# Config file for the codes_ui package
# Defines the following variables:
#
#  codes_ui_FEATURES       - list of enabled features
#  codes_ui_VERSION        - version of the package
#  codes_ui_GIT_SHA1       - Git revision of the package
#  codes_ui_GIT_SHA1_SHORT - short Git revision of the package
#


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was project-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

### computed paths
set_and_check(codes_ui_CMAKE_DIR "${PACKAGE_PREFIX_DIR}/lib/cmake/codes_ui")
set_and_check(codes_ui_BASE_DIR "${PACKAGE_PREFIX_DIR}/.")
if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(CODES_UI_CMAKE_DIR ${codes_ui_CMAKE_DIR})
  set(CODES_UI_BASE_DIR ${codes_ui_BASE_DIR})
endif()

### export version info
set(codes_ui_VERSION           "1.3.3")
set(codes_ui_GIT_SHA1          "")
set(codes_ui_GIT_SHA1_SHORT    "")

if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(CODES_UI_VERSION           "1.3.3" )
  set(CODES_UI_GIT_SHA1          "" )
  set(CODES_UI_GIT_SHA1_SHORT    "" )
endif()

### has this configuration been exported from a build tree?
set(codes_ui_IS_BUILD_DIR_EXPORT OFF)
if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(CODES_UI_IS_BUILD_DIR_EXPORT ${codes_ui_IS_BUILD_DIR_EXPORT})
endif()

### include the <project>-import.cmake file if there is one
if(EXISTS ${codes_ui_CMAKE_DIR}/codes_ui-import.cmake)
  set(codes_ui_IMPORT_FILE "${codes_ui_CMAKE_DIR}/codes_ui-import.cmake")
  include(${codes_ui_IMPORT_FILE})
endif()

### handle third-party dependencies
if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(CODES_UI_LIBRARIES         "CodesUi;FTimeUtil;Metview;MvQtGui;MvQtUtil")
  set(CODES_UI_TPLS              "eccodes" )

  include(${CMAKE_CURRENT_LIST_FILE}.tpls OPTIONAL)
endif()

### insert definitions for IMPORTED targets
if(NOT codes_ui_BINARY_DIR)
  find_file(codes_ui_TARGETS_FILE
    NAMES codes_ui-targets.cmake
    HINTS ${codes_ui_CMAKE_DIR}
    NO_DEFAULT_PATH)
  if(codes_ui_TARGETS_FILE)
    include(${codes_ui_TARGETS_FILE})
  endif()
endif()

### publish this file as imported
if( DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT )
  set(codes_ui_IMPORT_FILE ${CMAKE_CURRENT_LIST_FILE})
  mark_as_advanced(codes_ui_IMPORT_FILE)
  set(CODES_UI_IMPORT_FILE ${CMAKE_CURRENT_LIST_FILE})
  mark_as_advanced(CODES_UI_IMPORT_FILE)
endif()

### export features and check requirements
set(codes_ui_FEATURES "TESTS")
if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(CODES_UI_FEATURES ${codes_ui_FEATURES})
endif()
foreach(_f ${codes_ui_FEATURES})
  set(codes_ui_${_f}_FOUND 1)
  set(codes_ui_HAVE_${_f} 1)
  if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
    set(CODES_UI_HAVE_${_f} 1)
  endif()
endforeach()
check_required_components(codes_ui)
