# Config file for the codes_ui package
# Defines the following variables:
#
#  CODES_UI_INCLUDE_DIRS   - include directories
#  CODES_UI_DEFINITIONS    - preprocessor definitions
#  CODES_UI_LIBRARIES      - libraries to link against
#  CODES_UI_FEATURES       - list of enabled features
#  CODES_UI_VERSION        - version of the package
#  CODES_UI_GIT_SHA1       - Git revision of the package
#  CODES_UI_GIT_SHA1_SHORT - short Git revision of the package
#
# Also defines codes_ui third-party library dependencies:
#  CODES_UI_TPLS             - package names of  third-party library dependencies
#  CODES_UI_TPL_INCLUDE_DIRS - include directories
#  CODES_UI_TPL_DEFINITIONS  - preprocessor definitions
#  CODES_UI_TPL_LIBRARIES    - libraries to link against

### compute paths

get_filename_component(CODES_UI_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

set( CODES_UI_SELF_INCLUDE_DIRS "${CODES_UI_CMAKE_DIR}/../../../include" )
set( CODES_UI_SELF_DEFINITIONS  "" )
set( CODES_UI_SELF_LIBRARIES    "CodesUi;FTimeUtil;Metview;MvQtGui;MvQtUtil" )

set( CODES_UI_TPLS              "eccodes" )
set( CODES_UI_TPL_INCLUDE_DIRS  "C:/bld/codes-ui_1555156170098/_h_env/Library/include" )
set( CODES_UI_TPL_DEFINITIONS   "" )
set( CODES_UI_TPL_LIBRARIES     "eccodes" )

set( CODES_UI_VERSION           "1.2.3" )
set( CODES_UI_GIT_SHA1          "" )
set( CODES_UI_GIT_SHA1_SHORT    "" )

### export include paths as absolute paths

set( CODES_UI_INCLUDE_DIRS "" )
foreach( path ${CODES_UI_SELF_INCLUDE_DIRS} )
  get_filename_component( abspath ${path} ABSOLUTE )
  list( APPEND CODES_UI_INCLUDE_DIRS ${abspath} )
endforeach()
list( APPEND CODES_UI_INCLUDE_DIRS ${CODES_UI_TPL_INCLUDE_DIRS} )

### export definitions

set( CODES_UI_DEFINITIONS      ${CODES_UI_SELF_DEFINITIONS} ${CODES_UI_TPL_DEFINITIONS} )

### export list of all libraries

set( CODES_UI_LIBRARIES        ${CODES_UI_SELF_LIBRARIES}   ${CODES_UI_TPL_LIBRARIES}   )

### export the features provided by the package

set( CODES_UI_FEATURES    "TESTS" )
foreach( _f ${CODES_UI_FEATURES} )
  set( CODES_UI_HAVE_${_f} 1 )
endforeach()

# Has this configuration been exported from a build tree?
set( CODES_UI_IS_BUILD_DIR_EXPORT OFF )

if( EXISTS ${CODES_UI_CMAKE_DIR}/codes_ui-import.cmake )
  set( CODES_UI_IMPORT_FILE "${CODES_UI_CMAKE_DIR}/codes_ui-import.cmake" )
  include( ${CODES_UI_IMPORT_FILE} )
endif()

# here goes the imports of the TPL's

include( ${CMAKE_CURRENT_LIST_FILE}.tpls OPTIONAL )

# insert definitions for IMPORTED targets

if( NOT codes_ui_BINARY_DIR )

  if( CODES_UI_IS_BUILD_DIR_EXPORT )
    include( "C:/bld/codes-ui_1555156170098/work/codes_ui-targets.cmake" OPTIONAL )
  else()
    include( "${CODES_UI_CMAKE_DIR}/codes_ui-targets.cmake" OPTIONAL )
  endif()

endif()

# publish this file as imported

set( CODES_UI_IMPORT_FILE ${CMAKE_CURRENT_LIST_FILE} )
mark_as_advanced( CODES_UI_IMPORT_FILE )

# set codes_ui_BASE_DIR for final installations or build directories

if( NOT codes_ui )
  if( CODES_UI_IS_BUILD_DIR_EXPORT )
    set( codes_ui_BASE_DIR C:/bld/codes-ui_1555156170098/work )
  else()
    get_filename_component( abspath ${CMAKE_CURRENT_LIST_DIR}/../../.. ABSOLUTE )
    set( codes_ui_BASE_DIR ${abspath} )
  endif()
endif()
