#include <stan/lang/ast_def.cpp>

#include <gtest/gtest.h>
#include <test/unit/util.hpp>
#include <test/unit/lang/utility.hpp>
#include <sstream>
#include <string>
#include <iostream>

TEST(lang, local_function_args_ast) {
  std::string m1(
      "functions {\n"
      "  void f0(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] a6, "
      "vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    print(\"hi\");\n"
      "  }\n"
      "\n"
      "  int f1(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] a6, "
      "vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a1;\n"
      "  }\n"
      "\n"
      "  int[] f2(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] a6, "
      "vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a2;\n"
      "  }\n"
      "\n"
      "  int[,] f3(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a3;\n"
      "  }\n"
      "\n"
      "  real f4(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] a6, "
      "vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a4;\n"
      "  }\n"
      "\n"
      "  real[] f5(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a5;\n"
      "  }\n"
      "\n"
      "  real[,] f6(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a6;\n"
      "  }\n"
      "\n"
      "  vector f7(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a7;\n"
      "  }\n"
      "\n"
      "  vector[] f8(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a8;\n"
      "  }\n"
      "\n"
      "  vector[,] f9(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a9;\n"
      "  }\n"
      "\n"
      "  matrix f10(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a10;\n"
      "  }\n"
      "\n"
      "  matrix[] f11(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a11;\n"
      "  }\n"
      "\n"
      "  matrix[,] f12(int a1, int[] a2, int[,] a3, real a4, real[] a5, "
      "real[,] a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] "
      "a11, matrix[,] a12) {\n"
      "    return a12;\n"
      "  }\n"
      "}\n");
  stan::lang::program prog = model_to_ast("function_args", m1);
  EXPECT_EQ(13, prog.function_decl_defs_.size());
}

TEST(lang, local_function_args_hpp) {
  std::string m1(
      "functions {\n"
      "  void f0(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] a6, "
      "vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    print(\"hi\");\n"
      "  }\n"
      "\n"
      "  int f1(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] a6, "
      "vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a1;\n"
      "  }\n"
      "\n"
      "  int[] f2(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] a6, "
      "vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a2;\n"
      "  }\n"
      "\n"
      "  int[,] f3(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a3;\n"
      "  }\n"
      "\n"
      "  real f4(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] a6, "
      "vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a4;\n"
      "  }\n"
      "\n"
      "  real[] f5(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a5;\n"
      "  }\n"
      "\n"
      "  real[,] f6(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a6;\n"
      "  }\n"
      "\n"
      "  vector f7(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a7;\n"
      "  }\n"
      "\n"
      "  vector[] f8(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a8;\n"
      "  }\n"
      "\n"
      "  vector[,] f9(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a9;\n"
      "  }\n"
      "\n"
      "  matrix f10(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a10;\n"
      "  }\n"
      "\n"
      "  matrix[] f11(int a1, int[] a2, int[,] a3, real a4, real[] a5, real[,] "
      "a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] a11, "
      "matrix[,] a12) {\n"
      "    return a11;\n"
      "  }\n"
      "\n"
      "  matrix[,] f12(int a1, int[] a2, int[,] a3, real a4, real[] a5, "
      "real[,] a6, vector a7, vector[] a8, vector[,] a9, matrix a10, matrix[] "
      "a11, matrix[,] a12) {\n"
      "    return a12;\n"
      "  }\n"
      "}\n");
  std::string hpp = model_to_hpp("function_args", m1);

  std::string expected(
      "template <typename T3__, typename T4__, typename T5__, typename T6__, "
      "typename T7__, typename T8__, typename T9__, typename T10__, typename "
      "T11__>\n"
      "void\n"
      "f0(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) {\n"
      "    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type "
      "local_scalar_t__;\n"
      "    typedef local_scalar_t__ fun_return_scalar_t__;\n"
      "    const static bool propto__ = true;\n"
      "    (void) propto__;\n"
      "        local_scalar_t__ "
      "DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());\n"
      "        (void) DUMMY_VAR__;  // suppress unused var warning\n"
      "\n"
      "    int current_statement_begin__ = -1;\n"
      "    try {\n"
      "\n"
      "        current_statement_begin__ = 3;\n"
      "        if (pstream__) {\n"
      "            stan_print(pstream__,\"hi\");\n"
      "            *pstream__ << std::endl;\n"
      "        }\n"
      "    } catch (const std::exception& e) {\n"
      "        stan::lang::rethrow_located(e, current_statement_begin__, "
      "prog_reader__());\n"
      "        // Next line prevents compiler griping about no return\n"
      "        throw std::runtime_error(\"*** IF YOU SEE THIS, PLEASE REPORT A "
      "BUG ***\");\n"
      "    }\n"
      "}\n"
      "\n"
      "\n"
      "struct f0_functor__ {\n"
      "    template <typename T3__, typename T4__, typename T5__, typename "
      "T6__, typename T7__, typename T8__, typename T9__, typename T10__, "
      "typename T11__>\n"
      "        void\n"
      "    operator()(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) "
      "const {\n"
      "        return f0(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, "
      "pstream__);\n"
      "    }\n"
      "};\n"
      "\n"
      "template <typename T3__, typename T4__, typename T5__, typename T6__, "
      "typename T7__, typename T8__, typename T9__, typename T10__, typename "
      "T11__>\n"
      "int\n"
      "f1(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) {\n"
      "    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type "
      "local_scalar_t__;\n"
      "    typedef int fun_return_scalar_t__;\n"
      "    const static bool propto__ = true;\n"
      "    (void) propto__;\n"
      "        local_scalar_t__ "
      "DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());\n"
      "        (void) DUMMY_VAR__;  // suppress unused var warning\n"
      "\n"
      "    int current_statement_begin__ = -1;\n"
      "    try {\n"
      "\n"
      "        current_statement_begin__ = 7;\n"
      "        return stan::math::promote_scalar<fun_return_scalar_t__>(a1);\n"
      "    } catch (const std::exception& e) {\n"
      "        stan::lang::rethrow_located(e, current_statement_begin__, "
      "prog_reader__());\n"
      "        // Next line prevents compiler griping about no return\n"
      "        throw std::runtime_error(\"*** IF YOU SEE THIS, PLEASE REPORT A "
      "BUG ***\");\n"
      "    }\n"
      "}\n"
      "\n"
      "\n"
      "struct f1_functor__ {\n"
      "    template <typename T3__, typename T4__, typename T5__, typename "
      "T6__, typename T7__, typename T8__, typename T9__, typename T10__, "
      "typename T11__>\n"
      "        int\n"
      "    operator()(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) "
      "const {\n"
      "        return f1(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, "
      "pstream__);\n"
      "    }\n"
      "};\n"
      "\n"
      "template <typename T3__, typename T4__, typename T5__, typename T6__, "
      "typename T7__, typename T8__, typename T9__, typename T10__, typename "
      "T11__>\n"
      "std::vector<int>\n"
      "f2(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) {\n"
      "    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type "
      "local_scalar_t__;\n"
      "    typedef int fun_return_scalar_t__;\n"
      "    const static bool propto__ = true;\n"
      "    (void) propto__;\n"
      "        local_scalar_t__ "
      "DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());\n"
      "        (void) DUMMY_VAR__;  // suppress unused var warning\n"
      "\n"
      "    int current_statement_begin__ = -1;\n"
      "    try {\n"
      "\n"
      "        current_statement_begin__ = 11;\n"
      "        return stan::math::promote_scalar<fun_return_scalar_t__>(a2);\n"
      "    } catch (const std::exception& e) {\n"
      "        stan::lang::rethrow_located(e, current_statement_begin__, "
      "prog_reader__());\n"
      "        // Next line prevents compiler griping about no return\n"
      "        throw std::runtime_error(\"*** IF YOU SEE THIS, PLEASE REPORT A "
      "BUG ***\");\n"
      "    }\n"
      "}\n"
      "\n"
      "\n"
      "struct f2_functor__ {\n"
      "    template <typename T3__, typename T4__, typename T5__, typename "
      "T6__, typename T7__, typename T8__, typename T9__, typename T10__, "
      "typename T11__>\n"
      "        std::vector<int>\n"
      "    operator()(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) "
      "const {\n"
      "        return f2(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, "
      "pstream__);\n"
      "    }\n"
      "};\n"
      "\n"
      "template <typename T3__, typename T4__, typename T5__, typename T6__, "
      "typename T7__, typename T8__, typename T9__, typename T10__, typename "
      "T11__>\n"
      "std::vector<std::vector<int> >\n"
      "f3(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) {\n"
      "    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type "
      "local_scalar_t__;\n"
      "    typedef int fun_return_scalar_t__;\n"
      "    const static bool propto__ = true;\n"
      "    (void) propto__;\n"
      "        local_scalar_t__ "
      "DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());\n"
      "        (void) DUMMY_VAR__;  // suppress unused var warning\n"
      "\n"
      "    int current_statement_begin__ = -1;\n"
      "    try {\n"
      "\n"
      "        current_statement_begin__ = 15;\n"
      "        return stan::math::promote_scalar<fun_return_scalar_t__>(a3);\n"
      "    } catch (const std::exception& e) {\n"
      "        stan::lang::rethrow_located(e, current_statement_begin__, "
      "prog_reader__());\n"
      "        // Next line prevents compiler griping about no return\n"
      "        throw std::runtime_error(\"*** IF YOU SEE THIS, PLEASE REPORT A "
      "BUG ***\");\n"
      "    }\n"
      "}\n"
      "\n"
      "\n"
      "struct f3_functor__ {\n"
      "    template <typename T3__, typename T4__, typename T5__, typename "
      "T6__, typename T7__, typename T8__, typename T9__, typename T10__, "
      "typename T11__>\n"
      "        std::vector<std::vector<int> >\n"
      "    operator()(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) "
      "const {\n"
      "        return f3(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, "
      "pstream__);\n"
      "    }\n"
      "};\n"
      "\n"
      "template <typename T3__, typename T4__, typename T5__, typename T6__, "
      "typename T7__, typename T8__, typename T9__, typename T10__, typename "
      "T11__>\n"
      "typename boost::math::tools::promote_args<T3__, T4__, T5__, T6__, "
      "typename boost::math::tools::promote_args<T7__, T8__, T9__, T10__, "
      "typename boost::math::tools::promote_args<T11__>::type>::type>::type\n"
      "f4(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) {\n"
      "    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type "
      "local_scalar_t__;\n"
      "    typedef local_scalar_t__ fun_return_scalar_t__;\n"
      "    const static bool propto__ = true;\n"
      "    (void) propto__;\n"
      "        local_scalar_t__ "
      "DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());\n"
      "        (void) DUMMY_VAR__;  // suppress unused var warning\n"
      "\n"
      "    int current_statement_begin__ = -1;\n"
      "    try {\n"
      "\n"
      "        current_statement_begin__ = 19;\n"
      "        return stan::math::promote_scalar<fun_return_scalar_t__>(a4);\n"
      "    } catch (const std::exception& e) {\n"
      "        stan::lang::rethrow_located(e, current_statement_begin__, "
      "prog_reader__());\n"
      "        // Next line prevents compiler griping about no return\n"
      "        throw std::runtime_error(\"*** IF YOU SEE THIS, PLEASE REPORT A "
      "BUG ***\");\n"
      "    }\n"
      "}\n"
      "\n"
      "\n"
      "struct f4_functor__ {\n"
      "    template <typename T3__, typename T4__, typename T5__, typename "
      "T6__, typename T7__, typename T8__, typename T9__, typename T10__, "
      "typename T11__>\n"
      "        typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type\n"
      "    operator()(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) "
      "const {\n"
      "        return f4(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, "
      "pstream__);\n"
      "    }\n"
      "};\n"
      "\n"
      "template <typename T3__, typename T4__, typename T5__, typename T6__, "
      "typename T7__, typename T8__, typename T9__, typename T10__, typename "
      "T11__>\n"
      "std::vector<typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type>\n"
      "f5(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) {\n"
      "    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type "
      "local_scalar_t__;\n"
      "    typedef local_scalar_t__ fun_return_scalar_t__;\n"
      "    const static bool propto__ = true;\n"
      "    (void) propto__;\n"
      "        local_scalar_t__ "
      "DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());\n"
      "        (void) DUMMY_VAR__;  // suppress unused var warning\n"
      "\n"
      "    int current_statement_begin__ = -1;\n"
      "    try {\n"
      "\n"
      "        current_statement_begin__ = 23;\n"
      "        return stan::math::promote_scalar<fun_return_scalar_t__>(a5);\n"
      "    } catch (const std::exception& e) {\n"
      "        stan::lang::rethrow_located(e, current_statement_begin__, "
      "prog_reader__());\n"
      "        // Next line prevents compiler griping about no return\n"
      "        throw std::runtime_error(\"*** IF YOU SEE THIS, PLEASE REPORT A "
      "BUG ***\");\n"
      "    }\n"
      "}\n"
      "\n"
      "\n"
      "struct f5_functor__ {\n"
      "    template <typename T3__, typename T4__, typename T5__, typename "
      "T6__, typename T7__, typename T8__, typename T9__, typename T10__, "
      "typename T11__>\n"
      "        std::vector<typename boost::math::tools::promote_args<T3__, "
      "T4__, T5__, T6__, typename boost::math::tools::promote_args<T7__, T8__, "
      "T9__, T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type>\n"
      "    operator()(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) "
      "const {\n"
      "        return f5(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, "
      "pstream__);\n"
      "    }\n"
      "};\n"
      "\n"
      "template <typename T3__, typename T4__, typename T5__, typename T6__, "
      "typename T7__, typename T8__, typename T9__, typename T10__, typename "
      "T11__>\n"
      "std::vector<std::vector<typename boost::math::tools::promote_args<T3__, "
      "T4__, T5__, T6__, typename boost::math::tools::promote_args<T7__, T8__, "
      "T9__, T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type> >\n"
      "f6(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) {\n"
      "    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type "
      "local_scalar_t__;\n"
      "    typedef local_scalar_t__ fun_return_scalar_t__;\n"
      "    const static bool propto__ = true;\n"
      "    (void) propto__;\n"
      "        local_scalar_t__ "
      "DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());\n"
      "        (void) DUMMY_VAR__;  // suppress unused var warning\n"
      "\n"
      "    int current_statement_begin__ = -1;\n"
      "    try {\n"
      "\n"
      "        current_statement_begin__ = 27;\n"
      "        return stan::math::promote_scalar<fun_return_scalar_t__>(a6);\n"
      "    } catch (const std::exception& e) {\n"
      "        stan::lang::rethrow_located(e, current_statement_begin__, "
      "prog_reader__());\n"
      "        // Next line prevents compiler griping about no return\n"
      "        throw std::runtime_error(\"*** IF YOU SEE THIS, PLEASE REPORT A "
      "BUG ***\");\n"
      "    }\n"
      "}\n"
      "\n"
      "\n"
      "struct f6_functor__ {\n"
      "    template <typename T3__, typename T4__, typename T5__, typename "
      "T6__, typename T7__, typename T8__, typename T9__, typename T10__, "
      "typename T11__>\n"
      "        std::vector<std::vector<typename "
      "boost::math::tools::promote_args<T3__, T4__, T5__, T6__, typename "
      "boost::math::tools::promote_args<T7__, T8__, T9__, T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type> >\n"
      "    operator()(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) "
      "const {\n"
      "        return f6(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, "
      "pstream__);\n"
      "    }\n"
      "};\n"
      "\n"
      "template <typename T3__, typename T4__, typename T5__, typename T6__, "
      "typename T7__, typename T8__, typename T9__, typename T10__, typename "
      "T11__>\n"
      "Eigen::Matrix<typename boost::math::tools::promote_args<T3__, T4__, "
      "T5__, T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type, "
      "Eigen::Dynamic, 1>\n"
      "f7(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) {\n"
      "    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type "
      "local_scalar_t__;\n"
      "    typedef local_scalar_t__ fun_return_scalar_t__;\n"
      "    const static bool propto__ = true;\n"
      "    (void) propto__;\n"
      "        local_scalar_t__ "
      "DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());\n"
      "        (void) DUMMY_VAR__;  // suppress unused var warning\n"
      "\n"
      "    int current_statement_begin__ = -1;\n"
      "    try {\n"
      "\n"
      "        current_statement_begin__ = 31;\n"
      "        return stan::math::promote_scalar<fun_return_scalar_t__>(a7);\n"
      "    } catch (const std::exception& e) {\n"
      "        stan::lang::rethrow_located(e, current_statement_begin__, "
      "prog_reader__());\n"
      "        // Next line prevents compiler griping about no return\n"
      "        throw std::runtime_error(\"*** IF YOU SEE THIS, PLEASE REPORT A "
      "BUG ***\");\n"
      "    }\n"
      "}\n"
      "\n"
      "\n"
      "struct f7_functor__ {\n"
      "    template <typename T3__, typename T4__, typename T5__, typename "
      "T6__, typename T7__, typename T8__, typename T9__, typename T10__, "
      "typename T11__>\n"
      "        Eigen::Matrix<typename boost::math::tools::promote_args<T3__, "
      "T4__, T5__, T6__, typename boost::math::tools::promote_args<T7__, T8__, "
      "T9__, T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type, "
      "Eigen::Dynamic, 1>\n"
      "    operator()(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) "
      "const {\n"
      "        return f7(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, "
      "pstream__);\n"
      "    }\n"
      "};\n"
      "\n"
      "template <typename T3__, typename T4__, typename T5__, typename T6__, "
      "typename T7__, typename T8__, typename T9__, typename T10__, typename "
      "T11__>\n"
      "std::vector<Eigen::Matrix<typename "
      "boost::math::tools::promote_args<T3__, T4__, T5__, T6__, typename "
      "boost::math::tools::promote_args<T7__, T8__, T9__, T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type, "
      "Eigen::Dynamic, 1> >\n"
      "f8(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) {\n"
      "    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type "
      "local_scalar_t__;\n"
      "    typedef local_scalar_t__ fun_return_scalar_t__;\n"
      "    const static bool propto__ = true;\n"
      "    (void) propto__;\n"
      "        local_scalar_t__ "
      "DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());\n"
      "        (void) DUMMY_VAR__;  // suppress unused var warning\n"
      "\n"
      "    int current_statement_begin__ = -1;\n"
      "    try {\n"
      "\n"
      "        current_statement_begin__ = 35;\n"
      "        return stan::math::promote_scalar<fun_return_scalar_t__>(a8);\n"
      "    } catch (const std::exception& e) {\n"
      "        stan::lang::rethrow_located(e, current_statement_begin__, "
      "prog_reader__());\n"
      "        // Next line prevents compiler griping about no return\n"
      "        throw std::runtime_error(\"*** IF YOU SEE THIS, PLEASE REPORT A "
      "BUG ***\");\n"
      "    }\n"
      "}\n"
      "\n"
      "\n"
      "struct f8_functor__ {\n"
      "    template <typename T3__, typename T4__, typename T5__, typename "
      "T6__, typename T7__, typename T8__, typename T9__, typename T10__, "
      "typename T11__>\n"
      "        std::vector<Eigen::Matrix<typename "
      "boost::math::tools::promote_args<T3__, T4__, T5__, T6__, typename "
      "boost::math::tools::promote_args<T7__, T8__, T9__, T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type, "
      "Eigen::Dynamic, 1> >\n"
      "    operator()(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) "
      "const {\n"
      "        return f8(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, "
      "pstream__);\n"
      "    }\n"
      "};\n"
      "\n"
      "template <typename T3__, typename T4__, typename T5__, typename T6__, "
      "typename T7__, typename T8__, typename T9__, typename T10__, typename "
      "T11__>\n"
      "std::vector<std::vector<Eigen::Matrix<typename "
      "boost::math::tools::promote_args<T3__, T4__, T5__, T6__, typename "
      "boost::math::tools::promote_args<T7__, T8__, T9__, T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type, "
      "Eigen::Dynamic, 1> > >\n"
      "f9(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) {\n"
      "    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type "
      "local_scalar_t__;\n"
      "    typedef local_scalar_t__ fun_return_scalar_t__;\n"
      "    const static bool propto__ = true;\n"
      "    (void) propto__;\n"
      "        local_scalar_t__ "
      "DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());\n"
      "        (void) DUMMY_VAR__;  // suppress unused var warning\n"
      "\n"
      "    int current_statement_begin__ = -1;\n"
      "    try {\n"
      "\n"
      "        current_statement_begin__ = 39;\n"
      "        return stan::math::promote_scalar<fun_return_scalar_t__>(a9);\n"
      "    } catch (const std::exception& e) {\n"
      "        stan::lang::rethrow_located(e, current_statement_begin__, "
      "prog_reader__());\n"
      "        // Next line prevents compiler griping about no return\n"
      "        throw std::runtime_error(\"*** IF YOU SEE THIS, PLEASE REPORT A "
      "BUG ***\");\n"
      "    }\n"
      "}\n"
      "\n"
      "\n"
      "struct f9_functor__ {\n"
      "    template <typename T3__, typename T4__, typename T5__, typename "
      "T6__, typename T7__, typename T8__, typename T9__, typename T10__, "
      "typename T11__>\n"
      "        std::vector<std::vector<Eigen::Matrix<typename "
      "boost::math::tools::promote_args<T3__, T4__, T5__, T6__, typename "
      "boost::math::tools::promote_args<T7__, T8__, T9__, T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type, "
      "Eigen::Dynamic, 1> > >\n"
      "    operator()(const int& a1,\n"
      "       const std::vector<int>& a2,\n"
      "       const std::vector<std::vector<int> >& a3,\n"
      "       const T3__& a4,\n"
      "       const std::vector<T4__>& a5,\n"
      "       const std::vector<std::vector<T5__> >& a6,\n"
      "       const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "       const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& a8,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "       const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& a10,\n"
      "       const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "       const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) "
      "const {\n"
      "        return f9(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, "
      "pstream__);\n"
      "    }\n"
      "};\n"
      "\n"
      "template <typename T3__, typename T4__, typename T5__, typename T6__, "
      "typename T7__, typename T8__, typename T9__, typename T10__, typename "
      "T11__>\n"
      "Eigen::Matrix<typename boost::math::tools::promote_args<T3__, T4__, "
      "T5__, T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type, "
      "Eigen::Dynamic, Eigen::Dynamic>\n"
      "f10(const int& a1,\n"
      "        const std::vector<int>& a2,\n"
      "        const std::vector<std::vector<int> >& a3,\n"
      "        const T3__& a4,\n"
      "        const std::vector<T4__>& a5,\n"
      "        const std::vector<std::vector<T5__> >& a6,\n"
      "        const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "        const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& "
      "a8,\n"
      "        const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "        const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& "
      "a10,\n"
      "        const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "        const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) {\n"
      "    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type "
      "local_scalar_t__;\n"
      "    typedef local_scalar_t__ fun_return_scalar_t__;\n"
      "    const static bool propto__ = true;\n"
      "    (void) propto__;\n"
      "        local_scalar_t__ "
      "DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());\n"
      "        (void) DUMMY_VAR__;  // suppress unused var warning\n"
      "\n"
      "    int current_statement_begin__ = -1;\n"
      "    try {\n"
      "\n"
      "        current_statement_begin__ = 43;\n"
      "        return stan::math::promote_scalar<fun_return_scalar_t__>(a10);\n"
      "    } catch (const std::exception& e) {\n"
      "        stan::lang::rethrow_located(e, current_statement_begin__, "
      "prog_reader__());\n"
      "        // Next line prevents compiler griping about no return\n"
      "        throw std::runtime_error(\"*** IF YOU SEE THIS, PLEASE REPORT A "
      "BUG ***\");\n"
      "    }\n"
      "}\n"
      "\n"
      "\n"
      "struct f10_functor__ {\n"
      "    template <typename T3__, typename T4__, typename T5__, typename "
      "T6__, typename T7__, typename T8__, typename T9__, typename T10__, "
      "typename T11__>\n"
      "        Eigen::Matrix<typename boost::math::tools::promote_args<T3__, "
      "T4__, T5__, T6__, typename boost::math::tools::promote_args<T7__, T8__, "
      "T9__, T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type, "
      "Eigen::Dynamic, Eigen::Dynamic>\n"
      "    operator()(const int& a1,\n"
      "        const std::vector<int>& a2,\n"
      "        const std::vector<std::vector<int> >& a3,\n"
      "        const T3__& a4,\n"
      "        const std::vector<T4__>& a5,\n"
      "        const std::vector<std::vector<T5__> >& a6,\n"
      "        const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "        const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& "
      "a8,\n"
      "        const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "        const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& "
      "a10,\n"
      "        const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "        const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) "
      "const {\n"
      "        return f10(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, "
      "pstream__);\n"
      "    }\n"
      "};\n"
      "\n"
      "template <typename T3__, typename T4__, typename T5__, typename T6__, "
      "typename T7__, typename T8__, typename T9__, typename T10__, typename "
      "T11__>\n"
      "std::vector<Eigen::Matrix<typename "
      "boost::math::tools::promote_args<T3__, T4__, T5__, T6__, typename "
      "boost::math::tools::promote_args<T7__, T8__, T9__, T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type, "
      "Eigen::Dynamic, Eigen::Dynamic> >\n"
      "f11(const int& a1,\n"
      "        const std::vector<int>& a2,\n"
      "        const std::vector<std::vector<int> >& a3,\n"
      "        const T3__& a4,\n"
      "        const std::vector<T4__>& a5,\n"
      "        const std::vector<std::vector<T5__> >& a6,\n"
      "        const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "        const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& "
      "a8,\n"
      "        const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "        const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& "
      "a10,\n"
      "        const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "        const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) {\n"
      "    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type "
      "local_scalar_t__;\n"
      "    typedef local_scalar_t__ fun_return_scalar_t__;\n"
      "    const static bool propto__ = true;\n"
      "    (void) propto__;\n"
      "        local_scalar_t__ "
      "DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());\n"
      "        (void) DUMMY_VAR__;  // suppress unused var warning\n"
      "\n"
      "    int current_statement_begin__ = -1;\n"
      "    try {\n"
      "\n"
      "        current_statement_begin__ = 47;\n"
      "        return stan::math::promote_scalar<fun_return_scalar_t__>(a11);\n"
      "    } catch (const std::exception& e) {\n"
      "        stan::lang::rethrow_located(e, current_statement_begin__, "
      "prog_reader__());\n"
      "        // Next line prevents compiler griping about no return\n"
      "        throw std::runtime_error(\"*** IF YOU SEE THIS, PLEASE REPORT A "
      "BUG ***\");\n"
      "    }\n"
      "}\n"
      "\n"
      "\n"
      "struct f11_functor__ {\n"
      "    template <typename T3__, typename T4__, typename T5__, typename "
      "T6__, typename T7__, typename T8__, typename T9__, typename T10__, "
      "typename T11__>\n"
      "        std::vector<Eigen::Matrix<typename "
      "boost::math::tools::promote_args<T3__, T4__, T5__, T6__, typename "
      "boost::math::tools::promote_args<T7__, T8__, T9__, T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type, "
      "Eigen::Dynamic, Eigen::Dynamic> >\n"
      "    operator()(const int& a1,\n"
      "        const std::vector<int>& a2,\n"
      "        const std::vector<std::vector<int> >& a3,\n"
      "        const T3__& a4,\n"
      "        const std::vector<T4__>& a5,\n"
      "        const std::vector<std::vector<T5__> >& a6,\n"
      "        const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "        const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& "
      "a8,\n"
      "        const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "        const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& "
      "a10,\n"
      "        const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "        const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) "
      "const {\n"
      "        return f11(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, "
      "pstream__);\n"
      "    }\n"
      "};\n"
      "\n"
      "template <typename T3__, typename T4__, typename T5__, typename T6__, "
      "typename T7__, typename T8__, typename T9__, typename T10__, typename "
      "T11__>\n"
      "std::vector<std::vector<Eigen::Matrix<typename "
      "boost::math::tools::promote_args<T3__, T4__, T5__, T6__, typename "
      "boost::math::tools::promote_args<T7__, T8__, T9__, T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type, "
      "Eigen::Dynamic, Eigen::Dynamic> > >\n"
      "f12(const int& a1,\n"
      "        const std::vector<int>& a2,\n"
      "        const std::vector<std::vector<int> >& a3,\n"
      "        const T3__& a4,\n"
      "        const std::vector<T4__>& a5,\n"
      "        const std::vector<std::vector<T5__> >& a6,\n"
      "        const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "        const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& "
      "a8,\n"
      "        const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "        const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& "
      "a10,\n"
      "        const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "        const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) {\n"
      "    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, "
      "T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, "
      "T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type "
      "local_scalar_t__;\n"
      "    typedef local_scalar_t__ fun_return_scalar_t__;\n"
      "    const static bool propto__ = true;\n"
      "    (void) propto__;\n"
      "        local_scalar_t__ "
      "DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());\n"
      "        (void) DUMMY_VAR__;  // suppress unused var warning\n"
      "\n"
      "    int current_statement_begin__ = -1;\n"
      "    try {\n"
      "\n"
      "        current_statement_begin__ = 51;\n"
      "        return stan::math::promote_scalar<fun_return_scalar_t__>(a12);\n"
      "    } catch (const std::exception& e) {\n"
      "        stan::lang::rethrow_located(e, current_statement_begin__, "
      "prog_reader__());\n"
      "        // Next line prevents compiler griping about no return\n"
      "        throw std::runtime_error(\"*** IF YOU SEE THIS, PLEASE REPORT A "
      "BUG ***\");\n"
      "    }\n"
      "}\n"
      "\n"
      "\n"
      "struct f12_functor__ {\n"
      "    template <typename T3__, typename T4__, typename T5__, typename "
      "T6__, typename T7__, typename T8__, typename T9__, typename T10__, "
      "typename T11__>\n"
      "        std::vector<std::vector<Eigen::Matrix<typename "
      "boost::math::tools::promote_args<T3__, T4__, T5__, T6__, typename "
      "boost::math::tools::promote_args<T7__, T8__, T9__, T10__, typename "
      "boost::math::tools::promote_args<T11__>::type>::type>::type, "
      "Eigen::Dynamic, Eigen::Dynamic> > >\n"
      "    operator()(const int& a1,\n"
      "        const std::vector<int>& a2,\n"
      "        const std::vector<std::vector<int> >& a3,\n"
      "        const T3__& a4,\n"
      "        const std::vector<T4__>& a5,\n"
      "        const std::vector<std::vector<T5__> >& a6,\n"
      "        const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a7,\n"
      "        const std::vector<Eigen::Matrix<T7__, Eigen::Dynamic, 1> >& "
      "a8,\n"
      "        const std::vector<std::vector<Eigen::Matrix<T8__, "
      "Eigen::Dynamic, 1> > >& a9,\n"
      "        const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& "
      "a10,\n"
      "        const std::vector<Eigen::Matrix<T10__, Eigen::Dynamic, "
      "Eigen::Dynamic> >& a11,\n"
      "        const std::vector<std::vector<Eigen::Matrix<T11__, "
      "Eigen::Dynamic, Eigen::Dynamic> > >& a12, std::ostream* pstream__) "
      "const {\n"
      "        return f12(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, "
      "pstream__);\n"
      "    }\n"
      "};\n");
  EXPECT_EQ(1, count_matches(expected, hpp));
}
