#ifdef STAN_OPENCL
#include <stan/math/prim.hpp>
#include <stan/math/opencl/copy.hpp>
#include <stan/math/opencl/matrix_cl_view.hpp>
#include <stan/math/opencl/matrix_cl.hpp>
#include <stan/math/opencl/triangular_transpose.hpp>
#include <gtest/gtest.h>
#include <algorithm>

TEST(MathMatrixCL, triangular_transpose_m_exception_pass) {
  stan::math::matrix_cl<double> m1(1, 1);
  stan::math::matrix_cl<double> m0;
  stan::math::matrix_cl<double> m2(5, 3);
  stan::math::matrix_cl<double> m3(3, 4);

  EXPECT_NO_THROW(
      m0.triangular_transpose<stan::math::TriangularMapCL::LowerToUpper>());
  EXPECT_NO_THROW(
      m0.triangular_transpose<stan::math::TriangularMapCL::UpperToLower>());
  EXPECT_NO_THROW(
      m1.triangular_transpose<stan::math::TriangularMapCL::LowerToUpper>());
  EXPECT_NO_THROW(
      m1.triangular_transpose<stan::math::TriangularMapCL::UpperToLower>());
  EXPECT_THROW(
      m2.triangular_transpose<stan::math::TriangularMapCL::LowerToUpper>(),
      std::invalid_argument);
  EXPECT_THROW(
      m2.triangular_transpose<stan::math::TriangularMapCL::UpperToLower>(),
      std::invalid_argument);
  EXPECT_THROW(
      m3.triangular_transpose<stan::math::TriangularMapCL::LowerToUpper>(),
      std::invalid_argument);
  EXPECT_THROW(
      m3.triangular_transpose<stan::math::TriangularMapCL::UpperToLower>(),
      std::invalid_argument);
}

TEST(MathMatrixCL, triangular_transpose_m_pass) {
  stan::math::matrix_d m0(2, 2);
  m0 << 1, 2, 3, 4;
  stan::math::matrix_d m1(2, 2);
  m1 << 1, 2, 3, 4;
  stan::math::matrix_d m0_dst(2, 2);

  stan::math::matrix_cl<double> m00(m0);
  stan::math::matrix_cl<double> m11(m1);

  EXPECT_NO_THROW(
      m00.triangular_transpose<stan::math::TriangularMapCL::LowerToUpper>());
  EXPECT_NO_THROW(m0_dst = stan::math::from_matrix_cl(m00));
  EXPECT_EQ(1, m0_dst(0, 0));
  EXPECT_EQ(3, m0_dst(0, 1));
  EXPECT_EQ(3, m0_dst(1, 0));
  EXPECT_EQ(4, m0_dst(1, 1));

  EXPECT_NO_THROW(
      m11.triangular_transpose<stan::math::TriangularMapCL::UpperToLower>());
  EXPECT_NO_THROW(m0_dst = stan::math::from_matrix_cl(m11));
  EXPECT_EQ(1, m0_dst(0, 0));
  EXPECT_EQ(2, m0_dst(0, 1));
  EXPECT_EQ(2, m0_dst(1, 0));
  EXPECT_EQ(4, m0_dst(1, 1));
}

#endif
