from sqlalchemy import Table as TableBase
from sqlalchemy.sql.base import _bind_or_error

from . import ddl


class Table(TableBase):
    def drop(self, bind=None, checkfirst=False, if_exists=False):
        if bind is None:
            bind = _bind_or_error(self)
        bind._run_visitor(ddl.SchemaDropper,
                          self,
                          checkfirst=checkfirst, if_exists=if_exists)
