
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was chemfiles-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include("${CMAKE_CURRENT_LIST_DIR}/chemfiles-targets.cmake")
check_required_components("chemfiles")

get_target_property(IMPORTED_CONFIGURATIONS chemfiles IMPORTED_CONFIGURATIONS)

get_target_property(IMPORTED_SONAME chemfiles "IMPORTED_SONAME_${IMPORTED_CONFIGURATIONS}")
if (IMPORTED_SONAME)
    set_target_properties(chemfiles PROPERTIES IMPORTED_SONAME "${IMPORTED_SONAME}")
endif()
