
"""cheat

Usage:
  cheat <cheatsheet>
  cheat -e <cheatsheet>
  cheat -s <keyword>
  cheat -l
  cheat -d
  cheat -v

cheat allows you to create and view interactive cheatsheets on the
command-line. It was designed to help remind *nix system
administrators of options for commands that they use frequently,
but not frequently enough to remember.

Examples:
  To look up 'tar':
  cheat tar

  To create or edit the cheatsheet for 'foo':
  cheat -e foo

Options:
  -d --directories  List directories on CHEATPATH
  -e --edit         Edit cheatsheet
  -l --list         List cheatsheets
  -s --search       Search cheatsheets for <keyword>
  -v --version      Print the version number
"""

# require the dependencies
from cheat import sheets, sheet
from cheat.utils import colorize
from docopt import docopt


if __name__ == '__main__':
    # parse the command-line options
    options = docopt(__doc__, version='cheat 2.1.26')

    # list directories
    if options['--directories']:
        print("\n".join(sheets.paths()))

    # list cheatsheets
    elif options['--list']:
        print(sheets.list())

    # create/edit cheatsheet
    elif options['--edit']:
        sheet.create_or_edit(options['<cheatsheet>'])

    # search among the cheatsheets
    elif options['--search']:
        print(colorize(sheets.search(options['<keyword>'])))

    # print the cheatsheet
    else:
        print(colorize(sheet.read(options['<cheatsheet>'])))
