// Copyright (c) 2009  INRIA Sophia-Antipolis (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org).
//
// $URL: https://github.com/CGAL/cgal/blob/v5.3.1/Circular_kernel_3/include/CGAL/Circle_type.h $
// $Id: Circle_type.h 0779373 2020-03-26T13:31:46+01:00 Sébastien Loriot
// SPDX-License-Identifier: GPL-3.0-or-later OR LicenseRef-Commercial
//
// Author(s) : Monique Teillaud, Sylvain Pion, Pedro Machado,
//             Sebastien Loriot, Julien Hazebrouck, Damien Leroy

// Partially supported by the IST Programme of the EU as a Shared-cost
// RTD (FET Open) Project under Contract No  IST-2000-26473
// (ECG - Effective Computational Geometry for Curves and Surfaces)
// and a STREP (FET Open) Project under Contract No  IST-006413
// (ACS -- Algorithms for Complex Shapes)

#ifndef CGAL_CIRCLE_TYPE_H
#define CGAL_CIRCLE_TYPE_H

#include <CGAL/license/Circular_kernel_3.h>


namespace CGAL {
  enum Circle_type {NORMAL, THREADED, POLAR, BIPOLAR};
} //CGAL

#endif //CGAL_CIRCLE_TYPE_H
