"""
This module contains the error messages issued by the Cerberus Validator.
The test suite uses this module as well.
"""
ERROR_SCHEMA_MISSING = "validation schema missing"
ERROR_SCHEMA_FORMAT = "'{0}' is not a schema, must be a dict"
ERROR_SCHEMA_TYPE = "type of field '{0}' must be either 'list' or 'dict'"
ERROR_DOCUMENT_MISSING = "document is missing"
ERROR_DOCUMENT_FORMAT = "'{0}' is not a document, must be a dict"
ERROR_UNKNOWN_RULE = "unknown rule '{0}' for field '{0}'"
ERROR_DEFINITION_FORMAT = "schema definition for field '{0}' must be a dict"
ERROR_UNKNOWN_FIELD = "unknown field"
ERROR_REQUIRED_FIELD = "required field"
ERROR_UNKNOWN_TYPE = "unrecognized data-type '{0}'"
ERROR_BAD_TYPE = "must be of {0} type"
ERROR_MIN_LENGTH = "min length is {0}"
ERROR_MAX_LENGTH = "max length is {0}"
ERROR_UNALLOWED_VALUES = "unallowed values {0}"
ERROR_UNALLOWED_VALUE = "unallowed value {0}"
ERROR_ITEMS_LIST = "length of list should be {0}"
ERROR_READONLY_FIELD = "field is read-only"
ERROR_MAX_VALUE = "max value is {0}"
ERROR_MIN_VALUE = "min value is {0}"
ERROR_EMPTY_NOT_ALLOWED = "empty values not allowed"
ERROR_NOT_NULLABLE = "null value not allowed"
ERROR_REGEX = "value does not match regex '{0}'"
ERROR_DEPENDENCIES_FIELD = "field '{0}' is required"
ERROR_DEPENDENCIES_FIELD_VALUE = "field '{0}' is required with values: {0}"
ERROR_COERCION_FAILED = "field '{0}' could not be coerced"
