from __future__ import absolute_import, division, print_function
import iotbx.pdb
from mmtbx import hydrogens
from mmtbx import monomer_library
import mmtbx.restraints
from cctbx.array_family import flex
import time
from libtbx.utils import null_out

m1_str = """\
CRYST1    9.756    9.585    9.568  90.00  90.00  90.00 P 1
ATOM      1  N   SER H   7       4.184   4.600   6.227  1.00 10.00           N
ATOM      2  CA  SER H   7       4.535   3.950   4.970  1.00 10.00           C
ATOM      3  C   SER H   7       6.049   3.863   4.811  1.00 10.00           C
ATOM      4  O   SER H   7       6.790   4.650   5.400  1.00 10.00           O
ATOM      5  CB  SER H   7       3.931   4.713   3.791  1.00 10.00           C
ATOM      6  OG  SER H   7       4.412   6.045   3.745  1.00 10.00           O
ATOM      8  HA  SER H   7       4.176   3.049   4.965  1.00 10.00           H
ATOM      9  HB2 SER H   7       4.173   4.263   2.966  1.00 10.00           H
ATOM     10  HB3 SER H   7       2.966   4.730   3.887  1.00 10.00           H
ATOM     11  HG  SER H   7       4.200   6.456   4.459  1.00 10.00           H
"""

m2_str = """\
CRYST1    9.756    9.585    9.568  90.00  90.00  90.00 P 1
ATOM      1  N   SER H   7       4.184   4.600   6.227  1.00 10.00           N
ATOM      2  CA  SER H   7       4.535   3.950   4.970  1.00 10.00           C
ATOM      3  C   SER H   7       6.049   3.863   4.811  1.00 10.00           C
ATOM      4  O   SER H   7       6.790   4.650   5.400  1.00 10.00           O
ATOM      5  CB  SER H   7       3.931   4.713   3.791  1.00 10.00           C
ATOM      6  OG  SER H   7       4.412   6.045   3.745  1.00 10.00           O
ATOM      8  HA  SER H   7       4.176   3.049   4.965  1.00 10.00           H
ATOM      9  HB2 SER H   7       4.173   4.263   2.966  1.00 10.00           H
ATOM     10  HB3 SER H   7       2.966   4.730   3.887  1.00 10.00           H
ATOM     11  HG ASER H   7       4.200   6.456   4.459  0.50 10.00           H
ATOM     11  DG BSER H   7       4.200   6.456   4.459  0.50 10.00           D
"""

m3_str = """
CRYST1    9.756    9.585    9.568  90.00  90.00  90.00 P 1
ATOM      1  N   SER H   7       4.184   4.600   6.227  1.00 10.00           N
ATOM      2  CA  SER H   7       4.535   3.950   4.970  1.00 10.00           C
ATOM      3  C   SER H   7       6.049   3.863   4.811  1.00 10.00           C
ATOM      4  O   SER H   7       6.790   4.650   5.400  1.00 10.00           O
ATOM      5  CB  SER H   7       3.931   4.713   3.791  1.00 10.00           C
ATOM      6  OG ASER H   7       4.412   6.045   3.745  0.50 10.00           O
ATOM      6  OG BSER H   7       2.515   4.664   3.823  0.50 10.00           O
ATOM      0  HA  SER H   7       4.173   3.050   4.984  1.00 10.00           H
ATOM      0  HG ASER H   7       4.483   6.348   4.536  0.50 10.00           H
ATOM      0  HG BSER H   7       2.253   4.558   4.625  0.50 10.00           H
"""

m4_str = """
CRYST1    8.942    9.538    9.274  90.00  90.00  90.00 P 1
ATOM      1  N   THR H  21       6.000   3.103   5.518  1.00 10.00           N
ATOM      2  CA  THR H  21       5.114   4.258   5.439  1.00 10.00           C
ATOM      3  C   THR H  21       3.895   4.074   6.337  1.00 10.00           C
ATOM      4  O   THR H  21       3.236   3.035   6.301  1.00 10.00           O
ATOM      5  CB  THR H  21       4.646   4.511   3.992  1.00 10.00           C
ATOM      6  OG1 THR H  21       5.786   4.660   3.137  1.00 10.00           O
ATOM      7  CG2 THR H  21       3.792   5.769   3.916  1.00 10.00           C
ATOM      8  H1  THR H  21       6.394   2.977   4.730  1.00 10.00           H
ATOM      9  H2  THR H  21       6.620   3.247   6.140  1.00 10.00           H
ATOM     10  H3  THR H  21       5.527   2.380   5.733  1.00 10.00           H
ATOM      8 DG21 THR H  21       3.708   6.055   2.993  1.00 10.00           D
ATOM      9 DG22 THR H  21       2.906   5.595   4.272  1.00 10.00           D
ATOM     10 DG23 THR H  21       4.205   6.482   4.429  1.00 10.00           D
"""

m5_str = """
CRYST1   19.756   19.585   19.568  90.00  90.00  90.00 P 1
ATOM      1  N   SER H   1       7.561   4.409   2.370  1.00 10.00           N
ATOM      2  CA  SER H   1       6.281   4.192   3.051  1.00 10.00           C
ATOM      3  C   SER H   1       6.112   3.781   4.520  1.00 10.00           C
ATOM      4  O   SER H   1       6.620   2.744   4.947  1.00 10.00           O
ATOM      5  CB  SER H   1       5.067   3.972   2.131  1.00 10.00           C
ATOM      6  HA  SER H   1       6.473   3.250   2.923  1.00 10.00           H
ATOM      7  OG ASER H   1       3.884   3.774   2.885  0.50 10.00           O
ATOM      8  HG ASER H   1       3.729   4.456   3.369  0.50 10.00           H
ATOM      9  OG BSER H   1       5.247   2.836   1.302  0.50 10.00           O
ATOM     10  HG BSER H   1       5.189   2.125   1.764  0.50 10.00           H
ATOM     11  N   THR H   2       5.397   4.602   5.281  1.00 10.00           N
ATOM     12  CA  THR H   2       5.161   4.328   6.694  1.00 10.00           C
ATOM     13  C   THR H   2       3.963   3.404   6.887  1.00 10.00           C
ATOM     14  O   THR H   2       4.113   2.257   7.310  1.00 10.00           O
ATOM     15  CB  THR H   2       4.938   5.627   7.495  1.00 10.00           C
ATOM     16  OG1 THR H   2       4.686   5.308   8.869  1.00 10.00           O
ATOM     17  CG2 THR H   2       3.757   6.410   6.935  1.00 10.00           C
ATOM     18 DG21 THR H   2       3.891   6.587   5.991  1.00 10.00           D
ATOM     19 DG22 THR H   2       2.937   5.904   7.048  1.00 10.00           D
ATOM     20 DG23 THR H   2       3.670   7.255   7.403  1.00 10.00           D
"""

m6_str = """
CRYST1    4.870   17.281   23.045  90.00  90.00  90.00 P 21 21 21
ATOM      1  N   PHE A   1       2.305   1.496  17.812  1.00  1.22           N
ATOM      2  CA  PHE A   1       1.374   2.648  17.647  1.00  1.07           C
ATOM      3  C   PHE A   1       2.067   3.806  16.938  1.00  1.09           C
ATOM      4  O   PHE A   1       3.294   3.909  16.951  1.00  1.16           O
ATOM      5  CB  PHE A   1       0.850   3.108  19.009  1.00  1.41           C
ATOM      6  CG  PHE A   1       1.930   3.539  19.961  1.00  1.13           C
ATOM      7  CD1 PHE A   1       2.323   4.866  20.029  1.00  1.42           C
ATOM      8  CD2 PHE A   1       2.552   2.618  20.787  1.00  1.48           C
ATOM      9  CE1 PHE A   1       3.316   5.265  20.903  1.00  1.70           C
ATOM     10  CE2 PHE A   1       3.546   3.011  21.663  1.00  1.44           C
ATOM     11  CZ  PHE A   1       3.928   4.336  21.721  1.00  1.76           C
ATOM     12  H1  PHE A   1       2.118   1.070  18.571  1.00  1.40           H
ATOM     13  H2  PHE A   1       2.210   0.937  17.126  1.00  1.40           H
ATOM     14  H3  PHE A   1       3.143   1.794  17.838  1.00  1.40           H
ATOM     15  HA  PHE A   1       0.616   2.372  17.108  1.00  1.25           H
ATOM     16  HB2 PHE A   1       0.254   3.862  18.877  1.00  1.49           H
ATOM     17  HB3 PHE A   1       0.367   2.375  19.422  1.00  1.49           H
ATOM     18  HD1 PHE A   1       1.914   5.495  19.480  1.00  1.59           H
ATOM     19  HD2 PHE A   1       2.298   1.724  20.752  1.00  1.70           H
ATOM     20  HE1 PHE A   1       3.572   6.158  20.941  1.00  1.89           H
ATOM     21  HE2 PHE A   1       3.956   2.384  22.213  1.00  1.75           H
ATOM     22  HZ  PHE A   1       4.597   4.603  22.310  1.00  1.98           H
ATOM     23  N   PHE A   2      -0.321   5.485  15.641  1.00  1.12           N
ATOM     24  CA  PHE A   2       0.601   6.613  15.605  1.00  1.21           C
ATOM     25  C   PHE A   2      -0.083   7.886  16.091  1.00  1.63           C
ATOM     26  O   PHE A   2      -1.310   7.980  16.107  1.00  1.87           O
ATOM     27  CB  PHE A   2       1.137   6.817  14.186  1.00  1.37           C
ATOM     28  CG  PHE A   2       0.066   7.076  13.165  1.00  1.31           C
ATOM     29  CD1 PHE A   2      -0.313   8.371  12.851  1.00  1.43           C
ATOM     30  CD2 PHE A   2      -0.561   6.025  12.517  1.00  1.58           C
ATOM     31  CE1 PHE A   2      -1.297   8.612  11.912  1.00  1.85           C
ATOM     32  CE2 PHE A   2      -1.546   6.259  11.577  1.00  1.91           C
ATOM     33  CZ  PHE A   2      -1.914   7.555  11.274  1.00  1.83           C
ATOM     34  OXT PHE A   2       0.576   8.850  16.480  1.00  1.73           O
ATOM     35  H   PHE A   2       0.025   4.742  15.380  1.00  1.22           H
ATOM     36  HA  PHE A   2       1.353   6.430  16.190  1.00  1.44           H
ATOM     37  HB2 PHE A   2       1.738   7.579  14.186  1.00  1.52           H
ATOM     38  HB3 PHE A   2       1.618   6.019  13.916  1.00  1.52           H
ATOM     39  HD1 PHE A   2       0.100   9.087  13.278  1.00  1.62           H
ATOM     40  HD2 PHE A   2      -0.316   5.150  12.718  1.00  1.67           H
ATOM     41  HE1 PHE A   2      -1.544   9.485  11.709  1.00  2.06           H
ATOM     42  HE2 PHE A   2      -1.960   5.545  11.149  1.00  2.14           H
ATOM     43  HZ  PHE A   2      -2.577   7.715  10.642  1.00  2.02           H
"""

m7_str = """
CRYST1    4.870   17.281   23.045  90.00  90.00  90.00 P 21 21 21
ATOM     45  O   MOH B   1       4.618   8.936  19.345  1.00  1.81           O
ATOM     44  C   MOH B   1       5.441   7.889  19.813  1.00  2.23           C
ATOM     46  H1  MOH B   1       5.160   7.047  19.406  1.00  2.30           H
ATOM     47  H2  MOH B   1       6.369   8.073  19.573  1.00  2.30           H
ATOM     48  H3  MOH B   1       5.363   7.822  20.784  1.00  2.30           H
ATOM     49  HO  MOH B   1       4.367   9.444  20.029  1.00  2.16           H
"""

m8_str = """
CRYST1   59.186   87.431   46.405  90.00  90.00  90.00 P 21 21 2
ATOM   2815  N   ASP B  25      16.862 -16.381 -24.728  1.00 13.97           N
ATOM   2816  CA  ASP B  25      16.773 -16.667 -23.301  1.00 15.05           C
ATOM   2817  DA  ASP B  25      16.336 -15.824 -22.767  1.00 14.51           D
ATOM   2818  CB  ASP B  25      15.862 -17.877 -23.090  1.00 15.17           C
ATOM   2819  DB2 ASP B  25      14.945 -17.731 -23.662  1.00 14.33           D
ATOM   2820  CG  ASP B  25      15.482 -18.081 -21.642  1.00 14.41           C
ATOM   2821  OD2 ASP B  25      16.126 -17.476 -20.764  1.00 14.08           O
ATOM   2822  OD1 ASP B  25      14.530 -18.848 -21.383  1.00 15.02           O
ATOM   2823  C   ASP B  25      18.154 -16.938 -22.706  1.00 14.49           C
ATOM   2824  O   ASP B  25      18.682 -18.044 -22.810  1.00 14.50           O
ATOM   2828  HN BASP B  25      17.321 -17.116 -25.265  1.00 15.02           H
ATOM   2829  HB1BASP B  25      16.379 -18.773 -23.430  1.00 14.52           H
ATOM   2830  DD2BASP B  25      15.766 -17.709 -19.919  1.00 14.05           D
END
"""

m9_str = """
CRYST1   26.468   33.148   34.654  90.00  90.00  90.00 P 1
ATOM     99  N   THR C  12       9.083  21.642  26.327  1.00 20.97           N
ATOM    100  CA  THR C  12       9.725  22.948  26.407  1.00 21.31           C
ATOM    101  CB  THR C  12      11.241  22.810  26.634  1.00 20.73           C
ATOM    102  OG1 THR C  12      11.823  22.052  25.565  1.00 23.32           O
ATOM    103  CG2 THR C  12      11.523  22.114  27.957  1.00 21.87           C
ATOM    104  C   THR C  12       9.495  23.750  25.125  1.00 20.19           C
ATOM    105  O   THR C  12      10.403  23.870  24.304  1.00 21.54           O
ATOM      0  HA  THR C  12       9.361  23.440  27.158  1.00 21.31           H
ATOM      0  HB  THR C  12      11.645  23.691  26.660  1.00 20.73           H
ATOM      0  HG1 THR C  12      11.728  22.460  24.837  1.00 23.32           H
ATOM      0 HG21 THR C  12      12.480  22.046  28.098  1.00 21.87           H
ATOM      0 HG22 THR C  12      11.132  22.619  28.687  1.00 21.87           H
ATOM      0 HG23 THR C  12      11.141  21.222  27.951  1.00 21.87           H
TER
END
"""

m10_str = """
CRYST1   26.468   33.148   34.654  90.00  90.00  90.00 P 1
ATOM    106  N   ILE C  13       8.293  24.298  24.942  1.00 20.53           N
ATOM    107  CA  ILE C  13       7.196  24.182  25.901  1.00 21.71           C
ATOM    108  CB  ILE C  13       7.277  25.278  26.988  1.00 21.47           C
ATOM    109  CG1 ILE C  13       6.236  25.036  28.086  1.00 20.24           C
ATOM    110  CG2 ILE C  13       7.086  26.658  26.373  1.00 20.55           C
ATOM    111  CD1 ILE C  13       6.447  23.754  28.867  1.00 20.37           C
ATOM    112  C   ILE C  13       5.861  24.302  25.175  1.00 21.07           C
ATOM    113  O   ILE C  13       5.000  23.429  25.290  1.00 22.22           O
ATOM      0  H   ILE C  13       8.085  24.758  24.246  1.00 20.53           H
ATOM      0  HA  ILE C  13       7.213  23.314  26.329  1.00 21.71           H
ATOM      0  HB  ILE C  13       8.158  25.248  27.392  1.00 21.47           H
ATOM      0 HG12 ILE C  13       6.276  25.772  28.716  1.00 20.24           H
ATOM      0 HG13 ILE C  13       5.354  24.998  27.686  1.00 20.24           H
ATOM      0 HG21 ILE C  13       7.378  27.329  27.009  1.00 20.55           H
ATOM      0 HG22 ILE C  13       7.615  26.720  25.562  1.00 20.55           H
ATOM      0 HG23 ILE C  13       6.147  26.787  26.165  1.00 20.55           H
ATOM      0 HD11 ILE C  13       5.881  23.770  29.654  1.00 20.37           H
ATOM      0 HD12 ILE C  13       6.211  22.998  28.306  1.00 20.37           H
ATOM      0 HD13 ILE C  13       7.378  23.695  29.131  1.00 20.37           H
TER
END
"""

m11_str = """
CRYST1   26.468   33.148   34.654  90.00  90.00  90.00 P 1
ATOM     99  N   THR C  12       9.083  21.642  26.327  1.00 20.97           N
ATOM    100  CA  THR C  12       9.725  22.948  26.407  1.00 21.31           C
ATOM    101  CB  THR C  12      11.241  22.810  26.634  1.00 20.73           C
ATOM    102  OG1 THR C  12      11.823  22.052  25.565  1.00 23.32           O
ATOM    103  CG2 THR C  12      11.523  22.114  27.957  1.00 21.87           C
ATOM    104  C   THR C  12       9.495  23.750  25.125  1.00 20.19           C
ATOM    105  O   THR C  12      10.403  23.870  24.304  1.00 21.54           O
ATOM      0  HA  THR C  12       9.361  23.440  27.158  1.00 21.31           H
ATOM      0  HB  THR C  12      11.645  23.691  26.660  1.00 20.73           H
ATOM      0  HG1 THR C  12      11.728  22.460  24.837  1.00 23.32           H
ATOM      0 HG21 THR C  12      12.480  22.046  28.098  1.00 21.87           H
ATOM      0 HG22 THR C  12      11.132  22.619  28.687  1.00 21.87           H
ATOM      0 HG23 THR C  12      11.141  21.222  27.951  1.00 21.87           H
ATOM    106  N   ILE C  13       8.293  24.298  24.942  1.00 20.53           N
ATOM    107  CA  ILE C  13       7.196  24.182  25.901  1.00 21.71           C
ATOM    108  CB  ILE C  13       7.277  25.278  26.988  1.00 21.47           C
ATOM    109  CG1 ILE C  13       6.236  25.036  28.086  1.00 20.24           C
ATOM    110  CG2 ILE C  13       7.086  26.658  26.373  1.00 20.55           C
ATOM    111  CD1 ILE C  13       6.447  23.754  28.867  1.00 20.37           C
ATOM    112  C   ILE C  13       5.861  24.302  25.175  1.00 21.07           C
ATOM    113  O   ILE C  13       5.000  23.429  25.290  1.00 22.22           O
ATOM      0  H   ILE C  13       8.085  24.758  24.246  1.00 20.53           H
ATOM      0  HA  ILE C  13       7.213  23.314  26.329  1.00 21.71           H
ATOM      0  HB  ILE C  13       8.158  25.248  27.392  1.00 21.47           H
ATOM      0 HG12 ILE C  13       6.276  25.772  28.716  1.00 20.24           H
ATOM      0 HG13 ILE C  13       5.354  24.998  27.686  1.00 20.24           H
ATOM      0 HG21 ILE C  13       7.378  27.329  27.009  1.00 20.55           H
ATOM      0 HG22 ILE C  13       7.615  26.720  25.562  1.00 20.55           H
ATOM      0 HG23 ILE C  13       6.147  26.787  26.165  1.00 20.55           H
ATOM      0 HD11 ILE C  13       5.881  23.770  29.654  1.00 20.37           H
ATOM      0 HD12 ILE C  13       6.211  22.998  28.306  1.00 20.37           H
ATOM      0 HD13 ILE C  13       7.378  23.695  29.131  1.00 20.37           H
TER
END
"""

m12_str = """\
CRYST1    9.756    9.585    9.568  90.00  90.00  90.00 P 1
ATOM     10  HB3 SER H   7       2.966   4.730   3.887  1.00 10.00           H
ATOM      1  N   SER H   7       4.184   4.600   6.227  1.00 10.00           N
ATOM      6  OG  SER H   7       4.412   6.045   3.745  1.00 10.00           O
ATOM      3  C   SER H   7       6.049   3.863   4.811  1.00 10.00           C
ATOM      5  CB  SER H   7       3.931   4.713   3.791  1.00 10.00           C
ATOM      8  HA  SER H   7       4.176   3.049   4.965  1.00 10.00           H
ATOM      4  O   SER H   7       6.790   4.650   5.400  1.00 10.00           O
ATOM      9  HB2 SER H   7       4.173   4.263   2.966  1.00 10.00           H
ATOM      2  CA  SER H   7       4.535   3.950   4.970  1.00 10.00           C
ATOM     11  HG  SER H   7       4.200   6.456   4.459  1.00 10.00           H
"""

m13_str = """
CRYST1   19.756   19.585   19.568  90.00  90.00  90.00 P 1
ATOM      8  HG ASER H   7       3.729   4.456   3.369  0.50 10.00           H
ATOM      4  O   SER H   7       6.620   2.744   4.947  1.00 10.00           O
ATOM      5  CB  SER H   7       5.067   3.972   2.131  1.00 10.00           C
ATOM      6  HA  SER H   7       6.473   3.250   2.923  1.00 10.00           H
ATOM      2  CA  SER H   7       6.281   4.192   3.051  1.00 10.00           C
ATOM      7  OG ASER H   7       3.884   3.774   2.885  0.50 10.00           O
ATOM      1  N   SER H   7       7.561   4.409   2.370  1.00 10.00           N
ATOM      9  OG BSER H   7       5.247   2.836   1.302  0.50 10.00           O
ATOM     10  HG BSER H   7       5.189   2.125   1.764  0.50 10.00           H
ATOM      3  C   SER H   7       6.112   3.781   4.520  1.00 10.00           C
ATOM     19 DG22 THR H   8       2.937   5.904   7.048  1.00 10.00           D
ATOM     11  N   THR H   8       5.397   4.602   5.281  1.00 10.00           N
ATOM     16  OG1 THR H   8       4.686   5.308   8.869  1.00 10.00           O
ATOM     13  C   THR H   8       3.963   3.404   6.887  1.00 10.00           C
ATOM     15  CB  THR H   8       4.938   5.627   7.495  1.00 10.00           C
ATOM     17  CG2 THR H   8       3.757   6.410   6.935  1.00 10.00           C
ATOM     14  O   THR H   8       4.113   2.257   7.310  1.00 10.00           O
ATOM     18 DG21 THR H   8       3.891   6.587   5.991  1.00 10.00           D
ATOM     12  CA  THR H   8       5.161   4.328   6.694  1.00 10.00           C
ATOM     20 DG23 THR H   8       3.670   7.255   7.403  1.00 10.00           D
"""

m14_str = """
CRYST1   13.051   13.521   12.472  90.00  90.00  90.00 P 1
HETATM  875  C1  IPA A 117       5.585   5.769   5.650  1.00 56.50           C
HETATM  876  C2  IPA A 117       6.580   6.709   6.074  1.00 57.10           C
HETATM  877  C3  IPA A 117       5.961   7.904   6.698  1.00 57.31           C
HETATM  878  O2  IPA A 117       7.451   6.016   6.974  1.00 57.41           O
HETATM    0  HO2 IPA A 117       8.051   6.539   7.243  1.00 57.41           H
HETATM    0  H33 IPA A 117       5.379   8.340   6.056  1.00 57.31           H
HETATM    0  H32 IPA A 117       5.443   7.633   7.472  1.00 57.31           H
HETATM    0  H31 IPA A 117       6.656   8.521   6.975  1.00 57.31           H
HETATM    0  H2  IPA A 117       7.085   7.045   5.317  1.00 57.10           H
HETATM    0  H13 IPA A 117       5.064   5.482   6.416  1.00 56.50           H
HETATM    0  H12 IPA A 117       5.000   6.188   5.000  1.00 56.50           H
HETATM    0  H11 IPA A 117       6.017   5.000   5.247  1.00 56.50           H
TER
END
"""

m5_str_HD_rotated = """
CRYST1   19.756   19.585   19.568  90.00  90.00  90.00 P 1
ATOM      1  N   SER H   7       7.561   4.409   2.370  1.00 10.00           N
ATOM      2  CA  SER H   7       6.281   4.192   3.051  1.00 10.00           C
ATOM      3  C   SER H   7       6.112   3.781   4.520  1.00 10.00           C
ATOM      4  O   SER H   7       6.620   2.744   4.947  1.00 10.00           O
ATOM      5  CB  SER H   7       5.067   3.972   2.131  1.00 10.00           C
ATOM      6  HA  SER H   7       6.473   3.250   2.923  1.00 10.00           H
ATOM      7  OG ASER H   7       3.884   3.774   2.885  0.50 10.00           O
ATOM      8  HG ASER H   7       3.210   4.055   2.449  0.50 10.00           H
ATOM      9  OG BSER H   7       5.247   2.836   1.302  0.50 10.00           O
ATOM     10  HG BSER H   7       5.379   3.079   0.498  0.50 10.00           H
ATOM     11  N   THR H   8       5.397   4.602   5.281  1.00 10.00           N
ATOM     12  CA  THR H   8       5.161   4.328   6.694  1.00 10.00           C
ATOM     13  C   THR H   8       3.963   3.404   6.887  1.00 10.00           C
ATOM     14  O   THR H   8       4.113   2.257   7.310  1.00 10.00           O
ATOM     15  CB  THR H   8       4.938   5.627   7.495  1.00 10.00           C
ATOM     16  OG1 THR H   8       4.686   5.308   8.869  1.00 10.00           O
ATOM     17  CG2 THR H   8       3.757   6.410   6.935  1.00 10.00           C
ATOM     18 DG21 THR H   8       3.078   5.801   6.606  1.00 10.00           D
ATOM     19 DG22 THR H   8       3.370   6.971   7.626  1.00 10.00           D
ATOM     20 DG23 THR H   8       4.053   6.974   6.204  1.00 10.00           D
"""

exercise_02_str = """
CRYST1   26.468   33.148   34.654  90.00  90.00  90.00 P 1
ATOM      1  N   PRO A   1      14.232  25.725  10.396  1.00 20.59           N
ATOM      2  CA  PRO A   1      15.656  25.573  10.083  1.00 20.69           C
ATOM      3  CB  PRO A   1      15.798  26.331   8.761  1.00 22.63           C
ATOM      4  CG  PRO A   1      14.742  27.375   8.819  1.00 21.05           C
ATOM      5  CD  PRO A   1      13.588  26.749   9.553  1.00 21.65           C
ATOM      6  C   PRO A   1      16.549  26.194  11.163  1.00 20.54           C
ATOM      7  O   PRO A   1      16.890  27.370  11.033  1.00 20.15           O
ATOM      8  H2  PRO A   1      14.131  25.778  11.248  1.00 20.59           H   std
ATOM      9  H3  PRO A   1      13.995  24.943  10.127  1.00 20.59           H   std
ATOM     10  HA  PRO A   1      15.881  24.641   9.935  1.00 20.69           H   std
ATOM     11  HB2 PRO A   1      16.680  26.729   8.691  1.00 22.63           H   std
ATOM     12  HB3 PRO A   1      15.638  25.725   8.020  1.00 22.63           H   std
ATOM     13  HG2 PRO A   1      15.075  28.148   9.302  1.00 21.05           H   std
ATOM     14  HG3 PRO A   1      14.480  27.622   7.918  1.00 21.05           H   std
ATOM     15  HD2 PRO A   1      13.141  27.409  10.106  1.00 21.65           H   std
ATOM     16  HD3 PRO A   1      12.974  26.334   8.927  1.00 21.65           H   std
ATOM     17  N   CYS A   2      16.920  25.451  12.208  1.00 19.39           N
ATOM     18  CA  CYS A   2      16.531  24.056  12.415  1.00 18.94           C
ATOM     19  C   CYS A   2      16.244  23.839  13.900  1.00 20.59           C
ATOM     20  O   CYS A   2      16.957  24.403  14.730  1.00 19.50           O
ATOM     21  H   CYS A   2      17.421  25.751  12.839  1.00 19.39           H   std
ATOM     22  HA  CYS A   2      15.742  23.845  11.891  1.00 18.94           H   std
ATOM     23  CB  CYS A   2      17.623  23.101  11.929  1.00 20.00           C
ATOM     24  SG  CYS A   2      17.898  23.129  10.143  1.00 20.00           S
ATOM      0  HB2 CYS A   2      18.454  23.323  12.377  1.00 20.00           H   new
ATOM      0  HB3 CYS A   2      17.390  22.198  12.195  1.00 20.00           H   new
ATOM      0  HG  CYS A   2      18.769  22.353   9.860  1.00 20.00           H   new
ATOM     25  N   ILE A   3      15.232  23.049  14.280  1.00 18.74           N
ATOM     26  CA  ILE A   3      14.277  22.348  13.402  1.00 17.42           C
ATOM     27  CB  ILE A   3      13.316  23.325  12.664  1.00 18.24           C
ATOM     28  CG1 ILE A   3      12.907  24.472  13.592  1.00 18.08           C
ATOM     29  CG2 ILE A   3      12.088  22.576  12.161  1.00 17.65           C
ATOM     30  CD1 ILE A   3      11.879  25.414  12.996  1.00 18.72           C
ATOM     31  C   ILE A   3      14.903  21.352  12.416  1.00 17.75           C
ATOM     32  O   ILE A   3      15.097  21.655  11.238  1.00 17.97           O
ATOM     33  H   ILE A   3      15.069  22.892  15.110  1.00 18.74           H   std
ATOM     34  HA  ILE A   3      13.711  21.816  13.984  1.00 17.42           H   std
ATOM     35  HB  ILE A   3      13.760  23.703  11.889  1.00 18.24           H   std
ATOM     36 HG12 ILE A   3      12.530  24.098  14.404  1.00 18.08           H   std
ATOM     37 HG13 ILE A   3      13.693  24.998  13.807  1.00 18.08           H   std
ATOM     38 HG21 ILE A   3      11.575  23.159  11.581  1.00 17.65           H   std
ATOM     39 HG22 ILE A   3      12.374  21.792  11.666  1.00 17.65           H   std
ATOM     40 HG23 ILE A   3      11.550  22.307  12.922  1.00 17.65           H   std
ATOM     41 HD11 ILE A   3      11.824  26.210  13.548  1.00 18.72           H   std
ATOM     42 HD12 ILE A   3      12.153  25.653  12.097  1.00 18.72           H   std
ATOM     43 HD13 ILE A   3      11.018  24.969  12.971  1.00 18.72           H   std
ATOM     44  N   THR A   4      15.190  20.152  12.916  1.00 16.98           N
ATOM     45  CA  THR A   4      15.689  19.051  12.095  1.00 18.61           C
ATOM     46  CB  THR A   4      17.201  18.838  12.300  1.00 18.25           C
ATOM     47  OG1 THR A   4      17.928  19.919  11.704  1.00 18.31           O
ATOM     48  CG2 THR A   4      17.655  17.530  11.668  1.00 18.01           C
ATOM     49  C   THR A   4      14.963  17.756  12.477  1.00 17.76           C
ATOM     50  O   THR A   4      15.199  17.248  13.574  1.00 16.77           O
ATOM     51  H   THR A   4      15.101  19.947  13.746  1.00 16.98           H   std
ATOM     52  HA  THR A   4      15.554  19.265  11.159  1.00 18.61           H   std
ATOM     53  HB  THR A   4      17.396  18.804  13.250  1.00 18.25           H   std
ATOM     54  HG1 THR A   4      17.765  19.954  10.881  1.00 18.31           H   std
ATOM     55 HG21 THR A   4      18.614  17.550  11.524  1.00 18.01           H   std
ATOM     56 HG22 THR A   4      17.443  16.784  12.250  1.00 18.01           H   std
ATOM     57 HG23 THR A   4      17.214  17.403  10.814  1.00 18.01           H   std
ATOM     58  N   LEU A   5      14.092  17.196  11.629  1.00 16.14           N
ATOM     59  CA  LEU A   5      13.724  17.691  10.292  1.00 17.00           C
ATOM     60  CB  LEU A   5      12.978  19.035  10.373  1.00 16.17           C
ATOM     61  CG  LEU A   5      11.564  19.020  10.967  1.00 16.47           C
ATOM     62  CD1 LEU A   5      11.570  18.554  12.417  1.00 16.13           C
ATOM     63  CD2 LEU A   5      10.630  18.155  10.130  1.00 17.36           C
ATOM     64  C   LEU A   5      14.894  17.771   9.296  1.00 17.30           C
ATOM     65  O   LEU A   5      15.227  18.857   8.821  1.00 18.08           O
ATOM     66  H   LEU A   5      13.670  16.472  11.824  1.00 16.14           H   std
ATOM     67  HA  LEU A   5      13.089  17.062   9.915  1.00 17.00           H   std
ATOM     68  HB2 LEU A   5      13.493  19.660  10.907  1.00 16.17           H   std
ATOM     69  HB3 LEU A   5      12.893  19.384   9.472  1.00 16.17           H   std
ATOM     70  HG  LEU A   5      11.214  19.924  10.953  1.00 16.47           H   std
ATOM     71 HD11 LEU A   5      10.724  18.793  12.827  1.00 16.13           H   std
ATOM     72 HD12 LEU A   5      11.687  17.591  12.441  1.00 16.13           H   std
ATOM     73 HD13 LEU A   5      12.298  18.991  12.886  1.00 16.13           H   std
ATOM     74 HD21 LEU A   5       9.717  18.298  10.426  1.00 17.36           H   std
ATOM     75 HD22 LEU A   5      10.718  18.408   9.198  1.00 17.36           H   std
ATOM     76 HD23 LEU A   5      10.872  17.223  10.244  1.00 17.36           H   std
ATOM     77  N   TRP A   6      15.507  16.634   8.960  1.00 16.90           N
ATOM     78  CA  TRP A   6      15.125  15.315   9.469  1.00 17.53           C
ATOM     79  CB  TRP A   6      15.441  14.230   8.431  1.00 17.50           C
ATOM     80  CG  TRP A   6      16.901  14.093   8.068  1.00 18.12           C
ATOM     81  CD1 TRP A   6      17.948  14.834   8.543  1.00 18.89           C
ATOM     82  CD2 TRP A   6      17.467  13.151   7.147  1.00 18.05           C
ATOM     83  NE1 TRP A   6      19.125  14.411   7.976  1.00 18.60           N
ATOM     84  CE2 TRP A   6      18.857  13.379   7.115  1.00 20.37           C
ATOM     85  CE3 TRP A   6      16.932  12.136   6.347  1.00 19.14           C
ATOM     86  CZ2 TRP A   6      19.719  12.631   6.315  1.00 19.76           C
ATOM     87  CZ3 TRP A   6      17.789  11.395   5.553  1.00 18.94           C
ATOM     88  CH2 TRP A   6      19.167  11.646   5.544  1.00 18.61           C
ATOM     89  C   TRP A   6      15.823  14.992  10.787  1.00 18.02           C
ATOM     90  O   TRP A   6      15.469  14.030  11.469  1.00 17.00           O
ATOM     91  H   TRP A   6      16.169  16.606   8.412  1.00 16.90           H   std
ATOM     92  HA  TRP A   6      14.168  15.277   9.623  1.00 17.53           H   std
ATOM     93  HB2 TRP A   6      15.146  13.375   8.781  1.00 17.50           H   std
ATOM     94  HB3 TRP A   6      14.955  14.432   7.616  1.00 17.50           H   std
ATOM     95  HD1 TRP A   6      17.873  15.524   9.161  1.00 18.89           H   std
ATOM     96  HE1 TRP A   6      19.903  14.741   8.135  1.00 18.60           H   std
ATOM     97  HE3 TRP A   6      16.018  11.964   6.348  1.00 19.14           H   std
ATOM     98  HZ2 TRP A   6      20.634  12.795   6.307  1.00 19.76           H   std
ATOM     99  HZ3 TRP A   6      17.445  10.718   5.017  1.00 18.94           H   std
ATOM    100  HH2 TRP A   6      19.719  11.132   5.000  1.00 18.61           H   std
TER     101      TRP A   6
ATOM    102  N   LYS B   7      16.104  11.520  14.704  1.00 18.31           N
ATOM    103  CA  LYS B   7      16.294  11.108  16.089  1.00 18.17           C
ATOM    104  CB  LYS B   7      17.578  11.718  16.655  1.00 17.67           C
ATOM    105  CG  LYS B   7      18.833  11.386  15.859  1.00 19.54           C
ATOM    106  CD  LYS B   7      19.123   9.893  15.862  1.00 20.73           C
ATOM    107  CE  LYS B   7      20.411   9.576  15.119  1.00 22.48           C
ATOM    108  NZ  LYS B   7      20.711   8.117  15.116  1.00 24.00           N
ATOM    109  C   LYS B   7      15.100  11.526  16.941  1.00 16.04           C
ATOM    110  O   LYS B   7      15.263  11.950  18.085  1.00 16.51           O
ATOM    111  HA  LYS B   7      16.370  10.142  16.129  1.00 18.17           H   std
ATOM    112  HB2 LYS B   7      17.484  12.683  16.668  1.00 17.67           H   std
ATOM    113  HB3 LYS B   7      17.708  11.389  17.558  1.00 17.67           H   std
ATOM    114  HG2 LYS B   7      18.713  11.670  14.939  1.00 19.54           H   std
ATOM    115  HG3 LYS B   7      19.592  11.843  16.254  1.00 19.54           H   std
ATOM    116  HD2 LYS B   7      19.217   9.586  16.777  1.00 20.73           H   std
ATOM    117  HD3 LYS B   7      18.397   9.423  15.423  1.00 20.73           H   std
ATOM    118  HE2 LYS B   7      20.327   9.869  14.198  1.00 22.48           H   std
ATOM    119  HE3 LYS B   7      21.149  10.035  15.550  1.00 22.48           H   std
ATOM    120  HZ1 LYS B   7      21.469   7.964  14.676  1.00 24.00           H   std
ATOM    121  HZ2 LYS B   7      20.797   7.824  15.952  1.00 24.00           H   std
ATOM    122  HZ3 LYS B   7      20.050   7.672  14.720  1.00 24.00           H   std
ATOM    123  N   TYR B   8      13.905  11.402  16.370  1.00 16.27           N
ATOM    124  CA  TYR B   8      12.667  11.763  17.057  1.00 16.41           C
ATOM    125  C   TYR B   8      12.691  13.213  17.539  1.00 17.10           C
ATOM    126  O   TYR B   8      12.799  13.464  18.740  1.00 18.90           O
ATOM    127  CB  TYR B   8      12.416  10.823  18.239  1.00 20.00           C
ATOM    128  CG  TYR B   8      12.300   9.367  17.847  1.00 20.00           C
ATOM    129  CD1 TYR B   8      11.070   8.814  17.514  1.00 20.00           C
ATOM    130  CD2 TYR B   8      13.419   8.547  17.809  1.00 20.00           C
ATOM    131  CE1 TYR B   8      10.959   7.484  17.155  1.00 20.00           C
ATOM    132  CE2 TYR B   8      13.317   7.216  17.451  1.00 20.00           C
ATOM    133  CZ  TYR B   8      12.085   6.690  17.125  1.00 20.00           C
ATOM    134  OH  TYR B   8      11.979   5.365  16.768  1.00 20.00           O
ATOM    135  H   TYR B   8      13.782  11.106  15.572  1.00 16.27           H   std
ATOM    136  HA  TYR B   8      11.924  11.664  16.441  1.00 16.41           H   std
ATOM    137  HB2 TYR B   8      13.148  10.901  18.870  1.00 20.00           H   std
ATOM    138  HB3 TYR B   8      11.585  11.079  18.669  1.00 20.00           H   std
ATOM    139  HD1 TYR B   8      10.308   9.347  17.534  1.00 20.00           H   std
ATOM    140  HD2 TYR B   8      14.251   8.899  18.028  1.00 20.00           H   std
ATOM    141  HE1 TYR B   8      10.129   7.127  16.935  1.00 20.00           H   std
ATOM    142  HE2 TYR B   8      14.076   6.678  17.430  1.00 20.00           H   std
ATOM    143  HH  TYR B   8      12.735   5.000  16.791  1.00 20.00           H   std
ATOM    144  N   PRO B   9      12.608  14.170  16.597  1.00 16.48           N
ATOM    145  CA  PRO B   9      12.577  15.606  16.896  1.00 17.55           C
ATOM    146  CB  PRO B   9      12.059  16.223  15.593  1.00 16.00           C
ATOM    147  CG  PRO B   9      12.367  15.223  14.516  1.00 15.64           C
ATOM    148  CD  PRO B   9      12.758  13.918  15.153  1.00 16.47           C
ATOM    149  C   PRO B   9      11.635  15.961  18.044  1.00 18.40           C
ATOM    150  O   PRO B   9      10.513  15.458  18.098  1.00 17.31           O
ATOM    151  HA  PRO B   9      13.468  15.939  17.085  1.00 17.55           H   std
ATOM    152  HB2 PRO B   9      11.102  16.368  15.660  1.00 16.00           H   std
ATOM    153  HB3 PRO B   9      12.520  17.059  15.424  1.00 16.00           H   std
ATOM    154  HG2 PRO B   9      11.578  15.100  13.966  1.00 15.64           H   std
ATOM    155  HG3 PRO B   9      13.099  15.559  13.975  1.00 15.64           H   std
ATOM    156  HD2 PRO B   9      12.154  13.216  14.863  1.00 16.47           H   std
ATOM    157  HD3 PRO B   9      13.680  13.702  14.943  1.00 16.47           H   std
ATOM    158  N   LEU B  10      12.094  16.821  18.947  1.00 20.07           N
ATOM    159  CA  LEU B  10      11.289  17.237  20.089  1.00 19.87           C
ATOM    160  CB  LEU B  10      11.231  16.120  21.134  1.00 18.03           C
ATOM    161  CG  LEU B  10      10.403  16.407  22.389  1.00 20.45           C
ATOM    162  CD1 LEU B  10       8.948  16.673  22.031  1.00 19.06           C
ATOM    163  CD2 LEU B  10      10.511  15.252  23.373  1.00 20.13           C
ATOM    164  C   LEU B  10      11.859  18.506  20.713  1.00 19.53           C
ATOM    165  O   LEU B  10      12.918  18.479  21.340  1.00 21.35           O
ATOM    166  H   LEU B  10      12.875  17.180  18.921  1.00 20.07           H   std
ATOM    167  HA  LEU B  10      10.385  17.425  19.791  1.00 19.87           H   std
ATOM    168  HB2 LEU B  10      10.855  15.330  20.715  1.00 18.03           H   std
ATOM    169  HB3 LEU B  10      12.137  15.929  21.424  1.00 18.03           H   std
ATOM    170  HG  LEU B  10      10.752  17.200  22.824  1.00 20.45           H   std
ATOM    171 HD11 LEU B  10       8.432  16.749  22.849  1.00 19.06           H   std
ATOM    172 HD12 LEU B  10       8.892  17.500  21.528  1.00 19.06           H   std
ATOM    173 HD13 LEU B  10       8.614  15.935  21.497  1.00 19.06           H   std
ATOM    174 HD21 LEU B  10       9.980  15.456  24.159  1.00 20.13           H   std
ATOM    175 HD22 LEU B  10      10.180  14.445  22.950  1.00 20.13           H   std
ATOM    176 HD23 LEU B  10      11.441  15.137  23.623  1.00 20.13           H   std
ATOM    177  N   VAL B  11      11.150  19.617  20.535  1.00 20.16           N
ATOM    178  CA  VAL B  11      11.583  20.898  21.081  1.00 18.60           C
ATOM    179  CB  VAL B  11      10.740  22.063  20.522  1.00 19.39           C
ATOM    180  CG1 VAL B  11       9.284  21.932  20.952  1.00 18.61           C
ATOM    181  CG2 VAL B  11      10.853  22.120  19.005  1.00 19.71           C
ATOM    182  C   VAL B  11      11.486  20.900  22.603  1.00 19.78           C
ATOM    183  O   VAL B  11      12.498  20.808  23.299  1.00 20.36           O
ATOM    184  H   VAL B  11      10.410  19.654  20.098  1.00 20.16           H   std
ATOM    185  HA  VAL B  11      12.509  21.051  20.837  1.00 18.60           H   std
ATOM    186  HB  VAL B  11      11.083  22.898  20.878  1.00 19.39           H   std
ATOM    187 HG11 VAL B  11       8.747  22.553  20.435  1.00 18.61           H   std
ATOM    188 HG12 VAL B  11       8.984  21.024  20.791  1.00 18.61           H   std
ATOM    189 HG13 VAL B  11       9.210  22.140  21.897  1.00 18.61           H   std
ATOM    190 HG21 VAL B  11      10.356  22.887  18.681  1.00 19.71           H   std
ATOM    191 HG22 VAL B  11      11.788  22.204  18.762  1.00 19.71           H   std
ATOM    192 HG23 VAL B  11      10.485  21.305  18.630  1.00 19.71           H   std
TER     193      VAL B  11
ATOM    194  N   THR C  12       9.083  21.642  26.327  1.00 20.97           N
ATOM    195  CA  THR C  12       9.725  22.948  26.407  1.00 21.31           C
ATOM    196  CB  THR C  12      11.241  22.810  26.634  1.00 20.73           C
ATOM    197  OG1 THR C  12      11.823  22.052  25.565  1.00 23.32           O
ATOM    198  CG2 THR C  12      11.523  22.114  27.957  1.00 21.87           C
ATOM    199  C   THR C  12       9.495  23.750  25.125  1.00 20.19           C
ATOM    200  O   THR C  12      10.403  23.870  24.304  1.00 21.54           O
ATOM    201  HA  THR C  12       9.361  23.441  27.159  1.00 21.31           H   std
ATOM    202  HB  THR C  12      11.645  23.691  26.660  1.00 20.73           H   std
ATOM    203  HG1 THR C  12      11.728  22.460  24.837  1.00 23.32           H   std
ATOM    204 HG21 THR C  12      12.480  22.046  28.098  1.00 21.87           H   std
ATOM    205 HG22 THR C  12      11.132  22.619  28.687  1.00 21.87           H   std
ATOM    206 HG23 THR C  12      11.141  21.222  27.951  1.00 21.87           H   std
ATOM    207  N   ILE C  13       8.293  24.298  24.942  1.00 20.53           N
ATOM    208  CA  ILE C  13       7.196  24.182  25.901  1.00 21.71           C
ATOM    209  CB  ILE C  13       7.277  25.278  26.988  1.00 21.47           C
ATOM    210  CG1 ILE C  13       6.236  25.036  28.086  1.00 20.24           C
ATOM    211  CG2 ILE C  13       7.086  26.658  26.373  1.00 20.55           C
ATOM    212  CD1 ILE C  13       6.447  23.754  28.867  1.00 20.37           C
ATOM    213  C   ILE C  13       5.861  24.302  25.175  1.00 21.07           C
ATOM    214  O   ILE C  13       5.000  23.429  25.290  1.00 22.22           O
ATOM    215  H   ILE C  13       8.085  24.758  24.246  1.00 20.53           H   std
ATOM    216  HA  ILE C  13       7.213  23.312  26.330  1.00 21.71           H   std
ATOM    217  HB  ILE C  13       8.158  25.248  27.392  1.00 21.47           H   std
ATOM    218 HG12 ILE C  13       6.276  25.772  28.716  1.00 20.24           H   std
ATOM    219 HG13 ILE C  13       5.353  24.998  27.686  1.00 20.24           H   std
ATOM    220 HG21 ILE C  13       7.378  27.329  27.009  1.00 20.55           H   std
ATOM    221 HG22 ILE C  13       7.615  26.720  25.562  1.00 20.55           H   std
ATOM    222 HG23 ILE C  13       6.147  26.787  26.165  1.00 20.55           H   std
ATOM    223 HD11 ILE C  13       5.881  23.770  29.654  1.00 20.37           H   std
ATOM    224 HD12 ILE C  13       6.211  22.998  28.306  1.00 20.37           H   std
ATOM    225 HD13 ILE C  13       7.378  23.695  29.131  1.00 20.37           H   std
TER     226      ILE C  13
END
"""

m15_str="""
CRYST1   94.040   99.520  102.470  90.00  90.00  90.00 I 2 2 2       8
ATOM   1132  N   ARG A  74     -19.326 -37.600 -34.577  1.00 26.20           N
ATOM   1133  CA  ARG A  74     -18.130 -37.395 -33.759  1.00 25.89           C
ATOM   1134  C   ARG A  74     -18.042 -35.939 -33.320  1.00 24.08           C
ATOM   1135  O   ARG A  74     -17.750 -35.641 -32.160  1.00 23.39           O
ATOM   1136  CB  ARG A  74     -16.849 -37.735 -34.533  1.00 28.75           C
ATOM   1137  CG  ARG A  74     -16.608 -39.205 -34.790  1.00 33.03           C
ATOM   1138  CD  ARG A  74     -15.231 -39.442 -35.435  1.00 36.08           C
ATOM   1139  NE  ARG A  74     -14.118 -39.145 -34.528  1.00 37.90           N
ATOM   1140  CZ  ARG A  74     -13.275 -38.122 -34.667  1.00 38.74           C
ATOM   1141  NH1 ARG A  74     -13.430 -37.239 -35.652  1.00 38.21           N
ATOM   1142  NH2 ARG A  74     -12.270 -37.980 -33.806  1.00 38.01           N
ATOM   1143  D   ARG A  74     -19.235 -37.934 -35.490  0.81 26.33           D
ATOM   1144  HA  ARG A  74     -18.194 -38.026 -32.882  1.00 26.28           H
ATOM   1145  HB2 ARG A  74     -16.885 -37.231 -35.488  1.00 29.24           H
ATOM   1146  HB3 ARG A  74     -16.006 -37.351 -33.972  1.00 28.50           H
ATOM   1147  HG2 ARG A  74     -16.657 -39.745 -33.856  1.00 33.30           H
ATOM   1148  HG3 ARG A  74     -17.373 -39.565 -35.457  1.00 32.25           H
ATOM   1149  HD2 ARG A  74     -15.163 -40.473 -35.726  1.00 36.76           H
ATOM   1150  HD3 ARG A  74     -15.142 -38.814 -36.306  1.00 36.58           H
ATOM   1151  DE  ARG A  74     -13.981 -39.762 -33.774  0.24 37.60           D
ATOM   1152 DH11 ARG A  74     -14.186 -37.340 -36.302  0.17 38.08           D
ATOM   1153 DH12 ARG A  74     -12.793 -36.467 -35.747  1.00 36.47           D
ATOM   1154 DH21 ARG A  74     -11.634 -37.223 -33.911  0.05 38.56           D
ATOM   1155 DH22 ARG A  74     -12.148 -38.635 -33.057  0.77 39.36           D
END
"""

m16_str="""
CRYST1   94.040   99.520  102.470  90.00  90.00  90.00 I 2 2 2       8
ATOM   1110  N   ALA A  73     -21.444 -37.009 -36.391  1.00 28.60           N
ATOM   1111  CA  ALA A  73     -21.705 -37.562 -35.064  1.00 30.00           C
ATOM   1112  C   ALA A  73     -20.540 -37.326 -34.112  1.00 27.41           C
ATOM   1113  O   ALA A  73     -20.742 -36.891 -32.978  1.00 28.01           O
ATOM   1132  N   ARG A  74     -19.326 -37.600 -34.577  1.00 26.20           N
ATOM   1133  CA  ARG A  74     -18.130 -37.395 -33.759  1.00 25.89           C
ATOM   1134  C   ARG A  74     -18.042 -35.939 -33.320  1.00 24.08           C
ATOM   1135  O   ARG A  74     -17.750 -35.641 -32.160  1.00 23.39           O
ATOM   1136  CB  ARG A  74     -16.849 -37.735 -34.533  1.00 28.75           C
ATOM   1137  CG  ARG A  74     -16.608 -39.205 -34.790  1.00 33.03           C
ATOM   1138  CD  ARG A  74     -15.231 -39.442 -35.435  1.00 36.08           C
ATOM   1139  NE  ARG A  74     -14.118 -39.145 -34.528  1.00 37.90           N
ATOM   1140  CZ  ARG A  74     -13.275 -38.122 -34.667  1.00 38.74           C
ATOM   1141  NH1 ARG A  74     -13.430 -37.239 -35.652  1.00 38.21           N
ATOM   1142  NH2 ARG A  74     -12.270 -37.980 -33.806  1.00 38.01           N
ATOM   1143  D   ARG A  74     -19.235 -37.934 -35.490  0.81 26.33           D
ATOM   1144  HA  ARG A  74     -18.194 -38.026 -32.882  1.00 26.28           H
ATOM   1145  HB2 ARG A  74     -16.885 -37.231 -35.488  1.00 29.24           H
ATOM   1146  HB3 ARG A  74     -16.006 -37.351 -33.972  1.00 28.50           H
ATOM   1147  HG2 ARG A  74     -16.657 -39.745 -33.856  1.00 33.30           H
ATOM   1148  HG3 ARG A  74     -17.373 -39.565 -35.457  1.00 32.25           H
ATOM   1149  HD2 ARG A  74     -15.163 -40.473 -35.726  1.00 36.76           H
ATOM   1150  HD3 ARG A  74     -15.142 -38.814 -36.306  1.00 36.58           H
ATOM   1151  DE  ARG A  74     -13.981 -39.762 -33.774  0.24 37.60           D
ATOM   1152 DH11 ARG A  74     -14.186 -37.340 -36.302  0.17 38.08           D
ATOM   1153 DH12 ARG A  74     -12.793 -36.467 -35.747  1.00 36.47           D
ATOM   1154 DH21 ARG A  74     -11.634 -37.223 -33.911  0.05 38.56           D
ATOM   1155 DH22 ARG A  74     -12.148 -38.635 -33.057  0.77 39.36           D
ATOM   1156  N   PHE A  75     -18.266 -35.038 -34.269  1.00 21.63           N
ATOM   1157  CA  PHE A  75     -18.198 -33.602 -34.011  1.00 21.44           C
ATOM   1158  C   PHE A  75     -19.269 -33.200 -32.988  1.00 22.63           C
ATOM   1159  O   PHE A  75     -18.978 -32.496 -32.021  1.00 21.77           O
END
"""

m17_str="""
CRYST1   94.040   99.520  102.470  90.00  90.00  90.00 I 2 2 2       8
ATOM   1132  N   ARG A  74     -19.326 -37.600 -34.577  1.00 26.20           N
ATOM   1133  CA  ARG A  74     -18.130 -37.395 -33.759  1.00 25.89           C
ATOM   1134  C   ARG A  74     -18.042 -35.939 -33.320  1.00 24.08           C
ATOM   1135  O   ARG A  74     -17.750 -35.641 -32.160  1.00 23.39           O
ATOM   1136  CB  ARG A  74     -16.849 -37.735 -34.533  1.00 28.75           C
ATOM   1137  CG  ARG A  74     -16.608 -39.205 -34.790  1.00 33.03           C
ATOM   1138  CD  ARG A  74     -15.231 -39.442 -35.435  1.00 36.08           C
ATOM   1139  NE  ARG A  74     -14.118 -39.145 -34.528  1.00 37.90           N
ATOM   1140  CZ  ARG A  74     -13.275 -38.122 -34.667  1.00 38.74           C
ATOM   1141  NH1 ARG A  74     -13.430 -37.239 -35.652  1.00 38.21           N
ATOM   1142  NH2 ARG A  74     -12.270 -37.980 -33.806  1.00 38.01           N
ATOM   1143  D   ARG A  74     -19.235 -37.934 -35.490  0.81 26.33           D
ATOM   1144  HA  ARG A  74     -18.194 -38.026 -32.882  1.00 26.28           H
ATOM   1145  HB2 ARG A  74     -16.885 -37.231 -35.488  1.00 29.24           H
ATOM   1146  HB3 ARG A  74     -16.006 -37.351 -33.972  1.00 28.50           H
ATOM   1147  HG2 ARG A  74     -16.657 -39.745 -33.856  1.00 33.30           H
ATOM   1148  HG3 ARG A  74     -17.373 -39.565 -35.457  1.00 32.25           H
ATOM   1149  HD2 ARG A  74     -15.163 -40.473 -35.726  1.00 36.76           H
ATOM   1150  HD3 ARG A  74     -15.142 -38.814 -36.306  1.00 36.58           H
ATOM   1151  DE  ARG A  74     -13.981 -39.762 -33.774  0.24 37.60           D
ATOM   1152 DH11 ARG A  74     -14.186 -37.340 -36.302  0.17 38.08           D
ATOM   1153 DH12 ARG A  74     -12.793 -36.467 -35.747  1.00 36.47           D
ATOM   1154 DH21 ARG A  74     -11.634 -37.223 -33.911  0.05 38.56           D
ATOM   1155 DH22 ARG A  74     -12.148 -38.635 -33.057  0.77 39.36           D
ATOM   1156  N   ALA A  75     -18.266 -35.038 -34.269  1.00 21.63           N
ATOM   1157  CA  ALA A  75     -18.198 -33.602 -34.011  1.00 21.44           C
ATOM   1158  C   ALA A  75     -19.269 -33.200 -32.988  1.00 22.63           C
ATOM   1159  O   ALA A  75     -18.978 -32.496 -32.021  1.00 21.77           O
END
"""

m18_str="""
CRYST1   94.040   99.520  102.470  90.00  90.00  90.00 I 2 2 2       8
ATOM   1110  N   LYS A  73     -21.444 -37.009 -36.391  1.00 28.60           N
ATOM   1111  CA  LYS A  73     -21.705 -37.562 -35.064  1.00 30.00           C
ATOM   1112  C   LYS A  73     -20.540 -37.326 -34.112  1.00 27.41           C
ATOM   1113  O   LYS A  73     -20.742 -36.891 -32.978  1.00 28.01           O
ATOM   1132  N   ARG A  74     -19.326 -37.600 -34.577  1.00 26.20           N
ATOM   1133  CA  ARG A  74     -18.130 -37.395 -33.759  1.00 25.89           C
ATOM   1134  C   ARG A  74     -18.042 -35.939 -33.320  1.00 24.08           C
ATOM   1135  O   ARG A  74     -17.750 -35.641 -32.160  1.00 23.39           O
ATOM   1136  CB  ARG A  74     -16.849 -37.735 -34.533  1.00 28.75           C
ATOM   1137  CG  ARG A  74     -16.608 -39.205 -34.790  1.00 33.03           C
ATOM   1138  CD  ARG A  74     -15.231 -39.442 -35.435  1.00 36.08           C
ATOM   1139  NE  ARG A  74     -14.118 -39.145 -34.528  1.00 37.90           N
ATOM   1140  CZ  ARG A  74     -13.275 -38.122 -34.667  1.00 38.74           C
ATOM   1141  NH1 ARG A  74     -13.430 -37.239 -35.652  1.00 38.21           N
ATOM   1142  NH2 ARG A  74     -12.270 -37.980 -33.806  1.00 38.01           N
ATOM   1143  D   ARG A  74     -19.235 -37.934 -35.490  0.81 26.33           D
ATOM   1144  HA  ARG A  74     -18.194 -38.026 -32.882  1.00 26.28           H
ATOM   1145  HB2 ARG A  74     -16.885 -37.231 -35.488  1.00 29.24           H
ATOM   1146  HB3 ARG A  74     -16.006 -37.351 -33.972  1.00 28.50           H
ATOM   1147  HG2 ARG A  74     -16.657 -39.745 -33.856  1.00 33.30           H
ATOM   1148  HG3 ARG A  74     -17.373 -39.565 -35.457  1.00 32.25           H
ATOM   1149  HD2 ARG A  74     -15.163 -40.473 -35.726  1.00 36.76           H
ATOM   1150  HD3 ARG A  74     -15.142 -38.814 -36.306  1.00 36.58           H
ATOM   1151  DE  ARG A  74     -13.981 -39.762 -33.774  0.24 37.60           D
ATOM   1152 DH11 ARG A  74     -14.186 -37.340 -36.302  0.17 38.08           D
ATOM   1153 DH12 ARG A  74     -12.793 -36.467 -35.747  1.00 36.47           D
ATOM   1154 DH21 ARG A  74     -11.634 -37.223 -33.911  0.05 38.56           D
ATOM   1155 DH22 ARG A  74     -12.148 -38.635 -33.057  0.77 39.36           D
END
"""

m19_str = """
CRYST1   14.387   16.193   14.476  90.00  90.00  90.00 P 1
HETATM    1  N   FME A   1     236.245 307.364 304.398  1.00 42.67           N
HETATM    2  CA  FME A   1     237.012 307.961 305.455  1.00 42.67           C
HETATM    3  C   FME A   1     237.071 307.161 306.754  1.00 42.67           C
HETATM    4  O   FME A   1     238.089 307.116 307.330  1.00 42.67           O
HETATM    5  CB  FME A   1     236.594 309.395 305.815  1.00 42.67           C
HETATM    6  CG  FME A   1     237.522 310.450 305.284  1.00 42.67           C
HETATM    7  SD  FME A   1     239.193 310.361 305.969  1.00 42.67           S
HETATM    8  CE  FME A   1     238.948 310.824 307.683  1.00 42.67           C
HETATM    9  CN  FME A   1     236.279 306.173 303.908  1.00 42.67           C
HETATM   10  O1  FME A   1     237.287 305.523 303.668  1.00 42.67           O
HETATM   12  HA  FME A   1     237.923 308.003 305.126  1.00 42.67           H
HETATM   13  HB2 FME A   1     236.551 309.472 306.781  1.00 42.67           H
HETATM   14  HB3 FME A   1     235.701 309.568 305.477  1.00 42.67           H
HETATM   15  HG2 FME A   1     237.152 311.325 305.482  1.00 42.67           H
HETATM   16  HG3 FME A   1     237.577 310.366 304.319  1.00 42.67           H
HETATM   17  HE1 FME A   1     239.802 310.814 308.144  1.00 42.67           H
HETATM   18  HE2 FME A   1     238.347 310.194 308.111  1.00 42.67           H
HETATM   19  HE3 FME A   1     238.570 311.716 307.725  1.00 42.67           H
HETATM   20  HCN FME A   1     235.415 305.803 303.669  1.00 42.67           H
END
"""

all_aa_all_h = """
ATOM      1  N   GLY A   1      -5.398  -1.491 -11.512  1.00  0.00           N
ATOM      2  CA  GLY A   1      -4.707  -0.522 -12.342  1.00  0.00           C
ATOM      3  C   GLY A   1      -4.028  -1.140 -13.548  1.00  0.00           C
ATOM      4  O   GLY A   1      -4.570  -1.108 -14.652  1.00  0.00           O
ATOM      5  H1  GLY A   1      -6.275  -1.348 -11.557  1.00  0.00           H
ATOM      6  H2  GLY A   1      -5.216  -2.313 -11.801  1.00  0.00           H
ATOM      7  H3  GLY A   1      -5.126  -1.407 -10.669  1.00  0.00           H
ATOM      8  HA2 GLY A   1      -5.353   0.124 -12.667  1.00  0.00           H
ATOM      9  HA3 GLY A   1      -4.053  -0.043 -11.812  1.00  0.00           H
ATOM     10  N   PRO A   2      -2.833  -1.701 -13.342  1.00  0.00           N
ATOM     11  CA  PRO A   2      -2.123  -2.328 -14.468  1.00  0.00           C
ATOM     12  C   PRO A   2      -2.829  -3.557 -15.012  1.00  0.00           C
ATOM     13  O   PRO A   2      -2.735  -3.826 -16.216  1.00  0.00           O
ATOM     14  CB  PRO A   2      -0.752  -2.683 -13.871  1.00  0.00           C
ATOM     15  CG  PRO A   2      -0.641  -1.867 -12.615  1.00  0.00           C
ATOM     16  CD  PRO A   2      -2.037  -1.721 -12.104  1.00  0.00           C
ATOM     17  HA  PRO A   2      -2.001  -1.687 -15.185  1.00  0.00           H
ATOM     18  HB2 PRO A   2      -0.721  -3.631 -13.667  1.00  0.00           H
ATOM     19  HB3 PRO A   2      -0.051  -2.444 -14.498  1.00  0.00           H
ATOM     20  HG2 PRO A   2      -0.089  -2.336 -11.970  1.00  0.00           H
ATOM     21  HG3 PRO A   2      -0.261  -0.999 -12.823  1.00  0.00           H
ATOM     22  HD2 PRO A   2      -2.280  -2.483 -11.555  1.00  0.00           H
ATOM     23  HD3 PRO A   2      -2.122  -0.887 -11.617  1.00  0.00           H
ATOM     24  N   ALA A   3      -3.531  -4.309 -14.168  1.00  0.00           N
ATOM     25  CA  ALA A   3      -4.240  -5.508 -14.591  1.00  0.00           C
ATOM     26  C   ALA A   3      -5.691  -5.236 -14.967  1.00  0.00           C
ATOM     27  O   ALA A   3      -6.458  -6.186 -15.156  1.00  0.00           O
ATOM     28  CB  ALA A   3      -4.179  -6.571 -13.492  1.00  0.00           C
ATOM     29  H   ALA A   3      -3.612  -4.140 -13.329  1.00  0.00           H
ATOM     30  HA  ALA A   3      -3.797  -5.871 -15.374  1.00  0.00           H
ATOM     31  HB1 ALA A   3      -4.654  -7.362 -13.791  1.00  0.00           H
ATOM     32  HB2 ALA A   3      -3.250  -6.789 -13.316  1.00  0.00           H
ATOM     33  HB3 ALA A   3      -4.594  -6.219 -12.689  1.00  0.00           H
ATOM     34  N   VAL A   4      -6.084  -3.970 -15.080  1.00  0.00           N
ATOM     35  CA  VAL A   4      -7.445  -3.598 -15.431  1.00  0.00           C
ATOM     36  C   VAL A   4      -7.517  -2.959 -16.812  1.00  0.00           C
ATOM     37  O   VAL A   4      -8.399  -3.291 -17.606  1.00  0.00           O
ATOM     38  CB  VAL A   4      -8.051  -2.664 -14.360  1.00  0.00           C
ATOM     39  CG1 VAL A   4      -9.502  -2.346 -14.689  1.00  0.00           C
ATOM     40  CG2 VAL A   4      -7.936  -3.293 -12.980  1.00  0.00           C
ATOM     41  H   VAL A   4      -5.567  -3.295 -14.955  1.00  0.00           H
ATOM     42  HA  VAL A   4      -7.990  -4.400 -15.455  1.00  0.00           H
ATOM     43  HB  VAL A   4      -7.556  -1.830 -14.352  1.00  0.00           H
ATOM     44 HG11 VAL A   4      -9.909  -1.910 -13.924  1.00  0.00           H
ATOM     45 HG12 VAL A   4      -9.532  -1.757 -15.459  1.00  0.00           H
ATOM     46 HG13 VAL A   4      -9.969  -3.173 -14.885  1.00  0.00           H
ATOM     47 HG21 VAL A   4      -8.407  -2.737 -12.340  1.00  0.00           H
ATOM     48 HG22 VAL A   4      -8.332  -4.178 -13.003  1.00  0.00           H
ATOM     49 HG23 VAL A   4      -6.999  -3.356 -12.737  1.00  0.00           H
ATOM     50  N   LEU A   5      -6.594  -2.044 -17.118  1.00  0.00           N
ATOM     51  CA  LEU A   5      -6.605  -1.378 -18.415  1.00  0.00           C
ATOM     52  C   LEU A   5      -6.149  -2.294 -19.543  1.00  0.00           C
ATOM     53  O   LEU A   5      -6.429  -2.003 -20.711  1.00  0.00           O
ATOM     54  CB  LEU A   5      -5.725  -0.129 -18.373  1.00  0.00           C
ATOM     55  CG  LEU A   5      -6.208   1.011 -17.473  1.00  0.00           C
ATOM     56  CD1 LEU A   5      -5.151   2.100 -17.371  1.00  0.00           C
ATOM     57  CD2 LEU A   5      -7.522   1.580 -17.985  1.00  0.00           C
ATOM     58  H   LEU A   5      -5.958  -1.795 -16.595  1.00  0.00           H
ATOM     59  HA  LEU A   5      -7.512  -1.098 -18.613  1.00  0.00           H
ATOM     60  HB2 LEU A   5      -4.844  -0.388 -18.061  1.00  0.00           H
ATOM     61  HB3 LEU A   5      -5.656   0.225 -19.274  1.00  0.00           H
ATOM     62  HG  LEU A   5      -6.362   0.662 -16.581  1.00  0.00           H
ATOM     63 HD11 LEU A   5      -5.482   2.807 -16.796  1.00  0.00           H
ATOM     64 HD12 LEU A   5      -4.341   1.719 -16.996  1.00  0.00           H
ATOM     65 HD13 LEU A   5      -4.973   2.450 -18.258  1.00  0.00           H
ATOM     66 HD21 LEU A   5      -7.738   2.378 -17.478  1.00  0.00           H
ATOM     67 HD22 LEU A   5      -7.425   1.801 -18.925  1.00  0.00           H
ATOM     68 HD23 LEU A   5      -8.220   0.916 -17.872  1.00  0.00           H
ATOM     69  N   ILE A   6      -5.454  -3.390 -19.225  1.00  0.00           N
ATOM     70  CA  ILE A   6      -4.992  -4.302 -20.263  1.00  0.00           C
ATOM     71  C   ILE A   6      -6.126  -5.159 -20.808  1.00  0.00           C
ATOM     72  O   ILE A   6      -6.024  -5.676 -21.927  1.00  0.00           O
ATOM     73  CB  ILE A   6      -3.853  -5.192 -19.732  1.00  0.00           C
ATOM     74  CG1 ILE A   6      -4.261  -5.852 -18.413  1.00  0.00           C
ATOM     75  CG2 ILE A   6      -2.580  -4.378 -19.554  1.00  0.00           C
ATOM     76  CD1 ILE A   6      -3.337  -6.967 -17.977  1.00  0.00           C
ATOM     77  H   ILE A   6      -5.243  -3.614 -18.424  1.00  0.00           H
ATOM     78  HA  ILE A   6      -4.638  -3.780 -21.000  1.00  0.00           H
ATOM     79  HB  ILE A   6      -3.681  -5.890 -20.383  1.00  0.00           H
ATOM     80 HG12 ILE A   6      -4.256  -5.184 -17.711  1.00  0.00           H
ATOM     81 HG13 ILE A   6      -5.151  -6.224 -18.508  1.00  0.00           H
ATOM     82 HG21 ILE A   6      -1.860  -4.970 -19.288  1.00  0.00           H
ATOM     83 HG22 ILE A   6      -2.361  -3.949 -20.396  1.00  0.00           H
ATOM     84 HG23 ILE A   6      -2.728  -3.707 -18.869  1.00  0.00           H
ATOM     85 HD11 ILE A   6      -3.702  -7.386 -17.182  1.00  0.00           H
ATOM     86 HD12 ILE A   6      -3.270  -7.618 -18.693  1.00  0.00           H
ATOM     87 HD13 ILE A   6      -2.462  -6.596 -17.784  1.00  0.00           H
ATOM     88  N   MET A   7      -7.209  -5.326 -20.047  1.00  0.00           N
ATOM     89  CA  MET A   7      -8.336  -6.128 -20.506  1.00  0.00           C
ATOM     90  C   MET A   7      -9.245  -5.371 -21.465  1.00  0.00           C
ATOM     91  O   MET A   7      -9.999  -6.005 -22.211  1.00  0.00           O
ATOM     92  CB  MET A   7      -9.151  -6.624 -19.310  1.00  0.00           C
ATOM     93  CG  MET A   7      -8.766  -8.014 -18.830  1.00  0.00           C
ATOM     94  SD  MET A   7      -7.227  -8.026 -17.891  1.00  0.00           S
ATOM     95  CE  MET A   7      -7.281  -9.665 -17.172  1.00  0.00           C
ATOM     96  H   MET A   7      -7.313  -4.985 -19.264  1.00  0.00           H
ATOM     97  HA  MET A   7      -7.989  -6.908 -20.966  1.00  0.00           H
ATOM     98  HB2 MET A   7      -9.025  -6.010 -18.569  1.00  0.00           H
ATOM     99  HB3 MET A   7     -10.088  -6.647 -19.560  1.00  0.00           H
ATOM    100  HG2 MET A   7      -9.469  -8.355 -18.256  1.00  0.00           H
ATOM    101  HG3 MET A   7      -8.654  -8.596 -19.598  1.00  0.00           H
ATOM    102  HE1 MET A   7      -6.488  -9.798 -16.630  1.00  0.00           H
ATOM    103  HE2 MET A   7      -8.075  -9.741 -16.621  1.00  0.00           H
ATOM    104  HE3 MET A   7      -7.308 -10.322 -17.885  1.00  0.00           H
ATOM    105  N   MSE A   8      -9.193  -4.043 -21.462  1.00  0.00           N
ATOM    106  CA  MSE A   8     -10.030  -3.242 -22.348  1.00  0.00           C
ATOM    107  C   MSE A   8      -9.310  -2.934 -23.656  1.00  0.00           C
ATOM    108  O   MSE A   8      -9.914  -2.436 -24.606  1.00  0.00           O
ATOM    109  CB  MSE A   8     -10.449  -1.942 -21.659  1.00  0.00           C
ATOM    110  CG  MSE A   8     -11.716  -2.059 -20.827  1.00  0.00           C
ATOM    111 SE   MSE A   8     -11.431  -3.005 -19.146  1.00  0.00          Se
ATOM    112  CE  MSE A   8     -13.097  -2.534 -18.248  1.00  0.00           C
ATOM    113  H   MSE A   8      -8.678  -3.579 -20.953  1.00  0.00           H
ATOM    114  HA  MSE A   8     -10.837  -3.741 -22.549  1.00  0.00           H
ATOM    115  HB2 MSE A   8      -9.734  -1.658 -21.069  1.00  0.00           H
ATOM    116  HB3 MSE A   8     -10.603  -1.266 -22.337  1.00  0.00           H
ATOM    117  HG2 MSE A   8     -12.040  -1.169 -20.618  1.00  0.00           H
ATOM    118  HG3 MSE A   8     -12.385  -2.544 -21.335  1.00  0.00           H
ATOM    119  HE1 MSE A   8     -13.108  -2.943 -17.369  1.00  0.00           H
ATOM    120  HE2 MSE A   8     -13.149  -1.569 -18.165  1.00  0.00           H
ATOM    121  HE3 MSE A   8     -13.843  -2.862 -18.775  1.00  0.00           H
ATOM    122  N   CYS A   9      -8.010  -3.234 -23.698  1.00  0.00           N
ATOM    123  CA  CYS A   9      -7.229  -2.980 -24.904  1.00  0.00           C
ATOM    124  C   CYS A   9      -7.519  -4.012 -25.987  1.00  0.00           C
ATOM    125  O   CYS A   9      -7.559  -3.673 -27.175  1.00  0.00           O
ATOM    126  CB  CYS A   9      -5.737  -2.965 -24.569  1.00  0.00           C
ATOM    127  SG  CYS A   9      -5.172  -1.457 -23.746  1.00  0.00           S
ATOM    128  H   CYS A   9      -7.561  -3.579 -23.052  1.00  0.00           H
ATOM    129  HA  CYS A   9      -7.465  -2.107 -25.253  1.00  0.00           H
ATOM    130  HB2 CYS A   9      -5.543  -3.712 -23.981  1.00  0.00           H
ATOM    131  HB3 CYS A   9      -5.233  -3.058 -25.392  1.00  0.00           H
ATOM    132  HG  CYS A   9      -5.895  -1.207 -22.823  1.00  0.00           H
ATOM    133  N   PHE A  10      -7.723  -5.272 -25.600  1.00  0.00           N
ATOM    134  CA  PHE A  10      -8.009  -6.322 -26.569  1.00  0.00           C
ATOM    135  C   PHE A  10      -9.463  -6.325 -27.020  1.00  0.00           C
ATOM    136  O   PHE A  10      -9.786  -6.978 -28.018  1.00  0.00           O
ATOM    137  CB  PHE A  10      -7.650  -7.690 -25.985  1.00  0.00           C
ATOM    138  CG  PHE A  10      -6.173  -7.906 -25.812  1.00  0.00           C
ATOM    139  CD1 PHE A  10      -5.380  -8.258 -26.891  1.00  0.00           C
ATOM    140  CD2 PHE A  10      -5.579  -7.757 -24.570  1.00  0.00           C
ATOM    141  CE1 PHE A  10      -4.021  -8.457 -26.735  1.00  0.00           C
ATOM    142  CE2 PHE A  10      -4.220  -7.955 -24.407  1.00  0.00           C
ATOM    143  CZ  PHE A  10      -3.441  -8.305 -25.491  1.00  0.00           C
ATOM    144  H   PHE A  10      -7.701  -5.541 -24.784  1.00  0.00           H
ATOM    145  HA  PHE A  10      -7.456  -6.181 -27.354  1.00  0.00           H
ATOM    146  HB2 PHE A  10      -8.067  -7.777 -25.113  1.00  0.00           H
ATOM    147  HB3 PHE A  10      -7.983  -8.381 -26.579  1.00  0.00           H
ATOM    148  HD1 PHE A  10      -5.766  -8.361 -27.731  1.00  0.00           H
ATOM    149  HD2 PHE A  10      -6.100  -7.521 -23.837  1.00  0.00           H
ATOM    150  HE1 PHE A  10      -3.498  -8.693 -27.467  1.00  0.00           H
ATOM    151  HE2 PHE A  10      -3.832  -7.852 -23.568  1.00  0.00           H
ATOM    152  HZ  PHE A  10      -2.527  -8.439 -25.384  1.00  0.00           H
ATOM    153  N   TYR A  11     -10.345  -5.616 -26.312  1.00  0.00           N
ATOM    154  CA  TYR A  11     -11.751  -5.579 -26.697  1.00  0.00           C
ATOM    155  C   TYR A  11     -11.995  -4.659 -27.886  1.00  0.00           C
ATOM    156  O   TYR A  11     -12.913  -4.906 -28.676  1.00  0.00           O
ATOM    157  CB  TYR A  11     -12.610  -5.139 -25.511  1.00  0.00           C
ATOM    158  CG  TYR A  11     -12.819  -6.218 -24.471  1.00  0.00           C
ATOM    159  CD1 TYR A  11     -12.576  -7.553 -24.768  1.00  0.00           C
ATOM    160  CD2 TYR A  11     -13.261  -5.901 -23.193  1.00  0.00           C
ATOM    161  CE1 TYR A  11     -12.766  -8.541 -23.821  1.00  0.00           C
ATOM    162  CE2 TYR A  11     -13.454  -6.883 -22.240  1.00  0.00           C
ATOM    163  CZ  TYR A  11     -13.205  -8.201 -22.559  1.00  0.00           C
ATOM    164  OH  TYR A  11     -13.396  -9.182 -21.613  1.00  0.00           O
ATOM    165  H   TYR A  11     -10.155  -5.154 -25.612  1.00  0.00           H
ATOM    166  HA  TYR A  11     -12.024  -6.460 -26.988  1.00  0.00           H
ATOM    167  HB2 TYR A  11     -12.179  -4.387 -25.075  1.00  0.00           H
ATOM    168  HB3 TYR A  11     -13.483  -4.872 -25.840  1.00  0.00           H
ATOM    169  HD1 TYR A  11     -12.280  -7.795 -25.614  1.00  0.00           H
ATOM    170  HD2 TYR A  11     -13.430  -5.013 -22.975  1.00  0.00           H
ATOM    171  HE1 TYR A  11     -12.599  -9.431 -24.034  1.00  0.00           H
ATOM    172  HE2 TYR A  11     -13.750  -6.656 -21.388  1.00  0.00           H
ATOM    173  HH  TYR A  11     -13.663  -8.840 -20.894  1.00  0.00           H
ATOM    174  N   TRP A  12     -11.194  -3.602 -28.031  1.00  0.00           N
ATOM    175  CA  TRP A  12     -11.371  -2.680 -29.147  1.00  0.00           C
ATOM    176  C   TRP A  12     -10.822  -3.245 -30.451  1.00  0.00           C
ATOM    177  O   TRP A  12     -11.324  -2.905 -31.528  1.00  0.00           O
ATOM    178  CB  TRP A  12     -10.703  -1.340 -28.835  1.00  0.00           C
ATOM    179  CG  TRP A  12     -11.507  -0.468 -27.920  1.00  0.00           C
ATOM    180  CD1 TRP A  12     -11.397  -0.382 -26.563  1.00  0.00           C
ATOM    181  CD2 TRP A  12     -12.545   0.445 -28.297  1.00  0.00           C
ATOM    182  NE1 TRP A  12     -12.302   0.527 -26.071  1.00  0.00           N
ATOM    183  CE2 TRP A  12     -13.019   1.049 -27.116  1.00  0.00           C
ATOM    184  CE3 TRP A  12     -13.120   0.810 -29.519  1.00  0.00           C
ATOM    185  CZ2 TRP A  12     -14.040   1.997 -27.120  1.00  0.00           C
ATOM    186  CZ3 TRP A  12     -14.133   1.751 -29.520  1.00  0.00           C
ATOM    187  CH2 TRP A  12     -14.583   2.334 -28.329  1.00  0.00           C
ATOM    188  H   TRP A  12     -10.548  -3.400 -27.501  1.00  0.00           H
ATOM    189  HA  TRP A  12     -12.319  -2.517 -29.270  1.00  0.00           H
ATOM    190  HB2 TRP A  12      -9.847  -1.508 -28.410  1.00  0.00           H
ATOM    191  HB3 TRP A  12     -10.569  -0.856 -29.665  1.00  0.00           H
ATOM    192  HD1 TRP A  12     -10.796  -0.868 -26.046  1.00  0.00           H
ATOM    193  HE1 TRP A  12     -12.402   0.735 -25.243  1.00  0.00           H
ATOM    194  HE3 TRP A  12     -12.827   0.428 -30.314  1.00  0.00           H
ATOM    195  HZ2 TRP A  12     -14.341   2.386 -26.331  1.00  0.00           H
ATOM    196  HZ3 TRP A  12     -14.523   2.001 -30.326  1.00  0.00           H
ATOM    197  HH2 TRP A  12     -15.266   2.964 -28.361  1.00  0.00           H
ATOM    198  N   HIS A  13      -9.801  -4.102 -30.378  1.00  0.00           N
ATOM    199  CA  HIS A  13      -9.227  -4.680 -31.587  1.00  0.00           C
ATOM    200  C   HIS A  13     -10.095  -5.793 -32.159  1.00  0.00           C
ATOM    201  O   HIS A  13     -10.031  -6.065 -33.363  1.00  0.00           O
ATOM    202  CB  HIS A  13      -7.820  -5.207 -31.301  1.00  0.00           C
ATOM    203  CG  HIS A  13      -6.792  -4.131 -31.142  1.00  0.00           C
ATOM    204  ND1 HIS A  13      -6.302  -3.406 -32.207  1.00  0.00           N
ATOM    205  CD2 HIS A  13      -6.161  -3.656 -30.042  1.00  0.00           C
ATOM    206  CE1 HIS A  13      -5.414  -2.531 -31.770  1.00  0.00           C
ATOM    207  NE2 HIS A  13      -5.310  -2.662 -30.459  1.00  0.00           N
ATOM    208  H   HIS A  13      -9.428  -4.361 -29.647  1.00  0.00           H
ATOM    209  HA  HIS A  13      -9.153  -3.986 -32.261  1.00  0.00           H
ATOM    210  HB2 HIS A  13      -7.840  -5.721 -30.479  1.00  0.00           H
ATOM    211  HB3 HIS A  13      -7.543  -5.775 -32.037  1.00  0.00           H
ATOM    212  HD2 HIS A  13      -6.282  -3.948 -29.167  1.00  0.00           H
ATOM    213  HE1 HIS A  13      -4.942  -1.926 -32.295  1.00  0.00           H
ATOM    214  HE2 HIS A  13      -4.793  -2.200 -29.950  1.00  0.00           H
ATOM    215  N   LYS A  14     -10.905  -6.444 -31.322  1.00  0.00           N
ATOM    216  CA  LYS A  14     -11.763  -7.520 -31.805  1.00  0.00           C
ATOM    217  C   LYS A  14     -12.981  -6.978 -32.543  1.00  0.00           C
ATOM    218  O   LYS A  14     -13.417  -7.564 -33.540  1.00  0.00           O
ATOM    219  CB  LYS A  14     -12.196  -8.410 -30.640  1.00  0.00           C
ATOM    220  CG  LYS A  14     -11.091  -9.298 -30.092  1.00  0.00           C
ATOM    221  CD  LYS A  14     -11.589 -10.150 -28.936  1.00  0.00           C
ATOM    222  CE  LYS A  14     -10.476 -11.017 -28.371  1.00  0.00           C
ATOM    223  NZ  LYS A  14     -10.943 -11.837 -27.219  1.00  0.00           N
ATOM    224  H   LYS A  14     -10.974  -6.283 -30.480  1.00  0.00           H
ATOM    225  HA  LYS A  14     -11.259  -8.068 -32.426  1.00  0.00           H
ATOM    226  HB2 LYS A  14     -12.507  -7.845 -29.916  1.00  0.00           H
ATOM    227  HB3 LYS A  14     -12.917  -8.986 -30.939  1.00  0.00           H
ATOM    228  HG2 LYS A  14     -10.778  -9.890 -30.794  1.00  0.00           H
ATOM    229  HG3 LYS A  14     -10.363  -8.743 -29.770  1.00  0.00           H
ATOM    230  HD2 LYS A  14     -11.914  -9.572 -28.228  1.00  0.00           H
ATOM    231  HD3 LYS A  14     -12.299 -10.732 -29.249  1.00  0.00           H
ATOM    232  HE2 LYS A  14     -10.158 -11.619 -29.062  1.00  0.00           H
ATOM    233  HE3 LYS A  14      -9.753 -10.448 -28.064  1.00  0.00           H
ATOM    234  HZ1 LYS A  14     -10.273 -12.334 -26.908  1.00  0.00           H
ATOM    235  HZ2 LYS A  14     -11.236 -11.306 -26.567  1.00  0.00           H
ATOM    236  HZ3 LYS A  14     -11.606 -12.373 -27.476  1.00  0.00           H
ATOM    237  N   ARG A  15     -13.543  -5.865 -32.069  1.00  0.00           N
ATOM    238  CA  ARG A  15     -14.709  -5.275 -32.714  1.00  0.00           C
ATOM    239  C   ARG A  15     -14.360  -4.533 -33.997  1.00  0.00           C
ATOM    240  O   ARG A  15     -15.237  -4.351 -34.848  1.00  0.00           O
ATOM    241  CB  ARG A  15     -15.421  -4.324 -31.749  1.00 10.00           C
ATOM    242  CG  ARG A  15     -16.040  -5.012 -30.543  1.00 10.00           C
ATOM    243  CD  ARG A  15     -17.207  -5.897 -30.950  1.00 10.00           C
ATOM    244  NE  ARG A  15     -18.309  -5.123 -31.513  1.00 10.00           N
ATOM    245  CZ  ARG A  15     -19.293  -5.644 -32.240  1.00 10.00           C
ATOM    246  NH1 ARG A  15     -19.314  -6.945 -32.495  1.00 10.00           N
ATOM    247  NH2 ARG A  15     -20.256  -4.864 -32.712  1.00 10.00           N
ATOM    248  H   ARG A  15     -13.267  -5.436 -31.377  1.00  0.00           H
ATOM    249  HA  ARG A  15     -15.325  -5.985 -32.950  1.00  0.00           H
ATOM    250  HB2 ARG A  15     -14.779  -3.676 -31.421  1.00 10.00           H
ATOM    251  HB3 ARG A  15     -16.131  -3.868 -32.228  1.00 10.00           H
ATOM    252  HG2 ARG A  15     -15.372  -5.568 -30.113  1.00 10.00           H
ATOM    253  HG3 ARG A  15     -16.368  -4.341 -29.924  1.00 10.00           H
ATOM    254  HD2 ARG A  15     -16.912  -6.538 -31.613  1.00 10.00           H
ATOM    255  HD3 ARG A  15     -17.538  -6.361 -30.165  1.00 10.00           H
ATOM    256  HE  ARG A  15     -18.323  -4.276 -31.365  1.00 10.00           H
ATOM    257 HH11 ARG A  15     -18.694  -7.458 -32.192  1.00 10.00           H
ATOM    258 HH12 ARG A  15     -19.952  -7.278 -32.966  1.00 10.00           H
ATOM    259 HH21 ARG A  15     -20.245  -4.020 -32.548  1.00 10.00           H
ATOM    260 HH22 ARG A  15     -20.892  -5.202 -33.182  1.00 10.00           H
ATOM    261  N   GLN A  16     -13.107  -4.104 -34.155  1.00  0.00           N
ATOM    262  CA  GLN A  16     -12.715  -3.387 -35.363  1.00  0.00           C
ATOM    263  C   GLN A  16     -12.453  -4.341 -36.522  1.00  0.00           C
ATOM    264  O   GLN A  16     -12.768  -4.023 -37.674  1.00  0.00           O
ATOM    265  CB  GLN A  16     -11.477  -2.531 -35.087  1.00  0.00           C
ATOM    266  CG  GLN A  16     -11.109  -1.586 -36.219  1.00  0.00           C
ATOM    267  CD  GLN A  16      -9.920  -0.708 -35.881  1.00  0.00           C
ATOM    268  OE1 GLN A  16      -9.334  -0.824 -34.804  1.00  0.00           O
ATOM    269  NE2 GLN A  16      -9.557   0.177 -36.802  1.00  0.00           N
ATOM    270  H   GLN A  16     -12.474  -4.214 -33.584  1.00  0.00           H
ATOM    271  HA  GLN A  16     -13.436  -2.793 -35.624  1.00  0.00           H
ATOM    272  HB2 GLN A  16     -11.640  -1.994 -34.295  1.00  0.00           H
ATOM    273  HB3 GLN A  16     -10.720  -3.118 -34.935  1.00  0.00           H
ATOM    274  HG2 GLN A  16     -10.883  -2.106 -37.006  1.00  0.00           H
ATOM    275  HG3 GLN A  16     -11.865  -1.008 -36.408  1.00  0.00           H
ATOM    276 HE21 GLN A  16      -9.991   0.229 -37.543  1.00  0.00           H
ATOM    277 HE22 GLN A  16      -8.888   0.698 -36.658  1.00  0.00           H
ATOM    278  N   ASN A  17     -11.882  -5.514 -36.238  1.00  0.00           N
ATOM    279  CA  ASN A  17     -11.600  -6.473 -37.300  1.00  0.00           C
ATOM    280  C   ASN A  17     -12.869  -7.154 -37.797  1.00  0.00           C
ATOM    281  O   ASN A  17     -12.953  -7.519 -38.975  1.00  0.00           O
ATOM    282  CB  ASN A  17     -10.595  -7.517 -36.813  1.00  0.00           C
ATOM    283  CG  ASN A  17      -9.203  -6.944 -36.631  1.00  0.00           C
ATOM    284  OD1 ASN A  17      -8.725  -6.169 -37.460  1.00  0.00           O
ATOM    285  ND2 ASN A  17      -8.544  -7.324 -35.543  1.00  0.00           N
ATOM    286  H   ASN A  17     -11.653  -5.773 -35.451  1.00  0.00           H
ATOM    287  HA  ASN A  17     -11.202  -6.003 -38.049  1.00  0.00           H
ATOM    288  HB2 ASN A  17     -10.891  -7.866 -35.958  1.00  0.00           H
ATOM    289  HB3 ASN A  17     -10.542  -8.234 -37.464  1.00  0.00           H
ATOM    290 HD21 ASN A  17      -7.751  -7.026 -35.395  1.00  0.00           H
ATOM    291 HD22 ASN A  17      -8.910  -7.867 -34.986  1.00  0.00           H
ATOM    292  N   GLU A  18     -13.860  -7.335 -36.923  1.00  0.00           N
ATOM    293  CA  GLU A  18     -15.108  -7.974 -37.320  1.00  0.00           C
ATOM    294  C   GLU A  18     -16.016  -7.048 -38.118  1.00  0.00           C
ATOM    295  O   GLU A  18     -16.891  -7.536 -38.842  1.00  0.00           O
ATOM    296  CB  GLU A  18     -15.854  -8.487 -36.086  1.00  0.00           C
ATOM    297  CG  GLU A  18     -15.201  -9.688 -35.421  1.00  0.00           C
ATOM    298  CD  GLU A  18     -15.961 -10.160 -34.197  1.00  0.00           C
ATOM    299  OE1 GLU A  18     -16.936  -9.485 -33.803  1.00  0.00           O
ATOM    300  OE2 GLU A  18     -15.585 -11.207 -33.629  1.00  0.00           O
ATOM    301  H   GLU A  18     -13.832  -7.097 -36.097  1.00  0.00           H
ATOM    302  HA  GLU A  18     -14.901  -8.739 -37.880  1.00  0.00           H
ATOM    303  HB2 GLU A  18     -15.898  -7.774 -35.430  1.00  0.00           H
ATOM    304  HB3 GLU A  18     -16.751  -8.746 -36.350  1.00  0.00           H
ATOM    305  HG2 GLU A  18     -15.167 -10.421 -36.055  1.00  0.00           H
ATOM    306  HG3 GLU A  18     -14.304  -9.447 -35.143  1.00  0.00           H
ATOM    307  N   ASP A  19     -15.832  -5.734 -38.003  1.00  0.00           N
ATOM    308  CA  ASP A  19     -16.656  -4.779 -38.735  1.00  0.00           C
ATOM    309  C   ASP A  19     -16.155  -4.553 -40.156  1.00  0.00           C
ATOM    310  O   ASP A  19     -16.962  -4.402 -41.080  1.00  0.00           O
ATOM    311  CB  ASP A  19     -16.711  -3.446 -37.984  1.00  0.00           C
ATOM    312  CG  ASP A  19     -17.674  -2.461 -38.616  1.00  0.00           C
ATOM    313  OD1 ASP A  19     -18.900  -2.644 -38.463  1.00  0.00           O
ATOM    314  OD2 ASP A  19     -17.206  -1.503 -39.267  1.00  0.00           O
ATOM    315  H   ASP A  19     -15.233  -5.370 -37.505  1.00  0.00           H
ATOM    316  HA  ASP A  19     -17.560  -5.125 -38.791  1.00  0.00           H
ATOM    317  HB2 ASP A  19     -17.002  -3.608 -37.073  1.00  0.00           H
ATOM    318  HB3 ASP A  19     -15.828  -3.045 -37.985  1.00  0.00           H
ATOM    319  N   SER A  20     -14.835  -4.526 -40.351  1.00  0.00           N
ATOM    320  CA  SER A  20     -14.273  -4.316 -41.679  1.00  0.00           C
ATOM    321  C   SER A  20     -14.330  -5.566 -42.546  1.00  0.00           C
ATOM    322  O   SER A  20     -14.281  -5.452 -43.776  1.00  0.00           O
ATOM    323  CB  SER A  20     -12.825  -3.834 -41.567  1.00  0.00           C
ATOM    324  OG  SER A  20     -12.244  -3.664 -42.848  1.00  0.00           O
ATOM    325  H   SER A  20     -14.248  -4.627 -39.731  1.00  0.00           H
ATOM    326  HA  SER A  20     -14.782  -3.622 -42.127  1.00  0.00           H
ATOM    327  HB2 SER A  20     -12.811  -2.984 -41.100  1.00  0.00           H
ATOM    328  HB3 SER A  20     -12.311  -4.492 -41.073  1.00  0.00           H
ATOM    329  HG  SER A  20     -11.450  -3.400 -42.771  1.00  0.00           H
ATOM    330  N   THR A  21     -14.432  -6.745 -41.942  1.00  0.00           N
ATOM    331  CA  THR A  21     -14.493  -7.990 -42.698  1.00  0.00           C
ATOM    332  C   THR A  21     -15.918  -8.530 -42.751  1.00  0.00           C
ATOM    333  O   THR A  21     -16.459  -8.778 -43.829  1.00  0.00           O
ATOM    334  CB  THR A  21     -13.569  -9.064 -42.093  1.00  0.00           C
ATOM    335  OG1 THR A  21     -13.970  -9.340 -40.746  1.00  0.00           O
ATOM    336  CG2 THR A  21     -12.124  -8.589 -42.101  1.00  0.00           C
ATOM    337  H   THR A  21     -14.468  -6.852 -41.089  1.00  0.00           H
ATOM    338  HA  THR A  21     -14.201  -7.826 -43.608  1.00  0.00           H
ATOM    339  HB  THR A  21     -13.628  -9.876 -42.621  1.00  0.00           H
ATOM    340  HG1 THR A  21     -13.917  -8.642 -40.282  1.00  0.00           H
ATOM    341 HG21 THR A  21     -11.546  -9.282 -41.747  1.00  0.00           H
ATOM    342 HG22 THR A  21     -11.849  -8.382 -43.008  1.00  0.00           H
ATOM    343 HG23 THR A  21     -12.033  -7.793 -41.554  1.00  0.00           H
TER
END
"""

all_aa_all_d="""
ATOM      1  N   GLY A   1      -5.398  -1.491 -11.512  1.00  0.00           N
ATOM      2  CA  GLY A   1      -4.707  -0.522 -12.342  1.00  0.00           C
ATOM      3  C   GLY A   1      -4.028  -1.140 -13.548  1.00  0.00           C
ATOM      4  O   GLY A   1      -4.570  -1.108 -14.652  1.00  0.00           O
ATOM      5  D1  GLY A   1      -6.425  -1.359 -11.608  1.00  0.00           D
ATOM      6  D2  GLY A   1      -5.142  -2.452 -11.815  1.00  0.00           D
ATOM      7  D3  GLY A   1      -5.122  -1.356 -10.518  1.00  0.00           D
ATOM      8  DA2 GLY A   1      -5.433   0.205 -12.707  1.00  0.00           D
ATOM      9  DA3 GLY A   1      -3.971   0.015 -11.746  1.00  0.00           D
ATOM     10  N   PRO A   2      -2.833  -1.701 -13.342  1.00  0.00           N
ATOM     11  CA  PRO A   2      -2.123  -2.328 -14.468  1.00  0.00           C
ATOM     12  C   PRO A   2      -2.829  -3.557 -15.012  1.00  0.00           C
ATOM     13  O   PRO A   2      -2.735  -3.826 -16.216  1.00  0.00           O
ATOM     14  CB  PRO A   2      -0.752  -2.683 -13.871  1.00  0.00           C
ATOM     15  CG  PRO A   2      -0.641  -1.867 -12.615  1.00  0.00           C
ATOM     16  CD  PRO A   2      -2.037  -1.721 -12.104  1.00  0.00           C
ATOM     17  DA  PRO A   2      -1.986  -1.607 -15.274  1.00  0.00           D
ATOM     18  DB2 PRO A   2      -0.717  -3.748 -13.642  1.00  0.00           D
ATOM     19  DB3 PRO A   2       0.035  -2.414 -14.575  1.00  0.00           D
ATOM     20  DD2 PRO A   2      -2.310  -2.577 -11.487  1.00  0.00           D
ATOM     21  DD3 PRO A   2      -2.133  -0.784 -11.557  1.00  0.00           D
ATOM     22  DG2 PRO A   2      -0.020  -2.394 -11.890  1.00  0.00           D
ATOM     23  DG3 PRO A   2      -0.214  -0.892 -12.849  1.00  0.00           D
ATOM     24  N   ALA A   3      -3.531  -4.309 -14.168  1.00  0.00           N
ATOM     25  CA  ALA A   3      -4.240  -5.508 -14.591  1.00  0.00           C
ATOM     26  C   ALA A   3      -5.691  -5.236 -14.967  1.00  0.00           C
ATOM     27  O   ALA A   3      -6.458  -6.186 -15.156  1.00  0.00           O
ATOM     28  CB  ALA A   3      -4.179  -6.571 -13.492  1.00  0.00           C
ATOM     29  D   ALA A   3      -3.627  -4.108 -13.173  1.00  0.00           D
ATOM     30  DA  ALA A   3      -3.742  -5.915 -15.471  1.00  0.00           D
ATOM     31  DB1 ALA A   3      -4.714  -7.459 -13.828  1.00  0.00           D
ATOM     32  DB2 ALA A   3      -3.136  -6.818 -13.295  1.00  0.00           D
ATOM     33  DB3 ALA A   3      -4.645  -6.175 -12.590  1.00  0.00           D
ATOM     34  N   VAL A   4      -6.084  -3.970 -15.080  1.00  0.00           N
ATOM     35  CA  VAL A   4      -7.445  -3.598 -15.431  1.00  0.00           C
ATOM     36  C   VAL A   4      -7.517  -2.959 -16.812  1.00  0.00           C
ATOM     37  O   VAL A   4      -8.399  -3.291 -17.606  1.00  0.00           O
ATOM     38  CB  VAL A   4      -8.051  -2.664 -14.360  1.00  0.00           C
ATOM     39  CG1 VAL A   4      -9.502  -2.346 -14.689  1.00  0.00           C
ATOM     40  CG2 VAL A   4      -7.936  -3.293 -12.980  1.00  0.00           C
ATOM     41  D   VAL A   4      -5.470  -3.169 -14.932  1.00  0.00           D
ATOM     42  DA  VAL A   4      -8.057  -4.499 -15.458  1.00  0.00           D
ATOM     43  DB  VAL A   4      -7.495  -1.727 -14.350  1.00  0.00           D
ATOM     44 DG11 VAL A   4      -9.952  -1.831 -13.840  1.00  0.00           D
ATOM     45 DG12 VAL A   4      -9.537  -1.707 -15.571  1.00  0.00           D
ATOM     46 DG13 VAL A   4     -10.034  -3.278 -14.882  1.00  0.00           D
ATOM     47 DG21 VAL A   4      -8.449  -2.658 -12.258  1.00  0.00           D
ATOM     48 DG22 VAL A   4      -8.398  -4.280 -13.001  1.00  0.00           D
ATOM     49 DG23 VAL A   4      -6.882  -3.381 -12.716  1.00  0.00           D
ATOM     50  N   LEU A   5      -6.594  -2.044 -17.118  1.00  0.00           N
ATOM     51  CA  LEU A   5      -6.605  -1.378 -18.415  1.00  0.00           C
ATOM     52  C   LEU A   5      -6.149  -2.294 -19.543  1.00  0.00           C
ATOM     53  O   LEU A   5      -6.429  -2.003 -20.711  1.00  0.00           O
ATOM     54  CB  LEU A   5      -5.725  -0.129 -18.373  1.00  0.00           C
ATOM     55  CG  LEU A   5      -6.208   1.011 -17.473  1.00  0.00           C
ATOM     56  CD1 LEU A   5      -5.151   2.100 -17.371  1.00  0.00           C
ATOM     57  CD2 LEU A   5      -7.522   1.580 -17.985  1.00  0.00           C
ATOM     58  D   LEU A   5      -5.840  -1.749 -16.498  1.00  0.00           D
ATOM     59  DA  LEU A   5      -7.624  -1.063 -18.638  1.00  0.00           D
ATOM     60  DB2 LEU A   5      -4.735  -0.420 -18.023  1.00  0.00           D
ATOM     61  DB3 LEU A   5      -5.647   0.268 -19.385  1.00  0.00           D
ATOM     62  DG  LEU A   5      -6.382   0.619 -16.471  1.00  0.00           D
ATOM     63 DD11 LEU A   5      -5.523   2.896 -16.725  1.00  0.00           D
ATOM     64 DD12 LEU A   5      -4.242   1.673 -16.949  1.00  0.00           D
ATOM     65 DD13 LEU A   5      -4.950   2.493 -18.368  1.00  0.00           D
ATOM     66 DD21 LEU A   5      -7.762   2.481 -17.420  1.00  0.00           D
ATOM     67 DD22 LEU A   5      -7.415   1.822 -19.042  1.00  0.00           D
ATOM     68 DD23 LEU A   5      -8.308   0.837 -17.852  1.00  0.00           D
ATOM     69  N   ILE A   6      -5.454  -3.390 -19.225  1.00  0.00           N
ATOM     70  CA  ILE A   6      -4.992  -4.302 -20.263  1.00  0.00           C
ATOM     71  C   ILE A   6      -6.126  -5.159 -20.808  1.00  0.00           C
ATOM     72  O   ILE A   6      -6.024  -5.676 -21.927  1.00  0.00           O
ATOM     73  CB  ILE A   6      -3.853  -5.192 -19.732  1.00  0.00           C
ATOM     74  CG1 ILE A   6      -4.261  -5.852 -18.413  1.00  0.00           C
ATOM     75  CG2 ILE A   6      -2.580  -4.378 -19.554  1.00  0.00           C
ATOM     76  CD1 ILE A   6      -3.337  -6.967 -17.977  1.00  0.00           C
ATOM     77  D   ILE A   6      -5.206  -3.652 -18.273  1.00  0.00           D
ATOM     78  DA  ILE A   6      -4.594  -3.715 -21.091  1.00  0.00           D
ATOM     79  DB  ILE A   6      -3.660  -5.976 -20.464  1.00  0.00           D
ATOM     80 DD11 ILE A   6      -3.755  -7.449 -17.093  1.00  0.00           D
ATOM     81 DD12 ILE A   6      -3.248  -7.690 -18.788  1.00  0.00           D
ATOM     82 DD13 ILE A   6      -2.359  -6.547 -17.744  1.00  0.00           D
ATOM     83 DG12 ILE A   6      -4.253  -5.103 -17.622  1.00  0.00           D
ATOM     84 DG13 ILE A   6      -5.262  -6.267 -18.520  1.00  0.00           D
ATOM     85 DG21 ILE A   6      -1.773  -5.043 -19.247  1.00  0.00           D
ATOM     86 DG22 ILE A   6      -2.329  -3.902 -20.502  1.00  0.00           D
ATOM     87 DG23 ILE A   6      -2.749  -3.619 -18.790  1.00  0.00           D
ATOM     88  N   MET A   7      -7.209  -5.326 -20.047  1.00  0.00           N
ATOM     89  CA  MET A   7      -8.336  -6.128 -20.506  1.00  0.00           C
ATOM     90  C   MET A   7      -9.245  -5.371 -21.465  1.00  0.00           C
ATOM     91  O   MET A   7      -9.999  -6.005 -22.211  1.00  0.00           O
ATOM     92  CB  MET A   7      -9.151  -6.624 -19.310  1.00  0.00           C
ATOM     93  CG  MET A   7      -8.766  -8.014 -18.830  1.00  0.00           C
ATOM     94  SD  MET A   7      -7.227  -8.026 -17.891  1.00  0.00           S
ATOM     95  CE  MET A   7      -7.281  -9.665 -17.172  1.00  0.00           C
ATOM     96  D   MET A   7      -7.332  -4.922 -19.118  1.00  0.00           D
ATOM     97  DA  MET A   7      -7.946  -7.005 -21.022  1.00  0.00           D
ATOM     98  DB2 MET A   7      -9.009  -5.934 -18.478  1.00  0.00           D
ATOM     99  DB3 MET A   7     -10.204  -6.650 -19.591  1.00  0.00           D
ATOM    100  DE1 MET A   7      -6.390  -9.814 -16.563  1.00  0.00           D
ATOM    101  DE2 MET A   7      -8.174  -9.751 -16.553  1.00  0.00           D
ATOM    102  DE3 MET A   7      -7.312 -10.403 -17.974  1.00  0.00           D
ATOM    103  DG2 MET A   7      -9.557  -8.399 -18.186  1.00  0.00           D
ATOM    104  DG3 MET A   7      -8.639  -8.666 -19.694  1.00  0.00           D
ATOM    105  N   MSE A   8      -9.193  -4.043 -21.462  1.00  0.00           N
ATOM    106  CA  MSE A   8     -10.030  -3.242 -22.348  1.00  0.00           C
ATOM    107  C   MSE A   8      -9.310  -2.934 -23.656  1.00  0.00           C
ATOM    108  O   MSE A   8      -9.914  -2.436 -24.606  1.00  0.00           O
ATOM    109  CB  MSE A   8     -10.449  -1.942 -21.659  1.00  0.00           C
ATOM    110  CG  MSE A   8     -11.716  -2.059 -20.827  1.00  0.00           C
ATOM    111 SE   MSE A   8     -11.431  -3.005 -19.146  1.00  0.00          Se
ATOM    112  CE  MSE A   8     -13.097  -2.534 -18.248  1.00  0.00           C
ATOM    113  D   MSE A   8      -8.582  -3.492 -20.858  1.00  0.00           D
ATOM    114  DA  MSE A   8     -10.937  -3.803 -22.573  1.00  0.00           D
ATOM    115  DB2 MSE A   8      -9.645  -1.623 -20.996  1.00  0.00           D
ATOM    116  DB3 MSE A   8     -10.621  -1.182 -22.421  1.00  0.00           D
ATOM    117  DE1 MSE A   8     -13.109  -2.994 -17.260  1.00  0.00           D
ATOM    118  DE2 MSE A   8     -13.155  -1.450 -18.155  1.00  0.00           D
ATOM    119  DE3 MSE A   8     -13.935  -2.902 -18.840  1.00  0.00           D
ATOM    120  DG2 MSE A   8     -12.081  -1.059 -20.593  1.00  0.00           D
ATOM    121  DG3 MSE A   8     -12.467  -2.605 -21.398  1.00  0.00           D
ATOM    122  N   CYS A   9      -8.010  -3.234 -23.698  1.00  0.00           N
ATOM    123  CA  CYS A   9      -7.229  -2.980 -24.904  1.00  0.00           C
ATOM    124  C   CYS A   9      -7.519  -4.012 -25.987  1.00  0.00           C
ATOM    125  O   CYS A   9      -7.559  -3.673 -27.175  1.00  0.00           O
ATOM    126  CB  CYS A   9      -5.737  -2.965 -24.569  1.00  0.00           C
ATOM    127  SG  CYS A   9      -5.172  -1.457 -23.746  1.00  0.00           S
ATOM    128  D   CYS A   9      -7.477  -3.644 -22.931  1.00  0.00           D
ATOM    129  DA  CYS A   9      -7.495  -1.998 -25.297  1.00  0.00           D
ATOM    130  DB2 CYS A   9      -5.519  -3.804 -23.908  1.00  0.00           D
ATOM    131  DB3 CYS A   9      -5.170  -3.069 -25.494  1.00  0.00           D
ATOM    132  DG  CYS A   9      -5.979  -1.162 -22.773  1.00  0.00           D
ATOM    133  N   PHE A  10      -7.723  -5.272 -25.600  1.00  0.00           N
ATOM    134  CA  PHE A  10      -8.009  -6.322 -26.569  1.00  0.00           C
ATOM    135  C   PHE A  10      -9.463  -6.325 -27.020  1.00  0.00           C
ATOM    136  O   PHE A  10      -9.786  -6.978 -28.018  1.00  0.00           O
ATOM    137  CB  PHE A  10      -7.650  -7.690 -25.985  1.00  0.00           C
ATOM    138  CG  PHE A  10      -6.173  -7.906 -25.812  1.00  0.00           C
ATOM    139  CD1 PHE A  10      -5.380  -8.258 -26.891  1.00  0.00           C
ATOM    140  CD2 PHE A  10      -5.579  -7.757 -24.570  1.00  0.00           C
ATOM    141  CE1 PHE A  10      -4.021  -8.457 -26.735  1.00  0.00           C
ATOM    142  CE2 PHE A  10      -4.220  -7.955 -24.407  1.00  0.00           C
ATOM    143  CZ  PHE A  10      -3.441  -8.305 -25.491  1.00  0.00           C
ATOM    144  D   PHE A  10      -7.697  -5.591 -24.632  1.00  0.00           D
ATOM    145  DA  PHE A  10      -7.388  -6.163 -27.451  1.00  0.00           D
ATOM    146  DB2 PHE A  10      -8.118  -7.788 -25.005  1.00  0.00           D
ATOM    147  DB3 PHE A  10      -8.024  -8.466 -26.652  1.00  0.00           D
ATOM    148  DD1 PHE A  10      -5.828  -8.378 -27.866  1.00  0.00           D
ATOM    149  DD2 PHE A  10      -6.184  -7.483 -23.719  1.00  0.00           D
ATOM    150  DE1 PHE A  10      -3.414  -8.731 -27.585  1.00  0.00           D
ATOM    151  DE2 PHE A  10      -3.769  -7.835 -23.433  1.00  0.00           D
ATOM    152  DZ  PHE A  10      -2.379  -8.460 -25.367  1.00  0.00           D
ATOM    153  N   TYR A  11     -10.345  -5.616 -26.312  1.00  0.00           N
ATOM    154  CA  TYR A  11     -11.751  -5.579 -26.697  1.00  0.00           C
ATOM    155  C   TYR A  11     -11.995  -4.659 -27.886  1.00  0.00           C
ATOM    156  O   TYR A  11     -12.913  -4.906 -28.676  1.00  0.00           O
ATOM    157  CB  TYR A  11     -12.610  -5.139 -25.511  1.00  0.00           C
ATOM    158  CG  TYR A  11     -12.819  -6.218 -24.471  1.00  0.00           C
ATOM    159  CD1 TYR A  11     -12.576  -7.553 -24.768  1.00  0.00           C
ATOM    160  CD2 TYR A  11     -13.261  -5.901 -23.193  1.00  0.00           C
ATOM    161  CE1 TYR A  11     -12.766  -8.541 -23.821  1.00  0.00           C
ATOM    162  CE2 TYR A  11     -13.454  -6.883 -22.240  1.00  0.00           C
ATOM    163  CZ  TYR A  11     -13.205  -8.201 -22.559  1.00  0.00           C
ATOM    164  OH  TYR A  11     -13.396  -9.182 -21.613  1.00  0.00           O
ATOM    165  D   TYR A  11     -10.120  -5.067 -25.482  1.00  0.00           D
ATOM    166  DA  TYR A  11     -12.059  -6.569 -27.026  1.00  0.00           D
ATOM    167  DB2 TYR A  11     -12.126  -4.294 -25.021  1.00  0.00           D
ATOM    168  DB3 TYR A  11     -13.590  -4.839 -25.880  1.00  0.00           D
ATOM    169  DD1 TYR A  11     -12.232  -7.838 -25.749  1.00  0.00           D
ATOM    170  DD2 TYR A  11     -13.457  -4.870 -22.940  1.00  0.00           D
ATOM    171  DE1 TYR A  11     -12.572  -9.574 -24.068  1.00  0.00           D
ATOM    172  DE2 TYR A  11     -13.798  -6.619 -21.251  1.00  0.00           D
ATOM    173  DH  TYR A  11     -13.707  -8.783 -20.774  1.00  0.00           D
ATOM    174  N   TRP A  12     -11.194  -3.602 -28.031  1.00  0.00           N
ATOM    175  CA  TRP A  12     -11.371  -2.680 -29.147  1.00  0.00           C
ATOM    176  C   TRP A  12     -10.822  -3.245 -30.451  1.00  0.00           C
ATOM    177  O   TRP A  12     -11.324  -2.905 -31.528  1.00  0.00           O
ATOM    178  CB  TRP A  12     -10.703  -1.340 -28.835  1.00  0.00           C
ATOM    179  CG  TRP A  12     -11.507  -0.468 -27.920  1.00  0.00           C
ATOM    180  CD1 TRP A  12     -11.397  -0.382 -26.563  1.00  0.00           C
ATOM    181  CD2 TRP A  12     -12.545   0.445 -28.297  1.00  0.00           C
ATOM    182  NE1 TRP A  12     -12.302   0.527 -26.071  1.00  0.00           N
ATOM    183  CE2 TRP A  12     -13.019   1.049 -27.116  1.00  0.00           C
ATOM    184  CE3 TRP A  12     -13.120   0.810 -29.519  1.00  0.00           C
ATOM    185  CZ2 TRP A  12     -14.040   1.997 -27.120  1.00  0.00           C
ATOM    186  CZ3 TRP A  12     -14.133   1.751 -29.520  1.00  0.00           C
ATOM    187  CH2 TRP A  12     -14.583   2.334 -28.329  1.00  0.00           C
ATOM    188  D   TRP A  12     -10.427  -3.362 -27.402  1.00  0.00           D
ATOM    189  DA  TRP A  12     -12.437  -2.497 -29.286  1.00  0.00           D
ATOM    190  DB2 TRP A  12      -9.742  -1.529 -28.357  1.00  0.00           D
ATOM    191  DB3 TRP A  12     -10.552  -0.796 -29.768  1.00  0.00           D
ATOM    192  DD1 TRP A  12     -10.700  -0.946 -25.963  1.00  0.00           D
ATOM    193  DE1 TRP A  12     -12.421   0.774 -25.088  1.00  0.00           D
ATOM    194  DE3 TRP A  12     -12.780   0.366 -30.443  1.00  0.00           D
ATOM    195  DH2 TRP A  12     -15.376   3.066 -28.366  1.00  0.00           D
ATOM    196  DZ2 TRP A  12     -14.389   2.448 -26.203  1.00  0.00           D
ATOM    197  DZ3 TRP A  12     -14.585   2.042 -30.457  1.00  0.00           D
ATOM    198  N   HIS A  13      -9.801  -4.102 -30.378  1.00  0.00           N
ATOM    199  CA  HIS A  13      -9.227  -4.680 -31.587  1.00  0.00           C
ATOM    200  C   HIS A  13     -10.095  -5.793 -32.159  1.00  0.00           C
ATOM    201  O   HIS A  13     -10.031  -6.065 -33.363  1.00  0.00           O
ATOM    202  CB  HIS A  13      -7.820  -5.207 -31.301  1.00  0.00           C
ATOM    203  CG  HIS A  13      -6.792  -4.131 -31.142  1.00  0.00           C
ATOM    204  ND1 HIS A  13      -6.302  -3.406 -32.207  1.00  0.00           N
ATOM    205  CD2 HIS A  13      -6.161  -3.656 -30.042  1.00  0.00           C
ATOM    206  CE1 HIS A  13      -5.414  -2.531 -31.770  1.00  0.00           C
ATOM    207  NE2 HIS A  13      -5.310  -2.662 -30.459  1.00  0.00           N
ATOM    208  D   HIS A  13      -9.359  -4.409 -29.511  1.00  0.00           D
ATOM    209  DA  HIS A  13      -9.144  -3.900 -32.344  1.00  0.00           D
ATOM    210  DB2 HIS A  13      -7.843  -5.785 -30.377  1.00  0.00           D
ATOM    211  DB3 HIS A  13      -7.509  -5.845 -32.128  1.00  0.00           D
ATOM    212  DD2 HIS A  13      -6.301  -3.995 -29.026  1.00  0.00           D
ATOM    213  DE1 HIS A  13      -4.866  -1.828 -32.380  1.00  0.00           D
ATOM    214  DE2 HIS A  13      -4.697  -2.115 -29.855  1.00  0.00           D
ATOM    215  N   LYS A  14     -10.905  -6.444 -31.322  1.00  0.00           N
ATOM    216  CA  LYS A  14     -11.763  -7.520 -31.805  1.00  0.00           C
ATOM    217  C   LYS A  14     -12.981  -6.978 -32.543  1.00  0.00           C
ATOM    218  O   LYS A  14     -13.417  -7.564 -33.540  1.00  0.00           O
ATOM    219  CB  LYS A  14     -12.196  -8.410 -30.640  1.00  0.00           C
ATOM    220  CG  LYS A  14     -11.091  -9.298 -30.092  1.00  0.00           C
ATOM    221  CD  LYS A  14     -11.589 -10.150 -28.936  1.00  0.00           C
ATOM    222  CE  LYS A  14     -10.476 -11.017 -28.371  1.00  0.00           C
ATOM    223  NZ  LYS A  14     -10.943 -11.837 -27.219  1.00  0.00           N
ATOM    224  D   LYS A  14     -10.987  -6.253 -30.324  1.00  0.00           D
ATOM    225  DA  LYS A  14     -11.196  -8.136 -32.503  1.00  0.00           D
ATOM    226  DB2 LYS A  14     -12.546  -7.775 -29.826  1.00  0.00           D
ATOM    227  DB3 LYS A  14     -13.006  -9.057 -30.976  1.00  0.00           D
ATOM    228  DD2 LYS A  14     -11.954  -9.500 -28.141  1.00  0.00           D
ATOM    229  DD3 LYS A  14     -12.387 -10.804 -29.288  1.00  0.00           D
ATOM    230  DE2 LYS A  14     -10.119 -11.693 -29.148  1.00  0.00           D
ATOM    231  DE3 LYS A  14      -9.663 -10.378 -28.026  1.00  0.00           D
ATOM    232  DG2 LYS A  14     -10.739  -9.963 -30.881  1.00  0.00           D
ATOM    233  DG3 LYS A  14     -10.273  -8.675 -29.731  1.00  0.00           D
ATOM    234  DZ1 LYS A  14     -10.160 -12.418 -26.856  1.00  0.00           D
ATOM    235  DZ2 LYS A  14     -11.286 -11.217 -26.458  1.00  0.00           D
ATOM    236  DZ3 LYS A  14     -11.717 -12.463 -27.519  1.00  0.00           D
ATOM    237  N   ARG A  15     -13.543  -5.865 -32.069  1.00  0.00           N
ATOM    238  CA  ARG A  15     -14.709  -5.275 -32.714  1.00  0.00           C
ATOM    239  C   ARG A  15     -14.360  -4.533 -33.997  1.00  0.00           C
ATOM    240  O   ARG A  15     -15.237  -4.351 -34.848  1.00  0.00           O
ATOM    241  CB  ARG A  15     -15.421  -4.324 -31.749  1.00 10.00           C
ATOM    242  CG  ARG A  15     -16.040  -5.012 -30.543  1.00 10.00           C
ATOM    243  CD  ARG A  15     -17.207  -5.897 -30.950  1.00 10.00           C
ATOM    244  NE  ARG A  15     -18.309  -5.123 -31.513  1.00 10.00           N
ATOM    245  CZ  ARG A  15     -19.293  -5.644 -32.240  1.00 10.00           C
ATOM    246  NH1 ARG A  15     -19.314  -6.945 -32.495  1.00 10.00           N
ATOM    247  NH2 ARG A  15     -20.256  -4.864 -32.712  1.00 10.00           N
ATOM    248  D   ARG A  15     -13.215  -5.356 -31.248  1.00  0.00           D
ATOM    249  DA  ARG A  15     -15.400  -6.073 -32.981  1.00  0.00           D
ATOM    250  DB2 ARG A  15     -14.699  -3.595 -31.381  1.00 10.00           D
ATOM    251  DB3 ARG A  15     -16.219  -3.812 -32.287  1.00 10.00           D
ATOM    252  DD2 ARG A  15     -16.877  -6.620 -31.694  1.00 10.00           D
ATOM    253  DD3 ARG A  15     -17.580  -6.417 -30.067  1.00 10.00           D
ATOM    254  DE  ARG A  15     -18.325  -4.118 -31.338  1.00 10.00           D
ATOM    255  DG2 ARG A  15     -15.289  -5.637 -30.060  1.00 10.00           D
ATOM    256  DG3 ARG A  15     -16.409  -4.258 -29.848  1.00 10.00           D
ATOM    257 DH11 ARG A  15     -18.579  -7.553 -32.136  1.00 10.00           D
ATOM    258 DH12 ARG A  15     -20.071  -7.340 -33.053  1.00 10.00           D
ATOM    259 DH21 ARG A  15     -20.242  -3.863 -32.518  1.00 10.00           D
ATOM    260 DH22 ARG A  15     -21.010  -5.265 -33.270  1.00 10.00           D
ATOM    261  N   GLN A  16     -13.107  -4.104 -34.155  1.00  0.00           N
ATOM    262  CA  GLN A  16     -12.715  -3.387 -35.363  1.00  0.00           C
ATOM    263  C   GLN A  16     -12.453  -4.341 -36.522  1.00  0.00           C
ATOM    264  O   GLN A  16     -12.768  -4.023 -37.674  1.00  0.00           O
ATOM    265  CB  GLN A  16     -11.477  -2.531 -35.087  1.00  0.00           C
ATOM    266  CG  GLN A  16     -11.109  -1.586 -36.219  1.00  0.00           C
ATOM    267  CD  GLN A  16      -9.920  -0.708 -35.881  1.00  0.00           C
ATOM    268  OE1 GLN A  16      -9.334  -0.824 -34.804  1.00  0.00           O
ATOM    269  NE2 GLN A  16      -9.557   0.177 -36.802  1.00  0.00           N
ATOM    270  D   GLN A  16     -12.356  -4.235 -33.477  1.00  0.00           D
ATOM    271  DA  GLN A  16     -13.525  -2.719 -35.656  1.00  0.00           D
ATOM    272  DB2 GLN A  16     -11.660  -1.928 -34.198  1.00  0.00           D
ATOM    273  DB3 GLN A  16     -10.626  -3.191 -34.916  1.00  0.00           D
ATOM    274  DG2 GLN A  16     -10.856  -2.171 -37.103  1.00  0.00           D
ATOM    275  DG3 GLN A  16     -11.959  -0.937 -36.431  1.00  0.00           D
ATOM    276 DE21 GLN A  16     -10.071   0.239 -37.681  1.00  0.00           D
ATOM    277 DE22 GLN A  16      -8.764   0.795 -36.631  1.00  0.00           D
ATOM    278  N   ASN A  17     -11.882  -5.514 -36.238  1.00  0.00           N
ATOM    279  CA  ASN A  17     -11.600  -6.473 -37.300  1.00  0.00           C
ATOM    280  C   ASN A  17     -12.869  -7.154 -37.797  1.00  0.00           C
ATOM    281  O   ASN A  17     -12.953  -7.519 -38.975  1.00  0.00           O
ATOM    282  CB  ASN A  17     -10.595  -7.517 -36.813  1.00  0.00           C
ATOM    283  CG  ASN A  17      -9.203  -6.944 -36.631  1.00  0.00           C
ATOM    284  OD1 ASN A  17      -8.725  -6.169 -37.460  1.00  0.00           O
ATOM    285  ND2 ASN A  17      -8.544  -7.324 -35.543  1.00  0.00           N
ATOM    286  D   ASN A  17     -11.610  -5.821 -35.304  1.00  0.00           D
ATOM    287  DA  ASN A  17     -11.152  -5.945 -38.142  1.00  0.00           D
ATOM    288  DB2 ASN A  17     -10.927  -7.909 -35.852  1.00  0.00           D
ATOM    289  DB3 ASN A  17     -10.536  -8.322 -37.545  1.00  0.00           D
ATOM    290 DD21 ASN A  17      -7.603  -6.971 -35.367  1.00  0.00           D
ATOM    291 DD22 ASN A  17      -8.979  -7.968 -34.883  1.00  0.00           D
ATOM    292  N   GLU A  18     -13.860  -7.335 -36.923  1.00  0.00           N
ATOM    293  CA  GLU A  18     -15.108  -7.974 -37.320  1.00  0.00           C
ATOM    294  C   GLU A  18     -16.016  -7.048 -38.118  1.00  0.00           C
ATOM    295  O   GLU A  18     -16.891  -7.536 -38.842  1.00  0.00           O
ATOM    296  CB  GLU A  18     -15.854  -8.487 -36.086  1.00  0.00           C
ATOM    297  CG  GLU A  18     -15.201  -9.688 -35.421  1.00  0.00           C
ATOM    298  CD  GLU A  18     -15.961 -10.160 -34.197  1.00  0.00           C
ATOM    299  OE1 GLU A  18     -16.936  -9.485 -33.803  1.00  0.00           O
ATOM    300  OE2 GLU A  18     -15.585 -11.207 -33.629  1.00  0.00           O
ATOM    301  D   GLU A  18     -13.827  -7.052 -35.944  1.00  0.00           D
ATOM    302  DA  GLU A  18     -14.876  -8.833 -37.949  1.00  0.00           D
ATOM    303  DB2 GLU A  18     -15.904  -7.686 -35.349  1.00  0.00           D
ATOM    304  DB3 GLU A  18     -16.862  -8.778 -36.382  1.00  0.00           D
ATOM    305  DG2 GLU A  18     -15.163 -10.512 -36.133  1.00  0.00           D
ATOM    306  DG3 GLU A  18     -14.192  -9.417 -35.109  1.00  0.00           D
ATOM    307  N   ASP A  19     -15.832  -5.734 -38.003  1.00  0.00           N
ATOM    308  CA  ASP A  19     -16.656  -4.779 -38.735  1.00  0.00           C
ATOM    309  C   ASP A  19     -16.155  -4.553 -40.156  1.00  0.00           C
ATOM    310  O   ASP A  19     -16.962  -4.402 -41.080  1.00  0.00           O
ATOM    311  CB  ASP A  19     -16.711  -3.446 -37.984  1.00  0.00           C
ATOM    312  CG  ASP A  19     -17.674  -2.461 -38.616  1.00  0.00           C
ATOM    313  OD1 ASP A  19     -18.900  -2.644 -38.463  1.00  0.00           O
ATOM    314  OD2 ASP A  19     -17.206  -1.503 -39.267  1.00  0.00           O
ATOM    315  D   ASP A  19     -15.122  -5.302 -37.412  1.00  0.00           D
ATOM    316  DA  ASP A  19     -17.672  -5.168 -38.798  1.00  0.00           D
ATOM    317  DB2 ASP A  19     -17.038  -3.628 -36.960  1.00  0.00           D
ATOM    318  DB3 ASP A  19     -15.718  -2.996 -37.985  1.00  0.00           D
ATOM    319  N   SER A  20     -14.835  -4.526 -40.351  1.00  0.00           N
ATOM    320  CA  SER A  20     -14.273  -4.316 -41.679  1.00  0.00           C
ATOM    321  C   SER A  20     -14.330  -5.566 -42.546  1.00  0.00           C
ATOM    322  O   SER A  20     -14.281  -5.452 -43.776  1.00  0.00           O
ATOM    323  CB  SER A  20     -12.825  -3.834 -41.567  1.00  0.00           C
ATOM    324  OG  SER A  20     -12.244  -3.664 -42.848  1.00  0.00           O
ATOM    325  D   SER A  20     -14.139  -4.645 -39.615  1.00  0.00           D
ATOM    326  DA  SER A  20     -14.845  -3.537 -42.182  1.00  0.00           D
ATOM    327  DB2 SER A  20     -12.809  -2.879 -41.042  1.00  0.00           D
ATOM    328  DB3 SER A  20     -12.248  -4.573 -41.012  1.00  0.00           D
ATOM    329  DG  SER A  20     -11.318  -3.355 -42.758  1.00  0.00           D
ATOM    330  N   THR A  21     -14.432  -6.745 -41.942  1.00  0.00           N
ATOM    331  CA  THR A  21     -14.493  -7.990 -42.698  1.00  0.00           C
ATOM    332  C   THR A  21     -15.918  -8.530 -42.751  1.00  0.00           C
ATOM    333  O   THR A  21     -16.459  -8.778 -43.829  1.00  0.00           O
ATOM    334  CB  THR A  21     -13.569  -9.064 -42.093  1.00  0.00           C
ATOM    335  OG1 THR A  21     -13.970  -9.340 -40.746  1.00  0.00           O
ATOM    336  CG2 THR A  21     -12.124  -8.589 -42.101  1.00  0.00           C
ATOM    337  D   THR A  21     -14.475  -6.871 -40.931  1.00  0.00           D
ATOM    338  DA  THR A  21     -14.165  -7.805 -43.721  1.00  0.00           D
ATOM    339  DB  THR A  21     -13.636  -9.976 -42.686  1.00  0.00           D
ATOM    340  DG1 THR A  21     -13.895  -8.529 -40.201  1.00  0.00           D
ATOM    341 DG21 THR A  21     -11.476  -9.362 -41.689  1.00  0.00           D
ATOM    342 DG22 THR A  21     -11.810  -8.370 -43.122  1.00  0.00           D
ATOM    343 DG23 THR A  21     -12.025  -7.686 -41.499  1.00  0.00           D
TER
END
"""

loop = [
  (m1_str, 1, [[[4,5], [9]]]),
  (m2_str, 2, [[[4,5], [9]], [[4,5], [10]]]),
  (m3_str, 2, [[[4,6], [7]], [[4,8], [9]]]),
  (m4_str, 6, [[[4, 6], [7, 8, 9]], [[1, 0], [10, 11, 12]]]),
  (m5_str, 5, [[[4,6], [7]], [[4,8], [9]], [[14,16], [17,18,19]]]),
  (m6_str, 4, [[[1,0], [11,12,13]], [[23,22],[34]]]),
  (m7_str, 4, [[[0, 1], [5]], [[1, 0], [2, 3, 4]]]), #[[[0, 1], [2, 3, 4]], [[1, 0], [5]]]),
  (m8_str, 1, [[[1, 0], [12]]]),
  (m9_str, 4, [[[4, 6], [10, 11, 12]], [[4, 5], [9]]]),
  (m10_str,7, [[[4, 6], [13, 14, 15]], [[5, 7], [16, 17, 18]], [[1, 0], [8]]]),
  (m11_str,10,[[[4, 6], [10, 11, 12]], [[4, 5], [9]], [[17, 19], [26, 27, 28]], [[18, 20], [29, 30, 31]]]),
  (m12_str,1, [[[4, 5], [9]]]),
  (m13_str,5, [[[4, 6], [7]], [[4, 8], [9]], [[14, 16], [17, 18, 19]]]),
  (m14_str,7, [[[1, 2], [8, 9, 10]], [[1, 3], [11]], [[1, 0], [5, 6, 7]]]),
  (m15_str,1, [[[1, 0], [11]]]),
  (m16_str,0, []),
  (m17_str,1, [[[1, 0], [11]]]), # no shortcut: (m17_str,1, [[[1, 0], [11]]])
  (m18_str,0, []),
  (m19_str,3, [[[6, 7], [15, 16, 17]]])
  ]

def exercise_00(debug=True):
  mon_lib_srv = monomer_library.server.server()
  ener_lib = monomer_library.server.ener_lib()
  for i, l in enumerate(loop):
    #print(i,"*"*10)
    ppf = monomer_library.pdb_interpretation.process(
      mon_lib_srv    = mon_lib_srv,
      ener_lib       = ener_lib,
      raw_records    = flex.std_string(l[0].splitlines()),
      force_symmetry = True)
    geometry = ppf.geometry_restraints_manager(
      show_energies      = False,
      plain_pairs_radius = 5.0)
    restraints_manager = mmtbx.restraints.manager(
      geometry = geometry, normalization = False)
    ph = ppf.all_chain_proxies.pdb_hierarchy
    atoms = ph.atoms()
    ppf.all_chain_proxies.pdb_inp.write_pdb_file(file_name = "m%s.pdb"%str(i))
    sel = hydrogens.rotatable(pdb_hierarchy=ph, mon_lib_srv=mon_lib_srv,
      restraints_manager = restraints_manager, log=None, use_shortcut=False)
    #for it in sel:
    #  print(atoms[it[0][0]].i_seq,atoms[it[0][1]].i_seq, "<>", [atoms[j].i_seq for j in it[1]])
    #  print(atoms[it[0][0]].name,atoms[it[0][1]].name, "<>", [atoms[j].name for j in it[1]])
    #  print()
    assert sel == l[2], "%s != %s" % (sel, l[2])
    assert hydrogens.count_rotatable(sel) == l[1]

def exercise_01():
  pdb_inp = iotbx.pdb.input(source_info=None, lines=m5_str)
  ph = pdb_inp.construct_hierarchy()
  xrs_answer = pdb_inp.xray_structure_simple()
  xrs_answer.switch_to_neutron_scattering_dictionary()
  ph.write_pdb_file(file_name = "answer.pdb")
  f_calc = xrs_answer.structure_factors(d_min=1).f_calc()
  fft_map = f_calc.fft_map(resolution_factor=0.1)
  fft_map.apply_sigma_scaling()
  map_data = fft_map.real_map_unpadded()
  #
  mon_lib_srv = monomer_library.server.server()
  ener_lib = monomer_library.server.ener_lib()
  ppf = monomer_library.pdb_interpretation.process(
    mon_lib_srv    = mon_lib_srv,
    ener_lib       = ener_lib,
    raw_records    = flex.std_string(m5_str_HD_rotated.splitlines()),
    force_symmetry = True)
  geometry = ppf.geometry_restraints_manager(
    show_energies      = False,
    plain_pairs_radius = 5.0)
  restraints_manager = mmtbx.restraints.manager(
    geometry = geometry, normalization = False)
  xrs = ppf.all_chain_proxies.pdb_inp.xray_structure_simple()
  ph = ppf.all_chain_proxies.pdb_hierarchy
  ph.write_pdb_file(file_name = "poor.pdb")
  xrs.switch_to_neutron_scattering_dictionary()
  f_calc_poor = f_calc.structure_factors_from_scatterers(
    xray_structure = xrs).f_calc()
  #
  rotatable_h_selection = hydrogens.rotatable(
    pdb_hierarchy      = ph,
    mon_lib_srv        = mon_lib_srv,
    restraints_manager = restraints_manager,
    log                = None)
  hydrogens.fit_rotatable(pdb_hierarchy=ph, xray_structure=xrs,
    map_data=map_data,rotatable_h_selection=rotatable_h_selection)
  ph.write_pdb_file(file_name = "result.pdb")
  #
  f_calc_fixed = f_calc.structure_factors_from_scatterers(
    xray_structure = xrs).f_calc()
  def r_factor(x,y):
    n = flex.sum( flex.abs( abs(x).data() - abs(y).data() ) )
    d = flex.sum( flex.abs( abs(x).data() + abs(y).data() ) )/2
    return n/d
  assert r_factor(f_calc, f_calc_poor) > 0.2
  assert r_factor(f_calc, f_calc_fixed) < 0.015

def exercise_02(debug=False):
  mon_lib_srv = monomer_library.server.server()
  ener_lib = monomer_library.server.ener_lib()
  ppf = monomer_library.pdb_interpretation.process(
    mon_lib_srv    = mon_lib_srv,
    ener_lib       = ener_lib,
    raw_records    = flex.std_string(exercise_02_str.splitlines()),
    force_symmetry = True)
  geometry = ppf.geometry_restraints_manager(
    show_energies      = False,
    plain_pairs_radius = 5.0)
  restraints_manager = mmtbx.restraints.manager(
    geometry = geometry, normalization = False)
  ph = ppf.all_chain_proxies.pdb_hierarchy
  sel = hydrogens.rotatable(pdb_hierarchy=ph, mon_lib_srv=mon_lib_srv,
    restraints_manager = restraints_manager, log = None)
  n_rot_h = hydrogens.count_rotatable(sel)
  assert n_rot_h == 43, n_rot_h

def exercise_03():
  for pdb_str in [all_aa_all_h, all_aa_all_d]:
    pdb_inp = iotbx.pdb.input(source_info=None, lines=all_aa_all_d)
    m = mmtbx.model.manager(model_input = pdb_inp, log=null_out())
    m.process(make_restraints=True)
    r1 = mmtbx.hydrogens.rotatable(
      pdb_hierarchy      = m.get_hierarchy(),
      mon_lib_srv        = m.get_mon_lib_srv(),
      restraints_manager = m.get_restraints_manager(),
      log                = null_out(),
      use_shortcut       = True)
    r2 = mmtbx.hydrogens.rotatable(
      pdb_hierarchy      = m.get_hierarchy(),
      mon_lib_srv        = m.get_mon_lib_srv(),
      restraints_manager = m.get_restraints_manager(),
      log                = null_out(),
      use_shortcut       = False)
  # Ideally this is what it should be. But dynamic modifications, adding planes
  # etc make it hard to achieve. According to Nigel: H in ASP, plane is added
  # only if HD2/DD2 is present.
  #assert r1 == r2

if (__name__ == "__main__"):
  t0 = time.time()
  exercise_00()
  exercise_01()
  exercise_02()
  exercise_03()
  print("Total time: %-8.4f"%(time.time()-t0))
  print("OK")
