#!/bin/bash
set -xe

# Get an updated config.sub and config.guess
cp $BUILD_PREFIX/share/gnuconfig/config.* ./modules/ccp4io/libccp4/build-aux
cp $BUILD_PREFIX/share/gnuconfig/config.* ./modules/cbflib/libtool
cp $BUILD_PREFIX/share/gnuconfig/config.* ./modules/cbflib

# copy autogenerated header to avoid binary compiler check on osx-arm64
if [[ "$CC" == *"arm64"* || "$CC" == *"aarch64"* || "$CC" == *"pc64le"* ]]; then
  mkdir -p build/include/boost_adaptbx
  cp ${RECIPE_DIR}/type_id_eq.h build/include/boost_adaptbx/type_id_eq.h
fi

# link bootstrap.py
ln -s modules/cctbx_project/libtbx/auto_build/bootstrap.py

# remove extra source code
rm -fr ./modules/boost
rm -fr ./modules/eigen
rm -fr ./modules/scons

# build
${PYTHON} bootstrap.py build --builder=cctbx --use-conda ${PREFIX} --nproc ${CPU_COUNT} \
  --config-flags="--compiler=conda" --config-flags="--use_environment_flags" \
  --config-flags="--enable_cxx11" --config-flags="--no_bin_python" \
  --config-flags="--skip_phenix_dispatchers"
cd build
./bin/libtbx.configure cma_es crys3d fable rstbx spotinder
./bin/libtbx.scons -j ${CPU_COUNT}
./bin/libtbx.scons -j ${CPU_COUNT}
cd ..

# remove dxtbx and cbflib
rm -fr ./build/*cbflib*
rm -fr ./build/lib/cbflib*
rm -fr ./build/lib/*dxtbx*
rm -fr ./modules/dxtbx
rm -fr ./modules/cbflib
./build/bin/libtbx.python ${RECIPE_DIR}/clean_env.py

# remove extra source files (C, C++, Fortran, CUDA)
cd build
find . -name "*.c" -type f -delete
find . -name "*.cpp" -type f -delete
find . -name "*.cu" -type f -delete
find . -name "*.f" -type f -delete
cd ../modules
find . -name "*.c" -type f -delete
find . -name "*.cpp" -type f -delete
find . -name "*.cu" -type f -delete
find . -name "*.f" -type f -delete
cd ..

# remove intermediate objects in build directory
cd build
find . -name "*.o" -type f -delete
cd ..

# fix rpath on macOS because libraries and extensions will be in different locations
if [[ ! -z "$MACOSX_DEPLOYMENT_TARGET" ]]; then
  echo Fixing rpath:
  ${PYTHON} ${RECIPE_DIR}/fix_macos_rpath.py
fi

# copy files in build
echo Copying build
EXTRA_CCTBX_DIR=${PREFIX}/share/cctbx
mkdir -p ${EXTRA_CCTBX_DIR}
CCTBX_CONDA_BUILD=./modules/cctbx_project/libtbx/auto_build/conda_build
./build/bin/libtbx.python ${CCTBX_CONDA_BUILD}/install_build.py --preserve-egg-dir

# copy version and copyright files
${PYTHON} ./modules/cctbx_project/libtbx/version.py --version=${PKG_VERSION}
cp ./modules/cctbx_project/COPYRIGHT.txt ${EXTRA_CCTBX_DIR}
cp ./modules/cctbx_project/cctbx_version.txt ${EXTRA_CCTBX_DIR}
cp ./modules/cctbx_project/cctbx_version.h ${PREFIX}/include/cctbx
cd ./modules/cctbx_project
${PYTHON} setup.py install
cd ../..

# copy libtbx_env and update dispatchers
echo Copying libtbx_env
./build/bin/libtbx.python ${CCTBX_CONDA_BUILD}/update_libtbx_env.py
if [[ -f "${PREFIX}/python.app/Contents/MacOS/python" ]]; then
  ${PREFIX}/python.app/Contents/MacOS/python ${CCTBX_CONDA_BUILD}/update_libtbx_env.py
else
  ${PYTHON} ${CCTBX_CONDA_BUILD}/update_libtbx_env.py
fi

# copy annlib headers and then clean up annlib
cp -a ./modules/annlib/include/ANN ${EXTRA_CCTBX_DIR}/annlib_adaptbx/include/
rm -fr ./build/annlib
rm -fr ./modules/annlib

# remove extra copies of dispatchers
echo Removing some duplicate dispatchers
find ${PREFIX}/bin -name "*show_dist_paths" -not -name "libtbx.show_dist_paths" -type f -delete
find ${PREFIX}/bin -name "*show_build_path" -not -name "libtbx.show_build_path" -type f -delete
