
from __future__ import division
# Phi/Psi corrections in Angstrom and Radials
mean_devs = {
  (-110, 10) : (0.091918, 1.352457), # 10
  (-100, -10) : (0.060645, 1.649950), # 30
  (-100, 0) : (0.064179, 1.639073), # 62
  (-100, 10) : (0.063725, 1.564583), # 58
  (-100, 20) : (0.081505, 1.455948), # 51
  (-100, 30) : (0.065837, 1.325381), # 36
  (-100, 50) : (0.087832, 1.172422), # 11
  (-100, 150) : (0.088871, 1.488196), # 13
  (-100, 160) : (0.077718, 1.540391), # 31
  (-100, 170) : (0.098643, 1.362199), # 35
  (-90, -180) : (0.068752, 1.232704), # 27
  (-90, -170) : (0.089792, 1.195701), # 16
  (-90, -20) : (0.062294, 1.865343), # 50
  (-90, -10) : (0.041429, 1.902076), # 176
  (-90, 0) : (0.049688, 1.650217), # 332
  (-90, 10) : (0.045193, 1.642799), # 242
  (-90, 20) : (0.041346, 1.607879), # 109
  (-90, 30) : (0.039670, 1.584264), # 38
  (-90, 40) : (0.047507, 1.529254), # 18
  (-90, 50) : (0.021312, 1.441359), # 30
  (-90, 60) : (0.018737, 1.049525), # 39
  (-90, 70) : (0.014214, 0.661171), # 38
  (-90, 80) : (0.034970, 1.144122), # 17
  (-90, 100) : (0.030995, 1.086535), # 10
  (-90, 110) : (0.033805, 1.376524), # 14
  (-90, 120) : (0.038184, 1.494090), # 38
  (-90, 130) : (0.036087, 1.554489), # 74
  (-90, 140) : (0.057363, 1.630193), # 126
  (-90, 150) : (0.069342, 1.541631), # 192
  (-90, 160) : (0.068722, 1.556901), # 201
  (-90, 170) : (0.070752, 1.367089), # 169
  (-90, 180) : (0.067576, 1.383182), # 49
  (-80, -180) : (0.051240, 1.305154), # 84
  (-80, -170) : (0.040300, 1.246082), # 47
  (-80, -160) : (0.013787, -0.043572), # 13
  (-80, -40) : (0.039637, 2.815404), # 13
  (-80, -30) : (0.031489, 2.706108), # 90
  (-80, -20) : (0.027203, 2.562033), # 385
  (-80, -10) : (0.033108, 2.169340), # 680
  (-80, 0) : (0.031129, 2.215753), # 454
  (-80, 10) : (0.024574, 2.671618), # 146
  (-80, 20) : (0.022342, 2.795569), # 43
  (-80, 30) : (0.019173, 2.733091), # 31
  (-80, 40) : (0.012886, -2.977515), # 39
  (-80, 50) : (0.003854, 2.831913), # 130
  (-80, 60) : (0.002822, -2.672865), # 292
  (-80, 70) : (0.003467, 0.804835), # 308
  (-80, 80) : (0.010602, 1.454806), # 129
  (-80, 90) : (0.002813, 2.136069), # 48
  (-80, 100) : (0.027193, 1.386346), # 58
  (-80, 110) : (0.032494, 1.512464), # 85
  (-80, 120) : (0.032883, 1.529866), # 138
  (-80, 130) : (0.038336, 1.691542), # 326
  (-80, 140) : (0.045539, 1.692478), # 669
  (-80, 150) : (0.053648, 1.660015), # 1107
  (-80, 160) : (0.058678, 1.583413), # 1289
  (-80, 170) : (0.061150, 1.484021), # 822
  (-80, 180) : (0.052682, 1.396727), # 179
  (-70, -180) : (0.036062, 1.643954), # 35
  (-70, -170) : (0.021988, 1.586032), # 21
  (-70, -50) : (0.035262, -2.608024), # 22
  (-70, -40) : (0.030074, -3.135490), # 168
  (-70, -30) : (0.029227, 3.011066), # 1063
  (-70, -20) : (0.029686, 2.870614), # 1802
  (-70, -10) : (0.028964, 2.909291), # 1288
  (-70, 0) : (0.031355, -2.906938), # 193
  (-70, 10) : (0.048450, -2.435418), # 15
  (-70, 50) : (0.058593, -2.131437), # 28
  (-70, 60) : (0.044925, -2.117105), # 48
  (-70, 70) : (0.021435, -2.242025), # 36
  (-70, 80) : (0.008524, 1.963758), # 17
  (-70, 90) : (0.011229, 1.864535), # 19
  (-70, 100) : (0.014265, 1.985003), # 30
  (-70, 110) : (0.018950, 1.608031), # 84
  (-70, 120) : (0.031935, 1.813138), # 238
  (-70, 130) : (0.036287, 1.873324), # 810
  (-70, 140) : (0.044327, 1.827230), # 2235
  (-70, 150) : (0.048446, 1.799276), # 3530
  (-70, 160) : (0.049340, 1.743002), # 2774
  (-70, 170) : (0.048698, 1.637056), # 921
  (-70, 180) : (0.047262, 1.599714), # 109
  (-60, -50) : (0.027575, -2.603555), # 281
  (-60, -40) : (0.021686, 3.127675), # 2845
  (-60, -30) : (0.028817, 3.119899), # 4417
  (-60, -20) : (0.031132, 3.115036), # 2828
  (-60, -10) : (0.036427, -2.747398), # 438
  (-60, 0) : (0.047368, -2.645144), # 14
  (-60, 110) : (0.012995, 2.218015), # 21
  (-60, 120) : (0.024218, 1.907700), # 253
  (-60, 130) : (0.032096, 1.866465), # 1715
  (-60, 140) : (0.041328, 1.809512), # 4671
  (-60, 150) : (0.048077, 1.821774), # 4147
  (-60, 160) : (0.051060, 1.797175), # 1270
  (-60, 170) : (0.056690, 1.753189), # 132
  (-50, -60) : (0.051981, -2.251120), # 27
  (-50, -50) : (0.035811, -2.315985), # 591
  (-50, -40) : (0.022766, -2.727562), # 2538
  (-50, -30) : (0.028654, -2.756427), # 1272
  (-50, -20) : (0.035598, -2.634689), # 168
  (-50, 120) : (0.011368, 2.409818), # 218
  (-50, 130) : (0.020695, 1.942466), # 1360
  (-50, 140) : (0.030447, 1.810412), # 1820
  (-50, 150) : (0.038627, 1.715753), # 504
  (-50, 160) : (0.046254, 1.836329), # 43
  (-40, -60) : (0.070484, -2.073773), # 25
  (-40, -50) : (0.054890, -2.133911), # 110
  (-40, -40) : (0.042678, -2.313959), # 82
  (-40, 120) : (0.019602, -2.087781), # 20
  (-40, 130) : (0.008294, 2.905864), # 53
  (-40, 140) : (0.020747, 2.001922), # 20
}

if __name__ == '__main__':
  for phi_psi in [(0,0), (-60,-60)]:
    print(phi_psi, mean_devs.get(phi_psi, None))
