from __future__ import absolute_import, division, print_function
from cctbx.array_family import flex
import os
import mmtbx.model
import libtbx.load_env
from six.moves import cStringIO as StringIO
from libtbx.utils import format_cpu_times, null_out
from libtbx.test_utils import approx_equal, show_diff
import iotbx.pdb
from mmtbx.refinement import geometry_minimization
from six.moves import range

pdb_str_00="""
CRYST1  107.161  107.161   93.144  90.00  90.00 120.00 H 3           9
ATOM      1  O5'  DG A 101      30.353  -5.691  -5.826  1.00 80.00           O
ATOM      2  C5'  DG A 101      30.297  -7.106  -5.681  1.00 80.00           C
ATOM      3  C4'  DG A 101      31.674  -7.699  -5.430  1.00 80.00           C
ATOM      4  O4'  DG A 101      32.464  -7.647  -6.648  1.00 80.00           O
ATOM      5  C3'  DG A 101      32.550  -6.981  -4.410  1.00 80.00           C
ATOM      6  O3'  DG A 101      32.270  -7.276  -3.034  1.00 80.00           O
ATOM      7  C2'  DG A 101      33.901  -7.575  -4.788  1.00 80.00           C
ATOM      8  C1'  DG A 101      33.833  -7.502  -6.309  1.00 80.00           C
ATOM      9  N9   DG A 101      34.347  -6.243  -6.849  1.00 80.00           N
ATOM     10  C8   DG A 101      34.042  -5.661  -8.057  1.00 80.00           C
ATOM     11  N7   DG A 101      34.661  -4.530  -8.261  1.00 80.00           N
ATOM     12  C5   DG A 101      35.428  -4.345  -7.115  1.00 80.00           C
ATOM     13  C6   DG A 101      36.313  -3.295  -6.755  1.00 80.00           C
ATOM     14  O6   DG A 101      36.612  -2.277  -7.397  1.00 80.00           O
ATOM     15  N1   DG A 101      36.884  -3.505  -5.501  1.00 80.00           N
ATOM     16  C2   DG A 101      36.635  -4.591  -4.694  1.00 80.00           C
ATOM     17  N2   DG A 101      37.276  -4.631  -3.515  1.00 80.00           N
ATOM     18  N3   DG A 101      35.812  -5.576  -5.021  1.00 80.00           N
ATOM     19  C4   DG A 101      35.243  -5.392  -6.238  1.00 80.00           C
ATOM     20  P    DA A 102      30.891  -7.850  -2.448  1.00 80.00           P
ATOM     21  OP1  DA A 102      30.412  -8.967  -3.293  1.00 80.00           O
ATOM     22  OP2  DA A 102      30.002  -6.702  -2.162  1.00 80.00           O
ATOM     23  O5'  DA A 102      31.376  -8.460  -1.047  1.00 80.00           O
ATOM     24  C5'  DA A 102      31.097  -7.804   0.189  1.00 80.00           C
ATOM     25  C4'  DA A 102      32.133  -6.759   0.563  1.00 80.00           C
ATOM     26  O4'  DA A 102      32.644  -6.131  -0.644  1.00 80.00           O
ATOM     27  C3'  DA A 102      31.556  -5.636   1.422  1.00 80.00           C
ATOM     28  O3'  DA A 102      32.520  -5.085   2.335  1.00 80.00           O
ATOM     29  C2'  DA A 102      31.162  -4.648   0.332  1.00 80.00           C
ATOM     30  C1'  DA A 102      32.411  -4.745  -0.532  1.00 80.00           C
ATOM     31  N9   DA A 102      32.281  -4.091  -1.831  1.00 80.00           N
ATOM     32  C8   DA A 102      31.274  -4.232  -2.743  1.00 80.00           C
ATOM     33  N7   DA A 102      31.432  -3.498  -3.820  1.00 80.00           N
ATOM     34  C5   DA A 102      32.622  -2.824  -3.594  1.00 80.00           C
ATOM     35  C6   DA A 102      33.346  -1.887  -4.362  1.00 80.00           C
ATOM     36  N6   DA A 102      32.949  -1.453  -5.565  1.00 80.00           N
ATOM     37  N1   DA A 102      34.499  -1.412  -3.839  1.00 80.00           N
ATOM     38  C2   DA A 102      34.895  -1.846  -2.634  1.00 80.00           C
ATOM     39  N3   DA A 102      34.299  -2.721  -1.825  1.00 80.00           N
ATOM     40  C4   DA A 102      33.157  -3.176  -2.369  1.00 80.00           C
ATOM     41  P    DG A 103      32.892  -3.523   2.296  1.00 80.00           P
ATOM     42  OP1  DG A 103      31.640  -2.754   2.139  1.00 80.00           O
ATOM     43  OP2  DG A 103      34.006  -3.355   1.337  1.00 80.00           O
ATOM     44  O5'  DG A 103      33.448  -3.176   3.750  1.00 80.00           O
ATOM     45  C5'  DG A 103      34.359  -2.085   3.897  1.00 80.00           C
ATOM     46  C4'  DG A 103      33.856  -0.766   3.315  1.00 80.00           C
ATOM     47  O4'  DG A 103      33.647  -0.832   1.878  1.00 80.00           O
ATOM     48  C3'  DG A 103      32.546  -0.221   3.892  1.00 80.00           C
ATOM     49  O3'  DG A 103      32.798   0.912   4.728  1.00 80.00           O
ATOM     50  C2'  DG A 103      31.711   0.163   2.669  1.00 80.00           C
ATOM     51  C1'  DG A 103      32.785   0.248   1.593  1.00 80.00           C
ATOM     52  N9   DG A 103      32.290   0.224   0.218  1.00 80.00           N
ATOM     53  C8   DG A 103      31.420  -0.663  -0.371  1.00 80.00           C
ATOM     54  N7   DG A 103      31.177  -0.390  -1.626  1.00 80.00           N
ATOM     55  C5   DG A 103      31.930   0.751  -1.886  1.00 80.00           C
ATOM     56  C6   DG A 103      32.073   1.512  -3.074  1.00 80.00           C
ATOM     57  O6   DG A 103      31.547   1.330  -4.185  1.00 80.00           O
ATOM     58  N1   DG A 103      32.939   2.590  -2.882  1.00 80.00           N
ATOM     59  C2   DG A 103      33.581   2.892  -1.700  1.00 80.00           C
ATOM     60  N2   DG A 103      34.377   3.970  -1.703  1.00 80.00           N
ATOM     61  N3   DG A 103      33.453   2.187  -0.586  1.00 80.00           N
ATOM     62  C4   DG A 103      32.616   1.137  -0.755  1.00 80.00           C
ATOM     63  P    DC A 104      33.914   2.007   4.370  1.00 80.00           P
ATOM     64  OP1  DC A 104      33.746   2.431   2.963  1.00 80.00           O
ATOM     65  OP2  DC A 104      35.221   1.487   4.828  1.00 80.00           O
ATOM     66  O5'  DC A 104      33.518   3.233   5.318  1.00 80.00           O
ATOM     67  C5'  DC A 104      32.464   4.116   4.954  1.00 80.00           C
ATOM     68  C4'  DC A 104      32.995   5.260   4.108  1.00 80.00           C
ATOM     69  O4'  DC A 104      33.087   4.852   2.719  1.00 80.00           O
ATOM     70  C3'  DC A 104      32.140   6.517   4.153  1.00 80.00           C
ATOM     71  O3'  DC A 104      32.959   7.623   4.504  1.00 80.00           O
ATOM     72  C2'  DC A 104      31.561   6.667   2.748  1.00 80.00           C
ATOM     73  C1'  DC A 104      32.386   5.736   1.867  1.00 80.00           C
ATOM     74  N1   DC A 104      31.555   4.918   0.935  1.00 80.00           N
ATOM     75  C2   DC A 104      31.268   5.380  -0.358  1.00 80.00           C
ATOM     76  O2   DC A 104      31.708   6.476  -0.729  1.00 80.00           O
ATOM     77  N3   DC A 104      30.510   4.607  -1.178  1.00 80.00           N
ATOM     78  C4   DC A 104      30.047   3.428  -0.756  1.00 80.00           C
ATOM     79  N4   DC A 104      29.303   2.699  -1.599  1.00 80.00           N
ATOM     80  C5   DC A 104      30.329   2.944   0.557  1.00 80.00           C
ATOM     81  C6   DC A 104      31.078   3.711   1.357  1.00 80.00           C
ATOM     82  P    DA A 105      32.348   9.101   4.508  1.00 80.00           P
ATOM     83  OP1  DA A 105      33.057   9.891   5.540  1.00 80.00           O
ATOM     84  OP2  DA A 105      30.874   8.987   4.560  1.00 80.00           O
ATOM     85  O5'  DA A 105      32.742   9.657   3.061  1.00 80.00           O
ATOM     86  C5'  DA A 105      32.655  11.052   2.825  1.00 80.00           C
ATOM     87  C4'  DA A 105      31.977  11.333   1.502  1.00 80.00           C
ATOM     88  O4'  DA A 105      31.468  10.103   0.922  1.00 80.00           O
ATOM     89  C3'  DA A 105      30.771  12.251   1.639  1.00 80.00           C
ATOM     90  O3'  DA A 105      30.631  13.044   0.476  1.00 80.00           O
ATOM     91  C2'  DA A 105      29.635  11.242   1.738  1.00 80.00           C
ATOM     92  C1'  DA A 105      30.103  10.319   0.626  1.00 80.00           C
ATOM     93  N9   DA A 105      29.385   9.052   0.528  1.00 80.00           N
ATOM     94  C8   DA A 105      29.276   8.056   1.456  1.00 80.00           C
ATOM     95  N7   DA A 105      28.553   7.035   1.056  1.00 80.00           N
ATOM     96  C5   DA A 105      28.157   7.390  -0.224  1.00 80.00           C
ATOM     97  C6   DA A 105      27.371   6.744  -1.202  1.00 80.00           C
ATOM     98  N6   DA A 105      26.808   5.541  -1.035  1.00 80.00           N
ATOM     99  N1   DA A 105      27.180   7.393  -2.369  1.00 80.00           N
ATOM    100  C2   DA A 105      27.737   8.597  -2.550  1.00 80.00           C
ATOM    101  N3   DA A 105      28.492   9.298  -1.711  1.00 80.00           N
ATOM    102  C4   DA A 105      28.663   8.631  -0.560  1.00 80.00           C
ATOM    103  P    DG A 106      29.602  14.269   0.500  1.00 80.00           P
ATOM    104  OP1  DG A 106      30.398  15.515   0.488  1.00 80.00           O
ATOM    105  OP2  DG A 106      28.639  14.023   1.596  1.00 80.00           O
ATOM    106  O5'  DG A 106      28.803  14.154  -0.882  1.00 80.00           O
ATOM    107  C5'  DG A 106      27.826  15.145  -1.198  1.00 80.00           C
ATOM    108  C4'  DG A 106      26.772  14.584  -2.133  1.00 80.00           C
ATOM    109  O4'  DG A 106      26.868  13.141  -2.116  1.00 80.00           O
ATOM    110  C3'  DG A 106      25.340  14.942  -1.740  1.00 80.00           C
ATOM    111  O3'  DG A 106      24.833  16.023  -2.560  1.00 80.00           O
ATOM    112  C2'  DG A 106      24.552  13.634  -1.861  1.00 80.00           C
ATOM    113  C1'  DG A 106      25.585  12.567  -2.228  1.00 80.00           C
ATOM    114  N9   DG A 106      25.534  11.397  -1.358  1.00 80.00           N
ATOM    115  C8   DG A 106      25.934  11.315  -0.046  1.00 80.00           C
ATOM    116  N7   DG A 106      25.762  10.132   0.476  1.00 80.00           N
ATOM    117  C5   DG A 106      25.214   9.382  -0.557  1.00 80.00           C
ATOM    118  C6   DG A 106      24.814   8.026  -0.587  1.00 80.00           C
ATOM    119  O6   DG A 106      24.869   7.190   0.326  1.00 80.00           O
ATOM    120  N1   DG A 106      24.309   7.667  -1.836  1.00 80.00           N
ATOM    121  C2   DG A 106      24.205   8.514  -2.916  1.00 80.00           C
ATOM    122  N2   DG A 106      23.693   7.995  -4.040  1.00 80.00           N
ATOM    123  N3   DG A 106      24.575   9.786  -2.899  1.00 80.00           N
ATOM    124  C4   DG A 106      25.068  10.148  -1.691  1.00 80.00           C
ATOM    125  P    DC A 107      23.670  15.874  -3.663  1.00 80.00           P
ATOM    126  OP1  DC A 107      23.922  16.896  -4.704  1.00 80.00           O
ATOM    127  OP2  DC A 107      22.371  15.869  -2.955  1.00 80.00           O
ATOM    128  O5'  DC A 107      23.890  14.422  -4.301  1.00 80.00           O
ATOM    129  C5'  DC A 107      23.186  14.007  -5.467  1.00 80.00           C
ATOM    130  C4'  DC A 107      22.016  13.088  -5.146  1.00 80.00           C
ATOM    131  O4'  DC A 107      22.408  11.990  -4.275  1.00 80.00           O
ATOM    132  C3'  DC A 107      20.823  13.746  -4.452  1.00 80.00           C
ATOM    133  O3'  DC A 107      19.648  13.446  -5.181  1.00 80.00           O
ATOM    134  C2'  DC A 107      20.782  13.047  -3.098  1.00 80.00           C
ATOM    135  C1'  DC A 107      21.224  11.674  -3.575  1.00 80.00           C
ATOM    136  N1   DC A 107      21.443  10.667  -2.497  1.00 80.00           N
ATOM    137  C2   DC A 107      21.175   9.318  -2.763  1.00 80.00           C
ATOM    138  O2   DC A 107      20.780   8.993  -3.891  1.00 80.00           O
ATOM    139  N3   DC A 107      21.367   8.406  -1.776  1.00 80.00           N
ATOM    140  C4   DC A 107      21.795   8.797  -0.574  1.00 80.00           C
ATOM    141  N4   DC A 107      21.968   7.861   0.368  1.00 80.00           N
ATOM    142  C5   DC A 107      22.064  10.168  -0.286  1.00 80.00           C
ATOM    143  C6   DC A 107      21.873  11.060  -1.265  1.00 80.00           C
ATOM    144  P    DC A 108      18.566  14.590  -5.437  1.00 80.00           P
ATOM    145  OP1  DC A 108      19.277  15.771  -5.984  1.00 80.00           O
ATOM    146  OP2  DC A 108      17.761  14.715  -4.201  1.00 80.00           O
ATOM    147  O5'  DC A 108      17.622  13.954  -6.563  1.00 80.00           O
ATOM    148  C5'  DC A 108      16.332  13.473  -6.207  1.00 80.00           C
ATOM    149  C4'  DC A 108      16.257  11.958  -6.195  1.00 80.00           C
ATOM    150  O4'  DC A 108      17.371  11.392  -5.470  1.00 80.00           O
ATOM    151  C3'  DC A 108      15.028  11.417  -5.486  1.00 80.00           C
ATOM    152  O3'  DC A 108      13.942  11.422  -6.406  1.00 80.00           O
ATOM    153  C2'  DC A 108      15.469  10.012  -5.091  1.00 80.00           C
ATOM    154  C1'  DC A 108      16.977  10.159  -4.897  1.00 80.00           C
ATOM    155  N1   DC A 108      17.412  10.157  -3.471  1.00 80.00           N
ATOM    156  C2   DC A 108      17.296   8.999  -2.689  1.00 80.00           C
ATOM    157  O2   DC A 108      16.820   7.970  -3.182  1.00 80.00           O
ATOM    158  N3   DC A 108      17.708   9.034  -1.397  1.00 80.00           N
ATOM    159  C4   DC A 108      18.217  10.157  -0.889  1.00 80.00           C
ATOM    160  N4   DC A 108      18.608  10.144   0.389  1.00 80.00           N
ATOM    161  C5   DC A 108      18.343  11.343  -1.670  1.00 80.00           C
ATOM    162  C6   DC A 108      17.935  11.298  -2.942  1.00 80.00           C
ATOM    163  P    DT A 109      12.767  10.335  -6.352  1.00 80.00           P
ATOM    164  OP1  DT A 109      13.346   9.044  -6.792  1.00 80.00           O
ATOM    165  OP2  DT A 109      11.601  10.895  -7.072  1.00 80.00           O
ATOM    166  O5'  DT A 109      12.371  10.262  -4.802  1.00 80.00           O
ATOM    167  C5'  DT A 109      11.341   9.374  -4.378  1.00 80.00           C
ATOM    168  C4'  DT A 109      11.748   7.948  -4.691  1.00 80.00           C
ATOM    169  O4'  DT A 109      13.164   7.820  -4.404  1.00 80.00           O
ATOM    170  C3'  DT A 109      11.038   6.875  -3.875  1.00 80.00           C
ATOM    171  O3'  DT A 109      10.032   6.201  -4.629  1.00 80.00           O
ATOM    172  C2'  DT A 109      12.157   5.904  -3.516  1.00 80.00           C
ATOM    173  C1'  DT A 109      13.364   6.830  -3.418  1.00 80.00           C
ATOM    174  N1   DT A 109      13.566   7.503  -2.089  1.00 80.00           N
ATOM    175  C2   DT A 109      13.223   6.852  -0.921  1.00 80.00           C
ATOM    176  O2   DT A 109      12.741   5.734  -0.882  1.00 80.00           O
ATOM    177  N3   DT A 109      13.462   7.566   0.226  1.00 80.00           N
ATOM    178  C4   DT A 109      14.001   8.834   0.334  1.00 80.00           C
ATOM    179  O4   DT A 109      14.171   9.378   1.425  1.00 80.00           O
ATOM    180  C5   DT A 109      14.342   9.457  -0.924  1.00 80.00           C
ATOM    181  C7   DT A 109      14.933  10.836  -0.951  1.00 80.00           C
ATOM    182  C6   DT A 109      14.113   8.772  -2.054  1.00 80.00           C
ATOM    183  P    DG A 110       8.773   6.966  -5.255  1.00 80.00           P
ATOM    184  OP1  DG A 110       7.794   5.926  -5.644  1.00 80.00           O
ATOM    185  OP2  DG A 110       9.264   7.931  -6.263  1.00 80.00           O
ATOM    186  O5'  DG A 110       8.163   7.793  -4.030  1.00 80.00           O
ATOM    187  C5'  DG A 110       7.217   7.175  -3.170  1.00 80.00           C
ATOM    188  C4'  DG A 110       7.900   6.082  -2.381  1.00 80.00           C
ATOM    189  O4'  DG A 110       9.169   6.610  -1.957  1.00 80.00           O
ATOM    190  C3'  DG A 110       7.209   5.673  -1.094  1.00 80.00           C
ATOM    191  O3'  DG A 110       6.337   4.602  -1.358  1.00 80.00           O
ATOM    192  C2'  DG A 110       8.355   5.237  -0.192  1.00 80.00           C
ATOM    193  C1'  DG A 110       9.541   6.033  -0.729  1.00 80.00           C
ATOM    194  N9   DG A 110      10.003   7.124   0.119  1.00 80.00           N
ATOM    195  C8   DG A 110      10.514   8.324  -0.310  1.00 80.00           C
ATOM    196  N7   DG A 110      10.859   9.116   0.665  1.00 80.00           N
ATOM    197  C5   DG A 110      10.561   8.393   1.814  1.00 80.00           C
ATOM    198  C6   DG A 110      10.716   8.740   3.177  1.00 80.00           C
ATOM    199  O6   DG A 110      11.170   9.789   3.657  1.00 80.00           O
ATOM    200  N1   DG A 110      10.283   7.718   4.019  1.00 80.00           N
ATOM    201  C2   DG A 110       9.767   6.516   3.596  1.00 80.00           C
ATOM    202  N2   DG A 110       9.401   5.650   4.551  1.00 80.00           N
ATOM    203  N3   DG A 110       9.615   6.181   2.323  1.00 80.00           N
ATOM    204  C4   DG A 110      10.031   7.164   1.492  1.00 80.00           C
ATOM    205  P    DT A 111       4.960   4.916  -2.099  1.00 80.00           P
ATOM    206  OP1  DT A 111       5.092   4.516  -3.518  1.00 80.00           O
ATOM    207  OP2  DT A 111       4.587   6.305  -1.757  1.00 80.00           O
ATOM    208  O5'  DT A 111       3.929   3.946  -1.358  1.00 80.00           O
ATOM    209  C5'  DT A 111       3.218   4.420  -0.224  1.00 80.00           C
ATOM    210  C4'  DT A 111       3.932   4.139   1.088  1.00 80.00           C
ATOM    211  O4'  DT A 111       5.168   4.904   1.195  1.00 80.00           O
ATOM    212  C3'  DT A 111       3.082   4.523   2.294  1.00 80.00           C
ATOM    213  O3'  DT A 111       2.994   3.461   3.244  1.00 80.00           O
ATOM    214  C2'  DT A 111       3.809   5.741   2.863  1.00 80.00           C
ATOM    215  C1'  DT A 111       5.255   5.454   2.495  1.00 80.00           C
ATOM    216  N1   DT A 111       6.098   6.689   2.477  1.00 80.00           N
ATOM    217  C2   DT A 111       6.650   7.188   3.644  1.00 80.00           C
ATOM    218  O2   DT A 111       6.513   6.684   4.745  1.00 80.00           O
ATOM    219  N3   DT A 111       7.394   8.329   3.480  1.00 80.00           N
ATOM    220  C4   DT A 111       7.635   9.008   2.301  1.00 80.00           C
ATOM    221  O4   DT A 111       8.317  10.026   2.252  1.00 80.00           O
ATOM    222  C5   DT A 111       7.032   8.437   1.128  1.00 80.00           C
ATOM    223  C7   DT A 111       7.228   9.091  -0.206  1.00 80.00           C
ATOM    224  C6   DT A 111       6.300   7.328   1.274  1.00 80.00           C
ATOM    225  P    DA A 112       2.965   3.884   4.784  1.00 80.00           P
ATOM    226  OP1  DA A 112       1.999   4.996   4.916  1.00 80.00           O
ATOM    227  OP2  DA A 112       4.381   4.040   5.191  1.00 80.00           O
ATOM    228  O5'  DA A 112       2.356   2.660   5.606  1.00 80.00           O
ATOM    229  C5'  DA A 112       1.577   2.955   6.768  1.00 80.00           C
ATOM    230  C4'  DA A 112       2.349   3.720   7.837  1.00 80.00           C
ATOM    231  O4'  DA A 112       3.444   4.490   7.280  1.00 80.00           O
ATOM    232  C3'  DA A 112       1.513   4.734   8.604  1.00 80.00           C
ATOM    233  O3'  DA A 112       0.910   4.105   9.734  1.00 80.00           O
ATOM    234  C2'  DA A 112       2.519   5.808   9.014  1.00 80.00           C
ATOM    235  C1'  DA A 112       3.697   5.647   8.055  1.00 80.00           C
ATOM    236  N9   DA A 112       3.925   6.796   7.169  1.00 80.00           N
ATOM    237  C8   DA A 112       3.695   6.853   5.824  1.00 80.00           C
ATOM    238  N7   DA A 112       3.988   8.003   5.267  1.00 80.00           N
ATOM    239  C5   DA A 112       4.449   8.768   6.323  1.00 80.00           C
ATOM    240  C6   DA A 112       4.920  10.095   6.393  1.00 80.00           C
ATOM    241  N6   DA A 112       5.006  10.912   5.336  1.00 80.00           N
ATOM    242  N1   DA A 112       5.305  10.555   7.601  1.00 80.00           N
ATOM    243  C2   DA A 112       5.221   9.740   8.659  1.00 80.00           C
ATOM    244  N3   DA A 112       4.795   8.477   8.715  1.00 80.00           N
ATOM    245  C4   DA A 112       4.419   8.042   7.502  1.00 80.00           C
ATOM    246  P    DC A 113       1.755   3.812  11.063  1.00 80.00           P
ATOM    247  OP1  DC A 113       3.072   3.272  10.660  1.00 80.00           O
ATOM    248  OP2  DC A 113       0.895   3.026  11.975  1.00 80.00           O
ATOM    249  O5'  DC A 113       1.962   5.264  11.707  1.00 80.00           O
ATOM    250  C5'  DC A 113       3.125   5.543  12.481  1.00 80.00           C
ATOM    251  C4'  DC A 113       3.028   6.911  13.131  1.00 80.00           C
ATOM    252  O4'  DC A 113       3.173   7.957  12.138  1.00 80.00           O
ATOM    253  C3'  DC A 113       1.705   7.169  13.839  1.00 80.00           C
ATOM    254  O3'  DC A 113       1.962   7.721  15.127  1.00 80.00           O
ATOM    255  C2'  DC A 113       0.971   8.124  12.896  1.00 80.00           C
ATOM    256  C1'  DC A 113       2.122   8.892  12.260  1.00 80.00           C
ATOM    257  N1   DC A 113       1.847   9.424  10.891  1.00 80.00           N
ATOM    258  C2   DC A 113       1.880  10.800  10.648  1.00 80.00           C
ATOM    259  O2   DC A 113       2.128  11.565  11.582  1.00 80.00           O
ATOM    260  N3   DC A 113       1.635  11.260   9.396  1.00 80.00           N
ATOM    261  C4   DC A 113       1.370  10.404   8.409  1.00 80.00           C
ATOM    262  N4   DC A 113       1.135  10.903   7.189  1.00 80.00           N
ATOM    263  C5   DC A 113       1.334   8.997   8.633  1.00 80.00           C
ATOM    264  C6   DC A 113       1.576   8.560   9.875  1.00 80.00           C
ATOM    265  P    DG A 114       1.600   6.848  16.418  1.00 80.00           P
ATOM    266  OP1  DG A 114       1.787   5.427  16.053  1.00 80.00           O
ATOM    267  OP2  DG A 114       0.290   7.315  16.917  1.00 80.00           O
ATOM    268  O5'  DG A 114       2.700   7.244  17.509  1.00 80.00           O
ATOM    269  C5'  DG A 114       2.480   8.349  18.378  1.00 80.00           C
ATOM    270  C4'  DG A 114       3.302   9.539  17.924  1.00 80.00           C
ATOM    271  O4'  DG A 114       3.208   9.629  16.484  1.00 80.00           O
ATOM    272  C3'  DG A 114       2.866  10.886  18.484  1.00 80.00           C
ATOM    273  O3'  DG A 114       3.685  11.197  19.606  1.00 80.00           O
ATOM    274  C2'  DG A 114       3.112  11.853  17.331  1.00 80.00           C
ATOM    275  C1'  DG A 114       3.061  10.974  16.084  1.00 80.00           C
ATOM    276  N9   DG A 114       1.839  11.066  15.289  1.00 80.00           N
ATOM    277  C8   DG A 114       0.794  10.177  15.251  1.00 80.00           C
ATOM    278  N7   DG A 114      -0.157  10.523  14.427  1.00 80.00           N
ATOM    279  C5   DG A 114       0.285  11.720  13.880  1.00 80.00           C
ATOM    280  C6   DG A 114      -0.319  12.573  12.925  1.00 80.00           C
ATOM    281  O6   DG A 114      -1.403  12.447  12.339  1.00 80.00           O
ATOM    282  N1   DG A 114       0.479  13.680  12.659  1.00 80.00           N
ATOM    283  C2   DG A 114       1.700  13.927  13.239  1.00 80.00           C
ATOM    284  N2   DG A 114       2.328  15.048  12.859  1.00 80.00           N
ATOM    285  N3   DG A 114       2.276  13.140  14.133  1.00 80.00           N
ATOM    286  C4   DG A 114       1.513  12.061  14.402  1.00 80.00           C
ATOM    287  P    DG A 115       3.482  12.544  20.444  1.00 80.00           P
ATOM    288  OP1  DG A 115       3.569  12.198  21.880  1.00 80.00           O
ATOM    289  OP2  DG A 115       2.290  13.247  19.927  1.00 80.00           O
ATOM    290  O5'  DG A 115       4.767  13.407  20.053  1.00 80.00           O
ATOM    291  C5'  DG A 115       4.748  14.805  20.275  1.00 80.00           C
ATOM    292  C4'  DG A 115       4.431  15.527  18.982  1.00 80.00           C
ATOM    293  O4'  DG A 115       3.747  14.642  18.061  1.00 80.00           O
ATOM    294  C3'  DG A 115       3.453  16.678  19.113  1.00 80.00           C
ATOM    295  O3'  DG A 115       4.061  17.824  19.729  1.00 80.00           O
ATOM    296  C2'  DG A 115       3.074  16.876  17.649  1.00 80.00           C
ATOM    297  C1'  DG A 115       3.037  15.440  17.129  1.00 80.00           C
ATOM    298  N9   DG A 115       1.685  14.911  16.941  1.00 80.00           N
ATOM    299  C8   DG A 115       1.063  13.944  17.688  1.00 80.00           C
ATOM    300  N7   DG A 115      -0.145  13.664  17.289  1.00 80.00           N
ATOM    301  C5   DG A 115      -0.345  14.505  16.203  1.00 80.00           C
ATOM    302  C6   DG A 115      -1.473  14.655  15.360  1.00 80.00           C
ATOM    303  O6   DG A 115      -2.554  14.058  15.406  1.00 80.00           O
ATOM    304  N1   DG A 115      -1.269  15.616  14.377  1.00 80.00           N
ATOM    305  C2   DG A 115      -0.115  16.342  14.230  1.00 80.00           C
ATOM    306  N2   DG A 115      -0.108  17.224  13.220  1.00 80.00           N
ATOM    307  N3   DG A 115       0.952  16.214  15.012  1.00 80.00           N
ATOM    308  C4   DG A 115       0.770  15.279  15.976  1.00 80.00           C
ATOM    309  P    DA A 116       5.043  18.849  18.982  1.00 80.00           P
ATOM    310  OP1  DA A 116       5.270  18.413  17.588  1.00 80.00           O
ATOM    311  OP2  DA A 116       6.205  19.060  19.873  1.00 80.00           O
ATOM    312  O5'  DA A 116       4.200  20.208  18.971  1.00 80.00           O
ATOM    313  C5'  DA A 116       4.399  21.132  17.916  1.00 80.00           C
ATOM    314  C4'  DA A 116       3.267  21.056  16.910  1.00 80.00           C
ATOM    315  O4'  DA A 116       2.561  19.797  17.037  1.00 80.00           O
ATOM    316  C3'  DA A 116       2.201  22.127  17.103  1.00 80.00           C
ATOM    317  O3'  DA A 116       2.289  23.067  16.054  1.00 80.00           O
ATOM    318  C2'  DA A 116       0.866  21.388  17.055  1.00 80.00           C
ATOM    319  C1'  DA A 116       1.260  20.012  16.535  1.00 80.00           C
ATOM    320  N9   DA A 116       0.333  18.952  16.941  1.00 80.00           N
ATOM    321  C8   DA A 116       0.447  18.043  17.956  1.00 80.00           C
ATOM    322  N7   DA A 116      -0.571  17.217  18.058  1.00 80.00           N
ATOM    323  C5   DA A 116      -1.422  17.616  17.042  1.00 80.00           C
ATOM    324  C6   DA A 116      -2.682  17.156  16.606  1.00 80.00           C
ATOM    325  N6   DA A 116      -3.351  16.137  17.160  1.00 80.00           N
ATOM    326  N1   DA A 116      -3.241  17.791  15.559  1.00 80.00           N
ATOM    327  C2   DA A 116      -2.588  18.811  14.992  1.00 80.00           C
ATOM    328  N3   DA A 116      -1.408  19.332  15.309  1.00 80.00           N
ATOM    329  C4   DA A 116      -0.876  18.683  16.351  1.00 80.00           C
ATOM    330  P    DC A 117       2.105  24.611  16.411  1.00 80.00           P
ATOM    331  OP1  DC A 117       2.988  25.393  15.519  1.00 80.00           O
ATOM    332  OP2  DC A 117       2.223  24.748  17.879  1.00 80.00           O
ATOM    333  O5'  DC A 117       0.588  24.892  15.994  1.00 80.00           O
ATOM    334  C5'  DC A 117       0.266  24.938  14.615  1.00 80.00           C
ATOM    335  C4'  DC A 117      -1.169  24.516  14.361  1.00 80.00           C
ATOM    336  O4'  DC A 117      -1.470  23.276  15.052  1.00 80.00           O
ATOM    337  C3'  DC A 117      -2.249  25.510  14.796  1.00 80.00           C
ATOM    338  O3'  DC A 117      -2.890  26.015  13.623  1.00 80.00           O
ATOM    339  C2'  DC A 117      -3.190  24.677  15.668  1.00 80.00           C
ATOM    340  C1'  DC A 117      -2.873  23.265  15.194  1.00 80.00           C
ATOM    341  N1   DC A 117      -3.312  22.171  16.114  1.00 80.00           N
ATOM    342  C2   DC A 117      -4.452  21.432  15.782  1.00 80.00           C
ATOM    343  O2   DC A 117      -5.064  21.706  14.744  1.00 80.00           O
ATOM    344  N3   DC A 117      -4.861  20.438  16.607  1.00 80.00           N
ATOM    345  C4   DC A 117      -4.175  20.174  17.718  1.00 80.00           C
ATOM    346  N4   DC A 117      -4.619  19.181  18.495  1.00 80.00           N
ATOM    347  C5   DC A 117      -3.008  20.913  18.075  1.00 80.00           C
ATOM    348  C6   DC A 117      -2.616  21.894  17.253  1.00 80.00           C
ATOM    349  P    DA A 118      -4.112  27.051  13.667  1.00 80.00           P
ATOM    350  OP1  DA A 118      -3.583  28.391  13.332  1.00 80.00           O
ATOM    351  OP2  DA A 118      -4.873  26.851  14.920  1.00 80.00           O
ATOM    352  O5'  DA A 118      -5.026  26.539  12.457  1.00 80.00           O
ATOM    353  C5'  DA A 118      -5.272  25.145  12.319  1.00 80.00           C
ATOM    354  C4'  DA A 118      -6.637  24.866  11.721  1.00 80.00           C
ATOM    355  O4'  DA A 118      -7.241  23.799  12.487  1.00 80.00           O
ATOM    356  C3'  DA A 118      -7.664  25.969  11.880  1.00 80.00           C
ATOM    357  O3'  DA A 118      -8.848  25.575  11.204  1.00 80.00           O
ATOM    358  C2'  DA A 118      -7.856  25.891  13.384  1.00 80.00           C
ATOM    359  C1'  DA A 118      -8.005  24.381  13.528  1.00 80.00           C
ATOM    360  N9   DA A 118      -7.512  23.861  14.797  1.00 80.00           N
ATOM    361  C8   DA A 118      -6.366  24.199  15.461  1.00 80.00           C
ATOM    362  N7   DA A 118      -6.197  23.545  16.588  1.00 80.00           N
ATOM    363  C5   DA A 118      -7.306  22.719  16.665  1.00 80.00           C
ATOM    364  C6   DA A 118      -7.733  21.769  17.617  1.00 80.00           C
ATOM    365  N6   DA A 118      -7.065  21.462  18.736  1.00 80.00           N
ATOM    366  N1   DA A 118      -8.895  21.133  17.367  1.00 80.00           N
ATOM    367  C2   DA A 118      -9.575  21.424  16.253  1.00 80.00           C
ATOM    368  N3   DA A 118      -9.279  22.291  15.292  1.00 80.00           N
ATOM    369  C4   DA A 118      -8.123  22.906  15.565  1.00 80.00           C
ATOM    370  P    DT A 119     -10.214  26.387  11.386  1.00 80.00           P
ATOM    371  OP1  DT A 119     -10.052  27.708  10.741  1.00 80.00           O
ATOM    372  OP2  DT A 119     -10.622  26.317  12.805  1.00 80.00           O
ATOM    373  O5'  DT A 119     -11.237  25.517  10.520  1.00 80.00           O
ATOM    374  C5'  DT A 119     -11.341  24.119  10.739  1.00 80.00           C
ATOM    375  C4'  DT A 119     -12.159  23.825  11.983  1.00 80.00           C
ATOM    376  O4'  DT A 119     -11.315  23.827  13.158  1.00 80.00           O
ATOM    377  C3'  DT A 119     -13.270  24.833  12.284  1.00 80.00           C
ATOM    378  O3'  DT A 119     -14.542  24.302  11.891  1.00 80.00           O
ATOM    379  C2'  DT A 119     -13.161  25.091  13.791  1.00 80.00           C
ATOM    380  C1'  DT A 119     -12.201  23.996  14.239  1.00 80.00           C
ATOM    381  N1   DT A 119     -11.443  24.293  15.482  1.00 80.00           N
ATOM    382  C2   DT A 119     -11.767  23.570  16.600  1.00 80.00           C
ATOM    383  O2   DT A 119     -12.635  22.721  16.593  1.00 80.00           O
ATOM    384  N3   DT A 119     -11.038  23.879  17.719  1.00 80.00           N
ATOM    385  C4   DT A 119     -10.036  24.823  17.826  1.00 80.00           C
ATOM    386  O4   DT A 119      -9.438  25.026  18.881  1.00 80.00           O
ATOM    387  C5   DT A 119      -9.746  25.546  16.612  1.00 80.00           C
ATOM    388  C7   DT A 119      -8.678  26.597  16.607  1.00 80.00           C
ATOM    389  C6   DT A 119     -10.454  25.253  15.511  1.00 80.00           C
ATOM    390  P    DC A 120     -15.468  23.453  12.885  1.00 80.00           P
ATOM    391  OP1  DC A 120     -14.618  22.442  13.552  1.00 80.00           O
ATOM    392  OP2  DC A 120     -16.663  23.023  12.125  1.00 80.00           O
ATOM    393  O5'  DC A 120     -15.936  24.536  13.965  1.00 80.00           O
ATOM    394  C5'  DC A 120     -17.013  24.233  14.835  1.00 80.00           C
ATOM    395  C4'  DC A 120     -16.925  22.791  15.292  1.00 80.00           C
ATOM    396  O4'  DC A 120     -15.683  22.617  16.015  1.00 80.00           O
ATOM    397  C3'  DC A 120     -18.006  22.358  16.267  1.00 80.00           C
ATOM    398  O3'  DC A 120     -18.104  20.946  16.280  1.00 80.00           O
ATOM    399  C2'  DC A 120     -17.431  22.871  17.577  1.00 80.00           C
ATOM    400  C1'  DC A 120     -15.965  22.499  17.395  1.00 80.00           C
ATOM    401  N1   DC A 120     -15.035  23.383  18.138  1.00 80.00           N
ATOM    402  C2   DC A 120     -14.632  23.001  19.417  1.00 80.00           C
ATOM    403  O2   DC A 120     -15.067  21.941  19.878  1.00 80.00           O
ATOM    404  N3   DC A 120     -13.781  23.797  20.110  1.00 80.00           N
ATOM    405  C4   DC A 120     -13.342  24.930  19.564  1.00 80.00           C
ATOM    406  N4   DC A 120     -12.505  25.682  20.286  1.00 80.00           N
ATOM    407  C5   DC A 120     -13.746  25.339  18.257  1.00 80.00           C
ATOM    408  C6   DC A 120     -14.587  24.544  17.584  1.00 80.00           C
ATOM    409  P    DA A 121     -19.416  20.260  16.881  1.00 80.00           P
ATOM    410  OP1  DA A 121     -19.577  18.929  16.255  1.00 80.00           O
ATOM    411  OP2  DA A 121     -20.516  21.244  16.799  1.00 80.00           O
ATOM    412  O5'  DA A 121     -19.044  20.078  18.425  1.00 80.00           O
ATOM    413  C5'  DA A 121     -20.069  19.733  19.343  1.00 80.00           C
ATOM    414  C4'  DA A 121     -19.576  19.889  20.766  1.00 80.00           C
ATOM    415  O4'  DA A 121     -18.465  20.820  20.781  1.00 80.00           O
ATOM    416  C3'  DA A 121     -20.600  20.475  21.731  1.00 80.00           C
ATOM    417  O3'  DA A 121     -20.330  20.010  23.045  1.00 80.00           O
ATOM    418  C2'  DA A 121     -20.290  21.960  21.615  1.00 80.00           C
ATOM    419  C1'  DA A 121     -18.785  21.806  21.738  1.00 80.00           C
ATOM    420  N9   DA A 121     -17.974  22.997  21.524  1.00 80.00           N
ATOM    421  C8   DA A 121     -18.031  23.959  20.555  1.00 80.00           C
ATOM    422  N7   DA A 121     -17.109  24.890  20.695  1.00 80.00           N
ATOM    423  C5   DA A 121     -16.403  24.507  21.829  1.00 80.00           C
ATOM    424  C6   DA A 121     -15.300  25.047  22.534  1.00 80.00           C
ATOM    425  N6   DA A 121     -14.643  26.166  22.206  1.00 80.00           N
ATOM    426  N1   DA A 121     -14.881  24.373  23.625  1.00 80.00           N
ATOM    427  C2   DA A 121     -15.510  23.251  23.991  1.00 80.00           C
ATOM    428  N3   DA A 121     -16.542  22.652  23.417  1.00 80.00           N
ATOM    429  C4   DA A 121     -16.935  23.340  22.339  1.00 80.00           C
TER     430       DA A 121
ATOM    431  P    DC B 119      -4.997  12.691   6.730  1.00 80.00           P
ATOM    432  OP1  DC B 119      -5.064  11.667   5.666  1.00 80.00           O
ATOM    433  OP2  DC B 119      -4.773  12.292   8.137  1.00 80.00           O
ATOM    434  O5'  DC B 119      -3.872  13.760   6.342  1.00 80.00           O
ATOM    435  C5'  DC B 119      -4.236  14.912   5.593  1.00 80.00           C
ATOM    436  C4'  DC B 119      -4.388  16.143   6.471  1.00 80.00           C
ATOM    437  O4'  DC B 119      -4.859  15.775   7.793  1.00 80.00           O
ATOM    438  C3'  DC B 119      -3.106  16.943   6.679  1.00 80.00           C
ATOM    439  O3'  DC B 119      -3.373  18.319   6.438  1.00 80.00           O
ATOM    440  C2'  DC B 119      -2.742  16.678   8.138  1.00 80.00           C
ATOM    441  C1'  DC B 119      -4.118  16.492   8.759  1.00 80.00           C
ATOM    442  N1   DC B 119      -4.159  15.715  10.033  1.00 80.00           N
ATOM    443  C2   DC B 119      -3.232  15.927  11.066  1.00 80.00           C
ATOM    444  O2   DC B 119      -2.336  16.770  10.943  1.00 80.00           O
ATOM    445  N3   DC B 119      -3.335  15.188  12.197  1.00 80.00           N
ATOM    446  C4   DC B 119      -4.306  14.282  12.317  1.00 80.00           C
ATOM    447  N4   DC B 119      -4.368  13.577  13.451  1.00 80.00           N
ATOM    448  C5   DC B 119      -5.259  14.054  11.284  1.00 80.00           C
ATOM    449  C6   DC B 119      -5.144  14.785  10.175  1.00 80.00           C
ATOM    450  P    DC B 120      -2.194  19.307   6.004  1.00 80.00           P
ATOM    451  OP1  DC B 120      -1.448  19.684   7.226  1.00 80.00           O
ATOM    452  OP2  DC B 120      -2.775  20.360   5.139  1.00 80.00           O
ATOM    453  O5'  DC B 120      -1.261  18.359   5.118  1.00 80.00           O
ATOM    454  C5'  DC B 120       0.058  18.758   4.765  1.00 80.00           C
ATOM    455  C4'  DC B 120       1.014  18.542   5.924  1.00 80.00           C
ATOM    456  O4'  DC B 120       0.382  17.708   6.931  1.00 80.00           O
ATOM    457  C3'  DC B 120       2.318  17.849   5.540  1.00 80.00           C
ATOM    458  O3'  DC B 120       3.426  18.520   6.135  1.00 80.00           O
ATOM    459  C2'  DC B 120       2.118  16.436   6.078  1.00 80.00           C
ATOM    460  C1'  DC B 120       1.306  16.719   7.331  1.00 80.00           C
ATOM    461  N1   DC B 120       0.576  15.535   7.880  1.00 80.00           N
ATOM    462  C2   DC B 120       0.854  15.128   9.186  1.00 80.00           C
ATOM    463  O2   DC B 120       1.692  15.765   9.832  1.00 80.00           O
ATOM    464  N3   DC B 120       0.204  14.057   9.705  1.00 80.00           N
ATOM    465  C4   DC B 120      -0.692  13.400   8.970  1.00 80.00           C
ATOM    466  N4   DC B 120      -1.304  12.351   9.535  1.00 80.00           N
ATOM    467  C5   DC B 120      -0.991  13.797   7.631  1.00 80.00           C
ATOM    468  C6   DC B 120      -0.340  14.856   7.130  1.00 80.00           C
ATOM    469  P    DG B 121       3.831  19.954   5.556  1.00 80.00           P
ATOM    470  OP1  DG B 121       3.397  20.965   6.540  1.00 80.00           O
ATOM    471  OP2  DG B 121       3.342  20.031   4.163  1.00 80.00           O
ATOM    472  O5'  DG B 121       5.429  19.953   5.538  1.00 80.00           O
ATOM    473  C5'  DG B 121       6.145  20.665   6.542  1.00 80.00           C
ATOM    474  C4'  DG B 121       6.754  19.720   7.558  1.00 80.00           C
ATOM    475  O4'  DG B 121       5.784  18.690   7.847  1.00 80.00           O
ATOM    476  C3'  DG B 121       8.010  19.007   7.067  1.00 80.00           C
ATOM    477  O3'  DG B 121       9.207  19.685   7.518  1.00 80.00           O
ATOM    478  C2'  DG B 121       7.881  17.572   7.578  1.00 80.00           C
ATOM    479  C1'  DG B 121       6.438  17.458   8.062  1.00 80.00           C
ATOM    480  N9   DG B 121       5.671  16.422   7.381  1.00 80.00           N
ATOM    481  C8   DG B 121       5.376  16.317   6.044  1.00 80.00           C
ATOM    482  N7   DG B 121       4.665  15.260   5.754  1.00 80.00           N
ATOM    483  C5   DG B 121       4.474  14.628   6.977  1.00 80.00           C
ATOM    484  C6   DG B 121       3.779  13.437   7.307  1.00 80.00           C
ATOM    485  O6   DG B 121       3.162  12.662   6.562  1.00 80.00           O
ATOM    486  N1   DG B 121       3.843  13.170   8.672  1.00 80.00           N
ATOM    487  C2   DG B 121       4.494  13.952   9.598  1.00 80.00           C
ATOM    488  N2   DG B 121       4.455  13.542  10.873  1.00 80.00           N
ATOM    489  N3   DG B 121       5.145  15.066   9.304  1.00 80.00           N
ATOM    490  C4   DG B 121       5.089  15.337   7.982  1.00 80.00           C
ATOM    491  P    DT B 122       9.955  19.429   8.918  1.00 80.00           P
ATOM    492  OP1  DT B 122      10.186  20.750   9.545  1.00 80.00           O
ATOM    493  OP2  DT B 122      11.112  18.548   8.651  1.00 80.00           O
ATOM    494  O5'  DT B 122       8.898  18.634   9.816  1.00 80.00           O
ATOM    495  C5'  DT B 122       9.274  18.108  11.084  1.00 80.00           C
ATOM    496  C4'  DT B 122       9.561  16.614  11.029  1.00 80.00           C
ATOM    497  O4'  DT B 122       8.714  15.959  10.053  1.00 80.00           O
ATOM    498  C3'  DT B 122      10.989  16.214  10.658  1.00 80.00           C
ATOM    499  O3'  DT B 122      11.650  15.728  11.827  1.00 80.00           O
ATOM    500  C2'  DT B 122      10.825  15.122   9.595  1.00 80.00           C
ATOM    501  C1'  DT B 122       9.355  14.745   9.726  1.00 80.00           C
ATOM    502  N1   DT B 122       8.742  14.194   8.486  1.00 80.00           N
ATOM    503  C2   DT B 122       7.718  13.280   8.599  1.00 80.00           C
ATOM    504  O2   DT B 122       7.278  12.890   9.665  1.00 80.00           O
ATOM    505  N3   DT B 122       7.215  12.829   7.406  1.00 80.00           N
ATOM    506  C4   DT B 122       7.626  13.193   6.139  1.00 80.00           C
ATOM    507  O4   DT B 122       7.104  12.726   5.129  1.00 80.00           O
ATOM    508  C5   DT B 122       8.703  14.152   6.093  1.00 80.00           C
ATOM    509  C7   DT B 122       9.236  14.622   4.772  1.00 80.00           C
ATOM    510  C6   DT B 122       9.204  14.601   7.252  1.00 80.00           C
ATOM    511  P    DA B 123      13.116  15.081  11.762  1.00 80.00           P
ATOM    512  OP1  DA B 123      13.781  15.326  13.063  1.00 80.00           O
ATOM    513  OP2  DA B 123      13.764  15.544  10.513  1.00 80.00           O
ATOM    514  O5'  DA B 123      12.815  13.511  11.650  1.00 80.00           O
ATOM    515  C5'  DA B 123      11.968  12.864  12.598  1.00 80.00           C
ATOM    516  C4'  DA B 123      11.689  11.434  12.178  1.00 80.00           C
ATOM    517  O4'  DA B 123      10.834  11.423  11.002  1.00 80.00           O
ATOM    518  C3'  DA B 123      12.930  10.654  11.764  1.00 80.00           C
ATOM    519  O3'  DA B 123      12.687   9.266  11.879  1.00 80.00           O
ATOM    520  C2'  DA B 123      12.986  11.019  10.296  1.00 80.00           C
ATOM    521  C1'  DA B 123      11.529  10.700  10.011  1.00 80.00           C
ATOM    522  N9   DA B 123      11.114  11.085   8.674  1.00 80.00           N
ATOM    523  C8   DA B 123      11.492  12.199   7.981  1.00 80.00           C
ATOM    524  N7   DA B 123      10.962  12.273   6.785  1.00 80.00           N
ATOM    525  C5   DA B 123      10.187  11.128   6.693  1.00 80.00           C
ATOM    526  C6   DA B 123       9.365  10.616   5.671  1.00 80.00           C
ATOM    527  N6   DA B 123       9.188  11.231   4.499  1.00 80.00           N
ATOM    528  N1   DA B 123       8.730   9.446   5.896  1.00 80.00           N
ATOM    529  C2   DA B 123       8.909   8.831   7.070  1.00 80.00           C
ATOM    530  N3   DA B 123       9.657   9.217   8.106  1.00 80.00           N
ATOM    531  C4   DA B 123      10.273  10.382   7.849  1.00 80.00           C
ATOM    532  P    DC B 124      12.749   8.568  13.313  1.00 80.00           P
ATOM    533  OP1  DC B 124      11.376   8.134  13.650  1.00 80.00           O
ATOM    534  OP2  DC B 124      13.491   9.470  14.222  1.00 80.00           O
ATOM    535  O5'  DC B 124      13.622   7.252  13.059  1.00 80.00           O
ATOM    536  C5'  DC B 124      12.998   5.981  13.162  1.00 80.00           C
ATOM    537  C4'  DC B 124      12.292   5.574  11.881  1.00 80.00           C
ATOM    538  O4'  DC B 124      12.213   6.680  10.948  1.00 80.00           O
ATOM    539  C3'  DC B 124      12.965   4.437  11.115  1.00 80.00           C
ATOM    540  O3'  DC B 124      12.069   3.341  11.055  1.00 80.00           O
ATOM    541  C2'  DC B 124      13.231   5.011   9.726  1.00 80.00           C
ATOM    542  C1'  DC B 124      12.170   6.096   9.666  1.00 80.00           C
ATOM    543  N1   DC B 124      12.402   7.130   8.628  1.00 80.00           N
ATOM    544  C2   DC B 124      11.731   7.022   7.411  1.00 80.00           C
ATOM    545  O2   DC B 124      10.971   6.065   7.240  1.00 80.00           O
ATOM    546  N3   DC B 124      11.935   7.962   6.457  1.00 80.00           N
ATOM    547  C4   DC B 124      12.768   8.976   6.689  1.00 80.00           C
ATOM    548  N4   DC B 124      12.940   9.884   5.723  1.00 80.00           N
ATOM    549  C5   DC B 124      13.462   9.100   7.926  1.00 80.00           C
ATOM    550  C6   DC B 124      13.252   8.166   8.860  1.00 80.00           C
ATOM    551  P    DA B 125      12.623   1.875  10.755  1.00 80.00           P
ATOM    552  OP1  DA B 125      12.258   1.006  11.893  1.00 80.00           O
ATOM    553  OP2  DA B 125      14.035   2.002  10.337  1.00 80.00           O
ATOM    554  O5'  DA B 125      11.759   1.416   9.495  1.00 80.00           O
ATOM    555  C5'  DA B 125      11.939   2.071   8.254  1.00 80.00           C
ATOM    556  C4'  DA B 125      12.557   1.098   7.274  1.00 80.00           C
ATOM    557  O4'  DA B 125      12.842   1.780   6.034  1.00 80.00           O
ATOM    558  C3'  DA B 125      13.908   0.563   7.706  1.00 80.00           C
ATOM    559  O3'  DA B 125      14.225  -0.600   6.948  1.00 80.00           O
ATOM    560  C2'  DA B 125      14.805   1.746   7.359  1.00 80.00           C
ATOM    561  C1'  DA B 125      14.186   2.215   6.046  1.00 80.00           C
ATOM    562  N9   DA B 125      14.169   3.658   5.849  1.00 80.00           N
ATOM    563  C8   DA B 125      14.221   4.660   6.775  1.00 80.00           C
ATOM    564  N7   DA B 125      14.180   5.862   6.245  1.00 80.00           N
ATOM    565  C5   DA B 125      14.089   5.631   4.881  1.00 80.00           C
ATOM    566  C6   DA B 125      14.008   6.476   3.753  1.00 80.00           C
ATOM    567  N6   DA B 125      14.004   7.813   3.796  1.00 80.00           N
ATOM    568  N1   DA B 125      13.930   5.884   2.546  1.00 80.00           N
ATOM    569  C2   DA B 125      13.931   4.549   2.471  1.00 80.00           C
ATOM    570  N3   DA B 125      14.002   3.658   3.449  1.00 80.00           N
ATOM    571  C4   DA B 125      14.080   4.274   4.632  1.00 80.00           C
TER     572       DA B 125
ATOM    573  P    DG C 209      19.189  -1.072   6.886  1.00 80.00           P
ATOM    574  OP1  DG C 209      19.987   0.135   7.191  1.00 80.00           O
ATOM    575  OP2  DG C 209      19.863  -2.336   6.525  1.00 80.00           O
ATOM    576  O5'  DG C 209      18.144  -0.722   5.726  1.00 80.00           O
ATOM    577  C5'  DG C 209      18.596  -0.403   4.410  1.00 80.00           C
ATOM    578  C4'  DG C 209      17.449   0.114   3.554  1.00 80.00           C
ATOM    579  O4'  DG C 209      17.113   1.466   3.947  1.00 80.00           O
ATOM    580  C3'  DG C 209      17.734   0.202   2.061  1.00 80.00           C
ATOM    581  O3'  DG C 209      17.401  -1.046   1.458  1.00 80.00           O
ATOM    582  C2'  DG C 209      16.802   1.322   1.594  1.00 80.00           C
ATOM    583  C1'  DG C 209      16.555   2.163   2.847  1.00 80.00           C
ATOM    584  N9   DG C 209      17.102   3.525   2.838  1.00 80.00           N
ATOM    585  C8   DG C 209      17.843   4.106   3.842  1.00 80.00           C
ATOM    586  N7   DG C 209      18.203   5.333   3.592  1.00 80.00           N
ATOM    587  C5   DG C 209      17.666   5.595   2.339  1.00 80.00           C
ATOM    588  C6   DG C 209      17.734   6.773   1.555  1.00 80.00           C
ATOM    589  O6   DG C 209      18.296   7.847   1.814  1.00 80.00           O
ATOM    590  N1   DG C 209      17.058   6.625   0.348  1.00 80.00           N
ATOM    591  C2   DG C 209      16.401   5.484  -0.047  1.00 80.00           C
ATOM    592  N2   DG C 209      15.810   5.539  -1.251  1.00 80.00           N
ATOM    593  N3   DG C 209      16.330   4.371   0.678  1.00 80.00           N
ATOM    594  C4   DG C 209      16.984   4.495   1.860  1.00 80.00           C
ATOM    595  P    DG C 210      18.164  -1.598   0.162  1.00 80.00           P
ATOM    596  OP1  DG C 210      18.646  -2.963   0.466  1.00 80.00           O
ATOM    597  OP2  DG C 210      19.126  -0.572  -0.288  1.00 80.00           O
ATOM    598  O5'  DG C 210      16.985  -1.722  -0.912  1.00 80.00           O
ATOM    599  C5'  DG C 210      17.270  -2.156  -2.235  1.00 80.00           C
ATOM    600  C4'  DG C 210      17.298  -0.977  -3.190  1.00 80.00           C
ATOM    601  O4'  DG C 210      17.216   0.268  -2.442  1.00 80.00           O
ATOM    602  C3'  DG C 210      18.568  -0.909  -4.038  1.00 80.00           C
ATOM    603  O3'  DG C 210      18.286  -0.626  -5.424  1.00 80.00           O
ATOM    604  C2'  DG C 210      19.343   0.201  -3.336  1.00 80.00           C
ATOM    605  C1'  DG C 210      18.204   1.136  -2.952  1.00 80.00           C
ATOM    606  N9   DG C 210      18.599   2.133  -1.966  1.00 80.00           N
ATOM    607  C8   DG C 210      18.627   1.983  -0.606  1.00 80.00           C
ATOM    608  N7   DG C 210      19.034   3.043   0.032  1.00 80.00           N
ATOM    609  C5   DG C 210      19.301   3.959  -0.976  1.00 80.00           C
ATOM    610  C6   DG C 210      19.774   5.289  -0.888  1.00 80.00           C
ATOM    611  O6   DG C 210      20.058   5.935   0.133  1.00 80.00           O
ATOM    612  N1   DG C 210      19.907   5.868  -2.149  1.00 80.00           N
ATOM    613  C2   DG C 210      19.621   5.241  -3.340  1.00 80.00           C
ATOM    614  N2   DG C 210      19.810   5.965  -4.455  1.00 80.00           N
ATOM    615  N3   DG C 210      19.177   3.993  -3.433  1.00 80.00           N
ATOM    616  C4   DG C 210      19.041   3.414  -2.214  1.00 80.00           C
ATOM    617  P    DC C 211      18.468   0.841  -6.054  1.00 80.00           P
ATOM    618  OP1  DC C 211      19.776   1.371  -5.621  1.00 80.00           O
ATOM    619  OP2  DC C 211      17.225   1.596  -5.782  1.00 80.00           O
ATOM    620  O5'  DC C 211      18.604   0.607  -7.630  1.00 80.00           O
ATOM    621  C5'  DC C 211      18.366   1.695  -8.529  1.00 80.00           C
ATOM    622  C4'  DC C 211      19.477   2.743  -8.586  1.00 80.00           C
ATOM    623  O4'  DC C 211      19.807   3.279  -7.275  1.00 80.00           O
ATOM    624  C3'  DC C 211      20.804   2.292  -9.206  1.00 80.00           C
ATOM    625  O3'  DC C 211      21.049   3.043 -10.410  1.00 80.00           O
ATOM    626  C2'  DC C 211      21.830   2.554  -8.101  1.00 80.00           C
ATOM    627  C1'  DC C 211      21.152   3.695  -7.359  1.00 80.00           C
ATOM    628  N1   DC C 211      21.713   3.986  -6.010  1.00 80.00           N
ATOM    629  C2   DC C 211      22.175   5.276  -5.744  1.00 80.00           C
ATOM    630  O2   DC C 211      22.097   6.135  -6.632  1.00 80.00           O
ATOM    631  N3   DC C 211      22.685   5.550  -4.520  1.00 80.00           N
ATOM    632  C4   DC C 211      22.748   4.595  -3.592  1.00 80.00           C
ATOM    633  N4   DC C 211      23.262   4.917  -2.401  1.00 80.00           N
ATOM    634  C5   DC C 211      22.286   3.271  -3.845  1.00 80.00           C
ATOM    635  C6   DC C 211      21.785   3.014  -5.056  1.00 80.00           C
ATOM    636  P    DT C 212      22.296   4.036 -10.603  1.00 80.00           P
ATOM    637  OP1  DT C 212      22.133   5.165  -9.658  1.00 80.00           O
ATOM    638  OP2  DT C 212      22.421   4.329 -12.048  1.00 80.00           O
ATOM    639  O5'  DT C 212      23.540   3.129 -10.155  1.00 80.00           O
ATOM    640  C5'  DT C 212      24.877   3.495 -10.472  1.00 80.00           C
ATOM    641  C4'  DT C 212      25.155   4.920 -10.040  1.00 80.00           C
ATOM    642  O4'  DT C 212      24.485   5.180  -8.782  1.00 80.00           O
ATOM    643  C3'  DT C 212      26.609   5.236  -9.729  1.00 80.00           C
ATOM    644  O3'  DT C 212      27.391   5.443 -10.909  1.00 80.00           O
ATOM    645  C2'  DT C 212      26.448   6.495  -8.886  1.00 80.00           C
ATOM    646  C1'  DT C 212      25.242   6.114  -8.033  1.00 80.00           C
ATOM    647  N1   DT C 212      25.636   5.497  -6.739  1.00 80.00           N
ATOM    648  C2   DT C 212      26.039   6.322  -5.713  1.00 80.00           C
ATOM    649  O2   DT C 212      26.083   7.537  -5.814  1.00 80.00           O
ATOM    650  N3   DT C 212      26.386   5.665  -4.559  1.00 80.00           N
ATOM    651  C4   DT C 212      26.374   4.300  -4.334  1.00 80.00           C
ATOM    652  O4   DT C 212      26.706   3.812  -3.255  1.00 80.00           O
ATOM    653  C5   DT C 212      25.943   3.496  -5.454  1.00 80.00           C
ATOM    654  C7   DT C 212      25.887   2.002  -5.335  1.00 80.00           C
ATOM    655  C6   DT C 212      25.600   4.124  -6.588  1.00 80.00           C
ATOM    656  P    DG C 213      26.985   6.465 -12.076  1.00 80.00           P
ATOM    657  OP1  DG C 213      26.124   7.530 -11.515  1.00 80.00           O
ATOM    658  OP2  DG C 213      26.503   5.669 -13.226  1.00 80.00           O
ATOM    659  O5'  DG C 213      28.397   7.124 -12.451  1.00 80.00           O
ATOM    660  C5'  DG C 213      28.753   8.401 -11.929  1.00 80.00           C
ATOM    661  C4'  DG C 213      29.542   8.334 -10.629  1.00 80.00           C
ATOM    662  O4'  DG C 213      29.077   7.274  -9.756  1.00 80.00           O
ATOM    663  C3'  DG C 213      31.048   8.097 -10.766  1.00 80.00           C
ATOM    664  O3'  DG C 213      31.726   9.284 -10.363  1.00 80.00           O
ATOM    665  C2'  DG C 213      31.334   6.932  -9.814  1.00 80.00           C
ATOM    666  C1'  DG C 213      30.150   7.063  -8.867  1.00 80.00           C
ATOM    667  N9   DG C 213      29.904   5.917  -7.990  1.00 80.00           N
ATOM    668  C8   DG C 213      29.368   4.691  -8.307  1.00 80.00           C
ATOM    669  N7   DG C 213      29.278   3.882  -7.285  1.00 80.00           N
ATOM    670  C5   DG C 213      29.788   4.617  -6.219  1.00 80.00           C
ATOM    671  C6   DG C 213      29.951   4.271  -4.852  1.00 80.00           C
ATOM    672  O6   DG C 213      29.667   3.207  -4.280  1.00 80.00           O
ATOM    673  N1   DG C 213      30.509   5.320  -4.120  1.00 80.00           N
ATOM    674  C2   DG C 213      30.864   6.545  -4.638  1.00 80.00           C
ATOM    675  N2   DG C 213      31.389   7.433  -3.777  1.00 80.00           N
ATOM    676  N3   DG C 213      30.716   6.877  -5.914  1.00 80.00           N
ATOM    677  C4   DG C 213      30.174   5.870  -6.642  1.00 80.00           C
ATOM    678  P    DC C 214      33.306   9.458 -10.562  1.00 80.00           P
ATOM    679  OP1  DC C 214      33.524  10.612 -11.464  1.00 80.00           O
ATOM    680  OP2  DC C 214      33.869   8.133 -10.905  1.00 80.00           O
ATOM    681  O5'  DC C 214      33.814   9.885  -9.104  1.00 80.00           O
ATOM    682  C5'  DC C 214      33.600   9.022  -7.994  1.00 80.00           C
ATOM    683  C4'  DC C 214      34.777   9.064  -7.038  1.00 80.00           C
ATOM    684  O4'  DC C 214      34.622   8.000  -6.068  1.00 80.00           O
ATOM    685  C3'  DC C 214      36.130   8.780  -7.668  1.00 80.00           C
ATOM    686  O3'  DC C 214      37.170   9.216  -6.802  1.00 80.00           O
ATOM    687  C2'  DC C 214      36.099   7.258  -7.763  1.00 80.00           C
ATOM    688  C1'  DC C 214      35.405   6.886  -6.455  1.00 80.00           C
ATOM    689  N1   DC C 214      34.511   5.694  -6.550  1.00 80.00           N
ATOM    690  C2   DC C 214      34.537   4.749  -5.521  1.00 80.00           C
ATOM    691  O2   DC C 214      35.302   4.930  -4.566  1.00 80.00           O
ATOM    692  N3   DC C 214      33.727   3.664  -5.596  1.00 80.00           N
ATOM    693  C4   DC C 214      32.916   3.506  -6.643  1.00 80.00           C
ATOM    694  N4   DC C 214      32.136   2.416  -6.667  1.00 80.00           N
ATOM    695  C5   DC C 214      32.874   4.460  -7.705  1.00 80.00           C
ATOM    696  C6   DC C 214      33.678   5.529  -7.619  1.00 80.00           C
TER     697       DC C 214
ATOM    698  O5'  DT D 101     -11.214  36.668  23.965  1.00 80.00           O
ATOM    699  C5'  DT D 101     -12.609  36.525  24.185  1.00 80.00           C
ATOM    700  C4'  DT D 101     -12.892  36.191  25.637  1.00 80.00           C
ATOM    701  O4'  DT D 101     -14.285  36.476  25.930  1.00 80.00           O
ATOM    702  C3'  DT D 101     -12.734  34.723  26.016  1.00 80.00           C
ATOM    703  O3'  DT D 101     -11.375  34.358  26.273  1.00 80.00           O
ATOM    704  C2'  DT D 101     -13.619  34.671  27.251  1.00 80.00           C
ATOM    705  C1'  DT D 101     -14.823  35.400  26.678  1.00 80.00           C
ATOM    706  N1   DT D 101     -15.622  34.523  25.774  1.00 80.00           N
ATOM    707  C2   DT D 101     -15.951  33.245  26.186  1.00 80.00           C
ATOM    708  O2   DT D 101     -15.631  32.771  27.263  1.00 80.00           O
ATOM    709  N3   DT D 101     -16.685  32.522  25.279  1.00 80.00           N
ATOM    710  C4   DT D 101     -17.112  32.935  24.031  1.00 80.00           C
ATOM    711  O4   DT D 101     -17.768  32.208  23.291  1.00 80.00           O
ATOM    712  C5   DT D 101     -16.733  34.277  23.663  1.00 80.00           C
ATOM    713  C7   DT D 101     -17.143  34.829  22.330  1.00 80.00           C
ATOM    714  C6   DT D 101     -16.015  34.998  24.537  1.00 80.00           C
ATOM    715  P    DC D 102     -10.685  34.423  27.721  1.00 80.00           P
ATOM    716  OP1  DC D 102     -11.394  35.418  28.557  1.00 80.00           O
ATOM    717  OP2  DC D 102      -9.235  34.591  27.489  1.00 80.00           O
ATOM    718  O5'  DC D 102     -10.893  32.947  28.317  1.00 80.00           O
ATOM    719  C5'  DC D 102     -10.248  32.568  29.542  1.00 80.00           C
ATOM    720  C4'  DC D 102     -10.650  31.174  29.997  1.00 80.00           C
ATOM    721  O4'  DC D 102     -11.953  30.875  29.427  1.00 80.00           O
ATOM    722  C3'  DC D 102      -9.734  30.044  29.533  1.00 80.00           C
ATOM    723  O3'  DC D 102      -9.801  28.887  30.393  1.00 80.00           O
ATOM    724  C2'  DC D 102     -10.339  29.760  28.167  1.00 80.00           C
ATOM    725  C1'  DC D 102     -11.822  29.805  28.513  1.00 80.00           C
ATOM    726  N1   DC D 102     -12.689  30.033  27.325  1.00 80.00           N
ATOM    727  C2   DC D 102     -13.545  29.015  26.894  1.00 80.00           C
ATOM    728  O2   DC D 102     -13.573  27.948  27.515  1.00 80.00           O
ATOM    729  N3   DC D 102     -14.325  29.230  25.808  1.00 80.00           N
ATOM    730  C4   DC D 102     -14.266  30.397  25.167  1.00 80.00           C
ATOM    731  N4   DC D 102     -15.054  30.562  24.100  1.00 80.00           N
ATOM    732  C5   DC D 102     -13.397  31.445  25.589  1.00 80.00           C
ATOM    733  C6   DC D 102     -12.632  31.222  26.661  1.00 80.00           C
ATOM    734  P    DT D 103      -9.742  27.408  29.757  1.00 80.00           P
ATOM    735  OP1  DT D 103      -8.653  27.402  28.756  1.00 80.00           O
ATOM    736  OP2  DT D 103     -11.127  27.069  29.356  1.00 80.00           O
ATOM    737  O5'  DT D 103      -9.322  26.402  30.937  1.00 80.00           O
ATOM    738  C5'  DT D 103      -8.623  25.175  30.645  1.00 80.00           C
ATOM    739  C4'  DT D 103      -9.475  24.128  29.936  1.00 80.00           C
ATOM    740  O4'  DT D 103     -10.440  24.766  29.058  1.00 80.00           O
ATOM    741  C3'  DT D 103      -8.679  23.162  29.052  1.00 80.00           C
ATOM    742  O3'  DT D 103      -8.976  21.764  29.316  1.00 80.00           O
ATOM    743  C2'  DT D 103      -9.015  23.609  27.628  1.00 80.00           C
ATOM    744  C1'  DT D 103     -10.447  24.090  27.818  1.00 80.00           C
ATOM    745  N1   DT D 103     -11.003  24.949  26.718  1.00 80.00           N
ATOM    746  C2   DT D 103     -12.034  24.430  25.972  1.00 80.00           C
ATOM    747  O2   DT D 103     -12.494  23.323  26.173  1.00 80.00           O
ATOM    748  N3   DT D 103     -12.507  25.251  24.981  1.00 80.00           N
ATOM    749  C4   DT D 103     -12.065  26.519  24.662  1.00 80.00           C
ATOM    750  O4   DT D 103     -12.555  27.182  23.750  1.00 80.00           O
ATOM    751  C5   DT D 103     -10.984  27.005  25.480  1.00 80.00           C
ATOM    752  C7   DT D 103     -10.426  28.371  25.217  1.00 80.00           C
ATOM    753  C6   DT D 103     -10.508  26.211  26.455  1.00 80.00           C
ATOM    754  P    DG D 104     -10.432  21.076  29.251  1.00 80.00           P
ATOM    755  OP1  DG D 104     -11.129  21.475  28.009  1.00 80.00           O
ATOM    756  OP2  DG D 104     -11.073  21.312  30.562  1.00 80.00           O
ATOM    757  O5'  DG D 104     -10.103  19.510  29.135  1.00 80.00           O
ATOM    758  C5'  DG D 104     -11.141  18.530  29.257  1.00 80.00           C
ATOM    759  C4'  DG D 104     -11.682  18.044  27.919  1.00 80.00           C
ATOM    760  O4'  DG D 104     -11.943  19.164  27.033  1.00 80.00           O
ATOM    761  C3'  DG D 104     -10.746  17.143  27.123  1.00 80.00           C
ATOM    762  O3'  DG D 104     -11.473  16.393  26.164  1.00 80.00           O
ATOM    763  C2'  DG D 104      -9.943  18.195  26.379  1.00 80.00           C
ATOM    764  C1'  DG D 104     -11.135  19.001  25.884  1.00 80.00           C
ATOM    765  N9   DG D 104     -10.819  20.306  25.321  1.00 80.00           N
ATOM    766  C8   DG D 104      -9.750  21.118  25.604  1.00 80.00           C
ATOM    767  N7   DG D 104      -9.751  22.234  24.927  1.00 80.00           N
ATOM    768  C5   DG D 104     -10.895  22.155  24.148  1.00 80.00           C
ATOM    769  C6   DG D 104     -11.423  23.072  23.212  1.00 80.00           C
ATOM    770  O6   DG D 104     -10.969  24.173  22.871  1.00 80.00           O
ATOM    771  N1   DG D 104     -12.602  22.591  22.649  1.00 80.00           N
ATOM    772  C2   DG D 104     -13.188  21.385  22.956  1.00 80.00           C
ATOM    773  N2   DG D 104     -14.323  21.091  22.310  1.00 80.00           N
ATOM    774  N3   DG D 104     -12.703  20.518  23.830  1.00 80.00           N
ATOM    775  C4   DG D 104     -11.560  20.974  24.383  1.00 80.00           C
ATOM    776  P    DA D 105     -12.709  15.446  26.533  1.00 80.00           P
ATOM    777  OP1  DA D 105     -12.866  15.434  28.004  1.00 80.00           O
ATOM    778  OP2  DA D 105     -12.545  14.167  25.806  1.00 80.00           O
ATOM    779  O5'  DA D 105     -13.943  16.220  25.870  1.00 80.00           O
ATOM    780  C5'  DA D 105     -13.723  17.284  24.953  1.00 80.00           C
ATOM    781  C4'  DA D 105     -13.471  16.809  23.536  1.00 80.00           C
ATOM    782  O4'  DA D 105     -12.949  17.930  22.780  1.00 80.00           O
ATOM    783  C3'  DA D 105     -12.428  15.711  23.364  1.00 80.00           C
ATOM    784  O3'  DA D 105     -12.672  14.997  22.160  1.00 80.00           O
ATOM    785  C2'  DA D 105     -11.149  16.530  23.285  1.00 80.00           C
ATOM    786  C1'  DA D 105     -11.657  17.587  22.321  1.00 80.00           C
ATOM    787  N9   DA D 105     -10.845  18.789  22.180  1.00 80.00           N
ATOM    788  C8   DA D 105      -9.655  19.109  22.770  1.00 80.00           C
ATOM    789  N7   DA D 105      -9.190  20.286  22.405  1.00 80.00           N
ATOM    790  C5   DA D 105     -10.134  20.764  21.508  1.00 80.00           C
ATOM    791  C6   DA D 105     -10.247  21.953  20.752  1.00 80.00           C
ATOM    792  N6   DA D 105      -9.362  22.957  20.761  1.00 80.00           N
ATOM    793  N1   DA D 105     -11.334  22.079  19.968  1.00 80.00           N
ATOM    794  C2   DA D 105     -12.235  21.092  19.939  1.00 80.00           C
ATOM    795  N3   DA D 105     -12.240  19.939  20.594  1.00 80.00           N
ATOM    796  C4   DA D 105     -11.153  19.842  21.364  1.00 80.00           C
ATOM    797  P    DT D 106     -13.616  13.707  22.181  1.00 80.00           P
ATOM    798  OP1  DT D 106     -14.095  13.505  23.565  1.00 80.00           O
ATOM    799  OP2  DT D 106     -12.912  12.622  21.469  1.00 80.00           O
ATOM    800  O5'  DT D 106     -14.845  14.133  21.259  1.00 80.00           O
ATOM    801  C5'  DT D 106     -15.043  15.493  20.926  1.00 80.00           C
ATOM    802  C4'  DT D 106     -14.211  15.836  19.708  1.00 80.00           C
ATOM    803  O4'  DT D 106     -13.046  16.617  20.057  1.00 80.00           O
ATOM    804  C3'  DT D 106     -13.664  14.624  18.960  1.00 80.00           C
ATOM    805  O3'  DT D 106     -14.110  14.704  17.632  1.00 80.00           O
ATOM    806  C2'  DT D 106     -12.149  14.788  19.039  1.00 80.00           C
ATOM    807  C1'  DT D 106     -12.120  16.304  19.045  1.00 80.00           C
ATOM    808  N1   DT D 106     -10.805  16.957  19.301  1.00 80.00           N
ATOM    809  C2   DT D 106     -10.613  18.180  18.712  1.00 80.00           C
ATOM    810  O2   DT D 106     -11.469  18.700  18.027  1.00 80.00           O
ATOM    811  N3   DT D 106      -9.399  18.767  18.952  1.00 80.00           N
ATOM    812  C4   DT D 106      -8.366  18.258  19.712  1.00 80.00           C
ATOM    813  O4   DT D 106      -7.312  18.870  19.865  1.00 80.00           O
ATOM    814  C5   DT D 106      -8.636  16.968  20.297  1.00 80.00           C
ATOM    815  C7   DT D 106      -7.584  16.275  21.169  1.00 30.00           C
ATOM    816  C6   DT D 106      -9.820  16.374  20.073  1.00 80.00           C
ATOM    817  P    DG D 107     -14.206  13.357  16.795  1.00 80.00           P
ATOM    818  OP1  DG D 107     -15.637  13.030  16.608  1.00 80.00           O
ATOM    819  OP2  DG D 107     -13.314  12.373  17.442  1.00 80.00           O
ATOM    820  O5'  DG D 107     -13.575  13.784  15.391  1.00 80.00           O
ATOM    821  C5'  DG D 107     -14.392  14.473  14.460  1.00 80.00           C
ATOM    822  C4'  DG D 107     -13.692  15.725  13.979  1.00 80.00           C
ATOM    823  O4'  DG D 107     -12.779  16.166  15.009  1.00 80.00           O
ATOM    824  C3'  DG D 107     -12.860  15.564  12.711  1.00 80.00           C
ATOM    825  O3'  DG D 107     -13.367  16.436  11.713  1.00 80.00           O
ATOM    826  C2'  DG D 107     -11.445  15.962  13.125  1.00 80.00           C
ATOM    827  C1'  DG D 107     -11.691  16.791  14.374  1.00 80.00           C
ATOM    828  N9   DG D 107     -10.575  16.778  15.306  1.00 80.00           N
ATOM    829  C8   DG D 107     -10.456  15.991  16.421  1.00 80.00           C
ATOM    830  N7   DG D 107      -9.346  16.190  17.076  1.00 80.00           N
ATOM    831  C5   DG D 107      -8.687  17.172  16.349  1.00 80.00           C
ATOM    832  C6   DG D 107      -7.433  17.790  16.576  1.00 80.00           C
ATOM    833  O6   DG D 107      -6.627  17.591  17.495  1.00 80.00           O
ATOM    834  N1   DG D 107      -7.143  18.732  15.594  1.00 80.00           N
ATOM    835  C2   DG D 107      -7.962  19.034  14.532  1.00 80.00           C
ATOM    836  N2   DG D 107      -7.510  19.971  13.689  1.00 80.00           N
ATOM    837  N3   DG D 107      -9.137  18.461  14.306  1.00 80.00           N
ATOM    838  C4   DG D 107      -9.434  17.544  15.254  1.00 80.00           C
ATOM    839  P    DT D 108     -13.261  16.062  10.162  1.00 80.00           P
ATOM    840  OP1  DT D 108     -14.311  16.797   9.424  1.00 80.00           O
ATOM    841  OP2  DT D 108     -13.216  14.591  10.061  1.00 80.00           O
ATOM    842  O5'  DT D 108     -11.841  16.670   9.752  1.00 80.00           O
ATOM    843  C5'  DT D 108     -10.665  15.894   9.901  1.00 80.00           C
ATOM    844  C4'  DT D 108      -9.467  16.798  10.079  1.00 80.00           C
ATOM    845  O4'  DT D 108      -9.212  16.988  11.487  1.00 80.00           O
ATOM    846  C3'  DT D 108      -8.155  16.231   9.575  1.00 80.00           C
ATOM    847  O3'  DT D 108      -8.061  16.397   8.176  1.00 80.00           O
ATOM    848  C2'  DT D 108      -7.166  17.136  10.292  1.00 80.00           C
ATOM    849  C1'  DT D 108      -7.865  17.394  11.624  1.00 80.00           C
ATOM    850  N1   DT D 108      -7.233  16.701  12.786  1.00 80.00           N
ATOM    851  C2   DT D 108      -5.968  17.085  13.161  1.00 80.00           C
ATOM    852  O2   DT D 108      -5.349  17.952  12.584  1.00 80.00           O
ATOM    853  N3   DT D 108      -5.446  16.419  14.237  1.00 80.00           N
ATOM    854  C4   DT D 108      -6.051  15.422  14.970  1.00 80.00           C
ATOM    855  O4   DT D 108      -5.499  14.881  15.926  1.00 80.00           O
ATOM    856  C5   DT D 108      -7.374  15.067  14.525  1.00 80.00           C
ATOM    857  C7   DT D 108      -8.126  13.993  15.248  1.00 80.00           C
ATOM    858  C6   DT D 108      -7.900  15.710  13.471  1.00 80.00           C
END
"""

def exercise_00():
  def get_ab(params):
    pdb_inp = iotbx.pdb.input(lines=pdb_str_00.split('\n'), source_info=None)
    m = mmtbx.model.manager(model_input=pdb_inp)
    m.process(make_restraints=True)
    xray_structure = m.get_xray_structure()
    assert xray_structure is not None
    s = flex.bool(xray_structure.scatterers().size(),flex.size_t(range(40,504)))
    geometry = m.get_restraints_manager().geometry
    geometry = geometry.select(s)
    es = geometry.energies_sites(
      sites_cart = xray_structure.sites_cart().select(s))
    a = es.angle_deviations()[2]
    b = es.bond_deviations()[2]
    return a, b
  # default
  a1,b1 = get_ab(params=None)
  # using custom bonds
  params = mmtbx.model.manager.get_default_pdb_interpretation_params()
  params.pdb_interpretation.automatic_linking.link_all=True
  params.pdb_interpretation.secondary_structure.enabled=True
  params.pdb_interpretation.secondary_structure.nucleic_acid.base_pair[0].restrain_hbonds=True
  params.pdb_interpretation.secondary_structure.nucleic_acid.base_pair[0].restrain_hb_angles=True
  a2,b2 = get_ab(params=params)
  #
  assert approx_equal(a1,a2)
  assert approx_equal(b1,b2)

def exercise():
  pdb_file = libtbx.env.find_in_repositories(
                   relative_path="phenix_regression/pdb/enk.pdb", test=os.path.isfile)
  mol = mmtbx.model.manager(
      model_input = iotbx.pdb.input(file_name=pdb_file))
  mol.process(make_restraints=True)
  mol.setup_scattering_dictionaries(scattering_table = "wk1995")
################


  # Not clear why one needed 2 identical files...
  mol_copy = mol.deep_copy()
  assert mol.number_of_ordered_solvent_molecules() == 9
  f1 = open("test_model_out.pdb","w")
  f2 = open("test_model_out_nohydrogens.pdb","w")
  pdb_str = mol.model_as_pdb()
  f1.write(pdb_str)
  pdb_str = mol.model_as_pdb()
  f2.write(pdb_str)
  f1.close()
  f2.close()
  mol = mol.remove_solvent()
  assert mol.number_of_ordered_solvent_molecules() == 0
  f1 = open("test_model_out_nosolvent.pdb","w")
  f2 = open("test_model_out_noO.pdb","w")
  pdb_str = mol.model_as_pdb()
  f1.write(pdb_str)
  pdb_str = mol.model_as_pdb()
  f2.write(pdb_str)
  f1.close()
  f2.close()
  mol.geometry_statistics().show()
  mol.geometry_statistics().show()

################
  selection = flex.bool(mol.get_number_of_atoms(), True)
  mol_other = mol.select(selection)
  mol_other.setup_scattering_dictionaries(scattering_table = "wk1995")
################

  mol_other.geometry_statistics()
  print()
  mol.geometry_statistics()

#####
  class iso: pass
  iso.sphere_radius = 5.0
  iso.distance_power = 1.57
  iso.average_power = 0.58
  iso.wilson_b_weight_auto = False
  iso.wilson_b_weight = None
  iso.plain_pairs_radius = 5.0
  iso.refine_ap_and_dp = False
  iso.use_u_local_only = False
#####
  import sys
  mol.show_adp_statistics(out=sys.stdout)
  print()
  mol.show_adp_statistics(out=sys.stdout)

  rm = mol.restraints_manager

  # Not clear why one needed 2 identical files...
  f1 = open("XXX.pdb","w")
  f2 = open("XXXr.pdb","w")
  pdb_str = mol_copy.model_as_pdb()
  f1.write(pdb_str)
  pdb_str = mol_copy.model_as_pdb()
  f2.write(pdb_str)
  f1.close()
  f2.close()

def exercise_2():
  pdb_file = libtbx.env.find_in_repositories(
                   relative_path="phenix_regression/pdb/adp_out_stat.pdb", test=os.path.isfile)
  params = mmtbx.model.manager.get_default_pdb_interpretation_params()
  params.pdb_interpretation.nonbonded_weight = 16
  params.pdb_interpretation.clash_guard.nonbonded_distance_threshold = None # disable clash_guard
  mol = mmtbx.model.manager(
      model_input = iotbx.pdb.input(file_name=pdb_file))
  mol.process(pdb_interpretation_params=params, make_restraints=True)
  mol.setup_scattering_dictionaries(scattering_table = "wk1995")
  out = StringIO()
  adp_stat = mol.show_adp_statistics(out = out)

def exercise_3():
  pdb_file = libtbx.env.find_in_repositories(
    relative_path="phenix_regression/pdb/arg_h_hohh1_sh.pdb",
    test=os.path.isfile)
  params = mmtbx.model.manager.get_default_pdb_interpretation_params()
  params.pdb_interpretation.nonbonded_weight = 16
  mol = mmtbx.model.manager(
    model_input               = iotbx.pdb.input(file_name=pdb_file))
  mol.process(pdb_interpretation_params=params, make_restraints=True)
  mol.setup_scattering_dictionaries(scattering_table = "wk1995")
  out = StringIO()
  mol.set_log(out)
  mol.idealize_h_minimization()
  assert out.getvalue().splitlines()[0] == \
  "X-H deviation from ideal before regularization (bond): mean= 0.201 max= 0.636", \
  out.getvalue().splitlines()[0]
  assert out.getvalue().splitlines()[1] == \
  "X-H deviation from ideal after  regularization (bond): mean= 0.000 max= 0.000"
  #diffs = flex.double()
  #for it in mol.xh_connectivity_table():
  #  diffs.append(abs(it[3]-it[4]))
  #mmm = diffs.min_max_mean()
  #print mmm.as_tuple()
  #assert mmm.max <0.01 , mmm.max
  #assert mmm.mean<0.001, mmm.mean

def exercise_4():
  pdb_file = libtbx.env.find_in_repositories(
    relative_path="phenix_regression/pdb/lysozyme_noH.pdb",
    test=os.path.isfile)
  mol = mmtbx.model.manager(
      model_input = iotbx.pdb.input(file_name=pdb_file))
  mol.process(make_restraints=True)
  result = mol.isolated_atoms_selection()
  solvent_sel = mol.solvent_selection()
  assert solvent_sel.count(True)+1 == result.count(True)

def exercise_convert_atom():
  from iotbx.pdb import hierarchy
  from cctbx import crystal
  from cctbx.xray import anomalous_scatterer_group
  coords = [ (2.12, 0., 0.), (0., 2.12, 0.), (0, 0, 2.12), (0,0,0),
             (-2.12, 0, 0), (0, -2.12, 0), (0, 0, -2.12) ]
  root = hierarchy.root()
  model = hierarchy.model()
  chain = hierarchy.chain(id="S")
  root.append_model(model)
  model.append_chain(chain)
  for k, xyz in enumerate(coords):
    rg = hierarchy.residue_group(resseq=str(k+1))
    ag = hierarchy.atom_group(resname="HOH")
    atom = hierarchy.atom()
    atom.serial = str(k+1)
    atom.name = " O  "
    atom.occ = 1.0
    atom.b = 20.0
    atom.xyz=  xyz
    atom.element = " O"
    ag.append_atom(atom)
    rg.append_atom_group(ag)
    chain.append_residue_group(rg)
  symm = crystal.symmetry(
    space_group_symbol="P1",
    unit_cell=(10,10,10,90,90,90))
  open("tmp_tst_model_5.pdb", "w").write(root.as_pdb_string(symm))
  mol = mmtbx.model.manager(
      model_input = iotbx.pdb.input(file_name="tmp_tst_model_5.pdb"))
  mol.process(make_restraints=True)
  mol.convert_atom(
    i_seq=4,
    scattering_type="Mg2+",
    atom_name="MG",
    element="MG",
    charge=2,
    residue_name="MG",
    initial_occupancy=0.99,
    chain_id='X')
  mol.set_anomalous_scatterer_groups(
      [anomalous_scatterer_group(
          iselection=flex.size_t([4]),
          f_prime=0,
          f_double_prime=0,
          refine=["f_prime","f_double_prime"],
          selection_string="element MG",
          update_from_selection=True),]
      )
  geometry_minimization.run2(
      restraints_manager = mol.get_restraints_manager(),
      pdb_hierarchy = mol.get_hierarchy(),
      correct_special_position_tolerance = 1.,
      nonbonded = True,
      )
  mol.set_sites_cart_from_hierarchy()
  # if the nonbonded type is set correctly, the nonbonded restraints should
  # not push the
  for atom in mol.get_hierarchy().atoms():
    xyz_max = max([ abs(n) for n in atom.xyz])
    assert (xyz_max < 2.6), 'max %s is larger than 2.6' % xyz_max
  mol = mol.select(flex.size_t([1,2,3,4,5,6]))
  assert mol.have_anomalous_scatterer_groups()
  # assert mol.update_anomalous_groups(out=null_out()) # not needed because select() processed groups correctly
  isel = mol.get_anomalous_scatterer_groups()[0].iselection
  assert list(isel) == [3]

pdb_file_exercise_h_counts="""
CRYST1    8.228   11.366   10.991  90.00  90.00  90.00 P 1
ATOM      1  N  AGLY B   1       3.102   3.878   3.794  0.70  7.85           N
ATOM      2  CA AGLY B   1       3.985   4.960   4.314  0.70  6.79           C
ATOM      3  C  AGLY B   1       5.454   4.600   4.162  0.70  5.59           C
ATOM      4  O  AGLY B   1       5.756   3.431   3.920  0.70  6.04           O
ATOM      5  H1 AGLY B   1       2.660   4.173   3.080  0.70  7.85           H
ATOM      6  H2 AGLY B   1       3.597   3.175   3.566  0.70  7.85           H
ATOM      7  H3 AGLY B   1       2.522   3.640   4.425  0.70  7.85           H
ATOM      8  HA2AGLY B   1       3.815   5.782   3.828  0.70  6.79           H
ATOM      9  HA3AGLY B   1       3.798   5.111   5.254  0.70  6.79           H
ATOM     10  N  BGLY B   1       4.731   2.369   3.426  0.30  7.85           N
ATOM     11  CA BGLY B   1       5.847   3.227   3.917  0.30  6.79           C
ATOM     12  C  BGLY B   1       5.408   4.661   4.138  0.30  5.59           C
ATOM     13  O  BGLY B   1       4.212   4.956   4.163  0.30  6.04           O
ATOM     14  H1 BGLY B   1       4.655   1.653   3.949  0.30  7.85           H
ATOM     15  H2 BGLY B   1       3.971   2.832   3.444  0.30  7.85           H
ATOM     16  H3 BGLY B   1       4.901   2.110   2.592  0.30  7.85           H
ATOM     17  HA2BGLY B   1       6.182   2.874   4.756  0.30  6.79           H
ATOM     18  HA3BGLY B   1       6.569   3.222   3.269  0.30  6.79           H
ATOM     19  N   CYS B   2       6.380   5.555   4.293  1.00  5.95           N
ATOM     20  CA  CYS B   2       6.109   6.982   4.531  1.00  5.17           C
ATOM     21  C   CYS B   2       5.169   7.274   5.709  1.00  4.74           C
ATOM     22  O   CYS B   2       5.516   7.016   6.861  1.00  4.51           O
ATOM     23  CB  CYS B   2       5.631   7.673   3.244  1.00  5.99           C
ATOM     24  SG  CYS B   2       5.163   9.405   3.466  1.00  5.51           S
ATOM     25  H   CYS B   2       7.222   5.382   4.256  1.00  5.95           H
ATOM     26  HA  CYS B   2       6.956   7.396   4.758  1.00  5.17           H
ATOM     27  HB2 CYS B   2       6.346   7.642   2.590  1.00  5.99           H
ATOM     28  HB3 CYS B   2       4.856   7.199   2.905  1.00  5.99           H
ATOM     29  HG  CYS B   2       4.807   9.852   2.411  1.00  5.51           H
ATOM     30  N   CYS B   3       3.986   7.810   5.419  1.00  4.88           N
ATOM     31  CA  CYS B   3       3.018   8.129   6.461  1.00  5.24           C
ATOM     32  C   CYS B   3       2.431   6.857   7.062  1.00  6.13           C
ATOM     33  O   CYS B   3       1.976   6.851   8.205  1.00  7.85           O
ATOM     34  CB  CYS B   3       1.896   9.003   5.897  1.00  4.92           C
ATOM     35  SG  CYS B   3       2.450  10.600   5.255  1.00  6.13           S
ATOM     36  H   CYS B   3       3.720   7.999   4.623  1.00  4.88           H
ATOM     37  HA  CYS B   3       3.461   8.623   7.169  1.00  5.24           H
ATOM     38  HB2 CYS B   3       1.466   8.526   5.170  0.30  4.92           H
ATOM     39  HB3 CYS B   3       1.252   9.176   6.602  0.10  4.92           H
ATOM     40  HG  CYS B   3       3.237  10.413   4.368  1.00  6.13           H
TER
ATOM     41  O   HOH C   1       1.194   0.871   7.026  1.00  7.85           O
ATOM     42  H1  HOH C   1       2.011   1.046   7.112  1.00  7.85           H
ATOM     43  H2  HOH C   1       0.786   1.605   7.030  1.00  7.85           H
ATOM     44  O   HOH C   2       2.387   2.996   6.915  1.00  6.79           O
ATOM     45  H1  HOH C   2       3.061   3.497   6.915  1.00  6.79           H
ATOM     46  H2  HOH C   2       1.712   3.496   6.915  1.00  6.79           H
ATOM     47  O   HOH C   3       6.169   4.601   8.563  1.00  5.59           O
ATOM     48  D1  HOH C   3       6.992   4.768   8.578  1.00  5.59           D
ATOM     49  D2  HOH C   3       5.784   5.301   8.302  1.00  5.59           D
TER
END
"""

def exercise_h_counts():
  of = open("exercise_h_counts.pdb", "w")
  print(pdb_file_exercise_h_counts, file=of)
  of.close()
  pdb_inp = iotbx.pdb.input(file_name = "exercise_h_counts.pdb")
  model = mmtbx.model.manager(
      model_input = pdb_inp)
  model.process(make_restraints=True)
  model.setup_scattering_dictionaries(scattering_table="n_gaussian")
  hc = model.h_counts()
  assert approx_equal(hc.h_count                , 26   , 0.01)
  assert approx_equal(hc.h_occ_sum              , 19.4 , 0.01)
  assert approx_equal(hc.h_fraction_of_total    , 50.52, 0.01)
  assert approx_equal(hc.hrot_count             , 8    , 0.01)
  assert approx_equal(hc.hrot_occ_sum           , 5    , 0.01)
  assert approx_equal(hc.hrot_fraction_of_total , 13.02, 0.01)
  model.show_h_counts()

def exercise_5():
  pdb_str = """
CRYST1   98.237   98.237   87.605  90.00  90.00 120.00 P 31 2 1     18
HETATM 2731  O  AHOH A 380      19.567  26.060  41.021  0.50 32.01           O
ANISOU 2731  O  AHOH A 380     4916   4203   3042    782    151  -1380       O
HETATM 2732  O  BHOH A 380      19.179  25.528  38.229  0.50 20.88           O
ANISOU 2732  O  BHOH A 380     3169   2234   2532   1183    675   -168       O
"""
  of = open("exercise_5.pdb", "w")
  print(pdb_str, file=of)
  of.close()
  pdb_inp = iotbx.pdb.input(file_name = "exercise_5.pdb")
  model = mmtbx.model.manager(
      model_input = pdb_inp)
  model.process(make_restraints=True)
  model.setup_scattering_dictionaries(scattering_table="n_gaussian")
  result = model.extract_water_residue_groups()
  assert len(result)==1

def exercise_6():
  pdb_inp = iotbx.pdb.input(lines=pdb_str_00.split('\n'), source_info=None)
  m = mmtbx.model.manager(model_input=pdb_inp)
  m.process(make_restraints=True)
  ms = m.geometry_statistics()
  ms.show()
  #
  # IF you are about to change this - STOP! Likely you're doing something wrong!
  # Essentially, this test is to prevent inserting parameters into
  # mmtbx.model.statistics without much thinking. Most of parameters should
  # go elsewhere.
  #
  import inspect
  r = inspect.getargspec(mmtbx.model.statistics.geometry.__init__)
  assert r.args == ['self', 'model', 'fast_clash', 'condensed_probe',
    'use_hydrogens'], r.args

def exercise_from_hierarchy():
  def check_consistency(m1, m2):
    assert approx_equal(m1.get_sites_cart(), m2.get_sites_cart())
    assert approx_equal(m1.get_xray_structure().sites_cart(),
                        m2.get_xray_structure().sites_cart())
    assert m1.crystal_symmetry().is_similar_symmetry(m2.crystal_symmetry())
    assert not show_diff(m1.model_as_pdb(), m2.model_as_pdb())
    assert not show_diff(m1.model_as_mmcif(), m2.model_as_mmcif())
    grm1 = m1.get_restraints_manager()
    grm2 = m2.get_restraints_manager()
    geo1 = m1.restraints_as_geo()
    geo2 = m2.restraints_as_geo()
    # mixed order in nonbonded. It is fine since everything else below
    # matches perfectly
    # assert not show_diff(geo1, geo2)
    es1 = grm1.energies_sites(m1.get_sites_cart(), compute_gradients=True)
    es2 = grm2.energies_sites(m2.get_sites_cart(), compute_gradients=True)
    print(es1.residual_sum)
    print(es1.target)
    assert approx_equal(es1.residual_sum, es2.residual_sum)
    assert approx_equal(es1.target, es2.target)
    assert approx_equal(es1.gradients, es2.gradients)

  pdb_inp1 = iotbx.pdb.input(lines=pdb_str_00.split('\n'), source_info=None)
  pdb_inp2 = iotbx.pdb.input(lines=pdb_str_00.split('\n'), source_info=None)
  m1 = mmtbx.model.manager(model_input = pdb_inp1)
  m1.process(make_restraints=True)
  m2 = mmtbx.model.manager(
      model_input = None,
      crystal_symmetry = pdb_inp2.crystal_symmetry(),
      pdb_hierarchy=pdb_inp2.construct_hierarchy())
  m2.process(make_restraints=True)
  check_consistency(m1, m2)
  sel = m1.selection("chain A")
  m11 = m1.select(sel)
  m22 = m2.select(sel)
  check_consistency(m11, m22)

def exercise_7():
  lines = """
CRYST1   43.974   32.795   33.672  90.00  90.00  90.00 P 1
ATOM     56  N   ARG A  10      27.185  16.460  17.483  1.00  2.08           N
ATOM     57  CA  ARG A  10      26.022  16.782  18.294  1.00  2.02           C
ATOM     58  C   ARG A  10      25.096  17.774  17.594  1.00  2.02           C
ATOM     59  O   ARG A  10      23.865  17.608  17.611  1.00  2.22           O
ATOM     60  CB  ARG A  10      26.464  17.332  19.652  1.00  2.22           C
ATOM     61  CG  ARG A  10      25.307  17.788  20.546  1.00  2.51           C
ATOM     62  CD  ARG A  10      24.394  16.657  21.045  1.00  2.89           C
ATOM     63  NE  ARG A  10      25.123  15.776  21.930  1.00  3.18           N
ATOM     64  CZ  ARG A  10      24.571  14.673  22.470  1.00  4.37           C
ATOM     65  NH1 ARG A  10      23.310  14.331  22.245  1.00  6.14           N
ATOM     66  NH2 ARG A  10      25.349  13.908  23.244  1.00  5.58           N
ATOM     67  H   ARG A  10      28.082  16.725  17.890  1.00  2.08           H
ATOM     68  HA  ARG A  10      25.458  15.861  18.445  1.00  2.02           H
ATOM     69  HB2 ARG A  10      27.033  16.564  20.176  1.00  2.22           H
ATOM     70  HB3 ARG A  10      27.138  18.173  19.490  1.00  2.22           H
ATOM     71  HG2 ARG A  10      25.718  18.312  21.409  1.00  2.51           H
ATOM     72  HG3 ARG A  10      24.702  18.508  19.995  1.00  2.51           H
ATOM     73  HD2 ARG A  10      23.535  17.078  21.567  1.00  2.89           H
ATOM     74  HD3 ARG A  10      24.007  16.092  20.197  1.00  2.89           H
ATOM     75  HE  ARG A  10      26.093  15.999  22.154  1.00  3.18           H
ATOM     76 HH11 ARG A  10      22.723  14.911  21.645  1.00  6.14           H
ATOM     77 HH12 ARG A  10      22.926  13.488  22.672  1.00  6.14           H
ATOM     78 HH21 ARG A  10      26.322  14.169  23.406  1.00  5.58           H
ATOM     79 HH22 ARG A  10      24.970  13.064  23.672  1.00  5.58           H
TER
END
"""
  for use_neutron_distances in [True, False]:
    params = mmtbx.model.manager.get_default_pdb_interpretation_params()
    params.pdb_interpretation.use_neutron_distances=use_neutron_distances
    model = mmtbx.model.manager(
      model_input = iotbx.pdb.input(source_info=None, lines=lines),
      log = null_out())
    model.process(pdb_interpretation_params=params, make_restraints=True)
    gs = model.geometry_statistics(use_hydrogens = True).result()
    if(use_neutron_distances):
      assert approx_equal(gs.bond.mean, 0.0068, 0.0001)
    else:
      assert approx_equal(gs.bond.mean, 0.1054, 0.0001)
    bps, asu = model.get_restraints_manager().geometry.get_all_bond_proxies(
      sites_cart = model.get_sites_cart())
    elems = model.get_hierarchy().atoms().extract_element()
    cntr=0
    for p in bps:
      i, j = p.i_seqs
      if([elems[i], elems[j]].count("H")):
        if(use_neutron_distances): assert p.distance_ideal > 1.0
        else:                      assert p.distance_ideal < 1.0
        cntr+=1
    assert cntr==13

def exercise_8():
  """
  Indirectly make sure new model from model.selection() does not inherit
  pdb_interpretation object as it becomes obsolete as result of selection.
  """
  pdb_str = """
CRYST1   17.862   33.032   12.451  90.00  90.00  90.00 P 21 21 21    0
HETATM    1  O   MPR A   5      -3.288   3.784  12.142  1.00  0.05           O
HETATM    2  C1  MPR A   5      -2.721   3.156  13.026  1.00  0.04           C
HETATM    3  C2  MPR A   5      -3.033   3.296  14.510  1.00  0.05           C
HETATM    4  C3  MPR A   5      -3.588   4.658  14.899  1.00  0.05           C
HETATM    5  S3  MPR A   5      -2.358   5.908  15.321  1.00  0.06           S
HETATM    0  H32 MPR A   5      -4.126   4.992  14.165  1.00  0.05           H
HETATM    0  H31 MPR A   5      -4.182   4.543  15.657  1.00  0.05           H
HETATM    0  H22 MPR A   5      -3.673   2.612  14.763  1.00  0.05           H
HETATM    0  H21 MPR A   5      -2.224   3.129  15.018  1.00  0.05           H
ATOM     10  N   CYS A   6      -1.838   2.168  12.744  1.00  0.05           N
ATOM     11  CA  CYS A   6      -1.501   1.856  11.357  1.00  0.04           C
ATOM     12  C   CYS A   6      -2.711   1.429  10.499  1.00  0.04           C
ATOM     13  O   CYS A   6      -2.700   1.672   9.296  1.00  0.04           O
ATOM     14  CB  CYS A   6      -0.431   0.750  11.269  1.00  0.05           C
ATOM     15  SG  CYS A   6       1.221   1.279  11.825  1.00  0.06           S
ATOM      0  HA  CYS A   6      -1.159   2.690  10.998  1.00  0.04           H
ATOM      0  HB2 CYS A   6      -0.716  -0.007  11.804  1.00  0.05           H
ATOM      0  HB3 CYS A   6      -0.371   0.442  10.351  1.00  0.05           H
  """
  pdb_inp = iotbx.pdb.input(source_info=None, lines = pdb_str)
  model = mmtbx.model.manager(
    model_input = pdb_inp,
    log         = null_out())
  model.process(make_restraints=True)
  sel = model.selection(string = "element H and not protein")
  model = model.select(~sel)
  sel = model.selection(string="protein")
  assert model.size() == sel.size(), [model.size(), sel.size()]

def exercise_9():
  """
  Exercise rotamer_outlier_selection.
  """
  pdb_str = """
CRYST1   82.497   82.497  134.586  90.00  90.00 120.00 P 32 2 1
ATOM      0  N   LYS A 228      16.753  49.364  44.427  1.00 29.71           N
ATOM      1  CA  LYS A 228      17.316  50.225  45.462  1.00 30.97           C
ATOM      2  C   LYS A 228      16.971  51.681  45.225  1.00 32.43           C
ATOM      3  O   LYS A 228      16.594  52.055  44.120  1.00 32.69           O
ATOM      4  CB  LYS A 228      18.841  50.152  45.390  1.00 32.79           C
ATOM      5  CG  LYS A 228      19.434  48.982  46.075  1.00 36.99           C
ATOM      6  CD  LYS A 228      20.099  49.447  47.331  1.00 40.31           C
ATOM      7  CE  LYS A 228      20.368  48.266  48.182  1.00 41.44           C
ATOM      8  NZ  LYS A 228      20.323  48.625  49.612  1.00 41.02           N
ATOM      9  N   GLN A 229      17.130  52.508  46.260  1.00 32.84           N
ATOM     10  C   GLN A 229      18.360  54.464  45.732  1.00 33.80           C
ATOM     11  O   GLN A 229      19.348  54.126  46.386  1.00 34.43           O
ATOM     12  CA AGLN A 229      16.971  53.942  46.112  0.43 33.76           C
ATOM     13  CB AGLN A 229      16.506  54.583  47.431  0.43 35.95           C
ATOM     14  CG AGLN A 229      15.176  55.322  47.295  0.43 39.53           C
ATOM     15  CD AGLN A 229      14.847  56.184  48.492  0.43 43.68           C
ATOM     16  OE1AGLN A 229      15.695  56.481  49.340  0.43 45.16           O
ATOM     17  NE2AGLN A 229      13.608  56.636  48.568  0.43 44.89           N
ATOM     18  CA BGLN A 229      16.981  53.943  46.113  0.57 33.65           C
ATOM     19  CB BGLN A 229      16.529  54.590  47.436  0.57 35.47           C
ATOM     20  CG BGLN A 229      15.105  54.230  47.849  0.57 37.90           C
ATOM     21  CD BGLN A 229      14.089  54.492  46.764  0.57 40.71           C
ATOM     22  OE1BGLN A 229      13.564  53.568  46.135  0.57 41.54           O
ATOM     23  NE2BGLN A 229      13.802  55.759  46.510  0.57 41.34           N
ATOM     24  N   ALA A 230      18.441  55.247  44.673  1.00 33.30           N
ATOM     25  CA  ALA A 230      19.683  55.848  44.191  1.00 32.95           C
ATOM     26  C   ALA A 230      19.661  57.363  44.526  1.00 32.70           C
ATOM     27  O   ALA A 230      18.597  57.905  44.844  1.00 33.61           O
ATOM     28  CB  ALA A 230      19.790  55.649  42.683  1.00 32.78           C
TER
END
  """
  pdb_inp = iotbx.pdb.input(source_info=None, lines = pdb_str)
  model = mmtbx.model.manager(
    model_input = pdb_inp,
    log         = null_out())
  model.process(make_restraints=True)
  sel = model.rotamer_outlier_selection().iselection()
  assert list(sel) == [9, 10, 11, 12, 13, 14, 15, 16, 17]

def exercise_10():
  """
  Exercise macromolecule_plus_hetatms_by_chain_selections() method.
  """
  psb_str1 = """
CRYST1   21.937    4.866   23.477  90.00 107.08  90.00 P 1 21 1      2
ATOM      0  CG  ASN A   2      -7.584   1.342   0.692  1.00 14.08           C
ATOM      1  OD1 ASN A   2      -8.025   0.227   1.016  1.00 17.46           O
ATOM      2  ND2 ASN A   2      -8.204   2.155  -0.169  1.00 11.72           N
TER
ATOM      3  C   TYR B   7      10.603   2.331   6.885  1.00 15.91           C
ATOM      4  O   TYR B   7      11.041   1.811   5.855  1.00 15.76           O
ATOM      5  OXT TYR B   7      11.358   2.999   7.612  1.00 17.49           O
TER
HETATM    6  O   HOH C   9      10.431   1.858   3.216  1.00 19.71           O
HETATM    7  O   HOH C  10     -11.286   1.756  -1.468  1.00 17.08           O
HETATM    8  O   HOH C  11      11.808   4.179   9.970  1.00 23.99           O
HETATM    9  O   HOH C  12      13.605   1.327   9.198  1.00 26.17           O
END
  """
  psb_str2 = """
CRYST1   21.937    4.866   23.477  90.00 107.08  90.00 P 1 21 1      2
ATOM      0  CG  ASN A   2      -7.584   1.342   0.692  1.00 14.08           C
ATOM      1  OD1 ASN A   2      -8.025   0.227   1.016  1.00 17.46           O
ATOM      2  ND2 ASN A   2      -8.204   2.155  -0.169  1.00 11.72           N
ATOM      3  C   TYR B   7      10.603   2.331   6.885  1.00 15.91           C
ATOM      4  O   TYR B   7      11.041   1.811   5.855  1.00 15.76           O
ATOM      5  OXT TYR B   7      11.358   2.999   7.612  1.00 17.49           O
HETATM    6  O   HOH C   9      10.431   1.858   3.216  1.00 19.71           O
HETATM    7  O   HOH C  10     -11.286   1.756  -1.468  1.00 17.08           O
HETATM    8  O   HOH C  11      11.808   4.179   9.970  1.00 23.99           O
HETATM    9  O   HOH C  12      13.605   1.327   9.198  1.00 26.17           O
END
  """
  psb_str3 = """
CRYST1   21.937    4.866   23.477  90.00 107.08  90.00 P 1 21 1      2
ATOM      0  CG  ASN A   2      -7.584   1.342   0.692  1.00 14.08           C
ATOM      1  OD1 ASN A   2      -8.025   0.227   1.016  1.00 17.46           O
ATOM      2  ND2 ASN A   2      -8.204   2.155  -0.169  1.00 11.72           N
ATOM      3  C   TYR B   7      10.603   2.331   6.885  1.00 15.91           C
ATOM      4  O   TYR B   7      11.041   1.811   5.855  1.00 15.76           O
ATOM      5  OXT TYR B   7      11.358   2.999   7.612  1.00 17.49           O
HETATM    6  O   HOH A   9      10.431   1.858   3.216  1.00 19.71           O
HETATM    7  O   HOH A  10     -11.286   1.756  -1.468  1.00 17.08           O
HETATM    8  O   HOH A  11      11.808   4.179   9.970  1.00 23.99           O
HETATM    9  O   HOH A  12      13.605   1.327   9.198  1.00 26.17           O
END
  """
  psb_str4 = """
CRYST1   21.937    4.866   23.477  90.00 107.08  90.00 P 1 21 1      2
ATOM      0  CG  ASN A   2      -7.584   1.342   0.692  1.00 14.08           C
ATOM      1  OD1 ASN A   2      -8.025   0.227   1.016  1.00 17.46           O
ATOM      2  ND2 ASN A   2      -8.204   2.155  -0.169  1.00 11.72           N
ATOM      3  C   TYR B   7      10.603   2.331   6.885  1.00 15.91           C
ATOM      4  O   TYR B   7      11.041   1.811   5.855  1.00 15.76           O
ATOM      5  OXT TYR B   7      11.358   2.999   7.612  1.00 17.49           O
HETATM    6  O   HOH B   9      10.431   1.858   3.216  1.00 19.71           O
HETATM    7  O   HOH B  10     -11.286   1.756  -1.468  1.00 17.08           O
HETATM    8  O   HOH B  11      11.808   4.179   9.970  1.00 23.99           O
HETATM    9  O   HOH B  12      13.605   1.327   9.198  1.00 26.17           O
END
  """
  psb_str5 = """
CRYST1   21.937    4.866   23.477  90.00 107.08  90.00 P 1 21 1      2
ATOM      0  CG  ASN A   2      -7.584   1.342   0.692  1.00 14.08           C
ATOM      1  OD1 ASN A   2      -8.025   0.227   1.016  1.00 17.46           O
ATOM      2  ND2 ASN A   2      -8.204   2.155  -0.169  1.00 11.72           N
TER
ATOM      3  C   TYR A   7      10.603   2.331   6.885  1.00 15.91           C
ATOM      4  O   TYR A   7      11.041   1.811   5.855  1.00 15.76           O
ATOM      5  OXT TYR A   7      11.358   2.999   7.612  1.00 17.49           O
HETATM    6  O   HOH A   9      10.431   1.858   3.216  1.00 19.71           O
HETATM    7  O   HOH A  10     -11.286   1.756  -1.468  1.00 17.08           O
HETATM    8  O   HOH A  11      11.808   4.179   9.970  1.00 23.99           O
HETATM    9  O   HOH A  12      13.605   1.327   9.198  1.00 26.17           O
END
  """
  for i, pdb_str in enumerate([psb_str1, psb_str2, psb_str3, psb_str4, psb_str5]):
    pi = iotbx.pdb.input(source_info=None, lines=pdb_str)
    m = mmtbx.model.manager(model_input = pi)
    sels = m.macromolecule_plus_hetatms_by_chain_selections()
    sels = [list(s.iselection()) for s in sels]
    assert sels == [[0, 1, 2, 7], [3, 4, 5, 6, 8, 9]]
    # Check first_resseq_as_int in hierarchy and model (same function)
    ph = pi.construct_hierarchy()
    assert m.first_resseq_as_int() == ph.first_resseq_as_int()
    assert m.last_resseq_as_int() == ph.last_resseq_as_int()


def exercise_11_ss_annotations():
  good_h_str = 'HELIX    1   1 THR A   18  ILE A   20  5                                   3'
  bad_h_str = 'HELIX    1   1 THR A   18  ILE A   20 11                                   3'
  pdb_str = """
CRYST1   32.501   39.502   44.640  90.00  90.00  90.00 P 21 21 21    4
ATOM    265  N   THR A  18      13.114   7.968   6.956  1.00  4.57           N
ATOM    266  CA  THR A  18      13.581   6.907   6.105  1.00  4.76           C
ATOM    267  C   THR A  18      14.273   5.867   7.003  1.00  4.60           C
ATOM    268  O   THR A  18      14.631   6.110   8.149  1.00  4.40           O
ATOM    269  CB  THR A  18      14.556   7.447   5.032  1.00  5.62           C
ATOM    270  OG1 THR A  18      15.710   7.880   5.759  1.00  6.08           O
ATOM    271  CG2 THR A  18      13.937   8.551   4.219  1.00  7.48           C
ATOM    279  N   LEU A  19      14.528   4.681   6.410  1.00  5.15           N
ATOM    280  CA  LEU A  19      15.074   3.599   7.202  1.00  4.83           C
ATOM    281  C   LEU A  19      16.437   3.919   7.781  1.00  4.82           C
ATOM    282  O   LEU A  19      16.736   3.482   8.909  1.00  5.18           O
ATOM    283  CB  LEU A  19      15.111   2.303   6.373  1.00  5.60           C
ATOM    284  CG  LEU A  19      13.748   1.663   6.109  1.00  6.04           C
ATOM    285  CD1 LEU A  19      13.891   0.508   5.116  1.00  7.36           C
ATOM    286  CD2 LEU A  19      13.107   1.170   7.418  1.00  7.22           C
ATOM    298  N   ILE A  20      17.306   4.658   7.066  1.00  5.11           N
ATOM    299  CA  ILE A  20      18.645   4.933   7.588  1.00  5.24           C
ATOM    300  C   ILE A  20      18.601   5.767   8.844  1.00  4.94           C
ATOM    301  O   ILE A  20      19.565   5.822   9.609  1.00  5.92           O
ATOM    302  CB  ILE A  20      19.529   5.617   6.519  1.00  6.40           C
ATOM    303  CG1 ILE A  20      21.031   5.545   6.877  1.00  9.33           C
ATOM    304  CG2 ILE A  20      19.057   7.034   6.234  1.00  7.06           C
ATOM    305  CD1 ILE A  20      21.947   6.045   5.765  1.00 12.70           C
  """
  good_inp = iotbx.pdb.input(source_info=None, lines=good_h_str+pdb_str)
  bad_inp = iotbx.pdb.input(source_info=None, lines=bad_h_str+pdb_str)
  m1 = mmtbx.model.manager(model_input = good_inp)
  m2 = mmtbx.model.manager(model_input = bad_inp, skip_ss_annotations=True)
  try:
    m2 = mmtbx.model.manager(model_input = bad_inp)
  except IndexError as e:
    assert str(e) == 'list index out of range', e
  else:
    assert 0

def run():
  exercise_00()
  exercise()
  exercise_2()
  exercise_3()
  exercise_4()
  exercise_convert_atom()
  exercise_h_counts()
  exercise_5()
  exercise_6()
  exercise_7()
  exercise_8()
  exercise_from_hierarchy()
  exercise_9()
  exercise_10()
  exercise_11_ss_annotations()
  print(format_cpu_times())

if (__name__ == "__main__"):
  run()
