from __future__ import absolute_import, division, print_function
from mmtbx.secondary_structure.build import ss_idealization as ssb
import iotbx.pdb
from iotbx.pdb import secondary_structure as ioss
from scitbx.array_family import flex
import mmtbx.model
from six.moves import range

tst_00_start_lines = """\
CRYST1  100.000  100.000  100.000  90.00  90.00  90.00 P 1
ATOM      1  N   SER A   2      35.297  13.646  38.741  1.00 25.20           N
ATOM      2  CA  SER A   2      36.338  14.513  38.201  1.00 23.89           C
ATOM      3  C   SER A   2      35.963  15.024  36.813  1.00 22.90           C
ATOM      4  O   SER A   2      36.377  16.112  36.414  1.00 23.08           O
ATOM      5  CB  SER A   2      37.676  13.773  38.145  1.00 23.11           C
ATOM      6  N   PRO A   3      35.174  14.230  36.074  1.00 22.39           N
ATOM      7  CA  PRO A   3      34.697  14.560  34.727  1.00 19.74           C
ATOM      8  C   PRO A   3      33.762  15.765  34.734  1.00 13.82           C
ATOM      9  O   PRO A   3      33.782  16.567  33.801  1.00 12.80           O
ATOM     10  CB  PRO A   3      33.930  13.302  34.316  1.00 23.07           C
ATOM     11  N   LEU A   4      32.952  15.881  35.782  1.00 11.29           N
ATOM     12  CA  LEU A   4      32.002  16.982  35.905  1.00  9.66           C
ATOM     13  C   LEU A   4      32.704  18.325  36.079  1.00  7.86           C
ATOM     14  O   LEU A   4      32.252  19.341  35.551  1.00  7.65           O
ATOM     15  CB  LEU A   4      31.045  16.734  37.073  1.00 10.57           C
ATOM     16  N   ALA A   5      33.804  18.327  36.825  1.00  8.13           N
ATOM     17  CA  ALA A   5      34.574  19.547  37.045  1.00  8.04           C
ATOM     18  C   ALA A   5      35.262  20.002  35.761  1.00  7.24           C
ATOM     19  O   ALA A   5      35.319  21.196  35.464  1.00  6.98           O
ATOM     20  CB  ALA A   5      35.597  19.336  38.151  1.00  9.33           C
ATOM     21  N   GLN A   6      35.778  19.040  35.003  1.00  6.89           N
ATOM     22  CA  GLN A   6      36.437  19.332  33.736  1.00  7.52           C
ATOM     23  C   GLN A   6      35.426  19.821  32.707  1.00  5.67           C
ATOM     24  O   GLN A   6      35.714  20.721  31.917  1.00  5.64           O
ATOM     25  CB  GLN A   6      37.166  18.093  33.212  1.00  9.58           C
ATOM     26  N   GLN A   7      34.239  19.223  32.724  1.00  5.24           N
ATOM     27  CA  GLN A   7      33.169  19.614  31.817  1.00  4.92           C
ATOM     28  C   GLN A   7      32.652  21.006  32.158  1.00  4.44           C
ATOM     29  O   GLN A   7      32.319  21.788  31.270  1.00  4.63           O
ATOM     30  CB  GLN A   7      32.024  18.600  31.868  1.00  5.87           C
ATOM     31  N   ILE A   8      32.582  21.306  33.451  1.00  4.24           N
ATOM     32  CA  ILE A   8      32.135  22.614  33.914  1.00  4.30           C
ATOM     33  C   ILE A   8      33.159  23.694  33.584  1.00  4.16           C
ATOM     34  O   ILE A   8      32.799  24.810  33.207  1.00  5.21           O
ATOM     35  CB  ILE A   8      31.871  22.618  35.431  1.00  4.60           C
ATOM     36  N   LYS A   9      34.437  23.355  33.727  1.00  4.57           N
ATOM     37  CA  LYS A   9      35.513  24.288  33.414  1.00  5.70           C
ATOM     38  C   LYS A   9      35.572  24.547  31.913  1.00  5.50           C
ATOM     39  O   LYS A   9      35.800  25.676  31.473  1.00  6.01           O
ATOM     40  CB  LYS A   9      36.855  23.746  33.909  1.00  8.15           C
ATOM     41  N   ASN A  10      35.358  23.493  31.131  1.00  5.00           N
ATOM     42  CA  ASN A  10      35.346  23.607  29.679  1.00  5.09           C
ATOM     43  C   ASN A  10      34.143  24.408  29.198  1.00  4.73           C
ATOM     44  O   ASN A  10      34.240  25.175  28.242  1.00  4.79           O
ATOM     45  CB  ASN A  10      35.350  22.222  29.030  1.00  5.93           C
ATOM     46  N   ILE A  11      33.010  24.220  29.866  1.00  4.14           N
ATOM     47  CA  ILE A  11      31.789  24.946  29.534  1.00  4.17           C
ATOM     48  C   ILE A  11      31.911  26.423  29.892  1.00  4.30           C
ATOM     49  O   ILE A  11      31.423  27.287  29.165  1.00  4.57           O
ATOM     50  CB  ILE A  11      30.563  24.354  30.253  1.00  4.26           C
ATOM     51  N   GLU A  12      32.554  26.705  31.021  1.00  5.14           N
ATOM     52  CA  GLU A  12      32.765  28.081  31.458  1.00  6.72           C
ATOM     53  C   GLU A  12      33.762  28.794  30.550  1.00  5.62           C
ATOM     54  O   GLU A  12      33.583  29.966  30.211  1.00  6.01           O
ATOM     55  CB  GLU A  12      33.253  28.115  32.908  1.00  8.41           C
ATOM     56  N   SER A  13      34.809  28.076  30.155  1.00  5.36           N
ATOM     57  CA  SER A  13      35.819  28.627  29.260  0.48  5.54           C
ATOM     58  C   SER A  13      35.220  28.870  27.881  1.00  4.98           C
ATOM     59  O   SER A  13      35.535  29.859  27.221  1.00  5.24           O
ATOM     60  CB  SER A  13      37.018  27.683  29.155  0.48  7.24           C
ATOM     61  N   PHE A  14      34.350  27.958  27.457  1.00  4.22           N
ATOM     62  CA  PHE A  14      33.665  28.082  26.177  1.00  4.26           C
ATOM     63  C   PHE A  14      32.679  29.242  26.205  1.00  3.83           C
ATOM     64  O   PHE A  14      32.483  29.920  25.201  1.00  4.21           O
ATOM     65  CB  PHE A  14      32.938  26.783  25.823  1.00  4.34           C
ATOM     66  N   ILE A  15      32.050  29.454  27.356  1.00  3.71           N
ATOM     67  CA  ILE A  15      31.101  30.549  27.522  1.00  3.57           C
ATOM     68  C   ILE A  15      31.803  31.904  27.525  1.00  3.45           C
ATOM     69  O   ILE A  15      31.312  32.867  26.935  1.00  3.86           O
ATOM     70  CB  ILE A  15      30.289  30.401  28.823  1.00  4.42           C
ATOM     71  N   HIS A  16      32.953  31.972  28.191  0.73  3.71           N
ATOM     72  CA  HIS A  16      33.733  33.204  28.237  0.73  3.79           C
ATOM     73  C   HIS A  16      34.322  33.510  26.864  0.73  3.39           C
ATOM     74  O   HIS A  16      34.358  34.666  26.428  0.73  3.85           O
ATOM     75  CB  HIS A  16      34.850  33.095  29.276  0.73  4.49           C
ATOM     76  N   GLN A  17      34.771  32.460  26.182  0.73  3.40           N
ATOM     77  CA  GLN A  17      35.326  32.593  24.843  0.73  3.79           C
ATOM     78  C   GLN A  17      34.237  33.024  23.872  0.73  3.29           C
ATOM     79  O   GLN A  17      34.486  33.794  22.952  0.73  3.69           O
ATOM     80  CB  GLN A  17      35.951  31.276  24.382  0.73  4.26           C
ATOM     81  N   ALA A  18      33.029  32.517  24.081  1.00  3.36           N
ATOM     82  CA  ALA A  18      31.889  32.893  23.257  1.00  3.89           C
ATOM     83  C   ALA A  18      31.514  34.345  23.518  1.00  4.05           C
ATOM     84  O   ALA A  18      31.092  35.060  22.610  1.00  4.91           O
ATOM     85  CB  ALA A  18      30.705  31.980  23.533  1.00  4.53           C
ATOM     86  N   LYS A  19      31.661  34.773  24.768  1.00  4.37           N
ATOM     87  CA  LYS A  19      31.330  36.142  25.141  1.00  5.39           C
ATOM     88  C   LYS A  19      32.309  37.167  24.571  1.00  5.25           C
ATOM     89  O   LYS A  19      31.891  38.187  24.022  1.00  5.52           O
ATOM     90  CB  LYS A  19      31.261  36.276  26.664  1.00  6.50           C
ATOM     91  N   ALA A  20      33.608  36.904  24.697  1.00  5.38           N
ATOM     92  CA  ALA A  20      34.602  37.833  24.160  1.00  5.88           C
ATOM     93  C   ALA A  20      34.717  37.749  22.638  1.00  5.38           C
ATOM     94  O   ALA A  20      34.663  38.763  21.943  1.00  6.73           O
ATOM     95  CB  ALA A  20      35.958  37.592  24.810  1.00  6.65           C
ATOM     96  N   ALA A  21      34.877  36.530  22.132  1.00  4.87           N
ATOM     97  CA  ALA A  21      34.919  36.267  20.695  1.00  5.54           C
ATOM     98  C   ALA A  21      33.517  36.185  20.104  1.00  4.89           C
ATOM     99  O   ALA A  21      32.541  36.580  20.741  1.00  5.59           O
ATOM    100  CB  ALA A  21      35.709  35.002  20.393  1.00  6.30           C
ATOM    101  N   GLY A  22      33.429  35.682  18.876  1.00  4.70           N
ATOM    102  CA  GLY A  22      32.150  35.469  18.222  1.00  4.84           C
ATOM    103  C   GLY A  22      31.234  34.541  19.001  1.00  4.56           C
ATOM    104  O   GLY A  22      31.687  33.750  19.830  1.00  5.92           O
ATOM    105  N   ARG A  23      29.938  34.639  18.724  1.00  4.30           N
ATOM    106  CA  ARG A  23      28.917  33.916  19.478  1.00  4.97           C
ATOM    107  C   ARG A  23      28.339  32.726  18.714  1.00  5.19           C
ATOM    108  O   ARG A  23      28.359  31.591  19.196  1.00  5.70           O
ATOM    109  CB  ARG A  23      27.792  34.865  19.896  1.00  5.52           C
ATOM    110  N   MET A  24      27.823  33.003  17.520  0.69  5.87           N
ATOM    111  CA  MET A  24      27.131  32.007  16.707  0.69  7.12           C
ATOM    112  C   MET A  24      27.979  30.787  16.355  0.69  6.14           C
ATOM    113  O   MET A  24      27.452  29.685  16.228  0.69  5.80           O
ATOM    114  CB  MET A  24      26.593  32.649  15.425  0.69  9.83           C
ATOM    115  N   ASP A  25      29.282  30.981  16.182  1.00  6.26           N
ATOM    116  CA  ASP A  25      30.170  29.863  15.877  1.00  6.70           C
ATOM    117  C   ASP A  25      30.293  28.915  17.070  1.00  5.34           C
ATOM    118  O   ASP A  25      30.261  27.691  16.913  1.00  5.81           O
ATOM    119  CB  ASP A  25      31.553  30.374  15.467  1.00  9.38           C
ATOM    120  N   GLU A  26      30.415  29.491  18.262  0.67  4.76           N
ATOM    121  CA  GLU A  26      30.516  28.708  19.488  0.67  4.83           C
ATOM    122  C   GLU A  26      29.195  28.010  19.790  0.67  4.62           C
ATOM    123  O   GLU A  26      29.175  26.864  20.246  0.67  4.93           O
ATOM    124  CB  GLU A  26      30.920  29.601  20.663  0.67  5.41           C
ATOM    125  N   VAL A  27      28.094  28.707  19.527  1.00  4.54           N
ATOM    126  CA  VAL A  27      26.766  28.144  19.737  1.00  5.02           C
ATOM    127  C   VAL A  27      26.514  27.000  18.761  1.00  4.94           C
ATOM    128  O   VAL A  27      25.883  26.003  19.109  1.00  5.05           O
ATOM    129  CB  VAL A  27      25.667  29.209  19.566  1.00  5.29           C
ATOM    130  N   ARG A  28      27.012  27.155  17.539  1.00  5.20           N
ATOM    131  CA  ARG A  28      26.880  26.126  16.515  1.00  5.54           C
ATOM    132  C   ARG A  28      27.724  24.906  16.863  1.00  4.76           C
ATOM    133  O   ARG A  28      27.311  23.770  16.630  1.00  5.46           O
ATOM    134  CB  ARG A  28      27.288  26.671  15.145  1.00  6.82           C
ATOM    135  N   THR A  29      28.908  25.147  17.418  1.00  4.62           N
ATOM    136  CA  THR A  29      29.787  24.058  17.829  1.00  5.38           C
ATOM    137  C   THR A  29      29.183  23.294  19.005  1.00  4.39           C
ATOM    138  O   THR A  29      29.254  22.064  19.065  1.00  5.02           O
ATOM    139  CB  THR A  29      31.182  24.575  18.224  1.00  7.77           C
ATOM    140  N   LEU A  30      28.579  24.032  19.931  1.00  4.10           N
ATOM    141  CA  LEU A  30      27.937  23.429  21.093  1.00  4.03           C
ATOM    142  C   LEU A  30      26.699  22.638  20.684  1.00  4.40           C
ATOM    143  O   LEU A  30      26.424  21.569  21.231  1.00  4.33           O
ATOM    144  CB  LEU A  30      27.563  24.502  22.117  1.00  4.41           C
ATOM    145  N   GLN A  31      25.956  23.171  19.719  1.00  4.65           N
ATOM    146  CA  GLN A  31      24.760  22.507  19.214  1.00  5.33           C
ATOM    147  C   GLN A  31      25.128  21.239  18.451  1.00  5.02           C
ATOM    148  O   GLN A  31      24.432  20.227  18.538  1.00  5.56           O
ATOM    149  CB  GLN A  31      23.961  23.450  18.314  1.00  6.58           C
ATOM    150  N   GLU A  32      26.224  21.304  17.702  1.00  5.72           N
ATOM    151  CA  GLU A  32      26.705  20.153  16.949  1.00  6.90           C
ATOM    152  C   GLU A  32      27.211  19.070  17.894  1.00  5.82           C
ATOM    153  O   GLU A  32      26.996  17.879  17.663  1.00  6.63           O
ATOM    154  CB  GLU A  32      27.816  20.568  15.982  1.00 10.01           C
ATOM    155  N   ASN A  33      27.881  19.491  18.963  1.00  5.36           N
ATOM    156  CA  ASN A  33      28.380  18.557  19.964  1.00  5.56           C
ATOM    157  C   ASN A  33      27.239  17.898  20.732  1.00  5.07           C
ATOM    158  O   ASN A  33      27.291  16.706  21.041  1.00  6.19           O
ATOM    159  CB  ASN A  33      29.329  19.264  20.933  1.00  6.47           C
ATOM    160  N   LEU A  34      26.207  18.681  21.030  1.00  4.51           N
ATOM    161  CA  LEU A  34      25.036  18.173  21.734  1.00  4.72           C
ATOM    162  C   LEU A  34      24.248  17.208  20.854  1.00  4.80           C
ATOM    163  O   LEU A  34      23.731  16.198  21.332  1.00  4.90           O
ATOM    164  CB  LEU A  34      24.138  19.327  22.184  1.00  4.81           C
ATOM    165  N   HIS A  35      24.161  17.528  19.567  1.00  5.03           N
ATOM    166  CA  HIS A  35      23.463  16.676  18.611  1.00  5.85           C
ATOM    167  C   HIS A  35      24.218  15.369  18.399  1.00  5.91           C
ATOM    168  O   HIS A  35      23.612  14.304  18.272  1.00  6.51           O
ATOM    169  CB  HIS A  35      23.283  17.402  17.276  1.00  7.35           C
ATOM    170  N   GLN A  36      25.544  15.458  18.365  1.00  5.86           N
ATOM    171  CA  GLN A  36      26.385  14.279  18.203  1.00  7.12           C
ATOM    172  C   GLN A  36      26.310  13.391  19.440  1.00  5.57           C
ATOM    173  O   GLN A  36      26.294  12.164  19.336  1.00  6.15           O
ATOM    174  CB  GLN A  36      27.835  14.686  17.934  1.00 10.81           C
ATOM    175  N   LEU A  37      26.261  14.020  20.611  1.00  4.79           N
ATOM    176  CA  LEU A  37      26.156  13.290  21.868  1.00  5.02           C
ATOM    177  C   LEU A  37      24.795  12.613  21.990  1.00  4.81           C
ATOM    178  O   LEU A  37      24.692  11.490  22.485  1.00  5.11           O
ATOM    179  CB  LEU A  37      26.386  14.228  23.055  1.00  5.48           C
ATOM    180  N   MET A  38      23.754  13.303  21.535  1.00  5.10           N
ATOM    181  CA  MET A  38      22.401  12.760  21.565  0.60  5.87           C
ATOM    182  C   MET A  38      22.262  11.601  20.584  1.00  5.55           C
ATOM    183  O   MET A  38      21.594  10.607  20.873  1.00  5.83           O
ATOM    184  CB  MET A  38      21.378  13.850  21.241  0.60  7.11           C
ATOM    185  N   HIS A  39      22.897  11.736  19.424  1.00  5.90           N
ATOM    186  CA  HIS A  39      22.871  10.689  18.410  1.00  6.60           C
ATOM    187  C   HIS A  39      23.647   9.464  18.879  1.00  6.76           C
ATOM    188  O   HIS A  39      23.242   8.328  18.631  1.00  7.35           O
ATOM    189  CB  HIS A  39      23.447  11.204  17.090  1.00  7.90           C
ATOM    190  N   GLU A  40      24.765   9.703  19.558  1.00  6.24           N
ATOM    191  CA  GLU A  40      25.583   8.621  20.092  1.00  7.45           C
ATOM    192  C   GLU A  40      24.859   7.903  21.225  1.00  6.69           C
ATOM    193  O   GLU A  40      24.937   6.680  21.348  1.00  7.99           O
ATOM    194  CB  GLU A  40      26.929   9.158  20.583  1.00  8.91           C
ATOM    195  N   TYR A  41      24.153   8.672  22.048  1.00  6.31           N
ATOM    196  CA  TYR A  41      23.389   8.109  23.156  1.00  6.52           C
ATOM    197  C   TYR A  41      22.206   7.298  22.641  1.00  6.93           C
ATOM    198  O   TYR A  41      21.872   6.249  23.194  1.00  7.89           O
ATOM    199  CB  TYR A  41      22.900   9.219  24.089  1.00  6.84           C
ATOM    200  N   PHE A  42      21.574   7.791  21.581  1.00  7.44           N
ATOM    201  CA  PHE A  42      20.448   7.095  20.968  1.00  9.29           C
ATOM    202  C   PHE A  42      20.907   5.812  20.283  1.00 11.50           C
ATOM    203  O   PHE A  42      20.219   4.792  20.331  1.00 13.50           O
ATOM    204  CB  PHE A  42      19.739   8.004  19.962  1.00  9.49           C
ATOM    205  N   GLN A  43      22.072   5.872  19.646  1.00 11.97           N
ATOM    206  CA  GLN A  43      22.637   4.711  18.968  1.00 13.21           C
ATOM    207  C   GLN A  43      23.083   3.647  19.966  1.00 16.37           C
ATOM    208  O   GLN A  43      22.917   2.451  19.727  1.00 17.39           O
ATOM    209  CB  GLN A  43      23.813   5.127  18.082  1.00 11.79           C
ATOM    210  N   GLN A  44      23.652   4.091  21.082  1.00 19.32           N
ATOM    211  CA  GLN A  44      24.109   3.178  22.125  1.00 22.77           C
ATOM    212  C   GLN A  44      22.935   2.498  22.821  1.00 25.16           C
ATOM    213  O   GLN A  44      23.114   1.528  23.557  1.00 27.03           O
ATOM    214  CB  GLN A  44      24.968   3.921  23.150  1.00 23.69           C
TER
"""

tst_01_start_lines = """
CRYST1  100.000  100.000  100.000  90.00  90.00  90.00 P 1
ATOM      1  N   SER A   2      34.406  14.074  39.193  1.00 25.20           N
ATOM      2  CA  SER A   2      35.650  14.676  38.720  1.00 23.89           C
ATOM      3  C   SER A   2      35.652  14.973  37.209  1.00 22.90           C
ATOM      4  O   SER A   2      36.003  16.085  36.813  1.00 23.08           O
ATOM      5  CB  SER A   2      36.846  13.786  39.085  1.00 23.11           C
ATOM      6  OG  SER A   2      36.688  13.224  40.377  1.00 21.13           O
ATOM      7  N   PRO A   3      35.271  14.008  36.359  1.00 22.39           N
ATOM      8  CA  PRO A   3      35.247  14.320  34.919  1.00 19.74           C
ATOM      9  C   PRO A   3      34.131  15.273  34.536  1.00 13.82           C
ATOM     10  O   PRO A   3      34.335  16.145  33.682  1.00 12.80           O
ATOM     11  CB  PRO A   3      35.078  12.943  34.264  1.00 23.07           C
ATOM     12  CG  PRO A   3      34.365  12.142  35.278  1.00 24.21           C
ATOM     13  CD  PRO A   3      34.900  12.599  36.604  1.00 23.79           C
ATOM     14  N   LEU A   4      32.953  15.140  35.151  1.00 11.29           N
ATOM     15  CA  LEU A   4      31.842  16.029  34.822  1.00  9.66           C
ATOM     16  C   LEU A   4      32.126  17.459  35.265  1.00  7.86           C
ATOM     17  O   LEU A   4      31.771  18.414  34.563  1.00  7.65           O
ATOM     18  CB  LEU A   4      30.548  15.506  35.450  1.00 10.57           C
ATOM     19  CG  LEU A   4      30.507  15.261  36.962  1.00 11.83           C
ATOM     20  CD1 LEU A   4      29.955  16.470  37.708  1.00 12.67           C
ATOM     21  CD2 LEU A   4      29.695  14.015  37.281  1.00 13.04           C
ATOM     22  N   ALA A   5      32.784  17.630  36.414  1.00  8.13           N
ATOM     23  CA  ALA A   5      33.115  18.975  36.873  1.00  8.04           C
ATOM     24  C   ALA A   5      34.133  19.637  35.953  1.00  7.24           C
ATOM     25  O   ALA A   5      33.992  20.816  35.611  1.00  6.98           O
ATOM     26  CB  ALA A   5      33.638  18.927  38.309  1.00  9.33           C
ATOM     27  N   GLN A   6      35.143  18.885  35.510  1.00  6.89           N
ATOM     28  CA  GLN A   6      36.114  19.438  34.571  1.00  7.52           C
ATOM     29  C   GLN A   6      35.465  19.744  33.227  1.00  5.67           C
ATOM     30  O   GLN A   6      35.792  20.752  32.586  1.00  5.64           O
ATOM     31  CB  GLN A   6      37.285  18.471  34.396  1.00  9.58           C
ATOM     32  CG  GLN A   6      38.274  18.479  35.550  1.00 12.45           C
ATOM     33  CD  GLN A   6      39.606  19.097  35.172  1.00 16.41           C
ATOM     34  OE1 GLN A   6      39.943  19.199  33.993  1.00 17.91           O
ATOM     35  NE2 GLN A   6      40.371  19.512  36.175  1.00 18.48           N
ATOM     36  N   GLN A   7      34.524  18.899  32.796  1.00  5.24           N
ATOM     37  CA  GLN A   7      33.828  19.156  31.542  1.00  4.92           C
ATOM     38  C   GLN A   7      32.990  20.424  31.629  1.00  4.44           C
ATOM     39  O   GLN A   7      33.018  21.255  30.715  1.00  4.63           O
ATOM     40  CB  GLN A   7      32.956  17.957  31.170  1.00  5.87           C
ATOM     41  CG  GLN A   7      32.163  18.140  29.886  1.00  8.74           C
ATOM     42  CD  GLN A   7      30.750  17.601  29.994  1.00 11.90           C
ATOM     43  OE1 GLN A   7      30.358  17.054  31.025  1.00 17.10           O
ATOM     44  NE2 GLN A   7      29.976  17.753  28.926  1.00 12.32           N
ATOM     45  N   ILE A   8      32.276  20.615  32.740  1.00  4.24           N
ATOM     46  CA  ILE A   8      31.464  21.818  32.889  1.00  4.30           C
ATOM     47  C   ILE A   8      32.353  23.051  33.021  1.00  4.16           C
ATOM     48  O   ILE A   8      32.020  24.128  32.509  1.00  5.21           O
ATOM     49  CB  ILE A   8      30.480  21.670  34.068  1.00  4.60           C
ATOM     50  CG1 ILE A   8      29.202  22.467  33.796  1.00  5.10           C
ATOM     51  CG2 ILE A   8      31.099  22.110  35.388  1.00  4.97           C
ATOM     52  CD1 ILE A   8      28.386  21.933  32.639  1.00  5.70           C
ATOM     53  N   LYS A   9      33.520  22.910  33.660  1.00  4.57           N
ATOM     54  CA  LYS A   9      34.420  24.049  33.795  1.00  5.70           C
ATOM     55  C   LYS A   9      34.997  24.465  32.447  1.00  5.50           C
ATOM     56  O   LYS A   9      35.036  25.659  32.128  1.00  6.01           O
ATOM     57  CB  LYS A   9      35.542  23.718  34.779  1.00  8.15           C
ATOM     58  CG  LYS A   9      36.199  24.937  35.406  1.00 13.11           C
ATOM     59  CD  LYS A   9      37.078  24.548  36.582  1.00 17.07           C
ATOM     60  CE  LYS A   9      38.267  23.715  36.131  1.00 20.09           C
ATOM     61  NZ  LYS A   9      39.237  23.487  37.238  1.00 22.35           N
ATOM     62  N   ASN A  10      35.420  23.499  31.626  1.00  5.00           N
ATOM     63  CA  ASN A  10      35.922  23.863  30.304  1.00  5.09           C
ATOM     64  C   ASN A  10      34.803  24.374  29.404  1.00  4.73           C
ATOM     65  O   ASN A  10      35.041  25.255  28.567  1.00  4.79           O
ATOM     66  CB  ASN A  10      36.678  22.696  29.655  1.00  5.93           C
ATOM     67  CG  ASN A  10      35.794  21.504  29.339  1.00  6.66           C
ATOM     68  OD1 ASN A  10      34.783  21.619  28.645  1.00  7.40           O
ATOM     69  ND2 ASN A  10      36.202  20.336  29.817  1.00  8.16           N
ATOM     70  N   ILE A  11      33.578  23.865  29.573  1.00  4.14           N
ATOM     71  CA  ILE A  11      32.456  24.379  28.795  1.00  4.17           C
ATOM     72  C   ILE A  11      32.191  25.836  29.146  1.00  4.30           C
ATOM     73  O   ILE A  11      32.011  26.679  28.258  1.00  4.57           O
ATOM     74  CB  ILE A  11      31.208  23.504  29.017  1.00  4.26           C
ATOM     75  CG1 ILE A  11      31.288  22.231  28.171  1.00  4.74           C
ATOM     76  CG2 ILE A  11      29.939  24.280  28.694  1.00  5.09           C
ATOM     77  CD1 ILE A  11      30.152  21.262  28.415  1.00  5.63           C
ATOM     78  N   GLU A  12      32.215  26.164  30.439  1.00  5.14           N
ATOM     79  CA  GLU A  12      32.020  27.549  30.852  1.00  6.72           C
ATOM     80  C   GLU A  12      33.168  28.430  30.377  1.00  5.62           C
ATOM     81  O   GLU A  12      32.949  29.573  29.956  1.00  6.01           O
ATOM     82  CB  GLU A  12      31.871  27.629  32.371  1.00  8.41           C
ATOM     83  CG  GLU A  12      31.058  28.820  32.853  1.00 10.55           C
ATOM     84  CD  GLU A  12      31.919  29.896  33.485  1.00 11.85           C
ATOM     85  OE1 GLU A  12      33.021  29.568  33.973  1.00 13.15           O
ATOM     86  OE2 GLU A  12      31.495  31.070  33.493  1.00 11.88           O
ATOM     87  N   SER A  13      34.395  27.907  30.401  1.00  5.36           N
ATOM     88  CA  SER A  13      35.537  28.704  29.968  0.48  5.54           C
ATOM     89  C   SER A  13      35.456  29.021  28.479  1.00  4.98           C
ATOM     90  O   SER A  13      35.663  30.171  28.069  1.00  5.24           O
ATOM     91  CB  SER A  13      36.839  27.973  30.295  0.48  7.24           C
ATOM     92  OG  SER A  13      37.946  28.596  29.667  0.48  8.58           O
ATOM     93  N   PHE A  14      35.126  28.026  27.649  1.00  4.22           N
ATOM     94  CA  PHE A  14      35.038  28.334  26.226  1.00  4.26           C
ATOM     95  C   PHE A  14      33.790  29.148  25.894  1.00  3.83           C
ATOM     96  O   PHE A  14      33.827  29.951  24.957  1.00  4.21           O
ATOM     97  CB  PHE A  14      35.193  27.071  25.347  1.00  4.34           C
ATOM     98  CG  PHE A  14      34.038  26.087  25.368  1.00  4.32           C
ATOM     99  CD1 PHE A  14      34.287  24.750  25.636  1.00  5.73           C
ATOM    100  CD2 PHE A  14      32.748  26.454  25.018  1.00  4.92           C
ATOM    101  CE1 PHE A  14      33.268  23.818  25.617  1.00  6.75           C
ATOM    102  CE2 PHE A  14      31.723  25.529  25.013  1.00  5.77           C
ATOM    103  CZ  PHE A  14      31.983  24.210  25.310  1.00  6.41           C
ATOM    104  N   ILE A  15      32.696  29.006  26.651  1.00  3.71           N
ATOM    105  CA  ILE A  15      31.547  29.870  26.392  1.00  3.57           C
ATOM    106  C   ILE A  15      31.869  31.317  26.759  1.00  3.45           C
ATOM    107  O   ILE A  15      31.454  32.244  26.054  1.00  3.86           O
ATOM    108  CB  ILE A  15      30.287  29.342  27.113  1.00  4.42           C
ATOM    109  CG1 ILE A  15      29.028  29.728  26.334  1.00  5.07           C
ATOM    110  CG2 ILE A  15      30.181  29.859  28.539  1.00  5.27           C
ATOM    111  CD1 ILE A  15      29.057  29.319  24.882  1.00  5.89           C
ATOM    112  N   HIS A  16      32.648  31.542  27.823  0.73  3.71           N
ATOM    113  CA  HIS A  16      33.061  32.904  28.149  0.73  3.79           C
ATOM    114  C   HIS A  16      34.024  33.454  27.102  0.73  3.39           C
ATOM    115  O   HIS A  16      33.933  34.628  26.717  0.73  3.85           O
ATOM    116  CB  HIS A  16      33.697  32.942  29.538  0.73  4.49           C
ATOM    117  CG  HIS A  16      33.432  34.209  30.290  0.73  5.87           C
ATOM    118  ND1 HIS A  16      32.233  34.464  30.919  0.73  8.05           N
ATOM    119  CD2 HIS A  16      34.212  35.293  30.513  0.73  5.56           C
ATOM    120  CE1 HIS A  16      32.285  35.650  31.498  0.73  7.55           C
ATOM    121  NE2 HIS A  16      33.475  36.174  31.267  0.73  6.08           N
ATOM    122  N   GLN A  17      34.937  32.612  26.609  0.73  3.40           N
ATOM    123  CA  GLN A  17      35.849  33.060  25.562  0.73  3.79           C
ATOM    124  C   GLN A  17      35.102  33.377  24.271  0.73  3.29           C
ATOM    125  O   GLN A  17      35.473  34.316  23.559  0.73  3.69           O
ATOM    126  CB  GLN A  17      36.940  32.010  25.329  0.73  4.26           C
ATOM    127  CG  GLN A  17      36.804  31.193  24.052  0.73  5.23           C
ATOM    128  CD  GLN A  17      37.890  30.145  23.912  0.73  7.38           C
ATOM    129  OE1 GLN A  17      38.792  30.054  24.745  0.73  8.36           O
ATOM    130  NE2 GLN A  17      37.810  29.347  22.853  0.73  9.04           N
ATOM    131  N   ALA A  18      34.040  32.627  23.962  1.00  3.36           N
ATOM    132  CA  ALA A  18      33.230  32.928  22.786  1.00  3.89           C
ATOM    133  C   ALA A  18      32.415  34.199  22.981  1.00  4.05           C
ATOM    134  O   ALA A  18      32.272  35.000  22.049  1.00  4.91           O
ATOM    135  CB  ALA A  18      32.312  31.752  22.469  1.00  4.53           C
ATOM    136  N   LYS A  19      31.873  34.406  24.184  1.00  4.37           N
ATOM    137  CA  LYS A  19      31.121  35.626  24.450  1.00  5.39           C
ATOM    138  C   LYS A  19      32.019  36.849  24.336  1.00  5.25           C
ATOM    139  O   LYS A  19      31.579  37.915  23.889  1.00  5.52           O
ATOM    140  CB  LYS A  19      30.476  35.556  25.834  1.00  6.50           C
ATOM    141  CG  LYS A  19      29.188  36.352  25.960  1.00  7.77           C
ATOM    142  CD  LYS A  19      28.242  35.717  26.966  1.00 10.16           C
ATOM    143  CE  LYS A  19      27.556  34.492  26.381  1.00 12.49           C
ATOM    144  NZ  LYS A  19      26.524  33.941  27.302  1.00 15.57           N
ATOM    145  N   ALA A  20      33.284  36.716  24.739  1.00  5.38           N
ATOM    146  CA  ALA A  20      34.236  37.796  24.503  1.00  5.88           C
ATOM    147  C   ALA A  20      34.551  37.944  23.016  1.00  5.38           C
ATOM    148  O   ALA A  20      34.554  39.060  22.485  1.00  6.73           O
ATOM    149  CB  ALA A  20      35.515  37.554  25.303  1.00  6.65           C
ATOM    150  N   ALA A  21      34.820  36.830  22.330  1.00  4.87           N
ATOM    151  CA  ALA A  21      35.054  36.852  20.885  1.00  5.54           C
ATOM    152  C   ALA A  21      33.744  36.915  20.101  1.00  4.89           C
ATOM    153  O   ALA A  21      32.953  37.850  20.258  1.00  5.59           O
ATOM    154  CB  ALA A  21      35.880  35.629  20.473  1.00  6.30           C
ATOM    155  N   GLY A  22      33.510  35.920  19.244  1.00  4.70           N
ATOM    156  CA  GLY A  22      32.291  35.852  18.458  1.00  4.84           C
ATOM    157  C   GLY A  22      31.400  34.733  18.952  1.00  4.56           C
ATOM    158  O   GLY A  22      31.849  33.811  19.640  1.00  5.92           O
ATOM    159  N   ARG A  23      30.123  34.810  18.572  1.00  4.30           N
ATOM    160  CA  ARG A  23      29.089  33.993  19.194  1.00  4.97           C
ATOM    161  C   ARG A  23      28.401  33.034  18.229  1.00  5.19           C
ATOM    162  O   ARG A  23      28.118  31.896  18.608  1.00  5.70           O
ATOM    163  CB  ARG A  23      28.049  34.905  19.862  1.00  5.52           C
ATOM    164  CG  ARG A  23      27.232  34.223  20.947  1.00  6.50           C
ATOM    165  CD  ARG A  23      25.919  34.951  21.188  1.00  7.51           C
ATOM    166  NE  ARG A  23      25.127  34.316  22.237  1.00  8.98           N
ATOM    167  CZ  ARG A  23      25.009  34.788  23.474  1.00 10.56           C
ATOM    168  NH1 ARG A  23      24.266  34.144  24.364  1.00 10.81           N
ATOM    169  NH2 ARG A  23      25.633  35.905  23.821  1.00 11.93           N
ATOM    170  N   MET A  24      28.115  33.455  16.994  0.69  5.87           N
ATOM    171  CA  MET A  24      27.227  32.666  16.141  0.69  7.12           C
ATOM    172  C   MET A  24      27.867  31.348  15.717  0.69  6.14           C
ATOM    173  O   MET A  24      27.240  30.284  15.810  0.69  5.80           O
ATOM    174  CB  MET A  24      26.822  33.482  14.913  0.69  9.83           C
ATOM    175  CG  MET A  24      27.848  34.521  14.492  0.69 13.17           C
ATOM    176  SD  MET A  24      27.247  35.602  13.180  0.69 13.65           S
ATOM    177  CE  MET A  24      26.251  36.755  14.121  0.69 13.09           C
ATOM    178  N   ASP A  25      29.126  31.390  15.278  1.00  6.26           N
ATOM    179  CA  ASP A  25      29.788  30.162  14.854  1.00  6.70           C
ATOM    180  C   ASP A  25      29.993  29.219  16.031  1.00  5.34           C
ATOM    181  O   ASP A  25      29.821  28.000  15.899  1.00  5.81           O
ATOM    182  CB  ASP A  25      31.123  30.487  14.185  1.00  9.38           C
ATOM    183  CG  ASP A  25      31.909  31.544  14.936  1.00 13.52           C
ATOM    184  OD1 ASP A  25      31.368  32.111  15.909  1.00 14.07           O
ATOM    185  OD2 ASP A  25      33.068  31.809  14.553  1.00 17.20           O
ATOM    186  N   GLU A  26      30.326  29.768  17.200  0.67  4.76           N
ATOM    187  CA  GLU A  26      30.545  28.922  18.366  0.67  4.83           C
ATOM    188  C   GLU A  26      29.250  28.275  18.839  0.67  4.62           C
ATOM    189  O   GLU A  26      29.247  27.100  19.214  0.67  4.93           O
ATOM    190  CB  GLU A  26      31.188  29.724  19.494  0.67  5.41           C
ATOM    191  CG  GLU A  26      31.798  28.848  20.575  0.67  6.20           C
ATOM    192  CD  GLU A  26      30.880  28.677  21.769  0.67  7.05           C
ATOM    193  OE1 GLU A  26      29.734  29.168  21.714  0.67  7.13           O
ATOM    194  OE2 GLU A  26      31.306  28.054  22.763  0.67  8.43           O
ATOM    195  N   VAL A  27      28.135  29.012  18.822  1.00  4.54           N
ATOM    196  CA  VAL A  27      26.875  28.408  19.248  1.00  5.02           C
ATOM    197  C   VAL A  27      26.405  27.374  18.231  1.00  4.94           C
ATOM    198  O   VAL A  27      25.830  26.346  18.602  1.00  5.05           O
ATOM    199  CB  VAL A  27      25.797  29.476  19.528  1.00  5.29           C
ATOM    200  CG1 VAL A  27      26.246  30.412  20.644  1.00  5.41           C
ATOM    201  CG2 VAL A  27      25.426  30.247  18.274  1.00  6.00           C
ATOM    202  N   ARG A  28      26.669  27.601  16.938  1.00  5.20           N
ATOM    203  CA  ARG A  28      26.324  26.581  15.951  1.00  5.54           C
ATOM    204  C   ARG A  28      27.152  25.315  16.152  1.00  4.76           C
ATOM    205  O   ARG A  28      26.618  24.198  16.093  1.00  5.46           O
ATOM    206  CB  ARG A  28      26.516  27.132  14.538  1.00  6.82           C
ATOM    207  CG  ARG A  28      25.943  26.248  13.444  1.00  9.78           C
ATOM    208  CD  ARG A  28      26.151  26.864  12.070  1.00 13.05           C
ATOM    209  NE  ARG A  28      25.672  25.993  11.001  1.00 17.58           N
ATOM    210  CZ  ARG A  28      26.420  25.084  10.385  1.00 20.46           C
ATOM    211  NH1 ARG A  28      25.900  24.335   9.423  1.00 20.45           N
ATOM    212  NH2 ARG A  28      27.690  24.923  10.732  1.00 21.92           N
ATOM    213  N   THR A  29      28.449  25.469  16.431  1.00  4.62           N
ATOM    214  CA  THR A  29      29.288  24.302  16.684  1.00  5.38           C
ATOM    215  C   THR A  29      28.875  23.593  17.969  1.00  4.39           C
ATOM    216  O   THR A  29      28.889  22.360  18.034  1.00  5.02           O
ATOM    217  CB  THR A  29      30.761  24.707  16.747  1.00  7.77           C
ATOM    218  OG1 THR A  29      30.920  25.804  17.655  1.00  9.68           O
ATOM    219  CG2 THR A  29      31.262  25.115  15.369  1.00  8.93           C
ATOM    220  N   LEU A  30      28.484  24.355  18.994  1.00  4.10           N
ATOM    221  CA  LEU A  30      28.026  23.747  20.238  1.00  4.03           C
ATOM    222  C   LEU A  30      26.719  22.993  20.048  1.00  4.40           C
ATOM    223  O   LEU A  30      26.548  21.908  20.611  1.00  4.33           O
ATOM    224  CB  LEU A  30      27.863  24.818  21.316  1.00  4.41           C
ATOM    225  CG  LEU A  30      28.940  24.866  22.399  1.00  5.82           C
ATOM    226  CD1 LEU A  30      30.313  25.071  21.778  1.00  7.43           C
ATOM    227  CD2 LEU A  30      28.627  25.963  23.402  1.00  7.81           C
ATOM    228  N   GLN A  31      25.797  23.534  19.249  1.00  4.65           N
ATOM    229  CA  GLN A  31      24.556  22.821  18.972  1.00  5.33           C
ATOM    230  C   GLN A  31      24.822  21.548  18.179  1.00  5.02           C
ATOM    231  O   GLN A  31      24.220  20.503  18.453  1.00  5.56           O
ATOM    232  CB  GLN A  31      23.582  23.730  18.223  1.00  6.58           C
ATOM    233  CG  GLN A  31      22.873  24.743  19.107  1.00  9.50           C
ATOM    234  CD  GLN A  31      22.308  25.908  18.320  1.00 12.70           C
ATOM    235  OE1 GLN A  31      22.575  26.055  17.127  1.00 14.44           O
ATOM    236  NE2 GLN A  31      21.521  26.746  18.985  1.00 13.69           N
ATOM    237  N   GLU A  32      25.749  21.605  17.218  1.00  5.72           N
ATOM    238  CA  GLU A  32      26.091  20.402  16.465  1.00  6.90           C
ATOM    239  C   GLU A  32      26.744  19.355  17.362  1.00  5.82           C
ATOM    240  O   GLU A  32      26.439  18.160  17.256  1.00  6.63           O
ATOM    241  CB  GLU A  32      27.008  20.757  15.296  1.00 10.01           C
ATOM    242  CG  GLU A  32      26.300  21.436  14.135  1.00 16.02           C
ATOM    243  CD  GLU A  32      27.262  21.925  13.071  1.00 22.44           C
ATOM    244  OE1 GLU A  32      28.484  21.934  13.330  1.00 25.00           O
ATOM    245  OE2 GLU A  32      26.797  22.299  11.973  1.00 24.85           O
ATOM    246  N   ASN A  33      27.618  19.787  18.274  1.00  5.36           N
ATOM    247  CA  ASN A  33      28.261  18.849  19.188  1.00  5.56           C
ATOM    248  C   ASN A  33      27.256  18.244  20.160  1.00  5.07           C
ATOM    249  O   ASN A  33      27.323  17.049  20.463  1.00  6.19           O
ATOM    250  CB  ASN A  33      29.390  19.546  19.947  1.00  6.47           C
ATOM    251  CG  ASN A  33      30.596  19.825  19.071  1.00  8.34           C
ATOM    252  OD1 ASN A  33      30.940  19.030  18.196  1.00 11.36           O
ATOM    253  ND2 ASN A  33      31.245  20.960  19.301  1.00  8.04           N
ATOM    254  N   LEU A  34      26.302  19.045  20.640  1.00  4.51           N
ATOM    255  CA  LEU A  34      25.277  18.518  21.534  1.00  4.72           C
ATOM    256  C   LEU A  34      24.372  17.530  20.810  1.00  4.80           C
ATOM    257  O   LEU A  34      23.995  16.497  21.377  1.00  4.90           O
ATOM    258  CB  LEU A  34      24.458  19.664  22.128  1.00  4.81           C
ATOM    259  CG  LEU A  34      24.657  19.937  23.620  1.00  4.99           C
ATOM    260  CD1 LEU A  34      26.062  20.453  23.889  1.00  5.66           C
ATOM    261  CD2 LEU A  34      23.614  20.919  24.130  1.00  6.50           C
ATOM    262  N   HIS A  35      24.037  17.810  19.548  1.00  5.03           N
ATOM    263  CA  HIS A  35      23.225  16.871  18.782  1.00  5.85           C
ATOM    264  C   HIS A  35      23.980  15.572  18.528  1.00  5.91           C
ATOM    265  O   HIS A  35      23.402  14.483  18.630  1.00  6.51           O
ATOM    266  CB  HIS A  35      22.790  17.508  17.463  1.00  7.35           C
ATOM    267  CG  HIS A  35      21.672  18.494  17.608  1.00 10.07           C
ATOM    268  ND1 HIS A  35      21.887  19.850  17.726  1.00 13.24           N
ATOM    269  CD2 HIS A  35      20.330  18.320  17.654  1.00 10.94           C
ATOM    270  CE1 HIS A  35      20.726  20.470  17.838  1.00 14.19           C
ATOM    271  NE2 HIS A  35      19.765  19.564  17.797  1.00 13.06           N
ATOM    272  N   GLN A  36      25.279  15.661  18.229  1.00  5.86           N
ATOM    273  CA  GLN A  36      26.061  14.447  18.014  1.00  7.12           C
ATOM    274  C   GLN A  36      26.211  13.651  19.308  1.00  5.57           C
ATOM    275  O   GLN A  36      26.159  12.416  19.290  1.00  6.15           O
ATOM    276  CB  GLN A  36      27.424  14.798  17.407  1.00 10.81           C
ATOM    277  CG  GLN A  36      28.592  14.846  18.382  1.00 15.82           C
ATOM    278  CD  GLN A  36      29.891  15.255  17.715  1.00 20.43           C
ATOM    279  OE1 GLN A  36      29.943  15.458  16.502  1.00 21.72           O
ATOM    280  NE2 GLN A  36      30.949  15.379  18.508  1.00 22.23           N
ATOM    281  N   LEU A  37      26.352  14.338  20.446  1.00  4.79           N
ATOM    282  CA  LEU A  37      26.445  13.639  21.722  1.00  5.02           C
ATOM    283  C   LEU A  37      25.126  12.964  22.077  1.00  4.81           C
ATOM    284  O   LEU A  37      25.117  11.831  22.572  1.00  5.11           O
ATOM    285  CB  LEU A  37      26.867  14.612  22.823  1.00  5.48           C
ATOM    286  CG  LEU A  37      26.728  14.123  24.266  1.00  7.48           C
ATOM    287  CD1 LEU A  37      27.780  13.069  24.580  1.00  8.34           C
ATOM    288  CD2 LEU A  37      26.822  15.287  25.241  1.00  9.38           C
ATOM    289  N   MET A  38      24.001  13.629  21.804  1.00  5.10           N
ATOM    290  CA  MET A  38      22.703  13.013  22.057  0.60  5.87           C
ATOM    291  C   MET A  38      22.477  11.813  21.146  1.00  5.55           C
ATOM    292  O   MET A  38      21.943  10.787  21.584  1.00  5.83           O
ATOM    293  CB  MET A  38      21.589  14.044  21.877  0.60  7.11           C
ATOM    294  CG  MET A  38      20.241  13.603  22.425  0.60  8.46           C
ATOM    295  SD  MET A  38      18.991  14.897  22.321  0.60 10.21           S
ATOM    296  CE  MET A  38      18.644  14.893  20.564  0.60 11.26           C
ATOM    297  N   HIS A  39      22.905  11.908  19.885  1.00  5.90           N
ATOM    298  CA  HIS A  39      22.765  10.775  18.976  1.00  6.60           C
ATOM    299  C   HIS A  39      23.638   9.605  19.411  1.00  6.76           C
ATOM    300  O   HIS A  39      23.205   8.448  19.360  1.00  7.35           O
ATOM    301  CB  HIS A  39      23.108  11.202  17.549  1.00  7.90           C
ATOM    302  CG  HIS A  39      22.023  11.981  16.873  1.00  9.99           C
ATOM    303  ND1 HIS A  39      21.973  13.358  16.894  1.00 11.79           N
ATOM    304  CD2 HIS A  39      20.947  11.576  16.158  1.00 10.09           C
ATOM    305  CE1 HIS A  39      20.913  13.768  16.221  1.00 11.60           C
ATOM    306  NE2 HIS A  39      20.273  12.707  15.764  1.00 10.84           N
ATOM    307  N   GLU A  40      24.862   9.884  19.870  1.00  6.24           N
ATOM    308  CA  GLU A  40      25.726   8.811  20.348  1.00  7.45           C
ATOM    309  C   GLU A  40      25.188   8.186  21.631  1.00  6.69           C
ATOM    310  O   GLU A  40      25.300   6.969  21.817  1.00  7.99           O
ATOM    311  CB  GLU A  40      27.156   9.330  20.539  1.00  8.91           C
ATOM    312  CG  GLU A  40      27.585   9.564  21.980  1.00 12.58           C
ATOM    313  CD  GLU A  40      29.016  10.053  22.090  1.00 17.22           C
ATOM    314  OE1 GLU A  40      29.644  10.299  21.039  1.00 19.50           O
ATOM    315  OE2 GLU A  40      29.513  10.190  23.228  1.00 19.12           O
ATOM    316  N   TYR A  41      24.581   8.989  22.511  1.00  6.31           N
ATOM    317  CA  TYR A  41      23.987   8.438  23.725  1.00  6.52           C
ATOM    318  C   TYR A  41      22.765   7.587  23.405  1.00  6.93           C
ATOM    319  O   TYR A  41      22.534   6.555  24.046  1.00  7.89           O
ATOM    320  CB  TYR A  41      23.620   9.566  24.688  1.00  6.84           C
ATOM    321  CG  TYR A  41      23.436   9.114  26.119  1.00  7.08           C
ATOM    322  CD1 TYR A  41      24.526   8.750  26.899  1.00  8.09           C
ATOM    323  CD2 TYR A  41      22.172   9.052  26.691  1.00  8.31           C
ATOM    324  CE1 TYR A  41      24.362   8.336  28.207  1.00  8.88           C
ATOM    325  CE2 TYR A  41      21.998   8.639  27.998  1.00  8.84           C
ATOM    326  CZ  TYR A  41      23.096   8.282  28.752  1.00  9.01           C
ATOM    327  OH  TYR A  41      22.928   7.871  30.054  1.00  9.91           O
ATOM    328  N   PHE A  42      21.967   8.005  22.419  1.00  7.44           N
ATOM    329  CA  PHE A  42      20.818   7.204  22.010  1.00  9.29           C
ATOM    330  C   PHE A  42      21.258   5.906  21.343  1.00 11.50           C
ATOM    331  O   PHE A  42      20.629   4.859  21.536  1.00 13.50           O
ATOM    332  CB  PHE A  42      19.921   8.013  21.073  1.00  9.49           C
ATOM    333  CG  PHE A  42      18.539   7.445  20.919  1.00  9.99           C
ATOM    334  CD1 PHE A  42      17.621   7.530  21.953  1.00 11.43           C
ATOM    335  CD2 PHE A  42      18.157   6.828  19.739  1.00 10.35           C
ATOM    336  CE1 PHE A  42      16.348   7.009  21.813  1.00 11.84           C
ATOM    337  CE2 PHE A  42      16.885   6.305  19.593  1.00 11.43           C
ATOM    338  CZ  PHE A  42      15.980   6.396  20.632  1.00 12.29           C
ATOM    339  N   GLN A  43      22.333   5.955  20.552  1.00 11.97           N
ATOM    340  CA  GLN A  43      22.837   4.742  19.916  1.00 13.21           C
ATOM    341  C   GLN A  43      23.436   3.785  20.939  1.00 16.37           C
ATOM    342  O   GLN A  43      23.265   2.565  20.830  1.00 17.39           O
ATOM    343  CB  GLN A  43      23.870   5.101  18.847  1.00 11.79           C
ATOM    344  CG  GLN A  43      24.156   3.981  17.860  1.00 11.86           C
ATOM    345  CD  GLN A  43      25.046   4.427  16.716  1.00 12.53           C
ATOM    346  OE1 GLN A  43      25.415   5.597  16.621  1.00 14.19           O
ATOM    347  NE2 GLN A  43      25.396   3.492  15.840  1.00 13.65           N
ATOM    348  N   GLN A  44      24.141   4.313  21.935  1.00 19.32           N
ATOM    349  CA  GLN A  44      24.715   3.485  22.989  1.00 22.77           C
ATOM    350  C   GLN A  44      23.627   2.896  23.880  1.00 25.16           C
ATOM    351  O   GLN A  44      23.715   1.744  24.305  1.00 27.03           O
ATOM    352  CB  GLN A  44      25.702   4.297  23.831  1.00 23.69           C
TER
"""

tst_02_start_lines = """\
CRYST1   39.979   38.891   33.998  90.00  90.00  90.00 P 1
SCALE1      0.025013  0.000000  0.000000        0.00000
SCALE2      0.000000  0.025713  0.000000        0.00000
SCALE3      0.000000  0.000000  0.029413        0.00000
ATOM      1  N   ALA A  21       8.035  20.299   4.150  1.00 33.96           N
ATOM      2  CA  ALA A  21       9.085  20.780   5.040  1.00 32.69           C
ATOM      3  C   ALA A  21       9.114  19.980   6.338  1.00 32.55           C
ATOM      4  O   ALA A  21       8.257  20.152   7.204  1.00 33.56           O
ATOM      5  CB  ALA A  21       8.893  22.260   5.334  1.00 33.18           C
ATOM      6  N   ALA A  22      10.106  19.104   6.465  1.00 31.24           N
ATOM      7  CA  ALA A  22      10.248  18.275   7.655  1.00 30.10           C
ATOM      8  C   ALA A  22      11.377  18.783   8.546  1.00 29.32           C
ATOM      9  O   ALA A  22      12.549  18.724   8.173  1.00 30.19           O
ATOM     10  CB  ALA A  22      10.491  16.826   7.266  1.00 30.34           C
ATOM     11  N   ALA A  23      11.017  19.283   9.723  1.00 27.76           N
ATOM     12  CA  ALA A  23      11.998  19.805  10.666  1.00 26.26           C
ATOM     13  C   ALA A  23      11.854  19.144  12.033  1.00 23.38           C
ATOM     14  O   ALA A  23      11.027  18.251  12.217  1.00 25.31           O
ATOM     15  CB  ALA A  23      11.863  21.315  10.790  1.00 27.05           C
ATOM     16  N   ALA A  24      12.663  19.590  12.988  1.00 19.15           N
ATOM     17  CA  ALA A  24      12.633  19.039  14.337  1.00 17.40           C
ATOM     18  C   ALA A  24      11.922  19.980  15.304  1.00 15.24           C
ATOM     19  O   ALA A  24      12.393  21.086  15.567  1.00 15.15           O
ATOM     20  CB  ALA A  24      14.044  18.750  14.822  1.00 16.09           C
ATOM     21  N   ALA A  25      10.786  19.533  15.829  1.00 13.99           N
ATOM     22  CA  ALA A  25      10.015  20.329  16.776  1.00 13.94           C
ATOM     23  C   ALA A  25      10.239  19.843  18.204  1.00 12.79           C
ATOM     24  O   ALA A  25      10.365  18.643  18.449  1.00 11.77           O
ATOM     25  CB  ALA A  25       8.536  20.287  16.426  1.00 14.72           C
ATOM     26  N   ALA A  26      10.287  20.782  19.143  1.00 11.97           N
ATOM     27  CA  ALA A  26      10.504  20.451  20.547  1.00 12.04           C
ATOM     28  C   ALA A  26       9.246  19.858  21.172  1.00 10.98           C
ATOM     29  O   ALA A  26       8.158  20.424  21.059  1.00 12.65           O
ATOM     30  CB  ALA A  26      10.949  21.684  21.319  1.00 11.63           C
ATOM     31  N   ALA A  27       9.402  18.715  21.831  1.00 10.67           N
ATOM     32  CA  ALA A  27       8.280  18.044  22.478  1.00 12.41           C
ATOM     33  C   ALA A  27       8.017  18.628  23.862  1.00 13.93           C
ATOM     34  O   ALA A  27       8.706  19.549  24.300  1.00 14.04           O
ATOM     35  CB  ALA A  27       8.541  16.549  22.574  1.00 12.92           C
ATOM     36  N   ALA A  28       7.014  18.086  24.546  1.00 15.45           N
ATOM     37  CA  ALA A  28       6.660  18.549  25.882  1.00 17.17           C
ATOM     38  C   ALA A  28       7.601  17.969  26.932  1.00 16.56           C
ATOM     39  O   ALA A  28       7.858  16.765  26.952  1.00 18.23           O
ATOM     40  CB  ALA A  28       5.218  18.186  26.203  1.00 17.15           C
ATOM     41  N   GLY A  29       8.113  18.833  27.803  1.00 18.72           N
ATOM     42  CA  GLY A  29       9.016  18.408  28.856  1.00 18.52           C
ATOM     43  C   GLY A  29      10.462  18.764  28.570  1.00 18.48           C
ATOM     44  O   GLY A  29      11.301  18.760  29.470  1.00 19.65           O
ATOM     45  N   ALA A  30      10.753  19.073  27.311  1.00 17.32           N
ATOM     46  CA  ALA A  30      12.107  19.433  26.905  1.00 16.80           C
ATOM     47  C   ALA A  30      12.217  20.928  26.624  1.00 16.52           C
ATOM     48  O   ALA A  30      11.285  21.541  26.102  1.00 17.70           O
ATOM     49  CB  ALA A  30      12.525  18.631  25.683  1.00 15.92           C
ATOM     50  N   ALA A  31      13.360  21.509  26.972  1.00 17.28           N
ATOM     51  CA  ALA A  31      13.591  22.933  26.761  1.00 16.91           C
ATOM     52  C   ALA A  31      14.726  23.168  25.770  1.00 16.03           C
ATOM     53  O   ALA A  31      15.327  22.221  25.263  1.00 14.98           O
ATOM     54  CB  ALA A  31      13.890  23.623  28.083  1.00 17.76           C
ATOM     55  N   ALA A  32      15.014  24.438  25.499  1.00 16.22           N
ATOM     56  CA  ALA A  32      16.077  24.804  24.571  1.00 16.19           C
ATOM     57  C   ALA A  32      17.454  24.603  25.197  1.00 14.39           C
ATOM     58  O   ALA A  32      17.594  24.584  26.420  1.00 15.02           O
ATOM     59  CB  ALA A  32      15.908  26.246  24.116  1.00 18.18           C
ATOM     60  N   ALA A  33      18.466  24.453  24.349  1.00 13.72           N
ATOM     61  CA  ALA A  33      19.836  24.268  24.814  1.00 13.64           C
ATOM     62  C   ALA A  33      20.441  25.587  25.284  1.00 12.50           C
ATOM     63  O   ALA A  33      20.243  26.629  24.660  1.00 12.22           O
ATOM     64  CB  ALA A  33      20.690  23.656  23.714  1.00 14.15           C
ATOM     65  N   ALA A  34      21.178  25.534  26.389  1.00 12.12           N
ATOM     66  CA  ALA A  34      21.807  26.725  26.950  1.00 12.41           C
ATOM     67  C   ALA A  34      23.098  27.068  26.213  1.00 13.60           C
ATOM     68  O   ALA A  34      24.003  26.240  26.107  1.00 15.68           O
ATOM     69  CB  ALA A  34      22.080  26.530  28.433  1.00 12.66           C
ATOM     70  N   ALA A  35      23.176  28.295  25.706  1.00 14.17           N
ATOM     71  CA  ALA A  35      24.355  28.754  24.981  1.00 16.12           C
ATOM     72  C   ALA A  35      25.475  29.145  25.941  1.00 15.11           C
ATOM     73  O   ALA A  35      25.219  29.625  27.045  1.00 16.45           O
ATOM     74  CB  ALA A  35      23.998  29.925  24.078  1.00 16.47           C
ATOM     75  N   GLY A  36      26.715  28.936  25.512  1.00 14.18           N
ATOM     76  CA  GLY A  36      27.869  29.252  26.333  1.00 13.93           C
ATOM     77  C   GLY A  36      28.258  30.716  26.267  1.00 13.16           C
ATOM     78  O   GLY A  36      27.771  31.461  25.417  1.00 12.39           O
ATOM     79  N   ALA A  37      29.142  31.128  27.171  1.00 14.69           N
ATOM     80  CA  ALA A  37      29.593  32.514  27.230  1.00 16.56           C
ATOM     81  C   ALA A  37      30.896  32.713  26.461  1.00 18.09           C
ATOM     82  O   ALA A  37      31.452  33.812  26.441  1.00 19.82           O
ATOM     83  CB  ALA A  37      29.761  32.952  28.677  1.00 17.45           C
ATOM     84  N   ALA A  38      31.380  31.645  25.835  1.00 20.32           N
ATOM     85  CA  ALA A  38      32.634  31.691  25.089  1.00 19.19           C
ATOM     86  C   ALA A  38      32.523  32.591  23.861  1.00 19.61           C
ATOM     87  O   ALA A  38      31.430  32.814  23.340  1.00 18.87           O
ATOM     88  CB  ALA A  38      33.057  30.289  24.680  1.00 20.89           C
ATOM     89  N   ALA A  39      33.662  33.103  23.405  1.00 18.72           N
ATOM     90  CA  ALA A  39      33.693  33.988  22.245  1.00 19.33           C
ATOM     91  C   ALA A  39      33.919  33.202  20.957  1.00 18.66           C
ATOM     92  O   ALA A  39      33.897  33.765  19.863  1.00 21.79           O
ATOM     93  CB  ALA A  39      34.772  35.046  22.416  1.00 20.01           C
ATOM     94  N   ALA A  40      34.135  31.898  21.097  1.00 17.11           N
ATOM     95  CA  ALA A  40      34.309  31.020  19.946  1.00 17.00           C
ATOM     96  C   ALA A  40      33.079  30.140  19.765  1.00 16.01           C
ATOM     97  O   ALA A  40      32.433  29.760  20.742  1.00 16.18           O
ATOM     98  CB  ALA A  40      35.558  30.168  20.108  1.00 17.26           C
ATOM     99  N   ALA A  41      32.753  29.817  18.518  1.00 15.99           N
ATOM    100  CA  ALA A  41      31.569  29.015  18.241  1.00 16.37           C
ATOM    101  C   ALA A  41      31.823  27.542  18.541  1.00 15.52           C
ATOM    102  O   ALA A  41      32.953  27.155  18.845  1.00 18.11           O
ATOM    103  CB  ALA A  41      31.133  29.194  16.795  1.00 17.06           C
ATOM    104  N   ALA A  42      30.774  26.729  18.414  1.00 13.73           N
ATOM    105  CA  ALA A  42      30.833  25.293  18.719  1.00 13.40           C
ATOM    106  C   ALA A  42      29.475  24.631  18.468  1.00 12.31           C
ATOM    107  O   ALA A  42      28.435  25.294  18.493  1.00 13.00           O
ATOM    108  CB  ALA A  42      31.299  25.047  20.147  1.00 14.91           C
ATOM    109  N   ALA A  43      29.490  23.325  18.212  1.00 12.74           N
ATOM    110  CA  ALA A  43      28.299  22.611  17.753  1.00 12.74           C
ATOM    111  C   ALA A  43      27.575  21.788  18.816  1.00 11.86           C
ATOM    112  O   ALA A  43      28.147  20.872  19.408  1.00 12.94           O
ATOM    113  CB  ALA A  43      28.672  21.710  16.582  1.00 13.72           C
ATOM    114  N   ALA A  44      26.306  22.127  19.048  1.00  9.87           N
ATOM    115  CA  ALA A  44      25.485  21.399  20.010  1.00  9.48           C
ATOM    116  C   ALA A  44      24.361  20.643  19.306  1.00  9.29           C
ATOM    117  O   ALA A  44      23.451  21.248  18.741  1.00  9.63           O
ATOM    118  CB  ALA A  44      24.911  22.348  21.050  1.00 11.24           C
ATOM    119  N   ALA A  45      24.424  19.317  19.347  1.00  8.42           N
ATOM    120  CA  ALA A  45      23.416  18.491  18.692  1.00  9.05           C
ATOM    121  C   ALA A  45      22.579  17.737  19.718  1.00  9.11           C
ATOM    122  O   ALA A  45      23.069  16.837  20.399  1.00 10.48           O
ATOM    123  CB  ALA A  45      24.073  17.520  17.725  0.50  9.47           C
ATOM    125  N   ALA A  46      21.309  18.115  19.818  1.00  9.29           N
ATOM    126  CA  ALA A  46      20.391  17.499  20.768  1.00  9.25           C
ATOM    127  C   ALA A  46      19.256  16.778  20.049  1.00  9.68           C
ATOM    128  O   ALA A  46      18.431  17.404  19.381  1.00  9.10           O
ATOM    129  CB  ALA A  46      19.834  18.545  21.721  1.00 10.94           C
ATOM    130  N   ALA A  47      19.225  15.456  20.183  1.00  9.82           N
ATOM    131  CA  ALA A  47      18.183  14.649  19.562  1.00 10.81           C
ATOM    132  C   ALA A  47      17.313  13.981  20.621  1.00 11.43           C
ATOM    133  O   ALA A  47      17.767  13.093  21.342  1.00 12.52           O
ATOM    134  CB  ALA A  47      18.795  13.607  18.642  1.00 12.42           C
ATOM    135  N   ALA A  48      16.060  14.415  20.708  1.00 10.26           N
ATOM    136  CA  ALA A  48      15.122  13.861  21.676  1.00 11.47           C
ATOM    137  C   ALA A  48      14.029  13.061  20.977  1.00 11.60           C
ATOM    138  O   ALA A  48      13.231  13.613  20.220  1.00 12.19           O
ATOM    139  CB  ALA A  48      14.513  14.970  22.519  1.00 12.77           C
ATOM    140  N   GLY A  49      13.997  11.758  21.239  1.00 12.74           N
ATOM    141  CA  GLY A  49      13.020  10.881  20.622  1.00 11.60           C
ATOM    142  C   GLY A  49      13.227  10.734  19.127  1.00 10.42           C
ATOM    143  O   GLY A  49      14.313  10.378  18.672  1.00 11.59           O
ATOM    144  N   ALA A  50      12.177  11.011  18.361  1.00 11.29           N
ATOM    145  CA  ALA A  50      12.225  10.874  16.910  1.00 11.34           C
ATOM    146  C   ALA A  50      12.657  12.172  16.235  1.00 12.16           C
ATOM    147  O   ALA A  50      12.687  12.263  15.008  1.00 13.13           O
ATOM    148  CB  ALA A  50      10.871  10.428  16.378  1.00 12.07           C
ATOM    149  N   ALA A  51      12.990  13.175  17.041  1.00 10.41           N
ATOM    150  CA  ALA A  51      13.381  14.478  16.513  1.00 10.68           C
ATOM    151  C   ALA A  51      14.841  14.792  16.822  1.00  9.61           C
ATOM    152  O   ALA A  51      15.298  14.623  17.952  1.00 10.82           O
ATOM    153  CB  ALA A  51      12.477  15.566  17.072  1.00 12.11           C
ATOM    154  N   ALA A  52      15.568  15.249  15.807  1.00  9.76           N
ATOM    155  CA  ALA A  52      16.974  15.603  15.959  1.00  9.58           C
ATOM    156  C   ALA A  52      17.203  17.074  15.628  1.00  9.17           C
ATOM    157  O   ALA A  52      17.052  17.491  14.479  1.00 10.60           O
ATOM    158  CB  ALA A  52      17.843  14.718  15.079  1.00 10.97           C
ATOM    159  N   ALA A  53      17.571  17.855  16.638  1.00  9.58           N
ATOM    160  CA  ALA A  53      17.791  19.286  16.461  1.00  9.19           C
ATOM    161  C   ALA A  53      19.252  19.653  16.693  1.00  8.44           C
ATOM    162  O   ALA A  53      19.766  19.511  17.802  1.00  9.51           O
ATOM    163  CB  ALA A  53      16.891  20.080  17.395  1.00 11.00           C
ATOM    164  N   ALA A  54      19.918  20.128  15.645  1.00  9.12           N
ATOM    165  CA  ALA A  54      21.327  20.490  15.746  1.00 10.31           C
ATOM    166  C   ALA A  54      21.531  21.995  15.606  1.00 11.22           C
ATOM    167  O   ALA A  54      21.358  22.566  14.528  1.00 11.54           O
ATOM    168  CB  ALA A  54      22.139  19.747  14.695  0.70 11.35           C
ATOM    170  N   ALA A  55      21.900  22.624  16.716  1.00 10.84           N
ATOM    171  CA  ALA A  55      22.157  24.058  16.771  1.00 10.72           C
ATOM    172  C   ALA A  55      23.597  24.312  17.198  1.00 11.99           C
ATOM    173  O   ALA A  55      24.025  23.856  18.265  1.00 12.79           O
ATOM    174  CB  ALA A  55      21.187  24.740  17.722  1.00 10.97           C
ATOM    175  N   ALA A  56      24.372  25.000  16.367  1.00 12.74           N
ATOM    176  CA  ALA A  56      25.747  25.233  16.770  1.00 13.08           C
ATOM    177  C   ALA A  56      26.096  26.690  17.034  1.00 12.57           C
ATOM    178  O   ALA A  56      26.352  27.451  16.101  1.00 13.19           O
ATOM    179  CB  ALA A  56      26.668  24.693  15.689  1.00 15.32           C
ATOM    180  N   GLY A  57      26.109  27.080  18.306  1.00 12.52           N
ATOM    181  CA  GLY A  57      26.797  28.286  18.722  1.00 12.40           C
ATOM    182  C   GLY A  57      27.895  27.915  19.699  1.00 13.18           C
ATOM    183  O   GLY A  57      28.923  28.579  19.811  1.00 12.99           O
ATOM    184  N   ALA A  58      27.685  26.777  20.355  1.00 13.41           N
ATOM    185  CA  ALA A  58      28.465  26.401  21.529  1.00 14.00           C
ATOM    186  C   ALA A  58      28.354  24.905  21.806  1.00 14.24           C
ATOM    187  O   ALA A  58      27.435  24.246  21.326  1.00 15.91           O
ATOM    188  CB  ALA A  58      28.015  27.201  22.742  1.00 15.02           C
ATOM    189  N   ALA A  59      29.297  24.374  22.577  1.00 13.99           N
ATOM    190  CA  ALA A  59      29.253  22.974  22.983  1.00 13.59           C
ATOM    191  C   ALA A  59      29.906  22.777  24.347  1.00 15.86           C
ATOM    192  O   ALA A  59      30.922  23.400  24.652  1.00 15.86           O
ATOM    193  CB  ALA A  59      29.928  22.097  21.941  1.00 12.76           C
ATOM    194  N   ALA A  60      29.318  21.909  25.163  1.00 17.03           N
ATOM    195  CA  ALA A  60      29.899  21.568  26.456  1.00 17.98           C
ATOM    196  C   ALA A  60      29.836  20.066  26.706  1.00 17.64           C
ATOM    197  O   ALA A  60      28.752  19.486  26.776  1.00 18.56           O
ATOM    198  CB  ALA A  60      29.191  22.322  27.570  0.60 18.61           C
ATOM    200  N   GLY A  61      31.001  19.441  26.842  1.00 18.36           N
ATOM    201  CA  GLY A  61      31.078  18.021  27.136  1.00 16.97           C
ATOM    202  C   GLY A  61      30.562  17.140  26.015  1.00 15.14           C
ATOM    203  O   GLY A  61      30.170  17.627  24.954  1.00 15.23           O
ATOM    204  N   GLY A  62      30.568  15.832  26.250  1.00 13.16           N
ATOM    205  CA  GLY A  62      30.013  14.883  25.304  1.00 11.15           C
ATOM    206  C   GLY A  62      30.870  14.653  24.074  1.00 10.98           C
ATOM    207  O   GLY A  62      32.096  14.588  24.156  1.00 12.09           O
ATOM    208  N   ALA A  63      30.210  14.530  22.926  1.00  9.78           N
ATOM    209  CA  ALA A  63      30.884  14.231  21.668  1.00 10.89           C
ATOM    210  C   ALA A  63      30.175  14.913  20.503  1.00 11.10           C
ATOM    211  O   ALA A  63      29.324  15.779  20.708  1.00 10.76           O
ATOM    212  CB  ALA A  63      30.952  12.729  21.445  1.00 10.28           C
ATOM    213  N   ALA A  64      30.541  14.524  19.284  1.00 11.99           N
ATOM    214  CA  ALA A  64      29.927  15.064  18.072  1.00 14.29           C
ATOM    215  C   ALA A  64      28.409  14.880  18.068  1.00 13.74           C
ATOM    216  O   ALA A  64      27.693  15.621  17.390  1.00 15.77           O
ATOM    217  CB  ALA A  64      30.538  14.415  16.840  1.00 15.98           C
ATOM    218  N   ALA A  65      27.945  13.859  18.789  1.00 12.96           N
ATOM    219  CA  ALA A  65      26.528  13.647  19.102  1.00 14.79           C
ATOM    220  C   ALA A  65      25.710  13.132  17.918  1.00 12.45           C
ATOM    221  O   ALA A  65      24.622  12.590  18.107  1.00 12.02           O
ATOM    222  CB  ALA A  65      25.901  14.929  19.657  1.00 14.67           C
ATOM    223  N   ALA A  66      26.223  13.303  16.704  1.00 12.45           N
ATOM    224  CA  ALA A  66      25.522  12.836  15.512  1.00 12.26           C
ATOM    225  C   ALA A  66      25.481  11.311  15.461  1.00 11.46           C
ATOM    226  O   ALA A  66      24.461  10.716  15.103  1.00 11.40           O
ATOM    227  CB  ALA A  66      26.180  13.391  14.259  1.00 14.48           C
ATOM    228  N   GLY A  67      26.593  10.684  15.834  1.00 11.42           N
ATOM    229  CA  GLY A  67      26.682   9.236  15.855  1.00 11.67           C
ATOM    230  C   GLY A  67      25.800   8.640  16.932  1.00 11.68           C
ATOM    231  O   GLY A  67      25.177   7.598  16.732  1.00 12.32           O
ATOM    232  N   ALA A  68      25.749   9.307  18.080  1.00 11.77           N
ATOM    233  CA  ALA A  68      24.907   8.871  19.187  1.00 12.05           C
ATOM    234  C   ALA A  68      23.433   9.040  18.836  1.00 11.27           C
ATOM    235  O   ALA A  68      22.597   8.217  19.208  1.00 11.60           O
ATOM    236  CB  ALA A  68      25.247   9.644  20.451  1.00 13.97           C
ATOM    237  N   ALA A  69      23.124  10.116  18.119  1.00  9.97           N
ATOM    238  CA  ALA A  69      21.758  10.389  17.692  1.00  9.00           C
ATOM    239  C   ALA A  69      21.298   9.369  16.658  1.00  9.48           C
ATOM    240  O   ALA A  69      20.146   8.939  16.668  1.00  9.28           O
ATOM    241  CB  ALA A  69      21.647  11.798  17.131  1.00  8.57           C
ATOM    242  N   ALA A  70      22.201   8.988  15.760  1.00  9.73           N
ATOM    243  CA  ALA A  70      21.878   7.986  14.752  1.00 10.58           C
ATOM    244  C   ALA A  70      21.731   6.603  15.383  1.00 12.45           C
ATOM    245  O   ALA A  70      20.833   5.840  15.027  1.00 14.36           O
ATOM    246  CB  ALA A  70      22.942   7.964  13.667  1.00 12.29           C
ATOM    247  N   ALA A  71      22.620   6.290  16.320  1.00 11.50           N
ATOM    248  CA  ALA A  71      22.609   4.998  17.000  1.00 12.25           C
ATOM    249  C   ALA A  71      21.494   4.864  18.036  1.00 12.23           C
ATOM    250  O   ALA A  71      20.573   4.063  17.870  1.00 15.23           O
ATOM    251  CB  ALA A  71      23.959   4.748  17.658  1.00 12.60           C
ATOM    252  N   ALA A  72      21.584   5.652  19.103  1.00 11.11           N
ATOM    253  CA  ALA A  72      20.753   5.446  20.287  1.00 12.65           C
ATOM    254  C   ALA A  72      19.374   6.098  20.201  1.00 13.10           C
ATOM    255  O   ALA A  72      18.580   5.996  21.136  1.00 16.44           O
ATOM    256  CB  ALA A  72      21.485   5.951  21.524  1.00 12.96           C
ATOM    257  N   ALA A  73      19.086   6.765  19.088  1.00 14.17           N
ATOM    258  CA  ALA A  73      17.781   7.392  18.913  1.00 15.12           C
ATOM    259  C   ALA A  73      17.104   6.920  17.631  1.00 17.70           C
ATOM    260  O   ALA A  73      17.664   6.124  16.877  1.00 20.10           O
ATOM    261  CB  ALA A  73      17.914   8.907  18.916  1.00 13.89           C
ATOM    262  N   ALA A  74      15.894   7.415  17.391  1.00 19.16           N
ATOM    263  CA  ALA A  74      15.122   7.024  16.218  1.00 21.44           C
ATOM    264  C   ALA A  74      15.369   7.973  15.051  1.00 23.40           C
ATOM    265  O   ALA A  74      15.195   9.185  15.176  1.00 24.90           O
ATOM    266  CB  ALA A  74      13.640   6.972  16.554  1.00 21.64           C
ATOM    267  N   GLY A  75      15.776   7.413  13.916  1.00 25.83           N
ATOM    268  CA  GLY A  75      16.036   8.202  12.727  1.00 26.40           C
ATOM    269  C   GLY A  75      14.778   8.470  11.925  1.00 27.84           C
ATOM    270  O   GLY A  75      13.687   8.041  12.302  1.00 29.68           O
TER
"""

tst_03_start_lines = """\
HELIX   13  13 SER A  466  TYR A  472  1                                   7
CRYST1  316.252  316.252  137.685  90.00  90.00  90.00 P 42
SCALE1      0.003162  0.000000  0.000000        0.00000
SCALE2      0.000000  0.003162  0.000000        0.00000
SCALE3      0.000000  0.000000  0.007263        0.00000
ATOM   3705  N   SER A 466     155.504 100.416 -57.508  1.00 73.99           N
ATOM   3706  CA  SER A 466     154.512 101.335 -58.064  1.00 70.64           C
ATOM   3707  CB  SER A 466     154.564 102.666 -57.311  1.00 81.39           C
ATOM   3708  OG  SER A 466     154.140 102.507 -55.969  1.00 74.75           O
ATOM   3709  C   SER A 466     154.658 101.598 -59.564  1.00 77.28           C
ATOM   3710  O   SER A 466     153.814 102.267 -60.156  1.00 76.04           O
ATOM   3711  N   ILE A 467     155.744 101.115 -60.162  1.00 88.34           N
ATOM   3712  CA  ILE A 467     155.931 101.173 -61.612  1.00 89.88           C
ATOM   3713  CB  ILE A 467     157.236 100.452 -62.029  1.00 81.96           C
ATOM   3714  CG1 ILE A 467     158.436 101.009 -61.259  1.00 71.84           C
ATOM   3715  CD1 ILE A 467     158.840 100.182 -60.054  1.00 55.56           C
ATOM   3716  CG2 ILE A 467     157.477 100.579 -63.527  1.00 90.27           C
ATOM   3717  C   ILE A 467     154.723 100.581 -62.351  1.00 79.45           C
ATOM   3718  O   ILE A 467     154.413 100.983 -63.474  1.00 70.14           O
ATOM   3719  N   VAL A 468     154.032  99.642 -61.709  1.00 84.86           N
ATOM   3720  CA  VAL A 468     152.853  98.999 -62.290  1.00 82.37           C
ATOM   3721  CB  VAL A 468     152.383  97.825 -61.409  1.00 45.76           C
ATOM   3722  CG1 VAL A 468     153.491  96.793 -61.264  1.00 58.97           C
ATOM   3723  CG2 VAL A 468     151.937  98.330 -60.045  1.00 48.02           C
ATOM   3724  C   VAL A 468     151.703  99.986 -62.509  1.00 99.02           C
ATOM   3725  O   VAL A 468     150.720  99.668 -63.180  1.00 92.98           O
ATOM   3726  N   ASN A 469     151.829 101.178 -61.935  1.00 94.97           N
ATOM   3727  CA  ASN A 469     150.817 102.225 -62.049  1.00 86.97           C
ATOM   3728  CB  ASN A 469     150.703 103.002 -60.735  1.00 92.20           C
ATOM   3729  CG  ASN A 469     150.184 102.149 -59.594  1.00 81.03           C
ATOM   3730  OD1 ASN A 469     150.837 102.009 -58.560  1.00 77.52           O
ATOM   3731  ND2 ASN A 469     149.000 101.575 -59.776  1.00 70.45           N
ATOM   3732  C   ASN A 469     151.105 103.193 -63.197  1.00 95.36           C
ATOM   3733  O   ASN A 469     150.432 104.215 -63.329  1.00103.42           O
ATOM   3734  N   ASP A 470     152.122 102.878 -63.998  1.00 97.78           N
ATOM   3735  CA  ASP A 470     152.569 103.730 -65.106  1.00 92.19           C
ATOM   3736  CB  ASP A 470     153.585 102.967 -65.962  1.00 87.01           C
ATOM   3737  CG  ASP A 470     154.148 103.806 -67.091  1.00 77.46           C
ATOM   3738  OD1 ASP A 470     154.285 105.034 -66.912  1.00 85.03           O
ATOM   3739  OD2 ASP A 470     154.454 103.235 -68.159  1.00 71.40           O
ATOM   3740  C   ASP A 470     151.421 104.230 -65.989  1.00 84.38           C
ATOM   3741  O   ASP A 470     151.094 105.417 -65.978  1.00 87.02           O
ATOM   3742  N   ILE A 471     150.820 103.312 -66.741  1.00 79.41           N
ATOM   3743  CA  ILE A 471     149.625 103.570 -67.552  1.00 79.85           C
ATOM   3744  CB  ILE A 471     148.379 103.743 -66.646  1.00 74.88           C
ATOM   3745  CG1 ILE A 471     148.466 102.822 -65.430  1.00 82.61           C
ATOM   3746  CD1 ILE A 471     148.426 101.349 -65.777  1.00 74.09           C
ATOM   3747  CG2 ILE A 471     147.104 103.383 -67.400  1.00 64.21           C
ATOM   3748  C   ILE A 471     149.781 104.769 -68.507  1.00 84.73           C
ATOM   3749  O   ILE A 471     150.776 104.874 -69.223  1.00 88.84           O
ATOM   3750  N   TYR A 472     148.794 105.664 -68.506  1.00 80.60           N
ATOM   3751  CA  TYR A 472     148.586 106.618 -69.597  1.00 75.53           C
ATOM   3752  CB  TYR A 472     147.081 106.733 -69.879  1.00 73.74           C
ATOM   3753  CG  TYR A 472     146.738 107.485 -71.147  1.00 67.57           C
ATOM   3754  CD1 TYR A 472     147.138 107.010 -72.389  1.00 64.47           C
ATOM   3755  CE1 TYR A 472     146.829 107.695 -73.548  1.00 69.28           C
ATOM   3756  CZ  TYR A 472     146.109 108.869 -73.475  1.00 73.07           C
ATOM   3757  OH  TYR A 472     145.797 109.553 -74.627  1.00 67.60           O
ATOM   3758  CE2 TYR A 472     145.698 109.360 -72.254  1.00 73.64           C
ATOM   3759  CD2 TYR A 472     146.012 108.669 -71.100  1.00 67.13           C
ATOM   3760  C   TYR A 472     149.180 108.017 -69.381  1.00 52.97           C
ATOM   3761  O   TYR A 472     148.984 108.907 -70.208  1.00 41.97           O
"""

tst_03_answer_lines = """\
HELIX   13  13 SER A  466  TYR A  472  1                                   7
CRYST1  316.252  316.252  137.685  90.00  90.00  90.00 P 42
SCALE1      0.003162  0.000000  0.000000        0.00000
SCALE2      0.000000  0.003162  0.000000        0.00000
SCALE3      0.000000  0.000000  0.007263        0.00000
ATOM      1  N   SER A 466     152.392 101.460 -58.921  1.00 73.99           N
ATOM      2  CA  SER A 466     153.185 102.566 -59.445  1.00 70.64           C
ATOM      3  C   SER A 466     153.602 102.304 -60.888  1.00 77.28           C
ATOM      4  O   SER A 466     153.608 103.216 -61.717  1.00 76.04           O
ATOM      5  CB  SER A 466     154.422 102.798 -58.574  1.00 81.39           C
ATOM      6  OG  SER A 466     154.063 103.338 -57.313  1.00 74.75           O
ATOM      7  N   ILE A 467     153.940 101.047 -61.186  1.00 88.34           N
ATOM      8  CA  ILE A 467     154.346 100.688 -62.542  1.00 89.88           C
ATOM      9  C   ILE A 467     153.180 100.819 -63.508  1.00 79.45           C
ATOM     10  O   ILE A 467     153.344 101.314 -64.630  1.00 70.14           O
ATOM     11  CB  ILE A 467     154.938  99.263 -62.563  1.00 81.96           C
ATOM     12  CG1 ILE A 467     156.014  99.117 -61.485  1.00 71.84           C
ATOM     13  CG2 ILE A 467     155.507  98.940 -63.936  1.00 90.27           C
ATOM     14  CD1 ILE A 467     155.630  98.179 -60.362  1.00 55.56           C
ATOM     15  N   VAL A 468     151.982 100.412 -63.085  1.00 84.86           N
ATOM     16  CA  VAL A 468     150.800 100.549 -63.922  1.00 82.37           C
ATOM     17  C   VAL A 468     150.436 102.005 -64.169  1.00 99.02           C
ATOM     18  O   VAL A 468     150.057 102.360 -65.288  1.00 92.98           O
ATOM     19  CB  VAL A 468     149.606  99.798 -63.293  1.00 45.76           C
ATOM     20  CG1 VAL A 468     149.642  98.328 -63.680  1.00 58.97           C
ATOM     21  CG2 VAL A 468     149.615  99.957 -61.780  1.00 48.02           C
ATOM     22  N   ASN A 469     150.568 102.862 -63.159  1.00 94.97           N
ATOM     23  CA  ASN A 469     150.349 104.292 -63.314  1.00 86.97           C
ATOM     24  C   ASN A 469     151.392 104.949 -64.210  1.00 95.36           C
ATOM     25  O   ASN A 469     151.052 105.862 -64.969  1.00103.42           O
ATOM     26  CB  ASN A 469     150.335 104.975 -61.944  1.00 92.20           C
ATOM     27  CG  ASN A 469     149.151 104.555 -61.096  1.00 81.03           C
ATOM     28  OD1 ASN A 469     149.313 103.916 -60.057  1.00 77.52           O
ATOM     29  ND2 ASN A 469     147.950 104.914 -61.536  1.00 70.45           N
ATOM     30  N   ASP A 470     152.647 104.508 -64.137  1.00 97.78           N
ATOM     31  CA  ASP A 470     153.692 105.026 -65.011  1.00 92.19           C
ATOM     32  C   ASP A 470     153.455 104.600 -66.454  1.00 84.38           C
ATOM     33  O   ASP A 470     153.701 105.375 -67.384  1.00 87.02           O
ATOM     34  CB  ASP A 470     155.069 104.557 -64.536  1.00 87.01           C
ATOM     35  CG  ASP A 470     156.186 105.479 -64.984  1.00 77.46           C
ATOM     36  OD1 ASP A 470     155.882 106.556 -65.539  1.00 85.03           O
ATOM     37  OD2 ASP A 470     157.367 105.128 -64.780  1.00 71.40           O
ATOM     38  N   ILE A 471     152.981 103.370 -66.652  1.00 79.41           N
ATOM     39  CA  ILE A 471     152.685 102.866 -67.989  1.00 79.85           C
ATOM     40  C   ILE A 471     151.489 103.616 -68.562  1.00 84.73           C
ATOM     41  O   ILE A 471     151.480 103.984 -69.743  1.00 88.84           O
ATOM     42  CB  ILE A 471     152.431 101.346 -67.963  1.00 74.88           C
ATOM     43  CG1 ILE A 471     153.749 100.589 -67.786  1.00 82.61           C
ATOM     44  CG2 ILE A 471     151.724 100.891 -69.231  1.00 64.21           C
ATOM     45  CD1 ILE A 471     154.742 100.822 -68.904  1.00 74.09           C
ATOM     46  N   TYR A 472     150.482 103.863 -67.729  1.00 80.60           N
ATOM     47  CA  TYR A 472     149.304 104.610 -68.155  1.00 75.53           C
ATOM     48  C   TYR A 472     149.643 106.074 -68.413  1.00 52.97           C
ATOM     49  O   TYR A 472     149.190 106.662 -69.396  1.00 41.97           O
ATOM     50  CB  TYR A 472     148.195 104.503 -67.106  1.00 73.74           C
ATOM     51  CG  TYR A 472     146.901 105.173 -67.512  1.00 67.57           C
ATOM     52  CD1 TYR A 472     146.117 104.650 -68.532  1.00 64.47           C
ATOM     53  CD2 TYR A 472     146.464 106.327 -66.875  1.00 67.13           C
ATOM     54  CE1 TYR A 472     144.934 105.258 -68.907  1.00 69.28           C
ATOM     55  CE2 TYR A 472     145.282 106.942 -67.243  1.00 73.64           C
ATOM     56  CZ  TYR A 472     144.521 106.403 -68.259  1.00 73.07           C
ATOM     57  OH  TYR A 472     143.344 107.012 -68.629  1.00 67.60           O
TER
"""

tst_04_start_lines = """\
CRYST1  100.000  100.000  100.000  90.00  90.00  90.00 P 1
ATOM      1  N   ALA A  21       8.035  20.299   4.150  1.00 33.96           N
ATOM      2  CA  ALA A  21       9.085  20.780   5.040  1.00 32.69           C
ATOM      3  C   ALA A  21       9.114  19.980   6.338  1.00 32.55           C
ATOM      4  O   ALA A  21       8.257  20.152   7.204  1.00 33.56           O
ATOM      5  CB  ALA A  21       8.893  22.260   5.334  1.00 33.18           C
ATOM      6  N   UNK A  22      10.106  19.104   6.465  1.00 31.24           N
ATOM      7  CA  UNK A  22      10.248  18.275   7.655  1.00 30.10           C
ATOM      8  C   UNK A  22      11.377  18.783   8.546  1.00 29.32           C
ATOM      9  O   UNK A  22      12.549  18.724   8.173  1.00 30.19           O
ATOM     10  CB  UNK A  22      10.491  16.826   7.266  1.00 30.34           C
ATOM     11  CG  UNK A  22      10.006  16.721   7.661  1.00 20.00           C
ATOM     12  N   ALA A  23      11.017  19.283   9.723  1.00 27.76           N
ATOM     13  CA  ALA A  23      11.998  19.805  10.666  1.00 26.26           C
ATOM     14  C   ALA A  23      11.854  19.144  12.033  1.00 23.38           C
ATOM     15  O   ALA A  23      11.027  18.251  12.217  1.00 25.31           O
ATOM     16  CB  ALA A  23      11.863  21.315  10.790  1.00 27.05           C
ATOM     17  N   ALA A  24      12.663  19.590  12.988  1.00 19.15           N
ATOM     18  CA  ALA A  24      12.633  19.039  14.337  1.00 17.40           C
ATOM     19  C   ALA A  24      11.922  19.980  15.304  1.00 15.24           C
ATOM     20  O   ALA A  24      12.393  21.086  15.567  1.00 15.15           O
ATOM     21  CB  ALA A  24      14.044  18.750  14.822  1.00 16.09           C
"""

tst_04_answer_lines = """\
CRYST1  100.000  100.000  100.000  90.00  90.00  90.00 P 1
ATOM      1  N   ALA A  21       9.842  22.066   6.712  1.00 33.96           N
ATOM      2  CA  ALA A  21       8.824  21.158   6.199  1.00 32.69           C
ATOM      3  C   ALA A  21       8.841  19.833   6.953  1.00 32.55           C
ATOM      4  O   ALA A  21       7.792  19.247   7.219  1.00 33.56           O
ATOM      5  CB  ALA A  21       9.026  20.923   4.710  1.00 33.18           C
ATOM      6  N   UNK A  22      10.038  19.366   7.297  1.00 31.24           N
ATOM      7  CA  UNK A  22      10.187  18.059   7.925  1.00 30.10           C
ATOM      8  C   UNK A  22      11.176  18.063   9.092  1.00 29.32           C
ATOM      9  O   UNK A  22      10.991  17.321  10.057  1.00 30.19           O
ATOM     10  CB  UNK A  22      10.610  17.019   6.882  1.00 30.34           C
ATOM     11  CG  UNK A  22      10.658  15.590   7.400  1.00 20.00           C
ATOM     12  N   ALA A  23      12.213  18.891   9.011  1.00 27.76           N
ATOM     13  CA  ALA A  23      13.279  18.849  10.010  1.00 26.26           C
ATOM     14  C   ALA A  23      12.837  19.350  11.384  1.00 23.38           C
ATOM     15  O   ALA A  23      13.231  18.793  12.408  1.00 25.31           O
ATOM     16  CB  ALA A  23      14.477  19.653   9.524  1.00 27.05           C
ATOM     17  N   ALA A  24      12.018  20.397  11.404  1.00 19.15           N
ATOM     18  CA  ALA A  24      11.559  20.982  12.660  1.00 17.40           C
ATOM     19  C   ALA A  24      10.649  20.028  13.426  1.00 15.24           C
ATOM     20  O   ALA A  24      10.774  19.881  14.642  1.00 15.15           O
ATOM     21  CB  ALA A  24      10.842  22.298  12.396  1.00 16.09           C
TER
"""

def get_distances(h, n_neighbours=None):
  d = flex.double()
  for i, a in enumerate(h.atoms()):
    #for j in range(i, min(len(h.atoms()), i+10)):
    if n_neighbours is not None:
      r = range(i, min(len(h.atoms()), i+10))
    else:
      r = range(i, len(h.atoms()))
    for j in r:
      d.append(a.distance(h.atoms()[j]))
  return d

ssb_params_norot = ssb.master_phil.extract()
ssb_params_norot.ss_idealization.fix_rotamer_outliers=False
ssb_params_norot.ss_idealization.enabled=True

def exercise_pure_polyala_alpha(prefix="tst_2_ex_ppa_"):
  """
  Simple polyala one helix case.
  """
  h_records = """\
HELIX    1   1 ALA A    1  ALA A   20  1                                  20
"""
  import sys # import dependency
  h = ssb.secondary_structure_from_sequence(ssb.alpha_helix_str,"A"*20)
  h.write_pdb_file(file_name=prefix+'h0.pdb')
  d1 = get_distances(h)
  ann = ioss.annotation.from_records(records=h_records.split('\n'))
  pdb_inp = iotbx.pdb.input(source_info=None,
        lines=h.as_pdb_string())
  model = mmtbx.model.manager(
      model_input = pdb_inp,
      build_grm=True)
  model.set_ss_annotation(ann)
  # test_h = pdb_inp.construct_hierarchy()
  for i in range(3):
    rm = ssb.substitute_ss(
      model = model,
      params = ssb_params_norot.ss_idealization)
    model.get_hierarchy().write_pdb_file(file_name=prefix+'%d.pdb' % i)
  model.get_hierarchy().write_pdb_file(file_name=prefix+'h1.pdb')
  d2 = get_distances(model.get_hierarchy())
  dist = abs(d2-d1)
  dmmm = abs(d2-d1).min_max_mean().as_tuple()
  print("minmaxmean sd", dmmm, abs(d2-d1).standard_deviation_of_the_sample())
  assert dmmm[1] < 0.65, dmmm[1]
  assert dmmm[2] < 0.17, dmmm[2]
  assert dist.standard_deviation_of_the_sample() < 0.15, dist.standard_deviation_of_the_sample()

def exercise_00(prefix="tst_2_exercise_00"):
  """
  2 alpha helices and loop between them
  seems that this test is bad.
  """
  h_records = """\
HELIX    1   1 PRO A    3  ALA A   21  1                                  19
HELIX    2   2 ARG A   23  GLN A   44  1                                  22
"""
  pdb_inp = iotbx.pdb.input(source_info=None,
    lines=tst_00_start_lines)
  ann = ioss.annotation.from_records(records=h_records.split('\n'))
  model = mmtbx.model.manager(
      model_input = pdb_inp,
      build_grm = True)
  model.set_ss_annotation(ann)
  d1 = get_distances(model.get_hierarchy())
  # model.get_hierarchy().write_pdb_file(file_name=prefix+'_initial.pdb')
  for i in range(1):
    rm = ssb.substitute_ss(
      model,
      )
  d2 = get_distances(model.get_hierarchy())
  # model.get_hierarchy().write_pdb_file(file_name=prefix+'_result.pdb')
  dist = abs(d2-d1)
  dmmm = abs(d2-d1).min_max_mean().as_tuple()
  print("minmaxmean sd", dmmm, abs(d2-d1).standard_deviation_of_the_sample())
  assert dmmm[1] < 1.5, dmmm[1]
  assert dmmm[2] < 0.2, dmmm[2]
  assert dist.standard_deviation_of_the_sample() < 0.2

def exercise_01(prefix="tst_2_exercise_01"):
  """
  Similar to exercise_00. + Side chains.
  """
  h_records = """\
HELIX    1   1 PRO A    3  ALA A   21  1                                  19
HELIX    2   2 ARG A   23  GLN A   44  1                                  22
"""
  pdb_inp = iotbx.pdb.input(source_info=None,
      lines=tst_01_start_lines)
  ann = ioss.annotation.from_records(records=h_records.split('\n'))
  model = mmtbx.model.manager(
    model_input = pdb_inp,
    build_grm = True)
  model.set_ss_annotation(ann)

  d1 = get_distances(model.get_hierarchy(), n_neighbours=20)
  # model.get_hierarchy().write_pdb_file(file_name=prefix+'_initial.pdb')
  for i in range(1):
    rm = ssb.substitute_ss(
      model,
      params = ssb_params_norot.ss_idealization)
  d2 = get_distances(model.get_hierarchy(), n_neighbours=20)
  # model.get_hierarchy().write_pdb_file(file_name=prefix+'_result.pdb')
  dist = abs(d2-d1)
  dmmm = abs(d2-d1).min_max_mean().as_tuple()
  print("minmaxmean sd", dmmm, abs(d2-d1).standard_deviation_of_the_sample())
  # assert dmmm[1] < 0.8
  assert dmmm[2] < 0.2, dmmm[2]
  # print dist.standard_deviation_of_the_sample()
  assert dist.standard_deviation_of_the_sample() < 0.25, dist.standard_deviation_of_the_sample()

def exercise_02(prefix="tst_2_exercise_02"):
  """
  Similar to exercise_01. +beta sheets.
  """
  h_records = """\
HELIX    1   1 ARG A   65  ARG A   71  1                                   7
SHEET    1  AA 2 PHE A  42  CYS A  47  0
SHEET    2  AA 2 CYS A  52  GLY A  57 -1  O  LYS A  53   N  TYR A  46
"""
  pdb_inp = iotbx.pdb.input(source_info=None,
      lines=tst_02_start_lines)
  ann = ioss.annotation.from_records(records=h_records.split('\n'))
  model = mmtbx.model.manager(
    model_input = pdb_inp,
    build_grm = True)
  model.set_ss_annotation(ann)
  d1 = get_distances(model.get_hierarchy(), n_neighbours=20)
  # h.write_pdb_file(file_name=prefix+'_initial.pdb')
  for i in range(3):
    rm = ssb.substitute_ss(
      model,
      params = ssb_params_norot.ss_idealization)
  d2 = get_distances(model.get_hierarchy(), n_neighbours=20)
  # h.write_pdb_file(file_name=prefix+'_result.pdb')
  dist = abs(d2-d1)
  dmmm = abs(d2-d1).min_max_mean().as_tuple()
  print("minmaxmean sd", dmmm, abs(d2-d1).standard_deviation_of_the_sample())
  #assert dmmm[1] < 0.8
  assert dmmm[2] < 0.1
  assert dist.standard_deviation_of_the_sample() < 0.2, dist.standard_deviation_of_the_sample()

def exercise_03(prefix="tst_2_exercise_03"):
  """
  Mixed order of atoms in pdb file
  """
  h_records = """\
HELIX   13  13 SER A  466  TYR A  472  1                                   7
  """
  pdb_inp = iotbx.pdb.input(source_info=None, lines=tst_03_start_lines)
  ann = ioss.annotation.from_records(records=h_records.split('\n'))
  model = mmtbx.model.manager(
    model_input = pdb_inp,
    build_grm = True)
  model.set_ss_annotation(ann)
  # model.get_hierarchy().write_pdb_file(file_name="start.pdb")
  rm = ssb.substitute_ss(
      model,
      params = ssb_params_norot.ss_idealization)
  rm.run()
  # model.get_hierarchy().write_pdb_file(file_name="result.pdb")
  d1 = get_distances(model.get_hierarchy(), 5)
  answer_h = iotbx.pdb.input(
      source_info=None,
      lines=tst_03_answer_lines).construct_hierarchy()
  # answer_h.write_pdb_file(file_name="answer.pdb")
  d2 = get_distances(answer_h, 5)
  dist = abs(d2-d1)
  dmmm = abs(d2-d1).min_max_mean().as_tuple()
  print("minmaxmean sd", dmmm, abs(d2-d1).standard_deviation_of_the_sample())
  assert dmmm[2] < 0.1, dmmm[2]

def exercise_04(prefix="tst_2_exercise_04"):
  """
  Unknown residue in SS structure
  """
  h_records = """\
HELIX    1  21 ALA A   21  ALA A   24  1                                  5
"""
  pdb_inp = iotbx.pdb.input(source_info=None, lines=tst_04_start_lines)
  ann = ioss.annotation.from_records(records=h_records.split('\n'))
  model = mmtbx.model.manager(
    model_input = pdb_inp,
    build_grm = True)
  model.set_ss_annotation(ann)
  # h.write_pdb_file(file_name="%s_start.pdb" % prefix)
  rm = ssb.substitute_ss(
      model,
      params = ssb_params_norot.ss_idealization)
  rm.run()
  # h.write_pdb_file(file_name="%s_result.pdb" % prefix)
  d1 = get_distances(model.get_hierarchy(), 5)
  answer_h = iotbx.pdb.input(
      source_info=None,
      lines=tst_04_answer_lines).construct_hierarchy()
  # answer_h.write_pdb_file(file_name="answer.pdb")
  d2 = get_distances(answer_h, 5)
  dist = abs(d2-d1)
  dmmm = abs(d2-d1).min_max_mean().as_tuple()
  print("minmaxmean sd", dmmm, abs(d2-d1).standard_deviation_of_the_sample())
  assert dmmm[2] < 0.2, dmmm[2]


def exercise():
  """  Crashes on chevy, works on marbles. """
  exercise_pure_polyala_alpha()
  exercise_00()
  exercise_01()
  exercise_02()
  exercise_03()
  exercise_04()
  print("OK")

if (__name__ == "__main__"):
  exercise()
