from __future__ import absolute_import, division, print_function
import iotbx.pdb
import mmtbx.model
from libtbx.utils import null_out
import time
import mmtbx.nci.hbond
from scitbx.array_family import flex
from libtbx.test_utils import approx_equal

pdb_str_00 = """
ATOM      1  N   GLY A   1      -5.606  -2.251 -12.878  1.00  0.00           N
ATOM      2  CA  GLY A   1      -5.850  -1.194 -13.852  1.00  0.00           C
ATOM      3  C   GLY A   1      -5.186  -1.524 -15.184  1.00  0.00           C
ATOM      4  O   GLY A   1      -5.744  -1.260 -16.249  1.00  0.00           O
ATOM      0  H1  GLY A   1      -6.104  -2.109 -12.154  1.00  0.00           H   new
ATOM      0  H2  GLY A   1      -5.819  -3.038 -13.234  1.00  0.00           H   new
ATOM      0  H3  GLY A   1      -4.746  -2.252 -12.650  1.00  0.00           H   new
ATOM      0  HA2 GLY A   1      -6.805  -1.081 -13.981  1.00  0.00           H   new
ATOM      0  HA3 GLY A   1      -5.507  -0.352 -13.515  1.00  0.00           H   new
ATOM      1  N   GLY A   2      -3.992  -2.102 -15.115  1.00  0.00           N
ATOM      2  CA  GLY A   2      -3.261  -2.499 -16.313  1.00  0.00           C
ATOM      3  C   GLY A   2      -3.961  -3.660 -17.011  1.00  0.00           C
ATOM      4  O   GLY A   2      -4.016  -3.716 -18.240  1.00  0.00           O
ATOM      0  H   GLY A   2      -3.585  -2.274 -14.378  1.00  0.00           H   new
ATOM      0  HA2 GLY A   2      -3.191  -1.745 -16.920  1.00  0.00           H   new
ATOM      0  HA3 GLY A   2      -2.356  -2.756 -16.075  1.00  0.00           H   new
ATOM      1  N   GLY A   3      -4.492  -4.585 -16.219  1.00  0.00           N
ATOM      2  CA  GLY A   3      -5.216  -5.731 -16.755  1.00  0.00           C
ATOM      3  C   GLY A   3      -6.531  -5.289 -17.389  1.00  0.00           C
ATOM      4  O   GLY A   3      -6.939  -5.814 -18.425  1.00  0.00           O
ATOM      0  H   GLY A   3      -4.443  -4.566 -15.361  1.00  0.00           H   new
ATOM      0  HA2 GLY A   3      -4.669  -6.185 -17.416  1.00  0.00           H   new
ATOM      0  HA3 GLY A   3      -5.392  -6.369 -16.046  1.00  0.00           H   new
ATOM      1  N   GLY A   4      -7.189  -4.323 -16.758  1.00  0.00           N
ATOM      2  CA  GLY A   4      -8.442  -3.785 -17.273  1.00  0.00           C
ATOM      3  C   GLY A   4      -8.205  -3.003 -18.561  1.00  0.00           C
ATOM      4  O   GLY A   4      -9.007  -3.065 -19.492  1.00  0.00           O
ATOM      0  H   GLY A   4      -6.924  -3.963 -16.024  1.00  0.00           H   new
ATOM      0  HA2 GLY A   4      -9.066  -4.509 -17.439  1.00  0.00           H   new
ATOM      0  HA3 GLY A   4      -8.848  -3.207 -16.608  1.00  0.00           H   new
ATOM      1  N   GLY A   5      -7.099  -2.269 -18.604  1.00  0.00           N
ATOM      2  CA  GLY A   5      -6.735  -1.498 -19.787  1.00  0.00           C
ATOM      3  C   GLY A   5      -6.358  -2.423 -20.939  1.00  0.00           C
ATOM      4  O   GLY A   5      -6.687  -2.157 -22.094  1.00  0.00           O
ATOM      0  H   GLY A   5      -6.541  -2.204 -17.953  1.00  0.00           H   new
ATOM      0  HA2 GLY A   5      -7.477  -0.932 -20.051  1.00  0.00           H   new
ATOM      0  HA3 GLY A   5      -5.990  -0.912 -19.580  1.00  0.00           H   new
ATOM      1  N   GLY A   6      -5.665  -3.509 -20.614  1.00  0.00           N
ATOM      2  CA  GLY A   6      -5.268  -4.493 -21.614  1.00  0.00           C
ATOM      3  C   GLY A   6      -6.485  -5.236 -22.153  1.00  0.00           C
ATOM      4  O   GLY A   6      -6.565  -5.533 -23.345  1.00  0.00           O
ATOM      0  H   GLY A   6      -5.413  -3.695 -19.813  1.00  0.00           H   new
ATOM      0  HA2 GLY A   6      -4.804  -4.051 -22.343  1.00  0.00           H   new
ATOM      0  HA3 GLY A   6      -4.645  -5.125 -21.223  1.00  0.00           H   new
ATOM      1  N   GLY A   7      -7.430  -5.532 -21.267  1.00  0.00           N
ATOM      2  CA  GLY A   7      -8.660  -6.212 -21.655  1.00  0.00           C
ATOM      3  C   GLY A   7      -9.529  -5.303 -22.518  1.00  0.00           C
ATOM      4  O   GLY A   7     -10.158  -5.756 -23.474  1.00  0.00           O
ATOM      0  H   GLY A   7      -7.377  -5.346 -20.429  1.00  0.00           H   new
ATOM      0  HA2 GLY A   7      -8.447  -7.022 -22.144  1.00  0.00           H   new
ATOM      0  HA3 GLY A   7      -9.151  -6.479 -20.862  1.00  0.00           H   new
ATOM      1  N   GLY A   8      -9.559  -4.021 -22.172  1.00  0.00           N
ATOM      2  CA  GLY A   8     -10.324  -3.039 -22.930  1.00  0.00           C
ATOM      3  C   GLY A   8      -9.706  -2.819 -24.306  1.00  0.00           C
ATOM      4  O   GLY A   8     -10.416  -2.660 -25.299  1.00  0.00           O
ATOM      0  H   GLY A   8      -9.139  -3.697 -21.495  1.00  0.00           H   new
ATOM      0  HA2 GLY A   8     -11.241  -3.341 -23.027  1.00  0.00           H   new
ATOM      0  HA3 GLY A   8     -10.352  -2.199 -22.445  1.00  0.00           H   new
ATOM      1  N   GLY A   9      -8.378  -2.810 -24.356  1.00  0.00           N
ATOM      2  CA  GLY A   9      -7.658  -2.641 -25.613  1.00  0.00           C
ATOM      3  C   GLY A   9      -7.843  -3.861 -26.508  1.00  0.00           C
ATOM      4  O   GLY A   9      -7.980  -3.734 -27.725  1.00  0.00           O
ATOM      0  H   GLY A   9      -7.872  -2.901 -23.667  1.00  0.00           H   new
ATOM      0  HA2 GLY A   9      -7.978  -1.847 -26.070  1.00  0.00           H   new
ATOM      0  HA3 GLY A   9      -6.714  -2.505 -25.435  1.00  0.00           H   new
"""

pdb_str_01 = """
CRYST1   44.527   44.527   62.306  90.00  90.00 120.00 P 3 2 1
ATOM    484  CB  ASP A 729      24.227   3.198  28.416  1.00 40.30           C
ATOM    485  CG  ASP A 729      23.109   3.028  27.407  1.00 47.94           C
ATOM    486  OD1 ASP A 729      21.948   3.391  27.749  1.00 53.20           O
ATOM    487  OD2 ASP A 729      23.414   2.492  26.298  1.00 59.90           O
ATOM    658  CZ  ARG A 740      20.407  -3.170  38.924  1.00 70.50           C
ATOM    660  NH2 ARG A 740      20.911  -2.860  37.739  1.00 64.32           N
ATOM    672 HH21 ARG A 740      21.872  -2.629  37.580  1.00 64.32           H
ATOM    673 HH22 ARG A 740      20.350  -2.943  36.924  1.00 64.32           H
TER
END
"""

pdb_str_02 = """
CRYST1   54.464   54.312   58.062  90.00  90.00  90.00 P 1
ATOM      8  NE  ARG A  96      37.134  48.090   7.933  1.00 51.90           N
ATOM      9  CZ  ARG A  96      36.368  47.222   8.585  1.00 55.75           C
ATOM     10  NH1 ARG A  96      35.225  46.792   8.057  1.00 55.83           N
ATOM     11  NH2 ARG A  96      36.755  46.779   9.765  1.00 46.04           N
ATOM     20  HE  ARG A  96      37.867  48.340   8.306  1.00 51.90           H
ATOM     21 HH11 ARG A  96      34.974  47.076   7.285  1.00 55.82           H
ATOM     22 HH12 ARG A  96      34.737  46.230   8.488  1.00 55.82           H
ATOM     23 HH21 ARG A  96      37.496  47.052  10.105  1.00 46.04           H
ATOM     24 HH22 ARG A  96      36.266  46.217  10.195  1.00 46.04           H
ATOM     44  CB  ASP A 118      34.771  43.337  12.171  1.00 50.91           C
ATOM     45  CG  ASP A 118      34.959  44.392  11.096  1.00 59.09           C
ATOM     46  OD1 ASP A 118      34.559  44.164   9.925  1.00 60.01           O
ATOM     47  OD2 ASP A 118      35.520  45.449  11.443  1.00 59.21           O
ATOM     50  HB2 ASP A 118      34.866  43.750  13.043  1.00 50.91           H
ATOM     51  HB3 ASP A 118      35.474  42.674  12.093  1.00 50.91           H
TER
END
"""

pdb_str_03 = """
ATOM      1  N   GLY A   1      -5.423  -6.897  -8.991  1.00  0.00           N
ATOM      2  CA  GLY A   1      -3.976  -6.554  -9.489  1.00  0.00           C
ATOM      3  C   GLY A   1      -3.642  -5.220 -10.016  1.00  0.00           C
ATOM      4  O   GLY A   1      -2.895  -4.472  -9.450  1.00  0.00           O
ATOM      5  H1  GLY A   1      -6.043  -6.804  -9.631  1.00  0.00           H
ATOM      6  H2  GLY A   1      -5.535  -7.752  -8.722  1.00  0.00           H
ATOM      7  H3  GLY A   1      -5.708  -6.370  -8.334  1.00  0.00           H
ATOM      8  HA2 GLY A   1      -3.306  -6.803  -8.861  1.00  0.00           H
ATOM      9  HA3 GLY A   1      -3.777  -7.117 -10.209  1.00  0.00           H
ATOM     10  N   GLY A   2      -4.208  -4.919 -11.204  1.00  0.00           N
ATOM     11  CA  GLY A   2      -3.776  -3.707 -11.889  1.00  0.00           C
ATOM     12  C   GLY A   2      -4.936  -2.864 -12.308  1.00  0.00           C
ATOM     13  O   GLY A   2      -5.832  -2.544 -11.494  1.00  0.00           O
ATOM     14  H   GLY A   2      -4.692  -5.484 -11.621  1.00  0.00           H
ATOM     15  HA2 GLY A   2      -3.186  -3.174 -11.317  1.00  0.00           H
ATOM     16  HA3 GLY A   2      -3.316  -3.955 -12.670  1.00  0.00           H
ATOM     17  N   GLY A   3      -4.859  -2.354 -13.528  1.00  0.00           N
ATOM     18  CA  GLY A   3      -5.899  -1.438 -13.954  1.00  0.00           C
ATOM     19  C   GLY A   3      -6.867  -2.105 -14.900  1.00  0.00           C
ATOM     20  O   GLY A   3      -7.641  -3.024 -14.476  1.00  0.00           O
ATOM     21  H   GLY A   3      -4.224  -2.449 -14.045  1.00  0.00           H
ATOM     22  HA2 GLY A   3      -6.449  -1.066 -13.206  1.00  0.00           H
ATOM     23  HA3 GLY A   3      -5.590  -0.635 -14.420  1.00  0.00           H
ATOM     24  N   GLY A   4      -6.766  -1.789 -16.194  1.00  0.00           N
ATOM     25  CA  GLY A   4      -7.861  -2.087 -17.072  1.00  0.00           C
ATOM     26  C   GLY A   4      -7.699  -1.579 -18.516  1.00  0.00           C
ATOM     27  O   GLY A   4      -7.751  -0.367 -18.770  1.00  0.00           O
ATOM     28  H   GLY A   4      -6.135  -1.331 -16.478  1.00  0.00           H
ATOM     29  HA2 GLY A   4      -7.943  -3.006 -16.969  1.00  0.00           H
ATOM     30  HA3 GLY A   4      -8.656  -1.754 -16.709  1.00  0.00           H
ATOM     31  N   GLY A   5      -7.809  -2.518 -19.502  1.00  0.00           N
ATOM     32  CA  GLY A   5      -7.740  -2.130 -20.882  1.00  0.00           C
ATOM     33  C   GLY A   5      -6.478  -2.653 -21.539  1.00  0.00           C
ATOM     34  O   GLY A   5      -5.802  -3.533 -20.997  1.00  0.00           O
ATOM     35  H   GLY A   5      -7.838  -3.379 -19.455  1.00  0.00           H
ATOM     36  HA2 GLY A   5      -8.468  -2.578 -21.312  1.00  0.00           H
ATOM     37  HA3 GLY A   5      -7.866  -1.212 -20.932  1.00  0.00           H
ATOM     38  N   GLY A   6      -6.117  -2.123 -22.731  1.00  0.00           N
ATOM     39  CA  GLY A   6      -4.987  -2.658 -23.491  1.00  0.00           C
ATOM     40  C   GLY A   6      -5.160  -2.640 -24.995  1.00  0.00           C
ATOM     41  O   GLY A   6      -4.908  -1.653 -25.672  1.00  0.00           O
ATOM     42  H   GLY A   6      -6.592  -1.532 -23.131  1.00  0.00           H
ATOM     43  HA2 GLY A   6      -4.142  -2.201 -23.305  1.00  0.00           H
ATOM     44  HA3 GLY A   6      -4.889  -3.560 -23.232  1.00  0.00           H
ATOM     45  N   GLY A   7      -5.638  -3.711 -25.585  1.00  0.00           N
ATOM     46  CA  GLY A   7      -5.960  -3.699 -27.015  1.00  0.00           C
ATOM     47  C   GLY A   7      -7.032  -4.738 -27.283  1.00  0.00           C
ATOM     48  O   GLY A   7      -7.311  -5.619 -26.444  1.00  0.00           O
ATOM     49  H   GLY A   7      -5.810  -4.476 -25.186  1.00  0.00           H
ATOM     50  HA2 GLY A   7      -6.227  -2.814 -27.234  1.00  0.00           H
ATOM     51  HA3 GLY A   7      -5.157  -3.875 -27.536  1.00  0.00           H
ATOM     52  N   GLY A   8      -7.771  -4.520 -28.396  1.00  0.00           N
ATOM     53  CA  GLY A   8      -8.795  -5.411 -28.892  1.00  0.00           C
ATOM     54  C   GLY A   8     -10.113  -5.074 -28.202  1.00  0.00           C
ATOM     55  O   GLY A   8     -10.343  -3.940 -27.807  1.00  0.00           O
ATOM     56  H   GLY A   8      -7.622  -3.806 -28.902  1.00  0.00           H
ATOM     57  HA2 GLY A   8      -8.940  -5.392 -29.823  1.00  0.00           H
ATOM     58  HA3 GLY A   8      -8.673  -6.343 -28.574  1.00  0.00           H
ATOM     59  N   GLY A   9     -11.025  -6.011 -28.143  1.00  0.00           N
ATOM     60  CA  GLY A   9     -12.304  -5.594 -27.670  1.00  0.00           C
ATOM     61  C   GLY A   9     -13.026  -4.589 -28.491  1.00  0.00           C
ATOM     62  O   GLY A   9     -13.941  -3.837 -28.020  1.00  0.00           O
ATOM     63  H   GLY A   9     -10.890  -6.885 -28.344  1.00  0.00           H
ATOM     64  HA2 GLY A   9     -12.901  -6.331 -27.544  1.00  0.00           H
ATOM     65  HA3 GLY A   9     -12.107  -5.113 -26.821  1.00  0.00           H
TER
END
"""

pdb_str_04 = """
CRYST1   21.937    4.866   23.477  90.00 107.08  90.00 P 1 21 1
ATOM     86  N   TYR A   7       8.292   1.817   6.147  1.00 14.70           N
ATOM     87  CA  TYR A   7       9.159   2.144   7.299  1.00 15.18           C
ATOM     88  C   TYR A   7      10.603   2.331   6.885  1.00 15.91           C
ATOM     89  O   TYR A   7      11.041   1.811   5.855  1.00 15.76           O
ATOM     90  CB  TYR A   7       9.061   1.065   8.369  1.00 15.35           C
ATOM     91  CG  TYR A   7       7.665   0.929   8.902  1.00 14.45           C
ATOM     92  CD1 TYR A   7       6.771   0.021   8.327  1.00 15.68           C
ATOM     93  CD2 TYR A   7       7.210   1.756   9.920  1.00 14.80           C
ATOM     94  CE1 TYR A   7       5.480  -0.094   8.796  1.00 13.46           C
ATOM     95  CE2 TYR A   7       5.904   1.649  10.416  1.00 14.33           C
ATOM     96  CZ  TYR A   7       5.047   0.729   9.831  1.00 15.09           C
ATOM     97  OH  TYR A   7       3.766   0.589  10.291  1.00 14.39           O
ATOM     98  OXT TYR A   7      11.358   2.999   7.612  1.00 17.49           O
ATOM     99  H   TYR A   7       8.109   0.980   6.070  1.00 14.70           H
ATOM    100  HA  TYR A   7       8.852   2.975   7.692  1.00 15.18           H
ATOM    101  HB2 TYR A   7       9.327   0.215   7.987  1.00 15.35           H
ATOM    102  HB3 TYR A   7       9.645   1.296   9.108  1.00 15.35           H
ATOM    103  HD1 TYR A   7       7.058  -0.530   7.635  1.00 15.68           H
ATOM    104  HD2 TYR A   7       7.794   2.369  10.304  1.00 14.80           H
ATOM    105  HE1 TYR A   7       4.899  -0.713   8.417  1.00 13.46           H
ATOM    106  HE2 TYR A   7       5.612   2.197  11.109  1.00 14.33           H
ATOM    107  HH  TYR A   7       3.618   1.146  10.902  1.00 14.39           H
TER
HETATM  108  O   HOH A   8      -6.471   5.227   7.124  1.00 22.62           O
HETATM  109  O   HOH A   9      10.431   1.858   3.216  1.00 19.71           O
HETATM  110  O   HOH A  10     -11.286   1.756  -1.468  1.00 17.08           O
HETATM  111  O   HOH A  11      11.808   4.179   9.970  1.00 23.99           O
HETATM  112  O   HOH A  12      13.605   1.327   9.198  1.00 26.17           O
HETATM  113  O   HOH A  13      -2.749   3.429  10.024  1.00 39.15           O
HETATM  114  O   HOH A  14      -1.500   0.682  10.967  1.00 43.49           O
END
"""

pdb_str_05 = """
CRYST1   92.001   81.653   92.636  90.00  90.00  90.00 P 1
ATOM      1  N   GLY A  55      35.440  29.229  55.816  1.00  3.36           N
ATOM      2  CA  GLY A  55      34.110  29.470  56.333  1.00  3.53           C
ATOM      3  C   GLY A  55      33.803  28.679  57.596  1.00  3.47           C
ATOM      4  O   GLY A  55      33.120  29.179  58.485  1.00  3.87           O
ATOM      5  H   GLY A  55      35.458  28.842  54.872  0.00  3.36           H
ATOM      6  HA2 GLY A  55      34.003  30.530  56.562  0.00  3.53           H
ATOM      7  HA3 GLY A  55      33.377  29.195  55.574  0.00  3.53           H
ATOM      8  N   VAL A  56      34.278  27.431  57.675  1.00  3.56           N
ATOM      9  CA  VAL A  56      34.056  26.666  58.889  1.00  3.58           C
ATOM     10  C   VAL A  56      34.608  27.424  60.090  1.00  3.66           C
ATOM     11  O   VAL A  56      33.978  27.478  61.157  1.00  4.12           O
ATOM     12  CB  VAL A  56      34.691  25.273  58.765  1.00  3.91           C
ATOM     13  CG1 VAL A  56      34.686  24.540  60.109  1.00  4.90           C
ATOM     14  CG2 VAL A  56      33.958  24.430  57.722  1.00  4.46           C
ATOM     15  H   VAL A  56      34.798  26.948  56.942  0.00  3.56           H
ATOM     16  HA  VAL A  56      32.983  26.535  59.029  0.00  3.58           H
ATOM     17  HB  VAL A  56      35.725  25.408  58.447  0.00  3.91           H
ATOM     18 HG11 VAL A  56      35.143  23.559  59.980  0.00  4.90           H
ATOM     19 HG12 VAL A  56      35.255  25.123  60.833  0.00  4.90           H
ATOM     20 HG13 VAL A  56      33.656  24.428  60.448  0.00  4.90           H
ATOM     21 HG21 VAL A  56      34.433  23.451  57.660  0.00  4.46           H
ATOM     22 HG22 VAL A  56      32.916  24.320  58.023  0.00  4.46           H
ATOM     23 HG23 VAL A  56      34.015  24.932  56.756  0.00  4.46           H
ATOM     24  N   LYS A 100      29.982  30.678  54.621  1.00  5.43           N
ATOM     25  CA  LYS A 100      28.939  30.680  55.652  1.00  5.43           C
ATOM     26  C   LYS A 100      28.489  32.103  55.989  1.00  5.93           C
ATOM     27  O   LYS A 100      28.164  32.418  57.136  1.00  8.82           O
ATOM     28  CB  LYS A 100      29.368  29.903  56.940  1.00  6.55           C
ATOM     29  CG  LYS A 100      28.950  28.444  56.941  1.00  6.01           C
ATOM     30  CD  LYS A 100      29.607  27.568  55.893  1.00  4.90           C
ATOM     31  CE  LYS A 100      31.103  27.362  56.227  1.00  4.24           C
ATOM     32  NZ  LYS A 100      31.724  26.461  55.219  1.00  3.46           N
ATOM     33  H   LYS A 100      29.687  30.249  53.744  0.00  5.43           H
ATOM     34  HA  LYS A 100      28.074  30.156  55.245  0.00  5.43           H
ATOM     35  HB2 LYS A 100      30.454  29.938  57.025  0.00  6.55           H
ATOM     36  HB3 LYS A 100      28.911  30.381  57.806  0.00  6.55           H
ATOM     37  HG2 LYS A 100      29.194  28.019  57.915  0.00  6.01           H
ATOM     38  HG3 LYS A 100      27.874  28.396  56.772  0.00  6.01           H
ATOM     39  HD2 LYS A 100      29.118  26.594  55.871  0.00  4.90           H
ATOM     40  HD3 LYS A 100      29.531  28.046  54.916  0.00  4.90           H
ATOM     41  HE2 LYS A 100      31.620  28.321  56.206  0.00  4.24           H
ATOM     42  HE3 LYS A 100      31.201  26.907  57.212  0.00  4.24           H
ATOM     43  HZ1 LYS A 100      32.671  26.171  55.537  0.00  3.46           H
ATOM     44  HZ2 LYS A 100      31.136  25.613  55.090  0.00  3.46           H
ATOM     45  HZ3 LYS A 100      31.810  26.953  54.307  0.00  3.46           H
TER
END
"""

pdb_str_06 = """
CRYST1   92.001   81.653   92.636  90.00  90.00  90.00 P 1
ATOM      1  N   HIS A  46      37.660  32.481  45.654  1.00  2.96           N
ATOM      2  CA  HIS A  46      37.172  31.209  45.164  1.00  2.95           C
ATOM      3  C   HIS A  46      38.283  30.380  44.539  1.00  2.89           C
ATOM      4  O   HIS A  46      38.339  29.161  44.715  1.00  3.35           O
ATOM      5  CB  HIS A  46      36.051  31.456  44.144  1.00  3.48           C
ATOM      6  CG  HIS A  46      35.543  30.200  43.524  1.00  3.74           C
ATOM      7  ND1 HIS A  46      34.849  29.246  44.252  1.00  4.29           N
ATOM      8  CD2 HIS A  46      35.623  29.728  42.252  1.00  4.70           C
ATOM      9  CE1 HIS A  46      34.526  28.252  43.427  1.00  5.04           C
ATOM     10  NE2 HIS A  46      34.972  28.513  42.231  1.00  5.35           N
ATOM     11  H   HIS A  46      37.203  33.302  45.257  0.00  2.96           H
ATOM     12  HA  HIS A  46      36.770  30.639  46.002  0.00  2.95           H
ATOM     13  HB2 HIS A  46      35.216  31.945  44.647  0.00  3.48           H
ATOM     14  HB3 HIS A  46      36.432  32.095  43.347  0.00  3.48           H
ATOM     15  HD2 HIS A  46      36.105  30.213  41.416  0.00  4.70           H
ATOM     16  HE1 HIS A  46      33.978  27.365  43.707  0.00  5.04           H
ATOM     17  HE2 HIS A  46      34.858  27.915  41.412  0.00  5.35           H
ATOM     18  N   TYR A  82      34.404  34.068  35.489  1.00  3.67           N
ATOM     19  CA  TYR A  82      33.058  34.470  35.852  1.00  4.09           C
ATOM     20  C   TYR A  82      32.814  35.947  35.518  1.00  4.50           C
ATOM     21  O   TYR A  82      31.919  36.549  36.083  1.00  5.48           O
ATOM     22  CB  TYR A  82      32.763  34.218  37.339  1.00  4.34           C
ATOM     23  CG  TYR A  82      32.983  32.796  37.768  1.00  4.48           C
ATOM     24  CD1 TYR A  82      32.042  31.788  37.652  1.00  6.09           C
ATOM     25  CD2 TYR A  82      34.208  32.403  38.324  1.00  5.43           C
ATOM     26  CE1 TYR A  82      32.297  30.478  38.079  1.00  6.44           C
ATOM     27  CE2 TYR A  82      34.463  31.117  38.746  1.00  6.09           C
ATOM     28  CZ  TYR A  82      33.492  30.163  38.630  1.00  5.63           C
ATOM     29  OH  TYR A  82      33.813  28.887  39.037  1.00  7.02           O
ATOM     30  H   TYR A  82      35.136  34.644  35.905  0.00  3.67           H
ATOM     31  HA  TYR A  82      32.361  33.855  35.282  0.00  4.09           H
ATOM     32  HB2 TYR A  82      33.418  34.851  37.938  0.00  4.34           H
ATOM     33  HB3 TYR A  82      31.720  34.467  37.536  0.00  4.34           H
ATOM     34  HD1 TYR A  82      31.080  32.018  37.218  0.00  6.09           H
ATOM     35  HD2 TYR A  82      34.988  33.143  38.426  0.00  5.43           H
ATOM     36  HE1 TYR A  82      31.538  29.718  37.968  0.00  6.44           H
ATOM     37  HE2 TYR A  82      35.425  30.864  39.166  0.00  6.09           H
ATOM     38  HH  TYR A  82      34.721  28.871  39.406  0.00  7.02           H
TER
END
"""

pdb_str_07 = """
CRYST1   92.001   81.653   92.636  90.00  90.00  90.00 P 1
ATOM      1  N   TRP A  79      36.523  35.243  40.298  1.00  2.80           N
ATOM      2  CA  TRP A  79      37.553  34.690  39.436  1.00  2.81           C
ATOM      3  C   TRP A  79      37.276  35.034  37.968  1.00  2.94           C
ATOM      4  O   TRP A  79      36.181  35.406  37.555  1.00  3.41           O
ATOM      5  CB  TRP A  79      37.708  33.167  39.695  1.00  3.01           C
ATOM      6  CG  TRP A  79      38.851  32.622  38.907  1.00  2.97           C
ATOM      7  CD1 TRP A  79      38.783  31.757  37.835  1.00  3.37           C
ATOM      8  CD2 TRP A  79      40.216  33.066  38.974  1.00  2.97           C
ATOM      9  NE1 TRP A  79      40.007  31.653  37.234  1.00  3.59           N
ATOM     10  CE2 TRP A  79      40.904  32.432  37.915  1.00  3.36           C
ATOM     11  CE3 TRP A  79      40.916  33.926  39.834  1.00  3.10           C
ATOM     12  CZ2 TRP A  79      42.265  32.638  37.694  1.00  3.79           C
ATOM     13  CZ3 TRP A  79      42.262  34.125  39.620  1.00  3.56           C
ATOM     14  CH2 TRP A  79      42.936  33.486  38.559  1.00  3.91           C
ATOM     15  H   TRP A  79      35.829  34.576  40.635  0.00  2.80           H
ATOM     16  HA  TRP A  79      38.523  35.133  39.660  0.00  2.81           H
ATOM     17  HB2 TRP A  79      37.900  32.994  40.754  0.00  3.01           H
ATOM     18  HB3 TRP A  79      36.797  32.650  39.392  0.00  3.01           H
ATOM     19  HD1 TRP A  79      37.892  31.237  37.516  0.00  3.37           H
ATOM     20  HE1 TRP A  79      40.218  31.087  36.412  0.00  3.59           H
ATOM     21  HE3 TRP A  79      40.409  34.422  40.648  0.00  3.10           H
ATOM     22  HZ2 TRP A  79      42.778  32.153  36.877  0.00  3.79           H
ATOM     23  HZ3 TRP A  79      42.811  34.783  40.277  0.00  3.56           H
ATOM     24  HH2 TRP A  79      43.992  33.661  38.419  0.00  3.91           H
ATOM     25  N   CYS A  80      38.352  34.909  37.174  1.00  3.00           N
ATOM     26  CA  CYS A  80      38.402  35.365  35.802  1.00  3.10           C
ATOM     27  C   CYS A  80      37.414  34.669  34.877  1.00  3.15           C
ATOM     28  O   CYS A  80      37.027  35.264  33.865  1.00  3.71           O
ATOM     29  CB  CYS A  80      39.810  35.172  35.248  1.00  3.25           C
ATOM     30  SG  CYS A  80      41.066  36.088  36.167  1.00  3.60           S
ATOM     31  H   CYS A  80      39.227  34.480  37.474  0.00  3.00           H
ATOM     32  HA  CYS A  80      38.140  36.423  35.815  0.00  3.10           H
ATOM     33  HB2 CYS A  80      40.065  34.113  35.294  0.00  3.25           H
ATOM     34  HB3 CYS A  80      39.833  35.516  34.214  0.00  3.25           H
ATOM     35  HG  CYS A  80      42.240  35.626  35.854  0.00  3.60           H
TER
END
"""

pdb_str_08 = """
CRYST1   92.001   81.653   92.636  90.00  90.00  90.00 P 1
ATOM      1  N   ASN A 182      42.008  48.764  45.591  1.00  3.28           N
ATOM      2  CA  ASN A 182      42.783  48.041  44.578  1.00  3.17           C
ATOM      3  C   ASN A 182      43.821  47.226  45.348  1.00  3.11           C
ATOM      4  O   ASN A 182      44.658  47.790  46.058  1.00  3.87           O
ATOM      5  CB  ASN A 182      43.459  48.986  43.592  1.00  3.55           C
ATOM      6  CG  ASN A 182      44.085  48.267  42.393  1.00  3.58           C
ATOM      7  OD1 ASN A 182      43.836  47.111  42.125  1.00  4.02           O
ATOM      8  ND2 ASN A 182      44.900  49.025  41.636  1.00  4.32           N
ATOM      9  H   ASN A 182      42.578  49.382  46.169  0.00  3.28           H
ATOM     10  HA  ASN A 182      42.138  47.386  43.992  0.00  3.17           H
ATOM     11  HB2 ASN A 182      42.717  49.688  43.211  0.00  3.55           H
ATOM     12  HB3 ASN A 182      44.252  49.526  44.109  0.00  3.55           H
ATOM     13 HD21 ASN A 182      45.357  48.622  40.818  0.00  4.32           H
ATOM     14 HD22 ASN A 182      45.060  50.002  41.880  0.00  4.32           H
ATOM     15  N   CYS A 199      46.213  55.651  42.964  1.00  4.34           N
ATOM     16  CA  CYS A 199      45.027  55.155  43.649  1.00  4.13           C
ATOM     17  C   CYS A 199      44.678  55.992  44.881  1.00  4.14           C
ATOM     18  O   CYS A 199      43.527  56.354  45.051  1.00  4.67           O
ATOM     19  CB  CYS A 199      45.230  53.699  44.054  1.00  4.38           C
ATOM     20  SG  CYS A 199      45.239  52.572  42.629  1.00  5.33           S
ATOM     21  H   CYS A 199      46.997  55.000  42.910  0.00  4.34           H
ATOM     22  HA  CYS A 199      44.190  55.219  42.953  0.00  4.13           H
ATOM     23  HB2 CYS A 199      46.187  53.603  44.567  0.00  4.38           H
ATOM     24  HB3 CYS A 199      44.419  53.399  44.718  0.00  4.38           H
ATOM     25  HG  CYS A 199      45.824  51.462  42.971  0.00  5.33           H
TER
END
"""

pdb_str_08 = """
REMARK TeraChem refined 4gif from paper#3.
CRYST1   44.527   44.527   62.306  90.00  90.00 120.00 P 3 2 1
ATOM      1  N   GLY A 699      15.070  20.279  -8.791  1.00 41.37           N
ATOM      2  CA  GLY A 699      15.959  21.472  -8.994  1.00 47.67           C
ATOM      3  C   GLY A 699      17.394  21.058  -9.221  1.00 48.10           C
ATOM      4  O   GLY A 699      18.250  21.241  -8.344  1.00 41.66           O
ATOM      5  H1  GLY A 699      14.792  20.199  -7.829  0.00 41.37           H
ATOM      6  H2  GLY A 699      14.233  20.358  -9.345  0.00 41.37           H
ATOM      7  H3  GLY A 699      15.516  19.412  -9.046  0.00 41.37           H
ATOM      8  HA2 GLY A 699      15.591  22.007  -9.852  0.00 47.67           H
ATOM      9  HA3 GLY A 699      15.887  22.080  -8.117  0.00 47.67           H
ATOM     10  N   GLY A 700      17.660  20.525 -10.408  1.00 41.60           N
ATOM     11  CA  GLY A 700      19.004  20.233 -10.807  1.00 43.78           C
ATOM     12  C   GLY A 700      19.511  18.859 -10.452  1.00 46.34           C
ATOM     13  O   GLY A 700      18.873  18.049  -9.769  1.00 39.15           O
ATOM     14  H   GLY A 700      16.979  20.531 -11.143  0.00 41.60           H
ATOM     15  HA2 GLY A 700      19.064  20.345 -11.879  0.00 43.78           H
ATOM     16  HA3 GLY A 700      19.680  20.944 -10.356  0.00 43.78           H
ATOM     17  N   TRP A 701      20.720  18.587 -10.943  1.00 50.97           N
ATOM     18  CA  TRP A 701      21.476  17.408 -10.630  1.00 42.20           C
ATOM     19  C   TRP A 701      22.145  17.536  -9.277  1.00 43.48           C
ATOM     20  O   TRP A 701      22.284  18.632  -8.720  1.00 39.93           O
ATOM     21  CB  TRP A 701      22.586  17.208 -11.665  1.00 44.80           C
ATOM     22  CG  TRP A 701      22.131  16.650 -12.966  1.00 65.21           C
ATOM     23  CD1 TRP A 701      21.074  15.840 -13.215  1.00 64.00           C
ATOM     24  CD2 TRP A 701      22.829  16.829 -14.230  1.00 68.71           C
ATOM     25  NE1 TRP A 701      21.041  15.509 -14.565  1.00 68.77           N
ATOM     26  CE2 TRP A 701      22.112  16.103 -15.203  1.00 69.04           C
ATOM     27  CE3 TRP A 701      24.000  17.499 -14.598  1.00 61.62           C
ATOM     28  CZ2 TRP A 701      22.531  16.049 -16.528  1.00 71.79           C
ATOM     29  CZ3 TRP A 701      24.422  17.434 -15.907  1.00 67.16           C
ATOM     30  CH2 TRP A 701      23.688  16.719 -16.866  1.00 62.88           C
ATOM     31  H   TRP A 701      21.180  19.285 -11.478  0.00 50.97           H
ATOM     32  HA  TRP A 701      20.820  16.555 -10.604  0.00 42.20           H
ATOM     33  HB2 TRP A 701      23.068  18.166 -11.823  0.00 44.80           H
ATOM     34  HB3 TRP A 701      23.340  16.564 -11.239  0.00 44.80           H
ATOM     35  HD1 TRP A 701      20.342  15.458 -12.548  0.00 64.00           H
ATOM     36  HE1 TRP A 701      20.352  14.945 -14.995  0.00 68.77           H
ATOM     37  HE3 TRP A 701      24.572  18.034 -13.867  0.00 61.62           H
ATOM     38  HZ2 TRP A 701      21.975  15.497 -17.259  0.00 71.79           H
ATOM     39  HZ3 TRP A 701      25.322  17.931 -16.205  0.00 67.16           H
ATOM     40  HH2 TRP A 701      24.040  16.687 -17.878  0.00 62.88           H
ATOM     41  N   VAL A 702      22.631  16.394  -8.783  1.00 36.81           N
ATOM     42  CA  VAL A 702      23.401  16.330  -7.566  1.00 30.75           C
ATOM     43  C   VAL A 702      24.745  15.734  -7.880  1.00 31.17           C
ATOM     44  O   VAL A 702      24.838  14.692  -8.548  1.00 31.66           O
ATOM     45  CB  VAL A 702      22.676  15.503  -6.502  1.00 33.84           C
ATOM     46  CG1 VAL A 702      23.533  15.374  -5.252  1.00 40.89           C
ATOM     47  CG2 VAL A 702      21.345  16.154  -6.171  1.00 28.22           C
ATOM     48  H   VAL A 702      22.483  15.542  -9.270  0.00 36.81           H
ATOM     49  HA  VAL A 702      23.527  17.332  -7.203  0.00 30.75           H
ATOM     50  HB  VAL A 702      22.499  14.521  -6.923  0.00 33.84           H
ATOM     51 HG11 VAL A 702      22.999  14.817  -4.495  0.00 40.89           H
ATOM     52 HG12 VAL A 702      24.465  14.869  -5.454  0.00 40.89           H
ATOM     53 HG13 VAL A 702      23.759  16.354  -4.857  0.00 40.89           H
ATOM     54 HG21 VAL A 702      20.802  15.542  -5.470  0.00 28.22           H
ATOM     55 HG22 VAL A 702      21.512  17.123  -5.714  0.00 28.22           H
ATOM     56 HG23 VAL A 702      20.738  16.283  -7.051  0.00 28.22           H
ATOM     57  N   SER A 703      25.798  16.383  -7.398  1.00 32.31           N
ATOM     58  CA  SER A 703      27.141  15.963  -7.656  1.00 35.26           C
ATOM     59  C   SER A 703      27.644  14.979  -6.632  1.00 39.64           C
ATOM     60  O   SER A 703      27.403  15.121  -5.420  1.00 38.44           O
ATOM     61  CB  SER A 703      28.014  17.203  -7.549  1.00 40.62           C
ATOM     62  OG  SER A 703      29.380  16.779  -7.413  1.00 43.63           O
ATOM     63  H   SER A 703      25.647  17.173  -6.782  0.00 32.31           H
ATOM     64  HA  SER A 703      27.210  15.529  -8.637  0.00 35.26           H
ATOM     65  HB2 SER A 703      27.888  17.802  -8.434  0.00 40.62           H
ATOM     66  HB3 SER A 703      27.728  17.770  -6.681  0.00 40.62           H
ATOM     67  HG  SER A 703      30.003  17.388  -7.792  0.00 43.63           H
ATOM     68  N   GLY A 704      28.455  14.029  -7.065  1.00 37.06           N
ATOM     69  CA  GLY A 704      29.073  13.126  -6.139  1.00 29.73           C
ATOM     70  C   GLY A 704      29.877  13.841  -5.095  1.00 38.41           C
ATOM     71  O   GLY A 704      30.031  13.322  -3.975  1.00 38.38           O
ATOM     72  H   GLY A 704      28.609  13.898  -8.043  0.00 37.06           H
ATOM     73  HA2 GLY A 704      28.340  12.535  -5.622  0.00 29.73           H
ATOM     74  HA3 GLY A 704      29.733  12.476  -6.688  0.00 29.73           H
ATOM     75  N   GLU A 705      30.438  15.004  -5.402  1.00 37.55           N
ATOM     76  CA  GLU A 705      31.276  15.692  -4.448  1.00 36.35           C
ATOM     77  C   GLU A 705      30.463  16.091  -3.247  1.00 39.10           C
ATOM     78  O   GLU A 705      30.867  15.907  -2.088  1.00 47.55           O
ATOM     79  CB  GLU A 705      31.872  16.928  -5.113  1.00 42.57           C
ATOM     80  CG  GLU A 705      32.688  17.787  -4.168  1.00 45.02           C
ATOM     81  CD  GLU A 705      33.950  17.119  -3.702  1.00 58.81           C
ATOM     82  OE1 GLU A 705      34.474  16.261  -4.503  1.00 46.73           O
ATOM     83  OE2 GLU A 705      34.438  17.444  -2.592  1.00 50.77           O
ATOM     84  H   GLU A 705      30.205  15.462  -6.262  0.00 37.55           H
ATOM     85  HA  GLU A 705      32.052  15.037  -4.099  0.00 36.35           H
ATOM     86  HB2 GLU A 705      32.505  16.594  -5.916  0.00 42.57           H
ATOM     87  HB3 GLU A 705      31.067  17.512  -5.533  0.00 42.57           H
ATOM     88  HG2 GLU A 705      32.980  18.689  -4.686  0.00 45.02           H
ATOM     89  HG3 GLU A 705      32.117  18.087  -3.302  0.00 45.02           H
ATOM     90  N   GLU A 706      29.303  16.696  -3.498  1.00 38.07           N
ATOM     91  CA  GLU A 706      28.486  17.183  -2.426  1.00 39.69           C
ATOM     92  C   GLU A 706      27.797  16.050  -1.724  1.00 39.42           C
ATOM     93  O   GLU A 706      27.539  16.154  -0.510  1.00 38.24           O
ATOM     94  CB  GLU A 706      27.512  18.247  -2.901  1.00 35.17           C
ATOM     95  CG  GLU A 706      26.431  17.705  -3.807  1.00 38.10           C
ATOM     96  CD  GLU A 706      25.664  18.815  -4.477  1.00 57.89           C
ATOM     97  OE1 GLU A 706      25.413  19.846  -3.791  1.00 50.66           O
ATOM     98  OE2 GLU A 706      25.314  18.642  -5.695  1.00 48.71           O
ATOM     99  H   GLU A 706      28.972  16.755  -4.435  0.00 38.07           H
ATOM    100  HA  GLU A 706      29.133  17.611  -1.685  0.00 39.69           H
ATOM    101  HB2 GLU A 706      27.067  18.705  -2.034  0.00 35.17           H
ATOM    102  HB3 GLU A 706      28.089  19.005  -3.408  0.00 35.17           H
ATOM    103  HG2 GLU A 706      26.832  17.057  -4.562  0.00 38.10           H
ATOM    104  HG3 GLU A 706      25.725  17.118  -3.234  0.00 38.10           H
ATOM    105  N   PHE A 707      27.503  14.961  -2.415  1.00 37.02           N
ATOM    106  CA  PHE A 707      26.962  13.796  -1.769  1.00 32.56           C
ATOM    107  C   PHE A 707      27.991  13.196  -0.847  1.00 34.48           C
ATOM    108  O   PHE A 707      27.665  12.813   0.297  1.00 35.80           O
ATOM    109  CB  PHE A 707      26.521  12.797  -2.835  1.00 29.07           C
ATOM    110  CG  PHE A 707      25.860  11.592  -2.243  1.00 30.32           C
ATOM    111  CD1 PHE A 707      24.564  11.683  -1.746  1.00 31.95           C
ATOM    112  CD2 PHE A 707      26.535  10.385  -2.158  1.00 26.61           C
ATOM    113  CE1 PHE A 707      23.956  10.588  -1.161  1.00 25.92           C
ATOM    114  CE2 PHE A 707      25.918   9.279  -1.598  1.00 28.88           C
ATOM    115  CZ  PHE A 707      24.633   9.382  -1.089  1.00 28.57           C
ATOM    116  H   PHE A 707      27.642  14.942  -3.405  0.00 37.02           H
ATOM    117  HA  PHE A 707      26.126  14.069  -1.152  0.00 32.56           H
ATOM    118  HB2 PHE A 707      25.833  13.321  -3.479  0.00 29.07           H
ATOM    119  HB3 PHE A 707      27.376  12.511  -3.423  0.00 29.07           H
ATOM    120  HD1 PHE A 707      24.036  12.613  -1.824  0.00 31.95           H
ATOM    121  HD2 PHE A 707      27.531  10.310  -2.547  0.00 26.61           H
ATOM    122  HE1 PHE A 707      22.968  10.672  -0.765  0.00 25.92           H
ATOM    123  HE2 PHE A 707      26.429   8.341  -1.574  0.00 28.88           H
ATOM    124  HZ  PHE A 707      24.157   8.525  -0.658  0.00 28.57           H
ATOM    125  N   TYR A 708      29.236  13.098  -1.268  1.00 34.29           N
ATOM    126  CA  TYR A 708      30.277  12.623  -0.382  1.00 36.58           C
ATOM    127  C   TYR A 708      30.320  13.499   0.845  1.00 41.56           C
ATOM    128  O   TYR A 708      30.453  13.023   1.987  1.00 34.18           O
ATOM    129  CB  TYR A 708      31.615  12.683  -1.130  1.00 40.06           C
ATOM    130  CG  TYR A 708      32.815  12.697  -0.223  1.00 50.68           C
ATOM    131  CD1 TYR A 708      33.394  11.526   0.246  1.00 49.45           C
ATOM    132  CD2 TYR A 708      33.367  13.907   0.176  1.00 49.91           C
ATOM    133  CE1 TYR A 708      34.501  11.561   1.073  1.00 41.40           C
ATOM    134  CE2 TYR A 708      34.464  13.958   1.022  1.00 43.78           C
ATOM    135  CZ  TYR A 708      35.046  12.779   1.450  1.00 54.11           C
ATOM    136  OH  TYR A 708      36.169  12.761   2.232  1.00 64.61           O
ATOM    137  H   TYR A 708      29.478  13.332  -2.210  0.00 34.29           H
ATOM    138  HA  TYR A 708      30.063  11.625  -0.041  0.00 36.58           H
ATOM    139  HB2 TYR A 708      31.653  11.838  -1.801  0.00 40.06           H
ATOM    140  HB3 TYR A 708      31.613  13.581  -1.724  0.00 40.06           H
ATOM    141  HD1 TYR A 708      32.978  10.579  -0.043  0.00 49.45           H
ATOM    142  HD2 TYR A 708      32.936  14.821  -0.182  0.00 49.91           H
ATOM    143  HE1 TYR A 708      34.957  10.659   1.424  0.00 41.40           H
ATOM    144  HE2 TYR A 708      34.871  14.901   1.325  0.00 43.78           H
ATOM    145  HH  TYR A 708      36.479  13.620   2.569  0.00 64.61           H
ATOM    146  N   MET A 709      30.245  14.805   0.628  1.00 37.42           N
ATOM    147  CA  MET A 709      30.379  15.747   1.708  1.00 35.46           C
ATOM    148  C   MET A 709      29.255  15.567   2.703  1.00 36.86           C
ATOM    149  O   MET A 709      29.476  15.499   3.929  1.00 35.98           O
ATOM    150  CB  MET A 709      30.404  17.127   1.085  1.00 38.95           C
ATOM    151  CG  MET A 709      30.743  18.213   2.077  1.00 50.16           C
ATOM    152  SD  MET A 709      31.458  19.684   1.175  1.00 66.11           S
ATOM    153  CE  MET A 709      30.145  19.953  -0.108  1.00 41.84           C
ATOM    154  H   MET A 709      30.243  15.155  -0.307  0.00 37.42           H
ATOM    155  HA  MET A 709      31.292  15.562   2.248  0.00 35.46           H
ATOM    156  HB2 MET A 709      31.158  17.101   0.311  0.00 38.95           H
ATOM    157  HB3 MET A 709      29.457  17.316   0.610  0.00 38.95           H
ATOM    158  HG2 MET A 709      29.883  18.535   2.639  0.00 50.16           H
ATOM    159  HG3 MET A 709      31.522  17.904   2.749  0.00 50.16           H
ATOM    160  HE1 MET A 709      30.384  20.878  -0.598  0.00 41.84           H
ATOM    161  HE2 MET A 709      30.174  19.148  -0.817  0.00 41.84           H
ATOM    162  HE3 MET A 709      29.182  20.014   0.365  0.00 41.84           H
ATOM    163  N   LEU A 710      28.025  15.457   2.207  1.00 33.64           N
ATOM    164  CA  LEU A 710      26.915  15.247   3.099  1.00 27.67           C
ATOM    165  C   LEU A 710      27.097  13.947   3.837  1.00 32.44           C
ATOM    166  O   LEU A 710      26.861  13.854   5.061  1.00 26.79           O
ATOM    167  CB  LEU A 710      25.610  15.252   2.324  1.00 22.03           C
ATOM    168  CG  LEU A 710      24.386  15.176   3.226  1.00 24.87           C
ATOM    169  CD1 LEU A 710      24.300  16.391   4.135  1.00 25.86           C
ATOM    170  CD2 LEU A 710      23.125  15.071   2.389  1.00 25.17           C
ATOM    171  H   LEU A 710      27.864  15.542   1.223  0.00 33.64           H
ATOM    172  HA  LEU A 710      26.913  16.015   3.849  0.00 27.67           H
ATOM    173  HB2 LEU A 710      25.564  16.168   1.751  0.00 22.03           H
ATOM    174  HB3 LEU A 710      25.612  14.427   1.623  0.00 22.03           H
ATOM    175  HG  LEU A 710      24.460  14.288   3.843  0.00 24.87           H
ATOM    176 HD11 LEU A 710      23.371  16.382   4.690  0.00 25.86           H
ATOM    177 HD12 LEU A 710      25.110  16.428   4.848  0.00 25.86           H
ATOM    178 HD13 LEU A 710      24.327  17.298   3.540  0.00 25.86           H
ATOM    179 HD21 LEU A 710      22.254  14.993   3.027  0.00 25.17           H
ATOM    180 HD22 LEU A 710      23.012  15.952   1.772  0.00 25.17           H
ATOM    181 HD23 LEU A 710      23.155  14.205   1.740  0.00 25.17           H
ATOM    182  N   THR A 711      27.526  12.921   3.114  1.00 30.10           N
ATOM    183  CA  THR A 711      27.779  11.633   3.712  1.00 31.25           C
ATOM    184  C   THR A 711      28.685  11.762   4.900  1.00 32.95           C
ATOM    185  O   THR A 711      28.455  11.099   5.925  1.00 33.36           O
ATOM    186  CB  THR A 711      28.386  10.697   2.679  1.00 29.81           C
ATOM    187  OG1 THR A 711      27.385  10.412   1.696  1.00 34.35           O
ATOM    188  CG2 THR A 711      28.797   9.384   3.275  1.00 35.06           C
ATOM    189  H   THR A 711      27.704  13.042   2.140  0.00 30.10           H
ATOM    190  HA  THR A 711      26.867  11.197   4.076  0.00 31.25           H
ATOM    191  HB  THR A 711      29.223  11.192   2.219  0.00 29.81           H
ATOM    192  HG1 THR A 711      27.324  11.115   1.047  0.00 34.35           H
ATOM    193 HG21 THR A 711      29.122   8.727   2.483  0.00 35.06           H
ATOM    194 HG22 THR A 711      29.609   9.506   3.976  0.00 35.06           H
ATOM    195 HG23 THR A 711      27.960   8.930   3.787  0.00 35.06           H
ATOM    196  N   ARG A 712      29.737  12.566   4.812  1.00 32.03           N
ATOM    197  CA  ARG A 712      30.647  12.663   5.921  1.00 26.64           C
ATOM    198  C   ARG A 712      29.970  13.247   7.139  1.00 32.90           C
ATOM    199  O   ARG A 712      30.237  12.827   8.277  1.00 33.29           O
ATOM    200  CB  ARG A 712      31.837  13.535   5.589  1.00 30.63           C
ATOM    201  CG  ARG A 712      32.654  13.052   4.409  1.00 39.48           C
ATOM    202  CD  ARG A 712      34.133  13.138   4.708  1.00 40.16           C
ATOM    203  NE  ARG A 712      34.511  11.927   5.426  1.00 62.76           N
ATOM    204  CZ  ARG A 712      35.605  11.760   6.150  1.00 60.65           C
ATOM    205  NH1 ARG A 712      36.400  12.772   6.446  1.00 52.71           N
ATOM    206  NH2 ARG A 712      35.894  10.534   6.582  1.00 58.33           N
ATOM    207  H   ARG A 712      29.925  13.056   3.961  0.00 32.03           H
ATOM    208  HA  ARG A 712      30.980  11.676   6.204  0.00 26.64           H
ATOM    209  HB2 ARG A 712      31.491  14.542   5.410  0.00 30.63           H
ATOM    210  HB3 ARG A 712      32.459  13.555   6.475  0.00 30.63           H
ATOM    211  HG2 ARG A 712      32.401  12.030   4.155  0.00 39.48           H
ATOM    212  HG3 ARG A 712      32.428  13.637   3.533  0.00 39.48           H
ATOM    213  HD2 ARG A 712      34.714  13.206   3.813  0.00 40.16           H
ATOM    214  HD3 ARG A 712      34.340  14.002   5.318  0.00 40.16           H
ATOM    215  HE  ARG A 712      33.967  11.117   5.234  0.00 62.76           H
ATOM    216 HH11 ARG A 712      36.167  13.744   6.311  0.00 52.71           H
ATOM    217 HH12 ARG A 712      37.211  12.595   6.993  0.00 52.71           H
ATOM    218 HH21 ARG A 712      35.332   9.757   6.330  0.00 58.33           H
ATOM    219 HH22 ARG A 712      36.671  10.376   7.179  0.00 58.33           H
ATOM    220  N   ARG A 713      29.120  14.247   6.950  1.00 30.30           N
ATOM    221  CA  ARG A 713      28.444  14.843   8.075  1.00 29.15           C
ATOM    222  C   ARG A 713      27.617  13.790   8.765  1.00 28.45           C
ATOM    223  O   ARG A 713      27.542  13.766  10.013  1.00 29.64           O
ATOM    224  CB  ARG A 713      27.571  16.011   7.627  1.00 24.07           C
ATOM    225  CG  ARG A 713      28.420  17.178   7.132  1.00 26.08           C
ATOM    226  CD  ARG A 713      27.623  18.183   6.342  1.00 28.20           C
ATOM    227  NE  ARG A 713      26.584  18.776   7.166  1.00 33.49           N
ATOM    228  CZ  ARG A 713      25.613  19.529   6.681  1.00 30.40           C
ATOM    229  NH1 ARG A 713      25.461  19.681   5.377  1.00 29.85           N
ATOM    230  NH2 ARG A 713      24.770  20.141   7.497  1.00 35.75           N
ATOM    231  H   ARG A 713      28.872  14.523   6.023  0.00 30.30           H
ATOM    232  HA  ARG A 713      29.166  15.178   8.800  0.00 29.15           H
ATOM    233  HB2 ARG A 713      26.925  15.664   6.834  0.00 24.07           H
ATOM    234  HB3 ARG A 713      26.959  16.324   8.455  0.00 24.07           H
ATOM    235  HG2 ARG A 713      28.892  17.661   7.980  0.00 26.08           H
ATOM    236  HG3 ARG A 713      29.206  16.812   6.487  0.00 26.08           H
ATOM    237  HD2 ARG A 713      28.271  18.956   5.954  0.00 28.20           H
ATOM    238  HD3 ARG A 713      27.168  17.674   5.504  0.00 28.20           H
ATOM    239  HE  ARG A 713      26.634  18.649   8.173  0.00 33.49           H
ATOM    240 HH11 ARG A 713      26.042  19.210   4.723  0.00 29.85           H
ATOM    241 HH12 ARG A 713      24.750  20.275   5.015  0.00 29.85           H
ATOM    242 HH21 ARG A 713      24.890  20.107   8.505  0.00 35.75           H
ATOM    243 HH22 ARG A 713      23.993  20.635   7.128  0.00 35.75           H
ATOM    244  N   VAL A 714      26.972  12.914   8.007  1.00 26.72           N
ATOM    245  CA  VAL A 714      26.192  11.851   8.599  1.00 30.57           C
ATOM    246  C   VAL A 714      27.080  10.921   9.377  1.00 32.73           C
ATOM    247  O   VAL A 714      26.697  10.481  10.481  1.00 26.73           O
ATOM    248  CB  VAL A 714      25.383  11.126   7.522  1.00 25.09           C
ATOM    249  CG1 VAL A 714      24.777   9.828   8.038  1.00 23.99           C
ATOM    250  CG2 VAL A 714      24.289  12.054   7.041  1.00 21.72           C
ATOM    251  H   VAL A 714      27.043  12.979   7.012  0.00 26.72           H
ATOM    252  HA  VAL A 714      25.515  12.267   9.323  0.00 30.57           H
ATOM    253  HB  VAL A 714      26.059  10.901   6.709  0.00 25.09           H
ATOM    254 HG11 VAL A 714      24.189   9.377   7.252  0.00 23.99           H
ATOM    255 HG12 VAL A 714      25.531   9.121   8.344  0.00 23.99           H
ATOM    256 HG13 VAL A 714      24.126  10.026   8.878  0.00 23.99           H
ATOM    257 HG21 VAL A 714      23.710  11.580   6.259  0.00 21.72           H
ATOM    258 HG22 VAL A 714      23.620  12.292   7.861  0.00 21.72           H
ATOM    259 HG23 VAL A 714      24.692  12.977   6.652  0.00 21.72           H
ATOM    260  N   LEU A 715      28.258  10.604   8.859  1.00 28.49           N
ATOM    261  CA  LEU A 715      29.170   9.756   9.587  1.00 29.67           C
ATOM    262  C   LEU A 715      29.560  10.386  10.906  1.00 31.84           C
ATOM    263  O   LEU A 715      29.632   9.708  11.954  1.00 34.88           O
ATOM    264  CB  LEU A 715      30.418   9.526   8.756  1.00 32.96           C
ATOM    265  CG  LEU A 715      31.489   8.727   9.486  1.00 36.94           C
ATOM    266  CD1 LEU A 715      30.959   7.391   9.989  1.00 33.20           C
ATOM    267  CD2 LEU A 715      32.672   8.524   8.552  1.00 34.70           C
ATOM    268  H   LEU A 715      28.512  10.934   7.951  0.00 28.49           H
ATOM    269  HA  LEU A 715      28.686   8.826   9.827  0.00 29.67           H
ATOM    270  HB2 LEU A 715      30.123   8.996   7.859  0.00 32.96           H
ATOM    271  HB3 LEU A 715      30.812  10.485   8.459  0.00 32.96           H
ATOM    272  HG  LEU A 715      31.828   9.302  10.335  0.00 36.94           H
ATOM    273 HD11 LEU A 715      31.769   6.798  10.391  0.00 33.20           H
ATOM    274 HD12 LEU A 715      30.219   7.524  10.761  0.00 33.20           H
ATOM    275 HD13 LEU A 715      30.509   6.838   9.170  0.00 33.20           H
ATOM    276 HD21 LEU A 715      33.466   7.985   9.052  0.00 34.70           H
ATOM    277 HD22 LEU A 715      32.367   7.954   7.683  0.00 34.70           H
ATOM    278 HD23 LEU A 715      33.066   9.476   8.214  0.00 34.70           H
ATOM    279  N   GLN A 716      29.855  11.674  10.903  1.00 33.08           N
ATOM    280  CA  GLN A 716      30.243  12.326  12.122  1.00 30.92           C
ATOM    281  C   GLN A 716      29.094  12.308  13.101  1.00 35.88           C
ATOM    282  O   GLN A 716      29.317  12.160  14.323  1.00 35.57           O
ATOM    283  CB  GLN A 716      30.691  13.748  11.812  1.00 25.47           C
ATOM    284  CG  GLN A 716      31.228  14.470  13.037  1.00 34.92           C
ATOM    285  CD  GLN A 716      32.503  13.880  13.553  1.00 35.99           C
ATOM    286  OE1 GLN A 716      33.090  12.953  12.956  1.00 44.99           O
ATOM    287  NE2 GLN A 716      32.995  14.386  14.670  1.00 41.21           N
ATOM    288  H   GLN A 716      29.840  12.185  10.043  0.00 33.08           H
ATOM    289  HA  GLN A 716      31.039  11.782  12.592  0.00 30.92           H
ATOM    290  HB2 GLN A 716      31.462  13.686  11.061  0.00 25.47           H
ATOM    291  HB3 GLN A 716      29.863  14.304  11.405  0.00 25.47           H
ATOM    292  HG2 GLN A 716      31.427  15.504  12.790  0.00 34.92           H
ATOM    293  HG3 GLN A 716      30.505  14.475  13.838  0.00 34.92           H
ATOM    294 HE21 GLN A 716      32.586  15.167  15.144  0.00 41.21           H
ATOM    295 HE22 GLN A 716      33.847  14.018  15.026  0.00 41.21           H
ATOM    296  N   LEU A 717      27.864  12.470  12.626  1.00 28.19           N
ATOM    297  CA  LEU A 717      26.726  12.459  13.512  1.00 30.27           C
ATOM    298  C   LEU A 717      26.607  11.110  14.160  1.00 32.02           C
ATOM    299  O   LEU A 717      26.382  11.007  15.381  1.00 30.44           O
ATOM    300  CB  LEU A 717      25.449  12.767  12.747  1.00 26.79           C
ATOM    301  CG  LEU A 717      25.281  14.237  12.400  1.00 25.59           C
ATOM    302  CD1 LEU A 717      24.170  14.375  11.375  1.00 24.52           C
ATOM    303  CD2 LEU A 717      24.962  15.050  13.641  1.00 30.81           C
ATOM    304  H   LEU A 717      27.725  12.673  11.658  0.00 28.19           H
ATOM    305  HA  LEU A 717      26.877  13.161  14.313  0.00 30.27           H
ATOM    306  HB2 LEU A 717      25.449  12.165  11.850  0.00 26.79           H
ATOM    307  HB3 LEU A 717      24.605  12.457  13.346  0.00 26.79           H
ATOM    308  HG  LEU A 717      26.199  14.605  11.963  0.00 25.59           H
ATOM    309 HD11 LEU A 717      23.988  15.413  11.142  0.00 24.52           H
ATOM    310 HD12 LEU A 717      24.418  13.856  10.459  0.00 24.52           H
ATOM    311 HD13 LEU A 717      23.250  13.957  11.765  0.00 24.52           H
ATOM    312 HD21 LEU A 717      24.734  16.069  13.375  0.00 30.81           H
ATOM    313 HD22 LEU A 717      24.103  14.633  14.152  0.00 30.81           H
ATOM    314 HD23 LEU A 717      25.794  15.066  14.332  0.00 30.81           H
ATOM    315  N   GLU A 718      26.736  10.048  13.377  1.00 27.97           N
ATOM    316  CA  GLU A 718      26.652   8.718  13.928  1.00 30.39           C
ATOM    317  C   GLU A 718      27.697   8.553  15.000  1.00 35.12           C
ATOM    318  O   GLU A 718      27.440   7.979  16.072  1.00 37.15           O
ATOM    319  CB  GLU A 718      26.838   7.689  12.825  1.00 28.83           C
ATOM    320  CG  GLU A 718      25.611   7.582  11.938  1.00 34.52           C
ATOM    321  CD  GLU A 718      25.869   6.852  10.644  1.00 36.73           C
ATOM    322  OE1 GLU A 718      27.045   6.815  10.187  1.00 38.37           O
ATOM    323  OE2 GLU A 718      24.876   6.347  10.025  1.00 38.94           O
ATOM    324  H   GLU A 718      26.934  10.180  12.406  0.00 27.97           H
ATOM    325  HA  GLU A 718      25.706   8.578  14.420  0.00 30.39           H
ATOM    326  HB2 GLU A 718      27.692   7.966  12.230  0.00 28.83           H
ATOM    327  HB3 GLU A 718      27.049   6.729  13.275  0.00 28.83           H
ATOM    328  HG2 GLU A 718      24.798   7.095  12.454  0.00 34.52           H
ATOM    329  HG3 GLU A 718      25.275   8.569  11.656  0.00 34.52           H
ATOM    330  N   THR A 719      28.906   9.034  14.743  1.00 30.92           N
ATOM    331  CA  THR A 719      29.988   8.862  15.679  1.00 34.79           C
ATOM    332  C   THR A 719      29.710   9.599  16.970  1.00 33.65           C
ATOM    333  O   THR A 719      29.850   9.050  18.084  1.00 32.74           O
ATOM    334  CB  THR A 719      31.276   9.369  15.046  1.00 38.63           C
ATOM    335  OG1 THR A 719      31.541   8.603  13.869  1.00 45.28           O
ATOM    336  CG2 THR A 719      32.444   9.204  15.978  1.00 27.09           C
ATOM    337  H   THR A 719      29.082   9.474  13.866  0.00 30.92           H
ATOM    338  HA  THR A 719      30.100   7.823  15.933  0.00 34.79           H
ATOM    339  HB  THR A 719      31.142  10.403  14.777  0.00 38.63           H
ATOM    340  HG1 THR A 719      31.037   8.912  13.113  0.00 45.28           H
ATOM    341 HG21 THR A 719      33.352   9.484  15.467  0.00 27.09           H
ATOM    342 HG22 THR A 719      32.332   9.833  16.849  0.00 27.09           H
ATOM    343 HG23 THR A 719      32.519   8.178  16.303  0.00 27.09           H
ATOM    344  N   VAL A 720      29.344  10.867  16.887  1.00 30.38           N
ATOM    345  CA  VAL A 720      29.090  11.596  18.104  1.00 34.14           C
ATOM    346  C   VAL A 720      27.909  11.009  18.821  1.00 29.67           C
ATOM    347  O   VAL A 720      27.916  10.899  20.062  1.00 32.70           O
ATOM    348  CB  VAL A 720      28.877  13.079  17.806  1.00 38.12           C
ATOM    349  CG1 VAL A 720      28.486  13.822  19.074  1.00 27.04           C
ATOM    350  CG2 VAL A 720      30.150  13.670  17.214  1.00 38.95           C
ATOM    351  H   VAL A 720      29.216  11.308  15.996  0.00 30.38           H
ATOM    352  HA  VAL A 720      29.929  11.487  18.769  0.00 34.14           H
ATOM    353  HB  VAL A 720      28.076  13.161  17.081  0.00 38.12           H
ATOM    354 HG11 VAL A 720      28.422  14.880  18.867  0.00 27.04           H
ATOM    355 HG12 VAL A 720      27.530  13.493  19.459  0.00 27.04           H
ATOM    356 HG13 VAL A 720      29.233  13.673  19.841  0.00 27.04           H
ATOM    357 HG21 VAL A 720      30.012  14.729  17.032  0.00 38.95           H
ATOM    358 HG22 VAL A 720      30.971  13.546  17.907  0.00 38.95           H
ATOM    359 HG23 VAL A 720      30.406  13.198  16.279  0.00 38.95           H
ATOM    360  N   LEU A 721      26.850  10.659  18.104  1.00 32.97           N
ATOM    361  CA  LEU A 721      25.655  10.220  18.781  1.00 29.81           C
ATOM    362  C   LEU A 721      25.909   8.920  19.474  1.00 33.43           C
ATOM    363  O   LEU A 721      25.400   8.690  20.584  1.00 35.89           O
ATOM    364  CB  LEU A 721      24.499  10.123  17.804  1.00 29.64           C
ATOM    365  CG  LEU A 721      23.183   9.661  18.425  1.00 27.60           C
ATOM    366  CD1 LEU A 721      22.791  10.477  19.651  1.00 25.63           C
ATOM    367  CD2 LEU A 721      22.100   9.749  17.356  1.00 21.29           C
ATOM    368  H   LEU A 721      26.832  10.770  17.110  0.00 32.97           H
ATOM    369  HA  LEU A 721      25.416  10.922  19.558  0.00 29.81           H
ATOM    370  HB2 LEU A 721      24.360  11.104  17.374  0.00 29.64           H
ATOM    371  HB3 LEU A 721      24.773   9.452  17.000  0.00 29.64           H
ATOM    372  HG  LEU A 721      23.284   8.626  18.732  0.00 27.60           H
ATOM    373 HD11 LEU A 721      21.806  10.180  19.990  0.00 25.63           H
ATOM    374 HD12 LEU A 721      23.486  10.330  20.463  0.00 25.63           H
ATOM    375 HD13 LEU A 721      22.759  11.531  19.402  0.00 25.63           H
ATOM    376 HD21 LEU A 721      21.145   9.433  17.752  0.00 21.29           H
ATOM    377 HD22 LEU A 721      22.005  10.773  17.011  0.00 21.29           H
ATOM    378 HD23 LEU A 721      22.344   9.126  16.509  0.00 21.29           H
ATOM    379  N   GLU A 722      26.689   8.023  18.880  1.00 31.63           N
ATOM    380  CA  GLU A 722      26.996   6.791  19.569  1.00 37.13           C
ATOM    381  C   GLU A 722      27.681   7.072  20.888  1.00 38.76           C
ATOM    382  O   GLU A 722      27.423   6.419  21.912  1.00 35.26           O
ATOM    383  CB  GLU A 722      27.884   5.920  18.693  1.00 45.47           C
ATOM    384  CG  GLU A 722      27.867   4.492  19.180  1.00 58.76           C
ATOM    385  CD  GLU A 722      28.754   3.571  18.393  1.00 67.06           C
ATOM    386  OE1 GLU A 722      29.380   4.008  17.395  1.00 60.66           O
ATOM    387  OE2 GLU A 722      28.777   2.352  18.790  1.00 71.26           O
ATOM    388  H   GLU A 722      27.062   8.184  17.964  0.00 31.63           H
ATOM    389  HA  GLU A 722      26.083   6.271  19.810  0.00 37.13           H
ATOM    390  HB2 GLU A 722      27.512   5.966  17.681  0.00 45.47           H
ATOM    391  HB3 GLU A 722      28.888   6.313  18.682  0.00 45.47           H
ATOM    392  HG2 GLU A 722      28.149   4.423  20.222  0.00 58.76           H
ATOM    393  HG3 GLU A 722      26.862   4.092  19.112  0.00 58.76           H
ATOM    394  N   GLY A 723      28.611   8.021  20.878  1.00 42.23           N
ATOM    395  CA  GLY A 723      29.329   8.348  22.076  1.00 29.44           C
ATOM    396  C   GLY A 723      28.428   8.937  23.125  1.00 39.54           C
ATOM    397  O   GLY A 723      28.573   8.657  24.337  1.00 43.43           O
ATOM    398  H   GLY A 723      28.807   8.526  20.041  0.00 42.23           H
ATOM    399  HA2 GLY A 723      29.784   7.471  22.504  0.00 29.44           H
ATOM    400  HA3 GLY A 723      30.098   9.063  21.832  0.00 29.44           H
ATOM    401  N   VAL A 724      27.486   9.775  22.715  1.00 40.23           N
ATOM    402  CA  VAL A 724      26.537  10.322  23.660  1.00 37.40           C
ATOM    403  C   VAL A 724      25.717   9.217  24.254  1.00 36.96           C
ATOM    404  O   VAL A 724      25.477   9.171  25.474  1.00 36.78           O
ATOM    405  CB  VAL A 724      25.681  11.368  22.955  1.00 32.82           C
ATOM    406  CG1 VAL A 724      24.351  11.595  23.651  1.00 28.42           C
ATOM    407  CG2 VAL A 724      26.469  12.665  22.877  1.00 34.46           C
ATOM    408  H   VAL A 724      27.433  10.037  21.751  0.00 40.23           H
ATOM    409  HA  VAL A 724      27.062  10.778  24.481  0.00 37.40           H
ATOM    410  HB  VAL A 724      25.488  11.002  21.957  0.00 32.82           H
ATOM    411 HG11 VAL A 724      23.823  12.403  23.165  0.00 28.42           H
ATOM    412 HG12 VAL A 724      23.730  10.710  23.612  0.00 28.42           H
ATOM    413 HG13 VAL A 724      24.505  11.862  24.688  0.00 28.42           H
ATOM    414 HG21 VAL A 724      25.922  13.398  22.305  0.00 34.46           H
ATOM    415 HG22 VAL A 724      26.633  13.057  23.875  0.00 34.46           H
ATOM    416 HG23 VAL A 724      27.429  12.510  22.404  0.00 34.46           H
ATOM    417  N   VAL A 725      25.242   8.296  23.431  1.00 37.34           N
ATOM    418  CA  VAL A 725      24.420   7.246  23.967  1.00 40.18           C
ATOM    419  C   VAL A 725      25.180   6.446  24.997  1.00 42.80           C
ATOM    420  O   VAL A 725      24.618   6.042  26.029  1.00 40.56           O
ATOM    421  CB  VAL A 725      23.889   6.365  22.842  1.00 39.57           C
ATOM    422  CG1 VAL A 725      23.167   5.170  23.425  1.00 45.86           C
ATOM    423  CG2 VAL A 725      22.901   7.158  21.997  1.00 37.23           C
ATOM    424  H   VAL A 725      25.424   8.341  22.448  0.00 37.34           H
ATOM    425  HA  VAL A 725      23.586   7.674  24.502  0.00 40.18           H
ATOM    426  HB  VAL A 725      24.725   6.045  22.240  0.00 39.57           H
ATOM    427 HG11 VAL A 725      22.667   4.636  22.642  0.00 45.86           H
ATOM    428 HG12 VAL A 725      23.827   4.487  23.940  0.00 45.86           H
ATOM    429 HG13 VAL A 725      22.419   5.505  24.133  0.00 45.86           H
ATOM    430 HG21 VAL A 725      22.578   6.558  21.155  0.00 37.23           H
ATOM    431 HG22 VAL A 725      22.034   7.396  22.595  0.00 37.23           H
ATOM    432 HG23 VAL A 725      23.331   8.069  21.621  0.00 37.23           H
ATOM    433  N   SER A 726      26.455   6.151  24.770  1.00 40.16           N
ATOM    434  CA  SER A 726      27.149   5.314  25.705  1.00 40.36           C
ATOM    435  C   SER A 726      27.195   5.935  27.071  1.00 42.19           C
ATOM    436  O   SER A 726      27.040   5.249  28.094  1.00 45.48           O
ATOM    437  CB  SER A 726      28.566   5.059  25.251  1.00 33.03           C
ATOM    438  OG  SER A 726      28.491   3.936  24.394  1.00 42.08           O
ATOM    439  H   SER A 726      26.885   6.390  23.896  0.00 40.16           H
ATOM    440  HA  SER A 726      26.647   4.369  25.817  0.00 40.36           H
ATOM    441  HB2 SER A 726      28.952   5.929  24.744  0.00 33.03           H
ATOM    442  HB3 SER A 726      29.193   4.842  26.102  0.00 33.03           H
ATOM    443  HG  SER A 726      29.307   3.765  23.933  0.00 42.08           H
ATOM    444  N   GLN A 727      27.501   7.224  27.144  1.00 39.41           N
ATOM    445  CA  GLN A 727      27.619   7.821  28.448  1.00 42.13           C
ATOM    446  C   GLN A 727      26.258   7.911  29.084  1.00 44.78           C
ATOM    447  O   GLN A 727      26.144   7.769  30.316  1.00 48.64           O
ATOM    448  CB  GLN A 727      28.402   9.125  28.422  1.00 42.59           C
ATOM    449  CG  GLN A 727      27.984  10.052  27.304  1.00 48.01           C
ATOM    450  CD  GLN A 727      28.976  11.150  27.080  1.00 55.11           C
ATOM    451  OE1 GLN A 727      29.255  11.976  27.969  1.00 59.74           O
ATOM    452  NE2 GLN A 727      29.527  11.185  25.865  1.00 51.08           N
ATOM    453  H   GLN A 727      27.622   7.745  26.305  0.00 39.41           H
ATOM    454  HA  GLN A 727      28.154   7.131  29.078  0.00 42.13           H
ATOM    455  HB2 GLN A 727      28.294   9.611  29.381  0.00 42.59           H
ATOM    456  HB3 GLN A 727      29.443   8.859  28.304  0.00 42.59           H
ATOM    457  HG2 GLN A 727      27.879   9.522  26.382  0.00 48.01           H
ATOM    458  HG3 GLN A 727      27.026  10.506  27.517  0.00 48.01           H
ATOM    459 HE21 GLN A 727      29.323  10.466  25.209  0.00 51.08           H
ATOM    460 HE22 GLN A 727      29.992  12.012  25.560  0.00 51.08           H
ATOM    461  N   ILE A 728      25.193   8.075  28.317  1.00 39.39           N
ATOM    462  CA  ILE A 728      23.882   8.003  28.920  1.00 45.22           C
ATOM    463  C   ILE A 728      23.672   6.641  29.516  1.00 38.33           C
ATOM    464  O   ILE A 728      23.113   6.527  30.620  1.00 47.51           O
ATOM    465  CB  ILE A 728      22.813   8.408  27.908  1.00 43.04           C
ATOM    466  CG1 ILE A 728      22.862   9.926  27.758  1.00 40.27           C
ATOM    467  CG2 ILE A 728      21.438   7.920  28.319  1.00 44.30           C
ATOM    468  CD1 ILE A 728      21.850  10.464  26.761  1.00 44.04           C
ATOM    469  H   ILE A 728      25.277   8.207  27.332  0.00 39.39           H
ATOM    470  HA  ILE A 728      23.838   8.679  29.756  0.00 45.22           H
ATOM    471  HB  ILE A 728      23.071   7.950  26.963  0.00 43.04           H
ATOM    472 HG12 ILE A 728      22.687  10.368  28.731  0.00 40.27           H
ATOM    473 HG13 ILE A 728      23.856  10.208  27.444  0.00 40.27           H
ATOM    474 HG21 ILE A 728      20.702   8.212  27.587  0.00 44.30           H
ATOM    475 HG22 ILE A 728      21.409   6.842  28.394  0.00 44.30           H
ATOM    476 HG23 ILE A 728      21.149   8.334  29.276  0.00 44.30           H
ATOM    477 HD11 ILE A 728      22.023  11.516  26.581  0.00 44.04           H
ATOM    478 HD12 ILE A 728      21.932   9.945  25.813  0.00 44.04           H
ATOM    479 HD13 ILE A 728      20.838  10.354  27.123  0.00 44.04           H
ATOM    480  N   ASP A 729      24.092   5.579  28.853  1.00 38.51           N
ATOM    481  CA  ASP A 729      23.914   4.271  29.436  1.00 41.71           C
ATOM    482  C   ASP A 729      24.766   4.125  30.673  1.00 43.82           C
ATOM    483  O   ASP A 729      24.338   3.523  31.679  1.00 47.00           O
ATOM    484  CB  ASP A 729      24.227   3.198  28.416  1.00 40.30           C
ATOM    485  CG  ASP A 729      23.109   3.028  27.407  1.00 47.94           C
ATOM    486  OD1 ASP A 729      21.948   3.391  27.749  1.00 53.20           O
ATOM    487  OD2 ASP A 729      23.414   2.492  26.298  1.00 59.90           O
ATOM    488  H   ASP A 729      24.485   5.673  27.940  0.00 38.51           H
ATOM    489  HA  ASP A 729      22.898   4.160  29.755  0.00 41.71           H
ATOM    490  HB2 ASP A 729      25.148   3.421  27.906  0.00 40.30           H
ATOM    491  HB3 ASP A 729      24.349   2.249  28.922  0.00 40.30           H
ATOM    492  N   ALA A 730      25.983   4.642  30.648  1.00 36.09           N
ATOM    493  CA  ALA A 730      26.859   4.525  31.778  1.00 42.42           C
ATOM    494  C   ALA A 730      26.253   5.176  33.000  1.00 45.35           C
ATOM    495  O   ALA A 730      26.341   4.631  34.114  1.00 49.17           O
ATOM    496  CB  ALA A 730      28.193   5.166  31.441  1.00 32.44           C
ATOM    497  H   ALA A 730      26.321   5.069  29.811  0.00 36.09           H
ATOM    498  HA  ALA A 730      26.991   3.488  32.038  0.00 42.42           H
ATOM    499  HB1 ALA A 730      28.872   5.070  32.277  0.00 32.44           H
ATOM    500  HB2 ALA A 730      28.622   4.672  30.583  0.00 32.44           H
ATOM    501  HB3 ALA A 730      28.054   6.210  31.210  0.00 32.44           H
ATOM    502  N   VAL A 731      25.669   6.361  32.854  1.00 44.75           N
ATOM    503  CA  VAL A 731      25.121   6.992  34.029  1.00 49.69           C
ATOM    504  C   VAL A 731      23.809   6.355  34.377  1.00 46.73           C
ATOM    505  O   VAL A 731      23.455   6.229  35.568  1.00 49.90           O
ATOM    506  CB  VAL A 731      25.026   8.512  33.911  1.00 50.82           C
ATOM    507  CG1 VAL A 731      26.426   9.081  33.738  1.00 47.71           C
ATOM    508  CG2 VAL A 731      24.107   8.965  32.794  1.00 43.66           C
ATOM    509  H   VAL A 731      25.667   6.819  31.964  0.00 44.75           H
ATOM    510  HA  VAL A 731      25.769   6.770  34.857  0.00 49.69           H
ATOM    511  HB  VAL A 731      24.625   8.853  34.857  0.00 50.82           H
ATOM    512 HG11 VAL A 731      26.389  10.163  33.731  0.00 47.71           H
ATOM    513 HG12 VAL A 731      27.072   8.763  34.547  0.00 47.71           H
ATOM    514 HG13 VAL A 731      26.852   8.751  32.803  0.00 47.71           H
ATOM    515 HG21 VAL A 731      24.087  10.048  32.762  0.00 43.66           H
ATOM    516 HG22 VAL A 731      24.461   8.606  31.840  0.00 43.66           H
ATOM    517 HG23 VAL A 731      23.097   8.610  32.937  0.00 43.66           H
ATOM    518  N   GLY A 732      23.061   5.906  33.382  1.00 37.81           N
ATOM    519  CA  GLY A 732      21.818   5.247  33.679  1.00 51.03           C
ATOM    520  C   GLY A 732      22.038   4.014  34.505  1.00 49.13           C
ATOM    521  O   GLY A 732      21.242   3.699  35.408  1.00 51.28           O
ATOM    522  H   GLY A 732      23.318   6.049  32.428  0.00 37.81           H
ATOM    523  HA2 GLY A 732      21.157   5.891  34.234  0.00 51.03           H
ATOM    524  HA3 GLY A 732      21.346   4.974  32.749  0.00 51.03           H
ATOM    525  N   SER A 733      23.101   3.271  34.221  1.00 43.30           N
ATOM    526  CA  SER A 733      23.314   2.080  34.991  1.00 42.83           C
ATOM    527  C   SER A 733      23.882   2.400  36.343  1.00 52.33           C
ATOM    528  O   SER A 733      23.599   1.660  37.308  1.00 55.41           O
ATOM    529  CB  SER A 733      24.136   1.049  34.257  1.00 36.40           C
ATOM    530  OG  SER A 733      25.498   1.470  34.263  1.00 45.61           O
ATOM    531  H   SER A 733      23.681   3.477  33.428  0.00 43.30           H
ATOM    532  HA  SER A 733      22.356   1.637  35.195  0.00 42.83           H
ATOM    533  HB2 SER A 733      24.034   0.100  34.765  0.00 36.40           H
ATOM    534  HB3 SER A 733      23.763   0.961  33.249  0.00 36.40           H
ATOM    535  HG  SER A 733      26.054   0.936  33.706  0.00 45.61           H
ATOM    536  N   LYS A 734      24.627   3.486  36.508  1.00 51.05           N
ATOM    537  CA  LYS A 734      25.026   3.860  37.845  1.00 57.62           C
ATOM    538  C   LYS A 734      23.824   4.229  38.667  1.00 54.11           C
ATOM    539  O   LYS A 734      23.765   3.893  39.863  1.00 54.50           O
ATOM    540  CB  LYS A 734      26.014   5.010  37.832  1.00 56.52           C
ATOM    541  CG  LYS A 734      27.396   4.548  37.426  1.00 58.20           C
ATOM    542  CD  LYS A 734      28.351   5.721  37.317  1.00 58.87           C
ATOM    543  CE  LYS A 734      29.802   5.281  37.332  1.00 72.24           C
ATOM    544  NZ  LYS A 734      30.318   5.296  38.739  1.00 81.16           N
ATOM    545  H   LYS A 734      24.928   4.021  35.724  0.00 51.05           H
ATOM    546  HA  LYS A 734      25.463   3.008  38.339  0.00 57.62           H
ATOM    547  HB2 LYS A 734      25.650   5.784  37.172  0.00 56.52           H
ATOM    548  HB3 LYS A 734      26.065   5.422  38.831  0.00 56.52           H
ATOM    549  HG2 LYS A 734      27.755   3.834  38.159  0.00 58.20           H
ATOM    550  HG3 LYS A 734      27.351   4.039  36.473  0.00 58.20           H
ATOM    551  HD2 LYS A 734      28.152   6.258  36.401  0.00 58.87           H
ATOM    552  HD3 LYS A 734      28.181   6.416  38.131  0.00 58.87           H
ATOM    553  HE2 LYS A 734      29.913   4.272  36.972  0.00 72.24           H
ATOM    554  HE3 LYS A 734      30.439   5.936  36.768  0.00 72.24           H
ATOM    555  HZ1 LYS A 734      31.242   4.900  38.793  0.00 81.16           H
ATOM    556  HZ2 LYS A 734      30.368   6.241  39.081  0.00 81.16           H
ATOM    557  HZ3 LYS A 734      29.719   4.775  39.360  0.00 81.16           H
ATOM    558  N   LEU A 735      22.852   4.925  38.092  1.00 56.42           N
ATOM    559  CA  LEU A 735      21.665   5.225  38.854  1.00 58.82           C
ATOM    560  C   LEU A 735      21.001   3.950  39.279  1.00 60.01           C
ATOM    561  O   LEU A 735      20.474   3.861  40.402  1.00 64.14           O
ATOM    562  CB  LEU A 735      20.695   6.076  38.052  1.00 54.50           C
ATOM    563  CG  LEU A 735      21.206   7.475  37.746  1.00 52.13           C
ATOM    564  CD1 LEU A 735      20.140   8.219  36.957  1.00 49.71           C
ATOM    565  CD2 LEU A 735      21.558   8.234  39.014  1.00 46.60           C
ATOM    566  H   LEU A 735      22.943   5.248  37.151  0.00 56.42           H
ATOM    567  HA  LEU A 735      21.932   5.726  39.768  0.00 58.82           H
ATOM    568  HB2 LEU A 735      20.467   5.561  37.130  0.00 54.50           H
ATOM    569  HB3 LEU A 735      19.780   6.161  38.627  0.00 54.50           H
ATOM    570  HG  LEU A 735      22.089   7.393  37.131  0.00 52.13           H
ATOM    571 HD11 LEU A 735      20.486   9.211  36.689  0.00 49.71           H
ATOM    572 HD12 LEU A 735      19.889   7.686  36.049  0.00 49.71           H
ATOM    573 HD13 LEU A 735      19.242   8.323  37.554  0.00 49.71           H
ATOM    574 HD21 LEU A 735      21.801   9.264  38.779  0.00 46.60           H
ATOM    575 HD22 LEU A 735      20.722   8.229  39.701  0.00 46.60           H
ATOM    576 HD23 LEU A 735      22.413   7.800  39.516  0.00 46.60           H
ATOM    577  N   LYS A 736      20.990   2.926  38.430  1.00 58.33           N
ATOM    578  CA  LYS A 736      20.410   1.678  38.849  1.00 59.37           C
ATOM    579  C   LYS A 736      21.199   1.038  39.963  1.00 58.66           C
ATOM    580  O   LYS A 736      20.592   0.438  40.871  1.00 62.81           O
ATOM    581  CB  LYS A 736      20.272   0.695  37.709  1.00 50.05           C
ATOM    582  CG  LYS A 736      19.202   1.095  36.705  1.00 62.51           C
ATOM    583  CD  LYS A 736      18.725  -0.160  35.981  1.00 75.22           C
ATOM    584  CE  LYS A 736      18.452   0.056  34.511  1.00 65.54           C
ATOM    585  NZ  LYS A 736      18.320  -1.286  33.855  1.00 62.41           N
ATOM    586  H   LYS A 736      21.345   3.032  37.506  0.00 58.33           H
ATOM    587  HA  LYS A 736      19.438   1.863  39.272  0.00 59.37           H
ATOM    588  HB2 LYS A 736      21.225   0.567  37.215  0.00 50.05           H
ATOM    589  HB3 LYS A 736      20.003  -0.255  38.146  0.00 50.05           H
ATOM    590  HG2 LYS A 736      18.376   1.565  37.223  0.00 62.51           H
ATOM    591  HG3 LYS A 736      19.599   1.815  36.006  0.00 62.51           H
ATOM    592  HD2 LYS A 736      19.493  -0.917  36.064  0.00 75.22           H
ATOM    593  HD3 LYS A 736      17.839  -0.555  36.464  0.00 75.22           H
ATOM    594  HE2 LYS A 736      17.542   0.597  34.327  0.00 65.54           H
ATOM    595  HE3 LYS A 736      19.277   0.554  34.032  0.00 65.54           H
ATOM    596  HZ1 LYS A 736      18.141  -1.199  32.871  0.00 62.41           H
ATOM    597  HZ2 LYS A 736      19.163  -1.820  33.975  0.00 62.41           H
ATOM    598  HZ3 LYS A 736      17.562  -1.809  34.265  0.00 62.41           H
ATOM    599  N   MET A 737      22.523   1.109  39.949  1.00 50.55           N
ATOM    600  CA  MET A 737      23.259   0.607  41.088  1.00 52.81           C
ATOM    601  C   MET A 737      22.878   1.354  42.338  1.00 56.83           C
ATOM    602  O   MET A 737      22.724   0.746  43.409  1.00 55.78           O
ATOM    603  CB  MET A 737      24.752   0.739  40.859  1.00 55.31           C
ATOM    604  CG  MET A 737      25.300  -0.311  39.912  1.00 84.69           C
ATOM    605  SD  MET A 737      25.914  -1.845  40.787  1.00 97.70           S
ATOM    606  CE  MET A 737      24.357  -2.826  40.955  1.00 68.31           C
ATOM    607  H   MET A 737      22.997   1.534  39.182  0.00 50.55           H
ATOM    608  HA  MET A 737      22.988  -0.414  41.270  0.00 52.81           H
ATOM    609  HB2 MET A 737      24.939   1.728  40.465  0.00 55.31           H
ATOM    610  HB3 MET A 737      25.258   0.664  41.809  0.00 55.31           H
ATOM    611  HG2 MET A 737      24.567  -0.621  39.186  0.00 84.69           H
ATOM    612  HG3 MET A 737      26.164   0.065  39.393  0.00 84.69           H
ATOM    613  HE1 MET A 737      24.643  -3.837  41.187  0.00 68.31           H
ATOM    614  HE2 MET A 737      23.740  -2.424  41.737  0.00 68.31           H
ATOM    615  HE3 MET A 737      23.857  -2.803  40.009  0.00 68.31           H
ATOM    616  N   LEU A 738      22.730   2.669  42.263  1.00 55.41           N
ATOM    617  CA  LEU A 738      22.312   3.405  43.430  1.00 56.92           C
ATOM    618  C   LEU A 738      20.994   2.890  43.939  1.00 60.54           C
ATOM    619  O   LEU A 738      20.787   2.751  45.162  1.00 52.99           O
ATOM    620  CB  LEU A 738      22.177   4.878  43.106  1.00 56.23           C
ATOM    621  CG  LEU A 738      23.508   5.577  42.862  1.00 55.46           C
ATOM    622  CD1 LEU A 738      23.237   7.069  42.751  1.00 61.67           C
ATOM    623  CD2 LEU A 738      24.487   5.301  43.992  1.00 62.08           C
ATOM    624  H   LEU A 738      22.888   3.149  41.401  0.00 55.41           H
ATOM    625  HA  LEU A 738      23.011   3.248  44.235  0.00 56.92           H
ATOM    626  HB2 LEU A 738      21.532   4.991  42.251  0.00 56.23           H
ATOM    627  HB3 LEU A 738      21.697   5.359  43.949  0.00 56.23           H
ATOM    628  HG  LEU A 738      23.926   5.223  41.932  0.00 55.46           H
ATOM    629 HD11 LEU A 738      24.142   7.616  42.523  0.00 61.67           H
ATOM    630 HD12 LEU A 738      22.501   7.276  41.984  0.00 61.67           H
ATOM    631 HD13 LEU A 738      22.853   7.438  43.697  0.00 61.67           H
ATOM    632 HD21 LEU A 738      25.348   5.954  43.915  0.00 62.08           H
ATOM    633 HD22 LEU A 738      24.014   5.480  44.950  0.00 62.08           H
ATOM    634 HD23 LEU A 738      24.840   4.280  43.976  0.00 62.08           H
ATOM    635  N   GLU A 739      20.064   2.621  43.036  1.00 58.03           N
ATOM    636  CA  GLU A 739      18.771   2.117  43.433  1.00 59.10           C
ATOM    637  C   GLU A 739      18.930   0.784  44.120  1.00 64.08           C
ATOM    638  O   GLU A 739      18.309   0.513  45.167  1.00 69.54           O
ATOM    639  CB  GLU A 739      17.894   2.031  42.198  1.00 59.69           C
ATOM    640  CG  GLU A 739      16.546   1.383  42.474  1.00 64.55           C
ATOM    641  CD  GLU A 739      16.356   0.036  41.802  1.00 77.44           C
ATOM    642  OE1 GLU A 739      17.003  -0.211  40.741  1.00 71.79           O
ATOM    643  OE2 GLU A 739      15.512  -0.742  42.332  1.00 85.32           O
ATOM    644  H   GLU A 739      20.237   2.812  42.071  0.00 58.03           H
ATOM    645  HA  GLU A 739      18.332   2.772  44.165  0.00 59.10           H
ATOM    646  HB2 GLU A 739      17.776   3.041  41.834  0.00 59.69           H
ATOM    647  HB3 GLU A 739      18.409   1.467  41.443  0.00 59.69           H
ATOM    648  HG2 GLU A 739      16.371   1.261  43.529  0.00 64.55           H
ATOM    649  HG3 GLU A 739      15.750   2.018  42.103  0.00 64.55           H
ATOM    650  N   ARG A 740      19.775  -0.082  43.580  1.00 61.20           N
ATOM    651  CA  ARG A 740      20.009  -1.362  44.191  1.00 59.46           C
ATOM    652  C   ARG A 740      20.671  -1.267  45.535  1.00 59.83           C
ATOM    653  O   ARG A 740      20.601  -2.248  46.304  1.00 60.93           O
ATOM    654  CB  ARG A 740      20.850  -2.230  43.269  1.00 49.08           C
ATOM    655  CG  ARG A 740      19.972  -2.961  42.273  1.00 55.55           C
ATOM    656  CD  ARG A 740      20.822  -3.702  41.260  1.00 60.68           C
ATOM    657  NE  ARG A 740      21.086  -2.945  40.039  1.00 61.26           N
ATOM    658  CZ  ARG A 740      20.407  -3.170  38.924  1.00 70.50           C
ATOM    659  NH1 ARG A 740      19.212  -3.742  38.997  1.00 66.85           N
ATOM    660  NH2 ARG A 740      20.911  -2.860  37.739  1.00 64.32           N
ATOM    661  H   ARG A 740      20.243   0.149  42.727  0.00 61.20           H
ATOM    662  HA  ARG A 740      19.065  -1.844  44.383  0.00 59.46           H
ATOM    663  HB2 ARG A 740      21.572  -1.609  42.766  0.00 49.08           H
ATOM    664  HB3 ARG A 740      21.380  -2.962  43.859  0.00 49.08           H
ATOM    665  HG2 ARG A 740      19.352  -3.667  42.811  0.00 55.55           H
ATOM    666  HG3 ARG A 740      19.311  -2.270  41.764  0.00 55.55           H
ATOM    667  HD2 ARG A 740      21.779  -3.944  41.695  0.00 60.68           H
ATOM    668  HD3 ARG A 740      20.363  -4.636  40.972  0.00 60.68           H
ATOM    669  HE  ARG A 740      21.862  -2.329  40.008  0.00 61.26           H
ATOM    670 HH11 ARG A 740      18.749  -3.820  39.868  0.00 66.85           H
ATOM    671 HH12 ARG A 740      18.904  -4.327  38.245  0.00 66.85           H
ATOM    672 HH21 ARG A 740      21.872  -2.629  37.580  0.00 64.32           H
ATOM    673 HH22 ARG A 740      20.350  -2.943  36.924  0.00 64.32           H
ATOM    674  N   LYS A 741      21.331  -0.168  45.845  1.00 53.92           N
ATOM    675  CA  LYS A 741      21.989   0.000  47.111  1.00 45.26           C
ATOM    676  C   LYS A 741      21.154   0.792  48.080  1.00 60.06           C
ATOM    677  O   LYS A 741      21.622   1.088  49.193  1.00 69.17           O
ATOM    678  CB  LYS A 741      23.365   0.611  46.921  1.00 48.09           C
ATOM    679  CG  LYS A 741      24.258  -0.331  46.141  1.00 54.85           C
ATOM    680  CD  LYS A 741      25.697   0.153  46.077  1.00 55.20           C
ATOM    681  CE  LYS A 741      26.515  -0.825  45.268  1.00 48.85           C
ATOM    682  NZ  LYS A 741      27.961  -0.476  45.250  1.00 55.05           N
ATOM    683  H   LYS A 741      21.477   0.525  45.142  0.00 53.92           H
ATOM    684  HA  LYS A 741      22.097  -0.975  47.554  0.00 45.26           H
ATOM    685  HB2 LYS A 741      23.268   1.550  46.396  0.00 48.09           H
ATOM    686  HB3 LYS A 741      23.782   0.811  47.897  0.00 48.09           H
ATOM    687  HG2 LYS A 741      24.237  -1.307  46.609  0.00 54.85           H
ATOM    688  HG3 LYS A 741      23.868  -0.434  45.139  0.00 54.85           H
ATOM    689  HD2 LYS A 741      25.740   1.136  45.623  0.00 55.20           H
ATOM    690  HD3 LYS A 741      26.101   0.234  47.077  0.00 55.20           H
ATOM    691  HE2 LYS A 741      26.441  -1.818  45.673  0.00 48.85           H
ATOM    692  HE3 LYS A 741      26.189  -0.845  44.242  0.00 48.85           H
ATOM    693  HZ1 LYS A 741      28.445  -1.154  44.628  0.00 55.05           H
ATOM    694  HZ2 LYS A 741      28.102   0.453  44.895  0.00 55.05           H
ATOM    695  HZ3 LYS A 741      28.358  -0.523  46.173  0.00 55.05           H
ATOM    696  N   GLY A 742      19.910   1.104  47.723  1.00 56.17           N
ATOM    697  CA  GLY A 742      19.013   1.747  48.640  1.00 54.77           C
ATOM    698  C   GLY A 742      19.000   3.242  48.584  1.00 55.73           C
ATOM    699  O   GLY A 742      18.250   3.852  49.381  1.00 60.93           O
ATOM    700  H   GLY A 742      19.579   0.893  46.803  0.00 56.17           H
ATOM    701  HA2 GLY A 742      18.005   1.415  48.444  0.00 54.77           H
ATOM    702  HA3 GLY A 742      19.273   1.469  49.650  0.00 54.77           H
ATOM    703  N   TRP A 743      19.766   3.850  47.705  0.76 56.29           N
ATOM    704  CA  TRP A 743      19.678   5.267  47.476  0.76 48.88           C
ATOM    705  C   TRP A 743      18.566   5.554  46.485  0.76 56.42           C
ATOM    706  O   TRP A 743      17.705   4.676  46.247  0.76 62.22           O
ATOM    707  CB  TRP A 743      20.999   5.795  46.936  0.76 48.27           C
ATOM    708  CG  TRP A 743      22.177   5.490  47.790  0.76 50.77           C
ATOM    709  CD1 TRP A 743      23.018   4.434  47.666  0.76 50.48           C
ATOM    710  CD2 TRP A 743      22.654   6.278  48.904  0.76 50.29           C
ATOM    711  NE1 TRP A 743      24.008   4.511  48.632  0.76 50.57           N
ATOM    712  CE2 TRP A 743      23.799   5.631  49.409  0.76 50.92           C
ATOM    713  CE3 TRP A 743      22.203   7.452  49.508  0.76 44.89           C
ATOM    714  CZ2 TRP A 743      24.491   6.127  50.509  0.76 47.89           C
ATOM    715  CZ3 TRP A 743      22.895   7.952  50.592  0.76 43.99           C
ATOM    716  CH2 TRP A 743      24.027   7.290  51.087  0.76 43.43           C
ATOM    717  OXT TRP A 743      18.594   6.700  45.923  0.76 56.42           O
ATOM    718  H   TRP A 743      20.242   3.312  47.012  0.00 56.29           H
ATOM    719  HA  TRP A 743      19.438   5.750  48.409  0.00 48.88           H
ATOM    720  HB2 TRP A 743      21.149   5.361  45.958  0.00 48.27           H
ATOM    721  HB3 TRP A 743      20.893   6.859  46.801  0.00 48.27           H
ATOM    722  HD1 TRP A 743      22.994   3.639  46.957  0.00 50.48           H
ATOM    723  HE1 TRP A 743      24.734   3.848  48.757  0.00 50.57           H
ATOM    724  HE3 TRP A 743      21.327   7.938  49.134  0.00 44.89           H
ATOM    725  HZ2 TRP A 743      25.355   5.623  50.895  0.00 47.89           H
ATOM    726  HZ3 TRP A 743      22.564   8.847  51.079  0.00 43.99           H
ATOM    727  HH2 TRP A 743      24.539   7.699  51.935  0.00 43.43           H
TER
HETATM  728  O   HOH S   1      37.102  14.983   3.406  1.00 43.82           O
HETATM  729  H1  HOH S   1      37.936  15.371   3.166  0.00 43.82           H
HETATM  730  H2  HOH S   1      36.485  15.637   3.779  0.00 43.82           H
HETATM  731  O   HOH S   2      33.639  11.035  11.311  1.00 51.24           O
HETATM  732  H1  HOH S   2      34.580  11.075  11.447  0.00 51.24           H
HETATM  733  H2  HOH S   2      33.222  11.742  11.807  0.00 51.24           H
HETATM  734  O   HOH S   3      36.103  15.502   6.625  1.00 53.01           O
HETATM  735  H1  HOH S   3      35.876  16.098   5.894  0.00 53.01           H
HETATM  736  H2  HOH S   3      35.675  15.751   7.439  0.00 53.01           H
HETATM  737  O   HOH S   4      22.304   5.976  11.072  1.00 32.81           O
HETATM  738  H1  HOH S   4      23.191   6.135  10.727  0.00 32.81           H
HETATM  739  H2  HOH S   4      21.682   6.645  10.800  0.00 32.81           H
HETATM  740  O   HOH S   5      31.577   7.057  18.699  1.00 42.74           O
HETATM  741  H1  HOH S   5      32.423   7.459  18.860  0.00 42.74           H
HETATM  742  H2  HOH S   5      30.927   7.723  18.466  0.00 42.74           H
HETATM  743  O   HOH S   6      29.638  13.776  24.815  1.00 50.68           O
HETATM  744  H1  HOH S   6      29.221  14.374  25.432  0.00 50.68           H
HETATM  745  H2  HOH S   6      29.059  13.591  24.085  0.00 50.68           H
HETATM  746  O   HOH S   7      26.278   2.309  12.190  1.00 42.98           O
HETATM  747  H1  HOH S   7      27.066   2.839  12.115  0.00 42.98           H
HETATM  748  H2  HOH S   7      25.547   2.844  12.510  0.00 42.98           H
HETATM  749  O   HOH S   8      24.679   4.244  13.176  1.00 42.58           O
HETATM  750  H1  HOH S   8      25.475   4.760  13.260  0.00 42.58           H
HETATM  751  H2  HOH S   8      24.026   4.599  13.797  0.00 42.58           H
HETATM  752  O   HOH S   9      23.351   5.567  15.076  1.00 48.21           O
HETATM  753  H1  HOH S   9      23.699   5.663  15.969  0.00 48.21           H
HETATM  754  H2  HOH S   9      22.530   6.044  14.986  0.00 48.21           H
HETATM  755  O   HOH S  10      23.819   6.019  17.701  1.00 38.43           O
HETATM  756  H1  HOH S  10      24.507   6.632  17.933  0.00 38.43           H
HETATM  757  H2  HOH S  10      22.960   6.370  17.922  0.00 38.43           H
HETATM  758  O   HOH S  11      20.261   8.881  32.107  1.00 59.14           O
HETATM  759  H1  HOH S  11      21.114   9.164  31.788  0.00 59.14           H
HETATM  760  H2  HOH S  11      19.670   9.619  32.214  0.00 59.14           H
HETATM  761  O   HOH S  12      18.714   6.780  31.460  1.00 56.28           O
HETATM  762  H1  HOH S  12      19.386   7.442  31.648  0.00 56.28           H
HETATM  763  H2  HOH S  12      17.849   7.165  31.562  0.00 56.28           H
HETATM  764  O   HOH S  13      19.196   7.303  41.660  1.00 64.34           O
HETATM  765  H1  HOH S  13      19.931   7.781  42.032  0.00 64.34           H
HETATM  766  H2  HOH S  13      18.587   6.959  42.336  0.00 64.34           H
HETATM  767  O   HOH S  14      17.634   6.339  43.534  1.00 65.54           O
HETATM  768  H1  HOH S  14      17.938   6.500  44.451  0.00 65.54           H
HETATM  769  H2  HOH S  14      16.697   6.198  43.484  0.00 65.54           H
"""

pdb_str_09 = """
CRYST1   49.280   66.590   47.260  90.00  92.40  90.00 P 1 21 1
ATOM      1  N   CYS A 186      22.251   3.226  21.792  1.00  3.34           N
ATOM      2  CA  CYS A 186      23.063   4.352  22.231  1.00  3.42           C
ATOM      3  C   CYS A 186      23.944   3.924  23.393  1.00  3.43           C
ATOM      4  O   CYS A 186      23.437   3.339  24.357  1.00  3.70           O
ATOM      5  H   CYS A 186      22.171   2.576  22.349  1.00  3.34           H
ATOM      6  HA  CYS A 186      23.637   4.658  21.511  1.00  3.42           H
ATOM      7  CB ACYS A 186      22.122   5.488  22.658  0.70  3.77           C
ATOM      8  SG ACYS A 186      23.034   6.948  23.170  0.70  5.03           S
ATOM      9  HB2ACYS A 186      21.534   5.715  21.921  0.70  4.57           H
ATOM     10  HB3ACYS A 186      21.559   5.185  23.388  0.70  4.57           H
ATOM     11  HG ACYS A 186      23.472   7.506  22.202  0.70  8.84           H
ATOM     12  CB BCYS A 186      22.198   5.514  22.639  0.30  4.57           C
ATOM     13  SG BCYS A 186      22.935   7.156  23.001  0.30  8.84           S
ATOM     14  HB2BCYS A 186      21.545   5.644  21.934  0.30  4.57           H
ATOM     15  HB3BCYS A 186      21.709   5.241  23.431  0.30  4.57           H
ATOM     16  HG BCYS A 186      23.377   7.628  21.990  0.30  8.84           H
ATOM     17  N  ATHR A 191      27.350   7.274  20.124  0.70  3.35           N
ATOM     18  CA ATHR A 191      26.814   8.243  21.048  0.70  3.27           C
ATOM     19  C  ATHR A 191      25.587   8.983  20.559  0.70  3.53           C
ATOM     20  O  ATHR A 191      24.872   9.566  21.383  0.70  3.93           O
ATOM     21  CB ATHR A 191      27.925   9.229  21.468  0.70  3.73           C
ATOM     22  OG1ATHR A 191      28.519   9.718  20.259  0.70  5.22           O
ATOM     23  CG2ATHR A 191      28.924   8.567  22.345  0.70  4.21           C
ATOM     24  H  ATHR A 191      28.031   7.538  19.670  0.70  4.73           H
ATOM     25  HA ATHR A 191      26.502   7.738  21.815  0.70  5.22           H
ATOM     26  HB ATHR A 191      27.562   9.964  21.987  0.70  5.81           H
ATOM     27  HG1ATHR A 191      28.164  10.449  20.048  0.70  6.87           H
ATOM     28 HG21ATHR A 191      29.610   9.206  22.594  0.70  6.53           H
ATOM     29 HG22ATHR A 191      28.485   8.236  23.144  0.70  6.53           H
ATOM     30 HG23ATHR A 191      29.331   7.826  21.870  0.70  6.53           H
ATOM     31  N  BTHR A 191      27.001   7.449  20.189  0.30  4.73           N
ATOM     32  CA BTHR A 191      26.482   8.443  21.103  0.30  5.22           C
ATOM     33  C  BTHR A 191      25.280   9.248  20.599  0.30  6.06           C
ATOM     34  O  BTHR A 191      24.521   9.713  21.419  0.30  6.27           O
ATOM     35  CB BTHR A 191      27.622   9.408  21.469  0.30  5.81           C
ATOM     36  OG1BTHR A 191      28.300   9.871  20.275  0.30  6.87           O
ATOM     37  CG2BTHR A 191      28.674   8.659  22.258  0.30  6.53           C
ATOM     38  H  BTHR A 191      27.648   7.727  19.695  0.30  4.73           H
ATOM     39  HA BTHR A 191      26.148   7.950  21.868  0.30  5.22           H
ATOM     40  HB BTHR A 191      27.235  10.146  21.966  0.30  5.81           H
ATOM     41  HG1BTHR A 191      27.753  10.271  19.779  0.30  6.87           H
ATOM     42 HG21BTHR A 191      29.396   9.264  22.491  0.30  6.53           H
ATOM     43 HG22BTHR A 191      28.278   8.301  23.068  0.30  6.53           H
ATOM     44 HG23BTHR A 191      29.024   7.931  21.721  0.30  6.53           H
ATOM     45  N  AGLN A 192      25.312   8.971  19.243  0.70  4.07           N
ATOM     46  CA AGLN A 192      24.033   9.419  18.718  0.70  4.07           C
ATOM     47  C  AGLN A 192      23.734  10.895  18.979  0.70  3.82           C
ATOM     48  O  AGLN A 192      22.573  11.289  19.085  0.70  4.49           O
ATOM     49  CB AGLN A 192      22.858   8.582  19.216  0.70  4.33           C
ATOM     50  CG AGLN A 192      22.950   7.115  18.827  0.70  4.86           C
ATOM     51  CD AGLN A 192      22.276   6.833  17.491  0.70  4.28           C
ATOM     52  OE1AGLN A 192      22.194   7.713  16.613  0.70  5.70           O
ATOM     53  NE2AGLN A 192      21.769   5.626  17.346  0.70  4.05           N
ATOM     54  H  AGLN A 192      25.865   8.703  18.642  0.70  5.54           H
ATOM     55  HA AGLN A 192      24.128   9.297  17.760  0.70  5.05           H
ATOM     56  HB2AGLN A 192      22.808   8.650  20.182  0.70  6.08           H
ATOM     57  HB3AGLN A 192      22.034   8.952  18.862  0.70  6.08           H
ATOM     58  HG2AGLN A 192      23.883   6.852  18.779  0.70  8.01           H
ATOM     59  HG3AGLN A 192      22.537   6.572  19.517  0.70  8.01           H
ATOM     60 HE21AGLN A 192      21.848   5.048  17.978  0.70  4.48           H
ATOM     61 HE22AGLN A 192      21.359   5.416  16.620  0.70  4.48           H
ATOM     62  N  BGLN A 192      25.136   9.400  19.308  0.30  5.54           N
ATOM     63  CA BGLN A 192      23.868   9.855  18.795  0.30  5.05           C
ATOM     64  C  BGLN A 192      23.555  11.302  19.135  0.30  5.35           C
ATOM     65  O  BGLN A 192      22.366  11.654  19.263  0.30  6.11           O
ATOM     66  CB BGLN A 192      22.687   8.972  19.292  0.30  6.08           C
ATOM     67  CG BGLN A 192      22.905   7.554  18.849  0.30  8.01           C
ATOM     68  CD BGLN A 192      22.165   7.149  17.568  0.30  5.68           C
ATOM     69  OE1BGLN A 192      22.003   7.967  16.661  0.30  8.03           O
ATOM     70  NE2BGLN A 192      21.686   5.924  17.490  0.30  4.47           N
ATOM     71  H  BGLN A 192      25.744   9.250  18.719  0.30  5.54           H
ATOM     72  HA BGLN A 192      23.959   9.781  17.832  0.30  5.05           H
ATOM     73  HB2BGLN A 192      22.624   9.013  20.259  0.30  6.08           H
ATOM     74  HB3BGLN A 192      21.848   9.307  18.938  0.30  6.08           H
ATOM     75  HG2BGLN A 192      23.855   7.415  18.714  0.30  8.01           H
ATOM     76  HG3BGLN A 192      22.630   6.961  19.565  0.30  8.01           H
ATOM     77 HE21BGLN A 192      21.812   5.371  18.136  0.30  4.48           H
ATOM     78 HE22BGLN A 192      21.247   5.677  16.793  0.30  4.48           H
TER
END
"""

def core(pdb_str, pair_proxies = None):
  pdb_inp = iotbx.pdb.input(source_info = None, lines = pdb_str)
  model = mmtbx.model.manager(
    model_input   = pdb_inp,
    process_input = True,
    log           = null_out())
  return mmtbx.nci.hbond.find(model=model, pair_proxies=pair_proxies)

def exercise_00():
  r = core(pdb_str=pdb_str_00)
  #r.show()
  assert len(r.result) == 5
  d_HA = flex.double()
  d_AD = flex.double()
  a_DHA = flex.double()
  for r in r.result:
    d_HA .append(r.d_HA )
    d_AD .append(r.d_AD )
    a_DHA.append(r.a_DHA)
  assert approx_equal(flex.mean(d_HA), 2.104, 1.e-2)
  assert approx_equal(flex.mean(d_AD), 2.899, 1.e-2)
  assert approx_equal(flex.mean(a_DHA), 153.2, 1.e-1)

def exercise_01():
  r = core(pdb_str=pdb_str_01)
  #r.show()
  assert len(r.result) == 2
  r0 = r.result[0]
  r1 = r.result[1]
  for r_ in r.result:
    assert approx_equal(r_.d_HA, 2.206, 1.e-2)
    assert approx_equal(r_.d_AD, 3.065, 1.e-2)
    assert approx_equal(r_.a_DHA, 142.98, 1.e-1)
    assert str(r_.symop) == "x-y,-y,-z+1"
  assert [r0.i, r0.j] == [3,6], [r0.i, r0.j]
  assert [r1.i, r1.j] == [6,3], [r1.i, r1.j]

def exercise_02():
  r = core(pdb_str=pdb_str_02)
  #r.show()
  #r.as_pymol()
  assert len(r.result) == 2
  r0 = r.result[0]
  r1 = r.result[1]
  assert approx_equal(r0.d_HA, 2.523, 1.e-2)
  assert approx_equal(r0.d_AD, 3.292, 1.e-2)
  assert approx_equal(r0.a_DHA, 149.378, 1.e-1)
  assert str(r0.symop) == "x,y,z"
  assert approx_equal(r1.d_HA, 1.644, 1.e-2)
  assert approx_equal(r1.d_AD, 2.472, 1.e-2)
  assert approx_equal(r1.a_DHA, 160.475, 1.e-1)
  assert str(r1.symop) == "x,y,z"

def exercise_03():
  r1 = core(pdb_str=pdb_str_00)
  assert len(r1.result) == 5
  r2 = core(pdb_str=pdb_str_03, pair_proxies = r1.pair_proxies)
  assert len(r2.result) == 5, len(r2.result)
  r2.as_pymol()
  for a,b in zip(r1.result, r2.result):
    assert a.i == b.i
    assert a.j == b.j

def exercise_04():
  """
  Case when A is not bonded to anything (based on 1yjp).
  """
  r = core(pdb_str=pdb_str_04)

def exercise_05():
  """
  Exercise the use of a_YAH.
  """
  for pdb_str in [pdb_str_05, pdb_str_06, pdb_str_07, pdb_str_08]:
    r = core(pdb_str=pdb_str_05)
    assert len(r.result) == 0 and r.result == []

def exercise_06():
  """
  Q|R/TeraChem refined 4gif (paper #3).
  """
  r = core(pdb_str=pdb_str_08)
  assert len(r.result) == 76
  cntr = 0
  for r_ in r.result:
    if(str(r_.symop)=="x,y,z"): continue
    cntr += 1
  assert cntr == 12 # number of symmetry H bonds

def exercise_07():
  """
  Altlocs.
  """
  r = core(pdb_str=pdb_str_09)
  assert len(r.result) == 2
  for i, r_ in enumerate(r.result):
    print (r_.i, r_.j)
    if(i==0):
      assert [r_.i, r_.j] == [10,19]
    elif(i==1):
      assert [r_.i, r_.j] == [15,33]
    else: assert 0

def exercise_08():
  from libtbx import easy_run
  with open('exercise_08_01.pdb', 'w') as f:
    f.write(pdb_str_01)
  cmd = 'phenix.hbond exercise_08_01.pdb'
  rc = easy_run.go(cmd)
  for line in rc.stdout_lines:
    if line.find('Per residue')>-1: break
  else:
    assert 'no Pre'

if __name__ == '__main__':
  t0 = time.time()
  exercise_00()
  exercise_01()
  exercise_02()
  exercise_03()
  exercise_04()
  exercise_05()
  exercise_06()
  exercise_07()
  exercise_08()
  print("OK. Time: %6.3f"%(time.time()-t0))
