from __future__ import absolute_import, division, print_function
import iotbx.pdb
import time
from scitbx.array_family import flex
import boost_adaptbx.boost.python as bp
asu_map_ext = bp.import_ext("cctbx_asymmetric_map_ext")
from libtbx.test_utils import approx_equal
from libtbx import group_args
from mmtbx.bulk_solvent import mosaic

pdb_str = """
REMARK iotbx.pdb.box_around_molecule --buffer-layer=2 "l.pdb"
REMARK Date 2020-04-16 Time 11:24:48 PDT -0700 (1587061488.33 s)
CRYST1   36.359   37.628   51.937  90.00  90.00  90.00 P 1
SCALE1      0.027504  0.000000  0.000000        0.00000
SCALE2      0.000000  0.026576  0.000000        0.00000
SCALE3      0.000000  0.000000  0.019254        0.00000
ATOM      1  N   LYS     1       6.885  22.776  20.969  1.00  7.59           N
ATOM      2  CA  LYS     1       7.314  22.228  19.673  1.00  7.59           C
ATOM      3  C   LYS     1       7.946  20.842  19.872  1.00  7.59           C
ATOM      4  O   LYS     1       8.694  20.610  20.830  1.00  7.59           O
ATOM      5  CB  LYS     1       8.386  23.180  19.074  1.00  7.59           C
ATOM      6  CG  LYS     1       9.247  22.500  18.006  1.00  7.59           C
ATOM      7  CD  LYS     1       9.878  23.486  17.023  1.00  7.59           C
ATOM      8  CE  LYS     1      10.485  22.800  15.797  1.00  7.59           C
ATOM      9  NZ  LYS     1      11.589  23.564  15.197  1.00  7.59           N
ATOM     10  N   VAL     2       7.623  19.950  18.951  1.00  7.59           N
ATOM     11  CA  VAL     2       8.151  18.570  18.956  1.00  7.59           C
ATOM     12  C   VAL     2       9.125  18.388  17.774  1.00  7.59           C
ATOM     13  O   VAL     2       8.706  18.279  16.615  1.00  7.59           O
ATOM     14  CB  VAL     2       6.995  17.566  18.811  1.00  7.59           C
ATOM     15  CG1 VAL     2       7.458  16.107  18.839  1.00  7.59           C
ATOM     16  CG2 VAL     2       5.942  17.682  19.919  1.00  7.59           C
ATOM     17  N   PHE     3      10.429  18.362  18.082  1.00  7.59           N
ATOM     18  CA  PHE     3      11.492  18.184  17.044  1.00  7.59           C
ATOM     19  C   PHE     3      11.624  16.687  16.680  1.00  7.59           C
ATOM     20  O   PHE     3      10.965  15.828  17.278  1.00  7.59           O
ATOM     21  CB  PHE     3      12.838  18.723  17.535  1.00  7.59           C
ATOM     22  CG  PHE     3      12.867  20.253  17.666  1.00  7.59           C
ATOM     23  CD1 PHE     3      12.621  20.839  18.908  1.00  7.59           C
ATOM     24  CD2 PHE     3      13.139  21.064  16.550  1.00  7.59           C
ATOM     25  CE1 PHE     3      12.649  22.227  19.047  1.00  7.59           C
ATOM     26  CE2 PHE     3      13.170  22.456  16.691  1.00  7.59           C
ATOM     27  CZ  PHE     3      12.926  23.037  17.939  1.00  7.59           C
ATOM     28  N   GLY     4      12.501  16.403  15.705  1.00  7.59           N
ATOM     29  CA  GLY     4      12.668  15.030  15.136  1.00  7.59           C
ATOM     30  C   GLY     4      13.921  14.283  15.641  1.00  7.59           C
ATOM     31  O   GLY     4      13.936  13.660  16.698  1.00  7.59           O
ATOM     32  N   ARG     5      14.968  14.310  14.852  1.00  7.59           N
ATOM     33  CA  ARG     5      16.228  13.647  15.220  1.00  7.59           C
ATOM     34  C   ARG     5      17.276  14.116  14.269  1.00  7.59           C
ATOM     35  O   ARG     5      18.312  13.477  14.083  1.00  7.59           O
ATOM     36  CB  ARG     5      16.088  12.122  15.136  1.00  7.59           C
ATOM     37  CG  ARG     5      16.244  11.569  13.713  1.00  7.59           C
ATOM     38  CD  ARG     5      17.201  10.369  13.616  1.00  7.59           C
ATOM     39  NE  ARG     5      18.497  10.606  14.272  1.00  7.59           N
ATOM     40  CZ  ARG     5      19.669  10.101  13.843  1.00  7.59           C
ATOM     41  NH1 ARG     5      19.735   9.327  12.752  1.00  7.59           N
ATOM     42  NH2 ARG     5      20.846  10.315  14.452  1.00  7.59           N
ATOM     43  N   CYS     6      16.951  15.226  13.708  1.00  7.59           N
ATOM     44  CA  CYS     6      17.784  15.830  12.724  1.00  7.59           C
ATOM     45  C   CYS     6      17.604  17.328  12.820  1.00  7.59           C
ATOM     46  O   CYS     6      18.550  18.085  12.570  1.00  7.59           O
ATOM     47  CB  CYS     6      17.387  15.237  11.381  1.00  7.59           C
ATOM     48  SG  CYS     6      16.811  13.463  11.529  1.00  7.59           S
ATOM     49  N   GLU     7      16.380  17.698  13.181  1.00  7.59           N
ATOM     50  CA  GLU     7      16.025  19.104  13.422  1.00  7.59           C
ATOM     51  C   GLU     7      16.788  19.566  14.650  1.00  7.59           C
ATOM     52  O   GLU     7      17.483  20.605  14.594  1.00  7.59           O
ATOM     53  CB  GLU     7      14.535  19.272  13.776  1.00  7.59           C
ATOM     54  CG  GLU     7      13.544  18.630  12.807  1.00  7.59           C
ATOM     55  CD  GLU     7      12.088  18.818  13.269  1.00  7.59           C
ATOM     56  OE1 GLU     7      11.834  19.462  14.361  1.00  7.59           O
ATOM     57  OE2 GLU     7      11.117  18.334  12.571  1.00  7.59           O
ATOM     58  N   LEU     8      16.572  18.709  15.657  1.00  7.59           N
ATOM     59  CA  LEU     8      17.145  18.779  17.024  1.00  7.59           C
ATOM     60  C   LEU     8      18.668  18.726  16.953  1.00  7.59           C
ATOM     61  O   LEU     8      19.368  19.479  17.644  1.00  7.59           O
ATOM     62  CB  LEU     8      16.705  17.554  17.868  1.00  7.59           C
ATOM     63  CG  LEU     8      15.223  17.552  18.290  1.00  7.59           C
ATOM     64  CD1 LEU     8      14.857  16.367  19.199  1.00  7.59           C
ATOM     65  CD2 LEU     8      14.811  18.800  19.073  1.00  7.59           C
ATOM     66  N   ALA     9      19.135  17.819  16.116  1.00  7.59           N
ATOM     67  CA  ALA     9      20.567  17.631  15.880  1.00  7.59           C
ATOM     68  C   ALA     9      21.162  18.944  15.369  1.00  7.59           C
ATOM     69  O   ALA     9      22.210  19.398  15.847  1.00  7.59           O
ATOM     70  CB  ALA     9      20.789  16.537  14.833  1.00  7.59           C
ATOM     71  N   ALA    10      20.449  19.510  14.415  1.00  7.59           N
ATOM     72  CA  ALA    10      20.834  20.769  13.762  1.00  7.59           C
ATOM     73  C   ALA    10      20.856  21.924  14.768  1.00  7.59           C
ATOM     74  O   ALA    10      21.863  22.632  14.907  1.00  7.59           O
ATOM     75  CB  ALA    10      19.834  21.113  12.657  1.00  7.59           C
ATOM     76  N   ALA    11      19.737  22.077  15.445  1.00  7.59           N
ATOM     77  CA  ALA    11      19.533  23.156  16.424  1.00  7.59           C
ATOM     78  C   ALA    11      20.550  23.089  17.577  1.00  7.59           C
ATOM     79  O   ALA    11      21.064  24.117  18.037  1.00  7.59           O
ATOM     80  CB  ALA    11      18.128  23.068  17.022  1.00  7.59           C
ATOM     81  N   MET    12      20.843  21.881  18.046  1.00  7.59           N
ATOM     82  CA  MET    12      21.769  21.707  19.192  1.00  7.59           C
ATOM     83  C   MET    12      23.241  21.570  18.791  1.00  7.59           C
ATOM     84  O   MET    12      24.050  21.008  19.535  1.00  7.59           O
ATOM     85  CB  MET    12      21.510  20.433  19.987  1.00  7.59           C
ATOM     86  CG  MET    12      20.040  20.153  20.255  1.00  7.59           C
ATOM     87  SD  MET    12      19.771  19.276  21.782  1.00  7.59           S
ATOM     88  CE  MET    12      20.267  20.295  23.154  1.00  7.59           C
ATOM     89  N   LYS    13      23.599  22.042  17.628  1.00  7.59           N
ATOM     90  CA  LYS    13      25.018  22.041  17.228  1.00  7.59           C
ATOM     91  C   LYS    13      25.402  23.470  16.924  1.00  7.59           C
ATOM     92  O   LYS    13      26.528  23.899  17.216  1.00  7.59           O
ATOM     93  CB  LYS    13      25.279  21.185  15.985  1.00  7.59           C
ATOM     94  CG  LYS    13      26.738  21.303  15.511  1.00  7.59           C
ATOM     95  CD  LYS    13      27.030  20.558  14.205  1.00  7.59           C
ATOM     96  CE  LYS    13      28.459  20.786  13.693  1.00  7.59           C
ATOM     97  NZ  LYS    13      28.754  20.042  12.460  1.00  7.59           N
ATOM     98  N   ARG    14      24.409  24.112  16.362  1.00  7.59           N
ATOM     99  CA  ARG    14      24.453  25.507  15.943  1.00  7.59           C
ATOM    100  C   ARG    14      24.579  26.423  17.163  1.00  7.59           C
ATOM    101  O   ARG    14      25.252  27.462  17.114  1.00  7.59           O
ATOM    102  CB  ARG    14      23.161  25.834  15.192  1.00  7.59           C
ATOM    103  CG  ARG    14      23.090  27.276  14.694  1.00  7.59           C
ATOM    104  CD  ARG    14      21.790  27.573  13.941  1.00  7.59           C
ATOM    105  NE  ARG    14      21.699  28.962  13.471  1.00  7.59           N
ATOM    106  CZ  ARG    14      21.986  30.030  14.228  1.00  7.59           C
ATOM    107  NH1 ARG    14      22.389  29.887  15.498  1.00  7.59           N
ATOM    108  NH2 ARG    14      21.900  31.297  13.800  1.00  7.59           N
ATOM    109  N   HIS    15      23.925  26.009  18.236  1.00  7.59           N
ATOM    110  CA  HIS    15      23.902  26.773  19.497  1.00  7.59           C
ATOM    111  C   HIS    15      25.091  26.402  20.384  1.00  7.59           C
ATOM    112  O   HIS    15      24.947  26.239  21.606  1.00  7.59           O
ATOM    113  CB  HIS    15      22.606  26.497  20.250  1.00  7.59           C
ATOM    114  CG  HIS    15      21.375  26.945  19.465  1.00  7.59           C
ATOM    115  ND1 HIS    15      20.689  26.076  18.625  1.00  7.59           N
ATOM    116  CD2 HIS    15      20.732  28.138  19.392  1.00  7.59           C
ATOM    117  CE1 HIS    15      19.684  26.740  18.085  1.00  7.59           C
ATOM    118  NE2 HIS    15      19.695  27.971  18.532  1.00  7.59           N
ATOM    119  N   GLY    16      26.224  26.288  19.722  1.00  7.59           N
ATOM    120  CA  GLY    16      27.515  25.976  20.356  1.00  7.59           C
ATOM    121  C   GLY    16      27.351  24.947  21.474  1.00  7.59           C
ATOM    122  O   GLY    16      27.322  25.300  22.665  1.00  7.59           O
ATOM    123  N   LEU    17      27.265  23.710  21.041  1.00  7.59           N
ATOM    124  CA  LEU    17      27.120  22.558  21.931  1.00  7.59           C
ATOM    125  C   LEU    17      28.061  21.426  21.513  1.00  7.59           C
ATOM    126  O   LEU    17      28.844  20.916  22.326  1.00  7.59           O
ATOM    127  CB  LEU    17      25.710  21.960  21.825  1.00  7.59           C
ATOM    128  CG  LEU    17      24.719  22.460  22.883  1.00  7.59           C
ATOM    129  CD1 LEU    17      23.432  21.625  22.930  1.00  7.59           C
ATOM    130  CD2 LEU    17      25.276  22.433  24.305  1.00  7.59           C
ATOM    131  N   ASP    18      27.948  21.090  20.238  1.00  7.59           N
ATOM    132  CA  ASP    18      28.620  19.915  19.657  1.00  7.59           C
ATOM    133  C   ASP    18      30.052  19.676  20.134  1.00  7.59           C
ATOM    134  O   ASP    18      30.978  20.434  19.781  1.00  7.59           O
ATOM    135  CB  ASP    18      28.709  19.928  18.148  1.00  7.59           C
ATOM    136  CG  ASP    18      29.092  18.527  17.681  1.00  7.59           C
ATOM    137  OD1 ASP    18      29.745  17.749  18.487  1.00  7.59           O
ATOM    138  OD2 ASP    18      28.761  18.116  16.513  1.00  7.59           O
ATOM    139  N   ASN    19      30.098  18.577  20.881  1.00  7.59           N
ATOM    140  CA  ASN    19      31.297  18.002  21.508  1.00  7.59           C
ATOM    141  C   ASN    19      31.640  18.793  22.759  1.00  7.59           C
ATOM    142  O   ASN    19      32.793  18.795  23.212  1.00  7.59           O
ATOM    143  CB  ASN    19      32.453  18.014  20.518  1.00  7.59           C
ATOM    144  CG  ASN    19      32.303  16.937  19.444  1.00  7.59           C
ATOM    145  OD1 ASN    19      31.526  15.998  19.619  1.00  7.59           O
ATOM    146  ND2 ASN    19      33.002  17.014  18.330  1.00  7.59           N
ATOM    147  N   TYR    20      30.598  19.414  23.259  1.00  7.59           N
ATOM    148  CA  TYR    20      30.660  20.291  24.426  1.00  7.59           C
ATOM    149  C   TYR    20      31.021  19.531  25.710  1.00  7.59           C
ATOM    150  O   TYR    20      30.638  18.363  25.891  1.00  7.59           O
ATOM    151  CB  TYR    20      29.320  20.964  24.643  1.00  7.59           C
ATOM    152  CG  TYR    20      29.353  21.867  25.857  1.00  7.59           C
ATOM    153  CD1 TYR    20      29.745  23.199  25.718  1.00  7.59           C
ATOM    154  CD2 TYR    20      29.005  21.348  27.102  1.00  7.59           C
ATOM    155  CE1 TYR    20      29.786  24.026  26.840  1.00  7.59           C
ATOM    156  CE2 TYR    20      29.046  22.175  28.226  1.00  7.59           C
ATOM    157  CZ  TYR    20      29.436  23.515  28.095  1.00  7.59           C
ATOM    158  OH  TYR    20      29.474  24.317  29.189  1.00  7.59           O
ATOM    159  N   ARG    21      31.741  20.279  26.537  1.00  7.59           N
ATOM    160  CA  ARG    21      32.270  19.842  27.840  1.00  7.59           C
ATOM    161  C   ARG    21      32.600  18.353  27.808  1.00  7.59           C
ATOM    162  O   ARG    21      32.448  17.641  28.814  1.00  7.59           O
ATOM    163  CB  ARG    21      31.274  20.136  28.965  1.00  7.59           C
ATOM    164  CG  ARG    21      31.894  20.941  30.124  1.00  7.59           C
ATOM    165  CD  ARG    21      33.402  21.194  29.957  1.00  7.59           C
ATOM    166  NE  ARG    21      33.952  22.148  30.944  1.00  7.59           N
ATOM    167  CZ  ARG    21      33.855  22.000  32.276  1.00  7.59           C
ATOM    168  NH1 ARG    21      33.225  20.944  32.809  1.00  7.59           N
ATOM    169  NH2 ARG    21      34.359  22.865  33.169  1.00  7.59           N
ATOM    170  N   GLY    22      33.041  17.933  26.636  1.00  7.59           N
ATOM    171  CA  GLY    22      33.508  16.564  26.419  1.00  7.59           C
ATOM    172  C   GLY    22      32.548  15.704  25.582  1.00  7.59           C
ATOM    173  O   GLY    22      32.973  14.811  24.838  1.00  7.59           O
ATOM    174  N   TYR    23      31.357  16.113  25.408  1.00  7.59           N
ATOM    175  CA  TYR    23      30.281  15.256  24.978  1.00  7.59           C
ATOM    176  C   TYR    23      29.693  15.575  23.645  1.00  7.59           C
ATOM    177  O   TYR    23      29.373  16.716  23.359  1.00  7.59           O
ATOM    178  CB  TYR    23      29.200  15.235  25.934  1.00  7.59           C
ATOM    179  CG  TYR    23      29.546  15.136  27.383  1.00  7.59           C
ATOM    180  CD1 TYR    23      29.801  16.191  28.049  1.00  7.59           C
ATOM    181  CD2 TYR    23      29.610  13.984  28.037  1.00  7.59           C
ATOM    182  CE1 TYR    23      30.107  16.101  29.373  1.00  7.59           C
ATOM    183  CE2 TYR    23      29.913  13.894  29.364  1.00  7.59           C
ATOM    184  CZ  TYR    23      30.159  14.953  30.032  1.00  7.59           C
ATOM    185  OH  TYR    23      30.446  14.864  31.324  1.00  7.59           O
ATOM    186  N   SER    24      29.590  14.485  22.945  1.00  7.59           N
ATOM    187  CA  SER    24      29.115  14.395  21.586  1.00  7.59           C
ATOM    188  C   SER    24      27.635  14.670  21.436  1.00  7.59           C
ATOM    189  O   SER    24      26.845  14.409  22.356  1.00  7.59           O
ATOM    190  CB  SER    24      29.342  13.017  21.056  1.00  7.59           C
ATOM    191  OG  SER    24      28.951  12.294  20.706  1.00  7.59           O
ATOM    192  N   LEU    25      27.391  15.182  20.251  1.00  7.59           N
ATOM    193  CA  LEU    25      26.080  15.561  19.751  1.00  7.59           C
ATOM    194  C   LEU    25      25.282  14.385  19.635  1.00  7.59           C
ATOM    195  O   LEU    25      24.805  14.419  19.301  1.00  7.59           O
ATOM    196  CB  LEU    25      26.184  16.216  18.462  1.00  7.59           C
ATOM    197  CG  LEU    25      24.968  16.904  17.913  1.00  7.59           C
ATOM    198  CD1 LEU    25      25.007  18.139  17.926  1.00  7.59           C
ATOM    199  CD2 LEU    25      24.727  16.648  16.737  1.00  7.59           C
ATOM    200  N   GLY    26      25.184  13.422  19.943  1.00  7.59           N
ATOM    201  CA  GLY    26      24.454  12.192  20.057  1.00  7.59           C
ATOM    202  C   GLY    26      24.190  12.092  21.516  1.00  7.59           C
ATOM    203  O   GLY    26      23.136  11.743  21.904  1.00  7.59           O
ATOM    204  N   ASN    27      25.190  12.446  22.234  1.00  7.59           N
ATOM    205  CA  ASN    27      25.179  12.555  23.664  1.00  7.59           C
ATOM    206  C   ASN    27      24.305  13.749  24.005  1.00  7.59           C
ATOM    207  O   ASN    27      24.239  14.188  25.152  1.00  7.59           O
ATOM    208  CB  ASN    27      26.597  12.756  24.175  1.00  7.59           C
ATOM    209  CG  ASN    27      27.309  11.481  24.546  1.00  7.59           C
ATOM    210  OD1 ASN    27      26.734  10.632  25.196  1.00  7.59           O
ATOM    211  ND2 ASN    27      28.535  11.292  24.166  1.00  7.59           N
ATOM    212  N   TRP    28      23.646  14.249  22.971  1.00  7.59           N
ATOM    213  CA  TRP    28      22.743  15.395  23.106  1.00  7.59           C
ATOM    214  C   TRP    28      21.520  15.229  22.193  1.00  7.59           C
ATOM    215  O   TRP    28      20.541  15.977  22.290  1.00  7.59           O
ATOM    216  CB  TRP    28      23.501  16.688  22.806  1.00  7.59           C
ATOM    217  CG  TRP    28      24.528  17.012  23.881  1.00  7.59           C
ATOM    218  CD1 TRP    28      25.798  16.768  23.861  1.00  7.59           C
ATOM    219  CD2 TRP    28      24.285  17.628  25.098  1.00  7.59           C
ATOM    220  NE1 TRP    28      26.366  17.230  25.076  1.00  7.59           N
ATOM    221  CE2 TRP    28      25.463  17.732  25.786  1.00  7.59           C
ATOM    222  CE3 TRP    28      23.171  18.107  25.668  1.00  7.59           C
ATOM    223  CZ2 TRP    28      25.601  18.292  27.034  1.00  7.59           C
ATOM    224  CZ3 TRP    28      23.320  18.670  26.926  1.00  7.59           C
ATOM    225  CH2 TRP    28      24.478  18.759  27.574  1.00  7.59           C
ATOM    226  N   VAL    29      21.589  14.240  21.316  1.00  7.59           N
ATOM    227  CA  VAL    29      20.467  13.928  20.418  1.00  7.59           C
ATOM    228  C   VAL    29      19.730  12.690  20.936  1.00  7.59           C
ATOM    229  O   VAL    29      18.580  12.432  20.580  1.00  7.59           O
ATOM    230  CB  VAL    29      20.960  13.671  18.993  1.00  7.59           C
ATOM    231  CG1 VAL    29      19.826  13.316  18.022  1.00  7.59           C
ATOM    232  CG2 VAL    29      21.660  14.883  18.374  1.00  7.59           C
ATOM    233  N   CYS    30      20.419  11.949  21.784  1.00  7.59           N
ATOM    234  CA  CYS    30      19.872  10.723  22.387  1.00  7.59           C
ATOM    235  C   CYS    30      19.310  11.013  23.744  1.00  7.59           C
ATOM    236  O   CYS    30      18.486  10.422  24.147  1.00  7.59           O
ATOM    237  CB  CYS    30      20.926   9.652  22.536  1.00  7.59           C
ATOM    238  SG  CYS    30      20.299   8.030  23.121  1.00  7.59           S
ATOM    239  N   ALA    31      19.749  11.920  24.433  1.00  7.59           N
ATOM    240  CA  ALA    31      19.286  12.315  25.724  1.00  7.59           C
ATOM    241  C   ALA    31      18.038  13.144  25.600  1.00  7.59           C
ATOM    242  O   ALA    31      17.446  13.449  26.282  1.00  7.59           O
ATOM    243  CB  ALA    31      20.309  13.151  26.409  1.00  7.59           C
ATOM    244  N   ALA    32      17.656  13.496  24.729  1.00  7.59           N
ATOM    245  CA  ALA    32      16.516  14.335  24.497  1.00  7.59           C
ATOM    246  C   ALA    32      15.255  13.537  24.161  1.00  7.59           C
ATOM    247  O   ALA    32      14.170  13.813  24.572  1.00  7.59           O
ATOM    248  CB  ALA    32      16.810  15.259  23.395  1.00  7.59           C
ATOM    249  N   LYS    33      15.414  12.567  23.413  1.00  7.59           N
ATOM    250  CA  LYS    33      14.298  11.698  23.030  1.00  7.59           C
ATOM    251  C   LYS    33      13.778  10.980  24.265  1.00  7.59           C
ATOM    252  O   LYS    33      12.582  10.707  24.385  1.00  7.59           O
ATOM    253  CB  LYS    33      14.751  10.655  22.010  1.00  7.59           C
ATOM    254  CG  LYS    33      13.642   9.655  21.656  1.00  7.59           C
ATOM    255  CD  LYS    33      13.329   9.375  20.688  1.00  7.59           C
ATOM    256  CE  LYS    33      12.192   8.594  20.123  1.00  7.59           C
ATOM    257  NZ  LYS    33      11.923   8.397  19.095  1.00  7.59           N
ATOM    258  N   PHE    34      14.715  10.709  25.144  1.00  7.59           N
ATOM    259  CA  PHE    34      14.442  10.012  26.396  1.00  7.59           C
ATOM    260  C   PHE    34      13.830  10.983  27.418  1.00  7.59           C
ATOM    261  O   PHE    34      13.177  10.599  28.315  1.00  7.59           O
ATOM    262  CB  PHE    34      15.734   9.379  26.916  1.00  7.59           C
ATOM    263  CG  PHE    34      16.088   8.086  26.168  1.00  7.59           C
ATOM    264  CD1 PHE    34      16.948   8.111  25.077  1.00  7.59           C
ATOM    265  CD2 PHE    34      15.549   6.874  26.565  1.00  7.59           C
ATOM    266  CE1 PHE    34      17.261   6.930  24.389  1.00  7.59           C
ATOM    267  CE2 PHE    34      15.863   5.696  25.878  1.00  7.59           C
ATOM    268  CZ  PHE    34      16.719   5.724  24.790  1.00  7.59           C
ATOM    269  N   GLU    35      14.029  12.248  27.292  1.00  7.59           N
ATOM    270  CA  GLU    35      13.450  13.249  28.203  1.00  7.59           C
ATOM    271  C   GLU    35      12.128  13.751  27.618  1.00  7.59           C
ATOM    272  O   GLU    35      11.246  13.024  27.395  1.00  7.59           O
ATOM    273  CB  GLU    35      14.417  14.413  28.414  1.00  7.59           C
ATOM    274  CG  GLU    35      15.606  14.052  29.305  1.00  7.59           C
ATOM    275  CD  GLU    35      15.915  14.527  30.221  1.00  7.59           C
ATOM    276  OE1 GLU    35      15.201  15.367  30.323  1.00  7.59           O
ATOM    277  OE2 GLU    35      16.892  14.087  30.894  1.00  7.59           O
ATOM    278  N   SER    36      12.030  14.990  27.376  1.00  7.59           N
ATOM    279  CA  SER    36      10.829  15.638  26.828  1.00  7.59           C
ATOM    280  C   SER    36      10.333  14.922  25.582  1.00  7.59           C
ATOM    281  O   SER    36       9.374  15.300  25.028  1.00  7.59           O
ATOM    282  CB  SER    36      11.118  17.077  26.472  1.00  7.59           C
ATOM    283  OG  SER    36      11.438  17.319  26.573  1.00  7.59           O
ATOM    284  N   ASN    37      11.002  13.893  25.165  1.00  7.59           N
ATOM    285  CA  ASN    37      10.644  13.092  23.986  1.00  7.59           C
ATOM    286  C   ASN    37      10.891  13.859  22.728  1.00  7.59           C
ATOM    287  O   ASN    37      10.731  13.402  21.808  1.00  7.59           O
ATOM    288  CB  ASN    37       9.191  12.762  24.030  1.00  7.59           C
ATOM    289  CG  ASN    37       8.934  11.653  24.276  1.00  7.59           C
ATOM    290  OD1 ASN    37       9.554  10.940  23.765  1.00  7.59           O
ATOM    291  ND2 ASN    37       8.046  11.463  25.039  1.00  7.59           N
ATOM    292  N   PHE    38      11.271  15.009  22.735  1.00  7.59           N
ATOM    293  CA  PHE    38      11.539  15.907  21.626  1.00  7.59           C
ATOM    294  C   PHE    38      10.587  17.077  21.705  1.00  7.59           C
ATOM    295  O   PHE    38      10.528  17.910  20.802  1.00  7.59           O
ATOM    296  CB  PHE    38      11.338  15.161  20.312  1.00  7.59           C
ATOM    297  CG  PHE    38      12.461  14.202  20.026  1.00  7.59           C
ATOM    298  CD1 PHE    38      13.065  13.535  20.140  1.00  7.59           C
ATOM    299  CD2 PHE    38      12.888  14.000  19.659  1.00  7.59           C
ATOM    300  CE1 PHE    38      14.107  12.661  19.886  1.00  7.59           C
ATOM    301  CE2 PHE    38      13.928  13.126  19.405  1.00  7.59           C
ATOM    302  CZ  PHE    38      14.538  12.458  19.519  1.00  7.59           C
ATOM    303  N   ASN    39       9.871  17.092  22.804  1.00  7.59           N
ATOM    304  CA  ASN    39       8.883  18.126  23.075  1.00  7.59           C
ATOM    305  C   ASN    39       9.429  19.159  24.045  1.00  7.59           C
ATOM    306  O   ASN    39       9.757  18.823  25.186  1.00  7.59           O
ATOM    307  CB  ASN    39       7.631  17.512  23.612  1.00  7.59           C
ATOM    308  CG  ASN    39       6.815  17.051  22.612  1.00  7.59           C
ATOM    309  OD1 ASN    39       6.456  17.745  21.839  1.00  7.59           O
ATOM    310  ND2 ASN    39       6.504  15.912  22.575  1.00  7.59           N
ATOM    311  N   THR    40       9.682  20.200  23.417  1.00  7.59           N
ATOM    312  CA  THR    40      10.139  21.428  24.075  1.00  7.59           C
ATOM    313  C   THR    40       9.381  21.724  25.369  1.00  7.59           C
ATOM    314  O   THR    40       9.949  22.270  26.329  1.00  7.59           O
ATOM    315  CB  THR    40       9.899  22.584  23.108  1.00  7.59           C
ATOM    316  OG1 THR    40       8.500  22.801  22.957  1.00  7.59           O
ATOM    317  CG2 THR    40      10.462  22.309  21.709  1.00  7.59           C
ATOM    318  N   GLN    41       8.115  21.379  25.362  1.00  7.59           N
ATOM    319  CA  GLN    41       7.241  21.587  26.522  1.00  7.59           C
ATOM    320  C   GLN    41       7.426  20.448  27.515  1.00  7.59           C
ATOM    321  O   GLN    41       7.276  19.269  27.170  1.00  7.59           O
ATOM    322  CB  GLN    41       5.779  21.613  26.084  1.00  7.59           C
ATOM    323  CG  GLN    41       5.445  22.780  25.155  1.00  7.59           C
ATOM    324  CD  GLN    41       3.960  22.835  24.795  1.00  7.59           C
ATOM    325  OE1 GLN    41       3.169  22.063  25.337  1.00  7.59           O
ATOM    326  NE2 GLN    41       3.527  23.709  23.907  1.00  7.59           N
ATOM    327  N   ALA    42       7.752  20.830  28.730  1.00  7.59           N
ATOM    328  CA  ALA    42       7.959  19.875  29.820  1.00  7.59           C
ATOM    329  C   ALA    42       6.800  19.970  30.802  1.00  7.59           C
ATOM    330  O   ALA    42       5.704  20.437  30.454  1.00  7.59           O
ATOM    331  CB  ALA    42       9.265  20.188  30.550  1.00  7.59           C
ATOM    332  N   THR    43       7.076  19.524  32.006  1.00  7.59           N
ATOM    333  CA  THR    43       6.097  19.552  33.088  1.00  7.59           C
ATOM    334  C   THR    43       5.974  18.160  33.723  1.00  7.59           C
ATOM    335  O   THR    43       4.865  17.691  34.024  1.00  7.59           O
ATOM    336  CB  THR    43       4.756  20.035  32.529  1.00  7.59           C
ATOM    337  OG1 THR    43       4.333  19.188  31.472  1.00  7.59           O
ATOM    338  CG2 THR    43       4.830  21.460  31.962  1.00  7.59           C
ATOM    339  N   ASN    44       7.146  17.564  33.893  1.00  7.59           N
ATOM    340  CA  ASN    44       7.321  16.250  34.543  1.00  7.59           C
ATOM    341  C   ASN    44       7.656  16.505  36.026  1.00  7.59           C
ATOM    342  O   ASN    44       8.831  16.642  36.397  1.00  7.59           O
ATOM    343  CB  ASN    44       8.478  15.490  33.864  1.00  7.59           C
ATOM    344  CG  ASN    44       8.019  14.373  32.913  1.00  7.59           C
ATOM    345  OD1 ASN    44       7.076  13.648  33.223  1.00  7.59           O
ATOM    346  ND2 ASN    44       8.638  14.186  31.758  1.00  7.59           N
ATOM    347  N   ARG    45       6.595  16.572  36.833  1.00  7.59           N
ATOM    348  CA  ARG    45       6.683  16.891  38.286  1.00  7.59           C
ATOM    349  C   ARG    45       7.667  15.975  39.022  1.00  7.59           C
ATOM    350  O   ARG    45       8.557  15.366  38.412  1.00  7.59           O
ATOM    351  CB  ARG    45       5.313  16.769  38.973  1.00  7.59           C
ATOM    352  CG  ARG    45       4.701  18.139  39.307  1.00  7.59           C
ATOM    353  CD  ARG    45       4.112  18.251  40.727  1.00  7.59           C
ATOM    354  NE  ARG    45       3.281  19.462  40.887  1.00  7.59           N
ATOM    355  CZ  ARG    45       2.757  19.902  42.047  1.00  7.59           C
ATOM    356  NH1 ARG    45       2.959  19.248  43.197  1.00  7.59           N
ATOM    357  NH2 ARG    45       2.000  21.008  42.154  1.00  7.59           N
ATOM    358  N   ASN    46       7.466  15.922  40.334  1.00  7.59           N
ATOM    359  CA  ASN    46       8.321  15.140  41.239  1.00  7.59           C
ATOM    360  C   ASN    46       7.789  15.193  42.681  1.00  7.59           C
ATOM    361  O   ASN    46       7.207  16.200  43.112  1.00  7.59           O
ATOM    362  CB  ASN    46       9.735  15.722  41.217  1.00  7.59           C
ATOM    363  CG  ASN    46      10.649  15.035  40.203  1.00  7.59           C
ATOM    364  OD1 ASN    46      11.422  14.158  40.579  1.00  7.59           O
ATOM    365  ND2 ASN    46      10.610  15.384  38.931  1.00  7.59           N
ATOM    366  N   THR    47       8.028  14.087  43.373  1.00  7.59           N
ATOM    367  CA  THR    47       7.606  13.874  44.775  1.00  7.59           C
ATOM    368  C   THR    47       8.025  15.044  45.673  1.00  7.59           C
ATOM    369  O   THR    47       7.184  15.670  46.337  1.00  7.59           O
ATOM    370  CB  THR    47       8.261  12.610  45.334  1.00  7.59           C
ATOM    371  OG1 THR    47       9.676  12.753  45.328  1.00  7.59           O
ATOM    372  CG2 THR    47       7.928  11.354  44.527  1.00  7.59           C
ATOM    373  N   ASP    48       9.324  15.292  45.669  1.00  7.59           N
ATOM    374  CA  ASP    48       9.944  16.353  46.485  1.00  7.59           C
ATOM    375  C   ASP    48       9.210  17.680  46.287  1.00  7.59           C
ATOM    376  O   ASP    48       8.960  18.424  47.245  1.00  7.59           O
ATOM    377  CB  ASP    48      11.413  16.525  46.108  1.00  7.59           C
ATOM    378  CG  ASP    48      11.620  16.865  44.634  1.00  7.59           C
ATOM    379  OD1 ASP    48      10.601  17.009  43.858  1.00  7.59           O
ATOM    380  OD2 ASP    48      12.813  17.005  44.168  1.00  7.59           O
ATOM    381  N   GLY    49       8.884  17.972  45.044  1.00  7.59           N
ATOM    382  CA  GLY    49       8.128  19.189  44.728  1.00  7.59           C
ATOM    383  C   GLY    49       8.836  20.074  43.697  1.00  7.59           C
ATOM    384  O   GLY    49       8.418  21.206  43.428  1.00  7.59           O
ATOM    385  N   SER    50       9.908  19.584  43.126  1.00  7.59           N
ATOM    386  CA  SER    50      10.602  20.338  42.075  1.00  7.59           C
ATOM    387  C   SER    50      10.056  19.838  40.734  1.00  7.59           C
ATOM    388  O   SER    50      10.146  18.648  40.411  1.00  7.59           O
ATOM    389  CB  SER    50      12.116  20.140  42.210  1.00  7.59           C
ATOM    390  OG  SER    50      12.618  19.404  41.110  1.00  7.59           O
ATOM    391  N   THR    51       9.468  20.750  39.975  1.00  7.59           N
ATOM    392  CA  THR    51       8.854  20.403  38.677  1.00  7.59           C
ATOM    393  C   THR    51       9.961  19.945  37.705  1.00  7.59           C
ATOM    394  O   THR    51      10.684  18.987  37.954  1.00  7.59           O
ATOM    395  CB  THR    51       8.025  21.586  38.174  1.00  7.59           C
ATOM    396  OG1 THR    51       6.909  21.787  39.042  1.00  7.59           O
ATOM    397  CG2 THR    51       7.466  21.370  36.768  1.00  7.59           C
ATOM    398  N   ASP    52      10.120  20.602  36.573  1.00  7.59           N
ATOM    399  CA  ASP    52      11.192  20.208  35.612  1.00  7.59           C
ATOM    400  C   ASP    52      10.505  20.023  34.225  1.00  7.59           C
ATOM    401  O   ASP    52       9.792  19.014  34.014  1.00  7.59           O
ATOM    402  CB  ASP    52      12.048  19.096  36.307  1.00  7.59           C
ATOM    403  CG  ASP    52      11.702  17.621  36.065  1.00  7.59           C
ATOM    404  OD1 ASP    52      10.510  17.251  35.774  1.00  7.59           O
ATOM    405  OD2 ASP    52      12.648  16.733  36.169  1.00  7.59           O
ATOM    406  N   TYR    53      10.863  21.089  33.450  1.00  7.59           N
ATOM    407  CA  TYR    53      10.270  21.629  32.169  1.00  7.59           C
ATOM    408  C   TYR    53      11.031  21.485  30.891  1.00  7.59           C
ATOM    409  O   TYR    53      12.005  22.072  30.578  1.00  7.59           O
ATOM    410  CB  TYR    53      10.366  23.151  32.297  1.00  7.59           C
ATOM    411  CG  TYR    53       9.542  23.570  33.436  1.00  7.59           C
ATOM    412  CD1 TYR    53      10.067  23.612  34.736  1.00  7.59           C
ATOM    413  CD2 TYR    53       8.243  23.861  33.144  1.00  7.59           C
ATOM    414  CE1 TYR    53       9.201  23.915  35.788  1.00  7.59           C
ATOM    415  CE2 TYR    53       7.372  24.143  34.187  1.00  7.59           C
ATOM    416  CZ  TYR    53       7.846  24.163  35.510  1.00  7.59           C
ATOM    417  OH  TYR    53       6.974  24.412  36.516  1.00  7.59           O
ATOM    418  N   GLY    54      10.774  20.760  29.907  1.00  7.59           N
ATOM    419  CA  GLY    54      11.804  20.977  28.865  1.00  7.59           C
ATOM    420  C   GLY    54      12.536  19.702  28.546  1.00  7.59           C
ATOM    421  O   GLY    54      12.761  18.843  29.414  1.00  7.59           O
ATOM    422  N   ILE    55      12.844  19.671  27.279  1.00  7.59           N
ATOM    423  CA  ILE    55      13.426  18.525  26.599  1.00  7.59           C
ATOM    424  C   ILE    55      14.650  17.969  27.335  1.00  7.59           C
ATOM    425  O   ILE    55      14.904  16.725  27.288  1.00  7.59           O
ATOM    426  CB  ILE    55      13.830  18.937  25.182  1.00  7.59           C
ATOM    427  CG1 ILE    55      12.657  19.510  24.378  1.00  7.59           C
ATOM    428  CG2 ILE    55      14.375  17.776  24.351  1.00  7.59           C
ATOM    429  CD1 ILE    55      13.071  20.037  23.004  1.00  7.59           C
ATOM    430  N   LEU    56      15.233  19.327  28.280  1.00  7.59           N
ATOM    431  CA  LEU    56      16.456  18.859  28.938  1.00  7.59           C
ATOM    432  C   LEU    56      16.246  18.625  30.433  1.00  7.59           C
ATOM    433  O   LEU    56      17.219  18.297  31.084  1.00  7.59           O
ATOM    434  CB  LEU    56      17.595  19.846  28.712  1.00  7.59           C
ATOM    435  CG  LEU    56      18.220  19.723  27.397  1.00  7.59           C
ATOM    436  CD1 LEU    56      19.465  20.554  27.279  1.00  7.59           C
ATOM    437  CD2 LEU    56      18.572  18.301  27.046  1.00  7.59           C
ATOM    438  N   GLN    57      15.028  18.777  30.979  1.00  7.59           N
ATOM    439  CA  GLN    57      14.635  18.460  32.390  1.00  7.59           C
ATOM    440  C   GLN    57      15.522  19.216  33.381  1.00  7.59           C
ATOM    441  O   GLN    57      16.107  18.615  34.279  1.00  7.59           O
ATOM    442  CB  GLN    57      14.738  16.962  32.643  1.00  7.59           C
ATOM    443  CG  GLN    57      13.631  16.149  32.042  1.00  7.59           C
ATOM    444  CD  GLN    57      13.004  15.834  32.120  1.00  7.59           C
ATOM    445  OE1 GLN    57      13.039  15.790  33.059  1.00  7.59           O
ATOM    446  NE2 GLN    57      12.421  15.605  31.179  1.00  7.59           N
ATOM    447  N   ILE    58      15.708  20.334  33.458  1.00  7.59           N
ATOM    448  CA  ILE    58      16.296  21.449  34.129  1.00  7.59           C
ATOM    449  C   ILE    58      16.129  21.911  34.169  1.00  7.59           C
ATOM    450  O   ILE    58      15.350  22.711  34.084  1.00  7.59           O
ATOM    451  CB  ILE    58      16.944  22.051  34.283  1.00  7.59           C
ATOM    452  CG1 ILE    58      17.081  21.590  34.238  1.00  7.59           C
ATOM    453  CG2 ILE    58      17.614  23.240  34.912  1.00  7.59           C
ATOM    454  CD1 ILE    58      17.838  22.193  34.421  1.00  7.59           C
ATOM    455  N   ASN    59      16.134  21.231  36.527  1.00  7.59           N
ATOM    456  CA  ASN    59      15.558  21.103  37.874  1.00  7.59           C
ATOM    457  C   ASN    59      15.232  22.478  38.460  1.00  7.59           C
ATOM    458  O   ASN    59      16.012  23.349  38.298  1.00  7.59           O
ATOM    459  CB  ASN    59      16.537  20.388  38.791  1.00  7.59           C
ATOM    460  CG  ASN    59      16.854  18.984  38.311  1.00  7.59           C
ATOM    461  OD1 ASN    59      15.957  18.156  38.193  1.00  7.59           O
ATOM    462  ND2 ASN    59      18.091  18.663  38.022  1.00  7.59           N
ATOM    463  N   SER    60      14.163  22.645  39.121  1.00  7.59           N
ATOM    464  CA  SER    60      13.714  23.931  39.687  1.00  7.59           C
ATOM    465  C   SER    60      14.629  24.371  40.807  1.00  7.59           C
ATOM    466  O   SER    60      14.957  25.526  40.875  1.00  7.59           O
ATOM    467  CB  SER    60      12.307  23.810  40.243  1.00  7.59           C
ATOM    468  OG  SER    60      12.272  22.807  41.231  1.00  7.59           O
ATOM    469  N   ARG    61      15.002  23.487  41.663  1.00  7.59           N
ATOM    470  CA  ARG    61      15.832  23.773  42.832  1.00  7.59           C
ATOM    471  C   ARG    61      17.211  24.336  42.450  1.00  7.59           C
ATOM    472  O   ARG    61      17.962  24.739  43.340  1.00  7.59           O
ATOM    473  CB  ARG    61      16.112  22.488  43.605  1.00  7.59           C
ATOM    474  CG  ARG    61      15.392  22.368  44.903  1.00  7.59           C
ATOM    475  CD  ARG    61      15.927  21.226  45.714  1.00  7.59           C
ATOM    476  NE  ARG    61      15.842  21.333  47.128  1.00  7.59           N
ATOM    477  CZ  ARG    61      16.071  21.051  48.122  1.00  7.59           C
ATOM    478  NH1 ARG    61      16.408  20.647  47.870  1.00  7.59           N
ATOM    479  NH2 ARG    61      15.984  21.146  49.413  1.00  7.59           N
ATOM    480  N   TRP    62      17.554  24.375  41.144  1.00  7.59           N
ATOM    481  CA  TRP    62      18.920  24.802  40.765  1.00  7.59           C
ATOM    482  C   TRP    62      19.019  25.693  39.577  1.00  7.59           C
ATOM    483  O   TRP    62      19.721  26.719  39.610  1.00  7.59           O
ATOM    484  CB  TRP    62      19.735  23.616  40.589  1.00  7.59           C
ATOM    485  CG  TRP    62      19.424  22.436  41.489  1.00  7.59           C
ATOM    486  CD1 TRP    62      18.745  21.345  41.167  1.00  7.59           C
ATOM    487  CD2 TRP    62      19.810  22.316  42.836  1.00  7.59           C
ATOM    488  NE1 TRP    62      18.705  20.526  42.318  1.00  7.59           N
ATOM    489  CE2 TRP    62      19.335  21.112  43.285  1.00  7.59           C
ATOM    490  CE3 TRP    62      20.519  23.121  43.706  1.00  7.59           C
ATOM    491  CZ2 TRP    62      19.536  20.653  44.576  1.00  7.59           C
ATOM    492  CZ3 TRP    62      20.715  22.653  45.004  1.00  7.59           C
ATOM    493  CH2 TRP    62      20.245  21.476  45.416  1.00  7.59           C
ATOM    494  N   TRP    63      18.311  25.288  38.611  1.00  7.59           N
ATOM    495  CA  TRP    63      18.368  25.902  37.343  1.00  7.59           C
ATOM    496  C   TRP    63      17.220  26.841  37.095  1.00  7.59           C
ATOM    497  O   TRP    63      17.372  27.906  36.538  1.00  7.59           O
ATOM    498  CB  TRP    63      18.424  24.802  36.336  1.00  7.59           C
ATOM    499  CG  TRP    63      19.479  23.794  36.733  1.00  7.59           C
ATOM    500  CD1 TRP    63      19.320  22.479  36.895  1.00  7.59           C
ATOM    501  CD2 TRP    63      20.821  24.126  37.012  1.00  7.59           C
ATOM    502  NE1 TRP    63      20.591  21.960  37.279  1.00  7.59           N
ATOM    503  CE2 TRP    63      21.459  22.945  37.338  1.00  7.59           C
ATOM    504  CE3 TRP    63      21.550  25.320  37.006  1.00  7.59           C
ATOM    505  CZ2 TRP    63      22.813  22.882  37.663  1.00  7.59           C
ATOM    506  CZ3 TRP    63      22.914  25.245  37.332  1.00  7.59           C
ATOM    507  CH2 TRP    63      23.516  24.084  37.645  1.00  7.59           C
ATOM    508  N   CYS    64      16.023  26.536  37.464  1.00  7.59           N
ATOM    509  CA  CYS    64      15.031  27.498  37.052  1.00  7.59           C
ATOM    510  C   CYS    64      14.094  27.859  38.179  1.00  7.59           C
ATOM    511  O   CYS    64      13.967  27.132  39.140  1.00  7.59           O
ATOM    512  CB  CYS    64      14.228  26.917  35.919  1.00  7.59           C
ATOM    513  SG  CYS    64      12.598  27.264  35.783  1.00  7.59           S
ATOM    514  N   ASN    65      13.426  28.996  38.048  1.00  7.59           N
ATOM    515  CA  ASN    65      12.484  29.418  39.068  1.00  7.59           C
ATOM    516  C   ASN    65      11.139  29.370  38.658  1.00  7.59           C
ATOM    517  O   ASN    65      10.839  29.859  37.638  1.00  7.59           O
ATOM    518  CB  ASN    65      12.585  30.768  39.503  1.00  7.59           C
ATOM    519  CG  ASN    65      11.918  31.444  40.498  1.00  7.59           C
ATOM    520  OD1 ASN    65      11.156  31.623  40.447  1.00  7.59           O
ATOM    521  ND2 ASN    65      12.151  31.842  41.402  1.00  7.59           N
ATOM    522  N   ASP    66      10.389  28.815  39.491  1.00  7.59           N
ATOM    523  CA  ASP    66       9.057  28.586  39.197  1.00  7.59           C
ATOM    524  C   ASP    66       8.059  29.231  40.088  1.00  7.59           C
ATOM    525  O   ASP    66       6.912  29.137  39.806  1.00  7.59           O
ATOM    526  CB  ASP    66       8.735  27.133  39.233  1.00  7.59           C
ATOM    527  CG  ASP    66       9.433  26.325  40.279  1.00  7.59           C
ATOM    528  OD1 ASP    66       9.960  26.899  41.207  1.00  7.59           O
ATOM    529  OD2 ASP    66       9.485  25.056  40.230  1.00  7.59           O
ATOM    530  N   GLY    67       8.410  29.905  41.128  1.00  7.59           N
ATOM    531  CA  GLY    67       7.373  30.456  42.030  1.00  7.59           C
ATOM    532  C   GLY    67       6.890  29.480  42.929  1.00  7.59           C
ATOM    533  O   GLY    67       6.405  29.891  43.683  1.00  7.59           O
ATOM    534  N   ARG    68       7.065  28.196  42.840  1.00  7.59           N
ATOM    535  CA  ARG    68       6.548  27.149  43.639  1.00  7.59           C
ATOM    536  C   ARG    68       7.485  26.124  44.203  1.00  7.59           C
ATOM    537  O   ARG    68       7.072  25.317  44.852  1.00  7.59           O
ATOM    538  CB  ARG    68       5.730  26.292  42.864  1.00  7.59           C
ATOM    539  CG  ARG    68       4.869  26.049  42.086  1.00  7.59           C
ATOM    540  CD  ARG    68       4.132  24.958  41.511  1.00  7.59           C
ATOM    541  NE  ARG    68       3.540  24.998  40.233  1.00  7.59           N
ATOM    542  CZ  ARG    68       2.807  24.133  39.577  1.00  7.59           C
ATOM    543  NH1 ARG    68       2.564  23.150  40.060  1.00  7.59           N
ATOM    544  NH2 ARG    68       2.269  24.166  38.417  1.00  7.59           N
ATOM    545  N   THR    69       8.724  26.136  43.951  1.00  7.59           N
ATOM    546  CA  THR    69       9.723  25.175  44.385  1.00  7.59           C
ATOM    547  C   THR    69      10.778  25.939  45.197  1.00  7.59           C
ATOM    548  O   THR    69      11.779  26.384  44.606  1.00  7.59           O
ATOM    549  CB  THR    69      10.197  24.464  43.181  1.00  7.59           C
ATOM    550  OG1 THR    69      10.992  25.326  42.491  1.00  7.59           O
ATOM    551  CG2 THR    69       9.084  23.986  42.282  1.00  7.59           C
ATOM    552  N   PRO    70      10.411  26.012  46.486  1.00  7.59           N
ATOM    553  CA  PRO    70      11.008  26.816  47.573  1.00  7.59           C
ATOM    554  C   PRO    70      12.414  26.583  47.997  1.00  7.59           C
ATOM    555  O   PRO    70      13.009  27.468  48.615  1.00  7.59           O
ATOM    556  CB  PRO    70      10.151  26.542  48.770  1.00  7.59           C
ATOM    557  CG  PRO    70       9.074  25.561  48.345  1.00  7.59           C
ATOM    558  CD  PRO    70       9.255  25.221  46.910  1.00  7.59           C
ATOM    559  N   GLY    71      13.029  25.481  47.780  1.00  7.59           N
ATOM    560  CA  GLY    71      14.424  25.399  48.212  1.00  7.59           C
ATOM    561  C   GLY    71      15.289  25.951  47.158  1.00  7.59           C
ATOM    562  O   GLY    71      16.442  25.941  47.378  1.00  7.59           O
ATOM    563  N   SER    72      14.597  26.385  46.130  1.00  7.59           N
ATOM    564  CA  SER    72      15.053  26.968  44.853  1.00  7.59           C
ATOM    565  C   SER    72      15.957  28.196  44.992  1.00  7.59           C
ATOM    566  O   SER    72      15.572  29.233  45.507  1.00  7.59           O
ATOM    567  CB  SER    72      13.852  27.377  44.016  1.00  7.59           C
ATOM    568  OG  SER    72      13.183  28.298  44.438  1.00  7.59           O
ATOM    569  N   ARG    73      16.979  27.955  44.385  1.00  7.59           N
ATOM    570  CA  ARG    73      18.043  28.971  44.232  1.00  7.59           C
ATOM    571  C   ARG    73      18.334  29.271  42.823  1.00  7.59           C
ATOM    572  O   ARG    73      19.219  29.273  42.503  1.00  7.59           O
ATOM    573  CB  ARG    73      19.348  28.451  44.809  1.00  7.59           C
ATOM    574  CG  ARG    73      19.208  27.858  46.209  1.00  7.59           C
ATOM    575  CD  ARG    73      20.375  26.952  46.577  1.00  7.59           C
ATOM    576  NE  ARG    73      20.574  26.790  48.018  1.00  7.59           N
ATOM    577  CZ  ARG    73      21.215  25.886  48.622  1.00  7.59           C
ATOM    578  NH1 ARG    73      21.726  25.059  47.925  1.00  7.59           N
ATOM    579  NH2 ARG    73      21.398  25.730  49.937  1.00  7.59           N
ATOM    580  N   ASN    74      17.636  29.524  41.952  1.00  7.59           N
ATOM    581  CA  ASN    74      17.842  29.885  40.626  1.00  7.59           C
ATOM    582  C   ASN    74      19.287  30.049  40.191  1.00  7.59           C
ATOM    583  O   ASN    74      19.795  31.156  40.063  1.00  7.59           O
ATOM    584  CB  ASN    74      17.288  31.160  40.382  1.00  7.59           C
ATOM    585  CG  ASN    74      16.848  31.329  39.089  1.00  7.59           C
ATOM    586  OD1 ASN    74      16.765  30.506  38.637  1.00  7.59           O
ATOM    587  ND2 ASN    74      16.554  32.338  38.467  1.00  7.59           N
ATOM    588  N   LEU    75      19.981  28.995  39.915  1.00  7.59           N
ATOM    589  CA  LEU    75      21.354  29.194  39.491  1.00  7.59           C
ATOM    590  C   LEU    75      21.436  29.576  38.007  1.00  7.59           C
ATOM    591  O   LEU    75      22.418  29.879  37.505  1.00  7.59           O
ATOM    592  CB  LEU    75      22.184  27.998  39.842  1.00  7.59           C
ATOM    593  CG  LEU    75      22.411  27.926  41.279  1.00  7.59           C
ATOM    594  CD1 LEU    75      23.492  27.598  41.400  1.00  7.59           C
ATOM    595  CD2 LEU    75      22.257  28.927  42.096  1.00  7.59           C
ATOM    596  N   CYS    76      20.442  29.603  37.236  1.00  7.59           N
ATOM    597  CA  CYS    76      20.571  29.984  35.836  1.00  7.59           C
ATOM    598  C   CYS    76      19.933  31.345  35.583  1.00  7.59           C
ATOM    599  O   CYS    76      20.078  31.962  34.525  1.00  7.59           O
ATOM    600  CB  CYS    76      19.948  28.920  34.932  1.00  7.59           C
ATOM    601  SG  CYS    76      20.086  29.267  33.163  1.00  7.59           S
ATOM    602  N   ASN    77      19.228  31.803  36.403  1.00  7.59           N
ATOM    603  CA  ASN    77      18.520  33.105  36.509  1.00  7.59           C
ATOM    604  C   ASN    77      17.516  33.339  35.439  1.00  7.59           C
ATOM    605  O   ASN    77      17.539  34.312  34.704  1.00  7.59           O
ATOM    606  CB  ASN    77      19.438  34.287  36.357  1.00  7.59           C
ATOM    607  CG  ASN    77      19.402  35.149  37.560  1.00  7.59           C
ATOM    608  OD1 ASN    77      19.387  35.628  38.242  1.00  7.59           O
ATOM    609  ND2 ASN    77      19.367  35.366  37.875  1.00  7.59           N
ATOM    610  N   ILE    78      16.636  32.479  35.340  1.00  7.59           N
ATOM    611  CA  ILE    78      15.618  32.660  34.400  1.00  7.59           C
ATOM    612  C   ILE    78      14.308  32.212  34.937  1.00  7.59           C
ATOM    613  O   ILE    78      14.262  31.582  35.927  1.00  7.59           O
ATOM    614  CB  ILE    78      15.872  31.881  33.180  1.00  7.59           C
ATOM    615  CG1 ILE    78      15.822  32.194  32.238  1.00  7.59           C
ATOM    616  CG2 ILE    78      15.322  31.212  33.133  1.00  7.59           C
ATOM    617  CD1 ILE    78      16.030  31.379  31.060  1.00  7.59           C
ATOM    618  N   PRO    79      13.247  32.547  34.309  1.00  7.59           N
ATOM    619  CA  PRO    79      11.920  32.166  34.686  1.00  7.59           C
ATOM    620  C   PRO    79      11.627  30.748  34.571  1.00  7.59           C
ATOM    621  O   PRO    79      11.298  30.545  34.343  1.00  7.59           O
ATOM    622  CB  PRO    79      11.062  32.834  33.732  1.00  7.59           C
ATOM    623  CG  PRO    79      11.956  33.540  32.814  1.00  7.59           C
ATOM    624  CD  PRO    79      13.345  33.341  33.191  1.00  7.59           C
ATOM    625  N   CYS    80      11.704  29.677  34.657  1.00  7.59           N
ATOM    626  CA  CYS    80      11.570  28.304  34.393  1.00  7.59           C
ATOM    627  C   CYS    80      10.495  28.133  33.324  1.00  7.59           C
ATOM    628  O   CYS    80      10.468  27.149  32.659  1.00  7.59           O
ATOM    629  CB  CYS    80      11.218  27.672  35.634  1.00  7.59           C
ATOM    630  SG  CYS    80      12.227  27.565  37.044  1.00  7.59           S
ATOM    631  N   SER    81      10.029  29.236  33.072  1.00  7.59           N
ATOM    632  CA  SER    81       9.111  29.356  31.958  1.00  7.59           C
ATOM    633  C   SER    81       9.755  29.671  30.685  1.00  7.59           C
ATOM    634  O   SER    81       9.163  29.536  29.629  1.00  7.59           O
ATOM    635  CB  SER    81       8.035  30.322  32.221  1.00  7.59           C
ATOM    636  OG  SER    81       8.550  31.533  32.432  1.00  7.59           O
ATOM    637  N   ALA    82      10.784  29.939  30.691  1.00  7.59           N
ATOM    638  CA  ALA    82      11.596  30.363  29.594  1.00  7.59           C
ATOM    639  C   ALA    82      12.004  29.254  28.753  1.00  7.59           C
ATOM    640  O   ALA    82      12.199  29.483  27.730  1.00  7.59           O
ATOM    641  CB  ALA    82      12.787  31.067  30.021  1.00  7.59           C
ATOM    642  N   LEU    83      12.171  28.121  29.338  1.00  7.59           N
ATOM    643  CA  LEU    83      12.726  26.870  28.915  1.00  7.59           C
ATOM    644  C   LEU    83      11.685  25.872  28.378  1.00  7.59           C
ATOM    645  O   LEU    83      11.992  24.702  28.146  1.00  7.59           O
ATOM    646  CB  LEU    83      13.516  26.349  30.094  1.00  7.59           C
ATOM    647  CG  LEU    83      14.700  27.235  30.435  1.00  7.59           C
ATOM    648  CD1 LEU    83      15.637  26.626  31.443  1.00  7.59           C
ATOM    649  CD2 LEU    83      15.552  27.548  29.209  1.00  7.59           C
ATOM    650  N   LEU    84      10.460  26.392  27.876  1.00  7.59           N
ATOM    651  CA  LEU    84       9.354  25.615  27.272  1.00  7.59           C
ATOM    652  C   LEU    84       8.984  26.131  25.841  1.00  7.59           C
ATOM    653  O   LEU    84       8.216  25.545  25.108  1.00  7.59           O
ATOM    654  CB  LEU    84       8.127  25.705  28.162  1.00  7.59           C
ATOM    655  CG  LEU    84       8.121  24.858  29.368  1.00  7.59           C
ATOM    656  CD1 LEU    84       6.952  24.987  30.305  1.00  7.59           C
ATOM    657  CD2 LEU    84       8.181  23.507  29.018  1.00  7.59           C
ATOM    658  N   SER    85       9.612  27.225  25.821  1.00  7.59           N
ATOM    659  CA  SER    85       9.481  27.913  24.511  1.00  7.59           C
ATOM    660  C   SER    85      10.247  27.193  23.445  1.00  7.59           C
ATOM    661  O   SER    85      11.186  26.491  23.728  1.00  7.59           O
ATOM    662  CB  SER    85      10.127  29.272  24.621  1.00  7.59           C
ATOM    663  OG  SER    85      11.387  29.250  24.652  1.00  7.59           O
ATOM    664  N   SER    86       9.817  27.461  22.274  1.00  7.59           N
ATOM    665  CA  SER    86      10.262  26.823  21.058  1.00  7.59           C
ATOM    666  C   SER    86      11.810  26.823  20.810  1.00  7.59           C
ATOM    667  O   SER    86      12.369  25.890  20.215  1.00  7.59           O
ATOM    668  CB  SER    86       9.590  27.520  19.878  1.00  7.59           C
ATOM    669  OG  SER    86       9.089  26.897  19.079  1.00  7.59           O
ATOM    670  N   ASP    87      12.474  27.855  21.209  1.00  7.59           N
ATOM    671  CA  ASP    87      13.920  28.040  21.057  1.00  7.59           C
ATOM    672  C   ASP    87      14.627  27.710  22.292  1.00  7.59           C
ATOM    673  O   ASP    87      14.352  28.304  23.253  1.00  7.59           O
ATOM    674  CB  ASP    87      14.269  29.437  20.722  1.00  7.59           C
ATOM    675  CG  ASP    87      14.262  30.361  20.542  1.00  7.59           C
ATOM    676  OD1 ASP    87      13.886  30.047  20.801  1.00  7.59           O
ATOM    677  OD2 ASP    87      14.633  31.449  20.131  1.00  7.59           O
ATOM    678  N   ILE    88      15.146  26.937  21.645  1.00  7.59           N
ATOM    679  CA  ILE    88      15.763  26.243  22.783  1.00  7.59           C
ATOM    680  C   ILE    88      17.079  26.882  23.241  1.00  7.59           C
ATOM    681  O   ILE    88      18.007  26.191  23.684  1.00  7.59           O
ATOM    682  CB  ILE    88      16.039  24.813  22.353  1.00  7.59           C
ATOM    683  CG1 ILE    88      14.771  24.075  21.916  1.00  7.59           C
ATOM    684  CG2 ILE    88      16.656  23.964  23.465  1.00  7.59           C
ATOM    685  CD1 ILE    88      15.041  22.643  21.448  1.00  7.59           C
ATOM    686  N   THR    89      17.129  28.190  23.153  1.00  7.59           N
ATOM    687  CA  THR    89      18.329  28.965  23.513  1.00  7.59           C
ATOM    688  C   THR    89      18.698  28.830  25.011  1.00  7.59           C
ATOM    689  O   THR    89      19.864  28.589  25.360  1.00  7.59           O
ATOM    690  CB  THR    89      18.091  30.450  23.224  1.00  7.59           C
ATOM    691  OG1 THR    89      17.004  30.926  24.004  1.00  7.59           O
ATOM    692  CG2 THR    89      17.759  30.733  21.758  1.00  7.59           C
ATOM    693  N   ALA    90      17.687  28.990  25.859  1.00  7.59           N
ATOM    694  CA  ALA    90      17.836  29.019  27.345  1.00  7.59           C
ATOM    695  C   ALA    90      18.332  27.693  27.965  1.00  7.59           C
ATOM    696  O   ALA    90      18.988  27.691  29.025  1.00  7.59           O
ATOM    697  CB  ALA    90      16.490  29.331  28.002  1.00  7.59           C
ATOM    698  N   SER    91      18.006  26.590  27.314  1.00  7.59           N
ATOM    699  CA  SER    91      18.385  25.240  27.794  1.00  7.59           C
ATOM    700  C   SER    91      19.824  24.923  27.397  1.00  7.59           C
ATOM    701  O   SER    91      20.575  24.279  28.147  1.00  7.59           O
ATOM    702  CB  SER    91      17.451  24.184  27.211  1.00  7.59           C
ATOM    703  OG  SER    91      17.504  24.220  25.798  1.00  7.59           O
ATOM    704  N   VAL    92      20.186  25.360  26.207  1.00  7.59           N
ATOM    705  CA  VAL    92      21.565  25.230  25.758  1.00  7.59           C
ATOM    706  C   VAL    92      22.381  26.041  26.747  1.00  7.59           C
ATOM    707  O   VAL    92      23.473  25.626  27.164  1.00  7.59           O
ATOM    708  CB  VAL    92      21.723  25.788  24.341  1.00  7.59           C
ATOM    709  CG1 VAL    92      23.162  25.714  23.826  1.00  7.59           C
ATOM    710  CG2 VAL    92      20.874  25.050  23.305  1.00  7.59           C
ATOM    711  N   ASN    93      21.755  27.162  27.072  1.00  7.59           N
ATOM    712  CA  ASN    93      22.261  28.144  28.030  1.00  7.59           C
ATOM    713  C   ASN    93      22.422  27.479  29.394  1.00  7.59           C
ATOM    714  O   ASN    93      23.511  27.494  29.986  1.00  7.59           O
ATOM    715  CB  ASN    93      21.266  29.305  28.150  1.00  7.59           C
ATOM    716  CG  ASN    93      21.024  30.034  26.825  1.00  7.59           C
ATOM    717  OD1 ASN    93      21.960  30.586  26.249  1.00  7.59           O
ATOM    718  ND2 ASN    93      19.814  30.071  26.298  1.00  7.59           N
ATOM    719  N   CYS    94      21.313  26.919  29.857  1.00  7.59           N
ATOM    720  CA  CYS    94      21.274  26.199  31.121  1.00  7.59           C
ATOM    721  C   CYS    94      22.035  24.883  31.034  1.00  7.59           C
ATOM    722  O   CYS    94      22.797  24.511  31.925  1.00  7.59           O
ATOM    723  CB  CYS    94      19.827  25.945  31.546  1.00  7.59           C
ATOM    724  SG  CYS    94      18.888  27.442  31.937  1.00  7.59           S
ATOM    725  N   ALA    95      21.805  24.229  29.901  1.00  7.59           N
ATOM    726  CA  ALA    95      22.459  22.954  29.581  1.00  7.59           C
ATOM    727  C   ALA    95      23.967  23.102  29.773  1.00  7.59           C
ATOM    728  O   ALA    95      24.673  22.125  30.060  1.00  7.59           O
ATOM    729  CB  ALA    95      22.167  22.570  28.127  1.00  7.59           C
ATOM    730  N   LYS    96      24.389  24.341  29.608  1.00  7.59           N
ATOM    731  CA  LYS    96      25.793  24.750  29.741  1.00  7.59           C
ATOM    732  C   LYS    96      26.269  24.579  31.182  1.00  7.59           C
ATOM    733  O   LYS    96      27.017  23.640  31.496  1.00  7.59           O
ATOM    734  CB  LYS    96      25.933  26.237  29.397  1.00  7.59           C
ATOM    735  CG  LYS    96      26.704  26.488  28.103  1.00  7.59           C
ATOM    736  CD  LYS    96      26.330  25.508  26.992  1.00  7.59           C
ATOM    737  CE  LYS    96      26.184  26.178  25.627  1.00  7.59           C
ATOM    738  NZ  LYS    96      27.320  27.050  25.293  1.00  7.59           N
ATOM    739  N   LYS    97      25.795  25.518  31.973  1.00  7.59           N
ATOM    740  CA  LYS    97      26.114  25.647  33.400  1.00  7.59           C
ATOM    741  C   LYS    97      26.151  24.289  34.101  1.00  7.59           C
ATOM    742  O   LYS    97      27.036  24.018  34.922  1.00  7.59           O
ATOM    743  CB  LYS    97      25.072  26.533  34.083  1.00  7.59           C
ATOM    744  CG  LYS    97      25.225  28.006  33.698  1.00  7.59           C
ATOM    745  CD  LYS    97      24.521  28.962  34.659  1.00  7.59           C
ATOM    746  CE  LYS    97      24.633  30.423  34.220  1.00  7.59           C
ATOM    747  NZ  LYS    97      23.909  31.347  35.103  1.00  7.59           N
ATOM    748  N   ILE    98      25.195  23.443  33.782  1.00  7.59           N
ATOM    749  CA  ILE    98      25.129  22.119  34.409  1.00  7.59           C
ATOM    750  C   ILE    98      26.193  21.197  33.832  1.00  7.59           C
ATOM    751  O   ILE    98      26.779  20.369  34.532  1.00  7.59           O
ATOM    752  CB  ILE    98      23.762  21.481  34.216  1.00  7.59           C
ATOM    753  CG1 ILE    98      22.651  22.266  34.908  1.00  7.59           C
ATOM    754  CG2 ILE    98      23.692  20.059  34.786  1.00  7.59           C
ATOM    755  CD1 ILE    98      21.303  21.549  34.873  1.00  7.59           C
ATOM    756  N   VAL    99      26.444  21.333  32.556  1.00  7.59           N
ATOM    757  CA  VAL    99      27.459  20.499  31.922  1.00  7.59           C
ATOM    758  C   VAL    99      28.853  20.901  32.422  1.00  7.59           C
ATOM    759  O   VAL    99      29.867  20.318  32.026  1.00  7.59           O
ATOM    760  CB  VAL    99      27.430  20.665  30.400  1.00  7.59           C
ATOM    761  CG1 VAL    99      28.651  20.046  29.713  1.00  7.59           C
ATOM    762  CG2 VAL    99      26.213  20.006  29.744  1.00  7.59           C
ATOM    763  N   SER   100      28.902  21.890  33.313  1.00  7.59           N
ATOM    764  CA  SER   100      30.203  22.419  33.781  1.00  7.59           C
ATOM    765  C   SER   100      30.307  22.594  35.301  1.00  7.59           C
ATOM    766  O   SER   100      31.265  23.200  35.814  1.00  7.59           O
ATOM    767  CB  SER   100      30.449  23.798  33.173  1.00  7.59           C
ATOM    768  OG  SER   100      29.333  24.182  32.382  1.00  7.59           O
ATOM    769  N   ASP   101      29.353  22.070  36.023  1.00  7.59           N
ATOM    770  CA  ASP   101      29.374  22.198  37.477  1.00  7.59           C
ATOM    771  C   ASP   101      30.181  21.030  38.083  1.00  7.59           C
ATOM    772  O   ASP   101      31.188  21.209  38.763  1.00  7.59           O
ATOM    773  CB  ASP   101      27.951  22.337  37.981  1.00  7.59           C
ATOM    774  CG  ASP   101      27.206  23.447  37.224  1.00  7.59           C
ATOM    775  OD1 ASP   101      27.703  24.640  37.153  1.00  7.59           O
ATOM    776  OD2 ASP   101      26.089  23.185  36.639  1.00  7.59           O
ATOM    777  N   GLY   102      29.822  19.769  37.874  1.00  7.59           N
ATOM    778  CA  GLY   102      30.666  18.725  38.503  1.00  7.59           C
ATOM    779  C   GLY   102      30.265  17.297  38.167  1.00  7.59           C
ATOM    780  O   GLY   102      31.118  16.393  38.096  1.00  7.59           O
ATOM    781  N   ASN   103      28.984  17.096  37.990  1.00  7.59           N
ATOM    782  CA  ASN   103      28.483  15.764  37.680  1.00  7.59           C
ATOM    783  C   ASN   103      28.528  15.561  36.147  1.00  7.59           C
ATOM    784  O   ASN   103      29.115  14.621  35.637  1.00  7.59           O
ATOM    785  CB  ASN   103      27.148  15.542  38.384  1.00  7.59           C
ATOM    786  CG  ASN   103      27.383  14.991  39.807  1.00  7.59           C
ATOM    787  OD1 ASN   103      28.121  14.013  39.976  1.00  7.59           O
ATOM    788  ND2 ASN   103      26.818  15.565  40.852  1.00  7.59           N
ATOM    789  N   GLY   104      27.938  16.416  35.331  1.00  7.59           N
ATOM    790  CA  GLY   104      28.101  16.230  33.854  1.00  7.59           C
ATOM    791  C   GLY   104      26.916  15.493  33.207  1.00  7.59           C
ATOM    792  O   GLY   104      25.896  15.228  33.854  1.00  7.59           O
ATOM    793  N   MET   105      27.082  15.193  31.916  1.00  7.59           N
ATOM    794  CA  MET   105      26.026  14.547  31.113  1.00  7.59           C
ATOM    795  C   MET   105      25.268  13.553  32.003  1.00  7.59           C
ATOM    796  O   MET   105      24.143  13.133  31.670  1.00  7.59           O
ATOM    797  CB  MET   105      26.630  13.867  29.879  1.00  7.59           C
ATOM    798  CG  MET   105      27.428  14.833  28.985  1.00  7.59           C
ATOM    799  SD  MET   105      26.545  16.327  28.572  1.00  7.59           S
ATOM    800  CE  MET   105      25.245  15.972  27.407  1.00  7.59           C
ATOM    801  N   ASN   106      25.945  13.230  33.110  1.00  7.59           N
ATOM    802  CA  ASN   106      25.411  12.359  34.181  1.00  7.59           C
ATOM    803  C   ASN   106      25.234  13.207  35.432  1.00  7.59           C
ATOM    804  O   ASN   106      26.167  13.334  36.257  1.00  7.59           O
ATOM    805  CB  ASN   106      26.287  11.135  34.413  1.00  7.59           C
ATOM    806  CG  ASN   106      27.664  11.439  34.978  1.00  7.59           C
ATOM    807  OD1 ASN   106      28.002  12.598  35.185  1.00  7.59           O
ATOM    808  ND2 ASN   106      28.491  10.442  35.233  1.00  7.59           N
ATOM    809  N   ALA   107      24.042  13.669  35.367  1.00  7.59           N
ATOM    810  CA  ALA   107      23.359  14.582  36.231  1.00  7.59           C
ATOM    811  C   ALA   107      22.222  15.033  35.329  1.00  7.59           C
ATOM    812  O   ALA   107      21.997  16.246  35.172  1.00  7.59           O
ATOM    813  CB  ALA   107      24.306  15.702  36.658  1.00  7.59           C
ATOM    814  N   TRP   108      21.646  13.956  34.771  1.00  7.59           N
ATOM    815  CA  TRP   108      20.521  13.942  33.804  1.00  7.59           C
ATOM    816  C   TRP   108      19.676  12.634  33.982  1.00  7.59           C
ATOM    817  O   TRP   108      18.683  12.415  33.268  1.00  7.59           O
ATOM    818  CB  TRP   108      21.078  13.961  32.361  1.00  7.59           C
ATOM    819  CG  TRP   108      20.648  15.190  31.545  1.00  7.59           C
ATOM    820  CD1 TRP   108      19.507  15.348  30.858  1.00  7.59           C
ATOM    821  CD2 TRP   108      21.414  16.377  31.384  1.00  7.59           C
ATOM    822  NE1 TRP   108      19.534  16.660  30.285  1.00  7.59           N
ATOM    823  CE2 TRP   108      20.655  17.251  30.618  1.00  7.59           C
ATOM    824  CE3 TRP   108      22.669  16.784  31.843  1.00  7.59           C
ATOM    825  CZ2 TRP   108      21.073  18.549  30.300  1.00  7.59           C
ATOM    826  CZ3 TRP   108      23.089  18.088  31.507  1.00  7.59           C
ATOM    827  CH2 TRP   108      22.325  18.929  30.774  1.00  7.59           C
ATOM    828  N   VAL   109      20.116  11.813  34.953  1.00  7.59           N
ATOM    829  CA  VAL   109      19.535  10.467  35.317  1.00  7.59           C
ATOM    830  C   VAL   109      19.268   9.592  34.084  1.00  7.59           C
ATOM    831  O   VAL   109      19.679   8.421  34.029  1.00  7.59           O
ATOM    832  CB  VAL   109      18.197  10.552  36.077  1.00  7.59           C
ATOM    833  CG1 VAL   109      17.658   9.167  36.490  1.00  7.59           C
ATOM    834  CG2 VAL   109      18.285  11.345  37.380  1.00  7.59           C
ATOM    835  N   ALA   110      18.580  10.184  33.128  1.00  7.59           N
ATOM    836  CA  ALA   110      18.209   9.503  31.877  1.00  7.59           C
ATOM    837  C   ALA   110      19.433   9.311  30.978  1.00  7.59           C
ATOM    838  O   ALA   110      19.602   8.268  30.331  1.00  7.59           O
ATOM    839  CB  ALA   110      17.171  10.327  31.116  1.00  7.59           C
ATOM    840  N   TRP   111      20.279  10.324  30.937  1.00  7.59           N
ATOM    841  CA  TRP   111      21.497  10.252  30.122  1.00  7.59           C
ATOM    842  C   TRP   111      22.408   9.171  30.677  1.00  7.59           C
ATOM    843  O   TRP   111      22.914   8.316  29.938  1.00  7.59           O
ATOM    844  CB  TRP   111      22.267  11.568  30.131  1.00  7.59           C
ATOM    845  CG  TRP   111      23.539  11.489  29.280  1.00  7.59           C
ATOM    846  CD1 TRP   111      23.654  11.760  27.972  1.00  7.59           C
ATOM    847  CD2 TRP   111      24.819  11.098  29.756  1.00  7.59           C
ATOM    848  NE1 TRP   111      25.023  11.543  27.614  1.00  7.59           N
ATOM    849  CE2 TRP   111      25.689  11.156  28.675  1.00  7.59           C
ATOM    850  CE3 TRP   111      25.308  10.707  31.007  1.00  7.59           C
ATOM    851  CZ2 TRP   111      27.050  10.844  28.772  1.00  7.59           C
ATOM    852  CZ3 TRP   111      26.680  10.392  31.095  1.00  7.59           C
ATOM    853  CH2 TRP   111      27.509  10.459  30.029  1.00  7.59           C
ATOM    854  N   ARG   112      22.582   9.243  31.975  1.00  7.59           N
ATOM    855  CA  ARG   112      23.418   8.297  32.691  1.00  7.59           C
ATOM    856  C   ARG   112      22.863   6.889  32.558  1.00  7.59           C
ATOM    857  O   ARG   112      23.608   5.912  32.446  1.00  7.59           O
ATOM    858  CB  ARG   112      23.462   8.617  34.190  1.00  7.59           C
ATOM    859  CG  ARG   112      24.132   7.506  35.011  1.00  7.59           C
ATOM    860  CD  ARG   112      24.246   7.839  36.501  1.00  7.59           C
ATOM    861  NE  ARG   112      23.883   9.228  36.803  1.00  7.59           N
ATOM    862  CZ  ARG   112      23.829   9.739  38.039  1.00  7.59           C
ATOM    863  NH1 ARG   112      24.114   8.987  39.109  1.00  7.59           N
ATOM    864  NH2 ARG   112      23.497  11.009  38.309  1.00  7.59           N
ATOM    865  N   ASN   113      21.558   6.794  32.539  1.00  7.59           N
ATOM    866  CA  ASN   113      20.928   5.483  32.592  1.00  7.59           C
ATOM    867  C   ASN   113      20.767   4.767  31.258  1.00  7.59           C
ATOM    868  O   ASN   113      20.689   5.422  30.193  1.00  7.59           O
ATOM    869  CB  ASN   113      19.586   5.564  33.263  1.00  7.59           C
ATOM    870  CG  ASN   113      19.728   5.142  34.714  1.00  7.59           C
ATOM    871  OD1 ASN   113      20.609   4.338  35.028  1.00  7.59           O
ATOM    872  ND2 ASN   113      18.930   5.643  35.625  1.00  7.59           N
ATOM    873  N   ARG   114      20.259   5.545  30.112  1.00  7.59           N
ATOM    874  CA  ARG   114      19.889   5.135  28.754  1.00  7.59           C
ATOM    875  C   ARG   114      20.809   5.506  27.663  1.00  7.59           C
ATOM    876  O   ARG   114      20.647   4.978  26.562  1.00  7.59           O
ATOM    877  CB  ARG   114      18.524   5.820  28.470  1.00  7.59           C
ATOM    878  CG  ARG   114      17.622   5.591  29.700  1.00  7.59           C
ATOM    879  CD  ARG   114      16.120   5.571  29.514  1.00  7.59           C
ATOM    880  NE  ARG   114      15.538   4.773  28.422  1.00  7.59           N
ATOM    881  CZ  ARG   114      14.272   4.987  28.087  1.00  7.59           C
ATOM    882  NH1 ARG   114      13.588   5.934  28.760  1.00  7.59           N
ATOM    883  NH2 ARG   114      13.676   4.312  27.124  1.00  7.59           N
ATOM    884  N   CYS   115      21.731   6.434  27.948  1.00  7.59           N
ATOM    885  CA  CYS   115      22.611   6.927  26.912  1.00  7.59           C
ATOM    886  C   CYS   115      24.038   6.546  27.121  1.00  7.59           C
ATOM    887  O   CYS   115      24.761   6.124  26.167  1.00  7.59           O
ATOM    888  CB  CYS   115      22.512   8.456  26.779  1.00  7.59           C
ATOM    889  SG  CYS   115      20.831   8.880  26.337  1.00  7.59           S
ATOM    890  N   LYS   116      24.448   6.818  28.370  1.00  7.59           N
ATOM    891  CA  LYS   116      25.788   6.594  28.786  1.00  7.59           C
ATOM    892  C   LYS   116      26.255   5.204  28.388  1.00  7.59           C
ATOM    893  O   LYS   116      25.561   4.220  28.674  1.00  7.59           O
ATOM    894  CB  LYS   116      25.945   6.826  30.286  1.00  7.59           C
ATOM    895  CG  LYS   116      27.391   6.777  30.761  1.00  7.59           C
ATOM    896  CD  LYS   116      27.435   7.045  32.288  1.00  7.59           C
ATOM    897  CE  LYS   116      28.837   7.224  32.895  1.00  7.59           C
ATOM    898  NZ  LYS   116      28.779   7.665  34.314  1.00  7.59           N
ATOM    899  N   GLY   117      27.430   5.166  27.679  1.00  7.59           N
ATOM    900  CA  GLY   117      28.050   3.899  27.271  1.00  7.59           C
ATOM    901  C   GLY   117      27.341   3.164  26.137  1.00  7.59           C
ATOM    902  O   GLY   117      27.555   2.000  25.926  1.00  7.59           O
ATOM    903  N   THR   118      26.477   3.832  25.410  1.00  7.59           N
ATOM    904  CA  THR   118      25.783   3.220  24.282  1.00  7.59           C
ATOM    905  C   THR   118      26.362   3.862  23.017  1.00  7.59           C
ATOM    906  O   THR   118      27.127   4.818  23.143  1.00  7.59           O
ATOM    907  CB  THR   118      24.263   3.406  24.402  1.00  7.59           C
ATOM    908  OG1 THR   118      23.938   4.736  24.070  1.00  7.59           O
ATOM    909  CG2 THR   118      23.757   3.044  25.817  1.00  7.59           C
ATOM    910  N   ASP   119      26.048   3.362  21.818  1.00  7.59           N
ATOM    911  CA  ASP   119      26.569   3.988  20.588  1.00  7.59           C
ATOM    912  C   ASP   119      25.702   5.204  20.282  1.00  7.59           C
ATOM    913  O   ASP   119      24.770   5.173  19.449  1.00  7.59           O
ATOM    914  CB  ASP   119      26.546   3.030  19.395  1.00  7.59           C
ATOM    915  CG  ASP   119      26.801   3.738  18.095  1.00  7.59           C
ATOM    916  OD1 ASP   119      27.402   4.796  18.022  1.00  7.59           O
ATOM    917  OD2 ASP   119      26.273   3.118  17.069  1.00  7.59           O
ATOM    918  N   VAL   120      26.011   6.285  21.001  1.00  7.59           N
ATOM    919  CA  VAL   120      25.220   7.527  20.892  1.00  7.59           C
ATOM    920  C   VAL   120      25.316   8.183  19.531  1.00  7.59           C
ATOM    921  O   VAL   120      24.491   9.072  19.160  1.00  7.59           O
ATOM    922  CB  VAL   120      25.478   8.534  22.044  1.00  7.59           C
ATOM    923  CG1 VAL   120      25.154   7.923  23.430  1.00  7.59           C
ATOM    924  CG2 VAL   120      26.928   8.957  21.975  1.00  7.59           C
ATOM    925  N   GLN   121      26.334   7.762  18.773  1.00  7.59           N
ATOM    926  CA  GLN   121      26.510   8.321  17.437  1.00  7.59           C
ATOM    927  C   GLN   121      25.321   7.977  16.553  1.00  7.59           C
ATOM    928  O   GLN   121      25.052   8.653  15.553  1.00  7.59           O
ATOM    929  CB  GLN   121      27.719   7.642  16.827  1.00  7.59           C
ATOM    930  CG  GLN   121      28.877   8.586  16.806  1.00  7.59           C
ATOM    931  CD  GLN   121      29.539   8.430  15.489  1.00  7.59           C
ATOM    932  OE1 GLN   121      29.167   9.113  14.526  1.00  7.59           O
ATOM    933  NE2 GLN   121      30.458   7.464  15.430  1.00  7.59           N
ATOM    934  N   ALA   122      24.622   6.905  16.935  1.00  7.59           N
ATOM    935  CA  ALA   122      23.427   6.482  16.199  1.00  7.59           C
ATOM    936  C   ALA   122      22.384   7.595  16.097  1.00  7.59           C
ATOM    937  O   ALA   122      21.607   7.709  15.136  1.00  7.59           O
ATOM    938  CB  ALA   122      22.810   5.285  16.892  1.00  7.59           C
ATOM    939  N   TRP   123      22.359   8.432  17.127  1.00  7.59           N
ATOM    940  CA  TRP   123      21.393   9.528  17.218  1.00  7.59           C
ATOM    941  C   TRP   123      21.553  10.621  16.174  1.00  7.59           C
ATOM    942  O   TRP   123      20.605  11.371  15.868  1.00  7.59           O
ATOM    943  CB  TRP   123      21.268  10.072  18.669  1.00  7.59           C
ATOM    944  CG  TRP   123      20.703   9.027  19.570  1.00  7.59           C
ATOM    945  CD1 TRP   123      21.373   8.205  20.411  1.00  7.59           C
ATOM    946  CD2 TRP   123      19.315   8.706  19.690  1.00  7.59           C
ATOM    947  NE1 TRP   123      20.478   7.367  21.043  1.00  7.59           N
ATOM    948  CE2 TRP   123      19.223   7.644  20.594  1.00  7.59           C
ATOM    949  CE3 TRP   123      18.185   9.218  19.077  1.00  7.59           C
ATOM    950  CZ2 TRP   123      17.979   7.100  20.931  1.00  7.59           C
ATOM    951  CZ3 TRP   123      16.968   8.661  19.367  1.00  7.59           C
ATOM    952  CH2 TRP   123      16.866   7.616  20.286  1.00  7.59           C
ATOM    953  N   ILE   124      22.729  10.746  15.614  1.00  7.59           N
ATOM    954  CA  ILE   124      22.875  11.773  14.587  1.00  7.59           C
ATOM    955  C   ILE   124      23.074  11.184  13.177  1.00  7.59           C
ATOM    956  O   ILE   124      23.303  11.891  12.208  1.00  7.59           O
ATOM    957  CB  ILE   124      23.953  12.766  14.964  1.00  7.59           C
ATOM    958  CG1 ILE   124      25.198  11.964  15.324  1.00  7.59           C
ATOM    959  CG2 ILE   124      23.483  13.522  16.222  1.00  7.59           C
ATOM    960  CD1 ILE   124      26.509  12.617  14.845  1.00  7.59           C
ATOM    961  N   ARG   125      23.017   9.859  13.097  1.00  7.59           N
ATOM    962  CA  ARG   125      23.154   9.162  11.829  1.00  7.59           C
ATOM    963  C   ARG   125      22.072   9.595  10.864  1.00  7.59           C
ATOM    964  O   ARG   125      20.886   9.734  11.227  1.00  7.59           O
ATOM    965  CB  ARG   125      23.215   7.658  11.995  1.00  7.59           C
ATOM    966  CG  ARG   125      23.182   6.839  10.712  1.00  7.59           C
ATOM    967  CD  ARG   125      23.563   5.374  10.966  1.00  7.59           C
ATOM    968  NE  ARG   125      22.735   4.867  12.058  1.00  7.59           N
ATOM    969  CZ  ARG   125      21.435   4.602  11.902  1.00  7.59           C
ATOM    970  NH1 ARG   125      20.840   4.736  10.715  1.00  7.59           N
ATOM    971  NH2 ARG   125      20.716   4.182  12.948  1.00  7.59           N
ATOM    972  N   GLY   126      22.558   9.888   9.625  1.00  7.59           N
ATOM    973  CA  GLY   126      21.769  10.304   8.464  1.00  7.59           C
ATOM    974  C   GLY   126      21.435  11.750   8.447  1.00  7.59           C
ATOM    975  O   GLY   126      20.730  12.208   7.555  1.00  7.59           O
ATOM    976  N   CYS   127      21.911  12.484   9.459  1.00  7.59           N
ATOM    977  CA  CYS   127      21.537  13.870   9.473  1.00  7.59           C
ATOM    978  C   CYS   127      22.472  14.743   8.656  1.00  7.59           C
ATOM    979  O   CYS   127      23.713  14.559   8.603  1.00  7.59           O
ATOM    980  CB  CYS   127      21.384  14.487  10.907  1.00  7.59           C
ATOM    981  SG  CYS   127      20.334  13.515  11.983  1.00  7.59           S
ATOM    982  N   ARG   128      21.879  15.755   8.055  1.00  7.59           N
ATOM    983  CA  ARG   128      22.717  16.669   7.327  1.00  7.59           C
ATOM    984  C   ARG   128      23.279  17.684   8.284  1.00  7.59           C
ATOM    985  O   ARG   128      22.578  18.621   8.661  1.00  7.59           O
ATOM    986  CB  ARG   128      21.956  17.415   6.245  1.00  7.59           C
ATOM    987  CG  ARG   128      22.900  18.275   5.419  1.00  7.59           C
ATOM    988  CD  ARG   128      22.275  18.562   4.063  1.00  7.59           C
ATOM    989  NE  ARG   128      20.799  18.559   4.127  1.00  7.59           N
ATOM    990  CZ  ARG   128      19.912  18.143   3.182  1.00  7.59           C
ATOM    991  NH1 ARG   128      20.267  17.616   2.000  1.00  7.59           N
ATOM    992  NH2 ARG   128      18.606  18.264   3.443  1.00  7.59           N
ATOM    993  N   LEU   129      24.503  17.501   8.709  1.00  7.59           N
ATOM    994  CA  LEU   129      25.067  18.491   9.631  1.00  7.59           C
ATOM    995  C   LEU   129      26.363  19.028   9.072  1.00  7.59           C
ATOM    996  O   LEU   129      26.851  18.378   8.098  1.00  7.59           O
ATOM    997  CB  LEU   129      25.334  18.005  11.070  1.00  7.59           C
ATOM    998  CG  LEU   129      24.151  17.331  11.805  1.00  7.59           C
ATOM    999  CD1 LEU   129      24.715  16.261  12.759  1.00  7.59           C
ATOM   1000  CD2 LEU   129      23.399  18.364  12.610  1.00  7.59           C
TER
END
"""

def write_ccp4_map(cg, file_name, mc=None, map_data=None):
  assert [mc, map_data].count(None)==1
  if(map_data is None):
    map_data = get_map(mc=mc, cg=cg)
  from iotbx import mrcfile
  mrcfile.write_ccp4_map(
      file_name=file_name,
      unit_cell=cg.unit_cell(),
      space_group=cg.space_group(),
      #gridding_first=(0,0,0),# This causes a bug (map gets shifted)
      #gridding_last=n_real,  # This causes a bug (map gets shifted)
      map_data=map_data,
      labels=flex.std_string([""]))

def common_inputs(k_sols, for_test):
  pdb_inp = iotbx.pdb.input(source_info=None, lines = pdb_str)
  xrs = pdb_inp.xray_structure_simple()
  sgt = xrs.space_group().type()
  fc  = xrs.structure_factors(d_min=4).f_calc()
  #
  mm = mosaic.mosaic_f_mask(
    f_obs          = abs(fc),
    #f_calc         = fc,
    xray_structure = xrs,
    step           = 0.5,
    volume_cutoff  = 6)
  # Make Fobs
  f_bulk_data = flex.complex_double(fc.data().size())
  for f_mask, k_sol in zip(mm.FV.keys(), k_sols):
    f_bulk_data += f_mask.data() * k_sol
  f_obs = fc.customized_copy(data = flex.abs(fc.data()+f_bulk_data))
  i_obs = f_obs.customized_copy(data = f_obs.data()*f_obs.data())
  return group_args(mm=mm, f_obs=f_obs, i_obs=i_obs, fc=fc)

def run2():
  def rfactor(x,y):
    n = flex.sum(flex.abs(x-y))
    d = flex.sum(flex.abs(x+y))
    if(d!=0): return n/d
    else:     return None
  for it in range(1):
    k_sols = flex.random_double(6)
    answer = flex.double([1,])
    answer.extend(k_sols)
    inp = common_inputs(k_sols=k_sols, for_test=False)
    x = flex.double([1,])
    x.extend(flex.random_double(6))
    result1 = mosaic.algorithm_2(
      i_obs          = inp.i_obs,
      F              = [inp.fc]+inp.mm.FV.keys(),
      x              = x.deep_copy(),
      use_curvatures = True)
    result2 = mosaic.algorithm_2(
      i_obs          = inp.i_obs,
      F              = [inp.fc]+inp.mm.FV.keys(),
      x              = x.deep_copy(),
      use_curvatures = False)
    print (rfactor(answer, result1), rfactor(answer, result2))

def run():
  k_sols = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6]
  inp = common_inputs(k_sols=k_sols, for_test=True)
  mm, f_obs, i_obs, fc = inp.mm, inp.f_obs, inp.i_obs, inp.fc
  # Initial k_sols for finite differences test and minimization (algorithm_2)
  x = flex.double([1,  .01,.01,.01, .01,.01,.01])
  # Finite differences test
  g_anal = mosaic.tg(i_obs = i_obs, F=[fc]+mm.FV.keys(), x=x, use_curvatures=False).gradients()
  e=1.e-6
  g_fd = flex.double()
  for i in [0,1,2,3,4,5,6]:
    x_ = x[:]
    x_[i] = x_[i]+e
    t1 = mosaic.tg(i_obs = i_obs, F=[fc]+mm.FV.keys(), x=x_, use_curvatures=False).target()
    x_ = x[:]
    x_[i] = x_[i]-e
    t2 = mosaic.tg(i_obs = i_obs, F=[fc]+mm.FV.keys(), x=x_, use_curvatures=False).target()
    g_fd.append( (t1-t2)/(2*e) )
  assert flex.sum(flex.abs(g_anal-g_fd))*2/flex.sum(flex.abs(g_anal+g_fd))<1.e-9
  #
  for use_cpp in [True, False]:
    r = mosaic.algorithm_4(
      f_obs             = f_obs,
      phase_source      = fc,
      F                 = [fc]+inp.mm.FV.keys(),
      auto_converge_eps = 1.e-9,
      use_cpp           = use_cpp)
    assert approx_equal(r, [1,]+k_sols)
  #
  r = mosaic.algorithm_3(
    i_obs = i_obs,
    fc = fc,
    f_masks = mm.FV.keys()
    )
  assert approx_equal(r, [1,]+k_sols)
  #
  r = mosaic.algorithm_2(
    i_obs = i_obs,
    F = [fc]+inp.mm.FV.keys(),
    x = flex.double(x))
  assert approx_equal(r, [1,]+k_sols)
  #
  r = mosaic.algorithm_2(
    i_obs = i_obs,
    F = [fc]+inp.mm.FV.keys(),
    x = flex.double(x),
    use_curvatures = False,
    macro_cycles=100)
  assert approx_equal(r, [1,]+k_sols, 1.e-3)


if (__name__ == "__main__"):
  t0 = time.time()
  run()
  print ("Total time: %-8.4f"%(time.time()-t0))
  print ("OK")
