# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _casadi
else:
    import _casadi

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

CASADI_INT_TYPE_STR = _casadi.CASADI_INT_TYPE_STR


import contextlib

class _copyableObject(object):
  def __copy__(self):
    return self.__class__(self)

  def __deepcopy__(self,dummy=None):
    return self.__class__(self)

_object = object = _copyableObject

_swig_repr_default = _swig_repr
def _swig_repr(self):
  if hasattr(self,'repr'):
    return self.repr()
  else:
    return _swig_repr_default(self)

def DM_from_array(m, check_only=True):
  import numpy as np
  if isinstance(m, np.ndarray):
    if len(m.shape)>2:
      return False
    try:
      m = m.astype(float,casting="same_kind",copy=False)
    except:
      return False
    if check_only:
      return True
    else:
      shape = m.shape + (1, 1)
      nrow, ncol = shape[0], shape[1]
      return (nrow,ncol,m.flat)
  return False

def IM_from_array(m, check_only=True):
  import numpy as np
  if isinstance(m, np.ndarray):
    if len(m.shape)>2:
      return False
    try:
      m = m.astype(int,casting="same_kind",copy=False)
    except:
      return False
    if check_only:
      return True
    else:
      shape = m.shape + (1, 1)
      nrow, ncol = shape[0], shape[1]
      return (nrow,ncol,m.flat)
  return False

def SX_from_array(m, check_only=True):
  import numpy as np
  if isinstance(m, np.ndarray):
    if len(m.shape)>2:
      return False
    if m.dtype!=np.object: return None
    shape = m.shape + (1, 1)
    nrow, ncol = shape[0], shape[1]
    return (nrow,ncol,m.flat)
  return False

def DM_from_csc(m, check_only=True):
  if hasattr(m,"tocsc"):
    m = m.tocsc()
  if m.__class__.__name__ == "csc_matrix":
    if len(m.shape)!=2: return False
    if check_only: return True
    return m.shape + (m.indptr.flat,m.indices.flat,m.data.flat)
  return False


MNAME = _casadi.MNAME

class SwigPyIterator(object):
    r"""Proxy of C++ swig::SwigPyIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _casadi.delete_SwigPyIterator

    def value(self, *args) -> "PyObject *":
        r"""value(SwigPyIterator self) -> PyObject *"""
        return _casadi.SwigPyIterator_value(self, *args)

    def incr(self, *args) -> "swig::SwigPyIterator *":
        r"""incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _casadi.SwigPyIterator_incr(self, *args)

    def decr(self, *args) -> "swig::SwigPyIterator *":
        r"""decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _casadi.SwigPyIterator_decr(self, *args)

    def distance(self, *args) -> "ptrdiff_t":
        r"""distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _casadi.SwigPyIterator_distance(self, *args)

    def equal(self, *args) -> "bool":
        r"""equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _casadi.SwigPyIterator_equal(self, *args)

    def copy(self, *args) -> "swig::SwigPyIterator *":
        r"""copy(SwigPyIterator self) -> SwigPyIterator"""
        return _casadi.SwigPyIterator_copy(self, *args)

    def next(self, *args) -> "PyObject *":
        r"""next(SwigPyIterator self) -> PyObject *"""
        return _casadi.SwigPyIterator_next(self, *args)

    def __next__(self, *args) -> "PyObject *":
        r"""__next__(SwigPyIterator self) -> PyObject *"""
        return _casadi.SwigPyIterator___next__(self, *args)

    def previous(self, *args) -> "PyObject *":
        r"""previous(SwigPyIterator self) -> PyObject *"""
        return _casadi.SwigPyIterator_previous(self, *args)

    def advance(self, *args) -> "swig::SwigPyIterator *":
        r"""advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _casadi.SwigPyIterator_advance(self, *args)

    def __eq__(self, *args) -> "bool":
        r"""__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _casadi.SwigPyIterator___eq__(self, *args)

    def __ne__(self, *args) -> "bool":
        r"""__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _casadi.SwigPyIterator___ne__(self, *args)

    def __iadd__(self, *args) -> "swig::SwigPyIterator &":
        r"""__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _casadi.SwigPyIterator___iadd__(self, *args)

    def __isub__(self, *args) -> "swig::SwigPyIterator &":
        r"""__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _casadi.SwigPyIterator___isub__(self, *args)

    def __add__(self, *args) -> "swig::SwigPyIterator *":
        r"""__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _casadi.SwigPyIterator___add__(self, *args)

    def __sub__(self, *args) -> "ptrdiff_t":
        r"""
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _casadi.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _casadi:
_casadi.SwigPyIterator_swigregister(SwigPyIterator)

L_INT = _casadi.L_INT

L_BOOL = _casadi.L_BOOL

LL = _casadi.LL

LR = _casadi.LR

L_DICT = _casadi.L_DICT

L_DOUBLE = _casadi.L_DOUBLE

L_STR = _casadi.L_STR

LABEL = _casadi.LABEL


if __name__ != "casadi.casadi":
  raise Exception("""
            CasADi is not running from its package context.

            You probably specified the wrong casadi directory.

            When setting PYTHONPATH or sys.path.append,
            take care not to add a trailing '/casadi'.

        """)

def swigtypeconvertor(*args):
  return swig_typename_convertor_python2cpp(args)

def swig_typename_convertor_python2cpp(a):
  try:
    import numpy as np
  except:
    class NoExist:
      pass
    class Temp(object):
      ndarray = NoExist
    np = Temp()
  if isinstance(a,list):
    if len(a)>0:
      return "[%s]" % "|".join(set([swig_typename_convertor_python2cpp(i) for i in a]))
    else:
      return "[]"
  elif isinstance(a,tuple):
    return "(%s)" % ",".join([swig_typename_convertor_python2cpp(i) for i in a])
  elif isinstance(a,np.ndarray):
    return "np.array(%s)" % ",".join(set([swig_typename_convertor_python2cpp(i) for i in np.array(a).flatten().tolist()]))
  elif isinstance(a,dict):
    if len(a)>0:
      return "|".join(set([swig_typename_convertor_python2cpp(i) for i in a.keys()])) +":"+ "|".join(set([swig_typename_convertor_python2cpp(i) for i in a.values()]))
    else:
      return "dict"
  return type(a).__name__


try:
  from numpy import pi, inf
except:
  pass

arcsin = lambda x: _casadi.asin(x)
arccos = lambda x: _casadi.acos(x)
arctan = lambda x: _casadi.atan(x)
arctan2 = lambda x,y: _casadi.atan2(x, y)
arctanh = lambda x: _casadi.atanh(x)
arcsinh = lambda x: _casadi.asinh(x)
arccosh = lambda x: _casadi.acosh(x)


def veccat(*args): return _veccat(args)
def vertcat(*args): return _vertcat(args)
def horzcat(*args): return _horzcat(args)
def diagcat(*args): return _diagcat(args)
def vvcat(args): return _veccat(args)
def vcat(args): return _vertcat(args)
def hcat(args): return _horzcat(args)
def dcat(args): return _diagcat(args)


class NZproxy:
  def __init__(self,matrix):
    self.matrix = matrix

  def __getitem__(self,s):
    return self.matrix.get_nz(False, s)

  def __setitem__(self,s,val):
    return self.matrix.set_nz(val, False, s)

  def __len__(self):
    return self.matrix.nnz()

  def __iter__(self):
    for i in range(len(self)):
      yield self[i]


class PrintableCommon(object):
    r"""Proxy of C++ casadi::PrintableCommon class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __str__(self): return self.str()
    def repr(self): return self.type_name() + '(' + self.str() + ')'


    def __init__(self, *args):
        r"""
        __init__(PrintableCommon self) -> PrintableCommon
        __init__(PrintableCommon self, PrintableCommon other) -> PrintableCommon
        """
        _casadi.PrintableCommon_swiginit(self, _casadi.new_PrintableCommon(*args))
    __swig_destroy__ = _casadi.delete_PrintableCommon

# Register PrintableCommon in _casadi:
_casadi.PrintableCommon_swigregister(PrintableCommon)

class SharedObject(object):
    r"""


    SharedObject implements a reference counting framework similar for efficient
    and easily-maintained memory management.

    To use the class, both the SharedObject class (the public class), and the
    SharedObjectInternal class (the internal class) must be inherited from. It
    can be done in two different files and together with memory management, this
    approach provides a clear distinction of which methods of the class are to
    be considered "public", i.e. methods for public use that can be considered
    to remain over time with small changes, and the internal memory.

    When interfacing a software, which typically includes including some header
    file, this is best done only in the file where the internal class is
    defined, to avoid polluting the global namespace and other side effects.

    The default constructor always means creating a null pointer to an internal
    class only. To allocate an internal class (this works only when the internal
    class isn't abstract), use the constructor with arguments.

    The copy constructor and the assignment operator perform shallow copies
    only, to make a deep copy you must use the clone method explicitly. This
    will give a shared pointer instance.

    In an inheritance hierarchy, you can cast down automatically, e.g. (
    SXFunction is a child class of Function): SXFunction derived(...); Function
    base = derived;

    To cast up, use the shared_cast template function, which works analogously
    to dynamic_cast, static_cast, const_cast etc, e.g.: SXFunction derived(...);
    Function base = derived; SXFunction derived_from_base =
    shared_cast<SXFunction>(base);

    A failed shared_cast will result in a null pointer (cf. dynamic_cast)

    Joel Andersson

    C++ includes: shared_object.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def class_name(self, *args) -> "std::string":
        r"""
        class_name(SharedObject self) -> std::string


        Get class name.


        """
        return _casadi.SharedObject_class_name(self, *args)

    def disp(self, *args) -> "void":
        r"""
        disp(SharedObject self, bool more=False)


        Print a description of the object.


        """
        return _casadi.SharedObject_disp(self, *args)

    def str(self, *args) -> "std::string":
        r"""
        str(SharedObject self, bool more=False) -> std::string


        Get string representation.


        """
        return _casadi.SharedObject_str(self, *args)

    def print_ptr(self, *args) -> "void":
        r"""
        print_ptr(SharedObject self)


        [INTERNAL]  Print the pointer to the internal class


        """
        return _casadi.SharedObject_print_ptr(self, *args)

    def is_null(self, *args) -> "bool":
        r"""
        is_null(SharedObject self) -> bool


        Is a null pointer?


        """
        return _casadi.SharedObject_is_null(self, *args)

    def __hash__(self, *args) -> "casadi_int":
        r"""
        __hash__(SharedObject self) -> casadi_int


        Returns a number that is unique for a given Node. If the Object does not
        point to any node, "0" is returned.


        """
        return _casadi.SharedObject___hash__(self, *args)

    def __init__(self, *args):
        r"""
        __init__(SharedObject self) -> SharedObject
        __init__(SharedObject self, SharedObject other) -> SharedObject
        """
        _casadi.SharedObject_swiginit(self, _casadi.new_SharedObject(*args))
    __swig_destroy__ = _casadi.delete_SharedObject

# Register SharedObject in _casadi:
_casadi.SharedObject_swigregister(SharedObject)

class WeakRef(SharedObject):
    r"""


    Weak reference type A weak reference to a SharedObject.

    Joel Andersson

    C++ includes: shared_object.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def shared(self, *args) -> "casadi::SharedObject":
        r"""
        shared(WeakRef self) -> SharedObject


        Get a shared (owning) reference.


        """
        return _casadi.WeakRef_shared(self, *args)

    def alive(self, *args) -> "bool":
        r"""
        alive(WeakRef self) -> bool


        Check if alive.


        """
        return _casadi.WeakRef_alive(self, *args)

    def __init__(self, *args):
        r"""
        __init__(WeakRef self, int dummy=0) -> WeakRef
        __init__(WeakRef self, SharedObject shared) -> WeakRef
        __init__(WeakRef self, WeakRef other) -> WeakRef
        """
        _casadi.WeakRef_swiginit(self, _casadi.new_WeakRef(*args))
    __swig_destroy__ = _casadi.delete_WeakRef

# Register WeakRef in _casadi:
_casadi.WeakRef_swigregister(WeakRef)


def complement(*args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
    r"""
    complement(std::vector< casadi_int,std::allocator< casadi_int > > const & v, casadi_int size) -> std::vector< casadi_int,std::allocator< casadi_int > >


    Returns the list of all i in [0, size[ not found in supplied list.

    The supplied vector may contain duplicates and may be non-monotonous The
    supplied vector will be checked for bounds The result vector is guaranteed
    to be monotonously increasing


    """
    return _casadi.complement(*args)

def lookupvector(*args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
    r"""
    lookupvector(std::vector< casadi_int,std::allocator< casadi_int > > const & v, casadi_int size) -> std::vector< casadi_int,std::allocator< casadi_int > >
    lookupvector(std::vector< casadi_int,std::allocator< casadi_int > > const & v) -> std::vector< casadi_int,std::allocator< casadi_int > >
    """
    return _casadi.lookupvector(*args)

def temporary_file(*args) -> "std::string":
    r"""temporary_file(std::string const & prefix, std::string const & suffix) -> std::string"""
    return _casadi.temporary_file(*args)

def normalized_setup(*args) -> "void":
    r"""
    normalized_setup(std::istream & stream)
    normalized_setup()
    """
    return _casadi.normalized_setup(*args)

def normalized_out(*args) -> "void":
    r"""normalized_out(double val)"""
    return _casadi.normalized_out(*args)

def normalized_in(*args) -> "int":
    r"""normalized_in(std::istream & stream, double & ret) -> int"""
    return _casadi.normalized_in(*args)
SWIG_IND1 = _casadi.SWIG_IND1

class GenericType(PrintableCommon):
    r"""


    Generic data type, can hold different types such as bool, casadi_int, string
    etc.

    Joel Andersson

    C++ includes: generic_type.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def serialize(self, *args) -> "void":
        r"""
        serialize(GenericType self, casadi::SerializingStream & s)


        Serialize an object.


        """
        return _casadi.GenericType_serialize(self, *args)

    @staticmethod
    def deserialize(*args) -> "casadi::GenericType":
        r"""deserialize(casadi::DeserializingStream & s) -> GenericType"""
        return _casadi.GenericType_deserialize(*args)

    def __init__(self, *args):
        r"""
        __init__(GenericType self) -> GenericType
        __init__(GenericType self, GenericType other) -> GenericType
        """
        _casadi.GenericType_swiginit(self, _casadi.new_GenericType(*args))
    __swig_destroy__ = _casadi.delete_GenericType

# Register GenericType in _casadi:
_casadi.GenericType_swigregister(GenericType)

def GenericType_deserialize(*args) -> "casadi::GenericType":
    r"""GenericType_deserialize(casadi::DeserializingStream & s) -> GenericType"""
    return _casadi.GenericType_deserialize(*args)

OP_ASSIGN = _casadi.OP_ASSIGN

OP_ADD = _casadi.OP_ADD

OP_SUB = _casadi.OP_SUB

OP_MUL = _casadi.OP_MUL

OP_DIV = _casadi.OP_DIV

OP_NEG = _casadi.OP_NEG

OP_EXP = _casadi.OP_EXP

OP_LOG = _casadi.OP_LOG

OP_POW = _casadi.OP_POW

OP_CONSTPOW = _casadi.OP_CONSTPOW

OP_SQRT = _casadi.OP_SQRT

OP_SQ = _casadi.OP_SQ

OP_TWICE = _casadi.OP_TWICE

OP_SIN = _casadi.OP_SIN

OP_COS = _casadi.OP_COS

OP_TAN = _casadi.OP_TAN

OP_ASIN = _casadi.OP_ASIN

OP_ACOS = _casadi.OP_ACOS

OP_ATAN = _casadi.OP_ATAN

OP_LT = _casadi.OP_LT

OP_LE = _casadi.OP_LE

OP_EQ = _casadi.OP_EQ

OP_NE = _casadi.OP_NE

OP_NOT = _casadi.OP_NOT

OP_AND = _casadi.OP_AND

OP_OR = _casadi.OP_OR

OP_FLOOR = _casadi.OP_FLOOR

OP_CEIL = _casadi.OP_CEIL

OP_FMOD = _casadi.OP_FMOD

OP_FABS = _casadi.OP_FABS

OP_SIGN = _casadi.OP_SIGN

OP_COPYSIGN = _casadi.OP_COPYSIGN

OP_IF_ELSE_ZERO = _casadi.OP_IF_ELSE_ZERO

OP_ERF = _casadi.OP_ERF

OP_FMIN = _casadi.OP_FMIN

OP_FMAX = _casadi.OP_FMAX

OP_INV = _casadi.OP_INV

OP_SINH = _casadi.OP_SINH

OP_COSH = _casadi.OP_COSH

OP_TANH = _casadi.OP_TANH

OP_ASINH = _casadi.OP_ASINH

OP_ACOSH = _casadi.OP_ACOSH

OP_ATANH = _casadi.OP_ATANH

OP_ATAN2 = _casadi.OP_ATAN2

OP_CONST = _casadi.OP_CONST

OP_INPUT = _casadi.OP_INPUT

OP_OUTPUT = _casadi.OP_OUTPUT

OP_PARAMETER = _casadi.OP_PARAMETER

OP_CALL = _casadi.OP_CALL

OP_FIND = _casadi.OP_FIND

OP_LOW = _casadi.OP_LOW

OP_MAP = _casadi.OP_MAP

OP_MTIMES = _casadi.OP_MTIMES

OP_SOLVE = _casadi.OP_SOLVE

OP_TRANSPOSE = _casadi.OP_TRANSPOSE

OP_DETERMINANT = _casadi.OP_DETERMINANT

OP_INVERSE = _casadi.OP_INVERSE

OP_DOT = _casadi.OP_DOT

OP_BILIN = _casadi.OP_BILIN

OP_RANK1 = _casadi.OP_RANK1

OP_HORZCAT = _casadi.OP_HORZCAT

OP_VERTCAT = _casadi.OP_VERTCAT

OP_DIAGCAT = _casadi.OP_DIAGCAT

OP_HORZSPLIT = _casadi.OP_HORZSPLIT

OP_VERTSPLIT = _casadi.OP_VERTSPLIT

OP_DIAGSPLIT = _casadi.OP_DIAGSPLIT

OP_RESHAPE = _casadi.OP_RESHAPE

OP_SUBREF = _casadi.OP_SUBREF

OP_SUBASSIGN = _casadi.OP_SUBASSIGN

OP_GETNONZEROS = _casadi.OP_GETNONZEROS

OP_GETNONZEROS_PARAM = _casadi.OP_GETNONZEROS_PARAM

OP_ADDNONZEROS = _casadi.OP_ADDNONZEROS

OP_ADDNONZEROS_PARAM = _casadi.OP_ADDNONZEROS_PARAM

OP_SETNONZEROS = _casadi.OP_SETNONZEROS

OP_SETNONZEROS_PARAM = _casadi.OP_SETNONZEROS_PARAM

OP_PROJECT = _casadi.OP_PROJECT

OP_ASSERTION = _casadi.OP_ASSERTION

OP_MONITOR = _casadi.OP_MONITOR

OP_NORM2 = _casadi.OP_NORM2

OP_NORM1 = _casadi.OP_NORM1

OP_NORMINF = _casadi.OP_NORMINF

OP_NORMF = _casadi.OP_NORMF

OP_MMIN = _casadi.OP_MMIN

OP_MMAX = _casadi.OP_MMAX

OP_HORZREPMAT = _casadi.OP_HORZREPMAT

OP_HORZREPSUM = _casadi.OP_HORZREPSUM

OP_ERFINV = _casadi.OP_ERFINV

OP_PRINTME = _casadi.OP_PRINTME

OP_LIFT = _casadi.OP_LIFT

OP_EINSTEIN = _casadi.OP_EINSTEIN

OP_BSPLINE = _casadi.OP_BSPLINE

OP_CONVEXIFY = _casadi.OP_CONVEXIFY

class SparsityInterfaceCommon(object):
    r"""Proxy of C++ casadi::SparsityInterfaceCommon class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(SparsityInterfaceCommon self) -> SparsityInterfaceCommon
        __init__(SparsityInterfaceCommon self, SparsityInterfaceCommon other) -> SparsityInterfaceCommon
        """
        _casadi.SparsityInterfaceCommon_swiginit(self, _casadi.new_SparsityInterfaceCommon(*args))
    __swig_destroy__ = _casadi.delete_SparsityInterfaceCommon

# Register SparsityInterfaceCommon in _casadi:
_casadi.SparsityInterfaceCommon_swigregister(SparsityInterfaceCommon)

class Sparsity(SharedObject, SparsityInterfaceCommon, PrintableCommon):
    r"""


    General sparsity class.

    The storage format is a compressed column storage (CCS) format.  In this
    format, the structural non-zero elements are stored in column-major order,
    starting from the upper left corner of the matrix and ending in the lower
    right corner.

    In addition to the dimension ( size1(), size2()), (i.e. the number of rows
    and the number of columns respectively), there are also two vectors of
    integers:

    "colind" [length size2()+1], which contains the index to the first non-
    zero element on or after the corresponding column. All the non-zero elements
    of a particular i are thus the elements with index el that fulfills:
    colind[i] <= el < colind[i+1].

    "row" [same length as the number of non-zero elements, nnz()] The rows for
    each of the structural non-zeros.

    Note that with this format, it is cheap to loop over all the non-zero
    elements of a particular column, at constant time per element, but expensive
    to jump to access a location (i, j).

    If the matrix is dense, i.e. length(row) == size1()*size2(), the format
    reduces to standard dense column major format, which allows access to an
    arbitrary element in constant time.

    Since the object is reference counted (it inherits from SharedObject),
    several matrices are allowed to share the same sparsity pattern.

    The implementations of methods marked as such in this class has been taken
    from the CSparse package and modified to fit CasADi data structures and
    separation of sparsity pattern calculation and numerical evaluation. These
    functions are Copyright(c) Timothy A. Davis, 2006-2009 and licensed as a
    derivative work under the GNU LGPL

    See:   Matrix

    Joel Andersson

    C++ includes: sparsity.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def scalar(*args) -> "casadi::Sparsity":
        r"""
        scalar(bool dense_scalar=True) -> Sparsity


        Create a scalar sparsity pattern.


        """
        return _casadi.Sparsity_scalar(*args)

    @staticmethod
    def dense(*args) -> "casadi::Sparsity":
        r"""
        dense(casadi_int nrow, casadi_int ncol=1) -> Sparsity
        dense(std::pair< casadi_int,casadi_int > const & rc) -> Sparsity


        Create a dense rectangular sparsity pattern.


        """
        return _casadi.Sparsity_dense(*args)

    @staticmethod
    def unit(*args) -> "casadi::Sparsity":
        r"""
        unit(casadi_int n, casadi_int el) -> Sparsity


        Create the sparsity pattern for a unit vector of length n and a nonzero on
        position el.


        """
        return _casadi.Sparsity_unit(*args)

    @staticmethod
    def upper(*args) -> "casadi::Sparsity":
        r"""upper(casadi_int n) -> Sparsity"""
        return _casadi.Sparsity_upper(*args)

    @staticmethod
    def lower(*args) -> "casadi::Sparsity":
        r"""lower(casadi_int n) -> Sparsity"""
        return _casadi.Sparsity_lower(*args)

    @staticmethod
    def diag(*args) -> "casadi::Sparsity":
        r"""
        diag(casadi_int nrow) -> Sparsity
        diag(casadi_int nrow, casadi_int ncol) -> Sparsity
        diag(std::pair< casadi_int,casadi_int > const & rc) -> Sparsity


        Create diagonal sparsity pattern.


        """
        return _casadi.Sparsity_diag(*args)

    @staticmethod
    def band(*args) -> "casadi::Sparsity":
        r"""band(casadi_int n, casadi_int p) -> Sparsity"""
        return _casadi.Sparsity_band(*args)

    @staticmethod
    def banded(*args) -> "casadi::Sparsity":
        r"""banded(casadi_int n, casadi_int p) -> Sparsity"""
        return _casadi.Sparsity_banded(*args)

    @staticmethod
    def rowcol(*args) -> "casadi::Sparsity":
        r"""rowcol(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, casadi_int nrow, casadi_int ncol) -> Sparsity"""
        return _casadi.Sparsity_rowcol(*args)

    @staticmethod
    def triplet(*args) -> "casadi::Sparsity":
        r"""
        triplet(casadi_int nrow, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, bool invert_mapping) -> Sparsity
        triplet(casadi_int nrow, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col) -> Sparsity
        """
        return _casadi.Sparsity_triplet(*args)

    @staticmethod
    def nonzeros(*args) -> "casadi::Sparsity":
        r"""nonzeros(casadi_int nrow, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & nz, bool ind1=False) -> Sparsity"""
        return _casadi.Sparsity_nonzeros(*args)

    @staticmethod
    def compressed(*args) -> "casadi::Sparsity":
        r"""
        compressed(std::vector< casadi_int,std::allocator< casadi_int > > const & v, bool order_rows=False) -> Sparsity


        Create from a single vector containing the pattern in compressed column
        storage format: The format: The first two entries are the number of rows
        (nrow) and columns (ncol) The next ncol+1 entries are the column offsets
        (colind). Note that the last element, colind[ncol], gives the number of
        nonzeros The last colind[ncol] entries are the row indices


        """
        return _casadi.Sparsity_compressed(*args)

    def sanity_check(self, *args) -> "void":
        r"""
        sanity_check(Sparsity self, bool complete=False)


        [DEPRECATED] Correctness of sparsity patterns are checked during
        construction


        """
        return _casadi.Sparsity_sanity_check(self, *args)

    def get_diag(self, *args) -> "casadi::Sparsity":
        r"""
        get_diag(Sparsity self) -> Sparsity


        Get the diagonal of the matrix/create a diagonal matrix (mapping will
        contain the nonzero mapping) When the input is square, the diagonal elements
        are returned. If the input is vector-like, a diagonal matrix is constructed
        with it.


        """
        return _casadi.Sparsity_get_diag(self, *args)

    def compress(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""
        compress(Sparsity self) -> std::vector< casadi_int,std::allocator< casadi_int > >


        Compress a sparsity pattern.


        """
        return _casadi.Sparsity_compress(self, *args)

    def is_equal(self, *args) -> "bool":
        r"""
        is_equal(Sparsity self, Sparsity y) -> bool
        is_equal(Sparsity self, casadi_int nrow, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & colind, std::vector< casadi_int,std::allocator< casadi_int > > const & row) -> bool
        """
        return _casadi.Sparsity_is_equal(self, *args)

    def __eq__(self, *args) -> "bool":
        r"""__eq__(Sparsity self, Sparsity y) -> bool"""
        return _casadi.Sparsity___eq__(self, *args)

    def __ne__(self, *args) -> "bool":
        r"""__ne__(Sparsity self, Sparsity y) -> bool"""
        return _casadi.Sparsity___ne__(self, *args)

    def is_stacked(self, *args) -> "bool":
        r"""
        is_stacked(Sparsity self, Sparsity y, casadi_int n) -> bool


        Check if pattern is horizontal repeat of another.


        """
        return _casadi.Sparsity_is_stacked(self, *args)

    def size1(self, *args) -> "casadi_int":
        r"""
        size1(Sparsity self) -> casadi_int


        Get the number of rows.


        """
        return _casadi.Sparsity_size1(self, *args)

    def rows(self, *args) -> "casadi_int":
        r"""
        rows(Sparsity self) -> casadi_int


        Get the number of rows, Octave-style syntax.


        """
        return _casadi.Sparsity_rows(self, *args)

    def size2(self, *args) -> "casadi_int":
        r"""
        size2(Sparsity self) -> casadi_int


        Get the number of columns.


        """
        return _casadi.Sparsity_size2(self, *args)

    def columns(self, *args) -> "casadi_int":
        r"""
        columns(Sparsity self) -> casadi_int


        Get the number of columns, Octave-style syntax.


        """
        return _casadi.Sparsity_columns(self, *args)

    def numel(self, *args) -> "casadi_int":
        r"""
        numel(Sparsity self) -> casadi_int


        The total number of elements, including structural zeros, i.e.
        size2()*size1() Beware of overflow.

        See:   nnz()


        """
        return _casadi.Sparsity_numel(self, *args)

    def density(self, *args) -> "double":
        r"""
        density(Sparsity self) -> double


        The percentage of nonzero Equivalent to (100.0 * nnz())/numel(), but avoids
        overflow.


        """
        return _casadi.Sparsity_density(self, *args)

    def is_empty(self, *args) -> "bool":
        r"""
        is_empty(Sparsity self, bool both=False) -> bool


        Check if the sparsity is empty.

        A sparsity is considered empty if one of the dimensions is zero (or
        optionally both dimensions)


        """
        return _casadi.Sparsity_is_empty(self, *args)

    def nnz(self, *args) -> "casadi_int":
        r"""
        nnz(Sparsity self) -> casadi_int


        Get the number of (structural) non-zeros.

        See:   numel()


        """
        return _casadi.Sparsity_nnz(self, *args)

    def nnz_upper(self, *args) -> "casadi_int":
        r"""
        nnz_upper(Sparsity self, bool strictly=False) -> casadi_int


        Number of non-zeros in the upper triangular half, i.e. the number of
        elements (i, j) with j>=i.


        """
        return _casadi.Sparsity_nnz_upper(self, *args)

    def nnz_lower(self, *args) -> "casadi_int":
        r"""
        nnz_lower(Sparsity self, bool strictly=False) -> casadi_int


        Number of non-zeros in the lower triangular half, i.e. the number of
        elements (i, j) with j<=i.


        """
        return _casadi.Sparsity_nnz_lower(self, *args)

    def nnz_diag(self, *args) -> "casadi_int":
        r"""
        nnz_diag(Sparsity self) -> casadi_int


        Number of non-zeros on the diagonal, i.e. the number of elements (i, j) with
        j==i.


        """
        return _casadi.Sparsity_nnz_diag(self, *args)

    def bw_upper(self, *args) -> "casadi_int":
        r"""
        bw_upper(Sparsity self) -> casadi_int


        Upper half-bandwidth.


        """
        return _casadi.Sparsity_bw_upper(self, *args)

    def bw_lower(self, *args) -> "casadi_int":
        r"""
        bw_lower(Sparsity self) -> casadi_int


        Lower half-bandwidth.


        """
        return _casadi.Sparsity_bw_lower(self, *args)

    def size(self, *args) -> "casadi_int":
        r"""
        size(Sparsity self) -> std::pair< casadi_int,casadi_int >
        size(Sparsity self, casadi_int axis) -> casadi_int


        Get the size along a particular dimensions.


        """
        return _casadi.Sparsity_size(self, *args)

    def info(self, *args) -> "casadi::Dict":
        r"""
        info(Sparsity self) -> casadi::Dict


        Obtain information about sparsity


        """
        return _casadi.Sparsity_info(self, *args)

    def to_file(self, *args) -> "void":
        r"""
        to_file(Sparsity self, std::string const & filename, std::string const & format_hint="")


        Export sparsity pattern to file

        Supported formats: .mtx Matrix Market


        """
        return _casadi.Sparsity_to_file(self, *args)

    @staticmethod
    def from_file(*args) -> "casadi::Sparsity":
        r"""from_file(std::string const & filename, std::string const & format_hint="") -> Sparsity"""
        return _casadi.Sparsity_from_file(*args)

    def serialize(self, *args) -> "void":
        r"""
        serialize(Sparsity self) -> std::string
        serialize(Sparsity self, casadi::SerializingStream & s)


        Serialize an object.


        """
        return _casadi.Sparsity_serialize(self, *args)

    @staticmethod
    def deserialize(*args) -> "casadi::Sparsity":
        r"""
        deserialize(std::istream & stream) -> Sparsity
        deserialize(std::string const & s) -> Sparsity
        deserialize(casadi::DeserializingStream & s) -> Sparsity
        """
        return _casadi.Sparsity_deserialize(*args)

    def colind(self, *args) -> "casadi_int":
        r"""
        colind(Sparsity self) -> std::vector< casadi_int,std::allocator< casadi_int > >
        colind(Sparsity self, casadi_int cc) -> casadi_int


        Get a reference to the colindex of column cc (see class description)


        """
        return _casadi.Sparsity_colind(self, *args)

    def row(self, *args) -> "casadi_int":
        r"""
        row(Sparsity self) -> std::vector< casadi_int,std::allocator< casadi_int > >
        row(Sparsity self, casadi_int el) -> casadi_int


        Get the row of a non-zero element.


        """
        return _casadi.Sparsity_row(self, *args)

    def get_col(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""
        get_col(Sparsity self) -> std::vector< casadi_int,std::allocator< casadi_int > >


        Get the column for each non-zero entry Together with the row-vector, this
        vector gives the sparsity of the matrix in sparse triplet format, i.e. the
        column and row for each non-zero elements.


        """
        return _casadi.Sparsity_get_col(self, *args)

    def resize(self, *args) -> "void":
        r"""
        resize(Sparsity self, casadi_int nrow, casadi_int ncol)


        Resize.


        """
        return _casadi.Sparsity_resize(self, *args)

    def add_nz(self, *args) -> "casadi_int":
        r"""
        add_nz(Sparsity self, casadi_int rr, casadi_int cc) -> casadi_int


        Get the index of a non-zero element Add the element if it does not exist and
        copy object if it's not unique.


        """
        return _casadi.Sparsity_add_nz(self, *args)

    def has_nz(self, *args) -> "bool":
        r"""
        has_nz(Sparsity self, casadi_int rr, casadi_int cc) -> bool


        Returns true if the pattern has a non-zero at location rr, cc.


        """
        return _casadi.Sparsity_has_nz(self, *args)

    def get_nz(self, *args) -> "void":
        r"""
        get_nz(Sparsity self, casadi_int rr, casadi_int cc) -> casadi_int
        get_nz(Sparsity self, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, std::vector< casadi_int,std::allocator< casadi_int > > const & cc) -> std::vector< casadi_int,std::allocator< casadi_int > >
        get_nz(Sparsity self, std::vector< casadi_int,std::allocator< casadi_int > > & INOUT)


        Get the nonzero index for a set of elements The index vector is used both
        for input and outputs and must be sorted by increasing nonzero index, i.e.
        column-wise. Elements not found in the sparsity pattern are set to -1.


        """
        return _casadi.Sparsity_get_nz(self, *args)

    def get_lower(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""
        get_lower(Sparsity self) -> std::vector< casadi_int,std::allocator< casadi_int > >


        Get nonzeros in lower triangular part.


        """
        return _casadi.Sparsity_get_lower(self, *args)

    def get_upper(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""
        get_upper(Sparsity self) -> std::vector< casadi_int,std::allocator< casadi_int > >


        Get nonzeros in upper triangular part.


        """
        return _casadi.Sparsity_get_upper(self, *args)

    def get_ccs(self, *args) -> "void":
        r"""
        get_ccs(Sparsity self)


        Get the sparsity in compressed column storage (CCS) format.


        """
        return _casadi.Sparsity_get_ccs(self, *args)

    def get_crs(self, *args) -> "void":
        r"""
        get_crs(Sparsity self)


        Get the sparsity in compressed row storage (CRS) format.


        """
        return _casadi.Sparsity_get_crs(self, *args)

    def get_triplet(self, *args) -> "void":
        r"""
        get_triplet(Sparsity self)


        Get the sparsity in sparse triplet format.


        """
        return _casadi.Sparsity_get_triplet(self, *args)

    def sub(self, *args) -> "casadi::Sparsity":
        r"""
        sub(Sparsity self, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, std::vector< casadi_int,std::allocator< casadi_int > > const & cc, bool ind1=False) -> Sparsity
        sub(Sparsity self, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, Sparsity sp, bool ind1=False) -> Sparsity


        Get a set of elements.

        Returns the sparsity of the corresponding elements, with a mapping such that
        submatrix[k] = originalmatrix[mapping[k]]


        """
        return _casadi.Sparsity_sub(self, *args)

    def transpose(self, *args) -> "casadi::Sparsity":
        r"""
        transpose(Sparsity self, bool invert_mapping=False) -> Sparsity


        Transpose the matrix and get the reordering of the non-zero entries.

        Parameters:
        -----------

        mapping:  the non-zeros of the original matrix for each non-zero of the new
        matrix


        """
        return _casadi.Sparsity_transpose(self, *args)

    def is_transpose(self, *args) -> "bool":
        r"""
        is_transpose(Sparsity self, Sparsity y) -> bool


        Check if the sparsity is the transpose of another.


        """
        return _casadi.Sparsity_is_transpose(self, *args)

    def is_reshape(self, *args) -> "bool":
        r"""
        is_reshape(Sparsity self, Sparsity y) -> bool


        Check if the sparsity is a reshape of another.


        """
        return _casadi.Sparsity_is_reshape(self, *args)

    def combine(self, *args) -> "casadi::Sparsity":
        r"""
        combine(Sparsity self, Sparsity y, bool f0x_is_zero, bool function0_is_zero) -> Sparsity


        Combine two sparsity patterns Returns the new sparsity pattern as well as a
        mapping with the same length as the number of non-zero elements The mapping
        matrix contains the arguments for each nonzero, the first bit indicates if
        the first argument is nonzero, the second bit indicates if the second
        argument is nonzero (note that none of, one of or both of the arguments can
        be nonzero)


        """
        return _casadi.Sparsity_combine(self, *args)

    def unite(self, *args) -> "casadi::Sparsity":
        r"""
        unite(Sparsity self, Sparsity y) -> Sparsity


        Union of two sparsity patterns.


        """
        return _casadi.Sparsity_unite(self, *args)

    def __add__(self, *args) -> "casadi::Sparsity":
        r"""__add__(Sparsity self, Sparsity b) -> Sparsity"""
        return _casadi.Sparsity___add__(self, *args)

    def intersect(self, *args) -> "casadi::Sparsity":
        r"""
        intersect(Sparsity self, Sparsity y) -> Sparsity


        Intersection of two sparsity patterns Returns the new sparsity pattern as
        well as a mapping with the same length as the number of non-zero elements
        The value is 1 if the non-zero comes from the first (i.e. this) object, 2 if
        it is from the second and 3 (i.e. 1 | 2) if from both.


        """
        return _casadi.Sparsity_intersect(self, *args)

    def __mul__(self, *args) -> "casadi::Sparsity":
        r"""__mul__(Sparsity self, Sparsity b) -> Sparsity"""
        return _casadi.Sparsity___mul__(self, *args)

    def is_subset(self, *args) -> "bool":
        r"""
        is_subset(Sparsity self, Sparsity rhs) -> bool


        Is subset?


        """
        return _casadi.Sparsity_is_subset(self, *args)

    def pattern_inverse(self, *args) -> "casadi::Sparsity":
        r"""
        pattern_inverse(Sparsity self) -> Sparsity


        Take the inverse of a sparsity pattern; flip zeros and non-zeros.


        """
        return _casadi.Sparsity_pattern_inverse(self, *args)

    def enlarge(self, *args) -> "void":
        r"""
        enlarge(Sparsity self, casadi_int nrow, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, std::vector< casadi_int,std::allocator< casadi_int > > const & cc, bool ind1=False)


        Enlarge matrix Make the matrix larger by inserting empty rows and columns,
        keeping the existing non-zeros.

        For the matrices A to B A(m, n) length(jj)=m , length(ii)=n B(nrow, ncol)

        A=enlarge(m, n, ii, jj) makes sure that

        B[jj, ii] == A


        """
        return _casadi.Sparsity_enlarge(self, *args)

    def enlargeRows(self, *args) -> "void":
        r"""
        enlargeRows(Sparsity self, casadi_int nrow, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, bool ind1=False)


        Enlarge the matrix along the first dimension (i.e. insert rows)


        """
        return _casadi.Sparsity_enlargeRows(self, *args)

    def enlargeColumns(self, *args) -> "void":
        r"""
        enlargeColumns(Sparsity self, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & cc, bool ind1=False)


        Enlarge the matrix along the second dimension (i.e. insert columns)


        """
        return _casadi.Sparsity_enlargeColumns(self, *args)

    def makeDense(self, *args) -> "casadi::Sparsity":
        r"""
        makeDense(Sparsity self) -> Sparsity


        Make a patten dense.


        """
        return _casadi.Sparsity_makeDense(self, *args)

    def erase(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""
        erase(Sparsity self, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, std::vector< casadi_int,std::allocator< casadi_int > > const & cc, bool ind1=False) -> std::vector< casadi_int,std::allocator< casadi_int > >
        erase(Sparsity self, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, bool ind1=False) -> std::vector< casadi_int,std::allocator< casadi_int > >


        Erase elements of a matrix.


        """
        return _casadi.Sparsity_erase(self, *args)

    def append(self, *args) -> "void":
        r"""
        append(Sparsity self, Sparsity sp)


        Append another sparsity patten vertically (NOTE: only efficient if vector)


        """
        return _casadi.Sparsity_append(self, *args)

    def appendColumns(self, *args) -> "void":
        r"""
        appendColumns(Sparsity self, Sparsity sp)


        Append another sparsity patten horizontally.


        """
        return _casadi.Sparsity_appendColumns(self, *args)

    def is_scalar(self, *args) -> "bool":
        r"""
        is_scalar(Sparsity self, bool scalar_and_dense=False) -> bool


        Is scalar?


        """
        return _casadi.Sparsity_is_scalar(self, *args)

    def is_dense(self, *args) -> "bool":
        r"""
        is_dense(Sparsity self) -> bool


        Is dense?


        """
        return _casadi.Sparsity_is_dense(self, *args)

    def is_row(self, *args) -> "bool":
        r"""
        is_row(Sparsity self) -> bool


        Check if the pattern is a row vector (i.e. size1()==1)


        """
        return _casadi.Sparsity_is_row(self, *args)

    def is_column(self, *args) -> "bool":
        r"""
        is_column(Sparsity self) -> bool


        Check if the pattern is a column vector (i.e. size2()==1)


        """
        return _casadi.Sparsity_is_column(self, *args)

    def is_vector(self, *args) -> "bool":
        r"""
        is_vector(Sparsity self) -> bool


        Check if the pattern is a row or column vector.


        """
        return _casadi.Sparsity_is_vector(self, *args)

    def is_diag(self, *args) -> "bool":
        r"""
        is_diag(Sparsity self) -> bool


        Is diagonal?


        """
        return _casadi.Sparsity_is_diag(self, *args)

    def is_square(self, *args) -> "bool":
        r"""
        is_square(Sparsity self) -> bool


        Is square?


        """
        return _casadi.Sparsity_is_square(self, *args)

    def is_symmetric(self, *args) -> "bool":
        r"""
        is_symmetric(Sparsity self) -> bool


        Is symmetric?


        """
        return _casadi.Sparsity_is_symmetric(self, *args)

    def is_triu(self, *args) -> "bool":
        r"""
        is_triu(Sparsity self) -> bool


        Is upper triangular?


        """
        return _casadi.Sparsity_is_triu(self, *args)

    def is_tril(self, *args) -> "bool":
        r"""
        is_tril(Sparsity self) -> bool


        Is lower triangular?


        """
        return _casadi.Sparsity_is_tril(self, *args)

    def is_singular(self, *args) -> "bool":
        r"""
        is_singular(Sparsity self) -> bool


        Check whether the sparsity-pattern indicates structural singularity.


        """
        return _casadi.Sparsity_is_singular(self, *args)

    def rowsSequential(self, *args) -> "bool":
        r"""
        rowsSequential(Sparsity self, bool strictly=True) -> bool


        Do the rows appear sequentially on each column.

        Parameters:
        -----------

        strictly:  if true, then do not allow multiple entries


        """
        return _casadi.Sparsity_rowsSequential(self, *args)

    def removeDuplicates(self, *args) -> "void":
        r"""
        removeDuplicates(Sparsity self, std::vector< casadi_int,std::allocator< casadi_int > > & INOUT)


        Remove duplicate entries.

        The same indices will be removed from the mapping vector, which must have
        the same length as the number of nonzeros


        """
        return _casadi.Sparsity_removeDuplicates(self, *args)

    def etree(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""
        etree(Sparsity self, bool ata=False) -> std::vector< casadi_int,std::allocator< casadi_int > >


        Calculate the elimination tree See Direct Methods for Sparse Linear Systems
        by Davis (2006). If the parameter ata is false, the algorithm is equivalent
        to MATLAB's etree(A), except that the indices are zero- based. If ata is
        true, the algorithm is equivalent to MATLAB's etree(A, 'col').

        The implementation is a modified version of cs_etree in CSparse Copyright(c)
        Timothy A. Davis, 2006-2009 Licensed as a derivative work under the GNU LGPL


        """
        return _casadi.Sparsity_etree(self, *args)

    def ldl(self, *args) -> "casadi::Sparsity":
        r"""
        ldl(Sparsity self, bool amd=True) -> Sparsity


        Symbolic LDL factorization Returns the sparsity pattern of L^T.

        The implementation is a modified version of LDL Copyright(c) Timothy A.
        Davis, 2005-2013 Licensed as a derivative work under the GNU LGPL


        """
        return _casadi.Sparsity_ldl(self, *args)

    def qr_sparse(self, *args) -> "void":
        r"""
        qr_sparse(Sparsity self, bool amd=True)


        Symbolic QR factorization Returns the sparsity pattern of V (compact
        representation of Q) and R as well as vectors needed for the numerical
        factorization and solution. The implementation is a modified version of
        CSparse Copyright(c) Timothy A. Davis, 2006-2009 Licensed as a derivative
        work under the GNU LGPL.


        """
        return _casadi.Sparsity_qr_sparse(self, *args)

    def dfs(self, *args) -> "casadi_int":
        r"""
        dfs(Sparsity self, casadi_int j, casadi_int top, std::vector< casadi_int,std::allocator< casadi_int > > & arg4, std::vector< casadi_int,std::allocator< casadi_int > > & arg5, std::vector< casadi_int,std::allocator< casadi_int > > const & pinv, std::vector< bool,std::allocator< bool > > & arg7) -> casadi_int


        Depth-first search on the adjacency graph of the sparsity See Direct Methods
        for Sparse Linear Systems by Davis (2006).


        """
        return _casadi.Sparsity_dfs(self, *args)

    def scc(self, *args) -> "casadi_int":
        r"""
        scc(Sparsity self) -> casadi_int


        Find the strongly connected components of the bigraph defined by the
        sparsity pattern of a square matrix.

        See Direct Methods for Sparse Linear Systems by Davis (2006). Returns:
        Number of components

        Offset for each components (length: 1 + number of components)

        Indices for each components, component i has indices index[offset[i]], ...,
        index[offset[i+1]]

        In the case that the matrix is symmetric, the result has a particular
        interpretation: Given a symmetric matrix A and n = A.scc(p, r)

        => A[p, p] will appear block-diagonal with n blocks and with the indices of
        the block boundaries to be found in r.

        The implementation is a modified version of cs_scc in CSparse Copyright(c)
        Timothy A. Davis, 2006-2009 Licensed as a derivative work under the GNU LGPL


        """
        return _casadi.Sparsity_scc(self, *args)

    def btf(self, *args) -> "casadi_int":
        r"""
        btf(Sparsity self) -> casadi_int


        Calculate the block triangular form (BTF) See Direct Methods for Sparse
        Linear Systems by Davis (2006).

        The function computes the Dulmage-Mendelsohn decomposition, which allows you
        to reorder the rows and columns of a matrix to bring it into block
        triangular form (BTF).

        It will not consider the distance of off-diagonal elements to the diagonal:
        there is no guarantee you will get a block-diagonal matrix if you supply a
        randomly permuted block-diagonal matrix.

        If your matrix is symmetrical, this method is of limited use; permutation
        can make it non-symmetric.

        See:   scc  The implementation is a modified version of cs_dmperm in CSparse
        Copyright(c) Timothy A. Davis, 2006-2009 Licensed as a derivative work under
        the GNU LGPL


        """
        return _casadi.Sparsity_btf(self, *args)

    def amd(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""
        amd(Sparsity self) -> std::vector< casadi_int,std::allocator< casadi_int > >


        Approximate minimal degree preordering Fill-reducing ordering applied to the
        sparsity pattern of a linear system prior to factorization. The system must
        be symmetric, for an unsymmetric matrix A, first form the square of the
        pattern, A'*A.

        The implementation is a modified version of cs_amd in CSparse Copyright(c)
        Timothy A. Davis, 2006-2009 Licensed as a derivative work under the GNU LGPL


        """
        return _casadi.Sparsity_amd(self, *args)

    def find(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""
        find(Sparsity self, bool ind1=False) -> std::vector< casadi_int,std::allocator< casadi_int > >


        Get the location of all non-zero elements as they would appear in a Dense
        matrix A : DenseMatrix 4 x 3 B : SparseMatrix 4 x 3 , 5 structural non-
        zeros.

        k = A.find() A[k] will contain the elements of A that are non-zero in B

        Inverse of nonzeros.


        """
        return _casadi.Sparsity_find(self, *args)

    def uni_coloring(self, *args) -> "casadi::Sparsity":
        r"""
        uni_coloring(Sparsity self, Sparsity AT=casadi::Sparsity(), casadi_int cutoff=std::numeric_limits< casadi_int >::max()) -> Sparsity


        Perform a unidirectional coloring: A greedy distance-2 coloring algorithm
        (Algorithm 3.1 in A. H. GEBREMEDHIN, F. MANNE, A. POTHEN)


        """
        return _casadi.Sparsity_uni_coloring(self, *args)

    def star_coloring(self, *args) -> "casadi::Sparsity":
        r"""
        star_coloring(Sparsity self, casadi_int ordering=1, casadi_int cutoff=std::numeric_limits< casadi_int >::max()) -> Sparsity


        Perform a star coloring of a symmetric matrix: A greedy distance-2 coloring
        algorithm Algorithm 4.1 in What Color Is Your Jacobian? Graph Coloring for
        Computing Derivatives A. H. GEBREMEDHIN, F. MANNE, A. POTHEN SIAM Rev.,
        47(4), 629705 (2006)

        Ordering options: None (0), largest first (1)


        """
        return _casadi.Sparsity_star_coloring(self, *args)

    def star_coloring2(self, *args) -> "casadi::Sparsity":
        r"""
        star_coloring2(Sparsity self, casadi_int ordering=1, casadi_int cutoff=std::numeric_limits< casadi_int >::max()) -> Sparsity


        Perform a star coloring of a symmetric matrix: A new greedy distance-2
        coloring algorithm Algorithm 4.1 in NEW ACYCLIC AND STAR COLORING ALGORITHMS
        WITH APPLICATION TO COMPUTING HESSIANS A. H. GEBREMEDHIN, A. TARAFDAR, F.
        MANNE, A. POTHEN SIAM J. SCI. COMPUT. Vol. 29, No. 3, pp. 10421072 (2007)

        Ordering options: None (0), largest first (1)


        """
        return _casadi.Sparsity_star_coloring2(self, *args)

    def largest_first(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""
        largest_first(Sparsity self) -> std::vector< casadi_int,std::allocator< casadi_int > >


        Order the columns by decreasing degree.


        """
        return _casadi.Sparsity_largest_first(self, *args)

    def pmult(self, *args) -> "casadi::Sparsity":
        r"""
        pmult(Sparsity self, std::vector< casadi_int,std::allocator< casadi_int > > const & p, bool permute_rows=True, bool permute_columns=True, bool invert_permutation=False) -> Sparsity


        Permute rows and/or columns Multiply the sparsity with a permutation matrix
        from the left and/or from the right P * A * trans(P), A * trans(P) or A *
        trans(P) with P defined by an index vector containing the row for each col.
        As an alternative, P can be transposed (inverted).


        """
        return _casadi.Sparsity_pmult(self, *args)

    def dim(self, *args) -> "std::string":
        r"""
        dim(Sparsity self, bool with_nz=False) -> std::string


        Get the dimension as a string.


        """
        return _casadi.Sparsity_dim(self, *args)

    def postfix_dim(self, *args) -> "std::string":
        r"""
        postfix_dim(Sparsity self) -> std::string


        Dimension string as a postfix to a name Rules:

        Dense and scalar: ""

        0-by-0: "[]"

        Dense column vector: "[5]"

        Dense matrix: "[5x10]"

        Otherwise: "[5x10,3nz]"


        """
        return _casadi.Sparsity_postfix_dim(self, *args)

    def repr_el(self, *args) -> "std::string":
        r"""
        repr_el(Sparsity self, casadi_int k) -> std::string


        Describe the nonzero location k as a string.


        """
        return _casadi.Sparsity_repr_el(self, *args)

    def spy(self, *args) -> "void":
        r"""
        spy(Sparsity self)


        Print a textual representation of sparsity.


        """
        return _casadi.Sparsity_spy(self, *args)

    def spy_matlab(self, *args) -> "void":
        r"""
        spy_matlab(Sparsity self, std::string const & mfile)


        Generate a script for Matlab or Octave which visualizes the sparsity using
        the spy command.


        """
        return _casadi.Sparsity_spy_matlab(self, *args)

    def export_code(self, *args) -> "void":
        r"""
        export_code(Sparsity self, std::string const & lang, casadi::Dict const & options=casadi::Dict())


        Export matrix in specific language.

        lang: only 'matlab' supported for now

        ::

           * options:
           *   inline: Indicates if you want everything on a single line (default: False)
           *   name: Name of exported variable (default: 'sp')
           *   as_matrix: Matlab does not have a sparsity object. (default: false)
          *               With this option true, a numeric matrix will be constructed
           * 




        """
        return _casadi.Sparsity_export_code(self, *args)

    @staticmethod
    def type_name(*args) -> "std::string":
        r"""type_name() -> std::string"""
        return _casadi.Sparsity_type_name(*args)

    def hash(self, *args) -> "std::size_t":
        r"""hash(Sparsity self) -> std::size_t"""
        return _casadi.Sparsity_hash(self, *args)

    @staticmethod
    def test_cast(*args) -> "bool":
        r"""test_cast(casadi::SharedObjectInternal const * ptr) -> bool"""
        return _casadi.Sparsity_test_cast(*args)

    @staticmethod
    def kkt(*args) -> "casadi::Sparsity":
        r"""kkt(Sparsity H, Sparsity J, bool with_x_diag=True, bool with_lam_g_diag=True) -> Sparsity"""
        return _casadi.Sparsity_kkt(*args)

    def __setstate__(self, state):
        self.__init__(Sparsity.deserialize(state["serialization"]))

    def __getstate__(self):
        return {"serialization": self.serialize()}


    @property
    def shape(self):
        return (self.size1(),self.size2())

    @property
    def T(self):
        return _casadi.transpose(self)

    def __array__(self,*args,**kwargs):
        return DM.ones(self).full()


    def __init__(self, *args):
        r"""
        __init__(Sparsity self, casadi_int dummy=0) -> Sparsity
        __init__(Sparsity self, casadi_int nrow, casadi_int ncol) -> Sparsity
        __init__(Sparsity self, casadi_int nrow, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & colind, std::vector< casadi_int,std::allocator< casadi_int > > const & row, bool order_rows=False) -> Sparsity
        __init__(Sparsity self, std::pair< casadi_int,casadi_int > const & rc) -> Sparsity
        __init__(Sparsity self, Sparsity other) -> Sparsity
        """
        _casadi.Sparsity_swiginit(self, _casadi.new_Sparsity(*args))
    __swig_destroy__ = _casadi.delete_Sparsity

# Register Sparsity in _casadi:
_casadi.Sparsity_swigregister(Sparsity)

def Sparsity_scalar(*args) -> "casadi::Sparsity":
    r"""
    Sparsity_scalar(bool dense_scalar=True) -> Sparsity


    Create a scalar sparsity pattern.


    """
    return _casadi.Sparsity_scalar(*args)

def Sparsity_dense(*args) -> "casadi::Sparsity":
    r"""
    Sparsity_dense(casadi_int nrow, casadi_int ncol=1) -> Sparsity
    Sparsity_dense(std::pair< casadi_int,casadi_int > const & rc) -> Sparsity


    Create a dense rectangular sparsity pattern.


    """
    return _casadi.Sparsity_dense(*args)

def Sparsity_unit(*args) -> "casadi::Sparsity":
    r"""
    Sparsity_unit(casadi_int n, casadi_int el) -> Sparsity


    Create the sparsity pattern for a unit vector of length n and a nonzero on
    position el.


    """
    return _casadi.Sparsity_unit(*args)

def Sparsity_upper(*args) -> "casadi::Sparsity":
    r"""Sparsity_upper(casadi_int n) -> Sparsity"""
    return _casadi.Sparsity_upper(*args)

def Sparsity_lower(*args) -> "casadi::Sparsity":
    r"""Sparsity_lower(casadi_int n) -> Sparsity"""
    return _casadi.Sparsity_lower(*args)

def Sparsity_diag(*args) -> "casadi::Sparsity":
    r"""
    Sparsity_diag(casadi_int nrow) -> Sparsity
    Sparsity_diag(casadi_int nrow, casadi_int ncol) -> Sparsity
    Sparsity_diag(std::pair< casadi_int,casadi_int > const & rc) -> Sparsity


    Create diagonal sparsity pattern.


    """
    return _casadi.Sparsity_diag(*args)

def Sparsity_band(*args) -> "casadi::Sparsity":
    r"""Sparsity_band(casadi_int n, casadi_int p) -> Sparsity"""
    return _casadi.Sparsity_band(*args)

def Sparsity_banded(*args) -> "casadi::Sparsity":
    r"""Sparsity_banded(casadi_int n, casadi_int p) -> Sparsity"""
    return _casadi.Sparsity_banded(*args)

def Sparsity_rowcol(*args) -> "casadi::Sparsity":
    r"""Sparsity_rowcol(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, casadi_int nrow, casadi_int ncol) -> Sparsity"""
    return _casadi.Sparsity_rowcol(*args)

def Sparsity_triplet(*args) -> "casadi::Sparsity":
    r"""
    Sparsity_triplet(casadi_int nrow, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, bool invert_mapping) -> Sparsity
    Sparsity_triplet(casadi_int nrow, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col) -> Sparsity
    """
    return _casadi.Sparsity_triplet(*args)

def Sparsity_nonzeros(*args) -> "casadi::Sparsity":
    r"""Sparsity_nonzeros(casadi_int nrow, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & nz, bool ind1=False) -> Sparsity"""
    return _casadi.Sparsity_nonzeros(*args)

def Sparsity_compressed(*args) -> "casadi::Sparsity":
    r"""
    Sparsity_compressed(std::vector< casadi_int,std::allocator< casadi_int > > const & v, bool order_rows=False) -> Sparsity


    Create from a single vector containing the pattern in compressed column
    storage format: The format: The first two entries are the number of rows
    (nrow) and columns (ncol) The next ncol+1 entries are the column offsets
    (colind). Note that the last element, colind[ncol], gives the number of
    nonzeros The last colind[ncol] entries are the row indices


    """
    return _casadi.Sparsity_compressed(*args)

def Sparsity_from_file(*args) -> "casadi::Sparsity":
    r"""Sparsity_from_file(std::string const & filename, std::string const & format_hint="") -> Sparsity"""
    return _casadi.Sparsity_from_file(*args)

def Sparsity_deserialize(*args) -> "casadi::Sparsity":
    r"""
    Sparsity_deserialize(std::istream & stream) -> Sparsity
    Sparsity_deserialize(std::string const & s) -> Sparsity
    Sparsity_deserialize(casadi::DeserializingStream & s) -> Sparsity
    """
    return _casadi.Sparsity_deserialize(*args)

def Sparsity_type_name(*args) -> "std::string":
    r"""Sparsity_type_name() -> std::string"""
    return _casadi.Sparsity_type_name(*args)

def Sparsity_test_cast(*args) -> "bool":
    r"""Sparsity_test_cast(casadi::SharedObjectInternal const * ptr) -> bool"""
    return _casadi.Sparsity_test_cast(*args)

def Sparsity_kkt(*args) -> "casadi::Sparsity":
    r"""Sparsity_kkt(Sparsity H, Sparsity J, bool with_x_diag=True, bool with_lam_g_diag=True) -> Sparsity"""
    return _casadi.Sparsity_kkt(*args)


def hash_combine(*args) -> "void":
    r"""
    hash_combine(std::size_t & seed, casadi_int const * v, std::size_t sz)
    hash_combine(std::size_t & seed, std::vector< casadi_int,std::allocator< casadi_int > > const & v)


    Generate a hash value incrementally (function taken from boost)


    """
    return _casadi.hash_combine(*args)

def hash_sparsity(*args) -> "std::size_t":
    r"""
    hash_sparsity(casadi_int nrow, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & colind, std::vector< casadi_int,std::allocator< casadi_int > > const & row) -> std::size_t
    hash_sparsity(casadi_int nrow, casadi_int ncol, casadi_int const * colind, casadi_int const * row) -> std::size_t
    """
    return _casadi.hash_sparsity(*args)
class Slice(PrintableCommon):
    r"""


    Class representing a Slice.

    Note that Python or Octave do not need to use this class. They can just use
    slicing utility from the host language ( M[0:6] in Python, M(1:7) )

    C++ includes: slice.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    start = property(_casadi.Slice_start_get, doc=r"""start : casadi_int""")
    stop = property(_casadi.Slice_stop_get, doc=r"""stop : casadi_int""")
    step = property(_casadi.Slice_step_get, doc=r"""step : casadi_int""")

    def all(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""
        all(Slice self) -> std::vector< casadi_int,std::allocator< casadi_int > >
        all(Slice self, casadi_int len, bool ind1=False) -> std::vector< casadi_int,std::allocator< casadi_int > >
        all(Slice self, Slice outer, casadi_int len) -> std::vector< casadi_int,std::allocator< casadi_int > >


        Get a vector of indices (nested slice)


        """
        return _casadi.Slice_all(self, *args)

    def size(self, *args) -> "size_t":
        r"""
        size(Slice self) -> size_t


        Get number of elements.


        """
        return _casadi.Slice_size(self, *args)

    def is_empty(self, *args) -> "bool":
        r"""
        is_empty(Slice self) -> bool


        Check if slice is empty.


        """
        return _casadi.Slice_is_empty(self, *args)

    def is_scalar(self, *args) -> "bool":
        r"""
        is_scalar(Slice self, casadi_int len) -> bool


        Is the slice a scalar.


        """
        return _casadi.Slice_is_scalar(self, *args)

    def scalar(self, *args) -> "casadi_int":
        r"""
        scalar(Slice self, casadi_int len) -> casadi_int


        Get scalar (if is_scalar)


        """
        return _casadi.Slice_scalar(self, *args)

    def __eq__(self, *args) -> "bool":
        r"""__eq__(Slice self, Slice other) -> bool"""
        return _casadi.Slice___eq__(self, *args)

    def __ne__(self, *args) -> "bool":
        r"""__ne__(Slice self, Slice other) -> bool"""
        return _casadi.Slice___ne__(self, *args)

    def apply(self, *args) -> "casadi::Slice":
        r"""
        apply(Slice self, casadi_int len, bool ind1=False) -> Slice


        Apply concrete length.


        """
        return _casadi.Slice_apply(self, *args)

    def __sub__(self, *args) -> "casadi::Slice":
        r"""__sub__(Slice self, casadi_int i) -> Slice"""
        return _casadi.Slice___sub__(self, *args)

    def __mul__(self, *args) -> "casadi::Slice":
        r"""__mul__(Slice self, casadi_int i) -> Slice"""
        return _casadi.Slice___mul__(self, *args)

    def type_name(self, *args) -> "std::string":
        r"""
        type_name(Slice self) -> std::string


        Get name of the class.


        """
        return _casadi.Slice_type_name(self, *args)

    def disp(self, *args) -> "void":
        r"""
        disp(Slice self, bool more=False)


        Print a description of the object.


        """
        return _casadi.Slice_disp(self, *args)

    def str(self, *args) -> "std::string":
        r"""
        str(Slice self, bool more=False) -> std::string


        Get string representation.


        """
        return _casadi.Slice_str(self, *args)

    def info(self, *args) -> "casadi::Dict":
        r"""
        info(Slice self) -> casadi::Dict


        Obtain information


        """
        return _casadi.Slice_info(self, *args)

    def serialize(self, *args) -> "void":
        r"""
        serialize(Slice self, casadi::SerializingStream & s)


        Serialize an object.


        """
        return _casadi.Slice_serialize(self, *args)

    @staticmethod
    def deserialize(*args) -> "casadi::Slice":
        r"""deserialize(casadi::DeserializingStream & s) -> Slice"""
        return _casadi.Slice_deserialize(*args)

    def __init__(self, *args):
        r"""
        __init__(Slice self) -> Slice
        __init__(Slice self, casadi_int i, bool ind1=False) -> Slice
        __init__(Slice self, casadi_int start, casadi_int stop, casadi_int step=1) -> Slice
        __init__(Slice self, int start, int stop, int step=1) -> Slice
        __init__(Slice self, int start, casadi_int stop, int step=1) -> Slice
        __init__(Slice self, casadi_int start, int stop, int step=1) -> Slice
        __init__(Slice self, Slice other) -> Slice
        """
        _casadi.Slice_swiginit(self, _casadi.new_Slice(*args))
    __swig_destroy__ = _casadi.delete_Slice

# Register Slice in _casadi:
_casadi.Slice_swigregister(Slice)

def Slice_deserialize(*args) -> "casadi::Slice":
    r"""Slice_deserialize(casadi::DeserializingStream & s) -> Slice"""
    return _casadi.Slice_deserialize(*args)


def to_slice(*args) -> "casadi::Slice":
    r"""
    to_slice(std::vector< casadi_int,std::allocator< casadi_int > > const & v, bool ind1=False) -> Slice


    Construct from an index vector (requires is_slice(v) to be true)


    """
    return _casadi.to_slice(*args)

def to_slice2(*args) -> "std::pair< casadi::Slice,casadi::Slice >":
    r"""
    to_slice2(std::vector< casadi_int,std::allocator< casadi_int > > const & v) -> std::pair< casadi::Slice,casadi::Slice >


    Construct nested slices from an index vector (requires is_slice2(v) to be
    true)


    """
    return _casadi.to_slice2(*args)

def is_slice(*args) -> "bool":
    r"""
    is_slice(std::vector< casadi_int,std::allocator< casadi_int > > const & v, bool ind1=False) -> bool


    Check if an index vector can be represented more efficiently as a slice.


    """
    return _casadi.is_slice(*args)

def is_slice2(*args) -> "bool":
    r"""
    is_slice2(std::vector< casadi_int,std::allocator< casadi_int > > const & v) -> bool


    Check if an index vector can be represented more efficiently as two nested
    slices.


    """
    return _casadi.is_slice2(*args)
class GenericMatrixCommon(object):
    r"""


    Matrix base class.

    This is a common base class for MX and Matrix<>, introducing a uniform
    syntax and implementing common functionality using the curiously recurring
    template pattern (CRTP) idiom.  The class is designed with the idea that
    "everything is a matrix", that is, also scalars and vectors. This
    philosophy makes it easy to use and to interface in particularly with Python
    and Matlab/Octave.  The syntax tries to stay as close as possible to the
    ublas syntax when it comes to vector/matrix operations.  Index starts with
    0. Index vec happens as follows: (rr, cc) -> k = rr+cc*size1() Vectors are
    column vectors.  The storage format is Compressed Column Storage (CCS),
    similar to that used for sparse matrices in Matlab, but unlike this format,
    we do allow for elements to be structurally non-zero but numerically zero.
    The sparsity pattern, which is reference counted and cached, can be accessed
    with Sparsity& sparsity() Joel Andersson

    C++ includes: generic_matrix.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __mldivide__(x, y): return _casadi.mldivide(x, y)
    def __rmldivide__(y, x): return _casadi.mldivide(x, y)
    def __mrdivide__(x, y): return _casadi.mrdivide(x, y)
    def __rmrdivide__(y, x): return _casadi.mrdivide(x, y)
    def __mpower__(x, y): return _casadi.mpower(x, y)
    def __rmpower__(y, x): return _casadi.mpower(x, y)


    def __init__(self, *args):
        r"""
        __init__(GenericMatrixCommon self) -> GenericMatrixCommon
        __init__(GenericMatrixCommon self, GenericMatrixCommon other) -> GenericMatrixCommon
        """
        _casadi.GenericMatrixCommon_swiginit(self, _casadi.new_GenericMatrixCommon(*args))
    __swig_destroy__ = _casadi.delete_GenericMatrixCommon

# Register GenericMatrixCommon in _casadi:
_casadi.GenericMatrixCommon_swigregister(GenericMatrixCommon)


def index_interp1d(*args) -> "double":
    r"""index_interp1d(std::vector< double,std::allocator< double > > const & x, double xq, bool equidistant=False) -> double"""
    return _casadi.index_interp1d(*args)
class GenDM(GenericMatrixCommon, SparsityInterfaceCommon):
    r"""Proxy of C++ casadi::GenericMatrix< casadi::Matrix< double > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def nnz(self, *args) -> "casadi_int":
        r"""
        nnz(GenDM self) -> casadi_int


        Get the number of (structural) non-zero elements.


        """
        return _casadi.GenDM_nnz(self, *args)

    def nnz_lower(self, *args) -> "casadi_int":
        r"""
        nnz_lower(GenDM self) -> casadi_int


        Get the number of non-zeros in the lower triangular half.


        """
        return _casadi.GenDM_nnz_lower(self, *args)

    def nnz_upper(self, *args) -> "casadi_int":
        r"""
        nnz_upper(GenDM self) -> casadi_int


        Get the number of non-zeros in the upper triangular half.


        """
        return _casadi.GenDM_nnz_upper(self, *args)

    def nnz_diag(self, *args) -> "casadi_int":
        r"""
        nnz_diag(GenDM self) -> casadi_int


        Get get the number of non-zeros on the diagonal.


        """
        return _casadi.GenDM_nnz_diag(self, *args)

    def numel(self, *args) -> "casadi_int":
        r"""
        numel(GenDM self) -> casadi_int


        Get the number of elements.


        """
        return _casadi.GenDM_numel(self, *args)

    def size1(self, *args) -> "casadi_int":
        r"""
        size1(GenDM self) -> casadi_int


        Get the first dimension (i.e. number of rows)


        """
        return _casadi.GenDM_size1(self, *args)

    def rows(self, *args) -> "casadi_int":
        r"""
        rows(GenDM self) -> casadi_int


        Get the number of rows, Octave-style syntax.


        """
        return _casadi.GenDM_rows(self, *args)

    def size2(self, *args) -> "casadi_int":
        r"""
        size2(GenDM self) -> casadi_int


        Get the second dimension (i.e. number of columns)


        """
        return _casadi.GenDM_size2(self, *args)

    def columns(self, *args) -> "casadi_int":
        r"""
        columns(GenDM self) -> casadi_int


        Get the number of columns, Octave-style syntax.


        """
        return _casadi.GenDM_columns(self, *args)

    def dim(self, *args) -> "std::string":
        r"""
        dim(GenDM self, bool with_nz=False) -> std::string


        Get string representation of dimensions. The representation is e.g. "4x5"
        or "4x5,10nz".


        """
        return _casadi.GenDM_dim(self, *args)

    def size(self, *args) -> "casadi_int":
        r"""
        size(GenDM self) -> std::pair< casadi_int,casadi_int >
        size(GenDM self, casadi_int axis) -> casadi_int


        Get the size along a particular dimensions.


        """
        return _casadi.GenDM_size(self, *args)

    def is_empty(self, *args) -> "bool":
        r"""
        is_empty(GenDM self, bool both=False) -> bool


        Check if the sparsity is empty, i.e. if one of the dimensions is zero (or
        optionally both dimensions)


        """
        return _casadi.GenDM_is_empty(self, *args)

    def is_dense(self, *args) -> "bool":
        r"""
        is_dense(GenDM self) -> bool


        Check if the matrix expression is dense.


        """
        return _casadi.GenDM_is_dense(self, *args)

    def is_scalar(self, *args) -> "bool":
        r"""
        is_scalar(GenDM self, bool scalar_and_dense=False) -> bool


        Check if the matrix expression is scalar.


        """
        return _casadi.GenDM_is_scalar(self, *args)

    def is_square(self, *args) -> "bool":
        r"""
        is_square(GenDM self) -> bool


        Check if the matrix expression is square.


        """
        return _casadi.GenDM_is_square(self, *args)

    def is_vector(self, *args) -> "bool":
        r"""
        is_vector(GenDM self) -> bool


        Check if the matrix is a row or column vector.


        """
        return _casadi.GenDM_is_vector(self, *args)

    def is_row(self, *args) -> "bool":
        r"""
        is_row(GenDM self) -> bool


        Check if the matrix is a row vector (i.e. size1()==1)


        """
        return _casadi.GenDM_is_row(self, *args)

    def is_column(self, *args) -> "bool":
        r"""
        is_column(GenDM self) -> bool


        Check if the matrix is a column vector (i.e. size2()==1)


        """
        return _casadi.GenDM_is_column(self, *args)

    def is_triu(self, *args) -> "bool":
        r"""
        is_triu(GenDM self) -> bool


        Check if the matrix is upper triangular.


        """
        return _casadi.GenDM_is_triu(self, *args)

    def is_tril(self, *args) -> "bool":
        r"""
        is_tril(GenDM self) -> bool


        Check if the matrix is lower triangular.


        """
        return _casadi.GenDM_is_tril(self, *args)

    def row(self, *args) -> "casadi_int":
        r"""
        row(GenDM self) -> std::vector< casadi_int,std::allocator< casadi_int > >
        row(GenDM self, casadi_int el) -> casadi_int


        Get the sparsity pattern. See the Sparsity class for details.


        """
        return _casadi.GenDM_row(self, *args)

    def colind(self, *args) -> "casadi_int":
        r"""
        colind(GenDM self) -> std::vector< casadi_int,std::allocator< casadi_int > >
        colind(GenDM self, casadi_int col) -> casadi_int


        Get the sparsity pattern. See the Sparsity class for details.


        """
        return _casadi.GenDM_colind(self, *args)

    def sparsity(self, *args) -> "casadi::Sparsity const":
        r"""
        sparsity(GenDM self) -> Sparsity


        Get the sparsity pattern.


        """
        return _casadi.GenDM_sparsity(self, *args)

    @staticmethod
    def sym(*args) -> "std::vector< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >,std::allocator< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > > >":
        r"""
        sym(std::string const & name, casadi_int nrow=1, casadi_int ncol=1) -> DM
        sym(std::string const & name, std::pair< casadi_int,casadi_int > const & rc) -> DM
        sym(std::string const & name, Sparsity sp) -> DM
        sym(std::string const & name, Sparsity sp, casadi_int p) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
        sym(std::string const & name, casadi_int nrow, casadi_int ncol, casadi_int p) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
        sym(std::string const & name, Sparsity sp, casadi_int p, casadi_int r) -> std::vector< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >,std::allocator< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > > >
        sym(std::string const & name, casadi_int nrow, casadi_int ncol, casadi_int p, casadi_int r) -> std::vector< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >,std::allocator< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > > >


        Create a vector of length r of vectors of length p with nrow-by-ncol
        symbolic primitives.


        """
        return _casadi.GenDM_sym(*args)

    @staticmethod
    def zeros(*args) -> "casadi::Matrix< double >":
        r"""
        zeros(casadi_int nrow=1, casadi_int ncol=1) -> DM
        zeros(Sparsity sp) -> DM
        zeros(std::pair< casadi_int,casadi_int > const & rc) -> DM


        Create a dense matrix or a matrix with specified sparsity with all entries
        zero.


        """
        return _casadi.GenDM_zeros(*args)

    @staticmethod
    def ones(*args) -> "casadi::Matrix< double >":
        r"""
        ones(casadi_int nrow=1, casadi_int ncol=1) -> DM
        ones(Sparsity sp) -> DM
        ones(std::pair< casadi_int,casadi_int > const & rc) -> DM


        Create a dense matrix or a matrix with specified sparsity with all entries
        one.


        """
        return _casadi.GenDM_ones(*args)

    def __init__(self, *args):
        r"""
        __init__(GenDM self) -> GenDM
        __init__(GenDM self, GenDM other) -> GenDM
        """
        _casadi.GenDM_swiginit(self, _casadi.new_GenDM(*args))
    __swig_destroy__ = _casadi.delete_GenDM

# Register GenDM in _casadi:
_casadi.GenDM_swigregister(GenDM)

def GenDM_sym(*args) -> "std::vector< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >,std::allocator< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > > >":
    r"""
    GenDM_sym(std::string const & name, casadi_int nrow=1, casadi_int ncol=1) -> DM
    GenDM_sym(std::string const & name, std::pair< casadi_int,casadi_int > const & rc) -> DM
    GenDM_sym(std::string const & name, Sparsity sp) -> DM
    GenDM_sym(std::string const & name, Sparsity sp, casadi_int p) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
    GenDM_sym(std::string const & name, casadi_int nrow, casadi_int ncol, casadi_int p) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
    GenDM_sym(std::string const & name, Sparsity sp, casadi_int p, casadi_int r) -> std::vector< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >,std::allocator< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > > >
    GenDM_sym(std::string const & name, casadi_int nrow, casadi_int ncol, casadi_int p, casadi_int r) -> std::vector< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >,std::allocator< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > > >


    Create a vector of length r of vectors of length p with nrow-by-ncol
    symbolic primitives.


    """
    return _casadi.GenDM_sym(*args)

def GenDM_zeros(*args) -> "casadi::Matrix< double >":
    r"""
    GenDM_zeros(casadi_int nrow=1, casadi_int ncol=1) -> DM
    GenDM_zeros(Sparsity sp) -> DM
    GenDM_zeros(std::pair< casadi_int,casadi_int > const & rc) -> DM


    Create a dense matrix or a matrix with specified sparsity with all entries
    zero.


    """
    return _casadi.GenDM_zeros(*args)

def GenDM_ones(*args) -> "casadi::Matrix< double >":
    r"""
    GenDM_ones(casadi_int nrow=1, casadi_int ncol=1) -> DM
    GenDM_ones(Sparsity sp) -> DM
    GenDM_ones(std::pair< casadi_int,casadi_int > const & rc) -> DM


    Create a dense matrix or a matrix with specified sparsity with all entries
    one.


    """
    return _casadi.GenDM_ones(*args)

class GenSX(GenericMatrixCommon, SparsityInterfaceCommon):
    r"""Proxy of C++ casadi::GenericMatrix< casadi::Matrix< casadi::SXElem > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def nnz(self, *args) -> "casadi_int":
        r"""
        nnz(GenSX self) -> casadi_int


        Get the number of (structural) non-zero elements.


        """
        return _casadi.GenSX_nnz(self, *args)

    def nnz_lower(self, *args) -> "casadi_int":
        r"""
        nnz_lower(GenSX self) -> casadi_int


        Get the number of non-zeros in the lower triangular half.


        """
        return _casadi.GenSX_nnz_lower(self, *args)

    def nnz_upper(self, *args) -> "casadi_int":
        r"""
        nnz_upper(GenSX self) -> casadi_int


        Get the number of non-zeros in the upper triangular half.


        """
        return _casadi.GenSX_nnz_upper(self, *args)

    def nnz_diag(self, *args) -> "casadi_int":
        r"""
        nnz_diag(GenSX self) -> casadi_int


        Get get the number of non-zeros on the diagonal.


        """
        return _casadi.GenSX_nnz_diag(self, *args)

    def numel(self, *args) -> "casadi_int":
        r"""
        numel(GenSX self) -> casadi_int


        Get the number of elements.


        """
        return _casadi.GenSX_numel(self, *args)

    def size1(self, *args) -> "casadi_int":
        r"""
        size1(GenSX self) -> casadi_int


        Get the first dimension (i.e. number of rows)


        """
        return _casadi.GenSX_size1(self, *args)

    def rows(self, *args) -> "casadi_int":
        r"""
        rows(GenSX self) -> casadi_int


        Get the number of rows, Octave-style syntax.


        """
        return _casadi.GenSX_rows(self, *args)

    def size2(self, *args) -> "casadi_int":
        r"""
        size2(GenSX self) -> casadi_int


        Get the second dimension (i.e. number of columns)


        """
        return _casadi.GenSX_size2(self, *args)

    def columns(self, *args) -> "casadi_int":
        r"""
        columns(GenSX self) -> casadi_int


        Get the number of columns, Octave-style syntax.


        """
        return _casadi.GenSX_columns(self, *args)

    def dim(self, *args) -> "std::string":
        r"""
        dim(GenSX self, bool with_nz=False) -> std::string


        Get string representation of dimensions. The representation is e.g. "4x5"
        or "4x5,10nz".


        """
        return _casadi.GenSX_dim(self, *args)

    def size(self, *args) -> "casadi_int":
        r"""
        size(GenSX self) -> std::pair< casadi_int,casadi_int >
        size(GenSX self, casadi_int axis) -> casadi_int


        Get the size along a particular dimensions.


        """
        return _casadi.GenSX_size(self, *args)

    def is_empty(self, *args) -> "bool":
        r"""
        is_empty(GenSX self, bool both=False) -> bool


        Check if the sparsity is empty, i.e. if one of the dimensions is zero (or
        optionally both dimensions)


        """
        return _casadi.GenSX_is_empty(self, *args)

    def is_dense(self, *args) -> "bool":
        r"""
        is_dense(GenSX self) -> bool


        Check if the matrix expression is dense.


        """
        return _casadi.GenSX_is_dense(self, *args)

    def is_scalar(self, *args) -> "bool":
        r"""
        is_scalar(GenSX self, bool scalar_and_dense=False) -> bool


        Check if the matrix expression is scalar.


        """
        return _casadi.GenSX_is_scalar(self, *args)

    def is_square(self, *args) -> "bool":
        r"""
        is_square(GenSX self) -> bool


        Check if the matrix expression is square.


        """
        return _casadi.GenSX_is_square(self, *args)

    def is_vector(self, *args) -> "bool":
        r"""
        is_vector(GenSX self) -> bool


        Check if the matrix is a row or column vector.


        """
        return _casadi.GenSX_is_vector(self, *args)

    def is_row(self, *args) -> "bool":
        r"""
        is_row(GenSX self) -> bool


        Check if the matrix is a row vector (i.e. size1()==1)


        """
        return _casadi.GenSX_is_row(self, *args)

    def is_column(self, *args) -> "bool":
        r"""
        is_column(GenSX self) -> bool


        Check if the matrix is a column vector (i.e. size2()==1)


        """
        return _casadi.GenSX_is_column(self, *args)

    def is_triu(self, *args) -> "bool":
        r"""
        is_triu(GenSX self) -> bool


        Check if the matrix is upper triangular.


        """
        return _casadi.GenSX_is_triu(self, *args)

    def is_tril(self, *args) -> "bool":
        r"""
        is_tril(GenSX self) -> bool


        Check if the matrix is lower triangular.


        """
        return _casadi.GenSX_is_tril(self, *args)

    def row(self, *args) -> "casadi_int":
        r"""
        row(GenSX self) -> std::vector< casadi_int,std::allocator< casadi_int > >
        row(GenSX self, casadi_int el) -> casadi_int


        Get the sparsity pattern. See the Sparsity class for details.


        """
        return _casadi.GenSX_row(self, *args)

    def colind(self, *args) -> "casadi_int":
        r"""
        colind(GenSX self) -> std::vector< casadi_int,std::allocator< casadi_int > >
        colind(GenSX self, casadi_int col) -> casadi_int


        Get the sparsity pattern. See the Sparsity class for details.


        """
        return _casadi.GenSX_colind(self, *args)

    def sparsity(self, *args) -> "casadi::Sparsity const":
        r"""
        sparsity(GenSX self) -> Sparsity


        Get the sparsity pattern.


        """
        return _casadi.GenSX_sparsity(self, *args)

    @staticmethod
    def sym(*args) -> "std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > >":
        r"""
        sym(std::string const & name, casadi_int nrow=1, casadi_int ncol=1) -> SX
        sym(std::string const & name, std::pair< casadi_int,casadi_int > const & rc) -> SX
        sym(std::string const & name, Sparsity sp) -> SX
        sym(std::string const & name, Sparsity sp, casadi_int p) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >
        sym(std::string const & name, casadi_int nrow, casadi_int ncol, casadi_int p) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >
        sym(std::string const & name, Sparsity sp, casadi_int p, casadi_int r) -> std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > >
        sym(std::string const & name, casadi_int nrow, casadi_int ncol, casadi_int p, casadi_int r) -> std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > >


        Create a vector of length r of vectors of length p with nrow-by-ncol
        symbolic primitives.


        """
        return _casadi.GenSX_sym(*args)

    @staticmethod
    def zeros(*args) -> "casadi::Matrix< casadi::SXElem >":
        r"""
        zeros(casadi_int nrow=1, casadi_int ncol=1) -> SX
        zeros(Sparsity sp) -> SX
        zeros(std::pair< casadi_int,casadi_int > const & rc) -> SX


        Create a dense matrix or a matrix with specified sparsity with all entries
        zero.


        """
        return _casadi.GenSX_zeros(*args)

    @staticmethod
    def ones(*args) -> "casadi::Matrix< casadi::SXElem >":
        r"""
        ones(casadi_int nrow=1, casadi_int ncol=1) -> SX
        ones(Sparsity sp) -> SX
        ones(std::pair< casadi_int,casadi_int > const & rc) -> SX


        Create a dense matrix or a matrix with specified sparsity with all entries
        one.


        """
        return _casadi.GenSX_ones(*args)

    def __init__(self, *args):
        r"""
        __init__(GenSX self) -> GenSX
        __init__(GenSX self, GenSX other) -> GenSX
        """
        _casadi.GenSX_swiginit(self, _casadi.new_GenSX(*args))
    __swig_destroy__ = _casadi.delete_GenSX

# Register GenSX in _casadi:
_casadi.GenSX_swigregister(GenSX)

def GenSX_sym(*args) -> "std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > >":
    r"""
    GenSX_sym(std::string const & name, casadi_int nrow=1, casadi_int ncol=1) -> SX
    GenSX_sym(std::string const & name, std::pair< casadi_int,casadi_int > const & rc) -> SX
    GenSX_sym(std::string const & name, Sparsity sp) -> SX
    GenSX_sym(std::string const & name, Sparsity sp, casadi_int p) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >
    GenSX_sym(std::string const & name, casadi_int nrow, casadi_int ncol, casadi_int p) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >
    GenSX_sym(std::string const & name, Sparsity sp, casadi_int p, casadi_int r) -> std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > >
    GenSX_sym(std::string const & name, casadi_int nrow, casadi_int ncol, casadi_int p, casadi_int r) -> std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > >


    Create a vector of length r of vectors of length p with nrow-by-ncol
    symbolic primitives.


    """
    return _casadi.GenSX_sym(*args)

def GenSX_zeros(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    GenSX_zeros(casadi_int nrow=1, casadi_int ncol=1) -> SX
    GenSX_zeros(Sparsity sp) -> SX
    GenSX_zeros(std::pair< casadi_int,casadi_int > const & rc) -> SX


    Create a dense matrix or a matrix with specified sparsity with all entries
    zero.


    """
    return _casadi.GenSX_zeros(*args)

def GenSX_ones(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    GenSX_ones(casadi_int nrow=1, casadi_int ncol=1) -> SX
    GenSX_ones(Sparsity sp) -> SX
    GenSX_ones(std::pair< casadi_int,casadi_int > const & rc) -> SX


    Create a dense matrix or a matrix with specified sparsity with all entries
    one.


    """
    return _casadi.GenSX_ones(*args)

class GenMX(GenericMatrixCommon, SparsityInterfaceCommon):
    r"""Proxy of C++ casadi::GenericMatrix< casadi::MX > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def nnz(self, *args) -> "casadi_int":
        r"""
        nnz(GenMX self) -> casadi_int


        Get the number of (structural) non-zero elements.


        """
        return _casadi.GenMX_nnz(self, *args)

    def nnz_lower(self, *args) -> "casadi_int":
        r"""
        nnz_lower(GenMX self) -> casadi_int


        Get the number of non-zeros in the lower triangular half.


        """
        return _casadi.GenMX_nnz_lower(self, *args)

    def nnz_upper(self, *args) -> "casadi_int":
        r"""
        nnz_upper(GenMX self) -> casadi_int


        Get the number of non-zeros in the upper triangular half.


        """
        return _casadi.GenMX_nnz_upper(self, *args)

    def nnz_diag(self, *args) -> "casadi_int":
        r"""
        nnz_diag(GenMX self) -> casadi_int


        Get get the number of non-zeros on the diagonal.


        """
        return _casadi.GenMX_nnz_diag(self, *args)

    def numel(self, *args) -> "casadi_int":
        r"""
        numel(GenMX self) -> casadi_int


        Get the number of elements.


        """
        return _casadi.GenMX_numel(self, *args)

    def size1(self, *args) -> "casadi_int":
        r"""
        size1(GenMX self) -> casadi_int


        Get the first dimension (i.e. number of rows)


        """
        return _casadi.GenMX_size1(self, *args)

    def rows(self, *args) -> "casadi_int":
        r"""
        rows(GenMX self) -> casadi_int


        Get the number of rows, Octave-style syntax.


        """
        return _casadi.GenMX_rows(self, *args)

    def size2(self, *args) -> "casadi_int":
        r"""
        size2(GenMX self) -> casadi_int


        Get the second dimension (i.e. number of columns)


        """
        return _casadi.GenMX_size2(self, *args)

    def columns(self, *args) -> "casadi_int":
        r"""
        columns(GenMX self) -> casadi_int


        Get the number of columns, Octave-style syntax.


        """
        return _casadi.GenMX_columns(self, *args)

    def dim(self, *args) -> "std::string":
        r"""
        dim(GenMX self, bool with_nz=False) -> std::string


        Get string representation of dimensions. The representation is e.g. "4x5"
        or "4x5,10nz".


        """
        return _casadi.GenMX_dim(self, *args)

    def size(self, *args) -> "casadi_int":
        r"""
        size(GenMX self) -> std::pair< casadi_int,casadi_int >
        size(GenMX self, casadi_int axis) -> casadi_int


        Get the size along a particular dimensions.


        """
        return _casadi.GenMX_size(self, *args)

    def is_empty(self, *args) -> "bool":
        r"""
        is_empty(GenMX self, bool both=False) -> bool


        Check if the sparsity is empty, i.e. if one of the dimensions is zero (or
        optionally both dimensions)


        """
        return _casadi.GenMX_is_empty(self, *args)

    def is_dense(self, *args) -> "bool":
        r"""
        is_dense(GenMX self) -> bool


        Check if the matrix expression is dense.


        """
        return _casadi.GenMX_is_dense(self, *args)

    def is_scalar(self, *args) -> "bool":
        r"""
        is_scalar(GenMX self, bool scalar_and_dense=False) -> bool


        Check if the matrix expression is scalar.


        """
        return _casadi.GenMX_is_scalar(self, *args)

    def is_square(self, *args) -> "bool":
        r"""
        is_square(GenMX self) -> bool


        Check if the matrix expression is square.


        """
        return _casadi.GenMX_is_square(self, *args)

    def is_vector(self, *args) -> "bool":
        r"""
        is_vector(GenMX self) -> bool


        Check if the matrix is a row or column vector.


        """
        return _casadi.GenMX_is_vector(self, *args)

    def is_row(self, *args) -> "bool":
        r"""
        is_row(GenMX self) -> bool


        Check if the matrix is a row vector (i.e. size1()==1)


        """
        return _casadi.GenMX_is_row(self, *args)

    def is_column(self, *args) -> "bool":
        r"""
        is_column(GenMX self) -> bool


        Check if the matrix is a column vector (i.e. size2()==1)


        """
        return _casadi.GenMX_is_column(self, *args)

    def is_triu(self, *args) -> "bool":
        r"""
        is_triu(GenMX self) -> bool


        Check if the matrix is upper triangular.


        """
        return _casadi.GenMX_is_triu(self, *args)

    def is_tril(self, *args) -> "bool":
        r"""
        is_tril(GenMX self) -> bool


        Check if the matrix is lower triangular.


        """
        return _casadi.GenMX_is_tril(self, *args)

    def row(self, *args) -> "casadi_int":
        r"""
        row(GenMX self) -> std::vector< casadi_int,std::allocator< casadi_int > >
        row(GenMX self, casadi_int el) -> casadi_int


        Get the sparsity pattern. See the Sparsity class for details.


        """
        return _casadi.GenMX_row(self, *args)

    def colind(self, *args) -> "casadi_int":
        r"""
        colind(GenMX self) -> std::vector< casadi_int,std::allocator< casadi_int > >
        colind(GenMX self, casadi_int col) -> casadi_int


        Get the sparsity pattern. See the Sparsity class for details.


        """
        return _casadi.GenMX_colind(self, *args)

    def sparsity(self, *args) -> "casadi::Sparsity const":
        r"""
        sparsity(GenMX self) -> Sparsity


        Get the sparsity pattern.


        """
        return _casadi.GenMX_sparsity(self, *args)

    @staticmethod
    def sym(*args) -> "std::vector< std::vector< casadi::MX,std::allocator< casadi::MX > >,std::allocator< std::vector< casadi::MX,std::allocator< casadi::MX > > > >":
        r"""
        sym(std::string const & name, casadi_int nrow=1, casadi_int ncol=1) -> MX
        sym(std::string const & name, std::pair< casadi_int,casadi_int > const & rc) -> MX
        sym(std::string const & name, Sparsity sp) -> MX
        sym(std::string const & name, Sparsity sp, casadi_int p) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
        sym(std::string const & name, casadi_int nrow, casadi_int ncol, casadi_int p) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
        sym(std::string const & name, Sparsity sp, casadi_int p, casadi_int r) -> std::vector< std::vector< casadi::MX,std::allocator< casadi::MX > >,std::allocator< std::vector< casadi::MX,std::allocator< casadi::MX > > > >
        sym(std::string const & name, casadi_int nrow, casadi_int ncol, casadi_int p, casadi_int r) -> std::vector< std::vector< casadi::MX,std::allocator< casadi::MX > >,std::allocator< std::vector< casadi::MX,std::allocator< casadi::MX > > > >


        Create a vector of length r of vectors of length p with nrow-by-ncol
        symbolic primitives.


        """
        return _casadi.GenMX_sym(*args)

    @staticmethod
    def zeros(*args) -> "casadi::MX":
        r"""
        zeros(casadi_int nrow=1, casadi_int ncol=1) -> MX
        zeros(Sparsity sp) -> MX
        zeros(std::pair< casadi_int,casadi_int > const & rc) -> MX


        Create a dense matrix or a matrix with specified sparsity with all entries
        zero.


        """
        return _casadi.GenMX_zeros(*args)

    @staticmethod
    def ones(*args) -> "casadi::MX":
        r"""
        ones(casadi_int nrow=1, casadi_int ncol=1) -> MX
        ones(Sparsity sp) -> MX
        ones(std::pair< casadi_int,casadi_int > const & rc) -> MX


        Create a dense matrix or a matrix with specified sparsity with all entries
        one.


        """
        return _casadi.GenMX_ones(*args)

    def __init__(self, *args):
        r"""
        __init__(GenMX self) -> GenMX
        __init__(GenMX self, GenMX other) -> GenMX
        """
        _casadi.GenMX_swiginit(self, _casadi.new_GenMX(*args))
    __swig_destroy__ = _casadi.delete_GenMX

# Register GenMX in _casadi:
_casadi.GenMX_swigregister(GenMX)

def GenMX_sym(*args) -> "std::vector< std::vector< casadi::MX,std::allocator< casadi::MX > >,std::allocator< std::vector< casadi::MX,std::allocator< casadi::MX > > > >":
    r"""
    GenMX_sym(std::string const & name, casadi_int nrow=1, casadi_int ncol=1) -> MX
    GenMX_sym(std::string const & name, std::pair< casadi_int,casadi_int > const & rc) -> MX
    GenMX_sym(std::string const & name, Sparsity sp) -> MX
    GenMX_sym(std::string const & name, Sparsity sp, casadi_int p) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
    GenMX_sym(std::string const & name, casadi_int nrow, casadi_int ncol, casadi_int p) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
    GenMX_sym(std::string const & name, Sparsity sp, casadi_int p, casadi_int r) -> std::vector< std::vector< casadi::MX,std::allocator< casadi::MX > >,std::allocator< std::vector< casadi::MX,std::allocator< casadi::MX > > > >
    GenMX_sym(std::string const & name, casadi_int nrow, casadi_int ncol, casadi_int p, casadi_int r) -> std::vector< std::vector< casadi::MX,std::allocator< casadi::MX > >,std::allocator< std::vector< casadi::MX,std::allocator< casadi::MX > > > >


    Create a vector of length r of vectors of length p with nrow-by-ncol
    symbolic primitives.


    """
    return _casadi.GenMX_sym(*args)

def GenMX_zeros(*args) -> "casadi::MX":
    r"""
    GenMX_zeros(casadi_int nrow=1, casadi_int ncol=1) -> MX
    GenMX_zeros(Sparsity sp) -> MX
    GenMX_zeros(std::pair< casadi_int,casadi_int > const & rc) -> MX


    Create a dense matrix or a matrix with specified sparsity with all entries
    zero.


    """
    return _casadi.GenMX_zeros(*args)

def GenMX_ones(*args) -> "casadi::MX":
    r"""
    GenMX_ones(casadi_int nrow=1, casadi_int ncol=1) -> MX
    GenMX_ones(Sparsity sp) -> MX
    GenMX_ones(std::pair< casadi_int,casadi_int > const & rc) -> MX


    Create a dense matrix or a matrix with specified sparsity with all entries
    one.


    """
    return _casadi.GenMX_ones(*args)

class GenericExpressionCommon(object):
    r"""Proxy of C++ casadi::GenericExpressionCommon class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __hash__(self):
      try:
        return self.element_hash()
      except:
        return SharedObject.__hash__(self)
    def __matmul__(x, y): return _casadi.mtimes(x, y)
    def __rmatmul__(x, y): return _casadi.mtimes(y, x)


    def __add__(x, y): return _casadi.plus(x, y)
    def __radd__(x, y): return _casadi.plus(y, x)
    def __sub__(x, y): return _casadi.minus(x, y)
    def __rsub__(x, y): return _casadi.minus(y, x)
    def __mul__(x, y): return _casadi.times(x, y)
    def __rmul__(x, y): return _casadi.times(y, x)
    def __div__(x, y): return _casadi.rdivide(x, y)
    def __rdiv__(x, y): return _casadi.rdivide(y, x)
    def __truediv__(x, y): return _casadi.rdivide(x, y)
    def __rtruediv__(x, y): return _casadi.rdivide(y, x)
    def __lt__(x, y): return _casadi.lt(x, y)
    def __rlt__(x, y): return _casadi.lt(y, x)
    def __le__(x, y): return _casadi.le(x, y)
    def __rle__(x, y): return _casadi.le(y, x)
    def __gt__(x, y): return _casadi.lt(y, x)
    def __rgt__(x, y): return _casadi.lt(x, y)
    def __ge__(x, y): return _casadi.le(y, x)
    def __rge__(x, y): return _casadi.le(x, y)
    def __eq__(x, y): return _casadi.eq(x, y)
    def __req__(x, y): return _casadi.eq(y, x)
    def __ne__(x, y): return _casadi.ne(x, y)
    def __rne__(x, y): return _casadi.ne(y, x)
    def __pow__(x, n): return _casadi.power(x, n)
    def __rpow__(n, x): return _casadi.power(x, n)
    def __arctan2__(x, y): return _casadi.atan2(x, y)
    def __rarctan2__(y, x): return _casadi.atan2(x, y)
    def fmin(x, y): return _casadi.fmin(x, y)
    def fmax(x, y): return _casadi.fmax(x, y)
    def __fmin__(x, y): return _casadi.fmin(x, y)
    def __rfmin__(y, x): return _casadi.fmin(x, y)
    def __fmax__(x, y): return _casadi.fmax(x, y)
    def __rfmax__(y, x): return _casadi.fmax(x, y)
    def logic_and(x, y): return _casadi.logic_and(x, y)
    def logic_or(x, y): return _casadi.logic_or(x, y)
    def fabs(x): return _casadi.fabs(x)
    def sqrt(x): return _casadi.sqrt(x)
    def sin(x): return _casadi.sin(x)
    def cos(x): return _casadi.cos(x)
    def tan(x): return _casadi.tan(x)
    def arcsin(x): return _casadi.asin(x)
    def arccos(x): return _casadi.acos(x)
    def arctan(x): return _casadi.atan(x)
    def sinh(x): return _casadi.sinh(x)
    def cosh(x): return _casadi.cosh(x)
    def tanh(x): return _casadi.tanh(x)
    def arcsinh(x): return _casadi.asinh(x)
    def arccosh(x): return _casadi.acosh(x)
    def arctanh(x): return _casadi.atanh(x)
    def exp(x): return _casadi.exp(x)
    def log(x): return _casadi.log(x)
    def log10(x): return _casadi.log10(x)
    def floor(x): return _casadi.floor(x)
    def ceil(x): return _casadi.ceil(x)
    def erf(x): return _casadi.erf(x)
    def sign(x): return _casadi.sign(x)
    def fmod(x, y): return _casadi.mod(x, y)
    def __copysign__(x, y): return _casadi.copysign(x, y)
    def __rcopysign__(y, x): return _casadi.copysign(x, y)
    def copysign(x, y): return _casadi.copysign(x, y)
    def rcopysign(y, x): return _casadi.copysign(x, y)
    def __constpow__(x, y): return _casadi.constpow(x, y)
    def __rconstpow__(y, x): return _casadi.constpow(x, y)
    def constpow(x, y): return _casadi.constpow(x, y)
    def rconstpow(y, x): return _casadi.constpow(x, y)


    def __init__(self, *args):
        r"""
        __init__(GenericExpressionCommon self) -> GenericExpressionCommon
        __init__(GenericExpressionCommon self, GenericExpressionCommon other) -> GenericExpressionCommon
        """
        _casadi.GenericExpressionCommon_swiginit(self, _casadi.new_GenericExpressionCommon(*args))
    __swig_destroy__ = _casadi.delete_GenericExpressionCommon

# Register GenericExpressionCommon in _casadi:
_casadi.GenericExpressionCommon_swigregister(GenericExpressionCommon)

IS_GLOBAL = _casadi.IS_GLOBAL

IS_MEMBER = _casadi.IS_MEMBER

IS_SPARSITY = _casadi.IS_SPARSITY

IS_DMATRIX = _casadi.IS_DMATRIX

IS_IMATRIX = _casadi.IS_IMATRIX

IS_SX = _casadi.IS_SX

IS_MX = _casadi.IS_MX

IS_DOUBLE = _casadi.IS_DOUBLE

class MatrixCommon(object):
    r"""


    Sparse matrix class. SX and DM are specializations.

    General sparse matrix class that is designed with the idea that "everything
    is a matrix", that is, also scalars and vectors. This philosophy makes it
    easy to use and to interface in particularly with Python and Matlab/Octave.
    Index starts with 0. Index vec happens as follows: (rr, cc) -> k =
    rr+cc*size1() Vectors are column vectors.  The storage format is Compressed
    Column Storage (CCS), similar to that used for sparse matrices in Matlab,
    but unlike this format, we do allow for elements to be structurally non-zero
    but numerically zero.  Matrix<Scalar> is polymorphic with a
    std::vector<Scalar> that contain all non-identical-zero elements. The
    sparsity can be accessed with Sparsity& sparsity() Joel Andersson

    C++ includes: casadi_common.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(MatrixCommon self) -> MatrixCommon
        __init__(MatrixCommon self, MatrixCommon other) -> MatrixCommon
        """
        _casadi.MatrixCommon_swiginit(self, _casadi.new_MatrixCommon(*args))
    __swig_destroy__ = _casadi.delete_MatrixCommon

# Register MatrixCommon in _casadi:
_casadi.MatrixCommon_swigregister(MatrixCommon)

class DM(MatrixCommon, GenericExpressionCommon, GenDM, PrintableCommon):
    r"""Proxy of C++ casadi::Matrix< double > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def sanity_check(self, *args) -> "void":
        r"""
        sanity_check(DM self, bool complete=False)


        [DEPRECATED] Correctness is checked during construction


        """
        return _casadi.DM_sanity_check(self, *args)

    def has_nz(self, *args) -> "bool":
        r"""
        has_nz(DM self, casadi_int rr, casadi_int cc) -> bool


        Returns true if the matrix has a non-zero at location rr, cc.


        """
        return _casadi.DM_has_nz(self, *args)

    def __bool__(self, *args) -> "bool":
        r"""
        __bool__(DM self) -> bool


        Returns the truth value of a Matrix.


        """
        return _casadi.DM___bool__(self, *args)

    def get(self, *args) -> "void":
        r"""
        get(DM self, bool ind1, Slice rr)
        get(DM self, bool ind1, casadi::Matrix< casadi_int > const & rr)
        get(DM self, bool ind1, Sparsity sp)
        get(DM self, bool ind1, Slice rr, Slice cc)
        get(DM self, bool ind1, Slice rr, casadi::Matrix< casadi_int > const & cc)
        get(DM self, bool ind1, casadi::Matrix< casadi_int > const & rr, Slice cc)
        get(DM self, bool ind1, casadi::Matrix< casadi_int > const & rr, casadi::Matrix< casadi_int > const & cc)
        """
        return _casadi.DM_get(self, *args)

    def set(self, *args) -> "void":
        r"""
        set(DM self, DM m, bool ind1, Slice rr)
        set(DM self, DM m, bool ind1, casadi::Matrix< casadi_int > const & rr)
        set(DM self, DM m, bool ind1, Sparsity sp)
        set(DM self, DM m, bool ind1, Slice rr, Slice cc)
        set(DM self, DM m, bool ind1, Slice rr, casadi::Matrix< casadi_int > const & cc)
        set(DM self, DM m, bool ind1, casadi::Matrix< casadi_int > const & rr, Slice cc)
        set(DM self, DM m, bool ind1, casadi::Matrix< casadi_int > const & rr, casadi::Matrix< casadi_int > const & cc)
        """
        return _casadi.DM_set(self, *args)

    def get_nz(self, *args) -> "void":
        r"""
        get_nz(DM self, bool ind1, Slice k)
        get_nz(DM self, bool ind1, casadi::Matrix< casadi_int > const & k)
        """
        return _casadi.DM_get_nz(self, *args)

    def set_nz(self, *args) -> "void":
        r"""
        set_nz(DM self, DM m, bool ind1, Slice k)
        set_nz(DM self, DM m, bool ind1, casadi::Matrix< casadi_int > const & k)
        """
        return _casadi.DM_set_nz(self, *args)

    def __pos__(self, *args) -> "casadi::Matrix< double >":
        r"""__pos__(DM self) -> DM"""
        return _casadi.DM___pos__(self, *args)

    def __neg__(self, *args) -> "casadi::Matrix< double >":
        r"""__neg__(DM self) -> DM"""
        return _casadi.DM___neg__(self, *args)

    @staticmethod
    def binary(*args) -> "casadi::Matrix< double >":
        r"""binary(casadi_int op, DM x, DM y) -> DM"""
        return _casadi.DM_binary(*args)

    @staticmethod
    def unary(*args) -> "casadi::Matrix< double >":
        r"""unary(casadi_int op, DM x) -> DM"""
        return _casadi.DM_unary(*args)

    @staticmethod
    def scalar_matrix(*args) -> "casadi::Matrix< double >":
        r"""scalar_matrix(casadi_int op, DM x, DM y) -> DM"""
        return _casadi.DM_scalar_matrix(*args)

    @staticmethod
    def matrix_scalar(*args) -> "casadi::Matrix< double >":
        r"""matrix_scalar(casadi_int op, DM x, DM y) -> DM"""
        return _casadi.DM_matrix_scalar(*args)

    @staticmethod
    def matrix_matrix(*args) -> "casadi::Matrix< double >":
        r"""matrix_matrix(casadi_int op, DM x, DM y) -> DM"""
        return _casadi.DM_matrix_matrix(*args)

    def printme(self, *args) -> "casadi::Matrix< double >":
        r"""printme(DM self, DM y) -> DM"""
        return _casadi.DM_printme(self, *args)

    @staticmethod
    def set_max_depth(*args) -> "void":
        r"""set_max_depth(casadi_int eq_depth=1)"""
        return _casadi.DM_set_max_depth(*args)

    @staticmethod
    def get_max_depth(*args) -> "casadi_int":
        r"""get_max_depth() -> casadi_int"""
        return _casadi.DM_get_max_depth(*args)

    @staticmethod
    def get_input(*args) -> "std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >":
        r"""get_input(Function f) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >"""
        return _casadi.DM_get_input(*args)

    @staticmethod
    def get_free(*args) -> "std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >":
        r"""get_free(Function f) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >"""
        return _casadi.DM_get_free(*args)

    @staticmethod
    def type_name(*args) -> "std::string":
        r"""type_name() -> std::string"""
        return _casadi.DM_type_name(*args)

    def print_split(self, *args) -> "void":
        r"""
        print_split(DM self)


        Get strings corresponding to the nonzeros and the interdependencies.


        """
        return _casadi.DM_print_split(self, *args)

    def disp(self, *args) -> "void":
        r"""
        disp(DM self, bool more=False)


        Print a representation of the object.


        """
        return _casadi.DM_disp(self, *args)

    def str(self, *args) -> "std::string":
        r"""
        str(DM self, bool more=False) -> std::string


        Get string representation.


        """
        return _casadi.DM_str(self, *args)

    def print_scalar(self, *args) -> "void":
        r"""
        print_scalar(DM self)


        Print scalar.


        """
        return _casadi.DM_print_scalar(self, *args)

    def print_vector(self, *args) -> "void":
        r"""
        print_vector(DM self, bool truncate=True)


        Print vector-style.


        """
        return _casadi.DM_print_vector(self, *args)

    def print_dense(self, *args) -> "void":
        r"""
        print_dense(DM self, bool truncate=True)


        Print dense matrix-stype.


        """
        return _casadi.DM_print_dense(self, *args)

    def print_sparse(self, *args) -> "void":
        r"""
        print_sparse(DM self, bool truncate=True)


        Print sparse matrix style.


        """
        return _casadi.DM_print_sparse(self, *args)

    def clear(self, *args) -> "void":
        r"""clear(DM self)"""
        return _casadi.DM_clear(self, *args)

    def resize(self, *args) -> "void":
        r"""resize(DM self, casadi_int nrow, casadi_int ncol)"""
        return _casadi.DM_resize(self, *args)

    def reserve(self, *args) -> "void":
        r"""
        reserve(DM self, casadi_int nnz)
        reserve(DM self, casadi_int nnz, casadi_int ncol)
        """
        return _casadi.DM_reserve(self, *args)

    def erase(self, *args) -> "void":
        r"""
        erase(DM self, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, std::vector< casadi_int,std::allocator< casadi_int > > const & cc, bool ind1=False)
        erase(DM self, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, bool ind1=False)


        Erase a submatrix (leaving structural zeros in its place) Erase elements of
        a matrix.


        """
        return _casadi.DM_erase(self, *args)

    def remove(self, *args) -> "void":
        r"""
        remove(DM self, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, std::vector< casadi_int,std::allocator< casadi_int > > const & cc)


        Remove columns and rows Remove/delete rows and/or columns of a matrix.


        """
        return _casadi.DM_remove(self, *args)

    def enlarge(self, *args) -> "void":
        r"""
        enlarge(DM self, casadi_int nrow, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, std::vector< casadi_int,std::allocator< casadi_int > > const & cc, bool ind1=False)


        Enlarge matrix Make the matrix larger by inserting empty rows and columns,
        keeping the existing non-zeros.


        """
        return _casadi.DM_enlarge(self, *args)

    def sparsity(self, *args) -> "casadi::Sparsity":
        r"""
        sparsity(DM self) -> Sparsity


        Get an owning reference to the sparsity pattern.


        """
        return _casadi.DM_sparsity(self, *args)

    @staticmethod
    def triplet(*args) -> "casadi::Matrix< double >":
        r"""
        triplet(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, DM d) -> DM
        triplet(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, DM d, casadi_int nrow, casadi_int ncol) -> DM
        triplet(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, DM d, std::pair< casadi_int,casadi_int > const & rc) -> DM
        """
        return _casadi.DM_triplet(*args)

    @staticmethod
    def inf(*args) -> "casadi::Matrix< double >":
        r"""
        inf(Sparsity sp) -> DM
        inf(casadi_int nrow=1, casadi_int ncol=1) -> DM
        inf(std::pair< casadi_int,casadi_int > const & rc) -> DM


        create a matrix with all inf


        """
        return _casadi.DM_inf(*args)

    @staticmethod
    def nan(*args) -> "casadi::Matrix< double >":
        r"""
        nan(Sparsity sp) -> DM
        nan(casadi_int nrow=1, casadi_int ncol=1) -> DM
        nan(std::pair< casadi_int,casadi_int > const & rc) -> DM


        create a matrix with all nan


        """
        return _casadi.DM_nan(*args)

    @staticmethod
    def eye(*args) -> "casadi::Matrix< double >":
        r"""eye(casadi_int n) -> DM"""
        return _casadi.DM_eye(*args)

    def element_hash(self, *args) -> "casadi_int":
        r"""element_hash(DM self) -> casadi_int"""
        return _casadi.DM_element_hash(self, *args)

    def is_regular(self, *args) -> "bool":
        r"""is_regular(DM self) -> bool"""
        return _casadi.DM_is_regular(self, *args)

    def is_smooth(self, *args) -> "bool":
        r"""is_smooth(DM self) -> bool"""
        return _casadi.DM_is_smooth(self, *args)

    def is_leaf(self, *args) -> "bool":
        r"""is_leaf(DM self) -> bool"""
        return _casadi.DM_is_leaf(self, *args)

    def is_commutative(self, *args) -> "bool":
        r"""is_commutative(DM self) -> bool"""
        return _casadi.DM_is_commutative(self, *args)

    def is_symbolic(self, *args) -> "bool":
        r"""is_symbolic(DM self) -> bool"""
        return _casadi.DM_is_symbolic(self, *args)

    def is_valid_input(self, *args) -> "bool":
        r"""is_valid_input(DM self) -> bool"""
        return _casadi.DM_is_valid_input(self, *args)

    def has_duplicates(self, *args) -> "bool":
        r"""has_duplicates(DM self) -> bool"""
        return _casadi.DM_has_duplicates(self, *args)

    def reset_input(self, *args) -> "void":
        r"""reset_input(DM self)"""
        return _casadi.DM_reset_input(self, *args)

    def is_constant(self, *args) -> "bool":
        r"""
        is_constant(DM self) -> bool


        Check if the matrix is constant (note that false negative answers are
        possible)


        """
        return _casadi.DM_is_constant(self, *args)

    def is_integer(self, *args) -> "bool":
        r"""
        is_integer(DM self) -> bool


        Check if the matrix is integer-valued (note that false negative answers are
        possible)


        """
        return _casadi.DM_is_integer(self, *args)

    def is_zero(self, *args) -> "bool":
        r"""
        is_zero(DM self) -> bool


        check if the matrix is 0 (note that false negative answers are possible)


        """
        return _casadi.DM_is_zero(self, *args)

    def is_one(self, *args) -> "bool":
        r"""
        is_one(DM self) -> bool


        check if the matrix is 1 (note that false negative answers are possible)


        """
        return _casadi.DM_is_one(self, *args)

    def is_minus_one(self, *args) -> "bool":
        r"""
        is_minus_one(DM self) -> bool


        check if the matrix is -1 (note that false negative answers are possible)


        """
        return _casadi.DM_is_minus_one(self, *args)

    def is_eye(self, *args) -> "bool":
        r"""
        is_eye(DM self) -> bool


        check if the matrix is an identity matrix (note that false negative answers
        are possible)


        """
        return _casadi.DM_is_eye(self, *args)

    def op(self, *args) -> "casadi_int":
        r"""op(DM self) -> casadi_int"""
        return _casadi.DM_op(self, *args)

    def is_op(self, *args) -> "bool":
        r"""is_op(DM self, casadi_int op) -> bool"""
        return _casadi.DM_is_op(self, *args)

    def has_zeros(self, *args) -> "bool":
        r"""
        has_zeros(DM self) -> bool


        Check if the matrix has any zero entries which are not structural zeros.


        """
        return _casadi.DM_has_zeros(self, *args)

    def nonzeros(self, *args) -> "std::vector< double,std::allocator< double > >":
        r"""
        nonzeros(DM self) -> std::vector< double,std::allocator< double > >


        Get all nonzeros.

        Implementation of Matrix::get_nonzeros (in public API)


        """
        return _casadi.DM_nonzeros(self, *args)

    def elements(self, *args) -> "std::vector< double,std::allocator< double > >":
        r"""
        elements(DM self) -> std::vector< double,std::allocator< double > >


        Get all elements.


        """
        return _casadi.DM_elements(self, *args)

    def __float__(self, *args) -> "double":
        r"""__float__(DM self) -> double"""
        return _casadi.DM___float__(self, *args)

    def __int__(self, *args) -> "casadi_int":
        r"""__int__(DM self) -> casadi_int"""
        return _casadi.DM___int__(self, *args)

    def name(self, *args) -> "std::string":
        r"""name(DM self) -> std::string"""
        return _casadi.DM_name(self, *args)

    def dep(self, *args) -> "casadi::Matrix< double >":
        r"""dep(DM self, casadi_int ch=0) -> DM"""
        return _casadi.DM_dep(self, *args)

    def n_dep(self, *args) -> "casadi_int":
        r"""n_dep(DM self) -> casadi_int"""
        return _casadi.DM_n_dep(self, *args)

    @staticmethod
    def set_precision(*args) -> "void":
        r"""
        set_precision(casadi_int precision)


        Set the 'precision, width & scientific' used in printing and serializing to
        streams.


        """
        return _casadi.DM_set_precision(*args)

    @staticmethod
    def set_width(*args) -> "void":
        r"""
        set_width(casadi_int width)


        Set the 'precision, width & scientific' used in printing and serializing to
        streams.


        """
        return _casadi.DM_set_width(*args)

    @staticmethod
    def set_scientific(*args) -> "void":
        r"""
        set_scientific(bool scientific)


        Set the 'precision, width & scientific' used in printing and serializing to
        streams.


        """
        return _casadi.DM_set_scientific(*args)

    @staticmethod
    def rng(*args) -> "void":
        r"""rng(casadi_int seed)"""
        return _casadi.DM_rng(*args)

    @staticmethod
    def rand(*args) -> "casadi::Matrix< double >":
        r"""
        rand(casadi_int nrow=1, casadi_int ncol=1) -> DM
        rand(Sparsity sp) -> DM
        rand(std::pair< casadi_int,casadi_int > const & rc) -> DM


        Create a matrix with uniformly distributed random numbers.


        """
        return _casadi.DM_rand(*args)

    def export_code(self, *args) -> "void":
        r"""
        export_code(DM self, std::string const & lang, casadi::Dict const & options=casadi::Dict())


        Export matrix in specific language.

        lang: only 'matlab' supported for now

        ::

          * options:
          *   inline: Indicates if you want everything on a single line (default: False)
          *   name: Name of exported variable (default: 'm')
          *   indent_level: Level of indentation (default: 0)
          *   spoof_zero: Replace numerical zero by a 1e-200 (default: false)
          *               might be needed for matlab sparse construct,
          *               which doesn't allow numerical zero
          * 




        """
        return _casadi.DM_export_code(self, *args)

    def info(self, *args) -> "casadi::Dict":
        r"""info(DM self) -> casadi::Dict"""
        return _casadi.DM_info(self, *args)

    def serialize(self, *args) -> "void":
        r"""
        serialize(DM self) -> std::string
        serialize(DM self, casadi::SerializingStream & s)


        Serialize an object.


        """
        return _casadi.DM_serialize(self, *args)

    @staticmethod
    def deserialize(*args) -> "casadi::Matrix< double >":
        r"""
        deserialize(std::istream & stream) -> DM
        deserialize(std::string const & s) -> DM
        deserialize(casadi::DeserializingStream & s) -> DM
        """
        return _casadi.DM_deserialize(*args)

    def to_file(self, *args) -> "void":
        r"""
        to_file(DM self, std::string const & filename, std::string const & format="")


        Export numerical matrix to file

        Supported formats:



        ::

          *   - .mtx   Matrix Market (sparse)
          *   - .txt   Ascii full precision representation (sparse)
          *            Whitespace separated, aligned.
          *            Comments with # % or /
          *            Uses C locale
          *            Structural zeros represented by 00
          *            Does not scale well for large sparse matrices
          * 




        """
        return _casadi.DM_to_file(self, *args)

    @staticmethod
    def from_file(*args) -> "casadi::Matrix< double >":
        r"""
        from_file(std::string const & filename, std::string const & format_hint="") -> DM


        Export numerical matrix to file

        Supported formats:



        ::

          *   - .mtx   Matrix Market (sparse)
          *   - .txt   Ascii full precision representation (sparse)
          *            Whitespace separated, aligned.
          *            Comments with # % or /
          *            Uses C locale
          *            Structural zeros represented by 00
          *            Does not scale well for large sparse matrices
          * 




        """
        return _casadi.DM_from_file(*args)

    def __init__(self, *args):
        r"""
        __init__(DM self) -> DM
        __init__(DM self, DM m) -> DM
        __init__(DM self, casadi_int nrow, casadi_int ncol) -> DM
        __init__(DM self, Sparsity sp) -> DM
        __init__(DM self, Sparsity sp, DM d) -> DM
        __init__(DM self, double val) -> DM
        __init__(DM self, std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const & m) -> DM
        __init__(DM self, std::vector< casadi::SXElem,std::allocator< casadi::SXElem > > const & x) -> DM
        __init__(DM self, SX x) -> DM
        """
        _casadi.DM_swiginit(self, _casadi.new_DM(*args))

    def assign(self, *args) -> "void":
        r"""assign(DM self, DM rhs)"""
        return _casadi.DM_assign(self, *args)

    @property
    def shape(self):
        return (self.size1(),self.size2())

    def reshape(self,arg):
        return _casadi.reshape(self,arg)

    @property
    def T(self):
        return _casadi.transpose(self)

    def __getitem__(self, s):
          if isinstance(s, tuple) and len(s)==2:
            if s[1] is None: raise TypeError("Cannot slice with None")
            return self.get(False, s[0], s[1])
          return self.get(False, s)

    def __iter__(self):
      raise Exception("""CasADi matrices are not iterable by design.
                      Did you mean to iterate over m.nz, with m IM/DM/SX?
                      Did you mean to iterate over horzsplit(m,1)/vertsplit(m,1) with m IM/DM/SX/MX?
                      """)

    def __setitem__(self,s,val):
          if isinstance(s,tuple) and len(s)==2:
            return self.set(val, False, s[0], s[1])
          return self.set(val, False, s)

    @property
    def nz(self):
      return NZproxy(self)



    def full(self, *args) -> "PyObject *":
        r"""full(DM self) -> PyObject *"""
        return _casadi.DM_full(self, *args)

    def sparse(self, *args) -> "PyObject *":
        r"""sparse(DM self) -> PyObject *"""
        return _casadi.DM_sparse(self, *args)


    __array_priority__ = 999.0

    def __array_wrap__(self,out_arr,context=None):
      if context is None:
        return out_arr
      name = context[0].__name__
      args = list(context[1])

      if len(context[1])==3:
        raise Exception("Error with %s. Looks like you are using an assignment operator, such as 'a+=b' where 'a' is a numpy type. This is not supported, and cannot be supported without changing numpy." % name)

      if "vectorized" in name:
          name = name[:-len(" (vectorized)")]

      conversion = {"multiply": "mul", "divide": "div", "true_divide": "div", "subtract":"sub","power":"pow","greater_equal":"ge","less_equal": "le", "less": "lt", "greater": "gt"}
      if name in conversion:
        name = conversion[name]
      if len(context[1])==2 and context[1][1] is self and not(context[1][0] is self):
        name = 'r' + name
        args.reverse()
      if not(hasattr(self,name)) or ('mul' in name):
        name = '__' + name + '__'
      fun=getattr(self, name)
      return fun(*args[1:])

    def __array_ufunc__(self, ufunc, method, *inputs, **kwargs):
      conversion = {"multiply": "mul", "divide": "div", "true_divide": "div", "subtract":"sub","power":"pow","greater_equal":"ge","less_equal": "le", "less": "lt", "greater": "gt"}
      name = ufunc.__name__
      inputs = list(inputs)
      if len(inputs)==3:
        import warnings
        warnings.warn("Error with %s. Looks like you are using an assignment operator, such as 'a+=b' where 'a' is a numpy type. This is not supported, and cannot be supported without changing numpy." % name, RuntimeWarning)
        return NotImplemented
      if "vectorized" in name:
          name = name[:-len(" (vectorized)")]
      if name in conversion:
        name = conversion[name]
      if len(inputs)==2 and inputs[1] is self and not(inputs[0] is self):
        name = 'r' + name
        inputs.reverse()
      if not(hasattr(self,name)) or ('mul' in name):
        name = '__' + name + '__'
      try:
        assert method=="__call__"
        fun=getattr(self, name)
        return fun(*inputs[1:])
      except:
#Fall back to numpy conversion
        new_inputs = list(inputs)
        try:
          new_inputs[0] = new_inputs[0].full()
        except:
          import warnings
          warnings.warn("Implicit conversion of symbolic CasADi type to numeric matrix not supported.\n"
                                 + "This may occur when you pass a CasADi object to a numpy function.\n"
                                 + "Use an equivalent CasADi function instead of that numpy function.", RuntimeWarning)
          return NotImplemented
        return new_inputs[0].__array_ufunc__(ufunc, method, *new_inputs, **kwargs)


    def __array__(self,*args,**kwargs):
      import numpy as n
      if len(args) > 1 and isinstance(args[1],tuple) and isinstance(args[1][0],n.ufunc) and isinstance(args[1][0],n.ufunc) and len(args[1])>1 and args[1][0].nin==len(args[1][1]):
        if len(args[1][1])==3:
          raise Exception("Error with %s. Looks like you are using an assignment operator, such as 'a+=b'. This is not supported when 'a' is a numpy type, and cannot be supported without changing numpy itself. Either upgrade a to a CasADi type first, or use 'a = a + b'. " % args[1][0].__name__)
        return n.array([n.nan])
      else:
        if hasattr(self,'__array_custom__'):
          return self.__array_custom__(*args,**kwargs)
        else:
          try:
            return self.full()
          except:
            raise Exception("Implicit conversion of symbolic CasADi type to numeric matrix not supported.\n"
                       + "This may occur when you pass a CasADi object to a numpy function.\n"
                       + "Use an equivalent CasADi function instead of that numpy function.")



    def __array_custom__(self,*args,**kwargs):
      if "dtype" in kwargs and not(isinstance(kwargs["dtype"],n.double)):
        return n.array(self.full(),dtype=kwargs["dtype"])
      else:
        return self.full()


    def tocsc(self):
      import numpy as np
      import warnings
      with warnings.catch_warnings():
        warnings.simplefilter("ignore")
        from scipy.sparse import csc_matrix
      return csc_matrix( (self.nonzeros(),self.row(),self.colind()), shape = self.shape, dtype=np.double )
    def toarray(self,simplify=False):
      import numpy as np
      if simplify:
        if self.is_scalar():
          return float(self)
        elif self.is_vector():
          return np.array(self.T.elements())
      return np.array(self.T.elements()).reshape(self.shape)


    def __bool__(self):
      if self.numel()!=1:
        raise Exception("Only a scalar can be cast to a float")
      if self.nnz()==0:
        return False
      return float(self)!=0


    def __abs__(self):
      return abs(float(self))


    def __setstate__(self, state):
        self.__init__(DM.deserialize(state["serialization"]))

    def __getstate__(self):
        return {"serialization": self.serialize()}

    __swig_destroy__ = _casadi.delete_DM

# Register DM in _casadi:
_casadi.DM_swigregister(DM)

def DM_binary(*args) -> "casadi::Matrix< double >":
    r"""DM_binary(casadi_int op, DM x, DM y) -> DM"""
    return _casadi.DM_binary(*args)

def DM_unary(*args) -> "casadi::Matrix< double >":
    r"""DM_unary(casadi_int op, DM x) -> DM"""
    return _casadi.DM_unary(*args)

def DM_scalar_matrix(*args) -> "casadi::Matrix< double >":
    r"""DM_scalar_matrix(casadi_int op, DM x, DM y) -> DM"""
    return _casadi.DM_scalar_matrix(*args)

def DM_matrix_scalar(*args) -> "casadi::Matrix< double >":
    r"""DM_matrix_scalar(casadi_int op, DM x, DM y) -> DM"""
    return _casadi.DM_matrix_scalar(*args)

def DM_matrix_matrix(*args) -> "casadi::Matrix< double >":
    r"""DM_matrix_matrix(casadi_int op, DM x, DM y) -> DM"""
    return _casadi.DM_matrix_matrix(*args)

def DM_set_max_depth(*args) -> "void":
    r"""DM_set_max_depth(casadi_int eq_depth=1)"""
    return _casadi.DM_set_max_depth(*args)

def DM_get_max_depth(*args) -> "casadi_int":
    r"""DM_get_max_depth() -> casadi_int"""
    return _casadi.DM_get_max_depth(*args)

def DM_get_input(*args) -> "std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >":
    r"""DM_get_input(Function f) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >"""
    return _casadi.DM_get_input(*args)

def DM_get_free(*args) -> "std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >":
    r"""DM_get_free(Function f) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >"""
    return _casadi.DM_get_free(*args)

def DM_type_name(*args) -> "std::string":
    r"""DM_type_name() -> std::string"""
    return _casadi.DM_type_name(*args)

def DM_triplet(*args) -> "casadi::Matrix< double >":
    r"""
    DM_triplet(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, DM d) -> DM
    DM_triplet(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, DM d, casadi_int nrow, casadi_int ncol) -> DM
    DM_triplet(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, DM d, std::pair< casadi_int,casadi_int > const & rc) -> DM
    """
    return _casadi.DM_triplet(*args)

def DM_inf(*args) -> "casadi::Matrix< double >":
    r"""
    DM_inf(Sparsity sp) -> DM
    DM_inf(casadi_int nrow=1, casadi_int ncol=1) -> DM
    DM_inf(std::pair< casadi_int,casadi_int > const & rc) -> DM


    create a matrix with all inf


    """
    return _casadi.DM_inf(*args)

def DM_nan(*args) -> "casadi::Matrix< double >":
    r"""
    DM_nan(Sparsity sp) -> DM
    DM_nan(casadi_int nrow=1, casadi_int ncol=1) -> DM
    DM_nan(std::pair< casadi_int,casadi_int > const & rc) -> DM


    create a matrix with all nan


    """
    return _casadi.DM_nan(*args)

def DM_eye(*args) -> "casadi::Matrix< double >":
    r"""DM_eye(casadi_int n) -> DM"""
    return _casadi.DM_eye(*args)

def DM_set_precision(*args) -> "void":
    r"""
    DM_set_precision(casadi_int precision)


    Set the 'precision, width & scientific' used in printing and serializing to
    streams.


    """
    return _casadi.DM_set_precision(*args)

def DM_set_width(*args) -> "void":
    r"""
    DM_set_width(casadi_int width)


    Set the 'precision, width & scientific' used in printing and serializing to
    streams.


    """
    return _casadi.DM_set_width(*args)

def DM_set_scientific(*args) -> "void":
    r"""
    DM_set_scientific(bool scientific)


    Set the 'precision, width & scientific' used in printing and serializing to
    streams.


    """
    return _casadi.DM_set_scientific(*args)

def DM_rng(*args) -> "void":
    r"""DM_rng(casadi_int seed)"""
    return _casadi.DM_rng(*args)

def DM_rand(*args) -> "casadi::Matrix< double >":
    r"""
    DM_rand(casadi_int nrow=1, casadi_int ncol=1) -> DM
    DM_rand(Sparsity sp) -> DM
    DM_rand(std::pair< casadi_int,casadi_int > const & rc) -> DM


    Create a matrix with uniformly distributed random numbers.


    """
    return _casadi.DM_rand(*args)

def DM_deserialize(*args) -> "casadi::Matrix< double >":
    r"""
    DM_deserialize(std::istream & stream) -> DM
    DM_deserialize(std::string const & s) -> DM
    DM_deserialize(casadi::DeserializingStream & s) -> DM
    """
    return _casadi.DM_deserialize(*args)

def DM_from_file(*args) -> "casadi::Matrix< double >":
    r"""
    DM_from_file(std::string const & filename, std::string const & format_hint="") -> DM


    Export numerical matrix to file

    Supported formats:



    ::

      *   - .mtx   Matrix Market (sparse)
      *   - .txt   Ascii full precision representation (sparse)
      *            Whitespace separated, aligned.
      *            Comments with # % or /
      *            Uses C locale
      *            Structural zeros represented by 00
      *            Does not scale well for large sparse matrices
      * 




    """
    return _casadi.DM_from_file(*args)

class SXElem(object):
    r"""Proxy of C++ casadi::SXElem class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(SXElem self) -> SXElem
        __init__(SXElem self, SXElem other) -> SXElem
        """
        _casadi.SXElem_swiginit(self, _casadi.new_SXElem(*args))
    __swig_destroy__ = _casadi.delete_SXElem

# Register SXElem in _casadi:
_casadi.SXElem_swigregister(SXElem)



try:
  import numpy

  def constpow(x,y):
    pass

  constpow=numpy.frompyfunc(constpow,2,1)
except:
  pass

class SX(MatrixCommon, GenericExpressionCommon, GenSX, PrintableCommon):
    r"""Proxy of C++ casadi::Matrix< casadi::SXElem > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def sanity_check(self, *args) -> "void":
        r"""
        sanity_check(SX self, bool complete=False)


        [DEPRECATED] Correctness is checked during construction


        """
        return _casadi.SX_sanity_check(self, *args)

    def has_nz(self, *args) -> "bool":
        r"""
        has_nz(SX self, casadi_int rr, casadi_int cc) -> bool


        Returns true if the matrix has a non-zero at location rr, cc.


        """
        return _casadi.SX_has_nz(self, *args)

    def __bool__(self, *args) -> "bool":
        r"""
        __bool__(SX self) -> bool


        Returns the truth value of a Matrix.


        """
        return _casadi.SX___bool__(self, *args)

    def get(self, *args) -> "void":
        r"""
        get(SX self, bool ind1, Slice rr)
        get(SX self, bool ind1, casadi::Matrix< casadi_int > const & rr)
        get(SX self, bool ind1, Sparsity sp)
        get(SX self, bool ind1, Slice rr, Slice cc)
        get(SX self, bool ind1, Slice rr, casadi::Matrix< casadi_int > const & cc)
        get(SX self, bool ind1, casadi::Matrix< casadi_int > const & rr, Slice cc)
        get(SX self, bool ind1, casadi::Matrix< casadi_int > const & rr, casadi::Matrix< casadi_int > const & cc)
        """
        return _casadi.SX_get(self, *args)

    def set(self, *args) -> "void":
        r"""
        set(SX self, SX m, bool ind1, Slice rr)
        set(SX self, SX m, bool ind1, casadi::Matrix< casadi_int > const & rr)
        set(SX self, SX m, bool ind1, Sparsity sp)
        set(SX self, SX m, bool ind1, Slice rr, Slice cc)
        set(SX self, SX m, bool ind1, Slice rr, casadi::Matrix< casadi_int > const & cc)
        set(SX self, SX m, bool ind1, casadi::Matrix< casadi_int > const & rr, Slice cc)
        set(SX self, SX m, bool ind1, casadi::Matrix< casadi_int > const & rr, casadi::Matrix< casadi_int > const & cc)
        """
        return _casadi.SX_set(self, *args)

    def get_nz(self, *args) -> "void":
        r"""
        get_nz(SX self, bool ind1, Slice k)
        get_nz(SX self, bool ind1, casadi::Matrix< casadi_int > const & k)
        """
        return _casadi.SX_get_nz(self, *args)

    def set_nz(self, *args) -> "void":
        r"""
        set_nz(SX self, SX m, bool ind1, Slice k)
        set_nz(SX self, SX m, bool ind1, casadi::Matrix< casadi_int > const & k)
        """
        return _casadi.SX_set_nz(self, *args)

    def __pos__(self, *args) -> "casadi::Matrix< casadi::SXElem >":
        r"""__pos__(SX self) -> SX"""
        return _casadi.SX___pos__(self, *args)

    def __neg__(self, *args) -> "casadi::Matrix< casadi::SXElem >":
        r"""__neg__(SX self) -> SX"""
        return _casadi.SX___neg__(self, *args)

    @staticmethod
    def binary(*args) -> "casadi::Matrix< casadi::SXElem >":
        r"""binary(casadi_int op, SX x, SX y) -> SX"""
        return _casadi.SX_binary(*args)

    @staticmethod
    def unary(*args) -> "casadi::Matrix< casadi::SXElem >":
        r"""unary(casadi_int op, SX x) -> SX"""
        return _casadi.SX_unary(*args)

    @staticmethod
    def scalar_matrix(*args) -> "casadi::Matrix< casadi::SXElem >":
        r"""scalar_matrix(casadi_int op, SX x, SX y) -> SX"""
        return _casadi.SX_scalar_matrix(*args)

    @staticmethod
    def matrix_scalar(*args) -> "casadi::Matrix< casadi::SXElem >":
        r"""matrix_scalar(casadi_int op, SX x, SX y) -> SX"""
        return _casadi.SX_matrix_scalar(*args)

    @staticmethod
    def matrix_matrix(*args) -> "casadi::Matrix< casadi::SXElem >":
        r"""matrix_matrix(casadi_int op, SX x, SX y) -> SX"""
        return _casadi.SX_matrix_matrix(*args)

    def printme(self, *args) -> "casadi::Matrix< casadi::SXElem >":
        r"""printme(SX self, SX y) -> SX"""
        return _casadi.SX_printme(self, *args)

    @staticmethod
    def set_max_depth(*args) -> "void":
        r"""set_max_depth(casadi_int eq_depth=1)"""
        return _casadi.SX_set_max_depth(*args)

    @staticmethod
    def get_max_depth(*args) -> "casadi_int":
        r"""get_max_depth() -> casadi_int"""
        return _casadi.SX_get_max_depth(*args)

    @staticmethod
    def get_input(*args) -> "std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >":
        r"""get_input(Function f) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >"""
        return _casadi.SX_get_input(*args)

    @staticmethod
    def get_free(*args) -> "std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >":
        r"""get_free(Function f) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >"""
        return _casadi.SX_get_free(*args)

    @staticmethod
    def type_name(*args) -> "std::string":
        r"""type_name() -> std::string"""
        return _casadi.SX_type_name(*args)

    def print_split(self, *args) -> "void":
        r"""
        print_split(SX self)


        Get strings corresponding to the nonzeros and the interdependencies.


        """
        return _casadi.SX_print_split(self, *args)

    def disp(self, *args) -> "void":
        r"""
        disp(SX self, bool more=False)


        Print a representation of the object.


        """
        return _casadi.SX_disp(self, *args)

    def str(self, *args) -> "std::string":
        r"""
        str(SX self, bool more=False) -> std::string


        Get string representation.


        """
        return _casadi.SX_str(self, *args)

    def print_scalar(self, *args) -> "void":
        r"""
        print_scalar(SX self)


        Print scalar.


        """
        return _casadi.SX_print_scalar(self, *args)

    def print_vector(self, *args) -> "void":
        r"""
        print_vector(SX self, bool truncate=True)


        Print vector-style.


        """
        return _casadi.SX_print_vector(self, *args)

    def print_dense(self, *args) -> "void":
        r"""
        print_dense(SX self, bool truncate=True)


        Print dense matrix-stype.


        """
        return _casadi.SX_print_dense(self, *args)

    def print_sparse(self, *args) -> "void":
        r"""
        print_sparse(SX self, bool truncate=True)


        Print sparse matrix style.


        """
        return _casadi.SX_print_sparse(self, *args)

    def clear(self, *args) -> "void":
        r"""clear(SX self)"""
        return _casadi.SX_clear(self, *args)

    def resize(self, *args) -> "void":
        r"""resize(SX self, casadi_int nrow, casadi_int ncol)"""
        return _casadi.SX_resize(self, *args)

    def reserve(self, *args) -> "void":
        r"""
        reserve(SX self, casadi_int nnz)
        reserve(SX self, casadi_int nnz, casadi_int ncol)
        """
        return _casadi.SX_reserve(self, *args)

    def erase(self, *args) -> "void":
        r"""
        erase(SX self, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, std::vector< casadi_int,std::allocator< casadi_int > > const & cc, bool ind1=False)
        erase(SX self, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, bool ind1=False)


        Erase a submatrix (leaving structural zeros in its place) Erase elements of
        a matrix.


        """
        return _casadi.SX_erase(self, *args)

    def remove(self, *args) -> "void":
        r"""
        remove(SX self, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, std::vector< casadi_int,std::allocator< casadi_int > > const & cc)


        Remove columns and rows Remove/delete rows and/or columns of a matrix.


        """
        return _casadi.SX_remove(self, *args)

    def enlarge(self, *args) -> "void":
        r"""
        enlarge(SX self, casadi_int nrow, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, std::vector< casadi_int,std::allocator< casadi_int > > const & cc, bool ind1=False)


        Enlarge matrix Make the matrix larger by inserting empty rows and columns,
        keeping the existing non-zeros.


        """
        return _casadi.SX_enlarge(self, *args)

    def sparsity(self, *args) -> "casadi::Sparsity":
        r"""
        sparsity(SX self) -> Sparsity


        Get an owning reference to the sparsity pattern.


        """
        return _casadi.SX_sparsity(self, *args)

    @staticmethod
    def triplet(*args) -> "casadi::Matrix< casadi::SXElem >":
        r"""
        triplet(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, SX d) -> SX
        triplet(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, SX d, casadi_int nrow, casadi_int ncol) -> SX
        triplet(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, SX d, std::pair< casadi_int,casadi_int > const & rc) -> SX
        """
        return _casadi.SX_triplet(*args)

    @staticmethod
    def inf(*args) -> "casadi::Matrix< casadi::SXElem >":
        r"""
        inf(Sparsity sp) -> SX
        inf(casadi_int nrow=1, casadi_int ncol=1) -> SX
        inf(std::pair< casadi_int,casadi_int > const & rc) -> SX


        create a matrix with all inf


        """
        return _casadi.SX_inf(*args)

    @staticmethod
    def nan(*args) -> "casadi::Matrix< casadi::SXElem >":
        r"""
        nan(Sparsity sp) -> SX
        nan(casadi_int nrow=1, casadi_int ncol=1) -> SX
        nan(std::pair< casadi_int,casadi_int > const & rc) -> SX


        create a matrix with all nan


        """
        return _casadi.SX_nan(*args)

    @staticmethod
    def eye(*args) -> "casadi::Matrix< casadi::SXElem >":
        r"""eye(casadi_int n) -> SX"""
        return _casadi.SX_eye(*args)

    def element_hash(self, *args) -> "casadi_int":
        r"""element_hash(SX self) -> casadi_int"""
        return _casadi.SX_element_hash(self, *args)

    def is_regular(self, *args) -> "bool":
        r"""is_regular(SX self) -> bool"""
        return _casadi.SX_is_regular(self, *args)

    def is_smooth(self, *args) -> "bool":
        r"""is_smooth(SX self) -> bool"""
        return _casadi.SX_is_smooth(self, *args)

    def is_leaf(self, *args) -> "bool":
        r"""is_leaf(SX self) -> bool"""
        return _casadi.SX_is_leaf(self, *args)

    def is_commutative(self, *args) -> "bool":
        r"""is_commutative(SX self) -> bool"""
        return _casadi.SX_is_commutative(self, *args)

    def is_symbolic(self, *args) -> "bool":
        r"""is_symbolic(SX self) -> bool"""
        return _casadi.SX_is_symbolic(self, *args)

    def is_valid_input(self, *args) -> "bool":
        r"""is_valid_input(SX self) -> bool"""
        return _casadi.SX_is_valid_input(self, *args)

    def has_duplicates(self, *args) -> "bool":
        r"""has_duplicates(SX self) -> bool"""
        return _casadi.SX_has_duplicates(self, *args)

    def reset_input(self, *args) -> "void":
        r"""reset_input(SX self)"""
        return _casadi.SX_reset_input(self, *args)

    def is_constant(self, *args) -> "bool":
        r"""
        is_constant(SX self) -> bool


        Check if the matrix is constant (note that false negative answers are
        possible)


        """
        return _casadi.SX_is_constant(self, *args)

    def is_integer(self, *args) -> "bool":
        r"""
        is_integer(SX self) -> bool


        Check if the matrix is integer-valued (note that false negative answers are
        possible)


        """
        return _casadi.SX_is_integer(self, *args)

    def is_zero(self, *args) -> "bool":
        r"""
        is_zero(SX self) -> bool


        check if the matrix is 0 (note that false negative answers are possible)


        """
        return _casadi.SX_is_zero(self, *args)

    def is_one(self, *args) -> "bool":
        r"""
        is_one(SX self) -> bool


        check if the matrix is 1 (note that false negative answers are possible)


        """
        return _casadi.SX_is_one(self, *args)

    def is_minus_one(self, *args) -> "bool":
        r"""
        is_minus_one(SX self) -> bool


        check if the matrix is -1 (note that false negative answers are possible)


        """
        return _casadi.SX_is_minus_one(self, *args)

    def is_eye(self, *args) -> "bool":
        r"""
        is_eye(SX self) -> bool


        check if the matrix is an identity matrix (note that false negative answers
        are possible)


        """
        return _casadi.SX_is_eye(self, *args)

    def op(self, *args) -> "casadi_int":
        r"""op(SX self) -> casadi_int"""
        return _casadi.SX_op(self, *args)

    def is_op(self, *args) -> "bool":
        r"""is_op(SX self, casadi_int op) -> bool"""
        return _casadi.SX_is_op(self, *args)

    def has_zeros(self, *args) -> "bool":
        r"""
        has_zeros(SX self) -> bool


        Check if the matrix has any zero entries which are not structural zeros.


        """
        return _casadi.SX_has_zeros(self, *args)

    def nonzeros(self, *args) -> "std::vector< casadi::SXElem,std::allocator< casadi::SXElem > >":
        r"""
        nonzeros(SX self) -> std::vector< casadi::SXElem,std::allocator< casadi::SXElem > >


        Get all nonzeros.

        Implementation of Matrix::get_nonzeros (in public API)


        """
        return _casadi.SX_nonzeros(self, *args)

    def elements(self, *args) -> "std::vector< casadi::SXElem,std::allocator< casadi::SXElem > >":
        r"""
        elements(SX self) -> std::vector< casadi::SXElem,std::allocator< casadi::SXElem > >


        Get all elements.


        """
        return _casadi.SX_elements(self, *args)

    def __float__(self, *args) -> "double":
        r"""__float__(SX self) -> double"""
        return _casadi.SX___float__(self, *args)

    def __int__(self, *args) -> "casadi_int":
        r"""__int__(SX self) -> casadi_int"""
        return _casadi.SX___int__(self, *args)

    def name(self, *args) -> "std::string":
        r"""name(SX self) -> std::string"""
        return _casadi.SX_name(self, *args)

    def dep(self, *args) -> "casadi::Matrix< casadi::SXElem >":
        r"""dep(SX self, casadi_int ch=0) -> SX"""
        return _casadi.SX_dep(self, *args)

    def n_dep(self, *args) -> "casadi_int":
        r"""n_dep(SX self) -> casadi_int"""
        return _casadi.SX_n_dep(self, *args)

    @staticmethod
    def set_precision(*args) -> "void":
        r"""
        set_precision(casadi_int precision)


        Set the 'precision, width & scientific' used in printing and serializing to
        streams.


        """
        return _casadi.SX_set_precision(*args)

    @staticmethod
    def set_width(*args) -> "void":
        r"""
        set_width(casadi_int width)


        Set the 'precision, width & scientific' used in printing and serializing to
        streams.


        """
        return _casadi.SX_set_width(*args)

    @staticmethod
    def set_scientific(*args) -> "void":
        r"""
        set_scientific(bool scientific)


        Set the 'precision, width & scientific' used in printing and serializing to
        streams.


        """
        return _casadi.SX_set_scientific(*args)

    @staticmethod
    def rng(*args) -> "void":
        r"""rng(casadi_int seed)"""
        return _casadi.SX_rng(*args)

    @staticmethod
    def rand(*args) -> "casadi::Matrix< casadi::SXElem >":
        r"""
        rand(casadi_int nrow=1, casadi_int ncol=1) -> SX
        rand(Sparsity sp) -> SX
        rand(std::pair< casadi_int,casadi_int > const & rc) -> SX


        Create a matrix with uniformly distributed random numbers.


        """
        return _casadi.SX_rand(*args)

    def export_code(self, *args) -> "void":
        r"""
        export_code(SX self, std::string const & lang, casadi::Dict const & options=casadi::Dict())


        Export matrix in specific language.

        lang: only 'matlab' supported for now

        ::

          * options:
          *   inline: Indicates if you want everything on a single line (default: False)
          *   name: Name of exported variable (default: 'm')
          *   indent_level: Level of indentation (default: 0)
          *   spoof_zero: Replace numerical zero by a 1e-200 (default: false)
          *               might be needed for matlab sparse construct,
          *               which doesn't allow numerical zero
          * 




        """
        return _casadi.SX_export_code(self, *args)

    def info(self, *args) -> "casadi::Dict":
        r"""info(SX self) -> casadi::Dict"""
        return _casadi.SX_info(self, *args)

    def serialize(self, *args) -> "void":
        r"""
        serialize(SX self) -> std::string
        serialize(SX self, casadi::SerializingStream & s)


        Serialize an object.


        """
        return _casadi.SX_serialize(self, *args)

    @staticmethod
    def deserialize(*args) -> "casadi::Matrix< casadi::SXElem >":
        r"""
        deserialize(std::istream & stream) -> SX
        deserialize(std::string const & s) -> SX
        deserialize(casadi::DeserializingStream & s) -> SX
        """
        return _casadi.SX_deserialize(*args)

    def to_file(self, *args) -> "void":
        r"""
        to_file(SX self, std::string const & filename, std::string const & format="")


        Export numerical matrix to file

        Supported formats:



        ::

          *   - .mtx   Matrix Market (sparse)
          *   - .txt   Ascii full precision representation (sparse)
          *            Whitespace separated, aligned.
          *            Comments with # % or /
          *            Uses C locale
          *            Structural zeros represented by 00
          *            Does not scale well for large sparse matrices
          * 




        """
        return _casadi.SX_to_file(self, *args)

    @staticmethod
    def from_file(*args) -> "casadi::Matrix< double >":
        r"""
        from_file(std::string const & filename, std::string const & format_hint="") -> DM


        Export numerical matrix to file

        Supported formats:



        ::

          *   - .mtx   Matrix Market (sparse)
          *   - .txt   Ascii full precision representation (sparse)
          *            Whitespace separated, aligned.
          *            Comments with # % or /
          *            Uses C locale
          *            Structural zeros represented by 00
          *            Does not scale well for large sparse matrices
          * 




        """
        return _casadi.SX_from_file(*args)

    @property
    def shape(self):
        return (self.size1(),self.size2())

    def reshape(self,arg):
        return _casadi.reshape(self,arg)

    @property
    def T(self):
        return _casadi.transpose(self)

    def __getitem__(self, s):
          if isinstance(s, tuple) and len(s)==2:
            if s[1] is None: raise TypeError("Cannot slice with None")
            return self.get(False, s[0], s[1])
          return self.get(False, s)

    def __iter__(self):
      raise Exception("""CasADi matrices are not iterable by design.
                      Did you mean to iterate over m.nz, with m IM/DM/SX?
                      Did you mean to iterate over horzsplit(m,1)/vertsplit(m,1) with m IM/DM/SX/MX?
                      """)

    def __setitem__(self,s,val):
          if isinstance(s,tuple) and len(s)==2:
            return self.set(val, False, s[0], s[1])
          return self.set(val, False, s)

    @property
    def nz(self):
      return NZproxy(self)




    __array_priority__ = 1001.0

    def __array_wrap__(self,out_arr,context=None):
      if context is None:
        return out_arr
      name = context[0].__name__
      args = list(context[1])

      if len(context[1])==3:
        raise Exception("Error with %s. Looks like you are using an assignment operator, such as 'a+=b' where 'a' is a numpy type. This is not supported, and cannot be supported without changing numpy." % name)

      if "vectorized" in name:
          name = name[:-len(" (vectorized)")]

      conversion = {"multiply": "mul", "divide": "div", "true_divide": "div", "subtract":"sub","power":"pow","greater_equal":"ge","less_equal": "le", "less": "lt", "greater": "gt"}
      if name in conversion:
        name = conversion[name]
      if len(context[1])==2 and context[1][1] is self and not(context[1][0] is self):
        name = 'r' + name
        args.reverse()
      if not(hasattr(self,name)) or ('mul' in name):
        name = '__' + name + '__'
      fun=getattr(self, name)
      return fun(*args[1:])

    def __array_ufunc__(self, ufunc, method, *inputs, **kwargs):
      conversion = {"multiply": "mul", "divide": "div", "true_divide": "div", "subtract":"sub","power":"pow","greater_equal":"ge","less_equal": "le", "less": "lt", "greater": "gt"}
      name = ufunc.__name__
      inputs = list(inputs)
      if len(inputs)==3:
        import warnings
        warnings.warn("Error with %s. Looks like you are using an assignment operator, such as 'a+=b' where 'a' is a numpy type. This is not supported, and cannot be supported without changing numpy." % name, RuntimeWarning)
        return NotImplemented
      if "vectorized" in name:
          name = name[:-len(" (vectorized)")]
      if name in conversion:
        name = conversion[name]
      if len(inputs)==2 and inputs[1] is self and not(inputs[0] is self):
        name = 'r' + name
        inputs.reverse()
      if not(hasattr(self,name)) or ('mul' in name):
        name = '__' + name + '__'
      try:
        assert method=="__call__"
        fun=getattr(self, name)
        return fun(*inputs[1:])
      except:
#Fall back to numpy conversion
        new_inputs = list(inputs)
        try:
          new_inputs[0] = new_inputs[0].full()
        except:
          import warnings
          warnings.warn("Implicit conversion of symbolic CasADi type to numeric matrix not supported.\n"
                                 + "This may occur when you pass a CasADi object to a numpy function.\n"
                                 + "Use an equivalent CasADi function instead of that numpy function.", RuntimeWarning)
          return NotImplemented
        return new_inputs[0].__array_ufunc__(ufunc, method, *new_inputs, **kwargs)


    def __array__(self,*args,**kwargs):
      import numpy as n
      if len(args) > 1 and isinstance(args[1],tuple) and isinstance(args[1][0],n.ufunc) and isinstance(args[1][0],n.ufunc) and len(args[1])>1 and args[1][0].nin==len(args[1][1]):
        if len(args[1][1])==3:
          raise Exception("Error with %s. Looks like you are using an assignment operator, such as 'a+=b'. This is not supported when 'a' is a numpy type, and cannot be supported without changing numpy itself. Either upgrade a to a CasADi type first, or use 'a = a + b'. " % args[1][0].__name__)
        return n.array([n.nan])
      else:
        if hasattr(self,'__array_custom__'):
          return self.__array_custom__(*args,**kwargs)
        else:
          try:
            return self.full()
          except:
            raise Exception("Implicit conversion of symbolic CasADi type to numeric matrix not supported.\n"
                       + "This may occur when you pass a CasADi object to a numpy function.\n"
                       + "Use an equivalent CasADi function instead of that numpy function.")



    def __init__(self, *args):
        r"""
        __init__(SX self) -> SX
        __init__(SX self, SX m) -> SX
        __init__(SX self, casadi_int nrow, casadi_int ncol) -> SX
        __init__(SX self, Sparsity sp) -> SX
        __init__(SX self, Sparsity sp, SX d) -> SX
        __init__(SX self, double val) -> SX
        __init__(SX self, std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const & m) -> SX
        __init__(SX self, std::vector< double,std::allocator< double > > const & x) -> SX
        __init__(SX self, DM x) -> SX
        """
        _casadi.SX_swiginit(self, _casadi.new_SX(*args))
    __swig_destroy__ = _casadi.delete_SX

# Register SX in _casadi:
_casadi.SX_swigregister(SX)

def SX_binary(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""SX_binary(casadi_int op, SX x, SX y) -> SX"""
    return _casadi.SX_binary(*args)

def SX_unary(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""SX_unary(casadi_int op, SX x) -> SX"""
    return _casadi.SX_unary(*args)

def SX_scalar_matrix(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""SX_scalar_matrix(casadi_int op, SX x, SX y) -> SX"""
    return _casadi.SX_scalar_matrix(*args)

def SX_matrix_scalar(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""SX_matrix_scalar(casadi_int op, SX x, SX y) -> SX"""
    return _casadi.SX_matrix_scalar(*args)

def SX_matrix_matrix(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""SX_matrix_matrix(casadi_int op, SX x, SX y) -> SX"""
    return _casadi.SX_matrix_matrix(*args)

def SX_set_max_depth(*args) -> "void":
    r"""SX_set_max_depth(casadi_int eq_depth=1)"""
    return _casadi.SX_set_max_depth(*args)

def SX_get_max_depth(*args) -> "casadi_int":
    r"""SX_get_max_depth() -> casadi_int"""
    return _casadi.SX_get_max_depth(*args)

def SX_get_input(*args) -> "std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >":
    r"""SX_get_input(Function f) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >"""
    return _casadi.SX_get_input(*args)

def SX_get_free(*args) -> "std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >":
    r"""SX_get_free(Function f) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >"""
    return _casadi.SX_get_free(*args)

def SX_type_name(*args) -> "std::string":
    r"""SX_type_name() -> std::string"""
    return _casadi.SX_type_name(*args)

def SX_triplet(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    SX_triplet(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, SX d) -> SX
    SX_triplet(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, SX d, casadi_int nrow, casadi_int ncol) -> SX
    SX_triplet(std::vector< casadi_int,std::allocator< casadi_int > > const & row, std::vector< casadi_int,std::allocator< casadi_int > > const & col, SX d, std::pair< casadi_int,casadi_int > const & rc) -> SX
    """
    return _casadi.SX_triplet(*args)

def SX_inf(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    SX_inf(Sparsity sp) -> SX
    SX_inf(casadi_int nrow=1, casadi_int ncol=1) -> SX
    SX_inf(std::pair< casadi_int,casadi_int > const & rc) -> SX


    create a matrix with all inf


    """
    return _casadi.SX_inf(*args)

def SX_nan(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    SX_nan(Sparsity sp) -> SX
    SX_nan(casadi_int nrow=1, casadi_int ncol=1) -> SX
    SX_nan(std::pair< casadi_int,casadi_int > const & rc) -> SX


    create a matrix with all nan


    """
    return _casadi.SX_nan(*args)

def SX_eye(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""SX_eye(casadi_int n) -> SX"""
    return _casadi.SX_eye(*args)

def SX_set_precision(*args) -> "void":
    r"""
    SX_set_precision(casadi_int precision)


    Set the 'precision, width & scientific' used in printing and serializing to
    streams.


    """
    return _casadi.SX_set_precision(*args)

def SX_set_width(*args) -> "void":
    r"""
    SX_set_width(casadi_int width)


    Set the 'precision, width & scientific' used in printing and serializing to
    streams.


    """
    return _casadi.SX_set_width(*args)

def SX_set_scientific(*args) -> "void":
    r"""
    SX_set_scientific(bool scientific)


    Set the 'precision, width & scientific' used in printing and serializing to
    streams.


    """
    return _casadi.SX_set_scientific(*args)

def SX_rng(*args) -> "void":
    r"""SX_rng(casadi_int seed)"""
    return _casadi.SX_rng(*args)

def SX_rand(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    SX_rand(casadi_int nrow=1, casadi_int ncol=1) -> SX
    SX_rand(Sparsity sp) -> SX
    SX_rand(std::pair< casadi_int,casadi_int > const & rc) -> SX


    Create a matrix with uniformly distributed random numbers.


    """
    return _casadi.SX_rand(*args)

def SX_deserialize(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    SX_deserialize(std::istream & stream) -> SX
    SX_deserialize(std::string const & s) -> SX
    SX_deserialize(casadi::DeserializingStream & s) -> SX
    """
    return _casadi.SX_deserialize(*args)

def SX_from_file(*args) -> "casadi::Matrix< double >":
    r"""
    SX_from_file(std::string const & filename, std::string const & format_hint="") -> DM


    Export numerical matrix to file

    Supported formats:



    ::

      *   - .mtx   Matrix Market (sparse)
      *   - .txt   Ascii full precision representation (sparse)
      *            Whitespace separated, aligned.
      *            Comments with # % or /
      *            Uses C locale
      *            Structural zeros represented by 00
      *            Does not scale well for large sparse matrices
      * 




    """
    return _casadi.SX_from_file(*args)

class MX(GenericExpressionCommon, PrintableCommon, GenMX, SharedObject):
    r"""


    MX - Matrix expression.

    The MX class is used to build up trees made up from MXNodes. It is a more
    general graph representation than the scalar expression, SX, and much less
    efficient for small objects. On the other hand, the class allows much more
    general operations than does SX, in particular matrix valued operations and
    calls to arbitrary differentiable functions.

    The MX class is designed to have identical syntax with the Matrix<> template
    class, and uses DM (i.e. Matrix<double>) as its internal representation of
    the values at a node. By keeping the syntaxes identical, it is possible to
    switch from one class to the other, as well as inlining MX functions to
    SXElem functions.

    Note that an operation is always "lazy", making a matrix multiplication
    will create a matrix multiplication node, not perform the actual
    multiplication.

    Joel Andersson

    C++ includes: mx.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def type_name(*args) -> "std::string":
        r"""type_name() -> std::string"""
        return _casadi.MX_type_name(*args)

    def __init__(self, *args):
        r"""
        __init__(MX self) -> MX
        __init__(MX self, casadi_int nrow, casadi_int ncol) -> MX
        __init__(MX self, Sparsity sp) -> MX
        __init__(MX self, Sparsity sp, MX val) -> MX
        __init__(MX self, Sparsity sp, std::string const & fname) -> MX
        __init__(MX self, double x) -> MX
        __init__(MX self, MX x) -> MX
        __init__(MX self, DM x) -> MX
        """
        _casadi.MX_swiginit(self, _casadi.new_MX(*args))
    __swig_destroy__ = _casadi.delete_MX

    def __bool__(self, *args) -> "bool":
        r"""
        __bool__(MX self) -> bool


        Returns the truth value of an MX expression.


        """
        return _casadi.MX___bool__(self, *args)

    def sparsity(self, *args) -> "casadi::Sparsity":
        r"""
        sparsity(MX self) -> Sparsity


        Get an owning reference to the sparsity pattern.


        """
        return _casadi.MX_sparsity(self, *args)

    def erase(self, *args) -> "void":
        r"""
        erase(MX self, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, std::vector< casadi_int,std::allocator< casadi_int > > const & cc, bool ind1=False)
        erase(MX self, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, bool ind1=False)


        Erase a submatrix (leaving structural zeros in its place) Erase elements of
        a matrix.


        """
        return _casadi.MX_erase(self, *args)

    def enlarge(self, *args) -> "void":
        r"""
        enlarge(MX self, casadi_int nrow, casadi_int ncol, std::vector< casadi_int,std::allocator< casadi_int > > const & rr, std::vector< casadi_int,std::allocator< casadi_int > > const & cc, bool ind1=False)


        Enlarge matrix Make the matrix larger by inserting empty rows and columns,
        keeping the existing non-zeros.


        """
        return _casadi.MX_enlarge(self, *args)

    def __neg__(self, *args) -> "casadi::MX":
        r"""__neg__(MX self) -> MX"""
        return _casadi.MX___neg__(self, *args)

    def dep(self, *args) -> "casadi::MX":
        r"""
        dep(MX self, casadi_int ch=0) -> MX


        Get the nth dependency as MX.


        """
        return _casadi.MX_dep(self, *args)

    def n_out(self, *args) -> "casadi_int":
        r"""
        n_out(MX self) -> casadi_int


        Number of outputs.


        """
        return _casadi.MX_n_out(self, *args)

    def get_output(self, *args) -> "casadi::MX":
        r"""
        get_output(MX self, casadi_int oind) -> MX


        Get an output.


        """
        return _casadi.MX_get_output(self, *args)

    def n_dep(self, *args) -> "casadi_int":
        r"""
        n_dep(MX self) -> casadi_int


        Get the number of dependencies of a binary SXElem.


        """
        return _casadi.MX_n_dep(self, *args)

    def name(self, *args) -> "std::string":
        r"""
        name(MX self) -> std::string


        Get the name.


        """
        return _casadi.MX_name(self, *args)

    def __float__(self, *args) -> "double":
        r"""__float__(MX self) -> double"""
        return _casadi.MX___float__(self, *args)

    def to_DM(self, *args) -> "casadi::Matrix< double >":
        r"""to_DM(MX self) -> DM"""
        return _casadi.MX_to_DM(self, *args)

    def is_symbolic(self, *args) -> "bool":
        r"""
        is_symbolic(MX self) -> bool


        Check if symbolic.


        """
        return _casadi.MX_is_symbolic(self, *args)

    def is_constant(self, *args) -> "bool":
        r"""
        is_constant(MX self) -> bool


        Check if constant.


        """
        return _casadi.MX_is_constant(self, *args)

    def is_call(self, *args) -> "bool":
        r"""
        is_call(MX self) -> bool


        Check if evaluation.


        """
        return _casadi.MX_is_call(self, *args)

    def which_function(self, *args) -> "casadi::Function":
        r"""
        which_function(MX self) -> Function


        Get function - only valid when is_call() is true.


        """
        return _casadi.MX_which_function(self, *args)

    def is_output(self, *args) -> "bool":
        r"""
        is_output(MX self) -> bool


        Check if evaluation output.


        """
        return _casadi.MX_is_output(self, *args)

    def which_output(self, *args) -> "casadi_int":
        r"""
        which_output(MX self) -> casadi_int


        Get the index of evaluation output - only valid when is_output() is true.


        """
        return _casadi.MX_which_output(self, *args)

    def is_op(self, *args) -> "bool":
        r"""
        is_op(MX self, casadi_int op) -> bool


        Is it a certain operation.


        """
        return _casadi.MX_is_op(self, *args)

    def is_multiplication(self, *args) -> "bool":
        r"""
        is_multiplication(MX self) -> bool


        Check if multiplication.


        """
        return _casadi.MX_is_multiplication(self, *args)

    def is_commutative(self, *args) -> "bool":
        r"""
        is_commutative(MX self) -> bool


        Check if commutative operation.


        """
        return _casadi.MX_is_commutative(self, *args)

    def is_norm(self, *args) -> "bool":
        r"""
        is_norm(MX self) -> bool


        Check if norm.


        """
        return _casadi.MX_is_norm(self, *args)

    def is_valid_input(self, *args) -> "bool":
        r"""
        is_valid_input(MX self) -> bool


        Check if matrix can be used to define function inputs. Valid inputs for
        MXFunctions are combinations of Reshape, concatenations and SymbolicMX.


        """
        return _casadi.MX_is_valid_input(self, *args)

    def n_primitives(self, *args) -> "casadi_int":
        r"""
        n_primitives(MX self) -> casadi_int


        Get the number of primitives for MXFunction inputs/outputs.


        """
        return _casadi.MX_n_primitives(self, *args)

    def primitives(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""
        primitives(MX self) -> std::vector< casadi::MX,std::allocator< casadi::MX > >


        Get primitives.


        """
        return _casadi.MX_primitives(self, *args)

    def split_primitives(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""
        split_primitives(MX self, MX x) -> std::vector< casadi::MX,std::allocator< casadi::MX > >


        Split up an expression along symbolic primitives.


        """
        return _casadi.MX_split_primitives(self, *args)

    def join_primitives(self, *args) -> "casadi::MX":
        r"""
        join_primitives(MX self, std::vector< casadi::MX,std::allocator< casadi::MX > > const & v) -> MX


        Join an expression along symbolic primitives.


        """
        return _casadi.MX_join_primitives(self, *args)

    def has_duplicates(self, *args) -> "bool":
        r"""
        has_duplicates(MX self) -> bool


        [INTERNAL]  Detect duplicate symbolic expressions If there are symbolic
        primitives appearing more than once, the function will return true and the
        names of the duplicate expressions will be passed to casadi_warning. Note:
        Will mark the node using MX::set_temp. Make sure to call reset_input() after
        usage.


        """
        return _casadi.MX_has_duplicates(self, *args)

    def reset_input(self, *args) -> "void":
        r"""
        reset_input(MX self)


        [INTERNAL]  Reset the marker for an input expression.


        """
        return _casadi.MX_reset_input(self, *args)

    def is_eye(self, *args) -> "bool":
        r"""
        is_eye(MX self) -> bool


        check if identity


        """
        return _casadi.MX_is_eye(self, *args)

    def is_zero(self, *args) -> "bool":
        r"""
        is_zero(MX self) -> bool


        check if zero (note that false negative answers are possible)


        """
        return _casadi.MX_is_zero(self, *args)

    def is_one(self, *args) -> "bool":
        r"""
        is_one(MX self) -> bool


        check if zero (note that false negative answers are possible)


        """
        return _casadi.MX_is_one(self, *args)

    def is_minus_one(self, *args) -> "bool":
        r"""
        is_minus_one(MX self) -> bool


        check if zero (note that false negative answers are possible)


        """
        return _casadi.MX_is_minus_one(self, *args)

    def is_transpose(self, *args) -> "bool":
        r"""
        is_transpose(MX self) -> bool


        Is the expression a transpose?


        """
        return _casadi.MX_is_transpose(self, *args)

    def is_regular(self, *args) -> "bool":
        r"""
        is_regular(MX self) -> bool


        Checks if expression does not contain NaN or Inf.


        """
        return _casadi.MX_is_regular(self, *args)

    def is_binary(self, *args) -> "bool":
        r"""
        is_binary(MX self) -> bool


        Is binary operation.


        """
        return _casadi.MX_is_binary(self, *args)

    def is_unary(self, *args) -> "bool":
        r"""
        is_unary(MX self) -> bool


        Is unary operation.


        """
        return _casadi.MX_is_unary(self, *args)

    def op(self, *args) -> "casadi_int":
        r"""
        op(MX self) -> casadi_int


        Get operation type.


        """
        return _casadi.MX_op(self, *args)

    def info(self, *args) -> "casadi::Dict":
        r"""
        info(MX self) -> casadi::Dict


        Obtain information about node


        """
        return _casadi.MX_info(self, *args)

    def serialize(self, *args) -> "void":
        r"""
        serialize(MX self, casadi::SerializingStream & s)


        Serialize an object.


        """
        return _casadi.MX_serialize(self, *args)

    @staticmethod
    def deserialize(*args) -> "casadi::MX":
        r"""deserialize(casadi::DeserializingStream & s) -> MX"""
        return _casadi.MX_deserialize(*args)

    def get_temp(self, *args) -> "casadi_int":
        r"""
        get_temp(MX self) -> casadi_int


        [INTERNAL]  Get the temporary variable


        """
        return _casadi.MX_get_temp(self, *args)

    def set_temp(self, *args) -> "void":
        r"""
        set_temp(MX self, casadi_int t)


        [INTERNAL]  Set the temporary variable.


        """
        return _casadi.MX_set_temp(self, *args)

    @staticmethod
    def binary(*args) -> "casadi::MX":
        r"""
        binary(casadi_int op, MX x, MX y) -> MX


        Create nodes by their ID.


        """
        return _casadi.MX_binary(*args)

    @staticmethod
    def unary(*args) -> "casadi::MX":
        r"""
        unary(casadi_int op, MX x) -> MX


        Create nodes by their ID.


        """
        return _casadi.MX_unary(*args)

    @staticmethod
    def inf(*args) -> "casadi::MX":
        r"""
        inf(Sparsity sp) -> MX
        inf(casadi_int nrow=1, casadi_int ncol=1) -> MX
        inf(std::pair< casadi_int,casadi_int > const & rc) -> MX


        create a matrix with all inf


        """
        return _casadi.MX_inf(*args)

    @staticmethod
    def nan(*args) -> "casadi::MX":
        r"""
        nan(Sparsity sp) -> MX
        nan(casadi_int nrow=1, casadi_int ncol=1) -> MX
        nan(std::pair< casadi_int,casadi_int > const & rc) -> MX


        create a matrix with all nan


        """
        return _casadi.MX_nan(*args)

    @staticmethod
    def eye(*args) -> "casadi::MX":
        r"""eye(casadi_int n) -> MX"""
        return _casadi.MX_eye(*args)

    def get(self, *args) -> "void":
        r"""
        get(MX self, bool ind1, Slice rr)
        get(MX self, bool ind1, casadi::Matrix< casadi_int > const & rr)
        get(MX self, bool ind1, Sparsity sp)
        get(MX self, bool ind1, MX rr)
        get(MX self, bool ind1, casadi_int const rr)
        get(MX self, bool ind1, Slice rr, Slice cc)
        get(MX self, bool ind1, Slice rr, casadi::Matrix< casadi_int > const & cc)
        get(MX self, bool ind1, Slice rr, casadi_int cc)
        get(MX self, bool ind1, casadi::Matrix< casadi_int > const & rr, Slice cc)
        get(MX self, bool ind1, casadi_int rr, Slice cc)
        get(MX self, bool ind1, casadi::Matrix< casadi_int > const & rr, casadi::Matrix< casadi_int > const & cc)
        get(MX self, bool ind1, casadi_int rr, casadi_int cc)
        get(MX self, bool ind1, MX rr, Slice cc)
        get(MX self, bool ind1, Slice rr, MX cc)
        get(MX self, bool ind1, MX rr, MX cc)


        Get a submatrix, two arguments


        """
        return _casadi.MX_get(self, *args)

    def set(self, *args) -> "void":
        r"""
        set(MX self, MX m, bool ind1, Slice rr)
        set(MX self, MX m, bool ind1, casadi::Matrix< casadi_int > const & rr)
        set(MX self, MX m, bool ind1, Sparsity sp)
        set(MX self, MX m, bool ind1, Slice rr, Slice cc)
        set(MX self, MX m, bool ind1, Slice rr, casadi::Matrix< casadi_int > const & cc)
        set(MX self, MX m, bool ind1, casadi::Matrix< casadi_int > const & rr, Slice cc)
        set(MX self, MX m, bool ind1, casadi::Matrix< casadi_int > const & rr, casadi::Matrix< casadi_int > const & cc)
        """
        return _casadi.MX_set(self, *args)

    def get_nz(self, *args) -> "void":
        r"""
        get_nz(MX self, bool ind1, Slice kk)
        get_nz(MX self, bool ind1, casadi::Matrix< casadi_int > const & kk)
        get_nz(MX self, bool ind1, MX kk)
        get_nz(MX self, bool ind1, casadi_int kk)
        get_nz(MX self, bool ind1, MX inner, Slice outer)
        get_nz(MX self, bool ind1, Slice inner, MX outer)
        get_nz(MX self, bool ind1, MX inner, MX outer)


        Get a set of nonzeros


        """
        return _casadi.MX_get_nz(self, *args)

    def set_nz(self, *args) -> "void":
        r"""
        set_nz(MX self, MX m, bool ind1, Slice kk)
        set_nz(MX self, MX m, bool ind1, casadi::Matrix< casadi_int > const & kk)
        set_nz(MX self, MX m, bool ind1, MX kk)
        set_nz(MX self, MX m, bool ind1, casadi_int kk)


        Set a set of nonzeros


        """
        return _casadi.MX_set_nz(self, *args)

    @staticmethod
    def einstein(*args) -> "casadi::MX":
        r"""
        einstein(MX A, MX B, MX C, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_a, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_b, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_c, std::vector< casadi_int,std::allocator< casadi_int > > const & a, std::vector< casadi_int,std::allocator< casadi_int > > const & b, std::vector< casadi_int,std::allocator< casadi_int > > const & c) -> MX
        einstein(MX A, MX B, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_a, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_b, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_c, std::vector< casadi_int,std::allocator< casadi_int > > const & a, std::vector< casadi_int,std::allocator< casadi_int > > const & b, std::vector< casadi_int,std::allocator< casadi_int > > const & c) -> MX


        Computes an einstein dense tensor contraction.

        Computes the product: C_c = A_a + B_b where a b c are index/einstein
        notation in an encoded form

        For example, an matrix-matrix product may be written as: C_ij = A_ik B_kj

        The encoded form uses strictly negative numbers to indicate labels. For the
        above example, we would have: a {-1, -3} b {-3, -2} c {-1 -2}


        """
        return _casadi.MX_einstein(*args)

    @staticmethod
    def bspline_dual(*args) -> "casadi::DM":
        r"""
        bspline_dual(std::vector< double,std::allocator< double > > const & x, std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const & knots, std::vector< casadi_int,std::allocator< casadi_int > > const & degree, casadi::Dict const & opts=casadi::Dict()) -> DM


        Find first nonzero If failed, returns the number of rows.


        """
        return _casadi.MX_bspline_dual(*args)

    @staticmethod
    def interpn_linear(*args) -> "casadi::MX":
        r"""interpn_linear(std::vector< casadi::MX,std::allocator< casadi::MX > > const & x, MX v, std::vector< casadi::MX,std::allocator< casadi::MX > > const & xq, casadi::Dict const & opts=casadi::Dict()) -> MX"""
        return _casadi.MX_interpn_linear(*args)

    def printme(self, *args) -> "casadi::MX":
        r"""printme(MX self, MX b) -> MX"""
        return _casadi.MX_printme(self, *args)

    def attachAssert(self, *args) -> "casadi::MX":
        r"""
        attachAssert(MX self, MX y, std::string const & fail_message="") -> MX


        returns itself, but with an assertion attached

        If y does not evaluate to 1, a runtime error is raised


        """
        return _casadi.MX_attachAssert(self, *args)

    def monitor(self, *args) -> "casadi::MX":
        r"""
        monitor(MX self, std::string const & comment) -> MX


        Monitor an expression Returns itself, but with the side effect of printing
        the nonzeros along with a comment.


        """
        return _casadi.MX_monitor(self, *args)

    def mapping(self, *args) -> "casadi::Matrix< casadi_int >":
        r"""
        mapping(MX self) -> casadi::Matrix< casadi_int >


        Get an IM representation of a GetNonzeros or SetNonzeros node.


        """
        return _casadi.MX_mapping(self, *args)

    @staticmethod
    def set_max_depth(*args) -> "void":
        r"""set_max_depth(casadi_int eq_depth=1)"""
        return _casadi.MX_set_max_depth(*args)

    @staticmethod
    def get_max_depth(*args) -> "casadi_int":
        r"""get_max_depth() -> casadi_int"""
        return _casadi.MX_get_max_depth(*args)

    @staticmethod
    def test_cast(*args) -> "bool":
        r"""test_cast(casadi::SharedObjectInternal const * ptr) -> bool"""
        return _casadi.MX_test_cast(*args)

    @staticmethod
    def get_input(*args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""get_input(Function f) -> std::vector< casadi::MX,std::allocator< casadi::MX > >"""
        return _casadi.MX_get_input(*args)

    @staticmethod
    def get_free(*args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""get_free(Function f) -> std::vector< casadi::MX,std::allocator< casadi::MX > >"""
        return _casadi.MX_get_free(*args)

    @property
    def shape(self):
        return (self.size1(),self.size2())

    def reshape(self,arg):
        return _casadi.reshape(self,arg)

    @property
    def T(self):
        return _casadi.transpose(self)

    def __getitem__(self, s):
          if isinstance(s, tuple) and len(s)==2:
            if s[1] is None: raise TypeError("Cannot slice with None")
            return self.get(False, s[0], s[1])
          return self.get(False, s)

    def __iter__(self):
      raise Exception("""CasADi matrices are not iterable by design.
                      Did you mean to iterate over m.nz, with m IM/DM/SX?
                      Did you mean to iterate over horzsplit(m,1)/vertsplit(m,1) with m IM/DM/SX/MX?
                      """)

    def __setitem__(self,s,val):
          if isinstance(s,tuple) and len(s)==2:
            return self.set(val, False, s[0], s[1])
          return self.set(val, False, s)

    @property
    def nz(self):
      return NZproxy(self)




    __array_priority__ = 1002.0

    def __array_wrap__(self,out_arr,context=None):
      if context is None:
        return out_arr
      name = context[0].__name__
      args = list(context[1])

      if len(context[1])==3:
        raise Exception("Error with %s. Looks like you are using an assignment operator, such as 'a+=b' where 'a' is a numpy type. This is not supported, and cannot be supported without changing numpy." % name)

      if "vectorized" in name:
          name = name[:-len(" (vectorized)")]

      conversion = {"multiply": "mul", "divide": "div", "true_divide": "div", "subtract":"sub","power":"pow","greater_equal":"ge","less_equal": "le", "less": "lt", "greater": "gt"}
      if name in conversion:
        name = conversion[name]
      if len(context[1])==2 and context[1][1] is self and not(context[1][0] is self):
        name = 'r' + name
        args.reverse()
      if not(hasattr(self,name)) or ('mul' in name):
        name = '__' + name + '__'
      fun=getattr(self, name)
      return fun(*args[1:])

    def __array_ufunc__(self, ufunc, method, *inputs, **kwargs):
      conversion = {"multiply": "mul", "divide": "div", "true_divide": "div", "subtract":"sub","power":"pow","greater_equal":"ge","less_equal": "le", "less": "lt", "greater": "gt"}
      name = ufunc.__name__
      inputs = list(inputs)
      if len(inputs)==3:
        import warnings
        warnings.warn("Error with %s. Looks like you are using an assignment operator, such as 'a+=b' where 'a' is a numpy type. This is not supported, and cannot be supported without changing numpy." % name, RuntimeWarning)
        return NotImplemented
      if "vectorized" in name:
          name = name[:-len(" (vectorized)")]
      if name in conversion:
        name = conversion[name]
      if len(inputs)==2 and inputs[1] is self and not(inputs[0] is self):
        name = 'r' + name
        inputs.reverse()
      if not(hasattr(self,name)) or ('mul' in name):
        name = '__' + name + '__'
      try:
        assert method=="__call__"
        fun=getattr(self, name)
        return fun(*inputs[1:])
      except:
#Fall back to numpy conversion
        new_inputs = list(inputs)
        try:
          new_inputs[0] = new_inputs[0].full()
        except:
          import warnings
          warnings.warn("Implicit conversion of symbolic CasADi type to numeric matrix not supported.\n"
                                 + "This may occur when you pass a CasADi object to a numpy function.\n"
                                 + "Use an equivalent CasADi function instead of that numpy function.", RuntimeWarning)
          return NotImplemented
        return new_inputs[0].__array_ufunc__(ufunc, method, *new_inputs, **kwargs)


    def __array__(self,*args,**kwargs):
      import numpy as n
      if len(args) > 1 and isinstance(args[1],tuple) and isinstance(args[1][0],n.ufunc) and isinstance(args[1][0],n.ufunc) and len(args[1])>1 and args[1][0].nin==len(args[1][1]):
        if len(args[1][1])==3:
          raise Exception("Error with %s. Looks like you are using an assignment operator, such as 'a+=b'. This is not supported when 'a' is a numpy type, and cannot be supported without changing numpy itself. Either upgrade a to a CasADi type first, or use 'a = a + b'. " % args[1][0].__name__)
        return n.array([n.nan])
      else:
        if hasattr(self,'__array_custom__'):
          return self.__array_custom__(*args,**kwargs)
        else:
          try:
            return self.full()
          except:
            raise Exception("Implicit conversion of symbolic CasADi type to numeric matrix not supported.\n"
                       + "This may occur when you pass a CasADi object to a numpy function.\n"
                       + "Use an equivalent CasADi function instead of that numpy function.")



# Register MX in _casadi:
_casadi.MX_swigregister(MX)

def MX_type_name(*args) -> "std::string":
    r"""MX_type_name() -> std::string"""
    return _casadi.MX_type_name(*args)

def MX_deserialize(*args) -> "casadi::MX":
    r"""MX_deserialize(casadi::DeserializingStream & s) -> MX"""
    return _casadi.MX_deserialize(*args)

def MX_binary(*args) -> "casadi::MX":
    r"""
    MX_binary(casadi_int op, MX x, MX y) -> MX


    Create nodes by their ID.


    """
    return _casadi.MX_binary(*args)

def MX_unary(*args) -> "casadi::MX":
    r"""
    MX_unary(casadi_int op, MX x) -> MX


    Create nodes by their ID.


    """
    return _casadi.MX_unary(*args)

def MX_inf(*args) -> "casadi::MX":
    r"""
    MX_inf(Sparsity sp) -> MX
    MX_inf(casadi_int nrow=1, casadi_int ncol=1) -> MX
    MX_inf(std::pair< casadi_int,casadi_int > const & rc) -> MX


    create a matrix with all inf


    """
    return _casadi.MX_inf(*args)

def MX_nan(*args) -> "casadi::MX":
    r"""
    MX_nan(Sparsity sp) -> MX
    MX_nan(casadi_int nrow=1, casadi_int ncol=1) -> MX
    MX_nan(std::pair< casadi_int,casadi_int > const & rc) -> MX


    create a matrix with all nan


    """
    return _casadi.MX_nan(*args)

def MX_eye(*args) -> "casadi::MX":
    r"""MX_eye(casadi_int n) -> MX"""
    return _casadi.MX_eye(*args)

def MX_einstein(*args) -> "casadi::MX":
    r"""
    MX_einstein(MX A, MX B, MX C, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_a, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_b, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_c, std::vector< casadi_int,std::allocator< casadi_int > > const & a, std::vector< casadi_int,std::allocator< casadi_int > > const & b, std::vector< casadi_int,std::allocator< casadi_int > > const & c) -> MX
    MX_einstein(MX A, MX B, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_a, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_b, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_c, std::vector< casadi_int,std::allocator< casadi_int > > const & a, std::vector< casadi_int,std::allocator< casadi_int > > const & b, std::vector< casadi_int,std::allocator< casadi_int > > const & c) -> MX


    Computes an einstein dense tensor contraction.

    Computes the product: C_c = A_a + B_b where a b c are index/einstein
    notation in an encoded form

    For example, an matrix-matrix product may be written as: C_ij = A_ik B_kj

    The encoded form uses strictly negative numbers to indicate labels. For the
    above example, we would have: a {-1, -3} b {-3, -2} c {-1 -2}


    """
    return _casadi.MX_einstein(*args)

def MX_bspline_dual(*args) -> "casadi::DM":
    r"""
    MX_bspline_dual(std::vector< double,std::allocator< double > > const & x, std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const & knots, std::vector< casadi_int,std::allocator< casadi_int > > const & degree, casadi::Dict const & opts=casadi::Dict()) -> DM


    Find first nonzero If failed, returns the number of rows.


    """
    return _casadi.MX_bspline_dual(*args)

def MX_interpn_linear(*args) -> "casadi::MX":
    r"""MX_interpn_linear(std::vector< casadi::MX,std::allocator< casadi::MX > > const & x, MX v, std::vector< casadi::MX,std::allocator< casadi::MX > > const & xq, casadi::Dict const & opts=casadi::Dict()) -> MX"""
    return _casadi.MX_interpn_linear(*args)

def MX_set_max_depth(*args) -> "void":
    r"""MX_set_max_depth(casadi_int eq_depth=1)"""
    return _casadi.MX_set_max_depth(*args)

def MX_get_max_depth(*args) -> "casadi_int":
    r"""MX_get_max_depth() -> casadi_int"""
    return _casadi.MX_get_max_depth(*args)

def MX_test_cast(*args) -> "bool":
    r"""MX_test_cast(casadi::SharedObjectInternal const * ptr) -> bool"""
    return _casadi.MX_test_cast(*args)

def MX_get_input(*args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
    r"""MX_get_input(Function f) -> std::vector< casadi::MX,std::allocator< casadi::MX > >"""
    return _casadi.MX_get_input(*args)

def MX_get_free(*args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
    r"""MX_get_free(Function f) -> std::vector< casadi::MX,std::allocator< casadi::MX > >"""
    return _casadi.MX_get_free(*args)


def attach_return_type(f,t):
  if not(hasattr(f,'func_annotations')):
    f.func_annotations = {}
  if not(isinstance(getattr(f,'func_annotations'),dict)):
    raise Exception("Cannot annotate this python Method to be a sparsitygenerator. Method has func_annotations attribute with unknown type.")
  f.func_annotations["return"] = t
  return f

def pyevaluate(f):
  return attach_return_type(f,None)

def pycallback(f):
  return attach_return_type(f,int)


def pyfunction(inputs,outputs):
  def wrap(f):

    @pyevaluate
    def fcustom(f2):
      res = f([f2.getInput(i) for i in range(f2.n_in())])
      if not isinstance(res,list):
        res = [res]
      for i in range(f2.n_out()):
        f2.setOutput(res[i],i)
    import warnings

    with warnings.catch_warnings():
      warnings.filterwarnings("ignore",category=DeprecationWarning)
      Fun = CustomFunction("CustomFunction",fcustom,inputs,outputs)
      return Fun

  return wrap

def PyFunction(name, obj, inputs, outputs, opts={}):
    @pyevaluate
    def fcustom(f):
      res = [f.getOutput(i) for i in range(f.n_out())]
      obj.evaluate([f.getInput(i) for i in range(f.n_in())],res)
      for i in range(f.n_out()): f.setOutput(res[i], i)

    import warnings

    with warnings.catch_warnings():
      warnings.filterwarnings("ignore",category=DeprecationWarning)
      return CustomFunction("CustomFunction", fcustom,
                            inputs, outputs, opts)


class Function(SharedObject, PrintableCommon):
    r"""


    Function object A Function instance is a general multiple-input, multiple-
    output function where each input and output can be a sparse matrix. .

    For an introduction to this class, see the CasADi user guide. Function is a
    reference counted and immutable class; copying a class instance is very
    cheap and its behavior (with some exceptions) is not affected by calling its
    member functions. Joel Andersson >List of available options

    +------------------+-----------------+------------------+------------------+
    |        Id        |      Type       |   Description    |     Used in      |
    +==================+=================+==================+==================+
    | ad_weight        | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for derivative   | Internal         |
    |                  |                 | calculation.When |                  |
    |                  |                 | there is an      |                  |
    |                  |                 | option of either |                  |
    |                  |                 | using forward or |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | directional      |                  |
    |                  |                 | derivatives, the |                  |
    |                  |                 | condition ad_wei |                  |
    |                  |                 | ght*nf<=(1-ad_we |                  |
    |                  |                 | ight)*na is used |                  |
    |                  |                 | where nf and na  |                  |
    |                  |                 | are estimates of |                  |
    |                  |                 | the number of    |                  |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | mode directional |                  |
    |                  |                 | derivatives      |                  |
    |                  |                 | needed. By       |                  |
    |                  |                 | default,         |                  |
    |                  |                 | ad_weight is     |                  |
    |                  |                 | calculated       |                  |
    |                  |                 | automatically,   |                  |
    |                  |                 | but this can be  |                  |
    |                  |                 | overridden by    |                  |
    |                  |                 | setting this     |                  |
    |                  |                 | option. In       |                  |
    |                  |                 | particular, 0    |                  |
    |                  |                 | means forcing    |                  |
    |                  |                 | forward mode and |                  |
    |                  |                 | 1 forcing        |                  |
    |                  |                 | reverse mode.    |                  |
    |                  |                 | Leave unset for  |                  |
    |                  |                 | (class specific) |                  |
    |                  |                 | heuristics.      |                  |
    +------------------+-----------------+------------------+------------------+
    | ad_weight_sp     | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for sparsity     | Internal         |
    |                  |                 | pattern          |                  |
    |                  |                 | calculation calc |                  |
    |                  |                 | ulation.Override |                  |
    |                  |                 | s default        |                  |
    |                  |                 | behavior. Set to |                  |
    |                  |                 | 0 and 1 to force |                  |
    |                  |                 | forward and      |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | respectively.    |                  |
    |                  |                 | Cf. option       |                  |
    |                  |                 | "ad_weight".     |                  |
    |                  |                 | When set to -1,  |                  |
    |                  |                 | sparsity is      |                  |
    |                  |                 | completely       |                  |
    |                  |                 | ignored and      |                  |
    |                  |                 | dense matrices   |                  |
    |                  |                 | are used.        |                  |
    +------------------+-----------------+------------------+------------------+
    | always_inline    | OT_BOOL         | Force inlining.  | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | compiler         | OT_STRING       | Just-in-time     | casadi::Function |
    |                  |                 | compiler plugin  | Internal         |
    |                  |                 | to be used.      |                  |
    +------------------+-----------------+------------------+------------------+
    | custom_jacobian  | OT_FUNCTION     | Override         | casadi::Function |
    |                  |                 | CasADi's AD. Use | Internal         |
    |                  |                 | together with    |                  |
    |                  |                 | 'jac_penalty':   |                  |
    |                  |                 | 0. Note: Highly  |                  |
    |                  |                 | experimental.    |                  |
    |                  |                 | Syntax may break |                  |
    |                  |                 | often.           |                  |
    +------------------+-----------------+------------------+------------------+
    | derivative_of    | OT_FUNCTION     | The function is  | casadi::Function |
    |                  |                 | a derivative of  | Internal         |
    |                  |                 | another          |                  |
    |                  |                 | function. The    |                  |
    |                  |                 | type of          |                  |
    |                  |                 | derivative       |                  |
    |                  |                 | (directional     |                  |
    |                  |                 | derivative,      |                  |
    |                  |                 | Jacobian) is     |                  |
    |                  |                 | inferred from    |                  |
    |                  |                 | the function     |                  |
    |                  |                 | name.            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump             | OT_BOOL         | Dump function to | casadi::Function |
    |                  |                 | file upon first  | Internal         |
    |                  |                 | evaluation.      |                  |
    |                  |                 | [false]          |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_dir         | OT_STRING       | Directory to     | casadi::Function |
    |                  |                 | dump             | Internal         |
    |                  |                 | inputs/outputs   |                  |
    |                  |                 | to. Make sure    |                  |
    |                  |                 | the directory    |                  |
    |                  |                 | exists [.]       |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_format      | OT_STRING       | Choose file      | casadi::Function |
    |                  |                 | format to dump   | Internal         |
    |                  |                 | matrices. See    |                  |
    |                  |                 | DM.from_file     |                  |
    |                  |                 | [mtx]            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_in          | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | to file          |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_out         | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs to file  |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_fd        | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation by   |                  |
    |                  |                 | finite           |                  |
    |                  |                 | differencing.    |                  |
    |                  |                 | [default:        |                  |
    |                  |                 | false]]          |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_forward   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using forward    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_jacobian  | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobians of all |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | outputs with     |                  |
    |                  |                 | respect to all   |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | inputs - if      |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_reverse   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | transposed       |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using reverse    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_method        | OT_STRING       | Method for       | casadi::Function |
    |                  |                 | finite           | Internal         |
    |                  |                 | differencing     |                  |
    |                  |                 | [default         |                  |
    |                  |                 | 'central']       |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_options       | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | finite           |                  |
    |                  |                 | difference       |                  |
    |                  |                 | instance         |                  |
    +------------------+-----------------+------------------+------------------+
    | forward_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | forward mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | gather_stats     | OT_BOOL         | Deprecated       | casadi::Function |
    |                  |                 | option           | Internal         |
    |                  |                 | (ignored):       |                  |
    |                  |                 | Statistics are   |                  |
    |                  |                 | now always       |                  |
    |                  |                 | collected.       |                  |
    +------------------+-----------------+------------------+------------------+
    | input_scheme     | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | inputs_check     | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when the         | Internal         |
    |                  |                 | numerical values |                  |
    |                  |                 | of the inputs    |                  |
    |                  |                 | don't make sense |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_in       | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each input if it | Internal         |
    |                  |                 | should be        |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_out      | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each output if   | Internal         |
    |                  |                 | it should be     |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | jac_penalty      | OT_DOUBLE       | When requested   | casadi::Function |
    |                  |                 | for a number of  | Internal         |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | directions, it   |                  |
    |                  |                 | may be cheaper   |                  |
    |                  |                 | to compute first |                  |
    |                  |                 | the full         |                  |
    |                  |                 | jacobian and     |                  |
    |                  |                 | then multiply    |                  |
    |                  |                 | with seeds,      |                  |
    |                  |                 | rather than      |                  |
    |                  |                 | obtain the       |                  |
    |                  |                 | requested        |                  |
    |                  |                 | directions in a  |                  |
    |                  |                 | straightforward  |                  |
    |                  |                 | manner. Casadi   |                  |
    |                  |                 | uses a heuristic |                  |
    |                  |                 | to decide which  |                  |
    |                  |                 | is cheaper. A    |                  |
    |                  |                 | high value of    |                  |
    |                  |                 | 'jac_penalty'    |                  |
    |                  |                 | makes it less    |                  |
    |                  |                 | likely for the   |                  |
    |                  |                 | heurstic to      |                  |
    |                  |                 | chose the full   |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy. The    |                  |
    |                  |                 | special value -1 |                  |
    |                  |                 | indicates never  |                  |
    |                  |                 | to use the full  |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy         |                  |
    +------------------+-----------------+------------------+------------------+
    | jit              | OT_BOOL         | Use just-in-time | casadi::Function |
    |                  |                 | compiler to      | Internal         |
    |                  |                 | speed up the     |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_cleanup      | OT_BOOL         | Cleanup up the   | casadi::Function |
    |                  |                 | temporary source | Internal         |
    |                  |                 | file that jit    |                  |
    |                  |                 | creates.         |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_name         | OT_STRING       | The file name    | casadi::Function |
    |                  |                 | used to write    | Internal         |
    |                  |                 | out code. The    |                  |
    |                  |                 | actual file      |                  |
    |                  |                 | names used       |                  |
    |                  |                 | depend on 'jit_t |                  |
    |                  |                 | emp_suffix' and  |                  |
    |                  |                 | include          |                  |
    |                  |                 | extensions.      |                  |
    |                  |                 | Default:         |                  |
    |                  |                 | 'jit_tmp'        |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_options      | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | jit compiler.    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_serialize    | OT_STRING       | Specify          | casadi::Function |
    |                  |                 | behaviour when   | Internal         |
    |                  |                 | serializing a    |                  |
    |                  |                 | jitted function: |                  |
    |                  |                 | SOURCE|link|embe |                  |
    |                  |                 | d.               |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_temp_suffix  | OT_BOOL         | Use a temporary  | casadi::Function |
    |                  |                 | (seemingly       | Internal         |
    |                  |                 | random) filename |                  |
    |                  |                 | suffix for       |                  |
    |                  |                 | generated code   |                  |
    |                  |                 | and libraries.   |                  |
    |                  |                 | This is desired  |                  |
    |                  |                 | for thread-      |                  |
    |                  |                 | safety. This     |                  |
    |                  |                 | behaviour may    |                  |
    |                  |                 | defeat caching   |                  |
    |                  |                 | compiler         |                  |
    |                  |                 | wrappers.        |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | max_num_dir      | OT_INT          | Specify the      | casadi::Function |
    |                  |                 | maximum number   | Internal         |
    |                  |                 | of directions    |                  |
    |                  |                 | for derivative   |                  |
    |                  |                 | functions.       |                  |
    |                  |                 | Overrules the    |                  |
    |                  |                 | builtin optimize |                  |
    |                  |                 | d_num_dir.       |                  |
    +------------------+-----------------+------------------+------------------+
    | never_inline     | OT_BOOL         | Forbid inlining. | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | output_scheme    | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | print_in         | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_out        | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs          |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_time       | OT_BOOL         | print            | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time. Implies    |                  |
    |                  |                 | record_time.     |                  |
    +------------------+-----------------+------------------+------------------+
    | record_time      | OT_BOOL         | record           | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time, for        |                  |
    |                  |                 | retrieval with   |                  |
    |                  |                 | stats() .        |                  |
    +------------------+-----------------+------------------+------------------+
    | regularity_check | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when NaN or Inf  | Internal         |
    |                  |                 | appears during   |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | reverse_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | reverse mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | user_data        | OT_VOIDPTR      | A user-defined   | casadi::Function |
    |                  |                 | field that can   | Internal         |
    |                  |                 | be used to       |                  |
    |                  |                 | identify the     |                  |
    |                  |                 | function or pass |                  |
    |                  |                 | additional       |                  |
    |                  |                 | information      |                  |
    +------------------+-----------------+------------------+------------------+
    | verbose          | OT_BOOL         | Verbose          | casadi::Function |
    |                  |                 | evaluation  for  | Internal         |
    |                  |                 | debugging        |                  |
    +------------------+-----------------+------------------+------------------+

    C++ includes: function.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def type_name(*args) -> "std::string":
        r"""type_name() -> std::string"""
        return _casadi.Function_type_name(*args)

    @staticmethod
    def jit(*args) -> "casadi::Function":
        r"""
        jit(std::string const & name, std::string const & body, std::vector< std::string,std::allocator< std::string > > const & name_in, std::vector< std::string,std::allocator< std::string > > const & name_out, casadi::Dict const & opts=casadi::Dict()) -> Function
        jit(std::string const & name, std::string const & body, std::vector< std::string,std::allocator< std::string > > const & name_in, std::vector< std::string,std::allocator< std::string > > const & name_out, std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > > const & sparsity_in, std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > > const & sparsity_out, casadi::Dict const & opts=casadi::Dict()) -> Function


        To resolve ambiguity on some compilers.

        Create a just-in-time compiled function from a C language string The names
        and sparsity patterns of all the inputs and outputs must be provided. If
        sparsities are not provided, all inputs and outputs are assumed to be
        scalar. Only specify the function body, assuming that input and output
        nonzeros are stored in arrays with the specified naming convension. The data
        type used is 'casadi_real', which is typically equal to 'double` or another
        data type with the same API as 'double'.

        Inputs may be null pointers. This means that the all entries are zero.
        Outputs may be null points. This means that the corresponding result can be
        ignored.

        If an error occurs in the evaluation, issue "return 1;";

        The final generated function will have a structure similar to:

        casadi_int fname(const casadi_real** arg, casadi_real** res, casadi_int* iw,
        casadi_real* w, void* mem) { const casadi_real *x1, *x2; casadi_real *r1,
        *r2; x1 = *arg++; x2 = *arg++; r1 = *res++; r2 = *res++; <FUNCTION_BODY>
        return 0; }


        """
        return _casadi.Function_jit(*args)
    __swig_destroy__ = _casadi.delete_Function

    def expand(self, *args) -> "casadi::Function":
        r"""
        expand(Function self) -> Function
        expand(Function self, std::string const & name, casadi::Dict const & opts=casadi::Dict()) -> Function


        Expand a function to SX.


        """
        return _casadi.Function_expand(self, *args)

    def n_in(self, *args) -> "casadi_int":
        r"""
        n_in(Function self) -> casadi_int


        Get the number of function inputs.


        """
        return _casadi.Function_n_in(self, *args)

    def n_out(self, *args) -> "casadi_int":
        r"""
        n_out(Function self) -> casadi_int


        Get the number of function outputs.


        """
        return _casadi.Function_n_out(self, *args)

    def size1_in(self, *args) -> "casadi_int":
        r"""
        size1_in(Function self, casadi_int ind) -> casadi_int
        size1_in(Function self, std::string const & iname) -> casadi_int


        Get input dimension.


        """
        return _casadi.Function_size1_in(self, *args)

    def size2_in(self, *args) -> "casadi_int":
        r"""
        size2_in(Function self, casadi_int ind) -> casadi_int
        size2_in(Function self, std::string const & iname) -> casadi_int


        Get input dimension.


        """
        return _casadi.Function_size2_in(self, *args)

    def size_in(self, *args) -> "std::pair< casadi_int,casadi_int >":
        r"""
        size_in(Function self, casadi_int ind) -> std::pair< casadi_int,casadi_int >
        size_in(Function self, std::string const & iname) -> std::pair< casadi_int,casadi_int >


        Get input dimension.


        """
        return _casadi.Function_size_in(self, *args)

    def size1_out(self, *args) -> "casadi_int":
        r"""
        size1_out(Function self, casadi_int ind) -> casadi_int
        size1_out(Function self, std::string const & oname) -> casadi_int


        Get output dimension.


        """
        return _casadi.Function_size1_out(self, *args)

    def size2_out(self, *args) -> "casadi_int":
        r"""
        size2_out(Function self, casadi_int ind) -> casadi_int
        size2_out(Function self, std::string const & oname) -> casadi_int


        Get output dimension.


        """
        return _casadi.Function_size2_out(self, *args)

    def size_out(self, *args) -> "std::pair< casadi_int,casadi_int >":
        r"""
        size_out(Function self, casadi_int ind) -> std::pair< casadi_int,casadi_int >
        size_out(Function self, std::string const & oname) -> std::pair< casadi_int,casadi_int >


        Get output dimension.


        """
        return _casadi.Function_size_out(self, *args)

    def nnz_in(self, *args) -> "casadi_int":
        r"""
        nnz_in(Function self) -> casadi_int
        nnz_in(Function self, casadi_int ind) -> casadi_int
        nnz_in(Function self, std::string const & iname) -> casadi_int


        Get number of input nonzeros.

        For a particular input or for all of the inputs


        """
        return _casadi.Function_nnz_in(self, *args)

    def nnz_out(self, *args) -> "casadi_int":
        r"""
        nnz_out(Function self) -> casadi_int
        nnz_out(Function self, casadi_int ind) -> casadi_int
        nnz_out(Function self, std::string const & oname) -> casadi_int


        Get number of output nonzeros.

        For a particular output or for all of the outputs


        """
        return _casadi.Function_nnz_out(self, *args)

    def numel_in(self, *args) -> "casadi_int":
        r"""
        numel_in(Function self) -> casadi_int
        numel_in(Function self, casadi_int ind) -> casadi_int
        numel_in(Function self, std::string const & iname) -> casadi_int


        Get number of input elements.

        For a particular input or for all of the inputs


        """
        return _casadi.Function_numel_in(self, *args)

    def numel_out(self, *args) -> "casadi_int":
        r"""
        numel_out(Function self) -> casadi_int
        numel_out(Function self, casadi_int ind) -> casadi_int
        numel_out(Function self, std::string const & oname) -> casadi_int


        Get number of output elements.

        For a particular output or for all of the outputs


        """
        return _casadi.Function_numel_out(self, *args)

    def name_in(self, *args) -> "std::string const &":
        r"""
        name_in(Function self) -> std::vector< std::string,std::allocator< std::string > > const
        name_in(Function self, casadi_int ind) -> std::string const &


        Get input scheme name by index.


        """
        return _casadi.Function_name_in(self, *args)

    def name_out(self, *args) -> "std::string const &":
        r"""
        name_out(Function self) -> std::vector< std::string,std::allocator< std::string > > const
        name_out(Function self, casadi_int ind) -> std::string const &


        Get output scheme name by index.


        """
        return _casadi.Function_name_out(self, *args)

    def index_in(self, *args) -> "casadi_int":
        r"""
        index_in(Function self, std::string const & name) -> casadi_int


        Find the index for a string describing a particular entry of an input
        scheme.

        example: schemeEntry("x_opt") -> returns NLPSOL_X if FunctionInternal
        adheres to SCHEME_NLPINput


        """
        return _casadi.Function_index_in(self, *args)

    def index_out(self, *args) -> "casadi_int":
        r"""
        index_out(Function self, std::string const & name) -> casadi_int


        Find the index for a string describing a particular entry of an output
        scheme.

        example: schemeEntry("x_opt") -> returns NLPSOL_X if FunctionInternal
        adheres to SCHEME_NLPINput


        """
        return _casadi.Function_index_out(self, *args)

    def default_in(self, *args) -> "double":
        r"""
        default_in(Function self, casadi_int ind) -> double


        Get default input value.


        """
        return _casadi.Function_default_in(self, *args)

    def max_in(self, *args) -> "double":
        r"""
        max_in(Function self, casadi_int ind) -> double


        Get largest input value.


        """
        return _casadi.Function_max_in(self, *args)

    def min_in(self, *args) -> "double":
        r"""
        min_in(Function self, casadi_int ind) -> double


        Get smallest input value.


        """
        return _casadi.Function_min_in(self, *args)

    def sparsity_in(self, *args) -> "casadi::Sparsity const &":
        r"""
        sparsity_in(Function self, casadi_int ind) -> Sparsity
        sparsity_in(Function self, std::string const & iname) -> Sparsity


        Get sparsity of a given input.


        """
        return _casadi.Function_sparsity_in(self, *args)

    def sparsity_out(self, *args) -> "casadi::Sparsity const &":
        r"""
        sparsity_out(Function self, casadi_int ind) -> Sparsity
        sparsity_out(Function self, std::string const & iname) -> Sparsity


        Get sparsity of a given output.


        """
        return _casadi.Function_sparsity_out(self, *args)

    def is_diff_in(self, *args) -> "std::vector< bool,std::allocator< bool > >":
        r"""
        is_diff_in(Function self, casadi_int ind) -> bool
        is_diff_in(Function self) -> std::vector< bool,std::allocator< bool > >


        Get differentiability of inputs/output.


        """
        return _casadi.Function_is_diff_in(self, *args)

    def is_diff_out(self, *args) -> "std::vector< bool,std::allocator< bool > >":
        r"""
        is_diff_out(Function self, casadi_int ind) -> bool
        is_diff_out(Function self) -> std::vector< bool,std::allocator< bool > >


        Get differentiability of inputs/output.


        """
        return _casadi.Function_is_diff_out(self, *args)

    def factory(self, *args) -> "casadi::Function":
        r"""factory(Function self, std::string const & name, std::vector< std::string,std::allocator< std::string > > const & s_in, std::vector< std::string,std::allocator< std::string > > const & s_out, casadi::Function::AuxOut const & aux=casadi::Function::AuxOut(), casadi::Dict const & opts=casadi::Dict()) -> Function"""
        return _casadi.Function_factory(self, *args)

    def oracle(self, *args) -> "casadi::Function":
        r"""
        oracle(Function self) -> Function


        Get oracle.


        """
        return _casadi.Function_oracle(self, *args)

    def wrap(self, *args) -> "casadi::Function":
        r"""
        wrap(Function self) -> Function


        Wrap in an Function instance consisting of only one MX call.


        """
        return _casadi.Function_wrap(self, *args)

    def wrap_as_needed(self, *args) -> "casadi::Function":
        r"""
        wrap_as_needed(Function self, casadi::Dict const & opts) -> Function


        Wrap in a Function with options.


        """
        return _casadi.Function_wrap_as_needed(self, *args)

    def which_depends(self, *args) -> "std::vector< bool,std::allocator< bool > >":
        r"""
        which_depends(Function self, std::string const & s_in, std::vector< std::string,std::allocator< std::string > > const & s_out, casadi_int order=1, bool tr=False) -> std::vector< bool,std::allocator< bool > >


        Which variables enter with some order.

        Parameters:
        -----------

        order:  Only 1 (linear) and 2 (nonlinear) allowed

        tr:  Flip the relationship. Return which expressions contain the variables


        """
        return _casadi.Function_which_depends(self, *args)

    def print_dimensions(self, *args) -> "void":
        r"""
        print_dimensions(Function self)


        Print dimensions of inputs and outputs.


        """
        return _casadi.Function_print_dimensions(self, *args)

    def print_options(self, *args) -> "void":
        r"""
        print_options(Function self)


        Print options to a stream.


        """
        return _casadi.Function_print_options(self, *args)

    def print_option(self, *args) -> "void":
        r"""
        print_option(Function self, std::string const & name)


        Print all information there is to know about a certain option.


        """
        return _casadi.Function_print_option(self, *args)

    def uses_output(self, *args) -> "bool":
        r"""
        uses_output(Function self) -> bool


        Do the derivative functions need nondifferentiated outputs?


        """
        return _casadi.Function_uses_output(self, *args)

    def jacobian_old(self, *args) -> "casadi::Function":
        r"""
        jacobian_old(Function self, casadi_int iind, casadi_int oind) -> Function


        Generate a Jacobian function of output oind with respect to input iind.

        Parameters:
        -----------

        iind:  The index of the input

        oind:  The index of the output Legacy function: To be deprecated in a future
        version of CasADi. Exists only for compatibility with Function::jacobian
        pre-CasADi 3.2


        """
        return _casadi.Function_jacobian_old(self, *args)

    def hessian_old(self, *args) -> "casadi::Function":
        r"""
        hessian_old(Function self, casadi_int iind, casadi_int oind) -> Function


        Generate a Hessian function of output oind with respect to input iind.

        Parameters:
        -----------

        iind:  The index of the input

        oind:  The index of the output Legacy function: To be deprecated in a future
        version of CasADi. Exists only for compatibility with Function::hessian pre-
        CasADi 3.2


        """
        return _casadi.Function_hessian_old(self, *args)

    def jacobian(self, *args) -> "casadi::Function":
        r"""
        jacobian(Function self) -> Function


        Generate a Jacobian function of all the inputs elements with respect to all
        the output elements).


        """
        return _casadi.Function_jacobian(self, *args)

    def jac(self, *args) -> "casadi::Function":
        r"""
        jac(Function self) -> Function


        Calculate all Jacobian blocks Generates a function that takes all non-
        differentiated inputs and outputs and calculates all Jacobian blocks. Inputs
        that are not needed by the routine are all-zero sparse matrices with the
        correct dimensions. Output blocks that are not calculated, e.g. if the
        corresponding input or output is marked non-differentiated are also all-zero
        sparse. The Jacobian blocks are sorted starting by all the blocks for the
        first output, then all the blocks for the second output and so on. E.g.
        f:(x,y)->(r,s) results in the function jac_f:(x,y,r,s)->(dr_dx, dr_dy,
        ds_dx, ds_dy) This function is cached.


        """
        return _casadi.Function_jac(self, *args)

    def call(self, *args) -> "void":
        r"""
        call(Function self, std::vector< casadi::DM,std::allocator< casadi::DM > > const & arg, bool always_inline=False, bool never_inline=False)
        call(Function self, std::vector< casadi::SX,std::allocator< casadi::SX > > const & arg, bool always_inline=False, bool never_inline=False)
        call(Function self, std::vector< casadi::MX,std::allocator< casadi::MX > > const & arg, bool always_inline=False, bool never_inline=False)
        call(Function self, casadi::DMDict const & arg, bool always_inline=False, bool never_inline=False)
        call(Function self, casadi::SXDict const & arg, bool always_inline=False, bool never_inline=False)
        call(Function self, casadi::MXDict const & arg, bool always_inline=False, bool never_inline=False)


        Generate a Jacobian function of output oind with respect to input iind.

        Parameters:
        -----------

        iind:  The index of the input

        oind:  The index of the output Legacy function: To be deprecated in a future
        version of CasADi. Exists only for compatibility with Function::jacobian
        pre-CasADi 3.2


        """
        return _casadi.Function_call(self, *args)

    def mapsum(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""
        mapsum(Function self, std::vector< casadi::MX,std::allocator< casadi::MX > > const & x, std::string const & parallelization="serial") -> std::vector< casadi::MX,std::allocator< casadi::MX > >


        Evaluate symbolically in parallel and sum (matrix graph)

        Parameters:
        -----------

        parallelization:  Type of parallelization used: unroll|serial|openmp


        """
        return _casadi.Function_mapsum(self, *args)

    def mapaccum(self, *args) -> "casadi::Function":
        r"""
        mapaccum(Function self, std::string const & name, casadi_int N, casadi::Dict const & opts=casadi::Dict()) -> Function
        mapaccum(Function self, std::string const & name, casadi_int N, casadi_int n_accum, casadi::Dict const & opts=casadi::Dict()) -> Function
        mapaccum(Function self, std::string const & name, casadi_int n, std::vector< casadi_int,std::allocator< casadi_int > > const & accum_in, std::vector< casadi_int,std::allocator< casadi_int > > const & accum_out, casadi::Dict const & opts=casadi::Dict()) -> Function
        mapaccum(Function self, std::string const & name, casadi_int n, std::vector< std::string,std::allocator< std::string > > const & accum_in, std::vector< std::string,std::allocator< std::string > > const & accum_out, casadi::Dict const & opts=casadi::Dict()) -> Function
        mapaccum(Function self, casadi_int N, casadi::Dict const & opts=casadi::Dict()) -> Function


        Create a mapaccumulated version of this function.

        Suppose the function has a signature of:

        ::

             f: (x, u) -> (x_next , y )




        The the mapaccumulated version has the signature:

        ::

             F: (x0, U) -> (X , Y )

              with
                  U: horzcat([u0, u1, ..., u_(N-1)])
                  X: horzcat([x1, x2, ..., x_N])
                  Y: horzcat([y0, y1, ..., y_(N-1)])

              and
                  x1, y0 <- f(x0, u0)
                  x2, y1 <- f(x1, u1)
                  ...
                  x_N, y_(N-1) <- f(x_(N-1), u_(N-1))




        Mapaccum has the following benefits over writing an equivalent for- loop:
        much faster at construction time

        potentially much faster compilation times (for codegen)

        offers a trade-off between memory and evaluation time

        The base (settable through the options dictionary, default 10), is used to
        create a tower of function calls, containing unrolled for- loops of length
        maximum base.

        This technique is much more scalable in terms of memory-usage, but slightly
        slower at evaluation, than a plain for-loop. The effect is similar to that
        of a for-loop with a check-pointing instruction after each chunk of
        iterations with size base.

        Set base to -1 to unroll all the way; no gains in memory efficiency here.


        """
        return _casadi.Function_mapaccum(self, *args)

    def fold(self, *args) -> "casadi::Function":
        r"""
        fold(Function self, casadi_int N, casadi::Dict const & opts=casadi::Dict()) -> Function


        Create a mapaccumulated version of this function.

        Suppose the function has a signature of:

        ::

             f: (x, u) -> (x_next , y )




        The the mapaccumulated version has the signature:

        ::

             F: (x0, U) -> (X , Y )

              with
                  U: horzcat([u0, u1, ..., u_(N-1)])
                  X: horzcat([x1, x2, ..., x_N])
                  Y: horzcat([y0, y1, ..., y_(N-1)])

              and
                  x1, y0 <- f(x0, u0)
                  x2, y1 <- f(x1, u1)
                  ...
                  x_N, y_(N-1) <- f(x_(N-1), u_(N-1))




        Mapaccum has the following benefits over writing an equivalent for- loop:
        much faster at construction time

        potentially much faster compilation times (for codegen)

        offers a trade-off between memory and evaluation time

        The base (settable through the options dictionary, default 10), is used to
        create a tower of function calls, containing unrolled for- loops of length
        maximum base.

        This technique is much more scalable in terms of memory-usage, but slightly
        slower at evaluation, than a plain for-loop. The effect is similar to that
        of a for-loop with a check-pointing instruction after each chunk of
        iterations with size base.

        Set base to -1 to unroll all the way; no gains in memory efficiency here.


        """
        return _casadi.Function_fold(self, *args)

    def map(self, *args) -> "casadi::Function":
        r"""
        map(Function self, casadi_int n, std::string const & parallelization="serial") -> Function
        map(Function self, casadi_int n, std::string const & parallelization, casadi_int max_num_threads) -> Function
        map(Function self, std::string const & name, std::string const & parallelization, casadi_int n, std::vector< casadi_int,std::allocator< casadi_int > > const & reduce_in, std::vector< casadi_int,std::allocator< casadi_int > > const & reduce_out, casadi::Dict const & opts=casadi::Dict()) -> Function
        map(Function self, std::string const & name, std::string const & parallelization, casadi_int n, std::vector< std::string,std::allocator< std::string > > const & reduce_in, std::vector< std::string,std::allocator< std::string > > const & reduce_out, casadi::Dict const & opts=casadi::Dict()) -> Function
        map(Function self, casadi_int n, std::vector< bool,std::allocator< bool > > const & reduce_in, std::vector< bool,std::allocator< bool > > const & reduce_out=std::vector< bool >(), casadi::Dict const & opts=casadi::Dict()) -> Function


        Map with reduction A subset of the inputs are non-repeated and a subset of
        the outputs summed up.


        """
        return _casadi.Function_map(self, *args)

    def slice(self, *args) -> "casadi::Function":
        r"""
        slice(Function self, std::string const & name, std::vector< casadi_int,std::allocator< casadi_int > > const & order_in, std::vector< casadi_int,std::allocator< casadi_int > > const & order_out, casadi::Dict const & opts=casadi::Dict()) -> Function


        returns a new function with a selection of inputs/outputs of the original


        """
        return _casadi.Function_slice(self, *args)

    @staticmethod
    def conditional(*args) -> "casadi::Function":
        r"""conditional(std::string const & name, std::vector< casadi::Function,std::allocator< casadi::Function > > const & f, Function f_def, casadi::Dict const & opts=casadi::Dict()) -> Function"""
        return _casadi.Function_conditional(*args)

    @staticmethod
    def bspline(*args) -> "casadi::Function":
        r"""bspline(std::string const & name, std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const & knots, std::vector< double,std::allocator< double > > const & coeffs, std::vector< casadi_int,std::allocator< casadi_int > > const & degree, casadi_int m=1, casadi::Dict const & opts=casadi::Dict()) -> Function"""
        return _casadi.Function_bspline(*args)

    @staticmethod
    def if_else(*args) -> "casadi::Function":
        r"""if_else(std::string const & name, Function f_true, Function f_false, casadi::Dict const & opts=casadi::Dict()) -> Function"""
        return _casadi.Function_if_else(*args)

    def forward(self, *args) -> "casadi::Function":
        r"""
        forward(Function self, casadi_int nfwd) -> Function


        Get a function that calculates nfwd forward derivatives.

        Returns a function with n_in + n_out + n_in inputs and nfwd outputs. The
        first n_in inputs correspond to nondifferentiated inputs. The next n_out
        inputs correspond to nondifferentiated outputs. and the last n_in inputs
        correspond to forward seeds, stacked horizontally The n_out outputs
        correspond to forward sensitivities, stacked horizontally. * (n_in = n_in(),
        n_out = n_out())

        The functions returned are cached, meaning that if called multiple timed
        with the same value, then multiple references to the same function will be
        returned.


        """
        return _casadi.Function_forward(self, *args)

    def reverse(self, *args) -> "casadi::Function":
        r"""
        reverse(Function self, casadi_int nadj) -> Function


        Get a function that calculates nadj adjoint derivatives.

        Returns a function with n_in + n_out + n_out inputs and n_in outputs. The
        first n_in inputs correspond to nondifferentiated inputs. The next n_out
        inputs correspond to nondifferentiated outputs. and the last n_out inputs
        correspond to adjoint seeds, stacked horizontally The n_in outputs
        correspond to adjoint sensitivities, stacked horizontally. * (n_in = n_in(),
        n_out = n_out())

        (n_in = n_in(), n_out = n_out())

        The functions returned are cached, meaning that if called multiple timed
        with the same value, then multiple references to the same function will be
        returned.


        """
        return _casadi.Function_reverse(self, *args)

    def sparsity_jac(self, *args) -> "casadi::Sparsity const":
        r"""
        sparsity_jac(Function self, casadi_int iind, casadi_int oind, bool compact=False, bool symmetric=False) -> Sparsity
        sparsity_jac(Function self, std::string const & iind, casadi_int oind=0, bool compact=False, bool symmetric=False) -> Sparsity
        sparsity_jac(Function self, casadi_int iind, std::string const & oind, bool compact=False, bool symmetric=False) -> Sparsity
        sparsity_jac(Function self, std::string const & iind, std::string const & oind, bool compact=False, bool symmetric=False) -> Sparsity


        Get, if necessary generate, the sparsity of a Jacobian block


        """
        return _casadi.Function_sparsity_jac(self, *args)

    def generate(self, *args) -> "std::string":
        r"""
        generate(Function self, std::string const & fname, casadi::Dict const & opts=casadi::Dict()) -> std::string
        generate(Function self, casadi::Dict const & opts=casadi::Dict()) -> std::string


        Export / Generate C code for the function.


        """
        return _casadi.Function_generate(self, *args)

    def generate_dependencies(self, *args) -> "std::string":
        r"""
        generate_dependencies(Function self, std::string const & fname, casadi::Dict const & opts=casadi::Dict()) -> std::string


        Export / Generate C code for the dependency function.


        """
        return _casadi.Function_generate_dependencies(self, *args)

    def generate_in(self, *args) -> "std::vector< casadi::DM,std::allocator< casadi::DM > >":
        r"""
        generate_in(Function self, std::string const & fname, std::vector< casadi::DM,std::allocator< casadi::DM > > const & arg)
        generate_in(Function self, std::string const & fname) -> std::vector< casadi::DM,std::allocator< casadi::DM > >


        Export an input file that can be passed to generate C code with a main.

        generate_out  convert_in to convert between dict/map and vector


        """
        return _casadi.Function_generate_in(self, *args)

    def generate_out(self, *args) -> "std::vector< casadi::DM,std::allocator< casadi::DM > >":
        r"""
        generate_out(Function self, std::string const & fname, std::vector< casadi::DM,std::allocator< casadi::DM > > const & arg)
        generate_out(Function self, std::string const & fname) -> std::vector< casadi::DM,std::allocator< casadi::DM > >


        Export an output file that can be checked with generated C code output.

        generate_in  convert_out to convert between dict/map and vector


        """
        return _casadi.Function_generate_out(self, *args)

    def serialize(self, *args) -> "std::string":
        r"""
        serialize(Function self, casadi::Dict const & opts=casadi::Dict()) -> std::string


        Serialize.


        """
        return _casadi.Function_serialize(self, *args)

    def save(self, *args) -> "void":
        r"""
        save(Function self, std::string const & fname, casadi::Dict const & opts=casadi::Dict())


        Export function in specific language.

        Only allowed for (a subset of) SX/MX Functions


        """
        return _casadi.Function_save(self, *args)

    def export_code(self, *args) -> "std::string":
        r"""
        export_code(Function self, std::string const & lang, std::string const & fname, casadi::Dict const & options=casadi::Dict())
        export_code(Function self, std::string const & lang, casadi::Dict const & options=casadi::Dict()) -> std::string


        Export function in specific language.

        Only allowed for (a subset of) SX/MX Functions


        """
        return _casadi.Function_export_code(self, *args)

    def stats(self, *args) -> "casadi::Dict":
        r"""
        stats(Function self, int mem=0) -> casadi::Dict


        Get all statistics obtained at the end of the last evaluate call.


        """
        return _casadi.Function_stats(self, *args)

    def sx_in(self, *args) -> "std::vector< casadi::SX,std::allocator< casadi::SX > > const":
        r"""
        sx_in(Function self, casadi_int iind) -> SX
        sx_in(Function self, std::string const & iname) -> SX
        sx_in(Function self) -> std::vector< casadi::SX,std::allocator< casadi::SX > > const


        Get symbolic primitives equivalent to the input expressions There is no
        guarantee that subsequent calls return unique answers.


        """
        return _casadi.Function_sx_in(self, *args)

    def mx_in(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > > const":
        r"""
        mx_in(Function self, casadi_int ind) -> MX
        mx_in(Function self, std::string const & iname) -> MX
        mx_in(Function self) -> std::vector< casadi::MX,std::allocator< casadi::MX > > const


        Get symbolic primitives equivalent to the input expressions There is no
        guarantee that subsequent calls return unique answers.


        """
        return _casadi.Function_mx_in(self, *args)

    def sx_out(self, *args) -> "std::vector< casadi::SX,std::allocator< casadi::SX > > const":
        r"""
        sx_out(Function self, casadi_int oind) -> SX
        sx_out(Function self, std::string const & oname) -> SX
        sx_out(Function self) -> std::vector< casadi::SX,std::allocator< casadi::SX > > const


        Get symbolic primitives equivalent to the output expressions There is no
        guarantee that subsequent calls return unique answers.


        """
        return _casadi.Function_sx_out(self, *args)

    def mx_out(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > > const":
        r"""
        mx_out(Function self, casadi_int ind) -> MX
        mx_out(Function self, std::string const & oname) -> MX
        mx_out(Function self) -> std::vector< casadi::MX,std::allocator< casadi::MX > > const


        Get symbolic primitives equivalent to the output expressions There is no
        guarantee that subsequent calls return unique answers.


        """
        return _casadi.Function_mx_out(self, *args)

    def nz_from_in(self, *args) -> "std::vector< double,std::allocator< double > >":
        r"""
        nz_from_in(Function self, std::vector< casadi::DM,std::allocator< casadi::DM > > const & arg) -> std::vector< double,std::allocator< double > >


        Convert from/to flat vector of input/output nonzeros.


        """
        return _casadi.Function_nz_from_in(self, *args)

    def nz_from_out(self, *args) -> "std::vector< double,std::allocator< double > >":
        r"""
        nz_from_out(Function self, std::vector< casadi::DM,std::allocator< casadi::DM > > const & arg) -> std::vector< double,std::allocator< double > >


        Convert from/to flat vector of input/output nonzeros.


        """
        return _casadi.Function_nz_from_out(self, *args)

    def nz_to_in(self, *args) -> "std::vector< casadi::DM,std::allocator< casadi::DM > >":
        r"""
        nz_to_in(Function self, std::vector< double,std::allocator< double > > const & arg) -> std::vector< casadi::DM,std::allocator< casadi::DM > >


        Convert from/to flat vector of input/output nonzeros.


        """
        return _casadi.Function_nz_to_in(self, *args)

    def nz_to_out(self, *args) -> "std::vector< casadi::DM,std::allocator< casadi::DM > >":
        r"""
        nz_to_out(Function self, std::vector< double,std::allocator< double > > const & arg) -> std::vector< casadi::DM,std::allocator< casadi::DM > >


        Convert from/to flat vector of input/output nonzeros.


        """
        return _casadi.Function_nz_to_out(self, *args)

    def convert_in(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""
        convert_in(Function self, std::vector< casadi::DM,std::allocator< casadi::DM > > const & arg) -> casadi::DMDict
        convert_in(Function self, casadi::DMDict const & arg) -> std::vector< casadi::DM,std::allocator< casadi::DM > >
        convert_in(Function self, std::vector< casadi::SX,std::allocator< casadi::SX > > const & arg) -> casadi::SXDict
        convert_in(Function self, casadi::SXDict const & arg) -> std::vector< casadi::SX,std::allocator< casadi::SX > >
        convert_in(Function self, std::vector< casadi::MX,std::allocator< casadi::MX > > const & arg) -> casadi::MXDict
        convert_in(Function self, casadi::MXDict const & arg) -> std::vector< casadi::MX,std::allocator< casadi::MX > >


        Convert from/to input/output lists/map.

        Will raise an error when an unknown key is used or a list has incorrect
        size. Does not perform sparsity checking.


        """
        return _casadi.Function_convert_in(self, *args)

    def convert_out(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""
        convert_out(Function self, std::vector< casadi::DM,std::allocator< casadi::DM > > const & arg) -> casadi::DMDict
        convert_out(Function self, casadi::DMDict const & arg) -> std::vector< casadi::DM,std::allocator< casadi::DM > >
        convert_out(Function self, std::vector< casadi::SX,std::allocator< casadi::SX > > const & arg) -> casadi::SXDict
        convert_out(Function self, casadi::SXDict const & arg) -> std::vector< casadi::SX,std::allocator< casadi::SX > >
        convert_out(Function self, std::vector< casadi::MX,std::allocator< casadi::MX > > const & arg) -> casadi::MXDict
        convert_out(Function self, casadi::MXDict const & arg) -> std::vector< casadi::MX,std::allocator< casadi::MX > >


        Convert from/to input/output lists/map.

        Will raise an error when an unknown key is used or a list has incorrect
        size. Does not perform sparsity checking.


        """
        return _casadi.Function_convert_out(self, *args)

    def has_free(self, *args) -> "bool":
        r"""
        has_free(Function self) -> bool


        Does the function have free variables.


        """
        return _casadi.Function_has_free(self, *args)

    def get_free(self, *args) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        get_free(Function self) -> std::vector< std::string,std::allocator< std::string > >


        Get free variables as a string.


        """
        return _casadi.Function_get_free(self, *args)

    def free_sx(self, *args) -> "std::vector< casadi::SX,std::allocator< casadi::SX > >":
        r"""
        free_sx(Function self) -> std::vector< casadi::SX,std::allocator< casadi::SX > >


        Get all the free variables of the function.


        """
        return _casadi.Function_free_sx(self, *args)

    def free_mx(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""
        free_mx(Function self) -> std::vector< casadi::MX,std::allocator< casadi::MX > >


        Get all the free variables of the function.


        """
        return _casadi.Function_free_mx(self, *args)

    def generate_lifted(self, *args) -> "void":
        r"""
        generate_lifted(Function self)


        Extract the functions needed for the Lifted Newton method.


        """
        return _casadi.Function_generate_lifted(self, *args)

    def n_nodes(self, *args) -> "casadi_int":
        r"""
        n_nodes(Function self) -> casadi_int


        Number of nodes in the algorithm.


        """
        return _casadi.Function_n_nodes(self, *args)

    def n_instructions(self, *args) -> "casadi_int":
        r"""
        n_instructions(Function self) -> casadi_int


        Number of instruction in the algorithm (SXFunction/MXFunction)


        """
        return _casadi.Function_n_instructions(self, *args)

    def instruction_id(self, *args) -> "casadi_int":
        r"""
        instruction_id(Function self, casadi_int k) -> casadi_int


        Identifier index of the instruction (SXFunction/MXFunction)


        """
        return _casadi.Function_instruction_id(self, *args)

    def instruction_input(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""
        instruction_input(Function self, casadi_int k) -> std::vector< casadi_int,std::allocator< casadi_int > >


        Locations in the work vector for the inputs of the instruction
        (SXFunction/MXFunction)


        """
        return _casadi.Function_instruction_input(self, *args)

    def instruction_constant(self, *args) -> "double":
        r"""
        instruction_constant(Function self, casadi_int k) -> double


        Get the floating point output argument of an instruction ( SXFunction)


        """
        return _casadi.Function_instruction_constant(self, *args)

    def instruction_output(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""
        instruction_output(Function self, casadi_int k) -> std::vector< casadi_int,std::allocator< casadi_int > >


        Location in the work vector for the output of the instruction
        (SXFunction/MXFunction)


        """
        return _casadi.Function_instruction_output(self, *args)

    def instruction_MX(self, *args) -> "casadi::MX":
        r"""
        instruction_MX(Function self, casadi_int k) -> MX


        Get the MX node corresponding to an instruction ( MXFunction)


        """
        return _casadi.Function_instruction_MX(self, *args)

    def instructions_sx(self, *args) -> "casadi::SX":
        r"""
        instructions_sx(Function self) -> SX


        Get the SX node corresponding to all instructions ( SXFunction)

        Note: input and output instructions have no SX representation. This method
        returns nan for those instructions.


        """
        return _casadi.Function_instructions_sx(self, *args)

    def has_spfwd(self, *args) -> "bool":
        r"""
        has_spfwd(Function self) -> bool


        Is the class able to propagate seeds through the algorithm?


        """
        return _casadi.Function_has_spfwd(self, *args)

    def has_sprev(self, *args) -> "bool":
        r"""
        has_sprev(Function self) -> bool


        Is the class able to propagate seeds through the algorithm?


        """
        return _casadi.Function_has_sprev(self, *args)

    def sz_arg(self, *args) -> "size_t":
        r"""
        sz_arg(Function self) -> size_t


        Get required length of arg field.


        """
        return _casadi.Function_sz_arg(self, *args)

    def sz_res(self, *args) -> "size_t":
        r"""
        sz_res(Function self) -> size_t


        Get required length of res field.


        """
        return _casadi.Function_sz_res(self, *args)

    def sz_iw(self, *args) -> "size_t":
        r"""
        sz_iw(Function self) -> size_t


        Get required length of iw field.


        """
        return _casadi.Function_sz_iw(self, *args)

    def sz_w(self, *args) -> "size_t":
        r"""
        sz_w(Function self) -> size_t


        Get required length of w field.


        """
        return _casadi.Function_sz_w(self, *args)

    def name(self, *args) -> "std::string":
        r"""
        name(Function self) -> std::string


        Name of the function.


        """
        return _casadi.Function_name(self, *args)

    def is_a(self, *args) -> "bool":
        r"""
        is_a(Function self, std::string const & type, bool recursive=True) -> bool


        Check if the function is of a particular type Optionally check if name
        matches one of the base classes (default true)


        """
        return _casadi.Function_is_a(self, *args)

    @staticmethod
    def check_name(*args) -> "bool":
        r"""check_name(std::string const & name) -> bool"""
        return _casadi.Function_check_name(*args)

    @staticmethod
    def fix_name(*args) -> "std::string":
        r"""fix_name(std::string const & name) -> std::string"""
        return _casadi.Function_fix_name(*args)

    @staticmethod
    def load(*args) -> "casadi::Function":
        r"""load(std::string const & filename) -> Function"""
        return _casadi.Function_load(*args)

    @staticmethod
    def deserialize(*args) -> "casadi::Function":
        r"""
        deserialize(std::istream & stream) -> Function
        deserialize(std::string const & s) -> Function
        deserialize(casadi::DeserializingStream & s) -> Function
        """
        return _casadi.Function_deserialize(*args)

    def assert_size_in(self, *args) -> "void":
        r"""
        assert_size_in(Function self, casadi_int i, casadi_int nrow, casadi_int ncol)


        Assert that an input dimension is equal so some given value.


        """
        return _casadi.Function_assert_size_in(self, *args)

    def assert_size_out(self, *args) -> "void":
        r"""
        assert_size_out(Function self, casadi_int i, casadi_int nrow, casadi_int ncol)


        Assert that an output dimension is equal so some given value.


        """
        return _casadi.Function_assert_size_out(self, *args)

    def checkout(self, *args) -> "casadi_int":
        r"""
        checkout(Function self) -> casadi_int


        Checkout a memory object.


        """
        return _casadi.Function_checkout(self, *args)

    def release(self, *args) -> "void":
        r"""
        release(Function self, int mem)


        Release a memory object.


        """
        return _casadi.Function_release(self, *args)

    def get_function(self, *args) -> "casadi::Function":
        r"""
        get_function(Function self) -> std::vector< std::string,std::allocator< std::string > >
        get_function(Function self, std::string const & name) -> Function
        """
        return _casadi.Function_get_function(self, *args)

    def has_function(self, *args) -> "bool":
        r"""has_function(Function self, std::string const & fname) -> bool"""
        return _casadi.Function_has_function(self, *args)

    def info(self, *args) -> "casadi::Dict":
        r"""
        info(Function self) -> casadi::Dict


        Obtain information about function


        """
        return _casadi.Function_info(self, *args)

    def __setstate__(self, state):
        self.__init__(Function.deserialize(state["serialization"]))

    def __getstate__(self):
        return {"serialization": self.serialize()}


    def __call__(self, *args, **kwargs):
    # Either named inputs or ordered inputs
      if len(args)>0 and len(kwargs)>0:
        raise SyntaxError('Function evaluation requires all arguments to be named or none')
      if len(args)>0:
    # Ordered inputs -> return tuple
        ret = self.call(args)
        if len(ret)==0:
          return None
        elif len(ret)==1:
          return ret[0]
        else:
          return tuple(ret)
      else:
    # Named inputs -> return dictionary
        return self.call(kwargs)

    def buffer(self):
      """
      Create a FunctionBuffer object for evaluating with minimal overhead

      """
      import functools
      fb = FunctionBuffer(self)
      caller = functools.partial(_casadi._function_buffer_eval, fb._self())
      return (fb, caller)


    def __init__(self, *args):
        r"""
        __init__(Function self) -> Function
        __init__(Function self, std::string const & fname) -> Function
        __init__(Function self, std::string const & name, std::vector< casadi::SX,std::allocator< casadi::SX > > const & ex_in, std::vector< casadi::SX,std::allocator< casadi::SX > > const & ex_out, casadi::Dict const & opts=casadi::Dict()) -> Function
        __init__(Function self, std::string const & name, std::vector< casadi::SX,std::allocator< casadi::SX > > const & ex_in, std::vector< casadi::SX,std::allocator< casadi::SX > > const & ex_out, std::vector< std::string,std::allocator< std::string > > const & name_in, std::vector< std::string,std::allocator< std::string > > const & name_out, casadi::Dict const & opts=casadi::Dict()) -> Function
        __init__(Function self, std::string const & name, std::map< std::string,casadi::SX,std::less< std::string >,std::allocator< std::pair< std::string const,casadi::SX > > > const & dict, std::vector< std::string,std::allocator< std::string > > const & name_in, std::vector< std::string,std::allocator< std::string > > const & name_out, casadi::Dict const & opts=casadi::Dict()) -> Function
        __init__(Function self, std::string const & name, std::vector< casadi::MX,std::allocator< casadi::MX > > const & ex_in, std::vector< casadi::MX,std::allocator< casadi::MX > > const & ex_out, casadi::Dict const & opts=casadi::Dict()) -> Function
        __init__(Function self, std::string const & name, std::vector< casadi::MX,std::allocator< casadi::MX > > const & ex_in, std::vector< casadi::MX,std::allocator< casadi::MX > > const & ex_out, std::vector< std::string,std::allocator< std::string > > const & name_in, std::vector< std::string,std::allocator< std::string > > const & name_out, casadi::Dict const & opts=casadi::Dict()) -> Function
        __init__(Function self, std::string const & name, std::map< std::string,casadi::MX,std::less< std::string >,std::allocator< std::pair< std::string const,casadi::MX > > > const & dict, std::vector< std::string,std::allocator< std::string > > const & name_in, std::vector< std::string,std::allocator< std::string > > const & name_out, casadi::Dict const & opts=casadi::Dict()) -> Function
        __init__(Function self, Function other) -> Function
        """
        _casadi.Function_swiginit(self, _casadi.new_Function(*args))

# Register Function in _casadi:
_casadi.Function_swigregister(Function)

def Function_type_name(*args) -> "std::string":
    r"""Function_type_name() -> std::string"""
    return _casadi.Function_type_name(*args)

def Function_jit(*args) -> "casadi::Function":
    r"""
    Function_jit(std::string const & name, std::string const & body, std::vector< std::string,std::allocator< std::string > > const & name_in, std::vector< std::string,std::allocator< std::string > > const & name_out, casadi::Dict const & opts=casadi::Dict()) -> Function
    Function_jit(std::string const & name, std::string const & body, std::vector< std::string,std::allocator< std::string > > const & name_in, std::vector< std::string,std::allocator< std::string > > const & name_out, std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > > const & sparsity_in, std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > > const & sparsity_out, casadi::Dict const & opts=casadi::Dict()) -> Function


    To resolve ambiguity on some compilers.

    Create a just-in-time compiled function from a C language string The names
    and sparsity patterns of all the inputs and outputs must be provided. If
    sparsities are not provided, all inputs and outputs are assumed to be
    scalar. Only specify the function body, assuming that input and output
    nonzeros are stored in arrays with the specified naming convension. The data
    type used is 'casadi_real', which is typically equal to 'double` or another
    data type with the same API as 'double'.

    Inputs may be null pointers. This means that the all entries are zero.
    Outputs may be null points. This means that the corresponding result can be
    ignored.

    If an error occurs in the evaluation, issue "return 1;";

    The final generated function will have a structure similar to:

    casadi_int fname(const casadi_real** arg, casadi_real** res, casadi_int* iw,
    casadi_real* w, void* mem) { const casadi_real *x1, *x2; casadi_real *r1,
    *r2; x1 = *arg++; x2 = *arg++; r1 = *res++; r2 = *res++; <FUNCTION_BODY>
    return 0; }


    """
    return _casadi.Function_jit(*args)

def Function_conditional(*args) -> "casadi::Function":
    r"""Function_conditional(std::string const & name, std::vector< casadi::Function,std::allocator< casadi::Function > > const & f, Function f_def, casadi::Dict const & opts=casadi::Dict()) -> Function"""
    return _casadi.Function_conditional(*args)

def Function_bspline(*args) -> "casadi::Function":
    r"""Function_bspline(std::string const & name, std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const & knots, std::vector< double,std::allocator< double > > const & coeffs, std::vector< casadi_int,std::allocator< casadi_int > > const & degree, casadi_int m=1, casadi::Dict const & opts=casadi::Dict()) -> Function"""
    return _casadi.Function_bspline(*args)

def Function_if_else(*args) -> "casadi::Function":
    r"""Function_if_else(std::string const & name, Function f_true, Function f_false, casadi::Dict const & opts=casadi::Dict()) -> Function"""
    return _casadi.Function_if_else(*args)

def Function_check_name(*args) -> "bool":
    r"""Function_check_name(std::string const & name) -> bool"""
    return _casadi.Function_check_name(*args)

def Function_fix_name(*args) -> "std::string":
    r"""Function_fix_name(std::string const & name) -> std::string"""
    return _casadi.Function_fix_name(*args)

def Function_load(*args) -> "casadi::Function":
    r"""Function_load(std::string const & filename) -> Function"""
    return _casadi.Function_load(*args)

def Function_deserialize(*args) -> "casadi::Function":
    r"""
    Function_deserialize(std::istream & stream) -> Function
    Function_deserialize(std::string const & s) -> Function
    Function_deserialize(casadi::DeserializingStream & s) -> Function
    """
    return _casadi.Function_deserialize(*args)

class FunctionBuffer(object):
    r"""


    Class to achieve minimal overhead function evaluations.

    C++ includes: function.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def set_arg(self, *args) -> "void":
        r"""
        set_arg(FunctionBuffer self, casadi_int i, double const * a)


        Set input buffer for input i.

        mem.set_arg(0, memoryview(a))

        Note that CasADi uses 'fortran' order: column-by-column


        """
        return _casadi.FunctionBuffer_set_arg(self, *args)

    def set_res(self, *args) -> "void":
        r"""
        set_res(FunctionBuffer self, casadi_int i, double * a)


        Set output buffer for ouput i.

        mem.set_res(0, memoryview(a))

        Note that CasADi uses 'fortran' order: column-by-column


        """
        return _casadi.FunctionBuffer_set_res(self, *args)

    def ret(self, *args) -> "int":
        r"""
        ret(FunctionBuffer self) -> int


        Get last return value.


        """
        return _casadi.FunctionBuffer_ret(self, *args)

    def _eval(self, *args) -> "void":
        r"""_eval(FunctionBuffer self)"""
        return _casadi.FunctionBuffer__eval(self, *args)

    def _self(self, *args) -> "void *":
        r"""_self(FunctionBuffer self) -> void *"""
        return _casadi.FunctionBuffer__self(self, *args)

    def __init__(self, *args):
        r"""
        __init__(FunctionBuffer self, Function f) -> FunctionBuffer
        __init__(FunctionBuffer self, FunctionBuffer other) -> FunctionBuffer
        """
        _casadi.FunctionBuffer_swiginit(self, _casadi.new_FunctionBuffer(*args))
    __swig_destroy__ = _casadi.delete_FunctionBuffer

# Register FunctionBuffer in _casadi:
_casadi.FunctionBuffer_swigregister(FunctionBuffer)


def _function_buffer_eval(*args) -> "void":
    r"""_function_buffer_eval(void * raw)"""
    return _casadi._function_buffer_eval(*args)

def external(*args) -> "casadi::Function":
    r"""
    external(std::string const & name, casadi::Dict const & opts=casadi::Dict()) -> Function
    external(std::string const & name, std::string const & bin_name, casadi::Dict const & opts=casadi::Dict()) -> Function
    external(std::string const & name, Importer li, casadi::Dict const & opts=casadi::Dict()) -> Function


    Load a just-in-time compiled external function File name given.


    """
    return _casadi.external(*args)

def integrator(*args) -> "casadi::Function":
    r"""
    integrator(std::string const & name, std::string const & solver, casadi::SXDict const & dae, casadi::Dict const & opts=casadi::Dict()) -> Function
    integrator(std::string const & name, std::string const & solver, casadi::MXDict const & dae, casadi::Dict const & opts=casadi::Dict()) -> Function
    """
    return _casadi.integrator(*args)

def has_integrator(*args) -> "bool":
    r"""
    has_integrator(std::string const & name) -> bool


    Check if a particular plugin is available.


    """
    return _casadi.has_integrator(*args)

def load_integrator(*args) -> "void":
    r"""
    load_integrator(std::string const & name)


    Explicitly load a plugin dynamically.


    """
    return _casadi.load_integrator(*args)

def doc_integrator(*args) -> "std::string":
    r"""
    doc_integrator(std::string const & name) -> std::string


    Get the documentation string for a plugin.


    """
    return _casadi.doc_integrator(*args)

def integrator_in(*args) -> "std::string":
    r"""
    integrator_in() -> std::vector< std::string,std::allocator< std::string > >
    integrator_in(casadi_int ind) -> std::string


    Get integrator input scheme name by index.


    """
    return _casadi.integrator_in(*args)

def integrator_out(*args) -> "std::string":
    r"""
    integrator_out() -> std::vector< std::string,std::allocator< std::string > >
    integrator_out(casadi_int ind) -> std::string


    Get output scheme name by index.


    """
    return _casadi.integrator_out(*args)

def integrator_n_in(*args) -> "casadi_int":
    r"""
    integrator_n_in() -> casadi_int


    Get the number of integrator inputs.


    """
    return _casadi.integrator_n_in(*args)

def integrator_n_out(*args) -> "casadi_int":
    r"""
    integrator_n_out() -> casadi_int


    Get the number of integrator outputs.


    """
    return _casadi.integrator_n_out(*args)

def conic(*args) -> "casadi::Function":
    r"""
    conic(std::string const & name, std::string const & solver, casadi::SpDict const & qp, casadi::Dict const & opts=casadi::Dict()) -> Function


    Create a QP solver Solves the following strictly convex problem:



    ::

      min          1/2 x' H x + g' x
      x

      subject to
      LBA <= A x <= UBA
      LBX <= x   <= UBX

      resize(Q x, np, np) + P >= 0 (psd)

      with :
      H sparse (n x n) positive definite
      g dense  (n x 1)
      A sparse (nc x n)
      Q sparse symmetric (np^2 x n)
      P sparse symmetric (np x nq)

      n: number of decision variables (x)
      nc: number of constraints (A)
      nq: shape of psd constraint matrix



    If H is not positive-definite, the solver should throw an error.

    Second-order cone constraints can be added as psd constraints through a
    helper function 'soc':

    x in R^n y in R

    || x ||_2 <= y

    <=>

    soc(x, y) psd

    This can be proven with soc(x, y)=[y*I x; x' y] using the Shur complement.

    General information
    ===================



    >List of available options

    +------------------+-----------------+------------------+------------------+
    |        Id        |      Type       |   Description    |     Used in      |
    +==================+=================+==================+==================+
    | ad_weight        | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for derivative   | Internal         |
    |                  |                 | calculation.When |                  |
    |                  |                 | there is an      |                  |
    |                  |                 | option of either |                  |
    |                  |                 | using forward or |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | directional      |                  |
    |                  |                 | derivatives, the |                  |
    |                  |                 | condition ad_wei |                  |
    |                  |                 | ght*nf<=(1-ad_we |                  |
    |                  |                 | ight)*na is used |                  |
    |                  |                 | where nf and na  |                  |
    |                  |                 | are estimates of |                  |
    |                  |                 | the number of    |                  |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | mode directional |                  |
    |                  |                 | derivatives      |                  |
    |                  |                 | needed. By       |                  |
    |                  |                 | default,         |                  |
    |                  |                 | ad_weight is     |                  |
    |                  |                 | calculated       |                  |
    |                  |                 | automatically,   |                  |
    |                  |                 | but this can be  |                  |
    |                  |                 | overridden by    |                  |
    |                  |                 | setting this     |                  |
    |                  |                 | option. In       |                  |
    |                  |                 | particular, 0    |                  |
    |                  |                 | means forcing    |                  |
    |                  |                 | forward mode and |                  |
    |                  |                 | 1 forcing        |                  |
    |                  |                 | reverse mode.    |                  |
    |                  |                 | Leave unset for  |                  |
    |                  |                 | (class specific) |                  |
    |                  |                 | heuristics.      |                  |
    +------------------+-----------------+------------------+------------------+
    | ad_weight_sp     | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for sparsity     | Internal         |
    |                  |                 | pattern          |                  |
    |                  |                 | calculation calc |                  |
    |                  |                 | ulation.Override |                  |
    |                  |                 | s default        |                  |
    |                  |                 | behavior. Set to |                  |
    |                  |                 | 0 and 1 to force |                  |
    |                  |                 | forward and      |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | respectively.    |                  |
    |                  |                 | Cf. option       |                  |
    |                  |                 | "ad_weight".     |                  |
    |                  |                 | When set to -1,  |                  |
    |                  |                 | sparsity is      |                  |
    |                  |                 | completely       |                  |
    |                  |                 | ignored and      |                  |
    |                  |                 | dense matrices   |                  |
    |                  |                 | are used.        |                  |
    +------------------+-----------------+------------------+------------------+
    | always_inline    | OT_BOOL         | Force inlining.  | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | compiler         | OT_STRING       | Just-in-time     | casadi::Function |
    |                  |                 | compiler plugin  | Internal         |
    |                  |                 | to be used.      |                  |
    +------------------+-----------------+------------------+------------------+
    | custom_jacobian  | OT_FUNCTION     | Override         | casadi::Function |
    |                  |                 | CasADi's AD. Use | Internal         |
    |                  |                 | together with    |                  |
    |                  |                 | 'jac_penalty':   |                  |
    |                  |                 | 0. Note: Highly  |                  |
    |                  |                 | experimental.    |                  |
    |                  |                 | Syntax may break |                  |
    |                  |                 | often.           |                  |
    +------------------+-----------------+------------------+------------------+
    | derivative_of    | OT_FUNCTION     | The function is  | casadi::Function |
    |                  |                 | a derivative of  | Internal         |
    |                  |                 | another          |                  |
    |                  |                 | function. The    |                  |
    |                  |                 | type of          |                  |
    |                  |                 | derivative       |                  |
    |                  |                 | (directional     |                  |
    |                  |                 | derivative,      |                  |
    |                  |                 | Jacobian) is     |                  |
    |                  |                 | inferred from    |                  |
    |                  |                 | the function     |                  |
    |                  |                 | name.            |                  |
    +------------------+-----------------+------------------+------------------+
    | discrete         | OT_BOOLVECTOR   | Indicates which  | casadi::Conic    |
    |                  |                 | of the variables |                  |
    |                  |                 | are discrete,    |                  |
    |                  |                 | i.e. integer-    |                  |
    |                  |                 | valued           |                  |
    +------------------+-----------------+------------------+------------------+
    | dump             | OT_BOOL         | Dump function to | casadi::Function |
    |                  |                 | file upon first  | Internal         |
    |                  |                 | evaluation.      |                  |
    |                  |                 | [false]          |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_dir         | OT_STRING       | Directory to     | casadi::Function |
    |                  |                 | dump             | Internal         |
    |                  |                 | inputs/outputs   |                  |
    |                  |                 | to. Make sure    |                  |
    |                  |                 | the directory    |                  |
    |                  |                 | exists [.]       |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_format      | OT_STRING       | Choose file      | casadi::Function |
    |                  |                 | format to dump   | Internal         |
    |                  |                 | matrices. See    |                  |
    |                  |                 | DM.from_file     |                  |
    |                  |                 | [mtx]            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_in          | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | to file          |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_out         | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs to file  |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_fd        | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation by   |                  |
    |                  |                 | finite           |                  |
    |                  |                 | differencing.    |                  |
    |                  |                 | [default:        |                  |
    |                  |                 | false]]          |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_forward   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using forward    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_jacobian  | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobians of all |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | outputs with     |                  |
    |                  |                 | respect to all   |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | inputs - if      |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_reverse   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | transposed       |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using reverse    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | error_on_fail    | OT_BOOL         | When the         | casadi::Conic    |
    |                  |                 | numerical        |                  |
    |                  |                 | process returns  |                  |
    |                  |                 | unsuccessfully,  |                  |
    |                  |                 | raise an error   |                  |
    |                  |                 | (default false). |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_method        | OT_STRING       | Method for       | casadi::Function |
    |                  |                 | finite           | Internal         |
    |                  |                 | differencing     |                  |
    |                  |                 | [default         |                  |
    |                  |                 | 'central']       |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_options       | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | finite           |                  |
    |                  |                 | difference       |                  |
    |                  |                 | instance         |                  |
    +------------------+-----------------+------------------+------------------+
    | forward_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | forward mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | gather_stats     | OT_BOOL         | Deprecated       | casadi::Function |
    |                  |                 | option           | Internal         |
    |                  |                 | (ignored):       |                  |
    |                  |                 | Statistics are   |                  |
    |                  |                 | now always       |                  |
    |                  |                 | collected.       |                  |
    +------------------+-----------------+------------------+------------------+
    | input_scheme     | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | inputs_check     | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when the         | Internal         |
    |                  |                 | numerical values |                  |
    |                  |                 | of the inputs    |                  |
    |                  |                 | don't make sense |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_in       | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each input if it | Internal         |
    |                  |                 | should be        |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_out      | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each output if   | Internal         |
    |                  |                 | it should be     |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | jac_penalty      | OT_DOUBLE       | When requested   | casadi::Function |
    |                  |                 | for a number of  | Internal         |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | directions, it   |                  |
    |                  |                 | may be cheaper   |                  |
    |                  |                 | to compute first |                  |
    |                  |                 | the full         |                  |
    |                  |                 | jacobian and     |                  |
    |                  |                 | then multiply    |                  |
    |                  |                 | with seeds,      |                  |
    |                  |                 | rather than      |                  |
    |                  |                 | obtain the       |                  |
    |                  |                 | requested        |                  |
    |                  |                 | directions in a  |                  |
    |                  |                 | straightforward  |                  |
    |                  |                 | manner. Casadi   |                  |
    |                  |                 | uses a heuristic |                  |
    |                  |                 | to decide which  |                  |
    |                  |                 | is cheaper. A    |                  |
    |                  |                 | high value of    |                  |
    |                  |                 | 'jac_penalty'    |                  |
    |                  |                 | makes it less    |                  |
    |                  |                 | likely for the   |                  |
    |                  |                 | heurstic to      |                  |
    |                  |                 | chose the full   |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy. The    |                  |
    |                  |                 | special value -1 |                  |
    |                  |                 | indicates never  |                  |
    |                  |                 | to use the full  |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy         |                  |
    +------------------+-----------------+------------------+------------------+
    | jit              | OT_BOOL         | Use just-in-time | casadi::Function |
    |                  |                 | compiler to      | Internal         |
    |                  |                 | speed up the     |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_cleanup      | OT_BOOL         | Cleanup up the   | casadi::Function |
    |                  |                 | temporary source | Internal         |
    |                  |                 | file that jit    |                  |
    |                  |                 | creates.         |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_name         | OT_STRING       | The file name    | casadi::Function |
    |                  |                 | used to write    | Internal         |
    |                  |                 | out code. The    |                  |
    |                  |                 | actual file      |                  |
    |                  |                 | names used       |                  |
    |                  |                 | depend on 'jit_t |                  |
    |                  |                 | emp_suffix' and  |                  |
    |                  |                 | include          |                  |
    |                  |                 | extensions.      |                  |
    |                  |                 | Default:         |                  |
    |                  |                 | 'jit_tmp'        |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_options      | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | jit compiler.    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_serialize    | OT_STRING       | Specify          | casadi::Function |
    |                  |                 | behaviour when   | Internal         |
    |                  |                 | serializing a    |                  |
    |                  |                 | jitted function: |                  |
    |                  |                 | SOURCE|link|embe |                  |
    |                  |                 | d.               |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_temp_suffix  | OT_BOOL         | Use a temporary  | casadi::Function |
    |                  |                 | (seemingly       | Internal         |
    |                  |                 | random) filename |                  |
    |                  |                 | suffix for       |                  |
    |                  |                 | generated code   |                  |
    |                  |                 | and libraries.   |                  |
    |                  |                 | This is desired  |                  |
    |                  |                 | for thread-      |                  |
    |                  |                 | safety. This     |                  |
    |                  |                 | behaviour may    |                  |
    |                  |                 | defeat caching   |                  |
    |                  |                 | compiler         |                  |
    |                  |                 | wrappers.        |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | max_num_dir      | OT_INT          | Specify the      | casadi::Function |
    |                  |                 | maximum number   | Internal         |
    |                  |                 | of directions    |                  |
    |                  |                 | for derivative   |                  |
    |                  |                 | functions.       |                  |
    |                  |                 | Overrules the    |                  |
    |                  |                 | builtin optimize |                  |
    |                  |                 | d_num_dir.       |                  |
    +------------------+-----------------+------------------+------------------+
    | never_inline     | OT_BOOL         | Forbid inlining. | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | output_scheme    | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | print_in         | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_out        | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs          |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_problem    | OT_BOOL         | Print a numeric  | casadi::Conic    |
    |                  |                 | description of   |                  |
    |                  |                 | the problem      |                  |
    +------------------+-----------------+------------------+------------------+
    | print_time       | OT_BOOL         | print            | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time. Implies    |                  |
    |                  |                 | record_time.     |                  |
    +------------------+-----------------+------------------+------------------+
    | record_time      | OT_BOOL         | record           | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time, for        |                  |
    |                  |                 | retrieval with   |                  |
    |                  |                 | stats().         |                  |
    +------------------+-----------------+------------------+------------------+
    | regularity_check | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when NaN or Inf  | Internal         |
    |                  |                 | appears during   |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | reverse_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | reverse mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | user_data        | OT_VOIDPTR      | A user-defined   | casadi::Function |
    |                  |                 | field that can   | Internal         |
    |                  |                 | be used to       |                  |
    |                  |                 | identify the     |                  |
    |                  |                 | function or pass |                  |
    |                  |                 | additional       |                  |
    |                  |                 | information      |                  |
    +------------------+-----------------+------------------+------------------+
    | verbose          | OT_BOOL         | Verbose          | casadi::Function |
    |                  |                 | evaluation  for  | Internal         |
    |                  |                 | debugging        |                  |
    +------------------+-----------------+------------------+------------------+

    >Input scheme: casadi::ConicInput (CONIC_NUM_IN = 12)

    +--------------+--------+--------------------------------------------------+
    |  Full name   | Short  |                   Description                    |
    +==============+========+==================================================+
    | CONIC_H      | h      | The square matrix H: sparse, (n x n). Only the   |
    |              |        | lower triangular part is actually used. The      |
    |              |        | matrix is assumed to be symmetrical.             |
    +--------------+--------+--------------------------------------------------+
    | CONIC_G      | g      | The vector g: dense, (n x 1)                     |
    +--------------+--------+--------------------------------------------------+
    | CONIC_A      | a      | The matrix A: sparse, (nc x n) - product with x  |
    |              |        | must be dense.                                   |
    +--------------+--------+--------------------------------------------------+
    | CONIC_LBA    | lba    | dense, (nc x 1)                                  |
    +--------------+--------+--------------------------------------------------+
    | CONIC_UBA    | uba    | dense, (nc x 1)                                  |
    +--------------+--------+--------------------------------------------------+
    | CONIC_LBX    | lbx    | dense, (n x 1)                                   |
    +--------------+--------+--------------------------------------------------+
    | CONIC_UBX    | ubx    | dense, (n x 1)                                   |
    +--------------+--------+--------------------------------------------------+
    | CONIC_X0     | x0     | dense, (n x 1)                                   |
    +--------------+--------+--------------------------------------------------+
    | CONIC_LAM_X0 | lam_x0 | dense                                            |
    +--------------+--------+--------------------------------------------------+
    | CONIC_LAM_A0 | lam_a0 | dense                                            |
    +--------------+--------+--------------------------------------------------+
    | CONIC_Q      | q      | The matrix Q: sparse symmetric, (np^2 x n)       |
    +--------------+--------+--------------------------------------------------+
    | CONIC_P      | p      | The matrix P: sparse symmetric, (np x np)        |
    +--------------+--------+--------------------------------------------------+

    >Output scheme: casadi::ConicOutput (CONIC_NUM_OUT = 4)

    +-------------+-------+---------------------------------------------------+
    |  Full name  | Short |                    Description                    |
    +=============+=======+===================================================+
    | CONIC_X     | x     | The primal solution.                              |
    +-------------+-------+---------------------------------------------------+
    | CONIC_COST  | cost  | The optimal cost.                                 |
    +-------------+-------+---------------------------------------------------+
    | CONIC_LAM_A | lam_a | The dual solution corresponding to linear bounds. |
    +-------------+-------+---------------------------------------------------+
    | CONIC_LAM_X | lam_x | The dual solution corresponding to simple bounds. |
    +-------------+-------+---------------------------------------------------+

    List of plugins
    ===============



    - cbc

    - clp

    - cplex

    - gurobi

    - hpmpc

    - ooqp

    - osqp

    - qpoases

    - sqic

    - superscs

    - nlpsol

    - qrqp

    Note: some of the plugins in this list might not be available on your
    system. Also, there might be extra plugins available to you that are not
    listed here. You can obtain their documentation with
    Conic.doc("myextraplugin")



    --------------------------------------------------------------------------------

    cbc
    ---



    Interface to Cbc solver for sparse Quadratic Programs

    >List of available options

    +-------------+-----------------------+------------------------------------+
    |     Id      |         Type          |            Description             |
    +=============+=======================+====================================+
    | cbc         | OT_DICT               | Options to be passed to CBC.Three  |
    |             |                       | sets of options are supported. The |
    |             |                       | first can be found in              |
    |             |                       | OsiSolverParameters.hpp. The       |
    |             |                       | second can be found in             |
    |             |                       | CbcModel.hpp. The third are        |
    |             |                       | options that can be passed to      |
    |             |                       | CbcMain1.                          |
    +-------------+-----------------------+------------------------------------+
    | hot_start   | OT_BOOL               | Hot start with x0 [Default false]. |
    +-------------+-----------------------+------------------------------------+
    | sos_groups  | OT_INTVECTORVECTOR    | Definition of SOS groups by        |
    |             |                       | indices.                           |
    +-------------+-----------------------+------------------------------------+
    | sos_types   | OT_INTVECTOR          | Specify 1 or 2 for each SOS group. |
    +-------------+-----------------------+------------------------------------+
    | sos_weights | OT_DOUBLEVECTORVECTOR | Weights corresponding to SOS       |
    |             |                       | entries.                           |
    +-------------+-----------------------+------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    clp
    ---



    Interface to Clp solver for sparse Quadratic Programs

    >List of available options

    +-----+---------+----------------------------------------------------------+
    | Id  |  Type   |                       Description                        |
    +=====+=========+==========================================================+
    | clp | OT_DICT | Options to be passed to CLP. A first set of options can  |
    |     |         | be found in ClpParameters.hpp. eg. 'PrimalTolerance'.    |
    |     |         | There are other options in additions. 'AutomaticScaling' |
    |     |         | (bool) is recognised. 'initial_solve' (default off)      |
    |     |         | activates the use of Clp's initialSolve.                 |
    |     |         | 'initial_solve_options' takes a dictionary with          |
    |     |         | following keys (see ClpSolve.hpp): SolveType (string),   |
    |     |         | PresolveType (string), NumberPasses, SpecialOptions      |
    |     |         | (intvectorvector), IndependentOptions (intvectorvector). |
    +-----+---------+----------------------------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    cplex
    -----



    Interface to Cplex solver for sparse Quadratic Programs

    >List of available options

    +---------------+-----------------------+----------------------------------+
    |      Id       |         Type          |           Description            |
    +===============+=======================+==================================+
    | cplex         | OT_DICT               | Options to be passed to CPLEX    |
    +---------------+-----------------------+----------------------------------+
    | dep_check     | OT_INT                | Detect redundant constraints.    |
    +---------------+-----------------------+----------------------------------+
    | dump_filename | OT_STRING             | The filename to dump to.         |
    +---------------+-----------------------+----------------------------------+
    | dump_to_file  | OT_BOOL               | Dumps QP to file in CPLEX        |
    |               |                       | format.                          |
    +---------------+-----------------------+----------------------------------+
    | mip_start     | OT_BOOL               | Hot start integers with x0       |
    |               |                       | [Default false].                 |
    +---------------+-----------------------+----------------------------------+
    | qp_method     | OT_INT                | Determines which CPLEX algorithm |
    |               |                       | to use.                          |
    +---------------+-----------------------+----------------------------------+
    | sos_groups    | OT_INTVECTORVECTOR    | Definition of SOS groups by      |
    |               |                       | indices.                         |
    +---------------+-----------------------+----------------------------------+
    | sos_types     | OT_INTVECTOR          | Specify 1 or 2 for each SOS      |
    |               |                       | group.                           |
    +---------------+-----------------------+----------------------------------+
    | sos_weights   | OT_DOUBLEVECTORVECTOR | Weights corresponding to SOS     |
    |               |                       | entries.                         |
    +---------------+-----------------------+----------------------------------+
    | tol           | OT_DOUBLE             | Tolerance of solver              |
    +---------------+-----------------------+----------------------------------+
    | warm_start    | OT_BOOL               | Use warm start with simplex      |
    |               |                       | methods (affects only the        |
    |               |                       | simplex methods).                |
    +---------------+-----------------------+----------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    gurobi
    ------



    Interface to the GUROBI Solver for quadratic programming

    >List of available options

    +-------------+-----------------------+------------------------------------+
    |     Id      |         Type          |            Description             |
    +=============+=======================+====================================+
    | gurobi      | OT_DICT               | Options to be passed to gurobi.    |
    +-------------+-----------------------+------------------------------------+
    | sos_groups  | OT_INTVECTORVECTOR    | Definition of SOS groups by        |
    |             |                       | indices.                           |
    +-------------+-----------------------+------------------------------------+
    | sos_types   | OT_INTVECTOR          | Specify 1 or 2 for each SOS group. |
    +-------------+-----------------------+------------------------------------+
    | sos_weights | OT_DOUBLEVECTORVECTOR | Weights corresponding to SOS       |
    |             |                       | entries.                           |
    +-------------+-----------------------+------------------------------------+
    | vtype       | OT_STRINGVECTOR       | Type of variables: [CONTINUOUS|bin |
    |             |                       | ary|integer|semicont|semiint]      |
    +-------------+-----------------------+------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    hpmpc
    -----



    Interface to HMPC Solver

    In order to use this interface, you must:

    Decision variables must only by state and control, and the variable ordering
    must be [x0 u0 x1 u1 ...]

    The constraints must be in order: [ gap0 lincon0 gap1 lincon1 ]

    gap: Ak+1 = Ak xk + Bk uk lincon: yk= Ck xk + Dk uk



    ::

             A0 B0 -I
             C0 D0
                    A1 B1 -I
                    C1 D1



    where I must be a diagonal sparse matrix Either supply all of N, nx, ng, nu
    options or rely on automatic detection

    >List of available options

    +----------------+--------------+------------------------------------------+
    |       Id       |     Type     |               Description                |
    +================+==============+==========================================+
    | N              | OT_INT       | OCP horizon                              |
    +----------------+--------------+------------------------------------------+
    | blasfeo_target | OT_STRING    | hpmpc target                             |
    +----------------+--------------+------------------------------------------+
    | inf            | OT_DOUBLE    | HPMPC cannot handle infinities.          |
    |                |              | Infinities will be replaced by this      |
    |                |              | option's value.                          |
    +----------------+--------------+------------------------------------------+
    | max_iter       | OT_INT       | Max number of iterations                 |
    +----------------+--------------+------------------------------------------+
    | mu0            | OT_DOUBLE    | Max element in cost function as estimate |
    |                |              | of max multiplier                        |
    +----------------+--------------+------------------------------------------+
    | ng             | OT_INTVECTOR | Number of non-dynamic constraints,       |
    |                |              | length N+1                               |
    +----------------+--------------+------------------------------------------+
    | nu             | OT_INTVECTOR | Number of controls, length N             |
    +----------------+--------------+------------------------------------------+
    | nx             | OT_INTVECTOR | Number of states, length N+1             |
    +----------------+--------------+------------------------------------------+
    | print_level    | OT_INT       | Amount of diagnostic printing [Default:  |
    |                |              | 1].                                      |
    +----------------+--------------+------------------------------------------+
    | target         | OT_STRING    | hpmpc target                             |
    +----------------+--------------+------------------------------------------+
    | tol            | OT_DOUBLE    | Tolerance in the duality measure         |
    +----------------+--------------+------------------------------------------+
    | warm_start     | OT_BOOL      | Use warm-starting                        |
    +----------------+--------------+------------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    ooqp
    ----



    Interface to the OOQP Solver for quadratic programming The current
    implementation assumes that OOQP is configured with the MA27 sparse linear
    solver.

    NOTE: when doing multiple calls to evaluate(), check if you need to
    reInit();

    >List of available options

    +-------------+-----------+------------------------------------------------+
    |     Id      |   Type    |                  Description                   |
    +=============+===========+================================================+
    | artol       | OT_DOUBLE | tolerance as provided with setArTol to OOQP    |
    +-------------+-----------+------------------------------------------------+
    | mutol       | OT_DOUBLE | tolerance as provided with setMuTol to OOQP    |
    +-------------+-----------+------------------------------------------------+
    | print_level | OT_INT    | Print level. OOQP listens to print_level 0, 10 |
    |             |           | and 100                                        |
    +-------------+-----------+------------------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    osqp
    ----



    Interface to the OSQP Solver for quadratic programming

    >List of available options

    +-------------------+---------+--------------------------------------------+
    |        Id         |  Type   |                Description                 |
    +===================+=========+============================================+
    | osqp              | OT_DICT | const Options to be passed to osqp.        |
    +-------------------+---------+--------------------------------------------+
    | warm_start_dual   | OT_BOOL | Use lam_a0 and lam_x0 input to warmstart   |
    |                   |         | [Default: truw].                           |
    +-------------------+---------+--------------------------------------------+
    | warm_start_primal | OT_BOOL | Use x0 input to warmstart [Default: true]. |
    +-------------------+---------+--------------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    qpoases
    -------



    Interface to QPOases Solver for quadratic programming

    >List of available options

    +-------------------------------+-----------+------------------------------+
    |              Id               |   Type    |         Description          |
    +===============================+===========+==============================+
    | CPUtime                       | OT_DOUBLE | The maximum allowed CPU time |
    |                               |           | in seconds for the whole     |
    |                               |           | initialisation (and the      |
    |                               |           | actually required one on     |
    |                               |           | output). Disabled if unset.  |
    +-------------------------------+-----------+------------------------------+
    | boundRelaxation               | OT_DOUBLE | Initial relaxation of bounds |
    |                               |           | to start homotopy and        |
    |                               |           | initial value for far        |
    |                               |           | bounds.                      |
    +-------------------------------+-----------+------------------------------+
    | boundTolerance                | OT_DOUBLE | If upper and lower bounds    |
    |                               |           | differ less than this        |
    |                               |           | tolerance, they are regarded |
    |                               |           | equal, i.e. as equality      |
    |                               |           | constraint.                  |
    +-------------------------------+-----------+------------------------------+
    | enableCholeskyRefactorisation | OT_INT    | Specifies the frequency of a |
    |                               |           | full re-factorisation of     |
    |                               |           | projected Hessian matrix: 0: |
    |                               |           | turns them off, 1: uses them |
    |                               |           | at each iteration etc.       |
    +-------------------------------+-----------+------------------------------+
    | enableDriftCorrection         | OT_INT    | Specifies the frequency of   |
    |                               |           | drift corrections: 0: turns  |
    |                               |           | them off.                    |
    +-------------------------------+-----------+------------------------------+
    | enableEqualities              | OT_BOOL   | Specifies whether equalities |
    |                               |           | should be treated as always  |
    |                               |           | active (True) or not (False) |
    +-------------------------------+-----------+------------------------------+
    | enableFarBounds               | OT_BOOL   | Enables the use of far       |
    |                               |           | bounds.                      |
    +-------------------------------+-----------+------------------------------+
    | enableFlippingBounds          | OT_BOOL   | Enables the use of flipping  |
    |                               |           | bounds.                      |
    +-------------------------------+-----------+------------------------------+
    | enableFullLITests             | OT_BOOL   | Enables condition-hardened   |
    |                               |           | (but more expensive) LI      |
    |                               |           | test.                        |
    +-------------------------------+-----------+------------------------------+
    | enableInertiaCorrection       | OT_BOOL   | Should working set be        |
    |                               |           | repaired when negative       |
    |                               |           | curvature is discovered      |
    |                               |           | during hotstart.             |
    +-------------------------------+-----------+------------------------------+
    | enableNZCTests                | OT_BOOL   | Enables nonzero curvature    |
    |                               |           | tests.                       |
    +-------------------------------+-----------+------------------------------+
    | enableRamping                 | OT_BOOL   | Enables ramping.             |
    +-------------------------------+-----------+------------------------------+
    | enableRegularisation          | OT_BOOL   | Enables automatic Hessian    |
    |                               |           | regularisation.              |
    +-------------------------------+-----------+------------------------------+
    | epsDen                        | OT_DOUBLE | Denominator tolerance for    |
    |                               |           | ratio tests.                 |
    +-------------------------------+-----------+------------------------------+
    | epsFlipping                   | OT_DOUBLE | Tolerance of squared         |
    |                               |           | Cholesky diagonal factor     |
    |                               |           | which triggers flipping      |
    |                               |           | bound.                       |
    +-------------------------------+-----------+------------------------------+
    | epsIterRef                    | OT_DOUBLE | Early termination tolerance  |
    |                               |           | for iterative refinement.    |
    +-------------------------------+-----------+------------------------------+
    | epsLITests                    | OT_DOUBLE | Tolerance for linear         |
    |                               |           | independence tests.          |
    +-------------------------------+-----------+------------------------------+
    | epsNZCTests                   | OT_DOUBLE | Tolerance for nonzero        |
    |                               |           | curvature tests.             |
    +-------------------------------+-----------+------------------------------+
    | epsNum                        | OT_DOUBLE | Numerator tolerance for      |
    |                               |           | ratio tests.                 |
    +-------------------------------+-----------+------------------------------+
    | epsRegularisation             | OT_DOUBLE | Scaling factor of identity   |
    |                               |           | matrix used for Hessian      |
    |                               |           | regularisation.              |
    +-------------------------------+-----------+------------------------------+
    | finalRamping                  | OT_DOUBLE | Final value for ramping      |
    |                               |           | strategy.                    |
    +-------------------------------+-----------+------------------------------+
    | growFarBounds                 | OT_DOUBLE | Factor to grow far bounds.   |
    +-------------------------------+-----------+------------------------------+
    | hessian_type                  | OT_STRING | Type of Hessian - see        |
    |                               |           | qpOASES documentation [UNKNO |
    |                               |           | WN|posdef|semidef|indef|zero |
    |                               |           | |identity]]                  |
    +-------------------------------+-----------+------------------------------+
    | initialFarBounds              | OT_DOUBLE | Initial size for far bounds. |
    +-------------------------------+-----------+------------------------------+
    | initialRamping                | OT_DOUBLE | Start value for ramping      |
    |                               |           | strategy.                    |
    +-------------------------------+-----------+------------------------------+
    | initialStatusBounds           | OT_STRING | Initial status of bounds at  |
    |                               |           | first iteration.             |
    +-------------------------------+-----------+------------------------------+
    | linsol_plugin                 | OT_STRING | Linear solver plugin         |
    +-------------------------------+-----------+------------------------------+
    | maxDualJump                   | OT_DOUBLE | Maximum allowed jump in dual |
    |                               |           | variables in linear          |
    |                               |           | independence tests.          |
    +-------------------------------+-----------+------------------------------+
    | maxPrimalJump                 | OT_DOUBLE | Maximum allowed jump in      |
    |                               |           | primal variables in nonzero  |
    |                               |           | curvature tests.             |
    +-------------------------------+-----------+------------------------------+
    | max_schur                     | OT_INT    | Maximal number of Schur      |
    |                               |           | updates [75]                 |
    +-------------------------------+-----------+------------------------------+
    | nWSR                          | OT_INT    | The maximum number of        |
    |                               |           | working set recalculations   |
    |                               |           | to be performed during the   |
    |                               |           | initial homotopy. Default is |
    |                               |           | 5(nx + nc)                   |
    +-------------------------------+-----------+------------------------------+
    | numRefinementSteps            | OT_INT    | Maximum number of iterative  |
    |                               |           | refinement steps.            |
    +-------------------------------+-----------+------------------------------+
    | numRegularisationSteps        | OT_INT    | Maximum number of successive |
    |                               |           | regularisation steps.        |
    +-------------------------------+-----------+------------------------------+
    | printLevel                    | OT_STRING | Defines the amount of text   |
    |                               |           | output during QP solution,   |
    |                               |           | see Section 5.7              |
    +-------------------------------+-----------+------------------------------+
    | schur                         | OT_BOOL   | Use Schur Complement         |
    |                               |           | Approach [false]             |
    +-------------------------------+-----------+------------------------------+
    | sparse                        | OT_BOOL   | Formulate the QP using       |
    |                               |           | sparse matrices. [false]     |
    +-------------------------------+-----------+------------------------------+
    | terminationTolerance          | OT_DOUBLE | Relative termination         |
    |                               |           | tolerance to stop homotopy.  |
    +-------------------------------+-----------+------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    sqic
    ----



    Interface to the SQIC solver for quadratic programming

    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    superscs
    --------



    Interface to the SuperSCS solver for conic programming

    Joris Gillis, 2019

    >List of available options

    +----------+---------+-----------------------------------+
    |    Id    |  Type   |            Description            |
    +==========+=========+===================================+
    | superscs | OT_DICT | Options to be passed to superscs. |
    +----------+---------+-----------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    nlpsol
    ------



    Solve QPs using an Nlpsol Use the 'nlpsol' option to specify the NLP solver
    to use.

    >List of available options

    +----------------+-----------+---------------------------------+
    |       Id       |   Type    |           Description           |
    +================+===========+=================================+
    | nlpsol         | OT_STRING | Name of solver.                 |
    +----------------+-----------+---------------------------------+
    | nlpsol_options | OT_DICT   | Options to be passed to solver. |
    +----------------+-----------+---------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    qrqp
    ----



    Solve QPs using an active-set method

    >List of available options

    +-----------------+-----------+--------------------------------------------+
    |       Id        |   Type    |                Description                 |
    +=================+===========+============================================+
    | constr_viol_tol | OT_DOUBLE | Constraint violation tolerance [1e-8].     |
    +-----------------+-----------+--------------------------------------------+
    | dual_inf_tol    | OT_DOUBLE | Dual feasibility violation tolerance       |
    |                 |           | [1e-8]                                     |
    +-----------------+-----------+--------------------------------------------+
    | max_iter        | OT_INT    | Maximum number of iterations [1000].       |
    +-----------------+-----------+--------------------------------------------+
    | min_lam         | OT_DOUBLE | Smallest multiplier treated as inactive    |
    |                 |           | for the initial active set [0].            |
    +-----------------+-----------+--------------------------------------------+
    | print_header    | OT_BOOL   | Print header [true].                       |
    +-----------------+-----------+--------------------------------------------+
    | print_info      | OT_BOOL   | Print info [true].                         |
    +-----------------+-----------+--------------------------------------------+
    | print_iter      | OT_BOOL   | Print iterations [true].                   |
    +-----------------+-----------+--------------------------------------------+
    | print_lincomb   | OT_BOOL   | Print dependant linear combinations of     |
    |                 |           | constraints [false]. Printed numbers are   |
    |                 |           | 0-based indices into the vector of [simple |
    |                 |           | bounds;linear bounds]                      |
    +-----------------+-----------+--------------------------------------------+

    --------------------------------------------------------------------------------



    Joel Andersson


    """
    return _casadi.conic(*args)

def qpsol(*args) -> "casadi::Function":
    r"""
    qpsol(std::string const & name, std::string const & solver, casadi::SXDict const & qp, casadi::Dict const & opts=casadi::Dict()) -> Function
    qpsol(std::string const & name, std::string const & solver, casadi::MXDict const & qp, casadi::Dict const & opts=casadi::Dict()) -> Function
    """
    return _casadi.qpsol(*args)

def conic_in(*args) -> "std::string":
    r"""
    conic_in() -> std::vector< std::string,std::allocator< std::string > >
    conic_in(casadi_int ind) -> std::string


    Get QP solver input scheme name by index.


    """
    return _casadi.conic_in(*args)

def conic_out(*args) -> "std::string":
    r"""
    conic_out() -> std::vector< std::string,std::allocator< std::string > >
    conic_out(casadi_int ind) -> std::string


    Get output scheme name by index.


    """
    return _casadi.conic_out(*args)

def conic_n_in(*args) -> "casadi_int":
    r"""
    conic_n_in() -> casadi_int


    Get the number of QP solver inputs.


    """
    return _casadi.conic_n_in(*args)

def conic_n_out(*args) -> "casadi_int":
    r"""
    conic_n_out() -> casadi_int


    Get the number of QP solver outputs.


    """
    return _casadi.conic_n_out(*args)

def conic_options(*args) -> "std::vector< std::string,std::allocator< std::string > >":
    r"""
    conic_options(std::string const & name) -> std::vector< std::string,std::allocator< std::string > >


    Get all options for a plugin.


    """
    return _casadi.conic_options(*args)

def conic_option_type(*args) -> "std::string":
    r"""
    conic_option_type(std::string const & name, std::string const & op) -> std::string


    Get type info for a particular option.


    """
    return _casadi.conic_option_type(*args)

def conic_option_info(*args) -> "std::string":
    r"""
    conic_option_info(std::string const & name, std::string const & op) -> std::string


    Get documentation for a particular option.


    """
    return _casadi.conic_option_info(*args)

def has_conic(*args) -> "bool":
    r"""
    has_conic(std::string const & name) -> bool


    Check if a particular plugin is available.


    """
    return _casadi.has_conic(*args)

def load_conic(*args) -> "void":
    r"""
    load_conic(std::string const & name)


    Explicitly load a plugin dynamically.


    """
    return _casadi.load_conic(*args)

def doc_conic(*args) -> "std::string":
    r"""
    doc_conic(std::string const & name) -> std::string


    Get the documentation string for a plugin.


    """
    return _casadi.doc_conic(*args)

def conic_debug(*args) -> "void":
    r"""
    conic_debug(Function f, std::string const & filename)
    conic_debug(Function f, std::ostream & file)


    Generate native code in the interfaced language for debugging


    """
    return _casadi.conic_debug(*args)

def nlpsol(*args) -> "casadi::Function":
    r"""
    nlpsol(std::string const & name, std::string const & solver, casadi::SXDict const & nlp, casadi::Dict const & opts=casadi::Dict()) -> Function
    nlpsol(std::string const & name, std::string const & solver, casadi::MXDict const & nlp, casadi::Dict const & opts=casadi::Dict()) -> Function
    nlpsol(std::string const & name, std::string const & solver, std::string const & fname, casadi::Dict const & opts=casadi::Dict()) -> Function
    nlpsol(std::string const & name, std::string const & solver, Importer compiler, casadi::Dict const & opts=casadi::Dict()) -> Function
    nlpsol(std::string const & name, std::string const & solver, NlpBuilder nl, casadi::Dict const & opts=casadi::Dict()) -> Function
    """
    return _casadi.nlpsol(*args)

def nlpsol_in(*args) -> "std::string":
    r"""
    nlpsol_in() -> std::vector< std::string,std::allocator< std::string > >
    nlpsol_in(casadi_int ind) -> std::string


    Get NLP solver input scheme name by index.

    >Input scheme: casadi::NlpsolInput (NLPSOL_NUM_IN = 8)

    +---------------+--------+-------------------------------------------------+
    |   Full name   | Short  |                   Description                   |
    +===============+========+=================================================+
    | NLPSOL_X0     | x0     | Decision variables, initial guess (nx x 1)      |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_P      | p      | Value of fixed parameters (np x 1)              |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LBX    | lbx    | Decision variables lower bound (nx x 1),        |
    |               |        | default -inf.                                   |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_UBX    | ubx    | Decision variables upper bound (nx x 1),        |
    |               |        | default +inf.                                   |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LBG    | lbg    | Constraints lower bound (ng x 1), default -inf. |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_UBG    | ubg    | Constraints upper bound (ng x 1), default +inf. |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LAM_X0 | lam_x0 | Lagrange multipliers for bounds on X, initial   |
    |               |        | guess (nx x 1)                                  |
    +---------------+--------+-------------------------------------------------+
    | NLPSOL_LAM_G0 | lam_g0 | Lagrange multipliers for bounds on G, initial   |
    |               |        | guess (ng x 1)                                  |
    +---------------+--------+-------------------------------------------------+


    """
    return _casadi.nlpsol_in(*args)

def nlpsol_out(*args) -> "std::string":
    r"""
    nlpsol_out() -> std::vector< std::string,std::allocator< std::string > >
    nlpsol_out(casadi_int ind) -> std::string


    Get output scheme name by index.

    >Output scheme: casadi::NlpsolOutput (NLPSOL_NUM_OUT = 6)

    +--------------+-------+---------------------------------------------------+
    |  Full name   | Short |                    Description                    |
    +==============+=======+===================================================+
    | NLPSOL_X     | x     | Decision variables at the optimal solution (nx x  |
    |              |       | 1)                                                |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_F     | f     | Cost function value at the optimal solution (1 x  |
    |              |       | 1)                                                |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_G     | g     | Constraints function at the optimal solution (ng  |
    |              |       | x 1)                                              |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_X | lam_x | Lagrange multipliers for bounds on X at the       |
    |              |       | solution (nx x 1)                                 |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_G | lam_g | Lagrange multipliers for bounds on G at the       |
    |              |       | solution (ng x 1)                                 |
    +--------------+-------+---------------------------------------------------+
    | NLPSOL_LAM_P | lam_p | Lagrange multipliers for bounds on P at the       |
    |              |       | solution (np x 1)                                 |
    +--------------+-------+---------------------------------------------------+


    """
    return _casadi.nlpsol_out(*args)

def nlpsol_n_in(*args) -> "casadi_int":
    r"""
    nlpsol_n_in() -> casadi_int


    Number of NLP solver inputs.


    """
    return _casadi.nlpsol_n_in(*args)

def nlpsol_n_out(*args) -> "casadi_int":
    r"""
    nlpsol_n_out() -> casadi_int


    Number of NLP solver outputs.


    """
    return _casadi.nlpsol_n_out(*args)

def nlpsol_default_in(*args) -> "std::vector< double,std::allocator< double > >":
    r"""
    nlpsol_default_in(casadi_int ind) -> double
    nlpsol_default_in() -> std::vector< double,std::allocator< double > >


    Default input for an NLP solver.


    """
    return _casadi.nlpsol_default_in(*args)

def nlpsol_options(*args) -> "std::vector< std::string,std::allocator< std::string > >":
    r"""
    nlpsol_options(std::string const & name) -> std::vector< std::string,std::allocator< std::string > >


    Get all options for a plugin.


    """
    return _casadi.nlpsol_options(*args)

def nlpsol_option_type(*args) -> "std::string":
    r"""
    nlpsol_option_type(std::string const & name, std::string const & op) -> std::string


    Get type info for a particular option.


    """
    return _casadi.nlpsol_option_type(*args)

def nlpsol_option_info(*args) -> "std::string":
    r"""
    nlpsol_option_info(std::string const & name, std::string const & op) -> std::string


    Get documentation for a particular option.


    """
    return _casadi.nlpsol_option_info(*args)

def has_nlpsol(*args) -> "bool":
    r"""
    has_nlpsol(std::string const & name) -> bool


    Check if a particular plugin is available.


    """
    return _casadi.has_nlpsol(*args)

def load_nlpsol(*args) -> "void":
    r"""
    load_nlpsol(std::string const & name)


    Explicitly load a plugin dynamically.


    """
    return _casadi.load_nlpsol(*args)

def doc_nlpsol(*args) -> "std::string":
    r"""
    doc_nlpsol(std::string const & name) -> std::string


    Get the documentation string for a plugin.


    """
    return _casadi.doc_nlpsol(*args)

def rootfinder(*args) -> "casadi::Function":
    r"""
    rootfinder(std::string const & name, std::string const & solver, casadi::SXDict const & rfp, casadi::Dict const & opts=casadi::Dict()) -> Function
    rootfinder(std::string const & name, std::string const & solver, casadi::MXDict const & rfp, casadi::Dict const & opts=casadi::Dict()) -> Function
    rootfinder(std::string const & name, std::string const & solver, Function f, casadi::Dict const & opts=casadi::Dict()) -> Function
    """
    return _casadi.rootfinder(*args)

def rootfinder_in(*args) -> "std::string":
    r"""
    rootfinder_in() -> std::vector< std::string,std::allocator< std::string > >
    rootfinder_in(casadi_int ind) -> std::string


    Get rootfinder input scheme name by index.


    """
    return _casadi.rootfinder_in(*args)

def rootfinder_out(*args) -> "std::string":
    r"""
    rootfinder_out() -> std::vector< std::string,std::allocator< std::string > >
    rootfinder_out(casadi_int ind) -> std::string


    Get rootfinder output scheme name by index.


    """
    return _casadi.rootfinder_out(*args)

def rootfinder_n_in(*args) -> "casadi_int":
    r"""
    rootfinder_n_in() -> casadi_int


    Number of rootfinder inputs.


    """
    return _casadi.rootfinder_n_in(*args)

def rootfinder_n_out(*args) -> "casadi_int":
    r"""
    rootfinder_n_out() -> casadi_int


    Number of rootfinder outputs.


    """
    return _casadi.rootfinder_n_out(*args)

def rootfinder_options(*args) -> "std::vector< std::string,std::allocator< std::string > >":
    r"""
    rootfinder_options(std::string const & name) -> std::vector< std::string,std::allocator< std::string > >


    Get all options for a plugin.


    """
    return _casadi.rootfinder_options(*args)

def rootfinder_option_type(*args) -> "std::string":
    r"""
    rootfinder_option_type(std::string const & name, std::string const & op) -> std::string


    Get type info for a particular option.


    """
    return _casadi.rootfinder_option_type(*args)

def rootfinder_option_info(*args) -> "std::string":
    r"""
    rootfinder_option_info(std::string const & name, std::string const & op) -> std::string


    Get documentation for a particular option.


    """
    return _casadi.rootfinder_option_info(*args)

def has_rootfinder(*args) -> "bool":
    r"""
    has_rootfinder(std::string const & name) -> bool


    Check if a particular plugin is available.


    """
    return _casadi.has_rootfinder(*args)

def load_rootfinder(*args) -> "void":
    r"""
    load_rootfinder(std::string const & name)


    Explicitly load a plugin dynamically.


    """
    return _casadi.load_rootfinder(*args)

def doc_rootfinder(*args) -> "std::string":
    r"""
    doc_rootfinder(std::string const & name) -> std::string


    Get the documentation string for a plugin.


    """
    return _casadi.doc_rootfinder(*args)
class Linsol(SharedObject, PrintableCommon):
    r"""


    Linear solver Create a solver for linear systems of equations Solves the
    linear system A*X = B or A^T*X = B for X with A square and non- singular.

    If A is structurally singular, an error will be thrown during init. If A is
    numerically singular, the prepare step will fail.

    General information
    ===================



    List of plugins
    ===============



    - csparsecholesky

    - csparse

    - ma27

    - lapacklu

    - lapackqr

    - mumps

    - ldl

    - qr

    - tridiag

    - symbolicqr

    Note: some of the plugins in this list might not be available on your
    system. Also, there might be extra plugins available to you that are not
    listed here. You can obtain their documentation with
    Linsol.doc("myextraplugin")



    --------------------------------------------------------------------------------

    csparsecholesky
    ---------------



    Linsol with CSparseCholesky Interface

    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    csparse
    -------



    Linsol with CSparse Interface

    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    ma27
    ----



    Interface to the sparse direct linear solver MA27 Works for symmetric
    indefinite systems Partly adopted from qpOASES 3.2 Joel Andersson

    --------------------------------------------------------------------------------

    lapacklu
    --------



    This class solves the linear system A.x=b by making an LU factorization of
    A: A = L.U, with L lower and U upper triangular

    >List of available options

    +-----------------------------+---------+----------------------------------+
    |             Id              |  Type   |           Description            |
    +=============================+=========+==================================+
    | allow_equilibration_failure | OT_BOOL | Non-fatal error when             |
    |                             |         | equilibration fails              |
    +-----------------------------+---------+----------------------------------+
    | equilibration               | OT_BOOL | Equilibrate the matrix           |
    +-----------------------------+---------+----------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    lapackqr
    --------



    This class solves the linear system A.x=b by making an QR factorization of
    A: A = Q.R, with Q orthogonal and R upper triangular

    >List of available options

    +----------+--------+------------------------------------------------------+
    |    Id    |  Type  |                     Description                      |
    +==========+========+======================================================+
    | max_nrhs | OT_INT | Maximum number of right-hand-sides that get          |
    |          |        | processed in a single pass [default:10].             |
    +----------+--------+------------------------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    mumps
    -----



    Interface to the sparse direct linear solver MUMPS Works for symmetric
    indefinite systems Joel Andersson

    >List of available options

    +-----------+---------+-------------------+
    |    Id     |  Type   |    Description    |
    +===========+=========+===================+
    | posdef    | OT_BOOL | Positive definite |
    +-----------+---------+-------------------+
    | symmetric | OT_BOOL | Symmetric matrix  |
    +-----------+---------+-------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    ldl
    ---



    Linear solver using sparse direct LDL factorization

    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    qr --



    Linear solver using sparse direct QR factorization

    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    tridiag
    -------



    Linear solver for tridiagonal matrices

    --------------------------------------------------------------------------------





    --------------------------------------------------------------------------------

    symbolicqr
    ----------



    Linear solver for sparse least-squares problems Inspired
    fromhttps://github.com/scipy/scipy/blob/v0.14.0/scipy/sparse/linalg/isolve/lsqr.py#L96

    Linsol based on QR factorization with sparsity pattern based reordering
    without partial pivoting

    >List of available options

    +-------+---------+----------------------------------------------------+
    |  Id   |  Type   |                    Description                     |
    +=======+=========+====================================================+
    | fopts | OT_DICT | Options to be passed to generated function objects |
    +-------+---------+----------------------------------------------------+

    --------------------------------------------------------------------------------



    Joel Andersson

    C++ includes: linsol.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def type_name(*args) -> "std::string":
        r"""type_name() -> std::string"""
        return _casadi.Linsol_type_name(*args)

    @staticmethod
    def has_plugin(*args) -> "bool":
        r"""has_plugin(std::string const & name) -> bool"""
        return _casadi.Linsol_has_plugin(*args)

    @staticmethod
    def load_plugin(*args) -> "void":
        r"""load_plugin(std::string const & name)"""
        return _casadi.Linsol_load_plugin(*args)

    @staticmethod
    def doc(*args) -> "std::string":
        r"""doc(std::string const & name) -> std::string"""
        return _casadi.Linsol_doc(*args)

    def plugin_name(self, *args) -> "std::string":
        r"""
        plugin_name(Linsol self) -> std::string


        Query plugin name.


        """
        return _casadi.Linsol_plugin_name(self, *args)

    def sparsity(self, *args) -> "casadi::Sparsity const &":
        r"""
        sparsity(Linsol self) -> Sparsity


        Get linear system sparsity.


        """
        return _casadi.Linsol_sparsity(self, *args)

    def sfact(self, *args) -> "void":
        r"""
        sfact(Linsol self, DM A)


        Symbolic factorization of the linear system, e.g. selecting pivots.


        """
        return _casadi.Linsol_sfact(self, *args)

    def nfact(self, *args) -> "void":
        r"""
        nfact(Linsol self, DM A)


        Numeric factorization of the linear system.


        """
        return _casadi.Linsol_nfact(self, *args)

    def solve(self, *args) -> "casadi::MX":
        r"""
        solve(Linsol self, DM A, DM B, bool tr=False) -> DM
        solve(Linsol self, MX A, MX B, bool tr=False) -> MX


        Solve linear system of equations


        """
        return _casadi.Linsol_solve(self, *args)

    def neig(self, *args) -> "casadi_int":
        r"""
        neig(Linsol self, DM A) -> casadi_int


        Number of negative eigenvalues Not available for all solvers.


        """
        return _casadi.Linsol_neig(self, *args)

    def rank(self, *args) -> "casadi_int":
        r"""
        rank(Linsol self, DM A) -> casadi_int


        Matrix rank Not available for all solvers.


        """
        return _casadi.Linsol_rank(self, *args)

    def stats(self, *args) -> "casadi::Dict":
        r"""
        stats(Linsol self, int mem=1) -> casadi::Dict


        Get all statistics obtained at the end of the last evaluate call.


        """
        return _casadi.Linsol_stats(self, *args)

    def __init__(self, *args):
        r"""
        __init__(Linsol self) -> Linsol
        __init__(Linsol self, std::string const & name, std::string const & solver, Sparsity sp, casadi::Dict const & opts=casadi::Dict()) -> Linsol
        __init__(Linsol self, Linsol other) -> Linsol
        """
        _casadi.Linsol_swiginit(self, _casadi.new_Linsol(*args))
    __swig_destroy__ = _casadi.delete_Linsol

# Register Linsol in _casadi:
_casadi.Linsol_swigregister(Linsol)

def Linsol_type_name(*args) -> "std::string":
    r"""Linsol_type_name() -> std::string"""
    return _casadi.Linsol_type_name(*args)

def Linsol_has_plugin(*args) -> "bool":
    r"""Linsol_has_plugin(std::string const & name) -> bool"""
    return _casadi.Linsol_has_plugin(*args)

def Linsol_load_plugin(*args) -> "void":
    r"""Linsol_load_plugin(std::string const & name)"""
    return _casadi.Linsol_load_plugin(*args)

def Linsol_doc(*args) -> "std::string":
    r"""Linsol_doc(std::string const & name) -> std::string"""
    return _casadi.Linsol_doc(*args)


def has_linsol(*args) -> "bool":
    r"""
    has_linsol(std::string const & name) -> bool


    Check if a particular plugin is available.


    """
    return _casadi.has_linsol(*args)

def load_linsol(*args) -> "void":
    r"""
    load_linsol(std::string const & name)


    Explicitly load a plugin dynamically.


    """
    return _casadi.load_linsol(*args)

def doc_linsol(*args) -> "std::string":
    r"""
    doc_linsol(std::string const & name) -> std::string


    Get the documentation string for a plugin.


    """
    return _casadi.doc_linsol(*args)

def dplesol(*args) -> "casadi::DMVector":
    r"""
    dplesol(std::string const & name, std::string const & solver, casadi::SpDict const & st, casadi::Dict const & opts=casadi::Dict()) -> Function
    dplesol(MX A, MX V, std::string const & solver, casadi::Dict const & opts=casadi::Dict()) -> MX
    dplesol(casadi::MXVector const & A, casadi::MXVector const & V, std::string const & solver, casadi::Dict const & opts=casadi::Dict()) -> casadi::MXVector
    dplesol(casadi::DMVector const & A, casadi::DMVector const & V, std::string const & solver, casadi::Dict const & opts=casadi::Dict()) -> casadi::DMVector
    """
    return _casadi.dplesol(*args)

def dple_in(*args) -> "std::string":
    r"""
    dple_in() -> std::vector< std::string,std::allocator< std::string > >
    dple_in(casadi_int ind) -> std::string


    Get DPLE input scheme name by index.


    """
    return _casadi.dple_in(*args)

def dple_out(*args) -> "std::string":
    r"""
    dple_out() -> std::vector< std::string,std::allocator< std::string > >
    dple_out(casadi_int ind) -> std::string


    Get DPLE output scheme name by index.


    """
    return _casadi.dple_out(*args)

def dple_n_in(*args) -> "casadi_int":
    r"""
    dple_n_in() -> casadi_int


    Get the number of QP solver inputs.


    """
    return _casadi.dple_n_in(*args)

def dple_n_out(*args) -> "casadi_int":
    r"""
    dple_n_out() -> casadi_int


    Get the number of QP solver outputs.


    """
    return _casadi.dple_n_out(*args)

def has_dple(*args) -> "bool":
    r"""
    has_dple(std::string const & name) -> bool


    Check if a particular plugin is available.


    """
    return _casadi.has_dple(*args)

def load_dple(*args) -> "void":
    r"""
    load_dple(std::string const & name)


    Explicitly load a plugin dynamically.


    """
    return _casadi.load_dple(*args)

def doc_dple(*args) -> "std::string":
    r"""
    doc_dple(std::string const & name) -> std::string


    Get the documentation string for a plugin.


    """
    return _casadi.doc_dple(*args)

def expmsol(*args) -> "casadi::Function":
    r"""
    expmsol(std::string const & name, std::string const & solver, Sparsity A, casadi::Dict const & opts=casadi::Dict()) -> Function


    Performs a matrix exponentiation expm(A)

    General information
    ===================



    >List of available options

    +------------------+-----------------+------------------+------------------+
    |        Id        |      Type       |   Description    |     Used in      |
    +==================+=================+==================+==================+
    | ad_weight        | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for derivative   | Internal         |
    |                  |                 | calculation.When |                  |
    |                  |                 | there is an      |                  |
    |                  |                 | option of either |                  |
    |                  |                 | using forward or |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | directional      |                  |
    |                  |                 | derivatives, the |                  |
    |                  |                 | condition ad_wei |                  |
    |                  |                 | ght*nf<=(1-ad_we |                  |
    |                  |                 | ight)*na is used |                  |
    |                  |                 | where nf and na  |                  |
    |                  |                 | are estimates of |                  |
    |                  |                 | the number of    |                  |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | mode directional |                  |
    |                  |                 | derivatives      |                  |
    |                  |                 | needed. By       |                  |
    |                  |                 | default,         |                  |
    |                  |                 | ad_weight is     |                  |
    |                  |                 | calculated       |                  |
    |                  |                 | automatically,   |                  |
    |                  |                 | but this can be  |                  |
    |                  |                 | overridden by    |                  |
    |                  |                 | setting this     |                  |
    |                  |                 | option. In       |                  |
    |                  |                 | particular, 0    |                  |
    |                  |                 | means forcing    |                  |
    |                  |                 | forward mode and |                  |
    |                  |                 | 1 forcing        |                  |
    |                  |                 | reverse mode.    |                  |
    |                  |                 | Leave unset for  |                  |
    |                  |                 | (class specific) |                  |
    |                  |                 | heuristics.      |                  |
    +------------------+-----------------+------------------+------------------+
    | ad_weight_sp     | OT_DOUBLE       | Weighting factor | casadi::Function |
    |                  |                 | for sparsity     | Internal         |
    |                  |                 | pattern          |                  |
    |                  |                 | calculation calc |                  |
    |                  |                 | ulation.Override |                  |
    |                  |                 | s default        |                  |
    |                  |                 | behavior. Set to |                  |
    |                  |                 | 0 and 1 to force |                  |
    |                  |                 | forward and      |                  |
    |                  |                 | reverse mode     |                  |
    |                  |                 | respectively.    |                  |
    |                  |                 | Cf. option       |                  |
    |                  |                 | "ad_weight".     |                  |
    |                  |                 | When set to -1,  |                  |
    |                  |                 | sparsity is      |                  |
    |                  |                 | completely       |                  |
    |                  |                 | ignored and      |                  |
    |                  |                 | dense matrices   |                  |
    |                  |                 | are used.        |                  |
    +------------------+-----------------+------------------+------------------+
    | always_inline    | OT_BOOL         | Force inlining.  | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | compiler         | OT_STRING       | Just-in-time     | casadi::Function |
    |                  |                 | compiler plugin  | Internal         |
    |                  |                 | to be used.      |                  |
    +------------------+-----------------+------------------+------------------+
    | const_A          | OT_BOOL         | Assume A is      | casadi::Expm     |
    |                  |                 | constant.        |                  |
    |                  |                 | Default: false.  |                  |
    +------------------+-----------------+------------------+------------------+
    | custom_jacobian  | OT_FUNCTION     | Override         | casadi::Function |
    |                  |                 | CasADi's AD. Use | Internal         |
    |                  |                 | together with    |                  |
    |                  |                 | 'jac_penalty':   |                  |
    |                  |                 | 0. Note: Highly  |                  |
    |                  |                 | experimental.    |                  |
    |                  |                 | Syntax may break |                  |
    |                  |                 | often.           |                  |
    +------------------+-----------------+------------------+------------------+
    | derivative_of    | OT_FUNCTION     | The function is  | casadi::Function |
    |                  |                 | a derivative of  | Internal         |
    |                  |                 | another          |                  |
    |                  |                 | function. The    |                  |
    |                  |                 | type of          |                  |
    |                  |                 | derivative       |                  |
    |                  |                 | (directional     |                  |
    |                  |                 | derivative,      |                  |
    |                  |                 | Jacobian) is     |                  |
    |                  |                 | inferred from    |                  |
    |                  |                 | the function     |                  |
    |                  |                 | name.            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump             | OT_BOOL         | Dump function to | casadi::Function |
    |                  |                 | file upon first  | Internal         |
    |                  |                 | evaluation.      |                  |
    |                  |                 | [false]          |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_dir         | OT_STRING       | Directory to     | casadi::Function |
    |                  |                 | dump             | Internal         |
    |                  |                 | inputs/outputs   |                  |
    |                  |                 | to. Make sure    |                  |
    |                  |                 | the directory    |                  |
    |                  |                 | exists [.]       |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_format      | OT_STRING       | Choose file      | casadi::Function |
    |                  |                 | format to dump   | Internal         |
    |                  |                 | matrices. See    |                  |
    |                  |                 | DM.from_file     |                  |
    |                  |                 | [mtx]            |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_in          | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | to file          |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | dump_out         | OT_BOOL         | Dump numerical   | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs to file  |                  |
    |                  |                 | (readable with   |                  |
    |                  |                 | DM.from_file )   |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_fd        | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation by   |                  |
    |                  |                 | finite           |                  |
    |                  |                 | differencing.    |                  |
    |                  |                 | [default:        |                  |
    |                  |                 | false]]          |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_forward   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using forward    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_jacobian  | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | Jacobians of all |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | outputs with     |                  |
    |                  |                 | respect to all   |                  |
    |                  |                 | differentiable   |                  |
    |                  |                 | inputs - if      |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | enable_reverse   | OT_BOOL         | Enable           | casadi::Function |
    |                  |                 | derivative       | Internal         |
    |                  |                 | calculation      |                  |
    |                  |                 | using generated  |                  |
    |                  |                 | functions for    |                  |
    |                  |                 | transposed       |                  |
    |                  |                 | Jacobian-times-  |                  |
    |                  |                 | vector products  |                  |
    |                  |                 | - typically      |                  |
    |                  |                 | using reverse    |                  |
    |                  |                 | mode AD - if     |                  |
    |                  |                 | available.       |                  |
    |                  |                 | [default: true]  |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_method        | OT_STRING       | Method for       | casadi::Function |
    |                  |                 | finite           | Internal         |
    |                  |                 | differencing     |                  |
    |                  |                 | [default         |                  |
    |                  |                 | 'central']       |                  |
    +------------------+-----------------+------------------+------------------+
    | fd_options       | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | finite           |                  |
    |                  |                 | difference       |                  |
    |                  |                 | instance         |                  |
    +------------------+-----------------+------------------+------------------+
    | forward_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | forward mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | gather_stats     | OT_BOOL         | Deprecated       | casadi::Function |
    |                  |                 | option           | Internal         |
    |                  |                 | (ignored):       |                  |
    |                  |                 | Statistics are   |                  |
    |                  |                 | now always       |                  |
    |                  |                 | collected.       |                  |
    +------------------+-----------------+------------------+------------------+
    | input_scheme     | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | inputs_check     | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when the         | Internal         |
    |                  |                 | numerical values |                  |
    |                  |                 | of the inputs    |                  |
    |                  |                 | don't make sense |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_in       | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each input if it | Internal         |
    |                  |                 | should be        |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | is_diff_out      | OT_BOOLVECTOR   | Indicate for     | casadi::Function |
    |                  |                 | each output if   | Internal         |
    |                  |                 | it should be     |                  |
    |                  |                 | differentiable.  |                  |
    +------------------+-----------------+------------------+------------------+
    | jac_penalty      | OT_DOUBLE       | When requested   | casadi::Function |
    |                  |                 | for a number of  | Internal         |
    |                  |                 | forward/reverse  |                  |
    |                  |                 | directions, it   |                  |
    |                  |                 | may be cheaper   |                  |
    |                  |                 | to compute first |                  |
    |                  |                 | the full         |                  |
    |                  |                 | jacobian and     |                  |
    |                  |                 | then multiply    |                  |
    |                  |                 | with seeds,      |                  |
    |                  |                 | rather than      |                  |
    |                  |                 | obtain the       |                  |
    |                  |                 | requested        |                  |
    |                  |                 | directions in a  |                  |
    |                  |                 | straightforward  |                  |
    |                  |                 | manner. Casadi   |                  |
    |                  |                 | uses a heuristic |                  |
    |                  |                 | to decide which  |                  |
    |                  |                 | is cheaper. A    |                  |
    |                  |                 | high value of    |                  |
    |                  |                 | 'jac_penalty'    |                  |
    |                  |                 | makes it less    |                  |
    |                  |                 | likely for the   |                  |
    |                  |                 | heurstic to      |                  |
    |                  |                 | chose the full   |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy. The    |                  |
    |                  |                 | special value -1 |                  |
    |                  |                 | indicates never  |                  |
    |                  |                 | to use the full  |                  |
    |                  |                 | Jacobian         |                  |
    |                  |                 | strategy         |                  |
    +------------------+-----------------+------------------+------------------+
    | jit              | OT_BOOL         | Use just-in-time | casadi::Function |
    |                  |                 | compiler to      | Internal         |
    |                  |                 | speed up the     |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_cleanup      | OT_BOOL         | Cleanup up the   | casadi::Function |
    |                  |                 | temporary source | Internal         |
    |                  |                 | file that jit    |                  |
    |                  |                 | creates.         |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_name         | OT_STRING       | The file name    | casadi::Function |
    |                  |                 | used to write    | Internal         |
    |                  |                 | out code. The    |                  |
    |                  |                 | actual file      |                  |
    |                  |                 | names used       |                  |
    |                  |                 | depend on 'jit_t |                  |
    |                  |                 | emp_suffix' and  |                  |
    |                  |                 | include          |                  |
    |                  |                 | extensions.      |                  |
    |                  |                 | Default:         |                  |
    |                  |                 | 'jit_tmp'        |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_options      | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to the    | Internal         |
    |                  |                 | jit compiler.    |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_serialize    | OT_STRING       | Specify          | casadi::Function |
    |                  |                 | behaviour when   | Internal         |
    |                  |                 | serializing a    |                  |
    |                  |                 | jitted function: |                  |
    |                  |                 | SOURCE|link|embe |                  |
    |                  |                 | d.               |                  |
    +------------------+-----------------+------------------+------------------+
    | jit_temp_suffix  | OT_BOOL         | Use a temporary  | casadi::Function |
    |                  |                 | (seemingly       | Internal         |
    |                  |                 | random) filename |                  |
    |                  |                 | suffix for       |                  |
    |                  |                 | generated code   |                  |
    |                  |                 | and libraries.   |                  |
    |                  |                 | This is desired  |                  |
    |                  |                 | for thread-      |                  |
    |                  |                 | safety. This     |                  |
    |                  |                 | behaviour may    |                  |
    |                  |                 | defeat caching   |                  |
    |                  |                 | compiler         |                  |
    |                  |                 | wrappers.        |                  |
    |                  |                 | Default: true    |                  |
    +------------------+-----------------+------------------+------------------+
    | max_num_dir      | OT_INT          | Specify the      | casadi::Function |
    |                  |                 | maximum number   | Internal         |
    |                  |                 | of directions    |                  |
    |                  |                 | for derivative   |                  |
    |                  |                 | functions.       |                  |
    |                  |                 | Overrules the    |                  |
    |                  |                 | builtin optimize |                  |
    |                  |                 | d_num_dir.       |                  |
    +------------------+-----------------+------------------+------------------+
    | never_inline     | OT_BOOL         | Forbid inlining. | casadi::Function |
    |                  |                 |                  | Internal         |
    +------------------+-----------------+------------------+------------------+
    | output_scheme    | OT_STRINGVECTOR | Deprecated       | casadi::Function |
    |                  |                 | option (ignored) | Internal         |
    +------------------+-----------------+------------------+------------------+
    | print_in         | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of inputs | Internal         |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_out        | OT_BOOL         | Print numerical  | casadi::Function |
    |                  |                 | values of        | Internal         |
    |                  |                 | outputs          |                  |
    |                  |                 | [default: false] |                  |
    +------------------+-----------------+------------------+------------------+
    | print_time       | OT_BOOL         | print            | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time. Implies    |                  |
    |                  |                 | record_time.     |                  |
    +------------------+-----------------+------------------+------------------+
    | record_time      | OT_BOOL         | record           | casadi::Function |
    |                  |                 | information      | Internal         |
    |                  |                 | about execution  |                  |
    |                  |                 | time, for        |                  |
    |                  |                 | retrieval with   |                  |
    |                  |                 | stats().         |                  |
    +------------------+-----------------+------------------+------------------+
    | regularity_check | OT_BOOL         | Throw exceptions | casadi::Function |
    |                  |                 | when NaN or Inf  | Internal         |
    |                  |                 | appears during   |                  |
    |                  |                 | evaluation       |                  |
    +------------------+-----------------+------------------+------------------+
    | reverse_options  | OT_DICT         | Options to be    | casadi::Function |
    |                  |                 | passed to a      | Internal         |
    |                  |                 | reverse mode     |                  |
    |                  |                 | constructor      |                  |
    +------------------+-----------------+------------------+------------------+
    | user_data        | OT_VOIDPTR      | A user-defined   | casadi::Function |
    |                  |                 | field that can   | Internal         |
    |                  |                 | be used to       |                  |
    |                  |                 | identify the     |                  |
    |                  |                 | function or pass |                  |
    |                  |                 | additional       |                  |
    |                  |                 | information      |                  |
    +------------------+-----------------+------------------+------------------+
    | verbose          | OT_BOOL         | Verbose          | casadi::Function |
    |                  |                 | evaluation  for  | Internal         |
    |                  |                 | debugging        |                  |
    +------------------+-----------------+------------------+------------------+

    List of plugins
    ===============



    - slicot

    Note: some of the plugins in this list might not be available on your
    system. Also, there might be extra plugins available to you that are not
    listed here. You can obtain their documentation with
    Expm.doc("myextraplugin")



    --------------------------------------------------------------------------------

    slicot
    ------





    --------------------------------------------------------------------------------



    Joris Gillis


    """
    return _casadi.expmsol(*args)

def expm_n_in(*args) -> "casadi_int":
    r"""
    expm_n_in() -> casadi_int


    Get the number of expm solver inputs.


    """
    return _casadi.expm_n_in(*args)

def expm_n_out(*args) -> "casadi_int":
    r"""
    expm_n_out() -> casadi_int


    Get the number of expm solver outputs.


    """
    return _casadi.expm_n_out(*args)

def has_expm(*args) -> "bool":
    r"""
    has_expm(std::string const & name) -> bool


    Check if a particular plugin is available.


    """
    return _casadi.has_expm(*args)

def load_expm(*args) -> "void":
    r"""
    load_expm(std::string const & name)


    Explicitly load a plugin dynamically.


    """
    return _casadi.load_expm(*args)

def doc_expm(*args) -> "std::string":
    r"""
    doc_expm(std::string const & name) -> std::string


    Get the documentation string for a plugin.


    """
    return _casadi.doc_expm(*args)

def interpolant(*args) -> "casadi::Function":
    r"""
    interpolant(std::string const & name, std::string const & solver, std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const & grid, std::vector< double,std::allocator< double > > const & values, casadi::Dict const & opts=casadi::Dict()) -> Function
    interpolant(std::string const & name, std::string const & solver, std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const & grid, casadi_int m=1, casadi::Dict const & opts=casadi::Dict()) -> Function
    interpolant(std::string const & name, std::string const & solver, std::vector< casadi_int,std::allocator< casadi_int > > const & grid_dims, casadi_int m=1, casadi::Dict const & opts=casadi::Dict()) -> Function
    interpolant(std::string const & name, std::string const & solver, std::vector< casadi_int,std::allocator< casadi_int > > const & grid_dims, std::vector< double,std::allocator< double > > const & values, casadi::Dict const & opts=casadi::Dict()) -> Function


    Parametric variant of interpolant.

    The resulting function will have an additional argument for the grid

    By default, derivatives wrt the coefficients are not supported (zero). Some
    interpolant plugins may support the inline=true which enables correct
    derivatives


    """
    return _casadi.interpolant(*args)

def has_interpolant(*args) -> "bool":
    r"""
    has_interpolant(std::string const & name) -> bool


    Check if a particular plugin is available.


    """
    return _casadi.has_interpolant(*args)

def load_interpolant(*args) -> "void":
    r"""
    load_interpolant(std::string const & name)


    Explicitly load a plugin dynamically.


    """
    return _casadi.load_interpolant(*args)

def doc_interpolant(*args) -> "std::string":
    r"""
    doc_interpolant(std::string const & name) -> std::string


    Get the documentation string for a plugin.


    """
    return _casadi.doc_interpolant(*args)
class CodeGenerator(object):
    r"""


    Helper class for C code generation.

    Joel Andersson

    C++ includes: code_generator.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(CodeGenerator self, std::string const & name, casadi::Dict const & opts=casadi::Dict()) -> CodeGenerator


        Constructor.


        """
        _casadi.CodeGenerator_swiginit(self, _casadi.new_CodeGenerator(*args))

    def add(self, *args) -> "void":
        r"""
        add(CodeGenerator self, Function f, bool with_jac_sparsity=False)


        Add a function (name generated)


        """
        return _casadi.CodeGenerator_add(self, *args)

    def dump(self, *args) -> "std::string":
        r"""
        dump(CodeGenerator self) -> std::string


        Generate a file, return code as string.


        """
        return _casadi.CodeGenerator_dump(self, *args)

    def generate(self, *args) -> "std::string":
        r"""
        generate(CodeGenerator self, std::string const & prefix="") -> std::string


        Generate file(s) The "prefix" argument will be prepended to the generated
        files and may be a directory or a file prefix. returns the filename.


        """
        return _casadi.CodeGenerator_generate(self, *args)

    def add_include(self, *args) -> "void":
        r"""
        add_include(CodeGenerator self, std::string const & new_include, bool relative_path=False, std::string const & use_ifdef=std::string())


        Add an include file optionally using a relative path "..." instead of an
        absolute path <...>


        """
        return _casadi.CodeGenerator_add_include(self, *args)
    __swig_destroy__ = _casadi.delete_CodeGenerator

# Register CodeGenerator in _casadi:
_casadi.CodeGenerator_swigregister(CodeGenerator)

FLAG = _casadi.FLAG


def _horzcat(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    _horzcat(std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > > const & v) -> Sparsity
    _horzcat(std::vector< casadi::MX,std::allocator< casadi::MX > > const & v) -> MX
    _horzcat(std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & v) -> DM
    _horzcat(std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & v) -> SX
    """
    return _casadi._horzcat(*args)

def _vertcat(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    _vertcat(std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > > const & v) -> Sparsity
    _vertcat(std::vector< casadi::MX,std::allocator< casadi::MX > > const & v) -> MX
    _vertcat(std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & v) -> DM
    _vertcat(std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & v) -> SX
    """
    return _casadi._vertcat(*args)

def horzsplit(*args) -> "std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >":
    r"""
    horzsplit(Sparsity v, std::vector< casadi_int,std::allocator< casadi_int > > const & offset) -> std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >
    horzsplit(Sparsity v, casadi_int incr=1) -> std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >
    horzsplit(MX v, std::vector< casadi_int,std::allocator< casadi_int > > const & offset) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
    horzsplit(MX v, casadi_int incr=1) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
    horzsplit(DM v, std::vector< casadi_int,std::allocator< casadi_int > > const & offset) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
    horzsplit(DM v, casadi_int incr=1) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
    horzsplit(SX v, std::vector< casadi_int,std::allocator< casadi_int > > const & offset) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >
    horzsplit(SX v, casadi_int incr=1) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >
    """
    return _casadi.horzsplit(*args)

def offset(*args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
    r"""
    offset(std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > > const & v, bool vert=True) -> std::vector< casadi_int,std::allocator< casadi_int > >
    offset(std::vector< casadi::MX,std::allocator< casadi::MX > > const & v, bool vert=True) -> std::vector< casadi_int,std::allocator< casadi_int > >
    offset(std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & v, bool vert=True) -> std::vector< casadi_int,std::allocator< casadi_int > >
    offset(std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & v, bool vert=True) -> std::vector< casadi_int,std::allocator< casadi_int > >
    """
    return _casadi.offset(*args)

def vertsplit(*args) -> "std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >":
    r"""
    vertsplit(Sparsity v, std::vector< casadi_int,std::allocator< casadi_int > > const & offset) -> std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >
    vertsplit(Sparsity v, casadi_int incr=1) -> std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >
    vertsplit(MX v, std::vector< casadi_int,std::allocator< casadi_int > > const & offset) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
    vertsplit(MX v, casadi_int incr=1) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
    vertsplit(DM v, std::vector< casadi_int,std::allocator< casadi_int > > const & offset) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
    vertsplit(DM v, casadi_int incr=1) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
    vertsplit(SX v, std::vector< casadi_int,std::allocator< casadi_int > > const & offset) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >
    vertsplit(SX v, casadi_int incr=1) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >
    """
    return _casadi.vertsplit(*args)

def blocksplit(*args) -> "std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > >":
    r"""
    blocksplit(Sparsity x, std::vector< casadi_int,std::allocator< casadi_int > > const & vert_offset, std::vector< casadi_int,std::allocator< casadi_int > > const & horz_offset) -> std::vector< std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >,std::allocator< std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > > > >
    blocksplit(Sparsity x, casadi_int vert_incr=1, casadi_int horz_incr=1) -> std::vector< std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >,std::allocator< std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > > > >
    blocksplit(MX x, std::vector< casadi_int,std::allocator< casadi_int > > const & vert_offset, std::vector< casadi_int,std::allocator< casadi_int > > const & horz_offset) -> std::vector< std::vector< casadi::MX,std::allocator< casadi::MX > >,std::allocator< std::vector< casadi::MX,std::allocator< casadi::MX > > > >
    blocksplit(MX x, casadi_int vert_incr=1, casadi_int horz_incr=1) -> std::vector< std::vector< casadi::MX,std::allocator< casadi::MX > >,std::allocator< std::vector< casadi::MX,std::allocator< casadi::MX > > > >
    blocksplit(DM x, std::vector< casadi_int,std::allocator< casadi_int > > const & vert_offset, std::vector< casadi_int,std::allocator< casadi_int > > const & horz_offset) -> std::vector< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >,std::allocator< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > > >
    blocksplit(DM x, casadi_int vert_incr=1, casadi_int horz_incr=1) -> std::vector< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >,std::allocator< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > > >
    blocksplit(SX x, std::vector< casadi_int,std::allocator< casadi_int > > const & vert_offset, std::vector< casadi_int,std::allocator< casadi_int > > const & horz_offset) -> std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > >
    blocksplit(SX x, casadi_int vert_incr=1, casadi_int horz_incr=1) -> std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > >
    """
    return _casadi.blocksplit(*args)

def _diagcat(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    _diagcat(std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > > const & A) -> Sparsity
    _diagcat(std::vector< casadi::MX,std::allocator< casadi::MX > > const & A) -> MX
    _diagcat(std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & A) -> DM
    _diagcat(std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & A) -> SX
    """
    return _casadi._diagcat(*args)

def diagsplit(*args) -> "std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >":
    r"""
    diagsplit(Sparsity x, std::vector< casadi_int,std::allocator< casadi_int > > const & output_offset1, std::vector< casadi_int,std::allocator< casadi_int > > const & output_offset2) -> std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >
    diagsplit(Sparsity x, std::vector< casadi_int,std::allocator< casadi_int > > const & output_offset) -> std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >
    diagsplit(Sparsity x, casadi_int incr=1) -> std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >
    diagsplit(Sparsity x, casadi_int incr1, casadi_int incr2) -> std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >
    diagsplit(MX x, std::vector< casadi_int,std::allocator< casadi_int > > const & output_offset1, std::vector< casadi_int,std::allocator< casadi_int > > const & output_offset2) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
    diagsplit(MX x, std::vector< casadi_int,std::allocator< casadi_int > > const & output_offset) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
    diagsplit(MX x, casadi_int incr=1) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
    diagsplit(MX x, casadi_int incr1, casadi_int incr2) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
    diagsplit(DM x, std::vector< casadi_int,std::allocator< casadi_int > > const & output_offset1, std::vector< casadi_int,std::allocator< casadi_int > > const & output_offset2) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
    diagsplit(DM x, std::vector< casadi_int,std::allocator< casadi_int > > const & output_offset) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
    diagsplit(DM x, casadi_int incr=1) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
    diagsplit(DM x, casadi_int incr1, casadi_int incr2) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
    diagsplit(SX x, std::vector< casadi_int,std::allocator< casadi_int > > const & output_offset1, std::vector< casadi_int,std::allocator< casadi_int > > const & output_offset2) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >
    diagsplit(SX x, std::vector< casadi_int,std::allocator< casadi_int > > const & output_offset) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >
    diagsplit(SX x, casadi_int incr=1) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >
    diagsplit(SX x, casadi_int incr1, casadi_int incr2) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >
    """
    return _casadi.diagsplit(*args)

def _veccat(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    _veccat(std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > > const & x) -> Sparsity
    _veccat(std::vector< casadi::MX,std::allocator< casadi::MX > > const & x) -> MX
    _veccat(std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & x) -> DM
    _veccat(std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & x) -> SX
    """
    return _casadi._veccat(*args)

def mtimes(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    mtimes(Sparsity x, Sparsity y) -> Sparsity
    mtimes(std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > > const & args) -> Sparsity
    mtimes(MX x, MX y) -> MX
    mtimes(std::vector< casadi::MX,std::allocator< casadi::MX > > const & args) -> MX
    mtimes(DM x, DM y) -> DM
    mtimes(std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & args) -> DM
    mtimes(SX x, SX y) -> SX
    mtimes(std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & args) -> SX
    """
    return _casadi.mtimes(*args)

def mac(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    mac(Sparsity X, Sparsity Y, Sparsity Z) -> Sparsity
    mac(MX X, MX Y, MX Z) -> MX
    mac(DM X, DM Y, DM Z) -> DM
    mac(SX X, SX Y, SX Z) -> SX
    """
    return _casadi.mac(*args)

def transpose(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    transpose(Sparsity X) -> Sparsity
    transpose(MX X) -> MX
    transpose(DM X) -> DM
    transpose(SX X) -> SX


    Transpose the matrix and get the reordering of the non-zero entries.

    Parameters:
    -----------

    mapping:  the non-zeros of the original matrix for each non-zero of the new
    matrix


    """
    return _casadi.transpose(*args)

def vec(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    vec(Sparsity a) -> Sparsity
    vec(MX a) -> MX
    vec(DM a) -> DM
    vec(SX a) -> SX
    """
    return _casadi.vec(*args)

def reshape(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    reshape(Sparsity a, casadi_int nrow, casadi_int ncol) -> Sparsity
    reshape(Sparsity a, std::pair< casadi_int,casadi_int > rc) -> Sparsity
    reshape(Sparsity a, Sparsity sp) -> Sparsity
    reshape(MX a, casadi_int nrow, casadi_int ncol) -> MX
    reshape(MX a, std::pair< casadi_int,casadi_int > rc) -> MX
    reshape(MX a, Sparsity sp) -> MX
    reshape(DM a, casadi_int nrow, casadi_int ncol) -> DM
    reshape(DM a, std::pair< casadi_int,casadi_int > rc) -> DM
    reshape(DM a, Sparsity sp) -> DM
    reshape(SX a, casadi_int nrow, casadi_int ncol) -> SX
    reshape(SX a, std::pair< casadi_int,casadi_int > rc) -> SX
    reshape(SX a, Sparsity sp) -> SX
    """
    return _casadi.reshape(*args)

def sprank(*args) -> "casadi_int":
    r"""
    sprank(Sparsity A) -> casadi_int
    sprank(MX A) -> casadi_int
    sprank(DM A) -> casadi_int
    sprank(SX A) -> casadi_int
    """
    return _casadi.sprank(*args)

def norm_0_mul(*args) -> "casadi_int":
    r"""
    norm_0_mul(Sparsity x, Sparsity y) -> casadi_int
    norm_0_mul(MX x, MX y) -> casadi_int
    norm_0_mul(DM x, DM y) -> casadi_int
    norm_0_mul(SX x, SX y) -> casadi_int
    """
    return _casadi.norm_0_mul(*args)

def triu(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    triu(Sparsity a, bool includeDiagonal=True) -> Sparsity
    triu(MX a, bool includeDiagonal=True) -> MX
    triu(DM a, bool includeDiagonal=True) -> DM
    triu(SX a, bool includeDiagonal=True) -> SX
    """
    return _casadi.triu(*args)

def tril(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    tril(Sparsity a, bool includeDiagonal=True) -> Sparsity
    tril(MX a, bool includeDiagonal=True) -> MX
    tril(DM a, bool includeDiagonal=True) -> DM
    tril(SX a, bool includeDiagonal=True) -> SX
    """
    return _casadi.tril(*args)

def kron(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    kron(Sparsity a, Sparsity b) -> Sparsity
    kron(MX a, MX b) -> MX
    kron(DM a, DM b) -> DM
    kron(SX a, SX b) -> SX
    """
    return _casadi.kron(*args)

def repmat(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    repmat(Sparsity A, casadi_int n, casadi_int m=1) -> Sparsity
    repmat(Sparsity A, std::pair< casadi_int,casadi_int > const & rc) -> Sparsity
    repmat(MX A, casadi_int n, casadi_int m=1) -> MX
    repmat(MX A, std::pair< casadi_int,casadi_int > const & rc) -> MX
    repmat(DM A, casadi_int n, casadi_int m=1) -> DM
    repmat(DM A, std::pair< casadi_int,casadi_int > const & rc) -> DM
    repmat(SX A, casadi_int n, casadi_int m=1) -> SX
    repmat(SX A, std::pair< casadi_int,casadi_int > const & rc) -> SX
    """
    return _casadi.repmat(*args)

def sum2(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    sum2(Sparsity x) -> Sparsity
    sum2(MX x) -> MX
    sum2(DM x) -> DM
    sum2(SX x) -> SX
    """
    return _casadi.sum2(*args)

def sum1(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    sum1(Sparsity x) -> Sparsity
    sum1(MX x) -> MX
    sum1(DM x) -> DM
    sum1(SX x) -> SX
    """
    return _casadi.sum1(*args)

def plus(*args) -> "double":
    r"""
    plus(MX x, MX y) -> MX
    plus(DM x, DM y) -> DM
    plus(SX x, SX y) -> SX
    plus(double const & x, double const & y) -> double
    """
    return _casadi.plus(*args)

def minus(*args) -> "double":
    r"""
    minus(MX x, MX y) -> MX
    minus(DM x, DM y) -> DM
    minus(SX x, SX y) -> SX
    minus(double const & x, double const & y) -> double
    """
    return _casadi.minus(*args)

def times(*args) -> "double":
    r"""
    times(MX x, MX y) -> MX
    times(DM x, DM y) -> DM
    times(SX x, SX y) -> SX
    times(double const & x, double const & y) -> double
    """
    return _casadi.times(*args)

def rdivide(*args) -> "double":
    r"""
    rdivide(MX x, MX y) -> MX
    rdivide(DM x, DM y) -> DM
    rdivide(SX x, SX y) -> SX
    rdivide(double const & x, double const & y) -> double
    """
    return _casadi.rdivide(*args)

def ldivide(*args) -> "double":
    r"""
    ldivide(MX x, MX y) -> MX
    ldivide(DM x, DM y) -> DM
    ldivide(SX x, SX y) -> SX
    ldivide(double const & x, double const & y) -> double
    """
    return _casadi.ldivide(*args)

def lt(*args) -> "double":
    r"""
    lt(MX x, MX y) -> MX
    lt(DM x, DM y) -> DM
    lt(SX x, SX y) -> SX
    lt(double const & x, double const & y) -> double
    """
    return _casadi.lt(*args)

def le(*args) -> "double":
    r"""
    le(MX x, MX y) -> MX
    le(DM x, DM y) -> DM
    le(SX x, SX y) -> SX
    le(double const & x, double const & y) -> double
    """
    return _casadi.le(*args)

def gt(*args) -> "double":
    r"""
    gt(MX x, MX y) -> MX
    gt(DM x, DM y) -> DM
    gt(SX x, SX y) -> SX
    gt(double const & x, double const & y) -> double
    """
    return _casadi.gt(*args)

def ge(*args) -> "double":
    r"""
    ge(MX x, MX y) -> MX
    ge(DM x, DM y) -> DM
    ge(SX x, SX y) -> SX
    ge(double const & x, double const & y) -> double
    """
    return _casadi.ge(*args)

def eq(*args) -> "double":
    r"""
    eq(MX x, MX y) -> MX
    eq(DM x, DM y) -> DM
    eq(SX x, SX y) -> SX
    eq(double const & x, double const & y) -> double
    """
    return _casadi.eq(*args)

def ne(*args) -> "double":
    r"""
    ne(MX x, MX y) -> MX
    ne(DM x, DM y) -> DM
    ne(SX x, SX y) -> SX
    ne(double const & x, double const & y) -> double
    """
    return _casadi.ne(*args)

def logic_and(*args) -> "double":
    r"""
    logic_and(MX x, MX y) -> MX
    logic_and(DM x, DM y) -> DM
    logic_and(SX x, SX y) -> SX
    logic_and(double const & x, double const & y) -> double
    """
    return _casadi.logic_and(*args)

def logic_or(*args) -> "double":
    r"""
    logic_or(MX x, MX y) -> MX
    logic_or(DM x, DM y) -> DM
    logic_or(SX x, SX y) -> SX
    logic_or(double const & x, double const & y) -> double
    """
    return _casadi.logic_or(*args)

def logic_not(*args) -> "double":
    r"""
    logic_not(MX x) -> MX
    logic_not(DM x) -> DM
    logic_not(SX x) -> SX
    logic_not(double const & x) -> double
    """
    return _casadi.logic_not(*args)

def fabs(*args) -> "double":
    r"""
    fabs(MX x) -> MX
    fabs(DM x) -> DM
    fabs(SX x) -> SX
    fabs(double const & x) -> double
    """
    return _casadi.fabs(*args)

def sqrt(*args) -> "double":
    r"""
    sqrt(MX x) -> MX
    sqrt(DM x) -> DM
    sqrt(SX x) -> SX
    sqrt(double const & x) -> double
    """
    return _casadi.sqrt(*args)

def sin(*args) -> "double":
    r"""
    sin(MX x) -> MX
    sin(DM x) -> DM
    sin(SX x) -> SX
    sin(double const & x) -> double
    """
    return _casadi.sin(*args)

def cos(*args) -> "double":
    r"""
    cos(MX x) -> MX
    cos(DM x) -> DM
    cos(SX x) -> SX
    cos(double const & x) -> double
    """
    return _casadi.cos(*args)

def tan(*args) -> "double":
    r"""
    tan(MX x) -> MX
    tan(DM x) -> DM
    tan(SX x) -> SX
    tan(double const & x) -> double
    """
    return _casadi.tan(*args)

def atan(*args) -> "double":
    r"""
    atan(MX x) -> MX
    atan(DM x) -> DM
    atan(SX x) -> SX
    atan(double const & x) -> double
    """
    return _casadi.atan(*args)

def asin(*args) -> "double":
    r"""
    asin(MX x) -> MX
    asin(DM x) -> DM
    asin(SX x) -> SX
    asin(double const & x) -> double
    """
    return _casadi.asin(*args)

def acos(*args) -> "double":
    r"""
    acos(MX x) -> MX
    acos(DM x) -> DM
    acos(SX x) -> SX
    acos(double const & x) -> double
    """
    return _casadi.acos(*args)

def tanh(*args) -> "double":
    r"""
    tanh(MX x) -> MX
    tanh(DM x) -> DM
    tanh(SX x) -> SX
    tanh(double const & x) -> double
    """
    return _casadi.tanh(*args)

def sinh(*args) -> "double":
    r"""
    sinh(MX x) -> MX
    sinh(DM x) -> DM
    sinh(SX x) -> SX
    sinh(double const & x) -> double
    """
    return _casadi.sinh(*args)

def cosh(*args) -> "double":
    r"""
    cosh(MX x) -> MX
    cosh(DM x) -> DM
    cosh(SX x) -> SX
    cosh(double const & x) -> double
    """
    return _casadi.cosh(*args)

def atanh(*args) -> "double":
    r"""
    atanh(MX x) -> MX
    atanh(DM x) -> DM
    atanh(SX x) -> SX
    atanh(double const & x) -> double
    """
    return _casadi.atanh(*args)

def asinh(*args) -> "double":
    r"""
    asinh(MX x) -> MX
    asinh(DM x) -> DM
    asinh(SX x) -> SX
    asinh(double const & x) -> double
    """
    return _casadi.asinh(*args)

def acosh(*args) -> "double":
    r"""
    acosh(MX x) -> MX
    acosh(DM x) -> DM
    acosh(SX x) -> SX
    acosh(double const & x) -> double
    """
    return _casadi.acosh(*args)

def exp(*args) -> "double":
    r"""
    exp(MX x) -> MX
    exp(DM x) -> DM
    exp(SX x) -> SX
    exp(double const & x) -> double
    """
    return _casadi.exp(*args)

def log(*args) -> "double":
    r"""
    log(MX x) -> MX
    log(DM x) -> DM
    log(SX x) -> SX
    log(double const & x) -> double
    """
    return _casadi.log(*args)

def log10(*args) -> "double":
    r"""
    log10(MX x) -> MX
    log10(DM x) -> DM
    log10(SX x) -> SX
    log10(double const & x) -> double
    """
    return _casadi.log10(*args)

def floor(*args) -> "double":
    r"""
    floor(MX x) -> MX
    floor(DM x) -> DM
    floor(SX x) -> SX
    floor(double const & x) -> double
    """
    return _casadi.floor(*args)

def ceil(*args) -> "double":
    r"""
    ceil(MX x) -> MX
    ceil(DM x) -> DM
    ceil(SX x) -> SX
    ceil(double const & x) -> double
    """
    return _casadi.ceil(*args)

def erf(*args) -> "double":
    r"""
    erf(MX x) -> MX
    erf(DM x) -> DM
    erf(SX x) -> SX
    erf(double const & x) -> double
    """
    return _casadi.erf(*args)

def erfinv(*args) -> "double":
    r"""
    erfinv(MX x) -> MX
    erfinv(DM x) -> DM
    erfinv(SX x) -> SX
    erfinv(double const & x) -> double
    """
    return _casadi.erfinv(*args)

def sign(*args) -> "double":
    r"""
    sign(MX x) -> MX
    sign(DM x) -> DM
    sign(SX x) -> SX
    sign(double const & x) -> double
    """
    return _casadi.sign(*args)

def power(*args) -> "double":
    r"""
    power(MX x, MX n) -> MX
    power(DM x, DM n) -> DM
    power(SX x, SX n) -> SX
    power(double const & x, double const & n) -> double
    """
    return _casadi.power(*args)

def mod(*args) -> "double":
    r"""
    mod(MX x, MX y) -> MX
    mod(DM x, DM y) -> DM
    mod(SX x, SX y) -> SX
    mod(double const & x, double const & y) -> double
    """
    return _casadi.mod(*args)

def fmod(*args) -> "double":
    r"""
    fmod(MX x, MX y) -> MX
    fmod(DM x, DM y) -> DM
    fmod(SX x, SX y) -> SX
    fmod(double const & x, double const & y) -> double
    """
    return _casadi.fmod(*args)

def atan2(*args) -> "double":
    r"""
    atan2(MX x, MX y) -> MX
    atan2(DM x, DM y) -> DM
    atan2(SX x, SX y) -> SX
    atan2(double const & x, double const & y) -> double
    """
    return _casadi.atan2(*args)

def fmin(*args) -> "double":
    r"""
    fmin(MX x, MX y) -> MX
    fmin(DM x, DM y) -> DM
    fmin(SX x, SX y) -> SX
    fmin(double const & x, double const & y) -> double
    """
    return _casadi.fmin(*args)

def fmax(*args) -> "double":
    r"""
    fmax(MX x, MX y) -> MX
    fmax(DM x, DM y) -> DM
    fmax(SX x, SX y) -> SX
    fmax(double const & x, double const & y) -> double
    """
    return _casadi.fmax(*args)

def simplify(*args) -> "double":
    r"""
    simplify(MX x) -> MX
    simplify(DM x) -> DM
    simplify(SX x) -> SX
    simplify(double const & x) -> double


    Simplify an expression.


    """
    return _casadi.simplify(*args)

def is_equal(*args) -> "bool":
    r"""
    is_equal(MX x, MX y, casadi_int depth=0) -> bool
    is_equal(DM x, DM y, casadi_int depth=0) -> bool
    is_equal(SX x, SX y, casadi_int depth=0) -> bool
    is_equal(double const & x, double const & y, casadi_int depth=0) -> bool
    """
    return _casadi.is_equal(*args)

def copysign(*args) -> "double":
    r"""
    copysign(MX x, MX y) -> MX
    copysign(DM x, DM y) -> DM
    copysign(SX x, SX y) -> SX
    copysign(double const & x, double const & y) -> double
    """
    return _casadi.copysign(*args)

def constpow(*args) -> "double":
    r"""
    constpow(MX x, MX y) -> MX
    constpow(DM x, DM y) -> DM
    constpow(SX x, SX y) -> SX
    constpow(double const & x, double const & y) -> double
    """
    return _casadi.constpow(*args)

def mpower(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    mpower(MX x, MX n) -> MX
    mpower(DM x, DM n) -> DM
    mpower(SX x, SX n) -> SX


    Matrix power x^n.


    """
    return _casadi.mpower(*args)

def mrdivide(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    mrdivide(MX x, MX y) -> MX
    mrdivide(DM x, DM y) -> DM
    mrdivide(SX x, SX y) -> SX


    Matrix divide (cf. slash '/' in MATLAB)


    """
    return _casadi.mrdivide(*args)

def mldivide(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    mldivide(MX x, MX y) -> MX
    mldivide(DM x, DM y) -> DM
    mldivide(SX x, SX y) -> SX


    Matrix divide (cf. backslash '\\' in MATLAB)


    """
    return _casadi.mldivide(*args)

def symvar(*args) -> "std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >":
    r"""
    symvar(MX x) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
    symvar(DM x) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
    symvar(SX x) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >


    Get symbols present in expression.

    Returned vector is ordered according to the order of variable()/parameter()
    calls used to create the variables


    """
    return _casadi.symvar(*args)

def bilin(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    bilin(MX A, MX x, MX y) -> MX
    bilin(DM A, DM x, DM y) -> DM
    bilin(SX A, SX x, SX y) -> SX


    Calculate bilinear form x^T A y.


    """
    return _casadi.bilin(*args)

def rank1(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    rank1(MX A, MX alpha, MX x, MX y) -> MX
    rank1(DM A, DM alpha, DM x, DM y) -> DM
    rank1(SX A, SX alpha, SX x, SX y) -> SX


    Make a rank-1 update to a matrix A Calculates A + 1/2 * alpha * x*y'.


    """
    return _casadi.rank1(*args)

def sumsqr(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    sumsqr(MX X) -> MX
    sumsqr(DM X) -> DM
    sumsqr(SX X) -> SX


    Calculate sum of squares: sum_ij X_ij^2.


    """
    return _casadi.sumsqr(*args)

def linspace(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    linspace(MX a, MX b, casadi_int nsteps) -> MX
    linspace(DM a, DM b, casadi_int nsteps) -> DM
    linspace(SX a, SX b, casadi_int nsteps) -> SX


    Matlab's linspace command.


    """
    return _casadi.linspace(*args)

def interp1d(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    interp1d(std::vector< double,std::allocator< double > > const & x, MX v, std::vector< double,std::allocator< double > > const & xq, std::string const & mode="linear", bool equidistant=False) -> MX
    interp1d(std::vector< double,std::allocator< double > > const & x, DM v, std::vector< double,std::allocator< double > > const & xq, std::string const & mode="linear", bool equidistant=False) -> DM
    interp1d(std::vector< double,std::allocator< double > > const & x, SX v, std::vector< double,std::allocator< double > > const & xq, std::string const & mode="linear", bool equidistant=False) -> SX


    Performs 1d linear interpolation.

    The data-points to be interpolated are given as (x[i], v[i]). xq[j] is used
    as interplating value


    """
    return _casadi.interp1d(*args)

def soc(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    soc(MX x, MX y) -> MX
    soc(DM x, DM y) -> DM
    soc(SX x, SX y) -> SX


    Construct second-order-convex.

    Parameters:
    -----------

    x:  vector expression of size n

    y:  scalar expression

    soc(x,y) computes [y*eye(n) x; x' y]

    soc(x,y) positive semi definite <=> || x ||_2 <= y


    """
    return _casadi.soc(*args)

def cross(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    cross(MX a, MX b, casadi_int dim=-1) -> MX
    cross(DM a, DM b, casadi_int dim=-1) -> DM
    cross(SX a, SX b, casadi_int dim=-1) -> SX


    Matlab's cross command.


    """
    return _casadi.cross(*args)

def skew(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    skew(MX a) -> MX
    skew(DM a) -> DM
    skew(SX a) -> SX


    Generate a skew symmetric matrix from a 3-vector.


    """
    return _casadi.skew(*args)

def inv_skew(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    inv_skew(MX a) -> MX
    inv_skew(DM a) -> DM
    inv_skew(SX a) -> SX


    Generate the 3-vector progenitor of a skew symmetric matrix.


    """
    return _casadi.inv_skew(*args)

def det(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    det(MX A) -> MX
    det(DM A) -> DM
    det(SX A) -> SX


    Matrix determinant (experimental)


    """
    return _casadi.det(*args)

def inv_minor(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    inv_minor(MX A) -> MX
    inv_minor(DM A) -> DM
    inv_minor(SX A) -> SX


    Matrix inverse (experimental)


    """
    return _casadi.inv_minor(*args)

def inv(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    inv(MX A) -> MX
    inv(MX A, std::string const & lsolver, casadi::Dict const & opts=casadi::Dict()) -> MX
    inv(DM A) -> DM
    inv(DM A, std::string const & lsolver, casadi::Dict const & opts=casadi::Dict()) -> DM
    inv(SX A) -> SX
    inv(SX A, std::string const & lsolver, casadi::Dict const & opts=casadi::Dict()) -> SX


    Matrix inverse.


    """
    return _casadi.inv(*args)

def trace(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    trace(MX a) -> MX
    trace(DM a) -> DM
    trace(SX a) -> SX


    Matrix trace.


    """
    return _casadi.trace(*args)

def tril2symm(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    tril2symm(MX a) -> MX
    tril2symm(DM a) -> DM
    tril2symm(SX a) -> SX


    Convert a lower triangular matrix to a symmetric one.


    """
    return _casadi.tril2symm(*args)

def triu2symm(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    triu2symm(MX a) -> MX
    triu2symm(DM a) -> DM
    triu2symm(SX a) -> SX


    Convert a upper triangular matrix to a symmetric one.


    """
    return _casadi.triu2symm(*args)

def norm_fro(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    norm_fro(MX x) -> MX
    norm_fro(DM x) -> DM
    norm_fro(SX x) -> SX


    Frobenius norm.


    """
    return _casadi.norm_fro(*args)

def norm_2(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    norm_2(MX x) -> MX
    norm_2(DM x) -> DM
    norm_2(SX x) -> SX


    2-norm


    """
    return _casadi.norm_2(*args)

def norm_1(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    norm_1(MX x) -> MX
    norm_1(DM x) -> DM
    norm_1(SX x) -> SX


    1-norm


    """
    return _casadi.norm_1(*args)

def norm_inf(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    norm_inf(MX x) -> MX
    norm_inf(DM x) -> DM
    norm_inf(SX x) -> SX


    Infinity-norm.


    """
    return _casadi.norm_inf(*args)

def dot(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    dot(MX x, MX y) -> MX
    dot(DM x, DM y) -> DM
    dot(SX x, SX y) -> SX


    Inner product of two matrices with x and y matrices of the same dimension.


    """
    return _casadi.dot(*args)

def nullspace(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    nullspace(MX A) -> MX
    nullspace(DM A) -> DM
    nullspace(SX A) -> SX


    Computes the nullspace of a matrix A.

    Finds Z m-by-(m-n) such that AZ = 0 with A n-by-m with m > n

    Assumes A is full rank

    Inspired by Numerical Methods in Scientific Computing by Ake Bjorck


    """
    return _casadi.nullspace(*args)

def polyval(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    polyval(MX p, MX x) -> MX
    polyval(DM p, DM x) -> DM
    polyval(SX p, SX x) -> SX


    Evaluate a polynomial with coefficients p in x.


    """
    return _casadi.polyval(*args)

def diag(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    diag(MX A) -> MX
    diag(DM A) -> DM
    diag(SX A) -> SX


    Create diagonal sparsity pattern.


    """
    return _casadi.diag(*args)

def unite(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    unite(MX A, MX B) -> MX
    unite(DM A, DM B) -> DM
    unite(SX A, SX B) -> SX


    Union of two sparsity patterns.


    """
    return _casadi.unite(*args)

def densify(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    densify(MX x) -> MX
    densify(DM x) -> DM
    densify(SX x) -> SX


    Make the matrix dense and assign nonzeros to a value.


    """
    return _casadi.densify(*args)

def project(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    project(MX A, Sparsity sp, bool intersect=False) -> MX
    project(DM A, Sparsity sp, bool intersect=False) -> DM
    project(SX A, Sparsity sp, bool intersect=False) -> SX


    Create a new matrix with a given sparsity pattern but with the nonzeros
    taken from an existing matrix.


    """
    return _casadi.project(*args)

def if_else(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    if_else(MX cond, MX if_true, MX if_false, bool short_circuit=False) -> MX
    if_else(DM cond, DM if_true, DM if_false, bool short_circuit=False) -> DM
    if_else(SX cond, SX if_true, SX if_false, bool short_circuit=False) -> SX


    Branching on MX nodes Ternary operator, "cond ? if_true : if_false".


    """
    return _casadi.if_else(*args)

def conditional(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    conditional(MX ind, std::vector< casadi::MX,std::allocator< casadi::MX > > const & x, MX x_default, bool short_circuit=False) -> MX
    conditional(DM ind, std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & x, DM x_default, bool short_circuit=False) -> DM
    conditional(SX ind, std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & x, SX x_default, bool short_circuit=False) -> SX


    Create a switch.

    If the condition

    Parameters:
    -----------

    ind:  evaluates to the integer k, where 0<=k<f.size(), then x[k] will be
    returned, otherwise

    x_default:  will be returned.


    """
    return _casadi.conditional(*args)

def depends_on(*args) -> "bool":
    r"""
    depends_on(MX f, MX arg) -> bool
    depends_on(DM f, DM arg) -> bool
    depends_on(SX f, SX arg) -> bool


    Check if expression depends on the argument The argument must be symbolic.


    """
    return _casadi.depends_on(*args)

def solve(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    solve(MX A, MX b) -> MX
    solve(MX A, MX b, std::string const & lsolver, casadi::Dict const & opts=casadi::Dict()) -> MX
    solve(DM A, DM b) -> DM
    solve(DM A, DM b, std::string const & lsolver, casadi::Dict const & opts=casadi::Dict()) -> DM
    solve(SX A, SX b) -> SX
    solve(SX A, SX b, std::string const & lsolver, casadi::Dict const & opts=casadi::Dict()) -> SX


    Solve the QP.


    """
    return _casadi.solve(*args)

def pinv(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    pinv(MX A) -> MX
    pinv(MX A, std::string const & lsolver, casadi::Dict const & opts=casadi::Dict()) -> MX
    pinv(DM A) -> DM
    pinv(DM A, std::string const & lsolver, casadi::Dict const & opts=casadi::Dict()) -> DM
    pinv(SX A) -> SX
    pinv(SX A, std::string const & lsolver, casadi::Dict const & opts=casadi::Dict()) -> SX


    Computes the Moore-Penrose pseudo-inverse.

    If the matrix A is fat (size1>size2), mul(A, pinv(A)) is unity. If the
    matrix A is slender (size2<size1), mul(pinv(A), A) is unity.


    """
    return _casadi.pinv(*args)

def expm_const(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    expm_const(MX A, MX t) -> MX
    expm_const(DM A, DM t) -> DM
    expm_const(SX A, SX t) -> SX
    """
    return _casadi.expm_const(*args)

def expm(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    expm(MX A) -> MX
    expm(DM A) -> DM
    expm(SX A) -> SX
    """
    return _casadi.expm(*args)

def jacobian(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    jacobian(MX ex, MX arg, casadi::Dict const & opts=casadi::Dict()) -> MX
    jacobian(DM ex, DM arg, casadi::Dict const & opts=casadi::Dict()) -> DM
    jacobian(SX ex, SX arg, casadi::Dict const & opts=casadi::Dict()) -> SX


    Calculate Jacobian.


    """
    return _casadi.jacobian(*args)

def jtimes(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    jtimes(MX ex, MX arg, MX v, bool tr=False) -> MX
    jtimes(DM ex, DM arg, DM v, bool tr=False) -> DM
    jtimes(SX ex, SX arg, SX v, bool tr=False) -> SX


    Calculate the Jacobian and multiply by a vector from the right This is
    equivalent to mul(jacobian(ex, arg), v) or mul(jacobian(ex, arg).T, v) for
    tr set to false and true respectively. If contrast to these expressions, it
    will use directional derivatives which is typically (but not necessarily)
    more efficient if the complete Jacobian is not needed and v has few rows.


    """
    return _casadi.jtimes(*args)

def linearize(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    linearize(MX f, MX x, MX x0) -> MX
    linearize(DM f, DM x, DM x0) -> DM
    linearize(SX f, SX x, SX x0) -> SX


    Linearize an expression.


    """
    return _casadi.linearize(*args)

def which_depends(*args) -> "std::vector< bool,std::allocator< bool > >":
    r"""
    which_depends(MX expr, MX var, casadi_int order=1, bool tr=False) -> std::vector< bool,std::allocator< bool > >
    which_depends(DM expr, DM var, casadi_int order=1, bool tr=False) -> std::vector< bool,std::allocator< bool > >
    which_depends(SX expr, SX var, casadi_int order=1, bool tr=False) -> std::vector< bool,std::allocator< bool > >


    Find out which variables enter with some order.


    """
    return _casadi.which_depends(*args)

def is_linear(*args) -> "bool":
    r"""
    is_linear(MX expr, MX var) -> bool
    is_linear(DM expr, DM var) -> bool
    is_linear(SX expr, SX var) -> bool


    Is expr linear in var?

    False negatives are possible (an expression may not be recognised as linear
    while it really is), false positives not.


    """
    return _casadi.is_linear(*args)

def is_quadratic(*args) -> "bool":
    r"""
    is_quadratic(MX expr, MX var) -> bool
    is_quadratic(DM expr, DM var) -> bool
    is_quadratic(SX expr, SX var) -> bool


    Is expr quadratic in var?

    False negatives are possible (an expression may not be recognised as
    quadratic while it really is), false positives not.


    """
    return _casadi.is_quadratic(*args)

def gradient(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    gradient(MX ex, MX arg) -> MX
    gradient(DM ex, DM arg) -> DM
    gradient(SX ex, SX arg) -> SX


    Calculate Jacobian.


    """
    return _casadi.gradient(*args)

def tangent(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    tangent(MX ex, MX arg) -> MX
    tangent(DM ex, DM arg) -> DM
    tangent(SX ex, SX arg) -> SX


    Calculate Jacobian.


    """
    return _casadi.tangent(*args)

def hessian(*args) -> "casadi::Matrix< casadi::SXElem > &":
    r"""
    hessian(MX ex, MX arg) -> MX
    hessian(DM ex, DM arg) -> DM
    hessian(SX ex, SX arg) -> SX
    """
    return _casadi.hessian(*args)

def quadratic_coeff(*args) -> "casadi::Matrix< casadi::SXElem > &, casadi::Matrix< casadi::SXElem > &, casadi::Matrix< casadi::SXElem > &":
    r"""
    quadratic_coeff(MX ex, MX arg, bool check=True)
    quadratic_coeff(DM ex, DM arg, bool check=True)
    quadratic_coeff(SX ex, SX arg, bool check=True)


    Recognizes quadratic form in scalar expression.

    1/2*x' A x + b' x + c

    e = 0.5*bilin(A,x,x)+dot(b,x)+c

    Parameters:
    -----------

    check[in]:  When true (default), A is checked to be independent of x.
    Provided to deal with false positive dependency checks.


    """
    return _casadi.quadratic_coeff(*args)

def linear_coeff(*args) -> "casadi::Matrix< casadi::SXElem > &, casadi::Matrix< casadi::SXElem > &":
    r"""
    linear_coeff(MX ex, MX arg, bool check=True)
    linear_coeff(DM ex, DM arg, bool check=True)
    linear_coeff(SX ex, SX arg, bool check=True)


    Recognizes linear form in vector expression.

    A x + b

    Parameters:
    -----------

    check[in]:  When true (default)m, A is checked to be independent of x.
    Provided to deal with false positive dependency checks.


    """
    return _casadi.linear_coeff(*args)

def n_nodes(*args) -> "casadi_int":
    r"""
    n_nodes(MX A) -> casadi_int
    n_nodes(DM A) -> casadi_int
    n_nodes(SX A) -> casadi_int
    """
    return _casadi.n_nodes(*args)

def print_operator(*args) -> "std::string":
    r"""
    print_operator(MX xb, std::vector< std::string,std::allocator< std::string > > const & args) -> std::string
    print_operator(DM xb, std::vector< std::string,std::allocator< std::string > > const & args) -> std::string
    print_operator(SX xb, std::vector< std::string,std::allocator< std::string > > const & args) -> std::string


    Get a string representation for a binary MatType, using custom arguments.


    """
    return _casadi.print_operator(*args)

def repsum(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    repsum(MX A, casadi_int n, casadi_int m=1) -> MX
    repsum(DM A, casadi_int n, casadi_int m=1) -> DM
    repsum(SX A, casadi_int n, casadi_int m=1) -> SX


    Given a repeated matrix, computes the sum of repeated parts.


    """
    return _casadi.repsum(*args)

def diff(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    diff(MX A, casadi_int n=1, casadi_index axis=-1) -> MX
    diff(DM A, casadi_int n=1, casadi_index axis=-1) -> DM
    diff(SX A, casadi_int n=1, casadi_index axis=-1) -> SX


    Returns difference (n-th order) along given axis (MATLAB convention)


    """
    return _casadi.diff(*args)

def cumsum(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    cumsum(MX A, casadi_index axis=-1) -> MX
    cumsum(DM A, casadi_index axis=-1) -> DM
    cumsum(SX A, casadi_index axis=-1) -> SX


    Returns cumulative sum along given axis (MATLAB convention)


    """
    return _casadi.cumsum(*args)

def einstein(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    einstein(MX A, MX B, MX C, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_a, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_b, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_c, std::vector< casadi_int,std::allocator< casadi_int > > const & a, std::vector< casadi_int,std::allocator< casadi_int > > const & b, std::vector< casadi_int,std::allocator< casadi_int > > const & c) -> MX
    einstein(MX A, MX B, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_a, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_b, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_c, std::vector< casadi_int,std::allocator< casadi_int > > const & a, std::vector< casadi_int,std::allocator< casadi_int > > const & b, std::vector< casadi_int,std::allocator< casadi_int > > const & c) -> MX
    einstein(DM A, DM B, DM C, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_a, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_b, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_c, std::vector< casadi_int,std::allocator< casadi_int > > const & a, std::vector< casadi_int,std::allocator< casadi_int > > const & b, std::vector< casadi_int,std::allocator< casadi_int > > const & c) -> DM
    einstein(DM A, DM B, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_a, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_b, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_c, std::vector< casadi_int,std::allocator< casadi_int > > const & a, std::vector< casadi_int,std::allocator< casadi_int > > const & b, std::vector< casadi_int,std::allocator< casadi_int > > const & c) -> DM
    einstein(SX A, SX B, SX C, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_a, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_b, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_c, std::vector< casadi_int,std::allocator< casadi_int > > const & a, std::vector< casadi_int,std::allocator< casadi_int > > const & b, std::vector< casadi_int,std::allocator< casadi_int > > const & c) -> SX
    einstein(SX A, SX B, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_a, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_b, std::vector< casadi_int,std::allocator< casadi_int > > const & dim_c, std::vector< casadi_int,std::allocator< casadi_int > > const & a, std::vector< casadi_int,std::allocator< casadi_int > > const & b, std::vector< casadi_int,std::allocator< casadi_int > > const & c) -> SX


    Computes an einstein dense tensor contraction.

    Computes the product: C_c = A_a + B_b where a b c are index/einstein
    notation in an encoded form

    For example, an matrix-matrix product may be written as: C_ij = A_ik B_kj

    The encoded form uses strictly negative numbers to indicate labels. For the
    above example, we would have: a {-1, -3} b {-3, -2} c {-1 -2}


    """
    return _casadi.einstein(*args)

def mmin(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    mmin(MX x) -> MX
    mmin(DM x) -> DM
    mmin(SX x) -> SX


    Smallest element in a matrix.


    """
    return _casadi.mmin(*args)

def mmax(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    mmax(MX x) -> MX
    mmax(DM x) -> DM
    mmax(SX x) -> SX


    Largest element in a matrix.


    """
    return _casadi.mmax(*args)

def evalf(*args) -> "casadi::DM":
    r"""
    evalf(MX x) -> DM
    evalf(DM x) -> DM
    evalf(SX x) -> DM


    Evaluates the expression numerically.

    An error is raised when the expression contains symbols


    """
    return _casadi.evalf(*args)

def forward(*args) -> "std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > >":
    r"""
    forward(std::vector< casadi::MX,std::allocator< casadi::MX > > const & ex, std::vector< casadi::MX,std::allocator< casadi::MX > > const & arg, std::vector< std::vector< casadi::MX,std::allocator< casadi::MX > >,std::allocator< std::vector< casadi::MX,std::allocator< casadi::MX > > > > const & v, casadi::Dict const & opts=casadi::Dict()) -> std::vector< std::vector< casadi::MX,std::allocator< casadi::MX > >,std::allocator< std::vector< casadi::MX,std::allocator< casadi::MX > > > >
    forward(std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & ex, std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & arg, std::vector< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >,std::allocator< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > > > const & v, casadi::Dict const & opts=casadi::Dict()) -> std::vector< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >,std::allocator< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > > >
    forward(std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & ex, std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & arg, std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > > const & v, casadi::Dict const & opts=casadi::Dict()) -> std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > >


    Forward directional derivative.


    """
    return _casadi.forward(*args)

def reverse(*args) -> "std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > >":
    r"""
    reverse(std::vector< casadi::MX,std::allocator< casadi::MX > > const & ex, std::vector< casadi::MX,std::allocator< casadi::MX > > const & arg, std::vector< std::vector< casadi::MX,std::allocator< casadi::MX > >,std::allocator< std::vector< casadi::MX,std::allocator< casadi::MX > > > > const & v, casadi::Dict const & opts=casadi::Dict()) -> std::vector< std::vector< casadi::MX,std::allocator< casadi::MX > >,std::allocator< std::vector< casadi::MX,std::allocator< casadi::MX > > > >
    reverse(std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & ex, std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & arg, std::vector< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >,std::allocator< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > > > const & v, casadi::Dict const & opts=casadi::Dict()) -> std::vector< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >,std::allocator< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > > >
    reverse(std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & ex, std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & arg, std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > > const & v, casadi::Dict const & opts=casadi::Dict()) -> std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > >


    Reverse directional derivative.


    """
    return _casadi.reverse(*args)

def substitute(*args) -> "std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >":
    r"""
    substitute(MX ex, MX v, MX vdef) -> MX
    substitute(std::vector< casadi::MX,std::allocator< casadi::MX > > const & ex, std::vector< casadi::MX,std::allocator< casadi::MX > > const & v, std::vector< casadi::MX,std::allocator< casadi::MX > > const & vdef) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
    substitute(DM ex, DM v, DM vdef) -> DM
    substitute(std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & ex, std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & v, std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & vdef) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >
    substitute(SX ex, SX v, SX vdef) -> SX
    substitute(std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & ex, std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & v, std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & vdef) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >


    Substitute variable var with expression expr in multiple expressions.


    """
    return _casadi.substitute(*args)

def substitute_inplace(*args) -> "std::vector< casadi::Matrix< casadi::SXElem > > &, std::vector< casadi::Matrix< casadi::SXElem > > &":
    r"""
    substitute_inplace(std::vector< casadi::MX,std::allocator< casadi::MX > > const & v, std::vector< casadi::MX,std::allocator< casadi::MX > > & INOUT1, std::vector< casadi::MX,std::allocator< casadi::MX > > & INOUT2, bool reverse=False)
    substitute_inplace(std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & v, std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > & INOUT1, std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > & INOUT2, bool reverse=False)
    substitute_inplace(std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & v, std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > & INOUT1, std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > & INOUT2, bool reverse=False)


    Inplace substitution with piggyback expressions Substitute variables v out
    of the expressions vdef sequentially, as well as out of a number of other
    expressions piggyback.


    """
    return _casadi.substitute_inplace(*args)

def shared(*args) -> "std::vector< casadi::Matrix< casadi::SXElem > > &, std::vector< casadi::Matrix< casadi::SXElem > > &, std::vector< casadi::Matrix< casadi::SXElem > > &":
    r"""
    shared(std::vector< casadi::MX,std::allocator< casadi::MX > > const & ex, std::string const & v_prefix="v_", std::string const & v_suffix="")
    shared(std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & ex, std::string const & v_prefix="v_", std::string const & v_suffix="")
    shared(std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & ex, std::string const & v_prefix="v_", std::string const & v_suffix="")


    Get a shared (owning) reference.


    """
    return _casadi.shared(*args)

def blockcat(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    blockcat(Sparsity A, Sparsity B, Sparsity C, Sparsity D) -> Sparsity
    blockcat(MX A, MX B, MX C, MX D) -> MX
    blockcat(DM A, DM B, DM C, DM D) -> DM
    blockcat(SX A, SX B, SX C, SX D) -> SX
    blockcat(std::vector< std::vector< casadi::MX,std::allocator< casadi::MX > >,std::allocator< std::vector< casadi::MX,std::allocator< casadi::MX > > > > const & v) -> MX
    blockcat(std::vector< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >,std::allocator< std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > > > const & v) -> DM
    blockcat(std::vector< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >,std::allocator< std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > > > const & v) -> SX
    """
    return _casadi.blockcat(*args)

def logic_all(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    logic_all(DM x) -> DM
    logic_all(SX x) -> SX


    Get a vector of indices (nested slice)


    """
    return _casadi.logic_all(*args)

def logic_any(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    logic_any(DM x) -> DM
    logic_any(SX x) -> SX


    Returns true only if any element in the matrix is true.


    """
    return _casadi.logic_any(*args)

def adj(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    adj(DM A) -> DM
    adj(SX A) -> SX


    Matrix adjoint.


    """
    return _casadi.adj(*args)

def minor(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    minor(DM x, casadi_int i, casadi_int j) -> DM
    minor(SX x, casadi_int i, casadi_int j) -> SX


    Get the (i,j) minor matrix.


    """
    return _casadi.minor(*args)

def cofactor(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    cofactor(DM x, casadi_int i, casadi_int j) -> DM
    cofactor(SX x, casadi_int i, casadi_int j) -> SX


    Get the (i,j) cofactor matrix.


    """
    return _casadi.cofactor(*args)

def qr(*args) -> "casadi::Matrix< casadi::SXElem > &, casadi::Matrix< casadi::SXElem > &":
    r"""
    qr(DM A)
    qr(SX A)


    QR factorization using the modified Gram-Schmidt algorithm More stable than
    the classical Gram-Schmidt, but may break down if the rows of A are nearly
    linearly dependent See J. Demmel: Applied Numerical Linear Algebra
    (algorithm 3.1.). Note that in SWIG, Q and R are returned by value.


    """
    return _casadi.qr(*args)

def qr_sparse(*args) -> "casadi::Matrix< casadi::SXElem > &, casadi::Matrix< casadi::SXElem > &, casadi::Matrix< casadi::SXElem > &, std::vector< casadi_int > &, std::vector< casadi_int > &":
    r"""
    qr_sparse(DM A, bool amd=True)
    qr_sparse(SX A, bool amd=True)


    Symbolic QR factorization Returns the sparsity pattern of V (compact
    representation of Q) and R as well as vectors needed for the numerical
    factorization and solution. The implementation is a modified version of
    CSparse Copyright(c) Timothy A. Davis, 2006-2009 Licensed as a derivative
    work under the GNU LGPL.


    """
    return _casadi.qr_sparse(*args)

def qr_solve(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    qr_solve(DM b, DM v, DM r, DM beta, std::vector< casadi_int,std::allocator< casadi_int > > const & prinv, std::vector< casadi_int,std::allocator< casadi_int > > const & pc, bool tr=False) -> DM
    qr_solve(SX b, SX v, SX r, SX beta, std::vector< casadi_int,std::allocator< casadi_int > > const & prinv, std::vector< casadi_int,std::allocator< casadi_int > > const & pc, bool tr=False) -> SX


    Solve using a sparse QR factorization.


    """
    return _casadi.qr_solve(*args)

def ldl(*args) -> "casadi::Matrix< casadi::SXElem > &, casadi::Matrix< casadi::SXElem > &, std::vector< casadi_int > &":
    r"""
    ldl(DM A, bool amd=True)
    ldl(SX A, bool amd=True)


    Symbolic LDL factorization Returns the sparsity pattern of L^T.

    The implementation is a modified version of LDL Copyright(c) Timothy A.
    Davis, 2005-2013 Licensed as a derivative work under the GNU LGPL


    """
    return _casadi.ldl(*args)

def ldl_solve(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    ldl_solve(DM b, DM D, DM LT, std::vector< casadi_int,std::allocator< casadi_int > > const & p) -> DM
    ldl_solve(SX b, SX D, SX LT, std::vector< casadi_int,std::allocator< casadi_int > > const & p) -> SX


    Solve using a sparse LDL^T factorization.


    """
    return _casadi.ldl_solve(*args)

def chol(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    chol(DM A) -> DM
    chol(SX A) -> SX


    Obtain a Cholesky factorisation of a matrix Performs and LDL transformation
    [L,D] = ldl(A) and returns diag(sqrt(D))*L'.


    """
    return _casadi.chol(*args)

def norm_inf_mul(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    norm_inf_mul(DM x, DM y) -> DM
    norm_inf_mul(SX x, SX y) -> SX


    Inf-norm of a Matrix-Matrix product.


    """
    return _casadi.norm_inf_mul(*args)

def sparsify(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    sparsify(DM A, double tol=0) -> DM
    sparsify(SX A, double tol=0) -> SX


    Make a matrix sparse by removing numerical zeros.


    """
    return _casadi.sparsify(*args)

def expand(*args) -> "casadi::Matrix< casadi::SXElem > &, casadi::Matrix< casadi::SXElem > &":
    r"""
    expand(DM ex)
    expand(SX ex)


    Expand the expression as a weighted sum (with constant weights)


    """
    return _casadi.expand(*args)

def pw_const(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    pw_const(DM t, DM tval, DM val) -> DM
    pw_const(SX t, SX tval, SX val) -> SX


    Create a piecewise constant function Create a piecewise constant function
    with n=val.size() intervals.

    Inputs:

    Parameters:
    -----------

    t:  a scalar variable (e.g. time)

    tval:  vector with the discrete values of t at the interval transitions
    (length n-1)

    val:  vector with the value of the function for each interval (length n)


    """
    return _casadi.pw_const(*args)

def pw_lin(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    pw_lin(DM t, DM tval, DM val) -> DM
    pw_lin(SX t, SX tval, SX val) -> SX


    t a scalar variable (e.g. time)

    Create a piecewise linear function Create a piecewise linear function:

    Inputs: tval vector with the the discrete values of t (monotonically
    increasing) val vector with the corresponding function values (same length
    as tval)


    """
    return _casadi.pw_lin(*args)

def heaviside(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    heaviside(DM x) -> DM
    heaviside(SX x) -> SX


    Heaviside function.

    \\[ \\begin {cases} H(x) = 0 & x<0 \\\\ H(x) = 1/2 & x=0 \\\\
    H(x) = 1 & x>0 \\\\ \\end {cases} \\]


    """
    return _casadi.heaviside(*args)

def rectangle(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    rectangle(DM x) -> DM
    rectangle(SX x) -> SX


    rectangle function

    \\[ \\begin {cases} \\Pi(x) = 1 & |x| < 1/2 \\\\ \\Pi(x) = 1/2 &
    |x| = 1/2 \\\\ \\Pi(x) = 0 & |x| > 1/2 \\\\ \\end {cases} \\]

    Also called: gate function, block function, band function, pulse function,
    window function


    """
    return _casadi.rectangle(*args)

def triangle(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    triangle(DM x) -> DM
    triangle(SX x) -> SX


    triangle function

    \\[ \\begin {cases} \\Lambda(x) = 0 & |x| >= 1 \\\\ \\Lambda(x)
    = 1-|x| & |x| < 1 \\end {cases} \\]


    """
    return _casadi.triangle(*args)

def ramp(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    ramp(DM x) -> DM
    ramp(SX x) -> SX


    ramp function

    \\[ \\begin {cases} R(x) = 0 & x <= 1 \\\\ R(x) = x & x > 1 \\\\
    \\end {cases} \\]

    Also called: slope function


    """
    return _casadi.ramp(*args)

def gauss_quadrature(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    gauss_quadrature(DM f, DM x, DM a, DM b, casadi_int order=5) -> DM
    gauss_quadrature(DM f, DM x, DM a, DM b, casadi_int order, DM w) -> DM
    gauss_quadrature(SX f, SX x, SX a, SX b, casadi_int order=5) -> SX
    gauss_quadrature(SX f, SX x, SX a, SX b, casadi_int order, SX w) -> SX


    Matrix adjoint.


    """
    return _casadi.gauss_quadrature(*args)

def taylor(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    taylor(DM ex, DM x, DM a=0, casadi_int order=1) -> DM
    taylor(SX ex, SX x, SX a=0, casadi_int order=1) -> SX


    univariate Taylor series expansion

    Calculate the Taylor expansion of expression 'ex' up to order 'order' with
    respect to variable 'x' around the point 'a'

    $(x)=f(a)+f'(a)(x-a)+f''(a)\\frac
    {(x-a)^2}{2!}+f'''(a)\\frac{(x-a)^3}{3!}+\\ldots$

    Example usage:

    ::

    >>   x




    """
    return _casadi.taylor(*args)

def mtaylor(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    mtaylor(DM ex, DM x, DM a, casadi_int order=1) -> DM
    mtaylor(DM ex, DM x, DM a, casadi_int order, std::vector< casadi_int,std::allocator< casadi_int > > const & order_contributions) -> DM
    mtaylor(SX ex, SX x, SX a, casadi_int order=1) -> SX
    mtaylor(SX ex, SX x, SX a, casadi_int order, std::vector< casadi_int,std::allocator< casadi_int > > const & order_contributions) -> SX


    multivariate Taylor series expansion

    Do Taylor expansions until the aggregated order of a term is equal to
    'order'. The aggregated order of $x^n y^m$ equals $n+m$.

    The argument order_contributions can denote how match each variable
    contributes to the aggregated order. If x=[x, y] and order_contributions=[1,
    2], then the aggregated order of $x^n y^m$ equals $1n+2m$.

    Example usage

    $ \\sin(b+a)+\\cos(b+a)(x-a)+\\cos(b+a)(y-b) $ $ y+x-(x^3+3y x^2+3 y^2
    x+y^3)/6 $ $ (-3 x^2 y-x^3)/6+y+x $


    """
    return _casadi.mtaylor(*args)

def poly_coeff(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    poly_coeff(DM ex, DM x) -> DM
    poly_coeff(SX ex, SX x) -> SX


    extracts polynomial coefficients from an expression

    Parameters:
    -----------

    ex:  Scalar expression that represents a polynomial

    x:  Scalar symbol that the polynomial is build up with


    """
    return _casadi.poly_coeff(*args)

def poly_roots(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    poly_roots(DM p) -> DM
    poly_roots(SX p) -> SX


    Attempts to find the roots of a polynomial.

    This will only work for polynomials up to order 3 It is assumed that the
    roots are real.


    """
    return _casadi.poly_roots(*args)

def eig_symbolic(*args) -> "casadi::Matrix< casadi::SXElem >":
    r"""
    eig_symbolic(DM m) -> DM
    eig_symbolic(SX m) -> SX


    Attempts to find the eigenvalues of a symbolic matrix This will only work
    for up to 3x3 matrices.


    """
    return _casadi.eig_symbolic(*args)

def find(*args) -> "casadi::MX":
    r"""
    find(MX x) -> MX


    Get the location of all non-zero elements as they would appear in a Dense
    matrix A : DenseMatrix 4 x 3 B : SparseMatrix 4 x 3 , 5 structural non-
    zeros.

    k = A.find() A[k] will contain the elements of A that are non-zero in B

    Inverse of nonzeros.


    """
    return _casadi.find(*args)

def low(*args) -> "casadi::MX":
    r"""
    low(MX v, MX p, casadi::Dict const & options=casadi::Dict()) -> MX


    Find first nonzero If failed, returns the number of rows.


    """
    return _casadi.low(*args)

def inv_node(*args) -> "casadi::MX":
    r"""
    inv_node(MX x) -> MX


    Inverse node.


    """
    return _casadi.inv_node(*args)

def matrix_expand(*args) -> "casadi::MX":
    r"""
    matrix_expand(std::vector< casadi::MX,std::allocator< casadi::MX > > const & e, std::vector< casadi::MX,std::allocator< casadi::MX > > const & boundary=std::vector< casadi::MX >(), casadi::Dict const & options=casadi::Dict()) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
    matrix_expand(MX e, std::vector< casadi::MX,std::allocator< casadi::MX > > const & boundary=std::vector< casadi::MX >(), casadi::Dict const & options=casadi::Dict()) -> MX


    Expand MX graph to SXFunction call.

    Expand the given expression e, optionally supplying expressions contained in
    it at which expansion should stop.


    """
    return _casadi.matrix_expand(*args)

def graph_substitute(*args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
    r"""
    graph_substitute(MX ex, std::vector< casadi::MX,std::allocator< casadi::MX > > const & v, std::vector< casadi::MX,std::allocator< casadi::MX > > const & vdef) -> MX
    graph_substitute(std::vector< casadi::MX,std::allocator< casadi::MX > > const & ex, std::vector< casadi::MX,std::allocator< casadi::MX > > const & v, std::vector< casadi::MX,std::allocator< casadi::MX > > const & vdef) -> std::vector< casadi::MX,std::allocator< casadi::MX > >


    Substitute multiple expressions in graph Substitute variable var with
    expression expr in multiple expressions, preserving nodes.


    """
    return _casadi.graph_substitute(*args)

def bspline(*args) -> "casadi::MX":
    r"""
    bspline(MX x, DM coeffs, std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const & knots, std::vector< casadi_int,std::allocator< casadi_int > > const & degree, casadi_int m, casadi::Dict const & opts=casadi::Dict()) -> MX
    bspline(MX x, MX coeffs, std::vector< std::vector< double,std::allocator< double > >,std::allocator< std::vector< double,std::allocator< double > > > > const & knots, std::vector< casadi_int,std::allocator< casadi_int > > const & degree, casadi_int m, casadi::Dict const & opts=casadi::Dict()) -> MX


    Find first nonzero If failed, returns the number of rows.


    """
    return _casadi.bspline(*args)

def convexify(*args) -> "casadi::MX":
    r"""
    convexify(MX H, casadi::Dict const & opts=casadi::Dict()) -> MX


    Find first nonzero If failed, returns the number of rows.


    """
    return _casadi.convexify(*args)
class Importer(SharedObject, PrintableCommon):
    r"""


    Importer.

    Just-in-time compilation of code

    General information
    ===================



    List of plugins
    ===============



    - clang

    - shell

    Note: some of the plugins in this list might not be available on your
    system. Also, there might be extra plugins available to you that are not
    listed here. You can obtain their documentation with
    Importer.doc("myextraplugin")



    --------------------------------------------------------------------------------

    clang
    -----



    Interface to the JIT compiler CLANG

    >List of available options

    +--------------+-----------------+-----------------------------------------+
    |      Id      |      Type       |               Description               |
    +==============+=================+=========================================+
    | flags        | OT_STRINGVECTOR | Compile flags for the JIT compiler.     |
    |              |                 | Default: None                           |
    +--------------+-----------------+-----------------------------------------+
    | include_path | OT_STRING       | Include paths for the JIT compiler. The |
    |              |                 | include directory shipped with CasADi   |
    |              |                 | will be automatically appended.         |
    +--------------+-----------------+-----------------------------------------+

    --------------------------------------------------------------------------------



    --------------------------------------------------------------------------------

    shell
    -----



    Interface to the JIT compiler SHELL

    >List of available options

    +----------------------+-----------------+---------------------------------+
    |          Id          |      Type       |           Description           |
    +======================+=================+=================================+
    | cleanup              | OT_BOOL         | Cleanup temporary files when    |
    |                      |                 | unloading. Default: true        |
    +----------------------+-----------------+---------------------------------+
    | compiler             | OT_STRING       | Compiler command                |
    +----------------------+-----------------+---------------------------------+
    | compiler_flags       | OT_STRINGVECTOR | Alias for 'compiler_flags'      |
    +----------------------+-----------------+---------------------------------+
    | compiler_output_flag | OT_STRING       | Compiler flag to denote object  |
    |                      |                 | output. Default: '-o '          |
    +----------------------+-----------------+---------------------------------+
    | compiler_setup       | OT_STRING       | Compiler setup command.         |
    |                      |                 | Intended to be fixed. The       |
    |                      |                 | 'flag' option is the prefered   |
    |                      |                 | way to set custom flags.        |
    +----------------------+-----------------+---------------------------------+
    | extra_suffixes       | OT_STRINGVECTOR | List of suffixes for extra      |
    |                      |                 | files that the compiler may     |
    |                      |                 | generate. Default: None         |
    +----------------------+-----------------+---------------------------------+
    | flags                | OT_STRINGVECTOR | Compile flags for the JIT       |
    |                      |                 | compiler. Default: None         |
    +----------------------+-----------------+---------------------------------+
    | folder               | OT_STRING       | Folder to put temporary objects |
    |                      |                 | in.                             |
    +----------------------+-----------------+---------------------------------+
    | linker               | OT_STRING       | Linker command                  |
    +----------------------+-----------------+---------------------------------+
    | linker_flags         | OT_STRINGVECTOR | Linker flags for the JIT        |
    |                      |                 | compiler. Default: None         |
    +----------------------+-----------------+---------------------------------+
    | linker_output_flag   | OT_STRING       | Linker flag to denote shared    |
    |                      |                 | library output. Default: '-o '  |
    +----------------------+-----------------+---------------------------------+
    | linker_setup         | OT_STRING       | Linker setup command. Intended  |
    |                      |                 | to be fixed. The 'flag' option  |
    |                      |                 | is the prefered way to set      |
    |                      |                 | custom flags.                   |
    +----------------------+-----------------+---------------------------------+
    | name                 | OT_STRING       | The file name used to write out |
    |                      |                 | compiled objects/libraries. The |
    |                      |                 | actual file names used depend   |
    |                      |                 | on 'temp_suffix' and include    |
    |                      |                 | extensions. Default:            |
    |                      |                 | 'tmp_casadi_compiler_shell'     |
    +----------------------+-----------------+---------------------------------+
    | temp_suffix          | OT_BOOL         | Use a temporary (seemingly      |
    |                      |                 | random) filename suffix for     |
    |                      |                 | file names. This is desired for |
    |                      |                 | thread-safety. This behaviour   |
    |                      |                 | may defeat caching compiler     |
    |                      |                 | wrappers. Default: true         |
    +----------------------+-----------------+---------------------------------+

    --------------------------------------------------------------------------------



    Joris Gillis

    C++ includes: importer.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def type_name(*args) -> "std::string":
        r"""type_name() -> std::string"""
        return _casadi.Importer_type_name(*args)

    @staticmethod
    def test_cast(*args) -> "bool":
        r"""test_cast(casadi::SharedObjectInternal const * ptr) -> bool"""
        return _casadi.Importer_test_cast(*args)

    @staticmethod
    def has_plugin(*args) -> "bool":
        r"""has_plugin(std::string const & name) -> bool"""
        return _casadi.Importer_has_plugin(*args)

    @staticmethod
    def load_plugin(*args) -> "void":
        r"""load_plugin(std::string const & name)"""
        return _casadi.Importer_load_plugin(*args)

    @staticmethod
    def doc(*args) -> "std::string":
        r"""doc(std::string const & name) -> std::string"""
        return _casadi.Importer_doc(*args)

    def plugin_name(self, *args) -> "std::string":
        r"""
        plugin_name(Importer self) -> std::string


        Query plugin name.


        """
        return _casadi.Importer_plugin_name(self, *args)

    def has_function(self, *args) -> "bool":
        r"""has_function(Importer self, std::string const & symname) -> bool"""
        return _casadi.Importer_has_function(self, *args)

    def has_meta(self, *args) -> "bool":
        r"""
        has_meta(Importer self, std::string const & cmd, casadi_int ind=-1) -> bool


        Does a meta entry exist?


        """
        return _casadi.Importer_has_meta(self, *args)

    def get_meta(self, *args) -> "std::string":
        r"""
        get_meta(Importer self, std::string const & cmd, casadi_int ind=-1) -> std::string


        Get entry as a text.


        """
        return _casadi.Importer_get_meta(self, *args)

    def inlined(self, *args) -> "bool":
        r"""
        inlined(Importer self, std::string const & symname) -> bool


        Check if a function is inlined.


        """
        return _casadi.Importer_inlined(self, *args)

    def body(self, *args) -> "std::string":
        r"""
        body(Importer self, std::string const & symname) -> std::string


        Get the function body, if inlined.


        """
        return _casadi.Importer_body(self, *args)

    def library(self, *args) -> "std::string":
        r"""
        library(Importer self) -> std::string


        Get library name.


        """
        return _casadi.Importer_library(self, *args)

    def serialize(self, *args) -> "void":
        r"""
        serialize(Importer self, casadi::SerializingStream & s)


        Serialize an object.


        """
        return _casadi.Importer_serialize(self, *args)

    @staticmethod
    def deserialize(*args) -> "casadi::Importer":
        r"""deserialize(casadi::DeserializingStream & s) -> Importer"""
        return _casadi.Importer_deserialize(*args)

    def __init__(self, *args):
        r"""
        __init__(Importer self) -> Importer
        __init__(Importer self, std::string const & name, std::string const & compiler, casadi::Dict const & opts=casadi::Dict()) -> Importer
        __init__(Importer self, Importer other) -> Importer
        """
        _casadi.Importer_swiginit(self, _casadi.new_Importer(*args))
    __swig_destroy__ = _casadi.delete_Importer

# Register Importer in _casadi:
_casadi.Importer_swigregister(Importer)

def Importer_type_name(*args) -> "std::string":
    r"""Importer_type_name() -> std::string"""
    return _casadi.Importer_type_name(*args)

def Importer_test_cast(*args) -> "bool":
    r"""Importer_test_cast(casadi::SharedObjectInternal const * ptr) -> bool"""
    return _casadi.Importer_test_cast(*args)

def Importer_has_plugin(*args) -> "bool":
    r"""Importer_has_plugin(std::string const & name) -> bool"""
    return _casadi.Importer_has_plugin(*args)

def Importer_load_plugin(*args) -> "void":
    r"""Importer_load_plugin(std::string const & name)"""
    return _casadi.Importer_load_plugin(*args)

def Importer_doc(*args) -> "std::string":
    r"""Importer_doc(std::string const & name) -> std::string"""
    return _casadi.Importer_doc(*args)

def Importer_deserialize(*args) -> "casadi::Importer":
    r"""Importer_deserialize(casadi::DeserializingStream & s) -> Importer"""
    return _casadi.Importer_deserialize(*args)

class Callback(Function):
    r"""


    Callback function functionality.

    This class provides a public API to the FunctionInternal class that can be
    subclassed by the user, who is then able to implement the different virtual
    method. Note that the Function class also provides a public API to
    FunctionInternal, but only allows calling, not being called.

    The user is responsible for not deleting this class for the lifetime of the
    internal function object.

    Joris Gillis, Joel Andersson

    C++ includes: callback.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def type_name(*args) -> "std::string":
        r"""type_name() -> std::string"""
        return _casadi.Callback_type_name(*args)

    def __init__(self, *args):
        r"""
        __init__(Callback self) -> Callback
        __init__(Callback self, Callback obj) -> Callback


        Copy constructor (throws an error)


        """
        if self.__class__ == Callback:
            _self = None
        else:
            _self = self
        _casadi.Callback_swiginit(self, _casadi.new_Callback(_self, *args))
    __swig_destroy__ = _casadi.delete_Callback

    def construct(self, *args) -> "void":
        r"""
        construct(Callback self, std::string const & name, casadi::Dict const & opts=casadi::Dict())


        Construct internal object This is the step that actually construct the
        internal object, as the class constructor only creates a null pointer. It
        should be called from the user constructor.


        """
        return _casadi.Callback_construct(self, *args)

    def init(self, *args) -> "void":
        r"""
        init(Callback self)


        Initialize the object This function is called after the object construction
        (for the whole class hierarchy) is complete, but before the finalization
        step. It is called recursively for the whole class hierarchy, starting with
        the lowest level.


        """
        return _casadi.Callback_init(self, *args)

    def finalize(self, *args) -> "void":
        r"""
        finalize(Callback self)


        Finalize the object This function is called after the construction and init
        steps are completed, but before user functions are called. It is called
        recursively for the whole class hierarchy, starting with the highest level.


        """
        return _casadi.Callback_finalize(self, *args)

    def eval(self, *args) -> "std::vector< casadi::DM,std::allocator< casadi::DM > >":
        r"""
        eval(Callback self, std::vector< casadi::DM,std::allocator< casadi::DM > > const & arg) -> std::vector< casadi::DM,std::allocator< casadi::DM > >


        Evaluate numerically, using temporary matrices and work vectors.

        This signature is not thread-safe. For guaranteed thread-safety, use
        eval_buffer


        """
        return _casadi.Callback_eval(self, *args)

    def eval_buffer(self, *args) -> "int":
        r"""
        eval_buffer(Callback self, double const ** arg, std::vector< casadi_int,std::allocator< casadi_int > > const & sizes_arg, double ** res, std::vector< casadi_int,std::allocator< casadi_int > > const & sizes_res) -> int


        A copy-free low level interface.

        In Python, you will be passed two tuples of memoryview objects


        """
        return _casadi.Callback_eval_buffer(self, *args)

    def has_eval_buffer(self, *args) -> "bool":
        r"""has_eval_buffer(Callback self) -> bool"""
        return _casadi.Callback_has_eval_buffer(self, *args)

    def get_n_in(self, *args) -> "casadi_int":
        r"""
        get_n_in(Callback self) -> casadi_int


        Get the number of inputs This function is called during construction.


        """
        return _casadi.Callback_get_n_in(self, *args)

    def get_n_out(self, *args) -> "casadi_int":
        r"""
        get_n_out(Callback self) -> casadi_int


        Get the number of outputs This function is called during construction.


        """
        return _casadi.Callback_get_n_out(self, *args)

    def get_sparsity_in(self, *args) -> "casadi::Sparsity":
        r"""
        get_sparsity_in(Callback self, casadi_int i) -> Sparsity


        Get the sparsity of an input This function is called during construction.


        """
        return _casadi.Callback_get_sparsity_in(self, *args)

    def get_sparsity_out(self, *args) -> "casadi::Sparsity":
        r"""
        get_sparsity_out(Callback self, casadi_int i) -> Sparsity


        Get the sparsity of an output This function is called during construction.


        """
        return _casadi.Callback_get_sparsity_out(self, *args)

    def get_name_in(self, *args) -> "std::string":
        r"""
        get_name_in(Callback self, casadi_int i) -> std::string


        Get the sparsity of an input This function is called during construction.


        """
        return _casadi.Callback_get_name_in(self, *args)

    def get_name_out(self, *args) -> "std::string":
        r"""
        get_name_out(Callback self, casadi_int i) -> std::string


        Get the sparsity of an output This function is called during construction.


        """
        return _casadi.Callback_get_name_out(self, *args)

    def uses_output(self, *args) -> "bool":
        r"""
        uses_output(Callback self) -> bool


        Do the derivative functions need nondifferentiated outputs?


        """
        return _casadi.Callback_uses_output(self, *args)

    def has_jacobian(self, *args) -> "bool":
        r"""
        has_jacobian(Callback self) -> bool


        Return Jacobian of all input elements with respect to all output elements.


        """
        return _casadi.Callback_has_jacobian(self, *args)

    def get_jacobian(self, *args) -> "casadi::Function":
        r"""
        get_jacobian(Callback self, std::string const & name, std::vector< std::string,std::allocator< std::string > > const & inames, std::vector< std::string,std::allocator< std::string > > const & onames, casadi::Dict const & opts) -> Function


        Return Jacobian of all input elements with respect to all output elements.


        """
        return _casadi.Callback_get_jacobian(self, *args)

    def has_forward(self, *args) -> "bool":
        r"""
        has_forward(Callback self, casadi_int nfwd) -> bool


        Return function that calculates forward derivatives forward(nfwd) returns a
        cached instance if available, and calls  Function get_forward(casadi_int
        nfwd) if no cached version is available.


        """
        return _casadi.Callback_has_forward(self, *args)

    def get_forward(self, *args) -> "casadi::Function":
        r"""
        get_forward(Callback self, casadi_int nfwd, std::string const & name, std::vector< std::string,std::allocator< std::string > > const & inames, std::vector< std::string,std::allocator< std::string > > const & onames, casadi::Dict const & opts) -> Function


        Return function that calculates forward derivatives forward(nfwd) returns a
        cached instance if available, and calls  Function get_forward(casadi_int
        nfwd) if no cached version is available.


        """
        return _casadi.Callback_get_forward(self, *args)

    def has_reverse(self, *args) -> "bool":
        r"""
        has_reverse(Callback self, casadi_int nadj) -> bool


        Return function that calculates adjoint derivatives reverse(nadj) returns a
        cached instance if available, and calls  Function get_reverse(casadi_int
        nadj) if no cached version is available.


        """
        return _casadi.Callback_has_reverse(self, *args)

    def get_reverse(self, *args) -> "casadi::Function":
        r"""
        get_reverse(Callback self, casadi_int nadj, std::string const & name, std::vector< std::string,std::allocator< std::string > > const & inames, std::vector< std::string,std::allocator< std::string > > const & onames, casadi::Dict const & opts) -> Function


        Return function that calculates adjoint derivatives reverse(nadj) returns a
        cached instance if available, and calls  Function get_reverse(casadi_int
        nadj) if no cached version is available.


        """
        return _casadi.Callback_get_reverse(self, *args)

    def has_jacobian_sparsity(self, *args) -> "bool":
        r"""
        has_jacobian_sparsity(Callback self) -> bool


        Return sparsity of Jacobian of all input elements with respect to all output
        elements.


        """
        return _casadi.Callback_has_jacobian_sparsity(self, *args)

    def get_jacobian_sparsity(self, *args) -> "casadi::Sparsity":
        r"""
        get_jacobian_sparsity(Callback self) -> Sparsity


        Return sparsity of Jacobian of all input elements with respect to all output
        elements.


        """
        return _casadi.Callback_get_jacobian_sparsity(self, *args)
    def __disown__(self):
        self.this.disown()
        _casadi.disown_Callback(self)
        return weakref.proxy(self)

# Register Callback in _casadi:
_casadi.Callback_swigregister(Callback)

def Callback_type_name(*args) -> "std::string":
    r"""Callback_type_name() -> std::string"""
    return _casadi.Callback_type_name(*args)

class GlobalOptions(object):
    r"""


    Collects global CasADi options.

    Note to developers: use sparingly. Global options are - in general - a
    rather bad idea

    this class must never be instantiated. Access its static members directly
    Joris Gillis

    C++ includes: global_options.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def setSimplificationOnTheFly(*args) -> "void":
        r"""setSimplificationOnTheFly(bool flag)"""
        return _casadi.GlobalOptions_setSimplificationOnTheFly(*args)

    @staticmethod
    def getSimplificationOnTheFly(*args) -> "bool":
        r"""getSimplificationOnTheFly() -> bool"""
        return _casadi.GlobalOptions_getSimplificationOnTheFly(*args)

    @staticmethod
    def setHierarchicalSparsity(*args) -> "void":
        r"""setHierarchicalSparsity(bool flag)"""
        return _casadi.GlobalOptions_setHierarchicalSparsity(*args)

    @staticmethod
    def getHierarchicalSparsity(*args) -> "bool":
        r"""getHierarchicalSparsity() -> bool"""
        return _casadi.GlobalOptions_getHierarchicalSparsity(*args)

    @staticmethod
    def setCasadiPath(*args) -> "void":
        r"""setCasadiPath(std::string const & path)"""
        return _casadi.GlobalOptions_setCasadiPath(*args)

    @staticmethod
    def getCasadiPath(*args) -> "std::string":
        r"""getCasadiPath() -> std::string"""
        return _casadi.GlobalOptions_getCasadiPath(*args)

    @staticmethod
    def setCasadiIncludePath(*args) -> "void":
        r"""setCasadiIncludePath(std::string const & path)"""
        return _casadi.GlobalOptions_setCasadiIncludePath(*args)

    @staticmethod
    def getCasadiIncludePath(*args) -> "std::string":
        r"""getCasadiIncludePath() -> std::string"""
        return _casadi.GlobalOptions_getCasadiIncludePath(*args)

    @staticmethod
    def setMaxNumDir(*args) -> "void":
        r"""setMaxNumDir(casadi_int ndir)"""
        return _casadi.GlobalOptions_setMaxNumDir(*args)

    @staticmethod
    def getMaxNumDir(*args) -> "casadi_int":
        r"""getMaxNumDir() -> casadi_int"""
        return _casadi.GlobalOptions_getMaxNumDir(*args)

    def __init__(self, *args):
        r"""__init__(GlobalOptions self, GlobalOptions other) -> GlobalOptions"""
        _casadi.GlobalOptions_swiginit(self, _casadi.new_GlobalOptions(*args))
    __swig_destroy__ = _casadi.delete_GlobalOptions

# Register GlobalOptions in _casadi:
_casadi.GlobalOptions_swigregister(GlobalOptions)

def GlobalOptions_setSimplificationOnTheFly(*args) -> "void":
    r"""GlobalOptions_setSimplificationOnTheFly(bool flag)"""
    return _casadi.GlobalOptions_setSimplificationOnTheFly(*args)

def GlobalOptions_getSimplificationOnTheFly(*args) -> "bool":
    r"""GlobalOptions_getSimplificationOnTheFly() -> bool"""
    return _casadi.GlobalOptions_getSimplificationOnTheFly(*args)

def GlobalOptions_setHierarchicalSparsity(*args) -> "void":
    r"""GlobalOptions_setHierarchicalSparsity(bool flag)"""
    return _casadi.GlobalOptions_setHierarchicalSparsity(*args)

def GlobalOptions_getHierarchicalSparsity(*args) -> "bool":
    r"""GlobalOptions_getHierarchicalSparsity() -> bool"""
    return _casadi.GlobalOptions_getHierarchicalSparsity(*args)

def GlobalOptions_setCasadiPath(*args) -> "void":
    r"""GlobalOptions_setCasadiPath(std::string const & path)"""
    return _casadi.GlobalOptions_setCasadiPath(*args)

def GlobalOptions_getCasadiPath(*args) -> "std::string":
    r"""GlobalOptions_getCasadiPath() -> std::string"""
    return _casadi.GlobalOptions_getCasadiPath(*args)

def GlobalOptions_setCasadiIncludePath(*args) -> "void":
    r"""GlobalOptions_setCasadiIncludePath(std::string const & path)"""
    return _casadi.GlobalOptions_setCasadiIncludePath(*args)

def GlobalOptions_getCasadiIncludePath(*args) -> "std::string":
    r"""GlobalOptions_getCasadiIncludePath() -> std::string"""
    return _casadi.GlobalOptions_getCasadiIncludePath(*args)

def GlobalOptions_setMaxNumDir(*args) -> "void":
    r"""GlobalOptions_setMaxNumDir(casadi_int ndir)"""
    return _casadi.GlobalOptions_setMaxNumDir(*args)

def GlobalOptions_getMaxNumDir(*args) -> "casadi_int":
    r"""GlobalOptions_getMaxNumDir() -> casadi_int"""
    return _casadi.GlobalOptions_getMaxNumDir(*args)

class CasadiMeta(object):
    r"""


    Collects global CasADi meta information.

    Joris Gillis

    C++ includes: casadi_meta.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def version(*args) -> "char const *":
        r"""version() -> char const *"""
        return _casadi.CasadiMeta_version(*args)

    @staticmethod
    def git_revision(*args) -> "char const *":
        r"""git_revision() -> char const *"""
        return _casadi.CasadiMeta_git_revision(*args)

    @staticmethod
    def git_describe(*args) -> "char const *":
        r"""git_describe() -> char const *"""
        return _casadi.CasadiMeta_git_describe(*args)

    @staticmethod
    def feature_list(*args) -> "char const *":
        r"""feature_list() -> char const *"""
        return _casadi.CasadiMeta_feature_list(*args)

    @staticmethod
    def build_type(*args) -> "char const *":
        r"""build_type() -> char const *"""
        return _casadi.CasadiMeta_build_type(*args)

    @staticmethod
    def compiler_id(*args) -> "char const *":
        r"""compiler_id() -> char const *"""
        return _casadi.CasadiMeta_compiler_id(*args)

    @staticmethod
    def compiler(*args) -> "char const *":
        r"""compiler() -> char const *"""
        return _casadi.CasadiMeta_compiler(*args)

    @staticmethod
    def compiler_flags(*args) -> "char const *":
        r"""compiler_flags() -> char const *"""
        return _casadi.CasadiMeta_compiler_flags(*args)

    @staticmethod
    def modules(*args) -> "char const *":
        r"""modules() -> char const *"""
        return _casadi.CasadiMeta_modules(*args)

    @staticmethod
    def plugins(*args) -> "char const *":
        r"""plugins() -> char const *"""
        return _casadi.CasadiMeta_plugins(*args)

    @staticmethod
    def install_prefix(*args) -> "char const *":
        r"""install_prefix() -> char const *"""
        return _casadi.CasadiMeta_install_prefix(*args)

    def __init__(self, *args):
        r"""__init__(CasadiMeta self, CasadiMeta other) -> CasadiMeta"""
        _casadi.CasadiMeta_swiginit(self, _casadi.new_CasadiMeta(*args))
    __swig_destroy__ = _casadi.delete_CasadiMeta

# Register CasadiMeta in _casadi:
_casadi.CasadiMeta_swigregister(CasadiMeta)

def CasadiMeta_version(*args) -> "char const *":
    r"""CasadiMeta_version() -> char const *"""
    return _casadi.CasadiMeta_version(*args)

def CasadiMeta_git_revision(*args) -> "char const *":
    r"""CasadiMeta_git_revision() -> char const *"""
    return _casadi.CasadiMeta_git_revision(*args)

def CasadiMeta_git_describe(*args) -> "char const *":
    r"""CasadiMeta_git_describe() -> char const *"""
    return _casadi.CasadiMeta_git_describe(*args)

def CasadiMeta_feature_list(*args) -> "char const *":
    r"""CasadiMeta_feature_list() -> char const *"""
    return _casadi.CasadiMeta_feature_list(*args)

def CasadiMeta_build_type(*args) -> "char const *":
    r"""CasadiMeta_build_type() -> char const *"""
    return _casadi.CasadiMeta_build_type(*args)

def CasadiMeta_compiler_id(*args) -> "char const *":
    r"""CasadiMeta_compiler_id() -> char const *"""
    return _casadi.CasadiMeta_compiler_id(*args)

def CasadiMeta_compiler(*args) -> "char const *":
    r"""CasadiMeta_compiler() -> char const *"""
    return _casadi.CasadiMeta_compiler(*args)

def CasadiMeta_compiler_flags(*args) -> "char const *":
    r"""CasadiMeta_compiler_flags() -> char const *"""
    return _casadi.CasadiMeta_compiler_flags(*args)

def CasadiMeta_modules(*args) -> "char const *":
    r"""CasadiMeta_modules() -> char const *"""
    return _casadi.CasadiMeta_modules(*args)

def CasadiMeta_plugins(*args) -> "char const *":
    r"""CasadiMeta_plugins() -> char const *"""
    return _casadi.CasadiMeta_plugins(*args)

def CasadiMeta_install_prefix(*args) -> "char const *":
    r"""CasadiMeta_install_prefix() -> char const *"""
    return _casadi.CasadiMeta_install_prefix(*args)


def collocation_points(*args) -> "std::vector< double,std::allocator< double > >":
    r"""
    collocation_points(casadi_int order, std::string const & scheme="radau") -> std::vector< double,std::allocator< double > >


    Obtain collocation points of specific order and scheme.

    Parameters:
    -----------

    order:  Which order (1 to 9 supported)

    scheme:  'radau' or 'legendre'


    """
    return _casadi.collocation_points(*args)

def collocation_interpolators(*args) -> "std::vector< std::vector< double > > &, std::vector< double > &":
    r"""
    collocation_interpolators(std::vector< double,std::allocator< double > > const & tau)


    Obtain collocation interpolating matrices.

    A collocation method poses a polynomial Pi that interpolates exactly through
    an initial state (0,X_0) and helper states at collocation points
    (tau_j,X(j)).

    This function computes the linear mapping between dPi/dt and coefficients
    Z=[X_0 X].

    Parameters:
    -----------

    tau:  location of collocation points, as obtained from collocation_points

    output_C:  interpolating coefficients to obtain derivatives. Length:
    order+1, order+1



    ::

    dPi/dt @Z_j = (1/h) Sum_i C[j][i]*Z_i,



    with h the length of the integration interval.

    Parameters:
    -----------

    output_D:  interpolating coefficients to obtain end state. Length: order+1



    ::

    Pi @X_f = Sum_i D[i]*Z_i




    """
    return _casadi.collocation_interpolators(*args)

def collocation_coeff(*args) -> "casadi::Matrix< double > &, casadi::Matrix< double > &, casadi::Matrix< double > &":
    r"""
    collocation_coeff(std::vector< double,std::allocator< double > > const & tau)


    Obtain collocation interpolating matrices.

    A collocation method poses a polynomial Pi that interpolates exactly through
    an initial state (0,X_0) and helper states at collocation points
    (tau_j,Xc_j) with j=1..degree.

    This function computes the linear mapping between dPi/dt and coefficients
    Z=[X_0 Xc].

    Parameters:
    -----------

    tau:  location of collocation points (length: degree), as obtained from
    collocation_points

    C:  interpolating coefficients to obtain derivatives. Size: (degree+1)-by-
    degree

    You may find the slopes of Pi at the collocation points as

    ::

    dPi/dt @ Xc = (1/h) Z*C,



    with h the length of the integration interval.

    Parameters:
    -----------

    D:  interpolating coefficients to obtain end state. Size: (degree+1)-by-1

    You may find the end point of Pi as

    ::

    Pi @X_f = Z*D



    Parameters:
    -----------

    B:  quadrature coefficients Size: degree-by-1

    Given quadrature righ-hand-sides 'quad' evaluated at the collocation points,
    you may find the integrated quadratures as

    ::

    q = quad*B*h




    """
    return _casadi.collocation_coeff(*args)
LEGENDRE = _casadi.LEGENDRE

RADAU = _casadi.RADAU


def simpleRK(*args) -> "casadi::Function":
    r"""
    simpleRK(Function f, casadi_int N=10, casadi_int order=4) -> Function


    Construct an explicit Runge-Kutta integrator The constructed function has
    three inputs, corresponding to initial state (x0), parameter (p) and
    integration time (h) and one output, corresponding to final state (xf).

    Parameters:
    -----------

    f:  ODE function with two inputs (x and p) and one output (xdot)

    N:  Number of integrator steps

    order:  Order of interpolating polynomials


    """
    return _casadi.simpleRK(*args)

def simpleIRK(*args) -> "casadi::Function":
    r"""
    simpleIRK(Function f, casadi_int N=10, casadi_int order=4, std::string const & scheme="radau", std::string const & solver="newton", casadi::Dict const & solver_options=casadi::Dict()) -> Function


    Construct an implicit Runge-Kutta integrator using a collocation scheme The
    constructed function has three inputs, corresponding to initial state (x0),
    parameter (p) and integration time (h) and one output, corresponding to
    final state (xf).

    Parameters:
    -----------

    f:  ODE function with two inputs (x and p) and one output (xdot)

    N:  Number of integrator steps

    order:  Order of interpolating polynomials

    scheme:   Collocation scheme, as excepted by collocationPoints function.

    solver:  Solver plugin

    solver_options:  Options to be passed to the solver plugin


    """
    return _casadi.simpleIRK(*args)

def simpleIntegrator(*args) -> "casadi::Function":
    r"""
    simpleIntegrator(Function f, std::string const & integrator="cvodes", casadi::Dict const & integrator_options=casadi::Dict()) -> Function


    Simplified wrapper for the Integrator class Constructs an integrator using
    the same syntax as simpleRK and simpleIRK. The constructed function has
    three inputs, corresponding to initial state (x0), parameter (p) and
    integration time (h) and one output, corresponding to final state (xf).

    Parameters:
    -----------

    f:  ODE function with two inputs (x and p) and one output (xdot)

    N:  Number of integrator steps

    order:  Order of interpolating polynomials

    scheme:   Collocation scheme, as excepted by collocationPoints function.


    """
    return _casadi.simpleIntegrator(*args)

def detect_simple_bounds(*args) -> "std::vector< casadi_int > &, casadi::MX &, casadi::MX &, casadi::Function &, casadi::Function &":
    r"""
    detect_simple_bounds(SX xX, SX p, SX g, SX lbg, SX ubg)
    detect_simple_bounds(MX xX, MX p, MX g, MX lbg, MX ubg)


    Detect simple bounds from general constraints.

    Given parametric constraints:

    ::

      *   subject to lbg(p) <= g(x,p) <= ubg(p)
      * 



    Returns an equivalent set

    ::

      *   subject to  lbg(p)(gi) <= g(x,p)(gi) <= ubg(p)(gi)
      *               lbx(p) <= x                 <= ubx(p)
      * 



    Parameters:
    -----------

    lam_forward:  (lam_g,p)->(lam_sg,lam_x)

    lam_backward:  (lam_sg,lam_x,p)->(lam_g)


    """
    return _casadi.detect_simple_bounds(*args)
class NlpBuilder(PrintableCommon):
    r"""


    A symbolic NLP representation.

    Joel Andersson

    C++ includes: nlp_builder.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    x = property(_casadi.NlpBuilder_x_get, doc=r"""x : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    f = property(_casadi.NlpBuilder_f_get, doc=r"""f : casadi::MX""")
    g = property(_casadi.NlpBuilder_g_get, doc=r"""g : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    x_lb = property(_casadi.NlpBuilder_x_lb_get, doc=r"""x_lb : std::vector<(double,std::allocator<(double)>)>""")
    x_ub = property(_casadi.NlpBuilder_x_ub_get, doc=r"""x_ub : std::vector<(double,std::allocator<(double)>)>""")
    g_lb = property(_casadi.NlpBuilder_g_lb_get, doc=r"""g_lb : std::vector<(double,std::allocator<(double)>)>""")
    g_ub = property(_casadi.NlpBuilder_g_ub_get, doc=r"""g_ub : std::vector<(double,std::allocator<(double)>)>""")
    x_init = property(_casadi.NlpBuilder_x_init_get, doc=r"""x_init : std::vector<(double,std::allocator<(double)>)>""")
    lambda_init = property(_casadi.NlpBuilder_lambda_init_get, doc=r"""lambda_init : std::vector<(double,std::allocator<(double)>)>""")
    discrete = property(_casadi.NlpBuilder_discrete_get, doc=r"""discrete : std::vector<(bool,std::allocator<(bool)>)>""")

    def import_nl(self, *args) -> "void":
        r"""
        import_nl(NlpBuilder self, std::string const & filename, casadi::Dict const & opts=casadi::Dict())


        Import an .nl file.


        """
        return _casadi.NlpBuilder_import_nl(self, *args)

    def type_name(self, *args) -> "std::string":
        r"""
        type_name(NlpBuilder self) -> std::string


        Readable name of the class.


        """
        return _casadi.NlpBuilder_type_name(self, *args)

    def disp(self, *args) -> "void":
        r"""
        disp(NlpBuilder self, bool more=False)


        Print a description of the object.


        """
        return _casadi.NlpBuilder_disp(self, *args)

    def str(self, *args) -> "std::string":
        r"""
        str(NlpBuilder self, bool more=False) -> std::string


        Get string representation.


        """
        return _casadi.NlpBuilder_str(self, *args)

    def __init__(self, *args):
        r"""
        __init__(NlpBuilder self) -> NlpBuilder
        __init__(NlpBuilder self, NlpBuilder other) -> NlpBuilder
        """
        _casadi.NlpBuilder_swiginit(self, _casadi.new_NlpBuilder(*args))
    __swig_destroy__ = _casadi.delete_NlpBuilder

# Register NlpBuilder in _casadi:
_casadi.NlpBuilder_swigregister(NlpBuilder)

CONSTANT = _casadi.CONSTANT

PARAMETER = _casadi.PARAMETER

DISCRETE = _casadi.DISCRETE

CONTINUOUS = _casadi.CONTINUOUS

INPUT = _casadi.INPUT

OUTPUT = _casadi.OUTPUT

INTERNAL = _casadi.INTERNAL

ALGEBRAIC = _casadi.ALGEBRAIC

DIFFERENTIAL = _casadi.DIFFERENTIAL

NO_ALIAS = _casadi.NO_ALIAS

ALIAS = _casadi.ALIAS

NEGATED_ALIAS = _casadi.NEGATED_ALIAS

CAT_UNKNOWN = _casadi.CAT_UNKNOWN

CAT_DERIVATIVE = _casadi.CAT_DERIVATIVE

CAT_STATE = _casadi.CAT_STATE

CAT_DEPENDENT_CONSTANT = _casadi.CAT_DEPENDENT_CONSTANT

CAT_INDEPENDENT_CONSTANT = _casadi.CAT_INDEPENDENT_CONSTANT

CAT_DEPENDENT_PARAMETER = _casadi.CAT_DEPENDENT_PARAMETER

CAT_INDEPENDENT_PARAMETER = _casadi.CAT_INDEPENDENT_PARAMETER

CAT_ALGEBRAIC = _casadi.CAT_ALGEBRAIC

class Variable(PrintableCommon):
    r"""Proxy of C++ casadi::Variable class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def name(self, *args) -> "std::string":
        r"""name(Variable self) -> std::string"""
        return _casadi.Variable_name(self, *args)
    v = property(_casadi.Variable_v_get, doc=r"""v : casadi::MX""")
    d = property(_casadi.Variable_d_get, doc=r"""d : casadi::MX""")
    nominal = property(_casadi.Variable_nominal_get, doc=r"""nominal : double""")
    start = property(_casadi.Variable_start_get, doc=r"""start : double""")
    min = property(_casadi.Variable_min_get, doc=r"""min : double""")
    max = property(_casadi.Variable_max_get, doc=r"""max : double""")
    guess = property(_casadi.Variable_guess_get, doc=r"""guess : double""")
    derivative_start = property(_casadi.Variable_derivative_start_get, doc=r"""derivative_start : double""")
    variability = property(_casadi.Variable_variability_get, doc=r"""variability : casadi::Variability""")
    causality = property(_casadi.Variable_causality_get, doc=r"""causality : casadi::Causality""")
    category = property(_casadi.Variable_category_get, doc=r"""category : casadi::Category""")
    alias = property(_casadi.Variable_alias_get, doc=r"""alias : casadi::Alias""")
    description = property(_casadi.Variable_description_get, doc=r"""description : std::string""")
    valueReference = property(_casadi.Variable_valueReference_get, doc=r"""valueReference : casadi_int""")
    unit = property(_casadi.Variable_unit_get, doc=r"""unit : std::string""")
    display_unit = property(_casadi.Variable_display_unit_get, doc=r"""display_unit : std::string""")
    free = property(_casadi.Variable_free_get, doc=r"""free : bool""")

    def type_name(self, *args) -> "std::string":
        r"""type_name(Variable self) -> std::string"""
        return _casadi.Variable_type_name(self, *args)

    def disp(self, *args) -> "void":
        r"""disp(Variable self, bool more=False)"""
        return _casadi.Variable_disp(self, *args)

    def str(self, *args) -> "std::string":
        r"""str(Variable self, bool more=False) -> std::string"""
        return _casadi.Variable_str(self, *args)

    def __init__(self, *args):
        r"""
        __init__(Variable self) -> Variable
        __init__(Variable self, std::string const & name, Sparsity sp=casadi::Sparsity::scalar()) -> Variable
        __init__(Variable self, Variable other) -> Variable
        """
        _casadi.Variable_swiginit(self, _casadi.new_Variable(*args))
    __swig_destroy__ = _casadi.delete_Variable

# Register Variable in _casadi:
_casadi.Variable_swigregister(Variable)

class DaeBuilder(PrintableCommon):
    r"""


    An initial-value problem in differential-algebraic equations.

    Independent variables:
    ======================





    ::

      t:      time




    Time-continuous variables:
    ==========================





    ::

      x:      states defined by ODE
      s:      implicitly defined states
      z:      algebraic variables
      u:      control signals
      q:      quadrature states
      y:      outputs




    Time-constant variables:
    ========================





    ::

      p:      free parameters
      d:      dependent parameters




    Dynamic constraints (imposed everywhere):
    =========================================





    ::

      ODE                    \\dot{x} ==  ode(t, x, s, z, u, p, d)
      DAE or implicit ODE:         0 ==  dae(t, x, s, z, u, p, d, sdot)
      algebraic equations:         0 ==  alg(t, x, s, z, u, p, d)
      quadrature equations:  \\dot{q} == quad(t, x, s, z, u, p, d)
      dependent parameters:        d == ddef(t, x, s, z, u, p, d)
      output equations:            y == ydef(t, x, s, z, u, p, d)




    Point constraints (imposed pointwise):
    ======================================





    ::

      Initial equations:           0 == init(t, x, s, z, u, p, d, sdot)




    Joel Andersson

    C++ includes: dae_builder.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    t = property(_casadi.DaeBuilder_t_get, doc=r"""t : casadi::MX""")
    x = property(_casadi.DaeBuilder_x_get, doc=r"""x : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    ode = property(_casadi.DaeBuilder_ode_get, doc=r"""ode : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    lam_ode = property(_casadi.DaeBuilder_lam_ode_get, doc=r"""lam_ode : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    s = property(_casadi.DaeBuilder_s_get, doc=r"""s : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    sdot = property(_casadi.DaeBuilder_sdot_get, doc=r"""sdot : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    dae = property(_casadi.DaeBuilder_dae_get, doc=r"""dae : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    lam_dae = property(_casadi.DaeBuilder_lam_dae_get, doc=r"""lam_dae : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    z = property(_casadi.DaeBuilder_z_get, doc=r"""z : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    alg = property(_casadi.DaeBuilder_alg_get, doc=r"""alg : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    lam_alg = property(_casadi.DaeBuilder_lam_alg_get, doc=r"""lam_alg : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    q = property(_casadi.DaeBuilder_q_get, doc=r"""q : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    quad = property(_casadi.DaeBuilder_quad_get, doc=r"""quad : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    lam_quad = property(_casadi.DaeBuilder_lam_quad_get, doc=r"""lam_quad : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    w = property(_casadi.DaeBuilder_w_get, doc=r"""w : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    wdef = property(_casadi.DaeBuilder_wdef_get, doc=r"""wdef : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    lam_wdef = property(_casadi.DaeBuilder_lam_wdef_get, doc=r"""lam_wdef : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    y = property(_casadi.DaeBuilder_y_get, doc=r"""y : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    ydef = property(_casadi.DaeBuilder_ydef_get, doc=r"""ydef : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    lam_ydef = property(_casadi.DaeBuilder_lam_ydef_get, doc=r"""lam_ydef : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    u = property(_casadi.DaeBuilder_u_get, doc=r"""u : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    p = property(_casadi.DaeBuilder_p_get, doc=r"""p : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    c = property(_casadi.DaeBuilder_c_get, doc=r"""c : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    cdef = property(_casadi.DaeBuilder_cdef_get, doc=r"""cdef : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    d = property(_casadi.DaeBuilder_d_get, doc=r"""d : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    ddef = property(_casadi.DaeBuilder_ddef_get, doc=r"""ddef : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    lam_ddef = property(_casadi.DaeBuilder_lam_ddef_get, doc=r"""lam_ddef : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    aux = property(_casadi.DaeBuilder_aux_get, doc=r"""aux : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")
    init = property(_casadi.DaeBuilder_init_get, doc=r"""init : std::vector<(casadi::MX,std::allocator<(casadi::MX)>)>""")

    def add_p(self, *args) -> "casadi::MX":
        r"""
        add_p(DaeBuilder self, std::string const & name=std::string(), casadi_int n=1) -> MX


        Add a new parameter


        """
        return _casadi.DaeBuilder_add_p(self, *args)

    def add_u(self, *args) -> "casadi::MX":
        r"""
        add_u(DaeBuilder self, std::string const & name=std::string(), casadi_int n=1) -> MX


        Add a new control.


        """
        return _casadi.DaeBuilder_add_u(self, *args)

    def add_x(self, *args) -> "casadi::MX":
        r"""
        add_x(DaeBuilder self, std::string const & name=std::string(), casadi_int n=1) -> MX


        Add a new differential state.


        """
        return _casadi.DaeBuilder_add_x(self, *args)

    def add_s(self, *args) -> "std::pair< casadi::MX,casadi::MX >":
        r"""
        add_s(DaeBuilder self, std::string const & name=std::string(), casadi_int n=1) -> std::pair< casadi::MX,casadi::MX >


        Add a implicit state.


        """
        return _casadi.DaeBuilder_add_s(self, *args)

    def add_z(self, *args) -> "casadi::MX":
        r"""
        add_z(DaeBuilder self, std::string const & name=std::string(), casadi_int n=1) -> MX


        Add a new algebraic variable.


        """
        return _casadi.DaeBuilder_add_z(self, *args)

    def add_q(self, *args) -> "casadi::MX":
        r"""
        add_q(DaeBuilder self, std::string const & name=std::string(), casadi_int n=1) -> MX


        Add a new quadrature state.


        """
        return _casadi.DaeBuilder_add_q(self, *args)

    def add_d(self, *args) -> "casadi::MX":
        r"""
        add_d(DaeBuilder self, std::string const & name, MX new_ddef) -> MX


        Add a new dependent parameter.


        """
        return _casadi.DaeBuilder_add_d(self, *args)

    def add_y(self, *args) -> "casadi::MX":
        r"""
        add_y(DaeBuilder self, std::string const & name, MX new_ydef) -> MX


        Add a new output.


        """
        return _casadi.DaeBuilder_add_y(self, *args)

    def add_ode(self, *args) -> "void":
        r"""
        add_ode(DaeBuilder self, std::string const & name, MX new_ode)


        Add an ordinary differential equation.


        """
        return _casadi.DaeBuilder_add_ode(self, *args)

    def add_dae(self, *args) -> "void":
        r"""
        add_dae(DaeBuilder self, std::string const & name, MX new_dae)


        Add a differential-algebraic equation.


        """
        return _casadi.DaeBuilder_add_dae(self, *args)

    def add_alg(self, *args) -> "void":
        r"""
        add_alg(DaeBuilder self, std::string const & name, MX new_alg)


        Add an algebraic equation.


        """
        return _casadi.DaeBuilder_add_alg(self, *args)

    def add_quad(self, *args) -> "void":
        r"""
        add_quad(DaeBuilder self, std::string const & name, MX new_quad)


        Add a quadrature equation.


        """
        return _casadi.DaeBuilder_add_quad(self, *args)

    def add_aux(self, *args) -> "casadi::MX":
        r"""
        add_aux(DaeBuilder self, std::string const & name=std::string(), casadi_int n=1) -> MX


        Add an auxiliary variable.


        """
        return _casadi.DaeBuilder_add_aux(self, *args)

    def sanity_check(self, *args) -> "void":
        r"""
        sanity_check(DaeBuilder self)


        Check if dimensions match.


        """
        return _casadi.DaeBuilder_sanity_check(self, *args)

    def split_dae(self, *args) -> "void":
        r"""
        split_dae(DaeBuilder self)


        Identify and separate the algebraic variables and equations in the DAE.


        """
        return _casadi.DaeBuilder_split_dae(self, *args)

    def eliminate_alg(self, *args) -> "void":
        r"""
        eliminate_alg(DaeBuilder self)


        Eliminate algebraic variables and equations transforming them into outputs.


        """
        return _casadi.DaeBuilder_eliminate_alg(self, *args)

    def make_semi_explicit(self, *args) -> "void":
        r"""
        make_semi_explicit(DaeBuilder self)


        Transform the implicit DAE to a semi-explicit DAE.


        """
        return _casadi.DaeBuilder_make_semi_explicit(self, *args)

    def make_explicit(self, *args) -> "void":
        r"""
        make_explicit(DaeBuilder self)


        Transform the implicit DAE or semi-explicit DAE into an explicit ODE.


        """
        return _casadi.DaeBuilder_make_explicit(self, *args)

    def sort_d(self, *args) -> "void":
        r"""
        sort_d(DaeBuilder self)


        Sort dependent parameters.


        """
        return _casadi.DaeBuilder_sort_d(self, *args)

    def split_d(self, *args) -> "void":
        r"""
        split_d(DaeBuilder self)


        Eliminate interdependencies amongst dependent parameters.


        """
        return _casadi.DaeBuilder_split_d(self, *args)

    def eliminate_d(self, *args) -> "void":
        r"""
        eliminate_d(DaeBuilder self)


        Eliminate dependent parameters.


        """
        return _casadi.DaeBuilder_eliminate_d(self, *args)

    def eliminate_quad(self, *args) -> "void":
        r"""
        eliminate_quad(DaeBuilder self)


        Eliminate quadrature states and turn them into ODE states.


        """
        return _casadi.DaeBuilder_eliminate_quad(self, *args)

    def sort_dae(self, *args) -> "void":
        r"""
        sort_dae(DaeBuilder self)


        Sort the DAE and implicitly defined states.


        """
        return _casadi.DaeBuilder_sort_dae(self, *args)

    def sort_alg(self, *args) -> "void":
        r"""
        sort_alg(DaeBuilder self)


        Sort the algebraic equations and algebraic states.


        """
        return _casadi.DaeBuilder_sort_alg(self, *args)

    def scale_variables(self, *args) -> "void":
        r"""
        scale_variables(DaeBuilder self)


        Scale the variables.


        """
        return _casadi.DaeBuilder_scale_variables(self, *args)

    def scale_equations(self, *args) -> "void":
        r"""
        scale_equations(DaeBuilder self)


        Scale the implicit equations.


        """
        return _casadi.DaeBuilder_scale_equations(self, *args)

    def add_fun(self, *args) -> "casadi::Function":
        r"""
        add_fun(DaeBuilder self, std::string const & name, std::vector< std::string,std::allocator< std::string > > const & arg, std::vector< std::string,std::allocator< std::string > > const & res, casadi::Dict const & opts=casadi::Dict()) -> Function
        add_fun(DaeBuilder self, Function f) -> Function
        add_fun(DaeBuilder self, std::string const & name, Importer compiler, casadi::Dict const & opts=casadi::Dict()) -> Function


        Add an external function.


        """
        return _casadi.DaeBuilder_add_fun(self, *args)

    def has_fun(self, *args) -> "bool":
        r"""
        has_fun(DaeBuilder self, std::string const & name) -> bool


        Does a particular function already exist?


        """
        return _casadi.DaeBuilder_has_fun(self, *args)

    def fun(self, *args) -> "casadi::Function":
        r"""
        fun(DaeBuilder self, std::string const & name) -> Function


        Get function by name.


        """
        return _casadi.DaeBuilder_fun(self, *args)

    def parse_fmi(self, *args) -> "void":
        r"""
        parse_fmi(DaeBuilder self, std::string const & filename)


        Import existing problem from FMI/XML


        """
        return _casadi.DaeBuilder_parse_fmi(self, *args)

    def add_lc(self, *args) -> "casadi::MX":
        r"""
        add_lc(DaeBuilder self, std::string const & name, std::vector< std::string,std::allocator< std::string > > const & f_out) -> MX


        Add a named linear combination of output expressions.


        """
        return _casadi.DaeBuilder_add_lc(self, *args)

    def create(self, *args) -> "casadi::Function":
        r"""
        create(DaeBuilder self, std::string const & fname, std::vector< std::string,std::allocator< std::string > > const & s_in, std::vector< std::string,std::allocator< std::string > > const & s_out) -> Function


        Construct a function object.


        """
        return _casadi.DaeBuilder_create(self, *args)

    def var(self, *args) -> "casadi::MX":
        r"""
        var(DaeBuilder self, std::string const & name) -> MX


        Get variable expression by name.


        """
        return _casadi.DaeBuilder_var(self, *args)

    def __call__(self, *args) -> "casadi::MX":
        r"""__call__(DaeBuilder self, std::string const & name) -> MX"""
        return _casadi.DaeBuilder___call__(self, *args)

    def der(self, *args) -> "casadi::MX":
        r"""
        der(DaeBuilder self, std::string const & name) -> MX
        der(DaeBuilder self, MX var) -> MX


        Get a derivative expression by non-differentiated expression.


        """
        return _casadi.DaeBuilder_der(self, *args)

    def nominal(self, *args) -> "std::vector< double,std::allocator< double > >":
        r"""
        nominal(DaeBuilder self, std::string const & name) -> double
        nominal(DaeBuilder self, MX var) -> std::vector< double,std::allocator< double > >


        Get the nominal value(s) by expression.


        """
        return _casadi.DaeBuilder_nominal(self, *args)

    def set_nominal(self, *args) -> "void":
        r"""
        set_nominal(DaeBuilder self, std::string const & name, double val)
        set_nominal(DaeBuilder self, MX var, std::vector< double,std::allocator< double > > const & val)


        Set the nominal value(s) by expression.


        """
        return _casadi.DaeBuilder_set_nominal(self, *args)

    def min(self, *args) -> "std::vector< double,std::allocator< double > >":
        r"""
        min(DaeBuilder self, std::string const & name, bool normalized=False) -> double
        min(DaeBuilder self, MX var, bool normalized=False) -> std::vector< double,std::allocator< double > >


        Get the lower bound(s) by expression.


        """
        return _casadi.DaeBuilder_min(self, *args)

    def set_min(self, *args) -> "void":
        r"""
        set_min(DaeBuilder self, std::string const & name, double val, bool normalized=False)
        set_min(DaeBuilder self, MX var, std::vector< double,std::allocator< double > > const & val, bool normalized=False)


        Set the lower bound(s) by expression.


        """
        return _casadi.DaeBuilder_set_min(self, *args)

    def max(self, *args) -> "std::vector< double,std::allocator< double > >":
        r"""
        max(DaeBuilder self, std::string const & name, bool normalized=False) -> double
        max(DaeBuilder self, MX var, bool normalized=False) -> std::vector< double,std::allocator< double > >


        Get the upper bound(s) by expression.


        """
        return _casadi.DaeBuilder_max(self, *args)

    def set_max(self, *args) -> "void":
        r"""
        set_max(DaeBuilder self, std::string const & name, double val, bool normalized=False)
        set_max(DaeBuilder self, MX var, std::vector< double,std::allocator< double > > const & val, bool normalized=False)


        Set the upper bound(s) by expression.


        """
        return _casadi.DaeBuilder_set_max(self, *args)

    def guess(self, *args) -> "std::vector< double,std::allocator< double > >":
        r"""
        guess(DaeBuilder self, std::string const & name, bool normalized=False) -> double
        guess(DaeBuilder self, MX var, bool normalized=False) -> std::vector< double,std::allocator< double > >


        Get the initial guess(es) by expression.


        """
        return _casadi.DaeBuilder_guess(self, *args)

    def set_guess(self, *args) -> "void":
        r"""
        set_guess(DaeBuilder self, std::string const & name, double val, bool normalized=False)
        set_guess(DaeBuilder self, MX var, std::vector< double,std::allocator< double > > const & val, bool normalized=False)


        Set the initial guess(es) by expression.


        """
        return _casadi.DaeBuilder_set_guess(self, *args)

    def start(self, *args) -> "std::vector< double,std::allocator< double > >":
        r"""
        start(DaeBuilder self, std::string const & name, bool normalized=False) -> double
        start(DaeBuilder self, MX var, bool normalized=False) -> std::vector< double,std::allocator< double > >


        Get the (optionally normalized) value(s) at time 0 by expression.


        """
        return _casadi.DaeBuilder_start(self, *args)

    def set_start(self, *args) -> "void":
        r"""
        set_start(DaeBuilder self, std::string const & name, double val, bool normalized=False)
        set_start(DaeBuilder self, MX var, std::vector< double,std::allocator< double > > const & val, bool normalized=False)


        Set the (optionally normalized) value(s) at time 0 by expression.


        """
        return _casadi.DaeBuilder_set_start(self, *args)

    def derivative_start(self, *args) -> "std::vector< double,std::allocator< double > >":
        r"""
        derivative_start(DaeBuilder self, std::string const & name, bool normalized=False) -> double
        derivative_start(DaeBuilder self, MX var, bool normalized=False) -> std::vector< double,std::allocator< double > >


        Get the (optionally normalized) derivative value(s) at time 0 by expression.


        """
        return _casadi.DaeBuilder_derivative_start(self, *args)

    def set_derivative_start(self, *args) -> "void":
        r"""
        set_derivative_start(DaeBuilder self, std::string const & name, double val, bool normalized=False)
        set_derivative_start(DaeBuilder self, MX var, std::vector< double,std::allocator< double > > const & val, bool normalized=False)


        Set the (optionally normalized) derivative value(s) at time 0 by expression.


        """
        return _casadi.DaeBuilder_set_derivative_start(self, *args)

    def unit(self, *args) -> "std::string":
        r"""
        unit(DaeBuilder self, std::string const & name) -> std::string
        unit(DaeBuilder self, MX var) -> std::string


        Get the unit given a vector of symbolic variables (all units must be
        identical)


        """
        return _casadi.DaeBuilder_unit(self, *args)

    def set_unit(self, *args) -> "void":
        r"""
        set_unit(DaeBuilder self, std::string const & name, std::string const & val)


        Set the unit for a component.


        """
        return _casadi.DaeBuilder_set_unit(self, *args)

    def type_name(self, *args) -> "std::string":
        r"""
        type_name(DaeBuilder self) -> std::string


        Readable name of the class.


        """
        return _casadi.DaeBuilder_type_name(self, *args)

    def disp(self, *args) -> "void":
        r"""
        disp(DaeBuilder self, bool more=False)


        Print representation.


        """
        return _casadi.DaeBuilder_disp(self, *args)

    def str(self, *args) -> "std::string":
        r"""
        str(DaeBuilder self, bool more=False) -> std::string


        Get string representation.


        """
        return _casadi.DaeBuilder_str(self, *args)

    def add_variable(self, *args) -> "casadi::MX":
        r"""
        add_variable(DaeBuilder self, std::string const & name, Variable var)
        add_variable(DaeBuilder self, std::string const & name, casadi_int n=1) -> MX
        add_variable(DaeBuilder self, std::string const & name, Sparsity sp) -> MX


        Add a new variable: returns corresponding symbolic expression.


        """
        return _casadi.DaeBuilder_add_variable(self, *args)

    def variable(self, *args) -> "casadi::Variable const &":
        r"""
        variable(DaeBuilder self, std::string const & name) -> Variable
        variable(DaeBuilder self, std::string const & name) -> Variable


        Access a variable by name


        """
        return _casadi.DaeBuilder_variable(self, *args)

    def __init__(self, *args):
        r"""
        __init__(DaeBuilder self) -> DaeBuilder
        __init__(DaeBuilder self, DaeBuilder other) -> DaeBuilder
        """
        _casadi.DaeBuilder_swiginit(self, _casadi.new_DaeBuilder(*args))
    __swig_destroy__ = _casadi.delete_DaeBuilder

# Register DaeBuilder in _casadi:
_casadi.DaeBuilder_swigregister(DaeBuilder)

class XmlFile(SharedObject, PrintableCommon):
    r"""


    XML parser Can be used for parsing XML files into CasADi data structures.

    Joel Andersson

    C++ includes: xml_file.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def type_name(*args) -> "std::string":
        r"""type_name() -> std::string"""
        return _casadi.XmlFile_type_name(*args)
    __swig_destroy__ = _casadi.delete_XmlFile

    @staticmethod
    def load_plugin(*args) -> "void":
        r"""load_plugin(std::string const & name)"""
        return _casadi.XmlFile_load_plugin(*args)

    @staticmethod
    def doc(*args) -> "std::string":
        r"""doc(std::string const & name) -> std::string"""
        return _casadi.XmlFile_doc(*args)

    def __init__(self, *args):
        r"""
        __init__(XmlFile self) -> XmlFile
        __init__(XmlFile self, std::string const & name) -> XmlFile
        __init__(XmlFile self, XmlFile other) -> XmlFile
        """
        _casadi.XmlFile_swiginit(self, _casadi.new_XmlFile(*args))

# Register XmlFile in _casadi:
_casadi.XmlFile_swigregister(XmlFile)

def XmlFile_type_name(*args) -> "std::string":
    r"""XmlFile_type_name() -> std::string"""
    return _casadi.XmlFile_type_name(*args)

def XmlFile_load_plugin(*args) -> "void":
    r"""XmlFile_load_plugin(std::string const & name)"""
    return _casadi.XmlFile_load_plugin(*args)

def XmlFile_doc(*args) -> "std::string":
    r"""XmlFile_doc(std::string const & name) -> std::string"""
    return _casadi.XmlFile_doc(*args)

class SerializerBase(object):
    r"""


    C++ includes: serializer.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _casadi.delete_SerializerBase

    def pack(self, *args) -> "void":
        r"""
        pack(SerializerBase self, Sparsity e)
        pack(SerializerBase self, MX e)
        pack(SerializerBase self, DM e)
        pack(SerializerBase self, SX e)
        pack(SerializerBase self, Linsol e)
        pack(SerializerBase self, Function e)
        pack(SerializerBase self, GenericType e)
        pack(SerializerBase self, casadi_int const & e)
        pack(SerializerBase self, double const & e)
        pack(SerializerBase self, std::string const & e)
        pack(SerializerBase self, std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > > const & e)
        pack(SerializerBase self, std::vector< casadi::MX,std::allocator< casadi::MX > > const & e)
        pack(SerializerBase self, std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > > const & e)
        pack(SerializerBase self, std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > > const & e)
        pack(SerializerBase self, std::vector< casadi::Linsol,std::allocator< casadi::Linsol > > const & e)
        pack(SerializerBase self, std::vector< casadi::Function,std::allocator< casadi::Function > > const & e)
        pack(SerializerBase self, std::vector< casadi::GenericType,std::allocator< casadi::GenericType > > const & e)
        pack(SerializerBase self, std::vector< casadi_int,std::allocator< casadi_int > > const & e)
        pack(SerializerBase self, std::vector< double,std::allocator< double > > const & e)
        pack(SerializerBase self, std::vector< std::string,std::allocator< std::string > > const & e)
        """
        return _casadi.SerializerBase_pack(self, *args)
    _SERIALIZED_SPARSITY = _casadi.SerializerBase__SERIALIZED_SPARSITY
    
    _SERIALIZED_MX = _casadi.SerializerBase__SERIALIZED_MX
    
    _SERIALIZED_DM = _casadi.SerializerBase__SERIALIZED_DM
    
    _SERIALIZED_SX = _casadi.SerializerBase__SERIALIZED_SX
    
    _SERIALIZED_LINSOL = _casadi.SerializerBase__SERIALIZED_LINSOL
    
    _SERIALIZED_FUNCTION = _casadi.SerializerBase__SERIALIZED_FUNCTION
    
    _SERIALIZED_GENERICTYPE = _casadi.SerializerBase__SERIALIZED_GENERICTYPE
    
    _SERIALIZED_INT = _casadi.SerializerBase__SERIALIZED_INT
    
    _SERIALIZED_DOUBLE = _casadi.SerializerBase__SERIALIZED_DOUBLE
    
    _SERIALIZED_STRING = _casadi.SerializerBase__SERIALIZED_STRING
    
    _SERIALIZED_SPARSITY_VECTOR = _casadi.SerializerBase__SERIALIZED_SPARSITY_VECTOR
    
    _SERIALIZED_MX_VECTOR = _casadi.SerializerBase__SERIALIZED_MX_VECTOR
    
    _SERIALIZED_DM_VECTOR = _casadi.SerializerBase__SERIALIZED_DM_VECTOR
    
    _SERIALIZED_SX_VECTOR = _casadi.SerializerBase__SERIALIZED_SX_VECTOR
    
    _SERIALIZED_LINSOL_VECTOR = _casadi.SerializerBase__SERIALIZED_LINSOL_VECTOR
    
    _SERIALIZED_FUNCTION_VECTOR = _casadi.SerializerBase__SERIALIZED_FUNCTION_VECTOR
    
    _SERIALIZED_GENERICTYPE_VECTOR = _casadi.SerializerBase__SERIALIZED_GENERICTYPE_VECTOR
    
    _SERIALIZED_INT_VECTOR = _casadi.SerializerBase__SERIALIZED_INT_VECTOR
    
    _SERIALIZED_DOUBLE_VECTOR = _casadi.SerializerBase__SERIALIZED_DOUBLE_VECTOR
    
    _SERIALIZED_STRING_VECTOR = _casadi.SerializerBase__SERIALIZED_STRING_VECTOR
    

    @staticmethod
    def type_to_string(*args) -> "std::string":
        r"""type_to_string(casadi::SerializerBase::SerializationType type) -> std::string"""
        return _casadi.SerializerBase_type_to_string(*args)

    def connect(self, *args) -> "void":
        r"""connect(SerializerBase self, DeserializerBase s)"""
        return _casadi.SerializerBase_connect(self, *args)

    def reset(self, *args) -> "void":
        r"""reset(SerializerBase self)"""
        return _casadi.SerializerBase_reset(self, *args)

# Register SerializerBase in _casadi:
_casadi.SerializerBase_swigregister(SerializerBase)

def SerializerBase_type_to_string(*args) -> "std::string":
    r"""SerializerBase_type_to_string(casadi::SerializerBase::SerializationType type) -> std::string"""
    return _casadi.SerializerBase_type_to_string(*args)

class DeserializerBase(object):
    r"""


    C++ includes: serializer.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _casadi.delete_DeserializerBase

    def _pop_type(self, *args) -> "casadi::SerializerBase::SerializationType":
        r"""_pop_type(DeserializerBase self) -> casadi::SerializerBase::SerializationType"""
        return _casadi.DeserializerBase__pop_type(self, *args)

    def blind_unpack_sparsity(self, *args) -> "casadi::Sparsity":
        r"""blind_unpack_sparsity(DeserializerBase self) -> Sparsity"""
        return _casadi.DeserializerBase_blind_unpack_sparsity(self, *args)

    def blind_unpack_mx(self, *args) -> "casadi::MX":
        r"""blind_unpack_mx(DeserializerBase self) -> MX"""
        return _casadi.DeserializerBase_blind_unpack_mx(self, *args)

    def blind_unpack_dm(self, *args) -> "casadi::Matrix< double >":
        r"""blind_unpack_dm(DeserializerBase self) -> DM"""
        return _casadi.DeserializerBase_blind_unpack_dm(self, *args)

    def blind_unpack_sx(self, *args) -> "casadi::Matrix< casadi::SXElem >":
        r"""blind_unpack_sx(DeserializerBase self) -> SX"""
        return _casadi.DeserializerBase_blind_unpack_sx(self, *args)

    def blind_unpack_linsol(self, *args) -> "casadi::Linsol":
        r"""blind_unpack_linsol(DeserializerBase self) -> Linsol"""
        return _casadi.DeserializerBase_blind_unpack_linsol(self, *args)

    def blind_unpack_function(self, *args) -> "casadi::Function":
        r"""blind_unpack_function(DeserializerBase self) -> Function"""
        return _casadi.DeserializerBase_blind_unpack_function(self, *args)

    def blind_unpack_generictype(self, *args) -> "casadi::GenericType":
        r"""blind_unpack_generictype(DeserializerBase self) -> GenericType"""
        return _casadi.DeserializerBase_blind_unpack_generictype(self, *args)

    def blind_unpack_int(self, *args) -> "casadi_int":
        r"""blind_unpack_int(DeserializerBase self) -> casadi_int"""
        return _casadi.DeserializerBase_blind_unpack_int(self, *args)

    def blind_unpack_double(self, *args) -> "double":
        r"""blind_unpack_double(DeserializerBase self) -> double"""
        return _casadi.DeserializerBase_blind_unpack_double(self, *args)

    def blind_unpack_string(self, *args) -> "std::string":
        r"""blind_unpack_string(DeserializerBase self) -> std::string"""
        return _casadi.DeserializerBase_blind_unpack_string(self, *args)

    def blind_unpack_sparsity_vector(self, *args) -> "std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >":
        r"""blind_unpack_sparsity_vector(DeserializerBase self) -> std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >"""
        return _casadi.DeserializerBase_blind_unpack_sparsity_vector(self, *args)

    def blind_unpack_mx_vector(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""blind_unpack_mx_vector(DeserializerBase self) -> std::vector< casadi::MX,std::allocator< casadi::MX > >"""
        return _casadi.DeserializerBase_blind_unpack_mx_vector(self, *args)

    def blind_unpack_dm_vector(self, *args) -> "std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >":
        r"""blind_unpack_dm_vector(DeserializerBase self) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >"""
        return _casadi.DeserializerBase_blind_unpack_dm_vector(self, *args)

    def blind_unpack_sx_vector(self, *args) -> "std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >":
        r"""blind_unpack_sx_vector(DeserializerBase self) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >"""
        return _casadi.DeserializerBase_blind_unpack_sx_vector(self, *args)

    def blind_unpack_linsol_vector(self, *args) -> "std::vector< casadi::Linsol,std::allocator< casadi::Linsol > >":
        r"""blind_unpack_linsol_vector(DeserializerBase self) -> std::vector< casadi::Linsol,std::allocator< casadi::Linsol > >"""
        return _casadi.DeserializerBase_blind_unpack_linsol_vector(self, *args)

    def blind_unpack_function_vector(self, *args) -> "std::vector< casadi::Function,std::allocator< casadi::Function > >":
        r"""blind_unpack_function_vector(DeserializerBase self) -> std::vector< casadi::Function,std::allocator< casadi::Function > >"""
        return _casadi.DeserializerBase_blind_unpack_function_vector(self, *args)

    def blind_unpack_generictype_vector(self, *args) -> "std::vector< casadi::GenericType,std::allocator< casadi::GenericType > >":
        r"""blind_unpack_generictype_vector(DeserializerBase self) -> std::vector< casadi::GenericType,std::allocator< casadi::GenericType > >"""
        return _casadi.DeserializerBase_blind_unpack_generictype_vector(self, *args)

    def blind_unpack_int_vector(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""blind_unpack_int_vector(DeserializerBase self) -> std::vector< casadi_int,std::allocator< casadi_int > >"""
        return _casadi.DeserializerBase_blind_unpack_int_vector(self, *args)

    def blind_unpack_double_vector(self, *args) -> "std::vector< double,std::allocator< double > >":
        r"""blind_unpack_double_vector(DeserializerBase self) -> std::vector< double,std::allocator< double > >"""
        return _casadi.DeserializerBase_blind_unpack_double_vector(self, *args)

    def blind_unpack_string_vector(self, *args) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""blind_unpack_string_vector(DeserializerBase self) -> std::vector< std::string,std::allocator< std::string > >"""
        return _casadi.DeserializerBase_blind_unpack_string_vector(self, *args)

    def unpack_sparsity(self, *args) -> "casadi::Sparsity":
        r"""unpack_sparsity(DeserializerBase self) -> Sparsity"""
        return _casadi.DeserializerBase_unpack_sparsity(self, *args)

    def unpack_mx(self, *args) -> "casadi::MX":
        r"""unpack_mx(DeserializerBase self) -> MX"""
        return _casadi.DeserializerBase_unpack_mx(self, *args)

    def unpack_dm(self, *args) -> "casadi::Matrix< double >":
        r"""unpack_dm(DeserializerBase self) -> DM"""
        return _casadi.DeserializerBase_unpack_dm(self, *args)

    def unpack_sx(self, *args) -> "casadi::Matrix< casadi::SXElem >":
        r"""unpack_sx(DeserializerBase self) -> SX"""
        return _casadi.DeserializerBase_unpack_sx(self, *args)

    def unpack_linsol(self, *args) -> "casadi::Linsol":
        r"""unpack_linsol(DeserializerBase self) -> Linsol"""
        return _casadi.DeserializerBase_unpack_linsol(self, *args)

    def unpack_function(self, *args) -> "casadi::Function":
        r"""unpack_function(DeserializerBase self) -> Function"""
        return _casadi.DeserializerBase_unpack_function(self, *args)

    def unpack_generictype(self, *args) -> "casadi::GenericType":
        r"""unpack_generictype(DeserializerBase self) -> GenericType"""
        return _casadi.DeserializerBase_unpack_generictype(self, *args)

    def unpack_int(self, *args) -> "casadi_int":
        r"""unpack_int(DeserializerBase self) -> casadi_int"""
        return _casadi.DeserializerBase_unpack_int(self, *args)

    def unpack_double(self, *args) -> "double":
        r"""unpack_double(DeserializerBase self) -> double"""
        return _casadi.DeserializerBase_unpack_double(self, *args)

    def unpack_string(self, *args) -> "std::string":
        r"""unpack_string(DeserializerBase self) -> std::string"""
        return _casadi.DeserializerBase_unpack_string(self, *args)

    def unpack_sparsity_vector(self, *args) -> "std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >":
        r"""unpack_sparsity_vector(DeserializerBase self) -> std::vector< casadi::Sparsity,std::allocator< casadi::Sparsity > >"""
        return _casadi.DeserializerBase_unpack_sparsity_vector(self, *args)

    def unpack_mx_vector(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""unpack_mx_vector(DeserializerBase self) -> std::vector< casadi::MX,std::allocator< casadi::MX > >"""
        return _casadi.DeserializerBase_unpack_mx_vector(self, *args)

    def unpack_dm_vector(self, *args) -> "std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >":
        r"""unpack_dm_vector(DeserializerBase self) -> std::vector< casadi::Matrix< double >,std::allocator< casadi::Matrix< double > > >"""
        return _casadi.DeserializerBase_unpack_dm_vector(self, *args)

    def unpack_sx_vector(self, *args) -> "std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >":
        r"""unpack_sx_vector(DeserializerBase self) -> std::vector< casadi::Matrix< casadi::SXElem >,std::allocator< casadi::Matrix< casadi::SXElem > > >"""
        return _casadi.DeserializerBase_unpack_sx_vector(self, *args)

    def unpack_linsol_vector(self, *args) -> "std::vector< casadi::Linsol,std::allocator< casadi::Linsol > >":
        r"""unpack_linsol_vector(DeserializerBase self) -> std::vector< casadi::Linsol,std::allocator< casadi::Linsol > >"""
        return _casadi.DeserializerBase_unpack_linsol_vector(self, *args)

    def unpack_function_vector(self, *args) -> "std::vector< casadi::Function,std::allocator< casadi::Function > >":
        r"""unpack_function_vector(DeserializerBase self) -> std::vector< casadi::Function,std::allocator< casadi::Function > >"""
        return _casadi.DeserializerBase_unpack_function_vector(self, *args)

    def unpack_generictype_vector(self, *args) -> "std::vector< casadi::GenericType,std::allocator< casadi::GenericType > >":
        r"""unpack_generictype_vector(DeserializerBase self) -> std::vector< casadi::GenericType,std::allocator< casadi::GenericType > >"""
        return _casadi.DeserializerBase_unpack_generictype_vector(self, *args)

    def unpack_int_vector(self, *args) -> "std::vector< casadi_int,std::allocator< casadi_int > >":
        r"""unpack_int_vector(DeserializerBase self) -> std::vector< casadi_int,std::allocator< casadi_int > >"""
        return _casadi.DeserializerBase_unpack_int_vector(self, *args)

    def unpack_double_vector(self, *args) -> "std::vector< double,std::allocator< double > >":
        r"""unpack_double_vector(DeserializerBase self) -> std::vector< double,std::allocator< double > >"""
        return _casadi.DeserializerBase_unpack_double_vector(self, *args)

    def unpack_string_vector(self, *args) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""unpack_string_vector(DeserializerBase self) -> std::vector< std::string,std::allocator< std::string > >"""
        return _casadi.DeserializerBase_unpack_string_vector(self, *args)

    def connect(self, *args) -> "void":
        r"""connect(DeserializerBase self, SerializerBase s)"""
        return _casadi.DeserializerBase_connect(self, *args)

    def reset(self, *args) -> "void":
        r"""reset(DeserializerBase self)"""
        return _casadi.DeserializerBase_reset(self, *args)

    def unpack(self):
      type = SerializerBase.type_to_string(self._pop_type())
      f = getattr(self, "blind_unpack_"+type)
      return f()


# Register DeserializerBase in _casadi:
_casadi.DeserializerBase_swigregister(DeserializerBase)

class StringSerializer(SerializerBase):
    r"""


    C++ includes: serializer.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(StringSerializer self, casadi::Dict const & opts=casadi::Dict()) -> StringSerializer"""
        _casadi.StringSerializer_swiginit(self, _casadi.new_StringSerializer(*args))
    __swig_destroy__ = _casadi.delete_StringSerializer

    def encode(self, *args) -> "std::string":
        r"""
        encode(StringSerializer self) -> std::string


        Returns a string that holds the serialized objects.

        As a side effect, this method clears the internal buffer


        """
        return _casadi.StringSerializer_encode(self, *args)

# Register StringSerializer in _casadi:
_casadi.StringSerializer_swigregister(StringSerializer)

class FileSerializer(SerializerBase):
    r"""


    C++ includes: serializer.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(FileSerializer self, std::string const & fname, casadi::Dict const & opts=casadi::Dict()) -> FileSerializer


        Advanced serialization of CasADi objects.

        StringSerializer, FileDeserializer


        """
        _casadi.FileSerializer_swiginit(self, _casadi.new_FileSerializer(*args))
    __swig_destroy__ = _casadi.delete_FileSerializer

# Register FileSerializer in _casadi:
_casadi.FileSerializer_swigregister(FileSerializer)

class StringDeserializer(DeserializerBase):
    r"""


    C++ includes: serializer.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(StringDeserializer self, std::string const & string) -> StringDeserializer


        Advanced deserialization of CasADi objects.

        StringDeserializer


        """
        _casadi.StringDeserializer_swiginit(self, _casadi.new_StringDeserializer(*args))
    __swig_destroy__ = _casadi.delete_StringDeserializer

    def decode(self, *args) -> "void":
        r"""
        decode(StringDeserializer self, std::string const & string)


        Sets the string to deserialize objects from.


        """
        return _casadi.StringDeserializer_decode(self, *args)

# Register StringDeserializer in _casadi:
_casadi.StringDeserializer_swigregister(StringDeserializer)

class FileDeserializer(DeserializerBase):
    r"""


    C++ includes: serializer.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(FileDeserializer self, std::string const & fname) -> FileDeserializer


        Advanced deserialization of CasADi objects.

        FileSerializer


        """
        _casadi.FileDeserializer_swiginit(self, _casadi.new_FileDeserializer(*args))
    __swig_destroy__ = _casadi.delete_FileDeserializer

# Register FileDeserializer in _casadi:
_casadi.FileDeserializer_swigregister(FileDeserializer)

class Opti(PrintableCommon, SharedObject):
    r"""


    A simplified interface for NLP modeling/solving.

    This class offers a view with model description facilities The API is
    guaranteed to be stable.

    Example NLP:

    ::

        opti = casadi.Opti();

        x = opti.variable();
        y = opti.variable();

        opti.minimize(  (y-x^2)^2   );
        opti.subject_to( x^2+y^2==1 );
        opti.subject_to(     x+y>=1 );

        opti.solver('ipopt');
        sol = opti.solve();

        sol.value(x)
        sol.value(y)



    Example parametric NLP:

    ::

        opti = casadi.Opti();

        x = opti.variable(2,1);
        p = opti.parameter();

        opti.minimize(  (p*x(2)-x(1)^2)^2   );
        opti.subject_to( 1<=sum(x)<=2 );

        opti.solver('ipopt');

        opti.set_value(p, 3);
        sol = opti.solve();
        sol.value(x)

        opti.set_value(p, 5);
        sol = opti.solve();
        sol.value(x)



    Joris Gillis, Erik Lambrechts, Joel Andersson

    C++ includes: optistack.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def _variable(self, *args) -> "casadi::MX":
        r"""
        _variable(Opti self, casadi_int n=1, casadi_int m=1, std::string const & attribute="full") -> MX


        Create a decision variable (symbol)

        The order of creation matters. The order will be reflected in the
        optimization problem. It is not required for decision variables to actualy
        appear in the optimization problem.

        Parameters:
        -----------

        n:  number of rows (default 1)

        m:  number of columnss (default 1)

        attribute:  'full' (default) or 'symmetric'


        """
        return _casadi.Opti__variable(self, *args)

    def _parameter(self, *args) -> "casadi::MX":
        r"""
        _parameter(Opti self, casadi_int n=1, casadi_int m=1, std::string const & attribute="full") -> MX


        Create a parameter (symbol); fixed during optimization.

        The order of creation does not matter. It is not required for parameter to
        actualy appear in the optimization problem. Parameters that do appear, must
        be given a value before the problem can be solved.

        Parameters:
        -----------

        n:  number of rows (default 1)

        m:  number of columnss (default 1)

        attribute:  'full' (default) or 'symmetric'


        """
        return _casadi.Opti__parameter(self, *args)

    def minimize(self, *args) -> "void":
        r"""
        minimize(Opti self, MX f)


        Set objective.

        Objective must be a scalar. Default objective: 0 When method is called
        multiple times, the last call takes effect


        """
        return _casadi.Opti_minimize(self, *args)

    def _subject_to(self, *args) -> "void":
        r"""
        _subject_to(Opti self, MX g)
        _subject_to(Opti self, std::vector< casadi::MX,std::allocator< casadi::MX > > const & g)
        _subject_to(Opti self)


        Clear constraints.


        """
        return _casadi.Opti__subject_to(self, *args)

    def solver(self, *args) -> "void":
        r"""
        solver(Opti self, std::string const & solver, casadi::Dict const & plugin_options=casadi::Dict(), casadi::Dict const & solver_options=casadi::Dict())


        Set a solver.

        Parameters:
        -----------

        solver:  any of the nlpsol plugins can be used here In practice, not all
        nlpsol plugins may be supported yet

        options:  passed on to nlpsol plugin No stability can be guaranteed about
        this part of the API

        options:  to be passed to nlpsol solver No stability can be guaranteed about
        this part of the API


        """
        return _casadi.Opti_solver(self, *args)

    def set_initial(self, *args) -> "void":
        r"""
        set_initial(Opti self, MX x, DM v)
        set_initial(Opti self, std::vector< casadi::MX,std::allocator< casadi::MX > > const & assignments)


        Set initial guess for decision variables

        ::

          * opti.set_initial(x, 2)
          * opti.set_initial(10*x(1), 2)
          * 




        """
        return _casadi.Opti_set_initial(self, *args)

    def set_value(self, *args) -> "void":
        r"""
        set_value(Opti self, MX x, DM v)
        set_value(Opti self, std::vector< casadi::MX,std::allocator< casadi::MX > > const & assignments)


        Set value of parameter.

        Each parameter must be given a value before 'solve' can be called


        """
        return _casadi.Opti_set_value(self, *args)

    def solve(self, *args) -> "casadi::OptiSol":
        r"""
        solve(Opti self) -> OptiSol


        Crunch the numbers; solve the problem.


        """
        return _casadi.Opti_solve(self, *args)

    def solve_limited(self, *args) -> "casadi::OptiSol":
        r"""
        solve_limited(Opti self) -> OptiSol


        Crunch the numbers; solve the problem.

        Allows the solver to return without error when an iteration or time limit is
        reached


        """
        return _casadi.Opti_solve_limited(self, *args)

    def value(self, *args) -> "casadi::native_DM":
        r"""
        value(Opti self, MX x, std::vector< casadi::MX,std::allocator< casadi::MX > > const & values=std::vector< casadi::MX >()) -> DM
        value(Opti self, DM x, std::vector< casadi::MX,std::allocator< casadi::MX > > const & values=std::vector< casadi::MX >()) -> DM
        value(Opti self, SX x, std::vector< casadi::MX,std::allocator< casadi::MX > > const & values=std::vector< casadi::MX >()) -> DM


        Obtain value of expression at the current value

        In regular mode, teh current value is the converged solution In debug mode,
        the value can be non-converged

        Parameters:
        -----------

        values:  Optional assignment expressions (e.g. x==3) to overrule the current
        value


        """
        return _casadi.Opti_value(self, *args)

    def stats(self, *args) -> "casadi::Dict":
        r"""
        stats(Opti self) -> casadi::Dict


        Get statistics.

        nlpsol stats are passed as-is. No stability can be guaranteed about this
        part of the API


        """
        return _casadi.Opti_stats(self, *args)

    def return_status(self, *args) -> "std::string":
        r"""
        return_status(Opti self) -> std::string


        Get return status of solver passed as-is from nlpsol No stability can be
        guaranteed about this part of the API.


        """
        return _casadi.Opti_return_status(self, *args)

    def initial(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""
        initial(Opti self) -> std::vector< casadi::MX,std::allocator< casadi::MX > >


        get assignment expressions for initial values


        """
        return _casadi.Opti_initial(self, *args)

    def value_variables(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""
        value_variables(Opti self) -> std::vector< casadi::MX,std::allocator< casadi::MX > >


        get assignment expressions for latest values


        """
        return _casadi.Opti_value_variables(self, *args)

    def value_parameters(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""value_parameters(Opti self) -> std::vector< casadi::MX,std::allocator< casadi::MX > >"""
        return _casadi.Opti_value_parameters(self, *args)

    def dual(self, *args) -> "casadi::MX":
        r"""
        dual(Opti self, MX m) -> MX


        get the dual variable

        m must be a constraint expression. The returned value is still a symbolic
        expression. Use value on it to obtain the numerical value.


        """
        return _casadi.Opti_dual(self, *args)

    def _nx(self, *args) -> "casadi_int":
        r"""
        _nx(Opti self) -> casadi_int


        Number of (scalarised) decision variables.


        """
        return _casadi.Opti__nx(self, *args)

    def _np(self, *args) -> "casadi_int":
        r"""
        _np(Opti self) -> casadi_int


        Number of (scalarised) parameters.


        """
        return _casadi.Opti__np(self, *args)

    def _ng(self, *args) -> "casadi_int":
        r"""
        _ng(Opti self) -> casadi_int


        Number of (scalarised) constraints.


        """
        return _casadi.Opti__ng(self, *args)

    def _x(self, *args) -> "casadi::MX":
        r"""
        _x(Opti self) -> MX


        Get all (scalarised) decision variables as a symbolic column vector.


        """
        return _casadi.Opti__x(self, *args)

    def _p(self, *args) -> "casadi::MX":
        r"""
        _p(Opti self) -> MX


        Get all (scalarised) parameters as a symbolic column vector.


        """
        return _casadi.Opti__p(self, *args)

    def _g(self, *args) -> "casadi::MX":
        r"""
        _g(Opti self) -> MX


        Get all (scalarised) constraint expressions as a column vector.


        """
        return _casadi.Opti__g(self, *args)

    def _f(self, *args) -> "casadi::MX":
        r"""
        _f(Opti self) -> MX


        Get objective expression.


        """
        return _casadi.Opti__f(self, *args)

    def _lbg(self, *args) -> "casadi::MX":
        r"""
        _lbg(Opti self) -> MX


        Get all (scalarised) bounds on constraints as a column vector.


        """
        return _casadi.Opti__lbg(self, *args)

    def _ubg(self, *args) -> "casadi::MX":
        r"""_ubg(Opti self) -> MX"""
        return _casadi.Opti__ubg(self, *args)

    def _lam_g(self, *args) -> "casadi::MX":
        r"""
        _lam_g(Opti self) -> MX


        Get all (scalarised) dual variables as a symbolic column vector.

        Useful for obtaining the Lagrange Hessian:

        ::

          * sol.value(hessian(opti.f+opti.lam_g'*opti.g,opti.x)) % MATLAB
          * sol.value(hessian(opti.f+dot(opti.lam_g,opti.g),opti.x)[0]) # Python
          * 




        """
        return _casadi.Opti__lam_g(self, *args)

    def to_function(self, *args) -> "casadi::Function":
        r"""
        to_function(Opti self, std::string const & name, std::vector< casadi::MX,std::allocator< casadi::MX > > const & args, std::vector< casadi::MX,std::allocator< casadi::MX > > const & res, casadi::Dict const & opts=casadi::Dict()) -> Function
        to_function(Opti self, std::string const & name, std::vector< casadi::MX,std::allocator< casadi::MX > > const & args, std::vector< casadi::MX,std::allocator< casadi::MX > > const & res, std::vector< std::string,std::allocator< std::string > > const & name_in, std::vector< std::string,std::allocator< std::string > > const & name_out, casadi::Dict const & opts=casadi::Dict()) -> Function
        to_function(Opti self, std::string const & name, std::map< std::string,casadi::MX,std::less< std::string >,std::allocator< std::pair< std::string const,casadi::MX > > > const & dict, std::vector< std::string,std::allocator< std::string > > const & name_in, std::vector< std::string,std::allocator< std::string > > const & name_out, casadi::Dict const & opts=casadi::Dict()) -> Function
        """
        return _casadi.Opti_to_function(self, *args)

    @staticmethod
    def bounded(*args) -> "casadi::MX":
        r"""bounded(MX lb, MX expr, MX ub) -> MX"""
        return _casadi.Opti_bounded(*args)

    def _debug(self, *args) -> "casadi::OptiAdvanced":
        r"""
        _debug(Opti self) -> OptiAdvanced


        Get a copy with advanced functionality.

        You get access to more methods, but you have no guarantees about API
        stability

        The copy is effectively a deep copy: Updating the state of the copy does not
        update the original.


        """
        return _casadi.Opti__debug(self, *args)

    def _advanced(self, *args) -> "casadi::OptiAdvanced":
        r"""
        _advanced(Opti self) -> OptiAdvanced


        Get a copy with advanced functionality.

        You get access to more methods, but you have no guarantees about API
        stability

        The copy is effectively a deep copy: Updating the state of the copy does not
        update the original.


        """
        return _casadi.Opti__advanced(self, *args)

    def copy(self, *args) -> "casadi::Opti":
        r"""
        copy(Opti self) -> Opti


        Get a copy of the.

        The copy is effectively a deep copy: Updating the state of the copy does not
        update the original.


        """
        return _casadi.Opti_copy(self, *args)

    def update_user_dict(self, *args) -> "void":
        r"""
        update_user_dict(Opti self, MX m, casadi::Dict const & meta)
        update_user_dict(Opti self, std::vector< casadi::MX,std::allocator< casadi::MX > > const & m, casadi::Dict const & meta)
        """
        return _casadi.Opti_update_user_dict(self, *args)

    def user_dict(self, *args) -> "casadi::Dict":
        r"""
        user_dict(Opti self, MX m) -> casadi::Dict


        Get user data.


        """
        return _casadi.Opti_user_dict(self, *args)

    def type_name(self, *args) -> "std::string":
        r"""
        type_name(Opti self) -> std::string


        Readable name of the class.


        """
        return _casadi.Opti_type_name(self, *args)

    def disp(self, *args) -> "void":
        r"""
        disp(Opti self, bool more=False)


        Print representation.


        """
        return _casadi.Opti_disp(self, *args)

    def str(self, *args) -> "std::string":
        r"""
        str(Opti self, bool more=False) -> std::string


        Get string representation.


        """
        return _casadi.Opti_str(self, *args)

    def callback_class(self, *args) -> "void":
        r"""
        callback_class(Opti self, OptiCallback callback)
        callback_class(Opti self)


        Helper methods for callback()

        Do not use directly.


        """
        return _casadi.Opti_callback_class(self, *args)

    @property
    def debug(self):
      return self._debug()


    @property
    def advanced(self):
      return self._advanced()


    @property
    def f(self):
      return self._f()


    @property
    def g(self):
      return self._g()


    @property
    def x(self):
      return self._x()


    @property
    def p(self):
      return self._p()


    @property
    def lam_g(self):
      return self._lam_g()


    @property
    def lbg(self):
      return self._lbg()


    @property
    def ubg(self):
      return self._ubg()


    @property
    def nx(self):
      return self._nx()


    @property
    def np(self):
      return self._np()


    @property
    def ng(self):
      return self._ng()


    @property
    def casadi_solver(self):
      return self._casadi_solver()


    def parameter(self,*args):
      import sys
      import os
      frame = sys._getframe(1)
      meta = {"stacktrace": {"file":os.path.abspath(frame.f_code.co_filename),"line":frame.f_lineno,"name":frame.f_code.co_name}}
      ret = self._parameter(*args)
      self.update_user_dict(ret, meta)
      return ret

    def variable(self,*args):
      import sys
      import os
      frame = sys._getframe(1)
      meta = {"stacktrace": {"file":os.path.abspath(frame.f_code.co_filename),"line":frame.f_lineno,"name":frame.f_code.co_name}}
      ret = self._variable(*args)
      self.update_user_dict(ret, meta)
      return ret

    def subject_to(self,*args):
      if len(args)==0:
        return self._subject_to()
      import sys
      import os
      frame = sys._getframe(1)
      meta = {"stacktrace": {"file":os.path.abspath(frame.f_code.co_filename),"line":frame.f_lineno,"name":frame.f_code.co_name}}
      ret = self._subject_to(*args)
      self.update_user_dict(args[0], meta)
      return ret



    @staticmethod
    def _callback(self,fh=None):
      if fh is None:
        self.callback_class();
        return
      class OptiCallbackHelper(OptiCallback):
          def __init__(self, callback):
            OptiCallback.__init__(self)
            self.callback = callback

          def call(self, i):
            self.callback(i)

      self._fh = fh
      self._cb = OptiCallbackHelper(fh);
      self.callback_class(self._cb);


    def callback(self,fh=None):
      self._callback(self,fh)




    def __init__(self, *args):
        r"""
        __init__(Opti self, std::string const & problem_type="nlp") -> Opti
        __init__(Opti self, Opti other) -> Opti
        """
        _casadi.Opti_swiginit(self, _casadi.new_Opti(*args))
    __swig_destroy__ = _casadi.delete_Opti

# Register Opti in _casadi:
_casadi.Opti_swigregister(Opti)

def Opti_bounded(*args) -> "casadi::MX":
    r"""Opti_bounded(MX lb, MX expr, MX ub) -> MX"""
    return _casadi.Opti_bounded(*args)

OPTI_GENERIC_EQUALITY = _casadi.OPTI_GENERIC_EQUALITY

OPTI_GENERIC_INEQUALITY = _casadi.OPTI_GENERIC_INEQUALITY

OPTI_EQUALITY = _casadi.OPTI_EQUALITY

OPTI_INEQUALITY = _casadi.OPTI_INEQUALITY

OPTI_DOUBLE_INEQUALITY = _casadi.OPTI_DOUBLE_INEQUALITY

OPTI_PSD = _casadi.OPTI_PSD

OPTI_UNKNOWN = _casadi.OPTI_UNKNOWN

OPTI_VAR = _casadi.OPTI_VAR

OPTI_PAR = _casadi.OPTI_PAR

OPTI_DUAL_G = _casadi.OPTI_DUAL_G

class IndexAbstraction(object):
    r"""Proxy of C++ casadi::IndexAbstraction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    start = property(_casadi.IndexAbstraction_start_get, doc=r"""start : casadi_int""")
    stop = property(_casadi.IndexAbstraction_stop_get, doc=r"""stop : casadi_int""")

    def __init__(self, *args):
        r"""
        __init__(IndexAbstraction self) -> IndexAbstraction
        __init__(IndexAbstraction self, IndexAbstraction other) -> IndexAbstraction
        """
        _casadi.IndexAbstraction_swiginit(self, _casadi.new_IndexAbstraction(*args))
    __swig_destroy__ = _casadi.delete_IndexAbstraction

# Register IndexAbstraction in _casadi:
_casadi.IndexAbstraction_swigregister(IndexAbstraction)

class MetaCon(IndexAbstraction):
    r"""Proxy of C++ casadi::MetaCon class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    original = property(_casadi.MetaCon_original_get, doc=r"""original : casadi::MX""")
    canon = property(_casadi.MetaCon_canon_get, doc=r"""canon : casadi::MX""")
    type = property(_casadi.MetaCon_type_get, doc=r"""type : casadi::ConstraintType""")
    lb = property(_casadi.MetaCon_lb_get, doc=r"""lb : casadi::MX""")
    ub = property(_casadi.MetaCon_ub_get, doc=r"""ub : casadi::MX""")
    n = property(_casadi.MetaCon_n_get, doc=r"""n : casadi_int""")
    flipped = property(_casadi.MetaCon_flipped_get, doc=r"""flipped : bool""")
    dual_canon = property(_casadi.MetaCon_dual_canon_get, doc=r"""dual_canon : casadi::MX""")
    dual = property(_casadi.MetaCon_dual_get, doc=r"""dual : casadi::MX""")
    extra = property(_casadi.MetaCon_extra_get, doc=r"""extra : casadi::Dict""")

    def __init__(self, *args):
        r"""
        __init__(MetaCon self) -> MetaCon
        __init__(MetaCon self, MetaCon other) -> MetaCon
        """
        _casadi.MetaCon_swiginit(self, _casadi.new_MetaCon(*args))
    __swig_destroy__ = _casadi.delete_MetaCon

# Register MetaCon in _casadi:
_casadi.MetaCon_swigregister(MetaCon)

class MetaVar(IndexAbstraction):
    r"""Proxy of C++ casadi::MetaVar class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    attribute = property(_casadi.MetaVar_attribute_get, doc=r"""attribute : std::string""")
    n = property(_casadi.MetaVar_n_get, doc=r"""n : casadi_int""")
    m = property(_casadi.MetaVar_m_get, doc=r"""m : casadi_int""")
    type = property(_casadi.MetaVar_type_get, doc=r"""type : casadi::VariableType""")
    count = property(_casadi.MetaVar_count_get, doc=r"""count : casadi_int""")
    i = property(_casadi.MetaVar_i_get, doc=r"""i : casadi_int""")
    active_i = property(_casadi.MetaVar_active_i_get, doc=r"""active_i : casadi_int""")
    extra = property(_casadi.MetaVar_extra_get, doc=r"""extra : casadi::Dict""")

    def __init__(self, *args):
        r"""
        __init__(MetaVar self) -> MetaVar
        __init__(MetaVar self, MetaVar other) -> MetaVar
        """
        _casadi.MetaVar_swiginit(self, _casadi.new_MetaVar(*args))
    __swig_destroy__ = _casadi.delete_MetaVar

# Register MetaVar in _casadi:
_casadi.MetaVar_swigregister(MetaVar)

class OptiCallback(object):
    r"""


    C++ includes: optistack.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(OptiCallback self) -> OptiCallback
        __init__(OptiCallback self, OptiCallback obj) -> OptiCallback
        """
        if self.__class__ == OptiCallback:
            _self = None
        else:
            _self = self
        _casadi.OptiCallback_swiginit(self, _casadi.new_OptiCallback(_self, *args))

    def call(self, *args) -> "void":
        r"""call(OptiCallback self, casadi_int i)"""
        return _casadi.OptiCallback_call(self, *args)
    __swig_destroy__ = _casadi.delete_OptiCallback
    def __disown__(self):
        self.this.disown()
        _casadi.disown_OptiCallback(self)
        return weakref.proxy(self)

# Register OptiCallback in _casadi:
_casadi.OptiCallback_swigregister(OptiCallback)

class OptiAdvanced(Opti):
    r"""


    C++ includes: optistack.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _casadi.delete_OptiAdvanced

    def _casadi_solver(self, *args) -> "casadi::Function":
        r"""
        _casadi_solver(OptiAdvanced self) -> Function


        Get the underlying CasADi solver of the Opti stack.


        """
        return _casadi.OptiAdvanced__casadi_solver(self, *args)

    def is_parametric(self, *args) -> "bool":
        r"""
        is_parametric(OptiAdvanced self, MX expr) -> bool


        return true if expression is only dependant on Opti parameters, not
        variables


        """
        return _casadi.OptiAdvanced_is_parametric(self, *args)

    def symvar(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""
        symvar(OptiAdvanced self) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
        symvar(OptiAdvanced self, MX expr) -> std::vector< casadi::MX,std::allocator< casadi::MX > >
        symvar(OptiAdvanced self, MX expr, casadi::VariableType type) -> std::vector< casadi::MX,std::allocator< casadi::MX > >


        Get symbols present in expression.

        Returned vector is ordered according to the order of variable()/parameter()
        calls used to create the variables


        """
        return _casadi.OptiAdvanced_symvar(self, *args)

    def canon_expr(self, *args) -> "casadi::MetaCon":
        r"""
        canon_expr(OptiAdvanced self, MX expr) -> MetaCon


        Interpret an expression (for internal use only)


        """
        return _casadi.OptiAdvanced_canon_expr(self, *args)

    def get_meta(self, *args) -> "casadi::MetaVar":
        r"""
        get_meta(OptiAdvanced self, MX m) -> MetaVar


        Get meta-data of symbol (for internal use only)


        """
        return _casadi.OptiAdvanced_get_meta(self, *args)

    def get_meta_con(self, *args) -> "casadi::MetaCon":
        r"""
        get_meta_con(OptiAdvanced self, MX m) -> MetaCon


        Get meta-data of symbol (for internal use only)


        """
        return _casadi.OptiAdvanced_get_meta_con(self, *args)

    def set_meta(self, *args) -> "void":
        r"""
        set_meta(OptiAdvanced self, MX m, MetaVar meta)


        Set meta-data of an expression.


        """
        return _casadi.OptiAdvanced_set_meta(self, *args)

    def set_meta_con(self, *args) -> "void":
        r"""
        set_meta_con(OptiAdvanced self, MX m, MetaCon meta)


        Set meta-data of an expression.


        """
        return _casadi.OptiAdvanced_set_meta_con(self, *args)

    def assert_active_symbol(self, *args) -> "void":
        r"""assert_active_symbol(OptiAdvanced self, MX m)"""
        return _casadi.OptiAdvanced_assert_active_symbol(self, *args)

    def active_symvar(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""active_symvar(OptiAdvanced self, casadi::VariableType type) -> std::vector< casadi::MX,std::allocator< casadi::MX > >"""
        return _casadi.OptiAdvanced_active_symvar(self, *args)

    def active_values(self, *args) -> "std::vector< casadi::DM,std::allocator< casadi::DM > >":
        r"""active_values(OptiAdvanced self, casadi::VariableType type) -> std::vector< casadi::DM,std::allocator< casadi::DM > >"""
        return _casadi.OptiAdvanced_active_values(self, *args)

    def x_lookup(self, *args) -> "casadi::MX":
        r"""x_lookup(OptiAdvanced self, casadi_index i) -> MX"""
        return _casadi.OptiAdvanced_x_lookup(self, *args)

    def g_lookup(self, *args) -> "casadi::MX":
        r"""g_lookup(OptiAdvanced self, casadi_index i) -> MX"""
        return _casadi.OptiAdvanced_g_lookup(self, *args)

    def x_describe(self, *args) -> "std::string":
        r"""x_describe(OptiAdvanced self, casadi_index i) -> std::string"""
        return _casadi.OptiAdvanced_x_describe(self, *args)

    def g_describe(self, *args) -> "std::string":
        r"""g_describe(OptiAdvanced self, casadi_index i) -> std::string"""
        return _casadi.OptiAdvanced_g_describe(self, *args)

    def describe(self, *args) -> "std::string":
        r"""describe(OptiAdvanced self, MX x, casadi_index indent=0) -> std::string"""
        return _casadi.OptiAdvanced_describe(self, *args)

    def show_infeasibilities(self, *args) -> "void":
        r"""show_infeasibilities(OptiAdvanced self, double tol=0)"""
        return _casadi.OptiAdvanced_show_infeasibilities(self, *args)

    def solve_prepare(self, *args) -> "void":
        r"""solve_prepare(OptiAdvanced self)"""
        return _casadi.OptiAdvanced_solve_prepare(self, *args)

    def solve_actual(self, *args) -> "casadi::DMDict":
        r"""solve_actual(OptiAdvanced self, casadi::DMDict const & args) -> casadi::DMDict"""
        return _casadi.OptiAdvanced_solve_actual(self, *args)

    def arg(self, *args) -> "casadi::DMDict":
        r"""arg(OptiAdvanced self) -> casadi::DMDict"""
        return _casadi.OptiAdvanced_arg(self, *args)

    def res(self, *args) -> "casadi::DMDict":
        r"""
        res(OptiAdvanced self, casadi::DMDict const & res)
        res(OptiAdvanced self) -> casadi::DMDict
        """
        return _casadi.OptiAdvanced_res(self, *args)

    def constraints(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""constraints(OptiAdvanced self) -> std::vector< casadi::MX,std::allocator< casadi::MX > >"""
        return _casadi.OptiAdvanced_constraints(self, *args)

    def objective(self, *args) -> "casadi::MX":
        r"""objective(OptiAdvanced self) -> MX"""
        return _casadi.OptiAdvanced_objective(self, *args)

    def baked_copy(self, *args) -> "casadi::OptiAdvanced":
        r"""baked_copy(OptiAdvanced self) -> OptiAdvanced"""
        return _casadi.OptiAdvanced_baked_copy(self, *args)

    def assert_empty(self, *args) -> "void":
        r"""assert_empty(OptiAdvanced self)"""
        return _casadi.OptiAdvanced_assert_empty(self, *args)

    def bake(self, *args) -> "void":
        r"""
        bake(OptiAdvanced self)


        Fix the structure of the optimization problem.


        """
        return _casadi.OptiAdvanced_bake(self, *args)
    problem_dirty_ = property(_casadi.OptiAdvanced_problem_dirty__get, doc=r"""problem_dirty_ : bool""")

    def mark_problem_dirty(self, *args) -> "void":
        r"""mark_problem_dirty(OptiAdvanced self, bool flag=True)"""
        return _casadi.OptiAdvanced_mark_problem_dirty(self, *args)

    def problem_dirty(self, *args) -> "bool":
        r"""problem_dirty(OptiAdvanced self) -> bool"""
        return _casadi.OptiAdvanced_problem_dirty(self, *args)
    solver_dirty_ = property(_casadi.OptiAdvanced_solver_dirty__get, doc=r"""solver_dirty_ : bool""")

    def mark_solver_dirty(self, *args) -> "void":
        r"""mark_solver_dirty(OptiAdvanced self, bool flag=True)"""
        return _casadi.OptiAdvanced_mark_solver_dirty(self, *args)

    def solver_dirty(self, *args) -> "bool":
        r"""solver_dirty(OptiAdvanced self) -> bool"""
        return _casadi.OptiAdvanced_solver_dirty(self, *args)
    solved_ = property(_casadi.OptiAdvanced_solved__get, doc=r"""solved_ : bool""")

    def mark_solved(self, *args) -> "void":
        r"""mark_solved(OptiAdvanced self, bool flag=True)"""
        return _casadi.OptiAdvanced_mark_solved(self, *args)

    def solved(self, *args) -> "bool":
        r"""solved(OptiAdvanced self) -> bool"""
        return _casadi.OptiAdvanced_solved(self, *args)

    def assert_solved(self, *args) -> "void":
        r"""assert_solved(OptiAdvanced self)"""
        return _casadi.OptiAdvanced_assert_solved(self, *args)

    def assert_baked(self, *args) -> "void":
        r"""assert_baked(OptiAdvanced self)"""
        return _casadi.OptiAdvanced_assert_baked(self, *args)

    def instance_number(self, *args) -> "casadi_int":
        r"""instance_number(OptiAdvanced self) -> casadi_int"""
        return _casadi.OptiAdvanced_instance_number(self, *args)

    def __init__(self, *args):
        r"""
        __init__(OptiAdvanced self, Opti x) -> OptiAdvanced
        __init__(OptiAdvanced self, OptiAdvanced other) -> OptiAdvanced
        """
        _casadi.OptiAdvanced_swiginit(self, _casadi.new_OptiAdvanced(*args))

# Register OptiAdvanced in _casadi:
_casadi.OptiAdvanced_swigregister(OptiAdvanced)

class OptiSol(PrintableCommon):
    r"""


    A simplified interface for NLP modeling/solving.

    This class offers a view with solution retrieval facilities The API is
    guaranteed to be stable.

    Joris Gillis, Erik Lambrechts

    C++ includes: optistack.hpp 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def type_name(self, *args) -> "std::string":
        r"""type_name(OptiSol self) -> std::string"""
        return _casadi.OptiSol_type_name(self, *args)

    def disp(self, *args) -> "void":
        r"""disp(OptiSol self, bool more=False)"""
        return _casadi.OptiSol_disp(self, *args)

    def str(self, *args) -> "std::string":
        r"""str(OptiSol self, bool more=False) -> std::string"""
        return _casadi.OptiSol_str(self, *args)

    def value(self, *args) -> "casadi::native_DM":
        r"""
        value(OptiSol self, MX x, std::vector< casadi::MX,std::allocator< casadi::MX > > const & values=std::vector< casadi::MX >()) -> DM
        value(OptiSol self, DM x, std::vector< casadi::MX,std::allocator< casadi::MX > > const & values=std::vector< casadi::MX >()) -> DM
        value(OptiSol self, SX x, std::vector< casadi::MX,std::allocator< casadi::MX > > const & values=std::vector< casadi::MX >()) -> DM


        Obtain value of expression at the current value

        In regular mode, teh current value is the converged solution In debug mode,
        the value can be non-converged

        Parameters:
        -----------

        values:  Optional assignment expressions (e.g. x==3) to overrule the current
        value


        """
        return _casadi.OptiSol_value(self, *args)

    def value_variables(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""
        value_variables(OptiSol self) -> std::vector< casadi::MX,std::allocator< casadi::MX > >


        get assignment expressions for the optimal solution


        """
        return _casadi.OptiSol_value_variables(self, *args)

    def value_parameters(self, *args) -> "std::vector< casadi::MX,std::allocator< casadi::MX > >":
        r"""value_parameters(OptiSol self) -> std::vector< casadi::MX,std::allocator< casadi::MX > >"""
        return _casadi.OptiSol_value_parameters(self, *args)

    def stats(self, *args) -> "casadi::Dict":
        r"""
        stats(OptiSol self) -> casadi::Dict


        Get statistics.

        nlpsol stats are passed as-is. No stability can be guaranteed about this
        part of the API


        """
        return _casadi.OptiSol_stats(self, *args)

    def _opti(self, *args) -> "casadi::Opti":
        r"""_opti(OptiSol self) -> Opti"""
        return _casadi.OptiSol__opti(self, *args)

    @property
    def opti(self):
      return self._opti()


    @property
    def debug(self):
      return self._debug()


    def __init__(self, *args):
        r"""__init__(OptiSol self, OptiSol other) -> OptiSol"""
        _casadi.OptiSol_swiginit(self, _casadi.new_OptiSol(*args))
    __swig_destroy__ = _casadi.delete_OptiSol

# Register OptiSol in _casadi:
_casadi.OptiSol_swigregister(OptiSol)



