# CaImAn Code of Conduct (CCoC)

## Intent

We have expectations for behavior for participation in the CaImAn project in ways that respect both individual expression and community needs (including individual safety). This CoC is meant to be interpreted and applied according to a reasonable person standard.

## Scope

Covered behavior covers:
* Technical participation in our codebase (git commit messages)
* Official channels (Slack, Gitter)
* Participation in conferences and hackathons during on-conference time
Behavior outside these bounds is not restricted by this CoC. 

## Principles

We believe in:
* Honesty
* Fairness
* Deferring to law enforcement and aiding them in discovering the truth should any accusations possibly amount to a criminal or tort claim
* Due process (similar to our courts)
* Marking topics as out-of-bounds instead of marking perspectives as out-of-bounds
* Not letting long contributions to the project create leniency for egregious behaviour
* Not allowing friendships that may emerge from co-participation in the project lead us to belief that a participant must be innocent (in terms of contested claims)
* Not being spiteful if we are asked to change our behavior or leave - if as individuals we find ourselves incompatible with the CoC or judgement made under it, we pledge to leave without using our technical privileges or words to damage the project.

## Remedies

People violating acceptable behavior standards as covered by this CoC may be reminded, asked to refrain from certain behavior, or asked to leave the community temporarily or permanently, proportional to how unreasonable their behavior is.

## Types of problem behavior

There are two types of behavior that we wish to regulate.

First, much behavior that may make some reasonable people uncomfortable and others may object to. For this, we believe people should be able to opt-out from the behavior (including broad topics of conversation on potentially difficult matters, such as matters of race, religion, sex, other protected characteristics, as well as anything else unrelated to the project (such as politics), or unwanted social attention. When one participant makes it clear that they do not wish to take part in these conversations, others should cease to attempt to engage them in those ways. These topics are not banned, but people must be able to opt-out.

Second, some behavior is egregious enough that people should not see it in the context of our project (as understood by broad societal norms). This includes stalking, asking questions of a highly personal nature, doxxing or otherwise sharing private content. Behavior of this kind does not require the injured parties to file a complaint - anyone who is aware of this happening in the context of our project should inform a community leader of their choice to have it dealt with. Much of this behavior is already illegal.

## Process

People who feel that they have been ignored when trying to close a topic or otherwise uncomfortable interactions, or people who feel they have been targeted by egregious behavior that should not be permitted, should contact any of the project organizers. If the claim is not against any of the project organizers, available organizers should confer in the spirit of fairness and due process, investigate as they see fit (including discussing things with the accused), and apply any remedies that they choose. If an organizer is accused, other organizers should confer and apply the same process. Organizers should recuse if they think they cannot be fair.
