import btk
import unittest
import _TDDConfigure

class VerticalGroundReactionForceGaitEventDetectorTest(unittest.TestCase):
  def test_NoWrench(self):
    vgrfged = btk.btkVerticalGroundReactionForceGaitEventDetector()
    output = vgrfged.GetOutput()
    output.Update()
    self.assertEqual(output.GetItemNumber(), 0)
  
  def test_Gait(self):
    reader = btk.btkAcquisitionFileReader()
    reader.SetFilename(_TDDConfigure.C3DFilePathIN + "others/Gait.c3d")
    reader.Update()
    pfe = btk.btkForcePlatformsExtractor()
    grwf = btk.btkGroundReactionWrenchFilter()
    dswc = btk.btkWrenchCollectionDownsampleFilter()
    dswc.SetUpDownRatio(reader.GetOutput().GetNumberAnalogSamplePerFrame())
    pfe.SetInput(reader.GetOutput())
    grwf.SetInput(pfe.GetOutput())
    dswc.SetInput(grwf.GetOutput())
    vgrfged = btk.btkVerticalGroundReactionForceGaitEventDetector()
    vgrfged.SetInput(dswc.GetOutput())
    vgrfged.SetForceplateContextMapping(["Left", "Right"])
    vgrfged.SetAcquisitionInformation(reader.GetOutput().GetFirstFrame(), reader.GetOutput().GetPointFrequency(), "")
    output = vgrfged.GetOutput()
    output.Update()
    self.assertEqual(output.GetItemNumber(), 4)
    ev = output.GetItem(0)
    self.assertEqual(ev.GetLabel(), "Foot Strike")
    self.assertEqual(ev.GetContext(), "Left")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 1)
    self.assertEqual(ev.GetFrame(), 257)
    self.assertEqual(ev.GetTime(), 2.57)
    ev = output.GetItem(1)
    self.assertEqual(ev.GetLabel(), "Foot Off")
    self.assertEqual(ev.GetContext(), "Left")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 2)
    self.assertEqual(ev.GetFrame(), 316)
    self.assertEqual(ev.GetTime(), 3.16)
    ev = output.GetItem(2)
    self.assertEqual(ev.GetLabel(), "Foot Strike")
    self.assertEqual(ev.GetContext(), "Right")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 1)
    self.assertEqual(ev.GetFrame(), 209)
    self.assertEqual(ev.GetTime(), 2.09)
    ev = output.GetItem(3)
    self.assertEqual(ev.GetLabel(), "Foot Off")
    self.assertEqual(ev.GetContext(), "Right")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 2)
    self.assertEqual(ev.GetFrame(), 267)
    self.assertEqual(ev.GetTime(), 2.67)
  
  def test_Gait_NoMapping(self):
    reader = btk.btkAcquisitionFileReader()
    reader.SetFilename(_TDDConfigure.C3DFilePathIN + "others/Gait.c3d")
    reader.Update()
    pfe = btk.btkForcePlatformsExtractor()
    grwf = btk.btkGroundReactionWrenchFilter()
    dswc = btk.btkWrenchCollectionDownsampleFilter()
    dswc.SetUpDownRatio(reader.GetOutput().GetNumberAnalogSamplePerFrame())
    pfe.SetInput(reader.GetOutput())
    grwf.SetInput(pfe.GetOutput())
    dswc.SetInput(grwf.GetOutput())
    vgrfged = btk.btkVerticalGroundReactionForceGaitEventDetector()
    vgrfged.SetInput(dswc.GetOutput())
    vgrfged.SetAcquisitionInformation(reader.GetOutput().GetFirstFrame(), reader.GetOutput().GetPointFrequency(), "")
    output = vgrfged.GetOutput()
    output.Update()
    self.assertEqual(output.GetItemNumber(), 4)
    ev = output.GetItem(0)
    self.assertEqual(ev.GetLabel(), "Foot Strike")
    self.assertEqual(ev.GetContext(), "General")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 1)
    self.assertEqual(ev.GetFrame(), 257)
    self.assertEqual(ev.GetTime(), 2.57)
    ev = output.GetItem(1)
    self.assertEqual(ev.GetLabel(), "Foot Off")
    self.assertEqual(ev.GetContext(), "General")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 2)
    self.assertEqual(ev.GetFrame(), 316)
    self.assertEqual(ev.GetTime(), 3.16)
    ev = output.GetItem(2)
    self.assertEqual(ev.GetLabel(), "Foot Strike")
    self.assertEqual(ev.GetContext(), "General")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 1)
    self.assertEqual(ev.GetFrame(), 209)
    self.assertEqual(ev.GetTime(), 2.09)
    ev = output.GetItem(3)
    self.assertEqual(ev.GetLabel(), "Foot Off")
    self.assertEqual(ev.GetContext(), "General")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 2)
    self.assertEqual(ev.GetFrame(), 267)
    self.assertEqual(ev.GetTime(), 2.67)
  
  def test_PluginC3D(self):
    reader = btk.btkAcquisitionFileReader()
    reader.SetFilename(_TDDConfigure.C3DFilePathIN + "sample09/PlugInC3D.c3d")
    reader.Update()
    pfe = btk.btkForcePlatformsExtractor()
    grwf = btk.btkGroundReactionWrenchFilter()
    dswc = btk.btkWrenchCollectionDownsampleFilter()
    dswc.SetUpDownRatio(reader.GetOutput().GetNumberAnalogSamplePerFrame())
    pfe.SetInput(reader.GetOutput())
    grwf.SetInput(pfe.GetOutput())
    dswc.SetInput(grwf.GetOutput())
    vgrfged = btk.btkVerticalGroundReactionForceGaitEventDetector()
    vgrfged.SetInput(dswc.GetOutput())
    vgrfged.SetForceplateContextMapping(["Right","Left"])
    vgrfged.SetAcquisitionInformation(reader.GetOutput().GetFirstFrame(), reader.GetOutput().GetPointFrequency(), "")
    output = vgrfged.GetOutput()
    output.Update()
    self.assertEqual(output.GetItemNumber(), 4)
    ev = output.GetItem(0)
    self.assertEqual(ev.GetLabel(), "Foot Strike")
    self.assertEqual(ev.GetContext(), "Right")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 1)
    self.assertEqual(ev.GetFrame(), 65)
    self.assertEqual(ev.GetTime(), 65.0/60.0)
    ev = output.GetItem(1)
    self.assertEqual(ev.GetLabel(), "Foot Off")
    self.assertEqual(ev.GetContext(), "Right")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 2)
    self.assertEqual(ev.GetFrame(), 116)
    self.assertEqual(ev.GetTime(), 116.0/60.0)
    ev = output.GetItem(2)
    self.assertEqual(ev.GetLabel(), "Foot Strike")
    self.assertEqual(ev.GetContext(), "Left")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 1)
    self.assertEqual(ev.GetFrame(), 108)
    self.assertEqual(ev.GetTime(), 108.0/60.0)
    ev = output.GetItem(3)
    self.assertEqual(ev.GetLabel(), "Foot Off")
    self.assertEqual(ev.GetContext(), "Left")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 2)
    self.assertEqual(ev.GetFrame(), 150)
    self.assertEqual(ev.GetTime(), 150.0/60.0)
  
  def test_PluginC3D_Threshold50(self):
    reader = btk.btkAcquisitionFileReader()
    reader.SetFilename(_TDDConfigure.C3DFilePathIN + "sample09/PlugInC3D.c3d")
    reader.Update()
    pfe = btk.btkForcePlatformsExtractor()
    grwf = btk.btkGroundReactionWrenchFilter()
    dswc = btk.btkWrenchCollectionDownsampleFilter()
    dswc.SetUpDownRatio(reader.GetOutput().GetNumberAnalogSamplePerFrame())
    pfe.SetInput(reader.GetOutput())
    grwf.SetInput(pfe.GetOutput())
    dswc.SetInput(grwf.GetOutput())
    vgrfged = btk.btkVerticalGroundReactionForceGaitEventDetector()
    vgrfged.SetInput(dswc.GetOutput())
    vgrfged.SetThresholdValue(50)
    vgrfged.SetForceplateContextMapping(["Right","Left"])
    vgrfged.SetAcquisitionInformation(reader.GetOutput().GetFirstFrame(), reader.GetOutput().GetPointFrequency(), "")
    output = vgrfged.GetOutput()
    output.Update()
    self.assertEqual(output.GetItemNumber(), 4)
    ev = output.GetItem(0)
    self.assertEqual(ev.GetLabel(), "Foot Strike")
    self.assertEqual(ev.GetContext(), "Right")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 1)
    self.assertEqual(ev.GetFrame(), 67)
    self.assertEqual(ev.GetTime(), 67.0/60.0)
    ev = output.GetItem(1)
    self.assertEqual(ev.GetLabel(), "Foot Off")
    self.assertEqual(ev.GetContext(), "Right")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 2)
    self.assertEqual(ev.GetFrame(), 114)
    self.assertEqual(ev.GetTime(), 114.0/60.0)
    ev = output.GetItem(2)
    self.assertEqual(ev.GetLabel(), "Foot Strike")
    self.assertEqual(ev.GetContext(), "Left")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 1)
    self.assertEqual(ev.GetFrame(), 109)
    self.assertEqual(ev.GetTime(), 109.0/60.0)
    ev = output.GetItem(3)
    self.assertEqual(ev.GetLabel(), "Foot Off")
    self.assertEqual(ev.GetContext(), "Left")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 2)
    self.assertEqual(ev.GetFrame(), 148)
    self.assertEqual(ev.GetTime(), 148.0/60.0)
  
  def test_PluginC3D_ROI(self):
    reader = btk.btkAcquisitionFileReader()
    reader.SetFilename(_TDDConfigure.C3DFilePathIN + "sample09/PlugInC3D.c3d")
    reader.Update()
    pfe = btk.btkForcePlatformsExtractor()
    grwf = btk.btkGroundReactionWrenchFilter()
    dswc = btk.btkWrenchCollectionDownsampleFilter()
    dswc.SetUpDownRatio(reader.GetOutput().GetNumberAnalogSamplePerFrame())
    pfe.SetInput(reader.GetOutput())
    grwf.SetInput(pfe.GetOutput())
    dswc.SetInput(grwf.GetOutput())
    vgrfged = btk.btkVerticalGroundReactionForceGaitEventDetector()
    vgrfged.SetInput(dswc.GetOutput())
    vgrfged.SetForceplateContextMapping(["Right","Left"])
    vgrfged.SetAcquisitionInformation(reader.GetOutput().GetFirstFrame(), reader.GetOutput().GetPointFrequency(), "")
    vgrfged.SetRegionOfInterest(60-reader.GetOutput().GetFirstFrame(), 120-reader.GetOutput().GetFirstFrame())
    output = vgrfged.GetOutput()
    output.Update()
    self.assertEqual(output.GetItemNumber(), 3)
    ev = output.GetItem(0)
    self.assertEqual(ev.GetLabel(), "Foot Strike")
    self.assertEqual(ev.GetContext(), "Right")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 1)
    self.assertEqual(ev.GetFrame(), 65)
    self.assertEqual(ev.GetTime(), 65.0/60.0)
    ev = output.GetItem(1)
    self.assertEqual(ev.GetLabel(), "Foot Off")
    self.assertEqual(ev.GetContext(), "Right")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 2)
    self.assertEqual(ev.GetFrame(), 116)
    self.assertEqual(ev.GetTime(), 116.0/60.0)
    ev = output.GetItem(2)
    self.assertEqual(ev.GetLabel(), "Foot Strike")
    self.assertEqual(ev.GetContext(), "Left")
    self.assertEqual(ev.GetDetectionFlags(), btk.btkEvent.Automatic | btk.btkEvent.FromForcePlatform)
    self.assertEqual(ev.GetId(), 1)
    self.assertEqual(ev.GetFrame(), 108)
    self.assertEqual(ev.GetTime(), 108.0/60.0)