import btk
import unittest

class EventTest(unittest.TestCase):
    def test_default_ctor(self):
        e = btk.btkEvent()
        self.assertEqual(e.GetLabel(), '')
        self.assertEqual(e.GetTime(), -1.0)
        self.assertEqual(e.GetFrame(), -1)
        self.assertEqual(e.GetContext(), '')
        self.assertEqual(e.GetDetectionFlags(), btk.btkEvent.Unknown)
        self.assertEqual(e.GetSubject(), '')
        self.assertEqual(e.GetDescription(), '')
        self.assertEqual(e.GetId(), 0)
        
    def test_ctor_time(self):
        e = btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', 'Simple test with time', 1)
        self.assertEqual(e.GetLabel(), 'FOO')
        self.assertEqual(e.GetTime(), 1.52)
        self.assertEqual(e.GetFrame(), -1)
        self.assertEqual(e.GetContext(), 'Right')
        self.assertEqual(e.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e.GetSubject(), 'Bar')
        self.assertEqual(e.GetDescription(), 'Simple test with time')
        self.assertEqual(e.GetId(), 1)
        
    def test_ctor_frame(self):
        e = btk.btkEvent('FOO', 144, 'Right', btk.btkEvent.Manual, 'Bar', 'Simple test with frame', 1)
        self.assertEqual(e.GetLabel(), 'FOO')
        self.assertEqual(e.GetTime(), -1)
        self.assertEqual(e.GetFrame(), 144)
        self.assertEqual(e.GetContext(), 'Right')
        self.assertEqual(e.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e.GetSubject(), 'Bar')
        self.assertEqual(e.GetDescription(), 'Simple test with frame')
        self.assertEqual(e.GetId(), 1)
        
    def test_ctor_both(self):
        e = btk.btkEvent('FOO', 1.52, 144, 'Right', btk.btkEvent.Manual, 'Bar', 'Simple test with both', 1)
        self.assertEqual(e.GetLabel(), 'FOO')
        self.assertEqual(e.GetTime(), 1.52)
        self.assertEqual(e.GetFrame(), 144)
        self.assertEqual(e.GetContext(), 'Right')
        self.assertEqual(e.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e.GetSubject(), 'Bar')
        self.assertEqual(e.GetDescription(), 'Simple test with both')
        self.assertEqual(e.GetId(), 1)
        
    def test_modifiers(self):
        e = btk.btkEvent()
        e.SetLabel('FOO')
        e.SetTime(1.52)
        e.SetFrame(144)
        e.SetContext('Right')
        e.SetDetectionFlags(btk.btkEvent.Manual)
        e.SetSubject('Bar')
        e.SetDescription('Test for the modifiers')
        e.SetId(1)
        self.assertEqual(e.GetLabel(), 'FOO')
        self.assertEqual(e.GetTime(), 1.52)
        self.assertEqual(e.GetFrame(), 144)
        self.assertEqual(e.GetContext(), 'Right')
        self.assertEqual(e.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e.GetSubject(), 'Bar')
        self.assertEqual(e.GetDescription(), 'Test for the modifiers')
        self.assertEqual(e.GetId(), 1)
        
    def test_copy(self):
        e1 = btk.btkEvent('FOO', 1.52, 144, 'Right', btk.btkEvent.Manual, 'Bar', 'Simple test', 1)
        e2 = e1;
        self.assertEqual(e2.GetLabel(), 'FOO')
        self.assertEqual(e2.GetTime(), 1.52)
        self.assertEqual(e2.GetFrame(), 144)
        self.assertEqual(e2.GetContext(), 'Right')
        self.assertEqual(e2.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e2.GetSubject(), 'Bar')
        self.assertEqual(e2.GetDescription(), 'Simple test')
        self.assertEqual(e2.GetId(), 1)
        e2.SetLabel('ALLO')
        e2.SetTime(2.03)
        e2.SetFrame(789)
        e2.SetContext('Left')
        e2.SetDetectionFlags(btk.btkEvent.Automatic)
        e2.SetSubject('Heinz')
        e2.SetDescription('Test for the copy')
        e2.SetId(2)
        self.assertEqual(e1.GetLabel(), e2.GetLabel())
        self.assertEqual(e1.GetTime(), e2.GetTime())
        self.assertEqual(e1.GetFrame(), e2.GetFrame())
        self.assertEqual(e1.GetContext(), e2.GetContext())
        self.assertEqual(e1.GetDetectionFlags(), e2.GetDetectionFlags())
        self.assertEqual(e1.GetSubject(), e2.GetSubject())
        self.assertEqual(e1.GetDescription(), e2.GetDescription())
        self.assertEqual(e1.GetId(), e2.GetId())
        
    def test_clone(self):
        e1 = btk.btkEvent('FOO', 1.52, 144, 'Right', btk.btkEvent.Manual, 'Bar', 'Simple test', 1)
        e2 = e1.Clone();
        self.assertEqual(e2.GetLabel(), 'FOO')
        self.assertEqual(e2.GetTime(), 1.52)
        self.assertEqual(e2.GetFrame(), 144)
        self.assertEqual(e2.GetContext(), 'Right')
        self.assertEqual(e2.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e2.GetSubject(), 'Bar')
        self.assertEqual(e2.GetDescription(), 'Simple test')
        self.assertEqual(e2.GetId(), 1)
        e2.SetLabel('ALLO')
        e2.SetTime(2.03)
        e2.SetFrame(789)
        e2.SetContext('Left')
        e2.SetDetectionFlags(btk.btkEvent.Automatic)
        e2.SetSubject('Heinz')
        e2.SetDescription('Test for the clone')
        e2.SetId(2)
        self.assertEqual(e1.GetLabel(), 'FOO')
        self.assertEqual(e1.GetTime(), 1.52)
        self.assertEqual(e1.GetFrame(), 144)
        self.assertEqual(e1.GetContext(), 'Right')
        self.assertEqual(e1.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e1.GetSubject(), 'Bar')
        self.assertEqual(e1.GetDescription(), 'Simple test')
        self.assertEqual(e1.GetId(), 1)
        self.assertEqual(e2.GetLabel(), 'ALLO')
        self.assertEqual(e2.GetTime(), 2.03)
        self.assertEqual(e2.GetFrame(), 789)
        self.assertEqual(e2.GetContext(), 'Left')
        self.assertEqual(e2.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e2.GetSubject(), 'Heinz')
        self.assertEqual(e2.GetDescription(), 'Test for the clone')
        self.assertEqual(e2.GetId(), 2)