# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.1
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
Biomechanical ToolKit (BTK) for Python
High level classes and functions to open, edit and modify biomechanical acquisitions.
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _btk
else:
    import _btk

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



def Iterate(c):
    """
    Python generator to iterate through a collection of BTK objects (Points, Analogs, Events and Metadata).

    For example:

    for i in btk.Iterate(acq.GetPoints()):
        print i.GetLabel()
    """
    i = c.Begin()
    while i != c.End():
        yield i.value()
        i.incr()

class SwigPyIterator(object):
    r"""Proxy of C++ swig::SwigPyIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _btk.delete_SwigPyIterator

    def value(self):
        r"""value(self) -> PyObject *"""
        return _btk.SwigPyIterator_value(self)

    def incr(self, n=1):
        r"""incr(self, n=1) -> SwigPyIterator"""
        return _btk.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        r"""decr(self, n=1) -> SwigPyIterator"""
        return _btk.SwigPyIterator_decr(self, n)

    def distance(self, x):
        r"""distance(self, x) -> ptrdiff_t"""
        return _btk.SwigPyIterator_distance(self, x)

    def equal(self, x):
        r"""equal(self, x) -> bool"""
        return _btk.SwigPyIterator_equal(self, x)

    def copy(self):
        r"""copy(self) -> SwigPyIterator"""
        return _btk.SwigPyIterator_copy(self)

    def next(self):
        r"""next(self) -> PyObject *"""
        return _btk.SwigPyIterator_next(self)

    def __next__(self):
        r"""__next__(self) -> PyObject *"""
        return _btk.SwigPyIterator___next__(self)

    def previous(self):
        r"""previous(self) -> PyObject *"""
        return _btk.SwigPyIterator_previous(self)

    def advance(self, n):
        r"""advance(self, n) -> SwigPyIterator"""
        return _btk.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        r"""__eq__(self, x) -> bool"""
        return _btk.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        r"""__ne__(self, x) -> bool"""
        return _btk.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        r"""__iadd__(self, n) -> SwigPyIterator"""
        return _btk.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        r"""__isub__(self, n) -> SwigPyIterator"""
        return _btk.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        r"""__add__(self, n) -> SwigPyIterator"""
        return _btk.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        r"""
        __sub__(self, n) -> SwigPyIterator
        __sub__(self, x) -> ptrdiff_t
        """
        return _btk.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _btk:
_btk.SwigPyIterator_swigregister(SwigPyIterator)

class btkEvent(object):
    r"""

    An event is defined as:
     - a label (string);
     - a time (double);
     - a frame (integer);
     - a context (string);
     - a detection flag (integer);
     - a description (string);
     - an ID (integer).

    The detection flag has a limited range of possible values and are listed in the following enumeration:
     - btk.btkEvent.Unknown: Unknown method used to detect the event;
     - btk.btkEvent.Manual: Event detected manually;
     - btk.btkEvent.Automatic: Automatic method used to detect the event;
     - btk.btkEvent.FromForcePlatform: Method based on force platform data to detect the event.

    Note: Even if there is no rule for the id value, these 3 next values are used in Vicon Workstation and Nexus to distinguish events' type:
     - The value 0 is for general event;
     - Value 1 corresponds to the foot strike event;
     - Value 2 for the foot off. Without the use of these values.
    It is known that Workstation and Nexus put all events in general (default value is 0). 
    For Polygon, one user reported that some points had their values set to 0.

    For example, a Heel Strike event on the left leg or the subject John Doe at frame 143 can be set by
    evt = btk.btkEvent('FootStrike', 143, 'Right', btk.btkEvent.Manual, 'John Doe', 'Heel strike event', 2)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Unknown = _btk.btkEvent_Unknown
    
    Manual = _btk.btkEvent_Manual
    
    Automatic = _btk.btkEvent_Automatic
    
    FromForcePlatform = _btk.btkEvent_FromForcePlatform
    

    def __init__(self, *args):
        r"""
        __init__(self) -> btkEvent
        __init__(self, label, t, context="", detectionFlags=Unknown, subject="", desc="", id=0) -> btkEvent
        __init__(self, label, f, context="", detectionFlags=Unknown, subject="", desc="", id=0) -> btkEvent
        __init__(self, label, t, f, context="", detectionFlags=Unknown, subject="", desc="", id=0) -> btkEvent

        An event is defined as:
         - a label (string);
         - a time (double);
         - a frame (integer);
         - a context (string);
         - a detection flag (integer);
         - a description (string);
         - an ID (integer).

        The detection flag has a limited range of possible values and are listed in the following enumeration:
         - btk.btkEvent.Unknown: Unknown method used to detect the event;
         - btk.btkEvent.Manual: Event detected manually;
         - btk.btkEvent.Automatic: Automatic method used to detect the event;
         - btk.btkEvent.FromForcePlatform: Method based on force platform data to detect the event.

        Note: Even if there is no rule for the id value, these 3 next values are used in Vicon Workstation and Nexus to distinguish events' type:
         - The value 0 is for general event;
         - Value 1 corresponds to the foot strike event;
         - Value 2 for the foot off. Without the use of these values.
        It is known that Workstation and Nexus put all events in general (default value is 0). 
        For Polygon, one user reported that some points had their values set to 0.

        For example, a Heel Strike event on the left leg or the subject John Doe at frame 143 can be set by
        evt = btk.btkEvent('FootStrike', 143, 'Right', btk.btkEvent.Manual, 'John Doe', 'Heel strike event', 2)
        """
        _btk.btkEvent_swiginit(self, _btk.new_btkEvent(*args))

    def Clone(self):
        r"""
        Clone(self) -> btkEvent
        Deep copy of the object.
        """
        return _btk.btkEvent_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkEvent_impl *"""
        return _btk.btkEvent___deref__(self)
    __swig_destroy__ = _btk.delete_btkEvent

    def GetLabel(self):
        r"""
        GetLabel(self) -> std::string const &
        Returns the event's label.
        """
        return _btk.btkEvent_GetLabel(self)

    def SetLabel(self, arg2):
        r"""
        SetLabel(self, string)
        Sets the event's label.
        """
        return _btk.btkEvent_SetLabel(self, arg2)

    def GetDescription(self):
        r"""
        GetDescription(self) -> std::string const &
        Returns the event's description.
        """
        return _btk.btkEvent_GetDescription(self)

    def SetDescription(self, arg2):
        r"""
        SetDescription(self, string)
        Sets the event's description.
        """
        return _btk.btkEvent_SetDescription(self, arg2)

    def GetContext(self):
        r"""
        GetContext(self) -> std::string const &
        Returns the event's context.
        """
        return _btk.btkEvent_GetContext(self)

    def SetContext(self, arg2):
        r"""
        SetContext(self, string)
        Sets the event's context.
        """
        return _btk.btkEvent_SetContext(self, arg2)

    def GetSubject(self):
        r"""
        GetSubject(self) -> std::string const &
        Returns the event's subject.
        """
        return _btk.btkEvent_GetSubject(self)

    def SetSubject(self, arg2):
        r"""
        SetSubject(self, string)
        Sets the event's subject.
        """
        return _btk.btkEvent_SetSubject(self, arg2)

    def GetTime(self):
        r"""
        GetTime(self) -> double const
        Returns the event's time.
        """
        return _btk.btkEvent_GetTime(self)

    def SetTime(self, arg2):
        r"""
        SetTime(self, double)
        Sets the event's time.
        """
        return _btk.btkEvent_SetTime(self, arg2)

    def GetFrame(self):
        r"""
        GetFrame(self) -> int const
        Returns the event's frame.
        """
        return _btk.btkEvent_GetFrame(self)

    def SetFrame(self, arg2):
        r"""
        SetFrame(self, int)
        Sets the event's frame.
        """
        return _btk.btkEvent_SetFrame(self, arg2)

    def GetDetectionFlags(self):
        r"""
        GetDetectionFlags(self) -> int const
        Returns the event's detection flags.
        """
        return _btk.btkEvent_GetDetectionFlags(self)

    def SetDetectionFlags(self, arg2):
        r"""
        SetDetectionFlags(self, int)
        Sets the event's detection flags
        """
        return _btk.btkEvent_SetDetectionFlags(self, arg2)

    def HasDetectionFlag(self, arg2):
        r"""
        HasDetectionFlag(self, DetectionFlag) -> bool
        Check if the event has the given detection flag.
        """
        return _btk.btkEvent_HasDetectionFlag(self, arg2)

    def GetId(self):
        r"""
        GetId(self) -> int const
        Returns the event's ID.
        """
        return _btk.btkEvent_GetId(self)

    def SetId(self, arg2):
        r"""
        SetId(self, int)
        Sets the event's ID.
        """
        return _btk.btkEvent_SetId(self, arg2)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkEvent_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkEvent_GetTimestamp(self)

# Register btkEvent in _btk:
_btk.btkEvent_swigregister(btkEvent)

class btkAnalog(object):
    r"""

    An analog channel is defined as:
     - an array of double containing the samples (NumPy array);
     - a unit (string);
     - a scale (double);
     - an offset (integer);
     - a gain (integer).

    The gain has a limited range of possible values and are listed in the following enumeration:
     - btk.btkAnalog.Unknown: unknwon gain;
     - btk.btkAnalog.PlusMinus10: gain for the range +/- 10 volts;
     - btk.btkAnalog.PlusMinus5: gain for the range +/- 5 volts;
     - btk.btkAnalog.PlusMinus2Dot5: gain for the range +/- 2.5 volts;
     - btk.btkAnalog.PlusMinus1Dot65: gain for the range +/- 1.65 volts;
     - btk.btkAnalog.PlusMinus1Dot25: gain for the range +/- 1.25 volts;
     - btk.btkAnalog.PlusMinus1: gain for the range +/- 1 volt;
     - btk.btkAnalog.PlusMinus0Dot5: gain for the range +/- 0.5 volt;
     - btk.btkAnalog.PlusMinus0Dot25: gain for the range +/- 0.25 volt;
     - btk.btkAnalog.PlusMinus0Dot1: gain for the range +/- 0.1 volt;
     - btk.btkAnalog.PlusMinus0Dot05: gain for the range +/- 0.05 volt.

    Note: The informations associated (unit, scale, offset, gain) are useful for other classes/methods. 
    For example, when you save an acquisition in a file, analog's data are generally unscaled and written as integer, 
    then the scale and offset are important.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Unknown = _btk.btkAnalog_Unknown
    
    PlusMinus10 = _btk.btkAnalog_PlusMinus10
    
    PlusMinus5 = _btk.btkAnalog_PlusMinus5
    
    PlusMinus2Dot5 = _btk.btkAnalog_PlusMinus2Dot5
    
    PlusMinus1Dot25 = _btk.btkAnalog_PlusMinus1Dot25
    
    PlusMinus1 = _btk.btkAnalog_PlusMinus1
    
    PlusMinus0Dot5 = _btk.btkAnalog_PlusMinus0Dot5
    
    PlusMinus0Dot25 = _btk.btkAnalog_PlusMinus0Dot25
    
    PlusMinus0Dot1 = _btk.btkAnalog_PlusMinus0Dot1
    
    PlusMinus0Dot05 = _btk.btkAnalog_PlusMinus0Dot05
    

    def __init__(self, *args):
        r"""
        __init__(self, label="", desc="") -> btkAnalog
        __init__(self, frameNumber) -> btkAnalog
        __init__(self, label, frameNumber) -> btkAnalog

        An analog channel is defined as:
         - an array of double containing the samples (NumPy array);
         - a unit (string);
         - a scale (double);
         - an offset (integer);
         - a gain (integer).

        The gain has a limited range of possible values and are listed in the following enumeration:
         - btk.btkAnalog.Unknown: unknwon gain;
         - btk.btkAnalog.PlusMinus10: gain for the range +/- 10 volts;
         - btk.btkAnalog.PlusMinus5: gain for the range +/- 5 volts;
         - btk.btkAnalog.PlusMinus2Dot5: gain for the range +/- 2.5 volts;
         - btk.btkAnalog.PlusMinus1Dot65: gain for the range +/- 1.65 volts;
         - btk.btkAnalog.PlusMinus1Dot25: gain for the range +/- 1.25 volts;
         - btk.btkAnalog.PlusMinus1: gain for the range +/- 1 volt;
         - btk.btkAnalog.PlusMinus0Dot5: gain for the range +/- 0.5 volt;
         - btk.btkAnalog.PlusMinus0Dot25: gain for the range +/- 0.25 volt;
         - btk.btkAnalog.PlusMinus0Dot1: gain for the range +/- 0.1 volt;
         - btk.btkAnalog.PlusMinus0Dot05: gain for the range +/- 0.05 volt.

        Note: The informations associated (unit, scale, offset, gain) are useful for other classes/methods. 
        For example, when you save an acquisition in a file, analog's data are generally unscaled and written as integer, 
        then the scale and offset are important.
        """
        _btk.btkAnalog_swiginit(self, _btk.new_btkAnalog(*args))

    def Clone(self):
        r"""
        Clone(self) -> btkAnalog
        Deep copy of the object.
        """
        return _btk.btkAnalog_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkAnalog_impl *"""
        return _btk.btkAnalog___deref__(self)

    def GetValue(self, idx):
        r"""
        GetValue(self, idx) -> double
        Returns only one sample.
        """
        return _btk.btkAnalog_GetValue(self, idx)

    def SetValue(self, idx, v):
        r"""
        SetValue(self, int, double)
        Sets only one sample.
        """
        return _btk.btkAnalog_SetValue(self, idx, v)
    __swig_destroy__ = _btk.delete_btkAnalog

    def GetLabel(self):
        r"""
        GetLabel(self) -> std::string const &
        Returns the analog's label.
        """
        return _btk.btkAnalog_GetLabel(self)

    def SetLabel(self, arg2):
        r"""
        SetLabel(self, string)
        Sets the analog's label.
        """
        return _btk.btkAnalog_SetLabel(self, arg2)

    def GetDescription(self):
        r"""
        GetDescription(self) -> std::string const &
        Returns the analog's description.
        """
        return _btk.btkAnalog_GetDescription(self)

    def SetDescription(self, arg2):
        r"""
        SetDescription(self, string)
        Sets the analog's description.
        """
        return _btk.btkAnalog_SetDescription(self, arg2)

    def GetValues(self):
        r"""
        GetValues(self) -> array (NumPy)
        Returns the analog's samples.
        WARNING:You cannot set values using this method. Use the methods SetValues of SetValue for that.
        """
        return _btk.btkAnalog_GetValues(self)

    def SetValues(self, arg2):
        r"""
        SetValues(self, array)
        Sets the analog's samples.
        """
        return _btk.btkAnalog_SetValues(self, arg2)

    def GetFrameNumber(self):
        r"""
        GetFrameNumber(self) -> int const
        Returns the number of frames.
        """
        return _btk.btkAnalog_GetFrameNumber(self)

    def SetFrameNumber(self, arg2):
        r"""
        SetFrameNumber(self, int)
        Sets the number of frames.
        """
        return _btk.btkAnalog_SetFrameNumber(self, arg2)

    def GetUnit(self):
        r"""
        GetUnit(self) -> std::string const &
        Returns the analog's unit.
        """
        return _btk.btkAnalog_GetUnit(self)

    def SetUnit(self, arg2):
        r"""
        SetUnit(self, string)
        Sets the analog's unit.
        """
        return _btk.btkAnalog_SetUnit(self, arg2)

    def GetGain(self):
        r"""
        GetGain(self) -> btkAnalog_impl::Gain const
        Returns the analog's gain.
        """
        return _btk.btkAnalog_GetGain(self)

    def SetGain(self, arg2):
        r"""
        SetGain(self, int)
        Sets the analog's gain.
        """
        return _btk.btkAnalog_SetGain(self, arg2)

    def GetOffset(self):
        r"""GetOffset(self) -> double const"""
        return _btk.btkAnalog_GetOffset(self)

    def SetOffset(self, arg2):
        r"""SetOffset(self, arg2)"""
        return _btk.btkAnalog_SetOffset(self, arg2)

    def GetScale(self):
        r"""GetScale(self) -> double const"""
        return _btk.btkAnalog_GetScale(self)

    def SetScale(self, arg2):
        r"""SetScale(self, arg2)"""
        return _btk.btkAnalog_SetScale(self, arg2)

    def GetData(self):
        r"""
        GetData(self) -> btkAnalogData
        Return the data of this analog channel
        """
        return _btk.btkAnalog_GetData(self)

    def SetData(self, arg2, parenting=True):
        r"""
        SetData(self, btkAnalogData, parenting = true)SetData(self, btkAnalogData, parenting = true)
        Sets the data of this analog channel. By default, this object will take the parent of the data. Setting 'parenting' to false will unparent the old data, assign the new one, but doesn't set the point as its parent.
        """
        return _btk.btkAnalog_SetData(self, arg2, parenting)

    def SetDataSlice(self, arg2, arg3):
        r"""SetDataSlice(self, arg2, arg3)"""
        return _btk.btkAnalog_SetDataSlice(self, arg2, arg3)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkAnalog_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkAnalog_GetTimestamp(self)

# Register btkAnalog in _btk:
_btk.btkAnalog_swigregister(btkAnalog)

class btkAnalogData(object):
    r"""

    Class storing the measures for one analog channel.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, frameNumber):
        r"""
        __init__(self, frameNumber) -> btkAnalogData

        Class storing the measures for one analog channel.

        """
        _btk.btkAnalogData_swiginit(self, _btk.new_btkAnalogData(frameNumber))

    def Clone(self):
        r"""
        Clone(self) -> btkAnalogData
        Deep copy of the object.
        """
        return _btk.btkAnalogData_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkAnalogData_impl *"""
        return _btk.btkAnalogData___deref__(self)

    def GetValue(self, idx):
        r"""
        GetValue(self, idx) -> double
        Returns only one sample.
        """
        return _btk.btkAnalogData_GetValue(self, idx)

    def SetValue(self, idx, v):
        r"""
        SetValue(self, int, double)
        Sets only one sample.
        """
        return _btk.btkAnalogData_SetValue(self, idx, v)
    __swig_destroy__ = _btk.delete_btkAnalogData

    def GetValues(self):
        r"""
        GetValues(self) -> array (NumPy)
        Returns the analog's values.
        WARNING:You cannot set values using this method.
        """
        return _btk.btkAnalogData_GetValues(self)

    def SetValues(self, arg2):
        r"""
        SetValues(self, array)
        Sets the analog's values.
        """
        return _btk.btkAnalogData_SetValues(self, arg2)

    def Resize(self, frameNumber):
        r"""
        Resize(self, int)
        Resize the data to the given number of frames.
        """
        return _btk.btkAnalogData_Resize(self, frameNumber)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkAnalogData_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkAnalogData_GetTimestamp(self)

# Register btkAnalogData in _btk:
_btk.btkAnalogData_swigregister(btkAnalogData)

class btkPoint(object):
    r"""

    The coordinates of the point are generally measured by an acquisition system. For each frame, the
    3D value has a residual. It can provide informations on the quality of these 3D data 
    (residual associated with the reconstruction of the marker). 

    This class is also used to represent angles, forces, moments, powers and scalars. 
    To know/set the type of the point, you can use the methods GetType() and SetType(). 

    The type has a limited range of possible values and are listed in the following enumeration:
     - btk.btkPoint.Marker: Set the point object as a marker;
     - btk.btkPoint.Angle: Set the point object as an angle;
     - btk.btkPoint.Force: Set the point object as a force;
     - btk.btkPoint.Moment: Set the point object as a moment;
     - btk.btkPoint.Power: Set the point object as a power;
     - btk.btkPoint.Scalar: Set the point object as a scalar along the time;
     - btk.btkPoint.Reaction: Special type to indicate the point corresponds to one part of a wrench (not really used);

    Note: In some case the values at specific frames are invalid (mainly due to marker's occlusion).
    To detect if the frame is invalid, you can check the residual which will be 
    set to the value -1. It is the same thing if you want to set the frame as invalid. You can set
    the values of the frames to 0 and the associated residual to -1.

    Note: A residual with a value equal to 0 means that this frame has been post-processed (interpolation, filtering, etc.).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Marker = _btk.btkPoint_Marker
    
    Angle = _btk.btkPoint_Angle
    
    Force = _btk.btkPoint_Force
    
    Moment = _btk.btkPoint_Moment
    
    Power = _btk.btkPoint_Power
    
    Scalar = _btk.btkPoint_Scalar
    
    Reaction = _btk.btkPoint_Reaction
    

    def __init__(self, *args):
        r"""
        __init__(self, frameNumber) -> btkPoint
        __init__(self, label, frameNumber, t=Marker, desc="") -> btkPoint

        The coordinates of the point are generally measured by an acquisition system. For each frame, the
        3D value has a residual. It can provide informations on the quality of these 3D data 
        (residual associated with the reconstruction of the marker). 

        This class is also used to represent angles, forces, moments, powers and scalars. 
        To know/set the type of the point, you can use the methods GetType() and SetType(). 

        The type has a limited range of possible values and are listed in the following enumeration:
         - btk.btkPoint.Marker: Set the point object as a marker;
         - btk.btkPoint.Angle: Set the point object as an angle;
         - btk.btkPoint.Force: Set the point object as a force;
         - btk.btkPoint.Moment: Set the point object as a moment;
         - btk.btkPoint.Power: Set the point object as a power;
         - btk.btkPoint.Scalar: Set the point object as a scalar along the time;
         - btk.btkPoint.Reaction: Special type to indicate the point corresponds to one part of a wrench (not really used);

        Note: In some case the values at specific frames are invalid (mainly due to marker's occlusion).
        To detect if the frame is invalid, you can check the residual which will be 
        set to the value -1. It is the same thing if you want to set the frame as invalid. You can set
        the values of the frames to 0 and the associated residual to -1.

        Note: A residual with a value equal to 0 means that this frame has been post-processed (interpolation, filtering, etc.).
        """
        _btk.btkPoint_swiginit(self, _btk.new_btkPoint(*args))

    def Clone(self):
        r"""
        Clone(self) -> btkPoint
        Deep copy of the object.
        """
        return _btk.btkPoint_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkPoint_impl *"""
        return _btk.btkPoint___deref__(self)

    def GetValue(self, row, col):
        r"""
        GetValue(self, row, col) -> double
        Returns only one value for the given component and frame.
        """
        return _btk.btkPoint_GetValue(self, row, col)

    def SetValue(self, row, col, v):
        r"""
        SetValue(self, int, int, double)
        Sets only one value for the given component and frame.
        """
        return _btk.btkPoint_SetValue(self, row, col, v)

    def GetResidual(self, idx):
        r"""
        GetResidual(self, idx) -> double
        Returns only one residual for the given frame.
        """
        return _btk.btkPoint_GetResidual(self, idx)

    def SetResidual(self, idx, v):
        r"""
        SetResidual(self, int, double)
        Sets only one residual for the given frame.
        """
        return _btk.btkPoint_SetResidual(self, idx, v)
    __swig_destroy__ = _btk.delete_btkPoint

    def GetLabel(self):
        r"""
        GetLabel(self) -> std::string const &
        Returns the point's label.
        """
        return _btk.btkPoint_GetLabel(self)

    def SetLabel(self, arg2):
        r"""
        SetLabel(self, string)
        Sets the point's label.
        """
        return _btk.btkPoint_SetLabel(self, arg2)

    def GetDescription(self):
        r"""
        GetDescription(self) -> std::string const &
        Returns the point's description.
        """
        return _btk.btkPoint_GetDescription(self)

    def SetDescription(self, arg2):
        r"""
        SetDescription(self, string)
        Sets the point's description.
        """
        return _btk.btkPoint_SetDescription(self, arg2)

    def GetValues(self):
        r"""
        GetValues(self) -> array (NumPy)
        Returns the point's values.
        WARNING:You cannot set values using this method. Use the methods SetValues of SetValue for that.
        """
        return _btk.btkPoint_GetValues(self)

    def SetValues(self, arg2):
        r"""
        SetValues(self, array)
        Sets the point's values.
        """
        return _btk.btkPoint_SetValues(self, arg2)

    def GetResiduals(self):
        r"""
        GetResiduals(self) -> array (NumPy)
        Returns the point's residuals.
        """
        return _btk.btkPoint_GetResiduals(self)

    def SetResiduals(self, arg2):
        r"""
        SetResiduals(self, array)
        Sets the point's residuals.
        """
        return _btk.btkPoint_SetResiduals(self, arg2)

    def GetFrameNumber(self):
        r"""
        GetFrameNumber(self) -> int const
        Returns the number of frames.
        """
        return _btk.btkPoint_GetFrameNumber(self)

    def SetFrameNumber(self, arg2):
        r"""
        SetFrameNumber(self, int)
        Sets the number of frames.
        """
        return _btk.btkPoint_SetFrameNumber(self, arg2)

    def GetType(self):
        r"""
        GetType(self) -> btkPoint_impl::Type const
        Returns the point's type.
        """
        return _btk.btkPoint_GetType(self)

    def SetType(self, arg2):
        r"""
        SetUnit(self, int)
        Sets the point's type.
        """
        return _btk.btkPoint_SetType(self, arg2)

    def GetData(self):
        r"""
        GetData(self) -> btkPointData
        Return the data of this point
        """
        return _btk.btkPoint_GetData(self)

    def SetData(self, arg2, parenting=True):
        r"""
        SetData(self, btkPointData, parenting = true)SetData(self, btkPointData, parenting = true)
        Sets the data of this point. By default, this object will take the parent of the data. Setting 'parenting' to false will unparent the old data, assign the new one, but doesn't set the point as its parent.
        """
        return _btk.btkPoint_SetData(self, arg2, parenting)

    def SetDataSlice(self, arg2, arg3, arg4, arg5, res=0.0):
        r"""
        SetDataSlice(self, arg2, arg3, arg4, arg5, res=0.0)
        Convenient method to easily set the coordinates x,y,z and the residual for the given frame.
        WARNING: This function is not safe. There is no checking to determine if the frame is out of range or not. It has the advantage to be faster.
        """
        return _btk.btkPoint_SetDataSlice(self, arg2, arg3, arg4, arg5, res)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkPoint_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkPoint_GetTimestamp(self)

# Register btkPoint in _btk:
_btk.btkPoint_swigregister(btkPoint)

class btkPointData(object):
    r"""

    Class storing the measures for a point (3D values and residuals along the time).

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, frameNumber):
        r"""
        __init__(self, frameNumber) -> btkPointData

        Class storing the measures for a point (3D values and residuals along the time).

        """
        _btk.btkPointData_swiginit(self, _btk.new_btkPointData(frameNumber))

    def Clone(self):
        r"""
        Clone(self) -> btkPointData
        Deep copy of the object.
        """
        return _btk.btkPointData_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkPointData_impl *"""
        return _btk.btkPointData___deref__(self)

    def GetValue(self, row, col):
        r"""GetValue(self, row, col) -> double"""
        return _btk.btkPointData_GetValue(self, row, col)

    def SetValue(self, row, col, v):
        r"""SetValue(self, row, col, v)"""
        return _btk.btkPointData_SetValue(self, row, col, v)

    def GetResidual(self, idx):
        r"""GetResidual(self, idx) -> double"""
        return _btk.btkPointData_GetResidual(self, idx)

    def SetResidual(self, idx, v):
        r"""SetResidual(self, idx, v)"""
        return _btk.btkPointData_SetResidual(self, idx, v)
    __swig_destroy__ = _btk.delete_btkPointData

    def GetValues(self):
        r"""
        GetValues(self) -> array (NumPy)
        Returns the point's values.
        WARNING:You cannot set values using this method.
        """
        return _btk.btkPointData_GetValues(self)

    def SetValues(self, arg2):
        r"""
        SetValues(self, array)
        Sets the point's values.
        """
        return _btk.btkPointData_SetValues(self, arg2)

    def GetResiduals(self):
        r"""
        GetResiduals(self) -> array (NumPy)
        Returns the point's residuals.
        """
        return _btk.btkPointData_GetResiduals(self)

    def SetResiduals(self, arg2):
        r"""
        SetResiduals(self, array)
        Sets the point's residuals.
        """
        return _btk.btkPointData_SetResiduals(self, arg2)

    def Resize(self, frameNumber):
        r"""
        Resize(self, int)
        Resize the data to the given number of frames.
        """
        return _btk.btkPointData_Resize(self, frameNumber)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkPointData_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkPointData_GetTimestamp(self)

# Register btkPointData in _btk:
_btk.btkPointData_swigregister(btkPointData)

class btkForcePlatform(object):
    r"""

    This class is generic and doesn't know its type, nor the number of analog channels used.
    To use predefined force platform as proposed in the documentation of the C3D file format, check the following classes:
     - btk::ForcePlatformType1: 6 channels (FX, FY, FZ, PX, PY, MZ);
     - btk::ForcePlatformType2: 6 channels (FX, FY, FZ, MX, MY, MZ);
     - btk::ForcePlatformType3: 8 channels (FZ1, FZ2, FZ3, FZ4, FX12, FX34, FY14, FY23);
     - btk::ForcePlatformType4: Same as Type-2 + calibration matrix 6 (columns) by 6 (rows);
     - btk::ForcePlatformType5: Same as Type-3 + calibration matrix 6 (columns) by 8 (rows);
     - btk::ForcePlatformType6: 12 channels (FX[1,2,3,4], FY[1,2,3,4], FZ[1,2,3,4] + calibration matrix 12 by 12).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Clone(self):
        r"""
        Clone(self) -> btkForcePlatform
        Deep copy of the object.
        """
        return _btk.btkForcePlatform_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkForcePlatform_impl *"""
        return _btk.btkForcePlatform___deref__(self)

    def SetOrigin(self, *args):
        """
        SetOrigin(self, array)
        SetOrigin(self, double, double, double)

        Sets the origin.
        """
        if (len(args) == 1):
            self._set_origin_1(*args)
        else:
            self._set_origin_2(*args)

    def SetCorner(self, *args):
        """
        SetCorner(self, int, int, double)
        SetCorner(self, int, double, double, double)
        SetCorner(self, int, array)

        Sets the corner for the given index.
        """
        if (len(args) == 2):
            self._set_corner_1(*args)
        elif (len(args) == 3):
            self._set_corner_2(*args)
        else:
            self._set_corner_3(*args) 

    __swig_destroy__ = _btk.delete_btkForcePlatform

    def Begin(self):
        r"""
        Begin(self) -> btkAnalogIterator
        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkForcePlatform_Begin(self)

    def End(self):
        r"""
        End(self) -> btkAnalogIterator
        Returns an iterator just past the last item.
        """
        return _btk.btkForcePlatform_End(self)

    def GetChannelNumber(self):
        r"""
        GetChannelNumber(self) -> int
        Returns the number of analog channels used by the force platform.
        """
        return _btk.btkForcePlatform_GetChannelNumber(self)

    def GetChannel(self, arg2):
        r"""
        GetChannel(self, int) -> btkAnalog)
        Returns the analog channel for the given index.
        """
        return _btk.btkForcePlatform_GetChannel(self, arg2)

    def SetChannel(self, arg2, arg3):
        r"""
        SetChannel(self, int , btkAnalog)
        Sets the analog channel for the given index.
        """
        return _btk.btkForcePlatform_SetChannel(self, arg2, arg3)

    def GetChannels(self):
        r"""
        GetChannels(self) -> btkAnalogCollection
        Returns force platform's channels.
        """
        return _btk.btkForcePlatform_GetChannels(self)

    def GetOrigin(self):
        r"""
        GetOrigin(self) -> array (NumPy)
        Returns the origin of the force platform.
        """
        return _btk.btkForcePlatform_GetOrigin(self)

    def _set_origin_1(self, arg2):
        r"""
        _set_origin_1(self, array)
        Internal method. Sets the origin.
        """
        return _btk.btkForcePlatform__set_origin_1(self, arg2)

    def _set_origin_2(self, arg2, arg3, arg4):
        r"""
        _set_origin_2(self, double, double, double)
        Internal method. Sets the origin.
        """
        return _btk.btkForcePlatform__set_origin_2(self, arg2, arg3, arg4)

    def GetCorner(self, arg2):
        r"""
        GetCorner(self, int) -> array (NumPy)
        Returns the corner for the given index.
        """
        return _btk.btkForcePlatform_GetCorner(self, arg2)

    def _set_corner_2(self, arg2, arg3, arg4):
        r"""
        _set_corner_2(self, int, int, double)
        Internal method. Sets the corner for the given index.
        """
        return _btk.btkForcePlatform__set_corner_2(self, arg2, arg3, arg4)

    def _set_corner_3(self, arg2, arg3, arg4, arg5):
        r"""
        _set_corner_3(self, int, double, double, double)
        Internal method. Sets the corner for the given index.
        """
        return _btk.btkForcePlatform__set_corner_3(self, arg2, arg3, arg4, arg5)

    def _set_corner_1(self, arg2, arg3):
        r"""
        _set_corner_1(self, int, array)
        Internal method. Sets the corner for the given index.
        """
        return _btk.btkForcePlatform__set_corner_1(self, arg2, arg3)

    def GetCorners(self):
        r"""
        GetCorners(self) -> array (NumPy)
        Returns corners' coordinates.
        """
        return _btk.btkForcePlatform_GetCorners(self)

    def SetCorners(self, arg2):
        r"""
        SetCorners(self, array)
        Sets corners' coordinates.
        """
        return _btk.btkForcePlatform_SetCorners(self, arg2)

    def GetCalMatrix(self):
        r"""
        GetCalMatrix(self) -> array (NumPy)
        Returns the calibration matrix.
        """
        return _btk.btkForcePlatform_GetCalMatrix(self)

    def SetCalMatrix(self, arg2):
        r"""
        SetCalMatrix(self, array)
        Sets the calibration matrix.
        """
        return _btk.btkForcePlatform_SetCalMatrix(self, arg2)

    def GetType(self):
        r"""
        GetType(self) -> int
        Returns the type of the force platform.
        """
        return _btk.btkForcePlatform_GetType(self)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkForcePlatform_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatform_GetTimestamp(self)

# Register btkForcePlatform in _btk:
_btk.btkForcePlatform_swigregister(btkForcePlatform)


def btkForcePlatformType1():
    r"""
    btkForcePlatformType1() -> btkForcePlatform

    Force platform composed of 6 channels:
     - FX: Horizontal forces on the axis X of the platform;
     - FY: Horizontal forces on the axis Y of the platform;
     - FZ: Vertical forces on the axis Z of the platform;
     - PX: Position of the centre of pressure (CoP) on the axis X of the platform;
     - PY: Position of the centre of pressure (CoP) on the axis Y of the platform;
     - MZ: Vertical moment on the axis Z of the platform.
    """
    return _btk.btkForcePlatformType1()

def btkForcePlatformType2():
    r"""
    btkForcePlatformType2() -> btkForcePlatform

    Force platform composed of 6 channels:
     - FX: Horizontal forces on the axis X of the platform;
     - FY: Horizontal forces on the axis Y of the platform;
     - FZ: Vertical forces on the axis Z of the platform;
     - MX: Horizontal moment on the axis X of the platform;
     - MY: Horizontal moment on the axis Y of the platform;
     - MZ: Vertical moment on the axis Z of the platform.
    """
    return _btk.btkForcePlatformType2()

def btkForcePlatformType3():
    r"""
    btkForcePlatformType3() -> btkForcePlatform

    Force platform composed of 8 channels:
     - FZ1: Vertical forces measured by the sensor on the corner 1;
     - FZ2: Vertical forces measured by the sensor on the corner 2;
     - FZ3: Vertical forces measured by the sensor on the corner 3;
     - FZ4: Vertical forces measured by the sensor on the corner 4;
     - FX12: Horizontal forces measured by the sensors 1 & 2;
     - FX34: Horizontal forces measured by the sensors 3 & 4;
     - FY14: Horizontal forces measured by the sensors 1 & 4;
     - FY23: Horizontal forces measured by the sensors 2 & 3.
    """
    return _btk.btkForcePlatformType3()

def btkForcePlatformType4():
    r"""
    btkForcePlatformType4() -> btkForcePlatform

    Force platform composed of 6 channels and a 6 columns by 6 rows calibration matrix. 
    The definition of the channels are the same than the force platform Type 2.
    """
    return _btk.btkForcePlatformType4()

def btkForcePlatformType5():
    r"""
    btkForcePlatformType5() -> btkForcePlatform

    Force platform composed of 8 channels and a 8 columns by 6 rows calibration matrix. 
    The definition of the channels are the same than the force platform Type 3.
    """
    return _btk.btkForcePlatformType5()

def btkForcePlatformType6():
    r"""
    btkForcePlatformType6() -> btkForcePlatform

    Force platform composed of 12 channels and a 12 columns by 12 rows calibration matrix:
     - FX1: Horizontal forces measured by the sensor on the corner 1;
     - FX2: Horizontal forces measured by the sensor on the corner 2;
     - FX3: Horizontal forces measured by the sensor on the corner 3;
     - FX4: Horizontal forces measured by the sensor on the corner 4;
     - FY1: Horizontal forces measured by the sensor on the corner 1;
     - FY2: Horizontal forces measured by the sensor on the corner 2;
     - FY3: Horizontal forces measured by the sensor on the corner 3;
     - FY4: Horizontal forces measured by the sensor on the corner 4;
     - FZ1: Vertical forces measured by the sensor on the corner 1;
     - FZ2: Vertical forces measured by the sensor on the corner 2;
     - FZ3: Vertical forces measured by the sensor on the corner 3;
     - FZ4: Vertical forces measured by the sensor on the corner 4.
    """
    return _btk.btkForcePlatformType6()
class btkWrench(object):
    r"""

    Represents a wrench as position, force and moment varying during the time.

    This class is mainly used to have a compact way to store forces and moment acting (or reacting) at a given position.
    The moment should be expressed at the position as it is defined in general mechanics.

    By default, the label used for the forces and the moments corresponds to the given label followed by the suffix '.F' and '.M' respectively.

    Warning: The call of the constructor btkWrench(label) must be followed by the use of the method btkWrench::SetFrameNumber as it creates a null matrix for the values.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, label="") -> btkWrench
        __init__(self, frameNumber) -> btkWrench
        __init__(self, label, frameNumber) -> btkWrench

        Represents a wrench as position, force and moment varying during the time.

        This class is mainly used to have a compact way to store forces and moment acting (or reacting) at a given position.
        The moment should be expressed at the position as it is defined in general mechanics.

        By default, the label used for the forces and the moments corresponds to the given label followed by the suffix '.F' and '.M' respectively.

        Warning: The call of the constructor btkWrench(label) must be followed by the use of the method btkWrench::SetFrameNumber as it creates a null matrix for the values.
        """
        _btk.btkWrench_swiginit(self, _btk.new_btkWrench(*args))

    def Clone(self):
        r"""Clone(self) -> btkWrench"""
        return _btk.btkWrench_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkWrench_impl *"""
        return _btk.btkWrench___deref__(self)
    __swig_destroy__ = _btk.delete_btkWrench

    def GetPosition(self):
        r"""
        GetPosition(self) -> btkPoint
        Returns the wrench's position.
        """
        return _btk.btkWrench_GetPosition(self)

    def SetPosition(self, arg2):
        r"""
        SetPosition(self, btkPoint)
        Sets the wrench's position.
        """
        return _btk.btkWrench_SetPosition(self, arg2)

    def GetForce(self):
        r"""
        GetForce(self) -> btkPoint
        Returns the wrench's force.
        """
        return _btk.btkWrench_GetForce(self)

    def SetForce(self, arg2):
        r"""
        SetForce(self, btkPoint)
        Sets the wrench's moment.
        """
        return _btk.btkWrench_SetForce(self, arg2)

    def GetMoment(self):
        r"""
        GetMoment(self) -> btkPoint
        Returns the wrench's moment.
        """
        return _btk.btkWrench_GetMoment(self)

    def SetMoment(self, arg2):
        r"""SetMoment(self, btkPoint)"""
        return _btk.btkWrench_SetMoment(self, arg2)

    def GetComponent(self, arg2):
        r"""
        GetComponent(self, int) -> btkPoint)
        Returns the component with the given index. The possible value for the index are: 0: Returns the position, 1: Returns the force, 2: Returns the moment. Any other value will trigger an exception.
        """
        return _btk.btkWrench_GetComponent(self, arg2)

    def SetFrameNumber(self, arg2):
        r"""
        SetFrameNumber(self, int)
        Set the number of frames in the wrenches. The given number of frames must be greater than 0.
        """
        return _btk.btkWrench_SetFrameNumber(self, arg2)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkWrench_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkWrench_GetTimestamp(self)

# Register btkWrench in _btk:
_btk.btkWrench_swigregister(btkWrench)

class btkIMU(object):
    r"""

    Container of analog channels representing an inertial measurement unit (IMU).

    This class proposes to store any number of analog channels but the 6 first channels could be 
    used for 3 accelerometers and 3 gyroscopes as some convenient methods are proposed in this way
    (see SetChannels(), GetAccelerometerX(), GetAccelerometerY(), GetAccelerometerZ(), GetGyroscopeX(), GetGyroscopeY(), GetGyroscopeZ()).

    The storage of the channel is done using an ID and not an array index. You can then use the same ID for some kind of sensor even if other are missing (i.e. IMU with accelerometers disabled or configured with 1 acc, and 2 gyros., etc.).

    Note: This class is still experimental and could be modified in a new release.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Clone(self):
        r"""Clone(self) -> btkIMU"""
        return _btk.btkIMU_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkIMU_impl *"""
        return _btk.btkIMU___deref__(self)
    __swig_destroy__ = _btk.delete_btkIMU

    def GetLabel(self):
        r"""GetLabel(self) -> std::string const &"""
        return _btk.btkIMU_GetLabel(self)

    def SetLabel(self, arg2):
        r"""SetLabel(self, arg2)"""
        return _btk.btkIMU_SetLabel(self, arg2)

    def GetDescription(self):
        r"""GetDescription(self) -> std::string const &"""
        return _btk.btkIMU_GetDescription(self)

    def SetDescription(self, arg2):
        r"""SetDescription(self, arg2)"""
        return _btk.btkIMU_SetDescription(self, arg2)

    def SetChannels(self, arg2, arg3, arg4, arg5, arg6, arg7):
        r"""
        SetChannels(self, btkAnalog, btkAnalog, btkAnalog, btkAnalog, btkAnalog, btkAnalog)
        Sets the 6 first channels of the IMUs with the analog channels @a accX, @a accY, @a accZ, @a gyroX, @a gyroY, @a gyroZ.
        """
        return _btk.btkIMU_SetChannels(self, arg2, arg3, arg4, arg5, arg6, arg7)

    def GetChannels(self):
        r"""
        GetChannels(self) -> btkAnalogCollection
        Returns the analog channels of the IMU in a collection. The analog channels are pushed in the collection by using their ID.
        """
        return _btk.btkIMU_GetChannels(self)

    def SetChannel(self, arg2, arg3):
        r"""
        SetChannel(self, id, btkAnalog)
        Sets an analog channel to the given ID. If an analog channel is already set to this ID, then it is replaced.
        """
        return _btk.btkIMU_SetChannel(self, arg2, arg3)

    def GetChannel(self, *args):
        r"""
        GetChannel(self, id) -> btkAnalog
        GetChannel(self, arg2) -> btkAnalog
        Returns the analog channel with the given ID or label. If there is no analog channel with the given ID, then an exception is thrown.
        """
        return _btk.btkIMU_GetChannel(self, *args)

    def GetChannelNumber(self):
        r"""
        GetChannelNumber(self) -> int
        Returns the number of analog channels associated to this IMU.
        """
        return _btk.btkIMU_GetChannelNumber(self)

    def GetType(self):
        r"""
        GetType(self) -> int
        Returns the type of the IMU.
        """
        return _btk.btkIMU_GetType(self)

    def GetFrameNumber(self):
        r"""
        GetFrameNumber(self) -> int
        Returns the number of frames set in this IMU.
        """
        return _btk.btkIMU_GetFrameNumber(self)

    def SetFrameNumber(self, fn):
        r"""
        SetFrameNumber(self, fn)
        Set the number of frames for the IMU and modify also the number of frames for the channels.
        """
        return _btk.btkIMU_SetFrameNumber(self, fn)

    def GetFrequency(self):
        r"""
        GetFrequency(self) -> double
        Returns the frequency set to the IMU. (by default it is 0 Hz).
        """
        return _btk.btkIMU_GetFrequency(self)

    def SetFrequency(self, f):
        r"""
        SetFrequency(self, f)
        Sets the acquisition sample rate associated to the IMU.
        """
        return _btk.btkIMU_SetFrequency(self, f)

    def GetCalMatrix(self):
        r"""GetCalMatrix(self) -> array (NumPy)"""
        return _btk.btkIMU_GetCalMatrix(self)

    def SetCalMatrix(self, arg2):
        r"""SetCalMatrix(self, array)"""
        return _btk.btkIMU_SetCalMatrix(self, arg2)

    def GetAccelerometerX(self):
        r"""
        GetAccelerometerX(self) -> btkAnalog
        Convenient method to return the analog channel with the ID 0 (which should correspond to an accelerometer measuring data on the X axis of the IMU).
        """
        return _btk.btkIMU_GetAccelerometerX(self)

    def GetAccelerometerY(self):
        r"""
        GetAccelerometerY(self) -> btkAnalog
        Convenient method to return the analog channel with the ID 1 (which should correspond to an accelerometer measuring data on the Y axis of the IMU).
        """
        return _btk.btkIMU_GetAccelerometerY(self)

    def GetAccelerometerZ(self):
        r"""
        GetAccelerometerZ(self) -> btkAnalog
        Convenient method to return the analog channel with the ID 2 (which should correspond to an accelerometer measuring data on the Z axis of the IMU).
        """
        return _btk.btkIMU_GetAccelerometerZ(self)

    def GetGyroscopeX(self):
        r"""
        GetGyroscopeX(self) -> btkAnalog
        Convenient method to return the analog channel with the ID 3 (which should correspond to a gyroscope measuring data on the X axis of the IMU).
        """
        return _btk.btkIMU_GetGyroscopeX(self)

    def GetGyroscopeY(self):
        r"""
        GetGyroscopeY(self) -> btkAnalog
        Convenient method to return the analog channel with the ID 4 (which should correspond to a gyroscope measuring data on the Y axis of the IMU).
        """
        return _btk.btkIMU_GetGyroscopeY(self)

    def GetGyroscopeZ(self):
        r"""
        GetGyroscopeZ(self) -> btkAnalog
        Convenient method to return the analog channel with the ID 5 (which should correspond to a gyroscope measuring data on the Z axis of the IMU).
        """
        return _btk.btkIMU_GetGyroscopeZ(self)

    def Rotate(self, arg2):
        r"""
        Rotate(self, arg2)
        Convenient method to rotate the analog channels with the IDs 0-5. This method handles the case where some of these analog channels are missing.
        """
        return _btk.btkIMU_Rotate(self, arg2)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkIMU_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkIMU_GetTimestamp(self)

# Register btkIMU in _btk:
_btk.btkIMU_swigregister(btkIMU)


def btkIMUType1(*args):
    r"""
    btkIMUType1(label="IMU", desc="", init=True) -> btkIMU

    IMU 6D (3 accelerometers and 3 gyroscopes).
    """
    return _btk.btkIMUType1(*args)

def btkIMUType2(*args):
    r"""
    btkIMUType2(label="IMU", desc="", init=True) -> btkIMU

    IMU 6D (same as Type 1) with a calibration matrix used to align sensors (accelerometers and gyroscopes) on the same inertial reference frame.
    """
    return _btk.btkIMUType2(*args)
class btkEventCollectionIterator(object):
    r"""Proxy of C++ btkEventCollectionIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(self) -> btkEventCollectionIterator"""
        _btk.btkEventCollectionIterator_swiginit(self, _btk.new_btkEventCollectionIterator())

    def incr(self):
        r"""incr(self)"""
        return _btk.btkEventCollectionIterator_incr(self)

    def decr(self):
        r"""decr(self)"""
        return _btk.btkEventCollectionIterator_decr(self)

    def value(self):
        r"""value(self) -> btkEvent"""
        return _btk.btkEventCollectionIterator_value(self)

    def __eq__(self, rhs):
        r"""__eq__(self, rhs) -> bool"""
        return _btk.btkEventCollectionIterator___eq__(self, rhs)

    def __ne__(self, rhs):
        r"""__ne__(self, rhs) -> bool"""
        return _btk.btkEventCollectionIterator___ne__(self, rhs)
    __swig_destroy__ = _btk.delete_btkEventCollectionIterator

# Register btkEventCollectionIterator in _btk:
_btk.btkEventCollectionIterator_swigregister(btkEventCollectionIterator)

class btkEventCollection(object):
    r"""

    Collection of events stored in a list.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkEventCollection

        Collection of events stored in a list.
        """
        _btk.btkEventCollection_swiginit(self, _btk.new_btkEventCollection())

    def Clone(self):
        r"""
        Clone(self) -> btkEventCollection
        Deep copy of the object
        """
        return _btk.btkEventCollection_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkEventCollection_impl *"""
        return _btk.btkEventCollection___deref__(self)
    __swig_destroy__ = _btk.delete_btkEventCollection

    def Begin(self):
        r"""
        Begin(self) -> btkEventIterator
        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkEventCollection_Begin(self)

    def End(self):
        r"""
        End(self) -> btkEventIterator
        Returns an iterator just past the last item.
        """
        return _btk.btkEventCollection_End(self)

    def IsEmpty(self):
        r"""
        IsEmpty(self) -> bool
        Returns true if the collection is empty.
        """
        return _btk.btkEventCollection_IsEmpty(self)

    def GetItemNumber(self):
        r"""
        GetItemNumber(self) -> int
        Returns the number of events
        """
        return _btk.btkEventCollection_GetItemNumber(self)

    def SetItemNumber(self, arg2):
        r"""
        SetItemNumber(self, arg2)
        Sets the number of events
        """
        return _btk.btkEventCollection_SetItemNumber(self, arg2)

    def GetIndexOf(self, arg2):
        r"""
        GetIndexOf(self, int) -> btkEvent
        Returns the index of the given item.
        """
        return _btk.btkEventCollection_GetIndexOf(self, arg2)

    def GetItem(self, arg2):
        r"""
        GetItem(self, int) -> btkEvent
        Returns the event for the given index.
        """
        return _btk.btkEventCollection_GetItem(self, arg2)

    def InsertItem(self, *args):
        r"""
        InsertItem(self, btkEventIterator, btkEvent) -> boolInsertItem(self, int, btkEvent) -> boolInsertItem(self, btkEvent) -> bool
        Inserts an event in the list.
        """
        return _btk.btkEventCollection_InsertItem(self, *args)

    def SetItem(self, arg2, arg3):
        r"""
        SetItem(self, int) -> btkEvent
        Sets an event.
        """
        return _btk.btkEventCollection_SetItem(self, arg2, arg3)

    def RemoveItem(self, *args):
        r"""
        RemoveItem(self, btkEventIterator) -> btkEventIteratorRemoveItem(self, int)
        Removes an event.
        """
        return _btk.btkEventCollection_RemoveItem(self, *args)

    def TakeItem(self, *args):
        r"""
        TakeItem(self, btkEventIterator) -> btkEventTakeItem(self, int) -> btkEvent
        Removes an event and return it.
        """
        return _btk.btkEventCollection_TakeItem(self, *args)

    def Clear(self):
        r"""
        Clear(self)
        Clear the contents of the collection.
        """
        return _btk.btkEventCollection_Clear(self)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkEventCollection_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkEventCollection_GetTimestamp(self)

# Register btkEventCollection in _btk:
_btk.btkEventCollection_swigregister(btkEventCollection)

class btkAnalogCollectionIterator(object):
    r"""Proxy of C++ btkAnalogCollectionIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(self) -> btkAnalogCollectionIterator"""
        _btk.btkAnalogCollectionIterator_swiginit(self, _btk.new_btkAnalogCollectionIterator())

    def incr(self):
        r"""incr(self)"""
        return _btk.btkAnalogCollectionIterator_incr(self)

    def decr(self):
        r"""decr(self)"""
        return _btk.btkAnalogCollectionIterator_decr(self)

    def value(self):
        r"""value(self) -> btkAnalog"""
        return _btk.btkAnalogCollectionIterator_value(self)

    def __eq__(self, rhs):
        r"""__eq__(self, rhs) -> bool"""
        return _btk.btkAnalogCollectionIterator___eq__(self, rhs)

    def __ne__(self, rhs):
        r"""__ne__(self, rhs) -> bool"""
        return _btk.btkAnalogCollectionIterator___ne__(self, rhs)
    __swig_destroy__ = _btk.delete_btkAnalogCollectionIterator

# Register btkAnalogCollectionIterator in _btk:
_btk.btkAnalogCollectionIterator_swigregister(btkAnalogCollectionIterator)

class btkAnalogCollection(object):
    r"""

    Collection of analog channels stored in a list.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkAnalogCollection

        Collection of analog channels stored in a list.
        """
        _btk.btkAnalogCollection_swiginit(self, _btk.new_btkAnalogCollection())

    def Clone(self):
        r"""
        Clone(self) -> btkAnalogCollection
        Deep copy of the object
        """
        return _btk.btkAnalogCollection_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkAnalogCollection_impl *"""
        return _btk.btkAnalogCollection___deref__(self)
    __swig_destroy__ = _btk.delete_btkAnalogCollection

    def Begin(self):
        r"""
        Begin(self) -> btkAnalogIterator
        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkAnalogCollection_Begin(self)

    def End(self):
        r"""
        End(self) -> btkAnalogIterator
        Returns an iterator just past the last item.
        """
        return _btk.btkAnalogCollection_End(self)

    def IsEmpty(self):
        r"""
        IsEmpty(self) -> bool
        Returns true if the collection is empty.
        """
        return _btk.btkAnalogCollection_IsEmpty(self)

    def GetItemNumber(self):
        r"""
        GetItemNumber(self) -> int
        Returns the number of analog channels
        """
        return _btk.btkAnalogCollection_GetItemNumber(self)

    def SetItemNumber(self, arg2):
        r"""
        SetItemNumber(self, arg2)
        Sets the number of analog channels
        """
        return _btk.btkAnalogCollection_SetItemNumber(self, arg2)

    def GetIndexOf(self, arg2):
        r"""
        GetIndexOf(self, int) -> btkAnalog
        Returns the index of the given item.
        """
        return _btk.btkAnalogCollection_GetIndexOf(self, arg2)

    def GetItem(self, arg2):
        r"""
        GetItem(self, int) -> btkAnalog
        Returns the analog channel for the given index.
        """
        return _btk.btkAnalogCollection_GetItem(self, arg2)

    def InsertItem(self, *args):
        r"""
        InsertItem(self, btkAnalogIterator, btkAnalog) -> boolInsertItem(self, int, btkAnalog) -> boolInsertItem(self, btkAnalog) -> bool
        Inserts an analog channel in the list.
        """
        return _btk.btkAnalogCollection_InsertItem(self, *args)

    def SetItem(self, arg2, arg3):
        r"""
        SetItem(self, int) -> btkAnalog
        Sets an analog channel.
        """
        return _btk.btkAnalogCollection_SetItem(self, arg2, arg3)

    def RemoveItem(self, *args):
        r"""
        RemoveItem(self, btkAnalogIterator) -> btkAnalogIteratorRemoveItem(self, int)
        Removes an analog channel.
        """
        return _btk.btkAnalogCollection_RemoveItem(self, *args)

    def TakeItem(self, *args):
        r"""
        TakeItem(self, btkAnalogIterator) -> btkAnalogTakeItem(self, int) -> btkAnalog
        Removes an analog channel and return it.
        """
        return _btk.btkAnalogCollection_TakeItem(self, *args)

    def Clear(self):
        r"""
        Clear(self)
        Clear the contents of the collection.
        """
        return _btk.btkAnalogCollection_Clear(self)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkAnalogCollection_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkAnalogCollection_GetTimestamp(self)

# Register btkAnalogCollection in _btk:
_btk.btkAnalogCollection_swigregister(btkAnalogCollection)

class btkPointCollectionIterator(object):
    r"""Proxy of C++ btkPointCollectionIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(self) -> btkPointCollectionIterator"""
        _btk.btkPointCollectionIterator_swiginit(self, _btk.new_btkPointCollectionIterator())

    def incr(self):
        r"""incr(self)"""
        return _btk.btkPointCollectionIterator_incr(self)

    def decr(self):
        r"""decr(self)"""
        return _btk.btkPointCollectionIterator_decr(self)

    def value(self):
        r"""value(self) -> btkPoint"""
        return _btk.btkPointCollectionIterator_value(self)

    def __eq__(self, rhs):
        r"""__eq__(self, rhs) -> bool"""
        return _btk.btkPointCollectionIterator___eq__(self, rhs)

    def __ne__(self, rhs):
        r"""__ne__(self, rhs) -> bool"""
        return _btk.btkPointCollectionIterator___ne__(self, rhs)
    __swig_destroy__ = _btk.delete_btkPointCollectionIterator

# Register btkPointCollectionIterator in _btk:
_btk.btkPointCollectionIterator_swigregister(btkPointCollectionIterator)

class btkPointCollection(object):
    r"""

    Collection of point stored in a list.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkPointCollection

        Collection of point stored in a list.
        """
        _btk.btkPointCollection_swiginit(self, _btk.new_btkPointCollection())

    def Clone(self):
        r"""
        Clone(self) -> btkPointCollection
        Deep copy of the object
        """
        return _btk.btkPointCollection_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkPointCollection_impl *"""
        return _btk.btkPointCollection___deref__(self)
    __swig_destroy__ = _btk.delete_btkPointCollection

    def Begin(self):
        r"""
        Begin(self) -> btkPointIterator
        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkPointCollection_Begin(self)

    def End(self):
        r"""
        End(self) -> btkPointIterator
        Returns an iterator just past the last item.
        """
        return _btk.btkPointCollection_End(self)

    def IsEmpty(self):
        r"""
        IsEmpty(self) -> bool
        Returns true if the collection is empty.
        """
        return _btk.btkPointCollection_IsEmpty(self)

    def GetItemNumber(self):
        r"""
        GetItemNumber(self) -> int
        Returns the number of points
        """
        return _btk.btkPointCollection_GetItemNumber(self)

    def SetItemNumber(self, arg2):
        r"""
        SetItemNumber(self, arg2)
        Sets the number of points
        """
        return _btk.btkPointCollection_SetItemNumber(self, arg2)

    def GetIndexOf(self, arg2):
        r"""
        GetIndexOf(self, int) -> btkPoint
        Returns the index of the given item.
        """
        return _btk.btkPointCollection_GetIndexOf(self, arg2)

    def GetItem(self, arg2):
        r"""
        GetItem(self, int) -> btkPoint
        Returns the point for the given index.
        """
        return _btk.btkPointCollection_GetItem(self, arg2)

    def InsertItem(self, *args):
        r"""
        InsertItem(self, btkPointIterator, btkPoint) -> boolInsertItem(self, int, btkPoint) -> boolInsertItem(self, btkPoint) -> bool
        Inserts a point in the list.
        """
        return _btk.btkPointCollection_InsertItem(self, *args)

    def SetItem(self, arg2, arg3):
        r"""
        SetItem(self, int) -> btkPoint
        Sets a point.
        """
        return _btk.btkPointCollection_SetItem(self, arg2, arg3)

    def RemoveItem(self, *args):
        r"""
        RemoveItem(self, btkPointIterator) -> btkPointIteratorRemoveItem(self, int)
        Removes a point.
        """
        return _btk.btkPointCollection_RemoveItem(self, *args)

    def TakeItem(self, *args):
        r"""
        TakeItem(self, btkPointIterator) -> btkPointTakeItem(self, int) -> btkPoint
        Removes a point and return it.
        """
        return _btk.btkPointCollection_TakeItem(self, *args)

    def Clear(self):
        r"""
        Clear(self)
        Clear the contents of the collection.
        """
        return _btk.btkPointCollection_Clear(self)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkPointCollection_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkPointCollection_GetTimestamp(self)

# Register btkPointCollection in _btk:
_btk.btkPointCollection_swigregister(btkPointCollection)

class btkForcePlatformCollectionIterator(object):
    r"""Proxy of C++ btkForcePlatformCollectionIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(self) -> btkForcePlatformCollectionIterator"""
        _btk.btkForcePlatformCollectionIterator_swiginit(self, _btk.new_btkForcePlatformCollectionIterator())

    def incr(self):
        r"""incr(self)"""
        return _btk.btkForcePlatformCollectionIterator_incr(self)

    def decr(self):
        r"""decr(self)"""
        return _btk.btkForcePlatformCollectionIterator_decr(self)

    def value(self):
        r"""value(self) -> btkForcePlatform"""
        return _btk.btkForcePlatformCollectionIterator_value(self)

    def __eq__(self, rhs):
        r"""__eq__(self, rhs) -> bool"""
        return _btk.btkForcePlatformCollectionIterator___eq__(self, rhs)

    def __ne__(self, rhs):
        r"""__ne__(self, rhs) -> bool"""
        return _btk.btkForcePlatformCollectionIterator___ne__(self, rhs)
    __swig_destroy__ = _btk.delete_btkForcePlatformCollectionIterator

# Register btkForcePlatformCollectionIterator in _btk:
_btk.btkForcePlatformCollectionIterator_swigregister(btkForcePlatformCollectionIterator)

class btkForcePlatformCollection(object):
    r"""

    Collection of force platforms stored in a list.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkForcePlatformCollection

        Collection of force platforms stored in a list.
        """
        _btk.btkForcePlatformCollection_swiginit(self, _btk.new_btkForcePlatformCollection())

    def Clone(self):
        r"""
        Clone(self) -> btkForcePlatformCollection
        Deep copy of the object
        """
        return _btk.btkForcePlatformCollection_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkForcePlatformCollection_impl *"""
        return _btk.btkForcePlatformCollection___deref__(self)
    __swig_destroy__ = _btk.delete_btkForcePlatformCollection

    def Begin(self):
        r"""
        Begin(self) -> btkForcePlatformIterator
        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkForcePlatformCollection_Begin(self)

    def End(self):
        r"""
        End(self) -> btkForcePlatformIterator
        Returns an iterator just past the last item.
        """
        return _btk.btkForcePlatformCollection_End(self)

    def IsEmpty(self):
        r"""
        IsEmpty(self) -> bool
        Returns true if the collection is empty.
        """
        return _btk.btkForcePlatformCollection_IsEmpty(self)

    def GetItemNumber(self):
        r"""
        GetItemNumber(self) -> int
        Returns the number of force platforms
        """
        return _btk.btkForcePlatformCollection_GetItemNumber(self)

    def SetItemNumber(self, arg2):
        r"""
        SetItemNumber(self, arg2)
        Sets the number of force platforms
        """
        return _btk.btkForcePlatformCollection_SetItemNumber(self, arg2)

    def GetIndexOf(self, arg2):
        r"""
        GetIndexOf(self, int) -> btkForcePlatform
        Returns the index of the given item.
        """
        return _btk.btkForcePlatformCollection_GetIndexOf(self, arg2)

    def GetItem(self, arg2):
        r"""
        GetItem(self, int) -> btkForcePlatform
        Returns the force platform for the given index.
        """
        return _btk.btkForcePlatformCollection_GetItem(self, arg2)

    def InsertItem(self, *args):
        r"""
        InsertItem(self, btkForcePlatformIterator, btkForcePlatform) -> boolInsertItem(self, int, btkForcePlatform) -> boolInsertItem(self, btkForcePlatform) -> bool
        Inserts a force platform in the list.
        """
        return _btk.btkForcePlatformCollection_InsertItem(self, *args)

    def SetItem(self, arg2, arg3):
        r"""
        SetItem(self, int) -> btkForcePlatform
        Sets a force platform.
        """
        return _btk.btkForcePlatformCollection_SetItem(self, arg2, arg3)

    def RemoveItem(self, *args):
        r"""
        RemoveItem(self, btkForcePlatformIterator) -> btkForcePlatformIteratorRemoveItem(self, int)
        Removes a force platform.
        """
        return _btk.btkForcePlatformCollection_RemoveItem(self, *args)

    def TakeItem(self, *args):
        r"""
        TakeItem(self, btkForcePlatformIterator) -> btkForcePlatformTakeItem(self, int) -> btkForcePlatform
        Removes a force platform and return it.
        """
        return _btk.btkForcePlatformCollection_TakeItem(self, *args)

    def Clear(self):
        r"""
        Clear(self)
        Clear the contents of the collection.
        """
        return _btk.btkForcePlatformCollection_Clear(self)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkForcePlatformCollection_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatformCollection_GetTimestamp(self)

# Register btkForcePlatformCollection in _btk:
_btk.btkForcePlatformCollection_swigregister(btkForcePlatformCollection)

class btkWrenchCollectionIterator(object):
    r"""Proxy of C++ btkWrenchCollectionIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(self) -> btkWrenchCollectionIterator"""
        _btk.btkWrenchCollectionIterator_swiginit(self, _btk.new_btkWrenchCollectionIterator())

    def incr(self):
        r"""incr(self)"""
        return _btk.btkWrenchCollectionIterator_incr(self)

    def decr(self):
        r"""decr(self)"""
        return _btk.btkWrenchCollectionIterator_decr(self)

    def value(self):
        r"""value(self) -> btkWrench"""
        return _btk.btkWrenchCollectionIterator_value(self)

    def __eq__(self, rhs):
        r"""__eq__(self, rhs) -> bool"""
        return _btk.btkWrenchCollectionIterator___eq__(self, rhs)

    def __ne__(self, rhs):
        r"""__ne__(self, rhs) -> bool"""
        return _btk.btkWrenchCollectionIterator___ne__(self, rhs)
    __swig_destroy__ = _btk.delete_btkWrenchCollectionIterator

# Register btkWrenchCollectionIterator in _btk:
_btk.btkWrenchCollectionIterator_swigregister(btkWrenchCollectionIterator)

class btkWrenchCollection(object):
    r"""

    Collection of wrenchs stored in a list.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkWrenchCollection

        Collection of wrenchs stored in a list.
        """
        _btk.btkWrenchCollection_swiginit(self, _btk.new_btkWrenchCollection())

    def Clone(self):
        r"""
        Clone(self) -> btkWrenchCollection
        Deep copy of the object
        """
        return _btk.btkWrenchCollection_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkWrenchCollection_impl *"""
        return _btk.btkWrenchCollection___deref__(self)
    __swig_destroy__ = _btk.delete_btkWrenchCollection

    def Begin(self):
        r"""
        Begin(self) -> btkWrenchIterator
        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkWrenchCollection_Begin(self)

    def End(self):
        r"""
        End(self) -> btkWrenchIterator
        Returns an iterator just past the last item.
        """
        return _btk.btkWrenchCollection_End(self)

    def IsEmpty(self):
        r"""
        IsEmpty(self) -> bool
        Returns true if the collection is empty.
        """
        return _btk.btkWrenchCollection_IsEmpty(self)

    def GetItemNumber(self):
        r"""
        GetItemNumber(self) -> int
        Returns the number of wrenches
        """
        return _btk.btkWrenchCollection_GetItemNumber(self)

    def SetItemNumber(self, arg2):
        r"""
        SetItemNumber(self, arg2)
        Sets the number of wrenches
        """
        return _btk.btkWrenchCollection_SetItemNumber(self, arg2)

    def GetIndexOf(self, arg2):
        r"""
        GetIndexOf(self, int) -> btkWrench
        Returns the index of the given item.
        """
        return _btk.btkWrenchCollection_GetIndexOf(self, arg2)

    def GetItem(self, arg2):
        r"""
        GetItem(self, int) -> btkWrench
        Returns the wrench for the given index.
        """
        return _btk.btkWrenchCollection_GetItem(self, arg2)

    def InsertItem(self, *args):
        r"""
        InsertItem(self, btkWrenchIterator, btkWrench) -> boolInsertItem(self, int, btkWrench) -> boolInsertItem(self, btkWrench) -> bool
        Inserts a wrench in the list.
        """
        return _btk.btkWrenchCollection_InsertItem(self, *args)

    def SetItem(self, arg2, arg3):
        r"""
        SetItem(self, int) -> btkWrench
        Sets a wrench.
        """
        return _btk.btkWrenchCollection_SetItem(self, arg2, arg3)

    def RemoveItem(self, *args):
        r"""
        RemoveItem(self, btkWrenchIterator) -> btkWrenchIteratorRemoveItem(self, int)
        Removes a wrench.
        """
        return _btk.btkWrenchCollection_RemoveItem(self, *args)

    def TakeItem(self, *args):
        r"""
        TakeItem(self, btkWrenchIterator) -> btkWrenchTakeItem(self, int) -> btkWrench
        Removes a wrench and return it.
        """
        return _btk.btkWrenchCollection_TakeItem(self, *args)

    def Clear(self):
        r"""
        Clear(self)
        Clear the contents of the collection.
        """
        return _btk.btkWrenchCollection_Clear(self)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkWrenchCollection_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkWrenchCollection_GetTimestamp(self)

# Register btkWrenchCollection in _btk:
_btk.btkWrenchCollection_swigregister(btkWrenchCollection)

class btkIMUCollectionIterator(object):
    r"""Proxy of C++ btkIMUCollectionIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(self) -> btkIMUCollectionIterator"""
        _btk.btkIMUCollectionIterator_swiginit(self, _btk.new_btkIMUCollectionIterator())

    def incr(self):
        r"""incr(self)"""
        return _btk.btkIMUCollectionIterator_incr(self)

    def decr(self):
        r"""decr(self)"""
        return _btk.btkIMUCollectionIterator_decr(self)

    def value(self):
        r"""value(self) -> btkIMU"""
        return _btk.btkIMUCollectionIterator_value(self)

    def __eq__(self, rhs):
        r"""__eq__(self, rhs) -> bool"""
        return _btk.btkIMUCollectionIterator___eq__(self, rhs)

    def __ne__(self, rhs):
        r"""__ne__(self, rhs) -> bool"""
        return _btk.btkIMUCollectionIterator___ne__(self, rhs)
    __swig_destroy__ = _btk.delete_btkIMUCollectionIterator

# Register btkIMUCollectionIterator in _btk:
_btk.btkIMUCollectionIterator_swigregister(btkIMUCollectionIterator)

class btkIMUCollection(object):
    r"""

    Collection of IMUs stored in a list.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkIMUCollection

        Collection of IMUs stored in a list.
        """
        _btk.btkIMUCollection_swiginit(self, _btk.new_btkIMUCollection())

    def Clone(self):
        r"""
        Clone(self) -> btkIMUCollection
        Deep copy of the object
        """
        return _btk.btkIMUCollection_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkIMUCollection_impl *"""
        return _btk.btkIMUCollection___deref__(self)
    __swig_destroy__ = _btk.delete_btkIMUCollection

    def Begin(self):
        r"""
        Begin(self) -> btkIMUIterator
        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkIMUCollection_Begin(self)

    def End(self):
        r"""
        End(self) -> btkIMUIterator
        Returns an iterator just past the last item.
        """
        return _btk.btkIMUCollection_End(self)

    def IsEmpty(self):
        r"""
        IsEmpty(self) -> bool
        Returns true if the collection is empty.
        """
        return _btk.btkIMUCollection_IsEmpty(self)

    def GetItemNumber(self):
        r"""
        GetItemNumber(self) -> int
        Returns the number of IMUs
        """
        return _btk.btkIMUCollection_GetItemNumber(self)

    def SetItemNumber(self, arg2):
        r"""
        SetItemNumber(self, arg2)
        Sets the number of IMUs
        """
        return _btk.btkIMUCollection_SetItemNumber(self, arg2)

    def GetIndexOf(self, arg2):
        r"""
        GetIndexOf(self, int) -> btkIMU
        Returns the index of the given item.
        """
        return _btk.btkIMUCollection_GetIndexOf(self, arg2)

    def GetItem(self, arg2):
        r"""
        GetItem(self, int) -> btkIMU
        Returns the IMU for the given index.
        """
        return _btk.btkIMUCollection_GetItem(self, arg2)

    def InsertItem(self, *args):
        r"""
        InsertItem(self, btkIMUIterator, btkIMU) -> boolInsertItem(self, int, btkIMU) -> boolInsertItem(self, btkIMU) -> bool
        Inserts an IMU in the list.
        """
        return _btk.btkIMUCollection_InsertItem(self, *args)

    def SetItem(self, arg2, arg3):
        r"""
        SetItem(self, int) -> btkIMU
        Sets an IMU.
        """
        return _btk.btkIMUCollection_SetItem(self, arg2, arg3)

    def RemoveItem(self, *args):
        r"""
        RemoveItem(self, btkIMUIterator) -> btkIMUIteratorRemoveItem(self, int)
        Removes a IMU.
        """
        return _btk.btkIMUCollection_RemoveItem(self, *args)

    def TakeItem(self, *args):
        r"""
        TakeItem(self, btkIMUIterator) -> btkIMUTakeItem(self, int) -> btkIMU
        Removes an IMU and return it.
        """
        return _btk.btkIMUCollection_TakeItem(self, *args)

    def Clear(self):
        r"""
        Clear(self)
        Clear the contents of the collection.
        """
        return _btk.btkIMUCollection_Clear(self)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkIMUCollection_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkIMUCollection_GetTimestamp(self)

# Register btkIMUCollection in _btk:
_btk.btkIMUCollection_swigregister(btkIMUCollection)

class btkStringArray(object):
    r"""Proxy of C++ std::vector< std::string > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(self) -> SwigPyIterator"""
        return _btk.btkStringArray_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(self) -> bool"""
        return _btk.btkStringArray___nonzero__(self)

    def __bool__(self):
        r"""__bool__(self) -> bool"""
        return _btk.btkStringArray___bool__(self)

    def __len__(self):
        r"""__len__(self) -> std::vector< std::string >::size_type"""
        return _btk.btkStringArray___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(self, i, j) -> btkStringArray"""
        return _btk.btkStringArray___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(self, i, j)
        __setslice__(self, i, j, v)
        """
        return _btk.btkStringArray___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(self, i, j)"""
        return _btk.btkStringArray___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _btk.btkStringArray___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(self, slice) -> btkStringArray
        __getitem__(self, i) -> std::vector< std::string >::value_type const &
        """
        return _btk.btkStringArray___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _btk.btkStringArray___setitem__(self, *args)

    def pop(self):
        r"""pop(self) -> std::vector< std::string >::value_type"""
        return _btk.btkStringArray_pop(self)

    def append(self, x):
        r"""append(self, x)"""
        return _btk.btkStringArray_append(self, x)

    def empty(self):
        r"""empty(self) -> bool"""
        return _btk.btkStringArray_empty(self)

    def size(self):
        r"""size(self) -> std::vector< std::string >::size_type"""
        return _btk.btkStringArray_size(self)

    def swap(self, v):
        r"""swap(self, v)"""
        return _btk.btkStringArray_swap(self, v)

    def begin(self):
        r"""begin(self) -> std::vector< std::string >::iterator"""
        return _btk.btkStringArray_begin(self)

    def end(self):
        r"""end(self) -> std::vector< std::string >::iterator"""
        return _btk.btkStringArray_end(self)

    def rbegin(self):
        r"""rbegin(self) -> std::vector< std::string >::reverse_iterator"""
        return _btk.btkStringArray_rbegin(self)

    def rend(self):
        r"""rend(self) -> std::vector< std::string >::reverse_iterator"""
        return _btk.btkStringArray_rend(self)

    def clear(self):
        r"""clear(self)"""
        return _btk.btkStringArray_clear(self)

    def get_allocator(self):
        r"""get_allocator(self) -> std::vector< std::string >::allocator_type"""
        return _btk.btkStringArray_get_allocator(self)

    def pop_back(self):
        r"""pop_back(self)"""
        return _btk.btkStringArray_pop_back(self)

    def erase(self, *args):
        r"""
        erase(self, pos) -> std::vector< std::string >::iterator
        erase(self, first, last) -> std::vector< std::string >::iterator
        """
        return _btk.btkStringArray_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(self) -> btkStringArray
        __init__(self, other) -> btkStringArray
        __init__(self, size) -> btkStringArray
        __init__(self, size, value) -> btkStringArray
        """
        _btk.btkStringArray_swiginit(self, _btk.new_btkStringArray(*args))

    def push_back(self, x):
        r"""push_back(self, x)"""
        return _btk.btkStringArray_push_back(self, x)

    def front(self):
        r"""front(self) -> std::vector< std::string >::value_type const &"""
        return _btk.btkStringArray_front(self)

    def back(self):
        r"""back(self) -> std::vector< std::string >::value_type const &"""
        return _btk.btkStringArray_back(self)

    def assign(self, n, x):
        r"""assign(self, n, x)"""
        return _btk.btkStringArray_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _btk.btkStringArray_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(self, pos, x) -> std::vector< std::string >::iterator
        insert(self, pos, n, x)
        """
        return _btk.btkStringArray_insert(self, *args)

    def reserve(self, n):
        r"""reserve(self, n)"""
        return _btk.btkStringArray_reserve(self, n)

    def capacity(self):
        r"""capacity(self) -> std::vector< std::string >::size_type"""
        return _btk.btkStringArray_capacity(self)
    __swig_destroy__ = _btk.delete_btkStringArray

# Register btkStringArray in _btk:
_btk.btkStringArray_swigregister(btkStringArray)

class btkIntArray(object):
    r"""Proxy of C++ std::vector< int > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(self) -> SwigPyIterator"""
        return _btk.btkIntArray_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(self) -> bool"""
        return _btk.btkIntArray___nonzero__(self)

    def __bool__(self):
        r"""__bool__(self) -> bool"""
        return _btk.btkIntArray___bool__(self)

    def __len__(self):
        r"""__len__(self) -> std::vector< int >::size_type"""
        return _btk.btkIntArray___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(self, i, j) -> btkIntArray"""
        return _btk.btkIntArray___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(self, i, j)
        __setslice__(self, i, j, v)
        """
        return _btk.btkIntArray___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(self, i, j)"""
        return _btk.btkIntArray___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _btk.btkIntArray___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(self, slice) -> btkIntArray
        __getitem__(self, i) -> std::vector< int >::value_type const &
        """
        return _btk.btkIntArray___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _btk.btkIntArray___setitem__(self, *args)

    def pop(self):
        r"""pop(self) -> std::vector< int >::value_type"""
        return _btk.btkIntArray_pop(self)

    def append(self, x):
        r"""append(self, x)"""
        return _btk.btkIntArray_append(self, x)

    def empty(self):
        r"""empty(self) -> bool"""
        return _btk.btkIntArray_empty(self)

    def size(self):
        r"""size(self) -> std::vector< int >::size_type"""
        return _btk.btkIntArray_size(self)

    def swap(self, v):
        r"""swap(self, v)"""
        return _btk.btkIntArray_swap(self, v)

    def begin(self):
        r"""begin(self) -> std::vector< int >::iterator"""
        return _btk.btkIntArray_begin(self)

    def end(self):
        r"""end(self) -> std::vector< int >::iterator"""
        return _btk.btkIntArray_end(self)

    def rbegin(self):
        r"""rbegin(self) -> std::vector< int >::reverse_iterator"""
        return _btk.btkIntArray_rbegin(self)

    def rend(self):
        r"""rend(self) -> std::vector< int >::reverse_iterator"""
        return _btk.btkIntArray_rend(self)

    def clear(self):
        r"""clear(self)"""
        return _btk.btkIntArray_clear(self)

    def get_allocator(self):
        r"""get_allocator(self) -> std::vector< int >::allocator_type"""
        return _btk.btkIntArray_get_allocator(self)

    def pop_back(self):
        r"""pop_back(self)"""
        return _btk.btkIntArray_pop_back(self)

    def erase(self, *args):
        r"""
        erase(self, pos) -> std::vector< int >::iterator
        erase(self, first, last) -> std::vector< int >::iterator
        """
        return _btk.btkIntArray_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(self) -> btkIntArray
        __init__(self, other) -> btkIntArray
        __init__(self, size) -> btkIntArray
        __init__(self, size, value) -> btkIntArray
        """
        _btk.btkIntArray_swiginit(self, _btk.new_btkIntArray(*args))

    def push_back(self, x):
        r"""push_back(self, x)"""
        return _btk.btkIntArray_push_back(self, x)

    def front(self):
        r"""front(self) -> std::vector< int >::value_type const &"""
        return _btk.btkIntArray_front(self)

    def back(self):
        r"""back(self) -> std::vector< int >::value_type const &"""
        return _btk.btkIntArray_back(self)

    def assign(self, n, x):
        r"""assign(self, n, x)"""
        return _btk.btkIntArray_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _btk.btkIntArray_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(self, pos, x) -> std::vector< int >::iterator
        insert(self, pos, n, x)
        """
        return _btk.btkIntArray_insert(self, *args)

    def reserve(self, n):
        r"""reserve(self, n)"""
        return _btk.btkIntArray_reserve(self, n)

    def capacity(self):
        r"""capacity(self) -> std::vector< int >::size_type"""
        return _btk.btkIntArray_capacity(self)
    __swig_destroy__ = _btk.delete_btkIntArray

# Register btkIntArray in _btk:
_btk.btkIntArray_swigregister(btkIntArray)

class btkDoubleArray(object):
    r"""Proxy of C++ std::vector< double > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(self) -> SwigPyIterator"""
        return _btk.btkDoubleArray_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(self) -> bool"""
        return _btk.btkDoubleArray___nonzero__(self)

    def __bool__(self):
        r"""__bool__(self) -> bool"""
        return _btk.btkDoubleArray___bool__(self)

    def __len__(self):
        r"""__len__(self) -> std::vector< double >::size_type"""
        return _btk.btkDoubleArray___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(self, i, j) -> btkDoubleArray"""
        return _btk.btkDoubleArray___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(self, i, j)
        __setslice__(self, i, j, v)
        """
        return _btk.btkDoubleArray___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(self, i, j)"""
        return _btk.btkDoubleArray___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _btk.btkDoubleArray___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(self, slice) -> btkDoubleArray
        __getitem__(self, i) -> std::vector< double >::value_type const &
        """
        return _btk.btkDoubleArray___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _btk.btkDoubleArray___setitem__(self, *args)

    def pop(self):
        r"""pop(self) -> std::vector< double >::value_type"""
        return _btk.btkDoubleArray_pop(self)

    def append(self, x):
        r"""append(self, x)"""
        return _btk.btkDoubleArray_append(self, x)

    def empty(self):
        r"""empty(self) -> bool"""
        return _btk.btkDoubleArray_empty(self)

    def size(self):
        r"""size(self) -> std::vector< double >::size_type"""
        return _btk.btkDoubleArray_size(self)

    def swap(self, v):
        r"""swap(self, v)"""
        return _btk.btkDoubleArray_swap(self, v)

    def begin(self):
        r"""begin(self) -> std::vector< double >::iterator"""
        return _btk.btkDoubleArray_begin(self)

    def end(self):
        r"""end(self) -> std::vector< double >::iterator"""
        return _btk.btkDoubleArray_end(self)

    def rbegin(self):
        r"""rbegin(self) -> std::vector< double >::reverse_iterator"""
        return _btk.btkDoubleArray_rbegin(self)

    def rend(self):
        r"""rend(self) -> std::vector< double >::reverse_iterator"""
        return _btk.btkDoubleArray_rend(self)

    def clear(self):
        r"""clear(self)"""
        return _btk.btkDoubleArray_clear(self)

    def get_allocator(self):
        r"""get_allocator(self) -> std::vector< double >::allocator_type"""
        return _btk.btkDoubleArray_get_allocator(self)

    def pop_back(self):
        r"""pop_back(self)"""
        return _btk.btkDoubleArray_pop_back(self)

    def erase(self, *args):
        r"""
        erase(self, pos) -> std::vector< double >::iterator
        erase(self, first, last) -> std::vector< double >::iterator
        """
        return _btk.btkDoubleArray_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(self) -> btkDoubleArray
        __init__(self, other) -> btkDoubleArray
        __init__(self, size) -> btkDoubleArray
        __init__(self, size, value) -> btkDoubleArray
        """
        _btk.btkDoubleArray_swiginit(self, _btk.new_btkDoubleArray(*args))

    def push_back(self, x):
        r"""push_back(self, x)"""
        return _btk.btkDoubleArray_push_back(self, x)

    def front(self):
        r"""front(self) -> std::vector< double >::value_type const &"""
        return _btk.btkDoubleArray_front(self)

    def back(self):
        r"""back(self) -> std::vector< double >::value_type const &"""
        return _btk.btkDoubleArray_back(self)

    def assign(self, n, x):
        r"""assign(self, n, x)"""
        return _btk.btkDoubleArray_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _btk.btkDoubleArray_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(self, pos, x) -> std::vector< double >::iterator
        insert(self, pos, n, x)
        """
        return _btk.btkDoubleArray_insert(self, *args)

    def reserve(self, n):
        r"""reserve(self, n)"""
        return _btk.btkDoubleArray_reserve(self, n)

    def capacity(self):
        r"""capacity(self) -> std::vector< double >::size_type"""
        return _btk.btkDoubleArray_capacity(self)
    __swig_destroy__ = _btk.delete_btkDoubleArray

# Register btkDoubleArray in _btk:
_btk.btkDoubleArray_swigregister(btkDoubleArray)

class btkMetaDataInfo(object):
    r"""

    Container class to store data of a MetaData object.

    You can store integer value(s), real or string. This class has also methods to convert the native type into other, like integer into string.

    Even if the data extracted are set as native Python type, the internal type are different and set as:
     - btk.btkMetaDataInfo.Char: Type for the string;
     - btk.btkMetaDataInfo.Byte: Signed integer type stored only on 8 bit. Possible values between -127 and 128;
     - btk.btkMetaDataInfo.Integer: Signed integer type stored only on 16 bit. Possible values between -32767 and 32768;
     - btk.btkMetaDataInfo.Real: Float type. Precision limited to 1e-5.

    Note: The format btk.btkMetaDataInfo.Byte cannot be set using the method SetValues() do the impossibility to differentiate an integer. You need to use explicitly the method SetFormat().
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Char = _btk.btkMetaDataInfo_Char
    
    Byte = _btk.btkMetaDataInfo_Byte
    
    Integer = _btk.btkMetaDataInfo_Integer
    
    Real = _btk.btkMetaDataInfo_Real
    

    def __init__(self, *args):
        r"""
        __init__(self, val) -> btkMetaDataInfo
        __init__(self, val) -> btkMetaDataInfo
        __init__(self, val) -> btkMetaDataInfo
        __init__(self, val) -> btkMetaDataInfo
        __init__(self, val) -> btkMetaDataInfo
        __init__(self, val) -> btkMetaDataInfo
        __init__(self, dim, val) -> btkMetaDataInfo
        __init__(self, dim, val) -> btkMetaDataInfo
        __init__(self, dim, val) -> btkMetaDataInfo

        Container class to store data of a MetaData object.

        You can store integer value(s), real or string. This class has also methods to convert the native type into other, like integer into string.

        Even if the data extracted are set as native Python type, the internal type are different and set as:
         - btk.btkMetaDataInfo.Char: Type for the string;
         - btk.btkMetaDataInfo.Byte: Signed integer type stored only on 8 bit. Possible values between -127 and 128;
         - btk.btkMetaDataInfo.Integer: Signed integer type stored only on 16 bit. Possible values between -32767 and 32768;
         - btk.btkMetaDataInfo.Real: Float type. Precision limited to 1e-5.

        Note: The format btk.btkMetaDataInfo.Byte cannot be set using the method SetValues() do the impossibility to differentiate an integer. You need to use explicitly the method SetFormat().
        """
        _btk.btkMetaDataInfo_swiginit(self, _btk.new_btkMetaDataInfo(*args))

    def Clone(self):
        r"""
        Clone(self) -> btkMetaDataInfo
        Deep copy of the object
        """
        return _btk.btkMetaDataInfo_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkMetaDataInfo_impl *"""
        return _btk.btkMetaDataInfo___deref__(self)

    def GetDimension(self, idx):
        r"""GetDimension(self, idx) -> int"""
        return _btk.btkMetaDataInfo_GetDimension(self, idx)

    def SetDimension(self, idx, val):
        r"""SetDimension(self, idx, val)"""
        return _btk.btkMetaDataInfo_SetDimension(self, idx, val)

    def GetDimensions(self):
        r"""GetDimensions(self) -> btkIntArray"""
        return _btk.btkMetaDataInfo_GetDimensions(self)

    def SetDimensions(self, dims):
        r"""SetDimensions(self, dims)"""
        return _btk.btkMetaDataInfo_SetDimensions(self, dims)

    def GetValueNumber(self):
        r"""GetValueNumber(self) -> int"""
        return _btk.btkMetaDataInfo_GetValueNumber(self)

    def SetValue(self, *args):
        r"""
        SetValue(self, idx, val)
        SetValue(self, idx, val)
        SetValue(self, idx, val)
        """
        return _btk.btkMetaDataInfo_SetValue(self, *args)

    def SetValues(self, *args):
        r"""
        SetValues(self, val)
        SetValues(self, val)
        SetValues(self, val)
        SetValues(self, val)
        SetValues(self, val)
        SetValues(self, val)
        SetValues(self, dims, val)
        SetValues(self, dims, val)
        SetValues(self, dims, val)
        """
        return _btk.btkMetaDataInfo_SetValues(self, *args)

    def __eq__(self, rRHS):
        r"""__eq__(self, rRHS) -> bool"""
        return _btk.btkMetaDataInfo___eq__(self, rRHS)

    def __ne__(self, rRHS):
        r"""__ne__(self, rRHS) -> bool"""
        return _btk.btkMetaDataInfo___ne__(self, rRHS)
    __swig_destroy__ = _btk.delete_btkMetaDataInfo

    def GetFormat(self):
        r"""
        GetFormat(self) -> btkMetaDataInfo_impl::Format
        Returns the internal format of the values.
        """
        return _btk.btkMetaDataInfo_GetFormat(self)

    def GetFormatAsString(self):
        r"""
        GetFormatAsString(self) -> std::string
        Returns the format of the values as a string.
        """
        return _btk.btkMetaDataInfo_GetFormatAsString(self)

    def SetFormat(self, format):
        r"""
        SetFormat(self, btk.btkMetaDataInfo.Format)
        Sets the format of the values and adapt the values. This method erases the values and set default values ('0' or a string with white spaces).
        """
        return _btk.btkMetaDataInfo_SetFormat(self, format)

    def GetDimensionsProduct(self, start=0):
        r"""
        GetDimensionsProduct(self, start=0) -> int
        Compute the product of the dimensions from the given start index.
        """
        return _btk.btkMetaDataInfo_GetDimensionsProduct(self, start)

    def ResizeDimensions(self, nb):
        r"""
        ResizeDimensions(self, nb)
        Resize the dimensions and adapt the values and their structure. If the number of dimensions is greater, then the new dimensions are equal to 1. If the number of dimensions is lower, then the value are shrunken.
        """
        return _btk.btkMetaDataInfo_ResizeDimensions(self, nb)

    def ToString(self, *args):
        r"""
        ToString(self, idx) -> std::string const
        ToString(self) -> btkStringArray
        Convert stored value(s) into string(s).
        """
        return _btk.btkMetaDataInfo_ToString(self, *args)

    def ToInt(self, *args):
        r"""
        ToInt(self, idx) -> int
        ToInt(self) -> btkIntArray
        Convert stored value(s) into integer(s).
        """
        return _btk.btkMetaDataInfo_ToInt(self, *args)

    def ToDouble(self, *args):
        r"""
        ToDouble(self, idx) -> double
        ToDouble(self) -> btkDoubleArray
        Convert stored value(s) into double(s).
        """
        return _btk.btkMetaDataInfo_ToDouble(self, *args)

# Register btkMetaDataInfo in _btk:
_btk.btkMetaDataInfo_swigregister(btkMetaDataInfo)

class btkMetaData(object):
    r"""

    Store data which cannot be embedded within timeseries data (calibration matrix, subject informations, ...).

    Each object can store children metadata. Theoretically, the number of sub-level is infinite. However, the main common use of the metadata is to use 2 levels. This use was introduced in the C3D format.
    The values in a metadata are stored in a MetaDataInfo object and are accessible using the method GetInfo().

    The unlock member accessible using the methods GetUnlock() and SetUnlock() doesn't affect the setting of the values, but is used only to inform the user/developer.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, label) -> btkMetaData
        __init__(self, label, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, dim, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, dim, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, dim, val, desc="", isUnlocked=True) -> btkMetaData

        Store data which cannot be embedded within timeseries data (calibration matrix, subject informations, ...).

        Each object can store children metadata. Theoretically, the number of sub-level is infinite. However, the main common use of the metadata is to use 2 levels. This use was introduced in the C3D format.
        The values in a metadata are stored in a MetaDataInfo object and are accessible using the method GetInfo().

        The unlock member accessible using the methods GetUnlock() and SetUnlock() doesn't affect the setting of the values, but is used only to inform the user/developer.
        """
        _btk.btkMetaData_swiginit(self, _btk.new_btkMetaData(*args))

    def Clone(self):
        r"""
        Clone(self) -> btkMetaData
        Deep copy of the object
        """
        return _btk.btkMetaData_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkMetaData_impl *"""
        return _btk.btkMetaData___deref__(self)

    def __eq__(self, rRHS):
        r"""__eq__(self, rRHS) -> bool"""
        return _btk.btkMetaData___eq__(self, rRHS)

    def __ne__(self, rRHS):
        r"""__ne__(self, rRHS) -> bool"""
        return _btk.btkMetaData___ne__(self, rRHS)
    __swig_destroy__ = _btk.delete_btkMetaData

    def GetLabel(self):
        r"""GetLabel(self) -> std::string const &"""
        return _btk.btkMetaData_GetLabel(self)

    def SetLabel(self, arg2):
        r"""
        SetLabel(self, string)
        Sets the label of the entry. If label already exist in the parent's list, then an exception is thrown.
        """
        return _btk.btkMetaData_SetLabel(self, arg2)

    def GetDescription(self):
        r"""GetDescription(self) -> std::string const &"""
        return _btk.btkMetaData_GetDescription(self)

    def SetDescription(self, arg2):
        r"""SetDescription(self, string)"""
        return _btk.btkMetaData_SetDescription(self, arg2)

    def GetUnlockState(self):
        r"""
        GetUnlockState(self) -> bool const
        Gets the unlock state of the entry.
        """
        return _btk.btkMetaData_GetUnlockState(self)

    def SetUnlockState(self, arg2):
        r"""
        SetUnlockState(self, arg2)
        Sets the unlock state of the entry.
        """
        return _btk.btkMetaData_SetUnlockState(self, arg2)

    def GetInfo(self):
        r"""
        GetInfo(self) -> btkMetaDataInfo
        Gets the btkMetaDataInfo associated to the entry.
        """
        return _btk.btkMetaData_GetInfo(self)

    def SetInfo(self, arg2):
        r"""
        SetInfo(self, arg2)
        Sets the btkMetaDataInfo associated to the entry.
        """
        return _btk.btkMetaData_SetInfo(self, arg2)

    def HasInfo(self):
        r"""
        HasInfo(self) -> bool
        Checks if a btkMetaDataInfo is associated with the entry.
        """
        return _btk.btkMetaData_HasInfo(self)

    def ExtractChildInfo(self, arg2, arg3, arg4, noPossibleEmptyValue=True):
        r"""
        ExtractChildInfo(self, label, format, numdims, noPossibleEmptyValue = True) -> btkMetaDataInfoExtractChildInfo(self, label, format, numdims, noPossibleEmptyValue = True) -> btkMetaDataInfo
        Check if a child exists with the given label and correspond to the given format plus the number of dimensions with or without values (noPossibleEmptyValue). The informations of the metadata are extracted if all the checks are ok. Otherwise, the methods return an empty pointer.
        """
        return _btk.btkMetaData_ExtractChildInfo(self, arg2, arg3, arg4, noPossibleEmptyValue)

    def HasMetaDataAsParent(self):
        r"""
        HasMetaDataAsParent(self) -> bool
        Checks if this object has a MetaData object as parents.
        """
        return _btk.btkMetaData_HasMetaDataAsParent(self)

    def Begin(self):
        r"""
        Begin(self) -> btkMetaDataIterator
        Returns an iterator to the beginning of the list of children.
        """
        return _btk.btkMetaData_Begin(self)

    def End(self):
        r"""
        End(self) -> btkMetaDataIterator
        Returns an iterator just past the last child.
        """
        return _btk.btkMetaData_End(self)

    def GetChild(self, *args):
        r"""
        GetChild(self, index) -> btkMetaDataGetChild(self, index) -> btkMetaData
        Gets the entry for the given index or label. An exception is thrown is the given input doesn't correspond to any entry.
        """
        return _btk.btkMetaData_GetChild(self, *args)

    def AppendChild(self, arg2):
        r"""
        AppendChild(self, arg2) -> bool
        Append the child entry. If entry has a label which already exists in the parent's list, then it is not inserted. Returns True if child has been inserted or False.
        """
        return _btk.btkMetaData_AppendChild(self, arg2)

    def InsertChild(self, *args):
        r"""
        InsertChild(self, btkMetaDataIterator, btkMetaData) -> boolInsertChild(self, int, btkMetaData) -> bool
        Insert the child entry for the given location. If the entry has a label which already exists in the parent's list, then it is not inserted. Returns True if child has been inserted or False.
        """
        return _btk.btkMetaData_InsertChild(self, *args)

    def SetChild(self, arg2, arg3):
        r"""
        SetChild(self, int, btkMetaData)
        Sets the child entry for the given index
        """
        return _btk.btkMetaData_SetChild(self, arg2, arg3)

    def TakeChild(self, *args):
        r"""
        TakeChild(self, btkMetaDataIterator) -> btkMetaDataTakeChild(self, int) -> btkMetaDataTakeChild(self, string) -> btkMetaData
        Removes the child entry which has the given index, label or corresponding iterator. If there is no child with the specified label, then an empty pointer is returned.
        """
        return _btk.btkMetaData_TakeChild(self, *args)

    def RemoveChild(self, *args):
        r"""
        RemoveChild(self, btkMetaDataIterator) -> btkMetaDataIteratorRemoveChild(self, int)
        RemoveChild(self, arg2)
        Removes the child entry which has the given index, label or corresponding iterator.
        """
        return _btk.btkMetaData_RemoveChild(self, *args)

    def ClearChildren(self):
        r"""
        ClearChildren(self)
        Removes every children.
        """
        return _btk.btkMetaData_ClearChildren(self)

    def HasChildren(self):
        r"""
        HasChildren(self) -> bool
        Checks if the entry has children 
        """
        return _btk.btkMetaData_HasChildren(self)

    def GetChildNumber(self):
        r"""
        GetChildNumber(self) -> int
        Returns the number of children 
        """
        return _btk.btkMetaData_GetChildNumber(self)

    def FindChild(self, arg2):
        r"""
        FindChild(self, label) -> btkMetaDataIterator
        Finds the children which has the given label and return it as an iterator.
        """
        return _btk.btkMetaData_FindChild(self, arg2)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkMetaData_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkMetaData_GetTimestamp(self)

# Register btkMetaData in _btk:
_btk.btkMetaData_swigregister(btkMetaData)

class btkMetaDataIterator(object):
    r"""Proxy of C++ btkMetaDataIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(self) -> btkMetaDataIterator"""
        _btk.btkMetaDataIterator_swiginit(self, _btk.new_btkMetaDataIterator())

    def incr(self):
        r"""incr(self)"""
        return _btk.btkMetaDataIterator_incr(self)

    def decr(self):
        r"""decr(self)"""
        return _btk.btkMetaDataIterator_decr(self)

    def value(self):
        r"""value(self) -> btkMetaData"""
        return _btk.btkMetaDataIterator_value(self)

    def __eq__(self, rhs):
        r"""__eq__(self, rhs) -> bool"""
        return _btk.btkMetaDataIterator___eq__(self, rhs)

    def __ne__(self, rhs):
        r"""__ne__(self, rhs) -> bool"""
        return _btk.btkMetaDataIterator___ne__(self, rhs)
    __swig_destroy__ = _btk.delete_btkMetaDataIterator

# Register btkMetaDataIterator in _btk:
_btk.btkMetaDataIterator_swigregister(btkMetaDataIterator)


def btkMetaDataCreateChild(*args):
    r"""
    btkMetaDataCreateChild(parent, label) -> btkMetaDatabtkMetaDataCreateChild(parent , label , int )btkMetaDataCreateChild(parent , label , double )btkMetaDataCreateChild(parent , label , string )btkMetaDataCreateChild(parent , label , btkIntArray)btkMetaDataCreateChild(parent , label , btkDoubleArray)btkMetaDataCreateChild(parent , label , btkStringArray)btkMetaDataCreateChild(parent , label , btkIntArray , numCol)btkMetaDataCreateChild(parent , label , btkDoubleArray , numCol)btkMetaDataCreateChild(parent , label , btkStringArray , numCol)
    Function to create/set easily a metadata containing a 2D array as value, from a given label into a given parent.
    """
    return _btk.btkMetaDataCreateChild(*args)

def btkMetaDataCollapseChildrenValuesInt(parent, baselabel, targetFinalSize=-1, blankReplacement=0):
    r"""
    btkMetaDataCollapseChildrenValuesInt(parent, baselabel, targetFinalSize=-1, blankReplacement=0) -> btkIntArray
    Convenient method to extract the values of a metadata as an array of integers.
    Collapse the parent children entries' values starting with the string 'baselabel' and incrementing (for example: LABELS, LABELS2, LABELS3).
    """
    return _btk.btkMetaDataCollapseChildrenValuesInt(parent, baselabel, targetFinalSize, blankReplacement)

def btkMetaDataCollapseChildrenValuesDouble(parent, baselabel, targetFinalSize=-1, blankReplacement=0.0):
    r"""
    btkMetaDataCollapseChildrenValuesDouble(parent, baselabel, targetFinalSize=-1, blankReplacement=0.0) -> btkDoubleArray
    Convenient method to extract the values of a metadata as an array of doubles.
    Collapse the parent children entries' values starting with the string 'baselabel' and incrementing (for example: LABELS, LABELS2, LABELS3).
    """
    return _btk.btkMetaDataCollapseChildrenValuesDouble(parent, baselabel, targetFinalSize, blankReplacement)

def btkMetaDataCollapseChildrenValuesString(*args):
    r"""
    btkMetaDataCollapseChildrenValuesString(parent, baselabel, targetFinalSize=-1, blankReplacement="") -> btkStringArray
    Convenient method to extract the values of a metadata as an array of strings.
    Collapse the parent children entries' values starting with the string 'baselabel' and incrementing (for example: LABELS, LABELS2, LABELS3).
    """
    return _btk.btkMetaDataCollapseChildrenValuesString(*args)
class btkAcquisition(object):
    r"""

    Contains the data related to a biomechanical acquisition.

    A biomechanical acquisition can contains:
      - 3D data (makers, points, forces, moments, ...) ;
      - analog channels (force platform, emg, ...) ;
      - events
      - acquisition's setup ;
      - subject's informations.

    By default, the first frame is set to 1, the analog resolution is set to 12-bit, the maximum interpolation gap to 10 frames and the units are:
     - Marker: millimeters ;
     - Angle: degrees ;
     - Force: newtons ;
     - Moment: millimeter-newtons ;
     - Power: watts ;
     - Scalar: millimeters ;
     - Reaction: (nothing).

    After the creation of the acquisition, you should use the Init() method to populate the acquisition. 

    The member used for the maximum interpolation gap is only for information and is not used in the acquisition. It could be used later in a filter to fill gap.

    The analog resolution can be set to the following values:
     - btk.btkAcquisition.Bit8 ;
     - btk.btkAcquisition.Bit10 ;
     - btk.btkAcquisition.Bit12 ;
     - btk.btkAcquisition.Bit14 ;
     - btk.btkAcquisition.Bit16.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Bit8 = _btk.btkAcquisition_Bit8
    
    Bit10 = _btk.btkAcquisition_Bit10
    
    Bit12 = _btk.btkAcquisition_Bit12
    
    Bit14 = _btk.btkAcquisition_Bit14
    
    Bit16 = _btk.btkAcquisition_Bit16
    

    def __init__(self):
        r"""
        __init__(self) -> btkAcquisition

        Contains the data related to a biomechanical acquisition.

        A biomechanical acquisition can contains:
          - 3D data (makers, points, forces, moments, ...) ;
          - analog channels (force platform, emg, ...) ;
          - events
          - acquisition's setup ;
          - subject's informations.

        By default, the first frame is set to 1, the analog resolution is set to 12-bit, the maximum interpolation gap to 10 frames and the units are:
         - Marker: millimeters ;
         - Angle: degrees ;
         - Force: newtons ;
         - Moment: millimeter-newtons ;
         - Power: watts ;
         - Scalar: millimeters ;
         - Reaction: (nothing).

        After the creation of the acquisition, you should use the Init() method to populate the acquisition. 

        The member used for the maximum interpolation gap is only for information and is not used in the acquisition. It could be used later in a filter to fill gap.

        The analog resolution can be set to the following values:
         - btk.btkAcquisition.Bit8 ;
         - btk.btkAcquisition.Bit10 ;
         - btk.btkAcquisition.Bit12 ;
         - btk.btkAcquisition.Bit14 ;
         - btk.btkAcquisition.Bit16.
        """
        _btk.btkAcquisition_swiginit(self, _btk.new_btkAcquisition())

    def Clone(self):
        r"""
        Clone(self) -> btkAcquisition
        Deep copy of the object
        """
        return _btk.btkAcquisition_Clone(self)

    def __deref__(self):
        r"""__deref__(self) -> btkAcquisition_impl *"""
        return _btk.btkAcquisition___deref__(self)
    __swig_destroy__ = _btk.delete_btkAcquisition

    def BeginMetaData(self):
        r"""
        BeginMetaData(self) -> btkMetaDataIterator
        Returns an iterator to the beginning of the list of metadata.
        """
        return _btk.btkAcquisition_BeginMetaData(self)

    def EndMetaData(self):
        r"""
        EndMetaData(self) -> btkMetaDataIterator
        Returns an iterator just past the last metadata.
        """
        return _btk.btkAcquisition_EndMetaData(self)

    def GetMetaData(self):
        r"""
        GetMetaData(self) -> btkMetaData
        Returns the metadata.
        """
        return _btk.btkAcquisition_GetMetaData(self)

    def SetMetaData(self, arg2):
        r"""
        SetMetaData(self, btkMetaData)
        Sets the metadata of the acquisition.
        """
        return _btk.btkAcquisition_SetMetaData(self, arg2)

    def BeginEvent(self):
        r"""
        BeginEvent(self) -> btkEventCollectionIterator
        Returns an iterator to the beginning of the list of events.
        """
        return _btk.btkAcquisition_BeginEvent(self)

    def EndEvent(self):
        r"""
        EndEvent(self) -> btkEventCollectionIterator
        Returns a const iterator just past the last event.
        """
        return _btk.btkAcquisition_EndEvent(self)

    def GetEvent(self, arg2):
        r"""
        GetEvent(self, int) -> btkEvent
        Gets the event at the given index.
        """
        return _btk.btkAcquisition_GetEvent(self, arg2)

    def SetEvent(self, arg2, arg3):
        r"""
        SetEvent(self, int, btkEvent)
        Sets the content of event at the given index.
        """
        return _btk.btkAcquisition_SetEvent(self, arg2, arg3)

    def GetEvents(self):
        r"""
        GetEvents(self) -> btkEventCollection
        Returns the collection of events.
        """
        return _btk.btkAcquisition_GetEvents(self)

    def SetEvents(self, arg2):
        r"""
        SetEvents(self, btkEventCollection)
        Sets events for this acquisition.
        """
        return _btk.btkAcquisition_SetEvents(self, arg2)

    def IsEmptyEvent(self):
        r"""
        IsEmptyEvent(self) -> bool
        Checks if the events' list is empty.
        """
        return _btk.btkAcquisition_IsEmptyEvent(self)

    def GetEventNumber(self):
        r"""
        GetEventNumber(self) -> int
        Returns the number of events.
        """
        return _btk.btkAcquisition_GetEventNumber(self)

    def SetEventNumber(self, arg2):
        r"""
        SetEventNumber(self, int)
        Sets the number of events.
        """
        return _btk.btkAcquisition_SetEventNumber(self, arg2)

    def ClearEvents(self):
        r"""
        ClearEvents(self)
        Clear events.
        """
        return _btk.btkAcquisition_ClearEvents(self)

    def FindEvent(self, arg2):
        r"""
        FindEvent(self, string) -> btkEventIterator
        Finds the event with the proposed label and returns the iterator associated with it.
        If no event has the given label, an iterator pointing to the end of the collection is returned.
        """
        return _btk.btkAcquisition_FindEvent(self, arg2)

    def AppendEvent(self, arg2):
        r"""
        AppendEvent(self, btkEvent)
        Appends the given event in the acquisition.
        """
        return _btk.btkAcquisition_AppendEvent(self, arg2)

    def RemoveEvent(self, *args):
        r"""
        RemoveAnalog(self, int)RemoveEvent(self, btkEventCollectionIterator) -> btkEventCollectionIterator
        Removes the event associated with the given index or the given iterator.
        """
        return _btk.btkAcquisition_RemoveEvent(self, *args)

    def BeginPoint(self):
        r"""
        BeginPoint(self) -> btkPointCollectionIterator
        Returns an iterator to the beginning of the list of points.
        """
        return _btk.btkAcquisition_BeginPoint(self)

    def EndPoint(self):
        r"""
        EndPoint(self) -> btkPointCollectionIterator
        Returns an iterator just past the last point.
        """
        return _btk.btkAcquisition_EndPoint(self)

    def GetPoint(self, *args):
        r"""
        GetPoint(self, int) -> btkPointGetPoint(self, string) -> btkPoint
        Gets the point at the given index or label. If no Point exists, then an exception is thrown.
        """
        return _btk.btkAcquisition_GetPoint(self, *args)

    def SetPoint(self, arg2, arg3):
        r"""
        SetPoint(self, int, btkPoint)
        Sets the content of a point at the given index.
        """
        return _btk.btkAcquisition_SetPoint(self, arg2, arg3)

    def GetPoints(self):
        r"""
        GetPoints(self) -> btkPointCollection
        Returns the collection of points.
        """
        return _btk.btkAcquisition_GetPoints(self)

    def SetPoints(self, arg2):
        r"""
        SetPoints(self, btkPointCollection)
        Sets points for this acquisition.
        """
        return _btk.btkAcquisition_SetPoints(self, arg2)

    def IsEmptyPoint(self):
        r"""
        IsEmptyPoint(self) -> bool
        Checks if the points' list is empty.
        """
        return _btk.btkAcquisition_IsEmptyPoint(self)

    def GetPointNumber(self):
        r"""
        GetPointNumber(self) -> int
        Returns the number of points.
        """
        return _btk.btkAcquisition_GetPointNumber(self)

    def SetPointNumber(self, arg2):
        r"""
        SetPointNumber(self, int)
        Sets the number of points.
        """
        return _btk.btkAcquisition_SetPointNumber(self, arg2)

    def ClearPoints(self):
        r"""
        ClearPoints(self)
        Clear points.
        """
        return _btk.btkAcquisition_ClearPoints(self)

    def FindPoint(self, arg2):
        r"""
        FindPoint(self, string) -> btkPointIterator
        Finds the point with the proposed label and returns the iterator associated with it.
        If no point has the given label, an iterator pointing to the end of the collection is returned.
        """
        return _btk.btkAcquisition_FindPoint(self, arg2)

    def AppendPoint(self, arg2):
        r"""
        AppendPoint(self, btkPoint)
        Convenient method to append a point in the acquisition. This method also resizes the frame number of the inserted point if necessary.
        """
        return _btk.btkAcquisition_AppendPoint(self, arg2)

    def RemovePoint(self, *args):
        r"""
        RemovePoint(self, string)RemovePoint(self, int)RemovePoint(self, btkPointCollectionIterator) -> btkPointCollectionIterator
        Convenient method to delete a point from the acquisition.
        """
        return _btk.btkAcquisition_RemovePoint(self, *args)

    def BeginAnalog(self):
        r"""
        BeginAnalog(self) -> btkAnalogCollectionIterator
        Returns an iterator to the beginning of the list of analog channels.
        """
        return _btk.btkAcquisition_BeginAnalog(self)

    def EndAnalog(self):
        r"""
        EndAnalog(self) -> btkAnalogCollectionIterator
        Returns an iterator just past the last analog channel.
        """
        return _btk.btkAcquisition_EndAnalog(self)

    def IsEmptyAnalog(self):
        r"""
        IsEmptyAnalog(self) -> bool
        Checks if the analogs' list is empty.
        """
        return _btk.btkAcquisition_IsEmptyAnalog(self)

    def GetAnalogNumber(self):
        r"""
        GetAnalogNumber(self) -> int
        Returns the number of analog channels.
        """
        return _btk.btkAcquisition_GetAnalogNumber(self)

    def SetAnalogNumber(self, arg2):
        r"""
        SetAnalogNumber(self, int)
        Sets the number of analog channels.
        """
        return _btk.btkAcquisition_SetAnalogNumber(self, arg2)

    def GetAnalog(self, *args):
        r"""
        GetAnalog(self, int) -> btkAnalogGetAnalog(self, string) -> btkAnalog
        Gets the analog channel at the given index or label. If no Analog exists, then an exception is thrown.
        """
        return _btk.btkAcquisition_GetAnalog(self, *args)

    def SetAnalog(self, arg2, arg3):
        r"""
        SetAnalog(self, int, btkAnalog)
        Sets the analog channel at the given index by the content of the given analog channel.
        """
        return _btk.btkAcquisition_SetAnalog(self, arg2, arg3)

    def GetAnalogs(self):
        r"""
        GetAnalogs(self) -> btkAnalogCollection
        Returns the collection of analog channels.
        """
        return _btk.btkAcquisition_GetAnalogs(self)

    def SetAnalogs(self, arg2):
        r"""
        SetAnalogs(self, btkAnalogCollection)
        Sets analog channels for this acquisition.
        """
        return _btk.btkAcquisition_SetAnalogs(self, arg2)

    def ClearAnalogs(self):
        r"""
        ClearAnalogs(self)
        Clear analogs channels.
        """
        return _btk.btkAcquisition_ClearAnalogs(self)

    def FindAnalog(self, arg2):
        r"""
        FindAnalog(self, string) -> btkAnalogIterator
        Finds the analog channel with the proposed label and returns the iterator associated with it.
        If no analog channel has the given label, an iterator pointing to the end of the collection is returned.
        """
        return _btk.btkAcquisition_FindAnalog(self, arg2)

    def AppendAnalog(self, arg2):
        r"""
        AppendAnalog(self, btkAnalog)
        Append the analog channel ac in the acquisition This method also resizes the frame number of the inserted analog channel if necessary.
        """
        return _btk.btkAcquisition_AppendAnalog(self, arg2)

    def RemoveAnalog(self, *args):
        r"""
        RemoveAnalog(self, string)RemoveAnalog(self, int)RemoveAnalog(self, btkAnalogCollectionIterator) -> btkAnalogCollectionIterator
        Convenient method to delete an analog channel from the acquisition.
        """
        return _btk.btkAcquisition_RemoveAnalog(self, *args)

    def Init(self, arg2, arg3, analogNumber=0, analogSampleNumberPerPointFrame=1):
        r"""
        Init(self, pointNumber, frameNumber, analogNumber = 0, , analogSampleNumberPerPointFrame = 1)Init(self, pointNumber, frameNumber, analogNumber = 0)Init(self, pointNumber, frameNumber)
        Initialize the acquisition with the given number of point which have each the given number of frames.
        You can set also the number of analog channels and their number of frames corresponds to the given integer factor multiplied by the number of frames for the points.
        This method label added points and analog channels using the string 'uname*' concatenated with the index of the channel.
        """
        return _btk.btkAcquisition_Init(self, arg2, arg3, analogNumber, analogSampleNumberPerPointFrame)

    def Resize(self, arg2, arg3, analogNumber=0, analogSampleNumberPerPointFrame=1):
        r"""
        Resize(self, pointNumber, frameNumber, analogNumber = 0, , analogSampleNumberPerPointFrame = 1)Resize(self, pointNumber, frameNumber, analogNumber = 0)Resize(self, pointNumber, frameNumber)
        Resize the acquisition. Same as the method Init(), but does not label added points and analog channels
        """
        return _btk.btkAcquisition_Resize(self, arg2, arg3, analogNumber, analogSampleNumberPerPointFrame)

    def ResizePointNumber(self, arg2):
        r"""
        ResizePointNumber(self, int)
        Resize the number of points.
        """
        return _btk.btkAcquisition_ResizePointNumber(self, arg2)

    def ResizeAnalogNumber(self, arg2):
        r"""
        ResizeAnalogNumber(self, int)
        Resize the number of analog channels.
        """
        return _btk.btkAcquisition_ResizeAnalogNumber(self, arg2)

    def ResizeFrameNumber(self, arg2):
        r"""
        ResizeFrameNumber(self, int)
        Resize the number of frames.
        """
        return _btk.btkAcquisition_ResizeFrameNumber(self, arg2)

    def ResizeFrameNumberFromEnd(self, arg2):
        r"""
        ResizeFrameNumberFromEnd(self, int)
        Resize the number of frames by adding new (or removing) frames at the beginning of the acquisition and set automatically the new first frame index.
        """
        return _btk.btkAcquisition_ResizeFrameNumberFromEnd(self, arg2)

    def Reset(self):
        r"""
        Reset(self)
        Resets the acquisition as an empty acquisition.
        To re-populate this acquisition, you need to re-use the Init() method to set the point and analog number and their frame number.
        """
        return _btk.btkAcquisition_Reset(self)

    def GetDuration(self):
        r"""
        GetDuration(self) -> double
        Returns the duration of the acquisition. The duration is computed as the multiplication of the points' frequency with the points frame number.
        """
        return _btk.btkAcquisition_GetDuration(self)

    def GetFirstFrame(self):
        r"""
        GetFirstFrame(self) -> int
        Return the first frame index of the acquisition.
        """
        return _btk.btkAcquisition_GetFirstFrame(self)

    def SetFirstFrame(self, arg2, adaptEvents=False):
        r"""
        SetFirstFrame(self, int, adaptEvents)SetFirstFrame(self, int)
        Sets the first frame index. If the third argument is given and set to true, then events' frame/time will be shifted by the difference between the new first frame and the old one.
        """
        return _btk.btkAcquisition_SetFirstFrame(self, arg2, adaptEvents)

    def GetLastFrame(self):
        r"""
        GetLastFrame(self) -> int
        Returns the last frame index of the acquisition base on the first frame index and the frame number.
        """
        return _btk.btkAcquisition_GetLastFrame(self)

    def GetPointUnit(self, *args):
        r"""
        GetPointUnit(self) -> std::string const
        GetPointUnit(self, arg2) -> std::string const
        Returns the unit for points which have the given type.
        """
        return _btk.btkAcquisition_GetPointUnit(self, *args)

    def SetPointUnit(self, *args):
        r"""
        SetPointUnit(self, units="mm")
        SetPointUnit(self, arg2, arg3)
        Sets the point's unit for the given point's type. The type btk.btkPoint.Reaction cannot have any unit. You cannot set it.
        """
        return _btk.btkAcquisition_SetPointUnit(self, *args)

    def GetPointFrameNumber(self):
        r"""
        GetPointFrameNumber(self) -> int
        Returns the number of frames for the points.
        """
        return _btk.btkAcquisition_GetPointFrameNumber(self)

    def GetPointFrequency(self):
        r"""
        GetPointFrequency(self) -> double
        Returns the point's frequency.
        """
        return _btk.btkAcquisition_GetPointFrequency(self)

    def SetPointFrequency(self, arg2):
        r"""
        SetPointFrequency(self, double)
        Sets the points sample rate.
        """
        return _btk.btkAcquisition_SetPointFrequency(self, arg2)

    def GetAnalogFrameNumber(self):
        r"""
        GetAnalogFrameNumber(self) -> int
        Returns the number of frames for the analog channels.
        """
        return _btk.btkAcquisition_GetAnalogFrameNumber(self)

    def GetNumberAnalogSamplePerFrame(self):
        r"""
        GetNumberAnalogSamplePerFrame(self) -> int
        Returns the number of analog sample (acquired by each channel) per point frame.
        """
        return _btk.btkAcquisition_GetNumberAnalogSamplePerFrame(self)

    def GetAnalogFrequency(self):
        r"""
        GetAnalogFrequency(self) -> double
        Returns the analogs sample rate.
        """
        return _btk.btkAcquisition_GetAnalogFrequency(self)

    def GetAnalogResolution(self):
        r"""
        GetAnalogResolution(self) -> btk.btkAcquisition.AnalogResolution
        Returns the analog resolution.
        """
        return _btk.btkAcquisition_GetAnalogResolution(self)

    def SetAnalogResolution(self, r):
        r"""
        SetAnalogResolution(self, btk.btkAcquisition.AnalogResolution)
        Sets the analog resolution.
        """
        return _btk.btkAcquisition_SetAnalogResolution(self, r)

    def GetMaxInterpolationGap(self):
        r"""
        GetMaxInterpolationGap(self) -> int
        Gets the maximum gap length that any interpolation method would fill for the 3D point data.
        Warning: Only for information. Could be use later by a filter to fill gap 3D trajectories.
        """
        return _btk.btkAcquisition_GetMaxInterpolationGap(self)

    def SetMaxInterpolationGap(self, gap):
        r"""
        SetMaxInterpolationGap(self, int)
        Sets the maximum gap length that any interpolation method would fill for the 3D point data.
        Warning: Only for information. Could be use later by a filter to fill gap 3D trajectories.
        """
        return _btk.btkAcquisition_SetMaxInterpolationGap(self, gap)

    def Update(self):
        r"""
        Update(self)
        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkAcquisition_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkAcquisition_GetTimestamp(self)

# Register btkAcquisition in _btk:
_btk.btkAcquisition_swigregister(btkAcquisition)

class btkAcquisitionFileIO(object):
    r"""

    Interface to read/write acquisition's files, cannot be instanced.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    TypeNotApplicable = _btk.btkAcquisitionFileIO_TypeNotApplicable
    
    ASCII = _btk.btkAcquisitionFileIO_ASCII
    
    Binary = _btk.btkAcquisitionFileIO_Binary
    
    OrderNotApplicable = _btk.btkAcquisitionFileIO_OrderNotApplicable
    
    IEEE_LittleEndian = _btk.btkAcquisitionFileIO_IEEE_LittleEndian
    
    VAX_LittleEndian = _btk.btkAcquisitionFileIO_VAX_LittleEndian
    
    IEEE_BigEndian = _btk.btkAcquisitionFileIO_IEEE_BigEndian
    
    StorageNotApplicable = _btk.btkAcquisitionFileIO_StorageNotApplicable
    
    Float = _btk.btkAcquisitionFileIO_Float
    
    Integer = _btk.btkAcquisitionFileIO_Integer
    
    UpdateNotApplicable = _btk.btkAcquisitionFileIO_UpdateNotApplicable
    
    NoUpdate = _btk.btkAcquisitionFileIO_NoUpdate
    
    DataBasedUpdate = _btk.btkAcquisitionFileIO_DataBasedUpdate
    
    MetaDataBasedUpdate = _btk.btkAcquisitionFileIO_MetaDataBasedUpdate
    
    FileFormatOption = _btk.btkAcquisitionFileIO_FileFormatOption
    

    def __init__(self, toCopy):
        r"""
        __init__(self, toCopy) -> btkAcquisitionFileIO

        Interface to read/write acquisition's files, cannot be instanced.
        """
        _btk.btkAcquisitionFileIO_swiginit(self, _btk.new_btkAcquisitionFileIO(toCopy))

    def __deref__(self):
        r"""__deref__(self) -> btkAcquisitionFileIO_impl *"""
        return _btk.btkAcquisitionFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkAcquisitionFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkAcquisitionFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkAcquisitionFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkAcquisitionFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkAcquisitionFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkAcquisitionFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkAcquisitionFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkAcquisitionFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkAcquisitionFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkAcquisitionFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkAcquisitionFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkAcquisitionFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkAcquisitionFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkAcquisitionFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkAcquisitionFileIO_Write(self, filename, input)

# Register btkAcquisitionFileIO in _btk:
_btk.btkAcquisitionFileIO_swigregister(btkAcquisitionFileIO)

class btkAcquisitionFileReader(object):
    r"""

    Reader for files which contain acquisition data (C3D, TRC, ...).

    This class uses a btkAcquisitionFileIO object to read the data from the file corresponding to the given filename.
    You have two ways to set this object.
    First, you can set it manually by using the method btkAcquisitionFileReader::SetAcquisitionIO(),
    Second, the correct object can be detected automatically, by checking in each registered btkAcquisitionFileIO if it can read or not the file.

    The use of the manual setting should be only used if you want to read a file with a selected file format. To go back to the automatic mode 
    from the manual mode, you only have to use the method btkAcquisitionFileReader::SetAcquisitionIO() without any argument.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkAcquisitionFileReader

        Reader for files which contain acquisition data (C3D, TRC, ...).

        This class uses a btkAcquisitionFileIO object to read the data from the file corresponding to the given filename.
        You have two ways to set this object.
        First, you can set it manually by using the method btkAcquisitionFileReader::SetAcquisitionIO(),
        Second, the correct object can be detected automatically, by checking in each registered btkAcquisitionFileIO if it can read or not the file.

        The use of the manual setting should be only used if you want to read a file with a selected file format. To go back to the automatic mode 
        from the manual mode, you only have to use the method btkAcquisitionFileReader::SetAcquisitionIO() without any argument.
        """
        _btk.btkAcquisitionFileReader_swiginit(self, _btk.new_btkAcquisitionFileReader())

    def __deref__(self):
        r"""__deref__(self) -> btkAcquisitionFileReader_impl *"""
        return _btk.btkAcquisitionFileReader___deref__(self)

    def GetAcquisitionIO(self):
        r"""
        GetAcquisitionIO(self) -> btkAcquisitionFileIO
        Returns the btkAcquisitionIO used to read the given file.
        """
        return _btk.btkAcquisitionFileReader_GetAcquisitionIO(self)

    def _reset(self):
        r"""_reset(self)"""
        return _btk.btkAcquisitionFileReader__reset(self)
    __swig_destroy__ = _btk.delete_btkAcquisitionFileReader

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkAcquisition
        Returns the btkAcquisition read from the btkAcquisitionIO helper class.
        """
        return _btk.btkAcquisitionFileReader_GetOutput(self)

    def GetDisableFilenameExceptionState(self):
        r"""
        GetDisableFilenameExceptionState(self) -> bool
        Returns state of the disabling of the exception for missing filename.
        """
        return _btk.btkAcquisitionFileReader_GetDisableFilenameExceptionState(self)

    def SetDisableFilenameExceptionState(self, arg2):
        r"""
        SetDisableFilenameExceptionState(self, bool)
        Enable/disable exception for the missing of the filename.
        """
        return _btk.btkAcquisitionFileReader_SetDisableFilenameExceptionState(self, arg2)

    def GetFilename(self):
        r"""
        GetFilename(self) -> std::string const &
        Gets the filename of the file to read.
        """
        return _btk.btkAcquisitionFileReader_GetFilename(self)

    def SetFilename(self, arg2):
        r"""
        SetFilename(self, string)
        Specifies the file to read. This is forwarded to the IO instance.
        """
        return _btk.btkAcquisitionFileReader_SetFilename(self, arg2)

    def SetAcquisitionIO(self, *args):
        r"""
        SetAcquisitionIO(self, io=btkAcquisitionFileIO())
        Set the btkAcquisitionIO helper class. This method forces the btkAcquisitionIO to be used to read a particular file.
        The btkAcquisitionIO is ofently created via the object factory mechanism that determines whether a particular btkAcquisitionIO can read a certain file.
        """
        return _btk.btkAcquisitionFileReader_SetAcquisitionIO(self, *args)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkAcquisitionFileReader_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkAcquisitionFileReader_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkAcquisitionFileReader_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkAcquisitionFileReader_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkAcquisitionFileReader_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkAcquisitionFileReader_GetTimestamp(self)

# Register btkAcquisitionFileReader in _btk:
_btk.btkAcquisitionFileReader_swigregister(btkAcquisitionFileReader)

class btkAcquisitionFileWriter(object):
    r"""

    Writer of acquisition data into acquisition file (C3D, TRC, ...).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkAcquisitionFileWriter

        Writer of acquisition data into acquisition file (C3D, TRC, ...).
        """
        _btk.btkAcquisitionFileWriter_swiginit(self, _btk.new_btkAcquisitionFileWriter())

    def __deref__(self):
        r"""__deref__(self) -> btkAcquisitionFileWriter_impl *"""
        return _btk.btkAcquisitionFileWriter___deref__(self)

    def GetAcquisitionIO(self):
        r"""
        GetAcquisitionIO(self) -> btkAcquisitionFileIO
        Returns the btkAcquisitionIO used to write the given acquisition
        """
        return _btk.btkAcquisitionFileWriter_GetAcquisitionIO(self)
    __swig_destroy__ = _btk.delete_btkAcquisitionFileWriter

    def GetInput(self):
        r"""
        GetInput(self) -> btkAcquisition
        Returns the btkAcquisition to write by a btkAcquisitionIO helper class
        """
        return _btk.btkAcquisitionFileWriter_GetInput(self)

    def SetInput(self, arg2):
        r"""
        SetInput(self, arg2)
        Sets the btkAcquisition to write by a btkAcquisitionIO helper class
        """
        return _btk.btkAcquisitionFileWriter_SetInput(self, arg2)

    def GetFilename(self):
        r"""
        GetFilename(self) -> std::string const &
        Gets the filename of the file to write.
        """
        return _btk.btkAcquisitionFileWriter_GetFilename(self)

    def SetFilename(self, arg2):
        r"""
        SetFilename(self, arg2)
        Specifies the file to write. This is forwarded to the IO instance.
        """
        return _btk.btkAcquisitionFileWriter_SetFilename(self, arg2)

    def SetAcquisitionIO(self, *args):
        r"""
        SetAcquisitionIO(self, io=btkAcquisitionFileIO())
        Set the btkAcquisitionIO helper class. This method forces the btkAcquisitionIO to be used to write a particular file.
        The btkAcquisitionIO is ofently created via the object factory mechanism that determines whether a particular btkAcquisitionIO can write a certain file
        """
        return _btk.btkAcquisitionFileWriter_SetAcquisitionIO(self, *args)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkAcquisitionFileWriter_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkAcquisitionFileWriter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkAcquisitionFileWriter_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkAcquisitionFileWriter_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkAcquisitionFileWriter_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkAcquisitionFileWriter_GetTimestamp(self)

# Register btkAcquisitionFileWriter in _btk:
_btk.btkAcquisitionFileWriter_swigregister(btkAcquisitionFileWriter)

class btkC3DFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read/write C3D files.

    All the informations related to the acquisition are stored in the output object.
    Few data, like the byte order, the points' scale, the analog universal scale, the integer analog storage format are 
    available as member of this class. These informations are extracted when a C3D file is read or can be 
    filled/modified to write a new C3D file. All these members can be accessed or modified using dedicated methods.

    Compared to the C3DServer API, all the data in BTK extracted from a C3D file are already scaled and available in the 
    children of the output Acquisition. You don't need to access to the groups/parameters for that. However, if you have 
    some custom parameters, then you can access them from the metadata stored in the output Acquisition using the method 
    btkAcquisition::GetMetadata().

    Moreover, there are several options to create a C3D file from an acquisition:
     - DataBasedUpdate;
     - MetaDataBasedUpdate;
     - CompatibleVicon.

    By default, the writer is set with the options ScalesFromDataUpdate, MetaDataFromDataUpdate and CompatibleVicon.
    These options give you the possibility to create a C3D file from any kind of acquisition (created from raw or extracted from another file format).

    To write a C3D file with a given processor architecture (called byte order in BTK), you have to use the method btkC3DFileIO::SetByteOrder().

    For more informations on this file's format: http:://www.c3d.org
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Signed = _btk.btkC3DFileIO_Signed
    
    Unsigned = _btk.btkC3DFileIO_Unsigned
    
    CompatibleVicon = _btk.btkC3DFileIO_CompatibleVicon
    

    def __init__(self, *args):
        r"""
        __init__(self) -> btkC3DFileIO
        __init__(self, toCopy) -> btkC3DFileIO

        Interface to read/write C3D files.

        All the informations related to the acquisition are stored in the output object.
        Few data, like the byte order, the points' scale, the analog universal scale, the integer analog storage format are 
        available as member of this class. These informations are extracted when a C3D file is read or can be 
        filled/modified to write a new C3D file. All these members can be accessed or modified using dedicated methods.

        Compared to the C3DServer API, all the data in BTK extracted from a C3D file are already scaled and available in the 
        children of the output Acquisition. You don't need to access to the groups/parameters for that. However, if you have 
        some custom parameters, then you can access them from the metadata stored in the output Acquisition using the method 
        btkAcquisition::GetMetadata().

        Moreover, there are several options to create a C3D file from an acquisition:
         - DataBasedUpdate;
         - MetaDataBasedUpdate;
         - CompatibleVicon.

        By default, the writer is set with the options ScalesFromDataUpdate, MetaDataFromDataUpdate and CompatibleVicon.
        These options give you the possibility to create a C3D file from any kind of acquisition (created from raw or extracted from another file format).

        To write a C3D file with a given processor architecture (called byte order in BTK), you have to use the method btkC3DFileIO::SetByteOrder().

        For more informations on this file's format: http:://www.c3d.org
        """
        _btk.btkC3DFileIO_swiginit(self, _btk.new_btkC3DFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkC3DFileIO_impl *"""
        return _btk.btkC3DFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkC3DFileIO

    def GetPointScale(self):
        r"""
        GetPointScale(self) -> double
        Returns the scale for the points obtains from the POINT:SCALE parameter or from its determination for a created acquisition.
        """
        return _btk.btkC3DFileIO_GetPointScale(self)

    def SetPointScale(self, arg2):
        r"""
        SetPointScale(self, arg2)
        Sets the scale for the points.
        """
        return _btk.btkC3DFileIO_SetPointScale(self, arg2)

    def GetAnalogIntegerFormat(self):
        r"""
        GetAnalogIntegerFormat(self) -> btkC3DFileIO_impl::AnalogIntegerFormat
        Return the integer format (signed/unsigned).
        """
        return _btk.btkC3DFileIO_GetAnalogIntegerFormat(self)

    def SetAnalogIntegerFormat(self, arg2):
        r"""
        SetAnalogIntegerFormat(self, arg2)
        Sets the integer format used to store analog channels data.
        """
        return _btk.btkC3DFileIO_SetAnalogIntegerFormat(self, arg2)

    def GetAnalogChannelScale(self):
        r"""
        GetAnalogChannelScale(self) -> btkDoubleArray
        Returns the vector of scales used for the analog channels' scaling (parameter ANALOG:SCALE).
        """
        return _btk.btkC3DFileIO_GetAnalogChannelScale(self)

    def SetAnalogChannelScale(self, arg2):
        r"""
        SetAnalogChannelScale(self, arg2)
        Sets the vector of scales used for the analog channels' scaling.
        """
        return _btk.btkC3DFileIO_SetAnalogChannelScale(self, arg2)

    def GetAnalogZeroOffset(self):
        r"""
        GetAnalogZeroOffset(self) -> btkDoubleArray
        Returns the vector of offsets used for the analog channels' scaling (parameter ANALOG:OFFSET).
        """
        return _btk.btkC3DFileIO_GetAnalogZeroOffset(self)

    def SetAnalogZeroOffset(self, arg2):
        r"""
        SetAnalogZeroOffset(self, arg2)
        Sets the vector of offsets used for the analog channels' scaling.
        """
        return _btk.btkC3DFileIO_SetAnalogZeroOffset(self, arg2)

    def GetAnalogUniversalScale(self):
        r"""
        GetAnalogUniversalScale(self) -> double
        Returns the universal scale factor used to scale analog channels (parameter ANALOG:GEN_SCALE).
        """
        return _btk.btkC3DFileIO_GetAnalogUniversalScale(self)

    def SetAnalogUniversalScale(self, arg2):
        r"""
        SetAnalogUniversalScale(self, arg2)
        Sets Returns the universal scale factor used to scale analog channels.
        """
        return _btk.btkC3DFileIO_SetAnalogUniversalScale(self, arg2)

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkC3DFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkC3DFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkC3DFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkC3DFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkC3DFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkC3DFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkC3DFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkC3DFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkC3DFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkC3DFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkC3DFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkC3DFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkC3DFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkC3DFileIO_Write(self, filename, input)

# Register btkC3DFileIO in _btk:
_btk.btkC3DFileIO_swigregister(btkC3DFileIO)

class btkANBFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read/write ANB files (Motion Analysis Corp.).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkANBFileIO
        __init__(self, toCopy) -> btkANBFileIO

        Interface to read/write ANB files (Motion Analysis Corp.).
        """
        _btk.btkANBFileIO_swiginit(self, _btk.new_btkANBFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkANBFileIO_impl *"""
        return _btk.btkANBFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkANBFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkANBFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkANBFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkANBFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkANBFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkANBFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkANBFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkANBFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkANBFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkANBFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkANBFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkANBFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkANBFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkANBFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkANBFileIO_Write(self, filename, input)

# Register btkANBFileIO in _btk:
_btk.btkANBFileIO_swigregister(btkANBFileIO)

class btkANCFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read/write ANC files (Motion Analysis Corp.).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkANCFileIO
        __init__(self, toCopy) -> btkANCFileIO

        Interface to read/write ANC files (Motion Analysis Corp.).
        """
        _btk.btkANCFileIO_swiginit(self, _btk.new_btkANCFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkANCFileIO_impl *"""
        return _btk.btkANCFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkANCFileIO

    def GetFileGeneration(self):
        r"""
        GetFileGeneration(self) -> int
        Returns the generation of the ANC file.
        """
        return _btk.btkANCFileIO_GetFileGeneration(self)

    def SetFileGeneration(self, gen):
        r"""
        SetFileGeneration(self, gen)
        Set the generation of the ANC file.
        """
        return _btk.btkANCFileIO_SetFileGeneration(self, gen)

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkANCFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkANCFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkANCFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkANCFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkANCFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkANCFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkANCFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkANCFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkANCFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkANCFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkANCFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkANCFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkANCFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkANCFileIO_Write(self, filename, input)

# Register btkANCFileIO in _btk:
_btk.btkANCFileIO_swigregister(btkANCFileIO)

class btkANGFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read ANG files (Elite - BTS Bioengineering).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkANGFileIO
        __init__(self, toCopy) -> btkANGFileIO

        Interface to read ANG files (Elite - BTS Bioengineering).
        """
        _btk.btkANGFileIO_swiginit(self, _btk.new_btkANGFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkANGFileIO_impl *"""
        return _btk.btkANGFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkANGFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkANGFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkANGFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkANGFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkANGFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkANGFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkANGFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkANGFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkANGFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkANGFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkANGFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkANGFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkANGFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkANGFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkANGFileIO_Write(self, filename, input)

# Register btkANGFileIO in _btk:
_btk.btkANGFileIO_swigregister(btkANGFileIO)

class btkCALForcePlateFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read/write force platform calibration CAL files (Motion Analysis Corp.).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkCALForcePlateFileIO
        __init__(self, toCopy) -> btkCALForcePlateFileIO

        Interface to read/write force platform calibration CAL files (Motion Analysis Corp.).
        """
        _btk.btkCALForcePlateFileIO_swiginit(self, _btk.new_btkCALForcePlateFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkCALForcePlateFileIO_impl *"""
        return _btk.btkCALForcePlateFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkCALForcePlateFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkCALForcePlateFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkCALForcePlateFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkCALForcePlateFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkCALForcePlateFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkCALForcePlateFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkCALForcePlateFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkCALForcePlateFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkCALForcePlateFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkCALForcePlateFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkCALForcePlateFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkCALForcePlateFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkCALForcePlateFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkCALForcePlateFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkCALForcePlateFileIO_Write(self, filename, input)

# Register btkCALForcePlateFileIO in _btk:
_btk.btkCALForcePlateFileIO_swigregister(btkCALForcePlateFileIO)

class btkCLBFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read CLB files (Contec Inc.).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkCLBFileIO
        __init__(self, toCopy) -> btkCLBFileIO

        Interface to read CLB files (Contec Inc.).
        """
        _btk.btkCLBFileIO_swiginit(self, _btk.new_btkCLBFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkCLBFileIO_impl *"""
        return _btk.btkCLBFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkCLBFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkCLBFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkCLBFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkCLBFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkCLBFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkCLBFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkCLBFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkCLBFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkCLBFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkCLBFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkCLBFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkCLBFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkCLBFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkCLBFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkCLBFileIO_Write(self, filename, input)

# Register btkCLBFileIO in _btk:
_btk.btkCLBFileIO_swigregister(btkCLBFileIO)

class btkDelsysEMGFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read EMG file (Delsys Inc.).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkDelsysEMGFileIO
        __init__(self, toCopy) -> btkDelsysEMGFileIO

        Interface to read EMG file (Delsys Inc.).
        """
        _btk.btkDelsysEMGFileIO_swiginit(self, _btk.new_btkDelsysEMGFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkDelsysEMGFileIO_impl *"""
        return _btk.btkDelsysEMGFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkDelsysEMGFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkDelsysEMGFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkDelsysEMGFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkDelsysEMGFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkDelsysEMGFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkDelsysEMGFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkDelsysEMGFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkDelsysEMGFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkDelsysEMGFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkDelsysEMGFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkDelsysEMGFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkDelsysEMGFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkDelsysEMGFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkDelsysEMGFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkDelsysEMGFileIO_Write(self, filename, input)

# Register btkDelsysEMGFileIO in _btk:
_btk.btkDelsysEMGFileIO_swigregister(btkDelsysEMGFileIO)

class btkMDFFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read MDF files (Codamotion).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkMDFFileIO
        __init__(self, toCopy) -> btkMDFFileIO

        Interface to read MDF files (Codamotion).
        """
        _btk.btkMDFFileIO_swiginit(self, _btk.new_btkMDFFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkMDFFileIO_impl *"""
        return _btk.btkMDFFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkMDFFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkMDFFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkMDFFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkMDFFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkMDFFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkMDFFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkMDFFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkMDFFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkMDFFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkMDFFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkMDFFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkMDFFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkMDFFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkMDFFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkMDFFileIO_Write(self, filename, input)

# Register btkMDFFileIO in _btk:
_btk.btkMDFFileIO_swigregister(btkMDFFileIO)

class btkEMFFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read EMF files (Ascension Technology Corporation).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkEMFFileIO
        __init__(self, toCopy) -> btkEMFFileIO

        Interface to read EMF files (Ascension Technology Corporation).
        """
        _btk.btkEMFFileIO_swiginit(self, _btk.new_btkEMFFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkEMFFileIO_impl *"""
        return _btk.btkEMFFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkEMFFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkEMFFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkEMFFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkEMFFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkEMFFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkEMFFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkEMFFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkEMFFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkEMFFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkEMFFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkEMFFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkEMFFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkEMFFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkEMFFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkEMFFileIO_Write(self, filename, input)

# Register btkEMFFileIO in _btk:
_btk.btkEMFFileIO_swigregister(btkEMFFileIO)

class btkEMxFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read EMG files (Elite - BTS Bioengineering).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkEMxFileIO
        __init__(self, toCopy) -> btkEMxFileIO

        Interface to read EMG files (Elite - BTS Bioengineering).
        """
        _btk.btkEMxFileIO_swiginit(self, _btk.new_btkEMxFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkEMxFileIO_impl *"""
        return _btk.btkEMxFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkEMxFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkEMxFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkEMxFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkEMxFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkEMxFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkEMxFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkEMxFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkEMxFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkEMxFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkEMxFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkEMxFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkEMxFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkEMxFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkEMxFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkEMxFileIO_Write(self, filename, input)

# Register btkEMxFileIO in _btk:
_btk.btkEMxFileIO_swigregister(btkEMxFileIO)

class btkGRxFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read GR* (GR1, GR2, ...) files (Elite - BTS Bioengineering).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkGRxFileIO
        __init__(self, toCopy) -> btkGRxFileIO

        Interface to read GR* (GR1, GR2, ...) files (Elite - BTS Bioengineering).
        """
        _btk.btkGRxFileIO_swiginit(self, _btk.new_btkGRxFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkGRxFileIO_impl *"""
        return _btk.btkGRxFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkGRxFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkGRxFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkGRxFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkGRxFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkGRxFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkGRxFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkGRxFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkGRxFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkGRxFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkGRxFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkGRxFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkGRxFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkGRxFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkGRxFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkGRxFileIO_Write(self, filename, input)

# Register btkGRxFileIO in _btk:
_btk.btkGRxFileIO_swigregister(btkGRxFileIO)

class btkMOMFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read MOM files (Elite - BTS Bioengineering).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkMOMFileIO
        __init__(self, toCopy) -> btkMOMFileIO

        Interface to read MOM files (Elite - BTS Bioengineering).
        """
        _btk.btkMOMFileIO_swiginit(self, _btk.new_btkMOMFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkMOMFileIO_impl *"""
        return _btk.btkMOMFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkMOMFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkMOMFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkMOMFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkMOMFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkMOMFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkMOMFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkMOMFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkMOMFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkMOMFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkMOMFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkMOMFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkMOMFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkMOMFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkMOMFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkMOMFileIO_Write(self, filename, input)

# Register btkMOMFileIO in _btk:
_btk.btkMOMFileIO_swigregister(btkMOMFileIO)

class btkPWRFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read PWR files (Elite - BTS Bioengineering).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkPWRFileIO
        __init__(self, toCopy) -> btkPWRFileIO

        Interface to read PWR files (Elite - BTS Bioengineering).
        """
        _btk.btkPWRFileIO_swiginit(self, _btk.new_btkPWRFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkPWRFileIO_impl *"""
        return _btk.btkPWRFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkPWRFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkPWRFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkPWRFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkPWRFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkPWRFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkPWRFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkPWRFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkPWRFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkPWRFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkPWRFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkPWRFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkPWRFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkPWRFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkPWRFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkPWRFileIO_Write(self, filename, input)

# Register btkPWRFileIO in _btk:
_btk.btkPWRFileIO_swigregister(btkPWRFileIO)

class btkRAxFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read RAW, RAH files (Elite - BTS Bioengineering).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkRAxFileIO
        __init__(self, toCopy) -> btkRAxFileIO

        Interface to read RAW, RAH files (Elite - BTS Bioengineering).
        """
        _btk.btkRAxFileIO_swiginit(self, _btk.new_btkRAxFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkRAxFileIO_impl *"""
        return _btk.btkRAxFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkRAxFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkRAxFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkRAxFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkRAxFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkRAxFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkRAxFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkRAxFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkRAxFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkRAxFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkRAxFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkRAxFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkRAxFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkRAxFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkRAxFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkRAxFileIO_Write(self, filename, input)

# Register btkRAxFileIO in _btk:
_btk.btkRAxFileIO_swigregister(btkRAxFileIO)

class btkRICFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read RIC files (Elite - BTS Bioengineering).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkRICFileIO
        __init__(self, toCopy) -> btkRICFileIO

        Interface to read RIC files (Elite - BTS Bioengineering).
        """
        _btk.btkRICFileIO_swiginit(self, _btk.new_btkRICFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkRICFileIO_impl *"""
        return _btk.btkRICFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkRICFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkRICFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkRICFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkRICFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkRICFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkRICFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkRICFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkRICFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkRICFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkRICFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkRICFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkRICFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkRICFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkRICFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkRICFileIO_Write(self, filename, input)

# Register btkRICFileIO in _btk:
_btk.btkRICFileIO_swigregister(btkRICFileIO)

class btkTDFFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read TDF files (BTS Bioengineering).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkTDFFileIO
        __init__(self, toCopy) -> btkTDFFileIO

        Interface to read TDF files (BTS Bioengineering).
        """
        _btk.btkTDFFileIO_swiginit(self, _btk.new_btkTDFFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkTDFFileIO_impl *"""
        return _btk.btkTDFFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkTDFFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkTDFFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkTDFFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkTDFFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkTDFFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkTDFFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkTDFFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkTDFFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkTDFFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkTDFFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkTDFFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkTDFFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkTDFFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkTDFFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkTDFFileIO_Write(self, filename, input)

# Register btkTDFFileIO in _btk:
_btk.btkTDFFileIO_swigregister(btkTDFFileIO)

class btkTRBFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read/write TRB files (Motion Analysis Corp.).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkTRBFileIO
        __init__(self, toCopy) -> btkTRBFileIO

        Interface to read/write TRB files (Motion Analysis Corp.).
        """
        _btk.btkTRBFileIO_swiginit(self, _btk.new_btkTRBFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkTRBFileIO_impl *"""
        return _btk.btkTRBFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkTRBFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkTRBFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkTRBFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkTRBFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkTRBFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkTRBFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkTRBFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkTRBFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkTRBFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkTRBFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkTRBFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkTRBFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkTRBFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkTRBFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkTRBFileIO_Write(self, filename, input)

# Register btkTRBFileIO in _btk:
_btk.btkTRBFileIO_swigregister(btkTRBFileIO)

class btkTRCFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read/write TRC files (Motion Analysis Corp.).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkTRCFileIO
        __init__(self, toCopy) -> btkTRCFileIO

        Interface to read/write TRC files (Motion Analysis Corp.).
        """
        _btk.btkTRCFileIO_swiginit(self, _btk.new_btkTRCFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkTRCFileIO_impl *"""
        return _btk.btkTRCFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkTRCFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkTRCFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkTRCFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkTRCFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkTRCFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkTRCFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkTRCFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkTRCFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkTRCFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkTRCFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkTRCFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkTRCFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkTRCFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkTRCFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkTRCFileIO_Write(self, filename, input)

# Register btkTRCFileIO in _btk:
_btk.btkTRCFileIO_swigregister(btkTRCFileIO)

class btkXLSOrthoTrakFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read XLS OrthoTrak files (Motion Analysis Corp.).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkXLSOrthoTrakFileIO
        __init__(self, toCopy) -> btkXLSOrthoTrakFileIO

        Interface to read XLS OrthoTrak files (Motion Analysis Corp.).
        """
        _btk.btkXLSOrthoTrakFileIO_swiginit(self, _btk.new_btkXLSOrthoTrakFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkXLSOrthoTrakFileIO_impl *"""
        return _btk.btkXLSOrthoTrakFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkXLSOrthoTrakFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkXLSOrthoTrakFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkXLSOrthoTrakFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkXLSOrthoTrakFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkXLSOrthoTrakFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkXLSOrthoTrakFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkXLSOrthoTrakFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkXLSOrthoTrakFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkXLSOrthoTrakFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkXLSOrthoTrakFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkXLSOrthoTrakFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkXLSOrthoTrakFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkXLSOrthoTrakFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkXLSOrthoTrakFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkXLSOrthoTrakFileIO_Write(self, filename, input)

# Register btkXLSOrthoTrakFileIO in _btk:
_btk.btkXLSOrthoTrakFileIO_swigregister(btkXLSOrthoTrakFileIO)

class btkXMOVEFileIO(btkAcquisitionFileIO):
    r"""

    Interface to read XMOVE files (Codamotion).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> btkXMOVEFileIO
        __init__(self, toCopy) -> btkXMOVEFileIO

        Interface to read XMOVE files (Codamotion).
        """
        _btk.btkXMOVEFileIO_swiginit(self, _btk.new_btkXMOVEFileIO(*args))

    def __deref__(self):
        r"""__deref__(self) -> btkXMOVEFileIO_impl *"""
        return _btk.btkXMOVEFileIO___deref__(self)
    __swig_destroy__ = _btk.delete_btkXMOVEFileIO

    def GetFileType(self):
        r"""
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType
        Gets the type of the file.
        """
        return _btk.btkXMOVEFileIO_GetFileType(self)

    def GetByteOrder(self):
        r"""
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder
        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkXMOVEFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        r"""
        GetByteOrderAsString(self) -> std::string
        Gets the byte order as a string.
        """
        return _btk.btkXMOVEFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, b):
        r"""
        SetByteOrder(self, b)
        Sets the byte order of the file.
        """
        return _btk.btkXMOVEFileIO_SetByteOrder(self, b)

    def GetStorageFormat(self):
        r"""
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat
        Return the format used to store points and analog channels.
        """
        return _btk.btkXMOVEFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        r"""
        GetStorageFormatAsString(self) -> std::string
        Gets the storage format as a string.
        """
        return _btk.btkXMOVEFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, s):
        r"""
        SetStorageFormat(self, s)
        Set the format used to store points and analog channels.
        """
        return _btk.btkXMOVEFileIO_SetStorageFormat(self, s)

    def GetInternalsUpdateOptions(self):
        r"""
        GetInternalsUpdateOptions(self) -> int
        Returns the option(s) used to update internals.
        """
        return _btk.btkXMOVEFileIO_GetInternalsUpdateOptions(self)

    def SetInternalsUpdateOptions(self, options):
        r"""
        SetInternalsUpdateOptions(self, options)
        Sets the option(s) used to update internals.
        """
        return _btk.btkXMOVEFileIO_SetInternalsUpdateOptions(self, options)

    def HasInternalsUpdateOption(self, option):
        r"""
        HasInternalsUpdateOption(self, option) -> bool
        Returns true if the given @a option is used or false if not.
        """
        return _btk.btkXMOVEFileIO_HasInternalsUpdateOption(self, option)

    def CanReadFile(self, filename):
        r"""
        CanReadFile(self, filename) -> bool
        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkXMOVEFileIO_CanReadFile(self, filename)

    def CanWriteFile(self, filename):
        r"""
        CanWriteFile(self, filename) -> bool
        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkXMOVEFileIO_CanWriteFile(self, filename)

    def Read(self, filename, output):
        r"""
        Read(self, filename, output)
        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkXMOVEFileIO_Read(self, filename, output)

    def Write(self, filename, input):
        r"""
        Write(self, filename, input)
        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkXMOVEFileIO_Write(self, filename, input)

# Register btkXMOVEFileIO in _btk:
_btk.btkXMOVEFileIO_swigregister(btkXMOVEFileIO)

class btkAcquisitionUnitConverter(object):
    r"""

    This filter can convert units for trajectory, force, moment, angle and power.
    The known unit for the trajectory (length) are:
     - meter (m);
     - decimeter (dm);
     - centimeter (cm)
     - millimeter (mm)
     - inch (in)
    The known unit for the force are:
     - newton (N);
    The known unit for the moment are:
     - newton by meter (Nm);
     - newton by decimeter (Ndm);
     - newton by centimeter (Ncm);
     - newton by millimeter (Nmm);
     - newton by inch (Nin);
    The known unit for the angle are:
     - radian (rad);
     - degree (deg);
    The known unit for the power are:
     - watt (W);
    Moreover, the metadata known to be influenced by these unit (FORCE_PLATFORM, 
    SEG) are also converted. The metadata POINT:*UNITS are not updated as they are not
    used in BTK (instead, you can use the method btkAcquisition::GetPointUnit()).

    Use the method btkAcquisitionUnitConverter::SetUnit() with the following enumeration 
    value to select the wanted units:
     - btk.btkAcquisitionUnitConverter.Length
     - btk.btkAcquisitionUnitConverter.Angle
     - btk.btkAcquisitionUnitConverter.Force
     - btk.btkAcquisitionUnitConverter.Moment
     - btk.btkAcquisitionUnitConverter.Power

    By default, the data will be converted in millimeter, newton, newton by millimeter, 
    degree and watt. Even if you could convert trajectories and moments with the desired 
    units, it is recommended to use the same length unit (i.e. mm and Nmm or m with Nm).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Length = _btk.btkAcquisitionUnitConverter_Length
    
    Angle = _btk.btkAcquisitionUnitConverter_Angle
    
    Force = _btk.btkAcquisitionUnitConverter_Force
    
    Moment = _btk.btkAcquisitionUnitConverter_Moment
    
    Power = _btk.btkAcquisitionUnitConverter_Power
    

    def __init__(self):
        r"""
        __init__(self) -> btkAcquisitionUnitConverter

        This filter can convert units for trajectory, force, moment, angle and power.
        The known unit for the trajectory (length) are:
         - meter (m);
         - decimeter (dm);
         - centimeter (cm)
         - millimeter (mm)
         - inch (in)
        The known unit for the force are:
         - newton (N);
        The known unit for the moment are:
         - newton by meter (Nm);
         - newton by decimeter (Ndm);
         - newton by centimeter (Ncm);
         - newton by millimeter (Nmm);
         - newton by inch (Nin);
        The known unit for the angle are:
         - radian (rad);
         - degree (deg);
        The known unit for the power are:
         - watt (W);
        Moreover, the metadata known to be influenced by these unit (FORCE_PLATFORM, 
        SEG) are also converted. The metadata POINT:*UNITS are not updated as they are not
        used in BTK (instead, you can use the method btkAcquisition::GetPointUnit()).

        Use the method btkAcquisitionUnitConverter::SetUnit() with the following enumeration 
        value to select the wanted units:
         - btk.btkAcquisitionUnitConverter.Length
         - btk.btkAcquisitionUnitConverter.Angle
         - btk.btkAcquisitionUnitConverter.Force
         - btk.btkAcquisitionUnitConverter.Moment
         - btk.btkAcquisitionUnitConverter.Power

        By default, the data will be converted in millimeter, newton, newton by millimeter, 
        degree and watt. Even if you could convert trajectories and moments with the desired 
        units, it is recommended to use the same length unit (i.e. mm and Nmm or m with Nm).
        """
        _btk.btkAcquisitionUnitConverter_swiginit(self, _btk.new_btkAcquisitionUnitConverter())

    def __deref__(self):
        r"""__deref__(self) -> btkAcquisitionUnitConverter_impl *"""
        return _btk.btkAcquisitionUnitConverter___deref__(self)
    __swig_destroy__ = _btk.delete_btkAcquisitionUnitConverter

    def GetInput(self):
        r"""
        GetInput(self) -> btkAcquisition
        Gets the input registered with this process.
        """
        return _btk.btkAcquisitionUnitConverter_GetInput(self)

    def SetInput(self, arg2):
        r"""
        SetInput(self, btkAcquisition)
        Sets the input required with this process.
        """
        return _btk.btkAcquisitionUnitConverter_SetInput(self, arg2)

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkAcquisition
        Returns the output created with this process.
        """
        return _btk.btkAcquisitionUnitConverter_GetOutput(self)

    def SetUnit(self, arg2, arg3):
        r"""
        SetUnit(self, btk.btkAcquisitionUnitConverter.Unit, string)
        Set the given unit with the given string
        """
        return _btk.btkAcquisitionUnitConverter_SetUnit(self, arg2, arg3)

    def GetUnit(self, arg2):
        r"""
        GetUnit(self, btk.btkAcquisitionUnitConverter.Unit) -> string
        Returns the string corresponding to the given unit
        """
        return _btk.btkAcquisitionUnitConverter_GetUnit(self, arg2)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkAcquisitionUnitConverter_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkAcquisitionUnitConverter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkAcquisitionUnitConverter_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkAcquisitionUnitConverter_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkAcquisitionUnitConverter_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkAcquisitionUnitConverter_GetTimestamp(self)

# Register btkAcquisitionUnitConverter in _btk:
_btk.btkAcquisitionUnitConverter_swigregister(btkAcquisitionUnitConverter)

class btkAnalogOffsetRemover(object):
    r"""

    Remove a possible analog offset to the selected analog channels

    Based on the given offset input (see the method SetOffsetInput()), each analog signals
    are averaged and removed from the raw input (see the method SetRawInput()). The analog signals set in the raw input which
    are not given to the offset input are not processed but will be available in the output.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkAnalogOffsetRemover

        Remove a possible analog offset to the selected analog channels

        Based on the given offset input (see the method SetOffsetInput()), each analog signals
        are averaged and removed from the raw input (see the method SetRawInput()). The analog signals set in the raw input which
        are not given to the offset input are not processed but will be available in the output.
        """
        _btk.btkAnalogOffsetRemover_swiginit(self, _btk.new_btkAnalogOffsetRemover())

    def __deref__(self):
        r"""__deref__(self) -> btkAnalogOffsetRemover_impl *"""
        return _btk.btkAnalogOffsetRemover___deref__(self)
    __swig_destroy__ = _btk.delete_btkAnalogOffsetRemover

    def SetRawInput(self, arg2):
        r"""
        SetRawInput(self, btkAcquisition)
        Sets the input required with this process which is used as the input to process.
        """
        return _btk.btkAnalogOffsetRemover_SetRawInput(self, arg2)

    def GetRawInput(self):
        r"""
        GetRawInput(self) -> btkAcquisition
        Gets the input registered with this process which is used as the input to process.
        """
        return _btk.btkAnalogOffsetRemover_GetRawInput(self)

    def SetOffsetInput(self, arg2):
        r"""
        SetOffsetInput(self, btkAcquisition)
        Sets the input required with this process which corresponds to the offsets to remove.
        """
        return _btk.btkAnalogOffsetRemover_SetOffsetInput(self, arg2)

    def GetOffsetInput(self):
        r"""
        GetOffsetInput(self) -> btkAcquisition
        Gets the input registered with this process which corresponds to the offsets to remove.
        """
        return _btk.btkAnalogOffsetRemover_GetOffsetInput(self)

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkAcquisition
        Returns the output created with this process.
        """
        return _btk.btkAnalogOffsetRemover_GetOutput(self)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkAnalogOffsetRemover_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkAnalogOffsetRemover_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkAnalogOffsetRemover_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkAnalogOffsetRemover_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkAnalogOffsetRemover_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkAnalogOffsetRemover_GetTimestamp(self)

# Register btkAnalogOffsetRemover in _btk:
_btk.btkAnalogOffsetRemover_swigregister(btkAnalogOffsetRemover)

class btkWrenchDownsampleFilter(object):
    r"""

    Downsample data stored in a wrench

    To downsample data, you need to set the up/down sample ratio using the method SetUpDownRatio().
    The given value is an integer corresponding to the ratio used to extract only the value of interest.
    For example, if you have 200 frames and a ratio of 10, then 20 frames will be extracted (one frame each 10 frames).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkWrenchDownsampleFilter

        Downsample data stored in a wrench

        To downsample data, you need to set the up/down sample ratio using the method SetUpDownRatio().
        The given value is an integer corresponding to the ratio used to extract only the value of interest.
        For example, if you have 200 frames and a ratio of 10, then 20 frames will be extracted (one frame each 10 frames).
        """
        _btk.btkWrenchDownsampleFilter_swiginit(self, _btk.new_btkWrenchDownsampleFilter())

    def __deref__(self):
        r"""__deref__(self) -> btkWrenchDownsampleFilter_impl *"""
        return _btk.btkWrenchDownsampleFilter___deref__(self)
    __swig_destroy__ = _btk.delete_btkWrenchDownsampleFilter

    def GetInput(self):
        r"""
        GetInput(self) -> btkWrench
        Gets the input registered with this process.
        """
        return _btk.btkWrenchDownsampleFilter_GetInput(self)

    def SetInput(self, arg2):
        r"""
        SetInput(self, btkWrench)
        Sets the input required with this process.
        """
        return _btk.btkWrenchDownsampleFilter_SetInput(self, arg2)

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkWrench
        Returns the output created with this process.
        """
        return _btk.btkWrenchDownsampleFilter_GetOutput(self)

    def GetUpDownRatio(self):
        r"""
        GetUpDownRatio(self) -> int
        Gets the ratio used to downsample the data.
        """
        return _btk.btkWrenchDownsampleFilter_GetUpDownRatio(self)

    def SetUpDownRatio(self, ratio):
        r"""
        SetUpDownRatio(self, int)
        Sets the ratio used to downsample the data.
        """
        return _btk.btkWrenchDownsampleFilter_SetUpDownRatio(self, ratio)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkWrenchDownsampleFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkWrenchDownsampleFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkWrenchDownsampleFilter_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkWrenchDownsampleFilter_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkWrenchDownsampleFilter_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkWrenchDownsampleFilter_GetTimestamp(self)

# Register btkWrenchDownsampleFilter in _btk:
_btk.btkWrenchDownsampleFilter_swigregister(btkWrenchDownsampleFilter)

class btkWrenchCollectionDownsampleFilter(object):
    r"""

    Downsample data stored in a collection of wrenches.

    To downsample data, you need to set the up/down sample ratio using the method SetUpDownRatio().
    The given value is an integer corresponding to the ratio used to extract only the value of interest.
    For example, if you have 200 frames and a ratio of 10, then 20 frames will be extracted (one frame each 10 frames).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkWrenchCollectionDownsampleFilter

        Downsample data stored in a collection of wrenches.

        To downsample data, you need to set the up/down sample ratio using the method SetUpDownRatio().
        The given value is an integer corresponding to the ratio used to extract only the value of interest.
        For example, if you have 200 frames and a ratio of 10, then 20 frames will be extracted (one frame each 10 frames).
        """
        _btk.btkWrenchCollectionDownsampleFilter_swiginit(self, _btk.new_btkWrenchCollectionDownsampleFilter())

    def __deref__(self):
        r"""__deref__(self) -> btkWrenchCollectionDownsampleFilter_impl *"""
        return _btk.btkWrenchCollectionDownsampleFilter___deref__(self)
    __swig_destroy__ = _btk.delete_btkWrenchCollectionDownsampleFilter

    def GetInput(self):
        r"""
        GetInput(self) -> btkWrenchCollection
        Gets the input registered with this process.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetInput(self)

    def SetInput(self, arg2):
        r"""
        SetInput(self, btkWrenchCollection)
        Sets the input required with this process.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_SetInput(self, arg2)

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkWrenchCollection
        Returns the output created with this process.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetOutput(self)

    def GetUpDownRatio(self):
        r"""
        GetUpDownRatio(self) -> int
        Gets the ratio used to downsample the data.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetUpDownRatio(self)

    def SetUpDownRatio(self, ratio):
        r"""
        SetUpDownRatio(self, int)
        Sets the ratio used to downsample the data.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_SetUpDownRatio(self, ratio)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetTimestamp(self)

# Register btkWrenchCollectionDownsampleFilter in _btk:
_btk.btkWrenchCollectionDownsampleFilter_swigregister(btkWrenchCollectionDownsampleFilter)

class btkForcePlatformsExtractor(object):
    r"""

    Based on the content of the metadata FORCE_PLATFORM and the analog channels stored in the given 
    acquisition, this filter creates a collection of btkForcePlatform returned in the output.

    Depending of the type of the force platform, the analog channels' data are transformed to take into account a calibration matrix.

    The metadata FORCE_PLATFORM must be structured as the following:
     - FORCE_PLATFORM:USED: single integer storing the number of force plates ;
     - FORCE_PLATFORM:TYPE: 1D array of integer containing the type of force plates contained in the acquisition (see below for the supported types) ;
     - FORCE_PLATFORM:CHANNEL: 2D array of integer containing of 1-based indices of the analog channels used ;
     - FORCE_PLATFORM:LABELS: 1D array of strings containing the force plates' label ;
     - FORCE_PLATFORM:DESCRIPTIONS: 1D array of strings containing the force plates' description ;
     - FORCE_PLATFORM:ORIGIN: 2D array of reals (float) containing the coordinates of the origin of the surface of each force platform expressed in their frame ;
     - FORCE_PLATFORM:CORNERS: 3D array of reals containing the coordinates of the corners. The third dimensions corresponds to the number of force platforms ;
     - FORCE_PLATFORM:CAL_MATRIX: (could be optional, depend on the FP type). 3D array containing the calibration to transform the volts into forces and moments ;
    You can have more details on each metadata by following this link: http://www.c3d.org/HTML/theforceplatformgroup.htm

    This filter is able to manage the following force platform's type:
     - Type 1: 6 channels with Forces X,Y,Z Position X,Y of the COP, and Moment Z around the COP ;
     - Type 2: 6 channels (FX, FY, FZ, MX, MY, MZ) ;
     - Type 3: 8 channels (FZ1, FZ2, FZ3, FZ4, FX12, FX34, FY14, FY23) ;
     - Type 4: Same as Type-2 + calibration matrix 6 (columns) by 6 (rows) ;
     - Type 5: Same as Type-3 + calibration matrix 6 (columns) by 8 (rows).

    However, some other types are not yet supported due to the lack of information and data on them:
     - Type 6: 12 channels (FX[1,2,3,4], FY[1,2,3,4], FZ[1,2,3,4]) + calibration matrix 12 by 12 ;
     - Type 7: 8 channels (FZ1, FZ2, FZ3, FZ4, FX12, FX34, FY14, FY23) + calibration matrix 8 by 8 ;
     - Type 11: Kistler Split Belt Treadmill: 8 channels + calibration matrix 8X8 + polynomial correction matrix 2x6 + COP translation + COP rotation ;
     - Type 12: Gaitway treadmill: 8 channels (Fz11, Fz12, Fz13, Fz14, Fz21, Fz22, Fz23, and Fz24) + calibration matrix 8X8 ;
     - Type 21: AMTI-Stairs: 2 force plates with 6 channels + a calibration matrix 6x6 + data to locate the corners of the 4 steps.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkForcePlatformsExtractor

        Based on the content of the metadata FORCE_PLATFORM and the analog channels stored in the given 
        acquisition, this filter creates a collection of btkForcePlatform returned in the output.

        Depending of the type of the force platform, the analog channels' data are transformed to take into account a calibration matrix.

        The metadata FORCE_PLATFORM must be structured as the following:
         - FORCE_PLATFORM:USED: single integer storing the number of force plates ;
         - FORCE_PLATFORM:TYPE: 1D array of integer containing the type of force plates contained in the acquisition (see below for the supported types) ;
         - FORCE_PLATFORM:CHANNEL: 2D array of integer containing of 1-based indices of the analog channels used ;
         - FORCE_PLATFORM:LABELS: 1D array of strings containing the force plates' label ;
         - FORCE_PLATFORM:DESCRIPTIONS: 1D array of strings containing the force plates' description ;
         - FORCE_PLATFORM:ORIGIN: 2D array of reals (float) containing the coordinates of the origin of the surface of each force platform expressed in their frame ;
         - FORCE_PLATFORM:CORNERS: 3D array of reals containing the coordinates of the corners. The third dimensions corresponds to the number of force platforms ;
         - FORCE_PLATFORM:CAL_MATRIX: (could be optional, depend on the FP type). 3D array containing the calibration to transform the volts into forces and moments ;
        You can have more details on each metadata by following this link: http://www.c3d.org/HTML/theforceplatformgroup.htm

        This filter is able to manage the following force platform's type:
         - Type 1: 6 channels with Forces X,Y,Z Position X,Y of the COP, and Moment Z around the COP ;
         - Type 2: 6 channels (FX, FY, FZ, MX, MY, MZ) ;
         - Type 3: 8 channels (FZ1, FZ2, FZ3, FZ4, FX12, FX34, FY14, FY23) ;
         - Type 4: Same as Type-2 + calibration matrix 6 (columns) by 6 (rows) ;
         - Type 5: Same as Type-3 + calibration matrix 6 (columns) by 8 (rows).

        However, some other types are not yet supported due to the lack of information and data on them:
         - Type 6: 12 channels (FX[1,2,3,4], FY[1,2,3,4], FZ[1,2,3,4]) + calibration matrix 12 by 12 ;
         - Type 7: 8 channels (FZ1, FZ2, FZ3, FZ4, FX12, FX34, FY14, FY23) + calibration matrix 8 by 8 ;
         - Type 11: Kistler Split Belt Treadmill: 8 channels + calibration matrix 8X8 + polynomial correction matrix 2x6 + COP translation + COP rotation ;
         - Type 12: Gaitway treadmill: 8 channels (Fz11, Fz12, Fz13, Fz14, Fz21, Fz22, Fz23, and Fz24) + calibration matrix 8X8 ;
         - Type 21: AMTI-Stairs: 2 force plates with 6 channels + a calibration matrix 6x6 + data to locate the corners of the 4 steps.
        """
        _btk.btkForcePlatformsExtractor_swiginit(self, _btk.new_btkForcePlatformsExtractor())

    def __deref__(self):
        r"""__deref__(self) -> btkForcePlatformsExtractor_impl *"""
        return _btk.btkForcePlatformsExtractor___deref__(self)
    __swig_destroy__ = _btk.delete_btkForcePlatformsExtractor

    def GetInput(self):
        r"""
        GetInput(self) -> btkAcquisition
        Gets the input registered with this process.
        """
        return _btk.btkForcePlatformsExtractor_GetInput(self)

    def SetInput(self, arg2):
        r"""
        SetInput(self, arg2)
        Sets the input required with this process.
        """
        return _btk.btkForcePlatformsExtractor_SetInput(self, arg2)

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkForcePlatformCollection
        Returns the output created with this process.
        """
        return _btk.btkForcePlatformsExtractor_GetOutput(self)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkForcePlatformsExtractor_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkForcePlatformsExtractor_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkForcePlatformsExtractor_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkForcePlatformsExtractor_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkForcePlatformsExtractor_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatformsExtractor_GetTimestamp(self)

# Register btkForcePlatformsExtractor in _btk:
_btk.btkForcePlatformsExtractor_swigregister(btkForcePlatformsExtractor)

class btkForcePlatformWrenchFilter(object):
    r"""

    Based on the given collection of forceplate set in input, this filter transform the associated analog channels in forces and moments.
    This transformation take into account the type of each force platform.

    You can use the method btkForcePlatformWrenchFilter::SetTransformToGlobalFrame() to have the wrench expressed in the frame of the force platform.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkForcePlatformWrenchFilter

        Based on the given collection of forceplate set in input, this filter transform the associated analog channels in forces and moments.
        This transformation take into account the type of each force platform.

        You can use the method btkForcePlatformWrenchFilter::SetTransformToGlobalFrame() to have the wrench expressed in the frame of the force platform.
        """
        _btk.btkForcePlatformWrenchFilter_swiginit(self, _btk.new_btkForcePlatformWrenchFilter())

    def __deref__(self):
        r"""__deref__(self) -> btkForcePlatformWrenchFilter_impl *"""
        return _btk.btkForcePlatformWrenchFilter___deref__(self)
    __swig_destroy__ = _btk.delete_btkForcePlatformWrenchFilter

    def GetInput(self):
        r"""
        GetInput(self) -> btkForcePlatformCollection
        Gets the input registered with this process.
        """
        return _btk.btkForcePlatformWrenchFilter_GetInput(self)

    def SetInput(self, *args):
        r"""
        SetInput(self, btkForcePlatform)SetInput(self, btkForcePlatformCollection)
        Sets the input required with this process.
        """
        return _btk.btkForcePlatformWrenchFilter_SetInput(self, *args)

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkWrenchCollection
        Returns the output created with this process.
        """
        return _btk.btkForcePlatformWrenchFilter_GetOutput(self)

    def SetTransformToGlobalFrame(self, activation=False):
        r"""
        SetTransformToGlobalFrame(self, activation=False)
        Activate or deactivate the computation of the wrenches in the global frame.
        """
        return _btk.btkForcePlatformWrenchFilter_SetTransformToGlobalFrame(self, activation)

    def GetTransformToGlobalFrame(self):
        r"""
        GetTransformToGlobalFrame(self) -> bool
        Returns the state of the activation for the computation of the wrenches in the global frame.
        """
        return _btk.btkForcePlatformWrenchFilter_GetTransformToGlobalFrame(self)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkForcePlatformWrenchFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkForcePlatformWrenchFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkForcePlatformWrenchFilter_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkForcePlatformWrenchFilter_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkForcePlatformWrenchFilter_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatformWrenchFilter_GetTimestamp(self)

# Register btkForcePlatformWrenchFilter in _btk:
_btk.btkForcePlatformWrenchFilter_swigregister(btkForcePlatformWrenchFilter)

class btkGroundReactionWrenchFilter(object):
    r"""

    Transform force platform data into ground reaction wrenches.

    Theses wrenches are expressed in the global frame. The point of application (PWA)
    of each wrench is calculated from the paper of Shimba (1984). 
    Compared to the center of pressure (COP), the PWA take into account all the forces
    and moments (and does not assume any null forces).

    Note: For gait analysis, the COP and PWA are very similar.
    Because the computation of the PWA (as the COP) is sensitive to small (vertical) forces, the methods 
    SetThresholdValue and SetThresholdState() are provided to not compute the PWA if the vertical forces is
    the threshold. You first need to set the value and then activate the threshold method.
    By default, this threshold is not activated and the values is set to 0.

    # Example
    grwf = btk.btkGroundReactionWrenchFilter()
    grwf.SetThresholdValue(5.0); # 5 newtons
    grwf.SetThresholdState(true);

    Finally, you can also use the method btkGroundReactionWrenchFilter::SetTransformToGlobalFrame() to have the wrench expressed in the frame of the force platform.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkGroundReactionWrenchFilter

        Transform force platform data into ground reaction wrenches.

        Theses wrenches are expressed in the global frame. The point of application (PWA)
        of each wrench is calculated from the paper of Shimba (1984). 
        Compared to the center of pressure (COP), the PWA take into account all the forces
        and moments (and does not assume any null forces).

        Note: For gait analysis, the COP and PWA are very similar.
        Because the computation of the PWA (as the COP) is sensitive to small (vertical) forces, the methods 
        SetThresholdValue and SetThresholdState() are provided to not compute the PWA if the vertical forces is
        the threshold. You first need to set the value and then activate the threshold method.
        By default, this threshold is not activated and the values is set to 0.

        # Example
        grwf = btk.btkGroundReactionWrenchFilter()
        grwf.SetThresholdValue(5.0); # 5 newtons
        grwf.SetThresholdState(true);

        Finally, you can also use the method btkGroundReactionWrenchFilter::SetTransformToGlobalFrame() to have the wrench expressed in the frame of the force platform.
        """
        _btk.btkGroundReactionWrenchFilter_swiginit(self, _btk.new_btkGroundReactionWrenchFilter())

    def __deref__(self):
        r"""__deref__(self) -> btkGroundReactionWrenchFilter_impl *"""
        return _btk.btkGroundReactionWrenchFilter___deref__(self)
    __swig_destroy__ = _btk.delete_btkGroundReactionWrenchFilter

    def GetInput(self):
        r"""
        GetInput(self) -> btkForcePlatformCollection
        Gets the input registered with this process.
        """
        return _btk.btkGroundReactionWrenchFilter_GetInput(self)

    def SetInput(self, *args):
        r"""
        SetInput(self, btkForcePlatform)SetInput(self, btkForcePlatformCollection)
        Sets the input required with this process.
        """
        return _btk.btkGroundReactionWrenchFilter_SetInput(self, *args)

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkWrenchCollection
        Returns the output created with this process.
        """
        return _btk.btkGroundReactionWrenchFilter_GetOutput(self)

    def SetTransformToGlobalFrame(self, activation=False):
        r"""
        SetTransformToGlobalFrame(self, activation=False)
        Activate or deactivate the computation of the wrenches in the global frame.
        """
        return _btk.btkGroundReactionWrenchFilter_SetTransformToGlobalFrame(self, activation)

    def GetTransformToGlobalFrame(self):
        r"""
        GetTransformToGlobalFrame(self) -> bool
        Returns the state of the activation for the computation of the wrenches in the global frame.
        """
        return _btk.btkGroundReactionWrenchFilter_GetTransformToGlobalFrame(self)

    def GetThresholdState(self):
        r"""
        GetThresholdState(self) -> bool
        Returns the state of the threshold used to suppress false PWA.
        """
        return _btk.btkGroundReactionWrenchFilter_GetThresholdState(self)

    def SetThresholdState(self, activated=False):
        r"""
        SetThresholdState(self, activated=False)
        Sets the threshold state.
        """
        return _btk.btkGroundReactionWrenchFilter_SetThresholdState(self, activated)

    def GetThresholdValue(self):
        r"""
        GetThresholdValue(self) -> double
        Returns the value used to suppress PWA computed with a Fz value lower or equal than it.
        """
        return _btk.btkGroundReactionWrenchFilter_GetThresholdValue(self)

    def SetThresholdValue(self, arg2):
        r"""
        SetThresholdValue(self, double)
        Sets the threshold value.
        """
        return _btk.btkGroundReactionWrenchFilter_SetThresholdValue(self, arg2)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkGroundReactionWrenchFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkGroundReactionWrenchFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkGroundReactionWrenchFilter_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkGroundReactionWrenchFilter_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkGroundReactionWrenchFilter_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkGroundReactionWrenchFilter_GetTimestamp(self)

# Register btkGroundReactionWrenchFilter in _btk:
_btk.btkGroundReactionWrenchFilter_swigregister(btkGroundReactionWrenchFilter)

class btkIMUsExtractor(object):
    r"""

    Extracts inertial measurement units (IMUs) from a btkAcquisition object. 

    Based on the content of the metadata IMU and the analog channels stored in the given acquisition(s),
    this filter creates a collection of btkIMU returned in the output.

    The metadata IMU must be structured as the following:
     - IMU:USED: single integer storing the number of IMUs ;
     - IMU:TYPE: 1D array of integer containing the type of IMU contained in the acquisition (see below for the supported types) ;
     - IMU:CHANNEL: 2D array of integer containing of 1-based indices of the analog channels used ;
     - IMU:LABELS: 1D array of strings containing the force plates' label ;
     - IMU:DESCRIPTIONS: 1D array of strings containing the force plates' description ;

    The supported types are the following:
     - Type 1: 6D IMU with a 3D accelerometer and 3D gyroscope.

    Note: This class is still experimental and could be modified in the next release.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkIMUsExtractor

        Extracts inertial measurement units (IMUs) from a btkAcquisition object. 

        Based on the content of the metadata IMU and the analog channels stored in the given acquisition(s),
        this filter creates a collection of btkIMU returned in the output.

        The metadata IMU must be structured as the following:
         - IMU:USED: single integer storing the number of IMUs ;
         - IMU:TYPE: 1D array of integer containing the type of IMU contained in the acquisition (see below for the supported types) ;
         - IMU:CHANNEL: 2D array of integer containing of 1-based indices of the analog channels used ;
         - IMU:LABELS: 1D array of strings containing the force plates' label ;
         - IMU:DESCRIPTIONS: 1D array of strings containing the force plates' description ;

        The supported types are the following:
         - Type 1: 6D IMU with a 3D accelerometer and 3D gyroscope.

        Note: This class is still experimental and could be modified in the next release.
        """
        _btk.btkIMUsExtractor_swiginit(self, _btk.new_btkIMUsExtractor())

    def __deref__(self):
        r"""__deref__(self) -> btkIMUsExtractor_impl *"""
        return _btk.btkIMUsExtractor___deref__(self)
    __swig_destroy__ = _btk.delete_btkIMUsExtractor

    def GetInput(self, *args):
        r"""
        GetInput(self) -> btkAcquisitionGetInput(self, int) -> btkAcquisition
        Gets the input registered with this process.
        """
        return _btk.btkIMUsExtractor_GetInput(self, *args)

    def SetInput(self, *args):
        r"""
        SetInput(self, btkAcquisition)SetInput(self, int, btkAcquisition)
        Sets the input required with this process.
        """
        return _btk.btkIMUsExtractor_SetInput(self, *args)

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkIMUCollection
        Returns the output created with this process.
        """
        return _btk.btkIMUsExtractor_GetOutput(self)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkIMUsExtractor_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkIMUsExtractor_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkIMUsExtractor_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkIMUsExtractor_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkIMUsExtractor_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkIMUsExtractor_GetTimestamp(self)

# Register btkIMUsExtractor in _btk:
_btk.btkIMUsExtractor_swigregister(btkIMUsExtractor)

class btkMergeAcquisitionFilter(object):
    r"""

    Merges or concatenates two or more btkAcquisition objects into a single new one.

    The difference between the merging or the concatenating depends of the acquisitions' informations.

    If the acquisitions are exactly the same (same label for points and analog channels) and the first 
    frame of the n+1th acquisition corresponds to the last frame of the nth acquisition, then the 
    acquisitions are merged, otherwise, the data are concatenated. Merged acquisitions means that the 
    output will have the same number of points, analog channels, events than each output but the number
    of frames corresponds to the sum of the input's frame number. 

    Rules to merge/concatenate acquisitions are:
     - Must have the same acquisition frequency (or 0).
     - Must have the same number of analog samples per point frame (if there are points and analog channels).
     - Must have the same analog resolution.
     - Must have the same units (Use btkAcquisitionUnitConvert to convert them).
     - Must have the same global frame orientation (check POINT:X_SCREEN and POINT:Y_SCREEN)
     - The first input which has a non-zero acquisition frequency is used.
     - The first input which has analog channels is used to set the analog resolution of the output.

    Actions during the merging/concatenation:
     - If the first frame of the nth acquisition correspond to the last frame + 1 of the nth-1 acquisition, 
       AND the points / analog channels correspond exactly, then acquisitions are truncated.
     - If the first frame of two inputs are not the same, the final acquisition is adapted to contain the number of frames plus
       the difference between the first frame of each input.
     - If points have the same label (and the first frames doesn't correspond), then, the second and more are incremented (i.e. from Heel to Heel_2).
     - Idem for the analog channels.
     - Events with the same label, context, id and time are merged.
     - Metadata (if number of inputs greater than 1):
        - Only metadata defined by the user are inserted (i.e. POINT, ANALOG, EVENTS, etc. are not inserted as they are only used in a C3D file.).
        - If metadata are equivalent or equal, then they are merged, else the metadata is appended with a suffix
          (i.e. from STATIC_CALIBRATION:USED to STATIC_CALIBRATION:USED_2)

    Moreover, you can set a rule to keep only the data from the higher or the lower first frame.
    Use the method SetFirstFrameRule() with the values KeepAllFrames or KeepFromHighestFirstFrame.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    KeepAllFrames = _btk.btkMergeAcquisitionFilter_KeepAllFrames
    
    KeepFromHighestFirstFrame = _btk.btkMergeAcquisitionFilter_KeepFromHighestFirstFrame
    

    def __init__(self):
        r"""
        __init__(self) -> btkMergeAcquisitionFilter

        Merges or concatenates two or more btkAcquisition objects into a single new one.

        The difference between the merging or the concatenating depends of the acquisitions' informations.

        If the acquisitions are exactly the same (same label for points and analog channels) and the first 
        frame of the n+1th acquisition corresponds to the last frame of the nth acquisition, then the 
        acquisitions are merged, otherwise, the data are concatenated. Merged acquisitions means that the 
        output will have the same number of points, analog channels, events than each output but the number
        of frames corresponds to the sum of the input's frame number. 

        Rules to merge/concatenate acquisitions are:
         - Must have the same acquisition frequency (or 0).
         - Must have the same number of analog samples per point frame (if there are points and analog channels).
         - Must have the same analog resolution.
         - Must have the same units (Use btkAcquisitionUnitConvert to convert them).
         - Must have the same global frame orientation (check POINT:X_SCREEN and POINT:Y_SCREEN)
         - The first input which has a non-zero acquisition frequency is used.
         - The first input which has analog channels is used to set the analog resolution of the output.

        Actions during the merging/concatenation:
         - If the first frame of the nth acquisition correspond to the last frame + 1 of the nth-1 acquisition, 
           AND the points / analog channels correspond exactly, then acquisitions are truncated.
         - If the first frame of two inputs are not the same, the final acquisition is adapted to contain the number of frames plus
           the difference between the first frame of each input.
         - If points have the same label (and the first frames doesn't correspond), then, the second and more are incremented (i.e. from Heel to Heel_2).
         - Idem for the analog channels.
         - Events with the same label, context, id and time are merged.
         - Metadata (if number of inputs greater than 1):
            - Only metadata defined by the user are inserted (i.e. POINT, ANALOG, EVENTS, etc. are not inserted as they are only used in a C3D file.).
            - If metadata are equivalent or equal, then they are merged, else the metadata is appended with a suffix
              (i.e. from STATIC_CALIBRATION:USED to STATIC_CALIBRATION:USED_2)

        Moreover, you can set a rule to keep only the data from the higher or the lower first frame.
        Use the method SetFirstFrameRule() with the values KeepAllFrames or KeepFromHighestFirstFrame.
        """
        _btk.btkMergeAcquisitionFilter_swiginit(self, _btk.new_btkMergeAcquisitionFilter())

    def __deref__(self):
        r"""__deref__(self) -> btkMergeAcquisitionFilter_impl *"""
        return _btk.btkMergeAcquisitionFilter___deref__(self)
    __swig_destroy__ = _btk.delete_btkMergeAcquisitionFilter

    def GetFirstFrameRule(self):
        r"""
        GetFirstFrameRule(self) -> int
        Sets the rule for the first frame kept. Two rules are available:
         - KeepAllFrames: Use the lower first frame;
         - KeepFromHighestFirstFrame: Use the higher first frame.
        """
        return _btk.btkMergeAcquisitionFilter_GetFirstFrameRule(self)

    def SetFirstFrameRule(self, arg2):
        r"""
        SetFirstFrameRule(self, int)
        Returns the rule for the first frame kept.
        """
        return _btk.btkMergeAcquisitionFilter_SetFirstFrameRule(self, arg2)

    def GetInput(self, arg2):
        r"""
        GetInput(self, int) -> btkAcquisition
        Gets the input registered with this process.
        """
        return _btk.btkMergeAcquisitionFilter_GetInput(self, arg2)

    def SetInput(self, arg2, arg3):
        r"""
        SetInput(self, int, btkAcquisition)
        Sets the input required with this process.
        """
        return _btk.btkMergeAcquisitionFilter_SetInput(self, arg2, arg3)

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkAcquisition
        Returns the output created with this process.
        """
        return _btk.btkMergeAcquisitionFilter_GetOutput(self)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkMergeAcquisitionFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkMergeAcquisitionFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkMergeAcquisitionFilter_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkMergeAcquisitionFilter_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkMergeAcquisitionFilter_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkMergeAcquisitionFilter_GetTimestamp(self)

# Register btkMergeAcquisitionFilter in _btk:
_btk.btkMergeAcquisitionFilter_swigregister(btkMergeAcquisitionFilter)

class btkSeparateKnownVirtualMarkersFilter(object):
    r"""

    Separate a collection of points in five categories to be able to distinguish real markers from the others.

    These categories are:
     - all kind of markers (real and virtual) as stored in the acquisition
     - markers
     - virtual markers used to construct refence frames
     - other virtual markers (CenterOfMass, ...)
     - other points (angle, force, moment, power, ...)

    To select the output corresponding to the chosen category, you can use the method GetOutput() 
    with one of these enum values: AllMarkers, Markers, VirtualReferenceFrames, VirtualMarkers, OtherPoints.

    By default, the list of labels known as virtual markers used for frame is:
     - HED(O|A|L|P): HEDO, HEDA, HEDL, HELP
     - LCL(O|A|L|P)
     - LFE(O|A|L|P)
     - LFO(O|A|L|P)
     - LHN(O|A|L|P)
     - LHU(O|A|L|P)
     - LRA(O|A|L|P)
     - LTI(O|A|L|P)
     - LTO(O|A|L|P)
     - PEL(O|A|L|P)
     - RCL(O|A|L|P)
     - RFE(O|A|L|P)
     - RFO(O|A|L|P)
     - RHN(O|A|L|P)
     - RHU(O|A|L|P)
     - RRA(O|A|L|P)
     - RTI(O|A|L|P)
     - RTO(O|A|L|P)
     - TRX(O|A|L|P)

    By default, the list of labels known as other virtual markers is:
     - CenterOfMass
     - CenterOfMassFloor

    You can also add a prefix for the markers' label by using the method SetLabelPrefix. This prefix will be concatenated to the markers' label during the separation.

    This filter only copies the pointer associated which each point instead of using a deep copy of it.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    AllMarkers = _btk.btkSeparateKnownVirtualMarkersFilter_AllMarkers
    
    Markers = _btk.btkSeparateKnownVirtualMarkersFilter_Markers
    
    VirtualReferenceFrames = _btk.btkSeparateKnownVirtualMarkersFilter_VirtualReferenceFrames
    
    VirtualMarkers = _btk.btkSeparateKnownVirtualMarkersFilter_VirtualMarkers
    
    OtherPoints = _btk.btkSeparateKnownVirtualMarkersFilter_OtherPoints
    

    def __init__(self):
        r"""
        __init__(self) -> btkSeparateKnownVirtualMarkersFilter

        Separate a collection of points in five categories to be able to distinguish real markers from the others.

        These categories are:
         - all kind of markers (real and virtual) as stored in the acquisition
         - markers
         - virtual markers used to construct refence frames
         - other virtual markers (CenterOfMass, ...)
         - other points (angle, force, moment, power, ...)

        To select the output corresponding to the chosen category, you can use the method GetOutput() 
        with one of these enum values: AllMarkers, Markers, VirtualReferenceFrames, VirtualMarkers, OtherPoints.

        By default, the list of labels known as virtual markers used for frame is:
         - HED(O|A|L|P): HEDO, HEDA, HEDL, HELP
         - LCL(O|A|L|P)
         - LFE(O|A|L|P)
         - LFO(O|A|L|P)
         - LHN(O|A|L|P)
         - LHU(O|A|L|P)
         - LRA(O|A|L|P)
         - LTI(O|A|L|P)
         - LTO(O|A|L|P)
         - PEL(O|A|L|P)
         - RCL(O|A|L|P)
         - RFE(O|A|L|P)
         - RFO(O|A|L|P)
         - RHN(O|A|L|P)
         - RHU(O|A|L|P)
         - RRA(O|A|L|P)
         - RTI(O|A|L|P)
         - RTO(O|A|L|P)
         - TRX(O|A|L|P)

        By default, the list of labels known as other virtual markers is:
         - CenterOfMass
         - CenterOfMassFloor

        You can also add a prefix for the markers' label by using the method SetLabelPrefix. This prefix will be concatenated to the markers' label during the separation.

        This filter only copies the pointer associated which each point instead of using a deep copy of it.
        """
        _btk.btkSeparateKnownVirtualMarkersFilter_swiginit(self, _btk.new_btkSeparateKnownVirtualMarkersFilter())

    def __deref__(self):
        r"""__deref__(self) -> btkSeparateKnownVirtualMarkersFilter_impl *"""
        return _btk.btkSeparateKnownVirtualMarkersFilter___deref__(self)
    __swig_destroy__ = _btk.delete_btkSeparateKnownVirtualMarkersFilter

    def AppendVirtualReferenceFrame(self, *args):
        r"""
        AppendVirtualReferenceFrame(self, string, string, string, string)AppendVirtualReferenceFrame(self, btkStringAxes)
        Append a new set of labels for a virtual frame.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_AppendVirtualReferenceFrame(self, *args)

    def AppendVirtualReferenceFrames(self, arg2):
        r"""
        AppendKnownVirtualMarkerLabelForAxes(self, btkStringAxesList)
        Append a list of axes' definition in the category of the virtual markers used to defined frames.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_AppendVirtualReferenceFrames(self, arg2)

    def SetVirtualReferenceFrames(self, arg2):
        r"""
        SetKnownVirtualMarkerLabelsForAxes(self, btkStringAxesList)
        Sets the list of labels for the virtual markers used to create frames.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_SetVirtualReferenceFrames(self, arg2)

    def GetVirtualReferenceFrames(self):
        r"""
        GetVirtualReferenceFrames(self) -> btkStringAxesList
        Returns the list of labels for the virtual markers used to create frame.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetVirtualReferenceFrames(self)

    def AppendVirtualMarker(self, arg2):
        r"""
        AppendVirtualMarker(self, string)
        Append a label in the category of the other virtual markers.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_AppendVirtualMarker(self, arg2)

    def AppendVirtualMarkers(self, arg2):
        r"""
        AppendVirtualMarkers(self, btkStringList)
        Append a list of labels in the category of the other virtual markers.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_AppendVirtualMarkers(self, arg2)

    def SetVirtualMarkers(self, arg2):
        r"""
        SetKnownVirtualMarkerLabelsForOthers(self, btkStringList)
        Sets the list of labels for the virtual markers used in another context than virtual frames. Each label is checked before to be inserted to not have duplication.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_SetVirtualMarkers(self, arg2)

    def GetVirtualMarkers(self):
        r"""
        GetVirtualMarkers(self) -> btkStringList
        Returns the list of labels for the virtual markers used in another context than virtual frames
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetVirtualMarkers(self)

    def SetLabelPrefix(self, arg2):
        r"""
        SetLabelPrefix(self, string)
        Sets the prefix which will be concatenated to the markers' label during the separation.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_SetLabelPrefix(self, arg2)

    def GetLabelPrefix(self):
        r"""
        GetLabelPrefix(self) -> std::string const &
        Returns the prefix which will be concatenated to the markers' label during the separation.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetLabelPrefix(self)

    def GetInput(self):
        r"""
        GetInput(self) -> btkPointCollection
        Gets the input registered with this process.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetInput(self)

    def SetInput(self, arg2):
        r"""
        SetInput(self, btkAcquisition)
        Sets the input required with this process.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_SetInput(self, arg2)

    def GetOutput(self, arg2):
        r"""
        GetOutput(self, int) -> btkPointCollection
        Returns the output created with this process.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetOutput(self, arg2)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetTimestamp(self)

# Register btkSeparateKnownVirtualMarkersFilter in _btk:
_btk.btkSeparateKnownVirtualMarkersFilter_swigregister(btkSeparateKnownVirtualMarkersFilter)

class btkSpecializedPointsExtractor(object):
    r"""

    Extracts only the points corresponding to the given type (without cloning the extracted points).

    The type is set by the SetPointType() method. By default, if no type is set, this filter extract markers.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkSpecializedPointsExtractor

        Extracts only the points corresponding to the given type (without cloning the extracted points).

        The type is set by the SetPointType() method. By default, if no type is set, this filter extract markers.
        """
        _btk.btkSpecializedPointsExtractor_swiginit(self, _btk.new_btkSpecializedPointsExtractor())

    def __deref__(self):
        r"""__deref__(self) -> btkSpecializedPointsExtractor_impl *"""
        return _btk.btkSpecializedPointsExtractor___deref__(self)
    __swig_destroy__ = _btk.delete_btkSpecializedPointsExtractor

    def GetInput(self):
        r"""
        GetInput(self) -> btkAcquisition
        Gets the input registered with this process.
        """
        return _btk.btkSpecializedPointsExtractor_GetInput(self)

    def SetInput(self, input):
        r"""
        SetInput(self, input)
        Sets the input required with this process.
        """
        return _btk.btkSpecializedPointsExtractor_SetInput(self, input)

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkPointCollection
        Returns the output created with this process.
        """
        return _btk.btkSpecializedPointsExtractor_GetOutput(self)

    def GetPointType(self):
        r"""
        GetPointType(self) -> btkPoint_impl::Type
        Returns the type of points to extract.
        """
        return _btk.btkSpecializedPointsExtractor_GetPointType(self)

    def SetPointType(self, arg2):
        r"""
        SetPointType(self, btk.btkPoint.Type)
        Sets the type of points to extract.
        """
        return _btk.btkSpecializedPointsExtractor_SetPointType(self, arg2)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkSpecializedPointsExtractor_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkSpecializedPointsExtractor_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkSpecializedPointsExtractor_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkSpecializedPointsExtractor_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkSpecializedPointsExtractor_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkSpecializedPointsExtractor_GetTimestamp(self)

# Register btkSpecializedPointsExtractor in _btk:
_btk.btkSpecializedPointsExtractor_swigregister(btkSpecializedPointsExtractor)

class btkSubAcquisitionFilter(object):
    r"""

    Detect heel strike and toe-off events during gait from vertical ground reaction wrench.

    To fill exactly the detected events, you need to give some extra information to this filter:
     - The value of the first frame of the acquisition where the force platform data were extracted (to be added to the detected frames' index).
     - The acquisition's frequency used by the force platform data (to calculate the time related to the event's frame).
     - The subject's label (optional).
    All these informations have to be given to the method SetAcquisitionInformation().

    To detect the heel strike and toe-off events you can set some options:
     - The threshold value used to known when an event occurred (see SetThresholdValue()).
     - The mapping between the force plates and the side (left, right, general)  of the events detected (see SetForceplateContextMapping()).
     - The region of interest where to detect the events (see SetRegionOfInterest()).

    The algorithm works as following: Based on the region of interest, the maximum is searched. 
    If the maximum is higher than the threshold set, then the frame of the value on the left side of 
    this maximum lower than the threshold is used to create a heel strike event. On the other hand, 
    the value on the right side of the maximum lower than the threshold is used to create a toe-off event.

    Note: The design of this class is not perfect as it cannot be used in a pipeline without 
    to update the part before to know some acquisition's information (first frame, sample frequency, subject's name).
    This class (or the pipeline mechanism) could be modified in a future version of BTK to make up this problem.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    All = _btk.btkSubAcquisitionFilter_All
    
    PointsOnly = _btk.btkSubAcquisitionFilter_PointsOnly
    
    AnalogsOnly = _btk.btkSubAcquisitionFilter_AnalogsOnly
    
    EventsOnly = _btk.btkSubAcquisitionFilter_EventsOnly
    

    def __init__(self):
        r"""
        __init__(self) -> btkSubAcquisitionFilter

        Detect heel strike and toe-off events during gait from vertical ground reaction wrench.

        To fill exactly the detected events, you need to give some extra information to this filter:
         - The value of the first frame of the acquisition where the force platform data were extracted (to be added to the detected frames' index).
         - The acquisition's frequency used by the force platform data (to calculate the time related to the event's frame).
         - The subject's label (optional).
        All these informations have to be given to the method SetAcquisitionInformation().

        To detect the heel strike and toe-off events you can set some options:
         - The threshold value used to known when an event occurred (see SetThresholdValue()).
         - The mapping between the force plates and the side (left, right, general)  of the events detected (see SetForceplateContextMapping()).
         - The region of interest where to detect the events (see SetRegionOfInterest()).

        The algorithm works as following: Based on the region of interest, the maximum is searched. 
        If the maximum is higher than the threshold set, then the frame of the value on the left side of 
        this maximum lower than the threshold is used to create a heel strike event. On the other hand, 
        the value on the right side of the maximum lower than the threshold is used to create a toe-off event.

        Note: The design of this class is not perfect as it cannot be used in a pipeline without 
        to update the part before to know some acquisition's information (first frame, sample frequency, subject's name).
        This class (or the pipeline mechanism) could be modified in a future version of BTK to make up this problem.
        """
        _btk.btkSubAcquisitionFilter_swiginit(self, _btk.new_btkSubAcquisitionFilter())

    def __deref__(self):
        r"""__deref__(self) -> btkSubAcquisitionFilter_impl *"""
        return _btk.btkSubAcquisitionFilter___deref__(self)

    def GetExtractionOption(self, *args):
        r"""
        GetExtractionOption(self) -> btkSubAcquisitionFilter::ExtractionOption
        GetExtractionOption(self, ids) -> btkSubAcquisitionFilter::ExtractionOption
        """
        return _btk.btkSubAcquisitionFilter_GetExtractionOption(self, *args)

    def SetExtractionOption(self, *args):
        r"""
        SetExtractionOption(self, option)
        SetExtractionOption(self, option, ids)
        """
        return _btk.btkSubAcquisitionFilter_SetExtractionOption(self, *args)
    __swig_destroy__ = _btk.delete_btkSubAcquisitionFilter

    def SetInput(self, arg2):
        r"""
        SetInput(self, btkAcquisition)
        Sets the input required with this process.
        """
        return _btk.btkSubAcquisitionFilter_SetInput(self, arg2)

    def GetInput(self):
        r"""
        GetInput(self) -> btkAcquisition
        Gets the input registered with this process.
        """
        return _btk.btkSubAcquisitionFilter_GetInput(self)

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkAcquisition
        Returns the output created with this process.
        """
        return _btk.btkSubAcquisitionFilter_GetOutput(self)

    def GetFramesIndex(self):
        r"""
        GetFramesIndex(self) -> int const *
        Returns the index of the frames to extract. The returned array contains two values, where the first one is the low bound while the second value is the high bound.
        The index starts from 0 and correspond to the first frame of the acquisition. By default, all the frames are extracted and boundaries are set to -1.
        """
        return _btk.btkSubAcquisitionFilter_GetFramesIndex(self)

    def SetFramesIndex(self, lb=-1, ub=-1):
        r"""
        SetFramesIndex(self, lb=-1, ub=-1)
        Set the boundaries of the frames to extract. The default values (-1) reset the extraction to take all the frames.
        """
        return _btk.btkSubAcquisitionFilter_SetFramesIndex(self, lb, ub)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkSubAcquisitionFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkSubAcquisitionFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkSubAcquisitionFilter_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkSubAcquisitionFilter_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkSubAcquisitionFilter_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkSubAcquisitionFilter_GetTimestamp(self)

# Register btkSubAcquisitionFilter in _btk:
_btk.btkSubAcquisitionFilter_swigregister(btkSubAcquisitionFilter)

class btkVerticalGroundReactionForceGaitEventDetector(object):
    r"""Proxy of C++ btkVerticalGroundReactionForceGaitEventDetector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(self) -> btkVerticalGroundReactionForceGaitEventDetector"""
        _btk.btkVerticalGroundReactionForceGaitEventDetector_swiginit(self, _btk.new_btkVerticalGroundReactionForceGaitEventDetector())

    def __deref__(self):
        r"""__deref__(self) -> btkVerticalGroundReactionForceGaitEventDetector_impl *"""
        return _btk.btkVerticalGroundReactionForceGaitEventDetector___deref__(self)
    __swig_destroy__ = _btk.delete_btkVerticalGroundReactionForceGaitEventDetector

    def GetInput(self):
        r"""
        GetInput(self) -> btkWrenchCollection
        Gets the input registered with this process.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetInput(self)

    def SetInput(self, *args):
        r"""
        SetInput(self, arg2)
        SetInput(self, arg2)
        Sets the input required with this process.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_SetInput(self, *args)

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkEventCollection
        Gets the output created with this process.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetOutput(self)

    def SetThresholdValue(self, arg2):
        r"""
        SetThresholdValue(self, arg2)
        Sets the threshold used to detect gait events.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_SetThresholdValue(self, arg2)

    def GetThresholdValue(self):
        r"""
        GetThresholdValue(self) -> int
        Returns the threshold used to detect gait events.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetThresholdValue(self)

    def SetForceplateContextMapping(self, arg2):
        r"""
        SetForceplateContextMapping(self, arg2)
        Sets the mapping between the given wrenches and the side of the detected events. If no mapping is given, then all the detected events will be set as 'General' events.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_SetForceplateContextMapping(self, arg2)

    def GetForceplateContextMapping(self):
        r"""
        GetForceplateContextMapping(self) -> btkStringArray
        Returns the mapping between the wrenches in the input and the gait events to detect.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetForceplateContextMapping(self)

    def SetRegionOfInterest(self, lb=-1, ub=-1):
        r"""
        SetRegionOfInterest(self, lb=-1, ub=-1)
        Sets the region of interest to use to detect gait events.
        WARNING: The boundaries must be set using zero-based indices.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_SetRegionOfInterest(self, lb, ub)

    def GetRegionOfInterest(self):
        r"""
        GetRegionOfInterest(self) -> int const *
        Returns the region of interest to use to detect gait events.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetRegionOfInterest(self)

    def SetAcquisitionInformation(self, arg2, arg3, arg4):
        r"""
        SetAcquisitionInformation(int& ff, double& sampleRate, string& subjectLabel)
        Set the informations required to set correctly the detected events.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_SetAcquisitionInformation(self, arg2, arg3, arg4)

    def GetAcquisitionInformation(self, arg2, arg3, arg4):
        r"""
        GetAcquisitionInformation(int& ff, double& sampleRate, string& subjectLabel)
        Returns the informations required to set correctly the detected events.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetAcquisitionInformation(self, arg2, arg3, arg4)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetTimestamp(self)

# Register btkVerticalGroundReactionForceGaitEventDetector in _btk:
_btk.btkVerticalGroundReactionForceGaitEventDetector_swigregister(btkVerticalGroundReactionForceGaitEventDetector)

class btkWrenchDirectionAngleFilter(object):
    r"""

    Calculate the direction angle of the force vector for each wrench.

    The direction angle is projected on each plane of the global frame in this order:
     - Angle yOz: set in the X component of the output ;
     - Angle xOz: set in the Y component of the output ;
     - Angle xOy: set in the Z component of the output.

    The output angles are expressed in degrees and the range is between 0 and 360 degrees. 
    Then a shift from 360 to 0 is possible if the force turns around itself.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> btkWrenchDirectionAngleFilter

        Calculate the direction angle of the force vector for each wrench.

        The direction angle is projected on each plane of the global frame in this order:
         - Angle yOz: set in the X component of the output ;
         - Angle xOz: set in the Y component of the output ;
         - Angle xOy: set in the Z component of the output.

        The output angles are expressed in degrees and the range is between 0 and 360 degrees. 
        Then a shift from 360 to 0 is possible if the force turns around itself.
        """
        _btk.btkWrenchDirectionAngleFilter_swiginit(self, _btk.new_btkWrenchDirectionAngleFilter())

    def __deref__(self):
        r"""__deref__(self) -> btkWrenchDirectionAngleFilter_impl *"""
        return _btk.btkWrenchDirectionAngleFilter___deref__(self)
    __swig_destroy__ = _btk.delete_btkWrenchDirectionAngleFilter

    def GetInput(self):
        r"""
        GetInput(self) -> btkWrenchCollection
        Gets the input registered with this process.
        """
        return _btk.btkWrenchDirectionAngleFilter_GetInput(self)

    def SetInput(self, input):
        r"""
        SetInput(self, input)
        Sets the input required with this process.
        """
        return _btk.btkWrenchDirectionAngleFilter_SetInput(self, input)

    def GetOutput(self):
        r"""
        GetOutput(self) -> btkPointCollection
        Returns the output created with this process.
        """
        return _btk.btkWrenchDirectionAngleFilter_GetOutput(self)

    def GetInputNumber(self):
        r"""
        GetInputNumber(self) -> int
        Returns the number of inputs.
        """
        return _btk.btkWrenchDirectionAngleFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        r"""
        GetValidInputNumber(self) -> int
        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkWrenchDirectionAngleFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        r"""
        GetOutputNumber(self) -> int
        Returns the number of outputs.
        """
        return _btk.btkWrenchDirectionAngleFilter_GetOutputNumber(self)

    def ResetState(self):
        r"""
        ResetState(self)
        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkWrenchDirectionAngleFilter_ResetState(self)

    def Update(self):
        r"""
        Update(self)
        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkWrenchDirectionAngleFilter_Update(self)

    def GetTimestamp(self):
        r"""
        GetTimestamp(self) -> unsigned long
        Returns the timestamp of the object.
        """
        return _btk.btkWrenchDirectionAngleFilter_GetTimestamp(self)

# Register btkWrenchDirectionAngleFilter in _btk:
_btk.btkWrenchDirectionAngleFilter_swigregister(btkWrenchDirectionAngleFilter)

class btkStringAxes(object):
    r"""

    Workaround to represent the C++ class btk::SeparateKnownVirtualMarkersFilter::StringAxes with SWIG.

    Store four labels corresponding to markers used to define a frame.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, o, a1, a2, a3):
        r"""
        __init__(self, o, a1, a2, a3) -> btkStringAxes

        Workaround to represent the C++ class btk::SeparateKnownVirtualMarkersFilter::StringAxes with SWIG.

        Store four labels corresponding to markers used to define a frame.
        """
        _btk.btkStringAxes_swiginit(self, _btk.new_btkStringAxes(o, a1, a2, a3))
    Origin = property(_btk.btkStringAxes_Origin_get, _btk.btkStringAxes_Origin_set, doc=r"""Origin""")
    Axis1 = property(_btk.btkStringAxes_Axis1_get, _btk.btkStringAxes_Axis1_set, doc=r"""Axis1""")
    Axis2 = property(_btk.btkStringAxes_Axis2_get, _btk.btkStringAxes_Axis2_set, doc=r"""Axis2""")
    Axis3 = property(_btk.btkStringAxes_Axis3_get, _btk.btkStringAxes_Axis3_set, doc=r"""Axis3""")
    __swig_destroy__ = _btk.delete_btkStringAxes

# Register btkStringAxes in _btk:
_btk.btkStringAxes_swigregister(btkStringAxes)

class btkStringAxesList(object):
    r"""Proxy of C++ std::list< btkStringAxes > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(self) -> SwigPyIterator"""
        return _btk.btkStringAxesList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(self) -> bool"""
        return _btk.btkStringAxesList___nonzero__(self)

    def __bool__(self):
        r"""__bool__(self) -> bool"""
        return _btk.btkStringAxesList___bool__(self)

    def __len__(self):
        r"""__len__(self) -> std::list< btkStringAxes >::size_type"""
        return _btk.btkStringAxesList___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(self, i, j) -> btkStringAxesList"""
        return _btk.btkStringAxesList___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(self, i, j)
        __setslice__(self, i, j, v)
        """
        return _btk.btkStringAxesList___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(self, i, j)"""
        return _btk.btkStringAxesList___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _btk.btkStringAxesList___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(self, slice) -> btkStringAxesList
        __getitem__(self, i) -> btkStringAxes
        """
        return _btk.btkStringAxesList___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _btk.btkStringAxesList___setitem__(self, *args)

    def pop(self):
        r"""pop(self) -> btkStringAxes"""
        return _btk.btkStringAxesList_pop(self)

    def append(self, x):
        r"""append(self, x)"""
        return _btk.btkStringAxesList_append(self, x)

    def empty(self):
        r"""empty(self) -> bool"""
        return _btk.btkStringAxesList_empty(self)

    def size(self):
        r"""size(self) -> std::list< btkStringAxes >::size_type"""
        return _btk.btkStringAxesList_size(self)

    def swap(self, v):
        r"""swap(self, v)"""
        return _btk.btkStringAxesList_swap(self, v)

    def begin(self):
        r"""begin(self) -> std::list< btkStringAxes >::iterator"""
        return _btk.btkStringAxesList_begin(self)

    def end(self):
        r"""end(self) -> std::list< btkStringAxes >::iterator"""
        return _btk.btkStringAxesList_end(self)

    def rbegin(self):
        r"""rbegin(self) -> std::list< btkStringAxes >::reverse_iterator"""
        return _btk.btkStringAxesList_rbegin(self)

    def rend(self):
        r"""rend(self) -> std::list< btkStringAxes >::reverse_iterator"""
        return _btk.btkStringAxesList_rend(self)

    def clear(self):
        r"""clear(self)"""
        return _btk.btkStringAxesList_clear(self)

    def get_allocator(self):
        r"""get_allocator(self) -> std::list< btkStringAxes >::allocator_type"""
        return _btk.btkStringAxesList_get_allocator(self)

    def pop_back(self):
        r"""pop_back(self)"""
        return _btk.btkStringAxesList_pop_back(self)

    def erase(self, *args):
        r"""
        erase(self, pos) -> std::list< btkStringAxes >::iterator
        erase(self, first, last) -> std::list< btkStringAxes >::iterator
        """
        return _btk.btkStringAxesList_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(self) -> btkStringAxesList
        __init__(self, other) -> btkStringAxesList
        __init__(self, size) -> btkStringAxesList
        __init__(self, size, value) -> btkStringAxesList
        """
        _btk.btkStringAxesList_swiginit(self, _btk.new_btkStringAxesList(*args))

    def push_back(self, x):
        r"""push_back(self, x)"""
        return _btk.btkStringAxesList_push_back(self, x)

    def front(self):
        r"""front(self) -> btkStringAxes"""
        return _btk.btkStringAxesList_front(self)

    def back(self):
        r"""back(self) -> btkStringAxes"""
        return _btk.btkStringAxesList_back(self)

    def assign(self, n, x):
        r"""assign(self, n, x)"""
        return _btk.btkStringAxesList_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _btk.btkStringAxesList_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(self, pos, x) -> std::list< btkStringAxes >::iterator
        insert(self, pos, n, x)
        """
        return _btk.btkStringAxesList_insert(self, *args)

    def pop_front(self):
        r"""pop_front(self)"""
        return _btk.btkStringAxesList_pop_front(self)

    def push_front(self, x):
        r"""push_front(self, x)"""
        return _btk.btkStringAxesList_push_front(self, x)

    def reverse(self):
        r"""reverse(self)"""
        return _btk.btkStringAxesList_reverse(self)
    __swig_destroy__ = _btk.delete_btkStringAxesList

# Register btkStringAxesList in _btk:
_btk.btkStringAxesList_swigregister(btkStringAxesList)

class btkStringList(object):
    r"""Proxy of C++ std::list< std::string > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(self) -> SwigPyIterator"""
        return _btk.btkStringList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(self) -> bool"""
        return _btk.btkStringList___nonzero__(self)

    def __bool__(self):
        r"""__bool__(self) -> bool"""
        return _btk.btkStringList___bool__(self)

    def __len__(self):
        r"""__len__(self) -> std::list< std::string >::size_type"""
        return _btk.btkStringList___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(self, i, j) -> btkStringList"""
        return _btk.btkStringList___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(self, i, j)
        __setslice__(self, i, j, v)
        """
        return _btk.btkStringList___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(self, i, j)"""
        return _btk.btkStringList___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _btk.btkStringList___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(self, slice) -> btkStringList
        __getitem__(self, i) -> std::list< std::string >::value_type const &
        """
        return _btk.btkStringList___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _btk.btkStringList___setitem__(self, *args)

    def pop(self):
        r"""pop(self) -> std::list< std::string >::value_type"""
        return _btk.btkStringList_pop(self)

    def append(self, x):
        r"""append(self, x)"""
        return _btk.btkStringList_append(self, x)

    def empty(self):
        r"""empty(self) -> bool"""
        return _btk.btkStringList_empty(self)

    def size(self):
        r"""size(self) -> std::list< std::string >::size_type"""
        return _btk.btkStringList_size(self)

    def swap(self, v):
        r"""swap(self, v)"""
        return _btk.btkStringList_swap(self, v)

    def begin(self):
        r"""begin(self) -> std::list< std::string >::iterator"""
        return _btk.btkStringList_begin(self)

    def end(self):
        r"""end(self) -> std::list< std::string >::iterator"""
        return _btk.btkStringList_end(self)

    def rbegin(self):
        r"""rbegin(self) -> std::list< std::string >::reverse_iterator"""
        return _btk.btkStringList_rbegin(self)

    def rend(self):
        r"""rend(self) -> std::list< std::string >::reverse_iterator"""
        return _btk.btkStringList_rend(self)

    def clear(self):
        r"""clear(self)"""
        return _btk.btkStringList_clear(self)

    def get_allocator(self):
        r"""get_allocator(self) -> std::list< std::string >::allocator_type"""
        return _btk.btkStringList_get_allocator(self)

    def pop_back(self):
        r"""pop_back(self)"""
        return _btk.btkStringList_pop_back(self)

    def erase(self, *args):
        r"""
        erase(self, pos) -> std::list< std::string >::iterator
        erase(self, first, last) -> std::list< std::string >::iterator
        """
        return _btk.btkStringList_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(self) -> btkStringList
        __init__(self, other) -> btkStringList
        __init__(self, size) -> btkStringList
        __init__(self, size, value) -> btkStringList
        """
        _btk.btkStringList_swiginit(self, _btk.new_btkStringList(*args))

    def push_back(self, x):
        r"""push_back(self, x)"""
        return _btk.btkStringList_push_back(self, x)

    def front(self):
        r"""front(self) -> std::list< std::string >::value_type const &"""
        return _btk.btkStringList_front(self)

    def back(self):
        r"""back(self) -> std::list< std::string >::value_type const &"""
        return _btk.btkStringList_back(self)

    def assign(self, n, x):
        r"""assign(self, n, x)"""
        return _btk.btkStringList_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _btk.btkStringList_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(self, pos, x) -> std::list< std::string >::iterator
        insert(self, pos, n, x)
        """
        return _btk.btkStringList_insert(self, *args)

    def pop_front(self):
        r"""pop_front(self)"""
        return _btk.btkStringList_pop_front(self)

    def push_front(self, x):
        r"""push_front(self, x)"""
        return _btk.btkStringList_push_front(self, x)

    def reverse(self):
        r"""reverse(self)"""
        return _btk.btkStringList_reverse(self)
    __swig_destroy__ = _btk.delete_btkStringList

# Register btkStringList in _btk:
_btk.btkStringList_swigregister(btkStringList)



