import btk
import unittest

class EventCollectionTest(unittest.TestCase):
    def test_default_ctor(self):
        ec = btk.btkEventCollection()
        self.assertEqual(ec.GetItemNumber(), 0)
        
    def test_item_number(self):
        ec = btk.btkEventCollection()
        ec.SetItemNumber(5)
        self.assertEqual(ec.GetItemNumber(), 5)
        
    def test_insert(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        self.assertEqual(ec.GetItemNumber(), 1)
        e1 = ec.GetItem(0)
        self.assertEqual(e1.GetLabel(), 'FOO')
        self.assertEqual(e1.GetTime(), 1.52)
        self.assertEqual(e1.GetFrame(), -1)
        self.assertEqual(e1.GetContext(), 'Right')
        self.assertEqual(e1.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e1.GetSubject(), 'Bar')
        self.assertEqual(e1.GetDescription(), '')
        self.assertEqual(e1.GetId(), 1)
        e2 = btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2)
        ec.InsertItem(e2)
        e2_ = ec.GetItem(1);
        self.assertEqual(e2.GetLabel(), e2_.GetLabel())
        self.assertEqual(e2.GetTime(), e2_.GetTime())
        self.assertEqual(e2.GetFrame(), e2_.GetFrame())
        self.assertEqual(e2.GetContext(), e2_.GetContext())
        self.assertEqual(e2.GetDetectionFlags(), e2_.GetDetectionFlags())
        self.assertEqual(e2.GetSubject(), e2_.GetSubject())
        self.assertEqual(e2.GetDescription(), e2_.GetDescription())
        self.assertEqual(e2.GetId(), e2_.GetId())
        e2.SetLabel('Unknown')
        self.assertEqual(e2.GetLabel(), e2_.GetLabel())
        self.assertEqual(e2.GetTime(), e2_.GetTime())
        self.assertEqual(e2.GetFrame(), e2_.GetFrame())
        self.assertEqual(e2.GetContext(), e2_.GetContext())
        self.assertEqual(e2.GetDetectionFlags(), e2_.GetDetectionFlags())
        self.assertEqual(e2.GetSubject(), e2_.GetSubject())
        self.assertEqual(e2.GetDescription(), e2_.GetDescription())
        self.assertEqual(e2.GetId(), e2_.GetId())
        e2_.SetTime(1.45)
        self.assertEqual(e2.GetLabel(), e2_.GetLabel())
        self.assertEqual(e2.GetTime(), e2_.GetTime())
        self.assertEqual(e2.GetFrame(), e2_.GetFrame())
        self.assertEqual(e2.GetContext(), e2_.GetContext())
        self.assertEqual(e2.GetDetectionFlags(), e2_.GetDetectionFlags())
        self.assertEqual(e2.GetSubject(), e2_.GetSubject())
        self.assertEqual(e2.GetDescription(), e2_.GetDescription())
        self.assertEqual(e2.GetId(), e2_.GetId())
        
    def test_insert_index_first(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(0, btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        ec.InsertItem(0, btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2))
        e2 = ec.GetItem(0)
        self.assertEqual(e2.GetLabel(), 'BAR')
        self.assertEqual(e2.GetTime(), 2.03)
        self.assertEqual(e2.GetFrame(), -1)
        self.assertEqual(e2.GetContext(), 'Left')
        self.assertEqual(e2.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e2.GetSubject(), 'Foo')
        self.assertEqual(e2.GetDescription(), '')
        self.assertEqual(e2.GetId(), 2)
        e1 = ec.GetItem(1)
        self.assertEqual(e1.GetLabel(), 'FOO')
        self.assertEqual(e1.GetTime(), 1.52)
        self.assertEqual(e1.GetFrame(), -1)
        self.assertEqual(e1.GetContext(), 'Right')
        self.assertEqual(e1.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e1.GetSubject(), 'Bar')
        self.assertEqual(e1.GetDescription(), '')
        self.assertEqual(e1.GetId(), 1)
        
    def test_insert_index_last(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(0, btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        ec.InsertItem(1, btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2))
        e2 = ec.GetItem(1)
        self.assertEqual(e2.GetLabel(), 'BAR')
        self.assertEqual(e2.GetTime(), 2.03)
        self.assertEqual(e2.GetFrame(), -1)
        self.assertEqual(e2.GetContext(), 'Left')
        self.assertEqual(e2.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e2.GetSubject(), 'Foo')
        self.assertEqual(e2.GetDescription(), '')
        self.assertEqual(e2.GetId(), 2)
        e1 = ec.GetItem(0)
        self.assertEqual(e1.GetLabel(), 'FOO')
        self.assertEqual(e1.GetTime(), 1.52)
        self.assertEqual(e1.GetFrame(), -1)
        self.assertEqual(e1.GetContext(), 'Right')
        self.assertEqual(e1.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e1.GetSubject(), 'Bar')
        self.assertEqual(e1.GetDescription(), '')
        self.assertEqual(e1.GetId(), 1)
        
    def test_insert_index_middle(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        ec.InsertItem(btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2))
        ec.InsertItem(1, btk.btkEvent('FOOBAR', 5.05, 'General', btk.btkEvent.Automatic, 'FooBar', '', 3))
        self.assertEqual(ec.GetItemNumber(), 3)
        e = ec.GetItem(1)
        self.assertEqual(e.GetLabel(), 'FOOBAR')
        self.assertEqual(e.GetTime(), 5.05)
        self.assertEqual(e.GetFrame(), -1)
        self.assertEqual(e.GetContext(), 'General')
        self.assertEqual(e.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e.GetSubject(), 'FooBar')
        self.assertEqual(e.GetDescription(), '')
        self.assertEqual(e.GetId(), 3)
        
    def test_take(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        ec.InsertItem(btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2))
        self.assertEqual(ec.GetItemNumber(), 2)
        e1 = ec.TakeItem(0)
        self.assertEqual(ec.GetItemNumber(), 1)
        self.assertEqual(e1.GetLabel(), 'FOO')
        self.assertEqual(e1.GetTime(), 1.52)
        self.assertEqual(e1.GetFrame(), -1)
        self.assertEqual(e1.GetContext(), 'Right')
        self.assertEqual(e1.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e1.GetSubject(), 'Bar')
        self.assertEqual(e1.GetDescription(), '')
        self.assertEqual(e1.GetId(), 1)
        e2 = ec.GetItem(0)
        self.assertEqual(e2.GetLabel(), 'BAR')
        self.assertEqual(e2.GetTime(), 2.03)
        self.assertEqual(e2.GetFrame(), -1)
        self.assertEqual(e2.GetContext(), 'Left')
        self.assertEqual(e2.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e2.GetSubject(), 'Foo')
        self.assertEqual(e2.GetDescription(), '')
        self.assertEqual(e2.GetId(), 2)
        ec.Clear()
        self.assertEqual(ec.GetItemNumber(), 0)
        
    def test_iterator(self):
        ec = btk.btkEventCollection()
        ec.SetItemNumber(5)
        for i in range(0,5):
            e = btk.btkEvent()
            e.SetId(i)
            ec.SetItem(i, e)
        inc = 0
        i = ec.Begin()
        while i != ec.End():
            self.assertEqual(i.value().GetId(), inc)
            inc = inc + 1
            i.incr()
        inc = 0
        i = ec.Begin()
        while i != ec.End():
            i.value().SetId(inc * 10)
            self.assertEqual(i.value().GetId(), inc * 10)
            inc = inc + 1
            i.incr()
    
    def test_iterator_insert_begin(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(ec.Begin(), btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        ec.InsertItem(ec.Begin(), btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2))
        e2 = ec.GetItem(0)
        self.assertEqual(e2.GetLabel(), 'BAR')
        self.assertEqual(e2.GetTime(), 2.03)
        self.assertEqual(e2.GetFrame(), -1)
        self.assertEqual(e2.GetContext(), 'Left')
        self.assertEqual(e2.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e2.GetSubject(), 'Foo')
        self.assertEqual(e2.GetDescription(), '')
        self.assertEqual(e2.GetId(), 2)
        e1 = ec.GetItem(1)
        self.assertEqual(e1.GetLabel(), 'FOO')
        self.assertEqual(e1.GetTime(), 1.52)
        self.assertEqual(e1.GetFrame(), -1)
        self.assertEqual(e1.GetContext(), 'Right')
        self.assertEqual(e1.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e1.GetSubject(), 'Bar')
        self.assertEqual(e1.GetDescription(), '')
        self.assertEqual(e1.GetId(), 1)
        
    def test_iterator_insert_end(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(ec.End(), btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        ec.InsertItem(ec.End(), btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2))
        e2 = ec.GetItem(1)
        self.assertEqual(e2.GetLabel(), 'BAR')
        self.assertEqual(e2.GetTime(), 2.03)
        self.assertEqual(e2.GetFrame(), -1)
        self.assertEqual(e2.GetContext(), 'Left')
        self.assertEqual(e2.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e2.GetSubject(), 'Foo')
        self.assertEqual(e2.GetDescription(), '')
        self.assertEqual(e2.GetId(), 2)
        e1 = ec.GetItem(0)
        self.assertEqual(e1.GetLabel(), 'FOO')
        self.assertEqual(e1.GetTime(), 1.52)
        self.assertEqual(e1.GetFrame(), -1)
        self.assertEqual(e1.GetContext(), 'Right')
        self.assertEqual(e1.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e1.GetSubject(), 'Bar')
        self.assertEqual(e1.GetDescription(), '')
        self.assertEqual(e1.GetId(), 1)
        
    def test_iterator_insert_middle(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        ec.InsertItem(btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2))
        i = ec.Begin()
        i.incr()
        ec.InsertItem(i, btk.btkEvent('FOOBAR', 5.05, 'General', btk.btkEvent.Automatic, 'FooBar', '', 3))
        self.assertEqual(ec.GetItemNumber(), 3)
        e = ec.GetItem(1)
        self.assertEqual(e.GetLabel(), 'FOOBAR')
        self.assertEqual(e.GetTime(), 5.05)
        self.assertEqual(e.GetFrame(), -1)
        self.assertEqual(e.GetContext(), 'General')
        self.assertEqual(e.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e.GetSubject(), 'FooBar')
        self.assertEqual(e.GetDescription(), '')
        self.assertEqual(e.GetId(), 3)
        
    def test_iterator_remove_begin(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        ec.InsertItem(btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2))
        ec.InsertItem(btk.btkEvent('FOOBAR', 5.05, 'General', btk.btkEvent.Automatic, 'FooBar', '', 3))
        self.assertEqual(ec.GetItemNumber(), 3)
        ec.RemoveItem(ec.Begin())
        self.assertEqual(ec.GetItemNumber(), 2)
        e2 = ec.GetItem(0)
        self.assertEqual(e2.GetLabel(), 'BAR')
        self.assertEqual(e2.GetTime(), 2.03)
        self.assertEqual(e2.GetFrame(), -1)
        self.assertEqual(e2.GetContext(), 'Left')
        self.assertEqual(e2.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e2.GetSubject(), 'Foo')
        self.assertEqual(e2.GetDescription(), '')
        self.assertEqual(e2.GetId(), 2)
        e3 = ec.GetItem(1)
        self.assertEqual(e3.GetLabel(), 'FOOBAR')
        self.assertEqual(e3.GetTime(), 5.05)
        self.assertEqual(e3.GetFrame(), -1)
        self.assertEqual(e3.GetContext(), 'General')
        self.assertEqual(e3.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e3.GetSubject(), 'FooBar')
        self.assertEqual(e3.GetDescription(), '')
        self.assertEqual(e3.GetId(), 3)
        
    def test_iterator_remove_end(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        ec.InsertItem(btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2))
        ec.InsertItem(btk.btkEvent('FOOBAR', 5.05, 'General', btk.btkEvent.Automatic, 'FooBar', '', 3))
        self.assertEqual(ec.GetItemNumber(), 3)
        i = ec.End()
        i.decr()
        ec.RemoveItem(i)
        self.assertEqual(ec.GetItemNumber(), 2)
        e1 = ec.GetItem(0)
        self.assertEqual(e1.GetLabel(), 'FOO')
        self.assertEqual(e1.GetTime(), 1.52)
        self.assertEqual(e1.GetFrame(), -1)
        self.assertEqual(e1.GetContext(), 'Right')
        self.assertEqual(e1.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e1.GetSubject(), 'Bar')
        self.assertEqual(e1.GetDescription(), '')
        self.assertEqual(e1.GetId(), 1)
        e2 = ec.GetItem(1)
        self.assertEqual(e2.GetLabel(), 'BAR')
        self.assertEqual(e2.GetTime(), 2.03)
        self.assertEqual(e2.GetFrame(), -1)
        self.assertEqual(e2.GetContext(), 'Left')
        self.assertEqual(e2.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e2.GetSubject(), 'Foo')
        self.assertEqual(e2.GetDescription(), '')
        self.assertEqual(e2.GetId(), 2)
    
    def test_iterator_remove_middle(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        ec.InsertItem(btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2))
        ec.InsertItem(btk.btkEvent('FOOBAR', 5.05, 'General', btk.btkEvent.Automatic, 'FooBar', '', 3))
        i = ec.Begin()
        i.incr()
        ec.RemoveItem(i)
        self.assertEqual(ec.GetItemNumber(), 2)
        e = ec.GetItem(1)
        self.assertEqual(e.GetLabel(), 'FOOBAR')
        self.assertEqual(e.GetTime(), 5.05)
        self.assertEqual(e.GetFrame(), -1)
        self.assertEqual(e.GetContext(), 'General')
        self.assertEqual(e.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e.GetSubject(), 'FooBar')
        self.assertEqual(e.GetDescription(), '')
        self.assertEqual(e.GetId(), 3)
        
    def test_iterator_remove_clear(self):
        ec = btk.btkEventCollection()
        ec.SetItemNumber(5)
        for i in range(0,5):
            e = btk.btkEvent()
            e.SetId(i)
            ec.SetItem(i, e)
        i = ec.Begin()
        while i != ec.End():
            i = ec.RemoveItem(i)
        self.assertEqual(ec.GetItemNumber(), 0)
    
    def test_iterator_take_begin(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        ec.InsertItem(btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2))
        ec.InsertItem(btk.btkEvent('FOOBAR', 5.05, 'General', btk.btkEvent.Automatic, 'FooBar', '', 3))
        self.assertEqual(ec.GetItemNumber(), 3)
        e1 = ec.TakeItem(ec.Begin())
        self.assertEqual(ec.GetItemNumber(), 2)
        self.assertEqual(e1.GetLabel(), 'FOO')
        self.assertEqual(e1.GetTime(), 1.52)
        self.assertEqual(e1.GetFrame(), -1)
        self.assertEqual(e1.GetContext(), 'Right')
        self.assertEqual(e1.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e1.GetSubject(), 'Bar')
        self.assertEqual(e1.GetDescription(), '')
        self.assertEqual(e1.GetId(), 1)
        e2 = ec.GetItem(0)
        self.assertEqual(e2.GetLabel(), 'BAR')
        self.assertEqual(e2.GetTime(), 2.03)
        self.assertEqual(e2.GetFrame(), -1)
        self.assertEqual(e2.GetContext(), 'Left')
        self.assertEqual(e2.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e2.GetSubject(), 'Foo')
        self.assertEqual(e2.GetDescription(), '')
        self.assertEqual(e2.GetId(), 2)
        e3 = ec.GetItem(1)
        self.assertEqual(e3.GetLabel(), 'FOOBAR')
        self.assertEqual(e3.GetTime(), 5.05)
        self.assertEqual(e3.GetFrame(), -1)
        self.assertEqual(e3.GetContext(), 'General')
        self.assertEqual(e3.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e3.GetSubject(), 'FooBar')
        self.assertEqual(e3.GetDescription(), '')
        self.assertEqual(e3.GetId(), 3)
    
    def test_iterator_take_end(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        ec.InsertItem(btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2))
        ec.InsertItem(btk.btkEvent('FOOBAR', 5.05, 'General', btk.btkEvent.Automatic, 'FooBar', '', 3))
        self.assertEqual(ec.GetItemNumber(), 3)
        i = ec.End(); i.decr()
        e3 = ec.TakeItem(i)
        e1 = ec.GetItem(0)
        self.assertEqual(ec.GetItemNumber(), 2)
        self.assertEqual(e1.GetLabel(), 'FOO')
        self.assertEqual(e1.GetTime(), 1.52)
        self.assertEqual(e1.GetFrame(), -1)
        self.assertEqual(e1.GetContext(), 'Right')
        self.assertEqual(e1.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e1.GetSubject(), 'Bar')
        self.assertEqual(e1.GetDescription(), '')
        self.assertEqual(e1.GetId(), 1)
        e2 = ec.GetItem(1)
        self.assertEqual(e2.GetLabel(), 'BAR')
        self.assertEqual(e2.GetTime(), 2.03)
        self.assertEqual(e2.GetFrame(), -1)
        self.assertEqual(e2.GetContext(), 'Left')
        self.assertEqual(e2.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e2.GetSubject(), 'Foo')
        self.assertEqual(e2.GetDescription(), '')
        self.assertEqual(e2.GetId(), 2)
        # e3
        self.assertEqual(e3.GetLabel(), 'FOOBAR')
        self.assertEqual(e3.GetTime(), 5.05)
        self.assertEqual(e3.GetFrame(), -1)
        self.assertEqual(e3.GetContext(), 'General')
        self.assertEqual(e3.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e3.GetSubject(), 'FooBar')
        self.assertEqual(e3.GetDescription(), '')
        self.assertEqual(e3.GetId(), 3)
    
    def test_iterator_take_middle(self):
        ec = btk.btkEventCollection()
        ec.InsertItem(btk.btkEvent('FOO', 1.52, 'Right', btk.btkEvent.Manual, 'Bar', '', 1))
        ec.InsertItem(btk.btkEvent('BAR', 2.03, 'Left', btk.btkEvent.Automatic, 'Foo', '', 2))
        ec.InsertItem(btk.btkEvent('FOOBAR', 5.05, 'General', btk.btkEvent.Automatic, 'FooBar', '', 3))
        self.assertEqual(ec.GetItemNumber(), 3)
        i = ec.Begin(); i.incr()
        e2 = ec.TakeItem(i)
        e1 = ec.GetItem(0)
        self.assertEqual(ec.GetItemNumber(), 2)
        self.assertEqual(e1.GetLabel(), 'FOO')
        self.assertEqual(e1.GetTime(), 1.52)
        self.assertEqual(e1.GetFrame(), -1)
        self.assertEqual(e1.GetContext(), 'Right')
        self.assertEqual(e1.GetDetectionFlags(), btk.btkEvent.Manual)
        self.assertEqual(e1.GetSubject(), 'Bar')
        self.assertEqual(e1.GetDescription(), '')
        self.assertEqual(e1.GetId(), 1)
        # e2
        self.assertEqual(e2.GetLabel(), 'BAR')
        self.assertEqual(e2.GetTime(), 2.03)
        self.assertEqual(e2.GetFrame(), -1)
        self.assertEqual(e2.GetContext(), 'Left')
        self.assertEqual(e2.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e2.GetSubject(), 'Foo')
        self.assertEqual(e2.GetDescription(), '')
        self.assertEqual(e2.GetId(), 2)
        e3 = ec.GetItem(1)
        self.assertEqual(e3.GetLabel(), 'FOOBAR')
        self.assertEqual(e3.GetTime(), 5.05)
        self.assertEqual(e3.GetFrame(), -1)
        self.assertEqual(e3.GetContext(), 'General')
        self.assertEqual(e3.GetDetectionFlags(), btk.btkEvent.Automatic)
        self.assertEqual(e3.GetSubject(), 'FooBar')
        self.assertEqual(e3.GetDescription(), '')
        self.assertEqual(e3.GetId(), 3)