/*!
 * Copyright (c) 2012 - 2018, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
!function(e,t){t(e.Bokeh)}(this,function(Bokeh){var define;return function(e,t,n){if(null!=Bokeh)return Bokeh.register_plugin(e,{"models/widgets/tables/cell_editors":478,"models/widgets/tables/cell_formatters":479,"models/widgets/tables/data_cube":480,"models/widgets/tables/data_table":481,"models/widgets/tables/index":482,"models/widgets/tables/main":483,"models/widgets/tables/row_aggregators":484,"models/widgets/tables/table_column":485,"models/widgets/tables/table_widget":486,"models/widgets/widget":487,"styles/widgets/slickgrid":488,"styles/widgets/tables":489},483);throw new Error("Cannot find Bokeh. You have to load it prior to loading plugins.")}({478:function(e,t,n){var o=e(426),r=e(18),i=e(5),A=e(6),l=e(62),a=e(481),s=e(489),c=function(e){function t(t){var n=e.call(this,o.__assign({model:t.column.model},t))||this;return n.args=t,n.render(),n}return o.__extends(t,e),Object.defineProperty(t.prototype,"emptyValue",{get:function(){return null},enumerable:!0,configurable:!0}),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.inputEl=this._createInput(),this.defaultValue=null},t.prototype.css_classes=function(){return e.prototype.css_classes.call(this).concat(s.bk_cell_editor)},t.prototype.render=function(){e.prototype.render.call(this),this.args.container.append(this.el),this.el.appendChild(this.inputEl),this.renderEditor(),this.disableNavigation()},t.prototype.renderEditor=function(){},t.prototype.disableNavigation=function(){this.inputEl.addEventListener("keydown",function(e){switch(e.keyCode){case i.Keys.Left:case i.Keys.Right:case i.Keys.Up:case i.Keys.Down:case i.Keys.PageUp:case i.Keys.PageDown:e.stopImmediatePropagation()}})},t.prototype.destroy=function(){this.remove()},t.prototype.focus=function(){this.inputEl.focus()},t.prototype.show=function(){},t.prototype.hide=function(){},t.prototype.position=function(){},t.prototype.getValue=function(){return this.inputEl.value},t.prototype.setValue=function(e){this.inputEl.value=e},t.prototype.serializeValue=function(){return this.getValue()},t.prototype.isValueChanged=function(){return!(""==this.getValue()&&null==this.defaultValue)&&this.getValue()!==this.defaultValue},t.prototype.applyValue=function(e,t){var n=this.args.grid.getData(),o=n.index.indexOf(e[a.DTINDEX_NAME]);n.setField(o,this.args.column.field,t)},t.prototype.loadValue=function(e){var t=e[this.args.column.field];this.defaultValue=null!=t?t:this.emptyValue,this.setValue(this.defaultValue)},t.prototype.validateValue=function(e){if(this.args.column.validator){var t=this.args.column.validator(e);if(!t.valid)return t}return{valid:!0,msg:null}},t.prototype.validate=function(){return this.validateValue(this.getValue())},t.__name__="CellEditorView",t}(A.DOMView);n.CellEditorView=c;var u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.__name__="CellEditor",t}(l.Model);n.CellEditor=u;var d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),Object.defineProperty(t.prototype,"emptyValue",{get:function(){return""},enumerable:!0,configurable:!0}),t.prototype._createInput=function(){return i.input({type:"text"})},t.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},t.prototype.loadValue=function(t){e.prototype.loadValue.call(this,t),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()},t.__name__="StringEditorView",t}(c);n.StringEditorView=d;var p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.default_view=d,this.define({completions:[r.Array,[]]})},t.__name__="StringEditor",t}(u);n.StringEditor=p,p.initClass();var f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.textarea()},t.__name__="TextEditorView",t}(c);n.TextEditorView=f;var h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.default_view=f},t.__name__="TextEditor",t}(u);n.TextEditor=h,h.initClass();var g=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.select()},t.prototype.renderEditor=function(){for(var e=0,t=this.model.options;e<t.length;e++){var n=t[e];this.inputEl.appendChild(i.option({value:n},n))}this.focus()},t.__name__="SelectEditorView",t}(c);n.SelectEditorView=g;var m=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.default_view=g,this.define({options:[r.Array,[]]})},t.__name__="SelectEditor",t}(u);n.SelectEditor=m,m.initClass();var v=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"text"})},t.__name__="PercentEditorView",t}(c);n.PercentEditorView=v;var w=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.default_view=v},t.__name__="PercentEditor",t}(u);n.PercentEditor=w,w.initClass();var C=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"checkbox",value:"true"})},t.prototype.renderEditor=function(){this.focus()},t.prototype.loadValue=function(e){this.defaultValue=!!e[this.args.column.field],this.inputEl.checked=this.defaultValue},t.prototype.serializeValue=function(){return this.inputEl.checked},t.__name__="CheckboxEditorView",t}(c);n.CheckboxEditorView=C;var y=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.default_view=C},t.__name__="CheckboxEditor",t}(u);n.CheckboxEditor=y,y.initClass();var b=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"text"})},t.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},t.prototype.remove=function(){e.prototype.remove.call(this)},t.prototype.serializeValue=function(){return parseInt(this.getValue(),10)||0},t.prototype.loadValue=function(t){e.prototype.loadValue.call(this,t),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()},t.prototype.validateValue=function(t){return isNaN(t)?{valid:!1,msg:"Please enter a valid integer"}:e.prototype.validateValue.call(this,t)},t.__name__="IntEditorView",t}(c);n.IntEditorView=b;var x=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.default_view=b,this.define({step:[r.Number,1]})},t.__name__="IntEditor",t}(u);n.IntEditor=x,x.initClass();var k=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"text"})},t.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},t.prototype.remove=function(){e.prototype.remove.call(this)},t.prototype.serializeValue=function(){return parseFloat(this.getValue())||0},t.prototype.loadValue=function(t){e.prototype.loadValue.call(this,t),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()},t.prototype.validateValue=function(t){return isNaN(t)?{valid:!1,msg:"Please enter a valid number"}:e.prototype.validateValue.call(this,t)},t.__name__="NumberEditorView",t}(c);n.NumberEditorView=k;var R=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.default_view=k,this.define({step:[r.Number,.01]})},t.__name__="NumberEditor",t}(u);n.NumberEditor=R,R.initClass();var S=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"text"})},t.__name__="TimeEditorView",t}(c);n.TimeEditorView=S;var E=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.default_view=S},t.__name__="TimeEditor",t}(u);n.TimeEditor=E,E.initClass();var _=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"text"})},Object.defineProperty(t.prototype,"emptyValue",{get:function(){return new Date},enumerable:!0,configurable:!0}),t.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},t.prototype.destroy=function(){e.prototype.destroy.call(this)},t.prototype.show=function(){e.prototype.show.call(this)},t.prototype.hide=function(){e.prototype.hide.call(this)},t.prototype.position=function(){return e.prototype.position.call(this)},t.prototype.getValue=function(){},t.prototype.setValue=function(e){},t.__name__="DateEditorView",t}(c);n.DateEditorView=_;var T=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.default_view=_},t.__name__="DateEditor",t}(u);n.DateEditor=T,T.initClass()},479:function(e,t,n){var o=e(426),r=e(396),i=e(505),A=e(425),l=e(18),a=e(5),s=e(46),c=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.prototype.doFormat=function(e,t,n,o,r){return null==n?"":(n+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")},t.__name__="CellFormatter",t}(e(62).Model);n.CellFormatter=c;var u=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.define({font_style:[l.FontStyle,"normal"],text_align:[l.TextAlign,"left"],text_color:[l.Color]})},t.prototype.doFormat=function(e,t,n,o,r){var i=this.font_style,A=this.text_align,l=this.text_color,s=a.div({},null==n?"":""+n);switch(i){case"bold":s.style.fontWeight="bold";break;case"italic":s.style.fontStyle="italic"}return null!=A&&(s.style.textAlign=A),null!=l&&(s.style.color=l),s.outerHTML},t.__name__="StringFormatter",t}(c);n.StringFormatter=u,u.initClass();var d=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.define({format:[l.String,"0,0"],language:[l.String,"en"],rounding:[l.RoundingFunction,"round"]})},t.prototype.doFormat=function(t,n,o,i,A){var l=this,a=this.format,s=this.language,c=function(){switch(l.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}}();return o=r.format(o,a,s,c),e.prototype.doFormat.call(this,t,n,o,i,A)},t.__name__="NumberFormatter",t}(u);n.NumberFormatter=d,d.initClass();var p=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.define({icon:[l.String,"check"]})},t.prototype.doFormat=function(e,t,n,o,r){return n?a.i({class:this.icon}).outerHTML:""},t.__name__="BooleanFormatter",t}(c);n.BooleanFormatter=p,p.initClass();var f=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.define({format:[l.String,"ISO-8601"]})},t.prototype.getFormat=function(){switch(this.format){case"ATOM":case"W3C":case"RFC-3339":case"ISO-8601":return"%Y-%m-%d";case"COOKIE":return"%a, %d %b %Y";case"RFC-850":return"%A, %d-%b-%y";case"RFC-1123":case"RFC-2822":return"%a, %e %b %Y";case"RSS":case"RFC-822":case"RFC-1036":return"%a, %e %b %y";case"TIMESTAMP":return;default:return this.format}},t.prototype.doFormat=function(t,n,o,r,i){o=s.isString(o)?parseInt(o,10):o;var l=A(o,this.getFormat());return e.prototype.doFormat.call(this,t,n,l,r,i)},t.__name__="DateFormatter",t}(c);n.DateFormatter=f,f.initClass();var h=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.define({template:[l.String,"<%= value %>"]})},t.prototype.doFormat=function(e,t,n,r,A){var l=this.template;return null==n?"":i(l)(o.__assign({},A,{value:n}))},t.__name__="HTMLTemplateFormatter",t}(c);n.HTMLTemplateFormatter=h,h.initClass()},480:function(e,t,n){var o=e(426),r=e(18),i=e(5),A=e(491),l=e(481);function a(e,t,n,o,r){var A=r.collapsed,l=r.level,a=r.title,s=i.span({class:"slick-group-toggle "+(A?"collapsed":"expanded"),style:{"margin-left":15*l+"px"}}),c=i.span({class:"slick-group-title",level:l},a);return""+s.outerHTML+c.outerHTML}function s(e,t){var n=this.getDataItem(t.row);n instanceof A.Group&&e.target.classList.contains("slick-group-toggle")&&(n.collapsed?this.getData().expandGroup(n.groupingKey):this.getData().collapseGroup(n.groupingKey),e.stopImmediatePropagation(),e.preventDefault(),this.invalidate(),this.render())}var c=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="GroupingInfo",this.define({getter:[r.String,""],aggregators:[r.Array,[]],collapsed:[r.Boolean,!1]})},Object.defineProperty(t.prototype,"comparer",{get:function(){return function(e,t){return e.value===t.value?0:e.value>t.value?1:-1}},enumerable:!0,configurable:!0}),t.__name__="GroupingInfo",t}(e(62).Model);n.GroupingInfo=c,c.initClass();var u=function(e){function t(t,n,o,r){var i=e.call(this,t,n)||this;return i.columns=o,i.groupingInfos=[],i.groupingDelimiter=":|:",i.target=r,i}return o.__extends(t,e),t.prototype.setGrouping=function(e){this.groupingInfos=e,this.toggledGroupsByLevel=e.map(function(){return{}}),this.refresh()},t.prototype.extractGroups=function(e,t){var n=this,o=[],r=new Map,i=t?t.level+1:0,l=this.groupingInfos[i],a=l.comparer,s=l.getter;return e.forEach(function(e){var l=n.source.data[s][e],a=r.get(l);if(!a){var c=t?""+t.groupingKey+n.groupingDelimiter+l:""+l;a=Object.assign(new A.Group,{value:l,level:i,groupingKey:c}),o.push(a),r.set(l,a)}a.rows.push(e)}),i<this.groupingInfos.length-1&&o.forEach(function(e){e.groups=n.extractGroups(e.rows,e)}),o.sort(a),o},t.prototype.calculateTotals=function(e,t){var n={avg:{},max:{},min:{},sum:{}},r=this.source.data,i=Object.keys(r),A=e.rows.map(function(e){return i.reduce(function(t,n){var i;return o.__assign({},t,((i={})[n]=r[n][e],i))},{})});return t.forEach(function(e){e.init(),A.forEach(function(t){return e.accumulate(t)}),e.storeResult(n)}),n},t.prototype.addTotals=function(e,t){var n=this;void 0===t&&(t=0);var o=this.groupingInfos[t],r=o.aggregators,i=o.collapsed,A=this.toggledGroupsByLevel[t];e.forEach(function(e){e.groups&&n.addTotals(e.groups,t+1),r.length&&e.rows.length&&(e.totals=n.calculateTotals(e,r)),e.collapsed=i!==A[e.groupingKey],e.title=e.value?""+e.value:""})},t.prototype.flattenedGroupedRows=function(e,t){var n=this;void 0===t&&(t=0);var o=[];return e.forEach(function(e){if(o.push(e),!e.collapsed){var r=e.groups?n.flattenedGroupedRows(e.groups,t+1):e.rows;o.push.apply(o,r)}}),o},t.prototype.refresh=function(){var e=this.extractGroups(this.view.indices),t=this.source.data[this.columns[0].field];e.length&&(this.addTotals(e),this.rows=this.flattenedGroupedRows(e),this.target.data={row_indices:this.rows.map(function(e){return e instanceof A.Group?e.rows:e}),labels:this.rows.map(function(e){return e instanceof A.Group?e.title:t[e]})})},t.prototype.getLength=function(){return this.rows.length},t.prototype.getItem=function(e){var t,n=this.rows[e],r=this.source.data;return n instanceof A.Group?n:Object.keys(r).reduce(function(e,t){var i;return o.__assign({},e,((i={})[t]=r[t][n],i))},((t={})[l.DTINDEX_NAME]=n,t))},t.prototype.getItemMetadata=function(e){var t=this.rows[e],n=this.columns.slice(1),o=t instanceof A.Group?this.groupingInfos[t.level].aggregators:[];return t instanceof A.Group?{selectable:!1,focusable:!1,cssClasses:"slick-group",columns:[{formatter:a}].concat(n.map(function(e){var t=e.field,n=e.formatter,r=o.find(function(e){return e.field_===t});if(r){var i=r.key;return{formatter:function(e,o,r,A,l){return n?n(e,o,l.totals[i][t],A,l):""}}}return{}}))}:{}},t.prototype.collapseGroup=function(e){var t=e.split(this.groupingDelimiter).length-1;this.toggledGroupsByLevel[t][e]=!this.groupingInfos[t].collapsed,this.refresh()},t.prototype.expandGroup=function(e){var t=e.split(this.groupingDelimiter).length-1;this.toggledGroupsByLevel[t][e]=this.groupingInfos[t].collapsed,this.refresh()},t.__name__="DataCubeProvider",t}(l.TableDataProvider);n.DataCubeProvider=u;var d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype.render=function(){var e,t,n={enableCellNavigation:!1!==this.model.selectable,enableColumnReorder:!1,forceFitColumns:this.model.fit_columns,multiColumnSort:!1,editable:this.model.editable,autoEdit:!1,rowHeight:this.model.row_height},o=this.model.columns.map(function(e){return e.toColumn()});o[0].formatter=(e=o[0].formatter,t=this.model.grouping.length,function(n,o,r,A,l){var a=i.span({class:"slick-group-toggle",style:{"margin-left":15*(t||0)+"px"}}),s=e?e(n,o,r,A,l):""+r;return""+a.outerHTML+(s&&s.replace(/^<div/,"<span").replace(/div>$/,"span>"))}),delete o[0].editor,this.data=new u(this.model.source,this.model.view,o,this.model.target),this.data.setGrouping(this.model.grouping),this.el.style.width=this.model.width+"px",this.grid=new A.Grid(this.el,this.data,o,n),this.grid.onClick.subscribe(s)},t.__name__="DataCubeView",t}(l.DataTableView);n.DataCubeView=d;var p=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="DataCube",this.prototype.default_view=d,this.define({grouping:[r.Array,[]],target:[r.Instance]})},t.__name__="DataCube",t}(l.DataTable);n.DataCube=p,p.initClass()},481:function(e,t,n){var o=e(426),r=e(496).RowSelectionModel,i=e(495).CheckboxSelectColumn,A=e(494).CellExternalCopyManager,l=e(491),a=e(18),s=e(40),c=e(46),u=e(24),d=e(35),p=e(17),f=e(13),h=e(486),g=e(487),m=e(489);n.DTINDEX_NAME="__bkdt_internal_index__";var v=function(){function e(e,t){if(this.source=e,this.view=t,n.DTINDEX_NAME in this.source.data)throw new Error("special name "+n.DTINDEX_NAME+" cannot be used as a data table column");this.index=this.view.indices}return e.prototype.getLength=function(){return this.index.length},e.prototype.getItem=function(e){for(var t={},o=0,r=d.keys(this.source.data);o<r.length;o++){var i=r[o];t[i]=this.source.data[i][this.index[e]]}return t[n.DTINDEX_NAME]=this.index[e],t},e.prototype.getField=function(e,t){return t==n.DTINDEX_NAME?this.index[e]:this.source.data[t][this.index[e]]},e.prototype.setField=function(e,t,n){var o,r=this.index[e];this.source.patch(((o={})[t]=[[r,n]],o))},e.prototype.getItemMetadata=function(e){return null},e.prototype.getRecords=function(){var e=this;return u.range(0,this.getLength()).map(function(t){return e.getItem(t)})},e.prototype.sort=function(e){var t=e.map(function(e){return[e.sortCol.field,e.sortAsc?1:-1]});0==t.length&&(t=[[n.DTINDEX_NAME,1]]);var o=this.getRecords(),r=this.index.slice();this.index.sort(function(e,n){for(var i=0,A=t;i<A.length;i++){var l=A[i],a=l[0],s=l[1],c=o[r.indexOf(e)][a],u=o[r.indexOf(n)][a],d=c==u?0:c>u?s:-s;if(0!=d)return d}return 0})},e.__name__="TableDataProvider",e}();n.TableDataProvider=v;var w=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t._in_selection_update=!1,t._warned_not_reorderable=!1,t}return o.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()}),this.connect(this.model.source.streaming,function(){return t.updateGrid()}),this.connect(this.model.source.patching,function(){return t.updateGrid()}),this.connect(this.model.source.change,function(){return t.updateGrid()}),this.connect(this.model.source.properties.data.change,function(){return t.updateGrid()}),this.connect(this.model.source.selected.change,function(){return t.updateSelection()}),this.connect(this.model.source.selected.properties.indices.change,function(){return t.updateSelection()})},t.prototype._update_layout=function(){this.layout=new f.LayoutItem,this.layout.set_sizing(this.box_sizing())},t.prototype.update_position=function(){e.prototype.update_position.call(this),this.grid.resizeCanvas()},t.prototype.updateGrid=function(){var e=this;this.model.view.compute_indices(),this.data.constructor(this.model.source,this.model.view);var t=this.grid.getColumns(),n=this.grid.getSortColumns().map(function(n){return{sortCol:{field:t[e.grid.getColumnIndex(n.columnId)].field},sortAsc:n.sortAsc}});this.data.sort(n),this.grid.invalidate(),this.grid.render()},t.prototype.updateSelection=function(){var e=this;if(!this._in_selection_update){var t=this.model.source.selected.indices.map(function(t){return e.data.index.indexOf(t)}).sort();this._in_selection_update=!0,this.grid.setSelectedRows(t),this._in_selection_update=!1;var n=this.grid.getViewport(),o=this.model.get_scroll_index(n,t);null!=o&&this.grid.scrollRowToTop(o)}},t.prototype.newIndexColumn=function(){return{id:s.uniqueId(),name:this.model.index_header,field:n.DTINDEX_NAME,width:this.model.index_width,behavior:"select",cannotTriggerInsert:!0,resizable:!1,selectable:!1,sortable:!0,cssClass:m.bk_cell_index,headerCssClass:m.bk_header_index}},t.prototype.css_classes=function(){return e.prototype.css_classes.call(this).concat(m.bk_data_table)},t.prototype.render=function(){var e,t=this,n=this.model.columns.map(function(e){return e.toColumn()});if("checkbox"==this.model.selectable&&(e=new i({cssClass:m.bk_cell_select}),n.unshift(e.getColumnDefinition())),null!=this.model.index_position){var o=this.model.index_position,a=this.newIndexColumn();-1==o?n.push(a):o<-1?n.splice(o+1,0,a):n.splice(o,0,a)}var s=this.model.reorderable;!s||"undefined"!=typeof $&&null!=$.fn&&null!=$.fn.sortable||(this._warned_not_reorderable||(p.logger.warn("jquery-ui is required to enable DataTable.reorderable"),this._warned_not_reorderable=!0),s=!1);var u={enableCellNavigation:!1!==this.model.selectable,enableColumnReorder:s,forceFitColumns:this.model.fit_columns,multiColumnSort:this.model.sortable,editable:this.model.editable,autoEdit:!1,rowHeight:this.model.row_height};if(this.data=new v(this.model.source,this.model.view),this.grid=new l.Grid(this.el,this.data,n,u),this.grid.onSort.subscribe(function(e,o){n=o.sortCols,t.data.sort(n),t.grid.invalidate(),t.updateSelection(),t.grid.render(),t.model.header_row||t._hide_header(),t.model.update_sort_columns(n)}),!1!==this.model.selectable){this.grid.setSelectionModel(new r({selectActiveRow:null==e})),null!=e&&this.grid.registerPlugin(e);var d={dataItemColumnValueExtractor:function(e,t){var n=e[t.field];return c.isString(n)&&(n=n.replace(/\n/g,"\\n")),n},includeHeaderWhenCopying:!1};this.grid.registerPlugin(new A(d)),this.grid.onSelectedRowsChanged.subscribe(function(e,n){t._in_selection_update||(t.model.source.selected.indices=n.rows.map(function(e){return t.data.index[e]}))}),this.updateSelection(),this.model.header_row||this._hide_header()}},t.prototype._hide_header=function(){for(var e=0,t=Array.from(this.el.querySelectorAll(".slick-header-columns"));e<t.length;e++){t[e].style.height="0px"}this.grid.resizeCanvas()},t.__name__="DataTableView",t}(g.WidgetView);n.DataTableView=w;var C=function(e){function t(t){var n=e.call(this,t)||this;return n._sort_columns=[],n}return o.__extends(t,e),Object.defineProperty(t.prototype,"sort_columns",{get:function(){return this._sort_columns},enumerable:!0,configurable:!0}),t.initClass=function(){this.prototype.default_view=w,this.define({columns:[a.Array,[]],fit_columns:[a.Boolean,!0],sortable:[a.Boolean,!0],reorderable:[a.Boolean,!0],editable:[a.Boolean,!1],selectable:[a.Any,!0],index_position:[a.Int,0],index_header:[a.String,"#"],index_width:[a.Int,40],scroll_to_selection:[a.Boolean,!0],header_row:[a.Boolean,!0],row_height:[a.Int,25]}),this.override({width:600,height:400})},t.prototype.update_sort_columns=function(e){return this._sort_columns=e.map(function(e){return{field:e.sortCol.field,sortAsc:e.sortAsc}}),null},t.prototype.get_scroll_index=function(e,t){return this.scroll_to_selection&&0!=t.length?u.some(t,function(t){return e.top<=t&&t<=e.bottom})?null:Math.max(0,Math.min.apply(Math,t)-1):null},t.__name__="DataTable",t}(h.TableWidget);n.DataTable=C,C.initClass()},482:function(e,t,n){var o=e(426);o.__exportStar(e(478),n),o.__exportStar(e(479),n);var r=e(481);n.DataTable=r.DataTable;var i=e(485);n.TableColumn=i.TableColumn;var A=e(486);n.TableWidget=A.TableWidget;var l=e(484);n.AvgAggregator=l.AvgAggregator,n.MinAggregator=l.MinAggregator,n.MaxAggregator=l.MaxAggregator,n.SumAggregator=l.SumAggregator;var a=e(480);n.GroupingInfo=a.GroupingInfo,n.DataCube=a.DataCube},483:function(e,t,n){var o=e(482);n.Tables=o,e(0).register_models(o)},484:function(e,t,n){var o=e(426),r=e(491).Data.Aggregators,i=r.Avg,A=r.Min,l=r.Max,a=r.Sum,s=e(18),c=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="RowAggregator",this.define({field_:[s.String,""]})},t.__name__="RowAggregator",t}(e(62).Model);n.RowAggregator=c,c.initClass();var u=new i,d=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t.key="avg",t.init=u.init,t.accumulate=u.accumulate,t.storeResult=u.storeResult,t}return o.__extends(t,e),t.initClass=function(){this.prototype.type="AvgAggregator"},t.__name__="AvgAggregator",t}(c);n.AvgAggregator=d,d.initClass();var p=new A,f=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t.key="min",t.init=p.init,t.accumulate=p.accumulate,t.storeResult=p.storeResult,t}return o.__extends(t,e),t.initClass=function(){this.prototype.type="MinAggregator"},t.__name__="MinAggregator",t}(c);n.MinAggregator=f,f.initClass();var h=new l,g=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t.key="max",t.init=h.init,t.accumulate=h.accumulate,t.storeResult=h.storeResult,t}return o.__extends(t,e),t.initClass=function(){this.prototype.type="MaxAggregator"},t.__name__="MaxAggregator",t}(c);n.MaxAggregator=g,g.initClass();var m=new a,v=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t.key="sum",t.init=m.init,t.accumulate=m.accumulate,t.storeResult=m.storeResult,t}return o.__extends(t,e),t.initClass=function(){this.prototype.type="SumAggregator"},t.__name__="SumAggregator",t}(c);n.SumAggregator=v,v.initClass()},485:function(e,t,n){var o=e(426),r=e(479),i=e(478),A=e(18),l=e(40),a=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.define({field:[A.String],title:[A.String],width:[A.Number,300],formatter:[A.Instance,function(){return new r.StringFormatter}],editor:[A.Instance,function(){return new i.StringEditor}],sortable:[A.Boolean,!0],default_sort:[A.Sort,"ascending"]})},t.prototype.toColumn=function(){return{id:l.uniqueId(),field:this.field,name:this.title,width:this.width,formatter:null!=this.formatter?this.formatter.doFormat.bind(this.formatter):void 0,model:this.editor,editor:this.editor.default_view,sortable:this.sortable,defaultSortAsc:"ascending"==this.default_sort}},t.__name__="TableColumn",t}(e(62).Model);n.TableColumn=a,a.initClass()},486:function(e,t,n){var o=e(426),r=e(487),i=e(211),A=e(18),l=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.define({source:[A.Instance],view:[A.Instance,function(){return new i.CDSView}]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),null==this.view.source&&(this.view.source=this.source,this.view.compute_indices())},t.__name__="TableWidget",t}(r.Widget);n.TableWidget=l,l.initClass()},487:function(e,t,n){var o=e(426),r=e(164),i=e(18),A=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._width_policy=function(){return"horizontal"==this.model.orientation?e.prototype._width_policy.call(this):"fixed"},t.prototype._height_policy=function(){return"horizontal"==this.model.orientation?"fixed":e.prototype._height_policy.call(this)},t.prototype.box_sizing=function(){var t=e.prototype.box_sizing.call(this);return"horizontal"==this.model.orientation?null==t.width&&(t.width=this.model.default_size):null==t.height&&(t.height=this.model.default_size),t},t.__name__="WidgetView",t}(r.HTMLBoxView);n.WidgetView=A;var l=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.define({orientation:[i.Orientation,"horizontal"],default_size:[i.Number,300]}),this.override({margin:[5,5,5,5]})},t.__name__="Widget",t}(r.HTMLBox);n.Widget=l,l.initClass()},488:function(e,t,n){e(311),e(5).styles.append('.bk-root {\n  /*\nIMPORTANT:\nIn order to preserve the uniform grid appearance, all cell styles need to have padding, margin and border sizes.\nNo built-in (selected, editable, highlight, flashing, invalid, loading, :focus) or user-specified CSS\nclasses should alter those!\n*/\n  /*\nIMPORTANT:\nIn order to preserve the uniform grid appearance, all cell styles need to have padding, margin and border sizes.\nNo built-in (selected, editable, highlight, flashing, invalid, loading, :focus) or user-specified CSS\nclasses should alter those!\n*/\n  /* Menu button */\n  /* Menu */\n  /* Menu items */\n  /* Disabled */\n}\n.bk-root .slick-header.ui-state-default,\n.bk-root .slick-headerrow.ui-state-default,\n.bk-root .slick-footerrow.ui-state-default,\n.bk-root .slick-top-panel-scroller.ui-state-default {\n  width: 100%;\n  overflow: auto;\n  position: relative;\n  border-left: 0px !important;\n}\n.bk-root .slick-header.ui-state-default {\n  overflow: inherit;\n}\n.bk-root .slick-header::-webkit-scrollbar,\n.bk-root .slick-headerrow::-webkit-scrollbar,\n.bk-root .slick-footerrow::-webkit-scrollbar {\n  display: none;\n}\n.bk-root .slick-header-columns,\n.bk-root .slick-headerrow-columns,\n.bk-root .slick-footerrow-columns {\n  position: relative;\n  white-space: nowrap;\n  cursor: default;\n  overflow: hidden;\n}\n.bk-root .slick-header-column.ui-state-default {\n  position: relative;\n  display: inline-block;\n  box-sizing: content-box !important;\n  /* this here only for Firefox! */\n  overflow: hidden;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  height: 16px;\n  line-height: 16px;\n  margin: 0;\n  padding: 4px;\n  border-right: 1px solid silver;\n  border-left: 0px !important;\n  border-top: 0px !important;\n  border-bottom: 0px !important;\n  float: left;\n}\n.bk-root .slick-headerrow-column.ui-state-default,\n.bk-root .slick-footerrow-column.ui-state-default {\n  padding: 4px;\n}\n.bk-root .slick-header-column-sorted {\n  font-style: italic;\n}\n.bk-root .slick-sort-indicator {\n  display: inline-block;\n  width: 8px;\n  height: 5px;\n  margin-left: 4px;\n  margin-top: 6px;\n  float: left;\n}\n.bk-root .slick-sort-indicator-numbered {\n  display: inline-block;\n  width: 8px;\n  height: 5px;\n  margin-left: 4px;\n  margin-top: 0;\n  line-height: 20px;\n  float: left;\n  font-family: Arial;\n  font-style: normal;\n  font-weight: bold;\n  color: #6190CD;\n}\n.bk-root .slick-sort-indicator-desc {\n  background: url(images/sort-desc.gif);\n}\n.bk-root .slick-sort-indicator-asc {\n  background: url(images/sort-asc.gif);\n}\n.bk-root .slick-resizable-handle {\n  position: absolute;\n  font-size: 0.1px;\n  display: block;\n  cursor: col-resize;\n  width: 9px;\n  right: -5px;\n  top: 0;\n  height: 100%;\n  z-index: 1;\n}\n.bk-root .slick-sortable-placeholder {\n  background: silver;\n}\n.bk-root .grid-canvas {\n  position: relative;\n  outline: 0;\n}\n.bk-root .slick-row.ui-widget-content,\n.bk-root .slick-row.ui-state-active {\n  position: absolute;\n  border: 0px;\n  width: 100%;\n}\n.bk-root .slick-cell,\n.bk-root .slick-headerrow-column,\n.bk-root .slick-footerrow-column {\n  position: absolute;\n  border: 1px solid transparent;\n  border-right: 1px dotted silver;\n  border-bottom-color: silver;\n  overflow: hidden;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  vertical-align: middle;\n  z-index: 1;\n  padding: 1px 2px 2px 1px;\n  margin: 0;\n  white-space: nowrap;\n  cursor: default;\n}\n.bk-root .slick-cell,\n.bk-root .slick-headerrow-column {\n  border-bottom-color: silver;\n}\n.bk-root .slick-footerrow-column {\n  border-top-color: silver;\n}\n.bk-root .slick-group-toggle {\n  display: inline-block;\n}\n.bk-root .slick-cell.highlighted {\n  background: lightskyblue;\n  background: rgba(0, 0, 255, 0.2);\n  -webkit-transition: all 0.5s;\n  -moz-transition: all 0.5s;\n  -o-transition: all 0.5s;\n  transition: all 0.5s;\n}\n.bk-root .slick-cell.flashing {\n  border: 1px solid red !important;\n}\n.bk-root .slick-cell.editable {\n  z-index: 11;\n  overflow: visible;\n  background: white;\n  border-color: black;\n  border-style: solid;\n}\n.bk-root .slick-cell:focus {\n  outline: none;\n}\n.bk-root .slick-reorder-proxy {\n  display: inline-block;\n  background: blue;\n  opacity: 0.15;\n  cursor: move;\n}\n.bk-root .slick-reorder-guide {\n  display: inline-block;\n  height: 2px;\n  background: blue;\n  opacity: 0.7;\n}\n.bk-root .slick-selection {\n  z-index: 10;\n  position: absolute;\n  border: 2px dashed black;\n}\n.bk-root .slick-header-columns {\n  background: url(\'images/header-columns-bg.gif\') repeat-x center bottom;\n  border-bottom: 1px solid silver;\n}\n.bk-root .slick-header-column {\n  background: url(\'images/header-columns-bg.gif\') repeat-x center bottom;\n  border-right: 1px solid silver;\n}\n.bk-root .slick-header-column:hover,\n.bk-root .slick-header-column-active {\n  background: white url(\'images/header-columns-over-bg.gif\') repeat-x center bottom;\n}\n.bk-root .slick-headerrow {\n  background: #fafafa;\n}\n.bk-root .slick-headerrow-column {\n  background: #fafafa;\n  border-bottom: 0;\n  height: 100%;\n}\n.bk-root .slick-row.ui-state-active {\n  background: #F5F7D7;\n}\n.bk-root .slick-row {\n  position: absolute;\n  background: white;\n  border: 0px;\n  line-height: 20px;\n}\n.bk-root .slick-row.selected {\n  z-index: 10;\n  background: #DFE8F6;\n}\n.bk-root .slick-cell {\n  padding-left: 4px;\n  padding-right: 4px;\n}\n.bk-root .slick-group {\n  border-bottom: 2px solid silver;\n}\n.bk-root .slick-group-toggle {\n  width: 9px;\n  height: 9px;\n  margin-right: 5px;\n}\n.bk-root .slick-group-toggle.expanded {\n  background: url(images/collapse.gif) no-repeat center center;\n}\n.bk-root .slick-group-toggle.collapsed {\n  background: url(images/expand.gif) no-repeat center center;\n}\n.bk-root .slick-group-totals {\n  color: gray;\n  background: white;\n}\n.bk-root .slick-group-select-checkbox {\n  width: 13px;\n  height: 13px;\n  margin: 3px 10px 0 0;\n  display: inline-block;\n}\n.bk-root .slick-group-select-checkbox.checked {\n  background: url(images/GrpCheckboxY.png) no-repeat center center;\n}\n.bk-root .slick-group-select-checkbox.unchecked {\n  background: url(images/GrpCheckboxN.png) no-repeat center center;\n}\n.bk-root .slick-cell.selected {\n  background-color: beige;\n}\n.bk-root .slick-cell.active {\n  border-color: gray;\n  border-style: solid;\n}\n.bk-root .slick-sortable-placeholder {\n  background: silver !important;\n}\n.bk-root .slick-row.odd {\n  background: #fafafa;\n}\n.bk-root .slick-row.ui-state-active {\n  background: #F5F7D7;\n}\n.bk-root .slick-row.loading {\n  opacity: 0.5;\n}\n.bk-root .slick-cell.invalid {\n  border-color: red;\n  -moz-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  -moz-animation-name: slickgrid-invalid-hilite;\n  -webkit-animation-name: slickgrid-invalid-hilite;\n}\n@-moz-keyframes slickgrid-invalid-hilite {\n  from {\n    box-shadow: 0 0 6px red;\n  }\n  to {\n    box-shadow: none;\n  }\n}\n@-webkit-keyframes slickgrid-invalid-hilite {\n  from {\n    box-shadow: 0 0 6px red;\n  }\n  to {\n    box-shadow: none;\n  }\n}\n.bk-root .slick-column-name,\n.bk-root .slick-sort-indicator {\n  /**\n   * This makes all "float:right" elements after it that spill over to the next line\n   * display way below the lower boundary of the column thus hiding them.\n   */\n  display: inline-block;\n  float: left;\n  margin-bottom: 100px;\n}\n.bk-root .slick-header-button {\n  display: inline-block;\n  float: right;\n  vertical-align: top;\n  margin: 1px;\n  /**\n  * This makes all "float:right" elements after it that spill over to the next line\n  * display way below the lower boundary of the column thus hiding them.\n  */\n  margin-bottom: 100px;\n  height: 15px;\n  width: 15px;\n  background-repeat: no-repeat;\n  background-position: center center;\n  cursor: pointer;\n}\n.bk-root .slick-header-button-hidden {\n  width: 0;\n  -webkit-transition: 0.2s width;\n  -ms-transition: 0.2s width;\n  transition: 0.2s width;\n}\n.bk-root .slick-header-column:hover > .slick-header-button {\n  width: 15px;\n}\n.bk-root .slick-header-menubutton {\n  position: absolute;\n  right: 0;\n  top: 0;\n  bottom: 0;\n  width: 14px;\n  background-repeat: no-repeat;\n  background-position: left center;\n  background-image: url(../images/down.gif);\n  cursor: pointer;\n  display: none;\n  border-left: thin ridge silver;\n}\n.bk-root .slick-header-column:hover > .slick-header-menubutton,\n.bk-root .slick-header-column-active .slick-header-menubutton {\n  display: inline-block;\n}\n.bk-root .slick-header-menu {\n  position: absolute;\n  display: inline-block;\n  margin: 0;\n  padding: 2px;\n  cursor: default;\n}\n.bk-root .slick-header-menuitem {\n  list-style: none;\n  margin: 0;\n  padding: 0;\n  cursor: pointer;\n}\n.bk-root .slick-header-menuicon {\n  display: inline-block;\n  width: 16px;\n  height: 16px;\n  vertical-align: middle;\n  margin-right: 4px;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .slick-header-menucontent {\n  display: inline-block;\n  vertical-align: middle;\n}\n.bk-root .slick-header-menuitem-disabled {\n  color: silver;\n}\n.bk-root .slick-columnpicker {\n  border: 1px solid #718BB7;\n  background: #f0f0f0;\n  padding: 6px;\n  -moz-box-shadow: 2px 2px 2px silver;\n  -webkit-box-shadow: 2px 2px 2px silver;\n  box-shadow: 2px 2px 2px silver;\n  min-width: 150px;\n  cursor: default;\n  position: absolute;\n  z-index: 20;\n  overflow: auto;\n  resize: both;\n}\n.bk-root .slick-columnpicker > .close {\n  float: right;\n}\n.bk-root .slick-columnpicker .title {\n  font-size: 16px;\n  width: 60%;\n  border-bottom: solid 1px #d6d6d6;\n  margin-bottom: 10px;\n}\n.bk-root .slick-columnpicker li {\n  list-style: none;\n  margin: 0;\n  padding: 0;\n  background: none;\n}\n.bk-root .slick-columnpicker input {\n  margin: 4px;\n}\n.bk-root .slick-columnpicker li a {\n  display: block;\n  padding: 4px;\n  font-weight: bold;\n}\n.bk-root .slick-columnpicker li a:hover {\n  background: white;\n}\n.bk-root .slick-pager {\n  width: 100%;\n  height: 26px;\n  border: 1px solid gray;\n  border-top: 0;\n  background: url(\'../images/header-columns-bg.gif\') repeat-x center bottom;\n  vertical-align: middle;\n}\n.bk-root .slick-pager .slick-pager-status {\n  display: inline-block;\n  padding: 6px;\n}\n.bk-root .slick-pager .ui-icon-container {\n  display: inline-block;\n  margin: 2px;\n  border-color: gray;\n}\n.bk-root .slick-pager .slick-pager-nav {\n  display: inline-block;\n  float: left;\n  padding: 2px;\n}\n.bk-root .slick-pager .slick-pager-settings {\n  display: block;\n  float: right;\n  padding: 2px;\n}\n.bk-root .slick-pager .slick-pager-settings * {\n  vertical-align: middle;\n}\n.bk-root .slick-pager .slick-pager-settings a {\n  padding: 2px;\n  text-decoration: underline;\n  cursor: pointer;\n}\n.bk-root .slick-header-columns {\n  background-image: url("data:image/gif;base64,R0lGODlhAgAYAIcAANDQ0Ovs7uzt7+3u8O7v8e/w8vDx8/Hy9Pn5+QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAP8ALAAAAAACABgAAAghABEIHEiwYMEDCA8YWMiwgMMCBAgMmDhAgIAAGAMAABAQADs=");\n}\n.bk-root .slick-header-column {\n  background-image: url("data:image/gif;base64,R0lGODlhAgAYAIcAANDQ0Ovs7uzt7+3u8O7v8e/w8vDx8/Hy9Pn5+QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAP8ALAAAAAACABgAAAghABEIHEiwYMEDCA8YWMiwgMMCBAgMmDhAgIAAGAMAABAQADs=");\n}\n.bk-root .slick-header-column:hover,\n.bk-root .slick-header-column-active {\n  background-image: url("data:image/gif;base64,R0lGODlhAgAWAIcAAKrM9tno++vz/QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAP8ALAAAAAACABYAAAgUAAUIHEiwoIAACBMqXMhwIQAAAQEAOw==");\n}\n.bk-root .slick-group-toggle.expanded {\n  background-image: url("data:image/gif;base64,R0lGODlhCQAJAPcAAAFGeoCAgNXz/+v5/+v6/+z5/+36//L7//X8//j9/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAACQAJAAAIMwADCBxIUIDBgwIEChgwwECBAgQUFjBAkaJCABgxGlB4AGHCAAIQiBypEEECkScJqgwQEAA7");\n}\n.bk-root .slick-group-toggle.collapsed {\n  background-image: url("data:image/gif;base64,R0lGODlhCQAJAPcAAAFGeoCAgNXz/+v5/+v6/+z5/+36//L7//X8//j9/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAACQAJAAAIOAADCBxIUIDBgwIEChgwAECBAgQUFjAAQIABAwoBaNSIMYCAAwIqGlSIAEHFkiQTIBCgkqDLAAEBADs=");\n}\n.bk-root .slick-group-select-checkbox.checked {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAOCAIAAACQKrqGAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwQAADsEBuJFr7QAAABl0RVh0U29mdHdhcmUAcGFpbnQubmV0IDQuMC4xNkRpr/UAAAEcSURBVChTjdI9S8NQFAbg/raQXVwCRRFE7GK7OXTwD+ikk066VF3a0ja0hQTyQdJrwNq0zrYSQRLEXMSWSlCIb8glqRcFD+9yz3nugXwU4n9XQqMoGjj36uBJsTwuaNo3EwBG4Yy7pe7Gv8YcvhJCGFVsjxsjxujj6OTSGlHv+U2WZUZbPWKOv1ZjT5a7pbIoiptbO5b73mwrjHa1B27l8VlTEIS1damlTnEE+EEN9/P8WrfH81qdAIGeXvTTmzltdCy46sEhxpKUINReZR9NnqZbr9puugxV3NjWh/k74WmmEdWhmUNy2jNmWRc6fZTVADCqao52u+DGWTACYNT3fRxwtatPufTNR4yCIGAUn5hS+vJHhWGY/ANx/A3tvdv+1tZmuwAAAABJRU5ErkJggg==");\n}\n.bk-root .slick-group-select-checkbox.unchecked {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAOCAIAAACQKrqGAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwQAADsEBuJFr7QAAABl0RVh0U29mdHdhcmUAcGFpbnQubmV0IDQuMC4xNkRpr/UAAACXSURBVChT1dIxC4MwEAXg/v8/VOhQVDBNakV0KA6pxS4JhWRSIYPEJxwdDi1de7wleR+3JIf486w0hKCKRpSvvOhZcCmvNQBRuKqdah03U7UjNNH81rOaBYDo8SQaPX8JANFEaLaGBeAPaaY61rGksiN6TmR5H1j9CSoAosYYHLA7vTxYMvVEZa0liif23r93xjm3/oEYF8PiDn/I2FHCAAAAAElFTkSuQmCC");\n}\n.bk-root .slick-sort-indicator-desc {\n  background-image: url("data:image/gif;base64,R0lGODlhDQAFAIcAAGGQzUD/QOPu+wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAAAEALAAAAAANAAUAAAgeAAUAGEgQgIAACBEKLHgwYcKFBh1KFNhQosOKEgMCADs=");\n}\n.bk-root .slick-sort-indicator-asc {\n  background-image: url("data:image/gif;base64,R0lGODlhDQAFAIcAAGGQzUD/QOPu+wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAAAEALAAAAAANAAUAAAgbAAMIDABgoEGDABIeRJhQ4cKGEA8KmEiRosGAADs=");\n}\n.bk-root .slick-header-menubutton {\n  background-image: url("data:image/gif;base64,R0lGODlhDgAOAIABADtKYwAAACH5BAEAAAEALAAAAAAOAA4AAAISjI+py+0PHZgUsGobhTn6DxoFADs=");\n}\n.bk-root .slick-pager {\n  background-image: url("data:image/gif;base64,R0lGODlhAgAYAIcAANDQ0Ovs7uzt7+3u8O7v8e/w8vDx8/Hy9Pn5+QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAP8ALAAAAAACABgAAAghABEIHEiwYMEDCA8YWMiwgMMCBAgMmDhAgIAAGAMAABAQADs=");\n}\n')},489:function(e,t,n){e(311),e(488),e(5).styles.append('.bk-root .bk-data-table {\n  box-sizing: content-box;\n  font-size: 11px;\n}\n.bk-root .bk-data-table input[type="checkbox"] {\n  margin-left: 4px;\n  margin-right: 4px;\n}\n.bk-root .bk-cell-special-defaults {\n  border-right-color: silver;\n  border-right-style: solid;\n  background: #f5f5f5;\n}\n.bk-root .bk-cell-select {\n  border-right-color: silver;\n  border-right-style: solid;\n  background: #f5f5f5;\n}\n.bk-root .bk-cell-index {\n  border-right-color: silver;\n  border-right-style: solid;\n  background: #f5f5f5;\n  text-align: right;\n  color: gray;\n}\n.bk-root .bk-header-index .slick-column-name {\n  float: right;\n}\n.bk-root .slick-row.selected .bk-cell-index {\n  background-color: transparent;\n}\n.bk-root .slick-cell {\n  padding-left: 4px;\n  padding-right: 4px;\n}\n.bk-root .slick-cell.active {\n  border-style: dashed;\n}\n.bk-root .slick-cell.editable {\n  padding-left: 0;\n  padding-right: 0;\n}\n.bk-root .bk-cell-editor input,\n.bk-root .bk-cell-editor select {\n  width: 100%;\n  height: 100%;\n  border: 0;\n  margin: 0;\n  padding: 0;\n  outline: 0;\n  background: transparent;\n  vertical-align: baseline;\n}\n.bk-root .bk-cell-editor input {\n  padding-left: 4px;\n  padding-right: 4px;\n}\n.bk-root .bk-cell-editor-completion {\n  font-size: 11px;\n}\n'),n.bk_data_table="bk-data-table",n.bk_cell_index="bk-cell-index",n.bk_header_index="bk-header-index",n.bk_cell_editor="bk-cell-editor",n.bk_cell_select="bk-cell-select"},490:function(e,t,n){
/*!
     * jQuery JavaScript Library v3.4.1
     * https://jquery.com/
     *
     * Includes Sizzle.js
     * https://sizzlejs.com/
     *
     * Copyright JS Foundation and other contributors
     * Released under the MIT license
     * https://jquery.org/license
     *
     * Date: 2019-05-01T21:04Z
     */
!function(e,n){"use strict";"object"==typeof t&&"object"==typeof t.exports?t.exports=e.document?n(e,!0):function(e){if(!e.document)throw new Error("jQuery requires a window with a document");return n(e)}:n(e)}("undefined"!=typeof window?window:this,function(e,t){"use strict";var n=[],o=e.document,r=Object.getPrototypeOf,i=n.slice,A=n.concat,l=n.push,a=n.indexOf,s={},c=s.toString,u=s.hasOwnProperty,d=u.toString,p=d.call(Object),f={},h=function(e){return"function"==typeof e&&"number"!=typeof e.nodeType},g=function(e){return null!=e&&e===e.window},m={type:!0,src:!0,nonce:!0,noModule:!0};function v(e,t,n){var r,i,A=(n=n||o).createElement("script");if(A.text=e,t)for(r in m)(i=t[r]||t.getAttribute&&t.getAttribute(r))&&A.setAttribute(r,i);n.head.appendChild(A).parentNode.removeChild(A)}function w(e){return null==e?e+"":"object"==typeof e||"function"==typeof e?s[c.call(e)]||"object":typeof e}var C=function(e,t){return new C.fn.init(e,t)},y=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;function b(e){var t=!!e&&"length"in e&&e.length,n=w(e);return!h(e)&&!g(e)&&("array"===n||0===t||"number"==typeof t&&t>0&&t-1 in e)}C.fn=C.prototype={jquery:"3.4.1",constructor:C,length:0,toArray:function(){return i.call(this)},get:function(e){return null==e?i.call(this):e<0?this[e+this.length]:this[e]},pushStack:function(e){var t=C.merge(this.constructor(),e);return t.prevObject=this,t},each:function(e){return C.each(this,e)},map:function(e){return this.pushStack(C.map(this,function(t,n){return e.call(t,n,t)}))},slice:function(){return this.pushStack(i.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(e){var t=this.length,n=+e+(e<0?t:0);return this.pushStack(n>=0&&n<t?[this[n]]:[])},end:function(){return this.prevObject||this.constructor()},push:l,sort:n.sort,splice:n.splice},C.extend=C.fn.extend=function(){var e,t,n,o,r,i,A=arguments[0]||{},l=1,a=arguments.length,s=!1;for("boolean"==typeof A&&(s=A,A=arguments[l]||{},l++),"object"==typeof A||h(A)||(A={}),l===a&&(A=this,l--);l<a;l++)if(null!=(e=arguments[l]))for(t in e)o=e[t],"__proto__"!==t&&A!==o&&(s&&o&&(C.isPlainObject(o)||(r=Array.isArray(o)))?(n=A[t],i=r&&!Array.isArray(n)?[]:r||C.isPlainObject(n)?n:{},r=!1,A[t]=C.extend(s,i,o)):void 0!==o&&(A[t]=o));return A},C.extend({expando:"jQuery"+("3.4.1"+Math.random()).replace(/\D/g,""),isReady:!0,error:function(e){throw new Error(e)},noop:function(){},isPlainObject:function(e){var t,n;return!(!e||"[object Object]"!==c.call(e))&&(!(t=r(e))||"function"==typeof(n=u.call(t,"constructor")&&t.constructor)&&d.call(n)===p)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},globalEval:function(e,t){v(e,{nonce:t&&t.nonce})},each:function(e,t){var n,o=0;if(b(e))for(n=e.length;o<n&&!1!==t.call(e[o],o,e[o]);o++);else for(o in e)if(!1===t.call(e[o],o,e[o]))break;return e},trim:function(e){return null==e?"":(e+"").replace(y,"")},makeArray:function(e,t){var n=t||[];return null!=e&&(b(Object(e))?C.merge(n,"string"==typeof e?[e]:e):l.call(n,e)),n},inArray:function(e,t,n){return null==t?-1:a.call(t,e,n)},merge:function(e,t){for(var n=+t.length,o=0,r=e.length;o<n;o++)e[r++]=t[o];return e.length=r,e},grep:function(e,t,n){for(var o=[],r=0,i=e.length,A=!n;r<i;r++)!t(e[r],r)!==A&&o.push(e[r]);return o},map:function(e,t,n){var o,r,i=0,l=[];if(b(e))for(o=e.length;i<o;i++)null!=(r=t(e[i],i,n))&&l.push(r);else for(i in e)null!=(r=t(e[i],i,n))&&l.push(r);return A.apply([],l)},guid:1,support:f}),"function"==typeof Symbol&&(C.fn[Symbol.iterator]=n[Symbol.iterator]),C.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(e,t){s["[object "+t+"]"]=t.toLowerCase()});var x=
/*!
         * Sizzle CSS Selector Engine v2.3.4
         * https://sizzlejs.com/
         *
         * Copyright JS Foundation and other contributors
         * Released under the MIT license
         * https://js.foundation/
         *
         * Date: 2019-04-08
         */
function(e){var t,n,o,r,i,A,l,a,s,c,u,d,p,f,h,g,m,v,w,C="sizzle"+1*new Date,y=e.document,b=0,x=0,k=ae(),R=ae(),S=ae(),E=ae(),_=function(e,t){return e===t&&(u=!0),0},T={}.hasOwnProperty,D=[],P=D.pop,I=D.push,N=D.push,$=D.slice,H=function(e,t){for(var n=0,o=e.length;n<o;n++)if(e[n]===t)return n;return-1},M="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",L="[\\x20\\t\\r\\n\\f]",F="(?:\\\\.|[\\w-]|[^\0-\\xa0])+",V="\\["+L+"*("+F+")(?:"+L+"*([*^$|!~]?=)"+L+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+F+"))|)"+L+"*\\]",W=":("+F+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+V+")*)|.*)\\)|)",B=new RegExp(L+"+","g"),j=new RegExp("^"+L+"+|((?:^|[^\\\\])(?:\\\\.)*)"+L+"+$","g"),O=new RegExp("^"+L+"*,"+L+"*"),z=new RegExp("^"+L+"*([>+~]|"+L+")"+L+"*"),q=new RegExp(L+"|>"),G=new RegExp(W),K=new RegExp("^"+F+"$"),U={ID:new RegExp("^#("+F+")"),CLASS:new RegExp("^\\.("+F+")"),TAG:new RegExp("^("+F+"|[*])"),ATTR:new RegExp("^"+V),PSEUDO:new RegExp("^"+W),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+L+"*(even|odd|(([+-]|)(\\d*)n|)"+L+"*(?:([+-]|)"+L+"*(\\d+)|))"+L+"*\\)|)","i"),bool:new RegExp("^(?:"+M+")$","i"),needsContext:new RegExp("^"+L+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+L+"*((?:-\\d)?\\d*)"+L+"*\\)|)(?=[^-]|$)","i")},X=/HTML$/i,Q=/^(?:input|select|textarea|button)$/i,Y=/^h\d$/i,J=/^[^{]+\{\s*\[native \w/,Z=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,ee=/[+~]/,te=new RegExp("\\\\([\\da-f]{1,6}"+L+"?|("+L+")|.)","ig"),ne=function(e,t,n){var o="0x"+t-65536;return o!=o||n?t:o<0?String.fromCharCode(o+65536):String.fromCharCode(o>>10|55296,1023&o|56320)},oe=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,re=function(e,t){return t?"\0"===e?"�":e.slice(0,-1)+"\\"+e.charCodeAt(e.length-1).toString(16)+" ":"\\"+e},ie=function(){d()},Ae=Ce(function(e){return!0===e.disabled&&"fieldset"===e.nodeName.toLowerCase()},{dir:"parentNode",next:"legend"});try{N.apply(D=$.call(y.childNodes),y.childNodes),D[y.childNodes.length].nodeType}catch(e){N={apply:D.length?function(e,t){I.apply(e,$.call(t))}:function(e,t){for(var n=e.length,o=0;e[n++]=t[o++];);e.length=n-1}}}function le(e,t,o,r){var i,l,s,c,u,f,m,v=t&&t.ownerDocument,b=t?t.nodeType:9;if(o=o||[],"string"!=typeof e||!e||1!==b&&9!==b&&11!==b)return o;if(!r&&((t?t.ownerDocument||t:y)!==p&&d(t),t=t||p,h)){if(11!==b&&(u=Z.exec(e)))if(i=u[1]){if(9===b){if(!(s=t.getElementById(i)))return o;if(s.id===i)return o.push(s),o}else if(v&&(s=v.getElementById(i))&&w(t,s)&&s.id===i)return o.push(s),o}else{if(u[2])return N.apply(o,t.getElementsByTagName(e)),o;if((i=u[3])&&n.getElementsByClassName&&t.getElementsByClassName)return N.apply(o,t.getElementsByClassName(i)),o}if(n.qsa&&!E[e+" "]&&(!g||!g.test(e))&&(1!==b||"object"!==t.nodeName.toLowerCase())){if(m=e,v=t,1===b&&q.test(e)){for((c=t.getAttribute("id"))?c=c.replace(oe,re):t.setAttribute("id",c=C),l=(f=A(e)).length;l--;)f[l]="#"+c+" "+we(f[l]);m=f.join(","),v=ee.test(e)&&me(t.parentNode)||t}try{return N.apply(o,v.querySelectorAll(m)),o}catch(t){E(e,!0)}finally{c===C&&t.removeAttribute("id")}}}return a(e.replace(j,"$1"),t,o,r)}function ae(){var e=[];return function t(n,r){return e.push(n+" ")>o.cacheLength&&delete t[e.shift()],t[n+" "]=r}}function se(e){return e[C]=!0,e}function ce(e){var t=p.createElement("fieldset");try{return!!e(t)}catch(e){return!1}finally{t.parentNode&&t.parentNode.removeChild(t),t=null}}function ue(e,t){for(var n=e.split("|"),r=n.length;r--;)o.attrHandle[n[r]]=t}function de(e,t){var n=t&&e,o=n&&1===e.nodeType&&1===t.nodeType&&e.sourceIndex-t.sourceIndex;if(o)return o;if(n)for(;n=n.nextSibling;)if(n===t)return-1;return e?1:-1}function pe(e){return function(t){return"input"===t.nodeName.toLowerCase()&&t.type===e}}function fe(e){return function(t){var n=t.nodeName.toLowerCase();return("input"===n||"button"===n)&&t.type===e}}function he(e){return function(t){return"form"in t?t.parentNode&&!1===t.disabled?"label"in t?"label"in t.parentNode?t.parentNode.disabled===e:t.disabled===e:t.isDisabled===e||t.isDisabled!==!e&&Ae(t)===e:t.disabled===e:"label"in t&&t.disabled===e}}function ge(e){return se(function(t){return t=+t,se(function(n,o){for(var r,i=e([],n.length,t),A=i.length;A--;)n[r=i[A]]&&(n[r]=!(o[r]=n[r]))})})}function me(e){return e&&void 0!==e.getElementsByTagName&&e}for(t in n=le.support={},i=le.isXML=function(e){var t=e.namespaceURI,n=(e.ownerDocument||e).documentElement;return!X.test(t||n&&n.nodeName||"HTML")},d=le.setDocument=function(e){var t,r,A=e?e.ownerDocument||e:y;return A!==p&&9===A.nodeType&&A.documentElement?(f=(p=A).documentElement,h=!i(p),y!==p&&(r=p.defaultView)&&r.top!==r&&(r.addEventListener?r.addEventListener("unload",ie,!1):r.attachEvent&&r.attachEvent("onunload",ie)),n.attributes=ce(function(e){return e.className="i",!e.getAttribute("className")}),n.getElementsByTagName=ce(function(e){return e.appendChild(p.createComment("")),!e.getElementsByTagName("*").length}),n.getElementsByClassName=J.test(p.getElementsByClassName),n.getById=ce(function(e){return f.appendChild(e).id=C,!p.getElementsByName||!p.getElementsByName(C).length}),n.getById?(o.filter.ID=function(e){var t=e.replace(te,ne);return function(e){return e.getAttribute("id")===t}},o.find.ID=function(e,t){if(void 0!==t.getElementById&&h){var n=t.getElementById(e);return n?[n]:[]}}):(o.filter.ID=function(e){var t=e.replace(te,ne);return function(e){var n=void 0!==e.getAttributeNode&&e.getAttributeNode("id");return n&&n.value===t}},o.find.ID=function(e,t){if(void 0!==t.getElementById&&h){var n,o,r,i=t.getElementById(e);if(i){if((n=i.getAttributeNode("id"))&&n.value===e)return[i];for(r=t.getElementsByName(e),o=0;i=r[o++];)if((n=i.getAttributeNode("id"))&&n.value===e)return[i]}return[]}}),o.find.TAG=n.getElementsByTagName?function(e,t){return void 0!==t.getElementsByTagName?t.getElementsByTagName(e):n.qsa?t.querySelectorAll(e):void 0}:function(e,t){var n,o=[],r=0,i=t.getElementsByTagName(e);if("*"===e){for(;n=i[r++];)1===n.nodeType&&o.push(n);return o}return i},o.find.CLASS=n.getElementsByClassName&&function(e,t){if(void 0!==t.getElementsByClassName&&h)return t.getElementsByClassName(e)},m=[],g=[],(n.qsa=J.test(p.querySelectorAll))&&(ce(function(e){f.appendChild(e).innerHTML="<a id='"+C+"'></a><select id='"+C+"-\r\\' msallowcapture=''><option selected=''></option></select>",e.querySelectorAll("[msallowcapture^='']").length&&g.push("[*^$]="+L+"*(?:''|\"\")"),e.querySelectorAll("[selected]").length||g.push("\\["+L+"*(?:value|"+M+")"),e.querySelectorAll("[id~="+C+"-]").length||g.push("~="),e.querySelectorAll(":checked").length||g.push(":checked"),e.querySelectorAll("a#"+C+"+*").length||g.push(".#.+[+~]")}),ce(function(e){e.innerHTML="<a href='' disabled='disabled'></a><select disabled='disabled'><option/></select>";var t=p.createElement("input");t.setAttribute("type","hidden"),e.appendChild(t).setAttribute("name","D"),e.querySelectorAll("[name=d]").length&&g.push("name"+L+"*[*^$|!~]?="),2!==e.querySelectorAll(":enabled").length&&g.push(":enabled",":disabled"),f.appendChild(e).disabled=!0,2!==e.querySelectorAll(":disabled").length&&g.push(":enabled",":disabled"),e.querySelectorAll("*,:x"),g.push(",.*:")})),(n.matchesSelector=J.test(v=f.matches||f.webkitMatchesSelector||f.mozMatchesSelector||f.oMatchesSelector||f.msMatchesSelector))&&ce(function(e){n.disconnectedMatch=v.call(e,"*"),v.call(e,"[s!='']:x"),m.push("!=",W)}),g=g.length&&new RegExp(g.join("|")),m=m.length&&new RegExp(m.join("|")),t=J.test(f.compareDocumentPosition),w=t||J.test(f.contains)?function(e,t){var n=9===e.nodeType?e.documentElement:e,o=t&&t.parentNode;return e===o||!(!o||1!==o.nodeType||!(n.contains?n.contains(o):e.compareDocumentPosition&&16&e.compareDocumentPosition(o)))}:function(e,t){if(t)for(;t=t.parentNode;)if(t===e)return!0;return!1},_=t?function(e,t){if(e===t)return u=!0,0;var o=!e.compareDocumentPosition-!t.compareDocumentPosition;return o||(1&(o=(e.ownerDocument||e)===(t.ownerDocument||t)?e.compareDocumentPosition(t):1)||!n.sortDetached&&t.compareDocumentPosition(e)===o?e===p||e.ownerDocument===y&&w(y,e)?-1:t===p||t.ownerDocument===y&&w(y,t)?1:c?H(c,e)-H(c,t):0:4&o?-1:1)}:function(e,t){if(e===t)return u=!0,0;var n,o=0,r=e.parentNode,i=t.parentNode,A=[e],l=[t];if(!r||!i)return e===p?-1:t===p?1:r?-1:i?1:c?H(c,e)-H(c,t):0;if(r===i)return de(e,t);for(n=e;n=n.parentNode;)A.unshift(n);for(n=t;n=n.parentNode;)l.unshift(n);for(;A[o]===l[o];)o++;return o?de(A[o],l[o]):A[o]===y?-1:l[o]===y?1:0},p):p},le.matches=function(e,t){return le(e,null,null,t)},le.matchesSelector=function(e,t){if((e.ownerDocument||e)!==p&&d(e),n.matchesSelector&&h&&!E[t+" "]&&(!m||!m.test(t))&&(!g||!g.test(t)))try{var o=v.call(e,t);if(o||n.disconnectedMatch||e.document&&11!==e.document.nodeType)return o}catch(e){E(t,!0)}return le(t,p,null,[e]).length>0},le.contains=function(e,t){return(e.ownerDocument||e)!==p&&d(e),w(e,t)},le.attr=function(e,t){(e.ownerDocument||e)!==p&&d(e);var r=o.attrHandle[t.toLowerCase()],i=r&&T.call(o.attrHandle,t.toLowerCase())?r(e,t,!h):void 0;return void 0!==i?i:n.attributes||!h?e.getAttribute(t):(i=e.getAttributeNode(t))&&i.specified?i.value:null},le.escape=function(e){return(e+"").replace(oe,re)},le.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e)},le.uniqueSort=function(e){var t,o=[],r=0,i=0;if(u=!n.detectDuplicates,c=!n.sortStable&&e.slice(0),e.sort(_),u){for(;t=e[i++];)t===e[i]&&(r=o.push(i));for(;r--;)e.splice(o[r],1)}return c=null,e},r=le.getText=function(e){var t,n="",o=0,i=e.nodeType;if(i){if(1===i||9===i||11===i){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=r(e)}else if(3===i||4===i)return e.nodeValue}else for(;t=e[o++];)n+=r(t);return n},(o=le.selectors={cacheLength:50,createPseudo:se,match:U,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(te,ne),e[3]=(e[3]||e[4]||e[5]||"").replace(te,ne),"~="===e[2]&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),"nth"===e[1].slice(0,3)?(e[3]||le.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*("even"===e[3]||"odd"===e[3])),e[5]=+(e[7]+e[8]||"odd"===e[3])):e[3]&&le.error(e[0]),e},PSEUDO:function(e){var t,n=!e[6]&&e[2];return U.CHILD.test(e[0])?null:(e[3]?e[2]=e[4]||e[5]||"":n&&G.test(n)&&(t=A(n,!0))&&(t=n.indexOf(")",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){var t=e.replace(te,ne).toLowerCase();return"*"===e?function(){return!0}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=k[e+" "];return t||(t=new RegExp("(^|"+L+")"+e+"("+L+"|$)"))&&k(e,function(e){return t.test("string"==typeof e.className&&e.className||void 0!==e.getAttribute&&e.getAttribute("class")||"")})},ATTR:function(e,t,n){return function(o){var r=le.attr(o,e);return null==r?"!="===t:!t||(r+="","="===t?r===n:"!="===t?r!==n:"^="===t?n&&0===r.indexOf(n):"*="===t?n&&r.indexOf(n)>-1:"$="===t?n&&r.slice(-n.length)===n:"~="===t?(" "+r.replace(B," ")+" ").indexOf(n)>-1:"|="===t&&(r===n||r.slice(0,n.length+1)===n+"-"))}},CHILD:function(e,t,n,o,r){var i="nth"!==e.slice(0,3),A="last"!==e.slice(-4),l="of-type"===t;return 1===o&&0===r?function(e){return!!e.parentNode}:function(t,n,a){var s,c,u,d,p,f,h=i!==A?"nextSibling":"previousSibling",g=t.parentNode,m=l&&t.nodeName.toLowerCase(),v=!a&&!l,w=!1;if(g){if(i){for(;h;){for(d=t;d=d[h];)if(l?d.nodeName.toLowerCase()===m:1===d.nodeType)return!1;f=h="only"===e&&!f&&"nextSibling"}return!0}if(f=[A?g.firstChild:g.lastChild],A&&v){for(w=(p=(s=(c=(u=(d=g)[C]||(d[C]={}))[d.uniqueID]||(u[d.uniqueID]={}))[e]||[])[0]===b&&s[1])&&s[2],d=p&&g.childNodes[p];d=++p&&d&&d[h]||(w=p=0)||f.pop();)if(1===d.nodeType&&++w&&d===t){c[e]=[b,p,w];break}}else if(v&&(w=p=(s=(c=(u=(d=t)[C]||(d[C]={}))[d.uniqueID]||(u[d.uniqueID]={}))[e]||[])[0]===b&&s[1]),!1===w)for(;(d=++p&&d&&d[h]||(w=p=0)||f.pop())&&((l?d.nodeName.toLowerCase()!==m:1!==d.nodeType)||!++w||(v&&((c=(u=d[C]||(d[C]={}))[d.uniqueID]||(u[d.uniqueID]={}))[e]=[b,w]),d!==t)););return(w-=r)===o||w%o==0&&w/o>=0}}},PSEUDO:function(e,t){var n,r=o.pseudos[e]||o.setFilters[e.toLowerCase()]||le.error("unsupported pseudo: "+e);return r[C]?r(t):r.length>1?(n=[e,e,"",t],o.setFilters.hasOwnProperty(e.toLowerCase())?se(function(e,n){for(var o,i=r(e,t),A=i.length;A--;)e[o=H(e,i[A])]=!(n[o]=i[A])}):function(e){return r(e,0,n)}):r}},pseudos:{not:se(function(e){var t=[],n=[],o=l(e.replace(j,"$1"));return o[C]?se(function(e,t,n,r){for(var i,A=o(e,null,r,[]),l=e.length;l--;)(i=A[l])&&(e[l]=!(t[l]=i))}):function(e,r,i){return t[0]=e,o(t,null,i,n),t[0]=null,!n.pop()}}),has:se(function(e){return function(t){return le(e,t).length>0}}),contains:se(function(e){return e=e.replace(te,ne),function(t){return(t.textContent||r(t)).indexOf(e)>-1}}),lang:se(function(e){return K.test(e||"")||le.error("unsupported lang: "+e),e=e.replace(te,ne).toLowerCase(),function(t){var n;do{if(n=h?t.lang:t.getAttribute("xml:lang")||t.getAttribute("lang"))return(n=n.toLowerCase())===e||0===n.indexOf(e+"-")}while((t=t.parentNode)&&1===t.nodeType);return!1}}),target:function(t){var n=e.location&&e.location.hash;return n&&n.slice(1)===t.id},root:function(e){return e===f},focus:function(e){return e===p.activeElement&&(!p.hasFocus||p.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:he(!1),disabled:he(!0),checked:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&!!e.checked||"option"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,!0===e.selected},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeType<6)return!1;return!0},parent:function(e){return!o.pseudos.empty(e)},header:function(e){return Y.test(e.nodeName)},input:function(e){return Q.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&"button"===e.type||"button"===t},text:function(e){var t;return"input"===e.nodeName.toLowerCase()&&"text"===e.type&&(null==(t=e.getAttribute("type"))||"text"===t.toLowerCase())},first:ge(function(){return[0]}),last:ge(function(e,t){return[t-1]}),eq:ge(function(e,t,n){return[n<0?n+t:n]}),even:ge(function(e,t){for(var n=0;n<t;n+=2)e.push(n);return e}),odd:ge(function(e,t){for(var n=1;n<t;n+=2)e.push(n);return e}),lt:ge(function(e,t,n){for(var o=n<0?n+t:n>t?t:n;--o>=0;)e.push(o);return e}),gt:ge(function(e,t,n){for(var o=n<0?n+t:n;++o<t;)e.push(o);return e})}}).pseudos.nth=o.pseudos.eq,{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})o.pseudos[t]=pe(t);for(t in{submit:!0,reset:!0})o.pseudos[t]=fe(t);function ve(){}function we(e){for(var t=0,n=e.length,o="";t<n;t++)o+=e[t].value;return o}function Ce(e,t,n){var o=t.dir,r=t.next,i=r||o,A=n&&"parentNode"===i,l=x++;return t.first?function(t,n,r){for(;t=t[o];)if(1===t.nodeType||A)return e(t,n,r);return!1}:function(t,n,a){var s,c,u,d=[b,l];if(a){for(;t=t[o];)if((1===t.nodeType||A)&&e(t,n,a))return!0}else for(;t=t[o];)if(1===t.nodeType||A)if(c=(u=t[C]||(t[C]={}))[t.uniqueID]||(u[t.uniqueID]={}),r&&r===t.nodeName.toLowerCase())t=t[o]||t;else{if((s=c[i])&&s[0]===b&&s[1]===l)return d[2]=s[2];if(c[i]=d,d[2]=e(t,n,a))return!0}return!1}}function ye(e){return e.length>1?function(t,n,o){for(var r=e.length;r--;)if(!e[r](t,n,o))return!1;return!0}:e[0]}function be(e,t,n,o,r){for(var i,A=[],l=0,a=e.length,s=null!=t;l<a;l++)(i=e[l])&&(n&&!n(i,o,r)||(A.push(i),s&&t.push(l)));return A}function xe(e,t,n,o,r,i){return o&&!o[C]&&(o=xe(o)),r&&!r[C]&&(r=xe(r,i)),se(function(i,A,l,a){var s,c,u,d=[],p=[],f=A.length,h=i||function(e,t,n){for(var o=0,r=t.length;o<r;o++)le(e,t[o],n);return n}(t||"*",l.nodeType?[l]:l,[]),g=!e||!i&&t?h:be(h,d,e,l,a),m=n?r||(i?e:f||o)?[]:A:g;if(n&&n(g,m,l,a),o)for(s=be(m,p),o(s,[],l,a),c=s.length;c--;)(u=s[c])&&(m[p[c]]=!(g[p[c]]=u));if(i){if(r||e){if(r){for(s=[],c=m.length;c--;)(u=m[c])&&s.push(g[c]=u);r(null,m=[],s,a)}for(c=m.length;c--;)(u=m[c])&&(s=r?H(i,u):d[c])>-1&&(i[s]=!(A[s]=u))}}else m=be(m===A?m.splice(f,m.length):m),r?r(null,A,m,a):N.apply(A,m)})}function ke(e){for(var t,n,r,i=e.length,A=o.relative[e[0].type],l=A||o.relative[" "],a=A?1:0,c=Ce(function(e){return e===t},l,!0),u=Ce(function(e){return H(t,e)>-1},l,!0),d=[function(e,n,o){var r=!A&&(o||n!==s)||((t=n).nodeType?c(e,n,o):u(e,n,o));return t=null,r}];a<i;a++)if(n=o.relative[e[a].type])d=[Ce(ye(d),n)];else{if((n=o.filter[e[a].type].apply(null,e[a].matches))[C]){for(r=++a;r<i&&!o.relative[e[r].type];r++);return xe(a>1&&ye(d),a>1&&we(e.slice(0,a-1).concat({value:" "===e[a-2].type?"*":""})).replace(j,"$1"),n,a<r&&ke(e.slice(a,r)),r<i&&ke(e=e.slice(r)),r<i&&we(e))}d.push(n)}return ye(d)}return ve.prototype=o.filters=o.pseudos,o.setFilters=new ve,A=le.tokenize=function(e,t){var n,r,i,A,l,a,s,c=R[e+" "];if(c)return t?0:c.slice(0);for(l=e,a=[],s=o.preFilter;l;){for(A in n&&!(r=O.exec(l))||(r&&(l=l.slice(r[0].length)||l),a.push(i=[])),n=!1,(r=z.exec(l))&&(n=r.shift(),i.push({value:n,type:r[0].replace(j," ")}),l=l.slice(n.length)),o.filter)!(r=U[A].exec(l))||s[A]&&!(r=s[A](r))||(n=r.shift(),i.push({value:n,type:A,matches:r}),l=l.slice(n.length));if(!n)break}return t?l.length:l?le.error(e):R(e,a).slice(0)},l=le.compile=function(e,t){var n,r=[],i=[],l=S[e+" "];if(!l){for(t||(t=A(e)),n=t.length;n--;)(l=ke(t[n]))[C]?r.push(l):i.push(l);(l=S(e,function(e,t){var n=t.length>0,r=e.length>0,i=function(i,A,l,a,c){var u,f,g,m=0,v="0",w=i&&[],C=[],y=s,x=i||r&&o.find.TAG("*",c),k=b+=null==y?1:Math.random()||.1,R=x.length;for(c&&(s=A===p||A||c);v!==R&&null!=(u=x[v]);v++){if(r&&u){for(f=0,A||u.ownerDocument===p||(d(u),l=!h);g=e[f++];)if(g(u,A||p,l)){a.push(u);break}c&&(b=k)}n&&((u=!g&&u)&&m--,i&&w.push(u))}if(m+=v,n&&v!==m){for(f=0;g=t[f++];)g(w,C,A,l);if(i){if(m>0)for(;v--;)w[v]||C[v]||(C[v]=P.call(a));C=be(C)}N.apply(a,C),c&&!i&&C.length>0&&m+t.length>1&&le.uniqueSort(a)}return c&&(b=k,s=y),w};return n?se(i):i}(i,r))).selector=e}return l},a=le.select=function(e,t,n,r){var i,a,s,c,u,d="function"==typeof e&&e,p=!r&&A(e=d.selector||e);if(n=n||[],1===p.length){if((a=p[0]=p[0].slice(0)).length>2&&"ID"===(s=a[0]).type&&9===t.nodeType&&h&&o.relative[a[1].type]){if(!(t=(o.find.ID(s.matches[0].replace(te,ne),t)||[])[0]))return n;d&&(t=t.parentNode),e=e.slice(a.shift().value.length)}for(i=U.needsContext.test(e)?0:a.length;i--&&(s=a[i],!o.relative[c=s.type]);)if((u=o.find[c])&&(r=u(s.matches[0].replace(te,ne),ee.test(a[0].type)&&me(t.parentNode)||t))){if(a.splice(i,1),!(e=r.length&&we(a)))return N.apply(n,r),n;break}}return(d||l(e,p))(r,t,!h,n,!t||ee.test(e)&&me(t.parentNode)||t),n},n.sortStable=C.split("").sort(_).join("")===C,n.detectDuplicates=!!u,d(),n.sortDetached=ce(function(e){return 1&e.compareDocumentPosition(p.createElement("fieldset"))}),ce(function(e){return e.innerHTML="<a href='#'></a>","#"===e.firstChild.getAttribute("href")})||ue("type|href|height|width",function(e,t,n){if(!n)return e.getAttribute(t,"type"===t.toLowerCase()?1:2)}),n.attributes&&ce(function(e){return e.innerHTML="<input/>",e.firstChild.setAttribute("value",""),""===e.firstChild.getAttribute("value")})||ue("value",function(e,t,n){if(!n&&"input"===e.nodeName.toLowerCase())return e.defaultValue}),ce(function(e){return null==e.getAttribute("disabled")})||ue(M,function(e,t,n){var o;if(!n)return!0===e[t]?t.toLowerCase():(o=e.getAttributeNode(t))&&o.specified?o.value:null}),le}(e);C.find=x,C.expr=x.selectors,C.expr[":"]=C.expr.pseudos,C.uniqueSort=C.unique=x.uniqueSort,C.text=x.getText,C.isXMLDoc=x.isXML,C.contains=x.contains,C.escapeSelector=x.escape;var k=function(e,t,n){for(var o=[],r=void 0!==n;(e=e[t])&&9!==e.nodeType;)if(1===e.nodeType){if(r&&C(e).is(n))break;o.push(e)}return o},R=function(e,t){for(var n=[];e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n},S=C.expr.match.needsContext;function E(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()}var _=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;function T(e,t,n){return h(t)?C.grep(e,function(e,o){return!!t.call(e,o,e)!==n}):t.nodeType?C.grep(e,function(e){return e===t!==n}):"string"!=typeof t?C.grep(e,function(e){return a.call(t,e)>-1!==n}):C.filter(t,e,n)}C.filter=function(e,t,n){var o=t[0];return n&&(e=":not("+e+")"),1===t.length&&1===o.nodeType?C.find.matchesSelector(o,e)?[o]:[]:C.find.matches(e,C.grep(t,function(e){return 1===e.nodeType}))},C.fn.extend({find:function(e){var t,n,o=this.length,r=this;if("string"!=typeof e)return this.pushStack(C(e).filter(function(){for(t=0;t<o;t++)if(C.contains(r[t],this))return!0}));for(n=this.pushStack([]),t=0;t<o;t++)C.find(e,r[t],n);return o>1?C.uniqueSort(n):n},filter:function(e){return this.pushStack(T(this,e||[],!1))},not:function(e){return this.pushStack(T(this,e||[],!0))},is:function(e){return!!T(this,"string"==typeof e&&S.test(e)?C(e):e||[],!1).length}});var D,P=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/;(C.fn.init=function(e,t,n){var r,i;if(!e)return this;if(n=n||D,"string"==typeof e){if(!(r="<"===e[0]&&">"===e[e.length-1]&&e.length>=3?[null,e,null]:P.exec(e))||!r[1]&&t)return!t||t.jquery?(t||n).find(e):this.constructor(t).find(e);if(r[1]){if(t=t instanceof C?t[0]:t,C.merge(this,C.parseHTML(r[1],t&&t.nodeType?t.ownerDocument||t:o,!0)),_.test(r[1])&&C.isPlainObject(t))for(r in t)h(this[r])?this[r](t[r]):this.attr(r,t[r]);return this}return(i=o.getElementById(r[2]))&&(this[0]=i,this.length=1),this}return e.nodeType?(this[0]=e,this.length=1,this):h(e)?void 0!==n.ready?n.ready(e):e(C):C.makeArray(e,this)}).prototype=C.fn,D=C(o);var I=/^(?:parents|prev(?:Until|All))/,N={children:!0,contents:!0,next:!0,prev:!0};function $(e,t){for(;(e=e[t])&&1!==e.nodeType;);return e}C.fn.extend({has:function(e){var t=C(e,this),n=t.length;return this.filter(function(){for(var e=0;e<n;e++)if(C.contains(this,t[e]))return!0})},closest:function(e,t){var n,o=0,r=this.length,i=[],A="string"!=typeof e&&C(e);if(!S.test(e))for(;o<r;o++)for(n=this[o];n&&n!==t;n=n.parentNode)if(n.nodeType<11&&(A?A.index(n)>-1:1===n.nodeType&&C.find.matchesSelector(n,e))){i.push(n);break}return this.pushStack(i.length>1?C.uniqueSort(i):i)},index:function(e){return e?"string"==typeof e?a.call(C(e),this[0]):a.call(this,e.jquery?e[0]:e):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){return this.pushStack(C.uniqueSort(C.merge(this.get(),C(e,t))))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),C.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return k(e,"parentNode")},parentsUntil:function(e,t,n){return k(e,"parentNode",n)},next:function(e){return $(e,"nextSibling")},prev:function(e){return $(e,"previousSibling")},nextAll:function(e){return k(e,"nextSibling")},prevAll:function(e){return k(e,"previousSibling")},nextUntil:function(e,t,n){return k(e,"nextSibling",n)},prevUntil:function(e,t,n){return k(e,"previousSibling",n)},siblings:function(e){return R((e.parentNode||{}).firstChild,e)},children:function(e){return R(e.firstChild)},contents:function(e){return void 0!==e.contentDocument?e.contentDocument:(E(e,"template")&&(e=e.content||e),C.merge([],e.childNodes))}},function(e,t){C.fn[e]=function(n,o){var r=C.map(this,t,n);return"Until"!==e.slice(-5)&&(o=n),o&&"string"==typeof o&&(r=C.filter(o,r)),this.length>1&&(N[e]||C.uniqueSort(r),I.test(e)&&r.reverse()),this.pushStack(r)}});var H=/[^\x20\t\r\n\f]+/g;function M(e){return e}function L(e){throw e}function F(e,t,n,o){var r;try{e&&h(r=e.promise)?r.call(e).done(t).fail(n):e&&h(r=e.then)?r.call(e,t,n):t.apply(void 0,[e].slice(o))}catch(e){n.apply(void 0,[e])}}C.Callbacks=function(e){e="string"==typeof e?function(e){var t={};return C.each(e.match(H)||[],function(e,n){t[n]=!0}),t}(e):C.extend({},e);var t,n,o,r,i=[],A=[],l=-1,a=function(){for(r=r||e.once,o=t=!0;A.length;l=-1)for(n=A.shift();++l<i.length;)!1===i[l].apply(n[0],n[1])&&e.stopOnFalse&&(l=i.length,n=!1);e.memory||(n=!1),t=!1,r&&(i=n?[]:"")},s={add:function(){return i&&(n&&!t&&(l=i.length-1,A.push(n)),function t(n){C.each(n,function(n,o){h(o)?e.unique&&s.has(o)||i.push(o):o&&o.length&&"string"!==w(o)&&t(o)})}(arguments),n&&!t&&a()),this},remove:function(){return C.each(arguments,function(e,t){for(var n;(n=C.inArray(t,i,n))>-1;)i.splice(n,1),n<=l&&l--}),this},has:function(e){return e?C.inArray(e,i)>-1:i.length>0},empty:function(){return i&&(i=[]),this},disable:function(){return r=A=[],i=n="",this},disabled:function(){return!i},lock:function(){return r=A=[],n||t||(i=n=""),this},locked:function(){return!!r},fireWith:function(e,n){return r||(n=[e,(n=n||[]).slice?n.slice():n],A.push(n),t||a()),this},fire:function(){return s.fireWith(this,arguments),this},fired:function(){return!!o}};return s},C.extend({Deferred:function(t){var n=[["notify","progress",C.Callbacks("memory"),C.Callbacks("memory"),2],["resolve","done",C.Callbacks("once memory"),C.Callbacks("once memory"),0,"resolved"],["reject","fail",C.Callbacks("once memory"),C.Callbacks("once memory"),1,"rejected"]],o="pending",r={state:function(){return o},always:function(){return i.done(arguments).fail(arguments),this},catch:function(e){return r.then(null,e)},pipe:function(){var e=arguments;return C.Deferred(function(t){C.each(n,function(n,o){var r=h(e[o[4]])&&e[o[4]];i[o[1]](function(){var e=r&&r.apply(this,arguments);e&&h(e.promise)?e.promise().progress(t.notify).done(t.resolve).fail(t.reject):t[o[0]+"With"](this,r?[e]:arguments)})}),e=null}).promise()},then:function(t,o,r){var i=0;function A(t,n,o,r){return function(){var l=this,a=arguments,s=function(){var e,s;if(!(t<i)){if((e=o.apply(l,a))===n.promise())throw new TypeError("Thenable self-resolution");s=e&&("object"==typeof e||"function"==typeof e)&&e.then,h(s)?r?s.call(e,A(i,n,M,r),A(i,n,L,r)):(i++,s.call(e,A(i,n,M,r),A(i,n,L,r),A(i,n,M,n.notifyWith))):(o!==M&&(l=void 0,a=[e]),(r||n.resolveWith)(l,a))}},c=r?s:function(){try{s()}catch(e){C.Deferred.exceptionHook&&C.Deferred.exceptionHook(e,c.stackTrace),t+1>=i&&(o!==L&&(l=void 0,a=[e]),n.rejectWith(l,a))}};t?c():(C.Deferred.getStackHook&&(c.stackTrace=C.Deferred.getStackHook()),e.setTimeout(c))}}return C.Deferred(function(e){n[0][3].add(A(0,e,h(r)?r:M,e.notifyWith)),n[1][3].add(A(0,e,h(t)?t:M)),n[2][3].add(A(0,e,h(o)?o:L))}).promise()},promise:function(e){return null!=e?C.extend(e,r):r}},i={};return C.each(n,function(e,t){var A=t[2],l=t[5];r[t[1]]=A.add,l&&A.add(function(){o=l},n[3-e][2].disable,n[3-e][3].disable,n[0][2].lock,n[0][3].lock),A.add(t[3].fire),i[t[0]]=function(){return i[t[0]+"With"](this===i?void 0:this,arguments),this},i[t[0]+"With"]=A.fireWith}),r.promise(i),t&&t.call(i,i),i},when:function(e){var t=arguments.length,n=t,o=Array(n),r=i.call(arguments),A=C.Deferred(),l=function(e){return function(n){o[e]=this,r[e]=arguments.length>1?i.call(arguments):n,--t||A.resolveWith(o,r)}};if(t<=1&&(F(e,A.done(l(n)).resolve,A.reject,!t),"pending"===A.state()||h(r[n]&&r[n].then)))return A.then();for(;n--;)F(r[n],l(n),A.reject);return A.promise()}});var V=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;C.Deferred.exceptionHook=function(t,n){e.console&&e.console.warn&&t&&V.test(t.name)&&e.console.warn("jQuery.Deferred exception: "+t.message,t.stack,n)},C.readyException=function(t){e.setTimeout(function(){throw t})};var W=C.Deferred();function B(){o.removeEventListener("DOMContentLoaded",B),e.removeEventListener("load",B),C.ready()}C.fn.ready=function(e){return W.then(e).catch(function(e){C.readyException(e)}),this},C.extend({isReady:!1,readyWait:1,ready:function(e){(!0===e?--C.readyWait:C.isReady)||(C.isReady=!0,!0!==e&&--C.readyWait>0||W.resolveWith(o,[C]))}}),C.ready.then=W.then,"complete"===o.readyState||"loading"!==o.readyState&&!o.documentElement.doScroll?e.setTimeout(C.ready):(o.addEventListener("DOMContentLoaded",B),e.addEventListener("load",B));var j=function(e,t,n,o,r,i,A){var l=0,a=e.length,s=null==n;if("object"===w(n))for(l in r=!0,n)j(e,t,l,n[l],!0,i,A);else if(void 0!==o&&(r=!0,h(o)||(A=!0),s&&(A?(t.call(e,o),t=null):(s=t,t=function(e,t,n){return s.call(C(e),n)})),t))for(;l<a;l++)t(e[l],n,A?o:o.call(e[l],l,t(e[l],n)));return r?e:s?t.call(e):a?t(e[0],n):i},O=/^-ms-/,z=/-([a-z])/g;function q(e,t){return t.toUpperCase()}function G(e){return e.replace(O,"ms-").replace(z,q)}var K=function(e){return 1===e.nodeType||9===e.nodeType||!+e.nodeType};function U(){this.expando=C.expando+U.uid++}U.uid=1,U.prototype={cache:function(e){var t=e[this.expando];return t||(t={},K(e)&&(e.nodeType?e[this.expando]=t:Object.defineProperty(e,this.expando,{value:t,configurable:!0}))),t},set:function(e,t,n){var o,r=this.cache(e);if("string"==typeof t)r[G(t)]=n;else for(o in t)r[G(o)]=t[o];return r},get:function(e,t){return void 0===t?this.cache(e):e[this.expando]&&e[this.expando][G(t)]},access:function(e,t,n){return void 0===t||t&&"string"==typeof t&&void 0===n?this.get(e,t):(this.set(e,t,n),void 0!==n?n:t)},remove:function(e,t){var n,o=e[this.expando];if(void 0!==o){if(void 0!==t){n=(t=Array.isArray(t)?t.map(G):(t=G(t))in o?[t]:t.match(H)||[]).length;for(;n--;)delete o[t[n]]}(void 0===t||C.isEmptyObject(o))&&(e.nodeType?e[this.expando]=void 0:delete e[this.expando])}},hasData:function(e){var t=e[this.expando];return void 0!==t&&!C.isEmptyObject(t)}};var X=new U,Q=new U,Y=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,J=/[A-Z]/g;function Z(e,t,n){var o;if(void 0===n&&1===e.nodeType)if(o="data-"+t.replace(J,"-$&").toLowerCase(),"string"==typeof(n=e.getAttribute(o))){try{n=function(e){return"true"===e||"false"!==e&&("null"===e?null:e===+e+""?+e:Y.test(e)?JSON.parse(e):e)}(n)}catch(e){}Q.set(e,t,n)}else n=void 0;return n}C.extend({hasData:function(e){return Q.hasData(e)||X.hasData(e)},data:function(e,t,n){return Q.access(e,t,n)},removeData:function(e,t){Q.remove(e,t)},_data:function(e,t,n){return X.access(e,t,n)},_removeData:function(e,t){X.remove(e,t)}}),C.fn.extend({data:function(e,t){var n,o,r,i=this[0],A=i&&i.attributes;if(void 0===e){if(this.length&&(r=Q.get(i),1===i.nodeType&&!X.get(i,"hasDataAttrs"))){for(n=A.length;n--;)A[n]&&0===(o=A[n].name).indexOf("data-")&&(o=G(o.slice(5)),Z(i,o,r[o]));X.set(i,"hasDataAttrs",!0)}return r}return"object"==typeof e?this.each(function(){Q.set(this,e)}):j(this,function(t){var n;if(i&&void 0===t)return void 0!==(n=Q.get(i,e))?n:void 0!==(n=Z(i,e))?n:void 0;this.each(function(){Q.set(this,e,t)})},null,t,arguments.length>1,null,!0)},removeData:function(e){return this.each(function(){Q.remove(this,e)})}}),C.extend({queue:function(e,t,n){var o;if(e)return t=(t||"fx")+"queue",o=X.get(e,t),n&&(!o||Array.isArray(n)?o=X.access(e,t,C.makeArray(n)):o.push(n)),o||[]},dequeue:function(e,t){t=t||"fx";var n=C.queue(e,t),o=n.length,r=n.shift(),i=C._queueHooks(e,t);"inprogress"===r&&(r=n.shift(),o--),r&&("fx"===t&&n.unshift("inprogress"),delete i.stop,r.call(e,function(){C.dequeue(e,t)},i)),!o&&i&&i.empty.fire()},_queueHooks:function(e,t){var n=t+"queueHooks";return X.get(e,n)||X.access(e,n,{empty:C.Callbacks("once memory").add(function(){X.remove(e,[t+"queue",n])})})}}),C.fn.extend({queue:function(e,t){var n=2;return"string"!=typeof e&&(t=e,e="fx",n--),arguments.length<n?C.queue(this[0],e):void 0===t?this:this.each(function(){var n=C.queue(this,e,t);C._queueHooks(this,e),"fx"===e&&"inprogress"!==n[0]&&C.dequeue(this,e)})},dequeue:function(e){return this.each(function(){C.dequeue(this,e)})},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,t){var n,o=1,r=C.Deferred(),i=this,A=this.length,l=function(){--o||r.resolveWith(i,[i])};for("string"!=typeof e&&(t=e,e=void 0),e=e||"fx";A--;)(n=X.get(i[A],e+"queueHooks"))&&n.empty&&(o++,n.empty.add(l));return l(),r.promise(t)}});var ee=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,te=new RegExp("^(?:([+-])=|)("+ee+")([a-z%]*)$","i"),ne=["Top","Right","Bottom","Left"],oe=o.documentElement,re=function(e){return C.contains(e.ownerDocument,e)},ie={composed:!0};oe.getRootNode&&(re=function(e){return C.contains(e.ownerDocument,e)||e.getRootNode(ie)===e.ownerDocument});var Ae=function(e,t){return"none"===(e=t||e).style.display||""===e.style.display&&re(e)&&"none"===C.css(e,"display")},le=function(e,t,n,o){var r,i,A={};for(i in t)A[i]=e.style[i],e.style[i]=t[i];for(i in r=n.apply(e,o||[]),t)e.style[i]=A[i];return r};function ae(e,t,n,o){var r,i,A=20,l=o?function(){return o.cur()}:function(){return C.css(e,t,"")},a=l(),s=n&&n[3]||(C.cssNumber[t]?"":"px"),c=e.nodeType&&(C.cssNumber[t]||"px"!==s&&+a)&&te.exec(C.css(e,t));if(c&&c[3]!==s){for(a/=2,s=s||c[3],c=+a||1;A--;)C.style(e,t,c+s),(1-i)*(1-(i=l()/a||.5))<=0&&(A=0),c/=i;c*=2,C.style(e,t,c+s),n=n||[]}return n&&(c=+c||+a||0,r=n[1]?c+(n[1]+1)*n[2]:+n[2],o&&(o.unit=s,o.start=c,o.end=r)),r}var se={};function ce(e){var t,n=e.ownerDocument,o=e.nodeName,r=se[o];return r||(t=n.body.appendChild(n.createElement(o)),r=C.css(t,"display"),t.parentNode.removeChild(t),"none"===r&&(r="block"),se[o]=r,r)}function ue(e,t){for(var n,o,r=[],i=0,A=e.length;i<A;i++)(o=e[i]).style&&(n=o.style.display,t?("none"===n&&(r[i]=X.get(o,"display")||null,r[i]||(o.style.display="")),""===o.style.display&&Ae(o)&&(r[i]=ce(o))):"none"!==n&&(r[i]="none",X.set(o,"display",n)));for(i=0;i<A;i++)null!=r[i]&&(e[i].style.display=r[i]);return e}C.fn.extend({show:function(){return ue(this,!0)},hide:function(){return ue(this)},toggle:function(e){return"boolean"==typeof e?e?this.show():this.hide():this.each(function(){Ae(this)?C(this).show():C(this).hide()})}});var de=/^(?:checkbox|radio)$/i,pe=/<([a-z][^\/\0>\x20\t\r\n\f]*)/i,fe=/^$|^module$|\/(?:java|ecma)script/i,he={option:[1,"<select multiple='multiple'>","</select>"],thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};function ge(e,t){var n;return n=void 0!==e.getElementsByTagName?e.getElementsByTagName(t||"*"):void 0!==e.querySelectorAll?e.querySelectorAll(t||"*"):[],void 0===t||t&&E(e,t)?C.merge([e],n):n}function me(e,t){for(var n=0,o=e.length;n<o;n++)X.set(e[n],"globalEval",!t||X.get(t[n],"globalEval"))}he.optgroup=he.option,he.tbody=he.tfoot=he.colgroup=he.caption=he.thead,he.th=he.td;var ve,we,Ce=/<|&#?\w+;/;function ye(e,t,n,o,r){for(var i,A,l,a,s,c,u=t.createDocumentFragment(),d=[],p=0,f=e.length;p<f;p++)if((i=e[p])||0===i)if("object"===w(i))C.merge(d,i.nodeType?[i]:i);else if(Ce.test(i)){for(A=A||u.appendChild(t.createElement("div")),l=(pe.exec(i)||["",""])[1].toLowerCase(),a=he[l]||he._default,A.innerHTML=a[1]+C.htmlPrefilter(i)+a[2],c=a[0];c--;)A=A.lastChild;C.merge(d,A.childNodes),(A=u.firstChild).textContent=""}else d.push(t.createTextNode(i));for(u.textContent="",p=0;i=d[p++];)if(o&&C.inArray(i,o)>-1)r&&r.push(i);else if(s=re(i),A=ge(u.appendChild(i),"script"),s&&me(A),n)for(c=0;i=A[c++];)fe.test(i.type||"")&&n.push(i);return u}ve=o.createDocumentFragment().appendChild(o.createElement("div")),(we=o.createElement("input")).setAttribute("type","radio"),we.setAttribute("checked","checked"),we.setAttribute("name","t"),ve.appendChild(we),f.checkClone=ve.cloneNode(!0).cloneNode(!0).lastChild.checked,ve.innerHTML="<textarea>x</textarea>",f.noCloneChecked=!!ve.cloneNode(!0).lastChild.defaultValue;var be=/^key/,xe=/^(?:mouse|pointer|contextmenu|drag|drop)|click/,ke=/^([^.]*)(?:\.(.+)|)/;function Re(){return!0}function Se(){return!1}function Ee(e,t){return e===function(){try{return o.activeElement}catch(e){}}()==("focus"===t)}function _e(e,t,n,o,r,i){var A,l;if("object"==typeof t){for(l in"string"!=typeof n&&(o=o||n,n=void 0),t)_e(e,l,n,o,t[l],i);return e}if(null==o&&null==r?(r=n,o=n=void 0):null==r&&("string"==typeof n?(r=o,o=void 0):(r=o,o=n,n=void 0)),!1===r)r=Se;else if(!r)return e;return 1===i&&(A=r,(r=function(e){return C().off(e),A.apply(this,arguments)}).guid=A.guid||(A.guid=C.guid++)),e.each(function(){C.event.add(this,t,r,o,n)})}function Te(e,t,n){n?(X.set(e,t,!1),C.event.add(e,t,{namespace:!1,handler:function(e){var o,r,A=X.get(this,t);if(1&e.isTrigger&&this[t]){if(A.length)(C.event.special[t]||{}).delegateType&&e.stopPropagation();else if(A=i.call(arguments),X.set(this,t,A),o=n(this,t),this[t](),A!==(r=X.get(this,t))||o?X.set(this,t,!1):r={},A!==r)return e.stopImmediatePropagation(),e.preventDefault(),r.value}else A.length&&(X.set(this,t,{value:C.event.trigger(C.extend(A[0],C.Event.prototype),A.slice(1),this)}),e.stopImmediatePropagation())}})):void 0===X.get(e,t)&&C.event.add(e,t,Re)}C.event={global:{},add:function(e,t,n,o,r){var i,A,l,a,s,c,u,d,p,f,h,g=X.get(e);if(g)for(n.handler&&(n=(i=n).handler,r=i.selector),r&&C.find.matchesSelector(oe,r),n.guid||(n.guid=C.guid++),(a=g.events)||(a=g.events={}),(A=g.handle)||(A=g.handle=function(t){return void 0!==C&&C.event.triggered!==t.type?C.event.dispatch.apply(e,arguments):void 0}),s=(t=(t||"").match(H)||[""]).length;s--;)p=h=(l=ke.exec(t[s])||[])[1],f=(l[2]||"").split(".").sort(),p&&(u=C.event.special[p]||{},p=(r?u.delegateType:u.bindType)||p,u=C.event.special[p]||{},c=C.extend({type:p,origType:h,data:o,handler:n,guid:n.guid,selector:r,needsContext:r&&C.expr.match.needsContext.test(r),namespace:f.join(".")},i),(d=a[p])||((d=a[p]=[]).delegateCount=0,u.setup&&!1!==u.setup.call(e,o,f,A)||e.addEventListener&&e.addEventListener(p,A)),u.add&&(u.add.call(e,c),c.handler.guid||(c.handler.guid=n.guid)),r?d.splice(d.delegateCount++,0,c):d.push(c),C.event.global[p]=!0)},remove:function(e,t,n,o,r){var i,A,l,a,s,c,u,d,p,f,h,g=X.hasData(e)&&X.get(e);if(g&&(a=g.events)){for(s=(t=(t||"").match(H)||[""]).length;s--;)if(p=h=(l=ke.exec(t[s])||[])[1],f=(l[2]||"").split(".").sort(),p){for(u=C.event.special[p]||{},d=a[p=(o?u.delegateType:u.bindType)||p]||[],l=l[2]&&new RegExp("(^|\\.)"+f.join("\\.(?:.*\\.|)")+"(\\.|$)"),A=i=d.length;i--;)c=d[i],!r&&h!==c.origType||n&&n.guid!==c.guid||l&&!l.test(c.namespace)||o&&o!==c.selector&&("**"!==o||!c.selector)||(d.splice(i,1),c.selector&&d.delegateCount--,u.remove&&u.remove.call(e,c));A&&!d.length&&(u.teardown&&!1!==u.teardown.call(e,f,g.handle)||C.removeEvent(e,p,g.handle),delete a[p])}else for(p in a)C.event.remove(e,p+t[s],n,o,!0);C.isEmptyObject(a)&&X.remove(e,"handle events")}},dispatch:function(e){var t,n,o,r,i,A,l=C.event.fix(e),a=new Array(arguments.length),s=(X.get(this,"events")||{})[l.type]||[],c=C.event.special[l.type]||{};for(a[0]=l,t=1;t<arguments.length;t++)a[t]=arguments[t];if(l.delegateTarget=this,!c.preDispatch||!1!==c.preDispatch.call(this,l)){for(A=C.event.handlers.call(this,l,s),t=0;(r=A[t++])&&!l.isPropagationStopped();)for(l.currentTarget=r.elem,n=0;(i=r.handlers[n++])&&!l.isImmediatePropagationStopped();)l.rnamespace&&!1!==i.namespace&&!l.rnamespace.test(i.namespace)||(l.handleObj=i,l.data=i.data,void 0!==(o=((C.event.special[i.origType]||{}).handle||i.handler).apply(r.elem,a))&&!1===(l.result=o)&&(l.preventDefault(),l.stopPropagation()));return c.postDispatch&&c.postDispatch.call(this,l),l.result}},handlers:function(e,t){var n,o,r,i,A,l=[],a=t.delegateCount,s=e.target;if(a&&s.nodeType&&!("click"===e.type&&e.button>=1))for(;s!==this;s=s.parentNode||this)if(1===s.nodeType&&("click"!==e.type||!0!==s.disabled)){for(i=[],A={},n=0;n<a;n++)void 0===A[r=(o=t[n]).selector+" "]&&(A[r]=o.needsContext?C(r,this).index(s)>-1:C.find(r,this,null,[s]).length),A[r]&&i.push(o);i.length&&l.push({elem:s,handlers:i})}return s=this,a<t.length&&l.push({elem:s,handlers:t.slice(a)}),l},addProp:function(e,t){Object.defineProperty(C.Event.prototype,e,{enumerable:!0,configurable:!0,get:h(t)?function(){if(this.originalEvent)return t(this.originalEvent)}:function(){if(this.originalEvent)return this.originalEvent[e]},set:function(t){Object.defineProperty(this,e,{enumerable:!0,configurable:!0,writable:!0,value:t})}})},fix:function(e){return e[C.expando]?e:new C.Event(e)},special:{load:{noBubble:!0},click:{setup:function(e){var t=this||e;return de.test(t.type)&&t.click&&E(t,"input")&&Te(t,"click",Re),!1},trigger:function(e){var t=this||e;return de.test(t.type)&&t.click&&E(t,"input")&&Te(t,"click"),!0},_default:function(e){var t=e.target;return de.test(t.type)&&t.click&&E(t,"input")&&X.get(t,"click")||E(t,"a")}},beforeunload:{postDispatch:function(e){void 0!==e.result&&e.originalEvent&&(e.originalEvent.returnValue=e.result)}}}},C.removeEvent=function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n)},C.Event=function(e,t){if(!(this instanceof C.Event))return new C.Event(e,t);e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||void 0===e.defaultPrevented&&!1===e.returnValue?Re:Se,this.target=e.target&&3===e.target.nodeType?e.target.parentNode:e.target,this.currentTarget=e.currentTarget,this.relatedTarget=e.relatedTarget):this.type=e,t&&C.extend(this,t),this.timeStamp=e&&e.timeStamp||Date.now(),this[C.expando]=!0},C.Event.prototype={constructor:C.Event,isDefaultPrevented:Se,isPropagationStopped:Se,isImmediatePropagationStopped:Se,isSimulated:!1,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=Re,e&&!this.isSimulated&&e.preventDefault()},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=Re,e&&!this.isSimulated&&e.stopPropagation()},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=Re,e&&!this.isSimulated&&e.stopImmediatePropagation(),this.stopPropagation()}},C.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,char:!0,code:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:function(e){var t=e.button;return null==e.which&&be.test(e.type)?null!=e.charCode?e.charCode:e.keyCode:!e.which&&void 0!==t&&xe.test(e.type)?1&t?1:2&t?3:4&t?2:0:e.which}},C.event.addProp),C.each({focus:"focusin",blur:"focusout"},function(e,t){C.event.special[e]={setup:function(){return Te(this,e,Ee),!1},trigger:function(){return Te(this,e),!0},delegateType:t}}),C.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(e,t){C.event.special[e]={delegateType:t,bindType:t,handle:function(e){var n,o=e.relatedTarget,r=e.handleObj;return o&&(o===this||C.contains(this,o))||(e.type=r.origType,n=r.handler.apply(this,arguments),e.type=t),n}}}),C.fn.extend({on:function(e,t,n,o){return _e(this,e,t,n,o)},one:function(e,t,n,o){return _e(this,e,t,n,o,1)},off:function(e,t,n){var o,r;if(e&&e.preventDefault&&e.handleObj)return o=e.handleObj,C(e.delegateTarget).off(o.namespace?o.origType+"."+o.namespace:o.origType,o.selector,o.handler),this;if("object"==typeof e){for(r in e)this.off(r,t,e[r]);return this}return!1!==t&&"function"!=typeof t||(n=t,t=void 0),!1===n&&(n=Se),this.each(function(){C.event.remove(this,e,n,t)})}});var De=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi,Pe=/<script|<style|<link/i,Ie=/checked\s*(?:[^=]|=\s*.checked.)/i,Ne=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function $e(e,t){return E(e,"table")&&E(11!==t.nodeType?t:t.firstChild,"tr")&&C(e).children("tbody")[0]||e}function He(e){return e.type=(null!==e.getAttribute("type"))+"/"+e.type,e}function Me(e){return"true/"===(e.type||"").slice(0,5)?e.type=e.type.slice(5):e.removeAttribute("type"),e}function Le(e,t){var n,o,r,i,A,l,a,s;if(1===t.nodeType){if(X.hasData(e)&&(i=X.access(e),A=X.set(t,i),s=i.events))for(r in delete A.handle,A.events={},s)for(n=0,o=s[r].length;n<o;n++)C.event.add(t,r,s[r][n]);Q.hasData(e)&&(l=Q.access(e),a=C.extend({},l),Q.set(t,a))}}function Fe(e,t,n,o){t=A.apply([],t);var r,i,l,a,s,c,u=0,d=e.length,p=d-1,g=t[0],m=h(g);if(m||d>1&&"string"==typeof g&&!f.checkClone&&Ie.test(g))return e.each(function(r){var i=e.eq(r);m&&(t[0]=g.call(this,r,i.html())),Fe(i,t,n,o)});if(d&&(i=(r=ye(t,e[0].ownerDocument,!1,e,o)).firstChild,1===r.childNodes.length&&(r=i),i||o)){for(a=(l=C.map(ge(r,"script"),He)).length;u<d;u++)s=r,u!==p&&(s=C.clone(s,!0,!0),a&&C.merge(l,ge(s,"script"))),n.call(e[u],s,u);if(a)for(c=l[l.length-1].ownerDocument,C.map(l,Me),u=0;u<a;u++)s=l[u],fe.test(s.type||"")&&!X.access(s,"globalEval")&&C.contains(c,s)&&(s.src&&"module"!==(s.type||"").toLowerCase()?C._evalUrl&&!s.noModule&&C._evalUrl(s.src,{nonce:s.nonce||s.getAttribute("nonce")}):v(s.textContent.replace(Ne,""),s,c))}return e}function Ve(e,t,n){for(var o,r=t?C.filter(t,e):e,i=0;null!=(o=r[i]);i++)n||1!==o.nodeType||C.cleanData(ge(o)),o.parentNode&&(n&&re(o)&&me(ge(o,"script")),o.parentNode.removeChild(o));return e}C.extend({htmlPrefilter:function(e){return e.replace(De,"<$1></$2>")},clone:function(e,t,n){var o,r,i,A,l,a,s,c=e.cloneNode(!0),u=re(e);if(!(f.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||C.isXMLDoc(e)))for(A=ge(c),o=0,r=(i=ge(e)).length;o<r;o++)l=i[o],a=A[o],s=void 0,"input"===(s=a.nodeName.toLowerCase())&&de.test(l.type)?a.checked=l.checked:"input"!==s&&"textarea"!==s||(a.defaultValue=l.defaultValue);if(t)if(n)for(i=i||ge(e),A=A||ge(c),o=0,r=i.length;o<r;o++)Le(i[o],A[o]);else Le(e,c);return(A=ge(c,"script")).length>0&&me(A,!u&&ge(e,"script")),c},cleanData:function(e){for(var t,n,o,r=C.event.special,i=0;void 0!==(n=e[i]);i++)if(K(n)){if(t=n[X.expando]){if(t.events)for(o in t.events)r[o]?C.event.remove(n,o):C.removeEvent(n,o,t.handle);n[X.expando]=void 0}n[Q.expando]&&(n[Q.expando]=void 0)}}}),C.fn.extend({detach:function(e){return Ve(this,e,!0)},remove:function(e){return Ve(this,e)},text:function(e){return j(this,function(e){return void 0===e?C.text(this):this.empty().each(function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=e)})},null,e,arguments.length)},append:function(){return Fe(this,arguments,function(e){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||$e(this,e).appendChild(e)})},prepend:function(){return Fe(this,arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=$e(this,e);t.insertBefore(e,t.firstChild)}})},before:function(){return Fe(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return Fe(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},empty:function(){for(var e,t=0;null!=(e=this[t]);t++)1===e.nodeType&&(C.cleanData(ge(e,!1)),e.textContent="");return this},clone:function(e,t){return e=null!=e&&e,t=null==t?e:t,this.map(function(){return C.clone(this,e,t)})},html:function(e){return j(this,function(e){var t=this[0]||{},n=0,o=this.length;if(void 0===e&&1===t.nodeType)return t.innerHTML;if("string"==typeof e&&!Pe.test(e)&&!he[(pe.exec(e)||["",""])[1].toLowerCase()]){e=C.htmlPrefilter(e);try{for(;n<o;n++)1===(t=this[n]||{}).nodeType&&(C.cleanData(ge(t,!1)),t.innerHTML=e);t=0}catch(e){}}t&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(){var e=[];return Fe(this,arguments,function(t){var n=this.parentNode;C.inArray(this,e)<0&&(C.cleanData(ge(this)),n&&n.replaceChild(t,this))},e)}}),C.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(e,t){C.fn[e]=function(e){for(var n,o=[],r=C(e),i=r.length-1,A=0;A<=i;A++)n=A===i?this:this.clone(!0),C(r[A])[t](n),l.apply(o,n.get());return this.pushStack(o)}});var We=new RegExp("^("+ee+")(?!px)[a-z%]+$","i"),Be=function(t){var n=t.ownerDocument.defaultView;return n&&n.opener||(n=e),n.getComputedStyle(t)},je=new RegExp(ne.join("|"),"i");function Oe(e,t,n){var o,r,i,A,l=e.style;return(n=n||Be(e))&&(""!==(A=n.getPropertyValue(t)||n[t])||re(e)||(A=C.style(e,t)),!f.pixelBoxStyles()&&We.test(A)&&je.test(t)&&(o=l.width,r=l.minWidth,i=l.maxWidth,l.minWidth=l.maxWidth=l.width=A,A=n.width,l.width=o,l.minWidth=r,l.maxWidth=i)),void 0!==A?A+"":A}function ze(e,t){return{get:function(){if(!e())return(this.get=t).apply(this,arguments);delete this.get}}}!function(){function t(){if(c){s.style.cssText="position:absolute;left:-11111px;width:60px;margin-top:1px;padding:0;border:0",c.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;margin:auto;border:1px;padding:1px;width:60%;top:1%",oe.appendChild(s).appendChild(c);var t=e.getComputedStyle(c);r="1%"!==t.top,a=12===n(t.marginLeft),c.style.right="60%",l=36===n(t.right),i=36===n(t.width),c.style.position="absolute",A=12===n(c.offsetWidth/3),oe.removeChild(s),c=null}}function n(e){return Math.round(parseFloat(e))}var r,i,A,l,a,s=o.createElement("div"),c=o.createElement("div");c.style&&(c.style.backgroundClip="content-box",c.cloneNode(!0).style.backgroundClip="",f.clearCloneStyle="content-box"===c.style.backgroundClip,C.extend(f,{boxSizingReliable:function(){return t(),i},pixelBoxStyles:function(){return t(),l},pixelPosition:function(){return t(),r},reliableMarginLeft:function(){return t(),a},scrollboxSize:function(){return t(),A}}))}();var qe=["Webkit","Moz","ms"],Ge=o.createElement("div").style,Ke={};function Ue(e){var t=C.cssProps[e]||Ke[e];return t||(e in Ge?e:Ke[e]=function(e){for(var t=e[0].toUpperCase()+e.slice(1),n=qe.length;n--;)if((e=qe[n]+t)in Ge)return e}(e)||e)}var Xe=/^(none|table(?!-c[ea]).+)/,Qe=/^--/,Ye={position:"absolute",visibility:"hidden",display:"block"},Je={letterSpacing:"0",fontWeight:"400"};function Ze(e,t,n){var o=te.exec(t);return o?Math.max(0,o[2]-(n||0))+(o[3]||"px"):t}function et(e,t,n,o,r,i){var A="width"===t?1:0,l=0,a=0;if(n===(o?"border":"content"))return 0;for(;A<4;A+=2)"margin"===n&&(a+=C.css(e,n+ne[A],!0,r)),o?("content"===n&&(a-=C.css(e,"padding"+ne[A],!0,r)),"margin"!==n&&(a-=C.css(e,"border"+ne[A]+"Width",!0,r))):(a+=C.css(e,"padding"+ne[A],!0,r),"padding"!==n?a+=C.css(e,"border"+ne[A]+"Width",!0,r):l+=C.css(e,"border"+ne[A]+"Width",!0,r));return!o&&i>=0&&(a+=Math.max(0,Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-i-a-l-.5))||0),a}function tt(e,t,n){var o=Be(e),r=(!f.boxSizingReliable()||n)&&"border-box"===C.css(e,"boxSizing",!1,o),i=r,A=Oe(e,t,o),l="offset"+t[0].toUpperCase()+t.slice(1);if(We.test(A)){if(!n)return A;A="auto"}return(!f.boxSizingReliable()&&r||"auto"===A||!parseFloat(A)&&"inline"===C.css(e,"display",!1,o))&&e.getClientRects().length&&(r="border-box"===C.css(e,"boxSizing",!1,o),(i=l in e)&&(A=e[l])),(A=parseFloat(A)||0)+et(e,t,n||(r?"border":"content"),i,o,A)+"px"}function nt(e,t,n,o,r){return new nt.prototype.init(e,t,n,o,r)}C.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=Oe(e,"opacity");return""===n?"1":n}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,gridArea:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnStart:!0,gridRow:!0,gridRowEnd:!0,gridRowStart:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{},style:function(e,t,n,o){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var r,i,A,l=G(t),a=Qe.test(t),s=e.style;if(a||(t=Ue(l)),A=C.cssHooks[t]||C.cssHooks[l],void 0===n)return A&&"get"in A&&void 0!==(r=A.get(e,!1,o))?r:s[t];"string"===(i=typeof n)&&(r=te.exec(n))&&r[1]&&(n=ae(e,t,r),i="number"),null!=n&&n==n&&("number"!==i||a||(n+=r&&r[3]||(C.cssNumber[l]?"":"px")),f.clearCloneStyle||""!==n||0!==t.indexOf("background")||(s[t]="inherit"),A&&"set"in A&&void 0===(n=A.set(e,n,o))||(a?s.setProperty(t,n):s[t]=n))}},css:function(e,t,n,o){var r,i,A,l=G(t);return Qe.test(t)||(t=Ue(l)),(A=C.cssHooks[t]||C.cssHooks[l])&&"get"in A&&(r=A.get(e,!0,n)),void 0===r&&(r=Oe(e,t,o)),"normal"===r&&t in Je&&(r=Je[t]),""===n||n?(i=parseFloat(r),!0===n||isFinite(i)?i||0:r):r}}),C.each(["height","width"],function(e,t){C.cssHooks[t]={get:function(e,n,o){if(n)return!Xe.test(C.css(e,"display"))||e.getClientRects().length&&e.getBoundingClientRect().width?tt(e,t,o):le(e,Ye,function(){return tt(e,t,o)})},set:function(e,n,o){var r,i=Be(e),A=!f.scrollboxSize()&&"absolute"===i.position,l=(A||o)&&"border-box"===C.css(e,"boxSizing",!1,i),a=o?et(e,t,o,l,i):0;return l&&A&&(a-=Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-parseFloat(i[t])-et(e,t,"border",!1,i)-.5)),a&&(r=te.exec(n))&&"px"!==(r[3]||"px")&&(e.style[t]=n,n=C.css(e,t)),Ze(0,n,a)}}}),C.cssHooks.marginLeft=ze(f.reliableMarginLeft,function(e,t){if(t)return(parseFloat(Oe(e,"marginLeft"))||e.getBoundingClientRect().left-le(e,{marginLeft:0},function(){return e.getBoundingClientRect().left}))+"px"}),C.each({margin:"",padding:"",border:"Width"},function(e,t){C.cssHooks[e+t]={expand:function(n){for(var o=0,r={},i="string"==typeof n?n.split(" "):[n];o<4;o++)r[e+ne[o]+t]=i[o]||i[o-2]||i[0];return r}},"margin"!==e&&(C.cssHooks[e+t].set=Ze)}),C.fn.extend({css:function(e,t){return j(this,function(e,t,n){var o,r,i={},A=0;if(Array.isArray(t)){for(o=Be(e),r=t.length;A<r;A++)i[t[A]]=C.css(e,t[A],!1,o);return i}return void 0!==n?C.style(e,t,n):C.css(e,t)},e,t,arguments.length>1)}}),C.Tween=nt,nt.prototype={constructor:nt,init:function(e,t,n,o,r,i){this.elem=e,this.prop=n,this.easing=r||C.easing._default,this.options=t,this.start=this.now=this.cur(),this.end=o,this.unit=i||(C.cssNumber[n]?"":"px")},cur:function(){var e=nt.propHooks[this.prop];return e&&e.get?e.get(this):nt.propHooks._default.get(this)},run:function(e){var t,n=nt.propHooks[this.prop];return this.options.duration?this.pos=t=C.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):this.pos=t=e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):nt.propHooks._default.set(this),this}},nt.prototype.init.prototype=nt.prototype,nt.propHooks={_default:{get:function(e){var t;return 1!==e.elem.nodeType||null!=e.elem[e.prop]&&null==e.elem.style[e.prop]?e.elem[e.prop]:(t=C.css(e.elem,e.prop,""))&&"auto"!==t?t:0},set:function(e){C.fx.step[e.prop]?C.fx.step[e.prop](e):1!==e.elem.nodeType||!C.cssHooks[e.prop]&&null==e.elem.style[Ue(e.prop)]?e.elem[e.prop]=e.now:C.style(e.elem,e.prop,e.now+e.unit)}}},nt.propHooks.scrollTop=nt.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},C.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2},_default:"swing"},C.fx=nt.prototype.init,C.fx.step={};var ot,rt,it=/^(?:toggle|show|hide)$/,At=/queueHooks$/;function lt(){rt&&(!1===o.hidden&&e.requestAnimationFrame?e.requestAnimationFrame(lt):e.setTimeout(lt,C.fx.interval),C.fx.tick())}function at(){return e.setTimeout(function(){ot=void 0}),ot=Date.now()}function st(e,t){var n,o=0,r={height:e};for(t=t?1:0;o<4;o+=2-t)r["margin"+(n=ne[o])]=r["padding"+n]=e;return t&&(r.opacity=r.width=e),r}function ct(e,t,n){for(var o,r=(ut.tweeners[t]||[]).concat(ut.tweeners["*"]),i=0,A=r.length;i<A;i++)if(o=r[i].call(n,t,e))return o}function ut(e,t,n){var o,r,i=0,A=ut.prefilters.length,l=C.Deferred().always(function(){delete a.elem}),a=function(){if(r)return!1;for(var t=ot||at(),n=Math.max(0,s.startTime+s.duration-t),o=1-(n/s.duration||0),i=0,A=s.tweens.length;i<A;i++)s.tweens[i].run(o);return l.notifyWith(e,[s,o,n]),o<1&&A?n:(A||l.notifyWith(e,[s,1,0]),l.resolveWith(e,[s]),!1)},s=l.promise({elem:e,props:C.extend({},t),opts:C.extend(!0,{specialEasing:{},easing:C.easing._default},n),originalProperties:t,originalOptions:n,startTime:ot||at(),duration:n.duration,tweens:[],createTween:function(t,n){var o=C.Tween(e,s.opts,t,n,s.opts.specialEasing[t]||s.opts.easing);return s.tweens.push(o),o},stop:function(t){var n=0,o=t?s.tweens.length:0;if(r)return this;for(r=!0;n<o;n++)s.tweens[n].run(1);return t?(l.notifyWith(e,[s,1,0]),l.resolveWith(e,[s,t])):l.rejectWith(e,[s,t]),this}}),c=s.props;for(!function(e,t){var n,o,r,i,A;for(n in e)if(r=t[o=G(n)],i=e[n],Array.isArray(i)&&(r=i[1],i=e[n]=i[0]),n!==o&&(e[o]=i,delete e[n]),(A=C.cssHooks[o])&&"expand"in A)for(n in i=A.expand(i),delete e[o],i)n in e||(e[n]=i[n],t[n]=r);else t[o]=r}(c,s.opts.specialEasing);i<A;i++)if(o=ut.prefilters[i].call(s,e,c,s.opts))return h(o.stop)&&(C._queueHooks(s.elem,s.opts.queue).stop=o.stop.bind(o)),o;return C.map(c,ct,s),h(s.opts.start)&&s.opts.start.call(e,s),s.progress(s.opts.progress).done(s.opts.done,s.opts.complete).fail(s.opts.fail).always(s.opts.always),C.fx.timer(C.extend(a,{elem:e,anim:s,queue:s.opts.queue})),s}C.Animation=C.extend(ut,{tweeners:{"*":[function(e,t){var n=this.createTween(e,t);return ae(n.elem,e,te.exec(t),n),n}]},tweener:function(e,t){h(e)?(t=e,e=["*"]):e=e.match(H);for(var n,o=0,r=e.length;o<r;o++)n=e[o],ut.tweeners[n]=ut.tweeners[n]||[],ut.tweeners[n].unshift(t)},prefilters:[function(e,t,n){var o,r,i,A,l,a,s,c,u="width"in t||"height"in t,d=this,p={},f=e.style,h=e.nodeType&&Ae(e),g=X.get(e,"fxshow");for(o in n.queue||(null==(A=C._queueHooks(e,"fx")).unqueued&&(A.unqueued=0,l=A.empty.fire,A.empty.fire=function(){A.unqueued||l()}),A.unqueued++,d.always(function(){d.always(function(){A.unqueued--,C.queue(e,"fx").length||A.empty.fire()})})),t)if(r=t[o],it.test(r)){if(delete t[o],i=i||"toggle"===r,r===(h?"hide":"show")){if("show"!==r||!g||void 0===g[o])continue;h=!0}p[o]=g&&g[o]||C.style(e,o)}if((a=!C.isEmptyObject(t))||!C.isEmptyObject(p))for(o in u&&1===e.nodeType&&(n.overflow=[f.overflow,f.overflowX,f.overflowY],null==(s=g&&g.display)&&(s=X.get(e,"display")),"none"===(c=C.css(e,"display"))&&(s?c=s:(ue([e],!0),s=e.style.display||s,c=C.css(e,"display"),ue([e]))),("inline"===c||"inline-block"===c&&null!=s)&&"none"===C.css(e,"float")&&(a||(d.done(function(){f.display=s}),null==s&&(c=f.display,s="none"===c?"":c)),f.display="inline-block")),n.overflow&&(f.overflow="hidden",d.always(function(){f.overflow=n.overflow[0],f.overflowX=n.overflow[1],f.overflowY=n.overflow[2]})),a=!1,p)a||(g?"hidden"in g&&(h=g.hidden):g=X.access(e,"fxshow",{display:s}),i&&(g.hidden=!h),h&&ue([e],!0),d.done(function(){for(o in h||ue([e]),X.remove(e,"fxshow"),p)C.style(e,o,p[o])})),a=ct(h?g[o]:0,o,d),o in g||(g[o]=a.start,h&&(a.end=a.start,a.start=0))}],prefilter:function(e,t){t?ut.prefilters.unshift(e):ut.prefilters.push(e)}}),C.speed=function(e,t,n){var o=e&&"object"==typeof e?C.extend({},e):{complete:n||!n&&t||h(e)&&e,duration:e,easing:n&&t||t&&!h(t)&&t};return C.fx.off?o.duration=0:"number"!=typeof o.duration&&(o.duration in C.fx.speeds?o.duration=C.fx.speeds[o.duration]:o.duration=C.fx.speeds._default),null!=o.queue&&!0!==o.queue||(o.queue="fx"),o.old=o.complete,o.complete=function(){h(o.old)&&o.old.call(this),o.queue&&C.dequeue(this,o.queue)},o},C.fn.extend({fadeTo:function(e,t,n,o){return this.filter(Ae).css("opacity",0).show().end().animate({opacity:t},e,n,o)},animate:function(e,t,n,o){var r=C.isEmptyObject(e),i=C.speed(t,n,o),A=function(){var t=ut(this,C.extend({},e),i);(r||X.get(this,"finish"))&&t.stop(!0)};return A.finish=A,r||!1===i.queue?this.each(A):this.queue(i.queue,A)},stop:function(e,t,n){var o=function(e){var t=e.stop;delete e.stop,t(n)};return"string"!=typeof e&&(n=t,t=e,e=void 0),t&&!1!==e&&this.queue(e||"fx",[]),this.each(function(){var t=!0,r=null!=e&&e+"queueHooks",i=C.timers,A=X.get(this);if(r)A[r]&&A[r].stop&&o(A[r]);else for(r in A)A[r]&&A[r].stop&&At.test(r)&&o(A[r]);for(r=i.length;r--;)i[r].elem!==this||null!=e&&i[r].queue!==e||(i[r].anim.stop(n),t=!1,i.splice(r,1));!t&&n||C.dequeue(this,e)})},finish:function(e){return!1!==e&&(e=e||"fx"),this.each(function(){var t,n=X.get(this),o=n[e+"queue"],r=n[e+"queueHooks"],i=C.timers,A=o?o.length:0;for(n.finish=!0,C.queue(this,e,[]),r&&r.stop&&r.stop.call(this,!0),t=i.length;t--;)i[t].elem===this&&i[t].queue===e&&(i[t].anim.stop(!0),i.splice(t,1));for(t=0;t<A;t++)o[t]&&o[t].finish&&o[t].finish.call(this);delete n.finish})}}),C.each(["toggle","show","hide"],function(e,t){var n=C.fn[t];C.fn[t]=function(e,o,r){return null==e||"boolean"==typeof e?n.apply(this,arguments):this.animate(st(t,!0),e,o,r)}}),C.each({slideDown:st("show"),slideUp:st("hide"),slideToggle:st("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(e,t){C.fn[e]=function(e,n,o){return this.animate(t,e,n,o)}}),C.timers=[],C.fx.tick=function(){var e,t=0,n=C.timers;for(ot=Date.now();t<n.length;t++)(e=n[t])()||n[t]!==e||n.splice(t--,1);n.length||C.fx.stop(),ot=void 0},C.fx.timer=function(e){C.timers.push(e),C.fx.start()},C.fx.interval=13,C.fx.start=function(){rt||(rt=!0,lt())},C.fx.stop=function(){rt=null},C.fx.speeds={slow:600,fast:200,_default:400},C.fn.delay=function(t,n){return t=C.fx&&C.fx.speeds[t]||t,n=n||"fx",this.queue(n,function(n,o){var r=e.setTimeout(n,t);o.stop=function(){e.clearTimeout(r)}})},function(){var e=o.createElement("input"),t=o.createElement("select").appendChild(o.createElement("option"));e.type="checkbox",f.checkOn=""!==e.value,f.optSelected=t.selected,(e=o.createElement("input")).value="t",e.type="radio",f.radioValue="t"===e.value}();var dt,pt=C.expr.attrHandle;C.fn.extend({attr:function(e,t){return j(this,C.attr,e,t,arguments.length>1)},removeAttr:function(e){return this.each(function(){C.removeAttr(this,e)})}}),C.extend({attr:function(e,t,n){var o,r,i=e.nodeType;if(3!==i&&8!==i&&2!==i)return void 0===e.getAttribute?C.prop(e,t,n):(1===i&&C.isXMLDoc(e)||(r=C.attrHooks[t.toLowerCase()]||(C.expr.match.bool.test(t)?dt:void 0)),void 0!==n?null===n?void C.removeAttr(e,t):r&&"set"in r&&void 0!==(o=r.set(e,n,t))?o:(e.setAttribute(t,n+""),n):r&&"get"in r&&null!==(o=r.get(e,t))?o:null==(o=C.find.attr(e,t))?void 0:o)},attrHooks:{type:{set:function(e,t){if(!f.radioValue&&"radio"===t&&E(e,"input")){var n=e.value;return e.setAttribute("type",t),n&&(e.value=n),t}}}},removeAttr:function(e,t){var n,o=0,r=t&&t.match(H);if(r&&1===e.nodeType)for(;n=r[o++];)e.removeAttribute(n)}}),dt={set:function(e,t,n){return!1===t?C.removeAttr(e,n):e.setAttribute(n,n),n}},C.each(C.expr.match.bool.source.match(/\w+/g),function(e,t){var n=pt[t]||C.find.attr;pt[t]=function(e,t,o){var r,i,A=t.toLowerCase();return o||(i=pt[A],pt[A]=r,r=null!=n(e,t,o)?A:null,pt[A]=i),r}});var ft=/^(?:input|select|textarea|button)$/i,ht=/^(?:a|area)$/i;function gt(e){return(e.match(H)||[]).join(" ")}function mt(e){return e.getAttribute&&e.getAttribute("class")||""}function vt(e){return Array.isArray(e)?e:"string"==typeof e&&e.match(H)||[]}C.fn.extend({prop:function(e,t){return j(this,C.prop,e,t,arguments.length>1)},removeProp:function(e){return this.each(function(){delete this[C.propFix[e]||e]})}}),C.extend({prop:function(e,t,n){var o,r,i=e.nodeType;if(3!==i&&8!==i&&2!==i)return 1===i&&C.isXMLDoc(e)||(t=C.propFix[t]||t,r=C.propHooks[t]),void 0!==n?r&&"set"in r&&void 0!==(o=r.set(e,n,t))?o:e[t]=n:r&&"get"in r&&null!==(o=r.get(e,t))?o:e[t]},propHooks:{tabIndex:{get:function(e){var t=C.find.attr(e,"tabindex");return t?parseInt(t,10):ft.test(e.nodeName)||ht.test(e.nodeName)&&e.href?0:-1}}},propFix:{for:"htmlFor",class:"className"}}),f.optSelected||(C.propHooks.selected={get:function(e){var t=e.parentNode;return t&&t.parentNode&&t.parentNode.selectedIndex,null},set:function(e){var t=e.parentNode;t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex)}}),C.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){C.propFix[this.toLowerCase()]=this}),C.fn.extend({addClass:function(e){var t,n,o,r,i,A,l,a=0;if(h(e))return this.each(function(t){C(this).addClass(e.call(this,t,mt(this)))});if((t=vt(e)).length)for(;n=this[a++];)if(r=mt(n),o=1===n.nodeType&&" "+gt(r)+" "){for(A=0;i=t[A++];)o.indexOf(" "+i+" ")<0&&(o+=i+" ");r!==(l=gt(o))&&n.setAttribute("class",l)}return this},removeClass:function(e){var t,n,o,r,i,A,l,a=0;if(h(e))return this.each(function(t){C(this).removeClass(e.call(this,t,mt(this)))});if(!arguments.length)return this.attr("class","");if((t=vt(e)).length)for(;n=this[a++];)if(r=mt(n),o=1===n.nodeType&&" "+gt(r)+" "){for(A=0;i=t[A++];)for(;o.indexOf(" "+i+" ")>-1;)o=o.replace(" "+i+" "," ");r!==(l=gt(o))&&n.setAttribute("class",l)}return this},toggleClass:function(e,t){var n=typeof e,o="string"===n||Array.isArray(e);return"boolean"==typeof t&&o?t?this.addClass(e):this.removeClass(e):h(e)?this.each(function(n){C(this).toggleClass(e.call(this,n,mt(this),t),t)}):this.each(function(){var t,r,i,A;if(o)for(r=0,i=C(this),A=vt(e);t=A[r++];)i.hasClass(t)?i.removeClass(t):i.addClass(t);else void 0!==e&&"boolean"!==n||((t=mt(this))&&X.set(this,"__className__",t),this.setAttribute&&this.setAttribute("class",t||!1===e?"":X.get(this,"__className__")||""))})},hasClass:function(e){var t,n,o=0;for(t=" "+e+" ";n=this[o++];)if(1===n.nodeType&&(" "+gt(mt(n))+" ").indexOf(t)>-1)return!0;return!1}});var wt=/\r/g;C.fn.extend({val:function(e){var t,n,o,r=this[0];return arguments.length?(o=h(e),this.each(function(n){var r;1===this.nodeType&&(null==(r=o?e.call(this,n,C(this).val()):e)?r="":"number"==typeof r?r+="":Array.isArray(r)&&(r=C.map(r,function(e){return null==e?"":e+""})),(t=C.valHooks[this.type]||C.valHooks[this.nodeName.toLowerCase()])&&"set"in t&&void 0!==t.set(this,r,"value")||(this.value=r))})):r?(t=C.valHooks[r.type]||C.valHooks[r.nodeName.toLowerCase()])&&"get"in t&&void 0!==(n=t.get(r,"value"))?n:"string"==typeof(n=r.value)?n.replace(wt,""):null==n?"":n:void 0}}),C.extend({valHooks:{option:{get:function(e){var t=C.find.attr(e,"value");return null!=t?t:gt(C.text(e))}},select:{get:function(e){var t,n,o,r=e.options,i=e.selectedIndex,A="select-one"===e.type,l=A?null:[],a=A?i+1:r.length;for(o=i<0?a:A?i:0;o<a;o++)if(((n=r[o]).selected||o===i)&&!n.disabled&&(!n.parentNode.disabled||!E(n.parentNode,"optgroup"))){if(t=C(n).val(),A)return t;l.push(t)}return l},set:function(e,t){for(var n,o,r=e.options,i=C.makeArray(t),A=r.length;A--;)((o=r[A]).selected=C.inArray(C.valHooks.option.get(o),i)>-1)&&(n=!0);return n||(e.selectedIndex=-1),i}}}}),C.each(["radio","checkbox"],function(){C.valHooks[this]={set:function(e,t){if(Array.isArray(t))return e.checked=C.inArray(C(e).val(),t)>-1}},f.checkOn||(C.valHooks[this].get=function(e){return null===e.getAttribute("value")?"on":e.value})}),f.focusin="onfocusin"in e;var Ct=/^(?:focusinfocus|focusoutblur)$/,yt=function(e){e.stopPropagation()};C.extend(C.event,{trigger:function(t,n,r,i){var A,l,a,s,c,d,p,f,m=[r||o],v=u.call(t,"type")?t.type:t,w=u.call(t,"namespace")?t.namespace.split("."):[];if(l=f=a=r=r||o,3!==r.nodeType&&8!==r.nodeType&&!Ct.test(v+C.event.triggered)&&(v.indexOf(".")>-1&&(w=v.split("."),v=w.shift(),w.sort()),c=v.indexOf(":")<0&&"on"+v,(t=t[C.expando]?t:new C.Event(v,"object"==typeof t&&t)).isTrigger=i?2:3,t.namespace=w.join("."),t.rnamespace=t.namespace?new RegExp("(^|\\.)"+w.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,t.result=void 0,t.target||(t.target=r),n=null==n?[t]:C.makeArray(n,[t]),p=C.event.special[v]||{},i||!p.trigger||!1!==p.trigger.apply(r,n))){if(!i&&!p.noBubble&&!g(r)){for(s=p.delegateType||v,Ct.test(s+v)||(l=l.parentNode);l;l=l.parentNode)m.push(l),a=l;a===(r.ownerDocument||o)&&m.push(a.defaultView||a.parentWindow||e)}for(A=0;(l=m[A++])&&!t.isPropagationStopped();)f=l,t.type=A>1?s:p.bindType||v,(d=(X.get(l,"events")||{})[t.type]&&X.get(l,"handle"))&&d.apply(l,n),(d=c&&l[c])&&d.apply&&K(l)&&(t.result=d.apply(l,n),!1===t.result&&t.preventDefault());return t.type=v,i||t.isDefaultPrevented()||p._default&&!1!==p._default.apply(m.pop(),n)||!K(r)||c&&h(r[v])&&!g(r)&&((a=r[c])&&(r[c]=null),C.event.triggered=v,t.isPropagationStopped()&&f.addEventListener(v,yt),r[v](),t.isPropagationStopped()&&f.removeEventListener(v,yt),C.event.triggered=void 0,a&&(r[c]=a)),t.result}},simulate:function(e,t,n){var o=C.extend(new C.Event,n,{type:e,isSimulated:!0});C.event.trigger(o,null,t)}}),C.fn.extend({trigger:function(e,t){return this.each(function(){C.event.trigger(e,t,this)})},triggerHandler:function(e,t){var n=this[0];if(n)return C.event.trigger(e,t,n,!0)}}),f.focusin||C.each({focus:"focusin",blur:"focusout"},function(e,t){var n=function(e){C.event.simulate(t,e.target,C.event.fix(e))};C.event.special[t]={setup:function(){var o=this.ownerDocument||this,r=X.access(o,t);r||o.addEventListener(e,n,!0),X.access(o,t,(r||0)+1)},teardown:function(){var o=this.ownerDocument||this,r=X.access(o,t)-1;r?X.access(o,t,r):(o.removeEventListener(e,n,!0),X.remove(o,t))}}});var bt=e.location,xt=Date.now(),kt=/\?/;C.parseXML=function(t){var n;if(!t||"string"!=typeof t)return null;try{n=(new e.DOMParser).parseFromString(t,"text/xml")}catch(e){n=void 0}return n&&!n.getElementsByTagName("parsererror").length||C.error("Invalid XML: "+t),n};var Rt=/\[\]$/,St=/\r?\n/g,Et=/^(?:submit|button|image|reset|file)$/i,_t=/^(?:input|select|textarea|keygen)/i;function Tt(e,t,n,o){var r;if(Array.isArray(t))C.each(t,function(t,r){n||Rt.test(e)?o(e,r):Tt(e+"["+("object"==typeof r&&null!=r?t:"")+"]",r,n,o)});else if(n||"object"!==w(t))o(e,t);else for(r in t)Tt(e+"["+r+"]",t[r],n,o)}C.param=function(e,t){var n,o=[],r=function(e,t){var n=h(t)?t():t;o[o.length]=encodeURIComponent(e)+"="+encodeURIComponent(null==n?"":n)};if(null==e)return"";if(Array.isArray(e)||e.jquery&&!C.isPlainObject(e))C.each(e,function(){r(this.name,this.value)});else for(n in e)Tt(n,e[n],t,r);return o.join("&")},C.fn.extend({serialize:function(){return C.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=C.prop(this,"elements");return e?C.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!C(this).is(":disabled")&&_t.test(this.nodeName)&&!Et.test(e)&&(this.checked||!de.test(e))}).map(function(e,t){var n=C(this).val();return null==n?null:Array.isArray(n)?C.map(n,function(e){return{name:t.name,value:e.replace(St,"\r\n")}}):{name:t.name,value:n.replace(St,"\r\n")}}).get()}});var Dt=/%20/g,Pt=/#.*$/,It=/([?&])_=[^&]*/,Nt=/^(.*?):[ \t]*([^\r\n]*)$/gm,$t=/^(?:GET|HEAD)$/,Ht=/^\/\//,Mt={},Lt={},Ft="*/".concat("*"),Vt=o.createElement("a");function Wt(e){return function(t,n){"string"!=typeof t&&(n=t,t="*");var o,r=0,i=t.toLowerCase().match(H)||[];if(h(n))for(;o=i[r++];)"+"===o[0]?(o=o.slice(1)||"*",(e[o]=e[o]||[]).unshift(n)):(e[o]=e[o]||[]).push(n)}}function Bt(e,t,n,o){var r={},i=e===Lt;function A(l){var a;return r[l]=!0,C.each(e[l]||[],function(e,l){var s=l(t,n,o);return"string"!=typeof s||i||r[s]?i?!(a=s):void 0:(t.dataTypes.unshift(s),A(s),!1)}),a}return A(t.dataTypes[0])||!r["*"]&&A("*")}function jt(e,t){var n,o,r=C.ajaxSettings.flatOptions||{};for(n in t)void 0!==t[n]&&((r[n]?e:o||(o={}))[n]=t[n]);return o&&C.extend(!0,e,o),e}Vt.href=bt.href,C.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:bt.href,type:"GET",isLocal:/^(?:about|app|app-storage|.+-extension|file|res|widget):$/.test(bt.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":Ft,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":C.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?jt(jt(e,C.ajaxSettings),t):jt(C.ajaxSettings,e)},ajaxPrefilter:Wt(Mt),ajaxTransport:Wt(Lt),ajax:function(t,n){"object"==typeof t&&(n=t,t=void 0),n=n||{};var r,i,A,l,a,s,c,u,d,p,f=C.ajaxSetup({},n),h=f.context||f,g=f.context&&(h.nodeType||h.jquery)?C(h):C.event,m=C.Deferred(),v=C.Callbacks("once memory"),w=f.statusCode||{},y={},b={},x="canceled",k={readyState:0,getResponseHeader:function(e){var t;if(c){if(!l)for(l={};t=Nt.exec(A);)l[t[1].toLowerCase()+" "]=(l[t[1].toLowerCase()+" "]||[]).concat(t[2]);t=l[e.toLowerCase()+" "]}return null==t?null:t.join(", ")},getAllResponseHeaders:function(){return c?A:null},setRequestHeader:function(e,t){return null==c&&(e=b[e.toLowerCase()]=b[e.toLowerCase()]||e,y[e]=t),this},overrideMimeType:function(e){return null==c&&(f.mimeType=e),this},statusCode:function(e){var t;if(e)if(c)k.always(e[k.status]);else for(t in e)w[t]=[w[t],e[t]];return this},abort:function(e){var t=e||x;return r&&r.abort(t),R(0,t),this}};if(m.promise(k),f.url=((t||f.url||bt.href)+"").replace(Ht,bt.protocol+"//"),f.type=n.method||n.type||f.method||f.type,f.dataTypes=(f.dataType||"*").toLowerCase().match(H)||[""],null==f.crossDomain){s=o.createElement("a");try{s.href=f.url,s.href=s.href,f.crossDomain=Vt.protocol+"//"+Vt.host!=s.protocol+"//"+s.host}catch(e){f.crossDomain=!0}}if(f.data&&f.processData&&"string"!=typeof f.data&&(f.data=C.param(f.data,f.traditional)),Bt(Mt,f,n,k),c)return k;for(d in(u=C.event&&f.global)&&0==C.active++&&C.event.trigger("ajaxStart"),f.type=f.type.toUpperCase(),f.hasContent=!$t.test(f.type),i=f.url.replace(Pt,""),f.hasContent?f.data&&f.processData&&0===(f.contentType||"").indexOf("application/x-www-form-urlencoded")&&(f.data=f.data.replace(Dt,"+")):(p=f.url.slice(i.length),f.data&&(f.processData||"string"==typeof f.data)&&(i+=(kt.test(i)?"&":"?")+f.data,delete f.data),!1===f.cache&&(i=i.replace(It,"$1"),p=(kt.test(i)?"&":"?")+"_="+xt+++p),f.url=i+p),f.ifModified&&(C.lastModified[i]&&k.setRequestHeader("If-Modified-Since",C.lastModified[i]),C.etag[i]&&k.setRequestHeader("If-None-Match",C.etag[i])),(f.data&&f.hasContent&&!1!==f.contentType||n.contentType)&&k.setRequestHeader("Content-Type",f.contentType),k.setRequestHeader("Accept",f.dataTypes[0]&&f.accepts[f.dataTypes[0]]?f.accepts[f.dataTypes[0]]+("*"!==f.dataTypes[0]?", "+Ft+"; q=0.01":""):f.accepts["*"]),f.headers)k.setRequestHeader(d,f.headers[d]);if(f.beforeSend&&(!1===f.beforeSend.call(h,k,f)||c))return k.abort();if(x="abort",v.add(f.complete),k.done(f.success),k.fail(f.error),r=Bt(Lt,f,n,k)){if(k.readyState=1,u&&g.trigger("ajaxSend",[k,f]),c)return k;f.async&&f.timeout>0&&(a=e.setTimeout(function(){k.abort("timeout")},f.timeout));try{c=!1,r.send(y,R)}catch(e){if(c)throw e;R(-1,e)}}else R(-1,"No Transport");function R(t,n,o,l){var s,d,p,y,b,x=n;c||(c=!0,a&&e.clearTimeout(a),r=void 0,A=l||"",k.readyState=t>0?4:0,s=t>=200&&t<300||304===t,o&&(y=function(e,t,n){for(var o,r,i,A,l=e.contents,a=e.dataTypes;"*"===a[0];)a.shift(),void 0===o&&(o=e.mimeType||t.getResponseHeader("Content-Type"));if(o)for(r in l)if(l[r]&&l[r].test(o)){a.unshift(r);break}if(a[0]in n)i=a[0];else{for(r in n){if(!a[0]||e.converters[r+" "+a[0]]){i=r;break}A||(A=r)}i=i||A}if(i)return i!==a[0]&&a.unshift(i),n[i]}(f,k,o)),y=function(e,t,n,o){var r,i,A,l,a,s={},c=e.dataTypes.slice();if(c[1])for(A in e.converters)s[A.toLowerCase()]=e.converters[A];for(i=c.shift();i;)if(e.responseFields[i]&&(n[e.responseFields[i]]=t),!a&&o&&e.dataFilter&&(t=e.dataFilter(t,e.dataType)),a=i,i=c.shift())if("*"===i)i=a;else if("*"!==a&&a!==i){if(!(A=s[a+" "+i]||s["* "+i]))for(r in s)if((l=r.split(" "))[1]===i&&(A=s[a+" "+l[0]]||s["* "+l[0]])){!0===A?A=s[r]:!0!==s[r]&&(i=l[0],c.unshift(l[1]));break}if(!0!==A)if(A&&e.throws)t=A(t);else try{t=A(t)}catch(e){return{state:"parsererror",error:A?e:"No conversion from "+a+" to "+i}}}return{state:"success",data:t}}(f,y,k,s),s?(f.ifModified&&((b=k.getResponseHeader("Last-Modified"))&&(C.lastModified[i]=b),(b=k.getResponseHeader("etag"))&&(C.etag[i]=b)),204===t||"HEAD"===f.type?x="nocontent":304===t?x="notmodified":(x=y.state,d=y.data,s=!(p=y.error))):(p=x,!t&&x||(x="error",t<0&&(t=0))),k.status=t,k.statusText=(n||x)+"",s?m.resolveWith(h,[d,x,k]):m.rejectWith(h,[k,x,p]),k.statusCode(w),w=void 0,u&&g.trigger(s?"ajaxSuccess":"ajaxError",[k,f,s?d:p]),v.fireWith(h,[k,x]),u&&(g.trigger("ajaxComplete",[k,f]),--C.active||C.event.trigger("ajaxStop")))}return k},getJSON:function(e,t,n){return C.get(e,t,n,"json")},getScript:function(e,t){return C.get(e,void 0,t,"script")}}),C.each(["get","post"],function(e,t){C[t]=function(e,n,o,r){return h(n)&&(r=r||o,o=n,n=void 0),C.ajax(C.extend({url:e,type:t,dataType:r,data:n,success:o},C.isPlainObject(e)&&e))}}),C._evalUrl=function(e,t){return C.ajax({url:e,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,converters:{"text script":function(){}},dataFilter:function(e){C.globalEval(e,t)}})},C.fn.extend({wrapAll:function(e){var t;return this[0]&&(h(e)&&(e=e.call(this[0])),t=C(e,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){for(var e=this;e.firstElementChild;)e=e.firstElementChild;return e}).append(this)),this},wrapInner:function(e){return h(e)?this.each(function(t){C(this).wrapInner(e.call(this,t))}):this.each(function(){var t=C(this),n=t.contents();n.length?n.wrapAll(e):t.append(e)})},wrap:function(e){var t=h(e);return this.each(function(n){C(this).wrapAll(t?e.call(this,n):e)})},unwrap:function(e){return this.parent(e).not("body").each(function(){C(this).replaceWith(this.childNodes)}),this}}),C.expr.pseudos.hidden=function(e){return!C.expr.pseudos.visible(e)},C.expr.pseudos.visible=function(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)},C.ajaxSettings.xhr=function(){try{return new e.XMLHttpRequest}catch(e){}};var Ot={0:200,1223:204},zt=C.ajaxSettings.xhr();f.cors=!!zt&&"withCredentials"in zt,f.ajax=zt=!!zt,C.ajaxTransport(function(t){var n,o;if(f.cors||zt&&!t.crossDomain)return{send:function(r,i){var A,l=t.xhr();if(l.open(t.type,t.url,t.async,t.username,t.password),t.xhrFields)for(A in t.xhrFields)l[A]=t.xhrFields[A];for(A in t.mimeType&&l.overrideMimeType&&l.overrideMimeType(t.mimeType),t.crossDomain||r["X-Requested-With"]||(r["X-Requested-With"]="XMLHttpRequest"),r)l.setRequestHeader(A,r[A]);n=function(e){return function(){n&&(n=o=l.onload=l.onerror=l.onabort=l.ontimeout=l.onreadystatechange=null,"abort"===e?l.abort():"error"===e?"number"!=typeof l.status?i(0,"error"):i(l.status,l.statusText):i(Ot[l.status]||l.status,l.statusText,"text"!==(l.responseType||"text")||"string"!=typeof l.responseText?{binary:l.response}:{text:l.responseText},l.getAllResponseHeaders()))}},l.onload=n(),o=l.onerror=l.ontimeout=n("error"),void 0!==l.onabort?l.onabort=o:l.onreadystatechange=function(){4===l.readyState&&e.setTimeout(function(){n&&o()})},n=n("abort");try{l.send(t.hasContent&&t.data||null)}catch(e){if(n)throw e}},abort:function(){n&&n()}}}),C.ajaxPrefilter(function(e){e.crossDomain&&(e.contents.script=!1)}),C.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(e){return C.globalEval(e),e}}}),C.ajaxPrefilter("script",function(e){void 0===e.cache&&(e.cache=!1),e.crossDomain&&(e.type="GET")}),C.ajaxTransport("script",function(e){var t,n;if(e.crossDomain||e.scriptAttrs)return{send:function(r,i){t=C("<script>").attr(e.scriptAttrs||{}).prop({charset:e.scriptCharset,src:e.url}).on("load error",n=function(e){t.remove(),n=null,e&&i("error"===e.type?404:200,e.type)}),o.head.appendChild(t[0])},abort:function(){n&&n()}}});var qt,Gt=[],Kt=/(=)\?(?=&|$)|\?\?/;C.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=Gt.pop()||C.expando+"_"+xt++;return this[e]=!0,e}}),C.ajaxPrefilter("json jsonp",function(t,n,o){var r,i,A,l=!1!==t.jsonp&&(Kt.test(t.url)?"url":"string"==typeof t.data&&0===(t.contentType||"").indexOf("application/x-www-form-urlencoded")&&Kt.test(t.data)&&"data");if(l||"jsonp"===t.dataTypes[0])return r=t.jsonpCallback=h(t.jsonpCallback)?t.jsonpCallback():t.jsonpCallback,l?t[l]=t[l].replace(Kt,"$1"+r):!1!==t.jsonp&&(t.url+=(kt.test(t.url)?"&":"?")+t.jsonp+"="+r),t.converters["script json"]=function(){return A||C.error(r+" was not called"),A[0]},t.dataTypes[0]="json",i=e[r],e[r]=function(){A=arguments},o.always(function(){void 0===i?C(e).removeProp(r):e[r]=i,t[r]&&(t.jsonpCallback=n.jsonpCallback,Gt.push(r)),A&&h(i)&&i(A[0]),A=i=void 0}),"script"}),f.createHTMLDocument=((qt=o.implementation.createHTMLDocument("").body).innerHTML="<form></form><form></form>",2===qt.childNodes.length),C.parseHTML=function(e,t,n){return"string"!=typeof e?[]:("boolean"==typeof t&&(n=t,t=!1),t||(f.createHTMLDocument?((r=(t=o.implementation.createHTMLDocument("")).createElement("base")).href=o.location.href,t.head.appendChild(r)):t=o),A=!n&&[],(i=_.exec(e))?[t.createElement(i[1])]:(i=ye([e],t,A),A&&A.length&&C(A).remove(),C.merge([],i.childNodes)));var r,i,A},C.fn.load=function(e,t,n){var o,r,i,A=this,l=e.indexOf(" ");return l>-1&&(o=gt(e.slice(l)),e=e.slice(0,l)),h(t)?(n=t,t=void 0):t&&"object"==typeof t&&(r="POST"),A.length>0&&C.ajax({url:e,type:r||"GET",dataType:"html",data:t}).done(function(e){i=arguments,A.html(o?C("<div>").append(C.parseHTML(e)).find(o):e)}).always(n&&function(e,t){A.each(function(){n.apply(this,i||[e.responseText,t,e])})}),this},C.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(e,t){C.fn[t]=function(e){return this.on(t,e)}}),C.expr.pseudos.animated=function(e){return C.grep(C.timers,function(t){return e===t.elem}).length},C.offset={setOffset:function(e,t,n){var o,r,i,A,l,a,s=C.css(e,"position"),c=C(e),u={};"static"===s&&(e.style.position="relative"),l=c.offset(),i=C.css(e,"top"),a=C.css(e,"left"),("absolute"===s||"fixed"===s)&&(i+a).indexOf("auto")>-1?(A=(o=c.position()).top,r=o.left):(A=parseFloat(i)||0,r=parseFloat(a)||0),h(t)&&(t=t.call(e,n,C.extend({},l))),null!=t.top&&(u.top=t.top-l.top+A),null!=t.left&&(u.left=t.left-l.left+r),"using"in t?t.using.call(e,u):c.css(u)}},C.fn.extend({offset:function(e){if(arguments.length)return void 0===e?this:this.each(function(t){C.offset.setOffset(this,e,t)});var t,n,o=this[0];return o?o.getClientRects().length?(t=o.getBoundingClientRect(),n=o.ownerDocument.defaultView,{top:t.top+n.pageYOffset,left:t.left+n.pageXOffset}):{top:0,left:0}:void 0},position:function(){if(this[0]){var e,t,n,o=this[0],r={top:0,left:0};if("fixed"===C.css(o,"position"))t=o.getBoundingClientRect();else{for(t=this.offset(),n=o.ownerDocument,e=o.offsetParent||n.documentElement;e&&(e===n.body||e===n.documentElement)&&"static"===C.css(e,"position");)e=e.parentNode;e&&e!==o&&1===e.nodeType&&((r=C(e).offset()).top+=C.css(e,"borderTopWidth",!0),r.left+=C.css(e,"borderLeftWidth",!0))}return{top:t.top-r.top-C.css(o,"marginTop",!0),left:t.left-r.left-C.css(o,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){for(var e=this.offsetParent;e&&"static"===C.css(e,"position");)e=e.offsetParent;return e||oe})}}),C.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(e,t){var n="pageYOffset"===t;C.fn[e]=function(o){return j(this,function(e,o,r){var i;if(g(e)?i=e:9===e.nodeType&&(i=e.defaultView),void 0===r)return i?i[t]:e[o];i?i.scrollTo(n?i.pageXOffset:r,n?r:i.pageYOffset):e[o]=r},e,o,arguments.length)}}),C.each(["top","left"],function(e,t){C.cssHooks[t]=ze(f.pixelPosition,function(e,n){if(n)return n=Oe(e,t),We.test(n)?C(e).position()[t]+"px":n})}),C.each({Height:"height",Width:"width"},function(e,t){C.each({padding:"inner"+e,content:t,"":"outer"+e},function(n,o){C.fn[o]=function(r,i){var A=arguments.length&&(n||"boolean"!=typeof r),l=n||(!0===r||!0===i?"margin":"border");return j(this,function(t,n,r){var i;return g(t)?0===o.indexOf("outer")?t["inner"+e]:t.document.documentElement["client"+e]:9===t.nodeType?(i=t.documentElement,Math.max(t.body["scroll"+e],i["scroll"+e],t.body["offset"+e],i["offset"+e],i["client"+e])):void 0===r?C.css(t,n,l):C.style(t,n,r,l)},t,A?r:void 0,A)}})}),C.each("blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),function(e,t){C.fn[t]=function(e,n){return arguments.length>0?this.on(t,null,e,n):this.trigger(t)}}),C.fn.extend({hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)}}),C.fn.extend({bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,o){return this.on(t,e,n,o)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,"**"):this.off(t,e||"**",n)}}),C.proxy=function(e,t){var n,o,r;if("string"==typeof t&&(n=e[t],t=e,e=n),h(e))return o=i.call(arguments,2),(r=function(){return e.apply(t||this,o.concat(i.call(arguments)))}).guid=e.guid=e.guid||C.guid++,r},C.holdReady=function(e){e?C.readyWait++:C.ready(!0)},C.isArray=Array.isArray,C.parseJSON=JSON.parse,C.nodeName=E,C.isFunction=h,C.isWindow=g,C.camelCase=G,C.type=w,C.now=Date.now,C.isNumeric=function(e){var t=C.type(e);return("number"===t||"string"===t)&&!isNaN(e-parseFloat(e))},"function"==typeof define&&define.amd&&define("jquery",[],function(){return C});var Ut=e.jQuery,Xt=e.$;return C.noConflict=function(t){return e.$===C&&(e.$=Xt),t&&e.jQuery===C&&(e.jQuery=Ut),C},t||(e.jQuery=e.$=C),C})},491:function(e,t,n){var o=e(426);o.__exportStar(e(497),t.exports),o.__exportStar(e(501),t.exports),o.__exportStar(e(498),t.exports),o.__exportStar(e(499),t.exports),o.__exportStar(e(500),t.exports),o.__exportStar(e(504),t.exports),o.__exportStar(e(502),t.exports)},492:function(e,t,n){
/*!
     * jquery.event.drag - v 2.3.0
     * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
     * Open Source MIT License - http://threedubmedia.com/code/license
     */
var o=e(503);o.fn.drag=function(e,t,n){var r="string"==typeof e?e:"",i=o.isFunction(e)?e:o.isFunction(t)?t:null;return 0!==r.indexOf("drag")&&(r="drag"+r),n=(e==i?t:n)||{},i?this.on(r,n,i):this.trigger(r)};var r=o.event,i=r.special,A=i.drag={defaults:{which:1,distance:0,not:":input",handle:null,relative:!1,drop:!0,click:!1},datakey:"dragdata",noBubble:!0,add:function(e){var t=o.data(this,A.datakey),n=e.data||{};t.related+=1,o.each(A.defaults,function(e,o){void 0!==n[e]&&(t[e]=n[e])})},remove:function(){o.data(this,A.datakey).related-=1},setup:function(){if(!o.data(this,A.datakey)){var e=o.extend({related:0},A.defaults);o.data(this,A.datakey,e),r.add(this,"touchstart mousedown",A.init,e),this.attachEvent&&this.attachEvent("ondragstart",A.dontstart)}},teardown:function(){(o.data(this,A.datakey)||{}).related||(o.removeData(this,A.datakey),r.remove(this,"touchstart mousedown",A.init),A.textselect(!0),this.detachEvent&&this.detachEvent("ondragstart",A.dontstart))},init:function(e){if(!A.touched){var t,n=e.data;if(!(0!=e.which&&n.which>0&&e.which!=n.which)&&!o(e.target).is(n.not)&&(!n.handle||o(e.target).closest(n.handle,e.currentTarget).length)&&(A.touched="touchstart"==e.type?this:null,n.propagates=1,n.mousedown=this,n.interactions=[A.interaction(this,n)],n.target=e.target,n.pageX=e.pageX,n.pageY=e.pageY,n.dragging=null,t=A.hijack(e,"draginit",n),n.propagates))return(t=A.flatten(t))&&t.length&&(n.interactions=[],o.each(t,function(){n.interactions.push(A.interaction(this,n))})),n.propagates=n.interactions.length,!1!==n.drop&&i.drop&&i.drop.handler(e,n),A.textselect(!1),A.touched?r.add(A.touched,"touchmove touchend",A.handler,n):r.add(document,"mousemove mouseup",A.handler,n),!(!A.touched||n.live)&&void 0}},interaction:function(e,t){var n=e&&e.ownerDocument&&o(e)[t.relative?"position":"offset"]()||{top:0,left:0};return{drag:e,callback:new A.callback,droppable:[],offset:n}},handler:function(e){var t=e.data;switch(e.type){case!t.dragging&&"touchmove":e.preventDefault();case!t.dragging&&"mousemove":if(Math.pow(e.pageX-t.pageX,2)+Math.pow(e.pageY-t.pageY,2)<Math.pow(t.distance,2))break;e.target=t.target,A.hijack(e,"dragstart",t),t.propagates&&(t.dragging=!0);case"touchmove":e.preventDefault();case"mousemove":if(t.dragging){if(A.hijack(e,"drag",t),t.propagates){!1!==t.drop&&i.drop&&i.drop.handler(e,t);break}e.type="mouseup"}case"touchend":case"mouseup":default:A.touched?r.remove(A.touched,"touchmove touchend",A.handler):r.remove(document,"mousemove mouseup",A.handler),t.dragging&&(!1!==t.drop&&i.drop&&i.drop.handler(e,t),A.hijack(e,"dragend",t)),A.textselect(!0),!1===t.click&&t.dragging&&o.data(t.mousedown,"suppress.click",(new Date).getTime()+5),t.dragging=A.touched=!1}},hijack:function(e,t,n,i,l){if(n){var a,s,c,u={event:e.originalEvent,type:e.type},d=t.indexOf("drop")?"drag":"drop",p=i||0,f=isNaN(i)?n.interactions.length:i;e.type=t;var h=function(){};e.originalEvent=new o.Event(u.event,{preventDefault:h,stopPropagation:h,stopImmediatePropagation:h}),n.results=[];do{if(s=n.interactions[p]){if("dragend"!==t&&s.cancelled)continue;c=A.properties(e,n,s),s.results=[],o(l||s[d]||n.droppable).each(function(i,l){if(c.target=l,e.isPropagationStopped=function(){return!1},!1===(a=l?r.dispatch.call(l,e,c):null)?("drag"==d&&(s.cancelled=!0,n.propagates-=1),"drop"==t&&(s[d][i]=null)):"dropinit"==t&&s.droppable.push(A.element(a)||l),"dragstart"==t&&(s.proxy=o(A.element(a)||s.drag)[0]),s.results.push(a),delete e.result,"dropinit"!==t)return a}),n.results[p]=A.flatten(s.results),"dropinit"==t&&(s.droppable=A.flatten(s.droppable)),"dragstart"!=t||s.cancelled||c.update()}}while(++p<f);return e.type=u.type,e.originalEvent=u.event,A.flatten(n.results)}},properties:function(e,t,n){var o=n.callback;return o.drag=n.drag,o.proxy=n.proxy||n.drag,o.startX=t.pageX,o.startY=t.pageY,o.deltaX=e.pageX-t.pageX,o.deltaY=e.pageY-t.pageY,o.originalX=n.offset.left,o.originalY=n.offset.top,o.offsetX=o.originalX+o.deltaX,o.offsetY=o.originalY+o.deltaY,o.drop=A.flatten((n.drop||[]).slice()),o.available=A.flatten((n.droppable||[]).slice()),o},element:function(e){if(e&&(e.jquery||1==e.nodeType))return e},flatten:function(e){return o.map(e,function(e){return e&&e.jquery?o.makeArray(e):e&&e.length?A.flatten(e):e})},textselect:function(e){o(document)[e?"off":"on"]("selectstart",A.dontstart).css("MozUserSelect",e?"":"none"),document.unselectable=e?"off":"on"},dontstart:function(){return!1},callback:function(){}};A.callback.prototype={update:function(){i.drop&&this.available.length&&o.each(this.available,function(e){i.drop.locate(this,e)})}};var l=r.dispatch;r.dispatch=function(e){if(!(o.data(this,"suppress."+e.type)-(new Date).getTime()>0))return l.apply(this,arguments);o.removeData(this,"suppress."+e.type)},i.draginit=i.dragstart=i.dragend=A},493:function(e,t,n){
/*!
     * jquery.event.drop - v 2.3.0
     * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
     * Open Source MIT License - http://threedubmedia.com/code/license
     */
var o=e(503);o.fn.drop=function(e,t,n){var r="string"==typeof e?e:"",i=o.isFunction(e)?e:o.isFunction(t)?t:null;return 0!==r.indexOf("drop")&&(r="drop"+r),n=(e==i?t:n)||{},i?this.on(r,n,i):this.trigger(r)},o.drop=function(e){e=e||{},i.multi=!0===e.multi?1/0:!1===e.multi?1:isNaN(e.multi)?i.multi:e.multi,i.delay=e.delay||i.delay,i.tolerance=o.isFunction(e.tolerance)?e.tolerance:null===e.tolerance?null:i.tolerance,i.mode=e.mode||i.mode||"intersect"};var r=o.event.special,i=o.event.special.drop={multi:1,delay:20,mode:"overlap",targets:[],datakey:"dropdata",noBubble:!0,add:function(e){o.data(this,i.datakey).related+=1},remove:function(){o.data(this,i.datakey).related-=1},setup:function(){if(!o.data(this,i.datakey)){o.data(this,i.datakey,{related:0,active:[],anyactive:0,winner:0,location:{}}),i.targets.push(this)}},teardown:function(){if(!(o.data(this,i.datakey)||{}).related){o.removeData(this,i.datakey);var e=this;i.targets=o.grep(i.targets,function(t){return t!==e})}},handler:function(e,t){var n;if(t)switch(e.type){case"mousedown":case"touchstart":n=o(i.targets),"string"==typeof t.drop&&(n=n.filter(t.drop)),n.each(function(){var e=o.data(this,i.datakey);e.active=[],e.anyactive=0,e.winner=0}),t.droppable=n,r.drag.hijack(e,"dropinit",t);break;case"mousemove":case"touchmove":i.event=e,i.timer||i.tolerate(t);break;case"mouseup":case"touchend":i.timer=clearTimeout(i.timer),t.propagates&&(r.drag.hijack(e,"drop",t),r.drag.hijack(e,"dropend",t))}},locate:function(e,t){var n=o.data(e,i.datakey),r=o(e),A=r.offset()||{},l=r.outerHeight(),a=r.outerWidth(),s={elem:e,width:a,height:l,top:A.top,left:A.left,right:A.left+a,bottom:A.top+l};return n&&(n.location=s,n.index=t,n.elem=e),s},contains:function(e,t){return(t[0]||t.left)>=e.left&&(t[0]||t.right)<=e.right&&(t[1]||t.top)>=e.top&&(t[1]||t.bottom)<=e.bottom},modes:{intersect:function(e,t,n){return this.contains(n,[e.pageX,e.pageY])?1e9:this.modes.overlap.apply(this,arguments)},overlap:function(e,t,n){return Math.max(0,Math.min(n.bottom,t.bottom)-Math.max(n.top,t.top))*Math.max(0,Math.min(n.right,t.right)-Math.max(n.left,t.left))},fit:function(e,t,n){return this.contains(n,t)?1:0},middle:function(e,t,n){return this.contains(n,[t.left+.5*t.width,t.top+.5*t.height])?1:0}},sort:function(e,t){return t.winner-e.winner||e.index-t.index},tolerate:function(e){var t,n,A,l,a,s,c,u,d=0,p=e.interactions.length,f=[i.event.pageX,i.event.pageY],h=i.tolerance||i.modes[i.mode];do{if(u=e.interactions[d]){if(!u)return;u.drop=[],a=[],s=u.droppable.length,h&&(A=i.locate(u.proxy)),t=0;do{if(c=u.droppable[t]){if(!(n=(l=o.data(c,i.datakey)).location))continue;l.winner=h?h.call(i,i.event,A,n):i.contains(n,f)?1:0,a.push(l)}}while(++t<s);a.sort(i.sort),t=0;do{(l=a[t])&&(l.winner&&u.drop.length<i.multi?(l.active[d]||l.anyactive||(!1!==r.drag.hijack(i.event,"dropstart",e,d,l.elem)[0]?(l.active[d]=1,l.anyactive+=1):l.winner=0),l.winner&&u.drop.push(l.elem)):l.active[d]&&1==l.anyactive&&(r.drag.hijack(i.event,"dropend",e,d,l.elem),l.active[d]=0,l.anyactive-=1))}while(++t<s)}}while(++d<p);i.last&&f[0]==i.last.pageX&&f[1]==i.last.pageY?delete i.timer:i.timer=setTimeout(function(){i.tolerate(e)},i.delay),i.last=i.event}};r.dropinit=r.dropstart=r.dropend=i},494:function(e,t,n){var o=e(503),r=e(497),i=r.keyCode;t.exports={CellExternalCopyManager:function(e){var t,n,A=this,l=e||{},a=l.copiedCellStyleLayerKey||"copy-manager",s=l.copiedCellStyle||"copied",c=0,u=l.bodyElement||document.body,d=l.onCopyInit||null,p=l.onCopySuccess||null;function f(e){if(l.headerColumnValueExtractor){var t=l.headerColumnValueExtractor(e);if(t)return t}return e.name}function h(e,n,r){if(l.dataItemColumnValueExtractor){var i=l.dataItemColumnValueExtractor(e,n);if(i)return i}var A="";if(n.editor){var a={container:o("<p>"),column:n,position:{top:0,left:0},grid:t,event:r},s=new n.editor(a);s.loadValue(e),A=s.serializeValue(),s.destroy()}else A=e[n.field];return A}function g(e,n,r){if(l.dataItemColumnValueSetter)return l.dataItemColumnValueSetter(e,n,r);if(n.editor){var i={container:o("body"),column:n,position:{top:0,left:0},grid:t},A=new n.editor(i);A.loadValue(e),A.applyValue(e,r),A.destroy()}else e[n.field]=r}function m(e){var t=document.createElement("textarea");return t.style.position="absolute",t.style.left="-1000px",t.style.top=document.body.scrollTop+"px",t.value=e,u.appendChild(t),t.select(),t}function v(e,o){var r;if(!t.getEditorLock().isActive()||t.getOptions().autoEdit){if(e.which==i.ESC&&n&&(e.preventDefault(),C(),A.onCopyCancelled.notify({ranges:n}),n=null),(e.which===i.C||e.which===i.INSERT)&&(e.ctrlKey||e.metaKey)&&!e.shiftKey&&(d&&d.call(),0!=(r=t.getSelectionModel().getSelectedRanges()).length)){n=r,w(r),A.onCopyCells.notify({ranges:r});for(var a=t.getColumns(),s="",c=0;c<r.length;c++){for(var v=r[c],y=[],b=v.fromRow;b<v.toRow+1;b++){var x=[],k=t.getDataItem(b);if(""==y&&l.includeHeaderWhenCopying){for(var R=[],S=v.fromCell;S<v.toCell+1;S++)a[S].name.length>0&&R.push(f(a[S]));y.push(R.join("\t"))}for(S=v.fromCell;S<v.toCell+1;S++)x.push(h(k,a[S],e));y.push(x.join("\t"))}s+=y.join("\r\n")+"\r\n"}if(window.clipboardData)return window.clipboardData.setData("Text",s),!0;var E=document.activeElement;if((T=m(s)).focus(),setTimeout(function(){u.removeChild(T),E?E.focus():console.log("Not element to restore focus to after copy?")},100),p){var _=0;_=1===r.length?r[0].toRow+1-r[0].fromRow:r.length,p.call(this,_)}return!1}if(!l.readOnlyMode&&(e.which===i.V&&(e.ctrlKey||e.metaKey)&&!e.shiftKey||e.which===i.INSERT&&e.shiftKey&&!e.ctrlKey)){var T=m("");return setTimeout(function(){!function(e,t){var n=e.getColumns(),o=t.value.split(/[\n\f\r]/);""==o[o.length-1]&&o.pop();var r=[],i=0;u.removeChild(t);for(var a=0;a<o.length;a++)""!=o[a]?r[i++]=o[a].split("\t"):r[a]=[""];var s=e.getActiveCell(),c=e.getSelectionModel().getSelectedRanges(),d=c&&c.length?c[0]:null,p=null,f=null;if(d)p=d.fromRow,f=d.fromCell;else{if(!s)return;p=s.row,f=s.cell}var h=!1,m=r.length,v=r.length?r[0].length:0;1==r.length&&1==r[0].length&&d&&(h=!0,m=d.toRow-d.fromRow+1,v=d.toCell-d.fromCell+1);var C=e.getData().length-p,y=0;if(C<m&&l.newRowCreator){var b=e.getData();for(y=1;y<=m-C;y++)b.push({});e.setData(b),e.render()}var x=p+m>e.getDataLength();if(l.newRowCreator&&x){var k=p+m-e.getDataLength();l.newRowCreator(k)}var R={isClipboardCommand:!0,clippedRange:r,oldValues:[],cellExternalCopyManager:A,_options:l,setDataItemValueForColumn:g,markCopySelection:w,oneCellToMultiple:h,activeRow:p,activeCell:f,destH:m,destW:v,maxDestY:e.getDataLength(),maxDestX:e.getColumns().length,h:0,w:0,execute:function(){this.h=0;for(var t=0;t<this.destH;t++){this.oldValues[t]=[],this.w=0,this.h++;for(var o=0;o<this.destW;o++){this.w++;var i=p+t,A=f+o;if(i<this.maxDestY&&A<this.maxDestX){e.getCellNode(i,A);var l=e.getDataItem(i);this.oldValues[t][o]=l[n[A].field],h?this.setDataItemValueForColumn(l,n[A],r[0][0]):this.setDataItemValueForColumn(l,n[A],r[t]?r[t][o]:""),e.updateCell(i,A),e.onCellChange.notify({row:i,cell:A,item:l,grid:e})}}}var a={fromCell:f,fromRow:p,toCell:f+this.w-1,toRow:p+this.h-1};this.markCopySelection([a]),e.getSelectionModel().setSelectedRanges([a]),this.cellExternalCopyManager.onPasteCells.notify({ranges:[a]})},undo:function(){for(var t=0;t<this.destH;t++)for(var o=0;o<this.destW;o++){var r=p+t,i=f+o;if(r<this.maxDestY&&i<this.maxDestX){e.getCellNode(r,i);var A=e.getDataItem(r);h?this.setDataItemValueForColumn(A,n[i],this.oldValues[0][0]):this.setDataItemValueForColumn(A,n[i],this.oldValues[t][o]),e.updateCell(r,i),e.onCellChange.notify({row:r,cell:i,item:A,grid:e})}}var l={fromCell:f,fromRow:p,toCell:f+this.w-1,toRow:p+this.h-1};if(this.markCopySelection([l]),e.getSelectionModel().setSelectedRanges([l]),this.cellExternalCopyManager.onPasteCells.notify({ranges:[l]}),y>1){for(var a=e.getData();y>1;y--)a.splice(a.length-1,1);e.setData(a),e.render()}}};l.clipboardCommandHandler?l.clipboardCommandHandler(R):R.execute()}(t,T)},100),!1}}}function w(e){C();for(var n=t.getColumns(),o={},r=0;r<e.length;r++)for(var i=e[r].fromRow;i<=e[r].toRow;i++){o[i]={};for(var l=e[r].fromCell;l<=e[r].toCell&&l<n.length;l++)o[i][n[l].id]=s}t.setCellCssStyles(a,o),clearTimeout(c),c=setTimeout(function(){A.clearCopySelection()},2e3)}function C(){t.removeCellCssStyles(a)}o.extend(this,{init:function(e){(t=e).onKeyDown.subscribe(v);var n=e.getSelectionModel();if(!n)throw new Error("Selection model is mandatory for this plugin. Please set a selection model on the grid before adding this plugin: grid.setSelectionModel(new Slick.CellSelectionModel())");n.onSelectedRangesChanged.subscribe(function(e,n){t.focus()})},destroy:function(){t.onKeyDown.unsubscribe(v)},clearCopySelection:C,handleKeyDown:v,onCopyCells:new r.Event,onCopyCancelled:new r.Event,onPasteCells:new r.Event,setIncludeHeaderWhenCopying:function(e){l.includeHeaderWhenCopying=e}})}}},495:function(e,t,n){var o=e(503),r=e(497);t.exports={CheckboxSelectColumn:function(e){var t,n=m(),i=new r.EventHandler,A={},l=!1,a=o.extend(!0,{},{columnId:"_checkbox_selector",cssClass:null,hideSelectAllCheckbox:!1,toolTip:"Select/Deselect All",width:30,hideInColumnTitleRow:!1,hideInFilterHeaderRow:!0},e);function s(){t.updateColumnHeader(a.columnId,"","")}function c(){o("#filter-checkbox-selectall-container").hide()}function u(e,r){var i,s,c=t.getSelectedRows(),u={};for(s=0;s<c.length;s++)u[i=c[s]]=!0,u[i]!==A[i]&&(t.invalidateRow(i),delete A[i]);for(s in A)t.invalidateRow(s);A=u,t.render(),l=c.length&&c.length==t.getDataLength(),a.hideInColumnTitleRow||a.hideSelectAllCheckbox||(l?t.updateColumnHeader(a.columnId,"<input id='header-selector"+n+"' type='checkbox' checked='checked'><label for='header-selector"+n+"'></label>",a.toolTip):t.updateColumnHeader(a.columnId,"<input id='header-selector"+n+"' type='checkbox'><label for='header-selector"+n+"'></label>",a.toolTip)),a.hideInFilterHeaderRow||o("#header-filter-selector"+n).prop("checked",l)}function d(e,n){32==e.which&&t.getColumns()[n.cell].id===a.columnId&&(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit()||f(n.row),e.preventDefault(),e.stopImmediatePropagation())}function p(e,n){if(t.getColumns()[n.cell].id===a.columnId&&o(e.target).is(":checkbox")){if(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit())return e.preventDefault(),void e.stopImmediatePropagation();f(n.row),e.stopPropagation(),e.stopImmediatePropagation()}}function f(e){A[e]?t.setSelectedRows(o.grep(t.getSelectedRows(),function(t){return t!=e})):t.setSelectedRows(t.getSelectedRows().concat(e)),t.setActiveCell(e,function(){if(null===g){g=0;for(var e=t.getColumns(),n=0;n<e.length;n++)e[n].id==a.columnId&&(g=n)}return g}()),t.focus()}function h(e,n){if(n.column.id==a.columnId&&o(e.target).is(":checkbox")){if(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit())return e.preventDefault(),void e.stopImmediatePropagation();if(o(e.target).is(":checked")){for(var r=[],i=0;i<t.getDataLength();i++)r.push(i);t.setSelectedRows(r)}else t.setSelectedRows([]);e.stopPropagation(),e.stopImmediatePropagation()}}var g=null;function m(){return Math.round(1e7*Math.random())}function v(e,t,n,o,r){var i=m()+e;return r?A[e]?"<input id='selector"+i+"' type='checkbox' checked='checked'><label for='selector"+i+"'></label>":"<input id='selector"+i+"' type='checkbox'><label for='selector"+i+"'></label>":null}o.extend(this,{init:function(e){t=e,i.subscribe(t.onSelectedRowsChanged,u).subscribe(t.onClick,p).subscribe(t.onKeyDown,d),a.hideInFilterHeaderRow||function(e){e.onHeaderRowCellRendered.subscribe(function(e,t){"sel"===t.column.field&&(o(t.node).empty(),o("<span id='filter-checkbox-selectall-container'><input id='header-filter-selector"+n+"' type='checkbox'><label for='header-filter-selector"+n+"'></label></span>").appendTo(t.node).on("click",function(e){h(e,t)}))})}(e),a.hideInColumnTitleRow||i.subscribe(t.onHeaderClick,h)},destroy:function(){i.unsubscribeAll()},deSelectRows:function(e){var n,r=e.length,i=[];for(n=0;n<r;n++)A[e[n]]&&(i[i.length]=e[n]);t.setSelectedRows(o.grep(t.getSelectedRows(),function(e){return i.indexOf(e)<0}))},selectRows:function(e){var n,o=e.length,r=[];for(n=0;n<o;n++)A[e[n]]||(r[r.length]=e[n]);t.setSelectedRows(t.getSelectedRows().concat(r))},getColumnDefinition:function(){return{id:a.columnId,name:a.hideSelectAllCheckbox||a.hideInColumnTitleRow?"":"<input id='header-selector"+n+"' type='checkbox'><label for='header-selector"+n+"'></label>",toolTip:a.toolTip,field:"sel",width:a.width,resizable:!1,sortable:!1,cssClass:a.cssClass,hideSelectAllCheckbox:a.hideSelectAllCheckbox,formatter:v}},getOptions:function(){return a},setOptions:function(e){if((a=o.extend(!0,{},a,e)).hideSelectAllCheckbox)s(),c();else if(a.hideInColumnTitleRow?s():(l?t.updateColumnHeader(a.columnId,"<input id='header-selector"+n+"' type='checkbox' checked='checked'><label for='header-selector"+n+"'></label>",a.toolTip):t.updateColumnHeader(a.columnId,"<input id='header-selector"+n+"' type='checkbox'><label for='header-selector"+n+"'></label>",a.toolTip),i.subscribe(t.onHeaderClick,h)),a.hideInFilterHeaderRow)c();else{var r=o("#filter-checkbox-selectall-container");r.show(),r.find('input[type="checkbox"]').prop("checked",l)}}})}}},496:function(e,t,n){var o=e(503),r=e(497);t.exports={RowSelectionModel:function(e){var t,n,i,A=[],l=this,a=new r.EventHandler,s={selectActiveRow:!0};function c(e){return function(){n||(n=!0,e.apply(this,arguments),n=!1)}}function u(e){for(var t=[],n=0;n<e.length;n++)for(var o=e[n].fromRow;o<=e[n].toRow;o++)t.push(o);return t}function d(e){for(var n=[],o=t.getColumns().length-1,i=0;i<e.length;i++)n.push(new r.Range(e[i],0,e[i],o));return n}function p(){return u(A)}function f(e){(A&&0!==A.length||e&&0!==e.length)&&(A=e,l.onSelectedRangesChanged.notify(A))}function h(e,n){i.selectActiveRow&&null!=n.row&&f([new r.Range(n.row,0,n.row,t.getColumns().length-1)])}function g(e){var n=t.getActiveCell();if(t.getOptions().multiSelect&&n&&e.shiftKey&&!e.ctrlKey&&!e.altKey&&!e.metaKey&&(e.which==r.keyCode.UP||e.which==r.keyCode.DOWN)){var o=p();o.sort(function(e,t){return e-t}),o.length||(o=[n.row]);var i,A=o[0],l=o[o.length-1];(i=e.which==r.keyCode.DOWN?n.row<l||A==l?++l:++A:n.row<l?--l:--A)>=0&&i<t.getDataLength()&&(t.scrollRowIntoView(i),f(d(function(e,t){var n,o=[];for(n=e;n<=t;n++)o.push(n);for(n=t;n<e;n++)o.push(n);return o}(A,l)))),e.preventDefault(),e.stopPropagation()}}function m(e){var n=t.getCellFromEvent(e);if(!n||!t.canCellBeActive(n.row,n.cell))return!1;if(!t.getOptions().multiSelect||!e.ctrlKey&&!e.shiftKey&&!e.metaKey)return!1;var r=u(A),i=o.inArray(n.row,r);if(-1===i&&(e.ctrlKey||e.metaKey))r.push(n.row),t.setActiveCell(n.row,n.cell);else if(-1!==i&&(e.ctrlKey||e.metaKey))r=o.grep(r,function(e,t){return e!==n.row}),t.setActiveCell(n.row,n.cell);else if(r.length&&e.shiftKey){var l=r.pop(),a=Math.min(n.row,l),s=Math.max(n.row,l);r=[];for(var c=a;c<=s;c++)c!==l&&r.push(c);r.push(l),t.setActiveCell(n.row,n.cell)}return f(d(r)),e.stopImmediatePropagation(),!0}o.extend(this,{getSelectedRows:p,setSelectedRows:function(e){f(d(e))},getSelectedRanges:function(){return A},setSelectedRanges:f,init:function(n){i=o.extend(!0,{},s,e),t=n,a.subscribe(t.onActiveCellChanged,c(h)),a.subscribe(t.onKeyDown,c(g)),a.subscribe(t.onClick,c(m))},destroy:function(){a.unsubscribeAll()},onSelectedRangesChanged:new r.Event})}}},497:function(e,t,n){function o(){var e=!1,t=!1;this.stopPropagation=function(){e=!0},this.isPropagationStopped=function(){return e},this.stopImmediatePropagation=function(){t=!0},this.isImmediatePropagationStopped=function(){return t}}function r(){this.__nonDataRow=!0}function i(){this.__group=!0,this.level=0,this.count=0,this.value=null,this.title=null,this.collapsed=!1,this.selectChecked=!1,this.totals=null,this.rows=[],this.groups=null,this.groupingKey=null}function A(){this.__groupTotals=!0,this.group=null,this.initialized=!1}function l(){var e=null;this.isActive=function(t){return t?e===t:null!==e},this.activate=function(t){if(t!==e){if(null!==e)throw new Error("SlickGrid.EditorLock.activate: an editController is still active, can't activate another editController");if(!t.commitCurrentEdit)throw new Error("SlickGrid.EditorLock.activate: editController must implement .commitCurrentEdit()");if(!t.cancelCurrentEdit)throw new Error("SlickGrid.EditorLock.activate: editController must implement .cancelCurrentEdit()");e=t}},this.deactivate=function(t){if(e!==t)throw new Error("SlickGrid.EditorLock.deactivate: specified editController is not the currently active one");e=null},this.commitCurrentEdit=function(){return!e||e.commitCurrentEdit()},this.cancelCurrentEdit=function(){return!e||e.cancelCurrentEdit()}}i.prototype=new r,i.prototype.equals=function(e){return this.value===e.value&&this.count===e.count&&this.collapsed===e.collapsed&&this.title===e.title},A.prototype=new r,t.exports={Event:function(){var e=[];this.subscribe=function(t){e.push(t)},this.unsubscribe=function(t){for(var n=e.length-1;n>=0;n--)e[n]===t&&e.splice(n,1)},this.notify=function(t,n,r){var i;n=n||new o,r=r||this;for(var A=0;A<e.length&&!n.isPropagationStopped()&&!n.isImmediatePropagationStopped();A++)i=e[A].call(r,n,t);return i}},EventData:o,EventHandler:function(){var e=[];this.subscribe=function(t,n){return e.push({event:t,handler:n}),t.subscribe(n),this},this.unsubscribe=function(t,n){for(var o=e.length;o--;)if(e[o].event===t&&e[o].handler===n)return e.splice(o,1),void t.unsubscribe(n);return this},this.unsubscribeAll=function(){for(var t=e.length;t--;)e[t].event.unsubscribe(e[t].handler);return e=[],this}},Range:function(e,t,n,o){void 0===n&&void 0===o&&(n=e,o=t),this.fromRow=Math.min(e,n),this.fromCell=Math.min(t,o),this.toRow=Math.max(e,n),this.toCell=Math.max(t,o),this.isSingleRow=function(){return this.fromRow==this.toRow},this.isSingleCell=function(){return this.fromRow==this.toRow&&this.fromCell==this.toCell},this.contains=function(e,t){return e>=this.fromRow&&e<=this.toRow&&t>=this.fromCell&&t<=this.toCell},this.toString=function(){return this.isSingleCell()?"("+this.fromRow+":"+this.fromCell+")":"("+this.fromRow+":"+this.fromCell+" - "+this.toRow+":"+this.toCell+")"}},NonDataRow:r,Group:i,GroupTotals:A,EditorLock:l,GlobalEditorLock:new l,keyCode:{BACKSPACE:8,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,ESC:27,HOME:36,INSERT:45,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,RIGHT:39,TAB:9,UP:38,C:67,V:86},preClickClassName:"slick-edit-preclick"}},498:function(e,t,n){var o=e(503),r=e(497);var i={Avg:function(e){this.field_=e,this.init=function(){this.count_=0,this.nonNullCount_=0,this.sum_=0},this.accumulate=function(e){var t=e[this.field_];this.count_++,null==t||""===t||isNaN(t)||(this.nonNullCount_++,this.sum_+=parseFloat(t))},this.storeResult=function(e){e.avg||(e.avg={}),0!=this.nonNullCount_&&(e.avg[this.field_]=this.sum_/this.nonNullCount_)}},Min:function(e){this.field_=e,this.init=function(){this.min_=null},this.accumulate=function(e){var t=e[this.field_];null==t||""===t||isNaN(t)||(null==this.min_||t<this.min_)&&(this.min_=t)},this.storeResult=function(e){e.min||(e.min={}),e.min[this.field_]=this.min_}},Max:function(e){this.field_=e,this.init=function(){this.max_=null},this.accumulate=function(e){var t=e[this.field_];null==t||""===t||isNaN(t)||(null==this.max_||t>this.max_)&&(this.max_=t)},this.storeResult=function(e){e.max||(e.max={}),e.max[this.field_]=this.max_}},Sum:function(e){this.field_=e,this.init=function(){this.sum_=null},this.accumulate=function(e){var t=e[this.field_];null==t||""===t||isNaN(t)||(this.sum_+=parseFloat(t))},this.storeResult=function(e){e.sum||(e.sum={}),e.sum[this.field_]=this.sum_}}};t.exports={DataView:function(e){var t,n,i,A,l,a=this,s="id",c=[],u=[],d={},p=null,f=null,h=null,g=!1,m=!0,v={},w={},C=[],y=[],b={getter:null,formatter:null,comparer:function(e,t){return e.value===t.value?0:e.value>t.value?1:-1},predefinedValues:[],aggregators:[],aggregateEmpty:!1,aggregateCollapsed:!1,aggregateChildGroups:!1,collapsed:!1,displayTotalsRow:!0,lazyTotalsCalculation:!1},x=[],k=[],R=[],S=":|:",E=0,_=0,T=0,D=new r.Event,P=new r.Event,I=new r.Event;function N(e){for(var t,n=e=e||0,o=c.length;n<o;n++){if(void 0===(t=c[n][s]))throw new Error("Each data element must implement a unique 'id' property");d[t]=n}}function $(){var e=E?Math.max(1,Math.ceil(T/E)):1;return{pageSize:E,pageNum:_,totalRows:T,totalPages:e,dataView:a}}function H(e,o){m=o,n=e,t=null,!1===o&&c.reverse(),c.sort(e),!1===o&&c.reverse(),d={},N(),Z()}function M(e,o){m=o,t=e,n=null;var r=Object.prototype.toString;Object.prototype.toString="function"==typeof e?e:function(){return this[e]},!1===o&&c.reverse(),c.sort(),Object.prototype.toString=r,!1===o&&c.reverse(),d={},N(),Z()}function L(t){e.groupItemMetadataProvider||(e.groupItemMetadataProvider=new r.Data.GroupItemMetadataProvider),k=[],R=[],x=(t=t||[])instanceof Array?t:[t];for(var n=0;n<x.length;n++){var i=x[n]=o.extend(!0,{},b,x[n]);i.getterIsAFn="function"==typeof i.getter,i.compiledAccumulators=[];for(var A=i.aggregators.length;A--;)i.compiledAccumulators[A]=(l=i.aggregators[A],a=void 0,s=void 0,a=U(l.accumulate),(s=new Function("_items","for (var "+a.params[0]+", _i=0, _il=_items.length; _i<_il; _i++) {"+a.params[0]+" = _items[_i]; "+a.body+"}")).displayName=s.name="compiledAccumulatorLoop",s);R[n]={}}var l,a,s;Z()}function F(){if(!p){p={};for(var e=0,t=u.length;e<t;e++)p[u[e][s]]=e}}function V(e){return c[d[e]]}function W(e,t){if(void 0===d[e]||e!==t[s])throw new Error("Invalid or non-matching id");c[d[e]]=t,h||(h={}),h[e]=!0,Z()}function B(e,t){c.splice(e,0,t),N(e),Z()}function j(e){var t=d[e];if(void 0===t)throw new Error("Invalid id");delete d[e],c.splice(t,1),N(t),Z()}function O(e){if(!n)throw new Error("sortedAddItem() requires a sort comparer, use sort()");B(function(e){for(var t=0,o=c.length;t<o;){var r=t+o>>>1;-1===n(c[r],e)?t=r+1:o=r}return t}(e),e)}function z(e,t){if(null==e)for(var n=0;n<x.length;n++)R[n]={},x[n].collapsed=t;else R[e]={},x[e].collapsed=t;Z()}function q(e,t,n){R[e][t]=x[e].collapsed^n,Z()}function G(e){var t,n=e.group,o=x[n.level],r=n.level==x.length,i=o.aggregators.length;if(!r&&o.aggregateChildGroups)for(var A=n.groups.length;A--;)n.groups[A].totals.initialized||G(n.groups[A].totals);for(;i--;)(t=o.aggregators[i]).init(),!r&&o.aggregateChildGroups?o.compiledAccumulators[i].call(t,n.groups):o.compiledAccumulators[i].call(t,n.rows),t.storeResult(e);e.initialized=!0}function K(e){var t=x[e.level],n=new r.GroupTotals;n.group=e,e.totals=n,t.lazyTotalsCalculation||G(n)}function U(e){var t=e.toString().match(/^function[^(]*\(([^)]*)\)\s*{([\s\S]*)}$/);return{params:t[1].split(","),body:t[2]}}function X(e,t){for(var n=[],o=0,r=0,i=e.length;r<i;r++)f(e[r],t)&&(n[o++]=e[r]);return n}function Q(e,t,n){for(var o,r=[],i=0,A=0,l=e.length;A<l;A++)o=e[A],n[A]?r[i++]=o:f(o,t)&&(r[i++]=o,n[A]=!0);return r}function Y(t){if(f){var n=e.inlineFilters?A:X,o=e.inlineFilters?l:Q;v.isFilterNarrowing?C=n(C,i):v.isFilterExpanding?C=o(t,i,y):v.isFilterUnchanged||(C=n(t,i))}else C=E?t:t.concat();var r;return E?(C.length<=_*E&&(_=0===C.length?0:Math.floor((C.length-1)/E)),r=C.slice(E*_,E*_+E)):r=C,{totalRows:C.length,rows:r}}function J(e){p=null,v.isFilterNarrowing==w.isFilterNarrowing&&v.isFilterExpanding==w.isFilterExpanding||(y=[]);var t=Y(e);T=t.totalRows;var n=t.rows;k=[],x.length&&(k=function e(t,n){for(var o,i,A,l=[],a={},s=n?n.level+1:0,c=x[s],u=0,d=c.predefinedValues.length;u<d;u++)(o=a[i=c.predefinedValues[u]])||((o=new r.Group).value=i,o.level=s,o.groupingKey=(n?n.groupingKey+S:"")+i,l[l.length]=o,a[i]=o);for(u=0,d=t.length;u<d;u++)A=t[u],(o=a[i=c.getterIsAFn?c.getter(A):A[c.getter]])||((o=new r.Group).value=i,o.level=s,o.groupingKey=(n?n.groupingKey+S:"")+i,l[l.length]=o,a[i]=o),o.rows[o.count++]=A;if(s<x.length-1)for(u=0;u<l.length;u++)(o=l[u]).groups=e(o.rows,o);return l.sort(x[s].comparer),l}(n)).length&&(function e(t,n){for(var o,r=x[n=n||0],i=r.collapsed,A=R[n],l=t.length;l--;)(o=t[l]).collapsed&&!r.aggregateCollapsed||(o.groups&&e(o.groups,n+1),r.aggregators.length&&(r.aggregateEmpty||o.rows.length||o.groups&&o.groups.length)&&K(o),o.collapsed=i^A[o.groupingKey],o.title=r.formatter?r.formatter(o):o.value)}(k),n=function e(t,n){for(var o,r,i=x[n=n||0],A=[],l=0,a=0,s=t.length;a<s;a++){if(r=t[a],A[l++]=r,!r.collapsed)for(var c=0,u=(o=r.groups?e(r.groups,n+1):r.rows).length;c<u;c++)A[l++]=o[c];r.totals&&i.displayTotalsRow&&(!r.collapsed||i.aggregateCollapsed)&&(A[l++]=r.totals)}return A}(k));var o=function(e,t){var n,o,r,i=[],A=0,l=t.length;v&&v.ignoreDiffsBefore&&(A=Math.max(0,Math.min(t.length,v.ignoreDiffsBefore))),v&&v.ignoreDiffsAfter&&(l=Math.min(t.length,Math.max(0,v.ignoreDiffsAfter)));for(var a=A,c=e.length;a<l;a++)a>=c?i[i.length]=a:(n=t[a],o=e[a],(x.length&&(r=n.__nonDataRow||o.__nonDataRow)&&n.__group!==o.__group||n.__group&&!n.equals(o)||r&&(n.__groupTotals||o.__groupTotals)||n[s]!=o[s]||h&&h[n[s]])&&(i[i.length]=a));return i}(u,n);return u=n,o}function Z(){if(!g){var e=u.length,t=T,n=J(c);E&&T<_*E&&(_=Math.max(0,Math.ceil(T/E)-1),n=J(c)),h=null,w=v,v={},t!==T&&I.notify($(),null,a),e!==u.length&&D.notify({previous:e,current:u.length,dataView:a},null,a),n.length>0&&P.notify({rows:n,dataView:a},null,a)}}e=o.extend(!0,{},{groupItemMetadataProvider:null,inlineFilters:!1},e),o.extend(this,{beginUpdate:function(){g=!0},endUpdate:function(){g=!1,Z()},setPagingOptions:function(e){null!=e.pageSize&&(E=e.pageSize,_=E?Math.min(_,Math.max(0,Math.ceil(T/E)-1)):0),null!=e.pageNum&&(_=Math.min(e.pageNum,Math.max(0,Math.ceil(T/E)-1))),I.notify($(),null,a),Z()},getPagingInfo:$,getItems:function(){return c},setItems:function(e,t){void 0!==t&&(s=t),c=C=e,d={},N(),function(){for(var e,t=0,n=c.length;t<n;t++)if(void 0===(e=c[t][s])||d[e]!==t)throw new Error("Each data element must implement a unique 'id' property")}(),Z()},setFilter:function(t){f=t,e.inlineFilters&&(A=function(){var e=U(f),t="{ _retval[_idx++] = $item$; continue _coreloop; }$1",n=e.body.replace(/return false\s*([;}]|\}|$)/gi,"{ continue _coreloop; }$1").replace(/return!1([;}]|\}|$)/gi,"{ continue _coreloop; }$1").replace(/return true\s*([;}]|\}|$)/gi,t).replace(/return!0([;}]|\}|$)/gi,t).replace(/return ([^;}]+?)\s*([;}]|$)/gi,"{ if ($1) { _retval[_idx++] = $item$; }; continue _coreloop; }$2"),o=["var _retval = [], _idx = 0; ","var $item$, $args$ = _args; ","_coreloop: ","for (var _i = 0, _il = _items.length; _i < _il; _i++) { ","$item$ = _items[_i]; ","$filter$; ","} ","return _retval; "].join("");o=(o=(o=o.replace(/\$filter\$/gi,n)).replace(/\$item\$/gi,e.params[0])).replace(/\$args\$/gi,e.params[1]);var r=new Function("_items,_args",o);return r.displayName=r.name="compiledFilter",r}(),l=function(){var e=U(f),t="{ _cache[_i] = true;_retval[_idx++] = $item$; continue _coreloop; }$1",n=e.body.replace(/return false\s*([;}]|\}|$)/gi,"{ continue _coreloop; }$1").replace(/return!1([;}]|\}|$)/gi,"{ continue _coreloop; }$1").replace(/return true\s*([;}]|\}|$)/gi,t).replace(/return!0([;}]|\}|$)/gi,t).replace(/return ([^;}]+?)\s*([;}]|$)/gi,"{ if ((_cache[_i] = $1)) { _retval[_idx++] = $item$; }; continue _coreloop; }$2"),o=["var _retval = [], _idx = 0; ","var $item$, $args$ = _args; ","_coreloop: ","for (var _i = 0, _il = _items.length; _i < _il; _i++) { ","$item$ = _items[_i]; ","if (_cache[_i]) { ","_retval[_idx++] = $item$; ","continue _coreloop; ","} ","$filter$; ","} ","return _retval; "].join("");o=(o=(o=o.replace(/\$filter\$/gi,n)).replace(/\$item\$/gi,e.params[0])).replace(/\$args\$/gi,e.params[1]);var r=new Function("_items,_args,_cache",o);return r.displayName=r.name="compiledFilterWithCaching",r}()),Z()},getFilter:function(){return f},getFilteredItems:function(){return C},sort:H,fastSort:M,reSort:function(){n?H(n,m):t&&M(t,m)},setGrouping:L,getGrouping:function(){return x},groupBy:function(e,t,n){L(null!=e?{getter:e,formatter:t,comparer:n}:[])},setAggregators:function(e,t){if(!x.length)throw new Error("At least one grouping must be specified before calling setAggregators().");x[0].aggregators=e,x[0].aggregateCollapsed=t,L(x)},collapseAllGroups:function(e){z(e,!0)},expandAllGroups:function(e){z(e,!1)},collapseGroup:function(e){var t=Array.prototype.slice.call(arguments),n=t[0];1==t.length&&-1!=n.indexOf(S)?q(n.split(S).length-1,n,!0):q(t.length-1,t.join(S),!0)},expandGroup:function(e){var t=Array.prototype.slice.call(arguments),n=t[0];1==t.length&&-1!=n.indexOf(S)?q(n.split(S).length-1,n,!1):q(t.length-1,t.join(S),!1)},getGroups:function(){return k},getIdxById:function(e){return d[e]},getRowByItem:function(e){return F(),p[e[s]]},getRowById:function(e){return F(),p[e]},getItemById:V,getItemByIdx:function(e){return c[e]},mapItemsToRows:function(e){var t=[];F();for(var n=0,o=e.length;n<o;n++){var r=p[e[n][s]];null!=r&&(t[t.length]=r)}return t},mapRowsToIds:function(e){for(var t=[],n=0,o=e.length;n<o;n++)e[n]<u.length&&(t[t.length]=u[e[n]][s]);return t},mapIdsToRows:function(e){var t=[];F();for(var n=0,o=e.length;n<o;n++){var r=p[e[n]];null!=r&&(t[t.length]=r)}return t},setRefreshHints:function(e){v=e},setFilterArgs:function(e){i=e},refresh:Z,updateItem:W,insertItem:B,addItem:function(e){c.push(e),N(c.length-1),Z()},deleteItem:j,sortedAddItem:O,sortedUpdateItem:function(e,t){if(void 0===d[e]||e!==t[s])throw new Error("Invalid or non-matching id "+d[e]);if(!n)throw new Error("sortedUpdateItem() requires a sort comparer, use sort()");var o=V(e);0!==n(o,t)?(j(e),O(t)):W(e,t)},syncGridSelection:function(e,t,n){var i,A=this,l=A.mapRowsToIds(e.getSelectedRows()),a=new r.Event;function s(t){l.join(",")!=t.join(",")&&(l=t,a.notify({grid:e,ids:l,dataView:A},new r.EventData,A))}function c(){if(l.length>0){i=!0;var n=A.mapIdsToRows(l);t||s(A.mapRowsToIds(n)),e.setSelectedRows(n),i=!1}}return e.onSelectedRowsChanged.subscribe(function(t,r){if(!i){var a=A.mapRowsToIds(e.getSelectedRows());n&&e.getOptions().multiSelect?s(o.grep(l,function(e){return void 0===A.getRowById(e)}).concat(a)):s(a)}}),this.onRowsChanged.subscribe(c),this.onRowCountChanged.subscribe(c),a},syncGridCellCssStyles:function(e,t){var n,o;function r(e){for(var t in n={},e){var o=u[t][s];n[o]=e[t]}}function i(){if(n){o=!0,F();var r={};for(var i in n){var A=p[i];null!=A&&(r[A]=n[i])}e.setCellCssStyles(t,r),o=!1}}r(e.getCellCssStyles(t)),e.onCellCssStylesChanged.subscribe(function(n,A){o||t==A.key&&(A.hash?r(A.hash):(e.onCellCssStylesChanged.unsubscribe(styleChanged),a.onRowsChanged.unsubscribe(i),a.onRowCountChanged.unsubscribe(i)))}),this.onRowsChanged.subscribe(i),this.onRowCountChanged.subscribe(i)},getLength:function(){return u.length},getItem:function(e){var t=u[e];if(t&&t.__group&&t.totals&&!t.totals.initialized){var n=x[t.level];n.displayTotalsRow||(G(t.totals),t.title=n.formatter?n.formatter(t):t.value)}else t&&t.__groupTotals&&!t.initialized&&G(t);return t},getItemMetadata:function(t){var n=u[t];return void 0===n?null:n.__group?e.groupItemMetadataProvider.getGroupRowMetadata(n):n.__groupTotals?e.groupItemMetadataProvider.getTotalsRowMetadata(n):null},onRowCountChanged:D,onRowsChanged:P,onPagingInfoChanged:I})},Aggregators:i,Data:{Aggregators:i}}},499:function(e,t,n){var o=e(503),r=e(497);function i(e){var t,n;function r(){var t=e.column.editorFixedDecimalPlaces;return void 0===t&&(t=i.DefaultDecimalPlaces),t||0===t?t:null}this.init=function(){var n=e.grid.getOptions().editorCellNavOnLRKeys;t=o("<INPUT type=text class='editor-text' />").appendTo(e.container).on("keydown.nav",n?A:l).focus().select()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(o){n=o[e.column.field];var i=r();null!==i&&(n||0===n)&&n.toFixed&&(n=n.toFixed(i)),t.val(n),t[0].defaultValue=n,t.select()},this.serializeValue=function(){var e=parseFloat(t.val());i.AllowEmptyValue?e||0===e||(e=""):e=e||0;var n=r();return null!==n&&(e||0===e)&&e.toFixed&&(e=parseFloat(e.toFixed(n))),e},this.applyValue=function(t,n){t[e.column.field]=n},this.isValueChanged=function(){return!(""==t.val()&&null==n)&&t.val()!=n},this.validate=function(){if(isNaN(t.val()))return{valid:!1,msg:"Please enter a valid number"};if(e.column.validator){var n=e.column.validator(t.val());if(!n.valid)return n}return{valid:!0,msg:null}},this.init()}function A(e){var t=this.selectionStart,n=this.value.length;(e.keyCode===o.ui.keyCode.LEFT&&t>0||e.keyCode===o.ui.keyCode.RIGHT&&t<n-1)&&e.stopImmediatePropagation()}function l(e){e.keyCode!==o.ui.keyCode.LEFT&&e.keyCode!==o.ui.keyCode.RIGHT||e.stopImmediatePropagation()}i.DefaultDecimalPlaces=null,i.AllowEmptyValue=!1,t.exports={Editors:{Text:function(e){var t,n;this.init=function(){var n=e.grid.getOptions().editorCellNavOnLRKeys;t=o("<INPUT type=text class='editor-text' />").appendTo(e.container).on("keydown.nav",n?A:l).focus().select()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.getValue=function(){return t.val()},this.setValue=function(e){t.val(e)},this.loadValue=function(o){n=o[e.column.field]||"",t.val(n),t[0].defaultValue=n,t.select()},this.serializeValue=function(){return t.val()},this.applyValue=function(t,n){t[e.column.field]=n},this.isValueChanged=function(){return!(""==t.val()&&null==n)&&t.val()!=n},this.validate=function(){if(e.column.validator){var n=e.column.validator(t.val());if(!n.valid)return n}return{valid:!0,msg:null}},this.init()},Integer:function(e){var t,n;this.init=function(){var n=e.grid.getOptions().editorCellNavOnLRKeys;t=o("<INPUT type=text class='editor-text' />").appendTo(e.container).on("keydown.nav",n?A:l).focus().select()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(o){n=o[e.column.field],t.val(n),t[0].defaultValue=n,t.select()},this.serializeValue=function(){return parseInt(t.val(),10)||0},this.applyValue=function(t,n){t[e.column.field]=n},this.isValueChanged=function(){return!(""==t.val()&&null==n)&&t.val()!=n},this.validate=function(){if(isNaN(t.val()))return{valid:!1,msg:"Please enter a valid integer"};if(e.column.validator){var n=e.column.validator(t.val());if(!n.valid)return n}return{valid:!0,msg:null}},this.init()},Float:i,Date:function(e){var t,n,r=!1;this.init=function(){(t=o("<INPUT type=text class='editor-text' />")).appendTo(e.container),t.focus().select(),t.datepicker({showOn:"button",buttonImageOnly:!0,beforeShow:function(){r=!0},onClose:function(){r=!1}}),t.width(t.width()-18)},this.destroy=function(){o.datepicker.dpDiv.stop(!0,!0),t.datepicker("hide"),t.datepicker("destroy"),t.remove()},this.show=function(){r&&o.datepicker.dpDiv.stop(!0,!0).show()},this.hide=function(){r&&o.datepicker.dpDiv.stop(!0,!0).hide()},this.position=function(e){r&&o.datepicker.dpDiv.css("top",e.top+30).css("left",e.left)},this.focus=function(){t.focus()},this.loadValue=function(o){n=o[e.column.field],t.val(n),t[0].defaultValue=n,t.select()},this.serializeValue=function(){return t.val()},this.applyValue=function(t,n){t[e.column.field]=n},this.isValueChanged=function(){return!(""==t.val()&&null==n)&&t.val()!=n},this.validate=function(){if(e.column.validator){var n=e.column.validator(t.val());if(!n.valid)return n}return{valid:!0,msg:null}},this.init()},YesNoSelect:function(e){var t,n;this.init=function(){(t=o("<SELECT tabIndex='0' class='editor-yesno'><OPTION value='yes'>Yes</OPTION><OPTION value='no'>No</OPTION></SELECT>")).appendTo(e.container),t.focus()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(o){t.val((n=o[e.column.field])?"yes":"no"),t.select()},this.serializeValue=function(){return"yes"==t.val()},this.applyValue=function(t,n){t[e.column.field]=n},this.isValueChanged=function(){return t.val()!=n},this.validate=function(){return{valid:!0,msg:null}},this.init()},Checkbox:function(e){var t,n;this.init=function(){(t=o("<INPUT type=checkbox value='true' class='editor-checkbox' hideFocus>")).appendTo(e.container),t.focus()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(o){(n=!!o[e.column.field])?t.prop("checked",!0):t.prop("checked",!1)},this.preClick=function(){t.prop("checked",!t.prop("checked"))},this.serializeValue=function(){return t.prop("checked")},this.applyValue=function(t,n){t[e.column.field]=n},this.isValueChanged=function(){return this.serializeValue()!==n},this.validate=function(){return{valid:!0,msg:null}},this.init()},PercentComplete:function(e){var t,n,r;this.init=function(){(t=o("<INPUT type=text class='editor-percentcomplete' />")).width(o(e.container).innerWidth()-25),t.appendTo(e.container),(n=o("<div class='editor-percentcomplete-picker' />").appendTo(e.container)).append("<div class='editor-percentcomplete-helper'><div class='editor-percentcomplete-wrapper'><div class='editor-percentcomplete-slider' /><div class='editor-percentcomplete-buttons' /></div></div>"),n.find(".editor-percentcomplete-buttons").append("<button val=0>Not started</button><br/><button val=50>In Progress</button><br/><button val=100>Complete</button>"),t.focus().select(),n.find(".editor-percentcomplete-slider").slider({orientation:"vertical",range:"min",value:r,slide:function(e,n){t.val(n.value)}}),n.find(".editor-percentcomplete-buttons button").on("click",function(e){t.val(o(this).attr("val")),n.find(".editor-percentcomplete-slider").slider("value",o(this).attr("val"))})},this.destroy=function(){t.remove(),n.remove()},this.focus=function(){t.focus()},this.loadValue=function(n){t.val(r=n[e.column.field]),t.select()},this.serializeValue=function(){return parseInt(t.val(),10)||0},this.applyValue=function(t,n){t[e.column.field]=n},this.isValueChanged=function(){return!(""==t.val()&&null==r)&&(parseInt(t.val(),10)||0)!=r},this.validate=function(){return isNaN(parseInt(t.val(),10))?{valid:!1,msg:"Please enter a valid positive number"}:{valid:!0,msg:null}},this.init()},LongText:function(e){var t,n,i,A=this;this.init=function(){var r=o("body");e.grid.getOptions().editorCellNavOnLRKeys,n=o("<DIV style='z-index:10000;position:absolute;background:white;padding:5px;border:3px solid gray; -moz-border-radius:10px; border-radius:10px;'/>").appendTo(r),t=o("<TEXTAREA hidefocus rows=5 style='background:white;width:250px;height:80px;border:0;outline:0'>").appendTo(n),o("<DIV style='text-align:right'><BUTTON>Save</BUTTON><BUTTON>Cancel</BUTTON></DIV>").appendTo(n),n.find("button:first").on("click",this.save),n.find("button:last").on("click",this.cancel),t.on("keydown",this.handleKeyDown),A.position(e.position),t.focus().select()},this.handleKeyDown=function(t){if(t.which==r.keyCode.ENTER&&t.ctrlKey)A.save();else if(t.which==r.keyCode.ESCAPE)t.preventDefault(),A.cancel();else if(t.which==r.keyCode.TAB&&t.shiftKey)t.preventDefault(),e.grid.navigatePrev();else if(t.which==r.keyCode.TAB)t.preventDefault(),e.grid.navigateNext();else if((t.which==o.ui.keyCode.LEFT||t.which==o.ui.keyCode.RIGHT)&&e.grid.getOptions().editorCellNavOnLRKeys){var n=this.selectionStart,i=this.value.length;t.keyCode===o.ui.keyCode.LEFT&&0===n&&e.grid.navigatePrev(),t.keyCode===o.ui.keyCode.RIGHT&&n>=i-1&&e.grid.navigateNext()}},this.save=function(){e.commitChanges()},this.cancel=function(){t.val(i),e.cancelChanges()},this.hide=function(){n.hide()},this.show=function(){n.show()},this.position=function(e){n.css("top",e.top-5).css("left",e.left-5)},this.destroy=function(){n.remove()},this.focus=function(){t.focus()},this.loadValue=function(n){t.val(i=n[e.column.field]),t.select()},this.serializeValue=function(){return t.val()},this.applyValue=function(t,n){t[e.column.field]=n},this.isValueChanged=function(){return!(""==t.val()&&null==i)&&t.val()!=i},this.validate=function(){if(e.column.validator){var n=e.column.validator(t.val());if(!n.valid)return n}return{valid:!0,msg:null}},this.init()}}}},500:function(e,t,n){e(497);t.exports={Formatters:{PercentComplete:function(e,t,n,o,r){return null==n||""===n?"-":n<50?"<span style='color:red;font-weight:bold;'>"+n+"%</span>":"<span style='color:green'>"+n+"%</span>"},PercentCompleteBar:function(e,t,n,o,r){return null==n||""===n?"":"<span class='percent-complete-bar' style='background:"+(n<30?"red":n<70?"silver":"green")+";width:"+n+"%'></span>"},YesNo:function(e,t,n,o,r){return n?"Yes":"No"},Checkmark:function(e,t,n,o,r){return n?"<img src='../images/tick.png'>":""},Checkbox:function(e,t,n,o,r){return'<img class="slick-edit-preclick" src="../images/'+(n?"CheckboxY":"CheckboxN")+'.png">'}}}},501:function _(require,module,exports){
/**
     * @license
     * (c) 2009-2016 Michael Leibman
     * michael{dot}leibman{at}gmail{dot}com
     * http://github.com/mleibman/slickgrid
     *
     * Distributed under MIT license.
     * All rights reserved.
     *
     * SlickGrid v2.3
     *
     * NOTES:
     *     Cell/row DOM manipulations are done directly bypassing jQuery's DOM manipulation methods.
     *     This increases the speed dramatically, but can only be done safely because there are no event handlers
     *     or data associated with any cell/row DOM nodes.  Cell editors must make sure they implement .destroy()
     *     and do proper cleanup.
     */
var $=require(503),Slick=require(497),scrollbarDimensions,maxSupportedCssHeight;function SlickGrid(container,data,columns,options){$.fn.drag||require(492),$.fn.drop||require(493);var defaults={alwaysShowVerticalScroll:!1,explicitInitialization:!1,rowHeight:25,defaultColumnWidth:80,enableAddRow:!1,leaveSpaceForNewRows:!1,editable:!1,autoEdit:!0,suppressActiveCellChangeOnEdit:!1,enableCellNavigation:!0,enableColumnReorder:!0,asyncEditorLoading:!1,asyncEditorLoadDelay:100,forceFitColumns:!1,enableAsyncPostRender:!1,asyncPostRenderDelay:50,enableAsyncPostRenderCleanup:!1,asyncPostRenderCleanupDelay:40,autoHeight:!1,editorLock:Slick.GlobalEditorLock,showHeaderRow:!1,headerRowHeight:25,createFooterRow:!1,showFooterRow:!1,footerRowHeight:25,createPreHeaderPanel:!1,showPreHeaderPanel:!1,preHeaderPanelHeight:25,showTopPanel:!1,topPanelHeight:25,formatterFactory:null,editorFactory:null,cellFlashingCssClass:"flashing",selectedCellCssClass:"selected",multiSelect:!0,enableTextSelectionOnCells:!1,dataItemColumnValueExtractor:null,fullWidthRows:!1,multiColumnSort:!1,numberedMultiColumnSort:!1,tristateMultiColumnSort:!1,sortColNumberInSeparateSpan:!1,defaultFormatter:defaultFormatter,forceSyncScrolling:!1,addNewRowCssClass:"new-row",preserveCopiedSelectionOnPaste:!1,showCellSelection:!0,viewportClass:null,minRowBuffer:3,emulatePagingWhenScrolling:!0,editorCellNavOnLRKeys:!1},columnDefaults={name:"",resizable:!0,sortable:!1,minWidth:30,rerenderOnResize:!1,headerCssClass:null,defaultSortAsc:!0,focusable:!0,selectable:!0},th,h,ph,n,cj,page=0,offset=0,vScrollDir=1,initialized=!1,$container,uid="slickgrid_"+Math.round(1e6*Math.random()),self=this,$focusSink,$focusSink2,$headerScroller,$headers,$headerRow,$headerRowScroller,$headerRowSpacer,$footerRow,$footerRowScroller,$footerRowSpacer,$preHeaderPanel,$preHeaderPanelScroller,$preHeaderPanelSpacer,$topPanelScroller,$topPanel,$viewport,$canvas,$style,$boundAncestors,stylesheet,columnCssRulesL,columnCssRulesR,viewportH,viewportW,canvasWidth,viewportHasHScroll,viewportHasVScroll,headerColumnWidthDiff=0,headerColumnHeightDiff=0,cellWidthDiff=0,cellHeightDiff=0,jQueryNewWidthBehaviour=!1,absoluteColumnMinWidth,tabbingDirection=1,activePosX,activeRow,activeCell,activeCellNode=null,currentEditor=null,serializedEditorValue,editController,rowsCache={},renderedRows=0,numVisibleRows,prevScrollTop=0,scrollTop=0,lastRenderedScrollTop=0,lastRenderedScrollLeft=0,prevScrollLeft=0,scrollLeft=0,selectionModel,selectedRows=[],plugins=[],cellCssClasses={},columnsById={},sortColumns=[],columnPosLeft=[],columnPosRight=[],pagingActive=!1,pagingIsLastPage=!1,scrollThrottle=ActionThrottle(render,50),h_editorLoader=null,h_render=null,h_postrender=null,h_postrenderCleanup=null,postProcessedRows={},postProcessToRow=null,postProcessFromRow=null,postProcessedCleanupQueue=[],postProcessgroupId=0,counter_rows_rendered=0,counter_rows_removed=0,rowNodeFromLastMouseWheelEvent,zombieRowNodeFromLastMouseWheelEvent,zombieRowCacheFromLastMouseWheelEvent,zombieRowPostProcessedFromLastMouseWheelEvent,cssShow={position:"absolute",visibility:"hidden",display:"block"},$hiddenParents,oldProps=[],columnResizeDragging=!1;function init(){if(($container=container instanceof $?container:$(container)).length<1)throw new Error("SlickGrid requires a valid container, "+container+" does not exist in the DOM.");cacheCssForHiddenInit(),maxSupportedCssHeight=maxSupportedCssHeight||getMaxSupportedCssHeight(),options=$.extend({},defaults,options),validateAndEnforceOptions(),columnDefaults.width=options.defaultColumnWidth,columnsById={};for(var e=0;e<columns.length;e++){var t=columns[e]=$.extend({},columnDefaults,columns[e]);columnsById[t.id]=e,t.minWidth&&t.width<t.minWidth&&(t.width=t.minWidth),t.maxWidth&&t.width>t.maxWidth&&(t.width=t.maxWidth)}if(options.enableColumnReorder&&!$.fn.sortable)throw new Error("SlickGrid's 'enableColumnReorder = true' option requires jquery-ui.sortable module to be loaded");editController={commitCurrentEdit:commitCurrentEdit,cancelCurrentEdit:cancelCurrentEdit},$container.empty().css("overflow","hidden").css("outline",0).addClass(uid).addClass("ui-widget"),/relative|absolute|fixed/.test($container.css("position"))||$container.css("position","relative"),$focusSink=$("<div tabIndex='0' hideFocus style='position:fixed;width:0;height:0;top:0;left:0;outline:0;'></div>").appendTo($container),options.createPreHeaderPanel&&($preHeaderPanelScroller=$("<div class='slick-preheader-panel ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($container),$preHeaderPanel=$("<div />").appendTo($preHeaderPanelScroller),$preHeaderPanelSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").appendTo($preHeaderPanelScroller),options.showPreHeaderPanel||$preHeaderPanelScroller.hide()),$headerScroller=$("<div class='slick-header ui-state-default' />").appendTo($container),$headers=$("<div class='slick-header-columns' style='left:-1000px' />").appendTo($headerScroller),$headerRowScroller=$("<div class='slick-headerrow ui-state-default' />").appendTo($container),$headerRow=$("<div class='slick-headerrow-columns' />").appendTo($headerRowScroller),$headerRowSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").appendTo($headerRowScroller),$topPanelScroller=$("<div class='slick-top-panel-scroller ui-state-default' />").appendTo($container),$topPanel=$("<div class='slick-top-panel' style='width:10000px' />").appendTo($topPanelScroller),options.showTopPanel||$topPanelScroller.hide(),options.showHeaderRow||$headerRowScroller.hide(),($viewport=$("<div class='slick-viewport' style='width:100%;overflow:auto;outline:0;position:relative;;'>").appendTo($container)).css("overflow-y",options.alwaysShowVerticalScroll?"scroll":options.autoHeight?"hidden":"auto"),$viewport.css("overflow-x",options.forceFitColumns?"hidden":"auto"),options.viewportClass&&$viewport.toggleClass(options.viewportClass,!0),$canvas=$("<div class='grid-canvas' />").appendTo($viewport),scrollbarDimensions=scrollbarDimensions||measureScrollbar(),$preHeaderPanelSpacer&&$preHeaderPanelSpacer.css("width",getCanvasWidth()+scrollbarDimensions.width+"px"),$headers.width(getHeadersWidth()),$headerRowSpacer.css("width",getCanvasWidth()+scrollbarDimensions.width+"px"),options.createFooterRow&&($footerRowScroller=$("<div class='slick-footerrow ui-state-default' />").appendTo($container),$footerRow=$("<div class='slick-footerrow-columns' />").appendTo($footerRowScroller),$footerRowSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").css("width",getCanvasWidth()+scrollbarDimensions.width+"px").appendTo($footerRowScroller),options.showFooterRow||$footerRowScroller.hide()),$focusSink2=$focusSink.clone().appendTo($container),options.explicitInitialization||finishInitialization()}function finishInitialization(){initialized||(initialized=!0,viewportW=parseFloat($.css($container[0],"width",!0)),measureCellPaddingAndBorder(),disableSelection($headers),options.enableTextSelectionOnCells||$viewport.on("selectstart.ui",function(e){return $(e.target).is("input,textarea")}),updateColumnCaches(),createColumnHeaders(),setupColumnSort(),createCssRules(),resizeCanvas(),bindAncestorScrollEvents(),$container.on("resize.slickgrid",resizeCanvas),$viewport.on("scroll",handleScroll),$headerScroller.on("contextmenu",handleHeaderContextMenu).on("click",handleHeaderClick).on("mouseenter",".slick-header-column",handleHeaderMouseEnter).on("mouseleave",".slick-header-column",handleHeaderMouseLeave),$headerRowScroller.on("scroll",handleHeaderRowScroll),options.createFooterRow&&$footerRowScroller.on("scroll",handleFooterRowScroll),options.createPreHeaderPanel&&$preHeaderPanelScroller.on("scroll",handlePreHeaderPanelScroll),$focusSink.add($focusSink2).on("keydown",handleKeyDown),$canvas.on("keydown",handleKeyDown).on("click",handleClick).on("dblclick",handleDblClick).on("contextmenu",handleContextMenu).on("draginit",handleDragInit).on("dragstart",{distance:3},handleDragStart).on("drag",handleDrag).on("dragend",handleDragEnd).on("mouseenter",".slick-cell",handleMouseEnter).on("mouseleave",".slick-cell",handleMouseLeave),navigator.userAgent.toLowerCase().match(/webkit/)&&navigator.userAgent.toLowerCase().match(/macintosh/)&&$canvas.on("mousewheel",handleMouseWheel),restoreCssFromHiddenInit())}function cacheCssForHiddenInit(){($hiddenParents=$container.parents().addBack().not(":visible")).each(function(){var e={};for(var t in cssShow)e[t]=this.style[t],this.style[t]=cssShow[t];oldProps.push(e)})}function restoreCssFromHiddenInit(){$hiddenParents.each(function(e){var t=oldProps[e];for(var n in cssShow)this.style[n]=t[n]})}function registerPlugin(e){plugins.unshift(e),e.init(self)}function unregisterPlugin(e){for(var t=plugins.length;t>=0;t--)if(plugins[t]===e){plugins[t].destroy&&plugins[t].destroy(),plugins.splice(t,1);break}}function setSelectionModel(e){selectionModel&&(selectionModel.onSelectedRangesChanged.unsubscribe(handleSelectedRangesChanged),selectionModel.destroy&&selectionModel.destroy()),(selectionModel=e)&&(selectionModel.init(self),selectionModel.onSelectedRangesChanged.subscribe(handleSelectedRangesChanged))}function getSelectionModel(){return selectionModel}function getCanvasNode(){return $canvas[0]}function measureScrollbar(){var e=$('<div class="'+$viewport.className+'" style="position:absolute; top:-10000px; left:-10000px; overflow:auto; width:100px; height:100px;"></div>').appendTo($viewport),t=$('<div style="width:200px; height:200px; overflow:auto;"></div>').appendTo(e),n={width:e[0].offsetWidth-e[0].clientWidth,height:e[0].offsetHeight-e[0].clientHeight};return t.remove(),e.remove(),n}function getColumnTotalWidth(e){for(var t=0,n=0,o=columns.length;n<o;n++){t+=columns[n].width}return e&&(t+=scrollbarDimensions.width),t}function getHeadersWidth(){var e=getColumnTotalWidth(!options.autoHeight);return Math.max(e,viewportW)+1e3}function getCanvasWidth(){for(var e=viewportHasVScroll?viewportW-scrollbarDimensions.width:viewportW,t=0,n=columns.length;n--;)t+=columns[n].width;return options.fullWidthRows?Math.max(t,e):t}function updateCanvasWidth(e){var t=canvasWidth;(canvasWidth=getCanvasWidth())!=t&&($canvas.width(canvasWidth),$headerRow.width(canvasWidth),options.createFooterRow&&$footerRow.width(canvasWidth),options.createPreHeaderPanel&&$preHeaderPanel.width(canvasWidth),$headers.width(getHeadersWidth()),viewportHasHScroll=canvasWidth>viewportW-scrollbarDimensions.width);var n=canvasWidth+(viewportHasVScroll?scrollbarDimensions.width:0);$headerRowSpacer.width(n),options.createFooterRow&&$footerRowSpacer.width(n),options.createPreHeaderPanel&&$preHeaderPanelSpacer.width(n),(canvasWidth!=t||e)&&applyColumnWidths()}function disableSelection(e){e&&e.jquery&&e.attr("unselectable","on").css("MozUserSelect","none").on("selectstart.ui",function(){return!1})}function getMaxSupportedCssHeight(){for(var e=1e6,t=navigator.userAgent.toLowerCase().match(/firefox/)?6e6:1e9,n=$("<div style='display:none' />").appendTo(document.body);;){var o=2*e;if(n.css("height",o),o>t||n.height()!==o)break;e=o}return n.remove(),e}function getUID(){return uid}function getHeaderColumnWidthDiff(){return headerColumnWidthDiff}function getScrollbarDimensions(){return scrollbarDimensions}function bindAncestorScrollEvents(){for(var e=$canvas[0];(e=e.parentNode)!=document.body&&null!=e;)if(e==$viewport[0]||e.scrollWidth!=e.clientWidth||e.scrollHeight!=e.clientHeight){var t=$(e);$boundAncestors=$boundAncestors?$boundAncestors.add(t):t,t.on("scroll."+uid,handleActiveCellPositionChange)}}function unbindAncestorScrollEvents(){$boundAncestors&&($boundAncestors.off("scroll."+uid),$boundAncestors=null)}function updateColumnHeader(e,t,n){if(initialized){var o=getColumnIndex(e);if(null!=o){var r=columns[o],i=$headers.children().eq(o);i&&(void 0!==t&&(columns[o].name=t),void 0!==n&&(columns[o].toolTip=n),trigger(self.onBeforeHeaderCellDestroy,{node:i[0],column:r,grid:self}),i.attr("title",n||"").children().eq(0).html(t),trigger(self.onHeaderCellRendered,{node:i[0],column:r,grid:self}))}}}function getHeader(){return $headers[0]}function getHeaderColumn(e){var t="number"==typeof e?e:getColumnIndex(e),n=$headers.children().eq(t);return n&&n[0]}function getHeaderRow(){return $headerRow[0]}function getFooterRow(){return $footerRow[0]}function getPreHeaderPanel(){return $preHeaderPanel[0]}function getHeaderRowColumn(e){var t="number"==typeof e?e:getColumnIndex(e),n=$headerRow.children().eq(t);return n&&n[0]}function getFooterRowColumn(e){var t="number"==typeof e?e:getColumnIndex(e),n=$footerRow.children().eq(t);return n&&n[0]}function createColumnHeaders(){function e(){$(this).addClass("ui-state-hover")}function t(){$(this).removeClass("ui-state-hover")}$headers.find(".slick-header-column").each(function(){var e=$(this).data("column");e&&trigger(self.onBeforeHeaderCellDestroy,{node:this,column:e,grid:self})}),$headers.empty(),$headers.width(getHeadersWidth()),$headerRow.find(".slick-headerrow-column").each(function(){var e=$(this).data("column");e&&trigger(self.onBeforeHeaderRowCellDestroy,{node:this,column:e,grid:self})}),$headerRow.empty(),options.createFooterRow&&($footerRow.find(".slick-footerrow-column").each(function(){var e=$(this).data("column");e&&trigger(self.onBeforeFooterRowCellDestroy,{node:this,column:e})}),$footerRow.empty());for(var n=0;n<columns.length;n++){var o=columns[n],r=$("<div class='ui-state-default slick-header-column' />").html("<span class='slick-column-name'>"+o.name+"</span>").width(o.width-headerColumnWidthDiff).attr("id",""+uid+o.id).attr("title",o.toolTip||"").data("column",o).addClass(o.headerCssClass||"").appendTo($headers);if((options.enableColumnReorder||o.sortable)&&r.on("mouseenter",e).on("mouseleave",t),o.sortable&&(r.addClass("slick-header-sortable"),r.append("<span class='slick-sort-indicator"+(options.numberedMultiColumnSort&&!options.sortColNumberInSeparateSpan?" slick-sort-indicator-numbered":"")+"' />"),options.numberedMultiColumnSort&&options.sortColNumberInSeparateSpan&&r.append("<span class='slick-sort-indicator-numbered' />")),trigger(self.onHeaderCellRendered,{node:r[0],column:o,grid:self}),options.showHeaderRow){var i=$("<div class='ui-state-default slick-headerrow-column l"+n+" r"+n+"'></div>").data("column",o).appendTo($headerRow);trigger(self.onHeaderRowCellRendered,{node:i[0],column:o,grid:self})}if(options.createFooterRow&&options.showFooterRow){var A=$("<div class='ui-state-default slick-footerrow-column l"+n+" r"+n+"'></div>").data("column",o).appendTo($footerRow);trigger(self.onFooterRowCellRendered,{node:A[0],column:o})}}setSortColumns(sortColumns),setupColumnResize(),options.enableColumnReorder&&("function"==typeof options.enableColumnReorder?options.enableColumnReorder(self,$headers,headerColumnWidthDiff,setColumns,setupColumnResize,columns,getColumnIndex,uid,trigger):setupColumnReorder())}function setupColumnSort(){$headers.click(function(e){if(!columnResizeDragging&&(e.metaKey=e.metaKey||e.ctrlKey,!$(e.target).hasClass("slick-resizable-handle"))){var t=$(e.target).closest(".slick-header-column");if(t.length){var n=t.data("column");if(n.sortable){if(!getEditorLock().commitCurrentEdit())return;for(var o=null,r=0;r<sortColumns.length;r++)if(sortColumns[r].columnId==n.id){(o=sortColumns[r]).sortAsc=!o.sortAsc;break}var i=!!o;options.tristateMultiColumnSort?(o||(o={columnId:n.id,sortAsc:n.defaultSortAsc}),i&&o.sortAsc&&(sortColumns.splice(r,1),o=null),options.multiColumnSort||(sortColumns=[]),!o||i&&options.multiColumnSort||sortColumns.push(o)):e.metaKey&&options.multiColumnSort?o&&sortColumns.splice(r,1):((e.shiftKey||e.metaKey)&&options.multiColumnSort||(sortColumns=[]),o?0==sortColumns.length&&sortColumns.push(o):(o={columnId:n.id,sortAsc:n.defaultSortAsc},sortColumns.push(o))),setSortColumns(sortColumns),options.multiColumnSort?trigger(self.onSort,{multiColumnSort:!0,sortCols:$.map(sortColumns,function(e){return{sortCol:columns[getColumnIndex(e.columnId)],sortAsc:e.sortAsc}})},e):trigger(self.onSort,{multiColumnSort:!1,sortCol:sortColumns.length>0?n:null,sortAsc:!(sortColumns.length>0)||sortColumns[0].sortAsc},e)}}}})}function setupColumnReorder(){$headers.filter(":ui-sortable").sortable("destroy"),$headers.sortable({containment:"parent",distance:3,axis:"x",cursor:"default",tolerance:"intersection",helper:"clone",placeholder:"slick-sortable-placeholder ui-state-default slick-header-column",start:function(e,t){t.placeholder.width(t.helper.outerWidth()-headerColumnWidthDiff),$(t.helper).addClass("slick-header-column-active")},beforeStop:function(e,t){$(t.helper).removeClass("slick-header-column-active")},stop:function(e){if(getEditorLock().commitCurrentEdit()){for(var t=$headers.sortable("toArray"),n=[],o=0;o<t.length;o++)n.push(columns[getColumnIndex(t[o].replace(uid,""))]);setColumns(n),trigger(self.onColumnsReordered,{}),e.stopPropagation(),setupColumnResize()}else $(this).sortable("cancel")}})}function setupColumnResize(){var e,t,n,o,r,i,A,l;(o=$headers.children()).find(".slick-resizable-handle").remove(),o.each(function(e,t){e>=columns.length||columns[e].resizable&&(void 0===A&&(A=e),l=e)}),void 0!==A&&o.each(function(a,s){a>=columns.length||a<A||options.forceFitColumns&&a>=l||($(s),$("<div class='slick-resizable-handle' />").appendTo(s).on("dragstart",function(A,l){if(!getEditorLock().commitCurrentEdit())return!1;n=A.pageX,$(this).parent().addClass("slick-header-column-active");var s=null,c=null;if(o.each(function(e,t){e>=columns.length||(columns[e].previousWidth=$(t).outerWidth())}),options.forceFitColumns)for(s=0,c=0,e=a+1;e<columns.length;e++)(t=columns[e]).resizable&&(null!==c&&(t.maxWidth?c+=t.maxWidth-t.previousWidth:c=null),s+=t.previousWidth-Math.max(t.minWidth||0,absoluteColumnMinWidth));var u=0,d=0;for(e=0;e<=a;e++)(t=columns[e]).resizable&&(null!==d&&(t.maxWidth?d+=t.maxWidth-t.previousWidth:d=null),u+=t.previousWidth-Math.max(t.minWidth||0,absoluteColumnMinWidth));null===s&&(s=1e5),null===u&&(u=1e5),null===c&&(c=1e5),null===d&&(d=1e5),i=n+Math.min(s,d),r=n-Math.min(u,c)}).on("drag",function(o,A){columnResizeDragging=!0;var l,s,c=Math.min(i,Math.max(r,o.pageX))-n;if(c<0){for(s=c,e=a;e>=0;e--)(t=columns[e]).resizable&&(l=Math.max(t.minWidth||0,absoluteColumnMinWidth),s&&t.previousWidth+s<l?(s+=t.previousWidth-l,t.width=l):(t.width=t.previousWidth+s,s=0));if(options.forceFitColumns)for(s=-c,e=a+1;e<columns.length;e++)(t=columns[e]).resizable&&(s&&t.maxWidth&&t.maxWidth-t.previousWidth<s?(s-=t.maxWidth-t.previousWidth,t.width=t.maxWidth):(t.width=t.previousWidth+s,s=0))}else{for(s=c,e=a;e>=0;e--)(t=columns[e]).resizable&&(s&&t.maxWidth&&t.maxWidth-t.previousWidth<s?(s-=t.maxWidth-t.previousWidth,t.width=t.maxWidth):(t.width=t.previousWidth+s,s=0));if(options.forceFitColumns)for(s=-c,e=a+1;e<columns.length;e++)(t=columns[e]).resizable&&(l=Math.max(t.minWidth||0,absoluteColumnMinWidth),s&&t.previousWidth+s<l?(s+=t.previousWidth-l,t.width=l):(t.width=t.previousWidth+s,s=0))}applyColumnHeaderWidths(),options.syncColumnCellResize&&applyColumnWidths()}).on("dragend",function(n,r){var i;for($(this).parent().removeClass("slick-header-column-active"),e=0;e<columns.length;e++)t=columns[e],i=$(o[e]).outerWidth(),t.previousWidth!==i&&t.rerenderOnResize&&invalidateAllRows();updateCanvasWidth(!0),render(),trigger(self.onColumnsResized,{}),setTimeout(function(){columnResizeDragging=!1},300)}))})}function getVBoxDelta(e){var t=0;return $.each(["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],function(n,o){t+=parseFloat(e.css(o))||0}),t}function measureCellPaddingAndBorder(){var e,t=["borderLeftWidth","borderRightWidth","paddingLeft","paddingRight"],n=["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],o=$.fn.jquery.split(".");jQueryNewWidthBehaviour=1==o[0]&&o[1]>=8||o[0]>=2,e=$("<div class='ui-state-default slick-header-column' style='visibility:hidden'>-</div>").appendTo($headers),headerColumnWidthDiff=headerColumnHeightDiff=0,"border-box"!=e.css("box-sizing")&&"border-box"!=e.css("-moz-box-sizing")&&"border-box"!=e.css("-webkit-box-sizing")&&($.each(t,function(t,n){headerColumnWidthDiff+=parseFloat(e.css(n))||0}),$.each(n,function(t,n){headerColumnHeightDiff+=parseFloat(e.css(n))||0})),e.remove();var r=$("<div class='slick-row' />").appendTo($canvas);e=$("<div class='slick-cell' id='' style='visibility:hidden'>-</div>").appendTo(r),cellWidthDiff=cellHeightDiff=0,"border-box"!=e.css("box-sizing")&&"border-box"!=e.css("-moz-box-sizing")&&"border-box"!=e.css("-webkit-box-sizing")&&($.each(t,function(t,n){cellWidthDiff+=parseFloat(e.css(n))||0}),$.each(n,function(t,n){cellHeightDiff+=parseFloat(e.css(n))||0})),r.remove(),absoluteColumnMinWidth=Math.max(headerColumnWidthDiff,cellWidthDiff)}function createCssRules(){$style=$("<style type='text/css' rel='stylesheet' />").appendTo($("head"));for(var e=options.rowHeight-cellHeightDiff,t=["."+uid+" .slick-header-column { left: 1000px; }","."+uid+" .slick-top-panel { height:"+options.topPanelHeight+"px; }","."+uid+" .slick-preheader-panel { height:"+options.preHeaderPanelHeight+"px; }","."+uid+" .slick-headerrow-columns { height:"+options.headerRowHeight+"px; }","."+uid+" .slick-footerrow-columns { height:"+options.footerRowHeight+"px; }","."+uid+" .slick-cell { height:"+e+"px; }","."+uid+" .slick-row { height:"+options.rowHeight+"px; }"],n=0;n<columns.length;n++)t.push("."+uid+" .l"+n+" { }"),t.push("."+uid+" .r"+n+" { }");$style[0].styleSheet?$style[0].styleSheet.cssText=t.join(" "):$style[0].appendChild(document.createTextNode(t.join(" ")))}function getColumnCssRules(e){var t;if(!stylesheet){var n=document.styleSheets;for(t=0;t<n.length;t++)if((n[t].ownerNode||n[t].owningElement)==$style[0]){stylesheet=n[t];break}if(!stylesheet)throw new Error("Cannot find stylesheet.");columnCssRulesL=[],columnCssRulesR=[];var o,r,i=stylesheet.cssRules||stylesheet.rules;for(t=0;t<i.length;t++){var A=i[t].selectorText;(o=/\.l\d+/.exec(A))?(r=parseInt(o[0].substr(2,o[0].length-2),10),columnCssRulesL[r]=i[t]):(o=/\.r\d+/.exec(A))&&(r=parseInt(o[0].substr(2,o[0].length-2),10),columnCssRulesR[r]=i[t])}}return{left:columnCssRulesL[e],right:columnCssRulesR[e]}}function removeCssRules(){$style.remove(),stylesheet=null}function destroy(){getEditorLock().cancelCurrentEdit(),trigger(self.onBeforeDestroy,{});for(var e=plugins.length;e--;)unregisterPlugin(plugins[e]);options.enableColumnReorder&&$headers.filter(":ui-sortable").sortable("destroy"),unbindAncestorScrollEvents(),$container.off(".slickgrid"),removeCssRules(),$canvas.off("draginit dragstart dragend drag"),$container.empty().removeClass(uid)}function trigger(e,t,n){return n=n||new Slick.EventData,(t=t||{}).grid=self,e.notify(t,n,self)}function getEditorLock(){return options.editorLock}function getEditController(){return editController}function getColumnIndex(e){return columnsById[e]}function autosizeColumns(){var e,t,n,o=[],r=0,i=0,A=viewportHasVScroll?viewportW-scrollbarDimensions.width:viewportW;for(e=0;e<columns.length;e++)t=columns[e],o.push(t.width),i+=t.width,t.resizable&&(r+=t.width-Math.max(t.minWidth,absoluteColumnMinWidth));for(n=i;i>A&&r;){var l=(i-A)/r;for(e=0;e<columns.length&&i>A;e++){t=columns[e];var a=o[e];if(!(!t.resizable||a<=t.minWidth||a<=absoluteColumnMinWidth)){var s=Math.max(t.minWidth,absoluteColumnMinWidth),c=Math.floor(l*(a-s))||1;i-=c=Math.min(c,a-s),r-=c,o[e]-=c}}if(n<=i)break;n=i}for(n=i;i<A;){var u=A/i;for(e=0;e<columns.length&&i<A;e++){t=columns[e];var d,p=o[e];i+=d=!t.resizable||t.maxWidth<=p?0:Math.min(Math.floor(u*p)-p,t.maxWidth-p||1e6)||1,o[e]+=i<=A?d:0}if(n>=i)break;n=i}var f=!1;for(e=0;e<columns.length;e++)columns[e].rerenderOnResize&&columns[e].width!=o[e]&&(f=!0),columns[e].width=o[e];applyColumnHeaderWidths(),updateCanvasWidth(!0),trigger(self.onAutosizeColumns,{columns:columns}),f&&(invalidateAllRows(),render())}function applyColumnHeaderWidths(){if(initialized){for(var e,t=0,n=$headers.children(),o=columns.length;t<o;t++)e=$(n[t]),jQueryNewWidthBehaviour?e.outerWidth()!==columns[t].width&&e.outerWidth(columns[t].width):e.width()!==columns[t].width-headerColumnWidthDiff&&e.width(columns[t].width-headerColumnWidthDiff);updateColumnCaches()}}function applyColumnWidths(){for(var e,t,n=0,o=0;o<columns.length;o++)e=columns[o].width,(t=getColumnCssRules(o)).left.style.left=n+"px",t.right.style.right=canvasWidth-n-e+"px",n+=columns[o].width}function setSortColumn(e,t){setSortColumns([{columnId:e,sortAsc:t}])}function setSortColumns(e){sortColumns=e;var t=options.numberedMultiColumnSort&&sortColumns.length>1,n=$headers.children();n.removeClass("slick-header-column-sorted").find(".slick-sort-indicator").removeClass("slick-sort-indicator-asc slick-sort-indicator-desc"),n.find(".slick-sort-indicator-numbered").text(""),$.each(sortColumns,function(e,o){null==o.sortAsc&&(o.sortAsc=!0);var r=getColumnIndex(o.columnId);null!=r&&(n.eq(r).addClass("slick-header-column-sorted").find(".slick-sort-indicator").addClass(o.sortAsc?"slick-sort-indicator-asc":"slick-sort-indicator-desc"),t&&n.eq(r).find(".slick-sort-indicator-numbered").text(e+1))})}function getSortColumns(){return sortColumns}function handleSelectedRangesChanged(e,t){selectedRows=[];for(var n={},o=0;o<t.length;o++)for(var r=t[o].fromRow;r<=t[o].toRow;r++){n[r]||(selectedRows.push(r),n[r]={});for(var i=t[o].fromCell;i<=t[o].toCell;i++)canCellBeSelected(r,i)&&(n[r][columns[i].id]=options.selectedCellCssClass)}setCellCssStyles(options.selectedCellCssClass,n),trigger(self.onSelectedRowsChanged,{rows:getSelectedRows()},e)}function getColumns(){return columns}function updateColumnCaches(){columnPosLeft=[],columnPosRight=[];for(var e=0,t=0,n=columns.length;t<n;t++)columnPosLeft[t]=e,columnPosRight[t]=e+columns[t].width,e+=columns[t].width}function setColumns(e){columns=e,columnsById={};for(var t=0;t<columns.length;t++){var n=columns[t]=$.extend({},columnDefaults,columns[t]);columnsById[n.id]=t,n.minWidth&&n.width<n.minWidth&&(n.width=n.minWidth),n.maxWidth&&n.width>n.maxWidth&&(n.width=n.maxWidth)}updateColumnCaches(),initialized&&(invalidateAllRows(),createColumnHeaders(),removeCssRules(),createCssRules(),resizeCanvas(),applyColumnWidths(),handleScroll())}function getOptions(){return options}function setOptions(e,t){getEditorLock().commitCurrentEdit()&&(makeActiveCellNormal(),options.enableAddRow!==e.enableAddRow&&invalidateRow(getDataLength()),options=$.extend(options,e),validateAndEnforceOptions(),$viewport.css("overflow-y",options.autoHeight?"hidden":"auto"),t||render())}function validateAndEnforceOptions(){options.autoHeight&&(options.leaveSpaceForNewRows=!1)}function setData(e,t){data=e,invalidateAllRows(),updateRowCount(),t&&scrollTo(0)}function getData(){return data}function getDataLength(){return data.getLength?data.getLength():data.length}function getDataLengthIncludingAddNew(){return getDataLength()+(options.enableAddRow&&(!pagingActive||pagingIsLastPage)?1:0)}function getDataItem(e){return data.getItem?data.getItem(e):data[e]}function getTopPanel(){return $topPanel[0]}function setTopPanelVisibility(e){options.showTopPanel!=e&&(options.showTopPanel=e,e?$topPanelScroller.slideDown("fast",resizeCanvas):$topPanelScroller.slideUp("fast",resizeCanvas))}function setHeaderRowVisibility(e){options.showHeaderRow!=e&&(options.showHeaderRow=e,e?$headerRowScroller.slideDown("fast",resizeCanvas):$headerRowScroller.slideUp("fast",resizeCanvas))}function setFooterRowVisibility(e){options.showFooterRow!=e&&(options.showFooterRow=e,e?$footerRowScroller.slideDown("fast",resizeCanvas):$footerRowScroller.slideUp("fast",resizeCanvas))}function setPreHeaderPanelVisibility(e){options.showPreHeaderPanel!=e&&(options.showPreHeaderPanel=e,e?$preHeaderPanelScroller.slideDown("fast",resizeCanvas):$preHeaderPanelScroller.slideUp("fast",resizeCanvas))}function getContainerNode(){return $container.get(0)}function getRowTop(e){return options.rowHeight*e-offset}function getRowFromPosition(e){return Math.floor((e+offset)/options.rowHeight)}function scrollTo(e){e=Math.max(e,0),e=Math.min(e,th-viewportH+(viewportHasHScroll?scrollbarDimensions.height:0));var t=offset;page=Math.min(n-1,Math.floor(e/ph));var o=e-(offset=Math.round(page*cj));offset!=t&&(cleanupRows(getVisibleRange(o)),updateRowPositions());prevScrollTop!=o&&(vScrollDir=prevScrollTop+t<o+offset?1:-1,$viewport[0].scrollTop=lastRenderedScrollTop=scrollTop=prevScrollTop=o,trigger(self.onViewportChanged,{}))}function defaultFormatter(e,t,n,o,r,i){return null==n?"":(n+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}function getFormatter(e,t){var n=data.getItemMetadata&&data.getItemMetadata(e),o=n&&n.columns&&(n.columns[t.id]||n.columns[getColumnIndex(t.id)]);return o&&o.formatter||n&&n.formatter||t.formatter||options.formatterFactory&&options.formatterFactory.getFormatter(t)||options.defaultFormatter}function getEditor(e,t){var n=columns[t],o=data.getItemMetadata&&data.getItemMetadata(e),r=o&&o.columns;return r&&r[n.id]&&void 0!==r[n.id].editor?r[n.id].editor:r&&r[t]&&void 0!==r[t].editor?r[t].editor:n.editor||options.editorFactory&&options.editorFactory.getEditor(n)}function getDataItemValueForColumn(e,t){return options.dataItemColumnValueExtractor?options.dataItemColumnValueExtractor(e,t):e[t.field]}function appendRowHtml(e,t,n,o){var r=getDataItem(t),i="slick-row"+(t<o&&!r?" loading":"")+(t===activeRow&&options.showCellSelection?" active":"")+(t%2==1?" odd":" even");r||(i+=" "+options.addNewRowCssClass);var A,l,a=data.getItemMetadata&&data.getItemMetadata(t);a&&a.cssClasses&&(i+=" "+a.cssClasses),e.push("<div class='ui-widget-content "+i+"' style='top:"+getRowTop(t)+"px'>");for(var s=0,c=columns.length;s<c;s++){if(l=columns[s],A=1,a&&a.columns){var u=a.columns[l.id]||a.columns[s];"*"===(A=u&&u.colspan||1)&&(A=c-s)}if(columnPosRight[Math.min(c-1,s+A-1)]>n.leftPx){if(columnPosLeft[s]>n.rightPx)break;appendCellHtml(e,t,s,A,r)}A>1&&(s+=A-1)}e.push("</div>")}function appendCellHtml(e,t,n,o,r){var i=columns[n],A="slick-cell l"+n+" r"+Math.min(columns.length-1,n+o-1)+(i.cssClass?" "+i.cssClass:"");for(var l in t===activeRow&&n===activeCell&&options.showCellSelection&&(A+=" active"),cellCssClasses)cellCssClasses[l][t]&&cellCssClasses[l][t][i.id]&&(A+=" "+cellCssClasses[l][t][i.id]);var a=null,s="";r&&(a=getDataItemValueForColumn(r,i),null==(s=getFormatter(t,i)(t,n,a,i,r,self))&&(s=""));var c=trigger(self.onBeforeAppendCell,{row:t,cell:n,value:a,dataContext:r})||"";c+=s&&s.addClasses?(c?" ":"")+s.addClasses:"",e.push("<div class='"+A+(c?" "+c:"")+"'>"),r&&e.push("[object Object]"!==Object.prototype.toString.call(s)?s:s.text),e.push("</div>"),rowsCache[t].cellRenderQueue.push(n),rowsCache[t].cellColSpans[n]=o}function cleanupRows(e){for(var t in rowsCache)(t=parseInt(t,10))!==activeRow&&(t<e.top||t>e.bottom)&&removeRowFromCache(t);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}function invalidate(){updateRowCount(),invalidateAllRows(),render()}function invalidateAllRows(){for(var e in currentEditor&&makeActiveCellNormal(),rowsCache)removeRowFromCache(e);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}function queuePostProcessedRowForCleanup(e,t,n){for(var o in postProcessgroupId++,t)t.hasOwnProperty(o)&&postProcessedCleanupQueue.push({actionType:"C",groupId:postProcessgroupId,node:e.cellNodesByColumnIdx[0|o],columnIdx:0|o,rowIdx:n});postProcessedCleanupQueue.push({actionType:"R",groupId:postProcessgroupId,node:e.rowNode}),$(e.rowNode).detach()}function queuePostProcessedCellForCleanup(e,t,n){postProcessedCleanupQueue.push({actionType:"C",groupId:postProcessgroupId,node:e,columnIdx:t,rowIdx:n}),$(e).detach()}function removeRowFromCache(e){var t=rowsCache[e];t&&(t.rowNode&&(rowNodeFromLastMouseWheelEvent===t.rowNode?(t.rowNode.style.display="none",zombieRowNodeFromLastMouseWheelEvent=rowNodeFromLastMouseWheelEvent,zombieRowCacheFromLastMouseWheelEvent=t,zombieRowPostProcessedFromLastMouseWheelEvent=postProcessedRows[e]):options.enableAsyncPostRenderCleanup&&postProcessedRows[e]?queuePostProcessedRowForCleanup(t,postProcessedRows[e],e):$canvas[0].removeChild(t.rowNode)),delete rowsCache[e],delete postProcessedRows[e],renderedRows--,counter_rows_removed++)}function invalidateRows(e){var t,n;if(e&&e.length){for(vScrollDir=0,n=e.length,t=0;t<n;t++)currentEditor&&activeRow===e[t]&&makeActiveCellNormal(),rowsCache[e[t]]&&removeRowFromCache(e[t]);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}}function invalidateRow(e){(e||0===e)&&invalidateRows([e])}function applyFormatResultToCellNode(e,t,n){null==e&&(e=""),"[object Object]"===Object.prototype.toString.call(e)?(t.innerHTML=e.text,e.removeClasses&&!n&&$(t).removeClass(e.removeClasses),e.addClasses&&$(t).addClass(e.addClasses)):t.innerHTML=e}function updateCell(e,t){var n=getCellNode(e,t);if(n){var o=columns[t],r=getDataItem(e);if(currentEditor&&activeRow===e&&activeCell===t)currentEditor.loadValue(r);else applyFormatResultToCellNode(r?getFormatter(e,o)(e,t,getDataItemValueForColumn(r,o),o,r,self):"",n),invalidatePostProcessingResults(e)}}function updateRow(e){var t=rowsCache[e];if(t){ensureCellNodesInRowsCache(e);var n=getDataItem(e);for(var o in t.cellNodesByColumnIdx)if(t.cellNodesByColumnIdx.hasOwnProperty(o)){var r=columns[o|=0],i=t.cellNodesByColumnIdx[o];e===activeRow&&o===activeCell&&currentEditor?currentEditor.loadValue(n):n?applyFormatResultToCellNode(getFormatter(e,r)(e,o,getDataItemValueForColumn(n,r),r,n,self),i):i.innerHTML=""}invalidatePostProcessingResults(e)}}function getViewportHeight(){return parseFloat($.css($container[0],"height",!0))-parseFloat($.css($container[0],"paddingTop",!0))-parseFloat($.css($container[0],"paddingBottom",!0))-parseFloat($.css($headerScroller[0],"height"))-getVBoxDelta($headerScroller)-(options.showTopPanel?options.topPanelHeight+getVBoxDelta($topPanelScroller):0)-(options.showHeaderRow?options.headerRowHeight+getVBoxDelta($headerRowScroller):0)-(options.createFooterRow&&options.showFooterRow?options.footerRowHeight+getVBoxDelta($footerRowScroller):0)-(options.createPreHeaderPanel&&options.showPreHeaderPanel?options.preHeaderPanelHeight+getVBoxDelta($preHeaderPanelScroller):0)}function resizeCanvas(){initialized&&(viewportH=options.autoHeight?options.rowHeight*getDataLengthIncludingAddNew():getViewportHeight(),numVisibleRows=Math.ceil(viewportH/options.rowHeight),viewportW=parseFloat($.css($container[0],"width",!0)),options.autoHeight||$viewport.height(viewportH),scrollbarDimensions&&scrollbarDimensions.width||(scrollbarDimensions=measureScrollbar()),options.forceFitColumns&&autosizeColumns(),updateRowCount(),handleScroll(),lastRenderedScrollLeft=-1,render())}function updatePagingStatusFromView(e){pagingActive=0!==e.pageSize,pagingIsLastPage=e.pageNum==e.totalPages-1}function updateRowCount(){if(initialized){var e=getDataLength(),t=getDataLengthIncludingAddNew()+(options.leaveSpaceForNewRows?numVisibleRows-1:0),o=viewportHasVScroll;viewportHasVScroll=options.alwaysShowVerticalScroll||!options.autoHeight&&t*options.rowHeight>viewportH,viewportHasHScroll=canvasWidth>viewportW-scrollbarDimensions.width,makeActiveCellNormal();var r=e-1;for(var i in rowsCache)i>r&&removeRowFromCache(i);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup(),activeCellNode&&activeRow>r&&resetActiveCell();var A=h;(th=Math.max(options.rowHeight*t,viewportH-scrollbarDimensions.height))<maxSupportedCssHeight?(h=ph=th,n=1,cj=0):(ph=(h=maxSupportedCssHeight)/100,n=Math.floor(th/ph),cj=(th-h)/(n-1)),h!==A&&($canvas.css("height",h),scrollTop=$viewport[0].scrollTop);var l=scrollTop+offset<=th-viewportH;0==th||0==scrollTop?page=offset=0:scrollTo(l?scrollTop+offset:th-viewportH),h!=A&&options.autoHeight&&resizeCanvas(),options.forceFitColumns&&o!=viewportHasVScroll&&autosizeColumns(),updateCanvasWidth(!1)}}function getVisibleRange(e,t){return null==e&&(e=scrollTop),null==t&&(t=scrollLeft),{top:getRowFromPosition(e),bottom:getRowFromPosition(e+viewportH)+1,leftPx:t,rightPx:t+viewportW}}function getRenderedRange(e,t){var n=getVisibleRange(e,t),o=Math.round(viewportH/options.rowHeight),r=options.minRowBuffer;return-1==vScrollDir?(n.top-=o,n.bottom+=r):1==vScrollDir?(n.top-=r,n.bottom+=o):(n.top-=r,n.bottom+=r),n.top=Math.max(0,n.top),n.bottom=Math.min(getDataLengthIncludingAddNew()-1,n.bottom),n.leftPx-=viewportW,n.rightPx+=viewportW,n.leftPx=Math.max(0,n.leftPx),n.rightPx=Math.min(canvasWidth,n.rightPx),n}function ensureCellNodesInRowsCache(e){var t=rowsCache[e];if(t&&t.cellRenderQueue.length)for(var n=t.rowNode.lastChild;t.cellRenderQueue.length;){var o=t.cellRenderQueue.pop();t.cellNodesByColumnIdx[o]=n,n=n.previousSibling}}function cleanUpCells(e,t){var n,o,r=rowsCache[t],i=[];for(var A in r.cellNodesByColumnIdx)if(r.cellNodesByColumnIdx.hasOwnProperty(A)){A|=0;var l=r.cellColSpans[A];(columnPosLeft[A]>e.rightPx||columnPosRight[Math.min(columns.length-1,A+l-1)]<e.leftPx)&&(t==activeRow&&A==activeCell||i.push(A))}for(postProcessgroupId++;null!=(n=i.pop());)o=r.cellNodesByColumnIdx[n],options.enableAsyncPostRenderCleanup&&postProcessedRows[t]&&postProcessedRows[t][n]?queuePostProcessedCellForCleanup(o,n,t):r.rowNode.removeChild(o),delete r.cellColSpans[n],delete r.cellNodesByColumnIdx[n],postProcessedRows[t]&&delete postProcessedRows[t][n],0}function cleanUpAndRenderCells(e){for(var t,n,o,r=[],i=[],A=e.top,l=e.bottom;A<=l;A++)if(t=rowsCache[A]){ensureCellNodesInRowsCache(A),cleanUpCells(e,A),n=0;var a=data.getItemMetadata&&data.getItemMetadata(A);a=a&&a.columns;for(var s=getDataItem(A),c=0,u=columns.length;c<u&&!(columnPosLeft[c]>e.rightPx);c++)if(null==(o=t.cellColSpans[c])){if(o=1,a){var d=a[columns[c].id]||a[c];"*"===(o=d&&d.colspan||1)&&(o=u-c)}columnPosRight[Math.min(u-1,c+o-1)]>e.leftPx&&(appendCellHtml(r,A,c,o,s),n++),c+=o>1?o-1:0}else c+=o>1?o-1:0;n&&(n,i.push(A))}if(r.length){var p,f,h=document.createElement("div");for(h.innerHTML=r.join("");null!=(p=i.pop());){var g;for(t=rowsCache[p];null!=(g=t.cellRenderQueue.pop());)f=h.lastChild,t.rowNode.appendChild(f),t.cellNodesByColumnIdx[g]=f}}}function renderRows(e){for(var t=$canvas[0],n=[],o=[],r=!1,i=getDataLength(),A=e.top,l=e.bottom;A<=l;A++)rowsCache[A]||(renderedRows++,o.push(A),rowsCache[A]={rowNode:null,cellColSpans:[],cellNodesByColumnIdx:[],cellRenderQueue:[]},appendRowHtml(n,A,e,i),activeCellNode&&activeRow===A&&(r=!0),counter_rows_rendered++);if(o.length){var a=document.createElement("div");a.innerHTML=n.join("");for(A=0,l=o.length;A<l;A++)rowsCache[o[A]].rowNode=t.appendChild(a.firstChild);r&&(activeCellNode=getCellNode(activeRow,activeCell))}}function startPostProcessing(){options.enableAsyncPostRender&&(clearTimeout(h_postrender),h_postrender=setTimeout(asyncPostProcessRows,options.asyncPostRenderDelay))}function startPostProcessingCleanup(){options.enableAsyncPostRenderCleanup&&(clearTimeout(h_postrenderCleanup),h_postrenderCleanup=setTimeout(asyncPostProcessCleanupRows,options.asyncPostRenderCleanupDelay))}function invalidatePostProcessingResults(e){for(var t in postProcessedRows[e])postProcessedRows[e].hasOwnProperty(t)&&(postProcessedRows[e][t]="C");postProcessFromRow=Math.min(postProcessFromRow,e),postProcessToRow=Math.max(postProcessToRow,e),startPostProcessing()}function updateRowPositions(){for(var e in rowsCache)rowsCache[e].rowNode.style.top=getRowTop(e)+"px"}function render(){if(initialized){scrollThrottle.dequeue();var e=getVisibleRange(),t=getRenderedRange();cleanupRows(t),lastRenderedScrollLeft!=scrollLeft&&cleanUpAndRenderCells(t),renderRows(t),postProcessFromRow=e.top,postProcessToRow=Math.min(getDataLengthIncludingAddNew()-1,e.bottom),startPostProcessing(),lastRenderedScrollTop=scrollTop,lastRenderedScrollLeft=scrollLeft,h_render=null,trigger(self.onRendered,{startRow:e.top,endRow:e.bottom,grid:self})}}function handleHeaderScroll(){handleElementScroll($headerScroller[0])}function handleHeaderRowScroll(){handleElementScroll($headerRowScroller[0])}function handleFooterRowScroll(){handleElementScroll($footerRowScroller[0])}function handlePreHeaderPanelScroll(){handleElementScroll($preHeaderPanelScroller[0])}function handleElementScroll(e){var t=e.scrollLeft;t!=$viewport[0].scrollLeft&&($viewport[0].scrollLeft=t)}function handleScroll(){scrollTop=$viewport[0].scrollTop,scrollLeft=$viewport[0].scrollLeft;var e=Math.abs(scrollTop-prevScrollTop),t=Math.abs(scrollLeft-prevScrollLeft);if(t&&(prevScrollLeft=scrollLeft,$headerScroller[0].scrollLeft=scrollLeft,$topPanelScroller[0].scrollLeft=scrollLeft,$headerRowScroller[0].scrollLeft=scrollLeft,options.createFooterRow&&($footerRowScroller[0].scrollLeft=scrollLeft),options.createPreHeaderPanel&&($preHeaderPanelScroller[0].scrollLeft=scrollLeft)),e)if(vScrollDir=prevScrollTop<scrollTop?1:-1,prevScrollTop=scrollTop,e<viewportH)scrollTo(scrollTop+offset);else{var o=offset;page=h==viewportH?0:Math.min(n-1,Math.floor(scrollTop*((th-viewportH)/(h-viewportH))*(1/ph))),o!=(offset=Math.round(page*cj))&&invalidateAllRows()}if(t||e){var r=Math.abs(lastRenderedScrollLeft-scrollLeft),i=Math.abs(lastRenderedScrollTop-scrollTop);(r>20||i>20)&&(options.forceSyncScrolling||i<viewportH&&r<viewportW?render():scrollThrottle.enqueue(),trigger(self.onViewportChanged,{}))}trigger(self.onScroll,{scrollLeft:scrollLeft,scrollTop:scrollTop})}function ActionThrottle(e,t){var n=!1,o=!1;function r(){o=!1}function i(){n=!0,setTimeout(A,t),e()}function A(){o?(r(),i()):n=!1}return{enqueue:function(){n?o=!0:i()},dequeue:r}}function asyncPostProcessRows(){for(var e=getDataLength();postProcessFromRow<=postProcessToRow;){var t=vScrollDir>=0?postProcessFromRow++:postProcessToRow--,n=rowsCache[t];if(n&&!(t>=e)){for(var o in postProcessedRows[t]||(postProcessedRows[t]={}),ensureCellNodesInRowsCache(t),n.cellNodesByColumnIdx)if(n.cellNodesByColumnIdx.hasOwnProperty(o)){var r=columns[o|=0],i=postProcessedRows[t][o];if(r.asyncPostRender&&"R"!==i){var A=n.cellNodesByColumnIdx[o];A&&r.asyncPostRender(A,t,getDataItem(t),r,"C"===i),postProcessedRows[t][o]="R"}}return void(h_postrender=setTimeout(asyncPostProcessRows,options.asyncPostRenderDelay))}}}function asyncPostProcessCleanupRows(){if(postProcessedCleanupQueue.length>0){for(var e=postProcessedCleanupQueue[0].groupId;postProcessedCleanupQueue.length>0&&postProcessedCleanupQueue[0].groupId==e;){var t=postProcessedCleanupQueue.shift();if("R"==t.actionType&&$(t.node).remove(),"C"==t.actionType){var n=columns[t.columnIdx];n.asyncPostRenderCleanup&&t.node&&n.asyncPostRenderCleanup(t.node,t.rowIdx,n)}}h_postrenderCleanup=setTimeout(asyncPostProcessCleanupRows,options.asyncPostRenderCleanupDelay)}}function updateCellCssStylesOnRenderedRows(e,t){var n,o,r,i;for(var A in rowsCache){if(i=t&&t[A],r=e&&e[A],i)for(o in i)r&&i[o]==r[o]||(n=getCellNode(A,getColumnIndex(o)))&&$(n).removeClass(i[o]);if(r)for(o in r)i&&i[o]==r[o]||(n=getCellNode(A,getColumnIndex(o)))&&$(n).addClass(r[o])}}function addCellCssStyles(e,t){if(cellCssClasses[e])throw new Error("addCellCssStyles: cell CSS hash with key '"+e+"' already exists.");cellCssClasses[e]=t,updateCellCssStylesOnRenderedRows(t,null),trigger(self.onCellCssStylesChanged,{key:e,hash:t,grid:self})}function removeCellCssStyles(e){cellCssClasses[e]&&(updateCellCssStylesOnRenderedRows(null,cellCssClasses[e]),delete cellCssClasses[e],trigger(self.onCellCssStylesChanged,{key:e,hash:null,grid:self}))}function setCellCssStyles(e,t){var n=cellCssClasses[e];cellCssClasses[e]=t,updateCellCssStylesOnRenderedRows(t,n),trigger(self.onCellCssStylesChanged,{key:e,hash:t,grid:self})}function getCellCssStyles(e){return cellCssClasses[e]}function flashCell(e,t,n){if(n=n||100,rowsCache[e]){var o=$(getCellNode(e,t)),r=function(e){e&&setTimeout(function(){o.queue(function(){o.toggleClass(options.cellFlashingCssClass).dequeue(),r(e-1)})},n)};r(4)}}function handleMouseWheel(e){var t=$(e.target).closest(".slick-row")[0];t!=rowNodeFromLastMouseWheelEvent&&(zombieRowNodeFromLastMouseWheelEvent&&zombieRowNodeFromLastMouseWheelEvent!=t&&(options.enableAsyncPostRenderCleanup&&zombieRowPostProcessedFromLastMouseWheelEvent?queuePostProcessedRowForCleanup(zombieRowCacheFromLastMouseWheelEvent,zombieRowPostProcessedFromLastMouseWheelEvent):$canvas[0].removeChild(zombieRowNodeFromLastMouseWheelEvent),zombieRowNodeFromLastMouseWheelEvent=null,zombieRowCacheFromLastMouseWheelEvent=null,zombieRowPostProcessedFromLastMouseWheelEvent=null,options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()),rowNodeFromLastMouseWheelEvent=t)}function handleDragInit(e,t){var n=getCellFromEvent(e);if(!n||!cellExists(n.row,n.cell))return!1;var o=trigger(self.onDragInit,t,e);return!!e.isImmediatePropagationStopped()&&o}function handleDragStart(e,t){var n=getCellFromEvent(e);if(!n||!cellExists(n.row,n.cell))return!1;var o=trigger(self.onDragStart,t,e);return!!e.isImmediatePropagationStopped()&&o}function handleDrag(e,t){return trigger(self.onDrag,t,e)}function handleDragEnd(e,t){trigger(self.onDragEnd,t,e)}function handleKeyDown(e){trigger(self.onKeyDown,{row:activeRow,cell:activeCell},e);var t=e.isImmediatePropagationStopped(),n=Slick.keyCode;if(!t&&!e.shiftKey&&!e.altKey){if(options.editable&&currentEditor&&currentEditor.keyCaptureList&&currentEditor.keyCaptureList.indexOf(e.which)>-1)return;e.which==n.HOME?t=e.ctrlKey?navigateTop():navigateRowStart():e.which==n.END&&(t=e.ctrlKey?navigateBottom():navigateRowEnd())}if(!t)if(e.shiftKey||e.altKey||e.ctrlKey)e.which!=n.TAB||!e.shiftKey||e.ctrlKey||e.altKey||(t=navigatePrev());else{if(options.editable&&currentEditor&&currentEditor.keyCaptureList&&currentEditor.keyCaptureList.indexOf(e.which)>-1)return;if(e.which==n.ESCAPE){if(!getEditorLock().isActive())return;cancelEditAndSetFocus()}else e.which==n.PAGE_DOWN?(navigatePageDown(),t=!0):e.which==n.PAGE_UP?(navigatePageUp(),t=!0):e.which==n.LEFT?t=navigateLeft():e.which==n.RIGHT?t=navigateRight():e.which==n.UP?t=navigateUp():e.which==n.DOWN?t=navigateDown():e.which==n.TAB?t=navigateNext():e.which==n.ENTER&&(options.editable&&(currentEditor?activeRow===getDataLength()?navigateDown():commitEditAndSetFocus():getEditorLock().commitCurrentEdit()&&makeActiveCellEditable(void 0,void 0,e)),t=!0)}if(t){e.stopPropagation(),e.preventDefault();try{e.originalEvent.keyCode=0}catch(e){}}}function handleClick(e){currentEditor||(e.target!=document.activeElement||$(e.target).hasClass("slick-cell"))&&setFocus();var t=getCellFromEvent(e);if(t&&(null===currentEditor||activeRow!=t.row||activeCell!=t.cell)&&(trigger(self.onClick,{row:t.row,cell:t.cell},e),!e.isImmediatePropagationStopped()&&canCellBeActive(t.row,t.cell)&&(!getEditorLock().isActive()||getEditorLock().commitCurrentEdit()))){scrollRowIntoView(t.row,!1);var n=e.target&&e.target.className===Slick.preClickClassName,o=columns[t.cell],r=!!(options.editable&&o&&o.editor&&options.suppressActiveCellChangeOnEdit);setActiveCellInternal(getCellNode(t.row,t.cell),null,n,r,e)}}function handleContextMenu(e){var t=$(e.target).closest(".slick-cell",$canvas);0!==t.length&&(activeCellNode===t[0]&&null!==currentEditor||trigger(self.onContextMenu,{},e))}function handleDblClick(e){var t=getCellFromEvent(e);!t||null!==currentEditor&&activeRow==t.row&&activeCell==t.cell||(trigger(self.onDblClick,{row:t.row,cell:t.cell},e),e.isImmediatePropagationStopped()||options.editable&&gotoCell(t.row,t.cell,!0,e))}function handleHeaderMouseEnter(e){trigger(self.onHeaderMouseEnter,{column:$(this).data("column"),grid:self},e)}function handleHeaderMouseLeave(e){trigger(self.onHeaderMouseLeave,{column:$(this).data("column"),grid:self},e)}function handleHeaderContextMenu(e){var t=$(e.target).closest(".slick-header-column",".slick-header-columns"),n=t&&t.data("column");trigger(self.onHeaderContextMenu,{column:n},e)}function handleHeaderClick(e){if(!columnResizeDragging){var t=$(e.target).closest(".slick-header-column",".slick-header-columns"),n=t&&t.data("column");n&&trigger(self.onHeaderClick,{column:n},e)}}function handleMouseEnter(e){trigger(self.onMouseEnter,{},e)}function handleMouseLeave(e){trigger(self.onMouseLeave,{},e)}function cellExists(e,t){return!(e<0||e>=getDataLength()||t<0||t>=columns.length)}function getCellFromPoint(e,t){for(var n=getRowFromPosition(t),o=0,r=0,i=0;i<columns.length&&r<e;i++)r+=columns[i].width,o++;return o<0&&(o=0),{row:n,cell:o-1}}function getCellFromNode(e){var t=/l\d+/.exec(e.className);if(!t)throw new Error("getCellFromNode: cannot get cell - "+e.className);return parseInt(t[0].substr(1,t[0].length-1),10)}function getRowFromNode(e){for(var t in rowsCache)if(rowsCache[t].rowNode===e)return 0|t;return null}function getCellFromEvent(e){var t=$(e.target).closest(".slick-cell",$canvas);if(!t.length)return null;var n=getRowFromNode(t[0].parentNode),o=getCellFromNode(t[0]);return null==n||null==o?null:{row:n,cell:o}}function getCellNodeBox(e,t){if(!cellExists(e,t))return null;for(var n=getRowTop(e),o=n+options.rowHeight-1,r=0,i=0;i<t;i++)r+=columns[i].width;return{top:n,left:r,bottom:o,right:r+columns[t].width}}function resetActiveCell(){setActiveCellInternal(null,!1)}function setFocus(){-1==tabbingDirection?$focusSink[0].focus():$focusSink2[0].focus()}function scrollCellIntoView(e,t,n){scrollRowIntoView(e,n);var o=getColspan(e,t);internalScrollColumnIntoView(columnPosLeft[t],columnPosRight[t+(o>1?o-1:0)])}function internalScrollColumnIntoView(e,t){var n=scrollLeft+viewportW;e<scrollLeft?($viewport.scrollLeft(e),handleScroll(),render()):t>n&&($viewport.scrollLeft(Math.min(e,t-$viewport[0].clientWidth)),handleScroll(),render())}function scrollColumnIntoView(e){internalScrollColumnIntoView(columnPosLeft[e],columnPosRight[e])}function setActiveCellInternal(e,t,n,o,r){null!==activeCellNode&&(makeActiveCellNormal(),$(activeCellNode).removeClass("active"),rowsCache[activeRow]&&$(rowsCache[activeRow].rowNode).removeClass("active"));null!=(activeCellNode=e)?(activeRow=getRowFromNode(activeCellNode.parentNode),activeCell=activePosX=getCellFromNode(activeCellNode),null==t&&(t=activeRow==getDataLength()||options.autoEdit),options.showCellSelection&&($(activeCellNode).addClass("active"),$(rowsCache[activeRow].rowNode).addClass("active")),options.editable&&t&&isCellPotentiallyEditable(activeRow,activeCell)&&(clearTimeout(h_editorLoader),options.asyncEditorLoading?h_editorLoader=setTimeout(function(){makeActiveCellEditable(void 0,n,r)},options.asyncEditorLoadDelay):makeActiveCellEditable(void 0,n,r))):activeRow=activeCell=null,o||trigger(self.onActiveCellChanged,getActiveCell())}function clearTextSelection(){if(document.selection&&document.selection.empty)try{document.selection.empty()}catch(e){}else if(window.getSelection){var e=window.getSelection();e&&e.removeAllRanges&&e.removeAllRanges()}}function isCellPotentiallyEditable(e,t){var n=getDataLength();return!(e<n&&!getDataItem(e))&&(!(columns[t].cannotTriggerInsert&&e>=n)&&!!getEditor(e,t))}function makeActiveCellNormal(){if(currentEditor){if(trigger(self.onBeforeCellEditorDestroy,{editor:currentEditor}),currentEditor.destroy(),currentEditor=null,activeCellNode){var e=getDataItem(activeRow);if($(activeCellNode).removeClass("editable invalid"),e){var t=columns[activeCell];applyFormatResultToCellNode(getFormatter(activeRow,t)(activeRow,activeCell,getDataItemValueForColumn(e,t),t,e,self),activeCellNode),invalidatePostProcessingResults(activeRow)}}navigator.userAgent.toLowerCase().match(/msie/)&&clearTextSelection(),getEditorLock().deactivate(editController)}}function makeActiveCellEditable(e,t,n){if(activeCellNode){if(!options.editable)throw new Error("Grid : makeActiveCellEditable : should never get called when options.editable is false");if(clearTimeout(h_editorLoader),isCellPotentiallyEditable(activeRow,activeCell)){var o=columns[activeCell],r=getDataItem(activeRow);if(!1!==trigger(self.onBeforeEditCell,{row:activeRow,cell:activeCell,item:r,column:o})){getEditorLock().activate(editController),$(activeCellNode).addClass("editable");var i=e||getEditor(activeRow,activeCell);e||i.suppressClearOnEdit||(activeCellNode.innerHTML=""),currentEditor=new i({grid:self,gridPosition:absBox($container[0]),position:absBox(activeCellNode),container:activeCellNode,column:o,item:r||{},event:n,commitChanges:commitEditAndSetFocus,cancelChanges:cancelEditAndSetFocus}),r&&(currentEditor.loadValue(r),t&&currentEditor.preClick&&currentEditor.preClick()),serializedEditorValue=currentEditor.serializeValue(),currentEditor.position&&handleActiveCellPositionChange()}else setFocus()}}}function commitEditAndSetFocus(){getEditorLock().commitCurrentEdit()&&(setFocus(),options.autoEdit&&navigateDown())}function cancelEditAndSetFocus(){getEditorLock().cancelCurrentEdit()&&setFocus()}function absBox(e){var t={top:e.offsetTop,left:e.offsetLeft,bottom:0,right:0,width:$(e).outerWidth(),height:$(e).outerHeight(),visible:!0};t.bottom=t.top+t.height,t.right=t.left+t.width;for(var n=e.offsetParent;(e=e.parentNode)!=document.body&&null!=e;)t.visible&&e.scrollHeight!=e.offsetHeight&&"visible"!=$(e).css("overflowY")&&(t.visible=t.bottom>e.scrollTop&&t.top<e.scrollTop+e.clientHeight),t.visible&&e.scrollWidth!=e.offsetWidth&&"visible"!=$(e).css("overflowX")&&(t.visible=t.right>e.scrollLeft&&t.left<e.scrollLeft+e.clientWidth),t.left-=e.scrollLeft,t.top-=e.scrollTop,e===n&&(t.left+=e.offsetLeft,t.top+=e.offsetTop,n=e.offsetParent),t.bottom=t.top+t.height,t.right=t.left+t.width;return t}function getActiveCellPosition(){return absBox(activeCellNode)}function getGridPosition(){return absBox($container[0])}function handleActiveCellPositionChange(){if(activeCellNode&&(trigger(self.onActiveCellPositionChanged,{}),currentEditor)){var e=getActiveCellPosition();currentEditor.show&&currentEditor.hide&&(e.visible?currentEditor.show():currentEditor.hide()),currentEditor.position&&currentEditor.position(e)}}function getCellEditor(){return currentEditor}function getActiveCell(){return activeCellNode?{row:activeRow,cell:activeCell}:null}function getActiveCellNode(){return activeCellNode}function scrollRowIntoView(e,t){var n=e*options.rowHeight,o=(e+1)*options.rowHeight-viewportH+(viewportHasHScroll?scrollbarDimensions.height:0);(e+1)*options.rowHeight>scrollTop+viewportH+offset?(scrollTo(t?n:o),render()):e*options.rowHeight<scrollTop+offset&&(scrollTo(t?o:n),render())}function scrollRowToTop(e){scrollTo(e*options.rowHeight),render()}function scrollPage(e){var t=e*numVisibleRows;if(scrollTo((getRowFromPosition(scrollTop)+t)*options.rowHeight),render(),options.enableCellNavigation&&null!=activeRow){var n=activeRow+t,o=getDataLengthIncludingAddNew();n>=o&&(n=o-1),n<0&&(n=0);for(var r=0,i=null,A=activePosX;r<=activePosX;)canCellBeActive(n,r)&&(i=r),r+=getColspan(n,r);null!==i?(setActiveCellInternal(getCellNode(n,i)),activePosX=A):resetActiveCell()}}function navigatePageDown(){scrollPage(1)}function navigatePageUp(){scrollPage(-1)}function navigateTop(){navigateToRow(0)}function navigateBottom(){navigateToRow(getDataLength()-1)}function navigateToRow(e){var t=getDataLength();if(!t)return!0;if(e<0?e=0:e>=t&&(e=t-1),scrollCellIntoView(e,0,!0),options.enableCellNavigation&&null!=activeRow){for(var n=0,o=null,r=activePosX;n<=activePosX;)canCellBeActive(e,n)&&(o=n),n+=getColspan(e,n);null!==o?(setActiveCellInternal(getCellNode(e,o)),activePosX=r):resetActiveCell()}return!0}function getColspan(e,t){var n=data.getItemMetadata&&data.getItemMetadata(e);if(!n||!n.columns)return 1;var o=n.columns[columns[t].id]||n.columns[t],r=o&&o.colspan;return r="*"===r?columns.length-t:r||1}function findFirstFocusableCell(e){for(var t=0;t<columns.length;){if(canCellBeActive(e,t))return t;t+=getColspan(e,t)}return null}function findLastFocusableCell(e){for(var t=0,n=null;t<columns.length;)canCellBeActive(e,t)&&(n=t),t+=getColspan(e,t);return n}function gotoRight(e,t,n){if(t>=columns.length)return null;do{t+=getColspan(e,t)}while(t<columns.length&&!canCellBeActive(e,t));return t<columns.length?{row:e,cell:t,posX:t}:null}function gotoLeft(e,t,n){if(t<=0)return null;var o=findFirstFocusableCell(e);if(null===o||o>=t)return null;for(var r,i={row:e,cell:o,posX:o};;){if(!(r=gotoRight(i.row,i.cell,i.posX)))return null;if(r.cell>=t)return i;i=r}}function gotoDown(e,t,n){for(var o,r=getDataLengthIncludingAddNew();;){if(++e>=r)return null;for(o=t=0;t<=n;)o=t,t+=getColspan(e,t);if(canCellBeActive(e,o))return{row:e,cell:o,posX:n}}}function gotoUp(e,t,n){for(var o;;){if(--e<0)return null;for(o=t=0;t<=n;)o=t,t+=getColspan(e,t);if(canCellBeActive(e,o))return{row:e,cell:o,posX:n}}}function gotoNext(e,t,n){if(null==e&&null==t&&canCellBeActive(e=t=n=0,t))return{row:e,cell:t,posX:t};var o=gotoRight(e,t,n);if(o)return o;var r=null,i=getDataLengthIncludingAddNew();for(e===i-1&&e--;++e<i;)if(null!==(r=findFirstFocusableCell(e)))return{row:e,cell:r,posX:r};return null}function gotoPrev(e,t,n){if(null==e&&null==t&&canCellBeActive(e=getDataLengthIncludingAddNew()-1,t=n=columns.length-1))return{row:e,cell:t,posX:t};for(var o,r;!o&&!(o=gotoLeft(e,t,n));){if(--e<0)return null;t=0,null!==(r=findLastFocusableCell(e))&&(o={row:e,cell:r,posX:r})}return o}function gotoRowStart(e,t,n){var o=findFirstFocusableCell(e);return null===o?null:{row:e,cell:o,posX:o}}function gotoRowEnd(e,t,n){var o=findLastFocusableCell(e);return null===o?null:{row:e,cell:o,posX:o}}function navigateRight(){return navigate("right")}function navigateLeft(){return navigate("left")}function navigateDown(){return navigate("down")}function navigateUp(){return navigate("up")}function navigateNext(){return navigate("next")}function navigatePrev(){return navigate("prev")}function navigateRowStart(){return navigate("home")}function navigateRowEnd(){return navigate("end")}function navigate(e){if(!options.enableCellNavigation)return!1;if(!activeCellNode&&"prev"!=e&&"next"!=e)return!1;if(!getEditorLock().commitCurrentEdit())return!0;setFocus();tabbingDirection={up:-1,down:1,left:-1,right:1,prev:-1,next:1,home:-1,end:1}[e];var t=(0,{up:gotoUp,down:gotoDown,left:gotoLeft,right:gotoRight,prev:gotoPrev,next:gotoNext,home:gotoRowStart,end:gotoRowEnd}[e])(activeRow,activeCell,activePosX);if(t){var n=t.row==getDataLength();return scrollCellIntoView(t.row,t.cell,!n&&options.emulatePagingWhenScrolling),setActiveCellInternal(getCellNode(t.row,t.cell)),activePosX=t.posX,!0}return setActiveCellInternal(getCellNode(activeRow,activeCell)),!1}function getCellNode(e,t){return rowsCache[e]?(ensureCellNodesInRowsCache(e),rowsCache[e].cellNodesByColumnIdx[t]):null}function setActiveCell(e,t,n,o,r){initialized&&(e>getDataLength()||e<0||t>=columns.length||t<0||options.enableCellNavigation&&(scrollCellIntoView(e,t,!1),setActiveCellInternal(getCellNode(e,t),n,o,r)))}function canCellBeActive(e,t){if(!options.enableCellNavigation||e>=getDataLengthIncludingAddNew()||e<0||t>=columns.length||t<0)return!1;var n=data.getItemMetadata&&data.getItemMetadata(e);if(n&&void 0!==n.focusable)return!!n.focusable;var o=n&&n.columns;return o&&o[columns[t].id]&&void 0!==o[columns[t].id].focusable?!!o[columns[t].id].focusable:o&&o[t]&&void 0!==o[t].focusable?!!o[t].focusable:!!columns[t].focusable}function canCellBeSelected(e,t){if(e>=getDataLength()||e<0||t>=columns.length||t<0)return!1;var n=data.getItemMetadata&&data.getItemMetadata(e);if(n&&void 0!==n.selectable)return!!n.selectable;var o=n&&n.columns&&(n.columns[columns[t].id]||n.columns[t]);return o&&void 0!==o.selectable?!!o.selectable:!!columns[t].selectable}function gotoCell(e,t,n,o){initialized&&(canCellBeActive(e,t)&&getEditorLock().commitCurrentEdit()&&(scrollCellIntoView(e,t,!1),setActiveCellInternal(getCellNode(e,t),n||e===getDataLength()||options.autoEdit,null,options.editable,o),currentEditor||setFocus()))}function commitCurrentEdit(){var e=getDataItem(activeRow),t=columns[activeCell];if(currentEditor){if(currentEditor.isValueChanged()){var n=currentEditor.validate();if(n.valid){if(activeRow<getDataLength()){var o={row:activeRow,cell:activeCell,editor:currentEditor,serializedValue:currentEditor.serializeValue(),prevSerializedValue:serializedEditorValue,execute:function(){this.editor.applyValue(e,this.serializedValue),updateRow(this.row),trigger(self.onCellChange,{row:this.row,cell:this.cell,item:e})},undo:function(){this.editor.applyValue(e,this.prevSerializedValue),updateRow(this.row),trigger(self.onCellChange,{row:this.row,cell:this.cell,item:e})}};options.editCommandHandler?(makeActiveCellNormal(),options.editCommandHandler(e,t,o)):(o.execute(),makeActiveCellNormal())}else{var r={};currentEditor.applyValue(r,currentEditor.serializeValue()),makeActiveCellNormal(),trigger(self.onAddNewRow,{item:r,column:t})}return!getEditorLock().isActive()}return $(activeCellNode).removeClass("invalid"),$(activeCellNode).width(),$(activeCellNode).addClass("invalid"),trigger(self.onValidationError,{editor:currentEditor,cellNode:activeCellNode,validationResults:n,row:activeRow,cell:activeCell,column:t}),currentEditor.focus(),!1}makeActiveCellNormal()}return!0}function cancelCurrentEdit(){return makeActiveCellNormal(),!0}function rowsToRanges(e){for(var t=[],n=columns.length-1,o=0;o<e.length;o++)t.push(new Slick.Range(e[o],0,e[o],n));return t}function getSelectedRows(){if(!selectionModel)throw new Error("Selection model is not set");return selectedRows}function setSelectedRows(e){if(!selectionModel)throw new Error("Selection model is not set");self&&self.getEditorLock&&!self.getEditorLock().isActive()&&selectionModel.setSelectedRanges(rowsToRanges(e))}this.debug=function(){var e="";e+="\ncounter_rows_rendered:  "+counter_rows_rendered,e+="\ncounter_rows_removed:  "+counter_rows_removed,e+="\nrenderedRows:  "+renderedRows,e+="\nnumVisibleRows:  "+numVisibleRows,e+="\nmaxSupportedCssHeight:  "+maxSupportedCssHeight,e+="\nn(umber of pages):  "+n,e+="\n(current) page:  "+page,e+="\npage height (ph):  "+ph,e+="\nvScrollDir:  "+vScrollDir,alert(e)},this.eval=function(expr){return eval(expr)},$.extend(this,{slickGridVersion:"2.3.23",onScroll:new Slick.Event,onSort:new Slick.Event,onHeaderMouseEnter:new Slick.Event,onHeaderMouseLeave:new Slick.Event,onHeaderContextMenu:new Slick.Event,onHeaderClick:new Slick.Event,onHeaderCellRendered:new Slick.Event,onBeforeHeaderCellDestroy:new Slick.Event,onHeaderRowCellRendered:new Slick.Event,onFooterRowCellRendered:new Slick.Event,onBeforeHeaderRowCellDestroy:new Slick.Event,onBeforeFooterRowCellDestroy:new Slick.Event,onMouseEnter:new Slick.Event,onMouseLeave:new Slick.Event,onClick:new Slick.Event,onDblClick:new Slick.Event,onContextMenu:new Slick.Event,onKeyDown:new Slick.Event,onAddNewRow:new Slick.Event,onBeforeAppendCell:new Slick.Event,onValidationError:new Slick.Event,onViewportChanged:new Slick.Event,onColumnsReordered:new Slick.Event,onColumnsResized:new Slick.Event,onCellChange:new Slick.Event,onBeforeEditCell:new Slick.Event,onBeforeCellEditorDestroy:new Slick.Event,onBeforeDestroy:new Slick.Event,onActiveCellChanged:new Slick.Event,onActiveCellPositionChanged:new Slick.Event,onDragInit:new Slick.Event,onDragStart:new Slick.Event,onDrag:new Slick.Event,onDragEnd:new Slick.Event,onSelectedRowsChanged:new Slick.Event,onCellCssStylesChanged:new Slick.Event,onAutosizeColumns:new Slick.Event,onRendered:new Slick.Event,registerPlugin:registerPlugin,unregisterPlugin:unregisterPlugin,getColumns:getColumns,setColumns:setColumns,getColumnIndex:getColumnIndex,updateColumnHeader:updateColumnHeader,setSortColumn:setSortColumn,setSortColumns:setSortColumns,getSortColumns:getSortColumns,autosizeColumns:autosizeColumns,getOptions:getOptions,setOptions:setOptions,getData:getData,getDataLength:getDataLength,getDataItem:getDataItem,setData:setData,getSelectionModel:getSelectionModel,setSelectionModel:setSelectionModel,getSelectedRows:getSelectedRows,setSelectedRows:setSelectedRows,getContainerNode:getContainerNode,updatePagingStatusFromView:updatePagingStatusFromView,render:render,invalidate:invalidate,invalidateRow:invalidateRow,invalidateRows:invalidateRows,invalidateAllRows:invalidateAllRows,updateCell:updateCell,updateRow:updateRow,getViewport:getVisibleRange,getRenderedRange:getRenderedRange,resizeCanvas:resizeCanvas,updateRowCount:updateRowCount,scrollRowIntoView:scrollRowIntoView,scrollRowToTop:scrollRowToTop,scrollCellIntoView:scrollCellIntoView,scrollColumnIntoView:scrollColumnIntoView,getCanvasNode:getCanvasNode,getUID:getUID,getHeaderColumnWidthDiff:getHeaderColumnWidthDiff,getScrollbarDimensions:getScrollbarDimensions,getHeadersWidth:getHeadersWidth,getCanvasWidth:getCanvasWidth,focus:setFocus,scrollTo:scrollTo,getCellFromPoint:getCellFromPoint,getCellFromEvent:getCellFromEvent,getActiveCell:getActiveCell,setActiveCell:setActiveCell,getActiveCellNode:getActiveCellNode,getActiveCellPosition:getActiveCellPosition,resetActiveCell:resetActiveCell,editActiveCell:makeActiveCellEditable,getCellEditor:getCellEditor,getCellNode:getCellNode,getCellNodeBox:getCellNodeBox,canCellBeSelected:canCellBeSelected,canCellBeActive:canCellBeActive,navigatePrev:navigatePrev,navigateNext:navigateNext,navigateUp:navigateUp,navigateDown:navigateDown,navigateLeft:navigateLeft,navigateRight:navigateRight,navigatePageUp:navigatePageUp,navigatePageDown:navigatePageDown,navigateTop:navigateTop,navigateBottom:navigateBottom,navigateRowStart:navigateRowStart,navigateRowEnd:navigateRowEnd,gotoCell:gotoCell,getTopPanel:getTopPanel,setTopPanelVisibility:setTopPanelVisibility,getPreHeaderPanel:getPreHeaderPanel,setPreHeaderPanelVisibility:setPreHeaderPanelVisibility,getHeader:getHeader,getHeaderColumn:getHeaderColumn,setHeaderRowVisibility:setHeaderRowVisibility,getHeaderRow:getHeaderRow,getHeaderRowColumn:getHeaderRowColumn,setFooterRowVisibility:setFooterRowVisibility,getFooterRow:getFooterRow,getFooterRowColumn:getFooterRowColumn,getGridPosition:getGridPosition,flashCell:flashCell,addCellCssStyles:addCellCssStyles,setCellCssStyles:setCellCssStyles,removeCellCssStyles:removeCellCssStyles,getCellCssStyles:getCellCssStyles,init:finishInitialization,destroy:destroy,getEditorLock:getEditorLock,getEditController:getEditController}),init()}module.exports={Grid:SlickGrid}},502:function(e,t,n){var o=e(503),r=e(497);t.exports={GroupItemMetadataProvider:function(e){var t,n={checkboxSelect:!1,checkboxSelectCssClass:"slick-group-select-checkbox",checkboxSelectPlugin:null,groupCssClass:"slick-group",groupTitleCssClass:"slick-group-title",totalsCssClass:"slick-group-totals",groupFocusable:!0,totalsFocusable:!1,toggleCssClass:"slick-group-toggle",toggleExpandedCssClass:"expanded",toggleCollapsedCssClass:"collapsed",enableExpandCollapse:!0,groupFormatter:function(t,n,o,r,i,A){if(!e.enableExpandCollapse)return i.title;var l=15*i.level+"px";return(e.checkboxSelect?'<span class="'+e.checkboxSelectCssClass+" "+(i.selectChecked?"checked":"unchecked")+'"></span>':"")+"<span class='"+e.toggleCssClass+" "+(i.collapsed?e.toggleCollapsedCssClass:e.toggleExpandedCssClass)+"' style='margin-left:"+l+"'></span><span class='"+e.groupTitleCssClass+"' level='"+i.level+"'>"+i.title+"</span>"},totalsFormatter:function(e,t,n,o,r,i){return o.groupTotalsFormatter&&o.groupTotalsFormatter(r,o,i)||""}};function i(n,i){var A=o(n.target),l=this.getDataItem(i.row);if(l&&l instanceof r.Group&&A.hasClass(e.toggleCssClass)){var a=t.getRenderedRange();this.getData().setRefreshHints({ignoreDiffsBefore:a.top,ignoreDiffsAfter:a.bottom+1}),l.collapsed?this.getData().expandGroup(l.groupingKey):this.getData().collapseGroup(l.groupingKey),n.stopImmediatePropagation(),n.preventDefault()}if(l&&l instanceof r.Group&&A.hasClass(e.checkboxSelectCssClass)){l.selectChecked=!l.selectChecked,A.removeClass(l.selectChecked?"unchecked":"checked"),A.addClass(l.selectChecked?"checked":"unchecked");var s=t.getData().mapItemsToRows(l.rows);(l.selectChecked?e.checkboxSelectPlugin.selectRows:e.checkboxSelectPlugin.deSelectRows)(s)}}function A(n,o){if(e.enableExpandCollapse&&n.which==r.keyCode.SPACE){var i=this.getActiveCell();if(i){var A=this.getDataItem(i.row);if(A&&A instanceof r.Group){var l=t.getRenderedRange();this.getData().setRefreshHints({ignoreDiffsBefore:l.top,ignoreDiffsAfter:l.bottom+1}),A.collapsed?this.getData().expandGroup(A.groupingKey):this.getData().collapseGroup(A.groupingKey),n.stopImmediatePropagation(),n.preventDefault()}}}}return e=o.extend(!0,{},n,e),{init:function(e){(t=e).onClick.subscribe(i),t.onKeyDown.subscribe(A)},destroy:function(){t&&(t.onClick.unsubscribe(i),t.onKeyDown.unsubscribe(A))},getGroupRowMetadata:function(t){return{selectable:!1,focusable:e.groupFocusable,cssClasses:e.groupCssClass,columns:{0:{colspan:"*",formatter:e.groupFormatter,editor:null}}}},getTotalsRowMetadata:function(t){return{selectable:!1,focusable:e.totalsFocusable,cssClasses:e.totalsCssClass,formatter:e.totalsFormatter,editor:null}}}}}},503:function(e,t,n){t.exports="undefined"!=typeof $?$:e(490)},504:function(e,t,n){var o=e(503),r=e(497);t.exports={RemoteModel:function(){var e=50,t={length:0},n="",i=null,A=1,l=null,a=null,s=new r.Event,c=new r.Event;function u(){for(var e in t)delete t[e];t.length=0}function d(r,u){if(a){a.abort();for(var d=a.fromPage;d<=a.toPage;d++)t[d*e]=void 0}r<0&&(r=0),t.length>0&&(u=Math.min(u,t.length-1));for(var f=Math.floor(r/e),h=Math.floor(u/e);void 0!==t[f*e]&&f<h;)f++;for(;void 0!==t[h*e]&&f<h;)h--;if(f>h||f==h&&void 0!==t[f*e])c.notify({from:r,to:u});else{var g="http://octopart.com/api/v3/parts/search?apikey=68b25f31&include[]=short_description&show[]=uid&show[]=manufacturer&show[]=mpn&show[]=brand&show[]=octopart_url&show[]=short_description&q="+n+"&start="+f*e+"&limit="+((h-f)*e+e);null!=i&&(g+="&sortby="+i+(A>0?"+asc":"+desc")),null!=l&&clearTimeout(l),l=setTimeout(function(){for(var n=f;n<=h;n++)t[n*e]=null;s.notify({from:r,to:u}),(a=o.jsonp({url:g,callbackParameter:"callback",cache:!0,success:p,error:function(){!function(e,t){alert("error loading pages "+e+" to "+t)}(f,h)}})).fromPage=f,a.toPage=h},50)}}function p(e){var n=e.request.start,o=n+e.results.length;t.length=Math.min(parseInt(e.hits),1e3);for(var r=0;r<e.results.length;r++){var i=e.results[r].item;t[n+r]=i,t[n+r].index=n+r}a=null,c.notify({from:n,to:o})}return{data:t,clear:u,isDataLoaded:function(e,n){for(var o=e;o<=n;o++)if(null==t[o]||null==t[o])return!1;return!0},ensureData:d,reloadData:function(e,n){for(var o=e;o<=n;o++)delete t[o];d(e,n)},setSort:function(e,t){i=e,A=t,u()},setSearch:function(e){n=e,u()},onDataLoading:s,onDataLoaded:c}}}},505:function(e,t,n){var o=e(506),r=o.template;function i(e,t,n){return r(e,t,n)}i._=o,t.exports=i,"function"==typeof define&&define.amd?define(function(){return i}):"undefined"==typeof window&&"undefined"==typeof navigator||(window.UnderscoreTemplate=i)},506:function(e,t,n){
//     (c) 2009-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
var o={},r=Array.prototype,i=Object.prototype,A=r.slice,l=i.toString,a=i.hasOwnProperty,s=r.forEach,c=Object.keys,u=Array.isArray,d=function(){},p=d.each=d.forEach=function(e,t,n){if(null!=e)if(s&&e.forEach===s)e.forEach(t,n);else if(e.length===+e.length){for(var r=0,i=e.length;r<i;r++)if(t.call(n,e[r],r,e)===o)return}else{var A=d.keys(e);for(r=0,i=A.length;r<i;r++)if(t.call(n,e[A[r]],A[r],e)===o)return}};d.keys=c||function(e){if(e!==Object(e))throw new TypeError("Invalid object");var t=[];for(var n in e)d.has(e,n)&&t.push(n);return t},d.defaults=function(e){return p(A.call(arguments,1),function(t){if(t)for(var n in t)void 0===e[n]&&(e[n]=t[n])}),e},d.isArray=u||function(e){return"[object Array]"===l.call(e)},d.has=function(e,t){if(!d.isArray(t))return null!=e&&a.call(e,t);for(var n=t.length,o=0;o<n;o++){var r=t[o];if(null==e||!a.call(e,r))return!1;e=e[r]}return!!n};var f={escape:{"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;"}},h={escape:new RegExp("["+d.keys(f.escape).join("")+"]","g")};d.each(["escape"],function(e){d[e]=function(t){return null==t?"":(""+t).replace(h[e],function(t){return f[e][t]})}}),d.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var g=/(.)^/,m={"'":"'","\\":"\\","\r":"r","\n":"n","\t":"t","\u2028":"u2028","\u2029":"u2029"},v=/\\|'|\r|\n|\t|\u2028|\u2029/g;d.template=function(e,t,n){var o;n=d.defaults({},n,d.templateSettings);var r=new RegExp([(n.escape||g).source,(n.interpolate||g).source,(n.evaluate||g).source].join("|")+"|$","g"),i=0,A="__p+='";e.replace(r,function(t,n,o,r,l){return A+=e.slice(i,l).replace(v,function(e){return"\\"+m[e]}),n&&(A+="'+\n((__t=("+n+"))==null?'':_.escape(__t))+\n'"),o&&(A+="'+\n((__t=("+o+"))==null?'':__t)+\n'"),r&&(A+="';\n"+r+"\n__p+='"),i=l+t.length,t}),A+="';\n",n.variable||(A="with(obj||{}){\n"+A+"}\n"),A="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+A+"return __p;\n";try{o=new Function(n.variable||"obj","_",A)}catch(e){throw e.source=A,e}if(t)return o(t,d);var l=function(e){return o.call(this,e,d)};return l.source="function("+(n.variable||"obj")+"){\n"+A+"}",l},t.exports=d}},0,0)});
//# sourceMappingURL=bokeh-tables.min.js.map