"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var tick_formatter_1 = require("./tick_formatter");
var templating_1 = require("../../core/util/templating");
var p = require("../../core/properties");
var PrintfTickFormatter = /** @class */ (function (_super) {
    tslib_1.__extends(PrintfTickFormatter, _super);
    function PrintfTickFormatter(attrs) {
        return _super.call(this, attrs) || this;
    }
    PrintfTickFormatter.initClass = function () {
        this.define({
            format: [p.String, '%s'],
        });
    };
    PrintfTickFormatter.prototype.doFormat = function (ticks, _opts) {
        var _this = this;
        return ticks.map(function (tick) { return templating_1.sprintf(_this.format, tick); });
    };
    PrintfTickFormatter.__name__ = "PrintfTickFormatter";
    return PrintfTickFormatter;
}(tick_formatter_1.TickFormatter));
exports.PrintfTickFormatter = PrintfTickFormatter;
PrintfTickFormatter.initClass();
