import { Arrayable } from "../types";
export declare function splice<T>(array: Arrayable<T>, start: number, k?: number, ...items: T[]): Arrayable<T>;
export declare function insert<T>(array: Arrayable<T>, item: T, i: number): Arrayable<T>;
export declare function append<T>(array: Arrayable<T>, item: T): Arrayable<T>;
export declare function prepend<T>(array: Arrayable<T>, item: T): Arrayable<T>;
export declare function indexOf<T>(array: Arrayable<T>, item: T): number;
export declare function map<T, U>(array: Arrayable<T>, fn: (item: T, i: number, array: Arrayable<T>) => U): Arrayable<U>;
export declare function min(array: Arrayable<number>): number;
export declare function min_by<T>(array: Arrayable<T>, key: (item: T) => number): T;
export declare function max(array: Arrayable<number>): number;
export declare function max_by<T>(array: Arrayable<T>, key: (item: T) => number): T;
export declare function sum(array: Arrayable<number>): number;
export declare function every<T>(array: Arrayable<T>, predicate: (item: T) => boolean): boolean;
export declare function some<T>(array: Arrayable<T>, predicate: (item: T) => boolean): boolean;
export declare function index_of<T>(array: Arrayable<T>, value: T): number;
export declare const find_index: <T>(array: Arrayable<T>, predicate: (item: T) => boolean) => number;
export declare const find_last_index: <T>(array: Arrayable<T>, predicate: (item: T) => boolean) => number;
export declare function find<T>(array: Arrayable<T>, predicate: (item: T) => boolean): T | undefined;
export declare function find_last<T>(array: Arrayable<T>, predicate: (item: T) => boolean): T | undefined;
export declare function sorted_index<T>(array: Arrayable<T>, value: T): number;
