/*!
 * Copyright (c) 2012 - 2018, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
!function(a,b){!function(Bokeh){var define;(function(e,t,n){if(null!=Bokeh)return Bokeh.register_plugin(e,{"models/widgets/tables/cell_editors":433,"models/widgets/tables/cell_formatters":434,"models/widgets/tables/data_table":435,"models/widgets/tables/index":436,"models/widgets/tables/main":437,"models/widgets/tables/table_column":438,"models/widgets/tables/table_widget":439,"models/widgets/widget":440},437);throw new Error("Cannot find Bokeh. You have to load it prior to loading plugins.")})({433:function(e,t,n){var o=e(391),r=e(15),i=e(5),l=e(6),s=e(59),a=e(435),c=function(t){function e(e){return t.call(this,o.__assign({model:e.column.model},e))||this}return o.__extends(e,t),Object.defineProperty(e.prototype,"emptyValue",{get:function(){return null},enumerable:!0,configurable:!0}),e.prototype.initialize=function(e){t.prototype.initialize.call(this,e),this.inputEl=this._createInput(),this.defaultValue=null,this.args=e,this.render()},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat("bk-cell-editor")},e.prototype.render=function(){t.prototype.render.call(this),this.args.container.appendChild(this.el),this.el.appendChild(this.inputEl),this.renderEditor(),this.disableNavigation()},e.prototype.renderEditor=function(){},e.prototype.disableNavigation=function(){this.inputEl.addEventListener("keydown",function(e){switch(e.keyCode){case i.Keys.Left:case i.Keys.Right:case i.Keys.Up:case i.Keys.Down:case i.Keys.PageUp:case i.Keys.PageDown:e.stopImmediatePropagation()}})},e.prototype.destroy=function(){this.remove()},e.prototype.focus=function(){this.inputEl.focus()},e.prototype.show=function(){},e.prototype.hide=function(){},e.prototype.position=function(){},e.prototype.getValue=function(){return this.inputEl.value},e.prototype.setValue=function(e){this.inputEl.value=e},e.prototype.serializeValue=function(){return this.getValue()},e.prototype.isValueChanged=function(){return!(""==this.getValue()&&null==this.defaultValue)&&this.getValue()!==this.defaultValue},e.prototype.applyValue=function(e,t){var n=this.args.grid.getData(),o=n.index.indexOf(e[a.DTINDEX_NAME]);n.setField(o,this.args.column.field,t)},e.prototype.loadValue=function(e){var t=e[this.args.column.field];this.defaultValue=null!=t?t:this.emptyValue,this.setValue(this.defaultValue)},e.prototype.validateValue=function(e){if(this.args.column.validator){var t=this.args.column.validator(e);if(!t.valid)return t}return{valid:!0,msg:null}},e.prototype.validate=function(){return this.validateValue(this.getValue())},e}(l.DOMView);n.CellEditorView=c;var u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="CellEditor"},t}(s.Model);(n.CellEditor=u).initClass();var d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),Object.defineProperty(e.prototype,"emptyValue",{get:function(){return""},enumerable:!0,configurable:!0}),e.prototype._createInput=function(){return i.input({type:"text"})},e.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},e.prototype.loadValue=function(e){t.prototype.loadValue.call(this,e),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()},e}(c);n.StringEditorView=d;var p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="StringEditor",this.prototype.default_view=d,this.define({completions:[r.Array,[]]})},t}(u);(n.StringEditor=p).initClass();var f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.textarea()},t}(c);n.TextEditorView=f;var h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="TextEditor",this.prototype.default_view=f},t}(u);(n.TextEditor=h).initClass();var g=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.select()},t.prototype.renderEditor=function(){for(var e=0,t=this.model.options;e<t.length;e++){var n=t[e];this.inputEl.appendChild(i.option({value:n},n))}this.focus()},t}(c);n.SelectEditorView=g;var m=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="SelectEditor",this.prototype.default_view=g,this.define({options:[r.Array,[]]})},t}(u);(n.SelectEditor=m).initClass();var v=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"text"})},t}(c);n.PercentEditorView=v;var w=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="PercentEditor",this.prototype.default_view=v},t}(u);(n.PercentEditor=w).initClass();var y=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"checkbox",value:"true"})},t.prototype.renderEditor=function(){this.focus()},t.prototype.loadValue=function(e){this.defaultValue=!!e[this.args.column.field],this.inputEl.checked=this.defaultValue},t.prototype.serializeValue=function(){return this.inputEl.checked},t}(c);n.CheckboxEditorView=y;var C=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="CheckboxEditor",this.prototype.default_view=y},t}(u);(n.CheckboxEditor=C).initClass();var b=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype._createInput=function(){return i.input({type:"text"})},e.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},e.prototype.remove=function(){t.prototype.remove.call(this)},e.prototype.serializeValue=function(){return parseInt(this.getValue(),10)||0},e.prototype.loadValue=function(e){t.prototype.loadValue.call(this,e),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()},e.prototype.validateValue=function(e){return isNaN(e)?{valid:!1,msg:"Please enter a valid integer"}:t.prototype.validateValue.call(this,e)},e}(c);n.IntEditorView=b;var x=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="IntEditor",this.prototype.default_view=b,this.define({step:[r.Number,1]})},t}(u);(n.IntEditor=x).initClass();var R=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype._createInput=function(){return i.input({type:"text"})},e.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},e.prototype.remove=function(){t.prototype.remove.call(this)},e.prototype.serializeValue=function(){return parseFloat(this.getValue())||0},e.prototype.loadValue=function(e){t.prototype.loadValue.call(this,e),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()},e.prototype.validateValue=function(e){return isNaN(e)?{valid:!1,msg:"Please enter a valid number"}:t.prototype.validateValue.call(this,e)},e}(c);n.NumberEditorView=R;var S=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="NumberEditor",this.prototype.default_view=R,this.define({step:[r.Number,.01]})},t}(u);(n.NumberEditor=S).initClass();var E=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"text"})},t}(c);n.TimeEditorView=E;var k=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="TimeEditor",this.prototype.default_view=E},t}(u);(n.TimeEditor=k).initClass();var T=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"text"})},Object.defineProperty(t.prototype,"emptyValue",{get:function(){return new Date},enumerable:!0,configurable:!0}),t.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},t.prototype.destroy=function(){e.prototype.destroy.call(this)},t.prototype.show=function(){e.prototype.show.call(this)},t.prototype.hide=function(){e.prototype.hide.call(this)},t.prototype.position=function(){return e.prototype.position.call(this)},t.prototype.getValue=function(){},t.prototype.setValue=function(e){},t}(c);n.DateEditorView=T;var P=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="DateEditor",this.prototype.default_view=T},t}(u);(n.DateEditor=P).initClass()},434:function(e,t,n){var a=e(391),u=e(361),c=e(449),s=e(390),o=e(15),d=e(5),p=e(44),r=e(59),i=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.prototype.doFormat=function(e,t,n,o,r){return null==n?"":(n+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")},e}(r.Model),l=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.initClass=function(){this.prototype.type="StringFormatter",this.define({font_style:[o.FontStyle,"normal"],text_align:[o.TextAlign,"left"],text_color:[o.Color]})},e.prototype.doFormat=function(e,t,n,o,r){var i=this.font_style,l=this.text_align,s=this.text_color,a=d.div({},null==n?"":""+n);switch(i){case"bold":a.style.fontWeight="bold";break;case"italic":a.style.fontStyle="italic"}return null!=l&&(a.style.textAlign=l),null!=s&&(a.style.color=s),a.outerHTML},e}(n.CellFormatter=i);(n.StringFormatter=l).initClass();var f=function(c){function e(e){return c.call(this,e)||this}return a.__extends(e,c),e.initClass=function(){this.prototype.type="NumberFormatter",this.define({format:[o.String,"0,0"],language:[o.String,"en"],rounding:[o.String,"round"]})},e.prototype.doFormat=function(e,t,n,o,r){var i=this,l=this.format,s=this.language,a=function(){switch(i.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}}();return n=u.format(n,l,s,a),c.prototype.doFormat.call(this,e,t,n,o,r)},e}(l);(n.NumberFormatter=f).initClass();var h=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.initClass=function(){this.prototype.type="BooleanFormatter",this.define({icon:[o.String,"check"]})},e.prototype.doFormat=function(e,t,n,o,r){return n?d.i({class:this.icon}).outerHTML:""},e}(i);(n.BooleanFormatter=h).initClass();var g=function(l){function e(e){return l.call(this,e)||this}return a.__extends(e,l),e.initClass=function(){this.prototype.type="DateFormatter",this.define({format:[o.String,"ISO-8601"]})},e.prototype.getFormat=function(){switch(this.format){case"ATOM":case"W3C":case"RFC-3339":case"ISO-8601":return"%Y-%m-%d";case"COOKIE":return"%a, %d %b %Y";case"RFC-850":return"%A, %d-%b-%y";case"RFC-1123":case"RFC-2822":return"%a, %e %b %Y";case"RSS":case"RFC-822":case"RFC-1036":return"%a, %e %b %y";case"TIMESTAMP":return;default:return this.format}},e.prototype.doFormat=function(e,t,n,o,r){n=p.isString(n)?parseInt(n,10):n;var i=s(n,this.getFormat());return l.prototype.doFormat.call(this,e,t,i,o,r)},e}(i);(n.DateFormatter=g).initClass();var m=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.initClass=function(){this.prototype.type="HTMLTemplateFormatter",this.define({template:[o.String,"<%= value %>"]})},e.prototype.doFormat=function(e,t,n,o,r){var i=this.template;if(null==n)return"";var l=c(i),s=a.__assign({},r,{value:n});return l(s)},e}(i);(n.HTMLTemplateFormatter=m).initClass()},435:function(e,t,i){var o=e(391),s=e(447).Grid,a=e(445).RowSelectionModel,c=e(444).CheckboxSelectColumn,r=e(15),n=e(38),l=e(21),u=e(32),d=e(14),p=e(439),f=e(440);i.DTINDEX_NAME="__bkdt_internal_index__";var h=function(){function e(e,t){if(this.source=e,this.view=t,i.DTINDEX_NAME in this.source.data)throw new Error("special name "+i.DTINDEX_NAME+" cannot be used as a data table column");this.index=this.view.indices}return e.prototype.getLength=function(){return this.index.length},e.prototype.getItem=function(e){for(var t={},n=0,o=u.keys(this.source.data);n<o.length;n++){var r=o[n];t[r]=this.source.data[r][this.index[e]]}return t[i.DTINDEX_NAME]=this.index[e],t},e.prototype.getField=function(e,t){return t==i.DTINDEX_NAME?this.index[e]:this.source.data[t][this.index[e]]},e.prototype.setField=function(e,t,n){var o={},r=this.index[e];o[t]=[[r,n]],this.source.patch(o)},e.prototype.getItemMetadata=function(e){return null},e.prototype.getRecords=function(){var t=this;return l.range(0,this.getLength()).map(function(e){return t.getItem(e)})},e.prototype.sort=function(e){var u=e.map(function(e){return[e.sortCol.field,e.sortAsc?1:-1]});0==u.length&&(u=[[i.DTINDEX_NAME,1]]);var d=this.getRecords(),p=this.index.slice();this.index.sort(function(e,t){for(var n=0,o=u;n<o.length;n++){var r=o[n],i=r[0],l=r[1],s=d[p.indexOf(e)][i],a=d[p.indexOf(t)][i],c=s==a?0:a<s?l:-l;if(0!=c)return c}return 0})},e}();i.DataProvider=h;var g=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._in_selection_update=!1,e._warned_not_reorderable=!1,e}return o.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.render()}),this.connect(this.model.source.streaming,function(){return e.updateGrid()}),this.connect(this.model.source.patching,function(){return e.updateGrid()}),this.connect(this.model.source.change,function(){return e.updateGrid()}),this.connect(this.model.source.properties.data.change,function(){return e.updateGrid()}),this.connect(this.model.source.selected.change,function(){return e.updateSelection()}),this.connect(this.model.source.selected.properties.indices.change,function(){return e.updateSelection()})},e.prototype.updateGrid=function(){var t=this;this.model.view.compute_indices(),this.data.constructor(this.model.source,this.model.view);var n=this.grid.getColumns(),e=this.grid.getSortColumns().map(function(e){return{sortCol:{field:n[t.grid.getColumnIndex(e.columnId)].field},sortAsc:e.sortAsc}});this.data.sort(e),this.grid.invalidate(),this.grid.render()},e.prototype.updateSelection=function(){var t=this;if(!this._in_selection_update){var e=this.model.source.selected,n=e.indices.map(function(e){return t.data.index.indexOf(e)});this._in_selection_update=!0,this.grid.setSelectedRows(n),this._in_selection_update=!1;var o=this.grid.getViewport(),r=this.model.get_scroll_index(o,n);null!=r&&this.grid.scrollRowToTop(r)}},e.prototype.newIndexColumn=function(){return{id:n.uniqueId(),name:this.model.index_header,field:i.DTINDEX_NAME,width:this.model.index_width,behavior:"select",cannotTriggerInsert:!0,resizable:!1,selectable:!1,sortable:!0,cssClass:"bk-cell-index",headerCssClass:"bk-header-index"}},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat("bk-data-table")},e.prototype.render=function(){var e,n=this,o=this.model.columns.map(function(e){return e.toColumn()});if("checkbox"==this.model.selectable&&(e=new c({cssClass:"bk-cell-select"}),o.unshift(e.getColumnDefinition())),null!=this.model.index_position){var t=this.model.index_position,r=this.newIndexColumn();-1==t?o.push(r):t<-1?o.splice(t+1,0,r):o.splice(t,0,r)}var i=this.model.reorderable;!i||"undefined"!=typeof $&&null!=$.fn&&null!=$.fn.sortable||(this._warned_not_reorderable||(d.logger.warn("jquery-ui is required to enable DataTable.reorderable"),this._warned_not_reorderable=!0),i=!1);var l={enableCellNavigation:!1!==this.model.selectable,enableColumnReorder:i,forceFitColumns:this.model.fit_columns,autoHeight:"auto"==this.model.height,multiColumnSort:this.model.sortable,editable:this.model.editable,autoEdit:!1,rowHeight:this.model.row_height};null!=this.model.width?this.el.style.width=this.model.width+"px":this.el.style.width=this.model.default_width+"px",null!=this.model.height&&"auto"!=this.model.height&&(this.el.style.height=this.model.height+"px"),this.data=new h(this.model.source,this.model.view),this.grid=new s(this.el,this.data,o,l),this.grid.onSort.subscribe(function(e,t){o=t.sortCols,n.data.sort(o),n.grid.invalidate(),n.updateSelection(),n.grid.render(),n.model.header_row||n._hide_header()}),!1!==this.model.selectable&&(this.grid.setSelectionModel(new a({selectActiveRow:null==e})),null!=e&&this.grid.registerPlugin(e),this.grid.onSelectedRowsChanged.subscribe(function(e,t){n._in_selection_update||(n.model.source.selected.indices=t.rows.map(function(e){return n.data.index[e]}))}),this.updateSelection(),this.model.header_row||this._hide_header())},e.prototype._hide_header=function(){for(var e=0,t=Array.from(this.el.querySelectorAll(".slick-header-columns"));e<t.length;e++){var n=t[e];n.style.height="0px"}this.grid.resizeCanvas()},e}(f.WidgetView);i.DataTableView=g;var m=function(n){function e(e){var t=n.call(this,e)||this;return t.default_width=600,t}return o.__extends(e,n),e.initClass=function(){this.prototype.type="DataTable",this.prototype.default_view=g,this.define({columns:[r.Array,[]],fit_columns:[r.Bool,!0],sortable:[r.Bool,!0],reorderable:[r.Bool,!0],editable:[r.Bool,!1],selectable:[r.Any,!0],index_position:[r.Int,0],index_header:[r.String,"#"],index_width:[r.Int,40],scroll_to_selection:[r.Bool,!0],header_row:[r.Bool,!0],row_height:[r.Int,25]}),this.override({height:400})},e.prototype.get_scroll_index=function(t,e){return this.scroll_to_selection&&0!=e.length?l.any(e,function(e){return t.top<=e&&e<=t.bottom})?null:Math.max(0,Math.min.apply(Math,e)-1):null},e}(p.TableWidget);(i.DataTable=m).initClass()},436:function(e,t,n){var o=e(391);o.__exportStar(e(433),n),o.__exportStar(e(434),n);var r=e(435);n.DataTable=r.DataTable;var i=e(438);n.TableColumn=i.TableColumn;var l=e(439);n.TableWidget=l.TableWidget},437:function(e,t,n){var o=e(436);n.Tables=o;var r=e(0);r.register_models(o)},438:function(e,t,n){var o=e(391),r=e(434),i=e(433),l=e(15),s=e(38),a=e(59),c=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.initClass=function(){this.prototype.type="TableColumn",this.define({field:[l.String],title:[l.String],width:[l.Number,300],formatter:[l.Instance,function(){return new r.StringFormatter}],editor:[l.Instance,function(){return new i.StringEditor}],sortable:[l.Bool,!0],default_sort:[l.String,"ascending"]})},e.prototype.toColumn=function(){return{id:s.uniqueId(),field:this.field,name:this.title,width:this.width,formatter:null!=this.formatter?this.formatter.doFormat.bind(this.formatter):void 0,model:this.editor,editor:this.editor.default_view,sortable:this.sortable,defaultSortAsc:"ascending"==this.default_sort}},e}(a.Model);(n.TableColumn=c).initClass()},439:function(e,t,n){var o=e(391),r=e(440),i=e(199),l=e(15),s=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.initClass=function(){this.prototype.type="TableWidget",this.define({source:[l.Instance],view:[l.Instance,function(){return new i.CDSView}]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),null==this.view.source&&(this.view.source=this.source,this.view.compute_indices())},e}(r.Widget);(n.TableWidget=s).initClass()},440:function(e,t,n){var o=e(391),r=e(157),i=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype.css_classes=function(){return e.prototype.css_classes.call(this).concat("bk-widget")},t.prototype.render=function(){this._render_classes(),null!=this.model.height&&(this.el.style.height=this.model.height+"px"),null!=this.model.width&&(this.el.style.width=this.model.width+"px")},t.prototype.get_width=function(){throw new Error("unused")},t.prototype.get_height=function(){throw new Error("unused")},t}(r.LayoutDOMView);n.WidgetView=i;var l=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.initClass=function(){this.prototype.type="Widget"},e}(r.LayoutDOM);(n.Widget=l).initClass()},441:function(e,n,t){
/*!
     * jQuery JavaScript Library v3.2.1
     * https://jquery.com/
     *
     * Includes Sizzle.js
     * https://sizzlejs.com/
     *
     * Copyright JS Foundation and other contributors
     * Released under the MIT license
     * https://jquery.org/license
     *
     * Date: 2017-03-20T18:59Z
     */
!function(e,t){"use strict";"object"==typeof n&&"object"==typeof n.exports?n.exports=e.document?t(e,!0):function(e){if(!e.document)throw new Error("jQuery requires a window with a document");return t(e)}:t(e)}("undefined"!=typeof window?window:this,function(R,e){"use strict";var t=[],S=R.document,o=Object.getPrototypeOf,s=t.slice,g=t.concat,a=t.push,r=t.indexOf,n={},i=n.toString,h=n.hasOwnProperty,l=h.toString,c=l.call(Object),m={};function v(e,t){var n=(t=t||S).createElement("script");n.text=e,t.head.appendChild(n).parentNode.removeChild(n)}var E=function(e,t){return new E.fn.init(e,t)},u=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,d=/^-ms-/,p=/-([a-z])/g,f=function(e,t){return t.toUpperCase()};function w(e){var t=!!e&&"length"in e&&e.length,n=E.type(e);return"function"!==n&&!E.isWindow(e)&&("array"===n||0===t||"number"==typeof t&&0<t&&t-1 in e)}E.fn=E.prototype={jquery:"3.2.1",constructor:E,length:0,toArray:function(){return s.call(this)},get:function(e){return null==e?s.call(this):e<0?this[e+this.length]:this[e]},pushStack:function(e){var t=E.merge(this.constructor(),e);return t.prevObject=this,t},each:function(e){return E.each(this,e)},map:function(n){return this.pushStack(E.map(this,function(e,t){return n.call(e,t,e)}))},slice:function(){return this.pushStack(s.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(e){var t=this.length,n=+e+(e<0?t:0);return this.pushStack(0<=n&&n<t?[this[n]]:[])},end:function(){return this.prevObject||this.constructor()},push:a,sort:t.sort,splice:t.splice},E.extend=E.fn.extend=function(){var e,t,n,o,r,i,l=arguments[0]||{},s=1,a=arguments.length,c=!1;for("boolean"==typeof l&&(c=l,l=arguments[s]||{},s++),"object"==typeof l||E.isFunction(l)||(l={}),s===a&&(l=this,s--);s<a;s++)if(null!=(e=arguments[s]))for(t in e)n=l[t],o=e[t],l!==o&&(c&&o&&(E.isPlainObject(o)||(r=Array.isArray(o)))?(r?(r=!1,i=n&&Array.isArray(n)?n:[]):i=n&&E.isPlainObject(n)?n:{},l[t]=E.extend(c,i,o)):void 0!==o&&(l[t]=o));return l},E.extend({expando:"jQuery"+("3.2.1"+Math.random()).replace(/\D/g,""),isReady:!0,error:function(e){throw new Error(e)},noop:function(){},isFunction:function(e){return"function"===E.type(e)},isWindow:function(e){return null!=e&&e===e.window},isNumeric:function(e){var t=E.type(e);return("number"===t||"string"===t)&&!isNaN(e-parseFloat(e))},isPlainObject:function(e){var t,n;return!(!e||"[object Object]"!==i.call(e))&&(!(t=o(e))||"function"==typeof(n=h.call(t,"constructor")&&t.constructor)&&l.call(n)===c)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},type:function(e){return null==e?e+"":"object"==typeof e||"function"==typeof e?n[i.call(e)]||"object":typeof e},globalEval:function(e){v(e)},camelCase:function(e){return e.replace(d,"ms-").replace(p,f)},each:function(e,t){var n,o=0;if(w(e))for(n=e.length;o<n&&!1!==t.call(e[o],o,e[o]);o++);else for(o in e)if(!1===t.call(e[o],o,e[o]))break;return e},trim:function(e){return null==e?"":(e+"").replace(u,"")},makeArray:function(e,t){var n=t||[];return null!=e&&(w(Object(e))?E.merge(n,"string"==typeof e?[e]:e):a.call(n,e)),n},inArray:function(e,t,n){return null==t?-1:r.call(t,e,n)},merge:function(e,t){for(var n=+t.length,o=0,r=e.length;o<n;o++)e[r++]=t[o];return e.length=r,e},grep:function(e,t,n){for(var o=[],r=0,i=e.length,l=!n;r<i;r++)!t(e[r],r)!==l&&o.push(e[r]);return o},map:function(e,t,n){var o,r,i=0,l=[];if(w(e))for(o=e.length;i<o;i++)null!=(r=t(e[i],i,n))&&l.push(r);else for(i in e)null!=(r=t(e[i],i,n))&&l.push(r);return g.apply([],l)},guid:1,proxy:function(e,t){var n,o,r;if("string"==typeof t&&(n=e[t],t=e,e=n),E.isFunction(e))return o=s.call(arguments,2),(r=function(){return e.apply(t||this,o.concat(s.call(arguments)))}).guid=e.guid=e.guid||E.guid++,r},now:Date.now,support:m}),"function"==typeof Symbol&&(E.fn[Symbol.iterator]=t[Symbol.iterator]),E.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(e,t){n["[object "+t+"]"]=t.toLowerCase()});var y=
/*!
         * Sizzle CSS Selector Engine v2.3.3
         * https://sizzlejs.com/
         *
         * Copyright jQuery Foundation and other contributors
         * Released under the MIT license
         * http://jquery.org/license
         *
         * Date: 2016-08-08
         */
function(n){var e,f,C,i,r,h,d,g,b,a,c,x,R,l,S,m,s,u,v,E="sizzle"+1*new Date,w=n.document,k=0,o=0,p=le(),y=le(),T=le(),P=function(e,t){return e===t&&(c=!0),0},D={}.hasOwnProperty,t=[],A=t.pop,N=t.push,$=t.push,H=t.slice,L=function(e,t){for(var n=0,o=e.length;n<o;n++)if(e[n]===t)return n;return-1},_="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",F="[\\x20\\t\\r\\n\\f]",I="(?:\\\\.|[\\w-]|[^\0-\\xa0])+",M="\\["+F+"*("+I+")(?:"+F+"*([*^$|!~]?=)"+F+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+I+"))|)"+F+"*\\]",W=":("+I+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+M+")*)|.*)\\)|)",j=new RegExp(F+"+","g"),V=new RegExp("^"+F+"+|((?:^|[^\\\\])(?:\\\\.)*)"+F+"+$","g"),B=new RegExp("^"+F+"*,"+F+"*"),q=new RegExp("^"+F+"*([>+~]|"+F+")"+F+"*"),O=new RegExp("="+F+"*([^\\]'\"]*?)"+F+"*\\]","g"),z=new RegExp(W),X=new RegExp("^"+I+"$"),U={ID:new RegExp("^#("+I+")"),CLASS:new RegExp("^\\.("+I+")"),TAG:new RegExp("^("+I+"|[*])"),ATTR:new RegExp("^"+M),PSEUDO:new RegExp("^"+W),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+F+"*(even|odd|(([+-]|)(\\d*)n|)"+F+"*(?:([+-]|)"+F+"*(\\d+)|))"+F+"*\\)|)","i"),bool:new RegExp("^(?:"+_+")$","i"),needsContext:new RegExp("^"+F+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+F+"*((?:-\\d)?\\d*)"+F+"*\\)|)(?=[^-]|$)","i")},K=/^(?:input|select|textarea|button)$/i,G=/^h\d$/i,Y=/^[^{]+\{\s*\[native \w/,Q=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,J=/[+~]/,Z=new RegExp("\\\\([\\da-f]{1,6}"+F+"?|("+F+")|.)","ig"),ee=function(e,t,n){var o="0x"+t-65536;return o!=o||n?t:o<0?String.fromCharCode(o+65536):String.fromCharCode(o>>10|55296,1023&o|56320)},te=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,ne=function(e,t){return t?"\0"===e?"�":e.slice(0,-1)+"\\"+e.charCodeAt(e.length-1).toString(16)+" ":"\\"+e},oe=function(){x()},re=we(function(e){return!0===e.disabled&&("form"in e||"label"in e)},{dir:"parentNode",next:"legend"});try{$.apply(t=H.call(w.childNodes),w.childNodes),t[w.childNodes.length].nodeType}catch(e){$={apply:t.length?function(e,t){N.apply(e,H.call(t))}:function(e,t){for(var n=e.length,o=0;e[n++]=t[o++];);e.length=n-1}}}function ie(e,t,n,o){var r,i,l,s,a,c,u,d=t&&t.ownerDocument,p=t?t.nodeType:9;if(n=n||[],"string"!=typeof e||!e||1!==p&&9!==p&&11!==p)return n;if(!o&&((t?t.ownerDocument||t:w)!==R&&x(t),t=t||R,S)){if(11!==p&&(a=Q.exec(e)))if(r=a[1]){if(9===p){if(!(l=t.getElementById(r)))return n;if(l.id===r)return n.push(l),n}else if(d&&(l=d.getElementById(r))&&v(t,l)&&l.id===r)return n.push(l),n}else{if(a[2])return $.apply(n,t.getElementsByTagName(e)),n;if((r=a[3])&&f.getElementsByClassName&&t.getElementsByClassName)return $.apply(n,t.getElementsByClassName(r)),n}if(f.qsa&&!T[e+" "]&&(!m||!m.test(e))){if(1!==p)d=t,u=e;else if("object"!==t.nodeName.toLowerCase()){for((s=t.getAttribute("id"))?s=s.replace(te,ne):t.setAttribute("id",s=E),c=h(e),i=c.length;i--;)c[i]="#"+s+" "+ve(c[i]);u=c.join(","),d=J.test(e)&&ge(t.parentNode)||t}if(u)try{return $.apply(n,d.querySelectorAll(u)),n}catch(e){}finally{s===E&&t.removeAttribute("id")}}}return g(e.replace(V,"$1"),t,n,o)}function le(){var o=[];return function e(t,n){o.push(t+" ")>C.cacheLength&&delete e[o.shift()];return e[t+" "]=n}}function se(e){return e[E]=!0,e}function ae(e){var t=R.createElement("fieldset");try{return!!e(t)}catch(e){return!1}finally{t.parentNode&&t.parentNode.removeChild(t),t=null}}function ce(e,t){for(var n=e.split("|"),o=n.length;o--;)C.attrHandle[n[o]]=t}function ue(e,t){var n=t&&e,o=n&&1===e.nodeType&&1===t.nodeType&&e.sourceIndex-t.sourceIndex;if(o)return o;if(n)for(;n=n.nextSibling;)if(n===t)return-1;return e?1:-1}function de(n){return function(e){var t=e.nodeName.toLowerCase();return"input"===t&&e.type===n}}function pe(n){return function(e){var t=e.nodeName.toLowerCase();return("input"===t||"button"===t)&&e.type===n}}function fe(t){return function(e){return"form"in e?e.parentNode&&!1===e.disabled?"label"in e?"label"in e.parentNode?e.parentNode.disabled===t:e.disabled===t:e.isDisabled===t||e.isDisabled!==!t&&re(e)===t:e.disabled===t:"label"in e&&e.disabled===t}}function he(l){return se(function(i){return i=+i,se(function(e,t){for(var n,o=l([],e.length,i),r=o.length;r--;)e[n=o[r]]&&(e[n]=!(t[n]=e[n]))})})}function ge(e){return e&&void 0!==e.getElementsByTagName&&e}for(e in f=ie.support={},r=ie.isXML=function(e){var t=e&&(e.ownerDocument||e).documentElement;return!!t&&"HTML"!==t.nodeName},x=ie.setDocument=function(e){var t,n,o=e?e.ownerDocument||e:w;return o!==R&&9===o.nodeType&&o.documentElement&&(l=(R=o).documentElement,S=!r(R),w!==R&&(n=R.defaultView)&&n.top!==n&&(n.addEventListener?n.addEventListener("unload",oe,!1):n.attachEvent&&n.attachEvent("onunload",oe)),f.attributes=ae(function(e){return e.className="i",!e.getAttribute("className")}),f.getElementsByTagName=ae(function(e){return e.appendChild(R.createComment("")),!e.getElementsByTagName("*").length}),f.getElementsByClassName=Y.test(R.getElementsByClassName),f.getById=ae(function(e){return l.appendChild(e).id=E,!R.getElementsByName||!R.getElementsByName(E).length}),f.getById?(C.filter.ID=function(e){var t=e.replace(Z,ee);return function(e){return e.getAttribute("id")===t}},C.find.ID=function(e,t){if(void 0!==t.getElementById&&S){var n=t.getElementById(e);return n?[n]:[]}}):(C.filter.ID=function(e){var n=e.replace(Z,ee);return function(e){var t=void 0!==e.getAttributeNode&&e.getAttributeNode("id");return t&&t.value===n}},C.find.ID=function(e,t){if(void 0!==t.getElementById&&S){var n,o,r,i=t.getElementById(e);if(i){if((n=i.getAttributeNode("id"))&&n.value===e)return[i];for(r=t.getElementsByName(e),o=0;i=r[o++];)if((n=i.getAttributeNode("id"))&&n.value===e)return[i]}return[]}}),C.find.TAG=f.getElementsByTagName?function(e,t){return void 0!==t.getElementsByTagName?t.getElementsByTagName(e):f.qsa?t.querySelectorAll(e):void 0}:function(e,t){var n,o=[],r=0,i=t.getElementsByTagName(e);if("*"===e){for(;n=i[r++];)1===n.nodeType&&o.push(n);return o}return i},C.find.CLASS=f.getElementsByClassName&&function(e,t){if(void 0!==t.getElementsByClassName&&S)return t.getElementsByClassName(e)},s=[],m=[],(f.qsa=Y.test(R.querySelectorAll))&&(ae(function(e){l.appendChild(e).innerHTML="<a id='"+E+"'></a><select id='"+E+"-\r\\' msallowcapture=''><option selected=''></option></select>",e.querySelectorAll("[msallowcapture^='']").length&&m.push("[*^$]="+F+"*(?:''|\"\")"),e.querySelectorAll("[selected]").length||m.push("\\["+F+"*(?:value|"+_+")"),e.querySelectorAll("[id~="+E+"-]").length||m.push("~="),e.querySelectorAll(":checked").length||m.push(":checked"),e.querySelectorAll("a#"+E+"+*").length||m.push(".#.+[+~]")}),ae(function(e){e.innerHTML="<a href='' disabled='disabled'></a><select disabled='disabled'><option/></select>";var t=R.createElement("input");t.setAttribute("type","hidden"),e.appendChild(t).setAttribute("name","D"),e.querySelectorAll("[name=d]").length&&m.push("name"+F+"*[*^$|!~]?="),2!==e.querySelectorAll(":enabled").length&&m.push(":enabled",":disabled"),l.appendChild(e).disabled=!0,2!==e.querySelectorAll(":disabled").length&&m.push(":enabled",":disabled"),e.querySelectorAll("*,:x"),m.push(",.*:")})),(f.matchesSelector=Y.test(u=l.matches||l.webkitMatchesSelector||l.mozMatchesSelector||l.oMatchesSelector||l.msMatchesSelector))&&ae(function(e){f.disconnectedMatch=u.call(e,"*"),u.call(e,"[s!='']:x"),s.push("!=",W)}),m=m.length&&new RegExp(m.join("|")),s=s.length&&new RegExp(s.join("|")),t=Y.test(l.compareDocumentPosition),v=t||Y.test(l.contains)?function(e,t){var n=9===e.nodeType?e.documentElement:e,o=t&&t.parentNode;return e===o||!(!o||1!==o.nodeType||!(n.contains?n.contains(o):e.compareDocumentPosition&&16&e.compareDocumentPosition(o)))}:function(e,t){if(t)for(;t=t.parentNode;)if(t===e)return!0;return!1},P=t?function(e,t){if(e===t)return c=!0,0;var n=!e.compareDocumentPosition-!t.compareDocumentPosition;return n||(1&(n=(e.ownerDocument||e)===(t.ownerDocument||t)?e.compareDocumentPosition(t):1)||!f.sortDetached&&t.compareDocumentPosition(e)===n?e===R||e.ownerDocument===w&&v(w,e)?-1:t===R||t.ownerDocument===w&&v(w,t)?1:a?L(a,e)-L(a,t):0:4&n?-1:1)}:function(e,t){if(e===t)return c=!0,0;var n,o=0,r=e.parentNode,i=t.parentNode,l=[e],s=[t];if(!r||!i)return e===R?-1:t===R?1:r?-1:i?1:a?L(a,e)-L(a,t):0;if(r===i)return ue(e,t);for(n=e;n=n.parentNode;)l.unshift(n);for(n=t;n=n.parentNode;)s.unshift(n);for(;l[o]===s[o];)o++;return o?ue(l[o],s[o]):l[o]===w?-1:s[o]===w?1:0}),R},ie.matches=function(e,t){return ie(e,null,null,t)},ie.matchesSelector=function(e,t){if((e.ownerDocument||e)!==R&&x(e),t=t.replace(O,"='$1']"),f.matchesSelector&&S&&!T[t+" "]&&(!s||!s.test(t))&&(!m||!m.test(t)))try{var n=u.call(e,t);if(n||f.disconnectedMatch||e.document&&11!==e.document.nodeType)return n}catch(e){}return 0<ie(t,R,null,[e]).length},ie.contains=function(e,t){return(e.ownerDocument||e)!==R&&x(e),v(e,t)},ie.attr=function(e,t){(e.ownerDocument||e)!==R&&x(e);var n=C.attrHandle[t.toLowerCase()],o=n&&D.call(C.attrHandle,t.toLowerCase())?n(e,t,!S):void 0;return void 0!==o?o:f.attributes||!S?e.getAttribute(t):(o=e.getAttributeNode(t))&&o.specified?o.value:null},ie.escape=function(e){return(e+"").replace(te,ne)},ie.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e)},ie.uniqueSort=function(e){var t,n=[],o=0,r=0;if(c=!f.detectDuplicates,a=!f.sortStable&&e.slice(0),e.sort(P),c){for(;t=e[r++];)t===e[r]&&(o=n.push(r));for(;o--;)e.splice(n[o],1)}return a=null,e},i=ie.getText=function(e){var t,n="",o=0,r=e.nodeType;if(r){if(1===r||9===r||11===r){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=i(e)}else if(3===r||4===r)return e.nodeValue}else for(;t=e[o++];)n+=i(t);return n},(C=ie.selectors={cacheLength:50,createPseudo:se,match:U,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(Z,ee),e[3]=(e[3]||e[4]||e[5]||"").replace(Z,ee),"~="===e[2]&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),"nth"===e[1].slice(0,3)?(e[3]||ie.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*("even"===e[3]||"odd"===e[3])),e[5]=+(e[7]+e[8]||"odd"===e[3])):e[3]&&ie.error(e[0]),e},PSEUDO:function(e){var t,n=!e[6]&&e[2];return U.CHILD.test(e[0])?null:(e[3]?e[2]=e[4]||e[5]||"":n&&z.test(n)&&(t=h(n,!0))&&(t=n.indexOf(")",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){var t=e.replace(Z,ee).toLowerCase();return"*"===e?function(){return!0}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=p[e+" "];return t||(t=new RegExp("(^|"+F+")"+e+"("+F+"|$)"))&&p(e,function(e){return t.test("string"==typeof e.className&&e.className||void 0!==e.getAttribute&&e.getAttribute("class")||"")})},ATTR:function(n,o,r){return function(e){var t=ie.attr(e,n);return null==t?"!="===o:!o||(t+="","="===o?t===r:"!="===o?t!==r:"^="===o?r&&0===t.indexOf(r):"*="===o?r&&-1<t.indexOf(r):"$="===o?r&&t.slice(-r.length)===r:"~="===o?-1<(" "+t.replace(j," ")+" ").indexOf(r):"|="===o&&(t===r||t.slice(0,r.length+1)===r+"-"))}},CHILD:function(h,e,t,g,m){var v="nth"!==h.slice(0,3),w="last"!==h.slice(-4),y="of-type"===e;return 1===g&&0===m?function(e){return!!e.parentNode}:function(e,t,n){var o,r,i,l,s,a,c=v!==w?"nextSibling":"previousSibling",u=e.parentNode,d=y&&e.nodeName.toLowerCase(),p=!n&&!y,f=!1;if(u){if(v){for(;c;){for(l=e;l=l[c];)if(y?l.nodeName.toLowerCase()===d:1===l.nodeType)return!1;a=c="only"===h&&!a&&"nextSibling"}return!0}if(a=[w?u.firstChild:u.lastChild],w&&p){for(i=(l=u)[E]||(l[E]={}),r=i[l.uniqueID]||(i[l.uniqueID]={}),o=r[h]||[],s=o[0]===k&&o[1],f=s&&o[2],l=s&&u.childNodes[s];l=++s&&l&&l[c]||(f=s=0)||a.pop();)if(1===l.nodeType&&++f&&l===e){r[h]=[k,s,f];break}}else if(p&&(i=(l=e)[E]||(l[E]={}),r=i[l.uniqueID]||(i[l.uniqueID]={}),o=r[h]||[],s=o[0]===k&&o[1],f=s),!1===f)for(;(l=++s&&l&&l[c]||(f=s=0)||a.pop())&&((y?l.nodeName.toLowerCase()!==d:1!==l.nodeType)||!++f||(p&&(i=l[E]||(l[E]={}),(r=i[l.uniqueID]||(i[l.uniqueID]={}))[h]=[k,f]),l!==e)););return(f-=m)===g||f%g==0&&0<=f/g}}},PSEUDO:function(e,i){var t,l=C.pseudos[e]||C.setFilters[e.toLowerCase()]||ie.error("unsupported pseudo: "+e);return l[E]?l(i):1<l.length?(t=[e,e,"",i],C.setFilters.hasOwnProperty(e.toLowerCase())?se(function(e,t){for(var n,o=l(e,i),r=o.length;r--;)n=L(e,o[r]),e[n]=!(t[n]=o[r])}):function(e){return l(e,0,t)}):l}},pseudos:{not:se(function(e){var o=[],r=[],s=d(e.replace(V,"$1"));return s[E]?se(function(e,t,n,o){for(var r,i=s(e,null,o,[]),l=e.length;l--;)(r=i[l])&&(e[l]=!(t[l]=r))}):function(e,t,n){return o[0]=e,s(o,null,n,r),o[0]=null,!r.pop()}}),has:se(function(t){return function(e){return 0<ie(t,e).length}}),contains:se(function(t){return t=t.replace(Z,ee),function(e){return-1<(e.textContent||e.innerText||i(e)).indexOf(t)}}),lang:se(function(n){return X.test(n||"")||ie.error("unsupported lang: "+n),n=n.replace(Z,ee).toLowerCase(),function(e){var t;do{if(t=S?e.lang:e.getAttribute("xml:lang")||e.getAttribute("lang"))return(t=t.toLowerCase())===n||0===t.indexOf(n+"-")}while((e=e.parentNode)&&1===e.nodeType);return!1}}),target:function(e){var t=n.location&&n.location.hash;return t&&t.slice(1)===e.id},root:function(e){return e===l},focus:function(e){return e===R.activeElement&&(!R.hasFocus||R.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:fe(!1),disabled:fe(!0),checked:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&!!e.checked||"option"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,!0===e.selected},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeType<6)return!1;return!0},parent:function(e){return!C.pseudos.empty(e)},header:function(e){return G.test(e.nodeName)},input:function(e){return K.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&"button"===e.type||"button"===t},text:function(e){var t;return"input"===e.nodeName.toLowerCase()&&"text"===e.type&&(null==(t=e.getAttribute("type"))||"text"===t.toLowerCase())},first:he(function(){return[0]}),last:he(function(e,t){return[t-1]}),eq:he(function(e,t,n){return[n<0?n+t:n]}),even:he(function(e,t){for(var n=0;n<t;n+=2)e.push(n);return e}),odd:he(function(e,t){for(var n=1;n<t;n+=2)e.push(n);return e}),lt:he(function(e,t,n){for(var o=n<0?n+t:n;0<=--o;)e.push(o);return e}),gt:he(function(e,t,n){for(var o=n<0?n+t:n;++o<t;)e.push(o);return e})}}).pseudos.nth=C.pseudos.eq,{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})C.pseudos[e]=de(e);for(e in{submit:!0,reset:!0})C.pseudos[e]=pe(e);function me(){}function ve(e){for(var t=0,n=e.length,o="";t<n;t++)o+=e[t].value;return o}function we(s,e,t){var a=e.dir,c=e.next,u=c||a,d=t&&"parentNode"===u,p=o++;return e.first?function(e,t,n){for(;e=e[a];)if(1===e.nodeType||d)return s(e,t,n);return!1}:function(e,t,n){var o,r,i,l=[k,p];if(n){for(;e=e[a];)if((1===e.nodeType||d)&&s(e,t,n))return!0}else for(;e=e[a];)if(1===e.nodeType||d)if(i=e[E]||(e[E]={}),r=i[e.uniqueID]||(i[e.uniqueID]={}),c&&c===e.nodeName.toLowerCase())e=e[a]||e;else{if((o=r[u])&&o[0]===k&&o[1]===p)return l[2]=o[2];if((r[u]=l)[2]=s(e,t,n))return!0}return!1}}function ye(r){return 1<r.length?function(e,t,n){for(var o=r.length;o--;)if(!r[o](e,t,n))return!1;return!0}:r[0]}function Ce(e,t,n,o,r){for(var i,l=[],s=0,a=e.length,c=null!=t;s<a;s++)(i=e[s])&&(n&&!n(i,o,r)||(l.push(i),c&&t.push(s)));return l}function be(f,h,g,m,v,e){return m&&!m[E]&&(m=be(m)),v&&!v[E]&&(v=be(v,e)),se(function(e,t,n,o){var r,i,l,s=[],a=[],c=t.length,u=e||function(e,t,n){for(var o=0,r=t.length;o<r;o++)ie(e,t[o],n);return n}(h||"*",n.nodeType?[n]:n,[]),d=!f||!e&&h?u:Ce(u,s,f,n,o),p=g?v||(e?f:c||m)?[]:t:d;if(g&&g(d,p,n,o),m)for(r=Ce(p,a),m(r,[],n,o),i=r.length;i--;)(l=r[i])&&(p[a[i]]=!(d[a[i]]=l));if(e){if(v||f){if(v){for(r=[],i=p.length;i--;)(l=p[i])&&r.push(d[i]=l);v(null,p=[],r,o)}for(i=p.length;i--;)(l=p[i])&&-1<(r=v?L(e,l):s[i])&&(e[r]=!(t[r]=l))}}else p=Ce(p===t?p.splice(c,p.length):p),v?v(null,t,p,o):$.apply(t,p)})}function xe(e){for(var r,t,n,o=e.length,i=C.relative[e[0].type],l=i||C.relative[" "],s=i?1:0,a=we(function(e){return e===r},l,!0),c=we(function(e){return-1<L(r,e)},l,!0),u=[function(e,t,n){var o=!i&&(n||t!==b)||((r=t).nodeType?a(e,t,n):c(e,t,n));return r=null,o}];s<o;s++)if(t=C.relative[e[s].type])u=[we(ye(u),t)];else{if((t=C.filter[e[s].type].apply(null,e[s].matches))[E]){for(n=++s;n<o&&!C.relative[e[n].type];n++);return be(1<s&&ye(u),1<s&&ve(e.slice(0,s-1).concat({value:" "===e[s-2].type?"*":""})).replace(V,"$1"),t,s<n&&xe(e.slice(s,n)),n<o&&xe(e=e.slice(n)),n<o&&ve(e))}u.push(t)}return ye(u)}return me.prototype=C.filters=C.pseudos,C.setFilters=new me,h=ie.tokenize=function(e,t){var n,o,r,i,l,s,a,c=y[e+" "];if(c)return t?0:c.slice(0);for(l=e,s=[],a=C.preFilter;l;){for(i in n&&!(o=B.exec(l))||(o&&(l=l.slice(o[0].length)||l),s.push(r=[])),n=!1,(o=q.exec(l))&&(n=o.shift(),r.push({value:n,type:o[0].replace(V," ")}),l=l.slice(n.length)),C.filter)!(o=U[i].exec(l))||a[i]&&!(o=a[i](o))||(n=o.shift(),r.push({value:n,type:i,matches:o}),l=l.slice(n.length));if(!n)break}return t?l.length:l?ie.error(e):y(e,s).slice(0)},d=ie.compile=function(e,t){var n,m,v,w,y,o,r=[],i=[],l=T[e+" "];if(!l){for(t||(t=h(e)),n=t.length;n--;)(l=xe(t[n]))[E]?r.push(l):i.push(l);(l=T(e,(m=i,w=0<(v=r).length,y=0<m.length,o=function(e,t,n,o,r){var i,l,s,a=0,c="0",u=e&&[],d=[],p=b,f=e||y&&C.find.TAG("*",r),h=k+=null==p?1:Math.random()||.1,g=f.length;for(r&&(b=t===R||t||r);c!==g&&null!=(i=f[c]);c++){if(y&&i){for(l=0,t||i.ownerDocument===R||(x(i),n=!S);s=m[l++];)if(s(i,t||R,n)){o.push(i);break}r&&(k=h)}w&&((i=!s&&i)&&a--,e&&u.push(i))}if(a+=c,w&&c!==a){for(l=0;s=v[l++];)s(u,d,t,n);if(e){if(0<a)for(;c--;)u[c]||d[c]||(d[c]=A.call(o));d=Ce(d)}$.apply(o,d),r&&!e&&0<d.length&&1<a+v.length&&ie.uniqueSort(o)}return r&&(k=h,b=p),u},w?se(o):o))).selector=e}return l},g=ie.select=function(e,t,n,o){var r,i,l,s,a,c="function"==typeof e&&e,u=!o&&h(e=c.selector||e);if(n=n||[],1===u.length){if(2<(i=u[0]=u[0].slice(0)).length&&"ID"===(l=i[0]).type&&9===t.nodeType&&S&&C.relative[i[1].type]){if(!(t=(C.find.ID(l.matches[0].replace(Z,ee),t)||[])[0]))return n;c&&(t=t.parentNode),e=e.slice(i.shift().value.length)}for(r=U.needsContext.test(e)?0:i.length;r--&&(l=i[r],!C.relative[s=l.type]);)if((a=C.find[s])&&(o=a(l.matches[0].replace(Z,ee),J.test(i[0].type)&&ge(t.parentNode)||t))){if(i.splice(r,1),!(e=o.length&&ve(i)))return $.apply(n,o),n;break}}return(c||d(e,u))(o,t,!S,n,!t||J.test(e)&&ge(t.parentNode)||t),n},f.sortStable=E.split("").sort(P).join("")===E,f.detectDuplicates=!!c,x(),f.sortDetached=ae(function(e){return 1&e.compareDocumentPosition(R.createElement("fieldset"))}),ae(function(e){return e.innerHTML="<a href='#'></a>","#"===e.firstChild.getAttribute("href")})||ce("type|href|height|width",function(e,t,n){if(!n)return e.getAttribute(t,"type"===t.toLowerCase()?1:2)}),f.attributes&&ae(function(e){return e.innerHTML="<input/>",e.firstChild.setAttribute("value",""),""===e.firstChild.getAttribute("value")})||ce("value",function(e,t,n){if(!n&&"input"===e.nodeName.toLowerCase())return e.defaultValue}),ae(function(e){return null==e.getAttribute("disabled")})||ce(_,function(e,t,n){var o;if(!n)return!0===e[t]?t.toLowerCase():(o=e.getAttributeNode(t))&&o.specified?o.value:null}),ie}(R);E.find=y,E.expr=y.selectors,E.expr[":"]=E.expr.pseudos,E.uniqueSort=E.unique=y.uniqueSort,E.text=y.getText,E.isXMLDoc=y.isXML,E.contains=y.contains,E.escapeSelector=y.escape;var C=function(e,t,n){for(var o=[],r=void 0!==n;(e=e[t])&&9!==e.nodeType;)if(1===e.nodeType){if(r&&E(e).is(n))break;o.push(e)}return o},b=function(e,t){for(var n=[];e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n},x=E.expr.match.needsContext;function k(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()}var T=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i,P=/^.[^:#\[\.,]*$/;function D(e,n,o){return E.isFunction(n)?E.grep(e,function(e,t){return!!n.call(e,t,e)!==o}):n.nodeType?E.grep(e,function(e){return e===n!==o}):"string"!=typeof n?E.grep(e,function(e){return-1<r.call(n,e)!==o}):P.test(n)?E.filter(n,e,o):(n=E.filter(n,e),E.grep(e,function(e){return-1<r.call(n,e)!==o&&1===e.nodeType}))}E.filter=function(e,t,n){var o=t[0];return n&&(e=":not("+e+")"),1===t.length&&1===o.nodeType?E.find.matchesSelector(o,e)?[o]:[]:E.find.matches(e,E.grep(t,function(e){return 1===e.nodeType}))},E.fn.extend({find:function(e){var t,n,o=this.length,r=this;if("string"!=typeof e)return this.pushStack(E(e).filter(function(){for(t=0;t<o;t++)if(E.contains(r[t],this))return!0}));for(n=this.pushStack([]),t=0;t<o;t++)E.find(e,r[t],n);return 1<o?E.uniqueSort(n):n},filter:function(e){return this.pushStack(D(this,e||[],!1))},not:function(e){return this.pushStack(D(this,e||[],!0))},is:function(e){return!!D(this,"string"==typeof e&&x.test(e)?E(e):e||[],!1).length}});var A,N=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,$=E.fn.init=function(e,t,n){var o,r;if(!e)return this;if(n=n||A,"string"==typeof e){if(!(o="<"===e[0]&&">"===e[e.length-1]&&3<=e.length?[null,e,null]:N.exec(e))||!o[1]&&t)return!t||t.jquery?(t||n).find(e):this.constructor(t).find(e);if(o[1]){if(t=t instanceof E?t[0]:t,E.merge(this,E.parseHTML(o[1],t&&t.nodeType?t.ownerDocument||t:S,!0)),T.test(o[1])&&E.isPlainObject(t))for(o in t)E.isFunction(this[o])?this[o](t[o]):this.attr(o,t[o]);return this}return(r=S.getElementById(o[2]))&&(this[0]=r,this.length=1),this}return e.nodeType?(this[0]=e,this.length=1,this):E.isFunction(e)?void 0!==n.ready?n.ready(e):e(E):E.makeArray(e,this)};$.prototype=E.fn,A=E(S);var H=/^(?:parents|prev(?:Until|All))/,L={children:!0,contents:!0,next:!0,prev:!0};function _(e,t){for(;(e=e[t])&&1!==e.nodeType;);return e}E.fn.extend({has:function(e){var t=E(e,this),n=t.length;return this.filter(function(){for(var e=0;e<n;e++)if(E.contains(this,t[e]))return!0})},closest:function(e,t){var n,o=0,r=this.length,i=[],l="string"!=typeof e&&E(e);if(!x.test(e))for(;o<r;o++)for(n=this[o];n&&n!==t;n=n.parentNode)if(n.nodeType<11&&(l?-1<l.index(n):1===n.nodeType&&E.find.matchesSelector(n,e))){i.push(n);break}return this.pushStack(1<i.length?E.uniqueSort(i):i)},index:function(e){return e?"string"==typeof e?r.call(E(e),this[0]):r.call(this,e.jquery?e[0]:e):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){return this.pushStack(E.uniqueSort(E.merge(this.get(),E(e,t))))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),E.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return C(e,"parentNode")},parentsUntil:function(e,t,n){return C(e,"parentNode",n)},next:function(e){return _(e,"nextSibling")},prev:function(e){return _(e,"previousSibling")},nextAll:function(e){return C(e,"nextSibling")},prevAll:function(e){return C(e,"previousSibling")},nextUntil:function(e,t,n){return C(e,"nextSibling",n)},prevUntil:function(e,t,n){return C(e,"previousSibling",n)},siblings:function(e){return b((e.parentNode||{}).firstChild,e)},children:function(e){return b(e.firstChild)},contents:function(e){return k(e,"iframe")?e.contentDocument:(k(e,"template")&&(e=e.content||e),E.merge([],e.childNodes))}},function(o,r){E.fn[o]=function(e,t){var n=E.map(this,r,e);return"Until"!==o.slice(-5)&&(t=e),t&&"string"==typeof t&&(n=E.filter(t,n)),1<this.length&&(L[o]||E.uniqueSort(n),H.test(o)&&n.reverse()),this.pushStack(n)}});var F=/[^\x20\t\r\n\f]+/g;function I(e){return e}function M(e){throw e}function W(e,t,n,o){var r;try{e&&E.isFunction(r=e.promise)?r.call(e).done(t).fail(n):e&&E.isFunction(r=e.then)?r.call(e,t,n):t.apply(void 0,[e].slice(o))}catch(e){n.apply(void 0,[e])}}E.Callbacks=function(o){var e,n;o="string"==typeof o?(e=o,n={},E.each(e.match(F)||[],function(e,t){n[t]=!0}),n):E.extend({},o);var r,t,i,l,s=[],a=[],c=-1,u=function(){for(l=l||o.once,i=r=!0;a.length;c=-1)for(t=a.shift();++c<s.length;)!1===s[c].apply(t[0],t[1])&&o.stopOnFalse&&(c=s.length,t=!1);o.memory||(t=!1),r=!1,l&&(s=t?[]:"")},d={add:function(){return s&&(t&&!r&&(c=s.length-1,a.push(t)),function n(e){E.each(e,function(e,t){E.isFunction(t)?o.unique&&d.has(t)||s.push(t):t&&t.length&&"string"!==E.type(t)&&n(t)})}(arguments),t&&!r&&u()),this},remove:function(){return E.each(arguments,function(e,t){for(var n;-1<(n=E.inArray(t,s,n));)s.splice(n,1),n<=c&&c--}),this},has:function(e){return e?-1<E.inArray(e,s):0<s.length},empty:function(){return s&&(s=[]),this},disable:function(){return l=a=[],s=t="",this},disabled:function(){return!s},lock:function(){return l=a=[],t||r||(s=t=""),this},locked:function(){return!!l},fireWith:function(e,t){return l||(t=[e,(t=t||[]).slice?t.slice():t],a.push(t),r||u()),this},fire:function(){return d.fireWith(this,arguments),this},fired:function(){return!!i}};return d},E.extend({Deferred:function(e){var i=[["notify","progress",E.Callbacks("memory"),E.Callbacks("memory"),2],["resolve","done",E.Callbacks("once memory"),E.Callbacks("once memory"),0,"resolved"],["reject","fail",E.Callbacks("once memory"),E.Callbacks("once memory"),1,"rejected"]],r="pending",l={state:function(){return r},always:function(){return s.done(arguments).fail(arguments),this},catch:function(e){return l.then(null,e)},pipe:function(){var r=arguments;return E.Deferred(function(o){E.each(i,function(e,t){var n=E.isFunction(r[t[4]])&&r[t[4]];s[t[1]](function(){var e=n&&n.apply(this,arguments);e&&E.isFunction(e.promise)?e.promise().progress(o.notify).done(o.resolve).fail(o.reject):o[t[0]+"With"](this,n?[e]:arguments)})}),r=null}).promise()},then:function(t,n,o){var a=0;function c(r,i,l,s){return function(){var n=this,o=arguments,e=function(){var e,t;if(!(r<a)){if((e=l.apply(n,o))===i.promise())throw new TypeError("Thenable self-resolution");t=e&&("object"==typeof e||"function"==typeof e)&&e.then,E.isFunction(t)?s?t.call(e,c(a,i,I,s),c(a,i,M,s)):(a++,t.call(e,c(a,i,I,s),c(a,i,M,s),c(a,i,I,i.notifyWith))):(l!==I&&(n=void 0,o=[e]),(s||i.resolveWith)(n,o))}},t=s?e:function(){try{e()}catch(e){E.Deferred.exceptionHook&&E.Deferred.exceptionHook(e,t.stackTrace),a<=r+1&&(l!==M&&(n=void 0,o=[e]),i.rejectWith(n,o))}};r?t():(E.Deferred.getStackHook&&(t.stackTrace=E.Deferred.getStackHook()),R.setTimeout(t))}}return E.Deferred(function(e){i[0][3].add(c(0,e,E.isFunction(o)?o:I,e.notifyWith)),i[1][3].add(c(0,e,E.isFunction(t)?t:I)),i[2][3].add(c(0,e,E.isFunction(n)?n:M))}).promise()},promise:function(e){return null!=e?E.extend(e,l):l}},s={};return E.each(i,function(e,t){var n=t[2],o=t[5];l[t[1]]=n.add,o&&n.add(function(){r=o},i[3-e][2].disable,i[0][2].lock),n.add(t[3].fire),s[t[0]]=function(){return s[t[0]+"With"](this===s?void 0:this,arguments),this},s[t[0]+"With"]=n.fireWith}),l.promise(s),e&&e.call(s,s),s},when:function(e){var n=arguments.length,t=n,o=Array(t),r=s.call(arguments),i=E.Deferred(),l=function(t){return function(e){o[t]=this,r[t]=1<arguments.length?s.call(arguments):e,--n||i.resolveWith(o,r)}};if(n<=1&&(W(e,i.done(l(t)).resolve,i.reject,!n),"pending"===i.state()||E.isFunction(r[t]&&r[t].then)))return i.then();for(;t--;)W(r[t],l(t),i.reject);return i.promise()}});var j=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;E.Deferred.exceptionHook=function(e,t){R.console&&R.console.warn&&e&&j.test(e.name)&&R.console.warn("jQuery.Deferred exception: "+e.message,e.stack,t)},E.readyException=function(e){R.setTimeout(function(){throw e})};var V=E.Deferred();function B(){S.removeEventListener("DOMContentLoaded",B),R.removeEventListener("load",B),E.ready()}E.fn.ready=function(e){return V.then(e).catch(function(e){E.readyException(e)}),this},E.extend({isReady:!1,readyWait:1,ready:function(e){(!0===e?--E.readyWait:E.isReady)||(E.isReady=!0)!==e&&0<--E.readyWait||V.resolveWith(S,[E])}}),E.ready.then=V.then,"complete"===S.readyState||"loading"!==S.readyState&&!S.documentElement.doScroll?R.setTimeout(E.ready):(S.addEventListener("DOMContentLoaded",B),R.addEventListener("load",B));var q=function(e,t,n,o,r,i,l){var s=0,a=e.length,c=null==n;if("object"===E.type(n))for(s in r=!0,n)q(e,t,s,n[s],!0,i,l);else if(void 0!==o&&(r=!0,E.isFunction(o)||(l=!0),c&&(l?(t.call(e,o),t=null):(c=t,t=function(e,t,n){return c.call(E(e),n)})),t))for(;s<a;s++)t(e[s],n,l?o:o.call(e[s],s,t(e[s],n)));return r?e:c?t.call(e):a?t(e[0],n):i},O=function(e){return 1===e.nodeType||9===e.nodeType||!+e.nodeType};function z(){this.expando=E.expando+z.uid++}z.uid=1,z.prototype={cache:function(e){var t=e[this.expando];return t||(t={},O(e)&&(e.nodeType?e[this.expando]=t:Object.defineProperty(e,this.expando,{value:t,configurable:!0}))),t},set:function(e,t,n){var o,r=this.cache(e);if("string"==typeof t)r[E.camelCase(t)]=n;else for(o in t)r[E.camelCase(o)]=t[o];return r},get:function(e,t){return void 0===t?this.cache(e):e[this.expando]&&e[this.expando][E.camelCase(t)]},access:function(e,t,n){return void 0===t||t&&"string"==typeof t&&void 0===n?this.get(e,t):(this.set(e,t,n),void 0!==n?n:t)},remove:function(e,t){var n,o=e[this.expando];if(void 0!==o){if(void 0!==t){t=Array.isArray(t)?t.map(E.camelCase):(t=E.camelCase(t))in o?[t]:t.match(F)||[],n=t.length;for(;n--;)delete o[t[n]]}(void 0===t||E.isEmptyObject(o))&&(e.nodeType?e[this.expando]=void 0:delete e[this.expando])}},hasData:function(e){var t=e[this.expando];return void 0!==t&&!E.isEmptyObject(t)}};var X=new z,U=new z,K=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,G=/[A-Z]/g;function Y(e,t,n){var o;if(void 0===n&&1===e.nodeType)if(o="data-"+t.replace(G,"-$&").toLowerCase(),"string"==typeof(n=e.getAttribute(o))){try{n=function(e){if("true"===e)return!0;if("false"===e)return!1;if("null"===e)return null;if(e===+e+"")return+e;if(K.test(e))return JSON.parse(e);return e}(n)}catch(e){}U.set(e,t,n)}else n=void 0;return n}E.extend({hasData:function(e){return U.hasData(e)||X.hasData(e)},data:function(e,t,n){return U.access(e,t,n)},removeData:function(e,t){U.remove(e,t)},_data:function(e,t,n){return X.access(e,t,n)},_removeData:function(e,t){X.remove(e,t)}}),E.fn.extend({data:function(n,e){var t,o,r,i=this[0],l=i&&i.attributes;if(void 0===n){if(this.length&&(r=U.get(i),1===i.nodeType&&!X.get(i,"hasDataAttrs"))){for(t=l.length;t--;)l[t]&&0===(o=l[t].name).indexOf("data-")&&(o=E.camelCase(o.slice(5)),Y(i,o,r[o]));X.set(i,"hasDataAttrs",!0)}return r}return"object"==typeof n?this.each(function(){U.set(this,n)}):q(this,function(e){var t;if(i&&void 0===e)return void 0!==(t=U.get(i,n))?t:void 0!==(t=Y(i,n))?t:void 0;this.each(function(){U.set(this,n,e)})},null,e,1<arguments.length,null,!0)},removeData:function(e){return this.each(function(){U.remove(this,e)})}}),E.extend({queue:function(e,t,n){var o;if(e)return t=(t||"fx")+"queue",o=X.get(e,t),n&&(!o||Array.isArray(n)?o=X.access(e,t,E.makeArray(n)):o.push(n)),o||[]},dequeue:function(e,t){t=t||"fx";var n=E.queue(e,t),o=n.length,r=n.shift(),i=E._queueHooks(e,t);"inprogress"===r&&(r=n.shift(),o--),r&&("fx"===t&&n.unshift("inprogress"),delete i.stop,r.call(e,function(){E.dequeue(e,t)},i)),!o&&i&&i.empty.fire()},_queueHooks:function(e,t){var n=t+"queueHooks";return X.get(e,n)||X.access(e,n,{empty:E.Callbacks("once memory").add(function(){X.remove(e,[t+"queue",n])})})}}),E.fn.extend({queue:function(t,n){var e=2;return"string"!=typeof t&&(n=t,t="fx",e--),arguments.length<e?E.queue(this[0],t):void 0===n?this:this.each(function(){var e=E.queue(this,t,n);E._queueHooks(this,t),"fx"===t&&"inprogress"!==e[0]&&E.dequeue(this,t)})},dequeue:function(e){return this.each(function(){E.dequeue(this,e)})},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,t){var n,o=1,r=E.Deferred(),i=this,l=this.length,s=function(){--o||r.resolveWith(i,[i])};for("string"!=typeof e&&(t=e,e=void 0),e=e||"fx";l--;)(n=X.get(i[l],e+"queueHooks"))&&n.empty&&(o++,n.empty.add(s));return s(),r.promise(t)}});var Q=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,J=new RegExp("^(?:([+-])=|)("+Q+")([a-z%]*)$","i"),Z=["Top","Right","Bottom","Left"],ee=function(e,t){return"none"===(e=t||e).style.display||""===e.style.display&&E.contains(e.ownerDocument,e)&&"none"===E.css(e,"display")},te=function(e,t,n,o){var r,i,l={};for(i in t)l[i]=e.style[i],e.style[i]=t[i];for(i in r=n.apply(e,o||[]),t)e.style[i]=l[i];return r};function ne(e,t,n,o){var r,i=1,l=20,s=o?function(){return o.cur()}:function(){return E.css(e,t,"")},a=s(),c=n&&n[3]||(E.cssNumber[t]?"":"px"),u=(E.cssNumber[t]||"px"!==c&&+a)&&J.exec(E.css(e,t));if(u&&u[3]!==c)for(c=c||u[3],n=n||[],u=+a||1;u/=i=i||".5",E.style(e,t,u+c),i!==(i=s()/a)&&1!==i&&--l;);return n&&(u=+u||+a||0,r=n[1]?u+(n[1]+1)*n[2]:+n[2],o&&(o.unit=c,o.start=u,o.end=r)),r}var oe={};function re(e){var t,n=e.ownerDocument,o=e.nodeName,r=oe[o];return r||(t=n.body.appendChild(n.createElement(o)),r=E.css(t,"display"),t.parentNode.removeChild(t),"none"===r&&(r="block"),oe[o]=r)}function ie(e,t){for(var n,o,r=[],i=0,l=e.length;i<l;i++)(o=e[i]).style&&(n=o.style.display,t?("none"===n&&(r[i]=X.get(o,"display")||null,r[i]||(o.style.display="")),""===o.style.display&&ee(o)&&(r[i]=re(o))):"none"!==n&&(r[i]="none",X.set(o,"display",n)));for(i=0;i<l;i++)null!=r[i]&&(e[i].style.display=r[i]);return e}E.fn.extend({show:function(){return ie(this,!0)},hide:function(){return ie(this)},toggle:function(e){return"boolean"==typeof e?e?this.show():this.hide():this.each(function(){ee(this)?E(this).show():E(this).hide()})}});var le=/^(?:checkbox|radio)$/i,se=/<([a-z][^\/\0>\x20\t\r\n\f]+)/i,ae=/^$|\/(?:java|ecma)script/i,ce={option:[1,"<select multiple='multiple'>","</select>"],thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};function ue(e,t){var n;return n=void 0!==e.getElementsByTagName?e.getElementsByTagName(t||"*"):void 0!==e.querySelectorAll?e.querySelectorAll(t||"*"):[],void 0===t||t&&k(e,t)?E.merge([e],n):n}function de(e,t){for(var n=0,o=e.length;n<o;n++)X.set(e[n],"globalEval",!t||X.get(t[n],"globalEval"))}ce.optgroup=ce.option,ce.tbody=ce.tfoot=ce.colgroup=ce.caption=ce.thead,ce.th=ce.td;var pe,fe,he,ge=/<|&#?\w+;/;function me(e,t,n,o,r){for(var i,l,s,a,c,u,d=t.createDocumentFragment(),p=[],f=0,h=e.length;f<h;f++)if((i=e[f])||0===i)if("object"===E.type(i))E.merge(p,i.nodeType?[i]:i);else if(ge.test(i)){for(l=l||d.appendChild(t.createElement("div")),s=(se.exec(i)||["",""])[1].toLowerCase(),a=ce[s]||ce._default,l.innerHTML=a[1]+E.htmlPrefilter(i)+a[2],u=a[0];u--;)l=l.lastChild;E.merge(p,l.childNodes),(l=d.firstChild).textContent=""}else p.push(t.createTextNode(i));for(d.textContent="",f=0;i=p[f++];)if(o&&-1<E.inArray(i,o))r&&r.push(i);else if(c=E.contains(i.ownerDocument,i),l=ue(d.appendChild(i),"script"),c&&de(l),n)for(u=0;i=l[u++];)ae.test(i.type||"")&&n.push(i);return d}pe=S.createDocumentFragment(),fe=pe.appendChild(S.createElement("div")),(he=S.createElement("input")).setAttribute("type","radio"),he.setAttribute("checked","checked"),he.setAttribute("name","t"),fe.appendChild(he),m.checkClone=fe.cloneNode(!0).cloneNode(!0).lastChild.checked,fe.innerHTML="<textarea>x</textarea>",m.noCloneChecked=!!fe.cloneNode(!0).lastChild.defaultValue;var ve=S.documentElement,we=/^key/,ye=/^(?:mouse|pointer|contextmenu|drag|drop)|click/,Ce=/^([^.]*)(?:\.(.+)|)/;function be(){return!0}function xe(){return!1}function Re(){try{return S.activeElement}catch(e){}}function Se(e,t,n,o,r,i){var l,s;if("object"==typeof t){for(s in"string"!=typeof n&&(o=o||n,n=void 0),t)Se(e,s,n,o,t[s],i);return e}if(null==o&&null==r?(r=n,o=n=void 0):null==r&&("string"==typeof n?(r=o,o=void 0):(r=o,o=n,n=void 0)),!1===r)r=xe;else if(!r)return e;return 1===i&&(l=r,(r=function(e){return E().off(e),l.apply(this,arguments)}).guid=l.guid||(l.guid=E.guid++)),e.each(function(){E.event.add(this,t,r,o,n)})}E.event={global:{},add:function(t,e,n,o,r){var i,l,s,a,c,u,d,p,f,h,g,m=X.get(t);if(m)for(n.handler&&(n=(i=n).handler,r=i.selector),r&&E.find.matchesSelector(ve,r),n.guid||(n.guid=E.guid++),(a=m.events)||(a=m.events={}),(l=m.handle)||(l=m.handle=function(e){return void 0!==E&&E.event.triggered!==e.type?E.event.dispatch.apply(t,arguments):void 0}),e=(e||"").match(F)||[""],c=e.length;c--;)s=Ce.exec(e[c])||[],f=g=s[1],h=(s[2]||"").split(".").sort(),f&&(d=E.event.special[f]||{},f=(r?d.delegateType:d.bindType)||f,d=E.event.special[f]||{},u=E.extend({type:f,origType:g,data:o,handler:n,guid:n.guid,selector:r,needsContext:r&&E.expr.match.needsContext.test(r),namespace:h.join(".")},i),(p=a[f])||((p=a[f]=[]).delegateCount=0,d.setup&&!1!==d.setup.call(t,o,h,l)||t.addEventListener&&t.addEventListener(f,l)),d.add&&(d.add.call(t,u),u.handler.guid||(u.handler.guid=n.guid)),r?p.splice(p.delegateCount++,0,u):p.push(u),E.event.global[f]=!0)},remove:function(e,t,n,o,r){var i,l,s,a,c,u,d,p,f,h,g,m=X.hasData(e)&&X.get(e);if(m&&(a=m.events)){for(t=(t||"").match(F)||[""],c=t.length;c--;)if(s=Ce.exec(t[c])||[],f=g=s[1],h=(s[2]||"").split(".").sort(),f){for(d=E.event.special[f]||{},f=(o?d.delegateType:d.bindType)||f,p=a[f]||[],s=s[2]&&new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"),l=i=p.length;i--;)u=p[i],!r&&g!==u.origType||n&&n.guid!==u.guid||s&&!s.test(u.namespace)||o&&o!==u.selector&&("**"!==o||!u.selector)||(p.splice(i,1),u.selector&&p.delegateCount--,d.remove&&d.remove.call(e,u));l&&!p.length&&(d.teardown&&!1!==d.teardown.call(e,h,m.handle)||E.removeEvent(e,f,m.handle),delete a[f])}else for(f in a)E.event.remove(e,f+t[c],n,o,!0);E.isEmptyObject(a)&&X.remove(e,"handle events")}},dispatch:function(e){var t,n,o,r,i,l,s=E.event.fix(e),a=new Array(arguments.length),c=(X.get(this,"events")||{})[s.type]||[],u=E.event.special[s.type]||{};for(a[0]=s,t=1;t<arguments.length;t++)a[t]=arguments[t];if(s.delegateTarget=this,!u.preDispatch||!1!==u.preDispatch.call(this,s)){for(l=E.event.handlers.call(this,s,c),t=0;(r=l[t++])&&!s.isPropagationStopped();)for(s.currentTarget=r.elem,n=0;(i=r.handlers[n++])&&!s.isImmediatePropagationStopped();)s.rnamespace&&!s.rnamespace.test(i.namespace)||(s.handleObj=i,s.data=i.data,void 0!==(o=((E.event.special[i.origType]||{}).handle||i.handler).apply(r.elem,a))&&!1===(s.result=o)&&(s.preventDefault(),s.stopPropagation()));return u.postDispatch&&u.postDispatch.call(this,s),s.result}},handlers:function(e,t){var n,o,r,i,l,s=[],a=t.delegateCount,c=e.target;if(a&&c.nodeType&&!("click"===e.type&&1<=e.button))for(;c!==this;c=c.parentNode||this)if(1===c.nodeType&&("click"!==e.type||!0!==c.disabled)){for(i=[],l={},n=0;n<a;n++)o=t[n],r=o.selector+" ",void 0===l[r]&&(l[r]=o.needsContext?-1<E(r,this).index(c):E.find(r,this,null,[c]).length),l[r]&&i.push(o);i.length&&s.push({elem:c,handlers:i})}return c=this,a<t.length&&s.push({elem:c,handlers:t.slice(a)}),s},addProp:function(t,e){Object.defineProperty(E.Event.prototype,t,{enumerable:!0,configurable:!0,get:E.isFunction(e)?function(){if(this.originalEvent)return e(this.originalEvent)}:function(){if(this.originalEvent)return this.originalEvent[t]},set:function(e){Object.defineProperty(this,t,{enumerable:!0,configurable:!0,writable:!0,value:e})}})},fix:function(e){return e[E.expando]?e:new E.Event(e)},special:{load:{noBubble:!0},focus:{trigger:function(){if(this!==Re()&&this.focus)return this.focus(),!1},delegateType:"focusin"},blur:{trigger:function(){if(this===Re()&&this.blur)return this.blur(),!1},delegateType:"focusout"},click:{trigger:function(){if("checkbox"===this.type&&this.click&&k(this,"input"))return this.click(),!1},_default:function(e){return k(e.target,"a")}},beforeunload:{postDispatch:function(e){void 0!==e.result&&e.originalEvent&&(e.originalEvent.returnValue=e.result)}}}},E.removeEvent=function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n)},E.Event=function(e,t){if(!(this instanceof E.Event))return new E.Event(e,t);e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||void 0===e.defaultPrevented&&!1===e.returnValue?be:xe,this.target=e.target&&3===e.target.nodeType?e.target.parentNode:e.target,this.currentTarget=e.currentTarget,this.relatedTarget=e.relatedTarget):this.type=e,t&&E.extend(this,t),this.timeStamp=e&&e.timeStamp||E.now(),this[E.expando]=!0},E.Event.prototype={constructor:E.Event,isDefaultPrevented:xe,isPropagationStopped:xe,isImmediatePropagationStopped:xe,isSimulated:!1,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=be,e&&!this.isSimulated&&e.preventDefault()},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=be,e&&!this.isSimulated&&e.stopPropagation()},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=be,e&&!this.isSimulated&&e.stopImmediatePropagation(),this.stopPropagation()}},E.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,char:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:function(e){var t=e.button;return null==e.which&&we.test(e.type)?null!=e.charCode?e.charCode:e.keyCode:!e.which&&void 0!==t&&ye.test(e.type)?1&t?1:2&t?3:4&t?2:0:e.which}},E.event.addProp),E.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(e,r){E.event.special[e]={delegateType:r,bindType:r,handle:function(e){var t,n=e.relatedTarget,o=e.handleObj;return n&&(n===this||E.contains(this,n))||(e.type=o.origType,t=o.handler.apply(this,arguments),e.type=r),t}}}),E.fn.extend({on:function(e,t,n,o){return Se(this,e,t,n,o)},one:function(e,t,n,o){return Se(this,e,t,n,o,1)},off:function(e,t,n){var o,r;if(e&&e.preventDefault&&e.handleObj)return o=e.handleObj,E(e.delegateTarget).off(o.namespace?o.origType+"."+o.namespace:o.origType,o.selector,o.handler),this;if("object"==typeof e){for(r in e)this.off(r,t,e[r]);return this}return!1!==t&&"function"!=typeof t||(n=t,t=void 0),!1===n&&(n=xe),this.each(function(){E.event.remove(this,e,n,t)})}});var Ee=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi,ke=/<script|<style|<link/i,Te=/checked\s*(?:[^=]|=\s*.checked.)/i,Pe=/^true\/(.*)/,De=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function Ae(e,t){return k(e,"table")&&k(11!==t.nodeType?t:t.firstChild,"tr")&&E(">tbody",e)[0]||e}function Ne(e){return e.type=(null!==e.getAttribute("type"))+"/"+e.type,e}function $e(e){var t=Pe.exec(e.type);return t?e.type=t[1]:e.removeAttribute("type"),e}function He(e,t){var n,o,r,i,l,s,a,c;if(1===t.nodeType){if(X.hasData(e)&&(i=X.access(e),l=X.set(t,i),c=i.events))for(r in delete l.handle,l.events={},c)for(n=0,o=c[r].length;n<o;n++)E.event.add(t,r,c[r][n]);U.hasData(e)&&(s=U.access(e),a=E.extend({},s),U.set(t,a))}}function Le(e,t){var n=t.nodeName.toLowerCase();"input"===n&&le.test(e.type)?t.checked=e.checked:"input"!==n&&"textarea"!==n||(t.defaultValue=e.defaultValue)}function _e(n,o,r,i){o=g.apply([],o);var e,t,l,s,a,c,u=0,d=n.length,p=d-1,f=o[0],h=E.isFunction(f);if(h||1<d&&"string"==typeof f&&!m.checkClone&&Te.test(f))return n.each(function(e){var t=n.eq(e);h&&(o[0]=f.call(this,e,t.html())),_e(t,o,r,i)});if(d&&(e=me(o,n[0].ownerDocument,!1,n,i),t=e.firstChild,1===e.childNodes.length&&(e=t),t||i)){for(l=E.map(ue(e,"script"),Ne),s=l.length;u<d;u++)a=e,u!==p&&(a=E.clone(a,!0,!0),s&&E.merge(l,ue(a,"script"))),r.call(n[u],a,u);if(s)for(c=l[l.length-1].ownerDocument,E.map(l,$e),u=0;u<s;u++)a=l[u],ae.test(a.type||"")&&!X.access(a,"globalEval")&&E.contains(c,a)&&(a.src?E._evalUrl&&E._evalUrl(a.src):v(a.textContent.replace(De,""),c))}return n}function Fe(e,t,n){for(var o,r=t?E.filter(t,e):e,i=0;null!=(o=r[i]);i++)n||1!==o.nodeType||E.cleanData(ue(o)),o.parentNode&&(n&&E.contains(o.ownerDocument,o)&&de(ue(o,"script")),o.parentNode.removeChild(o));return e}E.extend({htmlPrefilter:function(e){return e.replace(Ee,"<$1></$2>")},clone:function(e,t,n){var o,r,i,l,s=e.cloneNode(!0),a=E.contains(e.ownerDocument,e);if(!(m.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||E.isXMLDoc(e)))for(l=ue(s),i=ue(e),o=0,r=i.length;o<r;o++)Le(i[o],l[o]);if(t)if(n)for(i=i||ue(e),l=l||ue(s),o=0,r=i.length;o<r;o++)He(i[o],l[o]);else He(e,s);return 0<(l=ue(s,"script")).length&&de(l,!a&&ue(e,"script")),s},cleanData:function(e){for(var t,n,o,r=E.event.special,i=0;void 0!==(n=e[i]);i++)if(O(n)){if(t=n[X.expando]){if(t.events)for(o in t.events)r[o]?E.event.remove(n,o):E.removeEvent(n,o,t.handle);n[X.expando]=void 0}n[U.expando]&&(n[U.expando]=void 0)}}}),E.fn.extend({detach:function(e){return Fe(this,e,!0)},remove:function(e){return Fe(this,e)},text:function(e){return q(this,function(e){return void 0===e?E.text(this):this.empty().each(function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=e)})},null,e,arguments.length)},append:function(){return _e(this,arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=Ae(this,e);t.appendChild(e)}})},prepend:function(){return _e(this,arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=Ae(this,e);t.insertBefore(e,t.firstChild)}})},before:function(){return _e(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return _e(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},empty:function(){for(var e,t=0;null!=(e=this[t]);t++)1===e.nodeType&&(E.cleanData(ue(e,!1)),e.textContent="");return this},clone:function(e,t){return e=null!=e&&e,t=null==t?e:t,this.map(function(){return E.clone(this,e,t)})},html:function(e){return q(this,function(e){var t=this[0]||{},n=0,o=this.length;if(void 0===e&&1===t.nodeType)return t.innerHTML;if("string"==typeof e&&!ke.test(e)&&!ce[(se.exec(e)||["",""])[1].toLowerCase()]){e=E.htmlPrefilter(e);try{for(;n<o;n++)1===(t=this[n]||{}).nodeType&&(E.cleanData(ue(t,!1)),t.innerHTML=e);t=0}catch(e){}}t&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(){var n=[];return _e(this,arguments,function(e){var t=this.parentNode;E.inArray(this,n)<0&&(E.cleanData(ue(this)),t&&t.replaceChild(e,this))},n)}}),E.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(e,l){E.fn[e]=function(e){for(var t,n=[],o=E(e),r=o.length-1,i=0;i<=r;i++)t=i===r?this:this.clone(!0),E(o[i])[l](t),a.apply(n,t.get());return this.pushStack(n)}});var Ie=/^margin/,Me=new RegExp("^("+Q+")(?!px)[a-z%]+$","i"),We=function(e){var t=e.ownerDocument.defaultView;return t&&t.opener||(t=R),t.getComputedStyle(e)};function je(e,t,n){var o,r,i,l,s=e.style;return(n=n||We(e))&&(""!==(l=n.getPropertyValue(t)||n[t])||E.contains(e.ownerDocument,e)||(l=E.style(e,t)),!m.pixelMarginRight()&&Me.test(l)&&Ie.test(t)&&(o=s.width,r=s.minWidth,i=s.maxWidth,s.minWidth=s.maxWidth=s.width=l,l=n.width,s.width=o,s.minWidth=r,s.maxWidth=i)),void 0!==l?l+"":l}function Ve(e,t){return{get:function(){if(!e())return(this.get=t).apply(this,arguments);delete this.get}}}!function(){function e(){if(l){l.style.cssText="box-sizing:border-box;position:relative;display:block;margin:auto;border:1px;padding:1px;top:1%;width:50%",l.innerHTML="",ve.appendChild(i);var e=R.getComputedStyle(l);t="1%"!==e.top,r="2px"===e.marginLeft,n="4px"===e.width,l.style.marginRight="50%",o="4px"===e.marginRight,ve.removeChild(i),l=null}}var t,n,o,r,i=S.createElement("div"),l=S.createElement("div");l.style&&(l.style.backgroundClip="content-box",l.cloneNode(!0).style.backgroundClip="",m.clearCloneStyle="content-box"===l.style.backgroundClip,i.style.cssText="border:0;width:8px;height:0;top:0;left:-9999px;padding:0;margin-top:1px;position:absolute",i.appendChild(l),E.extend(m,{pixelPosition:function(){return e(),t},boxSizingReliable:function(){return e(),n},pixelMarginRight:function(){return e(),o},reliableMarginLeft:function(){return e(),r}}))}();var Be=/^(none|table(?!-c[ea]).+)/,qe=/^--/,Oe={position:"absolute",visibility:"hidden",display:"block"},ze={letterSpacing:"0",fontWeight:"400"},Xe=["Webkit","Moz","ms"],Ue=S.createElement("div").style;function Ke(e){var t=E.cssProps[e];return t||(t=E.cssProps[e]=function(e){if(e in Ue)return e;var t=e[0].toUpperCase()+e.slice(1),n=Xe.length;for(;n--;)if((e=Xe[n]+t)in Ue)return e}(e)||e),t}function Ge(e,t,n){var o=J.exec(t);return o?Math.max(0,o[2]-(n||0))+(o[3]||"px"):t}function Ye(e,t,n,o,r){var i,l=0;for(i=n===(o?"border":"content")?4:"width"===t?1:0;i<4;i+=2)"margin"===n&&(l+=E.css(e,n+Z[i],!0,r)),o?("content"===n&&(l-=E.css(e,"padding"+Z[i],!0,r)),"margin"!==n&&(l-=E.css(e,"border"+Z[i]+"Width",!0,r))):(l+=E.css(e,"padding"+Z[i],!0,r),"padding"!==n&&(l+=E.css(e,"border"+Z[i]+"Width",!0,r)));return l}function Qe(e,t,n){var o,r=We(e),i=je(e,t,r),l="border-box"===E.css(e,"boxSizing",!1,r);return Me.test(i)?i:(o=l&&(m.boxSizingReliable()||i===e.style[t]),"auto"===i&&(i=e["offset"+t[0].toUpperCase()+t.slice(1)]),(i=parseFloat(i)||0)+Ye(e,t,n||(l?"border":"content"),o,r)+"px")}function Je(e,t,n,o,r){return new Je.prototype.init(e,t,n,o,r)}E.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=je(e,"opacity");return""===n?"1":n}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{float:"cssFloat"},style:function(e,t,n,o){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var r,i,l,s=E.camelCase(t),a=qe.test(t),c=e.style;if(a||(t=Ke(s)),l=E.cssHooks[t]||E.cssHooks[s],void 0===n)return l&&"get"in l&&void 0!==(r=l.get(e,!1,o))?r:c[t];"string"===(i=typeof n)&&(r=J.exec(n))&&r[1]&&(n=ne(e,t,r),i="number"),null!=n&&n==n&&("number"===i&&(n+=r&&r[3]||(E.cssNumber[s]?"":"px")),m.clearCloneStyle||""!==n||0!==t.indexOf("background")||(c[t]="inherit"),l&&"set"in l&&void 0===(n=l.set(e,n,o))||(a?c.setProperty(t,n):c[t]=n))}},css:function(e,t,n,o){var r,i,l,s=E.camelCase(t),a=qe.test(t);return a||(t=Ke(s)),(l=E.cssHooks[t]||E.cssHooks[s])&&"get"in l&&(r=l.get(e,!0,n)),void 0===r&&(r=je(e,t,o)),"normal"===r&&t in ze&&(r=ze[t]),""===n||n?(i=parseFloat(r),!0===n||isFinite(i)?i||0:r):r}}),E.each(["height","width"],function(e,l){E.cssHooks[l]={get:function(e,t,n){if(t)return!Be.test(E.css(e,"display"))||e.getClientRects().length&&e.getBoundingClientRect().width?Qe(e,l,n):te(e,Oe,function(){return Qe(e,l,n)})},set:function(e,t,n){var o,r=n&&We(e),i=n&&Ye(e,l,n,"border-box"===E.css(e,"boxSizing",!1,r),r);return i&&(o=J.exec(t))&&"px"!==(o[3]||"px")&&(e.style[l]=t,t=E.css(e,l)),Ge(e,t,i)}}}),E.cssHooks.marginLeft=Ve(m.reliableMarginLeft,function(e,t){if(t)return(parseFloat(je(e,"marginLeft"))||e.getBoundingClientRect().left-te(e,{marginLeft:0},function(){return e.getBoundingClientRect().left}))+"px"}),E.each({margin:"",padding:"",border:"Width"},function(r,i){E.cssHooks[r+i]={expand:function(e){for(var t=0,n={},o="string"==typeof e?e.split(" "):[e];t<4;t++)n[r+Z[t]+i]=o[t]||o[t-2]||o[0];return n}},Ie.test(r)||(E.cssHooks[r+i].set=Ge)}),E.fn.extend({css:function(e,t){return q(this,function(e,t,n){var o,r,i={},l=0;if(Array.isArray(t)){for(o=We(e),r=t.length;l<r;l++)i[t[l]]=E.css(e,t[l],!1,o);return i}return void 0!==n?E.style(e,t,n):E.css(e,t)},e,t,1<arguments.length)}}),((E.Tween=Je).prototype={constructor:Je,init:function(e,t,n,o,r,i){this.elem=e,this.prop=n,this.easing=r||E.easing._default,this.options=t,this.start=this.now=this.cur(),this.end=o,this.unit=i||(E.cssNumber[n]?"":"px")},cur:function(){var e=Je.propHooks[this.prop];return e&&e.get?e.get(this):Je.propHooks._default.get(this)},run:function(e){var t,n=Je.propHooks[this.prop];return this.options.duration?this.pos=t=E.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):this.pos=t=e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):Je.propHooks._default.set(this),this}}).init.prototype=Je.prototype,(Je.propHooks={_default:{get:function(e){var t;return 1!==e.elem.nodeType||null!=e.elem[e.prop]&&null==e.elem.style[e.prop]?e.elem[e.prop]:(t=E.css(e.elem,e.prop,""))&&"auto"!==t?t:0},set:function(e){E.fx.step[e.prop]?E.fx.step[e.prop](e):1!==e.elem.nodeType||null==e.elem.style[E.cssProps[e.prop]]&&!E.cssHooks[e.prop]?e.elem[e.prop]=e.now:E.style(e.elem,e.prop,e.now+e.unit)}}}).scrollTop=Je.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},E.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2},_default:"swing"},E.fx=Je.prototype.init,E.fx.step={};var Ze,et,tt,nt,ot,rt=/^(?:toggle|show|hide)$/,it=/queueHooks$/;function lt(){et&&(!1===S.hidden&&R.requestAnimationFrame?R.requestAnimationFrame(lt):R.setTimeout(lt,E.fx.interval),E.fx.tick())}function st(){return R.setTimeout(function(){Ze=void 0}),Ze=E.now()}function at(e,t){var n,o=0,r={height:e};for(t=t?1:0;o<4;o+=2-t)n=Z[o],r["margin"+n]=r["padding"+n]=e;return t&&(r.opacity=r.width=e),r}function ct(e,t,n){for(var o,r=(ut.tweeners[t]||[]).concat(ut.tweeners["*"]),i=0,l=r.length;i<l;i++)if(o=r[i].call(n,t,e))return o}function ut(l,e,t){var n,s,o=0,r=ut.prefilters.length,a=E.Deferred().always(function(){delete i.elem}),i=function(){if(s)return!1;for(var e=Ze||st(),t=Math.max(0,c.startTime+c.duration-e),n=t/c.duration||0,o=1-n,r=0,i=c.tweens.length;r<i;r++)c.tweens[r].run(o);return a.notifyWith(l,[c,o,t]),o<1&&i?t:(i||a.notifyWith(l,[c,1,0]),a.resolveWith(l,[c]),!1)},c=a.promise({elem:l,props:E.extend({},e),opts:E.extend(!0,{specialEasing:{},easing:E.easing._default},t),originalProperties:e,originalOptions:t,startTime:Ze||st(),duration:t.duration,tweens:[],createTween:function(e,t){var n=E.Tween(l,c.opts,e,t,c.opts.specialEasing[e]||c.opts.easing);return c.tweens.push(n),n},stop:function(e){var t=0,n=e?c.tweens.length:0;if(s)return this;for(s=!0;t<n;t++)c.tweens[t].run(1);return e?(a.notifyWith(l,[c,1,0]),a.resolveWith(l,[c,e])):a.rejectWith(l,[c,e]),this}}),u=c.props;for(!function(e,t){var n,o,r,i,l;for(n in e)if(o=E.camelCase(n),r=t[o],i=e[n],Array.isArray(i)&&(r=i[1],i=e[n]=i[0]),n!==o&&(e[o]=i,delete e[n]),(l=E.cssHooks[o])&&"expand"in l)for(n in i=l.expand(i),delete e[o],i)n in e||(e[n]=i[n],t[n]=r);else t[o]=r}(u,c.opts.specialEasing);o<r;o++)if(n=ut.prefilters[o].call(c,l,u,c.opts))return E.isFunction(n.stop)&&(E._queueHooks(c.elem,c.opts.queue).stop=E.proxy(n.stop,n)),n;return E.map(u,ct,c),E.isFunction(c.opts.start)&&c.opts.start.call(l,c),c.progress(c.opts.progress).done(c.opts.done,c.opts.complete).fail(c.opts.fail).always(c.opts.always),E.fx.timer(E.extend(i,{elem:l,anim:c,queue:c.opts.queue})),c}E.Animation=E.extend(ut,{tweeners:{"*":[function(e,t){var n=this.createTween(e,t);return ne(n.elem,e,J.exec(t),n),n}]},tweener:function(e,t){E.isFunction(e)?(t=e,e=["*"]):e=e.match(F);for(var n,o=0,r=e.length;o<r;o++)n=e[o],ut.tweeners[n]=ut.tweeners[n]||[],ut.tweeners[n].unshift(t)},prefilters:[function(e,t,n){var o,r,i,l,s,a,c,u,d="width"in t||"height"in t,p=this,f={},h=e.style,g=e.nodeType&&ee(e),m=X.get(e,"fxshow");n.queue||(null==(l=E._queueHooks(e,"fx")).unqueued&&(l.unqueued=0,s=l.empty.fire,l.empty.fire=function(){l.unqueued||s()}),l.unqueued++,p.always(function(){p.always(function(){l.unqueued--,E.queue(e,"fx").length||l.empty.fire()})}));for(o in t)if(r=t[o],rt.test(r)){if(delete t[o],i=i||"toggle"===r,r===(g?"hide":"show")){if("show"!==r||!m||void 0===m[o])continue;g=!0}f[o]=m&&m[o]||E.style(e,o)}if(!(a=!E.isEmptyObject(t))&&E.isEmptyObject(f))return;d&&1===e.nodeType&&(n.overflow=[h.overflow,h.overflowX,h.overflowY],null==(c=m&&m.display)&&(c=X.get(e,"display")),"none"===(u=E.css(e,"display"))&&(c?u=c:(ie([e],!0),c=e.style.display||c,u=E.css(e,"display"),ie([e]))),("inline"===u||"inline-block"===u&&null!=c)&&"none"===E.css(e,"float")&&(a||(p.done(function(){h.display=c}),null==c&&(u=h.display,c="none"===u?"":u)),h.display="inline-block"));n.overflow&&(h.overflow="hidden",p.always(function(){h.overflow=n.overflow[0],h.overflowX=n.overflow[1],h.overflowY=n.overflow[2]}));for(o in a=!1,f)a||(m?"hidden"in m&&(g=m.hidden):m=X.access(e,"fxshow",{display:c}),i&&(m.hidden=!g),g&&ie([e],!0),p.done(function(){for(o in g||ie([e]),X.remove(e,"fxshow"),f)E.style(e,o,f[o])})),a=ct(g?m[o]:0,o,p),o in m||(m[o]=a.start,g&&(a.end=a.start,a.start=0))}],prefilter:function(e,t){t?ut.prefilters.unshift(e):ut.prefilters.push(e)}}),E.speed=function(e,t,n){var o=e&&"object"==typeof e?E.extend({},e):{complete:n||!n&&t||E.isFunction(e)&&e,duration:e,easing:n&&t||t&&!E.isFunction(t)&&t};return E.fx.off?o.duration=0:"number"!=typeof o.duration&&(o.duration in E.fx.speeds?o.duration=E.fx.speeds[o.duration]:o.duration=E.fx.speeds._default),null!=o.queue&&!0!==o.queue||(o.queue="fx"),o.old=o.complete,o.complete=function(){E.isFunction(o.old)&&o.old.call(this),o.queue&&E.dequeue(this,o.queue)},o},E.fn.extend({fadeTo:function(e,t,n,o){return this.filter(ee).css("opacity",0).show().end().animate({opacity:t},e,n,o)},animate:function(t,e,n,o){var r=E.isEmptyObject(t),i=E.speed(e,n,o),l=function(){var e=ut(this,E.extend({},t),i);(r||X.get(this,"finish"))&&e.stop(!0)};return l.finish=l,r||!1===i.queue?this.each(l):this.queue(i.queue,l)},stop:function(r,e,i){var l=function(e){var t=e.stop;delete e.stop,t(i)};return"string"!=typeof r&&(i=e,e=r,r=void 0),e&&!1!==r&&this.queue(r||"fx",[]),this.each(function(){var e=!0,t=null!=r&&r+"queueHooks",n=E.timers,o=X.get(this);if(t)o[t]&&o[t].stop&&l(o[t]);else for(t in o)o[t]&&o[t].stop&&it.test(t)&&l(o[t]);for(t=n.length;t--;)n[t].elem!==this||null!=r&&n[t].queue!==r||(n[t].anim.stop(i),e=!1,n.splice(t,1));!e&&i||E.dequeue(this,r)})},finish:function(l){return!1!==l&&(l=l||"fx"),this.each(function(){var e,t=X.get(this),n=t[l+"queue"],o=t[l+"queueHooks"],r=E.timers,i=n?n.length:0;for(t.finish=!0,E.queue(this,l,[]),o&&o.stop&&o.stop.call(this,!0),e=r.length;e--;)r[e].elem===this&&r[e].queue===l&&(r[e].anim.stop(!0),r.splice(e,1));for(e=0;e<i;e++)n[e]&&n[e].finish&&n[e].finish.call(this);delete t.finish})}}),E.each(["toggle","show","hide"],function(e,o){var r=E.fn[o];E.fn[o]=function(e,t,n){return null==e||"boolean"==typeof e?r.apply(this,arguments):this.animate(at(o,!0),e,t,n)}}),E.each({slideDown:at("show"),slideUp:at("hide"),slideToggle:at("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(e,o){E.fn[e]=function(e,t,n){return this.animate(o,e,t,n)}}),E.timers=[],E.fx.tick=function(){var e,t=0,n=E.timers;for(Ze=E.now();t<n.length;t++)(e=n[t])()||n[t]!==e||n.splice(t--,1);n.length||E.fx.stop(),Ze=void 0},E.fx.timer=function(e){E.timers.push(e),E.fx.start()},E.fx.interval=13,E.fx.start=function(){et||(et=!0,lt())},E.fx.stop=function(){et=null},E.fx.speeds={slow:600,fast:200,_default:400},E.fn.delay=function(o,e){return o=E.fx&&E.fx.speeds[o]||o,e=e||"fx",this.queue(e,function(e,t){var n=R.setTimeout(e,o);t.stop=function(){R.clearTimeout(n)}})},tt=S.createElement("input"),nt=S.createElement("select"),ot=nt.appendChild(S.createElement("option")),tt.type="checkbox",m.checkOn=""!==tt.value,m.optSelected=ot.selected,(tt=S.createElement("input")).value="t",tt.type="radio",m.radioValue="t"===tt.value;var dt,pt=E.expr.attrHandle;E.fn.extend({attr:function(e,t){return q(this,E.attr,e,t,1<arguments.length)},removeAttr:function(e){return this.each(function(){E.removeAttr(this,e)})}}),E.extend({attr:function(e,t,n){var o,r,i=e.nodeType;if(3!==i&&8!==i&&2!==i)return void 0===e.getAttribute?E.prop(e,t,n):(1===i&&E.isXMLDoc(e)||(r=E.attrHooks[t.toLowerCase()]||(E.expr.match.bool.test(t)?dt:void 0)),void 0!==n?null===n?void E.removeAttr(e,t):r&&"set"in r&&void 0!==(o=r.set(e,n,t))?o:(e.setAttribute(t,n+""),n):r&&"get"in r&&null!==(o=r.get(e,t))?o:null==(o=E.find.attr(e,t))?void 0:o)},attrHooks:{type:{set:function(e,t){if(!m.radioValue&&"radio"===t&&k(e,"input")){var n=e.value;return e.setAttribute("type",t),n&&(e.value=n),t}}}},removeAttr:function(e,t){var n,o=0,r=t&&t.match(F);if(r&&1===e.nodeType)for(;n=r[o++];)e.removeAttribute(n)}}),dt={set:function(e,t,n){return!1===t?E.removeAttr(e,n):e.setAttribute(n,n),n}},E.each(E.expr.match.bool.source.match(/\w+/g),function(e,t){var l=pt[t]||E.find.attr;pt[t]=function(e,t,n){var o,r,i=t.toLowerCase();return n||(r=pt[i],pt[i]=o,o=null!=l(e,t,n)?i:null,pt[i]=r),o}});var ft=/^(?:input|select|textarea|button)$/i,ht=/^(?:a|area)$/i;function gt(e){var t=e.match(F)||[];return t.join(" ")}function mt(e){return e.getAttribute&&e.getAttribute("class")||""}E.fn.extend({prop:function(e,t){return q(this,E.prop,e,t,1<arguments.length)},removeProp:function(e){return this.each(function(){delete this[E.propFix[e]||e]})}}),E.extend({prop:function(e,t,n){var o,r,i=e.nodeType;if(3!==i&&8!==i&&2!==i)return 1===i&&E.isXMLDoc(e)||(t=E.propFix[t]||t,r=E.propHooks[t]),void 0!==n?r&&"set"in r&&void 0!==(o=r.set(e,n,t))?o:e[t]=n:r&&"get"in r&&null!==(o=r.get(e,t))?o:e[t]},propHooks:{tabIndex:{get:function(e){var t=E.find.attr(e,"tabindex");return t?parseInt(t,10):ft.test(e.nodeName)||ht.test(e.nodeName)&&e.href?0:-1}}},propFix:{for:"htmlFor",class:"className"}}),m.optSelected||(E.propHooks.selected={get:function(e){var t=e.parentNode;return t&&t.parentNode&&t.parentNode.selectedIndex,null},set:function(e){var t=e.parentNode;t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex)}}),E.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){E.propFix[this.toLowerCase()]=this}),E.fn.extend({addClass:function(t){var e,n,o,r,i,l,s,a=0;if(E.isFunction(t))return this.each(function(e){E(this).addClass(t.call(this,e,mt(this)))});if("string"==typeof t&&t)for(e=t.match(F)||[];n=this[a++];)if(r=mt(n),o=1===n.nodeType&&" "+gt(r)+" "){for(l=0;i=e[l++];)o.indexOf(" "+i+" ")<0&&(o+=i+" ");s=gt(o),r!==s&&n.setAttribute("class",s)}return this},removeClass:function(t){var e,n,o,r,i,l,s,a=0;if(E.isFunction(t))return this.each(function(e){E(this).removeClass(t.call(this,e,mt(this)))});if(!arguments.length)return this.attr("class","");if("string"==typeof t&&t)for(e=t.match(F)||[];n=this[a++];)if(r=mt(n),o=1===n.nodeType&&" "+gt(r)+" "){for(l=0;i=e[l++];)for(;-1<o.indexOf(" "+i+" ");)o=o.replace(" "+i+" "," ");s=gt(o),r!==s&&n.setAttribute("class",s)}return this},toggleClass:function(r,t){var i=typeof r;return"boolean"==typeof t&&"string"===i?t?this.addClass(r):this.removeClass(r):E.isFunction(r)?this.each(function(e){E(this).toggleClass(r.call(this,e,mt(this),t),t)}):this.each(function(){var e,t,n,o;if("string"===i)for(t=0,n=E(this),o=r.match(F)||[];e=o[t++];)n.hasClass(e)?n.removeClass(e):n.addClass(e);else void 0!==r&&"boolean"!==i||((e=mt(this))&&X.set(this,"__className__",e),this.setAttribute&&this.setAttribute("class",e||!1===r?"":X.get(this,"__className__")||""))})},hasClass:function(e){var t,n,o=0;for(t=" "+e+" ";n=this[o++];)if(1===n.nodeType&&-1<(" "+gt(mt(n))+" ").indexOf(t))return!0;return!1}});var vt=/\r/g;E.fn.extend({val:function(n){var o,e,r,t=this[0];return arguments.length?(r=E.isFunction(n),this.each(function(e){var t;1===this.nodeType&&(null==(t=r?n.call(this,e,E(this).val()):n)?t="":"number"==typeof t?t+="":Array.isArray(t)&&(t=E.map(t,function(e){return null==e?"":e+""})),(o=E.valHooks[this.type]||E.valHooks[this.nodeName.toLowerCase()])&&"set"in o&&void 0!==o.set(this,t,"value")||(this.value=t))})):t?(o=E.valHooks[t.type]||E.valHooks[t.nodeName.toLowerCase()])&&"get"in o&&void 0!==(e=o.get(t,"value"))?e:"string"==typeof(e=t.value)?e.replace(vt,""):null==e?"":e:void 0}}),E.extend({valHooks:{option:{get:function(e){var t=E.find.attr(e,"value");return null!=t?t:gt(E.text(e))}},select:{get:function(e){var t,n,o,r=e.options,i=e.selectedIndex,l="select-one"===e.type,s=l?null:[],a=l?i+1:r.length;for(o=i<0?a:l?i:0;o<a;o++)if(((n=r[o]).selected||o===i)&&!n.disabled&&(!n.parentNode.disabled||!k(n.parentNode,"optgroup"))){if(t=E(n).val(),l)return t;s.push(t)}return s},set:function(e,t){for(var n,o,r=e.options,i=E.makeArray(t),l=r.length;l--;)((o=r[l]).selected=-1<E.inArray(E.valHooks.option.get(o),i))&&(n=!0);return n||(e.selectedIndex=-1),i}}}}),E.each(["radio","checkbox"],function(){E.valHooks[this]={set:function(e,t){if(Array.isArray(t))return e.checked=-1<E.inArray(E(e).val(),t)}},m.checkOn||(E.valHooks[this].get=function(e){return null===e.getAttribute("value")?"on":e.value})});var wt=/^(?:focusinfocus|focusoutblur)$/;E.extend(E.event,{trigger:function(e,t,n,o){var r,i,l,s,a,c,u,d=[n||S],p=h.call(e,"type")?e.type:e,f=h.call(e,"namespace")?e.namespace.split("."):[];if(i=l=n=n||S,3!==n.nodeType&&8!==n.nodeType&&!wt.test(p+E.event.triggered)&&(-1<p.indexOf(".")&&(p=(f=p.split(".")).shift(),f.sort()),a=p.indexOf(":")<0&&"on"+p,(e=e[E.expando]?e:new E.Event(p,"object"==typeof e&&e)).isTrigger=o?2:3,e.namespace=f.join("."),e.rnamespace=e.namespace?new RegExp("(^|\\.)"+f.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,e.result=void 0,e.target||(e.target=n),t=null==t?[e]:E.makeArray(t,[e]),u=E.event.special[p]||{},o||!u.trigger||!1!==u.trigger.apply(n,t))){if(!o&&!u.noBubble&&!E.isWindow(n)){for(s=u.delegateType||p,wt.test(s+p)||(i=i.parentNode);i;i=i.parentNode)d.push(i),l=i;l===(n.ownerDocument||S)&&d.push(l.defaultView||l.parentWindow||R)}for(r=0;(i=d[r++])&&!e.isPropagationStopped();)e.type=1<r?s:u.bindType||p,(c=(X.get(i,"events")||{})[e.type]&&X.get(i,"handle"))&&c.apply(i,t),(c=a&&i[a])&&c.apply&&O(i)&&(e.result=c.apply(i,t),!1===e.result&&e.preventDefault());return e.type=p,o||e.isDefaultPrevented()||u._default&&!1!==u._default.apply(d.pop(),t)||!O(n)||a&&E.isFunction(n[p])&&!E.isWindow(n)&&((l=n[a])&&(n[a]=null),E.event.triggered=p,n[p](),E.event.triggered=void 0,l&&(n[a]=l)),e.result}},simulate:function(e,t,n){var o=E.extend(new E.Event,n,{type:e,isSimulated:!0});E.event.trigger(o,null,t)}}),E.fn.extend({trigger:function(e,t){return this.each(function(){E.event.trigger(e,t,this)})},triggerHandler:function(e,t){var n=this[0];if(n)return E.event.trigger(e,t,n,!0)}}),E.each("blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),function(e,n){E.fn[n]=function(e,t){return 0<arguments.length?this.on(n,null,e,t):this.trigger(n)}}),E.fn.extend({hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)}}),m.focusin="onfocusin"in R,m.focusin||E.each({focus:"focusin",blur:"focusout"},function(n,o){var r=function(e){E.event.simulate(o,e.target,E.event.fix(e))};E.event.special[o]={setup:function(){var e=this.ownerDocument||this,t=X.access(e,o);t||e.addEventListener(n,r,!0),X.access(e,o,(t||0)+1)},teardown:function(){var e=this.ownerDocument||this,t=X.access(e,o)-1;t?X.access(e,o,t):(e.removeEventListener(n,r,!0),X.remove(e,o))}}});var yt=R.location,Ct=E.now(),bt=/\?/;E.parseXML=function(e){var t;if(!e||"string"!=typeof e)return null;try{t=(new R.DOMParser).parseFromString(e,"text/xml")}catch(e){t=void 0}return t&&!t.getElementsByTagName("parsererror").length||E.error("Invalid XML: "+e),t};var xt=/\[\]$/,Rt=/\r?\n/g,St=/^(?:submit|button|image|reset|file)$/i,Et=/^(?:input|select|textarea|keygen)/i;function kt(n,e,o,r){var t;if(Array.isArray(e))E.each(e,function(e,t){o||xt.test(n)?r(n,t):kt(n+"["+("object"==typeof t&&null!=t?e:"")+"]",t,o,r)});else if(o||"object"!==E.type(e))r(n,e);else for(t in e)kt(n+"["+t+"]",e[t],o,r)}E.param=function(e,t){var n,o=[],r=function(e,t){var n=E.isFunction(t)?t():t;o[o.length]=encodeURIComponent(e)+"="+encodeURIComponent(null==n?"":n)};if(Array.isArray(e)||e.jquery&&!E.isPlainObject(e))E.each(e,function(){r(this.name,this.value)});else for(n in e)kt(n,e[n],t,r);return o.join("&")},E.fn.extend({serialize:function(){return E.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=E.prop(this,"elements");return e?E.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!E(this).is(":disabled")&&Et.test(this.nodeName)&&!St.test(e)&&(this.checked||!le.test(e))}).map(function(e,t){var n=E(this).val();return null==n?null:Array.isArray(n)?E.map(n,function(e){return{name:t.name,value:e.replace(Rt,"\r\n")}}):{name:t.name,value:n.replace(Rt,"\r\n")}}).get()}});var Tt=/%20/g,Pt=/#.*$/,Dt=/([?&])_=[^&]*/,At=/^(.*?):[ \t]*([^\r\n]*)$/gm,Nt=/^(?:GET|HEAD)$/,$t=/^\/\//,Ht={},Lt={},_t="*/".concat("*"),Ft=S.createElement("a");function It(i){return function(e,t){"string"!=typeof e&&(t=e,e="*");var n,o=0,r=e.toLowerCase().match(F)||[];if(E.isFunction(t))for(;n=r[o++];)"+"===n[0]?(n=n.slice(1)||"*",(i[n]=i[n]||[]).unshift(t)):(i[n]=i[n]||[]).push(t)}}function Mt(t,r,i,l){var s={},a=t===Lt;function c(e){var o;return s[e]=!0,E.each(t[e]||[],function(e,t){var n=t(r,i,l);return"string"!=typeof n||a||s[n]?a?!(o=n):void 0:(r.dataTypes.unshift(n),c(n),!1)}),o}return c(r.dataTypes[0])||!s["*"]&&c("*")}function Wt(e,t){var n,o,r=E.ajaxSettings.flatOptions||{};for(n in t)void 0!==t[n]&&((r[n]?e:o||(o={}))[n]=t[n]);return o&&E.extend(!0,e,o),e}Ft.href=yt.href,E.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:yt.href,type:"GET",isLocal:/^(?:about|app|app-storage|.+-extension|file|res|widget):$/.test(yt.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":_t,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":E.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?Wt(Wt(e,E.ajaxSettings),t):Wt(E.ajaxSettings,e)},ajaxPrefilter:It(Ht),ajaxTransport:It(Lt),ajax:function(e,t){"object"==typeof e&&(t=e,e=void 0),t=t||{};var u,d,p,n,f,o,h,g,r,i,m=E.ajaxSetup({},t),v=m.context||m,w=m.context&&(v.nodeType||v.jquery)?E(v):E.event,y=E.Deferred(),C=E.Callbacks("once memory"),b=m.statusCode||{},l={},s={},a="canceled",x={readyState:0,getResponseHeader:function(e){var t;if(h){if(!n)for(n={};t=At.exec(p);)n[t[1].toLowerCase()]=t[2];t=n[e.toLowerCase()]}return null==t?null:t},getAllResponseHeaders:function(){return h?p:null},setRequestHeader:function(e,t){return null==h&&(e=s[e.toLowerCase()]=s[e.toLowerCase()]||e,l[e]=t),this},overrideMimeType:function(e){return null==h&&(m.mimeType=e),this},statusCode:function(e){var t;if(e)if(h)x.always(e[x.status]);else for(t in e)b[t]=[b[t],e[t]];return this},abort:function(e){var t=e||a;return u&&u.abort(t),c(0,t),this}};if(y.promise(x),m.url=((e||m.url||yt.href)+"").replace($t,yt.protocol+"//"),m.type=t.method||t.type||m.method||m.type,m.dataTypes=(m.dataType||"*").toLowerCase().match(F)||[""],null==m.crossDomain){o=S.createElement("a");try{o.href=m.url,o.href=o.href,m.crossDomain=Ft.protocol+"//"+Ft.host!=o.protocol+"//"+o.host}catch(e){m.crossDomain=!0}}if(m.data&&m.processData&&"string"!=typeof m.data&&(m.data=E.param(m.data,m.traditional)),Mt(Ht,m,t,x),h)return x;for(r in(g=E.event&&m.global)&&0==E.active++&&E.event.trigger("ajaxStart"),m.type=m.type.toUpperCase(),m.hasContent=!Nt.test(m.type),d=m.url.replace(Pt,""),m.hasContent?m.data&&m.processData&&0===(m.contentType||"").indexOf("application/x-www-form-urlencoded")&&(m.data=m.data.replace(Tt,"+")):(i=m.url.slice(d.length),m.data&&(d+=(bt.test(d)?"&":"?")+m.data,delete m.data),!1===m.cache&&(d=d.replace(Dt,"$1"),i=(bt.test(d)?"&":"?")+"_="+Ct+++i),m.url=d+i),m.ifModified&&(E.lastModified[d]&&x.setRequestHeader("If-Modified-Since",E.lastModified[d]),E.etag[d]&&x.setRequestHeader("If-None-Match",E.etag[d])),(m.data&&m.hasContent&&!1!==m.contentType||t.contentType)&&x.setRequestHeader("Content-Type",m.contentType),x.setRequestHeader("Accept",m.dataTypes[0]&&m.accepts[m.dataTypes[0]]?m.accepts[m.dataTypes[0]]+("*"!==m.dataTypes[0]?", "+_t+"; q=0.01":""):m.accepts["*"]),m.headers)x.setRequestHeader(r,m.headers[r]);if(m.beforeSend&&(!1===m.beforeSend.call(v,x,m)||h))return x.abort();if(a="abort",C.add(m.complete),x.done(m.success),x.fail(m.error),u=Mt(Lt,m,t,x)){if(x.readyState=1,g&&w.trigger("ajaxSend",[x,m]),h)return x;m.async&&0<m.timeout&&(f=R.setTimeout(function(){x.abort("timeout")},m.timeout));try{h=!1,u.send(l,c)}catch(e){if(h)throw e;c(-1,e)}}else c(-1,"No Transport");function c(e,t,n,o){var r,i,l,s,a,c=t;h||(h=!0,f&&R.clearTimeout(f),u=void 0,p=o||"",x.readyState=0<e?4:0,r=200<=e&&e<300||304===e,n&&(s=function(e,t,n){var o,r,i,l,s=e.contents,a=e.dataTypes;for(;"*"===a[0];)a.shift(),void 0===o&&(o=e.mimeType||t.getResponseHeader("Content-Type"));if(o)for(r in s)if(s[r]&&s[r].test(o)){a.unshift(r);break}if(a[0]in n)i=a[0];else{for(r in n){if(!a[0]||e.converters[r+" "+a[0]]){i=r;break}l||(l=r)}i=i||l}if(i)return i!==a[0]&&a.unshift(i),n[i]}(m,x,n)),s=function(e,t,n,o){var r,i,l,s,a,c={},u=e.dataTypes.slice();if(u[1])for(l in e.converters)c[l.toLowerCase()]=e.converters[l];i=u.shift();for(;i;)if(e.responseFields[i]&&(n[e.responseFields[i]]=t),!a&&o&&e.dataFilter&&(t=e.dataFilter(t,e.dataType)),a=i,i=u.shift())if("*"===i)i=a;else if("*"!==a&&a!==i){if(!(l=c[a+" "+i]||c["* "+i]))for(r in c)if((s=r.split(" "))[1]===i&&(l=c[a+" "+s[0]]||c["* "+s[0]])){!0===l?l=c[r]:!0!==c[r]&&(i=s[0],u.unshift(s[1]));break}if(!0!==l)if(l&&e.throws)t=l(t);else try{t=l(t)}catch(e){return{state:"parsererror",error:l?e:"No conversion from "+a+" to "+i}}}return{state:"success",data:t}}(m,s,x,r),r?(m.ifModified&&((a=x.getResponseHeader("Last-Modified"))&&(E.lastModified[d]=a),(a=x.getResponseHeader("etag"))&&(E.etag[d]=a)),204===e||"HEAD"===m.type?c="nocontent":304===e?c="notmodified":(c=s.state,i=s.data,l=s.error,r=!l)):(l=c,!e&&c||(c="error",e<0&&(e=0))),x.status=e,x.statusText=(t||c)+"",r?y.resolveWith(v,[i,c,x]):y.rejectWith(v,[x,c,l]),x.statusCode(b),b=void 0,g&&w.trigger(r?"ajaxSuccess":"ajaxError",[x,m,r?i:l]),C.fireWith(v,[x,c]),g&&(w.trigger("ajaxComplete",[x,m]),--E.active||E.event.trigger("ajaxStop")))}return x},getJSON:function(e,t,n){return E.get(e,t,n,"json")},getScript:function(e,t){return E.get(e,void 0,t,"script")}}),E.each(["get","post"],function(e,r){E[r]=function(e,t,n,o){return E.isFunction(t)&&(o=o||n,n=t,t=void 0),E.ajax(E.extend({url:e,type:r,dataType:o,data:t,success:n},E.isPlainObject(e)&&e))}}),E._evalUrl=function(e){return E.ajax({url:e,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,throws:!0})},E.fn.extend({wrapAll:function(e){var t;return this[0]&&(E.isFunction(e)&&(e=e.call(this[0])),t=E(e,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){for(var e=this;e.firstElementChild;)e=e.firstElementChild;return e}).append(this)),this},wrapInner:function(n){return E.isFunction(n)?this.each(function(e){E(this).wrapInner(n.call(this,e))}):this.each(function(){var e=E(this),t=e.contents();t.length?t.wrapAll(n):e.append(n)})},wrap:function(t){var n=E.isFunction(t);return this.each(function(e){E(this).wrapAll(n?t.call(this,e):t)})},unwrap:function(e){return this.parent(e).not("body").each(function(){E(this).replaceWith(this.childNodes)}),this}}),E.expr.pseudos.hidden=function(e){return!E.expr.pseudos.visible(e)},E.expr.pseudos.visible=function(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)},E.ajaxSettings.xhr=function(){try{return new R.XMLHttpRequest}catch(e){}};var jt={0:200,1223:204},Vt=E.ajaxSettings.xhr();m.cors=!!Vt&&"withCredentials"in Vt,m.ajax=Vt=!!Vt,E.ajaxTransport(function(r){var i,l;if(m.cors||Vt&&!r.crossDomain)return{send:function(e,t){var n,o=r.xhr();if(o.open(r.type,r.url,r.async,r.username,r.password),r.xhrFields)for(n in r.xhrFields)o[n]=r.xhrFields[n];for(n in r.mimeType&&o.overrideMimeType&&o.overrideMimeType(r.mimeType),r.crossDomain||e["X-Requested-With"]||(e["X-Requested-With"]="XMLHttpRequest"),e)o.setRequestHeader(n,e[n]);i=function(e){return function(){i&&(i=l=o.onload=o.onerror=o.onabort=o.onreadystatechange=null,"abort"===e?o.abort():"error"===e?"number"!=typeof o.status?t(0,"error"):t(o.status,o.statusText):t(jt[o.status]||o.status,o.statusText,"text"!==(o.responseType||"text")||"string"!=typeof o.responseText?{binary:o.response}:{text:o.responseText},o.getAllResponseHeaders()))}},o.onload=i(),l=o.onerror=i("error"),void 0!==o.onabort?o.onabort=l:o.onreadystatechange=function(){4===o.readyState&&R.setTimeout(function(){i&&l()})},i=i("abort");try{o.send(r.hasContent&&r.data||null)}catch(e){if(i)throw e}},abort:function(){i&&i()}}}),E.ajaxPrefilter(function(e){e.crossDomain&&(e.contents.script=!1)}),E.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(e){return E.globalEval(e),e}}}),E.ajaxPrefilter("script",function(e){void 0===e.cache&&(e.cache=!1),e.crossDomain&&(e.type="GET")}),E.ajaxTransport("script",function(n){var o,r;if(n.crossDomain)return{send:function(e,t){o=E("<script>").prop({charset:n.scriptCharset,src:n.url}).on("load error",r=function(e){o.remove(),r=null,e&&t("error"===e.type?404:200,e.type)}),S.head.appendChild(o[0])},abort:function(){r&&r()}}});var Bt,qt=[],Ot=/(=)\?(?=&|$)|\?\?/;E.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=qt.pop()||E.expando+"_"+Ct++;return this[e]=!0,e}}),E.ajaxPrefilter("json jsonp",function(e,t,n){var o,r,i,l=!1!==e.jsonp&&(Ot.test(e.url)?"url":"string"==typeof e.data&&0===(e.contentType||"").indexOf("application/x-www-form-urlencoded")&&Ot.test(e.data)&&"data");if(l||"jsonp"===e.dataTypes[0])return o=e.jsonpCallback=E.isFunction(e.jsonpCallback)?e.jsonpCallback():e.jsonpCallback,l?e[l]=e[l].replace(Ot,"$1"+o):!1!==e.jsonp&&(e.url+=(bt.test(e.url)?"&":"?")+e.jsonp+"="+o),e.converters["script json"]=function(){return i||E.error(o+" was not called"),i[0]},e.dataTypes[0]="json",r=R[o],R[o]=function(){i=arguments},n.always(function(){void 0===r?E(R).removeProp(o):R[o]=r,e[o]&&(e.jsonpCallback=t.jsonpCallback,qt.push(o)),i&&E.isFunction(r)&&r(i[0]),i=r=void 0}),"script"}),m.createHTMLDocument=((Bt=S.implementation.createHTMLDocument("").body).innerHTML="<form></form><form></form>",2===Bt.childNodes.length),E.parseHTML=function(e,t,n){return"string"!=typeof e?[]:("boolean"==typeof t&&(n=t,t=!1),t||(m.createHTMLDocument?(t=S.implementation.createHTMLDocument(""),(o=t.createElement("base")).href=S.location.href,t.head.appendChild(o)):t=S),r=T.exec(e),i=!n&&[],r?[t.createElement(r[1])]:(r=me([e],t,i),i&&i.length&&E(i).remove(),E.merge([],r.childNodes)));var o,r,i},E.fn.load=function(e,t,n){var o,r,i,l=this,s=e.indexOf(" ");return-1<s&&(o=gt(e.slice(s)),e=e.slice(0,s)),E.isFunction(t)?(n=t,t=void 0):t&&"object"==typeof t&&(r="POST"),0<l.length&&E.ajax({url:e,type:r||"GET",dataType:"html",data:t}).done(function(e){i=arguments,l.html(o?E("<div>").append(E.parseHTML(e)).find(o):e)}).always(n&&function(e,t){l.each(function(){n.apply(this,i||[e.responseText,t,e])})}),this},E.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(e,t){E.fn[t]=function(e){return this.on(t,e)}}),E.expr.pseudos.animated=function(t){return E.grep(E.timers,function(e){return t===e.elem}).length},E.offset={setOffset:function(e,t,n){var o,r,i,l,s,a,c=E.css(e,"position"),u=E(e),d={};"static"===c&&(e.style.position="relative"),s=u.offset(),i=E.css(e,"top"),a=E.css(e,"left"),("absolute"===c||"fixed"===c)&&-1<(i+a).indexOf("auto")?(o=u.position(),l=o.top,r=o.left):(l=parseFloat(i)||0,r=parseFloat(a)||0),E.isFunction(t)&&(t=t.call(e,n,E.extend({},s))),null!=t.top&&(d.top=t.top-s.top+l),null!=t.left&&(d.left=t.left-s.left+r),"using"in t?t.using.call(e,d):u.css(d)}},E.fn.extend({offset:function(t){if(arguments.length)return void 0===t?this:this.each(function(e){E.offset.setOffset(this,t,e)});var e,n,o,r,i=this[0];return i?i.getClientRects().length?(o=i.getBoundingClientRect(),e=i.ownerDocument,n=e.documentElement,r=e.defaultView,{top:o.top+r.pageYOffset-n.clientTop,left:o.left+r.pageXOffset-n.clientLeft}):{top:0,left:0}:void 0},position:function(){if(this[0]){var e,t,n=this[0],o={top:0,left:0};return"fixed"===E.css(n,"position")?t=n.getBoundingClientRect():(e=this.offsetParent(),t=this.offset(),k(e[0],"html")||(o=e.offset()),o={top:o.top+E.css(e[0],"borderTopWidth",!0),left:o.left+E.css(e[0],"borderLeftWidth",!0)}),{top:t.top-o.top-E.css(n,"marginTop",!0),left:t.left-o.left-E.css(n,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){for(var e=this.offsetParent;e&&"static"===E.css(e,"position");)e=e.offsetParent;return e||ve})}}),E.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(t,r){var i="pageYOffset"===r;E.fn[t]=function(e){return q(this,function(e,t,n){var o;if(E.isWindow(e)?o=e:9===e.nodeType&&(o=e.defaultView),void 0===n)return o?o[r]:e[t];o?o.scrollTo(i?o.pageXOffset:n,i?n:o.pageYOffset):e[t]=n},t,e,arguments.length)}}),E.each(["top","left"],function(e,n){E.cssHooks[n]=Ve(m.pixelPosition,function(e,t){if(t)return t=je(e,n),Me.test(t)?E(e).position()[n]+"px":t})}),E.each({Height:"height",Width:"width"},function(l,s){E.each({padding:"inner"+l,content:s,"":"outer"+l},function(o,i){E.fn[i]=function(e,t){var n=arguments.length&&(o||"boolean"!=typeof e),r=o||(!0===e||!0===t?"margin":"border");return q(this,function(e,t,n){var o;return E.isWindow(e)?0===i.indexOf("outer")?e["inner"+l]:e.document.documentElement["client"+l]:9===e.nodeType?(o=e.documentElement,Math.max(e.body["scroll"+l],o["scroll"+l],e.body["offset"+l],o["offset"+l],o["client"+l])):void 0===n?E.css(e,t,r):E.style(e,t,n,r)},s,n?e:void 0,n)}})}),E.fn.extend({bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,o){return this.on(t,e,n,o)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,"**"):this.off(t,e||"**",n)}}),E.holdReady=function(e){e?E.readyWait++:E.ready(!0)},E.isArray=Array.isArray,E.parseJSON=JSON.parse,E.nodeName=k,"function"==typeof define&&define.amd&&define("jquery",[],function(){return E});var zt=R.jQuery,Xt=R.$;return E.noConflict=function(e){return R.$===E&&(R.$=Xt),e&&R.jQuery===E&&(R.jQuery=zt),E},e||(R.jQuery=R.$=E),E})},442:function(e,t,n){
/*!
     * jquery.event.drag - v 2.3.0
     * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
     * Open Source MIT License - http://threedubmedia.com/code/license
     */
var f=e(448);f.fn.drag=function(e,t,n){var o="string"==typeof e?e:"",r=f.isFunction(e)?e:f.isFunction(t)?t:null;return 0!==o.indexOf("drag")&&(o="drag"+o),n=(e==r?t:n)||{},r?this.on(o,n,r):this.trigger(o)};var h=f.event,o=h.special,g=o.drag={defaults:{which:1,distance:0,not:":input",handle:null,relative:!1,drop:!0,click:!1},datakey:"dragdata",noBubble:!0,add:function(e){var n=f.data(this,g.datakey),o=e.data||{};n.related+=1,f.each(g.defaults,function(e,t){void 0!==o[e]&&(n[e]=o[e])})},remove:function(){f.data(this,g.datakey).related-=1},setup:function(){if(!f.data(this,g.datakey)){var e=f.extend({related:0},g.defaults);f.data(this,g.datakey,e),h.add(this,"touchstart mousedown",g.init,e),this.attachEvent&&this.attachEvent("ondragstart",g.dontstart)}},teardown:function(){var e=f.data(this,g.datakey)||{};e.related||(f.removeData(this,g.datakey),h.remove(this,"touchstart mousedown",g.init),g.textselect(!0),this.detachEvent&&this.detachEvent("ondragstart",g.dontstart))},init:function(e){if(!g.touched){var t,n=e.data;if(!(0!=e.which&&0<n.which&&e.which!=n.which)&&!f(e.target).is(n.not)&&(!n.handle||f(e.target).closest(n.handle,e.currentTarget).length)&&(g.touched="touchstart"==e.type?this:null,n.propagates=1,n.mousedown=this,n.interactions=[g.interaction(this,n)],n.target=e.target,n.pageX=e.pageX,n.pageY=e.pageY,n.dragging=null,t=g.hijack(e,"draginit",n),n.propagates))return(t=g.flatten(t))&&t.length&&(n.interactions=[],f.each(t,function(){n.interactions.push(g.interaction(this,n))})),n.propagates=n.interactions.length,!1!==n.drop&&o.drop&&o.drop.handler(e,n),g.textselect(!1),g.touched?h.add(g.touched,"touchmove touchend",g.handler,n):h.add(document,"mousemove mouseup",g.handler,n),!(!g.touched||n.live)&&void 0}},interaction:function(e,t){var n=e&&e.ownerDocument&&f(e)[t.relative?"position":"offset"]()||{top:0,left:0};return{drag:e,callback:new g.callback,droppable:[],offset:n}},handler:function(e){var t=e.data;switch(e.type){case!t.dragging&&"touchmove":e.preventDefault();case!t.dragging&&"mousemove":if(Math.pow(e.pageX-t.pageX,2)+Math.pow(e.pageY-t.pageY,2)<Math.pow(t.distance,2))break;e.target=t.target,g.hijack(e,"dragstart",t),t.propagates&&(t.dragging=!0);case"touchmove":e.preventDefault();case"mousemove":if(t.dragging){if(g.hijack(e,"drag",t),t.propagates){!1!==t.drop&&o.drop&&o.drop.handler(e,t);break}e.type="mouseup"}case"touchend":case"mouseup":default:g.touched?h.remove(g.touched,"touchmove touchend",g.handler):h.remove(document,"mousemove mouseup",g.handler),t.dragging&&(!1!==t.drop&&o.drop&&o.drop.handler(e,t),g.hijack(e,"dragend",t)),g.textselect(!0),!1===t.click&&t.dragging&&f.data(t.mousedown,"suppress.click",(new Date).getTime()+5),t.dragging=g.touched=!1}},hijack:function(n,o,r,e,t){if(r){var i,l,s,a={event:n.originalEvent,type:n.type},c=o.indexOf("drop")?"drag":"drop",u=e||0,d=isNaN(e)?r.interactions.length:e;n.type=o;var p=function(){};n.originalEvent=new f.Event(a.event,{preventDefault:p,stopPropagation:p,stopImmediatePropagation:p}),r.results=[];do{if(l=r.interactions[u]){if("dragend"!==o&&l.cancelled)continue;s=g.properties(n,r,l),l.results=[],f(t||l[c]||r.droppable).each(function(e,t){if(s.target=t,!(n.isPropagationStopped=function(){return!1})===(i=t?h.dispatch.call(t,n,s):null)?("drag"==c&&(l.cancelled=!0,r.propagates-=1),"drop"==o&&(l[c][e]=null)):"dropinit"==o&&l.droppable.push(g.element(i)||t),"dragstart"==o&&(l.proxy=f(g.element(i)||l.drag)[0]),l.results.push(i),delete n.result,"dropinit"!==o)return i}),r.results[u]=g.flatten(l.results),"dropinit"==o&&(l.droppable=g.flatten(l.droppable)),"dragstart"!=o||l.cancelled||s.update()}}while(++u<d);return n.type=a.type,n.originalEvent=a.event,g.flatten(r.results)}},properties:function(e,t,n){var o=n.callback;return o.drag=n.drag,o.proxy=n.proxy||n.drag,o.startX=t.pageX,o.startY=t.pageY,o.deltaX=e.pageX-t.pageX,o.deltaY=e.pageY-t.pageY,o.originalX=n.offset.left,o.originalY=n.offset.top,o.offsetX=o.originalX+o.deltaX,o.offsetY=o.originalY+o.deltaY,o.drop=g.flatten((n.drop||[]).slice()),o.available=g.flatten((n.droppable||[]).slice()),o},element:function(e){if(e&&(e.jquery||1==e.nodeType))return e},flatten:function(e){return f.map(e,function(e){return e&&e.jquery?f.makeArray(e):e&&e.length?g.flatten(e):e})},textselect:function(e){f(document)[e?"off":"on"]("selectstart",g.dontstart).css("MozUserSelect",e?"":"none"),document.unselectable=e?"off":"on"},dontstart:function(){return!1},callback:function(){}};g.callback.prototype={update:function(){o.drop&&this.available.length&&f.each(this.available,function(e){o.drop.locate(this,e)})}};var r=h.dispatch;h.dispatch=function(e){if(!(0<f.data(this,"suppress."+e.type)-(new Date).getTime()))return r.apply(this,arguments);f.removeData(this,"suppress."+e.type)},o.draginit=o.dragstart=o.dragend=g},443:function(e,t,n){
/*!
     * jquery.event.drop - v 2.3.0
     * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
     * Open Source MIT License - http://threedubmedia.com/code/license
     */
var f=e(448);f.fn.drop=function(e,t,n){var o="string"==typeof e?e:"",r=f.isFunction(e)?e:f.isFunction(t)?t:null;return 0!==o.indexOf("drop")&&(o="drop"+o),n=(e==r?t:n)||{},r?this.on(o,n,r):this.trigger(o)},f.drop=function(e){e=e||{},g.multi=!0===e.multi?1/0:!1===e.multi?1:isNaN(e.multi)?g.multi:e.multi,g.delay=e.delay||g.delay,g.tolerance=f.isFunction(e.tolerance)?e.tolerance:null===e.tolerance?null:g.tolerance,g.mode=e.mode||g.mode||"intersect"};var o=f.event,h=o.special,g=f.event.special.drop={multi:1,delay:20,mode:"overlap",targets:[],datakey:"dropdata",noBubble:!0,add:function(e){var t=f.data(this,g.datakey);t.related+=1},remove:function(){f.data(this,g.datakey).related-=1},setup:function(){if(!f.data(this,g.datakey)){f.data(this,g.datakey,{related:0,active:[],anyactive:0,winner:0,location:{}}),g.targets.push(this)}},teardown:function(){var e=f.data(this,g.datakey)||{};if(!e.related){f.removeData(this,g.datakey);var t=this;g.targets=f.grep(g.targets,function(e){return e!==t})}},handler:function(e,t){var n;if(t)switch(e.type){case"mousedown":case"touchstart":n=f(g.targets),"string"==typeof t.drop&&(n=n.filter(t.drop)),n.each(function(){var e=f.data(this,g.datakey);e.active=[],e.anyactive=0,e.winner=0}),t.droppable=n,h.drag.hijack(e,"dropinit",t);break;case"mousemove":case"touchmove":g.event=e,g.timer||g.tolerate(t);break;case"mouseup":case"touchend":g.timer=clearTimeout(g.timer),t.propagates&&(h.drag.hijack(e,"drop",t),h.drag.hijack(e,"dropend",t))}},locate:function(e,t){var n=f.data(e,g.datakey),o=f(e),r=o.offset()||{},i=o.outerHeight(),l=o.outerWidth(),s={elem:e,width:l,height:i,top:r.top,left:r.left,right:r.left+l,bottom:r.top+i};return n&&(n.location=s,n.index=t,n.elem=e),s},contains:function(e,t){return(t[0]||t.left)>=e.left&&(t[0]||t.right)<=e.right&&(t[1]||t.top)>=e.top&&(t[1]||t.bottom)<=e.bottom},modes:{intersect:function(e,t,n){return this.contains(n,[e.pageX,e.pageY])?1e9:this.modes.overlap.apply(this,arguments)},overlap:function(e,t,n){return Math.max(0,Math.min(n.bottom,t.bottom)-Math.max(n.top,t.top))*Math.max(0,Math.min(n.right,t.right)-Math.max(n.left,t.left))},fit:function(e,t,n){return this.contains(n,t)?1:0},middle:function(e,t,n){return this.contains(n,[t.left+.5*t.width,t.top+.5*t.height])?1:0}},sort:function(e,t){return t.winner-e.winner||e.index-t.index},tolerate:function(e){var t,n,o,r,i,l,s,a,c=0,u=e.interactions.length,d=[g.event.pageX,g.event.pageY],p=g.tolerance||g.modes[g.mode];do{if(a=e.interactions[c]){if(!a)return;a.drop=[],i=[],l=a.droppable.length,p&&(o=g.locate(a.proxy)),t=0;do{if(s=a.droppable[t]){if(r=f.data(s,g.datakey),!(n=r.location))continue;r.winner=p?p.call(g,g.event,o,n):g.contains(n,d)?1:0,i.push(r)}}while(++t<l);for(i.sort(g.sort),t=0;(r=i[t])&&(r.winner&&a.drop.length<g.multi?(r.active[c]||r.anyactive||(!1!==h.drag.hijack(g.event,"dropstart",e,c,r.elem)[0]?(r.active[c]=1,r.anyactive+=1):r.winner=0),r.winner&&a.drop.push(r.elem)):r.active[c]&&1==r.anyactive&&(h.drag.hijack(g.event,"dropend",e,c,r.elem),r.active[c]=0,r.anyactive-=1)),++t<l;);}}while(++c<u);g.last&&d[0]==g.last.pageX&&d[1]==g.last.pageY?delete g.timer:g.timer=setTimeout(function(){g.tolerate(e)},g.delay),g.last=g.event}};h.dropinit=h.dropstart=h.dropend=g},444:function(e,t,n){var d=e(448),p=e(446);t.exports={CheckboxSelectColumn:function(e){var l,t=new p.EventHandler,s={},a=d.extend(!0,{},{columnId:"_checkbox_selector",cssClass:null,toolTip:"Select/Deselect All",width:30},e);function n(e,t){var n,o,r=l.getSelectedRows(),i={};for(o=0;o<r.length;o++)n=r[o],i[n]=!0,i[n]!==s[n]&&(l.invalidateRow(n),delete s[n]);for(o in s)l.invalidateRow(o);s=i,l.render(),r.length&&r.length==l.getDataLength()?l.updateColumnHeader(a.columnId,"<input type='checkbox' checked='checked'>",a.toolTip):l.updateColumnHeader(a.columnId,"<input type='checkbox'>",a.toolTip)}function o(e,t){32==e.which&&l.getColumns()[t.cell].id===a.columnId&&(l.getEditorLock().isActive()&&!l.getEditorLock().commitCurrentEdit()||i(t.row),e.preventDefault(),e.stopImmediatePropagation())}function r(e,t){if(l.getColumns()[t.cell].id===a.columnId&&d(e.target).is(":checkbox")){if(l.getEditorLock().isActive()&&!l.getEditorLock().commitCurrentEdit())return e.preventDefault(),void e.stopImmediatePropagation();i(t.row),e.stopPropagation(),e.stopImmediatePropagation()}}function i(t){s[t]?l.setSelectedRows(d.grep(l.getSelectedRows(),function(e){return e!=t})):l.setSelectedRows(l.getSelectedRows().concat(t))}function c(e,t){if(t.column.id==a.columnId&&d(e.target).is(":checkbox")){if(l.getEditorLock().isActive()&&!l.getEditorLock().commitCurrentEdit())return e.preventDefault(),void e.stopImmediatePropagation();if(d(e.target).is(":checked")){for(var n=[],o=0;o<l.getDataLength();o++)n.push(o);l.setSelectedRows(n)}else l.setSelectedRows([]);e.stopPropagation(),e.stopImmediatePropagation()}}function u(e,t,n,o,r){return r?s[e]?"<input type='checkbox' checked='checked'>":"<input type='checkbox'>":null}d.extend(this,{init:function(e){l=e,t.subscribe(l.onSelectedRowsChanged,n).subscribe(l.onClick,r).subscribe(l.onHeaderClick,c).subscribe(l.onKeyDown,o)},destroy:function(){t.unsubscribeAll()},deSelectRows:function(e){var t,n=e.length,o=[];for(t=0;t<n;t++)s[e[t]]&&(o[o.length]=e[t]);l.setSelectedRows(d.grep(l.getSelectedRows(),function(e){return o.indexOf(e)<0}))},selectRows:function(e){var t,n=e.length,o=[];for(t=0;t<n;t++)s[e[t]]||(o[o.length]=e[t]);l.setSelectedRows(l.getSelectedRows().concat(o))},getColumnDefinition:function(){return{id:a.columnId,name:"<input type='checkbox'>",toolTip:a.toolTip,field:"sel",width:a.width,resizable:!1,sortable:!1,cssClass:a.cssClass,formatter:u}}})}}},445:function(e,t,n){var v=e(448),w=e(446);t.exports={RowSelectionModel:function(t){var c,n,o,u=[],r=this,i=new w.EventHandler,l={selectActiveRow:!0};function s(e){return function(){n||(n=!0,e.apply(this,arguments),n=!1)}}function d(e){for(var t=[],n=0;n<e.length;n++)for(var o=e[n].fromRow;o<=e[n].toRow;o++)t.push(o);return t}function p(e){for(var t=[],n=c.getColumns().length-1,o=0;o<e.length;o++)t.push(new w.Range(e[o],0,e[o],n));return t}function a(){return d(u)}function f(e){(u&&0!==u.length||e&&0!==e.length)&&(u=e,r.onSelectedRangesChanged.notify(u))}function h(e,t){o.selectActiveRow&&null!=t.row&&f([new w.Range(t.row,0,t.row,c.getColumns().length-1)])}function g(e){var t=c.getActiveCell();if(t&&e.shiftKey&&!e.ctrlKey&&!e.altKey&&!e.metaKey&&(38==e.which||40==e.which)){var n=a();n.sort(function(e,t){return e-t}),n.length||(n=[t.row]);var o,r=n[0],i=n[n.length-1];if(0<=(o=40==e.which?t.row<i||r==i?++i:++r:t.row<i?--i:--r)&&o<c.getDataLength()){c.scrollRowIntoView(o);var l=p(function(e,t){var n,o=[];for(n=e;n<=t;n++)o.push(n);for(n=t;n<e;n++)o.push(n);return o}(r,i));f(l)}e.preventDefault(),e.stopPropagation()}}function m(e){var n=c.getCellFromEvent(e);if(!n||!c.canCellBeActive(n.row,n.cell))return!1;if(!c.getOptions().multiSelect||!e.ctrlKey&&!e.shiftKey&&!e.metaKey)return!1;var t=d(u),o=v.inArray(n.row,t);if(-1===o&&(e.ctrlKey||e.metaKey))t.push(n.row),c.setActiveCell(n.row,n.cell);else if(-1!==o&&(e.ctrlKey||e.metaKey))t=v.grep(t,function(e,t){return e!==n.row}),c.setActiveCell(n.row,n.cell);else if(t.length&&e.shiftKey){var r=t.pop(),i=Math.min(n.row,r),l=Math.max(n.row,r);t=[];for(var s=i;s<=l;s++)s!==r&&t.push(s);t.push(r),c.setActiveCell(n.row,n.cell)}var a=p(t);return f(a),e.stopImmediatePropagation(),!0}v.extend(this,{getSelectedRows:a,setSelectedRows:function(e){f(p(e))},getSelectedRanges:function(){return u},setSelectedRanges:f,init:function(e){o=v.extend(!0,{},l,t),c=e,i.subscribe(c.onActiveCellChanged,s(h)),i.subscribe(c.onKeyDown,s(g)),i.subscribe(c.onClick,s(m))},destroy:function(){i.unsubscribeAll()},onSelectedRangesChanged:new w.Event})}}},446:function(e,t,n){function l(){var e=!1,t=!1;this.stopPropagation=function(){e=!0},this.isPropagationStopped=function(){return e},this.stopImmediatePropagation=function(){t=!0},this.isImmediatePropagationStopped=function(){return t}}function o(){this.__nonDataRow=!0}function r(){this.__group=!0,this.level=0,this.count=0,this.value=null,this.title=null,this.collapsed=!1,this.selectChecked=!1,this.totals=null,this.rows=[],this.groups=null,this.groupingKey=null}function i(){this.__groupTotals=!0,this.group=null,this.initialized=!1}function s(){var t=null;this.isActive=function(e){return e?t===e:null!==t},this.activate=function(e){if(e!==t){if(null!==t)throw new Error("SlickGrid.EditorLock.activate: an editController is still active, can't activate another editController");if(!e.commitCurrentEdit)throw new Error("SlickGrid.EditorLock.activate: editController must implement .commitCurrentEdit()");if(!e.cancelCurrentEdit)throw new Error("SlickGrid.EditorLock.activate: editController must implement .cancelCurrentEdit()");t=e}},this.deactivate=function(e){if(t!==e)throw new Error("SlickGrid.EditorLock.deactivate: specified editController is not the currently active one");t=null},this.commitCurrentEdit=function(){return!t||t.commitCurrentEdit()},this.cancelCurrentEdit=function(){return!t||t.cancelCurrentEdit()}}(r.prototype=new o).equals=function(e){return this.value===e.value&&this.count===e.count&&this.collapsed===e.collapsed&&this.title===e.title},i.prototype=new o,t.exports={Event:function(){var i=[];this.subscribe=function(e){i.push(e)},this.unsubscribe=function(e){for(var t=i.length-1;0<=t;t--)i[t]===e&&i.splice(t,1)},this.notify=function(e,t,n){var o;t=t||new l,n=n||this;for(var r=0;r<i.length&&!t.isPropagationStopped()&&!t.isImmediatePropagationStopped();r++)o=i[r].call(n,t,e);return o}},EventData:l,EventHandler:function(){var o=[];this.subscribe=function(e,t){return o.push({event:e,handler:t}),e.subscribe(t),this},this.unsubscribe=function(e,t){for(var n=o.length;n--;)if(o[n].event===e&&o[n].handler===t)return o.splice(n,1),void e.unsubscribe(t);return this},this.unsubscribeAll=function(){for(var e=o.length;e--;)o[e].event.unsubscribe(o[e].handler);return o=[],this}},Range:function(e,t,n,o){void 0===n&&void 0===o&&(n=e,o=t);this.fromRow=Math.min(e,n),this.fromCell=Math.min(t,o),this.toRow=Math.max(e,n),this.toCell=Math.max(t,o),this.isSingleRow=function(){return this.fromRow==this.toRow},this.isSingleCell=function(){return this.fromRow==this.toRow&&this.fromCell==this.toCell},this.contains=function(e,t){return e>=this.fromRow&&e<=this.toRow&&t>=this.fromCell&&t<=this.toCell},this.toString=function(){return this.isSingleCell()?"("+this.fromRow+":"+this.fromCell+")":"("+this.fromRow+":"+this.fromCell+" - "+this.toRow+":"+this.toCell+")"}},NonDataRow:o,Group:r,GroupTotals:i,EditorLock:s,GlobalEditorLock:new s,keyCode:{BACKSPACE:8,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,ESC:27,HOME:36,INSERT:45,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,RIGHT:39,TAB:9,UP:38,C:67,V:86},preClickClassName:"slick-edit-preclick"}},447:function _(require,module,exports){
/**
     * @license
     * (c) 2009-2016 Michael Leibman
     * michael{dot}leibman{at}gmail{dot}com
     * http://github.com/mleibman/slickgrid
     *
     * Distributed under MIT license.
     * All rights reserved.
     *
     * SlickGrid v2.3
     *
     * NOTES:
     *     Cell/row DOM manipulations are done directly bypassing jQuery's DOM manipulation methods.
     *     This increases the speed dramatically, but can only be done safely because there are no event handlers
     *     or data associated with any cell/row DOM nodes.  Cell editors must make sure they implement .destroy()
     *     and do proper cleanup.
     */
var $=require(448),Slick=require(446),scrollbarDimensions,maxSupportedCssHeight;function SlickGrid(container,data,columns,options){$.fn.drag||require(442),$.fn.drop||require(443);var defaults={explicitInitialization:!1,rowHeight:25,defaultColumnWidth:80,enableAddRow:!1,leaveSpaceForNewRows:!1,editable:!1,autoEdit:!0,enableCellNavigation:!0,enableColumnReorder:!0,asyncEditorLoading:!1,asyncEditorLoadDelay:100,forceFitColumns:!1,enableAsyncPostRender:!1,asyncPostRenderDelay:50,enableAsyncPostRenderCleanup:!1,asyncPostRenderCleanupDelay:40,autoHeight:!1,editorLock:Slick.GlobalEditorLock,showHeaderRow:!1,headerRowHeight:25,createFooterRow:!1,showFooterRow:!1,footerRowHeight:25,createPreHeaderPanel:!1,showPreHeaderPanel:!1,preHeaderPanelHeight:25,showTopPanel:!1,topPanelHeight:25,formatterFactory:null,editorFactory:null,cellFlashingCssClass:"flashing",selectedCellCssClass:"selected",multiSelect:!0,enableTextSelectionOnCells:!1,dataItemColumnValueExtractor:null,fullWidthRows:!1,multiColumnSort:!1,numberedMultiColumnSort:!1,tristateMultiColumnSort:!1,defaultFormatter:defaultFormatter,forceSyncScrolling:!1,addNewRowCssClass:"new-row",preserveCopiedSelectionOnPaste:!1,showCellSelection:!0},columnDefaults={name:"",resizable:!0,sortable:!1,minWidth:30,rerenderOnResize:!1,headerCssClass:null,defaultSortAsc:!0,focusable:!0,selectable:!0},th,h,ph,n,cj,page=0,offset=0,vScrollDir=1,initialized=!1,$container,uid="slickgrid_"+Math.round(1e6*Math.random()),self=this,$focusSink,$focusSink2,$headerScroller,$headers,$headerRow,$headerRowScroller,$headerRowSpacer,$footerRow,$footerRowScroller,$footerRowSpacer,$preHeaderPanel,$preHeaderPanelScroller,$preHeaderPanelSpacer,$topPanelScroller,$topPanel,$viewport,$canvas,$style,$boundAncestors,stylesheet,columnCssRulesL,columnCssRulesR,viewportH,viewportW,canvasWidth,viewportHasHScroll,viewportHasVScroll,headerColumnWidthDiff=0,headerColumnHeightDiff=0,cellWidthDiff=0,cellHeightDiff=0,jQueryNewWidthBehaviour=!1,absoluteColumnMinWidth,sortIndicatorCssClass="slick-sort-indicator",tabbingDirection=1,activePosX,activeRow,activeCell,activeCellNode=null,currentEditor=null,serializedEditorValue,editController,rowsCache={},renderedRows=0,numVisibleRows,prevScrollTop=0,scrollTop=0,lastRenderedScrollTop=0,lastRenderedScrollLeft=0,prevScrollLeft=0,scrollLeft=0,selectionModel,selectedRows=[],plugins=[],cellCssClasses={},columnsById={},sortColumns=[],columnPosLeft=[],columnPosRight=[],pagingActive=!1,pagingIsLastPage=!1,h_editorLoader=null,h_render=null,h_postrender=null,h_postrenderCleanup=null,postProcessedRows={},postProcessToRow=null,postProcessFromRow=null,postProcessedCleanupQueue=[],postProcessgroupId=0,counter_rows_rendered=0,counter_rows_removed=0,rowNodeFromLastMouseWheelEvent,zombieRowNodeFromLastMouseWheelEvent,zombieRowCacheFromLastMouseWheelEvent,zombieRowPostProcessedFromLastMouseWheelEvent,cssShow={position:"absolute",visibility:"hidden",display:"block"},$hiddenParents,oldProps=[];function init(){if(($container=container instanceof $?container:$(container)).length<1)throw new Error("SlickGrid requires a valid container, "+container+" does not exist in the DOM.");cacheCssForHiddenInit(),maxSupportedCssHeight=maxSupportedCssHeight||getMaxSupportedCssHeight(),scrollbarDimensions=scrollbarDimensions||measureScrollbar(),options=$.extend({},defaults,options),validateAndEnforceOptions(),columnDefaults.width=options.defaultColumnWidth,columnsById={};for(var e=0;e<columns.length;e++){var t=columns[e]=$.extend({},columnDefaults,columns[e]);columnsById[t.id]=e,t.minWidth&&t.width<t.minWidth&&(t.width=t.minWidth),t.maxWidth&&t.width>t.maxWidth&&(t.width=t.maxWidth)}if(options.enableColumnReorder&&!$.fn.sortable)throw new Error("SlickGrid's 'enableColumnReorder = true' option requires jquery-ui.sortable module to be loaded");editController={commitCurrentEdit:commitCurrentEdit,cancelCurrentEdit:cancelCurrentEdit},$container.empty().css("overflow","hidden").css("outline",0).addClass(uid).addClass("ui-widget"),/relative|absolute|fixed/.test($container.css("position"))||$container.css("position","relative"),$focusSink=$("<div tabIndex='0' hideFocus style='position:fixed;width:0;height:0;top:0;left:0;outline:0;'></div>").appendTo($container),options.createPreHeaderPanel&&($preHeaderPanelScroller=$("<div class='slick-preheader-panel ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($container),$preHeaderPanel=$("<div />").appendTo($preHeaderPanelScroller),$preHeaderPanelSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").css("width",getCanvasWidth()+scrollbarDimensions.width+"px").appendTo($preHeaderPanelScroller),options.showPreHeaderPanel||$preHeaderPanelScroller.hide()),$headerScroller=$("<div class='slick-header ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($container),($headers=$("<div class='slick-header-columns' style='left:-1000px' />").appendTo($headerScroller)).width(getHeadersWidth()),$headerRowScroller=$("<div class='slick-headerrow ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($container),$headerRow=$("<div class='slick-headerrow-columns' />").appendTo($headerRowScroller),$headerRowSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").css("width",getCanvasWidth()+scrollbarDimensions.width+"px").appendTo($headerRowScroller),$topPanelScroller=$("<div class='slick-top-panel-scroller ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($container),$topPanel=$("<div class='slick-top-panel' style='width:10000px' />").appendTo($topPanelScroller),options.showTopPanel||$topPanelScroller.hide(),options.showHeaderRow||$headerRowScroller.hide(),($viewport=$("<div class='slick-viewport' style='width:100%;overflow:auto;outline:0;position:relative;;'>").appendTo($container)).css("overflow-y",options.autoHeight?"hidden":"auto"),$canvas=$("<div class='grid-canvas' />").appendTo($viewport),options.createFooterRow&&($footerRowScroller=$("<div class='slick-footerrow ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($container),$footerRow=$("<div class='slick-footerrow-columns' />").appendTo($footerRowScroller),$footerRowSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").css("width",getCanvasWidth()+scrollbarDimensions.width+"px").appendTo($footerRowScroller),options.showFooterRow||$footerRowScroller.hide()),options.numberedMultiColumnSort&&(sortIndicatorCssClass="slick-sort-indicator-numbered"),$focusSink2=$focusSink.clone().appendTo($container),options.explicitInitialization||finishInitialization()}function finishInitialization(){initialized||(initialized=!0,viewportW=parseFloat($.css($container[0],"width",!0)),measureCellPaddingAndBorder(),disableSelection($headers),options.enableTextSelectionOnCells||$viewport.on("selectstart.ui",function(e){return $(e.target).is("input,textarea")}),updateColumnCaches(),createColumnHeaders(),setupColumnSort(),createCssRules(),resizeCanvas(),bindAncestorScrollEvents(),$container.on("resize.slickgrid",resizeCanvas),$viewport.on("scroll",handleScroll),$headerScroller.on("contextmenu",handleHeaderContextMenu).on("click",handleHeaderClick).on("mouseenter",".slick-header-column",handleHeaderMouseEnter).on("mouseleave",".slick-header-column",handleHeaderMouseLeave),$headerRowScroller.on("scroll",handleHeaderRowScroll),options.createFooterRow&&$footerRowScroller.on("scroll",handleFooterRowScroll),options.createPreHeaderPanel&&$preHeaderPanelScroller.on("scroll",handlePreHeaderPanelScroll),$focusSink.add($focusSink2).on("keydown",handleKeyDown),$canvas.on("keydown",handleKeyDown).on("click",handleClick).on("dblclick",handleDblClick).on("contextmenu",handleContextMenu).on("draginit",handleDragInit).on("dragstart",{distance:3},handleDragStart).on("drag",handleDrag).on("dragend",handleDragEnd).on("mouseenter",".slick-cell",handleMouseEnter).on("mouseleave",".slick-cell",handleMouseLeave),navigator.userAgent.toLowerCase().match(/webkit/)&&navigator.userAgent.toLowerCase().match(/macintosh/)&&$canvas.on("mousewheel",handleMouseWheel),restoreCssFromHiddenInit())}function cacheCssForHiddenInit(){($hiddenParents=$container.parents().addBack().not(":visible")).each(function(){var e={};for(var t in cssShow)e[t]=this.style[t],this.style[t]=cssShow[t];oldProps.push(e)})}function restoreCssFromHiddenInit(){$hiddenParents.each(function(e){var t=oldProps[e];for(var n in cssShow)this.style[n]=t[n]})}function registerPlugin(e){plugins.unshift(e),e.init(self)}function unregisterPlugin(e){for(var t=plugins.length;0<=t;t--)if(plugins[t]===e){plugins[t].destroy&&plugins[t].destroy(),plugins.splice(t,1);break}}function setSelectionModel(e){selectionModel&&(selectionModel.onSelectedRangesChanged.unsubscribe(handleSelectedRangesChanged),selectionModel.destroy&&selectionModel.destroy()),(selectionModel=e)&&(selectionModel.init(self),selectionModel.onSelectedRangesChanged.subscribe(handleSelectedRangesChanged))}function getSelectionModel(){return selectionModel}function getCanvasNode(){return $canvas[0]}function measureScrollbar(){var e=$("<div style='position:absolute; top:-10000px; left:-10000px; width:100px; height:100px; overflow:scroll;'></div>").appendTo("body"),t={width:e.width()-e[0].clientWidth,height:e.height()-e[0].clientHeight};return e.remove(),t}function getColumnTotalWidth(e){for(var t=0,n=0,o=columns.length;n<o;n++){var r=columns[n].width;t+=r}return e&&(t+=scrollbarDimensions.width),t}function getHeadersWidth(){var e=getColumnTotalWidth(!0);return Math.max(e,viewportW)+1e3}function getCanvasWidth(){for(var e=viewportHasVScroll?viewportW-scrollbarDimensions.width:viewportW,t=0,n=columns.length;n--;)t+=columns[n].width;return options.fullWidthRows?Math.max(t,e):t}function updateCanvasWidth(e){var t=canvasWidth;(canvasWidth=getCanvasWidth())!=t&&($canvas.width(canvasWidth),$headerRow.width(canvasWidth),options.createFooterRow&&$footerRow.width(canvasWidth),options.createPreHeaderPanel&&$preHeaderPanel.width(canvasWidth),$headers.width(getHeadersWidth()),viewportHasHScroll=canvasWidth>viewportW-scrollbarDimensions.width);var n=canvasWidth+(viewportHasVScroll?scrollbarDimensions.width:0);$headerRowSpacer.width(n),options.createFooterRow&&$footerRowSpacer.width(n),options.createPreHeaderPanel&&$preHeaderPanelSpacer.width(n),(canvasWidth!=t||e)&&applyColumnWidths()}function disableSelection(e){e&&e.jquery&&e.attr("unselectable","on").css("MozUserSelect","none").on("selectstart.ui",function(){return!1})}function getMaxSupportedCssHeight(){for(var e=1e6,t=navigator.userAgent.toLowerCase().match(/firefox/)?6e6:1e9,n=$("<div style='display:none' />").appendTo(document.body);;){var o=2*e;if(n.css("height",o),t<o||n.height()!==o)break;e=o}return n.remove(),e}function getUID(){return uid}function getHeaderColumnWidthDiff(){return headerColumnWidthDiff}function getScrollbarDimensions(){return scrollbarDimensions}function bindAncestorScrollEvents(){for(var e=$canvas[0];(e=e.parentNode)!=document.body&&null!=e;)if(e==$viewport[0]||e.scrollWidth!=e.clientWidth||e.scrollHeight!=e.clientHeight){var t=$(e);$boundAncestors=$boundAncestors?$boundAncestors.add(t):t,t.on("scroll."+uid,handleActiveCellPositionChange)}}function unbindAncestorScrollEvents(){$boundAncestors&&($boundAncestors.off("scroll."+uid),$boundAncestors=null)}function updateColumnHeader(e,t,n){if(initialized){var o=getColumnIndex(e);if(null!=o){var r=columns[o],i=$headers.children().eq(o);i&&(void 0!==t&&(columns[o].name=t),void 0!==n&&(columns[o].toolTip=n),trigger(self.onBeforeHeaderCellDestroy,{node:i[0],column:r,grid:self}),i.attr("title",n||"").children().eq(0).html(t),trigger(self.onHeaderCellRendered,{node:i[0],column:r,grid:self}))}}}function getHeaderRow(){return $headerRow[0]}function getFooterRow(){return $footerRow[0]}function getPreHeaderPanel(){return $preHeaderPanel[0]}function getHeaderRowColumn(e){var t=getColumnIndex(e),n=$headerRow.children().eq(t);return n&&n[0]}function getFooterRowColumn(e){var t=getColumnIndex(e),n=$footerRow.children().eq(t);return n&&n[0]}function createColumnHeaders(){function e(){$(this).addClass("ui-state-hover")}function t(){$(this).removeClass("ui-state-hover")}$headers.find(".slick-header-column").each(function(){var e=$(this).data("column");e&&trigger(self.onBeforeHeaderCellDestroy,{node:this,column:e,grid:self})}),$headers.empty(),$headers.width(getHeadersWidth()),$headerRow.find(".slick-headerrow-column").each(function(){var e=$(this).data("column");e&&trigger(self.onBeforeHeaderRowCellDestroy,{node:this,column:e,grid:self})}),$headerRow.empty(),options.createFooterRow&&($footerRow.find(".slick-footerrow-column").each(function(){var e=$(this).data("column");e&&trigger(self.onBeforeFooterRowCellDestroy,{node:this,column:e})}),$footerRow.empty());for(var n=0;n<columns.length;n++){var o=columns[n],r=$("<div class='ui-state-default slick-header-column' />").html("<span class='slick-column-name'>"+o.name+"</span>").width(o.width-headerColumnWidthDiff).attr("id",""+uid+o.id).attr("title",o.toolTip||"").data("column",o).addClass(o.headerCssClass||"").appendTo($headers);if((options.enableColumnReorder||o.sortable)&&r.on("mouseenter",e).on("mouseleave",t),o.sortable&&(r.addClass("slick-header-sortable"),r.append("<span class='"+sortIndicatorCssClass+"' />")),trigger(self.onHeaderCellRendered,{node:r[0],column:o,grid:self}),options.showHeaderRow){var i=$("<div class='ui-state-default slick-headerrow-column l"+n+" r"+n+"'></div>").data("column",o).appendTo($headerRow);trigger(self.onHeaderRowCellRendered,{node:i[0],column:o,grid:self})}if(options.createFooterRow&&options.showFooterRow){var l=$("<div class='ui-state-default slick-footerrow-column l"+n+" r"+n+"'></div>").data("column",o).appendTo($footerRow);trigger(self.onFooterRowCellRendered,{node:l[0],column:o})}}setSortColumns(sortColumns),setupColumnResize(),options.enableColumnReorder&&("function"==typeof options.enableColumnReorder?options.enableColumnReorder(self,$headers,headerColumnWidthDiff,setColumns,setupColumnResize,columns,getColumnIndex,uid,trigger):setupColumnReorder())}function setupColumnSort(){$headers.click(function(e){if(e.metaKey=e.metaKey||e.ctrlKey,!$(e.target).hasClass("slick-resizable-handle")){var t=$(e.target).closest(".slick-header-column");if(t.length){var n=t.data("column");if(n.sortable){if(!getEditorLock().commitCurrentEdit())return;for(var o=null,r=0;r<sortColumns.length;r++)if(sortColumns[r].columnId==n.id){(o=sortColumns[r]).sortAsc=!o.sortAsc;break}var i=!!o;options.tristateMultiColumnSort?(o||(o={columnId:n.id,sortAsc:n.defaultSortAsc}),i&&o.sortAsc&&(sortColumns.splice(r,1),o=null),options.multiColumnSort||(sortColumns=[]),!o||i&&options.multiColumnSort||sortColumns.push(o)):e.metaKey&&options.multiColumnSort?o&&sortColumns.splice(r,1):((e.shiftKey||e.metaKey)&&options.multiColumnSort||(sortColumns=[]),o?0==sortColumns.length&&sortColumns.push(o):(o={columnId:n.id,sortAsc:n.defaultSortAsc},sortColumns.push(o))),setSortColumns(sortColumns),0<sortColumns.length&&(options.multiColumnSort?trigger(self.onSort,{multiColumnSort:!0,sortCols:$.map(sortColumns,function(e){return{sortCol:columns[getColumnIndex(e.columnId)],sortAsc:e.sortAsc}}),grid:self},e):trigger(self.onSort,{multiColumnSort:!1,sortCol:n,sortAsc:sortColumns[0].sortAsc,grid:self},e))}}}})}function setupColumnReorder(){$headers.filter(":ui-sortable").sortable("destroy"),$headers.sortable({containment:"parent",distance:3,axis:"x",cursor:"default",tolerance:"intersection",helper:"clone",placeholder:"slick-sortable-placeholder ui-state-default slick-header-column",start:function(e,t){t.placeholder.width(t.helper.outerWidth()-headerColumnWidthDiff),$(t.helper).addClass("slick-header-column-active")},beforeStop:function(e,t){$(t.helper).removeClass("slick-header-column-active")},stop:function(e){if(getEditorLock().commitCurrentEdit()){for(var t=$headers.sortable("toArray"),n=[],o=0;o<t.length;o++)n.push(columns[getColumnIndex(t[o].replace(uid,""))]);setColumns(n),trigger(self.onColumnsReordered,{grid:self}),e.stopPropagation(),setupColumnResize()}else $(this).sortable("cancel")}})}function setupColumnResize(){var s,a,c,u,d,p,n,o;(u=$headers.children()).find(".slick-resizable-handle").remove(),u.each(function(e,t){e>=columns.length||columns[e].resizable&&(void 0===n&&(n=e),o=e)}),void 0!==n&&u.each(function(l,e){l>=columns.length||l<n||options.forceFitColumns&&o<=l||($(e),$("<div class='slick-resizable-handle' />").appendTo(e).on("dragstart",function(e,t){if(!getEditorLock().commitCurrentEdit())return!1;c=e.pageX,$(this).parent().addClass("slick-header-column-active");var n=null,o=null;if(u.each(function(e,t){e>=columns.length||(columns[e].previousWidth=$(t).outerWidth())}),options.forceFitColumns)for(o=n=0,s=l+1;s<columns.length;s++)(a=columns[s]).resizable&&(null!==o&&(a.maxWidth?o+=a.maxWidth-a.previousWidth:o=null),n+=a.previousWidth-Math.max(a.minWidth||0,absoluteColumnMinWidth));var r=0,i=0;for(s=0;s<=l;s++)(a=columns[s]).resizable&&(null!==i&&(a.maxWidth?i+=a.maxWidth-a.previousWidth:i=null),r+=a.previousWidth-Math.max(a.minWidth||0,absoluteColumnMinWidth));null===n&&(n=1e5),null===r&&(r=1e5),null===o&&(o=1e5),null===i&&(i=1e5),p=c+Math.min(n,i),d=c-Math.min(r,o)}).on("drag",function(e,t){var n,o,r=Math.min(p,Math.max(d,e.pageX))-c;if(r<0){for(o=r,s=l;0<=s;s--)(a=columns[s]).resizable&&(n=Math.max(a.minWidth||0,absoluteColumnMinWidth),o&&a.previousWidth+o<n?(o+=a.previousWidth-n,a.width=n):(a.width=a.previousWidth+o,o=0));if(options.forceFitColumns)for(o=-r,s=l+1;s<columns.length;s++)(a=columns[s]).resizable&&(o&&a.maxWidth&&a.maxWidth-a.previousWidth<o?(o-=a.maxWidth-a.previousWidth,a.width=a.maxWidth):(a.width=a.previousWidth+o,o=0))}else{for(o=r,s=l;0<=s;s--)(a=columns[s]).resizable&&(o&&a.maxWidth&&a.maxWidth-a.previousWidth<o?(o-=a.maxWidth-a.previousWidth,a.width=a.maxWidth):(a.width=a.previousWidth+o,o=0));if(options.forceFitColumns)for(o=-r,s=l+1;s<columns.length;s++)(a=columns[s]).resizable&&(n=Math.max(a.minWidth||0,absoluteColumnMinWidth),o&&a.previousWidth+o<n?(o+=a.previousWidth-n,a.width=n):(a.width=a.previousWidth+o,o=0))}applyColumnHeaderWidths(),options.syncColumnCellResize&&applyColumnWidths()}).on("dragend",function(e,t){var n;for($(this).parent().removeClass("slick-header-column-active"),s=0;s<columns.length;s++)a=columns[s],n=$(u[s]).outerWidth(),a.previousWidth!==n&&a.rerenderOnResize&&invalidateAllRows();updateCanvasWidth(!0),render(),trigger(self.onColumnsResized,{grid:self})}))})}function getVBoxDelta(n){var o=0;return $.each(["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],function(e,t){o+=parseFloat(n.css(t))||0}),o}function measureCellPaddingAndBorder(){var n,e=["borderLeftWidth","borderRightWidth","paddingLeft","paddingRight"],t=["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],o=$.fn.jquery.split(".");jQueryNewWidthBehaviour=1==o[0]&&8<=o[1]||2<=o[0],n=$("<div class='ui-state-default slick-header-column' style='visibility:hidden'>-</div>").appendTo($headers),headerColumnWidthDiff=headerColumnHeightDiff=0,"border-box"!=n.css("box-sizing")&&"border-box"!=n.css("-moz-box-sizing")&&"border-box"!=n.css("-webkit-box-sizing")&&($.each(e,function(e,t){headerColumnWidthDiff+=parseFloat(n.css(t))||0}),$.each(t,function(e,t){headerColumnHeightDiff+=parseFloat(n.css(t))||0})),n.remove();var r=$("<div class='slick-row' />").appendTo($canvas);n=$("<div class='slick-cell' id='' style='visibility:hidden'>-</div>").appendTo(r),cellWidthDiff=cellHeightDiff=0,"border-box"!=n.css("box-sizing")&&"border-box"!=n.css("-moz-box-sizing")&&"border-box"!=n.css("-webkit-box-sizing")&&($.each(e,function(e,t){cellWidthDiff+=parseFloat(n.css(t))||0}),$.each(t,function(e,t){cellHeightDiff+=parseFloat(n.css(t))||0})),r.remove(),absoluteColumnMinWidth=Math.max(headerColumnWidthDiff,cellWidthDiff)}function createCssRules(){$style=$("<style type='text/css' rel='stylesheet' />").appendTo($("head"));for(var e=options.rowHeight-cellHeightDiff,t=["."+uid+" .slick-header-column { left: 1000px; }","."+uid+" .slick-top-panel { height:"+options.topPanelHeight+"px; }","."+uid+" .slick-preheader-panel { height:"+options.preHeaderPanelHeight+"px; }","."+uid+" .slick-headerrow-columns { height:"+options.headerRowHeight+"px; }","."+uid+" .slick-footerrow-columns { height:"+options.footerRowHeight+"px; }","."+uid+" .slick-cell { height:"+e+"px; }","."+uid+" .slick-row { height:"+options.rowHeight+"px; }"],n=0;n<columns.length;n++)t.push("."+uid+" .l"+n+" { }"),t.push("."+uid+" .r"+n+" { }");$style[0].styleSheet?$style[0].styleSheet.cssText=t.join(" "):$style[0].appendChild(document.createTextNode(t.join(" ")))}function getColumnCssRules(e){var t;if(!stylesheet){var n=document.styleSheets;for(t=0;t<n.length;t++)if((n[t].ownerNode||n[t].owningElement)==$style[0]){stylesheet=n[t];break}if(!stylesheet)throw new Error("Cannot find stylesheet.");columnCssRulesL=[],columnCssRulesR=[];var o,r,i=stylesheet.cssRules||stylesheet.rules;for(t=0;t<i.length;t++){var l=i[t].selectorText;(o=/\.l\d+/.exec(l))?(r=parseInt(o[0].substr(2,o[0].length-2),10),columnCssRulesL[r]=i[t]):(o=/\.r\d+/.exec(l))&&(r=parseInt(o[0].substr(2,o[0].length-2),10),columnCssRulesR[r]=i[t])}}return{left:columnCssRulesL[e],right:columnCssRulesR[e]}}function removeCssRules(){$style.remove(),stylesheet=null}function destroy(){getEditorLock().cancelCurrentEdit(),trigger(self.onBeforeDestroy,{grid:self});for(var e=plugins.length;e--;)unregisterPlugin(plugins[e]);options.enableColumnReorder&&$headers.filter(":ui-sortable").sortable("destroy"),unbindAncestorScrollEvents(),$container.off(".slickgrid"),removeCssRules(),$canvas.off("draginit dragstart dragend drag"),$container.empty().removeClass(uid)}function trigger(e,t,n){return n=n||new Slick.EventData,(t=t||{}).grid=self,e.notify(t,n,self)}function getEditorLock(){return options.editorLock}function getEditController(){return editController}function getColumnIndex(e){return columnsById[e]}function autosizeColumns(){var e,t,n,o=[],r=0,i=0,l=viewportHasVScroll?viewportW-scrollbarDimensions.width:viewportW;for(e=0;e<columns.length;e++)t=columns[e],o.push(t.width),i+=t.width,t.resizable&&(r+=t.width-Math.max(t.minWidth,absoluteColumnMinWidth));for(n=i;l<i&&r;){var s=(i-l)/r;for(e=0;e<columns.length&&l<i;e++){t=columns[e];var a=o[e];if(!(!t.resizable||a<=t.minWidth||a<=absoluteColumnMinWidth)){var c=Math.max(t.minWidth,absoluteColumnMinWidth),u=Math.floor(s*(a-c))||1;u=Math.min(u,a-c),i-=u,r-=u,o[e]-=u}}if(n<=i)break;n=i}for(n=i;i<l;){var d=l/i;for(e=0;e<columns.length&&i<l;e++){t=columns[e];var p,f=o[e];p=!t.resizable||t.maxWidth<=f?0:Math.min(Math.floor(d*f)-f,t.maxWidth-f||1e6)||1,i+=p,o[e]+=i<=l?p:0}if(i<=n)break;n=i}var h=!1;for(e=0;e<columns.length;e++)columns[e].rerenderOnResize&&columns[e].width!=o[e]&&(h=!0),columns[e].width=o[e];applyColumnHeaderWidths(),updateCanvasWidth(!0),h&&(invalidateAllRows(),render())}function applyColumnHeaderWidths(){if(initialized){for(var e,t=0,n=$headers.children(),o=columns.length;t<o;t++)e=$(n[t]),jQueryNewWidthBehaviour?e.outerWidth()!==columns[t].width&&e.outerWidth(columns[t].width):e.width()!==columns[t].width-headerColumnWidthDiff&&e.width(columns[t].width-headerColumnWidthDiff);updateColumnCaches()}}function applyColumnWidths(){for(var e,t,n=0,o=0;o<columns.length;o++)e=columns[o].width,(t=getColumnCssRules(o)).left.style.left=n+"px",t.right.style.right=canvasWidth-n-e+"px",n+=columns[o].width}function setSortColumn(e,t){setSortColumns([{columnId:e,sortAsc:t}])}function setSortColumns(e){sortColumns=e;var o=options.numberedMultiColumnSort&&1<sortColumns.length,r=$headers.children(),i=r.removeClass("slick-header-column-sorted").find("."+sortIndicatorCssClass).removeClass("slick-sort-indicator-asc slick-sort-indicator-desc");o&&i.text(""),$.each(sortColumns,function(e,t){null==t.sortAsc&&(t.sortAsc=!0);var n=getColumnIndex(t.columnId);null!=n&&(i=r.eq(n).addClass("slick-header-column-sorted").find("."+sortIndicatorCssClass).addClass(t.sortAsc?"slick-sort-indicator-asc":"slick-sort-indicator-desc"),o&&i.text(e+1))})}function getSortColumns(){return sortColumns}function handleSelectedRangesChanged(e,t){selectedRows=[];for(var n={},o=0;o<t.length;o++)for(var r=t[o].fromRow;r<=t[o].toRow;r++){n[r]||(selectedRows.push(r),n[r]={});for(var i=t[o].fromCell;i<=t[o].toCell;i++)canCellBeSelected(r,i)&&(n[r][columns[i].id]=options.selectedCellCssClass)}setCellCssStyles(options.selectedCellCssClass,n),trigger(self.onSelectedRowsChanged,{rows:getSelectedRows(),grid:self},e)}function getColumns(){return columns}function updateColumnCaches(){columnPosLeft=[],columnPosRight=[];for(var e=0,t=0,n=columns.length;t<n;t++)columnPosLeft[t]=e,columnPosRight[t]=e+columns[t].width,e+=columns[t].width}function setColumns(e){columns=e,columnsById={};for(var t=0;t<columns.length;t++){var n=columns[t]=$.extend({},columnDefaults,columns[t]);columnsById[n.id]=t,n.minWidth&&n.width<n.minWidth&&(n.width=n.minWidth),n.maxWidth&&n.width>n.maxWidth&&(n.width=n.maxWidth)}updateColumnCaches(),initialized&&(invalidateAllRows(),createColumnHeaders(),removeCssRules(),createCssRules(),resizeCanvas(),applyColumnWidths(),handleScroll())}function getOptions(){return options}function setOptions(e,t){getEditorLock().commitCurrentEdit()&&(makeActiveCellNormal(),options.enableAddRow!==e.enableAddRow&&invalidateRow(getDataLength()),options=$.extend(options,e),validateAndEnforceOptions(),$viewport.css("overflow-y",options.autoHeight?"hidden":"auto"),t||render())}function validateAndEnforceOptions(){options.autoHeight&&(options.leaveSpaceForNewRows=!1)}function setData(e,t){data=e,invalidateAllRows(),updateRowCount(),t&&scrollTo(0)}function getData(){return data}function getDataLength(){return data.getLength?data.getLength():data.length}function getDataLengthIncludingAddNew(){return getDataLength()+(options.enableAddRow&&(!pagingActive||pagingIsLastPage)?1:0)}function getDataItem(e){return data.getItem?data.getItem(e):data[e]}function getTopPanel(){return $topPanel[0]}function setTopPanelVisibility(e){options.showTopPanel!=e&&((options.showTopPanel=e)?$topPanelScroller.slideDown("fast",resizeCanvas):$topPanelScroller.slideUp("fast",resizeCanvas))}function setHeaderRowVisibility(e){options.showHeaderRow!=e&&((options.showHeaderRow=e)?$headerRowScroller.slideDown("fast",resizeCanvas):$headerRowScroller.slideUp("fast",resizeCanvas))}function setFooterRowVisibility(e){options.showFooterRow!=e&&((options.showFooterRow=e)?$footerRowScroller.slideDown("fast",resizeCanvas):$footerRowScroller.slideUp("fast",resizeCanvas))}function setPreHeaderPanelVisibility(e){options.showPreHeaderPanel!=e&&((options.showPreHeaderPanel=e)?$preHeaderPanelScroller.slideDown("fast",resizeCanvas):$preHeaderPanelScroller.slideUp("fast",resizeCanvas))}function getContainerNode(){return $container.get(0)}function getRowTop(e){return options.rowHeight*e-offset}function getRowFromPosition(e){return Math.floor((e+offset)/options.rowHeight)}function scrollTo(e){e=Math.max(e,0),e=Math.min(e,th-viewportH+(viewportHasHScroll?scrollbarDimensions.height:0));var t=offset;page=Math.min(n-1,Math.floor(e/ph)),offset=Math.round(page*cj);var o=e-offset;if(offset!=t){var r=getVisibleRange(o);cleanupRows(r),updateRowPositions()}prevScrollTop!=o&&(vScrollDir=prevScrollTop+t<o+offset?1:-1,$viewport[0].scrollTop=lastRenderedScrollTop=scrollTop=prevScrollTop=o,trigger(self.onViewportChanged,{grid:self}))}function defaultFormatter(e,t,n,o,r){return null==n?"":(n+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}function getFormatter(e,t){var n=data.getItemMetadata&&data.getItemMetadata(e),o=n&&n.columns&&(n.columns[t.id]||n.columns[getColumnIndex(t.id)]);return o&&o.formatter||n&&n.formatter||t.formatter||options.formatterFactory&&options.formatterFactory.getFormatter(t)||options.defaultFormatter}function getEditor(e,t){var n=columns[t],o=data.getItemMetadata&&data.getItemMetadata(e),r=o&&o.columns;return r&&r[n.id]&&void 0!==r[n.id].editor?r[n.id].editor:r&&r[t]&&void 0!==r[t].editor?r[t].editor:n.editor||options.editorFactory&&options.editorFactory.getEditor(n)}function getDataItemValueForColumn(e,t){return options.dataItemColumnValueExtractor?options.dataItemColumnValueExtractor(e,t):e[t.field]}function appendRowHtml(e,t,n,o){var r=getDataItem(t),i=t<o&&!r,l="slick-row"+(i?" loading":"")+(t===activeRow?" active":"")+(t%2==1?" odd":" even");r||(l+=" "+options.addNewRowCssClass);var s,a,c=data.getItemMetadata&&data.getItemMetadata(t);c&&c.cssClasses&&(l+=" "+c.cssClasses),e.push("<div class='ui-widget-content "+l+"' style='top:"+getRowTop(t)+"px'>");for(var u=0,d=columns.length;u<d;u++){if(a=columns[u],s=1,c&&c.columns){var p=c.columns[a.id]||c.columns[u];"*"===(s=p&&p.colspan||1)&&(s=d-u)}if(columnPosRight[Math.min(d-1,u+s-1)]>n.leftPx){if(columnPosLeft[u]>n.rightPx)break;appendCellHtml(e,t,u,s,r)}1<s&&(u+=s-1)}e.push("</div>")}function appendCellHtml(e,t,n,o,r){var i=columns[n],l="slick-cell l"+n+" r"+Math.min(columns.length-1,n+o-1)+(i.cssClass?" "+i.cssClass:"");for(var s in t===activeRow&&n===activeCell&&(l+=" active"),cellCssClasses)cellCssClasses[s][t]&&cellCssClasses[s][t][i.id]&&(l+=" "+cellCssClasses[s][t][i.id]);var a=null;r&&(a=getDataItemValueForColumn(r,i));var c=getFormatter(t,i)(t,n,a,i,r),u=trigger(self.onBeforeAppendCell,{row:t,cell:n,grid:self,value:a,dataContext:r})||"";u+=c.addClasses?(u?" ":"")+c.addClasses:"",e.push("<div class='"+l+(u?" "+u:"")+"'>"),r&&e.push("object"!=typeof c?c:c.text),e.push("</div>"),rowsCache[t].cellRenderQueue.push(n),rowsCache[t].cellColSpans[n]=o}function cleanupRows(e){for(var t in rowsCache)(t=parseInt(t,10))!==activeRow&&(t<e.top||t>e.bottom)&&removeRowFromCache(t);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}function invalidate(){updateRowCount(),invalidateAllRows(),render()}function invalidateAllRows(){for(var e in currentEditor&&makeActiveCellNormal(),rowsCache)removeRowFromCache(e);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}function queuePostProcessedRowForCleanup(e,t,n){for(var o in postProcessgroupId++,t)t.hasOwnProperty(o)&&postProcessedCleanupQueue.push({actionType:"C",groupId:postProcessgroupId,node:e.cellNodesByColumnIdx[0|o],columnIdx:0|o,rowIdx:n});postProcessedCleanupQueue.push({actionType:"R",groupId:postProcessgroupId,node:e.rowNode}),$(e.rowNode).detach()}function queuePostProcessedCellForCleanup(e,t,n){postProcessedCleanupQueue.push({actionType:"C",groupId:postProcessgroupId,node:e,columnIdx:t,rowIdx:n}),$(e).detach()}function removeRowFromCache(e){var t=rowsCache[e];t&&(rowNodeFromLastMouseWheelEvent===t.rowNode?(t.rowNode.style.display="none",zombieRowNodeFromLastMouseWheelEvent=rowNodeFromLastMouseWheelEvent,zombieRowCacheFromLastMouseWheelEvent=t,zombieRowPostProcessedFromLastMouseWheelEvent=postProcessedRows[e]):options.enableAsyncPostRenderCleanup&&postProcessedRows[e]?queuePostProcessedRowForCleanup(t,postProcessedRows[e],e):$canvas[0].removeChild(t.rowNode),delete rowsCache[e],delete postProcessedRows[e],renderedRows--,counter_rows_removed++)}function invalidateRows(e){var t,n;if(e&&e.length){for(vScrollDir=0,n=e.length,t=0;t<n;t++)currentEditor&&activeRow===e[t]&&makeActiveCellNormal(),rowsCache[e[t]]&&removeRowFromCache(e[t]);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}}function invalidateRow(e){invalidateRows([e])}function applyFormatResultToCellNode(e,t,n){"object"==typeof e?(t.innerHTML=e.text,e.removeClasses&&!n&&t.removeClass(e.removeClasses),e.addClasses&&t.addClass(e.addClasses)):t.innerHTML=e}function updateCell(e,t){var n=getCellNode(e,t);if(n){var o=columns[t],r=getDataItem(e);if(currentEditor&&activeRow===e&&activeCell===t)currentEditor.loadValue(r);else{var i=r?getFormatter(e,o)(e,t,getDataItemValueForColumn(r,o),o,r):"";applyFormatResultToCellNode(i,n),invalidatePostProcessingResults(e)}}}function updateRow(e){var t=rowsCache[e];if(t){ensureCellNodesInRowsCache(e);var n=getDataItem(e);for(var o in t.cellNodesByColumnIdx)if(t.cellNodesByColumnIdx.hasOwnProperty(o)){var r=columns[o|=0],i=t.cellNodesByColumnIdx[o];e===activeRow&&o===activeCell&&currentEditor?currentEditor.loadValue(n):n?applyFormatResultToCellNode(getFormatter(e,r)(e,o,getDataItemValueForColumn(n,r),r,n),i):i.innerHTML=""}invalidatePostProcessingResults(e)}}function getViewportHeight(){return parseFloat($.css($container[0],"height",!0))-parseFloat($.css($container[0],"paddingTop",!0))-parseFloat($.css($container[0],"paddingBottom",!0))-parseFloat($.css($headerScroller[0],"height"))-getVBoxDelta($headerScroller)-(options.showTopPanel?options.topPanelHeight+getVBoxDelta($topPanelScroller):0)-(options.showHeaderRow?options.headerRowHeight+getVBoxDelta($headerRowScroller):0)-(options.createFooterRow&&options.showFooterRow?options.footerRowHeight+getVBoxDelta($footerRowScroller):0)-(options.createPreHeaderPanel&&options.showPreHeaderPanel?options.preHeaderPanelHeight+getVBoxDelta($preHeaderPanelScroller):0)}function resizeCanvas(){initialized&&(viewportH=options.autoHeight?options.rowHeight*getDataLengthIncludingAddNew():getViewportHeight(),numVisibleRows=Math.ceil(viewportH/options.rowHeight),viewportW=parseFloat($.css($container[0],"width",!0)),options.autoHeight||$viewport.height(viewportH),options.forceFitColumns&&autosizeColumns(),updateRowCount(),handleScroll(),lastRenderedScrollLeft=-1,render())}function updatePagingStatusFromView(e){pagingActive=0!==e.pageSize,pagingIsLastPage=e.pageNum==e.totalPages-1}function updateRowCount(){if(initialized){var e=getDataLength(),t=getDataLengthIncludingAddNew(),o=t+(options.leaveSpaceForNewRows?numVisibleRows-1:0),r=viewportHasVScroll;viewportHasVScroll=!options.autoHeight&&o*options.rowHeight>viewportH,viewportHasHScroll=canvasWidth>viewportW-scrollbarDimensions.width,makeActiveCellNormal();var i=e-1;for(var l in rowsCache)i<l&&removeRowFromCache(l);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup(),activeCellNode&&i<activeRow&&resetActiveCell();var s=h;(th=Math.max(options.rowHeight*o,viewportH-scrollbarDimensions.height))<maxSupportedCssHeight?(h=ph=th,n=1,cj=0):(ph=(h=maxSupportedCssHeight)/100,n=Math.floor(th/ph),cj=(th-h)/(n-1)),h!==s&&($canvas.css("height",h),scrollTop=$viewport[0].scrollTop);var a=scrollTop+offset<=th-viewportH;0==th||0==scrollTop?page=offset=0:scrollTo(a?scrollTop+offset:th-viewportH),h!=s&&options.autoHeight&&resizeCanvas(),options.forceFitColumns&&r!=viewportHasVScroll&&autosizeColumns(),updateCanvasWidth(!1)}}function getVisibleRange(e,t){return null==e&&(e=scrollTop),null==t&&(t=scrollLeft),{top:getRowFromPosition(e),bottom:getRowFromPosition(e+viewportH)+1,leftPx:t,rightPx:t+viewportW}}function getRenderedRange(e,t){var n=getVisibleRange(e,t),o=Math.round(viewportH/options.rowHeight);return-1==vScrollDir?(n.top-=o,n.bottom+=3):1==vScrollDir?(n.top-=3,n.bottom+=o):(n.top-=3,n.bottom+=3),n.top=Math.max(0,n.top),n.bottom=Math.min(getDataLengthIncludingAddNew()-1,n.bottom),n.leftPx-=viewportW,n.rightPx+=viewportW,n.leftPx=Math.max(0,n.leftPx),n.rightPx=Math.min(canvasWidth,n.rightPx),n}function ensureCellNodesInRowsCache(e){var t=rowsCache[e];if(t&&t.cellRenderQueue.length)for(var n=t.rowNode.lastChild;t.cellRenderQueue.length;){var o=t.cellRenderQueue.pop();n=(t.cellNodesByColumnIdx[o]=n).previousSibling}}function cleanUpCells(e,t){var n,o,r=rowsCache[t],i=[];for(var l in r.cellNodesByColumnIdx)if(r.cellNodesByColumnIdx.hasOwnProperty(l)){l|=0;var s=r.cellColSpans[l];(columnPosLeft[l]>e.rightPx||columnPosRight[Math.min(columns.length-1,l+s-1)]<e.leftPx)&&(t==activeRow&&l==activeCell||i.push(l))}for(postProcessgroupId++;null!=(n=i.pop());)o=r.cellNodesByColumnIdx[n],options.enableAsyncPostRenderCleanup&&postProcessedRows[t]&&postProcessedRows[t][n]?queuePostProcessedCellForCleanup(o,n,t):r.rowNode.removeChild(o),delete r.cellColSpans[n],delete r.cellNodesByColumnIdx[n],postProcessedRows[t]&&delete postProcessedRows[t][n],0}function cleanUpAndRenderCells(e){for(var t,n,o,r=[],i=[],l=e.top,s=e.bottom;l<=s;l++)if(t=rowsCache[l]){ensureCellNodesInRowsCache(l),cleanUpCells(e,l),n=0;var a=data.getItemMetadata&&data.getItemMetadata(l);a=a&&a.columns;for(var c=getDataItem(l),u=0,d=columns.length;u<d&&!(columnPosLeft[u]>e.rightPx);u++)if(null==(o=t.cellColSpans[u])){if(o=1,a){var p=a[columns[u].id]||a[u];"*"===(o=p&&p.colspan||1)&&(o=d-u)}columnPosRight[Math.min(d-1,u+o-1)]>e.leftPx&&(appendCellHtml(r,l,u,o,c),n++),u+=1<o?o-1:0}else u+=1<o?o-1:0;n&&(n,i.push(l))}if(r.length){var f,h,g=document.createElement("div");for(g.innerHTML=r.join("");null!=(f=i.pop());){var m;for(t=rowsCache[f];null!=(m=t.cellRenderQueue.pop());)h=g.lastChild,t.rowNode.appendChild(h),t.cellNodesByColumnIdx[m]=h}}}function renderRows(e){for(var t=$canvas[0],n=[],o=[],r=!1,i=getDataLength(),l=e.top,s=e.bottom;l<=s;l++)rowsCache[l]||(renderedRows++,o.push(l),rowsCache[l]={rowNode:null,cellColSpans:[],cellNodesByColumnIdx:[],cellRenderQueue:[]},appendRowHtml(n,l,e,i),activeCellNode&&activeRow===l&&(r=!0),counter_rows_rendered++);if(o.length){var a=document.createElement("div");a.innerHTML=n.join("");for(var l=0,s=o.length;l<s;l++)rowsCache[o[l]].rowNode=t.appendChild(a.firstChild);r&&(activeCellNode=getCellNode(activeRow,activeCell))}}function startPostProcessing(){options.enableAsyncPostRender&&(clearTimeout(h_postrender),h_postrender=setTimeout(asyncPostProcessRows,options.asyncPostRenderDelay))}function startPostProcessingCleanup(){options.enableAsyncPostRenderCleanup&&(clearTimeout(h_postrenderCleanup),h_postrenderCleanup=setTimeout(asyncPostProcessCleanupRows,options.asyncPostRenderCleanupDelay))}function invalidatePostProcessingResults(e){for(var t in postProcessedRows[e])postProcessedRows[e].hasOwnProperty(t)&&(postProcessedRows[e][t]="C");postProcessFromRow=Math.min(postProcessFromRow,e),postProcessToRow=Math.max(postProcessToRow,e),startPostProcessing()}function updateRowPositions(){for(var e in rowsCache)rowsCache[e].rowNode.style.top=getRowTop(e)+"px"}function render(){if(initialized){var e=getVisibleRange(),t=getRenderedRange();cleanupRows(t),lastRenderedScrollLeft!=scrollLeft&&cleanUpAndRenderCells(t),renderRows(t),postProcessFromRow=e.top,postProcessToRow=Math.min(getDataLengthIncludingAddNew()-1,e.bottom),startPostProcessing(),lastRenderedScrollTop=scrollTop,lastRenderedScrollLeft=scrollLeft,h_render=null}}function handleHeaderRowScroll(){var e=$headerRowScroller[0].scrollLeft;e!=$viewport[0].scrollLeft&&($viewport[0].scrollLeft=e)}function handleFooterRowScroll(){var e=$footerRowScroller[0].scrollLeft;e!=$viewport[0].scrollLeft&&($viewport[0].scrollLeft=e)}function handlePreHeaderPanelScroll(){var e=$preHeaderPanelScroller[0].scrollLeft;e!=$viewport[0].scrollLeft&&($viewport[0].scrollLeft=e)}function handleScroll(){scrollTop=$viewport[0].scrollTop,scrollLeft=$viewport[0].scrollLeft;var e=Math.abs(scrollTop-prevScrollTop),t=Math.abs(scrollLeft-prevScrollLeft);if(t&&(prevScrollLeft=scrollLeft,$headerScroller[0].scrollLeft=scrollLeft,$topPanelScroller[0].scrollLeft=scrollLeft,$headerRowScroller[0].scrollLeft=scrollLeft,options.createFooterRow&&($footerRowScroller[0].scrollLeft=scrollLeft),options.createPreHeaderPanel&&($preHeaderPanelScroller[0].scrollLeft=scrollLeft)),e)if(vScrollDir=prevScrollTop<scrollTop?1:-1,prevScrollTop=scrollTop,e<viewportH)scrollTo(scrollTop+offset);else{var o=offset;page=h==viewportH?0:Math.min(n-1,Math.floor(scrollTop*((th-viewportH)/(h-viewportH))*(1/ph))),offset=Math.round(page*cj),o!=offset&&invalidateAllRows()}(t||e)&&(h_render&&clearTimeout(h_render),(20<Math.abs(lastRenderedScrollTop-scrollTop)||20<Math.abs(lastRenderedScrollLeft-scrollLeft))&&(options.forceSyncScrolling||Math.abs(lastRenderedScrollTop-scrollTop)<viewportH&&Math.abs(lastRenderedScrollLeft-scrollLeft)<viewportW?render():h_render=setTimeout(render,50),trigger(self.onViewportChanged,{grid:self}))),trigger(self.onScroll,{scrollLeft:scrollLeft,scrollTop:scrollTop,grid:self})}function asyncPostProcessRows(){for(var e=getDataLength();postProcessFromRow<=postProcessToRow;){var t=0<=vScrollDir?postProcessFromRow++:postProcessToRow--,n=rowsCache[t];if(n&&!(e<=t)){for(var o in postProcessedRows[t]||(postProcessedRows[t]={}),ensureCellNodesInRowsCache(t),n.cellNodesByColumnIdx)if(n.cellNodesByColumnIdx.hasOwnProperty(o)){var r=columns[o|=0],i=postProcessedRows[t][o];if(r.asyncPostRender&&"R"!==i){var l=n.cellNodesByColumnIdx[o];l&&r.asyncPostRender(l,t,getDataItem(t),r,"C"===i),postProcessedRows[t][o]="R"}}return void(h_postrender=setTimeout(asyncPostProcessRows,options.asyncPostRenderDelay))}}}function asyncPostProcessCleanupRows(){if(0<postProcessedCleanupQueue.length){for(var e=postProcessedCleanupQueue[0].groupId;0<postProcessedCleanupQueue.length&&postProcessedCleanupQueue[0].groupId==e;){var t=postProcessedCleanupQueue.shift();if("R"==t.actionType&&$(t.node).remove(),"C"==t.actionType){var n=columns[t.columnIdx];n.asyncPostRenderCleanup&&t.node&&n.asyncPostRenderCleanup(t.node,t.rowIdx,n)}}h_postrenderCleanup=setTimeout(asyncPostProcessCleanupRows,options.asyncPostRenderCleanupDelay)}}function updateCellCssStylesOnRenderedRows(e,t){var n,o,r,i;for(var l in rowsCache){if(i=t&&t[l],r=e&&e[l],i)for(o in i)r&&i[o]==r[o]||(n=getCellNode(l,getColumnIndex(o)))&&$(n).removeClass(i[o]);if(r)for(o in r)i&&i[o]==r[o]||(n=getCellNode(l,getColumnIndex(o)))&&$(n).addClass(r[o])}}function addCellCssStyles(e,t){if(cellCssClasses[e])throw new Error("addCellCssStyles: cell CSS hash with key '"+e+"' already exists.");updateCellCssStylesOnRenderedRows(cellCssClasses[e]=t,null),trigger(self.onCellCssStylesChanged,{key:e,hash:t,grid:self})}function removeCellCssStyles(e){cellCssClasses[e]&&(updateCellCssStylesOnRenderedRows(null,cellCssClasses[e]),delete cellCssClasses[e],trigger(self.onCellCssStylesChanged,{key:e,hash:null,grid:self}))}function setCellCssStyles(e,t){var n=cellCssClasses[e];updateCellCssStylesOnRenderedRows(cellCssClasses[e]=t,n),trigger(self.onCellCssStylesChanged,{key:e,hash:t,grid:self})}function getCellCssStyles(e){return cellCssClasses[e]}function flashCell(e,t,n){if(n=n||100,rowsCache[e]){var o=$(getCellNode(e,t)),r=function(e){e&&setTimeout(function(){o.queue(function(){o.toggleClass(options.cellFlashingCssClass).dequeue(),r(e-1)})},n)};r(4)}}function handleMouseWheel(e){var t=$(e.target).closest(".slick-row")[0];t!=rowNodeFromLastMouseWheelEvent&&(zombieRowNodeFromLastMouseWheelEvent&&zombieRowNodeFromLastMouseWheelEvent!=t&&(options.enableAsyncPostRenderCleanup&&zombieRowPostProcessedFromLastMouseWheelEvent?queuePostProcessedRowForCleanup(zombieRowCacheFromLastMouseWheelEvent,zombieRowPostProcessedFromLastMouseWheelEvent):$canvas[0].removeChild(zombieRowNodeFromLastMouseWheelEvent),zombieRowPostProcessedFromLastMouseWheelEvent=zombieRowCacheFromLastMouseWheelEvent=zombieRowNodeFromLastMouseWheelEvent=null,options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()),rowNodeFromLastMouseWheelEvent=t)}function handleDragInit(e,t){var n=getCellFromEvent(e);if(!n||!cellExists(n.row,n.cell))return!1;var o=trigger(self.onDragInit,t,e);return!!e.isImmediatePropagationStopped()&&o}function handleDragStart(e,t){var n=getCellFromEvent(e);if(!n||!cellExists(n.row,n.cell))return!1;var o=trigger(self.onDragStart,t,e);return!!e.isImmediatePropagationStopped()&&o}function handleDrag(e,t){return trigger(self.onDrag,t,e)}function handleDragEnd(e,t){trigger(self.onDragEnd,t,e)}function handleKeyDown(e){trigger(self.onKeyDown,{row:activeRow,cell:activeCell,grid:self},e);var t=e.isImmediatePropagationStopped(),n=Slick.keyCode;if(!t)if(e.shiftKey||e.altKey||e.ctrlKey)e.which!=n.TAB||!e.shiftKey||e.ctrlKey||e.altKey||(t=navigatePrev());else{if(options.editable&&currentEditor&&currentEditor.keyCaptureList&&-1<currentEditor.keyCaptureList.indexOf(e.which))return;if(e.which==n.ESCAPE){if(!getEditorLock().isActive())return;cancelEditAndSetFocus()}else e.which==n.PAGE_DOWN?(navigatePageDown(),t=!0):e.which==n.PAGE_UP?(navigatePageUp(),t=!0):e.which==n.LEFT?t=navigateLeft():e.which==n.RIGHT?t=navigateRight():e.which==n.UP?t=navigateUp():e.which==n.DOWN?t=navigateDown():e.which==n.TAB?t=navigateNext():e.which==n.ENTER&&(options.editable&&(currentEditor?activeRow===getDataLength()?navigateDown():commitEditAndSetFocus():getEditorLock().commitCurrentEdit()&&makeActiveCellEditable()),t=!0)}if(t){e.stopPropagation(),e.preventDefault();try{e.originalEvent.keyCode=0}catch(e){}}}function handleClick(e){currentEditor||(e.target!=document.activeElement||$(e.target).hasClass("slick-cell"))&&setFocus();var t=getCellFromEvent(e);if(t&&(null===currentEditor||activeRow!=t.row||activeCell!=t.cell)&&(trigger(self.onClick,{row:t.row,cell:t.cell,grid:self},e),!e.isImmediatePropagationStopped()&&canCellBeActive(t.row,t.cell)&&(!getEditorLock().isActive()||getEditorLock().commitCurrentEdit()))){scrollRowIntoView(t.row,!1);var n=e.target&&e.target.className===Slick.preClickClassName;setActiveCellInternal(getCellNode(t.row,t.cell),null,n)}}function handleContextMenu(e){var t=$(e.target).closest(".slick-cell",$canvas);0!==t.length&&(activeCellNode===t[0]&&null!==currentEditor||trigger(self.onContextMenu,{grid:self},e))}function handleDblClick(e){var t=getCellFromEvent(e);!t||null!==currentEditor&&activeRow==t.row&&activeCell==t.cell||(trigger(self.onDblClick,{row:t.row,cell:t.cell,grid:self},e),e.isImmediatePropagationStopped()||options.editable&&gotoCell(t.row,t.cell,!0))}function handleHeaderMouseEnter(e){trigger(self.onHeaderMouseEnter,{column:$(this).data("column"),grid:self},e)}function handleHeaderMouseLeave(e){trigger(self.onHeaderMouseLeave,{column:$(this).data("column"),grid:self},e)}function handleHeaderContextMenu(e){var t=$(e.target).closest(".slick-header-column",".slick-header-columns"),n=t&&t.data("column");trigger(self.onHeaderContextMenu,{column:n,grid:self},e)}function handleHeaderClick(e){var t=$(e.target).closest(".slick-header-column",".slick-header-columns"),n=t&&t.data("column");n&&trigger(self.onHeaderClick,{column:n,grid:self},e)}function handleMouseEnter(e){trigger(self.onMouseEnter,{grid:self},e)}function handleMouseLeave(e){trigger(self.onMouseLeave,{grid:self},e)}function cellExists(e,t){return!(e<0||e>=getDataLength()||t<0||t>=columns.length)}function getCellFromPoint(e,t){for(var n=getRowFromPosition(t),o=0,r=0,i=0;i<columns.length&&r<e;i++)r+=columns[i].width,o++;return o<0&&(o=0),{row:n,cell:o-1}}function getCellFromNode(e){var t=/l\d+/.exec(e.className);if(!t)throw new Error("getCellFromNode: cannot get cell - "+e.className);return parseInt(t[0].substr(1,t[0].length-1),10)}function getRowFromNode(e){for(var t in rowsCache)if(rowsCache[t].rowNode===e)return 0|t;return null}function getCellFromEvent(e){var t=$(e.target).closest(".slick-cell",$canvas);if(!t.length)return null;var n=getRowFromNode(t[0].parentNode),o=getCellFromNode(t[0]);return null==n||null==o?null:{row:n,cell:o}}function getCellNodeBox(e,t){if(!cellExists(e,t))return null;for(var n=getRowTop(e),o=n+options.rowHeight-1,r=0,i=0;i<t;i++)r+=columns[i].width;var l=r+columns[t].width;return{top:n,left:r,bottom:o,right:l}}function resetActiveCell(){setActiveCellInternal(null,!1)}function setFocus(){-1==tabbingDirection?$focusSink[0].focus():$focusSink2[0].focus()}function scrollCellIntoView(e,t,n){scrollRowIntoView(e,n);var o=getColspan(e,t);internalScrollColumnIntoView(columnPosLeft[t],columnPosRight[t+(1<o?o-1:0)])}function internalScrollColumnIntoView(e,t){var n=scrollLeft+viewportW;e<scrollLeft?($viewport.scrollLeft(e),handleScroll(),render()):n<t&&($viewport.scrollLeft(Math.min(e,t-$viewport[0].clientWidth)),handleScroll(),render())}function scrollColumnIntoView(e){internalScrollColumnIntoView(columnPosLeft[e],columnPosRight[e])}function setActiveCellInternal(e,t,n,o){null!==activeCellNode&&(makeActiveCellNormal(),$(activeCellNode).removeClass("active"),rowsCache[activeRow]&&$(rowsCache[activeRow].rowNode).removeClass("active"));null!=(activeCellNode=e)?(activeRow=getRowFromNode(activeCellNode.parentNode),activeCell=activePosX=getCellFromNode(activeCellNode),null==t&&(t=activeRow==getDataLength()||options.autoEdit),options.showCellSelection&&($(activeCellNode).addClass("active"),$(rowsCache[activeRow].rowNode).addClass("active")),options.editable&&t&&isCellPotentiallyEditable(activeRow,activeCell)&&(clearTimeout(h_editorLoader),options.asyncEditorLoading?h_editorLoader=setTimeout(function(){makeActiveCellEditable(void 0,n)},options.asyncEditorLoadDelay):makeActiveCellEditable(void 0,n))):activeRow=activeCell=null,o||trigger(self.onActiveCellChanged,getActiveCell())}function clearTextSelection(){if(document.selection&&document.selection.empty)try{document.selection.empty()}catch(e){}else if(window.getSelection){var e=window.getSelection();e&&e.removeAllRanges&&e.removeAllRanges()}}function isCellPotentiallyEditable(e,t){var n=getDataLength();return!(e<n&&!getDataItem(e))&&(!(columns[t].cannotTriggerInsert&&n<=e)&&!!getEditor(e,t))}function makeActiveCellNormal(){if(currentEditor){if(trigger(self.onBeforeCellEditorDestroy,{editor:currentEditor,grid:self}),currentEditor.destroy(),currentEditor=null,activeCellNode){var e=getDataItem(activeRow);if($(activeCellNode).removeClass("editable invalid"),e){var t=columns[activeCell],n=getFormatter(activeRow,t),o=n(activeRow,activeCell,getDataItemValueForColumn(e,t),t,e,self);applyFormatResultToCellNode(o,activeCellNode),invalidatePostProcessingResults(activeRow)}}navigator.userAgent.toLowerCase().match(/msie/)&&clearTextSelection(),getEditorLock().deactivate(editController)}}function makeActiveCellEditable(e,t){if(activeCellNode){if(!options.editable)throw new Error("Grid : makeActiveCellEditable : should never get called when options.editable is false");if(clearTimeout(h_editorLoader),isCellPotentiallyEditable(activeRow,activeCell)){var n=columns[activeCell],o=getDataItem(activeRow);if(!1!==trigger(self.onBeforeEditCell,{row:activeRow,cell:activeCell,item:o,column:n,grid:self})){getEditorLock().activate(editController),$(activeCellNode).addClass("editable");var r=e||getEditor(activeRow,activeCell);e||r.suppressClearOnEdit||(activeCellNode.innerHTML=""),currentEditor=new r({grid:self,gridPosition:absBox($container[0]),position:absBox(activeCellNode),container:activeCellNode,column:n,item:o||{},commitChanges:commitEditAndSetFocus,cancelChanges:cancelEditAndSetFocus}),o&&(currentEditor.loadValue(o),t&&currentEditor.preClick&&currentEditor.preClick()),serializedEditorValue=currentEditor.serializeValue(),currentEditor.position&&handleActiveCellPositionChange()}else setFocus()}}}function commitEditAndSetFocus(){getEditorLock().commitCurrentEdit()&&(setFocus(),options.autoEdit&&navigateDown())}function cancelEditAndSetFocus(){getEditorLock().cancelCurrentEdit()&&setFocus()}function absBox(e){var t={top:e.offsetTop,left:e.offsetLeft,bottom:0,right:0,width:$(e).outerWidth(),height:$(e).outerHeight(),visible:!0};t.bottom=t.top+t.height,t.right=t.left+t.width;for(var n=e.offsetParent;(e=e.parentNode)!=document.body&&null!=e;)t.visible&&e.scrollHeight!=e.offsetHeight&&"visible"!=$(e).css("overflowY")&&(t.visible=t.bottom>e.scrollTop&&t.top<e.scrollTop+e.clientHeight),t.visible&&e.scrollWidth!=e.offsetWidth&&"visible"!=$(e).css("overflowX")&&(t.visible=t.right>e.scrollLeft&&t.left<e.scrollLeft+e.clientWidth),t.left-=e.scrollLeft,t.top-=e.scrollTop,e===n&&(t.left+=e.offsetLeft,t.top+=e.offsetTop,n=e.offsetParent),t.bottom=t.top+t.height,t.right=t.left+t.width;return t}function getActiveCellPosition(){return absBox(activeCellNode)}function getGridPosition(){return absBox($container[0])}function handleActiveCellPositionChange(){if(activeCellNode&&(trigger(self.onActiveCellPositionChanged,{grid:self}),currentEditor)){var e=getActiveCellPosition();currentEditor.show&&currentEditor.hide&&(e.visible?currentEditor.show():currentEditor.hide()),currentEditor.position&&currentEditor.position(e)}}function getCellEditor(){return currentEditor}function getActiveCell(){return activeCellNode?{row:activeRow,cell:activeCell,grid:self}:null}function getActiveCellNode(){return activeCellNode}function scrollRowIntoView(e,t){var n=e*options.rowHeight,o=(e+1)*options.rowHeight-viewportH+(viewportHasHScroll?scrollbarDimensions.height:0);(e+1)*options.rowHeight>scrollTop+viewportH+offset?(scrollTo(t?n:o),render()):e*options.rowHeight<scrollTop+offset&&(scrollTo(t?o:n),render())}function scrollRowToTop(e){scrollTo(e*options.rowHeight),render()}function scrollPage(e){var t=e*numVisibleRows;if(scrollTo((getRowFromPosition(scrollTop)+t)*options.rowHeight),render(),options.enableCellNavigation&&null!=activeRow){var n=activeRow+t,o=getDataLengthIncludingAddNew();o<=n&&(n=o-1),n<0&&(n=0);for(var r=0,i=null,l=activePosX;r<=activePosX;)canCellBeActive(n,r)&&(i=r),r+=getColspan(n,r);null!==i?(setActiveCellInternal(getCellNode(n,i)),activePosX=l):resetActiveCell()}}function navigatePageDown(){scrollPage(1)}function navigatePageUp(){scrollPage(-1)}function getColspan(e,t){var n=data.getItemMetadata&&data.getItemMetadata(e);if(!n||!n.columns)return 1;var o=n.columns[columns[t].id]||n.columns[t],r=o&&o.colspan;return r="*"===r?columns.length-t:r||1}function findFirstFocusableCell(e){for(var t=0;t<columns.length;){if(canCellBeActive(e,t))return t;t+=getColspan(e,t)}return null}function findLastFocusableCell(e){for(var t=0,n=null;t<columns.length;)canCellBeActive(e,t)&&(n=t),t+=getColspan(e,t);return n}function gotoRight(e,t,n){if(t>=columns.length)return null;for(;(t+=getColspan(e,t))<columns.length&&!canCellBeActive(e,t););return t<columns.length?{row:e,cell:t,posX:t}:null}function gotoLeft(e,t,n){if(t<=0)return null;var o=findFirstFocusableCell(e);if(null===o||t<=o)return null;for(var r,i={row:e,cell:o,posX:o};;){if(!(r=gotoRight(i.row,i.cell,i.posX)))return null;if(r.cell>=t)return i;i=r}}function gotoDown(e,t,n){for(var o,r=getDataLengthIncludingAddNew();;){if(++e>=r)return null;for(o=t=0;t<=n;)t+=getColspan(e,o=t);if(canCellBeActive(e,o))return{row:e,cell:o,posX:n}}}function gotoUp(e,t,n){for(var o;;){if(--e<0)return null;for(o=t=0;t<=n;)t+=getColspan(e,o=t);if(canCellBeActive(e,o))return{row:e,cell:o,posX:n}}}function gotoNext(e,t,n){if(null==e&&null==t&&canCellBeActive(e=t=n=0,t))return{row:e,cell:t,posX:t};var o=gotoRight(e,t,n);if(o)return o;var r=null,i=getDataLengthIncludingAddNew();for(e===i-1&&e--;++e<i;)if(null!==(r=findFirstFocusableCell(e)))return{row:e,cell:r,posX:r};return null}function gotoPrev(e,t,n){if(null==e&&null==t&&(e=getDataLengthIncludingAddNew()-1,t=n=columns.length-1,canCellBeActive(e,t)))return{row:e,cell:t,posX:t};for(var o,r;!o&&!(o=gotoLeft(e,t,n));){if(--e<0)return null;t=0,null!==(r=findLastFocusableCell(e))&&(o={row:e,cell:r,posX:r})}return o}function navigateRight(){return navigate("right")}function navigateLeft(){return navigate("left")}function navigateDown(){return navigate("down")}function navigateUp(){return navigate("up")}function navigateNext(){return navigate("next")}function navigatePrev(){return navigate("prev")}function navigate(e){if(!options.enableCellNavigation)return!1;if(!activeCellNode&&"prev"!=e&&"next"!=e)return!1;if(!getEditorLock().commitCurrentEdit())return!0;setFocus();tabbingDirection={up:-1,down:1,left:-1,right:1,prev:-1,next:1}[e];var t={up:gotoUp,down:gotoDown,left:gotoLeft,right:gotoRight,prev:gotoPrev,next:gotoNext},n=t[e],o=n(activeRow,activeCell,activePosX);if(o){var r=o.row==getDataLength();return scrollCellIntoView(o.row,o.cell,!r),setActiveCellInternal(getCellNode(o.row,o.cell)),activePosX=o.posX,!0}return setActiveCellInternal(getCellNode(activeRow,activeCell)),!1}function getCellNode(e,t){return rowsCache[e]?(ensureCellNodesInRowsCache(e),rowsCache[e].cellNodesByColumnIdx[t]):null}function setActiveCell(e,t,n,o,r){initialized&&(e>getDataLength()||e<0||t>=columns.length||t<0||options.enableCellNavigation&&(scrollCellIntoView(e,t,!1),setActiveCellInternal(getCellNode(e,t),n,o,r)))}function canCellBeActive(e,t){if(!options.enableCellNavigation||e>=getDataLengthIncludingAddNew()||e<0||t>=columns.length||t<0)return!1;var n=data.getItemMetadata&&data.getItemMetadata(e);if(n&&"boolean"==typeof n.focusable)return n.focusable;var o=n&&n.columns;return o&&o[columns[t].id]&&"boolean"==typeof o[columns[t].id].focusable?o[columns[t].id].focusable:o&&o[t]&&"boolean"==typeof o[t].focusable?o[t].focusable:columns[t].focusable}function canCellBeSelected(e,t){if(e>=getDataLength()||e<0||t>=columns.length||t<0)return!1;var n=data.getItemMetadata&&data.getItemMetadata(e);if(n&&"boolean"==typeof n.selectable)return n.selectable;var o=n&&n.columns&&(n.columns[columns[t].id]||n.columns[t]);return o&&"boolean"==typeof o.selectable?o.selectable:columns[t].selectable}function gotoCell(e,t,n){if(initialized&&canCellBeActive(e,t)&&getEditorLock().commitCurrentEdit()){scrollCellIntoView(e,t,!1);var o=getCellNode(e,t);setActiveCellInternal(o,n||e===getDataLength()||options.autoEdit),currentEditor||setFocus()}}function commitCurrentEdit(){var e=getDataItem(activeRow),t=columns[activeCell];if(currentEditor){if(currentEditor.isValueChanged()){var n=currentEditor.validate();if(n.valid){if(activeRow<getDataLength()){var o={row:activeRow,cell:activeCell,editor:currentEditor,serializedValue:currentEditor.serializeValue(),prevSerializedValue:serializedEditorValue,execute:function(){this.editor.applyValue(e,this.serializedValue),updateRow(this.row),trigger(self.onCellChange,{row:activeRow,cell:activeCell,item:e,grid:self})},undo:function(){this.editor.applyValue(e,this.prevSerializedValue),updateRow(this.row),trigger(self.onCellChange,{row:activeRow,cell:activeCell,item:e,grid:self})}};options.editCommandHandler?(makeActiveCellNormal(),options.editCommandHandler(e,t,o)):(o.execute(),makeActiveCellNormal())}else{var r={};currentEditor.applyValue(r,currentEditor.serializeValue()),makeActiveCellNormal(),trigger(self.onAddNewRow,{item:r,column:t,grid:self})}return!getEditorLock().isActive()}return $(activeCellNode).removeClass("invalid"),$(activeCellNode).width(),$(activeCellNode).addClass("invalid"),trigger(self.onValidationError,{editor:currentEditor,cellNode:activeCellNode,validationResults:n,row:activeRow,cell:activeCell,column:t,grid:self}),currentEditor.focus(),!1}makeActiveCellNormal()}return!0}function cancelCurrentEdit(){return makeActiveCellNormal(),!0}function rowsToRanges(e){for(var t=[],n=columns.length-1,o=0;o<e.length;o++)t.push(new Slick.Range(e[o],0,e[o],n));return t}function getSelectedRows(){if(!selectionModel)throw new Error("Selection model is not set");return selectedRows}function setSelectedRows(e){if(!selectionModel)throw new Error("Selection model is not set");selectionModel.setSelectedRanges(rowsToRanges(e))}this.debug=function(){var e="";e+="\ncounter_rows_rendered:  "+counter_rows_rendered,e+="\ncounter_rows_removed:  "+counter_rows_removed,e+="\nrenderedRows:  "+renderedRows,e+="\nnumVisibleRows:  "+numVisibleRows,e+="\nmaxSupportedCssHeight:  "+maxSupportedCssHeight,e+="\nn(umber of pages):  "+n,e+="\n(current) page:  "+page,e+="\npage height (ph):  "+ph,e+="\nvScrollDir:  "+vScrollDir,alert(e)},this.eval=function(expr){return eval(expr)},$.extend(this,{slickGridVersion:"2.3.4",onScroll:new Slick.Event,onSort:new Slick.Event,onHeaderMouseEnter:new Slick.Event,onHeaderMouseLeave:new Slick.Event,onHeaderContextMenu:new Slick.Event,onHeaderClick:new Slick.Event,onHeaderCellRendered:new Slick.Event,onBeforeHeaderCellDestroy:new Slick.Event,onHeaderRowCellRendered:new Slick.Event,onFooterRowCellRendered:new Slick.Event,onBeforeHeaderRowCellDestroy:new Slick.Event,onBeforeFooterRowCellDestroy:new Slick.Event,onMouseEnter:new Slick.Event,onMouseLeave:new Slick.Event,onClick:new Slick.Event,onDblClick:new Slick.Event,onContextMenu:new Slick.Event,onKeyDown:new Slick.Event,onAddNewRow:new Slick.Event,onBeforeAppendCell:new Slick.Event,onValidationError:new Slick.Event,onViewportChanged:new Slick.Event,onColumnsReordered:new Slick.Event,onColumnsResized:new Slick.Event,onCellChange:new Slick.Event,onBeforeEditCell:new Slick.Event,onBeforeCellEditorDestroy:new Slick.Event,onBeforeDestroy:new Slick.Event,onActiveCellChanged:new Slick.Event,onActiveCellPositionChanged:new Slick.Event,onDragInit:new Slick.Event,onDragStart:new Slick.Event,onDrag:new Slick.Event,onDragEnd:new Slick.Event,onSelectedRowsChanged:new Slick.Event,onCellCssStylesChanged:new Slick.Event,registerPlugin:registerPlugin,unregisterPlugin:unregisterPlugin,getColumns:getColumns,setColumns:setColumns,getColumnIndex:getColumnIndex,updateColumnHeader:updateColumnHeader,setSortColumn:setSortColumn,setSortColumns:setSortColumns,getSortColumns:getSortColumns,autosizeColumns:autosizeColumns,getOptions:getOptions,setOptions:setOptions,getData:getData,getDataLength:getDataLength,getDataItem:getDataItem,setData:setData,getSelectionModel:getSelectionModel,setSelectionModel:setSelectionModel,getSelectedRows:getSelectedRows,setSelectedRows:setSelectedRows,getContainerNode:getContainerNode,updatePagingStatusFromView:updatePagingStatusFromView,render:render,invalidate:invalidate,invalidateRow:invalidateRow,invalidateRows:invalidateRows,invalidateAllRows:invalidateAllRows,updateCell:updateCell,updateRow:updateRow,getViewport:getVisibleRange,getRenderedRange:getRenderedRange,resizeCanvas:resizeCanvas,updateRowCount:updateRowCount,scrollRowIntoView:scrollRowIntoView,scrollRowToTop:scrollRowToTop,scrollCellIntoView:scrollCellIntoView,scrollColumnIntoView:scrollColumnIntoView,getCanvasNode:getCanvasNode,getUID:getUID,getHeaderColumnWidthDiff:getHeaderColumnWidthDiff,getScrollbarDimensions:getScrollbarDimensions,getHeadersWidth:getHeadersWidth,getCanvasWidth:getCanvasWidth,focus:setFocus,getCellFromPoint:getCellFromPoint,getCellFromEvent:getCellFromEvent,getActiveCell:getActiveCell,setActiveCell:setActiveCell,getActiveCellNode:getActiveCellNode,getActiveCellPosition:getActiveCellPosition,resetActiveCell:resetActiveCell,editActiveCell:makeActiveCellEditable,getCellEditor:getCellEditor,getCellNode:getCellNode,getCellNodeBox:getCellNodeBox,canCellBeSelected:canCellBeSelected,canCellBeActive:canCellBeActive,navigatePrev:navigatePrev,navigateNext:navigateNext,navigateUp:navigateUp,navigateDown:navigateDown,navigateLeft:navigateLeft,navigateRight:navigateRight,navigatePageUp:navigatePageUp,navigatePageDown:navigatePageDown,gotoCell:gotoCell,getTopPanel:getTopPanel,setTopPanelVisibility:setTopPanelVisibility,getPreHeaderPanel:getPreHeaderPanel,setPreHeaderPanelVisibility:setPreHeaderPanelVisibility,setHeaderRowVisibility:setHeaderRowVisibility,getHeaderRow:getHeaderRow,getHeaderRowColumn:getHeaderRowColumn,setFooterRowVisibility:setFooterRowVisibility,getFooterRow:getFooterRow,getFooterRowColumn:getFooterRowColumn,getGridPosition:getGridPosition,flashCell:flashCell,addCellCssStyles:addCellCssStyles,setCellCssStyles:setCellCssStyles,removeCellCssStyles:removeCellCssStyles,getCellCssStyles:getCellCssStyles,init:finishInitialization,destroy:destroy,getEditorLock:getEditorLock,getEditController:getEditController}),init()}module.exports={Grid:SlickGrid}},448:function(e,t,n){t.exports="undefined"!=typeof $?$:e(441)},449:function(e,t,n){var o=e(450),r=o.template;function i(e,t,n){return r(e,t,n)}i._=o,t.exports=i,"function"==typeof define&&define.amd?define(function(){return i}):"undefined"==typeof window&&"undefined"==typeof navigator||(window.UnderscoreTemplate=i)},450:function(e,t,n){
//     (c) 2009-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
var l={},o=Array.prototype,r=Object.prototype,i=o.slice,s=r.toString,a=r.hasOwnProperty,c=o.forEach,u=Object.keys,d=Array.isArray,p=function(){},f=p.each=p.forEach=function(e,t,n){if(null!=e)if(c&&e.forEach===c)e.forEach(t,n);else if(e.length===+e.length){for(var o=0,r=e.length;o<r;o++)if(t.call(n,e[o],o,e)===l)return}else for(var i=p.keys(e),o=0,r=i.length;o<r;o++)if(t.call(n,e[i[o]],i[o],e)===l)return};p.keys=u||function(e){if(e!==Object(e))throw new TypeError("Invalid object");var t=[];for(var n in e)p.has(e,n)&&t.push(n);return t},p.defaults=function(n){return f(i.call(arguments,1),function(e){if(e)for(var t in e)void 0===n[t]&&(n[t]=e[t])}),n},p.isArray=d||function(e){return"[object Array]"===s.call(e)},p.has=function(e,t){if(!p.isArray(t))return null!=e&&a.call(e,t);for(var n=t.length,o=0;o<n;o++){var r=t[o];if(null==e||!a.call(e,r))return!1;e=e[r]}return!!n};var h={escape:{"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;"}},g={escape:new RegExp("["+p.keys(h.escape).join("")+"]","g")};p.each(["escape"],function(t){p[t]=function(e){return null==e?"":(""+e).replace(g[t],function(e){return h[t][e]})}}),p.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var m=/(.)^/,v={"'":"'","\\":"\\","\r":"r","\n":"n","\t":"t","\u2028":"u2028","\u2029":"u2029"},w=/\\|'|\r|\n|\t|\u2028|\u2029/g;p.template=function(i,e,t){var n;t=p.defaults({},t,p.templateSettings);var o=new RegExp([(t.escape||m).source,(t.interpolate||m).source,(t.evaluate||m).source].join("|")+"|$","g"),l=0,s="__p+='";i.replace(o,function(e,t,n,o,r){return s+=i.slice(l,r).replace(w,function(e){return"\\"+v[e]}),t&&(s+="'+\n((__t=("+t+"))==null?'':_.escape(__t))+\n'"),n&&(s+="'+\n((__t=("+n+"))==null?'':__t)+\n'"),o&&(s+="';\n"+o+"\n__p+='"),l=r+e.length,e}),s+="';\n",t.variable||(s="with(obj||{}){\n"+s+"}\n"),s="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+s+"return __p;\n";try{n=new Function(t.variable||"obj","_",s)}catch(e){throw e.source=s,e}if(e)return n(e,p);var r=function(e){return n.call(this,e,p)};return r.source="function("+(t.variable||"obj")+"){\n"+s+"}",r},t.exports=p}},0,0)}(a.Bokeh)}(this);
//# sourceMappingURL=bokeh-tables.min.js.map