export declare function copy<T>(array: Array<T>): Array<T>;
export declare function concat<T>(arrays: Array<Array<T>>): Array<T>;
export declare function contains<T>(array: Array<T>, value: T): boolean;
export declare function nth<T>(array: Array<T>, index: number): T;
export declare function zip<A, B>(As: Array<A>, Bs: Array<B>): Array<[A, B]>;
export declare function unzip<A, B>(ABs: Array<[A, B]>): [Array<A>, Array<B>];
export declare function range(start: number, stop?: number, step?: number): Array<number>;
export declare function linspace(start: number, stop: number, num?: number): Array<number>;
export declare function transpose<T>(array: Array<Array<T>>): Array<Array<T>>;
export declare function sum(array: Array<number>): number;
export declare function cumsum(array: Array<number>): Array<number>;
export declare function min(array: Array<number>): number;
export declare function minBy<T>(array: Array<T>, key: (item: T) => number): T;
export declare function max(array: Array<number>): number;
export declare function maxBy<T>(array: Array<T>, key: (item: T) => number): T;
export declare function argmin(array: Array<number>): number;
export declare function argmax(array: Array<number>): number;
export declare function all<T>(array: Array<T>, predicate: (item: T) => boolean): boolean;
export declare function any<T>(array: Array<T>, predicate: (item: T) => boolean): boolean;
export declare const findIndex: <T>(array: T[], predicate: (item: T) => boolean) => number;
export declare const findLastIndex: <T>(array: T[], predicate: (item: T) => boolean) => number;
export declare function sortedIndex<T>(array: Array<T>, value: T): number;
export declare function sortBy<T>(array: Array<T>, key: (item: T) => number): Array<T>;
export declare function uniq<T>(array: Array<T>): Array<T>;
export declare function uniqBy<T, U>(array: Array<T>, key: (item: T) => U): Array<T>;
export declare function union<T>(...arrays: Array<Array<T>>): Array<T>;
export declare function intersection<T>(array: Array<T>, ...arrays: Array<Array<T>>): Array<T>;
export declare function difference<T>(array: Array<T>, ...arrays: Array<Array<T>>): Array<T>;
