var bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

import * as $ from "jquery";

import "jquery-ui/datepicker";

import * as p from "core/properties";

import {
  InputWidget,
  InputWidgetView
} from "./input_widget";

export var DatePickerView = (function(superClass) {
  extend(DatePickerView, superClass);

  function DatePickerView() {
    this.onSelect = bind(this.onSelect, this);
    return DatePickerView.__super__.constructor.apply(this, arguments);
  }

  DatePickerView.prototype.render = function() {
    DatePickerView.__super__.render.call(this);
    this.label = $('<label>').text(this.model.title);
    this.input = $('<input type="text">');
    this.datepicker = this.input.datepicker({
      defaultDate: new Date(this.model.value),
      minDate: this.model.min_date != null ? new Date(this.model.min_date) : null,
      maxDate: this.model.max_date != null ? new Date(this.model.max_date) : null,
      onSelect: this.onSelect
    });
    this.$el.append([this.label, this.input]);
    this._prefix_ui();
    return this;
  };

  DatePickerView.prototype.onSelect = function(dateText, ui) {
    var d, ref;
    d = new Date(dateText);
    this.model.value = d.toString();
    return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
  };

  return DatePickerView;

})(InputWidgetView);

export var DatePicker = (function(superClass) {
  extend(DatePicker, superClass);

  function DatePicker() {
    return DatePicker.__super__.constructor.apply(this, arguments);
  }

  DatePicker.prototype.type = "DatePicker";

  DatePicker.prototype.default_view = DatePickerView;

  DatePicker.define({
    value: [p.Any, Date.now()],
    min_date: [p.Any],
    max_date: [p.Any]
  });

  return DatePicker;

})(InputWidget);
