window.Bokeh = Bokeh = (function() { var define = undefined; return (function outer(modules, cache, entry) {
    function newRequire(name) {
        if (!cache[name]) {
            if (!modules[name]) {
                var err = new Error('Cannot find module \'' + name + '\'');
                err.code = 'MODULE_NOT_FOUND';
                throw err;
            }

            var m = cache[name] = {exports: {}};

            var moduleRequire = function foo(x) {
                var id = modules[name][1][x];
                return newRequire(id ? id : x);
            }
            moduleRequire.modules = newRequire.modules;

            modules[name][0].call(m.exports, moduleRequire, m, m.exports, outer, modules, cache, entry);
        }

        return cache[name].exports;
    }

    newRequire.modules = modules;

    var main = newRequire(entry[0]);
    main.require = newRequire;
    return main;
})
({"base":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var _all_models, hasProp = {}.hasOwnProperty;
var models = require("./models/index");
var object_1 = require("./core/util/object");
exports.overrides = {};
_all_models = object_1.clone(models);
exports.Models = function (name) {
    var model, ref;
    model = (ref = exports.overrides[name]) != null ? ref : _all_models[name];
    if (model == null) {
        throw new Error("Model `" + name + "' does not exist. This could be due to a widget or a custom model not being registered before first usage.");
    }
    return model;
};
exports.Models.register = function (name, model) {
    return exports.overrides[name] = model;
};
exports.Models.unregister = function (name) {
    return delete exports.overrides[name];
};
exports.Models.register_models = function (models, force, errorFn) {
    var model, name, results;
    if (force == null) {
        force = false;
    }
    if (errorFn == null) {
        errorFn = null;
    }
    if (models == null) {
        return;
    }
    results = [];
    for (name in models) {
        if (!hasProp.call(models, name))
            continue;
        model = models[name];
        if (force || !_all_models.hasOwnProperty(name)) {
            results.push(_all_models[name] = model);
        }
        else {
            results.push(typeof errorFn === "function" ? errorFn(name) : void 0);
        }
    }
    return results;
};
exports.Models.registered_names = function () {
    return Object.keys(_all_models);
};
exports.index = {};

},{"./core/util/object":"core/util/object","./models/index":"models/index"}],"client":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ClientConnection, ClientSession, Message, message_handlers;
var es6_promise_1 = require("es6-promise");
var logging_1 = require("./core/logging");
var string_1 = require("./core/util/string");
var object_1 = require("./core/util/object");
var document_1 = require("./document");
exports.DEFAULT_SERVER_WEBSOCKET_URL = "ws://localhost:5006/ws";
exports.DEFAULT_SESSION_ID = "default";
Message = (function () {
    function Message(header1, metadata1, content1) {
        this.header = header1;
        this.metadata = metadata1;
        this.content = content1;
        this.buffers = [];
    }
    Message.assemble = function (header_json, metadata_json, content_json) {
        var content, e, header, metadata;
        try {
            header = JSON.parse(header_json);
            metadata = JSON.parse(metadata_json);
            content = JSON.parse(content_json);
            return new Message(header, metadata, content);
        }
        catch (error1) {
            e = error1;
            logging_1.logger.error("Failure parsing json " + e + " " + header_json + " " + metadata_json + " " + content_json, e);
            throw e;
        }
    };
    Message.create_header = function (msgtype, options) {
        var header;
        header = {
            'msgid': string_1.uniqueId(),
            'msgtype': msgtype
        };
        return object_1.extend(header, options);
    };
    Message.create = function (msgtype, header_options, content) {
        var header;
        if (content == null) {
            content = {};
        }
        header = Message.create_header(msgtype, header_options);
        return new Message(header, {}, content);
    };
    Message.prototype.send = function (socket) {
        var content_json, e, header_json, metadata_json;
        try {
            header_json = JSON.stringify(this.header);
            metadata_json = JSON.stringify(this.metadata);
            content_json = JSON.stringify(this.content);
            socket.send(header_json);
            socket.send(metadata_json);
            return socket.send(content_json);
        }
        catch (error1) {
            e = error1;
            logging_1.logger.error("Error sending ", this, e);
            throw e;
        }
    };
    Message.prototype.complete = function () {
        if ((this.header != null) && (this.metadata != null) && (this.content != null)) {
            if ('num_buffers' in this.header) {
                return this.buffers.length === this.header['num_buffers'];
            }
            else {
                return true;
            }
        }
        else {
            return false;
        }
    };
    Message.prototype.add_buffer = function (buffer) {
        return this.buffers.push(buffer);
    };
    Message.prototype._header_field = function (field) {
        if (field in this.header) {
            return this.header[field];
        }
        else {
            return null;
        }
    };
    Message.prototype.msgid = function () {
        return this._header_field('msgid');
    };
    Message.prototype.msgtype = function () {
        return this._header_field('msgtype');
    };
    Message.prototype.sessid = function () {
        return this._header_field('sessid');
    };
    Message.prototype.reqid = function () {
        return this._header_field('reqid');
    };
    Message.prototype.problem = function () {
        if (!('msgid' in this.header)) {
            return "No msgid in header";
        }
        else if (!('msgtype' in this.header)) {
            return "No msgtype in header";
        }
        else {
            return null;
        }
    };
    return Message;
})();
message_handlers = {
    'PATCH-DOC': function (connection, message) {
        return connection._for_session(function (session) {
            return session._handle_patch(message);
        });
    },
    'OK': function (connection, message) {
        return logging_1.logger.debug("Unhandled OK reply to " + (message.reqid()));
    },
    'ERROR': function (connection, message) {
        return logging_1.logger.error("Unhandled ERROR reply to " + (message.reqid()) + ": " + message.content['text']);
    }
};
ClientConnection = (function () {
    ClientConnection._connection_count = 0;
    function ClientConnection(url1, id, args_string1, _on_have_session_hook, _on_closed_permanently_hook) {
        this.url = url1;
        this.id = id;
        this.args_string = args_string1;
        this._on_have_session_hook = _on_have_session_hook;
        this._on_closed_permanently_hook = _on_closed_permanently_hook;
        this._number = ClientConnection._connection_count;
        ClientConnection._connection_count = this._number + 1;
        if (this.url == null) {
            this.url = exports.DEFAULT_SERVER_WEBSOCKET_URL;
        }
        if (this.id == null) {
            this.id = exports.DEFAULT_SESSION_ID;
        }
        logging_1.logger.debug("Creating websocket " + this._number + " to '" + this.url + "' session '" + this.id + "'");
        this.socket = null;
        this.closed_permanently = false;
        this._fragments = [];
        this._partial = null;
        this._current_handler = null;
        this._pending_ack = null;
        this._pending_replies = {};
        this.session = null;
    }
    ClientConnection.prototype._for_session = function (f) {
        if (this.session !== null) {
            return f(this.session);
        }
    };
    ClientConnection.prototype.connect = function () {
        var error, ref, versioned_url;
        if (this.closed_permanently) {
            return es6_promise_1.Promise.reject(new Error("Cannot connect() a closed ClientConnection"));
        }
        if (this.socket != null) {
            return es6_promise_1.Promise.reject(new Error("Already connected"));
        }
        this._fragments = [];
        this._partial = null;
        this._pending_replies = {};
        this._current_handler = null;
        try {
            versioned_url = this.url + "?bokeh-protocol-version=1.0&bokeh-session-id=" + this.id;
            if (((ref = this.args_string) != null ? ref.length : void 0) > 0) {
                versioned_url += "&" + this.args_string;
            }
            if (window.MozWebSocket != null) {
                this.socket = new MozWebSocket(versioned_url);
            }
            else {
                this.socket = new WebSocket(versioned_url);
            }
            return new es6_promise_1.Promise((function (_this) {
                return function (resolve, reject) {
                    _this.socket.binarytype = "arraybuffer";
                    _this.socket.onopen = function () {
                        return _this._on_open(resolve, reject);
                    };
                    _this.socket.onmessage = function (event) {
                        return _this._on_message(event);
                    };
                    _this.socket.onclose = function (event) {
                        return _this._on_close(event);
                    };
                    return _this.socket.onerror = function () {
                        return _this._on_error(reject);
                    };
                };
            })(this));
        }
        catch (error1) {
            error = error1;
            logging_1.logger.error("websocket creation failed to url: " + this.url);
            logging_1.logger.error(" - " + error);
            return es6_promise_1.Promise.reject(error);
        }
    };
    ClientConnection.prototype.close = function () {
        if (!this.closed_permanently) {
            logging_1.logger.debug("Permanently closing websocket connection " + this._number);
            this.closed_permanently = true;
            if (this.socket != null) {
                this.socket.close(1000, "close method called on ClientConnection " + this._number);
            }
            this._for_session(function (session) {
                return session._connection_closed();
            });
            if (this._on_closed_permanently_hook != null) {
                this._on_closed_permanently_hook();
                return this._on_closed_permanently_hook = null;
            }
        }
    };
    ClientConnection.prototype._schedule_reconnect = function (milliseconds) {
        var retry;
        retry = (function (_this) {
            return function () {
                if (true || _this.closed_permanently) {
                    if (!_this.closed_permanently) {
                        logging_1.logger.info("Websocket connection " + _this._number + " disconnected, will not attempt to reconnect");
                    }
                }
                else {
                    logging_1.logger.debug("Attempting to reconnect websocket " + _this._number);
                    return _this.connect();
                }
            };
        })(this);
        return setTimeout(retry, milliseconds);
    };
    ClientConnection.prototype.send = function (message) {
        var e;
        try {
            if (this.socket === null) {
                throw new Error("not connected so cannot send " + message);
            }
            return message.send(this.socket);
        }
        catch (error1) {
            e = error1;
            return logging_1.logger.error("Error sending message ", e, message);
        }
    };
    ClientConnection.prototype.send_event = function (event) {
        var message;
        message = Message.create('EVENT', {}, JSON.stringify(event));
        return this.send(message);
    };
    ClientConnection.prototype.send_with_reply = function (message) {
        var promise;
        promise = new es6_promise_1.Promise((function (_this) {
            return function (resolve, reject) {
                _this._pending_replies[message.msgid()] = [resolve, reject];
                return _this.send(message);
            };
        })(this));
        return promise.then(function (message) {
            if (message.msgtype() === 'ERROR') {
                throw new Error("Error reply " + message.content['text']);
            }
            else {
                return message;
            }
        }, function (error) {
            throw error;
        });
    };
    ClientConnection.prototype._pull_doc_json = function () {
        var message, promise;
        message = Message.create('PULL-DOC-REQ', {});
        promise = this.send_with_reply(message);
        return promise.then(function (reply) {
            if (!('doc' in reply.content)) {
                throw new Error("No 'doc' field in PULL-DOC-REPLY");
            }
            return reply.content['doc'];
        }, function (error) {
            throw error;
        });
    };
    ClientConnection.prototype._repull_session_doc = function () {
        if (this.session === null) {
            logging_1.logger.debug("Pulling session for first time");
        }
        else {
            logging_1.logger.debug("Repulling session");
        }
        return this._pull_doc_json().then((function (_this) {
            return function (doc_json) {
                var document, patch, patch_message;
                if (_this.session === null) {
                    if (_this.closed_permanently) {
                        return logging_1.logger.debug("Got new document after connection was already closed");
                    }
                    else {
                        document = document_1.Document.from_json(doc_json);
                        patch = document_1.Document._compute_patch_since_json(doc_json, document);
                        if (patch.events.length > 0) {
                            logging_1.logger.debug("Sending " + patch.events.length + " changes from model construction back to server");
                            patch_message = Message.create('PATCH-DOC', {}, patch);
                            _this.send(patch_message);
                        }
                        _this.session = new ClientSession(_this, document, _this.id);
                        logging_1.logger.debug("Created a new session from new pulled doc");
                        if (_this._on_have_session_hook != null) {
                            _this._on_have_session_hook(_this.session);
                            return _this._on_have_session_hook = null;
                        }
                    }
                }
                else {
                    _this.session.document.replace_with_json(doc_json);
                    return logging_1.logger.debug("Updated existing session with new pulled doc");
                }
            };
        })(this), function (error) {
            throw error;
        })["catch"](function (error) {
            if (console.trace != null) {
                console.trace(error);
            }
            return logging_1.logger.error("Failed to repull session " + error);
        });
    };
    ClientConnection.prototype._on_open = function (resolve, reject) {
        logging_1.logger.info("Websocket connection " + this._number + " is now open");
        this._pending_ack = [resolve, reject];
        return this._current_handler = (function (_this) {
            return function (message) {
                return _this._awaiting_ack_handler(message);
            };
        })(this);
    };
    ClientConnection.prototype._on_message = function (event) {
        var e;
        try {
            return this._on_message_unchecked(event);
        }
        catch (error1) {
            e = error1;
            return logging_1.logger.error("Error handling message: " + e + ", " + event);
        }
    };
    ClientConnection.prototype._on_message_unchecked = function (event) {
        var msg, problem;
        if (this._current_handler == null) {
            logging_1.logger.error("got a message but haven't set _current_handler");
        }
        if (event.data instanceof ArrayBuffer) {
            if ((this._partial != null) && !this._partial.complete()) {
                this._partial.add_buffer(event.data);
            }
            else {
                this._close_bad_protocol("Got binary from websocket but we were expecting text");
            }
        }
        else if (this._partial != null) {
            this._close_bad_protocol("Got text from websocket but we were expecting binary");
        }
        else {
            this._fragments.push(event.data);
            if (this._fragments.length === 3) {
                this._partial = Message.assemble(this._fragments[0], this._fragments[1], this._fragments[2]);
                this._fragments = [];
                problem = this._partial.problem();
                if (problem !== null) {
                    this._close_bad_protocol(problem);
                }
            }
        }
        if ((this._partial != null) && this._partial.complete()) {
            msg = this._partial;
            this._partial = null;
            return this._current_handler(msg);
        }
    };
    ClientConnection.prototype._on_close = function (event) {
        var pop_pending, promise_funcs;
        logging_1.logger.info("Lost websocket " + this._number + " connection, " + event.code + " (" + event.reason + ")");
        this.socket = null;
        if (this._pending_ack != null) {
            this._pending_ack[1](new Error("Lost websocket connection, " + event.code + " (" + event.reason + ")"));
            this._pending_ack = null;
        }
        pop_pending = (function (_this) {
            return function () {
                var promise_funcs, ref, reqid;
                ref = _this._pending_replies;
                for (reqid in ref) {
                    promise_funcs = ref[reqid];
                    delete _this._pending_replies[reqid];
                    return promise_funcs;
                }
                return null;
            };
        })(this);
        promise_funcs = pop_pending();
        while (promise_funcs !== null) {
            promise_funcs[1]("Disconnected");
            promise_funcs = pop_pending();
        }
        if (!this.closed_permanently) {
            return this._schedule_reconnect(2000);
        }
    };
    ClientConnection.prototype._on_error = function (reject) {
        logging_1.logger.debug("Websocket error on socket  " + this._number);
        return reject(new Error("Could not open websocket"));
    };
    ClientConnection.prototype._close_bad_protocol = function (detail) {
        logging_1.logger.error("Closing connection: " + detail);
        if (this.socket != null) {
            return this.socket.close(1002, detail);
        }
    };
    ClientConnection.prototype._awaiting_ack_handler = function (message) {
        if (message.msgtype() === "ACK") {
            this._current_handler = (function (_this) {
                return function (message) {
                    return _this._steady_state_handler(message);
                };
            })(this);
            this._repull_session_doc();
            if (this._pending_ack != null) {
                this._pending_ack[0](this);
                return this._pending_ack = null;
            }
        }
        else {
            return this._close_bad_protocol("First message was not an ACK");
        }
    };
    ClientConnection.prototype._steady_state_handler = function (message) {
        var promise_funcs;
        if (message.reqid() in this._pending_replies) {
            promise_funcs = this._pending_replies[message.reqid()];
            delete this._pending_replies[message.reqid()];
            return promise_funcs[0](message);
        }
        else if (message.msgtype() in message_handlers) {
            return message_handlers[message.msgtype()](this, message);
        }
        else {
            return logging_1.logger.debug("Doing nothing with message " + (message.msgtype()));
        }
    };
    return ClientConnection;
})();
ClientSession = (function () {
    function ClientSession(_connection, document1, id) {
        this._connection = _connection;
        this.document = document1;
        this.id = id;
        this.document_listener = (function (_this) {
            return function (event) {
                return _this._document_changed(event);
            };
        })(this);
        this.document.on_change(this.document_listener);
        this.event_manager = this.document.event_manager;
        this.event_manager.session = this;
    }
    ClientSession.prototype.close = function () {
        return this._connection.close();
    };
    ClientSession.prototype.send_event = function (type) {
        return this._connection.send_event(type);
    };
    ClientSession.prototype._connection_closed = function () {
        return this.document.remove_on_change(this.document_listener);
    };
    ClientSession.prototype.request_server_info = function () {
        var message, promise;
        message = Message.create('SERVER-INFO-REQ', {});
        promise = this._connection.send_with_reply(message);
        return promise.then(function (reply) {
            return reply.content;
        });
    };
    ClientSession.prototype.force_roundtrip = function () {
        return this.request_server_info().then(function (ignored) {
            return void 0;
        });
    };
    ClientSession.prototype._document_changed = function (event) {
        var patch;
        if (event.setter_id === this.id) {
            return;
        }
        if (event instanceof document_1.ModelChangedEvent && !(event.attr in event.model.serializable_attributes())) {
            return;
        }
        patch = Message.create('PATCH-DOC', {}, this.document.create_json_patch([event]));
        return this._connection.send(patch);
    };
    ClientSession.prototype._handle_patch = function (message) {
        return this.document.apply_json_patch(message.content, this.id);
    };
    return ClientSession;
})();
exports.pull_session = function (url, session_id, args_string) {
    var connection, promise, rejecter;
    rejecter = null;
    connection = null;
    promise = new es6_promise_1.Promise(function (resolve, reject) {
        connection = new ClientConnection(url, session_id, args_string, function (session) {
            var e;
            try {
                return resolve(session);
            }
            catch (error1) {
                e = error1;
                logging_1.logger.error("Promise handler threw an error, closing session " + error);
                session.close();
                throw e;
            }
        }, function () {
            return reject(new Error("Connection was closed before we successfully pulled a session"));
        });
        return connection.connect().then(function (whatever) { }, function (error) {
            logging_1.logger.error("Failed to connect to Bokeh server " + error);
            throw error;
        });
    });
    promise.close = function () {
        return connection.close();
    };
    return promise;
};

},{"./core/logging":"core/logging","./core/util/object":"core/util/object","./core/util/string":"core/util/string","./document":"document","es6-promise":"es6-promise"}],"core/backbone":[function(require,module,exports){
//     Backbone.js 1.3.3
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
//     (c) 2010-2016 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Backbone may be freely distributed under the MIT license.
//     For all details and documentation:
//     http://backbonejs.org
var events_1 = require("./events");
var eq_1 = require("./util/eq");
var object_1 = require("./util/object");
// Backbone.Model
// --------------
// Backbone **Models** are the basic data object in the framework --
// frequently representing a row in a table in a database on your server.
// A discrete chunk of data and a bunch of useful, related methods for
// performing computations and transformations on that data.
// Create a new model with the specified attributes.
exports.Model = function (attributes, options) {
    var attrs = attributes || {};
    options || (options = {});
    this.attributes = {};
    this.setv(attrs, options);
    this.changed = {};
    this.initialize.apply(this, arguments);
};
// Attach all inheritable methods to the Model prototype.
object_1.extend(exports.Model.prototype, events_1.Events, {
    // A hash of attributes whose current and previous value differ.
    changed: null,
    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function () { },
    // Get the value of an attribute.
    getv: function (attr) {
        return this.attributes[attr];
    },
    // Set a hash of model attributes on the object, firing `"change"`. This is
    // the core primitive operation of a model, updating the data and notifying
    // anyone who needs to know about the change in state. The heart of the beast.
    setv: function (key, val, options) {
        if (key == null)
            return this;
        // Handle both `"key", value` and `{key: value}` -style arguments.
        var attrs;
        if (typeof key === 'object') {
            attrs = key;
            options = val;
        }
        else {
            (attrs = {})[key] = val;
        }
        options || (options = {});
        // Extract attributes and options.
        var silent = options.silent;
        var changes = [];
        var changing = this._changing;
        this._changing = true;
        if (!changing) {
            this._previousAttributes = object_1.clone(this.attributes);
            this.changed = {};
        }
        var current = this.attributes;
        var changed = this.changed;
        var prev = this._previousAttributes;
        // For each `set` attribute, update or delete the current value.
        for (var attr in attrs) {
            val = attrs[attr];
            if (!eq_1.isEqual(current[attr], val))
                changes.push(attr);
            if (!eq_1.isEqual(prev[attr], val)) {
                changed[attr] = val;
            }
            else {
                delete changed[attr];
            }
            current[attr] = val;
        }
        // Trigger all relevant attribute changes.
        if (!silent) {
            if (changes.length)
                this._pending = true;
            for (var i = 0; i < changes.length; i++) {
                this.trigger('change:' + changes[i], this, current[changes[i]]);
            }
        }
        // You might be wondering why there's a `while` loop here. Changes can
        // be recursively nested within `"change"` events.
        if (changing)
            return this;
        if (!silent) {
            while (this._pending) {
                this._pending = false;
                this.trigger('change', this);
            }
        }
        this._pending = false;
        this._changing = false;
        return this;
    },
    destroy: function () {
        this.stopListening();
        this.trigger('destroy', this);
    },
    // Create a new model with identical attributes to this one.
    clone: function () {
        return new this.constructor(this.attributes);
    }
});
// Backbone.View
// -------------
// Backbone Views are almost more convention than they are actual code. A View
// is simply a JavaScript object that represents a logical chunk of UI in the
// DOM. This might be a single item, an entire list, a sidebar or panel, or
// even the surrounding frame which wraps your whole app. Defining a chunk of
// UI as a **View** allows you to define your DOM events declaratively, without
// having to worry about render order ... and makes it easy for the view to
// react to specific changes in the state of your models.
// Creating a Backbone.View creates its initial element outside of the DOM,
// if an existing element is not provided...
exports.View = function (options) {
    options = options || {};
    this.model = options.model;
    this.id = options.id;
    this.el = options.el;
    this._ensureElement();
    this.initialize(options);
};
// Set up all inheritable **Backbone.View** properties and methods.
object_1.extend(exports.View.prototype, events_1.Events, {
    // The default `tagName` of a View's element is `"div"`.
    tagName: 'div',
    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function (options) { },
    // **render** is the core function that your view should override, in order
    // to populate its element (`this.el`), with the appropriate HTML. The
    // convention is for **render** to always return `this`.
    render: function () {
        return this;
    },
    // Remove this view by taking the element out of the DOM, and removing any
    // applicable Backbone.Events listeners.
    remove: function () {
        this._removeElement();
        this.stopListening();
        return this;
    },
    // Remove this view's element from the document and all event listeners
    // attached to it. Exposed for subclasses using an alternative DOM
    // manipulation API.
    _removeElement: function () {
        var parent = this.el.parentNode;
        if (parent != null) {
            parent.removeChild(this.el);
        }
    },
    setElement: function (element) {
        this._setElement(element);
        return this;
    },
    // Creates the `this.el`.
    _setElement: function (el) {
        this.el = el;
    },
    // Produces a DOM element to be assigned to your view. Exposed for
    // subclasses using an alternative DOM manipulation API.
    _createElement: function (tagName) {
        return document.createElement(tagName);
    },
    // Ensure that the View has a DOM element to render into.
    // If `this.el` is a string, pass it through `$()`, take the first
    // matching element, and re-assign it to `el`. Otherwise, create
    // an element from the `id`, `className` and `tagName` properties.
    _ensureElement: function () {
        if (!this.el) {
            this.setElement(this._createElement(this.tagName));
            if (this.id) {
                this.el.setAttribute('id', this.id);
            }
            if (this.className) {
                this.el.setAttribute('class', this.className);
            }
        }
        else {
            this.setElement(this.el);
        }
    }
});
exports.Model.getter = exports.View.getter = function (name, get) {
    Object.defineProperty(this.prototype, name, { get: get });
};
exports.Model.getters = exports.View.getters = function (specs) {
    for (var name in specs) {
        this.getter(name, specs[name]);
    }
};

},{"./events":"core/events","./util/eq":"core/util/eq","./util/object":"core/util/object"}],"core/bokeh_events":[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var logging_1 = require("./logging");
var object_1 = require("./util/object");
var event_classes = {};
function register_event_class(event_name) {
    return function (event_cls) {
        event_cls.prototype.event_name = event_name;
        event_classes[event_name] = event_cls;
    };
}
exports.register_event_class = register_event_class;
function register_with_event(event_cls) {
    var models = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        models[_i - 1] = arguments[_i];
    }
    var applicable_models = event_cls.prototype.applicable_models.concat(models);
    event_cls.prototype.applicable_models = applicable_models;
}
exports.register_with_event = register_with_event;
var BokehEvent = (function () {
    function BokehEvent(options) {
        if (options === void 0) { options = {}; }
        this._options = options;
        if (options.model_id) {
            this.model_id = options.model_id;
        }
    }
    BokehEvent.prototype.set_model_id = function (id) {
        this._options.model_id = id;
        this.model_id = id;
        return this;
    };
    BokehEvent.prototype.is_applicable_to = function (obj) {
        return this.applicable_models.some(function (model) { return obj instanceof model; });
    };
    BokehEvent.event_class = function (e) {
        // Given an event with a type attribute matching the event_name,
        // return the appropriate BokehEvent class
        if (e.type) {
            return event_classes[e.type];
        }
        else {
            logging_1.logger.warn('BokehEvent.event_class required events with a string type attribute');
        }
    };
    BokehEvent.prototype.toJSON = function () {
        return {
            event_name: this.event_name,
            event_values: object_1.clone(this._options),
        };
    };
    BokehEvent.prototype._customize_event = function (model) {
        return this;
    };
    return BokehEvent;
}());
exports.BokehEvent = BokehEvent;
BokehEvent.prototype.applicable_models = [];
var ButtonClick = (function (_super) {
    __extends(ButtonClick, _super);
    function ButtonClick() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return ButtonClick;
}(BokehEvent));
ButtonClick = __decorate([
    register_event_class("button_click")
], ButtonClick);
exports.ButtonClick = ButtonClick;
// A UIEvent is an event originating on a PlotCanvas this includes
// DOM events such as keystrokes as well as hammer events and LOD events.
var UIEvent = (function (_super) {
    __extends(UIEvent, _super);
    function UIEvent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return UIEvent;
}(BokehEvent));
exports.UIEvent = UIEvent;
var LODStart = (function (_super) {
    __extends(LODStart, _super);
    function LODStart() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return LODStart;
}(UIEvent));
LODStart = __decorate([
    register_event_class("lodstart")
], LODStart);
exports.LODStart = LODStart;
var LODEnd = (function (_super) {
    __extends(LODEnd, _super);
    function LODEnd() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return LODEnd;
}(UIEvent));
LODEnd = __decorate([
    register_event_class("lodend")
], LODEnd);
exports.LODEnd = LODEnd;
var PointEvent = (function (_super) {
    __extends(PointEvent, _super);
    function PointEvent(options) {
        var _this = _super.call(this, options) || this;
        _this.sx = options.sx;
        _this.sy = options.sy;
        _this.x = null;
        _this.y = null;
        return _this;
    }
    PointEvent.from_event = function (e, model_id) {
        if (model_id === void 0) { model_id = null; }
        return new this({ sx: e.bokeh['sx'], sy: e.bokeh['sy'], model_id: model_id });
    };
    PointEvent.prototype._customize_event = function (plot) {
        var xmapper = plot.plot_canvas.frame.x_mappers['default'];
        var ymapper = plot.plot_canvas.frame.y_mappers['default'];
        this.x = xmapper.map_from_target(plot.plot_canvas.canvas.sx_to_vx(this.sx));
        this.y = ymapper.map_from_target(plot.plot_canvas.canvas.sy_to_vy(this.sy));
        this._options['x'] = this.x;
        this._options['y'] = this.y;
        return this;
    };
    return PointEvent;
}(UIEvent));
exports.PointEvent = PointEvent;
var Pan = (function (_super) {
    __extends(Pan, _super);
    function Pan(options) {
        if (options === void 0) { options = {}; }
        var _this = _super.call(this, options) || this;
        _this.delta_x = options.delta_x;
        _this.delta_y = options.delta_y;
        return _this;
    }
    Pan.from_event = function (e, model_id) {
        if (model_id === void 0) { model_id = null; }
        return new this({
            sx: e.bokeh['sx'],
            sy: e.bokeh['sy'],
            delta_x: e.deltaX,
            delta_y: e.deltaY,
            direction: e.direction,
            model_id: model_id
        });
    };
    return Pan;
}(PointEvent));
Pan = __decorate([
    register_event_class("pan")
], Pan);
exports.Pan = Pan;
var Pinch = (function (_super) {
    __extends(Pinch, _super);
    function Pinch(options) {
        if (options === void 0) { options = {}; }
        var _this = _super.call(this, options) || this;
        _this.scale = options.scale;
        return _this;
    }
    Pinch.from_event = function (e, model_id) {
        if (model_id === void 0) { model_id = null; }
        return new this({
            sx: e.bokeh['sx'],
            sy: e.bokeh['sy'],
            scale: e.scale,
            model_id: model_id,
        });
    };
    return Pinch;
}(PointEvent));
Pinch = __decorate([
    register_event_class("pinch")
], Pinch);
exports.Pinch = Pinch;
var MouseWheel = (function (_super) {
    __extends(MouseWheel, _super);
    function MouseWheel(options) {
        if (options === void 0) { options = {}; }
        var _this = _super.call(this, options) || this;
        _this.delta = options.delta;
        return _this;
    }
    MouseWheel.from_event = function (e, model_id) {
        if (model_id === void 0) { model_id = null; }
        return new this({
            sx: e.bokeh['sx'],
            sy: e.bokeh['sy'],
            delta: e.delta,
            model_id: model_id,
        });
    };
    return MouseWheel;
}(PointEvent));
MouseWheel = __decorate([
    register_event_class("wheel")
], MouseWheel);
exports.MouseWheel = MouseWheel;
var MouseMove = (function (_super) {
    __extends(MouseMove, _super);
    function MouseMove() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return MouseMove;
}(PointEvent));
MouseMove = __decorate([
    register_event_class("mousemove")
], MouseMove);
exports.MouseMove = MouseMove;
var MouseEnter = (function (_super) {
    __extends(MouseEnter, _super);
    function MouseEnter() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return MouseEnter;
}(PointEvent));
MouseEnter = __decorate([
    register_event_class("mouseenter")
], MouseEnter);
exports.MouseEnter = MouseEnter;
var MouseLeave = (function (_super) {
    __extends(MouseLeave, _super);
    function MouseLeave() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return MouseLeave;
}(PointEvent));
MouseLeave = __decorate([
    register_event_class("mouseleave")
], MouseLeave);
exports.MouseLeave = MouseLeave;
var Tap = (function (_super) {
    __extends(Tap, _super);
    function Tap() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return Tap;
}(PointEvent));
Tap = __decorate([
    register_event_class("tap")
], Tap);
exports.Tap = Tap;
var DoubleTap = (function (_super) {
    __extends(DoubleTap, _super);
    function DoubleTap() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return DoubleTap;
}(PointEvent));
DoubleTap = __decorate([
    register_event_class("doubletap")
], DoubleTap);
exports.DoubleTap = DoubleTap;
var Press = (function (_super) {
    __extends(Press, _super);
    function Press() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return Press;
}(PointEvent));
Press = __decorate([
    register_event_class("press")
], Press);
exports.Press = Press;
var PanStart = (function (_super) {
    __extends(PanStart, _super);
    function PanStart() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return PanStart;
}(PointEvent));
PanStart = __decorate([
    register_event_class("panstart")
], PanStart);
exports.PanStart = PanStart;
var PanEnd = (function (_super) {
    __extends(PanEnd, _super);
    function PanEnd() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return PanEnd;
}(PointEvent));
PanEnd = __decorate([
    register_event_class("panend")
], PanEnd);
exports.PanEnd = PanEnd;
var PinchStart = (function (_super) {
    __extends(PinchStart, _super);
    function PinchStart() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return PinchStart;
}(PointEvent));
PinchStart = __decorate([
    register_event_class("pinchstart")
], PinchStart);
exports.PinchStart = PinchStart;
var PinchEnd = (function (_super) {
    __extends(PinchEnd, _super);
    function PinchEnd() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return PinchEnd;
}(PointEvent));
PinchEnd = __decorate([
    register_event_class("pinchend")
], PinchEnd);
exports.PinchEnd = PinchEnd;

},{"./logging":"core/logging","./util/object":"core/util/object"}],"core/bokeh_view":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var Backbone = require("./backbone");
var string_1 = require("./util/string");
exports.BokehView = (function (superClass) {
    extend(BokehView, superClass);
    function BokehView() {
        return BokehView.__super__.constructor.apply(this, arguments);
    }
    BokehView.prototype.initialize = function (options) {
        if (options.id == null) {
            return this.id = string_1.uniqueId('BokehView');
        }
    };
    BokehView.prototype.toString = function () {
        return this.model.type + "View(" + this.id + ")";
    };
    BokehView.prototype.bind_bokeh_events = function () { };
    BokehView.prototype.remove = function () {
        this.trigger('remove', this);
        return BokehView.__super__.remove.call(this);
    };
    return BokehView;
})(Backbone.View);

},{"./backbone":"core/backbone","./util/string":"core/util/string"}],"core/build_views":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var array_1 = require("./util/array");
var object_1 = require("./util/object");
exports.build_views = function (view_storage, view_models, options, view_types) {
    var cls, created_views, i, i_model, j, key, len, len1, model, newmodels, ref, to_remove, view, view_options;
    if (view_types == null) {
        view_types = [];
    }
    created_views = [];
    newmodels = view_models.filter(function (x) {
        return view_storage[x.id] == null;
    });
    for (i_model = i = 0, len = newmodels.length; i < len; i_model = ++i) {
        model = newmodels[i_model];
        cls = (ref = view_types[i_model]) != null ? ref : model.default_view;
        view_options = object_1.extend({
            model: model
        }, options);
        view_storage[model.id] = view = new cls(view_options);
        created_views.push(view);
    }
    to_remove = array_1.difference(Object.keys(view_storage), (function () {
        var j, len1, results;
        results = [];
        for (j = 0, len1 = view_models.length; j < len1; j++) {
            view = view_models[j];
            results.push(view.id);
        }
        return results;
    })());
    for (j = 0, len1 = to_remove.length; j < len1; j++) {
        key = to_remove[j];
        view_storage[key].remove();
        delete view_storage[key];
    }
    return created_views;
};

},{"./util/array":"core/util/array","./util/object":"core/util/object"}],"core/dom":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var types_1 = require("./util/types");
var _createElement = function (tag) { return function (attrs) {
    if (attrs === void 0) { attrs = {}; }
    var children = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        children[_i - 1] = arguments[_i];
    }
    var element;
    if (tag === "fragment") {
        // XXX: this is wrong, but the the common super type of DocumentFragment and HTMLElement is
        // Node, which doesn't support classList, style, etc. attributes.
        element = document.createDocumentFragment();
    }
    else {
        element = document.createElement(tag);
        for (var attr in attrs) {
            var value = attrs[attr];
            if (value == null || types_1.isBoolean(value) && !value)
                continue;
            if (attr === "class" && types_1.isArray(value)) {
                for (var _a = 0, _b = value; _a < _b.length; _a++) {
                    var cls = _b[_a];
                    if (cls != null)
                        element.classList.add(cls);
                }
                continue;
            }
            if (attr === "style" && types_1.isObject(value)) {
                for (var prop in value) {
                    element.style[prop] = value[prop];
                }
                continue;
            }
            element.setAttribute(attr, value);
        }
    }
    function append(child) {
        if (child instanceof HTMLElement)
            element.appendChild(child);
        else if (types_1.isString(child))
            element.appendChild(document.createTextNode(child));
        else if (child != null && child !== false)
            throw new Error("expected an HTMLElement, string, false or null, got " + JSON.stringify(child));
    }
    for (var _c = 0, children_1 = children; _c < children_1.length; _c++) {
        var child = children_1[_c];
        if (types_1.isArray(child)) {
            for (var _d = 0, child_1 = child; _d < child_1.length; _d++) {
                var _child = child_1[_d];
                append(_child);
            }
        }
        else
            append(child);
    }
    return element;
}; };
function createElement(tag, attrs) {
    var children = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        children[_i - 2] = arguments[_i];
    }
    return _createElement(tag).apply(void 0, [attrs].concat(children));
}
exports.createElement = createElement;
exports.div = _createElement("div"), exports.span = _createElement("span"), exports.link = _createElement("link"), exports.style = _createElement("style"), exports.a = _createElement("a"), exports.p = _createElement("p"), exports.pre = _createElement("pre"), exports.input = _createElement("input"), exports.label = _createElement("label"), exports.canvas = _createElement("canvas"), exports.ul = _createElement("ul"), exports.ol = _createElement("ol"), exports.li = _createElement("li");
function show(element) {
    element.style.display = "";
}
exports.show = show;
function hide(element) {
    element.style.display = "none";
}
exports.hide = hide;
function empty(element) {
    var child;
    while (child = element.firstChild) {
        element.removeChild(child);
    }
}
exports.empty = empty;
function position(element) {
    return {
        top: element.offsetTop,
        left: element.offsetLeft,
    };
}
exports.position = position;
function offset(element) {
    var rect = element.getBoundingClientRect();
    return {
        top: rect.top + window.pageYOffset - document.documentElement.clientTop,
        left: rect.left + window.pageXOffset - document.documentElement.clientLeft,
    };
}
exports.offset = offset;
function replaceWith(element, replacement) {
    var parent = element.parentNode;
    if (parent != null) {
        parent.replaceChild(replacement, element);
    }
}
exports.replaceWith = replaceWith;

},{"./util/types":"core/util/types"}],"core/enums":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AngleUnits = ["deg", "rad"];
exports.Dimension = ["width", "height"];
exports.Dimensions = ["width", "height", "both"];
exports.Direction = ["clock", "anticlock"];
exports.FontStyle = ["normal", "italic", "bold"];
exports.LatLon = ["lat", "lon"];
exports.LineCap = ["butt", "round", "square"];
exports.LineJoin = ["miter", "round", "bevel"];
exports.Location = ["above", "below", "left", "right"];
exports.LegendLocation = ["top_left", "top_center", "top_right", "center_left", "center", "center_right", "bottom_left", "bottom_center", "bottom_right"];
exports.Orientation = ["vertical", "horizontal"];
exports.RenderLevel = ["image", "underlay", "glyph", "annotation", "overlay"];
exports.RenderMode = ["canvas", "css"];
exports.Side = ["left", "right"];
exports.SpatialUnits = ["screen", "data"];
exports.StartEnd = ["start", "end"];
exports.TextAlign = ["left", "right", "center"];
exports.TextBaseline = ["top", "middle", "bottom", "alphabetic", "hanging", "ideographic"];
exports.DistributionTypes = ["uniform", "normal"];
exports.TransformStepModes = ["after", "before", "center"];
exports.SizingMode = ["stretch_both", "scale_width", "scale_height", "scale_both", "fixed"];

},{}],"core/events":[function(require,module,exports){
//     Backbone.js 1.3.3
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
//     (c) 2010-2016 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Backbone may be freely distributed under the MIT license.
//     For all details and documentation:
//     http://backbonejs.org
var string_1 = require("./util/string");
var callback_1 = require("./util/callback");
// Backbone.Events
// ---------------
// A module that can be mixed in to *any object* in order to provide it with
// a custom event channel. You may bind a callback to an event with `on` or
// remove with `off`; `trigger`-ing an event fires all callbacks in
// succession.
//
//     var object = {};
//     extend(object, Backbone.Events);
//     object.on('expand', function(){ alert('expanded'); });
//     object.trigger('expand');
//
exports.Events = {};
// Regular expression used to split event strings.
var eventSplitter = /\s+/;
// Iterates over the standard `event, callback` (as well as the fancy multiple
// space-separated events `"change blur", callback` and jQuery-style event
// maps `{event: callback}`).
var eventsApi = function (iteratee, events, name, callback, opts) {
    var i = 0, names;
    if (name && typeof name === 'object') {
        // Handle event maps.
        if (callback !== void 0 && 'context' in opts && opts.context === void 0)
            opts.context = callback;
        for (names = Object.keys(name); i < names.length; i++) {
            events = eventsApi(iteratee, events, names[i], name[names[i]], opts);
        }
    }
    else if (name && eventSplitter.test(name)) {
        // Handle space-separated event names by delegating them individually.
        for (names = name.split(eventSplitter); i < names.length; i++) {
            events = iteratee(events, names[i], callback, opts);
        }
    }
    else {
        // Finally, standard events.
        events = iteratee(events, name, callback, opts);
    }
    return events;
};
// Bind an event to a `callback` function. Passing `"all"` will bind
// the callback to all events fired.
exports.Events.on = function (name, callback, context) {
    return internalOn(this, name, callback, context);
};
// Guard the `listening` argument from the public API.
var internalOn = function (obj, name, callback, context, listening) {
    obj._events = eventsApi(onApi, obj._events || {}, name, callback, {
        context: context,
        ctx: obj,
        listening: listening
    });
    if (listening) {
        var listeners = obj._listeners || (obj._listeners = {});
        listeners[listening.id] = listening;
    }
    return obj;
};
// Inversion-of-control versions of `on`. Tell *this* object to listen to
// an event in another object... keeping track of what it's listening to
// for easier unbinding later.
exports.Events.listenTo = function (obj, name, callback) {
    if (!obj)
        return this;
    var id = obj._listenId || (obj._listenId = string_1.uniqueId('l'));
    var listeningTo = this._listeningTo || (this._listeningTo = {});
    var listening = listeningTo[id];
    // This object is not listening to any other events on `obj` yet.
    // Setup the necessary references to track the listening callbacks.
    if (!listening) {
        var thisId = this._listenId || (this._listenId = string_1.uniqueId('l'));
        listening = listeningTo[id] = { obj: obj, objId: id, id: thisId, listeningTo: listeningTo, count: 0 };
    }
    // Bind callbacks on obj, and keep track of them on listening.
    internalOn(obj, name, callback, this, listening);
    return this;
};
// The reducing API that adds a callback to the `events` object.
var onApi = function (events, name, callback, options) {
    if (callback) {
        var handlers = events[name] || (events[name] = []);
        var context = options.context, ctx = options.ctx, listening = options.listening;
        if (listening)
            listening.count++;
        handlers.push({ callback: callback, context: context, ctx: context || ctx, listening: listening });
    }
    return events;
};
// Remove one or many callbacks. If `context` is null, removes all
// callbacks with that function. If `callback` is null, removes all
// callbacks for the event. If `name` is null, removes all bound
// callbacks for all events.
exports.Events.off = function (name, callback, context) {
    if (!this._events)
        return this;
    this._events = eventsApi(offApi, this._events, name, callback, {
        context: context,
        listeners: this._listeners
    });
    return this;
};
// Tell this object to stop listening to either specific events ... or
// to every object it's currently listening to.
exports.Events.stopListening = function (obj, name, callback) {
    var listeningTo = this._listeningTo;
    if (!listeningTo)
        return this;
    var ids = obj ? [obj._listenId] : Object.keys(listeningTo);
    for (var i = 0; i < ids.length; i++) {
        var listening = listeningTo[ids[i]];
        // If listening doesn't exist, this object is not currently
        // listening to obj. Break out early.
        if (!listening)
            break;
        listening.obj.off(name, callback, this);
    }
    return this;
};
// The reducing API that removes a callback from the `events` object.
var offApi = function (events, name, callback, options) {
    if (!events)
        return;
    var i = 0, listening;
    var context = options.context, listeners = options.listeners;
    // Delete all events listeners and "drop" events.
    if (!name && !callback && !context) {
        var ids = Object.keys(listeners);
        for (; i < ids.length; i++) {
            listening = listeners[ids[i]];
            delete listeners[listening.id];
            delete listening.listeningTo[listening.objId];
        }
        return;
    }
    var names = name ? [name] : Object.keys(events);
    for (; i < names.length; i++) {
        name = names[i];
        var handlers = events[name];
        // Bail out if there are no events stored.
        if (!handlers)
            break;
        // Replace events if there are any remaining.  Otherwise, clean up.
        var remaining = [];
        for (var j = 0; j < handlers.length; j++) {
            var handler = handlers[j];
            if (callback && callback !== handler.callback &&
                callback !== handler.callback._callback ||
                context && context !== handler.context) {
                remaining.push(handler);
            }
            else {
                listening = handler.listening;
                if (listening && --listening.count === 0) {
                    delete listeners[listening.id];
                    delete listening.listeningTo[listening.objId];
                }
            }
        }
        // Update tail event if the list has any events.  Otherwise, clean up.
        if (remaining.length) {
            events[name] = remaining;
        }
        else {
            delete events[name];
        }
    }
    return events;
};
// Bind an event to only be triggered a single time. After the first time
// the callback is invoked, its listener will be removed. If multiple events
// are passed in using the space-separated syntax, the handler will fire
// once for each event, not once for a combination of all events.
exports.Events.once = function (name, callback, context) {
    // Map the event into a `{event: once}` object.
    var events = eventsApi(onceMap, {}, name, callback, this.off.bind(this));
    if (typeof name === 'string' && context == null)
        callback = void 0;
    return this.on(events, callback, context);
};
// Inversion-of-control versions of `once`.
exports.Events.listenToOnce = function (obj, name, callback) {
    // Map the event into a `{event: once}` object.
    var events = eventsApi(onceMap, {}, name, callback, this.stopListening.bind(this, obj));
    return this.listenTo(obj, events);
};
// Reduces the event callbacks into a map of `{event: onceWrapper}`.
// `offer` unbinds the `onceWrapper` after it has been called.
var onceMap = function (map, name, callback, offer) {
    if (callback) {
        var fn = map[name] = callback_1.once(function () {
            offer(name, fn);
            callback.apply(this, arguments);
        });
        fn._callback = callback;
    }
    return map;
};
// Trigger one or many events, firing all bound callbacks. Callbacks are
// passed the same arguments as `trigger` is, apart from the event name
// (unless you're listening on `"all"`, which will cause your callback to
// receive the true name of the event as the first argument).
exports.Events.trigger = function (name) {
    if (!this._events)
        return this;
    var length = Math.max(0, arguments.length - 1);
    var args = Array(length);
    for (var i = 0; i < length; i++)
        args[i] = arguments[i + 1];
    eventsApi(triggerApi, this._events, name, void 0, args);
    return this;
};
// Handles triggering the appropriate event callbacks.
var triggerApi = function (objEvents, name, callback, args) {
    if (objEvents) {
        var events = objEvents[name];
        var allEvents = objEvents.all;
        if (events && allEvents)
            allEvents = allEvents.slice();
        if (events)
            triggerEvents(events, args);
        if (allEvents)
            triggerEvents(allEvents, [name].concat(args));
    }
    return objEvents;
};
// A difficult-to-believe, but optimized internal dispatch function for
// triggering events. Tries to keep the usual cases speedy (most internal
// Backbone events have 3 arguments).
var triggerEvents = function (events, args) {
    var ev, i = -1, l = events.length, a1 = args[0], a2 = args[1], a3 = args[2];
    switch (args.length) {
        case 0:
            while (++i < l)
                (ev = events[i]).callback.call(ev.ctx);
            return;
        case 1:
            while (++i < l)
                (ev = events[i]).callback.call(ev.ctx, a1);
            return;
        case 2:
            while (++i < l)
                (ev = events[i]).callback.call(ev.ctx, a1, a2);
            return;
        case 3:
            while (++i < l)
                (ev = events[i]).callback.call(ev.ctx, a1, a2, a3);
            return;
        default:
            while (++i < l)
                (ev = events[i]).callback.apply(ev.ctx, args);
            return;
    }
};

},{"./util/callback":"core/util/callback","./util/string":"core/util/string"}],"core/has_props":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend1 = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, slice = [].slice;
var Backbone = require("./backbone");
var logging_1 = require("./logging");
var property_mixins = require("./property_mixins");
var refs = require("./util/refs");
var p = require("./properties");
var string_1 = require("./util/string");
var array_1 = require("./util/array");
var object_1 = require("./util/object");
var types_1 = require("./util/types");
exports.HasProps = (function (superClass) {
    extend1(HasProps, superClass);
    HasProps.prototype.props = {};
    HasProps.prototype.mixins = [];
    HasProps.define = function (object) {
        var name, prop, results;
        results = [];
        for (name in object) {
            prop = object[name];
            results.push((function (_this) {
                return function (name, prop) {
                    var default_value, internal, props, refined_prop, type;
                    if (_this.prototype.props[name] != null) {
                        throw new Error("attempted to redefine property '" + _this.name + "." + name + "'");
                    }
                    if (_this.prototype[name] != null) {
                        throw new Error("attempted to redefine attribute '" + _this.name + "." + name + "'");
                    }
                    Object.defineProperty(_this.prototype, name, {
                        get: function () {
                            var value;
                            value = this.getv(name);
                            return value;
                        },
                        set: function (value) {
                            this.setv(name, value);
                            return this;
                        }
                    }, {
                        configurable: false,
                        enumerable: true
                    });
                    type = prop[0], default_value = prop[1], internal = prop[2];
                    refined_prop = {
                        type: type,
                        default_value: default_value,
                        internal: internal != null ? internal : false
                    };
                    props = object_1.clone(_this.prototype.props);
                    props[name] = refined_prop;
                    return _this.prototype.props = props;
                };
            })(this)(name, prop));
        }
        return results;
    };
    HasProps.internal = function (object) {
        var _object, fn, name, prop;
        _object = {};
        fn = (function (_this) {
            return function (name, prop) {
                var default_value, type;
                type = prop[0], default_value = prop[1];
                return _object[name] = [type, default_value, true];
            };
        })(this);
        for (name in object) {
            prop = object[name];
            fn(name, prop);
        }
        return this.define(_object);
    };
    HasProps.mixin = function () {
        var mixins, names;
        names = 1 <= arguments.length ? slice.call(arguments, 0) : [];
        this.define(property_mixins.create(names));
        mixins = this.prototype.mixins.concat(names);
        return this.prototype.mixins = mixins;
    };
    HasProps.mixins = function (names) {
        return this.mixin.apply(this, names);
    };
    HasProps.override = function (name_or_object, default_value) {
        var name, object, results;
        if (types_1.isString(name_or_object)) {
            object = {};
            object[name] = default_value;
        }
        else {
            object = name_or_object;
        }
        results = [];
        for (name in object) {
            default_value = object[name];
            results.push((function (_this) {
                return function (name, default_value) {
                    var props, value;
                    value = _this.prototype.props[name];
                    if (value == null) {
                        throw new Error("attempted to override nonexistent '" + _this.name + "." + name + "'");
                    }
                    props = object_1.clone(_this.prototype.props);
                    props[name] = object_1.extend({}, value, {
                        default_value: default_value
                    });
                    return _this.prototype.props = props;
                };
            })(this)(name, default_value));
        }
        return results;
    };
    HasProps.define({
        id: [p.Any]
    });
    HasProps.prototype.toString = function () {
        return this.type + "(" + this.id + ")";
    };
    function HasProps(attributes, options) {
        var attrs, default_value, name, ref, ref1, type;
        this.document = null;
        attrs = attributes || {};
        if (!options) {
            options = {};
        }
        this.attributes = {};
        this.properties = {};
        ref = this.props;
        for (name in ref) {
            ref1 = ref[name], type = ref1.type, default_value = ref1.default_value;
            if (type == null) {
                throw new Error("undefined property type for " + this.type + "." + name);
            }
            this.properties[name] = new type({
                obj: this,
                attr: name,
                default_value: default_value
            });
        }
        this._set_after_defaults = {};
        this.setv(attrs, options);
        this.changed = {};
        this._computed = {};
        if (attrs.id == null) {
            this.id = string_1.uniqueId(this.type);
        }
        if (!options.defer_initialization) {
            this.initialize.apply(this, arguments);
        }
    }
    HasProps.prototype.initialize = function (options) {
        var name, prop, ref, results;
        ref = this.properties;
        results = [];
        for (name in ref) {
            prop = ref[name];
            prop.update();
            if (prop.spec.transform) {
                results.push(this.listenTo(prop.spec.transform, "change", function () {
                    return this.trigger('transformchange', this);
                }));
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    HasProps.prototype.setv = function (key, value, options) {
        var attrs, old, prop_name, results, val;
        if (types_1.isObject(key) || key === null) {
            attrs = key;
            options = value;
        }
        else {
            attrs = {};
            attrs[key] = value;
        }
        for (key in attrs) {
            if (!hasProp.call(attrs, key))
                continue;
            val = attrs[key];
            prop_name = key;
            if (this.props[prop_name] == null) {
                throw new Error("property " + this.type + "." + prop_name + " wasn't declared");
            }
            if (!((options != null) && options.defaults)) {
                this._set_after_defaults[key] = true;
            }
        }
        if (!object_1.isEmpty(attrs)) {
            old = {};
            for (key in attrs) {
                value = attrs[key];
                old[key] = this.getv(key);
            }
            HasProps.__super__.setv.call(this, attrs, options);
            if ((options != null ? options.silent : void 0) == null) {
                results = [];
                for (key in attrs) {
                    value = attrs[key];
                    results.push(this._tell_document_about_change(key, old[key], this.getv(key), options));
                }
                return results;
            }
        }
    };
    HasProps.prototype.add_dependencies = function (prop_name, object, fields) {
        var fld, j, len, prop_spec, results;
        if (!types_1.isArray(fields)) {
            fields = [fields];
        }
        prop_spec = this._computed[prop_name];
        prop_spec.dependencies = prop_spec.dependencies.concat({
            obj: object,
            fields: fields
        });
        results = [];
        for (j = 0, len = fields.length; j < len; j++) {
            fld = fields[j];
            results.push(this.listenTo(object, "change:" + fld, prop_spec['callbacks']['changedep']));
        }
        return results;
    };
    HasProps.prototype.define_computed_property = function (prop_name, getter, use_cache) {
        var changedep, prop_spec, propchange;
        if (use_cache == null) {
            use_cache = true;
        }
        if (this.props[prop_name] != null) {
            console.log("attempted to redefine existing property " + this.type + "." + prop_name);
        }
        if (this._computed[prop_name] != null) {
            throw new Error("attempted to redefine existing computed property " + this.type + "." + prop_name);
        }
        changedep = (function (_this) {
            return function () {
                return _this.trigger('changedep:' + prop_name);
            };
        })(this);
        propchange = (function (_this) {
            return function () {
                var firechange, new_val, old_val;
                firechange = true;
                if (prop_spec['use_cache']) {
                    old_val = prop_spec.cache;
                    prop_spec.cache = void 0;
                    new_val = _this._get_computed(prop_name);
                    firechange = new_val !== old_val;
                }
                if (firechange) {
                    _this.trigger('change:' + prop_name, _this, _this._get_computed(prop_name));
                    return _this.trigger('change', _this);
                }
            };
        })(this);
        prop_spec = {
            'getter': getter,
            'dependencies': [],
            'use_cache': use_cache,
            'callbacks': {
                changedep: changedep,
                propchange: propchange
            }
        };
        this._computed[prop_name] = prop_spec;
        this.listenTo(this, "changedep:" + prop_name, prop_spec['callbacks']['propchange']);
        return prop_spec;
    };
    HasProps.prototype.set = function (key, value, options) {
        logging_1.logger.warn("HasProps.set('prop_name', value) is deprecated, use HasProps.prop_name = value instead");
        return this.setv(key, value, options);
    };
    HasProps.prototype.get = function (prop_name) {
        logging_1.logger.warn("HasProps.get('prop_name') is deprecated, use HasProps.prop_name instead");
        return this.getv(prop_name);
    };
    HasProps.prototype.getv = function (prop_name) {
        if (this.props[prop_name] == null) {
            throw new Error("property " + this.type + "." + prop_name + " wasn't declared");
        }
        else {
            return HasProps.__super__.getv.call(this, prop_name);
        }
    };
    HasProps.prototype._get_computed = function (prop_name) {
        var computed, getter, prop_spec;
        prop_spec = this._computed[prop_name];
        if (prop_spec == null) {
            throw new Error("computed property " + this.type + "." + prop_name + " wasn't declared");
        }
        if (prop_spec.use_cache && prop_spec.cache) {
            return prop_spec.cache;
        }
        else {
            getter = prop_spec.getter;
            computed = getter.apply(this, [prop_name]);
            if (prop_spec.use_cache) {
                prop_spec.cache = computed;
            }
            return computed;
        }
    };
    HasProps.prototype.ref = function () {
        return refs.create_ref(this);
    };
    HasProps.prototype.set_subtype = function (subtype) {
        return this._subtype = subtype;
    };
    HasProps.prototype.attribute_is_serializable = function (attr) {
        var prop;
        prop = this.props[attr];
        if (prop == null) {
            throw new Error(this.type + ".attribute_is_serializable('" + attr + "'): " + attr + " wasn't declared");
        }
        else {
            return !prop.internal;
        }
    };
    HasProps.prototype.serializable_attributes = function () {
        var attrs, name, ref, value;
        attrs = {};
        ref = this.attributes;
        for (name in ref) {
            value = ref[name];
            if (this.attribute_is_serializable(name)) {
                attrs[name] = value;
            }
        }
        return attrs;
    };
    HasProps._value_to_json = function (key, value, optional_parent_object) {
        var i, j, len, ref_array, ref_obj, subkey, v;
        if (value instanceof HasProps) {
            return value.ref();
        }
        else if (types_1.isArray(value)) {
            ref_array = [];
            for (i = j = 0, len = value.length; j < len; i = ++j) {
                v = value[i];
                ref_array.push(HasProps._value_to_json(i, v, value));
            }
            return ref_array;
        }
        else if (types_1.isObject(value)) {
            ref_obj = {};
            for (subkey in value) {
                if (!hasProp.call(value, subkey))
                    continue;
                ref_obj[subkey] = HasProps._value_to_json(subkey, value[subkey], value);
            }
            return ref_obj;
        }
        else {
            return value;
        }
    };
    HasProps.prototype.attributes_as_json = function (include_defaults, value_to_json) {
        var attrs, key, ref, value;
        if (include_defaults == null) {
            include_defaults = true;
        }
        if (value_to_json == null) {
            value_to_json = HasProps._value_to_json;
        }
        attrs = {};
        ref = this.serializable_attributes();
        for (key in ref) {
            if (!hasProp.call(ref, key))
                continue;
            value = ref[key];
            if (include_defaults) {
                attrs[key] = value;
            }
            else if (key in this._set_after_defaults) {
                attrs[key] = value;
            }
        }
        return value_to_json("attributes", attrs, this);
    };
    HasProps._json_record_references = function (doc, v, result, recurse) {
        var elem, j, k, len, model, results, results1;
        if (v == null) {
        }
        else if (refs.is_ref(v)) {
            if (!(v.id in result)) {
                model = doc.get_model_by_id(v.id);
                return HasProps._value_record_references(model, result, recurse);
            }
        }
        else if (types_1.isArray(v)) {
            results = [];
            for (j = 0, len = v.length; j < len; j++) {
                elem = v[j];
                results.push(HasProps._json_record_references(doc, elem, result, recurse));
            }
            return results;
        }
        else if (types_1.isObject(v)) {
            results1 = [];
            for (k in v) {
                if (!hasProp.call(v, k))
                    continue;
                elem = v[k];
                results1.push(HasProps._json_record_references(doc, elem, result, recurse));
            }
            return results1;
        }
    };
    HasProps._value_record_references = function (v, result, recurse) {
        var elem, immediate, j, k, l, len, len1, obj, results, results1, results2;
        if (v == null) {
        }
        else if (v instanceof HasProps) {
            if (!(v.id in result)) {
                result[v.id] = v;
                if (recurse) {
                    immediate = v._immediate_references();
                    results = [];
                    for (j = 0, len = immediate.length; j < len; j++) {
                        obj = immediate[j];
                        results.push(HasProps._value_record_references(obj, result, true));
                    }
                    return results;
                }
            }
        }
        else if (v.buffer instanceof ArrayBuffer) {
        }
        else if (types_1.isArray(v)) {
            results1 = [];
            for (l = 0, len1 = v.length; l < len1; l++) {
                elem = v[l];
                results1.push(HasProps._value_record_references(elem, result, recurse));
            }
            return results1;
        }
        else if (types_1.isObject(v)) {
            results2 = [];
            for (k in v) {
                if (!hasProp.call(v, k))
                    continue;
                elem = v[k];
                results2.push(HasProps._value_record_references(elem, result, recurse));
            }
            return results2;
        }
    };
    HasProps.prototype._immediate_references = function () {
        var attrs, key, result, value;
        result = {};
        attrs = this.serializable_attributes();
        for (key in attrs) {
            value = attrs[key];
            HasProps._value_record_references(value, result, false);
        }
        return object_1.values(result);
    };
    HasProps.prototype.references = function () {
        var references;
        references = {};
        HasProps._value_record_references(this, references, true);
        return object_1.values(references);
    };
    HasProps.prototype.attach_document = function (doc) {
        if (this.document !== null && this.document !== doc) {
            throw new Error("models must be owned by only a single document");
        }
        this.document = doc;
        if (this._doc_attached != null) {
            return this._doc_attached();
        }
    };
    HasProps.prototype.detach_document = function () {
        return this.document = null;
    };
    HasProps.prototype._tell_document_about_change = function (attr, old, new_, options) {
        var need_invalidate, new_id, new_ref, new_refs, old_id, old_ref, old_refs;
        if (!this.attribute_is_serializable(attr)) {
            return;
        }
        if (this.document !== null) {
            new_refs = {};
            HasProps._value_record_references(new_, new_refs, false);
            old_refs = {};
            HasProps._value_record_references(old, old_refs, false);
            need_invalidate = false;
            for (new_id in new_refs) {
                new_ref = new_refs[new_id];
                if (!(new_id in old_refs)) {
                    need_invalidate = true;
                    break;
                }
            }
            if (!need_invalidate) {
                for (old_id in old_refs) {
                    old_ref = old_refs[old_id];
                    if (!(old_id in new_refs)) {
                        need_invalidate = true;
                        break;
                    }
                }
            }
            if (need_invalidate) {
                this.document._invalidate_all_models();
            }
            return this.document._notify_change(this, attr, old, new_, options);
        }
    };
    HasProps.prototype.materialize_dataspecs = function (source) {
        var data, name, prop, ref;
        data = {};
        ref = this.properties;
        for (name in ref) {
            prop = ref[name];
            if (!prop.dataspec) {
                continue;
            }
            if ((prop.optional || false) && prop.spec.value === null && (!(name in this._set_after_defaults))) {
                continue;
            }
            data["_" + name] = prop.array(source);
            if ((prop.spec.field != null) && prop.spec.field in source._shapes) {
                data["_" + name + "_shape"] = source._shapes[prop.spec.field];
            }
            if (prop instanceof p.Distance) {
                data["max_" + name] = array_1.max(data["_" + name]);
            }
        }
        return data;
    };
    return HasProps;
})(Backbone.Model);

},{"./backbone":"core/backbone","./logging":"core/logging","./properties":"core/properties","./property_mixins":"core/property_mixins","./util/array":"core/util/array","./util/object":"core/util/object","./util/refs":"core/util/refs","./util/string":"core/util/string","./util/types":"core/util/types"}],"core/hittest":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var dist_to_segment_squared, nullreturner, sqr;
var array_1 = require("./util/array");
exports.point_in_poly = function (x, y, px, py) {
    var i, inside, j, ref, x1, x2, y1, y2;
    inside = false;
    x1 = px[px.length - 1];
    y1 = py[py.length - 1];
    for (i = j = 0, ref = px.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        x2 = px[i];
        y2 = py[i];
        if ((y1 < y) !== (y2 < y)) {
            if (x1 + (y - y1) / (y2 - y1) * (x2 - x1) < x) {
                inside = !inside;
            }
        }
        x1 = x2;
        y1 = y2;
    }
    return inside;
};
nullreturner = function () {
    return null;
};
exports.HitTestResult = (function () {
    function HitTestResult() {
        this['0d'] = {
            glyph: null,
            get_view: nullreturner,
            indices: []
        };
        this['1d'] = {
            indices: []
        };
        this['2d'] = {
            indices: {}
        };
    }
    Object.defineProperty(HitTestResult.prototype, '_0d', {
        get: function () {
            return this['0d'];
        }
    });
    Object.defineProperty(HitTestResult.prototype, '_1d', {
        get: function () {
            return this['1d'];
        }
    });
    Object.defineProperty(HitTestResult.prototype, '_2d', {
        get: function () {
            return this['2d'];
        }
    });
    HitTestResult.prototype.is_empty = function () {
        return this._0d.indices.length === 0 && this._1d.indices.length === 0;
    };
    return HitTestResult;
})();
exports.create_hit_test_result = function () {
    return new exports.HitTestResult();
};
exports.create_1d_hit_test_result = function (hits) {
    var _dist, i, result;
    result = new exports.HitTestResult();
    result['1d'].indices = (function () {
        var j, len, ref, ref1, results;
        ref = array_1.sortBy(hits, function (arg) {
            var _i, dist;
            _i = arg[0], dist = arg[1];
            return dist;
        });
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
            ref1 = ref[j], i = ref1[0], _dist = ref1[1];
            results.push(i);
        }
        return results;
    })();
    return result;
};
exports.validate_bbox_coords = function (arg, arg1) {
    var ref, ref1, x0, x1, y0, y1;
    x0 = arg[0], x1 = arg[1];
    y0 = arg1[0], y1 = arg1[1];
    if (x0 > x1) {
        ref = [x1, x0], x0 = ref[0], x1 = ref[1];
    }
    if (y0 > y1) {
        ref1 = [y1, y0], y0 = ref1[0], y1 = ref1[1];
    }
    return {
        minX: x0,
        minY: y0,
        maxX: x1,
        maxY: y1
    };
};
sqr = function (x) {
    return x * x;
};
exports.dist_2_pts = function (vx, vy, wx, wy) {
    return sqr(vx - wx) + sqr(vy - wy);
};
dist_to_segment_squared = function (p, v, w) {
    var l2, t;
    l2 = exports.dist_2_pts(v.x, v.y, w.x, w.y);
    if (l2 === 0) {
        return exports.dist_2_pts(p.x, p.y, v.x, v.y);
    }
    t = ((p.x - v.x) * (w.x - v.x) + (p.y - v.y) * (w.y - v.y)) / l2;
    if (t < 0) {
        return exports.dist_2_pts(p.x, p.y, v.x, v.y);
    }
    if (t > 1) {
        return exports.dist_2_pts(p.x, p.y, w.x, w.y);
    }
    return exports.dist_2_pts(p.x, p.y, v.x + t * (w.x - v.x), v.y + t * (w.y - v.y));
};
exports.dist_to_segment = function (p, v, w) {
    return Math.sqrt(dist_to_segment_squared(p, v, w));
};
exports.check_2_segments_intersect = function (l0_x0, l0_y0, l0_x1, l0_y1, l1_x0, l1_y0, l1_x1, l1_y1) {
    /* Check if 2 segments (l0 and l1) intersect. Returns a structure with
      the following attributes:
        * hit (boolean): whether the 2 segments intersect
        * x (float): x coordinate of the intersection point
        * y (float): y coordinate of the intersection point
     */
    var a, b, den, num1, num2, x, y;
    den = ((l1_y1 - l1_y0) * (l0_x1 - l0_x0)) - ((l1_x1 - l1_x0) * (l0_y1 - l0_y0));
    if (den === 0) {
        return {
            hit: false,
            x: null,
            y: null
        };
    }
    else {
        a = l0_y0 - l1_y0;
        b = l0_x0 - l1_x0;
        num1 = ((l1_x1 - l1_x0) * a) - ((l1_y1 - l1_y0) * b);
        num2 = ((l0_x1 - l0_x0) * a) - ((l0_y1 - l0_y0) * b);
        a = num1 / den;
        b = num2 / den;
        x = l0_x0 + (a * (l0_x1 - l0_x0));
        y = l0_y0 + (a * (l0_y1 - l0_y0));
        return {
            hit: (a > 0 && a < 1) && (b > 0 && b < 1),
            x: x,
            y: y
        };
    }
};

},{"./util/array":"core/util/array"}],"core/layout/layout_canvas":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var solver_1 = require("./solver");
var model_1 = require("../../model");
var p = require("../properties");
exports.LayoutCanvas = (function (superClass) {
    extend(LayoutCanvas, superClass);
    function LayoutCanvas() {
        return LayoutCanvas.__super__.constructor.apply(this, arguments);
    }
    LayoutCanvas.prototype.type = 'LayoutCanvas';
    LayoutCanvas.prototype.initialize = function (attrs, options) {
        LayoutCanvas.__super__.initialize.call(this, attrs, options);
        this._top = new solver_1.Variable("top " + this.id);
        this._left = new solver_1.Variable("left " + this.id);
        this._width = new solver_1.Variable("width " + this.id);
        this._height = new solver_1.Variable("height " + this.id);
        this._right = new solver_1.Variable("right " + this.id);
        return this._bottom = new solver_1.Variable("bottom " + this.id);
    };
    LayoutCanvas.getters({
        height: function () {
            return this._height.value();
        },
        width: function () {
            return this._width.value();
        },
        right: function () {
            return this._right.value();
        },
        left: function () {
            return this._left.value();
        },
        top: function () {
            return this._top.value();
        },
        bottom: function () {
            return this._bottom.value();
        }
    });
    LayoutCanvas.internal({
        layout_location: [p.Any]
    });
    LayoutCanvas.prototype.get_edit_variables = function () {
        var editables;
        editables = [];
        editables.push({
            edit_variable: this._top,
            strength: solver_1.Strength.strong
        });
        editables.push({
            edit_variable: this._left,
            strength: solver_1.Strength.strong
        });
        editables.push({
            edit_variable: this._width,
            strength: solver_1.Strength.strong
        });
        editables.push({
            edit_variable: this._height,
            strength: solver_1.Strength.strong
        });
        return editables;
    };
    LayoutCanvas.prototype.get_constraints = function () {
        return [];
    };
    return LayoutCanvas;
})(model_1.Model);

},{"../../model":"model","../properties":"core/properties","./solver":"core/layout/solver"}],"core/layout/side_panel":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ALPHABETIC, BOTTOM, CENTER, HANGING, LEFT, MIDDLE, RIGHT, TOP, _align_lookup, _align_lookup_negative, _align_lookup_positive, _angle_lookup, _baseline_lookup, pi2, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var solver_1 = require("./solver");
var layout_canvas_1 = require("./layout_canvas");
var p = require("core/properties");
var logging_1 = require("core/logging");
var types_1 = require("core/util/types");
pi2 = Math.PI / 2;
ALPHABETIC = 'alphabetic';
TOP = 'top';
BOTTOM = 'bottom';
MIDDLE = 'middle';
HANGING = 'hanging';
LEFT = 'left';
RIGHT = 'right';
CENTER = 'center';
_angle_lookup = {
    above: {
        parallel: 0,
        normal: -pi2,
        horizontal: 0,
        vertical: -pi2
    },
    below: {
        parallel: 0,
        normal: pi2,
        horizontal: 0,
        vertical: pi2
    },
    left: {
        parallel: -pi2,
        normal: 0,
        horizontal: 0,
        vertical: -pi2
    },
    right: {
        parallel: pi2,
        normal: 0,
        horizontal: 0,
        vertical: pi2
    }
};
_baseline_lookup = {
    above: {
        justified: TOP,
        parallel: ALPHABETIC,
        normal: MIDDLE,
        horizontal: ALPHABETIC,
        vertical: MIDDLE
    },
    below: {
        justified: BOTTOM,
        parallel: HANGING,
        normal: MIDDLE,
        horizontal: HANGING,
        vertical: MIDDLE
    },
    left: {
        justified: TOP,
        parallel: ALPHABETIC,
        normal: MIDDLE,
        horizontal: MIDDLE,
        vertical: ALPHABETIC
    },
    right: {
        justified: TOP,
        parallel: ALPHABETIC,
        normal: MIDDLE,
        horizontal: MIDDLE,
        vertical: ALPHABETIC
    }
};
_align_lookup = {
    above: {
        justified: CENTER,
        parallel: CENTER,
        normal: LEFT,
        horizontal: CENTER,
        vertical: LEFT
    },
    below: {
        justified: CENTER,
        parallel: CENTER,
        normal: LEFT,
        horizontal: CENTER,
        vertical: RIGHT
    },
    left: {
        justified: CENTER,
        parallel: CENTER,
        normal: RIGHT,
        horizontal: RIGHT,
        vertical: CENTER
    },
    right: {
        justified: CENTER,
        parallel: CENTER,
        normal: LEFT,
        horizontal: LEFT,
        vertical: CENTER
    }
};
_align_lookup_negative = {
    above: RIGHT,
    below: LEFT,
    left: RIGHT,
    right: LEFT
};
_align_lookup_positive = {
    above: LEFT,
    below: RIGHT,
    left: RIGHT,
    right: LEFT
};
exports.update_constraints = function (view) {
    var s, side, size, v;
    v = view;
    if (v.model.props.visible != null) {
        if (v.model.visible === false) {
            return;
        }
    }
    size = v._get_size();
    if (v._last_size == null) {
        v._last_size = -1;
    }
    if (size === v._last_size) {
        return;
    }
    s = v.model.document.solver();
    v._last_size = size;
    if (v._size_constraint != null) {
        s.remove_constraint(v._size_constraint, true);
    }
    v._size_constraint = solver_1.GE(v.model.panel._size, -size);
    s.add_constraint(v._size_constraint);
    if (v._full_set == null) {
        v._full_set = false;
    }
    if (!v._full_set) {
        side = v.model.panel.side;
        if (side === 'above' || side === 'below') {
            s.add_constraint(solver_1.EQ(v.model.panel._width, [-1, v.plot_model.canvas._width]));
        }
        if (side === 'left' || side === 'right') {
            s.add_constraint(solver_1.EQ(v.model.panel._height, [-1, v.plot_model.canvas._height]));
        }
        return v._full_set = true;
    }
};
exports.SidePanel = (function (superClass) {
    extend(SidePanel, superClass);
    function SidePanel() {
        return SidePanel.__super__.constructor.apply(this, arguments);
    }
    SidePanel.internal({
        side: [p.String],
        plot: [p.Instance]
    });
    SidePanel.prototype.initialize = function (attrs, options) {
        SidePanel.__super__.initialize.call(this, attrs, options);
        switch (this.side) {
            case "above":
                this._dim = 0;
                this._normals = [0, -1];
                this._size = this._height;
                return this._anchor = this._bottom;
            case "below":
                this._dim = 0;
                this._normals = [0, 1];
                this._size = this._height;
                return this._anchor = this._top;
            case "left":
                this._dim = 1;
                this._normals = [-1, 0];
                this._size = this._width;
                return this._anchor = this._right;
            case "right":
                this._dim = 1;
                this._normals = [1, 0];
                this._size = this._width;
                return this._anchor = this._left;
            default:
                return logging_1.logger.error("unrecognized side: '" + this.side + "'");
        }
    };
    SidePanel.prototype.get_constraints = function () {
        var constraints;
        constraints = [];
        constraints.push(solver_1.GE(this._top));
        constraints.push(solver_1.GE(this._bottom));
        constraints.push(solver_1.GE(this._left));
        constraints.push(solver_1.GE(this._right));
        constraints.push(solver_1.GE(this._width));
        constraints.push(solver_1.GE(this._height));
        constraints.push(solver_1.EQ(this._left, this._width, [-1, this._right]));
        constraints.push(solver_1.EQ(this._bottom, this._height, [-1, this._top]));
        return constraints;
    };
    SidePanel.prototype.apply_label_text_heuristics = function (ctx, orient) {
        var align, baseline, side;
        side = this.side;
        if (types_1.isString(orient)) {
            baseline = _baseline_lookup[side][orient];
            align = _align_lookup[side][orient];
        }
        else if (orient === 0) {
            baseline = _baseline_lookup[side][orient];
            align = _align_lookup[side][orient];
        }
        else if (orient < 0) {
            baseline = 'middle';
            align = _align_lookup_negative[side];
        }
        else if (orient > 0) {
            baseline = 'middle';
            align = _align_lookup_positive[side];
        }
        ctx.textBaseline = baseline;
        ctx.textAlign = align;
        return ctx;
    };
    SidePanel.prototype.get_label_angle_heuristic = function (orient) {
        var side;
        side = this.side;
        return _angle_lookup[side][orient];
    };
    return SidePanel;
})(layout_canvas_1.LayoutCanvas);

},{"./layout_canvas":"core/layout/layout_canvas","./solver":"core/layout/solver","core/logging":"core/logging","core/properties":"core/properties","core/util/types":"core/util/types"}],"core/layout/solver":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var _constrainer, _weak_constrainer, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var kiwi_1 = require("kiwi");
exports.Variable = kiwi_1.Variable;
exports.Expression = kiwi_1.Expression;
exports.Constraint = kiwi_1.Constraint;
exports.Operator = kiwi_1.Operator;
exports.Strength = kiwi_1.Strength;
var events_1 = require("../events");
_constrainer = function (op) {
    return (function (_this) {
        return function () {
            var expr;
            expr = Object.create(kiwi_1.Expression.prototype);
            kiwi_1.Expression.apply(expr, arguments);
            return new kiwi_1.Constraint(expr, op);
        };
    })(this);
};
_weak_constrainer = function (op) {
    return function () {
        var arg, args, i, len;
        args = [null];
        for (i = 0, len = arguments.length; i < len; i++) {
            arg = arguments[i];
            args.push(arg);
        }
        return new kiwi_1.Constraint(new (Function.prototype.bind.apply(kiwi_1.Expression, args)), op, kiwi_1.Strength.weak);
    };
};
exports.EQ = _constrainer(kiwi_1.Operator.Eq);
exports.LE = _constrainer(kiwi_1.Operator.Le);
exports.GE = _constrainer(kiwi_1.Operator.Ge);
exports.WEAK_EQ = _weak_constrainer(kiwi_1.Operator.Eq);
exports.WEAK_LE = _weak_constrainer(kiwi_1.Operator.Le);
exports.WEAK_GE = _weak_constrainer(kiwi_1.Operator.Ge);
exports.Solver = (function () {
    extend(Solver.prototype, events_1.Events);
    function Solver() {
        this.solver = new kiwi_1.Solver();
    }
    Solver.prototype.clear = function () {
        return this.solver = new kiwi_1.Solver();
    };
    Solver.prototype.toString = function () {
        return "Solver[num_constraints=" + (this.num_constraints()) + ", num_edit_variables=" + (this.num_edit_variables()) + "]";
    };
    Solver.prototype.num_constraints = function () {
        return this.solver._cnMap._array.length;
    };
    Solver.prototype.num_edit_variables = function () {
        return this.solver._editMap._array.length;
    };
    Solver.prototype.update_variables = function (trigger) {
        if (trigger == null) {
            trigger = true;
        }
        this.solver.updateVariables();
        if (trigger) {
            return this.trigger('layout_update');
        }
    };
    Solver.prototype.add_constraint = function (constraint) {
        return this.solver.addConstraint(constraint);
    };
    Solver.prototype.remove_constraint = function (constraint, silent) {
        if (silent == null) {
            silent = false;
        }
        return this.solver.removeConstraint(constraint, silent);
    };
    Solver.prototype.add_edit_variable = function (variable, strength) {
        return this.solver.addEditVariable(variable, strength);
    };
    Solver.prototype.remove_edit_variable = function (variable, silent) {
        if (silent == null) {
            silent = false;
        }
        return this.solver.removeEditVariable(variable, strength, silent);
    };
    Solver.prototype.suggest_value = function (variable, value) {
        return this.solver.suggestValue(variable, value);
    };
    return Solver;
})();

},{"../events":"core/events","kiwi":"kiwi"}],"core/logging":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var LogLevel, _loggers, _method_factory, noop, indexOf = [].indexOf || function (item) { for (var i = 0, l = this.length; i < l; i++) {
    if (i in this && this[i] === item)
        return i;
} return -1; };
var types_1 = require("./util/types");
noop = function () { };
_method_factory = function (method_name, logger_name) {
    if (console[method_name] != null) {
        return console[method_name].bind(console, logger_name);
    }
    else if (console.log != null) {
        return console.log.bind(console, logger_name);
    }
    else {
        return noop;
    }
};
_loggers = {};
LogLevel = (function () {
    function LogLevel(name, level) {
        this.name = name;
        this.level = level;
    }
    return LogLevel;
})();
exports.Logger = (function () {
    Logger.TRACE = new LogLevel("trace", 0);
    Logger.DEBUG = new LogLevel("debug", 1);
    Logger.INFO = new LogLevel("info", 2);
    Logger.WARN = new LogLevel("warn", 6);
    Logger.ERROR = new LogLevel("error", 7);
    Logger.FATAL = new LogLevel("fatal", 8);
    Logger.OFF = new LogLevel("off", 9);
    Logger.log_levels = {
        trace: Logger.TRACE,
        debug: Logger.DEBUG,
        info: Logger.INFO,
        warn: Logger.WARN,
        error: Logger.ERROR,
        fatal: Logger.FATAL,
        off: Logger.OFF
    };
    Object.defineProperty(Logger, 'levels', {
        get: function () {
            return Object.keys(Logger.log_levels);
        }
    });
    Logger.get = function (name, level) {
        var logger;
        if (level == null) {
            level = Logger.INFO;
        }
        if (types_1.isString(name) && name.length > 0) {
            logger = _loggers[name];
            if (logger == null) {
                logger = _loggers[name] = new Logger(name, level);
            }
            return logger;
        }
        else {
            throw new TypeError("Logger.get() expects a string name and an optional log-level");
        }
    };
    function Logger(name, level) {
        if (level == null) {
            level = Logger.INFO;
        }
        this._name = name;
        this.set_level(level);
    }
    Object.defineProperty(Logger.prototype, 'level', {
        get: function () {
            return this.get_level();
        }
    });
    Logger.prototype.get_level = function () {
        return this._log_level;
    };
    Logger.prototype.set_level = function (log_level) {
        var __, logger_name, method_name, ref, results;
        if (log_level instanceof LogLevel) {
            this._log_level = log_level;
        }
        else if (types_1.isString(log_level) && (Logger.log_levels[log_level] != null)) {
            this._log_level = Logger.log_levels[log_level];
        }
        else {
            throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");
        }
        logger_name = "[" + this._name + "]";
        ref = Logger.log_levels;
        results = [];
        for (__ in ref) {
            log_level = ref[__];
            if (log_level === Logger.OFF) {
                break;
            }
            else {
                method_name = log_level.name;
                if (log_level.level < this._log_level.level) {
                    results.push(this[method_name] = noop);
                }
                else {
                    results.push(this[method_name] = _method_factory(method_name, logger_name));
                }
            }
        }
        return results;
    };
    return Logger;
})();
exports.logger = exports.Logger.get("bokeh");
exports.set_log_level = function (level) {
    if (indexOf.call(exports.Logger.levels, level) < 0) {
        console.log("[bokeh] unrecognized logging level '" + level + "' passed to Bokeh.set_log_level(), ignoring");
        return console.log("[bokeh] valid log levels are: " + (exports.Logger.levels.join(', ')));
    }
    else {
        console.log("[bokeh] setting log level to: '" + level + "'");
        return exports.logger.set_level(level);
    }
};

},{"./util/types":"core/util/types"}],"core/properties":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, indexOf = [].indexOf || function (item) { for (var i = 0, l = this.length; i < l; i++) {
    if (i in this && this[i] === item)
        return i;
} return -1; };
var events_1 = require("./events");
var enums = require("./enums");
var svg_colors = require("./util/svg_colors");
var color_1 = require("./util/color");
var array_1 = require("./util/array");
var types_1 = require("./util/types");
exports.Property = (function () {
    extend(Property.prototype, events_1.Events);
    Property.prototype.dataspec = false;
    function Property(arg) {
        this.obj = arg.obj, this.attr = arg.attr, this.default_value = arg.default_value;
        this._init(false);
        this.listenTo(this.obj, "change:" + this.attr, (function (_this) {
            return function () {
                _this._init();
                return _this.obj.trigger("propchange");
            };
        })(this));
    }
    Property.prototype.update = function () {
        return this._init();
    };
    Property.prototype.init = function () { };
    Property.prototype.transform = function (values) {
        return values;
    };
    Property.prototype.validate = function (value) { };
    Property.prototype.value = function (do_spec_transform) {
        var ret;
        if (do_spec_transform == null) {
            do_spec_transform = true;
        }
        if (this.spec.value === void 0) {
            throw new Error("attempted to retrieve property value for property without value specification");
        }
        ret = this.transform([this.spec.value])[0];
        if ((this.spec.transform != null) && do_spec_transform) {
            ret = this.spec.transform.compute(ret);
        }
        return ret;
    };
    Property.prototype.array = function (source) {
        var data, i, length, ret, value;
        if (!this.dataspec) {
            throw new Error("attempted to retrieve property array for non-dataspec property");
        }
        data = source.data;
        if (this.spec.field != null) {
            if (this.spec.field in data) {
                ret = this.transform(source.get_column(this.spec.field));
            }
            else {
                throw new Error("attempted to retrieve property array for nonexistent field '" + this.spec.field + "'");
            }
        }
        else {
            length = source.get_length();
            if (length == null) {
                length = 1;
            }
            value = this.value(false);
            ret = (function () {
                var j, ref, results;
                results = [];
                for (i = j = 0, ref = length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                    results.push(value);
                }
                return results;
            })();
        }
        if (this.spec.transform != null) {
            ret = this.spec.transform.v_compute(ret);
        }
        return ret;
    };
    Property.prototype._init = function (trigger) {
        var attr, attr_value, default_value, obj;
        if (trigger == null) {
            trigger = true;
        }
        obj = this.obj;
        if (obj == null) {
            throw new Error("missing property object");
        }
        if (obj.properties == null) {
            throw new Error("property object must be a HasProps");
        }
        attr = this.attr;
        if (attr == null) {
            throw new Error("missing property attr");
        }
        attr_value = obj.getv(attr);
        if (attr_value === void 0) {
            default_value = this.default_value;
            attr_value = (function () {
                switch (false) {
                    case default_value !== void 0:
                        return null;
                    case !types_1.isArray(default_value):
                        return array_1.copy(default_value);
                    case !types_1.isFunction(default_value):
                        return default_value(obj);
                    default:
                        return default_value;
                }
            })();
            obj.setv(attr, attr_value, {
                silent: true,
                defaults: true
            });
        }
        if (types_1.isArray(attr_value)) {
            this.spec = {
                value: attr_value
            };
        }
        else if (types_1.isObject(attr_value) && ((attr_value.value === void 0) !== (attr_value.field === void 0))) {
            this.spec = attr_value;
        }
        else {
            this.spec = {
                value: attr_value
            };
        }
        if ((this.spec.field != null) && !types_1.isString(this.spec.field)) {
            throw new Error("field value for property '" + attr + "' is not a string");
        }
        if (this.spec.value != null) {
            this.validate(this.spec.value);
        }
        this.init();
        if (trigger) {
            return this.trigger("change");
        }
    };
    return Property;
})();
exports.simple_prop = function (name, pred) {
    var Prop;
    return Prop = (function (superClass) {
        extend(Prop, superClass);
        function Prop() {
            return Prop.__super__.constructor.apply(this, arguments);
        }
        Prop.prototype.toString = function () {
            return name + "(obj: " + this.obj.id + ", spec: " + (JSON.stringify(this.spec)) + ")";
        };
        Prop.prototype.validate = function (value) {
            if (!pred(value)) {
                throw new Error(name + " property '" + this.attr + "' given invalid value: " + (JSON.stringify(value)));
            }
        };
        return Prop;
    })(exports.Property);
};
exports.Any = (function (superClass) {
    extend(Any, superClass);
    function Any() {
        return Any.__super__.constructor.apply(this, arguments);
    }
    return Any;
})(exports.simple_prop("Any", function (x) {
    return true;
}));
exports.Array = (function (superClass) {
    extend(Array, superClass);
    function Array() {
        return Array.__super__.constructor.apply(this, arguments);
    }
    return Array;
})(exports.simple_prop("Array", function (x) {
    return types_1.isArray(x) || x instanceof Float64Array;
}));
exports.Bool = (function (superClass) {
    extend(Bool, superClass);
    function Bool() {
        return Bool.__super__.constructor.apply(this, arguments);
    }
    return Bool;
})(exports.simple_prop("Bool", types_1.isBoolean));
exports.Boolean = exports.Bool;
exports.Color = (function (superClass) {
    extend(Color, superClass);
    function Color() {
        return Color.__super__.constructor.apply(this, arguments);
    }
    return Color;
})(exports.simple_prop("Color", function (x) {
    return (svg_colors[x.toLowerCase()] != null) || x.substring(0, 1) === "#" || color_1.valid_rgb(x);
}));
exports.Instance = (function (superClass) {
    extend(Instance, superClass);
    function Instance() {
        return Instance.__super__.constructor.apply(this, arguments);
    }
    return Instance;
})(exports.simple_prop("Instance", function (x) {
    return x.properties != null;
}));
exports.Number = (function (superClass) {
    extend(Number, superClass);
    function Number() {
        return Number.__super__.constructor.apply(this, arguments);
    }
    return Number;
})(exports.simple_prop("Number", function (x) {
    return types_1.isNumber(x) || types_1.isBoolean(x);
}));
exports.Int = exports.Number;
exports.Percent = (function (superClass) {
    extend(Percent, superClass);
    function Percent() {
        return Percent.__super__.constructor.apply(this, arguments);
    }
    return Percent;
})(exports.simple_prop("Number", function (x) {
    return (types_1.isNumber(x) || types_1.isBoolean(x)) && ((0 <= x && x <= 1.0));
}));
exports.String = (function (superClass) {
    extend(String, superClass);
    function String() {
        return String.__super__.constructor.apply(this, arguments);
    }
    return String;
})(exports.simple_prop("String", types_1.isString));
exports.Font = (function (superClass) {
    extend(Font, superClass);
    function Font() {
        return Font.__super__.constructor.apply(this, arguments);
    }
    return Font;
})(exports.String);
exports.enum_prop = function (name, enum_values) {
    var Enum;
    return Enum = (function (superClass) {
        extend(Enum, superClass);
        function Enum() {
            return Enum.__super__.constructor.apply(this, arguments);
        }
        Enum.prototype.toString = function () {
            return name + "(obj: " + this.obj.id + ", spec: " + (JSON.stringify(this.spec)) + ")";
        };
        return Enum;
    })(exports.simple_prop(name, function (x) {
        return indexOf.call(enum_values, x) >= 0;
    }));
};
exports.Anchor = (function (superClass) {
    extend(Anchor, superClass);
    function Anchor() {
        return Anchor.__super__.constructor.apply(this, arguments);
    }
    return Anchor;
})(exports.enum_prop("Anchor", enums.LegendLocation));
exports.AngleUnits = (function (superClass) {
    extend(AngleUnits, superClass);
    function AngleUnits() {
        return AngleUnits.__super__.constructor.apply(this, arguments);
    }
    return AngleUnits;
})(exports.enum_prop("AngleUnits", enums.AngleUnits));
exports.Direction = (function (superClass) {
    extend(Direction, superClass);
    function Direction() {
        return Direction.__super__.constructor.apply(this, arguments);
    }
    Direction.prototype.transform = function (values) {
        var i, j, ref, result;
        result = new Uint8Array(values.length);
        for (i = j = 0, ref = values.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            switch (values[i]) {
                case 'clock':
                    result[i] = false;
                    break;
                case 'anticlock':
                    result[i] = true;
            }
        }
        return result;
    };
    return Direction;
})(exports.enum_prop("Direction", enums.Direction));
exports.Dimension = (function (superClass) {
    extend(Dimension, superClass);
    function Dimension() {
        return Dimension.__super__.constructor.apply(this, arguments);
    }
    return Dimension;
})(exports.enum_prop("Dimension", enums.Dimension));
exports.Dimensions = (function (superClass) {
    extend(Dimensions, superClass);
    function Dimensions() {
        return Dimensions.__super__.constructor.apply(this, arguments);
    }
    return Dimensions;
})(exports.enum_prop("Dimensions", enums.Dimensions));
exports.FontStyle = (function (superClass) {
    extend(FontStyle, superClass);
    function FontStyle() {
        return FontStyle.__super__.constructor.apply(this, arguments);
    }
    return FontStyle;
})(exports.enum_prop("FontStyle", enums.FontStyle));
exports.LatLon = (function (superClass) {
    extend(LatLon, superClass);
    function LatLon() {
        return LatLon.__super__.constructor.apply(this, arguments);
    }
    return LatLon;
})(exports.enum_prop("LatLon", enums.LatLon));
exports.LineCap = (function (superClass) {
    extend(LineCap, superClass);
    function LineCap() {
        return LineCap.__super__.constructor.apply(this, arguments);
    }
    return LineCap;
})(exports.enum_prop("LineCap", enums.LineCap));
exports.LineJoin = (function (superClass) {
    extend(LineJoin, superClass);
    function LineJoin() {
        return LineJoin.__super__.constructor.apply(this, arguments);
    }
    return LineJoin;
})(exports.enum_prop("LineJoin", enums.LineJoin));
exports.LegendLocation = (function (superClass) {
    extend(LegendLocation, superClass);
    function LegendLocation() {
        return LegendLocation.__super__.constructor.apply(this, arguments);
    }
    return LegendLocation;
})(exports.enum_prop("LegendLocation", enums.LegendLocation));
exports.Location = (function (superClass) {
    extend(Location, superClass);
    function Location() {
        return Location.__super__.constructor.apply(this, arguments);
    }
    return Location;
})(exports.enum_prop("Location", enums.Location));
exports.Orientation = (function (superClass) {
    extend(Orientation, superClass);
    function Orientation() {
        return Orientation.__super__.constructor.apply(this, arguments);
    }
    return Orientation;
})(exports.enum_prop("Orientation", enums.Orientation));
exports.TextAlign = (function (superClass) {
    extend(TextAlign, superClass);
    function TextAlign() {
        return TextAlign.__super__.constructor.apply(this, arguments);
    }
    return TextAlign;
})(exports.enum_prop("TextAlign", enums.TextAlign));
exports.TextBaseline = (function (superClass) {
    extend(TextBaseline, superClass);
    function TextBaseline() {
        return TextBaseline.__super__.constructor.apply(this, arguments);
    }
    return TextBaseline;
})(exports.enum_prop("TextBaseline", enums.TextBaseline));
exports.RenderLevel = (function (superClass) {
    extend(RenderLevel, superClass);
    function RenderLevel() {
        return RenderLevel.__super__.constructor.apply(this, arguments);
    }
    return RenderLevel;
})(exports.enum_prop("RenderLevel", enums.RenderLevel));
exports.RenderMode = (function (superClass) {
    extend(RenderMode, superClass);
    function RenderMode() {
        return RenderMode.__super__.constructor.apply(this, arguments);
    }
    return RenderMode;
})(exports.enum_prop("RenderMode", enums.RenderMode));
exports.SizingMode = (function (superClass) {
    extend(SizingMode, superClass);
    function SizingMode() {
        return SizingMode.__super__.constructor.apply(this, arguments);
    }
    return SizingMode;
})(exports.enum_prop("SizingMode", enums.SizingMode));
exports.SpatialUnits = (function (superClass) {
    extend(SpatialUnits, superClass);
    function SpatialUnits() {
        return SpatialUnits.__super__.constructor.apply(this, arguments);
    }
    return SpatialUnits;
})(exports.enum_prop("SpatialUnits", enums.SpatialUnits));
exports.Distribution = (function (superClass) {
    extend(Distribution, superClass);
    function Distribution() {
        return Distribution.__super__.constructor.apply(this, arguments);
    }
    return Distribution;
})(exports.enum_prop("Distribution", enums.DistributionTypes));
exports.TransformStepMode = (function (superClass) {
    extend(TransformStepMode, superClass);
    function TransformStepMode() {
        return TransformStepMode.__super__.constructor.apply(this, arguments);
    }
    return TransformStepMode;
})(exports.enum_prop("TransformStepMode", enums.TransformStepModes));
exports.units_prop = function (name, valid_units, default_units) {
    var UnitsProp;
    return UnitsProp = (function (superClass) {
        extend(UnitsProp, superClass);
        function UnitsProp() {
            return UnitsProp.__super__.constructor.apply(this, arguments);
        }
        UnitsProp.prototype.toString = function () {
            return name + "(obj: " + this.obj.id + ", spec: " + (JSON.stringify(this.spec)) + ")";
        };
        UnitsProp.prototype.init = function () {
            var units;
            if (this.spec.units == null) {
                this.spec.units = default_units;
            }
            this.units = this.spec.units;
            units = this.spec.units;
            if (indexOf.call(valid_units, units) < 0) {
                throw new Error(name + " units must be one of " + valid_units + ", given invalid value: " + units);
            }
        };
        return UnitsProp;
    })(exports.Number);
};
exports.Angle = (function (superClass) {
    extend(Angle, superClass);
    function Angle() {
        return Angle.__super__.constructor.apply(this, arguments);
    }
    Angle.prototype.transform = function (values) {
        var x;
        if (this.spec.units === "deg") {
            values = (function () {
                var j, len, results;
                results = [];
                for (j = 0, len = values.length; j < len; j++) {
                    x = values[j];
                    results.push(x * Math.PI / 180.0);
                }
                return results;
            })();
        }
        values = (function () {
            var j, len, results;
            results = [];
            for (j = 0, len = values.length; j < len; j++) {
                x = values[j];
                results.push(-x);
            }
            return results;
        })();
        return Angle.__super__.transform.call(this, values);
    };
    return Angle;
})(exports.units_prop("Angle", enums.AngleUnits, "rad"));
exports.Distance = (function (superClass) {
    extend(Distance, superClass);
    function Distance() {
        return Distance.__super__.constructor.apply(this, arguments);
    }
    return Distance;
})(exports.units_prop("Distance", enums.SpatialUnits, "data"));
exports.AngleSpec = (function (superClass) {
    extend(AngleSpec, superClass);
    function AngleSpec() {
        return AngleSpec.__super__.constructor.apply(this, arguments);
    }
    AngleSpec.prototype.dataspec = true;
    return AngleSpec;
})(exports.Angle);
exports.ColorSpec = (function (superClass) {
    extend(ColorSpec, superClass);
    function ColorSpec() {
        return ColorSpec.__super__.constructor.apply(this, arguments);
    }
    ColorSpec.prototype.dataspec = true;
    return ColorSpec;
})(exports.Color);
exports.DirectionSpec = (function (superClass) {
    extend(DirectionSpec, superClass);
    function DirectionSpec() {
        return DirectionSpec.__super__.constructor.apply(this, arguments);
    }
    DirectionSpec.prototype.dataspec = true;
    return DirectionSpec;
})(exports.Distance);
exports.DistanceSpec = (function (superClass) {
    extend(DistanceSpec, superClass);
    function DistanceSpec() {
        return DistanceSpec.__super__.constructor.apply(this, arguments);
    }
    DistanceSpec.prototype.dataspec = true;
    return DistanceSpec;
})(exports.Distance);
exports.FontSizeSpec = (function (superClass) {
    extend(FontSizeSpec, superClass);
    function FontSizeSpec() {
        return FontSizeSpec.__super__.constructor.apply(this, arguments);
    }
    FontSizeSpec.prototype.dataspec = true;
    return FontSizeSpec;
})(exports.String);
exports.NumberSpec = (function (superClass) {
    extend(NumberSpec, superClass);
    function NumberSpec() {
        return NumberSpec.__super__.constructor.apply(this, arguments);
    }
    NumberSpec.prototype.dataspec = true;
    return NumberSpec;
})(exports.Number);
exports.StringSpec = (function (superClass) {
    extend(StringSpec, superClass);
    function StringSpec() {
        return StringSpec.__super__.constructor.apply(this, arguments);
    }
    StringSpec.prototype.dataspec = true;
    return StringSpec;
})(exports.String);

},{"./enums":"core/enums","./events":"core/events","./util/array":"core/util/array","./util/color":"core/util/color","./util/svg_colors":"core/util/svg_colors","./util/types":"core/util/types"}],"core/property_mixins":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var _fill_mixin, _gen_mixin, _line_mixin, _text_mixin;
var p = require("./properties");
var object_1 = require("./util/object");
_gen_mixin = function (mixin, prefix) {
    var name, result, type;
    result = {};
    if (prefix == null) {
        prefix = "";
    }
    for (name in mixin) {
        type = mixin[name];
        result[prefix + name] = type;
    }
    return result;
};
_line_mixin = {
    line_color: [p.ColorSpec, 'black'],
    line_width: [p.NumberSpec, 1],
    line_alpha: [p.NumberSpec, 1.0],
    line_join: [p.LineJoin, 'miter'],
    line_cap: [p.LineCap, 'butt'],
    line_dash: [p.Array, []],
    line_dash_offset: [p.Number, 0]
};
exports.line = function (prefix) {
    return _gen_mixin(_line_mixin, prefix);
};
_fill_mixin = {
    fill_color: [p.ColorSpec, 'gray'],
    fill_alpha: [p.NumberSpec, 1.0]
};
exports.fill = function (prefix) {
    return _gen_mixin(_fill_mixin, prefix);
};
_text_mixin = {
    text_font: [p.Font, 'helvetica'],
    text_font_size: [p.FontSizeSpec, '12pt'],
    text_font_style: [p.FontStyle, 'normal'],
    text_color: [p.ColorSpec, '#444444'],
    text_alpha: [p.NumberSpec, 1.0],
    text_align: [p.TextAlign, 'left'],
    text_baseline: [p.TextBaseline, 'bottom']
};
exports.text = function (prefix) {
    return _gen_mixin(_text_mixin, prefix);
};
exports.create = function (configs) {
    var config, i, kind, len, prefix, ref, result;
    result = {};
    for (i = 0, len = configs.length; i < len; i++) {
        config = configs[i];
        ref = config.split(":"), kind = ref[0], prefix = ref[1];
        if (this[kind] == null) {
            throw new Error("Unknown property mixin kind '" + kind + "'");
        }
        result = object_1.extend(result, this[kind](prefix));
    }
    return result;
};

},{"./properties":"core/properties","./util/object":"core/util/object"}],"core/selection_manager":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var has_props_1 = require("./has_props");
var logging_1 = require("./logging");
var selector_1 = require("./selector");
var hittest = require("./hittest");
var p = require("./properties");
exports.SelectionManager = (function (superClass) {
    extend(SelectionManager, superClass);
    function SelectionManager() {
        return SelectionManager.__super__.constructor.apply(this, arguments);
    }
    SelectionManager.prototype.type = 'SelectionManager';
    SelectionManager.internal({
        source: [p.Any]
    });
    SelectionManager.prototype.initialize = function (attrs, options) {
        SelectionManager.__super__.initialize.call(this, attrs, options);
        this.selectors = {};
        this.inspectors = {};
        return this.last_inspection_was_empty = {};
    };
    SelectionManager.prototype.select = function (tool, renderer_view, geometry, final, append) {
        var indices, selector, source;
        if (append == null) {
            append = false;
        }
        source = this.source;
        if (source !== renderer_view.model.data_source) {
            logging_1.logger.warn('select called with mis-matched data sources');
        }
        indices = renderer_view.hit_test(geometry);
        if (indices != null) {
            selector = this._get_selector(renderer_view);
            selector.update(indices, final, append);
            this.source.selected = selector.indices;
            source.trigger('select');
            source.trigger('select-' + renderer_view.model.id);
            return !indices.is_empty();
        }
        else {
            return false;
        }
    };
    SelectionManager.prototype.inspect = function (tool, renderer_view, geometry, data) {
        var indices, inspector, r_id, source;
        source = this.source;
        if (source !== renderer_view.model.data_source) {
            logging_1.logger.warn('inspect called with mis-matched data sources');
        }
        indices = renderer_view.hit_test(geometry);
        if (indices != null) {
            r_id = renderer_view.model.id;
            if (indices.is_empty()) {
                if (this.last_inspection_was_empty[r_id] == null) {
                    this.last_inspection_was_empty[r_id] = false;
                }
                if (this.last_inspection_was_empty[r_id]) {
                    return;
                }
                else {
                    this.last_inspection_was_empty[r_id] = true;
                }
            }
            else {
                this.last_inspection_was_empty[r_id] = false;
            }
            inspector = this._get_inspector(renderer_view);
            inspector.update(indices, true, false, true);
            this.source.setv({
                inspected: inspector.indices
            }, {
                "silent": true
            });
            source.trigger('inspect', indices, tool, renderer_view, source, data);
            source.trigger("inspect" + renderer_view.model.id, indices, tool, renderer_view, source, data);
            return !indices.is_empty();
        }
        else {
            return false;
        }
    };
    SelectionManager.prototype.clear = function (rview) {
        var k, ref, s, selector;
        if (rview != null) {
            selector = this._get_selector(rview);
            selector.clear();
        }
        else {
            ref = this.selectors;
            for (k in ref) {
                s = ref[k];
                s.clear();
            }
        }
        return this.source.selected = hittest.create_hit_test_result();
    };
    SelectionManager.prototype._get_selector_from = function (rview, selectors) {
        var id;
        id = rview.model.id;
        if (selectors[id] != null) {
            return selectors[id];
        }
        else {
            return selectors[id] = new selector_1.Selector();
        }
    };
    SelectionManager.prototype._get_selector = function (rview) {
        return this._get_selector_from(rview, this.selectors);
    };
    SelectionManager.prototype._get_inspector = function (rview) {
        return this._get_selector_from(rview, this.inspectors);
    };
    return SelectionManager;
})(has_props_1.HasProps);

},{"./has_props":"core/has_props","./hittest":"core/hittest","./logging":"core/logging","./properties":"core/properties","./selector":"core/selector"}],"core/selector":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var merge, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var has_props_1 = require("./has_props");
var hittest = require("./hittest");
var p = require("./properties");
var array_1 = require("./util/array");
merge = function (obj1, obj2) {
    var arr1, arr2, i, key, keys, len, result;
    result = {};
    keys = array_1.concat(Object.keys(obj1), Object.keys(obj2));
    for (i = 0, len = keys.length; i < len; i++) {
        key = keys[i];
        arr1 = obj1[key] || [];
        arr2 = obj2[key] || [];
        result[key] = array_1.union(arr1, arr2);
    }
    return result;
};
exports.Selector = (function (superClass) {
    extend(Selector, superClass);
    function Selector() {
        return Selector.__super__.constructor.apply(this, arguments);
    }
    Selector.prototype.type = 'Selector';
    Selector.prototype.update = function (indices, final, append, silent) {
        if (silent == null) {
            silent = false;
        }
        this.setv('timestamp', new Date(), {
            silent: silent
        });
        this.setv('final', final, {
            silent: silent
        });
        if (append) {
            indices['0d'].indices = array_1.union(this.indices['0d'].indices, indices['0d'].indices);
            indices['0d'].glyph = this.indices['0d'].glyph || indices['0d'].glyph;
            indices['1d'].indices = array_1.union(this.indices['1d'].indices, indices['1d'].indices);
            indices['2d'].indices = merge(this.indices['2d'].indices, indices['2d'].indices);
        }
        return this.setv('indices', indices, {
            silent: silent
        });
    };
    Selector.prototype.clear = function () {
        this.timestamp = new Date();
        this.final = true;
        return this.indices = hittest.create_hit_test_result();
    };
    Selector.internal({
        indices: [
            p.Any, function () {
                return hittest.create_hit_test_result();
            }
        ],
        final: [p.Boolean],
        timestamp: [p.Any]
    });
    return Selector;
})(has_props_1.HasProps);

},{"./has_props":"core/has_props","./hittest":"core/hittest","./properties":"core/properties","./util/array":"core/util/array"}],"core/ui_events":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend1 = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var Hammer = require("hammerjs");
var events_1 = require("./events");
var logging_1 = require("./logging");
var dom_1 = require("./dom");
var wheel_1 = require("./util/wheel");
var object_1 = require("./util/object");
var bokeh_events_1 = require("./bokeh_events");
var array_1 = require("./util/array");
exports.UIEvents = (function () {
    extend1(UIEvents.prototype, events_1.Events);
    function UIEvents(plot_view, toolbar, hit_area, plot) {
        this.plot_view = plot_view;
        this.toolbar = toolbar;
        this.hit_area = hit_area;
        this.plot = plot;
        this._configure_hammerjs();
    }
    UIEvents.prototype._configure_hammerjs = function () {
        this.hammer = new Hammer(this.hit_area);
        this.hammer.get('doubletap').recognizeWith('tap');
        this.hammer.get('tap').requireFailure('doubletap');
        this.hammer.get('doubletap').dropRequireFailure('tap');
        this.hammer.on('doubletap', (function (_this) {
            return function (e) {
                return _this._doubletap(e);
            };
        })(this));
        this.hammer.on('tap', (function (_this) {
            return function (e) {
                return _this._tap(e);
            };
        })(this));
        this.hammer.on('press', (function (_this) {
            return function (e) {
                return _this._press(e);
            };
        })(this));
        this.hammer.get('pan').set({
            direction: Hammer.DIRECTION_ALL
        });
        this.hammer.on('panstart', (function (_this) {
            return function (e) {
                return _this._pan_start(e);
            };
        })(this));
        this.hammer.on('pan', (function (_this) {
            return function (e) {
                return _this._pan(e);
            };
        })(this));
        this.hammer.on('panend', (function (_this) {
            return function (e) {
                return _this._pan_end(e);
            };
        })(this));
        this.hammer.get('pinch').set({
            enable: true
        });
        this.hammer.on('pinchstart', (function (_this) {
            return function (e) {
                return _this._pinch_start(e);
            };
        })(this));
        this.hammer.on('pinch', (function (_this) {
            return function (e) {
                return _this._pinch(e);
            };
        })(this));
        this.hammer.on('pinchend', (function (_this) {
            return function (e) {
                return _this._pinch_end(e);
            };
        })(this));
        this.hammer.get('rotate').set({
            enable: true
        });
        this.hammer.on('rotatestart', (function (_this) {
            return function (e) {
                return _this._rotate_start(e);
            };
        })(this));
        this.hammer.on('rotate', (function (_this) {
            return function (e) {
                return _this._rotate(e);
            };
        })(this));
        this.hammer.on('rotateend', (function (_this) {
            return function (e) {
                return _this._rotate_end(e);
            };
        })(this));
        this.hit_area.addEventListener("mousemove", (function (_this) {
            return function (e) {
                return _this._mouse_move(e);
            };
        })(this));
        this.hit_area.addEventListener("mouseenter", (function (_this) {
            return function (e) {
                return _this._mouse_enter(e);
            };
        })(this));
        this.hit_area.addEventListener("mouseleave", (function (_this) {
            return function (e) {
                return _this._mouse_exit(e);
            };
        })(this));
        this.hit_area.addEventListener("wheel", (function (_this) {
            return function (e) {
                return _this._mouse_wheel(e);
            };
        })(this));
        document.addEventListener("keydown", (function (_this) {
            return function (e) {
                return _this._key_down(e);
            };
        })(this));
        return document.addEventListener("keyup", (function (_this) {
            return function (e) {
                return _this._key_up(e);
            };
        })(this));
    };
    UIEvents.prototype.register_tool = function (tool_view) {
        var et, id, type;
        et = tool_view.model.event_type;
        id = tool_view.model.id;
        type = tool_view.model.type;
        if (et == null) {
            logging_1.logger.debug("Button tool: " + type);
            return;
        }
        if (et === 'pan' || et === 'pinch' || et === 'rotate') {
            logging_1.logger.debug("Registering tool: " + type + " for event '" + et + "'");
            if (tool_view["_" + et + "_start"] != null) {
                tool_view.listenTo(this, et + ":start:" + id, tool_view["_" + et + "_start"]);
            }
            if (tool_view["_" + et] != null) {
                tool_view.listenTo(this, et + ":" + id, tool_view["_" + et]);
            }
            if (tool_view["_" + et + "_end"] != null) {
                tool_view.listenTo(this, et + ":end:" + id, tool_view["_" + et + "_end"]);
            }
        }
        else if (et === "move") {
            logging_1.logger.debug("Registering tool: " + type + " for event '" + et + "'");
            if (tool_view._move_enter != null) {
                tool_view.listenTo(this, "move:enter", tool_view._move_enter);
            }
            tool_view.listenTo(this, "move", tool_view["_move"]);
            if (tool_view._move_exit != null) {
                tool_view.listenTo(this, "move:exit", tool_view._move_exit);
            }
        }
        else {
            logging_1.logger.debug("Registering tool: " + type + " for event '" + et + "'");
            tool_view.listenTo(this, et + ":" + id, tool_view["_" + et]);
        }
        if (tool_view._keydown != null) {
            logging_1.logger.debug("Registering tool: " + type + " for event 'keydown'");
            tool_view.listenTo(this, "keydown", tool_view._keydown);
        }
        if (tool_view._keyup != null) {
            logging_1.logger.debug("Registering tool: " + type + " for event 'keyup'");
            tool_view.listenTo(this, "keyup", tool_view._keyup);
        }
        if (tool_view._doubletap != null) {
            logging_1.logger.debug("Registering tool: " + type + " for event 'doubletap'");
            tool_view.listenTo(this, "doubletap", tool_view._doubletap);
        }
        if ('ontouchstart' in window || navigator.maxTouchPoints > 0) {
            if (et === 'pinch') {
                logging_1.logger.debug("Registering scroll on touch screen");
                return tool_view.listenTo(this, "scroll:" + id, tool_view["_scroll"]);
            }
        }
    };
    UIEvents.prototype._hit_test_renderers = function (sx, sy) {
        var i, ref, ref1, view;
        ref = this.plot_view.get_renderer_views();
        for (i = ref.length - 1; i >= 0; i += -1) {
            view = ref[i];
            if (((ref1 = view.model.level) === 'annotation' || ref1 === 'overlay') && (view.bbox != null)) {
                if (view.bbox().contains(sx, sy)) {
                    return view;
                }
            }
        }
        return null;
    };
    UIEvents.prototype._hit_test_frame = function (sx, sy) {
        var canvas, vx, vy;
        canvas = this.plot_view.canvas;
        vx = canvas.sx_to_vx(sx);
        vy = canvas.sy_to_vy(sy);
        return this.plot_view.frame.contains(vx, vy);
    };
    UIEvents.prototype._trigger = function (event_type, e) {
        var active_gesture, base, base_type, cursor, has_active_inspectors, view;
        base_type = event_type.split(":")[0];
        view = this._hit_test_renderers(e.bokeh.sx, e.bokeh.sy);
        switch (base_type) {
            case "move":
                has_active_inspectors = array_1.any(this.toolbar.inspectors, function (t) {
                    return t.active;
                });
                cursor = "default";
                if (view != null) {
                    if (view.model.cursor != null) {
                        cursor = view.model.cursor();
                    }
                    if (has_active_inspectors) {
                        event_type = "move:exit";
                    }
                }
                else if (this._hit_test_frame(e.bokeh.sx, e.bokeh.sy)) {
                    if (has_active_inspectors) {
                        cursor = "crosshair";
                    }
                }
                this.plot_view.set_cursor(cursor);
                return this.trigger(event_type, e);
            case "tap":
                if (view != null) {
                    if (typeof view.on_hit === "function") {
                        view.on_hit(e.bokeh.sx, e.bokeh.sy);
                    }
                }
                active_gesture = this.toolbar.gestures[base_type].active;
                if (active_gesture != null) {
                    return this.trigger(event_type + ":" + active_gesture.id, e);
                }
                break;
            case "scroll":
                base = 'ontouchstart' in window || navigator.maxTouchPoints > 0 ? "pinch" : "scroll";
                active_gesture = this.toolbar.gestures[base].active;
                if (active_gesture != null) {
                    e.preventDefault();
                    e.stopPropagation();
                    return this.trigger(event_type + ":" + active_gesture.id, e);
                }
                break;
            default:
                active_gesture = this.toolbar.gestures[base_type].active;
                if (active_gesture != null) {
                    return this.trigger(event_type + ":" + active_gesture.id, e);
                }
        }
    };
    UIEvents.prototype._bokify_hammer = function (e, extras) {
        var event_cls, left, ref, top, x, y;
        if (extras == null) {
            extras = {};
        }
        if (e.pointerType === 'mouse') {
            x = e.srcEvent.pageX;
            y = e.srcEvent.pageY;
        }
        else {
            x = e.pointers[0].pageX;
            y = e.pointers[0].pageY;
        }
        ref = dom_1.offset(e.target), left = ref.left, top = ref.top;
        e.bokeh = {
            sx: x - left,
            sy: y - top
        };
        e.bokeh = object_1.extend(e.bokeh, extras);
        event_cls = bokeh_events_1.BokehEvent.event_class(e);
        if (event_cls != null) {
            return this.plot.trigger_event(event_cls.from_event(e));
        }
        else {
            return logging_1.logger.debug('Unhandled event of type ' + e.type);
        }
    };
    UIEvents.prototype._bokify_point_event = function (e, extras) {
        var event_cls, left, ref, top;
        if (extras == null) {
            extras = {};
        }
        ref = dom_1.offset(e.currentTarget), left = ref.left, top = ref.top;
        e.bokeh = {
            sx: e.pageX - left,
            sy: e.pageY - top
        };
        e.bokeh = object_1.extend(e.bokeh, extras);
        event_cls = bokeh_events_1.BokehEvent.event_class(e);
        if (event_cls != null) {
            return this.plot.trigger_event(event_cls.from_event(e));
        }
        else {
            return logging_1.logger.debug('Unhandled event of type ' + e.type);
        }
    };
    UIEvents.prototype._tap = function (e) {
        this._bokify_hammer(e);
        return this._trigger('tap', e);
    };
    UIEvents.prototype._doubletap = function (e) {
        this._bokify_hammer(e);
        return this.trigger('doubletap', e);
    };
    UIEvents.prototype._press = function (e) {
        this._bokify_hammer(e);
        return this._trigger('press', e);
    };
    UIEvents.prototype._pan_start = function (e) {
        this._bokify_hammer(e);
        e.bokeh.sx -= e.deltaX;
        e.bokeh.sy -= e.deltaY;
        return this._trigger('pan:start', e);
    };
    UIEvents.prototype._pan = function (e) {
        this._bokify_hammer(e);
        return this._trigger('pan', e);
    };
    UIEvents.prototype._pan_end = function (e) {
        this._bokify_hammer(e);
        return this._trigger('pan:end', e);
    };
    UIEvents.prototype._pinch_start = function (e) {
        this._bokify_hammer(e);
        return this._trigger('pinch:start', e);
    };
    UIEvents.prototype._pinch = function (e) {
        this._bokify_hammer(e);
        return this._trigger('pinch', e);
    };
    UIEvents.prototype._pinch_end = function (e) {
        this._bokify_hammer(e);
        return this._trigger('pinch:end', e);
    };
    UIEvents.prototype._rotate_start = function (e) {
        this._bokify_hammer(e);
        return this._trigger('rotate:start', e);
    };
    UIEvents.prototype._rotate = function (e) {
        this._bokify_hammer(e);
        return this._trigger('rotate', e);
    };
    UIEvents.prototype._rotate_end = function (e) {
        this._bokify_hammer(e);
        return this._trigger('rotate:end', e);
    };
    UIEvents.prototype._mouse_enter = function (e) {
        this._bokify_point_event(e);
        return this._trigger('move:enter', e);
    };
    UIEvents.prototype._mouse_move = function (e) {
        this._bokify_point_event(e);
        return this._trigger('move', e);
    };
    UIEvents.prototype._mouse_exit = function (e) {
        this._bokify_point_event(e);
        return this._trigger('move:exit', e);
    };
    UIEvents.prototype._mouse_wheel = function (e) {
        this._bokify_point_event(e, {
            delta: wheel_1.getDeltaY(e)
        });
        return this._trigger('scroll', e);
    };
    UIEvents.prototype._key_down = function (e) {
        return this.trigger('keydown', e);
    };
    UIEvents.prototype._key_up = function (e) {
        return this.trigger('keyup', e);
    };
    return UIEvents;
})();

},{"./bokeh_events":"core/bokeh_events","./dom":"core/dom","./events":"core/events","./logging":"core/logging","./util/array":"core/util/array","./util/object":"core/util/object","./util/wheel":"core/util/wheel","hammerjs":"hammerjs"}],"core/util/array":[function(require,module,exports){
//     Underscore.js 1.8.3
//     http://underscorejs.org
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var slice = Array.prototype.slice;
function copy(array /*| TypedArray*/) {
    return slice.call(array);
}
exports.copy = copy;
function concat(arrays) {
    return [].concat.apply([], arrays);
}
exports.concat = concat;
function contains(array, value) {
    return array.indexOf(value) >= 0;
}
exports.contains = contains;
function nth(array, index) {
    return array[index >= 0 ? index : array.length + index];
}
exports.nth = nth;
function zip(As, Bs) {
    var n = Math.min(As.length, Bs.length);
    var ABs = new Array(n);
    for (var i = 0; i < n; i++) {
        ABs[i] = [As[i], Bs[i]];
    }
    return ABs;
}
exports.zip = zip;
function unzip(ABs) {
    var n = ABs.length;
    var As = new Array(n);
    var Bs = new Array(n);
    for (var i = 0; i < n; i++) {
        _a = ABs[i], As[i] = _a[0], Bs[i] = _a[1];
    }
    return [As, Bs];
    var _a;
}
exports.unzip = unzip;
function range(start, stop, step) {
    if (step === void 0) { step = 1; }
    if (stop == null) {
        stop = start;
        start = 0;
    }
    var length = Math.max(Math.ceil((stop - start) / step), 0);
    var range = Array(length);
    for (var i = 0; i < length; i++, start += step) {
        range[i] = start;
    }
    return range;
}
exports.range = range;
function linspace(start, stop, num) {
    if (num === void 0) { num = 100; }
    var step = (stop - start) / (num - 1);
    var array = new Array(num);
    for (var i = 0; i < num; i++) {
        array[i] = start + step * i;
    }
    return array;
}
exports.linspace = linspace;
function transpose(array) {
    var rows = array.length;
    var cols = array[0].length;
    var transposed = [];
    for (var j = 0; j < cols; j++) {
        transposed[j] = [];
        for (var i = 0; i < rows; i++) {
            transposed[j][i] = array[i][j];
        }
    }
    return transposed;
}
exports.transpose = transpose;
function sum(array) {
    return array.reduce(function (a, b) { return a + b; }, 0);
}
exports.sum = sum;
function cumsum(array) {
    var result = [];
    array.reduce(function (a, b, i) { return result[i] = a + b; }, 0);
    return result;
}
exports.cumsum = cumsum;
function min(array) {
    var value;
    var result = Infinity;
    for (var i = 0, length_1 = array.length; i < length_1; i++) {
        value = array[i];
        if (value < result) {
            result = value;
        }
    }
    return result;
}
exports.min = min;
function minBy(array, key) {
    var value;
    var result;
    var computed;
    var resultComputed = Infinity;
    for (var i = 0, length_2 = array.length; i < length_2; i++) {
        value = array[i];
        computed = key(value);
        if (computed < resultComputed) {
            result = value;
            resultComputed = computed;
        }
    }
    return result;
}
exports.minBy = minBy;
function max(array) {
    var value;
    var result = -Infinity;
    for (var i = 0, length_3 = array.length; i < length_3; i++) {
        value = array[i];
        if (value > result) {
            result = value;
        }
    }
    return result;
}
exports.max = max;
function maxBy(array, key) {
    var value;
    var result;
    var computed;
    var resultComputed = -Infinity;
    for (var i = 0, length_4 = array.length; i < length_4; i++) {
        value = array[i];
        computed = key(value);
        if (computed > resultComputed) {
            result = value;
            resultComputed = computed;
        }
    }
    return result;
}
exports.maxBy = maxBy;
function argmin(array) {
    return minBy(range(array.length), function (i) { return array[i]; });
}
exports.argmin = argmin;
function argmax(array) {
    return maxBy(range(array.length), function (i) { return array[i]; });
}
exports.argmax = argmax;
function all(array, predicate) {
    for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
        var item = array_1[_i];
        if (!predicate(item))
            return false;
    }
    return true;
}
exports.all = all;
function any(array, predicate) {
    for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
        var item = array_2[_i];
        if (predicate(item))
            return true;
    }
    return false;
}
exports.any = any;
function findIndexFactory(dir) {
    return function (array, predicate) {
        var length = array.length;
        var index = dir > 0 ? 0 : length - 1;
        for (; index >= 0 && index < length; index += dir) {
            if (predicate(array[index]))
                return index;
        }
        return -1;
    };
}
exports.findIndex = findIndexFactory(1);
exports.findLastIndex = findIndexFactory(-1);
function sortedIndex(array, value) {
    var low = 0;
    var high = array.length;
    while (low < high) {
        var mid = Math.floor((low + high) / 2);
        if (array[mid] < value)
            low = mid + 1;
        else
            high = mid;
    }
    return low;
}
exports.sortedIndex = sortedIndex;
function sortBy(array, key) {
    var tmp = array.map(function (value, index) {
        return { value: value, index: index, key: key(value) };
    });
    tmp.sort(function (left, right) {
        var a = left.key;
        var b = right.key;
        if (a !== b) {
            if (a > b || a === undefined)
                return 1;
            if (a < b || b === undefined)
                return -1;
        }
        return left.index - right.index;
    });
    return tmp.map(function (item) { return item.value; });
}
exports.sortBy = sortBy;
function uniq(array) {
    var result = [];
    for (var _i = 0, array_3 = array; _i < array_3.length; _i++) {
        var value = array_3[_i];
        if (!contains(result, value)) {
            result.push(value);
        }
    }
    return result;
}
exports.uniq = uniq;
function uniqBy(array, key) {
    var result = [];
    var seen = [];
    for (var _i = 0, array_4 = array; _i < array_4.length; _i++) {
        var value = array_4[_i];
        var computed = key(value);
        if (!contains(seen, computed)) {
            seen.push(computed);
            result.push(value);
        }
    }
    return result;
}
exports.uniqBy = uniqBy;
function union() {
    var arrays = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        arrays[_i] = arguments[_i];
    }
    return uniq(concat(arrays));
}
exports.union = union;
function intersection(array) {
    var arrays = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        arrays[_i - 1] = arguments[_i];
    }
    var result = [];
    top: for (var _a = 0, array_5 = array; _a < array_5.length; _a++) {
        var item = array_5[_a];
        if (contains(result, item))
            continue;
        for (var _b = 0, arrays_1 = arrays; _b < arrays_1.length; _b++) {
            var other = arrays_1[_b];
            if (!contains(other, item))
                continue top;
        }
        result.push(item);
    }
    return result;
}
exports.intersection = intersection;
function difference(array) {
    var arrays = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        arrays[_i - 1] = arguments[_i];
    }
    var rest = concat(arrays);
    return array.filter(function (value) { return !contains(rest, value); });
}
exports.difference = difference;

},{}],"core/util/bbox":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function empty() {
    return {
        minX: Infinity,
        minY: Infinity,
        maxX: -Infinity,
        maxY: -Infinity,
    };
}
exports.empty = empty;
function positive_x() {
    return {
        minX: Number.MIN_VALUE,
        minY: -Infinity,
        maxX: Infinity,
        maxY: Infinity,
    };
}
exports.positive_x = positive_x;
function positive_y() {
    return {
        minX: -Infinity,
        minY: Number.MIN_VALUE,
        maxX: Infinity,
        maxY: Infinity,
    };
}
exports.positive_y = positive_y;
function union(a, b) {
    return {
        minX: Math.min(a.minX, b.minX),
        maxX: Math.max(a.maxX, b.maxX),
        minY: Math.min(a.minY, b.minY),
        maxY: Math.max(a.maxY, b.maxY),
    };
}
exports.union = union;
var BBox = (function () {
    function BBox(bbox) {
        if (bbox == null) {
            this.x0 = Infinity;
            this.y0 = -Infinity;
            this.x1 = Infinity;
            this.y1 = -Infinity;
        }
        else {
            this.x0 = bbox.x0;
            this.y0 = bbox.y0;
            this.x1 = bbox.x1;
            this.y1 = bbox.y1;
        }
    }
    Object.defineProperty(BBox.prototype, "minX", {
        get: function () { return this.x0; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BBox.prototype, "minY", {
        get: function () { return this.y0; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BBox.prototype, "maxX", {
        get: function () { return this.x1; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BBox.prototype, "maxY", {
        get: function () { return this.y1; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BBox.prototype, "pt0", {
        get: function () { return [this.x0, this.y0]; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BBox.prototype, "pt1", {
        get: function () { return [this.x1, this.y1]; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BBox.prototype, "x", {
        get: function () { return this.x0; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BBox.prototype, "y", {
        get: function () { return this.x1; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BBox.prototype, "width", {
        get: function () { return this.x1 - this.x0; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BBox.prototype, "height", {
        get: function () { return this.y1 - this.y0; },
        enumerable: true,
        configurable: true
    });
    BBox.prototype.contains = function (x, y) {
        return x >= this.x0 && x <= this.x1 && y >= this.y0 && y <= this.y1;
    };
    BBox.prototype.union = function (that) {
        return new BBox({
            x0: Math.min(this.x0, that.x0),
            y0: Math.min(this.y0, that.y0),
            x1: Math.max(this.x1, that.x1),
            y1: Math.max(this.y1, that.y1),
        });
    };
    return BBox;
}());
exports.BBox = BBox;

},{}],"core/util/callback":[function(require,module,exports){
//     Underscore.js 1.8.3
//     http://underscorejs.org
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function delay(func, wait) {
    return setTimeout(func, wait);
}
exports.delay = delay;
function defer(func) {
    return delay(func, 1);
}
exports.defer = defer;
function throttle(func, wait, options) {
    var context, args, result;
    var timeout = null;
    var previous = 0;
    if (!options)
        options = {};
    var later = function () {
        previous = options.leading === false ? 0 : Date.now();
        timeout = null;
        result = func.apply(context, args);
        if (!timeout)
            context = args = null;
    };
    return function () {
        var now = Date.now();
        if (!previous && options.leading === false)
            previous = now;
        var remaining = wait - (now - previous);
        context = this;
        args = arguments;
        if (remaining <= 0 || remaining > wait) {
            if (timeout) {
                clearTimeout(timeout);
                timeout = null;
            }
            previous = now;
            result = func.apply(context, args);
            if (!timeout)
                context = args = null;
        }
        else if (!timeout && options.trailing !== false) {
            timeout = setTimeout(later, remaining);
        }
        return result;
    };
}
exports.throttle = throttle;
function once(func) {
    var done = false;
    var memo;
    return function () {
        if (!done) {
            done = true;
            memo = func();
        }
        return memo;
    };
}
exports.once = once;

},{}],"core/util/canvas":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fixup_line_dash = function (ctx) {
    if (!ctx.setLineDash) {
        ctx.setLineDash = function (dash) {
            ctx.mozDash = dash;
            return ctx.webkitLineDash = dash;
        };
    }
    if (!ctx.getLineDash) {
        return ctx.getLineDash = function () {
            return ctx.mozDash;
        };
    }
};
exports.fixup_line_dash_offset = function (ctx) {
    ctx.setLineDashOffset = function (dash_offset) {
        ctx.lineDashOffset = dash_offset;
        ctx.mozDashOffset = dash_offset;
        return ctx.webkitLineDashOffset = dash_offset;
    };
    return ctx.getLineDashOffset = function () {
        return ctx.mozDashOffset;
    };
};
exports.fixup_image_smoothing = function (ctx) {
    ctx.setImageSmoothingEnabled = function (value) {
        ctx.imageSmoothingEnabled = value;
        ctx.mozImageSmoothingEnabled = value;
        ctx.oImageSmoothingEnabled = value;
        return ctx.webkitImageSmoothingEnabled = value;
    };
    return ctx.getImageSmoothingEnabled = function () {
        var ref;
        return (ref = ctx.imageSmoothingEnabled) != null ? ref : true;
    };
};
exports.fixup_measure_text = function (ctx) {
    if (ctx.measureText && (ctx.html5MeasureText == null)) {
        ctx.html5MeasureText = ctx.measureText;
        return ctx.measureText = function (text) {
            var textMetrics;
            textMetrics = ctx.html5MeasureText(text);
            textMetrics.ascent = ctx.html5MeasureText("m").width * 1.6;
            return textMetrics;
        };
    }
};
exports.get_scale_ratio = function (ctx, hidpi) {
    var backingStoreRatio, devicePixelRatio;
    if (hidpi) {
        devicePixelRatio = window.devicePixelRatio || 1;
        backingStoreRatio = ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1;
        return devicePixelRatio / backingStoreRatio;
    }
    else {
        return 1;
    }
};
exports.fixup_ellipse = function (ctx) {
    var ellipse_bezier;
    ellipse_bezier = function (x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise) {
        var c, rx, ry;
        if (anticlockwise == null) {
            anticlockwise = false;
        }
        c = 0.551784;
        ctx.translate(x, y);
        ctx.rotate(rotation);
        rx = radiusX;
        ry = radiusY;
        if (anticlockwise) {
            rx = -radiusX;
            ry = -radiusY;
        }
        ctx.moveTo(-rx, 0);
        ctx.bezierCurveTo(-rx, ry * c, -rx * c, ry, 0, ry);
        ctx.bezierCurveTo(rx * c, ry, rx, ry * c, rx, 0);
        ctx.bezierCurveTo(rx, -ry * c, rx * c, -ry, 0, -ry);
        ctx.bezierCurveTo(-rx * c, -ry, -rx, -ry * c, -rx, 0);
        ctx.rotate(-rotation);
        ctx.translate(-x, -y);
    };
    if (!ctx.ellipse) {
        return ctx.ellipse = ellipse_bezier;
    }
};

},{}],"core/util/color":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var _component2hex, indexOf = [].indexOf || function (item) { for (var i = 0, l = this.length; i < l; i++) {
    if (i in this && this[i] === item)
        return i;
} return -1; };
var svg_colors = require("./svg_colors");
_component2hex = function (v) {
    var h;
    h = Number(v).toString(16);
    return h = h.length === 1 ? '0' + h : h;
};
exports.color2hex = function (color) {
    var hex, rgb, v;
    color = color + '';
    if (color.indexOf('#') === 0) {
        return color;
    }
    else if (svg_colors[color] != null) {
        return svg_colors[color];
    }
    else if (color.indexOf('rgb') === 0) {
        rgb = color.match(/\d+/g);
        hex = ((function () {
            var j, len, results;
            results = [];
            for (j = 0, len = rgb.length; j < len; j++) {
                v = rgb[j];
                results.push(_component2hex(v));
            }
            return results;
        })()).join('');
        return '#' + hex.slice(0, 8);
    }
    else {
        return color;
    }
};
exports.color2rgba = function (color, alpha) {
    var hex, i, rgba;
    if (alpha == null) {
        alpha = 1;
    }
    if (!color) {
        return [0, 0, 0, 0];
    }
    hex = exports.color2hex(color);
    hex = hex.replace(/ |#/g, '');
    if (hex.length <= 4) {
        hex = hex.replace(/(.)/g, '$1$1');
    }
    hex = hex.match(/../g);
    rgba = (function () {
        var j, len, results;
        results = [];
        for (j = 0, len = hex.length; j < len; j++) {
            i = hex[j];
            results.push(parseInt(i, 16) / 255);
        }
        return results;
    })();
    while (rgba.length < 3) {
        rgba.push(0);
    }
    if (rgba.length < 4) {
        rgba.push(alpha);
    }
    return rgba.slice(0, 4);
};
exports.valid_rgb = function (value) {
    var contents, params, ref, rgb;
    switch (value.substring(0, 4)) {
        case "rgba":
            params = {
                start: "rgba(",
                len: 4,
                alpha: true
            };
            break;
        case "rgb(":
            params = {
                start: "rgb(",
                len: 3,
                alpha: false
            };
            break;
        default:
            return false;
    }
    if (new RegExp(".*?(\\.).*(,)").test(value)) {
        throw new Error("color expects integers for rgb in rgb/rgba tuple, received " + value);
    }
    contents = value.replace(params.start, "").replace(")", "").split(',').map(parseFloat);
    if (contents.length !== params.len) {
        throw new Error("color expects rgba " + expect_len + "-tuple, received " + value);
    }
    if (params.alpha && !((0 <= (ref = contents[3]) && ref <= 1))) {
        throw new Error("color expects rgba 4-tuple to have alpha value between 0 and 1");
    }
    if (indexOf.call((function () {
        var j, len, ref1, results;
        ref1 = contents.slice(0, 3);
        results = [];
        for (j = 0, len = ref1.length; j < len; j++) {
            rgb = ref1[j];
            results.push((0 <= rgb && rgb <= 255));
        }
        return results;
    })(), false) >= 0) {
        throw new Error("color expects rgb to have value between 0 and 255");
    }
    return true;
};

},{"./svg_colors":"core/util/svg_colors"}],"core/util/data_structures":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var array_1 = require("./array");
var eq_1 = require("./eq");
var types_1 = require("./types");
exports.MultiDict = (function () {
    function MultiDict() {
        this._dict = {};
    }
    MultiDict.prototype._existing = function (key) {
        if (key in this._dict) {
            return this._dict[key];
        }
        else {
            return null;
        }
    };
    MultiDict.prototype.add_value = function (key, value) {
        var existing;
        if (value === null) {
            throw new Error("Can't put null in this dict");
        }
        if (types_1.isArray(value)) {
            throw new Error("Can't put arrays in this dict");
        }
        existing = this._existing(key);
        if (existing === null) {
            return this._dict[key] = value;
        }
        else if (types_1.isArray(existing)) {
            return existing.push(value);
        }
        else {
            return this._dict[key] = [existing, value];
        }
    };
    MultiDict.prototype.remove_value = function (key, value) {
        var existing, new_array;
        existing = this._existing(key);
        if (types_1.isArray(existing)) {
            new_array = array_1.difference(existing, [value]);
            if (new_array.length > 0) {
                return this._dict[key] = new_array;
            }
            else {
                return delete this._dict[key];
            }
        }
        else if (eq_1.isEqual(existing, value)) {
            return delete this._dict[key];
        }
    };
    MultiDict.prototype.get_one = function (key, duplicate_error) {
        var existing;
        existing = this._existing(key);
        if (types_1.isArray(existing)) {
            if (existing.length === 1) {
                return existing[0];
            }
            else {
                throw new Error(duplicate_error);
            }
        }
        else {
            return existing;
        }
    };
    return MultiDict;
})();
exports.Set = (function () {
    function Set(array) {
        if (!array) {
            this.values = [];
        }
        else {
            if (array.constructor === Set) {
                return new Set(array.values);
            }
            if (array.constructor === Array) {
                this.values = Set.compact(array);
            }
            else {
                this.values = [array];
            }
        }
    }
    Set.compact = function (array) {
        var item, j, len, newArray;
        newArray = [];
        for (j = 0, len = array.length; j < len; j++) {
            item = array[j];
            if (newArray.indexOf(item) === -1) {
                newArray.push(item);
            }
        }
        return newArray;
    };
    Set.prototype.push = function (item) {
        if (this.missing(item)) {
            return this.values.push(item);
        }
    };
    Set.prototype.remove = function (item) {
        var i;
        i = this.values.indexOf(item);
        return this.values = this.values.slice(0, i).concat(this.values.slice(i + 1));
    };
    Set.prototype.length = function () {
        return this.values.length;
    };
    Set.prototype.includes = function (item) {
        return this.values.indexOf(item) !== -1;
    };
    Set.prototype.missing = function (item) {
        return !this.includes(item);
    };
    Set.prototype.slice = function (from, to) {
        return this.values.slice(from, to);
    };
    Set.prototype.join = function (str) {
        return this.values.join(str);
    };
    Set.prototype.toString = function () {
        return this.join(', ');
    };
    Set.prototype.includes = function (item) {
        return this.values.indexOf(item) !== -1;
    };
    Set.prototype.union = function (set) {
        set = new Set(set);
        return new Set(this.values.concat(set.values));
    };
    Set.prototype.intersect = function (set) {
        var item, j, len, newSet, ref;
        set = new Set(set);
        newSet = new Set;
        ref = set.values;
        for (j = 0, len = ref.length; j < len; j++) {
            item = ref[j];
            if (this.includes(item) && set.includes(item)) {
                newSet.push(item);
            }
        }
        return newSet;
    };
    Set.prototype.diff = function (set) {
        var item, j, len, newSet, ref;
        set = new Set(set);
        newSet = new Set;
        ref = this.values;
        for (j = 0, len = ref.length; j < len; j++) {
            item = ref[j];
            if (set.missing(item)) {
                newSet.push(item);
            }
        }
        return newSet;
    };
    return Set;
})();

},{"./array":"core/util/array","./eq":"core/util/eq","./types":"core/util/types"}],"core/util/eq":[function(require,module,exports){
//     Underscore.js 1.8.3
//     http://underscorejs.org
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var types_1 = require("./types");
// Internal recursive comparison function for `isEqual`.
function eq(a, b, aStack, bStack) {
    // Identical objects are equal. `0 === -0`, but they aren't identical.
    // See the [Harmony `egal` proposal](http://wiki.ecmascript.org/doku.php?id=harmony:egal).
    if (a === b)
        return a !== 0 || 1 / a === 1 / b;
    // A strict comparison is necessary because `null == undefined`.
    if (a == null || b == null)
        return a === b;
    // Compare `[[Class]]` names.
    var className = toString.call(a);
    if (className !== toString.call(b))
        return false;
    switch (className) {
        // Strings, numbers, regular expressions, dates, and booleans are compared by value.
        case '[object RegExp]':
        // RegExps are coerced to strings for comparison (Note: '' + /a/i === '/a/i')
        case '[object String]':
            // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
            // equivalent to `new String("5")`.
            return '' + a === '' + b;
        case '[object Number]':
            // `NaN`s are equivalent, but non-reflexive.
            // Object(NaN) is equivalent to NaN
            if (+a !== +a)
                return +b !== +b;
            // An `egal` comparison is performed for other numeric values.
            return +a === 0 ? 1 / +a === 1 / b : +a === +b;
        case '[object Date]':
        case '[object Boolean]':
            // Coerce dates and booleans to numeric primitive values. Dates are compared by their
            // millisecond representations. Note that invalid dates with millisecond representations
            // of `NaN` are not equivalent.
            return +a === +b;
    }
    var areArrays = className === '[object Array]';
    if (!areArrays) {
        if (typeof a != 'object' || typeof b != 'object')
            return false;
        // Objects with different constructors are not equivalent, but `Object`s or `Array`s
        // from different frames are.
        var aCtor = a.constructor, bCtor = b.constructor;
        if (aCtor !== bCtor && !(types_1.isFunction(aCtor) && aCtor instanceof aCtor &&
            types_1.isFunction(bCtor) && bCtor instanceof bCtor)
            && ('constructor' in a && 'constructor' in b)) {
            return false;
        }
    }
    // Assume equality for cyclic structures. The algorithm for detecting cyclic
    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
    // Initializing stack of traversed objects.
    // It's done here since we only need them for objects and arrays comparison.
    aStack = aStack || [];
    bStack = bStack || [];
    var length = aStack.length;
    while (length--) {
        // Linear search. Performance is inversely proportional to the number of
        // unique nested structures.
        if (aStack[length] === a)
            return bStack[length] === b;
    }
    // Add the first object to the stack of traversed objects.
    aStack.push(a);
    bStack.push(b);
    // Recursively compare objects and arrays.
    if (areArrays) {
        // Compare array lengths to determine if a deep comparison is necessary.
        length = a.length;
        if (length !== b.length)
            return false;
        // Deep compare the contents, ignoring non-numeric properties.
        while (length--) {
            if (!eq(a[length], b[length], aStack, bStack))
                return false;
        }
    }
    else {
        // Deep compare objects.
        var keys = Object.keys(a);
        var key = void 0;
        length = keys.length;
        // Ensure that both objects contain the same number of properties before comparing deep equality.
        if (Object.keys(b).length !== length)
            return false;
        while (length--) {
            // Deep compare each member
            key = keys[length];
            if (!(b.hasOwnProperty(key) && eq(a[key], b[key], aStack, bStack)))
                return false;
        }
    }
    // Remove the first object from the stack of traversed objects.
    aStack.pop();
    bStack.pop();
    return true;
}
// Perform a deep comparison to check if two objects are equal.
function isEqual(a, b) {
    return eq(a, b);
}
exports.isEqual = isEqual;

},{"./types":"core/util/types"}],"core/util/math":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function angle_norm(angle) {
    while (angle < 0) {
        angle += 2 * Math.PI;
    }
    while (angle > 2 * Math.PI) {
        angle -= 2 * Math.PI;
    }
    return angle;
}
exports.angle_norm = angle_norm;
function angle_dist(lhs, rhs) {
    return Math.abs(angle_norm(lhs - rhs));
}
exports.angle_dist = angle_dist;
function angle_between(mid, lhs, rhs, direction) {
    var norm_mid = angle_norm(mid);
    var d = angle_dist(lhs, rhs);
    var cond = angle_dist(lhs, norm_mid) <= d && angle_dist(norm_mid, rhs) <= d;
    if (direction == "anticlock")
        return cond;
    else
        return !cond;
}
exports.angle_between = angle_between;
function random() {
    return Math.random();
}
exports.random = random;
function atan2(start, end) {
    /*
     * Calculate the angle between a line containing start and end points (composed
     * of [x, y] arrays) and the positive x-axis.
     */
    return Math.atan2(end[1] - start[1], end[0] - start[0]);
}
exports.atan2 = atan2;
// http://www2.econ.osaka-u.ac.jp/~tanizaki/class/2013/econome3/13.pdf (Page 432)
function rnorm(mu, sigma) {
    // Generate a random normal with a mean of 0 and a sigma of 1
    var r1;
    var r2;
    while (true) {
        r1 = random();
        r2 = random();
        r2 = (2 * r2 - 1) * Math.sqrt(2 * (1 / Math.E));
        if (-4 * r1 * r1 * Math.log(r1) >= r2 * r2)
            break;
    }
    var rn = r2 / r1;
    // Transform the standard normal to meet the characteristics that we want (mu, sigma)
    rn = mu + sigma * rn;
    return rn;
}
exports.rnorm = rnorm;
function clamp(val, min, max) {
    if (val > max)
        return max;
    if (val < min)
        return min;
    return val;
}
exports.clamp = clamp;

},{}],"core/util/object":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.keys = Object.keys;
function values(object) {
    var keys = Object.keys(object);
    var length = keys.length;
    var values = new Array(length);
    for (var i = 0; i < length; i++) {
        values[i] = object[keys[i]];
    }
    return values;
}
exports.values = values;
function extend(dest) {
    var sources = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        sources[_i - 1] = arguments[_i];
    }
    for (var _a = 0, sources_1 = sources; _a < sources_1.length; _a++) {
        var source = sources_1[_a];
        for (var key in source) {
            if (source.hasOwnProperty(key)) {
                dest[key] = source[key];
            }
        }
    }
    return dest;
}
exports.extend = extend;
function clone(obj) {
    return extend({}, obj);
}
exports.clone = clone;
function isEmpty(obj) {
    return Object.keys(obj).length === 0;
}
exports.isEmpty = isEmpty;

},{}],"core/util/proj4":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var proj4 = require("proj4/lib/core");
exports.proj4 = proj4;
var Proj = require("proj4/lib/Proj");
var toPoint = require("proj4/lib/common/toPoint");
var defs = require("proj4/lib/defs");
var transform = require("proj4/lib/transform");
proj4.defaultDatum = 'WGS84';
proj4.WGS84 = new Proj('WGS84');
proj4.Proj = Proj;
proj4.toPoint = toPoint;
proj4.defs = defs;
proj4.transform = transform;
exports.mercator = defs('GOOGLE');
exports.wgs84 = defs('WGS84');

},{"proj4/lib/Proj":"proj4/lib/Proj","proj4/lib/common/toPoint":"proj4/lib/common/toPoint","proj4/lib/core":"proj4/lib/core","proj4/lib/defs":"proj4/lib/defs","proj4/lib/transform":"proj4/lib/transform"}],"core/util/projections":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var proj4_1 = require("./proj4");
exports.project_xy = function (x, y) {
    var i, j, merc_x, merc_x_s, merc_y, merc_y_s, ref, ref1;
    merc_x_s = [];
    merc_y_s = [];
    for (i = j = 0, ref = x.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        ref1 = proj4_1.proj4(proj4_1.mercator, [x[i], y[i]]), merc_x = ref1[0], merc_y = ref1[1];
        merc_x_s[i] = merc_x;
        merc_y_s[i] = merc_y;
    }
    return [merc_x_s, merc_y_s];
};
exports.project_xsys = function (xs, ys) {
    var i, j, merc_x_s, merc_xs_s, merc_y_s, merc_ys_s, ref, ref1;
    merc_xs_s = [];
    merc_ys_s = [];
    for (i = j = 0, ref = xs.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        ref1 = exports.project_xy(xs[i], ys[i]), merc_x_s = ref1[0], merc_y_s = ref1[1];
        merc_xs_s[i] = merc_x_s;
        merc_ys_s[i] = merc_y_s;
    }
    return [merc_xs_s, merc_ys_s];
};

},{"./proj4":"core/util/proj4"}],"core/util/refs":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var has_props_1 = require("../has_props");
var types_1 = require("./types");
exports.create_ref = function (obj) {
    var ref;
    if (!(obj instanceof has_props_1.HasProps)) {
        throw new Error("can only create refs for HasProps subclasses");
    }
    ref = {
        'type': obj.type,
        'id': obj.id
    };
    if (obj._subtype != null) {
        ref['subtype'] = obj._subtype;
    }
    return ref;
};
exports.is_ref = function (arg) {
    var keys;
    if (types_1.isObject(arg)) {
        keys = Object.keys(arg).sort();
        if (keys.length === 2) {
            return keys[0] === 'id' && keys[1] === 'type';
        }
        if (keys.length === 3) {
            return keys[0] === 'id' && keys[1] === 'subtype' && keys[2] === 'type';
        }
    }
    return false;
};
exports.convert_to_ref = function (value) {
    if (types_1.isArray(value)) {
        return value.map(exports.convert_to_ref);
    }
    else {
        if (value instanceof has_props_1.HasProps) {
            return value.ref();
        }
    }
};

},{"../has_props":"core/has_props","./types":"core/util/types"}],"core/util/selection":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.get_indices = function (data_source) {
    var selected;
    selected = data_source.selected;
    if (selected['0d'].glyph) {
        return selected['0d'].indices;
    }
    else if (selected['1d'].indices.length > 0) {
        return selected['1d'].indices;
    }
    else if (selected['2d'].indices.length > 0) {
        return selected['2d'].indices;
    }
    else {
        return [];
    }
};

},{}],"core/util/serialization":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ARRAY_TYPES, DTYPES, _arrayBufferToBase64, _base64ToArrayBuffer, k, v;
var types_1 = require("./types");
ARRAY_TYPES = {
    float32: Float32Array,
    float64: Float64Array,
    uint8: Uint8Array,
    int8: Int8Array,
    uint16: Uint16Array,
    int16: Int16Array,
    uint32: Uint32Array,
    int32: Int32Array
};
DTYPES = {};
for (k in ARRAY_TYPES) {
    v = ARRAY_TYPES[k];
    DTYPES[v.name] = k;
}
_arrayBufferToBase64 = function (buffer) {
    var b, binary, bytes;
    bytes = new Uint8Array(buffer);
    binary = (function () {
        var j, len1, results;
        results = [];
        for (j = 0, len1 = bytes.length; j < len1; j++) {
            b = bytes[j];
            results.push(String.fromCharCode(b));
        }
        return results;
    })();
    return btoa(binary.join(""));
};
_base64ToArrayBuffer = function (base64) {
    var binary_string, bytes, i, j, len, ref;
    binary_string = atob(base64);
    len = binary_string.length;
    bytes = new Uint8Array(len);
    for (i = j = 0, ref = len; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        bytes[i] = binary_string.charCodeAt(i);
    }
    return bytes.buffer;
};
exports.decode_base64 = function (input) {
    var array, bytes, dtype, shape;
    bytes = _base64ToArrayBuffer(input['__ndarray__']);
    dtype = input['dtype'];
    if (dtype in ARRAY_TYPES) {
        array = new ARRAY_TYPES[dtype](bytes);
    }
    shape = input['shape'];
    return [array, shape];
};
exports.encode_base64 = function (array, shape) {
    var b64, data, dtype;
    b64 = _arrayBufferToBase64(array.buffer);
    dtype = DTYPES[array.constructor.name];
    data = {
        __ndarray__: b64,
        shape: shape,
        dtype: dtype
    };
    return data;
};
exports.decode_column_data = function (data) {
    var arr, arrays, data_shapes, j, len1, new_data, ref, ref1, shape, shapes;
    new_data = {};
    data_shapes = {};
    for (k in data) {
        v = data[k];
        if (types_1.isArray(v)) {
            arrays = [];
            shapes = [];
            for (j = 0, len1 = v.length; j < len1; j++) {
                arr = v[j];
                if (types_1.isObject(arr) && '__ndarray__' in arr) {
                    ref = exports.decode_base64(arr), arr = ref[0], shape = ref[1];
                    shapes.push(shape);
                    arrays.push(arr);
                }
                else if (types_1.isArray(arr)) {
                    shapes.push([]);
                    arrays.push(arr);
                }
            }
            if (shapes.length > 0) {
                new_data[k] = arrays;
                data_shapes[k] = shapes;
            }
            else {
                new_data[k] = v;
            }
        }
        else if (types_1.isObject(v) && '__ndarray__' in v) {
            ref1 = exports.decode_base64(v), arr = ref1[0], shape = ref1[1];
            new_data[k] = arr;
            data_shapes[k] = shape;
        }
        else {
            new_data[k] = v;
            data_shapes[k] = [];
        }
    }
    return [new_data, data_shapes];
};
exports.encode_column_data = function (data, shapes) {
    var i, j, new_array, new_data, ref, ref1, ref2;
    new_data = {};
    for (k in data) {
        v = data[k];
        if ((v != null ? v.buffer : void 0) instanceof ArrayBuffer) {
            v = exports.encode_base64(v, shapes != null ? shapes[k] : void 0);
        }
        else if (types_1.isArray(v)) {
            new_array = [];
            for (i = j = 0, ref = v.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                if (((ref1 = v[i]) != null ? ref1.buffer : void 0) instanceof ArrayBuffer) {
                    new_array.push(exports.encode_base64(v[i], shapes != null ? (ref2 = shapes[k]) != null ? ref2[i] : void 0 : void 0));
                }
                else {
                    new_array.push(v[i]);
                }
            }
            v = new_array;
        }
        new_data[k] = v;
    }
    return new_data;
};

},{"./types":"core/util/types"}],"core/util/spatial":[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/// <reference types="@types/rbush" />
var rbush = require("rbush");
var SpatialIndex = (function () {
    function SpatialIndex() {
    }
    return SpatialIndex;
}());
exports.SpatialIndex = SpatialIndex;
var RBush = (function (_super) {
    __extends(RBush, _super);
    function RBush(points) {
        var _this = _super.call(this) || this;
        _this.index = rbush();
        _this.index.load(points);
        return _this;
    }
    Object.defineProperty(RBush.prototype, "bbox", {
        get: function () {
            var _a = this.index.toJSON(), minX = _a.minX, minY = _a.minY, maxX = _a.maxX, maxY = _a.maxY;
            return { minX: minX, minY: minY, maxX: maxX, maxY: maxY };
        },
        enumerable: true,
        configurable: true
    });
    RBush.prototype.search = function (rect) {
        return this.index.search(rect);
    };
    RBush.prototype.indices = function (rect) {
        var points = this.search(rect);
        var n = points.length;
        var indices = new Array(n);
        for (var j = 0; j < n; j++) {
            indices[j] = points[j].i;
        }
        return indices;
    };
    return RBush;
}(SpatialIndex));
exports.RBush = RBush;

},{"rbush":"rbush"}],"core/util/string":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function startsWith(str, searchString, position) {
    if (position === void 0) { position = 0; }
    return str.substr(position, searchString.length) == searchString;
}
exports.startsWith = startsWith;
function uniqueId(prefix) {
    // from ipython project
    // http://www.ietf.org/rfc/rfc4122.txt
    var s = new Array(32);
    var hexDigits = "0123456789ABCDEF";
    for (var i = 0; i < 32; i++) {
        s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
    }
    s[12] = "4"; // bits 12-15 of the time_hi_and_version field to 0010
    s[16] = hexDigits.substr((s[16].charCodeAt(0) & 0x3) | 0x8, 1); // bits 6-7 of the clock_seq_hi_and_reserved to 01
    var uuid = s.join("");
    if (prefix != null)
        return prefix + "-" + uuid;
    else
        return uuid;
}
exports.uniqueId = uniqueId;
function escape(s) {
    return s.replace(/(?:[&<>"'`])/g, function (ch) {
        switch (ch) {
            case '&': return '&amp;';
            case '<': return '&lt;';
            case '>': return '&gt;';
            case '"': return '&quot;';
            case "'": return '&#x27;';
            case '`': return '&#x60;';
        }
    });
}
exports.escape = escape;

},{}],"core/util/svg_colors":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.indianred = "#CD5C5C";
exports.lightcoral = "#F08080";
exports.salmon = "#FA8072";
exports.darksalmon = "#E9967A";
exports.lightsalmon = "#FFA07A";
exports.crimson = "#DC143C";
exports.red = "#FF0000";
exports.firebrick = "#B22222";
exports.darkred = "#8B0000";
exports.pink = "#FFC0CB";
exports.lightpink = "#FFB6C1";
exports.hotpink = "#FF69B4";
exports.deeppink = "#FF1493";
exports.mediumvioletred = "#C71585";
exports.palevioletred = "#DB7093";
exports.coral = "#FF7F50";
exports.tomato = "#FF6347";
exports.orangered = "#FF4500";
exports.darkorange = "#FF8C00";
exports.orange = "#FFA500";
exports.gold = "#FFD700";
exports.yellow = "#FFFF00";
exports.lightyellow = "#FFFFE0";
exports.lemonchiffon = "#FFFACD";
exports.lightgoldenrodyellow = "#FAFAD2";
exports.papayawhip = "#FFEFD5";
exports.moccasin = "#FFE4B5";
exports.peachpuff = "#FFDAB9";
exports.palegoldenrod = "#EEE8AA";
exports.khaki = "#F0E68C";
exports.darkkhaki = "#BDB76B";
exports.lavender = "#E6E6FA";
exports.thistle = "#D8BFD8";
exports.plum = "#DDA0DD";
exports.violet = "#EE82EE";
exports.orchid = "#DA70D6";
exports.fuchsia = "#FF00FF";
exports.magenta = "#FF00FF";
exports.mediumorchid = "#BA55D3";
exports.mediumpurple = "#9370DB";
exports.blueviolet = "#8A2BE2";
exports.darkviolet = "#9400D3";
exports.darkorchid = "#9932CC";
exports.darkmagenta = "#8B008B";
exports.purple = "#800080";
exports.indigo = "#4B0082";
exports.slateblue = "#6A5ACD";
exports.darkslateblue = "#483D8B";
exports.mediumslateblue = "#7B68EE";
exports.greenyellow = "#ADFF2F";
exports.chartreuse = "#7FFF00";
exports.lawngreen = "#7CFC00";
exports.lime = "#00FF00";
exports.limegreen = "#32CD32";
exports.palegreen = "#98FB98";
exports.lightgreen = "#90EE90";
exports.mediumspringgreen = "#00FA9A";
exports.springgreen = "#00FF7F";
exports.mediumseagreen = "#3CB371";
exports.seagreen = "#2E8B57";
exports.forestgreen = "#228B22";
exports.green = "#008000";
exports.darkgreen = "#006400";
exports.yellowgreen = "#9ACD32";
exports.olivedrab = "#6B8E23";
exports.olive = "#808000";
exports.darkolivegreen = "#556B2F";
exports.mediumaquamarine = "#66CDAA";
exports.darkseagreen = "#8FBC8F";
exports.lightseagreen = "#20B2AA";
exports.darkcyan = "#008B8B";
exports.teal = "#008080";
exports.aqua = "#00FFFF";
exports.cyan = "#00FFFF";
exports.lightcyan = "#E0FFFF";
exports.paleturquoise = "#AFEEEE";
exports.aquamarine = "#7FFFD4";
exports.turquoise = "#40E0D0";
exports.mediumturquoise = "#48D1CC";
exports.darkturquoise = "#00CED1";
exports.cadetblue = "#5F9EA0";
exports.steelblue = "#4682B4";
exports.lightsteelblue = "#B0C4DE";
exports.powderblue = "#B0E0E6";
exports.lightblue = "#ADD8E6";
exports.skyblue = "#87CEEB";
exports.lightskyblue = "#87CEFA";
exports.deepskyblue = "#00BFFF";
exports.dodgerblue = "#1E90FF";
exports.cornflowerblue = "#6495ED";
exports.royalblue = "#4169E1";
exports.blue = "#0000FF";
exports.mediumblue = "#0000CD";
exports.darkblue = "#00008B";
exports.navy = "#000080";
exports.midnightblue = "#191970";
exports.cornsilk = "#FFF8DC";
exports.blanchedalmond = "#FFEBCD";
exports.bisque = "#FFE4C4";
exports.navajowhite = "#FFDEAD";
exports.wheat = "#F5DEB3";
exports.burlywood = "#DEB887";
exports.tan = "#D2B48C";
exports.rosybrown = "#BC8F8F";
exports.sandybrown = "#F4A460";
exports.goldenrod = "#DAA520";
exports.darkgoldenrod = "#B8860B";
exports.peru = "#CD853F";
exports.chocolate = "#D2691E";
exports.saddlebrown = "#8B4513";
exports.sienna = "#A0522D";
exports.brown = "#A52A2A";
exports.maroon = "#800000";
exports.white = "#FFFFFF";
exports.snow = "#FFFAFA";
exports.honeydew = "#F0FFF0";
exports.mintcream = "#F5FFFA";
exports.azure = "#F0FFFF";
exports.aliceblue = "#F0F8FF";
exports.ghostwhite = "#F8F8FF";
exports.whitesmoke = "#F5F5F5";
exports.seashell = "#FFF5EE";
exports.beige = "#F5F5DC";
exports.oldlace = "#FDF5E6";
exports.floralwhite = "#FFFAF0";
exports.ivory = "#FFFFF0";
exports.antiquewhite = "#FAEBD7";
exports.linen = "#FAF0E6";
exports.lavenderblush = "#FFF0F5";
exports.mistyrose = "#FFE4E1";
exports.gainsboro = "#DCDCDC";
exports.lightgray = "#D3D3D3";
exports.lightgrey = "#D3D3D3";
exports.silver = "#C0C0C0";
exports.darkgray = "#A9A9A9";
exports.darkgrey = "#A9A9A9";
exports.gray = "#808080";
exports.grey = "#808080";
exports.dimgray = "#696969";
exports.dimgrey = "#696969";
exports.lightslategray = "#778899";
exports.lightslategrey = "#778899";
exports.slategray = "#708090";
exports.slategrey = "#708090";
exports.darkslategray = "#2F4F4F";
exports.darkslategrey = "#2F4F4F";
exports.black = "#000000";

},{}],"core/util/templating":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var _format_number;
var SPrintf = require("sprintf");
var Numbro = require("numbro");
var string_1 = require("./string");
var types_1 = require("./types");
_format_number = function (number) {
    var format;
    if (types_1.isNumber(number)) {
        format = (function () {
            switch (false) {
                case Math.floor(number) !== number:
                    return "%d";
                case !(Math.abs(number) > 0.1 && Math.abs(number) < 1000):
                    return "%0.3f";
                default:
                    return "%0.3e";
            }
        })();
        return SPrintf.sprintf(format, number);
    }
    else {
        return "" + number;
    }
};
exports.replace_placeholders = function (string, data_source, i, special_vars) {
    if (special_vars == null) {
        special_vars = {};
    }
    string = string.replace(/(^|[^\$])\$(\w+)/g, (function (_this) {
        return function (match, prefix, name) {
            return prefix + "@$" + name;
        };
    })(this));
    string = string.replace(/(^|[^@])@(?:(\$?\w+)|{([^{}]+)})(?:{([^{}]+)})?/g, (function (_this) {
        return function (match, prefix, name, long_name, format) {
            var ref, replacement, value;
            name = long_name != null ? long_name : name;
            value = name[0] === "$" ? special_vars[name.substring(1)] : (ref = data_source.get_column(name)) != null ? ref[i] : void 0;
            replacement = null;
            if (value == null) {
                replacement = "???";
            }
            else {
                if (format === 'safe') {
                    return "" + prefix + value;
                }
                else if (format != null) {
                    replacement = Numbro.format(value, format);
                }
                else {
                    replacement = _format_number(value);
                }
            }
            return replacement = "" + prefix + (string_1.escape(replacement));
        };
    })(this));
    return string;
};

},{"./string":"core/util/string","./types":"core/util/types","numbro":"numbro","sprintf":"sprintf"}],"core/util/text":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var cache;
var dom_1 = require("../dom");
cache = {};
exports.get_text_height = function (font) {
    var block, elem, result, text;
    if (cache[font] != null) {
        return cache[font];
    }
    text = dom_1.span({
        style: {
            font: font
        }
    }, "Hg");
    block = dom_1.div({
        style: {
            display: "inline-block",
            width: "1px",
            height: "0px"
        }
    });
    elem = dom_1.div({}, text, block);
    document.body.appendChild(elem);
    try {
        result = {};
        block.style.verticalAlign = "baseline";
        result.ascent = dom_1.offset(block).top - dom_1.offset(text).top;
        block.style.verticalAlign = "bottom";
        result.height = dom_1.offset(block).top - dom_1.offset(text).top;
        result.descent = result.height - result.ascent;
    }
    finally {
        document.body.removeChild(elem);
    }
    cache[font] = result;
    return result;
};

},{"../dom":"core/dom"}],"core/util/throttle":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var _delay_animation, delay_animation;
_delay_animation = function (f) {
    return f();
};
delay_animation = (typeof window !== "undefined" && window !== null ? window.requestAnimationFrame : void 0) || (typeof window !== "undefined" && window !== null ? window.mozRequestAnimationFrame : void 0) || (typeof window !== "undefined" && window !== null ? window.webkitRequestAnimationFrame : void 0) || (typeof window !== "undefined" && window !== null ? window.msRequestAnimationFrame : void 0) || _delay_animation;
exports.throttle = function (func, wait) {
    var args, context, later, pending, previous, ref, result, timeout;
    ref = [null, null, null, null], context = ref[0], args = ref[1], timeout = ref[2], result = ref[3];
    previous = 0;
    pending = false;
    later = function () {
        previous = new Date;
        timeout = null;
        pending = false;
        return result = func.apply(context, args);
    };
    return function () {
        var now, remaining;
        now = new Date;
        remaining = wait - (now - previous);
        context = this;
        args = arguments;
        if (remaining <= 0 && !pending) {
            clearTimeout(timeout);
            pending = true;
            delay_animation(later);
        }
        else if (!timeout && !pending) {
            timeout = setTimeout((function () {
                return delay_animation(later);
            }), remaining);
        }
        return result;
    };
};

},{}],"core/util/types":[function(require,module,exports){
//     Underscore.js 1.8.3
//     http://underscorejs.org
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var toString = Object.prototype.toString;
function isBoolean(obj) {
    return obj === true || obj === false || toString.call(obj) === '[object Boolean]';
}
exports.isBoolean = isBoolean;
function isNumber(obj) {
    return toString.call(obj) === "[object Number]";
}
exports.isNumber = isNumber;
function isString(obj) {
    return toString.call(obj) === "[object String]";
}
exports.isString = isString;
function isStrictNaN(obj) {
    return isNumber(obj) && obj !== +obj;
}
exports.isStrictNaN = isStrictNaN;
function isFunction(obj) {
    return toString.call(obj) === "[object Function]";
}
exports.isFunction = isFunction;
function isArray(obj) {
    return Array.isArray(obj);
}
exports.isArray = isArray;
function isObject(obj) {
    var tp = typeof obj;
    return tp === 'function' || tp === 'object' && !!obj;
}
exports.isObject = isObject;

},{}],"core/util/wheel":[function(require,module,exports){
/*!
 * jQuery Mousewheel 3.1.13
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 */
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function fontSize(element) {
    return parseInt(getComputedStyle(element).fontSize, 10) || null;
}
function lineHeight(element) {
    var parent = element.offsetParent || document.body;
    return fontSize(parent) || fontSize(element) || 16;
}
function pageHeight(element) {
    return element.clientHeight; // XXX: should be content height?
}
function getDeltaY(event) {
    var deltaY = -event.deltaY;
    if (event.target instanceof HTMLElement) {
        switch (event.deltaMode) {
            case event.DOM_DELTA_LINE:
                deltaY *= lineHeight(event.target);
                break;
            case event.DOM_DELTA_PAGE:
                deltaY *= pageHeight(event.target);
                break;
        }
    }
    return deltaY;
}
exports.getDeltaY = getDeltaY;

},{}],"core/util/zoom":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var math_1 = require("./math");
exports.scale_highlow = function (range, factor, center) {
    var high, low, ref, x, x0, x1;
    if (center == null) {
        center = null;
    }
    ref = [range.start, range.end], low = ref[0], high = ref[1];
    x = center != null ? center : (high + low) / 2.0;
    x0 = low - (low - x) * factor;
    x1 = high - (high - x) * factor;
    return [x0, x1];
};
exports.get_info = function (mappers, arg) {
    var end, info, mapper, name, ref, start, x0, x1;
    x0 = arg[0], x1 = arg[1];
    info = {};
    for (name in mappers) {
        mapper = mappers[name];
        ref = mapper.v_map_from_target([x0, x1], true), start = ref[0], end = ref[1];
        info[name] = {
            start: start,
            end: end
        };
    }
    return info;
};
exports.scale_range = function (frame, factor, h_axis, v_axis, center) {
    var hfactor, ref, ref1, vfactor, vx0, vx1, vy0, vy1, xrs, yrs;
    if (h_axis == null) {
        h_axis = true;
    }
    if (v_axis == null) {
        v_axis = true;
    }
    if (center == null) {
        center = null;
    }
    "Utility function for zoom tools to calculate/create the zoom_info object\nof the form required by ``PlotCanvasView.update_range``\n\nParameters:\n  frame : CartesianFrame\n  factor : Number\n  h_axis : Boolean, optional\n    whether to zoom the horizontal axis (default = true)\n  v_axis : Boolean, optional\n    whether to zoom the horizontal axis (default = true)\n  center : object, optional\n    of form {'x': Number, 'y', Number}\n\nReturns:\n  object:";
    factor = math_1.clamp(factor, -0.9, 0.9);
    hfactor = h_axis ? factor : 0;
    ref = exports.scale_highlow(frame.h_range, hfactor, center != null ? center.x : void 0), vx0 = ref[0], vx1 = ref[1];
    xrs = exports.get_info(frame.x_mappers, [vx0, vx1]);
    vfactor = v_axis ? factor : 0;
    ref1 = exports.scale_highlow(frame.v_range, vfactor, center != null ? center.y : void 0), vy0 = ref1[0], vy1 = ref1[1];
    yrs = exports.get_info(frame.y_mappers, [vy0, vy1]);
    return {
        xrs: xrs,
        yrs: yrs,
        factor: factor
    };
};

},{"./math":"core/util/math"}],"core/visuals":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ContextProperties, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var mixins = require("./property_mixins");
var color_1 = require("./util/color");
ContextProperties = (function () {
    function ContextProperties(obj, prefix) {
        var attr, do_spec, j, len, ref;
        if (prefix == null) {
            prefix = "";
        }
        this.obj = obj;
        this.prefix = prefix;
        this.cache = {};
        do_spec = obj.properties[prefix + this.do_attr].spec;
        this.doit = do_spec.value !== null;
        ref = this.attrs;
        for (j = 0, len = ref.length; j < len; j++) {
            attr = ref[j];
            this[attr] = obj.properties[prefix + attr];
        }
    }
    ContextProperties.prototype.warm_cache = function (source) {
        var attr, j, len, prop, ref, results;
        ref = this.attrs;
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
            attr = ref[j];
            prop = this.obj.properties[this.prefix + attr];
            if (prop.spec.value !== void 0) {
                results.push(this.cache[attr] = prop.spec.value);
            }
            else {
                results.push(this.cache[attr + "_array"] = prop.array(source));
            }
        }
        return results;
    };
    ContextProperties.prototype.cache_select = function (attr, i) {
        var prop;
        prop = this.obj.properties[this.prefix + attr];
        if (prop.spec.value !== void 0) {
            return this.cache[attr] = prop.spec.value;
        }
        else {
            return this.cache[attr] = this.cache[attr + "_array"][i];
        }
    };
    return ContextProperties;
})();
exports.Line = (function (superClass) {
    extend(Line, superClass);
    function Line() {
        return Line.__super__.constructor.apply(this, arguments);
    }
    Line.prototype.attrs = Object.keys(mixins.line());
    Line.prototype.do_attr = "line_color";
    Line.prototype.set_value = function (ctx) {
        ctx.strokeStyle = this.line_color.value();
        ctx.globalAlpha = this.line_alpha.value();
        ctx.lineWidth = this.line_width.value();
        ctx.lineJoin = this.line_join.value();
        ctx.lineCap = this.line_cap.value();
        ctx.setLineDash(this.line_dash.value());
        return ctx.setLineDashOffset(this.line_dash_offset.value());
    };
    Line.prototype.set_vectorize = function (ctx, i) {
        this.cache_select("line_color", i);
        if (ctx.strokeStyle !== this.cache.line_color) {
            ctx.strokeStyle = this.cache.line_color;
        }
        this.cache_select("line_alpha", i);
        if (ctx.globalAlpha !== this.cache.line_alpha) {
            ctx.globalAlpha = this.cache.line_alpha;
        }
        this.cache_select("line_width", i);
        if (ctx.lineWidth !== this.cache.line_width) {
            ctx.lineWidth = this.cache.line_width;
        }
        this.cache_select("line_join", i);
        if (ctx.lineJoin !== this.cache.line_join) {
            ctx.lineJoin = this.cache.line_join;
        }
        this.cache_select("line_cap", i);
        if (ctx.lineCap !== this.cache.line_cap) {
            ctx.lineCap = this.cache.line_cap;
        }
        this.cache_select("line_dash", i);
        if (ctx.getLineDash() !== this.cache.line_dash) {
            ctx.setLineDash(this.cache.line_dash);
        }
        this.cache_select("line_dash_offset", i);
        if (ctx.getLineDashOffset() !== this.cache.line_dash_offset) {
            return ctx.setLineDashOffset(this.cache.line_dash_offset);
        }
    };
    Line.prototype.color_value = function () {
        var color;
        color = color_1.color2rgba(this.line_color.value(), this.line_alpha.value());
        return "rgba(" + (color[0] * 255) + "," + (color[1] * 255) + "," + (color[2] * 255) + "," + color[3] + ")";
    };
    return Line;
})(ContextProperties);
exports.Fill = (function (superClass) {
    extend(Fill, superClass);
    function Fill() {
        return Fill.__super__.constructor.apply(this, arguments);
    }
    Fill.prototype.attrs = Object.keys(mixins.fill());
    Fill.prototype.do_attr = "fill_color";
    Fill.prototype.set_value = function (ctx) {
        ctx.fillStyle = this.fill_color.value();
        return ctx.globalAlpha = this.fill_alpha.value();
    };
    Fill.prototype.set_vectorize = function (ctx, i) {
        this.cache_select("fill_color", i);
        if (ctx.fillStyle !== this.cache.fill_color) {
            ctx.fillStyle = this.cache.fill_color;
        }
        this.cache_select("fill_alpha", i);
        if (ctx.globalAlpha !== this.cache.fill_alpha) {
            return ctx.globalAlpha = this.cache.fill_alpha;
        }
    };
    Fill.prototype.color_value = function () {
        var color;
        color = color_1.color2rgba(this.fill_color.value(), this.fill_alpha.value());
        return "rgba(" + (color[0] * 255) + "," + (color[1] * 255) + "," + (color[2] * 255) + "," + color[3] + ")";
    };
    return Fill;
})(ContextProperties);
exports.Text = (function (superClass) {
    extend(Text, superClass);
    function Text() {
        return Text.__super__.constructor.apply(this, arguments);
    }
    Text.prototype.attrs = Object.keys(mixins.text());
    Text.prototype.do_attr = "text_color";
    Text.prototype.cache_select = function (name, i) {
        var val;
        if (name === "font") {
            val = Text.__super__.cache_select.call(this, "text_font_style", i) + " " + Text.__super__.cache_select.call(this, "text_font_size", i) + " " + Text.__super__.cache_select.call(this, "text_font", i);
            return this.cache.font = val;
        }
        else {
            return Text.__super__.cache_select.call(this, name, i);
        }
    };
    Text.prototype.font_value = function () {
        var font, font_size, font_style;
        font = this.text_font.value();
        font_size = this.text_font_size.value();
        font_style = this.text_font_style.value();
        return font_style + " " + font_size + " " + font;
    };
    Text.prototype.color_value = function () {
        var color;
        color = color_1.color2rgba(this.text_color.value(), this.text_alpha.value());
        return "rgba(" + (color[0] * 255) + "," + (color[1] * 255) + "," + (color[2] * 255) + "," + color[3] + ")";
    };
    Text.prototype.set_value = function (ctx) {
        ctx.font = this.font_value();
        ctx.fillStyle = this.text_color.value();
        ctx.globalAlpha = this.text_alpha.value();
        ctx.textAlign = this.text_align.value();
        return ctx.textBaseline = this.text_baseline.value();
    };
    Text.prototype.set_vectorize = function (ctx, i) {
        this.cache_select("font", i);
        if (ctx.font !== this.cache.font) {
            ctx.font = this.cache.font;
        }
        this.cache_select("text_color", i);
        if (ctx.fillStyle !== this.cache.text_color) {
            ctx.fillStyle = this.cache.text_color;
        }
        this.cache_select("text_alpha", i);
        if (ctx.globalAlpha !== this.cache.text_alpha) {
            ctx.globalAlpha = this.cache.text_alpha;
        }
        this.cache_select("text_align", i);
        if (ctx.textAlign !== this.cache.text_align) {
            ctx.textAlign = this.cache.text_align;
        }
        this.cache_select("text_baseline", i);
        if (ctx.textBaseline !== this.cache.text_baseline) {
            return ctx.textBaseline = this.cache.text_baseline;
        }
    };
    return Text;
})(ContextProperties);
exports.Visuals = (function () {
    function Visuals(model) {
        var cls, j, len, name, prefix, ref, ref1, ref2, spec;
        ref = model.mixins;
        for (j = 0, len = ref.length; j < len; j++) {
            spec = ref[j];
            ref1 = spec.split(":"), name = ref1[0], prefix = (ref2 = ref1[1]) != null ? ref2 : "";
            cls = (function () {
                switch (name) {
                    case "line":
                        return exports.Line;
                    case "fill":
                        return exports.Fill;
                    case "text":
                        return exports.Text;
                }
            })();
            this[prefix + name] = new cls(model, prefix);
        }
    }
    Visuals.prototype.warm_cache = function (source) {
        var name, prop, ref, results;
        ref = this;
        results = [];
        for (name in ref) {
            if (!hasProp.call(ref, name))
                continue;
            prop = ref[name];
            if (prop instanceof ContextProperties) {
                results.push(prop.warm_cache(source));
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    return Visuals;
})();

},{"./property_mixins":"core/property_mixins","./util/color":"core/util/color"}],"document":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var EventManager, extend1 = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, indexOf = [].indexOf || function (item) { for (var i = 0, l = this.length; i < l; i++) {
    if (i in this && this[i] === item)
        return i;
} return -1; };
var base_1 = require("./base");
var version_1 = require("./version");
var solver_1 = require("./core/layout/solver");
var logging_1 = require("./core/logging");
var has_props_1 = require("./core/has_props");
var refs_1 = require("./core/util/refs");
var serialization_1 = require("./core/util/serialization");
var data_structures_1 = require("./core/util/data_structures");
var array_1 = require("./core/util/array");
var object_1 = require("./core/util/object");
var eq_1 = require("./core/util/eq");
var types_1 = require("./core/util/types");
var column_data_source_1 = require("./models/sources/column_data_source");
EventManager = (function () {
    function EventManager(document1) {
        this.document = document1;
        this.session = null;
        this.subscribed_models = new data_structures_1.Set();
    }
    EventManager.prototype.send_event = function (event) {
        var ref1;
        return (ref1 = this.session) != null ? ref1.send_event(event) : void 0;
    };
    EventManager.prototype.trigger = function (event) {
        var j, len, model, model_id, ref1, results;
        ref1 = this.subscribed_models.values;
        results = [];
        for (j = 0, len = ref1.length; j < len; j++) {
            model_id = ref1[j];
            if (event.model_id !== null && event.model_id !== model_id) {
                continue;
            }
            model = this.document._all_models[model_id];
            results.push(model != null ? model._process_event(event) : void 0);
        }
        return results;
    };
    return EventManager;
})();
exports.DocumentChangedEvent = (function () {
    function DocumentChangedEvent(document1) {
        this.document = document1;
    }
    return DocumentChangedEvent;
})();
exports.ModelChangedEvent = (function (superClass) {
    extend1(ModelChangedEvent, superClass);
    function ModelChangedEvent(document1, model1, attr1, old1, new_1, setter_id1) {
        this.document = document1;
        this.model = model1;
        this.attr = attr1;
        this.old = old1;
        this.new_ = new_1;
        this.setter_id = setter_id1;
        ModelChangedEvent.__super__.constructor.call(this, this.document);
    }
    ModelChangedEvent.prototype.json = function (references) {
        var id, value, value_json, value_refs;
        if (this.attr === 'id') {
            logging_1.logger.warn("'id' field is immutable and should never be in a ModelChangedEvent ", this);
            throw new Error("'id' field should never change, whatever code just set it is wrong");
        }
        value = this.new_;
        value_json = this.model.constructor._value_to_json(this.attr, value, this.model);
        value_refs = {};
        has_props_1.HasProps._value_record_references(value, value_refs, true);
        if (this.model.id in value_refs && this.model !== value) {
            delete value_refs[this.model.id];
        }
        for (id in value_refs) {
            references[id] = value_refs[id];
        }
        return {
            'kind': 'ModelChanged',
            'model': this.model.ref(),
            'attr': this.attr,
            'new': value_json
        };
    };
    return ModelChangedEvent;
})(exports.DocumentChangedEvent);
exports.TitleChangedEvent = (function (superClass) {
    extend1(TitleChangedEvent, superClass);
    function TitleChangedEvent(document1, title1, setter_id1) {
        this.document = document1;
        this.title = title1;
        this.setter_id = setter_id1;
        TitleChangedEvent.__super__.constructor.call(this, this.document);
    }
    TitleChangedEvent.prototype.json = function (references) {
        return {
            'kind': 'TitleChanged',
            'title': this.title
        };
    };
    return TitleChangedEvent;
})(exports.DocumentChangedEvent);
exports.RootAddedEvent = (function (superClass) {
    extend1(RootAddedEvent, superClass);
    function RootAddedEvent(document1, model1, setter_id1) {
        this.document = document1;
        this.model = model1;
        this.setter_id = setter_id1;
        RootAddedEvent.__super__.constructor.call(this, this.document);
    }
    RootAddedEvent.prototype.json = function (references) {
        has_props_1.HasProps._value_record_references(this.model, references, true);
        return {
            'kind': 'RootAdded',
            'model': this.model.ref()
        };
    };
    return RootAddedEvent;
})(exports.DocumentChangedEvent);
exports.RootRemovedEvent = (function (superClass) {
    extend1(RootRemovedEvent, superClass);
    function RootRemovedEvent(document1, model1, setter_id1) {
        this.document = document1;
        this.model = model1;
        this.setter_id = setter_id1;
        RootRemovedEvent.__super__.constructor.call(this, this.document);
    }
    RootRemovedEvent.prototype.json = function (references) {
        return {
            'kind': 'RootRemoved',
            'model': this.model.ref()
        };
    };
    return RootRemovedEvent;
})(exports.DocumentChangedEvent);
exports.DEFAULT_TITLE = "Bokeh Application";
exports.Document = (function () {
    function Document() {
        this._title = exports.DEFAULT_TITLE;
        this._roots = [];
        this._all_models = {};
        this._all_models_by_name = new data_structures_1.MultiDict();
        this._all_models_freeze_count = 0;
        this._callbacks = [];
        this._doc_width = new solver_1.Variable("document_width");
        this._doc_height = new solver_1.Variable("document_height");
        this._solver = new solver_1.Solver();
        this._init_solver();
        this.event_manager = new EventManager(this);
        window.addEventListener("resize", (function (_this) {
            return function () {
                return _this.resize();
            };
        })(this));
    }
    Document.prototype._init_solver = function () {
        var j, len, model, ref1, results;
        this._solver.clear();
        this._solver.add_edit_variable(this._doc_width);
        this._solver.add_edit_variable(this._doc_height);
        ref1 = this._roots;
        results = [];
        for (j = 0, len = ref1.length; j < len; j++) {
            model = ref1[j];
            if (model.layoutable) {
                results.push(this._add_layoutable(model));
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    Document.prototype.solver = function () {
        return this._solver;
    };
    Document.prototype.resize = function (width, height) {
        if (width == null) {
            width = null;
        }
        if (height == null) {
            height = null;
        }
        this._resize(width, height);
        return this._resize(width, height);
    };
    Document.prototype._resize = function (width, height) {
        var j, len, measuring, ref1, ref2, root, root_div, vars;
        if (width == null) {
            width = null;
        }
        if (height == null) {
            height = null;
        }
        ref1 = this._roots;
        for (j = 0, len = ref1.length; j < len; j++) {
            root = ref1[j];
            if (root.layoutable !== true) {
                continue;
            }
            vars = root.get_constrained_variables();
            if ((vars.width == null) && (vars.height == null)) {
                continue;
            }
            root_div = document.getElementById("modelid_" + root.id);
            if ((root_div != null) && width === null) {
                measuring = root_div;
                while (true) {
                    measuring = measuring.parentNode;
                    ref2 = measuring.getBoundingClientRect(), width = ref2.width, height = ref2.height;
                    if (height !== 0) {
                        break;
                    }
                }
            }
            if (vars.width != null) {
                logging_1.logger.debug("Suggest width on Document -- " + width);
                this._solver.suggest_value(this._doc_width, width);
            }
            if (vars.height != null) {
                logging_1.logger.debug("Suggest height on Document -- " + height);
                this._solver.suggest_value(this._doc_height, height);
            }
        }
        this._solver.update_variables(false);
        return this._solver.trigger('resize');
    };
    Document.prototype.clear = function () {
        var results;
        this._push_all_models_freeze();
        try {
            results = [];
            while (this._roots.length > 0) {
                results.push(this.remove_root(this._roots[0]));
            }
            return results;
        }
        finally {
            this._pop_all_models_freeze();
        }
    };
    Document.prototype.destructively_move = function (dest_doc) {
        var j, l, len, len1, len2, n, r, ref1, roots;
        if (dest_doc === this) {
            throw new Error("Attempted to overwrite a document with itself");
        }
        dest_doc.clear();
        roots = [];
        ref1 = this._roots;
        for (j = 0, len = ref1.length; j < len; j++) {
            r = ref1[j];
            roots.push(r);
        }
        this.clear();
        for (l = 0, len1 = roots.length; l < len1; l++) {
            r = roots[l];
            if (r.document !== null) {
                throw new Error("Somehow we didn't detach " + r);
            }
        }
        if (Object.keys(this._all_models).length !== 0) {
            throw new Error("@_all_models still had stuff in it: " + this._all_models);
        }
        for (n = 0, len2 = roots.length; n < len2; n++) {
            r = roots[n];
            dest_doc.add_root(r);
        }
        return dest_doc.set_title(this._title);
    };
    Document.prototype._push_all_models_freeze = function () {
        return this._all_models_freeze_count += 1;
    };
    Document.prototype._pop_all_models_freeze = function () {
        this._all_models_freeze_count -= 1;
        if (this._all_models_freeze_count === 0) {
            return this._recompute_all_models();
        }
    };
    Document.prototype._invalidate_all_models = function () {
        logging_1.logger.debug("invalidating document models");
        if (this._all_models_freeze_count === 0) {
            return this._recompute_all_models();
        }
    };
    Document.prototype._recompute_all_models = function () {
        var a, d, j, l, len, len1, len2, len3, m, n, name, new_all_models_set, o, old_all_models_set, r, recomputed, ref1, ref2, ref3, ref4, to_attach, to_detach;
        new_all_models_set = new data_structures_1.Set();
        ref1 = this._roots;
        for (j = 0, len = ref1.length; j < len; j++) {
            r = ref1[j];
            new_all_models_set = new_all_models_set.union(r.references());
        }
        old_all_models_set = new data_structures_1.Set(object_1.values(this._all_models));
        to_detach = old_all_models_set.diff(new_all_models_set);
        to_attach = new_all_models_set.diff(old_all_models_set);
        recomputed = {};
        ref2 = new_all_models_set.values;
        for (l = 0, len1 = ref2.length; l < len1; l++) {
            m = ref2[l];
            recomputed[m.id] = m;
        }
        ref3 = to_detach.values;
        for (n = 0, len2 = ref3.length; n < len2; n++) {
            d = ref3[n];
            d.detach_document();
            name = d.name;
            if (name !== null) {
                this._all_models_by_name.remove_value(name, d);
            }
        }
        ref4 = to_attach.values;
        for (o = 0, len3 = ref4.length; o < len3; o++) {
            a = ref4[o];
            a.attach_document(this);
            name = a.name;
            if (name !== null) {
                this._all_models_by_name.add_value(name, a);
            }
        }
        return this._all_models = recomputed;
    };
    Document.prototype.roots = function () {
        return this._roots;
    };
    Document.prototype._add_layoutable = function (model) {
        var constraint, constraints, edit_variable, editables, j, l, len, len1, ref1, strength, vars;
        if (model.layoutable !== true) {
            throw new Error("Cannot add non-layoutable - " + model);
        }
        editables = model.get_edit_variables();
        constraints = model.get_constraints();
        vars = model.get_constrained_variables();
        for (j = 0, len = editables.length; j < len; j++) {
            ref1 = editables[j], edit_variable = ref1.edit_variable, strength = ref1.strength;
            this._solver.add_edit_variable(edit_variable, strength);
        }
        for (l = 0, len1 = constraints.length; l < len1; l++) {
            constraint = constraints[l];
            this._solver.add_constraint(constraint);
        }
        if (vars.width != null) {
            this._solver.add_constraint(solver_1.EQ(vars.width, this._doc_width));
        }
        if (vars.height != null) {
            this._solver.add_constraint(solver_1.EQ(vars.height, this._doc_height));
        }
        return this._solver.update_variables();
    };
    Document.prototype.add_root = function (model, setter_id) {
        logging_1.logger.debug("Adding root: " + model);
        if (indexOf.call(this._roots, model) >= 0) {
            return;
        }
        this._push_all_models_freeze();
        try {
            this._roots.push(model);
            model._is_root = true;
        }
        finally {
            this._pop_all_models_freeze();
        }
        this._init_solver();
        return this._trigger_on_change(new exports.RootAddedEvent(this, model, setter_id));
    };
    Document.prototype.remove_root = function (model, setter_id) {
        var i;
        i = this._roots.indexOf(model);
        if (i < 0) {
            return;
        }
        this._push_all_models_freeze();
        try {
            this._roots.splice(i, 1);
            model._is_root = false;
        }
        finally {
            this._pop_all_models_freeze();
        }
        this._init_solver();
        return this._trigger_on_change(new exports.RootRemovedEvent(this, model, setter_id));
    };
    Document.prototype.title = function () {
        return this._title;
    };
    Document.prototype.set_title = function (title, setter_id) {
        if (title !== this._title) {
            this._title = title;
            return this._trigger_on_change(new exports.TitleChangedEvent(this, title, setter_id));
        }
    };
    Document.prototype.get_model_by_id = function (model_id) {
        if (model_id in this._all_models) {
            return this._all_models[model_id];
        }
        else {
            return null;
        }
    };
    Document.prototype.get_model_by_name = function (name) {
        return this._all_models_by_name.get_one(name, "Multiple models are named '" + name + "'");
    };
    Document.prototype.on_change = function (callback) {
        if (indexOf.call(this._callbacks, callback) >= 0) {
            return;
        }
        return this._callbacks.push(callback);
    };
    Document.prototype.remove_on_change = function (callback) {
        var i;
        i = this._callbacks.indexOf(callback);
        if (i >= 0) {
            return this._callbacks.splice(i, 1);
        }
    };
    Document.prototype._trigger_on_change = function (event) {
        var cb, j, len, ref1, results;
        ref1 = this._callbacks;
        results = [];
        for (j = 0, len = ref1.length; j < len; j++) {
            cb = ref1[j];
            results.push(cb(event));
        }
        return results;
    };
    Document.prototype._notify_change = function (model, attr, old, new_, options) {
        if (attr === 'name') {
            this._all_models_by_name.remove_value(old, model);
            if (new_ !== null) {
                this._all_models_by_name.add_value(new_, model);
            }
        }
        return this._trigger_on_change(new exports.ModelChangedEvent(this, model, attr, old, new_, options != null ? options.setter_id : void 0));
    };
    Document._references_json = function (references, include_defaults) {
        var j, len, r, ref, references_json;
        if (include_defaults == null) {
            include_defaults = true;
        }
        references_json = [];
        for (j = 0, len = references.length; j < len; j++) {
            r = references[j];
            ref = r.ref();
            ref['attributes'] = r.attributes_as_json(include_defaults);
            delete ref['attributes']['id'];
            references_json.push(ref);
        }
        return references_json;
    };
    Document._instantiate_object = function (obj_id, obj_type, obj_attrs) {
        var full_attrs, model;
        full_attrs = object_1.extend({}, obj_attrs, {
            id: obj_id
        });
        model = base_1.Models(obj_type);
        return new model(full_attrs, {
            silent: true,
            defer_initialization: true
        });
    };
    Document._instantiate_references_json = function (references_json, existing_models) {
        var instance, j, len, obj, obj_attrs, obj_id, obj_type, references;
        references = {};
        for (j = 0, len = references_json.length; j < len; j++) {
            obj = references_json[j];
            obj_id = obj['id'];
            obj_type = obj['type'];
            obj_attrs = obj['attributes'];
            if (obj_id in existing_models) {
                instance = existing_models[obj_id];
            }
            else {
                instance = Document._instantiate_object(obj_id, obj_type, obj_attrs);
                if ('subtype' in obj) {
                    instance.set_subtype(obj['subtype']);
                }
            }
            references[instance.id] = instance;
        }
        return references;
    };
    Document._resolve_refs = function (value, old_references, new_references) {
        var resolve_array, resolve_dict, resolve_ref;
        resolve_ref = function (v) {
            if (refs_1.is_ref(v)) {
                if (v['id'] in old_references) {
                    return old_references[v['id']];
                }
                else if (v['id'] in new_references) {
                    return new_references[v['id']];
                }
                else {
                    throw new Error("reference " + (JSON.stringify(v)) + " isn't known (not in Document?)");
                }
            }
            else if (types_1.isArray(v)) {
                return resolve_array(v);
            }
            else if (types_1.isObject(v)) {
                return resolve_dict(v);
            }
            else {
                return v;
            }
        };
        resolve_dict = function (dict) {
            var k, resolved, v;
            resolved = {};
            for (k in dict) {
                v = dict[k];
                resolved[k] = resolve_ref(v);
            }
            return resolved;
        };
        resolve_array = function (array) {
            var j, len, results, v;
            results = [];
            for (j = 0, len = array.length; j < len; j++) {
                v = array[j];
                results.push(resolve_ref(v));
            }
            return results;
        };
        return resolve_ref(value);
    };
    Document._initialize_references_json = function (references_json, old_references, new_references) {
        var foreach_depth_first, instance, j, len, obj, obj_attrs, obj_id, to_update, was_new;
        to_update = {};
        for (j = 0, len = references_json.length; j < len; j++) {
            obj = references_json[j];
            obj_id = obj['id'];
            obj_attrs = obj['attributes'];
            was_new = false;
            instance = obj_id in old_references ? old_references[obj_id] : (was_new = true, new_references[obj_id]);
            obj_attrs = Document._resolve_refs(obj_attrs, old_references, new_references);
            to_update[instance.id] = [instance, obj_attrs, was_new];
        }
        foreach_depth_first = function (items, f) {
            var already_started, foreach_value, k, results, v;
            already_started = {};
            foreach_value = function (v, f) {
                var a, attrs, e, k, l, len1, ref1, results, results1, same_as_v;
                if (v instanceof has_props_1.HasProps) {
                    if (!(v.id in already_started) && v.id in items) {
                        already_started[v.id] = true;
                        ref1 = items[v.id], same_as_v = ref1[0], attrs = ref1[1], was_new = ref1[2];
                        for (a in attrs) {
                            e = attrs[a];
                            foreach_value(e, f);
                        }
                        return f(v, attrs, was_new);
                    }
                }
                else if (types_1.isArray(v)) {
                    results = [];
                    for (l = 0, len1 = v.length; l < len1; l++) {
                        e = v[l];
                        results.push(foreach_value(e, f));
                    }
                    return results;
                }
                else if (types_1.isObject(v)) {
                    results1 = [];
                    for (k in v) {
                        e = v[k];
                        results1.push(foreach_value(e, f));
                    }
                    return results1;
                }
            };
            results = [];
            for (k in items) {
                v = items[k];
                results.push(foreach_value(v[0], f));
            }
            return results;
        };
        foreach_depth_first(to_update, function (instance, attrs, was_new) {
            if (was_new) {
                return instance.setv(attrs);
            }
        });
        return foreach_depth_first(to_update, function (instance, attrs, was_new) {
            if (was_new) {
                return instance.initialize(attrs);
            }
        });
    };
    Document._event_for_attribute_change = function (changed_obj, key, new_value, doc, value_refs) {
        var changed_model, event;
        changed_model = doc.get_model_by_id(changed_obj.id);
        if (!changed_model.attribute_is_serializable(key)) {
            return null;
        }
        event = {
            'kind': 'ModelChanged',
            'model': {
                id: changed_obj.id,
                type: changed_obj.type
            },
            'attr': key,
            'new': new_value
        };
        has_props_1.HasProps._json_record_references(doc, new_value, value_refs, true);
        return event;
    };
    Document._events_to_sync_objects = function (from_obj, to_obj, to_doc, value_refs) {
        var added, events, from_keys, j, key, l, len, len1, len2, n, new_value, old_value, removed, shared, to_keys;
        from_keys = Object.keys(from_obj.attributes);
        to_keys = Object.keys(to_obj.attributes);
        removed = array_1.difference(from_keys, to_keys);
        added = array_1.difference(to_keys, from_keys);
        shared = array_1.intersection(from_keys, to_keys);
        events = [];
        for (j = 0, len = removed.length; j < len; j++) {
            key = removed[j];
            logging_1.logger.warn("Server sent key " + key + " but we don't seem to have it in our JSON");
        }
        for (l = 0, len1 = added.length; l < len1; l++) {
            key = added[l];
            new_value = to_obj.attributes[key];
            events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
        }
        for (n = 0, len2 = shared.length; n < len2; n++) {
            key = shared[n];
            old_value = from_obj.attributes[key];
            new_value = to_obj.attributes[key];
            if (old_value === null && new_value === null) {
            }
            else if (old_value === null || new_value === null) {
                events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
            }
            else {
                if (!eq_1.isEqual(old_value, new_value)) {
                    events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                }
            }
        }
        return events.filter(function (e) {
            return e !== null;
        });
    };
    Document._compute_patch_since_json = function (from_json, to_doc) {
        var events, from_references, from_root_ids, from_roots, id, include_defaults, j, l, len, len1, model, r, ref1, ref2, ref3, refs, to_json, to_references, to_root_ids, to_roots, update_model_events, value_refs;
        to_json = to_doc.to_json(include_defaults = false);
        refs = function (json) {
            var j, len, obj, ref1, result;
            result = {};
            ref1 = json['roots']['references'];
            for (j = 0, len = ref1.length; j < len; j++) {
                obj = ref1[j];
                result[obj.id] = obj;
            }
            return result;
        };
        from_references = refs(from_json);
        from_roots = {};
        from_root_ids = [];
        ref1 = from_json['roots']['root_ids'];
        for (j = 0, len = ref1.length; j < len; j++) {
            r = ref1[j];
            from_roots[r] = from_references[r];
            from_root_ids.push(r);
        }
        to_references = refs(to_json);
        to_roots = {};
        to_root_ids = [];
        ref2 = to_json['roots']['root_ids'];
        for (l = 0, len1 = ref2.length; l < len1; l++) {
            r = ref2[l];
            to_roots[r] = to_references[r];
            to_root_ids.push(r);
        }
        from_root_ids.sort();
        to_root_ids.sort();
        if (array_1.difference(from_root_ids, to_root_ids).length > 0 || array_1.difference(to_root_ids, from_root_ids).length > 0) {
            throw new Error("Not implemented: computing add/remove of document roots");
        }
        value_refs = {};
        events = [];
        ref3 = to_doc._all_models;
        for (id in ref3) {
            model = ref3[id];
            if (id in from_references) {
                update_model_events = Document._events_to_sync_objects(from_references[id], to_references[id], to_doc, value_refs);
                events = events.concat(update_model_events);
            }
        }
        return {
            'events': events,
            'references': Document._references_json(object_1.values(value_refs), include_defaults = false)
        };
    };
    Document.prototype.to_json_string = function (include_defaults) {
        if (include_defaults == null) {
            include_defaults = true;
        }
        return JSON.stringify(this.to_json(include_defaults));
    };
    Document.prototype.to_json = function (include_defaults) {
        var j, len, r, ref1, root_ids, root_references;
        if (include_defaults == null) {
            include_defaults = true;
        }
        root_ids = [];
        ref1 = this._roots;
        for (j = 0, len = ref1.length; j < len; j++) {
            r = ref1[j];
            root_ids.push(r.id);
        }
        root_references = object_1.values(this._all_models);
        return {
            'title': this._title,
            'roots': {
                'root_ids': root_ids,
                'references': Document._references_json(root_references, include_defaults)
            }
        };
    };
    Document.from_json_string = function (s) {
        var json;
        if (s === null || (s == null)) {
            throw new Error("JSON string is " + (typeof s));
        }
        json = JSON.parse(s);
        return Document.from_json(json);
    };
    Document.from_json = function (json) {
        var doc, is_dev, j, len, py_version, r, references, references_json, root_ids, roots_json, versions_string;
        logging_1.logger.debug("Creating Document from JSON");
        if (typeof json !== 'object') {
            throw new Error("JSON object has wrong type " + (typeof json));
        }
        py_version = json['version'];
        is_dev = py_version.indexOf('+') !== -1 || py_version.indexOf('-') !== -1;
        versions_string = "Library versions: JS (" + version_1.version + ")  /  Python (" + py_version + ")";
        if (!is_dev && version_1.version !== py_version) {
            logging_1.logger.warn("JS/Python version mismatch");
            logging_1.logger.warn(versions_string);
        }
        else {
            logging_1.logger.debug(versions_string);
        }
        roots_json = json['roots'];
        root_ids = roots_json['root_ids'];
        references_json = roots_json['references'];
        references = Document._instantiate_references_json(references_json, {});
        Document._initialize_references_json(references_json, {}, references);
        doc = new Document();
        for (j = 0, len = root_ids.length; j < len; j++) {
            r = root_ids[j];
            doc.add_root(references[r]);
        }
        doc.set_title(json['title']);
        return doc;
    };
    Document.prototype.replace_with_json = function (json) {
        var replacement;
        replacement = Document.from_json(json);
        return replacement.destructively_move(this);
    };
    Document.prototype.create_json_patch_string = function (events) {
        return JSON.stringify(this.create_json_patch(events));
    };
    Document.prototype.create_json_patch = function (events) {
        var event, j, json_events, len, references, result;
        references = {};
        json_events = [];
        for (j = 0, len = events.length; j < len; j++) {
            event = events[j];
            if (event.document !== this) {
                logging_1.logger.warn("Cannot create a patch using events from a different document, event had ", event.document, " we are ", this);
                throw new Error("Cannot create a patch using events from a different document");
            }
            json_events.push(event.json(references));
        }
        return result = {
            events: json_events,
            references: Document._references_json(object_1.values(references))
        };
    };
    Document.prototype.apply_json_patch_string = function (patch) {
        return this.apply_json_patch(JSON.parse(patch));
    };
    Document.prototype.apply_json_patch = function (patch, setter_id) {
        var attr, column_source, column_source_id, data, event_json, events_json, id, j, l, len, len1, model_id, model_type, new_references, obj1, old_references, patched_id, patched_obj, patches, ref1, references, references_json, results, rollover, root_id, root_obj, shapes, value;
        references_json = patch['references'];
        events_json = patch['events'];
        references = Document._instantiate_references_json(references_json, this._all_models);
        for (j = 0, len = events_json.length; j < len; j++) {
            event_json = events_json[j];
            if ('model' in event_json) {
                model_id = event_json['model']['id'];
                if (model_id in this._all_models) {
                    references[model_id] = this._all_models[model_id];
                }
                else {
                    if (!(model_id in references)) {
                        logging_1.logger.warn("Got an event for unknown model ", event_json['model']);
                        throw new Error("event model wasn't known");
                    }
                }
            }
        }
        old_references = {};
        new_references = {};
        for (id in references) {
            value = references[id];
            if (id in this._all_models) {
                old_references[id] = value;
            }
            else {
                new_references[id] = value;
            }
        }
        Document._initialize_references_json(references_json, old_references, new_references);
        results = [];
        for (l = 0, len1 = events_json.length; l < len1; l++) {
            event_json = events_json[l];
            switch (event_json.kind) {
                case 'ModelChanged':
                    patched_id = event_json['model']['id'];
                    if (!(patched_id in this._all_models)) {
                        throw new Error("Cannot apply patch to " + patched_id + " which is not in the document");
                    }
                    patched_obj = this._all_models[patched_id];
                    attr = event_json['attr'];
                    model_type = event_json['model']['type'];
                    if (attr === 'data' && model_type === 'ColumnDataSource') {
                        ref1 = serialization_1.decode_column_data(event_json['new']), data = ref1[0], shapes = ref1[1];
                        results.push(patched_obj.setv({
                            _shapes: shapes,
                            data: data
                        }, {
                            setter_id: setter_id
                        }));
                    }
                    else {
                        value = Document._resolve_refs(event_json['new'], old_references, new_references);
                        results.push(patched_obj.setv((obj1 = {},
                            obj1["" + attr] = value,
                            obj1), {
                            setter_id: setter_id
                        }));
                    }
                    break;
                case 'ColumnsStreamed':
                    column_source_id = event_json['column_source']['id'];
                    if (!(column_source_id in this._all_models)) {
                        throw new Error("Cannot stream to " + column_source_id + " which is not in the document");
                    }
                    column_source = this._all_models[column_source_id];
                    if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                        throw new Error("Cannot stream to non-ColumnDataSource");
                    }
                    data = event_json['data'];
                    rollover = event_json['rollover'];
                    results.push(column_source.stream(data, rollover));
                    break;
                case 'ColumnsPatched':
                    column_source_id = event_json['column_source']['id'];
                    if (!(column_source_id in this._all_models)) {
                        throw new Error("Cannot patch " + column_source_id + " which is not in the document");
                    }
                    column_source = this._all_models[column_source_id];
                    if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                        throw new Error("Cannot patch non-ColumnDataSource");
                    }
                    patches = event_json['patches'];
                    results.push(column_source.patch(patches));
                    break;
                case 'RootAdded':
                    root_id = event_json['model']['id'];
                    root_obj = references[root_id];
                    results.push(this.add_root(root_obj, setter_id));
                    break;
                case 'RootRemoved':
                    root_id = event_json['model']['id'];
                    root_obj = references[root_id];
                    results.push(this.remove_root(root_obj, setter_id));
                    break;
                case 'TitleChanged':
                    results.push(this.set_title(event_json['title'], setter_id));
                    break;
                default:
                    throw new Error("Unknown patch event " + JSON.stringify(event_json));
            }
        }
        return results;
    };
    return Document;
})();

},{"./base":"base","./core/has_props":"core/has_props","./core/layout/solver":"core/layout/solver","./core/logging":"core/logging","./core/util/array":"core/util/array","./core/util/data_structures":"core/util/data_structures","./core/util/eq":"core/util/eq","./core/util/object":"core/util/object","./core/util/refs":"core/util/refs","./core/util/serialization":"core/util/serialization","./core/util/types":"core/util/types","./models/sources/column_data_source":"models/sources/column_data_source","./version":"version"}],"embed":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var _create_view, _get_session, _handle_notebook_comms, _init_comms, _render_document_to_element, _sessions, _update_comms_callback, add_document_from_session, add_model_from_session, add_model_static, fill_render_item_from_script_tag;
var base = require("./base");
var client_1 = require("./client");
var logging_1 = require("./core/logging");
var document_1 = require("./document");
var dom_1 = require("./core/dom");
var callback_1 = require("./core/util/callback");
exports.BOKEH_ROOT = "bk-root";
_handle_notebook_comms = function (msg) {
    var data;
    logging_1.logger.debug("handling notebook comms");
    data = JSON.parse(msg.content.data);
    if ('events' in data && 'references' in data) {
        return this.apply_json_patch(data);
    }
    else if ('doc' in data) {
        return this.replace_with_json(data['doc']);
    }
    else {
        throw new Error("handling notebook comms message: ", msg);
    }
};
_update_comms_callback = function (target, doc, comm) {
    if (target === comm.target_name) {
        return comm.on_msg(_handle_notebook_comms.bind(doc));
    }
};
_init_comms = function (target, doc) {
    var comm_manager, e, id, promise, ref, update_comms;
    if ((typeof Jupyter !== "undefined" && Jupyter !== null) && (Jupyter.notebook.kernel != null)) {
        logging_1.logger.info("Registering Jupyter comms for target " + target);
        comm_manager = Jupyter.notebook.kernel.comm_manager;
        update_comms = function (comm) {
            return _update_comms_callback(target, doc, comm);
        };
        ref = comm_manager.comms;
        for (id in ref) {
            promise = ref[id];
            promise.then(update_comms);
        }
        try {
            return comm_manager.register_target(target, function (comm, msg) {
                logging_1.logger.info("Registering Jupyter comms for target " + target);
                return comm.on_msg(_handle_notebook_comms.bind(doc));
            });
        }
        catch (error1) {
            e = error1;
            return logging_1.logger.warn("Jupyter comms failed to register. push_notebook() will not function. (exception reported: " + e + ")");
        }
    }
    else {
        return console.warn('Jupyter notebooks comms not available. push_notebook() will not function');
    }
};
_create_view = function (model) {
    var view;
    view = new model.default_view({
        model: model
    });
    base.index[model.id] = view;
    return view;
};
_render_document_to_element = function (element, document, use_for_title) {
    var i, len, model, ref, render_model, unrender_model, views;
    views = {};
    render_model = function (model) {
        var view;
        view = _create_view(model);
        views[model.id] = view;
        return element.appendChild(view.el);
    };
    unrender_model = function (model) {
        var view;
        if (model.id in views) {
            view = views[model.id];
            element.removeChild(view.el);
            delete views[model.id];
            return delete base.index[model.id];
        }
    };
    ref = document.roots();
    for (i = 0, len = ref.length; i < len; i++) {
        model = ref[i];
        render_model(model);
    }
    if (use_for_title) {
        window.document.title = document.title();
    }
    document.on_change(function (event) {
        if (event instanceof document_1.RootAddedEvent) {
            return render_model(event.model);
        }
        else if (event instanceof document_1.RootRemovedEvent) {
            return unrender_model(event.model);
        }
        else if (use_for_title && event instanceof document_1.TitleChangedEvent) {
            return window.document.title = event.title;
        }
    });
    return views;
};
add_model_static = function (element, model_id, doc) {
    var model, view;
    model = doc.get_model_by_id(model_id);
    if (model == null) {
        throw new Error("Model " + model_id + " was not in document " + doc);
    }
    view = _create_view(model);
    return callback_1.delay(function () {
        return dom_1.replaceWith(element, view.el);
    });
};
exports.add_document_static = function (element, doc, use_for_title) {
    return callback_1.delay(function () {
        return _render_document_to_element(element, doc, use_for_title);
    });
};
exports.add_document_standalone = function (document, element, use_for_title) {
    if (use_for_title == null) {
        use_for_title = false;
    }
    return _render_document_to_element(element, document, use_for_title);
};
_sessions = {};
_get_session = function (websocket_url, session_id, args_string) {
    var subsessions;
    if ((websocket_url == null) || websocket_url === null) {
        throw new Error("Missing websocket_url");
    }
    if (!(websocket_url in _sessions)) {
        _sessions[websocket_url] = {};
    }
    subsessions = _sessions[websocket_url];
    if (!(session_id in subsessions)) {
        subsessions[session_id] = client_1.pull_session(websocket_url, session_id, args_string);
    }
    return subsessions[session_id];
};
add_document_from_session = function (element, websocket_url, session_id, use_for_title) {
    var args_string, promise;
    args_string = window.location.search.substr(1);
    promise = _get_session(websocket_url, session_id, args_string);
    return promise.then(function (session) {
        return _render_document_to_element(element, session.document, use_for_title);
    }, function (error) {
        logging_1.logger.error("Failed to load Bokeh session " + session_id + ": " + error);
        throw error;
    });
};
add_model_from_session = function (element, websocket_url, model_id, session_id) {
    var args_string, promise;
    args_string = window.location.search.substr(1);
    promise = _get_session(websocket_url, session_id, args_string);
    return promise.then(function (session) {
        var model, view;
        model = session.document.get_model_by_id(model_id);
        if (model == null) {
            throw new Error("Did not find model " + model_id + " in session");
        }
        view = _create_view(model);
        return dom_1.replaceWith(element, view.el);
    }, function (error) {
        logging_1.logger.error("Failed to load Bokeh session " + session_id + ": " + error);
        throw error;
    });
};
exports.inject_css = function (url) {
    var element;
    element = dom_1.link({
        href: url,
        rel: "stylesheet",
        type: "text/css"
    });
    return document.body.appendChild(element);
};
exports.inject_raw_css = function (css) {
    var element;
    element = dom_1.style({}, css);
    return document.body.appendChild(element);
};
fill_render_item_from_script_tag = function (script, item) {
    var info;
    info = script.dataset;
    if ((info.bokehLogLevel != null) && info.bokehLogLevel.length > 0) {
        logging_1.set_log_level(info.bokehLogLevel);
    }
    if ((info.bokehDocId != null) && info.bokehDocId.length > 0) {
        item['docid'] = info.bokehDocId;
    }
    if ((info.bokehModelId != null) && info.bokehModelId.length > 0) {
        item['modelid'] = info.bokehModelId;
    }
    if ((info.bokehSessionId != null) && info.bokehSessionId.length > 0) {
        item['sessionid'] = info.bokehSessionId;
    }
    return logging_1.logger.info("Will inject Bokeh script tag with params " + (JSON.stringify(item)));
};
exports.embed_items = function (docs_json, render_items, app_path, absolute_url) {
    var child, container, docid, docs, elem, element_id, i, item, len, loc, promise, protocol, results, use_for_title, websocket_url;
    protocol = 'ws:';
    if (window.location.protocol === 'https:') {
        protocol = 'wss:';
    }
    if (absolute_url != null) {
        loc = new URL(absolute_url);
    }
    else {
        loc = window.location;
    }
    if (app_path != null) {
        if (app_path === "/") {
            app_path = "";
        }
    }
    else {
        app_path = loc.pathname.replace(/\/+$/, '');
    }
    websocket_url = protocol + '//' + loc.host + app_path + '/ws';
    logging_1.logger.debug("embed: computed ws url: " + websocket_url);
    docs = {};
    for (docid in docs_json) {
        docs[docid] = document_1.Document.from_json(docs_json[docid]);
    }
    results = [];
    for (i = 0, len = render_items.length; i < len; i++) {
        item = render_items[i];
        if (item.notebook_comms_target != null) {
            _init_comms(item.notebook_comms_target, docs[docid]);
        }
        element_id = item['elementid'];
        elem = document.getElementById(element_id);
        if (elem == null) {
            throw new Error("Error rendering Bokeh model: could not find tag with id: " + element_id);
        }
        if (!document.body.contains(elem)) {
            throw new Error("Error rendering Bokeh model: element with id '" + element_id + "' must be under <body>");
        }
        if (elem.tagName === "SCRIPT") {
            fill_render_item_from_script_tag(elem, item);
            container = dom_1.div({
                "class": exports.BOKEH_ROOT
            });
            dom_1.replaceWith(elem, container);
            child = dom_1.div();
            container.appendChild(child);
            elem = child;
        }
        use_for_title = (item.use_for_title != null) && item.use_for_title;
        promise = null;
        if (item.modelid != null) {
            if (item.docid != null) {
                add_model_static(elem, item.modelid, docs[item.docid]);
            }
            else if (item.sessionid != null) {
                promise = add_model_from_session(elem, websocket_url, item.modelid, item.sessionid);
            }
            else {
                throw new Error("Error rendering Bokeh model " + item['modelid'] + " to element " + element_id + ": no document ID or session ID specified");
            }
        }
        else {
            if (item.docid != null) {
                exports.add_document_static(elem, docs[item.docid], use_for_title);
            }
            else if (item.sessionid != null) {
                promise = add_document_from_session(elem, websocket_url, item.sessionid, use_for_title);
            }
            else {
                throw new Error("Error rendering Bokeh document to element " + element_id + ": no document ID or session ID specified");
            }
        }
        if (promise !== null) {
            results.push(promise.then(function (value) {
                return console.log("Bokeh items were rendered successfully");
            }, function (error) {
                return console.log("Error rendering Bokeh items ", error);
            }));
        }
        else {
            results.push(void 0);
        }
    }
    return results;
};

},{"./base":"base","./client":"client","./core/dom":"core/dom","./core/logging":"core/logging","./core/util/callback":"core/util/callback","./document":"document"}],"main":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var version_1 = require("./version");
exports.version = version_1.version;
var embed = require("./embed");
exports.embed = embed;
var logging_1 = require("./core/logging");
exports.logger = logging_1.logger;
exports.set_log_level = logging_1.set_log_level;
var base_1 = require("./base");
exports.Models = base_1.Models;
exports.index = base_1.index;
var safely_1 = require("./safely");
exports.safely = safely_1.safely;

},{"./base":"base","./core/logging":"core/logging","./embed":"embed","./safely":"safely","./version":"version"}],"model":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var has_props_1 = require("./core/has_props");
var p = require("./core/properties");
var types_1 = require("./core/util/types");
var object_1 = require("./core/util/object");
var logging_1 = require("./core/logging");
exports.Model = (function (superClass) {
    extend(Model, superClass);
    function Model() {
        return Model.__super__.constructor.apply(this, arguments);
    }
    Model.prototype.type = "Model";
    Model.define({
        tags: [p.Array, []],
        name: [p.String],
        js_property_callbacks: [p.Any, {}],
        js_event_callbacks: [p.Any, {}],
        subscribed_events: [p.Array, []]
    });
    Model.prototype.initialize = function (options) {
        var callbacks, cb, evt, i, len, ref1;
        Model.__super__.initialize.call(this, options);
        ref1 = this.js_property_callbacks;
        for (evt in ref1) {
            callbacks = ref1[evt];
            for (i = 0, len = callbacks.length; i < len; i++) {
                cb = callbacks[i];
                this.listenTo(this, evt, function () {
                    return cb.execute(this);
                });
            }
        }
        this.listenTo(this, 'change:js_event_callbacks', function () {
            return this._update_event_callbacks;
        });
        return this.listenTo(this, 'change:subscribed_events', function () {
            return this._update_event_callbacks;
        });
    };
    Model.prototype._process_event = function (event) {
        var callback, i, len, ref1, ref2;
        if (event.is_applicable_to(this)) {
            event = event._customize_event(this);
            ref2 = (ref1 = this.js_event_callbacks[event.event_name]) != null ? ref1 : [];
            for (i = 0, len = ref2.length; i < len; i++) {
                callback = ref2[i];
                callback.execute(event, {});
            }
            if (this.subscribed_events.some(function (m) {
                return m === event.event_name;
            })) {
                return this.document.event_manager.send_event(event);
            }
        }
    };
    Model.prototype.trigger_event = function (event) {
        var ref1;
        return (ref1 = this.document) != null ? ref1.event_manager.trigger(event.set_model_id(this.id)) : void 0;
    };
    Model.prototype._update_event_callbacks = function () {
        if (this.document == null) {
            logging_1.logger.warn('WARNING: Document not defined for updating event callbacks');
            return;
        }
        return this.document.event_manager.subscribed_models.push(this.id);
    };
    Model.prototype._doc_attached = function () {
        if (!object_1.isEmpty(this.js_event_callbacks) || !object_1.isEmpty(this.subscribed_events)) {
            return this._update_event_callbacks();
        }
    };
    Model.prototype.select = function (selector) {
        if (selector.prototype instanceof Model) {
            return this.references().filter(function (ref) {
                return ref instanceof selector;
            });
        }
        else if (types_1.isString(selector)) {
            return this.references().filter(function (ref) {
                return ref.name === selector;
            });
        }
        else {
            throw new Error("invalid selector");
        }
    };
    Model.prototype.select_one = function (selector) {
        var result;
        result = this.select(selector);
        switch (result.length) {
            case 0:
                return null;
            case 1:
                return result[0];
            default:
                throw new Error("found more than one object matching given selector");
        }
    };
    return Model;
})(has_props_1.HasProps);

},{"./core/has_props":"core/has_props","./core/logging":"core/logging","./core/properties":"core/properties","./core/util/object":"core/util/object","./core/util/types":"core/util/types"}],"models/annotations/annotation":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var side_panel_1 = require("core/layout/side_panel");
var p = require("core/properties");
var renderer_1 = require("../renderers/renderer");
exports.AnnotationView = (function (superClass) {
    extend(AnnotationView, superClass);
    function AnnotationView() {
        return AnnotationView.__super__.constructor.apply(this, arguments);
    }
    AnnotationView.prototype._get_panel_offset = function () {
        var x, y;
        x = this.model.panel._left._value;
        y = this.model.panel._bottom._value;
        return {
            x: x,
            y: -y
        };
    };
    AnnotationView.prototype._get_size = function () {
        return -1;
    };
    return AnnotationView;
})(renderer_1.RendererView);
exports.Annotation = (function (superClass) {
    extend(Annotation, superClass);
    function Annotation() {
        return Annotation.__super__.constructor.apply(this, arguments);
    }
    Annotation.prototype.type = 'Annotation';
    Annotation.prototype.default_view = exports.AnnotationView;
    Annotation.define({
        plot: [p.Instance]
    });
    Annotation.override({
        level: 'annotation'
    });
    Annotation.prototype.add_panel = function (side) {
        this.panel = new side_panel_1.SidePanel({
            side: side
        });
        this.panel.attach_document(this.document);
        return this.level = 'overlay';
    };
    return Annotation;
})(renderer_1.Renderer);

},{"../renderers/renderer":"models/renderers/renderer","core/layout/side_panel":"core/layout/side_panel","core/properties":"core/properties"}],"models/annotations/arrow":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var annotation_1 = require("./annotation");
var arrow_head_1 = require("./arrow_head");
var column_data_source_1 = require("../sources/column_data_source");
var p = require("core/properties");
var math_1 = require("core/util/math");
exports.ArrowView = (function (superClass) {
    extend(ArrowView, superClass);
    function ArrowView() {
        return ArrowView.__super__.constructor.apply(this, arguments);
    }
    ArrowView.prototype.initialize = function (options) {
        ArrowView.__super__.initialize.call(this, options);
        if (this.model.source == null) {
            this.model.source = new column_data_source_1.ColumnDataSource();
        }
        this.canvas = this.plot_model.canvas;
        this.xmapper = this.plot_view.frame.x_mappers[this.model.x_range_name];
        this.ymapper = this.plot_view.frame.y_mappers[this.model.y_range_name];
        return this.set_data(this.model.source);
    };
    ArrowView.prototype.bind_bokeh_events = function () {
        this.listenTo(this.model, 'change', this.plot_view.request_render);
        return this.listenTo(this.model.source, 'change', function () {
            this.set_data(this.model.source);
            return this.plot_view.request_render();
        });
    };
    ArrowView.prototype.set_data = function (source) {
        ArrowView.__super__.set_data.call(this, source);
        return this.visuals.warm_cache(source);
    };
    ArrowView.prototype._map_data = function () {
        var end, start, x_name, y_name;
        if (this.model.start_units === 'data') {
            start = this.plot_view.map_to_screen(this._x_start, this._y_start, x_name = this.model.x_range_name, y_name = this.model.y_range_name);
        }
        else {
            start = [this.canvas.v_vx_to_sx(this._x_start), this.canvas.v_vy_to_sy(this._y_start)];
        }
        if (this.model.end_units === 'data') {
            end = this.plot_view.map_to_screen(this._x_end, this._y_end, x_name = this.model.x_range_name, y_name = this.model.y_range_name);
        }
        else {
            end = [this.canvas.v_vx_to_sx(this._x_end), this.canvas.v_vy_to_sy(this._y_end)];
        }
        return [start, end];
    };
    ArrowView.prototype.render = function () {
        var ctx, ref;
        if (!this.model.visible) {
            return;
        }
        ctx = this.plot_view.canvas_view.ctx;
        ctx.save();
        ref = this._map_data(), this.start = ref[0], this.end = ref[1];
        if (this.model.end != null) {
            this._arrow_head(ctx, "render", this.model.end, this.start, this.end);
        }
        if (this.model.start != null) {
            this._arrow_head(ctx, "render", this.model.start, this.end, this.start);
        }
        ctx.beginPath();
        ctx.rect(0, 0, this.canvas.width, this.canvas.height);
        if (this.model.end != null) {
            this._arrow_head(ctx, "clip", this.model.end, this.start, this.end);
        }
        if (this.model.start != null) {
            this._arrow_head(ctx, "clip", this.model.start, this.end, this.start);
        }
        ctx.closePath();
        ctx.clip();
        this._arrow_body(ctx);
        return ctx.restore();
    };
    ArrowView.prototype._arrow_body = function (ctx) {
        var i, j, ref, results;
        if (!this.visuals.line.doit) {
            return;
        }
        results = [];
        for (i = j = 0, ref = this._x_start.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            this.visuals.line.set_vectorize(ctx, i);
            ctx.beginPath();
            ctx.moveTo(this.start[0][i], this.start[1][i]);
            ctx.lineTo(this.end[0][i], this.end[1][i]);
            results.push(ctx.stroke());
        }
        return results;
    };
    ArrowView.prototype._arrow_head = function (ctx, action, head, start, end) {
        var angle, i, j, ref, results;
        results = [];
        for (i = j = 0, ref = this._x_start.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            angle = Math.PI / 2 + math_1.atan2([start[0][i], start[1][i]], [end[0][i], end[1][i]]);
            ctx.save();
            ctx.translate(end[0][i], end[1][i]);
            ctx.rotate(angle);
            if (action === "render") {
                head.render(ctx);
            }
            else if (action === "clip") {
                head.clip(ctx);
            }
            results.push(ctx.restore());
        }
        return results;
    };
    return ArrowView;
})(annotation_1.AnnotationView);
exports.Arrow = (function (superClass) {
    extend(Arrow, superClass);
    function Arrow() {
        return Arrow.__super__.constructor.apply(this, arguments);
    }
    Arrow.prototype.default_view = exports.ArrowView;
    Arrow.prototype.type = 'Arrow';
    Arrow.mixins(['line']);
    Arrow.define({
        x_start: [p.NumberSpec],
        y_start: [p.NumberSpec],
        start_units: [p.String, 'data'],
        start: [p.Instance, null],
        x_end: [p.NumberSpec],
        y_end: [p.NumberSpec],
        end_units: [p.String, 'data'],
        end: [p.Instance, new arrow_head_1.OpenHead({})],
        source: [p.Instance],
        x_range_name: [p.String, 'default'],
        y_range_name: [p.String, 'default']
    });
    return Arrow;
})(annotation_1.Annotation);

},{"../sources/column_data_source":"models/sources/column_data_source","./annotation":"models/annotations/annotation","./arrow_head":"models/annotations/arrow_head","core/properties":"core/properties","core/util/math":"core/util/math"}],"models/annotations/arrow_head":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var annotation_1 = require("./annotation");
var visuals_1 = require("core/visuals");
var p = require("core/properties");
exports.ArrowHead = (function (superClass) {
    extend(ArrowHead, superClass);
    function ArrowHead() {
        return ArrowHead.__super__.constructor.apply(this, arguments);
    }
    ArrowHead.prototype.type = 'ArrowHead';
    ArrowHead.prototype.initialize = function (options) {
        ArrowHead.__super__.initialize.call(this, options);
        return this.visuals = new visuals_1.Visuals(this);
    };
    ArrowHead.prototype.render = function (ctx, i) {
        return null;
    };
    ArrowHead.prototype.clip = function (ctx, i) {
        return null;
    };
    return ArrowHead;
})(annotation_1.Annotation);
exports.OpenHead = (function (superClass) {
    extend(OpenHead, superClass);
    function OpenHead() {
        return OpenHead.__super__.constructor.apply(this, arguments);
    }
    OpenHead.prototype.type = 'OpenHead';
    OpenHead.prototype.clip = function (ctx, i) {
        this.visuals.line.set_vectorize(ctx, i);
        ctx.moveTo(0.5 * this.size, this.size);
        ctx.lineTo(0.5 * this.size, -2);
        ctx.lineTo(-0.5 * this.size, -2);
        ctx.lineTo(-0.5 * this.size, this.size);
        ctx.lineTo(0, 0);
        return ctx.lineTo(0.5 * this.size, this.size);
    };
    OpenHead.prototype.render = function (ctx, i) {
        if (this.visuals.line.doit) {
            this.visuals.line.set_vectorize(ctx, i);
            ctx.beginPath();
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * this.size, this.size);
            return ctx.stroke();
        }
    };
    OpenHead.mixins(['line']);
    OpenHead.define({
        size: [p.Number, 25]
    });
    return OpenHead;
})(exports.ArrowHead);
exports.NormalHead = (function (superClass) {
    extend(NormalHead, superClass);
    function NormalHead() {
        return NormalHead.__super__.constructor.apply(this, arguments);
    }
    NormalHead.prototype.type = 'NormalHead';
    NormalHead.prototype.clip = function (ctx, i) {
        this.visuals.line.set_vectorize(ctx, i);
        ctx.moveTo(0.5 * this.size, this.size);
        ctx.lineTo(0.5 * this.size, -2);
        ctx.lineTo(-0.5 * this.size, -2);
        ctx.lineTo(-0.5 * this.size, this.size);
        return ctx.lineTo(0.5 * this.size, this.size);
    };
    NormalHead.prototype.render = function (ctx, i) {
        if (this.visuals.fill.doit) {
            this.visuals.fill.set_vectorize(ctx, i);
            this._normal(ctx, i);
            ctx.fill();
        }
        if (this.visuals.line.doit) {
            this.visuals.line.set_vectorize(ctx, i);
            this._normal(ctx, i);
            return ctx.stroke();
        }
    };
    NormalHead.prototype._normal = function (ctx, i) {
        ctx.beginPath();
        ctx.moveTo(0.5 * this.size, this.size);
        ctx.lineTo(0, 0);
        ctx.lineTo(-0.5 * this.size, this.size);
        return ctx.closePath();
    };
    NormalHead.mixins(['line', 'fill']);
    NormalHead.define({
        size: [p.Number, 25]
    });
    NormalHead.override({
        fill_color: 'black'
    });
    return NormalHead;
})(exports.ArrowHead);
exports.VeeHead = (function (superClass) {
    extend(VeeHead, superClass);
    function VeeHead() {
        return VeeHead.__super__.constructor.apply(this, arguments);
    }
    VeeHead.prototype.type = 'VeeHead';
    VeeHead.prototype.clip = function (ctx, i) {
        this.visuals.line.set_vectorize(ctx, i);
        ctx.moveTo(0.5 * this.size, this.size);
        ctx.lineTo(0.5 * this.size, -2);
        ctx.lineTo(-0.5 * this.size, -2);
        ctx.lineTo(-0.5 * this.size, this.size);
        ctx.lineTo(0, 0.5 * this.size);
        return ctx.lineTo(0.5 * this.size, this.size);
    };
    VeeHead.prototype.render = function (ctx, i) {
        if (this.visuals.fill.doit) {
            this.visuals.fill.set_vectorize(ctx, i);
            this._vee(ctx, i);
            ctx.fill();
        }
        if (this.visuals.line.doit) {
            this.visuals.line.set_vectorize(ctx, i);
            this._vee(ctx, i);
            return ctx.stroke();
        }
    };
    VeeHead.prototype._vee = function (ctx, i) {
        ctx.beginPath();
        ctx.moveTo(0.5 * this.size, this.size);
        ctx.lineTo(0, 0);
        ctx.lineTo(-0.5 * this.size, this.size);
        ctx.lineTo(0, 0.5 * this.size);
        return ctx.closePath();
    };
    VeeHead.mixins(['line', 'fill']);
    VeeHead.define({
        size: [p.Number, 25]
    });
    VeeHead.override({
        fill_color: 'black'
    });
    return VeeHead;
})(exports.ArrowHead);

},{"./annotation":"models/annotations/annotation","core/properties":"core/properties","core/visuals":"core/visuals"}],"models/annotations/box_annotation":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var annotation_1 = require("./annotation");
var dom_1 = require("core/dom");
var p = require("core/properties");
var types_1 = require("core/util/types");
exports.BoxAnnotationView = (function (superClass) {
    extend(BoxAnnotationView, superClass);
    function BoxAnnotationView() {
        return BoxAnnotationView.__super__.constructor.apply(this, arguments);
    }
    BoxAnnotationView.prototype.initialize = function (options) {
        BoxAnnotationView.__super__.initialize.call(this, options);
        this.plot_view.canvas_overlays.appendChild(this.el);
        this.el.classList.add("bk-shading");
        return dom_1.hide(this.el);
    };
    BoxAnnotationView.prototype.bind_bokeh_events = function () {
        if (this.model.render_mode === 'css') {
            this.listenTo(this.model, 'change', this.render);
            return this.listenTo(this.model, 'data_update', this.render);
        }
        else {
            this.listenTo(this.model, 'change', this.plot_view.request_render);
            return this.listenTo(this.model, 'data_update', this.plot_view.request_render);
        }
    };
    BoxAnnotationView.prototype.render = function () {
        var sbottom, sleft, sright, stop;
        if (!this.model.visible && this.model.render_mode === 'css') {
            dom_1.hide(this.el);
        }
        if (!this.model.visible) {
            return;
        }
        if ((this.model.left == null) && (this.model.right == null) && (this.model.top == null) && (this.model.bottom == null)) {
            dom_1.hide(this.el);
            return null;
        }
        this.frame = this.plot_model.frame;
        this.canvas = this.plot_model.canvas;
        this.xmapper = this.plot_view.frame.x_mappers[this.model.x_range_name];
        this.ymapper = this.plot_view.frame.y_mappers[this.model.y_range_name];
        sleft = this.canvas.vx_to_sx(this._calc_dim(this.model.left, this.model.left_units, this.xmapper, this.frame.h_range.start));
        sright = this.canvas.vx_to_sx(this._calc_dim(this.model.right, this.model.right_units, this.xmapper, this.frame.h_range.end));
        sbottom = this.canvas.vy_to_sy(this._calc_dim(this.model.bottom, this.model.bottom_units, this.ymapper, this.frame.v_range.start));
        stop = this.canvas.vy_to_sy(this._calc_dim(this.model.top, this.model.top_units, this.ymapper, this.frame.v_range.end));
        if (this.model.render_mode === 'css') {
            return this._css_box(sleft, sright, sbottom, stop);
        }
        else {
            return this._canvas_box(sleft, sright, sbottom, stop);
        }
    };
    BoxAnnotationView.prototype._css_box = function (sleft, sright, sbottom, stop) {
        var ld, sh, sw;
        sw = Math.abs(sright - sleft);
        sh = Math.abs(sbottom - stop);
        this.el.style.left = sleft + "px";
        this.el.style.width = sw + "px";
        this.el.style.top = stop + "px";
        this.el.style.height = sh + "px";
        this.el.style.borderWidth = this.model.line_width.value + "px";
        this.el.style.borderColor = this.model.line_color.value;
        this.el.style.backgroundColor = this.model.fill_color.value;
        this.el.style.opacity = this.model.fill_alpha.value;
        ld = this.model.line_dash;
        if (types_1.isArray(ld)) {
            ld = ld.length < 2 ? "solid" : "dashed";
        }
        if (types_1.isString(ld)) {
            this.el.style.borderStyle = ld;
        }
        return dom_1.show(this.el);
    };
    BoxAnnotationView.prototype._canvas_box = function (sleft, sright, sbottom, stop) {
        var ctx;
        ctx = this.plot_view.canvas_view.ctx;
        ctx.save();
        ctx.beginPath();
        ctx.rect(sleft, stop, sright - sleft, sbottom - stop);
        this.visuals.fill.set_value(ctx);
        ctx.fill();
        this.visuals.line.set_value(ctx);
        ctx.stroke();
        return ctx.restore();
    };
    BoxAnnotationView.prototype._calc_dim = function (dim, dim_units, mapper, frame_extrema) {
        var vdim;
        if (dim != null) {
            if (dim_units === 'data') {
                vdim = mapper.map_to_target(dim);
            }
            else {
                vdim = dim;
            }
        }
        else {
            vdim = frame_extrema;
        }
        return vdim;
    };
    return BoxAnnotationView;
})(annotation_1.AnnotationView);
exports.BoxAnnotation = (function (superClass) {
    extend(BoxAnnotation, superClass);
    function BoxAnnotation() {
        return BoxAnnotation.__super__.constructor.apply(this, arguments);
    }
    BoxAnnotation.prototype.default_view = exports.BoxAnnotationView;
    BoxAnnotation.prototype.type = 'BoxAnnotation';
    BoxAnnotation.mixins(['line', 'fill']);
    BoxAnnotation.define({
        render_mode: [p.RenderMode, 'canvas'],
        x_range_name: [p.String, 'default'],
        y_range_name: [p.String, 'default'],
        top: [p.Number, null],
        top_units: [p.SpatialUnits, 'data'],
        bottom: [p.Number, null],
        bottom_units: [p.SpatialUnits, 'data'],
        left: [p.Number, null],
        left_units: [p.SpatialUnits, 'data'],
        right: [p.Number, null],
        right_units: [p.SpatialUnits, 'data']
    });
    BoxAnnotation.override({
        fill_color: '#fff9ba',
        fill_alpha: 0.4,
        line_color: '#cccccc',
        line_alpha: 0.3
    });
    BoxAnnotation.prototype.update = function (arg) {
        var bottom, left, right, top;
        left = arg.left, right = arg.right, top = arg.top, bottom = arg.bottom;
        this.setv({
            left: left,
            right: right,
            top: top,
            bottom: bottom
        }, {
            silent: true
        });
        return this.trigger('data_update');
    };
    return BoxAnnotation;
})(annotation_1.Annotation);

},{"./annotation":"models/annotations/annotation","core/dom":"core/dom","core/properties":"core/properties","core/util/types":"core/util/types"}],"models/annotations/color_bar":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var LONG_DIM_MAX_SCALAR, LONG_DIM_MIN_SCALAR, SHORT_DIM, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var annotation_1 = require("./annotation");
var basic_ticker_1 = require("../tickers/basic_ticker");
var basic_tick_formatter_1 = require("../formatters/basic_tick_formatter");
var linear_color_mapper_1 = require("../mappers/linear_color_mapper");
var linear_mapper_1 = require("../mappers/linear_mapper");
var log_mapper_1 = require("../mappers/log_mapper");
var range1d_1 = require("../ranges/range1d");
var p = require("core/properties");
var text_util = require("core/util/text");
var array_1 = require("core/util/array");
var types_1 = require("core/util/types");
SHORT_DIM = 25;
LONG_DIM_MIN_SCALAR = 0.3;
LONG_DIM_MAX_SCALAR = 0.8;
exports.ColorBarView = (function (superClass) {
    extend(ColorBarView, superClass);
    function ColorBarView() {
        return ColorBarView.__super__.constructor.apply(this, arguments);
    }
    ColorBarView.prototype.initialize = function (options) {
        ColorBarView.__super__.initialize.call(this, options);
        return this._set_canvas_image();
    };
    ColorBarView.prototype.bind_bokeh_events = function () {
        this.listenTo(this.model, 'change:visible', this.plot_view.request_render);
        this.listenTo(this.model.ticker, 'change', this.plot_view.request_render);
        this.listenTo(this.model.formatter, 'change', this.plot_view.request_render);
        return this.listenTo(this.model.color_mapper, 'change', function () {
            this._set_canvas_image();
            return this.plot_view.request_render();
        });
    };
    ColorBarView.prototype._get_panel_offset = function () {
        var x, y;
        x = this.model.panel._left._value;
        y = this.model.panel._top._value;
        return {
            x: x,
            y: -y
        };
    };
    ColorBarView.prototype._get_size = function () {
        var bbox, side;
        bbox = this.compute_legend_dimensions();
        side = this.model.panel.side;
        if (side === 'above' || side === 'below') {
            return bbox.height;
        }
        if (side === 'left' || side === 'right') {
            return bbox.width;
        }
    };
    ColorBarView.prototype._set_canvas_image = function () {
        var buf, buf8, canvas, cmap, h, image_ctx, image_data, k, palette, ref, ref1, ref2, ref3, results, w;
        palette = this.model.color_mapper.palette;
        if (this.model.orientation === 'vertical') {
            palette = palette.slice(0).reverse();
        }
        switch (this.model.orientation) {
            case "vertical":
                ref = [1, palette.length], w = ref[0], h = ref[1];
                break;
            case "horizontal":
                ref1 = [palette.length, 1], w = ref1[0], h = ref1[1];
        }
        canvas = document.createElement('canvas');
        ref2 = [w, h], canvas.width = ref2[0], canvas.height = ref2[1];
        image_ctx = canvas.getContext('2d');
        image_data = image_ctx.getImageData(0, 0, w, h);
        cmap = new linear_color_mapper_1.LinearColorMapper({
            palette: palette
        });
        buf = cmap.v_map_screen((function () {
            results = [];
            for (var k = 0, ref3 = palette.length; 0 <= ref3 ? k < ref3 : k > ref3; 0 <= ref3 ? k++ : k--) {
                results.push(k);
            }
            return results;
        }).apply(this));
        buf8 = new Uint8Array(buf);
        image_data.data.set(buf8);
        image_ctx.putImageData(image_data, 0, 0);
        return this.image = canvas;
    };
    ColorBarView.prototype.compute_legend_dimensions = function () {
        var image_dimensions, image_height, image_width, label_extent, legend_height, legend_width, padding, ref, tick_extent, title_extent;
        image_dimensions = this.model._computed_image_dimensions();
        ref = [image_dimensions.height, image_dimensions.width], image_height = ref[0], image_width = ref[1];
        label_extent = this._get_label_extent();
        title_extent = this.model._title_extent();
        tick_extent = this.model._tick_extent();
        padding = this.model.padding;
        switch (this.model.orientation) {
            case "vertical":
                legend_height = image_height + title_extent + padding * 2;
                legend_width = image_width + tick_extent + label_extent + padding * 2;
                break;
            case "horizontal":
                legend_height = image_height + title_extent + tick_extent + label_extent + padding * 2;
                legend_width = image_width + padding * 2;
        }
        return {
            height: legend_height,
            width: legend_width
        };
    };
    ColorBarView.prototype.compute_legend_location = function () {
        var h_range, legend_dimensions, legend_height, legend_margin, legend_width, location, ref, sx, sy, v_range, x, y;
        legend_dimensions = this.compute_legend_dimensions();
        ref = [legend_dimensions.height, legend_dimensions.width], legend_height = ref[0], legend_width = ref[1];
        legend_margin = this.model.margin;
        location = this.model.location;
        h_range = this.plot_view.frame.h_range;
        v_range = this.plot_view.frame.v_range;
        if (types_1.isString(location)) {
            switch (location) {
                case 'top_left':
                    x = h_range.start + legend_margin;
                    y = v_range.end - legend_margin;
                    break;
                case 'top_center':
                    x = (h_range.end + h_range.start) / 2 - legend_width / 2;
                    y = v_range.end - legend_margin;
                    break;
                case 'top_right':
                    x = h_range.end - legend_margin - legend_width;
                    y = v_range.end - legend_margin;
                    break;
                case 'center_right':
                    x = h_range.end - legend_margin - legend_width;
                    y = (v_range.end + v_range.start) / 2 + legend_height / 2;
                    break;
                case 'bottom_right':
                    x = h_range.end - legend_margin - legend_width;
                    y = v_range.start + legend_margin + legend_height;
                    break;
                case 'bottom_center':
                    x = (h_range.end + h_range.start) / 2 - legend_width / 2;
                    y = v_range.start + legend_margin + legend_height;
                    break;
                case 'bottom_left':
                    x = h_range.start + legend_margin;
                    y = v_range.start + legend_margin + legend_height;
                    break;
                case 'center_left':
                    x = h_range.start + legend_margin;
                    y = (v_range.end + v_range.start) / 2 + legend_height / 2;
                    break;
                case 'center':
                    x = (h_range.end + h_range.start) / 2 - legend_width / 2;
                    y = (v_range.end + v_range.start) / 2 + legend_height / 2;
            }
        }
        else if (types_1.isArray(location) && location.length === 2) {
            x = location[0], y = location[1];
        }
        sx = this.plot_view.canvas.vx_to_sx(x);
        sy = this.plot_view.canvas.vy_to_sy(y);
        return {
            sx: sx,
            sy: sy
        };
    };
    ColorBarView.prototype.render = function () {
        var ctx, frame_offset, image_offset, location, panel_offset;
        if (!this.model.visible) {
            return;
        }
        ctx = this.plot_view.canvas_view.ctx;
        ctx.save();
        if (this.model.panel != null) {
            panel_offset = this._get_panel_offset();
            ctx.translate(panel_offset.x, panel_offset.y);
            frame_offset = this._get_frame_offset();
            ctx.translate(frame_offset.x, frame_offset.y);
        }
        location = this.compute_legend_location();
        ctx.translate(location.sx, location.sy);
        this._draw_bbox(ctx);
        image_offset = this._get_image_offset();
        ctx.translate(image_offset.x, image_offset.y);
        this._draw_image(ctx);
        if ((this.model.color_mapper.low != null) && (this.model.color_mapper.high != null)) {
            this._draw_major_ticks(ctx);
            this._draw_minor_ticks(ctx);
            this._draw_major_labels(ctx);
        }
        if (this.model.title) {
            this._draw_title(ctx);
        }
        return ctx.restore();
    };
    ColorBarView.prototype._draw_bbox = function (ctx) {
        var bbox;
        bbox = this.compute_legend_dimensions();
        ctx.save();
        if (this.visuals.background_fill.doit) {
            this.visuals.background_fill.set_value(ctx);
            ctx.fillRect(0, 0, bbox.width, bbox.height);
        }
        if (this.visuals.border_line.doit) {
            this.visuals.border_line.set_value(ctx);
            ctx.strokeRect(0, 0, bbox.width, bbox.height);
        }
        return ctx.restore();
    };
    ColorBarView.prototype._draw_image = function (ctx) {
        var image;
        image = this.model._computed_image_dimensions();
        ctx.save();
        ctx.setImageSmoothingEnabled(false);
        ctx.globalAlpha = this.model.scale_alpha;
        ctx.drawImage(this.image, 0, 0, image.width, image.height);
        if (this.visuals.bar_line.doit) {
            this.visuals.bar_line.set_value(ctx);
            ctx.strokeRect(0, 0, image.width, image.height);
        }
        return ctx.restore();
    };
    ColorBarView.prototype._draw_major_ticks = function (ctx) {
        var i, image, k, nx, ny, ref, ref1, ref2, ref3, sx, sy, tin, tout, x_offset, y_offset;
        if (!this.visuals.major_tick_line.doit) {
            return;
        }
        ref = this.model._normals(), nx = ref[0], ny = ref[1];
        image = this.model._computed_image_dimensions();
        ref1 = [image.width * nx, image.height * ny], x_offset = ref1[0], y_offset = ref1[1];
        ref2 = this.model._tick_coordinates().major, sx = ref2[0], sy = ref2[1];
        tin = this.model.major_tick_in;
        tout = this.model.major_tick_out;
        ctx.save();
        ctx.translate(x_offset, y_offset);
        this.visuals.major_tick_line.set_value(ctx);
        for (i = k = 0, ref3 = sx.length; 0 <= ref3 ? k < ref3 : k > ref3; i = 0 <= ref3 ? ++k : --k) {
            ctx.beginPath();
            ctx.moveTo(Math.round(sx[i] + nx * tout), Math.round(sy[i] + ny * tout));
            ctx.lineTo(Math.round(sx[i] - nx * tin), Math.round(sy[i] - ny * tin));
            ctx.stroke();
        }
        return ctx.restore();
    };
    ColorBarView.prototype._draw_minor_ticks = function (ctx) {
        var i, image, k, nx, ny, ref, ref1, ref2, ref3, sx, sy, tin, tout, x_offset, y_offset;
        if (!this.visuals.minor_tick_line.doit) {
            return;
        }
        ref = this.model._normals(), nx = ref[0], ny = ref[1];
        image = this.model._computed_image_dimensions();
        ref1 = [image.width * nx, image.height * ny], x_offset = ref1[0], y_offset = ref1[1];
        ref2 = this.model._tick_coordinates().minor, sx = ref2[0], sy = ref2[1];
        tin = this.model.minor_tick_in;
        tout = this.model.minor_tick_out;
        ctx.save();
        ctx.translate(x_offset, y_offset);
        this.visuals.minor_tick_line.set_value(ctx);
        for (i = k = 0, ref3 = sx.length; 0 <= ref3 ? k < ref3 : k > ref3; i = 0 <= ref3 ? ++k : --k) {
            ctx.beginPath();
            ctx.moveTo(Math.round(sx[i] + nx * tout), Math.round(sy[i] + ny * tout));
            ctx.lineTo(Math.round(sx[i] - nx * tin), Math.round(sy[i] - ny * tin));
            ctx.stroke();
        }
        return ctx.restore();
    };
    ColorBarView.prototype._draw_major_labels = function (ctx) {
        var formatted_labels, i, image, k, labels, nx, ny, ref, ref1, ref2, ref3, ref4, standoff, sx, sy, x_offset, x_standoff, y_offset, y_standoff;
        if (!this.visuals.major_label_text.doit) {
            return;
        }
        ref = this.model._normals(), nx = ref[0], ny = ref[1];
        image = this.model._computed_image_dimensions();
        ref1 = [image.width * nx, image.height * ny], x_offset = ref1[0], y_offset = ref1[1];
        standoff = this.model.label_standoff + this.model._tick_extent();
        ref2 = [standoff * nx, standoff * ny], x_standoff = ref2[0], y_standoff = ref2[1];
        ref3 = this.model._tick_coordinates().major, sx = ref3[0], sy = ref3[1];
        labels = this.model._tick_coordinates().major_labels;
        formatted_labels = this.model.formatter.doFormat(labels, null);
        this.visuals.major_label_text.set_value(ctx);
        ctx.save();
        ctx.translate(x_offset + x_standoff, y_offset + y_standoff);
        for (i = k = 0, ref4 = sx.length; 0 <= ref4 ? k < ref4 : k > ref4; i = 0 <= ref4 ? ++k : --k) {
            ctx.fillText(formatted_labels[i], Math.round(sx[i] + nx * this.model.label_standoff), Math.round(sy[i] + ny * this.model.label_standoff));
        }
        return ctx.restore();
    };
    ColorBarView.prototype._draw_title = function (ctx) {
        if (!this.visuals.title_text.doit) {
            return;
        }
        ctx.save();
        this.visuals.title_text.set_value(ctx);
        ctx.fillText(this.model.title, 0, -this.model.title_standoff);
        return ctx.restore();
    };
    ColorBarView.prototype._get_label_extent = function () {
        var ctx, formatted_labels, label, label_extent;
        if ((this.model.color_mapper.low != null) && (this.model.color_mapper.high != null)) {
            ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            this.visuals.major_label_text.set_value(ctx);
            switch (this.model.orientation) {
                case "vertical":
                    formatted_labels = this.model.formatter.doFormat(this.model._tick_coordinates().major_labels);
                    label_extent = array_1.max((function () {
                        var k, len, results;
                        results = [];
                        for (k = 0, len = formatted_labels.length; k < len; k++) {
                            label = formatted_labels[k];
                            results.push(ctx.measureText(label.toString()).width);
                        }
                        return results;
                    })());
                    break;
                case "horizontal":
                    label_extent = text_util.get_text_height(this.visuals.major_label_text.font_value()).height;
            }
            label_extent += this.model.label_standoff;
            ctx.restore();
        }
        else {
            label_extent = 0;
        }
        return label_extent;
    };
    ColorBarView.prototype._get_frame_offset = function () {
        var frame, panel, ref, xoff, yoff;
        ref = [0, 0], xoff = ref[0], yoff = ref[1];
        panel = this.model.panel;
        frame = this.plot_view.frame;
        switch (panel.side) {
            case "left":
            case "right":
                yoff = Math.abs(panel.top - frame.top);
                break;
            case "above":
            case "below":
                xoff = Math.abs(frame.left);
        }
        return {
            x: xoff,
            y: yoff
        };
    };
    ColorBarView.prototype._get_image_offset = function () {
        var x, y;
        x = this.model.padding;
        y = this.model.padding + this.model._title_extent();
        return {
            x: x,
            y: y
        };
    };
    return ColorBarView;
})(annotation_1.AnnotationView);
exports.ColorBar = (function (superClass) {
    extend(ColorBar, superClass);
    function ColorBar() {
        return ColorBar.__super__.constructor.apply(this, arguments);
    }
    ColorBar.prototype.default_view = exports.ColorBarView;
    ColorBar.prototype.type = 'ColorBar';
    ColorBar.mixins(['text:major_label_', 'text:title_', 'line:major_tick_', 'line:minor_tick_', 'line:border_', 'line:bar_', 'fill:background_']);
    ColorBar.define({
        location: [p.Any, 'top_right'],
        orientation: [p.Orientation, 'vertical'],
        title: [p.String],
        title_standoff: [p.Number, 2],
        height: [p.Any, 'auto'],
        width: [p.Any, 'auto'],
        scale_alpha: [p.Number, 1.0],
        ticker: [
            p.Instance, function () {
                return new basic_ticker_1.BasicTicker();
            }
        ],
        formatter: [
            p.Instance, function () {
                return new basic_tick_formatter_1.BasicTickFormatter();
            }
        ],
        color_mapper: [p.Instance],
        label_standoff: [p.Number, 5],
        margin: [p.Number, 30],
        padding: [p.Number, 10],
        major_tick_in: [p.Number, 5],
        major_tick_out: [p.Number, 0],
        minor_tick_in: [p.Number, 0],
        minor_tick_out: [p.Number, 0]
    });
    ColorBar.override({
        background_fill_color: "#ffffff",
        background_fill_alpha: 0.95,
        bar_line_color: null,
        border_line_color: null,
        major_label_text_align: "center",
        major_label_text_baseline: "middle",
        major_label_text_font_size: "8pt",
        major_tick_line_color: "#ffffff",
        minor_tick_line_color: null,
        title_text_font_size: "10pt",
        title_text_font_style: "italic"
    });
    ColorBar.prototype.initialize = function (attrs, options) {
        return ColorBar.__super__.initialize.call(this, attrs, options);
    };
    ColorBar.prototype._normals = function () {
        var i, j, ref, ref1;
        if (this.orientation === 'vertical') {
            ref = [1, 0], i = ref[0], j = ref[1];
        }
        else {
            ref1 = [0, 1], i = ref1[0], j = ref1[1];
        }
        return [i, j];
    };
    ColorBar.prototype._title_extent = function () {
        var font_value, title_extent;
        font_value = this.title_text_font + " " + this.title_text_font_size + " " + this.title_text_font_style;
        title_extent = this.title ? text_util.get_text_height(font_value).height + this.title_standoff : 0;
        return title_extent;
    };
    ColorBar.prototype._tick_extent = function () {
        var tick_extent;
        if ((this.color_mapper.low != null) && (this.color_mapper.high != null)) {
            tick_extent = array_1.max([this.major_tick_out, this.minor_tick_out]);
        }
        else {
            tick_extent = 0;
        }
        return tick_extent;
    };
    ColorBar.prototype._computed_image_dimensions = function () {
        /*
        Heuristics to determine ColorBar image dimensions if set to "auto"
        
        Note: Returns the height/width values for the ColorBar's scale image, not
        the dimensions of the entire ColorBar.
        
        If the short dimension (the width of a vertical bar or height of a
        horizontal bar) is set to "auto", the resulting dimension will be set to
        25 px.
        
        For a ColorBar in a side panel with the long dimension (the height of a
        vertical bar or width of a horizontal bar) set to "auto", the
        resulting dimension will be as long as the adjacent frame edge, so that the
        bar "fits" to the plot.
        
        For a ColorBar in the plot frame with the long dimension set to "auto", the
        resulting dimension will be the greater of:
          * The length of the color palette * 25px
          * The parallel frame dimension * 0.30
            (i.e the frame height for a vertical ColorBar)
        But not greater than:
          * The parallel frame dimension * 0.80
         */
        var frame_height, frame_width, height, title_extent, width;
        frame_height = this.plot.plot_canvas.frame.height;
        frame_width = this.plot.plot_canvas.frame.width;
        title_extent = this._title_extent();
        switch (this.orientation) {
            case "vertical":
                if (this.height === 'auto') {
                    if (this.panel != null) {
                        height = frame_height - 2 * this.padding - title_extent;
                    }
                    else {
                        height = array_1.max([this.color_mapper.palette.length * SHORT_DIM, frame_height * LONG_DIM_MIN_SCALAR]);
                        height = array_1.min([height, frame_height * LONG_DIM_MAX_SCALAR - 2 * this.padding - title_extent]);
                    }
                }
                else {
                    height = this.height;
                }
                width = this.width === 'auto' ? SHORT_DIM : this.width;
                break;
            case "horizontal":
                height = this.height === 'auto' ? SHORT_DIM : this.height;
                if (this.width === 'auto') {
                    if (this.panel != null) {
                        width = frame_width - 2 * this.padding;
                    }
                    else {
                        width = array_1.max([this.color_mapper.palette.length * SHORT_DIM, frame_width * LONG_DIM_MIN_SCALAR]);
                        width = array_1.min([width, frame_width * LONG_DIM_MAX_SCALAR - 2 * this.padding]);
                    }
                }
                else {
                    width = this.width;
                }
        }
        return {
            "height": height,
            "width": width
        };
    };
    ColorBar.prototype._tick_coordinate_mapper = function (scale_length) {
        /*
        Creates and returns a mapper instance that maps the `color_mapper` range
        (low to high) to a screen space range equal to the length of the ColorBar's
        scale image. The mapper is used to calculate the tick coordinates in screen
        coordinates for plotting purposes.
        
        Note: the type of color_mapper has to match the type of mapper (i.e.
        a LinearColorMapper will require a corresponding LinearMapper instance).
         */
        var mapper, mapping;
        mapping = {
            'source_range': new range1d_1.Range1d({
                start: this.color_mapper.low,
                end: this.color_mapper.high
            }),
            'target_range': new range1d_1.Range1d({
                start: 0,
                end: scale_length
            })
        };
        switch (this.color_mapper.type) {
            case "LinearColorMapper":
                mapper = new linear_mapper_1.LinearMapper(mapping);
                break;
            case "LogColorMapper":
                mapper = new log_mapper_1.LogMapper(mapping);
        }
        return mapper;
    };
    ColorBar.prototype._tick_coordinates = function () {
        var coord, end, i, ii, image_dimensions, j, k, l, major_coords, major_labels, majors, mapper, minor_coords, minors, ref, ref1, ref2, ref3, scale_length, start, ticks;
        image_dimensions = this._computed_image_dimensions();
        switch (this.orientation) {
            case "vertical":
                scale_length = image_dimensions.height;
                break;
            case "horizontal":
                scale_length = image_dimensions.width;
        }
        mapper = this._tick_coordinate_mapper(scale_length);
        ref = this._normals(), i = ref[0], j = ref[1];
        ref1 = [this.color_mapper.low, this.color_mapper.high], start = ref1[0], end = ref1[1];
        ticks = this.ticker.get_ticks(start, end, null, null, this.ticker.desired_num_ticks);
        majors = ticks.major;
        minors = ticks.minor;
        major_coords = [[], []];
        minor_coords = [[], []];
        for (ii = k = 0, ref2 = majors.length; 0 <= ref2 ? k < ref2 : k > ref2; ii = 0 <= ref2 ? ++k : --k) {
            if (majors[ii] < start || majors[ii] > end) {
                continue;
            }
            major_coords[i].push(majors[ii]);
            major_coords[j].push(0);
        }
        for (ii = l = 0, ref3 = minors.length; 0 <= ref3 ? l < ref3 : l > ref3; ii = 0 <= ref3 ? ++l : --l) {
            if (minors[ii] < start || minors[ii] > end) {
                continue;
            }
            minor_coords[i].push(minors[ii]);
            minor_coords[j].push(0);
        }
        major_labels = major_coords[i].slice(0);
        major_coords[i] = mapper.v_map_to_target(major_coords[i]);
        minor_coords[i] = mapper.v_map_to_target(minor_coords[i]);
        if (this.orientation === 'vertical') {
            major_coords[i] = new Float64Array((function () {
                var len, m, ref4, results;
                ref4 = major_coords[i];
                results = [];
                for (m = 0, len = ref4.length; m < len; m++) {
                    coord = ref4[m];
                    results.push(scale_length - coord);
                }
                return results;
            })());
            minor_coords[i] = new Float64Array((function () {
                var len, m, ref4, results;
                ref4 = minor_coords[i];
                results = [];
                for (m = 0, len = ref4.length; m < len; m++) {
                    coord = ref4[m];
                    results.push(scale_length - coord);
                }
                return results;
            })());
        }
        return {
            "major": major_coords,
            "minor": minor_coords,
            "major_labels": major_labels
        };
    };
    return ColorBar;
})(annotation_1.Annotation);

},{"../formatters/basic_tick_formatter":"models/formatters/basic_tick_formatter","../mappers/linear_color_mapper":"models/mappers/linear_color_mapper","../mappers/linear_mapper":"models/mappers/linear_mapper","../mappers/log_mapper":"models/mappers/log_mapper","../ranges/range1d":"models/ranges/range1d","../tickers/basic_ticker":"models/tickers/basic_ticker","./annotation":"models/annotations/annotation","core/properties":"core/properties","core/util/array":"core/util/array","core/util/text":"core/util/text","core/util/types":"core/util/types"}],"models/annotations/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var annotation_1 = require("./annotation");
exports.Annotation = annotation_1.Annotation;
var arrow_1 = require("./arrow");
exports.Arrow = arrow_1.Arrow;
var arrow_head_1 = require("./arrow_head");
exports.ArrowHead = arrow_head_1.ArrowHead;
var arrow_head_2 = require("./arrow_head");
exports.OpenHead = arrow_head_2.OpenHead;
var arrow_head_3 = require("./arrow_head");
exports.NormalHead = arrow_head_3.NormalHead;
var arrow_head_4 = require("./arrow_head");
exports.VeeHead = arrow_head_4.VeeHead;
var box_annotation_1 = require("./box_annotation");
exports.BoxAnnotation = box_annotation_1.BoxAnnotation;
var color_bar_1 = require("./color_bar");
exports.ColorBar = color_bar_1.ColorBar;
var label_1 = require("./label");
exports.Label = label_1.Label;
var label_set_1 = require("./label_set");
exports.LabelSet = label_set_1.LabelSet;
var legend_1 = require("./legend");
exports.Legend = legend_1.Legend;
var legend_item_1 = require("./legend_item");
exports.LegendItem = legend_item_1.LegendItem;
var poly_annotation_1 = require("./poly_annotation");
exports.PolyAnnotation = poly_annotation_1.PolyAnnotation;
var span_1 = require("./span");
exports.Span = span_1.Span;
var text_annotation_1 = require("./text_annotation");
exports.TextAnnotation = text_annotation_1.TextAnnotation;
var title_1 = require("./title");
exports.Title = title_1.Title;
var tooltip_1 = require("./tooltip");
exports.Tooltip = tooltip_1.Tooltip;

},{"./annotation":"models/annotations/annotation","./arrow":"models/annotations/arrow","./arrow_head":"models/annotations/arrow_head","./box_annotation":"models/annotations/box_annotation","./color_bar":"models/annotations/color_bar","./label":"models/annotations/label","./label_set":"models/annotations/label_set","./legend":"models/annotations/legend","./legend_item":"models/annotations/legend_item","./poly_annotation":"models/annotations/poly_annotation","./span":"models/annotations/span","./text_annotation":"models/annotations/text_annotation","./title":"models/annotations/title","./tooltip":"models/annotations/tooltip"}],"models/annotations/label":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var text_annotation_1 = require("./text_annotation");
var dom_1 = require("core/dom");
var p = require("core/properties");
exports.LabelView = (function (superClass) {
    extend(LabelView, superClass);
    function LabelView() {
        return LabelView.__super__.constructor.apply(this, arguments);
    }
    LabelView.prototype.initialize = function (options) {
        LabelView.__super__.initialize.call(this, options);
        this.canvas = this.plot_model.canvas;
        this.xmapper = this.plot_view.frame.x_mappers[this.model.x_range_name];
        this.ymapper = this.plot_view.frame.y_mappers[this.model.y_range_name];
        return this.visuals.warm_cache(null);
    };
    LabelView.prototype._get_size = function () {
        var ctx, height, side, width;
        ctx = this.plot_view.canvas_view.ctx;
        this.visuals.text.set_value(ctx);
        side = this.model.panel.side;
        if (side === "above" || side === "below") {
            height = ctx.measureText(this.model.text).ascent;
            return height;
        }
        if (side === 'left' || side === 'right') {
            width = ctx.measureText(this.model.text).width;
            return width;
        }
    };
    LabelView.prototype.render = function () {
        var angle, ctx, panel_offset, sx, sy, vx, vy;
        if (!this.model.visible && this.model.render_mode === 'css') {
            dom_1.hide(this.el);
        }
        if (!this.model.visible) {
            return;
        }
        ctx = this.plot_view.canvas_view.ctx;
        switch (this.model.angle_units) {
            case "rad":
                angle = -1 * this.model.angle;
                break;
            case "deg":
                angle = -1 * this.model.angle * Math.PI / 180.0;
        }
        if (this.model.x_units === "data") {
            vx = this.xmapper.map_to_target(this.model.x);
        }
        else {
            vx = this.model.x;
        }
        sx = this.canvas.vx_to_sx(vx);
        if (this.model.y_units === "data") {
            vy = this.ymapper.map_to_target(this.model.y);
        }
        else {
            vy = this.model.y;
        }
        sy = this.canvas.vy_to_sy(vy);
        if (this.model.panel != null) {
            panel_offset = this._get_panel_offset();
            sx += panel_offset.x;
            sy += panel_offset.y;
        }
        if (this.model.render_mode === 'canvas') {
            return this._canvas_text(ctx, this.model.text, sx + this.model.x_offset, sy - this.model.y_offset, angle);
        }
        else {
            return this._css_text(ctx, this.model.text, sx + this.model.x_offset, sy - this.model.y_offset, angle);
        }
    };
    return LabelView;
})(text_annotation_1.TextAnnotationView);
exports.Label = (function (superClass) {
    extend(Label, superClass);
    function Label() {
        return Label.__super__.constructor.apply(this, arguments);
    }
    Label.prototype.default_view = exports.LabelView;
    Label.prototype.type = 'Label';
    Label.mixins(['text', 'line:border_', 'fill:background_']);
    Label.define({
        x: [p.Number],
        x_units: [p.SpatialUnits, 'data'],
        y: [p.Number],
        y_units: [p.SpatialUnits, 'data'],
        text: [p.String],
        angle: [p.Angle, 0],
        angle_units: [p.AngleUnits, 'rad'],
        x_offset: [p.Number, 0],
        y_offset: [p.Number, 0],
        x_range_name: [p.String, 'default'],
        y_range_name: [p.String, 'default'],
        render_mode: [p.RenderMode, 'canvas']
    });
    Label.override({
        background_fill_color: null,
        border_line_color: null
    });
    return Label;
})(text_annotation_1.TextAnnotation);

},{"./text_annotation":"models/annotations/text_annotation","core/dom":"core/dom","core/properties":"core/properties"}],"models/annotations/label_set":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var text_annotation_1 = require("./text_annotation");
var column_data_source_1 = require("../sources/column_data_source");
var dom_1 = require("core/dom");
var p = require("core/properties");
var types_1 = require("core/util/types");
exports.LabelSetView = (function (superClass) {
    extend(LabelSetView, superClass);
    function LabelSetView() {
        return LabelSetView.__super__.constructor.apply(this, arguments);
    }
    LabelSetView.prototype.initialize = function (options) {
        var i, j, ref, results;
        LabelSetView.__super__.initialize.call(this, options);
        this.xmapper = this.plot_view.frame.x_mappers[this.model.x_range_name];
        this.ymapper = this.plot_view.frame.y_mappers[this.model.y_range_name];
        this.set_data(this.model.source);
        if (this.model.render_mode === 'css') {
            results = [];
            for (i = j = 0, ref = this._text.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                this.title_div = dom_1.div({
                    "class": 'bk-annotation-child',
                    style: {
                        display: "none"
                    }
                });
                results.push(this.el.appendChild(this.title_div));
            }
            return results;
        }
    };
    LabelSetView.prototype.bind_bokeh_events = function () {
        if (this.model.render_mode === 'css') {
            this.listenTo(this.model, 'change', function () {
                this.set_data(this.model.source);
                return this.render();
            });
            return this.listenTo(this.model.source, 'change', function () {
                this.set_data(this.model.source);
                return this.render();
            });
        }
        else {
            this.listenTo(this.model, 'change', function () {
                this.set_data(this.model.source);
                return this.plot_view.request_render();
            });
            return this.listenTo(this.model.source, 'change', function () {
                this.set_data(this.model.source);
                return this.plot_view.request_render();
            });
        }
    };
    LabelSetView.prototype.set_data = function (source) {
        LabelSetView.__super__.set_data.call(this, source);
        return this.visuals.warm_cache(source);
    };
    LabelSetView.prototype._map_data = function () {
        var sx, sy, vx, vy;
        if (this.model.x_units === "data") {
            vx = this.xmapper.v_map_to_target(this._x);
        }
        else {
            vx = this._x.slice(0);
        }
        sx = this.canvas.v_vx_to_sx(vx);
        if (this.model.y_units === "data") {
            vy = this.ymapper.v_map_to_target(this._y);
        }
        else {
            vy = this._y.slice(0);
        }
        sy = this.canvas.v_vy_to_sy(vy);
        return [sx, sy];
    };
    LabelSetView.prototype.render = function () {
        var ctx, i, j, k, ref, ref1, ref2, results, results1, sx, sy;
        if (!this.model.visible && this.model.render_mode === 'css') {
            dom_1.hide(this.el);
        }
        if (!this.model.visible) {
            return;
        }
        ctx = this.plot_view.canvas_view.ctx;
        ref = this._map_data(), sx = ref[0], sy = ref[1];
        if (this.model.render_mode === 'canvas') {
            results = [];
            for (i = j = 0, ref1 = this._text.length; 0 <= ref1 ? j < ref1 : j > ref1; i = 0 <= ref1 ? ++j : --j) {
                results.push(this._v_canvas_text(ctx, i, this._text[i], sx[i] + this._x_offset[i], sy[i] - this._y_offset[i], this._angle[i]));
            }
            return results;
        }
        else {
            results1 = [];
            for (i = k = 0, ref2 = this._text.length; 0 <= ref2 ? k < ref2 : k > ref2; i = 0 <= ref2 ? ++k : --k) {
                results1.push(this._v_css_text(ctx, i, this._text[i], sx[i] + this._x_offset[i], sy[i] - this._y_offset[i], this._angle[i]));
            }
            return results1;
        }
    };
    LabelSetView.prototype._get_size = function () {
        var ctx, height, side, width;
        ctx = this.plot_view.canvas_view.ctx;
        this.visuals.text.set_value(ctx);
        side = this.model.panel.side;
        if (side === "above" || side === "below") {
            height = ctx.measureText(this._text[0]).ascent;
            return height;
        }
        if (side === 'left' || side === 'right') {
            width = ctx.measureText(this._text[0]).width;
            return width;
        }
    };
    LabelSetView.prototype._v_canvas_text = function (ctx, i, text, sx, sy, angle) {
        var bbox_dims;
        this.visuals.text.set_vectorize(ctx, i);
        bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
        ctx.save();
        ctx.beginPath();
        ctx.translate(sx, sy);
        ctx.rotate(angle);
        ctx.rect(bbox_dims[0], bbox_dims[1], bbox_dims[2], bbox_dims[3]);
        if (this.visuals.background_fill.doit) {
            this.visuals.background_fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (this.visuals.border_line.doit) {
            this.visuals.border_line.set_vectorize(ctx, i);
            ctx.stroke();
        }
        if (this.visuals.text.doit) {
            this.visuals.text.set_vectorize(ctx, i);
            ctx.fillText(text, 0, 0);
        }
        return ctx.restore();
    };
    LabelSetView.prototype._v_css_text = function (ctx, i, text, sx, sy, angle) {
        var bbox_dims, el, ld, line_dash;
        el = this.el.childNodes[i];
        el.textContent = text;
        this.visuals.text.set_vectorize(ctx, i);
        bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
        ld = this.visuals.border_line.line_dash.value();
        if (types_1.isArray(ld)) {
            line_dash = ld.length < 2 ? "solid" : "dashed";
        }
        if (types_1.isString(ld)) {
            line_dash = ld;
        }
        this.visuals.border_line.set_vectorize(ctx, i);
        this.visuals.background_fill.set_vectorize(ctx, i);
        el.style.position = 'absolute';
        el.style.left = (sx + bbox_dims[0]) + "px";
        el.style.top = (sy + bbox_dims[1]) + "px";
        el.style.color = "" + (this.visuals.text.text_color.value());
        el.style.opacity = "" + (this.visuals.text.text_alpha.value());
        el.style.font = "" + (this.visuals.text.font_value());
        el.style.lineHeight = "normal";
        if (angle) {
            el.style.transform = "rotate(" + angle + "rad)";
        }
        if (this.visuals.background_fill.doit) {
            el.style.backgroundColor = "" + (this.visuals.background_fill.color_value());
        }
        if (this.visuals.border_line.doit) {
            el.style.borderStyle = "" + line_dash;
            el.style.borderWidth = (this.visuals.border_line.line_width.value()) + "px";
            el.style.borderColor = "" + (this.visuals.border_line.color_value());
        }
        return dom_1.show(el);
    };
    return LabelSetView;
})(text_annotation_1.TextAnnotationView);
exports.LabelSet = (function (superClass) {
    extend(LabelSet, superClass);
    function LabelSet() {
        return LabelSet.__super__.constructor.apply(this, arguments);
    }
    LabelSet.prototype.default_view = exports.LabelSetView;
    LabelSet.prototype.type = 'Label';
    LabelSet.mixins(['text', 'line:border_', 'fill:background_']);
    LabelSet.define({
        x: [p.NumberSpec],
        y: [p.NumberSpec],
        x_units: [p.SpatialUnits, 'data'],
        y_units: [p.SpatialUnits, 'data'],
        text: [
            p.StringSpec, {
                field: "text"
            }
        ],
        angle: [p.AngleSpec, 0],
        x_offset: [
            p.NumberSpec, {
                value: 0
            }
        ],
        y_offset: [
            p.NumberSpec, {
                value: 0
            }
        ],
        source: [
            p.Instance, function () {
                return new column_data_source_1.ColumnDataSource();
            }
        ],
        x_range_name: [p.String, 'default'],
        y_range_name: [p.String, 'default'],
        render_mode: [p.RenderMode, 'canvas']
    });
    LabelSet.override({
        background_fill_color: null,
        border_line_color: null
    });
    return LabelSet;
})(text_annotation_1.TextAnnotation);

},{"../sources/column_data_source":"models/sources/column_data_source","./text_annotation":"models/annotations/text_annotation","core/dom":"core/dom","core/properties":"core/properties","core/util/types":"core/util/types"}],"models/annotations/legend":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var annotation_1 = require("./annotation");
var p = require("core/properties");
var text_1 = require("core/util/text");
var bbox_1 = require("core/util/bbox");
var array_1 = require("core/util/array");
var object_1 = require("core/util/object");
var types_1 = require("core/util/types");
exports.LegendView = (function (superClass) {
    extend(LegendView, superClass);
    function LegendView() {
        return LegendView.__super__.constructor.apply(this, arguments);
    }
    LegendView.prototype.initialize = function (options) {
        return LegendView.__super__.initialize.call(this, options);
    };
    LegendView.prototype.bind_bokeh_events = function () {
        return this.listenTo(this.model, 'change:visible', this.plot_view.request_render);
    };
    LegendView.prototype.compute_legend_bbox = function () {
        var ctx, glyph_height, glyph_width, h_range, i, label_height, label_standoff, label_width, legend_height, legend_margin, legend_names, legend_padding, legend_spacing, legend_width, len, location, max_label_width, name, panel, ref, ref1, v_range, width, x, y;
        legend_names = this.model.get_legend_names();
        glyph_height = this.model.glyph_height;
        glyph_width = this.model.glyph_width;
        label_height = this.model.label_height;
        label_width = this.model.label_width;
        this.max_label_height = array_1.max([text_1.get_text_height(this.visuals.label_text.font_value()).height, label_height, glyph_height]);
        ctx = this.plot_view.canvas_view.ctx;
        ctx.save();
        this.visuals.label_text.set_value(ctx);
        this.text_widths = {};
        for (i = 0, len = legend_names.length; i < len; i++) {
            name = legend_names[i];
            this.text_widths[name] = array_1.max([ctx.measureText(name).width, label_width]);
        }
        ctx.restore();
        max_label_width = array_1.max(object_1.values(this.text_widths));
        legend_margin = this.model.margin;
        legend_padding = this.model.padding;
        legend_spacing = this.model.spacing;
        label_standoff = this.model.label_standoff;
        if (this.model.orientation === "vertical") {
            legend_height = legend_names.length * this.max_label_height + (legend_names.length - 1) * legend_spacing + 2 * legend_padding;
            legend_width = max_label_width + glyph_width + label_standoff + 2 * legend_padding;
        }
        else {
            legend_width = 2 * legend_padding + (legend_names.length - 1) * legend_spacing;
            ref = this.text_widths;
            for (name in ref) {
                width = ref[name];
                legend_width += array_1.max([width, label_width]) + glyph_width + label_standoff;
            }
            legend_height = this.max_label_height + 2 * legend_padding;
        }
        panel = (ref1 = this.model.panel) != null ? ref1 : this.plot_view.frame;
        h_range = {
            start: panel.left,
            end: panel.right
        };
        v_range = {
            start: panel.bottom,
            end: panel.top
        };
        location = this.model.location;
        if (types_1.isString(location)) {
            switch (location) {
                case 'top_left':
                    x = h_range.start + legend_margin;
                    y = v_range.end - legend_margin;
                    break;
                case 'top_center':
                    x = (h_range.end + h_range.start) / 2 - legend_width / 2;
                    y = v_range.end - legend_margin;
                    break;
                case 'top_right':
                    x = h_range.end - legend_margin - legend_width;
                    y = v_range.end - legend_margin;
                    break;
                case 'center_right':
                    x = h_range.end - legend_margin - legend_width;
                    y = (v_range.end + v_range.start) / 2 + legend_height / 2;
                    break;
                case 'bottom_right':
                    x = h_range.end - legend_margin - legend_width;
                    y = v_range.start + legend_margin + legend_height;
                    break;
                case 'bottom_center':
                    x = (h_range.end + h_range.start) / 2 - legend_width / 2;
                    y = v_range.start + legend_margin + legend_height;
                    break;
                case 'bottom_left':
                    x = h_range.start + legend_margin;
                    y = v_range.start + legend_margin + legend_height;
                    break;
                case 'center_left':
                    x = h_range.start + legend_margin;
                    y = (v_range.end + v_range.start) / 2 + legend_height / 2;
                    break;
                case 'center':
                    x = (h_range.end + h_range.start) / 2 - legend_width / 2;
                    y = (v_range.end + v_range.start) / 2 + legend_height / 2;
            }
        }
        else if (types_1.isArray(location) && location.length === 2) {
            x = location[0], y = location[1];
            x += h_range.start;
            y += v_range.start + legend_height;
        }
        x = this.plot_view.canvas.vx_to_sx(x);
        y = this.plot_view.canvas.vy_to_sy(y);
        return {
            x: x,
            y: y,
            width: legend_width,
            height: legend_height
        };
    };
    LegendView.prototype.bbox = function () {
        var height, ref, width, x, y;
        ref = this.compute_legend_bbox(), x = ref.x, y = ref.y, width = ref.width, height = ref.height;
        return new bbox_1.BBox({
            x0: x,
            y0: y,
            x1: x + width,
            y1: y + height
        });
    };
    LegendView.prototype.on_hit = function (sx, sy) {
        var bbox, field, glyph_height, glyph_width, h, i, item, j, k, l, label, label_standoff, labels, legend_bbox, legend_spacing, len, len1, len2, len3, r, ref, ref1, ref2, ref3, ref4, vertical, w, x1, x2, xoffset, y1, y2, yoffset;
        glyph_height = this.model.glyph_height;
        glyph_width = this.model.glyph_width;
        legend_spacing = this.model.spacing;
        label_standoff = this.model.label_standoff;
        xoffset = yoffset = this.model.padding;
        legend_bbox = this.compute_legend_bbox();
        vertical = this.model.orientation === "vertical";
        ref = this.model.items;
        for (i = 0, len = ref.length; i < len; i++) {
            item = ref[i];
            labels = item.get_labels_list_from_label_prop();
            field = item.get_field_from_label_prop();
            for (j = 0, len1 = labels.length; j < len1; j++) {
                label = labels[j];
                x1 = legend_bbox.x + xoffset;
                y1 = legend_bbox.y + yoffset;
                x2 = x1 + glyph_width;
                y2 = y1 + glyph_height;
                if (vertical) {
                    ref1 = [legend_bbox.width - 2 * this.model.padding, this.max_label_height], w = ref1[0], h = ref1[1];
                }
                else {
                    ref2 = [this.text_widths[label] + glyph_width + label_standoff, this.max_label_height], w = ref2[0], h = ref2[1];
                }
                bbox = new bbox_1.BBox({
                    x0: x1,
                    y0: y1,
                    x1: x1 + w,
                    y1: y1 + h
                });
                if (bbox.contains(sx, sy)) {
                    switch (this.model.click_policy) {
                        case "hide":
                            ref3 = item.renderers;
                            for (k = 0, len2 = ref3.length; k < len2; k++) {
                                r = ref3[k];
                                r.visible = !r.visible;
                            }
                            break;
                        case "mute":
                            ref4 = item.renderers;
                            for (l = 0, len3 = ref4.length; l < len3; l++) {
                                r = ref4[l];
                                r.muted = !r.muted;
                            }
                    }
                    return true;
                }
                if (vertical) {
                    yoffset += this.max_label_height + legend_spacing;
                }
                else {
                    xoffset += this.text_widths[label] + glyph_width + label_standoff + legend_spacing;
                }
            }
        }
        return false;
    };
    LegendView.prototype.render = function () {
        var bbox, ctx;
        if (!this.model.visible) {
            return;
        }
        if (this.model.items.length === 0) {
            return;
        }
        ctx = this.plot_view.canvas_view.ctx;
        bbox = this.compute_legend_bbox();
        ctx.save();
        this._draw_legend_box(ctx, bbox);
        this._draw_legend_items(ctx, bbox);
        return ctx.restore();
    };
    LegendView.prototype._draw_legend_box = function (ctx, bbox) {
        ctx.beginPath();
        ctx.rect(bbox.x, bbox.y, bbox.width, bbox.height);
        this.visuals.background_fill.set_value(ctx);
        ctx.fill();
        if (this.visuals.border_line.doit) {
            this.visuals.border_line.set_value(ctx);
            return ctx.stroke();
        }
    };
    LegendView.prototype._draw_legend_items = function (ctx, bbox) {
        var active, field, glyph_height, glyph_width, h, i, item, j, k, label, label_standoff, labels, legend_spacing, len, len1, len2, r, ref, ref1, ref2, ref3, vertical, view, w, x1, x2, xoffset, y1, y2, yoffset;
        glyph_height = this.model.glyph_height;
        glyph_width = this.model.glyph_width;
        legend_spacing = this.model.spacing;
        label_standoff = this.model.label_standoff;
        xoffset = yoffset = this.model.padding;
        vertical = this.model.orientation === "vertical";
        ref = this.model.items;
        for (i = 0, len = ref.length; i < len; i++) {
            item = ref[i];
            labels = item.get_labels_list_from_label_prop();
            field = item.get_field_from_label_prop();
            if (labels.length === 0) {
                continue;
            }
            active = (function () {
                switch (this.model.click_policy) {
                    case "none":
                        return true;
                    case "hide":
                        return array_1.all(item.renderers, function (r) {
                            return r.visible;
                        });
                    case "mute":
                        return array_1.all(item.renderers, function (r) {
                            return !r.muted;
                        });
                }
            }).call(this);
            for (j = 0, len1 = labels.length; j < len1; j++) {
                label = labels[j];
                x1 = bbox.x + xoffset;
                y1 = bbox.y + yoffset;
                x2 = x1 + glyph_width;
                y2 = y1 + glyph_height;
                if (vertical) {
                    yoffset += this.max_label_height + legend_spacing;
                }
                else {
                    xoffset += this.text_widths[label] + glyph_width + label_standoff + legend_spacing;
                }
                this.visuals.label_text.set_value(ctx);
                ctx.fillText(label, x2 + label_standoff, y1 + this.max_label_height / 2.0);
                ref1 = item.renderers;
                for (k = 0, len2 = ref1.length; k < len2; k++) {
                    r = ref1[k];
                    view = this.plot_view.renderer_views[r.id];
                    view.draw_legend(ctx, x1, x2, y1, y2, field, label);
                }
                if (!active) {
                    if (vertical) {
                        ref2 = [bbox.width - 2 * this.model.padding, this.max_label_height], w = ref2[0], h = ref2[1];
                    }
                    else {
                        ref3 = [this.text_widths[label] + glyph_width + label_standoff, this.max_label_height], w = ref3[0], h = ref3[1];
                    }
                    ctx.beginPath();
                    ctx.rect(x1, y1, w, h);
                    this.visuals.inactive_fill.set_value(ctx);
                    ctx.fill();
                }
            }
        }
        return null;
    };
    LegendView.prototype._get_size = function () {
        var bbox, side;
        bbox = this.compute_legend_bbox();
        side = this.model.panel.side;
        if (side === 'above' || side === 'below') {
            return bbox.height;
        }
        if (side === 'left' || side === 'right') {
            return bbox.width;
        }
    };
    return LegendView;
})(annotation_1.AnnotationView);
exports.Legend = (function (superClass) {
    extend(Legend, superClass);
    function Legend() {
        return Legend.__super__.constructor.apply(this, arguments);
    }
    Legend.prototype.default_view = exports.LegendView;
    Legend.prototype.type = 'Legend';
    Legend.prototype.cursor = function () {
        if (this.click_policy === "none") {
            return null;
        }
        else {
            return "pointer";
        }
    };
    Legend.prototype.get_legend_names = function () {
        var i, item, labels, legend_names, len, ref;
        legend_names = [];
        ref = this.items;
        for (i = 0, len = ref.length; i < len; i++) {
            item = ref[i];
            labels = item.get_labels_list_from_label_prop();
            legend_names = legend_names.concat(labels);
        }
        return legend_names;
    };
    Legend.mixins(['text:label_', 'fill:inactive_', 'line:border_', 'fill:background_']);
    Legend.define({
        orientation: [p.Orientation, 'vertical'],
        location: [p.Any, 'top_right'],
        label_standoff: [p.Number, 5],
        glyph_height: [p.Number, 20],
        glyph_width: [p.Number, 20],
        label_height: [p.Number, 20],
        label_width: [p.Number, 20],
        margin: [p.Number, 10],
        padding: [p.Number, 10],
        spacing: [p.Number, 3],
        items: [p.Array, []],
        click_policy: [p.Any, "none"]
    });
    Legend.override({
        border_line_color: "#e5e5e5",
        border_line_alpha: 0.5,
        border_line_width: 1,
        background_fill_color: "#ffffff",
        background_fill_alpha: 0.95,
        inactive_fill_color: "white",
        inactive_fill_alpha: 0.9,
        label_text_font_size: "10pt",
        label_text_baseline: "middle"
    });
    return Legend;
})(annotation_1.Annotation);

},{"./annotation":"models/annotations/annotation","core/properties":"core/properties","core/util/array":"core/util/array","core/util/bbox":"core/util/bbox","core/util/object":"core/util/object","core/util/text":"core/util/text","core/util/types":"core/util/types"}],"models/annotations/legend_item":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var bind = function (fn, me) { return function () { return fn.apply(me, arguments); }; }, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, indexOf = [].indexOf || function (item) { for (var i = 0, l = this.length; i < l; i++) {
    if (i in this && this[i] === item)
        return i;
} return -1; };
var model_1 = require("../../model");
var p = require("core/properties");
var logging_1 = require("core/logging");
var array_1 = require("core/util/array");
var column_data_source_1 = require("../../models/sources/column_data_source");
exports.LegendItem = (function (superClass) {
    extend(LegendItem, superClass);
    function LegendItem() {
        this.get_labels_list_from_label_prop = bind(this.get_labels_list_from_label_prop, this);
        this.get_field_from_label_prop = bind(this.get_field_from_label_prop, this);
        return LegendItem.__super__.constructor.apply(this, arguments);
    }
    LegendItem.prototype.type = "LegendItem";
    LegendItem.prototype._check_data_sources_on_renderers = function () {
        var field, i, len, r, ref, source;
        field = this.get_field_from_label_prop();
        if (field != null) {
            if (this.renderers.length < 1) {
                return false;
            }
            source = this.renderers[0].data_source;
            if (source != null) {
                ref = this.renderers;
                for (i = 0, len = ref.length; i < len; i++) {
                    r = ref[i];
                    if (r.data_source !== source) {
                        return false;
                    }
                }
            }
        }
        return true;
    };
    LegendItem.prototype._check_field_label_on_data_source = function () {
        var field, source;
        field = this.get_field_from_label_prop();
        if (field != null) {
            if (this.renderers.length < 1) {
                return false;
            }
            source = this.renderers[0].data_source;
            if ((source != null) && indexOf.call(source.columns(), field) < 0) {
                return false;
            }
        }
        return true;
    };
    LegendItem.prototype.initialize = function (attrs, options) {
        var data_source_validation, field_validation;
        LegendItem.__super__.initialize.call(this, attrs, options);
        data_source_validation = this._check_data_sources_on_renderers();
        if (!data_source_validation) {
            logging_1.logger.error("Non matching data sources on legend item renderers");
        }
        field_validation = this._check_field_label_on_data_source();
        if (!field_validation) {
            return logging_1.logger.error("Bad column name on label: " + this.label);
        }
    };
    LegendItem.define({
        label: [p.StringSpec, null],
        renderers: [p.Array, []]
    });
    LegendItem.prototype.get_field_from_label_prop = function () {
        if ((this.label != null) && (this.label.field != null)) {
            return this.label.field;
        }
    };
    LegendItem.prototype.get_labels_list_from_label_prop = function () {
        var data, field, source;
        if ((this.label != null) && (this.label.value != null)) {
            return [this.label.value];
        }
        field = this.get_field_from_label_prop();
        if (field != null) {
            if (this.renderers[0] && (this.renderers[0].data_source != null)) {
                source = this.renderers[0].data_source;
            }
            else {
                return ["No source found"];
            }
            if (source instanceof column_data_source_1.ColumnDataSource) {
                data = source.get_column(field);
                if (data != null) {
                    return array_1.uniq(data);
                }
                else {
                    return ["Invalid field"];
                }
            }
        }
        return [];
    };
    return LegendItem;
})(model_1.Model);

},{"../../model":"model","../../models/sources/column_data_source":"models/sources/column_data_source","core/logging":"core/logging","core/properties":"core/properties","core/util/array":"core/util/array"}],"models/annotations/poly_annotation":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var annotation_1 = require("./annotation");
var p = require("core/properties");
exports.PolyAnnotationView = (function (superClass) {
    extend(PolyAnnotationView, superClass);
    function PolyAnnotationView() {
        return PolyAnnotationView.__super__.constructor.apply(this, arguments);
    }
    PolyAnnotationView.prototype.bind_bokeh_events = function () {
        this.listenTo(this.model, 'change', this.plot_view.request_render);
        return this.listenTo(this.model, 'data_update', this.plot_view.request_render);
    };
    PolyAnnotationView.prototype.render = function (ctx) {
        var canvas, i, j, ref, sx, sy, vx, vy, xs, ys;
        if (!this.model.visible) {
            return;
        }
        xs = this.model.xs;
        ys = this.model.ys;
        if (xs.length !== ys.length) {
            return null;
        }
        if (xs.length < 3 || ys.length < 3) {
            return null;
        }
        canvas = this.plot_view.canvas;
        ctx = this.plot_view.canvas_view.ctx;
        for (i = j = 0, ref = xs.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            if (this.model.xs_units === 'screen') {
                vx = xs[i];
            }
            if (this.model.ys_units === 'screen') {
                vy = ys[i];
            }
            sx = canvas.vx_to_sx(vx);
            sy = canvas.vy_to_sy(vy);
            if (i === 0) {
                ctx.beginPath();
                ctx.moveTo(sx, sy);
            }
            else {
                ctx.lineTo(sx, sy);
            }
        }
        ctx.closePath();
        if (this.visuals.line.doit) {
            this.visuals.line.set_value(ctx);
            ctx.stroke();
        }
        if (this.visuals.fill.doit) {
            this.visuals.fill.set_value(ctx);
            return ctx.fill();
        }
    };
    return PolyAnnotationView;
})(annotation_1.AnnotationView);
exports.PolyAnnotation = (function (superClass) {
    extend(PolyAnnotation, superClass);
    function PolyAnnotation() {
        return PolyAnnotation.__super__.constructor.apply(this, arguments);
    }
    PolyAnnotation.prototype.default_view = exports.PolyAnnotationView;
    PolyAnnotation.prototype.type = "PolyAnnotation";
    PolyAnnotation.mixins(['line', 'fill']);
    PolyAnnotation.define({
        xs: [p.Array, []],
        xs_units: [p.SpatialUnits, 'data'],
        ys: [p.Array, []],
        ys_units: [p.SpatialUnits, 'data'],
        x_range_name: [p.String, 'default'],
        y_range_name: [p.String, 'default']
    });
    PolyAnnotation.override({
        fill_color: "#fff9ba",
        fill_alpha: 0.4,
        line_color: "#cccccc",
        line_alpha: 0.3
    });
    PolyAnnotation.prototype.update = function (arg) {
        var xs, ys;
        xs = arg.xs, ys = arg.ys;
        this.setv({
            xs: xs,
            ys: ys
        }, {
            silent: true
        });
        return this.trigger('data_update');
    };
    return PolyAnnotation;
})(annotation_1.Annotation);

},{"./annotation":"models/annotations/annotation","core/properties":"core/properties"}],"models/annotations/span":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var annotation_1 = require("./annotation");
var dom_1 = require("core/dom");
var p = require("core/properties");
exports.SpanView = (function (superClass) {
    extend(SpanView, superClass);
    function SpanView() {
        return SpanView.__super__.constructor.apply(this, arguments);
    }
    SpanView.prototype.initialize = function (options) {
        SpanView.__super__.initialize.call(this, options);
        this.plot_view.canvas_overlays.appendChild(this.el);
        this.el.style.position = "absolute";
        return dom_1.hide(this.el);
    };
    SpanView.prototype.bind_bokeh_events = function () {
        if (this.model.for_hover) {
            return this.listenTo(this.model, 'change:computed_location', this._draw_span);
        }
        else {
            if (this.model.render_mode === 'canvas') {
                this.listenTo(this.model, 'change', this.plot_view.request_render);
                return this.listenTo(this.model, 'change:location', this.plot_view.request_render);
            }
            else {
                this.listenTo(this.model, 'change', this.render);
                return this.listenTo(this.model, 'change:location', this._draw_span);
            }
        }
    };
    SpanView.prototype.render = function () {
        if (!this.model.visible && this.model.render_mode === 'css') {
            dom_1.hide(this.el);
        }
        if (!this.model.visible) {
            return;
        }
        return this._draw_span();
    };
    SpanView.prototype._draw_span = function () {
        var canvas, ctx, frame, height, loc, sleft, stop, width, xmapper, ymapper;
        if (this.model.for_hover) {
            loc = this.model.computed_location;
        }
        else {
            loc = this.model.location;
        }
        if (loc == null) {
            dom_1.hide(this.el);
            return;
        }
        frame = this.plot_model.frame;
        canvas = this.plot_model.canvas;
        xmapper = this.plot_view.frame.x_mappers[this.model.x_range_name];
        ymapper = this.plot_view.frame.y_mappers[this.model.y_range_name];
        if (this.model.dimension === 'width') {
            stop = canvas.vy_to_sy(this._calc_dim(loc, ymapper));
            sleft = canvas.vx_to_sx(frame.left);
            width = frame.width;
            height = this.model.properties.line_width.value();
        }
        else {
            stop = canvas.vy_to_sy(frame.top);
            sleft = canvas.vx_to_sx(this._calc_dim(loc, xmapper));
            width = this.model.properties.line_width.value();
            height = frame.height;
        }
        if (this.model.render_mode === "css") {
            this.el.style.top = stop + "px";
            this.el.style.left = sleft + "px";
            this.el.style.width = width + "px";
            this.el.style.height = height + "px";
            this.el.style.zIndex = 1000;
            this.el.style.backgroundColor = this.model.properties.line_color.value();
            this.el.style.opacity = this.model.properties.line_alpha.value();
            return dom_1.show(this.el);
        }
        else if (this.model.render_mode === "canvas") {
            ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            ctx.beginPath();
            this.visuals.line.set_value(ctx);
            ctx.moveTo(sleft, stop);
            if (this.model.dimension === "width") {
                ctx.lineTo(sleft + width, stop);
            }
            else {
                ctx.lineTo(sleft, stop + height);
            }
            ctx.stroke();
            return ctx.restore();
        }
    };
    SpanView.prototype._calc_dim = function (location, mapper) {
        var vdim;
        if (this.model.location_units === 'data') {
            vdim = mapper.map_to_target(location);
        }
        else {
            vdim = location;
        }
        return vdim;
    };
    return SpanView;
})(annotation_1.AnnotationView);
exports.Span = (function (superClass) {
    extend(Span, superClass);
    function Span() {
        return Span.__super__.constructor.apply(this, arguments);
    }
    Span.prototype.default_view = exports.SpanView;
    Span.prototype.type = 'Span';
    Span.mixins(['line']);
    Span.define({
        render_mode: [p.RenderMode, 'canvas'],
        x_range_name: [p.String, 'default'],
        y_range_name: [p.String, 'default'],
        location: [p.Number, null],
        location_units: [p.SpatialUnits, 'data'],
        dimension: [p.Dimension, 'width']
    });
    Span.override({
        line_color: 'black'
    });
    Span.internal({
        for_hover: [p.Boolean, false],
        computed_location: [p.Number, null]
    });
    return Span;
})(annotation_1.Annotation);

},{"./annotation":"models/annotations/annotation","core/dom":"core/dom","core/properties":"core/properties"}],"models/annotations/text_annotation":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var annotation_1 = require("./annotation");
var dom_1 = require("core/dom");
var types_1 = require("core/util/types");
var text_1 = require("core/util/text");
exports.TextAnnotationView = (function (superClass) {
    extend(TextAnnotationView, superClass);
    function TextAnnotationView() {
        return TextAnnotationView.__super__.constructor.apply(this, arguments);
    }
    TextAnnotationView.prototype.initialize = function (options) {
        TextAnnotationView.__super__.initialize.call(this, options);
        this.canvas = this.plot_model.canvas;
        this.frame = this.plot_model.frame;
        if (this.model.render_mode === 'css') {
            this.el.classList.add('bk-annotation');
            return this.plot_view.canvas_overlays.appendChild(this.el);
        }
    };
    TextAnnotationView.prototype.bind_bokeh_events = function () {
        if (this.model.render_mode === 'css') {
            return this.listenTo(this.model, 'change', this.render);
        }
        else {
            return this.listenTo(this.model, 'change', this.plot_view.request_render);
        }
    };
    TextAnnotationView.prototype._calculate_text_dimensions = function (ctx, text) {
        var height, width;
        width = ctx.measureText(text).width;
        height = text_1.get_text_height(this.visuals.text.font_value()).height;
        return [width, height];
    };
    TextAnnotationView.prototype._calculate_bounding_box_dimensions = function (ctx, text) {
        var height, ref, width, x_offset, y_offset;
        ref = this._calculate_text_dimensions(ctx, text), width = ref[0], height = ref[1];
        switch (ctx.textAlign) {
            case 'left':
                x_offset = 0;
                break;
            case 'center':
                x_offset = -width / 2;
                break;
            case 'right':
                x_offset = -width;
        }
        switch (ctx.textBaseline) {
            case 'top':
                y_offset = 0.0;
                break;
            case 'middle':
                y_offset = -0.5 * height;
                break;
            case 'bottom':
                y_offset = -1.0 * height;
                break;
            case 'alphabetic':
                y_offset = -0.8 * height;
                break;
            case 'hanging':
                y_offset = -0.17 * height;
                break;
            case 'ideographic':
                y_offset = -0.83 * height;
        }
        return [x_offset, y_offset, width, height];
    };
    TextAnnotationView.prototype._get_size = function () {
        var ctx;
        ctx = this.plot_view.canvas_view.ctx;
        this.visuals.text.set_value(ctx);
        return ctx.measureText(this.model.text).ascent;
    };
    TextAnnotationView.prototype.render = function () {
        return null;
    };
    TextAnnotationView.prototype._canvas_text = function (ctx, text, sx, sy, angle) {
        var bbox_dims;
        this.visuals.text.set_value(ctx);
        bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
        ctx.save();
        ctx.beginPath();
        ctx.translate(sx, sy);
        if (angle) {
            ctx.rotate(angle);
        }
        ctx.rect(bbox_dims[0], bbox_dims[1], bbox_dims[2], bbox_dims[3]);
        if (this.visuals.background_fill.doit) {
            this.visuals.background_fill.set_value(ctx);
            ctx.fill();
        }
        if (this.visuals.border_line.doit) {
            this.visuals.border_line.set_value(ctx);
            ctx.stroke();
        }
        if (this.visuals.text.doit) {
            this.visuals.text.set_value(ctx);
            ctx.fillText(text, 0, 0);
        }
        return ctx.restore();
    };
    TextAnnotationView.prototype._css_text = function (ctx, text, sx, sy, angle) {
        var bbox_dims, ld, line_dash;
        dom_1.hide(this.el);
        this.visuals.text.set_value(ctx);
        bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
        ld = this.visuals.border_line.line_dash.value();
        if (types_1.isArray(ld)) {
            if (ld.length < 2) {
                line_dash = "solid";
            }
            else {
                line_dash = "dashed";
            }
        }
        if (types_1.isString(ld)) {
            line_dash = ld;
        }
        this.visuals.border_line.set_value(ctx);
        this.visuals.background_fill.set_value(ctx);
        this.el.style.position = 'absolute';
        this.el.style.left = (sx + bbox_dims[0]) + "px";
        this.el.style.top = (sy + bbox_dims[1]) + "px";
        this.el.style.color = "" + (this.visuals.text.text_color.value());
        this.el.style.opacity = "" + (this.visuals.text.text_alpha.value());
        this.el.style.font = "" + (this.visuals.text.font_value());
        this.el.style.lineHeight = "normal";
        if (angle) {
            this.el.style.transform = "rotate(" + angle + "rad)";
        }
        if (this.visuals.background_fill.doit) {
            this.el.style.backgroundColor = "" + (this.visuals.background_fill.color_value());
        }
        if (this.visuals.border_line.doit) {
            this.el.style.borderStyle = "" + line_dash;
            this.el.style.borderWidth = (this.visuals.border_line.line_width.value()) + "px";
            this.el.style.borderColor = "" + (this.visuals.border_line.color_value());
        }
        this.el.textContent = text;
        return dom_1.show(this.el);
    };
    return TextAnnotationView;
})(annotation_1.AnnotationView);
exports.TextAnnotation = (function (superClass) {
    extend(TextAnnotation, superClass);
    function TextAnnotation() {
        return TextAnnotation.__super__.constructor.apply(this, arguments);
    }
    TextAnnotation.prototype.type = 'TextAnnotation';
    TextAnnotation.prototype.default_view = exports.TextAnnotationView;
    return TextAnnotation;
})(annotation_1.Annotation);

},{"./annotation":"models/annotations/annotation","core/dom":"core/dom","core/util/text":"core/util/text","core/util/types":"core/util/types"}],"models/annotations/title":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var text_annotation_1 = require("./text_annotation");
var dom_1 = require("core/dom");
var p = require("core/properties");
var Visuals = require("core/visuals");
exports.TitleView = (function (superClass) {
    extend(TitleView, superClass);
    function TitleView() {
        return TitleView.__super__.constructor.apply(this, arguments);
    }
    TitleView.prototype.initialize = function (options) {
        var ctx;
        TitleView.__super__.initialize.call(this, options);
        this.visuals.text = new Visuals.Text(this.model);
        ctx = this.plot_view.canvas_view.ctx;
        ctx.save();
        this.model.panel.apply_label_text_heuristics(ctx, 'justified');
        this.model.text_baseline = ctx.textBaseline;
        this.model.text_align = this.model.align;
        return ctx.restore();
    };
    TitleView.prototype._get_computed_location = function () {
        var height, ref, sx, sy, vx, vy, width;
        ref = this._calculate_text_dimensions(this.plot_view.canvas_view.ctx, this.text), width = ref[0], height = ref[1];
        switch (this.model.panel.side) {
            case 'left':
                vx = 0;
                vy = this._get_text_location(this.model.align, this.frame.v_range) + this.model.offset;
                break;
            case 'right':
                vx = this.canvas.right - 1;
                vy = this.canvas.height - this._get_text_location(this.model.align, this.frame.v_range) - this.model.offset;
                break;
            case 'above':
                vx = this._get_text_location(this.model.align, this.frame.h_range) + this.model.offset;
                vy = this.canvas.top - 10;
                break;
            case 'below':
                vx = this._get_text_location(this.model.align, this.frame.h_range) + this.model.offset;
                vy = 0;
        }
        sx = this.canvas.vx_to_sx(vx);
        sy = this.canvas.vy_to_sy(vy);
        return [sx, sy];
    };
    TitleView.prototype._get_text_location = function (alignment, range) {
        var text_location;
        switch (alignment) {
            case 'left':
                text_location = range.start;
                break;
            case 'center':
                text_location = (range.end + range.start) / 2;
                break;
            case 'right':
                text_location = range.end;
        }
        return text_location;
    };
    TitleView.prototype.render = function () {
        var angle, ctx, ref, sx, sy;
        if (!this.model.visible && this.model.render_mode === 'css') {
            dom_1.hide(this.el);
        }
        if (!this.model.visible) {
            return;
        }
        angle = this.model.panel.get_label_angle_heuristic('parallel');
        ref = this._get_computed_location(), sx = ref[0], sy = ref[1];
        ctx = this.plot_view.canvas_view.ctx;
        if (this.model.text === "" || this.model.text === null) {
            return;
        }
        if (this.model.render_mode === 'canvas') {
            return this._canvas_text(ctx, this.model.text, sx, sy, angle);
        }
        else {
            return this._css_text(ctx, this.model.text, sx, sy, angle);
        }
    };
    TitleView.prototype._get_size = function () {
        var ctx, text;
        text = this.model.text;
        if (text === "" || text === null) {
            return 0;
        }
        else {
            ctx = this.plot_view.canvas_view.ctx;
            this.visuals.text.set_value(ctx);
            return ctx.measureText(text).ascent + 10;
        }
    };
    return TitleView;
})(text_annotation_1.TextAnnotationView);
exports.Title = (function (superClass) {
    extend(Title, superClass);
    function Title() {
        return Title.__super__.constructor.apply(this, arguments);
    }
    Title.prototype.default_view = exports.TitleView;
    Title.prototype.type = 'Title';
    Title.mixins(['line:border_', 'fill:background_']);
    Title.define({
        text: [p.String],
        text_font: [p.Font, 'helvetica'],
        text_font_size: [p.FontSizeSpec, '10pt'],
        text_font_style: [p.FontStyle, 'bold'],
        text_color: [p.ColorSpec, '#444444'],
        text_alpha: [p.NumberSpec, 1.0],
        align: [p.TextAlign, 'left'],
        offset: [p.Number, 0],
        render_mode: [p.RenderMode, 'canvas']
    });
    Title.override({
        background_fill_color: null,
        border_line_color: null
    });
    Title.internal({
        text_align: [p.TextAlign, 'left'],
        text_baseline: [p.TextBaseline, 'bottom']
    });
    return Title;
})(text_annotation_1.TextAnnotation);

},{"./text_annotation":"models/annotations/text_annotation","core/dom":"core/dom","core/properties":"core/properties","core/visuals":"core/visuals"}],"models/annotations/tooltip":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var annotation_1 = require("./annotation");
var dom_1 = require("core/dom");
var p = require("core/properties");
exports.TooltipView = (function (superClass) {
    extend(TooltipView, superClass);
    function TooltipView() {
        return TooltipView.__super__.constructor.apply(this, arguments);
    }
    TooltipView.prototype.className = "bk-tooltip";
    TooltipView.prototype.initialize = function (options) {
        TooltipView.__super__.initialize.call(this, options);
        this.plot_view.canvas_overlays.appendChild(this.el);
        this.el.style.zIndex = 1010;
        return dom_1.hide(this.el);
    };
    TooltipView.prototype.bind_bokeh_events = function () {
        return this.listenTo(this.model, 'change:data', this._draw_tips);
    };
    TooltipView.prototype.render = function () {
        if (!this.model.visible) {
            return;
        }
        return this._draw_tips();
    };
    TooltipView.prototype._draw_tips = function () {
        var arrow_size, attachment, bottom, content, data, height, i, left, len, side, sx, sy, tip, top, val, vx, vy, width;
        data = this.model.data;
        dom_1.empty(this.el);
        dom_1.hide(this.el);
        if (this.model.custom) {
            this.el.classList.add("bk-tooltip-custom");
        }
        else {
            this.el.classList.remove("bk-tooltip-custom");
        }
        if (data.length === 0) {
            return;
        }
        for (i = 0, len = data.length; i < len; i++) {
            val = data[i];
            vx = val[0], vy = val[1], content = val[2];
            if (this.model.inner_only && !this.plot_view.frame.contains(vx, vy)) {
                continue;
            }
            tip = dom_1.div({}, content);
            this.el.appendChild(tip);
        }
        sx = this.plot_view.model.canvas.vx_to_sx(vx);
        sy = this.plot_view.model.canvas.vy_to_sy(vy);
        attachment = this.model.attachment;
        switch (attachment) {
            case "horizontal":
                width = this.plot_view.frame.width;
                left = this.plot_view.frame.left;
                if (vx - left < width / 2) {
                    side = 'right';
                }
                else {
                    side = 'left';
                }
                break;
            case "vertical":
                height = this.plot_view.frame.height;
                bottom = this.plot_view.frame.bottom;
                if (vy - bottom < height / 2) {
                    side = 'below';
                }
                else {
                    side = 'above';
                }
                break;
            default:
                side = attachment;
        }
        this.el.classList.remove("bk-right");
        this.el.classList.remove("bk-left");
        this.el.classList.remove("bk-above");
        this.el.classList.remove("bk-below");
        arrow_size = 10;
        dom_1.show(this.el);
        switch (side) {
            case "right":
                this.el.classList.add("bk-left");
                left = sx + (this.el.offsetWidth - this.el.clientWidth) + arrow_size;
                top = sy - this.el.offsetHeight / 2;
                break;
            case "left":
                this.el.classList.add("bk-right");
                left = sx - this.el.offsetWidth - arrow_size;
                top = sy - this.el.offsetHeight / 2;
                break;
            case "above":
                this.el.classList.add("bk-above");
                top = sy + (this.el.offsetHeight - this.el.clientHeight) + arrow_size;
                left = Math.round(sx - this.el.offsetWidth / 2);
                break;
            case "below":
                this.el.classList.add("bk-below");
                top = sy - this.el.offsetHeight - arrow_size;
                left = Math.round(sx - this.el.offsetWidth / 2);
        }
        if (this.model.show_arrow) {
            this.el.classList.add("bk-tooltip-arrow");
        }
        if (this.el.childNodes.length > 0) {
            this.el.style.top = top + "px";
            return this.el.style.left = left + "px";
        }
        else {
            return dom_1.hide(this.el);
        }
    };
    return TooltipView;
})(annotation_1.AnnotationView);
exports.Tooltip = (function (superClass) {
    extend(Tooltip, superClass);
    function Tooltip() {
        return Tooltip.__super__.constructor.apply(this, arguments);
    }
    Tooltip.prototype.default_view = exports.TooltipView;
    Tooltip.prototype.type = 'Tooltip';
    Tooltip.define({
        attachment: [p.String, 'horizontal'],
        inner_only: [p.Bool, true],
        show_arrow: [p.Bool, true]
    });
    Tooltip.override({
        level: 'overlay'
    });
    Tooltip.internal({
        data: [p.Any, []],
        custom: [p.Any]
    });
    Tooltip.prototype.clear = function () {
        return this.data = [];
    };
    Tooltip.prototype.add = function (vx, vy, content) {
        var data;
        data = this.data;
        data.push([vx, vy, content]);
        this.data = data;
        return this.trigger('change:data');
    };
    return Tooltip;
})(annotation_1.Annotation);

},{"./annotation":"models/annotations/annotation","core/dom":"core/dom","core/properties":"core/properties"}],"models/axes/axis":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var side_panel_1 = require("core/layout/side_panel");
var guide_renderer_1 = require("../renderers/guide_renderer");
var renderer_1 = require("../renderers/renderer");
var logging_1 = require("core/logging");
var p = require("core/properties");
var types_1 = require("core/util/types");
exports.AxisView = (function (superClass) {
    extend(AxisView, superClass);
    function AxisView() {
        return AxisView.__super__.constructor.apply(this, arguments);
    }
    AxisView.prototype.initialize = function (options) {
        AxisView.__super__.initialize.call(this, options);
        this._x_range_name = this.model.x_range_name;
        return this._y_range_name = this.model.y_range_name;
    };
    AxisView.prototype.render = function () {
        var ctx;
        if (this.model.visible === false) {
            return;
        }
        ctx = this.plot_view.canvas_view.ctx;
        ctx.save();
        this._draw_rule(ctx);
        this._draw_major_ticks(ctx);
        this._draw_minor_ticks(ctx);
        this._draw_major_labels(ctx);
        this._draw_axis_label(ctx);
        return ctx.restore();
    };
    AxisView.prototype.bind_bokeh_events = function () {
        return this.listenTo(this.model, 'change', this.plot_view.request_render);
    };
    AxisView.prototype._get_size = function () {
        return this._tick_extent() + this._tick_label_extent() + this._axis_label_extent();
    };
    AxisView.prototype._draw_rule = function (ctx) {
        var coords, i, k, nx, ny, ref, ref1, ref2, ref3, ref4, sx, sy, x, xoff, y, yoff;
        if (!this.visuals.axis_line.doit) {
            return;
        }
        ref = coords = this.model.rule_coords, x = ref[0], y = ref[1];
        ref1 = this.plot_view.map_to_screen(x, y, this._x_range_name, this._y_range_name), sx = ref1[0], sy = ref1[1];
        ref2 = this.model.normals, nx = ref2[0], ny = ref2[1];
        ref3 = this.model.offsets, xoff = ref3[0], yoff = ref3[1];
        this.visuals.axis_line.set_value(ctx);
        ctx.beginPath();
        ctx.moveTo(Math.round(sx[0] + nx * xoff), Math.round(sy[0] + ny * yoff));
        for (i = k = 1, ref4 = sx.length; 1 <= ref4 ? k < ref4 : k > ref4; i = 1 <= ref4 ? ++k : --k) {
            ctx.lineTo(Math.round(sx[i] + nx * xoff), Math.round(sy[i] + ny * yoff));
        }
        return ctx.stroke();
    };
    AxisView.prototype._draw_major_ticks = function (ctx) {
        var coords, i, k, nx, ny, ref, ref1, ref2, ref3, ref4, results, sx, sy, tin, tout, x, xoff, y, yoff;
        if (!this.visuals.major_tick_line.doit) {
            return;
        }
        coords = this.model.tick_coords;
        ref = coords.major, x = ref[0], y = ref[1];
        ref1 = this.plot_view.map_to_screen(x, y, this._x_range_name, this._y_range_name), sx = ref1[0], sy = ref1[1];
        ref2 = this.model.normals, nx = ref2[0], ny = ref2[1];
        ref3 = this.model.offsets, xoff = ref3[0], yoff = ref3[1];
        tin = this.model.major_tick_in;
        tout = this.model.major_tick_out;
        this.visuals.major_tick_line.set_value(ctx);
        results = [];
        for (i = k = 0, ref4 = sx.length; 0 <= ref4 ? k < ref4 : k > ref4; i = 0 <= ref4 ? ++k : --k) {
            ctx.beginPath();
            ctx.moveTo(Math.round(sx[i] + nx * tout + nx * xoff), Math.round(sy[i] + ny * tout + ny * yoff));
            ctx.lineTo(Math.round(sx[i] - nx * tin + nx * xoff), Math.round(sy[i] - ny * tin + ny * yoff));
            results.push(ctx.stroke());
        }
        return results;
    };
    AxisView.prototype._draw_minor_ticks = function (ctx) {
        var coords, i, k, nx, ny, ref, ref1, ref2, ref3, ref4, results, sx, sy, tin, tout, x, xoff, y, yoff;
        if (!this.visuals.minor_tick_line.doit) {
            return;
        }
        coords = this.model.tick_coords;
        ref = coords.minor, x = ref[0], y = ref[1];
        ref1 = this.plot_view.map_to_screen(x, y, this._x_range_name, this._y_range_name), sx = ref1[0], sy = ref1[1];
        ref2 = this.model.normals, nx = ref2[0], ny = ref2[1];
        ref3 = this.model.offsets, xoff = ref3[0], yoff = ref3[1];
        tin = this.model.minor_tick_in;
        tout = this.model.minor_tick_out;
        this.visuals.minor_tick_line.set_value(ctx);
        results = [];
        for (i = k = 0, ref4 = sx.length; 0 <= ref4 ? k < ref4 : k > ref4; i = 0 <= ref4 ? ++k : --k) {
            ctx.beginPath();
            ctx.moveTo(Math.round(sx[i] + nx * tout + nx * xoff), Math.round(sy[i] + ny * tout + ny * yoff));
            ctx.lineTo(Math.round(sx[i] - nx * tin + nx * xoff), Math.round(sy[i] - ny * tin + ny * yoff));
            results.push(ctx.stroke());
        }
        return results;
    };
    AxisView.prototype._draw_major_labels = function (ctx) {
        var angle, coords, dim, i, k, labels, nx, ny, orient, ref, ref1, ref2, ref3, ref4, results, side, standoff, sx, sy, x, xoff, y, yoff;
        coords = this.model.tick_coords;
        ref = coords.major, x = ref[0], y = ref[1];
        ref1 = this.plot_view.map_to_screen(x, y, this._x_range_name, this._y_range_name), sx = ref1[0], sy = ref1[1];
        ref2 = this.model.normals, nx = ref2[0], ny = ref2[1];
        ref3 = this.model.offsets, xoff = ref3[0], yoff = ref3[1];
        dim = this.model.dimension;
        side = this.model.panel_side;
        orient = this.model.major_label_orientation;
        if (types_1.isString(orient)) {
            angle = this.model.panel.get_label_angle_heuristic(orient);
        }
        else {
            angle = -orient;
        }
        standoff = this._tick_extent() + this.model.major_label_standoff;
        labels = this.model.formatter.doFormat(coords.major[dim], this.model.loc);
        this.visuals.major_label_text.set_value(ctx);
        this.model.panel.apply_label_text_heuristics(ctx, orient);
        results = [];
        for (i = k = 0, ref4 = sx.length; 0 <= ref4 ? k < ref4 : k > ref4; i = 0 <= ref4 ? ++k : --k) {
            if (angle) {
                ctx.translate(sx[i] + nx * standoff + nx * xoff, sy[i] + ny * standoff + ny * yoff);
                ctx.rotate(angle);
                ctx.fillText(labels[i], 0, 0);
                ctx.rotate(-angle);
                results.push(ctx.translate(-sx[i] - nx * standoff + nx * xoff, -sy[i] - ny * standoff + ny * yoff));
            }
            else {
                results.push(ctx.fillText(labels[i], Math.round(sx[i] + nx * standoff + nx * xoff), Math.round(sy[i] + ny * standoff + ny * yoff)));
            }
        }
        return results;
    };
    AxisView.prototype._draw_axis_label = function (ctx) {
        var angle, label, nx, ny, orient, ref, ref1, ref2, ref3, side, standoff, sx, sy, x, xoff, y, yoff;
        label = this.model.axis_label;
        if (label == null) {
            return;
        }
        ref = this.model.rule_coords, x = ref[0], y = ref[1];
        ref1 = this.plot_view.map_to_screen(x, y, this._x_range_name, this._y_range_name), sx = ref1[0], sy = ref1[1];
        ref2 = this.model.normals, nx = ref2[0], ny = ref2[1];
        ref3 = this.model.offsets, xoff = ref3[0], yoff = ref3[1];
        side = this.model.panel_side;
        orient = 'parallel';
        angle = this.model.panel.get_label_angle_heuristic(orient);
        standoff = this._tick_extent() + this._tick_label_extent() + this.model.axis_label_standoff;
        sx = (sx[0] + sx[sx.length - 1]) / 2;
        sy = (sy[0] + sy[sy.length - 1]) / 2;
        this.visuals.axis_label_text.set_value(ctx);
        this.model.panel.apply_label_text_heuristics(ctx, orient);
        x = sx + nx * standoff + nx * xoff;
        y = sy + ny * standoff + ny * yoff;
        if (isNaN(x) || isNaN(y)) {
            return;
        }
        if (angle) {
            ctx.translate(x, y);
            ctx.rotate(angle);
            ctx.fillText(label, 0, 0);
            ctx.rotate(-angle);
            return ctx.translate(-x, -y);
        }
        else {
            return ctx.fillText(label, x, y);
        }
    };
    AxisView.prototype._tick_extent = function () {
        return this.model.major_tick_out;
    };
    AxisView.prototype._tick_label_extent = function () {
        var angle, c, coords, ctx, dim, extent, h, hfactor, hscale, i, k, labels, orient, ref, s, side, val, w, wfactor;
        extent = 0;
        ctx = this.plot_view.canvas_view.ctx;
        dim = this.model.dimension;
        coords = this.model.tick_coords.major;
        side = this.model.panel_side;
        orient = this.model.major_label_orientation;
        labels = this.model.formatter.doFormat(coords[dim], this.model.loc);
        this.visuals.major_label_text.set_value(ctx);
        if (types_1.isString(orient)) {
            hscale = 1;
            angle = this.model.panel.get_label_angle_heuristic(orient);
        }
        else {
            hscale = 2;
            angle = -orient;
        }
        angle = Math.abs(angle);
        c = Math.cos(angle);
        s = Math.sin(angle);
        if (side === "above" || side === "below") {
            wfactor = s;
            hfactor = c;
        }
        else {
            wfactor = c;
            hfactor = s;
        }
        for (i = k = 0, ref = labels.length; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
            if (labels[i] == null) {
                continue;
            }
            w = ctx.measureText(labels[i]).width * 1.1;
            h = ctx.measureText(labels[i]).ascent * 0.9;
            val = w * wfactor + (h / hscale) * hfactor;
            if (val > extent) {
                extent = val;
            }
        }
        if (extent > 0) {
            extent += this.model.major_label_standoff;
        }
        return extent;
    };
    AxisView.prototype._axis_label_extent = function () {
        var angle, axis_label, c, ctx, extent, h, orient, s, side, w;
        extent = 0;
        side = this.model.panel_side;
        axis_label = this.model.axis_label;
        orient = 'parallel';
        ctx = this.plot_view.canvas_view.ctx;
        this.visuals.axis_label_text.set_value(ctx);
        angle = Math.abs(this.model.panel.get_label_angle_heuristic(orient));
        c = Math.cos(angle);
        s = Math.sin(angle);
        if (axis_label) {
            extent += this.model.axis_label_standoff;
            this.visuals.axis_label_text.set_value(ctx);
            w = ctx.measureText(axis_label).width * 1.1;
            h = ctx.measureText(axis_label).ascent * 0.9;
            if (side === "above" || side === "below") {
                extent += w * s + h * c;
            }
            else {
                extent += w * c + h * s;
            }
        }
        return extent;
    };
    return AxisView;
})(renderer_1.RendererView);
exports.Axis = (function (superClass) {
    extend(Axis, superClass);
    function Axis() {
        return Axis.__super__.constructor.apply(this, arguments);
    }
    Axis.prototype.default_view = exports.AxisView;
    Axis.prototype.type = 'Axis';
    Axis.mixins(['line:axis_', 'line:major_tick_', 'line:minor_tick_', 'text:major_label_', 'text:axis_label_']);
    Axis.define({
        bounds: [p.Any, 'auto'],
        ticker: [p.Instance, null],
        formatter: [p.Instance, null],
        x_range_name: [p.String, 'default'],
        y_range_name: [p.String, 'default'],
        axis_label: [p.String, ''],
        axis_label_standoff: [p.Int, 5],
        major_label_standoff: [p.Int, 5],
        major_label_orientation: [p.Any, "horizontal"],
        major_tick_in: [p.Number, 2],
        major_tick_out: [p.Number, 6],
        minor_tick_in: [p.Number, 0],
        minor_tick_out: [p.Number, 4]
    });
    Axis.override({
        axis_line_color: 'black',
        major_tick_line_color: 'black',
        minor_tick_line_color: 'black',
        major_label_text_font_size: "8pt",
        major_label_text_align: "center",
        major_label_text_baseline: "alphabetic",
        axis_label_text_font_size: "10pt",
        axis_label_text_font_style: "italic"
    });
    Axis.internal({
        panel_side: [p.Any]
    });
    Axis.prototype.initialize = function (attrs, options) {
        Axis.__super__.initialize.call(this, attrs, options);
        this.define_computed_property('computed_bounds', this._computed_bounds, false);
        this.add_dependencies('computed_bounds', this, ['bounds']);
        return this.add_dependencies('computed_bounds', this.plot, ['x_range', 'y_range']);
    };
    Axis.getters({
        computed_bounds: function () {
            return this._get_computed('computed_bounds');
        },
        rule_coords: function () {
            return this._rule_coords();
        },
        tick_coords: function () {
            return this._tick_coords();
        },
        ranges: function () {
            return this._ranges();
        },
        normals: function () {
            return this.panel._normals;
        },
        dimension: function () {
            return this.panel._dim;
        },
        offsets: function () {
            return this._offsets();
        },
        loc: function () {
            return this._get_loc();
        }
    });
    Axis.prototype.add_panel = function (side) {
        this.panel = new side_panel_1.SidePanel({
            side: side
        });
        this.panel.attach_document(this.document);
        return this.panel_side = side;
    };
    Axis.prototype._offsets = function () {
        var frame, ref, side, xoff, yoff;
        side = this.panel_side;
        ref = [0, 0], xoff = ref[0], yoff = ref[1];
        frame = this.plot.plot_canvas.frame;
        switch (side) {
            case "below":
                yoff = Math.abs(this.panel.top - frame.bottom);
                break;
            case "above":
                yoff = Math.abs(this.panel.bottom - frame.top);
                break;
            case "right":
                xoff = Math.abs(this.panel.left - frame.right);
                break;
            case "left":
                xoff = Math.abs(this.panel.right - frame.left);
        }
        return [xoff, yoff];
    };
    Axis.prototype._ranges = function () {
        var frame, i, j, ranges;
        i = this.dimension;
        j = (i + 1) % 2;
        frame = this.plot.plot_canvas.frame;
        ranges = [frame.x_ranges[this.x_range_name], frame.y_ranges[this.y_range_name]];
        return [ranges[i], ranges[j]];
    };
    Axis.prototype._computed_bounds = function () {
        var cross_range, end, range, range_bounds, ref, ref1, start, user_bounds;
        ref = this.ranges, range = ref[0], cross_range = ref[1];
        user_bounds = (ref1 = this.bounds) != null ? ref1 : 'auto';
        range_bounds = [range.min, range.max];
        if (user_bounds === 'auto') {
            return range_bounds;
        }
        if (types_1.isArray(user_bounds)) {
            if (Math.abs(user_bounds[0] - user_bounds[1]) > Math.abs(range_bounds[0] - range_bounds[1])) {
                start = Math.max(Math.min(user_bounds[0], user_bounds[1]), range_bounds[0]);
                end = Math.min(Math.max(user_bounds[0], user_bounds[1]), range_bounds[1]);
            }
            else {
                start = Math.min(user_bounds[0], user_bounds[1]);
                end = Math.max(user_bounds[0], user_bounds[1]);
            }
            return [start, end];
        }
        logging_1.logger.error("user bounds '" + user_bounds + "' not understood");
        return null;
    };
    Axis.prototype._rule_coords = function () {
        var coords, cross_range, end, i, j, range, ref, ref1, start, xs, ys;
        i = this.dimension;
        j = (i + 1) % 2;
        ref = this.ranges, range = ref[0], cross_range = ref[1];
        ref1 = this.computed_bounds, start = ref1[0], end = ref1[1];
        xs = new Array(2);
        ys = new Array(2);
        coords = [xs, ys];
        coords[i][0] = Math.max(start, range.min);
        coords[i][1] = Math.min(end, range.max);
        if (coords[i][0] > coords[i][1]) {
            coords[i][0] = coords[i][1] = 0 / 0;
        }
        coords[j][0] = this.loc;
        coords[j][1] = this.loc;
        return coords;
    };
    Axis.prototype._tick_coords = function () {
        var coords, cross_range, end, i, ii, j, k, l, m, majors, minor_coords, minor_xs, minor_ys, minors, range, range_max, range_min, ref, ref1, ref2, ref3, ref4, ref5, start, ticks, xs, ys;
        i = this.dimension;
        j = (i + 1) % 2;
        ref = this.ranges, range = ref[0], cross_range = ref[1];
        ref1 = this.computed_bounds, start = ref1[0], end = ref1[1];
        ticks = this.ticker.get_ticks(start, end, range, this.loc, {});
        majors = ticks.major;
        minors = ticks.minor;
        xs = [];
        ys = [];
        coords = [xs, ys];
        minor_xs = [];
        minor_ys = [];
        minor_coords = [minor_xs, minor_ys];
        if (range.type === "FactorRange") {
            for (ii = k = 0, ref2 = majors.length; 0 <= ref2 ? k < ref2 : k > ref2; ii = 0 <= ref2 ? ++k : --k) {
                coords[i].push(majors[ii]);
                coords[j].push(this.loc);
            }
        }
        else {
            ref3 = [range.min, range.max], range_min = ref3[0], range_max = ref3[1];
            for (ii = l = 0, ref4 = majors.length; 0 <= ref4 ? l < ref4 : l > ref4; ii = 0 <= ref4 ? ++l : --l) {
                if (majors[ii] < range_min || majors[ii] > range_max) {
                    continue;
                }
                coords[i].push(majors[ii]);
                coords[j].push(this.loc);
            }
            for (ii = m = 0, ref5 = minors.length; 0 <= ref5 ? m < ref5 : m > ref5; ii = 0 <= ref5 ? ++m : --m) {
                if (minors[ii] < range_min || minors[ii] > range_max) {
                    continue;
                }
                minor_coords[i].push(minors[ii]);
                minor_coords[j].push(this.loc);
            }
        }
        return {
            "major": coords,
            "minor": minor_coords
        };
    };
    Axis.prototype._get_loc = function () {
        var cend, cross_range, cstart, range, ref, side;
        ref = this.ranges, range = ref[0], cross_range = ref[1];
        cstart = cross_range.start;
        cend = cross_range.end;
        side = this.panel_side;
        switch (side) {
            case 'left':
            case 'below':
                return cross_range.start;
            case 'right':
            case 'above':
                return cross_range.end;
        }
    };
    return Axis;
})(guide_renderer_1.GuideRenderer);

},{"../renderers/guide_renderer":"models/renderers/guide_renderer","../renderers/renderer":"models/renderers/renderer","core/layout/side_panel":"core/layout/side_panel","core/logging":"core/logging","core/properties":"core/properties","core/util/types":"core/util/types"}],"models/axes/categorical_axis":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var axis_1 = require("./axis");
var categorical_tick_formatter_1 = require("../formatters/categorical_tick_formatter");
var categorical_ticker_1 = require("../tickers/categorical_ticker");
var logging_1 = require("core/logging");
exports.CategoricalAxisView = (function (superClass) {
    extend(CategoricalAxisView, superClass);
    function CategoricalAxisView() {
        return CategoricalAxisView.__super__.constructor.apply(this, arguments);
    }
    return CategoricalAxisView;
})(axis_1.AxisView);
exports.CategoricalAxis = (function (superClass) {
    extend(CategoricalAxis, superClass);
    function CategoricalAxis() {
        return CategoricalAxis.__super__.constructor.apply(this, arguments);
    }
    CategoricalAxis.prototype.default_view = exports.CategoricalAxisView;
    CategoricalAxis.prototype.type = 'CategoricalAxis';
    CategoricalAxis.override({
        ticker: function () {
            return new categorical_ticker_1.CategoricalTicker();
        },
        formatter: function () {
            return new categorical_tick_formatter_1.CategoricalTickFormatter();
        }
    });
    CategoricalAxis.prototype._computed_bounds = function () {
        var cross_range, range, range_bounds, ref, ref1, user_bounds;
        ref = this.ranges, range = ref[0], cross_range = ref[1];
        user_bounds = (ref1 = this.bounds) != null ? ref1 : 'auto';
        range_bounds = [range.min, range.max];
        if (user_bounds !== 'auto') {
            logging_1.logger.warn("Categorical Axes only support user_bounds='auto', ignoring");
        }
        return range_bounds;
    };
    return CategoricalAxis;
})(axis_1.Axis);

},{"../formatters/categorical_tick_formatter":"models/formatters/categorical_tick_formatter","../tickers/categorical_ticker":"models/tickers/categorical_ticker","./axis":"models/axes/axis","core/logging":"core/logging"}],"models/axes/continuous_axis":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var axis_1 = require("./axis");
exports.ContinuousAxis = (function (superClass) {
    extend(ContinuousAxis, superClass);
    function ContinuousAxis() {
        return ContinuousAxis.__super__.constructor.apply(this, arguments);
    }
    ContinuousAxis.prototype.type = 'ContinuousAxis';
    return ContinuousAxis;
})(axis_1.Axis);

},{"./axis":"models/axes/axis"}],"models/axes/datetime_axis":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var linear_axis_1 = require("./linear_axis");
var datetime_tick_formatter_1 = require("../formatters/datetime_tick_formatter");
var datetime_ticker_1 = require("../tickers/datetime_ticker");
exports.DatetimeAxisView = (function (superClass) {
    extend(DatetimeAxisView, superClass);
    function DatetimeAxisView() {
        return DatetimeAxisView.__super__.constructor.apply(this, arguments);
    }
    return DatetimeAxisView;
})(linear_axis_1.LinearAxisView);
exports.DatetimeAxis = (function (superClass) {
    extend(DatetimeAxis, superClass);
    function DatetimeAxis() {
        return DatetimeAxis.__super__.constructor.apply(this, arguments);
    }
    DatetimeAxis.prototype.default_view = exports.DatetimeAxisView;
    DatetimeAxis.prototype.type = 'DatetimeAxis';
    DatetimeAxis.override({
        ticker: function () {
            return new datetime_ticker_1.DatetimeTicker();
        },
        formatter: function () {
            return new datetime_tick_formatter_1.DatetimeTickFormatter();
        }
    });
    return DatetimeAxis;
})(linear_axis_1.LinearAxis);

},{"../formatters/datetime_tick_formatter":"models/formatters/datetime_tick_formatter","../tickers/datetime_ticker":"models/tickers/datetime_ticker","./linear_axis":"models/axes/linear_axis"}],"models/axes/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var axis_1 = require("./axis");
exports.Axis = axis_1.Axis;
var categorical_axis_1 = require("./categorical_axis");
exports.CategoricalAxis = categorical_axis_1.CategoricalAxis;
var continuous_axis_1 = require("./continuous_axis");
exports.ContinuousAxis = continuous_axis_1.ContinuousAxis;
var datetime_axis_1 = require("./datetime_axis");
exports.DatetimeAxis = datetime_axis_1.DatetimeAxis;
var linear_axis_1 = require("./linear_axis");
exports.LinearAxis = linear_axis_1.LinearAxis;
var log_axis_1 = require("./log_axis");
exports.LogAxis = log_axis_1.LogAxis;

},{"./axis":"models/axes/axis","./categorical_axis":"models/axes/categorical_axis","./continuous_axis":"models/axes/continuous_axis","./datetime_axis":"models/axes/datetime_axis","./linear_axis":"models/axes/linear_axis","./log_axis":"models/axes/log_axis"}],"models/axes/linear_axis":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var axis_1 = require("./axis");
var continuous_axis_1 = require("./continuous_axis");
var basic_tick_formatter_1 = require("../formatters/basic_tick_formatter");
var basic_ticker_1 = require("../tickers/basic_ticker");
exports.LinearAxisView = (function (superClass) {
    extend(LinearAxisView, superClass);
    function LinearAxisView() {
        return LinearAxisView.__super__.constructor.apply(this, arguments);
    }
    return LinearAxisView;
})(axis_1.AxisView);
exports.LinearAxis = (function (superClass) {
    extend(LinearAxis, superClass);
    function LinearAxis() {
        return LinearAxis.__super__.constructor.apply(this, arguments);
    }
    LinearAxis.prototype.default_view = exports.LinearAxisView;
    LinearAxis.prototype.type = 'LinearAxis';
    LinearAxis.override({
        ticker: function () {
            return new basic_ticker_1.BasicTicker();
        },
        formatter: function () {
            return new basic_tick_formatter_1.BasicTickFormatter();
        }
    });
    return LinearAxis;
})(continuous_axis_1.ContinuousAxis);

},{"../formatters/basic_tick_formatter":"models/formatters/basic_tick_formatter","../tickers/basic_ticker":"models/tickers/basic_ticker","./axis":"models/axes/axis","./continuous_axis":"models/axes/continuous_axis"}],"models/axes/log_axis":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var axis_1 = require("./axis");
var continuous_axis_1 = require("./continuous_axis");
var log_tick_formatter_1 = require("../formatters/log_tick_formatter");
var log_ticker_1 = require("../tickers/log_ticker");
exports.LogAxisView = (function (superClass) {
    extend(LogAxisView, superClass);
    function LogAxisView() {
        return LogAxisView.__super__.constructor.apply(this, arguments);
    }
    return LogAxisView;
})(axis_1.AxisView);
exports.LogAxis = (function (superClass) {
    extend(LogAxis, superClass);
    function LogAxis() {
        return LogAxis.__super__.constructor.apply(this, arguments);
    }
    LogAxis.prototype.default_view = exports.LogAxisView;
    LogAxis.prototype.type = 'LogAxis';
    LogAxis.override({
        ticker: function () {
            return new log_ticker_1.LogTicker();
        },
        formatter: function () {
            return new log_tick_formatter_1.LogTickFormatter();
        }
    });
    return LogAxis;
})(continuous_axis_1.ContinuousAxis);

},{"../formatters/log_tick_formatter":"models/formatters/log_tick_formatter","../tickers/log_ticker":"models/tickers/log_ticker","./axis":"models/axes/axis","./continuous_axis":"models/axes/continuous_axis"}],"models/callbacks/customjs":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, slice = [].slice;
var p = require("core/properties");
var object_1 = require("core/util/object");
var model_1 = require("../../model");
exports.CustomJS = (function (superClass) {
    extend(CustomJS, superClass);
    function CustomJS() {
        return CustomJS.__super__.constructor.apply(this, arguments);
    }
    CustomJS.prototype.type = 'CustomJS';
    CustomJS.define({
        args: [p.Any, {}],
        code: [p.String, '']
    });
    CustomJS.getters({
        values: function () {
            return this._make_values();
        },
        func: function () {
            return this._make_func();
        }
    });
    CustomJS.prototype.execute = function (cb_obj, cb_data) {
        return this.func.apply(this, slice.call(this.values).concat([cb_obj], [cb_data], [require], [{}]));
    };
    CustomJS.prototype._make_values = function () {
        return object_1.values(this.args);
    };
    CustomJS.prototype._make_func = function () {
        return (function (func, args, ctor) {
            ctor.prototype = func.prototype;
            var child = new ctor, result = func.apply(child, args);
            return Object(result) === result ? result : child;
        })(Function, slice.call(Object.keys(this.args)).concat(["cb_obj"], ["cb_data"], ["require"], ["exports"], [this.code]), function () { });
    };
    return CustomJS;
})(model_1.Model);

},{"../../model":"model","core/properties":"core/properties","core/util/object":"core/util/object"}],"models/callbacks/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var customjs_1 = require("./customjs");
exports.CustomJS = customjs_1.CustomJS;
var open_url_1 = require("./open_url");
exports.OpenURL = open_url_1.OpenURL;

},{"./customjs":"models/callbacks/customjs","./open_url":"models/callbacks/open_url"}],"models/callbacks/open_url":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var model_1 = require("../../model");
var p = require("core/properties");
var selection_1 = require("core/util/selection");
var templating_1 = require("core/util/templating");
exports.OpenURL = (function (superClass) {
    extend(OpenURL, superClass);
    function OpenURL() {
        return OpenURL.__super__.constructor.apply(this, arguments);
    }
    OpenURL.prototype.type = 'OpenURL';
    OpenURL.define({
        url: [p.String, 'http://']
    });
    OpenURL.prototype.execute = function (data_source) {
        var i, j, len, ref, url;
        ref = selection_1.get_indices(data_source);
        for (j = 0, len = ref.length; j < len; j++) {
            i = ref[j];
            url = templating_1.replace_placeholders(this.url, data_source, i);
            window.open(url);
        }
        return null;
    };
    return OpenURL;
})(model_1.Model);

},{"../../model":"model","core/properties":"core/properties","core/util/selection":"core/util/selection","core/util/templating":"core/util/templating"}],"models/canvas/canvas":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var canvas_template_1 = require("./canvas_template");
var layout_canvas_1 = require("core/layout/layout_canvas");
var bokeh_view_1 = require("core/bokeh_view");
var solver_1 = require("core/layout/solver");
var logging_1 = require("core/logging");
var p = require("core/properties");
var eq_1 = require("core/util/eq");
var canvas_1 = require("core/util/canvas");
exports.CanvasView = (function (superClass) {
    extend(CanvasView, superClass);
    function CanvasView() {
        return CanvasView.__super__.constructor.apply(this, arguments);
    }
    CanvasView.prototype.className = "bk-canvas-wrapper";
    CanvasView.prototype.template = canvas_template_1.default;
    CanvasView.prototype.initialize = function (options) {
        var html;
        CanvasView.__super__.initialize.call(this, options);
        html = this.template({
            map: this.model.map
        });
        this.el.appendChild(html);
        this.ctx = this.get_ctx();
        canvas_1.fixup_line_dash(this.ctx);
        canvas_1.fixup_line_dash_offset(this.ctx);
        canvas_1.fixup_image_smoothing(this.ctx);
        canvas_1.fixup_measure_text(this.ctx);
        canvas_1.fixup_ellipse(this.ctx);
        if (window.CanvasPixelArray != null) {
            CanvasPixelArray.prototype.set = function (arr) {
                var i, j, ref, results;
                results = [];
                for (i = j = 0, ref = this.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                    results.push(this[i] = arr[i]);
                }
                return results;
            };
        }
        this.map_div = this.el.querySelector('div.bk-canvas-map');
        this.set_dims([this.model.initial_width, this.model.initial_height]);
        return logging_1.logger.debug("CanvasView initialized");
    };
    CanvasView.prototype.get_canvas_element = function () {
        return this.el.querySelector('canvas.bk-canvas');
    };
    CanvasView.prototype.get_ctx = function () {
        return this.get_canvas_element().getContext('2d');
    };
    CanvasView.prototype.prepare_canvas = function (force) {
        var canvas_el, dpr, height, ratio, width;
        if (force == null) {
            force = false;
        }
        width = this.model._width._value;
        height = this.model._height._value;
        dpr = window.devicePixelRatio;
        if (!eq_1.isEqual(this.last_dims, [width, height, dpr]) || force) {
            this.el.style.width = width + "px";
            this.el.style.height = height + "px";
            this.pixel_ratio = ratio = canvas_1.get_scale_ratio(this.ctx, this.model.use_hidpi);
            canvas_el = this.get_canvas_element();
            canvas_el.style.width = width + "px";
            canvas_el.style.height = height + "px";
            canvas_el.setAttribute('width', width * ratio);
            canvas_el.setAttribute('height', height * ratio);
            logging_1.logger.debug("Rendering CanvasView [force=" + force + "] with width: " + width + ", height: " + height + ", ratio: " + ratio);
            this.model.pixel_ratio = this.pixel_ratio;
            return this.last_dims = [width, height, dpr];
        }
    };
    CanvasView.prototype.set_dims = function (dims, trigger) {
        if (trigger == null) {
            trigger = true;
        }
        this.requested_width = dims[0];
        this.requested_height = dims[1];
        this.update_constraints(trigger);
    };
    CanvasView.prototype.update_constraints = function (trigger) {
        var MIN_SIZE, requested_height, requested_width, s;
        if (trigger == null) {
            trigger = true;
        }
        requested_width = this.requested_width;
        requested_height = this.requested_height;
        if ((requested_width == null) || (requested_height == null)) {
            return;
        }
        MIN_SIZE = 50;
        if (requested_width < MIN_SIZE || requested_height < MIN_SIZE) {
            return;
        }
        if (eq_1.isEqual(this.last_requested_dims, [requested_width, requested_height])) {
            return;
        }
        s = this.model.document.solver();
        if (this._width_constraint != null) {
            s.remove_constraint(this._width_constraint, true);
        }
        this._width_constraint = solver_1.EQ(this.model._width, -requested_width);
        s.add_constraint(this._width_constraint);
        if (this._height_constraint != null) {
            s.remove_constraint(this._height_constraint, true);
        }
        this._height_constraint = solver_1.EQ(this.model._height, -requested_height);
        s.add_constraint(this._height_constraint);
        this.last_requested_dims = [requested_width, requested_height];
        return s.update_variables(trigger);
    };
    return CanvasView;
})(bokeh_view_1.BokehView);
exports.Canvas = (function (superClass) {
    extend(Canvas, superClass);
    function Canvas() {
        return Canvas.__super__.constructor.apply(this, arguments);
    }
    Canvas.prototype.type = 'Canvas';
    Canvas.prototype.default_view = exports.CanvasView;
    Canvas.internal({
        map: [p.Boolean, false],
        initial_width: [p.Number],
        initial_height: [p.Number],
        use_hidpi: [p.Boolean, true],
        pixel_ratio: [p.Number]
    });
    Canvas.prototype.initialize = function (attrs, options) {
        Canvas.__super__.initialize.call(this, attrs, options);
        return this.panel = this;
    };
    Canvas.prototype.vx_to_sx = function (x) {
        return x;
    };
    Canvas.prototype.vy_to_sy = function (y) {
        return this._height._value - (y + 1);
    };
    Canvas.prototype.v_vx_to_sx = function (xx) {
        return new Float64Array(xx);
    };
    Canvas.prototype.v_vy_to_sy = function (yy) {
        var _yy, height, idx, j, len, y;
        _yy = new Float64Array(yy.length);
        height = this._height._value;
        for (idx = j = 0, len = yy.length; j < len; idx = ++j) {
            y = yy[idx];
            _yy[idx] = height - (y + 1);
        }
        return _yy;
    };
    Canvas.prototype.sx_to_vx = function (x) {
        return x;
    };
    Canvas.prototype.sy_to_vy = function (y) {
        return this._height._value - (y + 1);
    };
    Canvas.prototype.v_sx_to_vx = function (xx) {
        return new Float64Array(xx);
    };
    Canvas.prototype.v_sy_to_vy = function (yy) {
        var _yy, height, idx, j, len, y;
        _yy = new Float64Array(yy.length);
        height = this._height._value;
        for (idx = j = 0, len = yy.length; j < len; idx = ++j) {
            y = yy[idx];
            _yy[idx] = height - (y + 1);
        }
        return _yy;
    };
    Canvas.prototype.get_constraints = function () {
        var constraints;
        constraints = Canvas.__super__.get_constraints.call(this);
        constraints.push(solver_1.GE(this._top));
        constraints.push(solver_1.GE(this._bottom));
        constraints.push(solver_1.GE(this._left));
        constraints.push(solver_1.GE(this._right));
        constraints.push(solver_1.GE(this._width));
        constraints.push(solver_1.GE(this._height));
        constraints.push(solver_1.EQ(this._width, [-1, this._right]));
        constraints.push(solver_1.EQ(this._height, [-1, this._top]));
        return constraints;
    };
    return Canvas;
})(layout_canvas_1.LayoutCanvas);

},{"./canvas_template":"models/canvas/canvas_template","core/bokeh_view":"core/bokeh_view","core/layout/layout_canvas":"core/layout/layout_canvas","core/layout/solver":"core/layout/solver","core/logging":"core/logging","core/properties":"core/properties","core/util/canvas":"core/util/canvas","core/util/eq":"core/util/eq"}],"models/canvas/canvas_template":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var DOM = require("core/dom");
exports.default = function (props) {
    return (DOM.createElement("fragment", null,
        props.map && DOM.createElement("div", { class: "bk-canvas-map" }),
        DOM.createElement("div", { class: "bk-canvas-events" }),
        DOM.createElement("div", { class: "bk-canvas-overlays" }),
        DOM.createElement("canvas", { class: 'bk-canvas' })));
};

},{"core/dom":"core/dom"}],"models/canvas/cartesian_frame":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var categorical_mapper_1 = require("../mappers/categorical_mapper");
var linear_mapper_1 = require("../mappers/linear_mapper");
var log_mapper_1 = require("../mappers/log_mapper");
var range1d_1 = require("../ranges/range1d");
var solver_1 = require("core/layout/solver");
var layout_canvas_1 = require("core/layout/layout_canvas");
var logging_1 = require("core/logging");
var p = require("core/properties");
exports.CartesianFrame = (function (superClass) {
    extend(CartesianFrame, superClass);
    function CartesianFrame() {
        return CartesianFrame.__super__.constructor.apply(this, arguments);
    }
    CartesianFrame.prototype.type = 'CartesianFrame';
    CartesianFrame.prototype.initialize = function (attrs, options) {
        CartesianFrame.__super__.initialize.call(this, attrs, options);
        this.panel = this;
        this._configure_mappers();
        this.listenTo(this, 'change', (function (_this) {
            return function () {
                return _this._configure_mappers();
            };
        })(this));
        return null;
    };
    CartesianFrame.prototype._doc_attached = function () {
        this.listenTo(this.document.solver(), 'layout_update', (function (_this) {
            return function () {
                return _this._update_mappers();
            };
        })(this));
        return null;
    };
    CartesianFrame.prototype.contains = function (vx, vy) {
        return vx >= this.left && vx <= this.right && vy >= this.bottom && vy <= this.top;
    };
    CartesianFrame.prototype.map_to_screen = function (x, y, canvas, x_name, y_name) {
        var sx, sy, vx, vy;
        if (x_name == null) {
            x_name = 'default';
        }
        if (y_name == null) {
            y_name = 'default';
        }
        vx = this.x_mappers[x_name].v_map_to_target(x);
        sx = canvas.v_vx_to_sx(vx);
        vy = this.y_mappers[y_name].v_map_to_target(y);
        sy = canvas.v_vy_to_sy(vy);
        return [sx, sy];
    };
    CartesianFrame.prototype._get_ranges = function (range, extra_ranges) {
        var extra_range, name, ranges;
        ranges = {};
        ranges['default'] = range;
        if (extra_ranges != null) {
            for (name in extra_ranges) {
                extra_range = extra_ranges[name];
                ranges[name] = extra_range;
            }
        }
        return ranges;
    };
    CartesianFrame.prototype._get_mappers = function (mapper_type, ranges, frame_range) {
        var mapper_model, mappers, name, range;
        mappers = {};
        for (name in ranges) {
            range = ranges[name];
            if (range.type === "Range1d" || range.type === "DataRange1d") {
                if (mapper_type === "log") {
                    mapper_model = log_mapper_1.LogMapper;
                }
                else {
                    mapper_model = linear_mapper_1.LinearMapper;
                }
                range.mapper_hint = mapper_type;
            }
            else if (range.type === "FactorRange") {
                mapper_model = categorical_mapper_1.CategoricalMapper;
            }
            else {
                logging_1.logger.warn("unknown range type for range '" + name + "': " + range);
                return null;
            }
            mappers[name] = new mapper_model({
                source_range: range,
                target_range: frame_range
            });
        }
        return mappers;
    };
    CartesianFrame.prototype._configure_frame_ranges = function () {
        this._h_range = new range1d_1.Range1d({
            start: this.left,
            end: this.left + this.width
        });
        return this._v_range = new range1d_1.Range1d({
            start: this.bottom,
            end: this.bottom + this.height
        });
    };
    CartesianFrame.prototype._configure_mappers = function () {
        this._configure_frame_ranges();
        this._x_ranges = this._get_ranges(this.x_range, this.extra_x_ranges);
        this._y_ranges = this._get_ranges(this.y_range, this.extra_y_ranges);
        this._x_mappers = this._get_mappers(this.x_mapper_type, this._x_ranges, this._h_range);
        return this._y_mappers = this._get_mappers(this.y_mapper_type, this._y_ranges, this._v_range);
    };
    CartesianFrame.prototype._update_mappers = function () {
        var mapper, name, ref, ref1;
        this._configure_frame_ranges();
        ref = this._x_mappers;
        for (name in ref) {
            mapper = ref[name];
            mapper.target_range = this._h_range;
        }
        ref1 = this._y_mappers;
        for (name in ref1) {
            mapper = ref1[name];
            mapper.target_range = this._v_range;
        }
        return null;
    };
    CartesianFrame.getters({
        h_range: function () {
            return this._h_range;
        },
        v_range: function () {
            return this._v_range;
        },
        x_ranges: function () {
            return this._x_ranges;
        },
        y_ranges: function () {
            return this._y_ranges;
        },
        x_mappers: function () {
            return this._x_mappers;
        },
        y_mappers: function () {
            return this._y_mappers;
        }
    });
    CartesianFrame.internal({
        extra_x_ranges: [p.Any, {}],
        extra_y_ranges: [p.Any, {}],
        x_range: [p.Instance],
        y_range: [p.Instance],
        x_mapper_type: [p.String, 'auto'],
        y_mapper_type: [p.String, 'auto']
    });
    CartesianFrame.prototype.get_constraints = function () {
        var constraints;
        constraints = [];
        constraints.push(solver_1.GE(this._top));
        constraints.push(solver_1.GE(this._bottom));
        constraints.push(solver_1.GE(this._left));
        constraints.push(solver_1.GE(this._right));
        constraints.push(solver_1.GE(this._width));
        constraints.push(solver_1.GE(this._height));
        constraints.push(solver_1.EQ(this._left, this._width, [-1, this._right]));
        constraints.push(solver_1.EQ(this._bottom, this._height, [-1, this._top]));
        return constraints;
    };
    return CartesianFrame;
})(layout_canvas_1.LayoutCanvas);

},{"../mappers/categorical_mapper":"models/mappers/categorical_mapper","../mappers/linear_mapper":"models/mappers/linear_mapper","../mappers/log_mapper":"models/mappers/log_mapper","../ranges/range1d":"models/ranges/range1d","core/layout/layout_canvas":"core/layout/layout_canvas","core/layout/solver":"core/layout/solver","core/logging":"core/logging","core/properties":"core/properties"}],"models/canvas/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("./canvas");
exports.Canvas = canvas_1.Canvas;
var cartesian_frame_1 = require("./cartesian_frame");
exports.CartesianFrame = cartesian_frame_1.CartesianFrame;

},{"./canvas":"models/canvas/canvas","./cartesian_frame":"models/canvas/cartesian_frame"}],"models/formatters/basic_tick_formatter":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var tick_formatter_1 = require("./tick_formatter");
var p = require("core/properties");
var types_1 = require("core/util/types");
exports.BasicTickFormatter = (function (superClass) {
    extend(BasicTickFormatter, superClass);
    function BasicTickFormatter() {
        return BasicTickFormatter.__super__.constructor.apply(this, arguments);
    }
    BasicTickFormatter.prototype.type = 'BasicTickFormatter';
    BasicTickFormatter.define({
        precision: [p.Any, 'auto'],
        use_scientific: [p.Bool, true],
        power_limit_high: [p.Number, 5],
        power_limit_low: [p.Number, -3]
    });
    BasicTickFormatter.getters({
        scientific_limit_low: function () {
            return Math.pow(10.0, this.power_limit_low);
        },
        scientific_limit_high: function () {
            return Math.pow(10.0, this.power_limit_high);
        }
    });
    BasicTickFormatter.prototype.initialize = function (attrs, options) {
        BasicTickFormatter.__super__.initialize.call(this, attrs, options);
        return this.last_precision = 3;
    };
    BasicTickFormatter.prototype.doFormat = function (ticks, loc) {
        var i, is_ok, j, k, l, labels, len, m, n, need_sci, o, precision, ref, ref1, ref2, ref3, ref4, tick, tick_abs, x, zero_eps;
        if (ticks.length === 0) {
            return [];
        }
        zero_eps = 0;
        if (ticks.length >= 2) {
            zero_eps = Math.abs(ticks[1] - ticks[0]) / 10000;
        }
        need_sci = false;
        if (this.use_scientific) {
            for (j = 0, len = ticks.length; j < len; j++) {
                tick = ticks[j];
                tick_abs = Math.abs(tick);
                if (tick_abs > zero_eps && (tick_abs >= this.scientific_limit_high || tick_abs <= this.scientific_limit_low)) {
                    need_sci = true;
                    break;
                }
            }
        }
        precision = this.precision;
        if ((precision == null) || types_1.isNumber(precision)) {
            labels = new Array(ticks.length);
            if (need_sci) {
                for (i = k = 0, ref = ticks.length; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
                    labels[i] = ticks[i].toExponential(precision || void 0);
                }
            }
            else {
                for (i = l = 0, ref1 = ticks.length; 0 <= ref1 ? l < ref1 : l > ref1; i = 0 <= ref1 ? ++l : --l) {
                    labels[i] = ticks[i].toFixed(precision || void 0).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
                }
            }
            return labels;
        }
        else if (precision === 'auto') {
            labels = new Array(ticks.length);
            for (x = m = ref2 = this.last_precision; ref2 <= 15 ? m <= 15 : m >= 15; x = ref2 <= 15 ? ++m : --m) {
                is_ok = true;
                if (need_sci) {
                    for (i = n = 0, ref3 = ticks.length; 0 <= ref3 ? n < ref3 : n > ref3; i = 0 <= ref3 ? ++n : --n) {
                        labels[i] = ticks[i].toExponential(x);
                        if (i > 0) {
                            if (labels[i] === labels[i - 1]) {
                                is_ok = false;
                                break;
                            }
                        }
                    }
                    if (is_ok) {
                        break;
                    }
                }
                else {
                    for (i = o = 0, ref4 = ticks.length; 0 <= ref4 ? o < ref4 : o > ref4; i = 0 <= ref4 ? ++o : --o) {
                        labels[i] = ticks[i].toFixed(x).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
                        if (i > 0) {
                            if (labels[i] === labels[i - 1]) {
                                is_ok = false;
                                break;
                            }
                        }
                    }
                    if (is_ok) {
                        break;
                    }
                }
                if (is_ok) {
                    this.last_precision = x;
                    return labels;
                }
            }
        }
        return labels;
    };
    return BasicTickFormatter;
})(tick_formatter_1.TickFormatter);

},{"./tick_formatter":"models/formatters/tick_formatter","core/properties":"core/properties","core/util/types":"core/util/types"}],"models/formatters/categorical_tick_formatter":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var tick_formatter_1 = require("./tick_formatter");
exports.CategoricalTickFormatter = (function (superClass) {
    extend(CategoricalTickFormatter, superClass);
    function CategoricalTickFormatter() {
        return CategoricalTickFormatter.__super__.constructor.apply(this, arguments);
    }
    CategoricalTickFormatter.prototype.type = 'CategoricalTickFormatter';
    CategoricalTickFormatter.prototype.doFormat = function (ticks, loc) {
        return ticks;
    };
    return CategoricalTickFormatter;
})(tick_formatter_1.TickFormatter);

},{"./tick_formatter":"models/formatters/tick_formatter"}],"models/formatters/datetime_tick_formatter":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var _array, _strftime, _us, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var SPrintf = require("sprintf");
var tz = require("timezone");
var tick_formatter_1 = require("./tick_formatter");
var logging_1 = require("core/logging");
var p = require("core/properties");
var array_1 = require("core/util/array");
var types_1 = require("core/util/types");
_us = function (t) {
    return Math.round(((t / 1000) % 1) * 1000000);
};
_array = function (t) {
    return tz(t, "%Y %m %d %H %M %S").split(/\s+/).map(function (e) {
        return parseInt(e, 10);
    });
};
_strftime = function (t, format) {
    var microsecond_replacement_string;
    if (types_1.isFunction(format)) {
        return format(t);
    }
    else {
        microsecond_replacement_string = SPrintf.sprintf("$1%06d", _us(t));
        format = format.replace(/((^|[^%])(%%)*)%f/, microsecond_replacement_string);
        if (format.indexOf("%") === -1) {
            return format;
        }
        return tz(t, format);
    }
};
exports.DatetimeTickFormatter = (function (superClass) {
    extend(DatetimeTickFormatter, superClass);
    function DatetimeTickFormatter() {
        return DatetimeTickFormatter.__super__.constructor.apply(this, arguments);
    }
    DatetimeTickFormatter.prototype.type = 'DatetimeTickFormatter';
    DatetimeTickFormatter.define({
        microseconds: [p.Array, ['%fus']],
        milliseconds: [p.Array, ['%3Nms', '%S.%3Ns']],
        seconds: [p.Array, ['%Ss']],
        minsec: [p.Array, [':%M:%S']],
        minutes: [p.Array, [':%M', '%Mm']],
        hourmin: [p.Array, ['%H:%M']],
        hours: [p.Array, ['%Hh', '%H:%M']],
        days: [p.Array, ['%m/%d', '%a%d']],
        months: [p.Array, ['%m/%Y', '%b%y']],
        years: [p.Array, ['%Y']]
    });
    DatetimeTickFormatter.prototype.format_order = ['microseconds', 'milliseconds', 'seconds', 'minsec', 'minutes', 'hourmin', 'hours', 'days', 'months', 'years'];
    DatetimeTickFormatter.prototype.strip_leading_zeros = true;
    DatetimeTickFormatter.prototype.initialize = function (attrs, options) {
        DatetimeTickFormatter.__super__.initialize.call(this, attrs, options);
        return this._update_width_formats();
    };
    DatetimeTickFormatter.prototype._update_width_formats = function () {
        var _widths, now;
        now = tz(new Date());
        _widths = function (fmt_strings) {
            var fmt_string, sizes, sorted;
            sizes = (function () {
                var j, len, results;
                results = [];
                for (j = 0, len = fmt_strings.length; j < len; j++) {
                    fmt_string = fmt_strings[j];
                    results.push(_strftime(now, fmt_string).length);
                }
                return results;
            })();
            sorted = array_1.sortBy(array_1.zip(sizes, fmt_strings), function (arg) {
                var fmt, size;
                size = arg[0], fmt = arg[1];
                return size;
            });
            return array_1.unzip(sorted);
        };
        return this._width_formats = {
            microseconds: _widths(this.microseconds),
            milliseconds: _widths(this.milliseconds),
            seconds: _widths(this.seconds),
            minsec: _widths(this.minsec),
            minutes: _widths(this.minutes),
            hourmin: _widths(this.hourmin),
            hours: _widths(this.hours),
            days: _widths(this.days),
            months: _widths(this.months),
            years: _widths(this.years)
        };
    };
    DatetimeTickFormatter.prototype._get_resolution_str = function (resolution_secs, span_secs) {
        var adjusted_secs;
        adjusted_secs = resolution_secs * 1.1;
        switch (false) {
            case !(adjusted_secs < 1e-3):
                return "microseconds";
            case !(adjusted_secs < 1.0):
                return "milliseconds";
            case !(adjusted_secs < 60):
                if (span_secs >= 60) {
                    return "minsec";
                }
                else {
                    return "seconds";
                }
            case !(adjusted_secs < 3600):
                if (span_secs >= 3600) {
                    return "hourmin";
                }
                else {
                    return "minutes";
                }
            case !(adjusted_secs < 24 * 3600):
                return "hours";
            case !(adjusted_secs < 31 * 24 * 3600):
                return "days";
            case !(adjusted_secs < 365 * 24 * 3600):
                return "months";
            default:
                return "years";
        }
    };
    DatetimeTickFormatter.prototype.doFormat = function (ticks, loc, num_labels, char_width, fill_ratio, ticker) {
        var error, fmt, format, formats, good_formats, hybrid_handled, i, j, k, l, labels, len, len1, next_format, next_ndx, r, ref, ref1, ref2, resol, resol_ndx, s, span, ss, t, time_tuple_ndx_for_resol, tm, widths;
        if (num_labels == null) {
            num_labels = null;
        }
        if (char_width == null) {
            char_width = null;
        }
        if (fill_ratio == null) {
            fill_ratio = 0.3;
        }
        if (ticker == null) {
            ticker = null;
        }
        if (ticks.length === 0) {
            return [];
        }
        span = Math.abs(ticks[ticks.length - 1] - ticks[0]) / 1000.0;
        if (ticker) {
            r = ticker.resolution;
        }
        else {
            r = span / (ticks.length - 1);
        }
        resol = this._get_resolution_str(r, span);
        ref = this._width_formats[resol], widths = ref[0], formats = ref[1];
        format = formats[0];
        if (char_width) {
            good_formats = [];
            for (i = j = 0, ref1 = widths.length; 0 <= ref1 ? j < ref1 : j > ref1; i = 0 <= ref1 ? ++j : --j) {
                if (widths[i] * ticks.length < fill_ratio * char_width) {
                    good_formats.push(this._width_formats[i]);
                }
            }
            if (good_formats.length > 0) {
                format = good_formats[good_formats.length - 1];
            }
        }
        labels = [];
        resol_ndx = this.format_order.indexOf(resol);
        time_tuple_ndx_for_resol = {};
        ref2 = this.format_order;
        for (k = 0, len = ref2.length; k < len; k++) {
            fmt = ref2[k];
            time_tuple_ndx_for_resol[fmt] = 0;
        }
        time_tuple_ndx_for_resol["seconds"] = 5;
        time_tuple_ndx_for_resol["minsec"] = 4;
        time_tuple_ndx_for_resol["minutes"] = 4;
        time_tuple_ndx_for_resol["hourmin"] = 3;
        time_tuple_ndx_for_resol["hours"] = 3;
        for (l = 0, len1 = ticks.length; l < len1; l++) {
            t = ticks[l];
            try {
                tm = _array(t);
                s = _strftime(t, format);
            }
            catch (error1) {
                error = error1;
                logging_1.logger.warn("unable to format tick for timestamp value " + t);
                logging_1.logger.warn(" - " + error);
                labels.push("ERR");
                continue;
            }
            hybrid_handled = false;
            next_ndx = resol_ndx;
            while (tm[time_tuple_ndx_for_resol[this.format_order[next_ndx]]] === 0) {
                next_ndx += 1;
                if (next_ndx === this.format_order.length) {
                    break;
                }
                if ((resol === "minsec" || resol === "hourmin") && !hybrid_handled) {
                    if ((resol === "minsec" && tm[4] === 0 && tm[5] !== 0) || (resol === "hourmin" && tm[3] === 0 && tm[4] !== 0)) {
                        next_format = this._width_formats[this.format_order[resol_ndx - 1]][1][0];
                        s = _strftime(t, next_format);
                        break;
                    }
                    else {
                        hybrid_handled = true;
                    }
                }
                next_format = this._width_formats[this.format_order[next_ndx]][1][0];
                s = _strftime(t, next_format);
            }
            if (this.strip_leading_zeros) {
                ss = s.replace(/^0+/g, "");
                if (ss !== s && isNaN(parseInt(ss))) {
                    ss = '0' + ss;
                }
                labels.push(ss);
            }
            else {
                labels.push(s);
            }
        }
        return labels;
    };
    return DatetimeTickFormatter;
})(tick_formatter_1.TickFormatter);

},{"./tick_formatter":"models/formatters/tick_formatter","core/logging":"core/logging","core/properties":"core/properties","core/util/array":"core/util/array","core/util/types":"core/util/types","sprintf":"sprintf","timezone":"timezone/index"}],"models/formatters/func_tick_formatter":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, slice = [].slice;
var tick_formatter_1 = require("./tick_formatter");
var p = require("core/properties");
var object_1 = require("core/util/object");
exports.FuncTickFormatter = (function (superClass) {
    extend(FuncTickFormatter, superClass);
    function FuncTickFormatter() {
        return FuncTickFormatter.__super__.constructor.apply(this, arguments);
    }
    FuncTickFormatter.prototype.type = 'FuncTickFormatter';
    FuncTickFormatter.define({
        args: [p.Any, {}],
        code: [p.String, '']
    });
    FuncTickFormatter.prototype.initialize = function (attrs, options) {
        return FuncTickFormatter.__super__.initialize.call(this, attrs, options);
    };
    FuncTickFormatter.prototype._make_func = function () {
        return (function (func, args, ctor) {
            ctor.prototype = func.prototype;
            var child = new ctor, result = func.apply(child, args);
            return Object(result) === result ? result : child;
        })(Function, ["tick"].concat(slice.call(Object.keys(this.args)), ["require"], [this.code]), function () { });
    };
    FuncTickFormatter.prototype.doFormat = function (ticks, loc) {
        var func, tick;
        func = this._make_func();
        return (function () {
            var i, len, results;
            results = [];
            for (i = 0, len = ticks.length; i < len; i++) {
                tick = ticks[i];
                results.push(func.apply(null, [tick].concat(slice.call(object_1.values(this.args)), [require])));
            }
            return results;
        }).call(this);
    };
    return FuncTickFormatter;
})(tick_formatter_1.TickFormatter);

},{"./tick_formatter":"models/formatters/tick_formatter","core/properties":"core/properties","core/util/object":"core/util/object"}],"models/formatters/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var basic_tick_formatter_1 = require("./basic_tick_formatter");
exports.BasicTickFormatter = basic_tick_formatter_1.BasicTickFormatter;
var categorical_tick_formatter_1 = require("./categorical_tick_formatter");
exports.CategoricalTickFormatter = categorical_tick_formatter_1.CategoricalTickFormatter;
var datetime_tick_formatter_1 = require("./datetime_tick_formatter");
exports.DatetimeTickFormatter = datetime_tick_formatter_1.DatetimeTickFormatter;
var func_tick_formatter_1 = require("./func_tick_formatter");
exports.FuncTickFormatter = func_tick_formatter_1.FuncTickFormatter;
var log_tick_formatter_1 = require("./log_tick_formatter");
exports.LogTickFormatter = log_tick_formatter_1.LogTickFormatter;
var mercator_tick_formatter_1 = require("./mercator_tick_formatter");
exports.MercatorTickFormatter = mercator_tick_formatter_1.MercatorTickFormatter;
var numeral_tick_formatter_1 = require("./numeral_tick_formatter");
exports.NumeralTickFormatter = numeral_tick_formatter_1.NumeralTickFormatter;
var printf_tick_formatter_1 = require("./printf_tick_formatter");
exports.PrintfTickFormatter = printf_tick_formatter_1.PrintfTickFormatter;
var tick_formatter_1 = require("./tick_formatter");
exports.TickFormatter = tick_formatter_1.TickFormatter;

},{"./basic_tick_formatter":"models/formatters/basic_tick_formatter","./categorical_tick_formatter":"models/formatters/categorical_tick_formatter","./datetime_tick_formatter":"models/formatters/datetime_tick_formatter","./func_tick_formatter":"models/formatters/func_tick_formatter","./log_tick_formatter":"models/formatters/log_tick_formatter","./mercator_tick_formatter":"models/formatters/mercator_tick_formatter","./numeral_tick_formatter":"models/formatters/numeral_tick_formatter","./printf_tick_formatter":"models/formatters/printf_tick_formatter","./tick_formatter":"models/formatters/tick_formatter"}],"models/formatters/log_tick_formatter":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var basic_tick_formatter_1 = require("./basic_tick_formatter");
var tick_formatter_1 = require("./tick_formatter");
var logging_1 = require("core/logging");
var p = require("core/properties");
exports.LogTickFormatter = (function (superClass) {
    extend(LogTickFormatter, superClass);
    function LogTickFormatter() {
        return LogTickFormatter.__super__.constructor.apply(this, arguments);
    }
    LogTickFormatter.prototype.type = 'LogTickFormatter';
    LogTickFormatter.define({
        ticker: [p.Instance, null]
    });
    LogTickFormatter.prototype.initialize = function (attrs, options) {
        LogTickFormatter.__super__.initialize.call(this, attrs, options);
        this.basic_formatter = new basic_tick_formatter_1.BasicTickFormatter();
        if (this.ticker == null) {
            return logging_1.logger.warn("LogTickFormatter not configured with a ticker, using default base of 10 (labels will be incorrect if ticker base is not 10)");
        }
    };
    LogTickFormatter.prototype.doFormat = function (ticks, loc) {
        var base, i, j, labels, ref, small_interval;
        if (ticks.length === 0) {
            return [];
        }
        if (this.ticker != null) {
            base = this.ticker.base;
        }
        else {
            base = 10;
        }
        small_interval = false;
        labels = new Array(ticks.length);
        for (i = j = 0, ref = ticks.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            labels[i] = base + "^" + (Math.round(Math.log(ticks[i]) / Math.log(base)));
            if ((i > 0) && (labels[i] === labels[i - 1])) {
                small_interval = true;
                break;
            }
        }
        if (small_interval) {
            labels = this.basic_formatter.doFormat(ticks);
        }
        return labels;
    };
    return LogTickFormatter;
})(tick_formatter_1.TickFormatter);

},{"./basic_tick_formatter":"models/formatters/basic_tick_formatter","./tick_formatter":"models/formatters/tick_formatter","core/logging":"core/logging","core/properties":"core/properties"}],"models/formatters/mercator_tick_formatter":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var basic_tick_formatter_1 = require("./basic_tick_formatter");
var p = require("core/properties");
var proj4_1 = require("core/util/proj4");
exports.MercatorTickFormatter = (function (superClass) {
    extend(MercatorTickFormatter, superClass);
    function MercatorTickFormatter() {
        return MercatorTickFormatter.__super__.constructor.apply(this, arguments);
    }
    MercatorTickFormatter.prototype.type = 'MercatorTickFormatter';
    MercatorTickFormatter.define({
        dimension: [p.LatLon]
    });
    MercatorTickFormatter.prototype.doFormat = function (ticks, loc) {
        var i, j, k, lat, lon, proj_ticks, ref, ref1, ref2, ref3;
        if (this.dimension == null) {
            throw new Error("MercatorTickFormatter.dimension not configured");
        }
        if (ticks.length === 0) {
            return [];
        }
        proj_ticks = new Array(ticks.length);
        if (this.dimension === "lon") {
            for (i = j = 0, ref = ticks.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                ref1 = proj4_1.proj4(proj4_1.mercator).inverse([ticks[i], loc]), lon = ref1[0], lat = ref1[1];
                proj_ticks[i] = lon;
            }
        }
        else {
            for (i = k = 0, ref2 = ticks.length; 0 <= ref2 ? k < ref2 : k > ref2; i = 0 <= ref2 ? ++k : --k) {
                ref3 = proj4_1.proj4(proj4_1.mercator).inverse([loc, ticks[i]]), lon = ref3[0], lat = ref3[1];
                proj_ticks[i] = lat;
            }
        }
        return MercatorTickFormatter.__super__.doFormat.call(this, proj_ticks, loc);
    };
    return MercatorTickFormatter;
})(basic_tick_formatter_1.BasicTickFormatter);

},{"./basic_tick_formatter":"models/formatters/basic_tick_formatter","core/properties":"core/properties","core/util/proj4":"core/util/proj4"}],"models/formatters/numeral_tick_formatter":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var Numbro = require("numbro");
var tick_formatter_1 = require("./tick_formatter");
var p = require("core/properties");
exports.NumeralTickFormatter = (function (superClass) {
    extend(NumeralTickFormatter, superClass);
    function NumeralTickFormatter() {
        return NumeralTickFormatter.__super__.constructor.apply(this, arguments);
    }
    NumeralTickFormatter.prototype.type = 'NumeralTickFormatter';
    NumeralTickFormatter.define({
        format: [p.String, '0,0'],
        language: [p.String, 'en'],
        rounding: [p.String, 'round']
    });
    NumeralTickFormatter.prototype.doFormat = function (ticks, loc) {
        var format, labels, language, rounding, tick;
        format = this.format;
        language = this.language;
        rounding = (function () {
            switch (this.rounding) {
                case "round":
                case "nearest":
                    return Math.round;
                case "floor":
                case "rounddown":
                    return Math.floor;
                case "ceil":
                case "roundup":
                    return Math.ceil;
            }
        }).call(this);
        labels = (function () {
            var i, len, results;
            results = [];
            for (i = 0, len = ticks.length; i < len; i++) {
                tick = ticks[i];
                results.push(Numbro.format(tick, format, language, rounding));
            }
            return results;
        })();
        return labels;
    };
    return NumeralTickFormatter;
})(tick_formatter_1.TickFormatter);

},{"./tick_formatter":"models/formatters/tick_formatter","core/properties":"core/properties","numbro":"numbro"}],"models/formatters/printf_tick_formatter":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var SPrintf = require("sprintf");
var tick_formatter_1 = require("./tick_formatter");
var p = require("core/properties");
exports.PrintfTickFormatter = (function (superClass) {
    extend(PrintfTickFormatter, superClass);
    function PrintfTickFormatter() {
        return PrintfTickFormatter.__super__.constructor.apply(this, arguments);
    }
    PrintfTickFormatter.prototype.type = 'PrintfTickFormatter';
    PrintfTickFormatter.define({
        format: [p.String, '%s']
    });
    PrintfTickFormatter.prototype.doFormat = function (ticks, loc) {
        var format, labels, tick;
        format = this.format;
        labels = (function () {
            var i, len, results;
            results = [];
            for (i = 0, len = ticks.length; i < len; i++) {
                tick = ticks[i];
                results.push(SPrintf.sprintf(format, tick));
            }
            return results;
        })();
        return labels;
    };
    return PrintfTickFormatter;
})(tick_formatter_1.TickFormatter);

},{"./tick_formatter":"models/formatters/tick_formatter","core/properties":"core/properties","sprintf":"sprintf"}],"models/formatters/tick_formatter":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var model_1 = require("../../model");
exports.TickFormatter = (function (superClass) {
    extend(TickFormatter, superClass);
    function TickFormatter() {
        return TickFormatter.__super__.constructor.apply(this, arguments);
    }
    TickFormatter.prototype.type = 'TickFormatter';
    TickFormatter.prototype.doFormat = function (ticks, loc) { };
    return TickFormatter;
})(model_1.Model);

},{"../../model":"model"}],"models/glyphs/annular_wedge":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
var hittest = require("core/hittest");
var p = require("core/properties");
var math_1 = require("core/util/math");
exports.AnnularWedgeView = (function (superClass) {
    extend(AnnularWedgeView, superClass);
    function AnnularWedgeView() {
        return AnnularWedgeView.__super__.constructor.apply(this, arguments);
    }
    AnnularWedgeView.prototype._map_data = function () {
        var i, j, ref, results;
        if (this.model.properties.inner_radius.units === "data") {
            this.sinner_radius = this.sdist(this.renderer.xmapper, this._x, this._inner_radius);
        }
        else {
            this.sinner_radius = this._inner_radius;
        }
        if (this.model.properties.outer_radius.units === "data") {
            this.souter_radius = this.sdist(this.renderer.xmapper, this._x, this._outer_radius);
        }
        else {
            this.souter_radius = this._outer_radius;
        }
        this._angle = new Float32Array(this._start_angle.length);
        results = [];
        for (i = j = 0, ref = this._start_angle.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            results.push(this._angle[i] = this._end_angle[i] - this._start_angle[i]);
        }
        return results;
    };
    AnnularWedgeView.prototype._render = function (ctx, indices, arg) {
        var _angle, _start_angle, direction, i, j, len, results, sinner_radius, souter_radius, sx, sy;
        sx = arg.sx, sy = arg.sy, _start_angle = arg._start_angle, _angle = arg._angle, sinner_radius = arg.sinner_radius, souter_radius = arg.souter_radius;
        direction = this.model.properties.direction.value();
        results = [];
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (isNaN(sx[i] + sy[i] + sinner_radius[i] + souter_radius[i] + _start_angle[i] + _angle[i])) {
                continue;
            }
            ctx.translate(sx[i], sy[i]);
            ctx.rotate(_start_angle[i]);
            ctx.moveTo(souter_radius[i], 0);
            ctx.beginPath();
            ctx.arc(0, 0, souter_radius[i], 0, _angle[i], direction);
            ctx.rotate(_angle[i]);
            ctx.lineTo(sinner_radius[i], 0);
            ctx.arc(0, 0, sinner_radius[i], 0, -_angle[i], !direction);
            ctx.closePath();
            ctx.rotate(-_angle[i] - _start_angle[i]);
            ctx.translate(-sx[i], -sy[i]);
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                results.push(ctx.stroke());
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    AnnularWedgeView.prototype._hit_point = function (geometry) {
        var angle, bbox, candidates, direction, dist, hits, i, ir2, j, k, len, len1, or2, ref, ref1, ref2, ref3, ref4, sx, sx0, sx1, sy, sy0, sy1, vx, vx0, vx1, vy, vy0, vy1, x, x0, x1, y, y0, y1;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        x = this.renderer.xmapper.map_from_target(vx, true);
        y = this.renderer.ymapper.map_from_target(vy, true);
        if (this.model.properties.outer_radius.units === "data") {
            x0 = x - this.max_outer_radius;
            x1 = x + this.max_outer_radius;
            y0 = y - this.max_outer_radius;
            y1 = y + this.max_outer_radius;
        }
        else {
            vx0 = vx - this.max_outer_radius;
            vx1 = vx + this.max_outer_radius;
            ref1 = this.renderer.xmapper.v_map_from_target([vx0, vx1], true), x0 = ref1[0], x1 = ref1[1];
            vy0 = vy - this.max_outer_radius;
            vy1 = vy + this.max_outer_radius;
            ref2 = this.renderer.ymapper.v_map_from_target([vy0, vy1], true), y0 = ref2[0], y1 = ref2[1];
        }
        candidates = [];
        bbox = hittest.validate_bbox_coords([x0, x1], [y0, y1]);
        ref3 = this.index.indices(bbox);
        for (j = 0, len = ref3.length; j < len; j++) {
            i = ref3[j];
            or2 = Math.pow(this.souter_radius[i], 2);
            ir2 = Math.pow(this.sinner_radius[i], 2);
            sx0 = this.renderer.xmapper.map_to_target(x, true);
            sx1 = this.renderer.xmapper.map_to_target(this._x[i], true);
            sy0 = this.renderer.ymapper.map_to_target(y, true);
            sy1 = this.renderer.ymapper.map_to_target(this._y[i], true);
            dist = Math.pow(sx0 - sx1, 2) + Math.pow(sy0 - sy1, 2);
            if (dist <= or2 && dist >= ir2) {
                candidates.push([i, dist]);
            }
        }
        direction = this.model.properties.direction.value();
        hits = [];
        for (k = 0, len1 = candidates.length; k < len1; k++) {
            ref4 = candidates[k], i = ref4[0], dist = ref4[1];
            sx = this.renderer.plot_view.canvas.vx_to_sx(vx);
            sy = this.renderer.plot_view.canvas.vy_to_sy(vy);
            angle = Math.atan2(sy - this.sy[i], sx - this.sx[i]);
            if (math_1.angle_between(-angle, -this._start_angle[i], -this._end_angle[i], direction)) {
                hits.push([i, dist]);
            }
        }
        return hittest.create_1d_hit_test_result(hits);
    };
    AnnularWedgeView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
    };
    AnnularWedgeView.prototype._scxy = function (i) {
        var a, r;
        r = (this.sinner_radius[i] + this.souter_radius[i]) / 2;
        a = (this._start_angle[i] + this._end_angle[i]) / 2;
        return {
            x: this.sx[i] + r * Math.cos(a),
            y: this.sy[i] + r * Math.sin(a)
        };
    };
    AnnularWedgeView.prototype.scx = function (i) {
        return this._scxy(i).x;
    };
    AnnularWedgeView.prototype.scy = function (i) {
        return this._scxy(i).y;
    };
    return AnnularWedgeView;
})(xy_glyph_1.XYGlyphView);
exports.AnnularWedge = (function (superClass) {
    extend(AnnularWedge, superClass);
    function AnnularWedge() {
        return AnnularWedge.__super__.constructor.apply(this, arguments);
    }
    AnnularWedge.prototype.default_view = exports.AnnularWedgeView;
    AnnularWedge.prototype.type = 'AnnularWedge';
    AnnularWedge.mixins(['line', 'fill']);
    AnnularWedge.define({
        direction: [p.Direction, 'anticlock'],
        inner_radius: [p.DistanceSpec],
        outer_radius: [p.DistanceSpec],
        start_angle: [p.AngleSpec],
        end_angle: [p.AngleSpec]
    });
    return AnnularWedge;
})(xy_glyph_1.XYGlyph);

},{"./xy_glyph":"models/glyphs/xy_glyph","core/hittest":"core/hittest","core/properties":"core/properties","core/util/math":"core/util/math"}],"models/glyphs/annulus":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
var hittest = require("core/hittest");
var p = require("core/properties");
exports.AnnulusView = (function (superClass) {
    extend(AnnulusView, superClass);
    function AnnulusView() {
        return AnnulusView.__super__.constructor.apply(this, arguments);
    }
    AnnulusView.prototype._map_data = function () {
        if (this.model.properties.inner_radius.units === "data") {
            this.sinner_radius = this.sdist(this.renderer.xmapper, this._x, this._inner_radius);
        }
        else {
            this.sinner_radius = this._inner_radius;
        }
        if (this.model.properties.outer_radius.units === "data") {
            return this.souter_radius = this.sdist(this.renderer.xmapper, this._x, this._outer_radius);
        }
        else {
            return this.souter_radius = this._outer_radius;
        }
    };
    AnnulusView.prototype._render = function (ctx, indices, arg) {
        var clockwise, i, isie, j, k, len, len1, ref, results, sinner_radius, souter_radius, sx, sy;
        sx = arg.sx, sy = arg.sy, sinner_radius = arg.sinner_radius, souter_radius = arg.souter_radius;
        results = [];
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (isNaN(sx[i] + sy[i] + sinner_radius[i] + souter_radius[i])) {
                continue;
            }
            isie = navigator.userAgent.indexOf('MSIE') >= 0 || navigator.userAgent.indexOf('Trident') > 0 || navigator.userAgent.indexOf('Edge') > 0;
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                ctx.beginPath();
                if (isie) {
                    ref = [false, true];
                    for (k = 0, len1 = ref.length; k < len1; k++) {
                        clockwise = ref[k];
                        ctx.arc(sx[i], sy[i], sinner_radius[i], 0, Math.PI, clockwise);
                        ctx.arc(sx[i], sy[i], souter_radius[i], Math.PI, 0, !clockwise);
                    }
                }
                else {
                    ctx.arc(sx[i], sy[i], sinner_radius[i], 0, 2 * Math.PI, true);
                    ctx.arc(sx[i], sy[i], souter_radius[i], 2 * Math.PI, 0, false);
                }
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                ctx.beginPath();
                ctx.arc(sx[i], sy[i], sinner_radius[i], 0, 2 * Math.PI);
                ctx.moveTo(sx[i] + souter_radius[i], sy[i]);
                ctx.arc(sx[i], sy[i], souter_radius[i], 0, 2 * Math.PI);
                results.push(ctx.stroke());
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    AnnulusView.prototype._hit_point = function (geometry) {
        var bbox, dist, hits, i, ir2, j, len, or2, ref, ref1, sx0, sx1, sy0, sy1, vx, vy, x, x0, x1, y, y0, y1;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        x = this.renderer.xmapper.map_from_target(vx, true);
        x0 = x - this.max_radius;
        x1 = x + this.max_radius;
        y = this.renderer.ymapper.map_from_target(vy, true);
        y0 = y - this.max_radius;
        y1 = y + this.max_radius;
        hits = [];
        bbox = hittest.validate_bbox_coords([x0, x1], [y0, y1]);
        ref1 = this.index.indices(bbox);
        for (j = 0, len = ref1.length; j < len; j++) {
            i = ref1[j];
            or2 = Math.pow(this.souter_radius[i], 2);
            ir2 = Math.pow(this.sinner_radius[i], 2);
            sx0 = this.renderer.xmapper.map_to_target(x);
            sx1 = this.renderer.xmapper.map_to_target(this._x[i]);
            sy0 = this.renderer.ymapper.map_to_target(y);
            sy1 = this.renderer.ymapper.map_to_target(this._y[i]);
            dist = Math.pow(sx0 - sx1, 2) + Math.pow(sy0 - sy1, 2);
            if (dist <= or2 && dist >= ir2) {
                hits.push([i, dist]);
            }
        }
        return hittest.create_1d_hit_test_result(hits);
    };
    AnnulusView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        var data, indices, r, sinner_radius, souter_radius, sx, sy;
        indices = [index];
        sx = {};
        sx[index] = (x0 + x1) / 2;
        sy = {};
        sy[index] = (y0 + y1) / 2;
        r = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.5;
        sinner_radius = {};
        sinner_radius[index] = r * 0.4;
        souter_radius = {};
        souter_radius[index] = r * 0.8;
        data = {
            sx: sx,
            sy: sy,
            sinner_radius: sinner_radius,
            souter_radius: souter_radius
        };
        return this._render(ctx, indices, data);
    };
    return AnnulusView;
})(xy_glyph_1.XYGlyphView);
exports.Annulus = (function (superClass) {
    extend(Annulus, superClass);
    function Annulus() {
        return Annulus.__super__.constructor.apply(this, arguments);
    }
    Annulus.prototype.default_view = exports.AnnulusView;
    Annulus.prototype.type = 'Annulus';
    Annulus.mixins(['line', 'fill']);
    Annulus.define({
        inner_radius: [p.DistanceSpec],
        outer_radius: [p.DistanceSpec]
    });
    return Annulus;
})(xy_glyph_1.XYGlyph);

},{"./xy_glyph":"models/glyphs/xy_glyph","core/hittest":"core/hittest","core/properties":"core/properties"}],"models/glyphs/arc":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
var p = require("core/properties");
exports.ArcView = (function (superClass) {
    extend(ArcView, superClass);
    function ArcView() {
        return ArcView.__super__.constructor.apply(this, arguments);
    }
    ArcView.prototype._map_data = function () {
        if (this.model.properties.radius.units === "data") {
            return this.sradius = this.sdist(this.renderer.xmapper, this._x, this._radius);
        }
        else {
            return this.sradius = this._radius;
        }
    };
    ArcView.prototype._render = function (ctx, indices, arg) {
        var _end_angle, _start_angle, direction, i, j, len, results, sradius, sx, sy;
        sx = arg.sx, sy = arg.sy, sradius = arg.sradius, _start_angle = arg._start_angle, _end_angle = arg._end_angle;
        if (this.visuals.line.doit) {
            direction = this.model.properties.direction.value();
            results = [];
            for (j = 0, len = indices.length; j < len; j++) {
                i = indices[j];
                if (isNaN(sx[i] + sy[i] + sradius[i] + _start_angle[i] + _end_angle[i])) {
                    continue;
                }
                ctx.beginPath();
                ctx.arc(sx[i], sy[i], sradius[i], _start_angle[i], _end_angle[i], direction);
                this.visuals.line.set_vectorize(ctx, i);
                results.push(ctx.stroke());
            }
            return results;
        }
    };
    ArcView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
    };
    return ArcView;
})(xy_glyph_1.XYGlyphView);
exports.Arc = (function (superClass) {
    extend(Arc, superClass);
    function Arc() {
        return Arc.__super__.constructor.apply(this, arguments);
    }
    Arc.prototype.default_view = exports.ArcView;
    Arc.prototype.type = 'Arc';
    Arc.mixins(['line']);
    Arc.define({
        direction: [p.Direction, 'anticlock'],
        radius: [p.DistanceSpec],
        start_angle: [p.AngleSpec],
        end_angle: [p.AngleSpec]
    });
    return Arc;
})(xy_glyph_1.XYGlyph);

},{"./xy_glyph":"models/glyphs/xy_glyph","core/properties":"core/properties"}],"models/glyphs/bezier":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var _cbb, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var spatial_1 = require("core/util/spatial");
var glyph_1 = require("./glyph");
_cbb = function (x0, y0, x1, y1, x2, y2, x3, y3) {
    var a, b, b2ac, bounds, c, i, j, jlen, k, mt, sqrtb2ac, t, t1, t2, tvalues, x, y;
    tvalues = [];
    bounds = [[], []];
    for (i = k = 0; k <= 2; i = ++k) {
        if (i === 0) {
            b = 6 * x0 - 12 * x1 + 6 * x2;
            a = -3 * x0 + 9 * x1 - 9 * x2 + 3 * x3;
            c = 3 * x1 - 3 * x0;
        }
        else {
            b = 6 * y0 - 12 * y1 + 6 * y2;
            a = -3 * y0 + 9 * y1 - 9 * y2 + 3 * y3;
            c = 3 * y1 - 3 * y0;
        }
        if (Math.abs(a) < 1e-12) {
            if (Math.abs(b) < 1e-12) {
                continue;
            }
            t = -c / b;
            if (0 < t && t < 1) {
                tvalues.push(t);
            }
            continue;
        }
        b2ac = b * b - 4 * c * a;
        sqrtb2ac = Math.sqrt(b2ac);
        if (b2ac < 0) {
            continue;
        }
        t1 = (-b + sqrtb2ac) / (2 * a);
        if (0 < t1 && t1 < 1) {
            tvalues.push(t1);
        }
        t2 = (-b - sqrtb2ac) / (2 * a);
        if (0 < t2 && t2 < 1) {
            tvalues.push(t2);
        }
    }
    j = tvalues.length;
    jlen = j;
    while (j--) {
        t = tvalues[j];
        mt = 1 - t;
        x = (mt * mt * mt * x0) + (3 * mt * mt * t * x1) + (3 * mt * t * t * x2) + (t * t * t * x3);
        bounds[0][j] = x;
        y = (mt * mt * mt * y0) + (3 * mt * mt * t * y1) + (3 * mt * t * t * y2) + (t * t * t * y3);
        bounds[1][j] = y;
    }
    bounds[0][jlen] = x0;
    bounds[1][jlen] = y0;
    bounds[0][jlen + 1] = x3;
    bounds[1][jlen + 1] = y3;
    return [Math.min.apply(null, bounds[0]), Math.max.apply(null, bounds[1]), Math.max.apply(null, bounds[0]), Math.min.apply(null, bounds[1])];
};
exports.BezierView = (function (superClass) {
    extend(BezierView, superClass);
    function BezierView() {
        return BezierView.__super__.constructor.apply(this, arguments);
    }
    BezierView.prototype._index_data = function () {
        var i, k, points, ref, ref1, x0, x1, y0, y1;
        points = [];
        for (i = k = 0, ref = this._x0.length; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
            if (isNaN(this._x0[i] + this._x1[i] + this._y0[i] + this._y1[i] + this._cx0[i] + this._cy0[i] + this._cx1[i] + this._cy1[i])) {
                continue;
            }
            ref1 = _cbb(this._x0[i], this._y0[i], this._x1[i], this._y1[i], this._cx0[i], this._cy0[i], this._cx1[i], this._cy1[i]), x0 = ref1[0], y0 = ref1[1], x1 = ref1[2], y1 = ref1[3];
            points.push({
                minX: x0,
                minY: y0,
                maxX: x1,
                maxY: y1,
                i: i
            });
        }
        return new spatial_1.RBush(points);
    };
    BezierView.prototype._render = function (ctx, indices, arg) {
        var i, k, len, results, scx, scx0, scx1, scy0, scy1, sx0, sx1, sy0, sy1;
        sx0 = arg.sx0, sy0 = arg.sy0, sx1 = arg.sx1, sy1 = arg.sy1, scx = arg.scx, scx0 = arg.scx0, scy0 = arg.scy0, scx1 = arg.scx1, scy1 = arg.scy1;
        if (this.visuals.line.doit) {
            results = [];
            for (k = 0, len = indices.length; k < len; k++) {
                i = indices[k];
                if (isNaN(sx0[i] + sy0[i] + sx1[i] + sy1[i] + scx0[i] + scy0[i] + scx1[i] + scy1[i])) {
                    continue;
                }
                ctx.beginPath();
                ctx.moveTo(sx0[i], sy0[i]);
                ctx.bezierCurveTo(scx0[i], scy0[i], scx1[i], scy1[i], sx1[i], sy1[i]);
                this.visuals.line.set_vectorize(ctx, i);
                results.push(ctx.stroke());
            }
            return results;
        }
    };
    BezierView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
    };
    return BezierView;
})(glyph_1.GlyphView);
exports.Bezier = (function (superClass) {
    extend(Bezier, superClass);
    function Bezier() {
        return Bezier.__super__.constructor.apply(this, arguments);
    }
    Bezier.prototype.default_view = exports.BezierView;
    Bezier.prototype.type = 'Bezier';
    Bezier.coords([['x0', 'y0'], ['x1', 'y1'], ['cx0', 'cy0'], ['cx1', 'cy1']]);
    Bezier.mixins(['line']);
    return Bezier;
})(glyph_1.Glyph);

},{"./glyph":"models/glyphs/glyph","core/util/spatial":"core/util/spatial"}],"models/glyphs/circle":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
var hittest = require("core/hittest");
var p = require("core/properties");
exports.CircleView = (function (superClass) {
    extend(CircleView, superClass);
    function CircleView() {
        return CircleView.__super__.constructor.apply(this, arguments);
    }
    CircleView.prototype._map_data = function () {
        var rd, s;
        if (this._radius != null) {
            if (this.model.properties.radius.spec.units === "data") {
                rd = this.model.properties.radius_dimension.spec.value;
                return this.sradius = this.sdist(this.renderer[rd + "mapper"], this["_" + rd], this._radius);
            }
            else {
                this.sradius = this._radius;
                return this.max_size = 2 * this.max_radius;
            }
        }
        else {
            return this.sradius = (function () {
                var j, len, ref, results;
                ref = this._size;
                results = [];
                for (j = 0, len = ref.length; j < len; j++) {
                    s = ref[j];
                    results.push(s / 2);
                }
                return results;
            }).call(this);
        }
    };
    CircleView.prototype._mask_data = function (all_indices) {
        var bbox, hr, ref, ref1, ref2, ref3, sx0, sx1, sy0, sy1, vr, x0, x1, y0, y1;
        hr = this.renderer.plot_view.frame.h_range;
        vr = this.renderer.plot_view.frame.v_range;
        if ((this._radius != null) && this.model.properties.radius.units === "data") {
            sx0 = hr.start;
            sx1 = hr.end;
            ref = this.renderer.xmapper.v_map_from_target([sx0, sx1], true), x0 = ref[0], x1 = ref[1];
            x0 -= this.max_radius;
            x1 += this.max_radius;
            sy0 = vr.start;
            sy1 = vr.end;
            ref1 = this.renderer.ymapper.v_map_from_target([sy0, sy1], true), y0 = ref1[0], y1 = ref1[1];
            y0 -= this.max_radius;
            y1 += this.max_radius;
        }
        else {
            sx0 = hr.start - this.max_size;
            sx1 = hr.end + this.max_size;
            ref2 = this.renderer.xmapper.v_map_from_target([sx0, sx1], true), x0 = ref2[0], x1 = ref2[1];
            sy0 = vr.start - this.max_size;
            sy1 = vr.end + this.max_size;
            ref3 = this.renderer.ymapper.v_map_from_target([sy0, sy1], true), y0 = ref3[0], y1 = ref3[1];
        }
        bbox = hittest.validate_bbox_coords([x0, x1], [y0, y1]);
        return this.index.indices(bbox);
    };
    CircleView.prototype._render = function (ctx, indices, arg) {
        var i, j, len, results, sradius, sx, sy;
        sx = arg.sx, sy = arg.sy, sradius = arg.sradius;
        results = [];
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (isNaN(sx[i] + sy[i] + sradius[i])) {
                continue;
            }
            ctx.beginPath();
            ctx.arc(sx[i], sy[i], sradius[i], 0, 2 * Math.PI, false);
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                results.push(ctx.stroke());
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    CircleView.prototype._hit_point = function (geometry) {
        var bbox, candidates, dist, hits, i, j, k, len, len1, r2, ref, ref1, ref2, ref3, ref4, sx, sx0, sx1, sy, sy0, sy1, vx, vx0, vx1, vy, vy0, vy1, x, x0, x1, y, y0, y1;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        x = this.renderer.xmapper.map_from_target(vx, true);
        y = this.renderer.ymapper.map_from_target(vy, true);
        if ((this._radius != null) && this.model.properties.radius.units === "data") {
            x0 = x - this.max_radius;
            x1 = x + this.max_radius;
            y0 = y - this.max_radius;
            y1 = y + this.max_radius;
        }
        else {
            vx0 = vx - this.max_size;
            vx1 = vx + this.max_size;
            ref1 = this.renderer.xmapper.v_map_from_target([vx0, vx1], true), x0 = ref1[0], x1 = ref1[1];
            ref2 = [Math.min(x0, x1), Math.max(x0, x1)], x0 = ref2[0], x1 = ref2[1];
            vy0 = vy - this.max_size;
            vy1 = vy + this.max_size;
            ref3 = this.renderer.ymapper.v_map_from_target([vy0, vy1], true), y0 = ref3[0], y1 = ref3[1];
            ref4 = [Math.min(y0, y1), Math.max(y0, y1)], y0 = ref4[0], y1 = ref4[1];
        }
        bbox = hittest.validate_bbox_coords([x0, x1], [y0, y1]);
        candidates = this.index.indices(bbox);
        hits = [];
        if ((this._radius != null) && this.model.properties.radius.units === "data") {
            for (j = 0, len = candidates.length; j < len; j++) {
                i = candidates[j];
                r2 = Math.pow(this.sradius[i], 2);
                sx0 = this.renderer.xmapper.map_to_target(x, true);
                sx1 = this.renderer.xmapper.map_to_target(this._x[i], true);
                sy0 = this.renderer.ymapper.map_to_target(y, true);
                sy1 = this.renderer.ymapper.map_to_target(this._y[i], true);
                dist = Math.pow(sx0 - sx1, 2) + Math.pow(sy0 - sy1, 2);
                if (dist <= r2) {
                    hits.push([i, dist]);
                }
            }
        }
        else {
            sx = this.renderer.plot_view.canvas.vx_to_sx(vx);
            sy = this.renderer.plot_view.canvas.vy_to_sy(vy);
            for (k = 0, len1 = candidates.length; k < len1; k++) {
                i = candidates[k];
                r2 = Math.pow(this.sradius[i], 2);
                dist = Math.pow(this.sx[i] - sx, 2) + Math.pow(this.sy[i] - sy, 2);
                if (dist <= r2) {
                    hits.push([i, dist]);
                }
            }
        }
        return hittest.create_1d_hit_test_result(hits);
    };
    CircleView.prototype._hit_span = function (geometry) {
        var bbox, hits, maxX, maxY, minX, minY, ms, ref, ref1, ref2, ref3, ref4, ref5, result, vx, vx0, vx1, vy, vy0, vy1, x0, x1, y0, y1;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        ref1 = this.bounds(), minX = ref1.minX, minY = ref1.minY, maxX = ref1.maxX, maxY = ref1.maxY;
        result = hittest.create_hit_test_result();
        if (geometry.direction === 'h') {
            y0 = minY;
            y1 = maxY;
            if ((this._radius != null) && this.model.properties.radius.units === "data") {
                vx0 = vx - this.max_radius;
                vx1 = vx + this.max_radius;
                ref2 = this.renderer.xmapper.v_map_from_target([vx0, vx1]), x0 = ref2[0], x1 = ref2[1];
            }
            else {
                ms = this.max_size / 2;
                vx0 = vx - ms;
                vx1 = vx + ms;
                ref3 = this.renderer.xmapper.v_map_from_target([vx0, vx1], true), x0 = ref3[0], x1 = ref3[1];
            }
        }
        else {
            x0 = minX;
            x1 = maxX;
            if ((this._radius != null) && this.model.properties.radius.units === "data") {
                vy0 = vy - this.max_radius;
                vy1 = vy + this.max_radius;
                ref4 = this.renderer.ymapper.v_map_from_target([vy0, vy1]), y0 = ref4[0], y1 = ref4[1];
            }
            else {
                ms = this.max_size / 2;
                vy0 = vy - ms;
                vy1 = vy + ms;
                ref5 = this.renderer.ymapper.v_map_from_target([vy0, vy1], true), y0 = ref5[0], y1 = ref5[1];
            }
        }
        bbox = hittest.validate_bbox_coords([x0, x1], [y0, y1]);
        hits = this.index.indices(bbox);
        result['1d'].indices = hits;
        return result;
    };
    CircleView.prototype._hit_rect = function (geometry) {
        var bbox, ref, ref1, result, x0, x1, y0, y1;
        ref = this.renderer.xmapper.v_map_from_target([geometry.vx0, geometry.vx1], true), x0 = ref[0], x1 = ref[1];
        ref1 = this.renderer.ymapper.v_map_from_target([geometry.vy0, geometry.vy1], true), y0 = ref1[0], y1 = ref1[1];
        bbox = hittest.validate_bbox_coords([x0, x1], [y0, y1]);
        result = hittest.create_hit_test_result();
        result['1d'].indices = this.index.indices(bbox);
        return result;
    };
    CircleView.prototype._hit_poly = function (geometry) {
        var candidates, hits, i, idx, j, k, ref, ref1, ref2, result, results, sx, sy, vx, vy;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        sx = this.renderer.plot_view.canvas.v_vx_to_sx(vx);
        sy = this.renderer.plot_view.canvas.v_vy_to_sy(vy);
        candidates = (function () {
            results = [];
            for (var j = 0, ref1 = this.sx.length; 0 <= ref1 ? j < ref1 : j > ref1; 0 <= ref1 ? j++ : j--) {
                results.push(j);
            }
            return results;
        }).apply(this);
        hits = [];
        for (i = k = 0, ref2 = candidates.length; 0 <= ref2 ? k < ref2 : k > ref2; i = 0 <= ref2 ? ++k : --k) {
            idx = candidates[i];
            if (hittest.point_in_poly(this.sx[i], this.sy[i], sx, sy)) {
                hits.push(idx);
            }
        }
        result = hittest.create_hit_test_result();
        result['1d'].indices = hits;
        return result;
    };
    CircleView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        var data, indices, sradius, sx, sy;
        indices = [index];
        sx = {};
        sx[index] = (x0 + x1) / 2;
        sy = {};
        sy[index] = (y0 + y1) / 2;
        sradius = {};
        sradius[index] = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.2;
        data = {
            sx: sx,
            sy: sy,
            sradius: sradius
        };
        return this._render(ctx, indices, data);
    };
    return CircleView;
})(xy_glyph_1.XYGlyphView);
exports.Circle = (function (superClass) {
    extend(Circle, superClass);
    function Circle() {
        return Circle.__super__.constructor.apply(this, arguments);
    }
    Circle.prototype.default_view = exports.CircleView;
    Circle.prototype.type = 'Circle';
    Circle.mixins(['line', 'fill']);
    Circle.define({
        angle: [p.AngleSpec, 0],
        size: [
            p.DistanceSpec, {
                units: "screen",
                value: 4
            }
        ],
        radius: [p.DistanceSpec, null],
        radius_dimension: [p.String, 'x']
    });
    Circle.prototype.initialize = function (attrs, options) {
        Circle.__super__.initialize.call(this, attrs, options);
        return this.properties.radius.optional = true;
    };
    return Circle;
})(xy_glyph_1.XYGlyph);

},{"./xy_glyph":"models/glyphs/xy_glyph","core/hittest":"core/hittest","core/properties":"core/properties"}],"models/glyphs/ellipse":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
var p = require("core/properties");
exports.EllipseView = (function (superClass) {
    extend(EllipseView, superClass);
    function EllipseView() {
        return EllipseView.__super__.constructor.apply(this, arguments);
    }
    EllipseView.prototype._set_data = function () {
        this.max_w2 = 0;
        if (this.model.properties.width.units === "data") {
            this.max_w2 = this.max_width / 2;
        }
        this.max_h2 = 0;
        if (this.model.properties.height.units === "data") {
            return this.max_h2 = this.max_height / 2;
        }
    };
    EllipseView.prototype._map_data = function () {
        if (this.model.properties.width.units === "data") {
            this.sw = this.sdist(this.renderer.xmapper, this._x, this._width, 'center');
        }
        else {
            this.sw = this._width;
        }
        if (this.model.properties.height.units === "data") {
            return this.sh = this.sdist(this.renderer.ymapper, this._y, this._height, 'center');
        }
        else {
            return this.sh = this._height;
        }
    };
    EllipseView.prototype._render = function (ctx, indices, arg) {
        var i, j, len, results, sh, sw, sx, sy;
        sx = arg.sx, sy = arg.sy, sw = arg.sw, sh = arg.sh;
        results = [];
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (isNaN(sx[i] + sy[i] + sw[i] + sh[i] + this._angle[i])) {
                continue;
            }
            ctx.beginPath();
            ctx.ellipse(sx[i], sy[i], sw[i] / 2.0, sh[i] / 2.0, this._angle[i], 0, 2 * Math.PI);
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                results.push(ctx.stroke());
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    EllipseView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        var d, data, indices, scale, sh, sw, sx, sy;
        indices = [index];
        sx = {};
        sx[index] = (x0 + x1) / 2;
        sy = {};
        sy[index] = (y0 + y1) / 2;
        scale = this.sw[index] / this.sh[index];
        d = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.8;
        sw = {};
        sh = {};
        if (scale > 1) {
            sw[index] = d;
            sh[index] = d / scale;
        }
        else {
            sw[index] = d * scale;
            sh[index] = d;
        }
        data = {
            sx: sx,
            sy: sy,
            sw: sw,
            sh: sh
        };
        return this._render(ctx, indices, data);
    };
    EllipseView.prototype._bounds = function (bds) {
        return this.max_wh2_bounds(bds);
    };
    return EllipseView;
})(xy_glyph_1.XYGlyphView);
exports.Ellipse = (function (superClass) {
    extend(Ellipse, superClass);
    function Ellipse() {
        return Ellipse.__super__.constructor.apply(this, arguments);
    }
    Ellipse.prototype.default_view = exports.EllipseView;
    Ellipse.prototype.type = 'Ellipse';
    Ellipse.mixins(['line', 'fill']);
    Ellipse.define({
        angle: [p.AngleSpec, 0.0],
        width: [p.DistanceSpec],
        height: [p.DistanceSpec]
    });
    return Ellipse;
})(xy_glyph_1.XYGlyph);

},{"./xy_glyph":"models/glyphs/xy_glyph","core/properties":"core/properties"}],"models/glyphs/glyph":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend1 = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var p = require("core/properties");
var bbox = require("core/util/bbox");
var proj = require("core/util/projections");
var bokeh_view_1 = require("core/bokeh_view");
var model_1 = require("../../model");
var visuals_1 = require("core/visuals");
var logging_1 = require("core/logging");
var object_1 = require("core/util/object");
var types_1 = require("core/util/types");
exports.GlyphView = (function (superClass) {
    extend1(GlyphView, superClass);
    function GlyphView() {
        return GlyphView.__super__.constructor.apply(this, arguments);
    }
    GlyphView.prototype.initialize = function (options) {
        var Cls, ctx, e, glglyphs;
        GlyphView.__super__.initialize.call(this, options);
        this._nohit_warned = {};
        this.renderer = options.renderer;
        this.visuals = new visuals_1.Visuals(this.model);
        ctx = this.renderer.plot_view.canvas_view.ctx;
        if (ctx.glcanvas != null) {
            try {
                glglyphs = require("models/glyphs/webgl/index");
            }
            catch (error) {
                e = error;
                if (e.code === 'MODULE_NOT_FOUND') {
                    logging_1.logger.warn('WebGL was requested and is supported, but bokeh-gl(.min).js is not available, falling back to 2D rendering.');
                    glglyphs = null;
                }
                else {
                    throw e;
                }
            }
            if (glglyphs != null) {
                Cls = glglyphs[this.model.type + 'GLGlyph'];
                if (Cls != null) {
                    return this.glglyph = new Cls(ctx.glcanvas.gl, this);
                }
            }
        }
    };
    GlyphView.prototype.set_visuals = function (source) {
        this.visuals.warm_cache(source);
        if (this.glglyph != null) {
            return this.glglyph.set_visuals_changed();
        }
    };
    GlyphView.prototype.render = function (ctx, indices, data) {
        ctx.beginPath();
        if (this.glglyph != null) {
            if (this.glglyph.render(ctx, indices, data)) {
                return;
            }
        }
        return this._render(ctx, indices, data);
    };
    GlyphView.prototype.bounds = function () {
        if (this.index == null) {
            return bbox.empty();
        }
        else {
            return this._bounds(this.index.bbox);
        }
    };
    GlyphView.prototype.log_bounds = function () {
        var bb, j, k, len, len1, positive_x_bbs, positive_y_bbs, x, y;
        if (this.index == null) {
            return bbox.empty();
        }
        bb = bbox.empty();
        positive_x_bbs = this.index.search(bbox.positive_x());
        positive_y_bbs = this.index.search(bbox.positive_y());
        for (j = 0, len = positive_x_bbs.length; j < len; j++) {
            x = positive_x_bbs[j];
            if (x.minX < bb.minX) {
                bb.minX = x.minX;
            }
            if (x.maxX > bb.maxX) {
                bb.maxX = x.maxX;
            }
        }
        for (k = 0, len1 = positive_y_bbs.length; k < len1; k++) {
            y = positive_y_bbs[k];
            if (y.minY < bb.minY) {
                bb.minY = y.minY;
            }
            if (y.maxY > bb.maxY) {
                bb.maxY = y.maxY;
            }
        }
        return this._bounds(bb);
    };
    GlyphView.prototype.max_wh2_bounds = function (bds) {
        return {
            minX: bds.minX - this.max_w2,
            maxX: bds.maxX + this.max_w2,
            minY: bds.minY - this.max_h2,
            maxY: bds.maxY + this.max_h2
        };
    };
    GlyphView.prototype.get_anchor_point = function (anchor, i, arg) {
        var sx, sy;
        sx = arg[0], sy = arg[1];
        switch (anchor) {
            case "center":
                return {
                    x: this.scx(i, sx, sy),
                    y: this.scy(i, sx, sy)
                };
            default:
                return null;
        }
    };
    GlyphView.prototype.scx = function (i) {
        return this.sx[i];
    };
    GlyphView.prototype.scy = function (i) {
        return this.sy[i];
    };
    GlyphView.prototype.sdist = function (mapper, pts, spans, pts_location, dilate) {
        var d, halfspan, i, pt0, pt1, spt0, spt1;
        if (pts_location == null) {
            pts_location = "edge";
        }
        if (dilate == null) {
            dilate = false;
        }
        if (types_1.isString(pts[0])) {
            pts = mapper.v_map_to_target(pts);
        }
        if (pts_location === 'center') {
            halfspan = (function () {
                var j, len, results;
                results = [];
                for (j = 0, len = spans.length; j < len; j++) {
                    d = spans[j];
                    results.push(d / 2);
                }
                return results;
            })();
            pt0 = (function () {
                var j, ref, results;
                results = [];
                for (i = j = 0, ref = pts.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                    results.push(pts[i] - halfspan[i]);
                }
                return results;
            })();
            pt1 = (function () {
                var j, ref, results;
                results = [];
                for (i = j = 0, ref = pts.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                    results.push(pts[i] + halfspan[i]);
                }
                return results;
            })();
        }
        else {
            pt0 = pts;
            pt1 = (function () {
                var j, ref, results;
                results = [];
                for (i = j = 0, ref = pt0.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                    results.push(pt0[i] + spans[i]);
                }
                return results;
            })();
        }
        spt0 = mapper.v_map_to_target(pt0);
        spt1 = mapper.v_map_to_target(pt1);
        if (dilate) {
            return (function () {
                var j, ref, results;
                results = [];
                for (i = j = 0, ref = spt0.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                    results.push(Math.ceil(Math.abs(spt1[i] - spt0[i])));
                }
                return results;
            })();
        }
        else {
            return (function () {
                var j, ref, results;
                results = [];
                for (i = j = 0, ref = spt0.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                    results.push(Math.abs(spt1[i] - spt0[i]));
                }
                return results;
            })();
        }
    };
    GlyphView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return null;
    };
    GlyphView.prototype._generic_line_legend = function (ctx, x0, x1, y0, y1, index) {
        ctx.save();
        ctx.beginPath();
        ctx.moveTo(x0, (y0 + y1) / 2);
        ctx.lineTo(x1, (y0 + y1) / 2);
        if (this.visuals.line.doit) {
            this.visuals.line.set_vectorize(ctx, index);
            ctx.stroke();
        }
        return ctx.restore();
    };
    GlyphView.prototype._generic_area_legend = function (ctx, x0, x1, y0, y1, index) {
        var dh, dw, h, indices, sx0, sx1, sy0, sy1, w;
        indices = [index];
        w = Math.abs(x1 - x0);
        dw = w * 0.1;
        h = Math.abs(y1 - y0);
        dh = h * 0.1;
        sx0 = x0 + dw;
        sx1 = x1 - dw;
        sy0 = y0 + dh;
        sy1 = y1 - dh;
        if (this.visuals.fill.doit) {
            this.visuals.fill.set_vectorize(ctx, index);
            ctx.fillRect(sx0, sy0, sx1 - sx0, sy1 - sy0);
        }
        if (this.visuals.line.doit) {
            ctx.beginPath();
            ctx.rect(sx0, sy0, sx1 - sx0, sy1 - sy0);
            this.visuals.line.set_vectorize(ctx, index);
            return ctx.stroke();
        }
    };
    GlyphView.prototype.hit_test = function (geometry) {
        var func, result;
        result = null;
        func = "_hit_" + geometry.type;
        if (this[func] != null) {
            result = this[func](geometry);
        }
        else if (this._nohit_warned[geometry.type] == null) {
            logging_1.logger.debug("'" + geometry.type + "' selection not available for " + this.model.type);
            this._nohit_warned[geometry.type] = true;
        }
        return result;
    };
    GlyphView.prototype.set_data = function (source) {
        var data, ref, ref1;
        data = this.model.materialize_dataspecs(source);
        object_1.extend(this, data);
        if (this.renderer.plot_view.model.use_map) {
            if (this._x != null) {
                ref = proj.project_xy(this._x, this._y), this._x = ref[0], this._y = ref[1];
            }
            if (this._xs != null) {
                ref1 = proj.project_xsys(this._xs, this._ys), this._xs = ref1[0], this._ys = ref1[1];
            }
        }
        if (this.glglyph != null) {
            this.glglyph.set_data_changed(this._x.length);
        }
        this._set_data(source);
        return this.index = this._index_data();
    };
    GlyphView.prototype._set_data = function () { };
    GlyphView.prototype._index_data = function () { };
    GlyphView.prototype.mask_data = function (indices) {
        if (this.glglyph != null) {
            return indices;
        }
        else {
            return this._mask_data(indices);
        }
    };
    GlyphView.prototype._mask_data = function (indices) {
        return indices;
    };
    GlyphView.prototype._bounds = function (bounds) {
        return bounds;
    };
    GlyphView.prototype.map_data = function () {
        var i, j, k, len, ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, sx, sxname, sy, syname, xname, yname;
        ref = this.model._coords;
        for (j = 0, len = ref.length; j < len; j++) {
            ref1 = ref[j], xname = ref1[0], yname = ref1[1];
            sxname = "s" + xname;
            syname = "s" + yname;
            xname = "_" + xname;
            yname = "_" + yname;
            if (types_1.isArray((ref2 = this[xname]) != null ? ref2[0] : void 0) || ((ref3 = this[xname]) != null ? (ref4 = ref3[0]) != null ? ref4.buffer : void 0 : void 0) instanceof ArrayBuffer) {
                ref5 = [[], []], this[sxname] = ref5[0], this[syname] = ref5[1];
                for (i = k = 0, ref6 = this[xname].length; 0 <= ref6 ? k < ref6 : k > ref6; i = 0 <= ref6 ? ++k : --k) {
                    ref7 = this.map_to_screen(this[xname][i], this[yname][i]), sx = ref7[0], sy = ref7[1];
                    this[sxname].push(sx);
                    this[syname].push(sy);
                }
            }
            else {
                ref8 = this.map_to_screen(this[xname], this[yname]), this[sxname] = ref8[0], this[syname] = ref8[1];
            }
        }
        return this._map_data();
    };
    GlyphView.prototype._map_data = function () { };
    GlyphView.prototype.map_to_screen = function (x, y) {
        return this.renderer.plot_view.map_to_screen(x, y, this.model.x_range_name, this.model.y_range_name);
    };
    return GlyphView;
})(bokeh_view_1.BokehView);
exports.Glyph = (function (superClass) {
    extend1(Glyph, superClass);
    function Glyph() {
        return Glyph.__super__.constructor.apply(this, arguments);
    }
    Glyph.prototype._coords = [];
    Glyph.coords = function (coords) {
        var _coords, j, len, ref, result, x, y;
        _coords = this.prototype._coords.concat(coords);
        this.prototype._coords = _coords;
        result = {};
        for (j = 0, len = coords.length; j < len; j++) {
            ref = coords[j], x = ref[0], y = ref[1];
            result[x] = [p.NumberSpec];
            result[y] = [p.NumberSpec];
        }
        return this.define(result);
    };
    Glyph.internal({
        x_range_name: [p.String, 'default'],
        y_range_name: [p.String, 'default']
    });
    return Glyph;
})(model_1.Model);

},{"../../model":"model","core/bokeh_view":"core/bokeh_view","core/logging":"core/logging","core/properties":"core/properties","core/util/bbox":"core/util/bbox","core/util/object":"core/util/object","core/util/projections":"core/util/projections","core/util/types":"core/util/types","core/visuals":"core/visuals","models/glyphs/webgl/index":undefined}],"models/glyphs/hbar":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var spatial_1 = require("core/util/spatial");
var glyph_1 = require("./glyph");
var categorical_mapper_1 = require("../mappers/categorical_mapper");
var hittest = require("core/hittest");
var p = require("core/properties");
exports.HBarView = (function (superClass) {
    extend(HBarView, superClass);
    function HBarView() {
        return HBarView.__super__.constructor.apply(this, arguments);
    }
    HBarView.prototype._map_data = function () {
        var i, j, ref, vleft, vright, vy;
        vy = this.renderer.ymapper.v_map_to_target(this._y);
        this.sy = this.renderer.plot_view.canvas.v_vy_to_sy(vy);
        vright = this.renderer.xmapper.v_map_to_target(this._right);
        vleft = this.renderer.xmapper.v_map_to_target(this._left);
        this.sright = this.renderer.plot_view.canvas.v_vx_to_sx(vright);
        this.sleft = this.renderer.plot_view.canvas.v_vx_to_sx(vleft);
        this.stop = [];
        this.sbottom = [];
        this.sh = this.sdist(this.renderer.ymapper, this._y, this._height, 'center');
        for (i = j = 0, ref = this.sy.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            this.stop.push(this.sy[i] - this.sh[i] / 2);
            this.sbottom.push(this.sy[i] + this.sh[i] / 2);
        }
        return null;
    };
    HBarView.prototype._index_data = function () {
        var b, height, i, j, l, left, map_to_synthetic, points, r, ref, right, t, y;
        map_to_synthetic = function (mapper, array) {
            if (mapper instanceof categorical_mapper_1.CategoricalMapper) {
                return mapper.v_map_to_target(array, true);
            }
            else {
                return array;
            }
        };
        left = map_to_synthetic(this.renderer.xmapper, this._left);
        right = map_to_synthetic(this.renderer.xmapper, this._right);
        y = map_to_synthetic(this.renderer.ymapper, this._y);
        height = map_to_synthetic(this.renderer.ymapper, this._height);
        points = [];
        for (i = j = 0, ref = y.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            l = left[i];
            r = right[i];
            t = y[i] + 0.5 * height[i];
            b = y[i] - 0.5 * height[i];
            if (isNaN(l + r + t + b) || !isFinite(l + r + t + b)) {
                continue;
            }
            points.push({
                minX: l,
                minY: b,
                maxX: r,
                maxY: t,
                i: i
            });
        }
        return new spatial_1.RBush(points);
    };
    HBarView.prototype._render = function (ctx, indices, arg) {
        var i, j, len, results, sbottom, sleft, sright, stop;
        sleft = arg.sleft, sright = arg.sright, stop = arg.stop, sbottom = arg.sbottom;
        results = [];
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (isNaN(sleft[i] + stop[i] + sright[i] + sbottom[i])) {
                continue;
            }
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                ctx.fillRect(sleft[i], stop[i], sright[i] - sleft[i], sbottom[i] - stop[i]);
            }
            if (this.visuals.line.doit) {
                ctx.beginPath();
                ctx.rect(sleft[i], stop[i], sright[i] - sleft[i], sbottom[i] - stop[i]);
                this.visuals.line.set_vectorize(ctx, i);
                results.push(ctx.stroke());
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    HBarView.prototype._hit_point = function (geometry) {
        var hits, ref, result, vx, vy, x, y;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        x = this.renderer.xmapper.map_from_target(vx, true);
        y = this.renderer.ymapper.map_from_target(vy, true);
        hits = this.index.indices({
            minX: x,
            minY: y,
            maxX: x,
            maxY: y
        });
        result = hittest.create_hit_test_result();
        result['1d'].indices = hits;
        return result;
    };
    HBarView.prototype.scx = function (i) {
        return (this.sleft[i] + this.sright[i]) / 2;
    };
    HBarView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
    };
    return HBarView;
})(glyph_1.GlyphView);
exports.HBar = (function (superClass) {
    extend(HBar, superClass);
    function HBar() {
        return HBar.__super__.constructor.apply(this, arguments);
    }
    HBar.prototype.default_view = exports.HBarView;
    HBar.prototype.type = 'HBar';
    HBar.mixins(['line', 'fill']);
    HBar.define({
        y: [p.NumberSpec],
        height: [p.DistanceSpec],
        left: [p.NumberSpec, 0],
        right: [p.NumberSpec]
    });
    return HBar;
})(glyph_1.Glyph);

},{"../mappers/categorical_mapper":"models/mappers/categorical_mapper","./glyph":"models/glyphs/glyph","core/hittest":"core/hittest","core/properties":"core/properties","core/util/spatial":"core/util/spatial"}],"models/glyphs/image":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Greys9, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
var linear_color_mapper_1 = require("../mappers/linear_color_mapper");
var p = require("core/properties");
var array_1 = require("core/util/array");
exports.ImageView = (function (superClass) {
    extend(ImageView, superClass);
    function ImageView() {
        return ImageView.__super__.constructor.apply(this, arguments);
    }
    ImageView.prototype.initialize = function (options) {
        ImageView.__super__.initialize.call(this, options);
        return this.listenTo(this.model.color_mapper, 'change', this._update_image);
    };
    ImageView.prototype._update_image = function () {
        if (this.image_data != null) {
            this._set_data();
            return this.renderer.plot_view.request_render();
        }
    };
    ImageView.prototype._set_data = function () {
        var buf, buf8, canvas, cmap, ctx, i, image_data, img, j, ref, results, shape;
        if ((this.image_data == null) || this.image_data.length !== this._image.length) {
            this.image_data = new Array(this._image.length);
        }
        if ((this._width == null) || this._width.length !== this._image.length) {
            this._width = new Array(this._image.length);
        }
        if ((this._height == null) || this._height.length !== this._image.length) {
            this._height = new Array(this._image.length);
        }
        results = [];
        for (i = j = 0, ref = this._image.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            shape = [];
            if (this._image_shape != null) {
                shape = this._image_shape[i];
            }
            if (shape.length > 0) {
                img = this._image[i];
                this._height[i] = shape[0];
                this._width[i] = shape[1];
            }
            else {
                img = array_1.concat(this._image[i]);
                this._height[i] = this._image[i].length;
                this._width[i] = this._image[i][0].length;
            }
            if ((this.image_data[i] != null) && this.image_data[i].width === this._width[i] && this.image_data[i].height === this._height[i]) {
                canvas = this.image_data[i];
            }
            else {
                canvas = document.createElement('canvas');
                canvas.width = this._width[i];
                canvas.height = this._height[i];
            }
            ctx = canvas.getContext('2d');
            image_data = ctx.getImageData(0, 0, this._width[i], this._height[i]);
            cmap = this.model.color_mapper;
            buf = cmap.v_map_screen(img, true);
            buf8 = new Uint8Array(buf);
            image_data.data.set(buf8);
            ctx.putImageData(image_data, 0, 0);
            this.image_data[i] = canvas;
            this.max_dw = 0;
            if (this._dw.units === "data") {
                this.max_dw = array_1.max(this._dw);
            }
            this.max_dh = 0;
            if (this._dh.units === "data") {
                results.push(this.max_dh = array_1.max(this._dh));
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    ImageView.prototype._map_data = function () {
        switch (this.model.properties.dw.units) {
            case "data":
                this.sw = this.sdist(this.renderer.xmapper, this._x, this._dw, 'edge', this.model.dilate);
                break;
            case "screen":
                this.sw = this._dw;
        }
        switch (this.model.properties.dh.units) {
            case "data":
                return this.sh = this.sdist(this.renderer.ymapper, this._y, this._dh, 'edge', this.model.dilate);
            case "screen":
                return this.sh = this._dh;
        }
    };
    ImageView.prototype._render = function (ctx, indices, arg) {
        var i, image_data, j, len, old_smoothing, sh, sw, sx, sy, y_offset;
        image_data = arg.image_data, sx = arg.sx, sy = arg.sy, sw = arg.sw, sh = arg.sh;
        old_smoothing = ctx.getImageSmoothingEnabled();
        ctx.setImageSmoothingEnabled(false);
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (image_data[i] == null) {
                continue;
            }
            if (isNaN(sx[i] + sy[i] + sw[i] + sh[i])) {
                continue;
            }
            y_offset = sy[i];
            ctx.translate(0, y_offset);
            ctx.scale(1, -1);
            ctx.translate(0, -y_offset);
            ctx.drawImage(image_data[i], sx[i] | 0, sy[i] | 0, sw[i], sh[i]);
            ctx.translate(0, y_offset);
            ctx.scale(1, -1);
            ctx.translate(0, -y_offset);
        }
        return ctx.setImageSmoothingEnabled(old_smoothing);
    };
    ImageView.prototype.bounds = function () {
        var bbox;
        bbox = this.index.bbox;
        bbox.maxX += this.max_dw;
        bbox.maxY += this.max_dh;
        return bbox;
    };
    return ImageView;
})(xy_glyph_1.XYGlyphView);
Greys9 = function () {
    return [0x000000, 0x252525, 0x525252, 0x737373, 0x969696, 0xbdbdbd, 0xd9d9d9, 0xf0f0f0, 0xffffff];
};
exports.Image = (function (superClass) {
    extend(Image, superClass);
    function Image() {
        return Image.__super__.constructor.apply(this, arguments);
    }
    Image.prototype.default_view = exports.ImageView;
    Image.prototype.type = 'Image';
    Image.define({
        image: [p.NumberSpec],
        dw: [p.DistanceSpec],
        dh: [p.DistanceSpec],
        dilate: [p.Bool, false],
        color_mapper: [
            p.Instance, function () {
                return new linear_color_mapper_1.LinearColorMapper({
                    palette: Greys9()
                });
            }
        ]
    });
    return Image;
})(xy_glyph_1.XYGlyph);

},{"../mappers/linear_color_mapper":"models/mappers/linear_color_mapper","./xy_glyph":"models/glyphs/xy_glyph","core/properties":"core/properties","core/util/array":"core/util/array"}],"models/glyphs/image_rgba":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
var p = require("core/properties");
var array_1 = require("core/util/array");
exports.ImageRGBAView = (function (superClass) {
    extend(ImageRGBAView, superClass);
    function ImageRGBAView() {
        return ImageRGBAView.__super__.constructor.apply(this, arguments);
    }
    ImageRGBAView.prototype._set_data = function (source, arg) {
        var buf, buf8, canvas, color, ctx, flat, i, image_data, j, k, l, m, ref, ref1, ref2, results, shape;
        if ((this.image_data == null) || this.image_data.length !== this._image.length) {
            this.image_data = new Array(this._image.length);
        }
        if ((this._width == null) || this._width.length !== this._image.length) {
            this._width = new Array(this._image.length);
        }
        if ((this._height == null) || this._height.length !== this._image.length) {
            this._height = new Array(this._image.length);
        }
        results = [];
        for (i = k = 0, ref = this._image.length; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
            if (arg != null) {
                if (i !== arg) {
                    continue;
                }
            }
            shape = [];
            if (this._image_shape != null) {
                shape = this._image_shape[i];
            }
            if (this._rows != null) {
                this._height[i] = this._rows[i];
                this._width[i] = this._cols[i];
                if (shape.length > 0) {
                    buf = this._image[i].buffer;
                }
                else {
                    flat = this._image[i];
                    buf = new ArrayBuffer(flat.length * 4);
                    color = new Uint32Array(buf);
                    for (j = l = 0, ref1 = flat.length; 0 <= ref1 ? l < ref1 : l > ref1; j = 0 <= ref1 ? ++l : --l) {
                        color[j] = flat[j];
                    }
                }
            }
            else if (shape.length > 0) {
                buf = this._image[i].buffer;
                this._height[i] = shape[0];
                this._width[i] = shape[1];
            }
            else {
                flat = array_1.concat(this._image[i]);
                buf = new ArrayBuffer(flat.length * 4);
                color = new Uint32Array(buf);
                for (j = m = 0, ref2 = flat.length; 0 <= ref2 ? m < ref2 : m > ref2; j = 0 <= ref2 ? ++m : --m) {
                    color[j] = flat[j];
                }
                this._height[i] = this._image[i].length;
                this._width[i] = this._image[i][0].length;
            }
            if ((this.image_data[i] != null) && this.image_data[i].width === this._width[i] && this.image_data[i].height === this._height[i]) {
                canvas = this.image_data[i];
            }
            else {
                canvas = document.createElement('canvas');
                canvas.width = this._width[i];
                canvas.height = this._height[i];
            }
            ctx = canvas.getContext('2d');
            image_data = ctx.getImageData(0, 0, this._width[i], this._height[i]);
            buf8 = new Uint8Array(buf);
            image_data.data.set(buf8);
            ctx.putImageData(image_data, 0, 0);
            this.image_data[i] = canvas;
            this.max_dw = 0;
            if (this._dw.units === "data") {
                this.max_dw = array_1.max(this._dw);
            }
            this.max_dh = 0;
            if (this._dh.units === "data") {
                results.push(this.max_dh = array_1.max(this._dh));
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    ImageRGBAView.prototype._map_data = function () {
        switch (this.model.properties.dw.units) {
            case "data":
                this.sw = this.sdist(this.renderer.xmapper, this._x, this._dw, 'edge', this.model.dilate);
                break;
            case "screen":
                this.sw = this._dw;
        }
        switch (this.model.properties.dh.units) {
            case "data":
                return this.sh = this.sdist(this.renderer.ymapper, this._y, this._dh, 'edge', this.model.dilate);
            case "screen":
                return this.sh = this._dh;
        }
    };
    ImageRGBAView.prototype._render = function (ctx, indices, arg1) {
        var i, image_data, k, len, old_smoothing, sh, sw, sx, sy, y_offset;
        image_data = arg1.image_data, sx = arg1.sx, sy = arg1.sy, sw = arg1.sw, sh = arg1.sh;
        old_smoothing = ctx.getImageSmoothingEnabled();
        ctx.setImageSmoothingEnabled(false);
        for (k = 0, len = indices.length; k < len; k++) {
            i = indices[k];
            if (isNaN(sx[i] + sy[i] + sw[i] + sh[i])) {
                continue;
            }
            y_offset = sy[i];
            ctx.translate(0, y_offset);
            ctx.scale(1, -1);
            ctx.translate(0, -y_offset);
            ctx.drawImage(image_data[i], sx[i] | 0, sy[i] | 0, sw[i], sh[i]);
            ctx.translate(0, y_offset);
            ctx.scale(1, -1);
            ctx.translate(0, -y_offset);
        }
        return ctx.setImageSmoothingEnabled(old_smoothing);
    };
    ImageRGBAView.prototype.bounds = function () {
        var bbox;
        bbox = this.index.bbox;
        bbox.maxX += this.max_dw;
        bbox.maxY += this.max_dh;
        return bbox;
    };
    return ImageRGBAView;
})(xy_glyph_1.XYGlyphView);
exports.ImageRGBA = (function (superClass) {
    extend(ImageRGBA, superClass);
    function ImageRGBA() {
        return ImageRGBA.__super__.constructor.apply(this, arguments);
    }
    ImageRGBA.prototype.default_view = exports.ImageRGBAView;
    ImageRGBA.prototype.type = 'ImageRGBA';
    ImageRGBA.define({
        image: [p.NumberSpec],
        rows: [p.NumberSpec],
        cols: [p.NumberSpec],
        dw: [p.DistanceSpec],
        dh: [p.DistanceSpec],
        dilate: [p.Bool, false]
    });
    ImageRGBA.prototype.initialize = function (attrs, options) {
        ImageRGBA.__super__.initialize.call(this, attrs, options);
        this.properties.rows.optional = true;
        return this.properties.cols.optional = true;
    };
    return ImageRGBA;
})(xy_glyph_1.XYGlyph);

},{"./xy_glyph":"models/glyphs/xy_glyph","core/properties":"core/properties","core/util/array":"core/util/array"}],"models/glyphs/image_url":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var glyph_1 = require("./glyph");
var logging_1 = require("core/logging");
var p = require("core/properties");
exports.ImageURLView = (function (superClass) {
    extend(ImageURLView, superClass);
    function ImageURLView() {
        return ImageURLView.__super__.constructor.apply(this, arguments);
    }
    ImageURLView.prototype.initialize = function (options) {
        ImageURLView.__super__.initialize.call(this, options);
        return this.listenTo(this.model, 'change:global_alpha', this.renderer.request_render);
    };
    ImageURLView.prototype._index_data = function () { };
    ImageURLView.prototype._set_data = function () {
        var i, img, j, ref, results, retry_attempts, retry_timeout;
        if ((this.image == null) || this.image.length !== this._url.length) {
            this.image = (function () {
                var j, len, ref, results;
                ref = this._url;
                results = [];
                for (j = 0, len = ref.length; j < len; j++) {
                    img = ref[j];
                    results.push(null);
                }
                return results;
            }).call(this);
        }
        retry_attempts = this.model.retry_attempts;
        retry_timeout = this.model.retry_timeout;
        this.retries = (function () {
            var j, len, ref, results;
            ref = this._url;
            results = [];
            for (j = 0, len = ref.length; j < len; j++) {
                img = ref[j];
                results.push(retry_attempts);
            }
            return results;
        }).call(this);
        results = [];
        for (i = j = 0, ref = this._url.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            if (this._url[i] == null) {
                continue;
            }
            img = new Image();
            img.onerror = (function (_this) {
                return function (i, img) {
                    return function () {
                        if (_this.retries[i] > 0) {
                            logging_1.logger.trace("ImageURL failed to load " + _this._url[i] + " image, retrying in " + retry_timeout + " ms");
                            setTimeout((function () {
                                return img.src = _this._url[i];
                            }), retry_timeout);
                        }
                        else {
                            logging_1.logger.warn("ImageURL unable to load " + _this._url[i] + " image after " + retry_attempts + " retries");
                        }
                        return _this.retries[i] -= 1;
                    };
                };
            })(this)(i, img);
            img.onload = (function (_this) {
                return function (img, i) {
                    return function () {
                        _this.image[i] = img;
                        return _this.renderer.request_render();
                    };
                };
            })(this)(img, i);
            results.push(img.src = this._url[i]);
        }
        return results;
    };
    ImageURLView.prototype._map_data = function () {
        var hs, ws, x;
        ws = ((function () {
            var j, len, ref, results;
            if (this._w != null) {
                return this._w;
            }
            else {
                ref = this._x;
                results = [];
                for (j = 0, len = ref.length; j < len; j++) {
                    x = ref[j];
                    results.push(0 / 0);
                }
                return results;
            }
        }).call(this));
        hs = ((function () {
            var j, len, ref, results;
            if (this._h != null) {
                return this._h;
            }
            else {
                ref = this._x;
                results = [];
                for (j = 0, len = ref.length; j < len; j++) {
                    x = ref[j];
                    results.push(0 / 0);
                }
                return results;
            }
        }).call(this));
        switch (this.model.properties.w.units) {
            case "data":
                this.sw = this.sdist(this.renderer.xmapper, this._x, ws, 'edge', this.model.dilate);
                break;
            case "screen":
                this.sw = ws;
        }
        switch (this.model.properties.h.units) {
            case "data":
                return this.sh = this.sdist(this.renderer.ymapper, this._y, hs, 'edge', this.model.dilate);
            case "screen":
                return this.sh = hs;
        }
    };
    ImageURLView.prototype._render = function (ctx, indices, arg) {
        var _angle, _url, frame, i, image, j, len, results, sh, sw, sx, sy;
        _url = arg._url, image = arg.image, sx = arg.sx, sy = arg.sy, sw = arg.sw, sh = arg.sh, _angle = arg._angle;
        frame = this.renderer.plot_view.frame;
        ctx.rect(frame.left + 1, frame.bottom + 1, frame.width - 2, frame.height - 2);
        ctx.clip();
        results = [];
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (isNaN(sx[i] + sy[i] + _angle[i])) {
                continue;
            }
            if (this.retries[i] === -1) {
                continue;
            }
            if (image[i] == null) {
                continue;
            }
            results.push(this._render_image(ctx, i, image[i], sx, sy, sw, sh, _angle));
        }
        return results;
    };
    ImageURLView.prototype._final_sx_sy = function (anchor, sx, sy, sw, sh) {
        switch (anchor) {
            case 'top_left':
                return [sx, sy];
            case 'top_center':
                return [sx - sw / 2, sy];
            case 'top_right':
                return [sx - sw, sy];
            case 'center_right':
                return [sx - sw, sy - sh / 2];
            case 'bottom_right':
                return [sx - sw, sy - sh];
            case 'bottom_center':
                return [sx - sw / 2, sy - sh];
            case 'bottom_left':
                return [sx, sy - sh];
            case 'center_left':
                return [sx, sy - sh / 2];
            case 'center':
                return [sx - sw / 2, sy - sh / 2];
        }
    };
    ImageURLView.prototype._render_image = function (ctx, i, image, sx, sy, sw, sh, angle) {
        var anchor, ref;
        if (isNaN(sw[i])) {
            sw[i] = image.width;
        }
        if (isNaN(sh[i])) {
            sh[i] = image.height;
        }
        anchor = this.model.anchor;
        ref = this._final_sx_sy(anchor, sx[i], sy[i], sw[i], sh[i]), sx = ref[0], sy = ref[1];
        ctx.save();
        ctx.globalAlpha = this.model.global_alpha;
        if (angle[i]) {
            ctx.translate(sx, sy);
            ctx.rotate(angle[i]);
            ctx.drawImage(image, 0, 0, sw[i], sh[i]);
            ctx.rotate(-angle[i]);
            ctx.translate(-sx, -sy);
        }
        else {
            ctx.drawImage(image, sx, sy, sw[i], sh[i]);
        }
        return ctx.restore();
    };
    return ImageURLView;
})(glyph_1.GlyphView);
exports.ImageURL = (function (superClass) {
    extend(ImageURL, superClass);
    function ImageURL() {
        return ImageURL.__super__.constructor.apply(this, arguments);
    }
    ImageURL.prototype.default_view = exports.ImageURLView;
    ImageURL.prototype.type = 'ImageURL';
    ImageURL.coords([['x', 'y']]);
    ImageURL.mixins([]);
    ImageURL.define({
        url: [p.StringSpec],
        anchor: [p.Anchor, 'top_left'],
        global_alpha: [p.Number, 1.0],
        angle: [p.AngleSpec, 0],
        w: [p.DistanceSpec],
        h: [p.DistanceSpec],
        dilate: [p.Bool, false],
        retry_attempts: [p.Number, 0],
        retry_timeout: [p.Number, 0]
    });
    return ImageURL;
})(glyph_1.Glyph);

},{"./glyph":"models/glyphs/glyph","core/logging":"core/logging","core/properties":"core/properties"}],"models/glyphs/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var annular_wedge_1 = require("./annular_wedge");
exports.AnnularWedge = annular_wedge_1.AnnularWedge;
var annulus_1 = require("./annulus");
exports.Annulus = annulus_1.Annulus;
var arc_1 = require("./arc");
exports.Arc = arc_1.Arc;
var bezier_1 = require("./bezier");
exports.Bezier = bezier_1.Bezier;
var circle_1 = require("./circle");
exports.Circle = circle_1.Circle;
var ellipse_1 = require("./ellipse");
exports.Ellipse = ellipse_1.Ellipse;
var glyph_1 = require("./glyph");
exports.Glyph = glyph_1.Glyph;
var hbar_1 = require("./hbar");
exports.HBar = hbar_1.HBar;
var image_1 = require("./image");
exports.Image = image_1.Image;
var image_rgba_1 = require("./image_rgba");
exports.ImageRGBA = image_rgba_1.ImageRGBA;
var image_url_1 = require("./image_url");
exports.ImageURL = image_url_1.ImageURL;
var line_1 = require("./line");
exports.Line = line_1.Line;
var multi_line_1 = require("./multi_line");
exports.MultiLine = multi_line_1.MultiLine;
var oval_1 = require("./oval");
exports.Oval = oval_1.Oval;
var patch_1 = require("./patch");
exports.Patch = patch_1.Patch;
var patches_1 = require("./patches");
exports.Patches = patches_1.Patches;
var quad_1 = require("./quad");
exports.Quad = quad_1.Quad;
var quadratic_1 = require("./quadratic");
exports.Quadratic = quadratic_1.Quadratic;
var ray_1 = require("./ray");
exports.Ray = ray_1.Ray;
var rect_1 = require("./rect");
exports.Rect = rect_1.Rect;
var segment_1 = require("./segment");
exports.Segment = segment_1.Segment;
var text_1 = require("./text");
exports.Text = text_1.Text;
var vbar_1 = require("./vbar");
exports.VBar = vbar_1.VBar;
var wedge_1 = require("./wedge");
exports.Wedge = wedge_1.Wedge;
var xy_glyph_1 = require("./xy_glyph");
exports.XYGlyph = xy_glyph_1.XYGlyph;

},{"./annular_wedge":"models/glyphs/annular_wedge","./annulus":"models/glyphs/annulus","./arc":"models/glyphs/arc","./bezier":"models/glyphs/bezier","./circle":"models/glyphs/circle","./ellipse":"models/glyphs/ellipse","./glyph":"models/glyphs/glyph","./hbar":"models/glyphs/hbar","./image":"models/glyphs/image","./image_rgba":"models/glyphs/image_rgba","./image_url":"models/glyphs/image_url","./line":"models/glyphs/line","./multi_line":"models/glyphs/multi_line","./oval":"models/glyphs/oval","./patch":"models/glyphs/patch","./patches":"models/glyphs/patches","./quad":"models/glyphs/quad","./quadratic":"models/glyphs/quadratic","./ray":"models/glyphs/ray","./rect":"models/glyphs/rect","./segment":"models/glyphs/segment","./text":"models/glyphs/text","./vbar":"models/glyphs/vbar","./wedge":"models/glyphs/wedge","./xy_glyph":"models/glyphs/xy_glyph"}],"models/glyphs/line":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
var hittest = require("core/hittest");
exports.LineView = (function (superClass) {
    extend(LineView, superClass);
    function LineView() {
        return LineView.__super__.constructor.apply(this, arguments);
    }
    LineView.prototype._render = function (ctx, indices, arg) {
        var drawing, i, j, len, sx, sy;
        sx = arg.sx, sy = arg.sy;
        drawing = false;
        this.visuals.line.set_value(ctx);
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (!isFinite(sx[i] + sy[i]) && drawing) {
                ctx.stroke();
                ctx.beginPath();
                drawing = false;
                continue;
            }
            if (drawing) {
                ctx.lineTo(sx[i], sy[i]);
            }
            else {
                ctx.beginPath();
                ctx.moveTo(sx[i], sy[i]);
                drawing = true;
            }
        }
        if (drawing) {
            return ctx.stroke();
        }
    };
    LineView.prototype._hit_point = function (geometry) {
        /* Check if the point geometry hits this line glyph and return an object
        that describes the hit result:
          Args:
            * geometry (object): object with the following keys
              * vx (float): view x coordinate of the point
              * vy (float): view y coordinate of the point
              * type (str): type of geometry (in this case it's a point)
          Output:
            Object with the following keys:
              * 0d (bool): whether the point hits the glyph or not
              * 1d (array(int)): array with the indices hit by the point
         */
        var dist, i, j, p0, p1, point, ref, ref1, result, shortest, threshold;
        result = hittest.create_hit_test_result();
        point = {
            x: this.renderer.plot_view.canvas.vx_to_sx(geometry.vx),
            y: this.renderer.plot_view.canvas.vy_to_sy(geometry.vy)
        };
        shortest = 9999;
        threshold = Math.max(2, this.visuals.line.line_width.value() / 2);
        for (i = j = 0, ref = this.sx.length - 1; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            ref1 = [
                {
                    x: this.sx[i],
                    y: this.sy[i]
                }, {
                    x: this.sx[i + 1],
                    y: this.sy[i + 1]
                }
            ], p0 = ref1[0], p1 = ref1[1];
            dist = hittest.dist_to_segment(point, p0, p1);
            if (dist < threshold && dist < shortest) {
                shortest = dist;
                result['0d'].glyph = this.model;
                result['0d'].get_view = (function () {
                    return this;
                }).bind(this);
                result['0d'].flag = true;
                result['0d'].indices = [i];
            }
        }
        return result;
    };
    LineView.prototype._hit_span = function (geometry) {
        var i, j, ref, ref1, result, val, values, vx, vy;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        result = hittest.create_hit_test_result();
        if (geometry.direction === 'v') {
            val = this.renderer.ymapper.map_from_target(vy);
            values = this._y;
        }
        else {
            val = this.renderer.xmapper.map_from_target(vx);
            values = this._x;
        }
        for (i = j = 0, ref1 = values.length - 1; 0 <= ref1 ? j < ref1 : j > ref1; i = 0 <= ref1 ? ++j : --j) {
            if ((values[i] <= val && val <= values[i + 1])) {
                result['0d'].glyph = this.model;
                result['0d'].get_view = (function () {
                    return this;
                }).bind(this);
                result['0d'].flag = true;
                result['0d'].indices.push(i);
            }
        }
        return result;
    };
    LineView.prototype.get_interpolation_hit = function (i, geometry) {
        var ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, res, vx, vy, x0, x1, x2, x3, y0, y1, y2, y3;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        ref1 = [this._x[i], this._y[i], this._x[i + 1], this._y[i + 1]], x2 = ref1[0], y2 = ref1[1], x3 = ref1[2], y3 = ref1[3];
        if (geometry.type === 'point') {
            ref2 = this.renderer.ymapper.v_map_from_target([vy - 1, vy + 1]), y0 = ref2[0], y1 = ref2[1];
            ref3 = this.renderer.xmapper.v_map_from_target([vx - 1, vx + 1]), x0 = ref3[0], x1 = ref3[1];
        }
        else {
            if (geometry.direction === 'v') {
                ref4 = this.renderer.ymapper.v_map_from_target([vy, vy]), y0 = ref4[0], y1 = ref4[1];
                ref5 = [x2, x3], x0 = ref5[0], x1 = ref5[1];
            }
            else {
                ref6 = this.renderer.xmapper.v_map_from_target([vx, vx]), x0 = ref6[0], x1 = ref6[1];
                ref7 = [y2, y3], y0 = ref7[0], y1 = ref7[1];
            }
        }
        res = hittest.check_2_segments_intersect(x0, y0, x1, y1, x2, y2, x3, y3);
        return [res.x, res.y];
    };
    LineView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
    };
    return LineView;
})(xy_glyph_1.XYGlyphView);
exports.Line = (function (superClass) {
    extend(Line, superClass);
    function Line() {
        return Line.__super__.constructor.apply(this, arguments);
    }
    Line.prototype.default_view = exports.LineView;
    Line.prototype.type = 'Line';
    Line.mixins(['line']);
    return Line;
})(xy_glyph_1.XYGlyph);

},{"./xy_glyph":"models/glyphs/xy_glyph","core/hittest":"core/hittest"}],"models/glyphs/multi_line":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var spatial_1 = require("core/util/spatial");
var hittest = require("core/hittest");
var array_1 = require("core/util/array");
var types_1 = require("core/util/types");
var glyph_1 = require("./glyph");
exports.MultiLineView = (function (superClass) {
    extend(MultiLineView, superClass);
    function MultiLineView() {
        return MultiLineView.__super__.constructor.apply(this, arguments);
    }
    MultiLineView.prototype._index_data = function () {
        var i, k, points, ref, x, xs, y, ys;
        points = [];
        for (i = k = 0, ref = this._xs.length; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
            xs = (function () {
                var l, len, ref1, results;
                ref1 = this._xs[i];
                results = [];
                for (l = 0, len = ref1.length; l < len; l++) {
                    x = ref1[l];
                    if (!types_1.isStrictNaN(x)) {
                        results.push(x);
                    }
                }
                return results;
            }).call(this);
            ys = (function () {
                var l, len, ref1, results;
                ref1 = this._ys[i];
                results = [];
                for (l = 0, len = ref1.length; l < len; l++) {
                    y = ref1[l];
                    if (!types_1.isStrictNaN(y)) {
                        results.push(y);
                    }
                }
                return results;
            }).call(this);
            if (xs.length === 0) {
                continue;
            }
            points.push({
                minX: array_1.min(xs),
                minY: array_1.min(ys),
                maxX: array_1.max(xs),
                maxY: array_1.max(ys),
                i: i
            });
        }
        return new spatial_1.RBush(points);
    };
    MultiLineView.prototype._render = function (ctx, indices, arg) {
        var i, j, k, l, len, ref, ref1, results, sx, sxs, sy, sys;
        sxs = arg.sxs, sys = arg.sys;
        results = [];
        for (k = 0, len = indices.length; k < len; k++) {
            i = indices[k];
            ref = [sxs[i], sys[i]], sx = ref[0], sy = ref[1];
            this.visuals.line.set_vectorize(ctx, i);
            for (j = l = 0, ref1 = sx.length; 0 <= ref1 ? l < ref1 : l > ref1; j = 0 <= ref1 ? ++l : --l) {
                if (j === 0) {
                    ctx.beginPath();
                    ctx.moveTo(sx[j], sy[j]);
                    continue;
                }
                else if (isNaN(sx[j]) || isNaN(sy[j])) {
                    ctx.stroke();
                    ctx.beginPath();
                    continue;
                }
                else {
                    ctx.lineTo(sx[j], sy[j]);
                }
            }
            results.push(ctx.stroke());
        }
        return results;
    };
    MultiLineView.prototype._hit_point = function (geometry) {
        var dist, hits, i, j, k, l, p0, p1, point, points, ref, ref1, ref2, result, shortest, threshold;
        result = hittest.create_hit_test_result();
        point = {
            x: this.renderer.plot_view.canvas.vx_to_sx(geometry.vx),
            y: this.renderer.plot_view.canvas.vy_to_sy(geometry.vy)
        };
        shortest = 9999;
        threshold = Math.max(2, this.visuals.line.line_width.value() / 2);
        hits = {};
        for (i = k = 0, ref = this.sxs.length; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
            points = null;
            for (j = l = 0, ref1 = this.sxs[i].length - 1; 0 <= ref1 ? l < ref1 : l > ref1; j = 0 <= ref1 ? ++l : --l) {
                ref2 = [
                    {
                        x: this.sxs[i][j],
                        y: this.sys[i][j]
                    }, {
                        x: this.sxs[i][j + 1],
                        y: this.sys[i][j + 1]
                    }
                ], p0 = ref2[0], p1 = ref2[1];
                dist = hittest.dist_to_segment(point, p0, p1);
                if (dist < threshold && dist < shortest) {
                    shortest = dist;
                    points = [j];
                }
            }
            if (points) {
                hits[i] = points;
            }
        }
        result['1d'].indices = Object.keys(hits);
        result['2d'].indices = hits;
        return result;
    };
    MultiLineView.prototype._hit_span = function (geometry) {
        var hits, i, j, k, l, points, ref, ref1, ref2, result, val, values, vx, vy;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        result = hittest.create_hit_test_result();
        if (geometry.direction === 'v') {
            val = this.renderer.ymapper.map_from_target(vy);
            values = this._ys;
        }
        else {
            val = this.renderer.xmapper.map_from_target(vx);
            values = this._xs;
        }
        hits = {};
        for (i = k = 0, ref1 = values.length; 0 <= ref1 ? k < ref1 : k > ref1; i = 0 <= ref1 ? ++k : --k) {
            points = [];
            for (j = l = 0, ref2 = values[i].length - 1; 0 <= ref2 ? l < ref2 : l > ref2; j = 0 <= ref2 ? ++l : --l) {
                if ((values[i][j] <= val && val <= values[i][j + 1])) {
                    points.push(j);
                }
            }
            if (points.length > 0) {
                hits[i] = points;
            }
        }
        result['1d'].indices = Object.keys(hits);
        result['2d'].indices = hits;
        return result;
    };
    MultiLineView.prototype.get_interpolation_hit = function (i, point_i, geometry) {
        var ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, res, vx, vy, x0, x1, x2, x3, y0, y1, y2, y3;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        ref1 = [this._xs[i][point_i], this._ys[i][point_i], this._xs[i][point_i + 1], this._ys[i][point_i + 1]], x2 = ref1[0], y2 = ref1[1], x3 = ref1[2], y3 = ref1[3];
        if (geometry.type === 'point') {
            ref2 = this.renderer.ymapper.v_map_from_target([vy - 1, vy + 1]), y0 = ref2[0], y1 = ref2[1];
            ref3 = this.renderer.xmapper.v_map_from_target([vx - 1, vx + 1]), x0 = ref3[0], x1 = ref3[1];
        }
        else {
            if (geometry.direction === 'v') {
                ref4 = this.renderer.ymapper.v_map_from_target([vy, vy]), y0 = ref4[0], y1 = ref4[1];
                ref5 = [x2, x3], x0 = ref5[0], x1 = ref5[1];
            }
            else {
                ref6 = this.renderer.xmapper.v_map_from_target([vx, vx]), x0 = ref6[0], x1 = ref6[1];
                ref7 = [y2, y3], y0 = ref7[0], y1 = ref7[1];
            }
        }
        res = hittest.check_2_segments_intersect(x0, y0, x1, y1, x2, y2, x3, y3);
        return [res.x, res.y];
    };
    MultiLineView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
    };
    return MultiLineView;
})(glyph_1.GlyphView);
exports.MultiLine = (function (superClass) {
    extend(MultiLine, superClass);
    function MultiLine() {
        return MultiLine.__super__.constructor.apply(this, arguments);
    }
    MultiLine.prototype.default_view = exports.MultiLineView;
    MultiLine.prototype.type = 'MultiLine';
    MultiLine.coords([['xs', 'ys']]);
    MultiLine.mixins(['line']);
    return MultiLine;
})(glyph_1.Glyph);

},{"./glyph":"models/glyphs/glyph","core/hittest":"core/hittest","core/util/array":"core/util/array","core/util/spatial":"core/util/spatial","core/util/types":"core/util/types"}],"models/glyphs/oval":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
var p = require("core/properties");
exports.OvalView = (function (superClass) {
    extend(OvalView, superClass);
    function OvalView() {
        return OvalView.__super__.constructor.apply(this, arguments);
    }
    OvalView.prototype._set_data = function () {
        this.max_w2 = 0;
        if (this.model.properties.width.units === "data") {
            this.max_w2 = this.max_width / 2;
        }
        this.max_h2 = 0;
        if (this.model.properties.height.units === "data") {
            return this.max_h2 = this.max_height / 2;
        }
    };
    OvalView.prototype._map_data = function () {
        if (this.model.properties.width.units === "data") {
            this.sw = this.sdist(this.renderer.xmapper, this._x, this._width, 'center');
        }
        else {
            this.sw = this._width;
        }
        if (this.model.properties.height.units === "data") {
            return this.sh = this.sdist(this.renderer.ymapper, this._y, this._height, 'center');
        }
        else {
            return this.sh = this._height;
        }
    };
    OvalView.prototype._render = function (ctx, indices, arg) {
        var i, j, len, results, sh, sw, sx, sy;
        sx = arg.sx, sy = arg.sy, sw = arg.sw, sh = arg.sh;
        results = [];
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (isNaN(sx[i] + sy[i] + sw[i] + sh[i] + this._angle[i])) {
                continue;
            }
            ctx.translate(sx[i], sy[i]);
            ctx.rotate(this._angle[i]);
            ctx.beginPath();
            ctx.moveTo(0, -sh[i] / 2);
            ctx.bezierCurveTo(sw[i] / 2, -sh[i] / 2, sw[i] / 2, sh[i] / 2, 0, sh[i] / 2);
            ctx.bezierCurveTo(-sw[i] / 2, sh[i] / 2, -sw[i] / 2, -sh[i] / 2, 0, -sh[i] / 2);
            ctx.closePath();
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                ctx.stroke();
            }
            ctx.rotate(-this._angle[i]);
            results.push(ctx.translate(-sx[i], -sy[i]));
        }
        return results;
    };
    OvalView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        var d, data, indices, scale, sh, sw, sx, sy;
        indices = [index];
        sx = {};
        sx[index] = (x0 + x1) / 2;
        sy = {};
        sy[index] = (y0 + y1) / 2;
        scale = this.sw[index] / this.sh[index];
        d = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.8;
        sw = {};
        sh = {};
        if (scale > 1) {
            sw[index] = d;
            sh[index] = d / scale;
        }
        else {
            sw[index] = d * scale;
            sh[index] = d;
        }
        data = {
            sx: sx,
            sy: sy,
            sw: sw,
            sh: sh
        };
        return this._render(ctx, indices, data);
    };
    OvalView.prototype._bounds = function (bds) {
        return this.max_wh2_bounds(bds);
    };
    return OvalView;
})(xy_glyph_1.XYGlyphView);
exports.Oval = (function (superClass) {
    extend(Oval, superClass);
    function Oval() {
        return Oval.__super__.constructor.apply(this, arguments);
    }
    Oval.prototype.default_view = exports.OvalView;
    Oval.prototype.type = 'Oval';
    Oval.mixins(['line', 'fill']);
    Oval.define({
        angle: [p.AngleSpec, 0.0],
        width: [p.DistanceSpec],
        height: [p.DistanceSpec]
    });
    return Oval;
})(xy_glyph_1.XYGlyph);

},{"./xy_glyph":"models/glyphs/xy_glyph","core/properties":"core/properties"}],"models/glyphs/patch":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
exports.PatchView = (function (superClass) {
    extend(PatchView, superClass);
    function PatchView() {
        return PatchView.__super__.constructor.apply(this, arguments);
    }
    PatchView.prototype._render = function (ctx, indices, arg) {
        var i, j, k, len, len1, sx, sy;
        sx = arg.sx, sy = arg.sy;
        if (this.visuals.fill.doit) {
            this.visuals.fill.set_value(ctx);
            for (j = 0, len = indices.length; j < len; j++) {
                i = indices[j];
                if (i === 0) {
                    ctx.beginPath();
                    ctx.moveTo(sx[i], sy[i]);
                    continue;
                }
                else if (isNaN(sx[i] + sy[i])) {
                    ctx.closePath();
                    ctx.fill();
                    ctx.beginPath();
                    continue;
                }
                else {
                    ctx.lineTo(sx[i], sy[i]);
                }
            }
            ctx.closePath();
            ctx.fill();
        }
        if (this.visuals.line.doit) {
            this.visuals.line.set_value(ctx);
            for (k = 0, len1 = indices.length; k < len1; k++) {
                i = indices[k];
                if (i === 0) {
                    ctx.beginPath();
                    ctx.moveTo(sx[i], sy[i]);
                    continue;
                }
                else if (isNaN(sx[i] + sy[i])) {
                    ctx.closePath();
                    ctx.stroke();
                    ctx.beginPath();
                    continue;
                }
                else {
                    ctx.lineTo(sx[i], sy[i]);
                }
            }
            ctx.closePath();
            return ctx.stroke();
        }
    };
    PatchView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
    };
    return PatchView;
})(xy_glyph_1.XYGlyphView);
exports.Patch = (function (superClass) {
    extend(Patch, superClass);
    function Patch() {
        return Patch.__super__.constructor.apply(this, arguments);
    }
    Patch.prototype.default_view = exports.PatchView;
    Patch.prototype.type = 'Patch';
    Patch.mixins(['line', 'fill']);
    return Patch;
})(xy_glyph_1.XYGlyph);

},{"./xy_glyph":"models/glyphs/xy_glyph"}],"models/glyphs/patches":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var spatial_1 = require("core/util/spatial");
var glyph_1 = require("./glyph");
var array_1 = require("core/util/array");
var types_1 = require("core/util/types");
var hittest = require("core/hittest");
exports.PatchesView = (function (superClass) {
    extend(PatchesView, superClass);
    function PatchesView() {
        return PatchesView.__super__.constructor.apply(this, arguments);
    }
    PatchesView.prototype._build_discontinuous_object = function (nanned_qs) {
        var denanned, ds, i, k, nan_index, q, qs, qs_part, ref;
        ds = {};
        for (i = k = 0, ref = nanned_qs.length; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
            ds[i] = [];
            qs = array_1.copy(nanned_qs[i]);
            while (qs.length > 0) {
                nan_index = array_1.findLastIndex(qs, function (q) {
                    return types_1.isStrictNaN(q);
                });
                if (nan_index >= 0) {
                    qs_part = qs.splice(nan_index);
                }
                else {
                    qs_part = qs;
                    qs = [];
                }
                denanned = (function () {
                    var l, len, results;
                    results = [];
                    for (l = 0, len = qs_part.length; l < len; l++) {
                        q = qs_part[l];
                        if (!types_1.isStrictNaN(q)) {
                            results.push(q);
                        }
                    }
                    return results;
                })();
                ds[i].push(denanned);
            }
        }
        return ds;
    };
    PatchesView.prototype._index_data = function () {
        var i, j, k, l, points, ref, ref1, xs, xss, ys, yss;
        xss = this._build_discontinuous_object(this._xs);
        yss = this._build_discontinuous_object(this._ys);
        points = [];
        for (i = k = 0, ref = this._xs.length; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
            for (j = l = 0, ref1 = xss[i].length; 0 <= ref1 ? l < ref1 : l > ref1; j = 0 <= ref1 ? ++l : --l) {
                xs = xss[i][j];
                ys = yss[i][j];
                if (xs.length === 0) {
                    continue;
                }
                points.push({
                    minX: array_1.min(xs),
                    minY: array_1.min(ys),
                    maxX: array_1.max(xs),
                    maxY: array_1.max(ys),
                    i: i
                });
            }
        }
        return new spatial_1.RBush(points);
    };
    PatchesView.prototype._mask_data = function (all_indices) {
        var bbox, ref, ref1, x0, x1, xr, y0, y1, yr;
        xr = this.renderer.plot_view.x_range;
        ref = [xr.min, xr.max], x0 = ref[0], x1 = ref[1];
        yr = this.renderer.plot_view.y_range;
        ref1 = [yr.min, yr.max], y0 = ref1[0], y1 = ref1[1];
        bbox = hittest.validate_bbox_coords([x0, x1], [y0, y1]);
        return this.index.indices(bbox);
    };
    PatchesView.prototype._render = function (ctx, indices, arg) {
        var i, j, k, l, len, m, ref, ref1, ref2, results, sx, sxs, sy, sys;
        sxs = arg.sxs, sys = arg.sys;
        this.renderer.sxss = this._build_discontinuous_object(sxs);
        this.renderer.syss = this._build_discontinuous_object(sys);
        results = [];
        for (k = 0, len = indices.length; k < len; k++) {
            i = indices[k];
            ref = [sxs[i], sys[i]], sx = ref[0], sy = ref[1];
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                for (j = l = 0, ref1 = sx.length; 0 <= ref1 ? l < ref1 : l > ref1; j = 0 <= ref1 ? ++l : --l) {
                    if (j === 0) {
                        ctx.beginPath();
                        ctx.moveTo(sx[j], sy[j]);
                        continue;
                    }
                    else if (isNaN(sx[j] + sy[j])) {
                        ctx.closePath();
                        ctx.fill();
                        ctx.beginPath();
                        continue;
                    }
                    else {
                        ctx.lineTo(sx[j], sy[j]);
                    }
                }
                ctx.closePath();
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                for (j = m = 0, ref2 = sx.length; 0 <= ref2 ? m < ref2 : m > ref2; j = 0 <= ref2 ? ++m : --m) {
                    if (j === 0) {
                        ctx.beginPath();
                        ctx.moveTo(sx[j], sy[j]);
                        continue;
                    }
                    else if (isNaN(sx[j] + sy[j])) {
                        ctx.closePath();
                        ctx.stroke();
                        ctx.beginPath();
                        continue;
                    }
                    else {
                        ctx.lineTo(sx[j], sy[j]);
                    }
                }
                ctx.closePath();
                results.push(ctx.stroke());
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    PatchesView.prototype._hit_point = function (geometry) {
        var candidates, hits, i, idx, j, k, l, ref, ref1, ref2, result, sx, sxs, sy, sys, vx, vy, x, y;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        sx = this.renderer.plot_view.canvas.vx_to_sx(vx);
        sy = this.renderer.plot_view.canvas.vy_to_sy(vy);
        x = this.renderer.xmapper.map_from_target(vx, true);
        y = this.renderer.ymapper.map_from_target(vy, true);
        candidates = this.index.indices({
            minX: x,
            minY: y,
            maxX: x,
            maxY: y
        });
        hits = [];
        for (i = k = 0, ref1 = candidates.length; 0 <= ref1 ? k < ref1 : k > ref1; i = 0 <= ref1 ? ++k : --k) {
            idx = candidates[i];
            sxs = this.renderer.sxss[idx];
            sys = this.renderer.syss[idx];
            for (j = l = 0, ref2 = sxs.length; 0 <= ref2 ? l < ref2 : l > ref2; j = 0 <= ref2 ? ++l : --l) {
                if (hittest.point_in_poly(sx, sy, sxs[j], sys[j])) {
                    hits.push(idx);
                }
            }
        }
        result = hittest.create_hit_test_result();
        result['1d'].indices = hits;
        return result;
    };
    PatchesView.prototype._get_snap_coord = function (array) {
        var k, len, s, sum;
        sum = 0;
        for (k = 0, len = array.length; k < len; k++) {
            s = array[k];
            sum += s;
        }
        return sum / array.length;
    };
    PatchesView.prototype.scx = function (i, sx, sy) {
        var j, k, ref, sxs, sys;
        if (this.renderer.sxss[i].length === 1) {
            return this._get_snap_coord(this.sxs[i]);
        }
        else {
            sxs = this.renderer.sxss[i];
            sys = this.renderer.syss[i];
            for (j = k = 0, ref = sxs.length; 0 <= ref ? k < ref : k > ref; j = 0 <= ref ? ++k : --k) {
                if (hittest.point_in_poly(sx, sy, sxs[j], sys[j])) {
                    return this._get_snap_coord(sxs[j]);
                }
            }
        }
        return null;
    };
    PatchesView.prototype.scy = function (i, sx, sy) {
        var j, k, ref, sxs, sys;
        if (this.renderer.syss[i].length === 1) {
            return this._get_snap_coord(this.sys[i]);
        }
        else {
            sxs = this.renderer.sxss[i];
            sys = this.renderer.syss[i];
            for (j = k = 0, ref = sxs.length; 0 <= ref ? k < ref : k > ref; j = 0 <= ref ? ++k : --k) {
                if (hittest.point_in_poly(sx, sy, sxs[j], sys[j])) {
                    return this._get_snap_coord(sys[j]);
                }
            }
        }
    };
    PatchesView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
    };
    return PatchesView;
})(glyph_1.GlyphView);
exports.Patches = (function (superClass) {
    extend(Patches, superClass);
    function Patches() {
        return Patches.__super__.constructor.apply(this, arguments);
    }
    Patches.prototype.default_view = exports.PatchesView;
    Patches.prototype.type = 'Patches';
    Patches.coords([['xs', 'ys']]);
    Patches.mixins(['line', 'fill']);
    return Patches;
})(glyph_1.Glyph);

},{"./glyph":"models/glyphs/glyph","core/hittest":"core/hittest","core/util/array":"core/util/array","core/util/spatial":"core/util/spatial","core/util/types":"core/util/types"}],"models/glyphs/quad":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var spatial_1 = require("core/util/spatial");
var glyph_1 = require("./glyph");
var categorical_mapper_1 = require("../mappers/categorical_mapper");
var hittest = require("core/hittest");
exports.QuadView = (function (superClass) {
    extend(QuadView, superClass);
    function QuadView() {
        return QuadView.__super__.constructor.apply(this, arguments);
    }
    QuadView.prototype._index_data = function () {
        var b, bottom, i, j, l, left, map_to_synthetic, points, r, ref, right, t, top;
        map_to_synthetic = function (mapper, array) {
            if (mapper instanceof categorical_mapper_1.CategoricalMapper) {
                return mapper.v_map_to_target(array, true);
            }
            else {
                return array;
            }
        };
        left = map_to_synthetic(this.renderer.xmapper, this._left);
        right = map_to_synthetic(this.renderer.xmapper, this._right);
        top = map_to_synthetic(this.renderer.ymapper, this._top);
        bottom = map_to_synthetic(this.renderer.ymapper, this._bottom);
        points = [];
        for (i = j = 0, ref = left.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            l = left[i];
            r = right[i];
            t = top[i];
            b = bottom[i];
            if (isNaN(l + r + t + b) || !isFinite(l + r + t + b)) {
                continue;
            }
            points.push({
                minX: l,
                minY: b,
                maxX: r,
                maxY: t,
                i: i
            });
        }
        return new spatial_1.RBush(points);
    };
    QuadView.prototype._render = function (ctx, indices, arg) {
        var i, j, len, results, sbottom, sleft, sright, stop;
        sleft = arg.sleft, sright = arg.sright, stop = arg.stop, sbottom = arg.sbottom;
        results = [];
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (isNaN(sleft[i] + stop[i] + sright[i] + sbottom[i])) {
                continue;
            }
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                ctx.fillRect(sleft[i], stop[i], sright[i] - sleft[i], sbottom[i] - stop[i]);
            }
            if (this.visuals.line.doit) {
                ctx.beginPath();
                ctx.rect(sleft[i], stop[i], sright[i] - sleft[i], sbottom[i] - stop[i]);
                this.visuals.line.set_vectorize(ctx, i);
                results.push(ctx.stroke());
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    QuadView.prototype._hit_point = function (geometry) {
        var hits, ref, result, vx, vy, x, y;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        x = this.renderer.xmapper.map_from_target(vx, true);
        y = this.renderer.ymapper.map_from_target(vy, true);
        hits = this.index.indices({
            minX: x,
            minY: y,
            maxX: x,
            maxY: y
        });
        result = hittest.create_hit_test_result();
        result['1d'].indices = hits;
        return result;
    };
    QuadView.prototype.get_anchor_point = function (anchor, i, spt) {
        var bottom, left, right, top;
        left = Math.min(this.sleft[i], this.sright[i]);
        right = Math.max(this.sright[i], this.sleft[i]);
        top = Math.min(this.stop[i], this.sbottom[i]);
        bottom = Math.max(this.sbottom[i], this.stop[i]);
        switch (anchor) {
            case 'top_left':
                return {
                    x: left,
                    y: top
                };
            case 'top_center':
                return {
                    x: (left + right) / 2,
                    y: top
                };
            case 'top_right':
                return {
                    x: right,
                    y: top
                };
            case 'center_right':
                return {
                    x: right,
                    y: (top + bottom) / 2
                };
            case 'bottom_right':
                return {
                    x: right,
                    y: bottom
                };
            case 'bottom_center':
                return {
                    x: (left + right) / 2,
                    y: bottom
                };
            case 'bottom_left':
                return {
                    x: left,
                    y: bottom
                };
            case 'center_left':
                return {
                    x: left,
                    y: (top + bottom) / 2
                };
            case 'center':
                return {
                    x: (left + right) / 2,
                    y: (top + bottom) / 2
                };
        }
    };
    QuadView.prototype.scx = function (i) {
        return (this.sleft[i] + this.sright[i]) / 2;
    };
    QuadView.prototype.scy = function (i) {
        return (this.stop[i] + this.sbottom[i]) / 2;
    };
    QuadView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
    };
    return QuadView;
})(glyph_1.GlyphView);
exports.Quad = (function (superClass) {
    extend(Quad, superClass);
    function Quad() {
        return Quad.__super__.constructor.apply(this, arguments);
    }
    Quad.prototype.default_view = exports.QuadView;
    Quad.prototype.type = 'Quad';
    Quad.coords([['right', 'bottom'], ['left', 'top']]);
    Quad.mixins(['line', 'fill']);
    return Quad;
})(glyph_1.Glyph);

},{"../mappers/categorical_mapper":"models/mappers/categorical_mapper","./glyph":"models/glyphs/glyph","core/hittest":"core/hittest","core/util/spatial":"core/util/spatial"}],"models/glyphs/quadratic":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var _qbb, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var spatial_1 = require("core/util/spatial");
var glyph_1 = require("./glyph");
_qbb = function (u, v, w) {
    var bd, t;
    if (v === (u + w) / 2) {
        return [u, w];
    }
    else {
        t = (u - v) / (u - 2 * v + w);
        bd = u * Math.pow(1 - t, 2) + 2 * v * (1 - t) * t + w * Math.pow(t, 2);
        return [Math.min(u, w, bd), Math.max(u, w, bd)];
    }
};
exports.QuadraticView = (function (superClass) {
    extend(QuadraticView, superClass);
    function QuadraticView() {
        return QuadraticView.__super__.constructor.apply(this, arguments);
    }
    QuadraticView.prototype._index_data = function () {
        var i, j, points, ref, ref1, ref2, x0, x1, y0, y1;
        points = [];
        for (i = j = 0, ref = this._x0.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            if (isNaN(this._x0[i] + this._x1[i] + this._y0[i] + this._y1[i] + this._cx[i] + this._cy[i])) {
                continue;
            }
            ref1 = _qbb(this._x0[i], this._cx[i], this._x1[i]), x0 = ref1[0], x1 = ref1[1];
            ref2 = _qbb(this._y0[i], this._cy[i], this._y1[i]), y0 = ref2[0], y1 = ref2[1];
            points.push({
                minX: x0,
                minY: y0,
                maxX: x1,
                maxY: y1,
                i: i
            });
        }
        return new spatial_1.RBush(points);
    };
    QuadraticView.prototype._render = function (ctx, indices, arg) {
        var i, j, len, results, scx, scy, sx0, sx1, sy0, sy1;
        sx0 = arg.sx0, sy0 = arg.sy0, sx1 = arg.sx1, sy1 = arg.sy1, scx = arg.scx, scy = arg.scy;
        if (this.visuals.line.doit) {
            results = [];
            for (j = 0, len = indices.length; j < len; j++) {
                i = indices[j];
                if (isNaN(sx0[i] + sy0[i] + sx1[i] + sy1[i] + scx[i] + scy[i])) {
                    continue;
                }
                ctx.beginPath();
                ctx.moveTo(sx0[i], sy0[i]);
                ctx.quadraticCurveTo(scx[i], scy[i], sx1[i], sy1[i]);
                this.visuals.line.set_vectorize(ctx, i);
                results.push(ctx.stroke());
            }
            return results;
        }
    };
    QuadraticView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
    };
    return QuadraticView;
})(glyph_1.GlyphView);
exports.Quadratic = (function (superClass) {
    extend(Quadratic, superClass);
    function Quadratic() {
        return Quadratic.__super__.constructor.apply(this, arguments);
    }
    Quadratic.prototype.default_view = exports.QuadraticView;
    Quadratic.prototype.type = 'Quadratic';
    Quadratic.coords([['x0', 'y0'], ['x1', 'y1'], ['cx', 'cy']]);
    Quadratic.mixins(['line']);
    return Quadratic;
})(glyph_1.Glyph);

},{"./glyph":"models/glyphs/glyph","core/util/spatial":"core/util/spatial"}],"models/glyphs/ray":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
var p = require("core/properties");
exports.RayView = (function (superClass) {
    extend(RayView, superClass);
    function RayView() {
        return RayView.__super__.constructor.apply(this, arguments);
    }
    RayView.prototype._map_data = function () {
        return this.slength = this.sdist(this.renderer.xmapper, this._x, this._length);
    };
    RayView.prototype._render = function (ctx, indices, arg) {
        var _angle, height, i, inf_len, j, k, len, ref, results, slength, sx, sy, width;
        sx = arg.sx, sy = arg.sy, slength = arg.slength, _angle = arg._angle;
        if (this.visuals.line.doit) {
            width = this.renderer.plot_view.frame.width;
            height = this.renderer.plot_view.frame.height;
            inf_len = 2 * (width + height);
            for (i = j = 0, ref = slength.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                if (slength[i] === 0) {
                    slength[i] = inf_len;
                }
            }
            results = [];
            for (k = 0, len = indices.length; k < len; k++) {
                i = indices[k];
                if (isNaN(sx[i] + sy[i] + _angle[i] + slength[i])) {
                    continue;
                }
                ctx.translate(sx[i], sy[i]);
                ctx.rotate(_angle[i]);
                ctx.beginPath();
                ctx.moveTo(0, 0);
                ctx.lineTo(slength[i], 0);
                this.visuals.line.set_vectorize(ctx, i);
                ctx.stroke();
                ctx.rotate(-_angle[i]);
                results.push(ctx.translate(-sx[i], -sy[i]));
            }
            return results;
        }
    };
    RayView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
    };
    return RayView;
})(xy_glyph_1.XYGlyphView);
exports.Ray = (function (superClass) {
    extend(Ray, superClass);
    function Ray() {
        return Ray.__super__.constructor.apply(this, arguments);
    }
    Ray.prototype.default_view = exports.RayView;
    Ray.prototype.type = 'Ray';
    Ray.mixins(['line']);
    Ray.define({
        length: [p.DistanceSpec],
        angle: [p.AngleSpec]
    });
    return Ray;
})(xy_glyph_1.XYGlyph);

},{"./xy_glyph":"models/glyphs/xy_glyph","core/properties":"core/properties"}],"models/glyphs/rect":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
var hittest = require("core/hittest");
var p = require("core/properties");
var array_1 = require("core/util/array");
var types_1 = require("core/util/types");
var categorical_mapper_1 = require("../mappers/categorical_mapper");
exports.RectView = (function (superClass) {
    extend(RectView, superClass);
    function RectView() {
        return RectView.__super__.constructor.apply(this, arguments);
    }
    RectView.prototype._set_data = function () {
        this.max_w2 = 0;
        if (this.model.properties.width.units === "data") {
            this.max_w2 = this.max_width / 2;
        }
        this.max_h2 = 0;
        if (this.model.properties.height.units === "data") {
            return this.max_h2 = this.max_height / 2;
        }
    };
    RectView.prototype._map_data = function () {
        var canvas, i, ref, ref1;
        canvas = this.renderer.plot_view.canvas;
        if (this.model.properties.width.units === "data") {
            ref = this._map_dist_corner_for_data_side_length(this._x, this._width, this.renderer.xmapper, canvas, 0), this.sw = ref[0], this.sx0 = ref[1];
        }
        else {
            this.sw = this._width;
            this.sx0 = (function () {
                var j, ref1, results;
                results = [];
                for (i = j = 0, ref1 = this.sx.length; 0 <= ref1 ? j < ref1 : j > ref1; i = 0 <= ref1 ? ++j : --j) {
                    results.push(this.sx[i] - this.sw[i] / 2);
                }
                return results;
            }).call(this);
        }
        if (this.model.properties.height.units === "data") {
            ref1 = this._map_dist_corner_for_data_side_length(this._y, this._height, this.renderer.ymapper, canvas, 1), this.sh = ref1[0], this.sy1 = ref1[1];
        }
        else {
            this.sh = this._height;
            this.sy1 = (function () {
                var j, ref2, results;
                results = [];
                for (i = j = 0, ref2 = this.sy.length; 0 <= ref2 ? j < ref2 : j > ref2; i = 0 <= ref2 ? ++j : --j) {
                    results.push(this.sy[i] - this.sh[i] / 2);
                }
                return results;
            }).call(this);
        }
        return this.ssemi_diag = (function () {
            var j, ref2, results;
            results = [];
            for (i = j = 0, ref2 = this.sw.length; 0 <= ref2 ? j < ref2 : j > ref2; i = 0 <= ref2 ? ++j : --j) {
                results.push(Math.sqrt(this.sw[i] / 2 * this.sw[i] / 2 + this.sh[i] / 2 * this.sh[i] / 2));
            }
            return results;
        }).call(this);
    };
    RectView.prototype._render = function (ctx, indices, arg) {
        var _angle, i, j, k, len, len1, sh, sw, sx, sx0, sy, sy1;
        sx = arg.sx, sy = arg.sy, sx0 = arg.sx0, sy1 = arg.sy1, sw = arg.sw, sh = arg.sh, _angle = arg._angle;
        if (this.visuals.fill.doit) {
            for (j = 0, len = indices.length; j < len; j++) {
                i = indices[j];
                if (isNaN(sx[i] + sy[i] + sx0[i] + sy1[i] + sw[i] + sh[i] + _angle[i])) {
                    continue;
                }
                this.visuals.fill.set_vectorize(ctx, i);
                if (_angle[i]) {
                    ctx.translate(sx[i], sy[i]);
                    ctx.rotate(_angle[i]);
                    ctx.fillRect(-sw[i] / 2, -sh[i] / 2, sw[i], sh[i]);
                    ctx.rotate(-_angle[i]);
                    ctx.translate(-sx[i], -sy[i]);
                }
                else {
                    ctx.fillRect(sx0[i], sy1[i], sw[i], sh[i]);
                }
            }
        }
        if (this.visuals.line.doit) {
            ctx.beginPath();
            for (k = 0, len1 = indices.length; k < len1; k++) {
                i = indices[k];
                if (isNaN(sx[i] + sy[i] + sx0[i] + sy1[i] + sw[i] + sh[i] + _angle[i])) {
                    continue;
                }
                if (sw[i] === 0 || sh[i] === 0) {
                    continue;
                }
                if (_angle[i]) {
                    ctx.translate(sx[i], sy[i]);
                    ctx.rotate(_angle[i]);
                    ctx.rect(-sw[i] / 2, -sh[i] / 2, sw[i], sh[i]);
                    ctx.rotate(-_angle[i]);
                    ctx.translate(-sx[i], -sy[i]);
                }
                else {
                    ctx.rect(sx0[i], sy1[i], sw[i], sh[i]);
                }
                this.visuals.line.set_vectorize(ctx, i);
                ctx.stroke();
                ctx.beginPath();
            }
            return ctx.stroke();
        }
    };
    RectView.prototype._hit_rect = function (geometry) {
        var bbox, ref, ref1, result, x0, x1, y0, y1;
        ref = this.renderer.xmapper.v_map_from_target([geometry.vx0, geometry.vx1], true), x0 = ref[0], x1 = ref[1];
        ref1 = this.renderer.ymapper.v_map_from_target([geometry.vy0, geometry.vy1], true), y0 = ref1[0], y1 = ref1[1];
        bbox = hittest.validate_bbox_coords([x0, x1], [y0, y1]);
        result = hittest.create_hit_test_result();
        result['1d'].indices = this.index.indices(bbox);
        return result;
    };
    RectView.prototype._hit_point = function (geometry) {
        var bbox, c, d, height_in, hits, i, j, len, max_x2_ddist, max_y2_ddist, px, py, ref, ref1, result, s, scenter_x, scenter_y, sx, sy, vx, vy, width_in, x, x0, x1, y, y0, y1;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        x = this.renderer.xmapper.map_from_target(vx, true);
        y = this.renderer.ymapper.map_from_target(vy, true);
        scenter_x = (function () {
            var j, ref1, results;
            results = [];
            for (i = j = 0, ref1 = this.sx0.length; 0 <= ref1 ? j < ref1 : j > ref1; i = 0 <= ref1 ? ++j : --j) {
                results.push(this.sx0[i] + this.sw[i] / 2);
            }
            return results;
        }).call(this);
        scenter_y = (function () {
            var j, ref1, results;
            results = [];
            for (i = j = 0, ref1 = this.sy1.length; 0 <= ref1 ? j < ref1 : j > ref1; i = 0 <= ref1 ? ++j : --j) {
                results.push(this.sy1[i] + this.sh[i] / 2);
            }
            return results;
        }).call(this);
        max_x2_ddist = array_1.max(this._ddist(0, scenter_x, this.ssemi_diag));
        max_y2_ddist = array_1.max(this._ddist(1, scenter_y, this.ssemi_diag));
        x0 = x - max_x2_ddist;
        x1 = x + max_x2_ddist;
        y0 = y - max_y2_ddist;
        y1 = y + max_y2_ddist;
        hits = [];
        bbox = hittest.validate_bbox_coords([x0, x1], [y0, y1]);
        ref1 = this.index.indices(bbox);
        for (j = 0, len = ref1.length; j < len; j++) {
            i = ref1[j];
            sx = this.renderer.plot_view.canvas.vx_to_sx(vx);
            sy = this.renderer.plot_view.canvas.vy_to_sy(vy);
            if (this._angle[i]) {
                d = Math.sqrt(Math.pow(sx - this.sx[i], 2) + Math.pow(sy - this.sy[i], 2));
                s = Math.sin(-this._angle[i]);
                c = Math.cos(-this._angle[i]);
                px = c * (sx - this.sx[i]) - s * (sy - this.sy[i]) + this.sx[i];
                py = s * (sx - this.sx[i]) + c * (sy - this.sy[i]) + this.sy[i];
                sx = px;
                sy = py;
                width_in = Math.abs(this.sx[i] - sx) <= this.sw[i] / 2;
                height_in = Math.abs(this.sy[i] - sy) <= this.sh[i] / 2;
            }
            else {
                width_in = sx - this.sx0[i] <= this.sw[i] && sx - this.sx0[i] >= 0;
                height_in = sy - this.sy1[i] <= this.sh[i] && sy - this.sy1[i] >= 0;
            }
            if (height_in && width_in) {
                hits.push(i);
            }
        }
        result = hittest.create_hit_test_result();
        result['1d'].indices = hits;
        return result;
    };
    RectView.prototype._map_dist_corner_for_data_side_length = function (coord, side_length, mapper, canvas, dim) {
        var i, pt0, pt1, return_synthetic, sside_length, synthetic_pt, synthetic_pt_corner, vpt0, vpt1, vpt_corner;
        if (types_1.isString(coord[0]) && mapper instanceof categorical_mapper_1.CategoricalMapper) {
            return_synthetic = true;
            synthetic_pt = mapper.v_map_to_target(coord, return_synthetic);
            if (dim === 0) {
                synthetic_pt_corner = (function () {
                    var j, ref, results;
                    results = [];
                    for (i = j = 0, ref = coord.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                        results.push(synthetic_pt[i] - side_length[i] / 2);
                    }
                    return results;
                })();
            }
            else if (dim === 1) {
                synthetic_pt_corner = (function () {
                    var j, ref, results;
                    results = [];
                    for (i = j = 0, ref = coord.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                        results.push(synthetic_pt[i] + side_length[i] / 2);
                    }
                    return results;
                })();
            }
            vpt_corner = mapper.v_map_to_target(synthetic_pt_corner);
            sside_length = this.sdist(mapper, coord, side_length, 'center', this.model.dilate);
        }
        else {
            pt0 = (function () {
                var j, ref, results;
                results = [];
                for (i = j = 0, ref = coord.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                    results.push(Number(coord[i]) - side_length[i] / 2);
                }
                return results;
            })();
            pt1 = (function () {
                var j, ref, results;
                results = [];
                for (i = j = 0, ref = coord.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                    results.push(Number(coord[i]) + side_length[i] / 2);
                }
                return results;
            })();
            vpt0 = mapper.v_map_to_target(pt0);
            vpt1 = mapper.v_map_to_target(pt1);
            sside_length = this.sdist(mapper, pt0, side_length, 'edge', this.model.dilate);
            if (dim === 0) {
                vpt_corner = vpt0[0] < vpt1[0] ? vpt0 : vpt1;
            }
            else if (dim === 1) {
                vpt_corner = vpt0[0] < vpt1[0] ? vpt1 : vpt0;
            }
        }
        if (dim === 0) {
            return [sside_length, canvas.v_vx_to_sx(vpt_corner)];
        }
        else if (dim === 1) {
            return [sside_length, canvas.v_vy_to_sy(vpt_corner)];
        }
    };
    RectView.prototype._ddist = function (dim, spts, spans) {
        var i, mapper, pt0, pt1, vpt0, vpt1, vpts;
        if (dim === 0) {
            vpts = this.renderer.plot_view.canvas.v_sx_to_vx(spts);
            mapper = this.renderer.xmapper;
        }
        else {
            vpts = this.renderer.plot_view.canvas.v_vy_to_sy(spts);
            mapper = this.renderer.ymapper;
        }
        vpt0 = vpts;
        vpt1 = (function () {
            var j, ref, results;
            results = [];
            for (i = j = 0, ref = vpt0.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                results.push(vpt0[i] + spans[i]);
            }
            return results;
        })();
        pt0 = mapper.v_map_from_target(vpt0);
        pt1 = mapper.v_map_from_target(vpt1);
        return (function () {
            var j, ref, results;
            results = [];
            for (i = j = 0, ref = pt0.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                results.push(Math.abs(pt1[i] - pt0[i]));
            }
            return results;
        })();
    };
    RectView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
    };
    RectView.prototype._bounds = function (bds) {
        return this.max_wh2_bounds(bds);
    };
    return RectView;
})(xy_glyph_1.XYGlyphView);
exports.Rect = (function (superClass) {
    extend(Rect, superClass);
    function Rect() {
        return Rect.__super__.constructor.apply(this, arguments);
    }
    Rect.prototype.default_view = exports.RectView;
    Rect.prototype.type = 'Rect';
    Rect.mixins(['line', 'fill']);
    Rect.define({
        angle: [p.AngleSpec, 0],
        width: [p.DistanceSpec],
        height: [p.DistanceSpec],
        dilate: [p.Bool, false]
    });
    return Rect;
})(xy_glyph_1.XYGlyph);

},{"../mappers/categorical_mapper":"models/mappers/categorical_mapper","./xy_glyph":"models/glyphs/xy_glyph","core/hittest":"core/hittest","core/properties":"core/properties","core/util/array":"core/util/array","core/util/types":"core/util/types"}],"models/glyphs/segment":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var spatial_1 = require("core/util/spatial");
var glyph_1 = require("./glyph");
exports.SegmentView = (function (superClass) {
    extend(SegmentView, superClass);
    function SegmentView() {
        return SegmentView.__super__.constructor.apply(this, arguments);
    }
    SegmentView.prototype._index_data = function () {
        var i, j, points, ref;
        points = [];
        for (i = j = 0, ref = this._x0.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            if (!isNaN(this._x0[i] + this._x1[i] + this._y0[i] + this._y1[i])) {
                points.push({
                    minX: Math.min(this._x0[i], this._x1[i]),
                    minY: Math.min(this._y0[i], this._y1[i]),
                    maxX: Math.max(this._x0[i], this._x1[i]),
                    maxY: Math.max(this._y0[i], this._y1[i]),
                    i: i
                });
            }
        }
        return new spatial_1.RBush(points);
    };
    SegmentView.prototype._render = function (ctx, indices, arg) {
        var i, j, len, results, sx0, sx1, sy0, sy1;
        sx0 = arg.sx0, sy0 = arg.sy0, sx1 = arg.sx1, sy1 = arg.sy1;
        if (this.visuals.line.doit) {
            results = [];
            for (j = 0, len = indices.length; j < len; j++) {
                i = indices[j];
                if (isNaN(sx0[i] + sy0[i] + sx1[i] + sy1[i])) {
                    continue;
                }
                ctx.beginPath();
                ctx.moveTo(sx0[i], sy0[i]);
                ctx.lineTo(sx1[i], sy1[i]);
                this.visuals.line.set_vectorize(ctx, i);
                results.push(ctx.stroke());
            }
            return results;
        }
    };
    SegmentView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
    };
    return SegmentView;
})(glyph_1.GlyphView);
exports.Segment = (function (superClass) {
    extend(Segment, superClass);
    function Segment() {
        return Segment.__super__.constructor.apply(this, arguments);
    }
    Segment.prototype.default_view = exports.SegmentView;
    Segment.prototype.type = 'Segment';
    Segment.coords([['x0', 'y0'], ['x1', 'y1']]);
    Segment.mixins(['line']);
    return Segment;
})(glyph_1.Glyph);

},{"./glyph":"models/glyphs/glyph","core/util/spatial":"core/util/spatial"}],"models/glyphs/text":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
var p = require("core/properties");
exports.TextView = (function (superClass) {
    extend(TextView, superClass);
    function TextView() {
        return TextView.__super__.constructor.apply(this, arguments);
    }
    TextView.prototype._render = function (ctx, indices, arg) {
        var _angle, _text, _x_offset, _y_offset, i, j, len, results, sx, sy;
        sx = arg.sx, sy = arg.sy, _x_offset = arg._x_offset, _y_offset = arg._y_offset, _angle = arg._angle, _text = arg._text;
        results = [];
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (isNaN(sx[i] + sy[i] + _x_offset[i] + _y_offset[i] + _angle[i]) || (_text[i] == null)) {
                continue;
            }
            if (this.visuals.text.doit) {
                ctx.save();
                ctx.translate(sx[i] + _x_offset[i], sy[i] + _y_offset[i]);
                ctx.rotate(_angle[i]);
                this.visuals.text.set_vectorize(ctx, i);
                ctx.fillText(_text[i], 0, 0);
                results.push(ctx.restore());
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    TextView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        ctx.save();
        this.text_props.set_value(ctx);
        ctx.font = this.text_props.font_value();
        ctx.font = ctx.font.replace(/\b[\d\.]+[\w]+\b/, '10pt');
        ctx.textAlign = "right";
        ctx.textBaseline = "middle";
        ctx.fillText("text", x2, (y1 + y2) / 2);
        return ctx.restore();
    };
    return TextView;
})(xy_glyph_1.XYGlyphView);
exports.Text = (function (superClass) {
    extend(Text, superClass);
    function Text() {
        return Text.__super__.constructor.apply(this, arguments);
    }
    Text.prototype.default_view = exports.TextView;
    Text.prototype.type = 'Text';
    Text.mixins(['text']);
    Text.define({
        text: [
            p.StringSpec, {
                field: "text"
            }
        ],
        angle: [p.AngleSpec, 0],
        x_offset: [p.NumberSpec, 0],
        y_offset: [p.NumberSpec, 0]
    });
    return Text;
})(xy_glyph_1.XYGlyph);

},{"./xy_glyph":"models/glyphs/xy_glyph","core/properties":"core/properties"}],"models/glyphs/vbar":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var spatial_1 = require("core/util/spatial");
var glyph_1 = require("./glyph");
var categorical_mapper_1 = require("../mappers/categorical_mapper");
var hittest = require("core/hittest");
var p = require("core/properties");
exports.VBarView = (function (superClass) {
    extend(VBarView, superClass);
    function VBarView() {
        return VBarView.__super__.constructor.apply(this, arguments);
    }
    VBarView.prototype._map_data = function () {
        var i, j, ref, vbottom, vtop;
        this.sx = this.renderer.xmapper.v_map_to_target(this._x);
        vtop = this.renderer.ymapper.v_map_to_target(this._top);
        vbottom = this.renderer.ymapper.v_map_to_target(this._bottom);
        this.stop = this.renderer.plot_view.canvas.v_vy_to_sy(vtop);
        this.sbottom = this.renderer.plot_view.canvas.v_vy_to_sy(vbottom);
        this.sleft = [];
        this.sright = [];
        this.sw = this.sdist(this.renderer.xmapper, this._x, this._width, 'center');
        for (i = j = 0, ref = this.sx.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            this.sleft.push(this.sx[i] - this.sw[i] / 2);
            this.sright.push(this.sx[i] + this.sw[i] / 2);
        }
        return null;
    };
    VBarView.prototype._index_data = function () {
        var b, bottom, i, j, l, map_to_synthetic, points, r, ref, t, top, width, x;
        map_to_synthetic = function (mapper, array) {
            if (mapper instanceof categorical_mapper_1.CategoricalMapper) {
                return mapper.v_map_to_target(array, true);
            }
            else {
                return array;
            }
        };
        x = map_to_synthetic(this.renderer.xmapper, this._x);
        width = map_to_synthetic(this.renderer.xmapper, this._width);
        top = map_to_synthetic(this.renderer.ymapper, this._top);
        bottom = map_to_synthetic(this.renderer.ymapper, this._bottom);
        points = [];
        for (i = j = 0, ref = x.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            l = x[i] - width[i] / 2;
            r = x[i] + width[i] / 2;
            t = top[i];
            b = bottom[i];
            if (isNaN(l + r + t + b) || !isFinite(l + r + t + b)) {
                continue;
            }
            points.push({
                minX: l,
                minY: b,
                maxX: r,
                maxY: t,
                i: i
            });
        }
        return new spatial_1.RBush(points);
    };
    VBarView.prototype._render = function (ctx, indices, arg) {
        var i, j, len, results, sbottom, sleft, sright, stop;
        sleft = arg.sleft, sright = arg.sright, stop = arg.stop, sbottom = arg.sbottom;
        results = [];
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (isNaN(sleft[i] + stop[i] + sright[i] + sbottom[i])) {
                continue;
            }
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                ctx.fillRect(sleft[i], stop[i], sright[i] - sleft[i], sbottom[i] - stop[i]);
            }
            if (this.visuals.line.doit) {
                ctx.beginPath();
                ctx.rect(sleft[i], stop[i], sright[i] - sleft[i], sbottom[i] - stop[i]);
                this.visuals.line.set_vectorize(ctx, i);
                results.push(ctx.stroke());
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    VBarView.prototype._hit_point = function (geometry) {
        var hits, ref, result, vx, vy, x, y;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        x = this.renderer.xmapper.map_from_target(vx, true);
        y = this.renderer.ymapper.map_from_target(vy, true);
        hits = this.index.indices({
            minX: x,
            minY: y,
            maxX: x,
            maxY: y
        });
        result = hittest.create_hit_test_result();
        result['1d'].indices = hits;
        return result;
    };
    VBarView.prototype.scy = function (i) {
        return (this.stop[i] + this.sbottom[i]) / 2;
    };
    VBarView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
    };
    return VBarView;
})(glyph_1.GlyphView);
exports.VBar = (function (superClass) {
    extend(VBar, superClass);
    function VBar() {
        return VBar.__super__.constructor.apply(this, arguments);
    }
    VBar.prototype.default_view = exports.VBarView;
    VBar.prototype.type = 'VBar';
    VBar.mixins(['line', 'fill']);
    VBar.define({
        x: [p.NumberSpec],
        width: [p.DistanceSpec],
        top: [p.NumberSpec],
        bottom: [p.NumberSpec, 0]
    });
    return VBar;
})(glyph_1.Glyph);

},{"../mappers/categorical_mapper":"models/mappers/categorical_mapper","./glyph":"models/glyphs/glyph","core/hittest":"core/hittest","core/properties":"core/properties","core/util/spatial":"core/util/spatial"}],"models/glyphs/wedge":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("./xy_glyph");
var hittest = require("core/hittest");
var p = require("core/properties");
var math_1 = require("core/util/math");
exports.WedgeView = (function (superClass) {
    extend(WedgeView, superClass);
    function WedgeView() {
        return WedgeView.__super__.constructor.apply(this, arguments);
    }
    WedgeView.prototype._map_data = function () {
        if (this.model.properties.radius.units === "data") {
            return this.sradius = this.sdist(this.renderer.xmapper, this._x, this._radius);
        }
        else {
            return this.sradius = this._radius;
        }
    };
    WedgeView.prototype._render = function (ctx, indices, arg) {
        var _end_angle, _start_angle, direction, i, j, len, results, sradius, sx, sy;
        sx = arg.sx, sy = arg.sy, sradius = arg.sradius, _start_angle = arg._start_angle, _end_angle = arg._end_angle;
        direction = this.model.properties.direction.value();
        results = [];
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (isNaN(sx[i] + sy[i] + sradius[i] + _start_angle[i] + _end_angle[i])) {
                continue;
            }
            ctx.beginPath();
            ctx.arc(sx[i], sy[i], sradius[i], _start_angle[i], _end_angle[i], direction);
            ctx.lineTo(sx[i], sy[i]);
            ctx.closePath();
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                results.push(ctx.stroke());
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    WedgeView.prototype._hit_point = function (geometry) {
        var angle, bbox, candidates, direction, dist, hits, i, j, k, len, len1, r2, ref, ref1, ref2, ref3, ref4, sx, sx0, sx1, sy, sy0, sy1, vx, vx0, vx1, vy, vy0, vy1, x, x0, x1, y, y0, y1;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        x = this.renderer.xmapper.map_from_target(vx, true);
        y = this.renderer.ymapper.map_from_target(vy, true);
        if (this.model.properties.radius.units === "data") {
            x0 = x - this.max_radius;
            x1 = x + this.max_radius;
            y0 = y - this.max_radius;
            y1 = y + this.max_radius;
        }
        else {
            vx0 = vx - this.max_radius;
            vx1 = vx + this.max_radius;
            ref1 = this.renderer.xmapper.v_map_from_target([vx0, vx1], true), x0 = ref1[0], x1 = ref1[1];
            vy0 = vy - this.max_radius;
            vy1 = vy + this.max_radius;
            ref2 = this.renderer.ymapper.v_map_from_target([vy0, vy1], true), y0 = ref2[0], y1 = ref2[1];
        }
        candidates = [];
        bbox = hittest.validate_bbox_coords([x0, x1], [y0, y1]);
        ref3 = this.index.indices(bbox);
        for (j = 0, len = ref3.length; j < len; j++) {
            i = ref3[j];
            r2 = Math.pow(this.sradius[i], 2);
            sx0 = this.renderer.xmapper.map_to_target(x, true);
            sx1 = this.renderer.xmapper.map_to_target(this._x[i], true);
            sy0 = this.renderer.ymapper.map_to_target(y, true);
            sy1 = this.renderer.ymapper.map_to_target(this._y[i], true);
            dist = Math.pow(sx0 - sx1, 2) + Math.pow(sy0 - sy1, 2);
            if (dist <= r2) {
                candidates.push([i, dist]);
            }
        }
        direction = this.model.properties.direction.value();
        hits = [];
        for (k = 0, len1 = candidates.length; k < len1; k++) {
            ref4 = candidates[k], i = ref4[0], dist = ref4[1];
            sx = this.renderer.plot_view.canvas.vx_to_sx(vx);
            sy = this.renderer.plot_view.canvas.vy_to_sy(vy);
            angle = Math.atan2(sy - this.sy[i], sx - this.sx[i]);
            if (math_1.angle_between(-angle, -this._start_angle[i], -this._end_angle[i], direction)) {
                hits.push([i, dist]);
            }
        }
        return hittest.create_1d_hit_test_result(hits);
    };
    WedgeView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
    };
    return WedgeView;
})(xy_glyph_1.XYGlyphView);
exports.Wedge = (function (superClass) {
    extend(Wedge, superClass);
    function Wedge() {
        return Wedge.__super__.constructor.apply(this, arguments);
    }
    Wedge.prototype.default_view = exports.WedgeView;
    Wedge.prototype.type = 'Wedge';
    Wedge.mixins(['line', 'fill']);
    Wedge.define({
        direction: [p.Direction, 'anticlock'],
        radius: [p.DistanceSpec],
        start_angle: [p.AngleSpec],
        end_angle: [p.AngleSpec]
    });
    return Wedge;
})(xy_glyph_1.XYGlyph);

},{"./xy_glyph":"models/glyphs/xy_glyph","core/hittest":"core/hittest","core/properties":"core/properties","core/util/math":"core/util/math"}],"models/glyphs/xy_glyph":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var spatial_1 = require("core/util/spatial");
var glyph_1 = require("./glyph");
var categorical_mapper_1 = require("../mappers/categorical_mapper");
exports.XYGlyphView = (function (superClass) {
    extend(XYGlyphView, superClass);
    function XYGlyphView() {
        return XYGlyphView.__super__.constructor.apply(this, arguments);
    }
    XYGlyphView.prototype._index_data = function () {
        var i, j, points, ref, x, xx, y, yy;
        if (this.renderer.xmapper instanceof categorical_mapper_1.CategoricalMapper) {
            xx = this.renderer.xmapper.v_map_to_target(this._x, true);
        }
        else {
            xx = this._x;
        }
        if (this.renderer.ymapper instanceof categorical_mapper_1.CategoricalMapper) {
            yy = this.renderer.ymapper.v_map_to_target(this._y, true);
        }
        else {
            yy = this._y;
        }
        points = [];
        for (i = j = 0, ref = xx.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            x = xx[i];
            if (isNaN(x) || !isFinite(x)) {
                continue;
            }
            y = yy[i];
            if (isNaN(y) || !isFinite(y)) {
                continue;
            }
            points.push({
                minX: x,
                minY: y,
                maxX: x,
                maxY: y,
                i: i
            });
        }
        return new spatial_1.RBush(points);
    };
    return XYGlyphView;
})(glyph_1.GlyphView);
exports.XYGlyph = (function (superClass) {
    extend(XYGlyph, superClass);
    function XYGlyph() {
        return XYGlyph.__super__.constructor.apply(this, arguments);
    }
    XYGlyph.prototype.type = "XYGlyph";
    XYGlyph.prototype.default_view = exports.XYGlyphView;
    XYGlyph.coords([['x', 'y']]);
    return XYGlyph;
})(glyph_1.Glyph);

},{"../mappers/categorical_mapper":"models/mappers/categorical_mapper","./glyph":"models/glyphs/glyph","core/util/spatial":"core/util/spatial"}],"models/grids/grid":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var guide_renderer_1 = require("../renderers/guide_renderer");
var renderer_1 = require("../renderers/renderer");
var p = require("core/properties");
var types_1 = require("core/util/types");
exports.GridView = (function (superClass) {
    extend(GridView, superClass);
    function GridView() {
        return GridView.__super__.constructor.apply(this, arguments);
    }
    GridView.prototype.initialize = function (attrs, options) {
        GridView.__super__.initialize.call(this, attrs, options);
        this._x_range_name = this.model.x_range_name;
        return this._y_range_name = this.model.y_range_name;
    };
    GridView.prototype.render = function () {
        var ctx;
        if (this.model.visible === false) {
            return;
        }
        ctx = this.plot_view.canvas_view.ctx;
        ctx.save();
        this._draw_regions(ctx);
        this._draw_minor_grids(ctx);
        this._draw_grids(ctx);
        return ctx.restore();
    };
    GridView.prototype.bind_bokeh_events = function () {
        return this.listenTo(this.model, 'change', this.request_render);
    };
    GridView.prototype._draw_regions = function (ctx) {
        var i, k, ref, ref1, ref2, ref3, sx0, sx1, sy0, sy1, xs, ys;
        if (!this.visuals.band_fill.doit) {
            return;
        }
        ref = this.model.grid_coords('major', false), xs = ref[0], ys = ref[1];
        this.visuals.band_fill.set_value(ctx);
        for (i = k = 0, ref1 = xs.length - 1; 0 <= ref1 ? k < ref1 : k > ref1; i = 0 <= ref1 ? ++k : --k) {
            if (i % 2 === 1) {
                ref2 = this.plot_view.map_to_screen(xs[i], ys[i], this._x_range_name, this._y_range_name), sx0 = ref2[0], sy0 = ref2[1];
                ref3 = this.plot_view.map_to_screen(xs[i + 1], ys[i + 1], this._x_range_name, this._y_range_name), sx1 = ref3[0], sy1 = ref3[1];
                ctx.fillRect(sx0[0], sy0[0], sx1[1] - sx0[0], sy1[1] - sy0[0]);
                ctx.fill();
            }
        }
    };
    GridView.prototype._draw_grids = function (ctx) {
        var ref, xs, ys;
        if (!this.visuals.grid_line.doit) {
            return;
        }
        ref = this.model.grid_coords('major'), xs = ref[0], ys = ref[1];
        return this._draw_grid_helper(ctx, this.visuals.grid_line, xs, ys);
    };
    GridView.prototype._draw_minor_grids = function (ctx) {
        var ref, xs, ys;
        if (!this.visuals.minor_grid_line.doit) {
            return;
        }
        ref = this.model.grid_coords('minor'), xs = ref[0], ys = ref[1];
        return this._draw_grid_helper(ctx, this.visuals.minor_grid_line, xs, ys);
    };
    GridView.prototype._draw_grid_helper = function (ctx, props, xs, ys) {
        var i, k, l, ref, ref1, ref2, sx, sy;
        props.set_value(ctx);
        for (i = k = 0, ref = xs.length; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
            ref1 = this.plot_view.map_to_screen(xs[i], ys[i], this._x_range_name, this._y_range_name), sx = ref1[0], sy = ref1[1];
            ctx.beginPath();
            ctx.moveTo(Math.round(sx[0]), Math.round(sy[0]));
            for (i = l = 1, ref2 = sx.length; 1 <= ref2 ? l < ref2 : l > ref2; i = 1 <= ref2 ? ++l : --l) {
                ctx.lineTo(Math.round(sx[i]), Math.round(sy[i]));
            }
            ctx.stroke();
        }
    };
    return GridView;
})(renderer_1.RendererView);
exports.Grid = (function (superClass) {
    extend(Grid, superClass);
    function Grid() {
        return Grid.__super__.constructor.apply(this, arguments);
    }
    Grid.prototype.default_view = exports.GridView;
    Grid.prototype.type = 'Grid';
    Grid.mixins(['line:grid_', 'line:minor_grid_', 'fill:band_']);
    Grid.define({
        bounds: [p.Any, 'auto'],
        dimension: [p.Number, 0],
        ticker: [p.Instance],
        x_range_name: [p.String, 'default'],
        y_range_name: [p.String, 'default']
    });
    Grid.override({
        level: "underlay",
        band_fill_color: null,
        band_fill_alpha: 0,
        grid_line_color: '#e5e5e5',
        minor_grid_line_color: null
    });
    Grid.prototype.ranges = function () {
        var frame, i, j, ranges;
        i = this.dimension;
        j = (i + 1) % 2;
        frame = this.plot.plot_canvas.frame;
        ranges = [frame.x_ranges[this.x_range_name], frame.y_ranges[this.y_range_name]];
        return [ranges[i], ranges[j]];
    };
    Grid.prototype.computed_bounds = function () {
        var cross_range, end, range, range_bounds, ref, start, user_bounds;
        ref = this.ranges(), range = ref[0], cross_range = ref[1];
        user_bounds = this.bounds;
        range_bounds = [range.min, range.max];
        if (types_1.isArray(user_bounds)) {
            start = Math.min(user_bounds[0], user_bounds[1]);
            end = Math.max(user_bounds[0], user_bounds[1]);
            if (start < range_bounds[0]) {
                start = range_bounds[0];
            }
            else if (start > range_bounds[1]) {
                start = null;
            }
            if (end > range_bounds[1]) {
                end = range_bounds[1];
            }
            else if (end < range_bounds[0]) {
                end = null;
            }
        }
        else {
            start = range_bounds[0], end = range_bounds[1];
        }
        return [start, end];
    };
    Grid.prototype.grid_coords = function (location, exclude_ends) {
        var N, cmax, cmin, coords, cross_range, dim_i, dim_j, end, i, ii, j, k, l, loc, max, min, n, range, ref, ref1, ref2, ref3, start, ticks, tmp;
        if (exclude_ends == null) {
            exclude_ends = true;
        }
        i = this.dimension;
        j = (i + 1) % 2;
        ref = this.ranges(), range = ref[0], cross_range = ref[1];
        ref1 = this.computed_bounds(), start = ref1[0], end = ref1[1];
        tmp = Math.min(start, end);
        end = Math.max(start, end);
        start = tmp;
        ticks = this.ticker.get_ticks(start, end, range, cross_range.min, {})[location];
        min = range.min;
        max = range.max;
        cmin = cross_range.min;
        cmax = cross_range.max;
        coords = [[], []];
        for (ii = k = 0, ref2 = ticks.length; 0 <= ref2 ? k < ref2 : k > ref2; ii = 0 <= ref2 ? ++k : --k) {
            if ((ticks[ii] === min || ticks[ii] === max) && exclude_ends) {
                continue;
            }
            dim_i = [];
            dim_j = [];
            N = 2;
            for (n = l = 0, ref3 = N; 0 <= ref3 ? l < ref3 : l > ref3; n = 0 <= ref3 ? ++l : --l) {
                loc = cmin + (cmax - cmin) / (N - 1) * n;
                dim_i.push(ticks[ii]);
                dim_j.push(loc);
            }
            coords[i].push(dim_i);
            coords[j].push(dim_j);
        }
        return coords;
    };
    return Grid;
})(guide_renderer_1.GuideRenderer);

},{"../renderers/guide_renderer":"models/renderers/guide_renderer","../renderers/renderer":"models/renderers/renderer","core/properties":"core/properties","core/util/types":"core/util/types"}],"models/grids/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var grid_1 = require("./grid");
exports.Grid = grid_1.Grid;

},{"./grid":"models/grids/grid"}],"models/index":[function(require,module,exports){
"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
__export(require("./annotations"));
__export(require("./axes"));
__export(require("./callbacks"));
__export(require("./canvas"));
__export(require("./formatters"));
__export(require("./glyphs"));
__export(require("./grids"));
__export(require("./layouts"));
__export(require("./mappers"));
__export(require("./transforms"));
__export(require("./markers"));
__export(require("./plots"));
__export(require("./ranges"));
__export(require("./renderers"));
__export(require("./sources"));
__export(require("./tickers"));
__export(require("./tiles"));
__export(require("./tools"));

},{"./annotations":"models/annotations/index","./axes":"models/axes/index","./callbacks":"models/callbacks/index","./canvas":"models/canvas/index","./formatters":"models/formatters/index","./glyphs":"models/glyphs/index","./grids":"models/grids/index","./layouts":"models/layouts/index","./mappers":"models/mappers/index","./markers":"models/markers/index","./plots":"models/plots/index","./ranges":"models/ranges/index","./renderers":"models/renderers/index","./sources":"models/sources/index","./tickers":"models/tickers/index","./tiles":"models/tiles/index","./tools":"models/tools/index","./transforms":"models/transforms/index"}],"models/layouts/box":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend1 = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, indexOf = [].indexOf || function (item) { for (var i = 0, l = this.length; i < l; i++) {
    if (i in this && this[i] === item)
        return i;
} return -1; };
var solver_1 = require("core/layout/solver");
var p = require("core/properties");
var types_1 = require("core/util/types");
var array_1 = require("core/util/array");
var object_1 = require("core/util/object");
var layout_dom_1 = require("./layout_dom");
exports.BoxView = (function (superClass) {
    extend1(BoxView, superClass);
    function BoxView() {
        return BoxView.__super__.constructor.apply(this, arguments);
    }
    BoxView.prototype.className = "bk-grid";
    BoxView.prototype.bind_bokeh_events = function () {
        BoxView.__super__.bind_bokeh_events.call(this);
        return this.listenTo(this.model, 'change:children', this.build_child_views);
    };
    BoxView.prototype.get_height = function () {
        var child_heights, children, height;
        children = this.model.get_layoutable_children();
        child_heights = children.map(function (child) {
            return child._height._value;
        });
        if (this.model._horizontal) {
            height = array_1.max(child_heights);
        }
        else {
            height = array_1.sum(child_heights);
        }
        return height;
    };
    BoxView.prototype.get_width = function () {
        var child_widths, children, width;
        children = this.model.get_layoutable_children();
        child_widths = children.map(function (child) {
            return child._width._value;
        });
        if (this.model._horizontal) {
            width = array_1.sum(child_widths);
        }
        else {
            width = array_1.max(child_widths);
        }
        return width;
    };
    return BoxView;
})(layout_dom_1.LayoutDOMView);
exports.Box = (function (superClass) {
    extend1(Box, superClass);
    Box.prototype.default_view = exports.BoxView;
    function Box(attrs, options) {
        Box.__super__.constructor.call(this, attrs, options);
        this._child_equal_size_width = new solver_1.Variable();
        this._child_equal_size_height = new solver_1.Variable();
        this._box_equal_size_top = new solver_1.Variable();
        this._box_equal_size_bottom = new solver_1.Variable();
        this._box_equal_size_left = new solver_1.Variable();
        this._box_equal_size_right = new solver_1.Variable();
        this._box_cell_align_top = new solver_1.Variable();
        this._box_cell_align_bottom = new solver_1.Variable();
        this._box_cell_align_left = new solver_1.Variable();
        this._box_cell_align_right = new solver_1.Variable();
    }
    Box.define({
        children: [p.Array, []]
    });
    Box.internal({
        spacing: [p.Number, 6]
    });
    Box.prototype.get_layoutable_children = function () {
        return this.children;
    };
    Box.prototype.variables_updated = function () {
        var child, j, len, ref;
        ref = this.get_layoutable_children();
        for (j = 0, len = ref.length; j < len; j++) {
            child = ref[j];
            child.trigger('change');
        }
        return this.trigger('change');
    };
    Box.prototype.get_edit_variables = function () {
        var child, edit_variables, j, len, ref;
        edit_variables = Box.__super__.get_edit_variables.call(this);
        ref = this.get_layoutable_children();
        for (j = 0, len = ref.length; j < len; j++) {
            child = ref[j];
            edit_variables = edit_variables.concat(child.get_edit_variables());
        }
        return edit_variables;
    };
    Box.prototype.get_constrained_variables = function () {
        var constrained_variables;
        constrained_variables = Box.__super__.get_constrained_variables.call(this);
        constrained_variables = object_1.extend(constrained_variables, {
            'box-equal-size-top': this._box_equal_size_top,
            'box-equal-size-bottom': this._box_equal_size_bottom,
            'box-equal-size-left': this._box_equal_size_left,
            'box-equal-size-right': this._box_equal_size_right,
            'box-cell-align-top': this._box_cell_align_top,
            'box-cell-align-bottom': this._box_cell_align_bottom,
            'box-cell-align-left': this._box_cell_align_left,
            'box-cell-align-right': this._box_cell_align_right
        });
        return constrained_variables;
    };
    Box.prototype.get_constraints = function () {
        var child, children, constraints, i, j, k, last, len, next, rect, ref, var_keys, vars;
        constraints = [];
        children = this.get_layoutable_children();
        if (children.length === 0) {
            return constraints;
        }
        for (j = 0, len = children.length; j < len; j++) {
            child = children[j];
            this._test_layoutable(child);
            vars = child.get_constrained_variables();
            var_keys = Object.keys(vars);
            rect = this._child_rect(vars);
            if (this._horizontal) {
                if (this._has_var('height', var_keys)) {
                    constraints.push(solver_1.EQ(rect.height, [-1, this._height]));
                }
            }
            else {
                if (this._has_var('width', var_keys)) {
                    constraints.push(solver_1.EQ(rect.width, [-1, this._width]));
                }
            }
            if (this._horizontal) {
                if (this._has_var(['box-equal-size-left', 'box-equal-size-right', 'width'], var_keys)) {
                    constraints.push(solver_1.EQ([-1, vars['box-equal-size-left']], [-1, vars['box-equal-size-right']], vars['width'], this._child_equal_size_width));
                }
            }
            else {
                if (this._has_var(['box-equal-size-top', 'box-equal-size-bottom', 'height'], var_keys)) {
                    constraints.push(solver_1.EQ([-1, vars['box-equal-size-top']], [-1, vars['box-equal-size-bottom']], vars['height'], this._child_equal_size_height));
                }
            }
            constraints = constraints.concat(child.get_constraints());
        }
        last = this._info(children[0].get_constrained_variables());
        constraints.push(solver_1.EQ(last.span.start, 0));
        for (i = k = 1, ref = children.length; 1 <= ref ? k < ref : k > ref; i = 1 <= ref ? ++k : --k) {
            next = this._info(children[i].get_constrained_variables());
            if (last.span.size) {
                constraints.push(solver_1.EQ(last.span.start, last.span.size, [-1, next.span.start]));
            }
            constraints.push(solver_1.WEAK_EQ(last.whitespace.after, next.whitespace.before, 0 - this.spacing));
            constraints.push(solver_1.GE(last.whitespace.after, next.whitespace.before, 0 - this.spacing));
            last = next;
        }
        if (this._horizontal) {
            if (this._has_var('width', var_keys)) {
                constraints.push(solver_1.EQ(last.span.start, last.span.size, [-1, this._width]));
            }
        }
        else {
            if (this._has_var('height', var_keys)) {
                constraints.push(solver_1.EQ(last.span.start, last.span.size, [-1, this._height]));
            }
        }
        constraints = constraints.concat(this._align_outer_edges_constraints(true));
        constraints = constraints.concat(this._align_outer_edges_constraints(false));
        constraints = constraints.concat(this._align_inner_cell_edges_constraints());
        constraints = constraints.concat(this._box_equal_size_bounds(true));
        constraints = constraints.concat(this._box_equal_size_bounds(false));
        constraints = constraints.concat(this._box_cell_align_bounds(true));
        constraints = constraints.concat(this._box_cell_align_bounds(false));
        constraints = constraints.concat(this._box_whitespace(true));
        constraints = constraints.concat(this._box_whitespace(false));
        return constraints;
    };
    Box.prototype._has_var = function (look_up, var_keys) {
        var look_up_list;
        look_up_list = types_1.isString(look_up) ? [look_up] : look_up;
        return array_1.all(look_up_list, function (x) {
            return indexOf.call(var_keys, x) >= 0;
        });
    };
    Box.prototype._test_layoutable = function (child) {
        var j, key, len, required_constrained_variables, vars;
        required_constrained_variables = ['origin-x', 'origin-y', 'whitespace-top', 'whitespace-right', 'whitespace-bottom', 'whitespace-left'];
        if (child.get_constrained_variables == null) {
            throw new Error(child + " is missing get_constrained_variables method");
        }
        vars = child.get_constrained_variables();
        for (j = 0, len = required_constrained_variables.length; j < len; j++) {
            key = required_constrained_variables[j];
            if (indexOf.call(Object.keys(vars), key) < 0) {
                throw new Error(child + " is missing constrained_variable " + key);
            }
            if (!vars[key] instanceof solver_1.Variable) {
                throw new Error(child + " " + key + " is not a solver Variable");
            }
        }
        return true;
    };
    Box.prototype._child_rect = function (vars) {
        var height, ref, width, x, y;
        width = vars['width'];
        height = vars['height'];
        ref = [vars['origin-x'], vars['origin-y']], x = ref[0], y = ref[1];
        return {
            x: x,
            y: y,
            width: width,
            height: height
        };
    };
    Box.prototype._span = function (rect) {
        if (this._horizontal) {
            return {
                start: rect.x,
                size: rect.width
            };
        }
        else {
            return {
                start: rect.y,
                size: rect.height
            };
        }
    };
    Box.prototype._info = function (vars) {
        var span, whitespace;
        if (this._horizontal) {
            whitespace = {
                before: vars['whitespace-left'],
                after: vars['whitespace-right']
            };
        }
        else {
            whitespace = {
                before: vars['whitespace-top'],
                after: vars['whitespace-bottom']
            };
        }
        span = this._span(this._child_rect(vars));
        return {
            span: span,
            whitespace: whitespace
        };
    };
    Box.prototype._flatten_cell_edge_variables = function (horizontal) {
        var add_path, all_vars, arity, cell, cell_vars, child, children, direction, flattened, j, k, key, kind, len, len1, name, new_key, parsed, path, relevant_edges, variables;
        if (horizontal) {
            relevant_edges = Box._top_bottom_inner_cell_edge_variables;
        }
        else {
            relevant_edges = Box._left_right_inner_cell_edge_variables;
        }
        add_path = horizontal !== this._horizontal;
        children = this.get_layoutable_children();
        arity = children.length;
        flattened = {};
        cell = 0;
        for (j = 0, len = children.length; j < len; j++) {
            child = children[j];
            if (child instanceof Box) {
                cell_vars = child._flatten_cell_edge_variables(horizontal);
            }
            else {
                cell_vars = {};
            }
            all_vars = child.get_constrained_variables();
            for (k = 0, len1 = relevant_edges.length; k < len1; k++) {
                name = relevant_edges[k];
                if (name in all_vars) {
                    cell_vars[name] = [all_vars[name]];
                }
            }
            for (key in cell_vars) {
                variables = cell_vars[key];
                if (add_path) {
                    parsed = key.split(" ");
                    kind = parsed[0];
                    if (parsed.length > 1) {
                        path = parsed[1];
                    }
                    else {
                        path = "";
                    }
                    if (this._horizontal) {
                        direction = "row";
                    }
                    else {
                        direction = "col";
                    }
                    new_key = kind + " " + direction + "-" + arity + "-" + cell + "-" + path;
                }
                else {
                    new_key = key;
                }
                if (new_key in flattened) {
                    flattened[new_key] = flattened[new_key].concat(variables);
                }
                else {
                    flattened[new_key] = variables;
                }
            }
            cell = cell + 1;
        }
        return flattened;
    };
    Box.prototype._align_inner_cell_edges_constraints = function () {
        var constraints, flattened, i, j, key, last, ref, variables;
        constraints = [];
        if (this._is_root) {
            flattened = this._flatten_cell_edge_variables(this._horizontal);
            for (key in flattened) {
                variables = flattened[key];
                if (variables.length > 1) {
                    last = variables[0];
                    for (i = j = 1, ref = variables.length; 1 <= ref ? j < ref : j > ref; i = 1 <= ref ? ++j : --j) {
                        constraints.push(solver_1.EQ(variables[i], [-1, last]));
                    }
                }
            }
        }
        return constraints;
    };
    Box.prototype._find_edge_leaves = function (horizontal) {
        var child, child_leaves, children, end, j, leaves, len, start;
        children = this.get_layoutable_children();
        leaves = [[], []];
        if (children.length > 0) {
            if (this._horizontal === horizontal) {
                start = children[0];
                end = children[children.length - 1];
                if (start instanceof Box) {
                    leaves[0] = leaves[0].concat(start._find_edge_leaves(horizontal)[0]);
                }
                else {
                    leaves[0].push(start);
                }
                if (end instanceof Box) {
                    leaves[1] = leaves[1].concat(end._find_edge_leaves(horizontal)[1]);
                }
                else {
                    leaves[1].push(end);
                }
            }
            else {
                for (j = 0, len = children.length; j < len; j++) {
                    child = children[j];
                    if (child instanceof Box) {
                        child_leaves = child._find_edge_leaves(horizontal);
                        leaves[0] = leaves[0].concat(child_leaves[0]);
                        leaves[1] = leaves[1].concat(child_leaves[1]);
                    }
                    else {
                        leaves[0].push(child);
                        leaves[1].push(child);
                    }
                }
            }
        }
        return leaves;
    };
    Box.prototype._align_outer_edges_constraints = function (horizontal) {
        var add_all_equal, collect_vars, end_edges, end_leaves, end_variable, ref, result, start_edges, start_leaves, start_variable;
        ref = this._find_edge_leaves(horizontal), start_leaves = ref[0], end_leaves = ref[1];
        if (horizontal) {
            start_variable = 'on-edge-align-left';
            end_variable = 'on-edge-align-right';
        }
        else {
            start_variable = 'on-edge-align-top';
            end_variable = 'on-edge-align-bottom';
        }
        collect_vars = function (leaves, name) {
            var edges, j, leaf, len, vars;
            edges = [];
            for (j = 0, len = leaves.length; j < len; j++) {
                leaf = leaves[j];
                vars = leaf.get_constrained_variables();
                if (name in vars) {
                    edges.push(vars[name]);
                }
            }
            return edges;
        };
        start_edges = collect_vars(start_leaves, start_variable);
        end_edges = collect_vars(end_leaves, end_variable);
        result = [];
        add_all_equal = function (edges) {
            var edge, first, i, j, ref1;
            if (edges.length > 1) {
                first = edges[0];
                for (i = j = 1, ref1 = edges.length; 1 <= ref1 ? j < ref1 : j > ref1; i = 1 <= ref1 ? ++j : --j) {
                    edge = edges[i];
                    result.push(solver_1.EQ([-1, first], edge));
                }
                return null;
            }
        };
        add_all_equal(start_edges);
        add_all_equal(end_edges);
        return result;
    };
    Box.prototype._box_insets_from_child_insets = function (horizontal, child_variable_prefix, our_variable_prefix, minimum) {
        var add_constraints, end_leaves, end_variable, our_end, our_start, ref, result, start_leaves, start_variable;
        ref = this._find_edge_leaves(horizontal), start_leaves = ref[0], end_leaves = ref[1];
        if (horizontal) {
            start_variable = child_variable_prefix + "-left";
            end_variable = child_variable_prefix + "-right";
            our_start = this[our_variable_prefix + "_left"];
            our_end = this[our_variable_prefix + "_right"];
        }
        else {
            start_variable = child_variable_prefix + "-top";
            end_variable = child_variable_prefix + "-bottom";
            our_start = this[our_variable_prefix + "_top"];
            our_end = this[our_variable_prefix + "_bottom"];
        }
        result = [];
        add_constraints = function (ours, leaves, name) {
            var edges, j, leaf, len, vars;
            edges = [];
            for (j = 0, len = leaves.length; j < len; j++) {
                leaf = leaves[j];
                vars = leaf.get_constrained_variables();
                if (name in vars) {
                    if (minimum) {
                        result.push(solver_1.GE([-1, ours], vars[name]));
                    }
                    else {
                        result.push(solver_1.EQ([-1, ours], vars[name]));
                    }
                }
            }
            return null;
        };
        add_constraints(our_start, start_leaves, start_variable);
        add_constraints(our_end, end_leaves, end_variable);
        return result;
    };
    Box.prototype._box_equal_size_bounds = function (horizontal) {
        return this._box_insets_from_child_insets(horizontal, 'box-equal-size', '_box_equal_size', false);
    };
    Box.prototype._box_cell_align_bounds = function (horizontal) {
        return this._box_insets_from_child_insets(horizontal, 'box-cell-align', '_box_cell_align', false);
    };
    Box.prototype._box_whitespace = function (horizontal) {
        return this._box_insets_from_child_insets(horizontal, 'whitespace', '_whitespace', true);
    };
    Box._left_right_inner_cell_edge_variables = ['box-cell-align-left', 'box-cell-align-right'];
    Box._top_bottom_inner_cell_edge_variables = ['box-cell-align-top', 'box-cell-align-bottom'];
    return Box;
})(layout_dom_1.LayoutDOM);

},{"./layout_dom":"models/layouts/layout_dom","core/layout/solver":"core/layout/solver","core/properties":"core/properties","core/util/array":"core/util/array","core/util/object":"core/util/object","core/util/types":"core/util/types"}],"models/layouts/column":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var box_1 = require("./box");
exports.ColumnView = (function (superClass) {
    extend(ColumnView, superClass);
    function ColumnView() {
        return ColumnView.__super__.constructor.apply(this, arguments);
    }
    ColumnView.prototype.className = "bk-grid-column";
    return ColumnView;
})(box_1.BoxView);
exports.Column = (function (superClass) {
    extend(Column, superClass);
    Column.prototype.type = 'Column';
    Column.prototype.default_view = exports.ColumnView;
    function Column(attrs, options) {
        Column.__super__.constructor.call(this, attrs, options);
        this._horizontal = false;
    }
    return Column;
})(box_1.Box);

},{"./box":"models/layouts/box"}],"models/layouts/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var box_1 = require("./box");
exports.Box = box_1.Box;
var column_1 = require("./column");
exports.Column = column_1.Column;
var layout_dom_1 = require("./layout_dom");
exports.LayoutDOM = layout_dom_1.LayoutDOM;
var row_1 = require("./row");
exports.Row = row_1.Row;
var spacer_1 = require("./spacer");
exports.Spacer = spacer_1.Spacer;
var widget_box_1 = require("./widget_box");
exports.WidgetBox = widget_box_1.WidgetBox;

},{"./box":"models/layouts/box","./column":"models/layouts/column","./layout_dom":"models/layouts/layout_dom","./row":"models/layouts/row","./spacer":"models/layouts/spacer","./widget_box":"models/layouts/widget_box"}],"models/layouts/layout_dom":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend1 = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var model_1 = require("../../model");
var dom_1 = require("core/dom");
var p = require("core/properties");
var solver_1 = require("core/layout/solver");
var build_views_1 = require("core/build_views");
var bokeh_view_1 = require("core/bokeh_view");
var logging_1 = require("core/logging");
var object_1 = require("core/util/object");
exports.LayoutDOMView = (function (superClass) {
    extend1(LayoutDOMView, superClass);
    function LayoutDOMView() {
        return LayoutDOMView.__super__.constructor.apply(this, arguments);
    }
    LayoutDOMView.prototype.initialize = function (options) {
        var cls, i, len, ref;
        LayoutDOMView.__super__.initialize.call(this, options);
        this.el.setAttribute("id", "modelid_" + this.model.id);
        this.el.classList.add("bk-layout-" + this.model.sizing_mode);
        if (this.model.css_classes != null) {
            ref = this.model.css_classes;
            for (i = 0, len = ref.length; i < len; i++) {
                cls = ref[i];
                this.el.classList.add(cls);
            }
        }
        this.child_views = {};
        return this.build_child_views(false);
    };
    LayoutDOMView.prototype.build_child_views = function (init_solver) {
        var child, child_view, children, i, len;
        if (init_solver == null) {
            init_solver = true;
        }
        this.unbind_bokeh_events();
        if (init_solver) {
            this.model.document._invalidate_all_models();
            this.model.document._init_solver();
        }
        children = this.model.get_layoutable_children();
        this.child_views = {};
        build_views_1.build_views(this.child_views, children);
        dom_1.empty(this.el);
        for (i = 0, len = children.length; i < len; i++) {
            child = children[i];
            child_view = this.child_views[child.id];
            this.el.appendChild(child_view.el);
        }
        return this.bind_bokeh_events();
    };
    LayoutDOMView.prototype.unbind_bokeh_events = function () {
        var id, ref, results, view;
        this.stopListening();
        ref = this.child_views;
        results = [];
        for (id in ref) {
            view = ref[id];
            view.stopListening();
            results.push(typeof view.unbind_bokeh_events === "function" ? view.unbind_bokeh_events() : void 0);
        }
        return results;
    };
    LayoutDOMView.prototype.bind_bokeh_events = function () {
        var sizing_mode_msg;
        this.listenTo(this.model, 'change', this.render);
        if (this.model.sizing_mode === 'fixed') {
            this.listenToOnce(this.model.document.solver(), 'resize', (function (_this) {
                return function () {
                    return _this.render();
                };
            })(this));
        }
        else {
            this.listenTo(this.model.document.solver(), 'resize', (function (_this) {
                return function () {
                    return _this.render();
                };
            })(this));
        }
        sizing_mode_msg = "Changing sizing_mode after initialization is not currently supported.";
        return this.listenTo(this.model, 'change:sizing_mode', function () {
            return logging_1.logger.warn(sizing_mode_msg);
        });
    };
    LayoutDOMView.prototype.render = function () {
        var height, s, width;
        s = this.model.document.solver();
        if (this.model.sizing_mode === 'fixed') {
            if (this.model.width != null) {
                width = this.model.width;
            }
            else {
                width = this.get_width();
                this.model.width = width;
            }
            if (this.model.height != null) {
                height = this.model.height;
            }
            else {
                height = this.get_height();
                this.model.height = height;
            }
            s.suggest_value(this.model._width, width);
            s.suggest_value(this.model._height, height);
            s.update_variables();
            this.el.style.width = width + "px";
            this.el.style.height = height + "px";
        }
        if (this.model.sizing_mode === 'scale_width') {
            height = this.get_height();
            s.suggest_value(this.model._height, height);
            s.update_variables();
            this.el.style.width = this.model._width._value + "px";
            this.el.style.height = this.model._height._value + "px";
        }
        if (this.model.sizing_mode === 'scale_height') {
            width = this.get_width();
            s.suggest_value(this.model._width, width);
            s.update_variables();
            this.el.style.width = this.model._width._value + "px";
            this.el.style.height = this.model._height._value + "px";
        }
        if (this.model.sizing_mode === 'stretch_both') {
            this.el.style.position = 'absolute';
            this.el.style.left = this.model._dom_left._value + "px";
            this.el.style.top = this.model._dom_top._value + "px";
            this.el.style.width = this.model._width._value + "px";
            return this.el.style.height = this.model._height._value + "px";
        }
    };
    LayoutDOMView.prototype.get_height = function () {
        return null;
    };
    LayoutDOMView.prototype.get_width = function () {
        return null;
    };
    return LayoutDOMView;
})(bokeh_view_1.BokehView);
exports.LayoutDOM = (function (superClass) {
    extend1(LayoutDOM, superClass);
    function LayoutDOM() {
        return LayoutDOM.__super__.constructor.apply(this, arguments);
    }
    LayoutDOM.prototype.type = "LayoutDOM";
    LayoutDOM.prototype.initialize = function (attrs, options) {
        LayoutDOM.__super__.initialize.call(this, attrs, options);
        this._width = new solver_1.Variable("_width " + this.id);
        this._height = new solver_1.Variable("_height " + this.id);
        this._left = new solver_1.Variable("_left " + this.id);
        this._right = new solver_1.Variable("_right " + this.id);
        this._top = new solver_1.Variable("_top " + this.id);
        this._bottom = new solver_1.Variable("_bottom " + this.id);
        this._dom_top = new solver_1.Variable("_dom_top " + this.id);
        this._dom_left = new solver_1.Variable("_dom_left " + this.id);
        this._width_minus_right = new solver_1.Variable("_width_minus_right " + this.id);
        this._height_minus_bottom = new solver_1.Variable("_height_minus_bottom " + this.id);
        this._whitespace_top = new solver_1.Variable();
        this._whitespace_bottom = new solver_1.Variable();
        this._whitespace_left = new solver_1.Variable();
        return this._whitespace_right = new solver_1.Variable();
    };
    LayoutDOM.prototype.get_constraints = function () {
        var constraints;
        constraints = [];
        constraints.push(solver_1.GE(this._dom_left));
        constraints.push(solver_1.GE(this._dom_top));
        constraints.push(solver_1.GE(this._left));
        constraints.push(solver_1.GE(this._width, [-1, this._right]));
        constraints.push(solver_1.GE(this._top));
        constraints.push(solver_1.GE(this._height, [-1, this._bottom]));
        constraints.push(solver_1.EQ(this._width_minus_right, [-1, this._width], this._right));
        constraints.push(solver_1.EQ(this._height_minus_bottom, [-1, this._height], this._bottom));
        return constraints;
    };
    LayoutDOM.prototype.get_layoutable_children = function () {
        return [];
    };
    LayoutDOM.prototype.get_edit_variables = function () {
        var edit_variables;
        edit_variables = [];
        if (this.sizing_mode === 'fixed') {
            edit_variables.push({
                edit_variable: this._height,
                strength: solver_1.Strength.strong
            });
            edit_variables.push({
                edit_variable: this._width,
                strength: solver_1.Strength.strong
            });
        }
        if (this.sizing_mode === 'scale_width') {
            edit_variables.push({
                edit_variable: this._height,
                strength: solver_1.Strength.strong
            });
        }
        if (this.sizing_mode === 'scale_height') {
            edit_variables.push({
                edit_variable: this._width,
                strength: solver_1.Strength.strong
            });
        }
        return edit_variables;
    };
    LayoutDOM.prototype.get_constrained_variables = function () {
        var constrained_variables;
        constrained_variables = {
            'origin-x': this._dom_left,
            'origin-y': this._dom_top,
            'whitespace-top': this._whitespace_top,
            'whitespace-bottom': this._whitespace_bottom,
            'whitespace-left': this._whitespace_left,
            'whitespace-right': this._whitespace_right
        };
        if (this.sizing_mode === 'stretch_both') {
            constrained_variables = object_1.extend(constrained_variables, {
                'width': this._width,
                'height': this._height
            });
        }
        if (this.sizing_mode === 'scale_width') {
            constrained_variables = object_1.extend(constrained_variables, {
                'width': this._width
            });
        }
        if (this.sizing_mode === 'scale_height') {
            constrained_variables = object_1.extend(constrained_variables, {
                'height': this._height
            });
        }
        return constrained_variables;
    };
    LayoutDOM.define({
        height: [p.Number],
        width: [p.Number],
        disabled: [p.Bool, false],
        sizing_mode: [p.SizingMode, "fixed"],
        css_classes: [p.Array]
    });
    LayoutDOM.internal({
        layoutable: [p.Bool, true]
    });
    return LayoutDOM;
})(model_1.Model);

},{"../../model":"model","core/bokeh_view":"core/bokeh_view","core/build_views":"core/build_views","core/dom":"core/dom","core/layout/solver":"core/layout/solver","core/logging":"core/logging","core/properties":"core/properties","core/util/object":"core/util/object"}],"models/layouts/row":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var box_1 = require("./box");
exports.RowView = (function (superClass) {
    extend(RowView, superClass);
    function RowView() {
        return RowView.__super__.constructor.apply(this, arguments);
    }
    RowView.prototype.className = "bk-grid-row";
    return RowView;
})(box_1.BoxView);
exports.Row = (function (superClass) {
    extend(Row, superClass);
    Row.prototype.type = 'Row';
    Row.prototype.default_view = exports.RowView;
    function Row(attrs, options) {
        Row.__super__.constructor.call(this, attrs, options);
        this._horizontal = true;
    }
    return Row;
})(box_1.Box);

},{"./box":"models/layouts/box"}],"models/layouts/spacer":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend1 = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var layout_dom_1 = require("./layout_dom");
var object_1 = require("core/util/object");
exports.SpacerView = (function (superClass) {
    extend1(SpacerView, superClass);
    function SpacerView() {
        return SpacerView.__super__.constructor.apply(this, arguments);
    }
    SpacerView.prototype.className = "bk-spacer-box";
    SpacerView.prototype.render = function () {
        SpacerView.__super__.render.call(this);
        if (this.sizing_mode === 'fixed') {
            this.el.style.width = this.model.width + "px";
            return this.el.style.height = this.model.height + "px";
        }
    };
    SpacerView.prototype.get_height = function () {
        return 1;
    };
    return SpacerView;
})(layout_dom_1.LayoutDOMView);
exports.Spacer = (function (superClass) {
    extend1(Spacer, superClass);
    function Spacer() {
        return Spacer.__super__.constructor.apply(this, arguments);
    }
    Spacer.prototype.type = 'Spacer';
    Spacer.prototype.default_view = exports.SpacerView;
    Spacer.prototype.get_constrained_variables = function () {
        var constrained_variables;
        constrained_variables = Spacer.__super__.get_constrained_variables.call(this);
        constrained_variables = object_1.extend(constrained_variables, {
            'on-edge-align-top': this._top,
            'on-edge-align-bottom': this._height_minus_bottom,
            'on-edge-align-left': this._left,
            'on-edge-align-right': this._width_minus_right,
            'box-cell-align-top': this._top,
            'box-cell-align-bottom': this._height_minus_bottom,
            'box-cell-align-left': this._left,
            'box-cell-align-right': this._width_minus_right,
            'box-equal-size-top': this._top,
            'box-equal-size-bottom': this._height_minus_bottom,
            'box-equal-size-left': this._left,
            'box-equal-size-right': this._width_minus_right
        });
        return constrained_variables;
    };
    return Spacer;
})(layout_dom_1.LayoutDOM);

},{"./layout_dom":"models/layouts/layout_dom","core/util/object":"core/util/object"}],"models/layouts/widget_box":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend1 = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var logging_1 = require("core/logging");
var p = require("core/properties");
var object_1 = require("core/util/object");
var layout_dom_1 = require("../layouts/layout_dom");
exports.WidgetBoxView = (function (superClass) {
    extend1(WidgetBoxView, superClass);
    function WidgetBoxView() {
        return WidgetBoxView.__super__.constructor.apply(this, arguments);
    }
    WidgetBoxView.prototype.className = "bk-widget-box";
    WidgetBoxView.prototype.initialize = function (options) {
        WidgetBoxView.__super__.initialize.call(this, options);
        return this.render();
    };
    WidgetBoxView.prototype.bind_bokeh_events = function () {
        WidgetBoxView.__super__.bind_bokeh_events.call(this);
        return this.listenTo(this.model, 'change:children', (function (_this) {
            return function () {
                return _this.build_child_views();
            };
        })(this));
    };
    WidgetBoxView.prototype.render = function () {
        var css_width, height, s, width;
        s = this.model.document.solver();
        if (this.model.sizing_mode === 'fixed' || this.model.sizing_mode === 'scale_height') {
            width = this.get_width();
            if (this.model._width._value !== width) {
                s.suggest_value(this.model._width, width);
                s.update_variables();
            }
        }
        if (this.model.sizing_mode === 'fixed' || this.model.sizing_mode === 'scale_width') {
            height = this.get_height();
            if (this.model._height._value !== height) {
                s.suggest_value(this.model._height, height);
                s.update_variables();
            }
        }
        if (this.model._width._value - 20 > 0) {
            css_width = (this.model._width._value - 20) + "px";
        }
        else {
            css_width = "100%";
        }
        if (this.model.sizing_mode === 'stretch_both') {
            this.el.style.position = 'absolute';
            this.el.style.left = this.model._dom_left._value + "px";
            this.el.style.top = this.model._dom_top._value + "px";
            this.el.style.width = this.model._width._value + "px";
            return this.el.style.height = this.model._height._value + "px";
        }
        else {
            return this.el.style.width = css_width;
        }
    };
    WidgetBoxView.prototype.get_height = function () {
        var child_view, height, key, ref;
        height = 0;
        ref = this.child_views;
        for (key in ref) {
            if (!hasProp.call(ref, key))
                continue;
            child_view = ref[key];
            height += child_view.el.scrollHeight;
        }
        return height + 20;
    };
    WidgetBoxView.prototype.get_width = function () {
        var child_view, child_width, key, ref, width;
        if (this.model.width != null) {
            return this.model.width;
        }
        else {
            width = this.el.scrollWidth + 20;
            ref = this.child_views;
            for (key in ref) {
                if (!hasProp.call(ref, key))
                    continue;
                child_view = ref[key];
                child_width = child_view.el.scrollWidth;
                if (child_width > width) {
                    width = child_width;
                }
            }
            return width;
        }
    };
    return WidgetBoxView;
})(layout_dom_1.LayoutDOMView);
exports.WidgetBox = (function (superClass) {
    extend1(WidgetBox, superClass);
    function WidgetBox() {
        return WidgetBox.__super__.constructor.apply(this, arguments);
    }
    WidgetBox.prototype.type = 'WidgetBox';
    WidgetBox.prototype.default_view = exports.WidgetBoxView;
    WidgetBox.prototype.initialize = function (options) {
        WidgetBox.__super__.initialize.call(this, options);
        if (this.sizing_mode === 'fixed' && this.width === null) {
            this.width = 300;
            logging_1.logger.info("WidgetBox mode is fixed, but no width specified. Using default of 300.");
        }
        if (this.sizing_mode === 'scale_height') {
            return logging_1.logger.warn("sizing_mode `scale_height` is not experimental for WidgetBox. Please report your results to the bokeh dev team so we can improve.");
        }
    };
    WidgetBox.prototype.get_edit_variables = function () {
        var child, edit_variables, i, len, ref;
        edit_variables = WidgetBox.__super__.get_edit_variables.call(this);
        ref = this.get_layoutable_children();
        for (i = 0, len = ref.length; i < len; i++) {
            child = ref[i];
            edit_variables = edit_variables.concat(child.get_edit_variables());
        }
        return edit_variables;
    };
    WidgetBox.prototype.get_constraints = function () {
        var child, constraints, i, len, ref;
        constraints = WidgetBox.__super__.get_constraints.call(this);
        ref = this.get_layoutable_children();
        for (i = 0, len = ref.length; i < len; i++) {
            child = ref[i];
            constraints = constraints.concat(child.get_constraints());
        }
        return constraints;
    };
    WidgetBox.prototype.get_constrained_variables = function () {
        var constrained_variables;
        constrained_variables = WidgetBox.__super__.get_constrained_variables.call(this);
        constrained_variables = object_1.extend(constrained_variables, {
            'on-edge-align-top': this._top,
            'on-edge-align-bottom': this._height_minus_bottom,
            'on-edge-align-left': this._left,
            'on-edge-align-right': this._width_minus_right,
            'box-cell-align-top': this._top,
            'box-cell-align-bottom': this._height_minus_bottom,
            'box-cell-align-left': this._left,
            'box-cell-align-right': this._width_minus_right,
            'box-equal-size-top': this._top,
            'box-equal-size-bottom': this._height_minus_bottom
        });
        if (this.sizing_mode !== 'fixed') {
            constrained_variables = object_1.extend(constrained_variables, {
                'box-equal-size-left': this._left,
                'box-equal-size-right': this._width_minus_right
            });
        }
        return constrained_variables;
    };
    WidgetBox.prototype.get_layoutable_children = function () {
        return this.children;
    };
    WidgetBox.define({
        'children': [p.Array, []]
    });
    return WidgetBox;
})(layout_dom_1.LayoutDOM);

},{"../layouts/layout_dom":"models/layouts/layout_dom","core/logging":"core/logging","core/properties":"core/properties","core/util/object":"core/util/object"}],"models/mappers/categorical_color_mapper":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var p = require("core/properties");
var color_mapper_1 = require("./color_mapper");
exports.CategoricalColorMapper = (function (superClass) {
    extend(CategoricalColorMapper, superClass);
    function CategoricalColorMapper() {
        return CategoricalColorMapper.__super__.constructor.apply(this, arguments);
    }
    CategoricalColorMapper.prototype.type = "CategoricalColorMapper";
    CategoricalColorMapper.define({
        factors: [p.Array]
    });
    CategoricalColorMapper.prototype._get_values = function (data, palette) {
        var color, d, i, key, len, values;
        values = [];
        for (i = 0, len = data.length; i < len; i++) {
            d = data[i];
            key = this.factors.indexOf(d);
            if (key < 0 || key >= palette.length) {
                color = this.nan_color;
            }
            else {
                color = palette[key];
            }
            values.push(color);
        }
        return values;
    };
    return CategoricalColorMapper;
})(color_mapper_1.ColorMapper);

},{"./color_mapper":"models/mappers/color_mapper","core/properties":"core/properties"}],"models/mappers/categorical_mapper":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var linear_mapper_1 = require("./linear_mapper");
var types_1 = require("core/util/types");
exports.CategoricalMapper = (function (superClass) {
    extend(CategoricalMapper, superClass);
    function CategoricalMapper() {
        return CategoricalMapper.__super__.constructor.apply(this, arguments);
    }
    CategoricalMapper.prototype.map_to_target = function (x, return_synthetic) {
        var factor, factors, percent, range, ref, result;
        if (return_synthetic == null) {
            return_synthetic = false;
        }
        if (types_1.isNumber(x)) {
            if (return_synthetic) {
                return x;
            }
            else {
                return CategoricalMapper.__super__.map_to_target.call(this, x);
            }
        }
        range = this.source_range;
        factors = range.factors;
        if (x.indexOf(':') >= 0) {
            ref = x.split(':'), factor = ref[0], percent = ref[1];
            percent = parseFloat(percent);
            result = factors.indexOf(factor) + 0.5 + range.offset + percent;
        }
        else {
            result = factors.indexOf(x) + 1 + range.offset;
        }
        if (return_synthetic) {
            return result;
        }
        else {
            return CategoricalMapper.__super__.map_to_target.call(this, result);
        }
    };
    CategoricalMapper.prototype.v_map_to_target = function (xs, return_synthetic) {
        var factor, factors, i, j, percent, range, ref, ref1, results, x;
        if (return_synthetic == null) {
            return_synthetic = false;
        }
        if (types_1.isNumber(xs[0])) {
            if (return_synthetic) {
                return xs;
            }
            else {
                return CategoricalMapper.__super__.v_map_to_target.call(this, xs);
            }
        }
        range = this.source_range;
        factors = range.factors;
        results = Array(xs.length);
        for (i = j = 0, ref = xs.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            x = xs[i];
            if (x.indexOf(':') >= 0) {
                ref1 = x.split(':'), factor = ref1[0], percent = ref1[1];
                percent = parseFloat(percent);
                results[i] = factors.indexOf(factor) + 0.5 + range.offset + percent;
            }
            else {
                results[i] = factors.indexOf(x) + 1 + range.offset;
            }
        }
        if (return_synthetic) {
            return results;
        }
        else {
            return CategoricalMapper.__super__.v_map_to_target.call(this, results);
        }
    };
    CategoricalMapper.prototype.map_from_target = function (xprime, skip_cat) {
        var factors, range;
        if (skip_cat == null) {
            skip_cat = false;
        }
        xprime = CategoricalMapper.__super__.map_from_target.call(this, xprime);
        if (skip_cat) {
            return xprime;
        }
        range = this.source_range;
        factors = range.factors;
        return factors[Math.floor(xprime - 0.5 - range.offset)];
    };
    CategoricalMapper.prototype.v_map_from_target = function (xprimes, skip_cat) {
        var factors, i, j, k, range, ref, ref1, result, x;
        if (skip_cat == null) {
            skip_cat = false;
        }
        x = CategoricalMapper.__super__.v_map_from_target.call(this, xprimes);
        for (i = j = 0, ref = x.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            x[i] = x[i];
        }
        if (skip_cat) {
            return x;
        }
        result = Array(x);
        range = this.source_range;
        factors = range.factors;
        for (i = k = 0, ref1 = xprimes.length; 0 <= ref1 ? k < ref1 : k > ref1; i = 0 <= ref1 ? ++k : --k) {
            result[i] = factors[Math.floor(x[i] - 0.5 - range.offset)];
        }
        return result;
    };
    return CategoricalMapper;
})(linear_mapper_1.LinearMapper);

},{"./linear_mapper":"models/mappers/linear_mapper","core/util/types":"core/util/types"}],"models/mappers/color_mapper":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var p = require("core/properties");
var model_1 = require("../../model");
var types_1 = require("core/util/types");
exports.ColorMapper = (function (superClass) {
    extend(ColorMapper, superClass);
    function ColorMapper() {
        return ColorMapper.__super__.constructor.apply(this, arguments);
    }
    ColorMapper.prototype.type = "ColorMapper";
    ColorMapper.define({
        palette: [p.Any],
        nan_color: [p.Color, "gray"]
    });
    ColorMapper.prototype.initialize = function (attrs, options) {
        ColorMapper.__super__.initialize.call(this, attrs, options);
        this._little_endian = this._is_little_endian();
        this._palette = this._build_palette(this.palette);
        return this.listenTo(this, 'change', function () {
            return this._palette = this._build_palette(this.palette);
        });
    };
    ColorMapper.prototype.v_map_screen = function (data, image_glyph) {
        var buf, color, i, j, k, ref, ref1, value, values;
        if (image_glyph == null) {
            image_glyph = false;
        }
        values = this._get_values(data, this._palette, image_glyph);
        buf = new ArrayBuffer(data.length * 4);
        color = new Uint32Array(buf);
        if (this._little_endian) {
            for (i = j = 0, ref = data.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                value = values[i];
                color[i] = (0xff << 24) | ((value & 0xff0000) >> 16) | (value & 0xff00) | ((value & 0xff) << 16);
            }
        }
        else {
            for (i = k = 0, ref1 = data.length; 0 <= ref1 ? k < ref1 : k > ref1; i = 0 <= ref1 ? ++k : --k) {
                value = values[i];
                color[i] = (value << 8) | 0xff;
            }
        }
        return buf;
    };
    ColorMapper.prototype.compute = function (x) {
        return null;
    };
    ColorMapper.prototype.v_compute = function (xs) {
        var values;
        values = this._get_values(xs, this.palette);
        return values;
    };
    ColorMapper.prototype._get_values = function (data, palette, image_glyph) {
        if (image_glyph == null) {
            image_glyph = false;
        }
        return [];
    };
    ColorMapper.prototype._is_little_endian = function () {
        var buf, buf32, buf8, little_endian;
        buf = new ArrayBuffer(4);
        buf8 = new Uint8Array(buf);
        buf32 = new Uint32Array(buf);
        buf32[1] = 0x0a0b0c0d;
        little_endian = true;
        if (buf8[4] === 0x0a && buf8[5] === 0x0b && buf8[6] === 0x0c && buf8[7] === 0x0d) {
            little_endian = false;
        }
        return little_endian;
    };
    ColorMapper.prototype._build_palette = function (palette) {
        var _convert, i, j, new_palette, ref;
        new_palette = new Uint32Array(palette.length);
        _convert = function (value) {
            if (types_1.isNumber(value)) {
                return value;
            }
            else {
                return parseInt(value.slice(1), 16);
            }
        };
        for (i = j = 0, ref = palette.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            new_palette[i] = _convert(palette[i]);
        }
        return new_palette;
    };
    return ColorMapper;
})(model_1.Model);

},{"../../model":"model","core/properties":"core/properties","core/util/types":"core/util/types"}],"models/mappers/grid_mapper":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var model_1 = require("../../model");
exports.GridMapper = (function (superClass) {
    extend(GridMapper, superClass);
    function GridMapper() {
        return GridMapper.__super__.constructor.apply(this, arguments);
    }
    GridMapper.prototype.map_to_target = function (x, y) {
        var xprime, yprime;
        xprime = this.domain_mapper.map_to_target(x);
        yprime = this.codomain_mapper.map_to_target(y);
        return [xprime, yprime];
    };
    GridMapper.prototype.v_map_to_target = function (xs, ys) {
        var xprimes, yprimes;
        xprimes = this.domain_mapper.v_map_to_target(xs);
        yprimes = this.codomain_mapper.v_map_to_target(ys);
        return [xprimes, yprimes];
    };
    GridMapper.prototype.map_from_target = function (xprime, yprime) {
        var x, y;
        x = this.domain_mapper.map_from_target(xprime);
        y = this.codomain_mapper.map_from_target(yprime);
        return [x, y];
    };
    GridMapper.prototype.v_map_from_target = function (xprimes, yprimes) {
        var xs, ys;
        xs = this.domain_mapper.v_map_from_target(xprimes);
        ys = this.codomain_mapper.v_map_from_target(yprimes);
        return [xs, ys];
    };
    return GridMapper;
})(model_1.Model);

},{"../../model":"model"}],"models/mappers/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var categorical_color_mapper_1 = require("./categorical_color_mapper");
exports.CategoricalColorMapper = categorical_color_mapper_1.CategoricalColorMapper;
var categorical_mapper_1 = require("./categorical_mapper");
exports.CategoricalMapper = categorical_mapper_1.CategoricalMapper;
var color_mapper_1 = require("./color_mapper");
exports.ColorMapper = color_mapper_1.ColorMapper;
var grid_mapper_1 = require("./grid_mapper");
exports.GridMapper = grid_mapper_1.GridMapper;
var linear_color_mapper_1 = require("./linear_color_mapper");
exports.LinearColorMapper = linear_color_mapper_1.LinearColorMapper;
var linear_mapper_1 = require("./linear_mapper");
exports.LinearMapper = linear_mapper_1.LinearMapper;
var log_color_mapper_1 = require("./log_color_mapper");
exports.LogColorMapper = log_color_mapper_1.LogColorMapper;
var log_mapper_1 = require("./log_mapper");
exports.LogMapper = log_mapper_1.LogMapper;

},{"./categorical_color_mapper":"models/mappers/categorical_color_mapper","./categorical_mapper":"models/mappers/categorical_mapper","./color_mapper":"models/mappers/color_mapper","./grid_mapper":"models/mappers/grid_mapper","./linear_color_mapper":"models/mappers/linear_color_mapper","./linear_mapper":"models/mappers/linear_mapper","./log_color_mapper":"models/mappers/log_color_mapper","./log_mapper":"models/mappers/log_mapper"}],"models/mappers/linear_color_mapper":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var p = require("core/properties");
var color_1 = require("core/util/color");
var array_1 = require("core/util/array");
var color_mapper_1 = require("./color_mapper");
exports.LinearColorMapper = (function (superClass) {
    extend(LinearColorMapper, superClass);
    function LinearColorMapper() {
        return LinearColorMapper.__super__.constructor.apply(this, arguments);
    }
    LinearColorMapper.prototype.type = "LinearColorMapper";
    LinearColorMapper.define({
        high: [p.Number],
        low: [p.Number],
        high_color: [p.Color],
        low_color: [p.Color]
    });
    LinearColorMapper.prototype.initialize = function (attrs, options) {
        LinearColorMapper.__super__.initialize.call(this, attrs, options);
        this._nan_color = this._build_palette([color_1.color2hex(this.nan_color)])[0];
        this._high_color = this.high_color != null ? this._build_palette([color_1.color2hex(this.high_color)])[0] : void 0;
        return this._low_color = this.low_color != null ? this._build_palette([color_1.color2hex(this.low_color)])[0] : void 0;
    };
    LinearColorMapper.prototype._get_values = function (data, palette, image_glyph) {
        var d, high, high_color, i, key, len, low, low_color, max_key, nan_color, norm_factor, normed_d, normed_interval, ref, ref1, values;
        if (image_glyph == null) {
            image_glyph = false;
        }
        low = (ref = this.low) != null ? ref : array_1.min(data);
        high = (ref1 = this.high) != null ? ref1 : array_1.max(data);
        max_key = palette.length - 1;
        values = [];
        nan_color = image_glyph ? this._nan_color : this.nan_color;
        low_color = image_glyph ? this._low_color : this.low_color;
        high_color = image_glyph ? this._high_color : this.high_color;
        norm_factor = 1 / (high - low);
        normed_interval = 1 / palette.length;
        for (i = 0, len = data.length; i < len; i++) {
            d = data[i];
            if (isNaN(d)) {
                values.push(nan_color);
                continue;
            }
            if (d === high) {
                values.push(palette[max_key]);
                continue;
            }
            normed_d = (d - low) * norm_factor;
            key = Math.floor(normed_d / normed_interval);
            if (key < 0) {
                if (this.low_color != null) {
                    values.push(low_color);
                }
                else {
                    values.push(palette[0]);
                }
            }
            else if (key > max_key) {
                if (this.high_color != null) {
                    values.push(high_color);
                }
                else {
                    values.push(palette[max_key]);
                }
            }
            else {
                values.push(palette[key]);
            }
        }
        return values;
    };
    return LinearColorMapper;
})(color_mapper_1.ColorMapper);

},{"./color_mapper":"models/mappers/color_mapper","core/properties":"core/properties","core/util/array":"core/util/array","core/util/color":"core/util/color"}],"models/mappers/linear_mapper":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var model_1 = require("../../model");
var p = require("core/properties");
exports.LinearMapper = (function (superClass) {
    extend(LinearMapper, superClass);
    function LinearMapper() {
        return LinearMapper.__super__.constructor.apply(this, arguments);
    }
    LinearMapper.prototype.initialize = function (attrs, options) {
        LinearMapper.__super__.initialize.call(this, attrs, options);
        this.define_computed_property('mapper_state', this._mapper_state, true);
        this.add_dependencies('mapper_state', this, ['source_range', 'target_range']);
        this.add_dependencies('mapper_state', this.source_range, ['start', 'end']);
        return this.add_dependencies('mapper_state', this.target_range, ['start', 'end']);
    };
    LinearMapper.getters({
        mapper_state: function () {
            return this._get_computed('mapper_state');
        }
    });
    LinearMapper.prototype.map_to_target = function (x) {
        var offset, ref, scale;
        ref = this.mapper_state, scale = ref[0], offset = ref[1];
        return scale * x + offset;
    };
    LinearMapper.prototype.v_map_to_target = function (xs) {
        var i, idx, len, offset, ref, result, scale, x;
        ref = this.mapper_state, scale = ref[0], offset = ref[1];
        result = new Float64Array(xs.length);
        for (idx = i = 0, len = xs.length; i < len; idx = ++i) {
            x = xs[idx];
            result[idx] = scale * x + offset;
        }
        return result;
    };
    LinearMapper.prototype.map_from_target = function (xprime) {
        var offset, ref, scale;
        ref = this.mapper_state, scale = ref[0], offset = ref[1];
        return (xprime - offset) / scale;
    };
    LinearMapper.prototype.v_map_from_target = function (xprimes) {
        var i, idx, len, offset, ref, result, scale, xprime;
        ref = this.mapper_state, scale = ref[0], offset = ref[1];
        result = new Float64Array(xprimes.length);
        for (idx = i = 0, len = xprimes.length; i < len; idx = ++i) {
            xprime = xprimes[idx];
            result[idx] = (xprime - offset) / scale;
        }
        return result;
    };
    LinearMapper.prototype._mapper_state = function () {
        var offset, scale, source_end, source_start, target_end, target_start;
        source_start = this.source_range.start;
        source_end = this.source_range.end;
        target_start = this.target_range.start;
        target_end = this.target_range.end;
        scale = (target_end - target_start) / (source_end - source_start);
        offset = -(scale * source_start) + target_start;
        return [scale, offset];
    };
    LinearMapper.internal({
        source_range: [p.Any],
        target_range: [p.Any]
    });
    return LinearMapper;
})(model_1.Model);

},{"../../model":"model","core/properties":"core/properties"}],"models/mappers/log_color_mapper":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var log1p, ref, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var p = require("core/properties");
var color_1 = require("core/util/color");
var array_1 = require("core/util/array");
var color_mapper_1 = require("./color_mapper");
log1p = (ref = Math.log1p) != null ? ref : function (x) {
    return Math.log(1 + x);
};
exports.LogColorMapper = (function (superClass) {
    extend(LogColorMapper, superClass);
    function LogColorMapper() {
        return LogColorMapper.__super__.constructor.apply(this, arguments);
    }
    LogColorMapper.prototype.type = "LogColorMapper";
    LogColorMapper.define({
        high: [p.Number],
        low: [p.Number],
        high_color: [p.Color],
        low_color: [p.Color]
    });
    LogColorMapper.prototype.initialize = function (attrs, options) {
        LogColorMapper.__super__.initialize.call(this, attrs, options);
        this._nan_color = this._build_palette([color_1.color2hex(this.nan_color)])[0];
        this._high_color = this.high_color != null ? this._build_palette([color_1.color2hex(this.high_color)])[0] : void 0;
        return this._low_color = this.low_color != null ? this._build_palette([color_1.color2hex(this.low_color)])[0] : void 0;
    };
    LogColorMapper.prototype._get_values = function (data, palette, image_glyph) {
        var d, high, high_color, i, key, len, log, low, low_color, max_key, n, nan_color, ref1, ref2, scale, values;
        if (image_glyph == null) {
            image_glyph = false;
        }
        n = palette.length;
        low = (ref1 = this.low) != null ? ref1 : array_1.min(data);
        high = (ref2 = this.high) != null ? ref2 : array_1.max(data);
        scale = n / (log1p(high) - log1p(low));
        max_key = palette.length - 1;
        values = [];
        nan_color = image_glyph ? this._nan_color : this.nan_color;
        high_color = image_glyph ? this._high_color : this.high_color;
        low_color = image_glyph ? this._low_color : this.low_color;
        for (i = 0, len = data.length; i < len; i++) {
            d = data[i];
            if (isNaN(d)) {
                values.push(nan_color);
                continue;
            }
            if (d > high) {
                if (this.high_color != null) {
                    values.push(high_color);
                }
                else {
                    values.push(palette[max_key]);
                }
                continue;
            }
            if (d === high) {
                values.push(palette[max_key]);
                continue;
            }
            if (d < low) {
                if (this.low_color != null) {
                    values.push(low_color);
                }
                else {
                    values.push(palette[0]);
                }
                continue;
            }
            log = log1p(d) - log1p(low);
            key = Math.floor(log * scale);
            if (key > max_key) {
                key = max_key;
            }
            values.push(palette[key]);
        }
        return values;
    };
    return LogColorMapper;
})(color_mapper_1.ColorMapper);

},{"./color_mapper":"models/mappers/color_mapper","core/properties":"core/properties","core/util/array":"core/util/array","core/util/color":"core/util/color"}],"models/mappers/log_mapper":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var model_1 = require("../../model");
var p = require("core/properties");
exports.LogMapper = (function (superClass) {
    extend(LogMapper, superClass);
    function LogMapper() {
        return LogMapper.__super__.constructor.apply(this, arguments);
    }
    LogMapper.prototype.initialize = function (attrs, options) {
        LogMapper.__super__.initialize.call(this, attrs, options);
        this.define_computed_property('mapper_state', this._mapper_state, true);
        this.add_dependencies('mapper_state', this, ['source_range', 'target_range']);
        this.add_dependencies('mapper_state', this.source_range, ['start', 'end']);
        return this.add_dependencies('mapper_state', this.target_range, ['start', 'end']);
    };
    LogMapper.getters({
        mapper_state: function () {
            return this._get_computed('mapper_state');
        }
    });
    LogMapper.prototype.map_to_target = function (x) {
        var inter_offset, inter_scale, offset, ref, scale, value;
        ref = this.mapper_state, scale = ref[0], offset = ref[1], inter_scale = ref[2], inter_offset = ref[3];
        if (inter_scale === 0) {
            value = 0;
        }
        else {
            value = (Math.log(x) - inter_offset) / inter_scale;
            if (isNaN(value) || !isFinite(value)) {
                value = 0;
            }
        }
        return value * scale + offset;
    };
    LogMapper.prototype.v_map_to_target = function (xs) {
        var i, inter_offset, inter_scale, j, k, l, offset, ref, ref1, ref2, ref3, result, scale, value;
        ref = this.mapper_state, scale = ref[0], offset = ref[1], inter_scale = ref[2], inter_offset = ref[3];
        result = new Float64Array(xs.length);
        if (inter_scale === 0) {
            for (i = j = 0, ref1 = xs.length; 0 <= ref1 ? j < ref1 : j > ref1; i = 0 <= ref1 ? ++j : --j) {
                result[i] = 0;
            }
        }
        else {
            for (i = k = 0, ref2 = xs.length; 0 <= ref2 ? k < ref2 : k > ref2; i = 0 <= ref2 ? ++k : --k) {
                value = (Math.log(xs[i]) - inter_offset) / inter_scale;
                if (isNaN(value) || !isFinite(value)) {
                    result[i] = 0;
                }
                else {
                    result[i] = value;
                }
            }
        }
        for (i = l = 0, ref3 = xs.length; 0 <= ref3 ? l < ref3 : l > ref3; i = 0 <= ref3 ? ++l : --l) {
            result[i] = result[i] * scale + offset;
        }
        return result;
    };
    LogMapper.prototype.map_from_target = function (xprime) {
        var inter_offset, inter_scale, offset, ref, scale, value;
        ref = this.mapper_state, scale = ref[0], offset = ref[1], inter_scale = ref[2], inter_offset = ref[3];
        value = (xprime - offset) / scale;
        return Math.exp(inter_scale * value + inter_offset);
    };
    LogMapper.prototype.v_map_from_target = function (xprimes) {
        var i, inter_offset, inter_scale, j, offset, ref, ref1, result, scale, value;
        ref = this.mapper_state, scale = ref[0], offset = ref[1], inter_scale = ref[2], inter_offset = ref[3];
        result = new Float64Array(xprimes.length);
        for (i = j = 0, ref1 = xprimes.length; 0 <= ref1 ? j < ref1 : j > ref1; i = 0 <= ref1 ? ++j : --j) {
            value = (xprimes[i] - offset) / scale;
            result[i] = Math.exp(inter_scale * value + inter_offset);
        }
        return result;
    };
    LogMapper.prototype._get_safe_scale = function (orig_start, orig_end) {
        var end, log_val, ref, start;
        if (orig_start < 0) {
            start = 0;
        }
        else {
            start = orig_start;
        }
        if (orig_end < 0) {
            end = 0;
        }
        else {
            end = orig_end;
        }
        if (start === end) {
            if (start === 0) {
                ref = [1, 10], start = ref[0], end = ref[1];
            }
            else {
                log_val = Math.log(start) / Math.log(10);
                start = Math.pow(10, Math.floor(log_val));
                if (Math.ceil(log_val) !== Math.floor(log_val)) {
                    end = Math.pow(10, Math.ceil(log_val));
                }
                else {
                    end = Math.pow(10, Math.ceil(log_val) + 1);
                }
            }
        }
        return [start, end];
    };
    LogMapper.prototype._mapper_state = function () {
        var end, inter_offset, inter_scale, offset, ref, scale, screen_range, source_end, source_start, start, target_end, target_start;
        source_start = this.source_range.start;
        source_end = this.source_range.end;
        target_start = this.target_range.start;
        target_end = this.target_range.end;
        screen_range = target_end - target_start;
        ref = this._get_safe_scale(source_start, source_end), start = ref[0], end = ref[1];
        if (start === 0) {
            inter_scale = Math.log(end);
            inter_offset = 0;
        }
        else {
            inter_scale = Math.log(end) - Math.log(start);
            inter_offset = Math.log(start);
        }
        scale = screen_range;
        offset = target_start;
        return [scale, offset, inter_scale, inter_offset];
    };
    LogMapper.internal({
        source_range: [p.Any],
        target_range: [p.Any]
    });
    return LogMapper;
})(model_1.Model);

},{"../../model":"model","core/properties":"core/properties"}],"models/markers/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var SQ3, _mk_model, _one_cross, _one_diamond, _one_tri, _one_x, asterisk, circle_cross, circle_x, cross, diamond, diamond_cross, inverted_triangle, square, square_cross, square_x, triangle, x, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var marker_1 = require("./marker");
SQ3 = Math.sqrt(3);
_one_x = function (ctx, r) {
    ctx.moveTo(-r, r);
    ctx.lineTo(r, -r);
    ctx.moveTo(-r, -r);
    return ctx.lineTo(r, r);
};
_one_cross = function (ctx, r) {
    ctx.moveTo(0, r);
    ctx.lineTo(0, -r);
    ctx.moveTo(-r, 0);
    return ctx.lineTo(r, 0);
};
_one_diamond = function (ctx, r) {
    ctx.moveTo(0, r);
    ctx.lineTo(r / 1.5, 0);
    ctx.lineTo(0, -r);
    ctx.lineTo(-r / 1.5, 0);
    return ctx.closePath();
};
_one_tri = function (ctx, r) {
    var a, h;
    h = r * SQ3;
    a = h / 3;
    ctx.moveTo(-r, a);
    ctx.lineTo(r, a);
    ctx.lineTo(0, a - h);
    return ctx.closePath();
};
asterisk = function (ctx, i, sx, sy, r, line, fill) {
    var r2;
    r2 = r * 0.65;
    _one_cross(ctx, r);
    _one_x(ctx, r2);
    if (line.doit) {
        line.set_vectorize(ctx, i);
        ctx.stroke();
    }
};
circle_cross = function (ctx, i, sx, sy, r, line, fill) {
    ctx.arc(0, 0, r, 0, 2 * Math.PI, false);
    if (fill.doit) {
        fill.set_vectorize(ctx, i);
        ctx.fill();
    }
    if (line.doit) {
        line.set_vectorize(ctx, i);
        _one_cross(ctx, r);
        ctx.stroke();
    }
};
circle_x = function (ctx, i, sx, sy, r, line, fill) {
    ctx.arc(0, 0, r, 0, 2 * Math.PI, false);
    if (fill.doit) {
        fill.set_vectorize(ctx, i);
        ctx.fill();
    }
    if (line.doit) {
        line.set_vectorize(ctx, i);
        _one_x(ctx, r);
        ctx.stroke();
    }
};
cross = function (ctx, i, sx, sy, r, line, fill) {
    _one_cross(ctx, r);
    if (line.doit) {
        line.set_vectorize(ctx, i);
        ctx.stroke();
    }
};
diamond = function (ctx, i, sx, sy, r, line, fill) {
    _one_diamond(ctx, r);
    if (fill.doit) {
        fill.set_vectorize(ctx, i);
        ctx.fill();
    }
    if (line.doit) {
        line.set_vectorize(ctx, i);
        ctx.stroke();
    }
};
diamond_cross = function (ctx, i, sx, sy, r, line, fill) {
    _one_diamond(ctx, r);
    if (fill.doit) {
        fill.set_vectorize(ctx, i);
        ctx.fill();
    }
    if (line.doit) {
        line.set_vectorize(ctx, i);
        _one_cross(ctx, r);
        ctx.stroke();
    }
};
inverted_triangle = function (ctx, i, sx, sy, r, line, fill) {
    ctx.rotate(Math.PI);
    _one_tri(ctx, r);
    ctx.rotate(-Math.PI);
    if (fill.doit) {
        fill.set_vectorize(ctx, i);
        ctx.fill();
    }
    if (line.doit) {
        line.set_vectorize(ctx, i);
        ctx.stroke();
    }
};
square = function (ctx, i, sx, sy, r, line, fill) {
    var size;
    size = 2 * r;
    ctx.rect(-r, -r, size, size);
    if (fill.doit) {
        fill.set_vectorize(ctx, i);
        ctx.fill();
    }
    if (line.doit) {
        line.set_vectorize(ctx, i);
        ctx.stroke();
    }
};
square_cross = function (ctx, i, sx, sy, r, line, fill) {
    var size;
    size = 2 * r;
    ctx.rect(-r, -r, size, size);
    if (fill.doit) {
        fill.set_vectorize(ctx, i);
        ctx.fill();
    }
    if (line.doit) {
        line.set_vectorize(ctx, i);
        _one_cross(ctx, r);
        ctx.stroke();
    }
};
square_x = function (ctx, i, sx, sy, r, line, fill) {
    var size;
    size = 2 * r;
    ctx.rect(-r, -r, size, size);
    if (fill.doit) {
        fill.set_vectorize(ctx, i);
        ctx.fill();
    }
    if (line.doit) {
        line.set_vectorize(ctx, i);
        _one_x(ctx, r);
        ctx.stroke();
    }
};
triangle = function (ctx, i, sx, sy, r, line, fill) {
    _one_tri(ctx, r);
    if (fill.doit) {
        fill.set_vectorize(ctx, i);
        ctx.fill();
    }
    if (line.doit) {
        line.set_vectorize(ctx, i);
        ctx.stroke();
    }
};
x = function (ctx, i, sx, sy, r, line, fill) {
    _one_x(ctx, r);
    if (line.doit) {
        line.set_vectorize(ctx, i);
        ctx.stroke();
    }
};
_mk_model = function (type, f) {
    var model, view;
    view = (function (superClass) {
        extend(view, superClass);
        function view() {
            return view.__super__.constructor.apply(this, arguments);
        }
        view.prototype._render_one = f;
        return view;
    })(marker_1.MarkerView);
    model = (function (superClass) {
        extend(model, superClass);
        function model() {
            return model.__super__.constructor.apply(this, arguments);
        }
        model.prototype.default_view = view;
        model.prototype.type = type;
        return model;
    })(marker_1.Marker);
    return model;
};
exports.Asterisk = _mk_model('Asterisk', asterisk);
exports.CircleCross = _mk_model('CircleCross', circle_cross);
exports.CircleX = _mk_model('CircleX', circle_x);
exports.Cross = _mk_model('Cross', cross);
exports.Diamond = _mk_model('Diamond', diamond);
exports.DiamondCross = _mk_model('DiamondCross', diamond_cross);
exports.InvertedTriangle = _mk_model('InvertedTriangle', inverted_triangle);
exports.Square = _mk_model('Square', square);
exports.SquareCross = _mk_model('SquareCross', square_cross);
exports.SquareX = _mk_model('SquareX', square_x);
exports.Triangle = _mk_model('Triangle', triangle);
exports.X = _mk_model('X', x);

},{"./marker":"models/markers/marker"}],"models/markers/marker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var xy_glyph_1 = require("../glyphs/xy_glyph");
var hittest = require("core/hittest");
var p = require("core/properties");
exports.MarkerView = (function (superClass) {
    extend(MarkerView, superClass);
    function MarkerView() {
        return MarkerView.__super__.constructor.apply(this, arguments);
    }
    MarkerView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
        var angle, data, indices, size, sx, sy;
        indices = [index];
        sx = {};
        sx[index] = (x0 + x1) / 2;
        sy = {};
        sy[index] = (y0 + y1) / 2;
        size = {};
        size[index] = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.4;
        angle = {};
        angle[index] = this._angle[index];
        data = {
            sx: sx,
            sy: sy,
            _size: size,
            _angle: angle
        };
        return this._render(ctx, indices, data);
    };
    MarkerView.prototype._render = function (ctx, indices, arg) {
        var _angle, _size, i, j, len, r, results, sx, sy;
        sx = arg.sx, sy = arg.sy, _size = arg._size, _angle = arg._angle;
        results = [];
        for (j = 0, len = indices.length; j < len; j++) {
            i = indices[j];
            if (isNaN(sx[i] + sy[i] + _size[i] + _angle[i])) {
                continue;
            }
            r = _size[i] / 2;
            ctx.beginPath();
            ctx.translate(sx[i], sy[i]);
            if (_angle[i]) {
                ctx.rotate(_angle[i]);
            }
            this._render_one(ctx, i, sx[i], sy[i], r, this.visuals.line, this.visuals.fill);
            if (_angle[i]) {
                ctx.rotate(-_angle[i]);
            }
            results.push(ctx.translate(-sx[i], -sy[i]));
        }
        return results;
    };
    MarkerView.prototype._mask_data = function (all_indices) {
        var bbox, hr, ref, ref1, vr, vx0, vx1, vy0, vy1, x0, x1, y0, y1;
        hr = this.renderer.plot_view.frame.h_range;
        vx0 = hr.start - this.max_size;
        vx1 = hr.end + this.max_size;
        ref = this.renderer.xmapper.v_map_from_target([vx0, vx1], true), x0 = ref[0], x1 = ref[1];
        vr = this.renderer.plot_view.frame.v_range;
        vy0 = vr.start - this.max_size;
        vy1 = vr.end + this.max_size;
        ref1 = this.renderer.ymapper.v_map_from_target([vy0, vy1], true), y0 = ref1[0], y1 = ref1[1];
        bbox = hittest.validate_bbox_coords([x0, x1], [y0, y1]);
        return this.index.indices(bbox);
    };
    MarkerView.prototype._hit_point = function (geometry) {
        var bbox, candidates, dist, hits, i, j, len, ref, ref1, ref2, s2, sx, sy, vx, vx0, vx1, vy, vy0, vy1, x0, x1, y0, y1;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        sx = this.renderer.plot_view.canvas.vx_to_sx(vx);
        sy = this.renderer.plot_view.canvas.vy_to_sy(vy);
        vx0 = vx - this.max_size;
        vx1 = vx + this.max_size;
        ref1 = this.renderer.xmapper.v_map_from_target([vx0, vx1], true), x0 = ref1[0], x1 = ref1[1];
        vy0 = vy - this.max_size;
        vy1 = vy + this.max_size;
        ref2 = this.renderer.ymapper.v_map_from_target([vy0, vy1], true), y0 = ref2[0], y1 = ref2[1];
        bbox = hittest.validate_bbox_coords([x0, x1], [y0, y1]);
        candidates = this.index.indices(bbox);
        hits = [];
        for (j = 0, len = candidates.length; j < len; j++) {
            i = candidates[j];
            s2 = this._size[i] / 2;
            dist = Math.abs(this.sx[i] - sx) + Math.abs(this.sy[i] - sy);
            if (Math.abs(this.sx[i] - sx) <= s2 && Math.abs(this.sy[i] - sy) <= s2) {
                hits.push([i, dist]);
            }
        }
        return hittest.create_1d_hit_test_result(hits);
    };
    MarkerView.prototype._hit_rect = function (geometry) {
        var bbox, ref, ref1, result, x0, x1, y0, y1;
        ref = this.renderer.xmapper.v_map_from_target([geometry.vx0, geometry.vx1], true), x0 = ref[0], x1 = ref[1];
        ref1 = this.renderer.ymapper.v_map_from_target([geometry.vy0, geometry.vy1], true), y0 = ref1[0], y1 = ref1[1];
        bbox = hittest.validate_bbox_coords([x0, x1], [y0, y1]);
        result = hittest.create_hit_test_result();
        result['1d'].indices = this.index.indices(bbox);
        return result;
    };
    MarkerView.prototype._hit_poly = function (geometry) {
        var candidates, hits, i, idx, j, k, ref, ref1, ref2, result, results, sx, sy, vx, vy;
        ref = [geometry.vx, geometry.vy], vx = ref[0], vy = ref[1];
        sx = this.renderer.plot_view.canvas.v_vx_to_sx(vx);
        sy = this.renderer.plot_view.canvas.v_vy_to_sy(vy);
        candidates = (function () {
            results = [];
            for (var j = 0, ref1 = this.sx.length; 0 <= ref1 ? j < ref1 : j > ref1; 0 <= ref1 ? j++ : j--) {
                results.push(j);
            }
            return results;
        }).apply(this);
        hits = [];
        for (i = k = 0, ref2 = candidates.length; 0 <= ref2 ? k < ref2 : k > ref2; i = 0 <= ref2 ? ++k : --k) {
            idx = candidates[i];
            if (hittest.point_in_poly(this.sx[i], this.sy[i], sx, sy)) {
                hits.push(idx);
            }
        }
        result = hittest.create_hit_test_result();
        result['1d'].indices = hits;
        return result;
    };
    return MarkerView;
})(xy_glyph_1.XYGlyphView);
exports.Marker = (function (superClass) {
    extend(Marker, superClass);
    function Marker() {
        return Marker.__super__.constructor.apply(this, arguments);
    }
    Marker.mixins(['line', 'fill']);
    Marker.define({
        size: [
            p.DistanceSpec, {
                units: "screen",
                value: 4
            }
        ],
        angle: [p.AngleSpec, 0]
    });
    return Marker;
})(xy_glyph_1.XYGlyph);

},{"../glyphs/xy_glyph":"models/glyphs/xy_glyph","core/hittest":"core/hittest","core/properties":"core/properties"}],"models/plots/gmap_plot":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var logging_1 = require("core/logging");
var gmap_plot_canvas_1 = require("./gmap_plot_canvas");
var plot_1 = require("./plot");
var p = require("core/properties");
var model_1 = require("../../model");
exports.MapOptions = (function (superClass) {
    extend(MapOptions, superClass);
    function MapOptions() {
        return MapOptions.__super__.constructor.apply(this, arguments);
    }
    MapOptions.prototype.type = 'MapOptions';
    MapOptions.define({
        lat: [p.Number],
        lng: [p.Number],
        zoom: [p.Number, 12]
    });
    return MapOptions;
})(model_1.Model);
exports.GMapOptions = (function (superClass) {
    extend(GMapOptions, superClass);
    function GMapOptions() {
        return GMapOptions.__super__.constructor.apply(this, arguments);
    }
    GMapOptions.prototype.type = 'GMapOptions';
    GMapOptions.define({
        map_type: [p.String, "roadmap"],
        scale_control: [p.Bool, false],
        styles: [p.String]
    });
    return GMapOptions;
})(exports.MapOptions);
exports.GMapPlotView = (function (superClass) {
    extend(GMapPlotView, superClass);
    function GMapPlotView() {
        return GMapPlotView.__super__.constructor.apply(this, arguments);
    }
    return GMapPlotView;
})(plot_1.PlotView);
exports.GMapPlot = (function (superClass) {
    extend(GMapPlot, superClass);
    function GMapPlot() {
        return GMapPlot.__super__.constructor.apply(this, arguments);
    }
    GMapPlot.prototype.type = 'GMapPlot';
    GMapPlot.prototype.default_view = exports.GMapPlotView;
    GMapPlot.prototype.initialize = function (options) {
        GMapPlot.__super__.initialize.call(this, options);
        if (!this.api_key) {
            logging_1.logger.error("api_key is required. See https://developers.google.com/maps/documentation/javascript/get-api-key for more information on how to obtain your own.");
        }
        this._plot_canvas = new gmap_plot_canvas_1.GMapPlotCanvas({
            plot: this
        });
        return this.plot_canvas.toolbar = this.toolbar;
    };
    GMapPlot.define({
        map_options: [p.Instance],
        api_key: [p.String]
    });
    return GMapPlot;
})(plot_1.Plot);

},{"../../model":"model","./gmap_plot_canvas":"models/plots/gmap_plot_canvas","./plot":"models/plots/plot","core/logging":"core/logging","core/properties":"core/properties"}],"models/plots/gmap_plot_canvas":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var load_google_api, bind = function (fn, me) { return function () { return fn.apply(me, arguments); }; }, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var proj4_1 = require("core/util/proj4");
var plot_canvas_1 = require("./plot_canvas");
load_google_api = function (callback, api_key) {
    var ref, script;
    if (((ref = window.google) != null ? ref.maps : void 0) == null) {
        window._bokeh_gmap_callback = function () {
            return callback();
        };
        script = document.createElement('script');
        script.type = 'text/javascript';
        script.src = "https://maps.googleapis.com/maps/api/js?key=" + api_key + "&callback=_bokeh_gmap_callback";
        return document.body.appendChild(script);
    }
};
exports.GMapPlotCanvasView = (function (superClass) {
    extend(GMapPlotCanvasView, superClass);
    function GMapPlotCanvasView() {
        this._set_bokeh_ranges = bind(this._set_bokeh_ranges, this);
        this._get_projected_bounds = bind(this._get_projected_bounds, this);
        this._get_latlon_bounds = bind(this._get_latlon_bounds, this);
        return GMapPlotCanvasView.__super__.constructor.apply(this, arguments);
    }
    GMapPlotCanvasView.prototype.initialize = function (options) {
        var mo;
        GMapPlotCanvasView.__super__.initialize.call(this, options);
        this.zoom_count = 0;
        mo = this.model.plot.map_options;
        this.initial_zoom = mo.zoom;
        this.initial_lat = mo.lat;
        this.initial_lng = mo.lng;
        this.canvas_view.map_div.style.position = "absolute";
        return load_google_api(this.request_render, this.model.plot.api_key);
    };
    GMapPlotCanvasView.prototype.update_range = function (range_info) {
        var mo, new_map_zoom, old_map_zoom, proj_xend, proj_xstart, proj_yend, proj_ystart, ref, zoom_change;
        if (range_info == null) {
            mo = this.model.plot.map_options;
            this.map.setCenter({
                lat: this.initial_lat,
                lng: this.initial_lng
            });
            this.map.setOptions({
                zoom: this.initial_zoom
            });
            GMapPlotCanvasView.__super__.update_range.call(this, null);
        }
        else if ((range_info.sdx != null) || (range_info.sdy != null)) {
            this.map.panBy(range_info.sdx, range_info.sdy);
            GMapPlotCanvasView.__super__.update_range.call(this, range_info);
        }
        else if (range_info.factor != null) {
            this.pause();
            if (this.zoom_count !== 10) {
                this.zoom_count += 1;
                return;
            }
            this.zoom_count = 0;
            GMapPlotCanvasView.__super__.update_range.call(this, range_info);
            if (range_info.factor < 0) {
                zoom_change = -1;
            }
            else {
                zoom_change = 1;
            }
            old_map_zoom = this.map.getZoom();
            new_map_zoom = old_map_zoom + zoom_change;
            if (new_map_zoom >= 2) {
                this.map.setZoom(new_map_zoom);
                ref = this._get_projected_bounds(), proj_xstart = ref[0], proj_xend = ref[1], proj_ystart = ref[2], proj_yend = ref[3];
                if ((proj_xend - proj_xstart) < 0) {
                    this.map.setZoom(old_map_zoom);
                }
            }
            this.unpause();
        }
        return this._set_bokeh_ranges();
    };
    GMapPlotCanvasView.prototype._build_map = function () {
        var map_options, maps, mo;
        maps = window.google.maps;
        this.map_types = {
            satellite: maps.MapTypeId.SATELLITE,
            terrain: maps.MapTypeId.TERRAIN,
            roadmap: maps.MapTypeId.ROADMAP,
            hybrid: maps.MapTypeId.HYBRID
        };
        mo = this.model.plot.map_options;
        map_options = {
            center: new maps.LatLng(mo.lat, mo.lng),
            zoom: mo.zoom,
            disableDefaultUI: true,
            mapTypeId: this.map_types[mo.map_type],
            scaleControl: mo.scale_control
        };
        if (mo.styles != null) {
            map_options.styles = JSON.parse(mo.styles);
        }
        this.map = new maps.Map(this.canvas_view.map_div, map_options);
        maps.event.addListenerOnce(this.map, 'idle', this._set_bokeh_ranges);
        this.listenTo(this.model.plot, 'change:map_options', (function (_this) {
            return function () {
                return _this._update_options();
            };
        })(this));
        this.listenTo(this.model.plot.map_options, 'change:styles', (function (_this) {
            return function () {
                return _this._update_styles();
            };
        })(this));
        this.listenTo(this.model.plot.map_options, 'change:lat', (function (_this) {
            return function () {
                return _this._update_center('lat');
            };
        })(this));
        this.listenTo(this.model.plot.map_options, 'change:lng', (function (_this) {
            return function () {
                return _this._update_center('lng');
            };
        })(this));
        this.listenTo(this.model.plot.map_options, 'change:zoom', (function (_this) {
            return function () {
                return _this._update_zoom();
            };
        })(this));
        this.listenTo(this.model.plot.map_options, 'change:map_type', (function (_this) {
            return function () {
                return _this._update_map_type();
            };
        })(this));
        return this.listenTo(this.model.plot.map_options, 'change:scale_control', (function (_this) {
            return function () {
                return _this._update_scale_control();
            };
        })(this));
    };
    GMapPlotCanvasView.prototype._get_latlon_bounds = function () {
        var bottom_left, bounds, top_right, xend, xstart, yend, ystart;
        bounds = this.map.getBounds();
        top_right = bounds.getNorthEast();
        bottom_left = bounds.getSouthWest();
        xstart = bottom_left.lng();
        xend = top_right.lng();
        ystart = bottom_left.lat();
        yend = top_right.lat();
        return [xstart, xend, ystart, yend];
    };
    GMapPlotCanvasView.prototype._get_projected_bounds = function () {
        var proj_xend, proj_xstart, proj_yend, proj_ystart, ref, ref1, ref2, xend, xstart, yend, ystart;
        ref = this._get_latlon_bounds(), xstart = ref[0], xend = ref[1], ystart = ref[2], yend = ref[3];
        ref1 = proj4_1.proj4(proj4_1.mercator, [xstart, ystart]), proj_xstart = ref1[0], proj_ystart = ref1[1];
        ref2 = proj4_1.proj4(proj4_1.mercator, [xend, yend]), proj_xend = ref2[0], proj_yend = ref2[1];
        return [proj_xstart, proj_xend, proj_ystart, proj_yend];
    };
    GMapPlotCanvasView.prototype._set_bokeh_ranges = function () {
        var proj_xend, proj_xstart, proj_yend, proj_ystart, ref;
        ref = this._get_projected_bounds(), proj_xstart = ref[0], proj_xend = ref[1], proj_ystart = ref[2], proj_yend = ref[3];
        this.x_range.setv({
            start: proj_xstart,
            end: proj_xend
        });
        return this.y_range.setv({
            start: proj_ystart,
            end: proj_yend
        });
    };
    GMapPlotCanvasView.prototype._update_center = function (fld) {
        var c;
        c = this.map.getCenter().toJSON();
        c[fld] = this.model.plot.map_options[fld];
        this.map.setCenter(c);
        return this._set_bokeh_ranges();
    };
    GMapPlotCanvasView.prototype._update_map_type = function () {
        var maps;
        maps = window.google.maps;
        return this.map.setOptions({
            mapTypeId: this.map_types[this.model.plot.map_options.map_type]
        });
    };
    GMapPlotCanvasView.prototype._update_scale_control = function () {
        var maps;
        maps = window.google.maps;
        return this.map.setOptions({
            scaleControl: this.model.plot.map_options.scale_control
        });
    };
    GMapPlotCanvasView.prototype._update_options = function () {
        this._update_styles();
        this._update_center('lat');
        this._update_center('lng');
        this._update_zoom();
        return this._update_map_type();
    };
    GMapPlotCanvasView.prototype._update_styles = function () {
        return this.map.setOptions({
            styles: JSON.parse(this.model.plot.map_options.styles)
        });
    };
    GMapPlotCanvasView.prototype._update_zoom = function () {
        this.map.setOptions({
            zoom: this.model.plot.map_options.zoom
        });
        return this._set_bokeh_ranges();
    };
    GMapPlotCanvasView.prototype._map_hook = function (ctx, frame_box) {
        var height, left, top, width;
        left = frame_box[0], top = frame_box[1], width = frame_box[2], height = frame_box[3];
        this.canvas_view.map_div.style.top = top + "px";
        this.canvas_view.map_div.style.left = left + "px";
        this.canvas_view.map_div.style.width = width + "px";
        this.canvas_view.map_div.style.height = height + "px";
        if (this.map == null) {
            return this._build_map();
        }
    };
    GMapPlotCanvasView.prototype._paint_empty = function (ctx, frame_box) {
        var ih, iw, left, oh, ow, top;
        ow = this.canvas.width;
        oh = this.canvas.height;
        left = frame_box[0], top = frame_box[1], iw = frame_box[2], ih = frame_box[3];
        ctx.clearRect(0, 0, ow, oh);
        ctx.beginPath();
        ctx.moveTo(0, 0);
        ctx.lineTo(0, oh);
        ctx.lineTo(ow, oh);
        ctx.lineTo(ow, 0);
        ctx.lineTo(0, 0);
        ctx.moveTo(left, top);
        ctx.lineTo(left + iw, top);
        ctx.lineTo(left + iw, top + ih);
        ctx.lineTo(left, top + ih);
        ctx.lineTo(left, top);
        ctx.closePath();
        ctx.fillStyle = this.model.plot.border_fill_color;
        return ctx.fill();
    };
    return GMapPlotCanvasView;
})(plot_canvas_1.PlotCanvasView);
exports.GMapPlotCanvas = (function (superClass) {
    extend(GMapPlotCanvas, superClass);
    function GMapPlotCanvas() {
        return GMapPlotCanvas.__super__.constructor.apply(this, arguments);
    }
    GMapPlotCanvas.prototype.type = 'GMapPlotCanvas';
    GMapPlotCanvas.prototype.default_view = exports.GMapPlotCanvasView;
    GMapPlotCanvas.prototype.initialize = function (attrs, options) {
        this.use_map = true;
        return GMapPlotCanvas.__super__.initialize.call(this, attrs, options);
    };
    return GMapPlotCanvas;
})(plot_canvas_1.PlotCanvas);

},{"./plot_canvas":"models/plots/plot_canvas","core/util/proj4":"core/util/proj4"}],"models/plots/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var gmap_plot_1 = require("./gmap_plot");
exports.MapOptions = gmap_plot_1.MapOptions;
var gmap_plot_2 = require("./gmap_plot");
exports.GMapOptions = gmap_plot_2.GMapOptions;
var gmap_plot_3 = require("./gmap_plot");
exports.GMapPlot = gmap_plot_3.GMapPlot;
var gmap_plot_canvas_1 = require("./gmap_plot_canvas");
exports.GMapPlotCanvas = gmap_plot_canvas_1.GMapPlotCanvas;
var plot_1 = require("./plot");
exports.Plot = plot_1.Plot;
var plot_canvas_1 = require("./plot_canvas");
exports.PlotCanvas = plot_canvas_1.PlotCanvas;

},{"./gmap_plot":"models/plots/gmap_plot","./gmap_plot_canvas":"models/plots/gmap_plot_canvas","./plot":"models/plots/plot","./plot_canvas":"models/plots/plot_canvas"}],"models/plots/plot":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend1 = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, slice = [].slice;
var solver_1 = require("core/layout/solver");
var logging_1 = require("core/logging");
var p = require("core/properties");
var object_1 = require("core/util/object");
var types_1 = require("core/util/types");
var layout_dom_1 = require("../layouts/layout_dom");
var title_1 = require("../annotations/title");
var toolbar_1 = require("../tools/toolbar");
var tool_events_1 = require("../tools/tool_events");
var plot_canvas_1 = require("./plot_canvas");
var column_data_source_1 = require("../sources/column_data_source");
var glyph_renderer_1 = require("../renderers/glyph_renderer");
var bokeh_events_1 = require("core/bokeh_events");
exports.PlotView = (function (superClass) {
    extend1(PlotView, superClass);
    function PlotView() {
        return PlotView.__super__.constructor.apply(this, arguments);
    }
    PlotView.prototype.className = "bk-plot-layout";
    PlotView.prototype.bind_bokeh_events = function () {
        var title_msg;
        PlotView.__super__.bind_bokeh_events.call(this);
        title_msg = "Title object cannot be replaced. Try changing properties on title to update it after initialization.";
        return this.listenTo(this.model, 'change:title', (function (_this) {
            return function () {
                return logging_1.logger.warn(title_msg);
            };
        })(this));
    };
    PlotView.prototype.render = function () {
        var height, ref, s, width;
        PlotView.__super__.render.call(this);
        if (this.model.sizing_mode === 'scale_both') {
            ref = this.get_width_height(), width = ref[0], height = ref[1];
            s = this.model.document.solver();
            s.suggest_value(this.model._width, width);
            s.suggest_value(this.model._height, height);
            this.el.style.position = 'absolute';
            this.el.style.left = this.model._dom_left._value + "px";
            this.el.style.top = this.model._dom_top._value + "px";
            this.el.style.width = (this.model._width.value()) + "px";
            return this.el.style.height = (this.model._height.value()) + "px";
        }
    };
    PlotView.prototype.get_width_height = function () {
        var ar, height, new_height_1, new_height_2, new_width_1, new_width_2, parent_height, parent_width, width;
        parent_height = this.el.parentNode.clientHeight;
        parent_width = this.el.parentNode.clientWidth;
        ar = this.model.get_aspect_ratio();
        new_width_1 = parent_width;
        new_height_1 = parent_width / ar;
        new_width_2 = parent_height * ar;
        new_height_2 = parent_height;
        if (new_width_1 < new_width_2) {
            width = new_width_1;
            height = new_height_1;
        }
        else {
            width = new_width_2;
            height = new_height_2;
        }
        return [width, height];
    };
    PlotView.prototype.get_height = function () {
        return this.model._width._value / this.model.get_aspect_ratio();
    };
    PlotView.prototype.get_width = function () {
        return this.model._height._value * this.model.get_aspect_ratio();
    };
    PlotView.prototype.save = function (name) {
        var view;
        return ((function () {
            var i, len, ref, results;
            ref = object_1.values(this.child_views);
            results = [];
            for (i = 0, len = ref.length; i < len; i++) {
                view = ref[i];
                if (view instanceof plot_canvas_1.PlotCanvasView) {
                    results.push(view);
                }
            }
            return results;
        }).call(this))[0].save(name);
    };
    return PlotView;
})(layout_dom_1.LayoutDOMView);
exports.Plot = (function (superClass) {
    extend1(Plot, superClass);
    function Plot() {
        return Plot.__super__.constructor.apply(this, arguments);
    }
    Plot.prototype.type = 'Plot';
    Plot.prototype.default_view = exports.PlotView;
    Plot.prototype.initialize = function (options) {
        var i, j, len, len1, plots, ref, ref1, ref2, title, xr, yr;
        Plot.__super__.initialize.call(this, options);
        ref = object_1.values(this.extra_x_ranges).concat(this.x_range);
        for (i = 0, len = ref.length; i < len; i++) {
            xr = ref[i];
            plots = xr.plots;
            if (types_1.isArray(plots)) {
                plots = plots.concat(this);
                xr.setv('plots', plots, {
                    silent: true
                });
            }
        }
        ref1 = object_1.values(this.extra_y_ranges).concat(this.y_range);
        for (j = 0, len1 = ref1.length; j < len1; j++) {
            yr = ref1[j];
            plots = yr.plots;
            if (types_1.isArray(plots)) {
                plots = plots.concat(this);
                yr.setv('plots', plots, {
                    silent: true
                });
            }
        }
        this._horizontal = false;
        if ((ref2 = this.toolbar_location) === 'left' || ref2 === 'right') {
            this._horizontal = true;
        }
        if (this.min_border != null) {
            if (this.min_border_top == null) {
                this.min_border_top = this.min_border;
            }
            if (this.min_border_bottom == null) {
                this.min_border_bottom = this.min_border;
            }
            if (this.min_border_left == null) {
                this.min_border_left = this.min_border;
            }
            if (this.min_border_right == null) {
                this.min_border_right = this.min_border;
            }
        }
        if (this.title != null) {
            title = types_1.isString(this.title) ? new title_1.Title({
                text: this.title
            }) : this.title;
            this.add_layout(title, this.title_location);
        }
        this._plot_canvas = new plot_canvas_1.PlotCanvas({
            plot: this
        });
        this.toolbar.toolbar_location = this.toolbar_location;
        this.toolbar.toolbar_sticky = this.toolbar_sticky;
        this.plot_canvas.toolbar = this.toolbar;
        if (this.width == null) {
            this.width = this.plot_width;
        }
        if (this.height == null) {
            return this.height = this.plot_height;
        }
    };
    Plot.getter("plot_canvas", function () {
        return this._plot_canvas;
    });
    Plot.prototype._doc_attached = function () {
        var i, j, layout_renderers, len, len1, r, ref, side;
        ref = ['above', 'below', 'left', 'right'];
        for (i = 0, len = ref.length; i < len; i++) {
            side = ref[i];
            layout_renderers = this.getv(side);
            for (j = 0, len1 = layout_renderers.length; j < len1; j++) {
                r = layout_renderers[j];
                this.plot_canvas.add_renderer_to_canvas_side(r, side);
            }
        }
        this.plot_canvas.attach_document(this.document);
        this._set_orientation_variables(this);
        this._set_orientation_variables(this.toolbar);
        this._set_orientation_variables(this.plot_canvas);
        return Plot.__super__._doc_attached.call(this);
    };
    Plot.prototype.add_renderers = function () {
        var new_renderers, renderers;
        new_renderers = 1 <= arguments.length ? slice.call(arguments, 0) : [];
        renderers = this.renderers;
        renderers = renderers.concat(new_renderers);
        return this.renderers = renderers;
    };
    Plot.prototype.add_layout = function (renderer, side) {
        var side_renderers;
        if (side == null) {
            side = "center";
        }
        if (renderer.props.plot != null) {
            renderer.plot = this;
        }
        this.add_renderers(renderer);
        if (side !== 'center') {
            side_renderers = this.getv(side);
            return side_renderers.push(renderer);
        }
    };
    Plot.prototype.add_glyph = function (glyph, source, attrs) {
        var renderer;
        if (attrs == null) {
            attrs = {};
        }
        if (source == null) {
            source = new column_data_source_1.ColumnDataSource();
        }
        attrs = object_1.extend({}, attrs, {
            data_source: source,
            glyph: glyph
        });
        renderer = new glyph_renderer_1.GlyphRenderer(attrs);
        this.add_renderers(renderer);
        return renderer;
    };
    Plot.prototype.add_tools = function () {
        var attrs, new_tools, tool, tools;
        tools = 1 <= arguments.length ? slice.call(arguments, 0) : [];
        new_tools = (function () {
            var i, len, results;
            results = [];
            for (i = 0, len = tools.length; i < len; i++) {
                tool = tools[i];
                if (tool.overlay != null) {
                    this.add_renderers(tool.overlay);
                }
                if (tool.plot != null) {
                    results.push(tool);
                }
                else {
                    attrs = object_1.clone(tool.attributes);
                    attrs.plot = this;
                    results.push(new tool.constructor(attrs));
                }
            }
            return results;
        }).call(this);
        return this.toolbar.tools = this.toolbar.tools.concat(new_tools);
    };
    Plot.prototype.get_aspect_ratio = function () {
        return this.width / this.height;
    };
    Plot.prototype.get_layoutable_children = function () {
        var children;
        children = [this.plot_canvas];
        if (this.toolbar_location != null) {
            children = [this.toolbar, this.plot_canvas];
        }
        return children;
    };
    Plot.prototype.get_edit_variables = function () {
        var child, edit_variables, i, len, ref;
        edit_variables = Plot.__super__.get_edit_variables.call(this);
        if (this.sizing_mode === 'scale_both') {
            edit_variables.push({
                edit_variable: this._width,
                strength: solver_1.Strength.strong
            });
            edit_variables.push({
                edit_variable: this._height,
                strength: solver_1.Strength.strong
            });
        }
        ref = this.get_layoutable_children();
        for (i = 0, len = ref.length; i < len; i++) {
            child = ref[i];
            edit_variables = edit_variables.concat(child.get_edit_variables());
        }
        return edit_variables;
    };
    Plot.prototype.get_constraints = function () {
        var child, constraints, i, len, ref, ref1, ref2, sticky_edge;
        constraints = Plot.__super__.get_constraints.call(this);
        if (this.toolbar_location != null) {
            if (this.toolbar_sticky === true) {
                constraints.push(solver_1.EQ(this._sizeable, [-1, this.plot_canvas._sizeable]));
            }
            else {
                constraints.push(solver_1.EQ(this._sizeable, [-1, this.plot_canvas._sizeable], [-1, this.toolbar._sizeable]));
            }
            constraints.push(solver_1.EQ(this._full, [-1, this.plot_canvas._full]));
            if (this.toolbar_location === 'above') {
                sticky_edge = this.toolbar_sticky === true ? this.plot_canvas._top : this.plot_canvas._dom_top;
                constraints.push(solver_1.EQ(sticky_edge, [-1, this.toolbar._dom_top], [-1, this.toolbar._height]));
            }
            if (this.toolbar_location === 'below') {
                if (this.toolbar_sticky === false) {
                    constraints.push(solver_1.EQ(this.toolbar._dom_top, [-1, this.plot_canvas._height], this.toolbar._bottom, [-1, this.toolbar._height]));
                }
                if (this.toolbar_sticky === true) {
                    constraints.push(solver_1.GE(this.plot_canvas.below_panel._height, [-1, this.toolbar._height]));
                    constraints.push(solver_1.WEAK_EQ(this.toolbar._dom_top, [-1, this.plot_canvas._height], this.plot_canvas.below_panel._height));
                }
            }
            if (this.toolbar_location === 'left') {
                sticky_edge = this.toolbar_sticky === true ? this.plot_canvas._left : this.plot_canvas._dom_left;
                constraints.push(solver_1.EQ(sticky_edge, [-1, this.toolbar._dom_left], [-1, this.toolbar._width]));
            }
            if (this.toolbar_location === 'right') {
                if (this.toolbar_sticky === false) {
                    constraints.push(solver_1.EQ(this.toolbar._dom_left, [-1, this.plot_canvas._width], this.toolbar._right, [-1, this.toolbar._width]));
                }
                if (this.toolbar_sticky === true) {
                    constraints.push(solver_1.GE(this.plot_canvas.right_panel._width, [-1, this.toolbar._width]));
                    constraints.push(solver_1.WEAK_EQ(this.toolbar._dom_left, [-1, this.plot_canvas._width], this.plot_canvas.right_panel._width));
                }
            }
            if ((ref = this.toolbar_location) === 'above' || ref === 'below') {
                constraints.push(solver_1.EQ(this._width, [-1, this.toolbar._width], [-1, this.plot_canvas._width_minus_right]));
            }
            if ((ref1 = this.toolbar_location) === 'left' || ref1 === 'right') {
                constraints.push(solver_1.EQ(this._height, [-1, this.toolbar._height], [-1, this.plot_canvas.above_panel._height]));
                constraints.push(solver_1.EQ(this.toolbar._dom_top, [-1, this.plot_canvas.above_panel._height]));
            }
        }
        if (this.toolbar_location == null) {
            constraints.push(solver_1.EQ(this._width, [-1, this.plot_canvas._width]));
            constraints.push(solver_1.EQ(this._height, [-1, this.plot_canvas._height]));
        }
        ref2 = this.get_layoutable_children();
        for (i = 0, len = ref2.length; i < len; i++) {
            child = ref2[i];
            constraints = constraints.concat(child.get_constraints());
        }
        return constraints;
    };
    Plot.prototype.get_constrained_variables = function () {
        var constrained_variables;
        constrained_variables = Plot.__super__.get_constrained_variables.call(this);
        constrained_variables = object_1.extend(constrained_variables, {
            'on-edge-align-top': this.plot_canvas._top,
            'on-edge-align-bottom': this.plot_canvas._height_minus_bottom,
            'on-edge-align-left': this.plot_canvas._left,
            'on-edge-align-right': this.plot_canvas._width_minus_right,
            'box-cell-align-top': this.plot_canvas._top,
            'box-cell-align-bottom': this.plot_canvas._height_minus_bottom,
            'box-cell-align-left': this.plot_canvas._left,
            'box-cell-align-right': this.plot_canvas._width_minus_right,
            'box-equal-size-top': this.plot_canvas._top,
            'box-equal-size-bottom': this.plot_canvas._height_minus_bottom
        });
        if (this.sizing_mode !== 'fixed') {
            constrained_variables = object_1.extend(constrained_variables, {
                'box-equal-size-left': this.plot_canvas._left,
                'box-equal-size-right': this.plot_canvas._width_minus_right
            });
        }
        return constrained_variables;
    };
    Plot.prototype._set_orientation_variables = function (model) {
        if (this._horizontal === false) {
            model._sizeable = model._height;
            model._full = model._width;
        }
        if (this._horizontal === true) {
            model._sizeable = model._width;
            return model._full = model._height;
        }
    };
    Plot.mixins(['line:outline_', 'fill:background_', 'fill:border_']);
    Plot.define({
        toolbar: [
            p.Instance, function () {
                return new toolbar_1.Toolbar();
            }
        ],
        toolbar_location: [p.Location, 'right'],
        toolbar_sticky: [p.Bool, true],
        plot_width: [p.Number, 600],
        plot_height: [p.Number, 600],
        title: [
            p.Any, function () {
                return new title_1.Title({
                    text: ""
                });
            }
        ],
        title_location: [p.Location, 'above'],
        h_symmetry: [p.Bool, true],
        v_symmetry: [p.Bool, false],
        above: [p.Array, []],
        below: [p.Array, []],
        left: [p.Array, []],
        right: [p.Array, []],
        renderers: [p.Array, []],
        x_range: [p.Instance],
        extra_x_ranges: [p.Any, {}],
        y_range: [p.Instance],
        extra_y_ranges: [p.Any, {}],
        x_mapper_type: [p.String, 'auto'],
        y_mapper_type: [p.String, 'auto'],
        tool_events: [
            p.Instance, function () {
                return new tool_events_1.ToolEvents();
            }
        ],
        lod_factor: [p.Number, 10],
        lod_interval: [p.Number, 300],
        lod_threshold: [p.Number, 2000],
        lod_timeout: [p.Number, 500],
        webgl: [p.Bool, false],
        hidpi: [p.Bool, true],
        min_border: [p.Number, 5],
        min_border_top: [p.Number, null],
        min_border_left: [p.Number, null],
        min_border_bottom: [p.Number, null],
        min_border_right: [p.Number, null],
        inner_width: [p.Number],
        inner_height: [p.Number],
        layout_width: [p.Number],
        layout_height: [p.Number]
    });
    Plot.override({
        outline_line_color: '#e5e5e5',
        border_fill_color: "#ffffff",
        background_fill_color: "#ffffff"
    });
    Plot.getters({
        all_renderers: function () {
            var i, len, ref, renderers, tool;
            renderers = this.renderers;
            ref = this.toolbar.tools;
            for (i = 0, len = ref.length; i < len; i++) {
                tool = ref[i];
                renderers = renderers.concat(tool.synthetic_renderers);
            }
            return renderers;
        }
    });
    return Plot;
})(layout_dom_1.LayoutDOM);
bokeh_events_1.register_with_event(bokeh_events_1.UIEvent, exports.Plot);

},{"../annotations/title":"models/annotations/title","../layouts/layout_dom":"models/layouts/layout_dom","../renderers/glyph_renderer":"models/renderers/glyph_renderer","../sources/column_data_source":"models/sources/column_data_source","../tools/tool_events":"models/tools/tool_events","../tools/toolbar":"models/tools/toolbar","./plot_canvas":"models/plots/plot_canvas","core/bokeh_events":"core/bokeh_events","core/layout/solver":"core/layout/solver","core/logging":"core/logging","core/properties":"core/properties","core/util/object":"core/util/object","core/util/types":"core/util/types"}],"models/plots/plot_canvas":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var global_glcanvas, bind = function (fn, me) { return function () { return fn.apply(me, arguments); }; }, extend1 = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, indexOf = [].indexOf || function (item) { for (var i = 0, l = this.length; i < l; i++) {
    if (i in this && this[i] === item)
        return i;
} return -1; };
var canvas_1 = require("../canvas/canvas");
var cartesian_frame_1 = require("../canvas/cartesian_frame");
var data_range1d_1 = require("../ranges/data_range1d");
var glyph_renderer_1 = require("../renderers/glyph_renderer");
var layout_dom_1 = require("../layouts/layout_dom");
var build_views_1 = require("core/build_views");
var ui_events_1 = require("core/ui_events");
var bokeh_events_1 = require("core/bokeh_events");
var layout_canvas_1 = require("core/layout/layout_canvas");
var visuals_1 = require("core/visuals");
var bokeh_view_1 = require("core/bokeh_view");
var solver_1 = require("core/layout/solver");
var logging_1 = require("core/logging");
var enums = require("core/enums");
var p = require("core/properties");
var throttle_1 = require("core/util/throttle");
var types_1 = require("core/util/types");
var array_1 = require("core/util/array");
var object_1 = require("core/util/object");
var callback_1 = require("core/util/callback");
var side_panel_1 = require("core/layout/side_panel");
global_glcanvas = null;
exports.PlotCanvasView = (function (superClass) {
    extend1(PlotCanvasView, superClass);
    function PlotCanvasView() {
        this.remove = bind(this.remove, this);
        this.request_render = bind(this.request_render, this);
        return PlotCanvasView.__super__.constructor.apply(this, arguments);
    }
    PlotCanvasView.prototype.className = "bk-plot-wrapper";
    PlotCanvasView.prototype.state = {
        history: [],
        index: -1
    };
    PlotCanvasView.prototype.view_options = function () {
        return object_1.extend({
            plot_view: this
        }, this.options);
    };
    PlotCanvasView.prototype.pause = function () {
        return this.is_paused = true;
    };
    PlotCanvasView.prototype.unpause = function () {
        this.is_paused = false;
        return this.request_render();
    };
    PlotCanvasView.prototype.request_render = function () {
        if (!this.is_paused) {
            this.throttled_render();
        }
    };
    PlotCanvasView.prototype.remove = function () {
        var id, ref, results, tool_view;
        PlotCanvasView.__super__.remove.call(this);
        ref = this.tool_views;
        results = [];
        for (id in ref) {
            tool_view = ref[id];
            results.push(tool_view.remove());
        }
        return results;
    };
    PlotCanvasView.prototype.initialize = function (options) {
        var j, len, level, ref;
        PlotCanvasView.__super__.initialize.call(this, options);
        this.pause();
        this.lod_started = false;
        this.visuals = new visuals_1.Visuals(this.model.plot);
        this._initial_state_info = {
            range: null,
            selection: {},
            dimensions: {
                width: this.model.canvas.width,
                height: this.model.canvas.height
            }
        };
        this.frame = this.model.frame;
        this.x_range = this.frame.x_ranges['default'];
        this.y_range = this.frame.y_ranges['default'];
        this.xmapper = this.frame.x_mappers['default'];
        this.ymapper = this.frame.y_mappers['default'];
        this.canvas = this.model.canvas;
        this.canvas_view = new this.canvas.default_view({
            'model': this.canvas
        });
        this.el.appendChild(this.canvas_view.el);
        this.canvas_view.render(true);
        if (this.model.plot.webgl) {
            this.init_webgl();
        }
        this.throttled_render = throttle_1.throttle(this.render, 15);
        if (this.model.document._unrendered_plots == null) {
            this.model.document._unrendered_plots = {};
        }
        this.model.document._unrendered_plots[this.id] = true;
        this.ui_event_bus = new ui_events_1.UIEvents(this, this.model.toolbar, this.canvas_view.el, this.model.plot);
        this.levels = {};
        ref = enums.RenderLevel;
        for (j = 0, len = ref.length; j < len; j++) {
            level = ref[j];
            this.levels[level] = {};
        }
        this.renderer_views = {};
        this.tool_views = {};
        this.build_levels();
        this.build_tools();
        this.bind_bokeh_events();
        this.update_dataranges();
        this.unpause();
        logging_1.logger.debug("PlotView initialized");
        return this;
    };
    PlotCanvasView.prototype.get_canvas_element = function () {
        return this.canvas_view.ctx.canvas;
    };
    PlotCanvasView.prototype.set_cursor = function (cursor) {
        if (cursor == null) {
            cursor = "default";
        }
        return this.canvas_view.el.style.cursor = cursor;
    };
    PlotCanvasView.getters({
        canvas_overlays: function () {
            return this.el.querySelector('.bk-canvas-overlays');
        }
    });
    PlotCanvasView.prototype.init_webgl = function () {
        var ctx, glcanvas, opts;
        ctx = this.canvas_view.ctx;
        glcanvas = global_glcanvas;
        if (glcanvas == null) {
            global_glcanvas = glcanvas = document.createElement('canvas');
            opts = {
                'premultipliedAlpha': true
            };
            glcanvas.gl = glcanvas.getContext("webgl", opts) || glcanvas.getContext("experimental-webgl", opts);
        }
        if (glcanvas.gl != null) {
            return ctx.glcanvas = glcanvas;
        }
        else {
            return logging_1.logger.warn('WebGL is not supported, falling back to 2D canvas.');
        }
    };
    PlotCanvasView.prototype.prepare_webgl = function (ratio, frame_box) {
        var canvas, ctx, flipped_top, gl;
        ctx = this.canvas_view.ctx;
        canvas = this.canvas_view.get_canvas_element();
        if (ctx.glcanvas) {
            ctx.glcanvas.width = canvas.width;
            ctx.glcanvas.height = canvas.height;
            gl = ctx.glcanvas.gl;
            gl.viewport(0, 0, ctx.glcanvas.width, ctx.glcanvas.height);
            gl.clearColor(0, 0, 0, 0);
            gl.clear(gl.COLOR_BUFFER_BIT || gl.DEPTH_BUFFER_BIT);
            gl.enable(gl.SCISSOR_TEST);
            flipped_top = ctx.glcanvas.height - ratio * (frame_box[1] + frame_box[3]);
            gl.scissor(ratio * frame_box[0], flipped_top, ratio * frame_box[2], ratio * frame_box[3]);
            gl.enable(gl.BLEND);
            return gl.blendFuncSeparate(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA, gl.ONE_MINUS_DST_ALPHA, gl.ONE);
        }
    };
    PlotCanvasView.prototype.blit_webgl = function (ratio) {
        var ctx;
        ctx = this.canvas_view.ctx;
        if (ctx.glcanvas) {
            logging_1.logger.debug('drawing with WebGL');
            ctx.restore();
            ctx.drawImage(ctx.glcanvas, 0, 0);
            ctx.save();
            ctx.scale(ratio, ratio);
            return ctx.translate(0.5, 0.5);
        }
    };
    PlotCanvasView.prototype.update_dataranges = function () {
        var bds, bounds, bounds_to_use, calculate_log_bounds, follow_enabled, frame, has_bounds, j, k, l, len, len1, len2, len3, len4, log_bds, log_bounds, m, n, o, r, ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, v, xr, yr;
        frame = this.model.frame;
        bounds = {};
        log_bounds = {};
        calculate_log_bounds = false;
        ref = object_1.values(frame.x_ranges).concat(object_1.values(frame.y_ranges));
        for (j = 0, len = ref.length; j < len; j++) {
            r = ref[j];
            if (r instanceof data_range1d_1.DataRange1d) {
                if (r.mapper_hint === "log") {
                    calculate_log_bounds = true;
                }
            }
        }
        ref1 = this.renderer_views;
        for (k in ref1) {
            v = ref1[k];
            bds = (ref2 = v.glyph) != null ? typeof ref2.bounds === "function" ? ref2.bounds() : void 0 : void 0;
            if (bds != null) {
                bounds[k] = bds;
            }
            if (calculate_log_bounds) {
                log_bds = (ref3 = v.glyph) != null ? typeof ref3.log_bounds === "function" ? ref3.log_bounds() : void 0 : void 0;
                if (log_bds != null) {
                    log_bounds[k] = log_bds;
                }
            }
        }
        follow_enabled = false;
        has_bounds = false;
        ref4 = object_1.values(frame.x_ranges);
        for (l = 0, len1 = ref4.length; l < len1; l++) {
            xr = ref4[l];
            if (xr instanceof data_range1d_1.DataRange1d) {
                bounds_to_use = xr.mapper_hint === "log" ? log_bounds : bounds;
                xr.update(bounds_to_use, 0, this.model.id);
                if (xr.follow) {
                    follow_enabled = true;
                }
            }
            if (xr.bounds != null) {
                has_bounds = true;
            }
        }
        ref5 = object_1.values(frame.y_ranges);
        for (m = 0, len2 = ref5.length; m < len2; m++) {
            yr = ref5[m];
            if (yr instanceof data_range1d_1.DataRange1d) {
                bounds_to_use = yr.mapper_hint === "log" ? log_bounds : bounds;
                yr.update(bounds_to_use, 1, this.model.id);
                if (yr.follow) {
                    follow_enabled = true;
                }
            }
            if (yr.bounds != null) {
                has_bounds = true;
            }
        }
        if (follow_enabled && has_bounds) {
            logging_1.logger.warn('Follow enabled so bounds are unset.');
            ref6 = object_1.values(frame.x_ranges);
            for (n = 0, len3 = ref6.length; n < len3; n++) {
                xr = ref6[n];
                xr.bounds = null;
            }
            ref7 = object_1.values(frame.y_ranges);
            for (o = 0, len4 = ref7.length; o < len4; o++) {
                yr = ref7[o];
                yr.bounds = null;
            }
        }
        return this.range_update_timestamp = Date.now();
    };
    PlotCanvasView.prototype.map_to_screen = function (x, y, x_name, y_name) {
        if (x_name == null) {
            x_name = 'default';
        }
        if (y_name == null) {
            y_name = 'default';
        }
        return this.frame.map_to_screen(x, y, this.canvas, x_name, y_name);
    };
    PlotCanvasView.prototype.push_state = function (type, info) {
        var prev_info, ref;
        prev_info = ((ref = this.state.history[this.state.index]) != null ? ref.info : void 0) || {};
        info = object_1.extend({}, this._initial_state_info, prev_info, info);
        this.state.history.slice(0, this.state.index + 1);
        this.state.history.push({
            type: type,
            info: info
        });
        this.state.index = this.state.history.length - 1;
        return this.trigger("state_changed");
    };
    PlotCanvasView.prototype.clear_state = function () {
        this.state = {
            history: [],
            index: -1
        };
        return this.trigger("state_changed");
    };
    PlotCanvasView.prototype.can_undo = function () {
        return this.state.index >= 0;
    };
    PlotCanvasView.prototype.can_redo = function () {
        return this.state.index < this.state.history.length - 1;
    };
    PlotCanvasView.prototype.undo = function () {
        if (this.can_undo()) {
            this.state.index -= 1;
            this._do_state_change(this.state.index);
            return this.trigger("state_changed");
        }
    };
    PlotCanvasView.prototype.redo = function () {
        if (this.can_redo()) {
            this.state.index += 1;
            this._do_state_change(this.state.index);
            return this.trigger("state_changed");
        }
    };
    PlotCanvasView.prototype._do_state_change = function (index) {
        var info, ref;
        info = ((ref = this.state.history[index]) != null ? ref.info : void 0) || this._initial_state_info;
        if (info.range != null) {
            this.update_range(info.range);
        }
        if (info.selection != null) {
            this.update_selection(info.selection);
        }
        if (info.dimensions != null) {
            return this.canvas_view.set_dims([info.dimensions.width, info.dimensions.height]);
        }
    };
    PlotCanvasView.prototype.reset_dimensions = function () {
        return this.update_dimensions(this.canvas.initial_width, this.canvas.initial_height);
    };
    PlotCanvasView.prototype.update_dimensions = function (width, height) {
        this.pause();
        this.model.plot.width = width;
        this.model.plot.height = height;
        this.model.document.resize();
        return this.unpause();
    };
    PlotCanvasView.prototype.get_selection = function () {
        var j, len, ref, renderer, selected, selection;
        selection = [];
        ref = this.model.plot.renderers;
        for (j = 0, len = ref.length; j < len; j++) {
            renderer = ref[j];
            if (renderer instanceof glyph_renderer_1.GlyphRenderer) {
                selected = renderer.data_source.selected;
                selection[renderer.id] = selected;
            }
        }
        return selection;
    };
    PlotCanvasView.prototype.update_selection = function (selection) {
        var ds, j, len, ref, ref1, renderer, results;
        ref = this.model.plot.renderers;
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
            renderer = ref[j];
            if (!(renderer instanceof glyph_renderer_1.GlyphRenderer)) {
                continue;
            }
            ds = renderer.data_source;
            if (selection != null) {
                if (ref1 = renderer.id, indexOf.call(selection, ref1) >= 0) {
                    results.push(ds.selected = selection[renderer.id]);
                }
                else {
                    results.push(void 0);
                }
            }
            else {
                results.push(ds.selection_manager.clear());
            }
        }
        return results;
    };
    PlotCanvasView.prototype.reset_selection = function () {
        return this.update_selection(null);
    };
    PlotCanvasView.prototype._update_ranges_together = function (range_info_iter) {
        var j, l, len, len1, range_info, ref, ref1, results, rng, weight;
        weight = 1.0;
        for (j = 0, len = range_info_iter.length; j < len; j++) {
            ref = range_info_iter[j], rng = ref[0], range_info = ref[1];
            weight = Math.min(weight, this._get_weight_to_constrain_interval(rng, range_info));
        }
        if (weight < 1) {
            results = [];
            for (l = 0, len1 = range_info_iter.length; l < len1; l++) {
                ref1 = range_info_iter[l], rng = ref1[0], range_info = ref1[1];
                range_info['start'] = weight * range_info['start'] + (1 - weight) * rng.start;
                results.push(range_info['end'] = weight * range_info['end'] + (1 - weight) * rng.end);
            }
            return results;
        }
    };
    PlotCanvasView.prototype._update_ranges_individually = function (range_info_iter, is_panning, is_scrolling) {
        var hit_bound, j, l, len, len1, max, min, new_interval, range_info, ref, ref1, results, reversed, rng, weight;
        hit_bound = false;
        for (j = 0, len = range_info_iter.length; j < len; j++) {
            ref = range_info_iter[j], rng = ref[0], range_info = ref[1];
            reversed = rng.start > rng.end;
            if (!is_scrolling) {
                weight = this._get_weight_to_constrain_interval(rng, range_info);
                if (weight < 1) {
                    range_info['start'] = weight * range_info['start'] + (1 - weight) * rng.start;
                    range_info['end'] = weight * range_info['end'] + (1 - weight) * rng.end;
                }
            }
            if (rng.bounds != null) {
                min = rng.bounds[0];
                max = rng.bounds[1];
                new_interval = Math.abs(range_info['end'] - range_info['start']);
                if (reversed) {
                    if (min != null) {
                        if (min >= range_info['end']) {
                            hit_bound = true;
                            range_info['end'] = min;
                            if ((is_panning != null) || (is_scrolling != null)) {
                                range_info['start'] = min + new_interval;
                            }
                        }
                    }
                    if (max != null) {
                        if (max <= range_info['start']) {
                            hit_bound = true;
                            range_info['start'] = max;
                            if ((is_panning != null) || (is_scrolling != null)) {
                                range_info['end'] = max - new_interval;
                            }
                        }
                    }
                }
                else {
                    if (min != null) {
                        if (min >= range_info['start']) {
                            hit_bound = true;
                            range_info['start'] = min;
                            if ((is_panning != null) || (is_scrolling != null)) {
                                range_info['end'] = min + new_interval;
                            }
                        }
                    }
                    if (max != null) {
                        if (max <= range_info['end']) {
                            hit_bound = true;
                            range_info['end'] = max;
                            if ((is_panning != null) || (is_scrolling != null)) {
                                range_info['start'] = max - new_interval;
                            }
                        }
                    }
                }
            }
        }
        if (is_scrolling && hit_bound) {
            return;
        }
        results = [];
        for (l = 0, len1 = range_info_iter.length; l < len1; l++) {
            ref1 = range_info_iter[l], rng = ref1[0], range_info = ref1[1];
            rng.have_updated_interactively = true;
            if (rng.start !== range_info['start'] || rng.end !== range_info['end']) {
                results.push(rng.setv(range_info));
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    PlotCanvasView.prototype._get_weight_to_constrain_interval = function (rng, range_info) {
        var max, max_interval, max_interval2, min, min_interval, new_interval, old_interval, ref, weight;
        min_interval = rng.min_interval;
        max_interval = rng.max_interval;
        weight = 1.0;
        if (rng.bounds != null) {
            ref = rng.bounds, min = ref[0], max = ref[1];
            if ((min != null) && (max != null)) {
                max_interval2 = Math.abs(max - min);
                max_interval = max_interval != null ? Math.min(max_interval, max_interval2) : max_interval2;
            }
        }
        if ((min_interval != null) || (max_interval != null)) {
            old_interval = Math.abs(rng.end - rng.start);
            new_interval = Math.abs(range_info['end'] - range_info['start']);
            if (min_interval > 0 && new_interval < min_interval) {
                weight = (old_interval - min_interval) / (old_interval - new_interval);
            }
            if (max_interval > 0 && new_interval > max_interval) {
                weight = (max_interval - old_interval) / (new_interval - old_interval);
            }
            weight = Math.max(0.0, Math.min(1.0, weight));
        }
        return weight;
    };
    PlotCanvasView.prototype.update_range = function (range_info, is_panning, is_scrolling) {
        var name, range_info_iter, ref, ref1, ref2, ref3, rng;
        this.pause;
        if (range_info == null) {
            ref = this.frame.x_ranges;
            for (name in ref) {
                rng = ref[name];
                rng.reset();
            }
            ref1 = this.frame.y_ranges;
            for (name in ref1) {
                rng = ref1[name];
                rng.reset();
            }
            this.update_dataranges();
        }
        else {
            range_info_iter = [];
            ref2 = this.frame.x_ranges;
            for (name in ref2) {
                rng = ref2[name];
                range_info_iter.push([rng, range_info.xrs[name]]);
            }
            ref3 = this.frame.y_ranges;
            for (name in ref3) {
                rng = ref3[name];
                range_info_iter.push([rng, range_info.yrs[name]]);
            }
            if (is_scrolling) {
                this._update_ranges_together(range_info_iter);
            }
            this._update_ranges_individually(range_info_iter, is_panning, is_scrolling);
        }
        return this.unpause();
    };
    PlotCanvasView.prototype.reset_range = function () {
        return this.update_range(null);
    };
    PlotCanvasView.prototype.build_levels = function () {
        var id_, j, l, len, len1, model, new_renderer_views, old_renderers, renderer_models, renderers_to_remove, view;
        renderer_models = this.model.plot.all_renderers;
        old_renderers = Object.keys(this.renderer_views);
        new_renderer_views = build_views_1.build_views(this.renderer_views, renderer_models, this.view_options());
        renderers_to_remove = array_1.difference(old_renderers, (function () {
            var j, len, results;
            results = [];
            for (j = 0, len = renderer_models.length; j < len; j++) {
                model = renderer_models[j];
                results.push(model.id);
            }
            return results;
        })());
        for (j = 0, len = renderers_to_remove.length; j < len; j++) {
            id_ = renderers_to_remove[j];
            delete this.levels.glyph[id_];
        }
        for (l = 0, len1 = new_renderer_views.length; l < len1; l++) {
            view = new_renderer_views[l];
            this.levels[view.model.level][view.model.id] = view;
            view.bind_bokeh_events();
        }
        return this;
    };
    PlotCanvasView.prototype.get_renderer_views = function () {
        var j, len, r, ref, results;
        ref = this.model.plot.renderers;
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
            r = ref[j];
            results.push(this.levels[r.level][r.id]);
        }
        return results;
    };
    PlotCanvasView.prototype.build_tools = function () {
        var j, len, new_tool_views, results, tool_models, tool_view;
        tool_models = this.model.plot.toolbar.tools;
        new_tool_views = build_views_1.build_views(this.tool_views, tool_models, this.view_options());
        results = [];
        for (j = 0, len = new_tool_views.length; j < len; j++) {
            tool_view = new_tool_views[j];
            tool_view.bind_bokeh_events();
            results.push(this.ui_event_bus.register_tool(tool_view));
        }
        return results;
    };
    PlotCanvasView.prototype.bind_bokeh_events = function () {
        var name, ref, ref1, rng;
        ref = this.model.frame.x_ranges;
        for (name in ref) {
            rng = ref[name];
            this.listenTo(rng, 'change', this.request_render);
        }
        ref1 = this.model.frame.y_ranges;
        for (name in ref1) {
            rng = ref1[name];
            this.listenTo(rng, 'change', this.request_render);
        }
        this.listenTo(this.model.plot, 'change:renderers', (function (_this) {
            return function () {
                return _this.build_levels();
            };
        })(this));
        this.listenTo(this.model.plot.toolbar, 'change:tools', (function (_this) {
            return function () {
                _this.build_levels();
                return _this.build_tools();
            };
        })(this));
        this.listenTo(this.model.plot, 'change', this.request_render);
        this.listenTo(this.model.plot, 'destroy', (function (_this) {
            return function () {
                return _this.remove();
            };
        })(this));
        this.listenTo(this.model.plot.document.solver(), 'layout_update', (function (_this) {
            return function () {
                return _this.request_render();
            };
        })(this));
        this.listenTo(this.model.plot.document.solver(), 'layout_update', (function (_this) {
            return function () {
                return _this.model.plot.setv({
                    inner_width: Math.round(_this.frame.width),
                    inner_height: Math.round(_this.frame.height),
                    layout_width: Math.round(_this.canvas.width),
                    layout_height: Math.round(_this.canvas.height)
                });
            };
        })(this));
        this.listenTo(this.model.plot.document.solver(), 'resize', (function (_this) {
            return function () {
                return _this.resize();
            };
        })(this));
        return this.listenTo(this.canvas, 'change:pixel_ratio', (function (_this) {
            return function () {
                return _this.request_render();
            };
        })(this));
    };
    PlotCanvasView.prototype.set_initial_range = function () {
        var good_vals, name, ref, ref1, rng, xrs, yrs;
        good_vals = true;
        xrs = {};
        ref = this.frame.x_ranges;
        for (name in ref) {
            rng = ref[name];
            if ((rng.start == null) || (rng.end == null) || types_1.isStrictNaN(rng.start + rng.end)) {
                good_vals = false;
                break;
            }
            xrs[name] = {
                start: rng.start,
                end: rng.end
            };
        }
        if (good_vals) {
            yrs = {};
            ref1 = this.frame.y_ranges;
            for (name in ref1) {
                rng = ref1[name];
                if ((rng.start == null) || (rng.end == null) || types_1.isStrictNaN(rng.start + rng.end)) {
                    good_vals = false;
                    break;
                }
                yrs[name] = {
                    start: rng.start,
                    end: rng.end
                };
            }
        }
        if (good_vals) {
            this._initial_state_info.range = this.initial_range_info = {
                xrs: xrs,
                yrs: yrs
            };
            return logging_1.logger.debug("initial ranges set");
        }
        else {
            return logging_1.logger.warn('could not set initial ranges');
        }
    };
    PlotCanvasView.prototype.render = function (force_canvas) {
        var ctx, event, frame_box, k, lod_timeout, ratio, ref, v;
        if (force_canvas == null) {
            force_canvas = false;
        }
        logging_1.logger.trace("PlotCanvas.render(force_canvas=" + force_canvas + ") for " + this.model.id);
        if (this.model.document == null) {
            return;
        }
        if (Date.now() - this.interactive_timestamp < this.model.plot.lod_interval) {
            if (!this.lod_started) {
                this.model.plot.trigger_event(new bokeh_events_1.LODStart({}));
                this.lod_started = true;
            }
            this.interactive = true;
            lod_timeout = this.model.plot.lod_timeout;
            setTimeout((function (_this) {
                return function () {
                    if (_this.interactive && (Date.now() - _this.interactive_timestamp) > lod_timeout) {
                        _this.interactive = false;
                    }
                    return _this.request_render();
                };
            })(this), lod_timeout);
        }
        else {
            this.interactive = false;
            if (this.lod_started) {
                this.model.plot.trigger_event(new bokeh_events_1.LODEnd({}));
                this.lod_started = false;
            }
        }
        ref = this.renderer_views;
        for (k in ref) {
            v = ref[k];
            if ((this.range_update_timestamp == null) || v.set_data_timestamp > this.range_update_timestamp) {
                this.update_dataranges();
                break;
            }
        }
        this.update_constraints();
        this.model.frame._update_mappers();
        ctx = this.canvas_view.ctx;
        ctx.pixel_ratio = ratio = this.canvas_view.pixel_ratio;
        ctx.save();
        ctx.scale(ratio, ratio);
        ctx.translate(0.5, 0.5);
        frame_box = [this.canvas.vx_to_sx(this.frame.left), this.canvas.vy_to_sy(this.frame.top), this.frame.width, this.frame.height];
        this._map_hook(ctx, frame_box);
        this._paint_empty(ctx, frame_box);
        this.prepare_webgl(ratio, frame_box);
        ctx.save();
        if (this.visuals.outline_line.doit) {
            this.visuals.outline_line.set_value(ctx);
            ctx.strokeRect.apply(ctx, frame_box);
        }
        ctx.restore();
        this._render_levels(ctx, ['image', 'underlay', 'glyph'], frame_box);
        this.blit_webgl(ratio);
        this._render_levels(ctx, ['annotation'], frame_box);
        this._render_levels(ctx, ['overlay']);
        if (this.initial_range_info == null) {
            this.set_initial_range();
        }
        ctx.restore();
        if (this.model.document._unrendered_plots != null) {
            delete this.model.document._unrendered_plots[this.id];
            if (object_1.isEmpty(this.model.document._unrendered_plots)) {
                this.model.document._unrendered_plots = null;
                callback_1.defer(this.model.document.resize.bind(this.model.document));
            }
        }
        event = new Event("bokeh:rendered", {
            detail: this
        });
        return window.dispatchEvent(event);
    };
    PlotCanvasView.prototype.resize = function () {
        var height, width;
        width = this.model._width._value;
        height = this.model._height._value;
        this.canvas_view.set_dims([width, height], true);
        this.canvas_view.prepare_canvas();
        this.update_constraints();
        this.el.style.position = 'absolute';
        this.el.style.left = this.model._dom_left._value + "px";
        this.el.style.top = this.model._dom_top._value + "px";
        this.el.style.width = this.model._width._value + "px";
        return this.el.style.height = this.model._height._value + "px";
    };
    PlotCanvasView.prototype.update_constraints = function () {
        var model_id, ref, s, view;
        s = this.model.document.solver();
        s.suggest_value(this.frame._width, this.canvas.width - 1);
        s.suggest_value(this.frame._height, this.canvas.height - 1);
        ref = this.renderer_views;
        for (model_id in ref) {
            view = ref[model_id];
            if (view.model.panel != null) {
                side_panel_1.update_constraints(view);
            }
        }
        return s.update_variables(false);
    };
    PlotCanvasView.prototype._render_levels = function (ctx, levels, clip_region) {
        var i, indices, j, l, len, len1, len2, level, m, ref, renderer, renderer_view, renderer_views, sortKey;
        ctx.save();
        if (clip_region != null) {
            ctx.beginPath();
            ctx.rect.apply(ctx, clip_region);
            ctx.clip();
            ctx.beginPath();
        }
        indices = {};
        ref = this.model.plot.renderers;
        for (i = j = 0, len = ref.length; j < len; i = ++j) {
            renderer = ref[i];
            indices[renderer.id] = i;
        }
        sortKey = function (renderer_view) {
            return indices[renderer_view.model.id];
        };
        for (l = 0, len1 = levels.length; l < len1; l++) {
            level = levels[l];
            renderer_views = array_1.sortBy(object_1.values(this.levels[level]), sortKey);
            for (m = 0, len2 = renderer_views.length; m < len2; m++) {
                renderer_view = renderer_views[m];
                renderer_view.render();
            }
        }
        return ctx.restore();
    };
    PlotCanvasView.prototype._map_hook = function (ctx, frame_box) { };
    PlotCanvasView.prototype._paint_empty = function (ctx, frame_box) {
        ctx.clearRect(0, 0, this.canvas_view.model.width, this.canvas_view.model.height);
        if (this.visuals.border_fill.doit) {
            this.visuals.border_fill.set_value(ctx);
            ctx.fillRect(0, 0, this.canvas_view.model.width, this.canvas_view.model.height);
            ctx.clearRect.apply(ctx, frame_box);
        }
        if (this.visuals.background_fill.doit) {
            this.visuals.background_fill.set_value(ctx);
            return ctx.fillRect.apply(ctx, frame_box);
        }
    };
    PlotCanvasView.prototype.save = function (name) {
        var blob, canvas, link;
        canvas = this.get_canvas_element();
        if (canvas.msToBlob != null) {
            blob = canvas.msToBlob();
            return window.navigator.msSaveBlob(blob, name);
        }
        else {
            link = document.createElement('a');
            link.href = canvas.toDataURL('image/png');
            link.download = name;
            link.target = "_blank";
            return link.dispatchEvent(new MouseEvent('click'));
        }
    };
    return PlotCanvasView;
})(bokeh_view_1.BokehView);
exports.PlotCanvas = (function (superClass) {
    extend1(PlotCanvas, superClass);
    function PlotCanvas() {
        return PlotCanvas.__super__.constructor.apply(this, arguments);
    }
    PlotCanvas.prototype.type = 'PlotCanvas';
    PlotCanvas.prototype.default_view = exports.PlotCanvasView;
    PlotCanvas.prototype.initialize = function (attrs, options) {
        var ref;
        PlotCanvas.__super__.initialize.call(this, attrs, options);
        this.canvas = new canvas_1.Canvas({
            map: (ref = this.use_map) != null ? ref : false,
            initial_width: this.plot.plot_width,
            initial_height: this.plot.plot_height,
            use_hidpi: this.plot.hidpi
        });
        this.frame = new cartesian_frame_1.CartesianFrame({
            x_range: this.plot.x_range,
            extra_x_ranges: this.plot.extra_x_ranges,
            x_mapper_type: this.plot.x_mapper_type,
            y_range: this.plot.y_range,
            extra_y_ranges: this.plot.extra_y_ranges,
            y_mapper_type: this.plot.y_mapper_type
        });
        this.above_panel = new layout_canvas_1.LayoutCanvas();
        this.below_panel = new layout_canvas_1.LayoutCanvas();
        this.left_panel = new layout_canvas_1.LayoutCanvas();
        this.right_panel = new layout_canvas_1.LayoutCanvas();
        return logging_1.logger.debug("PlotCanvas initialized");
    };
    PlotCanvas.prototype.add_renderer_to_canvas_side = function (renderer, side) {
        if (side !== 'center') {
            return renderer.add_panel(side);
        }
    };
    PlotCanvas.prototype._doc_attached = function () {
        this.canvas.attach_document(this.document);
        this.frame.attach_document(this.document);
        this.above_panel.attach_document(this.document);
        this.below_panel.attach_document(this.document);
        this.left_panel.attach_document(this.document);
        this.right_panel.attach_document(this.document);
        return logging_1.logger.debug("PlotCanvas attached to document");
    };
    PlotCanvas.override({
        sizing_mode: 'stretch_both'
    });
    PlotCanvas.internal({
        plot: [p.Instance],
        toolbar: [p.Instance],
        canvas: [p.Instance],
        frame: [p.Instance]
    });
    PlotCanvas.prototype.get_layoutable_children = function () {
        var children, collect_panels;
        children = [this.above_panel, this.below_panel, this.left_panel, this.right_panel, this.canvas, this.frame];
        collect_panels = function (layout_renderers) {
            var j, len, r, results;
            results = [];
            for (j = 0, len = layout_renderers.length; j < len; j++) {
                r = layout_renderers[j];
                if (r.panel != null) {
                    results.push(children.push(r.panel));
                }
                else {
                    results.push(void 0);
                }
            }
            return results;
        };
        collect_panels(this.plot.above);
        collect_panels(this.plot.below);
        collect_panels(this.plot.left);
        collect_panels(this.plot.right);
        return children;
    };
    PlotCanvas.prototype.get_edit_variables = function () {
        var child, edit_variables, j, len, ref;
        edit_variables = [];
        ref = this.get_layoutable_children();
        for (j = 0, len = ref.length; j < len; j++) {
            child = ref[j];
            edit_variables = edit_variables.concat(child.get_edit_variables());
        }
        return edit_variables;
    };
    PlotCanvas.prototype.get_constraints = function () {
        var child, constraints, j, len, ref;
        constraints = PlotCanvas.__super__.get_constraints.call(this);
        constraints = constraints.concat(this._get_constant_constraints());
        constraints = constraints.concat(this._get_side_constraints());
        ref = this.get_layoutable_children();
        for (j = 0, len = ref.length; j < len; j++) {
            child = ref[j];
            constraints = constraints.concat(child.get_constraints());
        }
        return constraints;
    };
    PlotCanvas.prototype._get_constant_constraints = function () {
        var constraints, min_border_bottom, min_border_left, min_border_right, min_border_top;
        min_border_top = this.plot.min_border_top;
        min_border_bottom = this.plot.min_border_bottom;
        min_border_left = this.plot.min_border_left;
        min_border_right = this.plot.min_border_right;
        constraints = [];
        constraints.push(solver_1.GE(this.above_panel._height, -min_border_top));
        constraints.push(solver_1.GE(this.below_panel._height, -min_border_bottom));
        constraints.push(solver_1.GE(this.left_panel._width, -min_border_left));
        constraints.push(solver_1.GE(this.right_panel._width, -min_border_right));
        constraints.push(solver_1.EQ(this.above_panel._top, [-1, this.canvas._top]));
        constraints.push(solver_1.EQ(this.above_panel._bottom, [-1, this.frame._top]));
        constraints.push(solver_1.EQ(this.below_panel._bottom, [-1, this.canvas._bottom]));
        constraints.push(solver_1.EQ(this.below_panel._top, [-1, this.frame._bottom]));
        constraints.push(solver_1.EQ(this.left_panel._left, [-1, this.canvas._left]));
        constraints.push(solver_1.EQ(this.left_panel._right, [-1, this.frame._left]));
        constraints.push(solver_1.EQ(this.right_panel._right, [-1, this.canvas._right]));
        constraints.push(solver_1.EQ(this.right_panel._left, [-1, this.frame._right]));
        constraints.push(solver_1.EQ(this.above_panel._height, [-1, this._top]));
        constraints.push(solver_1.EQ(this.above_panel._height, [-1, this.canvas._top], this.frame._top));
        constraints.push(solver_1.EQ(this.below_panel._height, [-1, this._height], this._bottom));
        constraints.push(solver_1.EQ(this.below_panel._height, [-1, this.frame._bottom]));
        constraints.push(solver_1.EQ(this.left_panel._width, [-1, this._left]));
        constraints.push(solver_1.EQ(this.left_panel._width, [-1, this.frame._left]));
        constraints.push(solver_1.EQ(this.right_panel._width, [-1, this._width], this._right));
        constraints.push(solver_1.EQ(this.right_panel._width, [-1, this.canvas._right], this.frame._right));
        return constraints;
    };
    PlotCanvas.prototype._get_side_constraints = function () {
        var constraint, constraints, j, l, last, layout_renderers, len, len1, r, ref, side, sides;
        constraints = [];
        sides = [['above', this.plot.above], ['below', this.plot.below], ['left', this.plot.left], ['right', this.plot.right]];
        for (j = 0, len = sides.length; j < len; j++) {
            ref = sides[j], side = ref[0], layout_renderers = ref[1];
            last = this.frame;
            for (l = 0, len1 = layout_renderers.length; l < len1; l++) {
                r = layout_renderers[l];
                constraint = (function () {
                    switch (side) {
                        case "above":
                            return solver_1.EQ(last.panel._top, [-1, r.panel._bottom]);
                        case "below":
                            return solver_1.EQ(last.panel._bottom, [-1, r.panel._top]);
                        case "left":
                            return solver_1.EQ(last.panel._left, [-1, r.panel._right]);
                        case "right":
                            return solver_1.EQ(last.panel._right, [-1, r.panel._left]);
                    }
                })();
                constraints.push(constraint);
                last = r;
            }
            if (layout_renderers.length !== 0) {
                constraint = (function () {
                    switch (side) {
                        case "above":
                            return solver_1.EQ(last.panel._top, [-1, this.above_panel._top]);
                        case "below":
                            return solver_1.EQ(last.panel._bottom, [-1, this.below_panel._bottom]);
                        case "left":
                            return solver_1.EQ(last.panel._left, [-1, this.left_panel._left]);
                        case "right":
                            return solver_1.EQ(last.panel._right, [-1, this.right_panel._right]);
                    }
                }).call(this);
                constraints.push(constraint);
            }
        }
        return constraints;
    };
    PlotCanvas.prototype.plot_canvas = function () {
        return this;
    };
    return PlotCanvas;
})(layout_dom_1.LayoutDOM);

},{"../canvas/canvas":"models/canvas/canvas","../canvas/cartesian_frame":"models/canvas/cartesian_frame","../layouts/layout_dom":"models/layouts/layout_dom","../ranges/data_range1d":"models/ranges/data_range1d","../renderers/glyph_renderer":"models/renderers/glyph_renderer","core/bokeh_events":"core/bokeh_events","core/bokeh_view":"core/bokeh_view","core/build_views":"core/build_views","core/enums":"core/enums","core/layout/layout_canvas":"core/layout/layout_canvas","core/layout/side_panel":"core/layout/side_panel","core/layout/solver":"core/layout/solver","core/logging":"core/logging","core/properties":"core/properties","core/ui_events":"core/ui_events","core/util/array":"core/util/array","core/util/callback":"core/util/callback","core/util/object":"core/util/object","core/util/throttle":"core/util/throttle","core/util/types":"core/util/types","core/visuals":"core/visuals"}],"models/ranges/data_range":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var range_1 = require("./range");
var p = require("core/properties");
exports.DataRange = (function (superClass) {
    extend(DataRange, superClass);
    function DataRange() {
        return DataRange.__super__.constructor.apply(this, arguments);
    }
    DataRange.prototype.type = 'DataRange';
    DataRange.define({
        names: [p.Array, []],
        renderers: [p.Array, []]
    });
    return DataRange;
})(range_1.Range);

},{"./range":"models/ranges/range","core/properties":"core/properties"}],"models/ranges/data_range1d":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var data_range_1 = require("./data_range");
var glyph_renderer_1 = require("../renderers/glyph_renderer");
var logging_1 = require("core/logging");
var p = require("core/properties");
var bbox = require("core/util/bbox");
exports.DataRange1d = (function (superClass) {
    extend(DataRange1d, superClass);
    function DataRange1d() {
        return DataRange1d.__super__.constructor.apply(this, arguments);
    }
    DataRange1d.prototype.type = 'DataRange1d';
    DataRange1d.define({
        start: [p.Number],
        end: [p.Number],
        range_padding: [p.Number, 0.1],
        flipped: [p.Bool, false],
        follow: [p.String],
        follow_interval: [p.Number],
        default_span: [p.Number, 2],
        bounds: [p.Any],
        min_interval: [p.Any],
        max_interval: [p.Any]
    });
    DataRange1d.internal({
        mapper_hint: [p.String, 'auto']
    });
    DataRange1d.prototype.initialize = function (attrs, options) {
        DataRange1d.__super__.initialize.call(this, attrs, options);
        this.plot_bounds = {};
        this.have_updated_interactively = false;
        this._initial_start = this.start;
        this._initial_end = this.end;
        this._initial_range_padding = this.range_padding;
        this._initial_follow = this.follow;
        this._initial_follow_interval = this.follow_interval;
        return this._initial_default_span = this.default_span;
    };
    DataRange1d.getters({
        min: function () {
            return Math.min(this.start, this.end);
        },
        max: function () {
            return Math.max(this.start, this.end);
        }
    });
    DataRange1d.prototype.computed_renderers = function () {
        var all_renderers, i, j, len, len1, names, plot, r, ref, renderers, rs;
        names = this.names;
        renderers = this.renderers;
        if (renderers.length === 0) {
            ref = this.plots;
            for (i = 0, len = ref.length; i < len; i++) {
                plot = ref[i];
                all_renderers = plot.renderers;
                rs = (function () {
                    var j, len1, results;
                    results = [];
                    for (j = 0, len1 = all_renderers.length; j < len1; j++) {
                        r = all_renderers[j];
                        if (r instanceof glyph_renderer_1.GlyphRenderer) {
                            results.push(r);
                        }
                    }
                    return results;
                })();
                renderers = renderers.concat(rs);
            }
        }
        if (names.length > 0) {
            renderers = (function () {
                var j, len1, results;
                results = [];
                for (j = 0, len1 = renderers.length; j < len1; j++) {
                    r = renderers[j];
                    if (names.indexOf(r.name) >= 0) {
                        results.push(r);
                    }
                }
                return results;
            })();
        }
        logging_1.logger.debug("computed " + renderers.length + " renderers for DataRange1d " + this.id);
        for (j = 0, len1 = renderers.length; j < len1; j++) {
            r = renderers[j];
            logging_1.logger.trace(" - " + r.type + " " + r.id);
        }
        return renderers;
    };
    DataRange1d.prototype._compute_plot_bounds = function (renderers, bounds) {
        var i, len, r, result;
        result = bbox.empty();
        for (i = 0, len = renderers.length; i < len; i++) {
            r = renderers[i];
            if (bounds[r.id] != null) {
                result = bbox.union(result, bounds[r.id]);
            }
        }
        return result;
    };
    DataRange1d.prototype._compute_min_max = function (plot_bounds, dimension) {
        var k, max, min, overall, ref, ref1, v;
        overall = bbox.empty();
        for (k in plot_bounds) {
            v = plot_bounds[k];
            overall = bbox.union(overall, v);
        }
        if (dimension === 0) {
            ref = [overall.minX, overall.maxX], min = ref[0], max = ref[1];
        }
        else {
            ref1 = [overall.minY, overall.maxY], min = ref1[0], max = ref1[1];
        }
        return [min, max];
    };
    DataRange1d.prototype._compute_range = function (min, max) {
        var center, end, follow_interval, follow_sign, log_max, log_min, range_padding, ref, ref1, ref2, ref3, span, start;
        range_padding = this.range_padding;
        if ((range_padding != null) && range_padding > 0) {
            if (this.mapper_hint === "log") {
                if (isNaN(min) || !isFinite(min) || min <= 0) {
                    if (isNaN(max) || !isFinite(max) || max <= 0) {
                        min = 0.1;
                    }
                    else {
                        min = max / 100;
                    }
                    logging_1.logger.warn("could not determine minimum data value for log axis, DataRange1d using value " + min);
                }
                if (isNaN(max) || !isFinite(max) || max <= 0) {
                    if (isNaN(min) || !isFinite(min) || min <= 0) {
                        max = 10;
                    }
                    else {
                        max = min * 100;
                    }
                    logging_1.logger.warn("could not determine maximum data value for log axis, DataRange1d using value " + max);
                }
                log_min = Math.log(min) / Math.log(10);
                log_max = Math.log(max) / Math.log(10);
                if (max === min) {
                    span = this.default_span + 0.001;
                }
                else {
                    span = (log_max - log_min) * (1 + range_padding);
                }
                center = (log_min + log_max) / 2.0;
                ref = [Math.pow(10, center - span / 2.0), Math.pow(10, center + span / 2.0)], start = ref[0], end = ref[1];
            }
            else {
                if (max === min) {
                    span = this.default_span;
                }
                else {
                    span = (max - min) * (1 + range_padding);
                }
                center = (max + min) / 2.0;
                ref1 = [center - span / 2.0, center + span / 2.0], start = ref1[0], end = ref1[1];
            }
        }
        else {
            ref2 = [min, max], start = ref2[0], end = ref2[1];
        }
        follow_sign = +1;
        if (this.flipped) {
            ref3 = [end, start], start = ref3[0], end = ref3[1];
            follow_sign = -1;
        }
        follow_interval = this.follow_interval;
        if ((follow_interval != null) && Math.abs(start - end) > follow_interval) {
            if (this.follow === 'start') {
                end = start + follow_sign * follow_interval;
            }
            else if (this.follow === 'end') {
                start = end - follow_sign * follow_interval;
            }
        }
        return [start, end];
    };
    DataRange1d.prototype.update = function (bounds, dimension, bounds_id) {
        var _end, _start, end, max, min, new_range, ref, ref1, ref2, renderers, start;
        if (this.have_updated_interactively) {
            return;
        }
        renderers = this.computed_renderers();
        this.plot_bounds[bounds_id] = this._compute_plot_bounds(renderers, bounds);
        ref = this._compute_min_max(this.plot_bounds, dimension), min = ref[0], max = ref[1];
        ref1 = this._compute_range(min, max), start = ref1[0], end = ref1[1];
        if (this._initial_start != null) {
            if (this.mapper_hint === "log") {
                if (this._initial_start > 0) {
                    start = this._initial_start;
                }
            }
            else {
                start = this._initial_start;
            }
        }
        if (this._initial_end != null) {
            if (this.mapper_hint === "log") {
                if (this._initial_end > 0) {
                    end = this._initial_end;
                }
            }
            else {
                end = this._initial_end;
            }
        }
        ref2 = [this.start, this.end], _start = ref2[0], _end = ref2[1];
        if (start !== _start || end !== _end) {
            new_range = {};
            if (start !== _start) {
                new_range.start = start;
            }
            if (end !== _end) {
                new_range.end = end;
            }
            this.setv(new_range);
        }
        if (this.bounds === 'auto') {
            this.setv({
                bounds: [start, end]
            }, {
                silent: true
            });
        }
        return this.trigger('change');
    };
    DataRange1d.prototype.reset = function () {
        this.have_updated_interactively = false;
        this.setv({
            range_padding: this._initial_range_padding,
            follow: this._initial_follow,
            follow_interval: this._initial_follow_interval,
            default_span: this._initial_default_span
        }, {
            silent: true
        });
        return this.trigger('change');
    };
    return DataRange1d;
})(data_range_1.DataRange);

},{"../renderers/glyph_renderer":"models/renderers/glyph_renderer","./data_range":"models/ranges/data_range","core/logging":"core/logging","core/properties":"core/properties","core/util/bbox":"core/util/bbox"}],"models/ranges/factor_range":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var range_1 = require("./range");
var p = require("core/properties");
exports.FactorRange = (function (superClass) {
    extend(FactorRange, superClass);
    function FactorRange() {
        return FactorRange.__super__.constructor.apply(this, arguments);
    }
    FactorRange.prototype.type = 'FactorRange';
    FactorRange.define({
        offset: [p.Number, 0],
        factors: [p.Array, []],
        bounds: [p.Any],
        min_interval: [p.Any],
        max_interval: [p.Any]
    });
    FactorRange.internal({
        _bounds_as_factors: [p.Any],
        start: [p.Number],
        end: [p.Number]
    });
    FactorRange.prototype.initialize = function (attrs, options) {
        FactorRange.__super__.initialize.call(this, attrs, options);
        if ((this.bounds != null) && this.bounds !== 'auto') {
            this.setv({
                _bounds_as_factors: this.bounds
            }, {
                silent: true
            });
        }
        else {
            this.setv({
                _bounds_as_factors: this.factors
            }, {
                silent: true
            });
        }
        this._init();
        this.listenTo(this, 'change:factors', this._update_factors);
        return this.listenTo(this, 'change:offset', this._init);
    };
    FactorRange.getters({
        min: function () {
            return this.start;
        },
        max: function () {
            return this.end;
        }
    });
    FactorRange.prototype.reset = function () {
        this._init();
        return this.trigger('change');
    };
    FactorRange.prototype._update_factors = function () {
        this.setv('_bounds_as_factors', this.factors, {
            silent: true
        });
        return this._init();
    };
    FactorRange.prototype._init = function () {
        var end, factors, start;
        factors = this.factors;
        if ((this.bounds != null) && this.bounds !== 'auto') {
            factors = this._bounds_as_factors;
            this.setv({
                factors: factors
            }, {
                silent: true
            });
        }
        start = 0.5 + this.offset;
        end = factors.length + start;
        this.setv({
            start: start,
            end: end
        }, {
            silent: true
        });
        if (this.bounds != null) {
            return this.setv({
                bounds: [start, end]
            }, {
                silent: true
            });
        }
    };
    return FactorRange;
})(range_1.Range);

},{"./range":"models/ranges/range","core/properties":"core/properties"}],"models/ranges/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var data_range_1 = require("./data_range");
exports.DataRange = data_range_1.DataRange;
var data_range1d_1 = require("./data_range1d");
exports.DataRange1d = data_range1d_1.DataRange1d;
var factor_range_1 = require("./factor_range");
exports.FactorRange = factor_range_1.FactorRange;
var range_1 = require("./range");
exports.Range = range_1.Range;
var range1d_1 = require("./range1d");
exports.Range1d = range1d_1.Range1d;

},{"./data_range":"models/ranges/data_range","./data_range1d":"models/ranges/data_range1d","./factor_range":"models/ranges/factor_range","./range":"models/ranges/range","./range1d":"models/ranges/range1d"}],"models/ranges/range":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var model_1 = require("../../model");
var p = require("core/properties");
exports.Range = (function (superClass) {
    extend(Range, superClass);
    function Range() {
        return Range.__super__.constructor.apply(this, arguments);
    }
    Range.prototype.type = 'Range';
    Range.prototype.initialize = function (options) {
        Range.__super__.initialize.call(this, options);
        return this.listenTo(this, 'change', function () {
            var ref;
            return (ref = this.callback) != null ? ref.execute(this) : void 0;
        });
    };
    Range.define({
        callback: [p.Instance]
    });
    Range.internal({
        plots: [p.Array, []]
    });
    Range.prototype.reset = function () {
        "This method should be reimplemented by subclasses and ensure that\nthe callback, if exists, is executed at completion.";
        return this.trigger('change');
    };
    return Range;
})(model_1.Model);

},{"../../model":"model","core/properties":"core/properties"}],"models/ranges/range1d":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var range_1 = require("./range");
var p = require("core/properties");
exports.Range1d = (function (superClass) {
    extend(Range1d, superClass);
    Range1d.prototype.type = 'Range1d';
    Range1d.define({
        start: [p.Number, 0],
        end: [p.Number, 1],
        bounds: [p.Any],
        min_interval: [p.Any],
        max_interval: [p.Any]
    });
    Range1d.prototype._set_auto_bounds = function () {
        var max, min;
        if (this.bounds === 'auto') {
            min = Math.min(this._initial_start, this._initial_end);
            max = Math.max(this._initial_start, this._initial_end);
            return this.setv({
                bounds: [min, max]
            }, {
                silent: true
            });
        }
    };
    function Range1d() {
        var end, start;
        if (this instanceof Range1d) {
            return Range1d.__super__.constructor.apply(this, arguments);
        }
        else {
            start = arguments[0], end = arguments[1];
            return new Range1d({
                start: start,
                end: end
            });
        }
    }
    Range1d.prototype.initialize = function (attrs, options) {
        Range1d.__super__.initialize.call(this, attrs, options);
        this._initial_start = this.start;
        this._initial_end = this.end;
        return this._set_auto_bounds();
    };
    Range1d.getters({
        min: function () {
            return Math.min(this.start, this.end);
        },
        max: function () {
            return Math.max(this.start, this.end);
        }
    });
    Range1d.prototype.reset = function () {
        this._set_auto_bounds();
        if (this.start !== this._initial_start || this.end !== this._initial_end) {
            return this.setv({
                start: this._initial_start,
                end: this._initial_end
            });
        }
        else {
            return this.trigger('change');
        }
    };
    return Range1d;
})(range_1.Range);

},{"./range":"models/ranges/range","core/properties":"core/properties"}],"models/renderers/glyph_renderer":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend1 = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, indexOf = [].indexOf || function (item) { for (var i = 0, l = this.length; i < l; i++) {
    if (i in this && this[i] === item)
        return i;
} return -1; };
var renderer_1 = require("./renderer");
var remote_data_source_1 = require("../sources/remote_data_source");
var logging_1 = require("core/logging");
var p = require("core/properties");
var array_1 = require("core/util/array");
var object_1 = require("core/util/object");
exports.GlyphRendererView = (function (superClass) {
    extend1(GlyphRendererView, superClass);
    function GlyphRendererView() {
        return GlyphRendererView.__super__.constructor.apply(this, arguments);
    }
    GlyphRendererView.prototype.initialize = function (options) {
        var base_glyph, decimated_glyph, glyph_attrs, has_fill, has_line, hover_glyph, mk_glyph, muted_glyph, nonselection_glyph, selection_glyph;
        GlyphRendererView.__super__.initialize.call(this, options);
        base_glyph = this.model.glyph;
        has_fill = indexOf.call(base_glyph.mixins, "fill") >= 0;
        has_line = indexOf.call(base_glyph.mixins, "line") >= 0;
        glyph_attrs = object_1.clone(base_glyph.attributes);
        delete glyph_attrs.id;
        mk_glyph = function (defaults) {
            var attrs;
            attrs = object_1.clone(glyph_attrs);
            if (has_fill) {
                object_1.extend(attrs, defaults.fill);
            }
            if (has_line) {
                object_1.extend(attrs, defaults.line);
            }
            return new base_glyph.constructor(attrs);
        };
        this.glyph = this.build_glyph_view(base_glyph);
        selection_glyph = this.model.selection_glyph;
        if (selection_glyph == null) {
            selection_glyph = mk_glyph({
                fill: {},
                line: {}
            });
        }
        else if (selection_glyph === "auto") {
            selection_glyph = mk_glyph(this.model.selection_defaults);
        }
        this.selection_glyph = this.build_glyph_view(selection_glyph);
        nonselection_glyph = this.model.nonselection_glyph;
        if (nonselection_glyph == null) {
            nonselection_glyph = mk_glyph({
                fill: {},
                line: {}
            });
        }
        else if (nonselection_glyph === "auto") {
            nonselection_glyph = mk_glyph(this.model.nonselection_defaults);
        }
        this.nonselection_glyph = this.build_glyph_view(nonselection_glyph);
        hover_glyph = this.model.hover_glyph;
        if (hover_glyph != null) {
            this.hover_glyph = this.build_glyph_view(hover_glyph);
        }
        muted_glyph = this.model.muted_glyph;
        if (muted_glyph != null) {
            this.muted_glyph = this.build_glyph_view(muted_glyph);
        }
        decimated_glyph = mk_glyph(this.model.decimated_defaults);
        this.decimated_glyph = this.build_glyph_view(decimated_glyph);
        this.xmapper = this.plot_view.frame.x_mappers[this.model.x_range_name];
        this.ymapper = this.plot_view.frame.y_mappers[this.model.y_range_name];
        this.set_data(false);
        if (this.model.data_source instanceof remote_data_source_1.RemoteDataSource) {
            return this.model.data_source.setup(this.plot_view, this.glyph);
        }
    };
    GlyphRendererView.prototype.build_glyph_view = function (model) {
        return new model.default_view({
            model: model,
            renderer: this,
            plot_view: this.plot_view
        });
    };
    GlyphRendererView.prototype.bind_bokeh_events = function () {
        this.listenTo(this.model, 'change', this.request_render);
        this.listenTo(this.model.data_source, 'change', this.set_data);
        this.listenTo(this.model.data_source, 'patch', this.set_data);
        this.listenTo(this.model.data_source, 'stream', this.set_data);
        this.listenTo(this.model.data_source, 'select', this.request_render);
        if (this.hover_glyph != null) {
            this.listenTo(this.model.data_source, 'inspect', this.request_render);
        }
        this.listenTo(this.model.glyph, 'transformchange', function () {
            return this.set_data();
        });
        return this.listenTo(this.model.glyph, 'propchange', function () {
            this.glyph.set_visuals(this.model.data_source);
            return this.request_render();
        });
    };
    GlyphRendererView.prototype.have_selection_glyphs = function () {
        return (this.selection_glyph != null) && (this.nonselection_glyph != null);
    };
    GlyphRendererView.prototype.set_data = function (request_render, arg) {
        var dt, i, j, k, length, lod_factor, ref, results, source, t0;
        if (request_render == null) {
            request_render = true;
        }
        t0 = Date.now();
        source = this.model.data_source;
        this.glyph.model.setv({
            x_range_name: this.model.x_range_name,
            y_range_name: this.model.y_range_name
        }, {
            silent: true
        });
        this.glyph.set_data(source, arg);
        this.glyph.set_visuals(source);
        this.decimated_glyph.set_visuals(source);
        if (this.have_selection_glyphs()) {
            this.selection_glyph.set_visuals(source);
            this.nonselection_glyph.set_visuals(source);
        }
        if (this.hover_glyph != null) {
            this.hover_glyph.set_visuals(source);
        }
        if (this.muted_glyph != null) {
            this.muted_glyph.set_visuals(source);
        }
        length = source.get_length();
        if (length == null) {
            length = 1;
        }
        this.all_indices = (function () {
            results = [];
            for (var j = 0; 0 <= length ? j < length : j > length; 0 <= length ? j++ : j--) {
                results.push(j);
            }
            return results;
        }).apply(this);
        lod_factor = this.plot_model.plot.lod_factor;
        this.decimated = [];
        for (i = k = 0, ref = Math.floor(this.all_indices.length / lod_factor); 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
            this.decimated.push(this.all_indices[i * lod_factor]);
        }
        dt = Date.now() - t0;
        logging_1.logger.debug(this.glyph.model.type + " GlyphRenderer (" + this.model.id + "): set_data finished in " + dt + "ms");
        this.set_data_timestamp = Date.now();
        if (request_render) {
            return this.request_render();
        }
    };
    GlyphRendererView.prototype.render = function () {
        var ctx, dtmap, dtmask, dtrender, dtselect, dttot, glsupport, glyph, i, indices, inspected, j, k, len, len1, lod_threshold, nonselected, nonselection_glyph, selected, selected_mask, selection_glyph, t0, tmap, tmask, trender, tselect;
        if (!this.model.visible) {
            return;
        }
        t0 = Date.now();
        glsupport = this.glyph.glglyph;
        tmap = Date.now();
        this.glyph.map_data();
        dtmap = Date.now() - t0;
        tmask = Date.now();
        indices = this.glyph.mask_data(this.all_indices);
        dtmask = Date.now() - tmask;
        ctx = this.plot_view.canvas_view.ctx;
        ctx.save();
        selected = this.model.data_source.selected;
        if (!selected || selected.length === 0) {
            selected = [];
        }
        else {
            if (selected['0d'].glyph) {
                selected = indices;
            }
            else if (selected['1d'].indices.length > 0) {
                selected = selected['1d'].indices;
            }
            else {
                selected = [];
            }
        }
        inspected = this.model.data_source.inspected;
        if (!inspected || inspected.length === 0) {
            inspected = [];
        }
        else {
            if (inspected['0d'].glyph) {
                inspected = indices;
            }
            else if (inspected['1d'].indices.length > 0) {
                inspected = inspected['1d'].indices;
            }
            else {
                inspected = [];
            }
        }
        lod_threshold = this.plot_model.plot.lod_threshold;
        if (this.plot_view.interactive && !glsupport && (lod_threshold != null) && this.all_indices.length > lod_threshold) {
            indices = this.decimated;
            glyph = this.decimated_glyph;
            nonselection_glyph = this.decimated_glyph;
            selection_glyph = this.selection_glyph;
        }
        else {
            glyph = this.model.muted && (this.muted_glyph != null) ? this.muted_glyph : this.glyph;
            nonselection_glyph = this.nonselection_glyph;
            selection_glyph = this.selection_glyph;
        }
        if ((this.hover_glyph != null) && inspected.length) {
            indices = array_1.difference(indices, inspected);
        }
        if (!(selected.length && this.have_selection_glyphs())) {
            trender = Date.now();
            glyph.render(ctx, indices, this.glyph);
            if (this.hover_glyph && inspected.length) {
                this.hover_glyph.render(ctx, inspected, this.glyph);
            }
            dtrender = Date.now() - trender;
        }
        else {
            tselect = Date.now();
            selected_mask = {};
            for (j = 0, len = selected.length; j < len; j++) {
                i = selected[j];
                selected_mask[i] = true;
            }
            selected = new Array();
            nonselected = new Array();
            for (k = 0, len1 = indices.length; k < len1; k++) {
                i = indices[k];
                if (selected_mask[i] != null) {
                    selected.push(i);
                }
                else {
                    nonselected.push(i);
                }
            }
            dtselect = Date.now() - tselect;
            trender = Date.now();
            nonselection_glyph.render(ctx, nonselected, this.glyph);
            selection_glyph.render(ctx, selected, this.glyph);
            if (this.hover_glyph != null) {
                this.hover_glyph.render(ctx, inspected, this.glyph);
            }
            dtrender = Date.now() - trender;
        }
        this.last_dtrender = dtrender;
        dttot = Date.now() - t0;
        logging_1.logger.debug(this.glyph.model.type + " GlyphRenderer (" + this.model.id + "): render finished in " + dttot + "ms");
        logging_1.logger.trace(" - map_data finished in       : " + dtmap + "ms");
        if (dtmask != null) {
            logging_1.logger.trace(" - mask_data finished in      : " + dtmask + "ms");
        }
        if (dtselect != null) {
            logging_1.logger.trace(" - selection mask finished in : " + dtselect + "ms");
        }
        logging_1.logger.trace(" - glyph renders finished in  : " + dtrender + "ms");
        return ctx.restore();
    };
    GlyphRendererView.prototype.map_to_screen = function (x, y) {
        return this.plot_view.map_to_screen(x, y, this.model.x_range_name, this.model.y_range_name);
    };
    GlyphRendererView.prototype.draw_legend = function (ctx, x0, x1, y0, y1, field, label) {
        var index;
        index = this.model.get_reference_point(field, label);
        return this.glyph.draw_legend_for_index(ctx, x0, x1, y0, y1, index);
    };
    GlyphRendererView.prototype.hit_test = function (geometry) {
        return this.glyph.hit_test(geometry);
    };
    return GlyphRendererView;
})(renderer_1.RendererView);
exports.GlyphRenderer = (function (superClass) {
    extend1(GlyphRenderer, superClass);
    function GlyphRenderer() {
        return GlyphRenderer.__super__.constructor.apply(this, arguments);
    }
    GlyphRenderer.prototype.default_view = exports.GlyphRendererView;
    GlyphRenderer.prototype.type = 'GlyphRenderer';
    GlyphRenderer.prototype.get_reference_point = function (field, value) {
        var data, i, index;
        index = 0;
        if ((field != null) && (this.data_source.get_column != null)) {
            data = this.data_source.get_column(field);
            if (data) {
                i = data.indexOf(value);
                if (i > 0) {
                    index = i;
                }
            }
        }
        return index;
    };
    GlyphRenderer.define({
        x_range_name: [p.String, 'default'],
        y_range_name: [p.String, 'default'],
        data_source: [p.Instance],
        glyph: [p.Instance],
        hover_glyph: [p.Instance],
        nonselection_glyph: [p.Any, 'auto'],
        selection_glyph: [p.Any, 'auto'],
        muted_glyph: [p.Instance],
        muted: [p.Bool, false]
    });
    GlyphRenderer.override({
        level: 'glyph'
    });
    GlyphRenderer.prototype.selection_defaults = {
        fill: {},
        line: {}
    };
    GlyphRenderer.prototype.decimated_defaults = {
        fill: {
            fill_alpha: 0.3,
            fill_color: "grey"
        },
        line: {
            line_alpha: 0.3,
            line_color: "grey"
        }
    };
    GlyphRenderer.prototype.nonselection_defaults = {
        fill: {
            fill_alpha: 0.2,
            line_alpha: 0.2
        },
        line: {}
    };
    return GlyphRenderer;
})(renderer_1.Renderer);

},{"../sources/remote_data_source":"models/sources/remote_data_source","./renderer":"models/renderers/renderer","core/logging":"core/logging","core/properties":"core/properties","core/util/array":"core/util/array","core/util/object":"core/util/object"}],"models/renderers/guide_renderer":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var renderer_1 = require("./renderer");
var p = require("core/properties");
exports.GuideRenderer = (function (superClass) {
    extend(GuideRenderer, superClass);
    function GuideRenderer() {
        return GuideRenderer.__super__.constructor.apply(this, arguments);
    }
    GuideRenderer.prototype.type = 'GuideRenderer';
    GuideRenderer.define({
        plot: [p.Instance]
    });
    GuideRenderer.override({
        level: 'overlay'
    });
    return GuideRenderer;
})(renderer_1.Renderer);

},{"./renderer":"models/renderers/renderer","core/properties":"core/properties"}],"models/renderers/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var glyph_renderer_1 = require("./glyph_renderer");
exports.GlyphRenderer = glyph_renderer_1.GlyphRenderer;
var guide_renderer_1 = require("./guide_renderer");
exports.GuideRenderer = guide_renderer_1.GuideRenderer;
var renderer_1 = require("./renderer");
exports.Renderer = renderer_1.Renderer;

},{"./glyph_renderer":"models/renderers/glyph_renderer","./guide_renderer":"models/renderers/guide_renderer","./renderer":"models/renderers/renderer"}],"models/renderers/renderer":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend1 = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var bokeh_view_1 = require("core/bokeh_view");
var visuals_1 = require("core/visuals");
var p = require("core/properties");
var proj = require("core/util/projections");
var object_1 = require("core/util/object");
var model_1 = require("../../model");
exports.RendererView = (function (superClass) {
    extend1(RendererView, superClass);
    function RendererView() {
        return RendererView.__super__.constructor.apply(this, arguments);
    }
    RendererView.prototype.initialize = function (options) {
        RendererView.__super__.initialize.call(this, options);
        this.plot_view = options.plot_view;
        return this.visuals = new visuals_1.Visuals(this.model);
    };
    RendererView.getters({
        plot_model: function () {
            return this.plot_view.model;
        }
    });
    RendererView.prototype.request_render = function () {
        return this.plot_view.request_render();
    };
    RendererView.prototype.set_data = function (source) {
        var data, ref, ref1;
        data = this.model.materialize_dataspecs(source);
        object_1.extend(this, data);
        if (this.plot_model.use_map) {
            if (this._x != null) {
                ref = proj.project_xy(this._x, this._y), this._x = ref[0], this._y = ref[1];
            }
            if (this._xs != null) {
                return ref1 = proj.project_xsys(this._xs, this._ys), this._xs = ref1[0], this._ys = ref1[1], ref1;
            }
        }
    };
    RendererView.prototype.map_to_screen = function (x, y) {
        return this.plot_view.map_to_screen(x, y, this.model.x_range_name, this.model.y_range_name);
    };
    return RendererView;
})(bokeh_view_1.BokehView);
exports.Renderer = (function (superClass) {
    extend1(Renderer, superClass);
    function Renderer() {
        return Renderer.__super__.constructor.apply(this, arguments);
    }
    Renderer.prototype.type = "Renderer";
    Renderer.define({
        level: [p.RenderLevel, null],
        visible: [p.Bool, true]
    });
    return Renderer;
})(model_1.Model);

},{"../../model":"model","core/bokeh_view":"core/bokeh_view","core/properties":"core/properties","core/util/object":"core/util/object","core/util/projections":"core/util/projections","core/visuals":"core/visuals"}],"models/sources/ajax_data_source":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var bind = function (fn, me) { return function () { return fn.apply(me, arguments); }; }, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var remote_data_source_1 = require("./remote_data_source");
var logging_1 = require("core/logging");
var p = require("core/properties");
exports.AjaxDataSource = (function (superClass) {
    extend(AjaxDataSource, superClass);
    function AjaxDataSource() {
        this.get_data = bind(this.get_data, this);
        this.setup = bind(this.setup, this);
        this.destroy = bind(this.destroy, this);
        return AjaxDataSource.__super__.constructor.apply(this, arguments);
    }
    AjaxDataSource.prototype.type = 'AjaxDataSource';
    AjaxDataSource.define({
        mode: [p.String, 'replace'],
        content_type: [p.String, 'application/json'],
        http_headers: [p.Any, {}],
        max_size: [p.Number],
        method: [p.String, 'POST'],
        if_modified: [p.Bool, false]
    });
    AjaxDataSource.prototype.destroy = function () {
        if (this.interval != null) {
            return clearInterval(this.interval);
        }
    };
    AjaxDataSource.prototype.setup = function (plot_view, glyph) {
        this.pv = plot_view;
        this.get_data(this.mode);
        if (this.polling_interval) {
            return this.interval = setInterval(this.get_data, this.polling_interval, this.mode, this.max_size, this.if_modified);
        }
    };
    AjaxDataSource.prototype.get_data = function (mode, max_size, if_modified) {
        var name, ref, value, xhr;
        if (max_size == null) {
            max_size = 0;
        }
        if (if_modified == null) {
            if_modified = false;
        }
        xhr = new XMLHttpRequest();
        xhr.open(this.method, this.data_url, true);
        xhr.withCredentials = false;
        xhr.setRequestHeader("Content-Type", this.content_type);
        ref = this.http_headers;
        for (name in ref) {
            value = ref[name];
            xhr.setRequestHeader(name, value);
        }
        xhr.addEventListener("load", (function (_this) {
            return function () {
                var column, data, i, len, original_data, ref1;
                if (xhr.status === 200) {
                    data = JSON.parse(xhr.responseText);
                    switch (mode) {
                        case 'replace':
                            return _this.data = data;
                        case 'append':
                            original_data = _this.data;
                            ref1 = _this.columns();
                            for (i = 0, len = ref1.length; i < len; i++) {
                                column = ref1[i];
                                data[column] = original_data[column].concat(data[column]).slice(-max_size);
                            }
                            return _this.data = data;
                    }
                }
            };
        })(this));
        xhr.addEventListener("error", (function (_this) {
            return function () {
                return logging_1.logger.error("Failed to fetch JSON from " + _this.data_url + " with code " + xhr.status);
            };
        })(this));
        xhr.send();
        return null;
    };
    return AjaxDataSource;
})(remote_data_source_1.RemoteDataSource);

},{"./remote_data_source":"models/sources/remote_data_source","core/logging":"core/logging","core/properties":"core/properties"}],"models/sources/column_data_source":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var columnar_data_source_1 = require("./columnar_data_source");
var has_props_1 = require("core/has_props");
var p = require("core/properties");
var serialization = require("core/util/serialization");
var types_1 = require("core/util/types");
exports.concat_typed_arrays = function (a, b) {
    var c;
    c = new a.constructor(a.length + b.length);
    c.set(a, 0);
    c.set(b, a.length);
    return c;
};
exports.stream_to_column = function (col, new_col, rollover) {
    var end, i, j, l, ref, ref1, ref2, start, tmp, total_len;
    if (col.concat != null) {
        col = col.concat(new_col);
        if (col.length > rollover) {
            col = col.slice(-rollover);
        }
        return col;
    }
    total_len = col.length + new_col.length;
    if ((rollover != null) && total_len > rollover) {
        start = total_len - rollover;
        end = col.length;
        if (col.length < rollover) {
            tmp = new col.constructor(rollover);
            tmp.set(col, 0);
            col = tmp;
        }
        for (i = j = ref = start, ref1 = end; ref <= ref1 ? j < ref1 : j > ref1; i = ref <= ref1 ? ++j : --j) {
            col[i - start] = col[i];
        }
        for (i = l = 0, ref2 = new_col.length; 0 <= ref2 ? l < ref2 : l > ref2; i = 0 <= ref2 ? ++l : --l) {
            col[i + (end - start)] = new_col[i];
        }
        return col;
    }
    tmp = new col.constructor(new_col);
    return exports.concat_typed_arrays(col, tmp);
};
exports.patch_to_column = function (col, patch) {
    var i, ind, j, ref, ref1, results, value;
    results = [];
    for (i = j = 0, ref = patch.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        ref1 = patch[i], ind = ref1[0], value = ref1[1];
        results.push(col[ind] = value);
    }
    return results;
};
exports.ColumnDataSource = (function (superClass) {
    extend(ColumnDataSource, superClass);
    function ColumnDataSource() {
        return ColumnDataSource.__super__.constructor.apply(this, arguments);
    }
    ColumnDataSource.prototype.type = 'ColumnDataSource';
    ColumnDataSource.prototype.initialize = function (options) {
        var ref;
        ColumnDataSource.__super__.initialize.call(this, options);
        return ref = serialization.decode_column_data(this.data), this.data = ref[0], this._shapes = ref[1], ref;
    };
    ColumnDataSource.define({
        data: [p.Any, {}]
    });
    ColumnDataSource.prototype.attributes_as_json = function (include_defaults, value_to_json) {
        var attrs, key, ref, value;
        if (include_defaults == null) {
            include_defaults = true;
        }
        if (value_to_json == null) {
            value_to_json = ColumnDataSource._value_to_json;
        }
        attrs = {};
        ref = this.serializable_attributes();
        for (key in ref) {
            if (!hasProp.call(ref, key))
                continue;
            value = ref[key];
            if (key === 'data') {
                value = serialization.encode_column_data(value, this._shapes);
            }
            if (include_defaults) {
                attrs[key] = value;
            }
            else if (key in this._set_after_defaults) {
                attrs[key] = value;
            }
        }
        return value_to_json("attributes", attrs, this);
    };
    ColumnDataSource._value_to_json = function (key, value, optional_parent_object) {
        if (types_1.isObject(value) && key === 'data') {
            return serialization.encode_column_data(value, optional_parent_object._shapes);
        }
        else {
            return has_props_1.HasProps._value_to_json(key, value, optional_parent_object);
        }
    };
    ColumnDataSource.prototype.stream = function (new_data, rollover) {
        var data, k, v;
        data = this.data;
        for (k in new_data) {
            v = new_data[k];
            data[k] = exports.stream_to_column(data[k], new_data[k], rollover);
        }
        this.setv('data', data, {
            silent: true
        });
        return this.trigger('stream');
    };
    ColumnDataSource.prototype.patch = function (patches) {
        var data, k, patch;
        data = this.data;
        for (k in patches) {
            patch = patches[k];
            exports.patch_to_column(data[k], patch);
        }
        this.setv('data', data, {
            silent: true
        });
        return this.trigger('patch');
    };
    return ColumnDataSource;
})(columnar_data_source_1.ColumnarDataSource);

},{"./columnar_data_source":"models/sources/columnar_data_source","core/has_props":"core/has_props","core/properties":"core/properties","core/util/serialization":"core/util/serialization","core/util/types":"core/util/types"}],"models/sources/columnar_data_source":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var data_source_1 = require("./data_source");
var logging_1 = require("core/logging");
var selection_manager_1 = require("core/selection_manager");
var p = require("core/properties");
var array_1 = require("core/util/array");
exports.ColumnarDataSource = (function (superClass) {
    extend(ColumnarDataSource, superClass);
    function ColumnarDataSource() {
        return ColumnarDataSource.__super__.constructor.apply(this, arguments);
    }
    ColumnarDataSource.prototype.type = 'ColumnarDataSource';
    ColumnarDataSource.define({
        column_names: [p.Array, []]
    });
    ColumnarDataSource.internal({
        selection_manager: [
            p.Instance, function (self) {
                return new selection_manager_1.SelectionManager({
                    source: self
                });
            }
        ],
        inspected: [p.Any],
        _shapes: [p.Any, {}]
    });
    ColumnarDataSource.prototype.get_column = function (colname) {
        var ref;
        return (ref = this.data[colname]) != null ? ref : null;
    };
    ColumnarDataSource.prototype.columns = function () {
        return Object.keys(this.data);
    };
    ColumnarDataSource.prototype.get_length = function (soft) {
        var _key, lengths, msg, val;
        if (soft == null) {
            soft = true;
        }
        lengths = array_1.uniq((function () {
            var ref, results;
            ref = this.data;
            results = [];
            for (_key in ref) {
                val = ref[_key];
                results.push(val.length);
            }
            return results;
        }).call(this));
        switch (lengths.length) {
            case 0:
                return null;
            case 1:
                return lengths[0];
            default:
                msg = "data source has columns of inconsistent lengths";
                if (soft) {
                    logging_1.logger.warn(msg);
                    return lengths.sort()[0];
                }
                else {
                    throw new Error(msg);
                }
        }
    };
    return ColumnarDataSource;
})(data_source_1.DataSource);

},{"./data_source":"models/sources/data_source","core/logging":"core/logging","core/properties":"core/properties","core/selection_manager":"core/selection_manager","core/util/array":"core/util/array"}],"models/sources/data_source":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var model_1 = require("../../model");
var hittest = require("core/hittest");
var p = require("core/properties");
var types_1 = require("core/util/types");
exports.DataSource = (function (superClass) {
    extend(DataSource, superClass);
    function DataSource() {
        return DataSource.__super__.constructor.apply(this, arguments);
    }
    DataSource.prototype.type = 'DataSource';
    DataSource.define({
        selected: [p.Any, hittest.create_hit_test_result()],
        callback: [p.Any]
    });
    DataSource.prototype.initialize = function (options) {
        DataSource.__super__.initialize.call(this, options);
        return this.listenTo(this, 'change:selected', (function (_this) {
            return function () {
                var callback;
                callback = _this.callback;
                if (callback != null) {
                    if (types_1.isFunction(callback)) {
                        return callback(_this);
                    }
                    else {
                        return callback.execute(_this);
                    }
                }
            };
        })(this));
    };
    return DataSource;
})(model_1.Model);

},{"../../model":"model","core/hittest":"core/hittest","core/properties":"core/properties","core/util/types":"core/util/types"}],"models/sources/geojson_data_source":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var columnar_data_source_1 = require("./columnar_data_source");
var logging_1 = require("core/logging");
var p = require("core/properties");
exports.GeoJSONDataSource = (function (superClass) {
    extend(GeoJSONDataSource, superClass);
    function GeoJSONDataSource() {
        return GeoJSONDataSource.__super__.constructor.apply(this, arguments);
    }
    GeoJSONDataSource.prototype.type = 'GeoJSONDataSource';
    GeoJSONDataSource.define({
        geojson: [p.Any]
    });
    GeoJSONDataSource.internal({
        data: [p.Any, {}]
    });
    GeoJSONDataSource.prototype.initialize = function (options) {
        GeoJSONDataSource.__super__.initialize.call(this, options);
        this._update_data();
        return this.listenTo(this, 'change:geojson', (function (_this) {
            return function () {
                return _this._update_data();
            };
        })(this));
    };
    GeoJSONDataSource.prototype._update_data = function () {
        return this.data = this.geojson_to_column_data();
    };
    GeoJSONDataSource.prototype._get_new_list_array = function (length) {
        var i, k, ref, results;
        results = [];
        for (i = k = 0, ref = length; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
            results.push([]);
        }
        return results;
    };
    GeoJSONDataSource.prototype._get_new_nan_array = function (length) {
        var i, k, ref, results;
        results = [];
        for (i = k = 0, ref = length; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
            results.push(0 / 0);
        }
        return results;
    };
    GeoJSONDataSource.prototype._flatten_function = function (accumulator, currentItem) {
        return accumulator.concat([[0 / 0, 0 / 0, 0 / 0]]).concat(currentItem);
    };
    GeoJSONDataSource.prototype._add_properties = function (item, data, i, item_count) {
        var property, results;
        results = [];
        for (property in item.properties) {
            if (!data.hasOwnProperty(property)) {
                data[property] = this._get_new_nan_array(item_count);
            }
            results.push(data[property][i] = item.properties[property]);
        }
        return results;
    };
    GeoJSONDataSource.prototype._add_geometry = function (geometry, data, i) {
        var coord_list, coords, exterior_ring, exterior_rings, flattened_coord_list, j, k, l, len, len1, len2, len3, len4, m, n, o, polygon, ref, ref1, ref2, ref3, ref4, ref5, results, results1, results2, results3;
        switch (geometry.type) {
            case "Point":
                coords = geometry.coordinates;
                data.x[i] = coords[0];
                data.y[i] = coords[1];
                return data.z[i] = (ref = coords[2]) != null ? ref : 0 / 0;
            case "LineString":
                coord_list = geometry.coordinates;
                results = [];
                for (j = k = 0, len = coord_list.length; k < len; j = ++k) {
                    coords = coord_list[j];
                    data.xs[i][j] = coords[0];
                    data.ys[i][j] = coords[1];
                    results.push(data.zs[i][j] = (ref1 = coords[2]) != null ? ref1 : 0 / 0);
                }
                return results;
                break;
            case "Polygon":
                if (geometry.coordinates.length > 1) {
                    logging_1.logger.warn('Bokeh does not support Polygons with holes in, only exterior ring used.');
                }
                exterior_ring = geometry.coordinates[0];
                results1 = [];
                for (j = l = 0, len1 = exterior_ring.length; l < len1; j = ++l) {
                    coords = exterior_ring[j];
                    data.xs[i][j] = coords[0];
                    data.ys[i][j] = coords[1];
                    results1.push(data.zs[i][j] = (ref2 = coords[2]) != null ? ref2 : 0 / 0);
                }
                return results1;
                break;
            case "MultiPoint":
                return logging_1.logger.warn('MultiPoint not supported in Bokeh');
            case "MultiLineString":
                flattened_coord_list = geometry.coordinates.reduce(this._flatten_function);
                results2 = [];
                for (j = m = 0, len2 = flattened_coord_list.length; m < len2; j = ++m) {
                    coords = flattened_coord_list[j];
                    data.xs[i][j] = coords[0];
                    data.ys[i][j] = coords[1];
                    results2.push(data.zs[i][j] = (ref3 = coords[2]) != null ? ref3 : 0 / 0);
                }
                return results2;
                break;
            case "MultiPolygon":
                exterior_rings = [];
                ref4 = geometry.coordinates;
                for (n = 0, len3 = ref4.length; n < len3; n++) {
                    polygon = ref4[n];
                    if (polygon.length > 1) {
                        logging_1.logger.warn('Bokeh does not support Polygons with holes in, only exterior ring used.');
                    }
                    exterior_rings.push(polygon[0]);
                }
                flattened_coord_list = exterior_rings.reduce(this._flatten_function);
                results3 = [];
                for (j = o = 0, len4 = flattened_coord_list.length; o < len4; j = ++o) {
                    coords = flattened_coord_list[j];
                    data.xs[i][j] = coords[0];
                    data.ys[i][j] = coords[1];
                    results3.push(data.zs[i][j] = (ref5 = coords[2]) != null ? ref5 : 0 / 0);
                }
                return results3;
                break;
            default:
                throw new Error('Invalid type ' + geometry.type);
        }
    };
    GeoJSONDataSource.prototype._get_items_length = function (items) {
        var count, g, geometry, i, item, j, k, l, len, len1, ref;
        count = 0;
        for (i = k = 0, len = items.length; k < len; i = ++k) {
            item = items[i];
            geometry = item.type === 'Feature' ? item.geometry : item;
            if (geometry.type === 'GeometryCollection') {
                ref = geometry.geometries;
                for (j = l = 0, len1 = ref.length; l < len1; j = ++l) {
                    g = ref[j];
                    count += 1;
                }
            }
            else {
                count += 1;
            }
        }
        return count;
    };
    GeoJSONDataSource.prototype.geojson_to_column_data = function () {
        var arr_index, data, g, geojson, geometry, i, item, item_count, items, j, k, l, len, len1, ref, ref1;
        geojson = JSON.parse(this.geojson);
        if ((ref = geojson.type) !== 'GeometryCollection' && ref !== 'FeatureCollection') {
            throw new Error('Bokeh only supports type GeometryCollection and FeatureCollection at top level');
        }
        if (geojson.type === 'GeometryCollection') {
            if (geojson.geometries == null) {
                throw new Error('No geometries found in GeometryCollection');
            }
            if (geojson.geometries.length === 0) {
                throw new Error('geojson.geometries must have one or more items');
            }
            items = geojson.geometries;
        }
        if (geojson.type === 'FeatureCollection') {
            if (geojson.features == null) {
                throw new Error('No features found in FeaturesCollection');
            }
            if (geojson.features.length === 0) {
                throw new Error('geojson.features must have one or more items');
            }
            items = geojson.features;
        }
        item_count = this._get_items_length(items);
        data = {
            'x': this._get_new_nan_array(item_count),
            'y': this._get_new_nan_array(item_count),
            'z': this._get_new_nan_array(item_count),
            'xs': this._get_new_list_array(item_count),
            'ys': this._get_new_list_array(item_count),
            'zs': this._get_new_list_array(item_count)
        };
        arr_index = 0;
        for (i = k = 0, len = items.length; k < len; i = ++k) {
            item = items[i];
            geometry = item.type === 'Feature' ? item.geometry : item;
            if (geometry.type === 'GeometryCollection') {
                ref1 = geometry.geometries;
                for (j = l = 0, len1 = ref1.length; l < len1; j = ++l) {
                    g = ref1[j];
                    this._add_geometry(g, data, arr_index);
                    if (item.type === 'Feature') {
                        this._add_properties(item, data, arr_index, item_count);
                    }
                    arr_index += 1;
                }
            }
            else {
                this._add_geometry(geometry, data, arr_index);
                if (item.type === 'Feature') {
                    this._add_properties(item, data, arr_index, item_count);
                }
                arr_index += 1;
            }
        }
        return data;
    };
    return GeoJSONDataSource;
})(columnar_data_source_1.ColumnarDataSource);

},{"./columnar_data_source":"models/sources/columnar_data_source","core/logging":"core/logging","core/properties":"core/properties"}],"models/sources/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ajax_data_source_1 = require("./ajax_data_source");
exports.AjaxDataSource = ajax_data_source_1.AjaxDataSource;
var column_data_source_1 = require("./column_data_source");
exports.ColumnDataSource = column_data_source_1.ColumnDataSource;
var columnar_data_source_1 = require("./columnar_data_source");
exports.ColumnarDataSource = columnar_data_source_1.ColumnarDataSource;
var data_source_1 = require("./data_source");
exports.DataSource = data_source_1.DataSource;
var geojson_data_source_1 = require("./geojson_data_source");
exports.GeoJSONDataSource = geojson_data_source_1.GeoJSONDataSource;
var remote_data_source_1 = require("./remote_data_source");
exports.RemoteDataSource = remote_data_source_1.RemoteDataSource;

},{"./ajax_data_source":"models/sources/ajax_data_source","./column_data_source":"models/sources/column_data_source","./columnar_data_source":"models/sources/columnar_data_source","./data_source":"models/sources/data_source","./geojson_data_source":"models/sources/geojson_data_source","./remote_data_source":"models/sources/remote_data_source"}],"models/sources/remote_data_source":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var column_data_source_1 = require("./column_data_source");
var p = require("core/properties");
exports.RemoteDataSource = (function (superClass) {
    extend(RemoteDataSource, superClass);
    function RemoteDataSource() {
        return RemoteDataSource.__super__.constructor.apply(this, arguments);
    }
    RemoteDataSource.prototype.type = 'RemoteDataSource';
    RemoteDataSource.define({
        data_url: [p.String],
        polling_interval: [p.Number]
    });
    return RemoteDataSource;
})(column_data_source_1.ColumnDataSource);

},{"./column_data_source":"models/sources/column_data_source","core/properties":"core/properties"}],"models/tickers/adaptive_ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var clamp, log, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, slice = [].slice;
var continuous_ticker_1 = require("./continuous_ticker");
var p = require("core/properties");
var array_1 = require("core/util/array");
clamp = function (x, min_val, max_val) {
    return Math.max(min_val, Math.min(max_val, x));
};
log = function (x, base) {
    if (base == null) {
        base = Math.E;
    }
    return Math.log(x) / Math.log(base);
};
exports.AdaptiveTicker = (function (superClass) {
    extend(AdaptiveTicker, superClass);
    function AdaptiveTicker() {
        return AdaptiveTicker.__super__.constructor.apply(this, arguments);
    }
    AdaptiveTicker.prototype.type = 'AdaptiveTicker';
    AdaptiveTicker.define({
        base: [p.Number, 10.0],
        mantissas: [p.Array, [1, 2, 5]],
        min_interval: [p.Number, 0.0],
        max_interval: [p.Number]
    });
    AdaptiveTicker.prototype.initialize = function (attrs, options) {
        var prefix_mantissa, suffix_mantissa;
        AdaptiveTicker.__super__.initialize.call(this, attrs, options);
        prefix_mantissa = array_1.nth(this.mantissas, -1) / this.base;
        suffix_mantissa = array_1.nth(this.mantissas, 0) * this.base;
        this.extended_mantissas = [prefix_mantissa].concat(slice.call(this.mantissas), [suffix_mantissa]);
        return this.base_factor = this.get_min_interval() === 0.0 ? 1.0 : this.get_min_interval();
    };
    AdaptiveTicker.prototype.get_interval = function (data_low, data_high, desired_n_ticks) {
        var best_mantissa, candidate_mantissas, data_range, errors, ideal_interval, ideal_magnitude, ideal_mantissa, interval, interval_exponent;
        data_range = data_high - data_low;
        ideal_interval = this.get_ideal_interval(data_low, data_high, desired_n_ticks);
        interval_exponent = Math.floor(log(ideal_interval / this.base_factor, this.base));
        ideal_magnitude = Math.pow(this.base, interval_exponent) * this.base_factor;
        ideal_mantissa = ideal_interval / ideal_magnitude;
        candidate_mantissas = this.extended_mantissas;
        errors = candidate_mantissas.map(function (mantissa) {
            return Math.abs(desired_n_ticks - (data_range / (mantissa * ideal_magnitude)));
        });
        best_mantissa = candidate_mantissas[array_1.argmin(errors)];
        interval = best_mantissa * ideal_magnitude;
        return clamp(interval, this.get_min_interval(), this.get_max_interval());
    };
    return AdaptiveTicker;
})(continuous_ticker_1.ContinuousTicker);

},{"./continuous_ticker":"models/tickers/continuous_ticker","core/properties":"core/properties","core/util/array":"core/util/array"}],"models/tickers/basic_ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var adaptive_ticker_1 = require("./adaptive_ticker");
exports.BasicTicker = (function (superClass) {
    extend(BasicTicker, superClass);
    function BasicTicker() {
        return BasicTicker.__super__.constructor.apply(this, arguments);
    }
    BasicTicker.prototype.type = 'BasicTicker';
    return BasicTicker;
})(adaptive_ticker_1.AdaptiveTicker);

},{"./adaptive_ticker":"models/tickers/adaptive_ticker"}],"models/tickers/categorical_ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var ticker_1 = require("./ticker");
exports.CategoricalTicker = (function (superClass) {
    extend(CategoricalTicker, superClass);
    function CategoricalTicker() {
        return CategoricalTicker.__super__.constructor.apply(this, arguments);
    }
    CategoricalTicker.prototype.type = 'CategoricalTicker';
    CategoricalTicker.prototype.get_ticks = function (start, end, range, cross_loc, arg) {
        var desired_n_ticks, factors, i, ii, j, majors, ref;
        desired_n_ticks = arg.desired_n_ticks;
        majors = [];
        factors = range.factors;
        for (i = j = 0, ref = factors.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            ii = i + range.offset;
            if ((ii + 1) > start && (ii + 1) < end) {
                majors.push(factors[i]);
            }
        }
        return {
            "major": majors,
            "minor": []
        };
    };
    return CategoricalTicker;
})(ticker_1.Ticker);

},{"./ticker":"models/tickers/ticker"}],"models/tickers/composite_ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var continuous_ticker_1 = require("./continuous_ticker");
var p = require("core/properties");
var array_1 = require("core/util/array");
exports.CompositeTicker = (function (superClass) {
    extend(CompositeTicker, superClass);
    function CompositeTicker() {
        return CompositeTicker.__super__.constructor.apply(this, arguments);
    }
    CompositeTicker.prototype.type = 'CompositeTicker';
    CompositeTicker.define({
        tickers: [p.Array, []]
    });
    CompositeTicker.getters({
        min_intervals: function () {
            var i, len, ref, results, ticker;
            ref = this.tickers;
            results = [];
            for (i = 0, len = ref.length; i < len; i++) {
                ticker = ref[i];
                results.push(ticker.get_min_interval());
            }
            return results;
        },
        max_intervals: function () {
            var i, len, ref, results, ticker;
            ref = this.tickers;
            results = [];
            for (i = 0, len = ref.length; i < len; i++) {
                ticker = ref[i];
                results.push(ticker.get_max_interval());
            }
            return results;
        },
        min_interval: function () {
            return this.min_intervals[0];
        },
        max_interval: function () {
            return this.max_intervals[0];
        }
    });
    CompositeTicker.prototype.get_best_ticker = function (data_low, data_high, desired_n_ticks) {
        var best_index, best_ticker, best_ticker_ndx, data_range, errors, ideal_interval, intervals, ticker_ndxs;
        data_range = data_high - data_low;
        ideal_interval = this.get_ideal_interval(data_low, data_high, desired_n_ticks);
        ticker_ndxs = [array_1.sortedIndex(this.min_intervals, ideal_interval) - 1, array_1.sortedIndex(this.max_intervals, ideal_interval)];
        intervals = [this.min_intervals[ticker_ndxs[0]], this.max_intervals[ticker_ndxs[1]]];
        errors = intervals.map(function (interval) {
            return Math.abs(desired_n_ticks - (data_range / interval));
        });
        best_index = array_1.argmin(errors);
        if (best_index === 2e308) {
            return this.tickers[0];
        }
        best_ticker_ndx = ticker_ndxs[best_index];
        best_ticker = this.tickers[best_ticker_ndx];
        return best_ticker;
    };
    CompositeTicker.prototype.get_interval = function (data_low, data_high, desired_n_ticks) {
        var best_ticker;
        best_ticker = this.get_best_ticker(data_low, data_high, desired_n_ticks);
        return best_ticker.get_interval(data_low, data_high, desired_n_ticks);
    };
    CompositeTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, cross_loc, desired_n_ticks) {
        var best_ticker, ticks;
        best_ticker = this.get_best_ticker(data_low, data_high, desired_n_ticks);
        ticks = best_ticker.get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks);
        return ticks;
    };
    return CompositeTicker;
})(continuous_ticker_1.ContinuousTicker);

},{"./continuous_ticker":"models/tickers/continuous_ticker","core/properties":"core/properties","core/util/array":"core/util/array"}],"models/tickers/continuous_ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var ticker_1 = require("./ticker");
var p = require("core/properties");
exports.ContinuousTicker = (function (superClass) {
    extend(ContinuousTicker, superClass);
    function ContinuousTicker() {
        return ContinuousTicker.__super__.constructor.apply(this, arguments);
    }
    ContinuousTicker.prototype.type = 'ContinuousTicker';
    ContinuousTicker.define({
        num_minor_ticks: [p.Number, 5],
        desired_num_ticks: [p.Number, 6]
    });
    ContinuousTicker.prototype.get_interval = void 0;
    ContinuousTicker.prototype.get_min_interval = function () {
        return this.min_interval;
    };
    ContinuousTicker.prototype.get_max_interval = function () {
        var ref;
        return (ref = this.max_interval) != null ? ref : 2e308;
    };
    ContinuousTicker.prototype.get_ideal_interval = function (data_low, data_high, desired_n_ticks) {
        var data_range;
        data_range = data_high - data_low;
        return data_range / desired_n_ticks;
    };
    return ContinuousTicker;
})(ticker_1.Ticker);

},{"./ticker":"models/tickers/ticker","core/properties":"core/properties"}],"models/tickers/datetime_ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ONE_HOUR, ONE_MILLI, ONE_MINUTE, ONE_MONTH, ONE_SECOND, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var array_1 = require("core/util/array");
var adaptive_ticker_1 = require("./adaptive_ticker");
var composite_ticker_1 = require("./composite_ticker");
var days_ticker_1 = require("./days_ticker");
var months_ticker_1 = require("./months_ticker");
var years_ticker_1 = require("./years_ticker");
var util = require("./util");
ONE_MILLI = util.ONE_MILLI;
ONE_SECOND = util.ONE_SECOND;
ONE_MINUTE = util.ONE_MINUTE;
ONE_HOUR = util.ONE_HOUR;
ONE_MONTH = util.ONE_MONTH;
exports.DatetimeTicker = (function (superClass) {
    extend(DatetimeTicker, superClass);
    function DatetimeTicker() {
        return DatetimeTicker.__super__.constructor.apply(this, arguments);
    }
    DatetimeTicker.prototype.type = 'DatetimeTicker';
    DatetimeTicker.override({
        num_minor_ticks: 0,
        tickers: function () {
            return [
                new adaptive_ticker_1.AdaptiveTicker({
                    mantissas: [1, 2, 5],
                    base: 10,
                    min_interval: 0,
                    max_interval: 500 * ONE_MILLI,
                    num_minor_ticks: 0
                }), new adaptive_ticker_1.AdaptiveTicker({
                    mantissas: [1, 2, 5, 10, 15, 20, 30],
                    base: 60,
                    min_interval: ONE_SECOND,
                    max_interval: 30 * ONE_MINUTE,
                    num_minor_ticks: 0
                }), new adaptive_ticker_1.AdaptiveTicker({
                    mantissas: [1, 2, 4, 6, 8, 12],
                    base: 24.0,
                    min_interval: ONE_HOUR,
                    max_interval: 12 * ONE_HOUR,
                    num_minor_ticks: 0
                }), new days_ticker_1.DaysTicker({
                    days: array_1.range(1, 32)
                }), new days_ticker_1.DaysTicker({
                    days: array_1.range(1, 31, 3)
                }), new days_ticker_1.DaysTicker({
                    days: [1, 8, 15, 22]
                }), new days_ticker_1.DaysTicker({
                    days: [1, 15]
                }), new months_ticker_1.MonthsTicker({
                    months: array_1.range(0, 12, 1)
                }), new months_ticker_1.MonthsTicker({
                    months: array_1.range(0, 12, 2)
                }), new months_ticker_1.MonthsTicker({
                    months: array_1.range(0, 12, 4)
                }), new months_ticker_1.MonthsTicker({
                    months: array_1.range(0, 12, 6)
                }), new years_ticker_1.YearsTicker({})
            ];
        }
    });
    return DatetimeTicker;
})(composite_ticker_1.CompositeTicker);

},{"./adaptive_ticker":"models/tickers/adaptive_ticker","./composite_ticker":"models/tickers/composite_ticker","./days_ticker":"models/tickers/days_ticker","./months_ticker":"models/tickers/months_ticker","./util":"models/tickers/util","./years_ticker":"models/tickers/years_ticker","core/util/array":"core/util/array"}],"models/tickers/days_ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ONE_DAY, copy_date, date_range_by_month, last_month_no_later_than, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var single_interval_ticker_1 = require("./single_interval_ticker");
var util = require("./util");
var p = require("core/properties");
var array_1 = require("core/util/array");
copy_date = util.copy_date;
last_month_no_later_than = util.last_month_no_later_than;
ONE_DAY = util.ONE_DAY;
date_range_by_month = function (start_time, end_time) {
    var date, dates, end_date, prev_end_date, start_date;
    start_date = last_month_no_later_than(new Date(start_time));
    end_date = last_month_no_later_than(new Date(end_time));
    prev_end_date = copy_date(end_date);
    end_date.setUTCMonth(end_date.getUTCMonth() + 1);
    dates = [];
    date = start_date;
    while (true) {
        dates.push(copy_date(date));
        date.setUTCMonth(date.getUTCMonth() + 1);
        if (date > end_date) {
            break;
        }
    }
    return dates;
};
exports.DaysTicker = (function (superClass) {
    extend(DaysTicker, superClass);
    function DaysTicker() {
        return DaysTicker.__super__.constructor.apply(this, arguments);
    }
    DaysTicker.prototype.type = 'DaysTicker';
    DaysTicker.define({
        days: [p.Array, []]
    });
    DaysTicker.prototype.initialize = function (attrs, options) {
        var days, interval;
        attrs.num_minor_ticks = 0;
        DaysTicker.__super__.initialize.call(this, attrs, options);
        days = this.days;
        interval = days.length > 1 ? (days[1] - days[0]) * ONE_DAY : 31 * ONE_DAY;
        return this.interval = interval;
    };
    DaysTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, cross_loc, desired_n_ticks) {
        var all_ticks, date, day_date, day_dates, days, days_of_month, interval, month_dates, ticks_in_range;
        month_dates = date_range_by_month(data_low, data_high);
        days = this.days;
        days_of_month = (function (_this) {
            return function (month_date, interval) {
                var dates, day, day_date, future_date, i, len;
                dates = [];
                for (i = 0, len = days.length; i < len; i++) {
                    day = days[i];
                    day_date = copy_date(month_date);
                    day_date.setUTCDate(day);
                    future_date = new Date(day_date.getTime() + (interval / 2));
                    if (future_date.getUTCMonth() === month_date.getUTCMonth()) {
                        dates.push(day_date);
                    }
                }
                return dates;
            };
        })(this);
        interval = this.interval;
        day_dates = array_1.concat((function () {
            var i, len, results;
            results = [];
            for (i = 0, len = month_dates.length; i < len; i++) {
                date = month_dates[i];
                results.push(days_of_month(date, interval));
            }
            return results;
        })());
        all_ticks = (function () {
            var i, len, results;
            results = [];
            for (i = 0, len = day_dates.length; i < len; i++) {
                day_date = day_dates[i];
                results.push(day_date.getTime());
            }
            return results;
        })();
        ticks_in_range = all_ticks.filter(function (tick) {
            return (data_low <= tick && tick <= data_high);
        });
        return {
            "major": ticks_in_range,
            "minor": []
        };
    };
    return DaysTicker;
})(single_interval_ticker_1.SingleIntervalTicker);

},{"./single_interval_ticker":"models/tickers/single_interval_ticker","./util":"models/tickers/util","core/properties":"core/properties","core/util/array":"core/util/array"}],"models/tickers/fixed_ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var continuous_ticker_1 = require("./continuous_ticker");
var p = require("core/properties");
exports.FixedTicker = (function (superClass) {
    extend(FixedTicker, superClass);
    function FixedTicker() {
        return FixedTicker.__super__.constructor.apply(this, arguments);
    }
    FixedTicker.prototype.type = 'FixedTicker';
    FixedTicker.define({
        ticks: [p.Array, []]
    });
    FixedTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, cross_loc, desired_n_ticks) {
        return {
            major: this.ticks,
            minor: []
        };
    };
    return FixedTicker;
})(continuous_ticker_1.ContinuousTicker);

},{"./continuous_ticker":"models/tickers/continuous_ticker","core/properties":"core/properties"}],"models/tickers/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var adaptive_ticker_1 = require("./adaptive_ticker");
exports.AdaptiveTicker = adaptive_ticker_1.AdaptiveTicker;
var basic_ticker_1 = require("./basic_ticker");
exports.BasicTicker = basic_ticker_1.BasicTicker;
var categorical_ticker_1 = require("./categorical_ticker");
exports.CategoricalTicker = categorical_ticker_1.CategoricalTicker;
var composite_ticker_1 = require("./composite_ticker");
exports.CompositeTicker = composite_ticker_1.CompositeTicker;
var continuous_ticker_1 = require("./continuous_ticker");
exports.ContinuousTicker = continuous_ticker_1.ContinuousTicker;
var datetime_ticker_1 = require("./datetime_ticker");
exports.DatetimeTicker = datetime_ticker_1.DatetimeTicker;
var days_ticker_1 = require("./days_ticker");
exports.DaysTicker = days_ticker_1.DaysTicker;
var fixed_ticker_1 = require("./fixed_ticker");
exports.FixedTicker = fixed_ticker_1.FixedTicker;
var log_ticker_1 = require("./log_ticker");
exports.LogTicker = log_ticker_1.LogTicker;
var mercator_ticker_1 = require("./mercator_ticker");
exports.MercatorTicker = mercator_ticker_1.MercatorTicker;
var months_ticker_1 = require("./months_ticker");
exports.MonthsTicker = months_ticker_1.MonthsTicker;
var single_interval_ticker_1 = require("./single_interval_ticker");
exports.SingleIntervalTicker = single_interval_ticker_1.SingleIntervalTicker;
var ticker_1 = require("./ticker");
exports.Ticker = ticker_1.Ticker;
var years_ticker_1 = require("./years_ticker");
exports.YearsTicker = years_ticker_1.YearsTicker;

},{"./adaptive_ticker":"models/tickers/adaptive_ticker","./basic_ticker":"models/tickers/basic_ticker","./categorical_ticker":"models/tickers/categorical_ticker","./composite_ticker":"models/tickers/composite_ticker","./continuous_ticker":"models/tickers/continuous_ticker","./datetime_ticker":"models/tickers/datetime_ticker","./days_ticker":"models/tickers/days_ticker","./fixed_ticker":"models/tickers/fixed_ticker","./log_ticker":"models/tickers/log_ticker","./mercator_ticker":"models/tickers/mercator_ticker","./months_ticker":"models/tickers/months_ticker","./single_interval_ticker":"models/tickers/single_interval_ticker","./ticker":"models/tickers/ticker","./years_ticker":"models/tickers/years_ticker"}],"models/tickers/log_ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var array_1 = require("core/util/array");
var types_1 = require("core/util/types");
var adaptive_ticker_1 = require("./adaptive_ticker");
exports.LogTicker = (function (superClass) {
    extend(LogTicker, superClass);
    function LogTicker() {
        return LogTicker.__super__.constructor.apply(this, arguments);
    }
    LogTicker.prototype.type = 'LogTicker';
    LogTicker.override({
        mantissas: [1, 5]
    });
    LogTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, cross_loc, desired_n_ticks) {
        var base, end_factor, endlog, factor, factors, i, interval, j, k, l, len, len1, len2, len3, len4, len5, log_high, log_interval, log_low, m, minor_interval, minor_offsets, minor_ticks, n, num_minor_ticks, o, start_factor, startlog, tick, ticks, x;
        num_minor_ticks = this.num_minor_ticks;
        minor_ticks = [];
        base = this.base;
        log_low = Math.log(data_low) / Math.log(base);
        log_high = Math.log(data_high) / Math.log(base);
        log_interval = log_high - log_low;
        if (log_interval < 2) {
            interval = this.get_interval(data_low, data_high, desired_n_ticks);
            start_factor = Math.floor(data_low / interval);
            end_factor = Math.ceil(data_high / interval);
            if (types_1.isStrictNaN(start_factor) || types_1.isStrictNaN(end_factor)) {
                factors = [];
            }
            else {
                factors = array_1.range(start_factor, end_factor + 1);
            }
            ticks = (function () {
                var j, len, results;
                results = [];
                for (j = 0, len = factors.length; j < len; j++) {
                    factor = factors[j];
                    if (factor !== 0) {
                        results.push(factor * interval);
                    }
                }
                return results;
            })();
            if (num_minor_ticks > 1) {
                minor_interval = interval / num_minor_ticks;
                minor_offsets = (function () {
                    var j, ref, results;
                    results = [];
                    for (i = j = 1, ref = num_minor_ticks; 1 <= ref ? j <= ref : j >= ref; i = 1 <= ref ? ++j : --j) {
                        results.push(i * minor_interval);
                    }
                    return results;
                })();
                for (j = 0, len = minor_offsets.length; j < len; j++) {
                    x = minor_offsets[j];
                    minor_ticks.push(ticks[0] - x);
                }
                for (k = 0, len1 = ticks.length; k < len1; k++) {
                    tick = ticks[k];
                    for (l = 0, len2 = minor_offsets.length; l < len2; l++) {
                        x = minor_offsets[l];
                        minor_ticks.push(tick + x);
                    }
                }
            }
        }
        else {
            startlog = Math.ceil(log_low);
            endlog = Math.floor(log_high);
            interval = Math.ceil((endlog - startlog) / 9.0);
            ticks = array_1.range(startlog, endlog, interval);
            if ((endlog - startlog) % interval === 0) {
                ticks = ticks.concat([endlog]);
            }
            ticks = ticks.map(function (i) {
                return Math.pow(base, i);
            });
            if (num_minor_ticks > 1) {
                minor_interval = Math.pow(base, interval) / num_minor_ticks;
                minor_offsets = (function () {
                    var m, ref, results;
                    results = [];
                    for (i = m = 1, ref = num_minor_ticks; 1 <= ref ? m <= ref : m >= ref; i = 1 <= ref ? ++m : --m) {
                        results.push(i * minor_interval);
                    }
                    return results;
                })();
                for (m = 0, len3 = minor_offsets.length; m < len3; m++) {
                    x = minor_offsets[m];
                    minor_ticks.push(ticks[0] / x);
                }
                for (n = 0, len4 = ticks.length; n < len4; n++) {
                    tick = ticks[n];
                    for (o = 0, len5 = minor_offsets.length; o < len5; o++) {
                        x = minor_offsets[o];
                        minor_ticks.push(tick * x);
                    }
                }
            }
        }
        return {
            major: ticks,
            minor: minor_ticks
        };
    };
    return LogTicker;
})(adaptive_ticker_1.AdaptiveTicker);

},{"./adaptive_ticker":"models/tickers/adaptive_ticker","core/util/array":"core/util/array","core/util/types":"core/util/types"}],"models/tickers/mercator_ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var basic_ticker_1 = require("./basic_ticker");
var p = require("core/properties");
var proj4_1 = require("core/util/proj4");
exports.MercatorTicker = (function (superClass) {
    extend(MercatorTicker, superClass);
    function MercatorTicker() {
        return MercatorTicker.__super__.constructor.apply(this, arguments);
    }
    MercatorTicker.prototype.type = 'MercatorTicker';
    MercatorTicker.define({
        dimension: [p.LatLon]
    });
    MercatorTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, cross_loc, desired_n_ticks) {
        var _, i, j, k, l, lat, len, len1, len2, len3, lon, proj_cross_loc, proj_high, proj_low, proj_ticks, ref, ref1, ref10, ref11, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9, tick, ticks;
        if (this.dimension == null) {
            throw new Error("MercatorTicker.dimension not configured");
        }
        if (this.dimension === "lon") {
            ref = proj4_1.proj4(proj4_1.mercator).inverse([data_low, cross_loc]), proj_low = ref[0], proj_cross_loc = ref[1];
            ref1 = proj4_1.proj4(proj4_1.mercator).inverse([data_high, cross_loc]), proj_high = ref1[0], proj_cross_loc = ref1[1];
        }
        else {
            ref2 = proj4_1.proj4(proj4_1.mercator).inverse([cross_loc, data_low]), proj_cross_loc = ref2[0], proj_low = ref2[1];
            ref3 = proj4_1.proj4(proj4_1.mercator).inverse([cross_loc, data_high]), proj_cross_loc = ref3[0], proj_high = ref3[1];
        }
        proj_ticks = MercatorTicker.__super__.get_ticks_no_defaults.call(this, proj_low, proj_high, cross_loc, desired_n_ticks);
        ticks = {
            major: [],
            minor: []
        };
        if (this.dimension === "lon") {
            ref4 = proj_ticks.major;
            for (i = 0, len = ref4.length; i < len; i++) {
                tick = ref4[i];
                ref5 = proj4_1.proj4(proj4_1.mercator).forward([tick, proj_cross_loc]), lon = ref5[0], _ = ref5[1];
                ticks.major.push(lon);
            }
            ref6 = proj_ticks.minor;
            for (j = 0, len1 = ref6.length; j < len1; j++) {
                tick = ref6[j];
                ref7 = proj4_1.proj4(proj4_1.mercator).forward([tick, proj_cross_loc]), lon = ref7[0], _ = ref7[1];
                ticks.minor.push(lon);
            }
        }
        else {
            ref8 = proj_ticks.major;
            for (k = 0, len2 = ref8.length; k < len2; k++) {
                tick = ref8[k];
                ref9 = proj4_1.proj4(proj4_1.mercator).forward([proj_cross_loc, tick]), _ = ref9[0], lat = ref9[1];
                ticks.major.push(lat);
            }
            ref10 = proj_ticks.minor;
            for (l = 0, len3 = ref10.length; l < len3; l++) {
                tick = ref10[l];
                ref11 = proj4_1.proj4(proj4_1.mercator).forward([proj_cross_loc, tick]), _ = ref11[0], lat = ref11[1];
                ticks.minor.push(lat);
            }
        }
        return ticks;
    };
    return MercatorTicker;
})(basic_ticker_1.BasicTicker);

},{"./basic_ticker":"models/tickers/basic_ticker","core/properties":"core/properties","core/util/proj4":"core/util/proj4"}],"models/tickers/months_ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ONE_MONTH, copy_date, date_range_by_year, last_year_no_later_than, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var single_interval_ticker_1 = require("./single_interval_ticker");
var util = require("./util");
var p = require("core/properties");
var array_1 = require("core/util/array");
copy_date = util.copy_date;
last_year_no_later_than = util.last_year_no_later_than;
ONE_MONTH = util.ONE_MONTH;
date_range_by_year = function (start_time, end_time) {
    var date, dates, end_date, start_date;
    start_date = last_year_no_later_than(new Date(start_time));
    end_date = last_year_no_later_than(new Date(end_time));
    end_date.setUTCFullYear(end_date.getUTCFullYear() + 1);
    dates = [];
    date = start_date;
    while (true) {
        dates.push(copy_date(date));
        date.setUTCFullYear(date.getUTCFullYear() + 1);
        if (date > end_date) {
            break;
        }
    }
    return dates;
};
exports.MonthsTicker = (function (superClass) {
    extend(MonthsTicker, superClass);
    function MonthsTicker() {
        return MonthsTicker.__super__.constructor.apply(this, arguments);
    }
    MonthsTicker.prototype.type = 'MonthsTicker';
    MonthsTicker.define({
        months: [p.Array, []]
    });
    MonthsTicker.prototype.initialize = function (attrs, options) {
        var interval, months;
        MonthsTicker.__super__.initialize.call(this, attrs, options);
        months = this.months;
        interval = months.length > 1 ? (months[1] - months[0]) * ONE_MONTH : 12 * ONE_MONTH;
        return this.interval = interval;
    };
    MonthsTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, cross_loc, desired_n_ticks) {
        var all_ticks, date, month_date, month_dates, months, months_of_year, ticks_in_range, year_dates;
        year_dates = date_range_by_year(data_low, data_high);
        months = this.months;
        months_of_year = function (year_date) {
            return months.map(function (month) {
                var month_date;
                month_date = copy_date(year_date);
                month_date.setUTCMonth(month);
                return month_date;
            });
        };
        month_dates = array_1.concat((function () {
            var i, len, results;
            results = [];
            for (i = 0, len = year_dates.length; i < len; i++) {
                date = year_dates[i];
                results.push(months_of_year(date));
            }
            return results;
        })());
        all_ticks = (function () {
            var i, len, results;
            results = [];
            for (i = 0, len = month_dates.length; i < len; i++) {
                month_date = month_dates[i];
                results.push(month_date.getTime());
            }
            return results;
        })();
        ticks_in_range = all_ticks.filter(function (tick) {
            return (data_low <= tick && tick <= data_high);
        });
        return {
            "major": ticks_in_range,
            "minor": []
        };
    };
    return MonthsTicker;
})(single_interval_ticker_1.SingleIntervalTicker);

},{"./single_interval_ticker":"models/tickers/single_interval_ticker","./util":"models/tickers/util","core/properties":"core/properties","core/util/array":"core/util/array"}],"models/tickers/single_interval_ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var continuous_ticker_1 = require("./continuous_ticker");
var p = require("core/properties");
exports.SingleIntervalTicker = (function (superClass) {
    extend(SingleIntervalTicker, superClass);
    function SingleIntervalTicker() {
        return SingleIntervalTicker.__super__.constructor.apply(this, arguments);
    }
    SingleIntervalTicker.prototype.type = 'SingleIntervalTicker';
    SingleIntervalTicker.define({
        interval: [p.Number]
    });
    SingleIntervalTicker.getters({
        min_interval: function () {
            return this.interval;
        },
        max_interval: function () {
            return this.interval;
        }
    });
    SingleIntervalTicker.prototype.get_interval = function (data_low, data_high, n_desired_ticks) {
        return this.interval;
    };
    return SingleIntervalTicker;
})(continuous_ticker_1.ContinuousTicker);

},{"./continuous_ticker":"models/tickers/continuous_ticker","core/properties":"core/properties"}],"models/tickers/ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var model_1 = require("../../model");
var array_1 = require("core/util/array");
var types_1 = require("core/util/types");
exports.Ticker = (function (superClass) {
    extend(Ticker, superClass);
    function Ticker() {
        return Ticker.__super__.constructor.apply(this, arguments);
    }
    Ticker.prototype.type = 'Ticker';
    Ticker.prototype.get_ticks = function (data_low, data_high, range, cross_loc, arg) {
        var desired_n_ticks;
        desired_n_ticks = arg.desired_n_ticks;
        return this.get_ticks_no_defaults(data_low, data_high, cross_loc, this.desired_num_ticks);
    };
    Ticker.prototype.get_ticks_no_defaults = function (data_low, data_high, cross_loc, desired_n_ticks) {
        var end_factor, factor, factors, i, interval, j, k, l, len, len1, len2, minor_interval, minor_offsets, minor_ticks, num_minor_ticks, start_factor, tick, ticks, x;
        interval = this.get_interval(data_low, data_high, desired_n_ticks);
        start_factor = Math.floor(data_low / interval);
        end_factor = Math.ceil(data_high / interval);
        if (types_1.isStrictNaN(start_factor) || types_1.isStrictNaN(end_factor)) {
            factors = [];
        }
        else {
            factors = array_1.range(start_factor, end_factor + 1);
        }
        ticks = (function () {
            var j, len, results;
            results = [];
            for (j = 0, len = factors.length; j < len; j++) {
                factor = factors[j];
                results.push(factor * interval);
            }
            return results;
        })();
        num_minor_ticks = this.num_minor_ticks;
        minor_ticks = [];
        if (num_minor_ticks > 1) {
            minor_interval = interval / num_minor_ticks;
            minor_offsets = (function () {
                var j, ref, results;
                results = [];
                for (i = j = 1, ref = num_minor_ticks; 1 <= ref ? j <= ref : j >= ref; i = 1 <= ref ? ++j : --j) {
                    results.push(i * minor_interval);
                }
                return results;
            })();
            for (j = 0, len = minor_offsets.length; j < len; j++) {
                x = minor_offsets[j];
                minor_ticks.push(ticks[0] - x);
            }
            for (k = 0, len1 = ticks.length; k < len1; k++) {
                tick = ticks[k];
                for (l = 0, len2 = minor_offsets.length; l < len2; l++) {
                    x = minor_offsets[l];
                    minor_ticks.push(tick + x);
                }
            }
        }
        return {
            "major": ticks,
            "minor": minor_ticks
        };
    };
    return Ticker;
})(model_1.Model);

},{"../../model":"model","core/util/array":"core/util/array","core/util/types":"core/util/types"}],"models/tickers/util":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ONE_MILLI = 1.0;
exports.ONE_SECOND = 1000.0;
exports.ONE_MINUTE = 60.0 * exports.ONE_SECOND;
exports.ONE_HOUR = 60 * exports.ONE_MINUTE;
exports.ONE_DAY = 24 * exports.ONE_HOUR;
exports.ONE_MONTH = 30 * exports.ONE_DAY;
exports.ONE_YEAR = 365 * exports.ONE_DAY;
exports.copy_date = function (date) {
    return new Date(date.getTime());
};
exports.last_month_no_later_than = function (date) {
    date = exports.copy_date(date);
    date.setUTCDate(1);
    date.setUTCHours(0);
    date.setUTCMinutes(0);
    date.setUTCSeconds(0);
    date.setUTCMilliseconds(0);
    return date;
};
exports.last_year_no_later_than = function (date) {
    date = exports.last_month_no_later_than(date);
    date.setUTCMonth(0);
    return date;
};

},{}],"models/tickers/years_ticker":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ONE_YEAR, last_year_no_later_than, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var basic_ticker_1 = require("./basic_ticker");
var single_interval_ticker_1 = require("./single_interval_ticker");
var util = require("./util");
last_year_no_later_than = util.last_year_no_later_than;
ONE_YEAR = util.ONE_YEAR;
exports.YearsTicker = (function (superClass) {
    extend(YearsTicker, superClass);
    function YearsTicker() {
        return YearsTicker.__super__.constructor.apply(this, arguments);
    }
    YearsTicker.prototype.type = 'YearsTicker';
    YearsTicker.prototype.initialize = function (attrs, options) {
        YearsTicker.__super__.initialize.call(this, attrs, options);
        this.interval = ONE_YEAR;
        return this.basic_ticker = new basic_ticker_1.BasicTicker({
            num_minor_ticks: 0
        });
    };
    YearsTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, cross_loc, desired_n_ticks) {
        var all_ticks, end_year, start_year, ticks_in_range, year, years;
        start_year = last_year_no_later_than(new Date(data_low)).getUTCFullYear();
        end_year = last_year_no_later_than(new Date(data_high)).getUTCFullYear();
        years = this.basic_ticker.get_ticks_no_defaults(start_year, end_year, cross_loc, desired_n_ticks).major;
        all_ticks = (function () {
            var i, len, results;
            results = [];
            for (i = 0, len = years.length; i < len; i++) {
                year = years[i];
                results.push(Date.UTC(year, 0, 1));
            }
            return results;
        })();
        ticks_in_range = all_ticks.filter(function (tick) {
            return (data_low <= tick && tick <= data_high);
        });
        return {
            major: ticks_in_range,
            minor: []
        };
    };
    return YearsTicker;
})(single_interval_ticker_1.SingleIntervalTicker);

},{"./basic_ticker":"models/tickers/basic_ticker","./single_interval_ticker":"models/tickers/single_interval_ticker","./util":"models/tickers/util"}],"models/tiles/bbox_tile_source":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var mercator_tile_source_1 = require("./mercator_tile_source");
var p = require("core/properties");
exports.BBoxTileSource = (function (superClass) {
    extend(BBoxTileSource, superClass);
    function BBoxTileSource() {
        return BBoxTileSource.__super__.constructor.apply(this, arguments);
    }
    BBoxTileSource.prototype.type = 'BBoxTileSource';
    BBoxTileSource.define({
        use_latlon: [p.Bool, false]
    });
    BBoxTileSource.prototype.get_image_url = function (x, y, z) {
        var image_url, ref, ref1, xmax, xmin, ymax, ymin;
        image_url = this.string_lookup_replace(this.url, this.extra_url_vars);
        if (this.use_latlon) {
            ref = this.get_tile_geographic_bounds(x, y, z), xmin = ref[0], ymin = ref[1], xmax = ref[2], ymax = ref[3];
        }
        else {
            ref1 = this.get_tile_meter_bounds(x, y, z), xmin = ref1[0], ymin = ref1[1], xmax = ref1[2], ymax = ref1[3];
        }
        return image_url.replace("{XMIN}", xmin).replace("{YMIN}", ymin).replace("{XMAX}", xmax).replace("{YMAX}", ymax);
    };
    return BBoxTileSource;
})(mercator_tile_source_1.MercatorTileSource);

},{"./mercator_tile_source":"models/tiles/mercator_tile_source","core/properties":"core/properties"}],"models/tiles/dynamic_image_renderer":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var bind = function (fn, me) { return function () { return fn.apply(me, arguments); }; }, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var renderer_1 = require("../renderers/renderer");
var logging_1 = require("core/logging");
var p = require("core/properties");
exports.DynamicImageView = (function (superClass) {
    extend(DynamicImageView, superClass);
    function DynamicImageView() {
        this._on_image_error = bind(this._on_image_error, this);
        this._on_image_load = bind(this._on_image_load, this);
        return DynamicImageView.__super__.constructor.apply(this, arguments);
    }
    DynamicImageView.prototype.bind_bokeh_events = function () {
        return this.listenTo(this.model, 'change', this.request_render);
    };
    DynamicImageView.prototype.get_extent = function () {
        return [this.x_range.start, this.y_range.start, this.x_range.end, this.y_range.end];
    };
    DynamicImageView.prototype._set_data = function () {
        this.map_plot = this.plot_view.model.plot;
        this.map_canvas = this.plot_view.canvas_view.ctx;
        this.map_frame = this.plot_view.frame;
        this.x_range = this.map_plot.x_range;
        this.x_mapper = this.map_frame.x_mappers['default'];
        this.y_range = this.map_plot.y_range;
        this.y_mapper = this.map_frame.y_mappers['default'];
        this.lastImage = void 0;
        return this.extent = this.get_extent();
    };
    DynamicImageView.prototype._map_data = function () {
        return this.initial_extent = this.get_extent();
    };
    DynamicImageView.prototype._on_image_load = function (e) {
        var image_data;
        image_data = e.target.image_data;
        image_data.img = e.target;
        image_data.loaded = true;
        this.lastImage = image_data;
        if (this.get_extent().join(':') === image_data.cache_key) {
            return this.request_render();
        }
    };
    DynamicImageView.prototype._on_image_error = function (e) {
        var image_data;
        logging_1.logger.error('Error loading image: #{e.target.src}');
        image_data = e.target.image_data;
        return this.model.image_source.remove_image(image_data);
    };
    DynamicImageView.prototype._create_image = function (bounds) {
        var image;
        image = new Image();
        image.onload = this._on_image_load;
        image.onerror = this._on_image_error;
        image.alt = '';
        image.image_data = {
            bounds: bounds,
            loaded: false,
            cache_key: bounds.join(':')
        };
        this.model.image_source.add_image(image.image_data);
        image.src = this.model.image_source.get_image_url(bounds[0], bounds[1], bounds[2], bounds[3], Math.ceil(this.map_frame.height), Math.ceil(this.map_frame.width));
        return image;
    };
    DynamicImageView.prototype.render = function (ctx, indices, args) {
        var extent, image_obj;
        if (this.map_initialized == null) {
            this._set_data();
            this._map_data();
            this.map_initialized = true;
        }
        extent = this.get_extent();
        if (this.render_timer) {
            clearTimeout(this.render_timer);
        }
        image_obj = this.model.image_source.images[extent.join(':')];
        if ((image_obj != null) && image_obj.loaded) {
            this._draw_image(extent.join(':'));
            return;
        }
        if (this.lastImage != null) {
            this._draw_image(this.lastImage.cache_key);
        }
        if (image_obj == null) {
            return this.render_timer = setTimeout(((function (_this) {
                return function () {
                    return _this._create_image(extent);
                };
            })(this)), 125);
        }
    };
    DynamicImageView.prototype._draw_image = function (image_key) {
        var image_obj, ref, ref1, sh, sw, sx, sxmax, sxmin, sy, symax, symin;
        image_obj = this.model.image_source.images[image_key];
        if (image_obj != null) {
            this.map_canvas.save();
            this._set_rect();
            this.map_canvas.globalAlpha = this.model.alpha;
            ref = this.plot_view.frame.map_to_screen([image_obj.bounds[0]], [image_obj.bounds[3]], this.plot_view.canvas), sxmin = ref[0], symin = ref[1];
            ref1 = this.plot_view.frame.map_to_screen([image_obj.bounds[2]], [image_obj.bounds[1]], this.plot_view.canvas), sxmax = ref1[0], symax = ref1[1];
            sxmin = sxmin[0];
            symin = symin[0];
            sxmax = sxmax[0];
            symax = symax[0];
            sw = sxmax - sxmin;
            sh = symax - symin;
            sx = sxmin;
            sy = symin;
            this.map_canvas.drawImage(image_obj.img, sx, sy, sw, sh);
            return this.map_canvas.restore();
        }
    };
    DynamicImageView.prototype._set_rect = function () {
        var h, l, outline_width, t, w;
        outline_width = this.plot_model.plot.properties.outline_line_width.value();
        l = this.plot_view.canvas.vx_to_sx(this.map_frame.left) + (outline_width / 2);
        t = this.plot_view.canvas.vy_to_sy(this.map_frame.top) + (outline_width / 2);
        w = this.map_frame.width - outline_width;
        h = this.map_frame.height - outline_width;
        this.map_canvas.rect(l, t, w, h);
        return this.map_canvas.clip();
    };
    return DynamicImageView;
})(renderer_1.RendererView);
exports.DynamicImageRenderer = (function (superClass) {
    extend(DynamicImageRenderer, superClass);
    function DynamicImageRenderer() {
        return DynamicImageRenderer.__super__.constructor.apply(this, arguments);
    }
    DynamicImageRenderer.prototype.default_view = exports.DynamicImageView;
    DynamicImageRenderer.prototype.type = 'DynamicImageRenderer';
    DynamicImageRenderer.define({
        alpha: [p.Number, 1.0],
        image_source: [p.Instance],
        render_parents: [p.Bool, true]
    });
    DynamicImageRenderer.override({
        level: 'underlay'
    });
    return DynamicImageRenderer;
})(renderer_1.Renderer);

},{"../renderers/renderer":"models/renderers/renderer","core/logging":"core/logging","core/properties":"core/properties"}],"models/tiles/image_pool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImagePool = (function () {
    function ImagePool() {
        this.images = [];
    }
    ImagePool.prototype.pop = function () {
        var img;
        img = this.images.pop();
        if (img != null) {
            return img;
        }
        else {
            return new Image();
        }
    };
    ImagePool.prototype.push = function (img) {
        if (this.images.length > 50) {
            return;
        }
        if (img.constructor === Array) {
            return Array.prototype.push.apply(this.images, img);
        }
        else {
            return this.images.push(img);
        }
    };
    return ImagePool;
})();

},{}],"models/tiles/image_source":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var p = require("core/properties");
var model_1 = require("../../model");
exports.ImageSource = (function (superClass) {
    extend(ImageSource, superClass);
    ImageSource.prototype.type = 'ImageSource';
    ImageSource.define({
        url: [p.String, ''],
        extra_url_vars: [p.Any, {}]
    });
    function ImageSource(options) {
        if (options == null) {
            options = {};
        }
        ImageSource.__super__.constructor.apply(this, arguments);
        this.images = {};
        this.normalize_case();
    }
    ImageSource.prototype.normalize_case = function () {
        'Note: should probably be refactored into subclasses.';
        var url;
        url = this.url;
        url = url.replace('{xmin}', '{XMIN}');
        url = url.replace('{ymin}', '{YMIN}');
        url = url.replace('{xmax}', '{XMAX}');
        url = url.replace('{ymax}', '{YMAX}');
        url = url.replace('{height}', '{HEIGHT}');
        url = url.replace('{width}', '{WIDTH}');
        return this.url = url;
    };
    ImageSource.prototype.string_lookup_replace = function (str, lookup) {
        var key, result_str, value;
        result_str = str;
        for (key in lookup) {
            value = lookup[key];
            result_str = result_str.replace('{' + key + '}', value.toString());
        }
        return result_str;
    };
    ImageSource.prototype.add_image = function (image_obj) {
        return this.images[image_obj.cache_key] = image_obj;
    };
    ImageSource.prototype.remove_image = function (image_obj) {
        return delete this.images[image_obj.cache_key];
    };
    ImageSource.prototype.get_image_url = function (xmin, ymin, xmax, ymax, height, width) {
        var image_url;
        image_url = this.string_lookup_replace(this.url, this.extra_url_vars);
        return image_url.replace("{XMIN}", xmin).replace("{YMIN}", ymin).replace("{XMAX}", xmax).replace("{YMAX}", ymax).replace("{WIDTH}", width).replace("{HEIGHT}", height);
    };
    return ImageSource;
})(model_1.Model);

},{"../../model":"model","core/properties":"core/properties"}],"models/tiles/index":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var bbox_tile_source_1 = require("./bbox_tile_source");
exports.BBoxTileSource = bbox_tile_source_1.BBoxTileSource;
var dynamic_image_renderer_1 = require("./dynamic_image_renderer");
exports.DynamicImageRenderer = dynamic_image_renderer_1.DynamicImageRenderer;
var image_source_1 = require("./image_source");
exports.ImageSource = image_source_1.ImageSource;
var mercator_tile_source_1 = require("./mercator_tile_source");
exports.MercatorTileSource = mercator_tile_source_1.MercatorTileSource;
var quadkey_tile_source_1 = require("./quadkey_tile_source");
exports.QUADKEYTileSource = quadkey_tile_source_1.QUADKEYTileSource;
var tile_renderer_1 = require("./tile_renderer");
exports.TileRenderer = tile_renderer_1.TileRenderer;
var tile_source_1 = require("./tile_source");
exports.TileSource = tile_source_1.TileSource;
var tms_tile_source_1 = require("./tms_tile_source");
exports.TMSTileSource = tms_tile_source_1.TMSTileSource;
var wmts_tile_source_1 = require("./wmts_tile_source");
exports.WMTSTileSource = wmts_tile_source_1.WMTSTileSource;

},{"./bbox_tile_source":"models/tiles/bbox_tile_source","./dynamic_image_renderer":"models/tiles/dynamic_image_renderer","./image_source":"models/tiles/image_source","./mercator_tile_source":"models/tiles/mercator_tile_source","./quadkey_tile_source":"models/tiles/quadkey_tile_source","./tile_renderer":"models/tiles/tile_renderer","./tile_source":"models/tiles/tile_source","./tms_tile_source":"models/tiles/tms_tile_source","./wmts_tile_source":"models/tiles/wmts_tile_source"}],"models/tiles/mercator_tile_source":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, indexOf = [].indexOf || function (item) { for (var i = 0, l = this.length; i < l; i++) {
    if (i in this && this[i] === item)
        return i;
} return -1; };
var tile_source_1 = require("./tile_source");
var p = require("core/properties");
exports.MercatorTileSource = (function (superClass) {
    extend(MercatorTileSource, superClass);
    function MercatorTileSource() {
        return MercatorTileSource.__super__.constructor.apply(this, arguments);
    }
    MercatorTileSource.prototype.type = 'MercatorTileSource';
    MercatorTileSource.define({
        wrap_around: [p.Bool, true]
    });
    MercatorTileSource.override({
        x_origin_offset: 20037508.34,
        y_origin_offset: 20037508.34,
        initial_resolution: 156543.03392804097
    });
    MercatorTileSource.prototype.initialize = function (options) {
        var z;
        MercatorTileSource.__super__.initialize.call(this, options);
        return this._resolutions = (function () {
            var j, results;
            results = [];
            for (z = j = 0; j <= 30; z = ++j) {
                results.push(this.get_resolution(z));
            }
            return results;
        }).call(this);
    };
    MercatorTileSource.prototype._computed_initial_resolution = function () {
        if (this.initial_resolution != null) {
            return this.initial_resolution;
        }
        else {
            return 2 * Math.PI * 6378137 / this.tile_size;
        }
    };
    MercatorTileSource.prototype.is_valid_tile = function (x, y, z) {
        if (!this.wrap_around) {
            if (x < 0 || x >= Math.pow(2, z)) {
                return false;
            }
        }
        if (y < 0 || y >= Math.pow(2, z)) {
            return false;
        }
        return true;
    };
    MercatorTileSource.prototype.retain_children = function (reference_tile) {
        var key, max_zoom, min_zoom, quadkey, ref, results, tile;
        quadkey = reference_tile.quadkey;
        min_zoom = quadkey.length;
        max_zoom = min_zoom + 3;
        ref = this.tiles;
        results = [];
        for (key in ref) {
            tile = ref[key];
            if (tile.quadkey.indexOf(quadkey) === 0 && tile.quadkey.length > min_zoom && tile.quadkey.length <= max_zoom) {
                results.push(tile.retain = true);
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    MercatorTileSource.prototype.retain_neighbors = function (reference_tile) {
        var key, neighbor_radius, neighbor_x, neighbor_y, ref, ref1, ref2, ref3, results, tile, tx, ty, tz, x, y;
        neighbor_radius = 4;
        ref = reference_tile.tile_coords, tx = ref[0], ty = ref[1], tz = ref[2];
        neighbor_x = (function () {
            var j, ref1, ref2, results;
            results = [];
            for (x = j = ref1 = tx - neighbor_radius, ref2 = tx + neighbor_radius; ref1 <= ref2 ? j <= ref2 : j >= ref2; x = ref1 <= ref2 ? ++j : --j) {
                results.push(x);
            }
            return results;
        })();
        neighbor_y = (function () {
            var j, ref1, ref2, results;
            results = [];
            for (y = j = ref1 = ty - neighbor_radius, ref2 = ty + neighbor_radius; ref1 <= ref2 ? j <= ref2 : j >= ref2; y = ref1 <= ref2 ? ++j : --j) {
                results.push(y);
            }
            return results;
        })();
        ref1 = this.tiles;
        results = [];
        for (key in ref1) {
            tile = ref1[key];
            if (tile.tile_coords[2] === tz && (ref2 = tile.tile_coords[0], indexOf.call(neighbor_x, ref2) >= 0) && (ref3 = tile.tile_coords[1], indexOf.call(neighbor_y, ref3) >= 0)) {
                results.push(tile.retain = true);
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    MercatorTileSource.prototype.retain_parents = function (reference_tile) {
        var key, quadkey, ref, results, tile;
        quadkey = reference_tile.quadkey;
        ref = this.tiles;
        results = [];
        for (key in ref) {
            tile = ref[key];
            results.push(tile.retain = quadkey.indexOf(tile.quadkey) === 0);
        }
        return results;
    };
    MercatorTileSource.prototype.children_by_tile_xyz = function (x, y, z) {
        var b, child_tile_xyz, i, j, quad_key, ref, ref1, ref2, world_x;
        world_x = this.calculate_world_x_by_tile_xyz(x, y, z);
        if (world_x !== 0) {
            ref = this.normalize_xyz(x, y, z), x = ref[0], y = ref[1], z = ref[2];
        }
        quad_key = this.tile_xyz_to_quadkey(x, y, z);
        child_tile_xyz = [];
        for (i = j = 0; j <= 3; i = j += 1) {
            ref1 = this.quadkey_to_tile_xyz(quad_key + i.toString()), x = ref1[0], y = ref1[1], z = ref1[2];
            if (world_x !== 0) {
                ref2 = this.denormalize_xyz(x, y, z, world_x), x = ref2[0], y = ref2[1], z = ref2[2];
            }
            b = this.get_tile_meter_bounds(x, y, z);
            if (b != null) {
                child_tile_xyz.push([x, y, z, b]);
            }
        }
        return child_tile_xyz;
    };
    MercatorTileSource.prototype.parent_by_tile_xyz = function (x, y, z) {
        var parent_quad_key, quad_key;
        quad_key = this.tile_xyz_to_quadkey(x, y, z);
        parent_quad_key = quad_key.substring(0, quad_key.length - 1);
        return this.quadkey_to_tile_xyz(parent_quad_key);
    };
    MercatorTileSource.prototype.get_resolution = function (level) {
        return this._computed_initial_resolution() / Math.pow(2, level);
    };
    MercatorTileSource.prototype.get_resolution_by_extent = function (extent, height, width) {
        var x_rs, y_rs;
        x_rs = (extent[2] - extent[0]) / width;
        y_rs = (extent[3] - extent[1]) / height;
        return [x_rs, y_rs];
    };
    MercatorTileSource.prototype.get_level_by_extent = function (extent, height, width) {
        var i, j, len, r, ref, resolution, x_rs, y_rs;
        x_rs = (extent[2] - extent[0]) / width;
        y_rs = (extent[3] - extent[1]) / height;
        resolution = Math.max(x_rs, y_rs);
        i = 0;
        ref = this._resolutions;
        for (j = 0, len = ref.length; j < len; j++) {
            r = ref[j];
            if (resolution > r) {
                if (i === 0) {
                    return 0;
                }
                if (i > 0) {
                    return i - 1;
                }
            }
            i += 1;
        }
    };
    MercatorTileSource.prototype.get_closest_level_by_extent = function (extent, height, width) {
        var closest, resolution, ress, x_rs, y_rs;
        x_rs = (extent[2] - extent[0]) / width;
        y_rs = (extent[3] - extent[1]) / height;
        resolution = Math.max(x_rs, y_rs);
        ress = this._resolutions;
        closest = this._resolutions.reduce(function (previous, current) {
            if (Math.abs(current - resolution) < Math.abs(previous - resolution)) {
                return current;
            }
            return previous;
        });
        return this._resolutions.indexOf(closest);
    };
    MercatorTileSource.prototype.snap_to_zoom = function (extent, height, width, level) {
        var desired_res, desired_x_delta, desired_y_delta, x_adjust, xmax, xmin, y_adjust, ymax, ymin;
        desired_res = this._resolutions[level];
        desired_x_delta = width * desired_res;
        desired_y_delta = height * desired_res;
        xmin = extent[0], ymin = extent[1], xmax = extent[2], ymax = extent[3];
        x_adjust = (desired_x_delta - (xmax - xmin)) / 2;
        y_adjust = (desired_y_delta - (ymax - ymin)) / 2;
        return [xmin - x_adjust, ymin - y_adjust, xmax + x_adjust, ymax + y_adjust];
    };
    MercatorTileSource.prototype.tms_to_wmts = function (x, y, z) {
        'Note this works both ways';
        return [x, Math.pow(2, z) - 1 - y, z];
    };
    MercatorTileSource.prototype.wmts_to_tms = function (x, y, z) {
        'Note this works both ways';
        return [x, Math.pow(2, z) - 1 - y, z];
    };
    MercatorTileSource.prototype.pixels_to_meters = function (px, py, level) {
        var mx, my, res;
        res = this.get_resolution(level);
        mx = px * res - this.x_origin_offset;
        my = py * res - this.y_origin_offset;
        return [mx, my];
    };
    MercatorTileSource.prototype.meters_to_pixels = function (mx, my, level) {
        var px, py, res;
        res = this.get_resolution(level);
        px = (mx + this.x_origin_offset) / res;
        py = (my + this.y_origin_offset) / res;
        return [px, py];
    };
    MercatorTileSource.prototype.pixels_to_tile = function (px, py) {
        var tx, ty;
        tx = Math.ceil(px / parseFloat(this.tile_size));
        tx = tx === 0 ? tx : tx - 1;
        ty = Math.max(Math.ceil(py / parseFloat(this.tile_size)) - 1, 0);
        return [tx, ty];
    };
    MercatorTileSource.prototype.pixels_to_raster = function (px, py, level) {
        var mapSize;
        mapSize = this.tile_size << level;
        return [px, mapSize - py];
    };
    MercatorTileSource.prototype.meters_to_tile = function (mx, my, level) {
        var px, py, ref;
        ref = this.meters_to_pixels(mx, my, level), px = ref[0], py = ref[1];
        return this.pixels_to_tile(px, py);
    };
    MercatorTileSource.prototype.get_tile_meter_bounds = function (tx, ty, level) {
        var ref, ref1, xmax, xmin, ymax, ymin;
        ref = this.pixels_to_meters(tx * this.tile_size, ty * this.tile_size, level), xmin = ref[0], ymin = ref[1];
        ref1 = this.pixels_to_meters((tx + 1) * this.tile_size, (ty + 1) * this.tile_size, level), xmax = ref1[0], ymax = ref1[1];
        if ((xmin != null) && (ymin != null) && (xmax != null) && (ymax != null)) {
            return [xmin, ymin, xmax, ymax];
        }
        else {
            return void 0;
        }
    };
    MercatorTileSource.prototype.get_tile_geographic_bounds = function (tx, ty, level) {
        var bounds, maxLat, maxLon, minLat, minLon, ref;
        bounds = this.get_tile_meter_bounds(tx, ty, level);
        ref = this.utils.meters_extent_to_geographic(bounds), minLon = ref[0], minLat = ref[1], maxLon = ref[2], maxLat = ref[3];
        return [minLon, minLat, maxLon, maxLat];
    };
    MercatorTileSource.prototype.get_tiles_by_extent = function (extent, level, tile_border) {
        var j, k, ref, ref1, ref2, ref3, ref4, ref5, tiles, tx, txmax, txmin, ty, tymax, tymin, xmax, xmin, ymax, ymin;
        if (tile_border == null) {
            tile_border = 1;
        }
        xmin = extent[0], ymin = extent[1], xmax = extent[2], ymax = extent[3];
        ref = this.meters_to_tile(xmin, ymin, level), txmin = ref[0], tymin = ref[1];
        ref1 = this.meters_to_tile(xmax, ymax, level), txmax = ref1[0], tymax = ref1[1];
        txmin -= tile_border;
        tymin -= tile_border;
        txmax += tile_border;
        tymax += tile_border;
        tiles = [];
        for (ty = j = ref2 = tymax, ref3 = tymin; j >= ref3; ty = j += -1) {
            for (tx = k = ref4 = txmin, ref5 = txmax; k <= ref5; tx = k += 1) {
                if (this.is_valid_tile(tx, ty, level)) {
                    tiles.push([tx, ty, level, this.get_tile_meter_bounds(tx, ty, level)]);
                }
            }
        }
        tiles = this.sort_tiles_from_center(tiles, [txmin, tymin, txmax, tymax]);
        return tiles;
    };
    MercatorTileSource.prototype.quadkey_to_tile_xyz = function (quadKey) {
        'Computes tile x, y and z values based on quadKey.';
        var i, j, mask, ref, tileX, tileY, tileZ, value;
        tileX = 0;
        tileY = 0;
        tileZ = quadKey.length;
        for (i = j = ref = tileZ; j > 0; i = j += -1) {
            value = quadKey.charAt(tileZ - i);
            mask = 1 << (i - 1);
            switch (value) {
                case '0':
                    continue;
                case '1':
                    tileX |= mask;
                    break;
                case '2':
                    tileY |= mask;
                    break;
                case '3':
                    tileX |= mask;
                    tileY |= mask;
                    break;
                default:
                    throw new TypeError("Invalid Quadkey: " + quadKey);
            }
        }
        return [tileX, tileY, tileZ];
    };
    MercatorTileSource.prototype.tile_xyz_to_quadkey = function (x, y, z) {
        'Computes quadkey value based on tile x, y and z values.';
        var digit, i, j, mask, quadKey, ref;
        quadKey = '';
        for (i = j = ref = z; j > 0; i = j += -1) {
            digit = 0;
            mask = 1 << (i - 1);
            if ((x & mask) !== 0) {
                digit += 1;
            }
            if ((y & mask) !== 0) {
                digit += 2;
            }
            quadKey += digit.toString();
        }
        return quadKey;
    };
    MercatorTileSource.prototype.children_by_tile_xyz = function (x, y, z) {
        var b, child_tile_xyz, i, j, quad_key, ref;
        quad_key = this.tile_xyz_to_quadkey(x, y, z);
        child_tile_xyz = [];
        for (i = j = 0; j <= 3; i = j += 1) {
            ref = this.quadkey_to_tile_xyz(quad_key + i.toString()), x = ref[0], y = ref[1], z = ref[2];
            b = this.get_tile_meter_bounds(x, y, z);
            if (b != null) {
                child_tile_xyz.push([x, y, z, b]);
            }
        }
        return child_tile_xyz;
    };
    MercatorTileSource.prototype.parent_by_tile_xyz = function (x, y, z) {
        var parent_quad_key, quad_key;
        quad_key = this.tile_xyz_to_quadkey(x, y, z);
        parent_quad_key = quad_key.substring(0, quad_key.length - 1);
        return this.quadkey_to_tile_xyz(parent_quad_key);
    };
    MercatorTileSource.prototype.get_closest_parent_by_tile_xyz = function (x, y, z) {
        var quad_key, ref, ref1, ref2, world_x;
        world_x = this.calculate_world_x_by_tile_xyz(x, y, z);
        ref = this.normalize_xyz(x, y, z), x = ref[0], y = ref[1], z = ref[2];
        quad_key = this.tile_xyz_to_quadkey(x, y, z);
        while (quad_key.length > 0) {
            quad_key = quad_key.substring(0, quad_key.length - 1);
            ref1 = this.quadkey_to_tile_xyz(quad_key), x = ref1[0], y = ref1[1], z = ref1[2];
            ref2 = this.denormalize_xyz(x, y, z, world_x), x = ref2[0], y = ref2[1], z = ref2[2];
            if (this.tile_xyz_to_key(x, y, z) in this.tiles) {
                return [x, y, z];
            }
        }
        return [0, 0, 0];
    };
    MercatorTileSource.prototype.normalize_xyz = function (x, y, z) {
        var tile_count;
        if (this.wrap_around) {
            tile_count = Math.pow(2, z);
            return [((x % tile_count) + tile_count) % tile_count, y, z];
        }
        else {
            return [x, y, z];
        }
    };
    MercatorTileSource.prototype.denormalize_xyz = function (x, y, z, world_x) {
        return [x + world_x * Math.pow(2, z), y, z];
    };
    MercatorTileSource.prototype.denormalize_meters = function (meters_x, meters_y, level, world_x) {
        return [meters_x + world_x * 2 * Math.PI * 6378137, meters_y];
    };
    MercatorTileSource.prototype.calculate_world_x_by_tile_xyz = function (x, y, z) {
        return Math.floor(x / Math.pow(2, z));
    };
    return MercatorTileSource;
})(tile_source_1.TileSource);

},{"./tile_source":"models/tiles/tile_source","core/properties":"core/properties"}],"models/tiles/quadkey_tile_source":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var mercator_tile_source_1 = require("./mercator_tile_source");
exports.QUADKEYTileSource = (function (superClass) {
    extend(QUADKEYTileSource, superClass);
    function QUADKEYTileSource() {
        return QUADKEYTileSource.__super__.constructor.apply(this, arguments);
    }
    QUADKEYTileSource.prototype.type = 'QUADKEYTileSource';
    QUADKEYTileSource.prototype.get_image_url = function (x, y, z) {
        var image_url, quadKey, ref;
        image_url = this.string_lookup_replace(this.url, this.extra_url_vars);
        ref = this.tms_to_wmts(x, y, z), x = ref[0], y = ref[1], z = ref[2];
        quadKey = this.tile_xyz_to_quadkey(x, y, z);
        return image_url.replace("{Q}", quadKey);
    };
    return QUADKEYTileSource;
})(mercator_tile_source_1.MercatorTileSource);

},{"./mercator_tile_source":"models/tiles/mercator_tile_source"}],"models/tiles/tile_renderer":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var bind = function (fn, me) { return function () { return fn.apply(me, arguments); }; }, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, indexOf = [].indexOf || function (item) { for (var i = 0, l = this.length; i < l; i++) {
    if (i in this && this[i] === item)
        return i;
} return -1; };
var image_pool_1 = require("./image_pool");
var wmts_tile_source_1 = require("./wmts_tile_source");
var renderer_1 = require("../renderers/renderer");
var dom_1 = require("core/dom");
var p = require("core/properties");
var types_1 = require("core/util/types");
exports.TileRendererView = (function (superClass) {
    extend(TileRendererView, superClass);
    function TileRendererView() {
        this._update = bind(this._update, this);
        this._prefetch_tiles = bind(this._prefetch_tiles, this);
        this._on_tile_error = bind(this._on_tile_error, this);
        this._on_tile_cache_load = bind(this._on_tile_cache_load, this);
        this._on_tile_load = bind(this._on_tile_load, this);
        this._add_attribution = bind(this._add_attribution, this);
        return TileRendererView.__super__.constructor.apply(this, arguments);
    }
    TileRendererView.prototype.initialize = function (options) {
        this.attributionEl = null;
        return TileRendererView.__super__.initialize.apply(this, arguments);
    };
    TileRendererView.prototype.bind_bokeh_events = function () {
        return this.listenTo(this.model, 'change', this.request_render);
    };
    TileRendererView.prototype.get_extent = function () {
        return [this.x_range.start, this.y_range.start, this.x_range.end, this.y_range.end];
    };
    TileRendererView.prototype._set_data = function () {
        this.pool = new image_pool_1.ImagePool();
        this.map_plot = this.plot_model.plot;
        this.map_canvas = this.plot_view.canvas_view.ctx;
        this.map_frame = this.plot_model.frame;
        this.x_range = this.map_plot.x_range;
        this.x_mapper = this.map_frame.x_mappers['default'];
        this.y_range = this.map_plot.y_range;
        this.y_mapper = this.map_frame.y_mappers['default'];
        this.extent = this.get_extent();
        this._last_height = void 0;
        return this._last_width = void 0;
    };
    TileRendererView.prototype._add_attribution = function () {
        var attribution, border_width, bottom_offset, max_width, overlays, right_offset;
        attribution = this.model.tile_source.attribution;
        if (types_1.isString(attribution) && attribution.length > 0) {
            if (this.attributionEl == null) {
                border_width = this.map_plot.outline_line_width;
                bottom_offset = this.map_plot.min_border_bottom + border_width;
                right_offset = this.map_frame.right - this.map_frame.width;
                max_width = this.map_frame.width - border_width;
                this.attributionEl = dom_1.div({
                    "class": 'bk-tile-attribution',
                    style: {
                        position: 'absolute',
                        bottom: bottom_offset + "px",
                        right: right_offset + "px",
                        'max-width': max_width + "px",
                        'background-color': 'rgba(255,255,255,0.8)',
                        'font-size': '9pt',
                        'font-family': 'sans-serif'
                    }
                });
                overlays = this.plot_view.el.querySelector('div.bk-canvas-events');
                overlays.appendChild(this.attributionEl);
            }
            return this.attributionEl.innerHTML = attribution;
        }
    };
    TileRendererView.prototype._map_data = function () {
        var new_extent, zoom_level;
        this.initial_extent = this.get_extent();
        zoom_level = this.model.tile_source.get_level_by_extent(this.initial_extent, this.map_frame.height, this.map_frame.width);
        new_extent = this.model.tile_source.snap_to_zoom(this.initial_extent, this.map_frame.height, this.map_frame.width, zoom_level);
        this.x_range.start = new_extent[0];
        this.y_range.start = new_extent[1];
        this.x_range.end = new_extent[2];
        this.y_range.end = new_extent[3];
        return this._add_attribution();
    };
    TileRendererView.prototype._on_tile_load = function (e) {
        var tile_data;
        tile_data = e.target.tile_data;
        tile_data.img = e.target;
        tile_data.current = true;
        tile_data.loaded = true;
        return this.request_render();
    };
    TileRendererView.prototype._on_tile_cache_load = function (e) {
        var tile_data;
        tile_data = e.target.tile_data;
        tile_data.img = e.target;
        return tile_data.loaded = true;
    };
    TileRendererView.prototype._on_tile_error = function (e) {
        return '';
    };
    TileRendererView.prototype._create_tile = function (x, y, z, bounds, cache_only) {
        var normalized_coords, ref, tile;
        if (cache_only == null) {
            cache_only = false;
        }
        normalized_coords = this.model.tile_source.normalize_xyz(x, y, z);
        tile = this.pool.pop();
        if (cache_only) {
            tile.onload = this._on_tile_cache_load;
        }
        else {
            tile.onload = this._on_tile_load;
        }
        tile.onerror = this._on_tile_error;
        tile.alt = '';
        tile.tile_data = {
            tile_coords: [x, y, z],
            normalized_coords: normalized_coords,
            quadkey: this.model.tile_source.tile_xyz_to_quadkey(x, y, z),
            cache_key: this.model.tile_source.tile_xyz_to_key(x, y, z),
            bounds: bounds,
            loaded: false,
            x_coord: bounds[0],
            y_coord: bounds[3]
        };
        this.model.tile_source.tiles[tile.tile_data.cache_key] = tile.tile_data;
        tile.src = (ref = this.model.tile_source).get_image_url.apply(ref, normalized_coords);
        return tile;
    };
    TileRendererView.prototype._enforce_aspect_ratio = function () {
        var extent, new_extent, zoom_level;
        if (this._last_height !== this.map_frame.height || this._last_width !== this.map_frame.width) {
            extent = this.get_extent();
            zoom_level = this.model.tile_source.get_level_by_extent(extent, this.map_frame.height, this.map_frame.width);
            new_extent = this.model.tile_source.snap_to_zoom(extent, this.map_frame.height, this.map_frame.width, zoom_level);
            this.x_range.setv({
                start: new_extent[0],
                end: new_extent[2]
            });
            this.y_range.setv({
                start: new_extent[1],
                end: new_extent[3]
            });
            this.extent = new_extent;
            this._last_height = this.map_frame.height;
            this._last_width = this.map_frame.width;
            return true;
        }
        return false;
    };
    TileRendererView.prototype.render = function (ctx, indices, args) {
        if (this.map_initialized == null) {
            this._set_data();
            this._map_data();
            this.map_initialized = true;
        }
        if (this._enforce_aspect_ratio()) {
            return;
        }
        this._update();
        if (this.prefetch_timer != null) {
            clearTimeout(this.prefetch_timer);
        }
        return this.prefetch_timer = setTimeout(this._prefetch_tiles, 500);
    };
    TileRendererView.prototype._draw_tile = function (tile_key) {
        var ref, ref1, sh, sw, sx, sxmax, sxmin, sy, symax, symin, tile_obj;
        tile_obj = this.model.tile_source.tiles[tile_key];
        if (tile_obj != null) {
            ref = this.plot_view.frame.map_to_screen([tile_obj.bounds[0]], [tile_obj.bounds[3]], this.plot_view.canvas), sxmin = ref[0], symin = ref[1];
            ref1 = this.plot_view.frame.map_to_screen([tile_obj.bounds[2]], [tile_obj.bounds[1]], this.plot_view.canvas), sxmax = ref1[0], symax = ref1[1];
            sxmin = sxmin[0];
            symin = symin[0];
            sxmax = sxmax[0];
            symax = symax[0];
            sw = sxmax - sxmin;
            sh = symax - symin;
            sx = sxmin;
            sy = symin;
            return this.map_canvas.drawImage(tile_obj.img, sx, sy, sw, sh);
        }
    };
    TileRendererView.prototype._set_rect = function () {
        var h, l, outline_width, t, w;
        outline_width = this.plot_model.plot.properties.outline_line_width.value();
        l = this.plot_view.canvas.vx_to_sx(this.map_frame.left) + (outline_width / 2);
        t = this.plot_view.canvas.vy_to_sy(this.map_frame.top) + (outline_width / 2);
        w = this.map_frame.width - outline_width;
        h = this.map_frame.height - outline_width;
        this.map_canvas.rect(l, t, w, h);
        return this.map_canvas.clip();
    };
    TileRendererView.prototype._render_tiles = function (tile_keys) {
        var i, len, tile_key;
        this.map_canvas.save();
        this._set_rect();
        this.map_canvas.globalAlpha = this.model.alpha;
        for (i = 0, len = tile_keys.length; i < len; i++) {
            tile_key = tile_keys[i];
            this._draw_tile(tile_key);
        }
        return this.map_canvas.restore();
    };
    TileRendererView.prototype._prefetch_tiles = function () {
        var bounds, c, cbounds, children, cx, cy, cz, extent, h, i, ref, results, t, tile_source, tiles, w, x, y, z, zoom_level;
        tile_source = this.model.tile_source;
        extent = this.get_extent();
        h = this.map_frame.height;
        w = this.map_frame.width;
        zoom_level = this.model.tile_source.get_level_by_extent(extent, h, w);
        tiles = this.model.tile_source.get_tiles_by_extent(extent, zoom_level);
        results = [];
        for (t = i = 0, ref = Math.min(10, tiles.length); i <= ref; t = i += 1) {
            x = t[0], y = t[1], z = t[2], bounds = t[3];
            children = this.model.tile_source.children_by_tile_xyz(x, y, z);
            results.push((function () {
                var j, len, results1;
                results1 = [];
                for (j = 0, len = children.length; j < len; j++) {
                    c = children[j];
                    cx = c[0], cy = c[1], cz = c[2], cbounds = c[3];
                    if (tile_source.tile_xyz_to_key(cx, cy, cz) in tile_source.tiles) {
                        continue;
                    }
                    else {
                        results1.push(this._create_tile(cx, cy, cz, cbounds, true));
                    }
                }
                return results1;
            }).call(this));
        }
        return results;
    };
    TileRendererView.prototype._fetch_tiles = function (tiles) {
        var bounds, i, len, results, t, x, y, z;
        results = [];
        for (i = 0, len = tiles.length; i < len; i++) {
            t = tiles[i];
            x = t[0], y = t[1], z = t[2], bounds = t[3];
            results.push(this._create_tile(x, y, z, bounds));
        }
        return results;
    };
    TileRendererView.prototype._update = function () {
        var bounds, c, cached, cbounds, child_key, children, cx, cy, cz, extent, h, i, j, k, key, len, len1, len2, max_zoom, min_zoom, need_load, parent_key, parent_tile, parents, px, py, pz, ref, snap_back, t, tile, tile_source, tiles, w, x, y, z, zoom_level, zooming_out;
        tile_source = this.model.tile_source;
        min_zoom = tile_source.min_zoom;
        max_zoom = tile_source.max_zoom;
        tile_source.update();
        extent = this.get_extent();
        zooming_out = this.extent[2] - this.extent[0] < extent[2] - extent[0];
        h = this.map_frame.height;
        w = this.map_frame.width;
        zoom_level = tile_source.get_level_by_extent(extent, h, w);
        snap_back = false;
        if (zoom_level < min_zoom) {
            extent = this.extent;
            zoom_level = min_zoom;
            snap_back = true;
        }
        else if (zoom_level > max_zoom) {
            extent = this.extent;
            zoom_level = max_zoom;
            snap_back = true;
        }
        if (snap_back) {
            this.x_range.setv({
                x_range: {
                    start: extent[0],
                    end: extent[2]
                }
            });
            this.y_range.setv({
                start: extent[1],
                end: extent[3]
            });
            this.extent = extent;
        }
        this.extent = extent;
        tiles = tile_source.get_tiles_by_extent(extent, zoom_level);
        parents = [];
        need_load = [];
        cached = [];
        children = [];
        for (i = 0, len = tiles.length; i < len; i++) {
            t = tiles[i];
            x = t[0], y = t[1], z = t[2], bounds = t[3];
            key = tile_source.tile_xyz_to_key(x, y, z);
            tile = tile_source.tiles[key];
            if ((tile != null) && tile.loaded === true) {
                cached.push(key);
            }
            else {
                if (this.model.render_parents) {
                    ref = tile_source.get_closest_parent_by_tile_xyz(x, y, z), px = ref[0], py = ref[1], pz = ref[2];
                    parent_key = tile_source.tile_xyz_to_key(px, py, pz);
                    parent_tile = tile_source.tiles[parent_key];
                    if ((parent_tile != null) && parent_tile.loaded && indexOf.call(parents, parent_key) < 0) {
                        parents.push(parent_key);
                    }
                    if (zooming_out) {
                        children = tile_source.children_by_tile_xyz(x, y, z);
                        for (j = 0, len1 = children.length; j < len1; j++) {
                            c = children[j];
                            cx = c[0], cy = c[1], cz = c[2], cbounds = c[3];
                            child_key = tile_source.tile_xyz_to_key(cx, cy, cz);
                            if (child_key in tile_source.tiles) {
                                children.push(child_key);
                            }
                        }
                    }
                }
            }
            if (tile == null) {
                need_load.push(t);
            }
        }
        this._render_tiles(parents);
        this._render_tiles(children);
        this._render_tiles(cached);
        for (k = 0, len2 = cached.length; k < len2; k++) {
            t = cached[k];
            tile_source.tiles[t].current = true;
        }
        if (this.render_timer != null) {
            clearTimeout(this.render_timer);
        }
        return this.render_timer = setTimeout(((function (_this) {
            return function () {
                return _this._fetch_tiles(need_load);
            };
        })(this)), 65);
    };
    return TileRendererView;
})(renderer_1.RendererView);
exports.TileRenderer = (function (superClass) {
    extend(TileRenderer, superClass);
    function TileRenderer() {
        return TileRenderer.__super__.constructor.apply(this, arguments);
    }
    TileRenderer.prototype.default_view = exports.TileRendererView;
    TileRenderer.prototype.type = 'TileRenderer';
    TileRenderer.define({
        alpha: [p.Number, 1.0],
        x_range_name: [p.String, "default"],
        y_range_name: [p.String, "default"],
        tile_source: [
            p.Instance, function () {
                return new wmts_tile_source_1.WMTSTileSource();
            }
        ],
        render_parents: [p.Bool, true]
    });
    TileRenderer.override({
        level: 'underlay'
    });
    return TileRenderer;
})(renderer_1.Renderer);

},{"../renderers/renderer":"models/renderers/renderer","./image_pool":"models/tiles/image_pool","./wmts_tile_source":"models/tiles/wmts_tile_source","core/dom":"core/dom","core/properties":"core/properties","core/util/types":"core/util/types"}],"models/tiles/tile_source":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var image_pool_1 = require("./image_pool");
var tile_utils_1 = require("./tile_utils");
var logging_1 = require("core/logging");
var p = require("core/properties");
var model_1 = require("../../model");
exports.TileSource = (function (superClass) {
    extend(TileSource, superClass);
    TileSource.prototype.type = 'TileSource';
    TileSource.define({
        url: [p.String, ''],
        tile_size: [p.Number, 256],
        max_zoom: [p.Number, 30],
        min_zoom: [p.Number, 0],
        extra_url_vars: [p.Any, {}],
        attribution: [p.String, ''],
        x_origin_offset: [p.Number],
        y_origin_offset: [p.Number],
        initial_resolution: [p.Number]
    });
    TileSource.prototype.initialize = function (options) {
        TileSource.__super__.initialize.call(this, options);
        return this.normalize_case();
    };
    function TileSource(options) {
        if (options == null) {
            options = {};
        }
        TileSource.__super__.constructor.apply(this, arguments);
        this.utils = new tile_utils_1.ProjectionUtils();
        this.pool = new image_pool_1.ImagePool();
        this.tiles = {};
        this.normalize_case();
    }
    TileSource.prototype.string_lookup_replace = function (str, lookup) {
        var key, result_str, value;
        result_str = str;
        for (key in lookup) {
            value = lookup[key];
            result_str = result_str.replace('{' + key + '}', value.toString());
        }
        return result_str;
    };
    TileSource.prototype.normalize_case = function () {
        'Note: should probably be refactored into subclasses.';
        var url;
        url = this.url;
        url = url.replace('{x}', '{X}');
        url = url.replace('{y}', '{Y}');
        url = url.replace('{z}', '{Z}');
        url = url.replace('{q}', '{Q}');
        url = url.replace('{xmin}', '{XMIN}');
        url = url.replace('{ymin}', '{YMIN}');
        url = url.replace('{xmax}', '{XMAX}');
        url = url.replace('{ymax}', '{YMAX}');
        return this.url = url;
    };
    TileSource.prototype.update = function () {
        var key, ref, results, tile;
        logging_1.logger.debug("TileSource: tile cache count: " + (Object.keys(this.tiles).length));
        ref = this.tiles;
        results = [];
        for (key in ref) {
            tile = ref[key];
            tile.current = false;
            results.push(tile.retain = false);
        }
        return results;
    };
    TileSource.prototype.tile_xyz_to_key = function (x, y, z) {
        var key;
        key = x + ":" + y + ":" + z;
        return key;
    };
    TileSource.prototype.key_to_tile_xyz = function (key) {
        var c;
        return (function () {
            var i, len, ref, results;
            ref = key.split(':');
            results = [];
            for (i = 0, len = ref.length; i < len; i++) {
                c = ref[i];
                results.push(parseInt(c));
            }
            return results;
        })();
    };
    TileSource.prototype.sort_tiles_from_center = function (tiles, tile_extent) {
        var center_x, center_y, txmax, txmin, tymax, tymin;
        txmin = tile_extent[0], tymin = tile_extent[1], txmax = tile_extent[2], tymax = tile_extent[3];
        center_x = (txmax - txmin) / 2 + txmin;
        center_y = (tymax - tymin) / 2 + tymin;
        tiles.sort(function (a, b) {
            var a_distance, b_distance;
            a_distance = Math.sqrt(Math.pow(center_x - a[0], 2) + Math.pow(center_y - a[1], 2));
            b_distance = Math.sqrt(Math.pow(center_x - b[0], 2) + Math.pow(center_y - b[1], 2));
            return a_distance - b_distance;
        });
        return tiles;
    };
    TileSource.prototype.prune_tiles = function () {
        var key, ref, ref1, results, tile;
        ref = this.tiles;
        for (key in ref) {
            tile = ref[key];
            tile.retain = tile.current || tile.tile_coords[2] < 3;
            if (tile.current) {
                this.retain_neighbors(tile);
                this.retain_children(tile);
                this.retain_parents(tile);
            }
        }
        ref1 = this.tiles;
        results = [];
        for (key in ref1) {
            tile = ref1[key];
            if (!tile.retain) {
                results.push(this.remove_tile(key));
            }
            else {
                results.push(void 0);
            }
        }
        return results;
    };
    TileSource.prototype.remove_tile = function (key) {
        var tile;
        tile = this.tiles[key];
        if (tile != null) {
            this.pool.push(tile.img);
            return delete this.tiles[key];
        }
    };
    TileSource.prototype.get_image_url = function (x, y, z) {
        var image_url;
        image_url = this.string_lookup_replace(this.url, this.extra_url_vars);
        return image_url.replace("{X}", x).replace('{Y}', y).replace("{Z}", z);
    };
    TileSource.prototype.retain_neighbors = function (reference_tile) {
        throw new Error("Not Implemented");
    };
    TileSource.prototype.retain_parents = function (reference_tile) {
        throw new Error("Not Implemented");
    };
    TileSource.prototype.retain_children = function (reference_tile) {
        throw new Error("Not Implemented");
    };
    TileSource.prototype.tile_xyz_to_quadkey = function (x, y, z) {
        throw new Error("Not Implemented");
    };
    TileSource.prototype.quadkey_to_tile_xyz = function (quadkey) {
        throw new Error("Not Implemented");
    };
    return TileSource;
})(model_1.Model);

},{"../../model":"model","./image_pool":"models/tiles/image_pool","./tile_utils":"models/tiles/tile_utils","core/logging":"core/logging","core/properties":"core/properties"}],"models/tiles/tile_utils":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var proj4_1 = require("core/util/proj4");
exports.ProjectionUtils = (function () {
    function ProjectionUtils() {
        this.origin_shift = 2 * Math.PI * 6378137 / 2.0;
    }
    ProjectionUtils.prototype.geographic_to_meters = function (xLon, yLat) {
        return proj4_1.proj4(proj4_1.wgs84, proj4_1.mercator, [xLon, yLat]);
    };
    ProjectionUtils.prototype.meters_to_geographic = function (mx, my) {
        return proj4_1.proj4(proj4_1.mercator, proj4_1.wgs84, [mx, my]);
    };
    ProjectionUtils.prototype.geographic_extent_to_meters = function (extent) {
        var ref, ref1, xmax, xmin, ymax, ymin;
        xmin = extent[0], ymin = extent[1], xmax = extent[2], ymax = extent[3];
        ref = this.geographic_to_meters(xmin, ymin), xmin = ref[0], ymin = ref[1];
        ref1 = this.geographic_to_meters(xmax, ymax), xmax = ref1[0], ymax = ref1[1];
        return [xmin, ymin, xmax, ymax];
    };
    ProjectionUtils.prototype.meters_extent_to_geographic = function (extent) {
        var ref, ref1, xmax, xmin, ymax, ymin;
        xmin = extent[0], ymin = extent[1], xmax = extent[2], ymax = extent[3];
        ref = this.meters_to_geographic(xmin, ymin), xmin = ref[0], ymin = ref[1];
        ref1 = this.meters_to_geographic(xmax, ymax), xmax = ref1[0], ymax = ref1[1];
        return [xmin, ymin, xmax, ymax];
    };
    return ProjectionUtils;
})();

},{"core/util/proj4":"core/util/proj4"}],"models/tiles/tms_tile_source":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var mercator_tile_source_1 = require("./mercator_tile_source");
exports.TMSTileSource = (function (superClass) {
    extend(TMSTileSource, superClass);
    function TMSTileSource() {
        return TMSTileSource.__super__.constructor.apply(this, arguments);
    }
    TMSTileSource.prototype.type = 'TMSTileSource';
    TMSTileSource.prototype.get_image_url = function (x, y, z) {
        var image_url;
        image_url = this.string_lookup_replace(this.url, this.extra_url_vars);
        return image_url.replace("{X}", x).replace('{Y}', y).replace("{Z}", z);
    };
    return TMSTileSource;
})(mercator_tile_source_1.MercatorTileSource);

},{"./mercator_tile_source":"models/tiles/mercator_tile_source"}],"models/tiles/wmts_tile_source":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var mercator_tile_source_1 = require("./mercator_tile_source");
exports.WMTSTileSource = (function (superClass) {
    extend(WMTSTileSource, superClass);
    function WMTSTileSource() {
        return WMTSTileSource.__super__.constructor.apply(this, arguments);
    }
    WMTSTileSource.prototype.type = 'WMTSTileSource';
    WMTSTileSource.prototype.get_image_url = function (x, y, z) {
        var image_url, ref;
        image_url = this.string_lookup_replace(this.url, this.extra_url_vars);
        ref = this.tms_to_wmts(x, y, z), x = ref[0], y = ref[1], z = ref[2];
        return image_url.replace("{X}", x).replace('{Y}', y).replace("{Z}", z);
    };
    return WMTSTileSource;
})(mercator_tile_source_1.MercatorTileSource);

},{"./mercator_tile_source":"models/tiles/mercator_tile_source"}],"models/tools/actions/action_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var button_tool_1 = require("../button_tool");
exports.ActionToolButtonView = (function (superClass) {
    extend(ActionToolButtonView, superClass);
    function ActionToolButtonView() {
        return ActionToolButtonView.__super__.constructor.apply(this, arguments);
    }
    ActionToolButtonView.prototype._clicked = function () {
        return this.model.trigger('do');
    };
    return ActionToolButtonView;
})(button_tool_1.ButtonToolButtonView);
exports.ActionToolView = (function (superClass) {
    extend(ActionToolView, superClass);
    function ActionToolView() {
        return ActionToolView.__super__.constructor.apply(this, arguments);
    }
    ActionToolView.prototype.initialize = function (options) {
        ActionToolView.__super__.initialize.call(this, options);
        return this.listenTo(this.model, 'do', this["do"]);
    };
    return ActionToolView;
})(button_tool_1.ButtonToolView);
exports.ActionTool = (function (superClass) {
    extend(ActionTool, superClass);
    function ActionTool() {
        return ActionTool.__super__.constructor.apply(this, arguments);
    }
    return ActionTool;
})(button_tool_1.ButtonTool);

},{"../button_tool":"models/tools/button_tool"}],"models/tools/actions/help_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var action_tool_1 = require("./action_tool");
var p = require("core/properties");
exports.HelpToolView = (function (superClass) {
    extend(HelpToolView, superClass);
    function HelpToolView() {
        return HelpToolView.__super__.constructor.apply(this, arguments);
    }
    HelpToolView.prototype["do"] = function () {
        return window.open(this.model.redirect);
    };
    return HelpToolView;
})(action_tool_1.ActionToolView);
exports.HelpTool = (function (superClass) {
    extend(HelpTool, superClass);
    function HelpTool() {
        return HelpTool.__super__.constructor.apply(this, arguments);
    }
    HelpTool.prototype.default_view = exports.HelpToolView;
    HelpTool.prototype.type = "HelpTool";
    HelpTool.prototype.tool_name = "Help";
    HelpTool.prototype.icon = "bk-tool-icon-help";
    HelpTool.define({
        help_tooltip: [p.String, 'Click the question mark to learn more about Bokeh plot tools.'],
        redirect: [p.String, 'http://bokeh.pydata.org/en/latest/docs/user_guide/tools.html']
    });
    HelpTool.getters({
        tooltip: function () {
            return this.help_tooltip;
        }
    });
    return HelpTool;
})(action_tool_1.ActionTool);

},{"./action_tool":"models/tools/actions/action_tool","core/properties":"core/properties"}],"models/tools/actions/redo_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var action_tool_1 = require("./action_tool");
exports.RedoToolView = (function (superClass) {
    extend(RedoToolView, superClass);
    function RedoToolView() {
        return RedoToolView.__super__.constructor.apply(this, arguments);
    }
    RedoToolView.prototype.initialize = function (options) {
        RedoToolView.__super__.initialize.call(this, options);
        return this.listenTo(this.plot_view, "state_changed", (function (_this) {
            return function () {
                return _this.model.disabled = !_this.plot_view.can_redo();
            };
        })(this));
    };
    RedoToolView.prototype["do"] = function () {
        return this.plot_view.redo();
    };
    return RedoToolView;
})(action_tool_1.ActionToolView);
exports.RedoTool = (function (superClass) {
    extend(RedoTool, superClass);
    function RedoTool() {
        return RedoTool.__super__.constructor.apply(this, arguments);
    }
    RedoTool.prototype.default_view = exports.RedoToolView;
    RedoTool.prototype.type = "RedoTool";
    RedoTool.prototype.tool_name = "Redo";
    RedoTool.prototype.icon = "bk-tool-icon-redo";
    RedoTool.override({
        disabled: true
    });
    return RedoTool;
})(action_tool_1.ActionTool);

},{"./action_tool":"models/tools/actions/action_tool"}],"models/tools/actions/reset_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var action_tool_1 = require("./action_tool");
var p = require("core/properties");
exports.ResetToolView = (function (superClass) {
    extend(ResetToolView, superClass);
    function ResetToolView() {
        return ResetToolView.__super__.constructor.apply(this, arguments);
    }
    ResetToolView.prototype["do"] = function () {
        this.plot_view.clear_state();
        this.plot_view.reset_range();
        this.plot_view.reset_selection();
        if (this.model.reset_size) {
            return this.plot_view.reset_dimensions();
        }
    };
    return ResetToolView;
})(action_tool_1.ActionToolView);
exports.ResetTool = (function (superClass) {
    extend(ResetTool, superClass);
    function ResetTool() {
        return ResetTool.__super__.constructor.apply(this, arguments);
    }
    ResetTool.prototype.default_view = exports.ResetToolView;
    ResetTool.prototype.type = "ResetTool";
    ResetTool.prototype.tool_name = "Reset";
    ResetTool.prototype.icon = "bk-tool-icon-reset";
    ResetTool.define({
        reset_size: [p.Bool, true]
    });
    return ResetTool;
})(action_tool_1.ActionTool);

},{"./action_tool":"models/tools/actions/action_tool","core/properties":"core/properties"}],"models/tools/actions/save_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var action_tool_1 = require("./action_tool");
exports.SaveToolView = (function (superClass) {
    extend(SaveToolView, superClass);
    function SaveToolView() {
        return SaveToolView.__super__.constructor.apply(this, arguments);
    }
    SaveToolView.prototype["do"] = function () {
        return this.plot_view.save("bokeh_plot.png");
    };
    return SaveToolView;
})(action_tool_1.ActionToolView);
exports.SaveTool = (function (superClass) {
    extend(SaveTool, superClass);
    function SaveTool() {
        return SaveTool.__super__.constructor.apply(this, arguments);
    }
    SaveTool.prototype.default_view = exports.SaveToolView;
    SaveTool.prototype.type = "SaveTool";
    SaveTool.prototype.tool_name = "Save";
    SaveTool.prototype.icon = "bk-tool-icon-save";
    return SaveTool;
})(action_tool_1.ActionTool);

},{"./action_tool":"models/tools/actions/action_tool"}],"models/tools/actions/undo_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var action_tool_1 = require("./action_tool");
exports.UndoToolView = (function (superClass) {
    extend(UndoToolView, superClass);
    function UndoToolView() {
        return UndoToolView.__super__.constructor.apply(this, arguments);
    }
    UndoToolView.prototype.initialize = function (options) {
        UndoToolView.__super__.initialize.call(this, options);
        return this.listenTo(this.plot_view, "state_changed", (function (_this) {
            return function () {
                return _this.model.disabled = !_this.plot_view.can_undo();
            };
        })(this));
    };
    UndoToolView.prototype["do"] = function () {
        return this.plot_view.undo();
    };
    return UndoToolView;
})(action_tool_1.ActionToolView);
exports.UndoTool = (function (superClass) {
    extend(UndoTool, superClass);
    function UndoTool() {
        return UndoTool.__super__.constructor.apply(this, arguments);
    }
    UndoTool.prototype.default_view = exports.UndoToolView;
    UndoTool.prototype.type = "UndoTool";
    UndoTool.prototype.tool_name = "Undo";
    UndoTool.prototype.icon = "bk-tool-icon-undo";
    UndoTool.override({
        disabled: true
    });
    return UndoTool;
})(action_tool_1.ActionTool);

},{"./action_tool":"models/tools/actions/action_tool"}],"models/tools/actions/zoom_in_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var action_tool_1 = require("./action_tool");
var zoom_1 = require("core/util/zoom");
var p = require("core/properties");
exports.ZoomInToolView = (function (superClass) {
    extend(ZoomInToolView, superClass);
    function ZoomInToolView() {
        return ZoomInToolView.__super__.constructor.apply(this, arguments);
    }
    ZoomInToolView.prototype["do"] = function () {
        var dims, frame, h_axis, v_axis, zoom_info;
        frame = this.plot_model.frame;
        dims = this.model.dimensions;
        h_axis = dims === 'width' || dims === 'both';
        v_axis = dims === 'height' || dims === 'both';
        zoom_info = zoom_1.scale_range(frame, this.model.factor, h_axis, v_axis);
        this.plot_view.push_state('zoom_out', {
            range: zoom_info
        });
        this.plot_view.update_range(zoom_info, false, true);
        this.plot_view.interactive_timestamp = Date.now();
        return null;
    };
    return ZoomInToolView;
})(action_tool_1.ActionToolView);
exports.ZoomInTool = (function (superClass) {
    extend(ZoomInTool, superClass);
    function ZoomInTool() {
        return ZoomInTool.__super__.constructor.apply(this, arguments);
    }
    ZoomInTool.prototype.default_view = exports.ZoomInToolView;
    ZoomInTool.prototype.type = "ZoomInTool";
    ZoomInTool.prototype.tool_name = "Zoom In";
    ZoomInTool.prototype.icon = "bk-tool-icon-zoom-in";
    ZoomInTool.getters({
        tooltip: function () {
            return this._get_dim_tooltip(this.tool_name, this.dimensions);
        }
    });
    ZoomInTool.define({
        factor: [p.Percent, 0.1],
        dimensions: [p.Dimensions, "both"]
    });
    return ZoomInTool;
})(action_tool_1.ActionTool);

},{"./action_tool":"models/tools/actions/action_tool","core/properties":"core/properties","core/util/zoom":"core/util/zoom"}],"models/tools/actions/zoom_out_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var action_tool_1 = require("./action_tool");
var zoom_1 = require("core/util/zoom");
var p = require("core/properties");
exports.ZoomOutToolView = (function (superClass) {
    extend(ZoomOutToolView, superClass);
    function ZoomOutToolView() {
        return ZoomOutToolView.__super__.constructor.apply(this, arguments);
    }
    ZoomOutToolView.prototype["do"] = function () {
        var dims, frame, h_axis, v_axis, zoom_info;
        frame = this.plot_model.frame;
        dims = this.model.dimensions;
        h_axis = dims === 'width' || dims === 'both';
        v_axis = dims === 'height' || dims === 'both';
        zoom_info = zoom_1.scale_range(frame, -this.model.factor, h_axis, v_axis);
        this.plot_view.push_state('zoom_out', {
            range: zoom_info
        });
        this.plot_view.update_range(zoom_info, false, true);
        this.plot_view.interactive_timestamp = Date.now();
        return null;
    };
    return ZoomOutToolView;
})(action_tool_1.ActionToolView);
exports.ZoomOutTool = (function (superClass) {
    extend(ZoomOutTool, superClass);
    function ZoomOutTool() {
        return ZoomOutTool.__super__.constructor.apply(this, arguments);
    }
    ZoomOutTool.prototype.default_view = exports.ZoomOutToolView;
    ZoomOutTool.prototype.type = "ZoomOutTool";
    ZoomOutTool.prototype.tool_name = "Zoom Out";
    ZoomOutTool.prototype.icon = "bk-tool-icon-zoom-out";
    ZoomOutTool.getters({
        tooltip: function () {
            return this._get_dim_tooltip(this.tool_name, this.dimensions);
        }
    });
    ZoomOutTool.define({
        factor: [p.Percent, 0.1],
        dimensions: [p.Dimensions, "both"]
    });
    return ZoomOutTool;
})(action_tool_1.ActionTool);

},{"./action_tool":"models/tools/actions/action_tool","core/properties":"core/properties","core/util/zoom":"core/util/zoom"}],"models/tools/button_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var bokeh_view_1 = require("core/bokeh_view");
var tool_1 = require("./tool");
var dom_1 = require("core/dom");
var p = require("core/properties");
exports.ButtonToolButtonView = (function (superClass) {
    extend(ButtonToolButtonView, superClass);
    function ButtonToolButtonView() {
        return ButtonToolButtonView.__super__.constructor.apply(this, arguments);
    }
    ButtonToolButtonView.prototype.className = "bk-toolbar-button";
    ButtonToolButtonView.prototype.initialize = function (options) {
        ButtonToolButtonView.__super__.initialize.call(this, options);
        this.listenTo(this.model, 'change', (function (_this) {
            return function () {
                return _this.render();
            };
        })(this));
        this.el.addEventListener("click", (function (_this) {
            return function (e) {
                return _this._clicked(e);
            };
        })(this));
        return this.render();
    };
    ButtonToolButtonView.prototype.render = function () {
        var icon, tip;
        dom_1.empty(this.el);
        this.el.disabled = this.model.disabled;
        icon = dom_1.div({
            "class": ['bk-btn-icon', this.model.icon]
        });
        tip = dom_1.span({
            "class": 'bk-tip'
        }, this.model.tooltip);
        this.el.appendChild(icon);
        return this.el.appendChild(tip);
    };
    ButtonToolButtonView.prototype._clicked = function (e) { };
    return ButtonToolButtonView;
})(bokeh_view_1.BokehView);
exports.ButtonToolView = (function (superClass) {
    extend(ButtonToolView, superClass);
    function ButtonToolView() {
        return ButtonToolView.__super__.constructor.apply(this, arguments);
    }
    return ButtonToolView;
})(tool_1.ToolView);
exports.ButtonTool = (function (superClass) {
    extend(ButtonTool, superClass);
    function ButtonTool() {
        return ButtonTool.__super__.constructor.apply(this, arguments);
    }
    ButtonTool.prototype.icon = null;
    ButtonTool.getters({
        tooltip: function () {
            return this.tool_name;
        }
    });
    ButtonTool.internal({
        disabled: [p.Boolean, false]
    });
    return ButtonTool;
})(tool_1.Tool);

},{"./tool":"models/tools/tool","core/bokeh_view":"core/bokeh_view","core/dom":"core/dom","core/properties":"core/properties"}],"models/tools/gestures/box_select_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var DEFAULT_BOX_OVERLAY, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var select_tool_1 = require("./select_tool");
var box_annotation_1 = require("../../annotations/box_annotation");
var p = require("core/properties");
exports.BoxSelectToolView = (function (superClass) {
    extend(BoxSelectToolView, superClass);
    function BoxSelectToolView() {
        return BoxSelectToolView.__super__.constructor.apply(this, arguments);
    }
    BoxSelectToolView.prototype._pan_start = function (e) {
        var canvas;
        canvas = this.plot_view.canvas;
        this._baseboint = [canvas.sx_to_vx(e.bokeh.sx), canvas.sy_to_vy(e.bokeh.sy)];
        return null;
    };
    BoxSelectToolView.prototype._pan = function (e) {
        var append, canvas, curpoint, dims, frame, ref, ref1, vxlim, vylim;
        canvas = this.plot_view.canvas;
        curpoint = [canvas.sx_to_vx(e.bokeh.sx), canvas.sy_to_vy(e.bokeh.sy)];
        frame = this.plot_model.frame;
        dims = this.model.dimensions;
        ref = this.model._get_dim_limits(this._baseboint, curpoint, frame, dims), vxlim = ref[0], vylim = ref[1];
        this.model.overlay.update({
            left: vxlim[0],
            right: vxlim[1],
            top: vylim[1],
            bottom: vylim[0]
        });
        if (this.model.select_every_mousemove) {
            append = (ref1 = e.srcEvent.shiftKey) != null ? ref1 : false;
            this._select(vxlim, vylim, false, append);
        }
        return null;
    };
    BoxSelectToolView.prototype._pan_end = function (e) {
        var append, canvas, curpoint, dims, frame, ref, ref1, vxlim, vylim;
        canvas = this.plot_view.canvas;
        curpoint = [canvas.sx_to_vx(e.bokeh.sx), canvas.sy_to_vy(e.bokeh.sy)];
        frame = this.plot_model.frame;
        dims = this.model.dimensions;
        ref = this.model._get_dim_limits(this._baseboint, curpoint, frame, dims), vxlim = ref[0], vylim = ref[1];
        append = (ref1 = e.srcEvent.shiftKey) != null ? ref1 : false;
        this._select(vxlim, vylim, true, append);
        this.model.overlay.update({
            left: null,
            right: null,
            top: null,
            bottom: null
        });
        this._baseboint = null;
        this.plot_view.push_state('box_select', {
            selection: this.plot_view.get_selection()
        });
        return null;
    };
    BoxSelectToolView.prototype._select = function (arg, arg1, final, append) {
        var ds, geometry, i, len, r, ref, sm, vx0, vx1, vy0, vy1;
        vx0 = arg[0], vx1 = arg[1];
        vy0 = arg1[0], vy1 = arg1[1];
        if (append == null) {
            append = false;
        }
        geometry = {
            type: 'rect',
            vx0: vx0,
            vx1: vx1,
            vy0: vy0,
            vy1: vy1
        };
        ref = this.model.computed_renderers;
        for (i = 0, len = ref.length; i < len; i++) {
            r = ref[i];
            ds = r.data_source;
            sm = ds.selection_manager;
            sm.select(this, this.plot_view.renderer_views[r.id], geometry, final, append);
        }
        if (this.model.callback != null) {
            this._emit_callback(geometry);
        }
        this._save_geometry(geometry, final, append);
        return null;
    };
    BoxSelectToolView.prototype._emit_callback = function (geometry) {
        var canvas, frame, r, xmapper, ymapper;
        r = this.model.computed_renderers[0];
        canvas = this.plot_model.canvas;
        frame = this.plot_model.frame;
        geometry['sx0'] = canvas.vx_to_sx(geometry.vx0);
        geometry['sx1'] = canvas.vx_to_sx(geometry.vx1);
        geometry['sy0'] = canvas.vy_to_sy(geometry.vy0);
        geometry['sy1'] = canvas.vy_to_sy(geometry.vy1);
        xmapper = frame.x_mappers[r.x_range_name];
        ymapper = frame.y_mappers[r.y_range_name];
        geometry['x0'] = xmapper.map_from_target(geometry.vx0);
        geometry['x1'] = xmapper.map_from_target(geometry.vx1);
        geometry['y0'] = ymapper.map_from_target(geometry.vy0);
        geometry['y1'] = ymapper.map_from_target(geometry.vy1);
        this.model.callback.execute(this.model, {
            geometry: geometry
        });
    };
    return BoxSelectToolView;
})(select_tool_1.SelectToolView);
DEFAULT_BOX_OVERLAY = function () {
    return new box_annotation_1.BoxAnnotation({
        level: "overlay",
        render_mode: "css",
        top_units: "screen",
        left_units: "screen",
        bottom_units: "screen",
        right_units: "screen",
        fill_color: "lightgrey",
        fill_alpha: 0.5,
        line_color: "black",
        line_alpha: 1.0,
        line_width: 2,
        line_dash: [4, 4]
    });
};
exports.BoxSelectTool = (function (superClass) {
    extend(BoxSelectTool, superClass);
    function BoxSelectTool() {
        return BoxSelectTool.__super__.constructor.apply(this, arguments);
    }
    BoxSelectTool.prototype.default_view = exports.BoxSelectToolView;
    BoxSelectTool.prototype.type = "BoxSelectTool";
    BoxSelectTool.prototype.tool_name = "Box Select";
    BoxSelectTool.prototype.icon = "bk-tool-icon-box-select";
    BoxSelectTool.prototype.event_type = "pan";
    BoxSelectTool.prototype.default_order = 30;
    BoxSelectTool.define({
        dimensions: [p.Dimensions, "both"],
        select_every_mousemove: [p.Bool, false],
        callback: [p.Instance],
        overlay: [p.Instance, DEFAULT_BOX_OVERLAY]
    });
    BoxSelectTool.getters({
        tooltip: function () {
            return this._get_dim_tooltip(this.tool_name, this.dimensions);
        }
    });
    return BoxSelectTool;
})(select_tool_1.SelectTool);

},{"../../annotations/box_annotation":"models/annotations/box_annotation","./select_tool":"models/tools/gestures/select_tool","core/properties":"core/properties"}],"models/tools/gestures/box_zoom_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var DEFAULT_BOX_OVERLAY, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var gesture_tool_1 = require("./gesture_tool");
var box_annotation_1 = require("../../annotations/box_annotation");
var p = require("core/properties");
exports.BoxZoomToolView = (function (superClass) {
    extend(BoxZoomToolView, superClass);
    function BoxZoomToolView() {
        return BoxZoomToolView.__super__.constructor.apply(this, arguments);
    }
    BoxZoomToolView.prototype._match_aspect = function (basepoint, curpoint, frame) {
        var a, bottom, h, hend, hstart, left, ref, ref1, right, top, va, vend, vh, vstart, vw, w, xmod, ymod;
        hend = frame.h_range.end;
        hstart = frame.h_range.start;
        vend = frame.v_range.end;
        vstart = frame.v_range.start;
        w = hend - hstart;
        h = vend - vstart;
        a = w / h;
        vw = Math.abs(basepoint[0] - curpoint[0]);
        vh = Math.abs(basepoint[1] - curpoint[1]);
        if (vh === 0) {
            va = 0;
        }
        else {
            va = vw / vh;
        }
        if (va >= a) {
            ref = [1, va / a], xmod = ref[0], ymod = ref[1];
        }
        else {
            ref1 = [a / va, 1], xmod = ref1[0], ymod = ref1[1];
        }
        if (basepoint[0] <= curpoint[0]) {
            left = basepoint[0];
            right = basepoint[0] + vw * xmod;
            if (right > hend) {
                right = hend;
            }
        }
        else {
            right = basepoint[0];
            left = basepoint[0] - vw * xmod;
            if (left < hstart) {
                left = hstart;
            }
        }
        vw = Math.abs(right - left);
        if (basepoint[1] <= curpoint[1]) {
            bottom = basepoint[1];
            top = basepoint[1] + vw / a;
            if (top > vend) {
                top = vend;
            }
        }
        else {
            top = basepoint[1];
            bottom = basepoint[1] - vw / a;
            if (bottom < vstart) {
                bottom = vstart;
            }
        }
        vh = Math.abs(top - bottom);
        if (basepoint[0] <= curpoint[0]) {
            right = basepoint[0] + a * vh;
        }
        else {
            left = basepoint[0] - a * vh;
        }
        return [[left, right], [bottom, top]];
    };
    BoxZoomToolView.prototype._pan_start = function (e) {
        var canvas;
        canvas = this.plot_view.canvas;
        this._baseboint = [canvas.sx_to_vx(e.bokeh.sx), canvas.sy_to_vy(e.bokeh.sy)];
        return null;
    };
    BoxZoomToolView.prototype._pan = function (e) {
        var canvas, curpoint, dims, frame, ref, ref1, vx, vy;
        canvas = this.plot_view.canvas;
        curpoint = [canvas.sx_to_vx(e.bokeh.sx), canvas.sy_to_vy(e.bokeh.sy)];
        frame = this.plot_model.frame;
        dims = this.model.dimensions;
        if (this.model.match_aspect && dims === 'both') {
            ref = this._match_aspect(this._baseboint, curpoint, frame), vx = ref[0], vy = ref[1];
        }
        else {
            ref1 = this.model._get_dim_limits(this._baseboint, curpoint, frame, dims), vx = ref1[0], vy = ref1[1];
        }
        this.model.overlay.update({
            left: vx[0],
            right: vx[1],
            top: vy[1],
            bottom: vy[0]
        });
        return null;
    };
    BoxZoomToolView.prototype._pan_end = function (e) {
        var canvas, curpoint, dims, frame, ref, ref1, vx, vy;
        canvas = this.plot_view.canvas;
        curpoint = [canvas.sx_to_vx(e.bokeh.sx), canvas.sy_to_vy(e.bokeh.sy)];
        frame = this.plot_model.frame;
        dims = this.model.dimensions;
        if (this.model.match_aspect && dims === 'both') {
            ref = this._match_aspect(this._baseboint, curpoint, frame), vx = ref[0], vy = ref[1];
        }
        else {
            ref1 = this.model._get_dim_limits(this._baseboint, curpoint, frame, dims), vx = ref1[0], vy = ref1[1];
        }
        this._update(vx, vy);
        this.model.overlay.update({
            left: null,
            right: null,
            top: null,
            bottom: null
        });
        this._baseboint = null;
        return null;
    };
    BoxZoomToolView.prototype._update = function (vx, vy) {
        var end, mapper, name, ref, ref1, ref2, ref3, start, xrs, yrs, zoom_info;
        if (Math.abs(vx[1] - vx[0]) <= 5 || Math.abs(vy[1] - vy[0]) <= 5) {
            return;
        }
        xrs = {};
        ref = this.plot_view.frame.x_mappers;
        for (name in ref) {
            mapper = ref[name];
            ref1 = mapper.v_map_from_target(vx, true), start = ref1[0], end = ref1[1];
            xrs[name] = {
                start: start,
                end: end
            };
        }
        yrs = {};
        ref2 = this.plot_view.frame.y_mappers;
        for (name in ref2) {
            mapper = ref2[name];
            ref3 = mapper.v_map_from_target(vy, true), start = ref3[0], end = ref3[1];
            yrs[name] = {
                start: start,
                end: end
            };
        }
        zoom_info = {
            xrs: xrs,
            yrs: yrs
        };
        this.plot_view.push_state('box_zoom', {
            range: zoom_info
        });
        return this.plot_view.update_range(zoom_info);
    };
    return BoxZoomToolView;
})(gesture_tool_1.GestureToolView);
DEFAULT_BOX_OVERLAY = function () {
    return new box_annotation_1.BoxAnnotation({
        level: "overlay",
        render_mode: "css",
        top_units: "screen",
        left_units: "screen",
        bottom_units: "screen",
        right_units: "screen",
        fill_color: "lightgrey",
        fill_alpha: 0.5,
        line_color: "black",
        line_alpha: 1.0,
        line_width: 2,
        line_dash: [4, 4]
    });
};
exports.BoxZoomTool = (function (superClass) {
    extend(BoxZoomTool, superClass);
    function BoxZoomTool() {
        return BoxZoomTool.__super__.constructor.apply(this, arguments);
    }
    BoxZoomTool.prototype.default_view = exports.BoxZoomToolView;
    BoxZoomTool.prototype.type = "BoxZoomTool";
    BoxZoomTool.prototype.tool_name = "Box Zoom";
    BoxZoomTool.prototype.icon = "bk-tool-icon-box-zoom";
    BoxZoomTool.prototype.event_type = "pan";
    BoxZoomTool.prototype.default_order = 20;
    BoxZoomTool.getters({
        tooltip: function () {
            return this._get_dim_tooltip(this.tool_name, this.dimensions);
        }
    });
    BoxZoomTool.define({
        dimensions: [p.Dimensions, "both"],
        overlay: [p.Instance, DEFAULT_BOX_OVERLAY],
        match_aspect: [p.Bool, false]
    });
    return BoxZoomTool;
})(gesture_tool_1.GestureTool);

},{"../../annotations/box_annotation":"models/annotations/box_annotation","./gesture_tool":"models/tools/gestures/gesture_tool","core/properties":"core/properties"}],"models/tools/gestures/gesture_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var button_tool_1 = require("../button_tool");
exports.GestureToolView = (function (superClass) {
    extend(GestureToolView, superClass);
    function GestureToolView() {
        return GestureToolView.__super__.constructor.apply(this, arguments);
    }
    return GestureToolView;
})(button_tool_1.ButtonToolView);
exports.GestureTool = (function (superClass) {
    extend(GestureTool, superClass);
    function GestureTool() {
        return GestureTool.__super__.constructor.apply(this, arguments);
    }
    GestureTool.prototype.event_type = null;
    GestureTool.prototype.default_order = null;
    return GestureTool;
})(button_tool_1.ButtonTool);

},{"../button_tool":"models/tools/button_tool"}],"models/tools/gestures/lasso_select_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var DEFAULT_POLY_OVERLAY, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var select_tool_1 = require("./select_tool");
var poly_annotation_1 = require("../../annotations/poly_annotation");
var p = require("core/properties");
exports.LassoSelectToolView = (function (superClass) {
    extend(LassoSelectToolView, superClass);
    function LassoSelectToolView() {
        return LassoSelectToolView.__super__.constructor.apply(this, arguments);
    }
    LassoSelectToolView.prototype.initialize = function (options) {
        LassoSelectToolView.__super__.initialize.call(this, options);
        this.listenTo(this.model, 'change:active', this._active_change);
        return this.data = null;
    };
    LassoSelectToolView.prototype._active_change = function () {
        if (!this.model.active) {
            return this._clear_overlay();
        }
    };
    LassoSelectToolView.prototype._keyup = function (e) {
        if (e.keyCode === 13) {
            return this._clear_overlay();
        }
    };
    LassoSelectToolView.prototype._pan_start = function (e) {
        var canvas, vx, vy;
        canvas = this.plot_view.canvas;
        vx = canvas.sx_to_vx(e.bokeh.sx);
        vy = canvas.sy_to_vy(e.bokeh.sy);
        this.data = {
            vx: [vx],
            vy: [vy]
        };
        return null;
    };
    LassoSelectToolView.prototype._pan = function (e) {
        var append, canvas, h_range, overlay, ref, v_range, vx, vy;
        canvas = this.plot_view.canvas;
        vx = canvas.sx_to_vx(e.bokeh.sx);
        vy = canvas.sy_to_vy(e.bokeh.sy);
        h_range = this.plot_model.frame.h_range;
        v_range = this.plot_model.frame.v_range;
        if (vx > h_range.end) {
            vx = h_range.end;
        }
        if (vx < h_range.start) {
            vx = h_range.start;
        }
        if (vy > v_range.end) {
            vy = v_range.end;
        }
        if (vy < v_range.start) {
            vy = v_range.start;
        }
        this.data.vx.push(vx);
        this.data.vy.push(vy);
        overlay = this.model.overlay;
        overlay.update({
            xs: this.data.vx,
            ys: this.data.vy
        });
        if (this.model.select_every_mousemove) {
            append = (ref = e.srcEvent.shiftKey) != null ? ref : false;
            return this._select(this.data.vx, this.data.vy, false, append);
        }
    };
    LassoSelectToolView.prototype._pan_end = function (e) {
        var append, ref;
        this._clear_overlay();
        append = (ref = e.srcEvent.shiftKey) != null ? ref : false;
        this._select(this.data.vx, this.data.vy, true, append);
        return this.plot_view.push_state('lasso_select', {
            selection: this.plot_view.get_selection()
        });
    };
    LassoSelectToolView.prototype._clear_overlay = function () {
        return this.model.overlay.update({
            xs: [],
            ys: []
        });
    };
    LassoSelectToolView.prototype._select = function (vx, vy, final, append) {
        var ds, geometry, i, len, r, ref, sm;
        geometry = {
            type: 'poly',
            vx: vx,
            vy: vy
        };
        ref = this.model.computed_renderers;
        for (i = 0, len = ref.length; i < len; i++) {
            r = ref[i];
            ds = r.data_source;
            sm = ds.selection_manager;
            sm.select(this, this.plot_view.renderer_views[r.id], geometry, final, append);
        }
        if (this.model.callback != null) {
            this._emit_callback(geometry);
        }
        this._save_geometry(geometry, final, append);
        return null;
    };
    LassoSelectToolView.prototype._emit_callback = function (geometry) {
        var canvas, frame, r, xmapper, ymapper;
        r = this.model.computed_renderers[0];
        canvas = this.plot_model.canvas;
        frame = this.plot_model.frame;
        geometry['sx'] = canvas.v_vx_to_sx(geometry.vx);
        geometry['sy'] = canvas.v_vy_to_sy(geometry.vy);
        xmapper = frame.x_mappers[r.x_range_name];
        ymapper = frame.y_mappers[r.y_range_name];
        geometry['x'] = xmapper.v_map_from_target(geometry.vx);
        geometry['y'] = ymapper.v_map_from_target(geometry.vy);
        this.model.callback.execute(this.model, {
            geometry: geometry
        });
    };
    return LassoSelectToolView;
})(select_tool_1.SelectToolView);
DEFAULT_POLY_OVERLAY = function () {
    return new poly_annotation_1.PolyAnnotation({
        level: "overlay",
        xs_units: "screen",
        ys_units: "screen",
        fill_color: "lightgrey",
        fill_alpha: 0.5,
        line_color: "black",
        line_alpha: 1.0,
        line_width: 2,
        line_dash: [4, 4]
    });
};
exports.LassoSelectTool = (function (superClass) {
    extend(LassoSelectTool, superClass);
    function LassoSelectTool() {
        return LassoSelectTool.__super__.constructor.apply(this, arguments);
    }
    LassoSelectTool.prototype.default_view = exports.LassoSelectToolView;
    LassoSelectTool.prototype.type = "LassoSelectTool";
    LassoSelectTool.prototype.tool_name = "Lasso Select";
    LassoSelectTool.prototype.icon = "bk-tool-icon-lasso-select";
    LassoSelectTool.prototype.event_type = "pan";
    LassoSelectTool.prototype.default_order = 12;
    LassoSelectTool.define({
        select_every_mousemove: [p.Bool, true],
        callback: [p.Instance],
        overlay: [p.Instance, DEFAULT_POLY_OVERLAY]
    });
    return LassoSelectTool;
})(select_tool_1.SelectTool);

},{"../../annotations/poly_annotation":"models/annotations/poly_annotation","./select_tool":"models/tools/gestures/select_tool","core/properties":"core/properties"}],"models/tools/gestures/pan_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var gesture_tool_1 = require("./gesture_tool");
var p = require("core/properties");
exports.PanToolView = (function (superClass) {
    extend(PanToolView, superClass);
    function PanToolView() {
        return PanToolView.__super__.constructor.apply(this, arguments);
    }
    PanToolView.prototype._pan_start = function (e) {
        var canvas, frame, hr, vr, vx, vy;
        this.last_dx = 0;
        this.last_dy = 0;
        canvas = this.plot_view.canvas;
        frame = this.plot_view.frame;
        vx = canvas.sx_to_vx(e.bokeh.sx);
        vy = canvas.sy_to_vy(e.bokeh.sy);
        if (!frame.contains(vx, vy)) {
            hr = frame.h_range;
            vr = frame.v_range;
            if (vx < hr.start || vx > hr.end) {
                this.v_axis_only = true;
            }
            if (vy < vr.start || vy > vr.end) {
                this.h_axis_only = true;
            }
        }
        return this.plot_view.interactive_timestamp = Date.now();
    };
    PanToolView.prototype._pan = function (e) {
        this._update(e.deltaX, -e.deltaY);
        return this.plot_view.interactive_timestamp = Date.now();
    };
    PanToolView.prototype._pan_end = function (e) {
        this.h_axis_only = false;
        this.v_axis_only = false;
        if (this.pan_info != null) {
            return this.plot_view.push_state('pan', {
                range: this.pan_info
            });
        }
    };
    PanToolView.prototype._update = function (dx, dy) {
        var dims, end, frame, hr, is_panning, mapper, name, new_dx, new_dy, ref, ref1, ref2, ref3, sdx, sdy, start, sx0, sx1, sx_high, sx_low, sy0, sy1, sy_high, sy_low, vr, xrs, yrs;
        frame = this.plot_view.frame;
        new_dx = dx - this.last_dx;
        new_dy = dy - this.last_dy;
        hr = frame.h_range;
        sx_low = hr.start - new_dx;
        sx_high = hr.end - new_dx;
        vr = frame.v_range;
        sy_low = vr.start - new_dy;
        sy_high = vr.end - new_dy;
        dims = this.model.dimensions;
        if ((dims === 'width' || dims === 'both') && !this.v_axis_only) {
            sx0 = sx_low;
            sx1 = sx_high;
            sdx = -new_dx;
        }
        else {
            sx0 = hr.start;
            sx1 = hr.end;
            sdx = 0;
        }
        if ((dims === 'height' || dims === 'both') && !this.h_axis_only) {
            sy0 = sy_low;
            sy1 = sy_high;
            sdy = new_dy;
        }
        else {
            sy0 = vr.start;
            sy1 = vr.end;
            sdy = 0;
        }
        this.last_dx = dx;
        this.last_dy = dy;
        xrs = {};
        ref = frame.x_mappers;
        for (name in ref) {
            mapper = ref[name];
            ref1 = mapper.v_map_from_target([sx0, sx1], true), start = ref1[0], end = ref1[1];
            xrs[name] = {
                start: start,
                end: end
            };
        }
        yrs = {};
        ref2 = frame.y_mappers;
        for (name in ref2) {
            mapper = ref2[name];
            ref3 = mapper.v_map_from_target([sy0, sy1], true), start = ref3[0], end = ref3[1];
            yrs[name] = {
                start: start,
                end: end
            };
        }
        this.pan_info = {
            xrs: xrs,
            yrs: yrs,
            sdx: sdx,
            sdy: sdy
        };
        this.plot_view.update_range(this.pan_info, is_panning = true);
        return null;
    };
    return PanToolView;
})(gesture_tool_1.GestureToolView);
exports.PanTool = (function (superClass) {
    extend(PanTool, superClass);
    function PanTool() {
        return PanTool.__super__.constructor.apply(this, arguments);
    }
    PanTool.prototype.default_view = exports.PanToolView;
    PanTool.prototype.type = "PanTool";
    PanTool.prototype.tool_name = "Pan";
    PanTool.prototype.event_type = "pan";
    PanTool.prototype.default_order = 10;
    PanTool.define({
        dimensions: [p.Dimensions, "both"]
    });
    PanTool.getters({
        tooltip: function () {
            return this._get_dim_tooltip("Pan", this.dimensions);
        },
        icon: function () {
            var suffix;
            suffix = (function () {
                switch (this.dimensions) {
                    case "both":
                        return "pan";
                    case "width":
                        return "xpan";
                    case "height":
                        return "ypan";
                }
            }).call(this);
            return "bk-tool-icon-" + suffix;
        }
    });
    return PanTool;
})(gesture_tool_1.GestureTool);

},{"./gesture_tool":"models/tools/gestures/gesture_tool","core/properties":"core/properties"}],"models/tools/gestures/poly_select_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var DEFAULT_POLY_OVERLAY, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var select_tool_1 = require("./select_tool");
var poly_annotation_1 = require("../../annotations/poly_annotation");
var p = require("core/properties");
var array_1 = require("core/util/array");
exports.PolySelectToolView = (function (superClass) {
    extend(PolySelectToolView, superClass);
    function PolySelectToolView() {
        return PolySelectToolView.__super__.constructor.apply(this, arguments);
    }
    PolySelectToolView.prototype.initialize = function (options) {
        PolySelectToolView.__super__.initialize.call(this, options);
        this.listenTo(this.model, 'change:active', this._active_change);
        return this.data = {
            vx: [],
            vy: []
        };
    };
    PolySelectToolView.prototype._active_change = function () {
        if (!this.model.active) {
            return this._clear_data();
        }
    };
    PolySelectToolView.prototype._keyup = function (e) {
        if (e.keyCode === 13) {
            return this._clear_data();
        }
    };
    PolySelectToolView.prototype._doubletap = function (e) {
        var append, ref;
        append = (ref = e.srcEvent.shiftKey) != null ? ref : false;
        this._select(this.data.vx, this.data.vy, true, append);
        return this._clear_data();
    };
    PolySelectToolView.prototype._clear_data = function () {
        this.data = {
            vx: [],
            vy: []
        };
        return this.model.overlay.update({
            xs: [],
            ys: []
        });
    };
    PolySelectToolView.prototype._tap = function (e) {
        var canvas, vx, vy;
        canvas = this.plot_view.canvas;
        vx = canvas.sx_to_vx(e.bokeh.sx);
        vy = canvas.sy_to_vy(e.bokeh.sy);
        this.data.vx.push(vx);
        this.data.vy.push(vy);
        return this.model.overlay.update({
            xs: array_1.copy(this.data.vx),
            ys: array_1.copy(this.data.vy)
        });
    };
    PolySelectToolView.prototype._select = function (vx, vy, final, append) {
        var ds, geometry, i, len, r, ref, sm;
        geometry = {
            type: 'poly',
            vx: vx,
            vy: vy
        };
        ref = this.model.computed_renderers;
        for (i = 0, len = ref.length; i < len; i++) {
            r = ref[i];
            ds = r.data_source;
            sm = ds.selection_manager;
            sm.select(this, this.plot_view.renderer_views[r.id], geometry, final, append);
        }
        this._save_geometry(geometry, final, append);
        this.plot_view.push_state('poly_select', {
            selection: this.plot_view.get_selection()
        });
        return null;
    };
    return PolySelectToolView;
})(select_tool_1.SelectToolView);
DEFAULT_POLY_OVERLAY = function () {
    return new poly_annotation_1.PolyAnnotation({
        level: "overlay",
        xs_units: "screen",
        ys_units: "screen",
        fill_color: "lightgrey",
        fill_alpha: 0.5,
        line_color: "black",
        line_alpha: 1.0,
        line_width: 2,
        line_dash: [4, 4]
    });
};
exports.PolySelectTool = (function (superClass) {
    extend(PolySelectTool, superClass);
    function PolySelectTool() {
        return PolySelectTool.__super__.constructor.apply(this, arguments);
    }
    PolySelectTool.prototype.default_view = exports.PolySelectToolView;
    PolySelectTool.prototype.type = "PolySelectTool";
    PolySelectTool.prototype.tool_name = "Poly Select";
    PolySelectTool.prototype.icon = "bk-tool-icon-polygon-select";
    PolySelectTool.prototype.event_type = "tap";
    PolySelectTool.prototype.default_order = 11;
    PolySelectTool.define({
        overlay: [p.Instance, DEFAULT_POLY_OVERLAY]
    });
    return PolySelectTool;
})(select_tool_1.SelectTool);

},{"../../annotations/poly_annotation":"models/annotations/poly_annotation","./select_tool":"models/tools/gestures/select_tool","core/properties":"core/properties","core/util/array":"core/util/array"}],"models/tools/gestures/resize_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var gesture_tool_1 = require("./gesture_tool");
var dom_1 = require("core/dom");
exports.ResizeToolView = (function (superClass) {
    extend(ResizeToolView, superClass);
    function ResizeToolView() {
        return ResizeToolView.__super__.constructor.apply(this, arguments);
    }
    ResizeToolView.prototype.className = "bk-resize-popup";
    ResizeToolView.prototype.initialize = function (options) {
        var wrapper;
        ResizeToolView.__super__.initialize.call(this, options);
        wrapper = this.plot_view.el.querySelector('div.bk-canvas-wrapper');
        wrapper.appendChild(this.el);
        dom_1.hide(this.el);
        this.active = false;
        return null;
    };
    ResizeToolView.prototype.activate = function () {
        this.active = true;
        this.render();
        return null;
    };
    ResizeToolView.prototype.deactivate = function () {
        this.active = false;
        this.render();
        return null;
    };
    ResizeToolView.prototype.render = function (ctx) {
        var canvas, frame, left, top;
        if (this.active) {
            canvas = this.plot_view.canvas;
            frame = this.plot_view.frame;
            left = canvas.vx_to_sx(frame.h_range.end - 40);
            top = canvas.vy_to_sy(frame.v_range.start + 40);
            this.el.style.position = "absolute";
            this.el.style.top = top + "px";
            this.el.style.left = left + "px";
            dom_1.show(this.el);
        }
        else {
            dom_1.hide(this.el);
        }
        return this;
    };
    ResizeToolView.prototype._pan_start = function (e) {
        var canvas;
        canvas = this.plot_view.canvas;
        this.ch = canvas.height;
        this.cw = canvas.width;
        this.plot_view.interactive_timestamp = Date.now();
        return null;
    };
    ResizeToolView.prototype._pan = function (e) {
        this._update(e.deltaX, e.deltaY);
        this.plot_view.interactive_timestamp = Date.now();
        return null;
    };
    ResizeToolView.prototype._pan_end = function (e) {
        return this.plot_view.push_state("resize", {
            dimensions: {
                width: this.plot_view.canvas.width,
                height: this.plot_view.canvas.height
            }
        });
    };
    ResizeToolView.prototype._update = function (dx, dy) {
        var new_height, new_width;
        new_width = this.cw + dx;
        new_height = this.ch + dy;
        if (new_width < 100 || new_height < 100) {
            return;
        }
        this.plot_view.update_dimensions(new_width, new_height);
    };
    return ResizeToolView;
})(gesture_tool_1.GestureToolView);
exports.ResizeTool = (function (superClass) {
    extend(ResizeTool, superClass);
    function ResizeTool() {
        return ResizeTool.__super__.constructor.apply(this, arguments);
    }
    ResizeTool.prototype.default_view = exports.ResizeToolView;
    ResizeTool.prototype.type = "ResizeTool";
    ResizeTool.prototype.tool_name = "Resize";
    ResizeTool.prototype.icon = "bk-tool-icon-resize";
    ResizeTool.prototype.event_type = "pan";
    ResizeTool.prototype.default_order = 40;
    return ResizeTool;
})(gesture_tool_1.GestureTool);

},{"./gesture_tool":"models/tools/gestures/gesture_tool","core/dom":"core/dom"}],"models/tools/gestures/select_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var gesture_tool_1 = require("./gesture_tool");
var glyph_renderer_1 = require("../../renderers/glyph_renderer");
var logging_1 = require("core/logging");
var p = require("core/properties");
var object_1 = require("core/util/object");
exports.SelectToolView = (function (superClass) {
    extend(SelectToolView, superClass);
    function SelectToolView() {
        return SelectToolView.__super__.constructor.apply(this, arguments);
    }
    SelectToolView.prototype._keyup = function (e) {
        var ds, j, len, r, ref, results, sm;
        if (e.keyCode === 27) {
            ref = this.model.computed_renderers;
            results = [];
            for (j = 0, len = ref.length; j < len; j++) {
                r = ref[j];
                ds = r.data_source;
                sm = ds.selection_manager;
                results.push(sm.clear());
            }
            return results;
        }
    };
    SelectToolView.prototype._save_geometry = function (geometry, final, append) {
        var g, geoms, i, j, ref, tool_events, xm, ym;
        g = object_1.clone(geometry);
        xm = this.plot_view.frame.x_mappers['default'];
        ym = this.plot_view.frame.y_mappers['default'];
        switch (g.type) {
            case 'point':
                g.x = xm.map_from_target(g.vx);
                g.y = ym.map_from_target(g.vy);
                break;
            case 'rect':
                g.x0 = xm.map_from_target(g.vx0);
                g.y0 = ym.map_from_target(g.vy0);
                g.x1 = xm.map_from_target(g.vx1);
                g.y1 = ym.map_from_target(g.vy1);
                break;
            case 'poly':
                g.x = new Array(g.vx.length);
                g.y = new Array(g.vy.length);
                for (i = j = 0, ref = g.vx.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                    g.x[i] = xm.map_from_target(g.vx[i]);
                    g.y[i] = ym.map_from_target(g.vy[i]);
                }
                break;
            default:
                logging_1.logger.debug("Unrecognized selection geometry type: '" + g.type + "'");
        }
        if (final) {
            tool_events = this.plot_model.plot.tool_events;
            if (append) {
                geoms = tool_events.geometries;
                geoms.push(g);
            }
            else {
                geoms = [g];
            }
            tool_events.geometries = geoms;
        }
        return null;
    };
    return SelectToolView;
})(gesture_tool_1.GestureToolView);
exports.SelectTool = (function (superClass) {
    extend(SelectTool, superClass);
    function SelectTool() {
        return SelectTool.__super__.constructor.apply(this, arguments);
    }
    SelectTool.define({
        renderers: [p.Array, []],
        names: [p.Array, []]
    });
    SelectTool.internal({
        multi_select_modifier: [p.String, "shift"]
    });
    SelectTool.prototype.initialize = function (attrs, options) {
        SelectTool.__super__.initialize.call(this, attrs, options);
        this.define_computed_property('computed_renderers', function () {
            var all_renderers, names, r, renderers;
            renderers = this.renderers;
            names = this.names;
            if (renderers.length === 0) {
                all_renderers = this.plot.renderers;
                renderers = (function () {
                    var j, len, results;
                    results = [];
                    for (j = 0, len = all_renderers.length; j < len; j++) {
                        r = all_renderers[j];
                        if (r instanceof glyph_renderer_1.GlyphRenderer) {
                            results.push(r);
                        }
                    }
                    return results;
                })();
            }
            if (names.length > 0) {
                renderers = (function () {
                    var j, len, results;
                    results = [];
                    for (j = 0, len = renderers.length; j < len; j++) {
                        r = renderers[j];
                        if (names.indexOf(r.name) >= 0) {
                            results.push(r);
                        }
                    }
                    return results;
                })();
            }
            return renderers;
        }, true);
        this.add_dependencies('computed_renderers', this, ['renderers', 'names', 'plot']);
        return this.add_dependencies('computed_renderers', this.plot, ['renderers']);
    };
    SelectTool.getters({
        computed_renderers: function () {
            return this._get_computed('computed_renderers');
        }
    });
    return SelectTool;
})(gesture_tool_1.GestureTool);

},{"../../renderers/glyph_renderer":"models/renderers/glyph_renderer","./gesture_tool":"models/tools/gestures/gesture_tool","core/logging":"core/logging","core/properties":"core/properties","core/util/object":"core/util/object"}],"models/tools/gestures/tap_tool":[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var select_tool_1 = require("./select_tool");
var p = require("core/properties");
var types_1 = require("core/util/types");
exports.TapToolView = (function (superClass) {
    extend(TapToolView, superClass);
    function TapToolView() {
        return TapToolView.__super__.constructor.apply(this, arguments);
    }
    TapToolView.prototype._tap = function (e) {
        var append, canvas, ref, vx, vy;
        canvas = this.plot_view.canvas;
        vx = canvas.sx_to_vx(e.bokeh.sx);
        vy = canvas.sy_to_vy(e.bokeh.sy);
        append = (ref = e.srcEvent.shiftKey) != null ? ref : false;
        return this._select(vx, vy, true, append);
    };
    TapToolView.prototype._select = function (vx, vy, final, append) {
        var callback, cb_data, did_hit, ds, geometry, i, len, r, ref, sm, view;
        geometry = {
            type: 'point',
            vx: vx,
            vy: vy
        };
        callback = this.model.callback;
        this._save_geometry(geometry, final, append);
        cb_data = {
            geometries: this.plot_model.plot.tool_events.geometries
        };
 