!function(){var t=void 0;return function(t,e,n){if(null==Bokeh)throw new Error("Cannot find Bokeh. You have to load it prior to loading plugins.");for(var a in t)Bokeh.require.modules[a]=t[a];for(var s=0;s<n.length;s++){var o=Bokeh.require(n[0]);Bokeh.Models.register_models(o.models);for(var a in o)"models"!==a&&(Bokeh[a]=o[a])}}({"models/glyphs/webgl/base":[function(t,e,n){"use strict";Object.defineProperty(n,"__esModule",{value:!0});var a=t("core/util/color");n.BaseGLGlyph=function(){function t(t,e){this.gl=t,this.glyph=e,this.nvertices=0,this.size_changed=!1,this.data_changed=!1,this.visuals_changed=!1,this.init()}return t.prototype.GLYPH="",t.prototype.VERT="",t.prototype.FRAG="",t.prototype.set_data_changed=function(t){return t!==this.nvertices&&(this.nvertices=t,this.size_changed=!0),this.data_changed=!0},t.prototype.set_visuals_changed=function(){return this.visuals_changed=!0},t.prototype.render=function(t,e,n){var a,s,o,r,i,l,_,h,c,u;return c=u=1,o=this.glyph.renderer.map_to_screen([0*c,1*c,2*c],[0*u,1*u,2*u]),a=o[0],s=o[1],c=100/Math.min(Math.max(Math.abs(a[1]-a[0]),1e-12),1e12),u=100/Math.min(Math.max(Math.abs(s[1]-s[0]),1e-12),1e12),r=this.glyph.renderer.map_to_screen([0*c,1*c,2*c],[0*u,1*u,2*u]),a=r[0],s=r[1],!(Math.abs(a[1]-a[0]-(a[2]-a[1]))>1e-6||Math.abs(s[1]-s[0]-(s[2]-s[1]))>1e-6)&&(i=[(a[1]-a[0])/c,(s[1]-s[0])/u],l=i[0],_=i[1],h={pixel_ratio:t.pixel_ratio,width:t.glcanvas.width,height:t.glcanvas.height,dx:a[0]/l,dy:s[0]/_,sx:l,sy:_},this.draw(e,n,h),!0)},t}(),n.line_width=function(t){return t<2&&(t=Math.sqrt(2*t)),t},n.fill_array_with_float=function(t,e){var n,a,s,o;for(n=new Float32Array(t),a=s=0,o=t;0<=o?s<o:s>o;a=0<=o?++s:--s)n[a]=e;return n},n.fill_array_with_vec=function(t,e,n){var a,s,o,r,i,l,_;for(a=new Float32Array(t*e),s=r=0,l=t;0<=l?r<l:r>l;s=0<=l?++r:--r)for(o=i=0,_=e;0<=_?i<_:i>_;o=0<=_?++i:--i)a[s*e+o]=n[o];return a},n.visual_prop_is_singular=function(t,e){return void 0!==t[e].spec.value},n.attach_float=function(t,e,a,s,o,r){var i;return o.doit?n.visual_prop_is_singular(o,r)?(e.used=!1,t.set_attribute(a,"float",o[r].value())):(e.used=!0,i=new Float32Array(o.cache[r+"_array"]),e.set_size(4*s),e.set_data(0,i),t.set_attribute(a,"float",e)):(e.used=!1,t.set_attribute(a,"float",[0]))},n.attach_color=function(t,e,s,o,r,i){var l,_,h,c,u,f,d,p,g,v,y,m,x;if(v=4,c=i+"_color",_=i+"_alpha",r.doit){if(n.visual_prop_is_singular(r,c)&&n.visual_prop_is_singular(r,_))return e.used=!1,x=a.color2rgba(r[c].value(),r[_].value()),t.set_attribute(s,"vec4",x);for(e.used=!0,u=n.visual_prop_is_singular(r,c)?function(){var t,e,n;for(n=[],f=t=0,e=o;0<=e?t<e:t>e;f=0<=e?++t:--t)n.push(r[c].value());return n}():r.cache[c+"_array"],h=n.visual_prop_is_singular(r,_)?n.fill_array_with_float(o,r[_].value()):r.cache[_+"_array"],l=new Float32Array(o*v),f=p=0,y=o;0<=y?p<y:p>y;f=0<=y?++p:--p)for(x=a.color2rgba(u[f],h[f]),d=g=0,m=v;0<=m?g<m:g>m;d=0<=m?++g:--g)l[f*v+d]=x[d];return e.set_size(o*v*4),e.set_data(0,l),t.set_attribute(s,"vec4",e)}return e.used=!1,t.set_attribute(s,"vec4",[0,0,0,0])}},{"core/util/color":void 0}],"models/glyphs/webgl/index":[function(t,e,n){/*
Copyright notice: many of the awesome techniques and  GLSL code contained in
this module are based on work by Nicolas Rougier as part of the Glumpy and
Vispy projects. The algorithms are published in
http://jcgt.org/published/0003/04/01/ and http://jcgt.org/published/0002/02/08/

This module contains all gl-specific code to add gl support for the glyphs.
By implementing it separetely, the GL functionality can be spun off in a
separate library.
Other locations where we work with GL, or prepare for GL-rendering:
- canvas.coffee
- plot.coffee
- glyph.coffee
- glyph_renderer.coffee
*/
"use strict";function a(t){for(var e in t)n.hasOwnProperty(e)||(n[e]=t[e])}Object.defineProperty(n,"__esModule",{value:!0}),a(t("./line")),a(t("./markers"))},{"./line":"models/glyphs/webgl/line","./markers":"models/glyphs/webgl/markers"}],"models/glyphs/webgl/line":[function(t,e,n){"use strict";Object.defineProperty(n,"__esModule",{value:!0});var a,s=function(t,e){function n(){this.constructor=t}for(var a in e)o.call(e,a)&&(t[a]=e[a]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},o={}.hasOwnProperty,r=t("gloo2"),i=t("core/util/color"),l=t("./base");a=function(){function t(t){this._atlas={},this._index=0,this._width=256,this._height=256,this.tex=new r.Texture2D(t),this.tex.set_wrapping(t.REPEAT,t.REPEAT),this.tex.set_interpolation(t.NEAREST,t.NEAREST),this.tex.set_size([this._height,this._width],t.RGBA),this.tex.set_data([0,0],[this._height,this._width],new Uint8Array(this._height*this._width*4)),this.get_atlas_data([1])}return t.prototype.get_atlas_data=function(t){var e,n,a,s,o,r;return a=t.join("-"),n=this._atlas[a],void 0===n&&(o=this.make_pattern(t),e=o[0],s=o[1],this.tex.set_data([this._index,0],[1,this._width],new Uint8Array(function(){var t,n,a;for(a=[],t=0,n=e.length;t<n;t++)r=e[t],a.push(r+10);return a}())),this._atlas[a]=[this._index/this._height,s],this._index+=1),this._atlas[a]},t.prototype.make_pattern=function(t){var e,n,a,s,o,r,i,l,_,h,c,u,f,d,p,g,v,y,m,x,b,w,P,A,E;for(t.length>1&&t.length%2&&(t=t.concat(t)),g=0,u=0,f=t.length;u<f;u++)w=t[u],g+=w;for(e=[],o=0,_=p=0,m=t.length+2;p<m;_=p+=2)a=Math.max(1e-4,t[_%t.length]),s=Math.max(1e-4,t[(_+1)%t.length]),e.push.apply(e,[o,o+a]),o+=a+s;for(d=this._width,n=new Float32Array(4*d),_=v=0,x=d;0<=x?v<x:v>x;_=0<=x?++v:--v){for(E=g*_/(d-1),h=0,A=1e16,c=y=0,b=e.length;0<=b?y<b:y>b;c=0<=b?++y:--y)P=Math.abs(e[c]-E),P<A&&(h=c,A=P);h%2===0?(l=E<=e[h]?1:0,i=e[h],r=e[h+1]):(l=E>e[h]?-1:0,i=e[h-1],r=e[h]),n[4*_+0]=e[h],n[4*_+1]=l,n[4*_+2]=i,n[4*_+3]=r}return[n,g]},t}(),n.LineGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="line",e.prototype.JOINS={miter:0,round:1,bevel:2},e.prototype.CAPS={"":0,none:0,".":0,round:1,")":1,"(":1,o:1,"triangle in":2,"<":2,"triangle out":3,">":3,square:4,"[":4,"]":4,"=":4,butt:5,"|":5},e.prototype.VERT="precision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size, u_offset;\nuniform vec2 u_scale_aspect;\nuniform float u_scale_length;\n\nuniform vec4 u_color;\nuniform float u_antialias;\nuniform float u_length;\nuniform float u_linewidth;\nuniform float u_dash_index;\nuniform float u_closed;\n\nattribute vec2 a_position;\nattribute vec4 a_tangents;\nattribute vec2 a_segment;\nattribute vec2 a_angles;\nattribute vec2 a_texcoord;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\nfloat cross(in vec2 v1, in vec2 v2)\n{\n    return v1.x*v2.y - v1.y*v2.x;\n}\n\nfloat signed_distance(in vec2 v1, in vec2 v2, in vec2 v3)\n{\n    return cross(v2-v1,v1-v3) / length(v2-v1);\n}\n\nvoid rotate( in vec2 v, in float alpha, out vec2 result )\n{\n    float c = cos(alpha);\n    float s = sin(alpha);\n    result = vec2( c*v.x - s*v.y,\n                   s*v.x + c*v.y );\n}\n\nvoid main()\n{\n    bool closed = (u_closed > 0.0);\n\n    // Attributes and uniforms to varyings\n    v_color = u_color;\n    v_linewidth = u_linewidth;\n    v_segment = a_segment * u_scale_length;\n    v_length = u_length * u_scale_length;\n\n    // Scale to map to pixel coordinates. The original algorithm from the paper\n    // assumed isotropic scale. We obviously do not have this.\n    vec2 abs_scale_aspect = abs(u_scale_aspect);\n    vec2 abs_scale = u_scale_length * abs_scale_aspect;\n\n    // Correct angles for aspect ratio\n    vec2 av;\n    av = vec2(1.0, tan(a_angles.x)) / abs_scale_aspect;\n    v_angles.x = atan(av.y, av.x);\n    av = vec2(1.0, tan(a_angles.y)) / abs_scale_aspect;\n    v_angles.y = atan(av.y, av.x);\n\n    // Thickness below 1 pixel are represented using a 1 pixel thickness\n    // and a modified alpha\n    v_color.a = min(v_linewidth, v_color.a);\n    v_linewidth = max(v_linewidth, 1.0);\n\n    // If color is fully transparent we just will discard the fragment anyway\n    if( v_color.a <= 0.0 ) {\n        gl_Position = vec4(0.0,0.0,0.0,1.0);\n        return;\n    }\n\n    // This is the actual half width of the line\n    float w = ceil(u_antialias+v_linewidth)/2.0;\n\n    vec2 position = (a_position + u_offset) * abs_scale;\n\n    vec2 t1 = normalize(a_tangents.xy * abs_scale_aspect);  // note the scaling for aspect ratio here\n    vec2 t2 = normalize(a_tangents.zw * abs_scale_aspect);\n    float u = a_texcoord.x;\n    float v = a_texcoord.y;\n    vec2 o1 = vec2( +t1.y, -t1.x);\n    vec2 o2 = vec2( +t2.y, -t2.x);\n\n    // This is a join\n    // ----------------------------------------------------------------\n    if( t1 != t2 ) {\n        float angle = atan (t1.x*t2.y-t1.y*t2.x, t1.x*t2.x+t1.y*t2.y);  // Angle needs recalculation for some reason\n        vec2 t  = normalize(t1+t2);\n        vec2 o  = vec2( + t.y, - t.x);\n\n        if ( u_dash_index > 0.0 )\n        {\n            // Broken angle\n            // ----------------------------------------------------------------\n            if( (abs(angle) > THETA) ) {\n                position += v * w * o / cos(angle/2.0);\n                float s = sign(angle);\n                if( angle < 0.0 ) {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position -= 2.0 * w * t1 / sin(angle);\n                            u -= 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position += 2.0 * w * t2 / sin(angle);\n                            u += 2.0*w / sin(angle);\n                        }\n                    }\n                } else {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position += 2.0 * w * t1 / sin(angle);\n                            u += 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position -= 2.0 * w * t2 / sin(angle);\n                            u -= 2.0*w / sin(angle);\n                        }\n                    }\n                }\n                // Continuous angle\n                // ------------------------------------------------------------\n            } else {\n                position += v * w * o / cos(angle/2.0);\n                if( u == +1.0 ) u = v_segment.y;\n                else            u = v_segment.x;\n            }\n        }\n\n        // Solid line\n        // --------------------------------------------------------------------\n        else\n        {\n            position.xy += v * w * o / cos(angle/2.0);\n            if( angle < 0.0 ) {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            } else {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            }\n        }\n\n    // This is a line start or end (t1 == t2)\n    // ------------------------------------------------------------------------\n    } else {\n        position += v * w * o1;\n        if( u == -1.0 ) {\n            u = v_segment.x - w;\n            position -= w * t1;\n        } else {\n            u = v_segment.y + w;\n            position += w * t2;\n        }\n    }\n\n    // Miter distance\n    // ------------------------------------------------------------------------\n    vec2 t;\n    vec2 curr = a_position * abs_scale;\n    if( a_texcoord.x < 0.0 ) {\n        vec2 next = curr + t2*(v_segment.y-v_segment.x);\n\n        rotate( t1, +v_angles.x/2.0, t);\n        v_miter.x = signed_distance(curr, curr+t, position);\n\n        rotate( t2, +v_angles.y/2.0, t);\n        v_miter.y = signed_distance(next, next+t, position);\n    } else {\n        vec2 prev = curr - t1*(v_segment.y-v_segment.x);\n\n        rotate( t1, -v_angles.x/2.0,t);\n        v_miter.x = signed_distance(prev, prev+t, position);\n\n        rotate( t2, -v_angles.y/2.0,t);\n        v_miter.y = signed_distance(curr, curr+t, position);\n    }\n\n    if (!closed && v_segment.x <= 0.0) {\n        v_miter.x = 1e10;\n    }\n    if (!closed && v_segment.y >= v_length)\n    {\n        v_miter.y = 1e10;\n    }\n\n    v_texcoord = vec2( u, v*w );\n\n    // Calculate position in device coordinates. Note that we\n    // already scaled with abs scale above.\n    vec2 normpos = position * sign(u_scale_aspect);\n    normpos += 0.5;  // make up for Bokeh's offset\n    normpos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(normpos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n}\n",e.prototype.FRAG_="// Fragment shader that can be convenient during debugging to show the line skeleton.\nprecision mediump float;\nuniform vec4  u_color;\nvoid main () {\n  gl_FragColor = u_color;\n}",e.prototype.FRAG="precision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform sampler2D u_dash_atlas;\n\nuniform vec2 u_linecaps;\nuniform float u_miter_limit;\nuniform float u_linejoin;\nuniform float u_antialias;\nuniform float u_dash_phase;\nuniform float u_dash_period;\nuniform float u_dash_index;\nuniform vec2 u_dash_caps;\nuniform float u_closed;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\n// Compute distance to cap ----------------------------------------------------\nfloat cap( int type, float dx, float dy, float t, float linewidth )\n{\n    float d = 0.0;\n    dx = abs(dx);\n    dy = abs(dy);\n    if      (type == 0)  discard;  // None\n    else if (type == 1)  d = sqrt(dx*dx+dy*dy);  // Round\n    else if (type == 3)  d = (dx+abs(dy));  // Triangle in\n    else if (type == 2)  d = max(abs(dy),(t+dx-abs(dy)));  // Triangle out\n    else if (type == 4)  d = max(dx,dy);  // Square\n    else if (type == 5)  d = max(dx+t,dy);  // Butt\n    return d;\n}\n\n// Compute distance to join -------------------------------------------------\nfloat join( in int type, in float d, in vec2 segment, in vec2 texcoord, in vec2 miter,\n           in float linewidth )\n{\n    // texcoord.x is distance from start\n    // texcoord.y is distance from centerline\n    // segment.x and y indicate the limits (as for texcoord.x) for this segment\n\n    float dx = texcoord.x;\n\n    // Round join\n    if( type == 1 ) {\n        if (dx < segment.x) {\n            d = max(d,length( texcoord - vec2(segment.x,0.0)));\n            //d = length( texcoord - vec2(segment.x,0.0));\n        } else if (dx > segment.y) {\n            d = max(d,length( texcoord - vec2(segment.y,0.0)));\n            //d = length( texcoord - vec2(segment.y,0.0));\n        }\n    }\n    // Bevel join\n    else if ( type == 2 ) {\n        if (dx < segment.x) {\n            vec2 x = texcoord - vec2(segment.x,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n\n        } else if (dx > segment.y) {\n            vec2 x = texcoord - vec2(segment.y,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n        }\n        /*  Original code for bevel which does not work for us\n        if( (dx < segment.x) ||  (dx > segment.y) )\n            d = max(d, min(abs(x.x),abs(x.y)));\n        */\n    }\n\n    return d;\n}\n\nvoid main()\n{\n    // If color is fully transparent we just discard the fragment\n    if( v_color.a <= 0.0 ) {\n        discard;\n    }\n\n    // Test if dash pattern is the solid one (0)\n    bool solid =  (u_dash_index == 0.0);\n\n    // Test if path is closed\n    bool closed = (u_closed > 0.0);\n\n    vec4 color = v_color;\n    float dx = v_texcoord.x;\n    float dy = v_texcoord.y;\n    float t = v_linewidth/2.0-u_antialias;\n    float width = 1.0;  //v_linewidth; original code had dashes scale with line width, we do not\n    float d = 0.0;\n\n    vec2 linecaps = u_linecaps;\n    vec2 dash_caps = u_dash_caps;\n    float line_start = 0.0;\n    float line_stop = v_length;\n\n    // Apply miter limit; fragments too far into the miter are simply discarded\n    if( (dx < v_segment.x) || (dx > v_segment.y) ) {\n        float into_miter = max(v_segment.x - dx, dx - v_segment.y);\n        if (into_miter > u_miter_limit*v_linewidth/2.0)\n          discard;\n    }\n\n    // Solid line --------------------------------------------------------------\n    if( solid ) {\n        d = abs(dy);\n        if( (!closed) && (dx < line_start) ) {\n            d = cap( int(u_linecaps.x), abs(dx), abs(dy), t, v_linewidth );\n        }\n        else if( (!closed) &&  (dx > line_stop) ) {\n            d = cap( int(u_linecaps.y), abs(dx)-line_stop, abs(dy), t, v_linewidth );\n        }\n        else {\n            d = join( int(u_linejoin), abs(dy), v_segment, v_texcoord, v_miter, v_linewidth );\n        }\n\n    // Dash line --------------------------------------------------------------\n    } else {\n        float segment_start = v_segment.x;\n        float segment_stop  = v_segment.y;\n        float segment_center= (segment_start+segment_stop)/2.0;\n        float freq          = u_dash_period*width;\n        float u = mod( dx + u_dash_phase*width, freq);\n        vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n        float dash_center= tex.x * width;\n        float dash_type  = tex.y;\n        float _start = tex.z * width;\n        float _stop  = tex.a * width;\n        float dash_start = dx - u + _start;\n        float dash_stop  = dx - u + _stop;\n\n        // Compute extents of the first dash (the one relative to v_segment.x)\n        // Note: this could be computed in the vertex shader\n        if( (dash_stop < segment_start) && (dash_caps.x != 5.0) ) {\n            float u = mod(segment_start + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_start - u + _start;\n            dash_stop = segment_start - u + _stop;\n        }\n\n        // Compute extents of the last dash (the one relatives to v_segment.y)\n        // Note: This could be computed in the vertex shader\n        else if( (dash_start > segment_stop)  && (dash_caps.y != 5.0) ) {\n            float u = mod(segment_stop + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_stop - u + _start;\n            dash_stop  = segment_stop - u + _stop;\n        }\n\n        // This test if the we are dealing with a discontinuous angle\n        bool discontinuous = ((dx <  segment_center) && abs(v_angles.x) > THETA) ||\n                             ((dx >= segment_center) && abs(v_angles.y) > THETA);\n        //if( dx < line_start) discontinuous = false;\n        //if( dx > line_stop)  discontinuous = false;\n\n        float d_join = join( int(u_linejoin), abs(dy),\n                            v_segment, v_texcoord, v_miter, v_linewidth );\n\n        // When path is closed, we do not have room for linecaps, so we make room\n        // by shortening the total length\n        if (closed) {\n             line_start += v_linewidth/2.0;\n             line_stop  -= v_linewidth/2.0;\n        }\n\n        // We also need to take antialias area into account\n        //line_start += u_antialias;\n        //line_stop  -= u_antialias;\n\n        // Check is dash stop is before line start\n        if( dash_stop <= line_start ) {\n            discard;\n        }\n        // Check is dash start is beyond line stop\n        if( dash_start >= line_stop ) {\n            discard;\n        }\n\n        // Check if current dash start is beyond segment stop\n        if( discontinuous ) {\n            // Dash start is beyond segment, we discard\n            if( (dash_start > segment_stop) ) {\n                discard;\n                //gl_FragColor = vec4(1.0,0.0,0.0,.25); return;\n            }\n\n            // Dash stop is before segment, we discard\n            if( (dash_stop < segment_start) ) {\n                discard;  //gl_FragColor = vec4(0.0,1.0,0.0,.25); return;\n            }\n\n            // Special case for round caps (nicer with this)\n            if( dash_caps.x == 1.0 ) {\n                if( (u > _stop) && (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for round caps  (nicer with this)\n            if( dash_caps.y == 1.0 ) {\n                if( (u < _start) && (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.x != 1.0) && (dash_caps.x != 5.0) ) {\n                if( (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0) ) {\n                    float a = v_angles.x/2.0;\n                    float x = (segment_start-dx)*cos(a) - dy*sin(a);\n                    float y = (segment_start-dx)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the cap into square to avoid holes\n                    dash_caps.x = 4.0;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.y != 1.0) && (dash_caps.y != 5.0) ) {\n                if( (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0) ) {\n                    float a = v_angles.y/2.0;\n                    float x = (dx-segment_stop)*cos(a) - dy*sin(a);\n                    float y = (dx-segment_stop)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the caps into square to avoid holes\n                    dash_caps.y = 4.0;\n                }\n            }\n        }\n\n        // Line cap at start\n        if( (dx < line_start) && (dash_start < line_start) && (dash_stop > line_start) ) {\n            d = cap( int(linecaps.x), dx-line_start, dy, t, v_linewidth);\n        }\n        // Line cap at stop\n        else if( (dx > line_stop) && (dash_stop > line_stop) && (dash_start < line_stop) ) {\n            d = cap( int(linecaps.y), dx-line_stop, dy, t, v_linewidth);\n        }\n        // Dash cap left - dash_type = -1, 0 or 1, but there may be roundoff errors\n        else if( dash_type < -0.5 ) {\n            d = cap( int(dash_caps.y), abs(u-dash_center), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash cap right\n        else if( dash_type > 0.5 ) {\n            d = cap( int(dash_caps.x), abs(dash_center-u), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash body (plain)\n        else {// if( dash_type > -0.5 &&  dash_type < 0.5) {\n            d = abs(dy);\n        }\n\n        // Line join\n        if( (dx > line_start) && (dx < line_stop)) {\n            if( (dx <= segment_start) && (dash_start <= segment_start)\n                && (dash_stop >= segment_start) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.x;\n                float f = abs( (segment_start - dx)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( (dx > segment_stop) && (dash_start <= segment_stop)\n                     && (dash_stop >= segment_stop) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.y;\n                float f = abs((dx - segment_stop)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( dx < (segment_start - v_linewidth/2.)) {\n                discard;\n            }\n            else if( dx > (segment_stop + v_linewidth/2.)) {\n                discard;\n            }\n        }\n        else if( dx < (segment_start - v_linewidth/2.)) {\n            discard;\n        }\n        else if( dx > (segment_stop + v_linewidth/2.)) {\n            discard;\n        }\n    }\n\n    // Distance to border ------------------------------------------------------\n    d = d - t;\n    if( d < 0.0 ) {\n        gl_FragColor = color;\n    } else {\n        d /= u_antialias;\n        gl_FragColor = vec4(color.rgb, exp(-d*d)*color.a);\n    }\n}",e.prototype.init=function(){var t;return t=this.gl,this._scale_aspect=0,this.prog=new r.Program(t),this.prog.set_shaders(this.VERT,this.FRAG),this.index_buffer=new r.IndexBuffer(t),this.vbo_position=new r.VertexBuffer(t),this.vbo_tangents=new r.VertexBuffer(t),this.vbo_segment=new r.VertexBuffer(t),this.vbo_angles=new r.VertexBuffer(t),this.vbo_texcoord=new r.VertexBuffer(t),this.dash_atlas=new a(t)},e.prototype.draw=function(t,e,n){var a,s,o,r,i,l,_,h,c,u,f,d,p,g,v,y,m,x,b,w;if(_=e.glglyph,_.data_changed){if(!isFinite(n.dx)||!isFinite(n.dy))return;_._baked_offset=[n.dx,n.dy],_._set_data(),_.data_changed=!1}if(this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1),m=n.sx,x=n.sy,y=Math.sqrt(m*m+x*x),m/=y,x/=y,Math.abs(this._scale_aspect-x/m)>Math.abs(.001*this._scale_aspect)&&(_._update_scale(m,x),this._scale_aspect=x/m),this.prog.set_attribute("a_position","vec2",_.vbo_position),this.prog.set_attribute("a_tangents","vec4",_.vbo_tangents),this.prog.set_attribute("a_segment","vec2",_.vbo_segment),this.prog.set_attribute("a_angles","vec2",_.vbo_angles),this.prog.set_attribute("a_texcoord","vec2",_.vbo_texcoord),this.prog.set_uniform("u_length","float",[_.cumsum]),this.prog.set_texture("u_dash_atlas",this.dash_atlas.tex),a=_._baked_offset,this.prog.set_uniform("u_pixel_ratio","float",[n.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[n.width,n.height]),this.prog.set_uniform("u_offset","vec2",[n.dx-a[0],n.dy-a[1]]),this.prog.set_uniform("u_scale_aspect","vec2",[m,x]),this.prog.set_uniform("u_scale_length","float",[y]),this.I_triangles=_.I_triangles,this.I_triangles.length<65535)return this.index_buffer.set_size(2*this.I_triangles.length),this.index_buffer.set_data(0,new Uint16Array(this.I_triangles)),this.prog.draw(this.gl.TRIANGLES,this.index_buffer);for(t=this.I_triangles,h=this.I_triangles.length,r=64008,o=[],i=l=0,d=Math.ceil(h/r);0<=d?l<d:l>d;i=0<=d?++l:--l)o.push([]);for(i=u=0,p=t.length;0<=p?u<p:u>p;i=0<=p?++u:--u)w=t[i]%r,s=Math.floor(t[i]/r),o[s].push(w);for(v=[],s=f=0,g=o.length;0<=g?f<g:f>g;s=0<=g?++f:--f)b=new Uint16Array(o[s]),c=s*r*4,0!==b.length&&(this.prog.set_attribute("a_position","vec2",_.vbo_position,0,2*c),this.prog.set_attribute("a_tangents","vec4",_.vbo_tangents,0,4*c),this.prog.set_attribute("a_segment","vec2",_.vbo_segment,0,2*c),this.prog.set_attribute("a_angles","vec2",_.vbo_angles,0,2*c),this.prog.set_attribute("a_texcoord","vec2",_.vbo_texcoord,0,2*c),this.index_buffer.set_size(2*b.length),this.index_buffer.set_data(0,b),v.push(this.prog.draw(this.gl.TRIANGLES,this.index_buffer)));return v},e.prototype._set_data=function(){return this._bake(),this.vbo_position.set_size(4*this.V_position.length),this.vbo_position.set_data(0,this.V_position),this.vbo_tangents.set_size(4*this.V_tangents.length),this.vbo_tangents.set_data(0,this.V_tangents),this.vbo_angles.set_size(4*this.V_angles.length),this.vbo_angles.set_data(0,this.V_angles),this.vbo_texcoord.set_size(4*this.V_texcoord.length),this.vbo_texcoord.set_data(0,this.V_texcoord)},e.prototype._set_visuals=function(){var t,e,n,a,s,o,r;return e=i.color2rgba(this.glyph.visuals.line.line_color.value(),this.glyph.visuals.line.line_alpha.value()),t=this.CAPS[this.glyph.visuals.line.line_cap.value()],o=this.JOINS[this.glyph.visuals.line.line_join.value()],this.prog.set_uniform("u_color","vec4",e),this.prog.set_uniform("u_linewidth","float",[this.glyph.visuals.line.line_width.value()]),this.prog.set_uniform("u_antialias","float",[.9]),this.prog.set_uniform("u_linecaps","vec2",[t,t]),this.prog.set_uniform("u_linejoin","float",[o]),this.prog.set_uniform("u_miter_limit","float",[10]),a=this.glyph.visuals.line.line_dash.value(),n=0,s=1,a.length&&(r=this.dash_atlas.get_atlas_data(a),n=r[0],s=r[1]),this.prog.set_uniform("u_dash_index","float",[n]),this.prog.set_uniform("u_dash_phase","float",[this.glyph.visuals.line.line_dash_offset.value()]),this.prog.set_uniform("u_dash_period","float",[s]),this.prog.set_uniform("u_dash_caps","vec2",[t,t]),this.prog.set_uniform("u_closed","float",[0])},e.prototype._bake=function(){var t,e,n,a,s,o,r,i,l,_,h,c,u,f,d,p,g,v,y,m,x,b,w,P,A,E,z,R,q,T,k,S,O,G,M,I,D,L,j,F,C,V;for(b=this.nvertices,f=new Float64Array(this.glyph._x),d=new Float64Array(this.glyph._y),o=c=new Float32Array(2*b),a=new Float32Array(2*b),i=u=new Float32Array(4*b),_=new Float32Array(2*b),p=m=0,R=b;0<=R?m<R:m>R;p=0<=R?++m:--m)o[2*p+0]=f[p]+this._baked_offset[0],o[2*p+1]=d[p]+this._baked_offset[1];for(this.tangents=n=new Float32Array(2*b-2),p=A=0,q=b-1;0<=q?A<q:A>q;p=0<=q?++A:--A)n[2*p+0]=c[2*(p+1)+0]-c[2*p+0],n[2*p+1]=c[2*(p+1)+1]-c[2*p+1];for(p=E=0,T=b-1;0<=T?E<T:E>T;p=0<=T?++E:--E)i[4*(p+1)+0]=n[2*p+0],i[4*(p+1)+1]=n[2*p+1],i[4*p+2]=n[2*p+0],i[4*p+3]=n[2*p+1];for(i[0]=n[0],i[1]=n[1],i[4*(b-1)+2]=n[2*(b-2)+0],i[4*(b-1)+3]=n[2*(b-2)+1],t=new Float32Array(b),p=z=0,k=b;0<=k?z<k:z>k;p=0<=k?++z:--z)t[p]=Math.atan2(u[4*p+0]*u[4*p+3]-u[4*p+1]*u[4*p+2],u[4*p+0]*u[4*p+2]+u[4*p+1]*u[4*p+3]);for(p=D=0,S=b-1;0<=S?D<S:D>S;p=0<=S?++D:--D)a[2*p+0]=t[p],a[2*p+1]=t[p+1];for(x=4*b-4,this.V_position=r=new Float32Array(2*x),this.V_angles=s=new Float32Array(2*x),this.V_tangents=l=new Float32Array(4*x),this.V_texcoord=h=new Float32Array(2*x),P=2,p=L=0,O=b;0<=O?L<O:L>O;p=0<=O?++L:--L)for(v=j=0;j<4;v=++j){for(y=F=0;F<2;y=++F)r[2*(4*p+v-P)+y]=o[2*p+y],s[2*(4*p+v)+y]=a[2*p+y];for(y=C=0;C<4;y=++C)l[4*(4*p+v-P)+y]=i[4*p+y]}for(p=V=0,G=b;0<=G?V<=G:V>=G;p=0<=G?++V:--V)h[2*(4*p+0)+0]=-1,h[2*(4*p+1)+0]=-1,h[2*(4*p+2)+0]=1,h[2*(4*p+3)+0]=1,h[2*(4*p+0)+1]=-1,h[2*(4*p+1)+1]=1,h[2*(4*p+2)+1]=-1,h[2*(4*p+3)+1]=1;for(w=6*(b-1),this.I_triangles=e=new Uint32Array(w),I=[],p=g=0,M=b;0<=M?g<M:g>M;p=0<=M?++g:--g)e[6*p+0]=0+4*p,e[6*p+1]=1+4*p,e[6*p+2]=3+4*p,e[6*p+3]=2+4*p,e[6*p+4]=0+4*p,I.push(e[6*p+5]=3+4*p);return I},e.prototype._update_scale=function(t,e){var n,a,s,o,r,i,l,_,h,c,u,f,d,p,g,v,y,m;for(u=this.nvertices,c=4*u-4,a=this.tangents,n=new Float32Array(u-1),s=new Float32Array(2*u),this.V_segment=o=new Float32Array(2*c),i=h=0,g=u-1;0<=g?h<g:h>g;i=0<=g?++h:--h)n[i]=Math.sqrt(Math.pow(a[2*i+0]*t,2)+Math.pow(a[2*i+1]*e,2));for(r=0,i=f=0,v=u-1;0<=v?f<v:f>v;i=0<=v?++f:--f)r+=n[i],s[2*(i+1)+0]=r,s[2*i+1]=r;for(i=d=0,y=u;0<=y?d<y:d>y;i=0<=y?++d:--d)for(l=p=0;p<4;l=++p)for(_=m=0;m<2;_=++m)o[2*(4*i+l)+_]=s[2*i+_];return this.cumsum=r,this.vbo_segment.set_size(4*this.V_segment.length),this.vbo_segment.set_data(0,this.V_segment)},e}(l.BaseGLGlyph)},{"./base":"models/glyphs/webgl/base","core/util/color":void 0,gloo2:"gloo2"}],"models/glyphs/webgl/main":[function(t,e,n){"use strict";Object.defineProperty(n,"__esModule",{value:!0}),t("./index")},{"./index":"models/glyphs/webgl/index"}],"models/glyphs/webgl/markers":[function(t,e,n){"use strict";Object.defineProperty(n,"__esModule",{value:!0});var a,s=function(t,e){function n(){this.constructor=t}for(var a in e)o.call(e,a)&&(t[a]=e[a]);return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},o={}.hasOwnProperty,r=t("gloo2"),i=t("core/logging"),l=t("./base");a=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.VERT="precision mediump float;\nconst float SQRT_2 = 1.4142135623730951;\n//\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform vec2 u_offset;\nuniform vec2 u_scale;\nuniform float u_antialias;\n//\nattribute float a_x;\nattribute float a_y;\nattribute float a_size;\nattribute float a_angle;  // in radians\nattribute float a_linewidth;\nattribute vec4  a_fg_color;\nattribute vec4  a_bg_color;\n//\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying vec2  v_rotation;\n\nvoid main (void)\n{\n    v_size = a_size * u_pixel_ratio;\n    v_linewidth = a_linewidth * u_pixel_ratio;\n    v_fg_color = a_fg_color;\n    v_bg_color = a_bg_color;\n    v_rotation = vec2(cos(-a_angle), sin(-a_angle));\n    // Calculate position - the -0.5 is to correct for canvas origin\n    vec2 pos = (vec2(a_x, a_y) + u_offset) * u_scale; // in pixels\n    pos += 0.5;  // make up for Bokeh's offset\n    pos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(pos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n    gl_PointSize = SQRT_2 * v_size + 2.0 * (v_linewidth + 1.5*u_antialias);\n}",e.prototype.FRAG="precision mediump float;\nconst float SQRT_2 = 1.4142135623730951;\nconst float PI = 3.14159265358979323846264;\n//\nuniform float u_antialias;\n//\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec2  v_rotation;\n\nMARKERCODE\n\nvec4 outline(float distance, float linewidth, float antialias, vec4 fg_color, vec4 bg_color)\n{\n    vec4 frag_color;\n    float t = linewidth/2.0 - antialias;\n    float signed_distance = distance;\n    float border_distance = abs(signed_distance) - t;\n    float alpha = border_distance/antialias;\n    alpha = exp(-alpha*alpha);\n\n    // If fg alpha is zero, it probably means no outline. To avoid a dark outline\n    // shining through due to aa, we set the fg color to the bg color. Avoid if (i.e. branching).\n    float select = float(bool(fg_color.a));\n    fg_color.rgb = select * fg_color.rgb + (1.0  - select) * bg_color.rgb;\n    // Similarly, if we want a transparent bg\n    select = float(bool(bg_color.a));\n    bg_color.rgb = select * bg_color.rgb + (1.0  - select) * fg_color.rgb;\n\n    if( border_distance < 0.0)\n        frag_color = fg_color;\n    else if( signed_distance < 0.0 ) {\n        frag_color = mix(bg_color, fg_color, sqrt(alpha));\n    } else {\n        if( abs(signed_distance) < (linewidth/2.0 + antialias) ) {\n            frag_color = vec4(fg_color.rgb, fg_color.a * alpha);\n        } else {\n            discard;\n        }\n    }\n    return frag_color;\n}\n\nvoid main()\n{\n    vec2 P = gl_PointCoord.xy - vec2(0.5, 0.5);\n    P = vec2(v_rotation.x*P.x - v_rotation.y*P.y,\n             v_rotation.y*P.x + v_rotation.x*P.y);\n    float point_size = SQRT_2*v_size  + 2.0 * (v_linewidth + 1.5*u_antialias);\n    float distance = marker(P*point_size, v_size);\n    gl_FragColor = outline(distance, v_linewidth, u_antialias, v_fg_color, v_bg_color);\n    //gl_FragColor.rgb *= gl_FragColor.a;  // pre-multiply alpha\n}",
e.prototype.MARKERCODE="<defined in subclasses>",e.prototype.init=function(){var t,e;return e=this.gl,t=this.FRAG.replace(/MARKERCODE/,this.MARKERCODE),this.last_trans={},this.prog=new r.Program(e),this.prog.set_shaders(this.VERT,t),this.vbo_x=new r.VertexBuffer(e),this.prog.set_attribute("a_x","float",this.vbo_x),this.vbo_y=new r.VertexBuffer(e),this.prog.set_attribute("a_y","float",this.vbo_y),this.vbo_s=new r.VertexBuffer(e),this.prog.set_attribute("a_size","float",this.vbo_s),this.vbo_a=new r.VertexBuffer(e),this.prog.set_attribute("a_angle","float",this.vbo_a),this.vbo_linewidth=new r.VertexBuffer(e),this.vbo_fg_color=new r.VertexBuffer(e),this.vbo_bg_color=new r.VertexBuffer(e),this.index_buffer=new r.IndexBuffer(e)},e.prototype.draw=function(t,e,n){var a,s,o,r,l,_,h,c,u,f,d,p,g,v,y,m,x,b,w;if(u=e.glglyph,f=u.nvertices,u.data_changed){if(!isFinite(n.dx)||!isFinite(n.dy))return;u._baked_offset=[n.dx,n.dy],u._set_data(f),u.data_changed=!1}else null==this.glyph._radius||n.sx===this.last_trans.sx&&n.sy===this.last_trans.sy||(this.last_trans=n,this.vbo_s.set_data(0,new Float32Array(function(){var t,e,n,a;for(n=this.glyph.sradius,a=[],t=0,e=n.length;t<e;t++)m=n[t],a.push(2*m);return a}.call(this))));if(this.visuals_changed&&(this._set_visuals(f),this.visuals_changed=!1),a=u._baked_offset,this.prog.set_uniform("u_pixel_ratio","float",[n.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[n.width,n.height]),this.prog.set_uniform("u_offset","vec2",[n.dx-a[0],n.dy-a[1]]),this.prog.set_uniform("u_scale","vec2",[n.sx,n.sy]),this.prog.set_attribute("a_x","float",u.vbo_x),this.prog.set_attribute("a_y","float",u.vbo_y),this.prog.set_attribute("a_size","float",u.vbo_s),this.prog.set_attribute("a_angle","float",u.vbo_a),0!==t.length){if(t.length===f)return this.prog.draw(this.gl.POINTS,[0,f]);if(f<65535)return b=window.navigator.userAgent,b.indexOf("MSIE ")+b.indexOf("Trident/")+b.indexOf("Edge/")>0&&i.logger.warn("WebGL warning: IE is known to produce 1px sprites whith selections."),this.index_buffer.set_size(2*t.length),this.index_buffer.set_data(0,new Uint16Array(t)),this.prog.draw(this.gl.POINTS,this.index_buffer);for(r=64e3,o=[],l=_=0,p=Math.ceil(f/r);0<=p?_<p:_>p;l=0<=p?++_:--_)o.push([]);for(l=h=0,g=t.length;0<=g?h<g:h>g;l=0<=g?++h:--h)w=t[l]%r,s=Math.floor(t[l]/r),o[s].push(w);for(y=[],s=c=0,v=o.length;0<=v?c<v:c>v;s=0<=v?++c:--c)x=new Uint16Array(o[s]),d=s*r*4,0!==x.length&&(this.prog.set_attribute("a_x","float",u.vbo_x,0,d),this.prog.set_attribute("a_y","float",u.vbo_y,0,d),this.prog.set_attribute("a_size","float",u.vbo_s,0,d),this.prog.set_attribute("a_angle","float",u.vbo_a,0,d),this.vbo_linewidth.used&&this.prog.set_attribute("a_linewidth","float",this.vbo_linewidth,0,d),this.vbo_fg_color.used&&this.prog.set_attribute("a_fg_color","vec4",this.vbo_fg_color,0,4*d),this.vbo_bg_color.used&&this.prog.set_attribute("a_bg_color","vec4",this.vbo_bg_color,0,4*d),this.index_buffer.set_size(2*x.length),this.index_buffer.set_data(0,x),y.push(this.prog.draw(this.gl.POINTS,this.index_buffer)));return y}},e.prototype._set_data=function(t){var e,n,a,s,o,r,i;for(a=4*t,this.vbo_x.set_size(a),this.vbo_y.set_size(a),this.vbo_a.set_size(a),this.vbo_s.set_size(a),r=new Float64Array(this.glyph._x),i=new Float64Array(this.glyph._y),e=n=0,s=t;0<=s?n<s:n>s;e=0<=s?++n:--n)r[e]+=this._baked_offset[0],i[e]+=this._baked_offset[1];return this.vbo_x.set_data(0,new Float32Array(r)),this.vbo_y.set_data(0,new Float32Array(i)),null!=this.glyph._angle&&this.vbo_a.set_data(0,new Float32Array(this.glyph._angle)),null!=this.glyph._radius?this.vbo_s.set_data(0,new Float32Array(function(){var t,e,n,a;for(n=this.glyph.sradius,a=[],t=0,e=n.length;t<e;t++)o=n[t],a.push(2*o);return a}.call(this))):this.vbo_s.set_data(0,new Float32Array(this.glyph._size))},e.prototype._set_visuals=function(t){return l.attach_float(this.prog,this.vbo_linewidth,"a_linewidth",t,this.glyph.visuals.line,"line_width"),l.attach_color(this.prog,this.vbo_fg_color,"a_fg_color",t,this.glyph.visuals.line,"line"),l.attach_color(this.prog,this.vbo_bg_color,"a_bg_color",t,this.glyph.visuals.fill,"fill"),this.prog.set_uniform("u_antialias","float",[.8])},e}(l.BaseGLGlyph),n.CircleGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="circle",e.prototype.MARKERCODE="// --- disc\nfloat marker(vec2 P, float size)\n{\n    return length(P) - size/2.0;\n}",e}(a),n.SquareGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="square",e.prototype.MARKERCODE="// --- square\nfloat marker(vec2 P, float size)\n{\n    return max(abs(P.x), abs(P.y)) - size/2.0;\n}",e}(a),n.AnnulusGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="annulus",e.prototype.MARKERCODE="float marker(vec2 P, float size)\n{\n    float r1 = length(P) - size/2.0;\n    float r2 = length(P) - size/4.0;  // half width\n    return max(r1, -r2);\n}",e}(a),n.DiamondGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="diamond",e.prototype.MARKERCODE="// --- diamond\nfloat marker(vec2 P, float size)\n{\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    return r1 / SQRT_2;\n}",e}(a),n.TriangleGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="triangle",e.prototype.MARKERCODE="float marker(vec2 P, float size)\n{\n    P.y -= size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = P.y;\n    return max(r1 / SQRT_2, r2);  // Instersect diamond with rectangle\n}",e}(a),n.InvertedTriangleGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="invertedtriangle",e.prototype.MARKERCODE="float marker(vec2 P, float size)\n{\n    P.y += size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = - P.y;\n    return max(r1 / SQRT_2, r2);  // Instersect diamond with rectangle\n}",e}(a),n.CrossGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="cross",e.prototype.MARKERCODE='float marker(vec2 P, float size)\n{\n    float square = max(abs(P.x), abs(P.y)) - size / 2.5;  // 2.5 is a tweak\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(square, cross);\n}',e}(a),n.CircleCrossGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="circlecross",e.prototype.MARKERCODE="float marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}",e}(a),n.SquareCrossGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="squarecross",e.prototype.MARKERCODE="float marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}",e}(a),n.DiamondCrossGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="diamondcross",e.prototype.MARKERCODE="float marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float diamond = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    diamond /= SQRT_2;\n    float c1 = max(diamond, s1);\n    float c2 = max(diamond, s2);\n    float c3 = max(diamond, s3);\n    float c4 = max(diamond, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}",e}(a),n.XGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="x",e.prototype.MARKERCODE='float marker(vec2 P, float size)\n{\n    float circle = length(P) - size / 1.6;\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(circle, X);\n}',e}(a),n.CircleXGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="circlex",e.prototype.MARKERCODE='float marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    float almost = min(min(min(c1, c2), c3), c4);\n    // In this case, the X is also outside of the main shape\n    float Xmask = length(P) - size / 1.6;  // a circle\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return min(max(X, Xmask), almost);\n}',e}(a),n.SquareXGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="squarex",e.prototype.MARKERCODE="float marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}",e}(a),n.AsteriskGLGlyph=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return s(e,t),e.prototype.GLYPH="asterisk",e.prototype.MARKERCODE='float marker(vec2 P, float size)\n{\n    // Masks\n    float diamond = max(abs(SQRT_2 / 2.0 * (P.x - P.y)), abs(SQRT_2 / 2.0 * (P.x + P.y))) - size / (2.0 * SQRT_2);\n    float square = max(abs(P.x), abs(P.y)) - size / (2.0 * SQRT_2);\n    // Shapes\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    // Result is union of masked shapes\n    return min(max(X, diamond), max(cross, square));\n}',e}(a)},{"./base":"models/glyphs/webgl/base","core/logging":void 0,gloo2:"gloo2"}],gloo2:[function(e,n,a){(function(e){!function(e,s){"function"==typeof t&&t.amd?t([],s):"undefined"!=typeof a?(n.exports=s(),"undefined"==typeof window&&(e.gloo2=n.exports)):e.gloo2=s()}(this,function(){var t,n,a,s,o,r,i,l,_,h,c=function(t,e){return Array.isArray(t)&&Array.isArray(e)?t.concat(e):t+e},u=function(t){for(var e=0;e<t.length;e++)if(!v(t[e]))return!1;return!0},f=function(t,e){if(null==e);else{if(Array.isArray(e)){for(var n=0;n<e.length;n++)if(d(t,e[n]))return!0;return!1}if(e.constructor===Object){for(var a in e)if(t==a)return!0;return!1}if(e.constructor==String)return e.indexOf(t)>=0}var s=Error("Not a container: "+e);throw s.name="TypeError",s},d=function E(t,e){if(null==t||null==e);else{if(Array.isArray(t)&&Array.isArray(e)){for(var n=0,a=t.length==e.length;a&&n<t.length;)a=E(t[n],e[n]),n+=1;return a}if(t.constructor===Object&&e.constructor===Object){var s=Object.keys(t),o=Object.keys(e);s.sort(),o.sort();for(var r,n=0,a=E(s,o);a&&n<s.length;)r=s[n],a=E(t[r],e[r]),n+=1;return a}}return t==e},p=function(t,n){if("undefined"==typeof t||"undefined"!=typeof window&&window===t||"undefined"!=typeof e&&e===t)throw"Class constructor is called as a function.";for(var a in t)void 0!==Object[a]||"function"!=typeof t[a]||t[a].nobind||(t[a]=t[a].bind(t));t.__init__&&t.__init__.apply(t,n)},g=function(t,e){if(("number"==typeof t)+("number"==typeof e)===1){if(t.constructor===String)return P.call(t,e);if(e.constructor===String)return P.call(e,t);if(Array.isArray(e)){var n=t;t=e,e=n}if(Array.isArray(t)){for(var a=[],s=0;s<e;s++)a=a.concat(t);return a}}return t*e},v=function(t){return null===t||"object"!=typeof t?t:void 0!==t.length?!!t.length&&t:void 0!==t.byteLength?!!t.byteLength&&t:t.constructor!==Object||!!Object.getOwnPropertyNames(t).length&&t},y=function(t){return Array.isArray(this)?void this.push(t):this.append.apply(this,arguments)},m=function(t,e){return this.constructor!==Object?this.get.apply(this,arguments):void 0!==this[t]?this[t]:void 0!==e?e:null},x=function(){return"function"==typeof this.keys?this.keys.apply(this,arguments):Object.keys(this)},b=function(t){if(this.constructor!==String)return this.lstrip.apply(this,arguments);t=void 0===t?" \t\r\n":t;for(var e=0;e<this.length;e++)if(t.indexOf(this[e])<0)return this.slice(e);return""},w=function(t){if(!Array.isArray(this))return this.remove.apply(this,arguments);for(var e=0;e<this.length;e++)if(d(this[e],t))return void this.splice(e,1);var n=Error(t);throw n.name="ValueError",n},P=function(t){if(this.repeat)return this.repeat(t);if(t<1)return"";for(var e="",n=this.valueOf();t>1;)1&t&&(e+=n),t>>=1,n+=n;return e+n},A=function(t){return this.constructor!==String?this.startswith.apply(this,arguments):0==this.indexOf(t)};return h=window.console,l="0.3",_=function(t,e){var n,a,s,o,r,i,l;for(e=void 0===e?"periodic check":e,o=[];;){if(a=t.getError(),d(a,t.NO_ERROR)||v(o)&&d(a,o[o.length-1]))break;y.call(o,a)}if(o.length){for(r="",i=o,"object"!=typeof i||Array.isArray(i)||(i=Object.keys(i)),l=0;l<i.length;l+=1)n=i[l],r=c(r,n);throw s=new Error("RuntimeError:"+("OpenGL got errors ("+e+"): "+r)),s.name="RuntimeError",s}return null},n=function(){p(this,arguments)},n.prototype._base_class=Object,n.prototype._class_name="GlooObject",n.prototype.__init__=function(t){if(this._gl=t,this.handle=null,this._create(),null===this.handle)throw"AssertionError: this.handle !== null";return null},n.prototype._create=function(){var t;throw t=new Error("NotImplementedError:"),t.name="NotImplementedError",t},s=function(){p(this,arguments)},s.prototype=Object.create(n.prototype),s.prototype._base_class=n.prototype,s.prototype._class_name="Program",s.prototype.UTYPEMAP={"float":"uniform1fv",vec2:"uniform2fv",vec3:"uniform3fv",vec4:"uniform4fv","int":"uniform1iv",ivec2:"uniform2iv",ivec3:"uniform3iv",ivec4:"uniform4iv",bool:"uniform1iv",bvec2:"uniform2iv",bvec3:"uniform3iv",bvec4:"uniform4iv",mat2:"uniformMatrix2fv",mat3:"uniformMatrix3fv",mat4:"uniformMatrix4fv",sampler1D:"uniform1i",sampler2D:"uniform1i",sampler3D:"uniform1i"},s.prototype.ATYPEMAP={"float":"vertexAttrib1f",vec2:"vertexAttrib2f",vec3:"vertexAttrib3f",vec4:"vertexAttrib4f"},s.prototype.ATYPEINFO={"float":[1,5126],vec2:[2,5126],vec3:[3,5126],vec4:[4,5126]},s.prototype._create=function(){return this.handle=this._gl.createProgram(),this.locations={},this._unset_variables=[],this._validated=!1,this._samplers={},this._attributes={},this._known_invalid=[],null},s.prototype["delete"]=function(){return this._gl.deleteProgram(this.handle),null},s.prototype.activate=function(){return this._gl.useProgram(this.handle),null},s.prototype.deactivate=function(){return this._gl.useProgram(0),null},s.prototype.set_shaders=function(t,e){var n,a,s,o,r,i,l,_,h,u,f,d,p;for(i=this._gl,this._linked=!1,p=i.createShader(i.VERTEX_SHADER),r=i.createShader(i.FRAGMENT_SHADER),f=[[t,p,"vertex"],[e,r,"fragment"]],_=0;_<2;_+=1)if(u=f[_],n=u[0],l=u[1],d=u[2],i.shaderSource(l,n),i.compileShader(l),h=i.getShaderParameter(l,i.COMPILE_STATUS),!v(h))throw o=i.getShaderInfoLog(l),s=new Error("RuntimeError:"+c("errors in "+d+" shader:\n",o)),s.name="RuntimeError",s;if(i.attachShader(this.handle,p),i.attachShader(this.handle,r),i.linkProgram(this.handle),!v(i.getProgramParameter(this.handle,i.LINK_STATUS)))throw a=new Error("RuntimeError:Program link error:\n"+i.getProgramInfoLog(this.handle)),a.name="RuntimeError",a;return this._unset_variables=this._get_active_attributes_and_uniforms(),i.detachShader(this.handle,p),i.detachShader(this.handle,r),i.deleteShader(p),i.deleteShader(r),this._known_invalid=[],this._linked=!0,null},s.prototype._get_active_attributes_and_uniforms=function(){var t,e,n,a,s,o,r,i,l,_,h,u,f,d,p,g,m,x,b;for(i=this._gl,this.locations={},d=new window.RegExp("(\\w+)\\s*(\\[(\\d+)\\])\\s*"),s=i.getProgramParameter(this.handle,i.ACTIVE_UNIFORMS),e=i.getProgramParameter(this.handle,i.ACTIVE_ATTRIBUTES),t=[],x=[],g=[[t,e,i.getActiveAttrib,i.getAttribLocation],[x,s,i.getActiveUniform,i.getUniformLocation]],"object"!=typeof g||Array.isArray(g)||(g=Object.keys(g)),m=0;m<g.length;m+=1)for(b=g[m],p=b,n=p[0],a=p[1],o=p[2],r=p[3],l=0;l<a;l+=1){if(_=o.call(i,this.handle,l),f=_.name,u=f.match(d),v(u))for(f=u[1],h=0;h<_.size;h+=1)y.call(n,[""+f+"["+h+"]",_.type]);else y.call(n,[f,_.type]);this.locations[f]=r.call(i,this.handle,f)}return c(function(){var e,n,a,s=[];for(n=t,"object"!=typeof n||Array.isArray(n)||(n=Object.keys(n)),a=0;a<n.length;a++)e=n[a],s.push(e[0]);return s}.apply(this),function(){var t,e,n,a=[];for(e=x,"object"!=typeof e||Array.isArray(e)||(e=Object.keys(e)),n=0;n<e.length;n++)t=e[n],a.push(t[0]);return a}.apply(this))},s.prototype.set_texture=function(t,e){var n,a,s;if(!v(this._linked))throw n=new Error("RuntimeError:Cannot set uniform when program has no code"),n.name="RuntimeError",n;return a=m.call(this.locations,t,-1),v(a<0)?(f(t,this._known_invalid)||(y.call(this._known_invalid,t),h.log("Variable "+t+" is not an active texture")),null):(f(t,this._unset_variables)&&w.call(this._unset_variables,t),this.activate(),s=x.call(this._samplers).length,f(t,this._samplers)&&(s=this._samplers[t][this._samplers[t].length-1]),this._samplers[t]=[e._target,e.handle,s],this._gl.uniform1i(a,s),null)},s.prototype.set_uniform=function(t,e,n){var a,s,o,r,i,l,_;if(!v(this._linked))throw o=new Error("RuntimeError:Cannot set uniform when program has no code"),o.name="RuntimeError",o;if(i=m.call(this.locations,t,-1),v(i<0))return f(t,this._known_invalid)||(y.call(this._known_invalid,t),h.log("Variable "+t+" is not an active uniform")),null;if(f(t,this._unset_variables)&&w.call(this._unset_variables,t),s=1,A.call(e,"mat")||(a=m.call({"int":"float",bool:"float"},e,b.call(e,"ib")),s=Math.floor(n.length/this.ATYPEINFO[a][0])),v(s>1))for(l=0;l<s;l+=1)f(""+t+"["+l+"]",this._unset_variables)&&(_=""+t+"["+l+"]",f(_,this._unset_variables)&&w.call(this._unset_variables,_));return r=this.UTYPEMAP[e],this.activate(),A.call(e,"mat")?this._gl[r](i,!1,n):this._gl[r](i,n),null},s.prototype.set_attribute=function(t,e,n,a,s){var o,r,l,_,c,u,d,p;if(a=void 0===a?0:a,s=void 0===s?0:s,!v(this._linked))throw r=new Error("RuntimeError:Cannot set attribute when program has no code"),r.name="RuntimeError",r;return u=n instanceof i,c=m.call(this.locations,t,-1),v(c<0)?(f(t,this._known_invalid)||(y.call(this._known_invalid,t),v(u)&&v(s>0)||h.log("Variable "+t+" is not an active attribute")),null):(f(t,this._unset_variables)&&w.call(this._unset_variables,t),this.activate(),v(u)?(p=this.ATYPEINFO[e],d=p[0],_=p[1],l="vertexAttribPointer",o=[d,_,this._gl.FALSE,a,s],this._attributes[t]=[n.handle,c,l,o]):(l=this.ATYPEMAP[e],this._attributes[t]=[0,c,l,n]),null)},s.prototype._pre_draw=function(){var t,e,n,a,s,o,r,i,l,_,h,u;this.activate(),r=this._samplers;for(u in r)r.hasOwnProperty(u)&&(u=r[u],o=u,l=o[0],i=o[1],_=o[2],this._gl.activeTexture(c(this._gl.TEXTURE0,_)),this._gl.bindTexture(l,i));s=this._attributes;for(u in s)s.hasOwnProperty(u)&&(u=s[u],a=u,h=a[0],e=a[1],n=a[2],t=a[3],v(h)?(this._gl.bindBuffer(this._gl.ARRAY_BUFFER,h),this._gl.enableVertexAttribArray(e),this._gl[n].apply(this._gl,[].concat([e],t))):(this._gl.bindBuffer(this._gl.ARRAY_BUFFER,null),this._gl.disableVertexAttribArray(e),this._gl[n].apply(this._gl,[].concat([e],t))));return v(this._validated)||(this._validated=!0,this._validate()),null},s.prototype._validate=function(){var t;if(this._unset_variables.length&&h.log("Program has unset variables: "+this._unset_variables),this._gl.validateProgram(this.handle),!v(this._gl.getProgramParameter(this.handle,this._gl.VALIDATE_STATUS)))throw h.log(this._gl.getProgramInfoLog(this.handle)),t=new Error("RuntimeError:Program validation error"),t.name="RuntimeError",t;return null},s.prototype.draw=function(t,e){var n,s,o,r,i;if(!v(this._linked))throw s=new Error("RuntimeError:Cannot draw program if code has not been set"),s.name="RuntimeError",s;return _(this._gl,"before draw"),v(e instanceof a)?(this._pre_draw(),e.activate(),n=e._buffer_size/2,r=this._gl.UNSIGNED_SHORT,this._gl.drawElements(t,n,r,0),e.deactivate()):(i=e,o=i[0],n=i[1],v(n)&&(this._pre_draw(),this._gl.drawArrays(t,o,n))),_(this._gl,"after draw"),null},t=function(){p(this,arguments)},t.prototype=Object.create(n.prototype),t.prototype._base_class=n.prototype,t.prototype._class_name="Buffer",t.prototype._target=null,t.prototype._usage=35048,t.prototype._create=function(){return this.handle=this._gl.createBuffer(),this._buffer_size=0,null},t.prototype["delete"]=function(){return this._gl.deleteBuffer(this.handle),null},t.prototype.activate=function(){return this._gl.bindBuffer(this._target,this.handle),null},t.prototype.deactivate=function(){return this._gl.bindBuffer(this._target,null),null},t.prototype.set_size=function(t){return d(t,this._buffer_size)||(this.activate(),this._gl.bufferData(this._target,t,this._usage),this._buffer_size=t),null},t.prototype.set_data=function(t,e){return this.activate(),this._gl.bufferSubData(this._target,t,e),null},i=function(){p(this,arguments)},i.prototype=Object.create(t.prototype),i.prototype._base_class=t.prototype,i.prototype._class_name="VertexBuffer",i.prototype._target=34962,a=function(){p(this,arguments)},a.prototype=Object.create(t.prototype),a.prototype._base_class=t.prototype,a.prototype._class_name="IndexBuffer",a.prototype._target=34963,o=function(){p(this,arguments)},o.prototype=Object.create(n.prototype),o.prototype._base_class=n.prototype,o.prototype._class_name="Texture2D",o.prototype._target=3553,o.prototype._types={Int8Array:5120,Uint8Array:5121,Int16Array:5122,Uint16Array:5123,Int32Array:5124,Uint32Array:5125,Float32Array:5126},o.prototype._create=function(){return this.handle=this._gl.createTexture(),this._shape_format=null,null},o.prototype["delete"]=function(){return this._gl.deleteTexture(this.handle),null},o.prototype.activate=function(){return this._gl.bindTexture(this._target,this.handle),null},o.prototype.deactivate=function(){return this._gl.bindTexture(this._target,0),null},o.prototype._get_alignment=function(t){var e,n,a,s;for(n=[4,8,2,1],a=n,"object"!=typeof a||Array.isArray(a)||(a=Object.keys(a)),s=0;s<a.length;s+=1)if(e=a[s],d(t%e,0))return e;return null},o.prototype.set_wrapping=function(t,e){return this.activate(),this._gl.texParameterf(this._target,this._gl.TEXTURE_WRAP_S,t),this._gl.texParameterf(this._target,this._gl.TEXTURE_WRAP_T,e),null},o.prototype.set_interpolation=function(t,e){return this.activate(),this._gl.texParameterf(this._target,this._gl.TEXTURE_MIN_FILTER,t),this._gl.texParameterf(this._target,this._gl.TEXTURE_MAG_FILTER,e),null},o.prototype.set_size=function(t,e){var n,a,s;return a=t,n=a[0],s=a[1],d([n,s,e],this._shape_format)||(this._shape_format=[n,s,e],this.activate(),this._gl.texImage2D(this._target,0,e,s,n,0,e,this._gl.UNSIGNED_BYTE,null)),this.u_shape=[n,s],null},o.prototype.set_data=function(t,e,n){var a,s,o,r,i,l,_,h,c,u,f;if(d(e.length,2)&&(e=[e[0],e[1],1]),this.activate(),r=this._shape_format[2],_=e,l=_[0],c=_[1],a=_[2],h=t,f=h[0],u=h[1],i=m.call(this._types,n.constructor.name,null),null===i)throw o=new Error("ValueError:"+("Type "+n.constructor.name+" not allowed for texture")),o.name="ValueError",o;return s=this._get_alignment(g(e[e.length-2],e[e.length-1])),d(s,4)||this._gl.pixelStorei(this._gl.UNPACK_ALIGNMENT,s),this._gl.texSubImage2D(this._target,0,u,f,c,l,r,i,n),d(s,4)||this._gl.pixelStorei(this._gl.UNPACK_ALIGNMENT,4),null},r=function(){p(this,arguments)},r.prototype=Object.create(o.prototype),r.prototype._base_class=o.prototype,r.prototype._class_name="Texture3DLike",r.prototype.GLSL_SAMPLE_NEAREST="\n        vec4 sample3D(sampler2D tex, vec3 texcoord, vec3 shape, vec2 tiles) {\n            shape.xyz = shape.zyx;  // silly row-major convention\n            float nrows = tiles.y, ncols = tiles.x;\n            // Don't let adjacent frames be interpolated into this one\n            texcoord.x = min(texcoord.x * shape.x, shape.x - 0.5);\n            texcoord.x = max(0.5, texcoord.x) / shape.x;\n            texcoord.y = min(texcoord.y * shape.y, shape.y - 0.5);\n            texcoord.y = max(0.5, texcoord.y) / shape.y;\n\n            float zindex = floor(texcoord.z * shape.z);\n\n            // Do a lookup in the 2D texture\n            float u = (mod(zindex, ncols) + texcoord.x) / ncols;\n            float v = (floor(zindex / ncols) + texcoord.y) / nrows;\n\n            return texture2D(tex, vec2(u,v));\n        }\n    ",r.prototype.GLSL_SAMPLE_LINEAR="\n        vec4 sample3D(sampler2D tex, vec3 texcoord, vec3 shape, vec2 tiles) {\n            shape.xyz = shape.zyx;  // silly row-major convention\n            float nrows = tiles.y, ncols = tiles.x;\n            // Don't let adjacent frames be interpolated into this one\n            texcoord.x = min(texcoord.x * shape.x, shape.x - 0.5);\n            texcoord.x = max(0.5, texcoord.x) / shape.x;\n            texcoord.y = min(texcoord.y * shape.y, shape.y - 0.5);\n            texcoord.y = max(0.5, texcoord.y) / shape.y;\n\n            float z = texcoord.z * shape.z;\n            float zindex1 = floor(z);\n            float u1 = (mod(zindex1, ncols) + texcoord.x) / ncols;\n            float v1 = (floor(zindex1 / ncols) + texcoord.y) / nrows;\n\n            float zindex2 = zindex1 + 1.0;\n            float u2 = (mod(zindex2, ncols) + texcoord.x) / ncols;\n            float v2 = (floor(zindex2 / ncols) + texcoord.y) / nrows;\n\n            vec4 s1 = texture2D(tex, vec2(u1, v1));\n            vec4 s2 = texture2D(tex, vec2(u2, v2));\n\n            return s1 * (zindex2 - z) + s2 * (z - zindex1);\n        }\n    ",r.prototype._get_tile_info=function(t){var e,n,a,s;if(n=this._gl.getParameter(this._gl.MAX_TEXTURE_SIZE),s=Math.floor(n/t[1]),s=Math.min(s,t[0]),a=window.Math.ceil(t[0]/s),v(g(a,t[2])>n))throw e=new Error("RuntimeError:"+("Cannot fit 3D data with shape "+t+" onto simulated 2D texture.")),e.name="RuntimeError",e;return[s,a]},r.prototype.set_size=function(t,e){var n,a,s,o;return o=this._get_tile_info(t),a=o[0],n=o[1],s=[g(t[1],a),g(t[2],n)],r.prototype._base_class.set_size.call(this,s,e),this.u_shape=[t[0],t[1],t[2]],this.u_tiles=[n,a],null},r.prototype.set_data=function(t,e,n){var a,s,o,i,l,_,h,c,f,p,v,y,m;if(d(e.length,3)&&(e=[e[0],e[1],e[2],1]),!u(function(){var e,n,a,s=[];for(n=t,"object"!=typeof n||Array.isArray(n)||(n=Object.keys(n)),a=0;a<n.length;a++)e=n[a],s.push(d(e,0));return s}.apply(this)))throw i=new Error("ValueError:Texture3DLike does not support nonzero offset (for now)"),i.name="ValueError",i;if(f=this._get_tile_info(e),_=f[0],l=f[1],c=[g(e[1],_),g(e[2],l),e[3]],d(l,1))r.prototype._base_class.set_data.call(this,[0,0],c,n);else for(a=n.constructor,m=new a(g(g(c[0],c[1]),c[2])),r.prototype._base_class.set_data.call(this,[0,0],c,m),y=0;y<e[0];y+=1)p=[Math.floor(y/l),y%l],h=p[0],s=p[1],o=Math.floor(n.length/e[0]),v=n.slice(g(y,o),g(y+1,o)),r.prototype._base_class.set_data.call(this,[g(h,e[1]),g(s,e[2])],e.slice(1),v);return null},{Buffer:t,GlooObject:n,IndexBuffer:a,Program:s,Texture2D:o,Texture3DLike:r,VertexBuffer:i,check_error:_,console:h}})}).call(this,"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}]},{},["models/glyphs/webgl/main"])}();/*
Copyright (c) 2012, Continuum Analytics, Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

Neither the name of Continuum Analytics nor the names of any contributors
may be used to endorse or promote products derived from this software
without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
THE POSSIBILITY OF SUCH DAMAGE.
*/
