(function(root, factory) {
//  if(typeof exports === 'object' && typeof module === 'object')
//    module.exports = factory();
//  else if(typeof define === 'function' && define.amd)
//    define("Bokeh", [], factory);
//  else if(typeof exports === 'object')
//    exports["Bokeh"] = factory();
//  else
    root["Bokeh"] = factory();
})(this, function() {
  var define;
  return (function(modules, aliases, entry) {
    var cache = {};

    var require = function(name) {
      var id = aliases[name] != null ? aliases[name] : name;

      if (!cache[id]) {
        if (!modules[id]) {
          var err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        var module = cache[id] = {exports: {}};
        modules[id].call(module.exports, require, module, module.exports);
      }

      return cache[id].exports;
    }

    var main = require(entry);
    main.require = require;

    main.register_plugin = function(plugin_modules, plugin_aliases, plugin_entry) {
      for (var name in plugin_modules) {
        modules[name] = plugin_modules[name];
      }

      for (var name in plugin_aliases) {
        aliases[name] = plugin_aliases[name];
      }

      var plugin = require(plugin_entry);

      for (var name in plugin) {
        main[name] = plugin[name];
      }

      return plugin;
    }

    return main;
  })
([
/*base*/
function _(require, module, exports) {
    var models = require(142    /* ./models/index */);
    var object_1 = require(32    /* ./core/util/object */);
    exports.overrides = {};
    var _all_models = object_1.clone(models);
    exports.Models = function (name) {
        var model = exports.overrides[name] || _all_models[name];
        if (model == null) {
            throw new Error('Model \'' + name + '\' does not exist. This could be due to a widget\n                     or a custom model not being registered before first usage.');
        }
        return model;
    };
    exports.Models.register = function (name, model) {
        exports.overrides[name] = model;
    };
    exports.Models.unregister = function (name) {
        delete exports.overrides[name];
    };
    exports.Models.register_models = function (models, force, errorFn) {
        if (force === void 0) {
            force = false;
        }
        if (models == null)
            return;
        for (var name_1 in models) {
            var model = models[name_1];
            if (force || !_all_models.hasOwnProperty(name_1))
                _all_models[name_1] = model;
            else if (errorFn != null)
                errorFn(name_1);
            else
                console.warn('Model \'' + name_1 + '\' was already registered');
        }
    };
    exports.register_models = exports.Models.register_models;
    exports.Models.registered_names = function () {
        return Object.keys(_all_models);
    };
    // "index" is a map from the toplevel model IDs rendered by
    // embed.ts, to the view objects for those models. It doesn't
    // contain all views, only those explicitly rendered to an element
    // by embed.ts.
    exports.index = {};    
},
/*client/connection*/
function _(require, module, exports) {
    var es6_promise_1 = require(319    /* es6-promise */);
    var logging_1 = require(14    /* core/logging */);
    var document_1 = require(50    /* document */);
    var message_1 = require(262    /* protocol/message */);
    var receiver_1 = require(263    /* protocol/receiver */);
    var session_1 = require(2    /* ./session */);
    exports.DEFAULT_SERVER_WEBSOCKET_URL = 'ws://localhost:5006/ws';
    exports.DEFAULT_SESSION_ID = 'default';
    var _connection_count = 0;
    var ClientConnection = function () {
        function ClientConnection(url, id, args_string, _on_have_session_hook, _on_closed_permanently_hook) {
            if (url === void 0) {
                url = exports.DEFAULT_SERVER_WEBSOCKET_URL;
            }
            if (id === void 0) {
                id = exports.DEFAULT_SESSION_ID;
            }
            if (args_string === void 0) {
                args_string = null;
            }
            if (_on_have_session_hook === void 0) {
                _on_have_session_hook = null;
            }
            if (_on_closed_permanently_hook === void 0) {
                _on_closed_permanently_hook = null;
            }
            this.url = url;
            this.id = id;
            this.args_string = args_string;
            this._on_have_session_hook = _on_have_session_hook;
            this._on_closed_permanently_hook = _on_closed_permanently_hook;
            this._number = _connection_count++;
            this.socket = null;
            this.session = null;
            this.closed_permanently = false;
            this._current_handler = null;
            this._pending_ack = null;
            // null or [resolve,reject]
            this._pending_replies = {};
            // map reqid to [resolve,reject]
            this._receiver = new receiver_1.Receiver();
            logging_1.logger.debug('Creating websocket ' + this._number + ' to \'' + this.url + '\' session \'' + this.id + '\'');
        }
        ClientConnection.prototype.connect = function () {
            var _this = this;
            if (this.closed_permanently)
                return es6_promise_1.Promise.reject(new Error('Cannot connect() a closed ClientConnection'));
            if (this.socket != null)
                return es6_promise_1.Promise.reject(new Error('Already connected'));
            this._pending_replies = {};
            this._current_handler = null;
            try {
                var versioned_url = this.url + '?bokeh-protocol-version=1.0&bokeh-session-id=' + this.id;
                if (this.args_string != null && this.args_string.length > 0)
                    versioned_url += '&' + this.args_string;
                this.socket = new WebSocket(versioned_url);
                return new es6_promise_1.Promise(function (resolve, reject) {
                    // "arraybuffer" gives us binary data we can look at;
                    // if we just needed an opaque blob we could use "blob"
                    _this.socket.binaryType = 'arraybuffer';
                    _this.socket.onopen = function () {
                        return _this._on_open(resolve, reject);
                    };
                    _this.socket.onmessage = function (event) {
                        return _this._on_message(event);
                    };
                    _this.socket.onclose = function (event) {
                        return _this._on_close(event);
                    };
                    _this.socket.onerror = function () {
                        return _this._on_error(reject);
                    };
                });
            } catch (error) {
                logging_1.logger.error('websocket creation failed to url: ' + this.url);
                logging_1.logger.error(' - ' + error);
                return es6_promise_1.Promise.reject(error);
            }
        };
        ClientConnection.prototype.close = function () {
            if (!this.closed_permanently) {
                logging_1.logger.debug('Permanently closing websocket connection ' + this._number);
                this.closed_permanently = true;
                if (this.socket != null)
                    this.socket.close(1000, 'close method called on ClientConnection ' + this._number);
                this.session._connection_closed();
                if (this._on_closed_permanently_hook != null) {
                    this._on_closed_permanently_hook();
                    this._on_closed_permanently_hook = null;
                }
            }
        };
        ClientConnection.prototype._schedule_reconnect = function (milliseconds) {
            var _this = this;
            var retry = function () {
                // TODO commented code below until we fix reconnection to repull
                // the document when required. Otherwise, we get a lot of
                // confusing errors that are causing trouble when debugging.
                /*
            if (this.closed_permanently) {
            */
                if (!_this.closed_permanently)
                    logging_1.logger.info('Websocket connection ' + _this._number + ' disconnected, will not attempt to reconnect');
                return;    /*
            } else {
              logger.debug(`Attempting to reconnect websocket ${this._number}`)
              this.connect()
            }
            */
            };
            setTimeout(retry, milliseconds);
        };
        ClientConnection.prototype.send = function (message) {
            if (this.socket == null)
                throw new Error('not connected so cannot send ' + message);
            message.send(this.socket);
        };
        ClientConnection.prototype.send_with_reply = function (message) {
            var _this = this;
            var promise = new es6_promise_1.Promise(function (resolve, reject) {
                _this._pending_replies[message.msgid()] = [
                    resolve,
                    reject
                ];
                _this.send(message);
            });
            return promise.then(function (message) {
                if (message.msgtype() === 'ERROR')
                    throw new Error('Error reply ' + message.content['text']);
                else
                    return message;
            }, function (error) {
                throw error;
            });
        };
        ClientConnection.prototype._pull_doc_json = function () {
            var message = message_1.Message.create('PULL-DOC-REQ', {});
            var promise = this.send_with_reply(message);
            return promise.then(function (reply) {
                if (!('doc' in reply.content))
                    throw new Error('No \'doc\' field in PULL-DOC-REPLY');
                return reply.content['doc'];
            }, function (error) {
                throw error;
            });
        };
        ClientConnection.prototype._repull_session_doc = function () {
            var _this = this;
            if (this.session == null)
                logging_1.logger.debug('Pulling session for first time');
            else
                logging_1.logger.debug('Repulling session');
            this._pull_doc_json().then(function (doc_json) {
                if (_this.session == null) {
                    if (_this.closed_permanently)
                        logging_1.logger.debug('Got new document after connection was already closed');
                    else {
                        var document_2 = document_1.Document.from_json(doc_json);
                        // Constructing models changes some of their attributes, we deal with that
                        // here. This happens when models set attributes during construction
                        // or initialization.
                        var patch = document_1.Document._compute_patch_since_json(doc_json, document_2);
                        if (patch.events.length > 0) {
                            logging_1.logger.debug('Sending ' + patch.events.length + ' changes from model construction back to server');
                            var patch_message = message_1.Message.create('PATCH-DOC', {}, patch);
                            _this.send(patch_message);
                        }
                        _this.session = new session_1.ClientSession(_this, document_2, _this.id);
                        logging_1.logger.debug('Created a new session from new pulled doc');
                        if (_this._on_have_session_hook != null) {
                            _this._on_have_session_hook(_this.session);
                            _this._on_have_session_hook = null;
                        }
                    }
                } else {
                    _this.session.document.replace_with_json(doc_json);
                    logging_1.logger.debug('Updated existing session with new pulled doc');
                }
            }, function (error) {
                // handling the error here is useless because we wouldn't
                // get errors from the resolve handler above, so see
                // the catch below instead
                throw error;
            }).catch(function (error) {
                if (console.trace != null)
                    console.trace(error);
                logging_1.logger.error('Failed to repull session ' + error);
            });
        };
        ClientConnection.prototype._on_open = function (resolve, reject) {
            var _this = this;
            logging_1.logger.info('Websocket connection ' + this._number + ' is now open');
            this._pending_ack = [
                resolve,
                reject
            ];
            this._current_handler = function (message) {
                _this._awaiting_ack_handler(message);
            };
        };
        ClientConnection.prototype._on_message = function (event) {
            if (this._current_handler == null)
                logging_1.logger.error('Got a message with no current handler set');
            try {
                this._receiver.consume(event.data);
            } catch (e) {
                this._close_bad_protocol(e.toString());
            }
            if (this._receiver.message == null)
                return;
            var msg = this._receiver.message;
            var problem = msg.problem();
            if (problem != null)
                this._close_bad_protocol(problem);
            this._current_handler(msg);
        };
        ClientConnection.prototype._on_close = function (event) {
            var _this = this;
            logging_1.logger.info('Lost websocket ' + this._number + ' connection, ' + event.code + ' (' + event.reason + ')');
            this.socket = null;
            if (this._pending_ack != null) {
                this._pending_ack[1](new Error('Lost websocket connection, ' + event.code + ' (' + event.reason + ')'));
                this._pending_ack = null;
            }
            var pop_pending = function () {
                for (var reqid in _this._pending_replies) {
                    var promise_funcs_1 = _this._pending_replies[reqid];
                    delete _this._pending_replies[reqid];
                    return promise_funcs_1;
                }
                return null;
            };
            var promise_funcs = pop_pending();
            while (promise_funcs != null) {
                promise_funcs[1]('Disconnected');
                promise_funcs = pop_pending();
            }
            if (!this.closed_permanently)
                this._schedule_reconnect(2000);
        };
        ClientConnection.prototype._on_error = function (reject) {
            logging_1.logger.debug('Websocket error on socket ' + this._number);
            reject(new Error('Could not open websocket'));
        };
        ClientConnection.prototype._close_bad_protocol = function (detail) {
            logging_1.logger.error('Closing connection: ' + detail);
            if (this.socket != null)
                this.socket.close(1002, detail);    // 1002 = protocol error
        };
        ClientConnection.prototype._awaiting_ack_handler = function (message) {
            var _this = this;
            if (message.msgtype() === 'ACK') {
                this._current_handler = function (message) {
                    return _this._steady_state_handler(message);
                };
                // Reload any sessions
                // TODO (havocp) there's a race where we might get a PATCH before
                // we send and get a reply to our pulls.
                this._repull_session_doc();
                if (this._pending_ack != null) {
                    this._pending_ack[0](this);
                    this._pending_ack = null;
                }
            } else
                this._close_bad_protocol('First message was not an ACK');
        };
        ClientConnection.prototype._steady_state_handler = function (message) {
            if (message.reqid() in this._pending_replies) {
                var promise_funcs = this._pending_replies[message.reqid()];
                delete this._pending_replies[message.reqid()];
                promise_funcs[0](message);
            } else
                this.session.handle(message);
        };
        return ClientConnection;
    }();
    exports.ClientConnection = ClientConnection;
    // Returns a promise of a ClientSession
    // The returned promise has a close() method in case you want to close before
    // getting a session; session.close() works too once you have a session.
    function pull_session(url, session_id, args_string) {
        var connection;
        var promise = new es6_promise_1.Promise(function (resolve, reject) {
            connection = new ClientConnection(url, session_id, args_string, function (session) {
                try {
                    resolve(session);
                } catch (error) {
                    logging_1.logger.error('Promise handler threw an error, closing session ' + error);
                    session.close();
                    throw error;
                }
            }, function () {
                // we rely on reject() as a no-op if we already resolved
                reject(new Error('Connection was closed before we successfully pulled a session'));
            });
            return connection.connect().then(function (_) {
                return undefined;
            }, function (error) {
                logging_1.logger.error('Failed to connect to Bokeh server ' + error);
                throw error;
            });
        });
        /*
    // add a "close" method to the promise... too weird?
    promise.close = () => {
      connection.close()
    }
    */
        return promise;
    }
    exports.pull_session = pull_session;    
},
/*client/session*/
function _(require, module, exports) {
    var logging_1 = require(14    /* core/logging */);
    var document_1 = require(50    /* document */);
    var message_1 = require(262    /* protocol/message */);
    var ClientSession = function () {
        function ClientSession(_connection, document, id) {
            var _this = this;
            this._connection = _connection;
            this.document = document;
            this.id = id;
            this._document_listener = function (event) {
                return _this._document_changed(event);
            };
            this.document.on_change(this._document_listener);
            this.event_manager = this.document.event_manager;
            this.event_manager.session = this;
        }
        ClientSession.prototype.handle = function (message) {
            var msgtype = message.msgtype();
            if (msgtype === 'PATCH-DOC')
                this._handle_patch(message);
            else if (msgtype === 'OK')
                this._handle_ok(message);
            else if (msgtype === 'ERROR')
                this._handle_error(message);
            else
                logging_1.logger.debug('Doing nothing with message ' + message.msgtype());
        };
        ClientSession.prototype.close = function () {
            this._connection.close();
        };
        ClientSession.prototype.send_event = function (event) {
            var message = message_1.Message.create('EVENT', {}, JSON.stringify(event));
            this._connection.send(message);
        };
        /*protected*/
        ClientSession.prototype._connection_closed = function () {
            this.document.remove_on_change(this._document_listener);
        };
        // Sends a request to the server for info about the server, such as its Bokeh
        // version. Returns a promise, the value of the promise is a free-form dictionary
        // of server details.
        ClientSession.prototype.request_server_info = function () {
            var message = message_1.Message.create('SERVER-INFO-REQ', {});
            var promise = this._connection.send_with_reply(message);
            return promise.then(function (reply) {
                return reply.content;
            });
        };
        // Sends some request to the server (no guarantee about which one) and returns
        // a promise which is completed when the server replies. The purpose of this
        // is that if you wait for the promise to be completed, you know the server
        // has processed the request. This is useful when writing tests because once
        // the server has processed this request it should also have processed any
        // events or requests you sent previously, which means you can check for the
        // results of that processing without a race condition. (This assumes the
        // server processes events in sequence, which it mostly has to semantically,
        // since reordering events might change the final state.)
        ClientSession.prototype.force_roundtrip = function () {
            return this.request_server_info().then(function (_) {
                return undefined;
            });
        };
        ClientSession.prototype._document_changed = function (event) {
            // Filter out events that were initiated by the ClientSession itself
            if (event.setter_id === this.id)
                return;
            // Filter out changes to attributes that aren't server-visible
            if (event instanceof document_1.ModelChangedEvent && !(event.attr in event.model.serializable_attributes()))
                return;
            // TODO (havocp) the connection may be closed here, which will
            // cause this send to throw an error - need to deal with it more cleanly.
            var message = message_1.Message.create('PATCH-DOC', {}, this.document.create_json_patch([event]));
            this._connection.send(message);
        };
        ClientSession.prototype._handle_patch = function (message) {
            this.document.apply_json_patch(message.content, message.buffers, this.id);
        };
        ClientSession.prototype._handle_ok = function (message) {
            logging_1.logger.trace('Unhandled OK reply to ' + message.reqid());
        };
        ClientSession.prototype._handle_error = function (message) {
            logging_1.logger.error('Unhandled ERROR reply to ' + message.reqid() + ': ' + message.content['text']);
        };
        return ClientSession;
    }();
    exports.ClientSession = ClientSession;    
},
/*core/bokeh_events*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var logging_1 = require(14    /* ./logging */);
    var object_1 = require(32    /* ./util/object */);
    var event_classes = {};
    function register_event_class(event_name) {
        return function (event_cls) {
            event_cls.prototype.event_name = event_name;
            event_classes[event_name] = event_cls;
        };
    }
    exports.register_event_class = register_event_class;
    function register_with_event(event_cls) {
        var models = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            models[_i - 1] = arguments[_i];
        }
        var applicable_models = event_cls.prototype.applicable_models.concat(models);
        event_cls.prototype.applicable_models = applicable_models;
    }
    exports.register_with_event = register_with_event;
    var BokehEvent = function () {
        function BokehEvent(options) {
            if (options === void 0) {
                options = {};
            }
            this.model_id = null;
            this._options = options;
            if (options.model_id) {
                this.model_id = options.model_id;
            }
        }
        BokehEvent.prototype.set_model_id = function (id) {
            this._options.model_id = id;
            this.model_id = id;
            return this;
        };
        BokehEvent.prototype.is_applicable_to = function (obj) {
            return this.applicable_models.some(function (model) {
                return obj instanceof model;
            });
        };
        BokehEvent.event_class = function (e) {
            // Given an event with a type attribute matching the event_name,
            // return the appropriate BokehEvent class
            if (e.type) {
                return event_classes[e.type];
            } else {
                logging_1.logger.warn('BokehEvent.event_class required events with a string type attribute');
            }
        };
        BokehEvent.prototype.toJSON = function () {
            return {
                event_name: this.event_name,
                event_values: object_1.clone(this._options)
            };
        };
        BokehEvent.prototype._customize_event = function (_model) {
            return this;
        };
        return BokehEvent;
    }();
    exports.BokehEvent = BokehEvent;
    BokehEvent.prototype.applicable_models = [];
    var ButtonClick = function (_super) {
        tslib_1.__extends(ButtonClick, _super);
        function ButtonClick() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ButtonClick = tslib_1.__decorate([register_event_class('button_click')], ButtonClick);
        return ButtonClick;
    }(BokehEvent);
    exports.ButtonClick = ButtonClick;
    // A UIEvent is an event originating on a PlotCanvas this includes
    // DOM events such as keystrokes as well as hammer events and LOD events.
    var UIEvent = function (_super) {
        tslib_1.__extends(UIEvent, _super);
        function UIEvent() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return UIEvent;
    }(BokehEvent);
    exports.UIEvent = UIEvent;
    var LODStart = function (_super) {
        tslib_1.__extends(LODStart, _super);
        function LODStart() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LODStart = tslib_1.__decorate([register_event_class('lodstart')], LODStart);
        return LODStart;
    }(UIEvent);
    exports.LODStart = LODStart;
    var LODEnd = function (_super) {
        tslib_1.__extends(LODEnd, _super);
        function LODEnd() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LODEnd = tslib_1.__decorate([register_event_class('lodend')], LODEnd);
        return LODEnd;
    }(UIEvent);
    exports.LODEnd = LODEnd;
    var SelectionGeometry = function (_super) {
        tslib_1.__extends(SelectionGeometry, _super);
        function SelectionGeometry(options) {
            var _this = _super.call(this, options) || this;
            _this.geometry = options.geometry;
            _this.final = options.final;
            return _this;
        }
        SelectionGeometry = tslib_1.__decorate([register_event_class('selectiongeometry')], SelectionGeometry);
        return SelectionGeometry;
    }(UIEvent);
    exports.SelectionGeometry = SelectionGeometry;
    var Reset = function (_super) {
        tslib_1.__extends(Reset, _super);
        function Reset() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Reset = tslib_1.__decorate([register_event_class('reset')], Reset);
        return Reset;
    }(UIEvent);
    exports.Reset = Reset;
    var PointEvent = function (_super) {
        tslib_1.__extends(PointEvent, _super);
        function PointEvent(options) {
            var _this = _super.call(this, options) || this;
            _this.sx = options.sx;
            _this.sy = options.sy;
            _this.x = null;
            _this.y = null;
            return _this;
        }
        PointEvent.from_event = function (e, model_id) {
            if (model_id === void 0) {
                model_id = null;
            }
            return new this({
                sx: e.sx,
                sy: e.sy,
                model_id: model_id
            });
        };
        PointEvent.prototype._customize_event = function (plot) {
            var xscale = plot.plot_canvas.frame.xscales['default'];
            var yscale = plot.plot_canvas.frame.yscales['default'];
            this.x = xscale.invert(this.sx);
            this.y = yscale.invert(this.sy);
            this._options['x'] = this.x;
            this._options['y'] = this.y;
            return this;
        };
        return PointEvent;
    }(UIEvent);
    exports.PointEvent = PointEvent;
    var Pan = function (_super) {
        tslib_1.__extends(Pan, _super);
        function Pan(options) {
            if (options === void 0) {
                options = {};
            }
            var _this = _super.call(this, options) || this;
            _this.delta_x = options.delta_x;
            _this.delta_y = options.delta_y;
            return _this;
        }
        Pan.from_event = function (e, model_id) {
            if (model_id === void 0) {
                model_id = null;
            }
            return new this({
                sx: e.sx,
                sy: e.sy,
                delta_x: e.deltaX,
                delta_y: e.deltaY,
                direction: e.direction,
                model_id: model_id
            });
        };
        Pan = tslib_1.__decorate([register_event_class('pan')], Pan);
        return Pan;
    }(PointEvent);
    exports.Pan = Pan;
    var Pinch = function (_super) {
        tslib_1.__extends(Pinch, _super);
        function Pinch(options) {
            if (options === void 0) {
                options = {};
            }
            var _this = _super.call(this, options) || this;
            _this.scale = options.scale;
            return _this;
        }
        Pinch.from_event = function (e, model_id) {
            if (model_id === void 0) {
                model_id = null;
            }
            return new this({
                sx: e.sx,
                sy: e.sy,
                scale: e.scale,
                model_id: model_id
            });
        };
        Pinch = tslib_1.__decorate([register_event_class('pinch')], Pinch);
        return Pinch;
    }(PointEvent);
    exports.Pinch = Pinch;
    var MouseWheel = function (_super) {
        tslib_1.__extends(MouseWheel, _super);
        function MouseWheel(options) {
            if (options === void 0) {
                options = {};
            }
            var _this = _super.call(this, options) || this;
            _this.delta = options.delta;
            return _this;
        }
        MouseWheel.from_event = function (e, model_id) {
            if (model_id === void 0) {
                model_id = null;
            }
            return new this({
                sx: e.sx,
                sy: e.sy,
                delta: e.delta,
                model_id: model_id
            });
        };
        MouseWheel = tslib_1.__decorate([register_event_class('wheel')], MouseWheel);
        return MouseWheel;
    }(PointEvent);
    exports.MouseWheel = MouseWheel;
    var MouseMove = function (_super) {
        tslib_1.__extends(MouseMove, _super);
        function MouseMove() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MouseMove = tslib_1.__decorate([register_event_class('mousemove')], MouseMove);
        return MouseMove;
    }(PointEvent);
    exports.MouseMove = MouseMove;
    var MouseEnter = function (_super) {
        tslib_1.__extends(MouseEnter, _super);
        function MouseEnter() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MouseEnter = tslib_1.__decorate([register_event_class('mouseenter')], MouseEnter);
        return MouseEnter;
    }(PointEvent);
    exports.MouseEnter = MouseEnter;
    var MouseLeave = function (_super) {
        tslib_1.__extends(MouseLeave, _super);
        function MouseLeave() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MouseLeave = tslib_1.__decorate([register_event_class('mouseleave')], MouseLeave);
        return MouseLeave;
    }(PointEvent);
    exports.MouseLeave = MouseLeave;
    var Tap = function (_super) {
        tslib_1.__extends(Tap, _super);
        function Tap() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Tap = tslib_1.__decorate([register_event_class('tap')], Tap);
        return Tap;
    }(PointEvent);
    exports.Tap = Tap;
    var DoubleTap = function (_super) {
        tslib_1.__extends(DoubleTap, _super);
        function DoubleTap() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        DoubleTap = tslib_1.__decorate([register_event_class('doubletap')], DoubleTap);
        return DoubleTap;
    }(PointEvent);
    exports.DoubleTap = DoubleTap;
    var Press = function (_super) {
        tslib_1.__extends(Press, _super);
        function Press() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Press = tslib_1.__decorate([register_event_class('press')], Press);
        return Press;
    }(PointEvent);
    exports.Press = Press;
    var PanStart = function (_super) {
        tslib_1.__extends(PanStart, _super);
        function PanStart() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PanStart = tslib_1.__decorate([register_event_class('panstart')], PanStart);
        return PanStart;
    }(PointEvent);
    exports.PanStart = PanStart;
    var PanEnd = function (_super) {
        tslib_1.__extends(PanEnd, _super);
        function PanEnd() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PanEnd = tslib_1.__decorate([register_event_class('panend')], PanEnd);
        return PanEnd;
    }(PointEvent);
    exports.PanEnd = PanEnd;
    var PinchStart = function (_super) {
        tslib_1.__extends(PinchStart, _super);
        function PinchStart() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PinchStart = tslib_1.__decorate([register_event_class('pinchstart')], PinchStart);
        return PinchStart;
    }(PointEvent);
    exports.PinchStart = PinchStart;
    var PinchEnd = function (_super) {
        tslib_1.__extends(PinchEnd, _super);
        function PinchEnd() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PinchEnd = tslib_1.__decorate([register_event_class('pinchend')], PinchEnd);
        return PinchEnd;
    }(PointEvent);
    exports.PinchEnd = PinchEnd;    
},
/*core/build_views*/
function _(require, module, exports) {
    var array_1 = require(21    /* ./util/array */);
    var object_1 = require(32    /* ./util/object */);
    function build_views(view_storage, models, options, cls) {
        if (cls === void 0) {
            cls = function (model) {
                return model.default_view;
            };
        }
        var to_remove = array_1.difference(Object.keys(view_storage), models.map(function (model) {
            return model.id;
        }));
        for (var _i = 0, to_remove_1 = to_remove; _i < to_remove_1.length; _i++) {
            var model_id = to_remove_1[_i];
            view_storage[model_id].remove();
            delete view_storage[model_id];
        }
        var created_views = [];
        var new_models = models.filter(function (model) {
            return view_storage[model.id] == null;
        });
        for (var _a = 0, new_models_1 = new_models; _a < new_models_1.length; _a++) {
            var model = new_models_1[_a];
            var view_cls = cls(model);
            var view_options = object_1.extend({}, options, {
                model: model,
                connect_signals: false
            });
            var view = new view_cls(view_options);
            view_storage[model.id] = view;
            created_views.push(view);
        }
        for (var _b = 0, created_views_1 = created_views; _b < created_views_1.length; _b++) {
            var view = created_views_1[_b];
            view.connect_signals();
        }
        return created_views;
    }
    exports.build_views = build_views;
    function remove_views(view_storage) {
        for (var id in view_storage) {
            view_storage[id].remove();
            delete view_storage[id];
        }
    }
    exports.remove_views = remove_views;    
},
/*core/dom*/
function _(require, module, exports) {
    var types_1 = require(44    /* ./util/types */);
    var _createElement = function (tag) {
        return function (attrs) {
            if (attrs === void 0) {
                attrs = {};
            }
            var children = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                children[_i - 1] = arguments[_i];
            }
            var element = document.createElement(tag);
            for (var attr in attrs) {
                var value = attrs[attr];
                if (value == null || types_1.isBoolean(value) && !value)
                    continue;
                if (attr === 'class' && types_1.isArray(value)) {
                    for (var _a = 0, _b = value; _a < _b.length; _a++) {
                        var cls = _b[_a];
                        if (cls != null)
                            element.classList.add(cls);
                    }
                    continue;
                }
                if (attr === 'style' && types_1.isObject(value)) {
                    for (var prop in value) {
                        element.style[prop] = value[prop];
                    }
                    continue;
                }
                if (attr === 'data' && types_1.isObject(value)) {
                    for (var key in value) {
                        element.dataset[key] = value[key];
                    }
                    continue;
                }
                element.setAttribute(attr, value);
            }
            function append(child) {
                if (child instanceof HTMLElement)
                    element.appendChild(child);
                else if (types_1.isString(child))
                    element.appendChild(document.createTextNode(child));
                else if (child != null && child !== false)
                    throw new Error('expected an HTMLElement, string, false or null, got ' + JSON.stringify(child));
            }
            for (var _c = 0, children_1 = children; _c < children_1.length; _c++) {
                var child = children_1[_c];
                if (types_1.isArray(child)) {
                    for (var _d = 0, child_1 = child; _d < child_1.length; _d++) {
                        var _child = child_1[_d];
                        append(_child);
                    }
                } else
                    append(child);
            }
            return element;
        };
    };
    function createElement(tag, attrs) {
        var children = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            children[_i - 2] = arguments[_i];
        }
        return _createElement(tag).apply(void 0, [attrs].concat(children));
    }
    exports.createElement = createElement;
    exports.div = _createElement('div'), exports.span = _createElement('span'), exports.link = _createElement('link'), exports.style = _createElement('style'), exports.a = _createElement('a'), exports.p = _createElement('p'), exports.i = _createElement('i'), exports.pre = _createElement('pre'), exports.button = _createElement('button'), exports.label = _createElement('label'), exports.input = _createElement('input'), exports.select = _createElement('select'), exports.option = _createElement('option'), exports.optgroup = _createElement('optgroup'), exports.textarea = _createElement('textarea'), exports.canvas = _createElement('canvas'), exports.ul = _createElement('ul'), exports.ol = _createElement('ol'), exports.li = _createElement('li');
    exports.nbsp = document.createTextNode('\xA0');
    function removeElement(element) {
        var parent = element.parentNode;
        if (parent != null) {
            parent.removeChild(element);
        }
    }
    exports.removeElement = removeElement;
    function replaceWith(element, replacement) {
        var parent = element.parentNode;
        if (parent != null) {
            parent.replaceChild(replacement, element);
        }
    }
    exports.replaceWith = replaceWith;
    function prepend(element) {
        var nodes = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            nodes[_i - 1] = arguments[_i];
        }
        var first = element.firstChild;
        for (var _a = 0, nodes_1 = nodes; _a < nodes_1.length; _a++) {
            var node = nodes_1[_a];
            element.insertBefore(node, first);
        }
    }
    exports.prepend = prepend;
    function empty(element) {
        var child;
        while (child = element.firstChild) {
            element.removeChild(child);
        }
    }
    exports.empty = empty;
    function show(element) {
        element.style.display = '';
    }
    exports.show = show;
    function hide(element) {
        element.style.display = 'none';
    }
    exports.hide = hide;
    function position(element) {
        return {
            top: element.offsetTop,
            left: element.offsetLeft
        };
    }
    exports.position = position;
    function offset(element) {
        var rect = element.getBoundingClientRect();
        return {
            top: rect.top + window.pageYOffset - document.documentElement.clientTop,
            left: rect.left + window.pageXOffset - document.documentElement.clientLeft
        };
    }
    exports.offset = offset;
    function matches(el, selector) {
        var p = Element.prototype;
        var f = p.matches || p.webkitMatchesSelector || p.mozMatchesSelector || p.msMatchesSelector;
        return f.call(el, selector);
    }
    exports.matches = matches;
    function parent(el, selector) {
        var node = el;
        while (node = node.parentElement) {
            if (matches(node, selector))
                return node;
        }
        return null;
    }
    exports.parent = parent;
    function margin(el) {
        var style = getComputedStyle(el);
        return {
            top: parseFloat(style.marginTop) || 0,
            bottom: parseFloat(style.marginBottom) || 0,
            left: parseFloat(style.marginLeft) || 0,
            right: parseFloat(style.marginRight) || 0
        };
    }
    exports.margin = margin;
    function padding(el) {
        var style = getComputedStyle(el);
        return {
            top: parseFloat(style.paddingTop) || 0,
            bottom: parseFloat(style.paddingBottom) || 0,
            left: parseFloat(style.paddingLeft) || 0,
            right: parseFloat(style.paddingRight) || 0
        };
    }
    exports.padding = padding;
    var Keys;
    (function (Keys) {
        Keys[Keys['Backspace'] = 8] = 'Backspace';
        Keys[Keys['Tab'] = 9] = 'Tab';
        Keys[Keys['Enter'] = 13] = 'Enter';
        Keys[Keys['Esc'] = 27] = 'Esc';
        Keys[Keys['PageUp'] = 33] = 'PageUp';
        Keys[Keys['PageDown'] = 34] = 'PageDown';
        Keys[Keys['Left'] = 37] = 'Left';
        Keys[Keys['Up'] = 38] = 'Up';
        Keys[Keys['Right'] = 39] = 'Right';
        Keys[Keys['Down'] = 40] = 'Down';
        Keys[Keys['Delete'] = 46] = 'Delete';
    }(Keys = exports.Keys || (exports.Keys = {})));    
},
/*core/dom_view*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var view_1 = require(48    /* ./view */);
    var DOM = require(5    /* ./dom */);
    var DOMView = function (_super) {
        tslib_1.__extends(DOMView, _super);
        function DOMView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        DOMView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this._has_finished = false;
            this.el = this._createElement();
        };
        DOMView.prototype.remove = function () {
            DOM.removeElement(this.el);
            _super.prototype.remove.call(this);
        };
        DOMView.prototype.css_classes = function () {
            return [];
        };
        Object.defineProperty(DOMView.prototype, 'cursor', {
            get: function () {
                return null;
            },
            enumerable: true,
            configurable: true
        });
        DOMView.prototype.layout = function () {
        };
        DOMView.prototype.render = function () {
        };
        DOMView.prototype.renderTo = function (element, replace) {
            if (replace === void 0) {
                replace = false;
            }
            if (!replace)
                element.appendChild(this.el);
            else
                DOM.replaceWith(element, this.el);
            this.layout();
        };
        DOMView.prototype.has_finished = function () {
            return this._has_finished;
        };
        Object.defineProperty(DOMView.prototype, '_root_element', {
            get: function () {
                return DOM.parent(this.el, '.bk-root') || document.body;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(DOMView.prototype, 'solver', {
            get: function () {
                return this.is_root ? this._solver : this.parent.solver;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(DOMView.prototype, 'is_idle', {
            get: function () {
                return this.has_finished();
            },
            enumerable: true,
            configurable: true
        });
        DOMView.prototype._createElement = function () {
            return DOM.createElement(this.tagName, {
                id: this.id,
                class: this.css_classes()
            });
        };
        return DOMView;
    }(view_1.View);
    exports.DOMView = DOMView;
    DOMView.prototype.tagName = 'div';    
},
/*core/enums*/
function _(require, module, exports) {
    exports.AngleUnits = [
        'deg',
        'rad'
    ];
    exports.Dimension = [
        'width',
        'height'
    ];
    exports.Dimensions = [
        'width',
        'height',
        'both'
    ];
    exports.Direction = [
        'clock',
        'anticlock'
    ];
    exports.FontStyle = [
        'normal',
        'italic',
        'bold'
    ];
    exports.LatLon = [
        'lat',
        'lon'
    ];
    exports.LineCap = [
        'butt',
        'round',
        'square'
    ];
    exports.LineJoin = [
        'miter',
        'round',
        'bevel'
    ];
    exports.Location = [
        'above',
        'below',
        'left',
        'right'
    ];
    exports.LegendClickPolicy = [
        'none',
        'hide',
        'mute'
    ];
    exports.LegendLocation = [
        'top_left',
        'top_center',
        'top_right',
        'center_left',
        'center',
        'center_right',
        'bottom_left',
        'bottom_center',
        'bottom_right'
    ];
    exports.Anchor = exports.LegendLocation;
    exports.Orientation = [
        'vertical',
        'horizontal'
    ];
    exports.OutputBackend = [
        'canvas',
        'svg',
        'webgl'
    ];
    exports.RenderLevel = [
        'image',
        'underlay',
        'glyph',
        'annotation',
        'overlay'
    ];
    exports.RenderMode = [
        'canvas',
        'css'
    ];
    exports.Side = [
        'above',
        'below',
        'left',
        'right'
    ];
    exports.Place = [
        'above',
        'below',
        'left',
        'right',
        'center'
    ];
    exports.SpatialUnits = [
        'screen',
        'data'
    ];
    exports.StartEnd = [
        'start',
        'end'
    ];
    exports.VerticalAlign = [
        'top',
        'middle',
        'bottom'
    ];
    exports.TextAlign = [
        'left',
        'right',
        'center'
    ];
    exports.TextBaseline = [
        'top',
        'middle',
        'bottom',
        'alphabetic',
        'hanging',
        'ideographic'
    ];
    exports.TickLabelOrientation = [
        'vertical',
        'horizontal',
        'parallel',
        'normal'
    ];
    exports.TooltipAttachment = [
        'horizontal',
        'vertical',
        'left',
        'right',
        'above',
        'below'
    ];
    exports.Distribution = [
        'uniform',
        'normal'
    ];
    exports.StepMode = [
        'after',
        'before',
        'center'
    ];
    exports.SizingMode = [
        'stretch_both',
        'scale_width',
        'scale_height',
        'scale_both',
        'fixed'
    ];
    exports.PaddingUnits = [
        'percent',
        'absolute'
    ];
    exports.SliderCallbackPolicy = [
        'continuous',
        'throttle',
        'mouseup'
    ];
    exports.RoundingFunction = [
        'round',
        'nearest',
        'floor',
        'rounddown',
        'ceil',
        'roundup'
    ];
    exports.UpdateMode = [
        'replace',
        'append'
    ];
    exports.HTTPMethod = [
        'POST',
        'GET'
    ];
    exports.Logo = [
        'normal',
        'grey'
    ];    
},
/*core/has_props*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var signaling_1 = require(19    /* ./signaling */);
    var property_mixins = require(16    /* ./property_mixins */);
    var refs_1 = require(34    /* ./util/refs */);
    var p = require(15    /* ./properties */);
    var string_1 = require(38    /* ./util/string */);
    var array_1 = require(21    /* ./util/array */);
    var object_1 = require(32    /* ./util/object */);
    var types_1 = require(44    /* ./util/types */);
    var eq_1 = require(30    /* ./util/eq */);
    var HasProps = function (_super) {
        tslib_1.__extends(HasProps, _super);
        function HasProps(attrs) {
            if (attrs === void 0) {
                attrs = {};
            }
            var _this = _super.call(this) || this;
            _this._subtype = undefined;
            _this.document = null;
            _this.destroyed = new signaling_1.Signal0(_this, 'destroyed');
            _this.change = new signaling_1.Signal0(_this, 'change');
            _this.transformchange = new signaling_1.Signal0(_this, 'transformchange');
            _this.attributes = {};
            _this.properties = {};
            _this._set_after_defaults = {};
            _this._pending = false;
            _this._changing = false;
            for (var name_1 in _this.props) {
                var _a = _this.props[name_1], type = _a.type, default_value = _a.default_value;
                if (type != null)
                    _this.properties[name_1] = new type(_this, name_1, default_value);
                else
                    throw new Error('undefined property type for ' + _this.type + '.' + name_1);
            }
            // auto generating ID
            if (attrs.id == null)
                _this.setv({ id: string_1.uniqueId() }, { silent: true });
            var deferred = attrs.__deferred__ || false;
            if (deferred) {
                attrs = object_1.clone(attrs);
                delete attrs.__deferred__;
            }
            _this.setv(attrs, { silent: true });
            // allowing us to defer initialization when loading many models
            // when loading a bunch of models, we want to do initialization as a second pass
            // because other objects that this one depends on might not be loaded yet
            if (!deferred)
                _this.finalize();
            return _this;
        }
        HasProps.initClass = function () {
            this.prototype.type = 'HasProps';
            this.prototype.props = {};
            this.prototype.mixins = [];
            this.define({ id: [p.Any] });
        };
        // }}}
        HasProps._fix_default = function (default_value, _attr) {
            if (default_value === undefined)
                return undefined;
            else if (types_1.isFunction(default_value))
                return default_value;
            else if (!types_1.isObject(default_value))
                return function () {
                    return default_value;
                };
            else {
                //logger.warn(`${this.prototype.type}.${attr} uses unwrapped non-primitive default value`)
                if (types_1.isArray(default_value))
                    return function () {
                        return array_1.copy(default_value);
                    };
                else
                    return function () {
                        return object_1.clone(default_value);
                    };
            }
        };
        HasProps.define = function (obj) {
            var _loop_1 = function (name_2) {
                var prop = obj[name_2];
                if (this_1.prototype.props[name_2] != null)
                    throw new Error('attempted to redefine property \'' + this_1.prototype.type + '.' + name_2 + '\'');
                if (this_1.prototype[name_2] != null)
                    throw new Error('attempted to redefine attribute \'' + this_1.prototype.type + '.' + name_2 + '\'');
                Object.defineProperty(this_1.prototype, name_2, {
                    // XXX: don't use tail calls in getters/setters due to https://bugs.webkit.org/show_bug.cgi?id=164306
                    get: function () {
                        var value = this.getv(name_2);
                        return value;
                    },
                    set: function (value) {
                        this.setv((_a = {}, _a[name_2] = value, _a));
                        return this;
                        var _a;
                    },
                    configurable: false,
                    enumerable: true
                });
                var type = prop[0], default_value = prop[1], internal = prop[2];
                var refined_prop = {
                    type: type,
                    default_value: this_1._fix_default(default_value, name_2),
                    internal: internal || false
                };
                var props = object_1.clone(this_1.prototype.props);
                props[name_2] = refined_prop;
                this_1.prototype.props = props;
            };
            var this_1 = this;
            for (var name_2 in obj) {
                _loop_1(name_2);
            }
        };
        HasProps.internal = function (obj) {
            var _object = {};
            for (var name_3 in obj) {
                var prop = obj[name_3];
                var type = prop[0], default_value = prop[1];
                _object[name_3] = [
                    type,
                    default_value,
                    true
                ];
            }
            this.define(_object);
        };
        HasProps.mixin = function () {
            var names = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                names[_i] = arguments[_i];
            }
            this.define(property_mixins.create(names));
            var mixins = this.prototype.mixins.concat(names);
            this.prototype.mixins = mixins;
        };
        HasProps.mixins = function (names) {
            this.mixin.apply(this, names);
        };
        HasProps.override = function (obj) {
            for (var name_4 in obj) {
                var default_value = this._fix_default(obj[name_4], name_4);
                var value = this.prototype.props[name_4];
                if (value == null)
                    throw new Error('attempted to override nonexistent \'' + this.prototype.type + '.' + name_4 + '\'');
                var props = object_1.clone(this.prototype.props);
                props[name_4] = object_1.extend({}, value, { default_value: default_value });
                this.prototype.props = props;
            }
        };
        HasProps.prototype.toString = function () {
            return this.type + '(' + this.id + ')';
        };
        HasProps.prototype.finalize = function () {
            var _this = this;
            // This is necessary because the initial creation of properties relies on
            // model.get which is not usable at that point yet in the constructor. This
            // initializer is called when deferred initialization happens for all models
            // and insures that the Bokeh properties are initialized from Backbone
            // attributes in a consistent way.
            //
            // TODO (bev) split property creation up into two parts so that only the
            // portion of init that can be done happens in HasProps constructor and so
            // that subsequent updates do not duplicate that setup work.
            for (var name_5 in this.properties) {
                var prop = this.properties[name_5];
                prop.update();
                if (prop.spec.transform != null)
                    this.connect(prop.spec.transform.change, function () {
                        return _this.transformchange.emit();
                    });
            }
            this.initialize();
            this.connect_signals();
        };
        HasProps.prototype.initialize = function () {
        };
        HasProps.prototype.connect_signals = function () {
        };
        HasProps.prototype.disconnect_signals = function () {
            signaling_1.Signal.disconnectReceiver(this);
        };
        HasProps.prototype.destroy = function () {
            this.disconnect_signals();
            this.destroyed.emit();
        };
        // Create a new model with identical attributes to this one.
        HasProps.prototype.clone = function () {
            return new this.constructor(this.attributes);
        };
        // Set a hash of model attributes on the object, firing `"change"`. This is
        // the core primitive operation of a model, updating the data and notifying
        // anyone who needs to know about the change in state. The heart of the beast.
        HasProps.prototype._setv = function (attrs, options) {
            // Extract attributes and options.
            var check_eq = options.check_eq;
            var silent = options.silent;
            var changes = [];
            var changing = this._changing;
            this._changing = true;
            var current = this.attributes;
            // For each `set` attribute, update or delete the current value.
            for (var attr in attrs) {
                var val = attrs[attr];
                if (check_eq !== false) {
                    if (!eq_1.isEqual(current[attr], val))
                        changes.push(attr);
                } else
                    changes.push(attr);
                current[attr] = val;
            }
            // Trigger all relevant attribute changes.
            if (!silent) {
                if (changes.length > 0)
                    this._pending = true;
                for (var i = 0; i < changes.length; i++)
                    this.properties[changes[i]].change.emit();
            }
            // You might be wondering why there's a `while` loop here. Changes can
            // be recursively nested within `"change"` events.
            if (changing)
                return;
            if (!silent && !options.no_change) {
                while (this._pending) {
                    this._pending = false;
                    this.change.emit();
                }
            }
            this._pending = false;
            this._changing = false;
        };
        HasProps.prototype.setv = function (attrs, options) {
            if (options === void 0) {
                options = {};
            }
            for (var key in attrs) {
                if (!attrs.hasOwnProperty(key))
                    continue;
                var prop_name = key;
                if (this.props[prop_name] == null)
                    throw new Error('property ' + this.type + '.' + prop_name + ' wasn\'t declared');
                if (!(options != null && options.defaults))
                    this._set_after_defaults[key] = true;
            }
            if (!object_1.isEmpty(attrs)) {
                var old = {};
                for (var key in attrs)
                    old[key] = this.getv(key);
                this._setv(attrs, options);
                var silent = options.silent;
                if (silent == null || !silent) {
                    for (var key in attrs)
                        this._tell_document_about_change(key, old[key], this.getv(key), options);
                }
            }
        };
        HasProps.prototype.getv = function (prop_name) {
            if (this.props[prop_name] == null)
                throw new Error('property ' + this.type + '.' + prop_name + ' wasn\'t declared');
            else
                return this.attributes[prop_name];
        };
        HasProps.prototype.ref = function () {
            return refs_1.create_ref(this);
        };
        // we only keep the subtype so we match Python;
        // only Python cares about this
        HasProps.prototype.set_subtype = function (subtype) {
            this._subtype = subtype;
        };
        HasProps.prototype.attribute_is_serializable = function (attr) {
            var prop = this.props[attr];
            if (prop == null)
                throw new Error(this.type + '.attribute_is_serializable(\'' + attr + '\'): ' + attr + ' wasn\'t declared');
            else
                return !prop.internal;
        };
        // dict of attributes that should be serialized to the server. We
        // sometimes stick things in attributes that aren't part of the
        // Document's models, subtypes that do that have to remove their
        // extra attributes here.
        HasProps.prototype.serializable_attributes = function () {
            var attrs = {};
            for (var name_6 in this.attributes) {
                var value = this.attributes[name_6];
                if (this.attribute_is_serializable(name_6))
                    attrs[name_6] = value;
            }
            return attrs;
        };
        HasProps._value_to_json = function (_key, value, _optional_parent_object) {
            if (value instanceof HasProps)
                return value.ref();
            else if (types_1.isArray(value)) {
                var ref_array = [];
                for (var i = 0; i < value.length; i++) {
                    var v = value[i];
                    ref_array.push(HasProps._value_to_json(i.toString(), v, value));
                }
                return ref_array;
            } else if (types_1.isObject(value)) {
                var ref_obj = {};
                for (var subkey in value) {
                    if (value.hasOwnProperty(subkey))
                        ref_obj[subkey] = HasProps._value_to_json(subkey, value[subkey], value);
                }
                return ref_obj;
            } else
                return value;
        };
        // Convert attributes to "shallow" JSON (values which are themselves models
        // are included as just references)
        HasProps.prototype.attributes_as_json = function (include_defaults, value_to_json) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            if (value_to_json === void 0) {
                value_to_json = HasProps._value_to_json;
            }
            var serializable = this.serializable_attributes();
            var attrs = {};
            for (var key in serializable) {
                if (serializable.hasOwnProperty(key)) {
                    var value = serializable[key];
                    if (include_defaults)
                        attrs[key] = value;
                    else if (key in this._set_after_defaults)
                        attrs[key] = value;
                }
            }
            return value_to_json('attributes', attrs, this);
        };
        // this is like _value_record_references but expects to find refs
        // instead of models, and takes a doc to look up the refs in
        HasProps._json_record_references = function (doc, v, result, recurse) {
            if (v == null) {
            } else if (refs_1.is_ref(v)) {
                if (!(v.id in result)) {
                    var model = doc.get_model_by_id(v.id);
                    HasProps._value_record_references(model, result, recurse);
                }
            } else if (types_1.isArray(v)) {
                for (var _i = 0, v_1 = v; _i < v_1.length; _i++) {
                    var elem = v_1[_i];
                    HasProps._json_record_references(doc, elem, result, recurse);
                }
            } else if (types_1.isObject(v)) {
                for (var k in v) {
                    if (v.hasOwnProperty(k)) {
                        var elem = v[k];
                        HasProps._json_record_references(doc, elem, result, recurse);
                    }
                }
            }
        };
        // add all references from 'v' to 'result', if recurse
        // is true then descend into refs, if false only
        // descend into non-refs
        HasProps._value_record_references = function (v, result, recurse) {
            if (v == null) {
            } else if (v instanceof HasProps) {
                if (!(v.id in result)) {
                    result[v.id] = v;
                    if (recurse) {
                        var immediate = v._immediate_references();
                        for (var _i = 0, immediate_1 = immediate; _i < immediate_1.length; _i++) {
                            var obj = immediate_1[_i];
                            HasProps._value_record_references(obj, result, true);
                        }    // true=recurse
                    }
                }
            } else if (v.buffer instanceof ArrayBuffer) {
            } else if (types_1.isArray(v)) {
                for (var _a = 0, v_2 = v; _a < v_2.length; _a++) {
                    var elem = v_2[_a];
                    HasProps._value_record_references(elem, result, recurse);
                }
            } else if (types_1.isObject(v)) {
                for (var k in v) {
                    if (v.hasOwnProperty(k)) {
                        var elem = v[k];
                        HasProps._value_record_references(elem, result, recurse);
                    }
                }
            }
        };
        // Get models that are immediately referenced by our properties
        // (do not recurse, do not include ourselves)
        HasProps.prototype._immediate_references = function () {
            var result = {};
            var attrs = this.serializable_attributes();
            for (var key in attrs) {
                var value = attrs[key];
                HasProps._value_record_references(value, result, false);    // false = no recurse
            }
            return object_1.values(result);
        };
        HasProps.prototype.references = function () {
            var references = {};
            HasProps._value_record_references(this, references, true);
            return object_1.values(references);
        };
        HasProps.prototype._doc_attached = function () {
        };
        HasProps.prototype.attach_document = function (doc) {
            // This should only be called by the Document implementation to set the document field
            if (this.document != null && this.document != doc)
                throw new Error('models must be owned by only a single document');
            this.document = doc;
            this._doc_attached();
        };
        HasProps.prototype.detach_document = function () {
            // This should only be called by the Document implementation to unset the document field
            this.document = null;
        };
        HasProps.prototype._tell_document_about_change = function (attr, old, new_, options) {
            if (!this.attribute_is_serializable(attr))
                return;
            if (this.document != null) {
                var new_refs = {};
                HasProps._value_record_references(new_, new_refs, false);
                var old_refs = {};
                HasProps._value_record_references(old, old_refs, false);
                var need_invalidate = false;
                for (var new_id in new_refs) {
                    if (!(new_id in old_refs)) {
                        need_invalidate = true;
                        break;
                    }
                }
                if (!need_invalidate) {
                    for (var old_id in old_refs) {
                        if (!(old_id in new_refs)) {
                            need_invalidate = true;
                            break;
                        }
                    }
                }
                if (need_invalidate)
                    this.document._invalidate_all_models();
                this.document._notify_change(this, attr, old, new_, options);
            }
        };
        HasProps.prototype.materialize_dataspecs = function (source) {
            // Note: this should be moved to a function separate from HasProps
            var data = {};
            for (var name_7 in this.properties) {
                var prop = this.properties[name_7];
                if (!prop.dataspec)
                    continue;
                // this skips optional properties like radius for circles
                if (prop.optional && prop.spec.value == null && !(name_7 in this._set_after_defaults))
                    continue;
                data['_' + name_7] = prop.array(source);
                // the shapes are indexed by the column name, but when we materialize the dataspec, we should
                // store under the canonical field name, e.g. _image_shape, even if the column name is "foo"
                if (prop.spec.field != null && prop.spec.field in source._shapes)
                    data['_' + name_7 + '_shape'] = source._shapes[prop.spec.field];
                if (prop instanceof p.Distance)
                    data['max_' + name_7] = array_1.max(data['_' + name_7]);
            }
            return data;
        };
        return HasProps;
    }(signaling_1.Signalable());
    exports.HasProps = HasProps;
    HasProps.initClass();    
},
/*core/hittest*/
function _(require, module, exports) {
    var array_1 = require(21    /* ./util/array */);
    var selection_1 = require(181    /* ../models/selections/selection */);
    function point_in_poly(x, y, px, py) {
        var inside = false;
        var x1 = px[px.length - 1];
        var y1 = py[py.length - 1];
        for (var i = 0; i < px.length; i++) {
            var x2 = px[i];
            var y2 = py[i];
            if (y1 < y != y2 < y) {
                if (x1 + (y - y1) / (y2 - y1) * (x2 - x1) < x)
                    inside = !inside;
            }
            x1 = x2;
            y1 = y2;
        }
        return inside;
    }
    exports.point_in_poly = point_in_poly;
    function create_empty_hit_test_result() {
        return new selection_1.Selection();
    }
    exports.create_empty_hit_test_result = create_empty_hit_test_result;
    function create_hit_test_result_from_hits(hits) {
        var result = new selection_1.Selection();
        result.indices = array_1.sortBy(hits, function (_a) {
            var _i = _a[0], dist = _a[1];
            return dist;
        }).map(function (_a) {
            var i = _a[0], _dist = _a[1];
            return i;
        });
        return result;
    }
    exports.create_hit_test_result_from_hits = create_hit_test_result_from_hits;
    function validate_bbox_coords(_a, _b) {
        var x0 = _a[0], x1 = _a[1];
        var y0 = _b[0], y1 = _b[1];
        // spatial index (flatbush) expects x0, y0 to be min, x1, y1 max
        if (x0 > x1)
            _c = [
                x1,
                x0
            ], x0 = _c[0], x1 = _c[1];
        if (y0 > y1)
            _d = [
                y1,
                y0
            ], y0 = _d[0], y1 = _d[1];
        return {
            minX: x0,
            minY: y0,
            maxX: x1,
            maxY: y1
        };
        var _c, _d;
    }
    exports.validate_bbox_coords = validate_bbox_coords;
    function sqr(x) {
        return x * x;
    }
    function dist_2_pts(p0, p1) {
        return sqr(p0.x - p1.x) + sqr(p0.y - p1.y);
    }
    exports.dist_2_pts = dist_2_pts;
    function dist_to_segment_squared(p, v, w) {
        var l2 = dist_2_pts(v, w);
        if (l2 == 0)
            return dist_2_pts(p, v);
        var t = ((p.x - v.x) * (w.x - v.x) + (p.y - v.y) * (w.y - v.y)) / l2;
        if (t < 0)
            return dist_2_pts(p, v);
        if (t > 1)
            return dist_2_pts(p, w);
        var q = {
            x: v.x + t * (w.x - v.x),
            y: v.y + t * (w.y - v.y)
        };
        return dist_2_pts(p, q);
    }
    exports.dist_to_segment_squared = dist_to_segment_squared;
    function dist_to_segment(p, v, w) {
        return Math.sqrt(dist_to_segment_squared(p, v, w));
    }
    exports.dist_to_segment = dist_to_segment;
    function check_2_segments_intersect(l0_x0, l0_y0, l0_x1, l0_y1, l1_x0, l1_y0, l1_x1, l1_y1) {
        /*
     *  Check if 2 segments (l0 and l1) intersect. Returns a structure with
     *  the following attributes:
     *   * hit (boolean): whether the 2 segments intersect
     *   * x (float): x coordinate of the intersection point
     *   * y (float): y coordinate of the intersection point
     */
        var den = (l1_y1 - l1_y0) * (l0_x1 - l0_x0) - (l1_x1 - l1_x0) * (l0_y1 - l0_y0);
        if (den == 0) {
            return {
                hit: false,
                x: null,
                y: null
            };
        } else {
            var a = l0_y0 - l1_y0;
            var b = l0_x0 - l1_x0;
            var num1 = (l1_x1 - l1_x0) * a - (l1_y1 - l1_y0) * b;
            var num2 = (l0_x1 - l0_x0) * a - (l0_y1 - l0_y0) * b;
            a = num1 / den;
            b = num2 / den;
            var x = l0_x0 + a * (l0_x1 - l0_x0);
            var y = l0_y0 + a * (l0_y1 - l0_y0);
            return {
                hit: a > 0 && a < 1 && (b > 0 && b < 1),
                x: x,
                y: y
            };
        }
    }
    exports.check_2_segments_intersect = check_2_segments_intersect;    
},
/*core/layout/alignments*/
function _(require, module, exports) {
    var solver_1 = require(13    /* ./solver */);
    var array_1 = require(21    /* ../util/array */);
    function vstack(container, children) {
        var constraints = [];
        if (children.length > 0) {
            constraints.push(solver_1.EQ(array_1.head(children)._bottom, [
                -1,
                container._bottom
            ]));
            constraints.push(solver_1.EQ(array_1.tail(children)._top, [
                -1,
                container._top
            ]));
            constraints.push.apply(constraints, array_1.pairwise(children, function (prev, next) {
                return solver_1.EQ(prev._top, [
                    -1,
                    next._bottom
                ]);
            }));
            for (var _i = 0, children_1 = children; _i < children_1.length; _i++) {
                var child = children_1[_i];
                constraints.push(solver_1.EQ(child._left, [
                    -1,
                    container._left
                ]));
                constraints.push(solver_1.EQ(child._right, [
                    -1,
                    container._right
                ]));
            }
        }
        return constraints;
    }
    exports.vstack = vstack;
    function hstack(container, children) {
        var constraints = [];
        if (children.length > 0) {
            constraints.push(solver_1.EQ(array_1.head(children)._right, [
                -1,
                container._right
            ]));
            constraints.push(solver_1.EQ(array_1.tail(children)._left, [
                -1,
                container._left
            ]));
            constraints.push.apply(constraints, array_1.pairwise(children, function (prev, next) {
                return solver_1.EQ(prev._left, [
                    -1,
                    next._right
                ]);
            }));
            for (var _i = 0, children_2 = children; _i < children_2.length; _i++) {
                var child = children_2[_i];
                constraints.push(solver_1.EQ(child._top, [
                    -1,
                    container._top
                ]));
                constraints.push(solver_1.EQ(child._bottom, [
                    -1,
                    container._bottom
                ]));
            }
        }
        return constraints;
    }
    exports.hstack = hstack;    
},
/*core/layout/layout_canvas*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var solver_1 = require(13    /* ./solver */);
    var has_props_1 = require(8    /* ../has_props */);
    var bbox_1 = require(24    /* ../util/bbox */);
    var LayoutCanvas = function (_super) {
        tslib_1.__extends(LayoutCanvas, _super);
        function LayoutCanvas(attrs) {
            return _super.call(this, attrs) || this;
        }
        LayoutCanvas.initClass = function () {
            this.prototype.type = 'LayoutCanvas';
        };
        LayoutCanvas.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._top = new solver_1.Variable(this.toString() + '.top');
            this._left = new solver_1.Variable(this.toString() + '.left');
            this._width = new solver_1.Variable(this.toString() + '.width');
            this._height = new solver_1.Variable(this.toString() + '.height');
            this._right = new solver_1.Variable(this.toString() + '.right');
            this._bottom = new solver_1.Variable(this.toString() + '.bottom');
            this._hcenter = new solver_1.Variable(this.toString() + '.hcenter');
            this._vcenter = new solver_1.Variable(this.toString() + '.vcenter');
        };
        LayoutCanvas.prototype.get_editables = function () {
            return [];
        };
        LayoutCanvas.prototype.get_constraints = function () {
            return [
                solver_1.GE(this._top),
                solver_1.GE(this._bottom),
                solver_1.GE(this._left),
                solver_1.GE(this._right),
                solver_1.GE(this._width),
                solver_1.GE(this._height),
                solver_1.EQ(this._left, this._width, [
                    -1,
                    this._right
                ]),
                solver_1.EQ(this._top, this._height, [
                    -1,
                    this._bottom
                ]),
                solver_1.EQ([
                    2,
                    this._hcenter
                ], [
                    -1,
                    this._left
                ], [
                    -1,
                    this._right
                ]),
                solver_1.EQ([
                    2,
                    this._vcenter
                ], [
                    -1,
                    this._top
                ], [
                    -1,
                    this._bottom
                ])
            ];
        };
        LayoutCanvas.prototype.get_layoutable_children = function () {
            return [];
        };
        Object.defineProperty(LayoutCanvas.prototype, 'bbox', {
            get: function () {
                return new bbox_1.BBox({
                    x0: this._left.value,
                    y0: this._top.value,
                    x1: this._right.value,
                    y1: this._bottom.value
                });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(LayoutCanvas.prototype, 'layout_bbox', {
            get: function () {
                return {
                    top: this._top.value,
                    left: this._left.value,
                    width: this._width.value,
                    height: this._height.value,
                    right: this._right.value,
                    bottom: this._bottom.value,
                    hcenter: this._hcenter.value,
                    vcenter: this._vcenter.value
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(LayoutCanvas.prototype, 'xview', {
            get: function () {
                var _this = this;
                return {
                    compute: function (x) {
                        return _this._left.value + x;
                    },
                    v_compute: function (xx) {
                        var _xx = new Float64Array(xx.length);
                        var left = _this._left.value;
                        for (var i = 0; i < xx.length; i++) {
                            _xx[i] = left + xx[i];
                        }
                        return _xx;
                    }
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(LayoutCanvas.prototype, 'yview', {
            get: function () {
                var _this = this;
                return {
                    compute: function (y) {
                        return _this._bottom.value - y;
                    },
                    v_compute: function (yy) {
                        var _yy = new Float64Array(yy.length);
                        var bottom = _this._bottom.value;
                        for (var i = 0; i < yy.length; i++) {
                            _yy[i] = bottom - yy[i];
                        }
                        return _yy;
                    }
                };
            },
            enumerable: true,
            configurable: true
        });
        return LayoutCanvas;
    }(has_props_1.HasProps);
    exports.LayoutCanvas = LayoutCanvas;
    LayoutCanvas.initClass();    
},
/*core/layout/side_panel*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var solver_1 = require(13    /* ./solver */);
    var layout_canvas_1 = require(11    /* ./layout_canvas */);
    var p = require(15    /* ../properties */);
    var logging_1 = require(14    /* ../logging */);
    var types_1 = require(44    /* ../util/types */);
    // This table lays out the rules for configuring the baseline, alignment, etc. of
    // title text, based on it's location and orientation
    //
    // side    orient        baseline   align     angle   normal-dist
    // ------------------------------------------------------------------------------
    // above   parallel      bottom     center    0       height
    //         normal        middle     left      -90     width
    //         horizontal    bottom     center    0       height
    //         [angle > 0]   middle     left              width * sin + height * cos
    //         [angle < 0]   middle     right             width * sin + height * cos
    //
    // below   parallel      top        center    0       height
    //         normal        middle     right     90      width
    //         horizontal    top        center    0       height
    //         [angle > 0]   middle     right             width * sin + height * cos
    //         [angle < 0]   middle     left              width * sin + height * cos
    //
    // left    parallel      bottom     center    90      height
    //         normal        middle     right     0       width
    //         horizontal    middle     right     0       width
    //         [angle > 0]   middle     right             width * cos + height * sin
    //         [angle < 0]   middle     right             width * cos + height + sin
    //
    // right   parallel      bottom     center   -90      height
    //         normal        middle     left     0        width
    //         horizontal    middle     left     0        width
    //         [angle > 0]   middle     left              width * cos + height * sin
    //         [angle < 0]   middle     left              width * cos + height + sin
    var pi2 = Math.PI / 2;
    var ALPHABETIC = 'alphabetic';
    var TOP = 'top';
    var BOTTOM = 'bottom';
    var MIDDLE = 'middle';
    var HANGING = 'hanging';
    var LEFT = 'left';
    var RIGHT = 'right';
    var CENTER = 'center';
    var _angle_lookup = {
        above: {
            parallel: 0,
            normal: -pi2,
            horizontal: 0,
            vertical: -pi2
        },
        below: {
            parallel: 0,
            normal: pi2,
            horizontal: 0,
            vertical: pi2
        },
        left: {
            parallel: -pi2,
            normal: 0,
            horizontal: 0,
            vertical: -pi2
        },
        right: {
            parallel: pi2,
            normal: 0,
            horizontal: 0,
            vertical: pi2
        }
    };
    var _baseline_lookup = {
        above: {
            justified: TOP,
            parallel: ALPHABETIC,
            normal: MIDDLE,
            horizontal: ALPHABETIC,
            vertical: MIDDLE
        },
        below: {
            justified: BOTTOM,
            parallel: HANGING,
            normal: MIDDLE,
            horizontal: HANGING,
            vertical: MIDDLE
        },
        left: {
            justified: TOP,
            parallel: ALPHABETIC,
            normal: MIDDLE,
            horizontal: MIDDLE,
            vertical: ALPHABETIC
        },
        right: {
            justified: TOP,
            parallel: ALPHABETIC,
            normal: MIDDLE,
            horizontal: MIDDLE,
            vertical: ALPHABETIC
        }
    };
    var _align_lookup = {
        above: {
            justified: CENTER,
            parallel: CENTER,
            normal: LEFT,
            horizontal: CENTER,
            vertical: LEFT
        },
        below: {
            justified: CENTER,
            parallel: CENTER,
            normal: LEFT,
            horizontal: CENTER,
            vertical: LEFT
        },
        left: {
            justified: CENTER,
            parallel: CENTER,
            normal: RIGHT,
            horizontal: RIGHT,
            vertical: CENTER
        },
        right: {
            justified: CENTER,
            parallel: CENTER,
            normal: LEFT,
            horizontal: LEFT,
            vertical: CENTER
        }
    };
    var _align_lookup_negative = {
        above: RIGHT,
        below: LEFT,
        left: RIGHT,
        right: LEFT
    };
    var _align_lookup_positive = {
        above: LEFT,
        below: RIGHT,
        left: RIGHT,
        right: LEFT
    };
    function isSizeable(model) {
        return 'panel' in model;
    }
    exports.isSizeable = isSizeable;
    function isSizeableView(view) {
        return isSizeable(view.model) && 'get_size' in view;
    }
    exports.isSizeableView = isSizeableView;
    exports._view_sizes = new WeakMap();
    exports._view_constraints = new WeakMap();
    function update_panel_constraints(view) {
        var s = view.solver;
        var size = view.get_size();
        var constraint = exports._view_constraints.get(view);
        if (constraint != null && s.has_constraint(constraint)) {
            if (exports._view_sizes.get(view) === size)
                return;
            s.remove_constraint(constraint);
        }
        constraint = solver_1.GE(view.model.panel._size, -size);
        s.add_constraint(constraint);
        exports._view_sizes.set(view, size);
        exports._view_constraints.set(view, constraint);
    }
    exports.update_panel_constraints = update_panel_constraints;
    var SidePanel = function (_super) {
        tslib_1.__extends(SidePanel, _super);
        function SidePanel(attrs) {
            return _super.call(this, attrs) || this;
        }
        SidePanel.initClass = function () {
            this.prototype.type = 'SidePanel';
            this.internal({ side: [p.String] });
        };
        SidePanel.prototype.toString = function () {
            return this.type + '(' + this.id + ', ' + this.side + ')';
        };
        SidePanel.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            switch (this.side) {
            case 'above':
                this._dim = 0;
                this._normals = [
                    0,
                    -1
                ];
                this._size = this._height;
                break;
            case 'below':
                this._dim = 0;
                this._normals = [
                    0,
                    1
                ];
                this._size = this._height;
                break;
            case 'left':
                this._dim = 1;
                this._normals = [
                    -1,
                    0
                ];
                this._size = this._width;
                break;
            case 'right':
                this._dim = 1;
                this._normals = [
                    1,
                    0
                ];
                this._size = this._width;
                break;
            default:
                logging_1.logger.error('unrecognized side: \'' + this.side + '\'');
            }
        };
        Object.defineProperty(SidePanel.prototype, 'dimension', {
            get: function () {
                return this._dim;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SidePanel.prototype, 'normals', {
            get: function () {
                return this._normals;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SidePanel.prototype, 'is_horizontal', {
            get: function () {
                return this.side == 'above' || this.side == 'below';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SidePanel.prototype, 'is_vertical', {
            get: function () {
                return this.side == 'left' || this.side == 'right';
            },
            enumerable: true,
            configurable: true
        });
        SidePanel.prototype.apply_label_text_heuristics = function (ctx, orient) {
            var side = this.side;
            var baseline;
            var align;
            if (types_1.isString(orient)) {
                baseline = _baseline_lookup[side][orient];
                align = _align_lookup[side][orient];
            } else {
                if (orient === 0) {
                    baseline = 'whatever';
                    // XXX: _baseline_lookup[side][orient]
                    align = 'whatever';    // XXX: _align_lookup[side][orient]
                } else if (orient < 0) {
                    baseline = 'middle';
                    align = _align_lookup_negative[side];
                } else {
                    baseline = 'middle';
                    align = _align_lookup_positive[side];
                }
            }
            ctx.textBaseline = baseline;
            ctx.textAlign = align;
        };
        SidePanel.prototype.get_label_angle_heuristic = function (orient) {
            return _angle_lookup[this.side][orient];
        };
        return SidePanel;
    }(layout_canvas_1.LayoutCanvas);
    exports.SidePanel = SidePanel;
    SidePanel.initClass();    
},
/*core/layout/solver*/
function _(require, module, exports) {
    var kiwi_1 = require(339    /* kiwi */);
    exports.Variable = kiwi_1.Variable;
    exports.Expression = kiwi_1.Expression;
    exports.Constraint = kiwi_1.Constraint;
    exports.Operator = kiwi_1.Operator;
    exports.Strength = kiwi_1.Strength;
    function _constrainer(op) {
        return function () {
            var terms = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                terms[_i] = arguments[_i];
            }
            return new kiwi_1.Constraint(new (kiwi_1.Expression.bind.apply(kiwi_1.Expression, [void 0].concat(terms)))(), op);
        };
    }
    function _weak_constrainer(op) {
        return function () {
            var terms = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                terms[_i] = arguments[_i];
            }
            return new kiwi_1.Constraint(new (kiwi_1.Expression.bind.apply(kiwi_1.Expression, [void 0].concat(terms)))(), op, kiwi_1.Strength.weak);
        };
    }
    exports.EQ = _constrainer(kiwi_1.Operator.Eq);
    exports.LE = _constrainer(kiwi_1.Operator.Le);
    exports.GE = _constrainer(kiwi_1.Operator.Ge);
    exports.WEAK_EQ = _weak_constrainer(kiwi_1.Operator.Eq);
    exports.WEAK_LE = _weak_constrainer(kiwi_1.Operator.Le);
    exports.WEAK_GE = _weak_constrainer(kiwi_1.Operator.Ge);
    var Solver = function () {
        function Solver() {
            this.solver = new kiwi_1.Solver();
        }
        Solver.prototype.clear = function () {
            this.solver = new kiwi_1.Solver();
        };
        Solver.prototype.toString = function () {
            return 'Solver(num_constraints=' + this.num_constraints + ', num_editables=' + this.num_editables + ')';
        };
        Object.defineProperty(Solver.prototype, 'num_constraints', {
            get: function () {
                return this.solver.numConstraints;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Solver.prototype, 'num_editables', {
            get: function () {
                return this.solver.numEditVariables;
            },
            enumerable: true,
            configurable: true
        });
        Solver.prototype.get_constraints = function () {
            return this.solver.getConstraints();
        };
        Solver.prototype.update_variables = function () {
            this.solver.updateVariables();
        };
        Solver.prototype.has_constraint = function (constraint) {
            return this.solver.hasConstraint(constraint);
        };
        Solver.prototype.add_constraint = function (constraint) {
            try {
                this.solver.addConstraint(constraint);
            } catch (e) {
                throw new Error(e.message + ': ' + constraint.toString());
            }
        };
        Solver.prototype.remove_constraint = function (constraint) {
            this.solver.removeConstraint(constraint);
        };
        Solver.prototype.add_edit_variable = function (variable, strength) {
            this.solver.addEditVariable(variable, strength);
        };
        Solver.prototype.remove_edit_variable = function (variable) {
            this.solver.removeEditVariable(variable);
        };
        Solver.prototype.suggest_value = function (variable, value) {
            this.solver.suggestValue(variable, value);
        };
        return Solver;
    }();
    exports.Solver = Solver;    
},
/*core/logging*/
function _(require, module, exports) {
    var types_1 = require(44    /* ./util/types */);
    var _loggers = {};
    var LogLevel = function () {
        function LogLevel(name, level) {
            this.name = name;
            this.level = level;
        }
        return LogLevel;
    }();
    exports.LogLevel = LogLevel;
    var Logger = function () {
        function Logger(name, level) {
            if (level === void 0) {
                level = Logger.INFO;
            }
            this._name = name;
            this.set_level(level);
        }
        Object.defineProperty(Logger, 'levels', {
            get: function () {
                return Object.keys(Logger.log_levels);
            },
            enumerable: true,
            configurable: true
        });
        Logger.get = function (name, level) {
            if (level === void 0) {
                level = Logger.INFO;
            }
            if (name.length > 0) {
                var logger_1 = _loggers[name];
                if (logger_1 == null)
                    _loggers[name] = logger_1 = new Logger(name, level);
                return logger_1;
            } else
                throw new TypeError('Logger.get() expects a non-empty string name and an optional log-level');
        };
        Object.defineProperty(Logger.prototype, 'level', {
            get: function () {
                return this.get_level();
            },
            enumerable: true,
            configurable: true
        });
        Logger.prototype.get_level = function () {
            return this._log_level;
        };
        Logger.prototype.set_level = function (log_level) {
            if (log_level instanceof LogLevel)
                this._log_level = log_level;
            else if (types_1.isString(log_level) && Logger.log_levels[log_level] != null)
                this._log_level = Logger.log_levels[log_level];
            else
                throw new Error('Logger.set_level() expects a log-level object or a string name of a log-level');
            var logger_name = '[' + this._name + ']';
            for (var name_1 in Logger.log_levels) {
                var log_level_1 = Logger.log_levels[name_1];
                if (log_level_1.level < this._log_level.level || this._log_level.level === Logger.OFF.level)
                    this[name_1] = function () {
                    };
                else
                    this[name_1] = _method_factory(name_1, logger_name);
            }
        };
        Logger.prototype.trace = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.debug = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.info = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.warn = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.error = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.TRACE = new LogLevel('trace', 0);
        Logger.DEBUG = new LogLevel('debug', 1);
        Logger.INFO = new LogLevel('info', 2);
        Logger.WARN = new LogLevel('warn', 6);
        Logger.ERROR = new LogLevel('error', 7);
        Logger.FATAL = new LogLevel('fatal', 8);
        Logger.OFF = new LogLevel('off', 9);
        Logger.log_levels = {
            trace: Logger.TRACE,
            debug: Logger.DEBUG,
            info: Logger.INFO,
            warn: Logger.WARN,
            error: Logger.ERROR,
            fatal: Logger.FATAL,
            off: Logger.OFF
        };
        return Logger;
    }();
    exports.Logger = Logger;
    function _method_factory(method_name, logger_name) {
        if (console[method_name] != null)
            return console[method_name].bind(console, logger_name);
        else if (console.log != null)
            return console.log.bind(console, logger_name);
        else
            return function () {
            };
    }
    exports.logger = Logger.get('bokeh');
    function set_log_level(level) {
        if (Logger.log_levels[level] == null) {
            console.log('[bokeh] unrecognized logging level \'' + level + '\' passed to Bokeh.set_log_level(), ignoring');
            console.log('[bokeh] valid log levels are: ' + Logger.levels.join(', '));
        } else {
            console.log('[bokeh] setting log level to: \'' + level + '\'');
            exports.logger.set_level(level);
        }
    }
    exports.set_log_level = set_log_level;    
},
/*core/properties*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var signaling_1 = require(19    /* ./signaling */);
    var has_props_1 = require(8    /* ./has_props */);
    var enums = require(7    /* ./enums */);
    var svg_colors_1 = require(39    /* ./util/svg_colors */);
    var color_1 = require(27    /* ./util/color */);
    var array_1 = require(21    /* ./util/array */);
    var arrayable_1 = require(22    /* ./util/arrayable */);
    var types_1 = require(44    /* ./util/types */);
    signaling_1.Signal;
    // XXX: silence TS, because `Signal` appears in declarations due to Signalable
    function valueToString(value) {
        try {
            return JSON.stringify(value);
        } catch (_a) {
            return value.toString();
        }
    }
    function isSpec(obj) {
        return !(obj instanceof has_props_1.HasProps) && types_1.isObject(obj) && (obj.value === undefined ? 0 : 1) + (obj.field === undefined ? 0 : 1) + (obj.expr === undefined ? 0 : 1) == 1;    // garbage JS XOR
    }
    exports.isSpec = isSpec;
    //
    // Property base class
    //
    var Property = function (_super) {
        tslib_1.__extends(Property, _super);
        function Property(obj, attr, default_value) {
            var _this = _super.call(this) || this;
            _this.optional = false;
            _this.obj = obj;
            _this.attr = attr;
            _this.default_value = default_value;
            _this.change = new signaling_1.Signal0(_this.obj, 'change');
            _this._init();
            _this.connect(_this.change, function () {
                return _this._init();
            });
            return _this;
        }
        Property.prototype.update = function () {
            this._init();
        };
        // ----- customizable policies
        Property.prototype.init = function () {
        };
        Property.prototype.transform = function (values) {
            return values;
        };
        Property.prototype.validate = function (_value) {
        };
        // ----- property accessors
        Property.prototype.value = function (do_spec_transform) {
            if (do_spec_transform === void 0) {
                do_spec_transform = true;
            }
            if (this.spec.value === undefined)
                throw new Error('attempted to retrieve property value for property without value specification');
            var ret = this.transform([this.spec.value])[0];
            if (this.spec.transform != null && do_spec_transform)
                ret = this.spec.transform.compute(ret);
            return ret;
        };
        Property.prototype.array = function (source) {
            if (!this.dataspec)
                throw new Error('attempted to retrieve property array for non-dataspec property');
            var ret;
            if (this.spec.field != null) {
                ret = this.transform(source.get_column(this.spec.field));
                if (ret == null)
                    throw new Error('attempted to retrieve property array for nonexistent field \'' + this.spec.field + '\'');
            } else if (this.spec.expr != null) {
                ret = this.transform(this.spec.expr.v_compute(source));
            } else {
                var length_1 = source.get_length();
                if (length_1 == null)
                    length_1 = 1;
                var value = this.value(false);
                // don't apply any spec transform
                ret = array_1.repeat(value, length_1);
            }
            if (this.spec.transform != null)
                ret = this.spec.transform.v_compute(ret);
            return ret;
        };
        // ----- private methods
        /*protected*/
        Property.prototype._init = function () {
            var obj = this.obj;
            var attr = this.attr;
            var attr_value = obj.getv(attr);
            if (attr_value === undefined) {
                var default_value = this.default_value;
                if (default_value !== undefined)
                    attr_value = default_value(obj);
                else
                    attr_value = null;
                obj.setv((_a = {}, _a[attr] = attr_value, _a), {
                    silent: true,
                    defaults: true
                });
            }
            if (types_1.isArray(attr_value))
                this.spec = { value: attr_value };
            else if (isSpec(attr_value))
                this.spec = attr_value;
            else
                this.spec = { value: attr_value };
            if (this.spec.field != null && !types_1.isString(this.spec.field))
                throw new Error('field value for property \'' + attr + '\' is not a string');
            if (this.spec.value != null)
                this.validate(this.spec.value);
            this.init();
            var _a;
        };
        Property.prototype.toString = function () {
            /*${this.name}*/
            return 'Prop(' + this.obj + '.' + this.attr + ', spec: ' + valueToString(this.spec) + ')';
        };
        return Property;
    }(signaling_1.Signalable());
    exports.Property = Property;
    Property.prototype.dataspec = false;
    //
    // Simple Properties
    //
    function simple_prop(name, pred) {
        return function (_super) {
            tslib_1.__extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_1.prototype.validate = function (value) {
                if (!pred(value))
                    throw new Error(name + ' property \'' + this.attr + '\' given invalid value: ' + valueToString(value));
            };
            return class_1;
        }(Property);
    }
    exports.simple_prop = simple_prop;
    var Any = function (_super) {
        tslib_1.__extends(Any, _super);
        function Any() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Any;
    }(simple_prop('Any', function (_x) {
        return true;
    }));
    exports.Any = Any;
    var Array = function (_super) {
        tslib_1.__extends(Array, _super);
        function Array() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Array;
    }(simple_prop('Array', function (x) {
        return types_1.isArray(x) || x instanceof Float64Array;
    }));
    exports.Array = Array;
    var Bool = function (_super) {
        tslib_1.__extends(Bool, _super);
        function Bool() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Bool;
    }(simple_prop('Bool', types_1.isBoolean));
    exports.Bool = Bool;
    exports.Boolean = Bool;
    var Color = function (_super) {
        tslib_1.__extends(Color, _super);
        function Color() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Color;
    }(simple_prop('Color', function (x) {
        return svg_colors_1.is_svg_color(x.toLowerCase()) || x.substring(0, 1) == '#' || color_1.valid_rgb(x);
    }));
    exports.Color = Color;
    var Instance = function (_super) {
        tslib_1.__extends(Instance, _super);
        function Instance() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Instance;
    }(simple_prop('Instance', function (x) {
        return x.properties != null;
    }));
    exports.Instance = Instance;
    // TODO (bev) separate booleans?
    var Number = function (_super) {
        tslib_1.__extends(Number, _super);
        function Number() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Number;
    }(simple_prop('Number', function (x) {
        return types_1.isNumber(x) || types_1.isBoolean(x);
    }));
    exports.Number = Number;
    exports.Int = Number;
    // TODO extend Number instead of copying it's predicate
    //class Percent extends Number("Percent", (x) -> 0 <= x <= 1.0)
    var Percent = function (_super) {
        tslib_1.__extends(Percent, _super);
        function Percent() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Percent;
    }(simple_prop('Number', function (x) {
        return (types_1.isNumber(x) || types_1.isBoolean(x)) && 0 <= x && x <= 1;
    }));
    exports.Percent = Percent;
    var String = function (_super) {
        tslib_1.__extends(String, _super);
        function String() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return String;
    }(simple_prop('String', types_1.isString));
    exports.String = String;
    // TODO (bev) don't think this exists python side
    var Font = function (_super) {
        tslib_1.__extends(Font, _super);
        function Font() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Font;
    }(String);
    exports.Font = Font;
    //
    // Enum properties
    //
    function enum_prop(name, enum_values) {
        return function (_super) {
            tslib_1.__extends(class_2, _super);
            function class_2() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            return class_2;
        }(simple_prop(name, function (x) {
            return array_1.includes(enum_values, x);
        }));
    }
    exports.enum_prop = enum_prop;
    var Anchor = function (_super) {
        tslib_1.__extends(Anchor, _super);
        function Anchor() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Anchor;
    }(enum_prop('Anchor', enums.LegendLocation));
    exports.Anchor = Anchor;
    var AngleUnits = function (_super) {
        tslib_1.__extends(AngleUnits, _super);
        function AngleUnits() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return AngleUnits;
    }(enum_prop('AngleUnits', enums.AngleUnits));
    exports.AngleUnits = AngleUnits;
    var Direction = function (_super) {
        tslib_1.__extends(Direction, _super);
        function Direction() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Direction.prototype.transform = function (values) {
            var result = new Uint8Array(values.length);
            for (var i = 0; i < values.length; i++) {
                switch (values[i]) {
                case 'clock':
                    result[i] = 0;
                    break;
                case 'anticlock':
                    result[i] = 1;
                    break;
                }
            }
            return result;
        };
        return Direction;
    }(enum_prop('Direction', enums.Direction));
    exports.Direction = Direction;
    var Dimension = function (_super) {
        tslib_1.__extends(Dimension, _super);
        function Dimension() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Dimension;
    }(enum_prop('Dimension', enums.Dimension));
    exports.Dimension = Dimension;
    var Dimensions = function (_super) {
        tslib_1.__extends(Dimensions, _super);
        function Dimensions() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Dimensions;
    }(enum_prop('Dimensions', enums.Dimensions));
    exports.Dimensions = Dimensions;
    var FontStyle = function (_super) {
        tslib_1.__extends(FontStyle, _super);
        function FontStyle() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontStyle;
    }(enum_prop('FontStyle', enums.FontStyle));
    exports.FontStyle = FontStyle;
    var LatLon = function (_super) {
        tslib_1.__extends(LatLon, _super);
        function LatLon() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LatLon;
    }(enum_prop('LatLon', enums.LatLon));
    exports.LatLon = LatLon;
    var LineCap = function (_super) {
        tslib_1.__extends(LineCap, _super);
        function LineCap() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineCap;
    }(enum_prop('LineCap', enums.LineCap));
    exports.LineCap = LineCap;
    var LineJoin = function (_super) {
        tslib_1.__extends(LineJoin, _super);
        function LineJoin() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineJoin;
    }(enum_prop('LineJoin', enums.LineJoin));
    exports.LineJoin = LineJoin;
    var LegendLocation = function (_super) {
        tslib_1.__extends(LegendLocation, _super);
        function LegendLocation() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LegendLocation;
    }(enum_prop('LegendLocation', enums.LegendLocation));
    exports.LegendLocation = LegendLocation;
    var Location = function (_super) {
        tslib_1.__extends(Location, _super);
        function Location() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Location;
    }(enum_prop('Location', enums.Location));
    exports.Location = Location;
    var OutputBackend = function (_super) {
        tslib_1.__extends(OutputBackend, _super);
        function OutputBackend() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return OutputBackend;
    }(enum_prop('OutputBackend', enums.OutputBackend));
    exports.OutputBackend = OutputBackend;
    var Orientation = function (_super) {
        tslib_1.__extends(Orientation, _super);
        function Orientation() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Orientation;
    }(enum_prop('Orientation', enums.Orientation));
    exports.Orientation = Orientation;
    var VerticalAlign = function (_super) {
        tslib_1.__extends(VerticalAlign, _super);
        function VerticalAlign() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return VerticalAlign;
    }(enum_prop('VerticalAlign', enums.VerticalAlign));
    exports.VerticalAlign = VerticalAlign;
    var TextAlign = function (_super) {
        tslib_1.__extends(TextAlign, _super);
        function TextAlign() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return TextAlign;
    }(enum_prop('TextAlign', enums.TextAlign));
    exports.TextAlign = TextAlign;
    var TextBaseline = function (_super) {
        tslib_1.__extends(TextBaseline, _super);
        function TextBaseline() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return TextBaseline;
    }(enum_prop('TextBaseline', enums.TextBaseline));
    exports.TextBaseline = TextBaseline;
    var RenderLevel = function (_super) {
        tslib_1.__extends(RenderLevel, _super);
        function RenderLevel() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return RenderLevel;
    }(enum_prop('RenderLevel', enums.RenderLevel));
    exports.RenderLevel = RenderLevel;
    var RenderMode = function (_super) {
        tslib_1.__extends(RenderMode, _super);
        function RenderMode() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return RenderMode;
    }(enum_prop('RenderMode', enums.RenderMode));
    exports.RenderMode = RenderMode;
    var SizingMode = function (_super) {
        tslib_1.__extends(SizingMode, _super);
        function SizingMode() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return SizingMode;
    }(enum_prop('SizingMode', enums.SizingMode));
    exports.SizingMode = SizingMode;
    var SpatialUnits = function (_super) {
        tslib_1.__extends(SpatialUnits, _super);
        function SpatialUnits() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return SpatialUnits;
    }(enum_prop('SpatialUnits', enums.SpatialUnits));
    exports.SpatialUnits = SpatialUnits;
    var Distribution = function (_super) {
        tslib_1.__extends(Distribution, _super);
        function Distribution() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Distribution;
    }(enum_prop('Distribution', enums.Distribution));
    exports.Distribution = Distribution;
    var StepMode = function (_super) {
        tslib_1.__extends(StepMode, _super);
        function StepMode() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return StepMode;
    }(enum_prop('StepMode', enums.StepMode));
    exports.StepMode = StepMode;
    var PaddingUnits = function (_super) {
        tslib_1.__extends(PaddingUnits, _super);
        function PaddingUnits() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return PaddingUnits;
    }(enum_prop('PaddingUnits', enums.PaddingUnits));
    exports.PaddingUnits = PaddingUnits;
    var StartEnd = function (_super) {
        tslib_1.__extends(StartEnd, _super);
        function StartEnd() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return StartEnd;
    }(enum_prop('StartEnd', enums.StartEnd));
    exports.StartEnd = StartEnd;
    //
    // Units Properties
    //
    function units_prop(name, valid_units, default_units) {
        return function (_super) {
            tslib_1.__extends(class_3, _super);
            function class_3() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_3.prototype.init = function () {
                if (this.spec.units == null)
                    this.spec.units = default_units;
                var units = this.spec.units;
                if (!array_1.includes(valid_units, units))
                    throw new Error(name + ' units must be one of ' + valid_units + ', given invalid value: ' + units);
            };
            Object.defineProperty(class_3.prototype, 'units', {
                get: function () {
                    return this.spec.units;
                },
                set: function (units) {
                    this.spec.units = units;
                },
                enumerable: true,
                configurable: true
            });
            return class_3;
        }(Number);
    }
    exports.units_prop = units_prop;
    var Angle = function (_super) {
        tslib_1.__extends(Angle, _super);
        function Angle() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Angle.prototype.transform = function (values) {
            if (this.spec.units == 'deg')
                values = arrayable_1.map(values, function (x) {
                    return x * Math.PI / 180;
                });
            values = arrayable_1.map(values, function (x) {
                return -x;
            });
            return _super.prototype.transform.call(this, values);
        };
        return Angle;
    }(units_prop('Angle', enums.AngleUnits, 'rad'));
    exports.Angle = Angle;
    var Distance = function (_super) {
        tslib_1.__extends(Distance, _super);
        function Distance() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Distance;
    }(units_prop('Distance', enums.SpatialUnits, 'data'));
    exports.Distance = Distance;
    //
    // DataSpec properties
    //
    var AngleSpec = function (_super) {
        tslib_1.__extends(AngleSpec, _super);
        function AngleSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return AngleSpec;
    }(Angle);
    exports.AngleSpec = AngleSpec;
    AngleSpec.prototype.dataspec = true;
    var ColorSpec = function (_super) {
        tslib_1.__extends(ColorSpec, _super);
        function ColorSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return ColorSpec;
    }(Color);
    exports.ColorSpec = ColorSpec;
    ColorSpec.prototype.dataspec = true;
    var DistanceSpec = function (_super) {
        tslib_1.__extends(DistanceSpec, _super);
        function DistanceSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DistanceSpec;
    }(Distance);
    exports.DistanceSpec = DistanceSpec;
    DistanceSpec.prototype.dataspec = true;
    var FontSizeSpec = function (_super) {
        tslib_1.__extends(FontSizeSpec, _super);
        function FontSizeSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontSizeSpec;
    }(String);
    exports.FontSizeSpec = FontSizeSpec;
    FontSizeSpec.prototype.dataspec = true;
    var NumberSpec = function (_super) {
        tslib_1.__extends(NumberSpec, _super);
        function NumberSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return NumberSpec;
    }(Number);
    exports.NumberSpec = NumberSpec;
    NumberSpec.prototype.dataspec = true;
    var StringSpec = function (_super) {
        tslib_1.__extends(StringSpec, _super);
        function StringSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return StringSpec;
    }(String);
    exports.StringSpec = StringSpec;
    StringSpec.prototype.dataspec = true;    
},
/*core/property_mixins*/
function _(require, module, exports) {
    var p = require(15    /* ./properties */);
    var object_1 = require(32    /* ./util/object */);
    function _gen_mixin(mixin, prefix) {
        var result = {};
        for (var name_1 in mixin) {
            var prop = mixin[name_1];
            result[prefix + name_1] = prop;
        }
        return result;
    }
    var _line_mixin = {
        line_color: [
            p.ColorSpec,
            'black'
        ],
        line_width: [
            p.NumberSpec,
            1
        ],
        line_alpha: [
            p.NumberSpec,
            1
        ],
        line_join: [
            p.LineJoin,
            'miter'
        ],
        line_cap: [
            p.LineCap,
            'butt'
        ],
        line_dash: [
            p.Array,
            []
        ],
        line_dash_offset: [
            p.Number,
            0
        ]
    };
    exports.line = function (prefix) {
        if (prefix === void 0) {
            prefix = '';
        }
        return _gen_mixin(_line_mixin, prefix);
    };
    var _fill_mixin = {
        fill_color: [
            p.ColorSpec,
            'gray'
        ],
        fill_alpha: [
            p.NumberSpec,
            1
        ]
    };
    exports.fill = function (prefix) {
        if (prefix === void 0) {
            prefix = '';
        }
        return _gen_mixin(_fill_mixin, prefix);
    };
    var _text_mixin = {
        text_font: [
            p.Font,
            'helvetica'
        ],
        text_font_size: [
            p.FontSizeSpec,
            '12pt'
        ],
        text_font_style: [
            p.FontStyle,
            'normal'
        ],
        text_color: [
            p.ColorSpec,
            '#444444'
        ],
        text_alpha: [
            p.NumberSpec,
            1
        ],
        text_align: [
            p.TextAlign,
            'left'
        ],
        text_baseline: [
            p.TextBaseline,
            'bottom'
        ],
        text_line_height: [
            p.Number,
            1.2
        ]
    };
    exports.text = function (prefix) {
        if (prefix === void 0) {
            prefix = '';
        }
        return _gen_mixin(_text_mixin, prefix);
    };
    function create(configs) {
        var result = {};
        for (var _i = 0, configs_1 = configs; _i < configs_1.length; _i++) {
            var config = configs_1[_i];
            var _a = config.split(':'), kind = _a[0], prefix = _a[1];
            var mixin = void 0;
            switch (kind) {
            case 'line':
                mixin = exports.line;
                break;
            case 'fill':
                mixin = exports.fill;
                break;
            case 'text':
                mixin = exports.text;
                break;
            default:
                throw new Error('Unknown property mixin kind \'' + kind + '\'');
            }
            object_1.extend(result, mixin(prefix));
        }
        return result;
    }
    exports.create = create;    
},
/*core/selection_manager*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var has_props_1 = require(8    /* ./has_props */);
    var selection_1 = require(181    /* models/selections/selection */);
    var glyph_renderer_1 = require(169    /* models/renderers/glyph_renderer */);
    var graph_renderer_1 = require(170    /* models/renderers/graph_renderer */);
    var p = require(15    /* ./properties */);
    var SelectionManager = function (_super) {
        tslib_1.__extends(SelectionManager, _super);
        function SelectionManager() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SelectionManager.initClass = function () {
            this.prototype.type = 'SelectionManager';
            this.internal({ source: [p.Any] });
        };
        SelectionManager.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.inspectors = {};
        };
        SelectionManager.prototype.select = function (renderer_views, geometry, final, append) {
            if (append === void 0) {
                append = false;
            }
            // divide renderers into glyph_renderers or graph_renderers
            var glyph_renderer_views = [];
            var graph_renderer_views = [];
            for (var _i = 0, renderer_views_1 = renderer_views; _i < renderer_views_1.length; _i++) {
                var r = renderer_views_1[_i];
                if (r instanceof glyph_renderer_1.GlyphRendererView)
                    glyph_renderer_views.push(r);
                else if (r instanceof graph_renderer_1.GraphRendererView)
                    graph_renderer_views.push(r);
            }
            var did_hit = false;
            // graph renderer case
            for (var _a = 0, graph_renderer_views_1 = graph_renderer_views; _a < graph_renderer_views_1.length; _a++) {
                var r = graph_renderer_views_1[_a];
                var hit_test_result = r.model.selection_policy.hit_test(geometry, r);
                did_hit = did_hit || r.model.selection_policy.do_selection(hit_test_result, r.model, final, append);
            }
            // glyph renderers
            if (glyph_renderer_views.length > 0) {
                var hit_test_result = this.source.selection_policy.hit_test(geometry, glyph_renderer_views);
                did_hit = did_hit || this.source.selection_policy.do_selection(hit_test_result, this.source, final, append);
            }
            return did_hit;
        };
        SelectionManager.prototype.inspect = function (renderer_view, geometry) {
            var did_hit = false;
            if (renderer_view instanceof glyph_renderer_1.GlyphRendererView) {
                var hit_test_result = renderer_view.hit_test(geometry);
                if (hit_test_result != null) {
                    did_hit = !hit_test_result.is_empty();
                    var inspection = this.get_or_create_inspector(renderer_view.model);
                    inspection.update(hit_test_result, true, false);
                    this.source.setv({ inspected: inspection }, { silent: true });
                    this.source.inspect.emit([
                        renderer_view,
                        { geometry: geometry }
                    ]);
                }
            } else if (renderer_view instanceof graph_renderer_1.GraphRendererView) {
                var hit_test_result = renderer_view.model.inspection_policy.hit_test(geometry, renderer_view);
                did_hit = did_hit || renderer_view.model.inspection_policy.do_inspection(hit_test_result, geometry, renderer_view, false, false);
            }
            return did_hit;
        };
        SelectionManager.prototype.clear = function (rview) {
            this.source.selected.clear();
            if (rview != null)
                this.get_or_create_inspector(rview.model).clear();
        };
        SelectionManager.prototype.get_or_create_inspector = function (rmodel) {
            if (this.inspectors[rmodel.id] == null)
                this.inspectors[rmodel.id] = new selection_1.Selection();
            return this.inspectors[rmodel.id];
        };
        return SelectionManager;
    }(has_props_1.HasProps);
    exports.SelectionManager = SelectionManager;
    SelectionManager.initClass();    
},
/*core/settings*/
function _(require, module, exports) {
    var Settings = function () {
        function Settings() {
            this._dev = false;
        }
        Object.defineProperty(Settings.prototype, 'dev', {
            get: function () {
                return this._dev;
            },
            set: function (dev) {
                this._dev = dev;
            },
            enumerable: true,
            configurable: true
        });
        return Settings;
    }();
    exports.Settings = Settings;
    exports.settings = new Settings();    
},
/*core/signaling*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var callback_1 = require(25    /* ./util/callback */);
    var array_1 = require(21    /* ./util/array */);
    var Signal = function () {
        function Signal(sender, name) {
            this.sender = sender;
            this.name = name;
        }
        Signal.prototype.connect = function (slot, context) {
            if (context === void 0) {
                context = null;
            }
            if (!receiversForSender.has(this.sender)) {
                receiversForSender.set(this.sender, []);
            }
            var receivers = receiversForSender.get(this.sender);
            if (findConnection(receivers, this, slot, context) != null) {
                return false;
            }
            var receiver = context || slot;
            if (!sendersForReceiver.has(receiver)) {
                sendersForReceiver.set(receiver, []);
            }
            var senders = sendersForReceiver.get(receiver);
            var connection = {
                signal: this,
                slot: slot,
                context: context
            };
            receivers.push(connection);
            senders.push(connection);
            return true;
        };
        Signal.prototype.disconnect = function (slot, context) {
            if (context === void 0) {
                context = null;
            }
            var receivers = receiversForSender.get(this.sender);
            if (receivers == null || receivers.length === 0) {
                return false;
            }
            var connection = findConnection(receivers, this, slot, context);
            if (connection == null) {
                return false;
            }
            var receiver = context || slot;
            var senders = sendersForReceiver.get(receiver);
            connection.signal = null;
            scheduleCleanup(receivers);
            scheduleCleanup(senders);
            return true;
        };
        Signal.prototype.emit = function (args) {
            var receivers = receiversForSender.get(this.sender) || [];
            for (var _i = 0, receivers_1 = receivers; _i < receivers_1.length; _i++) {
                var _a = receivers_1[_i], signal = _a.signal, slot = _a.slot, context = _a.context;
                if (signal === this) {
                    slot.call(context, args, this.sender);
                }
            }
        };
        return Signal;
    }();
    exports.Signal = Signal;
    var Signal0 = function (_super) {
        tslib_1.__extends(Signal0, _super);
        function Signal0() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Signal0.prototype.emit = function () {
            _super.prototype.emit.call(this, undefined);
        };
        return Signal0;
    }(Signal);
    exports.Signal0 = Signal0;
    (function (Signal) {
        function disconnectBetween(sender, receiver) {
            var receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            var senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            for (var _i = 0, senders_1 = senders; _i < senders_1.length; _i++) {
                var connection = senders_1[_i];
                if (connection.signal == null)
                    return;
                if (connection.signal.sender === sender)
                    connection.signal = null;
            }
            scheduleCleanup(receivers);
            scheduleCleanup(senders);
        }
        Signal.disconnectBetween = disconnectBetween;
        function disconnectSender(sender) {
            var receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            for (var _i = 0, receivers_2 = receivers; _i < receivers_2.length; _i++) {
                var connection = receivers_2[_i];
                if (connection.signal == null)
                    return;
                var receiver = connection.context || connection.slot;
                connection.signal = null;
                scheduleCleanup(sendersForReceiver.get(receiver));
            }
            scheduleCleanup(receivers);
        }
        Signal.disconnectSender = disconnectSender;
        function disconnectReceiver(receiver) {
            var senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            for (var _i = 0, senders_2 = senders; _i < senders_2.length; _i++) {
                var connection = senders_2[_i];
                if (connection.signal == null)
                    return;
                var sender = connection.signal.sender;
                connection.signal = null;
                scheduleCleanup(receiversForSender.get(sender));
            }
            scheduleCleanup(senders);
        }
        Signal.disconnectReceiver = disconnectReceiver;
        function disconnectAll(obj) {
            var receivers = receiversForSender.get(obj);
            if (receivers != null && receivers.length !== 0) {
                for (var _i = 0, receivers_3 = receivers; _i < receivers_3.length; _i++) {
                    var connection = receivers_3[_i];
                    connection.signal = null;
                }
                scheduleCleanup(receivers);
            }
            var senders = sendersForReceiver.get(obj);
            if (senders != null && senders.length !== 0) {
                for (var _a = 0, senders_3 = senders; _a < senders_3.length; _a++) {
                    var connection = senders_3[_a];
                    connection.signal = null;
                }
                scheduleCleanup(senders);
            }
        }
        Signal.disconnectAll = disconnectAll;
    }(Signal = exports.Signal || (exports.Signal = {})));
    exports.Signal = Signal;
    function Signalable(Base) {
        // XXX: `class Foo extends Signalable(Object)` doesn't work (compiles, but fails at runtime), so
        // we have to do this to allow signalable classes without an explict base class.
        if (Base != null) {
            return function (_super) {
                tslib_1.__extends(class_1, _super);
                function class_1() {
                    return _super !== null && _super.apply(this, arguments) || this;
                }
                class_1.prototype.connect = function (signal, slot) {
                    return signal.connect(slot, this);
                };
                return class_1;
            }(Base);
        } else {
            return function () {
                function class_2() {
                }
                class_2.prototype.connect = function (signal, slot) {
                    return signal.connect(slot, this);
                };
                return class_2;
            }();
        }
    }
    exports.Signalable = Signalable;
    var _Signalable;
    (function (_Signalable) {
        function connect(signal, slot) {
            return signal.connect(slot, this);
        }
        _Signalable.connect = connect;
    }(_Signalable = exports._Signalable || (exports._Signalable = {})));
    var receiversForSender = new WeakMap();
    var sendersForReceiver = new WeakMap();
    function findConnection(conns, signal, slot, context) {
        return array_1.find(conns, function (conn) {
            return conn.signal === signal && conn.slot === slot && conn.context === context;
        });
    }
    var dirtySet = new Set();
    function scheduleCleanup(connections) {
        if (dirtySet.size === 0) {
            callback_1.defer(cleanupDirtySet);
        }
        dirtySet.add(connections);
    }
    function cleanupDirtySet() {
        dirtySet.forEach(function (connections) {
            array_1.removeBy(connections, function (connection) {
                return connection.signal == null;
            });
        });
        dirtySet.clear();
    }    
},
/*core/ui_events*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var Hammer = require(336    /* hammerjs */);
    var signaling_1 = require(19    /* ./signaling */);
    var logging_1 = require(14    /* ./logging */);
    var dom_1 = require(5    /* ./dom */);
    var wheel_1 = require(45    /* ./util/wheel */);
    var array_1 = require(21    /* ./util/array */);
    var object_1 = require(32    /* ./util/object */);
    var types_1 = require(44    /* ./util/types */);
    var bokeh_events_1 = require(3    /* ./bokeh_events */);
    exports.is_mobile = 'ontouchstart' in window || navigator.maxTouchPoints > 0;
    var UIEvents = function () {
        function UIEvents(plot_view, toolbar, hit_area, plot) {
            this.plot_view = plot_view;
            this.toolbar = toolbar;
            this.hit_area = hit_area;
            this.plot = plot;
            this.pan_start = new signaling_1.Signal(this, 'pan:start');
            this.pan = new signaling_1.Signal(this, 'pan');
            this.pan_end = new signaling_1.Signal(this, 'pan:end');
            this.pinch_start = new signaling_1.Signal(this, 'pinch:start');
            this.pinch = new signaling_1.Signal(this, 'pinch');
            this.pinch_end = new signaling_1.Signal(this, 'pinch:end');
            this.rotate_start = new signaling_1.Signal(this, 'rotate:start');
            this.rotate = new signaling_1.Signal(this, 'rotate');
            this.rotate_end = new signaling_1.Signal(this, 'rotate:end');
            this.tap = new signaling_1.Signal(this, 'tap');
            this.doubletap = new signaling_1.Signal(this, 'doubletap');
            this.press = new signaling_1.Signal(this, 'press');
            this.move_enter = new signaling_1.Signal(this, 'move:enter');
            this.move = new signaling_1.Signal(this, 'move');
            this.move_exit = new signaling_1.Signal(this, 'move:exit');
            this.scroll = new signaling_1.Signal(this, 'scroll');
            this.keydown = new signaling_1.Signal(this, 'keydown');
            this.keyup = new signaling_1.Signal(this, 'keyup');
            this.hammer = new Hammer(this.hit_area);
            this._configure_hammerjs();
        }
        UIEvents.prototype._configure_hammerjs = function () {
            var _this = this;
            // This is to be able to distinguish double taps from single taps
            this.hammer.get('doubletap').recognizeWith('tap');
            this.hammer.get('tap').requireFailure('doubletap');
            this.hammer.get('doubletap').dropRequireFailure('tap');
            this.hammer.on('doubletap', function (e) {
                return _this._doubletap(e);
            });
            this.hammer.on('tap', function (e) {
                return _this._tap(e);
            });
            this.hammer.on('press', function (e) {
                return _this._press(e);
            });
            this.hammer.get('pan').set({ direction: Hammer.DIRECTION_ALL });
            this.hammer.on('panstart', function (e) {
                return _this._pan_start(e);
            });
            this.hammer.on('pan', function (e) {
                return _this._pan(e);
            });
            this.hammer.on('panend', function (e) {
                return _this._pan_end(e);
            });
            this.hammer.get('pinch').set({ enable: true });
            this.hammer.on('pinchstart', function (e) {
                return _this._pinch_start(e);
            });
            this.hammer.on('pinch', function (e) {
                return _this._pinch(e);
            });
            this.hammer.on('pinchend', function (e) {
                return _this._pinch_end(e);
            });
            this.hammer.get('rotate').set({ enable: true });
            this.hammer.on('rotatestart', function (e) {
                return _this._rotate_start(e);
            });
            this.hammer.on('rotate', function (e) {
                return _this._rotate(e);
            });
            this.hammer.on('rotateend', function (e) {
                return _this._rotate_end(e);
            });
            this.hit_area.addEventListener('mousemove', function (e) {
                return _this._mouse_move(e);
            });
            this.hit_area.addEventListener('mouseenter', function (e) {
                return _this._mouse_enter(e);
            });
            this.hit_area.addEventListener('mouseleave', function (e) {
                return _this._mouse_exit(e);
            });
            this.hit_area.addEventListener('wheel', function (e) {
                return _this._mouse_wheel(e);
            });
            document.addEventListener('keydown', function (e) {
                return _this._key_down(e);
            });
            document.addEventListener('keyup', function (e) {
                return _this._key_up(e);
            });
        };
        UIEvents.prototype.register_tool = function (tool_view) {
            var _this = this;
            var et = tool_view.model.event_type;
            if (et != null) {
                if (types_1.isString(et))
                    this._register_tool(tool_view, et);
                else {
                    // Multi-tools should only registered shared events once
                    et.forEach(function (e, index) {
                        return _this._register_tool(tool_view, e, index < 1);
                    });
                }
            }
        };
        UIEvents.prototype._register_tool = function (tool_view, et, shared) {
            if (shared === void 0) {
                shared = true;
            }
            var v = tool_view;
            var id = v.model.id;
            var conditionally = function (fn) {
                return function (arg) {
                    if (arg.id == id)
                        fn(arg.e);
                };
            };
            var unconditionally = function (fn) {
                return function (arg) {
                    fn(arg.e);
                };
            };
            switch (et) {
            case 'pan': {
                    if (v._pan_start != null)
                        v.connect(this.pan_start, conditionally(v._pan_start.bind(v)));
                    if (v._pan != null)
                        v.connect(this.pan, conditionally(v._pan.bind(v)));
                    if (v._pan_end != null)
                        v.connect(this.pan_end, conditionally(v._pan_end.bind(v)));
                    break;
                }
            case 'pinch': {
                    if (v._pinch_start != null)
                        v.connect(this.pinch_start, conditionally(v._pinch_start.bind(v)));
                    if (v._pinch != null)
                        v.connect(this.pinch, conditionally(v._pinch.bind(v)));
                    if (v._pinch_end != null)
                        v.connect(this.pinch_end, conditionally(v._pinch_end.bind(v)));
                    break;
                }
            case 'rotate': {
                    if (v._rotate_start != null)
                        v.connect(this.rotate_start, conditionally(v._rotate_start.bind(v)));
                    if (v._rotate != null)
                        v.connect(this.rotate, conditionally(v._rotate.bind(v)));
                    if (v._rotate_end != null)
                        v.connect(this.rotate_end, conditionally(v._rotate_end.bind(v)));
                    break;
                }
            case 'move': {
                    if (v._move_enter != null)
                        v.connect(this.move_enter, conditionally(v._move_enter.bind(v)));
                    if (v._move != null)
                        v.connect(this.move, conditionally(v._move.bind(v)));
                    if (v._move_exit != null)
                        v.connect(this.move_exit, conditionally(v._move_exit.bind(v)));
                    break;
                }
            case 'tap': {
                    if (v._tap != null)
                        v.connect(this.tap, conditionally(v._tap.bind(v)));
                    break;
                }
            case 'press': {
                    if (v._press != null)
                        v.connect(this.press, conditionally(v._press.bind(v)));
                    break;
                }
            case 'scroll': {
                    if (v._scroll != null)
                        v.connect(this.scroll, conditionally(v._scroll.bind(v)));
                    break;
                }
            default:
                throw new Error('unsupported event_type: ' + et);
            }
            // Skip shared events if registering multi-tool
            if (!shared)
                return;
            if (v._doubletap != null)
                v.connect(this.doubletap, unconditionally(v._doubletap.bind(v)));
            if (v._keydown != null)
                v.connect(this.keydown, unconditionally(v._keydown.bind(v)));
            if (v._keyup != null)
                v.connect(this.keyup, unconditionally(v._keyup.bind(v)));
            // Dual touch hack part 1/2
            // This is a hack for laptops with touch screen who may be pinching or scrolling
            // in order to use the wheel zoom tool. If it's a touch screen the WheelZoomTool event
            // will be linked to pinch. But we also want to trigger in the case of a scroll.
            if (exports.is_mobile && v._scroll != null && et == 'pinch') {
                logging_1.logger.debug('Registering scroll on touch screen');
                v.connect(this.scroll, conditionally(v._scroll.bind(v)));
            }
        };
        UIEvents.prototype._hit_test_renderers = function (sx, sy) {
            var views = this.plot_view.get_renderer_views();
            for (var _i = 0, _a = array_1.reversed(views); _i < _a.length; _i++) {
                var view = _a[_i];
                var level = view.model.level;
                if ((level == 'annotation' || level == 'overlay') && view.bbox != null) {
                    if (view.bbox().contains(sx, sy))
                        return view;
                }
            }
            return null;
        };
        UIEvents.prototype._hit_test_frame = function (sx, sy) {
            return this.plot_view.frame.bbox.contains(sx, sy);
        };
        UIEvents.prototype._trigger = function (signal, e, srcEvent) {
            var _this = this;
            var gestures = this.toolbar.gestures;
            var event_type = signal.name;
            var base_type = event_type.split(':')[0];
            var view = this._hit_test_renderers(e.sx, e.sy);
            switch (base_type) {
            case 'move': {
                    var active_gesture = gestures[base_type].active;
                    if (active_gesture != null)
                        this.trigger(signal, e, active_gesture.id);
                    var active_inspectors = this.toolbar.inspectors.filter(function (t) {
                        return t.active;
                    });
                    var cursor = 'default';
                    // the event happened on a renderer
                    if (view != null) {
                        cursor = view.cursor || cursor;
                        if (!object_1.isEmpty(active_inspectors)) {
                            // override event_type to cause inspectors to clear overlays
                            signal = this.move_exit;
                            event_type = signal.name;
                        }    // the event happened on the plot frame but off a renderer
                    } else if (this._hit_test_frame(e.sx, e.sy)) {
                        if (!object_1.isEmpty(active_inspectors)) {
                            cursor = 'crosshair';
                        }
                    }
                    this.plot_view.set_cursor(cursor);
                    active_inspectors.map(function (inspector) {
                        return _this.trigger(signal, e, inspector.id);
                    });
                    break;
                }
            case 'tap': {
                    var target = srcEvent.target;
                    if (target != null && target != this.hit_area)
                        return;
                    // don't trigger bokeh events
                    if (view != null && view.on_hit != null)
                        view.on_hit(e.sx, e.sy);
                    var active_gesture = gestures[base_type].active;
                    if (active_gesture != null)
                        this.trigger(signal, e, active_gesture.id);
                    break;
                }
            case 'scroll': {
                    // Dual touch hack part 2/2
                    // This is a hack for laptops with touch screen who may be pinching or scrolling
                    // in order to use the wheel zoom tool. If it's a touch screen the WheelZoomTool event
                    // will be linked to pinch. But we also want to trigger in the case of a scroll.
                    var base = exports.is_mobile ? 'pinch' : 'scroll';
                    var active_gesture = gestures[base].active;
                    if (active_gesture != null) {
                        srcEvent.preventDefault();
                        srcEvent.stopPropagation();
                        this.trigger(signal, e, active_gesture.id);
                    }
                    break;
                }
            default: {
                    var active_gesture = gestures[base_type].active;
                    if (active_gesture != null)
                        this.trigger(signal, e, active_gesture.id);
                }
            }
            this._trigger_bokeh_event(e);
        };
        UIEvents.prototype.trigger = function (signal, e, id) {
            if (id === void 0) {
                id = null;
            }
            signal.emit({
                id: id,
                e: e
            });
        };
        UIEvents.prototype._trigger_bokeh_event = function (e) {
            var event_cls = bokeh_events_1.BokehEvent.event_class(e);
            if (event_cls != null)
                this.plot.trigger_event(event_cls.from_event(e));
            else
                logging_1.logger.debug('Unhandled event of type ' + e.type);
        };
        UIEvents.prototype._get_sxy = function (event) {
            // XXX: jsdom doesn't support TouchEvent constructor
            function is_touch(event) {
                return typeof TouchEvent !== 'undefined' && event instanceof TouchEvent;
            }
            var _a = is_touch(event) ? (event.touches.length != 0 ? event.touches : event.changedTouches)[0] : event, pageX = _a.pageX, pageY = _a.pageY;
            var _b = dom_1.offset(this.hit_area), left = _b.left, top = _b.top;
            return {
                sx: pageX - left,
                sy: pageY - top
            };
        };
        UIEvents.prototype._gesture_event = function (e) {
            return tslib_1.__assign({ type: e.type }, this._get_sxy(e.srcEvent), {
                deltaX: e.deltaX,
                deltaY: e.deltaY,
                scale: e.scale,
                shiftKey: e.srcEvent.shiftKey
            });
        };
        UIEvents.prototype._tap_event = function (e) {
            return tslib_1.__assign({ type: e.type }, this._get_sxy(e.srcEvent), { shiftKey: e.srcEvent.shiftKey });
        };
        UIEvents.prototype._move_event = function (e) {
            return tslib_1.__assign({ type: e.type }, this._get_sxy(e));
        };
        UIEvents.prototype._scroll_event = function (e) {
            return tslib_1.__assign({ type: e.type }, this._get_sxy(e), { delta: wheel_1.getDeltaY(e) });
        };
        UIEvents.prototype._key_event = function (e) {
            return {
                type: e.type,
                keyCode: e.keyCode
            };
        };
        UIEvents.prototype._pan_start = function (e) {
            var ev = this._gesture_event(e);
            // back out delta to get original center point
            ev.sx -= e.deltaX;
            ev.sy -= e.deltaY;
            this._trigger(this.pan_start, ev, e.srcEvent);
        };
        UIEvents.prototype._pan = function (e) {
            this._trigger(this.pan, this._gesture_event(e), e.srcEvent);
        };
        UIEvents.prototype._pan_end = function (e) {
            this._trigger(this.pan_end, this._gesture_event(e), e.srcEvent);
        };
        UIEvents.prototype._pinch_start = function (e) {
            this._trigger(this.pinch_start, this._gesture_event(e), e.srcEvent);
        };
        UIEvents.prototype._pinch = function (e) {
            this._trigger(this.pinch, this._gesture_event(e), e.srcEvent);
        };
        UIEvents.prototype._pinch_end = function (e) {
            this._trigger(this.pinch_end, this._gesture_event(e), e.srcEvent);
        };
        UIEvents.prototype._rotate_start = function (e) {
            this._trigger(this.rotate_start, this._gesture_event(e), e.srcEvent);
        };
        UIEvents.prototype._rotate = function (e) {
            this._trigger(this.rotate, this._gesture_event(e), e.srcEvent);
        };
        UIEvents.prototype._rotate_end = function (e) {
            this._trigger(this.rotate_end, this._gesture_event(e), e.srcEvent);
        };
        UIEvents.prototype._tap = function (e) {
            this._trigger(this.tap, this._tap_event(e), e.srcEvent);
        };
        UIEvents.prototype._doubletap = function (e) {
            // NOTE: doubletap event triggered unconditionally
            var ev = this._tap_event(e);
            this._trigger_bokeh_event(ev);
            this.trigger(this.doubletap, ev);
        };
        UIEvents.prototype._press = function (e) {
            this._trigger(this.press, this._tap_event(e), e.srcEvent);
        };
        UIEvents.prototype._mouse_enter = function (e) {
            this._trigger(this.move_enter, this._move_event(e), e);
        };
        UIEvents.prototype._mouse_move = function (e) {
            this._trigger(this.move, this._move_event(e), e);
        };
        UIEvents.prototype._mouse_exit = function (e) {
            this._trigger(this.move_exit, this._move_event(e), e);
        };
        UIEvents.prototype._mouse_wheel = function (e) {
            this._trigger(this.scroll, this._scroll_event(e), e);
        };
        UIEvents.prototype._key_down = function (e) {
            // NOTE: keyup event triggered unconditionally
            this.trigger(this.keydown, this._key_event(e));
        };
        UIEvents.prototype._key_up = function (e) {
            // NOTE: keyup event triggered unconditionally
            this.trigger(this.keyup, this._key_event(e));
        };
        return UIEvents;
    }();
    exports.UIEvents = UIEvents;    
},
/*core/util/array*/
function _(require, module, exports) {
    var math_1 = require(31    /* ./math */);
    var assert_1 = require(23    /* ./assert */);
    var arrayable_1 = require(22    /* ./arrayable */);
    exports.min = arrayable_1.min;
    exports.minBy = arrayable_1.minBy;
    exports.max = arrayable_1.max;
    exports.maxBy = arrayable_1.maxBy;
    exports.sum = arrayable_1.sum;
    var slice = Array.prototype.slice;
    function head(array) {
        return array[0];
    }
    exports.head = head;
    function tail(array) {
        return array[array.length - 1];
    }
    exports.tail = tail;
    function last(array) {
        return array[array.length - 1];
    }
    exports.last = last;
    function copy(array) {
        return slice.call(array);
    }
    exports.copy = copy;
    function concat(arrays) {
        return (_a = []).concat.apply(_a, arrays);
        var _a;
    }
    exports.concat = concat;
    function includes(array, value) {
        return array.indexOf(value) !== -1;
    }
    exports.includes = includes;
    exports.contains = includes;
    function nth(array, index) {
        return array[index >= 0 ? index : array.length + index];
    }
    exports.nth = nth;
    function zip(As, Bs) {
        var n = Math.min(As.length, Bs.length);
        var ABs = new Array(n);
        for (var i = 0; i < n; i++) {
            ABs[i] = [
                As[i],
                Bs[i]
            ];
        }
        return ABs;
    }
    exports.zip = zip;
    function unzip(ABs) {
        var n = ABs.length;
        var As = new Array(n);
        var Bs = new Array(n);
        for (var i = 0; i < n; i++) {
            _a = ABs[i], As[i] = _a[0], Bs[i] = _a[1];
        }
        return [
            As,
            Bs
        ];
        var _a;
    }
    exports.unzip = unzip;
    function range(start, stop, step) {
        if (step === void 0) {
            step = 1;
        }
        assert_1.assert(step > 0, '\'step\' must be a positive number');
        if (stop == null) {
            stop = start;
            start = 0;
        }
        var max = Math.max, ceil = Math.ceil, abs = Math.abs;
        var delta = start <= stop ? step : -step;
        var length = max(ceil(abs(stop - start) / step), 0);
        var range = Array(length);
        for (var i = 0; i < length; i++, start += delta) {
            range[i] = start;
        }
        return range;
    }
    exports.range = range;
    function linspace(start, stop, num) {
        if (num === void 0) {
            num = 100;
        }
        var step = (stop - start) / (num - 1);
        var array = new Array(num);
        for (var i = 0; i < num; i++) {
            array[i] = start + step * i;
        }
        return array;
    }
    exports.linspace = linspace;
    function transpose(array) {
        var rows = array.length;
        var cols = array[0].length;
        var transposed = [];
        for (var j = 0; j < cols; j++) {
            transposed[j] = [];
            for (var i = 0; i < rows; i++) {
                transposed[j][i] = array[i][j];
            }
        }
        return transposed;
    }
    exports.transpose = transpose;
    function cumsum(array) {
        var result = [];
        array.reduce(function (a, b, i) {
            return result[i] = a + b;
        }, 0);
        return result;
    }
    exports.cumsum = cumsum;
    function argmin(array) {
        return arrayable_1.minBy(range(array.length), function (i) {
            return array[i];
        });
    }
    exports.argmin = argmin;
    function argmax(array) {
        return arrayable_1.maxBy(range(array.length), function (i) {
            return array[i];
        });
    }
    exports.argmax = argmax;
    function all(array, predicate) {
        for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
            var item = array_1[_i];
            if (!predicate(item))
                return false;
        }
        return true;
    }
    exports.all = all;
    function any(array, predicate) {
        for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
            var item = array_2[_i];
            if (predicate(item))
                return true;
        }
        return false;
    }
    exports.any = any;
    function findIndexFactory(dir) {
        return function (array, predicate) {
            var length = array.length;
            var index = dir > 0 ? 0 : length - 1;
            for (; index >= 0 && index < length; index += dir) {
                if (predicate(array[index]))
                    return index;
            }
            return -1;
        };
    }
    exports.findIndex = findIndexFactory(1);
    exports.findLastIndex = findIndexFactory(-1);
    function find(array, predicate) {
        var index = exports.findIndex(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find = find;
    function findLast(array, predicate) {
        var index = exports.findLastIndex(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.findLast = findLast;
    function sortedIndex(array, value) {
        var low = 0;
        var high = array.length;
        while (low < high) {
            var mid = Math.floor((low + high) / 2);
            if (array[mid] < value)
                low = mid + 1;
            else
                high = mid;
        }
        return low;
    }
    exports.sortedIndex = sortedIndex;
    function sortBy(array, key) {
        var tmp = array.map(function (value, index) {
            return {
                value: value,
                index: index,
                key: key(value)
            };
        });
        tmp.sort(function (left, right) {
            var a = left.key;
            var b = right.key;
            if (a !== b) {
                if (a > b || a === undefined)
                    return 1;
                if (a < b || b === undefined)
                    return -1;
            }
            return left.index - right.index;
        });
        return tmp.map(function (item) {
            return item.value;
        });
    }
    exports.sortBy = sortBy;
    function uniq(array) {
        var result = [];
        for (var _i = 0, array_3 = array; _i < array_3.length; _i++) {
            var value = array_3[_i];
            if (!includes(result, value)) {
                result.push(value);
            }
        }
        return result;
    }
    exports.uniq = uniq;
    function uniqBy(array, key) {
        var result = [];
        var seen = [];
        for (var _i = 0, array_4 = array; _i < array_4.length; _i++) {
            var value = array_4[_i];
            var computed = key(value);
            if (!includes(seen, computed)) {
                seen.push(computed);
                result.push(value);
            }
        }
        return result;
    }
    exports.uniqBy = uniqBy;
    function union() {
        var arrays = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            arrays[_i] = arguments[_i];
        }
        return uniq(concat(arrays));
    }
    exports.union = union;
    function intersection(array) {
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var result = [];
        top:
            for (var _a = 0, array_5 = array; _a < array_5.length; _a++) {
                var item = array_5[_a];
                if (includes(result, item))
                    continue;
                for (var _b = 0, arrays_1 = arrays; _b < arrays_1.length; _b++) {
                    var other = arrays_1[_b];
                    if (!includes(other, item))
                        continue top;
                }
                result.push(item);
            }
        return result;
    }
    exports.intersection = intersection;
    function difference(array) {
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var rest = concat(arrays);
        return array.filter(function (value) {
            return !includes(rest, value);
        });
    }
    exports.difference = difference;
    function removeBy(array, key) {
        for (var i = 0; i < array.length;) {
            if (key(array[i]))
                array.splice(i, 1);
            else
                i++;
        }
    }
    exports.removeBy = removeBy;
    // Shuffle a collection, using the modern version of the
    // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
    function shuffle(array) {
        var length = array.length;
        var shuffled = new Array(length);
        for (var i = 0; i < length; i++) {
            var rand = math_1.randomIn(0, i);
            if (rand !== i)
                shuffled[i] = shuffled[rand];
            shuffled[rand] = array[i];
        }
        return shuffled;
    }
    exports.shuffle = shuffle;
    function pairwise(array, fn) {
        var n = array.length;
        var result = new Array(n - 1);
        for (var i = 0; i < n - 1; i++) {
            result[i] = fn(array[i], array[i + 1]);
        }
        return result;
    }
    exports.pairwise = pairwise;
    function reversed(array) {
        var n = array.length;
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[n - i - 1] = array[i];
        }
        return result;
    }
    exports.reversed = reversed;
    function repeat(value, n) {
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[i] = value;
        }
        return result;
    }
    exports.repeat = repeat;    
},
/*core/util/arrayable*/
function _(require, module, exports) {
    function splice(array, start, k) {
        var items = [];
        for (var _i = 3; _i < arguments.length; _i++) {
            items[_i - 3] = arguments[_i];
        }
        var len = array.length;
        if (start < 0)
            start += len;
        if (start < 0)
            start = 0;
        else if (start > len)
            start = len;
        if (k == null || k > len - start)
            k = len - start;
        else if (k < 0)
            k = 0;
        var n = len - k + items.length;
        var result = new array.constructor(n);
        var i = 0;
        for (; i < start; i++) {
            result[i] = array[i];
        }
        for (var _a = 0, items_1 = items; _a < items_1.length; _a++) {
            var item = items_1[_a];
            result[i++] = item;
        }
        for (var j = start + k; j < len; j++) {
            result[i++] = array[j];
        }
        return result;
    }
    exports.splice = splice;
    function insert(array, item, i) {
        return splice(array, i, 0, item);
    }
    exports.insert = insert;
    function append(array, item) {
        return splice(array, array.length, 0, item);
    }
    exports.append = append;
    function prepend(array, item) {
        return splice(array, 0, 0, item);
    }
    exports.prepend = prepend;
    function indexOf(array, item) {
        for (var i = 0, n = array.length; i < n; i++) {
            if (array[i] === item)
                return i;
        }
        return -1;
    }
    exports.indexOf = indexOf;
    function map(array, fn) {
        var n = array.length;
        var result = new array.constructor(n);
        for (var i = 0; i < n; i++) {
            result[i] = fn(array[i], i, array);
        }
        return result;
    }
    exports.map = map;
    function min(array) {
        var value;
        var result = Infinity;
        for (var i = 0, length_1 = array.length; i < length_1; i++) {
            value = array[i];
            if (value < result) {
                result = value;
            }
        }
        return result;
    }
    exports.min = min;
    function minBy(array, key) {
        if (array.length == 0)
            throw new Error('minBy() called with an empty array');
        var result = array[0];
        var resultComputed = key(result);
        for (var i = 1, length_2 = array.length; i < length_2; i++) {
            var value = array[i];
            var computed = key(value);
            if (computed < resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.minBy = minBy;
    function max(array) {
        var value;
        var result = -Infinity;
        for (var i = 0, length_3 = array.length; i < length_3; i++) {
            value = array[i];
            if (value > result) {
                result = value;
            }
        }
        return result;
    }
    exports.max = max;
    function maxBy(array, key) {
        if (array.length == 0)
            throw new Error('maxBy() called with an empty array');
        var result = array[0];
        var resultComputed = key(result);
        for (var i = 1, length_4 = array.length; i < length_4; i++) {
            var value = array[i];
            var computed = key(value);
            if (computed > resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.maxBy = maxBy;
    function sum(array) {
        var result = 0;
        for (var i = 0, n = array.length; i < n; i++) {
            result += array[i];
        }
        return result;
    }
    exports.sum = sum;    
},
/*core/util/assert*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var AssertionError = function (_super) {
        tslib_1.__extends(AssertionError, _super);
        function AssertionError() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return AssertionError;
    }(Error);
    exports.AssertionError = AssertionError;
    function assert(condition, message) {
        if (condition === true || condition !== false && condition())
            return;
        throw new AssertionError(message || 'Assertion failed');
    }
    exports.assert = assert;    
},
/*core/util/bbox*/
function _(require, module, exports) {
    var min = Math.min, max = Math.max;
    function empty() {
        return {
            minX: Infinity,
            minY: Infinity,
            maxX: -Infinity,
            maxY: -Infinity
        };
    }
    exports.empty = empty;
    function positive_x() {
        return {
            minX: Number.MIN_VALUE,
            minY: -Infinity,
            maxX: Infinity,
            maxY: Infinity
        };
    }
    exports.positive_x = positive_x;
    function positive_y() {
        return {
            minX: -Infinity,
            minY: Number.MIN_VALUE,
            maxX: Infinity,
            maxY: Infinity
        };
    }
    exports.positive_y = positive_y;
    function union(a, b) {
        return {
            minX: min(a.minX, b.minX),
            maxX: max(a.maxX, b.maxX),
            minY: min(a.minY, b.minY),
            maxY: max(a.maxY, b.maxY)
        };
    }
    exports.union = union;
    var BBox = function () {
        function BBox(box) {
            if ('x0' in box && 'y0' in box && 'x1' in box && 'y1' in box) {
                var _a = box, x0 = _a.x0, y0 = _a.y0, x1 = _a.x1, y1 = _a.y1;
                if (!(x0 <= x1 && y0 <= y1))
                    throw new Error('invalid bbox {x0: ' + x0 + ', y0: ' + y0 + ', x1: ' + x1 + ', y1: ' + y1 + '}');
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
            } else {
                var _b = box, x = _b.x, y = _b.y, width = _b.width, height = _b.height;
                if (!(width >= 0 && height >= 0))
                    throw new Error('invalid bbox {x: ' + x + ', y: ' + y + ', width: ' + width + ', height: ' + height + '}');
                this.x0 = x;
                this.y0 = y;
                this.x1 = x + width;
                this.y1 = y + height;
            }
        }
        Object.defineProperty(BBox.prototype, 'minX', {
            get: function () {
                return this.x0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'minY', {
            get: function () {
                return this.y0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'maxX', {
            get: function () {
                return this.x1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'maxY', {
            get: function () {
                return this.y1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'left', {
            get: function () {
                return this.x0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'top', {
            get: function () {
                return this.y0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'right', {
            get: function () {
                return this.x1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'bottom', {
            get: function () {
                return this.y1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'p0', {
            get: function () {
                return [
                    this.x0,
                    this.y0
                ];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'p1', {
            get: function () {
                return [
                    this.x1,
                    this.y1
                ];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'x', {
            get: function () {
                return this.x0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'y', {
            get: function () {
                return this.y0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'width', {
            get: function () {
                return this.x1 - this.x0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'height', {
            get: function () {
                return this.y1 - this.y0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'rect', {
            get: function () {
                return {
                    x: this.x,
                    y: this.y,
                    width: this.width,
                    height: this.height
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'h_range', {
            get: function () {
                return {
                    start: this.x0,
                    end: this.x1
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'v_range', {
            get: function () {
                return {
                    start: this.y0,
                    end: this.y1
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'ranges', {
            get: function () {
                return [
                    this.h_range,
                    this.v_range
                ];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'aspect', {
            get: function () {
                return this.width / this.height;
            },
            enumerable: true,
            configurable: true
        });
        BBox.prototype.contains = function (x, y) {
            return x >= this.x0 && x <= this.x1 && y >= this.y0 && y <= this.y1;
        };
        BBox.prototype.clip = function (x, y) {
            if (x < this.x0)
                x = this.x0;
            else if (x > this.x1)
                x = this.x1;
            if (y < this.y0)
                y = this.y0;
            else if (y > this.y1)
                y = this.y1;
            return [
                x,
                y
            ];
        };
        BBox.prototype.union = function (that) {
            return new BBox({
                x0: min(this.x0, that.x0),
                y0: min(this.y0, that.y0),
                x1: max(this.x1, that.x1),
                y1: max(this.y1, that.y1)
            });
        };
        return BBox;
    }();
    exports.BBox = BBox;    
},
/*core/util/callback*/
function _(require, module, exports) {
    function delay(func, wait) {
        return setTimeout(func, wait);
    }
    exports.delay = delay;
    var _defer = typeof requestAnimationFrame === 'function' ? requestAnimationFrame : setImmediate;
    function defer(func) {
        return _defer(func);
    }
    exports.defer = defer;
    function throttle(func, wait, options) {
        if (options === void 0) {
            options = {};
        }
        var context, args, result;
        var timeout = null;
        var previous = 0;
        var later = function () {
            previous = options.leading === false ? 0 : Date.now();
            timeout = null;
            result = func.apply(context, args);
            if (!timeout)
                context = args = null;
        };
        return function () {
            var now = Date.now();
            if (!previous && options.leading === false)
                previous = now;
            var remaining = wait - (now - previous);
            context = this;
            args = arguments;
            if (remaining <= 0 || remaining > wait) {
                if (timeout) {
                    clearTimeout(timeout);
                    timeout = null;
                }
                previous = now;
                result = func.apply(context, args);
                if (!timeout)
                    context = args = null;
            } else if (!timeout && options.trailing !== false) {
                timeout = setTimeout(later, remaining);
            }
            return result;
        };
    }
    exports.throttle = throttle;
    function once(func) {
        var done = false;
        var memo;
        return function () {
            if (!done) {
                done = true;
                memo = func();
            }
            return memo;
        };
    }
    exports.once = once;    
},
/*core/util/canvas*/
function _(require, module, exports) {
    function fixup_line_dash(ctx) {
        if (!ctx.setLineDash) {
            ctx.setLineDash = function (dash) {
                ctx.mozDash = dash;
                ctx.webkitLineDash = dash;
            };
        }
        if (!ctx.getLineDash) {
            ctx.getLineDash = function () {
                return ctx.mozDash;
            };
        }
    }
    function fixup_line_dash_offset(ctx) {
        ctx.setLineDashOffset = function (offset) {
            ctx.lineDashOffset = offset;
            ctx.mozDashOffset = offset;
            ctx.webkitLineDashOffset = offset;
        };
        ctx.getLineDashOffset = function () {
            return ctx.mozDashOffset;
        };
    }
    function fixup_image_smoothing(ctx) {
        ctx.setImageSmoothingEnabled = function (value) {
            ctx.imageSmoothingEnabled = value;
            ctx.mozImageSmoothingEnabled = value;
            ctx.oImageSmoothingEnabled = value;
            ctx.webkitImageSmoothingEnabled = value;
            ctx.msImageSmoothingEnabled = value;
        };
        ctx.getImageSmoothingEnabled = function () {
            var val = ctx.imageSmoothingEnabled;
            return val != null ? val : true;
        };
    }
    function fixup_measure_text(ctx) {
        if (ctx.measureText && ctx.html5MeasureText == null) {
            ctx.html5MeasureText = ctx.measureText;
            ctx.measureText = function (text) {
                var textMetrics = ctx.html5MeasureText(text);
                // fake it til you make it
                textMetrics.ascent = ctx.html5MeasureText('m').width * 1.6;
                return textMetrics;
            };
        }
    }
    function fixup_ellipse(ctx) {
        // implementing the ctx.ellipse function with bezier curves
        // we don't implement the startAngle, endAngle and anticlockwise arguments.
        function ellipse_bezier(x, y, radiusX, radiusY, rotation, _startAngle, _endAngle, anticlockwise) {
            if (anticlockwise === void 0) {
                anticlockwise = false;
            }
            var c = 0.551784;
            // see http://www.tinaja.com/glib/ellipse4.pdf
            ctx.translate(x, y);
            ctx.rotate(rotation);
            var rx = radiusX;
            var ry = radiusY;
            if (anticlockwise) {
                rx = -radiusX;
                ry = -radiusY;
            }
            ctx.moveTo(-rx, 0);
            // start point of first curve
            ctx.bezierCurveTo(-rx, ry * c, -rx * c, ry, 0, ry);
            ctx.bezierCurveTo(rx * c, ry, rx, ry * c, rx, 0);
            ctx.bezierCurveTo(rx, -ry * c, rx * c, -ry, 0, -ry);
            ctx.bezierCurveTo(-rx * c, -ry, -rx, -ry * c, -rx, 0);
            ctx.rotate(-rotation);
            ctx.translate(-x, -y);
        }
        if (!ctx.ellipse)
            ctx.ellipse = ellipse_bezier;
    }
    function fixup_ctx(ctx) {
        fixup_line_dash(ctx);
        fixup_line_dash_offset(ctx);
        fixup_image_smoothing(ctx);
        fixup_measure_text(ctx);
        fixup_ellipse(ctx);
    }
    exports.fixup_ctx = fixup_ctx;
    function get_scale_ratio(ctx, hidpi, backend) {
        if (backend == 'svg')
            return 1;
        else if (hidpi) {
            var devicePixelRatio_1 = window.devicePixelRatio || 1;
            var backingStoreRatio = ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1;
            return devicePixelRatio_1 / backingStoreRatio;
        } else
            return 1;
    }
    exports.get_scale_ratio = get_scale_ratio;    
},
/*core/util/color*/
function _(require, module, exports) {
    var svg_colors_1 = require(39    /* ./svg_colors */);
    var array_1 = require(21    /* ./array */);
    function _component2hex(v) {
        var h = Number(v).toString(16);
        return h.length == 1 ? '0' + h : h;
    }
    function color2hex(color) {
        color = color + '';
        if (color.indexOf('#') == 0)
            return color;
        else if (svg_colors_1.is_svg_color(color))
            return svg_colors_1.svg_colors[color];
        else if (color.indexOf('rgb') == 0) {
            var rgb = color.replace(/^rgba?\(|\s+|\)$/g, '').split(',');
            var hex = rgb.slice(0, 3).map(_component2hex).join('');
            if (rgb.length == 4)
                hex += _component2hex(Math.floor(parseFloat(rgb[3]) * 255));
            return '#' + hex.slice(0, 8);    // can also be rgba
        } else
            return color;
    }
    exports.color2hex = color2hex;
    function color2rgba(color, alpha) {
        if (alpha === void 0) {
            alpha = 1;
        }
        if (!color)
            // NaN, null, '', etc.
            return [
                0,
                0,
                0,
                0
            ];
        // transparent
        // Convert to hex and then to clean version of 6 or 8 chars
        var hex = color2hex(color);
        hex = hex.replace(/ |#/g, '');
        if (hex.length <= 4) {
            hex = hex.replace(/(.)/g, '$1$1');
        }
        // Convert pairs to numbers
        var rgba = hex.match(/../g).map(function (i) {
            return parseInt(i, 16) / 255;
        });
        // Ensure correct length, add alpha if necessary
        while (rgba.length < 3)
            rgba.push(0);
        if (rgba.length < 4)
            rgba.push(alpha);
        return rgba.slice(0, 4);
    }
    exports.color2rgba = color2rgba;
    function valid_rgb(value) {
        var params;
        switch (value.substring(0, 4)) {
        case 'rgba': {
                params = {
                    start: 'rgba(',
                    len: 4,
                    alpha: true
                };
                break;
            }
        case 'rgb(': {
                params = {
                    start: 'rgb(',
                    len: 3,
                    alpha: false
                };
                break;
            }
        default:
            return false;
        }
        // if '.' and then ',' found, we know decimals are used on rgb
        if (new RegExp('.*?(\\.).*(,)').test(value))
            throw new Error('color expects integers for rgb in rgb/rgba tuple, received ' + value);
        // extract the numerical values from inside parens
        var contents = value.replace(params.start, '').replace(')', '').split(',').map(parseFloat);
        // check length of array based on rgb/rgba
        if (contents.length != params.len)
            throw new Error('color expects rgba ' + params.len + '-tuple, received ' + value);
        // check for valid numerical values for rgba
        if (params.alpha && !(0 <= contents[3] && contents[3] <= 1))
            throw new Error('color expects rgba 4-tuple to have alpha value between 0 and 1');
        if (array_1.includes(contents.slice(0, 3).map(function (rgb) {
                return 0 <= rgb && rgb <= 255;
            }), false))
            throw new Error('color expects rgb to have value between 0 and 255');
        return true;
    }
    exports.valid_rgb = valid_rgb;    
},
/*core/util/compat*/
function _(require, module, exports) {
    exports.is_ie = navigator.userAgent.indexOf('MSIE') >= 0 || navigator.userAgent.indexOf('Trident') > 0 || navigator.userAgent.indexOf('Edge') > 0;
    exports.is_little_endian = function () {
        var buf = new ArrayBuffer(4);
        var buf8 = new Uint8Array(buf);
        var buf32 = new Uint32Array(buf);
        buf32[1] = 168496141;
        var little_endian = true;
        if (buf8[4] == 10 && buf8[5] == 11 && buf8[6] == 12 && buf8[7] == 13) {
            little_endian = false;
        }
        return little_endian;
    }();    
},
/*core/util/data_structures*/
function _(require, module, exports) {
    var array_1 = require(21    /* ./array */);
    var eq_1 = require(30    /* ./eq */);
    var types_1 = require(44    /* ./types */);
    var MultiDict = function () {
        function MultiDict() {
            this._dict = {};
        }
        MultiDict.prototype._existing = function (key) {
            if (key in this._dict)
                return this._dict[key];
            else
                return null;
        };
        MultiDict.prototype.add_value = function (key, value) {
            /*
        if value == null
          throw new Error("Can't put null in this dict")
        if isArray(value)
          throw new Error("Can't put arrays in this dict")
        */
            var existing = this._existing(key);
            if (existing == null) {
                this._dict[key] = value;
            } else if (types_1.isArray(existing)) {
                existing.push(value);
            } else {
                this._dict[key] = [
                    existing,
                    value
                ];
            }
        };
        MultiDict.prototype.remove_value = function (key, value) {
            var existing = this._existing(key);
            if (types_1.isArray(existing)) {
                var new_array = array_1.difference(existing, [value]);
                if (new_array.length > 0)
                    this._dict[key] = new_array;
                else
                    delete this._dict[key];
            } else if (eq_1.isEqual(existing, value)) {
                delete this._dict[key];
            }
        };
        MultiDict.prototype.get_one = function (key, duplicate_error) {
            var existing = this._existing(key);
            if (types_1.isArray(existing)) {
                if (existing.length === 1)
                    return existing[0];
                else
                    throw new Error(duplicate_error);
            } else
                return existing;
        };
        return MultiDict;
    }();
    exports.MultiDict = MultiDict;
    var Set = function () {
        function Set(obj) {
            if (obj == null) {
                this.values = [];
            } else if (obj instanceof Set) {
                this.values = array_1.copy(obj.values);
            } else {
                this.values = this._compact(obj);
            }
        }
        Set.prototype._compact = function (array) {
            var newArray = [];
            for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
                var item = array_2[_i];
                if (newArray.indexOf(item) === -1) {
                    newArray.push(item);
                }
            }
            return newArray;
        };
        Set.prototype.push = function (item) {
            if (this.missing(item))
                this.values.push(item);
        };
        Set.prototype.remove = function (item) {
            var i = this.values.indexOf(item);
            this.values = this.values.slice(0, i).concat(this.values.slice(i + 1));
        };
        Set.prototype.length = function () {
            return this.values.length;
        };
        Set.prototype.includes = function (item) {
            return this.values.indexOf(item) != -1;
        };
        Set.prototype.missing = function (item) {
            return !this.includes(item);
        };
        Set.prototype.slice = function (from, to) {
            return this.values.slice(from, to);
        };
        Set.prototype.join = function (str) {
            return this.values.join(str);
        };
        Set.prototype.toString = function () {
            return this.join(', ');
        };
        Set.prototype.union = function (set) {
            set = new Set(set);
            return new Set(this.values.concat(set.values));
        };
        Set.prototype.intersect = function (set) {
            set = new Set(set);
            var newSet = new Set();
            for (var _i = 0, _a = set.values; _i < _a.length; _i++) {
                var item = _a[_i];
                if (this.includes(item) && set.includes(item))
                    newSet.push(item);
            }
            return newSet;
        };
        Set.prototype.diff = function (set) {
            set = new Set(set);
            var newSet = new Set();
            for (var _i = 0, _a = this.values; _i < _a.length; _i++) {
                var item = _a[_i];
                if (set.missing(item))
                    newSet.push(item);
            }
            return newSet;
        };
        return Set;
    }();
    exports.Set = Set;    
},
/*core/util/eq*/
function _(require, module, exports) {
    var types_1 = require(44    /* ./types */);
    var toString = Object.prototype.toString;
    // Internal recursive comparison function for `isEqual`.
    function eq(a, b, aStack, bStack) {
        // Identical objects are equal. `0 === -0`, but they aren't identical.
        // See the [Harmony `egal` proposal](http://wiki.ecmascript.org/doku.php?id=harmony:egal).
        if (a === b)
            return a !== 0 || 1 / a === 1 / b;
        // A strict comparison is necessary because `null == undefined`.
        if (a == null || b == null)
            return a === b;
        // Compare `[[Class]]` names.
        var className = toString.call(a);
        if (className !== toString.call(b))
            return false;
        switch (className) {
        // Strings, numbers, regular expressions, dates, and booleans are compared by value.
        case '[object RegExp]':
        // RegExps are coerced to strings for comparison (Note: '' + /a/i === '/a/i')
        case '[object String]':
            // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
            // equivalent to `new String("5")`.
            return '' + a === '' + b;
        case '[object Number]':
            // `NaN`s are equivalent, but non-reflexive.
            // Object(NaN) is equivalent to NaN
            if (+a !== +a)
                return +b !== +b;
            // An `egal` comparison is performed for other numeric values.
            return +a === 0 ? 1 / +a === 1 / b : +a === +b;
        case '[object Date]':
        case '[object Boolean]':
            // Coerce dates and booleans to numeric primitive values. Dates are compared by their
            // millisecond representations. Note that invalid dates with millisecond representations
            // of `NaN` are not equivalent.
            return +a === +b;
        }
        var areArrays = className === '[object Array]';
        if (!areArrays) {
            if (typeof a != 'object' || typeof b != 'object')
                return false;
            // Objects with different constructors are not equivalent, but `Object`s or `Array`s
            // from different frames are.
            var aCtor = a.constructor, bCtor = b.constructor;
            if (aCtor !== bCtor && !(types_1.isFunction(aCtor) && aCtor instanceof aCtor && types_1.isFunction(bCtor) && bCtor instanceof bCtor) && ('constructor' in a && 'constructor' in b)) {
                return false;
            }
        }
        // Assume equality for cyclic structures. The algorithm for detecting cyclic
        // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
        // Initializing stack of traversed objects.
        // It's done here since we only need them for objects and arrays comparison.
        aStack = aStack || [];
        bStack = bStack || [];
        var length = aStack.length;
        while (length--) {
            // Linear search. Performance is inversely proportional to the number of
            // unique nested structures.
            if (aStack[length] === a)
                return bStack[length] === b;
        }
        // Add the first object to the stack of traversed objects.
        aStack.push(a);
        bStack.push(b);
        // Recursively compare objects and arrays.
        if (areArrays) {
            // Compare array lengths to determine if a deep comparison is necessary.
            length = a.length;
            if (length !== b.length)
                return false;
            // Deep compare the contents, ignoring non-numeric properties.
            while (length--) {
                if (!eq(a[length], b[length], aStack, bStack))
                    return false;
            }
        } else {
            // Deep compare objects.
            var keys = Object.keys(a);
            var key = void 0;
            length = keys.length;
            // Ensure that both objects contain the same number of properties before comparing deep equality.
            if (Object.keys(b).length !== length)
                return false;
            while (length--) {
                // Deep compare each member
                key = keys[length];
                if (!(b.hasOwnProperty(key) && eq(a[key], b[key], aStack, bStack)))
                    return false;
            }
        }
        // Remove the first object from the stack of traversed objects.
        aStack.pop();
        bStack.pop();
        return true;
    }
    // Perform a deep comparison to check if two objects are equal.
    function isEqual(a, b) {
        return eq(a, b);
    }
    exports.isEqual = isEqual;    
},
/*core/util/math*/
function _(require, module, exports) {
    function angle_norm(angle) {
        while (angle < 0) {
            angle += 2 * Math.PI;
        }
        while (angle > 2 * Math.PI) {
            angle -= 2 * Math.PI;
        }
        return angle;
    }
    exports.angle_norm = angle_norm;
    function angle_dist(lhs, rhs) {
        return Math.abs(angle_norm(lhs - rhs));
    }
    exports.angle_dist = angle_dist;
    function angle_between(mid, lhs, rhs, direction) {
        var norm_mid = angle_norm(mid);
        var d = angle_dist(lhs, rhs);
        var cond = angle_dist(lhs, norm_mid) <= d && angle_dist(norm_mid, rhs) <= d;
        if (direction == 'anticlock')
            return cond;
        else
            return !cond;
    }
    exports.angle_between = angle_between;
    function random() {
        return Math.random();
    }
    exports.random = random;
    function randomIn(min, max) {
        if (max == null) {
            max = min;
            min = 0;
        }
        return min + Math.floor(Math.random() * (max - min + 1));
    }
    exports.randomIn = randomIn;
    function atan2(start, end) {
        /*
     * Calculate the angle between a line containing start and end points (composed
     * of [x, y] arrays) and the positive x-axis.
     */
        return Math.atan2(end[1] - start[1], end[0] - start[0]);
    }
    exports.atan2 = atan2;
    // http://www2.econ.osaka-u.ac.jp/~tanizaki/class/2013/econome3/13.pdf (Page 432)
    function rnorm(mu, sigma) {
        // Generate a random normal with a mean of 0 and a sigma of 1
        var r1;
        var r2;
        while (true) {
            r1 = random();
            r2 = random();
            r2 = (2 * r2 - 1) * Math.sqrt(2 * (1 / Math.E));
            if (-4 * r1 * r1 * Math.log(r1) >= r2 * r2)
                break;
        }
        var rn = r2 / r1;
        // Transform the standard normal to meet the characteristics that we want (mu, sigma)
        rn = mu + sigma * rn;
        return rn;
    }
    exports.rnorm = rnorm;
    function clamp(val, min, max) {
        if (val > max)
            return max;
        if (val < min)
            return min;
        return val;
    }
    exports.clamp = clamp;    
},
/*core/util/object*/
function _(require, module, exports) {
    var array_1 = require(21    /* ./array */);
    exports.keys = Object.keys;
    function values(object) {
        var keys = Object.keys(object);
        var length = keys.length;
        var values = new Array(length);
        for (var i = 0; i < length; i++) {
            values[i] = object[keys[i]];
        }
        return values;
    }
    exports.values = values;
    function extend(dest) {
        var sources = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            sources[_i - 1] = arguments[_i];
        }
        for (var _a = 0, sources_1 = sources; _a < sources_1.length; _a++) {
            var source = sources_1[_a];
            for (var key in source) {
                if (source.hasOwnProperty(key)) {
                    dest[key] = source[key];
                }
            }
        }
        return dest;
    }
    exports.extend = extend;
    function clone(obj) {
        return extend({}, obj);
    }
    exports.clone = clone;
    function merge(obj1, obj2) {
        /*
     * Returns an object with the array values for obj1 and obj2 unioned by key.
     */
        var result = Object.create(Object.prototype);
        var keys = array_1.concat([
            Object.keys(obj1),
            Object.keys(obj2)
        ]);
        for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
            var key = keys_1[_i];
            var arr1 = obj1.hasOwnProperty(key) ? obj1[key] : [];
            var arr2 = obj2.hasOwnProperty(key) ? obj2[key] : [];
            result[key] = array_1.union(arr1, arr2);
        }
        return result;
    }
    exports.merge = merge;
    function size(obj) {
        return Object.keys(obj).length;
    }
    exports.size = size;
    function isEmpty(obj) {
        return size(obj) === 0;
    }
    exports.isEmpty = isEmpty;    
},
/*core/util/projections*/
function _(require, module, exports) {
    var proj4 = require(363    /* proj4/lib/core */);
    var Projection = require(351    /* proj4/lib/Proj */);
    var mercator = new Projection('GOOGLE');
    var wgs84 = new Projection('WGS84');
    exports.wgs84_mercator = proj4(wgs84, mercator);
    var mercator_bounds = {
        lon: [
            -20026376.39,
            20026376.39
        ],
        lat: [
            -20048966.1,
            20048966.1
        ]
    };
    var latlon_bounds = {
        lon: [
            -180,
            180
        ],
        lat: [
            -85.06,
            85.06
        ]
    };
    function clip_mercator(low, high, dimension) {
        var _a = mercator_bounds[dimension], min = _a[0], max = _a[1];
        return [
            Math.max(low, min),
            Math.min(high, max)
        ];
    }
    exports.clip_mercator = clip_mercator;
    function in_bounds(value, dimension) {
        return value > latlon_bounds[dimension][0] && value < latlon_bounds[dimension][1];
    }
    exports.in_bounds = in_bounds;
    function project_xy(x, y) {
        var n = Math.min(x.length, y.length);
        var merc_x_s = new Array(n);
        var merc_y_s = new Array(n);
        for (var i = 0; i < n; i++) {
            var _a = exports.wgs84_mercator.forward([
                    x[i],
                    y[i]
                ]), merc_x = _a[0], merc_y = _a[1];
            merc_x_s[i] = merc_x;
            merc_y_s[i] = merc_y;
        }
        return [
            merc_x_s,
            merc_y_s
        ];
    }
    exports.project_xy = project_xy;
    function project_xsys(xs, ys) {
        var n = Math.min(xs.length, ys.length);
        var merc_xs_s = new Array(n);
        var merc_ys_s = new Array(n);
        for (var i = 0; i < n; i++) {
            var _a = project_xy(xs[i], ys[i]), merc_x_s = _a[0], merc_y_s = _a[1];
            merc_xs_s[i] = merc_x_s;
            merc_ys_s[i] = merc_y_s;
        }
        return [
            merc_xs_s,
            merc_ys_s
        ];
    }
    exports.project_xsys = project_xsys;    
},
/*core/util/refs*/
function _(require, module, exports) {
    var types_1 = require(44    /* ./types */);
    // Create a Bokeh reference from a HasProps subclass
    //
    // @param obj [HasProps] the object to create a reference for
    // @return [Object] a Bokeh reference for `obj`
    // @throw Error if `obj` is not a HasProps
    //
    function create_ref(obj) {
        var ref = {
            type: obj.type,
            id: obj.id
        };
        if (obj._subtype != null) {
            ref.subtype = obj._subtype;
        }
        return ref;
    }
    exports.create_ref = create_ref;
    // Determine whether an object has the proper format of a Bokeh reference
    //
    // @param arg [Object] the object to test
    // @return [bool] whether the object is a refererence
    //
    // @note this function does not check that the id and types are valid,
    //   only that the format is correct (all required keys are present)
    //
    function is_ref(arg) {
        if (types_1.isObject(arg)) {
            var keys = Object.keys(arg).sort();
            if (keys.length == 2)
                return keys[0] == 'id' && keys[1] == 'type';
            if (keys.length == 3)
                return keys[0] == 'id' && keys[1] == 'subtype' && keys[2] == 'type';
        }
        return false;
    }
    exports.is_ref = is_ref;    
},
/*core/util/selection*/
function _(require, module, exports) {
    function get_indices(data_source) {
        var selected = data_source.selected;
        if (selected['0d'].glyph)
            return selected['0d'].indices;
        else if (selected['1d'].indices.length > 0)
            return selected['1d'].indices;
        else if (selected['2d'].indices.length > 0)
            return selected['2d'].indices;
        else
            return [];
    }
    exports.get_indices = get_indices;    
},
/*core/util/serialization*/
function _(require, module, exports) {
    var types_1 = require(44    /* ./types */);
    var compat_1 = require(28    /* ./compat */);
    exports.ARRAY_TYPES = {
        uint8: Uint8Array,
        int8: Int8Array,
        uint16: Uint16Array,
        int16: Int16Array,
        uint32: Uint32Array,
        int32: Int32Array,
        float32: Float32Array,
        float64: Float64Array
    };
    exports.DTYPES = {
        Uint8Array: 'uint8',
        Int8Array: 'int8',
        Uint16Array: 'uint16',
        Int16Array: 'int16',
        Uint32Array: 'uint32',
        Int32Array: 'int32',
        Float32Array: 'float32',
        Float64Array: 'float64'
    };
    function arrayName(array) {
        if ('name' in array.constructor)
            return array.constructor.name;
        else {
            switch (true) {
            case array instanceof Uint8Array:
                return 'Uint8Array';
            case array instanceof Int8Array:
                return 'Int8Array';
            case array instanceof Uint16Array:
                return 'Uint16Array';
            case array instanceof Int16Array:
                return 'Int16Array';
            case array instanceof Uint32Array:
                return 'Uint32Array';
            case array instanceof Int32Array:
                return 'Int32Array';
            case array instanceof Float32Array:
                return 'Float32Array';
            case array instanceof Float64Array:
                return 'Float64Array';
            default:
                throw new Error('unsupported typed array');
            }
        }
    }
    exports.BYTE_ORDER = compat_1.is_little_endian ? 'little' : 'big';
    function swap16(a) {
        var x = new Uint8Array(a.buffer, a.byteOffset, a.length * 2);
        for (var i = 0, end = x.length; i < end; i += 2) {
            var t = x[i];
            x[i] = x[i + 1];
            x[i + 1] = t;
        }
    }
    exports.swap16 = swap16;
    function swap32(a) {
        var x = new Uint8Array(a.buffer, a.byteOffset, a.length * 4);
        for (var i = 0, end = x.length; i < end; i += 4) {
            var t = x[i];
            x[i] = x[i + 3];
            x[i + 3] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 2];
            x[i + 2] = t;
        }
    }
    exports.swap32 = swap32;
    function swap64(a) {
        var x = new Uint8Array(a.buffer, a.byteOffset, a.length * 8);
        for (var i = 0, end = x.length; i < end; i += 8) {
            var t = x[i];
            x[i] = x[i + 7];
            x[i + 7] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 6];
            x[i + 6] = t;
            t = x[i + 2];
            x[i + 2] = x[i + 5];
            x[i + 5] = t;
            t = x[i + 3];
            x[i + 3] = x[i + 4];
            x[i + 4] = t;
        }
    }
    exports.swap64 = swap64;
    function process_buffer(spec, buffers) {
        var need_swap = spec.order !== exports.BYTE_ORDER;
        var shape = spec.shape;
        var bytes = null;
        for (var _i = 0, buffers_1 = buffers; _i < buffers_1.length; _i++) {
            var buf = buffers_1[_i];
            var header = JSON.parse(buf[0]);
            if (header.id === spec.__buffer__) {
                bytes = buf[1];
                break;
            }
        }
        var arr = new exports.ARRAY_TYPES[spec.dtype](bytes);
        if (need_swap) {
            if (arr.BYTES_PER_ELEMENT === 2) {
                swap16(arr);
            } else if (arr.BYTES_PER_ELEMENT === 4) {
                swap32(arr);
            } else if (arr.BYTES_PER_ELEMENT === 8) {
                swap64(arr);
            }
        }
        return [
            arr,
            shape
        ];
    }
    exports.process_buffer = process_buffer;
    function process_array(obj, buffers) {
        if (types_1.isObject(obj) && '__ndarray__' in obj)
            return decode_base64(obj);
        else if (types_1.isObject(obj) && '__buffer__' in obj)
            return process_buffer(obj, buffers);
        else if (types_1.isArray(obj))
            return [
                obj,
                []
            ];
        else
            return undefined;
    }
    exports.process_array = process_array;
    function arrayBufferToBase64(buffer) {
        var bytes = new Uint8Array(buffer);
        var chars = Array.from(bytes).map(function (b) {
            return String.fromCharCode(b);
        });
        return btoa(chars.join(''));
    }
    exports.arrayBufferToBase64 = arrayBufferToBase64;
    function base64ToArrayBuffer(base64) {
        var binary_string = atob(base64);
        var len = binary_string.length;
        var bytes = new Uint8Array(len);
        for (var i = 0, end = len; i < end; i++) {
            bytes[i] = binary_string.charCodeAt(i);
        }
        return bytes.buffer;
    }
    exports.base64ToArrayBuffer = base64ToArrayBuffer;
    function decode_base64(input) {
        var bytes = base64ToArrayBuffer(input.__ndarray__);
        var dtype = input.dtype;
        var shape = input.shape;
        var array;
        if (dtype in exports.ARRAY_TYPES)
            array = new exports.ARRAY_TYPES[dtype](bytes);
        else
            throw new Error('unknown dtype: ' + dtype);
        return [
            array,
            shape
        ];
    }
    exports.decode_base64 = decode_base64;
    function encode_base64(array, shape) {
        var b64 = arrayBufferToBase64(array.buffer);
        var name = arrayName(array);
        var dtype;
        if (name in exports.DTYPES)
            dtype = exports.DTYPES[name];
        else
            throw new Error('unknown array type: ' + name);
        var data = {
            __ndarray__: b64,
            shape: shape,
            dtype: dtype
        };
        return data;
    }
    exports.encode_base64 = encode_base64;
    function decode_column_data(data, buffers) {
        if (buffers === void 0) {
            buffers = [];
        }
        var new_data = {};
        var new_shapes = {};
        for (var k in data) {
            // might be array of scalars, or might be ragged array or arrays
            var v = data[k];
            if (types_1.isArray(v)) {
                // v is just a regular array of scalars
                if (v.length == 0 || !(types_1.isObject(v[0]) || types_1.isArray(v[0]))) {
                    new_data[k] = v;
                    continue;
                }
                // v is a ragged array of arrays
                var arrays = [];
                var shapes = [];
                for (var _i = 0, v_1 = v; _i < v_1.length; _i++) {
                    var obj = v_1[_i];
                    var _a = process_array(obj, buffers), arr = _a[0], shape = _a[1];
                    arrays.push(arr);
                    shapes.push(shape);
                }
                new_data[k] = arrays;
                new_shapes[k] = shapes;    // must be object or array (single array case)
            } else {
                var _b = process_array(v, buffers), arr = _b[0], shape = _b[1];
                new_data[k] = arr;
                new_shapes[k] = shape;
            }
        }
        return [
            new_data,
            new_shapes
        ];
    }
    exports.decode_column_data = decode_column_data;
    function encode_column_data(data, shapes) {
        var new_data = {};
        for (var k in data) {
            var v = data[k];
            var new_v = void 0;
            if (types_1.isTypedArray(v)) {
                new_v = encode_base64(v, shapes != null ? shapes[k] : undefined);
            } else if (types_1.isArray(v)) {
                var new_array = [];
                for (var i = 0, end = v.length; i < end; i++) {
                    var item = v[i];
                    if (types_1.isTypedArray(item)) {
                        var shape = shapes != null && shapes[k] != null ? shapes[k][i] : undefined;
                        new_array.push(encode_base64(item, shape));
                    } else
                        new_array.push(item);
                }
                new_v = new_array;
            } else
                new_v = v;
            new_data[k] = new_v;
        }
        return new_data;
    }
    exports.encode_column_data = encode_column_data;    
},
/*core/util/spatial*/
function _(require, module, exports) {
    var FlatBush = require(335    /* flatbush */);
    var bbox_1 = require(24    /* ./bbox */);
    var SpatialIndex = function () {
        function SpatialIndex(points) {
            this.points = points;
            this.index = null;
            if (points.length > 0) {
                this.index = new FlatBush(points.length);
                for (var _i = 0, points_1 = points; _i < points_1.length; _i++) {
                    var p = points_1[_i];
                    var minX = p.minX, minY = p.minY, maxX = p.maxX, maxY = p.maxY;
                    this.index.add(minX, minY, maxX, maxY);
                }
                this.index.finish();
            }
        }
        Object.defineProperty(SpatialIndex.prototype, 'bbox', {
            get: function () {
                if (this.index == null)
                    return bbox_1.empty();
                else {
                    var _a = this.index, minX = _a.minX, minY = _a.minY, maxX = _a.maxX, maxY = _a.maxY;
                    return {
                        minX: minX,
                        minY: minY,
                        maxX: maxX,
                        maxY: maxY
                    };
                }
            },
            enumerable: true,
            configurable: true
        });
        SpatialIndex.prototype.search = function (rect) {
            var _this = this;
            if (this.index == null)
                return [];
            else {
                var minX = rect.minX, minY = rect.minY, maxX = rect.maxX, maxY = rect.maxY;
                var indices = this.index.search(minX, minY, maxX, maxY);
                return indices.map(function (j) {
                    return _this.points[j];
                });
            }
        };
        SpatialIndex.prototype.indices = function (rect) {
            return this.search(rect).map(function (_a) {
                var i = _a.i;
                return i;
            });
        };
        return SpatialIndex;
    }();
    exports.SpatialIndex = SpatialIndex;    
},
/*core/util/string*/
function _(require, module, exports) {
    var settings_1 = require(18    /* ../settings */);
    function startsWith(str, searchString, position) {
        if (position === void 0) {
            position = 0;
        }
        return str.substr(position, searchString.length) == searchString;
    }
    exports.startsWith = startsWith;
    function uuid4() {
        // from ipython project
        // http://www.ietf.org/rfc/rfc4122.txt
        var s = new Array(32);
        var hexDigits = '0123456789ABCDEF';
        for (var i = 0; i < 32; i++) {
            s[i] = hexDigits.substr(Math.floor(Math.random() * 16), 1);
        }
        s[12] = '4';
        // bits 12-15 of the time_hi_and_version field to 0010
        s[16] = hexDigits.substr(s[16].charCodeAt(0) & 3 | 8, 1);
        // bits 6-7 of the clock_seq_hi_and_reserved to 01
        return s.join('');
    }
    exports.uuid4 = uuid4;
    var counter = 1000;
    function uniqueId(prefix) {
        var id = settings_1.settings.dev ? 'j' + counter++ : uuid4();
        if (prefix != null)
            return prefix + '-' + id;
        else
            return id;
    }
    exports.uniqueId = uniqueId;
    function escape(s) {
        return s.replace(/(?:[&<>"'`])/g, function (ch) {
            switch (ch) {
            case '&':
                return '&amp;';
            case '<':
                return '&lt;';
            case '>':
                return '&gt;';
            case '"':
                return '&quot;';
            case '\'':
                return '&#x27;';
            case '`':
                return '&#x60;';
            default:
                return ch;
            }
        });
    }
    exports.escape = escape;
    function unescape(s) {
        return s.replace(/&(amp|lt|gt|quot|#x27|#x60);/g, function (_, entity) {
            switch (entity) {
            case 'amp':
                return '&';
            case 'lt':
                return '<';
            case 'gt':
                return '>';
            case 'quot':
                return '"';
            case '#x27':
                return '\'';
            case '#x60':
                return '`';
            default:
                return entity;
            }
        });
    }
    exports.unescape = unescape;
    function use_strict(code) {
        return '\'use strict\';\n' + code;
    }
    exports.use_strict = use_strict;    
},
/*core/util/svg_colors*/
function _(require, module, exports) {
    exports.svg_colors = {
        indianred: '#CD5C5C',
        lightcoral: '#F08080',
        salmon: '#FA8072',
        darksalmon: '#E9967A',
        lightsalmon: '#FFA07A',
        crimson: '#DC143C',
        red: '#FF0000',
        firebrick: '#B22222',
        darkred: '#8B0000',
        pink: '#FFC0CB',
        lightpink: '#FFB6C1',
        hotpink: '#FF69B4',
        deeppink: '#FF1493',
        mediumvioletred: '#C71585',
        palevioletred: '#DB7093',
        coral: '#FF7F50',
        tomato: '#FF6347',
        orangered: '#FF4500',
        darkorange: '#FF8C00',
        orange: '#FFA500',
        gold: '#FFD700',
        yellow: '#FFFF00',
        lightyellow: '#FFFFE0',
        lemonchiffon: '#FFFACD',
        lightgoldenrodyellow: '#FAFAD2',
        papayawhip: '#FFEFD5',
        moccasin: '#FFE4B5',
        peachpuff: '#FFDAB9',
        palegoldenrod: '#EEE8AA',
        khaki: '#F0E68C',
        darkkhaki: '#BDB76B',
        lavender: '#E6E6FA',
        thistle: '#D8BFD8',
        plum: '#DDA0DD',
        violet: '#EE82EE',
        orchid: '#DA70D6',
        fuchsia: '#FF00FF',
        magenta: '#FF00FF',
        mediumorchid: '#BA55D3',
        mediumpurple: '#9370DB',
        blueviolet: '#8A2BE2',
        darkviolet: '#9400D3',
        darkorchid: '#9932CC',
        darkmagenta: '#8B008B',
        purple: '#800080',
        indigo: '#4B0082',
        slateblue: '#6A5ACD',
        darkslateblue: '#483D8B',
        mediumslateblue: '#7B68EE',
        greenyellow: '#ADFF2F',
        chartreuse: '#7FFF00',
        lawngreen: '#7CFC00',
        lime: '#00FF00',
        limegreen: '#32CD32',
        palegreen: '#98FB98',
        lightgreen: '#90EE90',
        mediumspringgreen: '#00FA9A',
        springgreen: '#00FF7F',
        mediumseagreen: '#3CB371',
        seagreen: '#2E8B57',
        forestgreen: '#228B22',
        green: '#008000',
        darkgreen: '#006400',
        yellowgreen: '#9ACD32',
        olivedrab: '#6B8E23',
        olive: '#808000',
        darkolivegreen: '#556B2F',
        mediumaquamarine: '#66CDAA',
        darkseagreen: '#8FBC8F',
        lightseagreen: '#20B2AA',
        darkcyan: '#008B8B',
        teal: '#008080',
        aqua: '#00FFFF',
        cyan: '#00FFFF',
        lightcyan: '#E0FFFF',
        paleturquoise: '#AFEEEE',
        aquamarine: '#7FFFD4',
        turquoise: '#40E0D0',
        mediumturquoise: '#48D1CC',
        darkturquoise: '#00CED1',
        cadetblue: '#5F9EA0',
        steelblue: '#4682B4',
        lightsteelblue: '#B0C4DE',
        powderblue: '#B0E0E6',
        lightblue: '#ADD8E6',
        skyblue: '#87CEEB',
        lightskyblue: '#87CEFA',
        deepskyblue: '#00BFFF',
        dodgerblue: '#1E90FF',
        cornflowerblue: '#6495ED',
        royalblue: '#4169E1',
        blue: '#0000FF',
        mediumblue: '#0000CD',
        darkblue: '#00008B',
        navy: '#000080',
        midnightblue: '#191970',
        cornsilk: '#FFF8DC',
        blanchedalmond: '#FFEBCD',
        bisque: '#FFE4C4',
        navajowhite: '#FFDEAD',
        wheat: '#F5DEB3',
        burlywood: '#DEB887',
        tan: '#D2B48C',
        rosybrown: '#BC8F8F',
        sandybrown: '#F4A460',
        goldenrod: '#DAA520',
        darkgoldenrod: '#B8860B',
        peru: '#CD853F',
        chocolate: '#D2691E',
        saddlebrown: '#8B4513',
        sienna: '#A0522D',
        brown: '#A52A2A',
        maroon: '#800000',
        white: '#FFFFFF',
        snow: '#FFFAFA',
        honeydew: '#F0FFF0',
        mintcream: '#F5FFFA',
        azure: '#F0FFFF',
        aliceblue: '#F0F8FF',
        ghostwhite: '#F8F8FF',
        whitesmoke: '#F5F5F5',
        seashell: '#FFF5EE',
        beige: '#F5F5DC',
        oldlace: '#FDF5E6',
        floralwhite: '#FFFAF0',
        ivory: '#FFFFF0',
        antiquewhite: '#FAEBD7',
        linen: '#FAF0E6',
        lavenderblush: '#FFF0F5',
        mistyrose: '#FFE4E1',
        gainsboro: '#DCDCDC',
        lightgray: '#D3D3D3',
        lightgrey: '#D3D3D3',
        silver: '#C0C0C0',
        darkgray: '#A9A9A9',
        darkgrey: '#A9A9A9',
        gray: '#808080',
        grey: '#808080',
        dimgray: '#696969',
        dimgrey: '#696969',
        lightslategray: '#778899',
        lightslategrey: '#778899',
        slategray: '#708090',
        slategrey: '#708090',
        darkslategray: '#2F4F4F',
        darkslategrey: '#2F4F4F',
        black: '#000000'
    };
    function is_svg_color(color) {
        return color in exports.svg_colors;
    }
    exports.is_svg_color = is_svg_color;    
},
/*core/util/templating*/
function _(require, module, exports) {
    var sprintf_js_1 = require(378    /* sprintf-js */);
    var Numbro = require(350    /* numbro */);
    var tz = require(379    /* timezone */);
    var string_1 = require(38    /* ./string */);
    var types_1 = require(44    /* ./types */);
    exports.DEFAULT_FORMATTERS = {
        'numeral': function (value, format, _special_vars) {
            return Numbro.format(value, format);
        },
        'datetime': function (value, format, _special_vars) {
            return tz(value, format);
        },
        'printf': function (value, format, _special_vars) {
            return sprintf_js_1.sprintf(format, value);
        }
    };
    function basic_formatter(value, _format, _special_vars) {
        if (types_1.isNumber(value)) {
            var format = function () {
                switch (false) {
                case Math.floor(value) != value:
                    return '%d';
                case !(Math.abs(value) > 0.1) || !(Math.abs(value) < 1000):
                    return '%0.3f';
                default:
                    return '%0.3e';
                }
            }();
            return sprintf_js_1.sprintf(format, value);
        } else
            return '' + value;    // get strings for categorical types
    }
    exports.basic_formatter = basic_formatter;
    function get_formatter(name, raw_spec, format, formatters) {
        // no format, use default built in formatter
        if (format == null)
            return basic_formatter;
        // format spec in the formatters dict, use that
        if (formatters != null && (name in formatters || raw_spec in formatters)) {
            // some day (Bokeh 2.0) we can get rid of the check for name, and just check the raw spec
            // keep it now for compatibility but do not demonstrate it anywhere
            var key = raw_spec in formatters ? raw_spec : name;
            var formatter_1 = formatters[key];
            if (types_1.isString(formatter_1)) {
                if (formatter_1 in exports.DEFAULT_FORMATTERS)
                    return exports.DEFAULT_FORMATTERS[formatter_1];
                else
                    throw new Error('Unknown tooltip field formatter type \'' + formatter_1 + '\'');
            }
            return function (value, format, special_vars) {
                return formatter_1.format(value, format, special_vars);
            };
        }
        // otherwise use "numeral" as default
        return exports.DEFAULT_FORMATTERS['numeral'];
    }
    exports.get_formatter = get_formatter;
    function get_value(name, data_source, i, special_vars) {
        if (name[0] == '$') {
            if (name.substring(1) in special_vars)
                return special_vars[name.substring(1)];
            else
                throw new Error('Unknown special variable \'' + name + '\'');
        }
        var column = data_source.get_column(name);
        // missing column
        if (column == null)
            return null;
        // typical (non-image) index
        if (types_1.isNumber(i))
            return column[i];
        // image index
        var data = column[i.index];
        if (types_1.isTypedArray(data) || types_1.isArray(data)) {
            // inspect array of arrays
            if (types_1.isArray(data[0])) {
                var row = data[i.dim2];
                return row[i.dim1];
            }    // inspect flat array
            else
                return data[i.flat_index];
        }    // inspect per-image scalar data
        else
            return data;
    }
    exports.get_value = get_value;
    function replace_placeholders(str, data_source, i, formatters, special_vars) {
        if (special_vars === void 0) {
            special_vars = {};
        }
        // this extracts the $x, @x, @{x} without any trailing {format}
        var raw_spec = str.replace(/(?:^|[^@])([@|\$](?:\w+|{[^{}]+}))(?:{[^{}]+})?/g, function (_match, raw_spec, _format) {
            return '' + raw_spec;
        });
        // this prepends special vars with "@", e.g "$x" becomes "@$x", so subsequent processing is simpler
        str = str.replace(/(^|[^\$])\$(\w+)/g, function (_match, prefix, name) {
            return prefix + '@$' + name;
        });
        str = str.replace(/(^|[^@])@(?:(\$?\w+)|{([^{}]+)})(?:{([^{}]+)})?/g, function (_match, prefix, name, long_name, format) {
            name = long_name != null ? long_name : name;
            var value = get_value(name, data_source, i, special_vars);
            // missing value, return ???
            if (value == null)
                return '' + prefix + string_1.escape('???');
            // 'safe' format, return the value as-is
            if (format == 'safe')
                return '' + prefix + value;
            // format and escape everything else
            var formatter = get_formatter(name, raw_spec, format, formatters);
            return '' + prefix + string_1.escape(formatter(value, format, special_vars));
        });
        return str;
    }
    exports.replace_placeholders = replace_placeholders;    
},
/*core/util/text*/
function _(require, module, exports) {
    var dom_1 = require(5    /* ../dom */);
    var cache = {};
    function get_text_height(font) {
        if (cache[font] != null)
            return cache[font];
        var text = dom_1.span({ style: { font: font } }, 'Hg');
        var block = dom_1.div({
            style: {
                display: 'inline-block',
                width: '1px',
                height: '0px'
            }
        });
        var elem = dom_1.div({}, text, block);
        document.body.appendChild(elem);
        try {
            block.style.verticalAlign = 'baseline';
            var ascent = dom_1.offset(block).top - dom_1.offset(text).top;
            block.style.verticalAlign = 'bottom';
            var height = dom_1.offset(block).top - dom_1.offset(text).top;
            var result = {
                height: height,
                ascent: ascent,
                descent: height - ascent
            };
            cache[font] = result;
            return result;
        } finally {
            document.body.removeChild(elem);
        }
    }
    exports.get_text_height = get_text_height;    
},
/*core/util/throttle*/
function _(require, module, exports) {
    function _delay_animation(callback) {
        callback(Date.now());
        // XXX: performance.now()
        return -1;
    }
    var delay_animation = (typeof window !== 'undefined' ? window.requestAnimationFrame : undefined) || (typeof window !== 'undefined' ? window.webkitRequestAnimationFrame : undefined) || (typeof window !== 'undefined' ? window.mozRequestAnimationFrame : undefined) || (typeof window !== 'undefined' ? window.msRequestAnimationFrame : undefined) || _delay_animation;
    // Returns a function, that, when invoked, will only be triggered at
    // most once during a given window of time.
    //
    // In addition, if the browser supports requestAnimationFrame, the
    // throttled function will be run no more frequently than request
    // animation frame allows.
    //
    // @param func [function] the function to throttle
    // @param wait [number] time in milliseconds to use for window
    // @return [function] throttled function
    //
    function throttle(func, wait) {
        var timeout = null;
        var previous = 0;
        var pending = false;
        var later = function () {
            previous = Date.now();
            timeout = null;
            pending = false;
            func();
        };
        return function () {
            var now = Date.now();
            var remaining = wait - (now - previous);
            if (remaining <= 0 && !pending) {
                if (timeout != null)
                    clearTimeout(timeout);
                pending = true;
                delay_animation(later);
            } else if (!timeout && !pending)
                timeout = setTimeout(function () {
                    return delay_animation(later);
                }, remaining);
        };
    }
    exports.throttle = throttle;    
},
/*core/util/typed_array*/
function _(require, module, exports) {
    function concat(array0) {
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var n = array0.length;
        for (var _a = 0, arrays_1 = arrays; _a < arrays_1.length; _a++) {
            var array = arrays_1[_a];
            n += array.length;
        }
        var result = new array0.constructor(n);
        result.set(array0, 0);
        var i = array0.length;
        for (var _b = 0, arrays_2 = arrays; _b < arrays_2.length; _b++) {
            var array = arrays_2[_b];
            result.set(array, i);
            i += array.length;
        }
        return result;
    }
    exports.concat = concat;    
},
/*core/util/types*/
function _(require, module, exports) {
    var array_1 = require(21    /* ./array */);
    var toString = Object.prototype.toString;
    function isBoolean(obj) {
        return obj === true || obj === false || toString.call(obj) === '[object Boolean]';
    }
    exports.isBoolean = isBoolean;
    function isNumber(obj) {
        return toString.call(obj) === '[object Number]';
    }
    exports.isNumber = isNumber;
    function isInteger(obj) {
        return isNumber(obj) && isFinite(obj) && Math.floor(obj) === obj;
    }
    exports.isInteger = isInteger;
    function isString(obj) {
        return toString.call(obj) === '[object String]';
    }
    exports.isString = isString;
    function isStrictNaN(obj) {
        return isNumber(obj) && obj !== +obj;
    }
    exports.isStrictNaN = isStrictNaN;
    function isFunction(obj) {
        return toString.call(obj) === '[object Function]';
    }
    exports.isFunction = isFunction;
    function isArray(obj) {
        return Array.isArray(obj);
    }
    exports.isArray = isArray;
    function isArrayOf(arr, predicate) {
        return array_1.all(arr, predicate);
    }
    exports.isArrayOf = isArrayOf;
    function isArrayableOf(arr, predicate) {
        for (var i = 0, end = arr.length; i < end; i++) {
            if (!predicate(arr[i]))
                return false;
        }
        return true;
    }
    exports.isArrayableOf = isArrayableOf;
    function isTypedArray(obj) {
        return obj != null && obj.buffer != null && obj.buffer instanceof ArrayBuffer;
    }
    exports.isTypedArray = isTypedArray;
    function isObject(obj) {
        var tp = typeof obj;
        return tp === 'function' || tp === 'object' && !!obj;
    }
    exports.isObject = isObject;    
},
/*core/util/wheel*/
function _(require, module, exports) {
    function fontSize(element) {
        var value = getComputedStyle(element).fontSize;
        if (value != null)
            return parseInt(value, 10);
        return null;
    }
    function lineHeight(element) {
        var parent = element.offsetParent || document.body;
        return fontSize(parent) || fontSize(element) || 16;
    }
    function pageHeight(element) {
        return element.clientHeight;    // XXX: should be content height?
    }
    function getDeltaY(event) {
        var deltaY = -event.deltaY;
        if (event.target instanceof HTMLElement) {
            switch (event.deltaMode) {
            case event.DOM_DELTA_LINE:
                deltaY *= lineHeight(event.target);
                break;
            case event.DOM_DELTA_PAGE:
                deltaY *= pageHeight(event.target);
                break;
            }
        }
        return deltaY;
    }
    exports.getDeltaY = getDeltaY;    
},
/*core/util/zoom*/
function _(require, module, exports) {
    var math_1 = require(31    /* ./math */);
    // Module for zoom-related functions
    function scale_highlow(range, factor, center) {
        var _a = [
                range.start,
                range.end
            ], low = _a[0], high = _a[1];
        var x = center != null ? center : (high + low) / 2;
        var x0 = low - (low - x) * factor;
        var x1 = high - (high - x) * factor;
        return [
            x0,
            x1
        ];
    }
    exports.scale_highlow = scale_highlow;
    function get_info(scales, _a) {
        var sxy0 = _a[0], sxy1 = _a[1];
        var info = {};
        for (var name_1 in scales) {
            var scale = scales[name_1];
            var _b = scale.r_invert(sxy0, sxy1), start = _b[0], end = _b[1];
            info[name_1] = {
                start: start,
                end: end
            };
        }
        return info;
    }
    exports.get_info = get_info;
    function scale_range(frame, factor, h_axis, v_axis, center) {
        /*
     * Utility function for zoom tools to calculate/create the zoom_info object
     * of the form required by ``PlotCanvasView.update_range``
     *
     * Parameters:
     *   frame : CartesianFrame
     *   factor : Number
     *   h_axis : Boolean, optional
     *     whether to zoom the horizontal axis (default = true)
     *   v_axis : Boolean, optional
     *     whether to zoom the horizontal axis (default = true)
     *   center : object, optional
     *     of form {'x': Number, 'y', Number}
     *
     * Returns:
     *   object:
     */
        if (h_axis === void 0) {
            h_axis = true;
        }
        if (v_axis === void 0) {
            v_axis = true;
        }
        // clamp the  magnitude of factor, if it is > 1 bad things happen
        factor = math_1.clamp(factor, -0.9, 0.9);
        var hfactor = h_axis ? factor : 0;
        var _a = scale_highlow(frame.bbox.h_range, hfactor, center != null ? center.x : undefined), sx0 = _a[0], sx1 = _a[1];
        var xrs = get_info(frame.xscales, [
            sx0,
            sx1
        ]);
        var vfactor = v_axis ? factor : 0;
        var _b = scale_highlow(frame.bbox.v_range, vfactor, center != null ? center.y : undefined), sy0 = _b[0], sy1 = _b[1];
        var yrs = get_info(frame.yscales, [
            sy0,
            sy1
        ]);
        // OK this sucks we can't set factor independently in each direction. It is used
        // for GMap plots, and GMap plots always preserve aspect, so effective the value
        // of 'dimensions' is ignored.
        return {
            xrs: xrs,
            yrs: yrs,
            factor: factor
        };
    }
    exports.scale_range = scale_range;    
},
/*core/vectorization*/
function _(require, module, exports) {
    var types_1 = require(44    /* core/util/types */);
    function isValue(obj) {
        return types_1.isObject(obj) && 'value' in obj;
    }
    exports.isValue = isValue;
    function isField(obj) {
        return types_1.isObject(obj) && 'field' in obj;
    }
    exports.isField = isField;    
},
/*core/view*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var signaling_1 = require(19    /* ./signaling */);
    var string_1 = require(38    /* ./util/string */);
    var View = function (_super) {
        tslib_1.__extends(View, _super);
        function View(options) {
            var _this = _super.call(this) || this;
            _this.removed = new signaling_1.Signal0(_this, 'removed');
            if (options.model != null)
                _this.model = options.model;
            else
                throw new Error('model of a view wasn\'t configured');
            _this._parent = options.parent;
            _this.id = options.id || string_1.uniqueId();
            _this.initialize(options);
            if (options.connect_signals !== false)
                _this.connect_signals();
            return _this;
        }
        View.prototype.initialize = function (_options) {
        };
        View.prototype.remove = function () {
            this._parent = undefined;
            this.disconnect_signals();
            this.removed.emit();
        };
        View.prototype.toString = function () {
            return this.model.type + 'View(' + this.id + ')';
        };
        Object.defineProperty(View.prototype, 'parent', {
            get: function () {
                if (this._parent !== undefined)
                    return this._parent;
                else
                    throw new Error('parent of a view wasn\'t configured');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(View.prototype, 'is_root', {
            get: function () {
                return this.parent === null;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(View.prototype, 'root', {
            get: function () {
                return this.is_root ? this : this.parent.root;
            },
            enumerable: true,
            configurable: true
        });
        View.prototype.connect_signals = function () {
        };
        View.prototype.disconnect_signals = function () {
            signaling_1.Signal.disconnectReceiver(this);
        };
        View.prototype.notify_finished = function () {
            this.root.notify_finished();
        };
        return View;
    }(signaling_1.Signalable());
    exports.View = View;    
},
/*core/visuals*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var mixins = require(16    /* ./property_mixins */);
    var color_1 = require(27    /* ./util/color */);
    var ContextProperties = function () {
        function ContextProperties(obj, prefix) {
            if (prefix === void 0) {
                prefix = '';
            }
            this.obj = obj;
            this.prefix = prefix;
            // }
            this.cache = {};
            var do_spec = obj.properties[prefix + this.do_attr].spec;
            this.doit = do_spec.value !== null;
            // XXX: can't be `undefined`, see TODOs below.
            for (var _i = 0, _a = this.attrs; _i < _a.length; _i++) {
                var attr = _a[_i];
                this[attr] = obj.properties[prefix + attr];
            }
        }
        ContextProperties.prototype.warm_cache = function (source) {
            for (var _i = 0, _a = this.attrs; _i < _a.length; _i++) {
                var attr = _a[_i];
                var prop = this.obj.properties[this.prefix + attr];
                if (prop.spec.value !== undefined)
                    // TODO (bev) better test?
                    this.cache[attr] = prop.spec.value;
                else if (source != null)
                    this.cache[attr + '_array'] = prop.array(source);
                else
                    throw new Error('source is required with a vectorized visual property');
            }
        };
        ContextProperties.prototype.cache_select = function (attr, i) {
            var prop = this.obj.properties[this.prefix + attr];
            var value;
            if (prop.spec.value !== undefined)
                // TODO (bev) better test?
                this.cache[attr] = value = prop.spec.value;
            else
                this.cache[attr] = value = this.cache[attr + '_array'][i];
            return value;
        };
        ContextProperties.prototype.set_vectorize = function (ctx, i) {
            if (this.all_indices != null)
                // all_indices is set by a Visuals instance associated with a CDSView
                this._set_vectorize(ctx, this.all_indices[i]);
            else
                // all_indices is not set for annotations which may have vectorized visual props
                this._set_vectorize(ctx, i);
        };
        return ContextProperties;
    }();
    exports.ContextProperties = ContextProperties;
    var Line = function (_super) {
        tslib_1.__extends(Line, _super);
        function Line() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Line.prototype.set_value = function (ctx) {
            ctx.strokeStyle = this.line_color.value();
            ctx.globalAlpha = this.line_alpha.value();
            ctx.lineWidth = this.line_width.value();
            ctx.lineJoin = this.line_join.value();
            ctx.lineCap = this.line_cap.value();
            ctx.setLineDash(this.line_dash.value());
            ctx.setLineDashOffset(this.line_dash_offset.value());
        };
        Line.prototype._set_vectorize = function (ctx, i) {
            this.cache_select('line_color', i);
            if (ctx.strokeStyle !== this.cache.line_color)
                ctx.strokeStyle = this.cache.line_color;
            this.cache_select('line_alpha', i);
            if (ctx.globalAlpha !== this.cache.line_alpha)
                ctx.globalAlpha = this.cache.line_alpha;
            this.cache_select('line_width', i);
            if (ctx.lineWidth !== this.cache.line_width)
                ctx.lineWidth = this.cache.line_width;
            this.cache_select('line_join', i);
            if (ctx.lineJoin !== this.cache.line_join)
                ctx.lineJoin = this.cache.line_join;
            this.cache_select('line_cap', i);
            if (ctx.lineCap !== this.cache.line_cap)
                ctx.lineCap = this.cache.line_cap;
            this.cache_select('line_dash', i);
            if (ctx.getLineDash() !== this.cache.line_dash)
                ctx.setLineDash(this.cache.line_dash);
            this.cache_select('line_dash_offset', i);
            if (ctx.getLineDashOffset() !== this.cache.line_dash_offset)
                ctx.setLineDashOffset(this.cache.line_dash_offset);
        };
        Line.prototype.color_value = function () {
            var _a = color_1.color2rgba(this.line_color.value(), this.line_alpha.value()), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
            return 'rgba(' + r * 255 + ',' + g * 255 + ',' + b * 255 + ',' + a + ')';
        };
        return Line;
    }(ContextProperties);
    exports.Line = Line;
    Line.prototype.attrs = Object.keys(mixins.line());
    Line.prototype.do_attr = 'line_color';
    var Fill = function (_super) {
        tslib_1.__extends(Fill, _super);
        function Fill() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Fill.prototype.set_value = function (ctx) {
            ctx.fillStyle = this.fill_color.value();
            ctx.globalAlpha = this.fill_alpha.value();
        };
        Fill.prototype._set_vectorize = function (ctx, i) {
            this.cache_select('fill_color', i);
            if (ctx.fillStyle !== this.cache.fill_color)
                ctx.fillStyle = this.cache.fill_color;
            this.cache_select('fill_alpha', i);
            if (ctx.globalAlpha !== this.cache.fill_alpha)
                ctx.globalAlpha = this.cache.fill_alpha;
        };
        Fill.prototype.color_value = function () {
            var _a = color_1.color2rgba(this.fill_color.value(), this.fill_alpha.value()), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
            return 'rgba(' + r * 255 + ',' + g * 255 + ',' + b * 255 + ',' + a + ')';
        };
        return Fill;
    }(ContextProperties);
    exports.Fill = Fill;
    Fill.prototype.attrs = Object.keys(mixins.fill());
    Fill.prototype.do_attr = 'fill_color';
    var Text = function (_super) {
        tslib_1.__extends(Text, _super);
        function Text() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Text.prototype.cache_select = function (name, i) {
            var value;
            if (name == 'font') {
                _super.prototype.cache_select.call(this, 'text_font_style', i);
                _super.prototype.cache_select.call(this, 'text_font_size', i);
                _super.prototype.cache_select.call(this, 'text_font', i);
                var _a = this.cache, text_font_style = _a.text_font_style, text_font_size = _a.text_font_size, text_font = _a.text_font;
                this.cache.font = value = text_font_style + ' ' + text_font_size + ' ' + text_font;
            } else
                value = _super.prototype.cache_select.call(this, name, i);
            return value;
        };
        Text.prototype.font_value = function () {
            var font = this.text_font.value();
            var font_size = this.text_font_size.value();
            var font_style = this.text_font_style.value();
            return font_style + ' ' + font_size + ' ' + font;
        };
        Text.prototype.color_value = function () {
            var _a = color_1.color2rgba(this.text_color.value(), this.text_alpha.value()), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
            return 'rgba(' + r * 255 + ',' + g * 255 + ',' + b * 255 + ',' + a + ')';
        };
        Text.prototype.set_value = function (ctx) {
            ctx.font = this.font_value();
            ctx.fillStyle = this.text_color.value();
            ctx.globalAlpha = this.text_alpha.value();
            ctx.textAlign = this.text_align.value();
            ctx.textBaseline = this.text_baseline.value();
        };
        Text.prototype._set_vectorize = function (ctx, i) {
            this.cache_select('font', i);
            if (ctx.font !== this.cache.font)
                ctx.font = this.cache.font;
            this.cache_select('text_color', i);
            if (ctx.fillStyle !== this.cache.text_color)
                ctx.fillStyle = this.cache.text_color;
            this.cache_select('text_alpha', i);
            if (ctx.globalAlpha !== this.cache.text_alpha)
                ctx.globalAlpha = this.cache.text_alpha;
            this.cache_select('text_align', i);
            if (ctx.textAlign !== this.cache.text_align)
                ctx.textAlign = this.cache.text_align;
            this.cache_select('text_baseline', i);
            if (ctx.textBaseline !== this.cache.text_baseline)
                ctx.textBaseline = this.cache.text_baseline;
        };
        return Text;
    }(ContextProperties);
    exports.Text = Text;
    Text.prototype.attrs = Object.keys(mixins.text());
    Text.prototype.do_attr = 'text_color';
    var Visuals = function () {
        function Visuals(model) {
            for (var _i = 0, _a = model.mixins; _i < _a.length; _i++) {
                var spec = _a[_i];
                var _b = spec.split(':'), name_1 = _b[0], _c = _b[1], prefix = _c === void 0 ? '' : _c;
                var cls = void 0;
                switch (name_1) {
                case 'line':
                    cls = Line;
                    break;
                case 'fill':
                    cls = Fill;
                    break;
                case 'text':
                    cls = Text;
                    break;
                default:
                    throw new Error('unknown visual: ' + name_1);
                }
                this[prefix + name_1] = new cls(model, prefix);
            }
        }
        Visuals.prototype.warm_cache = function (source) {
            for (var name_2 in this) {
                if (this.hasOwnProperty(name_2)) {
                    var prop = this[name_2];
                    if (prop instanceof ContextProperties)
                        prop.warm_cache(source);
                }
            }
        };
        Visuals.prototype.set_all_indices = function (all_indices) {
            for (var name_3 in this) {
                if (this.hasOwnProperty(name_3)) {
                    var prop = this[name_3];
                    if (prop instanceof ContextProperties)
                        prop.all_indices = all_indices;
                }
            }
        };
        return Visuals;
    }();
    exports.Visuals = Visuals;    
},
/*document*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var base_1 = require(0    /* ./base */);
    var version_1 = require(265    /* ./version */);
    var logging_1 = require(14    /* ./core/logging */);
    var bokeh_events_1 = require(3    /* core/bokeh_events */);
    var has_props_1 = require(8    /* ./core/has_props */);
    var signaling_1 = require(19    /* ./core/signaling */);
    var refs_1 = require(34    /* ./core/util/refs */);
    var serialization_1 = require(36    /* ./core/util/serialization */);
    var data_structures_1 = require(29    /* ./core/util/data_structures */);
    var array_1 = require(21    /* ./core/util/array */);
    var object_1 = require(32    /* ./core/util/object */);
    var eq_1 = require(30    /* ./core/util/eq */);
    var types_1 = require(44    /* ./core/util/types */);
    var layout_dom_1 = require(146    /* ./models/layouts/layout_dom */);
    var column_data_source_1 = require(184    /* ./models/sources/column_data_source */);
    var model_1 = require(53    /* ./model */);
    var EventManager = function () {
        function EventManager(document) {
            this.document = document;
            // Dispatches events to the subscribed models
            this.session = null;
            this.subscribed_models = new data_structures_1.Set();
        }
        EventManager.prototype.send_event = function (event) {
            // Send message to Python via session
            if (this.session != null)
                this.session.send_event(event);
        };
        EventManager.prototype.trigger = function (event) {
            for (var _i = 0, _a = this.subscribed_models.values; _i < _a.length; _i++) {
                var model_id = _a[_i];
                if (event.model_id != null && event.model_id !== model_id)
                    continue;
                var model = this.document._all_models[model_id];
                if (model != null)
                    model._process_event(event);
            }
        };
        return EventManager;
    }();
    exports.EventManager = EventManager;
    var DocumentChangedEvent = function () {
        function DocumentChangedEvent(document) {
            this.document = document;
        }
        return DocumentChangedEvent;
    }();
    exports.DocumentChangedEvent = DocumentChangedEvent;
    var ModelChangedEvent = function (_super) {
        tslib_1.__extends(ModelChangedEvent, _super);
        function ModelChangedEvent(document, model, attr, old, new_, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.attr = attr;
            _this.old = old;
            _this.new_ = new_;
            _this.setter_id = setter_id;
            return _this;
        }
        ModelChangedEvent.prototype.json = function (references) {
            if (this.attr === 'id') {
                throw new Error('\'id\' field should never change, whatever code just set it is wrong');
            }
            var value = this.new_;
            var value_json = has_props_1.HasProps._value_to_json(this.attr, value, this.model);
            var value_refs = {};
            has_props_1.HasProps._value_record_references(value, value_refs, true);
            // true = recurse
            if (this.model.id in value_refs && this.model !== value) {
                // we know we don't want a whole new copy of the obj we're
                // patching unless it's also the value itself
                delete value_refs[this.model.id];
            }
            for (var id in value_refs) {
                references[id] = value_refs[id];
            }
            return {
                kind: 'ModelChanged',
                model: this.model.ref(),
                attr: this.attr,
                new: value_json
            };
        };
        return ModelChangedEvent;
    }(DocumentChangedEvent);
    exports.ModelChangedEvent = ModelChangedEvent;
    var TitleChangedEvent = function (_super) {
        tslib_1.__extends(TitleChangedEvent, _super);
        function TitleChangedEvent(document, title, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.title = title;
            _this.setter_id = setter_id;
            return _this;
        }
        TitleChangedEvent.prototype.json = function (_references) {
            return {
                kind: 'TitleChanged',
                title: this.title
            };
        };
        return TitleChangedEvent;
    }(DocumentChangedEvent);
    exports.TitleChangedEvent = TitleChangedEvent;
    var RootAddedEvent = function (_super) {
        tslib_1.__extends(RootAddedEvent, _super);
        function RootAddedEvent(document, model, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.setter_id = setter_id;
            return _this;
        }
        RootAddedEvent.prototype.json = function (references) {
            has_props_1.HasProps._value_record_references(this.model, references, true);
            return {
                kind: 'RootAdded',
                model: this.model.ref()
            };
        };
        return RootAddedEvent;
    }(DocumentChangedEvent);
    exports.RootAddedEvent = RootAddedEvent;
    var RootRemovedEvent = function (_super) {
        tslib_1.__extends(RootRemovedEvent, _super);
        function RootRemovedEvent(document, model, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.setter_id = setter_id;
            return _this;
        }
        RootRemovedEvent.prototype.json = function (_references) {
            return {
                kind: 'RootRemoved',
                model: this.model.ref()
            };
        };
        return RootRemovedEvent;
    }(DocumentChangedEvent);
    exports.RootRemovedEvent = RootRemovedEvent;
    exports.documents = [];
    exports.DEFAULT_TITLE = 'Bokeh Application';
    // This class should match the API of the Python Document class
    // as much as possible.
    var Document = function () {
        function Document() {
            exports.documents.push(this);
            this._init_timestamp = Date.now();
            this._title = exports.DEFAULT_TITLE;
            this._roots = [];
            this._all_models = {};
            this._all_models_by_name = new data_structures_1.MultiDict();
            this._all_models_freeze_count = 0;
            this._callbacks = [];
            this.event_manager = new EventManager(this);
            this.idle = new signaling_1.Signal0(this, 'idle');
            this._idle_roots = new WeakMap();
            // TODO: WeakSet would be better
            this._interactive_timestamp = null;
            this._interactive_plot = null;
        }
        Object.defineProperty(Document.prototype, 'layoutables', {
            get: function () {
                return this._roots.filter(function (root) {
                    return root instanceof layout_dom_1.LayoutDOM;
                });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Document.prototype, 'is_idle', {
            get: function () {
                for (var _i = 0, _a = this.layoutables; _i < _a.length; _i++) {
                    var root = _a[_i];
                    if (!this._idle_roots.has(root))
                        return false;
                }
                return true;
            },
            enumerable: true,
            configurable: true
        });
        Document.prototype.notify_idle = function (model) {
            this._idle_roots.set(model, true);
            if (this.is_idle) {
                logging_1.logger.info('document idle at ' + (Date.now() - this._init_timestamp) + ' ms');
                this.idle.emit();
            }
        };
        Document.prototype.clear = function () {
            this._push_all_models_freeze();
            try {
                while (this._roots.length > 0) {
                    this.remove_root(this._roots[0]);
                }
            } finally {
                this._pop_all_models_freeze();
            }
        };
        Document.prototype.interactive_start = function (plot) {
            if (this._interactive_plot == null) {
                this._interactive_plot = plot;
                this._interactive_plot.trigger_event(new bokeh_events_1.LODStart({}));
            }
            this._interactive_timestamp = Date.now();
        };
        Document.prototype.interactive_stop = function (plot) {
            if (this._interactive_plot != null && this._interactive_plot.id === plot.id) {
                this._interactive_plot.trigger_event(new bokeh_events_1.LODEnd({}));
            }
            this._interactive_plot = null;
            this._interactive_timestamp = null;
        };
        Document.prototype.interactive_duration = function () {
            if (this._interactive_timestamp == null)
                return -1;
            else
                return Date.now() - this._interactive_timestamp;
        };
        Document.prototype.destructively_move = function (dest_doc) {
            if (dest_doc === this) {
                throw new Error('Attempted to overwrite a document with itself');
            }
            dest_doc.clear();
            // we have to remove ALL roots before adding any
            // to the new doc or else models referenced from multiple
            // roots could be in both docs at once, which isn't allowed.
            var roots = array_1.copy(this._roots);
            this.clear();
            for (var _i = 0, roots_1 = roots; _i < roots_1.length; _i++) {
                var root = roots_1[_i];
                if (root.document != null)
                    throw new Error('Somehow we didn\'t detach ' + root);
            }
            if (Object.keys(this._all_models).length !== 0) {
                throw new Error('this._all_models still had stuff in it: ' + this._all_models);
            }
            for (var _a = 0, roots_2 = roots; _a < roots_2.length; _a++) {
                var root = roots_2[_a];
                dest_doc.add_root(root);
            }
            dest_doc.set_title(this._title);
        };
        // TODO other fields of doc
        Document.prototype._push_all_models_freeze = function () {
            this._all_models_freeze_count += 1;
        };
        Document.prototype._pop_all_models_freeze = function () {
            this._all_models_freeze_count -= 1;
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        };
        /*protected*/
        Document.prototype._invalidate_all_models = function () {
            logging_1.logger.debug('invalidating document models');
            // if freeze count is > 0, we'll recompute on unfreeze
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        };
        Document.prototype._recompute_all_models = function () {
            var new_all_models_set = new data_structures_1.Set();
            for (var _i = 0, _a = this._roots; _i < _a.length; _i++) {
                var r = _a[_i];
                new_all_models_set = new_all_models_set.union(r.references());
            }
            var old_all_models_set = new data_structures_1.Set(object_1.values(this._all_models));
            var to_detach = old_all_models_set.diff(new_all_models_set);
            var to_attach = new_all_models_set.diff(old_all_models_set);
            var recomputed = {};
            for (var _b = 0, _c = new_all_models_set.values; _b < _c.length; _b++) {
                var m = _c[_b];
                recomputed[m.id] = m;
            }
            for (var _d = 0, _e = to_detach.values; _d < _e.length; _d++) {
                var d = _e[_d];
                d.detach_document();
                if (d instanceof model_1.Model && d.name != null)
                    this._all_models_by_name.remove_value(d.name, d);
            }
            for (var _f = 0, _g = to_attach.values; _f < _g.length; _f++) {
                var a = _g[_f];
                a.attach_document(this);
                if (a instanceof model_1.Model && a.name != null)
                    this._all_models_by_name.add_value(a.name, a);
            }
            this._all_models = recomputed;
        };
        Document.prototype.roots = function () {
            return this._roots;
        };
        Document.prototype.add_root = function (model, setter_id) {
            logging_1.logger.debug('Adding root: ' + model);
            if (array_1.includes(this._roots, model))
                return;
            this._push_all_models_freeze();
            try {
                this._roots.push(model);
            } finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new RootAddedEvent(this, model, setter_id));
        };
        Document.prototype.remove_root = function (model, setter_id) {
            var i = this._roots.indexOf(model);
            if (i < 0)
                return;
            this._push_all_models_freeze();
            try {
                this._roots.splice(i, 1);
            } finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new RootRemovedEvent(this, model, setter_id));
        };
        Document.prototype.title = function () {
            return this._title;
        };
        Document.prototype.set_title = function (title, setter_id) {
            if (title !== this._title) {
                this._title = title;
                this._trigger_on_change(new TitleChangedEvent(this, title, setter_id));
            }
        };
        Document.prototype.get_model_by_id = function (model_id) {
            if (model_id in this._all_models) {
                return this._all_models[model_id];
            } else {
                return null;
            }
        };
        Document.prototype.get_model_by_name = function (name) {
            return this._all_models_by_name.get_one(name, 'Multiple models are named \'' + name + '\'');
        };
        Document.prototype.on_change = function (callback) {
            if (!array_1.includes(this._callbacks, callback))
                this._callbacks.push(callback);
        };
        Document.prototype.remove_on_change = function (callback) {
            var i = this._callbacks.indexOf(callback);
            if (i >= 0)
                this._callbacks.splice(i, 1);
        };
        Document.prototype._trigger_on_change = function (event) {
            for (var _i = 0, _a = this._callbacks; _i < _a.length; _i++) {
                var cb = _a[_i];
                cb(event);
            }
        };
        // called by the model
        Document.prototype._notify_change = function (model, attr, old, new_, options) {
            if (attr === 'name') {
                this._all_models_by_name.remove_value(old, model);
                if (new_ != null)
                    this._all_models_by_name.add_value(new_, model);
            }
            var setter_id = options != null ? options.setter_id : void 0;
            this._trigger_on_change(new ModelChangedEvent(this, model, attr, old, new_, setter_id));
        };
        Document._references_json = function (references, include_defaults) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            var references_json = [];
            for (var _i = 0, references_1 = references; _i < references_1.length; _i++) {
                var r = references_1[_i];
                var ref = r.ref();
                ref.attributes = r.attributes_as_json(include_defaults);
                // server doesn't want id in here since it's already in ref above
                delete ref.attributes.id;
                references_json.push(ref);
            }
            return references_json;
        };
        Document._instantiate_object = function (obj_id, obj_type, obj_attrs) {
            var full_attrs = object_1.extend({}, obj_attrs, {
                id: obj_id,
                __deferred__: true
            });
            var model = base_1.Models(obj_type);
            return new model(full_attrs);
        };
        // given a JSON representation of all models in a graph, return a
        // dict of new model objects
        Document._instantiate_references_json = function (references_json, existing_models) {
            // Create all instances, but without setting their props
            var references = {};
            for (var _i = 0, references_json_1 = references_json; _i < references_json_1.length; _i++) {
                var obj = references_json_1[_i];
                var obj_id = obj.id;
                var obj_type = obj.type;
                var obj_attrs = obj.attributes || {};
                var instance = void 0;
                if (obj_id in existing_models)
                    instance = existing_models[obj_id];
                else {
                    instance = Document._instantiate_object(obj_id, obj_type, obj_attrs);
                    if (obj.subtype != null)
                        instance.set_subtype(obj.subtype);
                }
                references[instance.id] = instance;
            }
            return references;
        };
        // if v looks like a ref, or a collection, resolve it, otherwise return it unchanged
        // recurse into collections but not into HasProps
        Document._resolve_refs = function (value, old_references, new_references) {
            function resolve_ref(v) {
                if (refs_1.is_ref(v)) {
                    if (v.id in old_references)
                        return old_references[v.id];
                    else if (v.id in new_references)
                        return new_references[v.id];
                    else
                        throw new Error('reference ' + JSON.stringify(v) + ' isn\'t known (not in Document?)');
                } else if (types_1.isArray(v))
                    return resolve_array(v);
                else if (types_1.isObject(v))
                    return resolve_dict(v);
                else
                    return v;
            }
            function resolve_array(array) {
                var results = [];
                for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
                    var v = array_2[_i];
                    results.push(resolve_ref(v));
                }
                return results;
            }
            function resolve_dict(dict) {
                var resolved = {};
                for (var k in dict) {
                    var v = dict[k];
                    resolved[k] = resolve_ref(v);
                }
                return resolved;
            }
            return resolve_ref(value);
        };
        // given a JSON representation of all models in a graph and new
        // model instances, set the properties on the models from the
        // JSON
        Document._initialize_references_json = function (references_json, old_references, new_references) {
            var to_update = {};
            for (var _i = 0, references_json_2 = references_json; _i < references_json_2.length; _i++) {
                var obj = references_json_2[_i];
                var obj_id = obj.id;
                var obj_attrs = obj.attributes;
                var was_new = !(obj_id in old_references);
                var instance = !was_new ? old_references[obj_id] : new_references[obj_id];
                // replace references with actual instances in obj_attrs
                var resolved_attrs = Document._resolve_refs(obj_attrs, old_references, new_references);
                to_update[instance.id] = [
                    instance,
                    resolved_attrs,
                    was_new
                ];
            }
            function foreach_depth_first(items, f) {
                var already_started = {};
                function foreach_value(v) {
                    if (v instanceof has_props_1.HasProps) {
                        // note that we ignore instances that aren't updated (not in to_update)
                        if (!(v.id in already_started) && v.id in items) {
                            already_started[v.id] = true;
                            var _a = items[v.id], attrs = _a[1], was_new = _a[2];
                            for (var a in attrs) {
                                var e = attrs[a];
                                foreach_value(e);
                            }
                            f(v, attrs, was_new);
                        }
                    } else if (types_1.isArray(v)) {
                        for (var _i = 0, v_1 = v; _i < v_1.length; _i++) {
                            var e = v_1[_i];
                            foreach_value(e);
                        }
                    } else if (types_1.isObject(v)) {
                        for (var k in v) {
                            var e = v[k];
                            foreach_value(e);
                        }
                    }
                }
                for (var k in items) {
                    var _a = items[k], instance = _a[0];
                    foreach_value(instance);
                }
            }
            // this first pass removes all 'refs' replacing them with real instances
            foreach_depth_first(to_update, function (instance, attrs, was_new) {
                if (was_new)
                    instance.setv(attrs, { silent: true });
            });
            // after removing all the refs, we can run the initialize code safely
            foreach_depth_first(to_update, function (instance, _attrs, was_new) {
                if (was_new)
                    instance.finalize();
            });
        };
        Document._event_for_attribute_change = function (changed_obj, key, new_value, doc, value_refs) {
            var changed_model = doc.get_model_by_id(changed_obj.id);
            // XXX!
            if (!changed_model.attribute_is_serializable(key))
                return null;
            else {
                var event_1 = {
                    kind: 'ModelChanged',
                    model: {
                        id: changed_obj.id,
                        type: changed_obj.type
                    },
                    attr: key,
                    new: new_value
                };
                has_props_1.HasProps._json_record_references(doc, new_value, value_refs, true);
                // true = recurse
                return event_1;
            }
        };
        Document._events_to_sync_objects = function (from_obj, to_obj, to_doc, value_refs) {
            var from_keys = Object.keys(from_obj.attributes);
            //XXX!
            var to_keys = Object.keys(to_obj.attributes);
            //XXX!
            var removed = array_1.difference(from_keys, to_keys);
            var added = array_1.difference(to_keys, from_keys);
            var shared = array_1.intersection(from_keys, to_keys);
            var events = [];
            for (var _i = 0, removed_1 = removed; _i < removed_1.length; _i++) {
                var key = removed_1[_i];
                // we don't really have a "remove" event - not sure this ever
                // happens even. One way this could happen is if the server
                // does include_defaults=True and we do
                // include_defaults=false ... in that case it'd be best to
                // just ignore this probably. Warn about it, could mean
                // there's a bug if we don't have a key that the server sent.
                logging_1.logger.warn('Server sent key ' + key + ' but we don\'t seem to have it in our JSON');
            }
            for (var _a = 0, added_1 = added; _a < added_1.length; _a++) {
                var key = added_1[_a];
                var new_value = to_obj.attributes[key];
                // XXX!
                events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
            }
            for (var _b = 0, shared_1 = shared; _b < shared_1.length; _b++) {
                var key = shared_1[_b];
                var old_value = from_obj.attributes[key];
                // XXX!
                var new_value = to_obj.attributes[key];
                // XXX!
                if (old_value == null && new_value == null) {
                } else if (old_value == null || new_value == null) {
                    events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                } else {
                    if (!eq_1.isEqual(old_value, new_value))
                        events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                }
            }
            return events.filter(function (e) {
                return e != null;
            });
        };
        // we use this to detect changes during document deserialization
        // (in model constructors and initializers)
        Document._compute_patch_since_json = function (from_json, to_doc) {
            var to_json = to_doc.to_json(false);
            // include_defaults=false
            function refs(json) {
                var result = {};
                for (var _i = 0, _a = json.roots.references; _i < _a.length; _i++) {
                    var obj = _a[_i];
                    result[obj.id] = obj;
                }
                return result;
            }
            var from_references = refs(from_json);
            var from_roots = {};
            var from_root_ids = [];
            for (var _i = 0, _a = from_json.roots.root_ids; _i < _a.length; _i++) {
                var r = _a[_i];
                from_roots[r] = from_references[r];
                from_root_ids.push(r);
            }
            var to_references = refs(to_json);
            var to_roots = {};
            var to_root_ids = [];
            for (var _b = 0, _c = to_json.roots.root_ids; _b < _c.length; _b++) {
                var r = _c[_b];
                to_roots[r] = to_references[r];
                to_root_ids.push(r);
            }
            from_root_ids.sort();
            to_root_ids.sort();
            if (array_1.difference(from_root_ids, to_root_ids).length > 0 || array_1.difference(to_root_ids, from_root_ids).length > 0) {
                // this would arise if someone does add_root/remove_root during
                // document deserialization, hopefully they won't ever do so.
                throw new Error('Not implemented: computing add/remove of document roots');
            }
            var value_refs = {};
            var events = [];
            for (var id in to_doc._all_models) {
                if (id in from_references) {
                    var update_model_events = Document._events_to_sync_objects(from_references[id], to_references[id], to_doc, value_refs);
                    events = events.concat(update_model_events);
                }
            }
            return {
                references: Document._references_json(object_1.values(value_refs), false),
                events: events
            };
        };
        Document.prototype.to_json_string = function (include_defaults) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            return JSON.stringify(this.to_json(include_defaults));
        };
        Document.prototype.to_json = function (include_defaults) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            var root_ids = this._roots.map(function (r) {
                return r.id;
            });
            var root_references = object_1.values(this._all_models);
            return {
                title: this._title,
                roots: {
                    root_ids: root_ids,
                    references: Document._references_json(root_references, include_defaults)
                }
            };
        };
        Document.from_json_string = function (s) {
            var json = JSON.parse(s);
            return Document.from_json(json);
        };
        Document.from_json = function (json) {
            logging_1.logger.debug('Creating Document from JSON');
            var py_version = json.version;
            // XXX!
            var is_dev = py_version.indexOf('+') !== -1 || py_version.indexOf('-') !== -1;
            var versions_string = 'Library versions: JS (' + version_1.version + ') / Python (' + py_version + ')';
            if (!is_dev && version_1.version !== py_version) {
                logging_1.logger.warn('JS/Python version mismatch');
                logging_1.logger.warn(versions_string);
            } else
                logging_1.logger.debug(versions_string);
            var roots_json = json.roots;
            var root_ids = roots_json.root_ids;
            var references_json = roots_json.references;
            var references = Document._instantiate_references_json(references_json, {});
            Document._initialize_references_json(references_json, {}, references);
            var doc = new Document();
            for (var _i = 0, root_ids_1 = root_ids; _i < root_ids_1.length; _i++) {
                var r = root_ids_1[_i];
                doc.add_root(references[r]);
            }
            // XXX: HasProps
            doc.set_title(json.title);
            // XXX!
            return doc;
        };
        Document.prototype.replace_with_json = function (json) {
            var replacement = Document.from_json(json);
            replacement.destructively_move(this);
        };
        Document.prototype.create_json_patch_string = function (events) {
            return JSON.stringify(this.create_json_patch(events));
        };
        Document.prototype.create_json_patch = function (events) {
            var references = {};
            var json_events = [];
            for (var _i = 0, events_1 = events; _i < events_1.length; _i++) {
                var event_2 = events_1[_i];
                if (event_2.document !== this) {
                    logging_1.logger.warn('Cannot create a patch using events from a different document, event had ', event_2.document, ' we are ', this);
                    throw new Error('Cannot create a patch using events from a different document');
                }
                json_events.push(event_2.json(references));
            }
            return {
                events: json_events,
                references: Document._references_json(object_1.values(references))
            };
        };
        Document.prototype.apply_json_patch = function (patch, buffers, setter_id) {
            var references_json = patch.references;
            var events_json = patch.events;
            var references = Document._instantiate_references_json(references_json, this._all_models);
            // The model being changed isn't always in references so add it in
            for (var _i = 0, events_json_1 = events_json; _i < events_json_1.length; _i++) {
                var event_json = events_json_1[_i];
                switch (event_json.kind) {
                case 'RootAdded':
                case 'RootRemoved':
                case 'ModelChanged': {
                        var model_id = event_json.model.id;
                        if (model_id in this._all_models) {
                            references[model_id] = this._all_models[model_id];
                        } else {
                            if (!(model_id in references)) {
                                logging_1.logger.warn('Got an event for unknown model ', event_json.model);
                                throw new Error('event model wasn\'t known');
                            }
                        }
                        break;
                    }
                }
            }
            // split references into old and new so we know whether to initialize or update
            var old_references = {};
            var new_references = {};
            for (var id in references) {
                var value = references[id];
                if (id in this._all_models)
                    old_references[id] = value;
                else
                    new_references[id] = value;
            }
            Document._initialize_references_json(references_json, old_references, new_references);
            for (var _a = 0, events_json_2 = events_json; _a < events_json_2.length; _a++) {
                var event_json = events_json_2[_a];
                switch (event_json.kind) {
                case 'ModelChanged': {
                        var patched_id = event_json.model.id;
                        if (!(patched_id in this._all_models)) {
                            throw new Error('Cannot apply patch to ' + patched_id + ' which is not in the document');
                        }
                        var patched_obj = this._all_models[patched_id];
                        var attr = event_json.attr;
                        var model_type = event_json.model.type;
                        // XXXX currently still need this first branch, some updates (initial?) go through here
                        if (attr === 'data' && model_type === 'ColumnDataSource') {
                            var _b = serialization_1.decode_column_data(event_json.new, buffers), data = _b[0], shapes = _b[1];
                            patched_obj.setv({
                                _shapes: shapes,
                                data: data
                            }, { setter_id: setter_id });
                        } else {
                            var value = Document._resolve_refs(event_json.new, old_references, new_references);
                            patched_obj.setv((_c = {}, _c[attr] = value, _c), { setter_id: setter_id });
                        }
                        break;
                    }
                case 'ColumnDataChanged': {
                        var column_source_id = event_json.column_source.id;
                        if (!(column_source_id in this._all_models)) {
                            throw new Error('Cannot stream to ' + column_source_id + ' which is not in the document');
                        }
                        var column_source = this._all_models[column_source_id];
                        var _d = serialization_1.decode_column_data(event_json.new, buffers), data = _d[0], shapes = _d[1];
                        if (event_json.cols != null) {
                            for (var k in column_source.data) {
                                if (!(k in data)) {
                                    data[k] = column_source.data[k];
                                }
                            }
                            for (var k in column_source._shapes) {
                                if (!(k in shapes)) {
                                    shapes[k] = column_source._shapes[k];
                                }
                            }
                        }
                        column_source.setv({
                            _shapes: shapes,
                            data: data
                        }, {
                            setter_id: setter_id,
                            check_eq: false
                        });
                        break;
                    }
                case 'ColumnsStreamed': {
                        var column_source_id = event_json.column_source.id;
                        if (!(column_source_id in this._all_models)) {
                            throw new Error('Cannot stream to ' + column_source_id + ' which is not in the document');
                        }
                        var column_source = this._all_models[column_source_id];
                        if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                            throw new Error('Cannot stream to non-ColumnDataSource');
                        }
                        var data = event_json.data;
                        var rollover = event_json.rollover;
                        column_source.stream(data, rollover);
                        break;
                    }
                case 'ColumnsPatched': {
                        var column_source_id = event_json.column_source.id;
                        if (!(column_source_id in this._all_models)) {
                            throw new Error('Cannot patch ' + column_source_id + ' which is not in the document');
                        }
                        var column_source = this._all_models[column_source_id];
                        if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                            throw new Error('Cannot patch non-ColumnDataSource');
                        }
                        var patches = event_json.patches;
                        column_source.patch(patches);
                        break;
                    }
                case 'RootAdded': {
                        var root_id = event_json.model.id;
                        var root_obj = references[root_id];
                        this.add_root(root_obj, setter_id);
                        // XXX: HasProps
                        break;
                    }
                case 'RootRemoved': {
                        var root_id = event_json.model.id;
                        var root_obj = references[root_id];
                        this.remove_root(root_obj, setter_id);
                        // XXX: HasProps
                        break;
                    }
                case 'TitleChanged': {
                        this.set_title(event_json.title, setter_id);
                        break;
                    }
                default:
                    throw new Error('Unknown patch event ' + JSON.stringify(event_json));
                }
            }
            var _c;
        };
        return Document;
    }();
    exports.Document = Document;    
},
/*embed*/
function _(require, module, exports) {
    var base = require(0    /* ./base */);
    var logging_1 = require(14    /* ./core/logging */);
    var document_1 = require(50    /* ./document */);
    var dom_1 = require(5    /* ./core/dom */);
    var callback_1 = require(25    /* ./core/util/callback */);
    var string_1 = require(38    /* ./core/util/string */);
    var object_1 = require(32    /* ./core/util/object */);
    var types_1 = require(44    /* ./core/util/types */);
    var receiver_1 = require(263    /* ./protocol/receiver */);
    var connection_1 = require(1    /* ./client/connection */);
    exports.kernels = {};
    // Matches Bokeh CSS class selector. Setting all Bokeh parent element class names
    // with this var prevents user configurations where css styling is unset.
    exports.BOKEH_ROOT = 'bk-root';
    function _handle_notebook_comms(receiver, comm_msg) {
        if (comm_msg.buffers.length > 0)
            receiver.consume(comm_msg.buffers[0].buffer);
        else
            receiver.consume(comm_msg.content.data);
        var msg = receiver.message;
        if (msg != null)
            this.apply_json_patch(msg.content, msg.buffers);
    }
    function _init_comms(target, doc) {
        if (typeof Jupyter !== 'undefined' && Jupyter.notebook.kernel != null) {
            logging_1.logger.info('Registering Jupyter comms for target ' + target);
            var comm_manager = Jupyter.notebook.kernel.comm_manager;
            try {
                comm_manager.register_target(target, function (comm) {
                    logging_1.logger.info('Registering Jupyter comms for target ' + target);
                    var r = new receiver_1.Receiver();
                    comm.on_msg(_handle_notebook_comms.bind(doc, r));
                });
            } catch (e) {
                logging_1.logger.warn('Jupyter comms failed to register. push_notebook() will not function. (exception reported: ' + e + ')');
            }
        } else if (doc.roots()[0].id in exports.kernels) {
            logging_1.logger.info('Registering JupyterLab comms for target ' + target);
            var kernel = exports.kernels[doc.roots()[0].id];
            try {
                kernel.registerCommTarget(target, function (comm) {
                    logging_1.logger.info('Registering JupyterLab comms for target ' + target);
                    var r = new receiver_1.Receiver();
                    comm.onMsg = _handle_notebook_comms.bind(doc, r);
                });
            } catch (e) {
                logging_1.logger.warn('Jupyter comms failed to register. push_notebook() will not function. (exception reported: ' + e + ')');
            }
        } else {
            console.warn('Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest jupyterlab_bokeh extension is installed. In an exported notebook this warning is expected.');
        }
    }
    function _create_view(model) {
        var view = new model.default_view({
            model: model,
            parent: null
        });
        base.index[model.id] = view;
        return view;
    }
    function _get_element(item) {
        var element_id = item.elementid;
        var elem = document.getElementById(element_id);
        if (elem == null)
            throw new Error('Error rendering Bokeh model: could not find tag with id: ' + element_id);
        if (!document.body.contains(elem))
            throw new Error('Error rendering Bokeh model: element with id \'' + element_id + '\' must be under <body>');
        // if autoload script, replace script tag with div for embedding
        if (elem.tagName == 'SCRIPT') {
            fill_render_item_from_script_tag(elem, item);
            var container = dom_1.div({ class: exports.BOKEH_ROOT });
            dom_1.replaceWith(elem, container);
            var child = dom_1.div();
            container.appendChild(child);
            elem = child;
        }
        return elem;
    }
    // Replace element with a view of model_id from document
    function add_model_standalone(model_id, element, doc) {
        var model = doc.get_model_by_id(model_id);
        if (model == null)
            throw new Error('Model ' + model_id + ' was not in document ' + doc);
        var view = _create_view(model);
        view.renderTo(element, true);
        return view;
    }
    exports.add_model_standalone = add_model_standalone;
    // Fill element with the roots from doc
    function add_document_standalone(document, element, use_for_title) {
        if (use_for_title === void 0) {
            use_for_title = false;
        }
        // this is a LOCAL index of views used only by this particular rendering
        // call, so we can remove the views we create.
        var views = {};
        function render_model(model) {
            var view = _create_view(model);
            view.renderTo(element);
            views[model.id] = view;
        }
        function unrender_model(model) {
            if (model.id in views) {
                var view = views[model.id];
                element.removeChild(view.el);
                delete views[model.id];
                delete base.index[model.id];
            }
        }
        for (var _i = 0, _a = document.roots(); _i < _a.length; _i++) {
            var model = _a[_i];
            render_model(model);
        }
        if (use_for_title)
            window.document.title = document.title();
        document.on_change(function (event) {
            if (event instanceof document_1.RootAddedEvent)
                render_model(event.model);
            else if (event instanceof document_1.RootRemovedEvent)
                unrender_model(event.model);
            else if (use_for_title && event instanceof document_1.TitleChangedEvent)
                window.document.title = event.title;
        });
        return views;
    }
    exports.add_document_standalone = add_document_standalone;
    // map { websocket url to map { session id to promise of ClientSession } }
    var _sessions = {};
    function _get_session(websocket_url, session_id, args_string) {
        if (!(websocket_url in _sessions))
            _sessions[websocket_url] = {};
        var subsessions = _sessions[websocket_url];
        if (!(session_id in subsessions))
            subsessions[session_id] = connection_1.pull_session(websocket_url, session_id, args_string);
        return subsessions[session_id];
    }
    // Fill element with the roots from session_id
    function add_document_from_session(element, websocket_url, session_id, use_for_title) {
        var args_string = window.location.search.substr(1);
        var promise = _get_session(websocket_url, session_id, args_string);
        return promise.then(function (session) {
            return add_document_standalone(session.document, element, use_for_title);
        }, function (error) {
            logging_1.logger.error('Failed to load Bokeh session ' + session_id + ': ' + error);
            throw error;
        });
    }
    exports.add_document_from_session = add_document_from_session;
    // Replace element with a view of model_id from the given session
    function add_model_from_session(element, websocket_url, model_id, session_id) {
        var args_string = window.location.search.substr(1);
        var promise = _get_session(websocket_url, session_id, args_string);
        return promise.then(function (session) {
            var model = session.document.get_model_by_id(model_id);
            if (model == null)
                throw new Error('Did not find model ' + model_id + ' in session');
            var view = _create_view(model);
            view.renderTo(element, true);
            return view;
        }, function (error) {
            logging_1.logger.error('Failed to load Bokeh session ' + session_id + ': ' + error);
            throw error;
        });
    }
    exports.add_model_from_session = add_model_from_session;
    function inject_css(url) {
        var element = dom_1.link({
            href: url,
            rel: 'stylesheet',
            type: 'text/css'
        });
        document.body.appendChild(element);
    }
    exports.inject_css = inject_css;
    function inject_raw_css(css) {
        var element = dom_1.style({}, css);
        document.body.appendChild(element);
    }
    exports.inject_raw_css = inject_raw_css;
    // pull missing render item fields from data- attributes
    function fill_render_item_from_script_tag(script, item) {
        var _a = script.dataset, bokehLogLevel = _a.bokehLogLevel, bokehDocId = _a.bokehDocId, bokehModelId = _a.bokehModelId, bokehSessionId = _a.bokehSessionId;
        // length checks are because we put all the attributes on the tag
        // but sometimes set them to empty string
        if (bokehLogLevel != null && bokehLogLevel.length > 0)
            logging_1.set_log_level(bokehLogLevel);
        if (bokehDocId != null && bokehDocId.length > 0)
            item.docid = bokehDocId;
        if (bokehModelId != null && bokehModelId.length > 0)
            item.modelid = bokehModelId;
        if (bokehSessionId != null && bokehSessionId.length > 0)
            item.sessionid = bokehSessionId;
        logging_1.logger.info('Will inject Bokeh script tag with params ' + JSON.stringify(item));
    }
    function embed_items_notebook(docs_json, render_items) {
        if (object_1.size(docs_json) != 1)
            throw new Error('embed_items_notebook expects exactly one document in docs_json');
        var doc = document_1.Document.from_json(object_1.values(docs_json)[0]);
        for (var _i = 0, render_items_1 = render_items; _i < render_items_1.length; _i++) {
            var item = render_items_1[_i];
            if (item.notebook_comms_target != null)
                _init_comms(item.notebook_comms_target, doc);
            var elem = _get_element(item);
            if (item.modelid != null)
                add_model_standalone(item.modelid, elem, doc);
            else
                add_document_standalone(doc, elem, false);
        }
    }
    exports.embed_items_notebook = embed_items_notebook;
    function _get_ws_url(app_path, absolute_url) {
        var protocol = 'ws:';
        if (window.location.protocol == 'https:')
            protocol = 'wss:';
        var loc;
        if (absolute_url != null) {
            loc = document.createElement('a');
            loc.href = absolute_url;
        } else
            loc = window.location;
        if (app_path != null) {
            if (app_path == '/')
                app_path = '';
        } else
            app_path = loc.pathname.replace(/\/+$/, '');
        return protocol + '//' + loc.host + app_path + '/ws';
    }
    // TODO (bev) this is currently clunky. Standalone embeds only provide
    // the first two args, whereas server provide the app_app, and *may* prove and
    // absolute_url as well if non-relative links are needed for resources. This function
    // should probably be split in to two pieces to reflect the different usage patterns
    function embed_items(docs_json, render_items, app_path, absolute_url) {
        callback_1.defer(function () {
            return _embed_items(docs_json, render_items, app_path, absolute_url);
        });
    }
    exports.embed_items = embed_items;
    function _embed_items(docs_json, render_items, app_path, absolute_url) {
        if (types_1.isString(docs_json))
            docs_json = JSON.parse(string_1.unescape(docs_json));
        var docs = {};
        for (var docid in docs_json) {
            var doc_json = docs_json[docid];
            docs[docid] = document_1.Document.from_json(doc_json);
        }
        for (var _i = 0, render_items_2 = render_items; _i < render_items_2.length; _i++) {
            var item = render_items_2[_i];
            var elem = _get_element(item);
            var use_for_title = item.use_for_title != null && item.use_for_title;
            // handle server session cases
            if (item.sessionid != null) {
                var websocket_url = _get_ws_url(app_path, absolute_url);
                logging_1.logger.debug('embed: computed ws url: ' + websocket_url);
                var promise = void 0;
                if (item.modelid != null)
                    promise = add_model_from_session(elem, websocket_url, item.modelid, item.sessionid);
                else
                    promise = add_document_from_session(elem, websocket_url, item.sessionid, use_for_title);
                promise.then(function () {
                    console.log('Bokeh items were rendered successfully');
                }, function (error) {
                    console.log('Error rendering Bokeh items ', error);
                });    // handle standalone document cases
            } else if (item.docid != null) {
                if (item.modelid != null)
                    add_model_standalone(item.modelid, elem, docs[item.docid]);
                else
                    add_document_standalone(docs[item.docid], elem, use_for_title);
            } else
                throw new Error('Error rendering Bokeh items to element ' + item.elementid + ': no document ID or session ID specified');
        }
    }    
},
/*main*/
function _(require, module, exports) {
    require(260    /* ./polyfill */);
    var version_1 = require(265    /* ./version */);
    exports.version = version_1.version;
    var embed = require(51    /* ./embed */);
    exports.embed = embed;
    var protocol = require(261    /* ./protocol */);
    exports.protocol = protocol;
    var logging_1 = require(14    /* ./core/logging */);
    exports.logger = logging_1.logger;
    exports.set_log_level = logging_1.set_log_level;
    var settings_1 = require(18    /* ./core/settings */);
    exports.settings = settings_1.settings;
    var base_1 = require(0    /* ./base */);
    exports.Models = base_1.Models;
    exports.index = base_1.index;
    var document_1 = require(50    /* ./document */);
    exports.documents = document_1.documents;
    var safely_1 = require(264    /* ./safely */);
    exports.safely = safely_1.safely;    
},
/*model*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var has_props_1 = require(8    /* ./core/has_props */);
    var p = require(15    /* ./core/properties */);
    var types_1 = require(44    /* ./core/util/types */);
    var object_1 = require(32    /* ./core/util/object */);
    var logging_1 = require(14    /* ./core/logging */);
    var Model = function (_super) {
        tslib_1.__extends(Model, _super);
        function Model(attrs) {
            return _super.call(this, attrs) || this;
        }
        Model.initClass = function () {
            this.prototype.type = 'Model';
            this.define({
                tags: [
                    p.Array,
                    []
                ],
                name: [p.String],
                js_property_callbacks: [
                    p.Any,
                    {}
                ],
                js_event_callbacks: [
                    p.Any,
                    {}
                ],
                subscribed_events: [
                    p.Array,
                    []
                ]
            });
        };
        Model.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            for (var base_evt in this.js_property_callbacks) {
                var callbacks = this.js_property_callbacks[base_evt];
                var _a = base_evt.split(':'), evt = _a[0], _b = _a[1], attr = _b === void 0 ? null : _b;
                var _loop_1 = function (cb) {
                    var signal = attr != null ? this_1.properties[attr][evt] : this_1[evt];
                    this_1.connect(signal, function () {
                        return cb.execute(_this, {});
                    });
                };
                var this_1 = this;
                for (var _i = 0, callbacks_1 = callbacks; _i < callbacks_1.length; _i++) {
                    var cb = callbacks_1[_i];
                    _loop_1(cb);
                }
            }
            this.connect(this.properties.js_event_callbacks.change, function () {
                return _this._update_event_callbacks;
            });
            this.connect(this.properties.subscribed_events.change, function () {
                return _this._update_event_callbacks;
            });
        };
        /*protected*/
        Model.prototype._process_event = function (event) {
            if (event.is_applicable_to(this)) {
                event = event._customize_event(this);
                for (var _i = 0, _a = this.js_event_callbacks[event.event_name] || []; _i < _a.length; _i++) {
                    var callback = _a[_i];
                    callback.execute(event, {});
                }
                if (this.document != null) {
                    if (this.subscribed_events.some(function (m) {
                            return m == event.event_name;
                        }))
                        this.document.event_manager.send_event(event);
                }
            }
        };
        Model.prototype.trigger_event = function (event) {
            if (this.document != null)
                this.document.event_manager.trigger(event.set_model_id(this.id));
        };
        Model.prototype._update_event_callbacks = function () {
            if (this.document == null) {
                // File an issue: SidePanel in particular seems to have this issue
                logging_1.logger.warn('WARNING: Document not defined for updating event callbacks');
                return;
            }
            this.document.event_manager.subscribed_models.push(this.id);
        };
        Model.prototype._doc_attached = function () {
            if (!object_1.isEmpty(this.js_event_callbacks) || !object_1.isEmpty(this.subscribed_events))
                this._update_event_callbacks();
        };
        Model.prototype.select = function (selector) {
            if (types_1.isString(selector))
                return this.references().filter(function (ref) {
                    return ref instanceof Model && ref.name === selector;
                });
            else if (selector.prototype instanceof has_props_1.HasProps)
                return this.references().filter(function (ref) {
                    return ref instanceof selector;
                });
            else
                throw new Error('invalid selector');
        };
        Model.prototype.select_one = function (selector) {
            var result = this.select(selector);
            switch (result.length) {
            case 0:
                return null;
            case 1:
                return result[0];
            default:
                throw new Error('found more than one object matching given selector');
            }
        };
        return Model;
    }(has_props_1.HasProps);
    exports.Model = Model;
    Model.initClass();    
},
/*models/annotations/annotation*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var side_panel_1 = require(12    /* core/layout/side_panel */);
    var p = require(15    /* core/properties */);
    var proj = require(33    /* core/util/projections */);
    var object_1 = require(32    /* core/util/object */);
    var renderer_1 = require(173    /* ../renderers/renderer */);
    var AnnotationView = function (_super) {
        tslib_1.__extends(AnnotationView, _super);
        function AnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AnnotationView.prototype._get_size = function () {
            throw new Error('not implemented');
        };
        AnnotationView.prototype.get_size = function () {
            return this.model.visible ? Math.round(this._get_size()) : 0;
        };
        AnnotationView.prototype.set_data = function (source) {
            var data = this.model.materialize_dataspecs(source);
            object_1.extend(this, data);
            if (this.plot_model.use_map) {
                var self_1 = this;
                if (self_1._x != null)
                    _a = proj.project_xy(self_1._x, self_1._y), self_1._x = _a[0], self_1._y = _a[1];
                if (self_1._xs != null)
                    _b = proj.project_xsys(self_1._xs, self_1._ys), self_1._xs = _b[0], self_1._ys = _b[1];
            }
            var _a, _b;
        };
        return AnnotationView;
    }(renderer_1.RendererView);
    exports.AnnotationView = AnnotationView;
    var Annotation = function (_super) {
        tslib_1.__extends(Annotation, _super);
        function Annotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        Annotation.initClass = function () {
            this.prototype.type = 'Annotation';
            this.define({ plot: [p.Instance] });
            this.override({ level: 'annotation' });
        };
        Annotation.prototype.add_panel = function (side) {
            if (this.panel == null || side !== this.panel.side) {
                var panel = new side_panel_1.SidePanel({ side: side });
                panel.attach_document(this.document);
                this.set_panel(panel);
            }
        };
        Annotation.prototype.set_panel = function (panel) {
            this.panel = panel;
            // If the annotation is in a side panel, we need to set level to overlay, so it is visible.
            this.level = 'overlay';
        };
        return Annotation;
    }(renderer_1.Renderer);
    exports.Annotation = Annotation;
    Annotation.initClass();    
},
/*models/annotations/arrow*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var annotation_1 = require(54    /* ./annotation */);
    var arrow_head_1 = require(56    /* ./arrow_head */);
    var column_data_source_1 = require(184    /* ../sources/column_data_source */);
    var p = require(15    /* core/properties */);
    var math_1 = require(31    /* core/util/math */);
    var ArrowView = function (_super) {
        tslib_1.__extends(ArrowView, _super);
        function ArrowView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ArrowView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            if (this.model.source == null)
                this.model.source = new column_data_source_1.ColumnDataSource();
            this.set_data(this.model.source);
        };
        ArrowView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () {
                return _this.plot_view.request_render();
            });
            this.connect(this.model.source.streaming, function () {
                return _this.set_data(_this.model.source);
            });
            this.connect(this.model.source.patching, function () {
                return _this.set_data(_this.model.source);
            });
            this.connect(this.model.source.change, function () {
                return _this.set_data(_this.model.source);
            });
        };
        ArrowView.prototype.set_data = function (source) {
            _super.prototype.set_data.call(this, source);
            this.visuals.warm_cache(source);
            this.plot_view.request_render();
        };
        ArrowView.prototype._map_data = function () {
            var frame = this.plot_view.frame;
            var sx_start, sy_start;
            if (this.model.start_units == 'data') {
                sx_start = frame.xscales[this.model.x_range_name].v_compute(this._x_start);
                sy_start = frame.yscales[this.model.y_range_name].v_compute(this._y_start);
            } else {
                sx_start = frame.xview.v_compute(this._x_start);
                sy_start = frame.yview.v_compute(this._y_start);
            }
            var sx_end, sy_end;
            if (this.model.end_units == 'data') {
                sx_end = frame.xscales[this.model.x_range_name].v_compute(this._x_end);
                sy_end = frame.yscales[this.model.y_range_name].v_compute(this._y_end);
            } else {
                sx_end = frame.xview.v_compute(this._x_end);
                sy_end = frame.yview.v_compute(this._y_end);
            }
            return [
                [
                    sx_start,
                    sy_start
                ],
                [
                    sx_end,
                    sy_end
                ]
            ];
        };
        ArrowView.prototype.render = function () {
            if (!this.model.visible)
                return;
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            // Order in this function is important. First we draw all the arrow heads.
            var _a = this._map_data(), start = _a[0], end = _a[1];
            if (this.model.end != null)
                this._arrow_head(ctx, 'render', this.model.end, start, end);
            if (this.model.start != null)
                this._arrow_head(ctx, 'render', this.model.start, end, start);
            // Next we call .clip on all the arrow heads, inside an initial canvas sized
            // rect, to create an "inverted" clip region for the arrow heads
            ctx.beginPath();
            var _b = this.plot_model.canvas.bbox.rect, x = _b.x, y = _b.y, width = _b.width, height = _b.height;
            ctx.rect(x, y, width, height);
            if (this.model.end != null)
                this._arrow_head(ctx, 'clip', this.model.end, start, end);
            if (this.model.start != null)
                this._arrow_head(ctx, 'clip', this.model.start, end, start);
            ctx.closePath();
            ctx.clip();
            // Finally we draw the arrow body, with the clipping regions set up. This prevents
            // "fat" arrows from overlapping the arrow head in a bad way.
            this._arrow_body(ctx, start, end);
            ctx.restore();
        };
        ArrowView.prototype._arrow_head = function (ctx, action, head, start, end) {
            for (var i = 0, _end = this._x_start.length; i < _end; i++) {
                // arrow head runs orthogonal to arrow body
                var angle = Math.PI / 2 + math_1.atan2([
                    start[0][i],
                    start[1][i]
                ], [
                    end[0][i],
                    end[1][i]
                ]);
                ctx.save();
                ctx.translate(end[0][i], end[1][i]);
                ctx.rotate(angle);
                if (action == 'render')
                    head.render(ctx, i);
                else if (action == 'clip')
                    head.clip(ctx, i);
                ctx.restore();
            }
        };
        ArrowView.prototype._arrow_body = function (ctx, start, end) {
            if (!this.visuals.line.doit)
                return;
            for (var i = 0, n = this._x_start.length; i < n; i++) {
                this.visuals.line.set_vectorize(ctx, i);
                ctx.beginPath();
                ctx.moveTo(start[0][i], start[1][i]);
                ctx.lineTo(end[0][i], end[1][i]);
                ctx.stroke();
            }
        };
        return ArrowView;
    }(annotation_1.AnnotationView);
    exports.ArrowView = ArrowView;
    var Arrow = function (_super) {
        tslib_1.__extends(Arrow, _super);
        function Arrow(attrs) {
            return _super.call(this, attrs) || this;
        }
        Arrow.initClass = function () {
            this.prototype.type = 'Arrow';
            this.prototype.default_view = ArrowView;
            this.mixins(['line']);
            this.define({
                x_start: [p.NumberSpec],
                y_start: [p.NumberSpec],
                start_units: [
                    p.String,
                    'data'
                ],
                start: [
                    p.Instance,
                    null
                ],
                x_end: [p.NumberSpec],
                y_end: [p.NumberSpec],
                end_units: [
                    p.String,
                    'data'
                ],
                end: [
                    p.Instance,
                    function () {
                        return new arrow_head_1.OpenHead({});
                    }
                ],
                source: [p.Instance],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
        };
        return Arrow;
    }(annotation_1.Annotation);
    exports.Arrow = Arrow;
    Arrow.initClass();    
},
/*models/annotations/arrow_head*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var annotation_1 = require(54    /* ./annotation */);
    var visuals_1 = require(49    /* core/visuals */);
    var p = require(15    /* core/properties */);
    var ArrowHead = function (_super) {
        tslib_1.__extends(ArrowHead, _super);
        function ArrowHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        ArrowHead.initClass = function () {
            this.prototype.type = 'ArrowHead';
            this.define({
                size: [
                    p.Number,
                    25
                ]
            });
        };
        ArrowHead.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.visuals = new visuals_1.Visuals(this);
        };
        return ArrowHead;
    }(annotation_1.Annotation);
    exports.ArrowHead = ArrowHead;
    ArrowHead.initClass();
    var OpenHead = function (_super) {
        tslib_1.__extends(OpenHead, _super);
        function OpenHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        OpenHead.initClass = function () {
            this.prototype.type = 'OpenHead';
            this.mixins(['line']);
        };
        OpenHead.prototype.clip = function (ctx, i) {
            // This method should not begin or close a path
            this.visuals.line.set_vectorize(ctx, i);
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.lineTo(0, 0);
            ctx.lineTo(0.5 * this.size, this.size);
        };
        OpenHead.prototype.render = function (ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                ctx.beginPath();
                ctx.moveTo(0.5 * this.size, this.size);
                ctx.lineTo(0, 0);
                ctx.lineTo(-0.5 * this.size, this.size);
                ctx.stroke();
            }
        };
        return OpenHead;
    }(ArrowHead);
    exports.OpenHead = OpenHead;
    OpenHead.initClass();
    var NormalHead = function (_super) {
        tslib_1.__extends(NormalHead, _super);
        function NormalHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        NormalHead.initClass = function () {
            this.prototype.type = 'NormalHead';
            this.mixins([
                'line',
                'fill'
            ]);
            this.override({ fill_color: 'black' });
        };
        NormalHead.prototype.clip = function (ctx, i) {
            // This method should not begin or close a path
            this.visuals.line.set_vectorize(ctx, i);
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.lineTo(0.5 * this.size, this.size);
        };
        NormalHead.prototype.render = function (ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.stroke();
            }
        };
        NormalHead.prototype._normal = function (ctx, _i) {
            ctx.beginPath();
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.closePath();
        };
        return NormalHead;
    }(ArrowHead);
    exports.NormalHead = NormalHead;
    NormalHead.initClass();
    var VeeHead = function (_super) {
        tslib_1.__extends(VeeHead, _super);
        function VeeHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        VeeHead.initClass = function () {
            this.prototype.type = 'VeeHead';
            this.mixins([
                'line',
                'fill'
            ]);
            this.override({ fill_color: 'black' });
        };
        VeeHead.prototype.clip = function (ctx, i) {
            // This method should not begin or close a path
            this.visuals.line.set_vectorize(ctx, i);
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.lineTo(0, 0.5 * this.size);
            ctx.lineTo(0.5 * this.size, this.size);
        };
        VeeHead.prototype.render = function (ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.stroke();
            }
        };
        VeeHead.prototype._vee = function (ctx, _i) {
            ctx.beginPath();
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.lineTo(0, 0.5 * this.size);
            ctx.closePath();
        };
        return VeeHead;
    }(ArrowHead);
    exports.VeeHead = VeeHead;
    VeeHead.initClass();
    var TeeHead = function (_super) {
        tslib_1.__extends(TeeHead, _super);
        function TeeHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        TeeHead.initClass = function () {
            this.prototype.type = 'TeeHead';
            this.mixins(['line']);
        };
        TeeHead.prototype.render = function (ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                ctx.beginPath();
                ctx.moveTo(0.5 * this.size, 0);
                ctx.lineTo(-0.5 * this.size, 0);
                ctx.stroke();
            }
        };
        TeeHead.prototype.clip = function (_ctx, _i) {
        };
        return TeeHead;
    }(ArrowHead);
    exports.TeeHead = TeeHead;
    TeeHead.initClass();    
},
/*models/annotations/band*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var annotation_1 = require(54    /* ./annotation */);
    var column_data_source_1 = require(184    /* ../sources/column_data_source */);
    var p = require(15    /* core/properties */);
    var BandView = function (_super) {
        tslib_1.__extends(BandView, _super);
        function BandView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BandView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.set_data(this.model.source);
        };
        BandView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.source.streaming, function () {
                return _this.set_data(_this.model.source);
            });
            this.connect(this.model.source.patching, function () {
                return _this.set_data(_this.model.source);
            });
            this.connect(this.model.source.change, function () {
                return _this.set_data(_this.model.source);
            });
        };
        BandView.prototype.set_data = function (source) {
            _super.prototype.set_data.call(this, source);
            this.visuals.warm_cache(source);
            this.plot_view.request_render();
        };
        BandView.prototype._map_data = function () {
            var frame = this.plot_view.frame;
            var dim = this.model.dimension;
            var xscale = frame.xscales[this.model.x_range_name];
            var yscale = frame.yscales[this.model.y_range_name];
            var limit_scale = dim == 'height' ? yscale : xscale;
            var base_scale = dim == 'height' ? xscale : yscale;
            var limit_view = dim == 'height' ? frame.yview : frame.xview;
            var base_view = dim == 'height' ? frame.xview : frame.yview;
            var _lower_sx;
            if (this.model.lower.units == 'data')
                _lower_sx = limit_scale.v_compute(this._lower);
            else
                _lower_sx = limit_view.v_compute(this._lower);
            var _upper_sx;
            if (this.model.upper.units == 'data')
                _upper_sx = limit_scale.v_compute(this._upper);
            else
                _upper_sx = limit_view.v_compute(this._upper);
            var _base_sx;
            if (this.model.base.units == 'data')
                _base_sx = base_scale.v_compute(this._base);
            else
                _base_sx = base_view.v_compute(this._base);
            var _a = dim == 'height' ? [
                    1,
                    0
                ] : [
                    0,
                    1
                ], i = _a[0], j = _a[1];
            var _lower = [
                _lower_sx,
                _base_sx
            ];
            var _upper = [
                _upper_sx,
                _base_sx
            ];
            this._lower_sx = _lower[i];
            this._lower_sy = _lower[j];
            this._upper_sx = _upper[i];
            this._upper_sy = _upper[j];
        };
        BandView.prototype.render = function () {
            if (!this.model.visible)
                return;
            this._map_data();
            var ctx = this.plot_view.canvas_view.ctx;
            // Draw the band body
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (var start = this._upper_sx.length - 1, i = start; i >= 0; i--) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            ctx.closePath();
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                ctx.fill();
            }
            // Draw the lower band edge
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
            // Draw the upper band edge
            ctx.beginPath();
            ctx.moveTo(this._upper_sx[0], this._upper_sy[0]);
            for (var i = 0, end = this._upper_sx.length; i < end; i++) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
        };
        return BandView;
    }(annotation_1.AnnotationView);
    exports.BandView = BandView;
    var Band = function (_super) {
        tslib_1.__extends(Band, _super);
        function Band(attrs) {
            return _super.call(this, attrs) || this;
        }
        Band.initClass = function () {
            this.prototype.type = 'Band';
            this.prototype.default_view = BandView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                lower: [p.DistanceSpec],
                upper: [p.DistanceSpec],
                base: [p.DistanceSpec],
                dimension: [
                    p.Dimension,
                    'height'
                ],
                source: [
                    p.Instance,
                    function () {
                        return new column_data_source_1.ColumnDataSource();
                    }
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
            this.override({
                fill_color: '#fff9ba',
                fill_alpha: 0.4,
                line_color: '#cccccc',
                line_alpha: 0.3
            });
        };
        return Band;
    }(annotation_1.Annotation);
    exports.Band = Band;
    Band.initClass();    
},
/*models/annotations/box_annotation*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var annotation_1 = require(54    /* ./annotation */);
    var signaling_1 = require(19    /* core/signaling */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var BoxAnnotationView = function (_super) {
        tslib_1.__extends(BoxAnnotationView, _super);
        function BoxAnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BoxAnnotationView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.plot_view.canvas_overlays.appendChild(this.el);
            this.el.classList.add('bk-shading');
            dom_1.hide(this.el);
        };
        BoxAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            // need to respond to either normal BB change events or silent
            // "data only updates" that tools might want to use
            if (this.model.render_mode == 'css') {
                // dispatch CSS update immediately
                this.connect(this.model.change, function () {
                    return _this.render();
                });
                this.connect(this.model.data_update, function () {
                    return _this.render();
                });
            } else {
                this.connect(this.model.change, function () {
                    return _this.plot_view.request_render();
                });
                this.connect(this.model.data_update, function () {
                    return _this.plot_view.request_render();
                });
            }
        };
        BoxAnnotationView.prototype.render = function () {
            var _this = this;
            if (!this.model.visible && this.model.render_mode == 'css')
                dom_1.hide(this.el);
            if (!this.model.visible)
                return;
            // don't render if *all* position are null
            if (this.model.left == null && this.model.right == null && this.model.top == null && this.model.bottom == null) {
                dom_1.hide(this.el);
                return;
            }
            var frame = this.plot_model.frame;
            var xscale = frame.xscales[this.model.x_range_name];
            var yscale = frame.yscales[this.model.y_range_name];
            var _calc_dim = function (dim, dim_units, scale, view, frame_extrema) {
                var sdim;
                if (dim != null) {
                    if (_this.model.screen)
                        sdim = dim;
                    else {
                        if (dim_units == 'data')
                            sdim = scale.compute(dim);
                        else
                            sdim = view.compute(dim);
                    }
                } else
                    sdim = frame_extrema;
                return sdim;
            };
            var sleft = _calc_dim(this.model.left, this.model.left_units, xscale, frame.xview, frame._left.value);
            var sright = _calc_dim(this.model.right, this.model.right_units, xscale, frame.xview, frame._right.value);
            var stop = _calc_dim(this.model.top, this.model.top_units, yscale, frame.yview, frame._top.value);
            var sbottom = _calc_dim(this.model.bottom, this.model.bottom_units, yscale, frame.yview, frame._bottom.value);
            var draw = this.model.render_mode == 'css' ? this._css_box.bind(this) : this._canvas_box.bind(this);
            draw(sleft, sright, sbottom, stop);
        };
        BoxAnnotationView.prototype._css_box = function (sleft, sright, sbottom, stop) {
            var sw = Math.abs(sright - sleft);
            var sh = Math.abs(sbottom - stop);
            this.el.style.left = sleft + 'px';
            this.el.style.width = sw + 'px';
            this.el.style.top = stop + 'px';
            this.el.style.height = sh + 'px';
            this.el.style.borderWidth = this.model.properties.line_width.value() + 'px';
            this.el.style.borderColor = this.model.properties.line_color.value();
            this.el.style.backgroundColor = this.model.properties.fill_color.value();
            this.el.style.opacity = this.model.properties.fill_alpha.value();
            // try our best to honor line dashing in some way, if we can
            var ld = this.model.properties.line_dash.value().length < 2 ? 'solid' : 'dashed';
            this.el.style.borderStyle = ld;
            dom_1.show(this.el);
        };
        BoxAnnotationView.prototype._canvas_box = function (sleft, sright, sbottom, stop) {
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            ctx.beginPath();
            ctx.rect(sleft, stop, sright - sleft, sbottom - stop);
            this.visuals.fill.set_value(ctx);
            ctx.fill();
            this.visuals.line.set_value(ctx);
            ctx.stroke();
            ctx.restore();
        };
        return BoxAnnotationView;
    }(annotation_1.AnnotationView);
    exports.BoxAnnotationView = BoxAnnotationView;
    var BoxAnnotation = function (_super) {
        tslib_1.__extends(BoxAnnotation, _super);
        function BoxAnnotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        BoxAnnotation.initClass = function () {
            this.prototype.type = 'BoxAnnotation';
            this.prototype.default_view = BoxAnnotationView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                render_mode: [
                    p.RenderMode,
                    'canvas'
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ],
                top: [
                    p.Number,
                    null
                ],
                top_units: [
                    p.SpatialUnits,
                    'data'
                ],
                bottom: [
                    p.Number,
                    null
                ],
                bottom_units: [
                    p.SpatialUnits,
                    'data'
                ],
                left: [
                    p.Number,
                    null
                ],
                left_units: [
                    p.SpatialUnits,
                    'data'
                ],
                right: [
                    p.Number,
                    null
                ],
                right_units: [
                    p.SpatialUnits,
                    'data'
                ]
            });
            this.internal({
                screen: [
                    p.Boolean,
                    false
                ]
            });
            this.override({
                fill_color: '#fff9ba',
                fill_alpha: 0.4,
                line_color: '#cccccc',
                line_alpha: 0.3
            });
        };
        BoxAnnotation.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.data_update = new signaling_1.Signal0(this, 'data_update');
        };
        BoxAnnotation.prototype.update = function (_a) {
            var left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
            this.setv({
                left: left,
                right: right,
                top: top,
                bottom: bottom,
                screen: true
            }, { silent: true });
            this.data_update.emit();
        };
        return BoxAnnotation;
    }(annotation_1.Annotation);
    exports.BoxAnnotation = BoxAnnotation;
    BoxAnnotation.initClass();    
},
/*models/annotations/color_bar*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var annotation_1 = require(54    /* ./annotation */);
    var basic_ticker_1 = require(191    /* ../tickers/basic_ticker */);
    var basic_tick_formatter_1 = require(96    /* ../formatters/basic_tick_formatter */);
    var linear_color_mapper_1 = require(154    /* ../mappers/linear_color_mapper */);
    var linear_scale_1 = require(176    /* ../scales/linear_scale */);
    var log_scale_1 = require(177    /* ../scales/log_scale */);
    var range1d_1 = require(168    /* ../ranges/range1d */);
    var p = require(15    /* core/properties */);
    var text_util = require(41    /* core/util/text */);
    var array_1 = require(21    /* core/util/array */);
    var arrayable_1 = require(22    /* core/util/arrayable */);
    var object_1 = require(32    /* core/util/object */);
    var types_1 = require(44    /* core/util/types */);
    var SHORT_DIM = 25;
    var LONG_DIM_MIN_SCALAR = 0.3;
    var LONG_DIM_MAX_SCALAR = 0.8;
    var ColorBarView = function (_super) {
        tslib_1.__extends(ColorBarView, _super);
        function ColorBarView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ColorBarView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this._set_canvas_image();
        };
        ColorBarView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.properties.visible.change, function () {
                return _this.plot_view.request_render();
            });
            this.connect(this.model.ticker.change, function () {
                return _this.plot_view.request_render();
            });
            this.connect(this.model.formatter.change, function () {
                return _this.plot_view.request_render();
            });
            if (this.model.color_mapper != null) {
                this.connect(this.model.color_mapper.change, function () {
                    _this._set_canvas_image();
                    _this.plot_view.request_render();
                });
            }
        };
        ColorBarView.prototype._get_size = function () {
            if (this.model.color_mapper == null)
                return 0;
            var bbox = this.compute_legend_dimensions();
            var side = this.model.panel.side;
            switch (side) {
            case 'above':
            case 'below':
                return bbox.height;
            case 'left':
            case 'right':
                return bbox.width;
            default:
                throw new Error('unreachable code');
            }
        };
        ColorBarView.prototype._set_canvas_image = function () {
            if (this.model.color_mapper == null)
                return;
            var palette = this.model.color_mapper.palette;
            if (this.model.orientation == 'vertical')
                palette = array_1.reversed(palette);
            var w, h;
            switch (this.model.orientation) {
            case 'vertical': {
                    _a = [
                        1,
                        palette.length
                    ], w = _a[0], h = _a[1];
                    break;
                }
            case 'horizontal': {
                    _b = [
                        palette.length,
                        1
                    ], w = _b[0], h = _b[1];
                    break;
                }
            default:
                throw new Error('unreachable code');
            }
            var canvas = document.createElement('canvas');
            canvas.width = w;
            canvas.height = h;
            var image_ctx = canvas.getContext('2d');
            var image_data = image_ctx.getImageData(0, 0, w, h);
            // We always want to draw the entire palette linearly, so we create a new
            // LinearColorMapper instance and map a monotonic range of values with
            // length = palette.length to get each palette color in order.
            var cmap = new linear_color_mapper_1.LinearColorMapper({ palette: palette }).rgba_mapper;
            var buf8 = cmap.v_compute(array_1.range(0, palette.length));
            image_data.data.set(buf8);
            image_ctx.putImageData(image_data, 0, 0);
            this.image = canvas;
            var _a, _b;
        };
        ColorBarView.prototype.compute_legend_dimensions = function () {
            var image_dimensions = this.model._computed_image_dimensions();
            var _a = [
                    image_dimensions.height,
                    image_dimensions.width
                ], image_height = _a[0], image_width = _a[1];
            var label_extent = this._get_label_extent();
            var title_extent = this.model._title_extent();
            var tick_extent = this.model._tick_extent();
            var padding = this.model.padding;
            var legend_height, legend_width;
            switch (this.model.orientation) {
            case 'vertical':
                legend_height = image_height + title_extent + 2 * padding;
                legend_width = image_width + tick_extent + label_extent + 2 * padding;
                break;
            case 'horizontal':
                legend_height = image_height + title_extent + tick_extent + label_extent + 2 * padding;
                legend_width = image_width + 2 * padding;
                break;
            default:
                throw new Error('unreachable code');
            }
            return {
                width: legend_width,
                height: legend_height
            };
        };
        ColorBarView.prototype.compute_legend_location = function () {
            var legend_dimensions = this.compute_legend_dimensions();
            var _a = [
                    legend_dimensions.height,
                    legend_dimensions.width
                ], legend_height = _a[0], legend_width = _a[1];
            var legend_margin = this.model.margin;
            var panel = this.model.panel != null ? this.model.panel : this.plot_view.frame;
            var _b = panel.bbox.ranges, hr = _b[0], vr = _b[1];
            var location = this.model.location;
            var sx, sy;
            if (types_1.isString(location)) {
                switch (location) {
                case 'top_left':
                    sx = hr.start + legend_margin;
                    sy = vr.start + legend_margin;
                    break;
                case 'top_center':
                    sx = (hr.end + hr.start) / 2 - legend_width / 2;
                    sy = vr.start + legend_margin;
                    break;
                case 'top_right':
                    sx = hr.end - legend_margin - legend_width;
                    sy = vr.start + legend_margin;
                    break;
                case 'bottom_right':
                    sx = hr.end - legend_margin - legend_width;
                    sy = vr.end - legend_margin - legend_height;
                    break;
                case 'bottom_center':
                    sx = (hr.end + hr.start) / 2 - legend_width / 2;
                    sy = vr.end - legend_margin - legend_height;
                    break;
                case 'bottom_left':
                    sx = hr.start + legend_margin;
                    sy = vr.end - legend_margin - legend_height;
                    break;
                case 'center_left':
                    sx = hr.start + legend_margin;
                    sy = (vr.end + vr.start) / 2 - legend_height / 2;
                    break;
                case 'center':
                    sx = (hr.end + hr.start) / 2 - legend_width / 2;
                    sy = (vr.end + vr.start) / 2 - legend_height / 2;
                    break;
                case 'center_right':
                    sx = hr.end - legend_margin - legend_width;
                    sy = (vr.end + vr.start) / 2 - legend_height / 2;
                    break;
                default:
                    throw new Error('unreachable code');
                }
            } else if (types_1.isArray(location) && location.length == 2) {
                var vx = location[0], vy = location[1];
                sx = panel.xview.compute(vx);
                sy = panel.yview.compute(vy) - legend_height;
            } else
                throw new Error('unreachable code');
            return {
                sx: sx,
                sy: sy
            };
        };
        ColorBarView.prototype.render = function () {
            if (!this.model.visible || this.model.color_mapper == null)
                return;
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            var _a = this.compute_legend_location(), sx = _a.sx, sy = _a.sy;
            ctx.translate(sx, sy);
            this._draw_bbox(ctx);
            var image_offset = this._get_image_offset();
            ctx.translate(image_offset.x, image_offset.y);
            this._draw_image(ctx);
            if (this.model.color_mapper.low != null && this.model.color_mapper.high != null) {
                var tick_info = this.model.tick_info();
                this._draw_major_ticks(ctx, tick_info);
                this._draw_minor_ticks(ctx, tick_info);
                this._draw_major_labels(ctx, tick_info);
            }
            if (this.model.title)
                this._draw_title(ctx);
            ctx.restore();
        };
        ColorBarView.prototype._draw_bbox = function (ctx) {
            var bbox = this.compute_legend_dimensions();
            ctx.save();
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                ctx.fillRect(0, 0, bbox.width, bbox.height);
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.strokeRect(0, 0, bbox.width, bbox.height);
            }
            ctx.restore();
        };
        ColorBarView.prototype._draw_image = function (ctx) {
            var image = this.model._computed_image_dimensions();
            ctx.save();
            ctx.setImageSmoothingEnabled(false);
            ctx.globalAlpha = this.model.scale_alpha;
            ctx.drawImage(this.image, 0, 0, image.width, image.height);
            if (this.visuals.bar_line.doit) {
                this.visuals.bar_line.set_value(ctx);
                ctx.strokeRect(0, 0, image.width, image.height);
            }
            ctx.restore();
        };
        ColorBarView.prototype._draw_major_ticks = function (ctx, tick_info) {
            if (!this.visuals.major_tick_line.doit)
                return;
            var _a = this.model._normals(), nx = _a[0], ny = _a[1];
            var image = this.model._computed_image_dimensions();
            var _b = [
                    image.width * nx,
                    image.height * ny
                ], x_offset = _b[0], y_offset = _b[1];
            var _c = tick_info.coords.major, sx = _c[0], sy = _c[1];
            var tin = this.model.major_tick_in;
            var tout = this.model.major_tick_out;
            ctx.save();
            ctx.translate(x_offset, y_offset);
            this.visuals.major_tick_line.set_value(ctx);
            for (var i = 0, end = sx.length; i < end; i++) {
                ctx.beginPath();
                ctx.moveTo(Math.round(sx[i] + nx * tout), Math.round(sy[i] + ny * tout));
                ctx.lineTo(Math.round(sx[i] - nx * tin), Math.round(sy[i] - ny * tin));
                ctx.stroke();
            }
            ctx.restore();
        };
        ColorBarView.prototype._draw_minor_ticks = function (ctx, tick_info) {
            if (!this.visuals.minor_tick_line.doit)
                return;
            var _a = this.model._normals(), nx = _a[0], ny = _a[1];
            var image = this.model._computed_image_dimensions();
            var _b = [
                    image.width * nx,
                    image.height * ny
                ], x_offset = _b[0], y_offset = _b[1];
            var _c = tick_info.coords.minor, sx = _c[0], sy = _c[1];
            var tin = this.model.minor_tick_in;
            var tout = this.model.minor_tick_out;
            ctx.save();
            ctx.translate(x_offset, y_offset);
            this.visuals.minor_tick_line.set_value(ctx);
            for (var i = 0, end = sx.length; i < end; i++) {
                ctx.beginPath();
                ctx.moveTo(Math.round(sx[i] + nx * tout), Math.round(sy[i] + ny * tout));
                ctx.lineTo(Math.round(sx[i] - nx * tin), Math.round(sy[i] - ny * tin));
                ctx.stroke();
            }
            ctx.restore();
        };
        ColorBarView.prototype._draw_major_labels = function (ctx, tick_info) {
            if (!this.visuals.major_label_text.doit)
                return;
            var _a = this.model._normals(), nx = _a[0], ny = _a[1];
            var image = this.model._computed_image_dimensions();
            var _b = [
                    image.width * nx,
                    image.height * ny
                ], x_offset = _b[0], y_offset = _b[1];
            var standoff = this.model.label_standoff + this.model._tick_extent();
            var _c = [
                    standoff * nx,
                    standoff * ny
                ], x_standoff = _c[0], y_standoff = _c[1];
            var _d = tick_info.coords.major, sx = _d[0], sy = _d[1];
            var formatted_labels = tick_info.labels.major;
            this.visuals.major_label_text.set_value(ctx);
            ctx.save();
            ctx.translate(x_offset + x_standoff, y_offset + y_standoff);
            for (var i = 0, end = sx.length; i < end; i++) {
                ctx.fillText(formatted_labels[i], Math.round(sx[i] + nx * this.model.label_standoff), Math.round(sy[i] + ny * this.model.label_standoff));
            }
            ctx.restore();
        };
        ColorBarView.prototype._draw_title = function (ctx) {
            if (!this.visuals.title_text.doit)
                return;
            ctx.save();
            this.visuals.title_text.set_value(ctx);
            ctx.fillText(this.model.title, 0, -this.model.title_standoff);
            ctx.restore();
        };
        ColorBarView.prototype._get_label_extent = function () {
            var major_labels = this.model.tick_info().labels.major;
            var label_extent;
            if (this.model.color_mapper.low != null && this.model.color_mapper.high != null && !object_1.isEmpty(major_labels)) {
                var ctx_1 = this.plot_view.canvas_view.ctx;
                ctx_1.save();
                this.visuals.major_label_text.set_value(ctx_1);
                switch (this.model.orientation) {
                case 'vertical':
                    label_extent = array_1.max(major_labels.map(function (label) {
                        return ctx_1.measureText(label.toString()).width;
                    }));
                    break;
                case 'horizontal':
                    label_extent = text_util.get_text_height(this.visuals.major_label_text.font_value()).height;
                    break;
                default:
                    throw new Error('unreachable code');
                }
                label_extent += this.model.label_standoff;
                ctx_1.restore();
            } else
                label_extent = 0;
            return label_extent;
        };
        ColorBarView.prototype._get_image_offset = function () {
            // Returns image offset relative to legend bounding box
            var x = this.model.padding;
            var y = this.model.padding + this.model._title_extent();
            return {
                x: x,
                y: y
            };
        };
        return ColorBarView;
    }(annotation_1.AnnotationView);
    exports.ColorBarView = ColorBarView;
    var ColorBar = function (_super) {
        tslib_1.__extends(ColorBar, _super);
        function ColorBar(attrs) {
            return _super.call(this, attrs) || this;
        }
        ColorBar.initClass = function () {
            this.prototype.type = 'ColorBar';
            this.prototype.default_view = ColorBarView;
            this.mixins([
                'text:major_label_',
                'text:title_',
                'line:major_tick_',
                'line:minor_tick_',
                'line:border_',
                'line:bar_',
                'fill:background_'
            ]);
            this.define({
                location: [
                    p.Any,
                    'top_right'
                ],
                orientation: [
                    p.Orientation,
                    'vertical'
                ],
                title: [p.String],
                title_standoff: [
                    p.Number,
                    2
                ],
                width: [
                    p.Any,
                    'auto'
                ],
                height: [
                    p.Any,
                    'auto'
                ],
                scale_alpha: [
                    p.Number,
                    1
                ],
                ticker: [
                    p.Instance,
                    function () {
                        return new basic_ticker_1.BasicTicker();
                    }
                ],
                formatter: [
                    p.Instance,
                    function () {
                        return new basic_tick_formatter_1.BasicTickFormatter();
                    }
                ],
                major_label_overrides: [
                    p.Any,
                    {}
                ],
                color_mapper: [p.Instance],
                label_standoff: [
                    p.Number,
                    5
                ],
                margin: [
                    p.Number,
                    30
                ],
                padding: [
                    p.Number,
                    10
                ],
                major_tick_in: [
                    p.Number,
                    5
                ],
                major_tick_out: [
                    p.Number,
                    0
                ],
                minor_tick_in: [
                    p.Number,
                    0
                ],
                minor_tick_out: [
                    p.Number,
                    0
                ]
            });
            this.override({
                background_fill_color: '#ffffff',
                background_fill_alpha: 0.95,
                bar_line_color: null,
                border_line_color: null,
                major_label_text_align: 'center',
                major_label_text_baseline: 'middle',
                major_label_text_font_size: '8pt',
                major_tick_line_color: '#ffffff',
                minor_tick_line_color: null,
                title_text_font_size: '10pt',
                title_text_font_style: 'italic'
            });
        };
        ColorBar.prototype._normals = function () {
            return this.orientation == 'vertical' ? [
                1,
                0
            ] : [
                0,
                1
            ];
        };
        ColorBar.prototype._title_extent = function () {
            var font_value = this.title_text_font + ' ' + this.title_text_font_size + ' ' + this.title_text_font_style;
            var title_extent = this.title ? text_util.get_text_height(font_value).height + this.title_standoff : 0;
            return title_extent;
        };
        ColorBar.prototype._tick_extent = function () {
            if (this.color_mapper.low != null && this.color_mapper.high != null)
                return array_1.max([
                    this.major_tick_out,
                    this.minor_tick_out
                ]);
            else
                return 0;
        };
        ColorBar.prototype._computed_image_dimensions = function () {
            /*
        Heuristics to determine ColorBar image dimensions if set to "auto"
    
        Note: Returns the height/width values for the ColorBar's scale image, not
        the dimensions of the entire ColorBar.
    
        If the short dimension (the width of a vertical bar or height of a
        horizontal bar) is set to "auto", the resulting dimension will be set to
        25 px.
    
        For a ColorBar in a side panel with the long dimension (the height of a
        vertical bar or width of a horizontal bar) set to "auto", the
        resulting dimension will be as long as the adjacent frame edge, so that the
        bar "fits" to the plot.
    
        For a ColorBar in the plot frame with the long dimension set to "auto", the
        resulting dimension will be the greater of:
          * The length of the color palette * 25px
          * The parallel frame dimension * 0.30
            (i.e the frame height for a vertical ColorBar)
        But not greater than:
          * The parallel frame dimension * 0.80
        */
            var frame_height = this.plot.plot_canvas.frame._height.value;
            var frame_width = this.plot.plot_canvas.frame._width.value;
            var title_extent = this._title_extent();
            var height, width;
            switch (this.orientation) {
            case 'vertical': {
                    if (this.height == 'auto') {
                        if (this.panel != null)
                            height = frame_height - 2 * this.padding - title_extent;
                        else {
                            height = array_1.max([
                                this.color_mapper.palette.length * SHORT_DIM,
                                frame_height * LONG_DIM_MIN_SCALAR
                            ]);
                            height = array_1.min([
                                height,
                                frame_height * LONG_DIM_MAX_SCALAR - 2 * this.padding - title_extent
                            ]);
                        }
                    } else
                        height = this.height;
                    width = this.width == 'auto' ? SHORT_DIM : this.width;
                    break;
                }
            case 'horizontal': {
                    height = this.height == 'auto' ? SHORT_DIM : this.height;
                    if (this.width == 'auto') {
                        if (this.panel != null)
                            width = frame_width - 2 * this.padding;
                        else {
                            width = array_1.max([
                                this.color_mapper.palette.length * SHORT_DIM,
                                frame_width * LONG_DIM_MIN_SCALAR
                            ]);
                            width = array_1.min([
                                width,
                                frame_width * LONG_DIM_MAX_SCALAR - 2 * this.padding
                            ]);
                        }
                    } else
                        width = this.width;
                    break;
                }
            default:
                throw new Error('unreachable code');
            }
            return {
                width: width,
                height: height
            };
        };
        ColorBar.prototype._tick_coordinate_scale = function (scale_length) {
            /*
        Creates and returns a scale instance that maps the `color_mapper` range
        (low to high) to a screen space range equal to the length of the ColorBar's
        scale image. The scale is used to calculate the tick coordinates in screen
        coordinates for plotting purposes.
    
        Note: the type of color_mapper has to match the type of scale (i.e.
        a LinearColorMapper will require a corresponding LinearScale instance).
        */
            var ranges = {
                source_range: new range1d_1.Range1d({
                    start: this.color_mapper.low,
                    end: this.color_mapper.high
                }),
                target_range: new range1d_1.Range1d({
                    start: 0,
                    end: scale_length
                })
            };
            switch (this.color_mapper.type) {
            case 'LinearColorMapper':
                return new linear_scale_1.LinearScale(ranges);
            case 'LogColorMapper':
                return new log_scale_1.LogScale(ranges);
            default:
                throw new Error('unreachable code');
            }
        };
        ColorBar.prototype._format_major_labels = function (initial_labels, major_ticks) {
            // XXX: passing null as cross_loc probably means MercatorTickFormatters, etc
            // will not function properly in conjunction with colorbars
            var formatted_labels = this.formatter.doFormat(initial_labels, null);
            for (var i = 0, end = major_ticks.length; i < end; i++) {
                if (major_ticks[i] in this.major_label_overrides)
                    formatted_labels[i] = this.major_label_overrides[major_ticks[i]];
            }
            return formatted_labels;
        };
        ColorBar.prototype.tick_info = function () {
            var image_dimensions = this._computed_image_dimensions();
            var scale_length;
            switch (this.orientation) {
            case 'vertical': {
                    scale_length = image_dimensions.height;
                    break;
                }
            case 'horizontal': {
                    scale_length = image_dimensions.width;
                    break;
                }
            default:
                throw new Error('unreachable code');
            }
            var scale = this._tick_coordinate_scale(scale_length);
            var _a = this._normals(), i = _a[0], j = _a[1];
            var _b = [
                    this.color_mapper.low,
                    this.color_mapper.high
                ], start = _b[0], end = _b[1];
            // XXX: passing null as cross_loc probably means MercatorTickers, etc
            // will not function properly in conjunction with colorbars
            var ticks = this.ticker.get_ticks(start, end, null, null, this.ticker.desired_num_ticks);
            var majors = ticks.major;
            var minors = ticks.minor;
            var major_coords = [
                [],
                []
            ];
            var minor_coords = [
                [],
                []
            ];
            for (var ii = 0, _end = majors.length; ii < _end; ii++) {
                if (majors[ii] < start || majors[ii] > end)
                    continue;
                major_coords[i].push(majors[ii]);
                major_coords[j].push(0);
            }
            for (var ii = 0, _end = minors.length; ii < _end; ii++) {
                if (minors[ii] < start || minors[ii] > end)
                    continue;
                minor_coords[i].push(minors[ii]);
                minor_coords[j].push(0);
            }
            var labels = { major: this._format_major_labels(major_coords[i], majors) };
            var coords = {
                major: [
                    [],
                    []
                ],
                minor: [
                    [],
                    []
                ]
            };
            coords.major[i] = scale.v_compute(major_coords[i]);
            coords.minor[i] = scale.v_compute(minor_coords[i]);
            coords.major[j] = major_coords[j];
            coords.minor[j] = minor_coords[j];
            // Because we want the scale to be reversed
            if (this.orientation == 'vertical') {
                coords.major[i] = arrayable_1.map(coords.major[i], function (coord) {
                    return scale_length - coord;
                });
                coords.minor[i] = arrayable_1.map(coords.minor[i], function (coord) {
                    return scale_length - coord;
                });
            }
            return {
                coords: coords,
                labels: labels
            };
        };
        return ColorBar;
    }(annotation_1.Annotation);
    exports.ColorBar = ColorBar;
    ColorBar.initClass();    
},
/*models/annotations/index*/
function _(require, module, exports) {
    var annotation_1 = require(54    /* ./annotation */);
    exports.Annotation = annotation_1.Annotation;
    var arrow_1 = require(55    /* ./arrow */);
    exports.Arrow = arrow_1.Arrow;
    var arrow_head_1 = require(56    /* ./arrow_head */);
    exports.ArrowHead = arrow_head_1.ArrowHead;
    var arrow_head_2 = require(56    /* ./arrow_head */);
    exports.OpenHead = arrow_head_2.OpenHead;
    var arrow_head_3 = require(56    /* ./arrow_head */);
    exports.NormalHead = arrow_head_3.NormalHead;
    var arrow_head_4 = require(56    /* ./arrow_head */);
    exports.TeeHead = arrow_head_4.TeeHead;
    var arrow_head_5 = require(56    /* ./arrow_head */);
    exports.VeeHead = arrow_head_5.VeeHead;
    var band_1 = require(57    /* ./band */);
    exports.Band = band_1.Band;
    var box_annotation_1 = require(58    /* ./box_annotation */);
    exports.BoxAnnotation = box_annotation_1.BoxAnnotation;
    var color_bar_1 = require(59    /* ./color_bar */);
    exports.ColorBar = color_bar_1.ColorBar;
    var label_1 = require(61    /* ./label */);
    exports.Label = label_1.Label;
    var label_set_1 = require(62    /* ./label_set */);
    exports.LabelSet = label_set_1.LabelSet;
    var legend_1 = require(63    /* ./legend */);
    exports.Legend = legend_1.Legend;
    var legend_item_1 = require(64    /* ./legend_item */);
    exports.LegendItem = legend_item_1.LegendItem;
    var poly_annotation_1 = require(65    /* ./poly_annotation */);
    exports.PolyAnnotation = poly_annotation_1.PolyAnnotation;
    var span_1 = require(66    /* ./span */);
    exports.Span = span_1.Span;
    var text_annotation_1 = require(67    /* ./text_annotation */);
    exports.TextAnnotation = text_annotation_1.TextAnnotation;
    var title_1 = require(68    /* ./title */);
    exports.Title = title_1.Title;
    var toolbar_panel_1 = require(69    /* ./toolbar_panel */);
    exports.ToolbarPanel = toolbar_panel_1.ToolbarPanel;
    var tooltip_1 = require(70    /* ./tooltip */);
    exports.Tooltip = tooltip_1.Tooltip;
    var whisker_1 = require(71    /* ./whisker */);
    exports.Whisker = whisker_1.Whisker;    
},
/*models/annotations/label*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var text_annotation_1 = require(67    /* ./text_annotation */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var LabelView = function (_super) {
        tslib_1.__extends(LabelView, _super);
        function LabelView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LabelView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.visuals.warm_cache();
        };
        LabelView.prototype._get_size = function () {
            var ctx = this.plot_view.canvas_view.ctx;
            this.visuals.text.set_value(ctx);
            if (this.model.panel.is_horizontal) {
                var height = ctx.measureText(this.model.text).ascent;
                return height;
            } else {
                var width = ctx.measureText(this.model.text).width;
                return width;
            }
        };
        LabelView.prototype.render = function () {
            if (!this.model.visible && this.model.render_mode == 'css')
                dom_1.hide(this.el);
            if (!this.model.visible)
                return;
            // Here because AngleSpec does units tranform and label doesn't support specs
            var angle;
            switch (this.model.angle_units) {
            case 'rad': {
                    angle = -this.model.angle;
                    break;
                }
            case 'deg': {
                    angle = -this.model.angle * Math.PI / 180;
                    break;
                }
            default:
                throw new Error('unreachable code');
            }
            var panel = this.model.panel != null ? this.model.panel : this.plot_view.frame;
            var xscale = this.plot_view.frame.xscales[this.model.x_range_name];
            var yscale = this.plot_view.frame.yscales[this.model.y_range_name];
            var sx = this.model.x_units == 'data' ? xscale.compute(this.model.x) : panel.xview.compute(this.model.x);
            var sy = this.model.y_units == 'data' ? yscale.compute(this.model.y) : panel.yview.compute(this.model.y);
            sx += this.model.x_offset;
            sy -= this.model.y_offset;
            var draw = this.model.render_mode == 'canvas' ? this._canvas_text.bind(this) : this._css_text.bind(this);
            draw(this.plot_view.canvas_view.ctx, this.model.text, sx, sy, angle);
        };
        return LabelView;
    }(text_annotation_1.TextAnnotationView);
    exports.LabelView = LabelView;
    var Label = function (_super) {
        tslib_1.__extends(Label, _super);
        function Label(attrs) {
            return _super.call(this, attrs) || this;
        }
        Label.initClass = function () {
            this.prototype.type = 'Label';
            this.prototype.default_view = LabelView;
            this.mixins([
                'text',
                'line:border_',
                'fill:background_'
            ]);
            this.define({
                x: [p.Number],
                x_units: [
                    p.SpatialUnits,
                    'data'
                ],
                y: [p.Number],
                y_units: [
                    p.SpatialUnits,
                    'data'
                ],
                text: [p.String],
                angle: [
                    p.Angle,
                    0
                ],
                angle_units: [
                    p.AngleUnits,
                    'rad'
                ],
                x_offset: [
                    p.Number,
                    0
                ],
                y_offset: [
                    p.Number,
                    0
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
            this.override({
                background_fill_color: null,
                border_line_color: null
            });
        };
        return Label;
    }(text_annotation_1.TextAnnotation);
    exports.Label = Label;
    Label.initClass();    
},
/*models/annotations/label_set*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var text_annotation_1 = require(67    /* ./text_annotation */);
    var column_data_source_1 = require(184    /* ../sources/column_data_source */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var LabelSetView = function (_super) {
        tslib_1.__extends(LabelSetView, _super);
        function LabelSetView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LabelSetView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.set_data(this.model.source);
            if (this.model.render_mode == 'css') {
                for (var i = 0, end = this._text.length; i < end; i++) {
                    var el = dom_1.div({
                        class: 'bk-annotation-child',
                        style: { display: 'none' }
                    });
                    this.el.appendChild(el);
                }
            }
        };
        LabelSetView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            if (this.model.render_mode == 'css') {
                // dispatch CSS update immediately
                this.connect(this.model.change, function () {
                    _this.set_data(_this.model.source);
                    _this.render();
                });
                this.connect(this.model.source.streaming, function () {
                    _this.set_data(_this.model.source);
                    _this.render();
                });
                this.connect(this.model.source.patching, function () {
                    _this.set_data(_this.model.source);
                    _this.render();
                });
                this.connect(this.model.source.change, function () {
                    _this.set_data(_this.model.source);
                    _this.render();
                });
            } else {
                this.connect(this.model.change, function () {
                    _this.set_data(_this.model.source);
                    _this.plot_view.request_render();
                });
                this.connect(this.model.source.streaming, function () {
                    _this.set_data(_this.model.source);
                    _this.plot_view.request_render();
                });
                this.connect(this.model.source.patching, function () {
                    _this.set_data(_this.model.source);
                    _this.plot_view.request_render();
                });
                this.connect(this.model.source.change, function () {
                    _this.set_data(_this.model.source);
                    _this.plot_view.request_render();
                });
            }
        };
        LabelSetView.prototype.set_data = function (source) {
            _super.prototype.set_data.call(this, source);
            this.visuals.warm_cache(source);
        };
        LabelSetView.prototype._map_data = function () {
            var xscale = this.plot_view.frame.xscales[this.model.x_range_name];
            var yscale = this.plot_view.frame.yscales[this.model.y_range_name];
            var panel = this.model.panel != null ? this.model.panel : this.plot_view.frame;
            var sx = this.model.x_units == 'data' ? xscale.v_compute(this._x) : panel.xview.v_compute(this._x);
            var sy = this.model.y_units == 'data' ? yscale.v_compute(this._y) : panel.yview.v_compute(this._y);
            return [
                sx,
                sy
            ];
        };
        LabelSetView.prototype.render = function () {
            if (!this.model.visible && this.model.render_mode == 'css')
                dom_1.hide(this.el);
            if (!this.model.visible)
                return;
            var draw = this.model.render_mode == 'canvas' ? this._v_canvas_text.bind(this) : this._v_css_text.bind(this);
            var ctx = this.plot_view.canvas_view.ctx;
            var _a = this._map_data(), sx = _a[0], sy = _a[1];
            for (var i = 0, end = this._text.length; i < end; i++) {
                draw(ctx, i, this._text[i], sx[i] + this._x_offset[i], sy[i] - this._y_offset[i], this._angle[i]);
            }
        };
        LabelSetView.prototype._get_size = function () {
            var ctx = this.plot_view.canvas_view.ctx;
            this.visuals.text.set_value(ctx);
            switch (this.model.panel.side) {
            case 'above':
            case 'below': {
                    var height = ctx.measureText(this._text[0]).ascent;
                    return height;
                }
            case 'left':
            case 'right': {
                    var width = ctx.measureText(this._text[0]).width;
                    return width;
                }
            default:
                throw new Error('unreachable code');
            }
        };
        LabelSetView.prototype._v_canvas_text = function (ctx, i, text, sx, sy, angle) {
            this.visuals.text.set_vectorize(ctx, i);
            var bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            ctx.save();
            ctx.beginPath();
            ctx.translate(sx, sy);
            ctx.rotate(angle);
            ctx.rect(bbox_dims[0], bbox_dims[1], bbox_dims[2], bbox_dims[3]);
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_vectorize(ctx, i);
                ctx.fill();
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_vectorize(ctx, i);
                ctx.stroke();
            }
            if (this.visuals.text.doit) {
                this.visuals.text.set_vectorize(ctx, i);
                ctx.fillText(text, 0, 0);
            }
            ctx.restore();
        };
        LabelSetView.prototype._v_css_text = function (ctx, i, text, sx, sy, angle) {
            var el = this.el.children[i];
            el.textContent = text;
            this.visuals.text.set_vectorize(ctx, i);
            var bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            // attempt to support vector-style ("8 4 8") line dashing for css mode
            var ld = this.visuals.border_line.line_dash.value();
            var line_dash = ld.length < 2 ? 'solid' : 'dashed';
            this.visuals.border_line.set_vectorize(ctx, i);
            this.visuals.background_fill.set_vectorize(ctx, i);
            el.style.position = 'absolute';
            el.style.left = sx + bbox_dims[0] + 'px';
            el.style.top = sy + bbox_dims[1] + 'px';
            el.style.color = '' + this.visuals.text.text_color.value();
            el.style.opacity = '' + this.visuals.text.text_alpha.value();
            el.style.font = '' + this.visuals.text.font_value();
            el.style.lineHeight = 'normal';
            // needed to prevent ipynb css override
            if (angle) {
                el.style.transform = 'rotate(' + angle + 'rad)';
            }
            if (this.visuals.background_fill.doit) {
                el.style.backgroundColor = '' + this.visuals.background_fill.color_value();
            }
            if (this.visuals.border_line.doit) {
                el.style.borderStyle = '' + line_dash;
                el.style.borderWidth = this.visuals.border_line.line_width.value() + 'px';
                el.style.borderColor = '' + this.visuals.border_line.color_value();
            }
            dom_1.show(el);
        };
        return LabelSetView;
    }(text_annotation_1.TextAnnotationView);
    exports.LabelSetView = LabelSetView;
    var LabelSet = function (_super) {
        tslib_1.__extends(LabelSet, _super);
        function LabelSet(attrs) {
            return _super.call(this, attrs) || this;
        }
        LabelSet.initClass = function () {
            this.prototype.type = 'LabelSet';
            this.prototype.default_view = LabelSetView;
            this.mixins([
                'text',
                'line:border_',
                'fill:background_'
            ]);
            this.define({
                x: [p.NumberSpec],
                y: [p.NumberSpec],
                x_units: [
                    p.SpatialUnits,
                    'data'
                ],
                y_units: [
                    p.SpatialUnits,
                    'data'
                ],
                text: [
                    p.StringSpec,
                    { field: 'text' }
                ],
                angle: [
                    p.AngleSpec,
                    0
                ],
                x_offset: [
                    p.NumberSpec,
                    { value: 0 }
                ],
                y_offset: [
                    p.NumberSpec,
                    { value: 0 }
                ],
                source: [
                    p.Instance,
                    function () {
                        return new column_data_source_1.ColumnDataSource();
                    }
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
            this.override({
                background_fill_color: null,
                border_line_color: null
            });
        };
        return LabelSet;
    }(text_annotation_1.TextAnnotation);
    exports.LabelSet = LabelSet;
    LabelSet.initClass();    
},
/*models/annotations/legend*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var annotation_1 = require(54    /* ./annotation */);
    var p = require(15    /* core/properties */);
    var text_1 = require(41    /* core/util/text */);
    var bbox_1 = require(24    /* core/util/bbox */);
    var array_1 = require(21    /* core/util/array */);
    var object_1 = require(32    /* core/util/object */);
    var types_1 = require(44    /* core/util/types */);
    var LegendView = function (_super) {
        tslib_1.__extends(LegendView, _super);
        function LegendView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(LegendView.prototype, 'cursor', {
            get: function () {
                return this.model.click_policy == 'none' ? null : 'pointer';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(LegendView.prototype, 'legend_padding', {
            get: function () {
                return this.visuals.border_line.line_color.value() != null ? this.model.padding : 0;
            },
            enumerable: true,
            configurable: true
        });
        LegendView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.properties.visible.change, function () {
                return _this.plot_view.request_render();
            });
        };
        LegendView.prototype.compute_legend_bbox = function () {
            var legend_names = this.model.get_legend_names();
            var _a = this.model, glyph_height = _a.glyph_height, glyph_width = _a.glyph_width;
            var _b = this.model, label_height = _b.label_height, label_width = _b.label_width;
            this.max_label_height = array_1.max([
                text_1.get_text_height(this.visuals.label_text.font_value()).height,
                label_height,
                glyph_height
            ]);
            // this is to measure text properties
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            this.visuals.label_text.set_value(ctx);
            this.text_widths = {};
            for (var _i = 0, legend_names_1 = legend_names; _i < legend_names_1.length; _i++) {
                var name_1 = legend_names_1[_i];
                this.text_widths[name_1] = array_1.max([
                    ctx.measureText(name_1).width,
                    label_width
                ]);
            }
            ctx.restore();
            var max_label_width = Math.max(array_1.max(object_1.values(this.text_widths)), 0);
            var legend_margin = this.model.margin;
            var legend_padding = this.legend_padding;
            var legend_spacing = this.model.spacing;
            var label_standoff = this.model.label_standoff;
            var legend_height, legend_width;
            if (this.model.orientation == 'vertical') {
                legend_height = legend_names.length * this.max_label_height + Math.max(legend_names.length - 1, 0) * legend_spacing + 2 * legend_padding;
                legend_width = max_label_width + glyph_width + label_standoff + 2 * legend_padding;
            } else {
                legend_width = 2 * legend_padding + Math.max(legend_names.length - 1, 0) * legend_spacing;
                for (var name_2 in this.text_widths) {
                    var width = this.text_widths[name_2];
                    legend_width += array_1.max([
                        width,
                        label_width
                    ]) + glyph_width + label_standoff;
                }
                legend_height = this.max_label_height + 2 * legend_padding;
            }
            var panel = this.model.panel != null ? this.model.panel : this.plot_view.frame;
            var _c = panel.bbox.ranges, hr = _c[0], vr = _c[1];
            var location = this.model.location;
            var sx, sy;
            if (types_1.isString(location)) {
                switch (location) {
                case 'top_left':
                    sx = hr.start + legend_margin;
                    sy = vr.start + legend_margin;
                    break;
                case 'top_center':
                    sx = (hr.end + hr.start) / 2 - legend_width / 2;
                    sy = vr.start + legend_margin;
                    break;
                case 'top_right':
                    sx = hr.end - legend_margin - legend_width;
                    sy = vr.start + legend_margin;
                    break;
                case 'bottom_right':
                    sx = hr.end - legend_margin - legend_width;
                    sy = vr.end - legend_margin - legend_height;
                    break;
                case 'bottom_center':
                    sx = (hr.end + hr.start) / 2 - legend_width / 2;
                    sy = vr.end - legend_margin - legend_height;
                    break;
                case 'bottom_left':
                    sx = hr.start + legend_margin;
                    sy = vr.end - legend_margin - legend_height;
                    break;
                case 'center_left':
                    sx = hr.start + legend_margin;
                    sy = (vr.end + vr.start) / 2 - legend_height / 2;
                    break;
                case 'center':
                    sx = (hr.end + hr.start) / 2 - legend_width / 2;
                    sy = (vr.end + vr.start) / 2 - legend_height / 2;
                    break;
                case 'center_right':
                    sx = hr.end - legend_margin - legend_width;
                    sy = (vr.end + vr.start) / 2 - legend_height / 2;
                    break;
                default:
                    throw new Error('unreachable code');
                }
            } else if (types_1.isArray(location) && location.length == 2) {
                var vx = location[0], vy = location[1];
                sx = panel.xview.compute(vx);
                sy = panel.yview.compute(vy) - legend_height;
            } else
                throw new Error('unreachable code');
            return {
                x: sx,
                y: sy,
                width: legend_width,
                height: legend_height
            };
        };
        LegendView.prototype.bbox = function () {
            var _a = this.compute_legend_bbox(), x = _a.x, y = _a.y, width = _a.width, height = _a.height;
            return new bbox_1.BBox({
                x: x,
                y: y,
                width: width,
                height: height
            });
        };
        LegendView.prototype.on_hit = function (sx, sy) {
            var yoffset;
            var glyph_width = this.model.glyph_width;
            var legend_padding = this.legend_padding;
            var legend_spacing = this.model.spacing;
            var label_standoff = this.model.label_standoff;
            var xoffset = yoffset = legend_padding;
            var legend_bbox = this.compute_legend_bbox();
            var vertical = this.model.orientation == 'vertical';
            for (var _i = 0, _a = this.model.items; _i < _a.length; _i++) {
                var item = _a[_i];
                var labels = item.get_labels_list_from_label_prop();
                for (var _b = 0, labels_1 = labels; _b < labels_1.length; _b++) {
                    var label = labels_1[_b];
                    var x1 = legend_bbox.x + xoffset;
                    var y1 = legend_bbox.y + yoffset;
                    var w = void 0, h = void 0;
                    if (vertical)
                        _c = [
                            legend_bbox.width - 2 * legend_padding,
                            this.max_label_height
                        ], w = _c[0], h = _c[1];
                    else
                        _d = [
                            this.text_widths[label] + glyph_width + label_standoff,
                            this.max_label_height
                        ], w = _d[0], h = _d[1];
                    var bbox = new bbox_1.BBox({
                        x: x1,
                        y: y1,
                        width: w,
                        height: h
                    });
                    if (bbox.contains(sx, sy)) {
                        switch (this.model.click_policy) {
                        case 'hide': {
                                for (var _e = 0, _f = item.renderers; _e < _f.length; _e++) {
                                    var r = _f[_e];
                                    r.visible = !r.visible;
                                }
                                break;
                            }
                        case 'mute': {
                                for (var _g = 0, _h = item.renderers; _g < _h.length; _g++) {
                                    var r = _h[_g];
                                    r.muted = !r.muted;
                                }
                                break;
                            }
                        }
                        return true;
                    }
                    if (vertical)
                        yoffset += this.max_label_height + legend_spacing;
                    else
                        xoffset += this.text_widths[label] + glyph_width + label_standoff + legend_spacing;
                }
            }
            return false;
            var _c, _d;
        };
        LegendView.prototype.render = function () {
            if (!this.model.visible)
                return;
            if (this.model.items.length == 0)
                return;
            var ctx = this.plot_view.canvas_view.ctx;
            var bbox = this.compute_legend_bbox();
            ctx.save();
            this._draw_legend_box(ctx, bbox);
            this._draw_legend_items(ctx, bbox);
            ctx.restore();
        };
        LegendView.prototype._draw_legend_box = function (ctx, bbox) {
            ctx.beginPath();
            ctx.rect(bbox.x, bbox.y, bbox.width, bbox.height);
            this.visuals.background_fill.set_value(ctx);
            ctx.fill();
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.stroke();
            }
        };
        LegendView.prototype._draw_legend_items = function (ctx, bbox) {
            var _this = this;
            var _a = this.model, glyph_width = _a.glyph_width, glyph_height = _a.glyph_height;
            var legend_padding = this.legend_padding;
            var legend_spacing = this.model.spacing;
            var label_standoff = this.model.label_standoff;
            var xoffset = legend_padding;
            var yoffset = legend_padding;
            var vertical = this.model.orientation == 'vertical';
            var _loop_1 = function (item) {
                var labels = item.get_labels_list_from_label_prop();
                var field = item.get_field_from_label_prop();
                if (labels.length == 0)
                    return 'continue';
                var active = function () {
                    switch (_this.model.click_policy) {
                    case 'none':
                        return true;
                    case 'hide':
                        return array_1.all(item.renderers, function (r) {
                            return r.visible;
                        });
                    case 'mute':
                        return array_1.all(item.renderers, function (r) {
                            return !r.muted;
                        });
                    }
                }();
                for (var _i = 0, labels_2 = labels; _i < labels_2.length; _i++) {
                    var label = labels_2[_i];
                    var x1 = bbox.x + xoffset;
                    var y1 = bbox.y + yoffset;
                    var x2 = x1 + glyph_width;
                    var y2 = y1 + glyph_height;
                    if (vertical)
                        yoffset += this_1.max_label_height + legend_spacing;
                    else
                        xoffset += this_1.text_widths[label] + glyph_width + label_standoff + legend_spacing;
                    this_1.visuals.label_text.set_value(ctx);
                    ctx.fillText(label, x2 + label_standoff, y1 + this_1.max_label_height / 2);
                    for (var _a = 0, _b = item.renderers; _a < _b.length; _a++) {
                        var r = _b[_a];
                        var view = this_1.plot_view.renderer_views[r.id];
                        view.draw_legend(ctx, x1, x2, y1, y2, field, label);
                    }
                    if (!active) {
                        var w = void 0, h = void 0;
                        if (vertical)
                            _c = [
                                bbox.width - 2 * legend_padding,
                                this_1.max_label_height
                            ], w = _c[0], h = _c[1];
                        else
                            _d = [
                                this_1.text_widths[label] + glyph_width + label_standoff,
                                this_1.max_label_height
                            ], w = _d[0], h = _d[1];
                        ctx.beginPath();
                        ctx.rect(x1, y1, w, h);
                        this_1.visuals.inactive_fill.set_value(ctx);
                        ctx.fill();
                    }
                }
                var _c, _d;
            };
            var this_1 = this;
            for (var _i = 0, _b = this.model.items; _i < _b.length; _i++) {
                var item = _b[_i];
                _loop_1(item);
            }
        };
        LegendView.prototype._get_size = function () {
            var bbox = this.compute_legend_bbox();
            switch (this.model.panel.side) {
            case 'above':
            case 'below':
                return bbox.height + 2 * this.model.margin;
            case 'left':
            case 'right':
                return bbox.width + 2 * this.model.margin;
            }
        };
        return LegendView;
    }(annotation_1.AnnotationView);
    exports.LegendView = LegendView;
    var Legend = function (_super) {
        tslib_1.__extends(Legend, _super);
        function Legend(attrs) {
            return _super.call(this, attrs) || this;
        }
        Legend.initClass = function () {
            this.prototype.type = 'Legend';
            this.prototype.default_view = LegendView;
            this.mixins([
                'text:label_',
                'fill:inactive_',
                'line:border_',
                'fill:background_'
            ]);
            this.define({
                orientation: [
                    p.Orientation,
                    'vertical'
                ],
                location: [
                    p.Any,
                    'top_right'
                ],
                label_standoff: [
                    p.Number,
                    5
                ],
                glyph_height: [
                    p.Number,
                    20
                ],
                glyph_width: [
                    p.Number,
                    20
                ],
                label_height: [
                    p.Number,
                    20
                ],
                label_width: [
                    p.Number,
                    20
                ],
                margin: [
                    p.Number,
                    10
                ],
                padding: [
                    p.Number,
                    10
                ],
                spacing: [
                    p.Number,
                    3
                ],
                items: [
                    p.Array,
                    []
                ],
                click_policy: [
                    p.Any,
                    'none'
                ]
            });
            this.override({
                border_line_color: '#e5e5e5',
                border_line_alpha: 0.5,
                border_line_width: 1,
                background_fill_color: '#ffffff',
                background_fill_alpha: 0.95,
                inactive_fill_color: 'white',
                inactive_fill_alpha: 0.7,
                label_text_font_size: '10pt',
                label_text_baseline: 'middle'
            });
        };
        Legend.prototype.get_legend_names = function () {
            var legend_names = [];
            for (var _i = 0, _a = this.items; _i < _a.length; _i++) {
                var item = _a[_i];
                var labels = item.get_labels_list_from_label_prop();
                legend_names.push.apply(legend_names, labels);
            }
            return legend_names;
        };
        return Legend;
    }(annotation_1.Annotation);
    exports.Legend = Legend;
    Legend.initClass();    
},
/*models/annotations/legend_item*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var model_1 = require(53    /* ../../model */);
    var columnar_data_source_1 = require(185    /* ../sources/columnar_data_source */);
    var vectorization_1 = require(47    /* core/vectorization */);
    var p = require(15    /* core/properties */);
    var logging_1 = require(14    /* core/logging */);
    var array_1 = require(21    /* core/util/array */);
    var LegendItem = function (_super) {
        tslib_1.__extends(LegendItem, _super);
        function LegendItem(attrs) {
            return _super.call(this, attrs) || this;
        }
        LegendItem.initClass = function () {
            this.prototype.type = 'LegendItem';
            this.define({
                label: [
                    p.StringSpec,
                    null
                ],
                renderers: [
                    p.Array,
                    []
                ]
            });
        };
        LegendItem.prototype._check_data_sources_on_renderers = function () {
            var field = this.get_field_from_label_prop();
            if (field != null) {
                if (this.renderers.length < 1) {
                    return false;
                }
                var source = this.renderers[0].data_source;
                if (source != null) {
                    for (var _i = 0, _a = this.renderers; _i < _a.length; _i++) {
                        var r = _a[_i];
                        if (r.data_source != source) {
                            return false;
                        }
                    }
                }
            }
            return true;
        };
        LegendItem.prototype._check_field_label_on_data_source = function () {
            var field = this.get_field_from_label_prop();
            if (field != null) {
                if (this.renderers.length < 1) {
                    return false;
                }
                var source = this.renderers[0].data_source;
                if (source != null && !array_1.includes(source.columns(), field)) {
                    return false;
                }
            }
            return true;
        };
        LegendItem.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            // Validate data_sources match
            var data_source_validation = this._check_data_sources_on_renderers();
            if (!data_source_validation)
                logging_1.logger.error('Non matching data sources on legend item renderers');
            // Validate label in data_source
            var field_validation = this._check_field_label_on_data_source();
            if (!field_validation)
                logging_1.logger.error('Bad column name on label: ' + this.label);
        };
        LegendItem.prototype.get_field_from_label_prop = function () {
            var label = this.label;
            return vectorization_1.isField(label) ? label.field : null;
        };
        LegendItem.prototype.get_labels_list_from_label_prop = function () {
            // Always return a list of the labels
            if (vectorization_1.isValue(this.label))
                return [this.label.value];
            var field = this.get_field_from_label_prop();
            if (field != null) {
                var source = void 0;
                if (this.renderers[0] && this.renderers[0].data_source != null)
                    source = this.renderers[0].data_source;
                else
                    return ['No source found'];
                if (source instanceof columnar_data_source_1.ColumnarDataSource) {
                    var data = source.get_column(field);
                    if (data != null)
                        return array_1.uniq(Array.from(data));
                    else
                        return ['Invalid field'];
                }
            }
            return [];
        };
        return LegendItem;
    }(model_1.Model);
    exports.LegendItem = LegendItem;
    LegendItem.initClass();    
},
/*models/annotations/poly_annotation*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var annotation_1 = require(54    /* ./annotation */);
    var signaling_1 = require(19    /* core/signaling */);
    var p = require(15    /* core/properties */);
    var PolyAnnotationView = function (_super) {
        tslib_1.__extends(PolyAnnotationView, _super);
        function PolyAnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PolyAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            // need to respond to either normal BB change events or silent
            // "data only updates" that tools might want to use
            this.connect(this.model.change, function () {
                return _this.plot_view.request_render();
            });
            this.connect(this.model.data_update, function () {
                return _this.plot_view.request_render();
            });
        };
        PolyAnnotationView.prototype.render = function () {
            if (!this.model.visible)
                return;
            var _a = this.model, xs = _a.xs, ys = _a.ys;
            if (xs.length != ys.length)
                return;
            if (xs.length < 3 || ys.length < 3)
                return;
            var frame = this.plot_view.frame;
            var ctx = this.plot_view.canvas_view.ctx;
            for (var i = 0, end = xs.length; i < end; i++) {
                var sx = void 0;
                if (this.model.xs_units == 'screen')
                    sx = this.model.screen ? xs[i] : frame.xview.compute(xs[i]);
                else
                    throw new Error('not implemented');
                var sy = void 0;
                if (this.model.ys_units == 'screen')
                    sy = this.model.screen ? ys[i] : frame.yview.compute(ys[i]);
                else
                    throw new Error('not implemented');
                if (i == 0) {
                    ctx.beginPath();
                    ctx.moveTo(sx, sy);
                } else {
                    ctx.lineTo(sx, sy);
                }
            }
            ctx.closePath();
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                ctx.fill();
            }
        };
        return PolyAnnotationView;
    }(annotation_1.AnnotationView);
    exports.PolyAnnotationView = PolyAnnotationView;
    var PolyAnnotation = function (_super) {
        tslib_1.__extends(PolyAnnotation, _super);
        function PolyAnnotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        PolyAnnotation.initClass = function () {
            this.prototype.type = 'PolyAnnotation';
            this.prototype.default_view = PolyAnnotationView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                xs: [
                    p.Array,
                    []
                ],
                xs_units: [
                    p.SpatialUnits,
                    'data'
                ],
                ys: [
                    p.Array,
                    []
                ],
                ys_units: [
                    p.SpatialUnits,
                    'data'
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
            this.internal({
                screen: [
                    p.Boolean,
                    false
                ]
            });
            this.override({
                fill_color: '#fff9ba',
                fill_alpha: 0.4,
                line_color: '#cccccc',
                line_alpha: 0.3
            });
        };
        PolyAnnotation.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.data_update = new signaling_1.Signal0(this, 'data_update');
        };
        PolyAnnotation.prototype.update = function (_a) {
            var xs = _a.xs, ys = _a.ys;
            this.setv({
                xs: xs,
                ys: ys,
                screen: true
            }, { silent: true });
            this.data_update.emit();
        };
        return PolyAnnotation;
    }(annotation_1.Annotation);
    exports.PolyAnnotation = PolyAnnotation;
    PolyAnnotation.initClass();    
},
/*models/annotations/span*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var annotation_1 = require(54    /* ./annotation */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var SpanView = function (_super) {
        tslib_1.__extends(SpanView, _super);
        function SpanView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SpanView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.plot_view.canvas_overlays.appendChild(this.el);
            this.el.style.position = 'absolute';
            dom_1.hide(this.el);
        };
        SpanView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            if (this.model.for_hover)
                this.connect(this.model.properties.computed_location.change, function () {
                    return _this._draw_span();
                });
            else {
                if (this.model.render_mode == 'canvas') {
                    this.connect(this.model.change, function () {
                        return _this.plot_view.request_render();
                    });
                    this.connect(this.model.properties.location.change, function () {
                        return _this.plot_view.request_render();
                    });
                } else {
                    this.connect(this.model.change, function () {
                        return _this.render();
                    });
                    this.connect(this.model.properties.location.change, function () {
                        return _this._draw_span();
                    });
                }
            }
        };
        SpanView.prototype.render = function () {
            if (!this.model.visible && this.model.render_mode == 'css')
                dom_1.hide(this.el);
            if (!this.model.visible)
                return;
            this._draw_span();
        };
        SpanView.prototype._draw_span = function () {
            var _this = this;
            var loc = this.model.for_hover ? this.model.computed_location : this.model.location;
            if (loc == null) {
                dom_1.hide(this.el);
                return;
            }
            var frame = this.plot_view.frame;
            var xscale = frame.xscales[this.model.x_range_name];
            var yscale = frame.yscales[this.model.y_range_name];
            var _calc_dim = function (scale, view) {
                if (_this.model.for_hover)
                    return _this.model.computed_location;
                else {
                    if (_this.model.location_units == 'data')
                        return scale.compute(loc);
                    else
                        return view.compute(loc);
                }
            };
            var height, sleft, stop, width;
            if (this.model.dimension == 'width') {
                stop = _calc_dim(yscale, frame.yview);
                sleft = frame._left.value;
                width = frame._width.value;
                height = this.model.properties.line_width.value();
            } else {
                stop = frame._top.value;
                sleft = _calc_dim(xscale, frame.xview);
                width = this.model.properties.line_width.value();
                height = frame._height.value;
            }
            if (this.model.render_mode == 'css') {
                this.el.style.top = stop + 'px';
                this.el.style.left = sleft + 'px';
                this.el.style.width = width + 'px';
                this.el.style.height = height + 'px';
                this.el.style.backgroundColor = this.model.properties.line_color.value();
                this.el.style.opacity = this.model.properties.line_alpha.value();
                dom_1.show(this.el);
            } else if (this.model.render_mode == 'canvas') {
                var ctx = this.plot_view.canvas_view.ctx;
                ctx.save();
                ctx.beginPath();
                this.visuals.line.set_value(ctx);
                ctx.moveTo(sleft, stop);
                if (this.model.dimension == 'width') {
                    ctx.lineTo(sleft + width, stop);
                } else {
                    ctx.lineTo(sleft, stop + height);
                }
                ctx.stroke();
                ctx.restore();
            }
        };
        return SpanView;
    }(annotation_1.AnnotationView);
    exports.SpanView = SpanView;
    var Span = function (_super) {
        tslib_1.__extends(Span, _super);
        function Span(attrs) {
            return _super.call(this, attrs) || this;
        }
        Span.initClass = function () {
            this.prototype.type = 'Span';
            this.prototype.default_view = SpanView;
            this.mixins(['line']);
            this.define({
                render_mode: [
                    p.RenderMode,
                    'canvas'
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ],
                location: [
                    p.Number,
                    null
                ],
                location_units: [
                    p.SpatialUnits,
                    'data'
                ],
                dimension: [
                    p.Dimension,
                    'width'
                ]
            });
            this.override({ line_color: 'black' });
            this.internal({
                for_hover: [
                    p.Boolean,
                    false
                ],
                computed_location: [
                    p.Number,
                    null
                ]
            });
        };
        return Span;
    }(annotation_1.Annotation);
    exports.Span = Span;
    Span.initClass();    
},
/*models/annotations/text_annotation*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var annotation_1 = require(54    /* ./annotation */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var text_1 = require(41    /* core/util/text */);
    var TextAnnotationView = function (_super) {
        tslib_1.__extends(TextAnnotationView, _super);
        function TextAnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TextAnnotationView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            if (this.model.render_mode == 'css') {
                this.el.classList.add('bk-annotation');
                this.plot_view.canvas_overlays.appendChild(this.el);
            }
        };
        TextAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            if (this.model.render_mode == 'css') {
                // dispatch CSS update immediately
                this.connect(this.model.change, function () {
                    return _this.render();
                });
            } else {
                this.connect(this.model.change, function () {
                    return _this.plot_view.request_render();
                });
            }
        };
        TextAnnotationView.prototype._calculate_text_dimensions = function (ctx, text) {
            var width = ctx.measureText(text).width;
            var height = text_1.get_text_height(this.visuals.text.font_value()).height;
            return [
                width,
                height
            ];
        };
        TextAnnotationView.prototype._calculate_bounding_box_dimensions = function (ctx, text) {
            var _a = this._calculate_text_dimensions(ctx, text), width = _a[0], height = _a[1];
            var x_offset;
            switch (ctx.textAlign) {
            case 'left':
                x_offset = 0;
                break;
            case 'center':
                x_offset = -width / 2;
                break;
            case 'right':
                x_offset = -width;
                break;
            default:
                throw new Error('unreachable code');
            }
            // guestimated from https://www.w3.org/TR/2dcontext/#dom-context-2d-textbaseline
            var y_offset;
            switch (ctx.textBaseline) {
            case 'top':
                y_offset = 0;
                break;
            case 'middle':
                y_offset = -0.5 * height;
                break;
            case 'bottom':
                y_offset = -1 * height;
                break;
            case 'alphabetic':
                y_offset = -0.8 * height;
                break;
            case 'hanging':
                y_offset = -0.17 * height;
                break;
            case 'ideographic':
                y_offset = -0.83 * height;
                break;
            default:
                throw new Error('unreachable code');
            }
            return [
                x_offset,
                y_offset,
                width,
                height
            ];
        };
        TextAnnotationView.prototype._canvas_text = function (ctx, text, sx, sy, angle) {
            this.visuals.text.set_value(ctx);
            var bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            ctx.save();
            ctx.beginPath();
            ctx.translate(sx, sy);
            if (angle)
                ctx.rotate(angle);
            ctx.rect(bbox_dims[0], bbox_dims[1], bbox_dims[2], bbox_dims[3]);
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                ctx.fill();
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.stroke();
            }
            if (this.visuals.text.doit) {
                this.visuals.text.set_value(ctx);
                ctx.fillText(text, 0, 0);
            }
            ctx.restore();
        };
        TextAnnotationView.prototype._css_text = function (ctx, text, sx, sy, angle) {
            dom_1.hide(this.el);
            this.visuals.text.set_value(ctx);
            var bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            // attempt to support vector string-style ("8 4 8") line dashing for css mode
            var ld = this.visuals.border_line.line_dash.value();
            var line_dash = ld.length < 2 ? 'solid' : 'dashed';
            this.visuals.border_line.set_value(ctx);
            this.visuals.background_fill.set_value(ctx);
            this.el.style.position = 'absolute';
            this.el.style.left = sx + bbox_dims[0] + 'px';
            this.el.style.top = sy + bbox_dims[1] + 'px';
            this.el.style.color = '' + this.visuals.text.text_color.value();
            this.el.style.opacity = '' + this.visuals.text.text_alpha.value();
            this.el.style.font = '' + this.visuals.text.font_value();
            this.el.style.lineHeight = 'normal';
            // needed to prevent ipynb css override
            if (angle) {
                this.el.style.transform = 'rotate(' + angle + 'rad)';
            }
            if (this.visuals.background_fill.doit) {
                this.el.style.backgroundColor = '' + this.visuals.background_fill.color_value();
            }
            if (this.visuals.border_line.doit) {
                this.el.style.borderStyle = '' + line_dash;
                this.el.style.borderWidth = this.visuals.border_line.line_width.value() + 'px';
                this.el.style.borderColor = '' + this.visuals.border_line.color_value();
            }
            this.el.textContent = text;
            dom_1.show(this.el);
        };
        return TextAnnotationView;
    }(annotation_1.AnnotationView);
    exports.TextAnnotationView = TextAnnotationView;
    var TextAnnotation = function (_super) {
        tslib_1.__extends(TextAnnotation, _super);
        function TextAnnotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        TextAnnotation.initClass = function () {
            this.prototype.type = 'TextAnnotation';
            this.define({
                render_mode: [
                    p.RenderMode,
                    'canvas'
                ]
            });
        };
        return TextAnnotation;
    }(annotation_1.Annotation);
    exports.TextAnnotation = TextAnnotation;
    TextAnnotation.initClass();    
},
/*models/annotations/title*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var text_annotation_1 = require(67    /* ./text_annotation */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var visuals_1 = require(49    /* core/visuals */);
    var TitleView = function (_super) {
        tslib_1.__extends(TitleView, _super);
        function TitleView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TitleView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.visuals.text = new visuals_1.Text(this.model);
        };
        TitleView.prototype._get_location = function () {
            var panel = this.model.panel;
            var hmargin = this.model.offset;
            var vmargin = 5;
            var sx, sy;
            switch (panel.side) {
            case 'above':
            case 'below': {
                    switch (this.model.vertical_align) {
                    case 'top':
                        sy = panel._top.value + vmargin;
                        break;
                    case 'middle':
                        sy = panel._vcenter.value;
                        break;
                    case 'bottom':
                        sy = panel._bottom.value - vmargin;
                        break;
                    default:
                        throw new Error('unreachable code');
                    }
                    switch (this.model.align) {
                    case 'left':
                        sx = panel._left.value + hmargin;
                        break;
                    case 'center':
                        sx = panel._hcenter.value;
                        break;
                    case 'right':
                        sx = panel._right.value - hmargin;
                        break;
                    default:
                        throw new Error('unreachable code');
                    }
                    break;
                }
            case 'left': {
                    switch (this.model.vertical_align) {
                    case 'top':
                        sx = panel._left.value - vmargin;
                        break;
                    case 'middle':
                        sx = panel._hcenter.value;
                        break;
                    case 'bottom':
                        sx = panel._right.value + vmargin;
                        break;
                    default:
                        throw new Error('unreachable code');
                    }
                    switch (this.model.align) {
                    case 'left':
                        sy = panel._bottom.value - hmargin;
                        break;
                    case 'center':
                        sy = panel._vcenter.value;
                        break;
                    case 'right':
                        sy = panel._top.value + hmargin;
                        break;
                    default:
                        throw new Error('unreachable code');
                    }
                    break;
                }
            case 'right': {
                    switch (this.model.vertical_align) {
                    case 'top':
                        sx = panel._right.value - vmargin;
                        break;
                    case 'middle':
                        sx = panel._hcenter.value;
                        break;
                    case 'bottom':
                        sx = panel._left.value + vmargin;
                        break;
                    default:
                        throw new Error('unreachable code');
                    }
                    switch (this.model.align) {
                    case 'left':
                        sy = panel._top.value + hmargin;
                        break;
                    case 'center':
                        sy = panel._vcenter.value;
                        break;
                    case 'right':
                        sy = panel._bottom.value - hmargin;
                        break;
                    default:
                        throw new Error('unreachable code');
                    }
                    break;
                }
            default:
                throw new Error('unreachable code');
            }
            return [
                sx,
                sy
            ];
        };
        TitleView.prototype.render = function () {
            if (!this.model.visible) {
                if (this.model.render_mode == 'css')
                    dom_1.hide(this.el);
                return;
            }
            var text = this.model.text;
            if (text == null || text.length == 0)
                return;
            this.model.text_baseline = this.model.vertical_align;
            this.model.text_align = this.model.align;
            var _a = this._get_location(), sx = _a[0], sy = _a[1];
            var angle = this.model.panel.get_label_angle_heuristic('parallel');
            var draw = this.model.render_mode == 'canvas' ? this._canvas_text.bind(this) : this._css_text.bind(this);
            draw(this.plot_view.canvas_view.ctx, text, sx, sy, angle);
        };
        TitleView.prototype._get_size = function () {
            var text = this.model.text;
            if (text == null || text.length == 0)
                return 0;
            else {
                var ctx = this.plot_view.canvas_view.ctx;
                this.visuals.text.set_value(ctx);
                return ctx.measureText(text).ascent + 10;
            }
        };
        return TitleView;
    }(text_annotation_1.TextAnnotationView);
    exports.TitleView = TitleView;
    var Title = function (_super) {
        tslib_1.__extends(Title, _super);
        function Title(attrs) {
            return _super.call(this, attrs) || this;
        }
        Title.initClass = function () {
            this.prototype.type = 'Title';
            this.prototype.default_view = TitleView;
            this.mixins([
                'line:border_',
                'fill:background_'
            ]);
            this.define({
                text: [p.String],
                text_font: [
                    p.Font,
                    'helvetica'
                ],
                text_font_size: [
                    p.FontSizeSpec,
                    '10pt'
                ],
                text_font_style: [
                    p.FontStyle,
                    'bold'
                ],
                text_color: [
                    p.ColorSpec,
                    '#444444'
                ],
                text_alpha: [
                    p.NumberSpec,
                    1
                ],
                vertical_align: [
                    p.VerticalAlign,
                    'bottom'
                ],
                align: [
                    p.TextAlign,
                    'left'
                ],
                offset: [
                    p.Number,
                    0
                ]
            });
            this.override({
                background_fill_color: null,
                border_line_color: null
            });
            this.internal({
                text_align: [
                    p.TextAlign,
                    'left'
                ],
                text_baseline: [
                    p.TextBaseline,
                    'bottom'
                ]
            });
        };
        return Title;
    }(text_annotation_1.TextAnnotation);
    exports.Title = Title;
    Title.initClass();    
},
/*models/annotations/toolbar_panel*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var annotation_1 = require(54    /* ./annotation */);
    var build_views_1 = require(4    /* core/build_views */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var ToolbarPanelView = function (_super) {
        tslib_1.__extends(ToolbarPanelView, _super);
        function ToolbarPanelView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ToolbarPanelView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.plot_view.canvas_events.appendChild(this.el);
            this._toolbar_views = {};
            build_views_1.build_views(this._toolbar_views, [this.model.toolbar], { parent: this });
        };
        ToolbarPanelView.prototype.remove = function () {
            build_views_1.remove_views(this._toolbar_views);
            _super.prototype.remove.call(this);
        };
        ToolbarPanelView.prototype.render = function () {
            _super.prototype.render.call(this);
            if (!this.model.visible) {
                dom_1.hide(this.el);
                return;
            }
            var panel = this.model.panel;
            this.el.style.position = 'absolute';
            this.el.style.left = panel._left.value + 'px';
            this.el.style.top = panel._top.value + 'px';
            this.el.style.width = panel._width.value + 'px';
            this.el.style.height = panel._height.value + 'px';
            this.el.style.overflow = 'hidden';
            var toolbar = this._toolbar_views[this.model.toolbar.id];
            toolbar.render();
            dom_1.empty(this.el);
            this.el.appendChild(toolbar.el);
            dom_1.show(this.el);
        };
        ToolbarPanelView.prototype._get_size = function () {
            return 30;
        };
        return ToolbarPanelView;
    }(annotation_1.AnnotationView);
    exports.ToolbarPanelView = ToolbarPanelView;
    var ToolbarPanel = function (_super) {
        tslib_1.__extends(ToolbarPanel, _super);
        function ToolbarPanel(attrs) {
            return _super.call(this, attrs) || this;
        }
        ToolbarPanel.initClass = function () {
            this.prototype.type = 'ToolbarPanel';
            this.prototype.default_view = ToolbarPanelView;
            this.define({ toolbar: [p.Instance] });
        };
        return ToolbarPanel;
    }(annotation_1.Annotation);
    exports.ToolbarPanel = ToolbarPanel;
    ToolbarPanel.initClass();    
},
/*models/annotations/tooltip*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var annotation_1 = require(54    /* ./annotation */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    function compute_side(attachment, sx, sy, hcenter, vcenter) {
        var side;
        switch (attachment) {
        case 'horizontal':
            side = sx < hcenter ? 'right' : 'left';
            break;
        case 'vertical':
            side = sy < vcenter ? 'below' : 'above';
            break;
        default:
            side = attachment;
        }
        return side;
    }
    exports.compute_side = compute_side;
    var TooltipView = function (_super) {
        tslib_1.__extends(TooltipView, _super);
        function TooltipView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TooltipView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            // TODO (bev) really probably need multiple divs
            this.plot_view.canvas_overlays.appendChild(this.el);
            dom_1.hide(this.el);
        };
        TooltipView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.properties.data.change, function () {
                return _this._draw_tips();
            });
        };
        TooltipView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-tooltip');
        };
        TooltipView.prototype.render = function () {
            if (!this.model.visible)
                return;
            this._draw_tips();
        };
        TooltipView.prototype._draw_tips = function () {
            var data = this.model.data;
            dom_1.empty(this.el);
            dom_1.hide(this.el);
            if (this.model.custom)
                this.el.classList.add('bk-tooltip-custom');
            else
                this.el.classList.remove('bk-tooltip-custom');
            if (data.length == 0)
                return;
            var frame = this.plot_view.frame;
            for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
                var _a = data_1[_i], sx_1 = _a[0], sy_1 = _a[1], content = _a[2];
                if (this.model.inner_only && !frame.bbox.contains(sx_1, sy_1))
                    continue;
                var tip = dom_1.div({}, content);
                this.el.appendChild(tip);
            }
            var _b = data[data.length - 1], sx = _b[0], sy = _b[1];
            // XXX: this previously depended on {sx, sy} leaking from the for-loop
            var side = compute_side(this.model.attachment, sx, sy, frame._hcenter.value, frame._vcenter.value);
            this.el.classList.remove('bk-right');
            this.el.classList.remove('bk-left');
            this.el.classList.remove('bk-above');
            this.el.classList.remove('bk-below');
            var arrow_size = 10;
            // XXX: keep in sync with less
            dom_1.show(this.el);
            // XXX: {offset,client}Width() gives 0 when display="none"
            // slightly confusing: side "left" (for example) is relative to point that
            // is being annotated but CS class "bk-left" is relative to the tooltip itself
            var left, top;
            switch (side) {
            case 'right':
                this.el.classList.add('bk-left');
                left = sx + (this.el.offsetWidth - this.el.clientWidth) + arrow_size;
                top = sy - this.el.offsetHeight / 2;
                break;
            case 'left':
                this.el.classList.add('bk-right');
                left = sx - this.el.offsetWidth - arrow_size;
                top = sy - this.el.offsetHeight / 2;
                break;
            case 'below':
                this.el.classList.add('bk-above');
                top = sy + (this.el.offsetHeight - this.el.clientHeight) + arrow_size;
                left = Math.round(sx - this.el.offsetWidth / 2);
                break;
            case 'above':
                this.el.classList.add('bk-below');
                top = sy - this.el.offsetHeight - arrow_size;
                left = Math.round(sx - this.el.offsetWidth / 2);
                break;
            default:
                throw new Error('unreachable code');
            }
            if (this.model.show_arrow)
                this.el.classList.add('bk-tooltip-arrow');
            // TODO (bev) this is not currently bulletproof. If there are
            // two hits, not colocated and one is off the screen, that can
            // be problematic
            if (this.el.childNodes.length > 0) {
                this.el.style.top = top + 'px';
                this.el.style.left = left + 'px';
            } else
                dom_1.hide(this.el);
        };
        return TooltipView;
    }(annotation_1.AnnotationView);
    exports.TooltipView = TooltipView;
    var Tooltip = function (_super) {
        tslib_1.__extends(Tooltip, _super);
        function Tooltip(attrs) {
            return _super.call(this, attrs) || this;
        }
        Tooltip.initClass = function () {
            this.prototype.type = 'Tooltip';
            this.prototype.default_view = TooltipView;
            this.define({
                attachment: [
                    p.String,
                    'horizontal'
                ],
                inner_only: [
                    p.Bool,
                    true
                ],
                show_arrow: [
                    p.Bool,
                    true
                ]
            });
            this.override({ level: 'overlay' });
            this.internal({
                data: [
                    p.Any,
                    []
                ],
                custom: [p.Any]
            });
        };
        Tooltip.prototype.clear = function () {
            this.data = [];
        };
        Tooltip.prototype.add = function (sx, sy, content) {
            this.data = this.data.concat([[
                    sx,
                    sy,
                    content
                ]]);
        };
        return Tooltip;
    }(annotation_1.Annotation);
    exports.Tooltip = Tooltip;
    Tooltip.initClass();    
},
/*models/annotations/whisker*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var annotation_1 = require(54    /* ./annotation */);
    var column_data_source_1 = require(184    /* ../sources/column_data_source */);
    var arrow_head_1 = require(56    /* ./arrow_head */);
    var p = require(15    /* core/properties */);
    var WhiskerView = function (_super) {
        tslib_1.__extends(WhiskerView, _super);
        function WhiskerView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        WhiskerView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.set_data(this.model.source);
        };
        WhiskerView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.source.streaming, function () {
                return _this.set_data(_this.model.source);
            });
            this.connect(this.model.source.patching, function () {
                return _this.set_data(_this.model.source);
            });
            this.connect(this.model.source.change, function () {
                return _this.set_data(_this.model.source);
            });
        };
        WhiskerView.prototype.set_data = function (source) {
            _super.prototype.set_data.call(this, source);
            this.visuals.warm_cache(source);
            this.plot_view.request_render();
        };
        WhiskerView.prototype._map_data = function () {
            var frame = this.plot_model.frame;
            var dim = this.model.dimension;
            var xscale = frame.xscales[this.model.x_range_name];
            var yscale = frame.yscales[this.model.y_range_name];
            var limit_scale = dim == 'height' ? yscale : xscale;
            var base_scale = dim == 'height' ? xscale : yscale;
            var limit_view = dim == 'height' ? frame.yview : frame.xview;
            var base_view = dim == 'height' ? frame.xview : frame.yview;
            var _lower_sx;
            if (this.model.lower.units == 'data')
                _lower_sx = limit_scale.v_compute(this._lower);
            else
                _lower_sx = limit_view.v_compute(this._lower);
            var _upper_sx;
            if (this.model.upper.units == 'data')
                _upper_sx = limit_scale.v_compute(this._upper);
            else
                _upper_sx = limit_view.v_compute(this._upper);
            var _base_sx;
            if (this.model.base.units == 'data')
                _base_sx = base_scale.v_compute(this._base);
            else
                _base_sx = base_view.v_compute(this._base);
            var _a = dim == 'height' ? [
                    1,
                    0
                ] : [
                    0,
                    1
                ], i = _a[0], j = _a[1];
            var _lower = [
                _lower_sx,
                _base_sx
            ];
            var _upper = [
                _upper_sx,
                _base_sx
            ];
            this._lower_sx = _lower[i];
            this._lower_sy = _lower[j];
            this._upper_sx = _upper[i];
            this._upper_sy = _upper[j];
        };
        WhiskerView.prototype.render = function () {
            if (!this.model.visible)
                return;
            this._map_data();
            var ctx = this.plot_view.canvas_view.ctx;
            if (this.visuals.line.doit) {
                for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.beginPath();
                    ctx.moveTo(this._lower_sx[i], this._lower_sy[i]);
                    ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
                    ctx.stroke();
                }
            }
            var angle = this.model.dimension == 'height' ? 0 : Math.PI / 2;
            if (this.model.lower_head != null) {
                for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                    ctx.save();
                    ctx.translate(this._lower_sx[i], this._lower_sy[i]);
                    ctx.rotate(angle + Math.PI);
                    this.model.lower_head.render(ctx, i);
                    ctx.restore();
                }
            }
            if (this.model.upper_head != null) {
                for (var i = 0, end = this._upper_sx.length; i < end; i++) {
                    ctx.save();
                    ctx.translate(this._upper_sx[i], this._upper_sy[i]);
                    ctx.rotate(angle);
                    this.model.upper_head.render(ctx, i);
                    ctx.restore();
                }
            }
        };
        return WhiskerView;
    }(annotation_1.AnnotationView);
    exports.WhiskerView = WhiskerView;
    var Whisker = function (_super) {
        tslib_1.__extends(Whisker, _super);
        function Whisker(attrs) {
            return _super.call(this, attrs) || this;
        }
        Whisker.initClass = function () {
            this.prototype.type = 'Whisker';
            this.prototype.default_view = WhiskerView;
            this.mixins(['line']);
            this.define({
                lower: [p.DistanceSpec],
                lower_head: [
                    p.Instance,
                    function () {
                        return new arrow_head_1.TeeHead({
                            level: 'underlay',
                            size: 10
                        });
                    }
                ],
                upper: [p.DistanceSpec],
                upper_head: [
                    p.Instance,
                    function () {
                        return new arrow_head_1.TeeHead({
                            level: 'underlay',
                            size: 10
                        });
                    }
                ],
                base: [p.DistanceSpec],
                dimension: [
                    p.Dimension,
                    'height'
                ],
                source: [
                    p.Instance,
                    function () {
                        return new column_data_source_1.ColumnDataSource();
                    }
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
            this.override({ level: 'underlay' });
        };
        return Whisker;
    }(annotation_1.Annotation);
    exports.Whisker = Whisker;
    Whisker.initClass();    
},
/*models/axes/axis*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var guide_renderer_1 = require(171    /* ../renderers/guide_renderer */);
    var p = require(15    /* core/properties */);
    var side_panel_1 = require(12    /* core/layout/side_panel */);
    var array_1 = require(21    /* core/util/array */);
    var types_1 = require(44    /* core/util/types */);
    var factor_range_1 = require(165    /* models/ranges/factor_range */);
    var abs = Math.abs, min = Math.min, max = Math.max;
    var AxisView = function (_super) {
        tslib_1.__extends(AxisView, _super);
        function AxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AxisView.prototype.render = function () {
            if (!this.model.visible)
                return;
            var extents = {
                tick: this._tick_extent(),
                tick_label: this._tick_label_extents(),
                axis_label: this._axis_label_extent()
            };
            var tick_coords = this.model.tick_coords;
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            this._draw_rule(ctx, extents);
            this._draw_major_ticks(ctx, extents, tick_coords);
            this._draw_minor_ticks(ctx, extents, tick_coords);
            this._draw_major_labels(ctx, extents, tick_coords);
            this._draw_axis_label(ctx, extents, tick_coords);
            if (this._render != null)
                this._render(ctx, extents, tick_coords);
            ctx.restore();
        };
        AxisView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () {
                return _this.plot_view.request_render();
            });
        };
        AxisView.prototype.get_size = function () {
            return this.model.visible ? Math.round(this._get_size()) : 0;
        };
        AxisView.prototype._get_size = function () {
            if (this.model.fixed_location != null) {
                return 0;
            }
            return this._tick_extent() + this._tick_label_extent() + this._axis_label_extent();
        };
        Object.defineProperty(AxisView.prototype, 'needs_clip', {
            get: function () {
                return this.model.fixed_location != null;
            },
            enumerable: true,
            configurable: true
        });
        // drawing sub functions -----------------------------------------------------
        AxisView.prototype._draw_rule = function (ctx, _extents) {
            if (!this.visuals.axis_line.doit)
                return;
            var _a = this.model.rule_coords, xs = _a[0], ys = _a[1];
            var _b = this.plot_view.map_to_screen(xs, ys, this.model.x_range_name, this.model.y_range_name), sxs = _b[0], sys = _b[1];
            var _c = this.model.normals, nx = _c[0], ny = _c[1];
            var _d = this.model.offsets, xoff = _d[0], yoff = _d[1];
            this.visuals.axis_line.set_value(ctx);
            ctx.beginPath();
            ctx.moveTo(Math.round(sxs[0] + nx * xoff), Math.round(sys[0] + ny * yoff));
            for (var i = 1; i < sxs.length; i++) {
                var sx = Math.round(sxs[i] + nx * xoff);
                var sy = Math.round(sys[i] + ny * yoff);
                ctx.lineTo(sx, sy);
            }
            ctx.stroke();
        };
        AxisView.prototype._draw_major_ticks = function (ctx, _extents, tick_coords) {
            var tin = this.model.major_tick_in;
            var tout = this.model.major_tick_out;
            var visuals = this.visuals.major_tick_line;
            this._draw_ticks(ctx, tick_coords.major, tin, tout, visuals);
        };
        AxisView.prototype._draw_minor_ticks = function (ctx, _extents, tick_coords) {
            var tin = this.model.minor_tick_in;
            var tout = this.model.minor_tick_out;
            var visuals = this.visuals.minor_tick_line;
            this._draw_ticks(ctx, tick_coords.minor, tin, tout, visuals);
        };
        AxisView.prototype._draw_major_labels = function (ctx, extents, tick_coords) {
            var coords = tick_coords.major;
            var labels = this.model.compute_labels(coords[this.model.dimension]);
            var orient = this.model.major_label_orientation;
            var standoff = extents.tick + this.model.major_label_standoff;
            var visuals = this.visuals.major_label_text;
            this._draw_oriented_labels(ctx, labels, coords, orient, this.model.panel.side, standoff, visuals);
        };
        AxisView.prototype._draw_axis_label = function (ctx, extents, _tick_coords) {
            if (this.model.axis_label == null || this.model.axis_label.length == 0 || this.model.fixed_location != null)
                return;
            var sx;
            var sy;
            switch (this.model.panel.side) {
            case 'above':
                sx = this.model.panel._hcenter.value;
                sy = this.model.panel._bottom.value;
                break;
            case 'below':
                sx = this.model.panel._hcenter.value;
                sy = this.model.panel._top.value;
                break;
            case 'left':
                sx = this.model.panel._right.value;
                sy = this.model.panel._vcenter.value;
                break;
            case 'right':
                sx = this.model.panel._left.value;
                sy = this.model.panel._vcenter.value;
                break;
            default:
                throw new Error('unknown side: ' + this.model.panel.side);
            }
            var coords = [
                [sx],
                [sy]
            ];
            var standoff = extents.tick + array_1.sum(extents.tick_label) + this.model.axis_label_standoff;
            var visuals = this.visuals.axis_label_text;
            this._draw_oriented_labels(ctx, [this.model.axis_label], coords, 'parallel', this.model.panel.side, standoff, visuals, 'screen');
        };
        AxisView.prototype._draw_ticks = function (ctx, coords, tin, tout, visuals) {
            if (!visuals.doit)
                return;
            var x = coords[0], y = coords[1];
            var _a = this.plot_view.map_to_screen(x, y, this.model.x_range_name, this.model.y_range_name), sxs = _a[0], sys = _a[1];
            var _b = this.model.normals, nx = _b[0], ny = _b[1];
            var _c = this.model.offsets, xoff = _c[0], yoff = _c[1];
            var _d = [
                    nx * (xoff - tin),
                    ny * (yoff - tin)
                ], nxin = _d[0], nyin = _d[1];
            var _e = [
                    nx * (xoff + tout),
                    ny * (yoff + tout)
                ], nxout = _e[0], nyout = _e[1];
            visuals.set_value(ctx);
            for (var i = 0; i < sxs.length; i++) {
                var sx0 = Math.round(sxs[i] + nxout);
                var sy0 = Math.round(sys[i] + nyout);
                var sx1 = Math.round(sxs[i] + nxin);
                var sy1 = Math.round(sys[i] + nyin);
                ctx.beginPath();
                ctx.moveTo(sx0, sy0);
                ctx.lineTo(sx1, sy1);
                ctx.stroke();
            }
        };
        AxisView.prototype._draw_oriented_labels = function (ctx, labels, coords, orient, _side, standoff, visuals, units) {
            if (units === void 0) {
                units = 'data';
            }
            if (!visuals.doit || labels.length == 0)
                return;
            var sxs, sys;
            var xoff, yoff;
            if (units == 'screen') {
                sxs = coords[0], sys = coords[1];
                _a = [
                    0,
                    0
                ], xoff = _a[0], yoff = _a[1];
            } else {
                var dxs = coords[0], dys = coords[1];
                _b = this.plot_view.map_to_screen(dxs, dys, this.model.x_range_name, this.model.y_range_name), sxs = _b[0], sys = _b[1];
                _c = this.model.offsets, xoff = _c[0], yoff = _c[1];
            }
            var _d = this.model.normals, nx = _d[0], ny = _d[1];
            var nxd = nx * (xoff + standoff);
            var nyd = ny * (yoff + standoff);
            visuals.set_value(ctx);
            this.model.panel.apply_label_text_heuristics(ctx, orient);
            var angle;
            if (types_1.isString(orient))
                angle = this.model.panel.get_label_angle_heuristic(orient);
            else
                angle = -orient;
            for (var i = 0; i < sxs.length; i++) {
                var sx = Math.round(sxs[i] + nxd);
                var sy = Math.round(sys[i] + nyd);
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.fillText(labels[i], 0, 0);
                ctx.rotate(-angle);
                ctx.translate(-sx, -sy);
            }
            var _a, _b, _c;
        };
        // extents sub functions -----------------------------------------------------
        AxisView.prototype._axis_label_extent = function () {
            if (this.model.axis_label == null || this.model.axis_label == '')
                return 0;
            var standoff = this.model.axis_label_standoff;
            var visuals = this.visuals.axis_label_text;
            return this._oriented_labels_extent([this.model.axis_label], 'parallel', this.model.panel.side, standoff, visuals);
        };
        AxisView.prototype._tick_extent = function () {
            return this.model.major_tick_out;
        };
        AxisView.prototype._tick_label_extent = function () {
            return array_1.sum(this._tick_label_extents());
        };
        AxisView.prototype._tick_label_extents = function () {
            var coords = this.model.tick_coords.major;
            var labels = this.model.compute_labels(coords[this.model.dimension]);
            var orient = this.model.major_label_orientation;
            var standoff = this.model.major_label_standoff;
            var visuals = this.visuals.major_label_text;
            return [this._oriented_labels_extent(labels, orient, this.model.panel.side, standoff, visuals)];
        };
        AxisView.prototype._oriented_labels_extent = function (labels, orient, side, standoff, visuals) {
            if (labels.length == 0)
                return 0;
            var ctx = this.plot_view.canvas_view.ctx;
            visuals.set_value(ctx);
            var hscale;
            var angle;
            if (types_1.isString(orient)) {
                hscale = 1;
                angle = this.model.panel.get_label_angle_heuristic(orient);
            } else {
                hscale = 2;
                angle = -orient;
            }
            angle = Math.abs(angle);
            var c = Math.cos(angle);
            var s = Math.sin(angle);
            var extent = 0;
            for (var i = 0; i < labels.length; i++) {
                var w = ctx.measureText(labels[i]).width * 1.1;
                var h = ctx.measureText(labels[i]).ascent * 0.9;
                var val = void 0;
                if (side == 'above' || side == 'below')
                    val = w * s + h / hscale * c;
                else
                    val = w * c + h / hscale * s;
                // update extent if current value is larger
                if (val > extent)
                    extent = val;
            }
            // only apply the standoff if we already have non-zero extent
            if (extent > 0)
                extent += standoff;
            return extent;
        };
        return AxisView;
    }(guide_renderer_1.GuideRendererView);
    exports.AxisView = AxisView;
    var Axis = function (_super) {
        tslib_1.__extends(Axis, _super);
        function Axis(attrs) {
            return _super.call(this, attrs) || this;
        }
        Axis.initClass = function () {
            this.prototype.type = 'Axis';
            this.prototype.default_view = AxisView;
            this.mixins([
                'line:axis_',
                'line:major_tick_',
                'line:minor_tick_',
                'text:major_label_',
                'text:axis_label_'
            ]);
            this.define({
                bounds: [
                    p.Any,
                    'auto'
                ],
                ticker: [
                    p.Instance,
                    null
                ],
                formatter: [
                    p.Instance,
                    null
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ],
                axis_label: [
                    p.String,
                    ''
                ],
                axis_label_standoff: [
                    p.Int,
                    5
                ],
                major_label_standoff: [
                    p.Int,
                    5
                ],
                major_label_orientation: [
                    p.Any,
                    'horizontal'
                ],
                major_label_overrides: [
                    p.Any,
                    {}
                ],
                major_tick_in: [
                    p.Number,
                    2
                ],
                major_tick_out: [
                    p.Number,
                    6
                ],
                minor_tick_in: [
                    p.Number,
                    0
                ],
                minor_tick_out: [
                    p.Number,
                    4
                ],
                fixed_location: [
                    p.Any,
                    null
                ]
            });
            this.override({
                axis_line_color: 'black',
                major_tick_line_color: 'black',
                minor_tick_line_color: 'black',
                major_label_text_font_size: '8pt',
                major_label_text_align: 'center',
                major_label_text_baseline: 'alphabetic',
                axis_label_text_font_size: '10pt',
                axis_label_text_font_style: 'italic'
            });
        };
        Axis.prototype.add_panel = function (side) {
            this.panel = new side_panel_1.SidePanel({ side: side });
            this.panel.attach_document(this.document);    // XXX!
        };
        Object.defineProperty(Axis.prototype, 'normals', {
            get: function () {
                return this.panel.normals;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Axis.prototype, 'dimension', {
            get: function () {
                return this.panel.dimension;
            },
            enumerable: true,
            configurable: true
        });
        Axis.prototype.compute_labels = function (ticks) {
            var labels = this.formatter.doFormat(ticks, this);
            for (var i = 0; i < ticks.length; i++) {
                if (ticks[i] in this.major_label_overrides)
                    labels[i] = this.major_label_overrides[ticks[i]];
            }
            return labels;
        };
        Object.defineProperty(Axis.prototype, 'offsets', {
            get: function () {
                var frame = this.plot.plot_canvas.frame;
                var _a = [
                        0,
                        0
                    ], xoff = _a[0], yoff = _a[1];
                switch (this.panel.side) {
                case 'below':
                    yoff = abs(this.panel._top.value - frame._bottom.value);
                    break;
                case 'above':
                    yoff = abs(this.panel._bottom.value - frame._top.value);
                    break;
                case 'right':
                    xoff = abs(this.panel._left.value - frame._right.value);
                    break;
                case 'left':
                    xoff = abs(this.panel._right.value - frame._left.value);
                    break;
                }
                return [
                    xoff,
                    yoff
                ];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Axis.prototype, 'ranges', {
            get: function () {
                var i = this.dimension;
                var j = (i + 1) % 2;
                var frame = this.plot.plot_canvas.frame;
                var ranges = [
                    frame.x_ranges[this.x_range_name],
                    frame.y_ranges[this.y_range_name]
                ];
                return [
                    ranges[i],
                    ranges[j]
                ];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Axis.prototype, 'computed_bounds', {
            get: function () {
                var range = this.ranges[0];
                var user_bounds = this.bounds;
                // XXX: ? 'auto'
                var range_bounds = [
                    range.min,
                    range.max
                ];
                if (user_bounds == 'auto')
                    return [
                        range.min,
                        range.max
                    ];
                else if (types_1.isArray(user_bounds)) {
                    var start = void 0;
                    var end = void 0;
                    var user_start = user_bounds[0], user_end = user_bounds[1];
                    var range_start = range_bounds[0], range_end = range_bounds[1];
                    if (abs(user_start - user_end) > abs(range_start - range_end)) {
                        start = max(min(user_start, user_end), range_start);
                        end = min(max(user_start, user_end), range_end);
                    } else {
                        start = min(user_start, user_end);
                        end = max(user_start, user_end);
                    }
                    return [
                        start,
                        end
                    ];
                } else
                    throw new Error('user bounds \'' + user_bounds + '\' not understood');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Axis.prototype, 'rule_coords', {
            get: function () {
                var i = this.dimension;
                var j = (i + 1) % 2;
                var range = this.ranges[0];
                var _a = this.computed_bounds, start = _a[0], end = _a[1];
                var xs = new Array(2);
                var ys = new Array(2);
                var coords = [
                    xs,
                    ys
                ];
                coords[i][0] = Math.max(start, range.min);
                coords[i][1] = Math.min(end, range.max);
                if (coords[i][0] > coords[i][1])
                    coords[i][0] = coords[i][1] = NaN;
                coords[j][0] = this.loc;
                coords[j][1] = this.loc;
                return coords;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Axis.prototype, 'tick_coords', {
            get: function () {
                var i = this.dimension;
                var j = (i + 1) % 2;
                var range = this.ranges[0];
                var _a = this.computed_bounds, start = _a[0], end = _a[1];
                var ticks = this.ticker.get_ticks(start, end, range, this.loc, {});
                var majors = ticks.major;
                var minors = ticks.minor;
                var xs = [];
                var ys = [];
                var coords = [
                    xs,
                    ys
                ];
                var minor_xs = [];
                var minor_ys = [];
                var minor_coords = [
                    minor_xs,
                    minor_ys
                ];
                var _b = [
                        range.min,
                        range.max
                    ], range_min = _b[0], range_max = _b[1];
                for (var ii = 0; ii < majors.length; ii++) {
                    if (majors[ii] < range_min || majors[ii] > range_max)
                        continue;
                    coords[i].push(majors[ii]);
                    coords[j].push(this.loc);
                }
                for (var ii = 0; ii < minors.length; ii++) {
                    if (minors[ii] < range_min || minors[ii] > range_max)
                        continue;
                    minor_coords[i].push(minors[ii]);
                    minor_coords[j].push(this.loc);
                }
                return {
                    major: coords,
                    minor: minor_coords
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Axis.prototype, 'loc', {
            get: function () {
                if (this.fixed_location != null) {
                    if (types_1.isNumber(this.fixed_location)) {
                        return this.fixed_location;
                    }
                    var _a = this.ranges, cross_range_1 = _a[1];
                    if (cross_range_1 instanceof factor_range_1.FactorRange) {
                        return cross_range_1.synthetic(this.fixed_location);
                    }
                    throw new Error('unexpected');
                }
                var _b = this.ranges, cross_range = _b[1];
                switch (this.panel.side) {
                case 'left':
                case 'below':
                    return cross_range.start;
                case 'right':
                case 'above':
                    return cross_range.end;
                }
            },
            enumerable: true,
            configurable: true
        });
        return Axis;
    }(guide_renderer_1.GuideRenderer);
    exports.Axis = Axis;
    Axis.initClass();    
},
/*models/axes/categorical_axis*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var axis_1 = require(72    /* ./axis */);
    var categorical_ticker_1 = require(192    /* ../tickers/categorical_ticker */);
    var categorical_tick_formatter_1 = require(97    /* ../formatters/categorical_tick_formatter */);
    var p = require(15    /* core/properties */);
    var CategoricalAxisView = function (_super) {
        tslib_1.__extends(CategoricalAxisView, _super);
        function CategoricalAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        CategoricalAxisView.prototype._render = function (ctx, extents, tick_coords) {
            this._draw_group_separators(ctx, extents, tick_coords);
        };
        CategoricalAxisView.prototype._draw_group_separators = function (ctx, _extents, _tick_coords) {
            var range = this.model.ranges[0];
            var _a = this.model.computed_bounds, start = _a[0], end = _a[1];
            if (!range.tops || range.tops.length < 2 || !this.visuals.separator_line.doit)
                return;
            var dim = this.model.dimension;
            var alt = (dim + 1) % 2;
            var coords = [
                [],
                []
            ];
            var ind = 0;
            for (var i = 0; i < range.tops.length - 1; i++) {
                var first = void 0, last = void 0;
                for (var j = ind; j < range.factors.length; j++) {
                    if (range.factors[j][0] == range.tops[i + 1]) {
                        _b = [
                            range.factors[j - 1],
                            range.factors[j]
                        ], first = _b[0], last = _b[1];
                        ind = j;
                        break;
                    }
                }
                var pt = (range.synthetic(first) + range.synthetic(last)) / 2;
                if (pt > start && pt < end) {
                    coords[dim].push(pt);
                    coords[alt].push(this.model.loc);
                }
            }
            var tex = this._tick_label_extent();
            this._draw_ticks(ctx, coords, -3, tex - 6, this.visuals.separator_line);
            var _b;
        };
        CategoricalAxisView.prototype._draw_major_labels = function (ctx, extents, _tick_coords) {
            var info = this._get_factor_info();
            var standoff = extents.tick + this.model.major_label_standoff;
            for (var i = 0; i < info.length; i++) {
                var _a = info[i], labels = _a[0], coords = _a[1], orient = _a[2], visuals = _a[3];
                this._draw_oriented_labels(ctx, labels, coords, orient, this.model.panel.side, standoff, visuals);
                standoff += extents.tick_label[i];
            }
        };
        CategoricalAxisView.prototype._tick_label_extents = function () {
            var info = this._get_factor_info();
            var extents = [];
            for (var _i = 0, info_1 = info; _i < info_1.length; _i++) {
                var _a = info_1[_i], labels = _a[0], orient = _a[2], visuals = _a[3];
                var extent = this._oriented_labels_extent(labels, orient, this.model.panel.side, this.model.major_label_standoff, visuals);
                extents.push(extent);
            }
            return extents;
        };
        CategoricalAxisView.prototype._get_factor_info = function () {
            var range = this.model.ranges[0];
            var _a = this.model.computed_bounds, start = _a[0], end = _a[1];
            var loc = this.model.loc;
            var ticks = this.model.ticker.get_ticks(start, end, range, loc, {});
            var coords = this.model.tick_coords;
            var info = [];
            if (range.levels == 1) {
                var labels = this.model.formatter.doFormat(ticks.major, this.model);
                info.push([
                    labels,
                    coords.major,
                    this.model.major_label_orientation,
                    this.visuals.major_label_text
                ]);
            } else if (range.levels == 2) {
                var labels = this.model.formatter.doFormat(ticks.major.map(function (x) {
                    return x[1];
                }), this.model);
                info.push([
                    labels,
                    coords.major,
                    this.model.major_label_orientation,
                    this.visuals.major_label_text
                ]);
                info.push([
                    ticks.tops,
                    coords.tops,
                    this.model.group_label_orientation,
                    this.visuals.group_text
                ]);
            } else if (range.levels == 3) {
                var labels = this.model.formatter.doFormat(ticks.major.map(function (x) {
                    return x[2];
                }), this.model);
                var mid_labels = ticks.mids.map(function (x) {
                    return x[1];
                });
                info.push([
                    labels,
                    coords.major,
                    this.model.major_label_orientation,
                    this.visuals.major_label_text
                ]);
                info.push([
                    mid_labels,
                    coords.mids,
                    this.model.subgroup_label_orientation,
                    this.visuals.subgroup_text
                ]);
                info.push([
                    ticks.tops,
                    coords.tops,
                    this.model.group_label_orientation,
                    this.visuals.group_text
                ]);
            }
            return info;
        };
        return CategoricalAxisView;
    }(axis_1.AxisView);
    exports.CategoricalAxisView = CategoricalAxisView;
    var CategoricalAxis = function (_super) {
        tslib_1.__extends(CategoricalAxis, _super);
        function CategoricalAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        CategoricalAxis.initClass = function () {
            this.prototype.type = 'CategoricalAxis';
            this.prototype.default_view = CategoricalAxisView;
            this.mixins([
                'line:separator_',
                'text:group_',
                'text:subgroup_'
            ]);
            this.define({
                group_label_orientation: [
                    p.Any,
                    'parallel'
                ],
                subgroup_label_orientation: [
                    p.Any,
                    'parallel'
                ]
            });
            this.override({
                ticker: function () {
                    return new categorical_ticker_1.CategoricalTicker();
                },
                formatter: function () {
                    return new categorical_tick_formatter_1.CategoricalTickFormatter();
                },
                separator_line_color: 'lightgrey',
                separator_line_width: 2,
                group_text_font_style: 'bold',
                group_text_font_size: '8pt',
                group_text_color: 'grey',
                subgroup_text_font_style: 'bold',
                subgroup_text_font_size: '8pt'
            });
        };
        Object.defineProperty(CategoricalAxis.prototype, 'tick_coords', {
            get: function () {
                var _this = this;
                var i = this.dimension;
                var j = (i + 1) % 2;
                var range = this.ranges[0];
                var _a = this.computed_bounds, start = _a[0], end = _a[1];
                var ticks = this.ticker.get_ticks(start, end, range, this.loc, {});
                var coords = {
                    major: [
                        [],
                        []
                    ],
                    mids: [
                        [],
                        []
                    ],
                    tops: [
                        [],
                        []
                    ],
                    minor: [
                        [],
                        []
                    ]
                };
                coords.major[i] = ticks.major;
                coords.major[j] = ticks.major.map(function (_x) {
                    return _this.loc;
                });
                if (range.levels == 3)
                    coords.mids[i] = ticks.mids;
                coords.mids[j] = ticks.mids.map(function (_x) {
                    return _this.loc;
                });
                if (range.levels > 1)
                    coords.tops[i] = ticks.tops;
                coords.tops[j] = ticks.tops.map(function (_x) {
                    return _this.loc;
                });
                return coords;
            },
            enumerable: true,
            configurable: true
        });
        return CategoricalAxis;
    }(axis_1.Axis);
    exports.CategoricalAxis = CategoricalAxis;
    CategoricalAxis.initClass();    
},
/*models/axes/continuous_axis*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var axis_1 = require(72    /* ./axis */);
    var ContinuousAxis = function (_super) {
        tslib_1.__extends(ContinuousAxis, _super);
        function ContinuousAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        ContinuousAxis.initClass = function () {
            this.prototype.type = 'ContinuousAxis';
        };
        return ContinuousAxis;
    }(axis_1.Axis);
    exports.ContinuousAxis = ContinuousAxis;
    ContinuousAxis.initClass();    
},
/*models/axes/datetime_axis*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var linear_axis_1 = require(77    /* ./linear_axis */);
    var datetime_tick_formatter_1 = require(98    /* ../formatters/datetime_tick_formatter */);
    var datetime_ticker_1 = require(195    /* ../tickers/datetime_ticker */);
    var DatetimeAxisView = function (_super) {
        tslib_1.__extends(DatetimeAxisView, _super);
        function DatetimeAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DatetimeAxisView;
    }(linear_axis_1.LinearAxisView);
    exports.DatetimeAxisView = DatetimeAxisView;
    var DatetimeAxis = function (_super) {
        tslib_1.__extends(DatetimeAxis, _super);
        function DatetimeAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        DatetimeAxis.initClass = function () {
            this.prototype.type = 'DatetimeAxis';
            this.prototype.default_view = DatetimeAxisView;
            this.override({
                ticker: function () {
                    return new datetime_ticker_1.DatetimeTicker();
                },
                formatter: function () {
                    return new datetime_tick_formatter_1.DatetimeTickFormatter();
                }
            });
        };
        return DatetimeAxis;
    }(linear_axis_1.LinearAxis);
    exports.DatetimeAxis = DatetimeAxis;
    DatetimeAxis.initClass();    
},
/*models/axes/index*/
function _(require, module, exports) {
    var axis_1 = require(72    /* ./axis */);
    exports.Axis = axis_1.Axis;
    var categorical_axis_1 = require(73    /* ./categorical_axis */);
    exports.CategoricalAxis = categorical_axis_1.CategoricalAxis;
    var continuous_axis_1 = require(74    /* ./continuous_axis */);
    exports.ContinuousAxis = continuous_axis_1.ContinuousAxis;
    var datetime_axis_1 = require(75    /* ./datetime_axis */);
    exports.DatetimeAxis = datetime_axis_1.DatetimeAxis;
    var linear_axis_1 = require(77    /* ./linear_axis */);
    exports.LinearAxis = linear_axis_1.LinearAxis;
    var log_axis_1 = require(78    /* ./log_axis */);
    exports.LogAxis = log_axis_1.LogAxis;
    var mercator_axis_1 = require(79    /* ./mercator_axis */);
    exports.MercatorAxis = mercator_axis_1.MercatorAxis;    
},
/*models/axes/linear_axis*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var axis_1 = require(72    /* ./axis */);
    var continuous_axis_1 = require(74    /* ./continuous_axis */);
    var basic_tick_formatter_1 = require(96    /* ../formatters/basic_tick_formatter */);
    var basic_ticker_1 = require(191    /* ../tickers/basic_ticker */);
    var LinearAxisView = function (_super) {
        tslib_1.__extends(LinearAxisView, _super);
        function LinearAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LinearAxisView;
    }(axis_1.AxisView);
    exports.LinearAxisView = LinearAxisView;
    var LinearAxis = function (_super) {
        tslib_1.__extends(LinearAxis, _super);
        function LinearAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        LinearAxis.initClass = function () {
            this.prototype.type = 'LinearAxis';
            this.prototype.default_view = LinearAxisView;
            this.override({
                ticker: function () {
                    return new basic_ticker_1.BasicTicker();
                },
                formatter: function () {
                    return new basic_tick_formatter_1.BasicTickFormatter();
                }
            });
        };
        return LinearAxis;
    }(continuous_axis_1.ContinuousAxis);
    exports.LinearAxis = LinearAxis;
    LinearAxis.initClass();    
},
/*models/axes/log_axis*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var axis_1 = require(72    /* ./axis */);
    var continuous_axis_1 = require(74    /* ./continuous_axis */);
    var log_tick_formatter_1 = require(101    /* ../formatters/log_tick_formatter */);
    var log_ticker_1 = require(199    /* ../tickers/log_ticker */);
    var LogAxisView = function (_super) {
        tslib_1.__extends(LogAxisView, _super);
        function LogAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LogAxisView;
    }(axis_1.AxisView);
    exports.LogAxisView = LogAxisView;
    var LogAxis = function (_super) {
        tslib_1.__extends(LogAxis, _super);
        function LogAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        LogAxis.initClass = function () {
            this.prototype.type = 'LogAxis';
            this.prototype.default_view = LogAxisView;
            this.override({
                ticker: function () {
                    return new log_ticker_1.LogTicker();
                },
                formatter: function () {
                    return new log_tick_formatter_1.LogTickFormatter();
                }
            });
        };
        return LogAxis;
    }(continuous_axis_1.ContinuousAxis);
    exports.LogAxis = LogAxis;
    LogAxis.initClass();    
},
/*models/axes/mercator_axis*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var axis_1 = require(72    /* ./axis */);
    var linear_axis_1 = require(77    /* ./linear_axis */);
    var mercator_tick_formatter_1 = require(102    /* ../formatters/mercator_tick_formatter */);
    var mercator_ticker_1 = require(200    /* ../tickers/mercator_ticker */);
    var MercatorAxisView = function (_super) {
        tslib_1.__extends(MercatorAxisView, _super);
        function MercatorAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return MercatorAxisView;
    }(axis_1.AxisView);
    exports.MercatorAxisView = MercatorAxisView;
    var MercatorAxis = function (_super) {
        tslib_1.__extends(MercatorAxis, _super);
        function MercatorAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        MercatorAxis.initClass = function () {
            this.prototype.type = 'MercatorAxis';
            this.prototype.default_view = MercatorAxisView;
            this.override({
                ticker: function () {
                    return new mercator_ticker_1.MercatorTicker({ dimension: 'lat' });
                },
                formatter: function () {
                    return new mercator_tick_formatter_1.MercatorTickFormatter({ dimension: 'lat' });
                }
            });
        };
        return MercatorAxis;
    }(linear_axis_1.LinearAxis);
    exports.MercatorAxis = MercatorAxis;
    MercatorAxis.initClass();    
},
/*models/callbacks/callback*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var model_1 = require(53    /* ../../model */);
    var Callback = function (_super) {
        tslib_1.__extends(Callback, _super);
        function Callback(attrs) {
            return _super.call(this, attrs) || this;
        }
        Callback.initClass = function () {
            this.prototype.type = 'Callback';
        };
        return Callback;
    }(model_1.Model);
    exports.Callback = Callback;
    Callback.initClass();    
},
/*models/callbacks/customjs*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var callback_1 = require(80    /* ./callback */);
    var p = require(15    /* core/properties */);
    var object_1 = require(32    /* core/util/object */);
    var string_1 = require(38    /* core/util/string */);
    var CustomJS = function (_super) {
        tslib_1.__extends(CustomJS, _super);
        function CustomJS(attrs) {
            return _super.call(this, attrs) || this;
        }
        CustomJS.initClass = function () {
            this.prototype.type = 'CustomJS';
            this.define({
                args: [
                    p.Any,
                    {}
                ],
                code: [
                    p.String,
                    ''
                ],
                use_strict: [
                    p.Boolean,
                    false
                ]
            });
        };
        Object.defineProperty(CustomJS.prototype, 'names', {
            get: function () {
                return object_1.keys(this.args);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CustomJS.prototype, 'values', {
            get: function () {
                return object_1.values(this.args);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CustomJS.prototype, 'func', {
            get: function () {
                var code = this.use_strict ? string_1.use_strict(this.code) : this.code;
                return new (Function.bind.apply(Function, [void 0].concat(this.names, [
                    'cb_obj',
                    'cb_data',
                    'require',
                    'exports',
                    code
                ])))();
            },
            enumerable: true,
            configurable: true
        });
        CustomJS.prototype.execute = function (cb_obj, cb_data) {
            return this.func.apply(cb_obj, this.values.concat(cb_obj, cb_data, require, {}));
        };
        return CustomJS;
    }(callback_1.Callback);
    exports.CustomJS = CustomJS;
    CustomJS.initClass();    
},
/*models/callbacks/index*/
function _(require, module, exports) {
    var customjs_1 = require(81    /* ./customjs */);
    exports.CustomJS = customjs_1.CustomJS;
    var open_url_1 = require(83    /* ./open_url */);
    exports.OpenURL = open_url_1.OpenURL;    
},
/*models/callbacks/open_url*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var callback_1 = require(80    /* ./callback */);
    var p = require(15    /* core/properties */);
    var selection_1 = require(35    /* core/util/selection */);
    var templating_1 = require(40    /* core/util/templating */);
    var OpenURL = function (_super) {
        tslib_1.__extends(OpenURL, _super);
        function OpenURL(attrs) {
            return _super.call(this, attrs) || this;
        }
        OpenURL.initClass = function () {
            this.prototype.type = 'OpenURL';
            this.define({
                url: [
                    p.String,
                    'http://'
                ]
            });
        };
        OpenURL.prototype.execute = function (_cb_obj, cb_data) {
            for (var _i = 0, _a = selection_1.get_indices(cb_data.source); _i < _a.length; _i++) {
                var i = _a[_i];
                var url = templating_1.replace_placeholders(this.url, cb_data.source, i);
                window.open(url);
            }
            return null;
        };
        return OpenURL;
    }(callback_1.Callback);
    exports.OpenURL = OpenURL;
    OpenURL.initClass();    
},
/*models/canvas/canvas*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var layout_canvas_1 = require(11    /* core/layout/layout_canvas */);
    var dom_view_1 = require(6    /* core/dom_view */);
    var solver_1 = require(13    /* core/layout/solver */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var dom_1 = require(5    /* core/dom */);
    var canvas_1 = require(26    /* core/util/canvas */);
    var canvas2svg = require(266    /* canvas2svg */);
    // XXX: no typings
    // fixes up a problem with some versions of IE11
    // ref: http://stackoverflow.com/questions/22062313/imagedata-set-in-internetexplorer
    if (window.CanvasPixelArray != null) {
        window.CanvasPixelArray.prototype.set = function (arr) {
            for (var i = 0; i < this.length; i++) {
                this[i] = arr[i];
            }
        };
    }
    var CanvasView = function (_super) {
        tslib_1.__extends(CanvasView, _super);
        function CanvasView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        CanvasView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.map_el = this.model.map ? this.el.appendChild(dom_1.div({ class: 'bk-canvas-map' })) : null;
            switch (this.model.output_backend) {
            case 'canvas':
            case 'webgl':
                this.canvas_el = this.el.appendChild(dom_1.canvas({ class: 'bk-canvas' }));
                this._ctx = this.canvas_el.getContext('2d');
                break;
            case 'svg':
                this._ctx = new canvas2svg();
                this.canvas_el = this.el.appendChild(this._ctx.getSvg());
                break;
            }
            this.overlays_el = this.el.appendChild(dom_1.div({ class: 'bk-canvas-overlays' }));
            this.events_el = this.el.appendChild(dom_1.div({ class: 'bk-canvas-events' }));
            this.ctx = this.get_ctx();
            // work around canvas incompatibilities
            canvas_1.fixup_ctx(this.ctx);
            logging_1.logger.debug('CanvasView initialized');
        };
        CanvasView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-canvas-wrapper');
        };
        // Method exists so that context can be stubbed in unit tests
        CanvasView.prototype.get_ctx = function () {
            return this._ctx;
        };
        CanvasView.prototype.get_canvas_element = function () {
            return this.canvas_el;
        };
        CanvasView.prototype.prepare_canvas = function () {
            // Ensure canvas has the correct size, taking HIDPI into account
            var width = this.model._width.value;
            var height = this.model._height.value;
            this.el.style.width = width + 'px';
            this.el.style.height = height + 'px';
            var pixel_ratio = canvas_1.get_scale_ratio(this.ctx, this.model.use_hidpi, this.model.output_backend);
            this.model.pixel_ratio = pixel_ratio;
            this.canvas_el.style.width = width + 'px';
            this.canvas_el.style.height = height + 'px';
            // XXX: io.export and canvas2svg don't like this
            // this.canvas_el.width = width*pixel_ratio
            // this.canvas_el.height = height*pixel_ratio
            this.canvas_el.setAttribute('width', '' + width * pixel_ratio);
            this.canvas_el.setAttribute('height', '' + height * pixel_ratio);
            logging_1.logger.debug('Rendering CanvasView with width: ' + width + ', height: ' + height + ', pixel ratio: ' + pixel_ratio);
        };
        CanvasView.prototype.set_dims = function (_a) {
            var width = _a[0], height = _a[1];
            // XXX: for whatever reason we need to protect against those nonsense values,
            //      that appear in the middle of updating layout. Otherwise we would get
            //      all possible errors from the layout solver.
            if (width == 0 || height == 0)
                return;
            if (width != this.model._width.value) {
                if (this._width_constraint != null && this.solver.has_constraint(this._width_constraint))
                    this.solver.remove_constraint(this._width_constraint);
                this._width_constraint = solver_1.EQ(this.model._width, -width);
                this.solver.add_constraint(this._width_constraint);
            }
            if (height != this.model._height.value) {
                if (this._height_constraint != null && this.solver.has_constraint(this._height_constraint))
                    this.solver.remove_constraint(this._height_constraint);
                this._height_constraint = solver_1.EQ(this.model._height, -height);
                this.solver.add_constraint(this._height_constraint);
            }
            this.solver.update_variables();
        };
        return CanvasView;
    }(dom_view_1.DOMView);
    exports.CanvasView = CanvasView;
    var Canvas = function (_super) {
        tslib_1.__extends(Canvas, _super);
        function Canvas(attrs) {
            return _super.call(this, attrs) || this;
        }
        Canvas.initClass = function () {
            this.prototype.type = 'Canvas';
            this.prototype.default_view = CanvasView;
            this.internal({
                map: [
                    p.Boolean,
                    false
                ],
                use_hidpi: [
                    p.Boolean,
                    true
                ],
                pixel_ratio: [
                    p.Number,
                    1
                ],
                output_backend: [
                    p.OutputBackend,
                    'canvas'
                ]
            });
        };
        Object.defineProperty(Canvas.prototype, 'panel', {
            get: function () {
                return this;
            },
            enumerable: true,
            configurable: true
        });
        return Canvas;
    }(layout_canvas_1.LayoutCanvas);
    exports.Canvas = Canvas;
    Canvas.initClass();    
},
/*models/canvas/cartesian_frame*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var categorical_scale_1 = require(174    /* ../scales/categorical_scale */);
    var linear_scale_1 = require(176    /* ../scales/linear_scale */);
    var log_scale_1 = require(177    /* ../scales/log_scale */);
    var range1d_1 = require(168    /* ../ranges/range1d */);
    var data_range1d_1 = require(164    /* ../ranges/data_range1d */);
    var factor_range_1 = require(165    /* ../ranges/factor_range */);
    var layout_canvas_1 = require(11    /* core/layout/layout_canvas */);
    var p = require(15    /* core/properties */);
    var CartesianFrame = function (_super) {
        tslib_1.__extends(CartesianFrame, _super);
        function CartesianFrame(attrs) {
            return _super.call(this, attrs) || this;
        }
        CartesianFrame.initClass = function () {
            this.prototype.type = 'CartesianFrame';
            this.internal({
                extra_x_ranges: [
                    p.Any,
                    {}
                ],
                extra_y_ranges: [
                    p.Any,
                    {}
                ],
                x_range: [p.Instance],
                y_range: [p.Instance],
                x_scale: [p.Instance],
                y_scale: [p.Instance]
            });
        };
        CartesianFrame.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._configure_scales();
        };
        CartesianFrame.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.change, function () {
                return _this._configure_scales();
            });
        };
        Object.defineProperty(CartesianFrame.prototype, 'panel', {
            get: function () {
                return this;
            },
            enumerable: true,
            configurable: true
        });
        CartesianFrame.prototype.get_editables = function () {
            return _super.prototype.get_editables.call(this).concat([
                this._width,
                this._height
            ]);
        };
        CartesianFrame.prototype.map_to_screen = function (x, y, x_name, y_name) {
            if (x_name === void 0) {
                x_name = 'default';
            }
            if (y_name === void 0) {
                y_name = 'default';
            }
            var sx = this.xscales[x_name].v_compute(x);
            var sy = this.yscales[y_name].v_compute(y);
            return [
                sx,
                sy
            ];
        };
        CartesianFrame.prototype._get_ranges = function (range, extra_ranges) {
            var ranges = {};
            ranges['default'] = range;
            if (extra_ranges != null) {
                for (var name_1 in extra_ranges)
                    ranges[name_1] = extra_ranges[name_1];
            }
            return ranges;
        };
        CartesianFrame.prototype._get_scales = function (scale, ranges, frame_range) {
            var scales = {};
            for (var name_2 in ranges) {
                var range = ranges[name_2];
                if (range instanceof data_range1d_1.DataRange1d || range instanceof range1d_1.Range1d) {
                    if (!(scale instanceof log_scale_1.LogScale) && !(scale instanceof linear_scale_1.LinearScale))
                        throw new Error('Range ' + range.type + ' is incompatible is Scale ' + scale.type);
                    // XXX: special case because CategoricalScale is a subclass of LinearScale, should be removed in future
                    if (scale instanceof categorical_scale_1.CategoricalScale)
                        throw new Error('Range ' + range.type + ' is incompatible is Scale ' + scale.type);
                }
                if (range instanceof factor_range_1.FactorRange) {
                    if (!(scale instanceof categorical_scale_1.CategoricalScale))
                        throw new Error('Range ' + range.type + ' is incompatible is Scale ' + scale.type);
                }
                if (scale instanceof log_scale_1.LogScale && range instanceof data_range1d_1.DataRange1d)
                    range.scale_hint = 'log';
                var s = scale.clone();
                s.setv({
                    source_range: range,
                    target_range: frame_range
                });
                scales[name_2] = s;
            }
            return scales;
        };
        CartesianFrame.prototype._configure_frame_ranges = function () {
            // data to/from screen space transform (left-bottom <-> left-top origin)
            this._h_target = new range1d_1.Range1d({
                start: this._left.value,
                end: this._right.value
            });
            this._v_target = new range1d_1.Range1d({
                start: this._bottom.value,
                end: this._top.value
            });
        };
        CartesianFrame.prototype._configure_scales = function () {
            this._configure_frame_ranges();
            this._x_ranges = this._get_ranges(this.x_range, this.extra_x_ranges);
            this._y_ranges = this._get_ranges(this.y_range, this.extra_y_ranges);
            this._xscales = this._get_scales(this.x_scale, this._x_ranges, this._h_target);
            this._yscales = this._get_scales(this.y_scale, this._y_ranges, this._v_target);
        };
        CartesianFrame.prototype.update_scales = function () {
            this._configure_frame_ranges();
            for (var name_3 in this._xscales) {
                var scale = this._xscales[name_3];
                scale.target_range = this._h_target;
            }
            for (var name_4 in this._yscales) {
                var scale = this._yscales[name_4];
                scale.target_range = this._v_target;
            }
        };
        Object.defineProperty(CartesianFrame.prototype, 'x_ranges', {
            get: function () {
                return this._x_ranges;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, 'y_ranges', {
            get: function () {
                return this._y_ranges;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, 'xscales', {
            get: function () {
                return this._xscales;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, 'yscales', {
            get: function () {
                return this._yscales;
            },
            enumerable: true,
            configurable: true
        });
        return CartesianFrame;
    }(layout_canvas_1.LayoutCanvas);
    exports.CartesianFrame = CartesianFrame;
    CartesianFrame.initClass();    
},
/*models/canvas/index*/
function _(require, module, exports) {
    var canvas_1 = require(84    /* ./canvas */);
    exports.Canvas = canvas_1.Canvas;
    var cartesian_frame_1 = require(85    /* ./cartesian_frame */);
    exports.CartesianFrame = cartesian_frame_1.CartesianFrame;    
},
/*models/expressions/expression*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var model_1 = require(53    /* ../../model */);
    var Expression = function (_super) {
        tslib_1.__extends(Expression, _super);
        function Expression(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this._connected = {};
            _this._result = {};
            return _this;
        }
        Expression.initClass = function () {
            this.prototype.type = 'Expression';
        };
        Expression.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._connected = {};
            this._result = {};
        };
        Expression.prototype.v_compute = function (source) {
            var _this = this;
            if (this._connected[source.id] == null) {
                this.connect(source.change, function () {
                    return delete _this._result[source.id];
                });
                this.connect(source.patching, function () {
                    return delete _this._result[source.id];
                });
                this.connect(source.streaming, function () {
                    return delete _this._result[source.id];
                });
                this._connected[source.id] = true;
            }
            var result = this._result[source.id];
            if (result == null)
                this._result[source.id] = result = this._v_compute(source);
            return result;
        };
        return Expression;
    }(model_1.Model);
    exports.Expression = Expression;
    Expression.initClass();    
},
/*models/expressions/index*/
function _(require, module, exports) {
    var expression_1 = require(87    /* ./expression */);
    exports.Expression = expression_1.Expression;
    var stack_1 = require(89    /* ./stack */);
    exports.Stack = stack_1.Stack;    
},
/*models/expressions/stack*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var expression_1 = require(87    /* ./expression */);
    var p = require(15    /* core/properties */);
    var Stack = function (_super) {
        tslib_1.__extends(Stack, _super);
        function Stack(attrs) {
            return _super.call(this, attrs) || this;
        }
        Stack.initClass = function () {
            this.prototype.type = 'Stack';
            this.define({
                fields: [
                    p.Array,
                    []
                ]
            });
        };
        Stack.prototype._v_compute = function (source) {
            var result = new Float64Array(source.get_length() || 0);
            for (var _i = 0, _a = this.fields; _i < _a.length; _i++) {
                var f = _a[_i];
                for (var i = 0; i < source.data[f].length; i++) {
                    var x = source.data[f][i];
                    result[i] += x;
                }
            }
            return result;
        };
        return Stack;
    }(expression_1.Expression);
    exports.Stack = Stack;
    Stack.initClass();    
},
/*models/filters/boolean_filter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var filter_1 = require(92    /* ./filter */);
    var p = require(15    /* core/properties */);
    var logging_1 = require(14    /* core/logging */);
    var array_1 = require(21    /* core/util/array */);
    var types_1 = require(44    /* core/util/types */);
    var BooleanFilter = function (_super) {
        tslib_1.__extends(BooleanFilter, _super);
        function BooleanFilter(attrs) {
            return _super.call(this, attrs) || this;
        }
        BooleanFilter.initClass = function () {
            this.prototype.type = 'BooleanFilter';
            this.define({
                booleans: [
                    p.Array,
                    null
                ]
            });
        };
        BooleanFilter.prototype.compute_indices = function (source) {
            var booleans = this.booleans;
            if (booleans != null && booleans.length > 0) {
                if (array_1.all(booleans, types_1.isBoolean)) {
                    if (booleans.length !== source.get_length()) {
                        logging_1.logger.warn('BooleanFilter ' + this.id + ': length of booleans doesn\'t match data source');
                    }
                    return array_1.range(0, booleans.length).filter(function (i) {
                        return booleans[i] === true;
                    });
                } else {
                    logging_1.logger.warn('BooleanFilter ' + this.id + ': booleans should be array of booleans, defaulting to no filtering');
                    return null;
                }
            } else {
                if (booleans != null && booleans.length == 0)
                    logging_1.logger.warn('BooleanFilter ' + this.id + ': booleans is empty, defaulting to no filtering');
                else
                    logging_1.logger.warn('BooleanFilter ' + this.id + ': booleans was not set, defaulting to no filtering');
                return null;
            }
        };
        return BooleanFilter;
    }(filter_1.Filter);
    exports.BooleanFilter = BooleanFilter;
    BooleanFilter.initClass();    
},
/*models/filters/customjs_filter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var filter_1 = require(92    /* ./filter */);
    var p = require(15    /* core/properties */);
    var object_1 = require(32    /* core/util/object */);
    var string_1 = require(38    /* core/util/string */);
    var CustomJSFilter = function (_super) {
        tslib_1.__extends(CustomJSFilter, _super);
        function CustomJSFilter(attrs) {
            return _super.call(this, attrs) || this;
        }
        CustomJSFilter.initClass = function () {
            this.prototype.type = 'CustomJSFilter';
            this.define({
                args: [
                    p.Any,
                    {}
                ],
                code: [
                    p.String,
                    ''
                ],
                use_strict: [
                    p.Boolean,
                    false
                ]
            });
        };
        Object.defineProperty(CustomJSFilter.prototype, 'names', {
            get: function () {
                return object_1.keys(this.args);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CustomJSFilter.prototype, 'values', {
            get: function () {
                return object_1.values(this.args);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CustomJSFilter.prototype, 'func', {
            get: function () {
                var code = this.use_strict ? string_1.use_strict(this.code) : this.code;
                return new (Function.bind.apply(Function, [void 0].concat(this.names, [
                    'source',
                    'require',
                    'exports',
                    code
                ])))();
            },
            enumerable: true,
            configurable: true
        });
        CustomJSFilter.prototype.compute_indices = function (source) {
            this.filter = this.func.apply(this, this.values.concat([
                source,
                require,
                {}
            ]));
            return _super.prototype.compute_indices.call(this, source);
        };
        return CustomJSFilter;
    }(filter_1.Filter);
    exports.CustomJSFilter = CustomJSFilter;
    CustomJSFilter.initClass();    
},
/*models/filters/filter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var model_1 = require(53    /* ../../model */);
    var p = require(15    /* core/properties */);
    var types_1 = require(44    /* core/util/types */);
    var array_1 = require(21    /* core/util/array */);
    var logging_1 = require(14    /* core/logging */);
    var Filter = function (_super) {
        tslib_1.__extends(Filter, _super);
        function Filter(attrs) {
            return _super.call(this, attrs) || this;
        }
        Filter.initClass = function () {
            this.prototype.type = 'Filter';
            this.define({
                filter: [
                    p.Array,
                    null
                ]
            });
        };
        Filter.prototype.compute_indices = function (_source) {
            var filter = this.filter;
            if (filter != null && filter.length >= 0) {
                if (types_1.isArrayOf(filter, types_1.isBoolean)) {
                    return array_1.range(0, filter.length).filter(function (i) {
                        return filter[i] === true;
                    });
                }
                if (types_1.isArrayOf(filter, types_1.isInteger)) {
                    return filter;
                }
                logging_1.logger.warn('Filter ' + this.id + ': filter should either be array of only booleans or only integers, defaulting to no filtering');
                return null;
            } else {
                logging_1.logger.warn('Filter ' + this.id + ': filter was not set to be an array, defaulting to no filtering');
                return null;
            }
        };
        return Filter;
    }(model_1.Model);
    exports.Filter = Filter;
    Filter.initClass();    
},
/*models/filters/group_filter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var filter_1 = require(92    /* ./filter */);
    var p = require(15    /* core/properties */);
    var logging_1 = require(14    /* core/logging */);
    var array_1 = require(21    /* core/util/array */);
    var GroupFilter = function (_super) {
        tslib_1.__extends(GroupFilter, _super);
        function GroupFilter(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this.indices = null;
            return _this;
        }
        GroupFilter.initClass = function () {
            this.prototype.type = 'GroupFilter';
            this.define({
                column_name: [p.String],
                group: [p.String]
            });
        };
        GroupFilter.prototype.compute_indices = function (source) {
            var _this = this;
            var column = source.get_column(this.column_name);
            if (column == null) {
                logging_1.logger.warn('group filter: groupby column not found in data source');
                return null;
            } else {
                this.indices = array_1.range(0, source.get_length() || 0).filter(function (i) {
                    return column[i] === _this.group;
                });
                if (this.indices.length === 0) {
                    logging_1.logger.warn('group filter: group \'' + this.group + '\' did not match any values in column \'' + this.column_name + '\'');
                }
                return this.indices;
            }
        };
        return GroupFilter;
    }(filter_1.Filter);
    exports.GroupFilter = GroupFilter;
    GroupFilter.initClass();    
},
/*models/filters/index*/
function _(require, module, exports) {
    var boolean_filter_1 = require(90    /* ./boolean_filter */);
    exports.BooleanFilter = boolean_filter_1.BooleanFilter;
    var customjs_filter_1 = require(91    /* ./customjs_filter */);
    exports.CustomJSFilter = customjs_filter_1.CustomJSFilter;
    var filter_1 = require(92    /* ./filter */);
    exports.Filter = filter_1.Filter;
    var group_filter_1 = require(93    /* ./group_filter */);
    exports.GroupFilter = group_filter_1.GroupFilter;
    var index_filter_1 = require(95    /* ./index_filter */);
    exports.IndexFilter = index_filter_1.IndexFilter;    
},
/*models/filters/index_filter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var filter_1 = require(92    /* ./filter */);
    var p = require(15    /* core/properties */);
    var logging_1 = require(14    /* core/logging */);
    var types_1 = require(44    /* core/util/types */);
    var array_1 = require(21    /* core/util/array */);
    var IndexFilter = function (_super) {
        tslib_1.__extends(IndexFilter, _super);
        function IndexFilter(attrs) {
            return _super.call(this, attrs) || this;
        }
        IndexFilter.initClass = function () {
            this.prototype.type = 'IndexFilter';
            this.define({
                indices: [
                    p.Array,
                    null
                ]
            });
        };
        IndexFilter.prototype.compute_indices = function (_source) {
            if (this.indices != null && this.indices.length >= 0) {
                if (array_1.all(this.indices, types_1.isInteger))
                    return this.indices;
                else {
                    logging_1.logger.warn('IndexFilter ' + this.id + ': indices should be array of integers, defaulting to no filtering');
                    return null;
                }
            } else {
                logging_1.logger.warn('IndexFilter ' + this.id + ': indices was not set, defaulting to no filtering');
                return null;
            }
        };
        return IndexFilter;
    }(filter_1.Filter);
    exports.IndexFilter = IndexFilter;
    IndexFilter.initClass();    
},
/*models/formatters/basic_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var tick_formatter_1 = require(105    /* ./tick_formatter */);
    var p = require(15    /* core/properties */);
    var types_1 = require(44    /* core/util/types */);
    var BasicTickFormatter = function (_super) {
        tslib_1.__extends(BasicTickFormatter, _super);
        function BasicTickFormatter(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this.last_precision = 3;
            return _this;
        }
        BasicTickFormatter.initClass = function () {
            this.prototype.type = 'BasicTickFormatter';
            this.define({
                precision: [
                    p.Any,
                    'auto'
                ],
                use_scientific: [
                    p.Bool,
                    true
                ],
                power_limit_high: [
                    p.Number,
                    5
                ],
                power_limit_low: [
                    p.Number,
                    -3
                ]
            });
        };
        Object.defineProperty(BasicTickFormatter.prototype, 'scientific_limit_low', {
            get: function () {
                return Math.pow(10, this.power_limit_low);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BasicTickFormatter.prototype, 'scientific_limit_high', {
            get: function () {
                return Math.pow(10, this.power_limit_high);
            },
            enumerable: true,
            configurable: true
        });
        BasicTickFormatter.prototype.doFormat = function (ticks, _axis) {
            if (ticks.length == 0)
                return [];
            var zero_eps = 0;
            if (ticks.length >= 2)
                zero_eps = Math.abs(ticks[1] - ticks[0]) / 10000;
            var need_sci = false;
            if (this.use_scientific) {
                for (var _i = 0, ticks_1 = ticks; _i < ticks_1.length; _i++) {
                    var tick = ticks_1[_i];
                    var tick_abs = Math.abs(tick);
                    if (tick_abs > zero_eps && (tick_abs >= this.scientific_limit_high || tick_abs <= this.scientific_limit_low)) {
                        need_sci = true;
                        break;
                    }
                }
            }
            var labels = new Array(ticks.length);
            var precision = this.precision;
            if (precision == null || types_1.isNumber(precision)) {
                if (need_sci) {
                    for (var i = 0, end = ticks.length; i < end; i++) {
                        labels[i] = ticks[i].toExponential(precision || undefined);
                    }
                } else {
                    for (var i = 0, end = ticks.length; i < end; i++) {
                        labels[i] = ticks[i].toFixed(precision || undefined).replace(/(\.[0-9]*?)0+$/, '$1').replace(/\.$/, '');
                    }
                }
            } else {
                for (var x = this.last_precision, asc = this.last_precision <= 15; asc ? x <= 15 : x >= 15; asc ? x++ : x--) {
                    var is_ok = true;
                    if (need_sci) {
                        for (var i = 0, end = ticks.length; i < end; i++) {
                            labels[i] = ticks[i].toExponential(x);
                            if (i > 0) {
                                if (labels[i] === labels[i - 1]) {
                                    is_ok = false;
                                    break;
                                }
                            }
                        }
                        if (is_ok) {
                            break;
                        }
                    } else {
                        for (var i = 0, end = ticks.length; i < end; i++) {
                            labels[i] = ticks[i].toFixed(x).replace(/(\.[0-9]*?)0+$/, '$1').replace(/\.$/, '');
                            if (i > 0) {
                                if (labels[i] == labels[i - 1]) {
                                    is_ok = false;
                                    break;
                                }
                            }
                        }
                        if (is_ok) {
                            break;
                        }
                    }
                    if (is_ok) {
                        this.last_precision = x;
                        break;
                    }
                }
            }
            return labels;
        };
        return BasicTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.BasicTickFormatter = BasicTickFormatter;
    BasicTickFormatter.initClass();    
},
/*models/formatters/categorical_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var tick_formatter_1 = require(105    /* ./tick_formatter */);
    var array_1 = require(21    /* core/util/array */);
    var CategoricalTickFormatter = function (_super) {
        tslib_1.__extends(CategoricalTickFormatter, _super);
        function CategoricalTickFormatter(attrs) {
            return _super.call(this, attrs) || this;
        }
        CategoricalTickFormatter.initClass = function () {
            this.prototype.type = 'CategoricalTickFormatter';
        };
        CategoricalTickFormatter.prototype.doFormat = function (ticks, _axis) {
            return array_1.copy(ticks);
        };
        return CategoricalTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.CategoricalTickFormatter = CategoricalTickFormatter;
    CategoricalTickFormatter.initClass();    
},
/*models/formatters/datetime_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var sprintf_js_1 = require(378    /* sprintf-js */);
    var tz = require(379    /* timezone */);
    var tick_formatter_1 = require(105    /* ./tick_formatter */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var array_1 = require(21    /* core/util/array */);
    var types_1 = require(44    /* core/util/types */);
    function _us(t) {
        // From double-precision unix (millisecond) timestamp get
        // microsecond since last second. Precision seems to run
        // out around the hundreds of nanoseconds scale, so rounding
        // to the nearest microsecond should round to a nice
        // microsecond / millisecond tick.
        return Math.round(t / 1000 % 1 * 1000000);
    }
    function _array(t) {
        return tz(t, '%Y %m %d %H %M %S').split(/\s+/).map(function (e) {
            return parseInt(e, 10);
        });
    }
    function _strftime(t, format) {
        if (types_1.isFunction(format)) {
            return format(t);
        } else {
            // Python's datetime library augments the microsecond directive %f, which is not
            // supported by the javascript library timezone: http://bigeasy.github.io/timezone/.
            // Use a regular expression to replace %f directive with microseconds.
            // TODO: what should we do for negative microsecond strings?
            var microsecond_replacement_string = sprintf_js_1.sprintf('$1%06d', _us(t));
            format = format.replace(/((^|[^%])(%%)*)%f/, microsecond_replacement_string);
            if (format.indexOf('%') == -1) {
                // timezone seems to ignore any strings without any formatting directives,
                // and just return the time argument back instead of the string argument.
                // But we want the string argument, in case a user supplies a format string
                // which doesn't contain a formatting directive or is only using %f.
                return format;
            }
            return tz(t, format);
        }
    }
    // Labels of time units, from finest to coarsest.
    var format_order = [
        'microseconds',
        'milliseconds',
        'seconds',
        'minsec',
        'minutes',
        'hourmin',
        'hours',
        'days',
        'months',
        'years'
    ];
    var DatetimeTickFormatter = function (_super) {
        tslib_1.__extends(DatetimeTickFormatter, _super);
        function DatetimeTickFormatter(attrs) {
            var _this = _super.call(this, attrs) || this;
            // Whether or not to strip the leading zeros on tick labels.
            _this.strip_leading_zeros = true;
            return _this;
        }
        DatetimeTickFormatter.initClass = function () {
            this.prototype.type = 'DatetimeTickFormatter';
            this.define({
                microseconds: [
                    p.Array,
                    ['%fus']
                ],
                milliseconds: [
                    p.Array,
                    [
                        '%3Nms',
                        '%S.%3Ns'
                    ]
                ],
                seconds: [
                    p.Array,
                    ['%Ss']
                ],
                minsec: [
                    p.Array,
                    [':%M:%S']
                ],
                minutes: [
                    p.Array,
                    [
                        ':%M',
                        '%Mm'
                    ]
                ],
                hourmin: [
                    p.Array,
                    ['%H:%M']
                ],
                hours: [
                    p.Array,
                    [
                        '%Hh',
                        '%H:%M'
                    ]
                ],
                days: [
                    p.Array,
                    [
                        '%m/%d',
                        '%a%d'
                    ]
                ],
                months: [
                    p.Array,
                    [
                        '%m/%Y',
                        '%b %Y'
                    ]
                ],
                years: [
                    p.Array,
                    ['%Y']
                ]
            });
        };
        DatetimeTickFormatter.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            // TODO (bev) trigger update on format change
            this._update_width_formats();
        };
        DatetimeTickFormatter.prototype._update_width_formats = function () {
            var now = +tz(new Date());
            var _widths = function (fmt_strings) {
                var sizes = fmt_strings.map(function (fmt_string) {
                    return _strftime(now, fmt_string).length;
                });
                var sorted = array_1.sortBy(array_1.zip(sizes, fmt_strings), function (_a) {
                    var size = _a[0];
                    return size;
                });
                return array_1.unzip(sorted);
            };
            this._width_formats = {
                microseconds: _widths(this.microseconds),
                milliseconds: _widths(this.milliseconds),
                seconds: _widths(this.seconds),
                minsec: _widths(this.minsec),
                minutes: _widths(this.minutes),
                hourmin: _widths(this.hourmin),
                hours: _widths(this.hours),
                days: _widths(this.days),
                months: _widths(this.months),
                years: _widths(this.years)
            };
        };
        // FIXME There is some unfortunate flicker when panning/zooming near the
        // span boundaries.
        // FIXME Rounding is weird at the 20-us scale and below.
        DatetimeTickFormatter.prototype._get_resolution_str = function (resolution_secs, span_secs) {
            // Our resolution boundaries should not be round numbers, because we want
            // them to fall between the possible tick intervals (which *are* round
            // numbers, as we've worked hard to ensure).  Consequently, we adjust the
            // resolution upwards a small amount (less than any possible step in
            // scales) to make the effective boundaries slightly lower.
            var adjusted_secs = resolution_secs * 1.1;
            switch (false) {
            case !(adjusted_secs < 0.001):
                return 'microseconds';
            case !(adjusted_secs < 1):
                return 'milliseconds';
            case !(adjusted_secs < 60):
                return span_secs >= 60 ? 'minsec' : 'seconds';
            case !(adjusted_secs < 3600):
                return span_secs >= 3600 ? 'hourmin' : 'minutes';
            case !(adjusted_secs < 24 * 3600):
                return 'hours';
            case !(adjusted_secs < 31 * 24 * 3600):
                return 'days';
            case !(adjusted_secs < 365 * 24 * 3600):
                return 'months';
            default:
                return 'years';
            }
        };
        DatetimeTickFormatter.prototype.doFormat = function (ticks, _axis) {
            // In order to pick the right set of labels, we need to determine
            // the resolution of the ticks.  We can do this using a ticker if
            // it's provided, or by computing the resolution from the actual
            // ticks we've been given.
            if (ticks.length == 0)
                return [];
            var span = Math.abs(ticks[ticks.length - 1] - ticks[0]) / 1000;
            var r = span / (ticks.length - 1);
            var resol = this._get_resolution_str(r, span);
            var _a = this._width_formats[resol], format = _a[1][0];
            // Apply the format to the tick values
            var labels = [];
            var resol_ndx = format_order.indexOf(resol);
            // This dictionary maps the name of a time resolution (in @format_order)
            // to its index in a time.localtime() timetuple.  The default is to map
            // everything to index 0, which is year.  This is not ideal; it might cause
            // a problem with the tick at midnight, january 1st, 0 a.d. being incorrectly
            // promoted at certain tick resolutions.
            var time_tuple_ndx_for_resol = {};
            for (var _i = 0, format_order_1 = format_order; _i < format_order_1.length; _i++) {
                var fmt = format_order_1[_i];
                time_tuple_ndx_for_resol[fmt] = 0;
            }
            time_tuple_ndx_for_resol['seconds'] = 5;
            time_tuple_ndx_for_resol['minsec'] = 4;
            time_tuple_ndx_for_resol['minutes'] = 4;
            time_tuple_ndx_for_resol['hourmin'] = 3;
            time_tuple_ndx_for_resol['hours'] = 3;
            // As we format each tick, check to see if we are at a boundary of the
            // next higher unit of time.  If so, replace the current format with one
            // from that resolution.  This is not the best heuristic in the world,
            // but it works!  There is some trickiness here due to having to deal
            // with hybrid formats in a reasonable manner.
            for (var _b = 0, ticks_1 = ticks; _b < ticks_1.length; _b++) {
                var t = ticks_1[_b];
                var s = void 0, tm = void 0;
                try {
                    tm = _array(t);
                    s = _strftime(t, format);
                } catch (error) {
                    logging_1.logger.warn('unable to format tick for timestamp value ' + t);
                    logging_1.logger.warn(' - ' + error);
                    labels.push('ERR');
                    continue;
                }
                var hybrid_handled = false;
                var next_ndx = resol_ndx;
                // The way to check that we are at the boundary of the next unit of
                // time is by checking that we have 0 units of the resolution, i.e.
                // we are at zero minutes, so display hours, or we are at zero seconds,
                // so display minutes (and if that is zero as well, then display hours).
                while (tm[time_tuple_ndx_for_resol[format_order[next_ndx]]] == 0) {
                    var next_format = void 0;
                    next_ndx += 1;
                    if (next_ndx == format_order.length)
                        break;
                    if ((resol == 'minsec' || resol == 'hourmin') && !hybrid_handled) {
                        if (resol == 'minsec' && tm[4] == 0 && tm[5] != 0 || resol == 'hourmin' && tm[3] == 0 && tm[4] != 0) {
                            next_format = this._width_formats[format_order[resol_ndx - 1]][1][0];
                            s = _strftime(t, next_format);
                            break;
                        } else {
                            hybrid_handled = true;
                        }
                    }
                    next_format = this._width_formats[format_order[next_ndx]][1][0];
                    s = _strftime(t, next_format);
                }
                // TODO: should expose this in api. %H, %d, etc use leading zeros and
                // users might prefer to see them lined up correctly.
                if (this.strip_leading_zeros) {
                    var ss = s.replace(/^0+/g, '');
                    if (ss != s && isNaN(parseInt(ss))) {
                        // If the string can now be parsed as starting with an integer, then
                        // leave all zeros stripped, otherwise start with a zero. Hence:
                        // A label such as '000ms' should leave one zero.
                        // A label such as '001ms' or '0-1ms' should not leave a leading zero.
                        ss = '0' + ss;
                    }
                    labels.push(ss);
                } else
                    labels.push(s);
            }
            return labels;
        };
        return DatetimeTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.DatetimeTickFormatter = DatetimeTickFormatter;
    DatetimeTickFormatter.initClass();    
},
/*models/formatters/func_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var tick_formatter_1 = require(105    /* ./tick_formatter */);
    var p = require(15    /* core/properties */);
    var object_1 = require(32    /* core/util/object */);
    var string_1 = require(38    /* core/util/string */);
    var FuncTickFormatter = function (_super) {
        tslib_1.__extends(FuncTickFormatter, _super);
        function FuncTickFormatter(attrs) {
            return _super.call(this, attrs) || this;
        }
        FuncTickFormatter.initClass = function () {
            this.prototype.type = 'FuncTickFormatter';
            this.define({
                args: [
                    p.Any,
                    {}
                ],
                code: [
                    p.String,
                    ''
                ],
                use_strict: [
                    p.Boolean,
                    false
                ]
            });
        };
        Object.defineProperty(FuncTickFormatter.prototype, 'names', {
            get: function () {
                return object_1.keys(this.args);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FuncTickFormatter.prototype, 'values', {
            get: function () {
                return object_1.values(this.args);
            },
            enumerable: true,
            configurable: true
        });
        FuncTickFormatter.prototype._make_func = function () {
            var code = this.use_strict ? string_1.use_strict(this.code) : this.code;
            return new (Function.bind.apply(Function, [
                void 0,
                'tick',
                'index',
                'ticks'
            ].concat(this.names, [
                'require',
                'exports',
                code
            ])))();
        };
        FuncTickFormatter.prototype.doFormat = function (ticks, _axis) {
            var _this = this;
            var cache = {};
            var func = this._make_func().bind(cache);
            return ticks.map(function (tick, index, ticks) {
                return func.apply(void 0, [
                    tick,
                    index,
                    ticks
                ].concat(_this.values, [
                    require,
                    {}
                ]));
            });
        };
        return FuncTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.FuncTickFormatter = FuncTickFormatter;
    FuncTickFormatter.initClass();    
},
/*models/formatters/index*/
function _(require, module, exports) {
    var basic_tick_formatter_1 = require(96    /* ./basic_tick_formatter */);
    exports.BasicTickFormatter = basic_tick_formatter_1.BasicTickFormatter;
    var categorical_tick_formatter_1 = require(97    /* ./categorical_tick_formatter */);
    exports.CategoricalTickFormatter = categorical_tick_formatter_1.CategoricalTickFormatter;
    var datetime_tick_formatter_1 = require(98    /* ./datetime_tick_formatter */);
    exports.DatetimeTickFormatter = datetime_tick_formatter_1.DatetimeTickFormatter;
    var func_tick_formatter_1 = require(99    /* ./func_tick_formatter */);
    exports.FuncTickFormatter = func_tick_formatter_1.FuncTickFormatter;
    var log_tick_formatter_1 = require(101    /* ./log_tick_formatter */);
    exports.LogTickFormatter = log_tick_formatter_1.LogTickFormatter;
    var mercator_tick_formatter_1 = require(102    /* ./mercator_tick_formatter */);
    exports.MercatorTickFormatter = mercator_tick_formatter_1.MercatorTickFormatter;
    var numeral_tick_formatter_1 = require(103    /* ./numeral_tick_formatter */);
    exports.NumeralTickFormatter = numeral_tick_formatter_1.NumeralTickFormatter;
    var printf_tick_formatter_1 = require(104    /* ./printf_tick_formatter */);
    exports.PrintfTickFormatter = printf_tick_formatter_1.PrintfTickFormatter;
    var tick_formatter_1 = require(105    /* ./tick_formatter */);
    exports.TickFormatter = tick_formatter_1.TickFormatter;    
},
/*models/formatters/log_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var tick_formatter_1 = require(105    /* ./tick_formatter */);
    var basic_tick_formatter_1 = require(96    /* ./basic_tick_formatter */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var LogTickFormatter = function (_super) {
        tslib_1.__extends(LogTickFormatter, _super);
        function LogTickFormatter(attrs) {
            return _super.call(this, attrs) || this;
        }
        LogTickFormatter.initClass = function () {
            this.prototype.type = 'LogTickFormatter';
            this.define({
                ticker: [
                    p.Instance,
                    null
                ]
            });
        };
        LogTickFormatter.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.basic_formatter = new basic_tick_formatter_1.BasicTickFormatter();
            if (this.ticker == null)
                logging_1.logger.warn('LogTickFormatter not configured with a ticker, using default base of 10 (labels will be incorrect if ticker base is not 10)');
        };
        LogTickFormatter.prototype.doFormat = function (ticks, axis) {
            if (ticks.length == 0)
                return [];
            var base = this.ticker != null ? this.ticker.base : 10;
            var small_interval = false;
            var labels = new Array(ticks.length);
            for (var i = 0, end = ticks.length; i < end; i++) {
                labels[i] = base + '^' + Math.round(Math.log(ticks[i]) / Math.log(base));
                if (i > 0 && labels[i] == labels[i - 1]) {
                    small_interval = true;
                    break;
                }
            }
            if (small_interval)
                return this.basic_formatter.doFormat(ticks, axis);
            else
                return labels;
        };
        return LogTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.LogTickFormatter = LogTickFormatter;
    LogTickFormatter.initClass();    
},
/*models/formatters/mercator_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var basic_tick_formatter_1 = require(96    /* ./basic_tick_formatter */);
    var p = require(15    /* core/properties */);
    var projections_1 = require(33    /* core/util/projections */);
    var MercatorTickFormatter = function (_super) {
        tslib_1.__extends(MercatorTickFormatter, _super);
        function MercatorTickFormatter(attrs) {
            return _super.call(this, attrs) || this;
        }
        MercatorTickFormatter.initClass = function () {
            this.prototype.type = 'MercatorTickFormatter';
            this.define({ dimension: [p.LatLon] });
        };
        MercatorTickFormatter.prototype.doFormat = function (ticks, axis) {
            if (this.dimension == null)
                throw new Error('MercatorTickFormatter.dimension not configured');
            if (ticks.length == 0)
                return [];
            var n = ticks.length;
            var proj_ticks = new Array(n);
            if (this.dimension == 'lon') {
                for (var i = 0; i < n; i++) {
                    var lon = projections_1.wgs84_mercator.inverse([
                        ticks[i],
                        axis.loc
                    ])[0];
                    proj_ticks[i] = lon;
                }
            } else {
                for (var i = 0; i < n; i++) {
                    var _a = projections_1.wgs84_mercator.inverse([
                            axis.loc,
                            ticks[i]
                        ]), lat = _a[1];
                    proj_ticks[i] = lat;
                }
            }
            return _super.prototype.doFormat.call(this, proj_ticks, axis);
        };
        return MercatorTickFormatter;
    }(basic_tick_formatter_1.BasicTickFormatter);
    exports.MercatorTickFormatter = MercatorTickFormatter;
    MercatorTickFormatter.initClass();    
},
/*models/formatters/numeral_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var Numbro = require(350    /* numbro */);
    var tick_formatter_1 = require(105    /* ./tick_formatter */);
    var p = require(15    /* core/properties */);
    var NumeralTickFormatter = function (_super) {
        tslib_1.__extends(NumeralTickFormatter, _super);
        function NumeralTickFormatter(attrs) {
            return _super.call(this, attrs) || this;
        }
        NumeralTickFormatter.initClass = function () {
            this.prototype.type = 'NumeralTickFormatter';
            this.define({
                // TODO (bev) all of these could be tightened up
                format: [
                    p.String,
                    '0,0'
                ],
                language: [
                    p.String,
                    'en'
                ],
                rounding: [
                    p.String,
                    'round'
                ]
            });
        };
        Object.defineProperty(NumeralTickFormatter.prototype, '_rounding_fn', {
            get: function () {
                switch (this.rounding) {
                case 'round':
                case 'nearest':
                    return Math.round;
                case 'floor':
                case 'rounddown':
                    return Math.floor;
                case 'ceil':
                case 'roundup':
                    return Math.ceil;
                }
            },
            enumerable: true,
            configurable: true
        });
        NumeralTickFormatter.prototype.doFormat = function (ticks, _axis) {
            var _a = this, format = _a.format, language = _a.language, _rounding_fn = _a._rounding_fn;
            return ticks.map(function (tick) {
                return Numbro.format(tick, format, language, _rounding_fn);
            });
        };
        return NumeralTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.NumeralTickFormatter = NumeralTickFormatter;
    NumeralTickFormatter.initClass();    
},
/*models/formatters/printf_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var sprintf_js_1 = require(378    /* sprintf-js */);
    var tick_formatter_1 = require(105    /* ./tick_formatter */);
    var p = require(15    /* core/properties */);
    var PrintfTickFormatter = function (_super) {
        tslib_1.__extends(PrintfTickFormatter, _super);
        function PrintfTickFormatter(attrs) {
            return _super.call(this, attrs) || this;
        }
        PrintfTickFormatter.initClass = function () {
            this.prototype.type = 'PrintfTickFormatter';
            this.define({
                format: [
                    p.String,
                    '%s'
                ]
            });
        };
        PrintfTickFormatter.prototype.doFormat = function (ticks, _axis) {
            var _this = this;
            return ticks.map(function (tick) {
                return sprintf_js_1.sprintf(_this.format, tick);
            });
        };
        return PrintfTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.PrintfTickFormatter = PrintfTickFormatter;
    PrintfTickFormatter.initClass();    
},
/*models/formatters/tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var model_1 = require(53    /* ../../model */);
    var TickFormatter = function (_super) {
        tslib_1.__extends(TickFormatter, _super);
        function TickFormatter(attrs) {
            return _super.call(this, attrs) || this;
        }
        TickFormatter.initClass = function () {
            this.prototype.type = 'TickFormatter';
        };
        return TickFormatter;
    }(model_1.Model);
    exports.TickFormatter = TickFormatter;
    TickFormatter.initClass();    
},
/*models/glyphs/annular_wedge*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var utils_1 = require(132    /* ./utils */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var math_1 = require(31    /* core/util/math */);
    var AnnularWedgeView = function (_super) {
        tslib_1.__extends(AnnularWedgeView, _super);
        function AnnularWedgeView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AnnularWedgeView.prototype._map_data = function () {
            if (this.model.properties.inner_radius.units == 'data')
                this.sinner_radius = this.sdist(this.renderer.xscale, this._x, this._inner_radius);
            else
                this.sinner_radius = this._inner_radius;
            if (this.model.properties.outer_radius.units == 'data')
                this.souter_radius = this.sdist(this.renderer.xscale, this._x, this._outer_radius);
            else
                this.souter_radius = this._outer_radius;
            this._angle = new Float32Array(this._start_angle.length);
            for (var i = 0, end = this._start_angle.length; i < end; i++) {
                this._angle[i] = this._end_angle[i] - this._start_angle[i];
            }
        };
        AnnularWedgeView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, _start_angle = _a._start_angle, _angle = _a._angle, sinner_radius = _a.sinner_radius, souter_radius = _a.souter_radius;
            var direction = this.model.properties.direction.value();
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sinner_radius[i] + souter_radius[i] + _start_angle[i] + _angle[i]))
                    continue;
                ctx.translate(sx[i], sy[i]);
                ctx.rotate(_start_angle[i]);
                ctx.moveTo(souter_radius[i], 0);
                ctx.beginPath();
                ctx.arc(0, 0, souter_radius[i], 0, _angle[i], direction);
                ctx.rotate(_angle[i]);
                ctx.lineTo(sinner_radius[i], 0);
                ctx.arc(0, 0, sinner_radius[i], 0, -_angle[i], !direction);
                ctx.closePath();
                ctx.rotate(-_angle[i] - _start_angle[i]);
                ctx.translate(-sx[i], -sy[i]);
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        AnnularWedgeView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            // check radius first
            var x0, y0;
            var x1, y1;
            if (this.model.properties.outer_radius.units == 'data') {
                x0 = x - this.max_outer_radius;
                x1 = x + this.max_outer_radius;
                y0 = y - this.max_outer_radius;
                y1 = y + this.max_outer_radius;
            } else {
                var sx0 = sx - this.max_outer_radius;
                var sx1 = sx + this.max_outer_radius;
                _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
                var sy0 = sy - this.max_outer_radius;
                var sy1 = sy + this.max_outer_radius;
                _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            }
            var candidates = [];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            for (var _i = 0, _c = this.index.indices(bbox); _i < _c.length; _i++) {
                var i = _c[_i];
                var or2 = Math.pow(this.souter_radius[i], 2);
                var ir2 = Math.pow(this.sinner_radius[i], 2);
                var _d = this.renderer.xscale.r_compute(x, this._x[i]), sx0 = _d[0], sx1 = _d[1];
                var _e = this.renderer.yscale.r_compute(y, this._y[i]), sy0 = _e[0], sy1 = _e[1];
                var dist = Math.pow(sx0 - sx1, 2) + Math.pow(sy0 - sy1, 2);
                if (dist <= or2 && dist >= ir2)
                    candidates.push([
                        i,
                        dist
                    ]);
            }
            var direction = this.model.properties.direction.value();
            var hits = [];
            for (var _f = 0, candidates_1 = candidates; _f < candidates_1.length; _f++) {
                var _g = candidates_1[_f], i = _g[0], dist = _g[1];
                // NOTE: minus the angle because JS uses non-mathy convention for angles
                var angle = Math.atan2(sy - this.sy[i], sx - this.sx[i]);
                if (math_1.angle_between(-angle, -this._start_angle[i], -this._end_angle[i], direction)) {
                    hits.push([
                        i,
                        dist
                    ]);
                }
            }
            return hittest.create_hit_test_result_from_hits(hits);
            var _a, _b;
        };
        AnnularWedgeView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_area_legend(this.visuals, ctx, bbox, index);
        };
        AnnularWedgeView.prototype._scenterxy = function (i) {
            var r = (this.sinner_radius[i] + this.souter_radius[i]) / 2;
            var a = (this._start_angle[i] + this._end_angle[i]) / 2;
            return {
                x: this.sx[i] + r * Math.cos(a),
                y: this.sy[i] + r * Math.sin(a)
            };
        };
        AnnularWedgeView.prototype.scenterx = function (i) {
            return this._scenterxy(i).x;
        };
        AnnularWedgeView.prototype.scentery = function (i) {
            return this._scenterxy(i).y;
        };
        return AnnularWedgeView;
    }(xy_glyph_1.XYGlyphView);
    exports.AnnularWedgeView = AnnularWedgeView;
    var AnnularWedge = function (_super) {
        tslib_1.__extends(AnnularWedge, _super);
        function AnnularWedge(attrs) {
            return _super.call(this, attrs) || this;
        }
        AnnularWedge.initClass = function () {
            this.prototype.type = 'AnnularWedge';
            this.prototype.default_view = AnnularWedgeView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                direction: [
                    p.Direction,
                    'anticlock'
                ],
                inner_radius: [p.DistanceSpec],
                outer_radius: [p.DistanceSpec],
                start_angle: [p.AngleSpec],
                end_angle: [p.AngleSpec]
            });
        };
        return AnnularWedge;
    }(xy_glyph_1.XYGlyph);
    exports.AnnularWedge = AnnularWedge;
    AnnularWedge.initClass();    
},
/*models/glyphs/annulus*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var compat_1 = require(28    /* core/util/compat */);
    var AnnulusView = function (_super) {
        tslib_1.__extends(AnnulusView, _super);
        function AnnulusView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AnnulusView.prototype._map_data = function () {
            if (this.model.properties.inner_radius.units == 'data')
                this.sinner_radius = this.sdist(this.renderer.xscale, this._x, this._inner_radius);
            else
                this.sinner_radius = this._inner_radius;
            if (this.model.properties.outer_radius.units == 'data')
                this.souter_radius = this.sdist(this.renderer.xscale, this._x, this._outer_radius);
            else
                this.souter_radius = this._outer_radius;
        };
        AnnulusView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sinner_radius = _a.sinner_radius, souter_radius = _a.souter_radius;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sinner_radius[i] + souter_radius[i]))
                    continue;
                // Because this visual has a whole in it, it proved "challenging"
                // for some browsers to render if drawn in one go --- i.e. it did not
                // work on IE. If we render in two parts (upper and lower part),
                // it is unambiguous what part should be filled. The line is
                // better drawn in one go though, otherwise the part where the pieces
                // meet will not be fully closed due to aa.
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.beginPath();
                    if (compat_1.is_ie) {
                        // Draw two halves of the donut. Works on IE, but causes an aa line on Safari.
                        for (var _b = 0, _c = [
                                    false,
                                    true
                                ]; _b < _c.length; _b++) {
                            var clockwise = _c[_b];
                            ctx.arc(sx[i], sy[i], sinner_radius[i], 0, Math.PI, clockwise);
                            ctx.arc(sx[i], sy[i], souter_radius[i], Math.PI, 0, !clockwise);
                        }
                    } else {
                        // Draw donut in one go. Does not work on iE.
                        ctx.arc(sx[i], sy[i], sinner_radius[i], 0, 2 * Math.PI, true);
                        ctx.arc(sx[i], sy[i], souter_radius[i], 2 * Math.PI, 0, false);
                    }
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.beginPath();
                    ctx.arc(sx[i], sy[i], sinner_radius[i], 0, 2 * Math.PI);
                    ctx.moveTo(sx[i] + souter_radius[i], sy[i]);
                    ctx.arc(sx[i], sy[i], souter_radius[i], 0, 2 * Math.PI);
                    ctx.stroke();
                }
            }
        };
        AnnulusView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var x0 = x - this.max_outer_radius;
            var x1 = x + this.max_outer_radius;
            var y = this.renderer.yscale.invert(sy);
            var y0 = y - this.max_outer_radius;
            var y1 = y + this.max_outer_radius;
            var hits = [];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            for (var _i = 0, _a = this.index.indices(bbox); _i < _a.length; _i++) {
                var i = _a[_i];
                var or2 = Math.pow(this.souter_radius[i], 2);
                var ir2 = Math.pow(this.sinner_radius[i], 2);
                var _b = this.renderer.xscale.r_compute(x, this._x[i]), sx0 = _b[0], sx1 = _b[1];
                var _c = this.renderer.yscale.r_compute(y, this._y[i]), sy0 = _c[0], sy1 = _c[1];
                var dist = Math.pow(sx0 - sx1, 2) + Math.pow(sy0 - sy1, 2);
                if (dist <= or2 && dist >= ir2)
                    hits.push([
                        i,
                        dist
                    ]);
            }
            return hittest.create_hit_test_result_from_hits(hits);
        };
        AnnulusView.prototype.draw_legend_for_index = function (ctx, _a, index) {
            var x0 = _a.x0, y0 = _a.y0, x1 = _a.x1, y1 = _a.y1;
            var len = index + 1;
            var sx = new Array(len);
            sx[index] = (x0 + x1) / 2;
            var sy = new Array(len);
            sy[index] = (y0 + y1) / 2;
            var r = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.5;
            var sinner_radius = new Array(len);
            sinner_radius[index] = r * 0.4;
            var souter_radius = new Array(len);
            souter_radius[index] = r * 0.8;
            this._render(ctx, [index], {
                sx: sx,
                sy: sy,
                sinner_radius: sinner_radius,
                souter_radius: souter_radius
            });    // XXX
        };
        return AnnulusView;
    }(xy_glyph_1.XYGlyphView);
    exports.AnnulusView = AnnulusView;
    var Annulus = function (_super) {
        tslib_1.__extends(Annulus, _super);
        function Annulus(attrs) {
            return _super.call(this, attrs) || this;
        }
        Annulus.initClass = function () {
            this.prototype.type = 'Annulus';
            this.prototype.default_view = AnnulusView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                inner_radius: [p.DistanceSpec],
                outer_radius: [p.DistanceSpec]
            });
        };
        return Annulus;
    }(xy_glyph_1.XYGlyph);
    exports.Annulus = Annulus;
    Annulus.initClass();    
},
/*models/glyphs/arc*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var utils_1 = require(132    /* ./utils */);
    var p = require(15    /* core/properties */);
    var ArcView = function (_super) {
        tslib_1.__extends(ArcView, _super);
        function ArcView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ArcView.prototype._map_data = function () {
            if (this.model.properties.radius.units == 'data')
                this.sradius = this.sdist(this.renderer.xscale, this._x, this._radius);
            else
                this.sradius = this._radius;
        };
        ArcView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sradius = _a.sradius, _start_angle = _a._start_angle, _end_angle = _a._end_angle;
            if (this.visuals.line.doit) {
                var direction = this.model.properties.direction.value();
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (isNaN(sx[i] + sy[i] + sradius[i] + _start_angle[i] + _end_angle[i]))
                        continue;
                    ctx.beginPath();
                    ctx.arc(sx[i], sy[i], sradius[i], _start_angle[i], _end_angle[i], direction);
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        ArcView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_line_legend(this.visuals, ctx, bbox, index);
        };
        return ArcView;
    }(xy_glyph_1.XYGlyphView);
    exports.ArcView = ArcView;
    var Arc = function (_super) {
        tslib_1.__extends(Arc, _super);
        function Arc(attrs) {
            return _super.call(this, attrs) || this;
        }
        Arc.initClass = function () {
            this.prototype.type = 'Arc';
            this.prototype.default_view = ArcView;
            this.mixins(['line']);
            this.define({
                direction: [
                    p.Direction,
                    'anticlock'
                ],
                radius: [p.DistanceSpec],
                start_angle: [p.AngleSpec],
                end_angle: [p.AngleSpec]
            });
        };
        return Arc;
    }(xy_glyph_1.XYGlyph);
    exports.Arc = Arc;
    Arc.initClass();    
},
/*models/glyphs/bezier*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var glyph_1 = require(113    /* ./glyph */);
    var utils_1 = require(132    /* ./utils */);
    // algorithm adapted from http://stackoverflow.com/a/14429749/3406693
    function _cbb(x0, y0, x1, y1, x2, y2, x3, y3) {
        var tvalues = [];
        var bounds = [
            [],
            []
        ];
        for (var i = 0; i <= 2; i++) {
            var a = void 0, b = void 0, c = void 0;
            if (i === 0) {
                b = 6 * x0 - 12 * x1 + 6 * x2;
                a = -3 * x0 + 9 * x1 - 9 * x2 + 3 * x3;
                c = 3 * x1 - 3 * x0;
            } else {
                b = 6 * y0 - 12 * y1 + 6 * y2;
                a = -3 * y0 + 9 * y1 - 9 * y2 + 3 * y3;
                c = 3 * y1 - 3 * y0;
            }
            if (Math.abs(a) < 1e-12) {
                // Numerical robustness
                if (Math.abs(b) < 1e-12)
                    // Numerical robustness
                    continue;
                var t = -c / b;
                if (0 < t && t < 1)
                    tvalues.push(t);
                continue;
            }
            var b2ac = b * b - 4 * c * a;
            var sqrtb2ac = Math.sqrt(b2ac);
            if (b2ac < 0)
                continue;
            var t1 = (-b + sqrtb2ac) / (2 * a);
            if (0 < t1 && t1 < 1)
                tvalues.push(t1);
            var t2 = (-b - sqrtb2ac) / (2 * a);
            if (0 < t2 && t2 < 1)
                tvalues.push(t2);
        }
        var j = tvalues.length;
        var jlen = j;
        while (j--) {
            var t = tvalues[j];
            var mt = 1 - t;
            var x = mt * mt * mt * x0 + 3 * mt * mt * t * x1 + 3 * mt * t * t * x2 + t * t * t * x3;
            bounds[0][j] = x;
            var y = mt * mt * mt * y0 + 3 * mt * mt * t * y1 + 3 * mt * t * t * y2 + t * t * t * y3;
            bounds[1][j] = y;
        }
        bounds[0][jlen] = x0;
        bounds[1][jlen] = y0;
        bounds[0][jlen + 1] = x3;
        bounds[1][jlen + 1] = y3;
        return [
            Math.min.apply(Math, bounds[0]),
            Math.max.apply(Math, bounds[1]),
            Math.max.apply(Math, bounds[0]),
            Math.min.apply(Math, bounds[1])
        ];
    }
    var BezierView = function (_super) {
        tslib_1.__extends(BezierView, _super);
        function BezierView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BezierView.prototype._index_data = function () {
            var points = [];
            for (var i = 0, end = this._x0.length; i < end; i++) {
                if (isNaN(this._x0[i] + this._x1[i] + this._y0[i] + this._y1[i] + this._cx0[i] + this._cy0[i] + this._cx1[i] + this._cy1[i]))
                    continue;
                var _a = _cbb(this._x0[i], this._y0[i], this._x1[i], this._y1[i], this._cx0[i], this._cy0[i], this._cx1[i], this._cy1[i]), x0 = _a[0], y0 = _a[1], x1 = _a[2], y1 = _a[3];
                points.push({
                    minX: x0,
                    minY: y0,
                    maxX: x1,
                    maxY: y1,
                    i: i
                });
            }
            return new spatial_1.SpatialIndex(points);
        };
        BezierView.prototype._render = function (ctx, indices, _a) {
            var sx0 = _a.sx0, sy0 = _a.sy0, sx1 = _a.sx1, sy1 = _a.sy1, scx0 = _a.scx0, scy0 = _a.scy0, scx1 = _a.scx1, scy1 = _a.scy1;
            if (this.visuals.line.doit) {
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (isNaN(sx0[i] + sy0[i] + sx1[i] + sy1[i] + scx0[i] + scy0[i] + scx1[i] + scy1[i]))
                        continue;
                    ctx.beginPath();
                    ctx.moveTo(sx0[i], sy0[i]);
                    ctx.bezierCurveTo(scx0[i], scy0[i], scx1[i], scy1[i], sx1[i], sy1[i]);
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        BezierView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_line_legend(this.visuals, ctx, bbox, index);
        };
        BezierView.prototype.scenterx = function () {
            throw new Error('not implemented');
        };
        BezierView.prototype.scentery = function () {
            throw new Error('not implemented');
        };
        return BezierView;
    }(glyph_1.GlyphView);
    exports.BezierView = BezierView;
    var Bezier = function (_super) {
        tslib_1.__extends(Bezier, _super);
        function Bezier(attrs) {
            return _super.call(this, attrs) || this;
        }
        Bezier.initClass = function () {
            this.prototype.type = 'Bezier';
            this.prototype.default_view = BezierView;
            this.coords([
                [
                    'x0',
                    'y0'
                ],
                [
                    'x1',
                    'y1'
                ],
                [
                    'cx0',
                    'cy0'
                ],
                [
                    'cx1',
                    'cy1'
                ]
            ]);
            this.mixins(['line']);
        };
        return Bezier;
    }(glyph_1.Glyph);
    exports.Bezier = Bezier;
    Bezier.initClass();    
},
/*models/glyphs/box*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var glyph_1 = require(113    /* ./glyph */);
    var utils_1 = require(132    /* ./utils */);
    var hittest = require(9    /* core/hittest */);
    var BoxView = function (_super) {
        tslib_1.__extends(BoxView, _super);
        function BoxView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BoxView.prototype._index_box = function (len) {
            var points = [];
            for (var i = 0; i < len; i++) {
                var _a = this._lrtb(i), l = _a[0], r = _a[1], t = _a[2], b = _a[3];
                if (isNaN(l + r + t + b) || !isFinite(l + r + t + b))
                    continue;
                points.push({
                    minX: l,
                    minY: b,
                    maxX: r,
                    maxY: t,
                    i: i
                });
            }
            return new spatial_1.SpatialIndex(points);
        };
        BoxView.prototype._render = function (ctx, indices, _a) {
            var sleft = _a.sleft, sright = _a.sright, stop = _a.stop, sbottom = _a.sbottom;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sleft[i] + stop[i] + sright[i] + sbottom[i]))
                    continue;
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.fillRect(sleft[i], stop[i], sright[i] - sleft[i], sbottom[i] - stop[i]);
                }
                if (this.visuals.line.doit) {
                    ctx.beginPath();
                    ctx.rect(sleft[i], stop[i], sright[i] - sleft[i], sbottom[i] - stop[i]);
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        BoxView.prototype._hit_rect = function (geometry) {
            return this._hit_rect_against_index(geometry);
        };
        BoxView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            var hits = this.index.indices({
                minX: x,
                minY: y,
                maxX: x,
                maxY: y
            });
            var result = hittest.create_empty_hit_test_result();
            result.indices = hits;
            return result;
        };
        BoxView.prototype._hit_span = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var hits;
            if (geometry.direction == 'v') {
                var y = this.renderer.yscale.invert(sy);
                var hr = this.renderer.plot_view.frame.bbox.h_range;
                var _a = this.renderer.xscale.r_invert(hr.start, hr.end), minX = _a[0], maxX = _a[1];
                hits = this.index.indices({
                    minX: minX,
                    minY: y,
                    maxX: maxX,
                    maxY: y
                });
            } else {
                var x = this.renderer.xscale.invert(sx);
                var vr = this.renderer.plot_view.frame.bbox.v_range;
                var _b = this.renderer.yscale.r_invert(vr.start, vr.end), minY = _b[0], maxY = _b[1];
                hits = this.index.indices({
                    minX: x,
                    minY: minY,
                    maxX: x,
                    maxY: maxY
                });
            }
            var result = hittest.create_empty_hit_test_result();
            result.indices = hits;
            return result;
        };
        BoxView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_area_legend(this.visuals, ctx, bbox, index);
        };
        return BoxView;
    }(glyph_1.GlyphView);
    exports.BoxView = BoxView;
    var Box = function (_super) {
        tslib_1.__extends(Box, _super);
        function Box(attrs) {
            return _super.call(this, attrs) || this;
        }
        Box.initClass = function () {
            this.prototype.type = 'Box';
            this.mixins([
                'line',
                'fill'
            ]);
        };
        return Box;
    }(glyph_1.Glyph);
    exports.Box = Box;
    Box.initClass();    
},
/*models/glyphs/circle*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var array_1 = require(21    /* core/util/array */);
    var arrayable_1 = require(22    /* core/util/arrayable */);
    var CircleView = function (_super) {
        tslib_1.__extends(CircleView, _super);
        function CircleView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        CircleView.prototype._map_data = function () {
            // XXX: Order is important here: size is always present (at least
            // a default), but radius is only present if a user specifies it.
            if (this._radius != null) {
                if (this.model.properties.radius.spec.units == 'data') {
                    var rd = this.model.properties.radius_dimension.spec.value;
                    switch (rd) {
                    case 'x': {
                            this.sradius = this.sdist(this.renderer.xscale, this._x, this._radius);
                            break;
                        }
                    case 'y': {
                            this.sradius = this.sdist(this.renderer.yscale, this._y, this._radius);
                            break;
                        }
                    }
                } else {
                    this.sradius = this._radius;
                    this.max_size = 2 * this.max_radius;
                }
            } else
                this.sradius = arrayable_1.map(this._size, function (s) {
                    return s / 2;
                });
        };
        CircleView.prototype._mask_data = function () {
            var _a = this.renderer.plot_view.frame.bbox.ranges, hr = _a[0], vr = _a[1];
            var x0, y0;
            var x1, y1;
            if (this._radius != null && this.model.properties.radius.units == 'data') {
                var sx0 = hr.start;
                var sx1 = hr.end;
                _b = this.renderer.xscale.r_invert(sx0, sx1), x0 = _b[0], x1 = _b[1];
                x0 -= this.max_radius;
                x1 += this.max_radius;
                var sy0 = vr.start;
                var sy1 = vr.end;
                _c = this.renderer.yscale.r_invert(sy0, sy1), y0 = _c[0], y1 = _c[1];
                y0 -= this.max_radius;
                y1 += this.max_radius;
            } else {
                var sx0 = hr.start - this.max_size;
                var sx1 = hr.end + this.max_size;
                _d = this.renderer.xscale.r_invert(sx0, sx1), x0 = _d[0], x1 = _d[1];
                var sy0 = vr.start - this.max_size;
                var sy1 = vr.end + this.max_size;
                _e = this.renderer.yscale.r_invert(sy0, sy1), y0 = _e[0], y1 = _e[1];
            }
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            return this.index.indices(bbox);
            var _b, _c, _d, _e;
        };
        CircleView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sradius = _a.sradius;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sradius[i]))
                    continue;
                ctx.beginPath();
                ctx.arc(sx[i], sy[i], sradius[i], 0, 2 * Math.PI, false);
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        CircleView.prototype._hit_point = function (geometry) {
            var dist, r2, sx0, sx1, sy0, sy1, x0, x1, y0, y1;
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            // check radius first
            if (this._radius != null && this.model.properties.radius.units == 'data') {
                x0 = x - this.max_radius;
                x1 = x + this.max_radius;
                y0 = y - this.max_radius;
                y1 = y + this.max_radius;
            } else {
                sx0 = sx - this.max_size;
                sx1 = sx + this.max_size;
                _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
                _b = [
                    Math.min(x0, x1),
                    Math.max(x0, x1)
                ], x0 = _b[0], x1 = _b[1];
                sy0 = sy - this.max_size;
                sy1 = sy + this.max_size;
                _c = this.renderer.yscale.r_invert(sy0, sy1), y0 = _c[0], y1 = _c[1];
                _d = [
                    Math.min(y0, y1),
                    Math.max(y0, y1)
                ], y0 = _d[0], y1 = _d[1];
            }
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var candidates = this.index.indices(bbox);
            var hits = [];
            if (this._radius != null && this.model.properties.radius.units == 'data') {
                for (var _i = 0, candidates_1 = candidates; _i < candidates_1.length; _i++) {
                    var i = candidates_1[_i];
                    r2 = Math.pow(this.sradius[i], 2);
                    _e = this.renderer.xscale.r_compute(x, this._x[i]), sx0 = _e[0], sx1 = _e[1];
                    _f = this.renderer.yscale.r_compute(y, this._y[i]), sy0 = _f[0], sy1 = _f[1];
                    dist = Math.pow(sx0 - sx1, 2) + Math.pow(sy0 - sy1, 2);
                    if (dist <= r2) {
                        hits.push([
                            i,
                            dist
                        ]);
                    }
                }
            } else {
                for (var _g = 0, candidates_2 = candidates; _g < candidates_2.length; _g++) {
                    var i = candidates_2[_g];
                    r2 = Math.pow(this.sradius[i], 2);
                    dist = Math.pow(this.sx[i] - sx, 2) + Math.pow(this.sy[i] - sy, 2);
                    if (dist <= r2) {
                        hits.push([
                            i,
                            dist
                        ]);
                    }
                }
            }
            return hittest.create_hit_test_result_from_hits(hits);
            var _a, _b, _c, _d, _e, _f;
        };
        CircleView.prototype._hit_span = function (geometry) {
            var ms, x0, x1, y0, y1;
            var sx = geometry.sx, sy = geometry.sy;
            var _a = this.bounds(), minX = _a.minX, minY = _a.minY, maxX = _a.maxX, maxY = _a.maxY;
            var result = hittest.create_empty_hit_test_result();
            if (geometry.direction == 'h') {
                // use circle bounds instead of current pointer y coordinates
                var sx0 = void 0, sx1 = void 0;
                y0 = minY;
                y1 = maxY;
                if (this._radius != null && this.model.properties.radius.units == 'data') {
                    sx0 = sx - this.max_radius;
                    sx1 = sx + this.max_radius;
                    _b = this.renderer.xscale.r_invert(sx0, sx1), x0 = _b[0], x1 = _b[1];
                } else {
                    ms = this.max_size / 2;
                    sx0 = sx - ms;
                    sx1 = sx + ms;
                    _c = this.renderer.xscale.r_invert(sx0, sx1), x0 = _c[0], x1 = _c[1];
                }
            } else {
                // use circle bounds instead of current pointer x coordinates
                var sy0 = void 0, sy1 = void 0;
                x0 = minX;
                x1 = maxX;
                if (this._radius != null && this.model.properties.radius.units == 'data') {
                    sy0 = sy - this.max_radius;
                    sy1 = sy + this.max_radius;
                    _d = this.renderer.yscale.r_invert(sy0, sy1), y0 = _d[0], y1 = _d[1];
                } else {
                    ms = this.max_size / 2;
                    sy0 = sy - ms;
                    sy1 = sy + ms;
                    _e = this.renderer.yscale.r_invert(sy0, sy1), y0 = _e[0], y1 = _e[1];
                }
            }
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var hits = this.index.indices(bbox);
            result.indices = hits;
            return result;
            var _b, _c, _d, _e;
        };
        CircleView.prototype._hit_rect = function (geometry) {
            var sx0 = geometry.sx0, sx1 = geometry.sx1, sy0 = geometry.sy0, sy1 = geometry.sy1;
            var _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
            var _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var result = hittest.create_empty_hit_test_result();
            result.indices = this.index.indices(bbox);
            return result;
        };
        CircleView.prototype._hit_poly = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            // TODO (bev) use spatial index to pare candidate list
            var candidates = array_1.range(0, this.sx.length);
            var hits = [];
            for (var i = 0, end = candidates.length; i < end; i++) {
                var idx = candidates[i];
                if (hittest.point_in_poly(this.sx[i], this.sy[i], sx, sy)) {
                    hits.push(idx);
                }
            }
            var result = hittest.create_empty_hit_test_result();
            result.indices = hits;
            return result;
        };
        // circle does not inherit from marker (since it also accepts radius) so we
        // must supply a draw_legend for it  here
        CircleView.prototype.draw_legend_for_index = function (ctx, _a, index) {
            var x0 = _a.x0, y0 = _a.y0, x1 = _a.x1, y1 = _a.y1;
            // using objects like this seems a little wonky, since the keys are coerced to
            // stings, but it works
            var len = index + 1;
            var sx = new Array(len);
            sx[index] = (x0 + x1) / 2;
            var sy = new Array(len);
            sy[index] = (y0 + y1) / 2;
            var sradius = new Array(len);
            sradius[index] = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.2;
            this._render(ctx, [index], {
                sx: sx,
                sy: sy,
                sradius: sradius
            });    // XXX
        };
        return CircleView;
    }(xy_glyph_1.XYGlyphView);
    exports.CircleView = CircleView;
    var Circle = function (_super) {
        tslib_1.__extends(Circle, _super);
        function Circle(attrs) {
            return _super.call(this, attrs) || this;
        }
        Circle.initClass = function () {
            this.prototype.type = 'Circle';
            this.prototype.default_view = CircleView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                angle: [
                    p.AngleSpec,
                    0
                ],
                size: [
                    p.DistanceSpec,
                    {
                        units: 'screen',
                        value: 4
                    }
                ],
                radius: [
                    p.DistanceSpec,
                    null
                ],
                radius_dimension: [
                    p.String,
                    'x'
                ]
            });
        };
        Circle.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.properties.radius.optional = true;
        };
        return Circle;
    }(xy_glyph_1.XYGlyph);
    exports.Circle = Circle;
    Circle.initClass();    
},
/*models/glyphs/ellipse*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var p = require(15    /* core/properties */);
    var EllipseView = function (_super) {
        tslib_1.__extends(EllipseView, _super);
        function EllipseView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        EllipseView.prototype._set_data = function () {
            this.max_w2 = 0;
            if (this.model.properties.width.units == 'data')
                this.max_w2 = this.max_width / 2;
            this.max_h2 = 0;
            if (this.model.properties.height.units == 'data')
                this.max_h2 = this.max_height / 2;
        };
        EllipseView.prototype._map_data = function () {
            if (this.model.properties.width.units == 'data')
                this.sw = this.sdist(this.renderer.xscale, this._x, this._width, 'center');
            else
                this.sw = this._width;
            if (this.model.properties.height.units == 'data')
                this.sh = this.sdist(this.renderer.yscale, this._y, this._height, 'center');
            else
                this.sh = this._height;
        };
        EllipseView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sw = _a.sw, sh = _a.sh;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sw[i] + sh[i] + this._angle[i]))
                    continue;
                ctx.beginPath();
                ctx.ellipse(sx[i], sy[i], sw[i] / 2, sh[i] / 2, this._angle[i], 0, 2 * Math.PI);
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        EllipseView.prototype.draw_legend_for_index = function (ctx, _a, index) {
            var x0 = _a.x0, y0 = _a.y0, x1 = _a.x1, y1 = _a.y1;
            var len = index + 1;
            var sx = new Array(len);
            sx[index] = (x0 + x1) / 2;
            var sy = new Array(len);
            sy[index] = (y0 + y1) / 2;
            var scale = this.sw[index] / this.sh[index];
            var d = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.8;
            var sw = new Array(len);
            var sh = new Array(len);
            if (scale > 1) {
                sw[index] = d;
                sh[index] = d / scale;
            } else {
                sw[index] = d * scale;
                sh[index] = d;
            }
            this._render(ctx, [index], {
                sx: sx,
                sy: sy,
                sw: sw,
                sh: sh
            });    // XXX
        };
        EllipseView.prototype._bounds = function (_a) {
            var minX = _a.minX, maxX = _a.maxX, minY = _a.minY, maxY = _a.maxY;
            return {
                minX: minX - this.max_w2,
                maxX: maxX + this.max_w2,
                minY: minY - this.max_h2,
                maxY: maxY + this.max_h2
            };
        };
        return EllipseView;
    }(xy_glyph_1.XYGlyphView);
    exports.EllipseView = EllipseView;
    var Ellipse = function (_super) {
        tslib_1.__extends(Ellipse, _super);
        function Ellipse(attrs) {
            return _super.call(this, attrs) || this;
        }
        Ellipse.initClass = function () {
            this.prototype.type = 'Ellipse';
            this.prototype.default_view = EllipseView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                angle: [
                    p.AngleSpec,
                    0
                ],
                width: [p.DistanceSpec],
                height: [p.DistanceSpec]
            });
        };
        return Ellipse;
    }(xy_glyph_1.XYGlyph);
    exports.Ellipse = Ellipse;
    Ellipse.initClass();    
},
/*models/glyphs/glyph*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var bbox = require(24    /* core/util/bbox */);
    var proj = require(33    /* core/util/projections */);
    var visuals = require(49    /* core/visuals */);
    var view_1 = require(48    /* core/view */);
    var model_1 = require(53    /* ../../model */);
    var logging_1 = require(14    /* core/logging */);
    var arrayable_1 = require(22    /* core/util/arrayable */);
    var object_1 = require(32    /* core/util/object */);
    var types_1 = require(44    /* core/util/types */);
    var line_1 = require(120    /* ./line */);
    var factor_range_1 = require(165    /* ../ranges/factor_range */);
    var GlyphView = function (_super) {
        tslib_1.__extends(GlyphView, _super);
        function GlyphView() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._nohit_warned = {};
            return _this;
        }
        GlyphView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this._nohit_warned = {};
            this.renderer = options.renderer;
            this.visuals = new visuals.Visuals(this.model);
            // Init gl (this should really be done anytime renderer is set,
            // and not done if it isn't ever set, but for now it only
            // matters in the unit tests because we build a view without a
            // renderer there)
            var gl = this.renderer.plot_view.gl;
            if (gl != null) {
                var webgl_module = null;
                try {
                    webgl_module = require(441    /* ./webgl/index */);
                } catch (e) {
                    if (e.code === 'MODULE_NOT_FOUND') {
                        logging_1.logger.warn('WebGL was requested and is supported, but bokeh-gl(.min).js is not available, falling back to 2D rendering.');
                    } else
                        throw e;
                }
                if (webgl_module != null) {
                    var Cls = webgl_module[this.model.type + 'GLGlyph'];
                    if (Cls != null)
                        this.glglyph = new Cls(gl.ctx, this);
                }
            }
        };
        GlyphView.prototype.set_visuals = function (source) {
            this.visuals.warm_cache(source);
            if (this.glglyph != null)
                this.glglyph.set_visuals_changed();
        };
        GlyphView.prototype.render = function (ctx, indices, data) {
            ctx.beginPath();
            if (this.glglyph != null) {
                if (this.glglyph.render(ctx, indices, data))
                    return;
            }
            this._render(ctx, indices, data);
        };
        GlyphView.prototype.has_finished = function () {
            return true;
        };
        GlyphView.prototype.notify_finished = function () {
            this.renderer.notify_finished();
        };
        GlyphView.prototype._bounds = function (bounds) {
            return bounds;
        };
        GlyphView.prototype.bounds = function () {
            return this._bounds(this.index.bbox);
        };
        GlyphView.prototype.log_bounds = function () {
            var bb = bbox.empty();
            var positive_x_bbs = this.index.search(bbox.positive_x());
            for (var _i = 0, positive_x_bbs_1 = positive_x_bbs; _i < positive_x_bbs_1.length; _i++) {
                var x = positive_x_bbs_1[_i];
                if (x.minX < bb.minX)
                    bb.minX = x.minX;
                if (x.maxX > bb.maxX)
                    bb.maxX = x.maxX;
            }
            var positive_y_bbs = this.index.search(bbox.positive_y());
            for (var _a = 0, positive_y_bbs_1 = positive_y_bbs; _a < positive_y_bbs_1.length; _a++) {
                var y = positive_y_bbs_1[_a];
                if (y.minY < bb.minY)
                    bb.minY = y.minY;
                if (y.maxY > bb.maxY)
                    bb.maxY = y.maxY;
            }
            return this._bounds(bb);
        };
        GlyphView.prototype.get_anchor_point = function (anchor, i, _a) {
            var sx = _a[0], sy = _a[1];
            switch (anchor) {
            case 'center':
                return {
                    x: this.scenterx(i, sx, sy),
                    y: this.scentery(i, sx, sy)
                };
            default:
                return null;
            }
        };
        GlyphView.prototype.sdist = function (scale, pts, spans, pts_location, dilate) {
            if (pts_location === void 0) {
                pts_location = 'edge';
            }
            if (dilate === void 0) {
                dilate = false;
            }
            var pt0;
            var pt1;
            var n = pts.length;
            if (pts_location == 'center') {
                var halfspan = arrayable_1.map(spans, function (d) {
                    return d / 2;
                });
                pt0 = new Float64Array(n);
                for (var i = 0; i < n; i++) {
                    pt0[i] = pts[i] - halfspan[i];
                }
                pt1 = new Float64Array(n);
                for (var i = 0; i < n; i++) {
                    pt1[i] = pts[i] + halfspan[i];
                }
            } else {
                pt0 = pts;
                pt1 = new Float64Array(n);
                for (var i = 0; i < n; i++) {
                    pt1[i] = pt0[i] + spans[i];
                }
            }
            var spt0 = scale.v_compute(pt0);
            var spt1 = scale.v_compute(pt1);
            if (dilate)
                return arrayable_1.map(spt0, function (_, i) {
                    return Math.ceil(Math.abs(spt1[i] - spt0[i]));
                });
            else
                return arrayable_1.map(spt0, function (_, i) {
                    return Math.abs(spt1[i] - spt0[i]);
                });
        };
        GlyphView.prototype.draw_legend_for_index = function (_ctx, _bbox, _index) {
        };
        GlyphView.prototype.hit_test = function (geometry) {
            var result = null;
            var func = '_hit_' + geometry.type;
            if (this[func] != null) {
                result = this[func](geometry);
            } else if (this._nohit_warned[geometry.type] == null) {
                logging_1.logger.debug('\'' + geometry.type + '\' selection not available for ' + this.model.type);
                this._nohit_warned[geometry.type] = true;
            }
            return result;
        };
        GlyphView.prototype._hit_rect_against_index = function (geometry) {
            var sx0 = geometry.sx0, sx1 = geometry.sx1, sy0 = geometry.sy0, sy1 = geometry.sy1;
            var _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
            var _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            var bb = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var result = hittest.create_empty_hit_test_result();
            result.indices = this.index.indices(bb);
            return result;
        };
        GlyphView.prototype.set_data = function (source, indices, indices_to_update) {
            var data = this.model.materialize_dataspecs(source);
            this.visuals.set_all_indices(indices);
            if (indices && !(this instanceof line_1.LineView)) {
                var data_subset = {};
                var _loop_1 = function (k) {
                    var v = data[k];
                    if (k.charAt(0) === '_')
                        data_subset[k] = indices.map(function (i) {
                            return v[i];
                        });
                    else
                        data_subset[k] = v;
                };
                for (var k in data) {
                    _loop_1(k);
                }
                data = data_subset;
            }
            var self = this;
            object_1.extend(self, data);
            if (this.renderer.plot_view.model.use_map) {
                if (self._x != null)
                    _a = proj.project_xy(self._x, self._y), self._x = _a[0], self._y = _a[1];
                if (self._xs != null)
                    _b = proj.project_xsys(self._xs, self._ys), self._xs = _b[0], self._ys = _b[1];
            }
            // if we have any coordinates that are categorical, convert them to
            // synthetic coords here
            if (this.renderer.plot_view.frame.x_ranges != null) {
                // XXXX JUST TEMP FOR TESTS TO PASS
                var xr_1 = this.renderer.plot_view.frame.x_ranges[this.model.x_range_name];
                var yr_1 = this.renderer.plot_view.frame.y_ranges[this.model.y_range_name];
                for (var _i = 0, _c = this.model._coords; _i < _c.length; _i++) {
                    var _d = _c[_i], xname = _d[0], yname = _d[1];
                    xname = '_' + xname;
                    yname = '_' + yname;
                    // TODO (bev) more robust detection of multi-glyph case
                    // hand multi glyph case
                    if (self._xs != null) {
                        if (xr_1 instanceof factor_range_1.FactorRange) {
                            self[xname] = arrayable_1.map(self[xname], function (arr) {
                                return xr_1.v_synthetic(arr);
                            });
                        }
                        if (yr_1 instanceof factor_range_1.FactorRange) {
                            self[yname] = arrayable_1.map(self[yname], function (arr) {
                                return yr_1.v_synthetic(arr);
                            });
                        }
                    }    // hand standard glyph case
                    else {
                        if (xr_1 instanceof factor_range_1.FactorRange) {
                            self[xname] = xr_1.v_synthetic(self[xname]);
                        }
                        if (yr_1 instanceof factor_range_1.FactorRange) {
                            self[yname] = yr_1.v_synthetic(self[yname]);
                        }
                    }
                }
            }
            if (this.glglyph != null)
                this.glglyph.set_data_changed(self._x.length);
            this._set_data(indices_to_update);
            //TODO doesn't take subset indices into account
            this.index_data();
            var _a, _b;
        };
        GlyphView.prototype._set_data = function (_indices) {
        };
        GlyphView.prototype.index_data = function () {
            this.index = this._index_data();
        };
        GlyphView.prototype.mask_data = function (indices) {
            // WebGL can do the clipping much more efficiently
            if (this.glglyph != null || this._mask_data == null)
                return indices;
            else
                return this._mask_data();
        };
        GlyphView.prototype.map_data = function () {
            // TODO: if using gl, skip this (when is this called?)
            // map all the coordinate fields
            var self = this;
            for (var _i = 0, _a = this.model._coords; _i < _a.length; _i++) {
                var _b = _a[_i], xname = _b[0], yname = _b[1];
                var sxname = 's' + xname;
                var syname = 's' + yname;
                xname = '_' + xname;
                yname = '_' + yname;
                if (self[xname] != null && (types_1.isArray(self[xname][0]) || types_1.isTypedArray(self[xname][0]))) {
                    var n = self[xname].length;
                    self[sxname] = new Array(n);
                    self[syname] = new Array(n);
                    for (var i = 0; i < n; i++) {
                        var _c = this.map_to_screen(self[xname][i], self[yname][i]), sx = _c[0], sy = _c[1];
                        self[sxname][i] = sx;
                        self[syname][i] = sy;
                    }
                } else
                    _d = this.map_to_screen(self[xname], self[yname]), self[sxname] = _d[0], self[syname] = _d[1];
            }
            this._map_data();
            var _d;
        };
        // This is where specs not included in coords are computed, e.g. radius.
        GlyphView.prototype._map_data = function () {
        };
        GlyphView.prototype.map_to_screen = function (x, y) {
            return this.renderer.plot_view.map_to_screen(x, y, this.model.x_range_name, this.model.y_range_name);
        };
        return GlyphView;
    }(view_1.View);
    exports.GlyphView = GlyphView;
    var Glyph = function (_super) {
        tslib_1.__extends(Glyph, _super);
        function Glyph(attrs) {
            return _super.call(this, attrs) || this;
        }
        Glyph.initClass = function () {
            this.prototype.type = 'Glyph';
            this.prototype._coords = [];
            this.internal({
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
        };
        Glyph.coords = function (coords) {
            var _coords = this.prototype._coords.concat(coords);
            this.prototype._coords = _coords;
            var result = {};
            for (var _i = 0, coords_1 = coords; _i < coords_1.length; _i++) {
                var _a = coords_1[_i], x = _a[0], y = _a[1];
                result[x] = [p.NumberSpec];
                result[y] = [p.NumberSpec];
            }
            this.define(result);
        };
        return Glyph;
    }(model_1.Model);
    exports.Glyph = Glyph;
    Glyph.initClass();    
},
/*models/glyphs/hbar*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var box_1 = require(110    /* ./box */);
    var p = require(15    /* core/properties */);
    var HBarView = function (_super) {
        tslib_1.__extends(HBarView, _super);
        function HBarView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        HBarView.prototype.scenterx = function (i) {
            return (this.sleft[i] + this.sright[i]) / 2;
        };
        HBarView.prototype.scentery = function (i) {
            return this.sy[i];
        };
        HBarView.prototype._index_data = function () {
            return this._index_box(this._y.length);
        };
        HBarView.prototype._lrtb = function (i) {
            var l = Math.min(this._left[i], this._right[i]);
            var r = Math.max(this._left[i], this._right[i]);
            var t = this._y[i] + 0.5 * this._height[i];
            var b = this._y[i] - 0.5 * this._height[i];
            return [
                l,
                r,
                t,
                b
            ];
        };
        HBarView.prototype._map_data = function () {
            this.sy = this.renderer.yscale.v_compute(this._y);
            this.sh = this.sdist(this.renderer.yscale, this._y, this._height, 'center');
            this.sleft = this.renderer.xscale.v_compute(this._left);
            this.sright = this.renderer.xscale.v_compute(this._right);
            var n = this.sy.length;
            this.stop = new Float64Array(n);
            this.sbottom = new Float64Array(n);
            for (var i = 0; i < n; i++) {
                this.stop[i] = this.sy[i] - this.sh[i] / 2;
                this.sbottom[i] = this.sy[i] + this.sh[i] / 2;
            }
        };
        return HBarView;
    }(box_1.BoxView);
    exports.HBarView = HBarView;
    var HBar = function (_super) {
        tslib_1.__extends(HBar, _super);
        function HBar(attrs) {
            return _super.call(this, attrs) || this;
        }
        HBar.initClass = function () {
            this.prototype.type = 'HBar';
            this.prototype.default_view = HBarView;
            this.coords([[
                    'left',
                    'y'
                ]]);
            this.define({
                height: [p.DistanceSpec],
                right: [p.NumberSpec]
            });
            this.override({ left: 0 });
        };
        return HBar;
    }(box_1.Box);
    exports.HBar = HBar;
    HBar.initClass();    
},
/*models/glyphs/hex_tile*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var glyph_1 = require(113    /* ./glyph */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var utils_1 = require(132    /* ./utils */);
    var HexTileView = function (_super) {
        tslib_1.__extends(HexTileView, _super);
        function HexTileView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        HexTileView.prototype.scenterx = function (i) {
            return this.sx[i];
        };
        HexTileView.prototype.scentery = function (i) {
            return this.sy[i];
        };
        HexTileView.prototype._set_data = function () {
            var n = this._q.length;
            var size = this.model.size;
            var aspect_scale = this.model.aspect_scale;
            this._x = new Float64Array(n);
            this._y = new Float64Array(n);
            if (this.model.orientation == 'pointytop') {
                for (var i = 0; i < n; i++) {
                    this._x[i] = size * Math.sqrt(3) * (this._q[i] + this._r[i] / 2) / aspect_scale;
                    this._y[i] = -size * 3 / 2 * this._r[i];
                }
            } else {
                for (var i = 0; i < n; i++) {
                    this._x[i] = size * 3 / 2 * this._q[i];
                    this._y[i] = -size * Math.sqrt(3) * (this._r[i] + this._q[i] / 2) * aspect_scale;
                }
            }
        };
        HexTileView.prototype._index_data = function () {
            var ysize = this.model.size;
            var xsize = Math.sqrt(3) * ysize / 2;
            if (this.model.orientation == 'flattop') {
                _a = [
                    ysize,
                    xsize
                ], xsize = _a[0], ysize = _a[1];
                ysize *= this.model.aspect_scale;
            } else {
                xsize /= this.model.aspect_scale;
            }
            var points = [];
            for (var i = 0; i < this._x.length; i++) {
                var x = this._x[i];
                var y = this._y[i];
                if (isNaN(x + y) || !isFinite(x + y))
                    continue;
                points.push({
                    minX: x - xsize,
                    minY: y - ysize,
                    maxX: x + xsize,
                    maxY: y + ysize,
                    i: i
                });
            }
            return new spatial_1.SpatialIndex(points);
            var _a;
        };
        // overriding map_data instead of _map_data because the default automatic mappings
        // for other glyphs (with cartesian coordinates) is not useful
        HexTileView.prototype.map_data = function () {
            _a = this.map_to_screen(this._x, this._y), this.sx = _a[0], this.sy = _a[1];
            _b = this._get_unscaled_vertices(), this.svx = _b[0], this.svy = _b[1];
            var _a, _b;
        };
        HexTileView.prototype._get_unscaled_vertices = function () {
            var size = this.model.size;
            var aspect_scale = this.model.aspect_scale;
            if (this.model.orientation == 'pointytop') {
                var rscale = this.renderer.yscale;
                var hscale = this.renderer.xscale;
                var r = Math.abs(rscale.compute(0) - rscale.compute(size));
                // assumes linear scale
                var h = Math.sqrt(3) / 2 * Math.abs(hscale.compute(0) - hscale.compute(size)) / aspect_scale;
                // assumes linear scale
                var r2 = r / 2;
                var svx = [
                    0,
                    -h,
                    -h,
                    0,
                    h,
                    h
                ];
                var svy = [
                    r,
                    r2,
                    -r2,
                    -r,
                    -r2,
                    r2
                ];
                return [
                    svx,
                    svy
                ];
            } else {
                var rscale = this.renderer.xscale;
                var hscale = this.renderer.yscale;
                var r = Math.abs(rscale.compute(0) - rscale.compute(size));
                // assumes linear scale
                var h = Math.sqrt(3) / 2 * Math.abs(hscale.compute(0) - hscale.compute(size)) * aspect_scale;
                // assumes linear scale
                var r2 = r / 2;
                var svx = [
                    r,
                    r2,
                    -r2,
                    -r,
                    -r2,
                    r2
                ];
                var svy = [
                    0,
                    -h,
                    -h,
                    0,
                    h,
                    h
                ];
                return [
                    svx,
                    svy
                ];
            }
        };
        HexTileView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, svx = _a.svx, svy = _a.svy, _scale = _a._scale;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + _scale[i]))
                    continue;
                ctx.translate(sx[i], sy[i]);
                ctx.beginPath();
                for (var j = 0; j < 6; j++) {
                    ctx.lineTo(svx[j] * _scale[i], svy[j] * _scale[i]);
                }
                ctx.closePath();
                ctx.translate(-sx[i], -sy[i]);
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        HexTileView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            var candidates = this.index.indices({
                minX: x,
                minY: y,
                maxX: x,
                maxY: y
            });
            var hits = [];
            for (var _i = 0, candidates_1 = candidates; _i < candidates_1.length; _i++) {
                var i = candidates_1[_i];
                if (hittest.point_in_poly(sx - this.sx[i], sy - this.sy[i], this.svx, this.svy)) {
                    hits.push(i);
                }
            }
            var result = hittest.create_empty_hit_test_result();
            result.indices = hits;
            return result;
        };
        HexTileView.prototype._hit_span = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var hits;
            if (geometry.direction == 'v') {
                var y = this.renderer.yscale.invert(sy);
                var hr = this.renderer.plot_view.frame.bbox.h_range;
                var _a = this.renderer.xscale.r_invert(hr.start, hr.end), minX = _a[0], maxX = _a[1];
                hits = this.index.indices({
                    minX: minX,
                    minY: y,
                    maxX: maxX,
                    maxY: y
                });
            } else {
                var x = this.renderer.xscale.invert(sx);
                var vr = this.renderer.plot_view.frame.bbox.v_range;
                var _b = this.renderer.yscale.r_invert(vr.start, vr.end), minY = _b[0], maxY = _b[1];
                hits = this.index.indices({
                    minX: x,
                    minY: minY,
                    maxX: x,
                    maxY: maxY
                });
            }
            var result = hittest.create_empty_hit_test_result();
            result.indices = hits;
            return result;
        };
        HexTileView.prototype._hit_rect = function (geometry) {
            var sx0 = geometry.sx0, sx1 = geometry.sx1, sy0 = geometry.sy0, sy1 = geometry.sy1;
            var _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
            var _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var result = hittest.create_empty_hit_test_result();
            result.indices = this.index.indices(bbox);
            return result;
        };
        HexTileView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_area_legend(this.visuals, ctx, bbox, index);
        };
        return HexTileView;
    }(glyph_1.GlyphView);
    exports.HexTileView = HexTileView;
    var HexTile = function (_super) {
        tslib_1.__extends(HexTile, _super);
        function HexTile(attrs) {
            return _super.call(this, attrs) || this;
        }
        HexTile.initClass = function () {
            this.prototype.type = 'HexTile';
            this.prototype.default_view = HexTileView;
            this.coords([[
                    'r',
                    'q'
                ]]);
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                size: [
                    p.Number,
                    1
                ],
                aspect_scale: [
                    p.Number,
                    1
                ],
                scale: [
                    p.NumberSpec,
                    1
                ],
                orientation: [
                    p.String,
                    'pointytop'
                ]
            });
            this.override({ line_color: null });
        };
        return HexTile;
    }(glyph_1.Glyph);
    exports.HexTile = HexTile;
    HexTile.initClass();    
},
/*models/glyphs/image*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var linear_color_mapper_1 = require(154    /* ../mappers/linear_color_mapper */);
    var p = require(15    /* core/properties */);
    var array_1 = require(21    /* core/util/array */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var hittest = require(9    /* core/hittest */);
    var ImageView = function (_super) {
        tslib_1.__extends(ImageView, _super);
        function ImageView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ImageView.prototype.initialize = function (options) {
            var _this = this;
            _super.prototype.initialize.call(this, options);
            this.connect(this.model.color_mapper.change, function () {
                return _this._update_image();
            });
            this.connect(this.model.properties.global_alpha.change, function () {
                return _this.renderer.request_render();
            });
        };
        ImageView.prototype._update_image = function () {
            // Only reset image_data if already initialized
            if (this.image_data != null) {
                this._set_data();
                this.renderer.plot_view.request_render();
            }
        };
        ImageView.prototype._index_data = function () {
            var points = [];
            for (var i = 0, end = this._x.length; i < end; i++) {
                var _a = this._lrtb(i), l = _a[0], r = _a[1], t = _a[2], b = _a[3];
                if (isNaN(l + r + t + b) || !isFinite(l + r + t + b)) {
                    continue;
                }
                points.push({
                    minX: l,
                    minY: b,
                    maxX: r,
                    maxY: t,
                    i: i
                });
            }
            return new spatial_1.SpatialIndex(points);
        };
        ImageView.prototype._lrtb = function (i) {
            var l = this._x[i];
            var r = l + this._dw[i];
            var b = this._y[i];
            var t = b + this._dh[i];
            return [
                l,
                r,
                t,
                b
            ];
        };
        ImageView.prototype._image_index = function (index, x, y) {
            var _a = this._lrtb(index), l = _a[0], r = _a[1], t = _a[2], b = _a[3];
            var width = this._width[index];
            var height = this._height[index];
            var dx = (r - l) / width;
            var dy = (t - b) / height;
            var dim1 = Math.floor((x - l) / dx);
            var dim2 = Math.floor((y - b) / dy);
            return {
                index: index,
                dim1: dim1,
                dim2: dim2,
                flat_index: dim2 * width + dim1
            };
        };
        ImageView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            var bbox = hittest.validate_bbox_coords([
                x,
                x
            ], [
                y,
                y
            ]);
            var candidates = this.index.indices(bbox);
            var result = hittest.create_empty_hit_test_result();
            result.image_indices = [];
            for (var _i = 0, candidates_1 = candidates; _i < candidates_1.length; _i++) {
                var index = candidates_1[_i];
                if (sx != Infinity && sy != Infinity) {
                    result.image_indices.push(this._image_index(index, x, y));
                }
            }
            return result;
        };
        ImageView.prototype._set_data = function () {
            if (this.image_data == null || this.image_data.length != this._image.length)
                this.image_data = new Array(this._image.length);
            if (this._width == null || this._width.length != this._image.length)
                this._width = new Array(this._image.length);
            if (this._height == null || this._height.length != this._image.length)
                this._height = new Array(this._image.length);
            var cmap = this.model.color_mapper.rgba_mapper;
            for (var i = 0, end = this._image.length; i < end; i++) {
                var img = void 0;
                if (this._image_shape != null && this._image_shape[i].length > 0) {
                    img = this._image[i];
                    var shape = this._image_shape[i];
                    this._height[i] = shape[0];
                    this._width[i] = shape[1];
                } else {
                    var _image = this._image[i];
                    img = array_1.concat(_image);
                    this._height[i] = _image.length;
                    this._width[i] = _image[0].length;
                }
                var _image_data = this.image_data[i];
                var canvas = void 0;
                if (_image_data != null && _image_data.width == this._width[i] && _image_data.height == this._height[i])
                    canvas = _image_data;
                else {
                    canvas = document.createElement('canvas');
                    canvas.width = this._width[i];
                    canvas.height = this._height[i];
                }
                var ctx = canvas.getContext('2d');
                var image_data = ctx.getImageData(0, 0, this._width[i], this._height[i]);
                var buf8 = cmap.v_compute(img);
                image_data.data.set(buf8);
                ctx.putImageData(image_data, 0, 0);
                this.image_data[i] = canvas;
                this.max_dw = 0;
                if (this.model.properties.dw.units == 'data')
                    this.max_dw = array_1.max(this._dw);
                this.max_dh = 0;
                if (this.model.properties.dh.units == 'data')
                    this.max_dh = array_1.max(this._dh);
            }
        };
        ImageView.prototype._map_data = function () {
            switch (this.model.properties.dw.units) {
            case 'data': {
                    this.sw = this.sdist(this.renderer.xscale, this._x, this._dw, 'edge', this.model.dilate);
                    break;
                }
            case 'screen': {
                    this.sw = this._dw;
                    break;
                }
            }
            switch (this.model.properties.dh.units) {
            case 'data': {
                    this.sh = this.sdist(this.renderer.yscale, this._y, this._dh, 'edge', this.model.dilate);
                    break;
                }
            case 'screen': {
                    this.sh = this._dh;
                    break;
                }
            }
        };
        ImageView.prototype._render = function (ctx, indices, _a) {
            var image_data = _a.image_data, sx = _a.sx, sy = _a.sy, sw = _a.sw, sh = _a.sh;
            var old_smoothing = ctx.getImageSmoothingEnabled();
            ctx.setImageSmoothingEnabled(false);
            ctx.globalAlpha = this.model.global_alpha;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (image_data[i] == null)
                    continue;
                if (isNaN(sx[i] + sy[i] + sw[i] + sh[i]))
                    continue;
                var y_offset = sy[i];
                ctx.translate(0, y_offset);
                ctx.scale(1, -1);
                ctx.translate(0, -y_offset);
                ctx.drawImage(image_data[i], sx[i] | 0, sy[i] | 0, sw[i], sh[i]);
                ctx.translate(0, y_offset);
                ctx.scale(1, -1);
                ctx.translate(0, -y_offset);
            }
            ctx.setImageSmoothingEnabled(old_smoothing);
        };
        ImageView.prototype.bounds = function () {
            var bbox = this.index.bbox;
            bbox.maxX += this.max_dw;
            bbox.maxY += this.max_dh;
            return bbox;
        };
        return ImageView;
    }(xy_glyph_1.XYGlyphView);
    exports.ImageView = ImageView;
    // NOTE: this needs to be redefined here, because palettes are located in bokeh-api.js bundle
    var Greys9 = function () {
        return [
            '#000000',
            '#252525',
            '#525252',
            '#737373',
            '#969696',
            '#bdbdbd',
            '#d9d9d9',
            '#f0f0f0',
            '#ffffff'
        ];
    };
    var Image = function (_super) {
        tslib_1.__extends(Image, _super);
        function Image(attrs) {
            return _super.call(this, attrs) || this;
        }
        Image.initClass = function () {
            this.prototype.type = 'Image';
            this.prototype.default_view = ImageView;
            this.define({
                image: [p.NumberSpec],
                dw: [p.DistanceSpec],
                dh: [p.DistanceSpec],
                dilate: [
                    p.Bool,
                    false
                ],
                global_alpha: [
                    p.Number,
                    1
                ],
                color_mapper: [
                    p.Instance,
                    function () {
                        return new linear_color_mapper_1.LinearColorMapper({ palette: Greys9() });
                    }
                ]
            });
        };
        return Image;
    }(xy_glyph_1.XYGlyph);
    exports.Image = Image;
    Image.initClass();    
},
/*models/glyphs/image_rgba*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var p = require(15    /* core/properties */);
    var array_1 = require(21    /* core/util/array */);
    var ImageRGBAView = function (_super) {
        tslib_1.__extends(ImageRGBAView, _super);
        function ImageRGBAView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ImageRGBAView.prototype.initialize = function (options) {
            var _this = this;
            _super.prototype.initialize.call(this, options);
            this.connect(this.model.properties.global_alpha.change, function () {
                return _this.renderer.request_render();
            });
        };
        ImageRGBAView.prototype._set_data = function (indices) {
            if (this.image_data == null || this.image_data.length != this._image.length)
                this.image_data = new Array(this._image.length);
            if (this._width == null || this._width.length != this._image.length)
                this._width = new Array(this._image.length);
            if (this._height == null || this._height.length != this._image.length)
                this._height = new Array(this._image.length);
            for (var i = 0, end = this._image.length; i < end; i++) {
                if (indices != null && indices.indexOf(i) < 0)
                    continue;
                var buf = void 0;
                if (this._image_shape != null && this._image_shape[i].length > 0) {
                    buf = this._image[i].buffer;
                    var shape = this._image_shape[i];
                    this._height[i] = shape[0];
                    this._width[i] = shape[1];
                } else {
                    var _image = this._image[i];
                    var flat = array_1.concat(_image);
                    buf = new ArrayBuffer(flat.length * 4);
                    var color = new Uint32Array(buf);
                    for (var j = 0, endj = flat.length; j < endj; j++) {
                        color[j] = flat[j];
                    }
                    this._height[i] = _image.length;
                    this._width[i] = _image[0].length;
                }
                var _image_data = this.image_data[i];
                var canvas = void 0;
                if (_image_data != null && _image_data.width == this._width[i] && _image_data.height == this._height[i])
                    canvas = _image_data;
                else {
                    canvas = document.createElement('canvas');
                    canvas.width = this._width[i];
                    canvas.height = this._height[i];
                }
                var ctx = canvas.getContext('2d');
                var image_data = ctx.getImageData(0, 0, this._width[i], this._height[i]);
                var buf8 = new Uint8Array(buf);
                image_data.data.set(buf8);
                ctx.putImageData(image_data, 0, 0);
                this.image_data[i] = canvas;
                this.max_dw = 0;
                if (this.model.properties.dw.units == 'data')
                    this.max_dw = array_1.max(this._dw);
                this.max_dh = 0;
                if (this.model.properties.dh.units == 'data')
                    this.max_dh = array_1.max(this._dh);
            }
        };
        ImageRGBAView.prototype._map_data = function () {
            switch (this.model.properties.dw.units) {
            case 'data': {
                    this.sw = this.sdist(this.renderer.xscale, this._x, this._dw, 'edge', this.model.dilate);
                    break;
                }
            case 'screen': {
                    this.sw = this._dw;
                    break;
                }
            }
            switch (this.model.properties.dh.units) {
            case 'data': {
                    this.sh = this.sdist(this.renderer.yscale, this._y, this._dh, 'edge', this.model.dilate);
                    break;
                }
            case 'screen': {
                    this.sh = this._dh;
                    break;
                }
            }
        };
        ImageRGBAView.prototype._render = function (ctx, indices, _a) {
            var image_data = _a.image_data, sx = _a.sx, sy = _a.sy, sw = _a.sw, sh = _a.sh;
            var old_smoothing = ctx.getImageSmoothingEnabled();
            ctx.setImageSmoothingEnabled(false);
            ctx.globalAlpha = this.model.global_alpha;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sw[i] + sh[i]))
                    continue;
                var y_offset = sy[i];
                ctx.translate(0, y_offset);
                ctx.scale(1, -1);
                ctx.translate(0, -y_offset);
                ctx.drawImage(image_data[i], sx[i] | 0, sy[i] | 0, sw[i], sh[i]);
                ctx.translate(0, y_offset);
                ctx.scale(1, -1);
                ctx.translate(0, -y_offset);
            }
            ctx.setImageSmoothingEnabled(old_smoothing);
        };
        ImageRGBAView.prototype.bounds = function () {
            var bbox = this.index.bbox;
            bbox.maxX += this.max_dw;
            bbox.maxY += this.max_dh;
            return bbox;
        };
        return ImageRGBAView;
    }(xy_glyph_1.XYGlyphView);
    exports.ImageRGBAView = ImageRGBAView;
    var ImageRGBA = function (_super) {
        tslib_1.__extends(ImageRGBA, _super);
        function ImageRGBA(attrs) {
            return _super.call(this, attrs) || this;
        }
        ImageRGBA.initClass = function () {
            this.prototype.type = 'ImageRGBA';
            this.prototype.default_view = ImageRGBAView;
            this.define({
                image: [p.NumberSpec],
                dw: [p.DistanceSpec],
                dh: [p.DistanceSpec],
                global_alpha: [
                    p.Number,
                    1
                ],
                dilate: [
                    p.Bool,
                    false
                ]
            });
        };
        return ImageRGBA;
    }(xy_glyph_1.XYGlyph);
    exports.ImageRGBA = ImageRGBA;
    ImageRGBA.initClass();    
},
/*models/glyphs/image_url*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var arrayable_1 = require(22    /* core/util/arrayable */);
    var spatial_1 = require(37    /* core/util/spatial */);
    exports.CanvasImage = Image;
    var ImageURLView = function (_super) {
        tslib_1.__extends(ImageURLView, _super);
        function ImageURLView() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._images_rendered = false;
            return _this;
        }
        ImageURLView.prototype.initialize = function (options) {
            var _this = this;
            _super.prototype.initialize.call(this, options);
            this.connect(this.model.properties.global_alpha.change, function () {
                return _this.renderer.request_render();
            });
        };
        ImageURLView.prototype._index_data = function () {
            return new spatial_1.SpatialIndex([]);
        };
        ImageURLView.prototype._set_data = function () {
            var _this = this;
            if (this.image == null || this.image.length != this._url.length)
                this.image = arrayable_1.map(this._url, function () {
                    return null;
                });
            var _a = this.model, retry_attempts = _a.retry_attempts, retry_timeout = _a.retry_timeout;
            this.retries = arrayable_1.map(this._url, function () {
                return retry_attempts;
            });
            var _loop_1 = function (i, end) {
                if (this_1._url[i] == null)
                    return 'continue';
                var img = new exports.CanvasImage();
                img.onerror = function () {
                    if (_this.retries[i] > 0) {
                        logging_1.logger.trace('ImageURL failed to load ' + _this._url[i] + ' image, retrying in ' + retry_timeout + ' ms');
                        setTimeout(function () {
                            return img.src = _this._url[i];
                        }, retry_timeout);
                    } else
                        logging_1.logger.warn('ImageURL unable to load ' + _this._url[i] + ' image after ' + retry_attempts + ' retries');
                    _this.retries[i] -= 1;
                };
                img.onload = function () {
                    _this.image[i] = img;
                    _this.renderer.request_render();
                };
                img.src = this_1._url[i];
            };
            var this_1 = this;
            for (var i = 0, end = this._url.length; i < end; i++) {
                _loop_1(i, end);
            }
        };
        ImageURLView.prototype.has_finished = function () {
            return _super.prototype.has_finished.call(this) && this._images_rendered == true;
        };
        ImageURLView.prototype._map_data = function () {
            // Better to check this.model.w and this.model.h for null since the set_data
            // machinery will have converted this._w and this._w to lists of null
            var ws = this.model.w != null ? this._w : arrayable_1.map(this._x, function () {
                return NaN;
            });
            var hs = this.model.h != null ? this._h : arrayable_1.map(this._x, function () {
                return NaN;
            });
            switch (this.model.properties.w.units) {
            case 'data': {
                    this.sw = this.sdist(this.renderer.xscale, this._x, ws, 'edge', this.model.dilate);
                    break;
                }
            case 'screen': {
                    this.sw = ws;
                    break;
                }
            }
            switch (this.model.properties.h.units) {
            case 'data': {
                    this.sh = this.sdist(this.renderer.yscale, this._y, hs, 'edge', this.model.dilate);
                    break;
                }
            case 'screen': {
                    this.sh = hs;
                    break;
                }
            }
        };
        ImageURLView.prototype._render = function (ctx, indices, _a) {
            var _url = _a._url, image = _a.image, sx = _a.sx, sy = _a.sy, sw = _a.sw, sh = _a.sh, _angle = _a._angle;
            // TODO (bev): take actual border width into account when clipping
            var frame = this.renderer.plot_view.frame;
            ctx.rect(frame._left.value + 1, frame._top.value + 1, frame._width.value - 2, frame._height.value - 2);
            ctx.clip();
            var finished = true;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + _angle[i]))
                    continue;
                if (this.retries[i] == -1)
                    continue;
                var img = image[i];
                if (img == null) {
                    finished = false;
                    continue;
                }
                this._render_image(ctx, i, img, sx, sy, sw, sh, _angle);
            }
            if (finished && !this._images_rendered) {
                this._images_rendered = true;
                this.notify_finished();
            }
        };
        ImageURLView.prototype._final_sx_sy = function (anchor, sx, sy, sw, sh) {
            switch (anchor) {
            case 'top_left':
                return [
                    sx,
                    sy
                ];
            case 'top_center':
                return [
                    sx - sw / 2,
                    sy
                ];
            case 'top_right':
                return [
                    sx - sw,
                    sy
                ];
            case 'center_right':
                return [
                    sx - sw,
                    sy - sh / 2
                ];
            case 'bottom_right':
                return [
                    sx - sw,
                    sy - sh
                ];
            case 'bottom_center':
                return [
                    sx - sw / 2,
                    sy - sh
                ];
            case 'bottom_left':
                return [
                    sx,
                    sy - sh
                ];
            case 'center_left':
                return [
                    sx,
                    sy - sh / 2
                ];
            case 'center':
                return [
                    sx - sw / 2,
                    sy - sh / 2
                ];
            }
        };
        ImageURLView.prototype._render_image = function (ctx, i, image, sx, sy, sw, sh, angle) {
            if (isNaN(sw[i]))
                sw[i] = image.width;
            if (isNaN(sh[i]))
                sh[i] = image.height;
            var anchor = this.model.anchor;
            var _a = this._final_sx_sy(anchor, sx[i], sy[i], sw[i], sh[i]), sxi = _a[0], syi = _a[1];
            ctx.save();
            ctx.globalAlpha = this.model.global_alpha;
            if (angle[i]) {
                ctx.translate(sxi, syi);
                ctx.rotate(angle[i]);
                ctx.drawImage(image, 0, 0, sw[i], sh[i]);
                ctx.rotate(-angle[i]);
                ctx.translate(-sxi, -syi);
            } else
                ctx.drawImage(image, sxi, syi, sw[i], sh[i]);
            ctx.restore();
        };
        return ImageURLView;
    }(xy_glyph_1.XYGlyphView);
    exports.ImageURLView = ImageURLView;
    var ImageURL = function (_super) {
        tslib_1.__extends(ImageURL, _super);
        function ImageURL(attrs) {
            return _super.call(this, attrs) || this;
        }
        ImageURL.initClass = function () {
            this.prototype.type = 'ImageURL';
            this.prototype.default_view = ImageURLView;
            this.define({
                url: [p.StringSpec],
                anchor: [
                    p.Anchor,
                    'top_left'
                ],
                global_alpha: [
                    p.Number,
                    1
                ],
                angle: [
                    p.AngleSpec,
                    0
                ],
                w: [p.DistanceSpec],
                h: [p.DistanceSpec],
                dilate: [
                    p.Bool,
                    false
                ],
                retry_attempts: [
                    p.Number,
                    0
                ],
                retry_timeout: [
                    p.Number,
                    0
                ]
            });
        };
        return ImageURL;
    }(xy_glyph_1.XYGlyph);
    exports.ImageURL = ImageURL;
    ImageURL.initClass();    
},
/*models/glyphs/index*/
function _(require, module, exports) {
    var annular_wedge_1 = require(106    /* ./annular_wedge */);
    exports.AnnularWedge = annular_wedge_1.AnnularWedge;
    var annulus_1 = require(107    /* ./annulus */);
    exports.Annulus = annulus_1.Annulus;
    var arc_1 = require(108    /* ./arc */);
    exports.Arc = arc_1.Arc;
    var bezier_1 = require(109    /* ./bezier */);
    exports.Bezier = bezier_1.Bezier;
    var circle_1 = require(111    /* ./circle */);
    exports.Circle = circle_1.Circle;
    var ellipse_1 = require(112    /* ./ellipse */);
    exports.Ellipse = ellipse_1.Ellipse;
    var glyph_1 = require(113    /* ./glyph */);
    exports.Glyph = glyph_1.Glyph;
    var hbar_1 = require(114    /* ./hbar */);
    exports.HBar = hbar_1.HBar;
    var hex_tile_1 = require(115    /* ./hex_tile */);
    exports.HexTile = hex_tile_1.HexTile;
    var image_1 = require(116    /* ./image */);
    exports.Image = image_1.Image;
    var image_rgba_1 = require(117    /* ./image_rgba */);
    exports.ImageRGBA = image_rgba_1.ImageRGBA;
    var image_url_1 = require(118    /* ./image_url */);
    exports.ImageURL = image_url_1.ImageURL;
    var line_1 = require(120    /* ./line */);
    exports.Line = line_1.Line;
    var multi_line_1 = require(121    /* ./multi_line */);
    exports.MultiLine = multi_line_1.MultiLine;
    var oval_1 = require(122    /* ./oval */);
    exports.Oval = oval_1.Oval;
    var patch_1 = require(123    /* ./patch */);
    exports.Patch = patch_1.Patch;
    var patches_1 = require(124    /* ./patches */);
    exports.Patches = patches_1.Patches;
    var quad_1 = require(125    /* ./quad */);
    exports.Quad = quad_1.Quad;
    var quadratic_1 = require(126    /* ./quadratic */);
    exports.Quadratic = quadratic_1.Quadratic;
    var ray_1 = require(127    /* ./ray */);
    exports.Ray = ray_1.Ray;
    var rect_1 = require(128    /* ./rect */);
    exports.Rect = rect_1.Rect;
    var segment_1 = require(129    /* ./segment */);
    exports.Segment = segment_1.Segment;
    var step_1 = require(130    /* ./step */);
    exports.Step = step_1.Step;
    var text_1 = require(131    /* ./text */);
    exports.Text = text_1.Text;
    var vbar_1 = require(133    /* ./vbar */);
    exports.VBar = vbar_1.VBar;
    var wedge_1 = require(134    /* ./wedge */);
    exports.Wedge = wedge_1.Wedge;
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    exports.XYGlyph = xy_glyph_1.XYGlyph;    
},
/*models/glyphs/line*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var utils_1 = require(132    /* ./utils */);
    var hittest = require(9    /* core/hittest */);
    var LineView = function (_super) {
        tslib_1.__extends(LineView, _super);
        function LineView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LineView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy;
            var drawing = false;
            var last_index = null;
            this.visuals.line.set_value(ctx);
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (drawing) {
                    if (!isFinite(sx[i] + sy[i])) {
                        ctx.stroke();
                        ctx.beginPath();
                        drawing = false;
                        last_index = i;
                        continue;
                    }
                    if (last_index != null && i - last_index > 1) {
                        ctx.stroke();
                        drawing = false;
                    }
                }
                if (drawing)
                    ctx.lineTo(sx[i], sy[i]);
                else {
                    ctx.beginPath();
                    ctx.moveTo(sx[i], sy[i]);
                    drawing = true;
                }
                last_index = i;
            }
            if (drawing)
                ctx.stroke();
        };
        LineView.prototype._hit_point = function (geometry) {
            var _this = this;
            /* Check if the point geometry hits this line glyph and return an object
        that describes the hit result:
          Args:
            * geometry (object): object with the following keys
              * sx (float): screen x coordinate of the point
              * sy (float): screen y coordinate of the point
              * type (str): type of geometry (in this case it's a point)
          Output:
            Object with the following keys:
              * 0d (bool): whether the point hits the glyph or not
              * 1d (array(int)): array with the indices hit by the point
        */
            var result = hittest.create_empty_hit_test_result();
            var point = {
                x: geometry.sx,
                y: geometry.sy
            };
            var shortest = 9999;
            var threshold = Math.max(2, this.visuals.line.line_width.value() / 2);
            for (var i = 0, end = this.sx.length - 1; i < end; i++) {
                var p0 = {
                    x: this.sx[i],
                    y: this.sy[i]
                };
                var p1 = {
                    x: this.sx[i + 1],
                    y: this.sy[i + 1]
                };
                var dist = hittest.dist_to_segment(point, p0, p1);
                if (dist < threshold && dist < shortest) {
                    shortest = dist;
                    result.add_to_selected_glyphs(this.model);
                    result.get_view = function () {
                        return _this;
                    };
                    result.line_indices = [i];
                }
            }
            return result;
        };
        LineView.prototype._hit_span = function (geometry) {
            var _this = this;
            var sx = geometry.sx, sy = geometry.sy;
            var result = hittest.create_empty_hit_test_result();
            var val;
            var values;
            if (geometry.direction == 'v') {
                val = this.renderer.yscale.invert(sy);
                values = this._y;
            } else {
                val = this.renderer.xscale.invert(sx);
                values = this._x;
            }
            for (var i = 0, end = values.length - 1; i < end; i++) {
                if (values[i] <= val && val <= values[i + 1] || values[i + 1] <= val && val <= values[i]) {
                    result.add_to_selected_glyphs(this.model);
                    result.get_view = function () {
                        return _this;
                    };
                    result.line_indices.push(i);
                }
            }
            return result;
        };
        LineView.prototype.get_interpolation_hit = function (i, geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var _a = [
                    this._x[i],
                    this._y[i],
                    this._x[i + 1],
                    this._y[i + 1]
                ], x2 = _a[0], y2 = _a[1], x3 = _a[2], y3 = _a[3];
            var x0, x1;
            var y0, y1;
            if (geometry.type == 'point') {
                ;
                _b = this.renderer.yscale.r_invert(sy - 1, sy + 1), y0 = _b[0], y1 = _b[1];
                _c = this.renderer.xscale.r_invert(sx - 1, sx + 1), x0 = _c[0], x1 = _c[1];
            } else {
                if (geometry.direction == 'v') {
                    ;
                    _d = this.renderer.yscale.r_invert(sy, sy), y0 = _d[0], y1 = _d[1];
                    _e = [
                        x2,
                        x3
                    ], x0 = _e[0], x1 = _e[1];
                } else {
                    ;
                    _f = this.renderer.xscale.r_invert(sx, sx), x0 = _f[0], x1 = _f[1];
                    _g = [
                        y2,
                        y3
                    ], y0 = _g[0], y1 = _g[1];
                }
            }
            var _h = hittest.check_2_segments_intersect(x0, y0, x1, y1, x2, y2, x3, y3), x = _h.x, y = _h.y;
            return [
                x,
                y
            ];
            // XXX: null is not handled at use sites
            var _b, _c, _d, _e, _f, _g;
        };
        LineView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_line_legend(this.visuals, ctx, bbox, index);
        };
        return LineView;
    }(xy_glyph_1.XYGlyphView);
    exports.LineView = LineView;
    var Line = function (_super) {
        tslib_1.__extends(Line, _super);
        function Line(attrs) {
            return _super.call(this, attrs) || this;
        }
        Line.initClass = function () {
            this.prototype.type = 'Line';
            this.prototype.default_view = LineView;
            this.mixins(['line']);
        };
        return Line;
    }(xy_glyph_1.XYGlyph);
    exports.Line = Line;
    Line.initClass();    
},
/*models/glyphs/multi_line*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var hittest = require(9    /* core/hittest */);
    var object_1 = require(32    /* core/util/object */);
    var array_1 = require(21    /* core/util/array */);
    var types_1 = require(44    /* core/util/types */);
    var glyph_1 = require(113    /* ./glyph */);
    var utils_1 = require(132    /* ./utils */);
    var MultiLineView = function (_super) {
        tslib_1.__extends(MultiLineView, _super);
        function MultiLineView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MultiLineView.prototype._index_data = function () {
            var points = [];
            for (var i = 0, end = this._xs.length; i < end; i++) {
                if (this._xs[i] == null || this._xs[i].length === 0)
                    continue;
                var _xsi = this._xs[i];
                var xs = [];
                for (var j = 0, n = _xsi.length; j < n; j++) {
                    var x = _xsi[j];
                    if (!types_1.isStrictNaN(x))
                        xs.push(x);
                }
                var _ysi = this._ys[i];
                var ys = [];
                for (var j = 0, n = _ysi.length; j < n; j++) {
                    var y = _ysi[j];
                    if (!types_1.isStrictNaN(y))
                        ys.push(y);
                }
                var _a = [
                        array_1.min(xs),
                        array_1.max(xs)
                    ], minX = _a[0], maxX = _a[1];
                var _b = [
                        array_1.min(ys),
                        array_1.max(ys)
                    ], minY = _b[0], maxY = _b[1];
                points.push({
                    minX: minX,
                    minY: minY,
                    maxX: maxX,
                    maxY: maxY,
                    i: i
                });
            }
            return new spatial_1.SpatialIndex(points);
        };
        MultiLineView.prototype._render = function (ctx, indices, _a) {
            var sxs = _a.sxs, sys = _a.sys;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                var _b = [
                        sxs[i],
                        sys[i]
                    ], sx = _b[0], sy = _b[1];
                this.visuals.line.set_vectorize(ctx, i);
                for (var j = 0, end = sx.length; j < end; j++) {
                    if (j == 0) {
                        ctx.beginPath();
                        ctx.moveTo(sx[j], sy[j]);
                        continue;
                    } else if (isNaN(sx[j]) || isNaN(sy[j])) {
                        ctx.stroke();
                        ctx.beginPath();
                        continue;
                    } else
                        ctx.lineTo(sx[j], sy[j]);
                }
                ctx.stroke();
            }
        };
        MultiLineView.prototype._hit_point = function (geometry) {
            var result = hittest.create_empty_hit_test_result();
            var point = {
                x: geometry.sx,
                y: geometry.sy
            };
            var shortest = 9999;
            var hits = {};
            for (var i = 0, end = this.sxs.length; i < end; i++) {
                var threshold = Math.max(2, this.visuals.line.cache_select('line_width', i) / 2);
                var points = null;
                for (var j = 0, endj = this.sxs[i].length - 1; j < endj; j++) {
                    var p0 = {
                        x: this.sxs[i][j],
                        y: this.sys[i][j]
                    };
                    var p1 = {
                        x: this.sxs[i][j + 1],
                        y: this.sys[i][j + 1]
                    };
                    var dist = hittest.dist_to_segment(point, p0, p1);
                    if (dist < threshold && dist < shortest) {
                        shortest = dist;
                        points = [j];
                    }
                }
                if (points)
                    hits[i] = points;
            }
            result.indices = object_1.keys(hits).map(function (x) {
                return parseInt(x, 10);
            });
            result.multiline_indices = hits;
            return result;
        };
        MultiLineView.prototype._hit_span = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var result = hittest.create_empty_hit_test_result();
            var val;
            var values;
            if (geometry.direction === 'v') {
                val = this.renderer.yscale.invert(sy);
                values = this._ys;
            } else {
                val = this.renderer.xscale.invert(sx);
                values = this._xs;
            }
            var hits = {};
            for (var i = 0, end = values.length; i < end; i++) {
                var points = [];
                for (var j = 0, endj = values[i].length - 1; j < endj; j++) {
                    if (values[i][j] <= val && val <= values[i][j + 1])
                        points.push(j);
                }
                if (points.length > 0)
                    hits[i] = points;
            }
            result.indices = object_1.keys(hits).map(function (x) {
                return parseInt(x, 10);
            });
            result.multiline_indices = hits;
            return result;
        };
        MultiLineView.prototype.get_interpolation_hit = function (i, point_i, geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var x2 = this._xs[i][point_i];
            var y2 = this._ys[i][point_i];
            var x3 = this._xs[i][point_i + 1];
            var y3 = this._ys[i][point_i + 1];
            var x0, x1;
            var y0, y1;
            if (geometry.type == 'point') {
                ;
                _a = this.renderer.yscale.r_invert(sy - 1, sy + 1), y0 = _a[0], y1 = _a[1];
                _b = this.renderer.xscale.r_invert(sx - 1, sx + 1), x0 = _b[0], x1 = _b[1];
            } else {
                if (geometry.direction == 'v') {
                    ;
                    _c = this.renderer.yscale.r_invert(sy, sy), y0 = _c[0], y1 = _c[1];
                    _d = [
                        x2,
                        x3
                    ], x0 = _d[0], x1 = _d[1];
                } else {
                    ;
                    _e = this.renderer.xscale.r_invert(sx, sx), x0 = _e[0], x1 = _e[1];
                    _f = [
                        y2,
                        y3
                    ], y0 = _f[0], y1 = _f[1];
                }
            }
            var _g = hittest.check_2_segments_intersect(x0, y0, x1, y1, x2, y2, x3, y3), x = _g.x, y = _g.y;
            return [
                x,
                y
            ];
            // XXX: null is not handled at use sites
            var _a, _b, _c, _d, _e, _f;
        };
        MultiLineView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_line_legend(this.visuals, ctx, bbox, index);
        };
        MultiLineView.prototype.scenterx = function () {
            throw new Error('not implemented');
        };
        MultiLineView.prototype.scentery = function () {
            throw new Error('not implemented');
        };
        return MultiLineView;
    }(glyph_1.GlyphView);
    exports.MultiLineView = MultiLineView;
    var MultiLine = function (_super) {
        tslib_1.__extends(MultiLine, _super);
        function MultiLine(attrs) {
            return _super.call(this, attrs) || this;
        }
        MultiLine.initClass = function () {
            this.prototype.type = 'MultiLine';
            this.prototype.default_view = MultiLineView;
            this.coords([[
                    'xs',
                    'ys'
                ]]);
            this.mixins(['line']);
        };
        return MultiLine;
    }(glyph_1.Glyph);
    exports.MultiLine = MultiLine;
    MultiLine.initClass();    
},
/*models/glyphs/oval*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var p = require(15    /* core/properties */);
    var OvalView = function (_super) {
        tslib_1.__extends(OvalView, _super);
        function OvalView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        OvalView.prototype._set_data = function () {
            this.max_w2 = 0;
            if (this.model.properties.width.units == 'data')
                this.max_w2 = this.max_width / 2;
            this.max_h2 = 0;
            if (this.model.properties.height.units == 'data')
                this.max_h2 = this.max_height / 2;
        };
        OvalView.prototype._map_data = function () {
            if (this.model.properties.width.units == 'data')
                this.sw = this.sdist(this.renderer.xscale, this._x, this._width, 'center');
            else
                this.sw = this._width;
            if (this.model.properties.height.units == 'data')
                this.sh = this.sdist(this.renderer.yscale, this._y, this._height, 'center');
            else
                this.sh = this._height;
        };
        OvalView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sw = _a.sw, sh = _a.sh, _angle = _a._angle;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sw[i] + sh[i] + _angle[i]))
                    continue;
                ctx.translate(sx[i], sy[i]);
                ctx.rotate(_angle[i]);
                ctx.beginPath();
                ctx.moveTo(0, -sh[i] / 2);
                ctx.bezierCurveTo(sw[i] / 2, -sh[i] / 2, sw[i] / 2, sh[i] / 2, 0, sh[i] / 2);
                ctx.bezierCurveTo(-sw[i] / 2, sh[i] / 2, -sw[i] / 2, -sh[i] / 2, 0, -sh[i] / 2);
                ctx.closePath();
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
                ctx.rotate(-_angle[i]);
                ctx.translate(-sx[i], -sy[i]);
            }
        };
        OvalView.prototype.draw_legend_for_index = function (ctx, _a, index) {
            var x0 = _a.x0, y0 = _a.y0, x1 = _a.x1, y1 = _a.y1;
            var len = index + 1;
            var sx = new Array(len);
            sx[index] = (x0 + x1) / 2;
            var sy = new Array(len);
            sy[index] = (y0 + y1) / 2;
            var scale = this.sw[index] / this.sh[index];
            var d = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.8;
            var sw = new Array(len);
            var sh = new Array(len);
            if (scale > 1) {
                sw[index] = d;
                sh[index] = d / scale;
            } else {
                sw[index] = d * scale;
                sh[index] = d;
            }
            this._render(ctx, [index], {
                sx: sx,
                sy: sy,
                sw: sw,
                sh: sh
            });    // XXX
        };
        OvalView.prototype._bounds = function (_a) {
            var minX = _a.minX, maxX = _a.maxX, minY = _a.minY, maxY = _a.maxY;
            return {
                minX: minX - this.max_w2,
                maxX: maxX + this.max_w2,
                minY: minY - this.max_h2,
                maxY: maxY + this.max_h2
            };
        };
        return OvalView;
    }(xy_glyph_1.XYGlyphView);
    exports.OvalView = OvalView;
    var Oval = function (_super) {
        tslib_1.__extends(Oval, _super);
        function Oval(attrs) {
            return _super.call(this, attrs) || this;
        }
        Oval.initClass = function () {
            this.prototype.type = 'Oval';
            this.prototype.default_view = OvalView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                angle: [
                    p.AngleSpec,
                    0
                ],
                width: [p.DistanceSpec],
                height: [p.DistanceSpec]
            });
        };
        return Oval;
    }(xy_glyph_1.XYGlyph);
    exports.Oval = Oval;
    Oval.initClass();    
},
/*models/glyphs/patch*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var utils_1 = require(132    /* ./utils */);
    var PatchView = function (_super) {
        tslib_1.__extends(PatchView, _super);
        function PatchView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PatchView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy;
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (i == 0) {
                        ctx.beginPath();
                        ctx.moveTo(sx[i], sy[i]);
                        continue;
                    } else if (isNaN(sx[i] + sy[i])) {
                        ctx.closePath();
                        ctx.fill();
                        ctx.beginPath();
                        continue;
                    } else
                        ctx.lineTo(sx[i], sy[i]);
                }
                ctx.closePath();
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                for (var _b = 0, indices_2 = indices; _b < indices_2.length; _b++) {
                    var i = indices_2[_b];
                    if (i == 0) {
                        ctx.beginPath();
                        ctx.moveTo(sx[i], sy[i]);
                        continue;
                    } else if (isNaN(sx[i] + sy[i])) {
                        ctx.closePath();
                        ctx.stroke();
                        ctx.beginPath();
                        continue;
                    } else
                        ctx.lineTo(sx[i], sy[i]);
                }
                ctx.closePath();
                return ctx.stroke();
            }
        };
        PatchView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_area_legend(this.visuals, ctx, bbox, index);
        };
        return PatchView;
    }(xy_glyph_1.XYGlyphView);
    exports.PatchView = PatchView;
    var Patch = function (_super) {
        tslib_1.__extends(Patch, _super);
        function Patch(attrs) {
            return _super.call(this, attrs) || this;
        }
        Patch.initClass = function () {
            this.prototype.type = 'Patch';
            this.prototype.default_view = PatchView;
            this.mixins([
                'line',
                'fill'
            ]);
        };
        return Patch;
    }(xy_glyph_1.XYGlyph);
    exports.Patch = Patch;
    Patch.initClass();    
},
/*models/glyphs/patches*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var glyph_1 = require(113    /* ./glyph */);
    var utils_1 = require(132    /* ./utils */);
    var array_1 = require(21    /* core/util/array */);
    var arrayable_1 = require(22    /* core/util/arrayable */);
    var types_1 = require(44    /* core/util/types */);
    var hittest = require(9    /* core/hittest */);
    var PatchesView = function (_super) {
        tslib_1.__extends(PatchesView, _super);
        function PatchesView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PatchesView.prototype._build_discontinuous_object = function (nanned_qs) {
            // _s is this.xs, this.ys, this.sxs, this.sys
            // an object of n 1-d arrays in either data or screen units
            //
            // Each 1-d array gets broken to an array of arrays split
            // on any NaNs
            //
            // So:
            // { 0: [x11, x12],
            //   1: [x21, x22, x23],
            //   2: [x31, NaN, x32]
            // }
            // becomes
            // { 0: [[x11, x12]],
            //   1: [[x21, x22, x23]],
            //   2: [[x31],[x32]]
            // }
            var ds = [];
            for (var i = 0, end = nanned_qs.length; i < end; i++) {
                ds[i] = [];
                var qs = array_1.copy(nanned_qs[i]);
                while (qs.length > 0) {
                    var nan_index = array_1.findLastIndex(qs, function (q) {
                        return types_1.isStrictNaN(q);
                    });
                    var qs_part = void 0;
                    if (nan_index >= 0)
                        qs_part = qs.splice(nan_index);
                    else {
                        qs_part = qs;
                        qs = [];
                    }
                    var denanned = qs_part.filter(function (q) {
                        return !types_1.isStrictNaN(q);
                    });
                    ds[i].push(denanned);
                }
            }
            return ds;
        };
        PatchesView.prototype._index_data = function () {
            var xss = this._build_discontinuous_object(this._xs);
            // XXX
            var yss = this._build_discontinuous_object(this._ys);
            // XXX
            var points = [];
            for (var i = 0, end = this._xs.length; i < end; i++) {
                for (var j = 0, endj = xss[i].length; j < endj; j++) {
                    var xs = xss[i][j];
                    var ys = yss[i][j];
                    if (xs.length == 0)
                        continue;
                    points.push({
                        minX: array_1.min(xs),
                        minY: array_1.min(ys),
                        maxX: array_1.max(xs),
                        maxY: array_1.max(ys),
                        i: i
                    });
                }
            }
            return new spatial_1.SpatialIndex(points);
        };
        PatchesView.prototype._mask_data = function () {
            var xr = this.renderer.plot_view.frame.x_ranges['default'];
            var _a = [
                    xr.min,
                    xr.max
                ], x0 = _a[0], x1 = _a[1];
            var yr = this.renderer.plot_view.frame.y_ranges['default'];
            var _b = [
                    yr.min,
                    yr.max
                ], y0 = _b[0], y1 = _b[1];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var indices = this.index.indices(bbox);
            // TODO (bev) this should be under test
            return indices.sort(function (a, b) {
                return a - b;
            });
        };
        PatchesView.prototype._render = function (ctx, indices, _a) {
            var sxs = _a.sxs, sys = _a.sys;
            // this.sxss and this.syss are used by _hit_point and sxc, syc
            // This is the earliest we can build them, and only build them once
            this.sxss = this._build_discontinuous_object(sxs);
            // XXX
            this.syss = this._build_discontinuous_object(sys);
            // XXX
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                var _b = [
                        sxs[i],
                        sys[i]
                    ], sx = _b[0], sy = _b[1];
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    for (var j = 0, end = sx.length; j < end; j++) {
                        if (j == 0) {
                            ctx.beginPath();
                            ctx.moveTo(sx[j], sy[j]);
                            continue;
                        } else if (isNaN(sx[j] + sy[j])) {
                            ctx.closePath();
                            ctx.fill();
                            ctx.beginPath();
                            continue;
                        } else
                            ctx.lineTo(sx[j], sy[j]);
                    }
                    ctx.closePath();
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    for (var j = 0, end = sx.length; j < end; j++) {
                        if (j == 0) {
                            ctx.beginPath();
                            ctx.moveTo(sx[j], sy[j]);
                            continue;
                        } else if (isNaN(sx[j] + sy[j])) {
                            ctx.closePath();
                            ctx.stroke();
                            ctx.beginPath();
                            continue;
                        } else
                            ctx.lineTo(sx[j], sy[j]);
                    }
                    ctx.closePath();
                    ctx.stroke();
                }
            }
        };
        PatchesView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            var candidates = this.index.indices({
                minX: x,
                minY: y,
                maxX: x,
                maxY: y
            });
            var hits = [];
            for (var i = 0, end = candidates.length; i < end; i++) {
                var idx = candidates[i];
                var sxs = this.sxss[idx];
                var sys = this.syss[idx];
                for (var j = 0, endj = sxs.length; j < endj; j++) {
                    if (hittest.point_in_poly(sx, sy, sxs[j], sys[j])) {
                        hits.push(idx);
                    }
                }
            }
            var result = hittest.create_empty_hit_test_result();
            result.indices = hits;
            return result;
        };
        PatchesView.prototype._get_snap_coord = function (array) {
            return arrayable_1.sum(array) / array.length;
        };
        PatchesView.prototype.scenterx = function (i, sx, sy) {
            if (this.sxss[i].length == 1) {
                // We don't have discontinuous objects so we're ok
                return this._get_snap_coord(this.sxs[i]);
            } else {
                // We have discontinuous objects, so we need to find which
                // one we're in, we can use point_in_poly again
                var sxs = this.sxss[i];
                var sys = this.syss[i];
                for (var j = 0, end = sxs.length; j < end; j++) {
                    if (hittest.point_in_poly(sx, sy, sxs[j], sys[j]))
                        return this._get_snap_coord(sxs[j]);
                }
            }
            throw new Error('unreachable code');
        };
        PatchesView.prototype.scentery = function (i, sx, sy) {
            if (this.syss[i].length == 1) {
                // We don't have discontinuous objects so we're ok
                return this._get_snap_coord(this.sys[i]);
            } else {
                // We have discontinuous objects, so we need to find which
                // one we're in, we can use point_in_poly again
                var sxs = this.sxss[i];
                var sys = this.syss[i];
                for (var j = 0, end = sxs.length; j < end; j++) {
                    if (hittest.point_in_poly(sx, sy, sxs[j], sys[j]))
                        return this._get_snap_coord(sys[j]);
                }
            }
            throw new Error('unreachable code');
        };
        PatchesView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_area_legend(this.visuals, ctx, bbox, index);
        };
        return PatchesView;
    }(glyph_1.GlyphView);
    exports.PatchesView = PatchesView;
    var Patches = function (_super) {
        tslib_1.__extends(Patches, _super);
        function Patches(attrs) {
            return _super.call(this, attrs) || this;
        }
        Patches.initClass = function () {
            this.prototype.type = 'Patches';
            this.prototype.default_view = PatchesView;
            this.coords([[
                    'xs',
                    'ys'
                ]]);
            this.mixins([
                'line',
                'fill'
            ]);
        };
        return Patches;
    }(glyph_1.Glyph);
    exports.Patches = Patches;
    Patches.initClass();    
},
/*models/glyphs/quad*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var box_1 = require(110    /* ./box */);
    var QuadView = function (_super) {
        tslib_1.__extends(QuadView, _super);
        function QuadView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        QuadView.prototype.get_anchor_point = function (anchor, i, _spt) {
            var left = Math.min(this.sleft[i], this.sright[i]);
            var right = Math.max(this.sright[i], this.sleft[i]);
            var top = Math.min(this.stop[i], this.sbottom[i]);
            // screen coordinates !!!
            var bottom = Math.max(this.sbottom[i], this.stop[i]);
            //
            switch (anchor) {
            case 'top_left':
                return {
                    x: left,
                    y: top
                };
            case 'top_center':
                return {
                    x: (left + right) / 2,
                    y: top
                };
            case 'top_right':
                return {
                    x: right,
                    y: top
                };
            case 'center_right':
                return {
                    x: right,
                    y: (top + bottom) / 2
                };
            case 'bottom_right':
                return {
                    x: right,
                    y: bottom
                };
            case 'bottom_center':
                return {
                    x: (left + right) / 2,
                    y: bottom
                };
            case 'bottom_left':
                return {
                    x: left,
                    y: bottom
                };
            case 'center_left':
                return {
                    x: left,
                    y: (top + bottom) / 2
                };
            case 'center':
                return {
                    x: (left + right) / 2,
                    y: (top + bottom) / 2
                };
            default:
                return null;
            }
        };
        QuadView.prototype.scenterx = function (i) {
            return (this.sleft[i] + this.sright[i]) / 2;
        };
        QuadView.prototype.scentery = function (i) {
            return (this.stop[i] + this.sbottom[i]) / 2;
        };
        QuadView.prototype._index_data = function () {
            return this._index_box(this._right.length);
        };
        QuadView.prototype._lrtb = function (i) {
            var l = this._left[i];
            var r = this._right[i];
            var t = this._top[i];
            var b = this._bottom[i];
            return [
                l,
                r,
                t,
                b
            ];
        };
        return QuadView;
    }(box_1.BoxView);
    exports.QuadView = QuadView;
    var Quad = function (_super) {
        tslib_1.__extends(Quad, _super);
        function Quad(attrs) {
            return _super.call(this, attrs) || this;
        }
        Quad.initClass = function () {
            this.prototype.type = 'Quad';
            this.prototype.default_view = QuadView;
            this.coords([
                [
                    'right',
                    'bottom'
                ],
                [
                    'left',
                    'top'
                ]
            ]);
        };
        return Quad;
    }(box_1.Box);
    exports.Quad = Quad;
    Quad.initClass();    
},
/*models/glyphs/quadratic*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var glyph_1 = require(113    /* ./glyph */);
    var utils_1 = require(132    /* ./utils */);
    // Formula from: http://pomax.nihongoresources.com/pages/bezier/
    //
    // if segment is quadratic bezier do:
    //   for both directions do:
    //     if control between start and end, compute linear bounding box
    //     otherwise, compute
    //       bound = u(1-t)^2 + 2v(1-t)t + wt^2
    //         (with t = ((u-v) / (u-2v+w)), with {u = start, v = control, w = end})
    //       if control precedes start, min = bound, otherwise max = bound
    function _qbb(u, v, w) {
        if (v == (u + w) / 2)
            return [
                u,
                w
            ];
        else {
            var t = (u - v) / (u - 2 * v + w);
            var bd = u * Math.pow(1 - t, 2) + 2 * v * (1 - t) * t + w * Math.pow(t, 2);
            return [
                Math.min(u, w, bd),
                Math.max(u, w, bd)
            ];
        }
    }
    var QuadraticView = function (_super) {
        tslib_1.__extends(QuadraticView, _super);
        function QuadraticView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        QuadraticView.prototype._index_data = function () {
            var points = [];
            for (var i = 0, end = this._x0.length; i < end; i++) {
                if (isNaN(this._x0[i] + this._x1[i] + this._y0[i] + this._y1[i] + this._cx[i] + this._cy[i]))
                    continue;
                var _a = _qbb(this._x0[i], this._cx[i], this._x1[i]), x0 = _a[0], x1 = _a[1];
                var _b = _qbb(this._y0[i], this._cy[i], this._y1[i]), y0 = _b[0], y1 = _b[1];
                points.push({
                    minX: x0,
                    minY: y0,
                    maxX: x1,
                    maxY: y1,
                    i: i
                });
            }
            return new spatial_1.SpatialIndex(points);
        };
        QuadraticView.prototype._render = function (ctx, indices, _a) {
            var sx0 = _a.sx0, sy0 = _a.sy0, sx1 = _a.sx1, sy1 = _a.sy1, scx = _a.scx, scy = _a.scy;
            if (this.visuals.line.doit) {
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (isNaN(sx0[i] + sy0[i] + sx1[i] + sy1[i] + scx[i] + scy[i]))
                        continue;
                    ctx.beginPath();
                    ctx.moveTo(sx0[i], sy0[i]);
                    ctx.quadraticCurveTo(scx[i], scy[i], sx1[i], sy1[i]);
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        QuadraticView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_line_legend(this.visuals, ctx, bbox, index);
        };
        QuadraticView.prototype.scenterx = function () {
            throw new Error('not implemented');
        };
        QuadraticView.prototype.scentery = function () {
            throw new Error('not implemented');
        };
        return QuadraticView;
    }(glyph_1.GlyphView);
    exports.QuadraticView = QuadraticView;
    var Quadratic = function (_super) {
        tslib_1.__extends(Quadratic, _super);
        function Quadratic(attrs) {
            return _super.call(this, attrs) || this;
        }
        Quadratic.initClass = function () {
            this.prototype.type = 'Quadratic';
            this.prototype.default_view = QuadraticView;
            this.coords([
                [
                    'x0',
                    'y0'
                ],
                [
                    'x1',
                    'y1'
                ],
                [
                    'cx',
                    'cy'
                ]
            ]);
            this.mixins(['line']);
        };
        return Quadratic;
    }(glyph_1.Glyph);
    exports.Quadratic = Quadratic;
    Quadratic.initClass();    
},
/*models/glyphs/ray*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var utils_1 = require(132    /* ./utils */);
    var p = require(15    /* core/properties */);
    var RayView = function (_super) {
        tslib_1.__extends(RayView, _super);
        function RayView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        RayView.prototype._map_data = function () {
            if (this.model.properties.length.units == 'data')
                this.slength = this.sdist(this.renderer.xscale, this._x, this._length);
            else
                this.slength = this._length;
        };
        RayView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, slength = _a.slength, _angle = _a._angle;
            if (this.visuals.line.doit) {
                var width = this.renderer.plot_view.frame._width.value;
                var height = this.renderer.plot_view.frame._height.value;
                var inf_len = 2 * (width + height);
                for (var i = 0, end = slength.length; i < end; i++) {
                    if (slength[i] == 0)
                        slength[i] = inf_len;
                }
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (isNaN(sx[i] + sy[i] + _angle[i] + slength[i]))
                        continue;
                    ctx.translate(sx[i], sy[i]);
                    ctx.rotate(_angle[i]);
                    ctx.beginPath();
                    ctx.moveTo(0, 0);
                    ctx.lineTo(slength[i], 0);
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                    ctx.rotate(-_angle[i]);
                    ctx.translate(-sx[i], -sy[i]);
                }
            }
        };
        RayView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_line_legend(this.visuals, ctx, bbox, index);
        };
        return RayView;
    }(xy_glyph_1.XYGlyphView);
    exports.RayView = RayView;
    var Ray = function (_super) {
        tslib_1.__extends(Ray, _super);
        function Ray(attrs) {
            return _super.call(this, attrs) || this;
        }
        Ray.initClass = function () {
            this.prototype.type = 'Ray';
            this.prototype.default_view = RayView;
            this.mixins(['line']);
            this.define({
                length: [p.DistanceSpec],
                angle: [p.AngleSpec]
            });
        };
        return Ray;
    }(xy_glyph_1.XYGlyph);
    exports.Ray = Ray;
    Ray.initClass();    
},
/*models/glyphs/rect*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var utils_1 = require(132    /* ./utils */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var arrayable_1 = require(22    /* core/util/arrayable */);
    var RectView = function (_super) {
        tslib_1.__extends(RectView, _super);
        function RectView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        RectView.prototype._set_data = function () {
            this.max_w2 = 0;
            if (this.model.properties.width.units == 'data')
                this.max_w2 = this.max_width / 2;
            this.max_h2 = 0;
            if (this.model.properties.height.units == 'data')
                this.max_h2 = this.max_height / 2;
        };
        RectView.prototype._map_data = function () {
            if (this.model.properties.width.units == 'data')
                _a = this._map_dist_corner_for_data_side_length(this._x, this._width, this.renderer.xscale), this.sw = _a[0], this.sx0 = _a[1];
            else {
                this.sw = this._width;
                var n_1 = this.sx.length;
                this.sx0 = new Float64Array(n_1);
                for (var i = 0; i < n_1; i++)
                    this.sx0[i] = this.sx[i] - this.sw[i] / 2;
            }
            if (this.model.properties.height.units == 'data')
                _b = this._map_dist_corner_for_data_side_length(this._y, this._height, this.renderer.yscale), this.sh = _b[0], this.sy1 = _b[1];
            else {
                this.sh = this._height;
                var n_2 = this.sy.length;
                this.sy1 = new Float64Array(n_2);
                for (var i = 0; i < n_2; i++)
                    this.sy1[i] = this.sy[i] - this.sh[i] / 2;
            }
            var n = this.sw.length;
            this.ssemi_diag = new Float64Array(n);
            for (var i = 0; i < n; i++)
                this.ssemi_diag[i] = Math.sqrt(this.sw[i] / 2 * this.sw[i] / 2 + this.sh[i] / 2 * this.sh[i] / 2);
            var _a, _b;
        };
        RectView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sx0 = _a.sx0, sy1 = _a.sy1, sw = _a.sw, sh = _a.sh, _angle = _a._angle;
            if (this.visuals.fill.doit) {
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (isNaN(sx[i] + sy[i] + sx0[i] + sy1[i] + sw[i] + sh[i] + _angle[i]))
                        continue;
                    //no need to test the return value, we call fillRect for every glyph anyway
                    this.visuals.fill.set_vectorize(ctx, i);
                    if (_angle[i]) {
                        ctx.translate(sx[i], sy[i]);
                        ctx.rotate(_angle[i]);
                        ctx.fillRect(-sw[i] / 2, -sh[i] / 2, sw[i], sh[i]);
                        ctx.rotate(-_angle[i]);
                        ctx.translate(-sx[i], -sy[i]);
                    } else
                        ctx.fillRect(sx0[i], sy1[i], sw[i], sh[i]);
                }
            }
            if (this.visuals.line.doit) {
                ctx.beginPath();
                for (var _b = 0, indices_2 = indices; _b < indices_2.length; _b++) {
                    var i = indices_2[_b];
                    if (isNaN(sx[i] + sy[i] + sx0[i] + sy1[i] + sw[i] + sh[i] + _angle[i]))
                        continue;
                    // fillRect does not fill zero-height or -width rects, but rect(...)
                    // does seem to stroke them (1px wide or tall). Explicitly ignore rects
                    // with zero width or height to be consistent
                    if (sw[i] == 0 || sh[i] == 0)
                        continue;
                    if (_angle[i]) {
                        ctx.translate(sx[i], sy[i]);
                        ctx.rotate(_angle[i]);
                        ctx.rect(-sw[i] / 2, -sh[i] / 2, sw[i], sh[i]);
                        ctx.rotate(-_angle[i]);
                        ctx.translate(-sx[i], -sy[i]);
                    } else
                        ctx.rect(sx0[i], sy1[i], sw[i], sh[i]);
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                    ctx.beginPath();
                }
                ctx.stroke();
            }
        };
        RectView.prototype._hit_rect = function (geometry) {
            return this._hit_rect_against_index(geometry);
        };
        RectView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            var scenter_x = [];
            for (var i = 0, end = this.sx0.length; i < end; i++) {
                scenter_x.push(this.sx0[i] + this.sw[i] / 2);
            }
            var scenter_y = [];
            for (var i = 0, end = this.sy1.length; i < end; i++) {
                scenter_y.push(this.sy1[i] + this.sh[i] / 2);
            }
            var max_x2_ddist = arrayable_1.max(this._ddist(0, scenter_x, this.ssemi_diag));
            var max_y2_ddist = arrayable_1.max(this._ddist(1, scenter_y, this.ssemi_diag));
            var x0 = x - max_x2_ddist;
            var x1 = x + max_x2_ddist;
            var y0 = y - max_y2_ddist;
            var y1 = y + max_y2_ddist;
            var hits = [];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            for (var _i = 0, _a = this.index.indices(bbox); _i < _a.length; _i++) {
                var i = _a[_i];
                var height_in = void 0, width_in = void 0;
                if (this._angle[i]) {
                    var s = Math.sin(-this._angle[i]);
                    var c = Math.cos(-this._angle[i]);
                    var px = c * (sx - this.sx[i]) - s * (sy - this.sy[i]) + this.sx[i];
                    var py = s * (sx - this.sx[i]) + c * (sy - this.sy[i]) + this.sy[i];
                    sx = px;
                    sy = py;
                    width_in = Math.abs(this.sx[i] - sx) <= this.sw[i] / 2;
                    height_in = Math.abs(this.sy[i] - sy) <= this.sh[i] / 2;
                } else {
                    width_in = sx - this.sx0[i] <= this.sw[i] && sx - this.sx0[i] >= 0;
                    height_in = sy - this.sy1[i] <= this.sh[i] && sy - this.sy1[i] >= 0;
                }
                if (height_in && width_in)
                    hits.push(i);
            }
            var result = hittest.create_empty_hit_test_result();
            result.indices = hits;
            return result;
        };
        RectView.prototype._map_dist_corner_for_data_side_length = function (coord, side_length, scale) {
            var n = coord.length;
            var pt0 = new Float64Array(n);
            var pt1 = new Float64Array(n);
            for (var i = 0; i < n; i++) {
                pt0[i] = Number(coord[i]) - side_length[i] / 2;
                pt1[i] = Number(coord[i]) + side_length[i] / 2;
            }
            var spt0 = scale.v_compute(pt0);
            var spt1 = scale.v_compute(pt1);
            var sside_length = this.sdist(scale, pt0, side_length, 'edge', this.model.dilate);
            var spt_corner = spt0;
            for (var i = 0, end = spt0.length; i < end; i++) {
                if (spt0[i] != spt1[i]) {
                    spt_corner = spt0[i] < spt1[i] ? spt0 : spt1;
                    break;
                }
            }
            return [
                sside_length,
                spt_corner
            ];
        };
        RectView.prototype._ddist = function (dim, spts, spans) {
            var scale = dim == 0 ? this.renderer.xscale : this.renderer.yscale;
            var spt0 = spts;
            var m = spt0.length;
            var spt1 = new Float64Array(m);
            for (var i = 0; i < m; i++)
                spt1[i] = spt0[i] + spans[i];
            var pt0 = scale.v_invert(spt0);
            var pt1 = scale.v_invert(spt1);
            var n = pt0.length;
            var ddist = new Float64Array(n);
            for (var i = 0; i < n; i++)
                ddist[i] = Math.abs(pt1[i] - pt0[i]);
            return ddist;
        };
        RectView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_area_legend(this.visuals, ctx, bbox, index);
        };
        RectView.prototype._bounds = function (_a) {
            var minX = _a.minX, maxX = _a.maxX, minY = _a.minY, maxY = _a.maxY;
            return {
                minX: minX - this.max_w2,
                maxX: maxX + this.max_w2,
                minY: minY - this.max_h2,
                maxY: maxY + this.max_h2
            };
        };
        return RectView;
    }(xy_glyph_1.XYGlyphView);
    exports.RectView = RectView;
    var Rect = function (_super) {
        tslib_1.__extends(Rect, _super);
        function Rect(attrs) {
            return _super.call(this, attrs) || this;
        }
        Rect.initClass = function () {
            this.prototype.type = 'Rect';
            this.prototype.default_view = RectView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                angle: [
                    p.AngleSpec,
                    0
                ],
                width: [p.DistanceSpec],
                height: [p.DistanceSpec],
                dilate: [
                    p.Bool,
                    false
                ]
            });
        };
        return Rect;
    }(xy_glyph_1.XYGlyph);
    exports.Rect = Rect;
    Rect.initClass();    
},
/*models/glyphs/segment*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var hittest = require(9    /* core/hittest */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var glyph_1 = require(113    /* ./glyph */);
    var utils_1 = require(132    /* ./utils */);
    var SegmentView = function (_super) {
        tslib_1.__extends(SegmentView, _super);
        function SegmentView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SegmentView.prototype._index_data = function () {
            var points = [];
            for (var i = 0, end = this._x0.length; i < end; i++) {
                var x0 = this._x0[i];
                var x1 = this._x1[i];
                var y0 = this._y0[i];
                var y1 = this._y1[i];
                if (!isNaN(x0 + x1 + y0 + y1)) {
                    points.push({
                        minX: Math.min(x0, x1),
                        minY: Math.min(y0, y1),
                        maxX: Math.max(x0, x1),
                        maxY: Math.max(y0, y1),
                        i: i
                    });
                }
            }
            return new spatial_1.SpatialIndex(points);
        };
        SegmentView.prototype._render = function (ctx, indices, _a) {
            var sx0 = _a.sx0, sy0 = _a.sy0, sx1 = _a.sx1, sy1 = _a.sy1;
            if (this.visuals.line.doit) {
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (isNaN(sx0[i] + sy0[i] + sx1[i] + sy1[i]))
                        continue;
                    ctx.beginPath();
                    ctx.moveTo(sx0[i], sy0[i]);
                    ctx.lineTo(sx1[i], sy1[i]);
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        SegmentView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var point = {
                x: sx,
                y: sy
            };
            var hits = [];
            var lw_voffset = 2;
            // FIXME: Use maximum of segments line_width/2 instead of magic constant 2
            var _a = this.renderer.xscale.r_invert(sx - lw_voffset, sx + lw_voffset), minX = _a[0], maxX = _a[1];
            var _b = this.renderer.yscale.r_invert(sy - lw_voffset, sy + lw_voffset), minY = _b[0], maxY = _b[1];
            var candidates = this.index.indices({
                minX: minX,
                minY: minY,
                maxX: maxX,
                maxY: maxY
            });
            for (var _i = 0, candidates_1 = candidates; _i < candidates_1.length; _i++) {
                var i = candidates_1[_i];
                var threshold2 = Math.pow(Math.max(2, this.visuals.line.cache_select('line_width', i) / 2), 2);
                var p0 = {
                    x: this.sx0[i],
                    y: this.sy0[i]
                };
                var p1 = {
                    x: this.sx1[i],
                    y: this.sy1[i]
                };
                var dist2 = hittest.dist_to_segment_squared(point, p0, p1);
                if (dist2 < threshold2)
                    hits.push(i);
            }
            var result = hittest.create_empty_hit_test_result();
            result.indices = hits;
            return result;
        };
        SegmentView.prototype._hit_span = function (geometry) {
            var _a = this.renderer.plot_view.frame.bbox.ranges, hr = _a[0], vr = _a[1];
            var sx = geometry.sx, sy = geometry.sy;
            var v0;
            var v1;
            var val;
            if (geometry.direction == 'v') {
                val = this.renderer.yscale.invert(sy);
                _b = [
                    this._y0,
                    this._y1
                ], v0 = _b[0], v1 = _b[1];
            } else {
                val = this.renderer.xscale.invert(sx);
                _c = [
                    this._x0,
                    this._x1
                ], v0 = _c[0], v1 = _c[1];
            }
            var hits = [];
            var _d = this.renderer.xscale.r_invert(hr.start, hr.end), minX = _d[0], maxX = _d[1];
            var _e = this.renderer.yscale.r_invert(vr.start, vr.end), minY = _e[0], maxY = _e[1];
            var candidates = this.index.indices({
                minX: minX,
                minY: minY,
                maxX: maxX,
                maxY: maxY
            });
            for (var _i = 0, candidates_2 = candidates; _i < candidates_2.length; _i++) {
                var i = candidates_2[_i];
                if (v0[i] <= val && val <= v1[i] || v1[i] <= val && val <= v0[i])
                    hits.push(i);
            }
            var result = hittest.create_empty_hit_test_result();
            result.indices = hits;
            return result;
            var _b, _c;
        };
        SegmentView.prototype.scenterx = function (i) {
            return (this.sx0[i] + this.sx1[i]) / 2;
        };
        SegmentView.prototype.scentery = function (i) {
            return (this.sy0[i] + this.sy1[i]) / 2;
        };
        SegmentView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_line_legend(this.visuals, ctx, bbox, index);
        };
        return SegmentView;
    }(glyph_1.GlyphView);
    exports.SegmentView = SegmentView;
    var Segment = function (_super) {
        tslib_1.__extends(Segment, _super);
        function Segment(attrs) {
            return _super.call(this, attrs) || this;
        }
        Segment.initClass = function () {
            this.prototype.type = 'Segment';
            this.prototype.default_view = SegmentView;
            this.coords([
                [
                    'x0',
                    'y0'
                ],
                [
                    'x1',
                    'y1'
                ]
            ]);
            this.mixins(['line']);
        };
        return Segment;
    }(glyph_1.Glyph);
    exports.Segment = Segment;
    Segment.initClass();    
},
/*models/glyphs/step*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var utils_1 = require(132    /* ./utils */);
    var p = require(15    /* core/properties */);
    var StepView = function (_super) {
        tslib_1.__extends(StepView, _super);
        function StepView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        StepView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy;
            this.visuals.line.set_value(ctx);
            var L = indices.length;
            if (L < 2)
                return;
            ctx.beginPath();
            ctx.moveTo(sx[0], sy[0]);
            for (var i = 1; i < L; i++) {
                var x1 = void 0, x2 = void 0;
                var y1 = void 0, y2 = void 0;
                switch (this.model.mode) {
                case 'before': {
                        ;
                        _b = [
                            sx[i - 1],
                            sy[i]
                        ], x1 = _b[0], y1 = _b[1];
                        _c = [
                            sx[i],
                            sy[i]
                        ], x2 = _c[0], y2 = _c[1];
                        break;
                    }
                case 'after': {
                        ;
                        _d = [
                            sx[i],
                            sy[i - 1]
                        ], x1 = _d[0], y1 = _d[1];
                        _e = [
                            sx[i],
                            sy[i]
                        ], x2 = _e[0], y2 = _e[1];
                        break;
                    }
                case 'center': {
                        var xm = (sx[i - 1] + sx[i]) / 2;
                        _f = [
                            xm,
                            sy[i - 1]
                        ], x1 = _f[0], y1 = _f[1];
                        _g = [
                            xm,
                            sy[i]
                        ], x2 = _g[0], y2 = _g[1];
                        break;
                    }
                default:
                    throw new Error('unexpected');
                }
                ctx.lineTo(x1, y1);
                ctx.lineTo(x2, y2);
            }
            ctx.lineTo(sx[L - 1], sy[L - 1]);
            ctx.stroke();
            var _b, _c, _d, _e, _f, _g;
        };
        StepView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_line_legend(this.visuals, ctx, bbox, index);
        };
        return StepView;
    }(xy_glyph_1.XYGlyphView);
    exports.StepView = StepView;
    var Step = function (_super) {
        tslib_1.__extends(Step, _super);
        function Step(attrs) {
            return _super.call(this, attrs) || this;
        }
        Step.initClass = function () {
            this.prototype.type = 'Step';
            this.prototype.default_view = StepView;
            this.mixins(['line']);
            this.define({
                mode: [
                    p.StepMode,
                    'before'
                ]
            });
        };
        return Step;
    }(xy_glyph_1.XYGlyph);
    exports.Step = Step;
    Step.initClass();    
},
/*models/glyphs/text*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var p = require(15    /* core/properties */);
    var text_1 = require(41    /* core/util/text */);
    var TextView = function (_super) {
        tslib_1.__extends(TextView, _super);
        function TextView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TextView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, _x_offset = _a._x_offset, _y_offset = _a._y_offset, _angle = _a._angle, _text = _a._text;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + _x_offset[i] + _y_offset[i] + _angle[i]) || _text[i] == null)
                    continue;
                if (this.visuals.text.doit) {
                    var text = '' + _text[i];
                    ctx.save();
                    ctx.translate(sx[i] + _x_offset[i], sy[i] + _y_offset[i]);
                    ctx.rotate(_angle[i]);
                    this.visuals.text.set_vectorize(ctx, i);
                    if (text.indexOf('\n') == -1)
                        ctx.fillText(text, 0, 0);
                    else {
                        var lines = text.split('\n');
                        var font = this.visuals.text.cache_select('font', i);
                        var height = text_1.get_text_height(font).height;
                        var line_height = this.visuals.text.text_line_height.value() * height;
                        var block_height = line_height * lines.length;
                        var baseline = this.visuals.text.cache_select('text_baseline', i);
                        var y = void 0;
                        switch (baseline) {
                        case 'top': {
                                y = 0;
                                break;
                            }
                        case 'middle': {
                                y = -block_height / 2 + line_height / 2;
                                break;
                            }
                        case 'bottom': {
                                y = -block_height + line_height;
                                break;
                            }
                        default: {
                                y = 0;
                                console.warn('\'' + baseline + '\' baseline not supported with multi line text');
                            }
                        }
                        for (var _b = 0, lines_1 = lines; _b < lines_1.length; _b++) {
                            var line = lines_1[_b];
                            ctx.fillText(line, 0, y);
                            y += line_height;
                        }
                    }
                    ctx.restore();
                }
            }
        };
        return TextView;
    }(xy_glyph_1.XYGlyphView);
    exports.TextView = TextView;
    var Text = function (_super) {
        tslib_1.__extends(Text, _super);
        function Text(attrs) {
            return _super.call(this, attrs) || this;
        }
        Text.initClass = function () {
            this.prototype.type = 'Text';
            this.prototype.default_view = TextView;
            this.mixins(['text']);
            this.define({
                text: [
                    p.StringSpec,
                    { field: 'text' }
                ],
                angle: [
                    p.AngleSpec,
                    0
                ],
                x_offset: [
                    p.NumberSpec,
                    0
                ],
                y_offset: [
                    p.NumberSpec,
                    0
                ]
            });
        };
        return Text;
    }(xy_glyph_1.XYGlyph);
    exports.Text = Text;
    Text.initClass();    
},
/*models/glyphs/utils*/
function _(require, module, exports) {
    function generic_line_legend(visuals, ctx, _a, index) {
        var x0 = _a.x0, x1 = _a.x1, y0 = _a.y0, y1 = _a.y1;
        ctx.save();
        ctx.beginPath();
        ctx.moveTo(x0, (y0 + y1) / 2);
        ctx.lineTo(x1, (y0 + y1) / 2);
        if (visuals.line.doit) {
            visuals.line.set_vectorize(ctx, index);
            ctx.stroke();
        }
        ctx.restore();
    }
    exports.generic_line_legend = generic_line_legend;
    function generic_area_legend(visuals, ctx, _a, index) {
        var x0 = _a.x0, x1 = _a.x1, y0 = _a.y0, y1 = _a.y1;
        var w = Math.abs(x1 - x0);
        var dw = w * 0.1;
        var h = Math.abs(y1 - y0);
        var dh = h * 0.1;
        var sx0 = x0 + dw;
        var sx1 = x1 - dw;
        var sy0 = y0 + dh;
        var sy1 = y1 - dh;
        if (visuals.fill.doit) {
            visuals.fill.set_vectorize(ctx, index);
            ctx.fillRect(sx0, sy0, sx1 - sx0, sy1 - sy0);
        }
        if (visuals.line.doit) {
            ctx.beginPath();
            ctx.rect(sx0, sy0, sx1 - sx0, sy1 - sy0);
            visuals.line.set_vectorize(ctx, index);
            ctx.stroke();
        }
    }
    exports.generic_area_legend = generic_area_legend;    
},
/*models/glyphs/vbar*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var box_1 = require(110    /* ./box */);
    var p = require(15    /* core/properties */);
    var VBarView = function (_super) {
        tslib_1.__extends(VBarView, _super);
        function VBarView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        VBarView.prototype.scenterx = function (i) {
            return this.sx[i];
        };
        VBarView.prototype.scentery = function (i) {
            return (this.stop[i] + this.sbottom[i]) / 2;
        };
        VBarView.prototype._index_data = function () {
            return this._index_box(this._x.length);
        };
        VBarView.prototype._lrtb = function (i) {
            var l = this._x[i] - this._width[i] / 2;
            var r = this._x[i] + this._width[i] / 2;
            var t = Math.max(this._top[i], this._bottom[i]);
            var b = Math.min(this._top[i], this._bottom[i]);
            return [
                l,
                r,
                t,
                b
            ];
        };
        VBarView.prototype._map_data = function () {
            this.sx = this.renderer.xscale.v_compute(this._x);
            this.sw = this.sdist(this.renderer.xscale, this._x, this._width, 'center');
            this.stop = this.renderer.yscale.v_compute(this._top);
            this.sbottom = this.renderer.yscale.v_compute(this._bottom);
            var n = this.sx.length;
            this.sleft = new Float64Array(n);
            this.sright = new Float64Array(n);
            for (var i = 0; i < n; i++) {
                this.sleft[i] = this.sx[i] - this.sw[i] / 2;
                this.sright[i] = this.sx[i] + this.sw[i] / 2;
            }
        };
        return VBarView;
    }(box_1.BoxView);
    exports.VBarView = VBarView;
    var VBar = function (_super) {
        tslib_1.__extends(VBar, _super);
        function VBar(attrs) {
            return _super.call(this, attrs) || this;
        }
        VBar.initClass = function () {
            this.prototype.type = 'VBar';
            this.prototype.default_view = VBarView;
            this.coords([[
                    'x',
                    'bottom'
                ]]);
            this.define({
                width: [p.DistanceSpec],
                top: [p.NumberSpec]
            });
            this.override({ bottom: 0 });
        };
        return VBar;
    }(box_1.Box);
    exports.VBar = VBar;
    VBar.initClass();    
},
/*models/glyphs/wedge*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ./xy_glyph */);
    var utils_1 = require(132    /* ./utils */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var math_1 = require(31    /* core/util/math */);
    var WedgeView = function (_super) {
        tslib_1.__extends(WedgeView, _super);
        function WedgeView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        WedgeView.prototype._map_data = function () {
            if (this.model.properties.radius.units == 'data')
                this.sradius = this.sdist(this.renderer.xscale, this._x, this._radius);
            else
                this.sradius = this._radius;
        };
        WedgeView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sradius = _a.sradius, _start_angle = _a._start_angle, _end_angle = _a._end_angle;
            var direction = this.model.properties.direction.value();
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sradius[i] + _start_angle[i] + _end_angle[i]))
                    continue;
                ctx.beginPath();
                ctx.arc(sx[i], sy[i], sradius[i], _start_angle[i], _end_angle[i], direction);
                ctx.lineTo(sx[i], sy[i]);
                ctx.closePath();
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        WedgeView.prototype._hit_point = function (geometry) {
            var dist, sx0, sx1, sy0, sy1, x0, x1, y0, y1;
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            // check radius first
            if (this.model.properties.radius.units === 'data') {
                x0 = x - this.max_radius;
                x1 = x + this.max_radius;
                y0 = y - this.max_radius;
                y1 = y + this.max_radius;
            } else {
                sx0 = sx - this.max_radius;
                sx1 = sx + this.max_radius;
                _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
                sy0 = sy - this.max_radius;
                sy1 = sy + this.max_radius;
                _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            }
            var candidates = [];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            for (var _i = 0, _c = this.index.indices(bbox); _i < _c.length; _i++) {
                var i = _c[_i];
                var r2 = Math.pow(this.sradius[i], 2);
                _d = this.renderer.xscale.r_compute(x, this._x[i]), sx0 = _d[0], sx1 = _d[1];
                _e = this.renderer.yscale.r_compute(y, this._y[i]), sy0 = _e[0], sy1 = _e[1];
                dist = Math.pow(sx0 - sx1, 2) + Math.pow(sy0 - sy1, 2);
                if (dist <= r2) {
                    candidates.push([
                        i,
                        dist
                    ]);
                }
            }
            var direction = this.model.properties.direction.value();
            var hits = [];
            for (var _f = 0, candidates_1 = candidates; _f < candidates_1.length; _f++) {
                var _g = candidates_1[_f], i = _g[0], dist_1 = _g[1];
                // NOTE: minus the angle because JS uses non-mathy convention for angles
                var angle = Math.atan2(sy - this.sy[i], sx - this.sx[i]);
                if (math_1.angle_between(-angle, -this._start_angle[i], -this._end_angle[i], direction)) {
                    hits.push([
                        i,
                        dist_1
                    ]);
                }
            }
            return hittest.create_hit_test_result_from_hits(hits);
            var _a, _b, _d, _e;
        };
        WedgeView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_area_legend(this.visuals, ctx, bbox, index);
        };
        return WedgeView;
    }(xy_glyph_1.XYGlyphView);
    exports.WedgeView = WedgeView;
    var Wedge = function (_super) {
        tslib_1.__extends(Wedge, _super);
        function Wedge(attrs) {
            return _super.call(this, attrs) || this;
        }
        Wedge.initClass = function () {
            this.prototype.type = 'Wedge';
            this.prototype.default_view = WedgeView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                direction: [
                    p.Direction,
                    'anticlock'
                ],
                radius: [p.DistanceSpec],
                start_angle: [p.AngleSpec],
                end_angle: [p.AngleSpec]
            });
        };
        return Wedge;
    }(xy_glyph_1.XYGlyph);
    exports.Wedge = Wedge;
    Wedge.initClass();    
},
/*models/glyphs/xy_glyph*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var glyph_1 = require(113    /* ./glyph */);
    var XYGlyphView = function (_super) {
        tslib_1.__extends(XYGlyphView, _super);
        function XYGlyphView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        XYGlyphView.prototype._index_data = function () {
            var points = [];
            for (var i = 0, end = this._x.length; i < end; i++) {
                var x = this._x[i];
                var y = this._y[i];
                if (isNaN(x + y) || !isFinite(x + y))
                    continue;
                points.push({
                    minX: x,
                    minY: y,
                    maxX: x,
                    maxY: y,
                    i: i
                });
            }
            return new spatial_1.SpatialIndex(points);
        };
        XYGlyphView.prototype.scenterx = function (i) {
            return this.sx[i];
        };
        XYGlyphView.prototype.scentery = function (i) {
            return this.sy[i];
        };
        return XYGlyphView;
    }(glyph_1.GlyphView);
    exports.XYGlyphView = XYGlyphView;
    var XYGlyph = function (_super) {
        tslib_1.__extends(XYGlyph, _super);
        function XYGlyph(attrs) {
            return _super.call(this, attrs) || this;
        }
        XYGlyph.initClass = function () {
            this.prototype.type = 'XYGlyph';
            this.coords([[
                    'x',
                    'y'
                ]]);
        };
        return XYGlyph;
    }(glyph_1.Glyph);
    exports.XYGlyph = XYGlyph;
    XYGlyph.initClass();    
},
/*models/graphs/graph_hit_test_policy*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var model_1 = require(53    /* ../../model */);
    var arrayable_1 = require(22    /* core/util/arrayable */);
    var array_1 = require(21    /* core/util/array */);
    var hittest_1 = require(9    /* core/hittest */);
    var GraphHitTestPolicy = function (_super) {
        tslib_1.__extends(GraphHitTestPolicy, _super);
        function GraphHitTestPolicy(attrs) {
            return _super.call(this, attrs) || this;
        }
        GraphHitTestPolicy.initClass = function () {
            this.prototype.type = 'GraphHitTestPolicy';
        };
        GraphHitTestPolicy.prototype._hit_test_nodes = function (geometry, graph_view) {
            if (!graph_view.model.visible)
                return null;
            var hit_test_result = graph_view.node_view.glyph.hit_test(geometry);
            if (hit_test_result == null)
                return null;
            else
                return graph_view.node_view.model.view.convert_selection_from_subset(hit_test_result);
        };
        GraphHitTestPolicy.prototype._hit_test_edges = function (geometry, graph_view) {
            if (!graph_view.model.visible)
                return null;
            var hit_test_result = graph_view.edge_view.glyph.hit_test(geometry);
            if (hit_test_result == null)
                return null;
            else
                return graph_view.edge_view.model.view.convert_selection_from_subset(hit_test_result);
        };
        return GraphHitTestPolicy;
    }(model_1.Model);
    exports.GraphHitTestPolicy = GraphHitTestPolicy;
    var NodesOnly = function (_super) {
        tslib_1.__extends(NodesOnly, _super);
        function NodesOnly(attrs) {
            return _super.call(this, attrs) || this;
        }
        NodesOnly.initClass = function () {
            this.prototype.type = 'NodesOnly';
        };
        NodesOnly.prototype.hit_test = function (geometry, graph_view) {
            return this._hit_test_nodes(geometry, graph_view);
        };
        NodesOnly.prototype.do_selection = function (hit_test_result, graph, final, append) {
            if (hit_test_result == null)
                return false;
            var node_selection = graph.node_renderer.data_source.selected;
            node_selection.update(hit_test_result, final, append);
            graph.node_renderer.data_source._select.emit();
            return !node_selection.is_empty();
        };
        NodesOnly.prototype.do_inspection = function (hit_test_result, geometry, graph_view, final, append) {
            if (hit_test_result == null)
                return false;
            var node_inspection = graph_view.model.get_selection_manager().get_or_create_inspector(graph_view.node_view.model);
            node_inspection.update(hit_test_result, final, append);
            // silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
            graph_view.node_view.model.data_source.inspect.emit([
                graph_view.node_view,
                { geometry: geometry }
            ]);
            return !node_inspection.is_empty();
        };
        return NodesOnly;
    }(GraphHitTestPolicy);
    exports.NodesOnly = NodesOnly;
    NodesOnly.initClass();
    var NodesAndLinkedEdges = function (_super) {
        tslib_1.__extends(NodesAndLinkedEdges, _super);
        function NodesAndLinkedEdges(attrs) {
            return _super.call(this, attrs) || this;
        }
        NodesAndLinkedEdges.initClass = function () {
            this.prototype.type = 'NodesAndLinkedEdges';
        };
        NodesAndLinkedEdges.prototype.hit_test = function (geometry, graph_view) {
            return this._hit_test_nodes(geometry, graph_view);
        };
        NodesAndLinkedEdges.prototype.get_linked_edges = function (node_source, edge_source, mode) {
            var node_indices = [];
            if (mode == 'selection') {
                node_indices = node_source.selected.indices.map(function (i) {
                    return node_source.data.index[i];
                });
            } else if (mode == 'inspection') {
                node_indices = node_source.inspected.indices.map(function (i) {
                    return node_source.data.index[i];
                });
            }
            var edge_indices = [];
            for (var i = 0; i < edge_source.data.start.length; i++) {
                if (array_1.contains(node_indices, edge_source.data.start[i]) || array_1.contains(node_indices, edge_source.data.end[i]))
                    edge_indices.push(i);
            }
            var linked_edges = hittest_1.create_empty_hit_test_result();
            for (var _i = 0, edge_indices_1 = edge_indices; _i < edge_indices_1.length; _i++) {
                var i = edge_indices_1[_i];
                linked_edges.multiline_indices[i] = [0];    //currently only supports 2-element multilines, so this is all of it
            }
            linked_edges.indices = edge_indices;
            return linked_edges;
        };
        NodesAndLinkedEdges.prototype.do_selection = function (hit_test_result, graph, final, append) {
            if (hit_test_result == null)
                return false;
            var node_selection = graph.node_renderer.data_source.selected;
            node_selection.update(hit_test_result, final, append);
            var edge_selection = graph.edge_renderer.data_source.selected;
            var linked_edges_selection = this.get_linked_edges(graph.node_renderer.data_source, graph.edge_renderer.data_source, 'selection');
            edge_selection.update(linked_edges_selection, final, append);
            graph.node_renderer.data_source._select.emit();
            return !node_selection.is_empty();
        };
        NodesAndLinkedEdges.prototype.do_inspection = function (hit_test_result, geometry, graph_view, final, append) {
            if (hit_test_result == null)
                return false;
            var node_inspection = graph_view.node_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.node_view.model);
            node_inspection.update(hit_test_result, final, append);
            graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
            var edge_inspection = graph_view.edge_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.edge_view.model);
            var linked_edges = this.get_linked_edges(graph_view.node_view.model.data_source, graph_view.edge_view.model.data_source, 'inspection');
            edge_inspection.update(linked_edges, final, append);
            //silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.edge_view.model.data_source.setv({ inspected: edge_inspection }, { silent: true });
            graph_view.node_view.model.data_source.inspect.emit([
                graph_view.node_view,
                { geometry: geometry }
            ]);
            return !node_inspection.is_empty();
        };
        return NodesAndLinkedEdges;
    }(GraphHitTestPolicy);
    exports.NodesAndLinkedEdges = NodesAndLinkedEdges;
    NodesAndLinkedEdges.initClass();
    var EdgesAndLinkedNodes = function (_super) {
        tslib_1.__extends(EdgesAndLinkedNodes, _super);
        function EdgesAndLinkedNodes(attrs) {
            return _super.call(this, attrs) || this;
        }
        EdgesAndLinkedNodes.initClass = function () {
            this.prototype.type = 'EdgesAndLinkedNodes';
        };
        EdgesAndLinkedNodes.prototype.hit_test = function (geometry, graph_view) {
            return this._hit_test_edges(geometry, graph_view);
        };
        EdgesAndLinkedNodes.prototype.get_linked_nodes = function (node_source, edge_source, mode) {
            var edge_indices = [];
            if (mode == 'selection')
                edge_indices = edge_source.selected.indices;
            else if (mode == 'inspection')
                edge_indices = edge_source.inspected.indices;
            var nodes = [];
            for (var _i = 0, edge_indices_2 = edge_indices; _i < edge_indices_2.length; _i++) {
                var i = edge_indices_2[_i];
                nodes.push(edge_source.data.start[i]);
                nodes.push(edge_source.data.end[i]);
            }
            var node_indices = array_1.uniq(nodes).map(function (i) {
                return arrayable_1.indexOf(node_source.data.index, i);
            });
            var linked_nodes = hittest_1.create_empty_hit_test_result();
            linked_nodes.indices = node_indices;
            return linked_nodes;
        };
        EdgesAndLinkedNodes.prototype.do_selection = function (hit_test_result, graph, final, append) {
            if (hit_test_result == null)
                return false;
            var edge_selection = graph.edge_renderer.data_source.selected;
            edge_selection.update(hit_test_result, final, append);
            var node_selection = graph.node_renderer.data_source.selected;
            var linked_nodes = this.get_linked_nodes(graph.node_renderer.data_source, graph.edge_renderer.data_source, 'selection');
            node_selection.update(linked_nodes, final, append);
            graph.edge_renderer.data_source._select.emit();
            return !edge_selection.is_empty();
        };
        EdgesAndLinkedNodes.prototype.do_inspection = function (hit_test_result, geometry, graph_view, final, append) {
            if (hit_test_result == null)
                return false;
            var edge_inspection = graph_view.edge_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.edge_view.model);
            edge_inspection.update(hit_test_result, final, append);
            graph_view.edge_view.model.data_source.setv({ inspected: edge_inspection }, { silent: true });
            var node_inspection = graph_view.node_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.node_view.model);
            var linked_nodes = this.get_linked_nodes(graph_view.node_view.model.data_source, graph_view.edge_view.model.data_source, 'inspection');
            node_inspection.update(linked_nodes, final, append);
            // silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
            graph_view.edge_view.model.data_source.inspect.emit([
                graph_view.edge_view,
                { geometry: geometry }
            ]);
            return !edge_inspection.is_empty();
        };
        return EdgesAndLinkedNodes;
    }(GraphHitTestPolicy);
    exports.EdgesAndLinkedNodes = EdgesAndLinkedNodes;
    EdgesAndLinkedNodes.initClass();    
},
/*models/graphs/index*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    tslib_1.__exportStar(require(136    /* ./graph_hit_test_policy */), exports);
    tslib_1.__exportStar(require(138    /* ./layout_provider */), exports);
    tslib_1.__exportStar(require(139    /* ./static_layout_provider */), exports);    
},
/*models/graphs/layout_provider*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var model_1 = require(53    /* ../../model */);
    var LayoutProvider = function (_super) {
        tslib_1.__extends(LayoutProvider, _super);
        function LayoutProvider(attrs) {
            return _super.call(this, attrs) || this;
        }
        LayoutProvider.initClass = function () {
            this.prototype.type = 'LayoutProvider';
        };
        return LayoutProvider;
    }(model_1.Model);
    exports.LayoutProvider = LayoutProvider;
    LayoutProvider.initClass();    
},
/*models/graphs/static_layout_provider*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var layout_provider_1 = require(138    /* ./layout_provider */);
    var p = require(15    /* ../../core/properties */);
    var StaticLayoutProvider = function (_super) {
        tslib_1.__extends(StaticLayoutProvider, _super);
        function StaticLayoutProvider(attrs) {
            return _super.call(this, attrs) || this;
        }
        StaticLayoutProvider.initClass = function () {
            this.prototype.type = 'StaticLayoutProvider';
            this.define({
                graph_layout: [
                    p.Any,
                    {}
                ]
            });
        };
        StaticLayoutProvider.prototype.get_node_coordinates = function (node_source) {
            var xs = [];
            var ys = [];
            var index = node_source.data.index;
            for (var i = 0, end = index.length; i < end; i++) {
                var point = this.graph_layout[index[i]];
                var _a = point != null ? point : [
                        NaN,
                        NaN
                    ], x = _a[0], y = _a[1];
                xs.push(x);
                ys.push(y);
            }
            return [
                xs,
                ys
            ];
        };
        StaticLayoutProvider.prototype.get_edge_coordinates = function (edge_source) {
            var xs = [];
            var ys = [];
            var starts = edge_source.data.start;
            var ends = edge_source.data.end;
            var has_paths = edge_source.data.xs != null && edge_source.data.ys != null;
            for (var i = 0, endi = starts.length; i < endi; i++) {
                var in_layout = this.graph_layout[starts[i]] != null && this.graph_layout[ends[i]] != null;
                if (has_paths && in_layout) {
                    xs.push(edge_source.data.xs[i]);
                    ys.push(edge_source.data.ys[i]);
                } else {
                    var end = void 0, start = void 0;
                    if (in_layout)
                        _a = [
                            this.graph_layout[starts[i]],
                            this.graph_layout[ends[i]]
                        ], start = _a[0], end = _a[1];
                    else
                        _b = [
                            [
                                NaN,
                                NaN
                            ],
                            [
                                NaN,
                                NaN
                            ]
                        ], start = _b[0], end = _b[1];
                    xs.push([
                        start[0],
                        end[0]
                    ]);
                    ys.push([
                        start[1],
                        end[1]
                    ]);
                }
            }
            return [
                xs,
                ys
            ];
            var _a, _b;
        };
        return StaticLayoutProvider;
    }(layout_provider_1.LayoutProvider);
    exports.StaticLayoutProvider = StaticLayoutProvider;
    StaticLayoutProvider.initClass();    
},
/*models/grids/grid*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var axis_1 = require(72    /* ../axes/axis */);
    var guide_renderer_1 = require(171    /* ../renderers/guide_renderer */);
    var p = require(15    /* core/properties */);
    var types_1 = require(44    /* core/util/types */);
    var GridView = function (_super) {
        tslib_1.__extends(GridView, _super);
        function GridView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(GridView.prototype, '_x_range_name', {
            get: function () {
                return this.model.x_range_name;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(GridView.prototype, '_y_range_name', {
            get: function () {
                return this.model.y_range_name;
            },
            enumerable: true,
            configurable: true
        });
        GridView.prototype.render = function () {
            if (!this.model.visible)
                return;
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            this._draw_regions(ctx);
            this._draw_minor_grids(ctx);
            this._draw_grids(ctx);
            ctx.restore();
        };
        GridView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () {
                return _this.request_render();
            });
        };
        GridView.prototype._draw_regions = function (ctx) {
            if (!this.visuals.band_fill.doit)
                return;
            var _a = this.model.grid_coords('major', false), xs = _a[0], ys = _a[1];
            this.visuals.band_fill.set_value(ctx);
            for (var i = 0; i < xs.length - 1; i++) {
                if (i % 2 == 1) {
                    var _b = this.plot_view.map_to_screen(xs[i], ys[i], this._x_range_name, this._y_range_name), sx0 = _b[0], sy0 = _b[1];
                    var _c = this.plot_view.map_to_screen(xs[i + 1], ys[i + 1], this._x_range_name, this._y_range_name), sx1 = _c[0], sy1 = _c[1];
                    ctx.fillRect(sx0[0], sy0[0], sx1[1] - sx0[0], sy1[1] - sy0[0]);
                    ctx.fill();
                }
            }
        };
        GridView.prototype._draw_grids = function (ctx) {
            if (!this.visuals.grid_line.doit)
                return;
            var _a = this.model.grid_coords('major'), xs = _a[0], ys = _a[1];
            this._draw_grid_helper(ctx, this.visuals.grid_line, xs, ys);
        };
        GridView.prototype._draw_minor_grids = function (ctx) {
            if (!this.visuals.minor_grid_line.doit)
                return;
            var _a = this.model.grid_coords('minor'), xs = _a[0], ys = _a[1];
            this._draw_grid_helper(ctx, this.visuals.minor_grid_line, xs, ys);
        };
        GridView.prototype._draw_grid_helper = function (ctx, visuals, xs, ys) {
            visuals.set_value(ctx);
            for (var i = 0; i < xs.length; i++) {
                var _a = this.plot_view.map_to_screen(xs[i], ys[i], this._x_range_name, this._y_range_name), sx = _a[0], sy = _a[1];
                ctx.beginPath();
                ctx.moveTo(Math.round(sx[0]), Math.round(sy[0]));
                for (var i_1 = 1; i_1 < sx.length; i_1++)
                    ctx.lineTo(Math.round(sx[i_1]), Math.round(sy[i_1]));
                ctx.stroke();
            }
        };
        return GridView;
    }(guide_renderer_1.GuideRendererView);
    exports.GridView = GridView;
    var Grid = function (_super) {
        tslib_1.__extends(Grid, _super);
        function Grid(attrs) {
            return _super.call(this, attrs) || this;
        }
        Grid.initClass = function () {
            this.prototype.type = 'Grid';
            this.prototype.default_view = GridView;
            this.mixins([
                'line:grid_',
                'line:minor_grid_',
                'fill:band_'
            ]);
            this.define({
                bounds: [
                    p.Any,
                    'auto'
                ],
                dimension: [
                    p.Number,
                    0
                ],
                ticker: [p.Instance],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
            this.override({
                level: 'underlay',
                band_fill_color: null,
                band_fill_alpha: 0,
                grid_line_color: '#e5e5e5',
                minor_grid_line_color: null
            });
        };
        Grid.prototype.ranges = function () {
            var i = this.dimension;
            var j = (i + 1) % 2;
            var frame = this.plot.plot_canvas.frame;
            var ranges = [
                frame.x_ranges[this.x_range_name],
                frame.y_ranges[this.y_range_name]
            ];
            return [
                ranges[i],
                ranges[j]
            ];
        };
        Grid.prototype.computed_bounds = function () {
            var range = this.ranges()[0];
            var user_bounds = this.bounds;
            var range_bounds = [
                range.min,
                range.max
            ];
            var start;
            var end;
            if (types_1.isArray(user_bounds)) {
                start = Math.min(user_bounds[0], user_bounds[1]);
                end = Math.max(user_bounds[0], user_bounds[1]);
                if (start < range_bounds[0])
                    start = range_bounds[0];
                // XXX:
                //else if (start > range_bounds[1])
                //  start = null
                if (end > range_bounds[1])
                    end = range_bounds[1];    // XXX:
                                              //else if (end < range_bounds[0])
                                              //  end = null
            } else {
                start = range_bounds[0], end = range_bounds[1];
                for (var _i = 0, _a = this.plot.select(axis_1.Axis); _i < _a.length; _i++) {
                    var axis = _a[_i];
                    if (axis.dimension == this.dimension && axis.x_range_name == this.x_range_name && axis.y_range_name == this.y_range_name) {
                        _b = axis.computed_bounds, start = _b[0], end = _b[1];
                    }
                }
            }
            return [
                start,
                end
            ];
            var _b;
        };
        Grid.prototype.grid_coords = function (location, exclude_ends) {
            if (exclude_ends === void 0) {
                exclude_ends = true;
            }
            var i = this.dimension;
            var j = (i + 1) % 2;
            var _a = this.ranges(), range = _a[0], cross_range = _a[1];
            var _b = this.computed_bounds(), start = _b[0], end = _b[1];
            _c = [
                Math.min(start, end),
                Math.max(start, end)
            ], start = _c[0], end = _c[1];
            // TODO: (bev) using cross_range.min for cross_loc is a bit of a cheat. Since we
            // currently only support "straight line" grids, this should be OK for now. If
            // we ever want to support "curved" grids, e.g. for some projections, we may
            // have to communicate more than just a single cross location.
            var ticks = this.ticker.get_ticks(start, end, range, cross_range.min, {})[location];
            var min = range.min;
            var max = range.max;
            var cmin = cross_range.min;
            var cmax = cross_range.max;
            var coords = [
                [],
                []
            ];
            if (!exclude_ends) {
                if (ticks[0] != min)
                    ticks.splice(0, 0, min);
                if (ticks[ticks.length - 1] != max)
                    ticks.push(max);
            }
            for (var ii = 0; ii < ticks.length; ii++) {
                if ((ticks[ii] == min || ticks[ii] == max) && exclude_ends)
                    continue;
                var dim_i = [];
                var dim_j = [];
                var N = 2;
                for (var n = 0; n < N; n++) {
                    var loc = cmin + (cmax - cmin) / (N - 1) * n;
                    dim_i.push(ticks[ii]);
                    dim_j.push(loc);
                }
                coords[i].push(dim_i);
                coords[j].push(dim_j);
            }
            return coords;
            var _c;
        };
        return Grid;
    }(guide_renderer_1.GuideRenderer);
    exports.Grid = Grid;
    Grid.initClass();    
},
/*models/grids/index*/
function _(require, module, exports) {
    var grid_1 = require(140    /* ./grid */);
    exports.Grid = grid_1.Grid;    
},
/*models/index*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    tslib_1.__exportStar(require(60    /* ./annotations */), exports);
    tslib_1.__exportStar(require(76    /* ./axes */), exports);
    tslib_1.__exportStar(require(82    /* ./callbacks */), exports);
    tslib_1.__exportStar(require(86    /* ./canvas */), exports);
    tslib_1.__exportStar(require(88    /* ./expressions */), exports);
    tslib_1.__exportStar(require(94    /* ./filters */), exports);
    tslib_1.__exportStar(require(100    /* ./formatters */), exports);
    tslib_1.__exportStar(require(119    /* ./glyphs */), exports);
    tslib_1.__exportStar(require(137    /* ./graphs */), exports);
    tslib_1.__exportStar(require(141    /* ./grids */), exports);
    tslib_1.__exportStar(require(145    /* ./layouts */), exports);
    tslib_1.__exportStar(require(153    /* ./mappers */), exports);
    tslib_1.__exportStar(require(254    /* ./transforms */), exports);
    tslib_1.__exportStar(require(156    /* ./markers */), exports);
    tslib_1.__exportStar(require(160    /* ./plots */), exports);
    tslib_1.__exportStar(require(166    /* ./ranges */), exports);
    tslib_1.__exportStar(require(172    /* ./renderers */), exports);
    tslib_1.__exportStar(require(175    /* ./scales */), exports);
    tslib_1.__exportStar(require(179    /* ./selections */), exports);
    tslib_1.__exportStar(require(188    /* ./sources */), exports);
    tslib_1.__exportStar(require(198    /* ./tickers */), exports);
    tslib_1.__exportStar(require(208    /* ./tiles */), exports);
    tslib_1.__exportStar(require(240    /* ./tools */), exports);    
},
/*models/layouts/box*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var solver_1 = require(13    /* core/layout/solver */);
    var p = require(15    /* core/properties */);
    var array_1 = require(21    /* core/util/array */);
    var object_1 = require(32    /* core/util/object */);
    var layout_dom_1 = require(146    /* ./layout_dom */);
    var BoxView = function (_super) {
        tslib_1.__extends(BoxView, _super);
        function BoxView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BoxView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.properties.children.change, function () {
                return _this.rebuild_child_views();
            });
        };
        BoxView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-grid');
        };
        BoxView.prototype.get_height = function () {
            var children = this.model.get_layoutable_children();
            var child_heights = children.map(function (child) {
                return child._height.value;
            });
            var height;
            if (this.model._horizontal)
                height = array_1.max(child_heights);
            else
                height = array_1.sum(child_heights);
            return height;
        };
        BoxView.prototype.get_width = function () {
            var children = this.model.get_layoutable_children();
            var child_widths = children.map(function (child) {
                return child._width.value;
            });
            var width;
            if (this.model._horizontal)
                width = array_1.sum(child_widths);
            else
                width = array_1.max(child_widths);
            return width;
        };
        return BoxView;
    }(layout_dom_1.LayoutDOMView);
    exports.BoxView = BoxView;
    var Box = function (_super) {
        tslib_1.__extends(Box, _super);
        function Box(attrs) {
            return _super.call(this, attrs) || this;
        }
        Box.initClass = function () {
            this.prototype.type = 'Box';
            this.prototype.default_view = BoxView;
            this.define({
                children: [
                    p.Array,
                    []
                ]
            });
            this.internal({
                spacing: [
                    p.Number,
                    6
                ]
            });
        };
        Box.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._child_equal_size_width = new solver_1.Variable(this.toString() + '.child_equal_size_width');
            this._child_equal_size_height = new solver_1.Variable(this.toString() + '.child_equal_size_height');
            this._box_equal_size_top = new solver_1.Variable(this.toString() + '.box_equal_size_top');
            this._box_equal_size_bottom = new solver_1.Variable(this.toString() + '.box_equal_size_bottom');
            this._box_equal_size_left = new solver_1.Variable(this.toString() + '.box_equal_size_left');
            this._box_equal_size_right = new solver_1.Variable(this.toString() + '.box_equal_size_right');
            this._box_cell_align_top = new solver_1.Variable(this.toString() + '.box_cell_align_top');
            this._box_cell_align_bottom = new solver_1.Variable(this.toString() + '.box_cell_align_bottom');
            this._box_cell_align_left = new solver_1.Variable(this.toString() + '.box_cell_align_left');
            this._box_cell_align_right = new solver_1.Variable(this.toString() + '.box_cell_align_right');
        };
        Box.prototype.get_layoutable_children = function () {
            return this.children;
        };
        Box.prototype.get_constrained_variables = function () {
            return object_1.extend({}, _super.prototype.get_constrained_variables.call(this), {
                box_equal_size_top: this._box_equal_size_top,
                box_equal_size_bottom: this._box_equal_size_bottom,
                box_equal_size_left: this._box_equal_size_left,
                box_equal_size_right: this._box_equal_size_right,
                box_cell_align_top: this._box_cell_align_top,
                box_cell_align_bottom: this._box_cell_align_bottom,
                box_cell_align_left: this._box_cell_align_left,
                box_cell_align_right: this._box_cell_align_right
            });
        };
        Box.prototype.get_constraints = function () {
            var constraints = _super.prototype.get_constraints.call(this);
            var add = function () {
                var new_constraints = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    new_constraints[_i] = arguments[_i];
                }
                constraints.push.apply(constraints, new_constraints);
            };
            var children = this.get_layoutable_children();
            if (children.length == 0)
                // No need to continue further if there are no children. Children sure do
                // make life a lot more complicated.
                return constraints;
            for (var _i = 0, children_1 = children; _i < children_1.length; _i++) {
                var child = children_1[_i];
                var vars_1 = child.get_constrained_variables();
                // Make total widget sizes fill the orthogonal direction
                // TODO(bird) Can't we make this shorter by using span which has already picked a
                // dominant direction (we'd just also need to set a doc_span)
                var rect = this._child_rect(vars_1);
                if (this._horizontal) {
                    if (vars_1.height != null)
                        add(solver_1.EQ(rect.height, [
                            -1,
                            this._height
                        ]));
                } else {
                    if (vars_1.width != null)
                        add(solver_1.EQ(rect.width, [
                            -1,
                            this._width
                        ]));
                }
                // Add equal_size constraint
                // - A child's "interesting area" (like the plot area) is the same size as the previous child
                //   (a child can opt out of this by not returning the box_equal_size variables)
                if (this._horizontal) {
                    if (vars_1.box_equal_size_left != null && vars_1.box_equal_size_right != null && vars_1.width != null)
                        add(solver_1.EQ([
                            -1,
                            vars_1.box_equal_size_left
                        ], [
                            -1,
                            vars_1.box_equal_size_right
                        ], vars_1.width, this._child_equal_size_width));
                } else {
                    if (vars_1.box_equal_size_top != null && vars_1.box_equal_size_bottom != null && vars_1.height != null)
                        add(solver_1.EQ([
                            -1,
                            vars_1.box_equal_size_top
                        ], [
                            -1,
                            vars_1.box_equal_size_bottom
                        ], vars_1.height, this._child_equal_size_height));
                }
            }
            // TODO(bird) - This is the second time we loop through children
            var last = this._info(children[0].get_constrained_variables());
            add(solver_1.EQ(last.span.start, 0));
            for (var i = 1; i < children.length; i++) {
                var next = this._info(children[i].get_constrained_variables());
                // Each child's start equals the previous child's end (unless we have a fixed layout
                // in which case size may not be available)
                if (last.span.size)
                    add(solver_1.EQ(last.span.start, last.span.size, [
                        -1,
                        next.span.start
                    ]));
                // The whitespace at end of one child + start of next must equal the box spacing.
                // This must be a weak constraint because it can conflict with aligning the
                // alignable edges in each child. Alignment is generally more important visually than spacing.
                add(solver_1.WEAK_EQ(last.whitespace.after, next.whitespace.before, 0 - this.spacing));
                // If we can't satisfy the whitespace being equal to box spacing, we should fix
                // it (align things) by increasing rather than decreasing the whitespace.
                add(solver_1.GE(last.whitespace.after, next.whitespace.before, 0 - this.spacing));
                last = next;
            }
            // Child's side has to stick to the end of the box
            var vars = children[children.length - 1].get_constrained_variables();
            if (this._horizontal) {
                if (vars.width != null)
                    add(solver_1.EQ(last.span.start, last.span.size, [
                        -1,
                        this._width
                    ]));
            } else {
                if (vars.height != null)
                    add(solver_1.EQ(last.span.start, last.span.size, [
                        -1,
                        this._height
                    ]));
            }
            constraints = constraints.concat(// align outermost edges in both dimensions
            this._align_outer_edges_constraints(true), // horizontal=true
            this._align_outer_edges_constraints(false), // line up edges in same_arity boxes
            this._align_inner_cell_edges_constraints(), // build our equal_size bounds from the child ones
            this._box_equal_size_bounds(true), // horizontal=true
            this._box_equal_size_bounds(false), // propagate cell alignment (between same_arity boxes) up the hierarchy
            this._box_cell_align_bounds(true), // horizontal=true
            this._box_cell_align_bounds(false), // build our whitespace from the child ones
            this._box_whitespace(true), // horizontal=true
            this._box_whitespace(false));
            return constraints;
        };
        Box.prototype._child_rect = function (vars) {
            return {
                x: vars.origin_x,
                y: vars.origin_y,
                width: vars.width,
                height: vars.height
            };
        };
        Box.prototype._span = function (rect) {
            // return [coordinate, size] pair in box_aligned direction
            if (this._horizontal)
                return {
                    start: rect.x,
                    size: rect.width
                };
            else
                return {
                    start: rect.y,
                    size: rect.height
                };
        };
        Box.prototype._info = function (vars) {
            var whitespace;
            if (this._horizontal)
                whitespace = {
                    before: vars.whitespace_left,
                    after: vars.whitespace_right
                };
            else
                whitespace = {
                    before: vars.whitespace_top,
                    after: vars.whitespace_bottom
                };
            var span = this._span(this._child_rect(vars));
            return {
                span: span,
                whitespace: whitespace
            };
        };
        Box.prototype._flatten_cell_edge_variables = function (horizontal) {
            /*
         * All alignment happens in terms of the
         * box_cell_align_{left,right,top,bottom} variables. We add
         * "path" information to variables so we know which ones align,
         * where the "path" includes the box arity and box cell we went
         * through.
         *
         * If we have a row of three plots, we should align the top and
         * bottom variables between the three plots.
         *
         * The flattened dictionary in this case (for the top and left
         * only) should be:
         *
         *   box_cell_align_top : [ 3 vars ]
         *   box_cell_align_bottom : [ 3 vars ]
         *
         * We don't do left/right starting from a row, and left/right
         * edges have nothing to align with here.
         *
         * Now say we have a row of three columns, each with three
         * plots (3x3 = 9). We should align the top/bottom variables
         * across the top three, middle three, and bottom three plots,
         * as if those groupings were rows. We do this by flattening
         * starting from the row first, which gets us a dictionary only
         * of top/bottom variables.
         *
         *   box_cell_align_top col-3-0- : [ 3 plots from top of columns ]
         *   box_cell_align_top col-3-1- : [ 3 plots from middle of columns ]
         *   box_cell_align_top col-3-2- : [ 3 plots from bottom of columns ]
         *
         * "col-3-1-" = 3-cell column, cell index 1.
         *
         * In three later, separate calls to
         * _align_inner_cell_edges_constraints() on each column, we'll
         * get the left/right variables:
         *
         *   box_cell_align_left : [ 3 left-column plots ]
         *   box_cell_align_left : [ 3 middle-column plots ]
         *   box_cell_align_left : [ 3 right-column plots ]
         *
         * Now add another nesting - we have a row of three columns,
         * each with three rows, each with three plots. This is
         * arranged 3x9 = 27.
         *
         *   box_cell_align_top col-3-0- : [ 9 plots from top rows of columns ]
         *   box_cell_align_top col-3-1- : [ 9 plots from middle rows of columns ]
         *   box_cell_align_top col-3-2- : [ 9 plots from bottom rows of columns ]
         *
         * When we make the _align_inner_cell_edges_constraints() calls on each of the three
         * columns, each column will return row-pathed values
         *
         *   box_cell_align_left row-3-0-: [  3 plots in left column of left column ]
         *   box_cell_align_left row-3-1-: [  3 plots in middle column of left column ]
         *   box_cell_align_left row-3-2-: [  3 plots in right column of left column ]
         *   ... same for the middle and right columns
         *
         * Anyway in essence what we do is that we add only rows to the
         * path to left/right variables, and only columns to the path
         * to top/bottom variables.
         *
         * If we nest yet another level we would finally get paths with
         * multiple rows or multiple columns in them.
         */
            var relevant_edges;
            if (horizontal)
                relevant_edges = Box._top_bottom_inner_cell_edge_variables;
            else
                relevant_edges = Box._left_right_inner_cell_edge_variables;
            var add_path = horizontal != this._horizontal;
            var children = this.get_layoutable_children();
            var arity = children.length;
            var flattened = {};
            var cell = 0;
            for (var _i = 0, children_2 = children; _i < children_2.length; _i++) {
                var child = children_2[_i];
                var cell_vars = void 0;
                if (child instanceof Box)
                    cell_vars = child._flatten_cell_edge_variables(horizontal);
                else
                    cell_vars = {};
                var all_vars = child.get_constrained_variables();
                for (var _a = 0, relevant_edges_1 = relevant_edges; _a < relevant_edges_1.length; _a++) {
                    var name_1 = relevant_edges_1[_a];
                    if (name_1 in all_vars)
                        cell_vars[name_1] = [all_vars[name_1]];
                }
                for (var key in cell_vars) {
                    var variables = cell_vars[key];
                    var new_key = void 0;
                    if (add_path) {
                        var parsed = key.split(' ');
                        var kind = parsed[0];
                        var path = parsed.length > 1 ? parsed[1] : '';
                        var direction = this._horizontal ? 'row' : 'col';
                        // TODO should we "ignore" arity-1 boxes potentially by not adding a path suffix?
                        new_key = kind + ' ' + direction + '-' + arity + '-' + cell + '-' + path;
                    } else
                        new_key = key;
                    if (new_key in flattened)
                        flattened[new_key] = flattened[new_key].concat(variables);
                    else
                        flattened[new_key] = variables;
                }
                cell++;
            }
            return flattened;
        };
        // This should only be called on the toplevel box (twice,
        // once with horizontal=true and once with horizontal=false)
        Box.prototype._align_inner_cell_edges_constraints = function () {
            var constraints = [];
            // XXX: checking for `this.document?` is a temporary hack, because document isn't always
            // attached properly. However, if document is not attached then we know it can't be
            // a root, because otherwise add_root() would attach it. All this layout logic should
            // be part of views instead of models and use is_root, etc.
            if (this.document != null && array_1.includes(this.document.roots(), this)) {
                var flattened = this._flatten_cell_edge_variables(this._horizontal);
                for (var key in flattened) {
                    var variables = flattened[key];
                    if (variables.length > 1) {
                        //console.log("constraining ", key, " ", variables)
                        var last = variables[0];
                        for (var i = 1; i < variables.length; i++)
                            constraints.push(solver_1.EQ(variables[i], [
                                -1,
                                last
                            ]));
                    }
                }
            }
            return constraints;
        };
        // returns a two-item array where each item is a list of edge
        // children from the start and end respectively
        Box.prototype._find_edge_leaves = function (horizontal) {
            var children = this.get_layoutable_children();
            // console.log(`  finding edge leaves in ${children.length}-${this.type}, ` +
            //  `our orientation ${this._horizontal} finding ${horizontal} children `, children)
            var leaves = [
                [],
                []
            ];
            if (children.length > 0) {
                if (this._horizontal == horizontal) {
                    // note start and end may be the same
                    var start = children[0];
                    var end = children[children.length - 1];
                    if (start instanceof Box)
                        leaves[0] = leaves[0].concat(start._find_edge_leaves(horizontal)[0]);
                    else
                        leaves[0].push(start);
                    if (end instanceof Box)
                        leaves[1] = leaves[1].concat(end._find_edge_leaves(horizontal)[1]);
                    else
                        leaves[1].push(end);
                } else {
                    // if we are a column and someone wants the horizontal edges,
                    // we return the horizontal edges from all of our children
                    for (var _i = 0, children_3 = children; _i < children_3.length; _i++) {
                        var child = children_3[_i];
                        if (child instanceof Box) {
                            var child_leaves = child._find_edge_leaves(horizontal);
                            leaves[0] = leaves[0].concat(child_leaves[0]);
                            leaves[1] = leaves[1].concat(child_leaves[1]);
                        } else {
                            leaves[0].push(child);
                            leaves[1].push(child);
                        }
                    }
                }
            }
            // console.log("  start leaves ", leaves[0].map((leaf) -> leaf.id)
            // console.log("  end leaves ", leaves[1].map((leaf) -> leaf.id)
            return leaves;
        };
        Box.prototype._align_outer_edges_constraints = function (horizontal) {
            // console.log(`${if horizontal then 'horizontal' else 'vertical'} outer edge constraints in ${this.get_layoutable_children().length}-${this.type}`)
            var _a = this._find_edge_leaves(horizontal), start_leaves = _a[0], end_leaves = _a[1];
            var start_variable;
            var end_variable;
            if (horizontal) {
                start_variable = 'on_edge_align_left';
                end_variable = 'on_edge_align_right';
            } else {
                start_variable = 'on_edge_align_top';
                end_variable = 'on_edge_align_bottom';
            }
            var collect_vars = function (leaves, name) {
                //console.log(`collecting ${name} in `, leaves)
                var edges = [];
                for (var _i = 0, leaves_1 = leaves; _i < leaves_1.length; _i++) {
                    var leaf = leaves_1[_i];
                    var vars = leaf.get_constrained_variables();
                    if (name in vars)
                        edges.push(vars[name]);
                }
                return edges;
            };
            var start_edges = collect_vars(start_leaves, start_variable);
            var end_edges = collect_vars(end_leaves, end_variable);
            var result = [];
            var add_all_equal = function (edges) {
                if (edges.length > 1) {
                    var first = edges[0];
                    for (var i = 1; i < edges.length; i++) {
                        var edge = edges[i];
                        //console.log(`  constraining ${first._debug} == ${edge._debug}`)
                        result.push(solver_1.EQ([
                            -1,
                            first
                        ], edge));
                    }
                }
            };
            add_all_equal(start_edges);
            add_all_equal(end_edges);
            // console.log("computed constraints ", result)
            return result;
        };
        Box.prototype._box_insets_from_child_insets = function (horizontal, child_variable_prefix, our_variable_prefix, minimum) {
            var _a = this._find_edge_leaves(horizontal), start_leaves = _a[0], end_leaves = _a[1];
            var start_variable;
            var end_variable;
            var our_start;
            var our_end;
            if (horizontal) {
                start_variable = child_variable_prefix + '_left';
                end_variable = child_variable_prefix + '_right';
                our_start = this[our_variable_prefix + '_left'];
                our_end = this[our_variable_prefix + '_right'];
            } else {
                start_variable = child_variable_prefix + '_top';
                end_variable = child_variable_prefix + '_bottom';
                our_start = this[our_variable_prefix + '_top'];
                our_end = this[our_variable_prefix + '_bottom'];
            }
            var result = [];
            var add_constraints = function (ours, leaves, name) {
                for (var _i = 0, leaves_2 = leaves; _i < leaves_2.length; _i++) {
                    var leaf = leaves_2[_i];
                    var vars = leaf.get_constrained_variables();
                    if (name in vars) {
                        if (minimum)
                            result.push(solver_1.GE([
                                -1,
                                ours
                            ], vars[name]));
                        else
                            result.push(solver_1.EQ([
                                -1,
                                ours
                            ], vars[name]));
                    }
                }
            };
            add_constraints(our_start, start_leaves, start_variable);
            add_constraints(our_end, end_leaves, end_variable);
            return result;
        };
        Box.prototype._box_equal_size_bounds = function (horizontal) {
            // false = box bounds equal all outer child bounds exactly
            return this._box_insets_from_child_insets(horizontal, 'box_equal_size', '_box_equal_size', false);
        };
        Box.prototype._box_cell_align_bounds = function (horizontal) {
            // false = box bounds equal all outer child bounds exactly
            return this._box_insets_from_child_insets(horizontal, 'box_cell_align', '_box_cell_align', false);
        };
        Box.prototype._box_whitespace = function (horizontal) {
            // true = box whitespace must be the minimum of child
            // whitespaces (i.e. distance from box edge to the outermost
            // child pixels)
            return this._box_insets_from_child_insets(horizontal, 'whitespace', '_whitespace', true);
        };
        Box._left_right_inner_cell_edge_variables = [
            'box_cell_align_left',
            'box_cell_align_right'
        ];
        Box._top_bottom_inner_cell_edge_variables = [
            'box_cell_align_top',
            'box_cell_align_bottom'
        ];
        return Box;
    }(layout_dom_1.LayoutDOM);
    exports.Box = Box;
    Box.initClass();    
},
/*models/layouts/column*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var box_1 = require(143    /* ./box */);
    var ColumnView = function (_super) {
        tslib_1.__extends(ColumnView, _super);
        function ColumnView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ColumnView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-grid-column');
        };
        return ColumnView;
    }(box_1.BoxView);
    exports.ColumnView = ColumnView;
    var Column = function (_super) {
        tslib_1.__extends(Column, _super);
        function Column(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this._horizontal = false;
            return _this;
        }
        Column.initClass = function () {
            this.prototype.type = 'Column';
            this.prototype.default_view = ColumnView;
        };
        return Column;
    }(box_1.Box);
    exports.Column = Column;
    Column.initClass();    
},
/*models/layouts/index*/
function _(require, module, exports) {
    var box_1 = require(143    /* ./box */);
    exports.Box = box_1.Box;
    var column_1 = require(144    /* ./column */);
    exports.Column = column_1.Column;
    var layout_dom_1 = require(146    /* ./layout_dom */);
    exports.LayoutDOM = layout_dom_1.LayoutDOM;
    var row_1 = require(147    /* ./row */);
    exports.Row = row_1.Row;
    var spacer_1 = require(148    /* ./spacer */);
    exports.Spacer = spacer_1.Spacer;
    var widget_box_1 = require(149    /* ./widget_box */);
    exports.WidgetBox = widget_box_1.WidgetBox;    
},
/*models/layouts/layout_dom*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var model_1 = require(53    /* ../../model */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var layout_canvas_1 = require(11    /* core/layout/layout_canvas */);
    var solver_1 = require(13    /* core/layout/solver */);
    var build_views_1 = require(4    /* core/build_views */);
    var dom_view_1 = require(6    /* core/dom_view */);
    var LayoutDOMView = function (_super) {
        tslib_1.__extends(LayoutDOMView, _super);
        function LayoutDOMView() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._solver_inited = false;
            _this._idle_notified = false;
            return _this;
        }
        LayoutDOMView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            // this is a root view
            if (this.is_root)
                this._solver = new solver_1.Solver();
            this.child_views = {};
            this.build_child_views();
        };
        LayoutDOMView.prototype.remove = function () {
            for (var model_id in this.child_views) {
                var view = this.child_views[model_id];
                view.remove();
            }
            this.child_views = {};
            // remove on_resize
            _super.prototype.remove.call(this);
        };
        LayoutDOMView.prototype.has_finished = function () {
            if (!_super.prototype.has_finished.call(this))
                return false;
            for (var model_id in this.child_views) {
                var child = this.child_views[model_id];
                if (!child.has_finished())
                    return false;
            }
            return true;
        };
        LayoutDOMView.prototype.notify_finished = function () {
            if (!this.is_root)
                _super.prototype.notify_finished.call(this);
            else {
                if (!this._idle_notified && this.has_finished()) {
                    if (this.model.document != null) {
                        this._idle_notified = true;
                        this.model.document.notify_idle(this.model);
                    }
                }
            }
        };
        LayoutDOMView.prototype._calc_width_height = function () {
            var measuring = this.el;
            while (measuring = measuring.parentElement) {
                // .bk-root element doesn't bring any value
                if (measuring.classList.contains('bk-root'))
                    continue;
                // we reached <body> element, so use viewport size
                if (measuring == document.body) {
                    var _a = dom_1.margin(document.body), left_1 = _a.left, right_1 = _a.right, top_1 = _a.top, bottom_1 = _a.bottom;
                    var width_1 = document.documentElement.clientWidth - left_1 - right_1;
                    var height_1 = document.documentElement.clientHeight - top_1 - bottom_1;
                    return [
                        width_1,
                        height_1
                    ];
                }
                // stop on first element with sensible dimensions
                var _b = dom_1.padding(measuring), left = _b.left, right = _b.right, top_2 = _b.top, bottom = _b.bottom;
                var rect = measuring.getBoundingClientRect();
                var width = rect.width - left - right;
                var height = rect.height - top_2 - bottom;
                if (width != 0 && height != 0)
                    return [
                        width,
                        height
                    ];
            }
            // this element is detached from DOM
            return [
                null,
                null
            ];
        };
        LayoutDOMView.prototype._init_solver = function () {
            this._root_width = new solver_1.Variable(this.toString() + '.root_width');
            this._root_height = new solver_1.Variable(this.toString() + '.root_height');
            // XXX: this relies on the fact that missing `strength` argument results
            // in strength being NaN, which behaves like `Strength.required`. However,
            // this is banned by the API.
            this._solver.add_edit_variable(this._root_width, NaN);
            this._solver.add_edit_variable(this._root_height, NaN);
            var editables = this.model.get_all_editables();
            for (var _i = 0, editables_1 = editables; _i < editables_1.length; _i++) {
                var edit_variable = editables_1[_i];
                this._solver.add_edit_variable(edit_variable, solver_1.Strength.strong);
            }
            var constraints = this.model.get_all_constraints();
            for (var _a = 0, constraints_1 = constraints; _a < constraints_1.length; _a++) {
                var constraint = constraints_1[_a];
                this._solver.add_constraint(constraint);
            }
            var variables = this.model.get_constrained_variables();
            if (variables.width != null)
                this._solver.add_constraint(solver_1.EQ(variables.width, this._root_width));
            if (variables.height != null)
                this._solver.add_constraint(solver_1.EQ(variables.height, this._root_height));
            this._solver.update_variables();
            this._solver_inited = true;
        };
        LayoutDOMView.prototype._suggest_dims = function (width, height) {
            var variables = this.model.get_constrained_variables();
            if (variables.width != null || variables.height != null) {
                if (width == null || height == null)
                    _a = this._calc_width_height(), width = _a[0], height = _a[1];
                if (variables.width != null && width != null)
                    this._solver.suggest_value(this._root_width, width);
                if (variables.height != null && height != null)
                    this._solver.suggest_value(this._root_height, height);
                this._solver.update_variables();
            }
            var _a;
        };
        LayoutDOMView.prototype.resize = function (width, height) {
            if (width === void 0) {
                width = null;
            }
            if (height === void 0) {
                height = null;
            }
            if (!this.is_root)
                this.root.resize(width, height);
            else
                this._do_layout(false, width, height);
        };
        LayoutDOMView.prototype.partial_layout = function () {
            if (!this.is_root)
                this.root.partial_layout();
            else
                this._do_layout(false);
        };
        LayoutDOMView.prototype.layout = function () {
            if (!this.is_root)
                this.root.layout();
            else
                this._do_layout(true);
        };
        LayoutDOMView.prototype._do_layout = function (full, width, height) {
            if (width === void 0) {
                width = null;
            }
            if (height === void 0) {
                height = null;
            }
            if (!this._solver_inited || full) {
                this._solver.clear();
                this._init_solver();
            }
            this._suggest_dims(width, height);
            // XXX: do layout twice, because there are interdependencies between views,
            // which currently cannot be resolved with one pass. The third one triggers
            // rendering and (expensive) painting.
            this._layout();
            // layout (1)
            this._layout();
            // layout (2)
            this._layout(true);
            // render & paint
            this.notify_finished();
        };
        LayoutDOMView.prototype._layout = function (final) {
            if (final === void 0) {
                final = false;
            }
            for (var _i = 0, _a = this.model.get_layoutable_children(); _i < _a.length; _i++) {
                var child = _a[_i];
                var child_view = this.child_views[child.id];
                if (child_view._layout != null)
                    child_view._layout(final);
            }
            this.render();
            if (final)
                this._has_finished = true;
        };
        LayoutDOMView.prototype.rebuild_child_views = function () {
            this.solver.clear();
            this.build_child_views();
            this.layout();
        };
        LayoutDOMView.prototype.build_child_views = function () {
            var children = this.model.get_layoutable_children();
            build_views_1.build_views(this.child_views, children, { parent: this });
            dom_1.empty(this.el);
            for (var _i = 0, children_1 = children; _i < children_1.length; _i++) {
                var child = children_1[_i];
                // Look-up the child_view in this.child_views and then append We can't just
                // read from this.child_views because then we don't get guaranteed ordering.
                // Which is a problem in non-box layouts.
                var child_view = this.child_views[child.id];
                this.el.appendChild(child_view.el);
            }
        };
        LayoutDOMView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            if (this.is_root)
                window.addEventListener('resize', function () {
                    return _this.resize();
                });
            // XXX: this.connect(this.model.change, () => this.layout())
            this.connect(this.model.properties.sizing_mode.change, function () {
                return _this.layout();
            });
        };
        LayoutDOMView.prototype._render_classes = function () {
            this.el.className = '';
            // removes all classes
            for (var _i = 0, _a = this.css_classes(); _i < _a.length; _i++) {
                var name_1 = _a[_i];
                this.el.classList.add(name_1);
            }
            this.el.classList.add('bk-layout-' + this.model.sizing_mode);
            for (var _b = 0, _c = this.model.css_classes; _b < _c.length; _b++) {
                var cls = _c[_b];
                this.el.classList.add(cls);
            }
        };
        LayoutDOMView.prototype.render = function () {
            this._render_classes();
            switch (this.model.sizing_mode) {
            case 'fixed': {
                    // If the width or height is unset:
                    // - compute it from children
                    // - but then save for future use
                    // (for some reason widget boxes keep shrinking if you keep computing
                    // but this is more efficient and appropriate for fixed anyway).
                    var width = void 0;
                    if (this.model.width != null)
                        width = this.model.width;
                    else
                        width = this.get_width();
                    this.model.setv({ width: width }, { silent: true });
                    var height = void 0;
                    if (this.model.height != null)
                        height = this.model.height;
                    else
                        height = this.get_height();
                    this.model.setv({ height: height }, { silent: true });
                    this.solver.suggest_value(this.model._width, width);
                    this.solver.suggest_value(this.model._height, height);
                    break;
                }
            case 'scale_width': {
                    var height = this.get_height();
                    this.solver.suggest_value(this.model._height, height);
                    break;
                }
            case 'scale_height': {
                    var width = this.get_width();
                    this.solver.suggest_value(this.model._width, width);
                    break;
                }
            case 'scale_both': {
                    var _a = this.get_width_height(), width = _a[0], height = _a[1];
                    this.solver.suggest_value(this.model._width, width);
                    this.solver.suggest_value(this.model._height, height);
                    break;
                }
            }
            this.solver.update_variables();
            this.position();
        };
        LayoutDOMView.prototype.position = function () {
            switch (this.model.sizing_mode) {
            case 'fixed':
            case 'scale_width':
            case 'scale_height': {
                    this.el.style.position = 'relative';
                    this.el.style.left = '';
                    this.el.style.top = '';
                    break;
                }
            case 'scale_both':
            case 'stretch_both': {
                    this.el.style.position = 'absolute';
                    this.el.style.left = this.model._dom_left.value + 'px';
                    this.el.style.top = this.model._dom_top.value + 'px';
                    break;
                }
            }
            this.el.style.width = this.model._width.value + 'px';
            this.el.style.height = this.model._height.value + 'px';
        };
        LayoutDOMView.prototype.get_width_height = function () {
            var parent = this.el.parentElement;
            if (parent == null)
                throw new Error('detached element');
            var parent_height = parent.clientHeight;
            var parent_width = parent.clientWidth;
            var ar = this.model.get_aspect_ratio();
            var new_width_1 = parent_width;
            var new_height_1 = parent_width / ar;
            var new_width_2 = parent_height * ar;
            var new_height_2 = parent_height;
            var width;
            var height;
            if (new_width_1 < new_width_2) {
                width = new_width_1;
                height = new_height_1;
            } else {
                width = new_width_2;
                height = new_height_2;
            }
            return [
                width,
                height
            ];
        };
        return LayoutDOMView;
    }(dom_view_1.DOMView);
    exports.LayoutDOMView = LayoutDOMView;
    var LayoutDOM = function (_super) {
        tslib_1.__extends(LayoutDOM, _super);
        function LayoutDOM(attrs) {
            return _super.call(this, attrs) || this;
        }
        LayoutDOM.initClass = function () {
            this.prototype.type = 'LayoutDOM';
            this.define({
                height: [p.Number],
                width: [p.Number],
                disabled: [
                    p.Bool,
                    false
                ],
                sizing_mode: [
                    p.SizingMode,
                    'fixed'
                ],
                css_classes: [
                    p.Array,
                    []
                ]
            });
        };
        LayoutDOM.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._width = new solver_1.Variable(this.toString() + '.width');
            this._height = new solver_1.Variable(this.toString() + '.height');
            this._left = new solver_1.Variable(this.toString() + '.left');
            this._right = new solver_1.Variable(this.toString() + '.right');
            this._top = new solver_1.Variable(this.toString() + '.top');
            this._bottom = new solver_1.Variable(this.toString() + '.bottom');
            this._dom_top = new solver_1.Variable(this.toString() + '.dom_top');
            this._dom_left = new solver_1.Variable(this.toString() + '.dom_left');
            this._width_minus_right = new solver_1.Variable(this.toString() + '.width_minus_right');
            this._height_minus_bottom = new solver_1.Variable(this.toString() + '.height_minus_bottom');
            this._whitespace_top = new solver_1.Variable(this.toString() + '.whitespace_top');
            this._whitespace_bottom = new solver_1.Variable(this.toString() + '.whitespace_bottom');
            this._whitespace_left = new solver_1.Variable(this.toString() + '.whitespace_left');
            this._whitespace_right = new solver_1.Variable(this.toString() + '.whitespace_right');
        };
        Object.defineProperty(LayoutDOM.prototype, 'layout_bbox', {
            get: function () {
                return {
                    top: this._top.value,
                    left: this._left.value,
                    width: this._width.value,
                    height: this._height.value,
                    right: this._right.value,
                    bottom: this._bottom.value,
                    dom_top: this._dom_top.value,
                    dom_left: this._dom_left.value
                };
            },
            enumerable: true,
            configurable: true
        });
        LayoutDOM.prototype.dump_layout = function () {
            var layoutables = {};
            var pending = [this];
            var obj;
            while (obj = pending.shift()) {
                pending.push.apply(pending, obj.get_layoutable_children());
                layoutables[obj.toString()] = obj.layout_bbox;
            }
            console.table(layoutables);
        };
        LayoutDOM.prototype.get_all_constraints = function () {
            var constraints = this.get_constraints();
            for (var _i = 0, _a = this.get_layoutable_children(); _i < _a.length; _i++) {
                var child = _a[_i];
                if (child instanceof layout_canvas_1.LayoutCanvas)
                    constraints = constraints.concat(child.get_constraints());
                else
                    constraints = constraints.concat(child.get_all_constraints());
            }
            return constraints;
        };
        LayoutDOM.prototype.get_all_editables = function () {
            var editables = this.get_editables();
            for (var _i = 0, _a = this.get_layoutable_children(); _i < _a.length; _i++) {
                var child = _a[_i];
                if (child instanceof layout_canvas_1.LayoutCanvas)
                    editables = editables.concat(child.get_editables());
                else
                    editables = editables.concat(child.get_all_editables());
            }
            return editables;
        };
        LayoutDOM.prototype.get_constraints = function () {
            return [
                // Make sure things dont squeeze out of their bounding box
                solver_1.GE(this._dom_left),
                solver_1.GE(this._dom_top),
                // Plot has to be inside the width/height
                solver_1.GE(this._left),
                solver_1.GE(this._width, [
                    -1,
                    this._right
                ]),
                solver_1.GE(this._top),
                solver_1.GE(this._height, [
                    -1,
                    this._bottom
                ]),
                // Declare computed constraints
                solver_1.EQ(this._width_minus_right, [
                    -1,
                    this._width
                ], this._right),
                solver_1.EQ(this._height_minus_bottom, [
                    -1,
                    this._height
                ], this._bottom)
            ];
        };
        LayoutDOM.prototype.get_layoutable_children = function () {
            return [];
        };
        LayoutDOM.prototype.get_editables = function () {
            switch (this.sizing_mode) {
            case 'fixed':
                return [
                    this._height,
                    this._width
                ];
            case 'scale_width':
                return [this._height];
            case 'scale_height':
                return [this._width];
            case 'scale_both':
                return [
                    this._width,
                    this._height
                ];
            default:
                return [];
            }
        };
        LayoutDOM.prototype.get_constrained_variables = function () {
            /*
         * THE FOLLOWING ARE OPTIONAL VARS THAT
         * YOU COULD ADD INTO SUBCLASSES
         *
         *  # When this widget is on the edge of a box visually,
         *  # align these variables down that edge. Right/bottom
         *  # are an inset from the edge.
         *  on_edge_align_top    : this._top
         *  on_edge_align_bottom : this._height_minus_bottom
         *  on_edge_align_left   : this._left
         *  on_edge_align_right  : this._width_minus_right
         *  # When this widget is in a box cell with the same "arity
         *  # path" as a widget in another cell, align these variables
         *  # between the two box cells. Right/bottom are an inset from
         *  # the edge.
         *  box_cell_align_top   : this._top
         *  box_cell_align_bottom: this._height_minus_bottom
         *  box_cell_align_left  : this._left
         *  box_cell_align_right : this._width_minus_right
         *  # When this widget is in a box, make these the same distance
         *  # apart in every widget. Right/bottom are inset from the edge.
         *  box_equal_size_top   : this._top
         *  box_equal_size_bottom: this._height_minus_bottom
         *  box_equal_size_left  : this._left
         *  box_equal_size_right : this._width_minus_right
         */
            var vars = {
                origin_x: this._dom_left,
                origin_y: this._dom_top,
                whitespace_top: this._whitespace_top,
                whitespace_bottom: this._whitespace_bottom,
                whitespace_left: this._whitespace_left,
                whitespace_right: this._whitespace_right
            };
            switch (this.sizing_mode) {
            case 'stretch_both':
                vars.width = this._width;
                vars.height = this._height;
                break;
            case 'scale_width':
                vars.width = this._width;
                break;
            case 'scale_height':
                vars.height = this._height;
                break;
            }
            return vars;
        };
        LayoutDOM.prototype.get_aspect_ratio = function () {
            return this.width / this.height;
        };
        return LayoutDOM;
    }(model_1.Model);
    exports.LayoutDOM = LayoutDOM;
    LayoutDOM.initClass();    
},
/*models/layouts/row*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var box_1 = require(143    /* ./box */);
    var RowView = function (_super) {
        tslib_1.__extends(RowView, _super);
        function RowView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        RowView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-grid-row');
        };
        return RowView;
    }(box_1.BoxView);
    exports.RowView = RowView;
    var Row = function (_super) {
        tslib_1.__extends(Row, _super);
        function Row(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this._horizontal = true;
            return _this;
        }
        Row.initClass = function () {
            this.prototype.type = 'Row';
            this.prototype.default_view = RowView;
        };
        return Row;
    }(box_1.Box);
    exports.Row = Row;
    Row.initClass();    
},
/*models/layouts/spacer*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var layout_dom_1 = require(146    /* ./layout_dom */);
    var object_1 = require(32    /* core/util/object */);
    var SpacerView = function (_super) {
        tslib_1.__extends(SpacerView, _super);
        function SpacerView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SpacerView.prototype.render = function () {
            _super.prototype.render.call(this);
            if (this.model.sizing_mode == 'fixed') {
                this.el.style.width = this.model.width + 'px';
                this.el.style.height = this.model.height + 'px';
            }
        };
        SpacerView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-spacer-box');
        };
        // spacer must always have some width/height
        SpacerView.prototype.get_width = function () {
            return 1;
        };
        SpacerView.prototype.get_height = function () {
            return 1;
        };
        return SpacerView;
    }(layout_dom_1.LayoutDOMView);
    exports.SpacerView = SpacerView;
    var Spacer = function (_super) {
        tslib_1.__extends(Spacer, _super);
        function Spacer(attrs) {
            return _super.call(this, attrs) || this;
        }
        Spacer.initClass = function () {
            this.prototype.type = 'Spacer';
            this.prototype.default_view = SpacerView;
        };
        Spacer.prototype.get_constrained_variables = function () {
            return object_1.extend({}, _super.prototype.get_constrained_variables.call(this), {
                on_edge_align_top: this._top,
                on_edge_align_bottom: this._height_minus_bottom,
                on_edge_align_left: this._left,
                on_edge_align_right: this._width_minus_right,
                box_cell_align_top: this._top,
                box_cell_align_bottom: this._height_minus_bottom,
                box_cell_align_left: this._left,
                box_cell_align_right: this._width_minus_right,
                box_equal_size_top: this._top,
                box_equal_size_bottom: this._height_minus_bottom,
                box_equal_size_left: this._left,
                box_equal_size_right: this._width_minus_right
            });
        };
        return Spacer;
    }(layout_dom_1.LayoutDOM);
    exports.Spacer = Spacer;
    Spacer.initClass();    
},
/*models/layouts/widget_box*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var object_1 = require(32    /* core/util/object */);
    var layout_dom_1 = require(146    /* ../layouts/layout_dom */);
    var WidgetBoxView = function (_super) {
        tslib_1.__extends(WidgetBoxView, _super);
        function WidgetBoxView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        WidgetBoxView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.properties.children.change, function () {
                return _this.rebuild_child_views();
            });
        };
        WidgetBoxView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-widget-box');
        };
        WidgetBoxView.prototype.render = function () {
            this._render_classes();
            // XXX: because no super()
            if (this.model.sizing_mode == 'fixed' || this.model.sizing_mode == 'scale_height') {
                var width = this.get_width();
                if (this.model._width.value != width)
                    this.solver.suggest_value(this.model._width, width);
            }
            if (this.model.sizing_mode == 'fixed' || this.model.sizing_mode == 'scale_width') {
                var height = this.get_height();
                if (this.model._height.value != height)
                    this.solver.suggest_value(this.model._height, height);
            }
            this.solver.update_variables();
            if (this.model.sizing_mode == 'stretch_both') {
                this.el.style.position = 'absolute';
                this.el.style.left = this.model._dom_left.value + 'px';
                this.el.style.top = this.model._dom_top.value + 'px';
                this.el.style.width = this.model._width.value + 'px';
                this.el.style.height = this.model._height.value + 'px';
            } else {
                // Note we DO NOT want to set a height (except in stretch_both). Widgets
                // are happier sizing themselves. We've tried to tell the layout what
                // the height is with the suggest_value. But that doesn't mean we need
                // to put it in the dom.
                var css_width = void 0;
                if (this.model._width.value - 20 > 0)
                    css_width = this.model._width.value - 20 + 'px';
                else
                    css_width = '100%';
                this.el.style.width = css_width;
            }
        };
        WidgetBoxView.prototype.get_height = function () {
            var height = 0;
            for (var key in this.child_views) {
                var child_view = this.child_views[key];
                var el = child_view.el;
                var style = getComputedStyle(el);
                var marginTop = parseInt(style.marginTop) || 0;
                var marginBottom = parseInt(style.marginBottom) || 0;
                height += el.offsetHeight + marginTop + marginBottom;
            }
            return height + 20;
        };
        WidgetBoxView.prototype.get_width = function () {
            if (this.model.width != null)
                return this.model.width;
            else {
                var width = this.el.scrollWidth + 20;
                for (var key in this.child_views) {
                    var child_view = this.child_views[key];
                    // Take the max width of all the children as the constrainer.
                    var child_width = child_view.el.scrollWidth;
                    if (child_width > width)
                        width = child_width;
                }
                return width;
            }
        };
        return WidgetBoxView;
    }(layout_dom_1.LayoutDOMView);
    exports.WidgetBoxView = WidgetBoxView;
    var WidgetBox = function (_super) {
        tslib_1.__extends(WidgetBox, _super);
        function WidgetBox(attrs) {
            return _super.call(this, attrs) || this;
        }
        WidgetBox.initClass = function () {
            this.prototype.type = 'WidgetBox';
            this.prototype.default_view = WidgetBoxView;
            this.define({
                children: [
                    p.Array,
                    []
                ]
            });
        };
        WidgetBox.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            if (this.sizing_mode == 'fixed' && this.width == null) {
                this.width = 300;
                // Set a default for fixed.
                logging_1.logger.info('WidgetBox mode is fixed, but no width specified. Using default of 300.');
            }
        };
        WidgetBox.prototype.get_constrained_variables = function () {
            var vars = object_1.extend({}, _super.prototype.get_constrained_variables.call(this), {
                on_edge_align_top: this._top,
                on_edge_align_bottom: this._height_minus_bottom,
                on_edge_align_left: this._left,
                on_edge_align_right: this._width_minus_right,
                box_cell_align_top: this._top,
                box_cell_align_bottom: this._height_minus_bottom,
                box_cell_align_left: this._left,
                box_cell_align_right: this._width_minus_right,
                box_equal_size_top: this._top,
                box_equal_size_bottom: this._height_minus_bottom
            });
            if (this.sizing_mode != 'fixed') {
                vars.box_equal_size_left = this._left;
                vars.box_equal_size_right = this._width_minus_right;
            }
            return vars;
        };
        WidgetBox.prototype.get_layoutable_children = function () {
            return this.children;
        };
        return WidgetBox;
    }(layout_dom_1.LayoutDOM);
    exports.WidgetBox = WidgetBox;
    WidgetBox.initClass();    
},
/*models/mappers/categorical_color_mapper*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var color_mapper_1 = require(151    /* ./color_mapper */);
    var p = require(15    /* core/properties */);
    var array_1 = require(21    /* core/util/array */);
    var types_1 = require(44    /* core/util/types */);
    function _equals(a, b) {
        if (a.length != b.length)
            return false;
        for (var i = 0, end = a.length; i < end; i++) {
            if (a[i] !== b[i])
                return false;
        }
        return true;
    }
    var CategoricalColorMapper = function (_super) {
        tslib_1.__extends(CategoricalColorMapper, _super);
        function CategoricalColorMapper(attrs) {
            return _super.call(this, attrs) || this;
        }
        CategoricalColorMapper.initClass = function () {
            this.prototype.type = 'CategoricalColorMapper';
            this.define({
                factors: [p.Array],
                start: [
                    p.Number,
                    0
                ],
                end: [p.Number]
            });
        };
        CategoricalColorMapper.prototype._v_compute = function (data, values, palette, _a) {
            var nan_color = _a.nan_color;
            var _loop_1 = function (i, end) {
                var d = data[i];
                var key = void 0;
                if (types_1.isString(d))
                    key = this_1.factors.indexOf(d);
                else {
                    if (this_1.start != null) {
                        if (this_1.end != null)
                            d = d.slice(this_1.start, this_1.end);
                        else
                            d = d.slice(this_1.start);
                    } else if (this_1.end != null)
                        d = d.slice(0, this_1.end);
                    if (d.length == 1)
                        key = this_1.factors.indexOf(d[0]);
                    else
                        key = array_1.findIndex(this_1.factors, function (x) {
                            return _equals(x, d);
                        });
                }
                var color = void 0;
                if (key < 0 || key >= palette.length)
                    color = nan_color;
                else
                    color = palette[key];
                values[i] = color;
            };
            var this_1 = this;
            for (var i = 0, end = data.length; i < end; i++) {
                _loop_1(i, end);
            }
        };
        return CategoricalColorMapper;
    }(color_mapper_1.ColorMapper);
    exports.CategoricalColorMapper = CategoricalColorMapper;
    CategoricalColorMapper.initClass();    
},
/*models/mappers/color_mapper*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var transform_1 = require(259    /* ../transforms/transform */);
    var p = require(15    /* core/properties */);
    var color_1 = require(27    /* core/util/color */);
    var compat_1 = require(28    /* core/util/compat */);
    function _convert_color(color) {
        if (color[0] != '#')
            color = color_1.color2hex(color);
        if (color.length != 9)
            color = color + 'ff';
        return parseInt(color.slice(1), 16);
    }
    exports._convert_color = _convert_color;
    function _convert_palette(palette) {
        var new_palette = new Uint32Array(palette.length);
        for (var i = 0, end = palette.length; i < end; i++)
            new_palette[i] = _convert_color(palette[i]);
        return new_palette;
    }
    exports._convert_palette = _convert_palette;
    function _uint32_to_rgba(values) {
        if (compat_1.is_little_endian) {
            var view = new DataView(values.buffer);
            for (var i = 0, end = values.length; i < end; i++)
                view.setUint32(i * 4, values[i]);
        }
        return new Uint8Array(values.buffer);
    }
    exports._uint32_to_rgba = _uint32_to_rgba;
    var ColorMapper = function (_super) {
        tslib_1.__extends(ColorMapper, _super);
        function ColorMapper(attrs) {
            return _super.call(this, attrs) || this;
        }
        ColorMapper.initClass = function () {
            this.prototype.type = 'ColorMapper';
            this.define({
                palette: [p.Any],
                nan_color: [
                    p.Color,
                    'gray'
                ]
            });
        };
        ColorMapper.prototype.compute = function (_x) {
            // If it's just a single value, then a color mapper doesn't really make sense.
            throw new Error('not supported');
        };
        ColorMapper.prototype.v_compute = function (xs) {
            var values = new Array(xs.length);
            this._v_compute(xs, values, this.palette, this._colors(function (c) {
                return c;
            }));
            return values;
        };
        Object.defineProperty(ColorMapper.prototype, 'rgba_mapper', {
            get: function () {
                var self = this;
                var palette = _convert_palette(this.palette);
                var colors = this._colors(_convert_color);
                return {
                    v_compute: function (xs) {
                        var values = new Uint32Array(xs.length);
                        self._v_compute(xs, values, palette, colors);
                        return _uint32_to_rgba(values);
                    }
                };
            },
            enumerable: true,
            configurable: true
        });
        ColorMapper.prototype._colors = function (conv) {
            return { nan_color: conv(this.nan_color) };
        };
        return ColorMapper;
    }(transform_1.Transform);
    exports.ColorMapper = ColorMapper;
    ColorMapper.initClass();    
},
/*models/mappers/continuous_color_mapper*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var color_mapper_1 = require(151    /* ./color_mapper */);
    var p = require(15    /* core/properties */);
    var ContinuousColorMapper = function (_super) {
        tslib_1.__extends(ContinuousColorMapper, _super);
        function ContinuousColorMapper(attrs) {
            return _super.call(this, attrs) || this;
        }
        ContinuousColorMapper.initClass = function () {
            this.prototype.type = 'ContinuousColorMapper';
            this.define({
                high: [p.Number],
                low: [p.Number],
                high_color: [p.Color],
                low_color: [p.Color]
            });
        };
        ContinuousColorMapper.prototype._colors = function (conv) {
            return tslib_1.__assign({}, _super.prototype._colors.call(this, conv), {
                low_color: this.low_color != null ? conv(this.low_color) : undefined,
                high_color: this.high_color != null ? conv(this.high_color) : undefined
            });
        };
        return ContinuousColorMapper;
    }(color_mapper_1.ColorMapper);
    exports.ContinuousColorMapper = ContinuousColorMapper;
    ContinuousColorMapper.initClass();    
},
/*models/mappers/index*/
function _(require, module, exports) {
    var categorical_color_mapper_1 = require(150    /* ./categorical_color_mapper */);
    exports.CategoricalColorMapper = categorical_color_mapper_1.CategoricalColorMapper;
    var continuous_color_mapper_1 = require(152    /* ./continuous_color_mapper */);
    exports.ContinuousColorMapper = continuous_color_mapper_1.ContinuousColorMapper;
    var color_mapper_1 = require(151    /* ./color_mapper */);
    exports.ColorMapper = color_mapper_1.ColorMapper;
    var linear_color_mapper_1 = require(154    /* ./linear_color_mapper */);
    exports.LinearColorMapper = linear_color_mapper_1.LinearColorMapper;
    var log_color_mapper_1 = require(155    /* ./log_color_mapper */);
    exports.LogColorMapper = log_color_mapper_1.LogColorMapper;    
},
/*models/mappers/linear_color_mapper*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var continuous_color_mapper_1 = require(152    /* ./continuous_color_mapper */);
    var arrayable_1 = require(22    /* core/util/arrayable */);
    var LinearColorMapper = function (_super) {
        tslib_1.__extends(LinearColorMapper, _super);
        function LinearColorMapper(attrs) {
            return _super.call(this, attrs) || this;
        }
        LinearColorMapper.initClass = function () {
            this.prototype.type = 'LinearColorMapper';
        };
        LinearColorMapper.prototype._v_compute = function (data, values, palette, colors) {
            var nan_color = colors.nan_color, low_color = colors.low_color, high_color = colors.high_color;
            var low = this.low != null ? this.low : arrayable_1.min(data);
            var high = this.high != null ? this.high : arrayable_1.max(data);
            var max_key = palette.length - 1;
            var norm_factor = 1 / (high - low);
            var normed_interval = 1 / palette.length;
            for (var i = 0, end = data.length; i < end; i++) {
                var d = data[i];
                if (isNaN(d)) {
                    values[i] = nan_color;
                    continue;
                }
                // This handles the edge case where d == high, since the code below maps
                // values exactly equal to high to palette.length, which is greater than
                // max_key
                if (d == high) {
                    values[i] = palette[max_key];
                    continue;
                }
                var normed_d = (d - low) * norm_factor;
                var key = Math.floor(normed_d / normed_interval);
                if (key < 0)
                    values[i] = low_color != null ? low_color : palette[0];
                else if (key > max_key)
                    values[i] = high_color != null ? high_color : palette[max_key];
                else
                    values[i] = palette[key];
            }
        };
        return LinearColorMapper;
    }(continuous_color_mapper_1.ContinuousColorMapper);
    exports.LinearColorMapper = LinearColorMapper;
    LinearColorMapper.initClass();    
},
/*models/mappers/log_color_mapper*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var continuous_color_mapper_1 = require(152    /* ./continuous_color_mapper */);
    var arrayable_1 = require(22    /* core/util/arrayable */);
    // Math.log1p() is not supported by any version of IE, so let's use a polyfill based on
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/log1p.
    var log1p = Math.log1p != null ? Math.log1p : function (x) {
        return Math.log(1 + x);
    };
    var LogColorMapper = function (_super) {
        tslib_1.__extends(LogColorMapper, _super);
        function LogColorMapper(attrs) {
            return _super.call(this, attrs) || this;
        }
        LogColorMapper.initClass = function () {
            this.prototype.type = 'LogColorMapper';
        };
        LogColorMapper.prototype._v_compute = function (data, values, palette, colors) {
            var nan_color = colors.nan_color, low_color = colors.low_color, high_color = colors.high_color;
            var n = palette.length;
            var low = this.low != null ? this.low : arrayable_1.min(data);
            var high = this.high != null ? this.high : arrayable_1.max(data);
            var scale = n / (log1p(high) - log1p(low));
            // subtract the low offset
            var max_key = palette.length - 1;
            for (var i = 0, end = data.length; i < end; i++) {
                var d = data[i];
                // Check NaN
                if (isNaN(d)) {
                    values[i] = nan_color;
                    continue;
                }
                if (d > high) {
                    values[i] = high_color != null ? high_color : palette[max_key];
                    continue;
                }
                // This handles the edge case where d == high, since the code below maps
                // values exactly equal to high to palette.length, which is greater than
                // max_key
                if (d == high) {
                    values[i] = palette[max_key];
                    continue;
                }
                if (d < low) {
                    values[i] = low_color != null ? low_color : palette[0];
                    continue;
                }
                // Get the key
                var log = log1p(d) - log1p(low);
                // subtract the low offset
                var key = Math.floor(log * scale);
                // Deal with upper bound
                if (key > max_key)
                    key = max_key;
                values[i] = palette[key];
            }
        };
        return LogColorMapper;
    }(continuous_color_mapper_1.ContinuousColorMapper);
    exports.LogColorMapper = LogColorMapper;
    LogColorMapper.initClass();    
},
/*models/markers/index*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var marker_1 = require(157    /* ./marker */);
    var SQ3 = Math.sqrt(3);
    function _one_x(ctx, r) {
        ctx.moveTo(-r, r);
        ctx.lineTo(r, -r);
        ctx.moveTo(-r, -r);
        ctx.lineTo(r, r);
    }
    function _one_cross(ctx, r) {
        ctx.moveTo(0, r);
        ctx.lineTo(0, -r);
        ctx.moveTo(-r, 0);
        ctx.lineTo(r, 0);
    }
    function _one_diamond(ctx, r) {
        ctx.moveTo(0, r);
        ctx.lineTo(r / 1.5, 0);
        ctx.lineTo(0, -r);
        ctx.lineTo(-r / 1.5, 0);
        ctx.closePath();
    }
    function _one_hex(ctx, r) {
        var r2 = r / 2;
        var h = SQ3 * r2;
        ctx.moveTo(r, 0);
        ctx.lineTo(r2, -h);
        ctx.lineTo(-r2, -h);
        ctx.lineTo(-r, 0);
        ctx.lineTo(-r2, h);
        ctx.lineTo(r2, h);
        ctx.closePath();
    }
    function _one_tri(ctx, r) {
        var h = r * SQ3;
        var a = h / 3;
        ctx.moveTo(-r, a);
        ctx.lineTo(r, a);
        ctx.lineTo(0, a - h);
        ctx.closePath();
    }
    function asterisk(ctx, i, r, line, _fill) {
        var r2 = r * 0.65;
        _one_cross(ctx, r);
        _one_x(ctx, r2);
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    }
    function circle_cross(ctx, i, r, line, fill) {
        ctx.arc(0, 0, r, 0, 2 * Math.PI, false);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            _one_cross(ctx, r);
            ctx.stroke();
        }
    }
    function circle_x(ctx, i, r, line, fill) {
        ctx.arc(0, 0, r, 0, 2 * Math.PI, false);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            _one_x(ctx, r);
            ctx.stroke();
        }
    }
    function cross(ctx, i, r, line, _fill) {
        _one_cross(ctx, r);
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    }
    function diamond(ctx, i, r, line, fill) {
        _one_diamond(ctx, r);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    }
    function diamond_cross(ctx, i, r, line, fill) {
        _one_diamond(ctx, r);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            _one_cross(ctx, r);
            ctx.stroke();
        }
    }
    function hex(ctx, i, r, line, fill) {
        _one_hex(ctx, r);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    }
    function inverted_triangle(ctx, i, r, line, fill) {
        ctx.rotate(Math.PI);
        _one_tri(ctx, r);
        ctx.rotate(-Math.PI);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    }
    function square(ctx, i, r, line, fill) {
        var size = 2 * r;
        ctx.rect(-r, -r, size, size);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    }
    function square_cross(ctx, i, r, line, fill) {
        var size = 2 * r;
        ctx.rect(-r, -r, size, size);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            _one_cross(ctx, r);
            ctx.stroke();
        }
    }
    function square_x(ctx, i, r, line, fill) {
        var size = 2 * r;
        ctx.rect(-r, -r, size, size);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            _one_x(ctx, r);
            ctx.stroke();
        }
    }
    function triangle(ctx, i, r, line, fill) {
        _one_tri(ctx, r);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    }
    function x(ctx, i, r, line, _fill) {
        _one_x(ctx, r);
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    }
    function _mk_model(type, f) {
        var view = function (_super) {
            tslib_1.__extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_1.initClass = function () {
                this.prototype._render_one = f;
            };
            return class_1;
        }(marker_1.MarkerView);
        view.initClass();
        var model = function (_super) {
            tslib_1.__extends(class_2, _super);
            function class_2() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_2.initClass = function () {
                this.prototype.default_view = view;
                this.prototype.type = type;
            };
            return class_2;
        }(marker_1.Marker);
        model.initClass();
        return model;
    }
    // markers are final, so no need to export views
    exports.Asterisk = _mk_model('Asterisk', asterisk);
    exports.CircleCross = _mk_model('CircleCross', circle_cross);
    exports.CircleX = _mk_model('CircleX', circle_x);
    exports.Cross = _mk_model('Cross', cross);
    exports.Diamond = _mk_model('Diamond', diamond);
    exports.DiamondCross = _mk_model('DiamondCross', diamond_cross);
    exports.Hex = _mk_model('Hex', hex);
    exports.InvertedTriangle = _mk_model('InvertedTriangle', inverted_triangle);
    exports.Square = _mk_model('Square', square);
    exports.SquareCross = _mk_model('SquareCross', square_cross);
    exports.SquareX = _mk_model('SquareX', square_x);
    exports.Triangle = _mk_model('Triangle', triangle);
    exports.X = _mk_model('X', x);    
},
/*models/markers/marker*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var xy_glyph_1 = require(135    /* ../glyphs/xy_glyph */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var array_1 = require(21    /* core/util/array */);
    var MarkerView = function (_super) {
        tslib_1.__extends(MarkerView, _super);
        function MarkerView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MarkerView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, _size = _a._size, _angle = _a._angle;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + _size[i] + _angle[i]))
                    continue;
                var r = _size[i] / 2;
                ctx.beginPath();
                ctx.translate(sx[i], sy[i]);
                if (_angle[i])
                    ctx.rotate(_angle[i]);
                this._render_one(ctx, i, r, this.visuals.line, this.visuals.fill);
                if (_angle[i])
                    ctx.rotate(-_angle[i]);
                ctx.translate(-sx[i], -sy[i]);
            }
        };
        MarkerView.prototype._mask_data = function () {
            // dilate the inner screen region by max_size and map back to data space for use in
            // spatial query
            var hr = this.renderer.plot_view.frame.bbox.h_range;
            var sx0 = hr.start - this.max_size;
            var sx1 = hr.end + this.max_size;
            var _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
            var vr = this.renderer.plot_view.frame.bbox.v_range;
            var sy0 = vr.start - this.max_size;
            var sy1 = vr.end + this.max_size;
            var _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            return this.index.indices(bbox);
        };
        MarkerView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var sx0 = sx - this.max_size;
            var sx1 = sx + this.max_size;
            var _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
            var sy0 = sy - this.max_size;
            var sy1 = sy + this.max_size;
            var _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var candidates = this.index.indices(bbox);
            var hits = [];
            for (var _i = 0, candidates_1 = candidates; _i < candidates_1.length; _i++) {
                var i = candidates_1[_i];
                var s2 = this._size[i] / 2;
                var dist = Math.abs(this.sx[i] - sx) + Math.abs(this.sy[i] - sy);
                if (Math.abs(this.sx[i] - sx) <= s2 && Math.abs(this.sy[i] - sy) <= s2) {
                    hits.push([
                        i,
                        dist
                    ]);
                }
            }
            return hittest.create_hit_test_result_from_hits(hits);
        };
        MarkerView.prototype._hit_span = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var _a = this.bounds(), minX = _a.minX, minY = _a.minY, maxX = _a.maxX, maxY = _a.maxY;
            var result = hittest.create_empty_hit_test_result();
            var x0, x1;
            var y0, y1;
            if (geometry.direction == 'h') {
                y0 = minY;
                y1 = maxY;
                var ms = this.max_size / 2;
                var sx0 = sx - ms;
                var sx1 = sx + ms;
                _b = this.renderer.xscale.r_invert(sx0, sx1), x0 = _b[0], x1 = _b[1];
            } else {
                x0 = minX;
                x1 = maxX;
                var ms = this.max_size / 2;
                var sy0 = sy - ms;
                var sy1 = sy + ms;
                _c = this.renderer.yscale.r_invert(sy0, sy1), y0 = _c[0], y1 = _c[1];
            }
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var hits = this.index.indices(bbox);
            result.indices = hits;
            return result;
            var _b, _c;
        };
        MarkerView.prototype._hit_rect = function (geometry) {
            var sx0 = geometry.sx0, sx1 = geometry.sx1, sy0 = geometry.sy0, sy1 = geometry.sy1;
            var _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
            var _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var result = hittest.create_empty_hit_test_result();
            result.indices = this.index.indices(bbox);
            return result;
        };
        MarkerView.prototype._hit_poly = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            // TODO (bev) use spatial index to pare candidate list
            var candidates = array_1.range(0, this.sx.length);
            var hits = [];
            for (var i = 0, end = candidates.length; i < end; i++) {
                var idx = candidates[i];
                if (hittest.point_in_poly(this.sx[i], this.sy[i], sx, sy))
                    hits.push(idx);
            }
            var result = hittest.create_empty_hit_test_result();
            result.indices = hits;
            return result;
        };
        MarkerView.prototype.draw_legend_for_index = function (ctx, _a, index) {
            var x0 = _a.x0, x1 = _a.x1, y0 = _a.y0, y1 = _a.y1;
            // using objects like this seems a little wonky, since the keys are coerced to
            // stings, but it works
            var len = index + 1;
            var sx = new Array(len);
            sx[index] = (x0 + x1) / 2;
            var sy = new Array(len);
            sy[index] = (y0 + y1) / 2;
            var size = new Array(len);
            size[index] = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.4;
            var angle = new Array(len);
            angle[index] = this._angle[index];
            this._render(ctx, [index], {
                sx: sx,
                sy: sy,
                _size: size,
                _angle: angle
            });    // XXX
        };
        return MarkerView;
    }(xy_glyph_1.XYGlyphView);
    exports.MarkerView = MarkerView;
    var Marker = function (_super) {
        tslib_1.__extends(Marker, _super);
        function Marker(attrs) {
            return _super.call(this, attrs) || this;
        }
        Marker.initClass = function () {
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                size: [
                    p.DistanceSpec,
                    {
                        units: 'screen',
                        value: 4
                    }
                ],
                angle: [
                    p.AngleSpec,
                    0
                ]
            });
        };
        return Marker;
    }(xy_glyph_1.XYGlyph);
    exports.Marker = Marker;
    Marker.initClass();    
},
/*models/plots/gmap_plot*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var logging_1 = require(14    /* core/logging */);
    var gmap_plot_canvas_1 = require(159    /* ./gmap_plot_canvas */);
    var plot_1 = require(161    /* ./plot */);
    var p = require(15    /* core/properties */);
    var model_1 = require(53    /* ../../model */);
    var MapOptions = function (_super) {
        tslib_1.__extends(MapOptions, _super);
        function MapOptions(attrs) {
            return _super.call(this, attrs) || this;
        }
        MapOptions.initClass = function () {
            this.prototype.type = 'MapOptions';
            this.define({
                lat: [p.Number],
                lng: [p.Number],
                zoom: [
                    p.Number,
                    12
                ]
            });
        };
        return MapOptions;
    }(model_1.Model);
    exports.MapOptions = MapOptions;
    MapOptions.initClass();
    var GMapOptions = function (_super) {
        tslib_1.__extends(GMapOptions, _super);
        function GMapOptions(attrs) {
            return _super.call(this, attrs) || this;
        }
        GMapOptions.initClass = function () {
            this.prototype.type = 'GMapOptions';
            this.define({
                map_type: [
                    p.String,
                    'roadmap'
                ],
                scale_control: [
                    p.Bool,
                    false
                ],
                styles: [p.String]
            });
        };
        return GMapOptions;
    }(MapOptions);
    exports.GMapOptions = GMapOptions;
    GMapOptions.initClass();
    var GMapPlotView = function (_super) {
        tslib_1.__extends(GMapPlotView, _super);
        function GMapPlotView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return GMapPlotView;
    }(plot_1.PlotView);
    exports.GMapPlotView = GMapPlotView;
    var GMapPlot = function (_super) {
        tslib_1.__extends(GMapPlot, _super);
        function GMapPlot(attrs) {
            return _super.call(this, attrs) || this;
        }
        GMapPlot.initClass = function () {
            this.prototype.type = 'GMapPlot';
            this.prototype.default_view = GMapPlotView;
            // Set all the PlotCanvas properties as internal.
            // This seems to be necessary so that everything can initialize.
            // Feels very clumsy, but I'm not sure how the properties system wants
            // to handle something like this situation.
            this.define({
                map_options: [p.Instance],
                api_key: [p.String]
            });
        };
        GMapPlot.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            if (!this.api_key)
                logging_1.logger.error('api_key is required. See https://developers.google.com/maps/documentation/javascript/get-api-key for more information on how to obtain your own.');
        };
        GMapPlot.prototype._init_plot_canvas = function () {
            return new gmap_plot_canvas_1.GMapPlotCanvas({ plot: this });
        };
        return GMapPlot;
    }(plot_1.Plot);
    exports.GMapPlot = GMapPlot;
    GMapPlot.initClass();    
},
/*models/plots/gmap_plot_canvas*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var signaling_1 = require(19    /* core/signaling */);
    var projections_1 = require(33    /* core/util/projections */);
    var plot_canvas_1 = require(162    /* ./plot_canvas */);
    var gmaps_ready = new signaling_1.Signal0({}, 'gmaps_ready');
    var load_google_api = function (api_key) {
        _bokeh_gmaps_callback = function () {
            return gmaps_ready.emit();
        };
        var script = document.createElement('script');
        script.type = 'text/javascript';
        script.src = 'https://maps.googleapis.com/maps/api/js?key=' + api_key + '&callback=_bokeh_gmaps_callback';
        document.body.appendChild(script);
    };
    var GMapPlotCanvasView = function (_super) {
        tslib_1.__extends(GMapPlotCanvasView, _super);
        function GMapPlotCanvasView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        GMapPlotCanvasView.prototype.initialize = function (options) {
            var _this = this;
            this.pause();
            _super.prototype.initialize.call(this, options);
            this._tiles_loaded = false;
            this.zoom_count = 0;
            var _a = this.model.plot.map_options, zoom = _a.zoom, lat = _a.lat, lng = _a.lng;
            this.initial_zoom = zoom;
            this.initial_lat = lat;
            this.initial_lng = lng;
            this.canvas_view.map_el.style.position = 'absolute';
            if (typeof google === 'undefined' || google.maps == null) {
                if (typeof _bokeh_gmaps_callback === 'undefined') {
                    load_google_api(this.model.plot.api_key);
                }
                gmaps_ready.connect(function () {
                    return _this.request_render();
                });
            }
            this.unpause();
        };
        GMapPlotCanvasView.prototype.update_range = function (range_info) {
            // RESET -------------------------
            if (range_info == null) {
                this.map.setCenter({
                    lat: this.initial_lat,
                    lng: this.initial_lng
                });
                this.map.setOptions({ zoom: this.initial_zoom });
                _super.prototype.update_range.call(this, null);    // PAN ----------------------------
            } else if (range_info.sdx != null || range_info.sdy != null) {
                this.map.panBy(range_info.sdx || 0, range_info.sdy || 0);
                _super.prototype.update_range.call(this, range_info);    // ZOOM ---------------------------
            } else if (range_info.factor != null) {
                // The zoom count decreases the sensitivity of the zoom. (We could make this user configurable)
                var zoom_change = void 0;
                if (this.zoom_count !== 10) {
                    this.zoom_count += 1;
                    return;
                }
                this.zoom_count = 0;
                this.pause();
                _super.prototype.update_range.call(this, range_info);
                if (range_info.factor < 0)
                    zoom_change = -1;
                else
                    zoom_change = 1;
                var old_map_zoom = this.map.getZoom();
                var new_map_zoom = old_map_zoom + zoom_change;
                // Zooming out too far causes problems
                if (new_map_zoom >= 2) {
                    this.map.setZoom(new_map_zoom);
                    // Check we haven't gone out of bounds, and if we have undo the zoom
                    var _a = this._get_projected_bounds(), proj_xstart = _a[0], proj_xend = _a[1];
                    if (proj_xend - proj_xstart < 0) {
                        this.map.setZoom(old_map_zoom);
                    }
                }
                this.unpause();
            }
            // Finally re-center
            this._set_bokeh_ranges();
        };
        GMapPlotCanvasView.prototype._build_map = function () {
            var _this = this;
            var maps = google.maps;
            this.map_types = {
                satellite: maps.MapTypeId.SATELLITE,
                terrain: maps.MapTypeId.TERRAIN,
                roadmap: maps.MapTypeId.ROADMAP,
                hybrid: maps.MapTypeId.HYBRID
            };
            var mo = this.model.plot.map_options;
            var map_options = {
                center: new maps.LatLng(mo.lat, mo.lng),
                zoom: mo.zoom,
                disableDefaultUI: true,
                mapTypeId: this.map_types[mo.map_type],
                scaleControl: mo.scale_control
            };
            if (mo.styles != null)
                map_options.styles = JSON.parse(mo.styles);
            // create the map with above options in div
            this.map = new maps.Map(this.canvas_view.map_el, map_options);
            // update bokeh ranges whenever the map idles, which should be after most UI action
            maps.event.addListener(this.map, 'idle', function () {
                return _this._set_bokeh_ranges();
            });
            // also need an event when bounds change so that map resizes trigger renders too
            maps.event.addListener(this.map, 'bounds_changed', function () {
                return _this._set_bokeh_ranges();
            });
            maps.event.addListenerOnce(this.map, 'tilesloaded', function () {
                return _this._render_finished();
            });
            // wire up listeners so that changes to properties are reflected
            this.connect(this.model.plot.properties.map_options.change, function () {
                return _this._update_options();
            });
            this.connect(this.model.plot.map_options.properties.styles.change, function () {
                return _this._update_styles();
            });
            this.connect(this.model.plot.map_options.properties.lat.change, function () {
                return _this._update_center('lat');
            });
            this.connect(this.model.plot.map_options.properties.lng.change, function () {
                return _this._update_center('lng');
            });
            this.connect(this.model.plot.map_options.properties.zoom.change, function () {
                return _this._update_zoom();
            });
            this.connect(this.model.plot.map_options.properties.map_type.change, function () {
                return _this._update_map_type();
            });
            this.connect(this.model.plot.map_options.properties.scale_control.change, function () {
                return _this._update_scale_control();
            });
        };
        GMapPlotCanvasView.prototype._render_finished = function () {
            this._tiles_loaded = true;
            this.notify_finished();
        };
        GMapPlotCanvasView.prototype.has_finished = function () {
            return _super.prototype.has_finished.call(this) && this._tiles_loaded === true;
        };
        GMapPlotCanvasView.prototype._get_latlon_bounds = function () {
            var bounds = this.map.getBounds();
            var top_right = bounds.getNorthEast();
            var bottom_left = bounds.getSouthWest();
            var xstart = bottom_left.lng();
            var xend = top_right.lng();
            var ystart = bottom_left.lat();
            var yend = top_right.lat();
            return [
                xstart,
                xend,
                ystart,
                yend
            ];
        };
        GMapPlotCanvasView.prototype._get_projected_bounds = function () {
            var _a = this._get_latlon_bounds(), xstart = _a[0], xend = _a[1], ystart = _a[2], yend = _a[3];
            var _b = projections_1.wgs84_mercator.forward([
                    xstart,
                    ystart
                ]), proj_xstart = _b[0], proj_ystart = _b[1];
            var _c = projections_1.wgs84_mercator.forward([
                    xend,
                    yend
                ]), proj_xend = _c[0], proj_yend = _c[1];
            return [
                proj_xstart,
                proj_xend,
                proj_ystart,
                proj_yend
            ];
        };
        GMapPlotCanvasView.prototype._set_bokeh_ranges = function () {
            var _a = this._get_projected_bounds(), proj_xstart = _a[0], proj_xend = _a[1], proj_ystart = _a[2], proj_yend = _a[3];
            this.frame.x_range.setv({
                start: proj_xstart,
                end: proj_xend
            });
            this.frame.y_range.setv({
                start: proj_ystart,
                end: proj_yend
            });
        };
        GMapPlotCanvasView.prototype._update_center = function (fld) {
            var c = this.map.getCenter().toJSON();
            c[fld] = this.model.plot.map_options[fld];
            this.map.setCenter(c);
            this._set_bokeh_ranges();
        };
        GMapPlotCanvasView.prototype._update_map_type = function () {
            this.map.setOptions({ mapTypeId: this.map_types[this.model.plot.map_options.map_type] });
        };
        GMapPlotCanvasView.prototype._update_scale_control = function () {
            this.map.setOptions({ scaleControl: this.model.plot.map_options.scale_control });
        };
        GMapPlotCanvasView.prototype._update_options = function () {
            this._update_styles();
            this._update_center('lat');
            this._update_center('lng');
            this._update_zoom();
            this._update_map_type();
        };
        GMapPlotCanvasView.prototype._update_styles = function () {
            this.map.setOptions({ styles: JSON.parse(this.model.plot.map_options.styles) });
        };
        GMapPlotCanvasView.prototype._update_zoom = function () {
            this.map.setOptions({ zoom: this.model.plot.map_options.zoom });
            this._set_bokeh_ranges();
        };
        // this method is expected and called by PlotCanvasView.render
        GMapPlotCanvasView.prototype._map_hook = function (_ctx, frame_box) {
            var left = frame_box[0], top = frame_box[1], width = frame_box[2], height = frame_box[3];
            this.canvas_view.map_el.style.top = top + 'px';
            this.canvas_view.map_el.style.left = left + 'px';
            this.canvas_view.map_el.style.width = width + 'px';
            this.canvas_view.map_el.style.height = height + 'px';
            if (this.map == null && typeof google !== 'undefined' && google.maps != null)
                this._build_map();
        };
        // this overrides the standard _paint_empty to make the inner canvas transparent
        GMapPlotCanvasView.prototype._paint_empty = function (ctx, frame_box) {
            var ow = this.canvas._width.value;
            var oh = this.canvas._height.value;
            var left = frame_box[0], top = frame_box[1], iw = frame_box[2], ih = frame_box[3];
            ctx.clearRect(0, 0, ow, oh);
            ctx.beginPath();
            ctx.moveTo(0, 0);
            ctx.lineTo(0, oh);
            ctx.lineTo(ow, oh);
            ctx.lineTo(ow, 0);
            ctx.lineTo(0, 0);
            ctx.moveTo(left, top);
            ctx.lineTo(left + iw, top);
            ctx.lineTo(left + iw, top + ih);
            ctx.lineTo(left, top + ih);
            ctx.lineTo(left, top);
            ctx.closePath();
            ctx.fillStyle = this.model.plot.border_fill_color;
            ctx.fill();
        };
        return GMapPlotCanvasView;
    }(plot_canvas_1.PlotCanvasView);
    exports.GMapPlotCanvasView = GMapPlotCanvasView;
    var GMapPlotCanvas = function (_super) {
        tslib_1.__extends(GMapPlotCanvas, _super);
        function GMapPlotCanvas(attrs) {
            return _super.call(this, attrs) || this;
        }
        GMapPlotCanvas.initClass = function () {
            this.prototype.type = 'GMapPlotCanvas';
            this.prototype.default_view = GMapPlotCanvasView;
        };
        GMapPlotCanvas.prototype.initialize = function () {
            this.use_map = true;
            _super.prototype.initialize.call(this);
        };
        return GMapPlotCanvas;
    }(plot_canvas_1.PlotCanvas);
    exports.GMapPlotCanvas = GMapPlotCanvas;
    GMapPlotCanvas.initClass();    
},
/*models/plots/index*/
function _(require, module, exports) {
    var gmap_plot_1 = require(158    /* ./gmap_plot */);
    exports.MapOptions = gmap_plot_1.MapOptions;
    var gmap_plot_2 = require(158    /* ./gmap_plot */);
    exports.GMapOptions = gmap_plot_2.GMapOptions;
    var gmap_plot_3 = require(158    /* ./gmap_plot */);
    exports.GMapPlot = gmap_plot_3.GMapPlot;
    var gmap_plot_canvas_1 = require(159    /* ./gmap_plot_canvas */);
    exports.GMapPlotCanvas = gmap_plot_canvas_1.GMapPlotCanvas;
    var plot_1 = require(161    /* ./plot */);
    exports.Plot = plot_1.Plot;
    var plot_canvas_1 = require(162    /* ./plot_canvas */);
    exports.PlotCanvas = plot_canvas_1.PlotCanvas;    
},
/*models/plots/plot*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var solver_1 = require(13    /* core/layout/solver */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var signaling_1 = require(19    /* core/signaling */);
    var array_1 = require(21    /* core/util/array */);
    var object_1 = require(32    /* core/util/object */);
    var types_1 = require(44    /* core/util/types */);
    var layout_dom_1 = require(146    /* ../layouts/layout_dom */);
    var title_1 = require(68    /* ../annotations/title */);
    var linear_scale_1 = require(176    /* ../scales/linear_scale */);
    var toolbar_1 = require(248    /* ../tools/toolbar */);
    var toolbar_panel_1 = require(69    /* ../annotations/toolbar_panel */);
    var plot_canvas_1 = require(162    /* ./plot_canvas */);
    var column_data_source_1 = require(184    /* ../sources/column_data_source */);
    var glyph_renderer_1 = require(169    /* ../renderers/glyph_renderer */);
    var bokeh_events_1 = require(3    /* core/bokeh_events */);
    var PlotView = function (_super) {
        tslib_1.__extends(PlotView, _super);
        function PlotView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PlotView.prototype.connect_signals = function () {
            _super.prototype.connect_signals.call(this);
            // Note: Title object cannot be replaced after initialization, similar to axes, and also
            // not being able to change the sizing_mode. All of these changes require a re-initialization
            // of all constraints which we don't currently support.
            var title_msg = 'Title object cannot be replaced. Try changing properties on title to update it after initialization.';
            this.connect(this.model.properties.title.change, function () {
                return logging_1.logger.warn(title_msg);
            });
        };
        PlotView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-plot-layout');
        };
        PlotView.prototype.get_height = function () {
            return this.model._width.value / this.model.get_aspect_ratio();
        };
        PlotView.prototype.get_width = function () {
            return this.model._height.value * this.model.get_aspect_ratio();
        };
        PlotView.prototype.save = function (name) {
            this.plot_canvas_view.save(name);
        };
        Object.defineProperty(PlotView.prototype, 'plot_canvas_view', {
            get: function () {
                // XXX: PlotCanvasView is not LayoutDOMView
                return this.child_views[this.model.plot_canvas.id];
            },
            enumerable: true,
            configurable: true
        });
        return PlotView;
    }(layout_dom_1.LayoutDOMView);
    exports.PlotView = PlotView;
    var Plot = function (_super) {
        tslib_1.__extends(Plot, _super);
        function Plot(attrs) {
            return _super.call(this, attrs) || this;
        }
        Plot.initClass = function () {
            this.prototype.type = 'Plot';
            this.prototype.default_view = PlotView;
            this.mixins([
                'line:outline_',
                'fill:background_',
                'fill:border_'
            ]);
            this.define({
                toolbar: [
                    p.Instance,
                    function () {
                        return new toolbar_1.Toolbar();
                    }
                ],
                toolbar_location: [
                    p.Location,
                    'right'
                ],
                toolbar_sticky: [
                    p.Boolean,
                    true
                ],
                plot_width: [
                    p.Number,
                    600
                ],
                plot_height: [
                    p.Number,
                    600
                ],
                title: [
                    p.Any,
                    function () {
                        return new title_1.Title({ text: '' });
                    }
                ],
                title_location: [
                    p.Location,
                    'above'
                ],
                h_symmetry: [
                    p.Bool,
                    true
                ],
                v_symmetry: [
                    p.Bool,
                    false
                ],
                above: [
                    p.Array,
                    []
                ],
                below: [
                    p.Array,
                    []
                ],
                left: [
                    p.Array,
                    []
                ],
                right: [
                    p.Array,
                    []
                ],
                renderers: [
                    p.Array,
                    []
                ],
                x_range: [p.Instance],
                extra_x_ranges: [
                    p.Any,
                    {}
                ],
                y_range: [p.Instance],
                extra_y_ranges: [
                    p.Any,
                    {}
                ],
                x_scale: [
                    p.Instance,
                    function () {
                        return new linear_scale_1.LinearScale();
                    }
                ],
                y_scale: [
                    p.Instance,
                    function () {
                        return new linear_scale_1.LinearScale();
                    }
                ],
                lod_factor: [
                    p.Number,
                    10
                ],
                lod_interval: [
                    p.Number,
                    300
                ],
                lod_threshold: [
                    p.Number,
                    2000
                ],
                lod_timeout: [
                    p.Number,
                    500
                ],
                hidpi: [
                    p.Bool,
                    true
                ],
                output_backend: [
                    p.OutputBackend,
                    'canvas'
                ],
                min_border: [
                    p.Number,
                    5
                ],
                min_border_top: [
                    p.Number,
                    null
                ],
                min_border_left: [
                    p.Number,
                    null
                ],
                min_border_bottom: [
                    p.Number,
                    null
                ],
                min_border_right: [
                    p.Number,
                    null
                ],
                inner_width: [p.Number],
                inner_height: [p.Number],
                layout_width: [p.Number],
                layout_height: [p.Number],
                match_aspect: [
                    p.Bool,
                    false
                ],
                aspect_scale: [
                    p.Number,
                    1
                ]
            });
            this.override({
                outline_line_color: '#e5e5e5',
                border_fill_color: '#ffffff',
                background_fill_color: '#ffffff'
            });
            bokeh_events_1.register_with_event(bokeh_events_1.UIEvent, this);
        };
        Plot.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.reset = new signaling_1.Signal0(this, 'reset');
            for (var _i = 0, _a = object_1.values(this.extra_x_ranges).concat(this.x_range); _i < _a.length; _i++) {
                var xr = _a[_i];
                var plots = xr.plots;
                if (types_1.isArray(plots)) {
                    plots = plots.concat(this);
                    xr.setv({ plots: plots }, { silent: true });
                }
            }
            for (var _b = 0, _c = object_1.values(this.extra_y_ranges).concat(this.y_range); _b < _c.length; _b++) {
                var yr = _c[_b];
                var plots = yr.plots;
                if (types_1.isArray(plots)) {
                    plots = plots.concat(this);
                    yr.setv({ plots: plots }, { silent: true });
                }
            }
            // Min border applies to the edge of everything
            if (this.min_border != null) {
                if (this.min_border_top == null)
                    this.min_border_top = this.min_border;
                if (this.min_border_bottom == null)
                    this.min_border_bottom = this.min_border;
                if (this.min_border_left == null)
                    this.min_border_left = this.min_border;
                if (this.min_border_right == null)
                    this.min_border_right = this.min_border;
            }
            // Setup side renderers
            for (var _d = 0, _e = [
                        'above',
                        'below',
                        'left',
                        'right'
                    ]; _d < _e.length; _d++) {
                var side = _e[_d];
                var layout_renderers = this.getv(side);
                for (var _f = 0, layout_renderers_1 = layout_renderers; _f < layout_renderers_1.length; _f++) {
                    var renderer = layout_renderers_1[_f];
                    renderer.add_panel(side);
                }
            }
            this._init_title_panel();
            this._init_toolbar_panel();
            this._plot_canvas = this._init_plot_canvas();
            this.plot_canvas.toolbar = this.toolbar;
            // Set width & height to be the passed in plot_width and plot_height
            // We may need to be more subtle about this - not sure why people use one
            // or the other.
            if (this.width == null)
                this.width = this.plot_width;
            if (this.height == null)
                this.height = this.plot_height;
        };
        Plot.prototype._init_plot_canvas = function () {
            return new plot_canvas_1.PlotCanvas({ plot: this });
        };
        Plot.prototype._init_title_panel = function () {
            if (this.title != null) {
                var title = types_1.isString(this.title) ? new title_1.Title({ text: this.title }) : this.title;
                this.add_layout(title, this.title_location);
            }
        };
        Plot.prototype._init_toolbar_panel = function () {
            var _this = this;
            var tpanel = array_1.find(this.renderers, function (model) {
                return model instanceof toolbar_panel_1.ToolbarPanel && array_1.includes(model.tags, _this.id);
            });
            if (tpanel != null)
                this.remove_layout(tpanel);
            switch (this.toolbar_location) {
            case 'left':
            case 'right':
            case 'above':
            case 'below': {
                    tpanel = new toolbar_panel_1.ToolbarPanel({
                        toolbar: this.toolbar,
                        tags: [this.id]
                    });
                    this.toolbar.toolbar_location = this.toolbar_location;
                    if (this.toolbar_sticky) {
                        var models = this.getv(this.toolbar_location);
                        var title = array_1.find(models, function (model) {
                            return model instanceof title_1.Title;
                        });
                        if (title != null) {
                            tpanel.set_panel(title.panel);
                            // XXX, XXX: because find() doesn't provide narrowed types
                            this.add_renderers(tpanel);
                            return;
                        }
                    }
                    this.add_layout(tpanel, this.toolbar_location);
                    break;
                }
            }
        };
        Plot.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.properties.toolbar_location.change, function () {
                return _this._init_toolbar_panel();
            });
        };
        Object.defineProperty(Plot.prototype, 'plot_canvas', {
            get: function () {
                return this._plot_canvas;
            },
            enumerable: true,
            configurable: true
        });
        Plot.prototype._doc_attached = function () {
            this.plot_canvas.attach_document(this.document);
            // XXX!
            _super.prototype._doc_attached.call(this);
        };
        Plot.prototype.add_renderers = function () {
            var new_renderers = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                new_renderers[_i] = arguments[_i];
            }
            var renderers = this.renderers;
            renderers = renderers.concat(new_renderers);
            this.renderers = renderers;
        };
        Plot.prototype.add_layout = function (renderer, side) {
            if (side === void 0) {
                side = 'center';
            }
            if (renderer.props.plot != null)
                renderer.plot = this;
            // XXX
            if (side != 'center') {
                var side_renderers = this.getv(side);
                side_renderers.push(renderer);
                renderer.add_panel(side);    // XXX
            }
            this.add_renderers(renderer);
        };
        Plot.prototype.remove_layout = function (renderer) {
            var del = function (items) {
                array_1.removeBy(items, function (item) {
                    return item == renderer;
                });
            };
            del(this.left);
            del(this.right);
            del(this.above);
            del(this.below);
            del(this.renderers);
        };
        Plot.prototype.add_glyph = function (glyph, source, extra_attrs) {
            if (source === void 0) {
                source = new column_data_source_1.ColumnDataSource();
            }
            if (extra_attrs === void 0) {
                extra_attrs = {};
            }
            var attrs = object_1.extend({}, extra_attrs, {
                data_source: source,
                glyph: glyph
            });
            var renderer = new glyph_renderer_1.GlyphRenderer(attrs);
            this.add_renderers(renderer);
            return renderer;
        };
        Plot.prototype.add_tools = function () {
            var tools = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                tools[_i] = arguments[_i];
            }
            for (var _a = 0, tools_1 = tools; _a < tools_1.length; _a++) {
                var tool = tools_1[_a];
                if (tool.overlay != null)
                    // XXX
                    this.add_renderers(tool.overlay);
            }
            this.toolbar.tools = this.toolbar.tools.concat(tools);
        };
        Plot.prototype.get_layoutable_children = function () {
            return [this.plot_canvas];
        };
        Plot.prototype.get_constraints = function () {
            var constraints = _super.prototype.get_constraints.call(this);
            constraints.push(solver_1.EQ(this._width, [
                -1,
                this.plot_canvas._width
            ]));
            constraints.push(solver_1.EQ(this._height, [
                -1,
                this.plot_canvas._height
            ]));
            return constraints;
        };
        Plot.prototype.get_constrained_variables = function () {
            var vars = object_1.extend({}, _super.prototype.get_constrained_variables.call(this), {
                on_edge_align_top: this.plot_canvas._top,
                on_edge_align_bottom: this.plot_canvas._height_minus_bottom,
                on_edge_align_left: this.plot_canvas._left,
                on_edge_align_right: this.plot_canvas._width_minus_right,
                box_cell_align_top: this.plot_canvas._top,
                box_cell_align_bottom: this.plot_canvas._height_minus_bottom,
                box_cell_align_left: this.plot_canvas._left,
                box_cell_align_right: this.plot_canvas._width_minus_right,
                box_equal_size_top: this.plot_canvas._top,
                box_equal_size_bottom: this.plot_canvas._height_minus_bottom
            });
            if (this.sizing_mode != 'fixed') {
                vars.box_equal_size_left = this.plot_canvas._left;
                vars.box_equal_size_right = this.plot_canvas._width_minus_right;
            }
            return vars;
        };
        Object.defineProperty(Plot.prototype, 'all_renderers', {
            get: function () {
                var renderers = this.renderers;
                for (var _i = 0, _a = this.toolbar.tools; _i < _a.length; _i++) {
                    var tool = _a[_i];
                    renderers = renderers.concat(tool.synthetic_renderers);
                }
                return renderers;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Plot.prototype, 'webgl', {
            get: function () {
                logging_1.logger.warn('webgl attr is deprecated, use output_backend');
                return this.output_backend == 'webgl';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Plot.prototype, 'tool_events', {
            get: function () {
                logging_1.logger.warn('tool_events attr is deprecated, use SelectionGeometry Event');
                return null;
            },
            enumerable: true,
            configurable: true
        });
        return Plot;
    }(layout_dom_1.LayoutDOM);
    exports.Plot = Plot;
    Plot.initClass();    
},
/*models/plots/plot_canvas*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var canvas_1 = require(84    /* ../canvas/canvas */);
    var cartesian_frame_1 = require(85    /* ../canvas/cartesian_frame */);
    var data_range1d_1 = require(164    /* ../ranges/data_range1d */);
    var glyph_renderer_1 = require(169    /* ../renderers/glyph_renderer */);
    var layout_dom_1 = require(146    /* ../layouts/layout_dom */);
    var bokeh_events_1 = require(3    /* core/bokeh_events */);
    var signaling_1 = require(19    /* core/signaling */);
    var build_views_1 = require(4    /* core/build_views */);
    var ui_events_1 = require(20    /* core/ui_events */);
    var visuals_1 = require(49    /* core/visuals */);
    var dom_view_1 = require(6    /* core/dom_view */);
    var layout_canvas_1 = require(11    /* core/layout/layout_canvas */);
    var alignments_1 = require(10    /* core/layout/alignments */);
    var solver_1 = require(13    /* core/layout/solver */);
    var logging_1 = require(14    /* core/logging */);
    var enums = require(7    /* core/enums */);
    var p = require(15    /* core/properties */);
    var throttle_1 = require(42    /* core/util/throttle */);
    var types_1 = require(44    /* core/util/types */);
    var array_1 = require(21    /* core/util/array */);
    var object_1 = require(32    /* core/util/object */);
    var side_panel_1 = require(12    /* core/layout/side_panel */);
    var global_gl = null;
    var PlotCanvasView = function (_super) {
        tslib_1.__extends(PlotCanvasView, _super);
        function PlotCanvasView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(PlotCanvasView.prototype, 'frame', {
            // compat, to be removed
            get: function () {
                return this.model.frame;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PlotCanvasView.prototype, 'canvas', {
            get: function () {
                return this.model.canvas;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PlotCanvasView.prototype, 'canvas_overlays', {
            get: function () {
                return this.canvas_view.overlays_el;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PlotCanvasView.prototype, 'canvas_events', {
            get: function () {
                return this.canvas_view.events_el;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PlotCanvasView.prototype, 'is_paused', {
            get: function () {
                return this._is_paused != null && this._is_paused !== 0;
            },
            enumerable: true,
            configurable: true
        });
        PlotCanvasView.prototype.view_options = function () {
            return {
                plot_view: this,
                parent: this
            };
        };
        PlotCanvasView.prototype.pause = function () {
            if (this._is_paused == null)
                this._is_paused = 1;
            else
                this._is_paused += 1;
        };
        PlotCanvasView.prototype.unpause = function (no_render) {
            if (no_render === void 0) {
                no_render = false;
            }
            if (this._is_paused == null)
                throw new Error('wasn\'t paused');
            this._is_paused -= 1;
            if (this._is_paused == 0 && !no_render)
                this.request_render();
        };
        PlotCanvasView.prototype.request_render = function () {
            this.request_paint();
        };
        PlotCanvasView.prototype.request_paint = function () {
            if (!this.is_paused)
                this.throttled_paint();
        };
        PlotCanvasView.prototype.reset = function () {
            this.clear_state();
            this.reset_range();
            this.reset_selection();
            this.model.plot.trigger_event(new bokeh_events_1.Reset());
        };
        PlotCanvasView.prototype.remove = function () {
            build_views_1.remove_views(this.renderer_views);
            build_views_1.remove_views(this.tool_views);
            this.canvas_view.remove();
            _super.prototype.remove.call(this);
        };
        PlotCanvasView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-plot-wrapper');
        };
        PlotCanvasView.prototype.initialize = function (options) {
            var _this = this;
            this.pause();
            _super.prototype.initialize.call(this, options);
            this.force_paint = new signaling_1.Signal0(this, 'force_paint');
            this.state_changed = new signaling_1.Signal0(this, 'state_changed');
            this.lod_started = false;
            this.visuals = new visuals_1.Visuals(this.model.plot);
            // XXX
            this._initial_state_info = {
                selection: {},
                dimensions: {
                    width: this.model.canvas._width.value,
                    height: this.model.canvas._height.value
                }
            };
            this.state = {
                history: [],
                index: -1
            };
            this.canvas_view = new this.canvas.default_view({
                model: this.canvas,
                parent: this
            });
            this.el.appendChild(this.canvas_view.el);
            this.canvas_view.render();
            // If requested, try enabling webgl
            if (this.model.plot.output_backend == 'webgl')
                this.init_webgl();
            this.throttled_paint = throttle_1.throttle(function () {
                return _this.force_paint.emit();
            }, 15);
            // TODO (bev) configurable
            this.ui_event_bus = new ui_events_1.UIEvents(this, this.model.toolbar, this.canvas_view.events_el, this.model.plot);
            this.levels = {};
            for (var _i = 0, _a = enums.RenderLevel; _i < _a.length; _i++) {
                var level = _a[_i];
                this.levels[level] = {};
            }
            this.renderer_views = {};
            this.tool_views = {};
            this.build_levels();
            this.build_tools();
            this.update_dataranges();
            this.unpause(true);
            logging_1.logger.debug('PlotView initialized');
        };
        PlotCanvasView.prototype.set_cursor = function (cursor) {
            if (cursor === void 0) {
                cursor = 'default';
            }
            this.canvas_view.el.style.cursor = cursor;
        };
        PlotCanvasView.prototype.init_webgl = function () {
            // We use a global invisible canvas and gl context. By having a global context,
            // we avoid the limitation of max 16 contexts that most browsers have.
            if (global_gl == null) {
                var canvas = document.createElement('canvas');
                var opts = { premultipliedAlpha: true };
                var ctx = canvas.getContext('webgl', opts) || canvas.getContext('experimental-webgl', opts);
                // If WebGL is available, we store a reference to the gl canvas on
                // the ctx object, because that's what gets passed everywhere.
                if (ctx != null)
                    global_gl = {
                        canvas: canvas,
                        ctx: ctx
                    };
            }
            if (global_gl != null)
                this.gl = global_gl;
            else
                logging_1.logger.warn('WebGL is not supported, falling back to 2D canvas.');
        };
        PlotCanvasView.prototype.prepare_webgl = function (ratio, frame_box) {
            // Prepare WebGL for a drawing pass
            if (this.gl != null) {
                var canvas = this.canvas_view.get_canvas_element();
                // Sync canvas size
                this.gl.canvas.width = canvas.width;
                this.gl.canvas.height = canvas.height;
                // Prepare GL for drawing
                var gl = this.gl.ctx;
                gl.viewport(0, 0, this.gl.canvas.width, this.gl.canvas.height);
                gl.clearColor(0, 0, 0, 0);
                gl.clear(gl.COLOR_BUFFER_BIT || gl.DEPTH_BUFFER_BIT);
                // Clipping
                gl.enable(gl.SCISSOR_TEST);
                var sx = frame_box[0], sy = frame_box[1], w = frame_box[2], h = frame_box[3];
                var _a = this.model.canvas, xview = _a.xview, yview = _a.yview;
                var vx = xview.compute(sx);
                var vy = yview.compute(sy + h);
                gl.scissor(ratio * vx, ratio * vy, ratio * w, ratio * h);
                // lower left corner, width, height
                // Setup blending
                gl.enable(gl.BLEND);
                gl.blendFuncSeparate(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA, gl.ONE_MINUS_DST_ALPHA, gl.ONE);    // premultipliedAlpha == true
            }
        };
        //gl.blendFuncSeparate(gl.ONE_MINUS_DST_ALPHA, gl.DST_ALPHA, gl.ONE_MINUS_DST_ALPHA, gl.ONE)  # Without premultipliedAlpha == false
        PlotCanvasView.prototype.blit_webgl = function (ratio) {
            // This should be called when the ctx has no state except the HIDPI transform
            var ctx = this.canvas_view.ctx;
            if (this.gl != null) {
                // Blit gl canvas into the 2D canvas. To do 1-on-1 blitting, we need
                // to remove the hidpi transform, then blit, then restore.
                // ctx.globalCompositeOperation = "source-over"  -> OK; is the default
                logging_1.logger.debug('drawing with WebGL');
                ctx.restore();
                ctx.drawImage(this.gl.canvas, 0, 0);
                // Set back hidpi transform
                ctx.save();
                ctx.scale(ratio, ratio);
                ctx.translate(0.5, 0.5);
            }
        };
        PlotCanvasView.prototype.update_dataranges = function () {
            // Update any DataRange1ds here
            var frame = this.model.frame;
            var bounds = {};
            var log_bounds = {};
            var calculate_log_bounds = false;
            for (var _i = 0, _a = object_1.values(frame.x_ranges).concat(object_1.values(frame.y_ranges)); _i < _a.length; _i++) {
                var r_1 = _a[_i];
                if (r_1 instanceof data_range1d_1.DataRange1d) {
                    if (r_1.scale_hint == 'log')
                        calculate_log_bounds = true;
                }
            }
            for (var id in this.renderer_views) {
                var view = this.renderer_views[id];
                if (view instanceof glyph_renderer_1.GlyphRendererView) {
                    var bds = view.glyph.bounds();
                    if (bds != null)
                        bounds[id] = bds;
                    if (calculate_log_bounds) {
                        var log_bds = view.glyph.log_bounds();
                        if (log_bds != null)
                            log_bounds[id] = log_bds;
                    }
                }
            }
            var follow_enabled = false;
            var has_bounds = false;
            var r;
            if (this.model.plot.match_aspect !== false && this.frame._width.value != 0 && this.frame._height.value != 0)
                r = 1 / this.model.plot.aspect_scale * (this.frame._width.value / this.frame._height.value);
            for (var _b = 0, _c = object_1.values(frame.x_ranges); _b < _c.length; _b++) {
                var xr = _c[_b];
                if (xr instanceof data_range1d_1.DataRange1d) {
                    var bounds_to_use = xr.scale_hint == 'log' ? log_bounds : bounds;
                    xr.update(bounds_to_use, 0, this.model.id, r);
                    if (xr.follow) {
                        follow_enabled = true;
                    }
                }
                if (xr.bounds != null)
                    has_bounds = true;
            }
            for (var _d = 0, _e = object_1.values(frame.y_ranges); _d < _e.length; _d++) {
                var yr = _e[_d];
                if (yr instanceof data_range1d_1.DataRange1d) {
                    var bounds_to_use = yr.scale_hint == 'log' ? log_bounds : bounds;
                    yr.update(bounds_to_use, 1, this.model.id, r);
                    if (yr.follow) {
                        follow_enabled = true;
                    }
                }
                if (yr.bounds != null)
                    has_bounds = true;
            }
            if (follow_enabled && has_bounds) {
                logging_1.logger.warn('Follow enabled so bounds are unset.');
                for (var _f = 0, _g = object_1.values(frame.x_ranges); _f < _g.length; _f++) {
                    var xr = _g[_f];
                    xr.bounds = null;
                }
                for (var _h = 0, _j = object_1.values(frame.y_ranges); _h < _j.length; _h++) {
                    var yr = _j[_h];
                    yr.bounds = null;
                }
            }
            this.range_update_timestamp = Date.now();
        };
        PlotCanvasView.prototype.map_to_screen = function (x, y, x_name, y_name) {
            if (x_name === void 0) {
                x_name = 'default';
            }
            if (y_name === void 0) {
                y_name = 'default';
            }
            return this.frame.map_to_screen(x, y, x_name, y_name);
        };
        PlotCanvasView.prototype.push_state = function (type, new_info) {
            var _a = this.state, history = _a.history, index = _a.index;
            var prev_info = history[index] != null ? history[index].info : {};
            var info = object_1.extend({}, this._initial_state_info, prev_info, new_info);
            this.state.history = this.state.history.slice(0, this.state.index + 1);
            this.state.history.push({
                type: type,
                info: info
            });
            this.state.index = this.state.history.length - 1;
            this.state_changed.emit();
        };
        PlotCanvasView.prototype.clear_state = function () {
            this.state = {
                history: [],
                index: -1
            };
            this.state_changed.emit();
        };
        PlotCanvasView.prototype.can_undo = function () {
            this.state.index >= 0;
        };
        PlotCanvasView.prototype.can_redo = function () {
            this.state.index < this.state.history.length - 1;
        };
        PlotCanvasView.prototype.undo = function () {
            if (this.can_undo()) {
                this.state.index -= 1;
                this._do_state_change(this.state.index);
                this.state_changed.emit();
            }
        };
        PlotCanvasView.prototype.redo = function () {
            if (this.can_redo()) {
                this.state.index += 1;
                this._do_state_change(this.state.index);
                this.state_changed.emit();
            }
        };
        PlotCanvasView.prototype._do_state_change = function (index) {
            var info = this.state.history[index] != null ? this.state.history[index].info : this._initial_state_info;
            if (info.range != null)
                this.update_range(info.range);
            if (info.selection != null)
                this.update_selection(info.selection);
        };
        PlotCanvasView.prototype.get_selection = function () {
            var selection = {};
            for (var _i = 0, _a = this.model.plot.renderers; _i < _a.length; _i++) {
                var renderer = _a[_i];
                if (renderer instanceof glyph_renderer_1.GlyphRenderer) {
                    var selected = renderer.data_source.selected;
                    selection[renderer.id] = selected;
                }
            }
            return selection;
        };
        PlotCanvasView.prototype.update_selection = function (selection) {
            for (var _i = 0, _a = this.model.plot.renderers; _i < _a.length; _i++) {
                var renderer = _a[_i];
                if (!(renderer instanceof glyph_renderer_1.GlyphRenderer))
                    continue;
                var ds = renderer.data_source;
                if (selection != null) {
                    if (selection[renderer.id] != null)
                        ds.selected = selection[renderer.id];
                } else
                    ds.selection_manager.clear();
            }
        };
        PlotCanvasView.prototype.reset_selection = function () {
            this.update_selection(null);
        };
        PlotCanvasView.prototype._update_ranges_together = function (range_info_iter) {
            // Get weight needed to scale the diff of the range to honor interval limits
            var weight = 1;
            for (var _i = 0, range_info_iter_1 = range_info_iter; _i < range_info_iter_1.length; _i++) {
                var _a = range_info_iter_1[_i], rng = _a[0], range_info = _a[1];
                weight = Math.min(weight, this._get_weight_to_constrain_interval(rng, range_info));
            }
            // Apply shared weight to all ranges
            if (weight < 1) {
                for (var _b = 0, range_info_iter_2 = range_info_iter; _b < range_info_iter_2.length; _b++) {
                    var _c = range_info_iter_2[_b], rng = _c[0], range_info = _c[1];
                    range_info.start = weight * range_info.start + (1 - weight) * rng.start;
                    range_info.end = weight * range_info.end + (1 - weight) * rng.end;
                }
            }
        };
        PlotCanvasView.prototype._update_ranges_individually = function (range_info_iter, is_panning, is_scrolling, maintain_focus) {
            var hit_bound = false;
            for (var _i = 0, range_info_iter_3 = range_info_iter; _i < range_info_iter_3.length; _i++) {
                var _a = range_info_iter_3[_i], rng = _a[0], range_info = _a[1];
                // Is this a reversed range?
                var is_reversed = rng.start > rng.end;
                // Limit range interval first. Note that for scroll events,
                // the interval has already been limited for all ranges simultaneously
                if (!is_scrolling) {
                    var weight = this._get_weight_to_constrain_interval(rng, range_info);
                    if (weight < 1) {
                        range_info.start = weight * range_info.start + (1 - weight) * rng.start;
                        range_info.end = weight * range_info.end + (1 - weight) * rng.end;
                    }
                }
                // Prevent range from going outside limits
                // Also ensure that range keeps the same delta when panning/scrolling
                if (rng.bounds != null && rng.bounds != 'auto') {
                    // check `auto` for type-checking purpose
                    var _b = rng.bounds, min = _b[0], max = _b[1];
                    var new_interval = Math.abs(range_info.end - range_info.start);
                    if (is_reversed) {
                        if (min != null) {
                            if (min >= range_info.end) {
                                hit_bound = true;
                                range_info.end = min;
                                if (is_panning || is_scrolling) {
                                    range_info.start = min + new_interval;
                                }
                            }
                        }
                        if (max != null) {
                            if (max <= range_info.start) {
                                hit_bound = true;
                                range_info.start = max;
                                if (is_panning || is_scrolling) {
                                    range_info.end = max - new_interval;
                                }
                            }
                        }
                    } else {
                        if (min != null) {
                            if (min >= range_info.start) {
                                hit_bound = true;
                                range_info.start = min;
                                if (is_panning || is_scrolling) {
                                    range_info.end = min + new_interval;
                                }
                            }
                        }
                        if (max != null) {
                            if (max <= range_info.end) {
                                hit_bound = true;
                                range_info.end = max;
                                if (is_panning || is_scrolling) {
                                    range_info.start = max - new_interval;
                                }
                            }
                        }
                    }
                }
            }
            // Cancel the event when hitting a bound while scrolling. This ensures that
            // the scroll-zoom tool maintains its focus position. Setting `maintain_focus`
            // to false results in a more "gliding" behavior, allowing one to
            // zoom out more smoothly, at the cost of losing the focus position.
            if (is_scrolling && hit_bound && maintain_focus)
                return;
            for (var _c = 0, range_info_iter_4 = range_info_iter; _c < range_info_iter_4.length; _c++) {
                var _d = range_info_iter_4[_c], rng = _d[0], range_info = _d[1];
                rng.have_updated_interactively = true;
                if (rng.start != range_info.start || rng.end != range_info.end)
                    rng.setv(range_info);
            }
        };
        PlotCanvasView.prototype._get_weight_to_constrain_interval = function (rng, range_info) {
            // Get the weight by which a range-update can be applied
            // to still honor the interval limits (including the implicit
            // max interval imposed by the bounds)
            var min_interval = rng.min_interval;
            var max_interval = rng.max_interval;
            // Express bounds as a max_interval. By doing this, the application of
            // bounds and interval limits can be applied independent from each-other.
            if (rng.bounds != null && rng.bounds != 'auto') {
                // check `auto` for type-checking purpose
                var _a = rng.bounds, min = _a[0], max = _a[1];
                if (min != null && max != null) {
                    var max_interval2 = Math.abs(max - min);
                    max_interval = max_interval != null ? Math.min(max_interval, max_interval2) : max_interval2;
                }
            }
            var weight = 1;
            if (min_interval != null || max_interval != null) {
                var old_interval = Math.abs(rng.end - rng.start);
                var new_interval = Math.abs(range_info.end - range_info.start);
                if (min_interval > 0 && new_interval < min_interval) {
                    weight = (old_interval - min_interval) / (old_interval - new_interval);
                }
                if (max_interval > 0 && new_interval > max_interval) {
                    weight = (max_interval - old_interval) / (new_interval - old_interval);
                }
                weight = Math.max(0, Math.min(1, weight));
            }
            return weight;
        };
        PlotCanvasView.prototype.update_range = function (range_info, is_panning, is_scrolling, maintain_focus) {
            if (is_panning === void 0) {
                is_panning = false;
            }
            if (is_scrolling === void 0) {
                is_scrolling = false;
            }
            if (maintain_focus === void 0) {
                maintain_focus = true;
            }
            this.pause();
            var _a = this.frame, x_ranges = _a.x_ranges, y_ranges = _a.y_ranges;
            if (range_info == null) {
                for (var name_1 in x_ranges) {
                    var rng = x_ranges[name_1];
                    rng.reset();
                }
                for (var name_2 in y_ranges) {
                    var rng = y_ranges[name_2];
                    rng.reset();
                }
                this.update_dataranges();
            } else {
                var range_info_iter = [];
                for (var name_3 in x_ranges) {
                    var rng = x_ranges[name_3];
                    range_info_iter.push([
                        rng,
                        range_info.xrs[name_3]
                    ]);
                }
                for (var name_4 in y_ranges) {
                    var rng = y_ranges[name_4];
                    range_info_iter.push([
                        rng,
                        range_info.yrs[name_4]
                    ]);
                }
                if (is_scrolling) {
                    this._update_ranges_together(range_info_iter);    // apply interval bounds while keeping aspect
                }
                this._update_ranges_individually(range_info_iter, is_panning, is_scrolling, maintain_focus);
            }
            this.unpause();
        };
        PlotCanvasView.prototype.reset_range = function () {
            this.update_range(null);
        };
        PlotCanvasView.prototype.build_levels = function () {
            var renderer_models = this.model.plot.all_renderers;
            // should only bind events on NEW views
            var old_renderers = object_1.keys(this.renderer_views);
            var new_renderer_views = build_views_1.build_views(this.renderer_views, renderer_models, this.view_options());
            var renderers_to_remove = array_1.difference(old_renderers, renderer_models.map(function (model) {
                return model.id;
            }));
            for (var level in this.levels) {
                for (var _i = 0, renderers_to_remove_1 = renderers_to_remove; _i < renderers_to_remove_1.length; _i++) {
                    var id = renderers_to_remove_1[_i];
                    delete this.levels[level][id];
                }
            }
            for (var _a = 0, new_renderer_views_1 = new_renderer_views; _a < new_renderer_views_1.length; _a++) {
                var view = new_renderer_views_1[_a];
                this.levels[view.model.level][view.model.id] = view;
            }
        };
        PlotCanvasView.prototype.get_renderer_views = function () {
            var _this = this;
            return this.model.plot.renderers.map(function (r) {
                return _this.levels[r.level][r.id];
            });
        };
        PlotCanvasView.prototype.build_tools = function () {
            var _this = this;
            var tool_models = this.model.plot.toolbar.tools;
            var new_tool_views = build_views_1.build_views(this.tool_views, tool_models, this.view_options());
            new_tool_views.map(function (tool_view) {
                return _this.ui_event_bus.register_tool(tool_view);
            });
        };
        PlotCanvasView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.force_paint, function () {
                return _this.repaint();
            });
            var _a = this.model.frame, x_ranges = _a.x_ranges, y_ranges = _a.y_ranges;
            for (var name_5 in x_ranges) {
                var rng = x_ranges[name_5];
                this.connect(rng.change, function () {
                    return _this.request_render();
                });
            }
            for (var name_6 in y_ranges) {
                var rng = y_ranges[name_6];
                this.connect(rng.change, function () {
                    return _this.request_render();
                });
            }
            this.connect(this.model.plot.properties.renderers.change, function () {
                return _this.build_levels();
            });
            this.connect(this.model.plot.toolbar.properties.tools.change, function () {
                _this.build_levels();
                _this.build_tools();
            });
            this.connect(this.model.plot.change, function () {
                return _this.request_render();
            });
            this.connect(this.model.plot.reset, function () {
                return _this.reset();
            });
        };
        PlotCanvasView.prototype.set_initial_range = function () {
            // check for good values for ranges before setting initial range
            var good_vals = true;
            var _a = this.frame, x_ranges = _a.x_ranges, y_ranges = _a.y_ranges;
            var xrs = {};
            var yrs = {};
            for (var name_7 in x_ranges) {
                var _b = x_ranges[name_7], start = _b.start, end = _b.end;
                if (start == null || end == null || types_1.isStrictNaN(start + end)) {
                    good_vals = false;
                    break;
                }
                xrs[name_7] = {
                    start: start,
                    end: end
                };
            }
            if (good_vals) {
                for (var name_8 in y_ranges) {
                    var _c = y_ranges[name_8], start = _c.start, end = _c.end;
                    if (start == null || end == null || types_1.isStrictNaN(start + end)) {
                        good_vals = false;
                        break;
                    }
                    yrs[name_8] = {
                        start: start,
                        end: end
                    };
                }
            }
            if (good_vals) {
                this._initial_state_info.range = {
                    xrs: xrs,
                    yrs: yrs
                };
                logging_1.logger.debug('initial ranges set');
            } else
                logging_1.logger.warn('could not set initial ranges');
        };
        PlotCanvasView.prototype.update_constraints = function () {
            this.solver.suggest_value(this.frame._width, this.canvas._width.value);
            this.solver.suggest_value(this.frame._height, this.canvas._height.value);
            for (var id in this.renderer_views) {
                var view = this.renderer_views[id];
                if (side_panel_1.isSizeableView(view) && view.model.panel != null)
                    side_panel_1.update_panel_constraints(view);
            }
            this.solver.update_variables();
        };
        // XXX: bacause PlotCanvas is NOT a LayoutDOM
        PlotCanvasView.prototype._layout = function (final) {
            if (final === void 0) {
                final = false;
            }
            this.render();
            if (final) {
                this.model.plot.setv({
                    inner_width: Math.round(this.frame._width.value),
                    inner_height: Math.round(this.frame._height.value),
                    layout_width: Math.round(this.canvas._width.value),
                    layout_height: Math.round(this.canvas._height.value)
                }, { no_change: true });
                // XXX: can't be @request_paint(), because it would trigger back-and-forth
                // layout recomputing feedback loop between plots. Plots are also much more
                // responsive this way, especially in interactive mode.
                this.paint();
            }
        };
        PlotCanvasView.prototype.has_finished = function () {
            if (!_super.prototype.has_finished.call(this)) {
                return false;
            }
            for (var level in this.levels) {
                var renderer_views = this.levels[level];
                for (var id in renderer_views) {
                    var view = renderer_views[id];
                    if (!view.has_finished())
                        return false;
                }
            }
            return true;
        };
        PlotCanvasView.prototype.render = function () {
            // Set the plot and canvas to the current model's size
            // This gets called upon solver resize events
            var width = this.model._width.value;
            var height = this.model._height.value;
            this.canvas_view.set_dims([
                width,
                height
            ]);
            this.update_constraints();
            if (this.model.plot.match_aspect !== false && this.frame._width.value != 0 && this.frame._height.value != 0)
                this.update_dataranges();
            // This allows the plot canvas to be positioned around the toolbar
            this.el.style.position = 'absolute';
            this.el.style.left = this.model._dom_left.value + 'px';
            this.el.style.top = this.model._dom_top.value + 'px';
            this.el.style.width = this.model._width.value + 'px';
            this.el.style.height = this.model._height.value + 'px';
        };
        PlotCanvasView.prototype._needs_layout = function () {
            for (var id in this.renderer_views) {
                var view = this.renderer_views[id];
                if (side_panel_1.isSizeableView(view) && view.model.panel != null) {
                    if (side_panel_1._view_sizes.get(view) != view.get_size())
                        return true;
                }
            }
            return false;
        };
        PlotCanvasView.prototype.repaint = function () {
            if (this._needs_layout())
                this.parent.partial_layout();    // XXX
            else
                this.paint();
        };
        PlotCanvasView.prototype.paint = function () {
            var _this = this;
            if (this.is_paused)
                return;
            logging_1.logger.trace('PlotCanvas.render() for ' + this.model.id);
            // Prepare the canvas size, taking HIDPI into account. Note that this may cause a resize
            // of the canvas, which means that any previous calls to ctx.save() will be undone.
            this.canvas_view.prepare_canvas();
            var document = this.model.document;
            if (document != null) {
                var interactive_duration = document.interactive_duration();
                var plot_1 = this.model.plot;
                if (interactive_duration >= 0 && interactive_duration < plot_1.lod_interval) {
                    setTimeout(function () {
                        if (document.interactive_duration() > plot_1.lod_timeout) {
                            document.interactive_stop(plot_1);
                        }
                        _this.request_render();
                    }, plot_1.lod_timeout);
                } else
                    document.interactive_stop(plot_1);
            }
            for (var id in this.renderer_views) {
                var v = this.renderer_views[id];
                if (this.range_update_timestamp == null || v instanceof glyph_renderer_1.GlyphRendererView && v.set_data_timestamp > this.range_update_timestamp) {
                    this.update_dataranges();
                    break;
                }
            }
            // TODO (bev) OK this sucks, but the event from the solver update doesn't
            // reach the frame in time (sometimes) so force an update here for now
            // (mp) not only that, but models don't know about solver anymore, so
            // frame can't update its scales.
            this.model.frame.update_scales();
            var ctx = this.canvas_view.ctx;
            var ratio = this.canvas.pixel_ratio;
            // Set hidpi-transform
            ctx.save();
            // Save default state, do *after* getting ratio, cause setting canvas.width resets transforms
            ctx.scale(ratio, ratio);
            ctx.translate(0.5, 0.5);
            var frame_box = [
                this.frame._left.value,
                this.frame._top.value,
                this.frame._width.value,
                this.frame._height.value
            ];
            this._map_hook(ctx, frame_box);
            this._paint_empty(ctx, frame_box);
            this.prepare_webgl(ratio, frame_box);
            ctx.save();
            if (this.visuals.outline_line.doit) {
                this.visuals.outline_line.set_value(ctx);
                var x0 = frame_box[0], y0 = frame_box[1], w = frame_box[2], h = frame_box[3];
                // XXX: shrink outline region by 1px to make right and bottom lines visible
                // if they are on the edge of the canvas.
                if (x0 + w == this.canvas._width.value) {
                    w -= 1;
                }
                if (y0 + h == this.canvas._height.value) {
                    h -= 1;
                }
                ctx.strokeRect(x0, y0, w, h);
            }
            ctx.restore();
            this._paint_levels(ctx, [
                'image',
                'underlay',
                'glyph'
            ], frame_box, true);
            this.blit_webgl(ratio);
            this._paint_levels(ctx, ['annotation'], frame_box, true);
            this._paint_levels(ctx, ['overlay'], frame_box, false);
            if (this._initial_state_info.range == null)
                this.set_initial_range();
            ctx.restore();
            // Restore to default state
            if (!this._has_finished) {
                this._has_finished = true;
                this.notify_finished();
            }
        };
        PlotCanvasView.prototype._paint_levels = function (ctx, levels, clip_region, global_clip) {
            ctx.save();
            if (global_clip) {
                ctx.beginPath();
                ctx.rect.apply(ctx, clip_region);
                ctx.clip();
            }
            var indices = {};
            for (var i = 0; i < this.model.plot.renderers.length; i++) {
                var renderer = this.model.plot.renderers[i];
                indices[renderer.id] = i;
            }
            var sortKey = function (renderer_view) {
                return indices[renderer_view.model.id];
            };
            for (var _i = 0, levels_1 = levels; _i < levels_1.length; _i++) {
                var level = levels_1[_i];
                var renderer_views = array_1.sortBy(object_1.values(this.levels[level]), sortKey);
                for (var _a = 0, renderer_views_1 = renderer_views; _a < renderer_views_1.length; _a++) {
                    var renderer_view = renderer_views_1[_a];
                    if (!global_clip && renderer_view.needs_clip) {
                        ctx.save();
                        ctx.beginPath();
                        ctx.rect.apply(ctx, clip_region);
                        ctx.clip();
                    }
                    renderer_view.render();
                    if (!global_clip && renderer_view.needs_clip) {
                        ctx.restore();
                    }
                }
            }
            ctx.restore();
        };
        PlotCanvasView.prototype._map_hook = function (_ctx, _frame_box) {
        };
        PlotCanvasView.prototype._paint_empty = function (ctx, frame_box) {
            var _a = [
                    0,
                    0,
                    this.canvas_view.model._width.value,
                    this.canvas_view.model._height.value
                ], cx = _a[0], cy = _a[1], cw = _a[2], ch = _a[3];
            var fx = frame_box[0], fy = frame_box[1], fw = frame_box[2], fh = frame_box[3];
            ctx.clearRect(cx, cy, cw, ch);
            if (this.visuals.border_fill.doit) {
                this.visuals.border_fill.set_value(ctx);
                ctx.fillRect(cx, cy, cw, ch);
                ctx.clearRect(fx, fy, fw, fh);
            }
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                ctx.fillRect(fx, fy, fw, fh);
            }
        };
        PlotCanvasView.prototype.save = function (name) {
            switch (this.model.plot.output_backend) {
            case 'canvas':
            case 'webgl': {
                    var canvas = this.canvas_view.get_canvas_element();
                    if (canvas.msToBlob != null) {
                        var blob = canvas.msToBlob();
                        window.navigator.msSaveBlob(blob, name);
                    } else {
                        var link = document.createElement('a');
                        link.href = canvas.toDataURL('image/png');
                        link.download = name + '.png';
                        link.target = '_blank';
                        link.dispatchEvent(new MouseEvent('click'));
                    }
                    break;
                }
            case 'svg': {
                    var svg = this.canvas_view.ctx.getSerializedSvg(true);
                    var svgblob = new Blob([svg], { type: 'text/plain' });
                    var downloadLink = document.createElement('a');
                    downloadLink.download = name + '.svg';
                    downloadLink.innerHTML = 'Download svg';
                    downloadLink.href = window.URL.createObjectURL(svgblob);
                    downloadLink.onclick = function (event) {
                        return document.body.removeChild(event.target);
                    };
                    downloadLink.style.display = 'none';
                    document.body.appendChild(downloadLink);
                    downloadLink.click();
                    break;
                }
            }
        };
        return PlotCanvasView;
    }(dom_view_1.DOMView);
    exports.PlotCanvasView = PlotCanvasView;
    var AbovePanel = function (_super) {
        tslib_1.__extends(AbovePanel, _super);
        function AbovePanel() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AbovePanel.initClass = function () {
            this.prototype.type = 'AbovePanel';
        };
        return AbovePanel;
    }(layout_canvas_1.LayoutCanvas);
    exports.AbovePanel = AbovePanel;
    AbovePanel.initClass();
    var BelowPanel = function (_super) {
        tslib_1.__extends(BelowPanel, _super);
        function BelowPanel() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BelowPanel.initClass = function () {
            this.prototype.type = 'BelowPanel';
        };
        return BelowPanel;
    }(layout_canvas_1.LayoutCanvas);
    exports.BelowPanel = BelowPanel;
    BelowPanel.initClass();
    var LeftPanel = function (_super) {
        tslib_1.__extends(LeftPanel, _super);
        function LeftPanel() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LeftPanel.initClass = function () {
            this.prototype.type = 'LeftPanel';
        };
        return LeftPanel;
    }(layout_canvas_1.LayoutCanvas);
    exports.LeftPanel = LeftPanel;
    LeftPanel.initClass();
    var RightPanel = function (_super) {
        tslib_1.__extends(RightPanel, _super);
        function RightPanel() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        RightPanel.initClass = function () {
            this.prototype.type = 'RightPanel';
        };
        return RightPanel;
    }(layout_canvas_1.LayoutCanvas);
    exports.RightPanel = RightPanel;
    RightPanel.initClass();
    var PlotCanvas = function (_super) {
        tslib_1.__extends(PlotCanvas, _super);
        function PlotCanvas(attrs) {
            return _super.call(this, attrs) || this;
        }
        PlotCanvas.initClass = function () {
            this.prototype.type = 'PlotCanvas';
            this.prototype.default_view = PlotCanvasView;
            this.internal({
                plot: [p.Instance],
                toolbar: [p.Instance],
                canvas: [p.Instance],
                frame: [p.Instance]
            });
            this.override({
                // We should find a way to enforce this
                sizing_mode: 'stretch_both'
            });
        };
        PlotCanvas.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.canvas = new canvas_1.Canvas({
                map: this.use_map != null ? this.use_map : false,
                use_hidpi: this.plot.hidpi,
                output_backend: this.plot.output_backend
            });
            this.frame = new cartesian_frame_1.CartesianFrame({
                x_range: this.plot.x_range,
                extra_x_ranges: this.plot.extra_x_ranges,
                x_scale: this.plot.x_scale,
                y_range: this.plot.y_range,
                extra_y_ranges: this.plot.extra_y_ranges,
                y_scale: this.plot.y_scale
            });
            this.above_panel = new AbovePanel();
            this.below_panel = new BelowPanel();
            this.left_panel = new LeftPanel();
            this.right_panel = new RightPanel();
            logging_1.logger.debug('PlotCanvas initialized');
        };
        PlotCanvas.prototype._doc_attached = function () {
            this.canvas.attach_document(this.document);
            this.frame.attach_document(this.document);
            this.above_panel.attach_document(this.document);
            this.below_panel.attach_document(this.document);
            this.left_panel.attach_document(this.document);
            this.right_panel.attach_document(this.document);
            _super.prototype._doc_attached.call(this);
            logging_1.logger.debug('PlotCanvas attached to document');
        };
        PlotCanvas.prototype.get_layoutable_children = function () {
            var children = [
                this.above_panel,
                this.below_panel,
                this.left_panel,
                this.right_panel,
                this.canvas,
                this.frame
            ];
            var collect_panels = function (layout_renderers) {
                for (var _i = 0, layout_renderers_1 = layout_renderers; _i < layout_renderers_1.length; _i++) {
                    var r = layout_renderers_1[_i];
                    if (side_panel_1.isSizeable(r) && r.panel != null)
                        children.push(r.panel);
                }
            };
            collect_panels(this.plot.above);
            collect_panels(this.plot.below);
            collect_panels(this.plot.left);
            collect_panels(this.plot.right);
            return children;    // XXX: PlotCanvas should be a LayoutCanvas
        };
        PlotCanvas.prototype.get_constraints = function () {
            return _super.prototype.get_constraints.call(this).concat(this._get_constant_constraints(), this._get_side_constraints());
        };
        PlotCanvas.prototype._get_constant_constraints = function () {
            return [
                // Set the origin. Everything else is positioned absolutely wrt canvas.
                solver_1.EQ(this.canvas._left, 0),
                solver_1.EQ(this.canvas._top, 0),
                solver_1.GE(this.above_panel._top, [
                    -1,
                    this.canvas._top
                ]),
                solver_1.EQ(this.above_panel._bottom, [
                    -1,
                    this.frame._top
                ]),
                solver_1.EQ(this.above_panel._left, [
                    -1,
                    this.left_panel._right
                ]),
                solver_1.EQ(this.above_panel._right, [
                    -1,
                    this.right_panel._left
                ]),
                solver_1.EQ(this.below_panel._top, [
                    -1,
                    this.frame._bottom
                ]),
                solver_1.LE(this.below_panel._bottom, [
                    -1,
                    this.canvas._bottom
                ]),
                solver_1.EQ(this.below_panel._left, [
                    -1,
                    this.left_panel._right
                ]),
                solver_1.EQ(this.below_panel._right, [
                    -1,
                    this.right_panel._left
                ]),
                solver_1.EQ(this.left_panel._top, [
                    -1,
                    this.above_panel._bottom
                ]),
                solver_1.EQ(this.left_panel._bottom, [
                    -1,
                    this.below_panel._top
                ]),
                solver_1.GE(this.left_panel._left, [
                    -1,
                    this.canvas._left
                ]),
                solver_1.EQ(this.left_panel._right, [
                    -1,
                    this.frame._left
                ]),
                solver_1.EQ(this.right_panel._top, [
                    -1,
                    this.above_panel._bottom
                ]),
                solver_1.EQ(this.right_panel._bottom, [
                    -1,
                    this.below_panel._top
                ]),
                solver_1.EQ(this.right_panel._left, [
                    -1,
                    this.frame._right
                ]),
                solver_1.LE(this.right_panel._right, [
                    -1,
                    this.canvas._right
                ]),
                solver_1.EQ(this._top, [
                    -1,
                    this.above_panel._bottom
                ]),
                solver_1.EQ(this._left, [
                    -1,
                    this.left_panel._right
                ]),
                solver_1.EQ(this._height, [
                    -1,
                    this._bottom
                ], [
                    -1,
                    this.canvas._bottom
                ], this.below_panel._top),
                solver_1.EQ(this._width, [
                    -1,
                    this._right
                ], [
                    -1,
                    this.canvas._right
                ], this.right_panel._left),
                solver_1.GE(this._top, -this.plot.min_border_top),
                solver_1.GE(this._left, -this.plot.min_border_left),
                solver_1.GE(this._height, [
                    -1,
                    this._bottom
                ], -this.plot.min_border_bottom),
                solver_1.GE(this._width, [
                    -1,
                    this._right
                ], -this.plot.min_border_right)
            ];
        };
        PlotCanvas.prototype._get_side_constraints = function () {
            var panels = function (objs) {
                return objs.map(function (obj) {
                    return obj.panel;
                });
            };
            var above = alignments_1.vstack(this.above_panel, panels(this.plot.above));
            var below = alignments_1.vstack(this.below_panel, array_1.reversed(panels(this.plot.below)));
            var left = alignments_1.hstack(this.left_panel, panels(this.plot.left));
            var right = alignments_1.hstack(this.right_panel, array_1.reversed(panels(this.plot.right)));
            return array_1.concat([
                above,
                below,
                left,
                right
            ]);
        };
        return PlotCanvas;
    }(layout_dom_1.LayoutDOM);
    exports.PlotCanvas = PlotCanvas;
    PlotCanvas.initClass();    
},
/*models/ranges/data_range*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var range_1 = require(167    /* ./range */);
    var p = require(15    /* core/properties */);
    var DataRange = function (_super) {
        tslib_1.__extends(DataRange, _super);
        function DataRange(attrs) {
            return _super.call(this, attrs) || this;
        }
        DataRange.initClass = function () {
            this.prototype.type = 'DataRange';
            this.define({
                names: [
                    p.Array,
                    []
                ],
                renderers: [
                    p.Array,
                    []
                ]
            });
        };
        return DataRange;
    }(range_1.Range);
    exports.DataRange = DataRange;
    DataRange.initClass();    
},
/*models/ranges/data_range1d*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var data_range_1 = require(163    /* ./data_range */);
    var glyph_renderer_1 = require(169    /* ../renderers/glyph_renderer */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var bbox = require(24    /* core/util/bbox */);
    var array_1 = require(21    /* core/util/array */);
    var DataRange1d = function (_super) {
        tslib_1.__extends(DataRange1d, _super);
        function DataRange1d(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this._plot_bounds = {};
            _this.have_updated_interactively = false;
            return _this;
        }
        DataRange1d.initClass = function () {
            this.prototype.type = 'DataRange1d';
            this.define({
                start: [p.Number],
                end: [p.Number],
                range_padding: [
                    p.Number,
                    0.1
                ],
                range_padding_units: [
                    p.PaddingUnits,
                    'percent'
                ],
                flipped: [
                    p.Bool,
                    false
                ],
                follow: [p.StartEnd],
                follow_interval: [p.Number],
                default_span: [
                    p.Number,
                    2
                ]
            });
            this.internal({
                scale_hint: [
                    p.String,
                    'auto'
                ]
            });
        };
        DataRange1d.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._initial_start = this.start;
            this._initial_end = this.end;
            this._initial_range_padding = this.range_padding;
            this._initial_range_padding_units = this.range_padding_units;
            this._initial_follow = this.follow;
            this._initial_follow_interval = this.follow_interval;
            this._initial_default_span = this.default_span;
        };
        Object.defineProperty(DataRange1d.prototype, 'min', {
            get: function () {
                return Math.min(this.start, this.end);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(DataRange1d.prototype, 'max', {
            get: function () {
                return Math.max(this.start, this.end);
            },
            enumerable: true,
            configurable: true
        });
        DataRange1d.prototype.computed_renderers = function () {
            // TODO (bev) check that renderers actually configured with this range
            var names = this.names;
            var renderers = this.renderers;
            if (renderers.length == 0) {
                for (var _i = 0, _a = this.plots; _i < _a.length; _i++) {
                    var plot = _a[_i];
                    var rs = plot.renderers.filter(function (r) {
                        return r instanceof glyph_renderer_1.GlyphRenderer;
                    });
                    renderers = renderers.concat(rs);
                }
            }
            if (names.length > 0)
                renderers = renderers.filter(function (r) {
                    return array_1.includes(names, r.name);
                });
            logging_1.logger.debug('computed ' + renderers.length + ' renderers for DataRange1d ' + this.id);
            for (var _b = 0, renderers_1 = renderers; _b < renderers_1.length; _b++) {
                var r = renderers_1[_b];
                logging_1.logger.trace(' - ' + r.type + ' ' + r.id);
            }
            return renderers;
        };
        DataRange1d.prototype._compute_plot_bounds = function (renderers, bounds) {
            var result = bbox.empty();
            for (var _i = 0, renderers_2 = renderers; _i < renderers_2.length; _i++) {
                var r = renderers_2[_i];
                if (bounds[r.id] != null)
                    result = bbox.union(result, bounds[r.id]);
            }
            return result;
        };
        DataRange1d.prototype.adjust_bounds_for_aspect = function (bounds, ratio) {
            var result = bbox.empty();
            var width = bounds.maxX - bounds.minX;
            if (width <= 0) {
                width = 1;
            }
            var height = bounds.maxY - bounds.minY;
            if (height <= 0) {
                height = 1;
            }
            var xcenter = 0.5 * (bounds.maxX + bounds.minX);
            var ycenter = 0.5 * (bounds.maxY + bounds.minY);
            if (width < ratio * height) {
                width = ratio * height;
            } else {
                height = width / ratio;
            }
            result.maxX = xcenter + 0.5 * width;
            result.minX = xcenter - 0.5 * width;
            result.maxY = ycenter + 0.5 * height;
            result.minY = ycenter - 0.5 * height;
            return result;
        };
        DataRange1d.prototype._compute_min_max = function (plot_bounds, dimension) {
            var overall = bbox.empty();
            for (var k in plot_bounds) {
                var v = plot_bounds[k];
                overall = bbox.union(overall, v);
            }
            var min, max;
            if (dimension == 0)
                _a = [
                    overall.minX,
                    overall.maxX
                ], min = _a[0], max = _a[1];
            else
                _b = [
                    overall.minY,
                    overall.maxY
                ], min = _b[0], max = _b[1];
            return [
                min,
                max
            ];
            var _a, _b;
        };
        DataRange1d.prototype._compute_range = function (min, max) {
            var range_padding = this.range_padding;
            // XXX: ? 0
            var start, end;
            if (this.scale_hint == 'log') {
                if (isNaN(min) || !isFinite(min) || min <= 0) {
                    if (isNaN(max) || !isFinite(max) || max <= 0)
                        min = 0.1;
                    else
                        min = max / 100;
                    logging_1.logger.warn('could not determine minimum data value for log axis, DataRange1d using value ' + min);
                }
                if (isNaN(max) || !isFinite(max) || max <= 0) {
                    if (isNaN(min) || !isFinite(min) || min <= 0)
                        max = 10;
                    else
                        max = min * 100;
                    logging_1.logger.warn('could not determine maximum data value for log axis, DataRange1d using value ' + max);
                }
                var center = void 0, span = void 0;
                if (max == min) {
                    span = this.default_span + 0.001;
                    center = Math.log(min) / Math.log(10);
                } else {
                    var log_min = void 0, log_max = void 0;
                    if (this.range_padding_units == 'percent') {
                        log_min = Math.log(min) / Math.log(10);
                        log_max = Math.log(max) / Math.log(10);
                        span = (log_max - log_min) * (1 + range_padding);
                    } else {
                        log_min = Math.log(min - range_padding) / Math.log(10);
                        log_max = Math.log(max + range_padding) / Math.log(10);
                        span = log_max - log_min;
                    }
                    center = (log_min + log_max) / 2;
                }
                start = Math.pow(10, center - span / 2);
                end = Math.pow(10, center + span / 2);
            } else {
                var span = void 0;
                if (max == min)
                    span = this.default_span;
                else {
                    if (this.range_padding_units == 'percent')
                        span = (max - min) * (1 + range_padding);
                    else
                        span = max - min + 2 * range_padding;
                }
                var center = (max + min) / 2;
                start = center - span / 2;
                end = center + span / 2;
            }
            var follow_sign = +1;
            if (this.flipped) {
                _a = [
                    end,
                    start
                ], start = _a[0], end = _a[1];
                follow_sign = -1;
            }
            var follow_interval = this.follow_interval;
            if (follow_interval != null && Math.abs(start - end) > follow_interval) {
                if (this.follow == 'start')
                    end = start + follow_sign * follow_interval;
                else if (this.follow == 'end')
                    start = end - follow_sign * follow_interval;
            }
            return [
                start,
                end
            ];
            var _a;
        };
        DataRange1d.prototype.update = function (bounds, dimension, bounds_id, ratio) {
            if (this.have_updated_interactively)
                return;
            var renderers = this.computed_renderers();
            // update the raw data bounds for all renderers we care about
            var total_bounds = this._compute_plot_bounds(renderers, bounds);
            if (ratio != null)
                total_bounds = this.adjust_bounds_for_aspect(total_bounds, ratio);
            this._plot_bounds[bounds_id] = total_bounds;
            // compute the min/mix for our specified dimension
            var _a = this._compute_min_max(this._plot_bounds, dimension), min = _a[0], max = _a[1];
            // derive start, end from bounds and data range config
            var _b = this._compute_range(min, max), start = _b[0], end = _b[1];
            if (this._initial_start != null) {
                if (this.scale_hint == 'log') {
                    if (this._initial_start > 0)
                        start = this._initial_start;
                } else
                    start = this._initial_start;
            }
            if (this._initial_end != null) {
                if (this.scale_hint == 'log') {
                    if (this._initial_end > 0)
                        end = this._initial_end;
                } else
                    end = this._initial_end;
            }
            // only trigger updates when there are changes
            var _c = [
                    this.start,
                    this.end
                ], _start = _c[0], _end = _c[1];
            if (start != _start || end != _end) {
                var new_range = {};
                if (start != _start)
                    new_range.start = start;
                if (end != _end)
                    new_range.end = end;
                this.setv(new_range);
            }
            if (this.bounds == 'auto')
                this.setv({
                    bounds: [
                        start,
                        end
                    ]
                }, { silent: true });
            this.change.emit();
        };
        DataRange1d.prototype.reset = function () {
            this.have_updated_interactively = false;
            // change events silenced as PlotCanvasView.update_dataranges triggers property callbacks
            this.setv({
                range_padding: this._initial_range_padding,
                range_padding_units: this._initial_range_padding_units,
                follow: this._initial_follow,
                follow_interval: this._initial_follow_interval,
                default_span: this._initial_default_span
            }, { silent: true });
            this.change.emit();
        };
        return DataRange1d;
    }(data_range_1.DataRange);
    exports.DataRange1d = DataRange1d;
    DataRange1d.initClass();    
},
/*models/ranges/factor_range*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var range_1 = require(167    /* ./range */);
    var p = require(15    /* core/properties */);
    var arrayable_1 = require(22    /* core/util/arrayable */);
    var array_1 = require(21    /* core/util/array */);
    var types_1 = require(44    /* core/util/types */);
    function map_one_level(factors, padding, offset) {
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = {};
        for (var i = 0; i < factors.length; i++) {
            var factor = factors[i];
            if (factor in mapping)
                throw new Error('duplicate factor or subfactor: ' + factor);
            else
                mapping[factor] = { value: 0.5 + i * (1 + padding) + offset };
        }
        return [
            mapping,
            (factors.length - 1) * padding
        ];
    }
    exports.map_one_level = map_one_level;
    function map_two_levels(factors, outer_pad, factor_pad, offset) {
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = {};
        var tops = {};
        var tops_order = [];
        for (var _i = 0, factors_1 = factors; _i < factors_1.length; _i++) {
            var _a = factors_1[_i], f0 = _a[0], f1 = _a[1];
            if (!(f0 in tops)) {
                tops[f0] = [];
                tops_order.push(f0);
            }
            tops[f0].push(f1);
        }
        var suboffset = offset;
        var total_subpad = 0;
        var _loop_1 = function (f0) {
            var n = tops[f0].length;
            var _a = map_one_level(tops[f0], factor_pad, suboffset), submap = _a[0], subpad = _a[1];
            total_subpad += subpad;
            var subtot = array_1.sum(tops[f0].map(function (f1) {
                return submap[f1].value;
            }));
            mapping[f0] = {
                value: subtot / n,
                mapping: submap
            };
            suboffset += n + outer_pad + subpad;
        };
        for (var _b = 0, tops_order_1 = tops_order; _b < tops_order_1.length; _b++) {
            var f0 = tops_order_1[_b];
            _loop_1(f0);
        }
        return [
            mapping,
            tops_order,
            (tops_order.length - 1) * outer_pad + total_subpad
        ];
    }
    exports.map_two_levels = map_two_levels;
    function map_three_levels(factors, outer_pad, inner_pad, factor_pad, offset) {
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = {};
        var tops = {};
        var tops_order = [];
        for (var _i = 0, factors_2 = factors; _i < factors_2.length; _i++) {
            var _a = factors_2[_i], f0 = _a[0], f1 = _a[1], f2 = _a[2];
            if (!(f0 in tops)) {
                tops[f0] = [];
                tops_order.push(f0);
            }
            tops[f0].push([
                f1,
                f2
            ]);
        }
        var mids_order = [];
        var suboffset = offset;
        var total_subpad = 0;
        var _loop_2 = function (f0) {
            var n = tops[f0].length;
            var _a = map_two_levels(tops[f0], inner_pad, factor_pad, suboffset), submap = _a[0], submids_order = _a[1], subpad = _a[2];
            for (var _i = 0, submids_order_1 = submids_order; _i < submids_order_1.length; _i++) {
                var f1 = submids_order_1[_i];
                mids_order.push([
                    f0,
                    f1
                ]);
            }
            total_subpad += subpad;
            var subtot = array_1.sum(tops[f0].map(function (_a) {
                var f1 = _a[0];
                return submap[f1].value;
            }));
            mapping[f0] = {
                value: subtot / n,
                mapping: submap
            };
            suboffset += n + outer_pad + subpad;
        };
        for (var _b = 0, tops_order_2 = tops_order; _b < tops_order_2.length; _b++) {
            var f0 = tops_order_2[_b];
            _loop_2(f0);
        }
        return [
            mapping,
            tops_order,
            mids_order,
            (tops_order.length - 1) * outer_pad + total_subpad
        ];
    }
    exports.map_three_levels = map_three_levels;
    var FactorRange = function (_super) {
        tslib_1.__extends(FactorRange, _super);
        function FactorRange(attrs) {
            return _super.call(this, attrs) || this;
        }
        FactorRange.initClass = function () {
            this.prototype.type = 'FactorRange';
            this.define({
                factors: [
                    p.Array,
                    []
                ],
                factor_padding: [
                    p.Number,
                    0
                ],
                subgroup_padding: [
                    p.Number,
                    0.8
                ],
                group_padding: [
                    p.Number,
                    1.4
                ],
                range_padding: [
                    p.Number,
                    0
                ],
                range_padding_units: [
                    p.PaddingUnits,
                    'percent'
                ],
                start: [p.Number],
                end: [p.Number]
            });
            this.internal({
                levels: [p.Number],
                mids: [p.Array],
                tops: [p.Array],
                tops_groups: [p.Array]
            });
        };
        Object.defineProperty(FactorRange.prototype, 'min', {
            get: function () {
                return this.start;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FactorRange.prototype, 'max', {
            get: function () {
                return this.end;
            },
            enumerable: true,
            configurable: true
        });
        FactorRange.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._init();
        };
        FactorRange.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.properties.factors.change, function () {
                return _this.reset();
            });
            this.connect(this.properties.factor_padding.change, function () {
                return _this.reset();
            });
            this.connect(this.properties.group_padding.change, function () {
                return _this.reset();
            });
            this.connect(this.properties.subgroup_padding.change, function () {
                return _this.reset();
            });
            this.connect(this.properties.range_padding.change, function () {
                return _this.reset();
            });
            this.connect(this.properties.range_padding_units.change, function () {
                return _this.reset();
            });
        };
        FactorRange.prototype.reset = function () {
            this._init();
            this.change.emit();
        };
        FactorRange.prototype._lookup = function (x) {
            if (x.length == 1) {
                var m = this._mapping;
                if (!m.hasOwnProperty(x[0])) {
                    return NaN;
                }
                return m[x[0]].value;
            } else if (x.length == 2) {
                var m = this._mapping;
                if (!m.hasOwnProperty(x[0]) || !m[x[0]].mapping.hasOwnProperty(x[1])) {
                    return NaN;
                }
                return m[x[0]].mapping[x[1]].value;
            } else if (x.length == 3) {
                var m = this._mapping;
                if (!m.hasOwnProperty(x[0]) || !m[x[0]].mapping.hasOwnProperty(x[1]) || !m[x[0]].mapping[x[1]].mapping.hasOwnProperty(x[2])) {
                    return NaN;
                }
                return m[x[0]].mapping[x[1]].mapping[x[2]].value;
            } else
                throw new Error('unreachable code');
        };
        // convert a string factor into a synthetic coordinate
        FactorRange.prototype.synthetic = function (x) {
            if (types_1.isNumber(x))
                return x;
            if (types_1.isString(x))
                return this._lookup([x]);
            var offset = 0;
            var off = x[x.length - 1];
            if (types_1.isNumber(off)) {
                offset = off;
                x = x.slice(0, -1);
            }
            return this._lookup(x) + offset;
        };
        // convert an array of string factors into synthetic coordinates
        FactorRange.prototype.v_synthetic = function (xs) {
            var _this = this;
            return arrayable_1.map(xs, function (x) {
                return _this.synthetic(x);
            });
        };
        FactorRange.prototype._init = function () {
            var levels;
            var inside_padding;
            if (array_1.all(this.factors, types_1.isString)) {
                levels = 1;
                _a = map_one_level(this.factors, this.factor_padding), this._mapping = _a[0], inside_padding = _a[1];
            } else if (array_1.all(this.factors, function (x) {
                    return types_1.isArray(x) && x.length == 2 && types_1.isString(x[0]) && types_1.isString(x[1]);
                })) {
                levels = 2;
                _b = map_two_levels(this.factors, this.group_padding, this.factor_padding), this._mapping = _b[0], this.tops = _b[1], inside_padding = _b[2];
            } else if (array_1.all(this.factors, function (x) {
                    return types_1.isArray(x) && x.length == 3 && types_1.isString(x[0]) && types_1.isString(x[1]) && types_1.isString(x[2]);
                })) {
                levels = 3;
                _c = map_three_levels(this.factors, this.group_padding, this.subgroup_padding, this.factor_padding), this._mapping = _c[0], this.tops = _c[1], this.mids = _c[2], inside_padding = _c[3];
            } else
                throw new Error('???');
            var start = 0;
            var end = this.factors.length + inside_padding;
            if (this.range_padding_units == 'percent') {
                var half_span = (end - start) * this.range_padding / 2;
                start -= half_span;
                end += half_span;
            } else {
                start -= this.range_padding;
                end += this.range_padding;
            }
            this.setv({
                start: start,
                end: end,
                levels: levels
            }, { silent: true });
            if (this.bounds == 'auto')
                this.setv({
                    bounds: [
                        start,
                        end
                    ]
                }, { silent: true });
            var _a, _b, _c;
        };
        return FactorRange;
    }(range_1.Range);
    exports.FactorRange = FactorRange;
    FactorRange.initClass();    
},
/*models/ranges/index*/
function _(require, module, exports) {
    var data_range_1 = require(163    /* ./data_range */);
    exports.DataRange = data_range_1.DataRange;
    var data_range1d_1 = require(164    /* ./data_range1d */);
    exports.DataRange1d = data_range1d_1.DataRange1d;
    var factor_range_1 = require(165    /* ./factor_range */);
    exports.FactorRange = factor_range_1.FactorRange;
    var range_1 = require(167    /* ./range */);
    exports.Range = range_1.Range;
    var range1d_1 = require(168    /* ./range1d */);
    exports.Range1d = range1d_1.Range1d;    
},
/*models/ranges/range*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var model_1 = require(53    /* ../../model */);
    var p = require(15    /* core/properties */);
    var types_1 = require(44    /* core/util/types */);
    var Range = function (_super) {
        tslib_1.__extends(Range, _super);
        function Range(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this.have_updated_interactively = false;
            return _this;
        }
        Range.initClass = function () {
            this.prototype.type = 'Range';
            this.define({
                callback: [p.Any],
                bounds: [p.Any],
                min_interval: [p.Any],
                max_interval: [p.Any]
            });
            this.internal({
                plots: [
                    p.Array,
                    []
                ]
            });
        };
        Range.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.change, function () {
                return _this._emit_callback();
            });
        };
        Range.prototype.reset = function () {
            /**
         * This method should be reimplemented by subclasses and ensure that
         * the callback, if exists, is executed at completion.
         */
            this.change.emit();
        };
        Range.prototype._emit_callback = function () {
            if (this.callback != null) {
                if (types_1.isFunction(this.callback))
                    this.callback(this);
                else
                    this.callback.execute(this, {});
            }
        };
        return Range;
    }(model_1.Model);
    exports.Range = Range;
    Range.initClass();    
},
/*models/ranges/range1d*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var range_1 = require(167    /* ./range */);
    var p = require(15    /* core/properties */);
    var Range1d = function (_super) {
        tslib_1.__extends(Range1d, _super);
        function Range1d(attrs) {
            return _super.call(this, attrs) || this;
        }
        Range1d.initClass = function () {
            this.prototype.type = 'Range1d';
            this.define({
                start: [
                    p.Number,
                    0
                ],
                end: [
                    p.Number,
                    1
                ]
            });
        };
        Range1d.prototype._set_auto_bounds = function () {
            if (this.bounds == 'auto') {
                var min = Math.min(this._initial_start, this._initial_end);
                var max = Math.max(this._initial_start, this._initial_end);
                this.setv({
                    bounds: [
                        min,
                        max
                    ]
                }, { silent: true });
            }
        };
        Range1d.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._initial_start = this.start;
            this._initial_end = this.end;
            this._set_auto_bounds();
        };
        Object.defineProperty(Range1d.prototype, 'min', {
            get: function () {
                return Math.min(this.start, this.end);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Range1d.prototype, 'max', {
            get: function () {
                return Math.max(this.start, this.end);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Range1d.prototype, 'is_reversed', {
            get: function () {
                return this.start > this.end;
            },
            enumerable: true,
            configurable: true
        });
        Range1d.prototype.reset = function () {
            this._set_auto_bounds();
            if (this.start != this._initial_start || this.end != this._initial_end)
                this.setv({
                    start: this._initial_start,
                    end: this._initial_end
                });
            else
                this.change.emit();
        };
        return Range1d;
    }(range_1.Range);
    exports.Range1d = Range1d;
    Range1d.initClass();    
},
/*models/renderers/glyph_renderer*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var renderer_1 = require(173    /* ./renderer */);
    var line_1 = require(120    /* ../glyphs/line */);
    var cds_view_1 = require(183    /* ../sources/cds_view */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var arrayable_1 = require(22    /* core/util/arrayable */);
    var array_1 = require(21    /* core/util/array */);
    var object_1 = require(32    /* core/util/object */);
    var factor_range_1 = require(165    /* ../ranges/factor_range */);
    var selection_defaults = {
        fill: {},
        line: {}
    };
    var decimated_defaults = {
        fill: {
            fill_alpha: 0.3,
            fill_color: 'grey'
        },
        line: {
            line_alpha: 0.3,
            line_color: 'grey'
        }
    };
    var nonselection_defaults = {
        fill: { fill_alpha: 0.2 },
        line: {}
    };
    var GlyphRendererView = function (_super) {
        tslib_1.__extends(GlyphRendererView, _super);
        function GlyphRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        GlyphRendererView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            var base_glyph = this.model.glyph;
            var has_fill = array_1.includes(base_glyph.mixins, 'fill');
            var has_line = array_1.includes(base_glyph.mixins, 'line');
            var glyph_attrs = object_1.clone(base_glyph.attributes);
            delete glyph_attrs.id;
            function mk_glyph(defaults) {
                var attrs = object_1.clone(glyph_attrs);
                if (has_fill)
                    object_1.extend(attrs, defaults.fill);
                if (has_line)
                    object_1.extend(attrs, defaults.line);
                return new base_glyph.constructor(attrs);
            }
            this.glyph = this.build_glyph_view(base_glyph);
            var selection_glyph = this.model.selection_glyph;
            if (selection_glyph == null)
                selection_glyph = mk_glyph({
                    fill: {},
                    line: {}
                });
            else if (selection_glyph === 'auto')
                selection_glyph = mk_glyph(selection_defaults);
            this.selection_glyph = this.build_glyph_view(selection_glyph);
            var nonselection_glyph = this.model.nonselection_glyph;
            if (nonselection_glyph == null)
                nonselection_glyph = mk_glyph({
                    fill: {},
                    line: {}
                });
            else if (nonselection_glyph === 'auto')
                nonselection_glyph = mk_glyph(nonselection_defaults);
            this.nonselection_glyph = this.build_glyph_view(nonselection_glyph);
            var hover_glyph = this.model.hover_glyph;
            if (hover_glyph != null)
                this.hover_glyph = this.build_glyph_view(hover_glyph);
            var muted_glyph = this.model.muted_glyph;
            if (muted_glyph != null)
                this.muted_glyph = this.build_glyph_view(muted_glyph);
            var decimated_glyph = mk_glyph(decimated_defaults);
            this.decimated_glyph = this.build_glyph_view(decimated_glyph);
            this.xscale = this.plot_view.frame.xscales[this.model.x_range_name];
            this.yscale = this.plot_view.frame.yscales[this.model.y_range_name];
            this.set_data(false);
            if (this.model.data_source.setup != null)
                this.model.data_source.setup();
        };
        GlyphRendererView.prototype.build_glyph_view = function (model) {
            return new model.default_view({
                model: model,
                renderer: this,
                plot_view: this.plot_view,
                parent: this
            });    // XXX
        };
        GlyphRendererView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () {
                return _this.request_render();
            });
            this.connect(this.model.glyph.change, function () {
                return _this.set_data();
            });
            this.connect(this.model.data_source.change, function () {
                return _this.set_data();
            });
            this.connect(this.model.data_source.streaming, function () {
                return _this.set_data();
            });
            this.connect(this.model.data_source.patching, function (indices) {
                return _this.set_data(true, indices);
            });
            this.connect(this.model.data_source._select, function () {
                return _this.request_render();
            });
            if (this.hover_glyph != null)
                this.connect(this.model.data_source.inspect, function () {
                    return _this.request_render();
                });
            this.connect(this.model.properties.view.change, function () {
                return _this.set_data();
            });
            this.connect(this.model.view.change, function () {
                return _this.set_data();
            });
            var _a = this.plot_model.frame, x_ranges = _a.x_ranges, y_ranges = _a.y_ranges;
            for (var name_1 in x_ranges) {
                var rng = x_ranges[name_1];
                if (rng instanceof factor_range_1.FactorRange)
                    this.connect(rng.change, function () {
                        return _this.set_data();
                    });
            }
            for (var name_2 in y_ranges) {
                var rng = y_ranges[name_2];
                if (rng instanceof factor_range_1.FactorRange)
                    this.connect(rng.change, function () {
                        return _this.set_data();
                    });
            }
            this.connect(this.model.glyph.transformchange, function () {
                return _this.set_data();
            });
        };
        GlyphRendererView.prototype.have_selection_glyphs = function () {
            return this.selection_glyph != null && this.nonselection_glyph != null;
        };
        // in case of partial updates like patching, the list of indices that actually
        // changed may be passed as the "indices" parameter to afford any optional optimizations
        GlyphRendererView.prototype.set_data = function (request_render, indices) {
            if (request_render === void 0) {
                request_render = true;
            }
            if (indices === void 0) {
                indices = null;
            }
            var t0 = Date.now();
            var source = this.model.data_source;
            this.all_indices = this.model.view.indices;
            // TODO (bev) this is a bit clunky, need to make sure glyphs use the correct ranges when they call
            // mapping functions on the base Renderer class
            this.glyph.model.setv({
                x_range_name: this.model.x_range_name,
                y_range_name: this.model.y_range_name
            }, { silent: true });
            this.glyph.set_data(source, this.all_indices, indices);
            this.glyph.set_visuals(source);
            this.decimated_glyph.set_visuals(source);
            if (this.have_selection_glyphs()) {
                this.selection_glyph.set_visuals(source);
                this.nonselection_glyph.set_visuals(source);
            }
            if (this.hover_glyph != null)
                this.hover_glyph.set_visuals(source);
            if (this.muted_glyph != null)
                this.muted_glyph.set_visuals(source);
            var lod_factor = this.plot_model.plot.lod_factor;
            this.decimated = [];
            for (var i = 0, end = Math.floor(this.all_indices.length / lod_factor); i < end; i++) {
                this.decimated.push(i * lod_factor);
            }
            var dt = Date.now() - t0;
            logging_1.logger.debug(this.glyph.model.type + ' GlyphRenderer (' + this.model.id + '): set_data finished in ' + dt + 'ms');
            this.set_data_timestamp = Date.now();
            if (request_render)
                this.request_render();
        };
        GlyphRendererView.prototype.render = function () {
            var _this = this;
            if (!this.model.visible)
                return;
            var t0 = Date.now();
            var glsupport = this.glyph.glglyph;
            this.glyph.map_data();
            var dtmap = Date.now() - t0;
            var tmask = Date.now();
            // all_indices is in full data space, indices is converted to subset space
            // either by mask_data (that uses the spatial index) or manually
            var indices = this.glyph.mask_data(this.all_indices);
            if (indices.length === this.all_indices.length) {
                indices = array_1.range(0, this.all_indices.length);
            }
            var dtmask = Date.now() - tmask;
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            // selected is in full set space
            var selected = this.model.data_source.selected;
            var selected_full_indices;
            if (!selected || selected.is_empty()) {
                selected_full_indices = [];
            } else {
                if (this.glyph instanceof line_1.LineView && selected.selected_glyph === this.glyph.model) {
                    selected_full_indices = this.model.view.convert_indices_from_subset(indices);
                } else {
                    selected_full_indices = selected.indices;
                }
            }
            // inspected is in full set space
            var inspected = this.model.data_source.inspected;
            var inspected_full_indices;
            if (!inspected || inspected.length === 0) {
                inspected_full_indices = [];
            } else {
                if (inspected['0d'].glyph) {
                    inspected_full_indices = this.model.view.convert_indices_from_subset(indices);
                } else if (inspected['1d'].indices.length > 0) {
                    inspected_full_indices = inspected['1d'].indices;
                } else {
                    inspected_full_indices = function () {
                        var result = [];
                        for (var _i = 0, _a = Object.keys(inspected['2d'].indices); _i < _a.length; _i++) {
                            var i = _a[_i];
                            result.push(parseInt(i));
                        }
                        return result;
                    }();
                }
            }
            // inspected is transformed to subset space
            var inspected_subset_indices = function () {
                var result = [];
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (array_1.includes(inspected_full_indices, _this.all_indices[i]))
                        result.push(i);
                }
                return result;
            }();
            var lod_threshold = this.plot_model.plot.lod_threshold;
            var glyph;
            var nonselection_glyph;
            var selection_glyph;
            if ((this.model.document != null ? this.model.document.interactive_duration() > 0 : false) && !glsupport && lod_threshold != null && this.all_indices.length > lod_threshold) {
                // Render decimated during interaction if too many elements and not using GL
                indices = this.decimated;
                glyph = this.decimated_glyph;
                nonselection_glyph = this.decimated_glyph;
                selection_glyph = this.selection_glyph;
            } else {
                glyph = this.model.muted && this.muted_glyph != null ? this.muted_glyph : this.glyph;
                nonselection_glyph = this.nonselection_glyph;
                selection_glyph = this.selection_glyph;
            }
            if (this.hover_glyph != null && inspected_subset_indices.length)
                indices = array_1.difference(indices, inspected_subset_indices);
            // Render with no selection
            var dtselect = null;
            var trender;
            if (!(selected_full_indices.length && this.have_selection_glyphs())) {
                trender = Date.now();
                if (this.glyph instanceof line_1.LineView) {
                    if (this.hover_glyph && inspected_subset_indices.length)
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices), this.glyph);
                    else
                        glyph.render(ctx, this.all_indices, this.glyph);
                } else {
                    glyph.render(ctx, indices, this.glyph);
                    if (this.hover_glyph && inspected_subset_indices.length)
                        this.hover_glyph.render(ctx, inspected_subset_indices, this.glyph);
                }    // Render with selection
            } else {
                // reset the selection mask
                var tselect = Date.now();
                var selected_mask = {};
                for (var _i = 0, selected_full_indices_1 = selected_full_indices; _i < selected_full_indices_1.length; _i++) {
                    var i = selected_full_indices_1[_i];
                    selected_mask[i] = true;
                }
                // intersect/different selection with render mask
                var selected_subset_indices = new Array();
                var nonselected_subset_indices = new Array();
                // now, selected is changed to subset space, except for Line glyph
                if (this.glyph instanceof line_1.LineView) {
                    for (var _a = 0, _b = this.all_indices; _a < _b.length; _a++) {
                        var i = _b[_a];
                        if (selected_mask[i] != null)
                            selected_subset_indices.push(i);
                        else
                            nonselected_subset_indices.push(i);
                    }
                } else {
                    for (var _c = 0, indices_2 = indices; _c < indices_2.length; _c++) {
                        var i = indices_2[_c];
                        if (selected_mask[this.all_indices[i]] != null)
                            selected_subset_indices.push(i);
                        else
                            nonselected_subset_indices.push(i);
                    }
                }
                dtselect = Date.now() - tselect;
                trender = Date.now();
                nonselection_glyph.render(ctx, nonselected_subset_indices, this.glyph);
                selection_glyph.render(ctx, selected_subset_indices, this.glyph);
                if (this.hover_glyph != null) {
                    if (this.glyph instanceof line_1.LineView)
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices), this.glyph);
                    else
                        this.hover_glyph.render(ctx, inspected_subset_indices, this.glyph);
                }
            }
            var dtrender = Date.now() - trender;
            this.last_dtrender = dtrender;
            var dttot = Date.now() - t0;
            logging_1.logger.debug(this.glyph.model.type + ' GlyphRenderer (' + this.model.id + '): render finished in ' + dttot + 'ms');
            logging_1.logger.trace(' - map_data finished in       : ' + dtmap + 'ms');
            logging_1.logger.trace(' - mask_data finished in      : ' + dtmask + 'ms');
            if (dtselect != null) {
                logging_1.logger.trace(' - selection mask finished in : ' + dtselect + 'ms');
            }
            logging_1.logger.trace(' - glyph renders finished in  : ' + dtrender + 'ms');
            return ctx.restore();
        };
        GlyphRendererView.prototype.draw_legend = function (ctx, x0, x1, y0, y1, field, label) {
            var index = this.model.get_reference_point(field, label);
            this.glyph.draw_legend_for_index(ctx, {
                x0: x0,
                x1: x1,
                y0: y0,
                y1: y1
            }, index);
        };
        GlyphRendererView.prototype.hit_test = function (geometry) {
            if (!this.model.visible)
                return null;
            var hit_test_result = this.glyph.hit_test(geometry);
            // glyphs that don't have hit-testing implemented will return null
            if (hit_test_result == null)
                return null;
            return this.model.view.convert_selection_from_subset(hit_test_result);
        };
        return GlyphRendererView;
    }(renderer_1.RendererView);
    exports.GlyphRendererView = GlyphRendererView;
    var GlyphRenderer = function (_super) {
        tslib_1.__extends(GlyphRenderer, _super);
        function GlyphRenderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        GlyphRenderer.initClass = function () {
            this.prototype.type = 'GlyphRenderer';
            this.prototype.default_view = GlyphRendererView;
            this.define({
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ],
                data_source: [p.Instance],
                view: [
                    p.Instance,
                    function () {
                        return new cds_view_1.CDSView();
                    }
                ],
                glyph: [p.Instance],
                hover_glyph: [p.Instance],
                nonselection_glyph: [
                    p.Any,
                    'auto'
                ],
                selection_glyph: [
                    p.Any,
                    'auto'
                ],
                muted_glyph: [p.Instance],
                muted: [
                    p.Bool,
                    false
                ]
            });
            this.override({ level: 'glyph' });
        };
        GlyphRenderer.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            if (this.view.source == null) {
                this.view.source = this.data_source;
                this.view.compute_indices();
            }
        };
        GlyphRenderer.prototype.get_reference_point = function (field, value) {
            var index = 0;
            if (field != null) {
                var data = this.data_source.get_column(field);
                if (data != null) {
                    var i = arrayable_1.indexOf(data, value);
                    if (i != -1)
                        index = i;
                }
            }
            return index;
        };
        GlyphRenderer.prototype.get_selection_manager = function () {
            return this.data_source.selection_manager;
        };
        return GlyphRenderer;
    }(renderer_1.Renderer);
    exports.GlyphRenderer = GlyphRenderer;
    GlyphRenderer.initClass();    
},
/*models/renderers/graph_renderer*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var renderer_1 = require(173    /* ./renderer */);
    var graph_hit_test_policy_1 = require(136    /* ../graphs/graph_hit_test_policy */);
    var p = require(15    /* core/properties */);
    var build_views_1 = require(4    /* core/build_views */);
    var GraphRendererView = function (_super) {
        tslib_1.__extends(GraphRendererView, _super);
        function GraphRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        GraphRendererView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.xscale = this.plot_view.frame.xscales['default'];
            this.yscale = this.plot_view.frame.yscales['default'];
            this._renderer_views = {};
            _a = build_views_1.build_views(this._renderer_views, [
                this.model.node_renderer,
                this.model.edge_renderer
            ], this.plot_view.view_options()), this.node_view = _a[0], this.edge_view = _a[1];
            this.set_data();
            var _a;
        };
        GraphRendererView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.layout_provider.change, function () {
                return _this.set_data();
            });
            this.connect(this.model.node_renderer.data_source._select, function () {
                return _this.set_data();
            });
            this.connect(this.model.node_renderer.data_source.inspect, function () {
                return _this.set_data();
            });
            this.connect(this.model.node_renderer.data_source.change, function () {
                return _this.set_data();
            });
            this.connect(this.model.edge_renderer.data_source._select, function () {
                return _this.set_data();
            });
            this.connect(this.model.edge_renderer.data_source.inspect, function () {
                return _this.set_data();
            });
            this.connect(this.model.edge_renderer.data_source.change, function () {
                return _this.set_data();
            });
            var _a = this.plot_model.frame, x_ranges = _a.x_ranges, y_ranges = _a.y_ranges;
            for (var name_1 in x_ranges) {
                var rng = x_ranges[name_1];
                this.connect(rng.change, function () {
                    return _this.set_data();
                });
            }
            for (var name_2 in y_ranges) {
                var rng = y_ranges[name_2];
                this.connect(rng.change, function () {
                    return _this.set_data();
                });
            }
        };
        GraphRendererView.prototype.set_data = function (request_render) {
            if (request_render === void 0) {
                request_render = true;
            }
            // TODO (bev) this is a bit clunky, need to make sure glyphs use the correct ranges when they call
            // mapping functions on the base Renderer class
            this.node_view.glyph.model.setv({
                x_range_name: this.model.x_range_name,
                y_range_name: this.model.y_range_name
            }, { silent: true });
            this.edge_view.glyph.model.setv({
                x_range_name: this.model.x_range_name,
                y_range_name: this.model.y_range_name
            }, { silent: true });
            // XXX
            var node_glyph = this.node_view.glyph;
            _a = this.model.layout_provider.get_node_coordinates(this.model.node_renderer.data_source), node_glyph._x = _a[0], node_glyph._y = _a[1];
            var edge_glyph = this.edge_view.glyph;
            _b = this.model.layout_provider.get_edge_coordinates(this.model.edge_renderer.data_source), edge_glyph._xs = _b[0], edge_glyph._ys = _b[1];
            node_glyph.index_data();
            edge_glyph.index_data();
            if (request_render)
                this.request_render();
            var _a, _b;
        };
        GraphRendererView.prototype.render = function () {
            this.edge_view.render();
            this.node_view.render();
        };
        return GraphRendererView;
    }(renderer_1.RendererView);
    exports.GraphRendererView = GraphRendererView;
    var GraphRenderer = function (_super) {
        tslib_1.__extends(GraphRenderer, _super);
        function GraphRenderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        GraphRenderer.initClass = function () {
            this.prototype.type = 'GraphRenderer';
            this.prototype.default_view = GraphRendererView;
            this.define({
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ],
                layout_provider: [p.Instance],
                node_renderer: [p.Instance],
                edge_renderer: [p.Instance],
                selection_policy: [
                    p.Instance,
                    function () {
                        return new graph_hit_test_policy_1.NodesOnly();
                    }
                ],
                inspection_policy: [
                    p.Instance,
                    function () {
                        return new graph_hit_test_policy_1.NodesOnly();
                    }
                ]
            });
            this.override({ level: 'glyph' });
        };
        GraphRenderer.prototype.get_selection_manager = function () {
            return this.node_renderer.data_source.selection_manager;
        };
        return GraphRenderer;
    }(renderer_1.Renderer);
    exports.GraphRenderer = GraphRenderer;
    GraphRenderer.initClass();    
},
/*models/renderers/guide_renderer*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var renderer_1 = require(173    /* ./renderer */);
    var p = require(15    /* core/properties */);
    var GuideRendererView = function (_super) {
        tslib_1.__extends(GuideRendererView, _super);
        function GuideRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return GuideRendererView;
    }(renderer_1.RendererView);
    exports.GuideRendererView = GuideRendererView;
    var GuideRenderer = function (_super) {
        tslib_1.__extends(GuideRenderer, _super);
        function GuideRenderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        GuideRenderer.initClass = function () {
            this.prototype.type = 'GuideRenderer';
            this.define({ plot: [p.Instance] });
            this.override({ level: 'overlay' });
        };
        return GuideRenderer;
    }(renderer_1.Renderer);
    exports.GuideRenderer = GuideRenderer;
    GuideRenderer.initClass();    
},
/*models/renderers/index*/
function _(require, module, exports) {
    var glyph_renderer_1 = require(169    /* ./glyph_renderer */);
    exports.GlyphRenderer = glyph_renderer_1.GlyphRenderer;
    var graph_renderer_1 = require(170    /* ./graph_renderer */);
    exports.GraphRenderer = graph_renderer_1.GraphRenderer;
    var guide_renderer_1 = require(171    /* ./guide_renderer */);
    exports.GuideRenderer = guide_renderer_1.GuideRenderer;
    var renderer_1 = require(173    /* ./renderer */);
    exports.Renderer = renderer_1.Renderer;    
},
/*models/renderers/renderer*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var dom_view_1 = require(6    /* core/dom_view */);
    var visuals = require(49    /* core/visuals */);
    var p = require(15    /* core/properties */);
    var model_1 = require(53    /* ../../model */);
    // This shouldn't be a DOMView, but annotations create a mess.
    var RendererView = function (_super) {
        tslib_1.__extends(RendererView, _super);
        function RendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        RendererView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.plot_view = options.plot_view;
            this.visuals = new visuals.Visuals(this.model);
            this._has_finished = true;    // XXX: should be in render() but subclasses don't respect super()
        };
        Object.defineProperty(RendererView.prototype, 'plot_model', {
            get: function () {
                return this.plot_view.model;
            },
            enumerable: true,
            configurable: true
        });
        RendererView.prototype.request_render = function () {
            this.plot_view.request_render();
        };
        RendererView.prototype.map_to_screen = function (x, y) {
            return this.plot_view.map_to_screen(x, y, this.model.x_range_name, this.model.y_range_name);
        };
        Object.defineProperty(RendererView.prototype, 'needs_clip', {
            get: function () {
                return false;
            },
            enumerable: true,
            configurable: true
        });
        return RendererView;
    }(dom_view_1.DOMView);
    exports.RendererView = RendererView;
    var Renderer = function (_super) {
        tslib_1.__extends(Renderer, _super);
        function Renderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        Renderer.initClass = function () {
            this.prototype.type = 'Renderer';
            this.define({
                level: [p.RenderLevel],
                visible: [
                    p.Bool,
                    true
                ]
            });
        };
        return Renderer;
    }(model_1.Model);
    exports.Renderer = Renderer;
    Renderer.initClass();    
},
/*models/scales/categorical_scale*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var linear_scale_1 = require(176    /* ./linear_scale */);
    var CategoricalScale = function (_super) {
        tslib_1.__extends(CategoricalScale, _super);
        function CategoricalScale(attrs) {
            return _super.call(this, attrs) || this;
        }
        CategoricalScale.initClass = function () {
            this.prototype.type = 'CategoricalScale';
        };
        CategoricalScale.prototype.compute = function (x) {
            return _super.prototype.compute.call(this, this.source_range.synthetic(x));
        };
        CategoricalScale.prototype.v_compute = function (xs) {
            return _super.prototype.v_compute.call(this, this.source_range.v_synthetic(xs));
        };
        return CategoricalScale;
    }(linear_scale_1.LinearScale);
    exports.CategoricalScale = CategoricalScale;
    CategoricalScale.initClass();    
},
/*models/scales/index*/
function _(require, module, exports) {
    var categorical_scale_1 = require(174    /* ./categorical_scale */);
    exports.CategoricalScale = categorical_scale_1.CategoricalScale;
    var linear_scale_1 = require(176    /* ./linear_scale */);
    exports.LinearScale = linear_scale_1.LinearScale;
    var log_scale_1 = require(177    /* ./log_scale */);
    exports.LogScale = log_scale_1.LogScale;
    var scale_1 = require(178    /* ./scale */);
    exports.Scale = scale_1.Scale;    
},
/*models/scales/linear_scale*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var scale_1 = require(178    /* ./scale */);
    var LinearScale = function (_super) {
        tslib_1.__extends(LinearScale, _super);
        function LinearScale(attrs) {
            return _super.call(this, attrs) || this;
        }
        LinearScale.initClass = function () {
            this.prototype.type = 'LinearScale';
        };
        LinearScale.prototype.compute = function (x) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1];
            return factor * x + offset;
        };
        LinearScale.prototype.v_compute = function (xs) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1];
            var result = new Float64Array(xs.length);
            for (var i = 0; i < xs.length; i++)
                result[i] = factor * xs[i] + offset;
            return result;
        };
        LinearScale.prototype.invert = function (xprime) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1];
            return (xprime - offset) / factor;
        };
        LinearScale.prototype.v_invert = function (xprimes) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1];
            var result = new Float64Array(xprimes.length);
            for (var i = 0; i < xprimes.length; i++)
                result[i] = (xprimes[i] - offset) / factor;
            return result;
        };
        LinearScale.prototype._compute_state = function () {
            //
            //  (t1 - t0)       (t1 - t0)
            //  --------- * x - --------- * s0 + t0
            //  (s1 - s0)       (s1 - s0)
            //
            // [  factor  ]     [    offset    ]
            //
            var source_start = this.source_range.start;
            var source_end = this.source_range.end;
            var target_start = this.target_range.start;
            var target_end = this.target_range.end;
            var factor = (target_end - target_start) / (source_end - source_start);
            var offset = -(factor * source_start) + target_start;
            return [
                factor,
                offset
            ];
        };
        return LinearScale;
    }(scale_1.Scale);
    exports.LinearScale = LinearScale;
    LinearScale.initClass();    
},
/*models/scales/log_scale*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var scale_1 = require(178    /* ./scale */);
    var LogScale = function (_super) {
        tslib_1.__extends(LogScale, _super);
        function LogScale(attrs) {
            return _super.call(this, attrs) || this;
        }
        LogScale.initClass = function () {
            this.prototype.type = 'LogScale';
        };
        LogScale.prototype.compute = function (x) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
            var value;
            if (inter_factor == 0)
                value = 0;
            else {
                var _x = (Math.log(x) - inter_offset) / inter_factor;
                if (isFinite(_x))
                    value = _x * factor + offset;
                else
                    value = NaN;
            }
            return value;
        };
        LogScale.prototype.v_compute = function (xs) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
            var result = new Float64Array(xs.length);
            if (inter_factor == 0) {
                for (var i = 0; i < xs.length; i++)
                    result[i] = 0;
            } else {
                for (var i = 0; i < xs.length; i++) {
                    var _x = (Math.log(xs[i]) - inter_offset) / inter_factor;
                    var value = void 0;
                    if (isFinite(_x))
                        value = _x * factor + offset;
                    else
                        value = NaN;
                    result[i] = value;
                }
            }
            return result;
        };
        LogScale.prototype.invert = function (xprime) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
            var value = (xprime - offset) / factor;
            return Math.exp(inter_factor * value + inter_offset);
        };
        LogScale.prototype.v_invert = function (xprimes) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
            var result = new Float64Array(xprimes.length);
            for (var i = 0; i < xprimes.length; i++) {
                var value = (xprimes[i] - offset) / factor;
                result[i] = Math.exp(inter_factor * value + inter_offset);
            }
            return result;
        };
        LogScale.prototype._get_safe_factor = function (orig_start, orig_end) {
            var start = orig_start < 0 ? 0 : orig_start;
            var end = orig_end < 0 ? 0 : orig_end;
            if (start == end) {
                if (start == 0)
                    _a = [
                        1,
                        10
                    ], start = _a[0], end = _a[1];
                else {
                    var log_val = Math.log(start) / Math.log(10);
                    start = Math.pow(10, Math.floor(log_val));
                    if (Math.ceil(log_val) != Math.floor(log_val))
                        end = Math.pow(10, Math.ceil(log_val));
                    else
                        end = Math.pow(10, Math.ceil(log_val) + 1);
                }
            }
            return [
                start,
                end
            ];
            var _a;
        };
        LogScale.prototype._compute_state = function () {
            var source_start = this.source_range.start;
            var source_end = this.source_range.end;
            var target_start = this.target_range.start;
            var target_end = this.target_range.end;
            var screen_range = target_end - target_start;
            var _a = this._get_safe_factor(source_start, source_end), start = _a[0], end = _a[1];
            var inter_factor;
            var inter_offset;
            if (start == 0) {
                inter_factor = Math.log(end);
                inter_offset = 0;
            } else {
                inter_factor = Math.log(end) - Math.log(start);
                inter_offset = Math.log(start);
            }
            var factor = screen_range;
            var offset = target_start;
            return [
                factor,
                offset,
                inter_factor,
                inter_offset
            ];
        };
        return LogScale;
    }(scale_1.Scale);
    exports.LogScale = LogScale;
    LogScale.initClass();    
},
/*models/scales/scale*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var transforms_1 = require(254    /* ../transforms */);
    var p = require(15    /* core/properties */);
    var Scale = function (_super) {
        tslib_1.__extends(Scale, _super);
        function Scale(attrs) {
            return _super.call(this, attrs) || this;
        }
        Scale.initClass = function () {
            this.prototype.type = 'Scale';
            this.internal({
                source_range: [p.Any],
                target_range: [p.Any]
            });
        };
        Scale.prototype.r_compute = function (x0, x1) {
            if (this.target_range.is_reversed)
                return [
                    this.compute(x1),
                    this.compute(x0)
                ];
            else
                return [
                    this.compute(x0),
                    this.compute(x1)
                ];
        };
        Scale.prototype.r_invert = function (sx0, sx1) {
            if (this.target_range.is_reversed)
                return [
                    this.invert(sx1),
                    this.invert(sx0)
                ];
            else
                return [
                    this.invert(sx0),
                    this.invert(sx1)
                ];
        };
        return Scale;
    }(transforms_1.Transform);
    exports.Scale = Scale;
    Scale.initClass();    
},
/*models/selections/index*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    tslib_1.__exportStar(require(180    /* ./interaction_policy */), exports);
    var selection_1 = require(181    /* ./selection */);
    exports.Selection = selection_1.Selection;    
},
/*models/selections/interaction_policy*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var model_1 = require(53    /* ../../model */);
    var selection_1 = require(181    /* ../selections/selection */);
    var SelectionPolicy = function (_super) {
        tslib_1.__extends(SelectionPolicy, _super);
        function SelectionPolicy() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SelectionPolicy.prototype.do_selection = function (hit_test_result, source, final, append) {
            if (hit_test_result === null) {
                return false;
            } else {
                source.selected.update(hit_test_result, final, append);
                //new selection created in order for python-side change detection machinery
                //to detect change in the source's selected property.
                var selected = new selection_1.Selection();
                selected.update(source.selected, final, false);
                source.selected = selected;
                source._select.emit();
                return !source.selected.is_empty();
            }
        };
        return SelectionPolicy;
    }(model_1.Model);
    exports.SelectionPolicy = SelectionPolicy;
    SelectionPolicy.prototype.type = 'SelectionPolicy';
    var IntersectRenderers = function (_super) {
        tslib_1.__extends(IntersectRenderers, _super);
        function IntersectRenderers() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        IntersectRenderers.prototype.hit_test = function (geometry, renderer_views) {
            var hit_test_result_renderers = [];
            for (var _i = 0, renderer_views_1 = renderer_views; _i < renderer_views_1.length; _i++) {
                var r = renderer_views_1[_i];
                var result = r.hit_test(geometry);
                if (result !== null)
                    hit_test_result_renderers.push(result);
            }
            if (hit_test_result_renderers.length > 0) {
                var hit_test_result = hit_test_result_renderers[0];
                for (var _a = 0, hit_test_result_renderers_1 = hit_test_result_renderers; _a < hit_test_result_renderers_1.length; _a++) {
                    var hit_test_result_other = hit_test_result_renderers_1[_a];
                    hit_test_result.update_through_intersection(hit_test_result_other);
                }
                return hit_test_result;
            } else {
                return null;
            }
        };
        return IntersectRenderers;
    }(SelectionPolicy);
    exports.IntersectRenderers = IntersectRenderers;
    IntersectRenderers.prototype.type = 'IntersectRenderers';
    var UnionRenderers = function (_super) {
        tslib_1.__extends(UnionRenderers, _super);
        function UnionRenderers() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        UnionRenderers.prototype.hit_test = function (geometry, renderer_views) {
            var hit_test_result_renderers = [];
            for (var _i = 0, renderer_views_2 = renderer_views; _i < renderer_views_2.length; _i++) {
                var r = renderer_views_2[_i];
                var result = r.hit_test(geometry);
                if (result !== null)
                    hit_test_result_renderers.push(result);
            }
            if (hit_test_result_renderers.length > 0) {
                var hit_test_result = hit_test_result_renderers[0];
                for (var _a = 0, hit_test_result_renderers_2 = hit_test_result_renderers; _a < hit_test_result_renderers_2.length; _a++) {
                    var hit_test_result_other = hit_test_result_renderers_2[_a];
                    hit_test_result.update_through_union(hit_test_result_other);
                }
                return hit_test_result;
            } else {
                return null;
            }
        };
        return UnionRenderers;
    }(SelectionPolicy);
    exports.UnionRenderers = UnionRenderers;
    UnionRenderers.prototype.type = 'UnionRenderers';    
},
/*models/selections/selection*/
function _(require, module, exports) {
    var tslib_1 = require(380    /* tslib */);
    var model_1 = require(53    /* ../../model */);
    var p = require(15    /* core/properties */);
    var array_1 = require(21    /* core/util/array */);
    var object_1 = require(32    /* core/util/object */);
    var Selection = function (_super) {
        tslib_1.__extends(Selection, _super);
        function Selection(attrs) {
            return _super.call(this, attrs) || this;
        }
        Selection.initClass = function () {
            this.prototype.type = 'Selection';
            this.define({
                indices: [
                    p.Array,
                    []
                ],
                line_indices: [
                    p.Array,
                    []
                ],
                multiline_indices: [
                    p.Any,
                    {}
                ]
            });
            this.internal({
                final: [p.Boolean],
                selected_glyphs: [
                    p.Array,
                    []
                ],
                get_view: [p.Any],
                image_indices: [
                    p.Array,
                    []
                ]
            });
        };
        Selection.prototype.initialize = function () {
            var _this = this;
            _super.prototype.initialize.call(this);
            this['0d'] = {
                'glyph': null,
                'indices': [],
                'flag': false,
                'get_view': function () {
                    return null;
                }
            };
            this['2d'] = { 'indices': {} };
            this['1d'] = { 'indices': this.indices };
            this.get_view = function () {
                return null;
            };
            this.connect(this.properties.indices.change, function () {
                return _this['1d']['indices'] = _this.indices;
            });
            this.connect(this.properties.line_indices.change, function () {
                _this['0d']['indices'] = _this.line_indices;
                if (_this.line_indices.length == 0)
                    _this['0d'].flag = false;
                else
                    _this['0d'].flag = true;
            });
            this.connect(this.properties.selected_glyphs.change, function () {
                return _this['0d'].glyph = _this.selected_glyph;
            });
            this.connect(this.properties.get_view.change, function () {
                return _this['0d'].get_view = _this.get_view;
            });
            this.connect(this.properties.multiline_indices.change, function () {
                return _this['2d'].indices = _this.multiline_indices;
            });
        };
        Object.defineProperty(Selection.prototype, 'selected_glyph', {
            get: function () {
                if (this.selected_glyphs.length > 0)
                    return this.selected_glyphs[0];
                else
                    return null;
            },
            enumerable: true,
            configurable: true
        });
        Selection.prototype.add_to_selected_glyphs = function (glyph) {
            this.selected_glyphs.push(glyph);
        };
        Selection.prototype.update = function (selection, final, append) {
            this.final = final;
            if (append)
                this.update_through_union(selection);
            else {
                this.indices = selection.indices;
                this.line_indices = selection.line_indices;
                this.selected_glyphs = selection.selected_glyphs;
                this.get_view = selection.get_view;
                this.multiline_indices = selection.multiline_indices;
                this.image_indices = selection.image_indices;
            }
        };
        Selection.prototype.clear = function () {
            this.final = true;
            this.indices = [];
            this.line_indices = [];
            this.multiline_indices = {};
            this.get_view = function () {
                return null;
            };
            this.selected_glyphs = [];
        };
        Selection.prototype.is_empty = function () {
            return this.indices.length == 0 && this.line_indices.length == 0 && this.image_indices.length == 0;
        };
        Selection.prototype.update_through_union = function (other) {
            this.indices = array_1.union(other.indices, this.indices);
            this.selected_glyphs = array_1.union(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = array_1.union(other.line_indices, this.line_indices);
            if (!this.get_view())
                this.get_view = other.get_view;
            this.multiline_indices = object_1.merge(other.multiline_indices, this.multiline_indices);
        };
        Selection.prototype.update_through_intersection = function (other) {
            this.indices = array_1.intersection(other.indices, this.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = array_1.union(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = array_1.union(other.line_indices, this.line_indices);
            if (!this.get_view())
                this.get_view = other.get_view;
            this.multiline_indices = object_1.merge(other.multiline_indices, this.multiline_indices);
        };
        return Selection;
    }(model_1.Model);
    exports.Selection = Selection;
    Selection.initClass(); 