# This source code is part of the Biotite package and is distributed
# under the 3-Clause BSD License. Please see 'LICENSE.rst' for further
# information.

from typing import (
    Dict,
    Tuple,
    Union,
    Optional,
    Iterable,
    Iterator,
    Set,
    FrozenSet,
    Container,
    overload,
    Hashable
)
from typing import Sequence as _Sequence
from enum import Enum, Flag
from .sequence import Sequence


class Location:
    class Defect(Flag):
        NONE         = ...
        MISS_LEFT    = ...
        MISS_RIGHT   = ...
        BEYOND_LEFT  = ...
        BEYOND_RIGHT = ...
        UNK_LOC      = ...
        BETWEEN      = ...

    class Strand(Enum):
        FORWARD = ...
        REVERSE = ...
        
    first: int
    last: int
    strand: Strand
    defect: Defect
    def __init__(
        self, first: int, last: int,
        strand: Strand = Strand.FORWARD, defect: Defect = Defect.NONE
    ) -> None: ...
    def __str__(self) -> str: ...
    def __eq__(self, item: object) -> bool: ...
    def __hash__(self) -> int: ...


class Feature:
    key: str
    locs: FrozenSet[Location]
    qual: Dict[str, str]
    def __init__(
        self, key: str, locs: Iterable[Location], qual: Dict[str, str] = {}
    ) -> None: ...
    def get_location_range(self) -> Tuple[int, int]: ...
    def __eq__(self, item: object) -> bool: ...
    def __lt__(self, item: object) -> bool: ...
    def __gt__(self, item: object) -> bool: ...
    def __hash__(self) -> int: ...



class Annotation(Iterable[Feature], Container):
    def __init__(self, features: Optional[Iterable[Feature]] = None) -> None: ...
    def get_features(self) -> Set[Feature]: ...
    def add_feature(self, feature: Feature) -> None: ...
    def get_location_range(self) -> Tuple[int, int]: ...
    def del_feature(self, feature: Feature) -> None: ...
    def __add__(self, item: Union[Annotation, Feature]) -> Annotation: ...
    def __getitem__(self, index: slice) -> Annotation: ...
    def __delitem__(self, item: Feature) -> None: ...
    def __iter__(self) -> Iterator[Feature]: ...
    def __contains__(self, item: object) -> bool: ...
    def __eq__(self, item: object) -> bool: ...


class AnnotatedSequence:
    sequence_start: int
    sequence: Sequence
    annotation: Annotation
    def __init__(
        self,
        annotation: Annotation,
        sequence: Sequence,
        sequence_start: int = 1
    ) -> None: ...
    def reverse_complement(self) -> None: ...
    @overload
    def __getitem__(self, index: slice) -> AnnotatedSequence: ...
    @overload
    def __getitem__(self, index: Feature) -> Sequence: ...
    @overload
    def __getitem__(self, index: int) -> Hashable: ...
    @overload
    def __setitem__(self, index: slice, item: Sequence) -> None: ...
    @overload
    def __setitem__(self, index: Feature, item: Sequence) -> None: ...
    @overload
    def __setitem__(self, index: int, item: Hashable) -> None: ...
    def __eq__(self, item: object) -> bool: ...