set(biorbd_VERSION 1.8.7)

if (biorbd_casadi_INCLUDE_DIR)
  # Already in cache, be silent
  set (biorbd_casadi_FIND_QUIETLY TRUE)
endif (biorbd_casadi_INCLUDE_DIR)

find_path (biorbd_casadi_INCLUDE_DIR "BiorbdModel.h"
    PATHS D:/bld/biorbd_1650566319406/_h_env/Library/include/biorbd_casadi
)
find_library (biorbd_casadi_LIBRARY
    NAMES biorbd_casadi biorbd_casadi_debug
    PATHS D:/bld/biorbd_1650566319406/_h_env/Library/Lib
)

get_filename_component(biorbd_casadi_LIB_PATH ${biorbd_casadi_LIBRARY} DIRECTORY)
get_filename_component(biorbd_casadi_LIB_NAME ${biorbd_casadi_LIBRARY} NAME_WE)
get_filename_component(biorbd_casadi_LIB_EXTENSION ${biorbd_casadi_LIBRARY} EXT)

string(REGEX MATCH "_debug" debug_flag ${biorbd_casadi_LIB_NAME})
if (debug_flag)
    string(REGEX REPLACE ${debug_flag} "" biorbd_casadi_LIB_NAME ${biorbd_casadi_LIB_NAME})
endif()

set(biorbd_casadi_LIBRARIES
    ${biorbd_casadi_LIB_PATH}/${biorbd_casadi_LIB_NAME}${debug_flag}${biorbd_casadi_LIB_EXTENSION}
    ${biorbd_casadi_LIB_PATH}/${biorbd_casadi_LIB_NAME}_utils${debug_flag}${biorbd_casadi_LIB_EXTENSION}
    ${biorbd_casadi_LIB_PATH}/${biorbd_casadi_LIB_NAME}_rigidbody${debug_flag}${biorbd_casadi_LIB_EXTENSION}
    ${biorbd_casadi_LIB_PATH}/${biorbd_casadi_LIB_NAME}_muscles${debug_flag}${biorbd_casadi_LIB_EXTENSION}
    ${biorbd_casadi_LIB_PATH}/${biorbd_casadi_LIB_NAME}_actuators${debug_flag}${biorbd_casadi_LIB_EXTENSION}
)

# handle the QUIETLY and REQUIRED arguments and set biorbd_casadi_FOUND to TRUE if
# all listed variables are TRUE
include (FindPackageHandleStandardArgs)
find_package_handle_standard_args (biorbd_casadi DEFAULT_MSG
  biorbd_casadi_LIBRARIES
  biorbd_casadi_INCLUDE_DIR
)
