set(biorbd_VERSION 1.1.3)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was biorbdConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(biorbd_INCLUDE_DIR "include/biorbd")
set_and_check(biorbd_LIBRARY_DIR "Lib")

find_library (biorbd_LIBRARY NAMES biorbd biorbd_debug PATHS ${biorbd_LIBRARY_DIR})

get_filename_component(biorbd_LIB_PATH ${biorbd_LIBRARY} DIRECTORY)
get_filename_component(biorbd_LIB_NAME ${biorbd_LIBRARY} NAME_WE)
get_filename_component(biorbd_LIB_EXTENSION ${biorbd_LIBRARY} EXT)

string(REGEX MATCH "_debug" debug_flag ${biorbd_LIB_NAME})
if (debug_flag)
    string(REGEX REPLACE ${debug_flag} "" biorbd_LIB_NAME ${biorbd_LIB_NAME})
endif()

set(biorbd_LIBRARIES
    ${biorbd_LIB_PATH}/${biorbd_LIB_NAME}${debug_flag}${biorbd_LIB_EXTENSION}
    ${biorbd_LIB_PATH}/${biorbd_LIB_NAME}_utils${debug_flag}${biorbd_LIB_EXTENSION}
    ${biorbd_LIB_PATH}/${biorbd_LIB_NAME}_rigidbody${debug_flag}${biorbd_LIB_EXTENSION}
    ${biorbd_LIB_PATH}/${biorbd_LIB_NAME}_muscles${debug_flag}${biorbd_LIB_EXTENSION}
    ${biorbd_LIB_PATH}/${biorbd_LIB_NAME}_actuators${debug_flag}${biorbd_LIB_EXTENSION}
)

# handle the QUIETLY and REQUIRED arguments and set DLIB_FOUND to TRUE if 
# all listed variables are TRUE
include (FindPackageHandleStandardArgs)
find_package_handle_standard_args (biorbd DEFAULT_MSG 
  biorbd_INCLUDE_DIR
  biorbd_LIBRARIES
)

check_required_components(biorbd)
