#!/usr/bin/env python
#      Copyright (C) 2004. Frederic Sohm.
#
# This code is part of the Biopython distribution and governed by its
# license.  Please see the LICENSE file that should have been included
# as part of this package.
#
# THIS FILE IS AUTOMATICALLY GENERATED - DO NOT EDIT IT BY HAND!
#
# Instead, use the tool Scripts/Restriction/ranacompiler.py which in turn
# uses Scripts/Restriction/rebase_update.py

"""Restriction Analysis Libraries.

Used REBASE emboss files version 001 (2020).
"""

rest_dict = {}

rest_dict["AanI"] = {
    "charac": (3, -3, None, None, "TTATAA"),
    "compsite": "(?=(?P<AanI>TTATAA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTATAA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["AarI"] = {
    "charac": (11, 8, None, None, "CACCTGC"),
    "compsite": "(?=(?P<AarI>CACCTGC))|(?=(?P<AarI_as>GCAGGTG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": 8,
    "fst5": 11,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACCTGC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["AasI"] = {
    "charac": (7, -7, None, None, "GACNNNNNNGTC"),
    "compsite": "(?=(?P<AasI>GAC......GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNNNNGTC",
    "size": 12,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["AatII"] = {
    "charac": (5, -5, None, None, "GACGTC"),
    "compsite": "(?=(?P<AatII>GACGTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "ACGT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACGTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "I", "K", "M", "N", "V"),
}

rest_dict["Aba6411II"] = {
    "charac": (None, None, None, None, "CRRTAAG"),
    "compsite": "(?=(?P<Aba6411II>C[AG][AG]TAAG))|(?=(?P<Aba6411II_as>CTTA[CT][CT]G))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CRRTAAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AbaB8342IV"] = {
    "charac": (None, None, None, None, "CATTAG"),
    "compsite": "(?=(?P<AbaB8342IV>CATTAG))|(?=(?P<AbaB8342IV_as>CTAATG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATTAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AbaCIII"] = {
    "charac": (None, None, None, None, "CTATCAV"),
    "compsite": "(?=(?P<AbaCIII>CTATCA[ACG]))|(?=(?P<AbaCIII_as>[CGT]TGATAG))",
    "dna": None,
    "freq": 5461.333333333333,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTATCAV",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AbaSI"] = {
    "charac": (12, 9, None, None, "C"),
    "compsite": "(?=(?P<AbaSI>C))|(?=(?P<AbaSI_as>G))",
    "dna": None,
    "freq": 4.0,
    "fst3": 9,
    "fst5": 12,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "C",
    "size": 1,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["AbaUMB2I"] = {
    "charac": (None, None, None, None, "YCCGSS"),
    "compsite": "(?=(?P<AbaUMB2I>[CT]CCG[CG][CG]))|(?=(?P<AbaUMB2I_as>[CG][CG]CGG[AG]))",
    "dna": None,
    "freq": 512.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "YCCGSS",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Abr4036II"] = {
    "charac": (None, None, None, None, "GRTYGACC"),
    "compsite": "(?=(?P<Abr4036II>G[AG]T[CT]GACC))|(?=(?P<Abr4036II_as>GGTC[AG]A[CT]C))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRTYGACC",
    "size": 8,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AbsI"] = {
    "charac": (2, -2, None, None, "CCTCGAGG"),
    "compsite": "(?=(?P<AbsI>CCTCGAGG))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TCGA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTCGAGG",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["Acc16I"] = {
    "charac": (3, -3, None, None, "TGCGCA"),
    "compsite": "(?=(?P<Acc16I>TGCGCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGCGCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Acc36I"] = {
    "charac": (10, 8, None, None, "ACCTGC"),
    "compsite": "(?=(?P<Acc36I>ACCTGC))|(?=(?P<Acc36I_as>GCAGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 8,
    "fst5": 10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCTGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["Acc65I"] = {
    "charac": (1, -1, None, None, "GGTACC"),
    "compsite": "(?=(?P<Acc65I>GGTACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GTAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTACC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "I", "N", "V"),
}

rest_dict["Acc65V"] = {
    "charac": (None, None, None, None, "GACGCA"),
    "compsite": "(?=(?P<Acc65V>GACGCA))|(?=(?P<Acc65V_as>TGCGTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACGCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AccB1I"] = {
    "charac": (1, -1, None, None, "GGYRCC"),
    "compsite": "(?=(?P<AccB1I>GG[CT][AG]CC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GYRC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGYRCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["AccB7I"] = {
    "charac": (7, -7, None, None, "CCANNNNNTGG"),
    "compsite": "(?=(?P<AccB7I>CCA.....TGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCANNNNNTGG",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["AccBSI"] = {
    "charac": (3, -3, None, None, "CCGCTC"),
    "compsite": "(?=(?P<AccBSI>CCGCTC))|(?=(?P<AccBSI_as>GAGCGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["AccI"] = {
    "charac": (2, -2, None, None, "GTMKAC"),
    "compsite": "(?=(?P<AccI>GT[AC][GT]AC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "MK",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTMKAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "J", "K", "M", "N", "Q", "R", "X"),
}

rest_dict["AccII"] = {
    "charac": (2, -2, None, None, "CGCG"),
    "compsite": "(?=(?P<AccII>CGCG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("J", "K"),
}

rest_dict["AccIII"] = {
    "charac": (1, -1, None, None, "TCCGGA"),
    "compsite": "(?=(?P<AccIII>TCCGGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCCGGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J", "K", "R"),
}

rest_dict["AceIII"] = {
    "charac": (13, 11, None, None, "CAGCTC"),
    "compsite": "(?=(?P<AceIII>CAGCTC))|(?=(?P<AceIII_as>GAGCTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 11,
    "fst5": 13,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAGCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AchA6III"] = {
    "charac": (None, None, None, None, "AGCCAG"),
    "compsite": "(?=(?P<AchA6III>AGCCAG))|(?=(?P<AchA6III_as>CTGGCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGCCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AciI"] = {
    "charac": (1, -1, None, None, "CCGC"),
    "compsite": "(?=(?P<AciI>CCGC))|(?=(?P<AciI_as>GCGG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["AclI"] = {
    "charac": (2, -2, None, None, "AACGTT"),
    "compsite": "(?=(?P<AclI>AACGTT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AACGTT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "N", "V"),
}

rest_dict["AclWI"] = {
    "charac": (9, 5, None, None, "GGATC"),
    "compsite": "(?=(?P<AclWI>GGATC))|(?=(?P<AclWI_as>GATCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 9,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGATC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["Aco12261II"] = {
    "charac": (None, None, None, None, "CCRGAG"),
    "compsite": "(?=(?P<Aco12261II>CC[AG]GAG))|(?=(?P<Aco12261II_as>CTC[CT]GG))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCRGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AcoI"] = {
    "charac": (1, -1, None, None, "YGGCCR"),
    "compsite": "(?=(?P<AcoI>[CT]GGCC[AG]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "YGGCCR",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["AcoY31II"] = {
    "charac": (None, None, None, None, "TAGCRAB"),
    "compsite": "(?=(?P<AcoY31II>TAGC[AG]A[CGT]))|(?=(?P<AcoY31II_as>[ACG]T[CT]GCTA))",
    "dna": None,
    "freq": 2730.6666666666665,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TAGCRAB",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AcsI"] = {
    "charac": (1, -1, None, None, "RAATTY"),
    "compsite": "(?=(?P<AcsI>[AG]AATT[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "AATT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RAATTY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["AcuI"] = {
    "charac": (22, 14, None, None, "CTGAAG"),
    "compsite": "(?=(?P<AcuI>CTGAAG))|(?=(?P<AcuI_as>CTTCAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 14,
    "fst5": 22,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTGAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "N"),
}

rest_dict["AcvI"] = {
    "charac": (3, -3, None, None, "CACGTG"),
    "compsite": "(?=(?P<AcvI>CACGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGTG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("Q", "X"),
}

rest_dict["AcyI"] = {
    "charac": (2, -2, None, None, "GRCGYC"),
    "compsite": "(?=(?P<AcyI>G[AG]CG[CT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRCGYC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J",),
}

rest_dict["AdeI"] = {
    "charac": (6, -6, None, None, "CACNNNGTG"),
    "compsite": "(?=(?P<AdeI>CAC...GTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACNNNGTG",
    "size": 9,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Adh6U21I"] = {
    "charac": (None, None, None, None, "GAANCAG"),
    "compsite": "(?=(?P<Adh6U21I>GAA.CAG))|(?=(?P<Adh6U21I_as>CTG.TTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAANCAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AfaI"] = {
    "charac": (2, -2, None, None, "GTAC"),
    "compsite": "(?=(?P<AfaI>GTAC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTAC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["AfeI"] = {
    "charac": (3, -3, None, None, "AGCGCT"),
    "compsite": "(?=(?P<AfeI>AGCGCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGCGCT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "N"),
}

rest_dict["AfiI"] = {
    "charac": (7, -7, None, None, "CCNNNNNNNGG"),
    "compsite": "(?=(?P<AfiI>CC.......GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNNNNNNNGG",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["AflII"] = {
    "charac": (1, -1, None, None, "CTTAAG"),
    "compsite": "(?=(?P<AflII>CTTAAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TTAA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTTAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J", "K", "N"),
}

rest_dict["AflIII"] = {
    "charac": (1, -1, None, None, "ACRYGT"),
    "compsite": "(?=(?P<AflIII>AC[AG][CT]GT))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CRYG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACRYGT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("M", "N", "S"),
}

rest_dict["AgeI"] = {
    "charac": (1, -1, None, None, "ACCGGT"),
    "compsite": "(?=(?P<AgeI>ACCGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCGGT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J", "N", "R"),
}

rest_dict["AgsI"] = {
    "charac": (3, -3, None, None, "TTSAA"),
    "compsite": "(?=(?P<AgsI>TT[CG]AA))",
    "dna": None,
    "freq": 512.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "S",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTSAA",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["AhaIII"] = {
    "charac": (3, -3, None, None, "TTTAAA"),
    "compsite": "(?=(?P<AhaIII>TTTAAA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTTAAA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AhdI"] = {
    "charac": (6, -6, None, None, "GACNNNNNGTC"),
    "compsite": "(?=(?P<AhdI>GAC.....GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNNNGTC",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["AhlI"] = {
    "charac": (1, -1, None, None, "ACTAGT"),
    "compsite": "(?=(?P<AhlI>ACTAGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CTAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACTAGT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["AhyRBAHI"] = {
    "charac": (None, None, None, None, "GCYYGAC"),
    "compsite": "(?=(?P<AhyRBAHI>GC[CT][CT]GAC))|(?=(?P<AhyRBAHI_as>GTC[AG][AG]GC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCYYGAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AhyYL17I"] = {
    "charac": (None, None, None, None, "YAAMGAG"),
    "compsite": "(?=(?P<AhyYL17I>[CT]AA[AC]GAG))|(?=(?P<AhyYL17I_as>CTC[GT]TT[AG]))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "YAAMGAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AjiI"] = {
    "charac": (3, -3, None, None, "CACGTC"),
    "compsite": "(?=(?P<AjiI>CACGTC))|(?=(?P<AjiI_as>GACGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["AjnI"] = {
    "charac": (0, 0, None, None, "CCWGG"),
    "compsite": "(?=(?P<AjnI>CC[AT]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "CCWGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["AjuI"] = {
    "charac": (-7, -26, 25, 6, "GAANNNNNNNTTGG"),
    "compsite": "(?=(?P<AjuI>GAA.......TTGG))|(?=(?P<AjuI_as>CCAA.......TTC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": -26,
    "fst5": -7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": 6,
    "scd5": 25,
    "site": "GAANNNNNNNTTGG",
    "size": 14,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["AleI"] = {
    "charac": (5, -5, None, None, "CACNNNNGTG"),
    "compsite": "(?=(?P<AleI>CAC....GTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACNNNNGTG",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["AlfI"] = {
    "charac": (-10, -24, 24, 10, "GCANNNNNNTGC"),
    "compsite": "(?=(?P<AlfI>GCA......TGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -24,
    "fst5": -10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": 10,
    "scd5": 24,
    "site": "GCANNNNNNTGC",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AloI"] = {
    "charac": (-7, -25, 25, 7, "GAACNNNNNNTCC"),
    "compsite": "(?=(?P<AloI>GAAC......TCC))|(?=(?P<AloI_as>GGA......GTTC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": -25,
    "fst5": -7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": 7,
    "scd5": 25,
    "site": "GAACNNNNNNTCC",
    "size": 13,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["AluBI"] = {
    "charac": (2, -2, None, None, "AGCT"),
    "compsite": "(?=(?P<AluBI>AGCT))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGCT",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["AluI"] = {
    "charac": (2, -2, None, None, "AGCT"),
    "compsite": "(?=(?P<AluI>AGCT))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGCT",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X", "Y"),
}

rest_dict["Alw21I"] = {
    "charac": (5, -5, None, None, "GWGCWC"),
    "compsite": "(?=(?P<Alw21I>G[AT]GC[AT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "WGCW",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GWGCWC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Alw26I"] = {
    "charac": (6, 5, None, None, "GTCTC"),
    "compsite": "(?=(?P<Alw26I>GTCTC))|(?=(?P<Alw26I_as>GAGAC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTCTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Alw44I"] = {
    "charac": (1, -1, None, None, "GTGCAC"),
    "compsite": "(?=(?P<Alw44I>GTGCAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TGCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTGCAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "J"),
}

rest_dict["AlwFI"] = {
    "charac": (None, None, None, None, "GAAAYNNNNNRTG"),
    "compsite": "(?=(?P<AlwFI>GAAA[CT].....[AG]TG))|(?=(?P<AlwFI_as>CA[CT].....[AG]TTTC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAAYNNNNNRTG",
    "size": 13,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AlwI"] = {
    "charac": (9, 5, None, None, "GGATC"),
    "compsite": "(?=(?P<AlwI>GGATC))|(?=(?P<AlwI_as>GATCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 9,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGATC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["AlwNI"] = {
    "charac": (6, -6, None, None, "CAGNNNCTG"),
    "compsite": "(?=(?P<AlwNI>CAG...CTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAGNNNCTG",
    "size": 9,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Ama87I"] = {
    "charac": (1, -1, None, None, "CYCGRG"),
    "compsite": "(?=(?P<Ama87I>C[CT]CG[AG]G))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "YCGR",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CYCGRG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["AmaCSI"] = {
    "charac": (17, 9, None, None, "GCTCCA"),
    "compsite": "(?=(?P<AmaCSI>GCTCCA))|(?=(?P<AmaCSI_as>TGGAGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 9,
    "fst5": 17,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTCCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Aod1I"] = {
    "charac": (None, None, None, None, "GATCNAC"),
    "compsite": "(?=(?P<Aod1I>GATC.AC))|(?=(?P<Aod1I_as>GT.GATC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATCNAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Aor13HI"] = {
    "charac": (1, -1, None, None, "TCCGGA"),
    "compsite": "(?=(?P<Aor13HI>TCCGGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCCGGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["Aor51HI"] = {
    "charac": (3, -3, None, None, "AGCGCT"),
    "compsite": "(?=(?P<Aor51HI>AGCGCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGCGCT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["AoxI"] = {
    "charac": (0, 0, None, None, "GGCC"),
    "compsite": "(?=(?P<AoxI>GGCC))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["ApaBI"] = {
    "charac": (8, -8, None, None, "GCANNNNNTGC"),
    "compsite": "(?=(?P<ApaBI>GCA.....TGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -8,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCANNNNNTGC",
    "size": 11,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["ApaI"] = {
    "charac": (5, -5, None, None, "GGGCCC"),
    "compsite": "(?=(?P<ApaI>GGGCCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGGCCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "I", "J", "K", "M", "N", "Q", "R", "S", "V", "X"),
}

rest_dict["ApaLI"] = {
    "charac": (1, -1, None, None, "GTGCAC"),
    "compsite": "(?=(?P<ApaLI>GTGCAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TGCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTGCAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C", "K", "N"),
}

rest_dict["ApeKI"] = {
    "charac": (1, -1, None, None, "GCWGC"),
    "compsite": "(?=(?P<ApeKI>GC[AT]GC))",
    "dna": None,
    "freq": 512.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "CWG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCWGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["ApoI"] = {
    "charac": (1, -1, None, None, "RAATTY"),
    "compsite": "(?=(?P<ApoI>[AG]AATT[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "AATT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RAATTY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["ApyPI"] = {
    "charac": (26, 18, None, None, "ATCGAC"),
    "compsite": "(?=(?P<ApyPI>ATCGAC))|(?=(?P<ApyPI_as>GTCGAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 18,
    "fst5": 26,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATCGAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AquII"] = {
    "charac": (27, 18, None, None, "GCCGNAC"),
    "compsite": "(?=(?P<AquII>GCCG.AC))|(?=(?P<AquII_as>GT.CGGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 18,
    "fst5": 27,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCGNAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AquIII"] = {
    "charac": (26, 18, None, None, "GAGGAG"),
    "compsite": "(?=(?P<AquIII>GAGGAG))|(?=(?P<AquIII_as>CTCCTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 18,
    "fst5": 26,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AquIV"] = {
    "charac": (26, 17, None, None, "GRGGAAG"),
    "compsite": "(?=(?P<AquIV>G[AG]GGAAG))|(?=(?P<AquIV_as>CTTCC[CT]C))",
    "dna": None,
    "freq": 8192.0,
    "fst3": 17,
    "fst5": 26,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRGGAAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["ArsI"] = {
    "charac": (-8, -26, 24, 6, "GACNNNNNNTTYG"),
    "compsite": "(?=(?P<ArsI>GAC......TT[CT]G))|(?=(?P<ArsI_as>C[AG]AA......GTC))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -26,
    "fst5": -8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": 6,
    "scd5": 24,
    "site": "GACNNNNNNTTYG",
    "size": 13,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["AscI"] = {
    "charac": (2, -2, None, None, "GGCGCGCC"),
    "compsite": "(?=(?P<AscI>GGCGCGCC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CGCG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGCGCC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["AseI"] = {
    "charac": (2, -2, None, None, "ATTAAT"),
    "compsite": "(?=(?P<AseI>ATTAAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATTAAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J", "N"),
}

rest_dict["Asi256I"] = {
    "charac": (1, -1, None, None, "GATC"),
    "compsite": "(?=(?P<Asi256I>GATC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "AT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATC",
    "size": 4,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AsiGI"] = {
    "charac": (1, -1, None, None, "ACCGGT"),
    "compsite": "(?=(?P<AsiGI>ACCGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCGGT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["AsiSI"] = {
    "charac": (5, -5, None, None, "GCGATCGC"),
    "compsite": "(?=(?P<AsiSI>GCGATCGC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "AT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGATCGC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("I", "N"),
}

rest_dict["Asp103I"] = {
    "charac": (None, None, None, None, "CGRAGGC"),
    "compsite": "(?=(?P<Asp103I>CG[AG]AGGC))|(?=(?P<Asp103I_as>GCCT[CT]CG))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGRAGGC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Asp114pII"] = {
    "charac": (None, None, None, None, "AGCABCC"),
    "compsite": "(?=(?P<Asp114pII>AGCA[CGT]CC))|(?=(?P<Asp114pII_as>GG[ACG]TGCT))",
    "dna": None,
    "freq": 5461.333333333333,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGCABCC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Asp337I"] = {
    "charac": (None, None, None, None, "CARABGG"),
    "compsite": "(?=(?P<Asp337I>CA[AG]A[CGT]GG))|(?=(?P<Asp337I_as>CC[ACG]T[CT]TG))",
    "dna": None,
    "freq": 2730.6666666666665,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CARABGG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Asp700I"] = {
    "charac": (5, -5, None, None, "GAANNNNTTC"),
    "compsite": "(?=(?P<Asp700I>GAA....TTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAANNNNTTC",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("M",),
}

rest_dict["Asp718I"] = {
    "charac": (1, -1, None, None, "GGTACC"),
    "compsite": "(?=(?P<Asp718I>GGTACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GTAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTACC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("M", "S"),
}

rest_dict["AspA2I"] = {
    "charac": (1, -1, None, None, "CCTAGG"),
    "compsite": "(?=(?P<AspA2I>CCTAGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CTAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTAGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["AspAMDIV"] = {
    "charac": (None, None, None, None, "ACCCAC"),
    "compsite": "(?=(?P<AspAMDIV>ACCCAC))|(?=(?P<AspAMDIV_as>GTGGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCCAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AspBHI"] = {
    "charac": (13, 12, None, None, "YSCNS"),
    "compsite": "(?=(?P<AspBHI>[CT][CG]C.[CG]))|(?=(?P<AspBHI_as>[CG].G[CG][AG]))",
    "dna": None,
    "freq": 32.0,
    "fst3": 12,
    "fst5": 13,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "YSCNS",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AspDUT2V"] = {
    "charac": (None, None, None, None, "GNGCAAC"),
    "compsite": "(?=(?P<AspDUT2V>G.GCAAC))|(?=(?P<AspDUT2V_as>GTTGC.C))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GNGCAAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AspJHL3II"] = {
    "charac": (None, None, None, None, "CGCCCAG"),
    "compsite": "(?=(?P<AspJHL3II>CGCCCAG))|(?=(?P<AspJHL3II_as>CTGGGCG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCCCAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AspLEI"] = {
    "charac": (3, -3, None, None, "GCGC"),
    "compsite": "(?=(?P<AspLEI>GCGC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["AspNIH4III"] = {
    "charac": (None, None, None, None, "AAGAACB"),
    "compsite": "(?=(?P<AspNIH4III>AAGAAC[CGT]))|(?=(?P<AspNIH4III_as>[ACG]GTTCTT))",
    "dna": None,
    "freq": 5461.333333333333,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AAGAACB",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AspS9I"] = {
    "charac": (1, -1, None, None, "GGNCC"),
    "compsite": "(?=(?P<AspS9I>GG.CC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GNC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGNCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["AspSLV7III"] = {
    "charac": (None, None, None, None, "GTCTCA"),
    "compsite": "(?=(?P<AspSLV7III>GTCTCA))|(?=(?P<AspSLV7III_as>TGAGAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTCTCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Asu14238IV"] = {
    "charac": (None, None, None, None, "CGTRAC"),
    "compsite": "(?=(?P<Asu14238IV>CGT[AG]AC))|(?=(?P<Asu14238IV_as>GT[CT]ACG))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGTRAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AsuC2I"] = {
    "charac": (2, -2, None, None, "CCSGG"),
    "compsite": "(?=(?P<AsuC2I>CC[CG]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "S",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCSGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["AsuHPI"] = {
    "charac": (13, 7, None, None, "GGTGA"),
    "compsite": "(?=(?P<AsuHPI>GGTGA))|(?=(?P<AsuHPI_as>TCACC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 7,
    "fst5": 13,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTGA",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["AsuI"] = {
    "charac": (1, -1, None, None, "GGNCC"),
    "compsite": "(?=(?P<AsuI>GG.CC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GNC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGNCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AsuII"] = {
    "charac": (2, -2, None, None, "TTCGAA"),
    "compsite": "(?=(?P<AsuII>TTCGAA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTCGAA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C",),
}

rest_dict["AsuNHI"] = {
    "charac": (1, -1, None, None, "GCTAGC"),
    "compsite": "(?=(?P<AsuNHI>GCTAGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CTAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTAGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["AteTI"] = {
    "charac": (None, None, None, None, "GGGRAG"),
    "compsite": "(?=(?P<AteTI>GGG[AG]AG))|(?=(?P<AteTI_as>CT[CT]CCC))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGGRAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AvaI"] = {
    "charac": (1, -1, None, None, "CYCGRG"),
    "compsite": "(?=(?P<AvaI>C[CT]CG[AG]G))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "YCGR",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CYCGRG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J", "N", "Q", "X"),
}

rest_dict["AvaII"] = {
    "charac": (1, -1, None, None, "GGWCC"),
    "compsite": "(?=(?P<AvaII>GG[AT]CC))",
    "dna": None,
    "freq": 512.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGWCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("J", "N", "R", "X"),
}

rest_dict["AvaIII"] = {
    "charac": (None, None, None, None, "ATGCAT"),
    "compsite": "(?=(?P<AvaIII>ATGCAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATGCAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AvrII"] = {
    "charac": (1, -1, None, None, "CCTAGG"),
    "compsite": "(?=(?P<AvrII>CCTAGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CTAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTAGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Awo1030IV"] = {
    "charac": (None, None, None, None, "GCCRAG"),
    "compsite": "(?=(?P<Awo1030IV>GCC[AG]AG))|(?=(?P<Awo1030IV_as>CT[CT]GGC))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCRAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["AxyI"] = {
    "charac": (2, -2, None, None, "CCTNAGG"),
    "compsite": "(?=(?P<AxyI>CCT.AGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TNA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTNAGG",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("J",),
}

rest_dict["BaeGI"] = {
    "charac": (5, -5, None, None, "GKGCMC"),
    "compsite": "(?=(?P<BaeGI>G[GT]GC[AC]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "KGCM",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GKGCMC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BaeI"] = {
    "charac": (-10, -26, 23, 7, "ACNNNNGTAYC"),
    "compsite": "(?=(?P<BaeI>AC....GTA[CT]C))|(?=(?P<BaeI_as>G[AG]TAC....GT))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -26,
    "fst5": -10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": 7,
    "scd5": 23,
    "site": "ACNNNNGTAYC",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Bag18758I"] = {
    "charac": (None, None, None, None, "CCCGAG"),
    "compsite": "(?=(?P<Bag18758I>CCCGAG))|(?=(?P<Bag18758I_as>CTCGGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BalI"] = {
    "charac": (3, -3, None, None, "TGGCCA"),
    "compsite": "(?=(?P<BalI>TGGCCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGGCCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "J", "K", "Q", "R", "X"),
}

rest_dict["BamHI"] = {
    "charac": (1, -1, None, None, "GGATCC"),
    "compsite": "(?=(?P<BamHI>GGATCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGATCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X", "Y"),
}

rest_dict["BanI"] = {
    "charac": (1, -1, None, None, "GGYRCC"),
    "compsite": "(?=(?P<BanI>GG[CT][AG]CC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GYRC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGYRCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N", "R"),
}

rest_dict["BanII"] = {
    "charac": (5, -5, None, None, "GRGCYC"),
    "compsite": "(?=(?P<BanII>G[AG]GC[CT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "RGCY",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRGCYC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("K", "N", "X"),
}

rest_dict["BanLI"] = {
    "charac": (None, None, None, None, "RTCAGG"),
    "compsite": "(?=(?P<BanLI>[AG]TCAGG))|(?=(?P<BanLI_as>CCTGA[CT]))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RTCAGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BarI"] = {
    "charac": (-7, -25, 25, 7, "GAAGNNNNNNTAC"),
    "compsite": "(?=(?P<BarI>GAAG......TAC))|(?=(?P<BarI_as>GTA......CTTC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": -25,
    "fst5": -7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": 7,
    "scd5": 25,
    "site": "GAAGNNNNNNTAC",
    "size": 13,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["Bau1417V"] = {
    "charac": (None, None, None, None, "GTTCAG"),
    "compsite": "(?=(?P<Bau1417V>GTTCAG))|(?=(?P<Bau1417V_as>CTGAAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTTCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BauI"] = {
    "charac": (1, -1, None, None, "CACGAG"),
    "compsite": "(?=(?P<BauI>CACGAG))|(?=(?P<BauI_as>CTCGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "ACGA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Bbr52II"] = {
    "charac": (None, None, None, None, "GGCGAG"),
    "compsite": "(?=(?P<Bbr52II>GGCGAG))|(?=(?P<Bbr52II_as>CTCGCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Bbr57III"] = {
    "charac": (None, None, None, None, "GTRAAYG"),
    "compsite": "(?=(?P<Bbr57III>GT[AG]AA[CT]G))|(?=(?P<Bbr57III_as>C[AG]TT[CT]AC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTRAAYG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Bbr7017II"] = {
    "charac": (None, None, None, None, "CGGGAG"),
    "compsite": "(?=(?P<Bbr7017II>CGGGAG))|(?=(?P<Bbr7017II_as>CTCCCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Bbr7017III"] = {
    "charac": (None, None, None, None, "GGRCAG"),
    "compsite": "(?=(?P<Bbr7017III>GG[AG]CAG))|(?=(?P<Bbr7017III_as>CTG[CT]CC))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGRCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BbrPI"] = {
    "charac": (3, -3, None, None, "CACGTG"),
    "compsite": "(?=(?P<BbrPI>CACGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGTG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("M",),
}

rest_dict["BbsI"] = {
    "charac": (8, 6, None, None, "GAAGAC"),
    "compsite": "(?=(?P<BbsI>GAAGAC))|(?=(?P<BbsI_as>GTCTTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 6,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAGAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BbuB31I"] = {
    "charac": (None, None, None, None, "GNAAYG"),
    "compsite": "(?=(?P<BbuB31I>G.AA[CT]G))|(?=(?P<BbuB31I_as>C[AG]TT.C))",
    "dna": None,
    "freq": 512.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GNAAYG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BbuB31II"] = {
    "charac": (None, None, None, None, "CGRKA"),
    "compsite": "(?=(?P<BbuB31II>CG[AG][GT]A))|(?=(?P<BbuB31II_as>T[AC][CT]CG))",
    "dna": None,
    "freq": 256.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGRKA",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Bbv12I"] = {
    "charac": (5, -5, None, None, "GWGCWC"),
    "compsite": "(?=(?P<Bbv12I>G[AT]GC[AT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "WGCW",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GWGCWC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BbvCI"] = {
    "charac": (2, -2, None, None, "CCTCAGC"),
    "compsite": "(?=(?P<BbvCI>CCTCAGC))|(?=(?P<BbvCI_as>GCTGAGG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTCAGC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BbvI"] = {
    "charac": (13, 12, None, None, "GCAGC"),
    "compsite": "(?=(?P<BbvI>GCAGC))|(?=(?P<BbvI_as>GCTGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 12,
    "fst5": 13,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCAGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BbvII"] = {
    "charac": (8, 6, None, None, "GAAGAC"),
    "compsite": "(?=(?P<BbvII>GAAGAC))|(?=(?P<BbvII_as>GTCTTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 6,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAGAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BccI"] = {
    "charac": (9, 5, None, None, "CCATC"),
    "compsite": "(?=(?P<BccI>CCATC))|(?=(?P<BccI_as>GATGG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 9,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCATC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Bce3081I"] = {
    "charac": (None, None, None, None, "TAGGAG"),
    "compsite": "(?=(?P<Bce3081I>TAGGAG))|(?=(?P<Bce3081I_as>CTCCTA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TAGGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Bce83I"] = {
    "charac": (22, 14, None, None, "CTTGAG"),
    "compsite": "(?=(?P<Bce83I>CTTGAG))|(?=(?P<Bce83I_as>CTCAAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 14,
    "fst5": 22,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTTGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BceAI"] = {
    "charac": (17, 14, None, None, "ACGGC"),
    "compsite": "(?=(?P<BceAI>ACGGC))|(?=(?P<BceAI_as>GCCGT))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 14,
    "fst5": 17,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACGGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BceSIV"] = {
    "charac": (-7, -10, 14, 11, "GCAGC"),
    "compsite": "(?=(?P<BceSIV>GCAGC))|(?=(?P<BceSIV_as>GCTGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -10,
    "fst5": -7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": 11,
    "scd5": 14,
    "site": "GCAGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BcefI"] = {
    "charac": (17, 13, None, None, "ACGGC"),
    "compsite": "(?=(?P<BcefI>ACGGC))|(?=(?P<BcefI_as>GCCGT))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 13,
    "fst5": 17,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACGGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BcgI"] = {
    "charac": (-10, -24, 24, 10, "CGANNNNNNTGC"),
    "compsite": "(?=(?P<BcgI>CGA......TGC))|(?=(?P<BcgI_as>GCA......TCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -24,
    "fst5": -10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": 10,
    "scd5": 24,
    "site": "CGANNNNNNTGC",
    "size": 12,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BciT130I"] = {
    "charac": (2, -2, None, None, "CCWGG"),
    "compsite": "(?=(?P<BciT130I>CC[AT]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "W",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["BciVI"] = {
    "charac": (12, 5, None, None, "GTATCC"),
    "compsite": "(?=(?P<BciVI>GTATCC))|(?=(?P<BciVI_as>GGATAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 5,
    "fst5": 12,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTATCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BclI"] = {
    "charac": (1, -1, None, None, "TGATCA"),
    "compsite": "(?=(?P<BclI>TGATCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGATCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "J", "M", "N", "O", "R", "S"),
}

rest_dict["BcnI"] = {
    "charac": (2, -2, None, None, "CCSGG"),
    "compsite": "(?=(?P<BcnI>CC[CG]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "S",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCSGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["BcoDI"] = {
    "charac": (6, 5, None, None, "GTCTC"),
    "compsite": "(?=(?P<BcoDI>GTCTC))|(?=(?P<BcoDI_as>GAGAC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTCTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BcuI"] = {
    "charac": (1, -1, None, None, "ACTAGT"),
    "compsite": "(?=(?P<BcuI>ACTAGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CTAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACTAGT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BdaI"] = {
    "charac": (-10, -24, 24, 10, "TGANNNNNNTCA"),
    "compsite": "(?=(?P<BdaI>TGA......TCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -24,
    "fst5": -10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": 10,
    "scd5": 24,
    "site": "TGANNNNNNTCA",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BetI"] = {
    "charac": (1, -1, None, None, "WCCGGW"),
    "compsite": "(?=(?P<BetI>[AT]CCGG[AT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "WCCGGW",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BfaI"] = {
    "charac": (1, -1, None, None, "CTAG"),
    "compsite": "(?=(?P<BfaI>CTAG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTAG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BfaSII"] = {
    "charac": (None, None, None, None, "GANGGAG"),
    "compsite": "(?=(?P<BfaSII>GA.GGAG))|(?=(?P<BfaSII_as>CTCC.TC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GANGGAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BfiI"] = {
    "charac": (11, 4, None, None, "ACTGGG"),
    "compsite": "(?=(?P<BfiI>ACTGGG))|(?=(?P<BfiI_as>CCCAGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 4,
    "fst5": 11,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACTGGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BfmI"] = {
    "charac": (1, -1, None, None, "CTRYAG"),
    "compsite": "(?=(?P<BfmI>CT[AG][CT]AG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TRYA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTRYAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BfoI"] = {
    "charac": (5, -5, None, None, "RGCGCY"),
    "compsite": "(?=(?P<BfoI>[AG]GCGC[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "GCGC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGCGCY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BfrI"] = {
    "charac": (1, -1, None, None, "CTTAAG"),
    "compsite": "(?=(?P<BfrI>CTTAAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TTAA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTTAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("M", "S"),
}

rest_dict["BfuAI"] = {
    "charac": (10, 8, None, None, "ACCTGC"),
    "compsite": "(?=(?P<BfuAI>ACCTGC))|(?=(?P<BfuAI_as>GCAGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 8,
    "fst5": 10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCTGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BfuI"] = {
    "charac": (12, 5, None, None, "GTATCC"),
    "compsite": "(?=(?P<BfuI>GTATCC))|(?=(?P<BfuI_as>GGATAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 5,
    "fst5": 12,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTATCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Bga514I"] = {
    "charac": (None, None, None, None, "GTRAAG"),
    "compsite": "(?=(?P<Bga514I>GT[AG]AAG))|(?=(?P<Bga514I_as>CTT[CT]AC))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTRAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BglI"] = {
    "charac": (7, -7, None, None, "GCCNNNNNGGC"),
    "compsite": "(?=(?P<BglI>GCC.....GGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCNNNNNGGC",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "N", "O", "Q", "R", "V", "X"),
}

rest_dict["BglII"] = {
    "charac": (1, -1, None, None, "AGATCT"),
    "compsite": "(?=(?P<BglII>AGATCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGATCT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X"),
}

rest_dict["BinI"] = {
    "charac": (9, 5, None, None, "GGATC"),
    "compsite": "(?=(?P<BinI>GGATC))|(?=(?P<BinI_as>GATCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 9,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGATC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BisI"] = {
    "charac": (2, -2, None, None, "GCNGC"),
    "compsite": "(?=(?P<BisI>GC.GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BkrAM31DI"] = {
    "charac": (None, None, None, None, "RTTAAATM"),
    "compsite": "(?=(?P<BkrAM31DI>[AG]TTAAAT[AC]))|(?=(?P<BkrAM31DI_as>[GT]ATTTAA[CT]))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RTTAAATM",
    "size": 8,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Ble402II"] = {
    "charac": (None, None, None, None, "GRAGCAG"),
    "compsite": "(?=(?P<Ble402II>G[AG]AGCAG))|(?=(?P<Ble402II_as>CTGCT[CT]C))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRAGCAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BlnI"] = {
    "charac": (1, -1, None, None, "CCTAGG"),
    "compsite": "(?=(?P<BlnI>CCTAGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CTAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTAGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("K", "M", "S"),
}

rest_dict["BloAII"] = {
    "charac": (None, None, None, None, "GAGGAC"),
    "compsite": "(?=(?P<BloAII>GAGGAC))|(?=(?P<BloAII_as>GTCCTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGGAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BlpI"] = {
    "charac": (2, -2, None, None, "GCTNAGC"),
    "compsite": "(?=(?P<BlpI>GCT.AGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TNA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTNAGC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BlsI"] = {
    "charac": (3, -3, None, None, "GCNGC"),
    "compsite": "(?=(?P<BlsI>GC.GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BmcAI"] = {
    "charac": (3, -3, None, None, "AGTACT"),
    "compsite": "(?=(?P<BmcAI>AGTACT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGTACT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["Bme1390I"] = {
    "charac": (2, -2, None, None, "CCNGG"),
    "compsite": "(?=(?P<Bme1390I>CC.GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Bme18I"] = {
    "charac": (1, -1, None, None, "GGWCC"),
    "compsite": "(?=(?P<Bme18I>GG[AT]CC))",
    "dna": None,
    "freq": 512.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGWCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BmeDI"] = {
    "charac": (3, 0, None, None, "C"),
    "compsite": "(?=(?P<BmeDI>C))|(?=(?P<BmeDI_as>G))",
    "dna": None,
    "freq": 4.0,
    "fst3": 0,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "C",
    "size": 1,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BmeRI"] = {
    "charac": (6, -6, None, None, "GACNNNNNGTC"),
    "compsite": "(?=(?P<BmeRI>GAC.....GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNNNGTC",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["BmeT110I"] = {
    "charac": (1, -1, None, None, "CYCGRG"),
    "compsite": "(?=(?P<BmeT110I>C[CT]CG[AG]G))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "YCGR",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CYCGRG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["BmgBI"] = {
    "charac": (3, -3, None, None, "CACGTC"),
    "compsite": "(?=(?P<BmgBI>CACGTC))|(?=(?P<BmgBI_as>GACGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BmgI"] = {
    "charac": (None, None, None, None, "GKGCCC"),
    "compsite": "(?=(?P<BmgI>G[GT]GCCC))|(?=(?P<BmgI_as>GGGC[AC]C))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GKGCCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BmgT120I"] = {
    "charac": (1, -1, None, None, "GGNCC"),
    "compsite": "(?=(?P<BmgT120I>GG.CC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GNC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGNCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["BmiI"] = {
    "charac": (3, -3, None, None, "GGNNCC"),
    "compsite": "(?=(?P<BmiI>GG..CC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGNNCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["BmrFI"] = {
    "charac": (2, -2, None, None, "CCNGG"),
    "compsite": "(?=(?P<BmrFI>CC.GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["BmrI"] = {
    "charac": (11, 4, None, None, "ACTGGG"),
    "compsite": "(?=(?P<BmrI>ACTGGG))|(?=(?P<BmrI_as>CCCAGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 4,
    "fst5": 11,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACTGGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BmsI"] = {
    "charac": (10, 9, None, None, "GCATC"),
    "compsite": "(?=(?P<BmsI>GCATC))|(?=(?P<BmsI_as>GATGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 9,
    "fst5": 10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCATC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BmtI"] = {
    "charac": (5, -5, None, None, "GCTAGC"),
    "compsite": "(?=(?P<BmtI>GCTAGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CTAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTAGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "N", "V"),
}

rest_dict["BmuI"] = {
    "charac": (11, 4, None, None, "ACTGGG"),
    "compsite": "(?=(?P<BmuI>ACTGGG))|(?=(?P<BmuI_as>CCCAGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 4,
    "fst5": 11,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACTGGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BoxI"] = {
    "charac": (5, -5, None, None, "GACNNNNGTC"),
    "compsite": "(?=(?P<BoxI>GAC....GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNNGTC",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BpiI"] = {
    "charac": (8, 6, None, None, "GAAGAC"),
    "compsite": "(?=(?P<BpiI>GAAGAC))|(?=(?P<BpiI_as>GTCTTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 6,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAGAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BplI"] = {
    "charac": (-8, -24, 24, 8, "GAGNNNNNCTC"),
    "compsite": "(?=(?P<BplI>GAG.....CTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -24,
    "fst5": -8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": 8,
    "scd5": 24,
    "site": "GAGNNNNNCTC",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BpmI"] = {
    "charac": (22, 14, None, None, "CTGGAG"),
    "compsite": "(?=(?P<BpmI>CTGGAG))|(?=(?P<BpmI_as>CTCCAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 14,
    "fst5": 22,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTGGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "N"),
}

rest_dict["Bpu10I"] = {
    "charac": (2, -2, None, None, "CCTNAGC"),
    "compsite": "(?=(?P<Bpu10I>CCT.AGC))|(?=(?P<Bpu10I_as>GCT.AGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TNA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTNAGC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("B", "I", "N", "V"),
}

rest_dict["Bpu1102I"] = {
    "charac": (2, -2, None, None, "GCTNAGC"),
    "compsite": "(?=(?P<Bpu1102I>GCT.AGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TNA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTNAGC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["Bpu14I"] = {
    "charac": (2, -2, None, None, "TTCGAA"),
    "compsite": "(?=(?P<Bpu14I>TTCGAA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTCGAA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BpuEI"] = {
    "charac": (22, 14, None, None, "CTTGAG"),
    "compsite": "(?=(?P<BpuEI>CTTGAG))|(?=(?P<BpuEI_as>CTCAAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 14,
    "fst5": 22,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTTGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BpuMI"] = {
    "charac": (2, -2, None, None, "CCSGG"),
    "compsite": "(?=(?P<BpuMI>CC[CG]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "S",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCSGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["Bsa29I"] = {
    "charac": (2, -2, None, None, "ATCGAT"),
    "compsite": "(?=(?P<Bsa29I>ATCGAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATCGAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BsaAI"] = {
    "charac": (3, -3, None, None, "YACGTR"),
    "compsite": "(?=(?P<BsaAI>[CT]ACGT[AG]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "YACGTR",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsaBI"] = {
    "charac": (5, -5, None, None, "GATNNNNATC"),
    "compsite": "(?=(?P<BsaBI>GAT....ATC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATNNNNATC",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsaHI"] = {
    "charac": (2, -2, None, None, "GRCGYC"),
    "compsite": "(?=(?P<BsaHI>G[AG]CG[CT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRCGYC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsaI"] = {
    "charac": (7, 5, None, None, "GGTCTC"),
    "compsite": "(?=(?P<BsaI>GGTCTC))|(?=(?P<BsaI_as>GAGACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 5,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsaJI"] = {
    "charac": (1, -1, None, None, "CCNNGG"),
    "compsite": "(?=(?P<BsaJI>CC..GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CNNG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNNGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsaWI"] = {
    "charac": (1, -1, None, None, "WCCGGW"),
    "compsite": "(?=(?P<BsaWI>[AT]CCGG[AT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "WCCGGW",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsaXI"] = {
    "charac": (-9, -23, 21, 7, "ACNNNNNCTCC"),
    "compsite": "(?=(?P<BsaXI>AC.....CTCC))|(?=(?P<BsaXI_as>GGAG.....GT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -23,
    "fst5": -9,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": 7,
    "scd5": 21,
    "site": "ACNNNNNCTCC",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsbI"] = {
    "charac": (27, 19, None, None, "CAACAC"),
    "compsite": "(?=(?P<BsbI>CAACAC))|(?=(?P<BsbI_as>GTGTTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 19,
    "fst5": 27,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAACAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Bsc4I"] = {
    "charac": (7, -7, None, None, "CCNNNNNNNGG"),
    "compsite": "(?=(?P<Bsc4I>CC.......GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNNNNNNNGG",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BscAI"] = {
    "charac": (9, 6, None, None, "GCATC"),
    "compsite": "(?=(?P<BscAI>GCATC))|(?=(?P<BscAI_as>GATGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 6,
    "fst5": 9,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCATC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BscGI"] = {
    "charac": (None, None, None, None, "CCCGT"),
    "compsite": "(?=(?P<BscGI>CCCGT))|(?=(?P<BscGI_as>ACGGG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCGT",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Bse118I"] = {
    "charac": (1, -1, None, None, "RCCGGY"),
    "compsite": "(?=(?P<Bse118I>[AG]CCGG[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RCCGGY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Bse1I"] = {
    "charac": (6, -1, None, None, "ACTGG"),
    "compsite": "(?=(?P<Bse1I>ACTGG))|(?=(?P<Bse1I_as>CCAGT))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "GN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACTGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Bse21I"] = {
    "charac": (2, -2, None, None, "CCTNAGG"),
    "compsite": "(?=(?P<Bse21I>CCT.AGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TNA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTNAGG",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Bse3DI"] = {
    "charac": (8, 0, None, None, "GCAATG"),
    "compsite": "(?=(?P<Bse3DI>GCAATG))|(?=(?P<Bse3DI_as>CATTGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 0,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCAATG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Bse8I"] = {
    "charac": (5, -5, None, None, "GATNNNNATC"),
    "compsite": "(?=(?P<Bse8I>GAT....ATC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATNNNNATC",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BseAI"] = {
    "charac": (1, -1, None, None, "TCCGGA"),
    "compsite": "(?=(?P<BseAI>TCCGGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCCGGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C",),
}

rest_dict["BseBI"] = {
    "charac": (2, -2, None, None, "CCWGG"),
    "compsite": "(?=(?P<BseBI>CC[AT]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "W",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("C",),
}

rest_dict["BseCI"] = {
    "charac": (2, -2, None, None, "ATCGAT"),
    "compsite": "(?=(?P<BseCI>ATCGAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATCGAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C",),
}

rest_dict["BseDI"] = {
    "charac": (1, -1, None, None, "CCNNGG"),
    "compsite": "(?=(?P<BseDI>CC..GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CNNG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNNGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BseGI"] = {
    "charac": (7, 0, None, None, "GGATG"),
    "compsite": "(?=(?P<BseGI>GGATG))|(?=(?P<BseGI_as>CATCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 0,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGATG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BseJI"] = {
    "charac": (5, -5, None, None, "GATNNNNATC"),
    "compsite": "(?=(?P<BseJI>GAT....ATC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATNNNNATC",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BseLI"] = {
    "charac": (7, -7, None, None, "CCNNNNNNNGG"),
    "compsite": "(?=(?P<BseLI>CC.......GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNNNNNNNGG",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BseMI"] = {
    "charac": (8, 0, None, None, "GCAATG"),
    "compsite": "(?=(?P<BseMI>GCAATG))|(?=(?P<BseMI_as>CATTGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 0,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCAATG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BseMII"] = {
    "charac": (15, 8, None, None, "CTCAG"),
    "compsite": "(?=(?P<BseMII>CTCAG))|(?=(?P<BseMII_as>CTGAG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 8,
    "fst5": 15,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTCAG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BseNI"] = {
    "charac": (6, -1, None, None, "ACTGG"),
    "compsite": "(?=(?P<BseNI>ACTGG))|(?=(?P<BseNI_as>CCAGT))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "GN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACTGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BsePI"] = {
    "charac": (1, -1, None, None, "GCGCGC"),
    "compsite": "(?=(?P<BsePI>GCGCGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CGCG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGCGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BseRI"] = {
    "charac": (16, 8, None, None, "GAGGAG"),
    "compsite": "(?=(?P<BseRI>GAGGAG))|(?=(?P<BseRI_as>CTCCTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 8,
    "fst5": 16,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BseSI"] = {
    "charac": (5, -5, None, None, "GKGCMC"),
    "compsite": "(?=(?P<BseSI>G[GT]GC[AC]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "KGCM",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GKGCMC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BseX3I"] = {
    "charac": (1, -1, None, None, "CGGCCG"),
    "compsite": "(?=(?P<BseX3I>CGGCCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGCCG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BseXI"] = {
    "charac": (13, 12, None, None, "GCAGC"),
    "compsite": "(?=(?P<BseXI>GCAGC))|(?=(?P<BseXI_as>GCTGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 12,
    "fst5": 13,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCAGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BseYI"] = {
    "charac": (1, -1, None, None, "CCCAGC"),
    "compsite": "(?=(?P<BseYI>CCCAGC))|(?=(?P<BseYI_as>GCTGGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCAGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsgI"] = {
    "charac": (22, 14, None, None, "GTGCAG"),
    "compsite": "(?=(?P<BsgI>GTGCAG))|(?=(?P<BsgI_as>CTGCAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 14,
    "fst5": 22,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTGCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Bsh1236I"] = {
    "charac": (2, -2, None, None, "CGCG"),
    "compsite": "(?=(?P<Bsh1236I>CGCG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Bsh1285I"] = {
    "charac": (4, -4, None, None, "CGRYCG"),
    "compsite": "(?=(?P<Bsh1285I>CG[AG][CT]CG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "RY",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGRYCG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BshFI"] = {
    "charac": (2, -2, None, None, "GGCC"),
    "compsite": "(?=(?P<BshFI>GGCC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("C",),
}

rest_dict["BshNI"] = {
    "charac": (1, -1, None, None, "GGYRCC"),
    "compsite": "(?=(?P<BshNI>GG[CT][AG]CC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GYRC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGYRCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BshTI"] = {
    "charac": (1, -1, None, None, "ACCGGT"),
    "compsite": "(?=(?P<BshTI>ACCGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCGGT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BshVI"] = {
    "charac": (2, -2, None, None, "ATCGAT"),
    "compsite": "(?=(?P<BshVI>ATCGAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATCGAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["BsiEI"] = {
    "charac": (4, -4, None, None, "CGRYCG"),
    "compsite": "(?=(?P<BsiEI>CG[AG][CT]CG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "RY",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGRYCG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsiHKAI"] = {
    "charac": (5, -5, None, None, "GWGCWC"),
    "compsite": "(?=(?P<BsiHKAI>G[AT]GC[AT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "WGCW",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GWGCWC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsiHKCI"] = {
    "charac": (1, -1, None, None, "CYCGRG"),
    "compsite": "(?=(?P<BsiHKCI>C[CT]CG[AG]G))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "YCGR",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CYCGRG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("Q", "X"),
}

rest_dict["BsiI"] = {
    "charac": (1, -1, None, None, "CACGAG"),
    "compsite": "(?=(?P<BsiI>CACGAG))|(?=(?P<BsiI_as>CTCGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "ACGA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BsiSI"] = {
    "charac": (1, -1, None, None, "CCGG"),
    "compsite": "(?=(?P<BsiSI>CCGG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("C", "Y"),
}

rest_dict["BsiWI"] = {
    "charac": (1, -1, None, None, "CGTACG"),
    "compsite": "(?=(?P<BsiWI>CGTACG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GTAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGTACG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsiYI"] = {
    "charac": (7, -7, None, None, "CCNNNNNNNGG"),
    "compsite": "(?=(?P<BsiYI>CC.......GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNNNNNNNGG",
    "size": 11,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BslFI"] = {
    "charac": (15, 14, None, None, "GGGAC"),
    "compsite": "(?=(?P<BslFI>GGGAC))|(?=(?P<BslFI_as>GTCCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 14,
    "fst5": 15,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGGAC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BslI"] = {
    "charac": (7, -7, None, None, "CCNNNNNNNGG"),
    "compsite": "(?=(?P<BslI>CC.......GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNNNNNNNGG",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsmAI"] = {
    "charac": (6, 5, None, None, "GTCTC"),
    "compsite": "(?=(?P<BsmAI>GTCTC))|(?=(?P<BsmAI_as>GAGAC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTCTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsmBI"] = {
    "charac": (7, 5, None, None, "CGTCTC"),
    "compsite": "(?=(?P<BsmBI>CGTCTC))|(?=(?P<BsmBI_as>GAGACG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 5,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGTCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsmFI"] = {
    "charac": (15, 14, None, None, "GGGAC"),
    "compsite": "(?=(?P<BsmFI>GGGAC))|(?=(?P<BsmFI_as>GTCCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 14,
    "fst5": 15,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGGAC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsmI"] = {
    "charac": (7, -1, None, None, "GAATGC"),
    "compsite": "(?=(?P<BsmI>GAATGC))|(?=(?P<BsmI_as>GCATTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "CN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAATGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J", "M", "N", "S"),
}

rest_dict["BsnI"] = {
    "charac": (2, -2, None, None, "GGCC"),
    "compsite": "(?=(?P<BsnI>GGCC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["Bso31I"] = {
    "charac": (7, 5, None, None, "GGTCTC"),
    "compsite": "(?=(?P<Bso31I>GGTCTC))|(?=(?P<Bso31I_as>GAGACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 5,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BsoBI"] = {
    "charac": (1, -1, None, None, "CYCGRG"),
    "compsite": "(?=(?P<BsoBI>C[CT]CG[AG]G))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "YCGR",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CYCGRG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Bsp119I"] = {
    "charac": (2, -2, None, None, "TTCGAA"),
    "compsite": "(?=(?P<Bsp119I>TTCGAA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTCGAA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Bsp120I"] = {
    "charac": (1, -1, None, None, "GGGCCC"),
    "compsite": "(?=(?P<Bsp120I>GGGCCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGGCCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Bsp1286I"] = {
    "charac": (5, -5, None, None, "GDGCHC"),
    "compsite": "(?=(?P<Bsp1286I>G[AGT]GC[ACT]C))",
    "dna": None,
    "freq": 455.1111111111111,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "DGCH",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GDGCHC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J", "K", "N"),
}

rest_dict["Bsp13I"] = {
    "charac": (1, -1, None, None, "TCCGGA"),
    "compsite": "(?=(?P<Bsp13I>TCCGGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCCGGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Bsp1407I"] = {
    "charac": (1, -1, None, None, "TGTACA"),
    "compsite": "(?=(?P<Bsp1407I>TGTACA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GTAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGTACA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["Bsp143I"] = {
    "charac": (0, 0, None, None, "GATC"),
    "compsite": "(?=(?P<Bsp143I>GATC))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Bsp1720I"] = {
    "charac": (2, -2, None, None, "GCTNAGC"),
    "compsite": "(?=(?P<Bsp1720I>GCT.AGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TNA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTNAGC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Bsp19I"] = {
    "charac": (1, -1, None, None, "CCATGG"),
    "compsite": "(?=(?P<Bsp19I>CCATGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCATGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Bsp24I"] = {
    "charac": (-8, -25, 24, 7, "GACNNNNNNTGG"),
    "compsite": "(?=(?P<Bsp24I>GAC......TGG))|(?=(?P<Bsp24I_as>CCA......GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -25,
    "fst5": -8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": 7,
    "scd5": 24,
    "site": "GACNNNNNNTGG",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Bsp3004IV"] = {
    "charac": (None, None, None, None, "CCGCAT"),
    "compsite": "(?=(?P<Bsp3004IV>CCGCAT))|(?=(?P<Bsp3004IV_as>ATGCGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGCAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Bsp460III"] = {
    "charac": (None, None, None, None, "CGCGCAG"),
    "compsite": "(?=(?P<Bsp460III>CGCGCAG))|(?=(?P<Bsp460III_as>CTGCGCG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCGCAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Bsp68I"] = {
    "charac": (3, -3, None, None, "TCGCGA"),
    "compsite": "(?=(?P<Bsp68I>TCGCGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCGCGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BspACI"] = {
    "charac": (1, -1, None, None, "CCGC"),
    "compsite": "(?=(?P<BspACI>CCGC))|(?=(?P<BspACI_as>GCGG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BspANI"] = {
    "charac": (2, -2, None, None, "GGCC"),
    "compsite": "(?=(?P<BspANI>GGCC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("X",),
}

rest_dict["BspCNI"] = {
    "charac": (14, 7, None, None, "CTCAG"),
    "compsite": "(?=(?P<BspCNI>CTCAG))|(?=(?P<BspCNI_as>CTGAG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 7,
    "fst5": 14,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTCAG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BspD6I"] = {
    "charac": (9, 6, None, None, "GAGTC"),
    "compsite": "(?=(?P<BspD6I>GAGTC))|(?=(?P<BspD6I_as>GACTC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 6,
    "fst5": 9,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BspDI"] = {
    "charac": (2, -2, None, None, "ATCGAT"),
    "compsite": "(?=(?P<BspDI>ATCGAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATCGAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BspEI"] = {
    "charac": (1, -1, None, None, "TCCGGA"),
    "compsite": "(?=(?P<BspEI>TCCGGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCCGGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BspFNI"] = {
    "charac": (2, -2, None, None, "CGCG"),
    "compsite": "(?=(?P<BspFNI>CGCG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BspGI"] = {
    "charac": (None, None, None, None, "CTGGAC"),
    "compsite": "(?=(?P<BspGI>CTGGAC))|(?=(?P<BspGI_as>GTCCAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTGGAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BspHI"] = {
    "charac": (1, -1, None, None, "TCATGA"),
    "compsite": "(?=(?P<BspHI>TCATGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCATGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BspLI"] = {
    "charac": (3, -3, None, None, "GGNNCC"),
    "compsite": "(?=(?P<BspLI>GG..CC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGNNCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BspLU11I"] = {
    "charac": (1, -1, None, None, "ACATGT"),
    "compsite": "(?=(?P<BspLU11I>ACATGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACATGT",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BspMAI"] = {
    "charac": (5, -5, None, None, "CTGCAG"),
    "compsite": "(?=(?P<BspMAI>CTGCAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "TGCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTGCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("X",),
}

rest_dict["BspMI"] = {
    "charac": (10, 8, None, None, "ACCTGC"),
    "compsite": "(?=(?P<BspMI>ACCTGC))|(?=(?P<BspMI_as>GCAGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 8,
    "fst5": 10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCTGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BspMII"] = {
    "charac": (1, -1, None, None, "TCCGGA"),
    "compsite": "(?=(?P<BspMII>TCCGGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCCGGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BspNCI"] = {
    "charac": (None, None, None, None, "CCAGA"),
    "compsite": "(?=(?P<BspNCI>CCAGA))|(?=(?P<BspNCI_as>TCTGG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCAGA",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BspOI"] = {
    "charac": (5, -5, None, None, "GCTAGC"),
    "compsite": "(?=(?P<BspOI>GCTAGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CTAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTAGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BspPI"] = {
    "charac": (9, 5, None, None, "GGATC"),
    "compsite": "(?=(?P<BspPI>GGATC))|(?=(?P<BspPI_as>GATCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 9,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGATC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BspQI"] = {
    "charac": (8, 4, None, None, "GCTCTTC"),
    "compsite": "(?=(?P<BspQI>GCTCTTC))|(?=(?P<BspQI_as>GAAGAGC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": 4,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTCTTC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BspT104I"] = {
    "charac": (2, -2, None, None, "TTCGAA"),
    "compsite": "(?=(?P<BspT104I>TTCGAA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTCGAA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["BspT107I"] = {
    "charac": (1, -1, None, None, "GGYRCC"),
    "compsite": "(?=(?P<BspT107I>GG[CT][AG]CC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GYRC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGYRCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["BspTI"] = {
    "charac": (1, -1, None, None, "CTTAAG"),
    "compsite": "(?=(?P<BspTI>CTTAAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TTAA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTTAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["BspTNI"] = {
    "charac": (7, 5, None, None, "GGTCTC"),
    "compsite": "(?=(?P<BspTNI>GGTCTC))|(?=(?P<BspTNI_as>GAGACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 5,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("X",),
}

rest_dict["BsrBI"] = {
    "charac": (3, -3, None, None, "CCGCTC"),
    "compsite": "(?=(?P<BsrBI>CCGCTC))|(?=(?P<BsrBI_as>GAGCGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsrDI"] = {
    "charac": (8, 0, None, None, "GCAATG"),
    "compsite": "(?=(?P<BsrDI>GCAATG))|(?=(?P<BsrDI_as>CATTGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 0,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCAATG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsrFI"] = {
    "charac": (1, -1, None, None, "RCCGGY"),
    "compsite": "(?=(?P<BsrFI>[AG]CCGG[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RCCGGY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsrGI"] = {
    "charac": (1, -1, None, None, "TGTACA"),
    "compsite": "(?=(?P<BsrGI>TGTACA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GTAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGTACA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsrI"] = {
    "charac": (6, -1, None, None, "ACTGG"),
    "compsite": "(?=(?P<BsrI>ACTGG))|(?=(?P<BsrI_as>CCAGT))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "GN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACTGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BssAI"] = {
    "charac": (1, -1, None, None, "RCCGGY"),
    "compsite": "(?=(?P<BssAI>[AG]CCGG[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RCCGGY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C",),
}

rest_dict["BssECI"] = {
    "charac": (1, -1, None, None, "CCNNGG"),
    "compsite": "(?=(?P<BssECI>CC..GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CNNG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNNGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BssHII"] = {
    "charac": (1, -1, None, None, "GCGCGC"),
    "compsite": "(?=(?P<BssHII>GCGCGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CGCG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGCGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J", "K", "M", "N", "Q", "R", "X"),
}

rest_dict["BssMI"] = {
    "charac": (0, 0, None, None, "GATC"),
    "compsite": "(?=(?P<BssMI>GATC))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["BssNAI"] = {
    "charac": (3, -3, None, None, "GTATAC"),
    "compsite": "(?=(?P<BssNAI>GTATAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTATAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BssNI"] = {
    "charac": (2, -2, None, None, "GRCGYC"),
    "compsite": "(?=(?P<BssNI>G[AG]CG[CT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRCGYC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["BssSI"] = {
    "charac": (1, -1, None, None, "CACGAG"),
    "compsite": "(?=(?P<BssSI>CACGAG))|(?=(?P<BssSI_as>CTCGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "ACGA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BssT1I"] = {
    "charac": (1, -1, None, None, "CCWWGG"),
    "compsite": "(?=(?P<BssT1I>CC[AT][AT]GG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CWWG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWWGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Bst1107I"] = {
    "charac": (3, -3, None, None, "GTATAC"),
    "compsite": "(?=(?P<Bst1107I>GTATAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTATAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["Bst2BI"] = {
    "charac": (1, -1, None, None, "CACGAG"),
    "compsite": "(?=(?P<Bst2BI>CACGAG))|(?=(?P<Bst2BI_as>CTCGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "ACGA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["Bst2UI"] = {
    "charac": (2, -2, None, None, "CCWGG"),
    "compsite": "(?=(?P<Bst2UI>CC[AT]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "W",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Bst4CI"] = {
    "charac": (3, -3, None, None, "ACNGT"),
    "compsite": "(?=(?P<Bst4CI>AC.GT))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACNGT",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Bst6I"] = {
    "charac": (7, 4, None, None, "CTCTTC"),
    "compsite": "(?=(?P<Bst6I>CTCTTC))|(?=(?P<Bst6I_as>GAAGAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 4,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTCTTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstACI"] = {
    "charac": (2, -2, None, None, "GRCGYC"),
    "compsite": "(?=(?P<BstACI>G[AG]CG[CT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRCGYC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BstAFI"] = {
    "charac": (1, -1, None, None, "CTTAAG"),
    "compsite": "(?=(?P<BstAFI>CTTAAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TTAA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTTAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BstAPI"] = {
    "charac": (7, -7, None, None, "GCANNNNNTGC"),
    "compsite": "(?=(?P<BstAPI>GCA.....TGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCANNNNNTGC",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("I", "N"),
}

rest_dict["BstAUI"] = {
    "charac": (1, -1, None, None, "TGTACA"),
    "compsite": "(?=(?P<BstAUI>TGTACA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GTAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGTACA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstBAI"] = {
    "charac": (3, -3, None, None, "YACGTR"),
    "compsite": "(?=(?P<BstBAI>[CT]ACGT[AG]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "YACGTR",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstBI"] = {
    "charac": (2, -2, None, None, "TTCGAA"),
    "compsite": "(?=(?P<BstBI>TTCGAA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTCGAA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BstC8I"] = {
    "charac": (3, -3, None, None, "GCNNGC"),
    "compsite": "(?=(?P<BstC8I>GC..GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNNGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BstDEI"] = {
    "charac": (1, -1, None, None, "CTNAG"),
    "compsite": "(?=(?P<BstDEI>CT.AG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TNA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTNAG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstDSI"] = {
    "charac": (1, -1, None, None, "CCRYGG"),
    "compsite": "(?=(?P<BstDSI>CC[AG][CT]GG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CRYG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCRYGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstEII"] = {
    "charac": (1, -1, None, None, "GGTNACC"),
    "compsite": "(?=(?P<BstEII>GGT.ACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "GTNAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTNACC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("C", "J", "N", "R"),
}

rest_dict["BstENI"] = {
    "charac": (5, -5, None, None, "CCTNNNNNAGG"),
    "compsite": "(?=(?P<BstENI>CCT.....AGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTNNNNNAGG",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstF5I"] = {
    "charac": (7, 0, None, None, "GGATG"),
    "compsite": "(?=(?P<BstF5I>GGATG))|(?=(?P<BstF5I_as>CATCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 0,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGATG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstFNI"] = {
    "charac": (2, -2, None, None, "CGCG"),
    "compsite": "(?=(?P<BstFNI>CGCG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstH2I"] = {
    "charac": (5, -5, None, None, "RGCGCY"),
    "compsite": "(?=(?P<BstH2I>[AG]GCGC[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "GCGC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGCGCY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstHHI"] = {
    "charac": (3, -3, None, None, "GCGC"),
    "compsite": "(?=(?P<BstHHI>GCGC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstKTI"] = {
    "charac": (3, -3, None, None, "GATC"),
    "compsite": "(?=(?P<BstKTI>GATC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "AT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BstMAI"] = {
    "charac": (6, 5, None, None, "GTCTC"),
    "compsite": "(?=(?P<BstMAI>GTCTC))|(?=(?P<BstMAI_as>GAGAC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTCTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstMBI"] = {
    "charac": (0, 0, None, None, "GATC"),
    "compsite": "(?=(?P<BstMBI>GATC))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstMCI"] = {
    "charac": (4, -4, None, None, "CGRYCG"),
    "compsite": "(?=(?P<BstMCI>CG[AG][CT]CG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "RY",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGRYCG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstMWI"] = {
    "charac": (7, -7, None, None, "GCNNNNNNNGC"),
    "compsite": "(?=(?P<BstMWI>GC.......GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNNNNNNNGC",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BstNI"] = {
    "charac": (2, -2, None, None, "CCWGG"),
    "compsite": "(?=(?P<BstNI>CC[AT]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "W",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BstNSI"] = {
    "charac": (5, -5, None, None, "RCATGY"),
    "compsite": "(?=(?P<BstNSI>[AG]CATG[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RCATGY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstPAI"] = {
    "charac": (5, -5, None, None, "GACNNNNGTC"),
    "compsite": "(?=(?P<BstPAI>GAC....GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNNGTC",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstPI"] = {
    "charac": (1, -1, None, None, "GGTNACC"),
    "compsite": "(?=(?P<BstPI>GGT.ACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "GTNAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTNACC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["BstSCI"] = {
    "charac": (0, 0, None, None, "CCNGG"),
    "compsite": "(?=(?P<BstSCI>CC.GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "CCNGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BstSFI"] = {
    "charac": (1, -1, None, None, "CTRYAG"),
    "compsite": "(?=(?P<BstSFI>CT[AG][CT]AG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TRYA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTRYAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BstSLI"] = {
    "charac": (5, -5, None, None, "GKGCMC"),
    "compsite": "(?=(?P<BstSLI>G[GT]GC[AC]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "KGCM",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GKGCMC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BstSNI"] = {
    "charac": (3, -3, None, None, "TACGTA"),
    "compsite": "(?=(?P<BstSNI>TACGTA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TACGTA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstUI"] = {
    "charac": (2, -2, None, None, "CGCG"),
    "compsite": "(?=(?P<BstUI>CGCG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BstV1I"] = {
    "charac": (13, 12, None, None, "GCAGC"),
    "compsite": "(?=(?P<BstV1I>GCAGC))|(?=(?P<BstV1I_as>GCTGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 12,
    "fst5": 13,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCAGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BstV2I"] = {
    "charac": (8, 6, None, None, "GAAGAC"),
    "compsite": "(?=(?P<BstV2I>GAAGAC))|(?=(?P<BstV2I_as>GTCTTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 6,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAGAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstX2I"] = {
    "charac": (1, -1, None, None, "RGATCY"),
    "compsite": "(?=(?P<BstX2I>[AG]GATC[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGATCY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["BstXI"] = {
    "charac": (8, -8, None, None, "CCANNNNNNTGG"),
    "compsite": "(?=(?P<BstXI>CCA......TGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -8,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCANNNNNNTGG",
    "size": 12,
    "substrat": "DNA",
    "suppl": ("B", "I", "J", "K", "M", "N", "Q", "R", "V", "X", "Y"),
}

rest_dict["BstYI"] = {
    "charac": (1, -1, None, None, "RGATCY"),
    "compsite": "(?=(?P<BstYI>[AG]GATC[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGATCY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BstZ17I"] = {
    "charac": (3, -3, None, None, "GTATAC"),
    "compsite": "(?=(?P<BstZ17I>GTATAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTATAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BstZI"] = {
    "charac": (1, -1, None, None, "CGGCCG"),
    "compsite": "(?=(?P<BstZI>CGGCCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGCCG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("R",),
}

rest_dict["Bsu15I"] = {
    "charac": (2, -2, None, None, "ATCGAT"),
    "compsite": "(?=(?P<Bsu15I>ATCGAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATCGAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Bsu36I"] = {
    "charac": (2, -2, None, None, "CCTNAGG"),
    "compsite": "(?=(?P<Bsu36I>CCT.AGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TNA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTNAGG",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BsuI"] = {
    "charac": (12, 5, None, None, "GTATCC"),
    "compsite": "(?=(?P<BsuI>GTATCC))|(?=(?P<BsuI_as>GGATAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 5,
    "fst5": 12,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTATCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BsuRI"] = {
    "charac": (2, -2, None, None, "GGCC"),
    "compsite": "(?=(?P<BsuRI>GGCC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B", "I"),
}

rest_dict["BsuTUI"] = {
    "charac": (2, -2, None, None, "ATCGAT"),
    "compsite": "(?=(?P<BsuTUI>ATCGAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATCGAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("X",),
}

rest_dict["BtgI"] = {
    "charac": (1, -1, None, None, "CCRYGG"),
    "compsite": "(?=(?P<BtgI>CC[AG][CT]GG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CRYG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCRYGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BtgZI"] = {
    "charac": (16, 14, None, None, "GCGATG"),
    "compsite": "(?=(?P<BtgZI>GCGATG))|(?=(?P<BtgZI_as>CATCGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 14,
    "fst5": 16,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGATG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BthCI"] = {
    "charac": (4, -4, None, None, "GCNGC"),
    "compsite": "(?=(?P<BthCI>GC.GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "CNG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BtrI"] = {
    "charac": (3, -3, None, None, "CACGTC"),
    "compsite": "(?=(?P<BtrI>CACGTC))|(?=(?P<BtrI_as>GACGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["BtsCI"] = {
    "charac": (7, 0, None, None, "GGATG"),
    "compsite": "(?=(?P<BtsCI>GGATG))|(?=(?P<BtsCI_as>CATCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 0,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGATG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BtsI"] = {
    "charac": (8, 0, None, None, "GCAGTG"),
    "compsite": "(?=(?P<BtsI>GCAGTG))|(?=(?P<BtsI_as>CACTGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 0,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCAGTG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BtsIMutI"] = {
    "charac": (7, 0, None, None, "CAGTG"),
    "compsite": "(?=(?P<BtsIMutI>CAGTG))|(?=(?P<BtsIMutI_as>CACTG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 0,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAGTG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["BtuMI"] = {
    "charac": (3, -3, None, None, "TCGCGA"),
    "compsite": "(?=(?P<BtuMI>TCGCGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCGCGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["Bve1B23I"] = {
    "charac": (None, None, None, None, "GACNNNNNTGG"),
    "compsite": "(?=(?P<Bve1B23I>GAC.....TGG))|(?=(?P<Bve1B23I_as>CCA.....GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNNNTGG",
    "size": 11,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["BveI"] = {
    "charac": (10, 8, None, None, "ACCTGC"),
    "compsite": "(?=(?P<BveI>ACCTGC))|(?=(?P<BveI_as>GCAGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 8,
    "fst5": 10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCTGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Cac8I"] = {
    "charac": (3, -3, None, None, "GCNNGC"),
    "compsite": "(?=(?P<Cac8I>GC..GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNNGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["CaiI"] = {
    "charac": (6, -6, None, None, "CAGNNNCTG"),
    "compsite": "(?=(?P<CaiI>CAG...CTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAGNNNCTG",
    "size": 9,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Cal14237I"] = {
    "charac": (None, None, None, None, "GGTTAG"),
    "compsite": "(?=(?P<Cal14237I>GGTTAG))|(?=(?P<Cal14237I_as>CTAACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTTAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CalB3II"] = {
    "charac": (None, None, None, None, "GRTTRAG"),
    "compsite": "(?=(?P<CalB3II>G[AG]TT[AG]AG))|(?=(?P<CalB3II_as>CT[CT]AA[CT]C))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRTTRAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cau10061II"] = {
    "charac": (None, None, None, None, "GTTAAT"),
    "compsite": "(?=(?P<Cau10061II>GTTAAT))|(?=(?P<Cau10061II_as>ATTAAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTTAAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CauII"] = {
    "charac": (2, -2, None, None, "CCSGG"),
    "compsite": "(?=(?P<CauII>CC[CG]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "S",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCSGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cba13II"] = {
    "charac": (None, None, None, None, "AGGAAT"),
    "compsite": "(?=(?P<Cba13II>AGGAAT))|(?=(?P<Cba13II_as>ATTCCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGGAAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cba16038I"] = {
    "charac": (None, None, None, None, "CCTNAYNC"),
    "compsite": "(?=(?P<Cba16038I>CCT.A[CT].C))|(?=(?P<Cba16038I_as>G.[AG]T.AGG))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTNAYNC",
    "size": 8,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cbo67071IV"] = {
    "charac": (None, None, None, None, "GCRGAAG"),
    "compsite": "(?=(?P<Cbo67071IV>GC[AG]GAAG))|(?=(?P<Cbo67071IV_as>CTTC[CT]GC))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCRGAAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cch467III"] = {
    "charac": (None, None, None, None, "GNGAAAY"),
    "compsite": "(?=(?P<Cch467III>G.GAAA[CT]))|(?=(?P<Cch467III_as>[AG]TTTC.C))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GNGAAAY",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CchII"] = {
    "charac": (17, 9, None, None, "GGARGA"),
    "compsite": "(?=(?P<CchII>GGA[AG]GA))|(?=(?P<CchII_as>TC[CT]TCC))",
    "dna": None,
    "freq": 2048.0,
    "fst3": 9,
    "fst5": 17,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGARGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CchIII"] = {
    "charac": (26, 18, None, None, "CCCAAG"),
    "compsite": "(?=(?P<CchIII>CCCAAG))|(?=(?P<CchIII_as>CTTGGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 18,
    "fst5": 26,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CciI"] = {
    "charac": (1, -1, None, None, "TCATGA"),
    "compsite": "(?=(?P<CciI>TCATGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCATGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["CciNI"] = {
    "charac": (2, -2, None, None, "GCGGCCGC"),
    "compsite": "(?=(?P<CciNI>GCGGCCGC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGGCCGC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Cco14983V"] = {
    "charac": (None, None, None, None, "GGGTDA"),
    "compsite": "(?=(?P<Cco14983V>GGGT[AGT]A))|(?=(?P<Cco14983V_as>T[ACT]ACCC))",
    "dna": None,
    "freq": 1365.3333333333333,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGGTDA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cco14983VI"] = {
    "charac": (None, None, None, None, "GCYGA"),
    "compsite": "(?=(?P<Cco14983VI>GC[CT]GA))|(?=(?P<Cco14983VI_as>TC[AG]GC))",
    "dna": None,
    "freq": 512.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCYGA",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CcrNAIII"] = {
    "charac": (None, None, None, None, "CGACCAG"),
    "compsite": "(?=(?P<CcrNAIII>CGACCAG))|(?=(?P<CcrNAIII_as>CTGGTCG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGACCAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cdi11397I"] = {
    "charac": (None, None, None, None, "GCGCAG"),
    "compsite": "(?=(?P<Cdi11397I>GCGCAG))|(?=(?P<Cdi11397I_as>CTGCGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CdiI"] = {
    "charac": (4, -1, None, None, "CATCG"),
    "compsite": "(?=(?P<CdiI>CATCG))|(?=(?P<CdiI_as>CGATG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATCG",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CdpI"] = {
    "charac": (26, 18, None, None, "GCGGAG"),
    "compsite": "(?=(?P<CdpI>GCGGAG))|(?=(?P<CdpI_as>CTCCGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 18,
    "fst5": 26,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cdu23823II"] = {
    "charac": (None, None, None, None, "GTGAAG"),
    "compsite": "(?=(?P<Cdu23823II>GTGAAG))|(?=(?P<Cdu23823II_as>CTTCAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTGAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CfoI"] = {
    "charac": (3, -3, None, None, "GCGC"),
    "compsite": "(?=(?P<CfoI>GCGC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("M", "R", "S"),
}

rest_dict["Cfr10I"] = {
    "charac": (1, -1, None, None, "RCCGGY"),
    "compsite": "(?=(?P<Cfr10I>[AG]CCGG[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RCCGGY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["Cfr13I"] = {
    "charac": (1, -1, None, None, "GGNCC"),
    "compsite": "(?=(?P<Cfr13I>GG.CC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GNC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGNCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Cfr42I"] = {
    "charac": (4, -4, None, None, "CCGCGG"),
    "compsite": "(?=(?P<Cfr42I>CCGCGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "GC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGCGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Cfr9I"] = {
    "charac": (1, -1, None, None, "CCCGGG"),
    "compsite": "(?=(?P<Cfr9I>CCCGGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCGGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["CfrI"] = {
    "charac": (1, -1, None, None, "YGGCCR"),
    "compsite": "(?=(?P<CfrI>[CT]GGCC[AG]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "YGGCCR",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CfrMH13II"] = {
    "charac": (None, None, None, None, "AGCANCC"),
    "compsite": "(?=(?P<CfrMH13II>AGCA.CC))|(?=(?P<CfrMH13II_as>GG.TGCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGCANCC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CfrMH16VI"] = {
    "charac": (None, None, None, None, "CTAAAG"),
    "compsite": "(?=(?P<CfrMH16VI>CTAAAG))|(?=(?P<CfrMH16VI_as>CTTTAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTAAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cfupf3II"] = {
    "charac": (None, None, None, None, "GARCAG"),
    "compsite": "(?=(?P<Cfupf3II>GA[AG]CAG))|(?=(?P<Cfupf3II_as>CTG[CT]TC))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GARCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cgl13032I"] = {
    "charac": (None, None, None, None, "GGCGCA"),
    "compsite": "(?=(?P<Cgl13032I>GGCGCA))|(?=(?P<Cgl13032I_as>TGCGCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cgl13032II"] = {
    "charac": (None, None, None, None, "ACGABGG"),
    "compsite": "(?=(?P<Cgl13032II>ACGA[CGT]GG))|(?=(?P<Cgl13032II_as>CC[ACG]TCGT))",
    "dna": None,
    "freq": 5461.333333333333,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACGABGG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["ChaI"] = {
    "charac": (4, -4, None, None, "GATC"),
    "compsite": "(?=(?P<ChaI>GATC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATC",
    "size": 4,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cje265V"] = {
    "charac": (None, None, None, None, "GKAAGC"),
    "compsite": "(?=(?P<Cje265V>G[GT]AAGC))|(?=(?P<Cje265V_as>GCTT[AC]C))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GKAAGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cje54107III"] = {
    "charac": (None, None, None, None, "GKAAYC"),
    "compsite": "(?=(?P<Cje54107III>G[GT]AA[CT]C))|(?=(?P<Cje54107III_as>G[AG]TT[AC]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GKAAYC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CjeFIII"] = {
    "charac": (None, None, None, None, "GCAAGG"),
    "compsite": "(?=(?P<CjeFIII>GCAAGG))|(?=(?P<CjeFIII_as>CCTTGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCAAGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CjeFV"] = {
    "charac": (None, None, None, None, "GGRCA"),
    "compsite": "(?=(?P<CjeFV>GG[AG]CA))|(?=(?P<CjeFV_as>TG[CT]CC))",
    "dna": None,
    "freq": 512.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGRCA",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CjeI"] = {
    "charac": (-8, -25, 26, 9, "CCANNNNNNGT"),
    "compsite": "(?=(?P<CjeI>CCA......GT))|(?=(?P<CjeI_as>AC......TGG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -25,
    "fst5": -8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 6,
    "ovhgseq": "NNNNNN",
    "results": None,
    "scd3": 9,
    "scd5": 26,
    "site": "CCANNNNNNGT",
    "size": 11,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CjeNII"] = {
    "charac": (None, None, None, None, "GAGNNNNNGT"),
    "compsite": "(?=(?P<CjeNII>GAG.....GT))|(?=(?P<CjeNII_as>AC.....CTC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGNNNNNGT",
    "size": 10,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CjeNIII"] = {
    "charac": (25, 17, None, None, "GKAAYG"),
    "compsite": "(?=(?P<CjeNIII>G[GT]AA[CT]G))|(?=(?P<CjeNIII_as>C[AG]TT[AC]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 17,
    "fst5": 25,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GKAAYG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CjeNV"] = {
    "charac": (None, None, None, None, "CCYGA"),
    "compsite": "(?=(?P<CjeNV>CC[CT]GA))|(?=(?P<CjeNV_as>TC[AG]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCYGA",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CjeP659IV"] = {
    "charac": (None, None, None, None, "CACNNNNNNNGAA"),
    "compsite": "(?=(?P<CjeP659IV>CAC.......GAA))|(?=(?P<CjeP659IV_as>TTC.......GTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACNNNNNNNGAA",
    "size": 13,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CjePI"] = {
    "charac": (-7, -25, 26, 8, "CCANNNNNNNTC"),
    "compsite": "(?=(?P<CjePI>CCA.......TC))|(?=(?P<CjePI_as>GA.......TGG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -25,
    "fst5": -7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 6,
    "ovhgseq": "NNNNNN",
    "results": None,
    "scd3": 8,
    "scd5": 26,
    "site": "CCANNNNNNNTC",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CjuI"] = {
    "charac": (None, None, None, None, "CAYNNNNNRTG"),
    "compsite": "(?=(?P<CjuI>CA[CT].....[AG]TG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAYNNNNNRTG",
    "size": 11,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CjuII"] = {
    "charac": (None, None, None, None, "CAYNNNNNCTC"),
    "compsite": "(?=(?P<CjuII>CA[CT].....CTC))|(?=(?P<CjuII_as>GAG.....[AG]TG))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAYNNNNNCTC",
    "size": 11,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cla11845III"] = {
    "charac": (None, None, None, None, "GCGAA"),
    "compsite": "(?=(?P<Cla11845III>GCGAA))|(?=(?P<Cla11845III_as>TTCGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGAA",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["ClaI"] = {
    "charac": (2, -2, None, None, "ATCGAT"),
    "compsite": "(?=(?P<ClaI>ATCGAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATCGAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "K", "M", "N", "Q", "R", "S", "X"),
}

rest_dict["Cly7489II"] = {
    "charac": (None, None, None, None, "AAAAGRG"),
    "compsite": "(?=(?P<Cly7489II>AAAAG[AG]G))|(?=(?P<Cly7489II_as>C[CT]CTTTT))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AAAAGRG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Cma23826I"] = {
    "charac": (None, None, None, None, "CGGAAG"),
    "compsite": "(?=(?P<Cma23826I>CGGAAG))|(?=(?P<Cma23826I_as>CTTCCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CpoI"] = {
    "charac": (2, -2, None, None, "CGGWCCG"),
    "compsite": "(?=(?P<CpoI>CGG[AT]CCG))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGWCCG",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["CseI"] = {
    "charac": (10, 10, None, None, "GACGC"),
    "compsite": "(?=(?P<CseI>GACGC))|(?=(?P<CseI_as>GCGTC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 10,
    "fst5": 10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["CsiI"] = {
    "charac": (1, -1, None, None, "ACCWGGT"),
    "compsite": "(?=(?P<CsiI>ACC[AT]GGT))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "CCWGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCWGGT",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Csp2014I"] = {
    "charac": (None, None, None, None, "GGAGGC"),
    "compsite": "(?=(?P<Csp2014I>GGAGGC))|(?=(?P<Csp2014I_as>GCCTCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGAGGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Csp6I"] = {
    "charac": (1, -1, None, None, "GTAC"),
    "compsite": "(?=(?P<Csp6I>GTAC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTAC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["CspAI"] = {
    "charac": (1, -1, None, None, "ACCGGT"),
    "compsite": "(?=(?P<CspAI>ACCGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCGGT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C",),
}

rest_dict["CspCI"] = {
    "charac": (-11, -25, 24, 10, "CAANNNNNGTGG"),
    "compsite": "(?=(?P<CspCI>CAA.....GTGG))|(?=(?P<CspCI_as>CCAC.....TTG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": -25,
    "fst5": -11,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": 10,
    "scd5": 24,
    "site": "CAANNNNNGTGG",
    "size": 12,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["CspI"] = {
    "charac": (2, -2, None, None, "CGGWCCG"),
    "compsite": "(?=(?P<CspI>CGG[AT]CCG))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGWCCG",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("R",),
}

rest_dict["CstMI"] = {
    "charac": (26, 18, None, None, "AAGGAG"),
    "compsite": "(?=(?P<CstMI>AAGGAG))|(?=(?P<CstMI_as>CTCCTT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 18,
    "fst5": 26,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AAGGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["CviAII"] = {
    "charac": (1, -1, None, None, "CATG"),
    "compsite": "(?=(?P<CviAII>CATG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "AT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["CviJI"] = {
    "charac": (2, -2, None, None, "RGCY"),
    "compsite": "(?=(?P<CviJI>[AG]GC[CT]))",
    "dna": None,
    "freq": 64.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGCY",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("Q", "X"),
}

rest_dict["CviKI_1"] = {
    "charac": (2, -2, None, None, "RGCY"),
    "compsite": "(?=(?P<CviKI_1>[AG]GC[CT]))",
    "dna": None,
    "freq": 64.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGCY",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["CviQI"] = {
    "charac": (1, -1, None, None, "GTAC"),
    "compsite": "(?=(?P<CviQI>GTAC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTAC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["CviRI"] = {
    "charac": (2, -2, None, None, "TGCA"),
    "compsite": "(?=(?P<CviRI>TGCA))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGCA",
    "size": 4,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Dde51507I"] = {
    "charac": (None, None, None, None, "CCWGG"),
    "compsite": "(?=(?P<Dde51507I>CC[AT]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["DdeI"] = {
    "charac": (1, -1, None, None, "CTNAG"),
    "compsite": "(?=(?P<DdeI>CT.AG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TNA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTNAG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("K", "M", "N", "O", "Q", "R", "S", "X"),
}

rest_dict["DinI"] = {
    "charac": (3, -3, None, None, "GGCGCC"),
    "compsite": "(?=(?P<DinI>GGCGCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["DpnI"] = {
    "charac": (2, -2, None, None, "GATC"),
    "compsite": "(?=(?P<DpnI>GATC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B", "E", "K", "M", "N", "O", "Q", "R", "S", "X"),
}

rest_dict["DpnII"] = {
    "charac": (0, 0, None, None, "GATC"),
    "compsite": "(?=(?P<DpnII>GATC))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["DraI"] = {
    "charac": (3, -3, None, None, "TTTAAA"),
    "compsite": "(?=(?P<DraI>TTTAAA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTTAAA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "I", "J", "K", "M", "N", "Q", "R", "S", "V", "X"),
}

rest_dict["DraII"] = {
    "charac": (2, -2, None, None, "RGGNCCY"),
    "compsite": "(?=(?P<DraII>[AG]GG.CC[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GNC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGGNCCY",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["DraIII"] = {
    "charac": (6, -6, None, None, "CACNNNGTG"),
    "compsite": "(?=(?P<DraIII>CAC...GTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACNNNGTG",
    "size": 9,
    "substrat": "DNA",
    "suppl": ("I", "M", "N", "V"),
}

rest_dict["DraRI"] = {
    "charac": (27, 18, None, None, "CAAGNAC"),
    "compsite": "(?=(?P<DraRI>CAAG.AC))|(?=(?P<DraRI_as>GT.CTTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 18,
    "fst5": 27,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAAGNAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["DrdI"] = {
    "charac": (7, -7, None, None, "GACNNNNNNGTC"),
    "compsite": "(?=(?P<DrdI>GAC......GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNNNNGTC",
    "size": 12,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["DrdII"] = {
    "charac": (None, None, None, None, "GAACCA"),
    "compsite": "(?=(?P<DrdII>GAACCA))|(?=(?P<DrdII_as>TGGTTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAACCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["DrdIV"] = {
    "charac": (26, 18, None, None, "TACGAC"),
    "compsite": "(?=(?P<DrdIV>TACGAC))|(?=(?P<DrdIV_as>GTCGTA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 18,
    "fst5": 26,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TACGAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["DriI"] = {
    "charac": (6, -6, None, None, "GACNNNNNGTC"),
    "compsite": "(?=(?P<DriI>GAC.....GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNNNGTC",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["DsaI"] = {
    "charac": (1, -1, None, None, "CCRYGG"),
    "compsite": "(?=(?P<DsaI>CC[AG][CT]GG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CRYG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCRYGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["DseDI"] = {
    "charac": (7, -7, None, None, "GACNNNNNNGTC"),
    "compsite": "(?=(?P<DseDI>GAC......GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNNNNGTC",
    "size": 12,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["DvuIII"] = {
    "charac": (None, None, None, None, "CACNCAC"),
    "compsite": "(?=(?P<DvuIII>CAC.CAC))|(?=(?P<DvuIII_as>GTG.GTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACNCAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["EaeI"] = {
    "charac": (1, -1, None, None, "YGGCCR"),
    "compsite": "(?=(?P<EaeI>[CT]GGCC[AG]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "YGGCCR",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("K", "N"),
}

rest_dict["EagI"] = {
    "charac": (1, -1, None, None, "CGGCCG"),
    "compsite": "(?=(?P<EagI>CGGCCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGCCG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Eam1104I"] = {
    "charac": (7, 4, None, None, "CTCTTC"),
    "compsite": "(?=(?P<Eam1104I>CTCTTC))|(?=(?P<Eam1104I_as>GAAGAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 4,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTCTTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Eam1105I"] = {
    "charac": (6, -6, None, None, "GACNNNNNGTC"),
    "compsite": "(?=(?P<Eam1105I>GAC.....GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNNNGTC",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["EarI"] = {
    "charac": (7, 4, None, None, "CTCTTC"),
    "compsite": "(?=(?P<EarI>CTCTTC))|(?=(?P<EarI_as>GAAGAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 4,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTCTTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["EciI"] = {
    "charac": (17, 9, None, None, "GGCGGA"),
    "compsite": "(?=(?P<EciI>GGCGGA))|(?=(?P<EciI_as>TCCGCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 9,
    "fst5": 17,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Ecl136II"] = {
    "charac": (3, -3, None, None, "GAGCTC"),
    "compsite": "(?=(?P<Ecl136II>GAGCTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Ecl234I"] = {
    "charac": (None, None, None, None, "CGGNAAG"),
    "compsite": "(?=(?P<Ecl234I>CGG.AAG))|(?=(?P<Ecl234I_as>CTT.CCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGNAAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Ecl35734I"] = {
    "charac": (None, None, None, None, "GAAAYTC"),
    "compsite": "(?=(?P<Ecl35734I>GAAA[CT]TC))|(?=(?P<Ecl35734I_as>GA[AG]TTTC))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAAYTC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["EclXI"] = {
    "charac": (1, -1, None, None, "CGGCCG"),
    "compsite": "(?=(?P<EclXI>CGGCCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGCCG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("S",),
}

rest_dict["Eco105I"] = {
    "charac": (3, -3, None, None, "TACGTA"),
    "compsite": "(?=(?P<Eco105I>TACGTA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TACGTA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Eco130I"] = {
    "charac": (1, -1, None, None, "CCWWGG"),
    "compsite": "(?=(?P<Eco130I>CC[AT][AT]GG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CWWG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWWGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Eco147I"] = {
    "charac": (3, -3, None, None, "AGGCCT"),
    "compsite": "(?=(?P<Eco147I>AGGCCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGGCCT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Eco24I"] = {
    "charac": (5, -5, None, None, "GRGCYC"),
    "compsite": "(?=(?P<Eco24I>G[AG]GC[CT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "RGCY",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRGCYC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Eco31I"] = {
    "charac": (7, 5, None, None, "GGTCTC"),
    "compsite": "(?=(?P<Eco31I>GGTCTC))|(?=(?P<Eco31I_as>GAGACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 5,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Eco32I"] = {
    "charac": (3, -3, None, None, "GATATC"),
    "compsite": "(?=(?P<Eco32I>GATATC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATATC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Eco43896II"] = {
    "charac": (None, None, None, None, "CRARCAG"),
    "compsite": "(?=(?P<Eco43896II>C[AG]A[AG]CAG))|(?=(?P<Eco43896II_as>CTG[CT]T[CT]G))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CRARCAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Eco4465II"] = {
    "charac": (None, None, None, None, "GAAABCC"),
    "compsite": "(?=(?P<Eco4465II>GAAA[CGT]CC))|(?=(?P<Eco4465II_as>GG[ACG]TTTC))",
    "dna": None,
    "freq": 5461.333333333333,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAABCC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Eco47I"] = {
    "charac": (1, -1, None, None, "GGWCC"),
    "compsite": "(?=(?P<Eco47I>GG[AT]CC))",
    "dna": None,
    "freq": 512.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGWCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Eco47III"] = {
    "charac": (3, -3, None, None, "AGCGCT"),
    "compsite": "(?=(?P<Eco47III>AGCGCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGCGCT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "M", "R", "S"),
}

rest_dict["Eco52I"] = {
    "charac": (1, -1, None, None, "CGGCCG"),
    "compsite": "(?=(?P<Eco52I>CGGCCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGCCG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["Eco53kI"] = {
    "charac": (3, -3, None, None, "GAGCTC"),
    "compsite": "(?=(?P<Eco53kI>GAGCTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Eco57I"] = {
    "charac": (22, 14, None, None, "CTGAAG"),
    "compsite": "(?=(?P<Eco57I>CTGAAG))|(?=(?P<Eco57I_as>CTTCAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 14,
    "fst5": 22,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTGAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Eco57MI"] = {
    "charac": (22, 14, None, None, "CTGRAG"),
    "compsite": "(?=(?P<Eco57MI>CTG[AG]AG))|(?=(?P<Eco57MI_as>CT[CT]CAG))",
    "dna": None,
    "freq": 2048.0,
    "fst3": 14,
    "fst5": 22,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTGRAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Eco72I"] = {
    "charac": (3, -3, None, None, "CACGTG"),
    "compsite": "(?=(?P<Eco72I>CACGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGTG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Eco81I"] = {
    "charac": (2, -2, None, None, "CCTNAGG"),
    "compsite": "(?=(?P<Eco81I>CCT.AGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TNA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTNAGG",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["Eco88I"] = {
    "charac": (1, -1, None, None, "CYCGRG"),
    "compsite": "(?=(?P<Eco88I>C[CT]CG[AG]G))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "YCGR",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CYCGRG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Eco91I"] = {
    "charac": (1, -1, None, None, "GGTNACC"),
    "compsite": "(?=(?P<Eco91I>GGT.ACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "GTNAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTNACC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["EcoBLMcrX"] = {
    "charac": (2, -2, None, None, "RCSRC"),
    "compsite": "(?=(?P<EcoBLMcrX>[AG]C[CG][AG]C))|(?=(?P<EcoBLMcrX_as>G[CT][CG]G[CT]))",
    "dna": None,
    "freq": 128.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "S",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RCSRC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["EcoE1140I"] = {
    "charac": (None, None, None, None, "ACCYAC"),
    "compsite": "(?=(?P<EcoE1140I>ACC[CT]AC))|(?=(?P<EcoE1140I_as>GT[AG]GGT))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCYAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["EcoHI"] = {
    "charac": (0, 0, None, None, "CCSGG"),
    "compsite": "(?=(?P<EcoHI>CC[CG]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "CCSGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCSGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["EcoHSI"] = {
    "charac": (None, None, None, None, "GGTAAG"),
    "compsite": "(?=(?P<EcoHSI>GGTAAG))|(?=(?P<EcoHSI_as>CTTACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["EcoICRI"] = {
    "charac": (3, -3, None, None, "GAGCTC"),
    "compsite": "(?=(?P<EcoICRI>GAGCTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "R", "V"),
}

rest_dict["EcoMVII"] = {
    "charac": (None, None, None, None, "CANCATC"),
    "compsite": "(?=(?P<EcoMVII>CA.CATC))|(?=(?P<EcoMVII_as>GATG.TG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CANCATC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["EcoNI"] = {
    "charac": (5, -5, None, None, "CCTNNNNNAGG"),
    "compsite": "(?=(?P<EcoNI>CCT.....AGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTNNNNNAGG",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["EcoNIH6II"] = {
    "charac": (None, None, None, None, "ATGAAG"),
    "compsite": "(?=(?P<EcoNIH6II>ATGAAG))|(?=(?P<EcoNIH6II_as>CTTCAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATGAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["EcoO109I"] = {
    "charac": (2, -2, None, None, "RGGNCCY"),
    "compsite": "(?=(?P<EcoO109I>[AG]GG.CC[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GNC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGGNCCY",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("B", "J", "K", "N"),
}

rest_dict["EcoO65I"] = {
    "charac": (1, -1, None, None, "GGTNACC"),
    "compsite": "(?=(?P<EcoO65I>GGT.ACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "GTNAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTNACC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["EcoRI"] = {
    "charac": (1, -1, None, None, "GAATTC"),
    "compsite": "(?=(?P<EcoRI>GAATTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "AATT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAATTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X", "Y"),
}

rest_dict["EcoRII"] = {
    "charac": (0, 0, None, None, "CCWGG"),
    "compsite": "(?=(?P<EcoRII>CC[AT]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "CCWGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B", "J"),
}

rest_dict["EcoRV"] = {
    "charac": (3, -3, None, None, "GATATC"),
    "compsite": "(?=(?P<EcoRV>GATATC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATATC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X"),
}

rest_dict["EcoT14I"] = {
    "charac": (1, -1, None, None, "CCWWGG"),
    "compsite": "(?=(?P<EcoT14I>CC[AT][AT]GG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CWWG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWWGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["EcoT22I"] = {
    "charac": (5, -5, None, None, "ATGCAT"),
    "compsite": "(?=(?P<EcoT22I>ATGCAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "TGCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATGCAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["EcoT38I"] = {
    "charac": (5, -5, None, None, "GRGCYC"),
    "compsite": "(?=(?P<EcoT38I>G[AG]GC[CT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "RGCY",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRGCYC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J",),
}

rest_dict["EgeI"] = {
    "charac": (3, -3, None, None, "GGCGCC"),
    "compsite": "(?=(?P<EgeI>GGCGCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["EheI"] = {
    "charac": (3, -3, None, None, "GGCGCC"),
    "compsite": "(?=(?P<EheI>GGCGCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Eli8509II"] = {
    "charac": (None, None, None, None, "CCGGAG"),
    "compsite": "(?=(?P<Eli8509II>CCGGAG))|(?=(?P<Eli8509II_as>CTCCGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["ErhI"] = {
    "charac": (1, -1, None, None, "CCWWGG"),
    "compsite": "(?=(?P<ErhI>CC[AT][AT]GG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CWWG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWWGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["EsaBC3I"] = {
    "charac": (2, -2, None, None, "TCGA"),
    "compsite": "(?=(?P<EsaBC3I>TCGA))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCGA",
    "size": 4,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["EsaSSI"] = {
    "charac": (None, None, None, None, "GACCAC"),
    "compsite": "(?=(?P<EsaSSI>GACCAC))|(?=(?P<EsaSSI_as>GTGGTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACCAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Esp3007I"] = {
    "charac": (None, None, None, None, "CAGAAG"),
    "compsite": "(?=(?P<Esp3007I>CAGAAG))|(?=(?P<Esp3007I_as>CTTCTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAGAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Esp3I"] = {
    "charac": (7, 5, None, None, "CGTCTC"),
    "compsite": "(?=(?P<Esp3I>CGTCTC))|(?=(?P<Esp3I_as>GAGACG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 5,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGTCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "N"),
}

rest_dict["EspI"] = {
    "charac": (2, -2, None, None, "GCTNAGC"),
    "compsite": "(?=(?P<EspI>GCT.AGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TNA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTNAGC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["FaeI"] = {
    "charac": (4, -4, None, None, "CATG"),
    "compsite": "(?=(?P<FaeI>CATG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["FaiI"] = {
    "charac": (2, -2, None, None, "YATR"),
    "compsite": "(?=(?P<FaiI>[CT]AT[AG]))",
    "dna": None,
    "freq": 64.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "YATR",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["FalI"] = {
    "charac": (-8, -24, 24, 8, "AAGNNNNNCTT"),
    "compsite": "(?=(?P<FalI>AAG.....CTT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -24,
    "fst5": -8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": 8,
    "scd5": 24,
    "site": "AAGNNNNNCTT",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["FaqI"] = {
    "charac": (15, 14, None, None, "GGGAC"),
    "compsite": "(?=(?P<FaqI>GGGAC))|(?=(?P<FaqI_as>GTCCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 14,
    "fst5": 15,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGGAC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["FatI"] = {
    "charac": (0, 0, None, None, "CATG"),
    "compsite": "(?=(?P<FatI>CATG))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I", "N"),
}

rest_dict["FauI"] = {
    "charac": (9, 6, None, None, "CCCGC"),
    "compsite": "(?=(?P<FauI>CCCGC))|(?=(?P<FauI_as>GCGGG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 6,
    "fst5": 9,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I", "N"),
}

rest_dict["FauNDI"] = {
    "charac": (2, -2, None, None, "CATATG"),
    "compsite": "(?=(?P<FauNDI>CATATG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATATG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Fba202Z8II"] = {
    "charac": (None, None, None, None, "AGAAGG"),
    "compsite": "(?=(?P<Fba202Z8II>AGAAGG))|(?=(?P<Fba202Z8II_as>CCTTCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGAAGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["FbaI"] = {
    "charac": (1, -1, None, None, "TGATCA"),
    "compsite": "(?=(?P<FbaI>TGATCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGATCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["FblI"] = {
    "charac": (2, -2, None, None, "GTMKAC"),
    "compsite": "(?=(?P<FblI>GT[AC][GT]AC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "MK",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTMKAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Fco1691IV"] = {
    "charac": (None, None, None, None, "GCVGAG"),
    "compsite": "(?=(?P<Fco1691IV>GC[ACG]GAG))|(?=(?P<Fco1691IV_as>CTC[CGT]GC))",
    "dna": None,
    "freq": 1365.3333333333333,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCVGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["FinI"] = {
    "charac": (None, None, None, None, "GGGAC"),
    "compsite": "(?=(?P<FinI>GGGAC))|(?=(?P<FinI_as>GTCCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGGAC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["FmuI"] = {
    "charac": (4, -4, None, None, "GGNCC"),
    "compsite": "(?=(?P<FmuI>GG.CC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "GNC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGNCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Fnu4HI"] = {
    "charac": (2, -2, None, None, "GCNGC"),
    "compsite": "(?=(?P<Fnu4HI>GC.GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["FnuDII"] = {
    "charac": (2, -2, None, None, "CGCG"),
    "compsite": "(?=(?P<FnuDII>CGCG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCG",
    "size": 4,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["FokI"] = {
    "charac": (14, 13, None, None, "GGATG"),
    "compsite": "(?=(?P<FokI>GGATG))|(?=(?P<FokI_as>CATCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 13,
    "fst5": 14,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGATG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B", "I", "J", "K", "M", "N", "V", "X", "Y"),
}

rest_dict["FriOI"] = {
    "charac": (5, -5, None, None, "GRGCYC"),
    "compsite": "(?=(?P<FriOI>G[AG]GC[CT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "RGCY",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRGCYC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["FseI"] = {
    "charac": (6, -6, None, None, "GGCCGGCC"),
    "compsite": "(?=(?P<FseI>GGCCGGCC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCCGGCC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Fsp4HI"] = {
    "charac": (2, -2, None, None, "GCNGC"),
    "compsite": "(?=(?P<Fsp4HI>GC.GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["FspAI"] = {
    "charac": (4, -4, None, None, "RTGCGCAY"),
    "compsite": "(?=(?P<FspAI>[AG]TGCGCA[CT]))",
    "dna": None,
    "freq": 16384.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RTGCGCAY",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["FspBI"] = {
    "charac": (1, -1, None, None, "CTAG"),
    "compsite": "(?=(?P<FspBI>CTAG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTAG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["FspEI"] = {
    "charac": (14, 16, None, None, "CC"),
    "compsite": "(?=(?P<FspEI>CC))|(?=(?P<FspEI_as>GG))",
    "dna": None,
    "freq": 16.0,
    "fst3": 16,
    "fst5": 14,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CC",
    "size": 2,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["FspI"] = {
    "charac": (3, -3, None, None, "TGCGCA"),
    "compsite": "(?=(?P<FspI>TGCGCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGCGCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J", "N"),
}

rest_dict["FspPK15I"] = {
    "charac": (None, None, None, None, "GARGAAG"),
    "compsite": "(?=(?P<FspPK15I>GA[AG]GAAG))|(?=(?P<FspPK15I_as>CTTC[CT]TC))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GARGAAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["FtnUV"] = {
    "charac": (None, None, None, None, "GAAACA"),
    "compsite": "(?=(?P<FtnUV>GAAACA))|(?=(?P<FtnUV_as>TGTTTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAACA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["GauT27I"] = {
    "charac": (None, None, None, None, "CGCGCAGG"),
    "compsite": "(?=(?P<GauT27I>CGCGCAGG))|(?=(?P<GauT27I_as>CCTGCGCG))",
    "dna": None,
    "freq": 65536.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCGCAGG",
    "size": 8,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Gba708II"] = {
    "charac": (None, None, None, None, "ATGCAC"),
    "compsite": "(?=(?P<Gba708II>ATGCAC))|(?=(?P<Gba708II_as>GTGCAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATGCAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["GdiII"] = {
    "charac": (1, -1, None, None, "CGGCCR"),
    "compsite": "(?=(?P<GdiII>CGGCC[AG]))|(?=(?P<GdiII_as>[CT]GGCCG))",
    "dna": None,
    "freq": 2048.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGCCR",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["GlaI"] = {
    "charac": (2, -2, None, None, "GCGC"),
    "compsite": "(?=(?P<GlaI>GCGC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["GluI"] = {
    "charac": (2, -2, None, None, "GCNGC"),
    "compsite": "(?=(?P<GluI>GC.GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["GsaI"] = {
    "charac": (5, -5, None, None, "CCCAGC"),
    "compsite": "(?=(?P<GsaI>CCCAGC))|(?=(?P<GsaI_as>GCTGGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CCAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCAGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["GsuI"] = {
    "charac": (22, 14, None, None, "CTGGAG"),
    "compsite": "(?=(?P<GsuI>CTGGAG))|(?=(?P<GsuI_as>CTCCAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 14,
    "fst5": 22,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTGGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["HaeI"] = {
    "charac": (3, -3, None, None, "WGGCCW"),
    "compsite": "(?=(?P<HaeI>[AT]GGCC[AT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "WGGCCW",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HaeII"] = {
    "charac": (5, -5, None, None, "RGCGCY"),
    "compsite": "(?=(?P<HaeII>[AG]GCGC[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "GCGC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGCGCY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J", "K", "N", "R"),
}

rest_dict["HaeIII"] = {
    "charac": (2, -2, None, None, "GGCC"),
    "compsite": "(?=(?P<HaeIII>GGCC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "X"),
}

rest_dict["HapII"] = {
    "charac": (1, -1, None, None, "CCGG"),
    "compsite": "(?=(?P<HapII>CCGG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["HauII"] = {
    "charac": (17, 9, None, None, "TGGCCA"),
    "compsite": "(?=(?P<HauII>TGGCCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 9,
    "fst5": 17,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGGCCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HbaII"] = {
    "charac": (None, None, None, None, "GCCCAG"),
    "compsite": "(?=(?P<HbaII>GCCCAG))|(?=(?P<HbaII_as>CTGGGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HdeNY26I"] = {
    "charac": (None, None, None, None, "CGANNNNNNTCC"),
    "compsite": "(?=(?P<HdeNY26I>CGA......TCC))|(?=(?P<HdeNY26I_as>GGA......TCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGANNNNNNTCC",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HdeZA17I"] = {
    "charac": (None, None, None, None, "GCANNNNNNTCC"),
    "compsite": "(?=(?P<HdeZA17I>GCA......TCC))|(?=(?P<HdeZA17I_as>GGA......TGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCANNNNNNTCC",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HgaI"] = {
    "charac": (10, 10, None, None, "GACGC"),
    "compsite": "(?=(?P<HgaI>GACGC))|(?=(?P<HgaI_as>GCGTC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 10,
    "fst5": 10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I", "N"),
}

rest_dict["HgiAI"] = {
    "charac": (5, -5, None, None, "GWGCWC"),
    "compsite": "(?=(?P<HgiAI>G[AT]GC[AT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "WGCW",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GWGCWC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HgiCI"] = {
    "charac": (1, -1, None, None, "GGYRCC"),
    "compsite": "(?=(?P<HgiCI>GG[CT][AG]CC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GYRC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGYRCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HgiEII"] = {
    "charac": (None, None, None, None, "ACCNNNNNNGGT"),
    "compsite": "(?=(?P<HgiEII>ACC......GGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCNNNNNNGGT",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HgiJII"] = {
    "charac": (5, -5, None, None, "GRGCYC"),
    "compsite": "(?=(?P<HgiJII>G[AG]GC[CT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "RGCY",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRGCYC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HhaI"] = {
    "charac": (3, -3, None, None, "GCGC"),
    "compsite": "(?=(?P<HhaI>GCGC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B", "J", "K", "N", "Q", "R", "X"),
}

rest_dict["Hin1I"] = {
    "charac": (2, -2, None, None, "GRCGYC"),
    "compsite": "(?=(?P<Hin1I>G[AG]CG[CT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRCGYC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["Hin1II"] = {
    "charac": (4, -4, None, None, "CATG"),
    "compsite": "(?=(?P<Hin1II>CATG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Hin4I"] = {
    "charac": (-8, -24, 24, 8, "GAYNNNNNVTC"),
    "compsite": "(?=(?P<Hin4I>GA[CT].....[ACG]TC))|(?=(?P<Hin4I_as>GA[CGT].....[AG]TC))",
    "dna": None,
    "freq": 682.6666666666666,
    "fst3": -24,
    "fst5": -8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": 8,
    "scd5": 24,
    "site": "GAYNNNNNVTC",
    "size": 11,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Hin4II"] = {
    "charac": (11, 5, None, None, "CCTTC"),
    "compsite": "(?=(?P<Hin4II>CCTTC))|(?=(?P<Hin4II_as>GAAGG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 11,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Hin6I"] = {
    "charac": (1, -1, None, None, "GCGC"),
    "compsite": "(?=(?P<Hin6I>GCGC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["HinP1I"] = {
    "charac": (1, -1, None, None, "GCGC"),
    "compsite": "(?=(?P<HinP1I>GCGC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["HincII"] = {
    "charac": (3, -3, None, None, "GTYRAC"),
    "compsite": "(?=(?P<HincII>GT[CT][AG]AC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTYRAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "J", "K", "N", "O", "Q", "R", "X"),
}

rest_dict["HindII"] = {
    "charac": (3, -3, None, None, "GTYRAC"),
    "compsite": "(?=(?P<HindII>GT[CT][AG]AC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTYRAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "M", "S", "V"),
}

rest_dict["HindIII"] = {
    "charac": (1, -1, None, None, "AAGCTT"),
    "compsite": "(?=(?P<HindIII>AAGCTT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "AGCT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AAGCTT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X", "Y"),
}

rest_dict["HinfI"] = {
    "charac": (1, -1, None, None, "GANTC"),
    "compsite": "(?=(?P<HinfI>GA.TC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "ANT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GANTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "V", "X", "Y"),
}

rest_dict["HpaI"] = {
    "charac": (3, -3, None, None, "GTTAAC"),
    "compsite": "(?=(?P<HpaI>GTTAAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTTAAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "Q", "R", "S", "V", "X"),
}

rest_dict["HpaII"] = {
    "charac": (1, -1, None, None, "CCGG"),
    "compsite": "(?=(?P<HpaII>CCGG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B", "I", "N", "Q", "R", "V", "X"),
}

rest_dict["HphI"] = {
    "charac": (13, 7, None, None, "GGTGA"),
    "compsite": "(?=(?P<HphI>GGTGA))|(?=(?P<HphI_as>TCACC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 7,
    "fst5": 13,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTGA",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B", "N"),
}

rest_dict["Hpy166II"] = {
    "charac": (3, -3, None, None, "GTNNAC"),
    "compsite": "(?=(?P<Hpy166II>GT..AC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTNNAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Hpy178III"] = {
    "charac": (2, -2, None, None, "TCNNGA"),
    "compsite": "(?=(?P<Hpy178III>TC..GA))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCNNGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Hpy188I"] = {
    "charac": (3, -3, None, None, "TCNGA"),
    "compsite": "(?=(?P<Hpy188I>TC.GA))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCNGA",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Hpy188III"] = {
    "charac": (2, -2, None, None, "TCNNGA"),
    "compsite": "(?=(?P<Hpy188III>TC..GA))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCNNGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Hpy300XI"] = {
    "charac": (None, None, None, None, "CCTYNA"),
    "compsite": "(?=(?P<Hpy300XI>CCT[CT].A))|(?=(?P<Hpy300XI_as>T.[AG]AGG))",
    "dna": None,
    "freq": 512.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTYNA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Hpy8I"] = {
    "charac": (3, -3, None, None, "GTNNAC"),
    "compsite": "(?=(?P<Hpy8I>GT..AC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTNNAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Hpy99I"] = {
    "charac": (5, -5, None, None, "CGWCG"),
    "compsite": "(?=(?P<Hpy99I>CG[AT]CG))",
    "dna": None,
    "freq": 512.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "CGWCG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGWCG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Hpy99XIII"] = {
    "charac": (None, None, None, None, "GCCTA"),
    "compsite": "(?=(?P<Hpy99XIII>GCCTA))|(?=(?P<Hpy99XIII_as>TAGGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCTA",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Hpy99XIV"] = {
    "charac": (None, None, None, None, "GGWTAA"),
    "compsite": "(?=(?P<Hpy99XIV>GG[AT]TAA))|(?=(?P<Hpy99XIV_as>TTA[AT]CC))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGWTAA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Hpy99XIV_mut1"] = {
    "charac": (None, None, None, None, "GGWCNA"),
    "compsite": "(?=(?P<Hpy99XIV_mut1>GG[AT]C.A))|(?=(?P<Hpy99XIV_mut1_as>T.G[AT]CC))",
    "dna": None,
    "freq": 512.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGWCNA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Hpy99XXII"] = {
    "charac": (None, None, None, None, "TCANNNNNNTRG"),
    "compsite": "(?=(?P<Hpy99XXII>TCA......T[AG]G))|(?=(?P<Hpy99XXII_as>C[CT]A......TGA))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCANNNNNNTRG",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HpyAV"] = {
    "charac": (11, 5, None, None, "CCTTC"),
    "compsite": "(?=(?P<HpyAV>CCTTC))|(?=(?P<HpyAV_as>GAAGG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 11,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["HpyAXIV"] = {
    "charac": (None, None, None, None, "GCGTA"),
    "compsite": "(?=(?P<HpyAXIV>GCGTA))|(?=(?P<HpyAXIV_as>TACGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGTA",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HpyAXVIII"] = {
    "charac": (None, None, None, None, "GGANNAG"),
    "compsite": "(?=(?P<HpyAXVIII>GGA..AG))|(?=(?P<HpyAXVIII_as>CT..TCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGANNAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HpyAXVI_mut1"] = {
    "charac": (None, None, None, None, "CRTTAA"),
    "compsite": "(?=(?P<HpyAXVI_mut1>C[AG]TTAA))|(?=(?P<HpyAXVI_mut1_as>TTAA[CT]G))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CRTTAA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HpyAXVI_mut2"] = {
    "charac": (None, None, None, None, "CRTCNA"),
    "compsite": "(?=(?P<HpyAXVI_mut2>C[AG]TC.A))|(?=(?P<HpyAXVI_mut2_as>T.GA[CT]G))",
    "dna": None,
    "freq": 512.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CRTCNA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HpyCH4III"] = {
    "charac": (3, -3, None, None, "ACNGT"),
    "compsite": "(?=(?P<HpyCH4III>AC.GT))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACNGT",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["HpyCH4IV"] = {
    "charac": (1, -1, None, None, "ACGT"),
    "compsite": "(?=(?P<HpyCH4IV>ACGT))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACGT",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["HpyCH4V"] = {
    "charac": (2, -2, None, None, "TGCA"),
    "compsite": "(?=(?P<HpyCH4V>TGCA))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGCA",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["HpyF10VI"] = {
    "charac": (7, -7, None, None, "GCNNNNNNNGC"),
    "compsite": "(?=(?P<HpyF10VI>GC.......GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNNNNNNNGC",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["HpyF3I"] = {
    "charac": (1, -1, None, None, "CTNAG"),
    "compsite": "(?=(?P<HpyF3I>CT.AG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TNA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTNAG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["HpySE526I"] = {
    "charac": (1, -1, None, None, "ACGT"),
    "compsite": "(?=(?P<HpySE526I>ACGT))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACGT",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["HpyUM032XIII"] = {
    "charac": (None, None, None, None, "CYANNNNNNNTRG"),
    "compsite": "(?=(?P<HpyUM032XIII>C[CT]A.......T[AG]G))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CYANNNNNNNTRG",
    "size": 13,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HpyUM032XIII_mut1"] = {
    "charac": (None, None, None, None, "CYANNNNNNNTTC"),
    "compsite": "(?=(?P<HpyUM032XIII_mut1>C[CT]A.......TTC))|(?=(?P<HpyUM032XIII_mut1_as>GAA.......T[AG]G))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CYANNNNNNNTTC",
    "size": 13,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HpyUM032XIV"] = {
    "charac": (None, None, None, None, "GAAAG"),
    "compsite": "(?=(?P<HpyUM032XIV>GAAAG))|(?=(?P<HpyUM032XIV_as>CTTTC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAAG",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["HpyUM037X"] = {
    "charac": (None, None, None, None, "TNGGNAG|GTGGNAG"),
    "compsite": "(?=(?P<HpyUM037X>T.GG.AG))|(?=(?P<HpyUM037X_as>CT.CC.A))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TNGGNAG|GTGGNAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Hso63250IV"] = {
    "charac": (None, None, None, None, "AACNNNNNGTT"),
    "compsite": "(?=(?P<Hso63250IV>AAC.....GTT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AACNNNNNGTT",
    "size": 11,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Hso63373III"] = {
    "charac": (None, None, None, None, "CGANNNNNRTAY"),
    "compsite": "(?=(?P<Hso63373III>CGA.....[AG]TA[CT]))|(?=(?P<Hso63373III_as>[AG]TA[CT].....TCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGANNNNNRTAY",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Hsp92I"] = {
    "charac": (2, -2, None, None, "GRCGYC"),
    "compsite": "(?=(?P<Hsp92I>G[AG]CG[CT]C))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRCGYC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("R",),
}

rest_dict["Hsp92II"] = {
    "charac": (4, -4, None, None, "CATG"),
    "compsite": "(?=(?P<Hsp92II>CATG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("R",),
}

rest_dict["HspAI"] = {
    "charac": (1, -1, None, None, "GCGC"),
    "compsite": "(?=(?P<HspAI>GCGC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["HspMHR1II"] = {
    "charac": (None, None, None, None, "GAGCAGC"),
    "compsite": "(?=(?P<HspMHR1II>GAGCAGC))|(?=(?P<HspMHR1II_as>GCTGCTC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGCAGC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Jma19592I"] = {
    "charac": (None, None, None, None, "GTATNAC"),
    "compsite": "(?=(?P<Jma19592I>GTAT.AC))|(?=(?P<Jma19592I_as>GT.ATAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTATNAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Jma19592II"] = {
    "charac": (None, None, None, None, "GRGCRAC"),
    "compsite": "(?=(?P<Jma19592II>G[AG]GC[AG]AC))|(?=(?P<Jma19592II_as>GT[CT]GC[CT]C))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRGCRAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Jsp2502II"] = {
    "charac": (None, None, None, None, "GRNGAAT"),
    "compsite": "(?=(?P<Jsp2502II>G[AG].GAAT))|(?=(?P<Jsp2502II_as>ATTC.[CT]C))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRNGAAT",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["KasI"] = {
    "charac": (1, -1, None, None, "GGCGCC"),
    "compsite": "(?=(?P<KasI>GGCGCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GCGC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["KflI"] = {
    "charac": (2, -2, None, None, "GGGWCCC"),
    "compsite": "(?=(?P<KflI>GGG[AT]CCC))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGGWCCC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Kor51II"] = {
    "charac": (None, None, None, None, "RTCGAG"),
    "compsite": "(?=(?P<Kor51II>[AG]TCGAG))|(?=(?P<Kor51II_as>CTCGA[CT]))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RTCGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Kpn156V"] = {
    "charac": (None, None, None, None, "CRTGATT"),
    "compsite": "(?=(?P<Kpn156V>C[AG]TGATT))|(?=(?P<Kpn156V_as>AATCA[CT]G))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CRTGATT",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Kpn2I"] = {
    "charac": (1, -1, None, None, "TCCGGA"),
    "compsite": "(?=(?P<Kpn2I>TCCGGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCCGGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Kpn327I"] = {
    "charac": (None, None, None, None, "GACATC"),
    "compsite": "(?=(?P<Kpn327I>GACATC))|(?=(?P<Kpn327I_as>GATGTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACATC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["KpnI"] = {
    "charac": (5, -5, None, None, "GGTACC"),
    "compsite": "(?=(?P<KpnI>GGTACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "GTAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTACC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X", "Y"),
}

rest_dict["KpnNH25III"] = {
    "charac": (None, None, None, None, "CTRGAG"),
    "compsite": "(?=(?P<KpnNH25III>CT[AG]GAG))|(?=(?P<KpnNH25III_as>CTC[CT]AG))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTRGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["KpnNIH30III"] = {
    "charac": (None, None, None, None, "GTTCNAC"),
    "compsite": "(?=(?P<KpnNIH30III>GTTC.AC))|(?=(?P<KpnNIH30III_as>GT.GAAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTTCNAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["KpnNIH50I"] = {
    "charac": (None, None, None, None, "GCYAAG"),
    "compsite": "(?=(?P<KpnNIH50I>GC[CT]AAG))|(?=(?P<KpnNIH50I_as>CTT[AG]GC))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCYAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["KroI"] = {
    "charac": (1, -1, None, None, "GCCGGC"),
    "compsite": "(?=(?P<KroI>GCCGGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCGGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["Ksp22I"] = {
    "charac": (1, -1, None, None, "TGATCA"),
    "compsite": "(?=(?P<Ksp22I>TGATCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGATCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Ksp632I"] = {
    "charac": (7, 4, None, None, "CTCTTC"),
    "compsite": "(?=(?P<Ksp632I>CTCTTC))|(?=(?P<Ksp632I_as>GAAGAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 4,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTCTTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["KspAI"] = {
    "charac": (3, -3, None, None, "GTTAAC"),
    "compsite": "(?=(?P<KspAI>GTTAAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTTAAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["KspI"] = {
    "charac": (4, -4, None, None, "CCGCGG"),
    "compsite": "(?=(?P<KspI>CCGCGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "GC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGCGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("M", "S"),
}

rest_dict["Kzo9I"] = {
    "charac": (0, 0, None, None, "GATC"),
    "compsite": "(?=(?P<Kzo9I>GATC))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["Lba2029III"] = {
    "charac": (None, None, None, None, "CYAAANG"),
    "compsite": "(?=(?P<Lba2029III>C[CT]AAA.G))|(?=(?P<Lba2029III_as>C.TTT[AG]G))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CYAAANG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Lbr124II"] = {
    "charac": (None, None, None, None, "CATCNAC"),
    "compsite": "(?=(?P<Lbr124II>CATC.AC))|(?=(?P<Lbr124II_as>GT.GATG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATCNAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Lde4408II"] = {
    "charac": (None, None, None, None, "ACAAAG"),
    "compsite": "(?=(?P<Lde4408II>ACAAAG))|(?=(?P<Lde4408II_as>CTTTGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACAAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["LguI"] = {
    "charac": (8, 4, None, None, "GCTCTTC"),
    "compsite": "(?=(?P<LguI>GCTCTTC))|(?=(?P<LguI_as>GAAGAGC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": 4,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTCTTC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["LlaG50I"] = {
    "charac": (None, None, None, None, "CCGTKA"),
    "compsite": "(?=(?P<LlaG50I>CCGT[GT]A))|(?=(?P<LlaG50I_as>T[AC]ACGG))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGTKA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["LmnI"] = {
    "charac": (6, -1, None, None, "GCTCC"),
    "compsite": "(?=(?P<LmnI>GCTCC))|(?=(?P<LmnI_as>GGAGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "CN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["Lmo370I"] = {
    "charac": (None, None, None, None, "AGCGCCG"),
    "compsite": "(?=(?P<Lmo370I>AGCGCCG))|(?=(?P<Lmo370I_as>CGGCGCT))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGCGCCG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Lmo911II"] = {
    "charac": (None, None, None, None, "TAGRAG"),
    "compsite": "(?=(?P<Lmo911II>TAG[AG]AG))|(?=(?P<Lmo911II_as>CT[CT]CTA))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TAGRAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Lpl1004II"] = {
    "charac": (None, None, None, None, "AGGRAG"),
    "compsite": "(?=(?P<Lpl1004II>AGG[AG]AG))|(?=(?P<Lpl1004II_as>CT[CT]CCT))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGGRAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["LpnI"] = {
    "charac": (3, -3, None, None, "RGCGCY"),
    "compsite": "(?=(?P<LpnI>[AG]GCGC[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGCGCY",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["LpnPI"] = {
    "charac": (14, 14, None, None, "CCDG"),
    "compsite": "(?=(?P<LpnPI>CC[AGT]G))|(?=(?P<LpnPI_as>C[ACT]GG))",
    "dna": None,
    "freq": 85.33333333333333,
    "fst3": 14,
    "fst5": 14,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCDG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Lra68I"] = {
    "charac": (None, None, None, None, "GTTCNAG"),
    "compsite": "(?=(?P<Lra68I>GTTC.AG))|(?=(?P<Lra68I_as>CT.GAAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTTCNAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["LsaDS4I"] = {
    "charac": (None, None, None, None, "TGGAAT"),
    "compsite": "(?=(?P<LsaDS4I>TGGAAT))|(?=(?P<LsaDS4I_as>ATTCCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGGAAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Lsp1109I"] = {
    "charac": (13, 12, None, None, "GCAGC"),
    "compsite": "(?=(?P<Lsp1109I>GCAGC))|(?=(?P<Lsp1109I_as>GCTGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 12,
    "fst5": 13,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCAGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Lsp48III"] = {
    "charac": (None, None, None, None, "AGCACC"),
    "compsite": "(?=(?P<Lsp48III>AGCACC))|(?=(?P<Lsp48III_as>GGTGCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGCACC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Lsp6406VI"] = {
    "charac": (None, None, None, None, "CRAGCAC"),
    "compsite": "(?=(?P<Lsp6406VI>C[AG]AGCAC))|(?=(?P<Lsp6406VI_as>GTGCT[CT]G))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CRAGCAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["LweI"] = {
    "charac": (10, 9, None, None, "GCATC"),
    "compsite": "(?=(?P<LweI>GCATC))|(?=(?P<LweI_as>GATGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 9,
    "fst5": 10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCATC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["MabI"] = {
    "charac": (1, -1, None, None, "ACCWGGT"),
    "compsite": "(?=(?P<MabI>ACC[AT]GGT))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "CCWGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCWGGT",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["MaeI"] = {
    "charac": (1, -1, None, None, "CTAG"),
    "compsite": "(?=(?P<MaeI>CTAG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTAG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("M",),
}

rest_dict["MaeII"] = {
    "charac": (1, -1, None, None, "ACGT"),
    "compsite": "(?=(?P<MaeII>ACGT))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACGT",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("M",),
}

rest_dict["MaeIII"] = {
    "charac": (0, 0, None, None, "GTNAC"),
    "compsite": "(?=(?P<MaeIII>GT.AC))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "GTNAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTNAC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("M", "S"),
}

rest_dict["MalI"] = {
    "charac": (2, -2, None, None, "GATC"),
    "compsite": "(?=(?P<MalI>GATC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["MaqI"] = {
    "charac": (28, 19, None, None, "CRTTGAC"),
    "compsite": "(?=(?P<MaqI>C[AG]TTGAC))|(?=(?P<MaqI_as>GTCAA[CT]G))",
    "dna": None,
    "freq": 8192.0,
    "fst3": 19,
    "fst5": 28,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CRTTGAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["MauBI"] = {
    "charac": (2, -2, None, None, "CGCGCGCG"),
    "compsite": "(?=(?P<MauBI>CGCGCGCG))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CGCG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCGCGCG",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Mba11I"] = {
    "charac": (None, None, None, None, "AGGCGA"),
    "compsite": "(?=(?P<Mba11I>AGGCGA))|(?=(?P<Mba11I_as>TCGCCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGGCGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["MbiI"] = {
    "charac": (3, -3, None, None, "CCGCTC"),
    "compsite": "(?=(?P<MbiI>CCGCTC))|(?=(?P<MbiI_as>GAGCGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["MboI"] = {
    "charac": (0, 0, None, None, "GATC"),
    "compsite": "(?=(?P<MboI>GATC))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B", "C", "K", "N", "Q", "R", "X", "Y"),
}

rest_dict["MboII"] = {
    "charac": (13, 7, None, None, "GAAGA"),
    "compsite": "(?=(?P<MboII>GAAGA))|(?=(?P<MboII_as>TCTTC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 7,
    "fst5": 13,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAGA",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B", "I", "J", "K", "N", "Q", "R", "V", "X"),
}

rest_dict["McaTI"] = {
    "charac": (4, -4, None, None, "GCGCGC"),
    "compsite": "(?=(?P<McaTI>GCGCGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "GC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGCGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Mcr10I"] = {
    "charac": (None, None, None, None, "GAAGNNNNNCTC"),
    "compsite": "(?=(?P<Mcr10I>GAAG.....CTC))|(?=(?P<Mcr10I_as>GAG.....CTTC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAGNNNNNCTC",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["McrI"] = {
    "charac": (4, -4, None, None, "CGRYCG"),
    "compsite": "(?=(?P<McrI>CG[AG][CT]CG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "RY",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGRYCG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["MfeI"] = {
    "charac": (1, -1, None, None, "CAATTG"),
    "compsite": "(?=(?P<MfeI>CAATTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "AATT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAATTG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "N"),
}

rest_dict["MflI"] = {
    "charac": (1, -1, None, None, "RGATCY"),
    "compsite": "(?=(?P<MflI>[AG]GATC[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGATCY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["MhlI"] = {
    "charac": (5, -5, None, None, "GDGCHC"),
    "compsite": "(?=(?P<MhlI>G[AGT]GC[ACT]C))",
    "dna": None,
    "freq": 455.1111111111111,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "DGCH",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GDGCHC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["MjaIV"] = {
    "charac": (None, None, None, None, "GTNNAC"),
    "compsite": "(?=(?P<MjaIV>GT..AC))",
    "dna": None,
    "freq": 256.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTNNAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["MkaDII"] = {
    "charac": (None, None, None, None, "GAGAYGT"),
    "compsite": "(?=(?P<MkaDII>GAGA[CT]GT))|(?=(?P<MkaDII_as>AC[AG]TCTC))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGAYGT",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["MlsI"] = {
    "charac": (3, -3, None, None, "TGGCCA"),
    "compsite": "(?=(?P<MlsI>TGGCCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGGCCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Mlu211III"] = {
    "charac": (None, None, None, None, "AGCCCA"),
    "compsite": "(?=(?P<Mlu211III>AGCCCA))|(?=(?P<Mlu211III_as>TGGGCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGCCCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["MluCI"] = {
    "charac": (0, 0, None, None, "AATT"),
    "compsite": "(?=(?P<MluCI>AATT))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "AATT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AATT",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["MluI"] = {
    "charac": (1, -1, None, None, "ACGCGT"),
    "compsite": "(?=(?P<MluI>ACGCGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CGCG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACGCGT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X"),
}

rest_dict["MluNI"] = {
    "charac": (3, -3, None, None, "TGGCCA"),
    "compsite": "(?=(?P<MluNI>TGGCCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGGCCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("M",),
}

rest_dict["Mly113I"] = {
    "charac": (2, -2, None, None, "GGCGCC"),
    "compsite": "(?=(?P<Mly113I>GGCGCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["MlyI"] = {
    "charac": (10, 5, None, None, "GAGTC"),
    "compsite": "(?=(?P<MlyI>GAGTC))|(?=(?P<MlyI_as>GACTC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["MmeI"] = {
    "charac": (26, 18, None, None, "TCCRAC"),
    "compsite": "(?=(?P<MmeI>TCC[AG]AC))|(?=(?P<MmeI_as>GT[CT]GGA))",
    "dna": None,
    "freq": 2048.0,
    "fst3": 18,
    "fst5": 26,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCCRAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N", "X"),
}

rest_dict["MnlI"] = {
    "charac": (11, 6, None, None, "CCTC"),
    "compsite": "(?=(?P<MnlI>CCTC))|(?=(?P<MnlI_as>GAGG))",
    "dna": None,
    "freq": 256.0,
    "fst3": 6,
    "fst5": 11,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B", "I", "N", "Q", "V", "X"),
}

rest_dict["Mox20I"] = {
    "charac": (3, -3, None, None, "TGGCCA"),
    "compsite": "(?=(?P<Mox20I>TGGCCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGGCCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["Mph1103I"] = {
    "charac": (5, -5, None, None, "ATGCAT"),
    "compsite": "(?=(?P<Mph1103I>ATGCAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "TGCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATGCAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["MreI"] = {
    "charac": (2, -2, None, None, "CGCCGGCG"),
    "compsite": "(?=(?P<MreI>CGCCGGCG))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCCGGCG",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["MroI"] = {
    "charac": (1, -1, None, None, "TCCGGA"),
    "compsite": "(?=(?P<MroI>TCCGGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCCGGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("M", "O"),
}

rest_dict["MroNI"] = {
    "charac": (1, -1, None, None, "GCCGGC"),
    "compsite": "(?=(?P<MroNI>GCCGGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCGGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["MroXI"] = {
    "charac": (5, -5, None, None, "GAANNNNTTC"),
    "compsite": "(?=(?P<MroXI>GAA....TTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAANNNNTTC",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["MscI"] = {
    "charac": (3, -3, None, None, "TGGCCA"),
    "compsite": "(?=(?P<MscI>TGGCCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGGCCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N", "O"),
}

rest_dict["MseI"] = {
    "charac": (1, -1, None, None, "TTAA"),
    "compsite": "(?=(?P<MseI>TTAA))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTAA",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["MslI"] = {
    "charac": (5, -5, None, None, "CAYNNNNRTG"),
    "compsite": "(?=(?P<MslI>CA[CT]....[AG]TG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAYNNNNRTG",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Msp20I"] = {
    "charac": (3, -3, None, None, "TGGCCA"),
    "compsite": "(?=(?P<Msp20I>TGGCCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGGCCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["MspA1I"] = {
    "charac": (3, -3, None, None, "CMGCKG"),
    "compsite": "(?=(?P<MspA1I>C[AC]GC[GT]G))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CMGCKG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "N", "R", "V"),
}

rest_dict["MspCI"] = {
    "charac": (1, -1, None, None, "CTTAAG"),
    "compsite": "(?=(?P<MspCI>CTTAAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TTAA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTTAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C",),
}

rest_dict["MspGI"] = {
    "charac": (5, -5, None, None, "GCCGGC"),
    "compsite": "(?=(?P<MspGI>GCCGGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCGGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["MspI"] = {
    "charac": (1, -1, None, None, "CCGG"),
    "compsite": "(?=(?P<MspI>CCGG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B", "I", "J", "K", "N", "Q", "R", "V", "X"),
}

rest_dict["MspI7II"] = {
    "charac": (None, None, None, None, "ACGRAG"),
    "compsite": "(?=(?P<MspI7II>ACG[AG]AG))|(?=(?P<MspI7II_as>CT[CT]CGT))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACGRAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["MspI7IV"] = {
    "charac": (None, None, None, None, "GCMGAAG"),
    "compsite": "(?=(?P<MspI7IV>GC[AC]GAAG))|(?=(?P<MspI7IV_as>CTTC[GT]GC))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCMGAAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["MspJI"] = {
    "charac": (13, 13, None, None, "CNNR"),
    "compsite": "(?=(?P<MspJI>C..[AG]))|(?=(?P<MspJI_as>[CT]..G))",
    "dna": None,
    "freq": 8.0,
    "fst3": 13,
    "fst5": 13,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CNNR",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["MspR9I"] = {
    "charac": (2, -2, None, None, "CCNGG"),
    "compsite": "(?=(?P<MspR9I>CC.GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["MspSC27II"] = {
    "charac": (None, None, None, None, "CCGCGAC"),
    "compsite": "(?=(?P<MspSC27II>CCGCGAC))|(?=(?P<MspSC27II_as>GTCGCGG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGCGAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["MssI"] = {
    "charac": (4, -4, None, None, "GTTTAAAC"),
    "compsite": "(?=(?P<MssI>GTTTAAAC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTTTAAAC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["MstI"] = {
    "charac": (3, -3, None, None, "TGCGCA"),
    "compsite": "(?=(?P<MstI>TGCGCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGCGCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["MteI"] = {
    "charac": (4, -4, None, None, "GCGCNGCGC"),
    "compsite": "(?=(?P<MteI>GCGC.GCGC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGCNGCGC",
    "size": 9,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["MtuHN878II"] = {
    "charac": (None, None, None, None, "CACGCAG"),
    "compsite": "(?=(?P<MtuHN878II>CACGCAG))|(?=(?P<MtuHN878II_as>CTGCGTG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGCAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["MunI"] = {
    "charac": (1, -1, None, None, "CAATTG"),
    "compsite": "(?=(?P<MunI>CAATTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "AATT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAATTG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "K", "M", "S"),
}

rest_dict["Mva1269I"] = {
    "charac": (7, -1, None, None, "GAATGC"),
    "compsite": "(?=(?P<Mva1269I>GAATGC))|(?=(?P<Mva1269I_as>GCATTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "CN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAATGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["MvaI"] = {
    "charac": (2, -2, None, None, "CCWGG"),
    "compsite": "(?=(?P<MvaI>CC[AT]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "W",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B", "M"),
}

rest_dict["MvnI"] = {
    "charac": (2, -2, None, None, "CGCG"),
    "compsite": "(?=(?P<MvnI>CGCG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("M",),
}

rest_dict["MwoI"] = {
    "charac": (7, -7, None, None, "GCNNNNNNNGC"),
    "compsite": "(?=(?P<MwoI>GC.......GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNNNNNNNGC",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["NaeI"] = {
    "charac": (3, -3, None, None, "GCCGGC"),
    "compsite": "(?=(?P<NaeI>GCCGGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCGGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C", "K", "N"),
}

rest_dict["Nal45188II"] = {
    "charac": (None, None, None, None, "ACCAGC"),
    "compsite": "(?=(?P<Nal45188II>ACCAGC))|(?=(?P<Nal45188II_as>GCTGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCAGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["NarI"] = {
    "charac": (2, -2, None, None, "GGCGCC"),
    "compsite": "(?=(?P<NarI>GGCGCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J", "M", "N", "Q", "R", "X"),
}

rest_dict["Nbr128II"] = {
    "charac": (None, None, None, None, "ACCGAC"),
    "compsite": "(?=(?P<Nbr128II>ACCGAC))|(?=(?P<Nbr128II_as>GTCGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCGAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["NciI"] = {
    "charac": (2, -2, None, None, "CCSGG"),
    "compsite": "(?=(?P<NciI>CC[CG]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "S",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCSGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("J", "N", "R"),
}

rest_dict["NcoI"] = {
    "charac": (1, -1, None, None, "CCATGG"),
    "compsite": "(?=(?P<NcoI>CCATGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCATGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "J", "K", "M", "N", "O", "Q", "R", "S", "X", "Y"),
}

rest_dict["NdeI"] = {
    "charac": (2, -2, None, None, "CATATG"),
    "compsite": "(?=(?P<NdeI>CATATG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATATG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "J", "K", "M", "N", "Q", "R", "S", "X"),
}

rest_dict["NdeII"] = {
    "charac": (0, 0, None, None, "GATC"),
    "compsite": "(?=(?P<NdeII>GATC))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("J", "M"),
}

rest_dict["NgoAVII"] = {
    "charac": (12, 7, None, None, "GCCGC"),
    "compsite": "(?=(?P<NgoAVII>GCCGC))|(?=(?P<NgoAVII_as>GCGGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 7,
    "fst5": 12,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["NgoAVIII"] = {
    "charac": (-12, -25, 24, 11, "GACNNNNNTGA"),
    "compsite": "(?=(?P<NgoAVIII>GAC.....TGA))|(?=(?P<NgoAVIII_as>TCA.....GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -25,
    "fst5": -12,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": 11,
    "scd5": 24,
    "site": "GACNNNNNTGA",
    "size": 11,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["NgoMIV"] = {
    "charac": (1, -1, None, None, "GCCGGC"),
    "compsite": "(?=(?P<NgoMIV>GCCGGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCGGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["NhaXI"] = {
    "charac": (None, None, None, None, "CAAGRAG"),
    "compsite": "(?=(?P<NhaXI>CAAG[AG]AG))|(?=(?P<NhaXI_as>CT[CT]CTTG))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAAGRAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["NheI"] = {
    "charac": (1, -1, None, None, "GCTAGC"),
    "compsite": "(?=(?P<NheI>GCTAGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CTAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTAGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "J", "K", "M", "N", "O", "Q", "R", "S", "X"),
}

rest_dict["NhoI"] = {
    "charac": (None, None, None, None, "GCWGC"),
    "compsite": "(?=(?P<NhoI>GC[AT]GC))",
    "dna": None,
    "freq": 512.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCWGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["NlaCI"] = {
    "charac": (25, 17, None, None, "CATCAC"),
    "compsite": "(?=(?P<NlaCI>CATCAC))|(?=(?P<NlaCI_as>GTGATG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 17,
    "fst5": 25,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATCAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["NlaIII"] = {
    "charac": (4, -4, None, None, "CATG"),
    "compsite": "(?=(?P<NlaIII>CATG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["NlaIV"] = {
    "charac": (3, -3, None, None, "GGNNCC"),
    "compsite": "(?=(?P<NlaIV>GG..CC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGNNCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Nli3877I"] = {
    "charac": (5, -5, None, None, "CYCGRG"),
    "compsite": "(?=(?P<Nli3877I>C[CT]CG[AG]G))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "YCGR",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CYCGRG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["NmeA6CIII"] = {
    "charac": (27, 19, None, None, "GCCGAC"),
    "compsite": "(?=(?P<NmeA6CIII>GCCGAC))|(?=(?P<NmeA6CIII_as>GTCGGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 19,
    "fst5": 27,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCGAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["NmeAIII"] = {
    "charac": (27, 19, None, None, "GCCGAG"),
    "compsite": "(?=(?P<NmeAIII>GCCGAG))|(?=(?P<NmeAIII_as>CTCGGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 19,
    "fst5": 27,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["NmeDI"] = {
    "charac": (-12, -13, 13, 12, "RCCGGY"),
    "compsite": "(?=(?P<NmeDI>[AG]CCGG[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -13,
    "fst5": -12,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": 12,
    "scd5": 13,
    "site": "RCCGGY",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["NmuCI"] = {
    "charac": (0, 0, None, None, "GTSAC"),
    "compsite": "(?=(?P<NmuCI>GT[CG]AC))",
    "dna": None,
    "freq": 512.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "GTSAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTSAC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["NotI"] = {
    "charac": (2, -2, None, None, "GCGGCCGC"),
    "compsite": "(?=(?P<NotI>GCGGCCGC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGGCCGC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("B", "C", "J", "K", "M", "N", "O", "Q", "R", "S", "X"),
}

rest_dict["NpeUS61II"] = {
    "charac": (None, None, None, None, "GATCGAC"),
    "compsite": "(?=(?P<NpeUS61II>GATCGAC))|(?=(?P<NpeUS61II_as>GTCGATC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATCGAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["NruI"] = {
    "charac": (3, -3, None, None, "TCGCGA"),
    "compsite": "(?=(?P<NruI>TCGCGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCGCGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "Q", "R", "S", "X"),
}

rest_dict["NsbI"] = {
    "charac": (3, -3, None, None, "TGCGCA"),
    "compsite": "(?=(?P<NsbI>TGCGCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGCGCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["NsiI"] = {
    "charac": (5, -5, None, None, "ATGCAT"),
    "compsite": "(?=(?P<NsiI>ATGCAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "TGCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATGCAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J", "M", "N", "Q", "R", "S", "X"),
}

rest_dict["NspBII"] = {
    "charac": (3, -3, None, None, "CMGCKG"),
    "compsite": "(?=(?P<NspBII>C[AC]GC[GT]G))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CMGCKG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["NspI"] = {
    "charac": (5, -5, None, None, "RCATGY"),
    "compsite": "(?=(?P<NspI>[AG]CATG[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RCATGY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["NspV"] = {
    "charac": (2, -2, None, None, "TTCGAA"),
    "compsite": "(?=(?P<NspV>TTCGAA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTCGAA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("J",),
}

rest_dict["ObaBS10I"] = {
    "charac": (None, None, None, None, "ACGAG"),
    "compsite": "(?=(?P<ObaBS10I>ACGAG))|(?=(?P<ObaBS10I_as>CTCGT))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACGAG",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["OgrI"] = {
    "charac": (None, None, None, None, "CAACNAC"),
    "compsite": "(?=(?P<OgrI>CAAC.AC))|(?=(?P<OgrI_as>GT.GTTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAACNAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["OliI"] = {
    "charac": (5, -5, None, None, "CACNNNNGTG"),
    "compsite": "(?=(?P<OliI>CAC....GTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACNNNNGTG",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["OspHL35III"] = {
    "charac": (None, None, None, None, "YAGGAG"),
    "compsite": "(?=(?P<OspHL35III>[CT]AGGAG))|(?=(?P<OspHL35III_as>CTCCT[AG]))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "YAGGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PabI"] = {
    "charac": (3, -3, None, None, "GTAC"),
    "compsite": "(?=(?P<PabI>GTAC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTAC",
    "size": 4,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Pac19842II"] = {
    "charac": (None, None, None, None, "CCTTGA"),
    "compsite": "(?=(?P<Pac19842II>CCTTGA))|(?=(?P<Pac19842II_as>TCAAGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTTGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PacI"] = {
    "charac": (5, -5, None, None, "TTAATTAA"),
    "compsite": "(?=(?P<PacI>TTAATTAA))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "AT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTAATTAA",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("B", "N", "O"),
}

rest_dict["PacIII"] = {
    "charac": (None, None, None, None, "GTAATC"),
    "compsite": "(?=(?P<PacIII>GTAATC))|(?=(?P<PacIII_as>GATTAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTAATC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PaeI"] = {
    "charac": (5, -5, None, None, "GCATGC"),
    "compsite": "(?=(?P<PaeI>GCATGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCATGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["PaePA99III"] = {
    "charac": (None, None, None, None, "AAGAYC"),
    "compsite": "(?=(?P<PaePA99III>AAGA[CT]C))|(?=(?P<PaePA99III_as>G[AG]TCTT))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AAGAYC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PaeR7I"] = {
    "charac": (1, -1, None, None, "CTCGAG"),
    "compsite": "(?=(?P<PaeR7I>CTCGAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TCGA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTCGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["PagI"] = {
    "charac": (1, -1, None, None, "TCATGA"),
    "compsite": "(?=(?P<PagI>TCATGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCATGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Pal408I"] = {
    "charac": (None, None, None, None, "CCRTGAG"),
    "compsite": "(?=(?P<Pal408I>CC[AG]TGAG))|(?=(?P<Pal408I_as>CTCA[CT]GG))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCRTGAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PalAI"] = {
    "charac": (2, -2, None, None, "GGCGCGCC"),
    "compsite": "(?=(?P<PalAI>GGCGCGCC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CGCG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGCGCC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["PasI"] = {
    "charac": (2, -2, None, None, "CCCWGGG"),
    "compsite": "(?=(?P<PasI>CCC[AT]GGG))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "CWG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCWGGG",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["PauI"] = {
    "charac": (1, -1, None, None, "GCGCGC"),
    "compsite": "(?=(?P<PauI>GCGCGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CGCG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGCGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Pba2294I"] = {
    "charac": (None, None, None, None, "GTAAG"),
    "compsite": "(?=(?P<Pba2294I>GTAAG))|(?=(?P<Pba2294I_as>CTTAC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTAAG",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PcaII"] = {
    "charac": (None, None, None, None, "GACGAG"),
    "compsite": "(?=(?P<PcaII>GACGAG))|(?=(?P<PcaII_as>CTCGTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PceI"] = {
    "charac": (3, -3, None, None, "AGGCCT"),
    "compsite": "(?=(?P<PceI>AGGCCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGGCCT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["PciI"] = {
    "charac": (1, -1, None, None, "ACATGT"),
    "compsite": "(?=(?P<PciI>ACATGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACATGT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "N"),
}

rest_dict["PciSI"] = {
    "charac": (8, 4, None, None, "GCTCTTC"),
    "compsite": "(?=(?P<PciSI>GCTCTTC))|(?=(?P<PciSI_as>GAAGAGC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": 4,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTCTTC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["Pcr308II"] = {
    "charac": (None, None, None, None, "CCAAAG"),
    "compsite": "(?=(?P<Pcr308II>CCAAAG))|(?=(?P<Pcr308II_as>CTTTGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCAAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PcsI"] = {
    "charac": (7, -7, None, None, "WCGNNNNNNNCGW"),
    "compsite": "(?=(?P<PcsI>[AT]CG.......CG[AT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "WCGNNNNNNNCGW",
    "size": 13,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["PctI"] = {
    "charac": (7, -1, None, None, "GAATGC"),
    "compsite": "(?=(?P<PctI>GAATGC))|(?=(?P<PctI_as>GCATTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "CN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAATGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Pdi8503III"] = {
    "charac": (None, None, None, None, "CCGGNAG"),
    "compsite": "(?=(?P<Pdi8503III>CCGG.AG))|(?=(?P<Pdi8503III_as>CT.CCGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGGNAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PdiI"] = {
    "charac": (3, -3, None, None, "GCCGGC"),
    "compsite": "(?=(?P<PdiI>GCCGGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCGGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["PdmI"] = {
    "charac": (5, -5, None, None, "GAANNNNTTC"),
    "compsite": "(?=(?P<PdmI>GAA....TTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAANNNNTTC",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Pdu1735I"] = {
    "charac": (None, None, None, None, "CACCAC"),
    "compsite": "(?=(?P<Pdu1735I>CACCAC))|(?=(?P<Pdu1735I_as>GTGGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACCAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PenI"] = {
    "charac": (None, None, None, None, "GCAGT"),
    "compsite": "(?=(?P<PenI>GCAGT))|(?=(?P<PenI_as>ACTGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCAGT",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PfeI"] = {
    "charac": (1, -1, None, None, "GAWTC"),
    "compsite": "(?=(?P<PfeI>GA[AT]TC))",
    "dna": None,
    "freq": 512.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "AWT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAWTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Pfl1108I"] = {
    "charac": (None, None, None, None, "TCGTAG"),
    "compsite": "(?=(?P<Pfl1108I>TCGTAG))|(?=(?P<Pfl1108I_as>CTACGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCGTAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Pfl23II"] = {
    "charac": (1, -1, None, None, "CGTACG"),
    "compsite": "(?=(?P<Pfl23II>CGTACG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GTAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGTACG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Pfl8569I"] = {
    "charac": (3, -3, None, None, "GCNNGC"),
    "compsite": "(?=(?P<Pfl8569I>GC..GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNNGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PflFI"] = {
    "charac": (4, -4, None, None, "GACNNNGTC"),
    "compsite": "(?=(?P<PflFI>GAC...GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNGTC",
    "size": 9,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["PflMI"] = {
    "charac": (7, -7, None, None, "CCANNNNNTGG"),
    "compsite": "(?=(?P<PflMI>CCA.....TGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCANNNNNTGG",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["PflPt14I"] = {
    "charac": (None, None, None, None, "RGCCCAC"),
    "compsite": "(?=(?P<PflPt14I>[AG]GCCCAC))|(?=(?P<PflPt14I_as>GTGGGC[CT]))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGCCCAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PfoI"] = {
    "charac": (1, -1, None, None, "TCCNGGA"),
    "compsite": "(?=(?P<PfoI>TCC.GGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "CCNGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCCNGGA",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["PfrJS12IV"] = {
    "charac": (None, None, None, None, "TANAAG"),
    "compsite": "(?=(?P<PfrJS12IV>TA.AAG))|(?=(?P<PfrJS12IV_as>CTT.TA))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TANAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PfrJS12V"] = {
    "charac": (None, None, None, None, "GGCGGAG"),
    "compsite": "(?=(?P<PfrJS12V>GGCGGAG))|(?=(?P<PfrJS12V_as>CTCCGCC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGGAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PfrJS15III"] = {
    "charac": (None, None, None, None, "CTTCNAC"),
    "compsite": "(?=(?P<PfrJS15III>CTTC.AC))|(?=(?P<PfrJS15III_as>GT.GAAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTTCNAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Pin17FIII"] = {
    "charac": (None, None, None, None, "GGYGAB"),
    "compsite": "(?=(?P<Pin17FIII>GG[CT]GA[CGT]))|(?=(?P<Pin17FIII_as>[ACG]TC[AG]CC))",
    "dna": None,
    "freq": 682.6666666666666,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGYGAB",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PinAI"] = {
    "charac": (1, -1, None, None, "ACCGGT"),
    "compsite": "(?=(?P<PinAI>ACCGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCGGT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("Q", "X"),
}

rest_dict["PinP23II"] = {
    "charac": (None, None, None, None, "CTRKCAG"),
    "compsite": "(?=(?P<PinP23II>CT[AG][GT]CAG))|(?=(?P<PinP23II_as>CTG[AC][CT]AG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTRKCAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PinP59III"] = {
    "charac": (None, None, None, None, "GAAGNAG"),
    "compsite": "(?=(?P<PinP59III>GAAG.AG))|(?=(?P<PinP59III_as>CT.CTTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAGNAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PkrI"] = {
    "charac": (3, -3, None, None, "GCNGC"),
    "compsite": "(?=(?P<PkrI>GC.GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["PlaDI"] = {
    "charac": (27, 19, None, None, "CATCAG"),
    "compsite": "(?=(?P<PlaDI>CATCAG))|(?=(?P<PlaDI_as>CTGATG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 19,
    "fst5": 27,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Ple19I"] = {
    "charac": (4, -4, None, None, "CGATCG"),
    "compsite": "(?=(?P<Ple19I>CGATCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "AT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGATCG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["PleI"] = {
    "charac": (9, 5, None, None, "GAGTC"),
    "compsite": "(?=(?P<PleI>GAGTC))|(?=(?P<PleI_as>GACTC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 9,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["PliMI"] = {
    "charac": (None, None, None, None, "CGCCGAC"),
    "compsite": "(?=(?P<PliMI>CGCCGAC))|(?=(?P<PliMI_as>GTCGGCG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCCGAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PluTI"] = {
    "charac": (5, -5, None, None, "GGCGCC"),
    "compsite": "(?=(?P<PluTI>GGCGCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "GCGC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["PmaCI"] = {
    "charac": (3, -3, None, None, "CACGTG"),
    "compsite": "(?=(?P<PmaCI>CACGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGTG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["PmeI"] = {
    "charac": (4, -4, None, None, "GTTTAAAC"),
    "compsite": "(?=(?P<PmeI>GTTTAAAC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTTTAAAC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["PmlI"] = {
    "charac": (3, -3, None, None, "CACGTG"),
    "compsite": "(?=(?P<PmlI>CACGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGTG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["PpiI"] = {
    "charac": (-7, -24, 25, 8, "GAACNNNNNCTC"),
    "compsite": "(?=(?P<PpiI>GAAC.....CTC))|(?=(?P<PpiI_as>GAG.....GTTC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": -24,
    "fst5": -7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": 8,
    "scd5": 25,
    "site": "GAACNNNNNCTC",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PpiP13II"] = {
    "charac": (None, None, None, None, "CGCRGAC"),
    "compsite": "(?=(?P<PpiP13II>CGC[AG]GAC))|(?=(?P<PpiP13II_as>GTC[CT]GCG))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCRGAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PpsI"] = {
    "charac": (9, 5, None, None, "GAGTC"),
    "compsite": "(?=(?P<PpsI>GAGTC))|(?=(?P<PpsI_as>GACTC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 9,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["Ppu10I"] = {
    "charac": (1, -1, None, None, "ATGCAT"),
    "compsite": "(?=(?P<Ppu10I>ATGCAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TGCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATGCAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Ppu21I"] = {
    "charac": (3, -3, None, None, "YACGTR"),
    "compsite": "(?=(?P<Ppu21I>[CT]ACGT[AG]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "YACGTR",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["PpuMI"] = {
    "charac": (2, -2, None, None, "RGGWCCY"),
    "compsite": "(?=(?P<PpuMI>[AG]GG[AT]CC[CT]))",
    "dna": None,
    "freq": 2048.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGGWCCY",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["PscI"] = {
    "charac": (1, -1, None, None, "ACATGT"),
    "compsite": "(?=(?P<PscI>ACATGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACATGT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Pse18267I"] = {
    "charac": (None, None, None, None, "RCCGAAG"),
    "compsite": "(?=(?P<Pse18267I>[AG]CCGAAG))|(?=(?P<Pse18267I_as>CTTCGG[CT]))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RCCGAAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PshAI"] = {
    "charac": (5, -5, None, None, "GACNNNNGTC"),
    "compsite": "(?=(?P<PshAI>GAC....GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNNGTC",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("K", "N"),
}

rest_dict["PshBI"] = {
    "charac": (2, -2, None, None, "ATTAAT"),
    "compsite": "(?=(?P<PshBI>ATTAAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATTAAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["PsiI"] = {
    "charac": (3, -3, None, None, "TTATAA"),
    "compsite": "(?=(?P<PsiI>TTATAA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTATAA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "N"),
}

rest_dict["Psp0357II"] = {
    "charac": (None, None, None, None, "GCGAAG"),
    "compsite": "(?=(?P<Psp0357II>GCGAAG))|(?=(?P<Psp0357II_as>CTTCGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Psp03I"] = {
    "charac": (4, -4, None, None, "GGWCC"),
    "compsite": "(?=(?P<Psp03I>GG[AT]CC))",
    "dna": None,
    "freq": 512.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGWCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Psp124BI"] = {
    "charac": (5, -5, None, None, "GAGCTC"),
    "compsite": "(?=(?P<Psp124BI>GAGCTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "AGCT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Psp1406I"] = {
    "charac": (2, -2, None, None, "AACGTT"),
    "compsite": "(?=(?P<Psp1406I>AACGTT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AACGTT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["Psp5II"] = {
    "charac": (2, -2, None, None, "RGGWCCY"),
    "compsite": "(?=(?P<Psp5II>[AG]GG[AT]CC[CT]))",
    "dna": None,
    "freq": 2048.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGGWCCY",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Psp6I"] = {
    "charac": (0, 0, None, None, "CCWGG"),
    "compsite": "(?=(?P<Psp6I>CC[AT]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "CCWGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["PspCI"] = {
    "charac": (3, -3, None, None, "CACGTG"),
    "compsite": "(?=(?P<PspCI>CACGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGTG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["PspEI"] = {
    "charac": (1, -1, None, None, "GGTNACC"),
    "compsite": "(?=(?P<PspEI>GGT.ACC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "GTNAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTNACC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["PspFI"] = {
    "charac": (1, -1, None, None, "CCCAGC"),
    "compsite": "(?=(?P<PspFI>CCCAGC))|(?=(?P<PspFI_as>GCTGGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCAGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["PspGI"] = {
    "charac": (0, 0, None, None, "CCWGG"),
    "compsite": "(?=(?P<PspGI>CC[AT]GG))",
    "dna": None,
    "freq": 512.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "CCWGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["PspLI"] = {
    "charac": (1, -1, None, None, "CGTACG"),
    "compsite": "(?=(?P<PspLI>CGTACG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GTAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGTACG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["PspN4I"] = {
    "charac": (3, -3, None, None, "GGNNCC"),
    "compsite": "(?=(?P<PspN4I>GG..CC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGNNCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["PspOMI"] = {
    "charac": (1, -1, None, None, "GGGCCC"),
    "compsite": "(?=(?P<PspOMI>GGGCCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGGCCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "N", "V"),
}

rest_dict["PspOMII"] = {
    "charac": (27, 18, None, None, "CGCCCAR"),
    "compsite": "(?=(?P<PspOMII>CGCCCA[AG]))|(?=(?P<PspOMII_as>[CT]TGGGCG))",
    "dna": None,
    "freq": 8192.0,
    "fst3": 18,
    "fst5": 27,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCCCAR",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PspPI"] = {
    "charac": (1, -1, None, None, "GGNCC"),
    "compsite": "(?=(?P<PspPI>GG.CC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GNC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGNCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("C",),
}

rest_dict["PspPPI"] = {
    "charac": (2, -2, None, None, "RGGWCCY"),
    "compsite": "(?=(?P<PspPPI>[AG]GG[AT]CC[CT]))",
    "dna": None,
    "freq": 2048.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGGWCCY",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["PspPRI"] = {
    "charac": (21, 13, None, None, "CCYCAG"),
    "compsite": "(?=(?P<PspPRI>CC[CT]CAG))|(?=(?P<PspPRI_as>CTG[AG]GG))",
    "dna": None,
    "freq": 2048.0,
    "fst3": 13,
    "fst5": 21,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCYCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PspXI"] = {
    "charac": (2, -2, None, None, "VCTCGAGB"),
    "compsite": "(?=(?P<PspXI>[ACG]CTCGAG[CGT]))",
    "dna": None,
    "freq": 7281.777777777777,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TCGA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "VCTCGAGB",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("I", "N"),
}

rest_dict["PsrI"] = {
    "charac": (-7, -25, 25, 7, "GAACNNNNNNTAC"),
    "compsite": "(?=(?P<PsrI>GAAC......TAC))|(?=(?P<PsrI_as>GTA......GTTC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": -25,
    "fst5": -7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": 7,
    "scd5": 25,
    "site": "GAACNNNNNNTAC",
    "size": 13,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["PssI"] = {
    "charac": (5, -5, None, None, "RGGNCCY"),
    "compsite": "(?=(?P<PssI>[AG]GG.CC[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "GNC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGGNCCY",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Pst14472I"] = {
    "charac": (None, None, None, None, "CNYACAC"),
    "compsite": "(?=(?P<Pst14472I>C.[CT]ACAC))|(?=(?P<Pst14472I_as>GTGT[AG].G))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CNYACAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Pst145I"] = {
    "charac": (None, None, None, None, "CTAMRAG"),
    "compsite": "(?=(?P<Pst145I>CTA[AC][AG]AG))|(?=(?P<Pst145I_as>CT[CT][GT]TAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTAMRAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Pst273I"] = {
    "charac": (None, None, None, None, "GATCGAG"),
    "compsite": "(?=(?P<Pst273I>GATCGAG))|(?=(?P<Pst273I_as>CTCGATC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATCGAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PstI"] = {
    "charac": (5, -5, None, None, "CTGCAG"),
    "compsite": "(?=(?P<PstI>CTGCAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "TGCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTGCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X"),
}

rest_dict["PstNI"] = {
    "charac": (6, -6, None, None, "CAGNNNCTG"),
    "compsite": "(?=(?P<PstNI>CAG...CTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAGNNNCTG",
    "size": 9,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["PsuGI"] = {
    "charac": (None, None, None, None, "BBCGD"),
    "compsite": "(?=(?P<PsuGI>[CGT][CGT]CG[AGT]))|(?=(?P<PsuGI_as>[ACT]CG[ACG][ACG]))",
    "dna": None,
    "freq": 37.925925925925924,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "BBCGD",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["PsuI"] = {
    "charac": (1, -1, None, None, "RGATCY"),
    "compsite": "(?=(?P<PsuI>[AG]GATC[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGATCY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["PsyI"] = {
    "charac": (4, -4, None, None, "GACNNNGTC"),
    "compsite": "(?=(?P<PsyI>GAC...GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNGTC",
    "size": 9,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["PteI"] = {
    "charac": (1, -1, None, None, "GCGCGC"),
    "compsite": "(?=(?P<PteI>GCGCGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CGCG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGCGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["PvuI"] = {
    "charac": (4, -4, None, None, "CGATCG"),
    "compsite": "(?=(?P<PvuI>CGATCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "AT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGATCG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "K", "M", "N", "O", "Q", "R", "S", "X"),
}

rest_dict["PvuII"] = {
    "charac": (3, -3, None, None, "CAGCTG"),
    "compsite": "(?=(?P<PvuII>CAGCTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAGCTG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X"),
}

rest_dict["Rba2021I"] = {
    "charac": (None, None, None, None, "CACGAGH"),
    "compsite": "(?=(?P<Rba2021I>CACGAG[ACT]))|(?=(?P<Rba2021I_as>[AGT]CTCGTG))",
    "dna": None,
    "freq": 5461.333333333333,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACGAGH",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RceI"] = {
    "charac": (27, 18, None, None, "CATCGAC"),
    "compsite": "(?=(?P<RceI>CATCGAC))|(?=(?P<RceI_as>GTCGATG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": 18,
    "fst5": 27,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CATCGAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RdeGBI"] = {
    "charac": (None, None, None, None, "CCGCAG"),
    "compsite": "(?=(?P<RdeGBI>CCGCAG))|(?=(?P<RdeGBI_as>CTGCGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RdeGBII"] = {
    "charac": (26, 18, None, None, "ACCCAG"),
    "compsite": "(?=(?P<RdeGBII>ACCCAG))|(?=(?P<RdeGBII_as>CTGGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 18,
    "fst5": 26,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RdeGBIII"] = {
    "charac": (-9, -17, 17, 9, "TGRYCA"),
    "compsite": "(?=(?P<RdeGBIII>TG[AG][CT]CA))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -17,
    "fst5": -9,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": 9,
    "scd5": 17,
    "site": "TGRYCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RflFIII"] = {
    "charac": (None, None, None, None, "CGCCAG"),
    "compsite": "(?=(?P<RflFIII>CGCCAG))|(?=(?P<RflFIII_as>CTGGCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RgaI"] = {
    "charac": (5, -5, None, None, "GCGATCGC"),
    "compsite": "(?=(?P<RgaI>GCGATCGC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "AT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGATCGC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["RigI"] = {
    "charac": (6, -6, None, None, "GGCCGGCC"),
    "compsite": "(?=(?P<RigI>GGCCGGCC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCCGGCC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["RlaI"] = {
    "charac": (None, None, None, None, "VCW"),
    "compsite": "(?=(?P<RlaI>[ACG]C[AT]))|(?=(?P<RlaI_as>[AT]G[CGT]))",
    "dna": None,
    "freq": 10.666666666666666,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "VCW",
    "size": 3,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RlaII"] = {
    "charac": (26, 18, None, None, "ACACAG"),
    "compsite": "(?=(?P<RlaII>ACACAG))|(?=(?P<RlaII_as>CTGTGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 18,
    "fst5": 26,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACACAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RleAI"] = {
    "charac": (18, 9, None, None, "CCCACA"),
    "compsite": "(?=(?P<RleAI>CCCACA))|(?=(?P<RleAI_as>TGTGGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 9,
    "fst5": 18,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCACA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Rmu369III"] = {
    "charac": (None, None, None, None, "GGCYAC"),
    "compsite": "(?=(?P<Rmu369III>GGC[CT]AC))|(?=(?P<Rmu369III_as>GT[AG]GCC))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCYAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RpaB5I"] = {
    "charac": (27, 18, None, None, "CGRGGAC"),
    "compsite": "(?=(?P<RpaB5I>CG[AG]GGAC))|(?=(?P<RpaB5I_as>GTCC[CT]CG))",
    "dna": None,
    "freq": 8192.0,
    "fst3": 18,
    "fst5": 27,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGRGGAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RpaBI"] = {
    "charac": (27, 18, None, None, "CCCGCAG"),
    "compsite": "(?=(?P<RpaBI>CCCGCAG))|(?=(?P<RpaBI_as>CTGCGGG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": 18,
    "fst5": 27,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCGCAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RpaI"] = {
    "charac": (18, 9, None, None, "GTYGGAG"),
    "compsite": "(?=(?P<RpaI>GT[CT]GGAG))|(?=(?P<RpaI_as>CTCC[AG]AC))",
    "dna": None,
    "freq": 8192.0,
    "fst3": 9,
    "fst5": 18,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTYGGAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RpaTI"] = {
    "charac": (None, None, None, None, "GRTGGAG"),
    "compsite": "(?=(?P<RpaTI>G[AG]TGGAG))|(?=(?P<RpaTI_as>CTCCA[CT]C))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRTGGAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RruI"] = {
    "charac": (3, -3, None, None, "TCGCGA"),
    "compsite": "(?=(?P<RruI>TCGCGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCGCGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["RsaI"] = {
    "charac": (2, -2, None, None, "GTAC"),
    "compsite": "(?=(?P<RsaI>GTAC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTAC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "M", "N", "Q", "R", "S", "V", "X", "Y"),
}

rest_dict["RsaNI"] = {
    "charac": (1, -1, None, None, "GTAC"),
    "compsite": "(?=(?P<RsaNI>GTAC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTAC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["RseI"] = {
    "charac": (5, -5, None, None, "CAYNNNNRTG"),
    "compsite": "(?=(?P<RseI>CA[CT]....[AG]TG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAYNNNNRTG",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Rsp008IV"] = {
    "charac": (None, None, None, None, "ACGCAG"),
    "compsite": "(?=(?P<Rsp008IV>ACGCAG))|(?=(?P<Rsp008IV_as>CTGCGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACGCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Rsp008V"] = {
    "charac": (None, None, None, None, "GCCCAT"),
    "compsite": "(?=(?P<Rsp008V>GCCCAT))|(?=(?P<Rsp008V_as>ATGGGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCCAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Rsp531II"] = {
    "charac": (None, None, None, None, "CACACG"),
    "compsite": "(?=(?P<Rsp531II>CACACG))|(?=(?P<Rsp531II_as>CGTGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACACG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["RspPBTS2III"] = {
    "charac": (None, None, None, None, "CTTCGAG"),
    "compsite": "(?=(?P<RspPBTS2III>CTTCGAG))|(?=(?P<RspPBTS2III_as>CTCGAAG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTTCGAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Rsr2I"] = {
    "charac": (2, -2, None, None, "CGGWCCG"),
    "compsite": "(?=(?P<Rsr2I>CGG[AT]CCG))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGWCCG",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["RsrII"] = {
    "charac": (2, -2, None, None, "CGGWCCG"),
    "compsite": "(?=(?P<RsrII>CGG[AT]CCG))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGWCCG",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("N", "Q", "X"),
}

rest_dict["Rtr1953I"] = {
    "charac": (None, None, None, None, "TGANNNNNNTGA"),
    "compsite": "(?=(?P<Rtr1953I>TGA......TGA))|(?=(?P<Rtr1953I_as>TCA......TCA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGANNNNNNTGA",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SacI"] = {
    "charac": (5, -5, None, None, "GAGCTC"),
    "compsite": "(?=(?P<SacI>GAGCTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "AGCT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "J", "K", "M", "N", "O", "Q", "R", "S", "X"),
}

rest_dict["SacII"] = {
    "charac": (4, -4, None, None, "CCGCGG"),
    "compsite": "(?=(?P<SacII>CCGCGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "GC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGCGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "J", "K", "N", "O", "Q", "R", "X"),
}

rest_dict["Saf8902III"] = {
    "charac": (None, None, None, None, "CAATNAG"),
    "compsite": "(?=(?P<Saf8902III>CAAT.AG))|(?=(?P<Saf8902III_as>CT.ATTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAATNAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Sag901I"] = {
    "charac": (None, None, None, None, "GCAAAT"),
    "compsite": "(?=(?P<Sag901I>GCAAAT))|(?=(?P<Sag901I_as>ATTTGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCAAAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SalI"] = {
    "charac": (1, -1, None, None, "GTCGAC"),
    "compsite": "(?=(?P<SalI>GTCGAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TCGA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTCGAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X"),
}

rest_dict["SanDI"] = {
    "charac": (2, -2, None, None, "GGGWCCC"),
    "compsite": "(?=(?P<SanDI>GGG[AT]CCC))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGGWCCC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SapI"] = {
    "charac": (8, 4, None, None, "GCTCTTC"),
    "compsite": "(?=(?P<SapI>GCTCTTC))|(?=(?P<SapI_as>GAAGAGC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": 4,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTCTTC",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["SaqAI"] = {
    "charac": (1, -1, None, None, "TTAA"),
    "compsite": "(?=(?P<SaqAI>TTAA))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTAA",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["SatI"] = {
    "charac": (2, -2, None, None, "GCNGC"),
    "compsite": "(?=(?P<SatI>GC.GC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCNGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Sau3AI"] = {
    "charac": (0, 0, None, None, "GATC"),
    "compsite": "(?=(?P<Sau3AI>GATC))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("C", "J", "K", "M", "N", "R", "X"),
}

rest_dict["Sau64037IV"] = {
    "charac": (None, None, None, None, "GTANNNNNNTGG"),
    "compsite": "(?=(?P<Sau64037IV>GTA......TGG))|(?=(?P<Sau64037IV_as>CCA......TAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTANNNNNNTGG",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Sau96I"] = {
    "charac": (1, -1, None, None, "GGNCC"),
    "compsite": "(?=(?P<Sau96I>GG.CC))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GNC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGNCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("J", "N"),
}

rest_dict["SauI"] = {
    "charac": (2, -2, None, None, "CCTNAGG"),
    "compsite": "(?=(?P<SauI>CCT.AGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "TNA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTNAGG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Sba460II"] = {
    "charac": (None, None, None, None, "GGNGAYG"),
    "compsite": "(?=(?P<Sba460II>GG.GA[CT]G))|(?=(?P<Sba460II_as>C[AG]TC.CC))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGNGAYG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SbfI"] = {
    "charac": (6, -6, None, None, "CCTGCAGG"),
    "compsite": "(?=(?P<SbfI>CCTGCAGG))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "TGCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTGCAGG",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("I", "N", "V"),
}

rest_dict["Sbo46I"] = {
    "charac": (None, None, None, None, "TGAAC"),
    "compsite": "(?=(?P<Sbo46I>TGAAC))|(?=(?P<Sbo46I_as>GTTCA))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TGAAC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["ScaI"] = {
    "charac": (3, -3, None, None, "AGTACT"),
    "compsite": "(?=(?P<ScaI>AGTACT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGTACT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "J", "K", "M", "N", "O", "Q", "R", "S", "X"),
}

rest_dict["SchI"] = {
    "charac": (10, 5, None, None, "GAGTC"),
    "compsite": "(?=(?P<SchI>GAGTC))|(?=(?P<SchI_as>GACTC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 5,
    "fst5": 10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["SciI"] = {
    "charac": (3, -3, None, None, "CTCGAG"),
    "compsite": "(?=(?P<SciI>CTCGAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTCGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["ScoDS2II"] = {
    "charac": (None, None, None, None, "GCTAAT"),
    "compsite": "(?=(?P<ScoDS2II>GCTAAT))|(?=(?P<ScoDS2II_as>ATTAGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCTAAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["ScrFI"] = {
    "charac": (2, -2, None, None, "CCNGG"),
    "compsite": "(?=(?P<ScrFI>CC.GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("J", "N"),
}

rest_dict["SdaI"] = {
    "charac": (6, -6, None, None, "CCTGCAGG"),
    "compsite": "(?=(?P<SdaI>CCTGCAGG))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "TGCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTGCAGG",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["SdeAI"] = {
    "charac": (27, 19, None, None, "CAGRAG"),
    "compsite": "(?=(?P<SdeAI>CAG[AG]AG))|(?=(?P<SdeAI_as>CT[CT]CTG))",
    "dna": None,
    "freq": 2048.0,
    "fst3": 19,
    "fst5": 27,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAGRAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SdeOSI"] = {
    "charac": (-11, -24, 23, 10, "GACNNNNRTGA"),
    "compsite": "(?=(?P<SdeOSI>GAC....[AG]TGA))|(?=(?P<SdeOSI_as>TCA[CT]....GTC))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -24,
    "fst5": -11,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": 10,
    "scd5": 23,
    "site": "GACNNNNRTGA",
    "size": 11,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SduI"] = {
    "charac": (5, -5, None, None, "GDGCHC"),
    "compsite": "(?=(?P<SduI>G[AGT]GC[ACT]C))",
    "dna": None,
    "freq": 455.1111111111111,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "DGCH",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GDGCHC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["SecI"] = {
    "charac": (1, -1, None, None, "CCNNGG"),
    "compsite": "(?=(?P<SecI>CC..GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CNNG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNNGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SelI"] = {
    "charac": (0, 0, None, None, "CGCG"),
    "compsite": "(?=(?P<SelI>CGCG))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CGCG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCG",
    "size": 4,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Sen17963III"] = {
    "charac": (None, None, None, None, "CCAAAC"),
    "compsite": "(?=(?P<Sen17963III>CCAAAC))|(?=(?P<Sen17963III_as>GTTTGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCAAAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SenA1673III"] = {
    "charac": (None, None, None, None, "GNGGCAG"),
    "compsite": "(?=(?P<SenA1673III>G.GGCAG))|(?=(?P<SenA1673III_as>CTGCC.C))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GNGGCAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SenSARA26III"] = {
    "charac": (None, None, None, None, "ACRCAG"),
    "compsite": "(?=(?P<SenSARA26III>AC[AG]CAG))|(?=(?P<SenSARA26III_as>CTG[CT]GT))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACRCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SenTFIV"] = {
    "charac": (None, None, None, None, "GATCAG"),
    "compsite": "(?=(?P<SenTFIV>GATCAG))|(?=(?P<SenTFIV_as>CTGATC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GATCAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SetI"] = {
    "charac": (4, -4, None, None, "ASST"),
    "compsite": "(?=(?P<SetI>A[CG][CG]T))",
    "dna": None,
    "freq": 64.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "ASST",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ASST",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["SexAI"] = {
    "charac": (1, -1, None, None, "ACCWGGT"),
    "compsite": "(?=(?P<SexAI>ACC[AT]GGT))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "CCWGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCWGGT",
    "size": 7,
    "substrat": "DNA",
    "suppl": ("M", "N"),
}

rest_dict["SfaAI"] = {
    "charac": (5, -5, None, None, "GCGATCGC"),
    "compsite": "(?=(?P<SfaAI>GCGATCGC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "AT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGATCGC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["SfaNI"] = {
    "charac": (10, 9, None, None, "GCATC"),
    "compsite": "(?=(?P<SfaNI>GCATC))|(?=(?P<SfaNI_as>GATGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 9,
    "fst5": 10,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCATC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I", "N", "V"),
}

rest_dict["SfcI"] = {
    "charac": (1, -1, None, None, "CTRYAG"),
    "compsite": "(?=(?P<SfcI>CT[AG][CT]AG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TRYA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTRYAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["SfeI"] = {
    "charac": (1, -1, None, None, "CTRYAG"),
    "compsite": "(?=(?P<SfeI>CT[AG][CT]AG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TRYA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTRYAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SfiI"] = {
    "charac": (8, -8, None, None, "GGCCNNNNNGGCC"),
    "compsite": "(?=(?P<SfiI>GGCC.....GGCC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -8,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCCNNNNNGGCC",
    "size": 13,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X"),
}

rest_dict["SfoI"] = {
    "charac": (3, -3, None, None, "GGCGCC"),
    "compsite": "(?=(?P<SfoI>GGCGCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Sfr274I"] = {
    "charac": (1, -1, None, None, "CTCGAG"),
    "compsite": "(?=(?P<Sfr274I>CTCGAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TCGA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTCGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["Sfr303I"] = {
    "charac": (4, -4, None, None, "CCGCGG"),
    "compsite": "(?=(?P<Sfr303I>CCGCGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "GC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGCGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["SfuI"] = {
    "charac": (2, -2, None, None, "TTCGAA"),
    "compsite": "(?=(?P<SfuI>TTCGAA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTCGAA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("M", "S"),
}

rest_dict["SgeI"] = {
    "charac": (13, 13, None, None, "CNNG"),
    "compsite": "(?=(?P<SgeI>C..G))",
    "dna": None,
    "freq": 16.0,
    "fst3": 13,
    "fst5": 13,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CNNG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["SgfI"] = {
    "charac": (5, -5, None, None, "GCGATCGC"),
    "compsite": "(?=(?P<SgfI>GCGATCGC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "AT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGATCGC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("R",),
}

rest_dict["SgrAI"] = {
    "charac": (2, -2, None, None, "CRCCGGYG"),
    "compsite": "(?=(?P<SgrAI>C[AG]CCGG[CT]G))",
    "dna": None,
    "freq": 16384.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CRCCGGYG",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["SgrAII"] = {
    "charac": (None, None, None, None, "CGAGATC"),
    "compsite": "(?=(?P<SgrAII>CGAGATC))|(?=(?P<SgrAII_as>GATCTCG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGAGATC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SgrBI"] = {
    "charac": (4, -4, None, None, "CCGCGG"),
    "compsite": "(?=(?P<SgrBI>CCGCGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "GC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGCGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C",),
}

rest_dict["SgrDI"] = {
    "charac": (2, -2, None, None, "CGTCGACG"),
    "compsite": "(?=(?P<SgrDI>CGTCGACG))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TCGA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGTCGACG",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["SgrTI"] = {
    "charac": (14, 14, None, None, "CCDS"),
    "compsite": "(?=(?P<SgrTI>CC[AGT][CG]))|(?=(?P<SgrTI_as>[CG][ACT]GG))",
    "dna": None,
    "freq": 42.666666666666664,
    "fst3": 14,
    "fst5": 14,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCDS",
    "size": 4,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SgsI"] = {
    "charac": (2, -2, None, None, "GGCGCGCC"),
    "compsite": "(?=(?P<SgsI>GGCGCGCC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CGCG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGCGCC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["SimI"] = {
    "charac": (2, 0, None, None, "GGGTC"),
    "compsite": "(?=(?P<SimI>GGGTC))|(?=(?P<SimI_as>GACCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 0,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GTC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGGTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SinI"] = {
    "charac": (1, -1, None, None, "GGWCC"),
    "compsite": "(?=(?P<SinI>GG[AT]CC))",
    "dna": None,
    "freq": 512.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGWCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("X",),
}

rest_dict["SlaI"] = {
    "charac": (1, -1, None, None, "CTCGAG"),
    "compsite": "(?=(?P<SlaI>CTCGAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TCGA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTCGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C", "Y"),
}

rest_dict["SmaI"] = {
    "charac": (3, -3, None, None, "CCCGGG"),
    "compsite": "(?=(?P<SmaI>CCCGGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCGGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X", "Y"),
}

rest_dict["SmaUMH5I"] = {
    "charac": (None, None, None, None, "CTTGAC"),
    "compsite": "(?=(?P<SmaUMH5I>CTTGAC))|(?=(?P<SmaUMH5I_as>GTCAAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTTGAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SmaUMH8I"] = {
    "charac": (None, None, None, None, "GCGAACB"),
    "compsite": "(?=(?P<SmaUMH8I>GCGAAC[CGT]))|(?=(?P<SmaUMH8I_as>[ACG]GTTCGC))",
    "dna": None,
    "freq": 5461.333333333333,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGAACB",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SmiI"] = {
    "charac": (4, -4, None, None, "ATTTAAAT"),
    "compsite": "(?=(?P<SmiI>ATTTAAAT))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATTTAAAT",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("B", "I", "K", "V"),
}

rest_dict["SmiMI"] = {
    "charac": (5, -5, None, None, "CAYNNNNRTG"),
    "compsite": "(?=(?P<SmiMI>CA[CT]....[AG]TG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAYNNNNRTG",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["SmlI"] = {
    "charac": (1, -1, None, None, "CTYRAG"),
    "compsite": "(?=(?P<SmlI>CT[CT][AG]AG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TYRA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTYRAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["SmoI"] = {
    "charac": (1, -1, None, None, "CTYRAG"),
    "compsite": "(?=(?P<SmoI>CT[CT][AG]AG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TYRA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTYRAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Sna507VIII"] = {
    "charac": (None, None, None, None, "CRTTGAG"),
    "compsite": "(?=(?P<Sna507VIII>C[AG]TTGAG))|(?=(?P<Sna507VIII_as>CTCAA[CT]G))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CRTTGAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SnaBI"] = {
    "charac": (3, -3, None, None, "TACGTA"),
    "compsite": "(?=(?P<SnaBI>TACGTA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TACGTA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C", "K", "M", "N", "R"),
}

rest_dict["SnaI"] = {
    "charac": (None, None, None, None, "GTATAC"),
    "compsite": "(?=(?P<SnaI>GTATAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTATAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Sno506I"] = {
    "charac": (None, None, None, None, "GGCCGAG"),
    "compsite": "(?=(?P<Sno506I>GGCCGAG))|(?=(?P<Sno506I_as>CTCGGCC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCCGAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Spe19205IV"] = {
    "charac": (None, None, None, None, "GGACY"),
    "compsite": "(?=(?P<Spe19205IV>GGAC[CT]))|(?=(?P<Spe19205IV_as>[AG]GTCC))",
    "dna": None,
    "freq": 512.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGACY",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SpeI"] = {
    "charac": (1, -1, None, None, "ACTAGT"),
    "compsite": "(?=(?P<SpeI>ACTAGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CTAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACTAGT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "J", "K", "M", "N", "O", "Q", "R", "S", "X"),
}

rest_dict["SphI"] = {
    "charac": (5, -5, None, None, "GCATGC"),
    "compsite": "(?=(?P<SphI>GCATGC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCATGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "O", "Q", "R", "S", "V", "X"),
}

rest_dict["SplI"] = {
    "charac": (1, -1, None, None, "CGTACG"),
    "compsite": "(?=(?P<SplI>CGTACG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GTAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGTACG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SpnRII"] = {
    "charac": (None, None, None, None, "TCGAG"),
    "compsite": "(?=(?P<SpnRII>TCGAG))|(?=(?P<SpnRII_as>CTCGA))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCGAG",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SpoDI"] = {
    "charac": (None, None, None, None, "GCGGRAG"),
    "compsite": "(?=(?P<SpoDI>GCGG[AG]AG))|(?=(?P<SpoDI_as>CT[CT]CCGC))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGGRAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SrfI"] = {
    "charac": (4, -4, None, None, "GCCCGGGC"),
    "compsite": "(?=(?P<SrfI>GCCCGGGC))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCCCGGGC",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Sse232I"] = {
    "charac": (2, -2, None, None, "CGCCGGCG"),
    "compsite": "(?=(?P<Sse232I>CGCCGGCG))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCCGGCG",
    "size": 8,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Sse8387I"] = {
    "charac": (6, -6, None, None, "CCTGCAGG"),
    "compsite": "(?=(?P<Sse8387I>CCTGCAGG))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -6,
    "fst5": 6,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "TGCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTGCAGG",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["Sse8647I"] = {
    "charac": (2, -2, None, None, "AGGWCCT"),
    "compsite": "(?=(?P<Sse8647I>AGG[AT]CCT))",
    "dna": None,
    "freq": 8192.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGGWCCT",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Sse9I"] = {
    "charac": (0, 0, None, None, "AATT"),
    "compsite": "(?=(?P<Sse9I>AATT))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "AATT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AATT",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["SseBI"] = {
    "charac": (3, -3, None, None, "AGGCCT"),
    "compsite": "(?=(?P<SseBI>AGGCCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGGCCT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C",),
}

rest_dict["SsiI"] = {
    "charac": (1, -1, None, None, "CCGC"),
    "compsite": "(?=(?P<SsiI>CCGC))|(?=(?P<SsiI_as>GCGG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGC",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Ssp6803IV"] = {
    "charac": (None, None, None, None, "GAAGGC"),
    "compsite": "(?=(?P<Ssp6803IV>GAAGGC))|(?=(?P<Ssp6803IV_as>GCCTTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAGGC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Ssp714II"] = {
    "charac": (None, None, None, None, "CGCAGCG"),
    "compsite": "(?=(?P<Ssp714II>CGCAGCG))|(?=(?P<Ssp714II_as>CGCTGCG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGCAGCG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SspD5I"] = {
    "charac": (13, 8, None, None, "GGTGA"),
    "compsite": "(?=(?P<SspD5I>GGTGA))|(?=(?P<SspD5I_as>TCACC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 8,
    "fst5": 13,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGTGA",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SspDI"] = {
    "charac": (1, -1, None, None, "GGCGCC"),
    "compsite": "(?=(?P<SspDI>GGCGCC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GCGC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGCGCC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["SspI"] = {
    "charac": (3, -3, None, None, "AATATT"),
    "compsite": "(?=(?P<SspI>AATATT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AATATT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "N", "Q", "R", "V", "X"),
}

rest_dict["SspJOR1II"] = {
    "charac": (None, None, None, None, "AGCGANC"),
    "compsite": "(?=(?P<SspJOR1II>AGCGA.C))|(?=(?P<SspJOR1II_as>G.TCGCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGCGANC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SspMI"] = {
    "charac": (1, -1, None, None, "CTAG"),
    "compsite": "(?=(?P<SspMI>CTAG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTAG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["SstE37I"] = {
    "charac": (27, 18, None, None, "CGAAGAC"),
    "compsite": "(?=(?P<SstE37I>CGAAGAC))|(?=(?P<SstE37I_as>GTCTTCG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": 18,
    "fst5": 27,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGAAGAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SstI"] = {
    "charac": (5, -5, None, None, "GAGCTC"),
    "compsite": "(?=(?P<SstI>GAGCTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "AGCT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C",),
}

rest_dict["Sth132I"] = {
    "charac": (8, 8, None, None, "CCCG"),
    "compsite": "(?=(?P<Sth132I>CCCG))|(?=(?P<Sth132I_as>CGGG))",
    "dna": None,
    "freq": 256.0,
    "fst3": 8,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCG",
    "size": 4,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Sth20745III"] = {
    "charac": (None, None, None, None, "GGACGAC"),
    "compsite": "(?=(?P<Sth20745III>GGACGAC))|(?=(?P<Sth20745III_as>GTCGTCC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGACGAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Sth302II"] = {
    "charac": (2, -2, None, None, "CCGG"),
    "compsite": "(?=(?P<Sth302II>CCGG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCGG",
    "size": 4,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SthSt3II"] = {
    "charac": (None, None, None, None, "GAAGT"),
    "compsite": "(?=(?P<SthSt3II>GAAGT))|(?=(?P<SthSt3II_as>ACTTC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAAGT",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["StsI"] = {
    "charac": (15, 14, None, None, "GGATG"),
    "compsite": "(?=(?P<StsI>GGATG))|(?=(?P<StsI_as>CATCC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 14,
    "fst5": 15,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "NNNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGATG",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["StuI"] = {
    "charac": (3, -3, None, None, "AGGCCT"),
    "compsite": "(?=(?P<StuI>AGGCCT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGGCCT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "J", "K", "M", "N", "Q", "R", "S", "X"),
}

rest_dict["StyD4I"] = {
    "charac": (0, 0, None, None, "CCNGG"),
    "compsite": "(?=(?P<StyD4I>CC.GG))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "CCNGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCNGG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["StyI"] = {
    "charac": (1, -1, None, None, "CCWWGG"),
    "compsite": "(?=(?P<StyI>CC[AT][AT]GG))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CWWG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCWWGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("C", "J", "N"),
}

rest_dict["SurP32aII"] = {
    "charac": (None, None, None, None, "ACRGAG"),
    "compsite": "(?=(?P<SurP32aII>AC[AG]GAG))|(?=(?P<SurP32aII_as>CTC[CT]GT))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACRGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["SwaI"] = {
    "charac": (4, -4, None, None, "ATTTAAAT"),
    "compsite": "(?=(?P<SwaI>ATTTAAAT))",
    "dna": None,
    "freq": 65536.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATTTAAAT",
    "size": 8,
    "substrat": "DNA",
    "suppl": ("J", "M", "N", "S"),
}

rest_dict["TaaI"] = {
    "charac": (3, -3, None, None, "ACNGT"),
    "compsite": "(?=(?P<TaaI>AC.GT))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACNGT",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["TaiI"] = {
    "charac": (4, -4, None, None, "ACGT"),
    "compsite": "(?=(?P<TaiI>ACGT))",
    "dna": None,
    "freq": 256.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "ACGT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACGT",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["TaqI"] = {
    "charac": (1, -1, None, None, "TCGA"),
    "compsite": "(?=(?P<TaqI>TCGA))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "CG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCGA",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "Q", "R", "S", "V", "X"),
}

rest_dict["TaqII"] = {
    "charac": (17, 9, None, None, "GACCGA"),
    "compsite": "(?=(?P<TaqII>GACCGA))|(?=(?P<TaqII_as>TCGGTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 9,
    "fst5": 17,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACCGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("Q", "X"),
}

rest_dict["TaqIII"] = {
    "charac": (17, 9, None, None, "CACCCA"),
    "compsite": "(?=(?P<TaqIII>CACCCA))|(?=(?P<TaqIII_as>TGGGTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": 9,
    "fst5": 17,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACCCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["TasI"] = {
    "charac": (0, 0, None, None, "AATT"),
    "compsite": "(?=(?P<TasI>AATT))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "AATT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AATT",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["TatI"] = {
    "charac": (1, -1, None, None, "WGTACW"),
    "compsite": "(?=(?P<TatI>[AT]GTAC[AT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GTAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "WGTACW",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["TauI"] = {
    "charac": (4, -4, None, None, "GCSGC"),
    "compsite": "(?=(?P<TauI>GC[CG]GC))",
    "dna": None,
    "freq": 512.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "CSG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCSGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["TfiI"] = {
    "charac": (1, -1, None, None, "GAWTC"),
    "compsite": "(?=(?P<TfiI>GA[AT]TC))",
    "dna": None,
    "freq": 512.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "AWT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAWTC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["TpyTP2I"] = {
    "charac": (None, None, None, None, "ACCAAG"),
    "compsite": "(?=(?P<TpyTP2I>ACCAAG))|(?=(?P<TpyTP2I_as>CTTGGT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACCAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Tru1I"] = {
    "charac": (1, -1, None, None, "TTAA"),
    "compsite": "(?=(?P<Tru1I>TTAA))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTAA",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["Tru9I"] = {
    "charac": (1, -1, None, None, "TTAA"),
    "compsite": "(?=(?P<Tru9I>TTAA))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TTAA",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("I", "M", "R", "V"),
}

rest_dict["TscAI"] = {
    "charac": (7, -7, None, None, "CASTG"),
    "compsite": "(?=(?P<TscAI>CA[CG]TG))",
    "dna": None,
    "freq": 512.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 10,
    "ovhgseq": "NNCASTGNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CASTG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["TseFI"] = {
    "charac": (0, 0, None, None, "GTSAC"),
    "compsite": "(?=(?P<TseFI>GT[CG]AC))",
    "dna": None,
    "freq": 512.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "GTSAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTSAC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["TseI"] = {
    "charac": (1, -1, None, None, "GCWGC"),
    "compsite": "(?=(?P<TseI>GC[AT]GC))",
    "dna": None,
    "freq": 512.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "CWG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCWGC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["TsoI"] = {
    "charac": (17, 9, None, None, "TARCCA"),
    "compsite": "(?=(?P<TsoI>TA[AG]CCA))|(?=(?P<TsoI_as>TGG[CT]TA))",
    "dna": None,
    "freq": 2048.0,
    "fst3": 9,
    "fst5": 17,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TARCCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Tsp45I"] = {
    "charac": (0, 0, None, None, "GTSAC"),
    "compsite": "(?=(?P<Tsp45I>GT[CG]AC))",
    "dna": None,
    "freq": 512.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "GTSAC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTSAC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["Tsp4CI"] = {
    "charac": (3, -3, None, None, "ACNGT"),
    "compsite": "(?=(?P<Tsp4CI>AC.GT))",
    "dna": None,
    "freq": 256.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACNGT",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["TspARh3I"] = {
    "charac": (None, None, None, None, "GRACGAC"),
    "compsite": "(?=(?P<TspARh3I>G[AG]ACGAC))|(?=(?P<TspARh3I_as>GTCGT[CT]C))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GRACGAC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["TspDTI"] = {
    "charac": (16, 9, None, None, "ATGAA"),
    "compsite": "(?=(?P<TspDTI>ATGAA))|(?=(?P<TspDTI_as>TTCAT))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 9,
    "fst5": 16,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATGAA",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("Q", "X"),
}

rest_dict["TspEI"] = {
    "charac": (0, 0, None, None, "AATT"),
    "compsite": "(?=(?P<TspEI>AATT))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "AATT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AATT",
    "size": 4,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["TspGWI"] = {
    "charac": (16, 9, None, None, "ACGGA"),
    "compsite": "(?=(?P<TspGWI>ACGGA))|(?=(?P<TspGWI_as>TCCGT))",
    "dna": None,
    "freq": 1024.0,
    "fst3": 9,
    "fst5": 16,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ACGGA",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("Q", "X"),
}

rest_dict["TspMI"] = {
    "charac": (1, -1, None, None, "CCCGGG"),
    "compsite": "(?=(?P<TspMI>CCCGGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCGGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["TspRI"] = {
    "charac": (7, -7, None, None, "CASTG"),
    "compsite": "(?=(?P<TspRI>CA[CG]TG))",
    "dna": None,
    "freq": 512.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 10,
    "ovhgseq": "NNCASTGNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CASTG",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["TssI"] = {
    "charac": (None, None, None, None, "GAGNNNCTC"),
    "compsite": "(?=(?P<TssI>GAG...CTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGNNNCTC",
    "size": 9,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["TstI"] = {
    "charac": (-8, -25, 24, 7, "CACNNNNNNTCC"),
    "compsite": "(?=(?P<TstI>CAC......TCC))|(?=(?P<TstI_as>GGA......GTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -25,
    "fst5": -8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 5,
    "ovhgseq": "NNNNN",
    "results": None,
    "scd3": 7,
    "scd5": 24,
    "site": "CACNNNNNNTCC",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["TsuI"] = {
    "charac": (None, None, None, None, "GCGAC"),
    "compsite": "(?=(?P<TsuI>GCGAC))|(?=(?P<TsuI_as>GTCGC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GCGAC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Tth111I"] = {
    "charac": (4, -4, None, None, "GACNNNGTC"),
    "compsite": "(?=(?P<Tth111I>GAC...GTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -4,
    "fst5": 4,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACNNNGTC",
    "size": 9,
    "substrat": "DNA",
    "suppl": ("I", "K", "N", "Q", "V", "X"),
}

rest_dict["Tth111II"] = {
    "charac": (17, 9, None, None, "CAARCA"),
    "compsite": "(?=(?P<Tth111II>CAA[AG]CA))|(?=(?P<Tth111II_as>TG[CT]TTG))",
    "dna": None,
    "freq": 2048.0,
    "fst3": 9,
    "fst5": 17,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CAARCA",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["UbaF11I"] = {
    "charac": (None, None, None, None, "TCGTA"),
    "compsite": "(?=(?P<UbaF11I>TCGTA))|(?=(?P<UbaF11I_as>TACGA))",
    "dna": None,
    "freq": 1024.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCGTA",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["UbaF12I"] = {
    "charac": (None, None, None, None, "CTACNNNGTC"),
    "compsite": "(?=(?P<UbaF12I>CTAC...GTC))|(?=(?P<UbaF12I_as>GAC...GTAG))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTACNNNGTC",
    "size": 10,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["UbaF13I"] = {
    "charac": (None, None, None, None, "GAGNNNNNNCTGG"),
    "compsite": "(?=(?P<UbaF13I>GAG......CTGG))|(?=(?P<UbaF13I_as>CCAG......CTC))",
    "dna": None,
    "freq": 16384.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAGNNNNNNCTGG",
    "size": 13,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["UbaF14I"] = {
    "charac": (None, None, None, None, "CCANNNNNTCG"),
    "compsite": "(?=(?P<UbaF14I>CCA.....TCG))|(?=(?P<UbaF14I_as>CGA.....TGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCANNNNNTCG",
    "size": 11,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["UbaF9I"] = {
    "charac": (None, None, None, None, "TACNNNNNRTGT"),
    "compsite": "(?=(?P<UbaF9I>TAC.....[AG]TGT))|(?=(?P<UbaF9I_as>ACA[CT].....GTA))",
    "dna": None,
    "freq": 8192.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TACNNNNNRTGT",
    "size": 12,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["UbaPI"] = {
    "charac": (None, None, None, None, "CGAACG"),
    "compsite": "(?=(?P<UbaPI>CGAACG))|(?=(?P<UbaPI_as>CGTTCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGAACG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["UcoMSI"] = {
    "charac": (-7, -11, 11, 7, "GAGCTC"),
    "compsite": "(?=(?P<UcoMSI>GAGCTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -11,
    "fst5": -7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": 7,
    "scd5": 11,
    "site": "GAGCTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["UnbI"] = {
    "charac": (0, 0, None, None, "GGNCC"),
    "compsite": "(?=(?P<UnbI>GG.CC))",
    "dna": None,
    "freq": 256.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "GGNCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGNCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Van9116I"] = {
    "charac": (None, None, None, None, "CCKAAG"),
    "compsite": "(?=(?P<Van9116I>CC[GT]AAG))|(?=(?P<Van9116I_as>CTT[AC]GG))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCKAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Van91I"] = {
    "charac": (7, -7, None, None, "CCANNNNNTGG"),
    "compsite": "(?=(?P<Van91I>CCA.....TGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -7,
    "fst5": 7,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 3,
    "ovhgseq": "NNN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCANNNNNTGG",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("B", "K"),
}

rest_dict["VchE4II"] = {
    "charac": (None, None, None, None, "RTAAAYG"),
    "compsite": "(?=(?P<VchE4II>[AG]TAAA[CT]G))|(?=(?P<VchE4II_as>C[AG]TTTA[CT]))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RTAAAYG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Vdi96II"] = {
    "charac": (None, None, None, None, "GNCYTAG"),
    "compsite": "(?=(?P<Vdi96II>G.C[CT]TAG))|(?=(?P<Vdi96II_as>CTA[AG]G.C))",
    "dna": None,
    "freq": 2048.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GNCYTAG",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["Vha464I"] = {
    "charac": (1, -1, None, None, "CTTAAG"),
    "compsite": "(?=(?P<Vha464I>CTTAAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TTAA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTTAAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("V",),
}

rest_dict["VneI"] = {
    "charac": (1, -1, None, None, "GTGCAC"),
    "compsite": "(?=(?P<VneI>GTGCAC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TGCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTGCAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}

rest_dict["VpaK11AI"] = {
    "charac": (0, 0, None, None, "GGWCC"),
    "compsite": "(?=(?P<VpaK11AI>GG[AT]CC))",
    "dna": None,
    "freq": 512.0,
    "fst3": 0,
    "fst5": 0,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -5,
    "ovhgseq": "GGWCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGWCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["VpaK11BI"] = {
    "charac": (1, -1, None, None, "GGWCC"),
    "compsite": "(?=(?P<VpaK11BI>GG[AT]CC))",
    "dna": None,
    "freq": 512.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -3,
    "ovhgseq": "GWC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GGWCC",
    "size": 5,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["VspI"] = {
    "charac": (2, -2, None, None, "ATTAAT"),
    "compsite": "(?=(?P<VspI>ATTAAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATTAAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "I", "R", "V"),
}

rest_dict["Vtu19109I"] = {
    "charac": (None, None, None, None, "CACRAYC"),
    "compsite": "(?=(?P<Vtu19109I>CAC[AG]A[CT]C))|(?=(?P<Vtu19109I_as>G[AG]T[CT]GTG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACRAYC",
    "size": 7,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["WviI"] = {
    "charac": (27, 19, None, None, "CACRAG"),
    "compsite": "(?=(?P<WviI>CAC[AG]AG))|(?=(?P<WviI_as>CT[CT]GTG))",
    "dna": None,
    "freq": 2048.0,
    "fst3": 19,
    "fst5": 27,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 2,
    "ovhgseq": "NN",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CACRAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["XagI"] = {
    "charac": (5, -5, None, None, "CCTNNNNNAGG"),
    "compsite": "(?=(?P<XagI>CCT.....AGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTNNNNNAGG",
    "size": 11,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["XapI"] = {
    "charac": (1, -1, None, None, "RAATTY"),
    "compsite": "(?=(?P<XapI>[AG]AATT[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "AATT",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RAATTY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["XbaI"] = {
    "charac": (1, -1, None, None, "TCTAGA"),
    "compsite": "(?=(?P<XbaI>TCTAGA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CTAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TCTAGA",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "C", "I", "J", "K", "M", "N", "Q", "R", "S", "V", "X"),
}

rest_dict["Xca85IV"] = {
    "charac": (None, None, None, None, "TACGAG"),
    "compsite": "(?=(?P<Xca85IV>TACGAG))|(?=(?P<Xca85IV_as>CTCGTA))",
    "dna": None,
    "freq": 4096.0,
    "fst3": None,
    "fst5": None,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": None,
    "ovhgseq": None,
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "TACGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["XceI"] = {
    "charac": (5, -5, None, None, "RCATGY"),
    "compsite": "(?=(?P<XceI>[AG]CATG[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "CATG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RCATGY",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["XcmI"] = {
    "charac": (8, -8, None, None, "CCANNNNNNNNNTGG"),
    "compsite": "(?=(?P<XcmI>CCA.........TGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -8,
    "fst5": 8,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCANNNNNNNNNTGG",
    "size": 15,
    "substrat": "DNA",
    "suppl": ("N",),
}

rest_dict["XhoI"] = {
    "charac": (1, -1, None, None, "CTCGAG"),
    "compsite": "(?=(?P<XhoI>CTCGAG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "TCGA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTCGAG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B", "J", "K", "M", "N", "O", "Q", "R", "S", "X"),
}

rest_dict["XhoII"] = {
    "charac": (1, -1, None, None, "RGATCY"),
    "compsite": "(?=(?P<XhoII>[AG]GATC[CT]))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GATC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "RGATCY",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["XmaI"] = {
    "charac": (1, -1, None, None, "CCCGGG"),
    "compsite": "(?=(?P<XmaI>CCCGGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CCGG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCCGGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "N", "R", "V"),
}

rest_dict["XmaIII"] = {
    "charac": (1, -1, None, None, "CGGCCG"),
    "compsite": "(?=(?P<XmaIII>CGGCCG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "GGCC",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CGGCCG",
    "size": 6,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["XmaJI"] = {
    "charac": (1, -1, None, None, "CCTAGG"),
    "compsite": "(?=(?P<XmaJI>CCTAGG))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -4,
    "ovhgseq": "CTAG",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CCTAGG",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["XmiI"] = {
    "charac": (2, -2, None, None, "GTMKAC"),
    "compsite": "(?=(?P<XmiI>GT[AC][GT]AC))",
    "dna": None,
    "freq": 1024.0,
    "fst3": -2,
    "fst5": 2,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "MK",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GTMKAC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("B",),
}

rest_dict["XmnI"] = {
    "charac": (5, -5, None, None, "GAANNNNTTC"),
    "compsite": "(?=(?P<XmnI>GAA....TTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GAANNNNTTC",
    "size": 10,
    "substrat": "DNA",
    "suppl": ("N", "R"),
}

rest_dict["XspI"] = {
    "charac": (1, -1, None, None, "CTAG"),
    "compsite": "(?=(?P<XspI>CTAG))",
    "dna": None,
    "freq": 256.0,
    "fst3": -1,
    "fst5": 1,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": -2,
    "ovhgseq": "TA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "CTAG",
    "size": 4,
    "substrat": "DNA",
    "suppl": ("K",),
}

rest_dict["YkrI"] = {
    "charac": (11, 9, None, None, "C"),
    "compsite": "(?=(?P<YkrI>C))|(?=(?P<YkrI_as>G))",
    "dna": None,
    "freq": 4.0,
    "fst3": 9,
    "fst5": 11,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 1,
    "ovhgseq": "N",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "C",
    "size": 1,
    "substrat": "DNA",
    "suppl": (),
}

rest_dict["ZraI"] = {
    "charac": (3, -3, None, None, "GACGTC"),
    "compsite": "(?=(?P<ZraI>GACGTC))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "GACGTC",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "N", "V"),
}

rest_dict["ZrmI"] = {
    "charac": (3, -3, None, None, "AGTACT"),
    "compsite": "(?=(?P<ZrmI>AGTACT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -3,
    "fst5": 3,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 0,
    "ovhgseq": "",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "AGTACT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I",),
}

rest_dict["Zsp2I"] = {
    "charac": (5, -5, None, None, "ATGCAT"),
    "compsite": "(?=(?P<Zsp2I>ATGCAT))",
    "dna": None,
    "freq": 4096.0,
    "fst3": -5,
    "fst5": 5,
    "inact_temp": 65,
    "opt_temp": 37,
    "ovhg": 4,
    "ovhgseq": "TGCA",
    "results": None,
    "scd3": None,
    "scd5": None,
    "site": "ATGCAT",
    "size": 6,
    "substrat": "DNA",
    "suppl": ("I", "V"),
}


# Turn black code style off
# fmt: off

suppliers = {}

suppliers["B"] = (
    "Life Technologies",
    ["AanI", "AarI", "AasI", "AatII", "AccI", "Acc65I", "AdeI", "AfaI", "AjiI", "AjuI", "AloI", "AluI", "Alw21I", "Alw26I", "Alw44I", "ApaI", "BalI", "BamHI", "BauI", "BclI", "BcnI", "BcuI", "BfmI", "BfoI", "BfuI", "BglI", "BglII", "Bme1390I", "BmeT110I", "BmsI", "BoxI", "BpiI", "BplI", "Bpu10I", "Bpu1102I", "BseDI", "BseGI", "BseJI", "BseLI", "BseMI", "BseMII", "BseNI", "BseSI", "BseXI", "Bsh1236I", "Bsh1285I", "BshNI", "BshTI", "Bsp68I", "Bsp119I", "Bsp120I", "Bsp143I", "Bsp1407I", "BspLI", "BspOI", "BspPI", "BspTI", "Bst1107I", "BstXI", "Bsu15I", "BsuRI", "BveI", "CaiI", "Cfr9I", "Cfr10I", "Cfr13I", "Cfr42I", "ClaI", "CpoI", "CseI", "CsiI", "Csp6I", "DpnI", "DraI", "Eam1104I", "Eam1105I", "Ecl136II", "Eco24I", "Eco31I", "Eco32I", "Eco47I", "Eco47III", "Eco52I", "Eco57I", "Eco72I", "Eco81I", "Eco88I", "Eco91I", "Eco105I", "Eco130I", "Eco147I", "EcoO109I", "EcoRI", "EcoRII", "EcoRV", "EcoT22I", "EheI", "Esp3I", "FaqI", "FokI", "FspAI", "FspBI", "GsuI", "HaeIII", "HapII", "HhaI", "Hin1I", "Hin1II", "Hin6I", "HincII", "HindIII", "HinfI", "HpaI", "HpaII", "HphI", "Hpy8I", "HpyF3I", "HpyF10VI", "KflI", "KpnI", "Kpn2I", "KspAI", "LguI", "Lsp1109I", "LweI", "MauBI", "MbiI", "MboI", "MboII", "MlsI", "MluI", "MnlI", "Mph1103I", "MreI", "MspI", "MssI", "MunI", "MvaI", "Mva1269I", "NcoI", "NdeI", "NheI", "NmuCI", "NotI", "NruI", "NsbI", "OliI", "PacI", "PaeI", "PagI", "PasI", "PauI", "PdiI", "PdmI", "PfeI", "Pfl23II", "PfoI", "Ppu21I", "PscI", "Psp5II", "Psp1406I", "PspFI", "PstI", "PsuI", "PsyI", "PteI", "PvuI", "PvuII", "RruI", "RsaI", "RseI", "SacI", "SacII", "SalI", "SaqAI", "SatI", "ScaI", "SchI", "SdaI", "SduI", "SfaAI", "SfiI", "SgeI", "SgrDI", "SgsI", "SmaI", "SmiI", "SmoI", "SpeI", "SphI", "SsiI", "SspI", "SspDI", "StuI", "TaaI", "TaiI", "TaqI", "TasI", "TatI", "TauI", "Tru1I", "TscAI", "Van91I", "VspI", "XagI", "XapI", "XbaI", "XceI", "XhoI", "XmaJI", "XmiI"],
)

suppliers["C"] = (
    "Minotech Biotechnology",
    ["AluI", "ApaLI", "AsuII", "BamHI", "BclI", "BglI", "BglII", "BseAI", "BseBI", "BseCI", "BshFI", "BsiSI", "BssAI", "BstEII", "CspAI", "EcoRI", "EcoRV", "HindIII", "HinfI", "HpaI", "KpnI", "MboI", "MspCI", "NaeI", "NcoI", "NheI", "NotI", "NruI", "PspPI", "PstI", "PvuII", "RsaI", "SalI", "Sau3AI", "ScaI", "SfiI", "SgrBI", "SlaI", "SmaI", "SnaBI", "SphI", "SseBI", "SspI", "SstI", "StyI", "TaqI", "XbaI"],
)

suppliers["E"] = (
    "Agilent Technologies",
    ["DpnI"],
)

suppliers["I"] = (
    "SibEnzyme Ltd.",
    ["AatII", "AbsI", "Acc16I", "Acc36I", "Acc65I", "AccB1I", "AccB7I", "AccBSI", "AclI", "AclWI", "AcoI", "AcsI", "AcuI", "AfeI", "AgsI", "AhlI", "AjnI", "AluI", "AluBI", "Ama87I", "AoxI", "ApaI", "ArsI", "AsiGI", "AsiSI", "AspA2I", "AspLEI", "AspS9I", "AsuC2I", "AsuHPI", "AsuNHI", "BamHI", "BarI", "Bbv12I", "BglI", "BglII", "BisI", "BlsI", "Bme18I", "BmtI", "BmuI", "BpmI", "Bpu10I", "Bpu14I", "Bsa29I", "Bsc4I", "Bse1I", "Bse8I", "Bse21I", "Bse118I", "Bse3DI", "BsePI", "BseX3I", "BslFI", "Bso31I", "Bsp13I", "Bsp19I", "Bsp1720I", "BspACI", "BspFNI", "BssECI", "BssNAI", "BssT1I", "Bst6I", "BstACI", "BstAFI", "BstAPI", "BstAUI", "Bst2BI", "BstBAI", "Bst4CI", "BstC8I", "BstDEI", "BstDSI", "BstENI", "BstF5I", "BstFNI", "BstH2I", "BstHHI", "BstKTI", "BstMAI", "BstMBI", "BstMCI", "BstMWI", "BstNSI", "BstPAI", "BstSCI", "BstSFI", "BstSLI", "BstSNI", "Bst2UI", "BstV1I", "BstV2I", "BstXI", "BstX2I", "BsuI", "BsuRI", "BtrI", "CciI", "CciNI", "DraI", "DraIII", "DriI", "DseDI", "EcoICRI", "EcoRI", "EcoRV", "EgeI", "ErhI", "FaeI", "FaiI", "FalI", "FatI", "FauI", "FauNDI", "FblI", "FokI", "FriOI", "Fsp4HI", "GlaI", "GluI", "GsaI", "HaeIII", "HgaI", "HindII", "HindIII", "HinfI", "HpaI", "HpaII", "HpySE526I", "HspAI", "KpnI", "KroI", "Ksp22I", "Kzo9I", "LmnI", "MabI", "MalI", "MboII", "MfeI", "MhlI", "MluI", "Mly113I", "MnlI", "Mox20I", "MroNI", "MroXI", "MspI", "MspA1I", "MspR9I", "MteI", "NruI", "PalAI", "PceI", "PciI", "PciSI", "PcsI", "PctI", "PkrI", "Ple19I", "PpsI", "PsiI", "Psp6I", "Psp124BI", "PspCI", "PspEI", "PspLI", "PspN4I", "PspOMI", "PspPPI", "PspXI", "PsrI", "PstI", "PstNI", "PvuII", "RgaI", "RigI", "RsaI", "RsaNI", "Rsr2I", "SalI", "SbfI", "SetI", "SfaNI", "SfiI", "Sfr274I", "Sfr303I", "SmaI", "SmiI", "SmiMI", "SphI", "Sse9I", "SspI", "SspMI", "TaqI", "Tru9I", "TseFI", "Tth111I", "VneI", "VspI", "XbaI", "XmaI", "ZraI", "ZrmI", "Zsp2I"],
)

suppliers["J"] = (
    "Nippon Gene Co., Ltd.",
    ["AccI", "AccII", "AccIII", "AcyI", "AflII", "AgeI", "AluI", "Alw44I", "ApaI", "AseI", "AvaI", "AvaII", "AxyI", "BalI", "BamHI", "BclI", "BglI", "BglII", "BsmI", "Bsp1286I", "BssHII", "BstEII", "BstXI", "DraI", "EcoO109I", "EcoRI", "EcoRII", "EcoRV", "EcoT38I", "FokI", "FspI", "HaeII", "HaeIII", "HhaI", "HincII", "HindIII", "HinfI", "HpaI", "KpnI", "MboII", "MluI", "MspI", "NarI", "NciI", "NcoI", "NdeI", "NdeII", "NheI", "NotI", "NruI", "NsiI", "NspV", "PstI", "PvuII", "RsaI", "SacI", "SacII", "SalI", "Sau96I", "Sau3AI", "ScaI", "ScrFI", "SfiI", "SmaI", "SpeI", "SphI", "SspI", "StuI", "StyI", "SwaI", "TaqI", "XbaI", "XhoI"],
)

suppliers["K"] = (
    "Takara Bio Inc.",
    ["AatII", "AccI", "AccII", "AccIII", "AfaI", "AflII", "AluI", "Aor13HI", "Aor51HI", "ApaI", "ApaLI", "BalI", "BamHI", "BanII", "BciT130I", "BcnI", "BglI", "BglII", "BlnI", "BmeT110I", "BmgT120I", "Bpu1102I", "Bsp1286I", "Bsp1407I", "BspT104I", "BspT107I", "BssHII", "Bst1107I", "BstPI", "BstXI", "Cfr10I", "ClaI", "CpoI", "DdeI", "DpnI", "DraI", "EaeI", "Eco52I", "Eco81I", "EcoO65I", "EcoO109I", "EcoRI", "EcoRV", "EcoT14I", "EcoT22I", "FbaI", "FokI", "HaeII", "HaeIII", "HapII", "HhaI", "Hin1I", "HincII", "HindIII", "HinfI", "HpaI", "KpnI", "MboI", "MboII", "MflI", "MluI", "MspI", "MunI", "NaeI", "NcoI", "NdeI", "NheI", "NotI", "NruI", "PmaCI", "PshAI", "PshBI", "Psp1406I", "PstI", "PvuI", "PvuII", "SacI", "SacII", "SalI", "Sau3AI", "ScaI", "SfiI", "SmaI", "SmiI", "SnaBI", "SpeI", "SphI", "Sse8387I", "SspI", "StuI", "TaqI", "Tth111I", "Van91I", "VpaK11BI", "XbaI", "XhoI", "XspI"],
)

suppliers["M"] = (
    "Roche Applied Science",
    ["AatII", "AccI", "AflIII", "AluI", "ApaI", "Asp700I", "Asp718I", "BamHI", "BbrPI", "BclI", "BfrI", "BglII", "BlnI", "BsmI", "BssHII", "BstXI", "CfoI", "ClaI", "DdeI", "DpnI", "DraI", "DraIII", "Eco47III", "EcoRI", "EcoRV", "FokI", "HaeIII", "HindII", "HindIII", "HinfI", "HpaI", "KpnI", "KspI", "MaeI", "MaeII", "MaeIII", "MluI", "MluNI", "MroI", "MunI", "MvaI", "MvnI", "NarI", "NcoI", "NdeI", "NdeII", "NheI", "NotI", "NruI", "NsiI", "PstI", "PvuI", "PvuII", "RsaI", "SacI", "SalI", "Sau3AI", "ScaI", "SexAI", "SfiI", "SfuI", "SmaI", "SnaBI", "SpeI", "SphI", "StuI", "SwaI", "TaqI", "Tru9I", "XbaI", "XhoI"],
)

suppliers["N"] = (
    "New England Biolabs",
    ["AatII", "AbaSI", "AccI", "Acc65I", "AciI", "AclI", "AcuI", "AfeI", "AflII", "AflIII", "AgeI", "AhdI", "AleI", "AluI", "AlwI", "AlwNI", "ApaI", "ApaLI", "ApeKI", "ApoI", "AscI", "AseI", "AsiSI", "AvaI", "AvaII", "AvrII", "BaeI", "BaeGI", "BamHI", "BanI", "BanII", "BbsI", "BbvI", "BbvCI", "BccI", "BceAI", "BcgI", "BciVI", "BclI", "BcoDI", "BfaI", "BfuAI", "BglI", "BglII", "BlpI", "BmgBI", "BmrI", "BmtI", "BpmI", "Bpu10I", "BpuEI", "BsaI", "BsaAI", "BsaBI", "BsaHI", "BsaJI", "BsaWI", "BsaXI", "BseRI", "BseYI", "BsgI", "BsiEI", "BsiHKAI", "BsiWI", "BslI", "BsmI", "BsmAI", "BsmBI", "BsmFI", "BsoBI", "Bsp1286I", "BspCNI", "BspDI", "BspEI", "BspHI", "BspMI", "BspQI", "BsrI", "BsrBI", "BsrDI", "BsrFI", "BsrGI", "BssHII", "BssSI", "BstAPI", "BstBI", "BstEII", "BstNI", "BstUI", "BstXI", "BstYI", "BstZ17I", "Bsu36I", "BtgI", "BtgZI", "BtsI", "BtsIMutI", "BtsCI", "Cac8I", "ClaI", "CspCI", "CviAII", "CviKI_1", "CviQI", "DdeI", "DpnI", "DpnII", "DraI", "DraIII", "DrdI", "EaeI", "EagI", "EarI", "EciI", "EcoNI", "EcoO109I", "EcoRI", "EcoRV", "Eco53kI", "Esp3I", "FatI", "FauI", "Fnu4HI", "FokI", "FseI", "FspI", "FspEI", "HaeII", "HaeIII", "HgaI", "HhaI", "HinP1I", "HincII", "HindIII", "HinfI", "HpaI", "HpaII", "HphI", "Hpy99I", "Hpy166II", "Hpy188I", "Hpy188III", "HpyAV", "HpyCH4III", "HpyCH4IV", "HpyCH4V", "KasI", "KpnI", "LpnPI", "MboI", "MboII", "MfeI", "MluI", "MluCI", "MlyI", "MmeI", "MnlI", "MscI", "MseI", "MslI", "MspI", "MspA1I", "MspJI", "MwoI", "NaeI", "NarI", "NciI", "NcoI", "NdeI", "NgoMIV", "NheI", "NlaIII", "NlaIV", "NmeAIII", "NotI", "NruI", "NsiI", "NspI", "PacI", "PaeR7I", "PciI", "PflFI", "PflMI", "PleI", "PluTI", "PmeI", "PmlI", "PpuMI", "PshAI", "PsiI", "PspGI", "PspOMI", "PspXI", "PstI", "PvuI", "PvuII", "RsaI", "RsrII", "SacI", "SacII", "SalI", "SapI", "Sau96I", "Sau3AI", "SbfI", "ScaI", "ScrFI", "SexAI", "SfaNI", "SfcI", "SfiI", "SfoI", "SgrAI", "SmaI", "SmlI", "SnaBI", "SpeI", "SphI", "SrfI", "SspI", "StuI", "StyI", "StyD4I", "SwaI", "TaqI", "TfiI", "TseI", "Tsp45I", "TspMI", "TspRI", "Tth111I", "XbaI", "XcmI", "XhoI", "XmaI", "XmnI", "ZraI"],
)

suppliers["O"] = (
    "Toyobo Biochemicals",
    ["AluI", "BamHI", "BclI", "BglI", "BglII", "DdeI", "DpnI", "EcoRI", "EcoRV", "HaeIII", "HincII", "HindIII", "HinfI", "KpnI", "MluI", "MroI", "MscI", "NcoI", "NheI", "NotI", "PacI", "PstI", "PvuI", "PvuII", "SacI", "SacII", "SalI", "ScaI", "SfiI", "SmaI", "SpeI", "SphI", "XhoI"],
)

suppliers["Q"] = (
    "Molecular Biology Resources - CHIMERx",
    ["AccI", "AcvI", "AluI", "ApaI", "AvaI", "BalI", "BamHI", "BglI", "BglII", "BsiHKCI", "BssHII", "BstXI", "ClaI", "CviJI", "DdeI", "DpnI", "DraI", "EcoRI", "EcoRV", "HaeIII", "HhaI", "HincII", "HindIII", "HinfI", "HpaI", "HpaII", "KpnI", "MboI", "MboII", "MluI", "MnlI", "MspI", "NarI", "NcoI", "NdeI", "NheI", "NotI", "NruI", "NsiI", "PinAI", "PstI", "PvuI", "PvuII", "RsaI", "RsrII", "SacI", "SacII", "SalI", "ScaI", "SfiI", "SmaI", "SpeI", "SphI", "SspI", "StuI", "TaqI", "TaqII", "TspDTI", "TspGWI", "Tth111I", "XbaI", "XhoI"],
)

suppliers["R"] = (
    "Promega Corporation",
    ["AccI", "AccIII", "AgeI", "AluI", "ApaI", "AvaII", "BalI", "BamHI", "BanI", "BclI", "BglI", "BglII", "BssHII", "BstEII", "BstXI", "BstZI", "CfoI", "ClaI", "CspI", "DdeI", "DpnI", "DraI", "Eco47III", "EcoICRI", "EcoRI", "EcoRV", "HaeII", "HaeIII", "HhaI", "HincII", "HindIII", "HinfI", "HpaI", "HpaII", "Hsp92I", "Hsp92II", "KpnI", "MboI", "MboII", "MluI", "MspI", "MspA1I", "NarI", "NciI", "NcoI", "NdeI", "NheI", "NotI", "NruI", "NsiI", "PstI", "PvuI", "PvuII", "RsaI", "SacI", "SacII", "SalI", "Sau3AI", "ScaI", "SfiI", "SgfI", "SmaI", "SnaBI", "SpeI", "SphI", "SspI", "StuI", "TaqI", "Tru9I", "VspI", "XbaI", "XhoI", "XmaI", "XmnI"],
)

suppliers["S"] = (
    "Sigma Chemical Corporation",
    ["AflIII", "AluI", "ApaI", "Asp718I", "BamHI", "BclI", "BfrI", "BglII", "BlnI", "BsmI", "CfoI", "ClaI", "DdeI", "DpnI", "DraI", "EclXI", "Eco47III", "EcoRI", "EcoRV", "HaeIII", "HindII", "HindIII", "HpaI", "KpnI", "KspI", "MaeIII", "MluI", "MunI", "NcoI", "NdeI", "NheI", "NotI", "NruI", "NsiI", "PstI", "PvuI", "PvuII", "RsaI", "SacI", "SalI", "ScaI", "SfiI", "SfuI", "SmaI", "SpeI", "SphI", "StuI", "SwaI", "TaqI", "XbaI", "XhoI"],
)

suppliers["V"] = (
    "Vivantis Technologies",
    ["AatII", "Acc16I", "Acc65I", "AccB1I", "AccB7I", "AccBSI", "AclI", "AcsI", "AfiI", "AhlI", "AluI", "Ama87I", "ApaI", "AsiGI", "AspA2I", "AspLEI", "AspS9I", "AsuHPI", "AsuNHI", "BamHI", "Bbv12I", "BglI", "BglII", "BmcAI", "Bme18I", "BmeRI", "BmiI", "BmrFI", "BmtI", "Bpu10I", "Bpu14I", "BpuMI", "Bse1I", "Bse8I", "Bse21I", "Bse118I", "Bse3DI", "BsePI", "BseX3I", "BshVI", "BsnI", "Bso31I", "Bsp13I", "Bsp19I", "Bsp1720I", "BssMI", "BssNI", "BssNAI", "BssT1I", "Bst6I", "BstAUI", "BstBAI", "Bst4CI", "BstDEI", "BstDSI", "BstENI", "BstF5I", "BstFNI", "BstH2I", "BstHHI", "BstMAI", "BstMBI", "BstMCI", "BstNSI", "BstPAI", "BstSNI", "Bst2UI", "BstV2I", "BstXI", "BstX2I", "BtuMI", "CciNI", "DinI", "DraI", "DraIII", "DseDI", "EcoICRI", "EcoRI", "EcoRV", "FauNDI", "FblI", "FokI", "FriOI", "HindII", "HindIII", "HinfI", "HpaI", "HpaII", "HspAI", "KpnI", "Ksp22I", "MboII", "MhlI", "MluI", "MnlI", "MroNI", "MroXI", "MspI", "Msp20I", "MspA1I", "PceI", "PctI", "Psp124BI", "PspCI", "PspEI", "PspOMI", "PstI", "PvuII", "RsaI", "Rsr2I", "SalI", "SbfI", "SfaNI", "SfiI", "Sfr274I", "Sfr303I", "SmaI", "SmiI", "SmiMI", "SphI", "Sse9I", "SspI", "TaqI", "Tru9I", "Tth111I", "Vha464I", "VneI", "VspI", "XbaI", "XmaI", "ZraI", "Zsp2I"],
)

suppliers["X"] = (
    "EURx Ltd.",
    ["AccI", "AcvI", "AluI", "ApaI", "AvaI", "AvaII", "BalI", "BamHI", "BanII", "BglI", "BglII", "BsiHKCI", "BspANI", "BspMAI", "BspTNI", "BssHII", "BstXI", "BsuTUI", "ClaI", "CviJI", "DdeI", "DpnI", "DraI", "EcoRI", "EcoRV", "FokI", "HaeIII", "HhaI", "HincII", "HindIII", "HinfI", "HpaI", "HpaII", "KpnI", "MboI", "MboII", "MluI", "MmeI", "MnlI", "MspI", "NarI", "NcoI", "NdeI", "NheI", "NotI", "NruI", "NsiI", "PinAI", "PstI", "PvuI", "PvuII", "RsaI", "RsrII", "SacI", "SacII", "SalI", "Sau3AI", "ScaI", "SfiI", "SinI", "SmaI", "SpeI", "SphI", "SspI", "StuI", "TaqI", "TaqII", "TspDTI", "TspGWI", "Tth111I", "XbaI", "XhoI"],
)

suppliers["Y"] = (
    "SinaClon BioScience Co.",
    ["AluI", "BamHI", "BsiSI", "BstXI", "EcoRI", "FokI", "HindIII", "HinfI", "KpnI", "MboI", "NcoI", "RsaI", "SlaI", "SmaI"],
)


typedict = {}

typedict["type130"] = (
    ("Palindromic", "TwoCuts", "Ov5", "Ambiguous", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["NmeDI"],
)

typedict["type132"] = (
    ("Palindromic", "TwoCuts", "Ov5", "Ambiguous", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["UcoMSI"],
)

typedict["type142"] = (
    ("Palindromic", "TwoCuts", "Ov3", "Ambiguous", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["RdeGBIII"],
)

typedict["type143"] = (
    ("Palindromic", "TwoCuts", "Ov3", "Ambiguous", "Meth_Undep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["BplI", "FalI"],
)

typedict["type144"] = (
    ("Palindromic", "TwoCuts", "Ov3", "Ambiguous", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["AlfI", "BdaI"],
)

typedict["type146"] = (
    ("NonPalindromic", "NoCut", "Unknown", "NotDefined", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["Aba6411II", "AbaB8342IV", "AbaCIII", "Abr4036II", "Acc65V", "AchA6III", "Aco12261II", "AcoY31II", "Adh6U21I", "AhyRBAHI", "AhyYL17I", "Aod1I", "Asp103I", "Asp337I", "AspAMDIV", "AspDUT2V", "AspJHL3II", "AspNIH4III", "AspSLV7III", "Asp114pII", "Asu14238IV", "AteTI", "Awo1030IV", "Bag18758I", "BanLI", "Bau1417V", "Bbr52II", "Bbr57III", "Bbr7017II", "Bbr7017III", "BbuB31I", "BbuB31II", "Bce3081I", "BfaSII", "Bga514I", "BkrAM31DI", "Ble402II", "BloAII", "BscGI", "Bsp460III", "Bsp3004IV", "BspNCI", "Bve1B23I", "Cal14237I", "CalB3II", "Cau10061II", "Cba13II", "Cba16038I", "Cbo67071IV", "Cch467III", "Cco14983V", "Cco14983VI", "CcrNAIII", "Cdi11397I", "Cdu23823II", "CfrMH13II", "CfrMH16VI", "Cfupf3II", "Cgl13032I", "Cgl13032II", "Cje265V", "Cje54107III", "CjeFIII", "CjeFV", "CjeNII", "CjeNV", "Cla11845III", "Cly7489II", "Cma23826I", "Csp2014I", "DrdII", "DvuIII", "Ecl234I", "Ecl35734I", "Eco4465II", "Eco43896II", "EcoE1140I", "EcoHSI", "EcoMVII", "EcoNIH6II", "Eli8509II", "EsaSSI", "Esp3007I", "Fba202Z8II", "Fco1691IV", "FspPK15I", "FtnUV", "GauT27I", "Gba708II", "HbaII", "HdeNY26I", "HdeZA17I", "Hpy99XIII", "Hpy99XIV", "Hpy99XIV_mut1", "Hpy99XXII", "Hpy300XI", "HpyAXIV", "HpyAXVI_mut1", "HpyAXVI_mut2", "HpyAXVIII", "HpyUM032XIII_mut1", "HpyUM032XIV", "HpyUM037X", "Hso63373III", "HspMHR1II", "Jma19592I", "Jma19592II", "Jsp2502II", "Kor51II", "Kpn156V", "Kpn327I", "KpnNH25III", "KpnNIH30III", "KpnNIH50I", "Lba2029III", "Lbr124II", "Lde4408II", "LlaG50I", "Lmo370I", "Lmo911II", "Lpl1004II", "Lra68I", "LsaDS4I", "Lsp48III", "Lsp6406VI", "Mba11I", "Mcr10I", "MkaDII", "Mlu211III", "MspI7II", "MspI7IV", "MspSC27II", "MtuHN878II", "Nal45188II", "Nbr128II", "NhaXI", "NpeUS61II", "ObaBS10I", "OgrI", "OspHL35III", "PacIII", "Pac19842II", "PaePA99III", "Pal408I", "Pba2294I", "PcaII", "Pcr308II", "Pdi8503III", "Pdu1735I", "PflPt14I", "PfrJS12IV", "PfrJS12V", "PfrJS15III", "Pin17FIII", "PinP23II", "PinP59III", "PliMI", "PpiP13II", "Pse18267I", "Psp0357II", "Pst145I", "Pst273I", "Pst14472I", "Rba2021I", "RdeGBI", "RflFIII", "Rmu369III", "RpaTI", "Rsp008IV", "Rsp008V", "Rsp531II", "RspPBTS2III", "Rtr1953I", "Saf8902III", "Sag901I", "Sau64037IV", "Sba460II", "Sbo46I", "ScoDS2II", "Sen17963III", "SenA1673III", "SenSARA26III", "SenTFIV", "SgrAII", "SmaUMH5I", "SmaUMH8I", "Sna507VIII", "Sno506I", "Spe19205IV", "SpnRII", "SpoDI", "Ssp714II", "Ssp6803IV", "SspJOR1II", "Sth20745III", "SthSt3II", "SurP32aII", "TpyTP2I", "TspARh3I", "Van9116I", "VchE4II", "Vdi96II", "Vtu19109I", "Xca85IV"],
)

typedict["type148"] = (
    ("NonPalindromic", "NoCut", "Unknown", "NotDefined", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["AbaUMB2I", "AlwFI", "BmgI", "BspGI", "CjeP659IV", "CjuII", "FinI", "PenI", "Pfl1108I", "PsuGI", "RlaI", "TsuI", "UbaF9I", "UbaF11I", "UbaF12I", "UbaF13I", "UbaF14I", "UbaPI"],
)

typedict["type2"] = (
    ("Palindromic", "NoCut", "Unknown", "NotDefined", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["AvaIII", "HpyUM032XIII", "Hso63250IV", "MjaIV"],
)

typedict["type209"] = (
    ("NonPalindromic", "OneCut", "Blunt", "Defined", "Meth_Dep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["BsrBI", "MlyI"],
)

typedict["type210"] = (
    ("NonPalindromic", "OneCut", "Blunt", "Defined", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["NgoAVII"],
)

typedict["type211"] = (
    ("NonPalindromic", "OneCut", "Blunt", "Defined", "Meth_Undep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AccBSI", "AjiI", "BmgBI", "BtrI", "MbiI", "SchI"],
)

typedict["type212"] = (
    ("NonPalindromic", "OneCut", "Blunt", "Defined", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["CdiI", "SspD5I"],
)

typedict["type221"] = (
    ("NonPalindromic", "OneCut", "Ov5", "Defined", "Meth_Dep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AciI", "BbvCI", "BspACI", "BssSI"],
)

typedict["type223"] = (
    ("NonPalindromic", "OneCut", "Ov5", "Defined", "Meth_Undep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["BauI", "BseYI", "Bst2BI", "PspFI", "SsiI"],
)

typedict["type224"] = (
    ("NonPalindromic", "OneCut", "Ov5", "Defined", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["BsiI", "GdiII", "SimI"],
)

typedict["type225"] = (
    ("NonPalindromic", "OneCut", "Ov5", "Ambiguous", "Meth_Dep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AlwI", "Alw26I", "BbvI", "BccI", "BceAI", "BcoDI", "BfuAI", "Bpu10I", "BsaI", "BsmAI", "BsmBI", "BsmFI", "BspMI", "BtgZI", "EarI", "Eco31I", "Esp3I", "FokI", "HgaI", "Lsp1109I", "PleI", "SapI"],
)

typedict["type226"] = (
    ("NonPalindromic", "OneCut", "Ov5", "Ambiguous", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["BscAI", "StsI"],
)

typedict["type227"] = (
    ("NonPalindromic", "OneCut", "Ov5", "Ambiguous", "Meth_Undep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AarI", "Acc36I", "AclWI", "BbsI", "BmsI", "BpiI", "BseXI", "BslFI", "Bso31I", "BspPI", "BspQI", "BspTNI", "Bst6I", "BstMAI", "BstV1I", "BstV2I", "BveI", "CseI", "Eam1104I", "FaqI", "FauI", "FspEI", "LguI", "LpnPI", "LweI", "MspJI", "PciSI", "PpsI", "SfaNI"],
)

typedict["type228"] = (
    ("NonPalindromic", "OneCut", "Ov5", "Ambiguous", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["AceIII", "AspBHI", "BbvII", "BcefI", "BinI", "BspD6I", "EcoBLMcrX", "Ksp632I", "SgrTI", "Sth132I"],
)

typedict["type235"] = (
    ("NonPalindromic", "OneCut", "Ov3", "Defined", "Meth_Undep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["GsaI"],
)

typedict["type237"] = (
    ("NonPalindromic", "OneCut", "Ov3", "Ambiguous", "Meth_Dep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AcuI", "BmrI", "BpmI", "BpuEI", "BseMII", "BseRI", "BsgI", "BspCNI", "BsrI", "BstF5I", "Eco57I", "HphI", "HpyAV", "MboII", "MmeI", "MnlI", "NmeAIII", "TaqII", "TspGWI"],
)

typedict["type238"] = (
    ("NonPalindromic", "OneCut", "Ov3", "Ambiguous", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["AmaCSI", "ApyPI", "AquII", "AquIII", "AquIV", "BfiI", "BsbI", "CchII", "CchIII", "CdpI", "CjeNIII", "CstMI", "DraRI", "DrdIV", "MaqI", "NlaCI", "NmeA6CIII", "PlaDI", "PspOMII", "PspPRI", "RceI", "RdeGBII", "RlaII", "RpaI", "RpaBI", "RpaB5I", "SdeAI", "SstE37I", "TaqIII", "TsoI", "Tth111II", "WviI"],
)

typedict["type239"] = (
    ("NonPalindromic", "OneCut", "Ov3", "Ambiguous", "Meth_Undep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AbaSI", "AsuHPI", "BciVI", "BfuI", "BmuI", "Bse1I", "Bse3DI", "BseGI", "BseMI", "BseNI", "BsmI", "BsrDI", "BsuI", "BtsI", "BtsIMutI", "BtsCI", "EciI", "GsuI", "LmnI", "Mva1269I", "PctI", "TspDTI"],
)

typedict["type240"] = (
    ("NonPalindromic", "OneCut", "Ov3", "Ambiguous", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["Bce83I", "BmeDI", "Eco57MI", "Hin4II", "RleAI", "YkrI"],
)

typedict["type274"] = (
    ("NonPalindromic", "TwoCuts", "Ov5", "Ambiguous", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["BceSIV"],
)

typedict["type285"] = (
    ("NonPalindromic", "TwoCuts", "Ov3", "Ambiguous", "Meth_Dep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AloI", "BcgI", "CspCI"],
)

typedict["type286"] = (
    ("NonPalindromic", "TwoCuts", "Ov3", "Ambiguous", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["CjeI", "NgoAVIII", "PpiI", "SdeOSI", "TstI"],
)

typedict["type287"] = (
    ("NonPalindromic", "TwoCuts", "Ov3", "Ambiguous", "Meth_Undep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AjuI", "ArsI", "BaeI", "BarI", "BsaXI", "PsrI"],
)

typedict["type288"] = (
    ("NonPalindromic", "TwoCuts", "Ov3", "Ambiguous", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["Bsp24I", "CjePI", "Hin4I"],
)

typedict["type4"] = (
    ("Palindromic", "NoCut", "Unknown", "NotDefined", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["CjuI", "Dde51507I", "HgiEII", "NhoI", "SnaI", "TssI"],
)

typedict["type65"] = (
    ("Palindromic", "OneCut", "Blunt", "Defined", "Meth_Dep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AleI", "AluI", "AluBI", "BalI", "BsaAI", "BstC8I", "BstUI", "BsuRI", "Cac8I", "CviJI", "DraI", "EcoRV", "FspI", "HaeIII", "HincII", "HindII", "HpaI", "Hpy8I", "MspA1I", "NaeI", "NlaIV", "NruI", "PmlI", "PshAI", "PsiI", "PvuII", "RsaI", "ScaI", "SfoI", "SmaI", "SnaBI", "SspI", "SwaI", "XmnI"],
)

typedict["type66"] = (
    ("Palindromic", "OneCut", "Blunt", "Defined", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["CviRI", "EsaBC3I", "FnuDII"],
)

typedict["type67"] = (
    ("Palindromic", "OneCut", "Blunt", "Defined", "Meth_Undep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AanI", "AccII", "Acc16I", "AcvI", "AfaI", "AfeI", "Aor51HI", "Asp700I", "BbrPI", "BmcAI", "BmiI", "BoxI", "BsaBI", "Bse8I", "BseJI", "Bsh1236I", "BshFI", "BsnI", "Bsp68I", "BspANI", "BspFNI", "BspLI", "BssNAI", "Bst1107I", "BstBAI", "BstFNI", "BstPAI", "BstSNI", "BstZ17I", "BtuMI", "CviKI_1", "DinI", "DpnI", "Ecl136II", "Eco32I", "Eco47III", "Eco72I", "Eco105I", "Eco147I", "EcoICRI", "Eco53kI", "EgeI", "EheI", "FaiI", "FspAI", "GlaI", "Hpy166II", "HpyCH4V", "KspAI", "MalI", "MlsI", "MluNI", "Mox20I", "MroXI", "MscI", "MslI", "Msp20I", "MssI", "MvnI", "NsbI", "OliI", "PceI", "PdiI", "PdmI", "PmaCI", "PmeI", "Ppu21I", "PspCI", "PspN4I", "RruI", "RseI", "SmiI", "SmiMI", "SrfI", "SseBI", "StuI", "ZraI", "ZrmI"],
)

typedict["type68"] = (
    ("Palindromic", "OneCut", "Blunt", "Defined", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["AhaIII", "HaeI", "LpnI", "MstI", "NspBII", "Pfl8569I", "SciI", "Sth302II"],
)

typedict["type77"] = (
    ("Palindromic", "OneCut", "Ov5", "Defined", "Meth_Dep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AccIII", "Acc65I", "AclI", "AflII", "AgeI", "ApaLI", "ApoI", "AscI", "AseI", "BamHI", "BclI", "BglII", "BsaHI", "BsaWI", "BseCI", "BsiWI", "BspHI", "BsrFI", "BssHII", "BstYI", "Bsu15I", "Cfr9I", "Cfr10I", "ClaI", "CviAII", "CviQI", "DpnII", "EaeI", "EagI", "EcoRI", "FatI", "HapII", "HinP1I", "HindIII", "HpaII", "HpyCH4IV", "HspAI", "KasI", "Kpn2I", "MboI", "MfeI", "MluI", "MseI", "MspI", "MunI", "NcoI", "NdeI", "NgoMIV", "NheI", "NotI", "PaeR7I", "SalI", "Sau3AI", "SgrAI", "Sse9I", "TaqI", "TspMI", "VspI", "XbaI", "XhoI", "XmaI"],
)

typedict["type78"] = (
    ("Palindromic", "OneCut", "Ov5", "Defined", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["BspMII", "CfrI", "XhoII", "XmaIII"],
)

typedict["type79"] = (
    ("Palindromic", "OneCut", "Ov5", "Defined", "Meth_Undep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AbsI", "AcoI", "AcsI", "AcyI", "AhlI", "Alw44I", "Aor13HI", "AoxI", "AsiGI", "Asp718I", "AspA2I", "AsuII", "AsuNHI", "AvrII", "BcuI", "BfaI", "BfrI", "BlnI", "Bpu14I", "Bsa29I", "Bse118I", "BseAI", "BsePI", "BseX3I", "BshTI", "BshVI", "BsiSI", "Bsp13I", "Bsp19I", "Bsp119I", "Bsp120I", "Bsp143I", "Bsp1407I", "BspDI", "BspEI", "BspTI", "BspT104I", "BsrGI", "BssAI", "BssMI", "BssNI", "BstACI", "BstAFI", "BstAUI", "BstBI", "BstMBI", "BstX2I", "BstZI", "BsuTUI", "CciI", "CciNI", "Csp6I", "CspAI", "EclXI", "Eco52I", "FauNDI", "FbaI", "FspBI", "Hin1I", "Hin6I", "HpySE526I", "Hsp92I", "KroI", "Ksp22I", "Kzo9I", "MaeI", "MaeII", "MauBI", "MflI", "MluCI", "Mly113I", "MreI", "MroI", "MroNI", "MspCI", "NarI", "NdeII", "NspV", "PagI", "PalAI", "PauI", "PciI", "Pfl23II", "PinAI", "PscI", "PshBI", "Psp1406I", "PspLI", "PspOMI", "PspXI", "PsuI", "PteI", "RsaNI", "SaqAI", "Sfr274I", "SfuI", "SgrDI", "SgsI", "SlaI", "SpeI", "SspDI", "SspMI", "TasI", "TatI", "Tru1I", "Tru9I", "Vha464I", "VneI", "XapI", "XmaJI", "XspI"],
)

typedict["type80"] = (
    ("Palindromic", "OneCut", "Ov5", "Defined", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["Asi256I", "BetI", "BspLU11I", "Ppu10I", "SelI", "SplI", "Sse232I", "TspEI"],
)

typedict["type81"] = (
    ("Palindromic", "OneCut", "Ov5", "Ambiguous", "Meth_Dep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AccI", "AflIII", "AjnI", "ApeKI", "AspS9I", "AvaI", "AvaII", "BanI", "BcnI", "BlpI", "BsaJI", "BsoBI", "BssECI", "BstNI", "Bsu36I", "Cfr13I", "DdeI", "EcoNI", "EcoO109I", "EcoRII", "Fnu4HI", "Fsp4HI", "HinfI", "MvaI", "NciI", "PpuMI", "PspGI", "PspPI", "RsrII", "Sau96I", "ScrFI", "SexAI", "SinI", "SmlI", "StyI", "StyD4I", "TfiI", "TseI", "Tsp45I", "Tth111I"],
)

typedict["type82"] = (
    ("Palindromic", "OneCut", "Ov5", "Ambiguous", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["EcoHI", "HgiCI"],
)

typedict["type83"] = (
    ("Palindromic", "OneCut", "Ov5", "Ambiguous", "Meth_Undep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AccB1I", "Ama87I", "AsuC2I", "AxyI", "BciT130I", "BfmI", "BisI", "Bme18I", "Bme1390I", "BmeT110I", "BmgT120I", "BmrFI", "Bpu1102I", "BpuMI", "Bse21I", "BseBI", "BseDI", "BshNI", "BsiHKCI", "Bsp1720I", "BspT107I", "BssT1I", "BstDEI", "BstDSI", "BstEII", "BstENI", "BstPI", "BstSCI", "BstSFI", "Bst2UI", "BtgI", "CpoI", "CsiI", "CspI", "Eco47I", "Eco81I", "Eco88I", "Eco91I", "Eco130I", "EcoO65I", "EcoT14I", "ErhI", "FblI", "GluI", "Hpy188III", "HpyF3I", "KflI", "MabI", "MaeIII", "MspR9I", "MteI", "NmuCI", "PasI", "PfeI", "PflFI", "PfoI", "Psp5II", "Psp6I", "PspEI", "PspPPI", "PsyI", "Rsr2I", "SatI", "SfcI", "SgeI", "SmoI", "TseFI", "VpaK11BI", "XagI", "XmiI"],
)

typedict["type84"] = (
    ("Palindromic", "OneCut", "Ov5", "Ambiguous", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["AsuI", "CauII", "DraII", "DsaI", "EspI", "Hpy178III", "SanDI", "SauI", "SecI", "SfeI", "Sse8647I", "UnbI", "VpaK11AI"],
)

typedict["type89"] = (
    ("Palindromic", "OneCut", "Ov3", "Defined", "Meth_Dep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AatII", "ApaI", "AsiSI", "Cfr42I", "FseI", "HaeII", "HhaI", "KpnI", "NlaIII", "NsiI", "NspI", "PluTI", "PstI", "SacI", "SacII"],
)

typedict["type90"] = (
    ("Palindromic", "OneCut", "Ov3", "Defined", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["McaTI", "PabI"],
)

typedict["type91"] = (
    ("Palindromic", "OneCut", "Ov3", "Defined", "Meth_Undep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AspLEI", "BfoI", "BmtI", "BspMAI", "BspOI", "BstH2I", "BstHHI", "BstKTI", "BstNSI", "CfoI", "EcoT22I", "FaeI", "Hin1II", "Hsp92II", "KspI", "Mph1103I", "PacI", "PaeI", "Ple19I", "Psp124BI", "PvuI", "RgaI", "RigI", "SbfI", "SdaI", "SfaAI", "Sfr303I", "SgfI", "SgrBI", "SphI", "Sse8387I", "SstI", "TaiI", "XceI", "Zsp2I"],
)

typedict["type92"] = (
    ("Palindromic", "OneCut", "Ov3", "Defined", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["ChaI", "MspGI"],
)

typedict["type93"] = (
    ("Palindromic", "OneCut", "Ov3", "Ambiguous", "Meth_Dep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AgsI", "AhdI", "BaeGI", "BanII", "BglI", "Bsc4I", "BslI", "Bsp1286I", "BstAPI", "BstXI", "DraIII", "EcoT38I", "Hpy99I", "Hpy188I", "MwoI", "SfiI", "TspRI", "XcmI"],
)

typedict["type94"] = (
    ("Palindromic", "OneCut", "Ov3", "Ambiguous", "Meth_Dep", "Not_available", "AbstractCut", "RestrictionType"),
    ["BthCI", "HauII"],
)

typedict["type95"] = (
    ("Palindromic", "OneCut", "Ov3", "Ambiguous", "Meth_Undep", "Commercially_available", "AbstractCut", "RestrictionType"),
    ["AasI", "AccB7I", "AdeI", "AfiI", "Alw21I", "AlwNI", "Bbv12I", "BlsI", "BmeRI", "BseLI", "BseSI", "Bsh1285I", "BsiEI", "BsiHKAI", "Bst4CI", "BstMCI", "BstMWI", "BstSLI", "CaiI", "DrdI", "DriI", "DseDI", "Eam1105I", "Eco24I", "FriOI", "HpyCH4III", "HpyF10VI", "MhlI", "PcsI", "PflMI", "PkrI", "PstNI", "SduI", "SetI", "TaaI", "TauI", "TscAI", "Van91I"],
)

typedict["type96"] = (
    ("Palindromic", "OneCut", "Ov3", "Ambiguous", "Meth_Undep", "Not_available", "AbstractCut", "RestrictionType"),
    ["ApaBI", "BsiYI", "FmuI", "HgiAI", "HgiJII", "McrI", "Nli3877I", "Psp03I", "PssI", "Tsp4CI"],
)

# Turn black code style on
# fmt: on
