/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command;

import com.twosigma.beakerx.kernel.commands.MavenInvocationSilentOutputHandler;
import com.twosigma.beakerx.kernel.commands.MavenJarResolverSilentLogger;
import com.twosigma.beakerx.kernel.magic.command.PomFactory;
import com.twosigma.beakerx.kernel.magic.command.functionality.MvnLoggerWidget;
import com.twosigma.beakerx.util.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenJarResolver {
    public static final String MVN_DIR = File.separator + "mvnJars";
    public static final String POM_XML = "PomTemplateMagicCommand.xml";
    public static final String GOAL = "validate";
    public static final String MAVEN_BUILT_CLASSPATH_FILE_NAME = "mavenclasspathfilename.txt";
    private static final Logger logger = LoggerFactory.getLogger(MavenJarResolver.class);
    private final String pathToMavenRepo;
    private ResolverParams commandParams;
    private String mavenLocation;
    private PomFactory pomFactory;

    public MavenJarResolver(ResolverParams commandParams, PomFactory pomFactory) {
        this.commandParams = Preconditions.checkNotNull(commandParams);
        this.pathToMavenRepo = this.getOrCreateFile(commandParams.getPathToNotebookJars()).getAbsolutePath();
        this.pomFactory = pomFactory;
    }

    public AddMvnCommandResult retrieve(Dependency dependency, MvnLoggerWidget progress) {
        List<Dependency> dependencies = Collections.singletonList(dependency);
        return this.retrieve(dependencies, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddMvnCommandResult retrieve(List<Dependency> dependencies, MvnLoggerWidget progress) {
        File finalPom = null;
        try {
            String pomAsString = this.pomFactory.createPom(new PomFactory.Params(this.pathToMavenRepo, dependencies, this.commandParams.getRepos(), GOAL, MAVEN_BUILT_CLASSPATH_FILE_NAME));
            finalPom = this.saveToFile(this.commandParams.getPathToNotebookJars(), pomAsString);
            InvocationRequest request = this.createInvocationRequest();
            request.setOffline(this.commandParams.getOffline());
            request.setPomFile(finalPom);
            request.setUpdateSnapshots(true);
            Invoker invoker = this.getInvoker(progress);
            progress.display();
            InvocationResult invocationResult = invoker.execute(request);
            progress.close();
            AddMvnCommandResult addMvnCommandResult = this.getResult(invocationResult, dependencies);
            this.deletePomFolder(finalPom);
            return addMvnCommandResult;
        }
        catch (Exception e) {
            AddMvnCommandResult addMvnCommandResult = AddMvnCommandResult.error(e.getMessage());
            return addMvnCommandResult;
        }
        finally {
            this.deletePomFolder(finalPom);
        }
    }

    private File saveToFile(String pathToNotebookJars, String pomAsString) throws IOException {
        File finalPom = new File(pathToNotebookJars + "/poms/pom-" + UUID.randomUUID() + "-xml");
        FileUtils.writeStringToFile((File)finalPom, (String)pomAsString, (Charset)StandardCharsets.UTF_8);
        return finalPom;
    }

    private Invoker getInvoker(MvnLoggerWidget progress) {
        DefaultInvoker invoker = new DefaultInvoker();
        String mvn = this.findMvn();
        System.setProperty("maven.home", mvn);
        invoker.setLogger((InvokerLogger)new MavenJarResolverSilentLogger());
        invoker.setOutputHandler((InvocationOutputHandler)new MavenInvocationSilentOutputHandler(progress));
        invoker.setLocalRepositoryDirectory(this.getOrCreateFile(this.commandParams.getPathToCache()));
        return invoker;
    }

    public String findMvn() {
        if (this.mavenLocation == null) {
            if (System.getenv("M2_HOME") != null) {
                this.mavenLocation = System.getenv("M2_HOME") + "/bin/mvn";
                return this.mavenLocation;
            }
            for (String dirname : System.getenv("PATH").split(File.pathSeparator)) {
                File file = new File(dirname, "mvn");
                if (!file.isFile() || !file.canExecute()) continue;
                this.mavenLocation = file.getAbsolutePath();
                return this.mavenLocation;
            }
            throw new RuntimeException("No mvn found, please install mvn by 'conda install maven' or setup M2_HOME");
        }
        return this.mavenLocation;
    }

    private AddMvnCommandResult getResult(InvocationResult invocationResult, List<Dependency> dependencies) {
        if (invocationResult.getExitCode() != 0) {
            if (invocationResult.getExecutionException() != null) {
                return AddMvnCommandResult.error(invocationResult.getExecutionException().getMessage());
            }
            StringBuilder errorMsgBuilder = new StringBuilder("Could not resolve dependencies for:");
            for (Dependency dependency : dependencies) {
                errorMsgBuilder.append("\n").append(dependency.groupId).append(" : ").append(dependency.artifactId).append(" : ").append(dependency.version).append(" : ").append(dependency.type);
            }
            return AddMvnCommandResult.error(errorMsgBuilder.toString());
        }
        return AddMvnCommandResult.success(this.transformFromMavenRepoToKernelRepo(this.mavenBuildClasspath(), this.jarsFromRepo()));
    }

    private List<String> transformFromMavenRepoToKernelRepo(List<String> jarNamesFromBuildClasspath, Map<String, Path> jarNames) {
        ArrayList<String> result = new ArrayList<String>();
        jarNamesFromBuildClasspath.forEach(jarName -> {
            if (jarNames.get(jarName) != null) {
                result.add(((Path)jarNames.get(jarName)).toAbsolutePath().toString());
            }
        });
        return result;
    }

    private Map<String, Path> jarsFromRepo() {
        try {
            List collect = Files.list(Paths.get(this.pathToMavenRepo, new String[0])).collect(Collectors.toList());
            return collect.stream().collect(Collectors.toMap(x -> x.getFileName().toString(), x -> x));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> mavenBuildClasspath() {
        String jarPathsAsString = null;
        try {
            File fileToClasspath = new File(this.pathToMavenRepo, MAVEN_BUILT_CLASSPATH_FILE_NAME);
            FileInputStream fileInputStream = new FileInputStream(fileToClasspath);
            jarPathsAsString = IOUtils.toString((InputStream)fileInputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Stream<String> stream = Arrays.stream(jarPathsAsString.split(File.pathSeparator));
        return stream.map(x -> Paths.get(x, new String[0]).getFileName().toString()).collect(Collectors.toList());
    }

    private InvocationRequest createInvocationRequest() {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(Collections.singletonList(GOAL));
        return request;
    }

    private void deletePomFolder(File finalPom) {
        if (finalPom != null) {
            File parentFile = new File(finalPom.getParent());
            try {
                FileUtils.deleteDirectory((File)parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getPathToMavenRepo() {
        return this.pathToMavenRepo;
    }

    private File getOrCreateFile(String pathToMavenRepo) {
        File theDir = new File(pathToMavenRepo);
        if (!theDir.exists()) {
            try {
                theDir.mkdirs();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return theDir;
    }

    public static class ResolverParams {
        private String pathToCache;
        private String pathToNotebookJars;
        private boolean offline = false;
        private Map<String, String> repos = Collections.emptyMap();

        public ResolverParams(String pathToCache, String pathToNotebookJars, boolean offline) {
            this.pathToCache = Preconditions.checkNotNull(pathToCache);
            this.pathToNotebookJars = Preconditions.checkNotNull(pathToNotebookJars);
            this.offline = offline;
        }

        public ResolverParams(String pathToCache, String pathToNotebookJars) {
            this(pathToCache, pathToNotebookJars, false);
        }

        public String getPathToCache() {
            return this.pathToCache;
        }

        public String getPathToNotebookJars() {
            return this.pathToNotebookJars;
        }

        public boolean getOffline() {
            return this.offline;
        }

        public Map<String, String> getRepos() {
            return this.repos;
        }

        public void setRepos(Map<String, String> repos) {
            this.repos = repos;
        }
    }

    public static class AddMvnCommandResult {
        private boolean jarRetrieved;
        private String errorMessage;
        private List<String> addedJarsPaths;

        private AddMvnCommandResult(boolean retrieved, String errorMessage, List<String> addedJarsPaths) {
            this.jarRetrieved = retrieved;
            this.errorMessage = errorMessage;
            this.addedJarsPaths = addedJarsPaths;
        }

        public boolean isJarRetrieved() {
            return this.jarRetrieved;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public static AddMvnCommandResult success(List<String> addedJarsPaths) {
            return new AddMvnCommandResult(true, "", addedJarsPaths);
        }

        public static AddMvnCommandResult error(String msg) {
            return new AddMvnCommandResult(false, msg, new ArrayList<String>());
        }

        public List<String> getAddedJarPaths() {
            return this.addedJarsPaths;
        }
    }

    public static class Dependency {
        static final String DEFAULT_TYPE = "jar";
        private String groupId;
        private String artifactId;
        private String version;
        private String type = "jar";
        private Optional<String> classifier = Optional.empty();

        private Dependency(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public static Dependency create(List<String> args) {
            Dependency dependency = new Dependency(args.get(0), args.get(1), args.get(2));
            if (args.size() > 3) {
                dependency.type = args.get(3);
            }
            if (args.size() > 4) {
                dependency.classifier = Optional.of(args.get(4));
            }
            return dependency;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getType() {
            return this.type;
        }

        public Optional<String> getClassifier() {
            return this.classifier;
        }
    }
}

