/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.sf.jtreemap.swing.TreeMapNode;

public class TreeMapReducer {
    private int limit;

    public TreeMapReducer(int limit) {
        this.limit = limit;
    }

    public TreeMapNode limitTreeMap(TreeMapNode root) {
        Queue<TreeLayer> treeLayers = this.createTreeLayers(root);
        Map<TreeMapNode, TreeMapNode> mapper = this.reduceTreeMapChildren(treeLayers);
        return mapper.get(root);
    }

    private Queue<TreeLayer> createTreeLayers(TreeMapNode root) {
        LinkedList<TreeLayer> treeLayers = new LinkedList<TreeLayer>();
        TreeLayer treeLayer = new TreeLayer();
        treeLayer.addNodeLayer(new NodeLayer(root, root.getChildren()));
        treeLayers.add(treeLayer);
        this.createNextTreeLayer(treeLayer, treeLayers);
        return treeLayers;
    }

    private void createNextTreeLayer(TreeLayer treeLayer, Queue<TreeLayer> treeLayers) {
        TreeLayer newTreeLayer = this.createTreeLayer(treeLayer.getNodeLayers());
        if (!newTreeLayer.getNodeLayers().isEmpty()) {
            treeLayers.add(newTreeLayer);
            this.createNextTreeLayer(newTreeLayer, treeLayers);
        }
    }

    private TreeLayer createTreeLayer(List<NodeLayer> nodeLayers) {
        TreeLayer newTreeLayer = new TreeLayer();
        for (NodeLayer rtl : nodeLayers) {
            List<TreeMapNode> children = rtl.getChildren();
            if (children == null) continue;
            for (TreeMapNode child : children) {
                NodeLayer nodeLayer = new NodeLayer(child, child.getChildren());
                newTreeLayer.addNodeLayer(nodeLayer);
            }
        }
        return newTreeLayer;
    }

    private Map<TreeMapNode, TreeMapNode> reduceTreeMapChildren(Queue<TreeLayer> treeLayers) {
        HashMap<TreeMapNode, TreeMapNode> mapper = new HashMap<TreeMapNode, TreeMapNode>();
        TreeCounter treeCounter = new TreeCounter();
        for (TreeLayer tl : treeLayers) {
            boolean numberOfNodesChanged = true;
            while (numberOfNodesChanged && treeCounter.getCount() <= this.limit) {
                numberOfNodesChanged = tl.addChildToNodeLayers(treeCounter, mapper);
            }
        }
        return mapper;
    }

    private class NodeLayer {
        private final Iterator<TreeMapNode> iter;
        private TreeMapNode node;
        private List<TreeMapNode> children;

        NodeLayer(TreeMapNode node, List<TreeMapNode> children) {
            this.node = node;
            this.children = children;
            this.iter = this.children == null ? Collections.emptyIterator() : children.iterator();
        }

        public TreeMapNode getNode() {
            return this.node;
        }

        public List<TreeMapNode> getChildren() {
            return this.children;
        }

        boolean addChild(TreeCounter treeCounter, Map<TreeMapNode, TreeMapNode> mapper) {
            if (this.iter.hasNext()) {
                if (!mapper.containsKey(this.node)) {
                    TreeMapNode clonedNode = (TreeMapNode)this.node.clone();
                    mapper.put(this.node, clonedNode);
                }
                TreeMapNode child = this.iter.next();
                TreeMapNode clone = (TreeMapNode)child.clone();
                mapper.get(this.node).add(clone);
                mapper.put(child, clone);
                if (child.isLeaf()) {
                    treeCounter.increase();
                }
                return true;
            }
            return false;
        }
    }

    private class TreeLayer {
        private List<NodeLayer> nodeLayers = new LinkedList<NodeLayer>();

        TreeLayer() {
        }

        List<NodeLayer> getNodeLayers() {
            return this.nodeLayers;
        }

        boolean addChildToNodeLayers(TreeCounter treeCounter, Map<TreeMapNode, TreeMapNode> mapper) {
            boolean atLeastOneChildAdded = false;
            for (NodeLayer nl : this.getNodeLayers()) {
                if (treeCounter.getCount() > TreeMapReducer.this.limit) continue;
                atLeastOneChildAdded = nl.addChild(treeCounter, mapper) || atLeastOneChildAdded;
            }
            return atLeastOneChildAdded;
        }

        void addNodeLayer(NodeLayer nodeLayer) {
            this.nodeLayers.add(nodeLayer);
        }
    }

    private class TreeCounter {
        private int count = 1;

        private TreeCounter() {
        }

        public void increase() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

