/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.autocomplete;

import java.util.ArrayList;
import java.util.List;

public class AutocompleteCandidate {
    public static final String EMPTY_NODE = "";
    private int type;
    private String key;
    private List<AutocompleteCandidate> children;

    public AutocompleteCandidate(int t, String k) {
        this.type = t;
        this.key = k;
    }

    public AutocompleteCandidate(int t, String[] k) {
        this.type = t;
        this.key = k[0];
        AutocompleteCandidate p = this;
        for (int i = 1; i < k.length; ++i) {
            AutocompleteCandidate n = new AutocompleteCandidate(t, k[i]);
            p.addChildren(n);
            p = n;
        }
    }

    public AutocompleteCandidate(int t, String[] k, int max) {
        this.type = t;
        this.key = k[0];
        AutocompleteCandidate p = this;
        for (int i = 1; i < max; ++i) {
            AutocompleteCandidate n = new AutocompleteCandidate(t, k[i]);
            p.addChildren(n);
            p = n;
        }
    }

    public AutocompleteCandidate clone() {
        AutocompleteCandidate n = new AutocompleteCandidate(this.type, this.key);
        if (this.children == null) {
            return n;
        }
        for (AutocompleteCandidate c1 : this.children) {
            n.addChildren(c1.clone());
        }
        return n;
    }

    public void addChildren(AutocompleteCandidate a) {
        if (this.children == null) {
            this.children = new ArrayList<AutocompleteCandidate>();
        }
        for (AutocompleteCandidate c1 : this.children) {
            if (!c1.getKey().equals(a.getKey())) continue;
            c1.addChildrens(a.getChildrens());
            return;
        }
        this.children.add(a);
    }

    public int getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public List<AutocompleteCandidate> getChildrens() {
        return this.children;
    }

    public void addChildrens(List<AutocompleteCandidate> chs) {
        if (chs == null) {
            return;
        }
        for (AutocompleteCandidate c : chs) {
            this.addChildren(c);
        }
    }

    public void searchCandidates(List<String> ret, AutocompleteCandidate a) {
        if (a.hasChildren()) {
            if (!this.key.equals(a.getKey())) {
                return;
            }
            if (this.children != null) {
                for (AutocompleteCandidate c1 : this.children) {
                    c1.searchCandidates(ret, a.getChildrens().get(0));
                }
            }
            return;
        }
        if (this.key.startsWith(a.key) && !ret.contains(this.key)) {
            ret.add(this.key);
        }
        if (a.getKey() != EMPTY_NODE && this.children != null) {
            for (AutocompleteCandidate c1 : this.children) {
                c1.searchCandidates(ret, a);
            }
        }
    }

    public AutocompleteCandidate findLeaf() {
        if (this.children != null && this.children.size() > 0) {
            return this.children.get(0).findLeaf();
        }
        return this;
    }
}

