/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx;

import com.twosigma.beakerx.DisplayerDataMapper;
import com.twosigma.beakerx.chart.xychart.Plot;
import com.twosigma.beakerx.chart.xychart.plotitem.XYGraphics;
import com.twosigma.beakerx.kernel.Kernel;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.table.TableDisplay;
import com.twosigma.beakerx.widget.DisplayableWidget;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jupyter.Displayers;

public class MIMEContainerFactory {
    private static List<MIMEContainer> HIDDEN_MIME = Collections.singletonList(MIMEContainer.HIDDEN);

    public static List<MIMEContainer> createMIMEContainers(Object input) {
        if (input == null) {
            return MIMEContainerFactory.getMimeContainerForNull();
        }
        return MIMEContainerFactory.createMIMEContainersFromObject(input);
    }

    public static List<MIMEContainer> getMimeContainerForNull() {
        if (Kernel.showNullExecutionResult) {
            return Collections.singletonList(MIMEContainer.Text("null"));
        }
        return HIDDEN_MIME;
    }

    private static List<MIMEContainer> createMIMEContainersFromObject(Object data) {
        Object input = DisplayerDataMapper.convert(data);
        if (input instanceof DisplayableWidget) {
            ((DisplayableWidget)input).display();
            return HIDDEN_MIME;
        }
        TableDisplay table = MIMEContainerFactory.getTableDisplay(input);
        if (table != null) {
            table.display();
            return HIDDEN_MIME;
        }
        if (input instanceof Collection) {
            return Collections.singletonList(MIMEContainer.Text(MIMEContainerFactory.collectionToString((Collection)input)));
        }
        if (input instanceof XYGraphics) {
            new Plot().add((XYGraphics)input).display();
            return HIDDEN_MIME;
        }
        if (input instanceof MIMEContainer) {
            return Collections.singletonList((MIMEContainer)input);
        }
        return Displayers.display((Object)input).entrySet().stream().map(item -> new MIMEContainer((String)item.getKey(), item.getValue())).collect(Collectors.toList());
    }

    public static TableDisplay getTableDisplay(Object input) {
        Map[] items;
        TableDisplay ret = null;
        if (input instanceof Map) {
            Map map = (Map)input;
            ret = new TableDisplay(map);
        } else if (input instanceof Collection) {
            Object item;
            Collection items2 = (Collection)input;
            if (!items2.isEmpty() && (item = items2.iterator().next()) instanceof Map && ((Map)item).keySet().stream().allMatch(o -> o instanceof String)) {
                ret = new TableDisplay(items2);
            }
        } else if (input instanceof Map[] && (items = (Map[])input).length > 0) {
            ret = new TableDisplay(items);
        }
        return ret;
    }

    private static <E> String collectionToString(Collection<E> collection) {
        Iterator<E> it = collection.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

