/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;

public abstract class WritingAccessProvider {
    public static final ExtensionPointName<WritingAccessProvider> EP_NAME = ExtensionPointName.create("org.jetbrains.kotlin.com.intellij.writingAccessProvider");

    public abstract boolean isPotentiallyWritable(@NotNull VirtualFile var1);

    @NotNull
    public static WritingAccessProvider[] getProvidersForProject(Project project) {
        WritingAccessProvider[] writingAccessProviderArray = project == null || project.isDefault() ? new WritingAccessProvider[]{} : Extensions.getExtensions(EP_NAME, (AreaInstance)project);
        if (writingAccessProviderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/WritingAccessProvider", "getProvidersForProject"));
        }
        return writingAccessProviderArray;
    }

    public static boolean isPotentiallyWritable(VirtualFile file2, Project project) {
        WritingAccessProvider[] providers;
        for (WritingAccessProvider provider : providers = WritingAccessProvider.getProvidersForProject(project)) {
            if (provider.isPotentiallyWritable(file2)) continue;
            return false;
        }
        return true;
    }
}

