/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget.configuration;

import com.twosigma.beakerx.util.Preconditions;
import com.twosigma.beakerx.widget.Button;
import com.twosigma.beakerx.widget.HBox;
import com.twosigma.beakerx.widget.HTML;
import com.twosigma.beakerx.widget.HiveSupport;
import com.twosigma.beakerx.widget.Text;
import com.twosigma.beakerx.widget.VBox;
import com.twosigma.beakerx.widget.Widget;
import com.twosigma.beakerx.widget.configuration.PropertiesWidget;
import com.twosigma.beakerx.widget.configuration.PropertyItem;
import com.twosigma.beakerx.widget.configuration.PropertyItemFactory;
import com.twosigma.beakerx.widget.configuration.PropertyItemFactoryImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SparkConfiguration
extends VBox {
    static final String VIEW_NAME_VALUE = "SparkConfigurationView";
    static final String MODEL_NAME_VALUE = "SparkConfigurationModel";
    private Button add;
    private HBox header;
    private PropertiesWidget properties;
    private HiveSupport hiveSupport;
    private PropertyItemFactory propertyItemFactory;

    public SparkConfiguration(Map<String, String> advancedSettings, String sparkVersion, HiveSupport hiveSupport) {
        this(advancedSettings, sparkVersion, hiveSupport, new Button(), new PropertyItemFactoryImpl());
    }

    SparkConfiguration(Map<String, String> advancedSettings, String sparkVersion, HiveSupport hiveSupport, Button addButton, PropertyItemFactory propertyItemFactory) {
        super(new ArrayList());
        this.hiveSupport = this.configureHiveSupport(hiveSupport);
        this.add = addButton;
        this.propertyItemFactory = propertyItemFactory;
        this.add = this.createAddButton();
        this.header = new HBox(Arrays.asList(this.sparkVersionWidget(sparkVersion), this.add));
        this.addConfiguration(advancedSettings);
    }

    public List<Configuration> getConfiguration() {
        if (this.properties == null) {
            return Collections.EMPTY_LIST;
        }
        List<PropertyItem> children = this.properties.getItems();
        return children.stream().map(x -> new Configuration(x.getNameAsString(), x.getValueAsString())).collect(Collectors.toList());
    }

    public void setConfiguration(Map<String, String> advancedSettings) {
        this.remove((Widget)this.getChildren().get(0));
        this.addConfiguration(advancedSettings);
    }

    public void setDisabledToAll() {
        this.add.setDisabled((Object)true);
        this.properties.disable();
    }

    public void setEnabledToAll() {
        this.add.setDisabled((Object)false);
        this.properties.enable();
    }

    private HiveSupport configureHiveSupport(HiveSupport hiveSupport) {
        hiveSupport.registerActionOnUpdate(this::handleActionOnUpdate);
        return hiveSupport;
    }

    private void handleActionOnUpdate(Boolean value) {
        List<PropertyItem> propertyItem = this.findHiveSupportPropertyItems();
        if (value.booleanValue()) {
            if (propertyItem.isEmpty()) {
                this.addProperty(new Text("spark.sql.catalogImplementation"), new Text("hive"));
            }
        } else {
            this.properties.remove(propertyItem);
        }
    }

    private List<PropertyItem> findHiveSupportPropertyItems() {
        return this.properties.findByName("spark.sql.catalogImplementation", "hive");
    }

    private HTML sparkVersionWidget(String version) {
        HTML html = new HTML();
        String ap = String.format("https://spark.apache.org/docs/%s/configuration.html#available-properties", version);
        html.setValue((Object)("<a target=\"_blank\" href=\"" + ap + "\">Available properties</a>"));
        html.setDomClasses(new ArrayList<String>(Arrays.asList("bx-properties-add-label")));
        return html;
    }

    private List<PropertyItem> createPropertyItems(Map<String, String> advancedSettings) {
        return advancedSettings.entrySet().stream().map(x -> this.createPropertyItem(new Text((String)x.getKey()), new Text((String)x.getValue()), new Button())).collect(Collectors.toList());
    }

    private Button createAddButton() {
        this.add.setTooltip("Add property");
        this.add.setDomClasses(new ArrayList<String>(Arrays.asList("bx-button", "icon-add", "bx-properties-add-button")));
        this.add.registerOnClick((content, message) -> this.addProperty());
        return this.add;
    }

    private void addProperty() {
        this.addProperty(new Text(), new Text());
    }

    private void addProperty(Text nameWidget, Text valueWidget) {
        PropertyItem propertyItem = this.createPropertyItem(nameWidget, valueWidget, new Button());
        this.properties.add(propertyItem);
    }

    private PropertyItem createPropertyItem(Text nameWidget, Text valueWidget, Button remove) {
        PropertyItem propertyItem = this.propertyItemFactory.createPropertyItem(nameWidget, valueWidget, remove);
        remove.registerOnClick((content, message) -> {
            this.properties.remove(propertyItem);
            this.removeHiveSupport();
        });
        nameWidget.registerActionOnUpdate(this::handleActionOnUpdate);
        valueWidget.registerActionOnUpdate(this::handleActionOnUpdate);
        return propertyItem;
    }

    private void handleActionOnUpdate(String value) {
        List<PropertyItem> propertyItem = this.findHiveSupportPropertyItems();
        this.hiveSupport.setValue(!propertyItem.isEmpty());
    }

    private void removeHiveSupport() {
        List<PropertyItem> propertyItem = this.findHiveSupportPropertyItems();
        if (propertyItem.isEmpty()) {
            this.hiveSupport.setValue(false);
        }
    }

    private void addConfiguration(Map<String, String> advancedSettings) {
        this.refreshStateOfHiveSupport(this.hiveSupport, advancedSettings);
        List<PropertyItem> propertyItems = this.createPropertyItems(advancedSettings);
        this.properties = new PropertiesWidget(propertyItems);
        VBox configuration = new VBox(Arrays.asList(this.properties.getWidget(), this.header));
        configuration.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-configuration")));
        this.add((Widget)configuration);
    }

    private void refreshStateOfHiveSupport(HiveSupport hiveSupport, Map<String, String> advancedSettings) {
        String catalogImplementation = advancedSettings.get("spark.sql.catalogImplementation");
        hiveSupport.setValue("hive".equals(catalogImplementation));
    }

    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    public String getModelModuleValue() {
        return "beakerx";
    }

    public String getViewModuleValue() {
        return "beakerx";
    }

    public static class Configuration {
        public static final String PROPERTY_NAME_CAN_NOT_BE_EMPTY = "Property 'name' can not be empty";
        public static final String PROPERTY_VALUE_CAN_NOT_BE_EMPTY = "Property 'value' can not be empty";
        private String name;
        private String value;

        public Configuration(String name, String value) {
            this.name = Preconditions.checkNotEmpty((String)name, (String)PROPERTY_NAME_CAN_NOT_BE_EMPTY);
            this.value = Preconditions.checkNotEmpty((String)value, (String)PROPERTY_VALUE_CAN_NOT_BE_EMPTY);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

