/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputBinary180
extends RowInputBinary {
    Calendar tempCalDefault = new GregorianCalendar();

    public RowInputBinary180(byte[] byArray) {
        super(byArray);
    }

    @Override
    protected TimeData readTime(Type type) {
        if (type.typeCode == 92) {
            long l = this.readLong();
            l = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, l);
            l = HsqlDateTime.getNormalisedTime(l);
            return new TimeData((int)(l / 1000L), 0, 0);
        }
        return new TimeData(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    protected TimestampData readDate(Type type) {
        long l = this.readLong();
        l = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, l);
        l = HsqlDateTime.getNormalisedDate(l);
        return new TimestampData(l / 1000L);
    }

    @Override
    protected TimestampData readTimestamp(Type type) {
        if (type.typeCode == 93) {
            long l = this.readLong();
            int n = this.readInt();
            l = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, l);
            return new TimestampData(l / 1000L, n);
        }
        return new TimestampData(this.readLong(), this.readInt(), this.readInt());
    }
}

