/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.clojure.evaluator;

import clojure.lang.Compiler;
import clojure.lang.DynamicClassLoader;
import clojure.lang.Namespace;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import com.twosigma.beakerx.BeakerXClient;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.autocomplete.MagicCommandAutocompletePatterns;
import com.twosigma.beakerx.clojure.autocomplete.ClojureAutocomplete;
import com.twosigma.beakerx.clojure.autotranslation.NSClientProxy;
import com.twosigma.beakerx.clojure.evaluator.ClojureClassLoaderFactory;
import com.twosigma.beakerx.clojure.evaluator.ClojureWorkerThread;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.ExecutionOptions;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.PathToJar;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClojureEvaluator
extends BaseEvaluator {
    public static final String beaker_clojure_ns = "beaker_clojure_shell";
    private static final Logger logger = LoggerFactory.getLogger((String)ClojureEvaluator.class.getName());
    private List<String> requirements = new ArrayList<String>();
    private DynamicClassLoader loader;
    private Var clojureLoadString = null;
    private ClojureAutocomplete clojureAutocomplete;

    public ClojureEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory, EvaluatorParameters evaluatorParameters, BeakerXClient beakerxClient, MagicCommandAutocompletePatterns autocompletePatterns) {
        super(id, sId, cellExecutor, tempFolderFactory, evaluatorParameters, beakerxClient, autocompletePatterns);
        this.init();
    }

    public ClojureEvaluator(String id, String sId, EvaluatorParameters evaluatorParameters, BeakerXClient beakerxClient, MagicCommandAutocompletePatterns autocompletePatterns) {
        this(id, sId, (CellExecutor)new BeakerCellExecutor("clojure"), (TempFolderFactory)new TempFolderFactoryImpl(), evaluatorParameters, beakerxClient, autocompletePatterns);
    }

    public void resetEnvironment() {
        this.killClojureThreads();
        super.resetEnvironment();
    }

    private void killClojureThreads() {
        this.runCode("(import 'clojure.lang.Agent)\n(.shutdownNow Agent/soloExecutor)\n(import 'java.util.concurrent.Executors) \n(set! Agent/soloExecutor (Executors/newCachedThreadPool))");
    }

    protected void addJarToClassLoader(PathToJar pathToJar) {
        this.loader.addURL(pathToJar.getUrl());
    }

    protected void addImportToClassLoader(ImportPath anImport) {
        this.addImportPathToShell(anImport);
    }

    protected void doResetEnvironment() {
        this.init();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.loader);
        for (ImportPath importPath : this.imports.getImportPaths()) {
            this.addImportPathToShell(importPath);
        }
        for (String string : this.requirements) {
            if (string == null || string.isEmpty()) continue;
            try {
                this.clojureLoadString.invoke((Object)String.format("(require '%s)", string));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        Thread.currentThread().setContextClassLoader(oldLoader);
        this.executorService.shutdown();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    private void addImportPathToShell(ImportPath s) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.loader);
        String ss = s.asString();
        if (!ss.isEmpty()) {
            try {
                this.loader.loadClass(ss);
                this.clojureLoadString.invoke((Object)String.format("(import '%s)", ss));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not create class while loading notebook: " + ss);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }

    public void exit() {
        super.exit();
        this.killAllThreads();
        this.executorService.shutdown();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public TryResult evaluate(SimpleEvaluationObject seo, String code, ExecutionOptions executionOptions) {
        return this.evaluate(seo, new ClojureWorkerThread(this, new JobDescriptor(code, seo, executionOptions)));
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        return this.clojureAutocomplete.find(code, caretPosition);
    }

    Object runCode(String theCode) {
        return this.clojureLoadString.invoke((Object)theCode);
    }

    private void init() {
        this.loader = ClojureClassLoaderFactory.newInstance(this.classPath, this.outDir);
        String loadFunctionPrefix = "run_str";
        try {
            String clojureInitScript = String.format(this.initScriptSource(), beaker_clojure_ns, this.shellId, loadFunctionPrefix, NSClientProxy.class.getName());
            String ns = String.format("%1$s_%2$s", beaker_clojure_ns, this.shellId);
            this.clearClojureNamespace(ns);
            this.clojureLoadString = RT.var((String)ns, (String)String.format("%1$s_%2$s", loadFunctionPrefix, this.shellId));
            Compiler.load((Reader)new StringReader(clojureInitScript));
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        this.clojureAutocomplete = new ClojureAutocomplete(this.clojureLoadString, this.shellId, this.autocompletePatterns);
    }

    private void clearClojureNamespace(String ns) {
        Namespace.remove((Symbol)Symbol.intern(null, (String)ns));
    }

    private String initScriptSource() throws Exception {
        String line;
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/init_clojure_script.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder result = new StringBuilder("");
        while ((line = reader.readLine()) != null) {
            result.append(line).append(System.lineSeparator());
        }
        in.close();
        return result.toString();
    }
}

