/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.clojure.autocomplete;

import clojure.lang.Var;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.autocomplete.AutocompleteServiceBeakerx;
import com.twosigma.beakerx.autocomplete.MagicCommandAutocompletePatterns;
import java.util.ArrayList;
import java.util.Collection;

public class ClojureAutocomplete
extends AutocompleteServiceBeakerx {
    private Var clojureLoadString;
    private String shellId;

    public ClojureAutocomplete(Var clojureLoadString, String shellId, MagicCommandAutocompletePatterns autocompletePatterns) {
        super(autocompletePatterns);
        this.clojureLoadString = clojureLoadString;
        this.shellId = shellId;
    }

    protected AutocompleteResult doAutocomplete(String txt, int cur) {
        return this.autocomplete(txt, cur, this.clojureLoadString, this.shellId);
    }

    private AutocompleteResult autocomplete(String code, int caretPosition, Var clojureLoadString, String shellId) {
        char c;
        int i;
        for (i = caretPosition; i > 0 && Character.isUnicodeIdentifierStart(c = code.charAt(i - 1)) && "[]{}()/\\".indexOf(c) < 0; --i) {
        }
        String _code = code.substring(i, caretPosition);
        String apropos = "(repl_%1$s/apropos \"%2$s\")";
        Object o = clojureLoadString.invoke((Object)String.format(apropos, shellId, _code));
        ArrayList<String> result = new ArrayList<String>();
        for (Object s : (Collection)o) {
            String whole = s.toString();
            int d = whole.indexOf(47);
            if (d > 0) {
                String woNS = whole.substring(d + 1);
                String ns = whole.substring(0, d);
                result.add(woNS);
                String currenClojureNS = String.format("%1$s_%2$s", "beaker_clojure_shell", shellId);
                if (currenClojureNS.equals(ns) || "clojure.core".equals(ns)) continue;
                result.add(whole);
                continue;
            }
            result.add(whole);
        }
        return new AutocompleteResult(result, i);
    }
}

