/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.Display;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.PlainCode;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.scala.magic.command.SparkFactory;
import com.twosigma.beakerx.scala.magic.command.SparkMagicCommandOptions;
import com.twosigma.beakerx.widget.SparkEngineNoUI;
import com.twosigma.beakerx.widget.SparkEngineNoUIImpl;
import com.twosigma.beakerx.widget.SparkEngineWithUI;
import com.twosigma.beakerx.widget.SparkEngineWithUIImpl;
import com.twosigma.beakerx.widget.SparkUI;
import com.twosigma.beakerx.widget.SparkUIApi;
import com.twosigma.beakerx.widget.SparkUiDefaults;
import java.util.List;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkFactoryImpl
implements SparkFactory {
    public static final String SPARK_SESSION_AVAILABLE_BY_SPARK = "SparkSession is available by 'spark'";
    public static final String CONFIGURATION_MUST_BE_PROVIDED = "Body of  %%spark magic command must return SparkConf object or SparkSession.Builder object";
    private KernelFunctionality kernel;
    private SparkEngineNoUIImpl.SparkEngineNoUIFactory sparkEngineNoUIFactory;
    private SparkUI.SparkUIFactory sparkUIFactory;
    private SparkUiDefaults sparkUiDefaults;

    public SparkFactoryImpl(KernelFunctionality kernel, SparkEngineNoUIImpl.SparkEngineNoUIFactory sparkEngineNoUIFactory, SparkUI.SparkUIFactory sparkUIFactory, SparkUiDefaults sparkUiDefaults) {
        this.kernel = kernel;
        this.sparkEngineNoUIFactory = sparkEngineNoUIFactory;
        this.sparkUIFactory = sparkUIFactory;
        this.sparkUiDefaults = sparkUiDefaults;
    }

    @Override
    public MagicCommandOutcomeItem createSpark(MagicCommandExecutionParam param, List<SparkMagicCommandOptions.SparkOptionCommand> options) {
        if (this.noUi(options)) {
            return this.createSparkWithoutUI(param, options);
        }
        return this.createSparkUI(param, options);
    }

    private MagicCommandOutcomeItem createSparkUI(MagicCommandExecutionParam param, List<SparkMagicCommandOptions.SparkOptionCommand> options) {
        if (param.getCommandCodeBlock().isEmpty()) {
            return this.createSparkBasedOnEmptyConfiguration(param, options);
        }
        return this.createSparkBasedOnUserSparkConfiguration(param, (builder, message) -> {
            this.createAndDisplaySparkUI(options, builder, message);
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
        });
    }

    private MagicCommandOutcomeItem createSparkWithoutUI(MagicCommandExecutionParam param, List<SparkMagicCommandOptions.SparkOptionCommand> options) {
        return this.createSparkBasedOnUserSparkConfiguration(param, (builder, message) -> {
            SparkEngineNoUI sparkEngine = this.sparkEngineNoUIFactory.create(builder);
            options.forEach(option -> option.run(sparkEngine, message));
            TryResult configure = sparkEngine.configure(this.kernel, param.getCode().getMessage());
            if (configure.isError()) {
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, configure.error());
            }
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, SPARK_SESSION_AVAILABLE_BY_SPARK);
        });
    }

    private void createAndDisplaySparkUI(List<SparkMagicCommandOptions.SparkOptionCommand> options, SparkSession.Builder builder, Message message) {
        this.sparkUiDefaults.loadDefaults();
        SparkEngineWithUIImpl.SparkEngineWithUIFactoryImpl sparkEngineWithUIFactory = new SparkEngineWithUIImpl.SparkEngineWithUIFactoryImpl();
        SparkEngineWithUI sparkEngineWithUI = sparkEngineWithUIFactory.create(builder);
        options.forEach(option -> option.run(sparkEngineWithUI, message));
        SparkUIApi sparkUI = this.sparkUIFactory.create(builder, sparkEngineWithUI, this.sparkUiDefaults);
        this.displaySparkUI(sparkUI, message);
    }

    private MagicCommandOutcomeItem createSparkBasedOnEmptyConfiguration(MagicCommandExecutionParam param, List<SparkMagicCommandOptions.SparkOptionCommand> options) {
        SimpleEvaluationObject seo = this.createSEO(param);
        InternalVariable.setValue((SimpleEvaluationObject)seo);
        SparkSession.Builder config = SparkSession.builder().config(new SparkConf());
        this.createAndDisplaySparkUI(options, config, param.getCode().getMessage());
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
    }

    private MagicCommandOutcomeItem createSparkBasedOnUserSparkConfiguration(MagicCommandExecutionParam param, SparkRunner sparkRunner) {
        SimpleEvaluationObject seo = this.createSEO(param);
        TryResult either = this.kernel.executeCode(param.getCommandCodeBlock(), seo);
        if (either.isResult()) {
            Optional<SparkSession.Builder> builderFromUser = this.getBuilderFromUser(either.result());
            if (builderFromUser.isPresent()) {
                SparkSession.Builder builder = builderFromUser.get();
                return sparkRunner.run(builder, param.getCode().getMessage());
            }
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, CONFIGURATION_MUST_BE_PROVIDED);
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "There occurs problem during execution of %%spark : " + either.error());
    }

    private Optional<SparkSession.Builder> getBuilderFromUser(Object result) {
        if (result instanceof SparkConf) {
            return Optional.of(SparkSession.builder().config((SparkConf)result));
        }
        if (result instanceof SparkSession.Builder) {
            return Optional.of((SparkSession.Builder)result);
        }
        return Optional.empty();
    }

    private SparkUIApi displaySparkUI(SparkUIApi sparkUI, Message message) {
        Display.display((Object)sparkUI);
        sparkUI.afterDisplay(message);
        return sparkUI;
    }

    private SimpleEvaluationObject createSEO(MagicCommandExecutionParam param) {
        return PlainCode.createSimpleEvaluationObject((String)param.getCommandCodeBlock(), (KernelFunctionality)this.kernel, (Message)param.getCode().getMessage(), (int)param.getExecutionCount());
    }

    private boolean noUi(List<SparkMagicCommandOptions.SparkOptionCommand> options) {
        return options.stream().anyMatch(x -> x.getName().equals("noUI"));
    }

    public static interface SparkRunner {
        public MagicCommandOutput run(SparkSession.Builder var1, Message var2);
    }
}

