/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.uri.ShouldHaveAnchor;
import org.assertj.core.error.uri.ShouldHaveAuthority;
import org.assertj.core.error.uri.ShouldHaveHost;
import org.assertj.core.error.uri.ShouldHaveParameter;
import org.assertj.core.error.uri.ShouldHavePath;
import org.assertj.core.error.uri.ShouldHavePort;
import org.assertj.core.error.uri.ShouldHaveProtocol;
import org.assertj.core.error.uri.ShouldHaveQuery;
import org.assertj.core.error.uri.ShouldHaveUserInfo;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Uris;
import org.assertj.core.util.Objects;
import org.assertj.core.util.VisibleForTesting;

public class Urls {
    private static final Urls INSTANCE = new Urls();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Urls instance() {
        return INSTANCE;
    }

    Urls() {
    }

    public void assertHasProtocol(AssertionInfo info, URL actual, String protocol) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getProtocol(), protocol)) {
            throw this.failures.failure(info, ShouldHaveProtocol.shouldHaveProtocol(actual, protocol));
        }
    }

    public void assertHasPath(AssertionInfo info, URL actual, String path) {
        Comparables.assertNotNull(info, actual);
        if (path == null) {
            throw new IllegalArgumentException("Expecting given path not to be null");
        }
        if (!Objects.areEqual(actual.getPath(), path)) {
            throw this.failures.failure(info, ShouldHavePath.shouldHavePath(actual, path));
        }
    }

    public void assertHasPort(AssertionInfo info, URL actual, int expected) {
        Comparables.assertNotNull(info, actual);
        if (actual.getPort() != expected) {
            throw this.failures.failure(info, ShouldHavePort.shouldHavePort(actual, expected));
        }
    }

    public void assertHasHost(AssertionInfo info, URL actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getHost(), expected)) {
            throw this.failures.failure(info, ShouldHaveHost.shouldHaveHost(actual, expected));
        }
    }

    public void assertHasAuthority(AssertionInfo info, URL actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getAuthority(), expected)) {
            throw this.failures.failure(info, ShouldHaveAuthority.shouldHaveAuthority(actual, expected));
        }
    }

    public void assertHasQuery(AssertionInfo info, URL actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getQuery(), expected)) {
            throw this.failures.failure(info, ShouldHaveQuery.shouldHaveQuery(actual, expected));
        }
    }

    public void assertHasAnchor(AssertionInfo info, URL actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getRef(), expected)) {
            throw this.failures.failure(info, ShouldHaveAnchor.shouldHaveAnchor(actual, expected));
        }
    }

    public void assertHasUserInfo(AssertionInfo info, URL actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getUserInfo(), expected)) {
            throw this.failures.failure(info, ShouldHaveUserInfo.shouldHaveUserInfo(actual, expected));
        }
    }

    public void assertHasParameter(AssertionInfo info, URL actual, String name) {
        Comparables.assertNotNull(info, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (!parameters.containsKey(name)) {
            throw this.failures.failure(info, ShouldHaveParameter.shouldHaveParameter(actual, name));
        }
    }

    public void assertHasParameter(AssertionInfo info, URL actual, String expectedParameterName, String expectedParameterValue) {
        Comparables.assertNotNull(info, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (!parameters.containsKey(expectedParameterName)) {
            throw this.failures.failure(info, ShouldHaveParameter.shouldHaveParameter(actual, expectedParameterName, expectedParameterValue));
        }
        List<String> values = parameters.get(expectedParameterName);
        if (!values.contains(expectedParameterValue)) {
            throw this.failures.failure(info, ShouldHaveParameter.shouldHaveParameter(actual, expectedParameterName, expectedParameterValue, values));
        }
    }

    public void assertHasNoParameters(AssertionInfo info, URL actual) {
        Comparables.assertNotNull(info, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (!parameters.isEmpty()) {
            throw this.failures.failure(info, ShouldHaveParameter.shouldHaveNoParameters(actual, parameters.keySet()));
        }
    }

    public void assertHasNoParameter(AssertionInfo info, URL actual, String name) {
        Comparables.assertNotNull(info, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (parameters.containsKey(name)) {
            throw this.failures.failure(info, ShouldHaveParameter.shouldHaveNoParameter(actual, name, parameters.get(name)));
        }
    }

    public void assertHasNoParameter(AssertionInfo info, URL actual, String name, String unwantedValue) {
        List<String> values;
        Comparables.assertNotNull(info, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (parameters.containsKey(name) && (values = parameters.get(name)).contains(unwantedValue)) {
            throw this.failures.failure(info, ShouldHaveParameter.shouldHaveNoParameter(actual, name, unwantedValue, values));
        }
    }
}

