/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractBooleanArrayAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.AbstractCharArrayAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractCharacterAssert;
import org.assertj.core.api.AbstractClassAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.AbstractDoubleArrayAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractFloatArrayAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractInputStreamAssert;
import org.assertj.core.api.AbstractIntArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractLocalDateAssert;
import org.assertj.core.api.AbstractLocalDateTimeAssert;
import org.assertj.core.api.AbstractLocalTimeAssert;
import org.assertj.core.api.AbstractLongArrayAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractOffsetDateTimeAssert;
import org.assertj.core.api.AbstractOffsetTimeAssert;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.AbstractShortArrayAssert;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AbstractUriAssert;
import org.assertj.core.api.AbstractUrlAssert;
import org.assertj.core.api.AbstractZonedDateTimeAssert;
import org.assertj.core.api.AssertDelegateTarget;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.assertj.core.api.ClassBasedNavigableIterableAssert;
import org.assertj.core.api.ClassBasedNavigableListAssert;
import org.assertj.core.api.CompletableFutureAssert;
import org.assertj.core.api.Condition;
import org.assertj.core.api.DoublePredicateAssert;
import org.assertj.core.api.FactoryBasedNavigableIterableAssert;
import org.assertj.core.api.FactoryBasedNavigableListAssert;
import org.assertj.core.api.Fail;
import org.assertj.core.api.IntPredicateAssert;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.LongPredicateAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.OptionalDoubleAssert;
import org.assertj.core.api.OptionalIntAssert;
import org.assertj.core.api.OptionalLongAssert;
import org.assertj.core.api.PredicateAssert;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.ThrowableTypeAssert;
import org.assertj.core.api.filter.Filters;
import org.assertj.core.api.filter.InFilter;
import org.assertj.core.api.filter.NotFilter;
import org.assertj.core.api.filter.NotInFilter;
import org.assertj.core.condition.AllOf;
import org.assertj.core.condition.AnyOf;
import org.assertj.core.condition.DoesNotHave;
import org.assertj.core.condition.Not;
import org.assertj.core.data.Index;
import org.assertj.core.data.MapEntry;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.groups.Properties;
import org.assertj.core.groups.Tuple;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Files;
import org.assertj.core.util.URLs;
import org.assertj.core.util.introspection.FieldSupport;

@CheckReturnValue
public class Assertions {
    @CheckReturnValue
    public static <T> PredicateAssert<T> assertThat(Predicate<T> actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static IntPredicateAssert assertThat(IntPredicate actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static LongPredicateAssert assertThat(LongPredicate actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static DoublePredicateAssert assertThat(DoublePredicate actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static <T> CompletableFutureAssert<T> assertThat(CompletableFuture<T> actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static <T> OptionalAssert<T> assertThat(Optional<T> actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static OptionalDoubleAssert assertThat(OptionalDouble actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static OptionalIntAssert assertThat(OptionalInt actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static OptionalLongAssert assertThat(OptionalLong actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractBigDecimalAssert<?> assertThat(BigDecimal actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractUriAssert<?> assertThat(URI actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractUrlAssert<?> assertThat(URL actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractBooleanAssert<?> assertThat(boolean actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractBooleanAssert<?> assertThat(Boolean actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractBooleanArrayAssert<?> assertThat(boolean[] actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractByteAssert<?> assertThat(byte actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractByteAssert<?> assertThat(Byte actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractByteArrayAssert<?> assertThat(byte[] actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractCharacterAssert<?> assertThat(char actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractCharArrayAssert<?> assertThat(char[] actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractCharacterAssert<?> assertThat(Character actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractClassAssert<?> assertThat(Class<?> actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractDoubleAssert<?> assertThat(double actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractDoubleAssert<?> assertThat(Double actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractDoubleArrayAssert<?> assertThat(double[] actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractFileAssert<?> assertThat(File actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractInputStreamAssert<?, ? extends InputStream> assertThat(InputStream actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractFloatAssert<?> assertThat(float actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractFloatAssert<?> assertThat(Float actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractFloatArrayAssert<?> assertThat(float[] actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractIntegerAssert<?> assertThat(int actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractIntArrayAssert<?> assertThat(int[] actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractIntegerAssert<?> assertThat(Integer actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    public static <ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> FactoryBasedNavigableIterableAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(Iterable<? extends ELEMENT> actual, AssertFactory<ELEMENT, ELEMENT_ASSERT> assertFactory) {
        return AssertionsForInterfaceTypes.assertThat(actual, assertFactory);
    }

    public static <ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> ClassBasedNavigableIterableAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(ACTUAL actual, Class<ELEMENT_ASSERT> assertClass) {
        return AssertionsForInterfaceTypes.assertThat(actual, assertClass);
    }

    public static <ACTUAL extends List<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> FactoryBasedNavigableListAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(List<? extends ELEMENT> actual, AssertFactory<ELEMENT, ELEMENT_ASSERT> assertFactory) {
        return AssertionsForInterfaceTypes.assertThat(actual, assertFactory);
    }

    public static <ELEMENT, ACTUAL extends List<? extends ELEMENT>, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> ClassBasedNavigableListAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(List<? extends ELEMENT> actual, Class<ELEMENT_ASSERT> assertClass) {
        return AssertionsForInterfaceTypes.assertThat(actual, assertClass);
    }

    @CheckReturnValue
    public static AbstractLongAssert<?> assertThat(long actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractLongAssert<?> assertThat(Long actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractLongArrayAssert<?> assertThat(long[] actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static <T> AbstractObjectAssert<?, T> assertThat(T actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static <T> AbstractObjectArrayAssert<?, T> assertThat(T[] actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractShortAssert<?> assertThat(short actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractShortAssert<?> assertThat(Short actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractShortArrayAssert<?> assertThat(short[] actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractCharSequenceAssert<?, String> assertThat(String actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractDateAssert<?> assertThat(Date actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractZonedDateTimeAssert<?> assertThat(ZonedDateTime actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractLocalDateTimeAssert<?> assertThat(LocalDateTime actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractOffsetDateTimeAssert<?> assertThat(OffsetDateTime actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractOffsetTimeAssert<?> assertThat(OffsetTime actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractLocalTimeAssert<?> assertThat(LocalTime actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractLocalDateAssert<?> assertThat(LocalDate actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractThrowableAssert<?, ? extends Throwable> assertThat(Throwable actual) {
        return AssertionsForClassTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractThrowableAssert<?, ? extends Throwable> assertThatThrownBy(ThrowableAssert.ThrowingCallable shouldRaiseThrowable) {
        return ((AbstractThrowableAssert)((Object)Assertions.assertThat(Assertions.catchThrowable(shouldRaiseThrowable)))).hasBeenThrown();
    }

    public static Throwable catchThrowable(ThrowableAssert.ThrowingCallable shouldRaiseThrowable) {
        return AssertionsForClassTypes.catchThrowable(shouldRaiseThrowable);
    }

    @CheckReturnValue
    public static <T extends Throwable> ThrowableTypeAssert<T> assertThatExceptionOfType(Class<? extends T> exceptionType) {
        return AssertionsForClassTypes.assertThatExceptionOfType(exceptionType);
    }

    public static void setRemoveAssertJRelatedElementsFromStackTrace(boolean removeAssertJRelatedElementsFromStackTrace) {
        Fail.setRemoveAssertJRelatedElementsFromStackTrace(removeAssertJRelatedElementsFromStackTrace);
    }

    public static void fail(String failureMessage) {
        Fail.fail(failureMessage);
    }

    public static void fail(String failureMessage, Object ... args) {
        Fail.fail(failureMessage, args);
    }

    public static void fail(String failureMessage, Throwable realCause) {
        Fail.fail(failureMessage, realCause);
    }

    public static void failBecauseExceptionWasNotThrown(Class<? extends Throwable> exceptionClass) {
        Fail.shouldHaveThrown(exceptionClass);
    }

    public static void shouldHaveThrown(Class<? extends Throwable> exceptionClass) {
        Fail.shouldHaveThrown(exceptionClass);
    }

    public static void setMaxLengthForSingleLineDescription(int maxLengthForSingleLineDescription) {
        StandardRepresentation.setMaxLengthForSingleLineDescription(maxLengthForSingleLineDescription);
    }

    public static void setMaxElementsForPrinting(int maxElementsForPrinting) {
        StandardRepresentation.setMaxElementsForPrinting(maxElementsForPrinting);
    }

    public static <T> Properties<T> extractProperty(String propertyName, Class<T> propertyType) {
        return Properties.extractProperty(propertyName, propertyType);
    }

    public static Properties<Object> extractProperty(String propertyName) {
        return Properties.extractProperty(propertyName);
    }

    public static Tuple tuple(Object ... values) {
        return Tuple.tuple(values);
    }

    public static void setAllowExtractingPrivateFields(boolean allowExtractingPrivateFields) {
        FieldSupport.extraction().setAllowUsingPrivateFields(allowExtractingPrivateFields);
    }

    public static void setAllowComparingPrivateFields(boolean allowComparingPrivateFields) {
        FieldSupport.comparison().setAllowUsingPrivateFields(allowComparingPrivateFields);
    }

    public static <K, V> MapEntry<K, V> entry(K key, V value) {
        return MapEntry.entry(key, value);
    }

    public static Index atIndex(int index) {
        return Index.atIndex(index);
    }

    public static Offset<Double> offset(Double value) {
        return Offset.offset(value);
    }

    public static Offset<Float> offset(Float value) {
        return Offset.offset(value);
    }

    public static Offset<Double> within(Double value) {
        return Offset.offset(value);
    }

    public static Offset<Double> withPrecision(Double value) {
        return Offset.offset(value);
    }

    public static Offset<Float> within(Float value) {
        return Offset.offset(value);
    }

    public static Offset<Float> withPrecision(Float value) {
        return Offset.offset(value);
    }

    public static Offset<BigDecimal> within(BigDecimal value) {
        return Offset.offset(value);
    }

    public static Offset<Byte> within(Byte value) {
        return Offset.offset(value);
    }

    public static Offset<Integer> within(Integer value) {
        return Offset.offset(value);
    }

    public static Offset<Short> within(Short value) {
        return Offset.offset(value);
    }

    public static Offset<Long> within(Long value) {
        return Offset.offset(value);
    }

    public static Percentage withinPercentage(Double value) {
        return Percentage.withPercentage(value);
    }

    public static Percentage withinPercentage(Integer value) {
        return Percentage.withPercentage(value.intValue());
    }

    public static Percentage withinPercentage(Long value) {
        return Percentage.withPercentage(value.longValue());
    }

    public static Offset<Double> byLessThan(Double value) {
        return Offset.offset(value);
    }

    public static Offset<Float> byLessThan(Float value) {
        return Offset.offset(value);
    }

    public static Offset<BigDecimal> byLessThan(BigDecimal value) {
        return Offset.offset(value);
    }

    public static Offset<Byte> byLessThan(Byte value) {
        return Offset.offset(value);
    }

    public static Offset<Integer> byLessThan(Integer value) {
        return Offset.offset(value);
    }

    public static Offset<Short> byLessThan(Short value) {
        return Offset.offset(value);
    }

    public static Offset<Long> byLessThan(Long value) {
        return Offset.offset(value);
    }

    @SafeVarargs
    public static <T> Condition<T> allOf(Condition<? super T> ... conditions) {
        return AllOf.allOf(conditions);
    }

    public static <T> Condition<T> allOf(Iterable<? extends Condition<? super T>> conditions) {
        return AllOf.allOf(conditions);
    }

    @SafeVarargs
    public static <T> Condition<T> anyOf(Condition<? super T> ... conditions) {
        return AnyOf.anyOf(conditions);
    }

    public static <T> Condition<T> anyOf(Iterable<? extends Condition<? super T>> conditions) {
        return AnyOf.anyOf(conditions);
    }

    public static <T> DoesNotHave<T> doesNotHave(Condition<? super T> condition) {
        return DoesNotHave.doesNotHave(condition);
    }

    public static <T> Not<T> not(Condition<? super T> condition) {
        return Not.not(condition);
    }

    public static <E> Filters<E> filter(E[] array) {
        return Filters.filter(array);
    }

    public static <E> Filters<E> filter(Iterable<E> iterableToFilter) {
        return Filters.filter(iterableToFilter);
    }

    public static InFilter in(Object ... values) {
        return InFilter.in(values);
    }

    public static NotInFilter notIn(Object ... valuesNotToMatch) {
        return NotInFilter.notIn(valuesNotToMatch);
    }

    public static NotFilter not(Object valueNotToMatch) {
        return NotFilter.not(valueNotToMatch);
    }

    public static String contentOf(File file, Charset charset) {
        return Files.contentOf(file, charset);
    }

    public static String contentOf(File file, String charsetName) {
        return Files.contentOf(file, charsetName);
    }

    public static String contentOf(File file) {
        return Files.contentOf(file, Charset.defaultCharset());
    }

    public static List<String> linesOf(File file) {
        return Files.linesOf(file, Charset.defaultCharset());
    }

    public static List<String> linesOf(File file, Charset charset) {
        return Files.linesOf(file, charset);
    }

    public static List<String> linesOf(File file, String charsetName) {
        return Files.linesOf(file, charsetName);
    }

    public static String contentOf(URL url, Charset charset) {
        return URLs.contentOf(url, charset);
    }

    public static String contentOf(URL url, String charsetName) {
        return URLs.contentOf(url, charsetName);
    }

    public static String contentOf(URL url) {
        return URLs.contentOf(url, Charset.defaultCharset());
    }

    public static List<String> linesOf(URL url) {
        return URLs.linesOf(url, Charset.defaultCharset());
    }

    public static List<String> linesOf(URL url, Charset charset) {
        return URLs.linesOf(url, charset);
    }

    public static List<String> linesOf(URL url, String charsetName) {
        return URLs.linesOf(url, charsetName);
    }

    public static void setLenientDateParsing(boolean value) {
        AbstractDateAssert.setLenientDateParsing(value);
    }

    public static void registerCustomDateFormat(DateFormat userCustomDateFormat) {
        AbstractDateAssert.registerCustomDateFormat(userCustomDateFormat);
    }

    public static void registerCustomDateFormat(String userCustomDateFormatPattern) {
        AbstractDateAssert.registerCustomDateFormat(userCustomDateFormatPattern);
    }

    public static void useDefaultDateFormatsOnly() {
        AbstractDateAssert.useDefaultDateFormatsOnly();
    }

    public static <T> T assertThat(AssertProvider<T> component) {
        return (T)AssertionsForInterfaceTypes.assertThat(component);
    }

    @CheckReturnValue
    public static AbstractCharSequenceAssert<?, ? extends CharSequence> assertThat(CharSequence actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static <ELEMENT> IterableAssert<ELEMENT> assertThat(Iterable<? extends ELEMENT> actual) {
        return new IterableAssert<ELEMENT>(actual);
    }

    @CheckReturnValue
    public static <ELEMENT> IterableAssert<ELEMENT> assertThat(Iterator<? extends ELEMENT> actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static <ELEMENT> ListAssert<ELEMENT> assertThat(List<? extends ELEMENT> actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static <ELEMENT> AbstractListAssert<?, List<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> assertThat(Stream<? extends ELEMENT> actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static AbstractPathAssert<?> assertThat(Path actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static <K, V> MapAssert<K, V> assertThat(Map<K, V> actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static <T extends Comparable<? super T>> AbstractComparableAssert<?, T> assertThat(T actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    @CheckReturnValue
    public static <T extends AssertDelegateTarget> T assertThat(T assertion) {
        return assertion;
    }

    public static void useRepresentation(Representation customRepresentation) {
        AbstractAssert.setCustomRepresentation(customRepresentation);
    }

    public static <T> void registerFormatterForType(Class<T> type, Function<T, String> formatter) {
        StandardRepresentation.registerFormatterForType(type, formatter);
    }

    public static void useDefaultRepresentation() {
        StandardRepresentation.removeAllRegisteredFormatters();
        AbstractAssert.setCustomRepresentation(StandardRepresentation.STANDARD_REPRESENTATION);
    }

    protected Assertions() {
    }
}

