/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.OffsetDateTime;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualsTo;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.core.error.ShouldBeEqualIgnoringHours;
import org.assertj.core.error.ShouldBeEqualIgnoringMinutes;
import org.assertj.core.error.ShouldBeEqualIgnoringNanos;
import org.assertj.core.error.ShouldBeEqualIgnoringSeconds;
import org.assertj.core.error.ShouldBeEqualIgnoringTimezone;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;

public abstract class AbstractOffsetDateTimeAssert<S extends AbstractOffsetDateTimeAssert<S>>
extends AbstractAssert<S, OffsetDateTime> {
    public static final String NULL_OFFSET_DATE_TIME_PARAMETER_MESSAGE = "The OffsetDateTime to compare actual with should not be null";

    protected AbstractOffsetDateTimeAssert(OffsetDateTime actual, Class<?> selfType) {
        super(actual, selfType);
    }

    protected OffsetDateTime getActual() {
        return (OffsetDateTime)this.actual;
    }

    public S isBefore(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!((OffsetDateTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (S)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public S isBefore(String offsetDateTimeAsString) {
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeAsStringParameterIsNotNull(offsetDateTimeAsString);
        return this.isBefore(OffsetDateTime.parse(offsetDateTimeAsString));
    }

    public S isBeforeOrEqualTo(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (((OffsetDateTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return (S)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public S isBeforeOrEqualTo(String offsetDateTimeAsString) {
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeAsStringParameterIsNotNull(offsetDateTimeAsString);
        return this.isBeforeOrEqualTo(OffsetDateTime.parse(offsetDateTimeAsString));
    }

    public S isAfterOrEqualTo(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (((OffsetDateTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return (S)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public S isAfterOrEqualTo(String offsetDateTimeAsString) {
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeAsStringParameterIsNotNull(offsetDateTimeAsString);
        return this.isAfterOrEqualTo(OffsetDateTime.parse(offsetDateTimeAsString));
    }

    public S isAfter(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!((OffsetDateTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (S)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public S isAfter(String offsetDateTimeAsString) {
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeAsStringParameterIsNotNull(offsetDateTimeAsString);
        return this.isAfter(OffsetDateTime.parse(offsetDateTimeAsString));
    }

    public S isEqualTo(String dateTimeAsString) {
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (S)((AbstractOffsetDateTimeAssert)this.isEqualTo(OffsetDateTime.parse(dateTimeAsString)));
    }

    public S isNotEqualTo(String dateTimeAsString) {
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (S)((AbstractOffsetDateTimeAssert)this.isNotEqualTo(OffsetDateTime.parse(dateTimeAsString)));
    }

    public S isIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (S)((AbstractOffsetDateTimeAssert)this.isIn(AbstractOffsetDateTimeAssert.convertToOffsetDateTimeArray(dateTimesAsString)));
    }

    public S isNotIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (S)((AbstractOffsetDateTimeAssert)this.isNotIn(AbstractOffsetDateTimeAssert.convertToOffsetDateTimeArray(dateTimesAsString)));
    }

    public S isEqualToIgnoringNanos(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!AbstractOffsetDateTimeAssert.areEqualIgnoringNanos((OffsetDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringNanos.shouldBeEqualIgnoringNanos(this.actual, other));
        }
        return (S)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public S isEqualToIgnoringTimezone(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!AbstractOffsetDateTimeAssert.areEqualIgnoringTimezone((OffsetDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringTimezone.shouldBeEqualIgnoringTimezone((OffsetDateTime)this.actual, other));
        }
        return (S)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public S isEqualToIgnoringSeconds(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!AbstractOffsetDateTimeAssert.areEqualIgnoringSeconds((OffsetDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds(this.actual, other));
        }
        return (S)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public S isEqualToIgnoringMinutes(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!AbstractOffsetDateTimeAssert.areEqualIgnoringMinutes((OffsetDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMinutes.shouldBeEqualIgnoringMinutes(this.actual, other));
        }
        return (S)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public S isEqualToIgnoringHours(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!AbstractOffsetDateTimeAssert.haveSameYearMonthAndDayOfMonth((OffsetDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringHours.shouldBeEqualIgnoringHours(this.actual, other));
        }
        return (S)((AbstractOffsetDateTimeAssert)this.myself);
    }

    private static boolean areEqualIgnoringNanos(OffsetDateTime actual, OffsetDateTime other) {
        return AbstractOffsetDateTimeAssert.areEqualIgnoringSeconds(actual, other) && actual.getSecond() == other.getSecond();
    }

    private static boolean areEqualIgnoringSeconds(OffsetDateTime actual, OffsetDateTime other) {
        return AbstractOffsetDateTimeAssert.areEqualIgnoringMinutes(actual, other) && actual.getMinute() == other.getMinute();
    }

    private static boolean areEqualIgnoringMinutes(OffsetDateTime actual, OffsetDateTime other) {
        return AbstractOffsetDateTimeAssert.haveSameYearMonthAndDayOfMonth(actual, other) && actual.getHour() == other.getHour();
    }

    private static boolean haveSameYearMonthAndDayOfMonth(OffsetDateTime actual, OffsetDateTime other) {
        return AbstractOffsetDateTimeAssert.haveSameYearAndMonth(actual, other) && actual.getDayOfMonth() == other.getDayOfMonth();
    }

    private static boolean haveSameYearAndMonth(OffsetDateTime actual, OffsetDateTime other) {
        return AbstractOffsetDateTimeAssert.haveSameYear(actual, other) && actual.getMonth() == other.getMonth();
    }

    private static boolean haveSameYear(OffsetDateTime actual, OffsetDateTime other) {
        return actual.getYear() == other.getYear();
    }

    private static boolean areEqualIgnoringTimezone(OffsetDateTime actual, OffsetDateTime other) {
        return AbstractOffsetDateTimeAssert.areEqualIgnoringNanos(actual, other) && AbstractOffsetDateTimeAssert.haveSameNano(actual, other);
    }

    private static boolean haveSameNano(OffsetDateTime actual, OffsetDateTime other) {
        return actual.getNano() == other.getNano();
    }

    private static Object[] convertToOffsetDateTimeArray(String ... dateTimesAsString) {
        Object[] dates = new OffsetDateTime[dateTimesAsString.length];
        for (int i = 0; i < dateTimesAsString.length; ++i) {
            dates[i] = OffsetDateTime.parse(dateTimesAsString[i]);
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The given OffsetDateTime array should not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("The given OffsetDateTime array should not be empty");
        }
    }

    private static void assertOffsetDateTimeAsStringParameterIsNotNull(String offsetDateTimeAsString) {
        if (offsetDateTimeAsString == null) {
            throw new IllegalArgumentException("The String representing the OffsetDateTime to compare actual with should not be null");
        }
    }

    private static void assertOffsetDateTimeParameterIsNotNull(OffsetDateTime other) {
        if (other == null) {
            throw new IllegalArgumentException(NULL_OFFSET_DATE_TIME_PARAMETER_MESSAGE);
        }
    }
}

