/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.mimetype;

import com.twosigma.beakerx.mimetype.MIMEContainer;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SVGContainer
extends MIMEContainer {
    public SVGContainer(String mime, String code) {
        super(mime, code);
    }

    public static MIMEContainer SVG(Object data) throws Exception {
        String code = "";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = SVGContainer.validateData(data, builder);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        code = writer.getBuffer().toString().replaceAll("\n|\r", "");
        return SVGContainer.addMimeType("image/svg+xml", code);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Document validateData(Object data, DocumentBuilder builder) throws SAXException, IOException {
        if (!(data instanceof String)) return builder.parse(new ByteArrayInputStream((byte[])data));
        String path = data.toString();
        if (SVGContainer.isValidURL(path)) {
            return builder.parse(new URL(path).openStream());
        }
        if (!SVGContainer.exists(path)) throw new FileNotFoundException(path + " doesn't exist. ");
        return builder.parse(path);
    }
}

