/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.threads;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.ExecutionOptions;
import com.twosigma.beakerx.kernel.GroupName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class BeakerCellExecutor
implements CellExecutor {
    private static final int KILL_THREAD_SLEEP_IN_MILLIS = 2000;
    private static AtomicInteger count = new AtomicInteger();
    private final String prefix;
    private final ReentrantLock theLock;
    private ConcurrentLinkedQueue<ThreadGroup> threadGroups = new ConcurrentLinkedQueue();
    private int killThreadSleepInMillis;

    public BeakerCellExecutor(String prf, int killThreadSleepInMillis) {
        this.prefix = prf;
        this.theLock = new ReentrantLock();
        this.killThreadSleepInMillis = killThreadSleepInMillis;
        this.reset();
    }

    public BeakerCellExecutor(String prf) {
        this(prf, 2000);
    }

    private void reset() {
        this.theLock.lock();
        this.threadGroups = new ConcurrentLinkedQueue();
        this.theLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TryResult executeTask(Callable<TryResult> tsk, ExecutionOptions executionOptions) {
        FutureTask<TryResult> ret;
        try {
            this.theLock.lock();
            ret = this.executeTaskInNewThread(tsk, executionOptions.getGroupName());
        }
        catch (Throwable t) {
            t.printStackTrace();
            TryResult.CellError cellError = TryResult.createError(t.getMessage());
            return cellError;
        }
        finally {
            this.theLock.unlock();
        }
        return this.getResult(ret);
    }

    private TryResult getResult(FutureTask<TryResult> ret) {
        TryResult o;
        try {
            o = ret.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return TryResult.createError(e.getMessage());
        }
        if (ret.isCancelled()) {
            return TryResult.createError("Cancelled");
        }
        return o;
    }

    @NotNull
    private FutureTask<TryResult> executeTaskInNewThread(Callable<TryResult> tsk, GroupName groupName) {
        ThreadGroup threadGroup = new ThreadGroup(groupName + "_" + this.prefix + "TG" + count.getAndIncrement());
        this.threadGroups.add(threadGroup);
        FutureTask<TryResult> ret = new FutureTask<TryResult>(tsk);
        Thread t = new Thread(threadGroup, ret);
        t.start();
        return ret;
    }

    @Override
    public void cancelExecution(GroupName groupName) {
        try {
            this.theLock.lock();
            this.threadGroups.stream().filter(thg -> thg.getName().contains(groupName.asString())).forEach(thg -> {
                List<Thread> tlist = this.getThreadList((ThreadGroup)thg);
                for (Thread t : tlist) {
                    this.killThread(t);
                }
                this.threadGroups.remove(thg);
            });
        }
        finally {
            this.theLock.unlock();
        }
    }

    public List<Thread> getThreadList(ThreadGroup thrGroup) {
        Thread[] threads;
        int nAlloc = thrGroup.activeCount();
        if (nAlloc == 0) {
            return new ArrayList<Thread>();
        }
        int n = 0;
        while ((n = thrGroup.enumerate(threads = new Thread[nAlloc *= 2])) == nAlloc) {
        }
        return Arrays.asList(threads);
    }

    private void killThread(Thread thr) {
        if (null == thr) {
            return;
        }
        thr.interrupt();
        try {
            Thread.sleep(this.killThreadSleepInMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!thr.getState().equals((Object)Thread.State.TERMINATED)) {
            thr.stop();
        }
    }

    @Override
    public void killAllThreads() {
        try {
            this.theLock.lock();
            this.threadGroups.forEach(y -> {
                List<Thread> tlist = this.getThreadList((ThreadGroup)y);
                for (Thread t : tlist) {
                    this.killThread(t);
                }
            });
        }
        finally {
            this.theLock.unlock();
            this.reset();
        }
    }
}

